//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/access_loggers/stats/v3/stats.proto

package statsv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on Config with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Config) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Config with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in ConfigMultiError, or nil if none found.
func (m *Config) ValidateAll() error {
	return m.validate(true)
}

func (m *Config) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetStatPrefix()) < 1 {
		err := ConfigValidationError{
			field:  "StatPrefix",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetHistograms() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ConfigValidationError{
						field:  fmt.Sprintf("Histograms[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ConfigValidationError{
						field:  fmt.Sprintf("Histograms[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ConfigValidationError{
					field:  fmt.Sprintf("Histograms[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetCounters() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ConfigValidationError{
						field:  fmt.Sprintf("Counters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ConfigValidationError{
						field:  fmt.Sprintf("Counters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ConfigValidationError{
					field:  fmt.Sprintf("Counters[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return ConfigMultiError(errors)
	}

	return nil
}

// ConfigMultiError is an error wrapping multiple validation errors returned by
// Config.ValidateAll() if the designated constraints aren't met.
type ConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ConfigMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ConfigMultiError) AllErrors() []error { return m }

// ConfigValidationError is the validation error returned by Config.Validate if
// the designated constraints aren't met.
type ConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ConfigValidationError) ErrorName() string { return "ConfigValidationError" }

// Error satisfies the builtin error interface
func (e ConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ConfigValidationError{}

// Validate checks the field values on Config_Tag with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Config_Tag) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Config_Tag with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in Config_TagMultiError, or
// nil if none found.
func (m *Config_Tag) ValidateAll() error {
	return m.validate(true)
}

func (m *Config_Tag) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := Config_TagValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if utf8.RuneCountInString(m.GetValueFormat()) < 1 {
		err := Config_TagValidationError{
			field:  "ValueFormat",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return Config_TagMultiError(errors)
	}

	return nil
}

// Config_TagMultiError is an error wrapping multiple validation errors
// returned by Config_Tag.ValidateAll() if the designated constraints aren't met.
type Config_TagMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Config_TagMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Config_TagMultiError) AllErrors() []error { return m }

// Config_TagValidationError is the validation error returned by
// Config_Tag.Validate if the designated constraints aren't met.
type Config_TagValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Config_TagValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Config_TagValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Config_TagValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Config_TagValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Config_TagValidationError) ErrorName() string { return "Config_TagValidationError" }

// Error satisfies the builtin error interface
func (e Config_TagValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sConfig_Tag.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Config_TagValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Config_TagValidationError{}

// Validate checks the field values on Config_Stat with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Config_Stat) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Config_Stat with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in Config_StatMultiError, or
// nil if none found.
func (m *Config_Stat) ValidateAll() error {
	return m.validate(true)
}

func (m *Config_Stat) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := Config_StatValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetTags() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, Config_StatValidationError{
						field:  fmt.Sprintf("Tags[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, Config_StatValidationError{
						field:  fmt.Sprintf("Tags[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return Config_StatValidationError{
					field:  fmt.Sprintf("Tags[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return Config_StatMultiError(errors)
	}

	return nil
}

// Config_StatMultiError is an error wrapping multiple validation errors
// returned by Config_Stat.ValidateAll() if the designated constraints aren't met.
type Config_StatMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Config_StatMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Config_StatMultiError) AllErrors() []error { return m }

// Config_StatValidationError is the validation error returned by
// Config_Stat.Validate if the designated constraints aren't met.
type Config_StatValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Config_StatValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Config_StatValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Config_StatValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Config_StatValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Config_StatValidationError) ErrorName() string { return "Config_StatValidationError" }

// Error satisfies the builtin error interface
func (e Config_StatValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sConfig_Stat.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Config_StatValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Config_StatValidationError{}

// Validate checks the field values on Config_Histogram with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *Config_Histogram) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Config_Histogram with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// Config_HistogramMultiError, or nil if none found.
func (m *Config_Histogram) ValidateAll() error {
	return m.validate(true)
}

func (m *Config_Histogram) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetStat() == nil {
		err := Config_HistogramValidationError{
			field:  "Stat",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetStat()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Config_HistogramValidationError{
					field:  "Stat",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Config_HistogramValidationError{
					field:  "Stat",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetStat()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Config_HistogramValidationError{
				field:  "Stat",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if _, ok := Config_Histogram_Unit_name[int32(m.GetUnit())]; !ok {
		err := Config_HistogramValidationError{
			field:  "Unit",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if utf8.RuneCountInString(m.GetValueFormat()) < 1 {
		err := Config_HistogramValidationError{
			field:  "ValueFormat",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !strings.HasPrefix(m.GetValueFormat(), "%") {
		err := Config_HistogramValidationError{
			field:  "ValueFormat",
			reason: "value does not have prefix \"%\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !strings.HasSuffix(m.GetValueFormat(), "%") {
		err := Config_HistogramValidationError{
			field:  "ValueFormat",
			reason: "value does not have suffix \"%\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return Config_HistogramMultiError(errors)
	}

	return nil
}

// Config_HistogramMultiError is an error wrapping multiple validation errors
// returned by Config_Histogram.ValidateAll() if the designated constraints
// aren't met.
type Config_HistogramMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Config_HistogramMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Config_HistogramMultiError) AllErrors() []error { return m }

// Config_HistogramValidationError is the validation error returned by
// Config_Histogram.Validate if the designated constraints aren't met.
type Config_HistogramValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Config_HistogramValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Config_HistogramValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Config_HistogramValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Config_HistogramValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Config_HistogramValidationError) ErrorName() string { return "Config_HistogramValidationError" }

// Error satisfies the builtin error interface
func (e Config_HistogramValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sConfig_Histogram.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Config_HistogramValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Config_HistogramValidationError{}

// Validate checks the field values on Config_Counter with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Config_Counter) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Config_Counter with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in Config_CounterMultiError,
// or nil if none found.
func (m *Config_Counter) ValidateAll() error {
	return m.validate(true)
}

func (m *Config_Counter) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetStat() == nil {
		err := Config_CounterValidationError{
			field:  "Stat",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetStat()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Config_CounterValidationError{
					field:  "Stat",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Config_CounterValidationError{
					field:  "Stat",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetStat()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Config_CounterValidationError{
				field:  "Stat",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetValueFormat() != "" {

		if !strings.HasPrefix(m.GetValueFormat(), "%") {
			err := Config_CounterValidationError{
				field:  "ValueFormat",
				reason: "value does not have prefix \"%\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if !strings.HasSuffix(m.GetValueFormat(), "%") {
			err := Config_CounterValidationError{
				field:  "ValueFormat",
				reason: "value does not have suffix \"%\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if wrapper := m.GetValueFixed(); wrapper != nil {

		if wrapper.GetValue() <= 0 {
			err := Config_CounterValidationError{
				field:  "ValueFixed",
				reason: "value must be greater than 0",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return Config_CounterMultiError(errors)
	}

	return nil
}

// Config_CounterMultiError is an error wrapping multiple validation errors
// returned by Config_Counter.ValidateAll() if the designated constraints
// aren't met.
type Config_CounterMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Config_CounterMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Config_CounterMultiError) AllErrors() []error { return m }

// Config_CounterValidationError is the validation error returned by
// Config_Counter.Validate if the designated constraints aren't met.
type Config_CounterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Config_CounterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Config_CounterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Config_CounterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Config_CounterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Config_CounterValidationError) ErrorName() string { return "Config_CounterValidationError" }

// Error satisfies the builtin error interface
func (e Config_CounterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sConfig_Counter.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Config_CounterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Config_CounterValidationError{}
