#define XERR
#include "modules.ih"

bool Modules::checkCircular()
{
    Vect::iterator from = d_modules.begin();

    while (true)
    {
        Vect::iterator next =           // put the 0-dependent modules on top
                        partition(from, d_modules.end(), 
                            [&](Data const &data)
                            {
                                return data.imports.size() == 0;
                            }
                        );
        if (next == d_modules.end())        // all circular checks were passed
            break;

        if (from == next)                   // circ.deps: deps still exist
        {
            emsg << "can't compile module " << from->modName << 
                    ": circular or undefined module(s)\n";
            return false;
        }

        from = removeImports(from, next);   // remove the deps fm imports
    }                                       // and continue

    //at this point the least dependent modules are on top. Modules can
    // only depend on modules earlier in d_modules

    return true;
}

