/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_pfb_clock_sync_fff = R"doc(Timing synchronizer using polyphase filterbanks.

This block performs timing synchronization for PAM signals by minimizing the derivative of the filtered signal, which in turn maximizes the SNR and minimizes ISI.


This approach works by setting up two filterbanks; one filterbank contains the signal's pulse shaping matched filter (such as a root raised cosine filter), where each branch of the filterbank contains a different phase of the filter. The second filterbank contains the derivatives of the filters in the first filterbank. Thinking of this in the time domain, the first filterbank contains filters that have a sinc shape to them. We want to align the output signal to be sampled at exactly the peak of the sinc shape. The derivative of the sinc contains a zero at the maximum point of the sinc (sinc(0) = 1, sinc(0)' = 0). Furthermore, the region around the zero point is relatively linear. We make use of this fact to generate the error signal.


If the signal out of the derivative filters is d_i[n] for the ith filter, and the output of the matched filter is x_i[n], we calculate the error as: e[n] = (Re{x_i[n]} * Re{d_i[n]} + Im{x_i[n]} * Im{d_i[n]}) / 2.0 This equation averages the error in the real and imaginary parts. There are two reasons we multiply by the signal itself. First, if the symbol could be positive or negative going, but we want the error term to always tell us to go in the same direction depending on which side of the zero point we are on. The sign of x_i[n] adjusts the error term to do this. Second, the magnitude of x_i[n] scales the error term depending on the symbol's amplitude, so larger signals give us a stronger error term because we have more confidence in that symbol's value. Using the magnitude of x_i[n] instead of just the sign is especially good for signals with low SNR.


The error signal, e[n], gives us a value proportional to how far away from the zero point we are in the derivative signal. We want to drive this value to zero, so we set up a second order loop. We have two variables for this loop; d_k is the filter number in the filterbank we are on and d_rate is the rate which we travel through the filters in the steady state. That is, due to the natural clock differences between the transmitter and receiver, d_rate represents that difference and would traverse the filter phase paths to keep the receiver locked. Thinking of this as a second-order PLL, the d_rate is the frequency and d_k is the phase. So we update d_rate and d_k using the standard loop equations based on two error signals, d_alpha and d_beta. We have these two values set based on each other for a critically damped system, so in the block constructor, we just ask for \"gain,\" which is d_alpha while d_beta is equal to (gain^2)/4.


The block's parameters are:









Reference: f. j. harris and M. Rice, \"Multirate Digital Filters for Symbol
Timing Synchronization in Software Defined Radios\", IEEE Selected Areas in Communications, Vol. 19, No. 12, Dec., 2001.

Constructor Specific Documentation:

Build the polyphase filterbank timing synchronizer.

Args:
    sps : (double) The number of samples per second in the incoming signal
    gain : (float) The alpha gain of the control loop; beta = (gain^2)/4 by default.
    taps : (vector<int>) The filter taps.
    filter_size : (uint) The number of filters in the filterbank (default = 32).
    init_phase : (float) The initial phase to look at, or which filter to start with (default = 0).
    max_rate_deviation : (float) Distance from 0 d_rate can get (default = 1.5).
    osps : (int) The number of output samples per symbol (default=1).)doc";


static const char* __doc_gr_digital_pfb_clock_sync_fff_pfb_clock_sync_fff_0 = R"doc()doc";


static const char* __doc_gr_digital_pfb_clock_sync_fff_pfb_clock_sync_fff_1 = R"doc()doc";


static const char* __doc_gr_digital_pfb_clock_sync_fff_make = R"doc(Timing synchronizer using polyphase filterbanks.

This block performs timing synchronization for PAM signals by minimizing the derivative of the filtered signal, which in turn maximizes the SNR and minimizes ISI.


This approach works by setting up two filterbanks; one filterbank contains the signal's pulse shaping matched filter (such as a root raised cosine filter), where each branch of the filterbank contains a different phase of the filter. The second filterbank contains the derivatives of the filters in the first filterbank. Thinking of this in the time domain, the first filterbank contains filters that have a sinc shape to them. We want to align the output signal to be sampled at exactly the peak of the sinc shape. The derivative of the sinc contains a zero at the maximum point of the sinc (sinc(0) = 1, sinc(0)' = 0). Furthermore, the region around the zero point is relatively linear. We make use of this fact to generate the error signal.


If the signal out of the derivative filters is d_i[n] for the ith filter, and the output of the matched filter is x_i[n], we calculate the error as: e[n] = (Re{x_i[n]} * Re{d_i[n]} + Im{x_i[n]} * Im{d_i[n]}) / 2.0 This equation averages the error in the real and imaginary parts. There are two reasons we multiply by the signal itself. First, if the symbol could be positive or negative going, but we want the error term to always tell us to go in the same direction depending on which side of the zero point we are on. The sign of x_i[n] adjusts the error term to do this. Second, the magnitude of x_i[n] scales the error term depending on the symbol's amplitude, so larger signals give us a stronger error term because we have more confidence in that symbol's value. Using the magnitude of x_i[n] instead of just the sign is especially good for signals with low SNR.


The error signal, e[n], gives us a value proportional to how far away from the zero point we are in the derivative signal. We want to drive this value to zero, so we set up a second order loop. We have two variables for this loop; d_k is the filter number in the filterbank we are on and d_rate is the rate which we travel through the filters in the steady state. That is, due to the natural clock differences between the transmitter and receiver, d_rate represents that difference and would traverse the filter phase paths to keep the receiver locked. Thinking of this as a second-order PLL, the d_rate is the frequency and d_k is the phase. So we update d_rate and d_k using the standard loop equations based on two error signals, d_alpha and d_beta. We have these two values set based on each other for a critically damped system, so in the block constructor, we just ask for \"gain,\" which is d_alpha while d_beta is equal to (gain^2)/4.


The block's parameters are:









Reference: f. j. harris and M. Rice, \"Multirate Digital Filters for Symbol
Timing Synchronization in Software Defined Radios\", IEEE Selected Areas in Communications, Vol. 19, No. 12, Dec., 2001.

Constructor Specific Documentation:

Build the polyphase filterbank timing synchronizer.

Args:
    sps : (double) The number of samples per second in the incoming signal
    gain : (float) The alpha gain of the control loop; beta = (gain^2)/4 by default.
    taps : (vector<int>) The filter taps.
    filter_size : (uint) The number of filters in the filterbank (default = 32).
    init_phase : (float) The initial phase to look at, or which filter to start with (default = 0).
    max_rate_deviation : (float) Distance from 0 d_rate can get (default = 1.5).
    osps : (int) The number of output samples per symbol (default=1).)doc";


static const char* __doc_gr_digital_pfb_clock_sync_fff_update_gains = R"doc(update the system gains from omega and eta

This function updates the system gains based on the loop bandwidth and damping factor of the system. These two factors can be set separately through their own set functions.)doc";


static const char* __doc_gr_digital_pfb_clock_sync_fff_update_taps = R"doc(Resets the filterbank's filter taps with the new prototype filter.)doc";


static const char* __doc_gr_digital_pfb_clock_sync_fff_taps = R"doc(Returns all of the taps of the matched filter)doc";


static const char* __doc_gr_digital_pfb_clock_sync_fff_diff_taps = R"doc(Returns all of the taps of the derivative filter)doc";


static const char* __doc_gr_digital_pfb_clock_sync_fff_channel_taps = R"doc(Returns the taps of the matched filter for a particular channel)doc";


static const char* __doc_gr_digital_pfb_clock_sync_fff_diff_channel_taps = R"doc(Returns the taps in the derivative filter for a particular channel)doc";


static const char* __doc_gr_digital_pfb_clock_sync_fff_taps_as_string = R"doc(Return the taps as a formatted string for printing)doc";


static const char* __doc_gr_digital_pfb_clock_sync_fff_diff_taps_as_string = R"doc(Return the derivative filter taps as a formatted string for printing)doc";


static const char* __doc_gr_digital_pfb_clock_sync_fff_set_loop_bandwidth = R"doc(Set the loop bandwidth.

Set the loop filter's bandwidth to . This should be between 2*pi/200 and 2*pi/100 (in rads/samp). It must also be a positive number.


When a new damping factor is set, the gains, alpha and beta, of the loop are recalculated by a call to update_gains().)doc";


static const char* __doc_gr_digital_pfb_clock_sync_fff_set_damping_factor = R"doc(Set the loop damping factor.

Set the loop filter's damping factor to . The damping factor should be sqrt(2)/2.0 for critically damped systems. Set it to anything else only if you know what you are doing. It must be a number between 0 and 1.


When a new damping factor is set, the gains, alpha and beta, of the loop are recalculated by a call to update_gains().)doc";


static const char* __doc_gr_digital_pfb_clock_sync_fff_set_alpha = R"doc(Set the loop gain alpha.

Set's the loop filter's alpha gain parameter.


This value should really only be set by adjusting the loop bandwidth and damping factor.)doc";


static const char* __doc_gr_digital_pfb_clock_sync_fff_set_beta = R"doc(Set the loop gain beta.

Set's the loop filter's beta gain parameter.


This value should really only be set by adjusting the loop bandwidth and damping factor.)doc";


static const char* __doc_gr_digital_pfb_clock_sync_fff_set_max_rate_deviation =
    R"doc()doc";


static const char* __doc_gr_digital_pfb_clock_sync_fff_loop_bandwidth = R"doc(Returns the loop bandwidth.)doc";


static const char* __doc_gr_digital_pfb_clock_sync_fff_damping_factor = R"doc(Returns the loop damping factor.)doc";


static const char* __doc_gr_digital_pfb_clock_sync_fff_alpha = R"doc(Returns the loop gain alpha.)doc";


static const char* __doc_gr_digital_pfb_clock_sync_fff_beta = R"doc(Returns the loop gain beta.)doc";


static const char* __doc_gr_digital_pfb_clock_sync_fff_clock_rate = R"doc(Returns the current clock rate.)doc";
