/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_vector_map = R"doc(Maps elements from a set of input vectors to a set of output vectors.

If in[i] is the input vector in the i'th stream then the output vector in the j'th stream is:


out[j][k] = in[mapping[j][k][0]][mapping[j][k][1]]


That is mapping is of the form (out_stream1_mapping, out_stream2_mapping, ...) and out_stream1_mapping is of the form (element1_mapping, element2_mapping, ...) and element1_mapping is of the form (in_stream, in_element).

Constructor Specific Documentation:

Build a vector map block.

Args:
    item_size : (integer) size of vector elements
    in_vlens : (vector of integers) number of elements in each input vector
    mapping : (vector of vectors of vectors of integers) how to map elements from input to output vectors)doc";


static const char* __doc_gr_blocks_vector_map_vector_map_0 = R"doc()doc";


static const char* __doc_gr_blocks_vector_map_vector_map_1 = R"doc()doc";


static const char* __doc_gr_blocks_vector_map_make = R"doc(Maps elements from a set of input vectors to a set of output vectors.

If in[i] is the input vector in the i'th stream then the output vector in the j'th stream is:


out[j][k] = in[mapping[j][k][0]][mapping[j][k][1]]


That is mapping is of the form (out_stream1_mapping, out_stream2_mapping, ...) and out_stream1_mapping is of the form (element1_mapping, element2_mapping, ...) and element1_mapping is of the form (in_stream, in_element).

Constructor Specific Documentation:

Build a vector map block.

Args:
    item_size : (integer) size of vector elements
    in_vlens : (vector of integers) number of elements in each input vector
    mapping : (vector of vectors of vectors of integers) how to map elements from input to output vectors)doc";


static const char* __doc_gr_blocks_vector_map_set_mapping = R"doc()doc";
