/* gitg-hook.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-hook.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2013 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include "libgitg/gitg-platform-support.h"
#include <libgit2-glib/ggit.h>

#define GITG_HOOK_CONFIG_HOOKS_PATH "core.hooksPath"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GITG_HOOK_0_PROPERTY,
	GITG_HOOK_ENVIRONMENT_PROPERTY,
	GITG_HOOK_NAME_PROPERTY,
	GITG_HOOK_WORKING_DIRECTORY_PROPERTY,
	GITG_HOOK_OUTPUT_PROPERTY,
	GITG_HOOK_NUM_PROPERTIES
};
static GParamSpec* gitg_hook_properties[GITG_HOOK_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block18Data Block18Data;
typedef struct _Block19Data Block19Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _Block20Data Block20Data;
typedef struct _GitgHookRunData GitgHookRunData;

struct _GitgHookPrivate {
	GeeHashMap* _environment;
	gchar* _name;
	gchar** d_arguments;
	gint d_arguments_length1;
	gint _d_arguments_size_;
	GFile* _working_directory;
	gchar** d_output;
	gint d_output_length1;
	gint _d_output_size_;
};

struct _Block18Data {
	int _ref_count_;
	GitgHook* self;
	GDataInputStream* stream;
};

struct _Block19Data {
	int _ref_count_;
	GitgHook* self;
	GMainLoop* m;
	GError* e;
	gint status;
};

struct _Block20Data {
	int _ref_count_;
	GitgHook* self;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	gint status;
	gpointer _async_data_;
};

struct _GitgHookRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgHook* self;
	GgitRepository* repository;
	gint result;
	Block20Data* _data20_;
	gchar** _tmp0_;
	GFile* wd;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* script;
	GFile* _tmp5_;
	gchar** args;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint args_length1;
	gint _args_size_;
	GFile* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar** a_collection;
	gint a_collection_length1;
	gint _a_collection_size_;
	gint a_it;
	gchar* _tmp11_;
	gchar* a;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** env;
	gint _tmp14_;
	gchar** _tmp15_;
	gint env_length1;
	gint _env_size_;
	GPid pid;
	gint pstdout;
	gint pstderr;
	GFile* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	GPid _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GError* _inner_error0_;
};

static gint GitgHook_private_offset;
static gpointer gitg_hook_parent_class = NULL;

static void _vala_array_add8 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gchar** gitg_hook_flat_environment (GitgHook* self,
                                    gint* result_length1);
static void _vala_array_add9 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add10 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void gitg_hook_stream_read_async (GitgHook* self,
                                  GDataInputStream* stream);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static void __lambda12_ (Block18Data* _data18_,
                  GObject* obj,
                  GAsyncResult* res);
static void _vala_array_add11 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void ___lambda12__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void gitg_hook_read_from_fd (GitgHook* self,
                             gint fd);
static GFile* gitg_hook_hook_file (GitgHook* self,
                            GgitRepository* repository);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
static void __lambda14_ (Block19Data* _data19_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda14__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void gitg_hook_run_data_free (gpointer _data);
static gboolean gitg_hook_run_co (GitgHookRunData* _data_);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static gboolean _gitg_hook_run_co_gsource_func (gpointer self);
static void _vala_array_add12 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add13 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void __lambda13_ (Block20Data* _data20_,
                  GPid p,
                  gint st);
static void ___lambda13__gchild_watch_func (GPid pid,
                                     gint wait_status,
                                     gpointer self);
static gchar** _vala_array_dup16 (gchar** self,
                           gssize length);
static GObject * gitg_hook_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties);
static void gitg_hook_finalize (GObject * obj);
static GType gitg_hook_get_type_once (void);
static void _vala_gitg_hook_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_gitg_hook_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
gitg_hook_get_instance_private (GitgHook* self)
{
	return G_STRUCT_MEMBER_P (self, GitgHook_private_offset);
}

GitgHook*
gitg_hook_construct (GType object_type,
                     const gchar* name)
{
	GitgHook * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (GitgHook*) g_object_new (object_type, "name", name, NULL);
	return self;
}

GitgHook*
gitg_hook_new (const gchar* name)
{
	return gitg_hook_construct (GITG_TYPE_HOOK, name);
}

static void
_vala_array_add8 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
gitg_hook_add_argument (GitgHook* self,
                        const gchar* arg)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = g_strdup (arg);
	_vala_array_add8 (&self->priv->d_arguments, &self->priv->d_arguments_length1, &self->priv->_d_arguments_size_, _tmp0_);
}

static void
_vala_array_add9 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add10 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
gitg_hook_flat_environment (GitgHook* self,
                            gint* result_length1)
{
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar** env = NULL;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint env_length1;
	gint _env_size_;
	gchar** ret = NULL;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GeeHashMap* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gchar** _tmp10_;
	gint ret_length1;
	gint _ret_size_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar** _tmp34_;
	gint _tmp34__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_environment;
	_tmp1_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = NULL;
		_tmp3__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp3__length1;
		}
		result = _tmp3_;
		return result;
	}
	_tmp5_ = _tmp4_ = g_listenv ();
	env = _tmp5_;
	env_length1 = _vala_array_length (_tmp4_);
	_env_size_ = env_length1;
	_tmp6_ = env;
	_tmp6__length1 = env_length1;
	_tmp7_ = self->priv->_environment;
	_tmp8_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_new0 (gchar*, (_tmp6__length1 + _tmp9_) + 1);
	ret = _tmp10_;
	ret_length1 = _tmp6__length1 + _tmp9_;
	_ret_size_ = ret_length1;
	ret_length1 = 0;
	_tmp11_ = env;
	_tmp11__length1 = env_length1;
	{
		gchar** e_collection = NULL;
		gint e_collection_length1 = 0;
		gint _e_collection_size_ = 0;
		gint e_it = 0;
		e_collection = _tmp11_;
		e_collection_length1 = _tmp11__length1;
		for (e_it = 0; e_it < e_collection_length1; e_it = e_it + 1) {
			gchar* _tmp12_;
			gchar* e = NULL;
			_tmp12_ = g_strdup (e_collection[e_it]);
			e = _tmp12_;
			{
				GeeHashMap* _tmp13_;
				const gchar* _tmp14_;
				_tmp13_ = self->priv->_environment;
				_tmp14_ = e;
				if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp13_, _tmp14_)) {
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp15_ = e;
					_tmp16_ = e;
					_tmp17_ = g_getenv (_tmp16_);
					_tmp18_ = g_strdup_printf ("%s=%s", _tmp15_, _tmp17_);
					_vala_array_add9 (&ret, &ret_length1, &_ret_size_, _tmp18_);
				}
				_g_free0 (e);
			}
		}
	}
	{
		GeeIterator* _e_it = NULL;
		GeeHashMap* _tmp19_;
		GeeSet* _tmp20_;
		GeeSet* _tmp21_;
		GeeSet* _tmp22_;
		GeeIterator* _tmp23_;
		GeeIterator* _tmp24_;
		_tmp19_ = self->priv->_environment;
		_tmp20_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _tmp21_;
		_tmp23_ = gee_iterable_iterator ((GeeIterable*) _tmp22_);
		_tmp24_ = _tmp23_;
		_g_object_unref0 (_tmp22_);
		_e_it = _tmp24_;
		while (TRUE) {
			GeeIterator* _tmp25_;
			gchar* e = NULL;
			GeeIterator* _tmp26_;
			gpointer _tmp27_;
			const gchar* _tmp28_;
			GeeHashMap* _tmp29_;
			const gchar* _tmp30_;
			gpointer _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			_tmp25_ = _e_it;
			if (!gee_iterator_next (_tmp25_)) {
				break;
			}
			_tmp26_ = _e_it;
			_tmp27_ = gee_iterator_get (_tmp26_);
			e = (gchar*) _tmp27_;
			_tmp28_ = e;
			_tmp29_ = self->priv->_environment;
			_tmp30_ = e;
			_tmp31_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp29_, _tmp30_);
			_tmp32_ = (gchar*) _tmp31_;
			_tmp33_ = g_strdup_printf ("%s=%s", _tmp28_, _tmp32_);
			_vala_array_add10 (&ret, &ret_length1, &_ret_size_, _tmp33_);
			_g_free0 (_tmp32_);
			_g_free0 (e);
		}
		_g_object_unref0 (_e_it);
	}
	_tmp34_ = ret;
	_tmp34__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp34__length1;
	}
	result = _tmp34_;
	env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		GitgHook* self;
		self = _data18_->self;
		_g_object_unref0 (_data18_->stream);
		_g_object_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}

static void
_vala_array_add11 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
__lambda12_ (Block18Data* _data18_,
             GObject* obj,
             GAsyncResult* res)
{
	GitgHook* self;
	GError* _inner_error0_ = NULL;
	self = _data18_->self;
	g_return_if_fail (res != NULL);
	{
		gchar* s = NULL;
		gchar* _tmp0_;
		_tmp0_ = g_data_input_stream_read_line_finish (_data18_->stream, res, NULL, &_inner_error0_);
		s = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (s != NULL) {
			if (g_utf8_validate (s, (gssize) -1, NULL)) {
				gchar* _tmp1_;
				_tmp1_ = g_strdup (s);
				_vala_array_add11 (&self->priv->d_output, &self->priv->d_output_length1, &self->priv->_d_output_size_, _tmp1_);
			}
			gitg_hook_stream_read_async (self, _data18_->stream);
		}
		_g_free0 (s);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda12__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda12_ (self, source_object, res);
	block18_data_unref (self);
}

static void
gitg_hook_stream_read_async (GitgHook* self,
                             GDataInputStream* stream)
{
	Block18Data* _data18_;
	GDataInputStream* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stream != NULL);
	_data18_ = g_slice_new0 (Block18Data);
	_data18_->_ref_count_ = 1;
	_data18_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (stream);
	_g_object_unref0 (_data18_->stream);
	_data18_->stream = _tmp0_;
	g_data_input_stream_read_line_async (_data18_->stream, G_PRIORITY_HIGH_IDLE, NULL, ___lambda12__gasync_ready_callback, block18_data_ref (_data18_));
	block18_data_unref (_data18_);
	_data18_ = NULL;
}

static void
gitg_hook_read_from_fd (GitgHook* self,
                        gint fd)
{
	GInputStream* stream = NULL;
	GInputStream* _tmp0_;
	GDataInputStream* dstream = NULL;
	GDataInputStream* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gitg_platform_support_new_input_stream_from_fd (fd, TRUE);
	stream = _tmp0_;
	_tmp1_ = g_data_input_stream_new (stream);
	dstream = _tmp1_;
	gitg_hook_stream_read_async (self, dstream);
	_g_object_unref0 (dstream);
	_g_object_unref0 (stream);
}

static GFile*
gitg_hook_hook_file (GitgHook* self,
                     GgitRepository* repository)
{
	GgitConfig* _tmp0_ = NULL;
	GgitConfig* _tmp1_;
	GgitConfig* config = NULL;
	GgitConfig* _tmp2_;
	gchar* hooks_path = NULL;
	GFile* hooksdir = NULL;
	const gchar* _tmp12_;
	GFile* _tmp13_;
	GFile* script = NULL;
	GFile* _tmp14_;
	const gchar* _tmp15_;
	GFile* _tmp16_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (repository != NULL, NULL);
	_tmp1_ = ggit_repository_get_config (repository, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp2_ = ggit_config_snapshot (_tmp0_, &_inner_error0_);
	config = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (_tmp0_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	hooks_path = NULL;
	{
		const gchar* _tmp3_ = NULL;
		GgitConfig* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = config;
		_tmp5_ = ggit_config_get_string (_tmp4_, GITG_HOOK_CONFIG_HOOKS_PATH, &_inner_error0_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = g_strdup (_tmp3_);
		_g_free0 (hooks_path);
		hooks_path = _tmp6_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GFile* _tmp7_;
		GFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		g_clear_error (&_inner_error0_);
		_tmp7_ = ggit_repository_get_location (repository);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_file_get_path (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup_printf ("%s/hooks", _tmp10_);
		_g_free0 (hooks_path);
		hooks_path = _tmp11_;
		_g_free0 (_tmp10_);
		_g_object_unref0 (_tmp8_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (hooks_path);
		_g_object_unref0 (config);
		_g_object_unref0 (_tmp0_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp12_ = hooks_path;
	_tmp13_ = g_file_new_for_path (_tmp12_);
	hooksdir = _tmp13_;
	_tmp14_ = hooksdir;
	_tmp15_ = self->priv->_name;
	_tmp16_ = g_file_resolve_relative_path (_tmp14_, _tmp15_);
	script = _tmp16_;
	result = script;
	_g_object_unref0 (hooksdir);
	_g_free0 (hooks_path);
	_g_object_unref0 (config);
	_g_object_unref0 (_tmp0_);
	return result;
}

gboolean
gitg_hook_exists_in (GitgHook* self,
                     GgitRepository* repository)
{
	GFile* script = NULL;
	GFile* _tmp0_;
	gboolean _tmp2_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (repository != NULL, FALSE);
	_tmp0_ = gitg_hook_hook_file (self, repository);
	script = _tmp0_;
	{
		GFileInfo* info = NULL;
		GFileInfo* _tmp1_;
		_tmp1_ = g_file_query_info (script, G_FILE_ATTRIBUTE_ACCESS_CAN_EXECUTE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		info = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = g_file_info_get_attribute_boolean (info, G_FILE_ATTRIBUTE_ACCESS_CAN_EXECUTE);
		_g_object_unref0 (info);
		_g_object_unref0 (script);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		_g_object_unref0 (script);
		return result;
	}
	__finally0:
	_g_object_unref0 (script);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp2_;
}

static Block19Data*
block19_data_ref (Block19Data* _data19_)
{
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}

static void
block19_data_unref (void * _userdata_)
{
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		GitgHook* self;
		self = _data19_->self;
		_g_error_free0 (_data19_->e);
		_g_main_loop_unref0 (_data19_->m);
		_g_object_unref0 (self);
		g_slice_free (Block19Data, _data19_);
	}
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
__lambda14_ (Block19Data* _data19_,
             GObject* obj,
             GAsyncResult* res)
{
	GitgHook* self;
	GMainLoop* _tmp3_;
	GError* _inner_error0_ = NULL;
	self = _data19_->self;
	g_return_if_fail (res != NULL);
	{
		gint _tmp0_ = 0;
		_tmp0_ = gitg_hook_run_finish (self, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_data19_->status = _tmp0_;
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* err = NULL;
		GError* _tmp1_;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = err;
		_tmp2_ = _g_error_copy0 (_tmp1_);
		_g_error_free0 (_data19_->e);
		_data19_->e = _tmp2_;
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp3_ = _data19_->m;
	g_main_loop_quit (_tmp3_);
}

static void
___lambda14__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda14_ (self, source_object, res);
	block19_data_unref (self);
}

gint
gitg_hook_run_sync (GitgHook* self,
                    GgitRepository* repository,
                    GError** error)
{
	Block19Data* _data19_;
	GMainLoop* _tmp0_;
	GMainLoop* _tmp1_;
	GError* _tmp2_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (repository != NULL, 0);
	_data19_ = g_slice_new0 (Block19Data);
	_data19_->_ref_count_ = 1;
	_data19_->self = g_object_ref (self);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_data19_->m = _tmp0_;
	_data19_->e = NULL;
	_data19_->status = 0;
	gitg_hook_run (self, repository, ___lambda14__gasync_ready_callback, block19_data_ref (_data19_));
	_tmp1_ = _data19_->m;
	g_main_loop_run (_tmp1_);
	_tmp2_ = _data19_->e;
	if (_tmp2_ != NULL) {
		GError* _tmp3_;
		GError* _tmp4_;
		_tmp3_ = _data19_->e;
		_tmp4_ = _g_error_copy0 (_tmp3_);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == G_SPAWN_ERROR) {
			gint _tmp5_ = -1;
			g_propagate_error (error, _inner_error0_);
			block19_data_unref (_data19_);
			_data19_ = NULL;
			return _tmp5_;
		} else {
			gint _tmp6_ = -1;
			block19_data_unref (_data19_);
			_data19_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
	}
	result = _data19_->status;
	block19_data_unref (_data19_);
	_data19_ = NULL;
	return result;
}

static void
gitg_hook_run_data_free (gpointer _data)
{
	GitgHookRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->repository);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgHookRunData, _data_);
}

void
gitg_hook_run (GitgHook* self,
               GgitRepository* repository,
               GAsyncReadyCallback _callback_,
               gpointer _user_data_)
{
	GitgHookRunData* _data_;
	GitgHook* _tmp0_;
	GgitRepository* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (repository != NULL);
	_data_ = g_slice_new0 (GitgHookRunData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_hook_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (repository);
	_g_object_unref0 (_data_->repository);
	_data_->repository = _tmp1_;
	gitg_hook_run_co (_data_);
}

gint
gitg_hook_run_finish (GitgHook* self,
                      GAsyncResult* _res_,
                      GError** error)
{
	gint result;
	GitgHookRunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gint _tmp0_ = 0;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		GitgHook* self;
		self = _data20_->self;
		(_data20_->callback_target_destroy_notify == NULL) ? NULL : (_data20_->callback_target_destroy_notify (_data20_->callback_target), NULL);
		_data20_->callback = NULL;
		_data20_->callback_target = NULL;
		_data20_->callback_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block20Data, _data20_);
	}
}

static gboolean
_gitg_hook_run_co_gsource_func (gpointer self)
{
	gboolean result;
	result = gitg_hook_run_co (self);
	return result;
}

static void
_vala_array_add12 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add13 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
__lambda13_ (Block20Data* _data20_,
             GPid p,
             gint st)
{
	GitgHook* self;
	GSourceFunc _tmp0_;
	gpointer _tmp0__target;
	self = _data20_->self;
	_data20_->status = st;
	g_spawn_close_pid (p);
	_tmp0_ = _data20_->callback;
	_tmp0__target = _data20_->callback_target;
	_tmp0_ (_tmp0__target);
}

static void
___lambda13__gchild_watch_func (GPid pid,
                                gint wait_status,
                                gpointer self)
{
	__lambda13_ (self, pid, wait_status);
}

static gboolean
gitg_hook_run_co (GitgHookRunData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data20_ = g_slice_new0 (Block20Data);
	_data_->_data20_->_ref_count_ = 1;
	_data_->_data20_->self = g_object_ref (_data_->self);
	_data_->_data20_->_async_data_ = _data_;
	_data_->_data20_->callback = _gitg_hook_run_co_gsource_func;
	_data_->_data20_->callback_target = _data_;
	_data_->_data20_->callback_target_destroy_notify = NULL;
	_data_->_tmp0_ = g_new0 (gchar*, 256 + 1);
	_data_->self->priv->d_output = (_vala_array_free (_data_->self->priv->d_output, _data_->self->priv->d_output_length1, (GDestroyNotify) g_free), NULL);
	_data_->self->priv->d_output = _data_->_tmp0_;
	_data_->self->priv->d_output_length1 = 256;
	_data_->self->priv->_d_output_size_ = _data_->self->priv->d_output_length1;
	_data_->self->priv->d_output_length1 = 0;
	_data_->_tmp1_ = _data_->self->priv->_working_directory;
	if (_data_->_tmp1_ == NULL) {
		_data_->_tmp2_ = _data_->self->priv->_working_directory;
		_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
		_g_object_unref0 (_data_->wd);
		_data_->wd = _data_->_tmp3_;
	} else {
		_data_->_tmp4_ = ggit_repository_get_workdir (_data_->repository);
		_g_object_unref0 (_data_->wd);
		_data_->wd = _data_->_tmp4_;
	}
	_data_->_tmp5_ = gitg_hook_hook_file (_data_->self, _data_->repository);
	_data_->script = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->self->priv->d_arguments;
	_data_->_tmp6__length1 = _data_->self->priv->d_arguments_length1;
	_data_->_tmp7_ = g_new0 (gchar*, (_data_->_tmp6__length1 + 1) + 1);
	_data_->args = _data_->_tmp7_;
	_data_->args_length1 = _data_->_tmp6__length1 + 1;
	_data_->_args_size_ = _data_->args_length1;
	_data_->args_length1 = 0;
	_data_->_tmp8_ = _data_->script;
	_data_->_tmp9_ = g_file_get_path (_data_->_tmp8_);
	_vala_array_add12 (&_data_->args, &_data_->args_length1, &_data_->_args_size_, _data_->_tmp9_);
	_data_->_tmp10_ = _data_->self->priv->d_arguments;
	_data_->_tmp10__length1 = _data_->self->priv->d_arguments_length1;
	{
		_data_->a_collection_length1 = 0;
		_data_->_a_collection_size_ = 0;
		_data_->a_collection = _data_->_tmp10_;
		_data_->a_collection_length1 = _data_->_tmp10__length1;
		for (_data_->a_it = 0; _data_->a_it < _data_->a_collection_length1; _data_->a_it = _data_->a_it + 1) {
			_data_->_tmp11_ = g_strdup (_data_->a_collection[_data_->a_it]);
			_data_->a = _data_->_tmp11_;
			{
				_data_->_tmp12_ = _data_->a;
				_data_->_tmp13_ = g_strdup (_data_->_tmp12_);
				_vala_array_add13 (&_data_->args, &_data_->args_length1, &_data_->_args_size_, _data_->_tmp13_);
				_g_free0 (_data_->a);
			}
		}
	}
	_data_->_tmp14_ = 0;
	_data_->_tmp15_ = gitg_hook_flat_environment (_data_->self, &_data_->_tmp14_);
	_data_->env = _data_->_tmp15_;
	_data_->env_length1 = _data_->_tmp14_;
	_data_->_env_size_ = _data_->env_length1;
	_data_->_tmp16_ = _data_->wd;
	_data_->_tmp17_ = g_file_get_path (_data_->_tmp16_);
	_data_->_tmp18_ = _data_->_tmp17_;
	_data_->_tmp19_ = _data_->args;
	_data_->_tmp19__length1 = _data_->args_length1;
	_data_->_tmp20_ = 0;
	_data_->_tmp21_ = 0;
	_data_->_tmp22_ = 0;
	g_spawn_async_with_pipes (_data_->_tmp18_, _data_->_tmp19_, _data_->env, G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_data_->_tmp20_, NULL, &_data_->_tmp21_, &_data_->_tmp22_, &_data_->_inner_error0_);
	_data_->pid = _data_->_tmp20_;
	_data_->pstdout = _data_->_tmp21_;
	_data_->pstderr = _data_->_tmp22_;
	_g_free0 (_data_->_tmp18_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == G_SPAWN_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_data_->env = (_vala_array_free (_data_->env, _data_->env_length1, (GDestroyNotify) g_free), NULL);
			_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->script);
			_g_object_unref0 (_data_->wd);
			block20_data_unref (_data_->_data20_);
			_data_->_data20_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_data_->env = (_vala_array_free (_data_->env, _data_->env_length1, (GDestroyNotify) g_free), NULL);
			_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->script);
			_g_object_unref0 (_data_->wd);
			block20_data_unref (_data_->_data20_);
			_data_->_data20_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	gitg_hook_read_from_fd (_data_->self, _data_->pstdout);
	gitg_hook_read_from_fd (_data_->self, _data_->pstderr);
	_data_->_data20_->status = 0;
	g_child_watch_add_full (G_PRIORITY_LOW, _data_->pid, ___lambda13__gchild_watch_func, block20_data_ref (_data_->_data20_), block20_data_unref);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->result = _data_->_data20_->status;
	_data_->env = (_vala_array_free (_data_->env, _data_->env_length1, (GDestroyNotify) g_free), NULL);
	_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->script);
	_g_object_unref0 (_data_->wd);
	block20_data_unref (_data_->_data20_);
	_data_->_data20_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

GeeHashMap*
gitg_hook_get_environment (GitgHook* self)
{
	GeeHashMap* result;
	GeeHashMap* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_environment;
	result = _tmp0_;
	return result;
}

void
gitg_hook_set_environment (GitgHook* self,
                           GeeHashMap* value)
{
	GeeHashMap* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_hook_get_environment (self);
	if (old_value != value) {
		GeeHashMap* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_environment);
		self->priv->_environment = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_hook_properties[GITG_HOOK_ENVIRONMENT_PROPERTY]);
	}
}

const gchar*
gitg_hook_get_name (GitgHook* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

void
gitg_hook_set_name (GitgHook* self,
                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_hook_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_hook_properties[GITG_HOOK_NAME_PROPERTY]);
	}
}

GFile*
gitg_hook_get_working_directory (GitgHook* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_working_directory;
	result = _tmp0_;
	return result;
}

void
gitg_hook_set_working_directory (GitgHook* self,
                                 GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_hook_get_working_directory (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_working_directory);
		self->priv->_working_directory = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_hook_properties[GITG_HOOK_WORKING_DIRECTORY_PROPERTY]);
	}
}

static gchar**
_vala_array_dup16 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

gchar**
gitg_hook_get_output (GitgHook* self,
                      gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_output;
	_tmp0__length1 = self->priv->d_output_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup16 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static GObject *
gitg_hook_constructor (GType type,
                       guint n_construct_properties,
                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GitgHook * self;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	parent_class = G_OBJECT_CLASS (gitg_hook_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_HOOK, GitgHook);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	gitg_hook_set_environment (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	return obj;
}

static void
gitg_hook_class_init (GitgHookClass * klass,
                      gpointer klass_data)
{
	gitg_hook_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgHook_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_hook_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_hook_set_property;
	G_OBJECT_CLASS (klass)->constructor = gitg_hook_constructor;
	G_OBJECT_CLASS (klass)->finalize = gitg_hook_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HOOK_ENVIRONMENT_PROPERTY, gitg_hook_properties[GITG_HOOK_ENVIRONMENT_PROPERTY] = g_param_spec_object ("environment", "environment", "environment", GEE_TYPE_HASH_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HOOK_NAME_PROPERTY, gitg_hook_properties[GITG_HOOK_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HOOK_WORKING_DIRECTORY_PROPERTY, gitg_hook_properties[GITG_HOOK_WORKING_DIRECTORY_PROPERTY] = g_param_spec_object ("working-directory", "working-directory", "working-directory", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HOOK_OUTPUT_PROPERTY, gitg_hook_properties[GITG_HOOK_OUTPUT_PROPERTY] = g_param_spec_boxed ("output", "output", "output", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gitg_hook_instance_init (GitgHook * self,
                         gpointer klass)
{
	self->priv = gitg_hook_get_instance_private (self);
}

static void
gitg_hook_finalize (GObject * obj)
{
	GitgHook * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_HOOK, GitgHook);
	_g_object_unref0 (self->priv->_environment);
	_g_free0 (self->priv->_name);
	self->priv->d_arguments = (_vala_array_free (self->priv->d_arguments, self->priv->d_arguments_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_working_directory);
	self->priv->d_output = (_vala_array_free (self->priv->d_output, self->priv->d_output_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (gitg_hook_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_hook_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgHookClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_hook_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgHook), 0, (GInstanceInitFunc) gitg_hook_instance_init, NULL };
	GType gitg_hook_type_id;
	gitg_hook_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgHook", &g_define_type_info, 0);
	GitgHook_private_offset = g_type_add_instance_private (gitg_hook_type_id, sizeof (GitgHookPrivate));
	return gitg_hook_type_id;
}

GType
gitg_hook_get_type (void)
{
	static gsize gitg_hook_type_id__once = 0;
	if (g_once_init_enter (&gitg_hook_type_id__once)) {
		GType gitg_hook_type_id;
		gitg_hook_type_id = gitg_hook_get_type_once ();
		g_once_init_leave (&gitg_hook_type_id__once, gitg_hook_type_id);
	}
	return gitg_hook_type_id__once;
}

static void
_vala_gitg_hook_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	GitgHook * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_HOOK, GitgHook);
	switch (property_id) {
		case GITG_HOOK_ENVIRONMENT_PROPERTY:
		g_value_set_object (value, gitg_hook_get_environment (self));
		break;
		case GITG_HOOK_NAME_PROPERTY:
		g_value_set_string (value, gitg_hook_get_name (self));
		break;
		case GITG_HOOK_WORKING_DIRECTORY_PROPERTY:
		g_value_set_object (value, gitg_hook_get_working_directory (self));
		break;
		case GITG_HOOK_OUTPUT_PROPERTY:
		{
			int length;
			g_value_take_boxed (value, gitg_hook_get_output (self, &length));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_hook_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	GitgHook * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_HOOK, GitgHook);
	switch (property_id) {
		case GITG_HOOK_ENVIRONMENT_PROPERTY:
		gitg_hook_set_environment (self, g_value_get_object (value));
		break;
		case GITG_HOOK_NAME_PROPERTY:
		gitg_hook_set_name (self, g_value_get_string (value));
		break;
		case GITG_HOOK_WORKING_DIRECTORY_PROPERTY:
		gitg_hook_set_working_directory (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

