/* imap-status-response.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-status-response.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_IMAP_STATUS_RESPONSE_0_PROPERTY,
	GEARY_IMAP_STATUS_RESPONSE_IS_COMPLETION_PROPERTY,
	GEARY_IMAP_STATUS_RESPONSE_STATUS_PROPERTY,
	GEARY_IMAP_STATUS_RESPONSE_RESPONSE_CODE_PROPERTY,
	GEARY_IMAP_STATUS_RESPONSE_NUM_PROPERTIES
};
static GParamSpec* geary_imap_status_response_properties[GEARY_IMAP_STATUS_RESPONSE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _GearyImapStatusResponsePrivate {
	gboolean _is_completion;
	GearyImapStatus _status;
	GearyImapResponseCode* _response_code;
};

static gint GearyImapStatusResponse_private_offset;
static gpointer geary_imap_status_response_parent_class = NULL;

static void geary_imap_status_response_set_is_completion (GearyImapStatusResponse* self,
                                                   gboolean value);
static void geary_imap_status_response_set_status (GearyImapStatusResponse* self,
                                            GearyImapStatus value);
static void geary_imap_status_response_set_response_code (GearyImapStatusResponse* self,
                                                   GearyImapResponseCode* value);
static GearyImapStatusResponse* geary_imap_status_response_new (GearyImapTag* tag,
                                                         GearyImapStatus status,
                                                         GearyImapResponseCode* response_code,
                                                         GearyImapQuirks* quirks);
static GearyImapStatusResponse* geary_imap_status_response_construct (GType object_type,
                                                               GearyImapTag* tag,
                                                               GearyImapStatus status,
                                                               GearyImapResponseCode* response_code,
                                                               GearyImapQuirks* quirks);
static void geary_imap_status_response_update_is_completion (GearyImapStatusResponse* self);
static void geary_imap_status_response_finalize (GObject * obj);
static GType geary_imap_status_response_get_type_once (void);
static void _vala_geary_imap_status_response_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_geary_imap_status_response_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);

static inline gpointer
geary_imap_status_response_get_instance_private (GearyImapStatusResponse* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapStatusResponse_private_offset);
}

gboolean
geary_imap_status_response_get_is_completion (GearyImapStatusResponse* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_STATUS_RESPONSE (self), FALSE);
	result = self->priv->_is_completion;
	return result;
}

static void
geary_imap_status_response_set_is_completion (GearyImapStatusResponse* self,
                                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (GEARY_IMAP_IS_STATUS_RESPONSE (self));
	old_value = geary_imap_status_response_get_is_completion (self);
	if (old_value != value) {
		self->priv->_is_completion = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_status_response_properties[GEARY_IMAP_STATUS_RESPONSE_IS_COMPLETION_PROPERTY]);
	}
}

GearyImapStatus
geary_imap_status_response_get_status (GearyImapStatusResponse* self)
{
	GearyImapStatus result;
	g_return_val_if_fail (GEARY_IMAP_IS_STATUS_RESPONSE (self), 0);
	result = self->priv->_status;
	return result;
}

static void
geary_imap_status_response_set_status (GearyImapStatusResponse* self,
                                       GearyImapStatus value)
{
	GearyImapStatus old_value;
	g_return_if_fail (GEARY_IMAP_IS_STATUS_RESPONSE (self));
	old_value = geary_imap_status_response_get_status (self);
	if (old_value != value) {
		self->priv->_status = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_status_response_properties[GEARY_IMAP_STATUS_RESPONSE_STATUS_PROPERTY]);
	}
}

GearyImapResponseCode*
geary_imap_status_response_get_response_code (GearyImapStatusResponse* self)
{
	GearyImapResponseCode* result;
	GearyImapResponseCode* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_STATUS_RESPONSE (self), NULL);
	_tmp0_ = self->priv->_response_code;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_imap_status_response_set_response_code (GearyImapStatusResponse* self,
                                              GearyImapResponseCode* value)
{
	GearyImapResponseCode* old_value;
	g_return_if_fail (GEARY_IMAP_IS_STATUS_RESPONSE (self));
	old_value = geary_imap_status_response_get_response_code (self);
	if (old_value != value) {
		GearyImapResponseCode* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_response_code);
		self->priv->_response_code = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_status_response_properties[GEARY_IMAP_STATUS_RESPONSE_RESPONSE_CODE_PROPERTY]);
	}
}

static GearyImapStatusResponse*
geary_imap_status_response_construct (GType object_type,
                                      GearyImapTag* tag,
                                      GearyImapStatus status,
                                      GearyImapResponseCode* response_code,
                                      GearyImapQuirks* quirks)
{
	GearyImapStatusResponse * self = NULL;
	g_return_val_if_fail (GEARY_IMAP_IS_TAG (tag), NULL);
	g_return_val_if_fail ((response_code == NULL) || GEARY_IMAP_IS_RESPONSE_CODE (response_code), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_QUIRKS (quirks), NULL);
	self = (GearyImapStatusResponse*) geary_imap_server_response_construct (object_type, tag, quirks);
	geary_imap_status_response_set_status (self, status);
	geary_imap_status_response_set_response_code (self, response_code);
	geary_imap_status_response_update_is_completion (self);
	return self;
}

static GearyImapStatusResponse*
geary_imap_status_response_new (GearyImapTag* tag,
                                GearyImapStatus status,
                                GearyImapResponseCode* response_code,
                                GearyImapQuirks* quirks)
{
	return geary_imap_status_response_construct (GEARY_IMAP_TYPE_STATUS_RESPONSE, tag, status, response_code, quirks);
}

/**
     * Converts the {@link RootParameters} into a {@link StatusResponse}.
     *
     * The supplied root is "stripped" of its children.  This may happen even if an exception is
     * thrown.  It's recommended to use {@link is_status_response} prior to this call.
     */
GearyImapStatusResponse*
geary_imap_status_response_construct_migrate (GType object_type,
                                              GearyImapRootParameters* root,
                                              GearyImapQuirks* quirks,
                                              GError** error)
{
	GearyImapStatusResponse * self = NULL;
	GearyImapStringParameter* _tmp0_ = NULL;
	GearyImapStringParameter* _tmp1_;
	GearyImapStatus _tmp2_ = 0;
	GearyImapListParameter* _tmp3_;
	GearyImapResponseCode* _tmp4_;
	GearyImapResponseCode* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (GEARY_IMAP_IS_ROOT_PARAMETERS (root), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_QUIRKS (quirks), NULL);
	self = (GearyImapStatusResponse*) geary_imap_server_response_construct_migrate (object_type, root, quirks, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = geary_imap_list_parameter_get_as_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 1, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = geary_imap_status_from_parameter (_tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	geary_imap_status_response_set_status (self, _tmp2_);
	_tmp3_ = geary_imap_list_parameter_get_if_list (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 2);
	_tmp4_ = GEARY_IMAP_IS_RESPONSE_CODE (_tmp3_) ? ((GearyImapResponseCode*) _tmp3_) : NULL;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (_tmp3_);
	}
	_tmp5_ = _tmp4_;
	geary_imap_status_response_set_response_code (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	geary_imap_status_response_update_is_completion (self);
	_g_object_unref0 (_tmp0_);
	return self;
}

GearyImapStatusResponse*
geary_imap_status_response_new_migrate (GearyImapRootParameters* root,
                                        GearyImapQuirks* quirks,
                                        GError** error)
{
	return geary_imap_status_response_construct_migrate (GEARY_IMAP_TYPE_STATUS_RESPONSE, root, quirks, error);
}

static void
geary_imap_status_response_update_is_completion (GearyImapStatusResponse* self)
{
	GearyImapTag* _tmp0_;
	GearyImapTag* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_STATUS_RESPONSE (self));
	geary_imap_status_response_set_is_completion (self, FALSE);
	_tmp0_ = geary_imap_server_response_get_tag (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_SERVER_RESPONSE, GearyImapServerResponse));
	_tmp1_ = _tmp0_;
	if (geary_imap_tag_is_tagged (_tmp1_)) {
		GearyImapStatus _tmp2_;
		_tmp2_ = self->priv->_status;
		switch (_tmp2_) {
			case GEARY_IMAP_STATUS_OK:
			case GEARY_IMAP_STATUS_NO:
			case GEARY_IMAP_STATUS_BAD:
			{
				geary_imap_status_response_set_is_completion (self, TRUE);
				break;
			}
			default:
			{
				break;
			}
		}
	}
}

/**
     * Returns optional text provided by the server.  Note that this text is not internationalized
     * and probably in English, and is not standard or uniformly declared.  It's not recommended
     * this text be displayed to the user.
     */
gchar*
geary_imap_status_response_get_text (GearyImapStatusResponse* self)
{
	GString* builder = NULL;
	GString* _tmp0_;
	const gchar* _tmp14_ = NULL;
	GString* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp19_;
	gchar* result;
	g_return_val_if_fail (GEARY_IMAP_IS_STATUS_RESPONSE (self), NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	{
		gint index = 0;
		index = 2;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				GearyImapStringParameter* strparam = NULL;
				GearyImapStringParameter* _tmp5_;
				GearyImapStringParameter* _tmp6_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = index;
					index = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = geary_imap_list_parameter_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter));
				_tmp4_ = _tmp3_;
				if (!(index < _tmp4_)) {
					break;
				}
				_tmp5_ = geary_imap_list_parameter_get_if_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), index);
				strparam = _tmp5_;
				_tmp6_ = strparam;
				if (_tmp6_ != NULL) {
					GString* _tmp7_;
					GearyImapStringParameter* _tmp8_;
					const gchar* _tmp9_;
					const gchar* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					_tmp7_ = builder;
					_tmp8_ = strparam;
					_tmp9_ = geary_imap_string_parameter_get_ascii (_tmp8_);
					_tmp10_ = _tmp9_;
					g_string_append (_tmp7_, _tmp10_);
					_tmp11_ = geary_imap_list_parameter_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter));
					_tmp12_ = _tmp11_;
					if (index < (_tmp12_ - 1)) {
						GString* _tmp13_;
						_tmp13_ = builder;
						g_string_append_c (_tmp13_, ' ');
					}
				}
				_g_object_unref0 (strparam);
			}
		}
	}
	_tmp15_ = builder;
	_tmp16_ = _tmp15_->str;
	if (!geary_string_is_empty (_tmp16_)) {
		GString* _tmp17_;
		const gchar* _tmp18_;
		_tmp17_ = builder;
		_tmp18_ = _tmp17_->str;
		_tmp14_ = _tmp18_;
	} else {
		_tmp14_ = NULL;
	}
	_tmp19_ = g_strdup (_tmp14_);
	result = _tmp19_;
	_g_string_free0 (builder);
	return result;
}

/**
     * Returns true if {@link RootParameters} holds a {@link Status} parameter.
     */
gboolean
geary_imap_status_response_is_status_response (GearyImapRootParameters* root)
{
	gboolean _tmp4_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_ROOT_PARAMETERS (root), FALSE);
	if (!geary_imap_root_parameters_has_tag (root)) {
		result = FALSE;
		return result;
	}
	{
		GearyImapStringParameter* _tmp0_ = NULL;
		GearyImapStringParameter* _tmp1_;
		_tmp1_ = geary_imap_list_parameter_get_as_string (G_TYPE_CHECK_INSTANCE_CAST (root, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 1, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp2_ = FALSE;
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				goto __catch0_geary_imap_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
		geary_imap_status_from_parameter (_tmp0_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp3_ = FALSE;
			_g_object_unref0 (_tmp0_);
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				goto __catch0_geary_imap_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
		result = TRUE;
		_g_object_unref0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_geary_imap_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp4_;
}

static void
geary_imap_status_response_class_init (GearyImapStatusResponseClass * klass,
                                       gpointer klass_data)
{
	geary_imap_status_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapStatusResponse_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_status_response_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_status_response_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_status_response_finalize;
	/**
	     * Returns true if this {@link StatusResponse} represents the completion of a {@link Command}.
	     *
	     * This is true if (a) the StatusResponse is tagged and (b) the {@link status} is
	     * {@link Status.OK}, {@link Status.NO}, or {@link Status.BAD}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_STATUS_RESPONSE_IS_COMPLETION_PROPERTY, geary_imap_status_response_properties[GEARY_IMAP_STATUS_RESPONSE_IS_COMPLETION_PROPERTY] = g_param_spec_boolean ("is-completion", "is-completion", "is-completion", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The {@link Status} being reported by the server in this {@link ServerResponse}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_STATUS_RESPONSE_STATUS_PROPERTY, geary_imap_status_response_properties[GEARY_IMAP_STATUS_RESPONSE_STATUS_PROPERTY] = g_param_spec_enum ("status", "status", "status", GEARY_IMAP_TYPE_STATUS, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * An optional {@link ResponseCode} reported by the server in this {@link ServerResponse}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_STATUS_RESPONSE_RESPONSE_CODE_PROPERTY, geary_imap_status_response_properties[GEARY_IMAP_STATUS_RESPONSE_RESPONSE_CODE_PROPERTY] = g_param_spec_object ("response-code", "response-code", "response-code", GEARY_IMAP_TYPE_RESPONSE_CODE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_status_response_instance_init (GearyImapStatusResponse * self,
                                          gpointer klass)
{
	self->priv = geary_imap_status_response_get_instance_private (self);
	self->priv->_is_completion = FALSE;
}

static void
geary_imap_status_response_finalize (GObject * obj)
{
	GearyImapStatusResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_STATUS_RESPONSE, GearyImapStatusResponse);
	_g_object_unref0 (self->priv->_response_code);
	G_OBJECT_CLASS (geary_imap_status_response_parent_class)->finalize (obj);
}

/**
 * A response line from the server indicating either a result from a command or an unsolicited
 * change in state.
 *
 * StatusResponses may be tagged or untagged, depending on their nature.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-7.1]] for more information.
 */
 G_GNUC_NO_INLINE static GType
geary_imap_status_response_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapStatusResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_status_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapStatusResponse), 0, (GInstanceInitFunc) geary_imap_status_response_instance_init, NULL };
	GType geary_imap_status_response_type_id;
	geary_imap_status_response_type_id = g_type_register_static (GEARY_IMAP_TYPE_SERVER_RESPONSE, "GearyImapStatusResponse", &g_define_type_info, 0);
	GearyImapStatusResponse_private_offset = g_type_add_instance_private (geary_imap_status_response_type_id, sizeof (GearyImapStatusResponsePrivate));
	return geary_imap_status_response_type_id;
}

GType
geary_imap_status_response_get_type (void)
{
	static gsize geary_imap_status_response_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_status_response_type_id__once)) {
		GType geary_imap_status_response_type_id;
		geary_imap_status_response_type_id = geary_imap_status_response_get_type_once ();
		g_once_init_leave (&geary_imap_status_response_type_id__once, geary_imap_status_response_type_id);
	}
	return geary_imap_status_response_type_id__once;
}

static void
_vala_geary_imap_status_response_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	GearyImapStatusResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_STATUS_RESPONSE, GearyImapStatusResponse);
	switch (property_id) {
		case GEARY_IMAP_STATUS_RESPONSE_IS_COMPLETION_PROPERTY:
		g_value_set_boolean (value, geary_imap_status_response_get_is_completion (self));
		break;
		case GEARY_IMAP_STATUS_RESPONSE_STATUS_PROPERTY:
		g_value_set_enum (value, geary_imap_status_response_get_status (self));
		break;
		case GEARY_IMAP_STATUS_RESPONSE_RESPONSE_CODE_PROPERTY:
		g_value_set_object (value, geary_imap_status_response_get_response_code (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_status_response_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	GearyImapStatusResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_STATUS_RESPONSE, GearyImapStatusResponse);
	switch (property_id) {
		case GEARY_IMAP_STATUS_RESPONSE_IS_COMPLETION_PROPERTY:
		geary_imap_status_response_set_is_completion (self, g_value_get_boolean (value));
		break;
		case GEARY_IMAP_STATUS_RESPONSE_STATUS_PROPERTY:
		geary_imap_status_response_set_status (self, g_value_get_enum (value));
		break;
		case GEARY_IMAP_STATUS_RESPONSE_RESPONSE_CODE_PROPERTY:
		geary_imap_status_response_set_response_code (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

