/* imap-uid-validity.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-uid-validity.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/*
 * A representation of IMAP's UIDVALIDITY.
 *
 * See [[tools.ietf.org/html/rfc3501#section-2.3.1.1]]
 *
 * @see UID
 */

#include "geary-engine.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_IMAP_UID_VALIDITY_0_PROPERTY,
	GEARY_IMAP_UID_VALIDITY_NUM_PROPERTIES
};
static GParamSpec* geary_imap_uid_validity_properties[GEARY_IMAP_UID_VALIDITY_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

static gpointer geary_imap_uid_validity_parent_class = NULL;
static GearyImapMessageDataIface * geary_imap_uid_validity_geary_imap_message_data_parent_iface = NULL;

static GType geary_imap_uid_validity_get_type_once (void);

/**
     * Creates a new {@link UIDValidity} without checking for valid values.
     *
     * @see UIDValidity.UIDValidity.checked
     */
GearyImapUIDValidity*
geary_imap_uid_validity_construct (GType object_type,
                                   gint64 value)
{
	GearyImapUIDValidity * self = NULL;
	self = (GearyImapUIDValidity*) geary_message_data_int64_message_data_construct (object_type, value);
	return self;
}

GearyImapUIDValidity*
geary_imap_uid_validity_new (gint64 value)
{
	return geary_imap_uid_validity_construct (GEARY_IMAP_TYPE_UID_VALIDITY, value);
}

/**
     * Creates a new {@link UIDValidity}, throwing {@link ImapError.INVALID} if the supplied value
     * is invalid.
     *
     * @see is_value_valid
     */
GearyImapUIDValidity*
geary_imap_uid_validity_construct_checked (GType object_type,
                                           gint64 value,
                                           GError** error)
{
	GearyImapUIDValidity * self = NULL;
	GError* _inner_error0_ = NULL;
	if (!geary_imap_uid_validity_is_value_valid (value)) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		GError* _tmp2_;
		GError* _tmp3_;
		_tmp0_ = g_strdup_printf ("%" G_GINT64_FORMAT, value);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Invalid UIDVALIDITY %s", _tmp1_);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		_inner_error0_ = _tmp3_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	self = (GearyImapUIDValidity*) geary_message_data_int64_message_data_construct (object_type, value);
	return self;
}

GearyImapUIDValidity*
geary_imap_uid_validity_new_checked (gint64 value,
                                     GError** error)
{
	return geary_imap_uid_validity_construct_checked (GEARY_IMAP_TYPE_UID_VALIDITY, value, error);
}

/**
     * @see is_value_valid
     */
gboolean
geary_imap_uid_validity_is_valid (GearyImapUIDValidity* self)
{
	gint64 _tmp0_;
	gint64 _tmp1_;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_UID_VALIDITY (self), FALSE);
	_tmp0_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_tmp1_ = _tmp0_;
	result = geary_imap_uid_validity_is_value_valid (_tmp1_);
	return result;
}

/**
     * Returns true if the supplied value is between {@link MIN} and {@link MAX}, inclusive.
     */
gboolean
geary_imap_uid_validity_is_value_valid (gint64 val)
{
	gboolean result;
	result = geary_numeric_int64_in_range_inclusive (val, GEARY_IMAP_UID_VALIDITY_MIN, GEARY_IMAP_UID_VALIDITY_MAX);
	return result;
}

static void
geary_imap_uid_validity_class_init (GearyImapUIDValidityClass * klass,
                                    gpointer klass_data)
{
	geary_imap_uid_validity_parent_class = g_type_class_peek_parent (klass);
}

static void
geary_imap_uid_validity_geary_imap_message_data_interface_init (GearyImapMessageDataIface * iface,
                                                                gpointer iface_data)
{
	geary_imap_uid_validity_geary_imap_message_data_parent_iface = g_type_interface_peek_parent (iface);
}

static void
geary_imap_uid_validity_instance_init (GearyImapUIDValidity * self,
                                       gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
geary_imap_uid_validity_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapUIDValidityClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_uid_validity_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapUIDValidity), 0, (GInstanceInitFunc) geary_imap_uid_validity_instance_init, NULL };
	static const GInterfaceInfo geary_imap_message_data_info = { (GInterfaceInitFunc) geary_imap_uid_validity_geary_imap_message_data_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_imap_uid_validity_type_id;
	geary_imap_uid_validity_type_id = g_type_register_static (GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, "GearyImapUIDValidity", &g_define_type_info, 0);
	g_type_add_interface_static (geary_imap_uid_validity_type_id, GEARY_IMAP_TYPE_MESSAGE_DATA, &geary_imap_message_data_info);
	return geary_imap_uid_validity_type_id;
}

GType
geary_imap_uid_validity_get_type (void)
{
	static gsize geary_imap_uid_validity_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_uid_validity_type_id__once)) {
		GType geary_imap_uid_validity_type_id;
		geary_imap_uid_validity_type_id = geary_imap_uid_validity_get_type_once ();
		g_once_init_leave (&geary_imap_uid_validity_type_id__once, geary_imap_uid_validity_type_id);
	}
	return geary_imap_uid_validity_type_id__once;
}

