/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "gdm-client-glue.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_service_name,
        const gchar *arg_query,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_service_name,
        const gchar *arg_prompt_message,
        GVariant *arg_query,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_variant (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_UINT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringUintStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_service_name,
        const gchar *arg_protocol,
        guint arg_version,
        const gchar *arg_request,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringUintStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 6);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringUintStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_uint (param_values + 4),
              g_marshal_value_peek_string (param_values + 5),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_VOID__STRING_STRING (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringStringFunc)
       (void *data1,
        const gchar *arg_service_name,
        const gchar *arg_info,
        void *data2);
  _GDbusCodegenMarshalVoid_StringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_string (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectBoxedFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *const *arg_extensions,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectBoxedFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectBoxedFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_boxed (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_service_name,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_VOID__STRING_STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringStringVariantFunc)
       (void *data1,
        const gchar *arg_service_name,
        const gchar *arg_prompt_message,
        GVariant *arg_list,
        void *data2);
  _GDbusCodegenMarshalVoid_StringStringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringStringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_string (param_values + 2),
            g_marshal_value_peek_variant (param_values + 3),
            data2);
}

static void
_g_dbus_codegen_marshal_VOID__STRING_STRING_UINT_STRING (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringStringUintStringFunc)
       (void *data1,
        const gchar *arg_service_name,
        const gchar *arg_protocol,
        guint arg_version,
        const gchar *arg_request,
        void *data2);
  _GDbusCodegenMarshalVoid_StringStringUintStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringStringUintStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_string (param_values + 2),
            g_marshal_value_peek_uint (param_values + 3),
            g_marshal_value_peek_string (param_values + 4),
            data2);
}

static void
_g_dbus_codegen_marshal_VOID__STRING_INT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringIntFunc)
       (void *data1,
        const gchar *arg_username,
        gint arg_delay,
        void *data2);
  _GDbusCodegenMarshalVoid_StringIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_int (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOOLEAN (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringBooleanFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_service_name,
        gboolean arg_should_start_session,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringBooleanFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringBooleanFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_boolean (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.DisplayManager.WorkerManager
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GdmWorkerManager
 * @title: GdmWorkerManager
 * @short_description: Generated C code for the org.gnome.DisplayManager.WorkerManager D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-DisplayManager-WorkerManager.top_of_page">org.gnome.DisplayManager.WorkerManager</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.DisplayManager.WorkerManager ---- */

static const _ExtendedGDBusMethodInfo _gdm_worker_manager_method_info_hello =
{
  {
    -1,
    (gchar *) "Hello",
    NULL,
    NULL,
    NULL
  },
  "handle-hello",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_worker_manager_method_info_info_query_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_worker_manager_method_info_info_query_IN_ARG_query =
{
  {
    -1,
    (gchar *) "query",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_worker_manager_method_info_info_query_IN_ARG_pointers[] =
{
  &_gdm_worker_manager_method_info_info_query_IN_ARG_service_name.parent_struct,
  &_gdm_worker_manager_method_info_info_query_IN_ARG_query.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gdm_worker_manager_method_info_info_query_OUT_ARG_answer =
{
  {
    -1,
    (gchar *) "answer",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_worker_manager_method_info_info_query_OUT_ARG_pointers[] =
{
  &_gdm_worker_manager_method_info_info_query_OUT_ARG_answer.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_worker_manager_method_info_info_query =
{
  {
    -1,
    (gchar *) "InfoQuery",
    (GDBusArgInfo **) &_gdm_worker_manager_method_info_info_query_IN_ARG_pointers,
    (GDBusArgInfo **) &_gdm_worker_manager_method_info_info_query_OUT_ARG_pointers,
    NULL
  },
  "handle-info-query",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_worker_manager_method_info_secret_info_query_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_worker_manager_method_info_secret_info_query_IN_ARG_query =
{
  {
    -1,
    (gchar *) "query",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_worker_manager_method_info_secret_info_query_IN_ARG_pointers[] =
{
  &_gdm_worker_manager_method_info_secret_info_query_IN_ARG_service_name.parent_struct,
  &_gdm_worker_manager_method_info_secret_info_query_IN_ARG_query.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gdm_worker_manager_method_info_secret_info_query_OUT_ARG_answer =
{
  {
    -1,
    (gchar *) "answer",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_worker_manager_method_info_secret_info_query_OUT_ARG_pointers[] =
{
  &_gdm_worker_manager_method_info_secret_info_query_OUT_ARG_answer.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_worker_manager_method_info_secret_info_query =
{
  {
    -1,
    (gchar *) "SecretInfoQuery",
    (GDBusArgInfo **) &_gdm_worker_manager_method_info_secret_info_query_IN_ARG_pointers,
    (GDBusArgInfo **) &_gdm_worker_manager_method_info_secret_info_query_OUT_ARG_pointers,
    NULL
  },
  "handle-secret-info-query",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_worker_manager_method_info_info_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_worker_manager_method_info_info_IN_ARG_info =
{
  {
    -1,
    (gchar *) "info",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_worker_manager_method_info_info_IN_ARG_pointers[] =
{
  &_gdm_worker_manager_method_info_info_IN_ARG_service_name.parent_struct,
  &_gdm_worker_manager_method_info_info_IN_ARG_info.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_worker_manager_method_info_info =
{
  {
    -1,
    (gchar *) "Info",
    (GDBusArgInfo **) &_gdm_worker_manager_method_info_info_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-info",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_worker_manager_method_info_problem_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_worker_manager_method_info_problem_IN_ARG_problem =
{
  {
    -1,
    (gchar *) "problem",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_worker_manager_method_info_problem_IN_ARG_pointers[] =
{
  &_gdm_worker_manager_method_info_problem_IN_ARG_service_name.parent_struct,
  &_gdm_worker_manager_method_info_problem_IN_ARG_problem.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_worker_manager_method_info_problem =
{
  {
    -1,
    (gchar *) "Problem",
    (GDBusArgInfo **) &_gdm_worker_manager_method_info_problem_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-problem",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_worker_manager_method_info_choice_list_query_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_worker_manager_method_info_choice_list_query_IN_ARG_prompt_message =
{
  {
    -1,
    (gchar *) "prompt_message",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_worker_manager_method_info_choice_list_query_IN_ARG_query =
{
  {
    -1,
    (gchar *) "query",
    (gchar *) "a{ss}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_worker_manager_method_info_choice_list_query_IN_ARG_pointers[] =
{
  &_gdm_worker_manager_method_info_choice_list_query_IN_ARG_service_name.parent_struct,
  &_gdm_worker_manager_method_info_choice_list_query_IN_ARG_prompt_message.parent_struct,
  &_gdm_worker_manager_method_info_choice_list_query_IN_ARG_query.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gdm_worker_manager_method_info_choice_list_query_OUT_ARG_answer =
{
  {
    -1,
    (gchar *) "answer",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_worker_manager_method_info_choice_list_query_OUT_ARG_pointers[] =
{
  &_gdm_worker_manager_method_info_choice_list_query_OUT_ARG_answer.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_worker_manager_method_info_choice_list_query =
{
  {
    -1,
    (gchar *) "ChoiceListQuery",
    (GDBusArgInfo **) &_gdm_worker_manager_method_info_choice_list_query_IN_ARG_pointers,
    (GDBusArgInfo **) &_gdm_worker_manager_method_info_choice_list_query_OUT_ARG_pointers,
    NULL
  },
  "handle-choice-list-query",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_worker_manager_method_info_custom_json_request_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_worker_manager_method_info_custom_json_request_IN_ARG_protocol =
{
  {
    -1,
    (gchar *) "protocol",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_worker_manager_method_info_custom_json_request_IN_ARG_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_worker_manager_method_info_custom_json_request_IN_ARG_request =
{
  {
    -1,
    (gchar *) "request",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_worker_manager_method_info_custom_json_request_IN_ARG_pointers[] =
{
  &_gdm_worker_manager_method_info_custom_json_request_IN_ARG_service_name.parent_struct,
  &_gdm_worker_manager_method_info_custom_json_request_IN_ARG_protocol.parent_struct,
  &_gdm_worker_manager_method_info_custom_json_request_IN_ARG_version.parent_struct,
  &_gdm_worker_manager_method_info_custom_json_request_IN_ARG_request.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gdm_worker_manager_method_info_custom_json_request_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_worker_manager_method_info_custom_json_request_OUT_ARG_pointers[] =
{
  &_gdm_worker_manager_method_info_custom_json_request_OUT_ARG_response.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_worker_manager_method_info_custom_json_request =
{
  {
    -1,
    (gchar *) "CustomJSONRequest",
    (GDBusArgInfo **) &_gdm_worker_manager_method_info_custom_json_request_IN_ARG_pointers,
    (GDBusArgInfo **) &_gdm_worker_manager_method_info_custom_json_request_OUT_ARG_pointers,
    NULL
  },
  "handle-custom-json-request",
  FALSE
};

static const GDBusMethodInfo * const _gdm_worker_manager_method_info_pointers[] =
{
  &_gdm_worker_manager_method_info_hello.parent_struct,
  &_gdm_worker_manager_method_info_info_query.parent_struct,
  &_gdm_worker_manager_method_info_secret_info_query.parent_struct,
  &_gdm_worker_manager_method_info_info.parent_struct,
  &_gdm_worker_manager_method_info_problem.parent_struct,
  &_gdm_worker_manager_method_info_choice_list_query.parent_struct,
  &_gdm_worker_manager_method_info_custom_json_request.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gdm_worker_manager_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.DisplayManager.WorkerManager",
    (GDBusMethodInfo **) &_gdm_worker_manager_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "worker-manager",
};


/**
 * gdm_worker_manager_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-DisplayManager-WorkerManager.top_of_page">org.gnome.DisplayManager.WorkerManager</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gdm_worker_manager_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gdm_worker_manager_interface_info.parent_struct;
}

/**
 * gdm_worker_manager_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GdmWorkerManager interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gdm_worker_manager_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
gdm_worker_manager_method_marshal_hello (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_worker_manager_method_marshal_info_query (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_worker_manager_method_marshal_secret_info_query (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_worker_manager_method_marshal_info (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_worker_manager_method_marshal_problem (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_worker_manager_method_marshal_choice_list_query (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_worker_manager_method_marshal_custom_json_request (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_UINT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GdmWorkerManager:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-WorkerManager.top_of_page">org.gnome.DisplayManager.WorkerManager</link>.
 */

/**
 * GdmWorkerManagerIface:
 * @parent_iface: The parent interface.
 * @handle_choice_list_query: Handler for the #GdmWorkerManager::handle-choice-list-query signal.
 * @handle_custom_json_request: Handler for the #GdmWorkerManager::handle-custom-json-request signal.
 * @handle_hello: Handler for the #GdmWorkerManager::handle-hello signal.
 * @handle_info: Handler for the #GdmWorkerManager::handle-info signal.
 * @handle_info_query: Handler for the #GdmWorkerManager::handle-info-query signal.
 * @handle_problem: Handler for the #GdmWorkerManager::handle-problem signal.
 * @handle_secret_info_query: Handler for the #GdmWorkerManager::handle-secret-info-query signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-WorkerManager.top_of_page">org.gnome.DisplayManager.WorkerManager</link>.
 */

typedef GdmWorkerManagerIface GdmWorkerManagerInterface;
G_DEFINE_INTERFACE (GdmWorkerManager, gdm_worker_manager, G_TYPE_OBJECT)

static void
gdm_worker_manager_default_init (GdmWorkerManagerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GdmWorkerManager::handle-hello:
   * @object: A #GdmWorkerManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.Hello">Hello()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_worker_manager_complete_hello() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-hello",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmWorkerManagerIface, handle_hello),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_worker_manager_method_marshal_hello,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GdmWorkerManager::handle-info-query:
   * @object: A #GdmWorkerManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   * @arg_query: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.InfoQuery">InfoQuery()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_worker_manager_complete_info_query() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-info-query",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmWorkerManagerIface, handle_info_query),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_worker_manager_method_marshal_info_query,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmWorkerManager::handle-secret-info-query:
   * @object: A #GdmWorkerManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   * @arg_query: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.SecretInfoQuery">SecretInfoQuery()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_worker_manager_complete_secret_info_query() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-secret-info-query",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmWorkerManagerIface, handle_secret_info_query),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_worker_manager_method_marshal_secret_info_query,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmWorkerManager::handle-info:
   * @object: A #GdmWorkerManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   * @arg_info: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.Info">Info()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_worker_manager_complete_info() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-info",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmWorkerManagerIface, handle_info),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_worker_manager_method_marshal_info,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmWorkerManager::handle-problem:
   * @object: A #GdmWorkerManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   * @arg_problem: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.Problem">Problem()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_worker_manager_complete_problem() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-problem",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmWorkerManagerIface, handle_problem),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_worker_manager_method_marshal_problem,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmWorkerManager::handle-choice-list-query:
   * @object: A #GdmWorkerManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   * @arg_prompt_message: Argument passed by remote caller.
   * @arg_query: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.ChoiceListQuery">ChoiceListQuery()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_worker_manager_complete_choice_list_query() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-choice-list-query",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmWorkerManagerIface, handle_choice_list_query),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_worker_manager_method_marshal_choice_list_query,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * GdmWorkerManager::handle-custom-json-request:
   * @object: A #GdmWorkerManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   * @arg_protocol: Argument passed by remote caller.
   * @arg_version: Argument passed by remote caller.
   * @arg_request: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.CustomJSONRequest">CustomJSONRequest()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_worker_manager_complete_custom_json_request() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-custom-json-request",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmWorkerManagerIface, handle_custom_json_request),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_worker_manager_method_marshal_custom_json_request,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING);

}

/**
 * gdm_worker_manager_call_hello:
 * @proxy: A #GdmWorkerManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.Hello">Hello()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_worker_manager_call_hello_finish() to get the result of the operation.
 *
 * See gdm_worker_manager_call_hello_sync() for the synchronous, blocking version of this method.
 */
void
gdm_worker_manager_call_hello (
    GdmWorkerManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Hello",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_worker_manager_call_hello_finish:
 * @proxy: A #GdmWorkerManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_worker_manager_call_hello().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_worker_manager_call_hello().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_worker_manager_call_hello_finish (
    GdmWorkerManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_worker_manager_call_hello_sync:
 * @proxy: A #GdmWorkerManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.Hello">Hello()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_worker_manager_call_hello() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_worker_manager_call_hello_sync (
    GdmWorkerManager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Hello",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_worker_manager_call_info_query:
 * @proxy: A #GdmWorkerManagerProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_query: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.InfoQuery">InfoQuery()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_worker_manager_call_info_query_finish() to get the result of the operation.
 *
 * See gdm_worker_manager_call_info_query_sync() for the synchronous, blocking version of this method.
 */
void
gdm_worker_manager_call_info_query (
    GdmWorkerManager *proxy,
    const gchar *arg_service_name,
    const gchar *arg_query,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "InfoQuery",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_query),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_worker_manager_call_info_query_finish:
 * @proxy: A #GdmWorkerManagerProxy.
 * @out_answer: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_worker_manager_call_info_query().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_worker_manager_call_info_query().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_worker_manager_call_info_query_finish (
    GdmWorkerManager *proxy,
    gchar ** out_answer,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_answer);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_worker_manager_call_info_query_sync:
 * @proxy: A #GdmWorkerManagerProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_query: Argument to pass with the method invocation.
 * @out_answer: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.InfoQuery">InfoQuery()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_worker_manager_call_info_query() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_worker_manager_call_info_query_sync (
    GdmWorkerManager *proxy,
    const gchar *arg_service_name,
    const gchar *arg_query,
    gchar ** out_answer,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "InfoQuery",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_query),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_answer);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_worker_manager_call_secret_info_query:
 * @proxy: A #GdmWorkerManagerProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_query: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.SecretInfoQuery">SecretInfoQuery()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_worker_manager_call_secret_info_query_finish() to get the result of the operation.
 *
 * See gdm_worker_manager_call_secret_info_query_sync() for the synchronous, blocking version of this method.
 */
void
gdm_worker_manager_call_secret_info_query (
    GdmWorkerManager *proxy,
    const gchar *arg_service_name,
    const gchar *arg_query,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SecretInfoQuery",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_query),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_worker_manager_call_secret_info_query_finish:
 * @proxy: A #GdmWorkerManagerProxy.
 * @out_answer: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_worker_manager_call_secret_info_query().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_worker_manager_call_secret_info_query().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_worker_manager_call_secret_info_query_finish (
    GdmWorkerManager *proxy,
    gchar ** out_answer,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_answer);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_worker_manager_call_secret_info_query_sync:
 * @proxy: A #GdmWorkerManagerProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_query: Argument to pass with the method invocation.
 * @out_answer: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.SecretInfoQuery">SecretInfoQuery()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_worker_manager_call_secret_info_query() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_worker_manager_call_secret_info_query_sync (
    GdmWorkerManager *proxy,
    const gchar *arg_service_name,
    const gchar *arg_query,
    gchar ** out_answer,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SecretInfoQuery",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_query),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_answer);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_worker_manager_call_info:
 * @proxy: A #GdmWorkerManagerProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_info: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.Info">Info()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_worker_manager_call_info_finish() to get the result of the operation.
 *
 * See gdm_worker_manager_call_info_sync() for the synchronous, blocking version of this method.
 */
void
gdm_worker_manager_call_info (
    GdmWorkerManager *proxy,
    const gchar *arg_service_name,
    const gchar *arg_info,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Info",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_info),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_worker_manager_call_info_finish:
 * @proxy: A #GdmWorkerManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_worker_manager_call_info().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_worker_manager_call_info().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_worker_manager_call_info_finish (
    GdmWorkerManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_worker_manager_call_info_sync:
 * @proxy: A #GdmWorkerManagerProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_info: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.Info">Info()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_worker_manager_call_info() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_worker_manager_call_info_sync (
    GdmWorkerManager *proxy,
    const gchar *arg_service_name,
    const gchar *arg_info,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Info",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_info),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_worker_manager_call_problem:
 * @proxy: A #GdmWorkerManagerProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_problem: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.Problem">Problem()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_worker_manager_call_problem_finish() to get the result of the operation.
 *
 * See gdm_worker_manager_call_problem_sync() for the synchronous, blocking version of this method.
 */
void
gdm_worker_manager_call_problem (
    GdmWorkerManager *proxy,
    const gchar *arg_service_name,
    const gchar *arg_problem,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Problem",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_problem),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_worker_manager_call_problem_finish:
 * @proxy: A #GdmWorkerManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_worker_manager_call_problem().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_worker_manager_call_problem().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_worker_manager_call_problem_finish (
    GdmWorkerManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_worker_manager_call_problem_sync:
 * @proxy: A #GdmWorkerManagerProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_problem: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.Problem">Problem()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_worker_manager_call_problem() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_worker_manager_call_problem_sync (
    GdmWorkerManager *proxy,
    const gchar *arg_service_name,
    const gchar *arg_problem,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Problem",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_problem),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_worker_manager_call_choice_list_query:
 * @proxy: A #GdmWorkerManagerProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_prompt_message: Argument to pass with the method invocation.
 * @arg_query: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.ChoiceListQuery">ChoiceListQuery()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_worker_manager_call_choice_list_query_finish() to get the result of the operation.
 *
 * See gdm_worker_manager_call_choice_list_query_sync() for the synchronous, blocking version of this method.
 */
void
gdm_worker_manager_call_choice_list_query (
    GdmWorkerManager *proxy,
    const gchar *arg_service_name,
    const gchar *arg_prompt_message,
    GVariant *arg_query,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ChoiceListQuery",
    g_variant_new ("(ss@a{ss})",
                   arg_service_name,
                   arg_prompt_message,
                   arg_query),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_worker_manager_call_choice_list_query_finish:
 * @proxy: A #GdmWorkerManagerProxy.
 * @out_answer: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_worker_manager_call_choice_list_query().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_worker_manager_call_choice_list_query().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_worker_manager_call_choice_list_query_finish (
    GdmWorkerManager *proxy,
    gchar ** out_answer,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_answer);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_worker_manager_call_choice_list_query_sync:
 * @proxy: A #GdmWorkerManagerProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_prompt_message: Argument to pass with the method invocation.
 * @arg_query: Argument to pass with the method invocation.
 * @out_answer: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.ChoiceListQuery">ChoiceListQuery()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_worker_manager_call_choice_list_query() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_worker_manager_call_choice_list_query_sync (
    GdmWorkerManager *proxy,
    const gchar *arg_service_name,
    const gchar *arg_prompt_message,
    GVariant *arg_query,
    gchar ** out_answer,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ChoiceListQuery",
    g_variant_new ("(ss@a{ss})",
                   arg_service_name,
                   arg_prompt_message,
                   arg_query),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_answer);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_worker_manager_call_custom_json_request:
 * @proxy: A #GdmWorkerManagerProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_protocol: Argument to pass with the method invocation.
 * @arg_version: Argument to pass with the method invocation.
 * @arg_request: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.CustomJSONRequest">CustomJSONRequest()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_worker_manager_call_custom_json_request_finish() to get the result of the operation.
 *
 * See gdm_worker_manager_call_custom_json_request_sync() for the synchronous, blocking version of this method.
 */
void
gdm_worker_manager_call_custom_json_request (
    GdmWorkerManager *proxy,
    const gchar *arg_service_name,
    const gchar *arg_protocol,
    guint arg_version,
    const gchar *arg_request,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CustomJSONRequest",
    g_variant_new ("(ssus)",
                   arg_service_name,
                   arg_protocol,
                   arg_version,
                   arg_request),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_worker_manager_call_custom_json_request_finish:
 * @proxy: A #GdmWorkerManagerProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_worker_manager_call_custom_json_request().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_worker_manager_call_custom_json_request().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_worker_manager_call_custom_json_request_finish (
    GdmWorkerManager *proxy,
    gchar ** out_response,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_response);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_worker_manager_call_custom_json_request_sync:
 * @proxy: A #GdmWorkerManagerProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_protocol: Argument to pass with the method invocation.
 * @arg_version: Argument to pass with the method invocation.
 * @arg_request: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.CustomJSONRequest">CustomJSONRequest()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_worker_manager_call_custom_json_request() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_worker_manager_call_custom_json_request_sync (
    GdmWorkerManager *proxy,
    const gchar *arg_service_name,
    const gchar *arg_protocol,
    guint arg_version,
    const gchar *arg_request,
    gchar ** out_response,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CustomJSONRequest",
    g_variant_new ("(ssus)",
                   arg_service_name,
                   arg_protocol,
                   arg_version,
                   arg_request),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_response);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_worker_manager_complete_hello:
 * @object: A #GdmWorkerManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.Hello">Hello()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_worker_manager_complete_hello (
    GdmWorkerManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_worker_manager_complete_info_query:
 * @object: A #GdmWorkerManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @answer: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.InfoQuery">InfoQuery()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_worker_manager_complete_info_query (
    GdmWorkerManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *answer)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   answer));
}

/**
 * gdm_worker_manager_complete_secret_info_query:
 * @object: A #GdmWorkerManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @answer: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.SecretInfoQuery">SecretInfoQuery()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_worker_manager_complete_secret_info_query (
    GdmWorkerManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *answer)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   answer));
}

/**
 * gdm_worker_manager_complete_info:
 * @object: A #GdmWorkerManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.Info">Info()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_worker_manager_complete_info (
    GdmWorkerManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_worker_manager_complete_problem:
 * @object: A #GdmWorkerManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.Problem">Problem()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_worker_manager_complete_problem (
    GdmWorkerManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_worker_manager_complete_choice_list_query:
 * @object: A #GdmWorkerManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @answer: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.ChoiceListQuery">ChoiceListQuery()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_worker_manager_complete_choice_list_query (
    GdmWorkerManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *answer)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   answer));
}

/**
 * gdm_worker_manager_complete_custom_json_request:
 * @object: A #GdmWorkerManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.CustomJSONRequest">CustomJSONRequest()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_worker_manager_complete_custom_json_request (
    GdmWorkerManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *response)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   response));
}

/* ------------------------------------------------------------------------ */

/**
 * GdmWorkerManagerProxy:
 *
 * The #GdmWorkerManagerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmWorkerManagerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmWorkerManagerProxy.
 */

struct _GdmWorkerManagerProxyPrivate
{
  GData *qdata;
};

static void gdm_worker_manager_proxy_iface_init (GdmWorkerManagerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmWorkerManagerProxy, gdm_worker_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GdmWorkerManagerProxy)
                         G_IMPLEMENT_INTERFACE (GDM_TYPE_WORKER_MANAGER, gdm_worker_manager_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmWorkerManagerProxy, gdm_worker_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GDM_TYPE_WORKER_MANAGER, gdm_worker_manager_proxy_iface_init))

#endif
static void
gdm_worker_manager_proxy_finalize (GObject *object)
{
  GdmWorkerManagerProxy *proxy = GDM_WORKER_MANAGER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gdm_worker_manager_proxy_parent_class)->finalize (object);
}

static void
gdm_worker_manager_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_worker_manager_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_worker_manager_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gdm_worker_manager_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GDM_TYPE_WORKER_MANAGER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_TYPE_WORKER_MANAGER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gdm_worker_manager_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GdmWorkerManagerProxy *proxy = GDM_WORKER_MANAGER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_worker_manager_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_worker_manager_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
gdm_worker_manager_proxy_init (GdmWorkerManagerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gdm_worker_manager_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GDM_TYPE_WORKER_MANAGER_PROXY, GdmWorkerManagerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gdm_worker_manager_interface_info ());
}

static void
gdm_worker_manager_proxy_class_init (GdmWorkerManagerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gdm_worker_manager_proxy_finalize;
  gobject_class->get_property = gdm_worker_manager_proxy_get_property;
  gobject_class->set_property = gdm_worker_manager_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gdm_worker_manager_proxy_g_signal;
  proxy_class->g_properties_changed = gdm_worker_manager_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmWorkerManagerProxyPrivate));
#endif
}

static void
gdm_worker_manager_proxy_iface_init (GdmWorkerManagerIface *iface G_GNUC_UNUSED)
{
}

/**
 * gdm_worker_manager_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-WorkerManager.top_of_page">org.gnome.DisplayManager.WorkerManager</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_worker_manager_proxy_new_finish() to get the result of the operation.
 *
 * See gdm_worker_manager_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_worker_manager_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_TYPE_WORKER_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.WorkerManager", NULL);
}

/**
 * gdm_worker_manager_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_worker_manager_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_worker_manager_proxy_new().
 *
 * Returns: (transfer full) (type GdmWorkerManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmWorkerManager *
gdm_worker_manager_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_WORKER_MANAGER (ret);
  else
    return NULL;
}

/**
 * gdm_worker_manager_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-WorkerManager.top_of_page">org.gnome.DisplayManager.WorkerManager</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_worker_manager_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmWorkerManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmWorkerManager *
gdm_worker_manager_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_TYPE_WORKER_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.WorkerManager", NULL);
  if (ret != NULL)
    return GDM_WORKER_MANAGER (ret);
  else
    return NULL;
}


/**
 * gdm_worker_manager_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gdm_worker_manager_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_worker_manager_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gdm_worker_manager_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_worker_manager_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_TYPE_WORKER_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.WorkerManager", NULL);
}

/**
 * gdm_worker_manager_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_worker_manager_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_worker_manager_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GdmWorkerManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmWorkerManager *
gdm_worker_manager_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_WORKER_MANAGER (ret);
  else
    return NULL;
}

/**
 * gdm_worker_manager_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gdm_worker_manager_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_worker_manager_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmWorkerManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmWorkerManager *
gdm_worker_manager_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_TYPE_WORKER_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.WorkerManager", NULL);
  if (ret != NULL)
    return GDM_WORKER_MANAGER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GdmWorkerManagerSkeleton:
 *
 * The #GdmWorkerManagerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmWorkerManagerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmWorkerManagerSkeleton.
 */

struct _GdmWorkerManagerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gdm_worker_manager_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GdmWorkerManagerSkeleton *skeleton = GDM_WORKER_MANAGER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GDM_TYPE_WORKER_MANAGER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_TYPE_WORKER_MANAGER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gdm_worker_manager_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GdmWorkerManagerSkeleton *skeleton = GDM_WORKER_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_worker_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gdm_worker_manager_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GdmWorkerManagerSkeleton *skeleton = GDM_WORKER_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_worker_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gdm_worker_manager_skeleton_vtable =
{
  _gdm_worker_manager_skeleton_handle_method_call,
  _gdm_worker_manager_skeleton_handle_get_property,
  _gdm_worker_manager_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gdm_worker_manager_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gdm_worker_manager_interface_info ();
}

static GDBusInterfaceVTable *
gdm_worker_manager_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gdm_worker_manager_skeleton_vtable;
}

static GVariant *
gdm_worker_manager_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GdmWorkerManagerSkeleton *skeleton = GDM_WORKER_MANAGER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gdm_worker_manager_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gdm_worker_manager_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gdm_worker_manager_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gdm_worker_manager_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.WorkerManager", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
gdm_worker_manager_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void gdm_worker_manager_skeleton_iface_init (GdmWorkerManagerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmWorkerManagerSkeleton, gdm_worker_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GdmWorkerManagerSkeleton)
                         G_IMPLEMENT_INTERFACE (GDM_TYPE_WORKER_MANAGER, gdm_worker_manager_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmWorkerManagerSkeleton, gdm_worker_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GDM_TYPE_WORKER_MANAGER, gdm_worker_manager_skeleton_iface_init))

#endif
static void
gdm_worker_manager_skeleton_finalize (GObject *object)
{
  GdmWorkerManagerSkeleton *skeleton = GDM_WORKER_MANAGER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  /* coverity[missing_lock : SUPPRESS] */
  g_clear_pointer (&skeleton->priv->changed_properties_idle_source, g_source_destroy);
#else
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
skeleton->priv->changed_properties_idle_source = NULL;
#endif
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gdm_worker_manager_skeleton_parent_class)->finalize (object);
}

static void
gdm_worker_manager_skeleton_init (GdmWorkerManagerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gdm_worker_manager_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GDM_TYPE_WORKER_MANAGER_SKELETON, GdmWorkerManagerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
gdm_worker_manager_skeleton_class_init (GdmWorkerManagerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gdm_worker_manager_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gdm_worker_manager_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gdm_worker_manager_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gdm_worker_manager_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gdm_worker_manager_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmWorkerManagerSkeletonPrivate));
#endif
}

static void
gdm_worker_manager_skeleton_iface_init (GdmWorkerManagerIface *iface G_GNUC_UNUSED)
{
}

/**
 * gdm_worker_manager_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-WorkerManager.top_of_page">org.gnome.DisplayManager.WorkerManager</link>.
 *
 * Returns: (transfer full) (type GdmWorkerManagerSkeleton): The skeleton object.
 */
GdmWorkerManager *
gdm_worker_manager_skeleton_new (void)
{
  return GDM_WORKER_MANAGER (g_object_new (GDM_TYPE_WORKER_MANAGER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.DisplayManager.UserVerifier
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GdmUserVerifier
 * @title: GdmUserVerifier
 * @short_description: Generated C code for the org.gnome.DisplayManager.UserVerifier D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier.top_of_page">org.gnome.DisplayManager.UserVerifier</link> D-Bus interface in C.
 */

enum
{
  GDM__USER_VERIFIER_CONVERSATION_STARTED,
  GDM__USER_VERIFIER_CONVERSATION_STOPPED,
  GDM__USER_VERIFIER_REAUTHENTICATION_STARTED,
  GDM__USER_VERIFIER_INFO,
  GDM__USER_VERIFIER_PROBLEM,
  GDM__USER_VERIFIER_INFO_QUERY,
  GDM__USER_VERIFIER_SECRET_INFO_QUERY,
  GDM__USER_VERIFIER_RESET,
  GDM__USER_VERIFIER_SERVICE_UNAVAILABLE,
  GDM__USER_VERIFIER_VERIFICATION_FAILED,
  GDM__USER_VERIFIER_VERIFICATION_COMPLETE,
};

static unsigned GDM__USER_VERIFIER_SIGNALS[11] = { 0 };

/* ---- Introspection data for org.gnome.DisplayManager.UserVerifier ---- */

static const _ExtendedGDBusArgInfo _gdm_user_verifier_method_info_enable_extensions_IN_ARG_extensions =
{
  {
    -1,
    (gchar *) "extensions",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_user_verifier_method_info_enable_extensions_IN_ARG_pointers[] =
{
  &_gdm_user_verifier_method_info_enable_extensions_IN_ARG_extensions.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_user_verifier_method_info_enable_extensions =
{
  {
    -1,
    (gchar *) "EnableExtensions",
    (GDBusArgInfo **) &_gdm_user_verifier_method_info_enable_extensions_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-enable-extensions",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_method_info_begin_verification_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_user_verifier_method_info_begin_verification_IN_ARG_pointers[] =
{
  &_gdm_user_verifier_method_info_begin_verification_IN_ARG_service_name.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_user_verifier_method_info_begin_verification =
{
  {
    -1,
    (gchar *) "BeginVerification",
    (GDBusArgInfo **) &_gdm_user_verifier_method_info_begin_verification_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-begin-verification",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_method_info_begin_verification_for_user_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_method_info_begin_verification_for_user_IN_ARG_username =
{
  {
    -1,
    (gchar *) "username",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_user_verifier_method_info_begin_verification_for_user_IN_ARG_pointers[] =
{
  &_gdm_user_verifier_method_info_begin_verification_for_user_IN_ARG_service_name.parent_struct,
  &_gdm_user_verifier_method_info_begin_verification_for_user_IN_ARG_username.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_user_verifier_method_info_begin_verification_for_user =
{
  {
    -1,
    (gchar *) "BeginVerificationForUser",
    (GDBusArgInfo **) &_gdm_user_verifier_method_info_begin_verification_for_user_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-begin-verification-for-user",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_method_info_answer_query_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_method_info_answer_query_IN_ARG_answer =
{
  {
    -1,
    (gchar *) "answer",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_user_verifier_method_info_answer_query_IN_ARG_pointers[] =
{
  &_gdm_user_verifier_method_info_answer_query_IN_ARG_service_name.parent_struct,
  &_gdm_user_verifier_method_info_answer_query_IN_ARG_answer.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_user_verifier_method_info_answer_query =
{
  {
    -1,
    (gchar *) "AnswerQuery",
    (GDBusArgInfo **) &_gdm_user_verifier_method_info_answer_query_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-answer-query",
  FALSE
};

static const _ExtendedGDBusMethodInfo _gdm_user_verifier_method_info_cancel =
{
  {
    -1,
    (gchar *) "Cancel",
    NULL,
    NULL,
    NULL
  },
  "handle-cancel",
  FALSE
};

static const GDBusMethodInfo * const _gdm_user_verifier_method_info_pointers[] =
{
  &_gdm_user_verifier_method_info_enable_extensions.parent_struct,
  &_gdm_user_verifier_method_info_begin_verification.parent_struct,
  &_gdm_user_verifier_method_info_begin_verification_for_user.parent_struct,
  &_gdm_user_verifier_method_info_answer_query.parent_struct,
  &_gdm_user_verifier_method_info_cancel.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_signal_info_conversation_started_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_user_verifier_signal_info_conversation_started_ARG_pointers[] =
{
  &_gdm_user_verifier_signal_info_conversation_started_ARG_service_name.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_user_verifier_signal_info_conversation_started =
{
  {
    -1,
    (gchar *) "ConversationStarted",
    (GDBusArgInfo **) &_gdm_user_verifier_signal_info_conversation_started_ARG_pointers,
    NULL
  },
  "conversation-started"
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_signal_info_conversation_stopped_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_user_verifier_signal_info_conversation_stopped_ARG_pointers[] =
{
  &_gdm_user_verifier_signal_info_conversation_stopped_ARG_service_name.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_user_verifier_signal_info_conversation_stopped =
{
  {
    -1,
    (gchar *) "ConversationStopped",
    (GDBusArgInfo **) &_gdm_user_verifier_signal_info_conversation_stopped_ARG_pointers,
    NULL
  },
  "conversation-stopped"
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_signal_info_reauthentication_started_ARG_pid_of_caller =
{
  {
    -1,
    (gchar *) "pid_of_caller",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_user_verifier_signal_info_reauthentication_started_ARG_pointers[] =
{
  &_gdm_user_verifier_signal_info_reauthentication_started_ARG_pid_of_caller.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_user_verifier_signal_info_reauthentication_started =
{
  {
    -1,
    (gchar *) "ReauthenticationStarted",
    (GDBusArgInfo **) &_gdm_user_verifier_signal_info_reauthentication_started_ARG_pointers,
    NULL
  },
  "reauthentication-started"
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_signal_info_info_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_signal_info_info_ARG_info =
{
  {
    -1,
    (gchar *) "info",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_user_verifier_signal_info_info_ARG_pointers[] =
{
  &_gdm_user_verifier_signal_info_info_ARG_service_name.parent_struct,
  &_gdm_user_verifier_signal_info_info_ARG_info.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_user_verifier_signal_info_info =
{
  {
    -1,
    (gchar *) "Info",
    (GDBusArgInfo **) &_gdm_user_verifier_signal_info_info_ARG_pointers,
    NULL
  },
  "info"
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_signal_info_problem_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_signal_info_problem_ARG_problem =
{
  {
    -1,
    (gchar *) "problem",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_user_verifier_signal_info_problem_ARG_pointers[] =
{
  &_gdm_user_verifier_signal_info_problem_ARG_service_name.parent_struct,
  &_gdm_user_verifier_signal_info_problem_ARG_problem.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_user_verifier_signal_info_problem =
{
  {
    -1,
    (gchar *) "Problem",
    (GDBusArgInfo **) &_gdm_user_verifier_signal_info_problem_ARG_pointers,
    NULL
  },
  "problem"
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_signal_info_info_query_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_signal_info_info_query_ARG_query =
{
  {
    -1,
    (gchar *) "query",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_user_verifier_signal_info_info_query_ARG_pointers[] =
{
  &_gdm_user_verifier_signal_info_info_query_ARG_service_name.parent_struct,
  &_gdm_user_verifier_signal_info_info_query_ARG_query.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_user_verifier_signal_info_info_query =
{
  {
    -1,
    (gchar *) "InfoQuery",
    (GDBusArgInfo **) &_gdm_user_verifier_signal_info_info_query_ARG_pointers,
    NULL
  },
  "info-query"
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_signal_info_secret_info_query_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_signal_info_secret_info_query_ARG_query =
{
  {
    -1,
    (gchar *) "query",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_user_verifier_signal_info_secret_info_query_ARG_pointers[] =
{
  &_gdm_user_verifier_signal_info_secret_info_query_ARG_service_name.parent_struct,
  &_gdm_user_verifier_signal_info_secret_info_query_ARG_query.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_user_verifier_signal_info_secret_info_query =
{
  {
    -1,
    (gchar *) "SecretInfoQuery",
    (GDBusArgInfo **) &_gdm_user_verifier_signal_info_secret_info_query_ARG_pointers,
    NULL
  },
  "secret-info-query"
};

static const _ExtendedGDBusSignalInfo _gdm_user_verifier_signal_info_reset =
{
  {
    -1,
    (gchar *) "Reset",
    NULL,
    NULL
  },
  "reset"
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_signal_info_service_unavailable_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_signal_info_service_unavailable_ARG_message =
{
  {
    -1,
    (gchar *) "message",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_user_verifier_signal_info_service_unavailable_ARG_pointers[] =
{
  &_gdm_user_verifier_signal_info_service_unavailable_ARG_service_name.parent_struct,
  &_gdm_user_verifier_signal_info_service_unavailable_ARG_message.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_user_verifier_signal_info_service_unavailable =
{
  {
    -1,
    (gchar *) "ServiceUnavailable",
    (GDBusArgInfo **) &_gdm_user_verifier_signal_info_service_unavailable_ARG_pointers,
    NULL
  },
  "service-unavailable"
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_signal_info_verification_failed_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_user_verifier_signal_info_verification_failed_ARG_pointers[] =
{
  &_gdm_user_verifier_signal_info_verification_failed_ARG_service_name.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_user_verifier_signal_info_verification_failed =
{
  {
    -1,
    (gchar *) "VerificationFailed",
    (GDBusArgInfo **) &_gdm_user_verifier_signal_info_verification_failed_ARG_pointers,
    NULL
  },
  "verification-failed"
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_signal_info_verification_complete_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_user_verifier_signal_info_verification_complete_ARG_pointers[] =
{
  &_gdm_user_verifier_signal_info_verification_complete_ARG_service_name.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_user_verifier_signal_info_verification_complete =
{
  {
    -1,
    (gchar *) "VerificationComplete",
    (GDBusArgInfo **) &_gdm_user_verifier_signal_info_verification_complete_ARG_pointers,
    NULL
  },
  "verification-complete"
};

static const GDBusSignalInfo * const _gdm_user_verifier_signal_info_pointers[] =
{
  &_gdm_user_verifier_signal_info_conversation_started.parent_struct,
  &_gdm_user_verifier_signal_info_conversation_stopped.parent_struct,
  &_gdm_user_verifier_signal_info_reauthentication_started.parent_struct,
  &_gdm_user_verifier_signal_info_info.parent_struct,
  &_gdm_user_verifier_signal_info_problem.parent_struct,
  &_gdm_user_verifier_signal_info_info_query.parent_struct,
  &_gdm_user_verifier_signal_info_secret_info_query.parent_struct,
  &_gdm_user_verifier_signal_info_reset.parent_struct,
  &_gdm_user_verifier_signal_info_service_unavailable.parent_struct,
  &_gdm_user_verifier_signal_info_verification_failed.parent_struct,
  &_gdm_user_verifier_signal_info_verification_complete.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gdm_user_verifier_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.DisplayManager.UserVerifier",
    (GDBusMethodInfo **) &_gdm_user_verifier_method_info_pointers,
    (GDBusSignalInfo **) &_gdm_user_verifier_signal_info_pointers,
    NULL,
    NULL
  },
  "user-verifier",
};


/**
 * gdm_user_verifier_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier.top_of_page">org.gnome.DisplayManager.UserVerifier</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gdm_user_verifier_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gdm_user_verifier_interface_info.parent_struct;
}

/**
 * gdm_user_verifier_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GdmUserVerifier interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gdm_user_verifier_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
gdm_user_verifier_signal_marshal_conversation_started (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_user_verifier_signal_marshal_conversation_stopped (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_user_verifier_signal_marshal_reauthentication_started (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_user_verifier_signal_marshal_info (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_user_verifier_signal_marshal_problem (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_user_verifier_signal_marshal_info_query (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_user_verifier_signal_marshal_secret_info_query (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_user_verifier_signal_marshal_reset (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_user_verifier_signal_marshal_service_unavailable (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_user_verifier_signal_marshal_verification_failed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_user_verifier_signal_marshal_verification_complete (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_user_verifier_method_marshal_enable_extensions (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_user_verifier_method_marshal_begin_verification (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_user_verifier_method_marshal_begin_verification_for_user (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_user_verifier_method_marshal_answer_query (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_user_verifier_method_marshal_cancel (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GdmUserVerifier:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier.top_of_page">org.gnome.DisplayManager.UserVerifier</link>.
 */

/**
 * GdmUserVerifierIface:
 * @parent_iface: The parent interface.
 * @handle_answer_query: Handler for the #GdmUserVerifier::handle-answer-query signal.
 * @handle_begin_verification: Handler for the #GdmUserVerifier::handle-begin-verification signal.
 * @handle_begin_verification_for_user: Handler for the #GdmUserVerifier::handle-begin-verification-for-user signal.
 * @handle_cancel: Handler for the #GdmUserVerifier::handle-cancel signal.
 * @handle_enable_extensions: Handler for the #GdmUserVerifier::handle-enable-extensions signal.
 * @conversation_started: Handler for the #GdmUserVerifier::conversation-started signal.
 * @conversation_stopped: Handler for the #GdmUserVerifier::conversation-stopped signal.
 * @info: Handler for the #GdmUserVerifier::info signal.
 * @info_query: Handler for the #GdmUserVerifier::info-query signal.
 * @problem: Handler for the #GdmUserVerifier::problem signal.
 * @reauthentication_started: Handler for the #GdmUserVerifier::reauthentication-started signal.
 * @reset: Handler for the #GdmUserVerifier::reset signal.
 * @secret_info_query: Handler for the #GdmUserVerifier::secret-info-query signal.
 * @service_unavailable: Handler for the #GdmUserVerifier::service-unavailable signal.
 * @verification_complete: Handler for the #GdmUserVerifier::verification-complete signal.
 * @verification_failed: Handler for the #GdmUserVerifier::verification-failed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier.top_of_page">org.gnome.DisplayManager.UserVerifier</link>.
 */

typedef GdmUserVerifierIface GdmUserVerifierInterface;
G_DEFINE_INTERFACE (GdmUserVerifier, gdm_user_verifier, G_TYPE_OBJECT)

static void
gdm_user_verifier_default_init (GdmUserVerifierIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GdmUserVerifier::handle-enable-extensions:
   * @object: A #GdmUserVerifier.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_extensions: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.EnableExtensions">EnableExtensions()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_user_verifier_complete_enable_extensions() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-enable-extensions",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmUserVerifierIface, handle_enable_extensions),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_user_verifier_method_marshal_enable_extensions,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV);

  /**
   * GdmUserVerifier::handle-begin-verification:
   * @object: A #GdmUserVerifier.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.BeginVerification">BeginVerification()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_user_verifier_complete_begin_verification() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-begin-verification",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmUserVerifierIface, handle_begin_verification),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_user_verifier_method_marshal_begin_verification,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * GdmUserVerifier::handle-begin-verification-for-user:
   * @object: A #GdmUserVerifier.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   * @arg_username: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.BeginVerificationForUser">BeginVerificationForUser()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_user_verifier_complete_begin_verification_for_user() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-begin-verification-for-user",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmUserVerifierIface, handle_begin_verification_for_user),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_user_verifier_method_marshal_begin_verification_for_user,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmUserVerifier::handle-answer-query:
   * @object: A #GdmUserVerifier.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   * @arg_answer: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.AnswerQuery">AnswerQuery()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_user_verifier_complete_answer_query() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-answer-query",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmUserVerifierIface, handle_answer_query),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_user_verifier_method_marshal_answer_query,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmUserVerifier::handle-cancel:
   * @object: A #GdmUserVerifier.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.Cancel">Cancel()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_user_verifier_complete_cancel() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-cancel",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmUserVerifierIface, handle_cancel),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_user_verifier_method_marshal_cancel,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * GdmUserVerifier::conversation-started:
   * @object: A #GdmUserVerifier.
   * @arg_service_name: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.ConversationStarted">"ConversationStarted"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM__USER_VERIFIER_SIGNALS[GDM__USER_VERIFIER_CONVERSATION_STARTED] =
    g_signal_new ("conversation-started",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmUserVerifierIface, conversation_started),
      NULL,
      NULL,
      gdm_user_verifier_signal_marshal_conversation_started,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * GdmUserVerifier::conversation-stopped:
   * @object: A #GdmUserVerifier.
   * @arg_service_name: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.ConversationStopped">"ConversationStopped"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM__USER_VERIFIER_SIGNALS[GDM__USER_VERIFIER_CONVERSATION_STOPPED] =
    g_signal_new ("conversation-stopped",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmUserVerifierIface, conversation_stopped),
      NULL,
      NULL,
      gdm_user_verifier_signal_marshal_conversation_stopped,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * GdmUserVerifier::reauthentication-started:
   * @object: A #GdmUserVerifier.
   * @arg_pid_of_caller: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.ReauthenticationStarted">"ReauthenticationStarted"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM__USER_VERIFIER_SIGNALS[GDM__USER_VERIFIER_REAUTHENTICATION_STARTED] =
    g_signal_new ("reauthentication-started",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmUserVerifierIface, reauthentication_started),
      NULL,
      NULL,
      gdm_user_verifier_signal_marshal_reauthentication_started,
      G_TYPE_NONE,
      1, G_TYPE_INT);

  /**
   * GdmUserVerifier::info:
   * @object: A #GdmUserVerifier.
   * @arg_service_name: Argument.
   * @arg_info: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.Info">"Info"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM__USER_VERIFIER_SIGNALS[GDM__USER_VERIFIER_INFO] =
    g_signal_new ("info",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmUserVerifierIface, info),
      NULL,
      NULL,
      gdm_user_verifier_signal_marshal_info,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmUserVerifier::problem:
   * @object: A #GdmUserVerifier.
   * @arg_service_name: Argument.
   * @arg_problem: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.Problem">"Problem"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM__USER_VERIFIER_SIGNALS[GDM__USER_VERIFIER_PROBLEM] =
    g_signal_new ("problem",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmUserVerifierIface, problem),
      NULL,
      NULL,
      gdm_user_verifier_signal_marshal_problem,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmUserVerifier::info-query:
   * @object: A #GdmUserVerifier.
   * @arg_service_name: Argument.
   * @arg_query: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.InfoQuery">"InfoQuery"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM__USER_VERIFIER_SIGNALS[GDM__USER_VERIFIER_INFO_QUERY] =
    g_signal_new ("info-query",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmUserVerifierIface, info_query),
      NULL,
      NULL,
      gdm_user_verifier_signal_marshal_info_query,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmUserVerifier::secret-info-query:
   * @object: A #GdmUserVerifier.
   * @arg_service_name: Argument.
   * @arg_query: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.SecretInfoQuery">"SecretInfoQuery"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM__USER_VERIFIER_SIGNALS[GDM__USER_VERIFIER_SECRET_INFO_QUERY] =
    g_signal_new ("secret-info-query",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmUserVerifierIface, secret_info_query),
      NULL,
      NULL,
      gdm_user_verifier_signal_marshal_secret_info_query,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmUserVerifier::reset:
   * @object: A #GdmUserVerifier.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.Reset">"Reset"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM__USER_VERIFIER_SIGNALS[GDM__USER_VERIFIER_RESET] =
    g_signal_new ("reset",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmUserVerifierIface, reset),
      NULL,
      NULL,
      gdm_user_verifier_signal_marshal_reset,
      G_TYPE_NONE,
      0);

  /**
   * GdmUserVerifier::service-unavailable:
   * @object: A #GdmUserVerifier.
   * @arg_service_name: Argument.
   * @arg_message: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.ServiceUnavailable">"ServiceUnavailable"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM__USER_VERIFIER_SIGNALS[GDM__USER_VERIFIER_SERVICE_UNAVAILABLE] =
    g_signal_new ("service-unavailable",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmUserVerifierIface, service_unavailable),
      NULL,
      NULL,
      gdm_user_verifier_signal_marshal_service_unavailable,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmUserVerifier::verification-failed:
   * @object: A #GdmUserVerifier.
   * @arg_service_name: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.VerificationFailed">"VerificationFailed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM__USER_VERIFIER_SIGNALS[GDM__USER_VERIFIER_VERIFICATION_FAILED] =
    g_signal_new ("verification-failed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmUserVerifierIface, verification_failed),
      NULL,
      NULL,
      gdm_user_verifier_signal_marshal_verification_failed,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * GdmUserVerifier::verification-complete:
   * @object: A #GdmUserVerifier.
   * @arg_service_name: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.VerificationComplete">"VerificationComplete"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM__USER_VERIFIER_SIGNALS[GDM__USER_VERIFIER_VERIFICATION_COMPLETE] =
    g_signal_new ("verification-complete",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmUserVerifierIface, verification_complete),
      NULL,
      NULL,
      gdm_user_verifier_signal_marshal_verification_complete,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

}

/**
 * gdm_user_verifier_emit_conversation_started:
 * @object: A #GdmUserVerifier.
 * @arg_service_name: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.ConversationStarted">"ConversationStarted"</link> D-Bus signal.
 */
void
gdm_user_verifier_emit_conversation_started (
    GdmUserVerifier *object,
    const gchar *arg_service_name)
{
  g_signal_emit (object, GDM__USER_VERIFIER_SIGNALS[GDM__USER_VERIFIER_CONVERSATION_STARTED], 0, arg_service_name);
}

/**
 * gdm_user_verifier_emit_conversation_stopped:
 * @object: A #GdmUserVerifier.
 * @arg_service_name: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.ConversationStopped">"ConversationStopped"</link> D-Bus signal.
 */
void
gdm_user_verifier_emit_conversation_stopped (
    GdmUserVerifier *object,
    const gchar *arg_service_name)
{
  g_signal_emit (object, GDM__USER_VERIFIER_SIGNALS[GDM__USER_VERIFIER_CONVERSATION_STOPPED], 0, arg_service_name);
}

/**
 * gdm_user_verifier_emit_reauthentication_started:
 * @object: A #GdmUserVerifier.
 * @arg_pid_of_caller: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.ReauthenticationStarted">"ReauthenticationStarted"</link> D-Bus signal.
 */
void
gdm_user_verifier_emit_reauthentication_started (
    GdmUserVerifier *object,
    gint arg_pid_of_caller)
{
  g_signal_emit (object, GDM__USER_VERIFIER_SIGNALS[GDM__USER_VERIFIER_REAUTHENTICATION_STARTED], 0, arg_pid_of_caller);
}

/**
 * gdm_user_verifier_emit_info:
 * @object: A #GdmUserVerifier.
 * @arg_service_name: Argument to pass with the signal.
 * @arg_info: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.Info">"Info"</link> D-Bus signal.
 */
void
gdm_user_verifier_emit_info (
    GdmUserVerifier *object,
    const gchar *arg_service_name,
    const gchar *arg_info)
{
  g_signal_emit (object, GDM__USER_VERIFIER_SIGNALS[GDM__USER_VERIFIER_INFO], 0, arg_service_name, arg_info);
}

/**
 * gdm_user_verifier_emit_problem:
 * @object: A #GdmUserVerifier.
 * @arg_service_name: Argument to pass with the signal.
 * @arg_problem: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.Problem">"Problem"</link> D-Bus signal.
 */
void
gdm_user_verifier_emit_problem (
    GdmUserVerifier *object,
    const gchar *arg_service_name,
    const gchar *arg_problem)
{
  g_signal_emit (object, GDM__USER_VERIFIER_SIGNALS[GDM__USER_VERIFIER_PROBLEM], 0, arg_service_name, arg_problem);
}

/**
 * gdm_user_verifier_emit_info_query:
 * @object: A #GdmUserVerifier.
 * @arg_service_name: Argument to pass with the signal.
 * @arg_query: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.InfoQuery">"InfoQuery"</link> D-Bus signal.
 */
void
gdm_user_verifier_emit_info_query (
    GdmUserVerifier *object,
    const gchar *arg_service_name,
    const gchar *arg_query)
{
  g_signal_emit (object, GDM__USER_VERIFIER_SIGNALS[GDM__USER_VERIFIER_INFO_QUERY], 0, arg_service_name, arg_query);
}

/**
 * gdm_user_verifier_emit_secret_info_query:
 * @object: A #GdmUserVerifier.
 * @arg_service_name: Argument to pass with the signal.
 * @arg_query: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.SecretInfoQuery">"SecretInfoQuery"</link> D-Bus signal.
 */
void
gdm_user_verifier_emit_secret_info_query (
    GdmUserVerifier *object,
    const gchar *arg_service_name,
    const gchar *arg_query)
{
  g_signal_emit (object, GDM__USER_VERIFIER_SIGNALS[GDM__USER_VERIFIER_SECRET_INFO_QUERY], 0, arg_service_name, arg_query);
}

/**
 * gdm_user_verifier_emit_reset:
 * @object: A #GdmUserVerifier.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.Reset">"Reset"</link> D-Bus signal.
 */
void
gdm_user_verifier_emit_reset (
    GdmUserVerifier *object)
{
  g_signal_emit (object, GDM__USER_VERIFIER_SIGNALS[GDM__USER_VERIFIER_RESET], 0);
}

/**
 * gdm_user_verifier_emit_service_unavailable:
 * @object: A #GdmUserVerifier.
 * @arg_service_name: Argument to pass with the signal.
 * @arg_message: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.ServiceUnavailable">"ServiceUnavailable"</link> D-Bus signal.
 */
void
gdm_user_verifier_emit_service_unavailable (
    GdmUserVerifier *object,
    const gchar *arg_service_name,
    const gchar *arg_message)
{
  g_signal_emit (object, GDM__USER_VERIFIER_SIGNALS[GDM__USER_VERIFIER_SERVICE_UNAVAILABLE], 0, arg_service_name, arg_message);
}

/**
 * gdm_user_verifier_emit_verification_failed:
 * @object: A #GdmUserVerifier.
 * @arg_service_name: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.VerificationFailed">"VerificationFailed"</link> D-Bus signal.
 */
void
gdm_user_verifier_emit_verification_failed (
    GdmUserVerifier *object,
    const gchar *arg_service_name)
{
  g_signal_emit (object, GDM__USER_VERIFIER_SIGNALS[GDM__USER_VERIFIER_VERIFICATION_FAILED], 0, arg_service_name);
}

/**
 * gdm_user_verifier_emit_verification_complete:
 * @object: A #GdmUserVerifier.
 * @arg_service_name: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.VerificationComplete">"VerificationComplete"</link> D-Bus signal.
 */
void
gdm_user_verifier_emit_verification_complete (
    GdmUserVerifier *object,
    const gchar *arg_service_name)
{
  g_signal_emit (object, GDM__USER_VERIFIER_SIGNALS[GDM__USER_VERIFIER_VERIFICATION_COMPLETE], 0, arg_service_name);
}

/**
 * gdm_user_verifier_call_enable_extensions:
 * @proxy: A #GdmUserVerifierProxy.
 * @arg_extensions: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.EnableExtensions">EnableExtensions()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_user_verifier_call_enable_extensions_finish() to get the result of the operation.
 *
 * See gdm_user_verifier_call_enable_extensions_sync() for the synchronous, blocking version of this method.
 */
void
gdm_user_verifier_call_enable_extensions (
    GdmUserVerifier *proxy,
    const gchar *const *arg_extensions,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EnableExtensions",
    g_variant_new ("(^as)",
                   arg_extensions),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_user_verifier_call_enable_extensions_finish:
 * @proxy: A #GdmUserVerifierProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_user_verifier_call_enable_extensions().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_user_verifier_call_enable_extensions().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_user_verifier_call_enable_extensions_finish (
    GdmUserVerifier *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_user_verifier_call_enable_extensions_sync:
 * @proxy: A #GdmUserVerifierProxy.
 * @arg_extensions: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.EnableExtensions">EnableExtensions()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_user_verifier_call_enable_extensions() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_user_verifier_call_enable_extensions_sync (
    GdmUserVerifier *proxy,
    const gchar *const *arg_extensions,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EnableExtensions",
    g_variant_new ("(^as)",
                   arg_extensions),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_user_verifier_call_begin_verification:
 * @proxy: A #GdmUserVerifierProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.BeginVerification">BeginVerification()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_user_verifier_call_begin_verification_finish() to get the result of the operation.
 *
 * See gdm_user_verifier_call_begin_verification_sync() for the synchronous, blocking version of this method.
 */
void
gdm_user_verifier_call_begin_verification (
    GdmUserVerifier *proxy,
    const gchar *arg_service_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "BeginVerification",
    g_variant_new ("(s)",
                   arg_service_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_user_verifier_call_begin_verification_finish:
 * @proxy: A #GdmUserVerifierProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_user_verifier_call_begin_verification().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_user_verifier_call_begin_verification().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_user_verifier_call_begin_verification_finish (
    GdmUserVerifier *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_user_verifier_call_begin_verification_sync:
 * @proxy: A #GdmUserVerifierProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.BeginVerification">BeginVerification()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_user_verifier_call_begin_verification() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_user_verifier_call_begin_verification_sync (
    GdmUserVerifier *proxy,
    const gchar *arg_service_name,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "BeginVerification",
    g_variant_new ("(s)",
                   arg_service_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_user_verifier_call_begin_verification_for_user:
 * @proxy: A #GdmUserVerifierProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_username: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.BeginVerificationForUser">BeginVerificationForUser()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_user_verifier_call_begin_verification_for_user_finish() to get the result of the operation.
 *
 * See gdm_user_verifier_call_begin_verification_for_user_sync() for the synchronous, blocking version of this method.
 */
void
gdm_user_verifier_call_begin_verification_for_user (
    GdmUserVerifier *proxy,
    const gchar *arg_service_name,
    const gchar *arg_username,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "BeginVerificationForUser",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_username),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_user_verifier_call_begin_verification_for_user_finish:
 * @proxy: A #GdmUserVerifierProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_user_verifier_call_begin_verification_for_user().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_user_verifier_call_begin_verification_for_user().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_user_verifier_call_begin_verification_for_user_finish (
    GdmUserVerifier *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_user_verifier_call_begin_verification_for_user_sync:
 * @proxy: A #GdmUserVerifierProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_username: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.BeginVerificationForUser">BeginVerificationForUser()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_user_verifier_call_begin_verification_for_user() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_user_verifier_call_begin_verification_for_user_sync (
    GdmUserVerifier *proxy,
    const gchar *arg_service_name,
    const gchar *arg_username,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "BeginVerificationForUser",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_username),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_user_verifier_call_answer_query:
 * @proxy: A #GdmUserVerifierProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_answer: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.AnswerQuery">AnswerQuery()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_user_verifier_call_answer_query_finish() to get the result of the operation.
 *
 * See gdm_user_verifier_call_answer_query_sync() for the synchronous, blocking version of this method.
 */
void
gdm_user_verifier_call_answer_query (
    GdmUserVerifier *proxy,
    const gchar *arg_service_name,
    const gchar *arg_answer,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AnswerQuery",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_answer),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_user_verifier_call_answer_query_finish:
 * @proxy: A #GdmUserVerifierProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_user_verifier_call_answer_query().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_user_verifier_call_answer_query().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_user_verifier_call_answer_query_finish (
    GdmUserVerifier *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_user_verifier_call_answer_query_sync:
 * @proxy: A #GdmUserVerifierProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_answer: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.AnswerQuery">AnswerQuery()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_user_verifier_call_answer_query() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_user_verifier_call_answer_query_sync (
    GdmUserVerifier *proxy,
    const gchar *arg_service_name,
    const gchar *arg_answer,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AnswerQuery",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_answer),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_user_verifier_call_cancel:
 * @proxy: A #GdmUserVerifierProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.Cancel">Cancel()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_user_verifier_call_cancel_finish() to get the result of the operation.
 *
 * See gdm_user_verifier_call_cancel_sync() for the synchronous, blocking version of this method.
 */
void
gdm_user_verifier_call_cancel (
    GdmUserVerifier *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Cancel",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_user_verifier_call_cancel_finish:
 * @proxy: A #GdmUserVerifierProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_user_verifier_call_cancel().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_user_verifier_call_cancel().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_user_verifier_call_cancel_finish (
    GdmUserVerifier *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_user_verifier_call_cancel_sync:
 * @proxy: A #GdmUserVerifierProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.Cancel">Cancel()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_user_verifier_call_cancel() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_user_verifier_call_cancel_sync (
    GdmUserVerifier *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Cancel",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_user_verifier_complete_enable_extensions:
 * @object: A #GdmUserVerifier.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.EnableExtensions">EnableExtensions()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_user_verifier_complete_enable_extensions (
    GdmUserVerifier *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_user_verifier_complete_begin_verification:
 * @object: A #GdmUserVerifier.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.BeginVerification">BeginVerification()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_user_verifier_complete_begin_verification (
    GdmUserVerifier *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_user_verifier_complete_begin_verification_for_user:
 * @object: A #GdmUserVerifier.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.BeginVerificationForUser">BeginVerificationForUser()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_user_verifier_complete_begin_verification_for_user (
    GdmUserVerifier *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_user_verifier_complete_answer_query:
 * @object: A #GdmUserVerifier.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.AnswerQuery">AnswerQuery()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_user_verifier_complete_answer_query (
    GdmUserVerifier *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_user_verifier_complete_cancel:
 * @object: A #GdmUserVerifier.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.Cancel">Cancel()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_user_verifier_complete_cancel (
    GdmUserVerifier *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * GdmUserVerifierProxy:
 *
 * The #GdmUserVerifierProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmUserVerifierProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmUserVerifierProxy.
 */

struct _GdmUserVerifierProxyPrivate
{
  GData *qdata;
};

static void gdm_user_verifier_proxy_iface_init (GdmUserVerifierIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmUserVerifierProxy, gdm_user_verifier_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GdmUserVerifierProxy)
                         G_IMPLEMENT_INTERFACE (GDM_TYPE_USER_VERIFIER, gdm_user_verifier_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmUserVerifierProxy, gdm_user_verifier_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GDM_TYPE_USER_VERIFIER, gdm_user_verifier_proxy_iface_init))

#endif
static void
gdm_user_verifier_proxy_finalize (GObject *object)
{
  GdmUserVerifierProxy *proxy = GDM_USER_VERIFIER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gdm_user_verifier_proxy_parent_class)->finalize (object);
}

static void
gdm_user_verifier_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_user_verifier_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_user_verifier_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gdm_user_verifier_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GDM_TYPE_USER_VERIFIER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_TYPE_USER_VERIFIER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gdm_user_verifier_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GdmUserVerifierProxy *proxy = GDM_USER_VERIFIER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_user_verifier_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_user_verifier_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
gdm_user_verifier_proxy_init (GdmUserVerifierProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gdm_user_verifier_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GDM_TYPE_USER_VERIFIER_PROXY, GdmUserVerifierProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gdm_user_verifier_interface_info ());
}

static void
gdm_user_verifier_proxy_class_init (GdmUserVerifierProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gdm_user_verifier_proxy_finalize;
  gobject_class->get_property = gdm_user_verifier_proxy_get_property;
  gobject_class->set_property = gdm_user_verifier_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gdm_user_verifier_proxy_g_signal;
  proxy_class->g_properties_changed = gdm_user_verifier_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmUserVerifierProxyPrivate));
#endif
}

static void
gdm_user_verifier_proxy_iface_init (GdmUserVerifierIface *iface G_GNUC_UNUSED)
{
}

/**
 * gdm_user_verifier_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier.top_of_page">org.gnome.DisplayManager.UserVerifier</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_user_verifier_proxy_new_finish() to get the result of the operation.
 *
 * See gdm_user_verifier_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_user_verifier_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_TYPE_USER_VERIFIER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.UserVerifier", NULL);
}

/**
 * gdm_user_verifier_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_user_verifier_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_user_verifier_proxy_new().
 *
 * Returns: (transfer full) (type GdmUserVerifierProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmUserVerifier *
gdm_user_verifier_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_USER_VERIFIER (ret);
  else
    return NULL;
}

/**
 * gdm_user_verifier_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier.top_of_page">org.gnome.DisplayManager.UserVerifier</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_user_verifier_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmUserVerifierProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmUserVerifier *
gdm_user_verifier_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_TYPE_USER_VERIFIER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.UserVerifier", NULL);
  if (ret != NULL)
    return GDM_USER_VERIFIER (ret);
  else
    return NULL;
}


/**
 * gdm_user_verifier_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gdm_user_verifier_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_user_verifier_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gdm_user_verifier_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_user_verifier_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_TYPE_USER_VERIFIER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.UserVerifier", NULL);
}

/**
 * gdm_user_verifier_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_user_verifier_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_user_verifier_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GdmUserVerifierProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmUserVerifier *
gdm_user_verifier_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_USER_VERIFIER (ret);
  else
    return NULL;
}

/**
 * gdm_user_verifier_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gdm_user_verifier_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_user_verifier_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmUserVerifierProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmUserVerifier *
gdm_user_verifier_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_TYPE_USER_VERIFIER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.UserVerifier", NULL);
  if (ret != NULL)
    return GDM_USER_VERIFIER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GdmUserVerifierSkeleton:
 *
 * The #GdmUserVerifierSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmUserVerifierSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmUserVerifierSkeleton.
 */

struct _GdmUserVerifierSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gdm_user_verifier_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GdmUserVerifierSkeleton *skeleton = GDM_USER_VERIFIER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GDM_TYPE_USER_VERIFIER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_TYPE_USER_VERIFIER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gdm_user_verifier_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GdmUserVerifierSkeleton *skeleton = GDM_USER_VERIFIER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_user_verifier_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gdm_user_verifier_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GdmUserVerifierSkeleton *skeleton = GDM_USER_VERIFIER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_user_verifier_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gdm_user_verifier_skeleton_vtable =
{
  _gdm_user_verifier_skeleton_handle_method_call,
  _gdm_user_verifier_skeleton_handle_get_property,
  _gdm_user_verifier_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gdm_user_verifier_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gdm_user_verifier_interface_info ();
}

static GDBusInterfaceVTable *
gdm_user_verifier_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gdm_user_verifier_skeleton_vtable;
}

static GVariant *
gdm_user_verifier_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GdmUserVerifierSkeleton *skeleton = GDM_USER_VERIFIER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gdm_user_verifier_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gdm_user_verifier_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gdm_user_verifier_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gdm_user_verifier_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
gdm_user_verifier_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_gdm_user_verifier_on_signal_conversation_started (
    GdmUserVerifier *object,
    const gchar *arg_service_name)
{
  GdmUserVerifierSkeleton *skeleton = GDM_USER_VERIFIER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_service_name));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier", "ConversationStarted",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_user_verifier_on_signal_conversation_stopped (
    GdmUserVerifier *object,
    const gchar *arg_service_name)
{
  GdmUserVerifierSkeleton *skeleton = GDM_USER_VERIFIER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_service_name));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier", "ConversationStopped",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_user_verifier_on_signal_reauthentication_started (
    GdmUserVerifier *object,
    gint arg_pid_of_caller)
{
  GdmUserVerifierSkeleton *skeleton = GDM_USER_VERIFIER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(i)",
                   arg_pid_of_caller));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier", "ReauthenticationStarted",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_user_verifier_on_signal_info (
    GdmUserVerifier *object,
    const gchar *arg_service_name,
    const gchar *arg_info)
{
  GdmUserVerifierSkeleton *skeleton = GDM_USER_VERIFIER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ss)",
                   arg_service_name,
                   arg_info));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier", "Info",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_user_verifier_on_signal_problem (
    GdmUserVerifier *object,
    const gchar *arg_service_name,
    const gchar *arg_problem)
{
  GdmUserVerifierSkeleton *skeleton = GDM_USER_VERIFIER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ss)",
                   arg_service_name,
                   arg_problem));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier", "Problem",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_user_verifier_on_signal_info_query (
    GdmUserVerifier *object,
    const gchar *arg_service_name,
    const gchar *arg_query)
{
  GdmUserVerifierSkeleton *skeleton = GDM_USER_VERIFIER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ss)",
                   arg_service_name,
                   arg_query));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier", "InfoQuery",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_user_verifier_on_signal_secret_info_query (
    GdmUserVerifier *object,
    const gchar *arg_service_name,
    const gchar *arg_query)
{
  GdmUserVerifierSkeleton *skeleton = GDM_USER_VERIFIER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ss)",
                   arg_service_name,
                   arg_query));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier", "SecretInfoQuery",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_user_verifier_on_signal_reset (
    GdmUserVerifier *object)
{
  GdmUserVerifierSkeleton *skeleton = GDM_USER_VERIFIER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier", "Reset",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_user_verifier_on_signal_service_unavailable (
    GdmUserVerifier *object,
    const gchar *arg_service_name,
    const gchar *arg_message)
{
  GdmUserVerifierSkeleton *skeleton = GDM_USER_VERIFIER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ss)",
                   arg_service_name,
                   arg_message));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier", "ServiceUnavailable",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_user_verifier_on_signal_verification_failed (
    GdmUserVerifier *object,
    const gchar *arg_service_name)
{
  GdmUserVerifierSkeleton *skeleton = GDM_USER_VERIFIER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_service_name));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier", "VerificationFailed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_user_verifier_on_signal_verification_complete (
    GdmUserVerifier *object,
    const gchar *arg_service_name)
{
  GdmUserVerifierSkeleton *skeleton = GDM_USER_VERIFIER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_service_name));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier", "VerificationComplete",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void gdm_user_verifier_skeleton_iface_init (GdmUserVerifierIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmUserVerifierSkeleton, gdm_user_verifier_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GdmUserVerifierSkeleton)
                         G_IMPLEMENT_INTERFACE (GDM_TYPE_USER_VERIFIER, gdm_user_verifier_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmUserVerifierSkeleton, gdm_user_verifier_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GDM_TYPE_USER_VERIFIER, gdm_user_verifier_skeleton_iface_init))

#endif
static void
gdm_user_verifier_skeleton_finalize (GObject *object)
{
  GdmUserVerifierSkeleton *skeleton = GDM_USER_VERIFIER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  /* coverity[missing_lock : SUPPRESS] */
  g_clear_pointer (&skeleton->priv->changed_properties_idle_source, g_source_destroy);
#else
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
skeleton->priv->changed_properties_idle_source = NULL;
#endif
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gdm_user_verifier_skeleton_parent_class)->finalize (object);
}

static void
gdm_user_verifier_skeleton_init (GdmUserVerifierSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gdm_user_verifier_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GDM_TYPE_USER_VERIFIER_SKELETON, GdmUserVerifierSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
gdm_user_verifier_skeleton_class_init (GdmUserVerifierSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gdm_user_verifier_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gdm_user_verifier_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gdm_user_verifier_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gdm_user_verifier_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gdm_user_verifier_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmUserVerifierSkeletonPrivate));
#endif
}

static void
gdm_user_verifier_skeleton_iface_init (GdmUserVerifierIface *iface)
{
  iface->conversation_started = _gdm_user_verifier_on_signal_conversation_started;
  iface->conversation_stopped = _gdm_user_verifier_on_signal_conversation_stopped;
  iface->reauthentication_started = _gdm_user_verifier_on_signal_reauthentication_started;
  iface->info = _gdm_user_verifier_on_signal_info;
  iface->problem = _gdm_user_verifier_on_signal_problem;
  iface->info_query = _gdm_user_verifier_on_signal_info_query;
  iface->secret_info_query = _gdm_user_verifier_on_signal_secret_info_query;
  iface->reset = _gdm_user_verifier_on_signal_reset;
  iface->service_unavailable = _gdm_user_verifier_on_signal_service_unavailable;
  iface->verification_failed = _gdm_user_verifier_on_signal_verification_failed;
  iface->verification_complete = _gdm_user_verifier_on_signal_verification_complete;
}

/**
 * gdm_user_verifier_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier.top_of_page">org.gnome.DisplayManager.UserVerifier</link>.
 *
 * Returns: (transfer full) (type GdmUserVerifierSkeleton): The skeleton object.
 */
GdmUserVerifier *
gdm_user_verifier_skeleton_new (void)
{
  return GDM_USER_VERIFIER (g_object_new (GDM_TYPE_USER_VERIFIER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.DisplayManager.UserVerifier.ChoiceList
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GdmUserVerifierChoiceList
 * @title: GdmUserVerifierChoiceList
 * @short_description: Generated C code for the org.gnome.DisplayManager.UserVerifier.ChoiceList D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-ChoiceList.top_of_page">org.gnome.DisplayManager.UserVerifier.ChoiceList</link> D-Bus interface in C.
 */

enum
{
  GDM__USER_VERIFIER_CHOICE_LIST_CHOICE_QUERY,
};

static unsigned GDM__USER_VERIFIER_CHOICE_LIST_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.gnome.DisplayManager.UserVerifier.ChoiceList ---- */

static const _ExtendedGDBusArgInfo _gdm_user_verifier_choice_list_method_info_select_choice_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_choice_list_method_info_select_choice_IN_ARG_choice =
{
  {
    -1,
    (gchar *) "choice",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_user_verifier_choice_list_method_info_select_choice_IN_ARG_pointers[] =
{
  &_gdm_user_verifier_choice_list_method_info_select_choice_IN_ARG_service_name.parent_struct,
  &_gdm_user_verifier_choice_list_method_info_select_choice_IN_ARG_choice.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_user_verifier_choice_list_method_info_select_choice =
{
  {
    -1,
    (gchar *) "SelectChoice",
    (GDBusArgInfo **) &_gdm_user_verifier_choice_list_method_info_select_choice_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-select-choice",
  FALSE
};

static const GDBusMethodInfo * const _gdm_user_verifier_choice_list_method_info_pointers[] =
{
  &_gdm_user_verifier_choice_list_method_info_select_choice.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_choice_list_signal_info_choice_query_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_choice_list_signal_info_choice_query_ARG_prompt_message =
{
  {
    -1,
    (gchar *) "prompt_message",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_choice_list_signal_info_choice_query_ARG_list =
{
  {
    -1,
    (gchar *) "list",
    (gchar *) "a{ss}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_user_verifier_choice_list_signal_info_choice_query_ARG_pointers[] =
{
  &_gdm_user_verifier_choice_list_signal_info_choice_query_ARG_service_name.parent_struct,
  &_gdm_user_verifier_choice_list_signal_info_choice_query_ARG_prompt_message.parent_struct,
  &_gdm_user_verifier_choice_list_signal_info_choice_query_ARG_list.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_user_verifier_choice_list_signal_info_choice_query =
{
  {
    -1,
    (gchar *) "ChoiceQuery",
    (GDBusArgInfo **) &_gdm_user_verifier_choice_list_signal_info_choice_query_ARG_pointers,
    NULL
  },
  "choice-query"
};

static const GDBusSignalInfo * const _gdm_user_verifier_choice_list_signal_info_pointers[] =
{
  &_gdm_user_verifier_choice_list_signal_info_choice_query.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gdm_user_verifier_choice_list_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.DisplayManager.UserVerifier.ChoiceList",
    (GDBusMethodInfo **) &_gdm_user_verifier_choice_list_method_info_pointers,
    (GDBusSignalInfo **) &_gdm_user_verifier_choice_list_signal_info_pointers,
    NULL,
    NULL
  },
  "user-verifier-choice-list",
};


/**
 * gdm_user_verifier_choice_list_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-ChoiceList.top_of_page">org.gnome.DisplayManager.UserVerifier.ChoiceList</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gdm_user_verifier_choice_list_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gdm_user_verifier_choice_list_interface_info.parent_struct;
}

/**
 * gdm_user_verifier_choice_list_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GdmUserVerifierChoiceList interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gdm_user_verifier_choice_list_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
gdm_user_verifier_choice_list_signal_marshal_choice_query (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_user_verifier_choice_list_method_marshal_select_choice (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GdmUserVerifierChoiceList:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-ChoiceList.top_of_page">org.gnome.DisplayManager.UserVerifier.ChoiceList</link>.
 */

/**
 * GdmUserVerifierChoiceListIface:
 * @parent_iface: The parent interface.
 * @handle_select_choice: Handler for the #GdmUserVerifierChoiceList::handle-select-choice signal.
 * @choice_query: Handler for the #GdmUserVerifierChoiceList::choice-query signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-ChoiceList.top_of_page">org.gnome.DisplayManager.UserVerifier.ChoiceList</link>.
 */

typedef GdmUserVerifierChoiceListIface GdmUserVerifierChoiceListInterface;
G_DEFINE_INTERFACE (GdmUserVerifierChoiceList, gdm_user_verifier_choice_list, G_TYPE_OBJECT)

static void
gdm_user_verifier_choice_list_default_init (GdmUserVerifierChoiceListIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GdmUserVerifierChoiceList::handle-select-choice:
   * @object: A #GdmUserVerifierChoiceList.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   * @arg_choice: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier-ChoiceList.SelectChoice">SelectChoice()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_user_verifier_choice_list_complete_select_choice() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-select-choice",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmUserVerifierChoiceListIface, handle_select_choice),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_user_verifier_choice_list_method_marshal_select_choice,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * GdmUserVerifierChoiceList::choice-query:
   * @object: A #GdmUserVerifierChoiceList.
   * @arg_service_name: Argument.
   * @arg_prompt_message: Argument.
   * @arg_list: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier-ChoiceList.ChoiceQuery">"ChoiceQuery"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM__USER_VERIFIER_CHOICE_LIST_SIGNALS[GDM__USER_VERIFIER_CHOICE_LIST_CHOICE_QUERY] =
    g_signal_new ("choice-query",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmUserVerifierChoiceListIface, choice_query),
      NULL,
      NULL,
      gdm_user_verifier_choice_list_signal_marshal_choice_query,
      G_TYPE_NONE,
      3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

}

/**
 * gdm_user_verifier_choice_list_emit_choice_query:
 * @object: A #GdmUserVerifierChoiceList.
 * @arg_service_name: Argument to pass with the signal.
 * @arg_prompt_message: Argument to pass with the signal.
 * @arg_list: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier-ChoiceList.ChoiceQuery">"ChoiceQuery"</link> D-Bus signal.
 */
void
gdm_user_verifier_choice_list_emit_choice_query (
    GdmUserVerifierChoiceList *object,
    const gchar *arg_service_name,
    const gchar *arg_prompt_message,
    GVariant *arg_list)
{
  g_signal_emit (object, GDM__USER_VERIFIER_CHOICE_LIST_SIGNALS[GDM__USER_VERIFIER_CHOICE_LIST_CHOICE_QUERY], 0, arg_service_name, arg_prompt_message, arg_list);
}

/**
 * gdm_user_verifier_choice_list_call_select_choice:
 * @proxy: A #GdmUserVerifierChoiceListProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_choice: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier-ChoiceList.SelectChoice">SelectChoice()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_user_verifier_choice_list_call_select_choice_finish() to get the result of the operation.
 *
 * See gdm_user_verifier_choice_list_call_select_choice_sync() for the synchronous, blocking version of this method.
 */
void
gdm_user_verifier_choice_list_call_select_choice (
    GdmUserVerifierChoiceList *proxy,
    const gchar *arg_service_name,
    const gchar *arg_choice,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SelectChoice",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_choice),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_user_verifier_choice_list_call_select_choice_finish:
 * @proxy: A #GdmUserVerifierChoiceListProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_user_verifier_choice_list_call_select_choice().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_user_verifier_choice_list_call_select_choice().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_user_verifier_choice_list_call_select_choice_finish (
    GdmUserVerifierChoiceList *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_user_verifier_choice_list_call_select_choice_sync:
 * @proxy: A #GdmUserVerifierChoiceListProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_choice: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier-ChoiceList.SelectChoice">SelectChoice()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_user_verifier_choice_list_call_select_choice() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_user_verifier_choice_list_call_select_choice_sync (
    GdmUserVerifierChoiceList *proxy,
    const gchar *arg_service_name,
    const gchar *arg_choice,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SelectChoice",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_choice),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_user_verifier_choice_list_complete_select_choice:
 * @object: A #GdmUserVerifierChoiceList.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier-ChoiceList.SelectChoice">SelectChoice()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_user_verifier_choice_list_complete_select_choice (
    GdmUserVerifierChoiceList *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * GdmUserVerifierChoiceListProxy:
 *
 * The #GdmUserVerifierChoiceListProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmUserVerifierChoiceListProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmUserVerifierChoiceListProxy.
 */

struct _GdmUserVerifierChoiceListProxyPrivate
{
  GData *qdata;
};

static void gdm_user_verifier_choice_list_proxy_iface_init (GdmUserVerifierChoiceListIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmUserVerifierChoiceListProxy, gdm_user_verifier_choice_list_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GdmUserVerifierChoiceListProxy)
                         G_IMPLEMENT_INTERFACE (GDM_TYPE_USER_VERIFIER_CHOICE_LIST, gdm_user_verifier_choice_list_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmUserVerifierChoiceListProxy, gdm_user_verifier_choice_list_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GDM_TYPE_USER_VERIFIER_CHOICE_LIST, gdm_user_verifier_choice_list_proxy_iface_init))

#endif
static void
gdm_user_verifier_choice_list_proxy_finalize (GObject *object)
{
  GdmUserVerifierChoiceListProxy *proxy = GDM_USER_VERIFIER_CHOICE_LIST_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gdm_user_verifier_choice_list_proxy_parent_class)->finalize (object);
}

static void
gdm_user_verifier_choice_list_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_user_verifier_choice_list_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_user_verifier_choice_list_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gdm_user_verifier_choice_list_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GDM_TYPE_USER_VERIFIER_CHOICE_LIST);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_TYPE_USER_VERIFIER_CHOICE_LIST);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gdm_user_verifier_choice_list_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GdmUserVerifierChoiceListProxy *proxy = GDM_USER_VERIFIER_CHOICE_LIST_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_user_verifier_choice_list_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_user_verifier_choice_list_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
gdm_user_verifier_choice_list_proxy_init (GdmUserVerifierChoiceListProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gdm_user_verifier_choice_list_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GDM_TYPE_USER_VERIFIER_CHOICE_LIST_PROXY, GdmUserVerifierChoiceListProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gdm_user_verifier_choice_list_interface_info ());
}

static void
gdm_user_verifier_choice_list_proxy_class_init (GdmUserVerifierChoiceListProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gdm_user_verifier_choice_list_proxy_finalize;
  gobject_class->get_property = gdm_user_verifier_choice_list_proxy_get_property;
  gobject_class->set_property = gdm_user_verifier_choice_list_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gdm_user_verifier_choice_list_proxy_g_signal;
  proxy_class->g_properties_changed = gdm_user_verifier_choice_list_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmUserVerifierChoiceListProxyPrivate));
#endif
}

static void
gdm_user_verifier_choice_list_proxy_iface_init (GdmUserVerifierChoiceListIface *iface G_GNUC_UNUSED)
{
}

/**
 * gdm_user_verifier_choice_list_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-ChoiceList.top_of_page">org.gnome.DisplayManager.UserVerifier.ChoiceList</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_user_verifier_choice_list_proxy_new_finish() to get the result of the operation.
 *
 * See gdm_user_verifier_choice_list_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_user_verifier_choice_list_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_TYPE_USER_VERIFIER_CHOICE_LIST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.UserVerifier.ChoiceList", NULL);
}

/**
 * gdm_user_verifier_choice_list_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_user_verifier_choice_list_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_user_verifier_choice_list_proxy_new().
 *
 * Returns: (transfer full) (type GdmUserVerifierChoiceListProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmUserVerifierChoiceList *
gdm_user_verifier_choice_list_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_USER_VERIFIER_CHOICE_LIST (ret);
  else
    return NULL;
}

/**
 * gdm_user_verifier_choice_list_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-ChoiceList.top_of_page">org.gnome.DisplayManager.UserVerifier.ChoiceList</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_user_verifier_choice_list_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmUserVerifierChoiceListProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmUserVerifierChoiceList *
gdm_user_verifier_choice_list_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_TYPE_USER_VERIFIER_CHOICE_LIST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.UserVerifier.ChoiceList", NULL);
  if (ret != NULL)
    return GDM_USER_VERIFIER_CHOICE_LIST (ret);
  else
    return NULL;
}


/**
 * gdm_user_verifier_choice_list_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gdm_user_verifier_choice_list_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_user_verifier_choice_list_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gdm_user_verifier_choice_list_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_user_verifier_choice_list_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_TYPE_USER_VERIFIER_CHOICE_LIST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.UserVerifier.ChoiceList", NULL);
}

/**
 * gdm_user_verifier_choice_list_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_user_verifier_choice_list_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_user_verifier_choice_list_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GdmUserVerifierChoiceListProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmUserVerifierChoiceList *
gdm_user_verifier_choice_list_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_USER_VERIFIER_CHOICE_LIST (ret);
  else
    return NULL;
}

/**
 * gdm_user_verifier_choice_list_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gdm_user_verifier_choice_list_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_user_verifier_choice_list_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmUserVerifierChoiceListProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmUserVerifierChoiceList *
gdm_user_verifier_choice_list_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_TYPE_USER_VERIFIER_CHOICE_LIST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.UserVerifier.ChoiceList", NULL);
  if (ret != NULL)
    return GDM_USER_VERIFIER_CHOICE_LIST (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GdmUserVerifierChoiceListSkeleton:
 *
 * The #GdmUserVerifierChoiceListSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmUserVerifierChoiceListSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmUserVerifierChoiceListSkeleton.
 */

struct _GdmUserVerifierChoiceListSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gdm_user_verifier_choice_list_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GdmUserVerifierChoiceListSkeleton *skeleton = GDM_USER_VERIFIER_CHOICE_LIST_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GDM_TYPE_USER_VERIFIER_CHOICE_LIST);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_TYPE_USER_VERIFIER_CHOICE_LIST);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gdm_user_verifier_choice_list_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GdmUserVerifierChoiceListSkeleton *skeleton = GDM_USER_VERIFIER_CHOICE_LIST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_user_verifier_choice_list_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gdm_user_verifier_choice_list_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GdmUserVerifierChoiceListSkeleton *skeleton = GDM_USER_VERIFIER_CHOICE_LIST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_user_verifier_choice_list_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gdm_user_verifier_choice_list_skeleton_vtable =
{
  _gdm_user_verifier_choice_list_skeleton_handle_method_call,
  _gdm_user_verifier_choice_list_skeleton_handle_get_property,
  _gdm_user_verifier_choice_list_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gdm_user_verifier_choice_list_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gdm_user_verifier_choice_list_interface_info ();
}

static GDBusInterfaceVTable *
gdm_user_verifier_choice_list_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gdm_user_verifier_choice_list_skeleton_vtable;
}

static GVariant *
gdm_user_verifier_choice_list_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GdmUserVerifierChoiceListSkeleton *skeleton = GDM_USER_VERIFIER_CHOICE_LIST_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gdm_user_verifier_choice_list_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gdm_user_verifier_choice_list_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gdm_user_verifier_choice_list_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gdm_user_verifier_choice_list_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier.ChoiceList", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
gdm_user_verifier_choice_list_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_gdm_user_verifier_choice_list_on_signal_choice_query (
    GdmUserVerifierChoiceList *object,
    const gchar *arg_service_name,
    const gchar *arg_prompt_message,
    GVariant *arg_list)
{
  GdmUserVerifierChoiceListSkeleton *skeleton = GDM_USER_VERIFIER_CHOICE_LIST_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ss@a{ss})",
                   arg_service_name,
                   arg_prompt_message,
                   arg_list));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier.ChoiceList", "ChoiceQuery",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void gdm_user_verifier_choice_list_skeleton_iface_init (GdmUserVerifierChoiceListIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmUserVerifierChoiceListSkeleton, gdm_user_verifier_choice_list_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GdmUserVerifierChoiceListSkeleton)
                         G_IMPLEMENT_INTERFACE (GDM_TYPE_USER_VERIFIER_CHOICE_LIST, gdm_user_verifier_choice_list_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmUserVerifierChoiceListSkeleton, gdm_user_verifier_choice_list_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GDM_TYPE_USER_VERIFIER_CHOICE_LIST, gdm_user_verifier_choice_list_skeleton_iface_init))

#endif
static void
gdm_user_verifier_choice_list_skeleton_finalize (GObject *object)
{
  GdmUserVerifierChoiceListSkeleton *skeleton = GDM_USER_VERIFIER_CHOICE_LIST_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  /* coverity[missing_lock : SUPPRESS] */
  g_clear_pointer (&skeleton->priv->changed_properties_idle_source, g_source_destroy);
#else
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
skeleton->priv->changed_properties_idle_source = NULL;
#endif
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gdm_user_verifier_choice_list_skeleton_parent_class)->finalize (object);
}

static void
gdm_user_verifier_choice_list_skeleton_init (GdmUserVerifierChoiceListSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gdm_user_verifier_choice_list_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GDM_TYPE_USER_VERIFIER_CHOICE_LIST_SKELETON, GdmUserVerifierChoiceListSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
gdm_user_verifier_choice_list_skeleton_class_init (GdmUserVerifierChoiceListSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gdm_user_verifier_choice_list_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gdm_user_verifier_choice_list_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gdm_user_verifier_choice_list_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gdm_user_verifier_choice_list_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gdm_user_verifier_choice_list_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmUserVerifierChoiceListSkeletonPrivate));
#endif
}

static void
gdm_user_verifier_choice_list_skeleton_iface_init (GdmUserVerifierChoiceListIface *iface)
{
  iface->choice_query = _gdm_user_verifier_choice_list_on_signal_choice_query;
}

/**
 * gdm_user_verifier_choice_list_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-ChoiceList.top_of_page">org.gnome.DisplayManager.UserVerifier.ChoiceList</link>.
 *
 * Returns: (transfer full) (type GdmUserVerifierChoiceListSkeleton): The skeleton object.
 */
GdmUserVerifierChoiceList *
gdm_user_verifier_choice_list_skeleton_new (void)
{
  return GDM_USER_VERIFIER_CHOICE_LIST (g_object_new (GDM_TYPE_USER_VERIFIER_CHOICE_LIST_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.DisplayManager.UserVerifier.CustomJSON
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GdmUserVerifierCustomJSON
 * @title: GdmUserVerifierCustomJSON
 * @short_description: Generated C code for the org.gnome.DisplayManager.UserVerifier.CustomJSON D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-CustomJSON.top_of_page">org.gnome.DisplayManager.UserVerifier.CustomJSON</link> D-Bus interface in C.
 */

enum
{
  GDM__USER_VERIFIER_CUSTOM_JSON_REQUEST,
};

static unsigned GDM__USER_VERIFIER_CUSTOM_JSON_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.gnome.DisplayManager.UserVerifier.CustomJSON ---- */

static const _ExtendedGDBusArgInfo _gdm_user_verifier_custom_json_method_info_reply_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_custom_json_method_info_reply_IN_ARG_reply =
{
  {
    -1,
    (gchar *) "reply",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_user_verifier_custom_json_method_info_reply_IN_ARG_pointers[] =
{
  &_gdm_user_verifier_custom_json_method_info_reply_IN_ARG_service_name.parent_struct,
  &_gdm_user_verifier_custom_json_method_info_reply_IN_ARG_reply.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_user_verifier_custom_json_method_info_reply =
{
  {
    -1,
    (gchar *) "Reply",
    (GDBusArgInfo **) &_gdm_user_verifier_custom_json_method_info_reply_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-reply",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_custom_json_method_info_report_error_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_custom_json_method_info_report_error_IN_ARG_error =
{
  {
    -1,
    (gchar *) "error",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_user_verifier_custom_json_method_info_report_error_IN_ARG_pointers[] =
{
  &_gdm_user_verifier_custom_json_method_info_report_error_IN_ARG_service_name.parent_struct,
  &_gdm_user_verifier_custom_json_method_info_report_error_IN_ARG_error.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_user_verifier_custom_json_method_info_report_error =
{
  {
    -1,
    (gchar *) "ReportError",
    (GDBusArgInfo **) &_gdm_user_verifier_custom_json_method_info_report_error_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-report-error",
  FALSE
};

static const GDBusMethodInfo * const _gdm_user_verifier_custom_json_method_info_pointers[] =
{
  &_gdm_user_verifier_custom_json_method_info_reply.parent_struct,
  &_gdm_user_verifier_custom_json_method_info_report_error.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_custom_json_signal_info_request_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_custom_json_signal_info_request_ARG_protocol =
{
  {
    -1,
    (gchar *) "protocol",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_custom_json_signal_info_request_ARG_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_user_verifier_custom_json_signal_info_request_ARG_request =
{
  {
    -1,
    (gchar *) "request",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_user_verifier_custom_json_signal_info_request_ARG_pointers[] =
{
  &_gdm_user_verifier_custom_json_signal_info_request_ARG_service_name.parent_struct,
  &_gdm_user_verifier_custom_json_signal_info_request_ARG_protocol.parent_struct,
  &_gdm_user_verifier_custom_json_signal_info_request_ARG_version.parent_struct,
  &_gdm_user_verifier_custom_json_signal_info_request_ARG_request.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_user_verifier_custom_json_signal_info_request =
{
  {
    -1,
    (gchar *) "Request",
    (GDBusArgInfo **) &_gdm_user_verifier_custom_json_signal_info_request_ARG_pointers,
    NULL
  },
  "request"
};

static const GDBusSignalInfo * const _gdm_user_verifier_custom_json_signal_info_pointers[] =
{
  &_gdm_user_verifier_custom_json_signal_info_request.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gdm_user_verifier_custom_json_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.DisplayManager.UserVerifier.CustomJSON",
    (GDBusMethodInfo **) &_gdm_user_verifier_custom_json_method_info_pointers,
    (GDBusSignalInfo **) &_gdm_user_verifier_custom_json_signal_info_pointers,
    NULL,
    NULL
  },
  "user-verifier-custom-json",
};


/**
 * gdm_user_verifier_custom_json_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-CustomJSON.top_of_page">org.gnome.DisplayManager.UserVerifier.CustomJSON</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gdm_user_verifier_custom_json_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gdm_user_verifier_custom_json_interface_info.parent_struct;
}

/**
 * gdm_user_verifier_custom_json_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GdmUserVerifierCustomJSON interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gdm_user_verifier_custom_json_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
gdm_user_verifier_custom_json_signal_marshal_request (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING_UINT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_user_verifier_custom_json_method_marshal_reply (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_user_verifier_custom_json_method_marshal_report_error (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GdmUserVerifierCustomJSON:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-CustomJSON.top_of_page">org.gnome.DisplayManager.UserVerifier.CustomJSON</link>.
 */

/**
 * GdmUserVerifierCustomJSONIface:
 * @parent_iface: The parent interface.
 * @handle_reply: Handler for the #GdmUserVerifierCustomJSON::handle-reply signal.
 * @handle_report_error: Handler for the #GdmUserVerifierCustomJSON::handle-report-error signal.
 * @request: Handler for the #GdmUserVerifierCustomJSON::request signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-CustomJSON.top_of_page">org.gnome.DisplayManager.UserVerifier.CustomJSON</link>.
 */

typedef GdmUserVerifierCustomJSONIface GdmUserVerifierCustomJSONInterface;
G_DEFINE_INTERFACE (GdmUserVerifierCustomJSON, gdm_user_verifier_custom_json, G_TYPE_OBJECT)

static void
gdm_user_verifier_custom_json_default_init (GdmUserVerifierCustomJSONIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GdmUserVerifierCustomJSON::handle-reply:
   * @object: A #GdmUserVerifierCustomJSON.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   * @arg_reply: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier-CustomJSON.Reply">Reply()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_user_verifier_custom_json_complete_reply() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reply",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmUserVerifierCustomJSONIface, handle_reply),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_user_verifier_custom_json_method_marshal_reply,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmUserVerifierCustomJSON::handle-report-error:
   * @object: A #GdmUserVerifierCustomJSON.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   * @arg_error: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier-CustomJSON.ReportError">ReportError()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_user_verifier_custom_json_complete_report_error() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-report-error",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmUserVerifierCustomJSONIface, handle_report_error),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_user_verifier_custom_json_method_marshal_report_error,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * GdmUserVerifierCustomJSON::request:
   * @object: A #GdmUserVerifierCustomJSON.
   * @arg_service_name: Argument.
   * @arg_protocol: Argument.
   * @arg_version: Argument.
   * @arg_request: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier-CustomJSON.Request">"Request"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM__USER_VERIFIER_CUSTOM_JSON_SIGNALS[GDM__USER_VERIFIER_CUSTOM_JSON_REQUEST] =
    g_signal_new ("request",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmUserVerifierCustomJSONIface, request),
      NULL,
      NULL,
      gdm_user_verifier_custom_json_signal_marshal_request,
      G_TYPE_NONE,
      4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING);

}

/**
 * gdm_user_verifier_custom_json_emit_request:
 * @object: A #GdmUserVerifierCustomJSON.
 * @arg_service_name: Argument to pass with the signal.
 * @arg_protocol: Argument to pass with the signal.
 * @arg_version: Argument to pass with the signal.
 * @arg_request: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier-CustomJSON.Request">"Request"</link> D-Bus signal.
 */
void
gdm_user_verifier_custom_json_emit_request (
    GdmUserVerifierCustomJSON *object,
    const gchar *arg_service_name,
    const gchar *arg_protocol,
    guint arg_version,
    const gchar *arg_request)
{
  g_signal_emit (object, GDM__USER_VERIFIER_CUSTOM_JSON_SIGNALS[GDM__USER_VERIFIER_CUSTOM_JSON_REQUEST], 0, arg_service_name, arg_protocol, arg_version, arg_request);
}

/**
 * gdm_user_verifier_custom_json_call_reply:
 * @proxy: A #GdmUserVerifierCustomJSONProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_reply: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier-CustomJSON.Reply">Reply()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_user_verifier_custom_json_call_reply_finish() to get the result of the operation.
 *
 * See gdm_user_verifier_custom_json_call_reply_sync() for the synchronous, blocking version of this method.
 */
void
gdm_user_verifier_custom_json_call_reply (
    GdmUserVerifierCustomJSON *proxy,
    const gchar *arg_service_name,
    const gchar *arg_reply,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Reply",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_reply),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_user_verifier_custom_json_call_reply_finish:
 * @proxy: A #GdmUserVerifierCustomJSONProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_user_verifier_custom_json_call_reply().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_user_verifier_custom_json_call_reply().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_user_verifier_custom_json_call_reply_finish (
    GdmUserVerifierCustomJSON *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_user_verifier_custom_json_call_reply_sync:
 * @proxy: A #GdmUserVerifierCustomJSONProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_reply: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier-CustomJSON.Reply">Reply()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_user_verifier_custom_json_call_reply() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_user_verifier_custom_json_call_reply_sync (
    GdmUserVerifierCustomJSON *proxy,
    const gchar *arg_service_name,
    const gchar *arg_reply,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Reply",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_reply),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_user_verifier_custom_json_call_report_error:
 * @proxy: A #GdmUserVerifierCustomJSONProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_error: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier-CustomJSON.ReportError">ReportError()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_user_verifier_custom_json_call_report_error_finish() to get the result of the operation.
 *
 * See gdm_user_verifier_custom_json_call_report_error_sync() for the synchronous, blocking version of this method.
 */
void
gdm_user_verifier_custom_json_call_report_error (
    GdmUserVerifierCustomJSON *proxy,
    const gchar *arg_service_name,
    const gchar *arg_error,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReportError",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_error),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_user_verifier_custom_json_call_report_error_finish:
 * @proxy: A #GdmUserVerifierCustomJSONProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_user_verifier_custom_json_call_report_error().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_user_verifier_custom_json_call_report_error().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_user_verifier_custom_json_call_report_error_finish (
    GdmUserVerifierCustomJSON *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_user_verifier_custom_json_call_report_error_sync:
 * @proxy: A #GdmUserVerifierCustomJSONProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_error: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier-CustomJSON.ReportError">ReportError()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_user_verifier_custom_json_call_report_error() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_user_verifier_custom_json_call_report_error_sync (
    GdmUserVerifierCustomJSON *proxy,
    const gchar *arg_service_name,
    const gchar *arg_error,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReportError",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_error),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_user_verifier_custom_json_complete_reply:
 * @object: A #GdmUserVerifierCustomJSON.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier-CustomJSON.Reply">Reply()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_user_verifier_custom_json_complete_reply (
    GdmUserVerifierCustomJSON *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_user_verifier_custom_json_complete_report_error:
 * @object: A #GdmUserVerifierCustomJSON.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier-CustomJSON.ReportError">ReportError()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_user_verifier_custom_json_complete_report_error (
    GdmUserVerifierCustomJSON *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * GdmUserVerifierCustomJSONProxy:
 *
 * The #GdmUserVerifierCustomJSONProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmUserVerifierCustomJSONProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmUserVerifierCustomJSONProxy.
 */

struct _GdmUserVerifierCustomJSONProxyPrivate
{
  GData *qdata;
};

static void gdm_user_verifier_custom_json_proxy_iface_init (GdmUserVerifierCustomJSONIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmUserVerifierCustomJSONProxy, gdm_user_verifier_custom_json_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GdmUserVerifierCustomJSONProxy)
                         G_IMPLEMENT_INTERFACE (GDM_TYPE_USER_VERIFIER_CUSTOM_JSON, gdm_user_verifier_custom_json_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmUserVerifierCustomJSONProxy, gdm_user_verifier_custom_json_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GDM_TYPE_USER_VERIFIER_CUSTOM_JSON, gdm_user_verifier_custom_json_proxy_iface_init))

#endif
static void
gdm_user_verifier_custom_json_proxy_finalize (GObject *object)
{
  GdmUserVerifierCustomJSONProxy *proxy = GDM_USER_VERIFIER_CUSTOM_JSON_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gdm_user_verifier_custom_json_proxy_parent_class)->finalize (object);
}

static void
gdm_user_verifier_custom_json_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_user_verifier_custom_json_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_user_verifier_custom_json_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gdm_user_verifier_custom_json_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GDM_TYPE_USER_VERIFIER_CUSTOM_JSON);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_TYPE_USER_VERIFIER_CUSTOM_JSON);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gdm_user_verifier_custom_json_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GdmUserVerifierCustomJSONProxy *proxy = GDM_USER_VERIFIER_CUSTOM_JSON_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_user_verifier_custom_json_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_user_verifier_custom_json_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
gdm_user_verifier_custom_json_proxy_init (GdmUserVerifierCustomJSONProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gdm_user_verifier_custom_json_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GDM_TYPE_USER_VERIFIER_CUSTOM_JSON_PROXY, GdmUserVerifierCustomJSONProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gdm_user_verifier_custom_json_interface_info ());
}

static void
gdm_user_verifier_custom_json_proxy_class_init (GdmUserVerifierCustomJSONProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gdm_user_verifier_custom_json_proxy_finalize;
  gobject_class->get_property = gdm_user_verifier_custom_json_proxy_get_property;
  gobject_class->set_property = gdm_user_verifier_custom_json_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gdm_user_verifier_custom_json_proxy_g_signal;
  proxy_class->g_properties_changed = gdm_user_verifier_custom_json_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmUserVerifierCustomJSONProxyPrivate));
#endif
}

static void
gdm_user_verifier_custom_json_proxy_iface_init (GdmUserVerifierCustomJSONIface *iface G_GNUC_UNUSED)
{
}

/**
 * gdm_user_verifier_custom_json_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-CustomJSON.top_of_page">org.gnome.DisplayManager.UserVerifier.CustomJSON</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_user_verifier_custom_json_proxy_new_finish() to get the result of the operation.
 *
 * See gdm_user_verifier_custom_json_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_user_verifier_custom_json_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_TYPE_USER_VERIFIER_CUSTOM_JSON_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.UserVerifier.CustomJSON", NULL);
}

/**
 * gdm_user_verifier_custom_json_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_user_verifier_custom_json_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_user_verifier_custom_json_proxy_new().
 *
 * Returns: (transfer full) (type GdmUserVerifierCustomJSONProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmUserVerifierCustomJSON *
gdm_user_verifier_custom_json_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_USER_VERIFIER_CUSTOM_JSON (ret);
  else
    return NULL;
}

/**
 * gdm_user_verifier_custom_json_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-CustomJSON.top_of_page">org.gnome.DisplayManager.UserVerifier.CustomJSON</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_user_verifier_custom_json_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmUserVerifierCustomJSONProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmUserVerifierCustomJSON *
gdm_user_verifier_custom_json_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_TYPE_USER_VERIFIER_CUSTOM_JSON_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.UserVerifier.CustomJSON", NULL);
  if (ret != NULL)
    return GDM_USER_VERIFIER_CUSTOM_JSON (ret);
  else
    return NULL;
}


/**
 * gdm_user_verifier_custom_json_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gdm_user_verifier_custom_json_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_user_verifier_custom_json_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gdm_user_verifier_custom_json_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_user_verifier_custom_json_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_TYPE_USER_VERIFIER_CUSTOM_JSON_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.UserVerifier.CustomJSON", NULL);
}

/**
 * gdm_user_verifier_custom_json_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_user_verifier_custom_json_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_user_verifier_custom_json_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GdmUserVerifierCustomJSONProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmUserVerifierCustomJSON *
gdm_user_verifier_custom_json_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_USER_VERIFIER_CUSTOM_JSON (ret);
  else
    return NULL;
}

/**
 * gdm_user_verifier_custom_json_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gdm_user_verifier_custom_json_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_user_verifier_custom_json_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmUserVerifierCustomJSONProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmUserVerifierCustomJSON *
gdm_user_verifier_custom_json_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_TYPE_USER_VERIFIER_CUSTOM_JSON_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.UserVerifier.CustomJSON", NULL);
  if (ret != NULL)
    return GDM_USER_VERIFIER_CUSTOM_JSON (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GdmUserVerifierCustomJSONSkeleton:
 *
 * The #GdmUserVerifierCustomJSONSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmUserVerifierCustomJSONSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmUserVerifierCustomJSONSkeleton.
 */

struct _GdmUserVerifierCustomJSONSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gdm_user_verifier_custom_json_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GdmUserVerifierCustomJSONSkeleton *skeleton = GDM_USER_VERIFIER_CUSTOM_JSON_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GDM_TYPE_USER_VERIFIER_CUSTOM_JSON);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_TYPE_USER_VERIFIER_CUSTOM_JSON);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gdm_user_verifier_custom_json_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GdmUserVerifierCustomJSONSkeleton *skeleton = GDM_USER_VERIFIER_CUSTOM_JSON_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_user_verifier_custom_json_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gdm_user_verifier_custom_json_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GdmUserVerifierCustomJSONSkeleton *skeleton = GDM_USER_VERIFIER_CUSTOM_JSON_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_user_verifier_custom_json_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gdm_user_verifier_custom_json_skeleton_vtable =
{
  _gdm_user_verifier_custom_json_skeleton_handle_method_call,
  _gdm_user_verifier_custom_json_skeleton_handle_get_property,
  _gdm_user_verifier_custom_json_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gdm_user_verifier_custom_json_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gdm_user_verifier_custom_json_interface_info ();
}

static GDBusInterfaceVTable *
gdm_user_verifier_custom_json_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gdm_user_verifier_custom_json_skeleton_vtable;
}

static GVariant *
gdm_user_verifier_custom_json_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GdmUserVerifierCustomJSONSkeleton *skeleton = GDM_USER_VERIFIER_CUSTOM_JSON_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gdm_user_verifier_custom_json_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gdm_user_verifier_custom_json_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gdm_user_verifier_custom_json_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gdm_user_verifier_custom_json_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier.CustomJSON", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
gdm_user_verifier_custom_json_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_gdm_user_verifier_custom_json_on_signal_request (
    GdmUserVerifierCustomJSON *object,
    const gchar *arg_service_name,
    const gchar *arg_protocol,
    guint arg_version,
    const gchar *arg_request)
{
  GdmUserVerifierCustomJSONSkeleton *skeleton = GDM_USER_VERIFIER_CUSTOM_JSON_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ssus)",
                   arg_service_name,
                   arg_protocol,
                   arg_version,
                   arg_request));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier.CustomJSON", "Request",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void gdm_user_verifier_custom_json_skeleton_iface_init (GdmUserVerifierCustomJSONIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmUserVerifierCustomJSONSkeleton, gdm_user_verifier_custom_json_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GdmUserVerifierCustomJSONSkeleton)
                         G_IMPLEMENT_INTERFACE (GDM_TYPE_USER_VERIFIER_CUSTOM_JSON, gdm_user_verifier_custom_json_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmUserVerifierCustomJSONSkeleton, gdm_user_verifier_custom_json_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GDM_TYPE_USER_VERIFIER_CUSTOM_JSON, gdm_user_verifier_custom_json_skeleton_iface_init))

#endif
static void
gdm_user_verifier_custom_json_skeleton_finalize (GObject *object)
{
  GdmUserVerifierCustomJSONSkeleton *skeleton = GDM_USER_VERIFIER_CUSTOM_JSON_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  /* coverity[missing_lock : SUPPRESS] */
  g_clear_pointer (&skeleton->priv->changed_properties_idle_source, g_source_destroy);
#else
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
skeleton->priv->changed_properties_idle_source = NULL;
#endif
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gdm_user_verifier_custom_json_skeleton_parent_class)->finalize (object);
}

static void
gdm_user_verifier_custom_json_skeleton_init (GdmUserVerifierCustomJSONSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gdm_user_verifier_custom_json_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GDM_TYPE_USER_VERIFIER_CUSTOM_JSON_SKELETON, GdmUserVerifierCustomJSONSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
gdm_user_verifier_custom_json_skeleton_class_init (GdmUserVerifierCustomJSONSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gdm_user_verifier_custom_json_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gdm_user_verifier_custom_json_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gdm_user_verifier_custom_json_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gdm_user_verifier_custom_json_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gdm_user_verifier_custom_json_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmUserVerifierCustomJSONSkeletonPrivate));
#endif
}

static void
gdm_user_verifier_custom_json_skeleton_iface_init (GdmUserVerifierCustomJSONIface *iface)
{
  iface->request = _gdm_user_verifier_custom_json_on_signal_request;
}

/**
 * gdm_user_verifier_custom_json_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-CustomJSON.top_of_page">org.gnome.DisplayManager.UserVerifier.CustomJSON</link>.
 *
 * Returns: (transfer full) (type GdmUserVerifierCustomJSONSkeleton): The skeleton object.
 */
GdmUserVerifierCustomJSON *
gdm_user_verifier_custom_json_skeleton_new (void)
{
  return GDM_USER_VERIFIER_CUSTOM_JSON (g_object_new (GDM_TYPE_USER_VERIFIER_CUSTOM_JSON_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.DisplayManager.Greeter
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GdmGreeter
 * @title: GdmGreeter
 * @short_description: Generated C code for the org.gnome.DisplayManager.Greeter D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-DisplayManager-Greeter.top_of_page">org.gnome.DisplayManager.Greeter</link> D-Bus interface in C.
 */

enum
{
  GDM__GREETER_SELECTED_USER_CHANGED,
  GDM__GREETER_DEFAULT_LANGUAGE_NAME_CHANGED,
  GDM__GREETER_DEFAULT_SESSION_NAME_CHANGED,
  GDM__GREETER_TIMED_LOGIN_REQUESTED,
  GDM__GREETER_SESSION_OPENED,
  GDM__GREETER_REAUTHENTICATED,
};

static unsigned GDM__GREETER_SIGNALS[6] = { 0 };

/* ---- Introspection data for org.gnome.DisplayManager.Greeter ---- */

static const _ExtendedGDBusArgInfo _gdm_greeter_method_info_select_session_IN_ARG_session =
{
  {
    -1,
    (gchar *) "session",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_greeter_method_info_select_session_IN_ARG_pointers[] =
{
  &_gdm_greeter_method_info_select_session_IN_ARG_session.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_greeter_method_info_select_session =
{
  {
    -1,
    (gchar *) "SelectSession",
    (GDBusArgInfo **) &_gdm_greeter_method_info_select_session_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-select-session",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_greeter_method_info_select_user_IN_ARG_username =
{
  {
    -1,
    (gchar *) "username",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_greeter_method_info_select_user_IN_ARG_pointers[] =
{
  &_gdm_greeter_method_info_select_user_IN_ARG_username.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_greeter_method_info_select_user =
{
  {
    -1,
    (gchar *) "SelectUser",
    (GDBusArgInfo **) &_gdm_greeter_method_info_select_user_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-select-user",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_greeter_method_info_begin_auto_login_IN_ARG_username =
{
  {
    -1,
    (gchar *) "username",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_greeter_method_info_begin_auto_login_IN_ARG_pointers[] =
{
  &_gdm_greeter_method_info_begin_auto_login_IN_ARG_username.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_greeter_method_info_begin_auto_login =
{
  {
    -1,
    (gchar *) "BeginAutoLogin",
    (GDBusArgInfo **) &_gdm_greeter_method_info_begin_auto_login_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-begin-auto-login",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_greeter_method_info_get_timed_login_details_OUT_ARG_enabled =
{
  {
    -1,
    (gchar *) "enabled",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_greeter_method_info_get_timed_login_details_OUT_ARG_username =
{
  {
    -1,
    (gchar *) "username",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_greeter_method_info_get_timed_login_details_OUT_ARG_delay =
{
  {
    -1,
    (gchar *) "delay",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_greeter_method_info_get_timed_login_details_OUT_ARG_pointers[] =
{
  &_gdm_greeter_method_info_get_timed_login_details_OUT_ARG_enabled.parent_struct,
  &_gdm_greeter_method_info_get_timed_login_details_OUT_ARG_username.parent_struct,
  &_gdm_greeter_method_info_get_timed_login_details_OUT_ARG_delay.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_greeter_method_info_get_timed_login_details =
{
  {
    -1,
    (gchar *) "GetTimedLoginDetails",
    NULL,
    (GDBusArgInfo **) &_gdm_greeter_method_info_get_timed_login_details_OUT_ARG_pointers,
    NULL
  },
  "handle-get-timed-login-details",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_greeter_method_info_start_session_when_ready_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_greeter_method_info_start_session_when_ready_IN_ARG_should_start_session =
{
  {
    -1,
    (gchar *) "should_start_session",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_greeter_method_info_start_session_when_ready_IN_ARG_pointers[] =
{
  &_gdm_greeter_method_info_start_session_when_ready_IN_ARG_service_name.parent_struct,
  &_gdm_greeter_method_info_start_session_when_ready_IN_ARG_should_start_session.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_greeter_method_info_start_session_when_ready =
{
  {
    -1,
    (gchar *) "StartSessionWhenReady",
    (GDBusArgInfo **) &_gdm_greeter_method_info_start_session_when_ready_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-start-session-when-ready",
  FALSE
};

static const _ExtendedGDBusMethodInfo _gdm_greeter_method_info_stop_conflicting_session =
{
  {
    -1,
    (gchar *) "StopConflictingSession",
    NULL,
    NULL,
    NULL
  },
  "handle-stop-conflicting-session",
  FALSE
};

static const GDBusMethodInfo * const _gdm_greeter_method_info_pointers[] =
{
  &_gdm_greeter_method_info_select_session.parent_struct,
  &_gdm_greeter_method_info_select_user.parent_struct,
  &_gdm_greeter_method_info_begin_auto_login.parent_struct,
  &_gdm_greeter_method_info_get_timed_login_details.parent_struct,
  &_gdm_greeter_method_info_start_session_when_ready.parent_struct,
  &_gdm_greeter_method_info_stop_conflicting_session.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gdm_greeter_signal_info_selected_user_changed_ARG_username =
{
  {
    -1,
    (gchar *) "username",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_greeter_signal_info_selected_user_changed_ARG_pointers[] =
{
  &_gdm_greeter_signal_info_selected_user_changed_ARG_username.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_greeter_signal_info_selected_user_changed =
{
  {
    -1,
    (gchar *) "SelectedUserChanged",
    (GDBusArgInfo **) &_gdm_greeter_signal_info_selected_user_changed_ARG_pointers,
    NULL
  },
  "selected-user-changed"
};

static const _ExtendedGDBusArgInfo _gdm_greeter_signal_info_default_language_name_changed_ARG_language_name =
{
  {
    -1,
    (gchar *) "language_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_greeter_signal_info_default_language_name_changed_ARG_pointers[] =
{
  &_gdm_greeter_signal_info_default_language_name_changed_ARG_language_name.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_greeter_signal_info_default_language_name_changed =
{
  {
    -1,
    (gchar *) "DefaultLanguageNameChanged",
    (GDBusArgInfo **) &_gdm_greeter_signal_info_default_language_name_changed_ARG_pointers,
    NULL
  },
  "default-language-name-changed"
};

static const _ExtendedGDBusArgInfo _gdm_greeter_signal_info_default_session_name_changed_ARG_session_name =
{
  {
    -1,
    (gchar *) "session_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_greeter_signal_info_default_session_name_changed_ARG_pointers[] =
{
  &_gdm_greeter_signal_info_default_session_name_changed_ARG_session_name.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_greeter_signal_info_default_session_name_changed =
{
  {
    -1,
    (gchar *) "DefaultSessionNameChanged",
    (GDBusArgInfo **) &_gdm_greeter_signal_info_default_session_name_changed_ARG_pointers,
    NULL
  },
  "default-session-name-changed"
};

static const _ExtendedGDBusArgInfo _gdm_greeter_signal_info_timed_login_requested_ARG_username =
{
  {
    -1,
    (gchar *) "username",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_greeter_signal_info_timed_login_requested_ARG_delay =
{
  {
    -1,
    (gchar *) "delay",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_greeter_signal_info_timed_login_requested_ARG_pointers[] =
{
  &_gdm_greeter_signal_info_timed_login_requested_ARG_username.parent_struct,
  &_gdm_greeter_signal_info_timed_login_requested_ARG_delay.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_greeter_signal_info_timed_login_requested =
{
  {
    -1,
    (gchar *) "TimedLoginRequested",
    (GDBusArgInfo **) &_gdm_greeter_signal_info_timed_login_requested_ARG_pointers,
    NULL
  },
  "timed-login-requested"
};

static const _ExtendedGDBusArgInfo _gdm_greeter_signal_info_session_opened_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_greeter_signal_info_session_opened_ARG_session_id =
{
  {
    -1,
    (gchar *) "session_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_greeter_signal_info_session_opened_ARG_pointers[] =
{
  &_gdm_greeter_signal_info_session_opened_ARG_service_name.parent_struct,
  &_gdm_greeter_signal_info_session_opened_ARG_session_id.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_greeter_signal_info_session_opened =
{
  {
    -1,
    (gchar *) "SessionOpened",
    (GDBusArgInfo **) &_gdm_greeter_signal_info_session_opened_ARG_pointers,
    NULL
  },
  "session-opened"
};

static const _ExtendedGDBusArgInfo _gdm_greeter_signal_info_reauthenticated_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_greeter_signal_info_reauthenticated_ARG_pointers[] =
{
  &_gdm_greeter_signal_info_reauthenticated_ARG_service_name.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_greeter_signal_info_reauthenticated =
{
  {
    -1,
    (gchar *) "Reauthenticated",
    (GDBusArgInfo **) &_gdm_greeter_signal_info_reauthenticated_ARG_pointers,
    NULL
  },
  "reauthenticated"
};

static const GDBusSignalInfo * const _gdm_greeter_signal_info_pointers[] =
{
  &_gdm_greeter_signal_info_selected_user_changed.parent_struct,
  &_gdm_greeter_signal_info_default_language_name_changed.parent_struct,
  &_gdm_greeter_signal_info_default_session_name_changed.parent_struct,
  &_gdm_greeter_signal_info_timed_login_requested.parent_struct,
  &_gdm_greeter_signal_info_session_opened.parent_struct,
  &_gdm_greeter_signal_info_reauthenticated.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gdm_greeter_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.DisplayManager.Greeter",
    (GDBusMethodInfo **) &_gdm_greeter_method_info_pointers,
    (GDBusSignalInfo **) &_gdm_greeter_signal_info_pointers,
    NULL,
    NULL
  },
  "greeter",
};


/**
 * gdm_greeter_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-DisplayManager-Greeter.top_of_page">org.gnome.DisplayManager.Greeter</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gdm_greeter_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gdm_greeter_interface_info.parent_struct;
}

/**
 * gdm_greeter_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GdmGreeter interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gdm_greeter_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
gdm_greeter_signal_marshal_selected_user_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_greeter_signal_marshal_default_language_name_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_greeter_signal_marshal_default_session_name_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_greeter_signal_marshal_timed_login_requested (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_greeter_signal_marshal_session_opened (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_greeter_signal_marshal_reauthenticated (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_greeter_method_marshal_select_session (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_greeter_method_marshal_select_user (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_greeter_method_marshal_begin_auto_login (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_greeter_method_marshal_get_timed_login_details (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_greeter_method_marshal_start_session_when_ready (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_greeter_method_marshal_stop_conflicting_session (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GdmGreeter:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-Greeter.top_of_page">org.gnome.DisplayManager.Greeter</link>.
 */

/**
 * GdmGreeterIface:
 * @parent_iface: The parent interface.
 * @handle_begin_auto_login: Handler for the #GdmGreeter::handle-begin-auto-login signal.
 * @handle_get_timed_login_details: Handler for the #GdmGreeter::handle-get-timed-login-details signal.
 * @handle_select_session: Handler for the #GdmGreeter::handle-select-session signal.
 * @handle_select_user: Handler for the #GdmGreeter::handle-select-user signal.
 * @handle_start_session_when_ready: Handler for the #GdmGreeter::handle-start-session-when-ready signal.
 * @handle_stop_conflicting_session: Handler for the #GdmGreeter::handle-stop-conflicting-session signal.
 * @default_language_name_changed: Handler for the #GdmGreeter::default-language-name-changed signal.
 * @default_session_name_changed: Handler for the #GdmGreeter::default-session-name-changed signal.
 * @reauthenticated: Handler for the #GdmGreeter::reauthenticated signal.
 * @selected_user_changed: Handler for the #GdmGreeter::selected-user-changed signal.
 * @session_opened: Handler for the #GdmGreeter::session-opened signal.
 * @timed_login_requested: Handler for the #GdmGreeter::timed-login-requested signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-Greeter.top_of_page">org.gnome.DisplayManager.Greeter</link>.
 */

typedef GdmGreeterIface GdmGreeterInterface;
G_DEFINE_INTERFACE (GdmGreeter, gdm_greeter, G_TYPE_OBJECT)

static void
gdm_greeter_default_init (GdmGreeterIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GdmGreeter::handle-select-session:
   * @object: A #GdmGreeter.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.SelectSession">SelectSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_greeter_complete_select_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-select-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmGreeterIface, handle_select_session),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_greeter_method_marshal_select_session,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * GdmGreeter::handle-select-user:
   * @object: A #GdmGreeter.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_username: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.SelectUser">SelectUser()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_greeter_complete_select_user() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-select-user",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmGreeterIface, handle_select_user),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_greeter_method_marshal_select_user,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * GdmGreeter::handle-begin-auto-login:
   * @object: A #GdmGreeter.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_username: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.BeginAutoLogin">BeginAutoLogin()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_greeter_complete_begin_auto_login() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-begin-auto-login",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmGreeterIface, handle_begin_auto_login),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_greeter_method_marshal_begin_auto_login,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * GdmGreeter::handle-get-timed-login-details:
   * @object: A #GdmGreeter.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.GetTimedLoginDetails">GetTimedLoginDetails()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_greeter_complete_get_timed_login_details() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-timed-login-details",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmGreeterIface, handle_get_timed_login_details),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_greeter_method_marshal_get_timed_login_details,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GdmGreeter::handle-start-session-when-ready:
   * @object: A #GdmGreeter.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   * @arg_should_start_session: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.StartSessionWhenReady">StartSessionWhenReady()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_greeter_complete_start_session_when_ready() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start-session-when-ready",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmGreeterIface, handle_start_session_when_ready),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_greeter_method_marshal_start_session_when_ready,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN);

  /**
   * GdmGreeter::handle-stop-conflicting-session:
   * @object: A #GdmGreeter.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.StopConflictingSession">StopConflictingSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_greeter_complete_stop_conflicting_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop-conflicting-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmGreeterIface, handle_stop_conflicting_session),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_greeter_method_marshal_stop_conflicting_session,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * GdmGreeter::selected-user-changed:
   * @object: A #GdmGreeter.
   * @arg_username: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-Greeter.SelectedUserChanged">"SelectedUserChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM__GREETER_SIGNALS[GDM__GREETER_SELECTED_USER_CHANGED] =
    g_signal_new ("selected-user-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmGreeterIface, selected_user_changed),
      NULL,
      NULL,
      gdm_greeter_signal_marshal_selected_user_changed,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * GdmGreeter::default-language-name-changed:
   * @object: A #GdmGreeter.
   * @arg_language_name: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-Greeter.DefaultLanguageNameChanged">"DefaultLanguageNameChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM__GREETER_SIGNALS[GDM__GREETER_DEFAULT_LANGUAGE_NAME_CHANGED] =
    g_signal_new ("default-language-name-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmGreeterIface, default_language_name_changed),
      NULL,
      NULL,
      gdm_greeter_signal_marshal_default_language_name_changed,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * GdmGreeter::default-session-name-changed:
   * @object: A #GdmGreeter.
   * @arg_session_name: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-Greeter.DefaultSessionNameChanged">"DefaultSessionNameChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM__GREETER_SIGNALS[GDM__GREETER_DEFAULT_SESSION_NAME_CHANGED] =
    g_signal_new ("default-session-name-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmGreeterIface, default_session_name_changed),
      NULL,
      NULL,
      gdm_greeter_signal_marshal_default_session_name_changed,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * GdmGreeter::timed-login-requested:
   * @object: A #GdmGreeter.
   * @arg_username: Argument.
   * @arg_delay: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-Greeter.TimedLoginRequested">"TimedLoginRequested"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM__GREETER_SIGNALS[GDM__GREETER_TIMED_LOGIN_REQUESTED] =
    g_signal_new ("timed-login-requested",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmGreeterIface, timed_login_requested),
      NULL,
      NULL,
      gdm_greeter_signal_marshal_timed_login_requested,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_INT);

  /**
   * GdmGreeter::session-opened:
   * @object: A #GdmGreeter.
   * @arg_service_name: Argument.
   * @arg_session_id: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-Greeter.SessionOpened">"SessionOpened"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM__GREETER_SIGNALS[GDM__GREETER_SESSION_OPENED] =
    g_signal_new ("session-opened",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmGreeterIface, session_opened),
      NULL,
      NULL,
      gdm_greeter_signal_marshal_session_opened,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmGreeter::reauthenticated:
   * @object: A #GdmGreeter.
   * @arg_service_name: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-Greeter.Reauthenticated">"Reauthenticated"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM__GREETER_SIGNALS[GDM__GREETER_REAUTHENTICATED] =
    g_signal_new ("reauthenticated",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmGreeterIface, reauthenticated),
      NULL,
      NULL,
      gdm_greeter_signal_marshal_reauthenticated,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

}

/**
 * gdm_greeter_emit_selected_user_changed:
 * @object: A #GdmGreeter.
 * @arg_username: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-Greeter.SelectedUserChanged">"SelectedUserChanged"</link> D-Bus signal.
 */
void
gdm_greeter_emit_selected_user_changed (
    GdmGreeter *object,
    const gchar *arg_username)
{
  g_signal_emit (object, GDM__GREETER_SIGNALS[GDM__GREETER_SELECTED_USER_CHANGED], 0, arg_username);
}

/**
 * gdm_greeter_emit_default_language_name_changed:
 * @object: A #GdmGreeter.
 * @arg_language_name: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-Greeter.DefaultLanguageNameChanged">"DefaultLanguageNameChanged"</link> D-Bus signal.
 */
void
gdm_greeter_emit_default_language_name_changed (
    GdmGreeter *object,
    const gchar *arg_language_name)
{
  g_signal_emit (object, GDM__GREETER_SIGNALS[GDM__GREETER_DEFAULT_LANGUAGE_NAME_CHANGED], 0, arg_language_name);
}

/**
 * gdm_greeter_emit_default_session_name_changed:
 * @object: A #GdmGreeter.
 * @arg_session_name: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-Greeter.DefaultSessionNameChanged">"DefaultSessionNameChanged"</link> D-Bus signal.
 */
void
gdm_greeter_emit_default_session_name_changed (
    GdmGreeter *object,
    const gchar *arg_session_name)
{
  g_signal_emit (object, GDM__GREETER_SIGNALS[GDM__GREETER_DEFAULT_SESSION_NAME_CHANGED], 0, arg_session_name);
}

/**
 * gdm_greeter_emit_timed_login_requested:
 * @object: A #GdmGreeter.
 * @arg_username: Argument to pass with the signal.
 * @arg_delay: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-Greeter.TimedLoginRequested">"TimedLoginRequested"</link> D-Bus signal.
 */
void
gdm_greeter_emit_timed_login_requested (
    GdmGreeter *object,
    const gchar *arg_username,
    gint arg_delay)
{
  g_signal_emit (object, GDM__GREETER_SIGNALS[GDM__GREETER_TIMED_LOGIN_REQUESTED], 0, arg_username, arg_delay);
}

/**
 * gdm_greeter_emit_session_opened:
 * @object: A #GdmGreeter.
 * @arg_service_name: Argument to pass with the signal.
 * @arg_session_id: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-Greeter.SessionOpened">"SessionOpened"</link> D-Bus signal.
 */
void
gdm_greeter_emit_session_opened (
    GdmGreeter *object,
    const gchar *arg_service_name,
    const gchar *arg_session_id)
{
  g_signal_emit (object, GDM__GREETER_SIGNALS[GDM__GREETER_SESSION_OPENED], 0, arg_service_name, arg_session_id);
}

/**
 * gdm_greeter_emit_reauthenticated:
 * @object: A #GdmGreeter.
 * @arg_service_name: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-Greeter.Reauthenticated">"Reauthenticated"</link> D-Bus signal.
 */
void
gdm_greeter_emit_reauthenticated (
    GdmGreeter *object,
    const gchar *arg_service_name)
{
  g_signal_emit (object, GDM__GREETER_SIGNALS[GDM__GREETER_REAUTHENTICATED], 0, arg_service_name);
}

/**
 * gdm_greeter_call_select_session:
 * @proxy: A #GdmGreeterProxy.
 * @arg_session: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.SelectSession">SelectSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_greeter_call_select_session_finish() to get the result of the operation.
 *
 * See gdm_greeter_call_select_session_sync() for the synchronous, blocking version of this method.
 */
void
gdm_greeter_call_select_session (
    GdmGreeter *proxy,
    const gchar *arg_session,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SelectSession",
    g_variant_new ("(s)",
                   arg_session),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_greeter_call_select_session_finish:
 * @proxy: A #GdmGreeterProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_greeter_call_select_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_greeter_call_select_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_greeter_call_select_session_finish (
    GdmGreeter *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_greeter_call_select_session_sync:
 * @proxy: A #GdmGreeterProxy.
 * @arg_session: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.SelectSession">SelectSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_greeter_call_select_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_greeter_call_select_session_sync (
    GdmGreeter *proxy,
    const gchar *arg_session,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SelectSession",
    g_variant_new ("(s)",
                   arg_session),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_greeter_call_select_user:
 * @proxy: A #GdmGreeterProxy.
 * @arg_username: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.SelectUser">SelectUser()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_greeter_call_select_user_finish() to get the result of the operation.
 *
 * See gdm_greeter_call_select_user_sync() for the synchronous, blocking version of this method.
 */
void
gdm_greeter_call_select_user (
    GdmGreeter *proxy,
    const gchar *arg_username,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SelectUser",
    g_variant_new ("(s)",
                   arg_username),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_greeter_call_select_user_finish:
 * @proxy: A #GdmGreeterProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_greeter_call_select_user().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_greeter_call_select_user().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_greeter_call_select_user_finish (
    GdmGreeter *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_greeter_call_select_user_sync:
 * @proxy: A #GdmGreeterProxy.
 * @arg_username: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.SelectUser">SelectUser()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_greeter_call_select_user() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_greeter_call_select_user_sync (
    GdmGreeter *proxy,
    const gchar *arg_username,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SelectUser",
    g_variant_new ("(s)",
                   arg_username),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_greeter_call_begin_auto_login:
 * @proxy: A #GdmGreeterProxy.
 * @arg_username: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.BeginAutoLogin">BeginAutoLogin()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_greeter_call_begin_auto_login_finish() to get the result of the operation.
 *
 * See gdm_greeter_call_begin_auto_login_sync() for the synchronous, blocking version of this method.
 */
void
gdm_greeter_call_begin_auto_login (
    GdmGreeter *proxy,
    const gchar *arg_username,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "BeginAutoLogin",
    g_variant_new ("(s)",
                   arg_username),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_greeter_call_begin_auto_login_finish:
 * @proxy: A #GdmGreeterProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_greeter_call_begin_auto_login().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_greeter_call_begin_auto_login().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_greeter_call_begin_auto_login_finish (
    GdmGreeter *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_greeter_call_begin_auto_login_sync:
 * @proxy: A #GdmGreeterProxy.
 * @arg_username: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.BeginAutoLogin">BeginAutoLogin()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_greeter_call_begin_auto_login() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_greeter_call_begin_auto_login_sync (
    GdmGreeter *proxy,
    const gchar *arg_username,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "BeginAutoLogin",
    g_variant_new ("(s)",
                   arg_username),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_greeter_call_get_timed_login_details:
 * @proxy: A #GdmGreeterProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.GetTimedLoginDetails">GetTimedLoginDetails()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_greeter_call_get_timed_login_details_finish() to get the result of the operation.
 *
 * See gdm_greeter_call_get_timed_login_details_sync() for the synchronous, blocking version of this method.
 */
void
gdm_greeter_call_get_timed_login_details (
    GdmGreeter *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetTimedLoginDetails",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_greeter_call_get_timed_login_details_finish:
 * @proxy: A #GdmGreeterProxy.
 * @out_enabled: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_username: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_delay: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_greeter_call_get_timed_login_details().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_greeter_call_get_timed_login_details().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_greeter_call_get_timed_login_details_finish (
    GdmGreeter *proxy,
    gboolean* out_enabled,
    gchar ** out_username,
    gint* out_delay,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bsi)",
                 out_enabled,
                 out_username,
                 out_delay);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_greeter_call_get_timed_login_details_sync:
 * @proxy: A #GdmGreeterProxy.
 * @out_enabled: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_username: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_delay: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.GetTimedLoginDetails">GetTimedLoginDetails()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_greeter_call_get_timed_login_details() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_greeter_call_get_timed_login_details_sync (
    GdmGreeter *proxy,
    gboolean* out_enabled,
    gchar ** out_username,
    gint* out_delay,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetTimedLoginDetails",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bsi)",
                 out_enabled,
                 out_username,
                 out_delay);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_greeter_call_start_session_when_ready:
 * @proxy: A #GdmGreeterProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_should_start_session: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.StartSessionWhenReady">StartSessionWhenReady()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_greeter_call_start_session_when_ready_finish() to get the result of the operation.
 *
 * See gdm_greeter_call_start_session_when_ready_sync() for the synchronous, blocking version of this method.
 */
void
gdm_greeter_call_start_session_when_ready (
    GdmGreeter *proxy,
    const gchar *arg_service_name,
    gboolean arg_should_start_session,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "StartSessionWhenReady",
    g_variant_new ("(sb)",
                   arg_service_name,
                   arg_should_start_session),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_greeter_call_start_session_when_ready_finish:
 * @proxy: A #GdmGreeterProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_greeter_call_start_session_when_ready().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_greeter_call_start_session_when_ready().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_greeter_call_start_session_when_ready_finish (
    GdmGreeter *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_greeter_call_start_session_when_ready_sync:
 * @proxy: A #GdmGreeterProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_should_start_session: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.StartSessionWhenReady">StartSessionWhenReady()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_greeter_call_start_session_when_ready() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_greeter_call_start_session_when_ready_sync (
    GdmGreeter *proxy,
    const gchar *arg_service_name,
    gboolean arg_should_start_session,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "StartSessionWhenReady",
    g_variant_new ("(sb)",
                   arg_service_name,
                   arg_should_start_session),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_greeter_call_stop_conflicting_session:
 * @proxy: A #GdmGreeterProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.StopConflictingSession">StopConflictingSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_greeter_call_stop_conflicting_session_finish() to get the result of the operation.
 *
 * See gdm_greeter_call_stop_conflicting_session_sync() for the synchronous, blocking version of this method.
 */
void
gdm_greeter_call_stop_conflicting_session (
    GdmGreeter *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "StopConflictingSession",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_greeter_call_stop_conflicting_session_finish:
 * @proxy: A #GdmGreeterProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_greeter_call_stop_conflicting_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_greeter_call_stop_conflicting_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_greeter_call_stop_conflicting_session_finish (
    GdmGreeter *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_greeter_call_stop_conflicting_session_sync:
 * @proxy: A #GdmGreeterProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.StopConflictingSession">StopConflictingSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_greeter_call_stop_conflicting_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_greeter_call_stop_conflicting_session_sync (
    GdmGreeter *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "StopConflictingSession",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_greeter_complete_select_session:
 * @object: A #GdmGreeter.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.SelectSession">SelectSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_greeter_complete_select_session (
    GdmGreeter *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_greeter_complete_select_user:
 * @object: A #GdmGreeter.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.SelectUser">SelectUser()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_greeter_complete_select_user (
    GdmGreeter *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_greeter_complete_begin_auto_login:
 * @object: A #GdmGreeter.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.BeginAutoLogin">BeginAutoLogin()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_greeter_complete_begin_auto_login (
    GdmGreeter *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_greeter_complete_get_timed_login_details:
 * @object: A #GdmGreeter.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @enabled: Parameter to return.
 * @username: Parameter to return.
 * @delay: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.GetTimedLoginDetails">GetTimedLoginDetails()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_greeter_complete_get_timed_login_details (
    GdmGreeter *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean enabled,
    const gchar *username,
    gint delay)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(bsi)",
                   enabled,
                   username,
                   delay));
}

/**
 * gdm_greeter_complete_start_session_when_ready:
 * @object: A #GdmGreeter.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.StartSessionWhenReady">StartSessionWhenReady()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_greeter_complete_start_session_when_ready (
    GdmGreeter *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_greeter_complete_stop_conflicting_session:
 * @object: A #GdmGreeter.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.StopConflictingSession">StopConflictingSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_greeter_complete_stop_conflicting_session (
    GdmGreeter *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * GdmGreeterProxy:
 *
 * The #GdmGreeterProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmGreeterProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmGreeterProxy.
 */

struct _GdmGreeterProxyPrivate
{
  GData *qdata;
};

static void gdm_greeter_proxy_iface_init (GdmGreeterIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmGreeterProxy, gdm_greeter_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GdmGreeterProxy)
                         G_IMPLEMENT_INTERFACE (GDM_TYPE_GREETER, gdm_greeter_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmGreeterProxy, gdm_greeter_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GDM_TYPE_GREETER, gdm_greeter_proxy_iface_init))

#endif
static void
gdm_greeter_proxy_finalize (GObject *object)
{
  GdmGreeterProxy *proxy = GDM_GREETER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gdm_greeter_proxy_parent_class)->finalize (object);
}

static void
gdm_greeter_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_greeter_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_greeter_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gdm_greeter_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GDM_TYPE_GREETER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_TYPE_GREETER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gdm_greeter_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GdmGreeterProxy *proxy = GDM_GREETER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_greeter_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_greeter_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
gdm_greeter_proxy_init (GdmGreeterProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gdm_greeter_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GDM_TYPE_GREETER_PROXY, GdmGreeterProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gdm_greeter_interface_info ());
}

static void
gdm_greeter_proxy_class_init (GdmGreeterProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gdm_greeter_proxy_finalize;
  gobject_class->get_property = gdm_greeter_proxy_get_property;
  gobject_class->set_property = gdm_greeter_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gdm_greeter_proxy_g_signal;
  proxy_class->g_properties_changed = gdm_greeter_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmGreeterProxyPrivate));
#endif
}

static void
gdm_greeter_proxy_iface_init (GdmGreeterIface *iface G_GNUC_UNUSED)
{
}

/**
 * gdm_greeter_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-Greeter.top_of_page">org.gnome.DisplayManager.Greeter</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_greeter_proxy_new_finish() to get the result of the operation.
 *
 * See gdm_greeter_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_greeter_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_TYPE_GREETER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.Greeter", NULL);
}

/**
 * gdm_greeter_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_greeter_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_greeter_proxy_new().
 *
 * Returns: (transfer full) (type GdmGreeterProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmGreeter *
gdm_greeter_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_GREETER (ret);
  else
    return NULL;
}

/**
 * gdm_greeter_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-Greeter.top_of_page">org.gnome.DisplayManager.Greeter</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_greeter_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmGreeterProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmGreeter *
gdm_greeter_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_TYPE_GREETER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.Greeter", NULL);
  if (ret != NULL)
    return GDM_GREETER (ret);
  else
    return NULL;
}


/**
 * gdm_greeter_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gdm_greeter_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_greeter_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gdm_greeter_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_greeter_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_TYPE_GREETER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.Greeter", NULL);
}

/**
 * gdm_greeter_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_greeter_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_greeter_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GdmGreeterProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmGreeter *
gdm_greeter_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_GREETER (ret);
  else
    return NULL;
}

/**
 * gdm_greeter_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gdm_greeter_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_greeter_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmGreeterProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmGreeter *
gdm_greeter_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_TYPE_GREETER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.Greeter", NULL);
  if (ret != NULL)
    return GDM_GREETER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GdmGreeterSkeleton:
 *
 * The #GdmGreeterSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmGreeterSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmGreeterSkeleton.
 */

struct _GdmGreeterSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gdm_greeter_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GdmGreeterSkeleton *skeleton = GDM_GREETER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GDM_TYPE_GREETER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_TYPE_GREETER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gdm_greeter_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GdmGreeterSkeleton *skeleton = GDM_GREETER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_greeter_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gdm_greeter_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GdmGreeterSkeleton *skeleton = GDM_GREETER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_greeter_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gdm_greeter_skeleton_vtable =
{
  _gdm_greeter_skeleton_handle_method_call,
  _gdm_greeter_skeleton_handle_get_property,
  _gdm_greeter_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gdm_greeter_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gdm_greeter_interface_info ();
}

static GDBusInterfaceVTable *
gdm_greeter_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gdm_greeter_skeleton_vtable;
}

static GVariant *
gdm_greeter_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GdmGreeterSkeleton *skeleton = GDM_GREETER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gdm_greeter_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gdm_greeter_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gdm_greeter_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gdm_greeter_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.Greeter", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
gdm_greeter_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_gdm_greeter_on_signal_selected_user_changed (
    GdmGreeter *object,
    const gchar *arg_username)
{
  GdmGreeterSkeleton *skeleton = GDM_GREETER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_username));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.Greeter", "SelectedUserChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_greeter_on_signal_default_language_name_changed (
    GdmGreeter *object,
    const gchar *arg_language_name)
{
  GdmGreeterSkeleton *skeleton = GDM_GREETER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_language_name));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.Greeter", "DefaultLanguageNameChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_greeter_on_signal_default_session_name_changed (
    GdmGreeter *object,
    const gchar *arg_session_name)
{
  GdmGreeterSkeleton *skeleton = GDM_GREETER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_session_name));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.Greeter", "DefaultSessionNameChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_greeter_on_signal_timed_login_requested (
    GdmGreeter *object,
    const gchar *arg_username,
    gint arg_delay)
{
  GdmGreeterSkeleton *skeleton = GDM_GREETER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(si)",
                   arg_username,
                   arg_delay));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.Greeter", "TimedLoginRequested",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_greeter_on_signal_session_opened (
    GdmGreeter *object,
    const gchar *arg_service_name,
    const gchar *arg_session_id)
{
  GdmGreeterSkeleton *skeleton = GDM_GREETER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ss)",
                   arg_service_name,
                   arg_session_id));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.Greeter", "SessionOpened",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_greeter_on_signal_reauthenticated (
    GdmGreeter *object,
    const gchar *arg_service_name)
{
  GdmGreeterSkeleton *skeleton = GDM_GREETER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_service_name));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.Greeter", "Reauthenticated",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void gdm_greeter_skeleton_iface_init (GdmGreeterIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmGreeterSkeleton, gdm_greeter_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GdmGreeterSkeleton)
                         G_IMPLEMENT_INTERFACE (GDM_TYPE_GREETER, gdm_greeter_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmGreeterSkeleton, gdm_greeter_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GDM_TYPE_GREETER, gdm_greeter_skeleton_iface_init))

#endif
static void
gdm_greeter_skeleton_finalize (GObject *object)
{
  GdmGreeterSkeleton *skeleton = GDM_GREETER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  /* coverity[missing_lock : SUPPRESS] */
  g_clear_pointer (&skeleton->priv->changed_properties_idle_source, g_source_destroy);
#else
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
skeleton->priv->changed_properties_idle_source = NULL;
#endif
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gdm_greeter_skeleton_parent_class)->finalize (object);
}

static void
gdm_greeter_skeleton_init (GdmGreeterSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gdm_greeter_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GDM_TYPE_GREETER_SKELETON, GdmGreeterSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
gdm_greeter_skeleton_class_init (GdmGreeterSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gdm_greeter_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gdm_greeter_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gdm_greeter_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gdm_greeter_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gdm_greeter_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmGreeterSkeletonPrivate));
#endif
}

static void
gdm_greeter_skeleton_iface_init (GdmGreeterIface *iface)
{
  iface->selected_user_changed = _gdm_greeter_on_signal_selected_user_changed;
  iface->default_language_name_changed = _gdm_greeter_on_signal_default_language_name_changed;
  iface->default_session_name_changed = _gdm_greeter_on_signal_default_session_name_changed;
  iface->timed_login_requested = _gdm_greeter_on_signal_timed_login_requested;
  iface->session_opened = _gdm_greeter_on_signal_session_opened;
  iface->reauthenticated = _gdm_greeter_on_signal_reauthenticated;
}

/**
 * gdm_greeter_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-Greeter.top_of_page">org.gnome.DisplayManager.Greeter</link>.
 *
 * Returns: (transfer full) (type GdmGreeterSkeleton): The skeleton object.
 */
GdmGreeter *
gdm_greeter_skeleton_new (void)
{
  return GDM_GREETER (g_object_new (GDM_TYPE_GREETER_SKELETON, NULL));
}

