/* PreviewPage.c generated by valac 0.56.18, the Vala compiler
 * generated from PreviewPage.vala, do not modify */

/* PreviewPage.vala
 *
 * Copyright (C) 2020-2025 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <webkit/webkit.h>
#include "config.h"
#include "font-manager.h"
#include <gtk/gtk.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include "vala-common.h"
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <locale.h>

#define HEADER "\n" \
"<html dir=\"%s\">\n" \
"  <head>\n" \
"    <style>\n" \
"      body, textarea {\n" \
"        color: %s;\n" \
"        background-color: %s;\n" \
"      }\n" \
"      textarea {\n" \
"        width: 95%;\n" \
"        height: 95%;\n" \
"        resize: none;\n" \
"        wrap: soft;\n" \
"        -webkit-box-sizing: border-box;\n" \
"      }\n" \
"      .aligned {\n" \
"        text-align: %s;\n" \
"      }\n" \
"      .padded {\n" \
"        padding: 64px;\n" \
"      }\n" \
"      .bodyText {\n" \
"        margin: 12px 8px 12px 8px;\n" \
"        text-align: justify;\n" \
"      }\n" \
"      .previewText {\n" \
"        font-size: %.0lfpx;\n" \
"        font-family: %s, adobe-notdef;\n" \
"        font-style: %s;\n" \
"        font-weight: %i;\n" \
"      }\n" \
"      .noWrap {\n" \
"        overflow: visible;\n" \
"        white-space: nowrap;\n" \
"        display:block;\n" \
"        width:100%;\n" \
"      }\n" \
"      %s\n" \
"      @font-face {\n" \
"            font-family: 'adobe-notdef';\n" \
"            src:\n" \
"                url('https://github.com/adobe-fonts/adobe-notdef/blob/" \
"master/AND-Regular.ttf?raw=true')\n" \
"                format('truetype');\n" \
"      }\n" \
"    </style>\n" \
"  </head>\n" \
"  <script>\n" \
"    function onInput() {\n" \
"      document.title = document.getElementById(\"textArea\").value;\n" \
"    }\n" \
"  </script>\n" \
"  <body oncontextmenu=\"return false;\">\n" \
"    <div>\n"
#define WATERFALL_ROW "\n" \
"      <p id=\"%.0lf\" class=\"noWrap\">\n" \
"        <span style=\"font-family: monospace;font-size: 10px;\">%s</sp" \
"an>\n" \
"        <span class=\"previewText\" style=\"font-size:%.0lfpx;\">%s</s" \
"pan>\n" \
"      </p>\n"
#define BODY_TEXT "\n" \
"      <p class=\"bodyText\">\n" \
"        <span class=\"previewText\">%s</span>\n" \
"      </p>\n"
#define ACTIVE_PREVIEW "\n" \
"      <div class=\"aligned\">\n" \
"        <div class=\"padded\">\n" \
"          <p class=\"previewText\" style=\"white-space: pre-line;\">%s" \
"</p>\n" \
"        </div>\n" \
"      </div>\n"
#define DEFAULT_ACTIVE_TEXT "\n" \
"The quick brown fox jumps over the lazy dog.\n" \
"ABCDEFGHIJKLMNOPQRSTUVWXYZ\n" \
"abcdefghijklmnopqrstuvwxyz\n" \
"1234567890.:,;(*!?')\n"
#define FOOTER "\n    </div>\n  </body>\n</html>\n"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FONT_MANAGER_GOOGLE_FONTS_TYPE_PREVIEW_PAGE (font_manager_google_fonts_preview_page_get_type ())
#define FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_PREVIEW_PAGE, FontManagerGoogleFontsPreviewPage))
#define FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_PREVIEW_PAGE, FontManagerGoogleFontsPreviewPageClass))
#define FONT_MANAGER_GOOGLE_FONTS_IS_PREVIEW_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_PREVIEW_PAGE))
#define FONT_MANAGER_GOOGLE_FONTS_IS_PREVIEW_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_PREVIEW_PAGE))
#define FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_PREVIEW_PAGE, FontManagerGoogleFontsPreviewPageClass))

typedef struct _FontManagerGoogleFontsPreviewPage FontManagerGoogleFontsPreviewPage;
typedef struct _FontManagerGoogleFontsPreviewPageClass FontManagerGoogleFontsPreviewPageClass;
typedef struct _FontManagerGoogleFontsPreviewPagePrivate FontManagerGoogleFontsPreviewPagePrivate;

#define FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT (font_manager_google_fonts_font_get_type ())
#define FONT_MANAGER_GOOGLE_FONTS_FONT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT, FontManagerGoogleFontsFont))
#define FONT_MANAGER_GOOGLE_FONTS_FONT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT, FontManagerGoogleFontsFontClass))
#define FONT_MANAGER_GOOGLE_FONTS_IS_FONT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT))
#define FONT_MANAGER_GOOGLE_FONTS_IS_FONT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT))
#define FONT_MANAGER_GOOGLE_FONTS_FONT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT, FontManagerGoogleFontsFontClass))

typedef struct _FontManagerGoogleFontsFont FontManagerGoogleFontsFont;
typedef struct _FontManagerGoogleFontsFontClass FontManagerGoogleFontsFontClass;

#define FONT_MANAGER_TYPE_PREVIEW_ENTRY (font_manager_preview_entry_get_type ())
#define FONT_MANAGER_PREVIEW_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_PREVIEW_ENTRY, FontManagerPreviewEntry))
#define FONT_MANAGER_PREVIEW_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_PREVIEW_ENTRY, FontManagerPreviewEntryClass))
#define FONT_MANAGER_IS_PREVIEW_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_PREVIEW_ENTRY))
#define FONT_MANAGER_IS_PREVIEW_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_PREVIEW_ENTRY))
#define FONT_MANAGER_PREVIEW_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_PREVIEW_ENTRY, FontManagerPreviewEntryClass))

typedef struct _FontManagerPreviewEntry FontManagerPreviewEntry;
typedef struct _FontManagerPreviewEntryClass FontManagerPreviewEntryClass;

#define FONT_MANAGER_GOOGLE_FONTS_TYPE_SAMPLE_LIST (font_manager_google_fonts_sample_list_get_type ())
#define FONT_MANAGER_GOOGLE_FONTS_SAMPLE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_SAMPLE_LIST, FontManagerGoogleFontsSampleList))
#define FONT_MANAGER_GOOGLE_FONTS_SAMPLE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_SAMPLE_LIST, FontManagerGoogleFontsSampleListClass))
#define FONT_MANAGER_GOOGLE_FONTS_IS_SAMPLE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_SAMPLE_LIST))
#define FONT_MANAGER_GOOGLE_FONTS_IS_SAMPLE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_SAMPLE_LIST))
#define FONT_MANAGER_GOOGLE_FONTS_SAMPLE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_SAMPLE_LIST, FontManagerGoogleFontsSampleListClass))

typedef struct _FontManagerGoogleFontsSampleList FontManagerGoogleFontsSampleList;
typedef struct _FontManagerGoogleFontsSampleListClass FontManagerGoogleFontsSampleListClass;
enum  {
	FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_0_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_PREDEFINED_SIZE_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_SHOW_LINE_SIZE_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_PREVIEW_SIZE_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_MIN_WATERFALL_SIZE_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_MAX_WATERFALL_SIZE_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_WATERFALL_SIZE_RATIO_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_SELECTED_ITEM_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_JUSTIFICATION_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_PREVIEW_MODE_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_WATERFALL_SETTINGS_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_PREVIEW_TEXT_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_ACTIVE_PREVIEW_TEXT_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_NUM_PROPERTIES
};
static GParamSpec* font_manager_google_fonts_preview_page_properties[FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY (font_manager_google_fonts_family_get_type ())
#define FONT_MANAGER_GOOGLE_FONTS_FAMILY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY, FontManagerGoogleFontsFamily))
#define FONT_MANAGER_GOOGLE_FONTS_FAMILY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY, FontManagerGoogleFontsFamilyClass))
#define FONT_MANAGER_GOOGLE_FONTS_IS_FAMILY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY))
#define FONT_MANAGER_GOOGLE_FONTS_IS_FAMILY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY))
#define FONT_MANAGER_GOOGLE_FONTS_FAMILY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY, FontManagerGoogleFontsFamilyClass))

typedef struct _FontManagerGoogleFontsFamily FontManagerGoogleFontsFamily;
typedef struct _FontManagerGoogleFontsFamilyClass FontManagerGoogleFontsFamilyClass;

#define FONT_MANAGER_GOOGLE_FONTS_TYPE_SAMPLE_MODEL (font_manager_google_fonts_sample_model_get_type ())
#define FONT_MANAGER_GOOGLE_FONTS_SAMPLE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_SAMPLE_MODEL, FontManagerGoogleFontsSampleModel))
#define FONT_MANAGER_GOOGLE_FONTS_SAMPLE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_SAMPLE_MODEL, FontManagerGoogleFontsSampleModelClass))
#define FONT_MANAGER_GOOGLE_FONTS_IS_SAMPLE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_SAMPLE_MODEL))
#define FONT_MANAGER_GOOGLE_FONTS_IS_SAMPLE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_SAMPLE_MODEL))
#define FONT_MANAGER_GOOGLE_FONTS_SAMPLE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_SAMPLE_MODEL, FontManagerGoogleFontsSampleModelClass))

typedef struct _FontManagerGoogleFontsSampleModel FontManagerGoogleFontsSampleModel;
typedef struct _FontManagerGoogleFontsSampleModelClass FontManagerGoogleFontsSampleModelClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FontManagerGoogleFontsPreviewPage {
	GtkBox parent_instance;
	FontManagerGoogleFontsPreviewPagePrivate * priv;
};

struct _FontManagerGoogleFontsPreviewPageClass {
	GtkBoxClass parent_class;
};

struct _FontManagerGoogleFontsPreviewPagePrivate {
	gint _predefined_size;
	gboolean _show_line_size;
	gdouble _preview_size;
	gdouble _min_waterfall_size;
	gdouble _max_waterfall_size;
	gdouble _waterfall_size_ratio;
	GObject* _selected_item;
	GtkJustification _justification;
	FontManagerPreviewPageMode _preview_mode;
	FontManagerWaterfallSettings* _waterfall_settings;
	gchar* _preview_text;
	gchar* waterfall_body;
	gchar* _active_preview_text;
	gchar* default_pangram;
	GtkCenterBox* controls;
	GtkMenuButton* menu_button;
	GtkMenuButton* sample_button;
	FontManagerPreviewColors* preview_colors;
	FontManagerGoogleFontsFont* font;
	FontManagerFontScale* fontscale;
	FontManagerPreviewEntry* entry;
	FontManagerPreviewControls* preview_controls;
	FontManagerGoogleFontsSampleList* samples;
	GdkRectangle clicked_area;
	WebKitWebView* webview;
	GtkRevealer* controls_revealer;
	GtkRevealer* fontscale_revealer;
	GtkStack* preview_stack;
	GtkTextView* textview;
	gchar** requires_reload;
	gint requires_reload_length1;
	gint _requires_reload_size_;
	gchar** affects_waterfall;
	gint affects_waterfall_length1;
	gint _affects_waterfall_size_;
};

static gint FontManagerGoogleFontsPreviewPage_private_offset;
static gpointer font_manager_google_fonts_preview_page_parent_class = NULL;

VALA_EXTERN WebKitWebView* font_manager_google_fonts_create_webview (void);
VALA_EXTERN GType font_manager_google_fonts_preview_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerGoogleFontsPreviewPage, g_object_unref)
VALA_EXTERN GType font_manager_google_fonts_font_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerGoogleFontsFont, g_object_unref)
VALA_EXTERN GType font_manager_preview_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerPreviewEntry, g_object_unref)
VALA_EXTERN GType font_manager_google_fonts_sample_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerGoogleFontsSampleList, g_object_unref)
VALA_EXTERN FontManagerGoogleFontsPreviewPage* font_manager_google_fonts_preview_page_new (void);
VALA_EXTERN FontManagerGoogleFontsPreviewPage* font_manager_google_fonts_preview_page_construct (GType object_type);
VALA_EXTERN FontManagerPreviewEntry* font_manager_preview_entry_new (void);
VALA_EXTERN FontManagerPreviewEntry* font_manager_preview_entry_construct (GType object_type);
VALA_EXTERN FontManagerGoogleFontsSampleList* font_manager_google_fonts_sample_list_new (void);
VALA_EXTERN FontManagerGoogleFontsSampleList* font_manager_google_fonts_sample_list_construct (GType object_type);
static void font_manager_google_fonts_preview_page_on_mode_action_activated (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      FontManagerGoogleFontsPreviewPage* self);
static void __lambda166_ (FontManagerGoogleFontsPreviewPage* self);
VALA_EXTERN void font_manager_google_fonts_preview_page_reload_preview (FontManagerGoogleFontsPreviewPage* self);
static void ___lambda166__font_manager_preview_colors_style_updated (FontManagerPreviewColors* _sender,
                                                              gpointer self);
static void font_manager_google_fonts_preview_page_on_item_selected (FontManagerGoogleFontsPreviewPage* self);
static void _font_manager_google_fonts_preview_page_on_item_selected_g_object_notify (GObject* _sender,
                                                                               GParamSpec* pspec,
                                                                               gpointer self);
static void font_manager_google_fonts_preview_page_on_sample_selected (FontManagerGoogleFontsPreviewPage* self,
                                                                const gchar* sample);
static void _font_manager_google_fonts_preview_page_on_sample_selected_font_manager_google_fonts_sample_list_row_selected (FontManagerGoogleFontsSampleList* _sender,
                                                                                                                    const gchar* sample,
                                                                                                                    gpointer self);
static void font_manager_google_fonts_preview_page_on_undo_clicked (FontManagerGoogleFontsPreviewPage* self);
static void _font_manager_google_fonts_preview_page_on_undo_clicked_font_manager_preview_controls_undo_clicked (FontManagerPreviewControls* _sender,
                                                                                                         gpointer self);
static void font_manager_google_fonts_preview_page_on_entry_changed (FontManagerGoogleFontsPreviewPage* self);
static void _font_manager_google_fonts_preview_page_on_entry_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                                    gpointer self);
static void font_manager_google_fonts_preview_page_update_waterfall_body (FontManagerGoogleFontsPreviewPage* self);
static void _font_manager_google_fonts_preview_page_update_waterfall_body_g_object_notify (GObject* _sender,
                                                                                    GParamSpec* pspec,
                                                                                    gpointer self);
static void _font_manager_google_fonts_preview_page_reload_preview_g_object_notify (GObject* _sender,
                                                                             GParamSpec* pspec,
                                                                             gpointer self);
static void font_manager_google_fonts_preview_page_on_edit_toggled (FontManagerGoogleFontsPreviewPage* self,
                                                             gboolean active);
static void _font_manager_google_fonts_preview_page_on_edit_toggled_font_manager_preview_controls_edit_toggled (FontManagerPreviewControls* _sender,
                                                                                                         gboolean object,
                                                                                                         gpointer self);
static void __lambda174_ (FontManagerGoogleFontsPreviewPage* self);
VALA_EXTERN FontManagerWaterfallSettings* font_manager_google_fonts_preview_page_get_waterfall_settings (FontManagerGoogleFontsPreviewPage* self);
static void ___lambda174__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void __lambda175_ (FontManagerGoogleFontsPreviewPage* self);
static gboolean __lambda176_ (FontManagerGoogleFontsPreviewPage* self);
VALA_EXTERN void font_manager_google_fonts_preview_page_set_min_waterfall_size (FontManagerGoogleFontsPreviewPage* self,
                                                                    gdouble value);
VALA_EXTERN void font_manager_google_fonts_preview_page_set_max_waterfall_size (FontManagerGoogleFontsPreviewPage* self,
                                                                    gdouble value);
VALA_EXTERN void font_manager_google_fonts_preview_page_set_waterfall_size_ratio (FontManagerGoogleFontsPreviewPage* self,
                                                                      gdouble value);
static gboolean ___lambda176__gsource_func (gpointer self);
static void ___lambda175__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void __lambda177_ (FontManagerGoogleFontsPreviewPage* self);
static void ___lambda177__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void font_manager_google_fonts_preview_page_on_show_context_menu (FontManagerGoogleFontsPreviewPage* self,
                                                                  gint n_press,
                                                                  gdouble x,
                                                                  gdouble y);
static void _font_manager_google_fonts_preview_page_on_show_context_menu_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                                             gint n_press,
                                                                                             gdouble x,
                                                                                             gdouble y,
                                                                                             gpointer self);
static void __lambda178_ (FontManagerGoogleFontsPreviewPage* self);
static void ___lambda178__gtk_widget_map (GtkWidget* _sender,
                                   gpointer self);
static void font_manager_google_fonts_preview_page_update_menu_button (FontManagerGoogleFontsPreviewPage* self);
VALA_EXTERN FontManagerPreviewPageMode font_manager_google_fonts_preview_page_get_preview_mode (FontManagerGoogleFontsPreviewPage* self);
static GVariant* _variant_new4 (const gchar* value);
VALA_EXTERN void font_manager_google_fonts_preview_page_restore_state (FontManagerGoogleFontsPreviewPage* self,
                                                           GSettings* settings);
static void __lambda179_ (FontManagerGoogleFontsPreviewPage* self,
                   const gchar* key);
static void ___lambda179__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
VALA_EXTERN void font_manager_google_fonts_preview_page_set_preview_text (FontManagerGoogleFontsPreviewPage* self,
                                                              const gchar* value);
VALA_EXTERN void font_manager_google_fonts_preview_page_set_active_preview_text (FontManagerGoogleFontsPreviewPage* self,
                                                                     const gchar* value);
static gchar* _variant_get3 (GVariant* value);
VALA_EXTERN void font_manager_google_fonts_preview_page_set_preview_mode (FontManagerGoogleFontsPreviewPage* self,
                                                              FontManagerPreviewPageMode value);
static gchar* font_manager_google_fonts_preview_page_generate_waterfall (FontManagerGoogleFontsPreviewPage* self);
static gchar* font_manager_google_fonts_preview_page_generate_lorem_ipsum (FontManagerGoogleFontsPreviewPage* self);
static gchar* font_manager_google_fonts_preview_page_generate_active_preview (FontManagerGoogleFontsPreviewPage* self);
VALA_EXTERN FontManagerStringSet* font_manager_google_fonts_font_get_subsets (FontManagerGoogleFontsFont* self);
VALA_EXTERN void font_manager_google_fonts_sample_list_set_items (FontManagerGoogleFontsSampleList* self,
                                                      FontManagerStringSet* value);
VALA_EXTERN const gchar* font_manager_google_fonts_font_get_family (FontManagerGoogleFontsFont* self);
VALA_EXTERN gchar* font_manager_google_fonts_font_to_display_name (FontManagerGoogleFontsFont* self);
VALA_EXTERN const gchar* font_manager_google_fonts_preview_page_get_active_preview_text (FontManagerGoogleFontsPreviewPage* self);
VALA_EXTERN GObject* font_manager_google_fonts_preview_page_get_selected_item (FontManagerGoogleFontsPreviewPage* self);
VALA_EXTERN GType font_manager_google_fonts_family_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerGoogleFontsFamily, g_object_unref)
VALA_EXTERN FontManagerGoogleFontsFont* font_manager_google_fonts_family_get_default_variant (FontManagerGoogleFontsFamily* self);
VALA_EXTERN GType font_manager_google_fonts_sample_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerGoogleFontsSampleModel, g_object_unref)
VALA_EXTERN FontManagerGoogleFontsSampleModel* font_manager_google_fonts_sample_list_get_model (FontManagerGoogleFontsSampleList* self);
static gdouble font_manager_google_fonts_preview_page_get_next_line_size (FontManagerGoogleFontsPreviewPage* self,
                                                                   gdouble current);
VALA_EXTERN gdouble font_manager_google_fonts_preview_page_get_waterfall_size_ratio (FontManagerGoogleFontsPreviewPage* self);
static gchar* font_manager_google_fonts_preview_page_get_current_header (FontManagerGoogleFontsPreviewPage* self);
VALA_EXTERN GtkJustification font_manager_google_fonts_preview_page_get_justification (FontManagerGoogleFontsPreviewPage* self);
VALA_EXTERN gdouble font_manager_google_fonts_preview_page_get_preview_size (FontManagerGoogleFontsPreviewPage* self);
VALA_EXTERN const gchar* font_manager_google_fonts_font_get_style (FontManagerGoogleFontsFont* self);
VALA_EXTERN gint font_manager_google_fonts_font_get_weight (FontManagerGoogleFontsFont* self);
VALA_EXTERN gchar* font_manager_google_fonts_font_to_font_face_rule (FontManagerGoogleFontsFont* self);
VALA_EXTERN gdouble font_manager_google_fonts_preview_page_get_min_waterfall_size (FontManagerGoogleFontsPreviewPage* self);
VALA_EXTERN gdouble font_manager_google_fonts_preview_page_get_max_waterfall_size (FontManagerGoogleFontsPreviewPage* self);
VALA_EXTERN gboolean font_manager_google_fonts_preview_page_get_show_line_size (FontManagerGoogleFontsPreviewPage* self);
VALA_EXTERN const gchar* font_manager_google_fonts_preview_page_get_preview_text (FontManagerGoogleFontsPreviewPage* self);
VALA_EXTERN gint font_manager_google_fonts_preview_page_get_predefined_size (FontManagerGoogleFontsPreviewPage* self);
VALA_EXTERN void font_manager_google_fonts_preview_page_set_predefined_size (FontManagerGoogleFontsPreviewPage* self,
                                                                 gint value);
VALA_EXTERN void font_manager_google_fonts_preview_page_set_show_line_size (FontManagerGoogleFontsPreviewPage* self,
                                                                gboolean value);
VALA_EXTERN void font_manager_google_fonts_preview_page_set_preview_size (FontManagerGoogleFontsPreviewPage* self,
                                                              gdouble value);
VALA_EXTERN void font_manager_google_fonts_preview_page_set_selected_item (FontManagerGoogleFontsPreviewPage* self,
                                                               GObject* value);
VALA_EXTERN void font_manager_google_fonts_preview_page_set_justification (FontManagerGoogleFontsPreviewPage* self,
                                                               GtkJustification value);
VALA_EXTERN void font_manager_google_fonts_preview_page_set_waterfall_settings (FontManagerGoogleFontsPreviewPage* self,
                                                                    FontManagerWaterfallSettings* value);
static void font_manager_google_fonts_preview_page_finalize (GObject * obj);
static GType font_manager_google_fonts_preview_page_get_type_once (void);
static void _vala_font_manager_google_fonts_preview_page_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec);
static void _vala_font_manager_google_fonts_preview_page_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

WebKitWebView*
font_manager_google_fonts_create_webview (void)
{
	WebKitWebView* webview = NULL;
	WebKitWebView* _tmp0_;
	WebKitSettings* settings = NULL;
	WebKitSettings* _tmp1_ = NULL;
	WebKitWebContext* _tmp2_;
	WebKitWebContext* _tmp3_;
	WebKitWebContext* _tmp4_;
	WebKitNetworkSession* _tmp5_;
	WebKitNetworkSession* _tmp6_;
	WebKitWebView* result;
	_tmp0_ = (WebKitWebView*) webkit_web_view_new ();
	g_object_ref_sink (_tmp0_);
	webview = _tmp0_;
	_tmp1_ = webkit_settings_new ();
	webkit_settings_set_allow_modal_dialogs (_tmp1_, FALSE);
	webkit_settings_set_auto_load_images (_tmp1_, FALSE);
	webkit_settings_set_enable_back_forward_navigation_gestures (_tmp1_, FALSE);
	webkit_settings_set_enable_developer_extras (_tmp1_, FALSE);
	webkit_settings_set_enable_fullscreen (_tmp1_, FALSE);
	webkit_settings_set_enable_media (_tmp1_, FALSE);
	webkit_settings_set_enable_media_stream (_tmp1_, FALSE);
	webkit_settings_set_enable_site_specific_quirks (_tmp1_, FALSE);
	webkit_settings_set_enable_smooth_scrolling (_tmp1_, TRUE);
	webkit_settings_set_enable_webaudio (_tmp1_, FALSE);
	settings = _tmp1_;
	webkit_settings_set_user_agent_with_application_details (settings, PACKAGE_NAME, PACKAGE_VERSION);
	webkit_web_view_set_settings (webview, settings);
	g_object_get (webview, "web-context", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	webkit_web_context_set_cache_model (_tmp4_, WEBKIT_CACHE_MODEL_DOCUMENT_BROWSER);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = webkit_web_view_get_network_session (webview);
	_tmp6_ = _tmp5_;
	webkit_network_session_prefetch_dns (_tmp6_, "http://fonts.gstatic.com/");
	font_manager_widget_set_expand ((GtkWidget*) webview, TRUE);
	result = webview;
	_g_object_unref0 (settings);
	return result;
}

static inline gpointer
font_manager_google_fonts_preview_page_get_instance_private (FontManagerGoogleFontsPreviewPage* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerGoogleFontsPreviewPage_private_offset);
}

static void
__lambda166_ (FontManagerGoogleFontsPreviewPage* self)
{
	font_manager_google_fonts_preview_page_reload_preview (self);
}

static void
___lambda166__font_manager_preview_colors_style_updated (FontManagerPreviewColors* _sender,
                                                         gpointer self)
{
	__lambda166_ ((FontManagerGoogleFontsPreviewPage*) self);
}

static void
_font_manager_google_fonts_preview_page_on_item_selected_g_object_notify (GObject* _sender,
                                                                          GParamSpec* pspec,
                                                                          gpointer self)
{
	font_manager_google_fonts_preview_page_on_item_selected ((FontManagerGoogleFontsPreviewPage*) self);
}

static void
_font_manager_google_fonts_preview_page_on_sample_selected_font_manager_google_fonts_sample_list_row_selected (FontManagerGoogleFontsSampleList* _sender,
                                                                                                               const gchar* sample,
                                                                                                               gpointer self)
{
	font_manager_google_fonts_preview_page_on_sample_selected ((FontManagerGoogleFontsPreviewPage*) self, sample);
}

static void
_font_manager_google_fonts_preview_page_on_undo_clicked_font_manager_preview_controls_undo_clicked (FontManagerPreviewControls* _sender,
                                                                                                    gpointer self)
{
	font_manager_google_fonts_preview_page_on_undo_clicked ((FontManagerGoogleFontsPreviewPage*) self);
}

static void
_font_manager_google_fonts_preview_page_on_entry_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                               gpointer self)
{
	font_manager_google_fonts_preview_page_on_entry_changed ((FontManagerGoogleFontsPreviewPage*) self);
}

static void
_font_manager_google_fonts_preview_page_update_waterfall_body_g_object_notify (GObject* _sender,
                                                                               GParamSpec* pspec,
                                                                               gpointer self)
{
	font_manager_google_fonts_preview_page_update_waterfall_body ((FontManagerGoogleFontsPreviewPage*) self);
}

static void
_font_manager_google_fonts_preview_page_reload_preview_g_object_notify (GObject* _sender,
                                                                        GParamSpec* pspec,
                                                                        gpointer self)
{
	font_manager_google_fonts_preview_page_reload_preview ((FontManagerGoogleFontsPreviewPage*) self);
}

static void
_font_manager_google_fonts_preview_page_on_edit_toggled_font_manager_preview_controls_edit_toggled (FontManagerPreviewControls* _sender,
                                                                                                    gboolean object,
                                                                                                    gpointer self)
{
	font_manager_google_fonts_preview_page_on_edit_toggled ((FontManagerGoogleFontsPreviewPage*) self, object);
}

static void
__lambda174_ (FontManagerGoogleFontsPreviewPage* self)
{
	GBindingFlags _flags = 0U;
	FontManagerWaterfallSettings* _tmp0_;
	FontManagerWaterfallSettings* _tmp1_;
	_flags = G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE;
	_tmp0_ = self->priv->_waterfall_settings;
	g_object_bind_property_with_closures ((GObject*) _tmp0_, "predefined-size", (GObject*) self, "predefined-size", _flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp1_ = self->priv->_waterfall_settings;
	g_object_bind_property_with_closures ((GObject*) _tmp1_, "show-line-size", (GObject*) self, "show-line-size", _flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
}

static void
___lambda174__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda174_ ((FontManagerGoogleFontsPreviewPage*) self);
}

static gboolean
__lambda176_ (FontManagerGoogleFontsPreviewPage* self)
{
	FontManagerWaterfallSettings* _tmp0_;
	FontManagerWaterfallSettings* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	FontManagerWaterfallSettings* _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	FontManagerWaterfallSettings* _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gboolean result;
	_tmp0_ = self->priv->_waterfall_settings;
	font_manager_waterfall_settings_on_selection_changed (_tmp0_);
	_tmp1_ = self->priv->_waterfall_settings;
	_tmp2_ = font_manager_waterfall_settings_get_minimum (_tmp1_);
	_tmp3_ = _tmp2_;
	font_manager_google_fonts_preview_page_set_min_waterfall_size (self, _tmp3_);
	_tmp4_ = self->priv->_waterfall_settings;
	_tmp5_ = font_manager_waterfall_settings_get_maximum (_tmp4_);
	_tmp6_ = _tmp5_;
	font_manager_google_fonts_preview_page_set_max_waterfall_size (self, _tmp6_);
	_tmp7_ = self->priv->_waterfall_settings;
	_tmp8_ = font_manager_waterfall_settings_get_ratio (_tmp7_);
	_tmp9_ = _tmp8_;
	font_manager_google_fonts_preview_page_set_waterfall_size_ratio (self, _tmp9_);
	font_manager_google_fonts_preview_page_update_waterfall_body (self);
	font_manager_google_fonts_preview_page_reload_preview (self);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda176__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda176_ ((FontManagerGoogleFontsPreviewPage*) self);
	return result;
}

static void
__lambda175_ (FontManagerGoogleFontsPreviewPage* self)
{
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda176__gsource_func, g_object_ref (self), g_object_unref);
}

static void
___lambda175__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda175_ ((FontManagerGoogleFontsPreviewPage*) self);
}

static void
__lambda177_ (FontManagerGoogleFontsPreviewPage* self)
{
	font_manager_google_fonts_preview_page_update_waterfall_body (self);
	font_manager_google_fonts_preview_page_reload_preview (self);
}

static void
___lambda177__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda177_ ((FontManagerGoogleFontsPreviewPage*) self);
}

static void
_font_manager_google_fonts_preview_page_on_show_context_menu_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                                        gint n_press,
                                                                                        gdouble x,
                                                                                        gdouble y,
                                                                                        gpointer self)
{
	font_manager_google_fonts_preview_page_on_show_context_menu ((FontManagerGoogleFontsPreviewPage*) self, n_press, x, y);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda178_ (FontManagerGoogleFontsPreviewPage* self)
{
	GtkTextView* _tmp0_;
	_tmp0_ = self->priv->textview;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}

static void
___lambda178__gtk_widget_map (GtkWidget* _sender,
                              gpointer self)
{
	__lambda178_ ((FontManagerGoogleFontsPreviewPage*) self);
}

FontManagerGoogleFontsPreviewPage*
font_manager_google_fonts_preview_page_construct (GType object_type)
{
	FontManagerGoogleFontsPreviewPage * self = NULL;
	WebKitWebView* _tmp0_;
	WebKitWebView* _tmp1_;
	WebKitWebView* _tmp2_;
	GtkWidget* _tmp3_;
	GtkTextView* _tmp4_ = NULL;
	GtkTextView* _tmp5_;
	GtkTextView* _tmp6_;
	FontManagerPreviewControls* _tmp7_;
	GtkRevealer* _tmp8_;
	GtkRevealer* _tmp9_;
	FontManagerPreviewControls* _tmp10_;
	GtkRevealer* _tmp11_;
	GtkStack* _tmp12_;
	GtkStack* _tmp13_;
	GtkStack* _tmp14_;
	WebKitWebView* _tmp15_;
	GtkStack* _tmp16_;
	GtkTextView* _tmp17_;
	GtkStack* _tmp18_;
	FontManagerPreviewEntry* _tmp19_;
	GtkCenterBox* _tmp20_;
	FontManagerPreviewEntry* _tmp21_;
	FontManagerFontScale* _tmp22_;
	GtkRevealer* _tmp23_;
	GtkRevealer* _tmp24_;
	FontManagerFontScale* _tmp25_;
	GtkRevealer* _tmp26_;
	FontManagerGoogleFontsSampleList* _tmp27_;
	GtkMenuButton* _tmp28_;
	FontManagerGoogleFontsSampleList* _tmp29_;
	GtkMenuButton* _tmp30_;
	FontManagerPreviewColors* _tmp31_;
	GBindingFlags flags = 0U;
	FontManagerFontScale* _tmp32_;
	FontManagerPreviewEntry* _tmp33_;
	FontManagerPreviewControls* _tmp34_;
	GtkTextView* _tmp35_;
	GtkTextView* _tmp36_;
	GtkTextBuffer* _tmp37_;
	GtkTextBuffer* _tmp38_;
	FontManagerGoogleFontsSampleList* _tmp39_;
	FontManagerPreviewControls* _tmp40_;
	FontManagerPreviewEntry* _tmp41_;
	gchar** _tmp42_;
	gint _tmp42__length1;
	gchar** _tmp46_;
	gint _tmp46__length1;
	FontManagerPreviewControls* _tmp50_;
	GtkGesture* right_click = NULL;
	GtkGestureClick* _tmp51_ = NULL;
	WebKitWebView* _tmp52_;
	GtkEventController* _tmp53_;
	GtkTextView* _tmp54_;
	self = (FontManagerGoogleFontsPreviewPage*) g_object_new (object_type, NULL);
	_tmp0_ = font_manager_google_fonts_create_webview ();
	_g_object_unref0 (self->priv->webview);
	self->priv->webview = _tmp0_;
	_tmp1_ = self->priv->webview;
	gtk_widget_add_css_class ((GtkWidget*) _tmp1_, "FontManagerFontPreviewArea");
	_tmp2_ = self->priv->webview;
	_tmp3_ = gtk_widget_get_first_child ((GtkWidget*) _tmp2_);
	gtk_widget_add_css_class (_tmp3_, "FontManagerFontPreviewArea");
	_tmp4_ = (GtkTextView*) gtk_text_view_new ();
	gtk_text_view_set_monospace (_tmp4_, TRUE);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->textview);
	self->priv->textview = _tmp4_;
	_tmp5_ = self->priv->textview;
	gtk_widget_add_css_class ((GtkWidget*) _tmp5_, "FontManagerFontPreviewArea");
	_tmp6_ = self->priv->textview;
	font_manager_widget_set_margin ((GtkWidget*) _tmp6_, 64);
	_tmp7_ = (FontManagerPreviewControls*) font_manager_preview_controls_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->preview_controls);
	self->priv->preview_controls = _tmp7_;
	_tmp8_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->controls_revealer);
	self->priv->controls_revealer = _tmp8_;
	_tmp9_ = self->priv->controls_revealer;
	_tmp10_ = self->priv->preview_controls;
	gtk_revealer_set_child (_tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->controls_revealer;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp11_);
	_tmp12_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->preview_stack);
	self->priv->preview_stack = _tmp12_;
	_tmp13_ = self->priv->preview_stack;
	gtk_widget_add_css_class ((GtkWidget*) _tmp13_, "FontManagerFontPreviewArea");
	_tmp14_ = self->priv->preview_stack;
	_tmp15_ = self->priv->webview;
	gtk_stack_add_named (_tmp14_, (GtkWidget*) _tmp15_, "WebView");
	_tmp16_ = self->priv->preview_stack;
	_tmp17_ = self->priv->textview;
	gtk_stack_add_named (_tmp16_, (GtkWidget*) _tmp17_, "TextView");
	_tmp18_ = self->priv->preview_stack;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp18_);
	_tmp19_ = font_manager_preview_entry_new ();
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->entry);
	self->priv->entry = _tmp19_;
	_tmp20_ = self->priv->controls;
	_tmp21_ = self->priv->entry;
	gtk_center_box_set_center_widget (_tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = (FontManagerFontScale*) font_manager_font_scale_new ();
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->fontscale);
	self->priv->fontscale = _tmp22_;
	_tmp23_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->fontscale_revealer);
	self->priv->fontscale_revealer = _tmp23_;
	_tmp24_ = self->priv->fontscale_revealer;
	_tmp25_ = self->priv->fontscale;
	gtk_revealer_set_child (_tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = self->priv->fontscale_revealer;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp26_);
	_tmp27_ = font_manager_google_fonts_sample_list_new ();
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->samples);
	self->priv->samples = _tmp27_;
	_tmp28_ = self->priv->sample_button;
	_tmp29_ = self->priv->samples;
	gtk_menu_button_set_popover (_tmp28_, (GtkWidget*) _tmp29_);
	_tmp30_ = self->priv->menu_button;
	font_manager_set_preview_page_mode_menu_and_actions ((GtkWidget*) self, (GtkWidget*) _tmp30_, (GCallback) font_manager_google_fonts_preview_page_on_mode_action_activated);
	_tmp31_ = self->priv->preview_colors;
	g_signal_connect_object (_tmp31_, "style-updated", (GCallback) ___lambda166__font_manager_preview_colors_style_updated, self, 0);
	flags = G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE;
	_tmp32_ = self->priv->fontscale;
	g_object_bind_property_with_closures ((GObject*) self, "preview-size", (GObject*) _tmp32_, "value", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp33_ = self->priv->entry;
	g_object_bind_property_with_closures ((GObject*) self, "preview-text", (GObject*) _tmp33_, "placeholder-text", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp34_ = self->priv->preview_controls;
	g_object_bind_property_with_closures ((GObject*) self, "justification", (GObject*) _tmp34_, "justification", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp35_ = self->priv->textview;
	g_object_bind_property_with_closures ((GObject*) self, "justification", (GObject*) _tmp35_, "justification", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp36_ = self->priv->textview;
	_tmp37_ = gtk_text_view_get_buffer (_tmp36_);
	_tmp38_ = _tmp37_;
	g_object_bind_property_with_closures ((GObject*) self, "active-preview-text", (GObject*) _tmp38_, "text", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_signal_connect_object ((GObject*) self, "notify::selected-item", (GCallback) _font_manager_google_fonts_preview_page_on_item_selected_g_object_notify, self, G_CONNECT_AFTER);
	_tmp39_ = self->priv->samples;
	g_signal_connect_object (_tmp39_, "row-selected", (GCallback) _font_manager_google_fonts_preview_page_on_sample_selected_font_manager_google_fonts_sample_list_row_selected, self, 0);
	_tmp40_ = self->priv->preview_controls;
	g_signal_connect_object (_tmp40_, "undo-clicked", (GCallback) _font_manager_google_fonts_preview_page_on_undo_clicked_font_manager_preview_controls_undo_clicked, self, 0);
	_tmp41_ = self->priv->entry;
	g_signal_connect_object ((GtkEditable*) _tmp41_, "changed", (GCallback) _font_manager_google_fonts_preview_page_on_entry_changed_gtk_editable_changed, self, 0);
	_tmp42_ = self->priv->affects_waterfall;
	_tmp42__length1 = self->priv->affects_waterfall_length1;
	{
		gchar** property_collection = NULL;
		gint property_collection_length1 = 0;
		gint _property_collection_size_ = 0;
		gint property_it = 0;
		property_collection = _tmp42_;
		property_collection_length1 = _tmp42__length1;
		for (property_it = 0; property_it < property_collection_length1; property_it = property_it + 1) {
			gchar* _tmp43_;
			gchar* property = NULL;
			_tmp43_ = g_strdup (property_collection[property_it]);
			property = _tmp43_;
			{
				const gchar* _tmp44_;
				gchar* _tmp45_;
				_tmp44_ = property;
				_tmp45_ = g_strconcat ("notify::", _tmp44_, NULL);
				g_signal_connect_object ((GObject*) self, _tmp45_, (GCallback) _font_manager_google_fonts_preview_page_update_waterfall_body_g_object_notify, self, G_CONNECT_AFTER);
				_g_free0 (_tmp45_);
				_g_free0 (property);
			}
		}
	}
	_tmp46_ = self->priv->requires_reload;
	_tmp46__length1 = self->priv->requires_reload_length1;
	{
		gchar** property_collection = NULL;
		gint property_collection_length1 = 0;
		gint _property_collection_size_ = 0;
		gint property_it = 0;
		property_collection = _tmp46_;
		property_collection_length1 = _tmp46__length1;
		for (property_it = 0; property_it < property_collection_length1; property_it = property_it + 1) {
			gchar* _tmp47_;
			gchar* property = NULL;
			_tmp47_ = g_strdup (property_collection[property_it]);
			property = _tmp47_;
			{
				const gchar* _tmp48_;
				gchar* _tmp49_;
				_tmp48_ = property;
				_tmp49_ = g_strconcat ("notify::", _tmp48_, NULL);
				g_signal_connect_object ((GObject*) self, _tmp49_, (GCallback) _font_manager_google_fonts_preview_page_reload_preview_g_object_notify, self, G_CONNECT_AFTER);
				_g_free0 (_tmp49_);
				_g_free0 (property);
			}
		}
	}
	_tmp50_ = self->priv->preview_controls;
	g_signal_connect_object (_tmp50_, "edit-toggled", (GCallback) _font_manager_google_fonts_preview_page_on_edit_toggled_font_manager_preview_controls_edit_toggled, self, 0);
	font_manager_google_fonts_preview_page_update_waterfall_body (self);
	font_manager_google_fonts_preview_page_reload_preview (self);
	g_signal_connect_object ((GObject*) self, "notify::waterfall-settings", (GCallback) ___lambda174__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::predefined-size", (GCallback) ___lambda175__g_object_notify, self, G_CONNECT_AFTER);
	g_signal_connect_object ((GObject*) self, "notify::show-line-size", (GCallback) ___lambda177__g_object_notify, self, G_CONNECT_AFTER);
	memset (&self->priv->clicked_area, 0, sizeof (GdkRectangle));
	_tmp51_ = (GtkGestureClick*) gtk_gesture_click_new ();
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp51_, (guint) GDK_BUTTON_SECONDARY);
	right_click = (GtkGesture*) _tmp51_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (right_click, gtk_gesture_click_get_type (), GtkGestureClick), "pressed", (GCallback) _font_manager_google_fonts_preview_page_on_show_context_menu_gtk_gesture_click_pressed, self, 0);
	_tmp52_ = self->priv->webview;
	_tmp53_ = _g_object_ref0 ((GtkEventController*) right_click);
	gtk_widget_add_controller ((GtkWidget*) _tmp52_, _tmp53_);
	_tmp54_ = self->priv->textview;
	g_signal_connect_object ((GtkWidget*) _tmp54_, "map", (GCallback) ___lambda178__gtk_widget_map, self, G_CONNECT_AFTER);
	_g_object_unref0 (right_click);
	return self;
}

FontManagerGoogleFontsPreviewPage*
font_manager_google_fonts_preview_page_new (void)
{
	return font_manager_google_fonts_preview_page_construct (FONT_MANAGER_GOOGLE_FONTS_TYPE_PREVIEW_PAGE);
}

static GVariant*
_variant_new4 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
font_manager_google_fonts_preview_page_update_menu_button (FontManagerGoogleFontsPreviewPage* self)
{
	GVariant* args = NULL;
	FontManagerPreviewPageMode _tmp0_;
	const gchar* _tmp1_;
	GVariant* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_preview_mode;
	_tmp1_ = font_manager_preview_page_mode_to_string (_tmp0_);
	_tmp2_ = _variant_new4 (_tmp1_);
	args = _tmp2_;
	gtk_widget_activate_action_variant ((GtkWidget*) self, "preview.mode", args);
	_g_variant_unref0 (args);
	return;
}

static void
__lambda179_ (FontManagerGoogleFontsPreviewPage* self,
              const gchar* key)
{
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "preview-mode") == 0) {
		font_manager_google_fonts_preview_page_update_menu_button (self);
	}
}

static void
___lambda179__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
	__lambda179_ ((FontManagerGoogleFontsPreviewPage*) self, key);
}

void
font_manager_google_fonts_preview_page_restore_state (FontManagerGoogleFontsPreviewPage* self,
                                                      GSettings* settings)
{
	FontManagerPreviewColors* _tmp0_;
	GSettingsBindFlags flags = 0U;
	g_return_if_fail (self != NULL);
	if (settings == NULL) {
		return;
	}
	_tmp0_ = self->priv->preview_colors;
	font_manager_preview_colors_restore_state (_tmp0_, settings);
	flags = G_SETTINGS_BIND_DEFAULT;
	g_settings_bind (settings, "preview-font-size", (GObject*) self, "preview-size", flags);
	g_settings_bind (settings, "preview-mode", (GObject*) self, "preview-mode", flags);
	font_manager_google_fonts_preview_page_update_menu_button (self);
	g_signal_connect_object (settings, "changed", (GCallback) ___lambda179__g_settings_changed, self, G_CONNECT_AFTER);
	g_settings_bind (settings, "google-fonts-preview-text", (GObject*) self, "preview-text", flags);
	return;
}

static void
font_manager_google_fonts_preview_page_on_sample_selected (FontManagerGoogleFontsPreviewPage* self,
                                                           const gchar* sample)
{
	FontManagerPreviewEntry* _tmp0_;
	FontManagerPreviewPageMode _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sample != NULL);
	_tmp0_ = self->priv->entry;
	gtk_editable_set_text ((GtkEditable*) _tmp0_, sample);
	_tmp1_ = self->priv->_preview_mode;
	if (_tmp1_ == FONT_MANAGER_PREVIEW_PAGE_MODE_PREVIEW) {
		font_manager_google_fonts_preview_page_set_preview_text (self, sample);
		font_manager_google_fonts_preview_page_reload_preview (self);
	}
	return;
}

static void
font_manager_google_fonts_preview_page_on_undo_clicked (FontManagerGoogleFontsPreviewPage* self)
{
	g_return_if_fail (self != NULL);
	font_manager_google_fonts_preview_page_set_active_preview_text (self, NULL);
	font_manager_google_fonts_preview_page_reload_preview (self);
	return;
}

static void
font_manager_google_fonts_preview_page_on_edit_toggled (FontManagerGoogleFontsPreviewPage* self,
                                                        gboolean active)
{
	const gchar* _tmp0_ = NULL;
	GtkStack* _tmp1_;
	g_return_if_fail (self != NULL);
	if (active) {
		_tmp0_ = "TextView";
	} else {
		_tmp0_ = "WebView";
	}
	_tmp1_ = self->priv->preview_stack;
	gtk_stack_set_visible_child_name (_tmp1_, _tmp0_);
	if (!active) {
		font_manager_google_fonts_preview_page_reload_preview (self);
	}
	return;
}

static gchar*
_variant_get3 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static void
font_manager_google_fonts_preview_page_on_mode_action_activated (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 FontManagerGoogleFontsPreviewPage* self)
{
	FontManagerPreviewPageMode mode = 0;
	gchar* param = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GtkMenuButton* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (parameter != NULL);
	mode = FONT_MANAGER_PREVIEW_PAGE_MODE_LOREM_IPSUM;
	_tmp0_ = _variant_get3 (parameter);
	param = _tmp0_;
	_tmp1_ = param;
	if (g_strcmp0 (_tmp1_, "Waterfall") == 0) {
		mode = FONT_MANAGER_PREVIEW_PAGE_MODE_WATERFALL;
	}
	_tmp2_ = param;
	if (g_strcmp0 (_tmp2_, "Preview") == 0) {
		mode = FONT_MANAGER_PREVIEW_PAGE_MODE_PREVIEW;
	}
	font_manager_google_fonts_preview_page_set_preview_mode (self, mode);
	g_simple_action_set_state (action, parameter);
	_tmp3_ = self->priv->sample_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, mode == FONT_MANAGER_PREVIEW_PAGE_MODE_WATERFALL);
	_g_free0 (param);
	return;
}

static void
font_manager_google_fonts_preview_page_on_entry_changed (FontManagerGoogleFontsPreviewPage* self)
{
	const gchar* _tmp0_ = NULL;
	FontManagerPreviewEntry* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->entry;
	_tmp2_ = gtk_entry_get_text_length ((GtkEntry*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > ((guint) 0)) {
		FontManagerPreviewEntry* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = self->priv->entry;
		_tmp5_ = gtk_editable_get_text ((GtkEditable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = NULL;
	}
	font_manager_google_fonts_preview_page_set_preview_text (self, _tmp0_);
	return;
}

void
font_manager_google_fonts_preview_page_reload_preview (FontManagerGoogleFontsPreviewPage* self)
{
	gchar* html = NULL;
	gchar* _tmp0_;
	FontManagerGoogleFontsFont* _tmp1_;
	GtkMenuButton* _tmp20_;
	FontManagerPreviewPageMode _tmp21_;
	GtkRevealer* _tmp22_;
	FontManagerPreviewPageMode _tmp23_;
	FontManagerPreviewControls* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	GtkRevealer* _tmp27_;
	FontManagerPreviewPageMode _tmp28_;
	FontManagerPreviewEntry* _tmp29_;
	FontManagerPreviewPageMode _tmp30_;
	WebKitWebView* _tmp31_;
	const gchar* _tmp32_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("<html><body><p> </p></body></html>");
	html = _tmp0_;
	_tmp1_ = self->priv->font;
	if (_tmp1_ != NULL) {
		FontManagerPreviewPageMode _tmp2_;
		FontManagerGoogleFontsSampleList* _tmp6_;
		FontManagerGoogleFontsFont* _tmp7_;
		FontManagerStringSet* _tmp8_;
		FontManagerStringSet* _tmp9_;
		gchar* description = NULL;
		FontManagerGoogleFontsFont* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		FontManagerGoogleFontsFont* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		FontManagerPreviewControls* _tmp18_;
		const gchar* _tmp19_;
		_tmp2_ = self->priv->_preview_mode;
		switch (_tmp2_) {
			case FONT_MANAGER_PREVIEW_PAGE_MODE_WATERFALL:
			{
				gchar* _tmp3_;
				_tmp3_ = font_manager_google_fonts_preview_page_generate_waterfall (self);
				_g_free0 (html);
				html = _tmp3_;
				break;
			}
			case FONT_MANAGER_PREVIEW_PAGE_MODE_LOREM_IPSUM:
			{
				gchar* _tmp4_;
				_tmp4_ = font_manager_google_fonts_preview_page_generate_lorem_ipsum (self);
				_g_free0 (html);
				html = _tmp4_;
				break;
			}
			case FONT_MANAGER_PREVIEW_PAGE_MODE_PREVIEW:
			{
				gchar* _tmp5_;
				_tmp5_ = font_manager_google_fonts_preview_page_generate_active_preview (self);
				_g_free0 (html);
				html = _tmp5_;
				break;
			}
			default:
			{
				g_assert_not_reached ();
			}
		}
		_tmp6_ = self->priv->samples;
		_tmp7_ = self->priv->font;
		_tmp8_ = font_manager_google_fonts_font_get_subsets (_tmp7_);
		_tmp9_ = _tmp8_;
		font_manager_google_fonts_sample_list_set_items (_tmp6_, _tmp9_);
		_tmp10_ = self->priv->font;
		_tmp11_ = font_manager_google_fonts_font_get_family (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = self->priv->font;
		_tmp14_ = font_manager_google_fonts_font_to_display_name (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup_printf ("%s %s", _tmp12_, _tmp15_);
		_tmp17_ = _tmp16_;
		_g_free0 (_tmp15_);
		description = _tmp17_;
		_tmp18_ = self->priv->preview_controls;
		_tmp19_ = description;
		g_object_set (_tmp18_, "description", _tmp19_, NULL);
		_g_free0 (description);
	}
	_tmp20_ = self->priv->sample_button;
	_tmp21_ = self->priv->_preview_mode;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp20_, _tmp21_ != FONT_MANAGER_PREVIEW_PAGE_MODE_LOREM_IPSUM);
	_tmp22_ = self->priv->controls_revealer;
	_tmp23_ = self->priv->_preview_mode;
	gtk_revealer_set_reveal_child (_tmp22_, _tmp23_ == FONT_MANAGER_PREVIEW_PAGE_MODE_PREVIEW);
	_tmp24_ = self->priv->preview_controls;
	_tmp25_ = font_manager_google_fonts_preview_page_get_active_preview_text (self);
	_tmp26_ = _tmp25_;
	g_object_set (_tmp24_, "undo-available", g_strcmp0 (_tmp26_, DEFAULT_ACTIVE_TEXT) != 0, NULL);
	_tmp27_ = self->priv->fontscale_revealer;
	_tmp28_ = self->priv->_preview_mode;
	gtk_revealer_set_reveal_child (_tmp27_, _tmp28_ != FONT_MANAGER_PREVIEW_PAGE_MODE_WATERFALL);
	_tmp29_ = self->priv->entry;
	_tmp30_ = self->priv->_preview_mode;
	gtk_widget_set_visible ((GtkWidget*) _tmp29_, _tmp30_ == FONT_MANAGER_PREVIEW_PAGE_MODE_WATERFALL);
	_tmp31_ = self->priv->webview;
	_tmp32_ = html;
	webkit_web_view_load_html (_tmp31_, _tmp32_, NULL);
	_g_free0 (html);
	return;
}

static void
font_manager_google_fonts_preview_page_on_item_selected (FontManagerGoogleFontsPreviewPage* self)
{
	GObject* _tmp0_;
	guint langs = 0U;
	FontManagerGoogleFontsSampleList* _tmp5_;
	FontManagerGoogleFontsSampleModel* _tmp6_;
	FontManagerGoogleFontsSampleModel* _tmp7_;
	GtkMenuButton* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_selected_item;
	if (FONT_MANAGER_GOOGLE_FONTS_IS_FAMILY (_tmp0_)) {
		GObject* _tmp1_;
		FontManagerGoogleFontsFont* _tmp2_;
		_tmp1_ = self->priv->_selected_item;
		_tmp2_ = font_manager_google_fonts_family_get_default_variant (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY, FontManagerGoogleFontsFamily));
		_g_object_unref0 (self->priv->font);
		self->priv->font = _tmp2_;
	} else {
		GObject* _tmp3_;
		FontManagerGoogleFontsFont* _tmp4_;
		_tmp3_ = self->priv->_selected_item;
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT, FontManagerGoogleFontsFont));
		_g_object_unref0 (self->priv->font);
		self->priv->font = _tmp4_;
	}
	font_manager_google_fonts_preview_page_reload_preview (self);
	_tmp5_ = self->priv->samples;
	_tmp6_ = font_manager_google_fonts_sample_list_get_model (_tmp5_);
	_tmp7_ = _tmp6_;
	langs = g_list_model_get_n_items ((GListModel*) _tmp7_);
	_tmp8_ = self->priv->sample_button;
	_tmp9_ = g_strdup_printf (ngettext ("%i Language Sample Available ", "%i Language Samples Available", (gulong) langs), (gint) langs);
	_tmp10_ = _tmp9_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp8_, _tmp10_);
	_g_free0 (_tmp10_);
	return;
}

static gdouble
font_manager_google_fonts_preview_page_get_next_line_size (FontManagerGoogleFontsPreviewPage* self,
                                                           gdouble current)
{
	gdouble _tmp0_;
	gdouble next = 0.0;
	gdouble _tmp1_;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_waterfall_size_ratio;
	if (_tmp0_ <= 1.0) {
		result = current + 1.0;
		return result;
	}
	_tmp1_ = self->priv->_waterfall_size_ratio;
	next = current * _tmp1_;
	_tmp3_ = self->priv->_waterfall_size_ratio;
	if (_tmp3_ > 1.1) {
		_tmp2_ = floor (next);
	} else {
		_tmp2_ = ceil (next);
	}
	result = _tmp2_;
	return result;
}

static gchar*
font_manager_google_fonts_preview_page_get_current_header (FontManagerGoogleFontsPreviewPage* self)
{
	FontManagerGoogleFontsFont* _tmp0_;
	gchar* justify = NULL;
	gchar* _tmp1_;
	PangoDirection dir = 0;
	FontManagerPreviewEntry* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	FontManagerPreviewPageMode _tmp5_;
	const gchar* _tmp10_ = NULL;
	FontManagerPreviewColors* _tmp11_;
	GdkRGBA _tmp12_ = {0};
	GdkRGBA _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	FontManagerPreviewColors* _tmp16_;
	GdkRGBA _tmp17_ = {0};
	GdkRGBA _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gdouble _tmp22_;
	FontManagerGoogleFontsFont* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	FontManagerGoogleFontsFont* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	FontManagerGoogleFontsFont* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	FontManagerGoogleFontsFont* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->font;
	_vala_return_val_if_fail (_tmp0_ != NULL, "font != null", NULL);
	_tmp1_ = g_strdup ("justify");
	justify = _tmp1_;
	_tmp2_ = self->priv->entry;
	_tmp3_ = gtk_editable_get_text ((GtkEditable*) _tmp2_);
	_tmp4_ = _tmp3_;
	dir = pango_find_base_dir (_tmp4_, -1);
	_tmp5_ = self->priv->_preview_mode;
	if (_tmp5_ == FONT_MANAGER_PREVIEW_PAGE_MODE_PREVIEW) {
		GtkJustification _tmp6_;
		_tmp6_ = self->priv->_justification;
		switch (_tmp6_) {
			case GTK_JUSTIFY_LEFT:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("left");
				_g_free0 (justify);
				justify = _tmp7_;
				break;
			}
			case GTK_JUSTIFY_CENTER:
			{
				gchar* _tmp8_;
				_tmp8_ = g_strdup ("center");
				_g_free0 (justify);
				justify = _tmp8_;
				break;
			}
			case GTK_JUSTIFY_RIGHT:
			{
				gchar* _tmp9_;
				_tmp9_ = g_strdup ("right");
				_g_free0 (justify);
				justify = _tmp9_;
				break;
			}
			default:
			{
				break;
			}
		}
	}
	if (dir == PANGO_DIRECTION_RTL) {
		_tmp10_ = "rtl";
	} else {
		_tmp10_ = "ltr";
	}
	_tmp11_ = self->priv->preview_colors;
	font_manager_preview_colors_get_foreground_color (_tmp11_, &_tmp12_);
	_tmp13_ = _tmp12_;
	_tmp14_ = gdk_rgba_to_string (&_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = self->priv->preview_colors;
	font_manager_preview_colors_get_background_color (_tmp16_, &_tmp17_);
	_tmp18_ = _tmp17_;
	_tmp19_ = gdk_rgba_to_string (&_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = justify;
	_tmp22_ = self->priv->_preview_size;
	_tmp23_ = self->priv->font;
	_tmp24_ = font_manager_google_fonts_font_get_family (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = self->priv->font;
	_tmp27_ = font_manager_google_fonts_font_get_style (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = self->priv->font;
	_tmp30_ = font_manager_google_fonts_font_get_weight (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = self->priv->font;
	_tmp33_ = font_manager_google_fonts_font_to_font_face_rule (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = g_strdup_printf (HEADER, _tmp10_, _tmp15_, _tmp20_, _tmp21_, _tmp22_, _tmp25_, _tmp28_, _tmp31_, _tmp34_);
	_tmp36_ = _tmp35_;
	_g_free0 (_tmp34_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp15_);
	result = _tmp36_;
	_g_free0 (justify);
	return result;
}

static void
font_manager_google_fonts_preview_page_update_waterfall_body (FontManagerGoogleFontsPreviewPage* self)
{
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	{
		gdouble i = 0.0;
		gdouble _tmp1_;
		_tmp1_ = self->priv->_min_waterfall_size;
		i = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gdouble _tmp3_;
				gchar* pixels = NULL;
				gchar* _tmp4_;
				gboolean _tmp5_;
				GString* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				if (!_tmp2_) {
					i = font_manager_google_fonts_preview_page_get_next_line_size (self, i);
				}
				_tmp2_ = FALSE;
				_tmp3_ = self->priv->_max_waterfall_size;
				if (!(i <= _tmp3_)) {
					break;
				}
				_tmp4_ = g_strdup ("&nbsp;");
				pixels = _tmp4_;
				_tmp5_ = self->priv->_show_line_size;
				if (_tmp5_) {
					gchar* _tmp6_ = NULL;
					gchar* _tmp9_;
					if (i < ((gdouble) 10)) {
						gchar* _tmp7_;
						_tmp7_ = g_strdup_printf ("&nbsp;&nbsp;%.0lfpx&nbsp", i);
						_g_free0 (_tmp6_);
						_tmp6_ = _tmp7_;
					} else {
						gchar* _tmp8_;
						_tmp8_ = g_strdup_printf ("&nbsp;%.0lfpx&nbsp;", i);
						_g_free0 (_tmp6_);
						_tmp6_ = _tmp8_;
					}
					_tmp9_ = g_strdup (_tmp6_);
					_g_free0 (pixels);
					pixels = _tmp9_;
					_g_free0 (_tmp6_);
				}
				_tmp10_ = builder;
				_tmp11_ = pixels;
				_tmp12_ = font_manager_google_fonts_preview_page_get_preview_text (self);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_strdup_printf (WATERFALL_ROW, i, _tmp11_, i, _tmp13_);
				_tmp15_ = _tmp14_;
				g_string_append (_tmp10_, _tmp15_);
				_g_free0 (_tmp15_);
				_g_free0 (pixels);
			}
		}
	}
	_tmp16_ = builder;
	_tmp17_ = _tmp16_->str;
	_tmp18_ = g_strdup (_tmp17_);
	_g_free0 (self->priv->waterfall_body);
	self->priv->waterfall_body = _tmp18_;
	_g_string_free0 (builder);
	return;
}

static gchar*
font_manager_google_fonts_preview_page_generate_active_preview (FontManagerGoogleFontsPreviewPage* self)
{
	FontManagerGoogleFontsFont* _tmp0_;
	GString* builder = NULL;
	GString* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->font;
	_vala_return_val_if_fail (_tmp0_ != NULL, "font != null", NULL);
	_tmp1_ = g_string_new ("");
	builder = _tmp1_;
	_tmp2_ = font_manager_google_fonts_preview_page_get_current_header (self);
	_tmp3_ = _tmp2_;
	g_string_append (builder, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = font_manager_google_fonts_preview_page_get_active_preview_text (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf (ACTIVE_PREVIEW, _tmp5_);
	_tmp7_ = _tmp6_;
	g_string_append (builder, _tmp7_);
	_g_free0 (_tmp7_);
	g_string_append (builder, FOOTER);
	_tmp8_ = builder->str;
	_tmp9_ = g_strdup (_tmp8_);
	result = _tmp9_;
	_g_string_free0 (builder);
	return result;
}

static gchar*
font_manager_google_fonts_preview_page_generate_waterfall (FontManagerGoogleFontsPreviewPage* self)
{
	FontManagerGoogleFontsFont* _tmp0_;
	GString* builder = NULL;
	GString* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->font;
	_vala_return_val_if_fail (_tmp0_ != NULL, "font != null", NULL);
	_tmp1_ = g_string_new ("");
	builder = _tmp1_;
	_tmp2_ = font_manager_google_fonts_preview_page_get_current_header (self);
	_tmp3_ = _tmp2_;
	g_string_append (builder, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->waterfall_body;
	g_string_append (builder, _tmp4_);
	g_string_append (builder, FOOTER);
	_tmp5_ = builder->str;
	_tmp6_ = g_strdup (_tmp5_);
	result = _tmp6_;
	_g_string_free0 (builder);
	return result;
}

static gchar*
font_manager_google_fonts_preview_page_generate_lorem_ipsum (FontManagerGoogleFontsPreviewPage* self)
{
	FontManagerGoogleFontsFont* _tmp0_;
	GString* builder = NULL;
	GString* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* pref_loc = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->font;
	_vala_return_val_if_fail (_tmp0_ != NULL, "font != null", NULL);
	_tmp1_ = g_string_new ("");
	builder = _tmp1_;
	_tmp2_ = font_manager_google_fonts_preview_page_get_current_header (self);
	_tmp3_ = _tmp2_;
	g_string_append (builder, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = setlocale (LC_ALL, "");
	_tmp5_ = g_strdup (_tmp4_);
	pref_loc = _tmp5_;
	setlocale (LC_ALL, "C");
	_tmp6_ = g_strdup_printf (BODY_TEXT, FONT_MANAGER_LOREM_IPSUM);
	_tmp7_ = _tmp6_;
	g_string_append (builder, _tmp7_);
	_g_free0 (_tmp7_);
	setlocale (LC_ALL, pref_loc);
	g_string_append (builder, FOOTER);
	_tmp8_ = builder->str;
	_tmp9_ = g_strdup (_tmp8_);
	result = _tmp9_;
	_g_free0 (pref_loc);
	_g_string_free0 (builder);
	return result;
}

static void
font_manager_google_fonts_preview_page_on_show_context_menu (FontManagerGoogleFontsPreviewPage* self,
                                                             gint n_press,
                                                             gdouble x,
                                                             gdouble y)
{
	gboolean _tmp0_ = FALSE;
	FontManagerWaterfallSettings* _tmp1_;
	FontManagerWaterfallSettings* _tmp3_;
	GtkPopoverMenu* _tmp4_;
	GtkPopoverMenu* _tmp5_;
	GtkWidget* _tmp6_;
	FontManagerWaterfallSettings* _tmp10_;
	GtkPopoverMenu* _tmp11_;
	GtkPopoverMenu* _tmp12_;
	WebKitWebView* _tmp13_;
	FontManagerWaterfallSettings* _tmp14_;
	GtkPopoverMenu* _tmp15_;
	GtkPopoverMenu* _tmp16_;
	GdkRectangle _tmp17_;
	FontManagerWaterfallSettings* _tmp18_;
	GtkPopoverMenu* _tmp19_;
	GtkPopoverMenu* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_waterfall_settings;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		FontManagerPreviewPageMode _tmp2_;
		_tmp2_ = self->priv->_preview_mode;
		_tmp0_ = _tmp2_ != FONT_MANAGER_PREVIEW_PAGE_MODE_WATERFALL;
	}
	if (_tmp0_) {
		return;
	}
	self->priv->clicked_area.x = (gint) x;
	self->priv->clicked_area.y = (gint) y;
	self->priv->clicked_area.width = 2;
	self->priv->clicked_area.height = 2;
	_tmp3_ = self->priv->_waterfall_settings;
	_tmp4_ = font_manager_waterfall_settings_get_context_menu (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_widget_get_parent ((GtkWidget*) _tmp5_);
	if (_tmp6_ != NULL) {
		FontManagerWaterfallSettings* _tmp7_;
		GtkPopoverMenu* _tmp8_;
		GtkPopoverMenu* _tmp9_;
		_tmp7_ = self->priv->_waterfall_settings;
		_tmp8_ = font_manager_waterfall_settings_get_context_menu (_tmp7_);
		_tmp9_ = _tmp8_;
		gtk_widget_unparent ((GtkWidget*) _tmp9_);
	}
	_tmp10_ = self->priv->_waterfall_settings;
	_tmp11_ = font_manager_waterfall_settings_get_context_menu (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->webview;
	gtk_widget_set_parent ((GtkWidget*) _tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = self->priv->_waterfall_settings;
	_tmp15_ = font_manager_waterfall_settings_get_context_menu (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = self->priv->clicked_area;
	gtk_popover_set_pointing_to ((GtkPopover*) _tmp16_, &_tmp17_);
	_tmp18_ = self->priv->_waterfall_settings;
	_tmp19_ = font_manager_waterfall_settings_get_context_menu (_tmp18_);
	_tmp20_ = _tmp19_;
	gtk_popover_popup ((GtkPopover*) _tmp20_);
	return;
}

gint
font_manager_google_fonts_preview_page_get_predefined_size (FontManagerGoogleFontsPreviewPage* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_predefined_size;
	return result;
}

void
font_manager_google_fonts_preview_page_set_predefined_size (FontManagerGoogleFontsPreviewPage* self,
                                                            gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_preview_page_get_predefined_size (self);
	if (old_value != value) {
		self->priv->_predefined_size = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_preview_page_properties[FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_PREDEFINED_SIZE_PROPERTY]);
	}
}

gboolean
font_manager_google_fonts_preview_page_get_show_line_size (FontManagerGoogleFontsPreviewPage* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_line_size;
	return result;
}

void
font_manager_google_fonts_preview_page_set_show_line_size (FontManagerGoogleFontsPreviewPage* self,
                                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_preview_page_get_show_line_size (self);
	if (old_value != value) {
		self->priv->_show_line_size = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_preview_page_properties[FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_SHOW_LINE_SIZE_PROPERTY]);
	}
}

gdouble
font_manager_google_fonts_preview_page_get_preview_size (FontManagerGoogleFontsPreviewPage* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_preview_size;
	return result;
}

void
font_manager_google_fonts_preview_page_set_preview_size (FontManagerGoogleFontsPreviewPage* self,
                                                         gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_preview_page_get_preview_size (self);
	if (old_value != value) {
		self->priv->_preview_size = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_preview_page_properties[FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_PREVIEW_SIZE_PROPERTY]);
	}
}

gdouble
font_manager_google_fonts_preview_page_get_min_waterfall_size (FontManagerGoogleFontsPreviewPage* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_min_waterfall_size;
	return result;
}

void
font_manager_google_fonts_preview_page_set_min_waterfall_size (FontManagerGoogleFontsPreviewPage* self,
                                                               gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_preview_page_get_min_waterfall_size (self);
	if (old_value != value) {
		self->priv->_min_waterfall_size = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_preview_page_properties[FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_MIN_WATERFALL_SIZE_PROPERTY]);
	}
}

gdouble
font_manager_google_fonts_preview_page_get_max_waterfall_size (FontManagerGoogleFontsPreviewPage* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_max_waterfall_size;
	return result;
}

void
font_manager_google_fonts_preview_page_set_max_waterfall_size (FontManagerGoogleFontsPreviewPage* self,
                                                               gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_preview_page_get_max_waterfall_size (self);
	if (old_value != value) {
		self->priv->_max_waterfall_size = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_preview_page_properties[FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_MAX_WATERFALL_SIZE_PROPERTY]);
	}
}

gdouble
font_manager_google_fonts_preview_page_get_waterfall_size_ratio (FontManagerGoogleFontsPreviewPage* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_waterfall_size_ratio;
	return result;
}

void
font_manager_google_fonts_preview_page_set_waterfall_size_ratio (FontManagerGoogleFontsPreviewPage* self,
                                                                 gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_preview_page_get_waterfall_size_ratio (self);
	if (old_value != value) {
		self->priv->_waterfall_size_ratio = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_preview_page_properties[FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_WATERFALL_SIZE_RATIO_PROPERTY]);
	}
}

GObject*
font_manager_google_fonts_preview_page_get_selected_item (FontManagerGoogleFontsPreviewPage* self)
{
	GObject* result;
	GObject* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selected_item;
	result = _tmp0_;
	return result;
}

void
font_manager_google_fonts_preview_page_set_selected_item (FontManagerGoogleFontsPreviewPage* self,
                                                          GObject* value)
{
	GObject* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_preview_page_get_selected_item (self);
	if (old_value != value) {
		GObject* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_selected_item);
		self->priv->_selected_item = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_preview_page_properties[FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_SELECTED_ITEM_PROPERTY]);
	}
}

GtkJustification
font_manager_google_fonts_preview_page_get_justification (FontManagerGoogleFontsPreviewPage* self)
{
	GtkJustification result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_justification;
	return result;
}

void
font_manager_google_fonts_preview_page_set_justification (FontManagerGoogleFontsPreviewPage* self,
                                                          GtkJustification value)
{
	GtkJustification old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_preview_page_get_justification (self);
	if (old_value != value) {
		self->priv->_justification = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_preview_page_properties[FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_JUSTIFICATION_PROPERTY]);
	}
}

FontManagerPreviewPageMode
font_manager_google_fonts_preview_page_get_preview_mode (FontManagerGoogleFontsPreviewPage* self)
{
	FontManagerPreviewPageMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_preview_mode;
	return result;
}

void
font_manager_google_fonts_preview_page_set_preview_mode (FontManagerGoogleFontsPreviewPage* self,
                                                         FontManagerPreviewPageMode value)
{
	FontManagerPreviewPageMode old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_preview_page_get_preview_mode (self);
	if (old_value != value) {
		self->priv->_preview_mode = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_preview_page_properties[FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_PREVIEW_MODE_PROPERTY]);
	}
}

FontManagerWaterfallSettings*
font_manager_google_fonts_preview_page_get_waterfall_settings (FontManagerGoogleFontsPreviewPage* self)
{
	FontManagerWaterfallSettings* result;
	FontManagerWaterfallSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_waterfall_settings;
	result = _tmp0_;
	return result;
}

void
font_manager_google_fonts_preview_page_set_waterfall_settings (FontManagerGoogleFontsPreviewPage* self,
                                                               FontManagerWaterfallSettings* value)
{
	FontManagerWaterfallSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_preview_page_get_waterfall_settings (self);
	if (old_value != value) {
		FontManagerWaterfallSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_waterfall_settings);
		self->priv->_waterfall_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_preview_page_properties[FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_WATERFALL_SETTINGS_PROPERTY]);
	}
}

const gchar*
font_manager_google_fonts_preview_page_get_preview_text (FontManagerGoogleFontsPreviewPage* self)
{
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_preview_text;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_preview_text;
		_tmp0_ = _tmp2_;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->default_pangram;
		_tmp0_ = _tmp3_;
	}
	result = _tmp0_;
	return result;
}

void
font_manager_google_fonts_preview_page_set_preview_text (FontManagerGoogleFontsPreviewPage* self,
                                                         const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_preview_text);
	self->priv->_preview_text = _tmp0_;
	g_object_notify ((GObject*) self, "preview-text");
	g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_preview_page_properties[FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_PREVIEW_TEXT_PROPERTY]);
}

const gchar*
font_manager_google_fonts_preview_page_get_active_preview_text (FontManagerGoogleFontsPreviewPage* self)
{
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_active_preview_text;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_active_preview_text;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = DEFAULT_ACTIVE_TEXT;
	}
	result = _tmp0_;
	return result;
}

void
font_manager_google_fonts_preview_page_set_active_preview_text (FontManagerGoogleFontsPreviewPage* self,
                                                                const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_active_preview_text);
	self->priv->_active_preview_text = _tmp0_;
	g_object_notify ((GObject*) self, "active-preview-text");
	g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_preview_page_properties[FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_ACTIVE_PREVIEW_TEXT_PROPERTY]);
}

static void
font_manager_google_fonts_preview_page_class_init (FontManagerGoogleFontsPreviewPageClass * klass,
                                                   gpointer klass_data)
{
	font_manager_google_fonts_preview_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerGoogleFontsPreviewPage_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_google_fonts_preview_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_google_fonts_preview_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_google_fonts_preview_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_PREDEFINED_SIZE_PROPERTY, font_manager_google_fonts_preview_page_properties[FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_PREDEFINED_SIZE_PROPERTY] = g_param_spec_int ("predefined-size", "predefined-size", "predefined-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_SHOW_LINE_SIZE_PROPERTY, font_manager_google_fonts_preview_page_properties[FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_SHOW_LINE_SIZE_PROPERTY] = g_param_spec_boolean ("show-line-size", "show-line-size", "show-line-size", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_PREVIEW_SIZE_PROPERTY, font_manager_google_fonts_preview_page_properties[FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_PREVIEW_SIZE_PROPERTY] = g_param_spec_double ("preview-size", "preview-size", "preview-size", -G_MAXDOUBLE, G_MAXDOUBLE, 12.5, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_MIN_WATERFALL_SIZE_PROPERTY, font_manager_google_fonts_preview_page_properties[FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_MIN_WATERFALL_SIZE_PROPERTY] = g_param_spec_double ("min-waterfall-size", "min-waterfall-size", "min-waterfall-size", -G_MAXDOUBLE, G_MAXDOUBLE, FONT_MANAGER_MIN_FONT_SIZE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_MAX_WATERFALL_SIZE_PROPERTY, font_manager_google_fonts_preview_page_properties[FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_MAX_WATERFALL_SIZE_PROPERTY] = g_param_spec_double ("max-waterfall-size", "max-waterfall-size", "max-waterfall-size", -G_MAXDOUBLE, G_MAXDOUBLE, FONT_MANAGER_MAX_FONT_SIZE * 2, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_WATERFALL_SIZE_RATIO_PROPERTY, font_manager_google_fonts_preview_page_properties[FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_WATERFALL_SIZE_RATIO_PROPERTY] = g_param_spec_double ("waterfall-size-ratio", "waterfall-size-ratio", "waterfall-size-ratio", -G_MAXDOUBLE, G_MAXDOUBLE, 1.1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_SELECTED_ITEM_PROPERTY, font_manager_google_fonts_preview_page_properties[FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_SELECTED_ITEM_PROPERTY] = g_param_spec_object ("selected-item", "selected-item", "selected-item", G_TYPE_OBJECT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_JUSTIFICATION_PROPERTY, font_manager_google_fonts_preview_page_properties[FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_JUSTIFICATION_PROPERTY] = g_param_spec_enum ("justification", "justification", "justification", gtk_justification_get_type (), GTK_JUSTIFY_CENTER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_PREVIEW_MODE_PROPERTY, font_manager_google_fonts_preview_page_properties[FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_PREVIEW_MODE_PROPERTY] = g_param_spec_enum ("preview-mode", "preview-mode", "preview-mode", font_manager_preview_page_mode_get_type (), FONT_MANAGER_PREVIEW_PAGE_MODE_WATERFALL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_WATERFALL_SETTINGS_PROPERTY, font_manager_google_fonts_preview_page_properties[FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_WATERFALL_SETTINGS_PROPERTY] = g_param_spec_object ("waterfall-settings", "waterfall-settings", "waterfall-settings", FONT_MANAGER_TYPE_WATERFALL_SETTINGS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_PREVIEW_TEXT_PROPERTY, font_manager_google_fonts_preview_page_properties[FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_PREVIEW_TEXT_PROPERTY] = g_param_spec_string ("preview-text", "preview-text", "preview-text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_ACTIVE_PREVIEW_TEXT_PROPERTY, font_manager_google_fonts_preview_page_properties[FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_ACTIVE_PREVIEW_TEXT_PROPERTY] = g_param_spec_string ("active-preview-text", "active-preview-text", "active-preview-text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/github/FontManager/FontManager/web/google/ui/google-fonts-preview-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "controls", FALSE, FontManagerGoogleFontsPreviewPage_private_offset + G_STRUCT_OFFSET (FontManagerGoogleFontsPreviewPagePrivate, controls));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "menu_button", FALSE, FontManagerGoogleFontsPreviewPage_private_offset + G_STRUCT_OFFSET (FontManagerGoogleFontsPreviewPagePrivate, menu_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "sample_button", FALSE, FontManagerGoogleFontsPreviewPage_private_offset + G_STRUCT_OFFSET (FontManagerGoogleFontsPreviewPagePrivate, sample_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "preview_colors", FALSE, FontManagerGoogleFontsPreviewPage_private_offset + G_STRUCT_OFFSET (FontManagerGoogleFontsPreviewPagePrivate, preview_colors));
	gtk_widget_class_install_property_action (GTK_WIDGET_CLASS (klass), "predefined-size", "predefined-size");
	gtk_widget_class_install_property_action (GTK_WIDGET_CLASS (klass), "show-line-size", "show-line-size");
}

static void
font_manager_google_fonts_preview_page_instance_init (FontManagerGoogleFontsPreviewPage * self,
                                                      gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	self->priv = font_manager_google_fonts_preview_page_get_instance_private (self);
	self->priv->_show_line_size = TRUE;
	self->priv->_preview_size = 12.5;
	self->priv->_min_waterfall_size = FONT_MANAGER_MIN_FONT_SIZE;
	self->priv->_max_waterfall_size = FONT_MANAGER_MAX_FONT_SIZE * 2;
	self->priv->_waterfall_size_ratio = 1.1;
	self->priv->_selected_item = NULL;
	self->priv->_justification = GTK_JUSTIFY_CENTER;
	self->priv->_preview_mode = FONT_MANAGER_PREVIEW_PAGE_MODE_WATERFALL;
	self->priv->_preview_text = NULL;
	self->priv->waterfall_body = NULL;
	self->priv->_active_preview_text = NULL;
	_tmp0_ = g_strdup ("The quick brown fox jumps over the lazy dog.");
	self->priv->default_pangram = _tmp0_;
	_tmp1_ = g_strdup ("preview-text");
	_tmp2_ = g_strdup ("preview-size");
	_tmp3_ = g_strdup ("preview-mode");
	_tmp4_ = g_strdup ("justification");
	_tmp5_ = g_new0 (gchar*, 4 + 1);
	_tmp5_[0] = _tmp1_;
	_tmp5_[1] = _tmp2_;
	_tmp5_[2] = _tmp3_;
	_tmp5_[3] = _tmp4_;
	self->priv->requires_reload = _tmp5_;
	self->priv->requires_reload_length1 = 4;
	self->priv->_requires_reload_size_ = self->priv->requires_reload_length1;
	_tmp6_ = g_strdup ("min-waterfall-size");
	_tmp7_ = g_strdup ("max-waterfall-size");
	_tmp8_ = g_strdup ("waterfall-size-ratio");
	_tmp9_ = g_strdup ("preview-text");
	_tmp10_ = g_strdup ("show-line-size");
	_tmp11_ = g_new0 (gchar*, 5 + 1);
	_tmp11_[0] = _tmp6_;
	_tmp11_[1] = _tmp7_;
	_tmp11_[2] = _tmp8_;
	_tmp11_[3] = _tmp9_;
	_tmp11_[4] = _tmp10_;
	self->priv->affects_waterfall = _tmp11_;
	self->priv->affects_waterfall_length1 = 5;
	self->priv->_affects_waterfall_size_ = self->priv->affects_waterfall_length1;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
font_manager_google_fonts_preview_page_finalize (GObject * obj)
{
	FontManagerGoogleFontsPreviewPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_GOOGLE_FONTS_TYPE_PREVIEW_PAGE, FontManagerGoogleFontsPreviewPage);
	_g_object_unref0 (self->priv->_selected_item);
	_g_object_unref0 (self->priv->_waterfall_settings);
	_g_free0 (self->priv->_preview_text);
	_g_free0 (self->priv->waterfall_body);
	_g_free0 (self->priv->_active_preview_text);
	_g_free0 (self->priv->default_pangram);
	_g_object_unref0 (self->priv->font);
	_g_object_unref0 (self->priv->fontscale);
	_g_object_unref0 (self->priv->entry);
	_g_object_unref0 (self->priv->preview_controls);
	_g_object_unref0 (self->priv->samples);
	_g_object_unref0 (self->priv->webview);
	_g_object_unref0 (self->priv->controls_revealer);
	_g_object_unref0 (self->priv->fontscale_revealer);
	_g_object_unref0 (self->priv->preview_stack);
	_g_object_unref0 (self->priv->textview);
	self->priv->requires_reload = (_vala_array_free (self->priv->requires_reload, self->priv->requires_reload_length1, (GDestroyNotify) g_free), NULL);
	self->priv->affects_waterfall = (_vala_array_free (self->priv->affects_waterfall, self->priv->affects_waterfall_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (font_manager_google_fonts_preview_page_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_google_fonts_preview_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerGoogleFontsPreviewPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_google_fonts_preview_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerGoogleFontsPreviewPage), 0, (GInstanceInitFunc) font_manager_google_fonts_preview_page_instance_init, NULL };
	GType font_manager_google_fonts_preview_page_type_id;
	font_manager_google_fonts_preview_page_type_id = g_type_register_static (gtk_box_get_type (), "FontManagerGoogleFontsPreviewPage", &g_define_type_info, 0);
	FontManagerGoogleFontsPreviewPage_private_offset = g_type_add_instance_private (font_manager_google_fonts_preview_page_type_id, sizeof (FontManagerGoogleFontsPreviewPagePrivate));
	return font_manager_google_fonts_preview_page_type_id;
}

GType
font_manager_google_fonts_preview_page_get_type (void)
{
	static volatile gsize font_manager_google_fonts_preview_page_type_id__once = 0;
	if (g_once_init_enter (&font_manager_google_fonts_preview_page_type_id__once)) {
		GType font_manager_google_fonts_preview_page_type_id;
		font_manager_google_fonts_preview_page_type_id = font_manager_google_fonts_preview_page_get_type_once ();
		g_once_init_leave (&font_manager_google_fonts_preview_page_type_id__once, font_manager_google_fonts_preview_page_type_id);
	}
	return font_manager_google_fonts_preview_page_type_id__once;
}

static void
_vala_font_manager_google_fonts_preview_page_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec)
{
	FontManagerGoogleFontsPreviewPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_GOOGLE_FONTS_TYPE_PREVIEW_PAGE, FontManagerGoogleFontsPreviewPage);
	switch (property_id) {
		case FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_PREDEFINED_SIZE_PROPERTY:
		g_value_set_int (value, font_manager_google_fonts_preview_page_get_predefined_size (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_SHOW_LINE_SIZE_PROPERTY:
		g_value_set_boolean (value, font_manager_google_fonts_preview_page_get_show_line_size (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_PREVIEW_SIZE_PROPERTY:
		g_value_set_double (value, font_manager_google_fonts_preview_page_get_preview_size (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_MIN_WATERFALL_SIZE_PROPERTY:
		g_value_set_double (value, font_manager_google_fonts_preview_page_get_min_waterfall_size (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_MAX_WATERFALL_SIZE_PROPERTY:
		g_value_set_double (value, font_manager_google_fonts_preview_page_get_max_waterfall_size (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_WATERFALL_SIZE_RATIO_PROPERTY:
		g_value_set_double (value, font_manager_google_fonts_preview_page_get_waterfall_size_ratio (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_SELECTED_ITEM_PROPERTY:
		g_value_set_object (value, font_manager_google_fonts_preview_page_get_selected_item (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_JUSTIFICATION_PROPERTY:
		g_value_set_enum (value, font_manager_google_fonts_preview_page_get_justification (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_PREVIEW_MODE_PROPERTY:
		g_value_set_enum (value, font_manager_google_fonts_preview_page_get_preview_mode (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_WATERFALL_SETTINGS_PROPERTY:
		g_value_set_object (value, font_manager_google_fonts_preview_page_get_waterfall_settings (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_PREVIEW_TEXT_PROPERTY:
		g_value_set_string (value, font_manager_google_fonts_preview_page_get_preview_text (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_ACTIVE_PREVIEW_TEXT_PROPERTY:
		g_value_set_string (value, font_manager_google_fonts_preview_page_get_active_preview_text (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_google_fonts_preview_page_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec)
{
	FontManagerGoogleFontsPreviewPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_GOOGLE_FONTS_TYPE_PREVIEW_PAGE, FontManagerGoogleFontsPreviewPage);
	switch (property_id) {
		case FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_PREDEFINED_SIZE_PROPERTY:
		font_manager_google_fonts_preview_page_set_predefined_size (self, g_value_get_int (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_SHOW_LINE_SIZE_PROPERTY:
		font_manager_google_fonts_preview_page_set_show_line_size (self, g_value_get_boolean (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_PREVIEW_SIZE_PROPERTY:
		font_manager_google_fonts_preview_page_set_preview_size (self, g_value_get_double (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_MIN_WATERFALL_SIZE_PROPERTY:
		font_manager_google_fonts_preview_page_set_min_waterfall_size (self, g_value_get_double (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_MAX_WATERFALL_SIZE_PROPERTY:
		font_manager_google_fonts_preview_page_set_max_waterfall_size (self, g_value_get_double (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_WATERFALL_SIZE_RATIO_PROPERTY:
		font_manager_google_fonts_preview_page_set_waterfall_size_ratio (self, g_value_get_double (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_SELECTED_ITEM_PROPERTY:
		font_manager_google_fonts_preview_page_set_selected_item (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_JUSTIFICATION_PROPERTY:
		font_manager_google_fonts_preview_page_set_justification (self, g_value_get_enum (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_PREVIEW_MODE_PROPERTY:
		font_manager_google_fonts_preview_page_set_preview_mode (self, g_value_get_enum (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_WATERFALL_SETTINGS_PROPERTY:
		font_manager_google_fonts_preview_page_set_waterfall_settings (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_PREVIEW_TEXT_PROPERTY:
		font_manager_google_fonts_preview_page_set_preview_text (self, g_value_get_string (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_ACTIVE_PREVIEW_TEXT_PROPERTY:
		font_manager_google_fonts_preview_page_set_active_preview_text (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

