/* Browse.c generated by valac 0.56.18, the Vala compiler
 * generated from Browse.vala, do not modify */

/* Browse.vala
 *
 * Copyright (C) 2020-2025 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <gtk/gtk.h>
#include "font-manager.h"
#include <gio/gio.h>
#include "vala-common.h"
#include <glib/gi18n-lib.h>
#include <sqlite3.h>
#include <json-glib/json-glib.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	FONT_MANAGER_BROWSE_MODE_GRID,
	FONT_MANAGER_BROWSE_MODE_LIST,
	FONT_MANAGER_BROWSE_MODE_N_MODES
} FontManagerBrowseMode;

#define FONT_MANAGER_TYPE_BROWSE_MODE (font_manager_browse_mode_get_type ())
typedef enum  {
	FONT_MANAGER_PREVIEW_TILE_SIZE_SMALL = 96,
	FONT_MANAGER_PREVIEW_TILE_SIZE_MEDIUM = 128,
	FONT_MANAGER_PREVIEW_TILE_SIZE_LARGE = 144,
	FONT_MANAGER_PREVIEW_TILE_SIZE_XLARGE = 192,
	FONT_MANAGER_PREVIEW_TILE_SIZE_XXLARGE = 256
} FontManagerPreviewTileSize;

#define FONT_MANAGER_TYPE_PREVIEW_TILE_SIZE (font_manager_preview_tile_size_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_PangoLanguage_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoLanguage_free (var), NULL)))

#define FONT_MANAGER_TYPE_FONT_PREVIEW_TILE (font_manager_font_preview_tile_get_type ())
#define FONT_MANAGER_FONT_PREVIEW_TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_FONT_PREVIEW_TILE, FontManagerFontPreviewTile))
#define FONT_MANAGER_FONT_PREVIEW_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_FONT_PREVIEW_TILE, FontManagerFontPreviewTileClass))
#define FONT_MANAGER_IS_FONT_PREVIEW_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_FONT_PREVIEW_TILE))
#define FONT_MANAGER_IS_FONT_PREVIEW_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_FONT_PREVIEW_TILE))
#define FONT_MANAGER_FONT_PREVIEW_TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_FONT_PREVIEW_TILE, FontManagerFontPreviewTileClass))

typedef struct _FontManagerFontPreviewTile FontManagerFontPreviewTile;
typedef struct _FontManagerFontPreviewTileClass FontManagerFontPreviewTileClass;
typedef struct _FontManagerFontPreviewTilePrivate FontManagerFontPreviewTilePrivate;
enum  {
	FONT_MANAGER_FONT_PREVIEW_TILE_0_PROPERTY,
	FONT_MANAGER_FONT_PREVIEW_TILE_ITEM_PROPERTY,
	FONT_MANAGER_FONT_PREVIEW_TILE_SIZE_PROPERTY,
	FONT_MANAGER_FONT_PREVIEW_TILE_ATTRS_PROPERTY,
	FONT_MANAGER_FONT_PREVIEW_TILE_PREVIEW_PROPERTY,
	FONT_MANAGER_FONT_PREVIEW_TILE_PREVIEW_TEXT_PROPERTY,
	FONT_MANAGER_FONT_PREVIEW_TILE_NUM_PROPERTIES
};
static GParamSpec* font_manager_font_preview_tile_properties[FONT_MANAGER_FONT_PREVIEW_TILE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))

#define FONT_MANAGER_TYPE_FONT_LIST_BASE (font_manager_font_list_base_get_type ())
#define FONT_MANAGER_FONT_LIST_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_FONT_LIST_BASE, FontManagerFontListBase))
#define FONT_MANAGER_FONT_LIST_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_FONT_LIST_BASE, FontManagerFontListBaseClass))
#define FONT_MANAGER_IS_FONT_LIST_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_FONT_LIST_BASE))
#define FONT_MANAGER_IS_FONT_LIST_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_FONT_LIST_BASE))
#define FONT_MANAGER_FONT_LIST_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_FONT_LIST_BASE, FontManagerFontListBaseClass))

typedef struct _FontManagerFontListBase FontManagerFontListBase;
typedef struct _FontManagerFontListBaseClass FontManagerFontListBaseClass;
typedef struct _FontManagerFontListBasePrivate FontManagerFontListBasePrivate;

#define FONT_MANAGER_TYPE_FONT_GRID_VIEW (font_manager_font_grid_view_get_type ())
#define FONT_MANAGER_FONT_GRID_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_FONT_GRID_VIEW, FontManagerFontGridView))
#define FONT_MANAGER_FONT_GRID_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_FONT_GRID_VIEW, FontManagerFontGridViewClass))
#define FONT_MANAGER_IS_FONT_GRID_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_FONT_GRID_VIEW))
#define FONT_MANAGER_IS_FONT_GRID_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_FONT_GRID_VIEW))
#define FONT_MANAGER_FONT_GRID_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_FONT_GRID_VIEW, FontManagerFontGridViewClass))

typedef struct _FontManagerFontGridView FontManagerFontGridView;
typedef struct _FontManagerFontGridViewClass FontManagerFontGridViewClass;
typedef struct _FontManagerFontGridViewPrivate FontManagerFontGridViewPrivate;
enum  {
	FONT_MANAGER_FONT_GRID_VIEW_0_PROPERTY,
	FONT_MANAGER_FONT_GRID_VIEW_SIZE_PROPERTY,
	FONT_MANAGER_FONT_GRID_VIEW_PREVIEW_TEXT_PROPERTY,
	FONT_MANAGER_FONT_GRID_VIEW_NUM_PROPERTIES
};
static GParamSpec* font_manager_font_grid_view_properties[FONT_MANAGER_FONT_GRID_VIEW_NUM_PROPERTIES];

#define FONT_MANAGER_TYPE_BASE_FONT_MODEL (font_manager_base_font_model_get_type ())
#define FONT_MANAGER_BASE_FONT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_BASE_FONT_MODEL, FontManagerBaseFontModel))
#define FONT_MANAGER_BASE_FONT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_BASE_FONT_MODEL, FontManagerBaseFontModelClass))
#define FONT_MANAGER_IS_BASE_FONT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_BASE_FONT_MODEL))
#define FONT_MANAGER_IS_BASE_FONT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_BASE_FONT_MODEL))
#define FONT_MANAGER_BASE_FONT_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_BASE_FONT_MODEL, FontManagerBaseFontModelClass))

typedef struct _FontManagerBaseFontModel FontManagerBaseFontModel;
typedef struct _FontManagerBaseFontModelClass FontManagerBaseFontModelClass;

#define FONT_MANAGER_TYPE_FONT_MODEL (font_manager_font_model_get_type ())
#define FONT_MANAGER_FONT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_FONT_MODEL, FontManagerFontModel))
#define FONT_MANAGER_FONT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_FONT_MODEL, FontManagerFontModelClass))
#define FONT_MANAGER_IS_FONT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_FONT_MODEL))
#define FONT_MANAGER_IS_FONT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_FONT_MODEL))
#define FONT_MANAGER_FONT_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_FONT_MODEL, FontManagerFontModelClass))

typedef struct _FontManagerFontModel FontManagerFontModel;
typedef struct _FontManagerFontModelClass FontManagerFontModelClass;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef enum  {
	FONT_MANAGER_BROWSE_PREVIEW_MODE_WATERFALL,
	FONT_MANAGER_BROWSE_PREVIEW_MODE_LOREM_IPSUM,
	FONT_MANAGER_BROWSE_PREVIEW_MODE_CHARACTER_MAP
} FontManagerBrowsePreviewMode;

#define FONT_MANAGER_TYPE_BROWSE_PREVIEW_MODE (font_manager_browse_preview_mode_get_type ())

#define FONT_MANAGER_TYPE_BROWSE_PREVIEW (font_manager_browse_preview_get_type ())
#define FONT_MANAGER_BROWSE_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_BROWSE_PREVIEW, FontManagerBrowsePreview))
#define FONT_MANAGER_BROWSE_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_BROWSE_PREVIEW, FontManagerBrowsePreviewClass))
#define FONT_MANAGER_IS_BROWSE_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_BROWSE_PREVIEW))
#define FONT_MANAGER_IS_BROWSE_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_BROWSE_PREVIEW))
#define FONT_MANAGER_BROWSE_PREVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_BROWSE_PREVIEW, FontManagerBrowsePreviewClass))

typedef struct _FontManagerBrowsePreview FontManagerBrowsePreview;
typedef struct _FontManagerBrowsePreviewClass FontManagerBrowsePreviewClass;
typedef struct _FontManagerBrowsePreviewPrivate FontManagerBrowsePreviewPrivate;
enum  {
	FONT_MANAGER_BROWSE_PREVIEW_0_PROPERTY,
	FONT_MANAGER_BROWSE_PREVIEW_DISABLED_FAMILIES_PROPERTY,
	FONT_MANAGER_BROWSE_PREVIEW_SELECTED_ITEM_PROPERTY,
	FONT_MANAGER_BROWSE_PREVIEW_MODEL_PROPERTY,
	FONT_MANAGER_BROWSE_PREVIEW_PREVIEW_PAGE_PROPERTY,
	FONT_MANAGER_BROWSE_PREVIEW_CHARACTER_MAP_PROPERTY,
	FONT_MANAGER_BROWSE_PREVIEW_WATERFALL_SETTINGS_PROPERTY,
	FONT_MANAGER_BROWSE_PREVIEW_PREDEFINED_SIZE_PROPERTY,
	FONT_MANAGER_BROWSE_PREVIEW_MODE_PROPERTY,
	FONT_MANAGER_BROWSE_PREVIEW_NUM_PROPERTIES
};
static GParamSpec* font_manager_browse_preview_properties[FONT_MANAGER_BROWSE_PREVIEW_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define FONT_MANAGER_TYPE_BROWSE_PANE (font_manager_browse_pane_get_type ())
#define FONT_MANAGER_BROWSE_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_BROWSE_PANE, FontManagerBrowsePane))
#define FONT_MANAGER_BROWSE_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_BROWSE_PANE, FontManagerBrowsePaneClass))
#define FONT_MANAGER_IS_BROWSE_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_BROWSE_PANE))
#define FONT_MANAGER_IS_BROWSE_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_BROWSE_PANE))
#define FONT_MANAGER_BROWSE_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_BROWSE_PANE, FontManagerBrowsePaneClass))

typedef struct _FontManagerBrowsePane FontManagerBrowsePane;
typedef struct _FontManagerBrowsePaneClass FontManagerBrowsePaneClass;
typedef struct _FontManagerBrowsePanePrivate FontManagerBrowsePanePrivate;

#define FONT_MANAGER_TYPE_PANED (font_manager_paned_get_type ())
#define FONT_MANAGER_PANED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_PANED, FontManagerPaned))
#define FONT_MANAGER_PANED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_PANED, FontManagerPanedClass))
#define FONT_MANAGER_IS_PANED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_PANED))
#define FONT_MANAGER_IS_PANED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_PANED))
#define FONT_MANAGER_PANED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_PANED, FontManagerPanedClass))

typedef struct _FontManagerPaned FontManagerPaned;
typedef struct _FontManagerPanedClass FontManagerPanedClass;

#define FONT_MANAGER_TYPE_BROWSE_LIST_VIEW (font_manager_browse_list_view_get_type ())
#define FONT_MANAGER_BROWSE_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_BROWSE_LIST_VIEW, FontManagerBrowseListView))
#define FONT_MANAGER_BROWSE_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_BROWSE_LIST_VIEW, FontManagerBrowseListViewClass))
#define FONT_MANAGER_IS_BROWSE_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_BROWSE_LIST_VIEW))
#define FONT_MANAGER_IS_BROWSE_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_BROWSE_LIST_VIEW))
#define FONT_MANAGER_BROWSE_LIST_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_BROWSE_LIST_VIEW, FontManagerBrowseListViewClass))

typedef struct _FontManagerBrowseListView FontManagerBrowseListView;
typedef struct _FontManagerBrowseListViewClass FontManagerBrowseListViewClass;
enum  {
	FONT_MANAGER_BROWSE_PANE_0_PROPERTY,
	FONT_MANAGER_BROWSE_PANE_PANE_POSITION_PROPERTY,
	FONT_MANAGER_BROWSE_PANE_AVAILABLE_FONTS_PROPERTY,
	FONT_MANAGER_BROWSE_PANE_DISABLED_FAMILIES_PROPERTY,
	FONT_MANAGER_BROWSE_PANE_SIZE_PROPERTY,
	FONT_MANAGER_BROWSE_PANE_MODE_PROPERTY,
	FONT_MANAGER_BROWSE_PANE_WATERFALL_SETTINGS_PROPERTY,
	FONT_MANAGER_BROWSE_PANE_STACK_PROPERTY,
	FONT_MANAGER_BROWSE_PANE_NUM_PROPERTIES
};
static GParamSpec* font_manager_browse_pane_properties[FONT_MANAGER_BROWSE_PANE_NUM_PROPERTIES];
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FontManagerFontPreviewTile {
	GtkFrame parent_instance;
	FontManagerFontPreviewTilePrivate * priv;
};

struct _FontManagerFontPreviewTileClass {
	GtkFrameClass parent_class;
};

struct _FontManagerFontPreviewTilePrivate {
	GObject* _item;
	FontManagerPreviewTileSize _size;
	PangoAttrList* _attrs;
	GtkInscription* _preview;
	gchar* _preview_text;
	GtkLabel* item_count;
	GtkOverlay* overlay;
};

struct _FontManagerFontListBase {
	GtkBox parent_instance;
	FontManagerFontListBasePrivate * priv;
};

struct _FontManagerFontListBaseClass {
	GtkBoxClass parent_class;
	void (*update) (FontManagerFontListBase* self, guint position);
	void (*setup_list_row) (FontManagerFontListBase* self, GtkSignalListItemFactory* factory, GObject* item);
	void (*bind_list_row) (FontManagerFontListBase* self, GtkSignalListItemFactory* factory, GObject* item);
	void (*on_selection_changed) (FontManagerFontListBase* self, guint position, guint n_items);
};

struct _FontManagerFontGridView {
	FontManagerFontListBase parent_instance;
	FontManagerFontGridViewPrivate * priv;
};

struct _FontManagerFontGridViewClass {
	FontManagerFontListBaseClass parent_class;
};

struct _FontManagerFontGridViewPrivate {
	FontManagerPreviewTileSize _size;
	gchar* _preview_text;
	GtkScrolledWindow* container;
};

struct _FontManagerBrowsePreview {
	GtkBox parent_instance;
	FontManagerBrowsePreviewPrivate * priv;
};

struct _FontManagerBrowsePreviewClass {
	GtkBoxClass parent_class;
};

struct _FontManagerBrowsePreviewPrivate {
	FontManagerReject* _disabled_families;
	GObject* _selected_item;
	FontManagerBaseFontModel* _model;
	FontManagerPreviewPage* _preview_page;
	FontManagerUnicodeCharacterMap* _character_map;
	FontManagerWaterfallSettings* _waterfall_settings;
	gint _predefined_size;
	GtkLabel* family_label;
	GtkLabel* state_label;
	GtkLabel* designer_label;
	GtkLabel* n_glyphs;
	GtkDropDown* style_drop_down;
	GtkScrolledWindow* character_map_scroll;
	GtkScrolledWindow* preview_scroll;
	GtkStack* preview_stack;
	GtkMenuButton* preview_menu;
	GtkSwitch* font_state;
	gboolean ignore_activation;
};

struct _FontManagerBrowsePane {
	GtkBox parent_instance;
	FontManagerBrowsePanePrivate * priv;
};

struct _FontManagerBrowsePaneClass {
	GtkBoxClass parent_class;
};

struct _FontManagerBrowsePanePrivate {
	gdouble _pane_position;
	JsonArray* _available_fonts;
	FontManagerReject* _disabled_families;
	FontManagerPreviewTileSize _size;
	FontManagerBrowseMode _mode;
	FontManagerWaterfallSettings* _waterfall_settings;
	GtkStack* _stack;
	GtkEntry* preview_entry;
	GtkSearchBar* search_bar;
	GtkSearchEntry* search_entry;
	GtkToggleButton* edit_toggle;
	GtkToggleButton* panel_toggle;
	GtkToggleButton* search_toggle;
	GtkAdjustment* icon_size_adjustment;
	FontManagerPaned* pane;
	GtkStack* control_stack;
	FontManagerBrowseListView* listview;
	FontManagerFontScale* fontscale;
	GtkRevealer* panel_revealer;
	GtkScrolledWindow* gridview_container;
	FontManagerBrowsePreview* preview;
	FontManagerFontGridView* gridview;
};

static gint FontManagerFontPreviewTile_private_offset;
static gpointer font_manager_font_preview_tile_parent_class = NULL;
static gint FontManagerFontGridView_private_offset;
static gpointer font_manager_font_grid_view_parent_class = NULL;
static gint FontManagerBrowsePreview_private_offset;
static gpointer font_manager_browse_preview_parent_class = NULL;
static gint FontManagerBrowsePane_private_offset;
static gpointer font_manager_browse_pane_parent_class = NULL;

VALA_EXTERN GType font_manager_browse_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* font_manager_browse_mode_to_string (FontManagerBrowseMode self);
VALA_EXTERN FontManagerBrowseMode font_manager_browse_mode_from_string (const gchar* mode);
VALA_EXTERN GType font_manager_preview_tile_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gint font_manager_preview_tile_size_to_preview_size (FontManagerPreviewTileSize self);
VALA_EXTERN gdouble font_manager_preview_tile_size_to_double (FontManagerPreviewTileSize self);
VALA_EXTERN FontManagerPreviewTileSize font_manager_preview_tile_size_from_double (gdouble val);
VALA_EXTERN gboolean font_manager_have_valid_preview_text (const gchar* preview_text);
static PangoLanguage* _vala_PangoLanguage_copy (PangoLanguage* self);
static void _vala_PangoLanguage_free (PangoLanguage* self);
VALA_EXTERN GType font_manager_font_preview_tile_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerFontPreviewTile, g_object_unref)
VALA_EXTERN PangoAttrList* font_manager_font_preview_tile_get_attrs (FontManagerFontPreviewTile* self);
VALA_EXTERN FontManagerFontPreviewTile* font_manager_font_preview_tile_new (void);
VALA_EXTERN FontManagerFontPreviewTile* font_manager_font_preview_tile_construct (GType object_type);
VALA_EXTERN void font_manager_font_preview_tile_set_preview (FontManagerFontPreviewTile* self,
                                                 GtkInscription* value);
VALA_EXTERN void font_manager_font_preview_tile_set_attrs (FontManagerFontPreviewTile* self,
                                               PangoAttrList* value);
VALA_EXTERN FontManagerPreviewTileSize font_manager_font_preview_tile_get_size (FontManagerFontPreviewTile* self);
VALA_EXTERN GtkInscription* font_manager_font_preview_tile_get_preview (FontManagerFontPreviewTile* self);
static void __lambda142_ (FontManagerFontPreviewTile* self,
                   GParamSpec* pspec);
VALA_EXTERN void font_manager_font_preview_tile_on_item_set (FontManagerFontPreviewTile* self);
static void ___lambda142__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void __lambda143_ (FontManagerFontPreviewTile* self,
                   GParamSpec* pspec);
static void ___lambda143__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
VALA_EXTERN void font_manager_font_preview_tile_reset (FontManagerFontPreviewTile* self);
VALA_EXTERN GObject* font_manager_font_preview_tile_get_item (FontManagerFontPreviewTile* self);
VALA_EXTERN const gchar* font_manager_font_preview_tile_get_preview_text (FontManagerFontPreviewTile* self);
VALA_EXTERN void font_manager_font_preview_tile_set_item (FontManagerFontPreviewTile* self,
                                              GObject* value);
VALA_EXTERN void font_manager_font_preview_tile_set_size (FontManagerFontPreviewTile* self,
                                              FontManagerPreviewTileSize value);
VALA_EXTERN void font_manager_font_preview_tile_set_preview_text (FontManagerFontPreviewTile* self,
                                                      const gchar* value);
static void font_manager_font_preview_tile_finalize (GObject * obj);
static GType font_manager_font_preview_tile_get_type_once (void);
static void _vala_font_manager_font_preview_tile_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_font_manager_font_preview_tile_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);
VALA_EXTERN GType font_manager_font_list_base_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerFontListBase, g_object_unref)
VALA_EXTERN GType font_manager_font_grid_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerFontGridView, g_object_unref)
VALA_EXTERN void font_manager_font_list_base_setup_list_row (FontManagerFontListBase* self,
                                                 GtkSignalListItemFactory* factory,
                                                 GObject* item);
VALA_EXTERN void font_manager_font_list_base_bind_list_row (FontManagerFontListBase* self,
                                                GtkSignalListItemFactory* factory,
                                                GObject* item);
VALA_EXTERN void font_manager_font_list_base_on_selection_changed (FontManagerFontListBase* self,
                                                       guint position,
                                                       guint n_items);
VALA_EXTERN FontManagerFontGridView* font_manager_font_grid_view_new (GtkScrolledWindow* parent);
VALA_EXTERN FontManagerFontGridView* font_manager_font_grid_view_construct (GType object_type,
                                                                GtkScrolledWindow* parent);
VALA_EXTERN FontManagerFontListBase* font_manager_font_list_base_new (void);
VALA_EXTERN FontManagerFontListBase* font_manager_font_list_base_construct (GType object_type);
VALA_EXTERN FontManagerFontModel* font_manager_font_model_new (void);
VALA_EXTERN FontManagerFontModel* font_manager_font_model_construct (GType object_type);
VALA_EXTERN GType font_manager_base_font_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerBaseFontModel, g_object_unref)
VALA_EXTERN GType font_manager_font_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerFontModel, g_object_unref)
VALA_EXTERN void font_manager_font_list_base_set_model (FontManagerFontListBase* self,
                                            FontManagerBaseFontModel* value);
static void __lambda138_ (FontManagerFontGridView* self);
VALA_EXTERN GtkListBase* font_manager_font_list_base_get_list (FontManagerFontListBase* self);
VALA_EXTERN void font_manager_font_grid_view_create_gridview (FontManagerFontGridView* self);
VALA_EXTERN void font_manager_font_list_base_queue_update (FontManagerFontListBase* self);
static void ___lambda138__gtk_widget_map (GtkWidget* _sender,
                                   gpointer self);
static void __lambda140_ (FontManagerFontGridView* self);
static void ___lambda140__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void __lambda141_ (FontManagerFontGridView* self);
static void ___lambda141__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
VALA_EXTERN FontManagerBaseFontModel* font_manager_font_list_base_get_model (FontManagerFontListBase* self);
VALA_EXTERN void font_manager_font_grid_view_set_search_entry (FontManagerFontGridView* self,
                                                   GtkSearchEntry* entry);
VALA_EXTERN void font_manager_font_list_base_set_search_entry (FontManagerFontListBase* self,
                                                   GtkSearchEntry* value);
VALA_EXTERN void font_manager_font_list_base_set_list (FontManagerFontListBase* self,
                                           GtkListBase* value);
VALA_EXTERN void font_manager_font_list_base_set_selection (FontManagerFontListBase* self,
                                                GtkSelectionModel* value);
VALA_EXTERN guint font_manager_base_font_model_get_n_items (FontManagerBaseFontModel* self);
static gboolean ___lambda139_ (FontManagerFontGridView* self);
VALA_EXTERN void font_manager_font_list_base_select_item (FontManagerFontListBase* self,
                                              guint position);
static gboolean ____lambda139__gsource_func (gpointer self);
static void font_manager_font_grid_view_real_setup_list_row (FontManagerFontListBase* base,
                                                      GtkSignalListItemFactory* factory,
                                                      GObject* item);
static void font_manager_font_grid_view_real_bind_list_row (FontManagerFontListBase* base,
                                                     GtkSignalListItemFactory* factory,
                                                     GObject* item);
static void font_manager_font_grid_view_real_on_selection_changed (FontManagerFontListBase* base,
                                                            guint position,
                                                            guint n_items);
VALA_EXTERN void font_manager_font_list_base_set_selected_item (FontManagerFontListBase* self,
                                                    GObject* value);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN void font_manager_font_list_base_set_selected_items (FontManagerFontListBase* self,
                                                     GPtrArray* value);
VALA_EXTERN guint font_manager_font_list_base_get_current_selection (FontManagerFontListBase* self);
VALA_EXTERN GPtrArray* font_manager_font_list_base_get_selected_items (FontManagerFontListBase* self);
VALA_EXTERN FontManagerPreviewTileSize font_manager_font_grid_view_get_size (FontManagerFontGridView* self);
VALA_EXTERN void font_manager_font_grid_view_set_size (FontManagerFontGridView* self,
                                           FontManagerPreviewTileSize value);
VALA_EXTERN const gchar* font_manager_font_grid_view_get_preview_text (FontManagerFontGridView* self);
VALA_EXTERN void font_manager_font_grid_view_set_preview_text (FontManagerFontGridView* self,
                                                   const gchar* value);
static void font_manager_font_grid_view_finalize (GObject * obj);
static GType font_manager_font_grid_view_get_type_once (void);
static void _vala_font_manager_font_grid_view_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_font_manager_font_grid_view_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
VALA_EXTERN GType font_manager_browse_preview_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType font_manager_browse_preview_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerBrowsePreview, g_object_unref)
static void font_manager_browse_preview_on_preview_mode_activated (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            FontManagerBrowsePreview* self);
static gchar* _variant_get1 (GVariant* value);
VALA_EXTERN FontManagerPreviewPage* font_manager_browse_preview_get_preview_page (FontManagerBrowsePreview* self);
static void font_manager_browse_preview_on_item_state_changed (FontManagerBrowsePreview* self);
VALA_EXTERN GObject* font_manager_browse_preview_get_selected_item (FontManagerBrowsePreview* self);
VALA_EXTERN FontManagerReject* font_manager_browse_preview_get_disabled_families (FontManagerBrowsePreview* self);
static void font_manager_browse_preview_append_metadata (FontManagerBrowsePreview* self,
                                                  GString* builder,
                                                  const gchar* metadata);
VALA_EXTERN void font_manager_browse_preview_update_metadata (FontManagerBrowsePreview* self);
VALA_EXTERN FontManagerDatabase* font_manager_database_proxy_get_default_db (void);
static void font_manager_browse_preview_on_item_selected (FontManagerBrowsePreview* self);
VALA_EXTERN FontManagerBaseFontModel* font_manager_browse_preview_get_model (FontManagerBrowsePreview* self);
VALA_EXTERN GListModel* font_manager_font_model_get_child_model (FontManagerFontModel* self,
                                                     GObject* item);
static void font_manager_browse_preview_on_variant_selected (FontManagerBrowsePreview* self);
VALA_EXTERN FontManagerUnicodeCharacterMap* font_manager_browse_preview_get_character_map (FontManagerBrowsePreview* self);
VALA_EXTERN void font_manager_browse_preview_setup_style_row (FontManagerBrowsePreview* self,
                                                  GtkSignalListItemFactory* factory,
                                                  GObject* item);
VALA_EXTERN void font_manager_browse_preview_bind_style_row (FontManagerBrowsePreview* self,
                                                 GtkSignalListItemFactory* factory,
                                                 GObject* item);
static GtkSignalListItemFactory* font_manager_browse_preview_get_style_factory (FontManagerBrowsePreview* self);
static void _font_manager_browse_preview_setup_style_row_gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                                      GObject* object,
                                                                                      gpointer self);
static void _font_manager_browse_preview_bind_style_row_gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                                    GObject* object,
                                                                                    gpointer self);
VALA_EXTERN FontManagerBrowsePreview* font_manager_browse_preview_new (void);
VALA_EXTERN FontManagerBrowsePreview* font_manager_browse_preview_construct (GType object_type);
VALA_EXTERN void font_manager_browse_preview_set_disabled_families (FontManagerBrowsePreview* self,
                                                        FontManagerReject* value);
VALA_EXTERN void font_manager_browse_preview_set_selected_item (FontManagerBrowsePreview* self,
                                                    GObject* value);
VALA_EXTERN void font_manager_browse_preview_set_model (FontManagerBrowsePreview* self,
                                            FontManagerBaseFontModel* value);
VALA_EXTERN void font_manager_browse_preview_set_preview_page (FontManagerBrowsePreview* self,
                                                   FontManagerPreviewPage* value);
VALA_EXTERN void font_manager_browse_preview_set_character_map (FontManagerBrowsePreview* self,
                                                    FontManagerUnicodeCharacterMap* value);
VALA_EXTERN FontManagerWaterfallSettings* font_manager_browse_preview_get_waterfall_settings (FontManagerBrowsePreview* self);
VALA_EXTERN void font_manager_browse_preview_set_waterfall_settings (FontManagerBrowsePreview* self,
                                                         FontManagerWaterfallSettings* value);
VALA_EXTERN gint font_manager_browse_preview_get_predefined_size (FontManagerBrowsePreview* self);
VALA_EXTERN void font_manager_browse_preview_set_predefined_size (FontManagerBrowsePreview* self,
                                                      gint value);
VALA_EXTERN FontManagerBrowsePreviewMode font_manager_browse_preview_get_mode (FontManagerBrowsePreview* self);
static GObject * font_manager_browse_preview_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _font_manager_browse_preview___lambda129_ (FontManagerBrowsePreview* self);
static void __font_manager_browse_preview___lambda129__g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static void _font_manager_browse_preview___lambda130_ (FontManagerBrowsePreview* self);
static void __font_manager_browse_preview___lambda130__g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static void _font_manager_browse_preview___lambda131_ (FontManagerBrowsePreview* self);
static void __font_manager_browse_preview___lambda131__g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static void _font_manager_browse_preview___lambda132_ (FontManagerBrowsePreview* self,
                                                const gchar* codepoint,
                                                const gchar* name,
                                                const gchar* n_codepoints);
static void __font_manager_browse_preview___lambda132__font_manager_unicode_character_map_selection_changed (FontManagerUnicodeCharacterMap* _sender,
                                                                                                      const gchar* codepoint,
                                                                                                      const gchar* codepoint_name,
                                                                                                      const gchar* n_codepoints,
                                                                                                      gpointer self);
static void _font_manager_browse_preview___lambda133_ (FontManagerBrowsePreview* self);
static void ___lambda134_ (FontManagerBrowsePreview* self);
static void ____lambda134__font_manager_string_set_changed (FontManagerStringSet* _sender,
                                                     gpointer self);
static void __font_manager_browse_preview___lambda133__g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static void _font_manager_browse_preview___lambda135_ (FontManagerBrowsePreview* self);
static void __font_manager_browse_preview___lambda135__g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static void _font_manager_browse_preview___lambda136_ (FontManagerBrowsePreview* self);
static void __font_manager_browse_preview___lambda136__g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static void _font_manager_browse_preview___lambda137_ (FontManagerBrowsePreview* self);
static void __font_manager_browse_preview___lambda137__g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static void font_manager_browse_preview_finalize (GObject * obj);
static GType font_manager_browse_preview_get_type_once (void);
static void _vala_font_manager_browse_preview_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_font_manager_browse_preview_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
VALA_EXTERN GType font_manager_browse_pane_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerBrowsePane, g_object_unref)
VALA_EXTERN GType font_manager_paned_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerPaned, g_object_unref)
VALA_EXTERN GType font_manager_browse_list_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerBrowseListView, g_object_unref)
VALA_EXTERN FontManagerBrowsePane* font_manager_browse_pane_new (void);
VALA_EXTERN FontManagerBrowsePane* font_manager_browse_pane_construct (GType object_type);
VALA_EXTERN void font_manager_paned_set_start_child (FontManagerPaned* self,
                                         GtkWidget* widget);
VALA_EXTERN void font_manager_paned_set_end_child (FontManagerPaned* self,
                                       GtkWidget* widget);
static void font_manager_browse_pane_set_fontscale_margins (FontManagerBrowsePane* self);
VALA_EXTERN FontManagerPreviewTileSize font_manager_browse_pane_get_size (FontManagerBrowsePane* self);
static void __lambda144_ (FontManagerBrowsePane* self);
static void ___lambda144__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void __lambda145_ (FontManagerBrowsePane* self);
static void ___lambda145__font_manager_font_list_base_activated (FontManagerFontListBase* _sender,
                                                          guint position,
                                                          gpointer self);
static void font_manager_browse_pane_on_map (FontManagerBrowsePane* self);
static void _font_manager_browse_pane_on_map_gtk_widget_map (GtkWidget* _sender,
                                                      gpointer self);
static void font_manager_browse_pane_on_mode_changed (FontManagerBrowsePane* self);
static void _font_manager_browse_pane_on_mode_changed_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void __lambda146_ (FontManagerBrowsePane* self);
VALA_EXTERN FontManagerWaterfallSettings* font_manager_browse_pane_get_waterfall_settings (FontManagerBrowsePane* self);
static void ___lambda146__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
VALA_EXTERN void font_manager_browse_pane_on_zoom (FontManagerBrowsePane* self,
                                       const gchar* action,
                                       GVariant* parameter);
static gchar* _variant_get2 (GVariant* value);
VALA_EXTERN FontManagerBrowseMode font_manager_browse_pane_get_mode (FontManagerBrowsePane* self);
VALA_EXTERN void font_manager_browse_pane_queue_update (FontManagerBrowsePane* self);
VALA_EXTERN void font_manager_browse_pane_restore_state (FontManagerBrowsePane* self,
                                             GSettings* settings);
VALA_EXTERN void font_manager_browse_pane_set_pane_position (FontManagerBrowsePane* self,
                                                 gdouble value);
VALA_EXTERN void font_manager_browse_list_view_set_preview_size (FontManagerBrowseListView* self,
                                                     gdouble value);
VALA_EXTERN void font_manager_browse_pane_select_first_font (FontManagerBrowsePane* self);
VALA_EXTERN void font_manager_browse_list_view_queue_update (FontManagerBrowseListView* self);
static void font_manager_browse_pane_toggle_panel (FontManagerBrowsePane* self,
                                            GtkWidget* widget,
                                            const gchar* action,
                                            GVariant* parameter);
VALA_EXTERN void font_manager_browse_pane_toggle_search (FontManagerBrowsePane* self);
VALA_EXTERN void font_manager_browse_pane_search (FontManagerBrowsePane* self,
                                      const gchar* needle);
VALA_EXTERN void font_manager_browse_pane_on_edit_toggled (FontManagerBrowsePane* self,
                                               GtkToggleButton* unused);
static void _font_manager_browse_pane_on_edit_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                          gpointer self);
VALA_EXTERN void font_manager_browse_pane_on_decrease_size (FontManagerBrowsePane* self,
                                                GtkButton* unused);
static void _font_manager_browse_pane_on_decrease_size_gtk_button_clicked (GtkButton* _sender,
                                                                    gpointer self);
VALA_EXTERN void font_manager_browse_pane_on_increase_size (FontManagerBrowsePane* self,
                                                GtkButton* unused);
static void _font_manager_browse_pane_on_increase_size_gtk_button_clicked (GtkButton* _sender,
                                                                    gpointer self);
VALA_EXTERN void font_manager_browse_pane_on_scale_changed (FontManagerBrowsePane* self,
                                                GtkRange* range);
VALA_EXTERN void font_manager_browse_pane_set_size (FontManagerBrowsePane* self,
                                        FontManagerPreviewTileSize value);
static void _font_manager_browse_pane_on_scale_changed_gtk_range_value_changed (GtkRange* _sender,
                                                                         gpointer self);
VALA_EXTERN gdouble font_manager_browse_pane_get_pane_position (FontManagerBrowsePane* self);
VALA_EXTERN JsonArray* font_manager_browse_pane_get_available_fonts (FontManagerBrowsePane* self);
VALA_EXTERN void font_manager_browse_pane_set_available_fonts (FontManagerBrowsePane* self,
                                                   JsonArray* value);
VALA_EXTERN FontManagerReject* font_manager_browse_pane_get_disabled_families (FontManagerBrowsePane* self);
VALA_EXTERN void font_manager_browse_pane_set_disabled_families (FontManagerBrowsePane* self,
                                                     FontManagerReject* value);
VALA_EXTERN void font_manager_browse_pane_set_mode (FontManagerBrowsePane* self,
                                        FontManagerBrowseMode value);
VALA_EXTERN void font_manager_browse_pane_set_waterfall_settings (FontManagerBrowsePane* self,
                                                      FontManagerWaterfallSettings* value);
VALA_EXTERN GtkStack* font_manager_browse_pane_get_stack (FontManagerBrowsePane* self);
static void font_manager_browse_pane_finalize (GObject * obj);
static GType font_manager_browse_pane_get_type_once (void);
static void _vala_font_manager_browse_pane_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_font_manager_browse_pane_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

gchar*
font_manager_browse_mode_to_string (FontManagerBrowseMode self)
{
	gchar* result;
	switch (self) {
		case FONT_MANAGER_BROWSE_MODE_LIST:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("list");
			result = _tmp0_;
			return result;
		}
		default:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("grid");
			result = _tmp1_;
			return result;
		}
	}
}

FontManagerBrowseMode
font_manager_browse_mode_from_string (const gchar* mode)
{
	gboolean _tmp0_ = FALSE;
	FontManagerBrowseMode result;
	g_return_val_if_fail (mode != NULL, 0);
	if (g_strcmp0 (mode, "list") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (mode, "1") == 0;
	}
	if (_tmp0_) {
		result = FONT_MANAGER_BROWSE_MODE_LIST;
		return result;
	} else {
		result = FONT_MANAGER_BROWSE_MODE_GRID;
		return result;
	}
}

 G_GNUC_NO_INLINE static GType
font_manager_browse_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{FONT_MANAGER_BROWSE_MODE_GRID, "FONT_MANAGER_BROWSE_MODE_GRID", "grid"}, {FONT_MANAGER_BROWSE_MODE_LIST, "FONT_MANAGER_BROWSE_MODE_LIST", "list"}, {FONT_MANAGER_BROWSE_MODE_N_MODES, "FONT_MANAGER_BROWSE_MODE_N_MODES", "n-modes"}, {0, NULL, NULL}};
	GType font_manager_browse_mode_type_id;
	font_manager_browse_mode_type_id = g_enum_register_static ("FontManagerBrowseMode", values);
	return font_manager_browse_mode_type_id;
}

GType
font_manager_browse_mode_get_type (void)
{
	static volatile gsize font_manager_browse_mode_type_id__once = 0;
	if (g_once_init_enter (&font_manager_browse_mode_type_id__once)) {
		GType font_manager_browse_mode_type_id;
		font_manager_browse_mode_type_id = font_manager_browse_mode_get_type_once ();
		g_once_init_leave (&font_manager_browse_mode_type_id__once, font_manager_browse_mode_type_id);
	}
	return font_manager_browse_mode_type_id__once;
}

gint
font_manager_preview_tile_size_to_preview_size (FontManagerPreviewTileSize self)
{
	gint result;
	switch (self) {
		case FONT_MANAGER_PREVIEW_TILE_SIZE_SMALL:
		{
			result = 10;
			return result;
		}
		case FONT_MANAGER_PREVIEW_TILE_SIZE_MEDIUM:
		{
			result = 12;
			return result;
		}
		case FONT_MANAGER_PREVIEW_TILE_SIZE_XLARGE:
		{
			result = 24;
			return result;
		}
		case FONT_MANAGER_PREVIEW_TILE_SIZE_XXLARGE:
		{
			result = 36;
			return result;
		}
		default:
		{
			result = 14;
			return result;
		}
	}
}

gdouble
font_manager_preview_tile_size_to_double (FontManagerPreviewTileSize self)
{
	gdouble result;
	switch (self) {
		case FONT_MANAGER_PREVIEW_TILE_SIZE_SMALL:
		{
			result = (gdouble) 0.0f;
			return result;
		}
		case FONT_MANAGER_PREVIEW_TILE_SIZE_MEDIUM:
		{
			result = (gdouble) 1.0f;
			return result;
		}
		case FONT_MANAGER_PREVIEW_TILE_SIZE_XLARGE:
		{
			result = (gdouble) 3.0f;
			return result;
		}
		case FONT_MANAGER_PREVIEW_TILE_SIZE_XXLARGE:
		{
			result = 4.0;
			return result;
		}
		default:
		{
			result = (gdouble) 2.0f;
			return result;
		}
	}
}

FontManagerPreviewTileSize
font_manager_preview_tile_size_from_double (gdouble val)
{
	FontManagerPreviewTileSize result;
	_vala_return_val_if_fail ((val >= ((gdouble) 0.0f)) && (val <= ((gdouble) 4.0f)), "val >= 0.0f && val <= 4.0f", 0);
	if (val == 0.0) {
		result = FONT_MANAGER_PREVIEW_TILE_SIZE_SMALL;
		return result;
	} else {
		if (val == 1.0) {
			result = FONT_MANAGER_PREVIEW_TILE_SIZE_MEDIUM;
			return result;
		} else {
			if (val == 2.0) {
				result = FONT_MANAGER_PREVIEW_TILE_SIZE_LARGE;
				return result;
			} else {
				if (val == 3.0) {
					result = FONT_MANAGER_PREVIEW_TILE_SIZE_XLARGE;
					return result;
				} else {
					result = FONT_MANAGER_PREVIEW_TILE_SIZE_XXLARGE;
					return result;
				}
			}
		}
	}
}

 G_GNUC_NO_INLINE static GType
font_manager_preview_tile_size_get_type_once (void)
{
	static const GEnumValue values[] = {{FONT_MANAGER_PREVIEW_TILE_SIZE_SMALL, "FONT_MANAGER_PREVIEW_TILE_SIZE_SMALL", "small"}, {FONT_MANAGER_PREVIEW_TILE_SIZE_MEDIUM, "FONT_MANAGER_PREVIEW_TILE_SIZE_MEDIUM", "medium"}, {FONT_MANAGER_PREVIEW_TILE_SIZE_LARGE, "FONT_MANAGER_PREVIEW_TILE_SIZE_LARGE", "large"}, {FONT_MANAGER_PREVIEW_TILE_SIZE_XLARGE, "FONT_MANAGER_PREVIEW_TILE_SIZE_XLARGE", "xlarge"}, {FONT_MANAGER_PREVIEW_TILE_SIZE_XXLARGE, "FONT_MANAGER_PREVIEW_TILE_SIZE_XXLARGE", "xxlarge"}, {0, NULL, NULL}};
	GType font_manager_preview_tile_size_type_id;
	font_manager_preview_tile_size_type_id = g_enum_register_static ("FontManagerPreviewTileSize", values);
	return font_manager_preview_tile_size_type_id;
}

GType
font_manager_preview_tile_size_get_type (void)
{
	static volatile gsize font_manager_preview_tile_size_type_id__once = 0;
	if (g_once_init_enter (&font_manager_preview_tile_size_type_id__once)) {
		GType font_manager_preview_tile_size_type_id;
		font_manager_preview_tile_size_type_id = font_manager_preview_tile_size_get_type_once ();
		g_once_init_leave (&font_manager_preview_tile_size_type_id__once, font_manager_preview_tile_size_type_id);
	}
	return font_manager_preview_tile_size_type_id__once;
}

static PangoLanguage*
_vala_PangoLanguage_copy (PangoLanguage* self)
{
	return g_boxed_copy (pango_language_get_type (), self);
}

static gpointer
__vala_PangoLanguage_copy0 (gpointer self)
{
	return self ? _vala_PangoLanguage_copy (self) : NULL;
}

static void
_vala_PangoLanguage_free (PangoLanguage* self)
{
	g_boxed_free (pango_language_get_type (), self);
}

gboolean
font_manager_have_valid_preview_text (const gchar* preview_text)
{
	PangoLanguage* C = NULL;
	PangoLanguage* _tmp0_;
	PangoLanguage* _tmp1_;
	gchar* default_preview_text = NULL;
	PangoLanguage* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean result;
	if (preview_text == NULL) {
		result = FALSE;
		return result;
	}
	_tmp0_ = pango_language_from_string ("xx");
	_tmp1_ = __vala_PangoLanguage_copy0 (_tmp0_);
	C = _tmp1_;
	_tmp2_ = C;
	_tmp3_ = pango_language_get_sample_string (_tmp2_);
	_tmp4_ = g_strdup (_tmp3_);
	default_preview_text = _tmp4_;
	_tmp5_ = default_preview_text;
	result = g_strcmp0 (preview_text, _tmp5_) != 0;
	_g_free0 (default_preview_text);
	__vala_PangoLanguage_free0 (C);
	return result;
}

static inline gpointer
font_manager_font_preview_tile_get_instance_private (FontManagerFontPreviewTile* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerFontPreviewTile_private_offset);
}

static void
__lambda142_ (FontManagerFontPreviewTile* self,
              GParamSpec* pspec)
{
	g_return_if_fail (pspec != NULL);
	font_manager_font_preview_tile_on_item_set (self);
}

static void
___lambda142__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda142_ ((FontManagerFontPreviewTile*) self, pspec);
}

static void
__lambda143_ (FontManagerFontPreviewTile* self,
              GParamSpec* pspec)
{
	PangoAttrList* _tmp0_;
	FontManagerPreviewTileSize _tmp1_;
	PangoAttribute* _tmp2_;
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->_attrs;
	_tmp1_ = self->priv->_size;
	_tmp2_ = pango_attr_size_new (font_manager_preview_tile_size_to_preview_size (_tmp1_) * PANGO_SCALE);
	pango_attr_list_change (_tmp0_, _tmp2_);
}

static void
___lambda143__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda143_ ((FontManagerFontPreviewTile*) self, pspec);
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

FontManagerFontPreviewTile*
font_manager_font_preview_tile_construct (GType object_type)
{
	FontManagerFontPreviewTile * self = NULL;
	GtkOverlay* _tmp0_;
	GtkInscription* _tmp1_ = NULL;
	GtkInscription* _tmp2_;
	PangoAttrList* _tmp3_;
	PangoAttrList* _tmp4_;
	PangoAttrList* _tmp5_;
	PangoAttribute* _tmp6_;
	PangoAttrList* _tmp7_;
	FontManagerPreviewTileSize _tmp8_;
	PangoAttribute* _tmp9_;
	PangoFontDescription* font_desc = NULL;
	PangoFontDescription* _tmp10_;
	PangoAttrList* _tmp11_;
	PangoAttrFontDesc* _tmp12_;
	GtkInscription* _tmp13_;
	PangoAttrList* _tmp14_;
	GtkOverlay* _tmp15_;
	GtkInscription* _tmp16_;
	GtkOverlay* _tmp17_;
	GtkLabel* _tmp18_ = NULL;
	GtkLabel* _tmp19_;
	GtkOverlay* _tmp20_;
	GtkLabel* _tmp21_;
	self = (FontManagerFontPreviewTile*) g_object_new (object_type, NULL);
	font_manager_widget_set_name ((GtkWidget*) self, "FontManagerFontPreviewTile");
	font_manager_widget_set_margin ((GtkWidget*) self, 6);
	_tmp0_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->overlay);
	self->priv->overlay = _tmp0_;
	_tmp1_ = (GtkInscription*) gtk_inscription_new (NULL);
	gtk_widget_set_halign ((GtkWidget*) _tmp1_, GTK_ALIGN_FILL);
	gtk_widget_set_valign ((GtkWidget*) _tmp1_, GTK_ALIGN_FILL);
	gtk_inscription_set_xalign (_tmp1_, 0.5f);
	gtk_inscription_set_yalign (_tmp1_, 0.5f);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp1_, TRUE);
	g_object_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	font_manager_font_preview_tile_set_preview (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = pango_attr_list_new ();
	_tmp4_ = _tmp3_;
	font_manager_font_preview_tile_set_attrs (self, _tmp4_);
	_pango_attr_list_unref0 (_tmp4_);
	_tmp5_ = self->priv->_attrs;
	_tmp6_ = pango_attr_fallback_new (FALSE);
	pango_attr_list_insert (_tmp5_, _tmp6_);
	_tmp7_ = self->priv->_attrs;
	_tmp8_ = self->priv->_size;
	_tmp9_ = pango_attr_size_new (font_manager_preview_tile_size_to_preview_size (_tmp8_) * PANGO_SCALE);
	pango_attr_list_insert (_tmp7_, _tmp9_);
	_tmp10_ = pango_font_description_from_string ("Sans");
	font_desc = _tmp10_;
	_tmp11_ = self->priv->_attrs;
	_tmp12_ = (PangoAttrFontDesc*) pango_attr_font_desc_new (font_desc);
	pango_attr_list_insert (_tmp11_, (PangoAttribute*) _tmp12_);
	_tmp13_ = self->priv->_preview;
	_tmp14_ = self->priv->_attrs;
	gtk_inscription_set_attributes (_tmp13_, _tmp14_);
	_tmp15_ = self->priv->overlay;
	_tmp16_ = self->priv->_preview;
	gtk_overlay_set_child (_tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = self->priv->overlay;
	gtk_frame_set_child ((GtkFrame*) self, (GtkWidget*) _tmp17_);
	_tmp18_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_widget_set_halign ((GtkWidget*) _tmp18_, GTK_ALIGN_END);
	gtk_widget_set_valign ((GtkWidget*) _tmp18_, GTK_ALIGN_END);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp18_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp18_, 9);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp18_, 9);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp18_, 6);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->item_count);
	self->priv->item_count = _tmp18_;
	_tmp19_ = self->priv->item_count;
	gtk_widget_add_css_class ((GtkWidget*) _tmp19_, "dim-label");
	_tmp20_ = self->priv->overlay;
	_tmp21_ = self->priv->item_count;
	gtk_overlay_add_overlay (_tmp20_, (GtkWidget*) _tmp21_);
	g_signal_connect_object ((GObject*) self, "notify::item", (GCallback) ___lambda142__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::size", (GCallback) ___lambda143__g_object_notify, self, 0);
	__vala_PangoFontDescription_free0 (font_desc);
	return self;
}

FontManagerFontPreviewTile*
font_manager_font_preview_tile_new (void)
{
	return font_manager_font_preview_tile_construct (FONT_MANAGER_TYPE_FONT_PREVIEW_TILE);
}

void
font_manager_font_preview_tile_reset (FontManagerFontPreviewTile* self)
{
	GtkInscription* _tmp0_;
	FontManagerPreviewTileSize _tmp1_;
	FontManagerPreviewTileSize _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_preview;
	gtk_inscription_set_text (_tmp0_, NULL);
	gtk_widget_set_tooltip_text ((GtkWidget*) self, NULL);
	_tmp1_ = self->priv->_size;
	_tmp2_ = self->priv->_size;
	gtk_widget_set_size_request ((GtkWidget*) self, (gint) _tmp1_, (gint) _tmp2_);
	return;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

void
font_manager_font_preview_tile_on_item_set (FontManagerFontPreviewTile* self)
{
	GObject* _tmp0_;
	FontManagerFamily* f = NULL;
	GObject* _tmp1_;
	FontManagerFamily* _tmp2_;
	FontManagerFamily* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* sample = NULL;
	FontManagerFamily* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_;
	gchar* display_text = NULL;
	gchar* _tmp17_;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	GtkInscription* _tmp25_;
	const gchar* _tmp26_;
	PangoFontDescription* font_desc = NULL;
	FontManagerFamily* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	PangoFontDescription* _tmp31_;
	PangoAttrList* _tmp32_;
	PangoFontDescription* _tmp33_;
	PangoAttrFontDesc* _tmp34_;
	gint count = 0;
	FontManagerFamily* _tmp35_;
	gint64 _tmp36_;
	gint64 _tmp37_;
	GtkLabel* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	GtkLabel* _tmp41_;
	g_return_if_fail (self != NULL);
	font_manager_font_preview_tile_reset (self);
	_tmp0_ = self->priv->_item;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_item;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, font_manager_family_get_type (), FontManagerFamily));
	f = _tmp2_;
	_tmp3_ = f;
	g_object_get (_tmp3_, "family", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = f;
	g_object_get (_tmp7_, "preview-text", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	sample = _tmp9_;
	_tmp11_ = sample;
	if (font_manager_have_valid_preview_text (_tmp11_)) {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = sample;
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (_tmp10_);
		_tmp10_ = _tmp13_;
	} else {
		FontManagerFamily* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp14_ = f;
		g_object_get (_tmp14_, "family", &_tmp15_, NULL);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp10_);
		_tmp10_ = _tmp16_;
	}
	_tmp17_ = g_strdup (_tmp10_);
	display_text = _tmp17_;
	_tmp19_ = self->priv->_preview_text;
	if (_tmp19_ != NULL) {
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp20_ = self->priv->_preview_text;
		_tmp21_ = string_strip (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp18_ = g_strcmp0 (_tmp22_, "") != 0;
		_g_free0 (_tmp22_);
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		const gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp23_ = self->priv->_preview_text;
		_tmp24_ = g_strdup (_tmp23_);
		_g_free0 (display_text);
		display_text = _tmp24_;
	}
	_tmp25_ = self->priv->_preview;
	_tmp26_ = display_text;
	gtk_inscription_set_text (_tmp25_, _tmp26_);
	_tmp27_ = f;
	g_object_get (_tmp27_, "description", &_tmp28_, NULL);
	_tmp29_ = _tmp28_;
	_tmp30_ = _tmp29_;
	_tmp31_ = pango_font_description_from_string (_tmp30_);
	__vala_PangoFontDescription_free0 (font_desc);
	font_desc = _tmp31_;
	_g_free0 (_tmp30_);
	_tmp32_ = self->priv->_attrs;
	_tmp33_ = font_desc;
	_tmp34_ = (PangoAttrFontDesc*) pango_attr_font_desc_new (_tmp33_);
	pango_attr_list_change (_tmp32_, (PangoAttribute*) _tmp34_);
	_tmp35_ = f;
	g_object_get (_tmp35_, "n-variations", &_tmp36_, NULL);
	_tmp37_ = _tmp36_;
	count = (gint) _tmp37_;
	_tmp38_ = self->priv->item_count;
	_tmp39_ = g_strdup_printf ("%i", count);
	_tmp40_ = _tmp39_;
	gtk_label_set_label (_tmp38_, _tmp40_);
	_g_free0 (_tmp40_);
	_tmp41_ = self->priv->item_count;
	gtk_widget_set_visible ((GtkWidget*) _tmp41_, count > 1);
	__vala_PangoFontDescription_free0 (font_desc);
	_g_free0 (display_text);
	_g_free0 (_tmp10_);
	_g_free0 (sample);
	_g_object_unref0 (f);
	return;
}

GObject*
font_manager_font_preview_tile_get_item (FontManagerFontPreviewTile* self)
{
	GObject* result;
	GObject* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_item;
	result = _tmp0_;
	return result;
}

void
font_manager_font_preview_tile_set_item (FontManagerFontPreviewTile* self,
                                         GObject* value)
{
	GObject* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_font_preview_tile_get_item (self);
	if (old_value != value) {
		GObject* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_item);
		self->priv->_item = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_font_preview_tile_properties[FONT_MANAGER_FONT_PREVIEW_TILE_ITEM_PROPERTY]);
	}
}

FontManagerPreviewTileSize
font_manager_font_preview_tile_get_size (FontManagerFontPreviewTile* self)
{
	FontManagerPreviewTileSize result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_size;
	return result;
}

void
font_manager_font_preview_tile_set_size (FontManagerFontPreviewTile* self,
                                         FontManagerPreviewTileSize value)
{
	FontManagerPreviewTileSize old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_font_preview_tile_get_size (self);
	if (old_value != value) {
		self->priv->_size = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_font_preview_tile_properties[FONT_MANAGER_FONT_PREVIEW_TILE_SIZE_PROPERTY]);
	}
}

PangoAttrList*
font_manager_font_preview_tile_get_attrs (FontManagerFontPreviewTile* self)
{
	PangoAttrList* result;
	PangoAttrList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_attrs;
	result = _tmp0_;
	return result;
}

static gpointer
_pango_attr_list_ref0 (gpointer self)
{
	return self ? pango_attr_list_ref (self) : NULL;
}

void
font_manager_font_preview_tile_set_attrs (FontManagerFontPreviewTile* self,
                                          PangoAttrList* value)
{
	PangoAttrList* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_font_preview_tile_get_attrs (self);
	if (old_value != value) {
		PangoAttrList* _tmp0_;
		_tmp0_ = _pango_attr_list_ref0 (value);
		_pango_attr_list_unref0 (self->priv->_attrs);
		self->priv->_attrs = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_font_preview_tile_properties[FONT_MANAGER_FONT_PREVIEW_TILE_ATTRS_PROPERTY]);
	}
}

GtkInscription*
font_manager_font_preview_tile_get_preview (FontManagerFontPreviewTile* self)
{
	GtkInscription* result;
	GtkInscription* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_preview;
	result = _tmp0_;
	return result;
}

void
font_manager_font_preview_tile_set_preview (FontManagerFontPreviewTile* self,
                                            GtkInscription* value)
{
	GtkInscription* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_font_preview_tile_get_preview (self);
	if (old_value != value) {
		GtkInscription* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_preview);
		self->priv->_preview = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_font_preview_tile_properties[FONT_MANAGER_FONT_PREVIEW_TILE_PREVIEW_PROPERTY]);
	}
}

const gchar*
font_manager_font_preview_tile_get_preview_text (FontManagerFontPreviewTile* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_preview_text;
	result = _tmp0_;
	return result;
}

void
font_manager_font_preview_tile_set_preview_text (FontManagerFontPreviewTile* self,
                                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_font_preview_tile_get_preview_text (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_preview_text);
		self->priv->_preview_text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_font_preview_tile_properties[FONT_MANAGER_FONT_PREVIEW_TILE_PREVIEW_TEXT_PROPERTY]);
	}
}

static void
font_manager_font_preview_tile_class_init (FontManagerFontPreviewTileClass * klass,
                                           gpointer klass_data)
{
	font_manager_font_preview_tile_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerFontPreviewTile_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_font_preview_tile_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_font_preview_tile_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_font_preview_tile_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_FONT_PREVIEW_TILE_ITEM_PROPERTY, font_manager_font_preview_tile_properties[FONT_MANAGER_FONT_PREVIEW_TILE_ITEM_PROPERTY] = g_param_spec_object ("item", "item", "item", G_TYPE_OBJECT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_FONT_PREVIEW_TILE_SIZE_PROPERTY, font_manager_font_preview_tile_properties[FONT_MANAGER_FONT_PREVIEW_TILE_SIZE_PROPERTY] = g_param_spec_enum ("size", "size", "size", FONT_MANAGER_TYPE_PREVIEW_TILE_SIZE, FONT_MANAGER_PREVIEW_TILE_SIZE_LARGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_FONT_PREVIEW_TILE_ATTRS_PROPERTY, font_manager_font_preview_tile_properties[FONT_MANAGER_FONT_PREVIEW_TILE_ATTRS_PROPERTY] = g_param_spec_boxed ("attrs", "attrs", "attrs", pango_attr_list_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_FONT_PREVIEW_TILE_PREVIEW_PROPERTY, font_manager_font_preview_tile_properties[FONT_MANAGER_FONT_PREVIEW_TILE_PREVIEW_PROPERTY] = g_param_spec_object ("preview", "preview", "preview", gtk_inscription_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_FONT_PREVIEW_TILE_PREVIEW_TEXT_PROPERTY, font_manager_font_preview_tile_properties[FONT_MANAGER_FONT_PREVIEW_TILE_PREVIEW_TEXT_PROPERTY] = g_param_spec_string ("preview-text", "preview-text", "preview-text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
font_manager_font_preview_tile_instance_init (FontManagerFontPreviewTile * self,
                                              gpointer klass)
{
	PangoAttrList* _tmp0_;
	self->priv = font_manager_font_preview_tile_get_instance_private (self);
	self->priv->_item = NULL;
	self->priv->_size = FONT_MANAGER_PREVIEW_TILE_SIZE_LARGE;
	_tmp0_ = pango_attr_list_new ();
	self->priv->_attrs = _tmp0_;
	self->priv->_preview = NULL;
	self->priv->_preview_text = NULL;
}

static void
font_manager_font_preview_tile_finalize (GObject * obj)
{
	FontManagerFontPreviewTile * self;
	PangoAttrList* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_FONT_PREVIEW_TILE, FontManagerFontPreviewTile);
	_tmp0_ = self->priv->_attrs;
	if (_tmp0_ != NULL) {
		PangoAttrList* _tmp1_;
		_tmp1_ = self->priv->_attrs;
		pango_attr_list_unref (_tmp1_);
	}
	_g_object_unref0 (self->priv->_item);
	_pango_attr_list_unref0 (self->priv->_attrs);
	_g_object_unref0 (self->priv->_preview);
	_g_free0 (self->priv->_preview_text);
	_g_object_unref0 (self->priv->item_count);
	_g_object_unref0 (self->priv->overlay);
	G_OBJECT_CLASS (font_manager_font_preview_tile_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_font_preview_tile_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerFontPreviewTileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_font_preview_tile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerFontPreviewTile), 0, (GInstanceInitFunc) font_manager_font_preview_tile_instance_init, NULL };
	GType font_manager_font_preview_tile_type_id;
	font_manager_font_preview_tile_type_id = g_type_register_static (gtk_frame_get_type (), "FontManagerFontPreviewTile", &g_define_type_info, 0);
	FontManagerFontPreviewTile_private_offset = g_type_add_instance_private (font_manager_font_preview_tile_type_id, sizeof (FontManagerFontPreviewTilePrivate));
	return font_manager_font_preview_tile_type_id;
}

GType
font_manager_font_preview_tile_get_type (void)
{
	static volatile gsize font_manager_font_preview_tile_type_id__once = 0;
	if (g_once_init_enter (&font_manager_font_preview_tile_type_id__once)) {
		GType font_manager_font_preview_tile_type_id;
		font_manager_font_preview_tile_type_id = font_manager_font_preview_tile_get_type_once ();
		g_once_init_leave (&font_manager_font_preview_tile_type_id__once, font_manager_font_preview_tile_type_id);
	}
	return font_manager_font_preview_tile_type_id__once;
}

static void
_vala_font_manager_font_preview_tile_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	FontManagerFontPreviewTile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_FONT_PREVIEW_TILE, FontManagerFontPreviewTile);
	switch (property_id) {
		case FONT_MANAGER_FONT_PREVIEW_TILE_ITEM_PROPERTY:
		g_value_set_object (value, font_manager_font_preview_tile_get_item (self));
		break;
		case FONT_MANAGER_FONT_PREVIEW_TILE_SIZE_PROPERTY:
		g_value_set_enum (value, font_manager_font_preview_tile_get_size (self));
		break;
		case FONT_MANAGER_FONT_PREVIEW_TILE_ATTRS_PROPERTY:
		g_value_set_boxed (value, font_manager_font_preview_tile_get_attrs (self));
		break;
		case FONT_MANAGER_FONT_PREVIEW_TILE_PREVIEW_PROPERTY:
		g_value_set_object (value, font_manager_font_preview_tile_get_preview (self));
		break;
		case FONT_MANAGER_FONT_PREVIEW_TILE_PREVIEW_TEXT_PROPERTY:
		g_value_set_string (value, font_manager_font_preview_tile_get_preview_text (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_font_preview_tile_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	FontManagerFontPreviewTile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_FONT_PREVIEW_TILE, FontManagerFontPreviewTile);
	switch (property_id) {
		case FONT_MANAGER_FONT_PREVIEW_TILE_ITEM_PROPERTY:
		font_manager_font_preview_tile_set_item (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_FONT_PREVIEW_TILE_SIZE_PROPERTY:
		font_manager_font_preview_tile_set_size (self, g_value_get_enum (value));
		break;
		case FONT_MANAGER_FONT_PREVIEW_TILE_ATTRS_PROPERTY:
		font_manager_font_preview_tile_set_attrs (self, g_value_get_boxed (value));
		break;
		case FONT_MANAGER_FONT_PREVIEW_TILE_PREVIEW_PROPERTY:
		font_manager_font_preview_tile_set_preview (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_FONT_PREVIEW_TILE_PREVIEW_TEXT_PROPERTY:
		font_manager_font_preview_tile_set_preview_text (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
font_manager_font_grid_view_get_instance_private (FontManagerFontGridView* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerFontGridView_private_offset);
}

static void
__lambda138_ (FontManagerFontGridView* self)
{
	GtkListBase* _tmp0_;
	GtkListBase* _tmp1_;
	_tmp0_ = font_manager_font_list_base_get_list ((FontManagerFontListBase*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		font_manager_font_grid_view_create_gridview (self);
	}
	font_manager_font_list_base_queue_update ((FontManagerFontListBase*) self);
}

static void
___lambda138__gtk_widget_map (GtkWidget* _sender,
                              gpointer self)
{
	__lambda138_ ((FontManagerFontGridView*) self);
}

static void
__lambda140_ (FontManagerFontGridView* self)
{
	font_manager_font_list_base_queue_update ((FontManagerFontListBase*) self);
}

static void
___lambda140__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda140_ ((FontManagerFontGridView*) self);
}

static void
__lambda141_ (FontManagerFontGridView* self)
{
	font_manager_font_list_base_queue_update ((FontManagerFontListBase*) self);
}

static void
___lambda141__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda141_ ((FontManagerFontGridView*) self);
}

FontManagerFontGridView*
font_manager_font_grid_view_construct (GType object_type,
                                       GtkScrolledWindow* parent)
{
	FontManagerFontGridView * self = NULL;
	FontManagerFontModel* _tmp0_;
	FontManagerFontModel* _tmp1_;
	FontManagerBaseFontModel* _tmp2_;
	FontManagerBaseFontModel* _tmp3_;
	g_return_val_if_fail (parent != NULL, NULL);
	self = (FontManagerFontGridView*) font_manager_font_list_base_construct (object_type);
	self->priv->container = parent;
	_tmp0_ = font_manager_font_model_new ();
	_tmp1_ = _tmp0_;
	font_manager_font_list_base_set_model ((FontManagerFontListBase*) self, (FontManagerBaseFontModel*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	g_signal_connect_object ((GtkWidget*) parent, "map", (GCallback) ___lambda138__gtk_widget_map, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::size", (GCallback) ___lambda140__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::preview-text", (GCallback) ___lambda141__g_object_notify, self, G_CONNECT_AFTER);
	_tmp2_ = font_manager_font_list_base_get_model ((FontManagerFontListBase*) self);
	_tmp3_ = _tmp2_;
	g_object_bind_property_with_closures ((GObject*) self, "available-fonts", (GObject*) _tmp3_, "entries", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	return self;
}

FontManagerFontGridView*
font_manager_font_grid_view_new (GtkScrolledWindow* parent)
{
	return font_manager_font_grid_view_construct (FONT_MANAGER_TYPE_FONT_GRID_VIEW, parent);
}

void
font_manager_font_grid_view_set_search_entry (FontManagerFontGridView* self,
                                              GtkSearchEntry* entry)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	font_manager_font_list_base_set_search_entry ((FontManagerFontListBase*) self, entry);
	return;
}

static gboolean
___lambda139_ (FontManagerFontGridView* self)
{
	gboolean result;
	font_manager_font_list_base_select_item ((FontManagerFontListBase*) self, (guint) 0);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda139__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda139_ ((FontManagerFontGridView*) self);
	return result;
}

void
font_manager_font_grid_view_create_gridview (FontManagerFontGridView* self)
{
	GtkGridView* _tmp0_ = NULL;
	GtkGridView* _tmp1_;
	FontManagerBaseFontModel* _tmp2_;
	FontManagerBaseFontModel* _tmp3_;
	GListModel* _tmp4_;
	GtkSingleSelection* _tmp5_ = NULL;
	GtkSingleSelection* _tmp6_;
	GtkScrolledWindow* _tmp7_;
	GtkListBase* _tmp8_;
	GtkListBase* _tmp9_;
	GtkScrolledWindow* _tmp10_;
	FontManagerBaseFontModel* _tmp11_;
	FontManagerBaseFontModel* _tmp12_;
	guint _tmp13_;
	guint _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkGridView*) gtk_grid_view_new (NULL, NULL);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp0_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp0_, TRUE);
	gtk_grid_view_set_min_columns (_tmp0_, (guint) 2);
	gtk_grid_view_set_max_columns (_tmp0_, (guint) 36);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	font_manager_font_list_base_set_list ((FontManagerFontListBase*) self, (GtkListBase*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = font_manager_font_list_base_get_model ((FontManagerFontListBase*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 ((GListModel*) _tmp3_);
	_tmp5_ = gtk_single_selection_new (_tmp4_);
	gtk_single_selection_set_autoselect (_tmp5_, FALSE);
	_tmp6_ = _tmp5_;
	font_manager_font_list_base_set_selection ((FontManagerFontListBase*) self, (GtkSelectionModel*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->container;
	_tmp8_ = font_manager_font_list_base_get_list ((FontManagerFontListBase*) self);
	_tmp9_ = _tmp8_;
	gtk_scrolled_window_set_child (_tmp7_, (GtkWidget*) _tmp9_);
	_tmp10_ = self->priv->container;
	gtk_widget_set_visible ((GtkWidget*) _tmp10_, TRUE);
	_tmp11_ = font_manager_font_list_base_get_model ((FontManagerFontListBase*) self);
	_tmp12_ = _tmp11_;
	_tmp13_ = font_manager_base_font_model_get_n_items (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_ > ((guint) 0)) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda139__gsource_func, g_object_ref (self), g_object_unref);
	}
	return;
}

static void
font_manager_font_grid_view_real_setup_list_row (FontManagerFontListBase* base,
                                                 GtkSignalListItemFactory* factory,
                                                 GObject* item)
{
	FontManagerFontGridView * self;
	GtkListItem* list_item = NULL;
	GtkListItem* _tmp0_;
	FontManagerFontPreviewTile* child = NULL;
	FontManagerFontPreviewTile* _tmp1_;
	self = (FontManagerFontGridView*) base;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (item, gtk_list_item_get_type (), GtkListItem));
	list_item = _tmp0_;
	_tmp1_ = font_manager_font_preview_tile_new ();
	g_object_ref_sink (_tmp1_);
	child = _tmp1_;
	g_object_bind_property_with_closures ((GObject*) self, "size", (GObject*) child, "size", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_object_bind_property_with_closures ((GObject*) self, "preview-text", (GObject*) child, "preview-text", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	gtk_list_item_set_child (list_item, (GtkWidget*) child);
	_g_object_unref0 (child);
	_g_object_unref0 (list_item);
	return;
}

static void
font_manager_font_grid_view_real_bind_list_row (FontManagerFontListBase* base,
                                                GtkSignalListItemFactory* factory,
                                                GObject* item)
{
	FontManagerFontGridView * self;
	GtkListItem* list_item = NULL;
	GtkListItem* _tmp0_;
	FontManagerFontPreviewTile* row = NULL;
	GtkWidget* _tmp1_;
	FontManagerFontPreviewTile* _tmp2_;
	GObject* tmp = NULL;
	GObject* _tmp3_;
	GObject* _tmp4_;
	self = (FontManagerFontGridView*) base;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (item, gtk_list_item_get_type (), GtkListItem));
	list_item = _tmp0_;
	_tmp1_ = gtk_list_item_get_child (list_item);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, FONT_MANAGER_TYPE_FONT_PREVIEW_TILE, FontManagerFontPreviewTile));
	row = _tmp2_;
	_tmp3_ = gtk_list_item_get_item (list_item);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	tmp = _tmp4_;
	font_manager_font_preview_tile_set_item (row, tmp);
	_g_object_unref0 (tmp);
	_g_object_unref0 (row);
	_g_object_unref0 (list_item);
	return;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
font_manager_font_grid_view_real_on_selection_changed (FontManagerFontListBase* base,
                                                       guint position,
                                                       guint n_items)
{
	FontManagerFontGridView * self;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	GObject* item = NULL;
	FontManagerBaseFontModel* _tmp2_;
	FontManagerBaseFontModel* _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	GObject* _tmp6_;
	GPtrArray* _tmp7_;
	GPtrArray* _tmp8_;
	GObject* _tmp9_;
	self = (FontManagerFontGridView*) base;
	FONT_MANAGER_FONT_LIST_BASE_CLASS (font_manager_font_grid_view_parent_class)->on_selection_changed (G_TYPE_CHECK_INSTANCE_CAST (self, FONT_MANAGER_TYPE_FONT_LIST_BASE, FontManagerFontListBase), position, n_items);
	font_manager_font_list_base_set_selected_item ((FontManagerFontListBase*) self, NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_tmp1_ = _tmp0_;
	font_manager_font_list_base_set_selected_items ((FontManagerFontListBase*) self, _tmp1_);
	_g_ptr_array_unref0 (_tmp1_);
	_tmp2_ = font_manager_font_list_base_get_model ((FontManagerFontListBase*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = font_manager_font_list_base_get_current_selection ((FontManagerFontListBase*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_list_model_get_item ((GListModel*) _tmp3_, _tmp5_);
	item = _tmp6_;
	font_manager_font_list_base_set_selected_item ((FontManagerFontListBase*) self, item);
	_tmp7_ = font_manager_font_list_base_get_selected_items ((FontManagerFontListBase*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (item);
	g_ptr_array_add (_tmp8_, _tmp9_);
	g_signal_emit_by_name ((FontManagerFontListBase*) self, "selection-changed", item);
	_g_object_unref0 (item);
	return;
}

FontManagerPreviewTileSize
font_manager_font_grid_view_get_size (FontManagerFontGridView* self)
{
	FontManagerPreviewTileSize result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_size;
	return result;
}

void
font_manager_font_grid_view_set_size (FontManagerFontGridView* self,
                                      FontManagerPreviewTileSize value)
{
	FontManagerPreviewTileSize old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_font_grid_view_get_size (self);
	if (old_value != value) {
		self->priv->_size = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_font_grid_view_properties[FONT_MANAGER_FONT_GRID_VIEW_SIZE_PROPERTY]);
	}
}

const gchar*
font_manager_font_grid_view_get_preview_text (FontManagerFontGridView* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_preview_text;
	result = _tmp0_;
	return result;
}

void
font_manager_font_grid_view_set_preview_text (FontManagerFontGridView* self,
                                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_font_grid_view_get_preview_text (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_preview_text);
		self->priv->_preview_text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_font_grid_view_properties[FONT_MANAGER_FONT_GRID_VIEW_PREVIEW_TEXT_PROPERTY]);
	}
}

static void
font_manager_font_grid_view_class_init (FontManagerFontGridViewClass * klass,
                                        gpointer klass_data)
{
	font_manager_font_grid_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerFontGridView_private_offset);
	((FontManagerFontListBaseClass *) klass)->setup_list_row = (void (*) (FontManagerFontListBase*, GtkSignalListItemFactory*, GObject*)) font_manager_font_grid_view_real_setup_list_row;
	((FontManagerFontListBaseClass *) klass)->bind_list_row = (void (*) (FontManagerFontListBase*, GtkSignalListItemFactory*, GObject*)) font_manager_font_grid_view_real_bind_list_row;
	((FontManagerFontListBaseClass *) klass)->on_selection_changed = (void (*) (FontManagerFontListBase*, guint, guint)) font_manager_font_grid_view_real_on_selection_changed;
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_font_grid_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_font_grid_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_font_grid_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_FONT_GRID_VIEW_SIZE_PROPERTY, font_manager_font_grid_view_properties[FONT_MANAGER_FONT_GRID_VIEW_SIZE_PROPERTY] = g_param_spec_enum ("size", "size", "size", FONT_MANAGER_TYPE_PREVIEW_TILE_SIZE, FONT_MANAGER_PREVIEW_TILE_SIZE_LARGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_FONT_GRID_VIEW_PREVIEW_TEXT_PROPERTY, font_manager_font_grid_view_properties[FONT_MANAGER_FONT_GRID_VIEW_PREVIEW_TEXT_PROPERTY] = g_param_spec_string ("preview-text", "preview-text", "preview-text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
font_manager_font_grid_view_instance_init (FontManagerFontGridView * self,
                                           gpointer klass)
{
	self->priv = font_manager_font_grid_view_get_instance_private (self);
	self->priv->_size = FONT_MANAGER_PREVIEW_TILE_SIZE_LARGE;
	self->priv->_preview_text = NULL;
}

static void
font_manager_font_grid_view_finalize (GObject * obj)
{
	FontManagerFontGridView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_FONT_GRID_VIEW, FontManagerFontGridView);
	_g_free0 (self->priv->_preview_text);
	G_OBJECT_CLASS (font_manager_font_grid_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_font_grid_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerFontGridViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_font_grid_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerFontGridView), 0, (GInstanceInitFunc) font_manager_font_grid_view_instance_init, NULL };
	GType font_manager_font_grid_view_type_id;
	font_manager_font_grid_view_type_id = g_type_register_static (FONT_MANAGER_TYPE_FONT_LIST_BASE, "FontManagerFontGridView", &g_define_type_info, 0);
	FontManagerFontGridView_private_offset = g_type_add_instance_private (font_manager_font_grid_view_type_id, sizeof (FontManagerFontGridViewPrivate));
	return font_manager_font_grid_view_type_id;
}

GType
font_manager_font_grid_view_get_type (void)
{
	static volatile gsize font_manager_font_grid_view_type_id__once = 0;
	if (g_once_init_enter (&font_manager_font_grid_view_type_id__once)) {
		GType font_manager_font_grid_view_type_id;
		font_manager_font_grid_view_type_id = font_manager_font_grid_view_get_type_once ();
		g_once_init_leave (&font_manager_font_grid_view_type_id__once, font_manager_font_grid_view_type_id);
	}
	return font_manager_font_grid_view_type_id__once;
}

static void
_vala_font_manager_font_grid_view_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	FontManagerFontGridView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_FONT_GRID_VIEW, FontManagerFontGridView);
	switch (property_id) {
		case FONT_MANAGER_FONT_GRID_VIEW_SIZE_PROPERTY:
		g_value_set_enum (value, font_manager_font_grid_view_get_size (self));
		break;
		case FONT_MANAGER_FONT_GRID_VIEW_PREVIEW_TEXT_PROPERTY:
		g_value_set_string (value, font_manager_font_grid_view_get_preview_text (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_font_grid_view_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	FontManagerFontGridView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_FONT_GRID_VIEW, FontManagerFontGridView);
	switch (property_id) {
		case FONT_MANAGER_FONT_GRID_VIEW_SIZE_PROPERTY:
		font_manager_font_grid_view_set_size (self, g_value_get_enum (value));
		break;
		case FONT_MANAGER_FONT_GRID_VIEW_PREVIEW_TEXT_PROPERTY:
		font_manager_font_grid_view_set_preview_text (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

 G_GNUC_NO_INLINE static GType
font_manager_browse_preview_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{FONT_MANAGER_BROWSE_PREVIEW_MODE_WATERFALL, "FONT_MANAGER_BROWSE_PREVIEW_MODE_WATERFALL", "waterfall"}, {FONT_MANAGER_BROWSE_PREVIEW_MODE_LOREM_IPSUM, "FONT_MANAGER_BROWSE_PREVIEW_MODE_LOREM_IPSUM", "lorem-ipsum"}, {FONT_MANAGER_BROWSE_PREVIEW_MODE_CHARACTER_MAP, "FONT_MANAGER_BROWSE_PREVIEW_MODE_CHARACTER_MAP", "character-map"}, {0, NULL, NULL}};
	GType font_manager_browse_preview_mode_type_id;
	font_manager_browse_preview_mode_type_id = g_enum_register_static ("FontManagerBrowsePreviewMode", values);
	return font_manager_browse_preview_mode_type_id;
}

GType
font_manager_browse_preview_mode_get_type (void)
{
	static volatile gsize font_manager_browse_preview_mode_type_id__once = 0;
	if (g_once_init_enter (&font_manager_browse_preview_mode_type_id__once)) {
		GType font_manager_browse_preview_mode_type_id;
		font_manager_browse_preview_mode_type_id = font_manager_browse_preview_mode_get_type_once ();
		g_once_init_leave (&font_manager_browse_preview_mode_type_id__once, font_manager_browse_preview_mode_type_id);
	}
	return font_manager_browse_preview_mode_type_id__once;
}

static inline gpointer
font_manager_browse_preview_get_instance_private (FontManagerBrowsePreview* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerBrowsePreview_private_offset);
}

static gchar*
_variant_get1 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static void
font_manager_browse_preview_on_preview_mode_activated (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       FontManagerBrowsePreview* self)
{
	FontManagerPreviewPageMode mode = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	FontManagerPreviewPage* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (parameter != NULL);
	mode = FONT_MANAGER_PREVIEW_PAGE_MODE_WATERFALL;
	_tmp0_ = _variant_get1 (parameter);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strcmp0 (_tmp1_, "Waterfall") != 0;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		mode = FONT_MANAGER_PREVIEW_PAGE_MODE_LOREM_IPSUM;
	}
	_tmp3_ = self->priv->_preview_page;
	font_manager_preview_page_set_preview_mode (_tmp3_, mode);
	g_simple_action_set_state (action, parameter);
	return;
}

static void
font_manager_browse_preview_on_item_state_changed (FontManagerBrowsePreview* self)
{
	gboolean _tmp0_ = FALSE;
	FontManagerFamily* family = NULL;
	GObject* _tmp2_;
	FontManagerFamily* _tmp3_;
	FontManagerFamily* _tmp4_;
	GtkSwitch* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	FontManagerFamily* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	FontManagerReject* _tmp25_;
	g_return_if_fail (self != NULL);
	if (self->priv->ignore_activation) {
		_tmp0_ = TRUE;
	} else {
		GObject* _tmp1_;
		_tmp1_ = self->priv->_selected_item;
		_tmp0_ = _tmp1_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	_tmp2_ = self->priv->_selected_item;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, font_manager_family_get_type (), FontManagerFamily));
	family = _tmp3_;
	_tmp4_ = family;
	_tmp5_ = self->priv->font_state;
	_tmp6_ = gtk_switch_get_active (_tmp5_);
	_tmp7_ = _tmp6_;
	g_object_set (_tmp4_, "active", _tmp7_, NULL);
	_tmp8_ = family;
	g_object_get (_tmp8_, "active", &_tmp9_, NULL);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		FontManagerReject* _tmp11_;
		FontManagerFamily* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		GtkLabel* _tmp16_;
		GtkLabel* _tmp17_;
		_tmp11_ = self->priv->_disabled_families;
		_tmp12_ = family;
		g_object_get (_tmp12_, "family", &_tmp13_, NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_;
		font_manager_string_set_remove ((FontManagerStringSet*) _tmp11_, _tmp15_);
		_g_free0 (_tmp15_);
		_tmp16_ = self->priv->state_label;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp16_, TRUE);
		_tmp17_ = self->priv->state_label;
		gtk_label_set_label (_tmp17_, _ ("Active"));
	} else {
		FontManagerReject* _tmp18_;
		FontManagerFamily* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		GtkLabel* _tmp23_;
		GtkLabel* _tmp24_;
		_tmp18_ = self->priv->_disabled_families;
		_tmp19_ = family;
		g_object_get (_tmp19_, "family", &_tmp20_, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = _tmp21_;
		font_manager_string_set_add ((FontManagerStringSet*) _tmp18_, _tmp22_);
		_g_free0 (_tmp22_);
		_tmp23_ = self->priv->state_label;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp23_, FALSE);
		_tmp24_ = self->priv->state_label;
		gtk_label_set_label (_tmp24_, _ ("Inactive"));
	}
	_tmp25_ = self->priv->_disabled_families;
	font_manager_selections_save ((FontManagerSelections*) _tmp25_);
	_g_object_unref0 (family);
	return;
}

static void
font_manager_browse_preview_append_metadata (FontManagerBrowsePreview* self,
                                             GString* builder,
                                             const gchar* metadata)
{
	gchar* data = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	if (metadata == NULL) {
		return;
	}
	_tmp0_ = string_strip (metadata);
	data = _tmp0_;
	if (builder->len > ((gssize) 0)) {
		g_string_append (builder, "\n\n");
	}
	_tmp1_ = data;
	g_string_append (builder, _tmp1_);
	_g_free0 (data);
	return;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

void
font_manager_browse_preview_update_metadata (FontManagerBrowsePreview* self)
{
	gchar* copyright = NULL;
	gchar* designer = NULL;
	gchar* description = NULL;
	GtkLabel* _tmp28_;
	const gchar* _tmp29_;
	GtkLabel* _tmp30_;
	const gchar* _tmp31_;
	gchar* designed_by = NULL;
	gchar* _tmp32_;
	GString* builder = NULL;
	GString* _tmp33_;
	const gchar* _tmp34_;
	GString* _tmp42_;
	const gchar* _tmp43_;
	GString* _tmp44_;
	const gchar* _tmp45_;
	GtkLabel* _tmp46_;
	GString* _tmp47_;
	const gchar* _tmp48_;
	GtkLabel* _tmp49_;
	GString* _tmp50_;
	const gchar* _tmp51_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	copyright = NULL;
	designer = NULL;
	description = NULL;
	{
		gchar* family = NULL;
		GObject* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		FontManagerDatabase* db = NULL;
		FontManagerDatabase* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp0_ = self->priv->_selected_item;
		g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, font_manager_family_get_type (), FontManagerFamily), "family", &_tmp1_, NULL);
		_tmp2_ = _tmp1_;
		family = _tmp2_;
		_tmp3_ = font_manager_database_proxy_get_default_db ();
		db = _tmp3_;
		_tmp4_ = string_to_string (family);
		_tmp5_ = g_strconcat ("SELECT copyright, designer, description FROM Metadata WHERE family = '", _tmp4_, "'", NULL);
		_tmp6_ = _tmp5_;
		font_manager_database_execute_query (db, _tmp6_, &_inner_error0_);
		_g_free0 (_tmp6_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (db);
			_g_free0 (family);
			goto __catch0_g_error;
		}
		{
			FontManagerDatabaseIterator* _row_it = NULL;
			FontManagerDatabaseIterator* _tmp7_;
			_tmp7_ = font_manager_database_iterator (db);
			_row_it = _tmp7_;
			while (TRUE) {
				FontManagerDatabaseIterator* _tmp8_;
				sqlite3_stmt* row = NULL;
				FontManagerDatabaseIterator* _tmp9_;
				sqlite3_stmt* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp15_;
				const gchar* _tmp19_;
				gboolean _tmp23_ = FALSE;
				const gchar* _tmp24_;
				_tmp8_ = _row_it;
				if (!font_manager_database_iterator_next (_tmp8_)) {
					break;
				}
				_tmp9_ = _row_it;
				_tmp10_ = font_manager_database_iterator_get (_tmp9_);
				row = _tmp10_;
				_tmp11_ = copyright;
				if (_tmp11_ == NULL) {
					sqlite3_stmt* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp12_ = row;
					_tmp13_ = (const gchar*) sqlite3_column_text (_tmp12_, 0);
					_tmp14_ = g_strdup (_tmp13_);
					_g_free0 (copyright);
					copyright = _tmp14_;
				}
				_tmp15_ = designer;
				if (_tmp15_ == NULL) {
					sqlite3_stmt* _tmp16_;
					const gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp16_ = row;
					_tmp17_ = (const gchar*) sqlite3_column_text (_tmp16_, 1);
					_tmp18_ = g_strdup (_tmp17_);
					_g_free0 (designer);
					designer = _tmp18_;
				}
				_tmp19_ = description;
				if (_tmp19_ == NULL) {
					sqlite3_stmt* _tmp20_;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					_tmp20_ = row;
					_tmp21_ = (const gchar*) sqlite3_column_text (_tmp20_, 2);
					_tmp22_ = g_strdup (_tmp21_);
					_g_free0 (description);
					description = _tmp22_;
				}
				_tmp24_ = copyright;
				if (_tmp24_ != NULL) {
					const gchar* _tmp25_;
					_tmp25_ = designer;
					_tmp23_ = _tmp25_ != NULL;
				} else {
					_tmp23_ = FALSE;
				}
				if (_tmp23_) {
					break;
				}
			}
			_g_object_unref0 (_row_it);
		}
		font_manager_database_end_query (db);
		_g_object_unref0 (db);
		_g_free0 (family);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp26_;
		const gchar* _tmp27_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp26_ = e;
		_tmp27_ = _tmp26_->message;
		g_warning ("Browse.vala:422: %s", _tmp27_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (description);
		_g_free0 (designer);
		_g_free0 (copyright);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp28_ = self->priv->designer_label;
	_tmp29_ = designer;
	gtk_label_set_label (_tmp28_, _tmp29_);
	_tmp30_ = self->priv->designer_label;
	_tmp31_ = designer;
	gtk_widget_set_visible ((GtkWidget*) _tmp30_, _tmp31_ != NULL);
	_tmp32_ = g_strdup (_ ("Designed by"));
	designed_by = _tmp32_;
	_tmp33_ = g_string_new (NULL);
	builder = _tmp33_;
	_tmp34_ = designer;
	if (_tmp34_ != NULL) {
		GString* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		_tmp35_ = builder;
		_tmp36_ = designed_by;
		_tmp37_ = string_to_string (_tmp36_);
		_tmp38_ = designer;
		_tmp39_ = string_to_string (_tmp38_);
		_tmp40_ = g_strconcat (_tmp37_, " ", _tmp39_, NULL);
		_tmp41_ = _tmp40_;
		font_manager_browse_preview_append_metadata (self, _tmp35_, _tmp41_);
		_g_free0 (_tmp41_);
	}
	_tmp42_ = builder;
	_tmp43_ = copyright;
	font_manager_browse_preview_append_metadata (self, _tmp42_, _tmp43_);
	_tmp44_ = builder;
	_tmp45_ = description;
	font_manager_browse_preview_append_metadata (self, _tmp44_, _tmp45_);
	_tmp46_ = self->priv->family_label;
	_tmp47_ = builder;
	_tmp48_ = _tmp47_->str;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp46_, _tmp48_);
	_tmp49_ = self->priv->designer_label;
	_tmp50_ = builder;
	_tmp51_ = _tmp50_->str;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp49_, _tmp51_);
	_g_string_free0 (builder);
	_g_free0 (designed_by);
	_g_free0 (description);
	_g_free0 (designer);
	_g_free0 (copyright);
	return;
}

static void
font_manager_browse_preview_on_item_selected (FontManagerBrowsePreview* self)
{
	GObject* _tmp0_;
	FontManagerFamily* family = NULL;
	GObject* _tmp1_;
	FontManagerFamily* _tmp2_;
	gint default_index = 0;
	FontManagerFamily* _tmp3_;
	GtkLabel* _tmp4_;
	FontManagerFamily* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GListModel* child_model = NULL;
	FontManagerBaseFontModel* _tmp9_;
	GObject* _tmp10_;
	GListModel* _tmp11_;
	guint child_size = 0U;
	GListModel* _tmp12_;
	GtkDropDown* _tmp13_;
	GListModel* _tmp14_;
	GtkDropDown* _tmp15_;
	GtkDropDown* _tmp16_;
	gint _tmp17_ = 0;
	GtkDropDown* _tmp18_;
	GtkSwitch* _tmp19_;
	FontManagerFamily* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_selected_item;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_selected_item;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, font_manager_family_get_type (), FontManagerFamily));
	family = _tmp2_;
	_tmp3_ = family;
	default_index = font_manager_family_get_default_index (_tmp3_);
	_tmp4_ = self->priv->family_label;
	_tmp5_ = family;
	g_object_get (_tmp5_, "family", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	gtk_label_set_label (_tmp4_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = self->priv->_model;
	_tmp10_ = self->priv->_selected_item;
	_tmp11_ = font_manager_font_model_get_child_model (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, FONT_MANAGER_TYPE_FONT_MODEL, FontManagerFontModel), _tmp10_);
	child_model = _tmp11_;
	_tmp12_ = child_model;
	child_size = g_list_model_get_n_items (_tmp12_);
	_tmp13_ = self->priv->style_drop_down;
	_tmp14_ = child_model;
	gtk_drop_down_set_model (_tmp13_, _tmp14_);
	_tmp15_ = self->priv->style_drop_down;
	gtk_drop_down_set_show_arrow (_tmp15_, child_size > ((guint) 1));
	_tmp16_ = self->priv->style_drop_down;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp16_, child_size > ((guint) 1));
	if (((guint) default_index) < child_size) {
		_tmp17_ = default_index;
	} else {
		_tmp17_ = 0;
	}
	_tmp18_ = self->priv->style_drop_down;
	gtk_drop_down_set_selected (_tmp18_, (guint) _tmp17_);
	self->priv->ignore_activation = TRUE;
	_tmp19_ = self->priv->font_state;
	_tmp20_ = family;
	g_object_get (_tmp20_, "active", &_tmp21_, NULL);
	_tmp22_ = _tmp21_;
	gtk_switch_set_active (_tmp19_, _tmp22_);
	self->priv->ignore_activation = FALSE;
	font_manager_browse_preview_update_metadata (self);
	_g_object_unref0 (child_model);
	_g_object_unref0 (family);
	return;
}

static void
font_manager_browse_preview_on_variant_selected (FontManagerBrowsePreview* self)
{
	guint selected_variant = 0U;
	GtkDropDown* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	FontManagerFont* selected_font = NULL;
	GtkDropDown* _tmp3_;
	GListModel* _tmp4_;
	GObject* _tmp5_;
	PangoFontDescription* font_desc = NULL;
	FontManagerFont* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	PangoFontDescription* _tmp10_;
	PangoFontDescription* _tmp11_;
	PangoFontDescription* _tmp12_;
	FontManagerUnicodeCharacterMap* _tmp13_;
	PangoFontDescription* _tmp14_;
	FontManagerPreviewPage* _tmp15_;
	FontManagerFont* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->style_drop_down;
	_tmp1_ = gtk_drop_down_get_selected (_tmp0_);
	_tmp2_ = _tmp1_;
	selected_variant = _tmp2_;
	if (selected_variant == GTK_INVALID_LIST_POSITION) {
		return;
	}
	_tmp3_ = self->priv->style_drop_down;
	_tmp4_ = gtk_drop_down_get_model (_tmp3_);
	_tmp5_ = g_list_model_get_item (_tmp4_, selected_variant);
	selected_font = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, font_manager_font_get_type (), FontManagerFont);
	_tmp6_ = selected_font;
	g_object_get (_tmp6_, "description", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp10_ = pango_font_description_from_string (_tmp9_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	font_desc = _tmp11_;
	_tmp12_ = font_desc;
	pango_font_description_set_size (_tmp12_, 10 * PANGO_SCALE);
	_tmp13_ = self->priv->_character_map;
	_tmp14_ = font_desc;
	font_manager_unicode_character_map_set_font_desc (_tmp13_, _tmp14_);
	_tmp15_ = self->priv->_preview_page;
	_tmp16_ = selected_font;
	font_manager_preview_page_set_font (_tmp15_, _tmp16_);
	__vala_PangoFontDescription_free0 (font_desc);
	_g_object_unref0 (selected_font);
	return;
}

void
font_manager_browse_preview_setup_style_row (FontManagerBrowsePreview* self,
                                             GtkSignalListItemFactory* factory,
                                             GObject* item)
{
	GtkListItem* list_item = NULL;
	GtkListItem* _tmp0_;
	GtkLabel* child = NULL;
	GtkLabel* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (factory != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (item, gtk_list_item_get_type (), GtkListItem));
	list_item = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp1_);
	child = _tmp1_;
	gtk_widget_add_css_class ((GtkWidget*) child, "heading");
	gtk_list_item_set_child (list_item, (GtkWidget*) child);
	_g_object_unref0 (child);
	_g_object_unref0 (list_item);
	return;
}

void
font_manager_browse_preview_bind_style_row (FontManagerBrowsePreview* self,
                                            GtkSignalListItemFactory* factory,
                                            GObject* item)
{
	GtkListItem* list_item = NULL;
	GtkListItem* _tmp0_;
	GtkLabel* label = NULL;
	GtkWidget* _tmp1_;
	GtkLabel* _tmp2_;
	FontManagerFont* font = NULL;
	GObject* _tmp3_;
	FontManagerFont* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (factory != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (item, gtk_list_item_get_type (), GtkListItem));
	list_item = _tmp0_;
	_tmp1_ = gtk_list_item_get_child (list_item);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_label_get_type (), GtkLabel));
	label = _tmp2_;
	_tmp3_ = gtk_list_item_get_item (list_item);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, font_manager_font_get_type (), FontManagerFont));
	font = _tmp4_;
	g_return_if_fail (font != NULL);
	g_object_get (font, "style", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	gtk_label_set_label (label, _tmp7_);
	_g_free0 (_tmp7_);
	_g_object_unref0 (font);
	_g_object_unref0 (label);
	_g_object_unref0 (list_item);
	return;
}

static void
_font_manager_browse_preview_setup_style_row_gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                                 GObject* object,
                                                                                 gpointer self)
{
	font_manager_browse_preview_setup_style_row ((FontManagerBrowsePreview*) self, _sender, object);
}

static void
_font_manager_browse_preview_bind_style_row_gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                               GObject* object,
                                                                               gpointer self)
{
	font_manager_browse_preview_bind_style_row ((FontManagerBrowsePreview*) self, _sender, object);
}

static GtkSignalListItemFactory*
font_manager_browse_preview_get_style_factory (FontManagerBrowsePreview* self)
{
	GtkSignalListItemFactory* factory = NULL;
	GtkSignalListItemFactory* _tmp0_;
	GtkSignalListItemFactory* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
	factory = _tmp0_;
	g_signal_connect_object (factory, "setup", (GCallback) _font_manager_browse_preview_setup_style_row_gtk_signal_list_item_factory_setup, self, 0);
	g_signal_connect_object (factory, "bind", (GCallback) _font_manager_browse_preview_bind_style_row_gtk_signal_list_item_factory_bind, self, 0);
	result = factory;
	return result;
}

FontManagerBrowsePreview*
font_manager_browse_preview_construct (GType object_type)
{
	FontManagerBrowsePreview * self = NULL;
	self = (FontManagerBrowsePreview*) g_object_new (object_type, NULL);
	return self;
}

FontManagerBrowsePreview*
font_manager_browse_preview_new (void)
{
	return font_manager_browse_preview_construct (FONT_MANAGER_TYPE_BROWSE_PREVIEW);
}

FontManagerReject*
font_manager_browse_preview_get_disabled_families (FontManagerBrowsePreview* self)
{
	FontManagerReject* result;
	FontManagerReject* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_disabled_families;
	result = _tmp0_;
	return result;
}

void
font_manager_browse_preview_set_disabled_families (FontManagerBrowsePreview* self,
                                                   FontManagerReject* value)
{
	FontManagerReject* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_browse_preview_get_disabled_families (self);
	if (old_value != value) {
		FontManagerReject* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_disabled_families);
		self->priv->_disabled_families = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_browse_preview_properties[FONT_MANAGER_BROWSE_PREVIEW_DISABLED_FAMILIES_PROPERTY]);
	}
}

GObject*
font_manager_browse_preview_get_selected_item (FontManagerBrowsePreview* self)
{
	GObject* result;
	GObject* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selected_item;
	result = _tmp0_;
	return result;
}

void
font_manager_browse_preview_set_selected_item (FontManagerBrowsePreview* self,
                                               GObject* value)
{
	GObject* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_browse_preview_get_selected_item (self);
	if (old_value != value) {
		GObject* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_selected_item);
		self->priv->_selected_item = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_browse_preview_properties[FONT_MANAGER_BROWSE_PREVIEW_SELECTED_ITEM_PROPERTY]);
	}
}

FontManagerBaseFontModel*
font_manager_browse_preview_get_model (FontManagerBrowsePreview* self)
{
	FontManagerBaseFontModel* result;
	FontManagerBaseFontModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_model;
	result = _tmp0_;
	return result;
}

void
font_manager_browse_preview_set_model (FontManagerBrowsePreview* self,
                                       FontManagerBaseFontModel* value)
{
	FontManagerBaseFontModel* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_browse_preview_get_model (self);
	if (old_value != value) {
		FontManagerBaseFontModel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_model);
		self->priv->_model = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_browse_preview_properties[FONT_MANAGER_BROWSE_PREVIEW_MODEL_PROPERTY]);
	}
}

FontManagerPreviewPage*
font_manager_browse_preview_get_preview_page (FontManagerBrowsePreview* self)
{
	FontManagerPreviewPage* result;
	FontManagerPreviewPage* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_preview_page;
	result = _tmp0_;
	return result;
}

void
font_manager_browse_preview_set_preview_page (FontManagerBrowsePreview* self,
                                              FontManagerPreviewPage* value)
{
	FontManagerPreviewPage* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_browse_preview_get_preview_page (self);
	if (old_value != value) {
		FontManagerPreviewPage* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_preview_page);
		self->priv->_preview_page = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_browse_preview_properties[FONT_MANAGER_BROWSE_PREVIEW_PREVIEW_PAGE_PROPERTY]);
	}
}

FontManagerUnicodeCharacterMap*
font_manager_browse_preview_get_character_map (FontManagerBrowsePreview* self)
{
	FontManagerUnicodeCharacterMap* result;
	FontManagerUnicodeCharacterMap* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_character_map;
	result = _tmp0_;
	return result;
}

void
font_manager_browse_preview_set_character_map (FontManagerBrowsePreview* self,
                                               FontManagerUnicodeCharacterMap* value)
{
	FontManagerUnicodeCharacterMap* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_browse_preview_get_character_map (self);
	if (old_value != value) {
		FontManagerUnicodeCharacterMap* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_character_map);
		self->priv->_character_map = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_browse_preview_properties[FONT_MANAGER_BROWSE_PREVIEW_CHARACTER_MAP_PROPERTY]);
	}
}

FontManagerWaterfallSettings*
font_manager_browse_preview_get_waterfall_settings (FontManagerBrowsePreview* self)
{
	FontManagerWaterfallSettings* result;
	FontManagerWaterfallSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_waterfall_settings;
	result = _tmp0_;
	return result;
}

void
font_manager_browse_preview_set_waterfall_settings (FontManagerBrowsePreview* self,
                                                    FontManagerWaterfallSettings* value)
{
	FontManagerWaterfallSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_browse_preview_get_waterfall_settings (self);
	if (old_value != value) {
		FontManagerWaterfallSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_waterfall_settings);
		self->priv->_waterfall_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_browse_preview_properties[FONT_MANAGER_BROWSE_PREVIEW_WATERFALL_SETTINGS_PROPERTY]);
	}
}

gint
font_manager_browse_preview_get_predefined_size (FontManagerBrowsePreview* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_predefined_size;
	return result;
}

void
font_manager_browse_preview_set_predefined_size (FontManagerBrowsePreview* self,
                                                 gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_browse_preview_get_predefined_size (self);
	if (old_value != value) {
		self->priv->_predefined_size = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_browse_preview_properties[FONT_MANAGER_BROWSE_PREVIEW_PREDEFINED_SIZE_PROPERTY]);
	}
}

FontManagerBrowsePreviewMode
font_manager_browse_preview_get_mode (FontManagerBrowsePreview* self)
{
	FontManagerBrowsePreviewMode result;
	GtkWidget* visible_child = NULL;
	GtkStack* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	GtkScrolledWindow* _tmp5_;
	FontManagerPreviewPage* _tmp6_;
	FontManagerPreviewPageMode _tmp7_;
	FontManagerPreviewPageMode _tmp8_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->preview_stack;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	visible_child = _tmp3_;
	_tmp4_ = visible_child;
	_tmp5_ = self->priv->character_map_scroll;
	if (_tmp4_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget)) {
		result = FONT_MANAGER_BROWSE_PREVIEW_MODE_CHARACTER_MAP;
		_g_object_unref0 (visible_child);
		return result;
	}
	_tmp6_ = self->priv->_preview_page;
	_tmp7_ = font_manager_preview_page_get_preview_mode (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == FONT_MANAGER_PREVIEW_PAGE_MODE_WATERFALL) {
		result = FONT_MANAGER_BROWSE_PREVIEW_MODE_WATERFALL;
		_g_object_unref0 (visible_child);
		return result;
	}
	result = FONT_MANAGER_BROWSE_PREVIEW_MODE_LOREM_IPSUM;
	_g_object_unref0 (visible_child);
	return result;
}

static void
_font_manager_browse_preview___lambda129_ (FontManagerBrowsePreview* self)
{
	font_manager_browse_preview_on_item_state_changed (self);
}

static void
__font_manager_browse_preview___lambda129__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	_font_manager_browse_preview___lambda129_ ((FontManagerBrowsePreview*) self);
}

static void
_font_manager_browse_preview___lambda130_ (FontManagerBrowsePreview* self)
{
	font_manager_browse_preview_on_item_selected (self);
}

static void
__font_manager_browse_preview___lambda130__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	_font_manager_browse_preview___lambda130_ ((FontManagerBrowsePreview*) self);
}

static void
_font_manager_browse_preview___lambda131_ (FontManagerBrowsePreview* self)
{
	font_manager_browse_preview_on_variant_selected (self);
}

static void
__font_manager_browse_preview___lambda131__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	_font_manager_browse_preview___lambda131_ ((FontManagerBrowsePreview*) self);
}

static void
_font_manager_browse_preview___lambda132_ (FontManagerBrowsePreview* self,
                                           const gchar* codepoint,
                                           const gchar* name,
                                           const gchar* n_codepoints)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (codepoint != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (n_codepoints != NULL);
	_tmp0_ = self->priv->n_glyphs;
	gtk_label_set_label (_tmp0_, n_codepoints);
}

static void
__font_manager_browse_preview___lambda132__font_manager_unicode_character_map_selection_changed (FontManagerUnicodeCharacterMap* _sender,
                                                                                                 const gchar* codepoint,
                                                                                                 const gchar* codepoint_name,
                                                                                                 const gchar* n_codepoints,
                                                                                                 gpointer self)
{
	_font_manager_browse_preview___lambda132_ ((FontManagerBrowsePreview*) self, codepoint, codepoint_name, n_codepoints);
}

static void
___lambda134_ (FontManagerBrowsePreview* self)
{
	font_manager_browse_preview_on_item_selected (self);
}

static void
____lambda134__font_manager_string_set_changed (FontManagerStringSet* _sender,
                                                gpointer self)
{
	___lambda134_ ((FontManagerBrowsePreview*) self);
}

static void
_font_manager_browse_preview___lambda133_ (FontManagerBrowsePreview* self)
{
	GtkSwitch* _tmp0_;
	FontManagerReject* _tmp1_;
	FontManagerReject* _tmp2_;
	_tmp0_ = self->priv->font_state;
	_tmp1_ = self->priv->_disabled_families;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp1_ != NULL);
	_tmp2_ = self->priv->_disabled_families;
	if (_tmp2_ != NULL) {
		FontManagerReject* _tmp3_;
		_tmp3_ = self->priv->_disabled_families;
		g_signal_connect_object ((FontManagerStringSet*) _tmp3_, "changed", (GCallback) ____lambda134__font_manager_string_set_changed, self, 0);
	}
}

static void
__font_manager_browse_preview___lambda133__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	_font_manager_browse_preview___lambda133_ ((FontManagerBrowsePreview*) self);
}

static void
_font_manager_browse_preview___lambda135_ (FontManagerBrowsePreview* self)
{
	GtkWidget* visible_child = NULL;
	GtkStack* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	GtkMenuButton* _tmp5_;
	GtkWidget* _tmp6_;
	GtkScrolledWindow* _tmp7_;
	gdouble _tmp8_ = 0.0;
	GtkWidget* _tmp9_;
	GtkScrolledWindow* _tmp10_;
	GtkLabel* _tmp11_;
	_tmp0_ = self->priv->preview_stack;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	visible_child = _tmp3_;
	_tmp4_ = visible_child;
	gtk_widget_grab_focus (_tmp4_);
	_tmp5_ = self->priv->preview_menu;
	_tmp6_ = visible_child;
	_tmp7_ = self->priv->preview_scroll;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, _tmp6_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	_tmp9_ = visible_child;
	_tmp10_ = self->priv->character_map_scroll;
	if (_tmp9_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget)) {
		_tmp8_ = 1.0;
	} else {
		_tmp8_ = 0.333;
	}
	_tmp11_ = self->priv->n_glyphs;
	gtk_widget_set_opacity ((GtkWidget*) _tmp11_, _tmp8_);
	_g_object_unref0 (visible_child);
}

static void
__font_manager_browse_preview___lambda135__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	_font_manager_browse_preview___lambda135_ ((FontManagerBrowsePreview*) self);
}

static void
_font_manager_browse_preview___lambda136_ (FontManagerBrowsePreview* self)
{
	GBindingFlags _flags = 0U;
	FontManagerWaterfallSettings* _tmp0_;
	_flags = G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE;
	_tmp0_ = self->priv->_waterfall_settings;
	g_object_bind_property_with_closures ((GObject*) _tmp0_, "predefined-size", (GObject*) self, "predefined-size", _flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
}

static void
__font_manager_browse_preview___lambda136__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	_font_manager_browse_preview___lambda136_ ((FontManagerBrowsePreview*) self);
}

static void
_font_manager_browse_preview___lambda137_ (FontManagerBrowsePreview* self)
{
	FontManagerWaterfallSettings* _tmp0_;
	FontManagerPreviewPage* _tmp1_;
	FontManagerWaterfallSettings* _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	FontManagerWaterfallSettings* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	FontManagerWaterfallSettings* _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	_tmp0_ = self->priv->_waterfall_settings;
	font_manager_waterfall_settings_on_selection_changed (_tmp0_);
	_tmp1_ = self->priv->_preview_page;
	_tmp2_ = self->priv->_waterfall_settings;
	_tmp3_ = font_manager_waterfall_settings_get_minimum (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->_waterfall_settings;
	_tmp6_ = font_manager_waterfall_settings_get_maximum (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->_waterfall_settings;
	_tmp9_ = font_manager_waterfall_settings_get_ratio (_tmp8_);
	_tmp10_ = _tmp9_;
	font_manager_preview_page_set_waterfall_size (_tmp1_, _tmp4_, _tmp7_, _tmp10_);
}

static void
__font_manager_browse_preview___lambda137__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	_font_manager_browse_preview___lambda137_ ((FontManagerBrowsePreview*) self);
}

static GObject *
font_manager_browse_preview_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FontManagerBrowsePreview * self;
	GtkDropDown* _tmp0_;
	GtkSignalListItemFactory* _tmp1_;
	GtkSignalListItemFactory* _tmp2_;
	GtkWidget* button = NULL;
	GtkDropDown* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	GtkLabel* _tmp8_;
	FontManagerUnicodeCharacterMap* _tmp9_ = NULL;
	FontManagerUnicodeCharacterMap* _tmp10_;
	FontManagerUnicodeCharacterMap* _tmp11_;
	FontManagerUnicodeCharacterMap* _tmp12_;
	GtkLabel* _tmp13_;
	GtkScrolledWindow* _tmp14_;
	FontManagerUnicodeCharacterMap* _tmp15_;
	GtkStack* _tmp16_;
	FontManagerPreviewPage* _tmp17_ = NULL;
	FontManagerPreviewPage* _tmp18_;
	FontManagerPreviewPage* _tmp19_;
	FontManagerPreviewPage* _tmp20_;
	FontManagerPreviewPage* _tmp21_;
	GtkWidget* _tmp22_;
	FontManagerPreviewPage* _tmp23_;
	GtkScrolledWindow* _tmp24_;
	FontManagerPreviewPage* _tmp25_;
	GtkMenuButton* _tmp26_;
	GtkMenuButton* _tmp27_;
	GMenuModel* _tmp28_;
	GMenuModel* _tmp29_;
	GtkWidget* toggle = NULL;
	GtkMenuButton* _tmp30_;
	GtkWidget* _tmp31_;
	GtkWidget* _tmp32_;
	GtkWidget* _tmp33_;
	GtkWidget* _tmp34_;
	GtkWidget* _tmp35_;
	GtkWidget* scroll = NULL;
	FontManagerPreviewPage* _tmp36_;
	GtkWidget* _tmp37_;
	GtkWidget* _tmp38_;
	GtkWidget* _tmp39_;
	GtkWidget* _tmp40_;
	GtkSwitch* _tmp42_;
	GtkDropDown* _tmp43_;
	FontManagerUnicodeCharacterMap* _tmp44_;
	GtkStack* _tmp45_;
	parent_class = G_OBJECT_CLASS (font_manager_browse_preview_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_BROWSE_PREVIEW, FontManagerBrowsePreview);
	font_manager_widget_set_name ((GtkWidget*) self, "FontManagerBrowsePreview");
	_tmp0_ = self->priv->style_drop_down;
	_tmp1_ = font_manager_browse_preview_get_style_factory (self);
	_tmp2_ = _tmp1_;
	gtk_drop_down_set_factory (_tmp0_, (GtkListItemFactory*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->style_drop_down;
	_tmp4_ = gtk_widget_get_first_child ((GtkWidget*) _tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	button = _tmp5_;
	_tmp6_ = button;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_toggle_button_get_type ())) {
		GtkWidget* _tmp7_;
		_tmp7_ = button;
		gtk_button_set_has_frame ((GtkButton*) _tmp7_, FALSE);
	}
	_tmp8_ = self->priv->n_glyphs;
	gtk_widget_set_opacity ((GtkWidget*) _tmp8_, 0.5);
	_tmp9_ = (FontManagerUnicodeCharacterMap*) font_manager_unicode_character_map_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp9_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp9_, TRUE);
	g_object_ref_sink (_tmp9_);
	_tmp10_ = _tmp9_;
	font_manager_browse_preview_set_character_map (self, _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = self->priv->_character_map;
	font_manager_widget_set_margin ((GtkWidget*) _tmp11_, 0);
	_tmp12_ = self->priv->_character_map;
	gtk_widget_add_css_class ((GtkWidget*) _tmp12_, "BrowsePaneCharacterMap");
	_tmp13_ = self->priv->n_glyphs;
	font_manager_widget_set_name ((GtkWidget*) _tmp13_, "CharacterMapCount");
	_tmp14_ = self->priv->character_map_scroll;
	_tmp15_ = self->priv->_character_map;
	gtk_scrolled_window_set_child (_tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = self->priv->preview_stack;
	gtk_stack_set_transition_type (_tmp16_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
	_tmp17_ = (FontManagerPreviewPage*) font_manager_preview_page_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp17_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp17_, TRUE);
	g_object_set (_tmp17_, "show-line-size", FALSE, NULL);
	g_object_ref_sink (_tmp17_);
	_tmp18_ = _tmp17_;
	font_manager_browse_preview_set_preview_page (self, _tmp18_);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = self->priv->_preview_page;
	font_manager_widget_set_margin ((GtkWidget*) _tmp19_, 0);
	_tmp20_ = self->priv->_preview_page;
	font_manager_preview_page_set_waterfall_size (_tmp20_, (gdouble) -1, (gdouble) 36, (gdouble) -1);
	_tmp21_ = self->priv->_preview_page;
	_tmp22_ = gtk_widget_get_last_child ((GtkWidget*) _tmp21_);
	gtk_widget_set_visible (_tmp22_, FALSE);
	_tmp23_ = self->priv->_preview_page;
	font_manager_preview_page_set_preview_size (_tmp23_, FONT_MANAGER_DEFAULT_PREVIEW_SIZE + 2.0);
	_tmp24_ = self->priv->preview_scroll;
	_tmp25_ = self->priv->_preview_page;
	gtk_scrolled_window_set_child (_tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = self->priv->preview_menu;
	font_manager_set_preview_page_mode_menu_and_actions ((GtkWidget*) self, (GtkWidget*) _tmp26_, (GCallback) font_manager_browse_preview_on_preview_mode_activated);
	_tmp27_ = self->priv->preview_menu;
	_tmp28_ = gtk_menu_button_get_menu_model (_tmp27_);
	_tmp29_ = _tmp28_;
	g_menu_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, g_menu_get_type (), GMenu), 0);
	_tmp30_ = self->priv->preview_menu;
	_tmp31_ = gtk_widget_get_first_child ((GtkWidget*) _tmp30_);
	_tmp32_ = _g_object_ref0 (_tmp31_);
	toggle = _tmp32_;
	_tmp33_ = toggle;
	gtk_widget_remove_css_class (_tmp33_, "toggle");
	_tmp34_ = toggle;
	gtk_widget_add_css_class (_tmp34_, "flat");
	_tmp35_ = toggle;
	gtk_widget_add_css_class (_tmp35_, "view");
	_tmp36_ = self->priv->_preview_page;
	_tmp37_ = gtk_widget_get_first_child ((GtkWidget*) _tmp36_);
	_tmp38_ = gtk_widget_get_next_sibling (_tmp37_);
	_tmp39_ = _g_object_ref0 (_tmp38_);
	scroll = _tmp39_;
	_tmp40_ = scroll;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, gtk_scrolled_window_get_type ())) {
		GtkWidget* _tmp41_;
		_tmp41_ = scroll;
		gtk_scrolled_window_set_policy (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, gtk_scrolled_window_get_type (), GtkScrolledWindow), GTK_POLICY_NEVER, GTK_POLICY_NEVER);
	}
	_tmp42_ = self->priv->font_state;
	g_signal_connect_object ((GObject*) _tmp42_, "notify::active", (GCallback) __font_manager_browse_preview___lambda129__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::selected-item", (GCallback) __font_manager_browse_preview___lambda130__g_object_notify, self, 0);
	_tmp43_ = self->priv->style_drop_down;
	g_signal_connect_object ((GObject*) _tmp43_, "notify::selected", (GCallback) __font_manager_browse_preview___lambda131__g_object_notify, self, 0);
	_tmp44_ = self->priv->_character_map;
	g_signal_connect_object (_tmp44_, "selection-changed", (GCallback) __font_manager_browse_preview___lambda132__font_manager_unicode_character_map_selection_changed, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::disabled-families", (GCallback) __font_manager_browse_preview___lambda133__g_object_notify, self, 0);
	_tmp45_ = self->priv->preview_stack;
	g_signal_connect_object ((GObject*) _tmp45_, "notify::visible-child", (GCallback) __font_manager_browse_preview___lambda135__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::waterfall-settings", (GCallback) __font_manager_browse_preview___lambda136__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::predefined-size", (GCallback) __font_manager_browse_preview___lambda137__g_object_notify, self, G_CONNECT_AFTER);
	_g_object_unref0 (scroll);
	_g_object_unref0 (toggle);
	_g_object_unref0 (button);
	return obj;
}

static void
font_manager_browse_preview_class_init (FontManagerBrowsePreviewClass * klass,
                                        gpointer klass_data)
{
	font_manager_browse_preview_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerBrowsePreview_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_browse_preview_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_browse_preview_set_property;
	G_OBJECT_CLASS (klass)->constructor = font_manager_browse_preview_constructor;
	G_OBJECT_CLASS (klass)->finalize = font_manager_browse_preview_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BROWSE_PREVIEW_DISABLED_FAMILIES_PROPERTY, font_manager_browse_preview_properties[FONT_MANAGER_BROWSE_PREVIEW_DISABLED_FAMILIES_PROPERTY] = g_param_spec_object ("disabled-families", "disabled-families", "disabled-families", font_manager_reject_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BROWSE_PREVIEW_SELECTED_ITEM_PROPERTY, font_manager_browse_preview_properties[FONT_MANAGER_BROWSE_PREVIEW_SELECTED_ITEM_PROPERTY] = g_param_spec_object ("selected-item", "selected-item", "selected-item", G_TYPE_OBJECT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BROWSE_PREVIEW_MODEL_PROPERTY, font_manager_browse_preview_properties[FONT_MANAGER_BROWSE_PREVIEW_MODEL_PROPERTY] = g_param_spec_object ("model", "model", "model", FONT_MANAGER_TYPE_BASE_FONT_MODEL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BROWSE_PREVIEW_PREVIEW_PAGE_PROPERTY, font_manager_browse_preview_properties[FONT_MANAGER_BROWSE_PREVIEW_PREVIEW_PAGE_PROPERTY] = g_param_spec_object ("preview-page", "preview-page", "preview-page", font_manager_preview_page_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BROWSE_PREVIEW_CHARACTER_MAP_PROPERTY, font_manager_browse_preview_properties[FONT_MANAGER_BROWSE_PREVIEW_CHARACTER_MAP_PROPERTY] = g_param_spec_object ("character-map", "character-map", "character-map", font_manager_unicode_character_map_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BROWSE_PREVIEW_WATERFALL_SETTINGS_PROPERTY, font_manager_browse_preview_properties[FONT_MANAGER_BROWSE_PREVIEW_WATERFALL_SETTINGS_PROPERTY] = g_param_spec_object ("waterfall-settings", "waterfall-settings", "waterfall-settings", FONT_MANAGER_TYPE_WATERFALL_SETTINGS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BROWSE_PREVIEW_PREDEFINED_SIZE_PROPERTY, font_manager_browse_preview_properties[FONT_MANAGER_BROWSE_PREVIEW_PREDEFINED_SIZE_PROPERTY] = g_param_spec_int ("predefined-size", "predefined-size", "predefined-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BROWSE_PREVIEW_MODE_PROPERTY, font_manager_browse_preview_properties[FONT_MANAGER_BROWSE_PREVIEW_MODE_PROPERTY] = g_param_spec_enum ("mode", "mode", "mode", FONT_MANAGER_TYPE_BROWSE_PREVIEW_MODE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/github/FontManager/FontManager/ui/font-manager-browse-preview.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "family_label", FALSE, FontManagerBrowsePreview_private_offset + G_STRUCT_OFFSET (FontManagerBrowsePreviewPrivate, family_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "state_label", FALSE, FontManagerBrowsePreview_private_offset + G_STRUCT_OFFSET (FontManagerBrowsePreviewPrivate, state_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "designer_label", FALSE, FontManagerBrowsePreview_private_offset + G_STRUCT_OFFSET (FontManagerBrowsePreviewPrivate, designer_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "n_glyphs", FALSE, FontManagerBrowsePreview_private_offset + G_STRUCT_OFFSET (FontManagerBrowsePreviewPrivate, n_glyphs));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "style_drop_down", FALSE, FontManagerBrowsePreview_private_offset + G_STRUCT_OFFSET (FontManagerBrowsePreviewPrivate, style_drop_down));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "character_map_scroll", FALSE, FontManagerBrowsePreview_private_offset + G_STRUCT_OFFSET (FontManagerBrowsePreviewPrivate, character_map_scroll));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "preview_scroll", FALSE, FontManagerBrowsePreview_private_offset + G_STRUCT_OFFSET (FontManagerBrowsePreviewPrivate, preview_scroll));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "preview_stack", FALSE, FontManagerBrowsePreview_private_offset + G_STRUCT_OFFSET (FontManagerBrowsePreviewPrivate, preview_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "preview_menu", FALSE, FontManagerBrowsePreview_private_offset + G_STRUCT_OFFSET (FontManagerBrowsePreviewPrivate, preview_menu));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "font_state", FALSE, FontManagerBrowsePreview_private_offset + G_STRUCT_OFFSET (FontManagerBrowsePreviewPrivate, font_state));
}

static void
font_manager_browse_preview_instance_init (FontManagerBrowsePreview * self,
                                           gpointer klass)
{
	self->priv = font_manager_browse_preview_get_instance_private (self);
	self->priv->_disabled_families = NULL;
	self->priv->_selected_item = NULL;
	self->priv->_model = NULL;
	self->priv->_preview_page = NULL;
	self->priv->_character_map = NULL;
	self->priv->ignore_activation = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
font_manager_browse_preview_finalize (GObject * obj)
{
	FontManagerBrowsePreview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_BROWSE_PREVIEW, FontManagerBrowsePreview);
	_g_object_unref0 (self->priv->_disabled_families);
	_g_object_unref0 (self->priv->_selected_item);
	_g_object_unref0 (self->priv->_model);
	_g_object_unref0 (self->priv->_preview_page);
	_g_object_unref0 (self->priv->_character_map);
	_g_object_unref0 (self->priv->_waterfall_settings);
	G_OBJECT_CLASS (font_manager_browse_preview_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_browse_preview_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerBrowsePreviewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_browse_preview_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerBrowsePreview), 0, (GInstanceInitFunc) font_manager_browse_preview_instance_init, NULL };
	GType font_manager_browse_preview_type_id;
	font_manager_browse_preview_type_id = g_type_register_static (gtk_box_get_type (), "FontManagerBrowsePreview", &g_define_type_info, 0);
	FontManagerBrowsePreview_private_offset = g_type_add_instance_private (font_manager_browse_preview_type_id, sizeof (FontManagerBrowsePreviewPrivate));
	return font_manager_browse_preview_type_id;
}

GType
font_manager_browse_preview_get_type (void)
{
	static volatile gsize font_manager_browse_preview_type_id__once = 0;
	if (g_once_init_enter (&font_manager_browse_preview_type_id__once)) {
		GType font_manager_browse_preview_type_id;
		font_manager_browse_preview_type_id = font_manager_browse_preview_get_type_once ();
		g_once_init_leave (&font_manager_browse_preview_type_id__once, font_manager_browse_preview_type_id);
	}
	return font_manager_browse_preview_type_id__once;
}

static void
_vala_font_manager_browse_preview_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	FontManagerBrowsePreview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_BROWSE_PREVIEW, FontManagerBrowsePreview);
	switch (property_id) {
		case FONT_MANAGER_BROWSE_PREVIEW_DISABLED_FAMILIES_PROPERTY:
		g_value_set_object (value, font_manager_browse_preview_get_disabled_families (self));
		break;
		case FONT_MANAGER_BROWSE_PREVIEW_SELECTED_ITEM_PROPERTY:
		g_value_set_object (value, font_manager_browse_preview_get_selected_item (self));
		break;
		case FONT_MANAGER_BROWSE_PREVIEW_MODEL_PROPERTY:
		g_value_set_object (value, font_manager_browse_preview_get_model (self));
		break;
		case FONT_MANAGER_BROWSE_PREVIEW_PREVIEW_PAGE_PROPERTY:
		g_value_set_object (value, font_manager_browse_preview_get_preview_page (self));
		break;
		case FONT_MANAGER_BROWSE_PREVIEW_CHARACTER_MAP_PROPERTY:
		g_value_set_object (value, font_manager_browse_preview_get_character_map (self));
		break;
		case FONT_MANAGER_BROWSE_PREVIEW_WATERFALL_SETTINGS_PROPERTY:
		g_value_set_object (value, font_manager_browse_preview_get_waterfall_settings (self));
		break;
		case FONT_MANAGER_BROWSE_PREVIEW_PREDEFINED_SIZE_PROPERTY:
		g_value_set_int (value, font_manager_browse_preview_get_predefined_size (self));
		break;
		case FONT_MANAGER_BROWSE_PREVIEW_MODE_PROPERTY:
		g_value_set_enum (value, font_manager_browse_preview_get_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_browse_preview_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	FontManagerBrowsePreview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_BROWSE_PREVIEW, FontManagerBrowsePreview);
	switch (property_id) {
		case FONT_MANAGER_BROWSE_PREVIEW_DISABLED_FAMILIES_PROPERTY:
		font_manager_browse_preview_set_disabled_families (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_BROWSE_PREVIEW_SELECTED_ITEM_PROPERTY:
		font_manager_browse_preview_set_selected_item (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_BROWSE_PREVIEW_MODEL_PROPERTY:
		font_manager_browse_preview_set_model (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_BROWSE_PREVIEW_PREVIEW_PAGE_PROPERTY:
		font_manager_browse_preview_set_preview_page (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_BROWSE_PREVIEW_CHARACTER_MAP_PROPERTY:
		font_manager_browse_preview_set_character_map (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_BROWSE_PREVIEW_WATERFALL_SETTINGS_PROPERTY:
		font_manager_browse_preview_set_waterfall_settings (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_BROWSE_PREVIEW_PREDEFINED_SIZE_PROPERTY:
		font_manager_browse_preview_set_predefined_size (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
font_manager_browse_pane_get_instance_private (FontManagerBrowsePane* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerBrowsePane_private_offset);
}

static void
__lambda144_ (FontManagerBrowsePane* self)
{
	GtkAdjustment* _tmp0_;
	FontManagerPreviewTileSize _tmp1_;
	_tmp0_ = self->priv->icon_size_adjustment;
	_tmp1_ = self->priv->_size;
	gtk_adjustment_set_value (_tmp0_, font_manager_preview_tile_size_to_double (_tmp1_));
}

static void
___lambda144__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda144_ ((FontManagerBrowsePane*) self);
}

static void
__lambda145_ (FontManagerBrowsePane* self)
{
	GtkToggleButton* _tmp0_;
	GtkToggleButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	_tmp0_ = self->priv->panel_toggle;
	_tmp1_ = self->priv->panel_toggle;
	_tmp2_ = gtk_toggle_button_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_toggle_button_set_active (_tmp0_, !_tmp3_);
}

static void
___lambda145__font_manager_font_list_base_activated (FontManagerFontListBase* _sender,
                                                     guint position,
                                                     gpointer self)
{
	__lambda145_ ((FontManagerBrowsePane*) self);
}

static void
_font_manager_browse_pane_on_map_gtk_widget_map (GtkWidget* _sender,
                                                 gpointer self)
{
	font_manager_browse_pane_on_map ((FontManagerBrowsePane*) self);
}

static void
_font_manager_browse_pane_on_mode_changed_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	font_manager_browse_pane_on_mode_changed ((FontManagerBrowsePane*) self);
}

static void
__lambda146_ (FontManagerBrowsePane* self)
{
	FontManagerBrowsePreview* _tmp0_;
	FontManagerWaterfallSettings* _tmp1_;
	_tmp0_ = self->priv->preview;
	_tmp1_ = self->priv->_waterfall_settings;
	font_manager_browse_preview_set_waterfall_settings (_tmp0_, _tmp1_);
}

static void
___lambda146__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda146_ ((FontManagerBrowsePane*) self);
}

FontManagerBrowsePane*
font_manager_browse_pane_construct (GType object_type)
{
	FontManagerBrowsePane * self = NULL;
	GtkScrolledWindow* _tmp0_;
	GtkScrolledWindow* _tmp1_;
	FontManagerFontGridView* _tmp2_;
	FontManagerFontGridView* _tmp3_;
	GtkSearchEntry* _tmp4_;
	GtkScrolledWindow* _tmp5_;
	FontManagerFontGridView* _tmp6_;
	FontManagerBrowsePreview* _tmp7_;
	FontManagerBrowsePreview* _tmp8_;
	FontManagerBrowsePreview* _tmp9_;
	GtkRevealer* _tmp10_ = NULL;
	GtkRevealer* _tmp11_;
	FontManagerBrowsePreview* _tmp12_;
	GtkRevealer* _tmp13_;
	FontManagerPaned* _tmp14_;
	GtkScrolledWindow* _tmp15_;
	FontManagerPaned* _tmp16_;
	GtkRevealer* _tmp17_;
	GBindingFlags flags = 0U;
	FontManagerFontGridView* _tmp18_;
	FontManagerBrowsePreview* _tmp19_;
	FontManagerFontGridView* _tmp20_;
	FontManagerBrowseListView* _tmp21_;
	FontManagerFontGridView* _tmp22_;
	FontManagerBrowsePreview* _tmp23_;
	FontManagerFontGridView* _tmp24_;
	FontManagerFontGridView* _tmp25_;
	FontManagerBrowsePreview* _tmp26_;
	GtkEntry* _tmp27_;
	FontManagerFontGridView* _tmp28_;
	GtkEntry* _tmp29_;
	FontManagerBrowseListView* _tmp30_;
	FontManagerBrowseListView* _tmp31_;
	FontManagerFontScale* _tmp32_;
	FontManagerPaned* _tmp33_;
	FontManagerFontGridView* _tmp34_;
	GtkRevealer* _tmp35_;
	GtkToggleButton* _tmp36_;
	GtkRevealer* _tmp37_;
	GtkToggleButton* _tmp38_;
	GtkToggleButton* _tmp39_;
	GtkSearchBar* _tmp40_;
	GtkAdjustment* _tmp41_;
	FontManagerPreviewTileSize _tmp42_;
	FontManagerFontGridView* _tmp43_;
	self = (FontManagerBrowsePane*) g_object_new (object_type, NULL);
	font_manager_widget_set_name ((GtkWidget*) self, "FontManagerBrowsePane");
	_tmp0_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->gridview_container);
	self->priv->gridview_container = _tmp0_;
	_tmp1_ = self->priv->gridview_container;
	_tmp2_ = font_manager_font_grid_view_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->gridview);
	self->priv->gridview = _tmp2_;
	_tmp3_ = self->priv->gridview;
	_tmp4_ = self->priv->search_entry;
	font_manager_font_grid_view_set_search_entry (_tmp3_, _tmp4_);
	_tmp5_ = self->priv->gridview_container;
	_tmp6_ = self->priv->gridview;
	gtk_scrolled_window_set_child (_tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = font_manager_browse_preview_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->preview);
	self->priv->preview = _tmp7_;
	_tmp8_ = self->priv->preview;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp8_, 0);
	_tmp9_ = self->priv->preview;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp9_, 6);
	_tmp10_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_reveal_child (_tmp10_, FALSE);
	gtk_widget_set_visible ((GtkWidget*) _tmp10_, FALSE);
	gtk_revealer_set_transition_type (_tmp10_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->panel_revealer);
	self->priv->panel_revealer = _tmp10_;
	_tmp11_ = self->priv->panel_revealer;
	_tmp12_ = self->priv->preview;
	gtk_revealer_set_child (_tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = self->priv->panel_revealer;
	gtk_widget_add_css_class ((GtkWidget*) _tmp13_, FONT_MANAGER_STYLE_CLASS_VIEW);
	_tmp14_ = self->priv->pane;
	_tmp15_ = self->priv->gridview_container;
	font_manager_paned_set_start_child (_tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = self->priv->pane;
	_tmp17_ = self->priv->panel_revealer;
	font_manager_paned_set_end_child (_tmp16_, (GtkWidget*) _tmp17_);
	font_manager_browse_pane_set_fontscale_margins (self);
	flags = G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE;
	_tmp18_ = self->priv->gridview;
	_tmp19_ = self->priv->preview;
	g_object_bind_property_with_closures ((GObject*) _tmp18_, "model", (GObject*) _tmp19_, "model", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp20_ = self->priv->gridview;
	_tmp21_ = self->priv->listview;
	g_object_bind_property_with_closures ((GObject*) _tmp20_, "model", (GObject*) _tmp21_, "font-model", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp22_ = self->priv->gridview;
	_tmp23_ = self->priv->preview;
	g_object_bind_property_with_closures ((GObject*) _tmp22_, "selected-item", (GObject*) _tmp23_, "selected-item", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp24_ = self->priv->gridview;
	g_object_bind_property_with_closures ((GObject*) self, "available-fonts", (GObject*) _tmp24_, "available-fonts", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp25_ = self->priv->gridview;
	g_object_bind_property_with_closures ((GObject*) self, "disabled-families", (GObject*) _tmp25_, "disabled-families", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp26_ = self->priv->preview;
	g_object_bind_property_with_closures ((GObject*) self, "disabled-families", (GObject*) _tmp26_, "disabled-families", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp27_ = self->priv->preview_entry;
	_tmp28_ = self->priv->gridview;
	g_object_bind_property_with_closures ((GObject*) _tmp27_, "text", (GObject*) _tmp28_, "preview-text", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp29_ = self->priv->preview_entry;
	_tmp30_ = self->priv->listview;
	g_object_bind_property_with_closures ((GObject*) _tmp29_, "text", (GObject*) _tmp30_, "preview-text", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	flags = G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE;
	_tmp31_ = self->priv->listview;
	_tmp32_ = self->priv->fontscale;
	g_object_bind_property_with_closures ((GObject*) _tmp31_, "preview-size", (GObject*) _tmp32_, "value", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	flags = G_BINDING_BIDIRECTIONAL;
	_tmp33_ = self->priv->pane;
	g_object_bind_property_with_closures ((GObject*) self, "pane-position", (GObject*) _tmp33_, "position", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp34_ = self->priv->gridview;
	g_object_bind_property_with_closures ((GObject*) self, "size", (GObject*) _tmp34_, "size", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp35_ = self->priv->panel_revealer;
	_tmp36_ = self->priv->panel_toggle;
	g_object_bind_property_with_closures ((GObject*) _tmp35_, "visible", (GObject*) _tmp36_, "active", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp37_ = self->priv->panel_revealer;
	_tmp38_ = self->priv->panel_toggle;
	g_object_bind_property_with_closures ((GObject*) _tmp37_, "reveal-child", (GObject*) _tmp38_, "active", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp39_ = self->priv->search_toggle;
	_tmp40_ = self->priv->search_bar;
	g_object_bind_property_with_closures ((GObject*) _tmp39_, "active", (GObject*) _tmp40_, "search-mode-enabled", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp41_ = self->priv->icon_size_adjustment;
	_tmp42_ = self->priv->_size;
	gtk_adjustment_set_value (_tmp41_, font_manager_preview_tile_size_to_double (_tmp42_));
	g_signal_connect_object ((GObject*) self, "notify::size", (GCallback) ___lambda144__g_object_notify, self, 0);
	_tmp43_ = self->priv->gridview;
	g_signal_connect_object ((FontManagerFontListBase*) _tmp43_, "activated", (GCallback) ___lambda145__font_manager_font_list_base_activated, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "map", (GCallback) _font_manager_browse_pane_on_map_gtk_widget_map, self, G_CONNECT_AFTER);
	g_signal_connect_object ((GObject*) self, "notify::mode", (GCallback) _font_manager_browse_pane_on_mode_changed_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::waterfall-settings", (GCallback) ___lambda146__g_object_notify, self, G_CONNECT_AFTER);
	return self;
}

FontManagerBrowsePane*
font_manager_browse_pane_new (void)
{
	return font_manager_browse_pane_construct (FONT_MANAGER_TYPE_BROWSE_PANE);
}

static gchar*
_variant_get2 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

void
font_manager_browse_pane_on_zoom (FontManagerBrowsePane* self,
                                  const gchar* action,
                                  GVariant* parameter)
{
	FontManagerBrowsePreviewMode mode = 0;
	FontManagerBrowsePreview* _tmp0_;
	FontManagerBrowsePreviewMode _tmp1_;
	FontManagerBrowsePreviewMode _tmp2_;
	gchar* param = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parameter != NULL);
	_tmp0_ = self->priv->preview;
	_tmp1_ = font_manager_browse_preview_get_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	mode = _tmp2_;
	if (mode == FONT_MANAGER_BROWSE_PREVIEW_MODE_WATERFALL) {
		return;
	}
	_tmp3_ = _variant_get2 (parameter);
	param = _tmp3_;
	_tmp4_ = param;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("+")))) {
		switch (0) {
			default:
			{
				if (mode == FONT_MANAGER_BROWSE_PREVIEW_MODE_LOREM_IPSUM) {
					FontManagerBrowsePreview* _tmp8_;
					FontManagerPreviewPage* _tmp9_;
					FontManagerPreviewPage* _tmp10_;
					gdouble _tmp11_;
					gdouble _tmp12_;
					_tmp8_ = self->priv->preview;
					_tmp9_ = font_manager_browse_preview_get_preview_page (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = font_manager_preview_page_get_preview_size (_tmp10_);
					_tmp12_ = _tmp11_;
					font_manager_preview_page_set_preview_size (_tmp10_, _tmp12_ + 1);
				} else {
					FontManagerBrowsePreview* _tmp13_;
					FontManagerUnicodeCharacterMap* _tmp14_;
					FontManagerUnicodeCharacterMap* _tmp15_;
					gdouble _tmp16_;
					gdouble _tmp17_;
					_tmp13_ = self->priv->preview;
					_tmp14_ = font_manager_browse_preview_get_character_map (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = font_manager_unicode_character_map_get_preview_size (_tmp15_);
					_tmp17_ = _tmp16_;
					font_manager_unicode_character_map_set_preview_size (_tmp15_, _tmp17_ + 1);
				}
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("-")))) {
		switch (0) {
			default:
			{
				if (mode == FONT_MANAGER_BROWSE_PREVIEW_MODE_LOREM_IPSUM) {
					FontManagerBrowsePreview* _tmp18_;
					FontManagerPreviewPage* _tmp19_;
					FontManagerPreviewPage* _tmp20_;
					gdouble _tmp21_;
					gdouble _tmp22_;
					_tmp18_ = self->priv->preview;
					_tmp19_ = font_manager_browse_preview_get_preview_page (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = font_manager_preview_page_get_preview_size (_tmp20_);
					_tmp22_ = _tmp21_;
					font_manager_preview_page_set_preview_size (_tmp20_, _tmp22_ - 1);
				} else {
					FontManagerBrowsePreview* _tmp23_;
					FontManagerUnicodeCharacterMap* _tmp24_;
					FontManagerUnicodeCharacterMap* _tmp25_;
					gdouble _tmp26_;
					gdouble _tmp27_;
					_tmp23_ = self->priv->preview;
					_tmp24_ = font_manager_browse_preview_get_character_map (_tmp23_);
					_tmp25_ = _tmp24_;
					_tmp26_ = font_manager_unicode_character_map_get_preview_size (_tmp25_);
					_tmp27_ = _tmp26_;
					font_manager_unicode_character_map_set_preview_size (_tmp25_, _tmp27_ - 1);
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				if (mode == FONT_MANAGER_BROWSE_PREVIEW_MODE_LOREM_IPSUM) {
					FontManagerBrowsePreview* _tmp28_;
					FontManagerPreviewPage* _tmp29_;
					FontManagerPreviewPage* _tmp30_;
					_tmp28_ = self->priv->preview;
					_tmp29_ = font_manager_browse_preview_get_preview_page (_tmp28_);
					_tmp30_ = _tmp29_;
					font_manager_preview_page_set_preview_size (_tmp30_, FONT_MANAGER_DEFAULT_PREVIEW_SIZE + 2.0);
				} else {
					FontManagerBrowsePreview* _tmp31_;
					FontManagerUnicodeCharacterMap* _tmp32_;
					FontManagerUnicodeCharacterMap* _tmp33_;
					_tmp31_ = self->priv->preview;
					_tmp32_ = font_manager_browse_preview_get_character_map (_tmp31_);
					_tmp33_ = _tmp32_;
					font_manager_unicode_character_map_set_preview_size (_tmp33_, FONT_MANAGER_LARGE_PREVIEW_SIZE);
				}
				break;
			}
		}
	}
	_g_free0 (param);
	return;
}

static void
font_manager_browse_pane_set_fontscale_margins (FontManagerBrowsePane* self)
{
	GtkWidget* child = NULL;
	FontManagerFontScale* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->fontscale;
	_tmp1_ = gtk_widget_get_first_child ((GtkWidget*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	child = _tmp2_;
	while (TRUE) {
		GtkWidget* _tmp3_;
		GtkWidget* _tmp4_;
		GtkWidget* _tmp5_;
		GtkWidget* _tmp6_;
		GtkWidget* _tmp7_;
		GtkWidget* _tmp8_;
		_tmp3_ = child;
		if (!(_tmp3_ != NULL)) {
			break;
		}
		_tmp4_ = child;
		gtk_widget_set_margin_bottom (_tmp4_, 1);
		_tmp5_ = child;
		gtk_widget_set_margin_top (_tmp5_, 1);
		_tmp6_ = child;
		_tmp7_ = gtk_widget_get_next_sibling (_tmp6_);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (child);
		child = _tmp8_;
	}
	_g_object_unref0 (child);
	return;
}

static void
font_manager_browse_pane_on_mode_changed (FontManagerBrowsePane* self)
{
	GtkToggleButton* _tmp0_;
	FontManagerBrowseMode _tmp1_;
	GtkToggleButton* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->panel_toggle;
	_tmp1_ = self->priv->_mode;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, _tmp1_ == FONT_MANAGER_BROWSE_MODE_GRID);
	_tmp2_ = self->priv->edit_toggle;
	_tmp3_ = gtk_toggle_button_get_active (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GtkStack* _tmp5_;
		_tmp5_ = self->priv->control_stack;
		gtk_stack_set_visible_child_name (_tmp5_, "entry");
	} else {
		gboolean _tmp6_ = FALSE;
		FontManagerBrowseMode _tmp7_;
		_tmp7_ = self->priv->_mode;
		if (_tmp7_ == FONT_MANAGER_BROWSE_MODE_LIST) {
			GtkToggleButton* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp8_ = self->priv->edit_toggle;
			_tmp9_ = gtk_toggle_button_get_active (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp6_ = !_tmp10_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			GtkStack* _tmp11_;
			_tmp11_ = self->priv->control_stack;
			gtk_stack_set_visible_child_name (_tmp11_, "fontscale");
		} else {
			gboolean _tmp12_ = FALSE;
			FontManagerBrowseMode _tmp13_;
			_tmp13_ = self->priv->_mode;
			if (_tmp13_ == FONT_MANAGER_BROWSE_MODE_GRID) {
				GtkToggleButton* _tmp14_;
				gboolean _tmp15_;
				gboolean _tmp16_;
				_tmp14_ = self->priv->edit_toggle;
				_tmp15_ = gtk_toggle_button_get_active (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp12_ = !_tmp16_;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				GtkStack* _tmp17_;
				_tmp17_ = self->priv->control_stack;
				gtk_stack_set_visible_child_name (_tmp17_, "scale");
			}
		}
	}
	return;
}

static void
font_manager_browse_pane_on_map (FontManagerBrowsePane* self)
{
	FontManagerBrowseListView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->listview;
	if (_tmp0_ != NULL) {
		FontManagerBrowseListView* _tmp1_;
		_tmp1_ = self->priv->listview;
		gtk_tree_view_set_model ((GtkTreeView*) _tmp1_, NULL);
	}
	font_manager_browse_pane_queue_update (self);
	return;
}

void
font_manager_browse_pane_restore_state (FontManagerBrowsePane* self,
                                        GSettings* settings)
{
	GtkToggleButton* _tmp0_;
	GtkRevealer* _tmp1_;
	GtkToggleButton* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkRevealer* _tmp5_;
	GtkToggleButton* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	FontManagerBrowseListView* _tmp9_;
	GtkEntry* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GtkToggleButton* _tmp13_;
	FontManagerFontGridView* _tmp14_;
	FontManagerBrowseListView* _tmp15_;
	GtkEntry* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	font_manager_browse_pane_set_pane_position (self, g_settings_get_double (settings, "browse-pane-position"));
	_tmp0_ = self->priv->panel_toggle;
	gtk_toggle_button_set_active (_tmp0_, g_settings_get_boolean (settings, "browse-preview-visible"));
	_tmp1_ = self->priv->panel_revealer;
	_tmp2_ = self->priv->panel_toggle;
	_tmp3_ = gtk_toggle_button_get_active (_tmp2_);
	_tmp4_ = _tmp3_;
	gtk_revealer_set_reveal_child (_tmp1_, _tmp4_);
	_tmp5_ = self->priv->panel_revealer;
	_tmp6_ = self->priv->panel_toggle;
	_tmp7_ = gtk_toggle_button_get_active (_tmp6_);
	_tmp8_ = _tmp7_;
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, _tmp8_);
	_tmp9_ = self->priv->listview;
	font_manager_browse_list_view_set_preview_size (_tmp9_, g_settings_get_double (settings, "browse-font-size"));
	_tmp10_ = self->priv->preview_entry;
	_tmp11_ = g_settings_get_string (settings, "browse-preview-text");
	_tmp12_ = _tmp11_;
	gtk_editable_set_text ((GtkEditable*) _tmp10_, _tmp12_);
	_g_free0 (_tmp12_);
	g_settings_bind (settings, "browse-pane-position", (GObject*) self, "pane-position", G_SETTINGS_BIND_DEFAULT);
	_tmp13_ = self->priv->panel_toggle;
	g_settings_bind (settings, "browse-preview-visible", (GObject*) _tmp13_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp14_ = self->priv->gridview;
	g_settings_bind (settings, "browse-preview-tile-size", (GObject*) _tmp14_, "size", G_SETTINGS_BIND_DEFAULT);
	_tmp15_ = self->priv->listview;
	g_settings_bind (settings, "browse-font-size", (GObject*) _tmp15_, "preview-size", G_SETTINGS_BIND_DEFAULT);
	_tmp16_ = self->priv->preview_entry;
	g_settings_bind (settings, "browse-preview-text", (GObject*) _tmp16_, "text", G_SETTINGS_BIND_DEFAULT);
	return;
}

void
font_manager_browse_pane_select_first_font (FontManagerBrowsePane* self)
{
	FontManagerFontGridView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gridview;
	font_manager_font_list_base_select_item ((FontManagerFontListBase*) _tmp0_, (guint) 0);
	return;
}

void
font_manager_browse_pane_queue_update (FontManagerBrowsePane* self)
{
	FontManagerFontGridView* _tmp0_;
	FontManagerBrowseListView* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gridview;
	font_manager_font_list_base_queue_update ((FontManagerFontListBase*) _tmp0_);
	_tmp1_ = self->priv->listview;
	font_manager_browse_list_view_queue_update (_tmp1_);
	return;
}

static void
font_manager_browse_pane_toggle_panel (FontManagerBrowsePane* self,
                                       GtkWidget* widget,
                                       const gchar* action,
                                       GVariant* parameter)
{
	GtkToggleButton* _tmp0_;
	GtkToggleButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->panel_toggle;
	_tmp1_ = self->priv->panel_toggle;
	_tmp2_ = gtk_toggle_button_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_toggle_button_set_active (_tmp0_, !_tmp3_);
	return;
}

void
font_manager_browse_pane_toggle_search (FontManagerBrowsePane* self)
{
	GtkSearchBar* _tmp0_;
	GtkSearchBar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_bar;
	_tmp1_ = self->priv->search_bar;
	gtk_search_bar_set_search_mode (_tmp0_, !gtk_search_bar_get_search_mode (_tmp1_));
	return;
}

void
font_manager_browse_pane_search (FontManagerBrowsePane* self,
                                 const gchar* needle)
{
	GtkSearchEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (needle != NULL);
	_tmp0_ = self->priv->search_entry;
	gtk_editable_set_text ((GtkEditable*) _tmp0_, needle);
	return;
}

void
font_manager_browse_pane_on_edit_toggled (FontManagerBrowsePane* self,
                                          GtkToggleButton* unused)
{
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (unused != NULL);
	font_manager_browse_pane_on_mode_changed (self);
	_tmp0_ = self->priv->edit_toggle;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkEntry* _tmp3_;
		_tmp3_ = self->priv->preview_entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp3_);
	}
	return;
}

static void
_font_manager_browse_pane_on_edit_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                     gpointer self)
{
	font_manager_browse_pane_on_edit_toggled ((FontManagerBrowsePane*) self, _sender);
}

void
font_manager_browse_pane_on_decrease_size (FontManagerBrowsePane* self,
                                           GtkButton* unused)
{
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (unused != NULL);
	_tmp0_ = self->priv->icon_size_adjustment;
	_tmp1_ = self->priv->icon_size_adjustment;
	gtk_adjustment_set_value (_tmp0_, gtk_adjustment_get_value (_tmp1_) - 1);
	return;
}

static void
_font_manager_browse_pane_on_decrease_size_gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self)
{
	font_manager_browse_pane_on_decrease_size ((FontManagerBrowsePane*) self, _sender);
}

void
font_manager_browse_pane_on_increase_size (FontManagerBrowsePane* self,
                                           GtkButton* unused)
{
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (unused != NULL);
	_tmp0_ = self->priv->icon_size_adjustment;
	_tmp1_ = self->priv->icon_size_adjustment;
	gtk_adjustment_set_value (_tmp0_, gtk_adjustment_get_value (_tmp1_) + 1);
	return;
}

static void
_font_manager_browse_pane_on_increase_size_gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self)
{
	font_manager_browse_pane_on_increase_size ((FontManagerBrowsePane*) self, _sender);
}

void
font_manager_browse_pane_on_scale_changed (FontManagerBrowsePane* self,
                                           GtkRange* range)
{
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (range != NULL);
	_tmp0_ = gtk_range_get_adjustment (range);
	_tmp1_ = _tmp0_;
	gtk_range_set_value (range, round (gtk_adjustment_get_value (_tmp1_)));
	font_manager_browse_pane_set_size (self, font_manager_preview_tile_size_from_double (gtk_range_get_value (range)));
	return;
}

static void
_font_manager_browse_pane_on_scale_changed_gtk_range_value_changed (GtkRange* _sender,
                                                                    gpointer self)
{
	font_manager_browse_pane_on_scale_changed ((FontManagerBrowsePane*) self, _sender);
}

gdouble
font_manager_browse_pane_get_pane_position (FontManagerBrowsePane* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_pane_position;
	return result;
}

void
font_manager_browse_pane_set_pane_position (FontManagerBrowsePane* self,
                                            gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_browse_pane_get_pane_position (self);
	if (old_value != value) {
		self->priv->_pane_position = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_browse_pane_properties[FONT_MANAGER_BROWSE_PANE_PANE_POSITION_PROPERTY]);
	}
}

JsonArray*
font_manager_browse_pane_get_available_fonts (FontManagerBrowsePane* self)
{
	JsonArray* result;
	JsonArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_available_fonts;
	result = _tmp0_;
	return result;
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

void
font_manager_browse_pane_set_available_fonts (FontManagerBrowsePane* self,
                                              JsonArray* value)
{
	JsonArray* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_browse_pane_get_available_fonts (self);
	if (old_value != value) {
		JsonArray* _tmp0_;
		_tmp0_ = _json_array_ref0 (value);
		_json_array_unref0 (self->priv->_available_fonts);
		self->priv->_available_fonts = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_browse_pane_properties[FONT_MANAGER_BROWSE_PANE_AVAILABLE_FONTS_PROPERTY]);
	}
}

FontManagerReject*
font_manager_browse_pane_get_disabled_families (FontManagerBrowsePane* self)
{
	FontManagerReject* result;
	FontManagerReject* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_disabled_families;
	result = _tmp0_;
	return result;
}

void
font_manager_browse_pane_set_disabled_families (FontManagerBrowsePane* self,
                                                FontManagerReject* value)
{
	FontManagerReject* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_browse_pane_get_disabled_families (self);
	if (old_value != value) {
		FontManagerReject* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_disabled_families);
		self->priv->_disabled_families = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_browse_pane_properties[FONT_MANAGER_BROWSE_PANE_DISABLED_FAMILIES_PROPERTY]);
	}
}

FontManagerPreviewTileSize
font_manager_browse_pane_get_size (FontManagerBrowsePane* self)
{
	FontManagerPreviewTileSize result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_size;
	return result;
}

void
font_manager_browse_pane_set_size (FontManagerBrowsePane* self,
                                   FontManagerPreviewTileSize value)
{
	FontManagerPreviewTileSize old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_browse_pane_get_size (self);
	if (old_value != value) {
		self->priv->_size = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_browse_pane_properties[FONT_MANAGER_BROWSE_PANE_SIZE_PROPERTY]);
	}
}

FontManagerBrowseMode
font_manager_browse_pane_get_mode (FontManagerBrowsePane* self)
{
	FontManagerBrowseMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_mode;
	return result;
}

void
font_manager_browse_pane_set_mode (FontManagerBrowsePane* self,
                                   FontManagerBrowseMode value)
{
	FontManagerBrowseMode old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_browse_pane_get_mode (self);
	if (old_value != value) {
		self->priv->_mode = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_browse_pane_properties[FONT_MANAGER_BROWSE_PANE_MODE_PROPERTY]);
	}
}

FontManagerWaterfallSettings*
font_manager_browse_pane_get_waterfall_settings (FontManagerBrowsePane* self)
{
	FontManagerWaterfallSettings* result;
	FontManagerWaterfallSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_waterfall_settings;
	result = _tmp0_;
	return result;
}

void
font_manager_browse_pane_set_waterfall_settings (FontManagerBrowsePane* self,
                                                 FontManagerWaterfallSettings* value)
{
	FontManagerWaterfallSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_browse_pane_get_waterfall_settings (self);
	if (old_value != value) {
		FontManagerWaterfallSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_waterfall_settings);
		self->priv->_waterfall_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_browse_pane_properties[FONT_MANAGER_BROWSE_PANE_WATERFALL_SETTINGS_PROPERTY]);
	}
}

GtkStack*
font_manager_browse_pane_get_stack (FontManagerBrowsePane* self)
{
	GtkStack* result;
	GtkStack* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_stack;
	result = _tmp0_;
	return result;
}

static void
font_manager_browse_pane_class_init (FontManagerBrowsePaneClass * klass,
                                     gpointer klass_data)
{
	GdkModifierType mode_mask = 0U;
	font_manager_browse_pane_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerBrowsePane_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_browse_pane_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_browse_pane_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_browse_pane_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BROWSE_PANE_PANE_POSITION_PROPERTY, font_manager_browse_pane_properties[FONT_MANAGER_BROWSE_PANE_PANE_POSITION_PROPERTY] = g_param_spec_double ("pane-position", "pane-position", "pane-position", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 55.0f, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BROWSE_PANE_AVAILABLE_FONTS_PROPERTY, font_manager_browse_pane_properties[FONT_MANAGER_BROWSE_PANE_AVAILABLE_FONTS_PROPERTY] = g_param_spec_boxed ("available-fonts", "available-fonts", "available-fonts", json_array_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BROWSE_PANE_DISABLED_FAMILIES_PROPERTY, font_manager_browse_pane_properties[FONT_MANAGER_BROWSE_PANE_DISABLED_FAMILIES_PROPERTY] = g_param_spec_object ("disabled-families", "disabled-families", "disabled-families", font_manager_reject_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BROWSE_PANE_SIZE_PROPERTY, font_manager_browse_pane_properties[FONT_MANAGER_BROWSE_PANE_SIZE_PROPERTY] = g_param_spec_enum ("size", "size", "size", FONT_MANAGER_TYPE_PREVIEW_TILE_SIZE, FONT_MANAGER_PREVIEW_TILE_SIZE_LARGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BROWSE_PANE_MODE_PROPERTY, font_manager_browse_pane_properties[FONT_MANAGER_BROWSE_PANE_MODE_PROPERTY] = g_param_spec_enum ("mode", "mode", "mode", FONT_MANAGER_TYPE_BROWSE_MODE, FONT_MANAGER_BROWSE_MODE_GRID, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BROWSE_PANE_WATERFALL_SETTINGS_PROPERTY, font_manager_browse_pane_properties[FONT_MANAGER_BROWSE_PANE_WATERFALL_SETTINGS_PROPERTY] = g_param_spec_object ("waterfall-settings", "waterfall-settings", "waterfall-settings", FONT_MANAGER_TYPE_WATERFALL_SETTINGS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BROWSE_PANE_STACK_PROPERTY, font_manager_browse_pane_properties[FONT_MANAGER_BROWSE_PANE_STACK_PROPERTY] = g_param_spec_object ("stack", "stack", "stack", gtk_stack_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/github/FontManager/FontManager/ui/font-manager-browse-pane.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, FontManagerBrowsePane_private_offset + G_STRUCT_OFFSET (FontManagerBrowsePanePrivate, _stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "preview_entry", FALSE, FontManagerBrowsePane_private_offset + G_STRUCT_OFFSET (FontManagerBrowsePanePrivate, preview_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_bar", FALSE, FontManagerBrowsePane_private_offset + G_STRUCT_OFFSET (FontManagerBrowsePanePrivate, search_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_entry", FALSE, FontManagerBrowsePane_private_offset + G_STRUCT_OFFSET (FontManagerBrowsePanePrivate, search_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "edit_toggle", FALSE, FontManagerBrowsePane_private_offset + G_STRUCT_OFFSET (FontManagerBrowsePanePrivate, edit_toggle));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "panel_toggle", FALSE, FontManagerBrowsePane_private_offset + G_STRUCT_OFFSET (FontManagerBrowsePanePrivate, panel_toggle));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_toggle", FALSE, FontManagerBrowsePane_private_offset + G_STRUCT_OFFSET (FontManagerBrowsePanePrivate, search_toggle));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "icon_size_adjustment", FALSE, FontManagerBrowsePane_private_offset + G_STRUCT_OFFSET (FontManagerBrowsePanePrivate, icon_size_adjustment));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pane", FALSE, FontManagerBrowsePane_private_offset + G_STRUCT_OFFSET (FontManagerBrowsePanePrivate, pane));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "control_stack", FALSE, FontManagerBrowsePane_private_offset + G_STRUCT_OFFSET (FontManagerBrowsePanePrivate, control_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "listview", FALSE, FontManagerBrowsePane_private_offset + G_STRUCT_OFFSET (FontManagerBrowsePanePrivate, listview));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "fontscale", FALSE, FontManagerBrowsePane_private_offset + G_STRUCT_OFFSET (FontManagerBrowsePanePrivate, fontscale));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_edit_toggled", G_CALLBACK(_font_manager_browse_pane_on_edit_toggled_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_decrease_size", G_CALLBACK(_font_manager_browse_pane_on_decrease_size_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_increase_size", G_CALLBACK(_font_manager_browse_pane_on_increase_size_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_scale_changed", G_CALLBACK(_font_manager_browse_pane_on_scale_changed_gtk_range_value_changed));
	gtk_widget_class_install_action (GTK_WIDGET_CLASS (klass), "toggle-panel", NULL, (GtkWidgetActionActivateFunc) font_manager_browse_pane_toggle_panel);
	mode_mask = GDK_CONTROL_MASK;
	gtk_widget_class_add_binding_action (GTK_WIDGET_CLASS (klass), GDK_KEY_F9, 0, "toggle-panel", NULL, NULL);
	gtk_widget_class_add_binding_action (GTK_WIDGET_CLASS (klass), GDK_KEY_0, mode_mask, "reset-size", "s", "0", NULL);
	gtk_widget_class_add_binding_action (GTK_WIDGET_CLASS (klass), GDK_KEY_plus, mode_mask, "increase-size", "s", "+", NULL);
	gtk_widget_class_add_binding_action (GTK_WIDGET_CLASS (klass), GDK_KEY_equal, mode_mask, "increase-size", "s", "+", NULL);
	gtk_widget_class_add_binding_action (GTK_WIDGET_CLASS (klass), GDK_KEY_ZoomIn, mode_mask, "increase-size", "s", "+", NULL);
	gtk_widget_class_add_binding_action (GTK_WIDGET_CLASS (klass), GDK_KEY_minus, mode_mask, "decrease-size", "s", "-", NULL);
	gtk_widget_class_add_binding_action (GTK_WIDGET_CLASS (klass), GDK_KEY_ZoomOut, mode_mask, "decrease-size", "s", "-", NULL);
	gtk_widget_class_install_action (GTK_WIDGET_CLASS (klass), "reset-size", "s", (GtkWidgetActionActivateFunc) font_manager_browse_pane_on_zoom);
	gtk_widget_class_install_action (GTK_WIDGET_CLASS (klass), "increase-size", "s", (GtkWidgetActionActivateFunc) font_manager_browse_pane_on_zoom);
	gtk_widget_class_install_action (GTK_WIDGET_CLASS (klass), "decrease-size", "s", (GtkWidgetActionActivateFunc) font_manager_browse_pane_on_zoom);
}

static void
font_manager_browse_pane_instance_init (FontManagerBrowsePane * self,
                                        gpointer klass)
{
	self->priv = font_manager_browse_pane_get_instance_private (self);
	self->priv->_pane_position = (gdouble) 55.0f;
	self->priv->_available_fonts = NULL;
	self->priv->_disabled_families = NULL;
	self->priv->_size = FONT_MANAGER_PREVIEW_TILE_SIZE_LARGE;
	self->priv->_mode = FONT_MANAGER_BROWSE_MODE_GRID;
	g_type_ensure (FONT_MANAGER_TYPE_PANED);
	g_type_ensure (FONT_MANAGER_TYPE_BROWSE_LIST_VIEW);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
font_manager_browse_pane_finalize (GObject * obj)
{
	FontManagerBrowsePane * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_BROWSE_PANE, FontManagerBrowsePane);
	_json_array_unref0 (self->priv->_available_fonts);
	_g_object_unref0 (self->priv->_disabled_families);
	_g_object_unref0 (self->priv->_waterfall_settings);
	_g_object_unref0 (self->priv->panel_revealer);
	_g_object_unref0 (self->priv->gridview_container);
	_g_object_unref0 (self->priv->preview);
	_g_object_unref0 (self->priv->gridview);
	G_OBJECT_CLASS (font_manager_browse_pane_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_browse_pane_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerBrowsePaneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_browse_pane_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerBrowsePane), 0, (GInstanceInitFunc) font_manager_browse_pane_instance_init, NULL };
	GType font_manager_browse_pane_type_id;
	font_manager_browse_pane_type_id = g_type_register_static (gtk_box_get_type (), "FontManagerBrowsePane", &g_define_type_info, 0);
	FontManagerBrowsePane_private_offset = g_type_add_instance_private (font_manager_browse_pane_type_id, sizeof (FontManagerBrowsePanePrivate));
	return font_manager_browse_pane_type_id;
}

GType
font_manager_browse_pane_get_type (void)
{
	static volatile gsize font_manager_browse_pane_type_id__once = 0;
	if (g_once_init_enter (&font_manager_browse_pane_type_id__once)) {
		GType font_manager_browse_pane_type_id;
		font_manager_browse_pane_type_id = font_manager_browse_pane_get_type_once ();
		g_once_init_leave (&font_manager_browse_pane_type_id__once, font_manager_browse_pane_type_id);
	}
	return font_manager_browse_pane_type_id__once;
}

static void
_vala_font_manager_browse_pane_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	FontManagerBrowsePane * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_BROWSE_PANE, FontManagerBrowsePane);
	switch (property_id) {
		case FONT_MANAGER_BROWSE_PANE_PANE_POSITION_PROPERTY:
		g_value_set_double (value, font_manager_browse_pane_get_pane_position (self));
		break;
		case FONT_MANAGER_BROWSE_PANE_AVAILABLE_FONTS_PROPERTY:
		g_value_set_boxed (value, font_manager_browse_pane_get_available_fonts (self));
		break;
		case FONT_MANAGER_BROWSE_PANE_DISABLED_FAMILIES_PROPERTY:
		g_value_set_object (value, font_manager_browse_pane_get_disabled_families (self));
		break;
		case FONT_MANAGER_BROWSE_PANE_SIZE_PROPERTY:
		g_value_set_enum (value, font_manager_browse_pane_get_size (self));
		break;
		case FONT_MANAGER_BROWSE_PANE_MODE_PROPERTY:
		g_value_set_enum (value, font_manager_browse_pane_get_mode (self));
		break;
		case FONT_MANAGER_BROWSE_PANE_WATERFALL_SETTINGS_PROPERTY:
		g_value_set_object (value, font_manager_browse_pane_get_waterfall_settings (self));
		break;
		case FONT_MANAGER_BROWSE_PANE_STACK_PROPERTY:
		g_value_set_object (value, font_manager_browse_pane_get_stack (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_browse_pane_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	FontManagerBrowsePane * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_BROWSE_PANE, FontManagerBrowsePane);
	switch (property_id) {
		case FONT_MANAGER_BROWSE_PANE_PANE_POSITION_PROPERTY:
		font_manager_browse_pane_set_pane_position (self, g_value_get_double (value));
		break;
		case FONT_MANAGER_BROWSE_PANE_AVAILABLE_FONTS_PROPERTY:
		font_manager_browse_pane_set_available_fonts (self, g_value_get_boxed (value));
		break;
		case FONT_MANAGER_BROWSE_PANE_DISABLED_FAMILIES_PROPERTY:
		font_manager_browse_pane_set_disabled_families (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_BROWSE_PANE_SIZE_PROPERTY:
		font_manager_browse_pane_set_size (self, g_value_get_enum (value));
		break;
		case FONT_MANAGER_BROWSE_PANE_MODE_PROPERTY:
		font_manager_browse_pane_set_mode (self, g_value_get_enum (value));
		break;
		case FONT_MANAGER_BROWSE_PANE_WATERFALL_SETTINGS_PROPERTY:
		font_manager_browse_pane_set_waterfall_settings (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

