/* dummy-persona.c generated by valac 0.56.18, the Vala compiler
 * generated from dummy-persona.vala, do not modify */

/*
 * Copyright (C) 2013 Philip Withnall
 * Copyright (C) 2013 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include "folks/folks-dummy.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "folks/folks.h"
#include <glib-object.h>
#include <gee.h>
#include "folks/small-set.h"
#include "folks-internal.h"
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FOLKS_DUMMY_PERSONA_0_PROPERTY,
	FOLKS_DUMMY_PERSONA_LINKABLE_PROPERTIES_PROPERTY,
	FOLKS_DUMMY_PERSONA_WRITEABLE_PROPERTIES_PROPERTY,
	FOLKS_DUMMY_PERSONA_PROPERTY_CHANGE_DELAY_PROPERTY,
	FOLKS_DUMMY_PERSONA_NUM_PROPERTIES
};
static GParamSpec* folks_dummy_persona_properties[FOLKS_DUMMY_PERSONA_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block21Data Block21Data;
typedef struct _FolksDummyPersonaChangePropertyData FolksDummyPersonaChangePropertyData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FolksDummyPersonaPrivate {
	gchar** _linkable_properties;
	gint _linkable_properties_length1;
	gint __linkable_properties_size_;
	gchar** _writeable_properties;
	gint _writeable_properties_length1;
	gint __writeable_properties_size_;
	gint _property_change_delay;
};

struct _Block21Data {
	int _ref_count_;
	FolksDummyPersona* self;
	FolksDummyPersonaChangePropertyCallback callback;
	gpointer callback_target;
	gpointer _async_data_;
};

struct _FolksDummyPersonaChangePropertyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksDummyPersona* self;
	gchar* property_name;
	FolksDummyPersonaChangePropertyCallback callback;
	gpointer callback_target;
	Block21Data* _data21_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
};

static gint FolksDummyPersona_private_offset;
static gpointer folks_dummy_persona_parent_class = NULL;

static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
static void folks_dummy_persona_real_linkable_property_to_links (FolksPersona* base,
                                                          const gchar* prop_name,
                                                          FolksPersonaLinkablePropertyCallback callback,
                                                          gpointer callback_target);
static gchar** _vala_array_dup4 (gchar** self,
                          gssize length);
static void folks_dummy_persona_change_property_data_free (gpointer _data);
static gboolean folks_dummy_persona_change_property_co (FolksDummyPersonaChangePropertyData* _data_);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static gboolean ____lambda4_ (Block21Data* _data21_);
static gboolean _____lambda4__gsource_func (gpointer self);
static gboolean ____lambda5_ (Block21Data* _data21_);
static gboolean _____lambda5__gsource_func (gpointer self);
static void folks_dummy_persona_finalize (GObject * obj);
static GType folks_dummy_persona_get_type_once (void);
static void _vala_folks_dummy_persona_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_folks_dummy_persona_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
folks_dummy_persona_get_instance_private (FolksDummyPersona* self)
{
	return G_STRUCT_MEMBER_P (self, FolksDummyPersona_private_offset);
}

/**
   * Create a new persona.
   *
   * Create a new persona for the {@link FolksDummy.PersonaStore} ``store``,
   * with the given construct-only properties.
   *
   * The persona’s {@link Folks.Persona.writeable_properties} are initialised to
   * the given ``store``’s
   * {@link Folks.PersonaStore.always_writeable_properties}. They may be updated
   * afterwards using {@link FolksDummy.Persona.update_writeable_properties}.
   *
   * @param store the store which will contain the persona
   * @param contact_id a unique free-form string identifier for the persona
   * @param is_user ``true`` if the persona represents the user, ``false``
   * otherwise
   * @param linkable_properties an array of names of the properties which should
   * be used for linking this persona to others
   *
   * @since 0.9.7
   */
static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

FolksDummyPersona*
folks_dummy_persona_construct (GType object_type,
                               FolksDummyPersonaStore* store,
                               const gchar* contact_id,
                               gboolean is_user,
                               gchar** linkable_properties,
                               gint linkable_properties_length1)
{
	FolksDummyPersona * self = NULL;
	gchar* uid = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* iid = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	FolksPersonaStore* _tmp10_;
	FolksPersonaStore* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gint _tmp13_ = 0;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar** _tmp15_;
	gint _tmp15__length1;
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (contact_id != NULL, NULL);
	_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) store);
	_tmp1_ = _tmp0_;
	_tmp2_ = folks_persona_build_uid (BACKEND_NAME, _tmp1_, contact_id);
	uid = _tmp2_;
	_tmp3_ = folks_persona_store_get_id ((FolksPersonaStore*) store);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, ":", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp6_, contact_id, NULL);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	iid = _tmp8_;
	self = (FolksDummyPersona*) g_object_new (object_type, "display-id", contact_id, "uid", uid, "iid", iid, "store", store, "is-user", is_user, NULL);
	_tmp9_ = (linkable_properties != NULL) ? _vala_array_dup2 (linkable_properties, linkable_properties_length1) : linkable_properties;
	_tmp9__length1 = linkable_properties_length1;
	self->priv->_linkable_properties = (_vala_array_free (self->priv->_linkable_properties, self->priv->_linkable_properties_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_linkable_properties = _tmp9_;
	self->priv->_linkable_properties_length1 = _tmp9__length1;
	self->priv->__linkable_properties_size_ = self->priv->_linkable_properties_length1;
	_tmp10_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = folks_persona_store_get_always_writeable_properties (_tmp11_, &_tmp13_);
	_tmp12__length1 = _tmp13_;
	_tmp14_ = _tmp12_;
	_tmp14__length1 = _tmp12__length1;
	_tmp15_ = (_tmp14_ != NULL) ? _vala_array_dup3 (_tmp14_, _tmp14__length1) : _tmp14_;
	_tmp15__length1 = _tmp14__length1;
	self->priv->_writeable_properties = (_vala_array_free (self->priv->_writeable_properties, self->priv->_writeable_properties_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_writeable_properties = _tmp15_;
	self->priv->_writeable_properties_length1 = _tmp15__length1;
	self->priv->__writeable_properties_size_ = self->priv->_writeable_properties_length1;
	_g_free0 (iid);
	_g_free0 (uid);
	return self;
}

FolksDummyPersona*
folks_dummy_persona_new (FolksDummyPersonaStore* store,
                         const gchar* contact_id,
                         gboolean is_user,
                         gchar** linkable_properties,
                         gint linkable_properties_length1)
{
	return folks_dummy_persona_construct (FOLKS_DUMMY_TYPE_PERSONA, store, contact_id, is_user, linkable_properties, linkable_properties_length1);
}

/**
   * {@inheritDoc}
   *
   * @since 0.9.7
   */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
folks_dummy_persona_real_linkable_property_to_links (FolksPersona* base,
                                                     const gchar* prop_name,
                                                     FolksPersonaLinkablePropertyCallback callback,
                                                     gpointer callback_target)
{
	FolksDummyPersona * self;
	self = (FolksDummyPersona*) base;
	g_return_if_fail (prop_name != NULL);
	if (g_strcmp0 (prop_name, "im-addresses") == 0) {
		FolksImDetails* persona = NULL;
		FolksImDetails* _tmp0_;
		FolksImDetails* _tmp1_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (self, FOLKS_TYPE_IM_DETAILS) ? ((FolksImDetails*) self) : NULL);
		persona = _tmp0_;
		_tmp1_ = persona;
		_vala_assert (_tmp1_ != NULL, "persona != null");
		{
			GeeIterator* _protocol_it = NULL;
			FolksImDetails* _tmp2_;
			GeeMultiMap* _tmp3_;
			GeeMultiMap* _tmp4_;
			GeeSet* _tmp5_;
			GeeSet* _tmp6_;
			GeeIterator* _tmp7_;
			GeeIterator* _tmp8_;
			_tmp2_ = persona;
			_tmp3_ = folks_im_details_get_im_addresses (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = gee_multi_map_get_keys (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
			_tmp8_ = _tmp7_;
			_g_object_unref0 (_tmp6_);
			_protocol_it = _tmp8_;
			while (TRUE) {
				GeeIterator* _tmp9_;
				gchar* protocol = NULL;
				GeeIterator* _tmp10_;
				gpointer _tmp11_;
				GeeCollection* im_fds = NULL;
				FolksImDetails* _tmp12_;
				GeeMultiMap* _tmp13_;
				GeeMultiMap* _tmp14_;
				const gchar* _tmp15_;
				GeeCollection* _tmp16_;
				_tmp9_ = _protocol_it;
				if (!gee_iterator_next (_tmp9_)) {
					break;
				}
				_tmp10_ = _protocol_it;
				_tmp11_ = gee_iterator_get (_tmp10_);
				protocol = (gchar*) _tmp11_;
				_tmp12_ = persona;
				_tmp13_ = folks_im_details_get_im_addresses (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = protocol;
				_tmp16_ = gee_multi_map_get (_tmp14_, _tmp15_);
				im_fds = _tmp16_;
				{
					GeeIterator* _im_fd_it = NULL;
					GeeCollection* _tmp17_;
					GeeIterator* _tmp18_;
					_tmp17_ = im_fds;
					_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
					_im_fd_it = _tmp18_;
					while (TRUE) {
						GeeIterator* _tmp19_;
						FolksImFieldDetails* im_fd = NULL;
						GeeIterator* _tmp20_;
						gpointer _tmp21_;
						const gchar* _tmp22_;
						gchar* _tmp23_;
						gchar* _tmp24_;
						FolksImFieldDetails* _tmp25_;
						gconstpointer _tmp26_;
						gconstpointer _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
						_tmp19_ = _im_fd_it;
						if (!gee_iterator_next (_tmp19_)) {
							break;
						}
						_tmp20_ = _im_fd_it;
						_tmp21_ = gee_iterator_get (_tmp20_);
						im_fd = (FolksImFieldDetails*) _tmp21_;
						_tmp22_ = protocol;
						_tmp23_ = g_strconcat (_tmp22_, ":", NULL);
						_tmp24_ = _tmp23_;
						_tmp25_ = im_fd;
						_tmp26_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp25_);
						_tmp27_ = _tmp26_;
						_tmp28_ = g_strconcat (_tmp24_, (const gchar*) _tmp27_, NULL);
						_tmp29_ = _tmp28_;
						callback (_tmp29_, callback_target);
						_g_free0 (_tmp29_);
						_g_free0 (_tmp24_);
						_g_object_unref0 (im_fd);
					}
					_g_object_unref0 (_im_fd_it);
				}
				_g_object_unref0 (im_fds);
				_g_free0 (protocol);
			}
			_g_object_unref0 (_protocol_it);
		}
		_g_object_unref0 (persona);
	} else {
		if (g_strcmp0 (prop_name, "local-ids") == 0) {
			FolksLocalIdDetails* persona = NULL;
			FolksLocalIdDetails* _tmp30_;
			FolksLocalIdDetails* _tmp31_;
			_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (self, FOLKS_TYPE_LOCAL_ID_DETAILS) ? ((FolksLocalIdDetails*) self) : NULL);
			persona = _tmp30_;
			_tmp31_ = persona;
			_vala_assert (_tmp31_ != NULL, "persona != null");
			{
				GeeIterator* _id_it = NULL;
				FolksLocalIdDetails* _tmp32_;
				GeeSet* _tmp33_;
				GeeSet* _tmp34_;
				GeeIterator* _tmp35_;
				_tmp32_ = persona;
				_tmp33_ = folks_local_id_details_get_local_ids (_tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = gee_iterable_iterator ((GeeIterable*) _tmp34_);
				_id_it = _tmp35_;
				while (TRUE) {
					GeeIterator* _tmp36_;
					gchar* id = NULL;
					GeeIterator* _tmp37_;
					gpointer _tmp38_;
					const gchar* _tmp39_;
					_tmp36_ = _id_it;
					if (!gee_iterator_next (_tmp36_)) {
						break;
					}
					_tmp37_ = _id_it;
					_tmp38_ = gee_iterator_get (_tmp37_);
					id = (gchar*) _tmp38_;
					_tmp39_ = id;
					callback (_tmp39_, callback_target);
					_g_free0 (id);
				}
				_g_object_unref0 (_id_it);
			}
			_g_object_unref0 (persona);
		} else {
			if (g_strcmp0 (prop_name, "web-service-addresses") == 0) {
				FolksWebServiceDetails* persona = NULL;
				FolksWebServiceDetails* _tmp40_;
				FolksWebServiceDetails* _tmp41_;
				_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (self, FOLKS_TYPE_WEB_SERVICE_DETAILS) ? ((FolksWebServiceDetails*) self) : NULL);
				persona = _tmp40_;
				_tmp41_ = persona;
				_vala_assert (_tmp41_ != NULL, "persona != null");
				{
					GeeIterator* _web_service_it = NULL;
					FolksWebServiceDetails* _tmp42_;
					GeeMultiMap* _tmp43_;
					GeeMultiMap* _tmp44_;
					GeeSet* _tmp45_;
					GeeSet* _tmp46_;
					GeeIterator* _tmp47_;
					GeeIterator* _tmp48_;
					_tmp42_ = persona;
					_tmp43_ = folks_web_service_details_get_web_service_addresses (_tmp42_);
					_tmp44_ = _tmp43_;
					_tmp45_ = gee_multi_map_get_keys (_tmp44_);
					_tmp46_ = _tmp45_;
					_tmp47_ = gee_iterable_iterator ((GeeIterable*) _tmp46_);
					_tmp48_ = _tmp47_;
					_g_object_unref0 (_tmp46_);
					_web_service_it = _tmp48_;
					while (TRUE) {
						GeeIterator* _tmp49_;
						gchar* web_service = NULL;
						GeeIterator* _tmp50_;
						gpointer _tmp51_;
						GeeCollection* web_service_addresses = NULL;
						FolksWebServiceDetails* _tmp52_;
						GeeMultiMap* _tmp53_;
						GeeMultiMap* _tmp54_;
						const gchar* _tmp55_;
						GeeCollection* _tmp56_;
						_tmp49_ = _web_service_it;
						if (!gee_iterator_next (_tmp49_)) {
							break;
						}
						_tmp50_ = _web_service_it;
						_tmp51_ = gee_iterator_get (_tmp50_);
						web_service = (gchar*) _tmp51_;
						_tmp52_ = persona;
						_tmp53_ = folks_web_service_details_get_web_service_addresses (_tmp52_);
						_tmp54_ = _tmp53_;
						_tmp55_ = web_service;
						_tmp56_ = gee_multi_map_get (_tmp54_, _tmp55_);
						web_service_addresses = _tmp56_;
						{
							GeeIterator* _ws_fd_it = NULL;
							GeeCollection* _tmp57_;
							GeeIterator* _tmp58_;
							_tmp57_ = web_service_addresses;
							_tmp58_ = gee_iterable_iterator ((GeeIterable*) _tmp57_);
							_ws_fd_it = _tmp58_;
							while (TRUE) {
								GeeIterator* _tmp59_;
								FolksWebServiceFieldDetails* ws_fd = NULL;
								GeeIterator* _tmp60_;
								gpointer _tmp61_;
								const gchar* _tmp62_;
								gchar* _tmp63_;
								gchar* _tmp64_;
								FolksWebServiceFieldDetails* _tmp65_;
								gconstpointer _tmp66_;
								gconstpointer _tmp67_;
								gchar* _tmp68_;
								gchar* _tmp69_;
								_tmp59_ = _ws_fd_it;
								if (!gee_iterator_next (_tmp59_)) {
									break;
								}
								_tmp60_ = _ws_fd_it;
								_tmp61_ = gee_iterator_get (_tmp60_);
								ws_fd = (FolksWebServiceFieldDetails*) _tmp61_;
								_tmp62_ = web_service;
								_tmp63_ = g_strconcat (_tmp62_, ":", NULL);
								_tmp64_ = _tmp63_;
								_tmp65_ = ws_fd;
								_tmp66_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp65_);
								_tmp67_ = _tmp66_;
								_tmp68_ = g_strconcat (_tmp64_, (const gchar*) _tmp67_, NULL);
								_tmp69_ = _tmp68_;
								callback (_tmp69_, callback_target);
								_g_free0 (_tmp69_);
								_g_free0 (_tmp64_);
								_g_object_unref0 (ws_fd);
							}
							_g_object_unref0 (_ws_fd_it);
						}
						_g_object_unref0 (web_service_addresses);
						_g_free0 (web_service);
					}
					_g_object_unref0 (_web_service_it);
				}
				_g_object_unref0 (persona);
			} else {
				if (g_strcmp0 (prop_name, "email-addresses") == 0) {
					FolksEmailDetails* persona = NULL;
					FolksEmailDetails* _tmp70_;
					FolksEmailDetails* _tmp71_;
					_tmp70_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (self, FOLKS_TYPE_EMAIL_DETAILS) ? ((FolksEmailDetails*) self) : NULL);
					persona = _tmp70_;
					_tmp71_ = persona;
					_vala_assert (_tmp71_ != NULL, "persona != null");
					{
						GeeIterator* _email_it = NULL;
						FolksEmailDetails* _tmp72_;
						GeeSet* _tmp73_;
						GeeSet* _tmp74_;
						GeeIterator* _tmp75_;
						_tmp72_ = persona;
						_tmp73_ = folks_email_details_get_email_addresses (_tmp72_);
						_tmp74_ = _tmp73_;
						_tmp75_ = gee_iterable_iterator ((GeeIterable*) _tmp74_);
						_email_it = _tmp75_;
						while (TRUE) {
							GeeIterator* _tmp76_;
							FolksEmailFieldDetails* email = NULL;
							GeeIterator* _tmp77_;
							gpointer _tmp78_;
							FolksEmailFieldDetails* _tmp79_;
							gconstpointer _tmp80_;
							gconstpointer _tmp81_;
							_tmp76_ = _email_it;
							if (!gee_iterator_next (_tmp76_)) {
								break;
							}
							_tmp77_ = _email_it;
							_tmp78_ = gee_iterator_get (_tmp77_);
							email = (FolksEmailFieldDetails*) _tmp78_;
							_tmp79_ = email;
							_tmp80_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp79_);
							_tmp81_ = _tmp80_;
							callback ((const gchar*) _tmp81_, callback_target);
							_g_object_unref0 (email);
						}
						_g_object_unref0 (_email_it);
					}
					_g_object_unref0 (persona);
				} else {
					FOLKS_PERSONA_CLASS (folks_dummy_persona_parent_class)->linkable_property_to_links (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_PERSONA, FolksPersona), prop_name, callback, callback_target);
				}
			}
		}
	}
}

/**
   * Update the persona’s set of writeable properties.
   *
   * Update the {@link Folks.Persona.writeable_properties} property to contain
   * the union of {@link Folks.PersonaStore.always_writeable_properties} from
   * the persona’s store, and the given ``writeable_properties``.
   *
   * This should be used to simulate a change in the backing store for the
   * persona which affects the writeability of one or more of its properties.
   *
   * @since 0.9.7
   */
void
folks_dummy_persona_update_writeable_properties (FolksDummyPersona* self,
                                                 gchar** writeable_properties,
                                                 gint writeable_properties_length1)
{
	GeeHashSet* new_writeable_properties = NULL;
	GeeHashSet* _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksPersonaStore* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_ = 0;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gboolean changed = FALSE;
	gchar** _tmp12_;
	gint _tmp12__length1;
	GeeHashSet* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	new_writeable_properties = _tmp0_;
	_tmp1_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_persona_store_get_always_writeable_properties (_tmp2_, &_tmp4_);
	_tmp3__length1 = _tmp4_;
	_tmp5_ = _tmp3_;
	_tmp5__length1 = _tmp3__length1;
	{
		gchar** p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
		p_collection = _tmp5_;
		p_collection_length1 = _tmp5__length1;
		for (p_it = 0; p_it < p_collection_length1; p_it = p_it + 1) {
			gchar* _tmp6_;
			gchar* p = NULL;
			_tmp6_ = g_strdup (p_collection[p_it]);
			p = _tmp6_;
			{
				GeeHashSet* _tmp7_;
				const gchar* _tmp8_;
				_tmp7_ = new_writeable_properties;
				_tmp8_ = p;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp8_);
				_g_free0 (p);
			}
		}
	}
	{
		gchar** p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
		p_collection = writeable_properties;
		p_collection_length1 = writeable_properties_length1;
		for (p_it = 0; p_it < p_collection_length1; p_it = p_it + 1) {
			gchar* _tmp9_;
			gchar* p = NULL;
			_tmp9_ = g_strdup (p_collection[p_it]);
			p = _tmp9_;
			{
				GeeHashSet* _tmp10_;
				const gchar* _tmp11_;
				_tmp10_ = new_writeable_properties;
				_tmp11_ = p;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
				_g_free0 (p);
			}
		}
	}
	changed = FALSE;
	_tmp12_ = self->priv->_writeable_properties;
	_tmp12__length1 = self->priv->_writeable_properties_length1;
	_tmp13_ = new_writeable_properties;
	_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp12__length1 != _tmp15_) {
		changed = TRUE;
	} else {
		gchar** _tmp16_;
		gint _tmp16__length1;
		_tmp16_ = self->priv->_writeable_properties;
		_tmp16__length1 = self->priv->_writeable_properties_length1;
		{
			gchar** p_collection = NULL;
			gint p_collection_length1 = 0;
			gint _p_collection_size_ = 0;
			gint p_it = 0;
			p_collection = _tmp16_;
			p_collection_length1 = _tmp16__length1;
			for (p_it = 0; p_it < p_collection_length1; p_it = p_it + 1) {
				gchar* _tmp17_;
				gchar* p = NULL;
				_tmp17_ = g_strdup (p_collection[p_it]);
				p = _tmp17_;
				{
					GeeHashSet* _tmp18_;
					const gchar* _tmp19_;
					_tmp18_ = new_writeable_properties;
					_tmp19_ = p;
					if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp18_, _tmp19_) == FALSE) {
						changed = TRUE;
						_g_free0 (p);
						break;
					}
					_g_free0 (p);
				}
			}
		}
	}
	if (changed == TRUE) {
		GeeHashSet* _tmp20_;
		gint _tmp21_ = 0;
		gpointer* _tmp22_;
		_tmp20_ = new_writeable_properties;
		_tmp22_ = gee_collection_to_array ((GeeCollection*) _tmp20_, &_tmp21_);
		self->priv->_writeable_properties = (_vala_array_free (self->priv->_writeable_properties, self->priv->_writeable_properties_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_writeable_properties = _tmp22_;
		self->priv->_writeable_properties_length1 = _tmp21_;
		self->priv->__writeable_properties_size_ = self->priv->_writeable_properties_length1;
		g_object_notify ((GObject*) self, "writeable-properties");
	}
	_g_object_unref0 (new_writeable_properties);
}

/**
   * Update the persona’s set of linkable properties.
   *
   * Update the {@link Folks.Persona.linkable_properties} property to contain
   * the given ``linkable_properties``.
   *
   * @param linkable_properties new set of linkable property names, in lower
   * case, hyphenated form
   * @since 0.9.7
   */
static gchar**
_vala_array_dup4 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
folks_dummy_persona_update_linkable_properties (FolksDummyPersona* self,
                                                gchar** linkable_properties,
                                                gint linkable_properties_length1)
{
	FolksSmallSet* new_linkable_properties = NULL;
	FolksSmallSet* _tmp0_;
	FolksSmallSet* _tmp1_;
	FolksSmallSet* old_linkable_properties = NULL;
	FolksSmallSet* _tmp2_;
	FolksSmallSet* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	FolksSmallSet* _tmp5_;
	FolksSmallSet* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = folks_small_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	new_linkable_properties = _tmp0_;
	_tmp1_ = new_linkable_properties;
	gee_collection_add_all_array ((GeeCollection*) _tmp1_, linkable_properties, (gint) linkable_properties_length1);
	_tmp2_ = folks_small_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	old_linkable_properties = _tmp2_;
	_tmp3_ = old_linkable_properties;
	_tmp4_ = self->priv->_linkable_properties;
	_tmp4__length1 = self->priv->_linkable_properties_length1;
	gee_collection_add_all_array ((GeeCollection*) _tmp3_, _tmp4_, (gint) _tmp4__length1);
	_tmp5_ = old_linkable_properties;
	_tmp6_ = new_linkable_properties;
	if (!folks_internal_equal_sets (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, (GeeSet*) _tmp5_, (GeeSet*) _tmp6_)) {
		gchar** _tmp7_;
		gint _tmp7__length1;
		_tmp7_ = (linkable_properties != NULL) ? _vala_array_dup4 (linkable_properties, linkable_properties_length1) : linkable_properties;
		_tmp7__length1 = linkable_properties_length1;
		self->priv->_linkable_properties = (_vala_array_free (self->priv->_linkable_properties, self->priv->_linkable_properties_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_linkable_properties = _tmp7_;
		self->priv->_linkable_properties_length1 = _tmp7__length1;
		self->priv->__linkable_properties_size_ = self->priv->_linkable_properties_length1;
		g_object_notify ((GObject*) self, "linkable-properties");
	}
	_g_object_unref0 (old_linkable_properties);
	_g_object_unref0 (new_linkable_properties);
}

static void
folks_dummy_persona_change_property_data_free (gpointer _data)
{
	FolksDummyPersonaChangePropertyData* _data_;
	_data_ = _data;
	_g_free0 (_data_->property_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksDummyPersonaChangePropertyData, _data_);
}

void
folks_dummy_persona_change_property (FolksDummyPersona* self,
                                     const gchar* property_name,
                                     FolksDummyPersonaChangePropertyCallback callback,
                                     gpointer callback_target,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	FolksDummyPersonaChangePropertyData* _data_;
	FolksDummyPersona* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (property_name != NULL);
	_data_ = g_slice_new0 (FolksDummyPersonaChangePropertyData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_dummy_persona_change_property_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (property_name);
	_g_free0 (_data_->property_name);
	_data_->property_name = _tmp1_;
	_data_->callback = callback;
	_data_->callback_target = callback_target;
	folks_dummy_persona_change_property_co (_data_);
}

void
folks_dummy_persona_change_property_finish (FolksDummyPersona* self,
                                            GAsyncResult* _res_)
{
	FolksDummyPersonaChangePropertyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
   * Change a property in the simulated backing store.
   *
   * This triggers a property change in the simulated backing store, applying
   * the current {@link FolksDummy.Persona.property_change_delay} before calling
   * the given ``callback`` which should actually effect the property change.
   *
   * @param property_name name of the property being changed
   * @param callback callback to call once the change delay has passed
   * @since 0.9.7
   */
static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}

static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		FolksDummyPersona* self;
		self = _data21_->self;
		_g_object_unref0 (self);
		g_slice_free (Block21Data, _data21_);
	}
}

static gboolean
____lambda4_ (Block21Data* _data21_)
{
	FolksDummyPersona* self;
	gboolean result;
	self = _data21_->self;
	_data21_->callback (_data21_->callback_target);
	folks_dummy_persona_change_property_co (_data21_->_async_data_);
	result = FALSE;
	return result;
}

static gboolean
_____lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda4_ (self);
	return result;
}

static gboolean
____lambda5_ (Block21Data* _data21_)
{
	FolksDummyPersona* self;
	gboolean result;
	self = _data21_->self;
	_data21_->callback (_data21_->callback_target);
	folks_dummy_persona_change_property_co (_data21_->_async_data_);
	result = FALSE;
	return result;
}

static gboolean
_____lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda5_ (self);
	return result;
}

static gboolean
folks_dummy_persona_change_property_co (FolksDummyPersonaChangePropertyData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data21_ = g_slice_new0 (Block21Data);
	_data_->_data21_->_ref_count_ = 1;
	_data_->_data21_->self = g_object_ref (_data_->self);
	_data_->_data21_->callback = _data_->callback;
	_data_->_data21_->callback_target = _data_->callback_target;
	_data_->_data21_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->_property_change_delay;
	if (_data_->_tmp0_ < 0) {
		_data_->_data21_->callback (_data_->_data21_->callback_target);
	} else {
		_data_->_tmp1_ = _data_->self->priv->_property_change_delay;
		if (_data_->_tmp1_ == 0) {
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _____lambda4__gsource_func, block21_data_ref (_data_->_data21_), block21_data_unref);
			_data_->_state_ = 1;
			return FALSE;
			_state_1:
			;
		} else {
			_data_->_tmp2_ = _data_->self->priv->_property_change_delay;
			g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _data_->_tmp2_, _____lambda5__gsource_func, block21_data_ref (_data_->_data21_), block21_data_unref);
			_data_->_state_ = 2;
			return FALSE;
			_state_2:
			;
		}
	}
	block21_data_unref (_data_->_data21_);
	_data_->_data21_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar**
folks_dummy_persona_real_get_linkable_properties (FolksPersona* base,
                                                  gint* result_length1)
{
	gchar** result;
	FolksDummyPersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = (FolksDummyPersona*) base;
	_tmp0_ = self->priv->_linkable_properties;
	_tmp0__length1 = self->priv->_linkable_properties_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
folks_dummy_persona_real_get_writeable_properties (FolksPersona* base,
                                                   gint* result_length1)
{
	gchar** result;
	FolksDummyPersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = (FolksDummyPersona*) base;
	_tmp0_ = self->priv->_writeable_properties;
	_tmp0__length1 = self->priv->_writeable_properties_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

gint
folks_dummy_persona_get_property_change_delay (FolksDummyPersona* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_property_change_delay;
	return result;
}

void
folks_dummy_persona_set_property_change_delay (FolksDummyPersona* self,
                                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = folks_dummy_persona_get_property_change_delay (self);
	if (old_value != value) {
		self->priv->_property_change_delay = value;
		g_object_notify_by_pspec ((GObject *) self, folks_dummy_persona_properties[FOLKS_DUMMY_PERSONA_PROPERTY_CHANGE_DELAY_PROPERTY]);
	}
}

static void
folks_dummy_persona_class_init (FolksDummyPersonaClass * klass,
                                gpointer klass_data)
{
	folks_dummy_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksDummyPersona_private_offset);
	((FolksPersonaClass *) klass)->linkable_property_to_links = (void (*) (FolksPersona*, const gchar*, FolksPersonaLinkablePropertyCallback, gpointer)) folks_dummy_persona_real_linkable_property_to_links;
	FOLKS_PERSONA_CLASS (klass)->get_linkable_properties = (gchar** (*) (FolksPersona*, gint*)) folks_dummy_persona_real_get_linkable_properties;
	FOLKS_PERSONA_CLASS (klass)->get_writeable_properties = (gchar** (*) (FolksPersona*, gint*)) folks_dummy_persona_real_get_writeable_properties;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_dummy_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_dummy_persona_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_dummy_persona_finalize;
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_LINKABLE_PROPERTIES_PROPERTY, folks_dummy_persona_properties[FOLKS_DUMMY_PERSONA_LINKABLE_PROPERTIES_PROPERTY] = g_param_spec_boxed ("linkable-properties", "linkable-properties", "linkable-properties", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_WRITEABLE_PROPERTIES_PROPERTY, folks_dummy_persona_properties[FOLKS_DUMMY_PERSONA_WRITEABLE_PROPERTIES_PROPERTY] = g_param_spec_boxed ("writeable-properties", "writeable-properties", "writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Delay between property changes and notifications.
	   *
	   * This sets an optional delay between client code requesting a property
	   * change (e.g. by calling {@link Folks.NameDetails.change_nickname}) and the
	   * property change taking place and a {@link Object.notify} signal being
	   * emitted for it.
	   *
	   * Delays are in milliseconds. Negative delays mean that property change
	   * notifications happen synchronously in the change method. A delay of 0
	   * means that property change notifications happen in an idle callback
	   * immediately after the change method. A positive delay means that property
	   * change notifications happen that many milliseconds after the change method
	   * is called.
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_PROPERTY_CHANGE_DELAY_PROPERTY, folks_dummy_persona_properties[FOLKS_DUMMY_PERSONA_PROPERTY_CHANGE_DELAY_PROPERTY] = g_param_spec_int ("property-change-delay", "property-change-delay", "property-change-delay", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
folks_dummy_persona_instance_init (FolksDummyPersona * self,
                                   gpointer klass)
{
	gchar** _tmp0_;
	gchar** _tmp1_;
	self->priv = folks_dummy_persona_get_instance_private (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->priv->_linkable_properties = _tmp0_;
	self->priv->_linkable_properties_length1 = 0;
	self->priv->__linkable_properties_size_ = self->priv->_linkable_properties_length1;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	self->priv->_writeable_properties = _tmp1_;
	self->priv->_writeable_properties_length1 = 0;
	self->priv->__writeable_properties_size_ = self->priv->_writeable_properties_length1;
	self->priv->_property_change_delay = 0;
}

static void
folks_dummy_persona_finalize (GObject * obj)
{
	FolksDummyPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_DUMMY_TYPE_PERSONA, FolksDummyPersona);
	self->priv->_linkable_properties = (_vala_array_free (self->priv->_linkable_properties, self->priv->_linkable_properties_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_writeable_properties = (_vala_array_free (self->priv->_writeable_properties, self->priv->_writeable_properties_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (folks_dummy_persona_parent_class)->finalize (obj);
}

/**
 * A persona subclass representing a single contact.
 *
 * This mocks up a ‘thin’ persona which implements none of the available
 * property interfaces provided by libfolks, and is designed as a base class to
 * be subclassed by personas which will implement one or more of these
 * interfaces. For example, {@link FolksDummy.FullPersona} is one such subclass
 * which implements all available interfaces.
 *
 * There are two sides to this class’ interface: the normal methods required by
 * {@link Folks.Persona}, such as
 * {@link Folks.Persona.linkable_property_to_links},
 * and the backend methods which should be called by test driver code to
 * simulate changes in the backing store providing this persona, such as
 * {@link FolksDummy.Persona.update_writeable_properties}. The ``update_``,
 * ``register_`` and ``unregister_`` prefixes are commonly used for backend
 * methods.
 *
 * All property changes for contact details of subclasses of
 * {@link FolksDummy.Persona} have a configurable delay before taking effect,
 * which can be controlled by {@link FolksDummy.Persona.property_change_delay}.
 *
 * The API in {@link FolksDummy} is unstable and may change wildly. It is
 * designed mostly for use by libfolks unit tests.
 *
 * @since 0.9.7
 */
static GType
folks_dummy_persona_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksDummyPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_dummy_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksDummyPersona), 0, (GInstanceInitFunc) folks_dummy_persona_instance_init, NULL };
	GType folks_dummy_persona_type_id;
	folks_dummy_persona_type_id = g_type_register_static (FOLKS_TYPE_PERSONA, "FolksDummyPersona", &g_define_type_info, 0);
	FolksDummyPersona_private_offset = g_type_add_instance_private (folks_dummy_persona_type_id, sizeof (FolksDummyPersonaPrivate));
	return folks_dummy_persona_type_id;
}

GType
folks_dummy_persona_get_type (void)
{
	static volatile gsize folks_dummy_persona_type_id__once = 0;
	if (g_once_init_enter (&folks_dummy_persona_type_id__once)) {
		GType folks_dummy_persona_type_id;
		folks_dummy_persona_type_id = folks_dummy_persona_get_type_once ();
		g_once_init_leave (&folks_dummy_persona_type_id__once, folks_dummy_persona_type_id);
	}
	return folks_dummy_persona_type_id__once;
}

static void
_vala_folks_dummy_persona_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	FolksDummyPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_DUMMY_TYPE_PERSONA, FolksDummyPersona);
	switch (property_id) {
		case FOLKS_DUMMY_PERSONA_LINKABLE_PROPERTIES_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_linkable_properties ((FolksPersona*) self, &length));
		}
		break;
		case FOLKS_DUMMY_PERSONA_WRITEABLE_PROPERTIES_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_writeable_properties ((FolksPersona*) self, &length));
		}
		break;
		case FOLKS_DUMMY_PERSONA_PROPERTY_CHANGE_DELAY_PROPERTY:
		g_value_set_int (value, folks_dummy_persona_get_property_change_delay (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folks_dummy_persona_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	FolksDummyPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_DUMMY_TYPE_PERSONA, FolksDummyPersona);
	switch (property_id) {
		case FOLKS_DUMMY_PERSONA_PROPERTY_CHANGE_DELAY_PROPERTY:
		folks_dummy_persona_set_property_change_delay (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

