//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcontainerservice

import "time"

// AccessProfile - Profile for enabling a user to access a managed cluster.
type AccessProfile struct {
	// Base64-encoded Kubernetes configuration file.
	KubeConfig []byte `json:"kubeConfig,omitempty"`
}

// AgentPool - Agent Pool.
type AgentPool struct {
	// Properties of an agent pool.
	Properties *ManagedClusterAgentPoolProfileProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AgentPoolAvailableVersions - The list of available versions for an agent pool.
type AgentPoolAvailableVersions struct {
	// REQUIRED; Properties of agent pool available versions.
	Properties *AgentPoolAvailableVersionsProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the agent pool version list.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the agent pool version list.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of the agent pool version list.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AgentPoolAvailableVersionsProperties - The list of available agent pool versions.
type AgentPoolAvailableVersionsProperties struct {
	// List of versions available for agent pool.
	AgentPoolVersions []*AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem `json:"agentPoolVersions,omitempty"`
}

type AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem struct {
	// Whether this version is the default agent pool version.
	Default *bool `json:"default,omitempty"`

	// Whether Kubernetes version is currently in preview.
	IsPreview *bool `json:"isPreview,omitempty"`

	// The Kubernetes version (major.minor.patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
}

// AgentPoolListResult - The response from the List Agent Pools operation.
type AgentPoolListResult struct {
	// The list of agent pools.
	Value []*AgentPool `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of agent pool results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// AgentPoolUpgradeProfile - The list of available upgrades for an agent pool.
type AgentPoolUpgradeProfile struct {
	// REQUIRED; The properties of the agent pool upgrade profile.
	Properties *AgentPoolUpgradeProfileProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the agent pool upgrade profile.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the agent pool upgrade profile.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the agent pool upgrade profile.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AgentPoolUpgradeProfileProperties - The list of available upgrade versions.
type AgentPoolUpgradeProfileProperties struct {
	// REQUIRED; The Kubernetes version (major.minor.patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`

	// REQUIRED; The operating system type. The default is Linux.
	OSType *OSType `json:"osType,omitempty"`

	// The latest AKS supported node image version.
	LatestNodeImageVersion *string `json:"latestNodeImageVersion,omitempty"`

	// List of orchestrator types and versions available for upgrade.
	Upgrades []*AgentPoolUpgradeProfilePropertiesUpgradesItem `json:"upgrades,omitempty"`
}

type AgentPoolUpgradeProfilePropertiesUpgradesItem struct {
	// Whether the Kubernetes version is currently in preview.
	IsPreview *bool `json:"isPreview,omitempty"`

	// The Kubernetes version (major.minor.patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
}

// AgentPoolUpgradeSettings - Settings for upgrading an agentpool
type AgentPoolUpgradeSettings struct {
	// This can either be set to an integer (e.g. '5') or a percentage (e.g. '50%'). If a percentage is specified, it is the percentage
	// of the total agent pool size at the time of the upgrade. For
	// percentages, fractional nodes are rounded up. If not specified, the default is 1. For more information, including best
	// practices, see:
	// https://docs.microsoft.com/azure/aks/upgrade-cluster#customize-node-surge-upgrade
	MaxSurge *string `json:"maxSurge,omitempty"`
}

// AgentPoolsClientBeginCreateOrUpdateOptions contains the optional parameters for the AgentPoolsClient.BeginCreateOrUpdate
// method.
type AgentPoolsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AgentPoolsClientBeginDeleteOptions contains the optional parameters for the AgentPoolsClient.BeginDelete method.
type AgentPoolsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AgentPoolsClientBeginUpgradeNodeImageVersionOptions contains the optional parameters for the AgentPoolsClient.BeginUpgradeNodeImageVersion
// method.
type AgentPoolsClientBeginUpgradeNodeImageVersionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AgentPoolsClientGetAvailableAgentPoolVersionsOptions contains the optional parameters for the AgentPoolsClient.GetAvailableAgentPoolVersions
// method.
type AgentPoolsClientGetAvailableAgentPoolVersionsOptions struct {
	// placeholder for future optional parameters
}

// AgentPoolsClientGetOptions contains the optional parameters for the AgentPoolsClient.Get method.
type AgentPoolsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AgentPoolsClientGetUpgradeProfileOptions contains the optional parameters for the AgentPoolsClient.GetUpgradeProfile method.
type AgentPoolsClientGetUpgradeProfileOptions struct {
	// placeholder for future optional parameters
}

// AgentPoolsClientListOptions contains the optional parameters for the AgentPoolsClient.List method.
type AgentPoolsClientListOptions struct {
	// placeholder for future optional parameters
}

// CloudError - An error response from the Container service.
type CloudError struct {
	// Details about the error.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody - An error response from the Container service.
type CloudErrorBody struct {
	// An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`

	// A list of additional details about the error.
	Details []*CloudErrorBody `json:"details,omitempty"`

	// A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`

	// The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
}

// CommandResultProperties - The results of a run command
type CommandResultProperties struct {
	// READ-ONLY; The exit code of the command
	ExitCode *int32 `json:"exitCode,omitempty" azure:"ro"`

	// READ-ONLY; The time when the command finished.
	FinishedAt *time.Time `json:"finishedAt,omitempty" azure:"ro"`

	// READ-ONLY; The command output.
	Logs *string `json:"logs,omitempty" azure:"ro"`

	// READ-ONLY; provisioning State
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; An explanation of why provisioningState is set to failed (if so).
	Reason *string `json:"reason,omitempty" azure:"ro"`

	// READ-ONLY; The time when the command started.
	StartedAt *time.Time `json:"startedAt,omitempty" azure:"ro"`
}

// CreationData - Data used when creating a target resource from a source resource.
type CreationData struct {
	// This is the ARM ID of the source object to be used to create the target object.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
}

// CredentialResult - The credential result response.
type CredentialResult struct {
	// READ-ONLY; The name of the credential.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Base64-encoded Kubernetes configuration file.
	Value []byte `json:"value,omitempty" azure:"ro"`
}

// CredentialResults - The list credential result response.
type CredentialResults struct {
	// READ-ONLY; Base64-encoded Kubernetes configuration file.
	Kubeconfigs []*CredentialResult `json:"kubeconfigs,omitempty" azure:"ro"`
}

// DiagnosticsProfile - Profile for diagnostics on the container service cluster.
type DiagnosticsProfile struct {
	// REQUIRED; Profile for diagnostics on the container service VMs.
	VMDiagnostics *VMDiagnostics `json:"vmDiagnostics,omitempty"`
}

// EndpointDependency - A domain name that AKS agent nodes are reaching at.
type EndpointDependency struct {
	// The domain name of the dependency.
	DomainName *string `json:"domainName,omitempty"`

	// The Ports and Protocols used when connecting to domainName.
	EndpointDetails []*EndpointDetail `json:"endpointDetails,omitempty"`
}

// EndpointDetail - connect information from the AKS agent nodes to a single endpoint.
type EndpointDetail struct {
	// Description of the detail
	Description *string `json:"description,omitempty"`

	// An IP Address that Domain Name currently resolves to.
	IPAddress *string `json:"ipAddress,omitempty"`

	// The port an endpoint is connected to.
	Port *int32 `json:"port,omitempty"`

	// The protocol used for connection
	Protocol *string `json:"protocol,omitempty"`
}

// ExtendedLocation - The complex type of the extended location.
type ExtendedLocation struct {
	// The name of the extended location.
	Name *string `json:"name,omitempty"`

	// The type of the extended location.
	Type *ExtendedLocationTypes `json:"type,omitempty"`
}

// KubeletConfig - See AKS custom node configuration [https://docs.microsoft.com/azure/aks/custom-node-configuration] for
// more details.
type KubeletConfig struct {
	// Allowed list of unsafe sysctls or unsafe sysctl patterns (ending in *).
	AllowedUnsafeSysctls []*string `json:"allowedUnsafeSysctls,omitempty"`

	// The default is true.
	CPUCfsQuota *bool `json:"cpuCfsQuota,omitempty"`

	// The default is '100ms.' Valid values are a sequence of decimal numbers with an optional fraction and a unit suffix. For
	// example: '300ms', '2h45m'. Supported units are 'ns', 'us', 'ms', 's', 'm', and
	// 'h'.
	CPUCfsQuotaPeriod *string `json:"cpuCfsQuotaPeriod,omitempty"`

	// The default is 'none'. See Kubernetes CPU management policies [https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/#cpu-management-policies]
	// for more information. Allowed
	// values are 'none' and 'static'.
	CPUManagerPolicy *string `json:"cpuManagerPolicy,omitempty"`

	// The maximum number of container log files that can be present for a container. The number must be ≥ 2.
	ContainerLogMaxFiles *int32 `json:"containerLogMaxFiles,omitempty"`

	// The maximum size (e.g. 10Mi) of container log file before it is rotated.
	ContainerLogMaxSizeMB *int32 `json:"containerLogMaxSizeMB,omitempty"`

	// If set to true it will make the Kubelet fail to start if swap is enabled on the node.
	FailSwapOn *bool `json:"failSwapOn,omitempty"`

	// To disable image garbage collection, set to 100. The default is 85%
	ImageGcHighThreshold *int32 `json:"imageGcHighThreshold,omitempty"`

	// This cannot be set higher than imageGcHighThreshold. The default is 80%
	ImageGcLowThreshold *int32 `json:"imageGcLowThreshold,omitempty"`

	// The maximum number of processes per pod.
	PodMaxPids *int32 `json:"podMaxPids,omitempty"`

	// For more information see Kubernetes Topology Manager [https://kubernetes.io/docs/tasks/administer-cluster/topology-manager].
	// The default is 'none'. Allowed values are 'none', 'best-effort',
	// 'restricted', and 'single-numa-node'.
	TopologyManagerPolicy *string `json:"topologyManagerPolicy,omitempty"`
}

// LinuxOSConfig - See AKS custom node configuration [https://docs.microsoft.com/azure/aks/custom-node-configuration] for
// more details.
type LinuxOSConfig struct {
	// The size in MB of a swap file that will be created on each node.
	SwapFileSizeMB *int32 `json:"swapFileSizeMB,omitempty"`

	// Sysctl settings for Linux agent nodes.
	Sysctls *SysctlConfig `json:"sysctls,omitempty"`

	// Valid values are 'always', 'defer', 'defer+madvise', 'madvise' and 'never'. The default is 'madvise'. For more information
	// see Transparent Hugepages
	// [https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge].
	TransparentHugePageDefrag *string `json:"transparentHugePageDefrag,omitempty"`

	// Valid values are 'always', 'madvise', and 'never'. The default is 'always'. For more information see Transparent Hugepages
	// [https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge].
	TransparentHugePageEnabled *string `json:"transparentHugePageEnabled,omitempty"`
}

// LinuxProfile - Profile for Linux VMs in the container service cluster.
type LinuxProfile struct {
	// REQUIRED; The administrator username to use for Linux VMs.
	AdminUsername *string `json:"adminUsername,omitempty"`

	// REQUIRED; The SSH configuration for Linux-based VMs running on Azure.
	SSH *SSHConfiguration `json:"ssh,omitempty"`
}

// MaintenanceConfiguration - See planned maintenance [https://docs.microsoft.com/azure/aks/planned-maintenance] for more
// information about planned maintenance.
type MaintenanceConfiguration struct {
	// Properties of a default maintenance configuration.
	Properties *MaintenanceConfigurationProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MaintenanceConfigurationListResult - The response from the List maintenance configurations operation.
type MaintenanceConfigurationListResult struct {
	// The list of maintenance configurations.
	Value []*MaintenanceConfiguration `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of maintenance configuration results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// MaintenanceConfigurationProperties - Properties used to configure planned maintenance for a Managed Cluster.
type MaintenanceConfigurationProperties struct {
	// Time slots on which upgrade is not allowed.
	NotAllowedTime []*TimeSpan `json:"notAllowedTime,omitempty"`

	// If two array entries specify the same day of the week, the applied configuration is the union of times in both entries.
	TimeInWeek []*TimeInWeek `json:"timeInWeek,omitempty"`
}

// MaintenanceConfigurationsClientCreateOrUpdateOptions contains the optional parameters for the MaintenanceConfigurationsClient.CreateOrUpdate
// method.
type MaintenanceConfigurationsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// MaintenanceConfigurationsClientDeleteOptions contains the optional parameters for the MaintenanceConfigurationsClient.Delete
// method.
type MaintenanceConfigurationsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// MaintenanceConfigurationsClientGetOptions contains the optional parameters for the MaintenanceConfigurationsClient.Get
// method.
type MaintenanceConfigurationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// MaintenanceConfigurationsClientListByManagedClusterOptions contains the optional parameters for the MaintenanceConfigurationsClient.ListByManagedCluster
// method.
type MaintenanceConfigurationsClientListByManagedClusterOptions struct {
	// placeholder for future optional parameters
}

// ManagedCluster - Managed cluster.
type ManagedCluster struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The extended location of the Virtual Machine.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// The identity of the managed cluster, if configured.
	Identity *ManagedClusterIdentity `json:"identity,omitempty"`

	// Properties of a managed cluster.
	Properties *ManagedClusterProperties `json:"properties,omitempty"`

	// The managed cluster SKU.
	SKU *ManagedClusterSKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedClusterAADProfile - For more details see managed AAD on AKS [https://docs.microsoft.com/azure/aks/managed-aad].
type ManagedClusterAADProfile struct {
	// The list of AAD group object IDs that will have admin role of the cluster.
	AdminGroupObjectIDs []*string `json:"adminGroupObjectIDs,omitempty"`

	// The client AAD application ID.
	ClientAppID *string `json:"clientAppID,omitempty"`

	// Whether to enable Azure RBAC for Kubernetes authorization.
	EnableAzureRBAC *bool `json:"enableAzureRBAC,omitempty"`

	// Whether to enable managed AAD.
	Managed *bool `json:"managed,omitempty"`

	// The server AAD application ID.
	ServerAppID *string `json:"serverAppID,omitempty"`

	// The server AAD application secret.
	ServerAppSecret *string `json:"serverAppSecret,omitempty"`

	// The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription.
	TenantID *string `json:"tenantID,omitempty"`
}

// ManagedClusterAPIServerAccessProfile - Access profile for managed cluster API server.
type ManagedClusterAPIServerAccessProfile struct {
	// IP ranges are specified in CIDR format, e.g. 137.117.106.88/29. This feature is not compatible with clusters that use Public
	// IP Per Node, or clusters that are using a Basic Load Balancer. For more
	// information see API server authorized IP ranges [https://docs.microsoft.com/azure/aks/api-server-authorized-ip-ranges].
	AuthorizedIPRanges []*string `json:"authorizedIPRanges,omitempty"`

	// Whether to disable run command for the cluster or not.
	DisableRunCommand *bool `json:"disableRunCommand,omitempty"`

	// For more details, see Creating a private AKS cluster [https://docs.microsoft.com/azure/aks/private-clusters].
	EnablePrivateCluster *bool `json:"enablePrivateCluster,omitempty"`

	// Whether to create additional public FQDN for private cluster or not.
	EnablePrivateClusterPublicFQDN *bool `json:"enablePrivateClusterPublicFQDN,omitempty"`

	// The default is System. For more details see configure private DNS zone [https://docs.microsoft.com/azure/aks/private-clusters#configure-private-dns-zone].
	// Allowed values are 'system' and 'none'.
	PrivateDNSZone *string `json:"privateDNSZone,omitempty"`
}

// ManagedClusterAccessProfile - Managed cluster Access Profile.
type ManagedClusterAccessProfile struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// AccessProfile of a managed cluster.
	Properties *AccessProfile `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedClusterAddonProfile - A Kubernetes add-on profile for a managed cluster.
type ManagedClusterAddonProfile struct {
	// REQUIRED; Whether the add-on is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`

	// Key-value pairs for configuring an add-on.
	Config map[string]*string `json:"config,omitempty"`

	// READ-ONLY; Information of user assigned identity used by this add-on.
	Identity *ManagedClusterAddonProfileIdentity `json:"identity,omitempty" azure:"ro"`
}

// ManagedClusterAddonProfileIdentity - Information of user assigned identity used by this add-on.
type ManagedClusterAddonProfileIdentity struct {
	// The client ID of the user assigned identity.
	ClientID *string `json:"clientId,omitempty"`

	// The object ID of the user assigned identity.
	ObjectID *string `json:"objectId,omitempty"`

	// The resource ID of the user assigned identity.
	ResourceID *string `json:"resourceId,omitempty"`
}

// ManagedClusterAgentPoolProfile - Profile for the container service agent pool.
type ManagedClusterAgentPoolProfile struct {
	// REQUIRED; Windows agent pool names must be 6 characters or less.
	Name *string `json:"name,omitempty"`

	// The list of Availability zones to use for nodes. This can only be specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
	AvailabilityZones []*string `json:"availabilityZones,omitempty"`

	// Number of agents (VMs) to host docker containers. Allowed values must be in the range of 0 to 1000 (inclusive) for user
	// pools and in the range of 1 to 1000 (inclusive) for system pools. The default
	// value is 1.
	Count *int32 `json:"count,omitempty"`

	// CreationData to be used to specify the source Snapshot ID if the node pool will be created/upgraded using a snapshot.
	CreationData *CreationData `json:"creationData,omitempty"`

	// Whether to enable auto-scaler
	EnableAutoScaling *bool `json:"enableAutoScaling,omitempty"`

	// This is only supported on certain VM sizes and in certain Azure regions. For more information, see: https://docs.microsoft.com/azure/aks/enable-host-encryption
	EnableEncryptionAtHost *bool `json:"enableEncryptionAtHost,omitempty"`

	// See Add a FIPS-enabled node pool [https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview]
	// for more details.
	EnableFIPS *bool `json:"enableFIPS,omitempty"`

	// Some scenarios may require nodes in a node pool to receive their own dedicated public IP addresses. A common scenario is
	// for gaming workloads, where a console needs to make a direct connection to a
	// cloud virtual machine to minimize hops. For more information see assigning a public IP per node
	// [https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools]. The default
	// is false.
	EnableNodePublicIP *bool `json:"enableNodePublicIP,omitempty"`

	// Whether to enable UltraSSD
	EnableUltraSSD *bool `json:"enableUltraSSD,omitempty"`

	// GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU.
	GpuInstanceProfile *GPUInstanceProfile `json:"gpuInstanceProfile,omitempty"`

	// The Kubelet configuration on the agent pool nodes.
	KubeletConfig *KubeletConfig `json:"kubeletConfig,omitempty"`

	// Determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage.
	KubeletDiskType *KubeletDiskType `json:"kubeletDiskType,omitempty"`

	// The OS configuration of Linux agent nodes.
	LinuxOSConfig *LinuxOSConfig `json:"linuxOSConfig,omitempty"`

	// The maximum number of nodes for auto-scaling
	MaxCount *int32 `json:"maxCount,omitempty"`

	// The maximum number of pods that can run on a node.
	MaxPods *int32 `json:"maxPods,omitempty"`

	// The minimum number of nodes for auto-scaling
	MinCount *int32 `json:"minCount,omitempty"`

	// A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool restrictions
	// and best practices, see: https://docs.microsoft.com/azure/aks/use-system-pools
	Mode *AgentPoolMode `json:"mode,omitempty"`

	// The node labels to be persisted across all nodes in agent pool.
	NodeLabels map[string]*string `json:"nodeLabels,omitempty"`

	// This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}
	NodePublicIPPrefixID *string `json:"nodePublicIPPrefixID,omitempty"`

	// The taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
	NodeTaints []*string `json:"nodeTaints,omitempty"`

	// OS Disk Size in GB to be used to specify the disk size for every machine in the master/agent pool. If you specify 0, it
	// will apply the default osDisk size according to the vmSize specified.
	OSDiskSizeGB *int32 `json:"osDiskSizeGB,omitempty"`

	// The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB. Otherwise,
	// defaults to 'Managed'. May not be changed after creation. For more information
	// see Ephemeral OS [https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os].
	OSDiskType *OSDiskType `json:"osDiskType,omitempty"`

	// Specifies an OS SKU. This value must not be specified if OSType is Windows.
	OSSKU *OSSKU `json:"osSKU,omitempty"`

	// The operating system type. The default is Linux.
	OSType *OSType `json:"osType,omitempty"`

	// Both patch version (e.g. 1.20.13) and (e.g. 1.20) are supported. When is specified, the latest supported GA patch version
	// is chosen automatically. Updating the cluster with the same once it has been
	// created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a newer patch version is available. As a best practice,
	// you should upgrade all node pools in an AKS cluster to the same Kubernetes
	// version. The node pool version must have the same major version as the control plane. The node pool minor version must
	// be within two minor versions of the control plane version. The node pool version
	// cannot be greater than the control plane version. For more information see upgrading a node pool [https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool].
	OrchestratorVersion *string `json:"orchestratorVersion,omitempty"`

	// If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID for more details). This is of the form:
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
	PodSubnetID *string `json:"podSubnetID,omitempty"`

	// When an Agent Pool is first created it is initially Running. The Agent Pool can be stopped by setting this field to Stopped.
	// A stopped Agent Pool stops all of its VMs and does not accrue billing
	// charges. An Agent Pool can only be stopped if it is Running and provisioning state is Succeeded
	PowerState *PowerState `json:"powerState,omitempty"`

	// The ID for Proximity Placement Group.
	ProximityPlacementGroupID *string `json:"proximityPlacementGroupID,omitempty"`

	// This also effects the cluster autoscaler behavior. If not specified, it defaults to Delete.
	ScaleDownMode *ScaleDownMode `json:"scaleDownMode,omitempty"`

	// This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'.
	ScaleSetEvictionPolicy *ScaleSetEvictionPolicy `json:"scaleSetEvictionPolicy,omitempty"`

	// The Virtual Machine Scale Set priority. If not specified, the default is 'Regular'.
	ScaleSetPriority *ScaleSetPriority `json:"scaleSetPriority,omitempty"`

	// Possible values are any decimal value greater than zero or -1 which indicates the willingness to pay any on-demand price.
	// For more details on spot pricing, see spot VMs pricing
	// [https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing]
	SpotMaxPrice *float32 `json:"spotMaxPrice,omitempty"`

	// The tags to be persisted on the agent pool virtual machine scale set.
	Tags map[string]*string `json:"tags,omitempty"`

	// The type of Agent Pool.
	Type *AgentPoolType `json:"type,omitempty"`

	// Settings for upgrading the agentpool
	UpgradeSettings *AgentPoolUpgradeSettings `json:"upgradeSettings,omitempty"`

	// VM size availability varies by region. If a node contains insufficient compute resources (memory, cpu, etc) pods might
	// fail to run correctly. For more details on restricted VM sizes, see:
	// https://docs.microsoft.com/azure/aks/quotas-skus-regions
	VMSize *string `json:"vmSize,omitempty"`

	// If this is not specified, a VNET and subnet will be generated and used. If no podSubnetID is specified, this applies to
	// nodes and pods, otherwise it applies to just nodes. This is of the form:
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
	VnetSubnetID *string `json:"vnetSubnetID,omitempty"`

	// Determines the type of workload a node can run.
	WorkloadRuntime *WorkloadRuntime `json:"workloadRuntime,omitempty"`

	// READ-ONLY; If orchestratorVersion is a fully specified version , this field will be exactly equal to it. If orchestratorVersion
	// is , this field will contain the full version being used.
	CurrentOrchestratorVersion *string `json:"currentOrchestratorVersion,omitempty" azure:"ro"`

	// READ-ONLY; The version of node image
	NodeImageVersion *string `json:"nodeImageVersion,omitempty" azure:"ro"`

	// READ-ONLY; The current deployment or provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ManagedClusterAgentPoolProfileProperties - Properties for the container service agent pool profile.
type ManagedClusterAgentPoolProfileProperties struct {
	// The list of Availability zones to use for nodes. This can only be specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
	AvailabilityZones []*string `json:"availabilityZones,omitempty"`

	// Number of agents (VMs) to host docker containers. Allowed values must be in the range of 0 to 1000 (inclusive) for user
	// pools and in the range of 1 to 1000 (inclusive) for system pools. The default
	// value is 1.
	Count *int32 `json:"count,omitempty"`

	// CreationData to be used to specify the source Snapshot ID if the node pool will be created/upgraded using a snapshot.
	CreationData *CreationData `json:"creationData,omitempty"`

	// Whether to enable auto-scaler
	EnableAutoScaling *bool `json:"enableAutoScaling,omitempty"`

	// This is only supported on certain VM sizes and in certain Azure regions. For more information, see: https://docs.microsoft.com/azure/aks/enable-host-encryption
	EnableEncryptionAtHost *bool `json:"enableEncryptionAtHost,omitempty"`

	// See Add a FIPS-enabled node pool [https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview]
	// for more details.
	EnableFIPS *bool `json:"enableFIPS,omitempty"`

	// Some scenarios may require nodes in a node pool to receive their own dedicated public IP addresses. A common scenario is
	// for gaming workloads, where a console needs to make a direct connection to a
	// cloud virtual machine to minimize hops. For more information see assigning a public IP per node
	// [https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools]. The default
	// is false.
	EnableNodePublicIP *bool `json:"enableNodePublicIP,omitempty"`

	// Whether to enable UltraSSD
	EnableUltraSSD *bool `json:"enableUltraSSD,omitempty"`

	// GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU.
	GpuInstanceProfile *GPUInstanceProfile `json:"gpuInstanceProfile,omitempty"`

	// The Kubelet configuration on the agent pool nodes.
	KubeletConfig *KubeletConfig `json:"kubeletConfig,omitempty"`

	// Determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage.
	KubeletDiskType *KubeletDiskType `json:"kubeletDiskType,omitempty"`

	// The OS configuration of Linux agent nodes.
	LinuxOSConfig *LinuxOSConfig `json:"linuxOSConfig,omitempty"`

	// The maximum number of nodes for auto-scaling
	MaxCount *int32 `json:"maxCount,omitempty"`

	// The maximum number of pods that can run on a node.
	MaxPods *int32 `json:"maxPods,omitempty"`

	// The minimum number of nodes for auto-scaling
	MinCount *int32 `json:"minCount,omitempty"`

	// A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool restrictions
	// and best practices, see: https://docs.microsoft.com/azure/aks/use-system-pools
	Mode *AgentPoolMode `json:"mode,omitempty"`

	// The node labels to be persisted across all nodes in agent pool.
	NodeLabels map[string]*string `json:"nodeLabels,omitempty"`

	// This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}
	NodePublicIPPrefixID *string `json:"nodePublicIPPrefixID,omitempty"`

	// The taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
	NodeTaints []*string `json:"nodeTaints,omitempty"`

	// OS Disk Size in GB to be used to specify the disk size for every machine in the master/agent pool. If you specify 0, it
	// will apply the default osDisk size according to the vmSize specified.
	OSDiskSizeGB *int32 `json:"osDiskSizeGB,omitempty"`

	// The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB. Otherwise,
	// defaults to 'Managed'. May not be changed after creation. For more information
	// see Ephemeral OS [https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os].
	OSDiskType *OSDiskType `json:"osDiskType,omitempty"`

	// Specifies an OS SKU. This value must not be specified if OSType is Windows.
	OSSKU *OSSKU `json:"osSKU,omitempty"`

	// The operating system type. The default is Linux.
	OSType *OSType `json:"osType,omitempty"`

	// Both patch version (e.g. 1.20.13) and (e.g. 1.20) are supported. When is specified, the latest supported GA patch version
	// is chosen automatically. Updating the cluster with the same once it has been
	// created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a newer patch version is available. As a best practice,
	// you should upgrade all node pools in an AKS cluster to the same Kubernetes
	// version. The node pool version must have the same major version as the control plane. The node pool minor version must
	// be within two minor versions of the control plane version. The node pool version
	// cannot be greater than the control plane version. For more information see upgrading a node pool [https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool].
	OrchestratorVersion *string `json:"orchestratorVersion,omitempty"`

	// If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID for more details). This is of the form:
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
	PodSubnetID *string `json:"podSubnetID,omitempty"`

	// When an Agent Pool is first created it is initially Running. The Agent Pool can be stopped by setting this field to Stopped.
	// A stopped Agent Pool stops all of its VMs and does not accrue billing
	// charges. An Agent Pool can only be stopped if it is Running and provisioning state is Succeeded
	PowerState *PowerState `json:"powerState,omitempty"`

	// The ID for Proximity Placement Group.
	ProximityPlacementGroupID *string `json:"proximityPlacementGroupID,omitempty"`

	// This also effects the cluster autoscaler behavior. If not specified, it defaults to Delete.
	ScaleDownMode *ScaleDownMode `json:"scaleDownMode,omitempty"`

	// This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'.
	ScaleSetEvictionPolicy *ScaleSetEvictionPolicy `json:"scaleSetEvictionPolicy,omitempty"`

	// The Virtual Machine Scale Set priority. If not specified, the default is 'Regular'.
	ScaleSetPriority *ScaleSetPriority `json:"scaleSetPriority,omitempty"`

	// Possible values are any decimal value greater than zero or -1 which indicates the willingness to pay any on-demand price.
	// For more details on spot pricing, see spot VMs pricing
	// [https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing]
	SpotMaxPrice *float32 `json:"spotMaxPrice,omitempty"`

	// The tags to be persisted on the agent pool virtual machine scale set.
	Tags map[string]*string `json:"tags,omitempty"`

	// The type of Agent Pool.
	Type *AgentPoolType `json:"type,omitempty"`

	// Settings for upgrading the agentpool
	UpgradeSettings *AgentPoolUpgradeSettings `json:"upgradeSettings,omitempty"`

	// VM size availability varies by region. If a node contains insufficient compute resources (memory, cpu, etc) pods might
	// fail to run correctly. For more details on restricted VM sizes, see:
	// https://docs.microsoft.com/azure/aks/quotas-skus-regions
	VMSize *string `json:"vmSize,omitempty"`

	// If this is not specified, a VNET and subnet will be generated and used. If no podSubnetID is specified, this applies to
	// nodes and pods, otherwise it applies to just nodes. This is of the form:
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
	VnetSubnetID *string `json:"vnetSubnetID,omitempty"`

	// Determines the type of workload a node can run.
	WorkloadRuntime *WorkloadRuntime `json:"workloadRuntime,omitempty"`

	// READ-ONLY; If orchestratorVersion is a fully specified version , this field will be exactly equal to it. If orchestratorVersion
	// is , this field will contain the full version being used.
	CurrentOrchestratorVersion *string `json:"currentOrchestratorVersion,omitempty" azure:"ro"`

	// READ-ONLY; The version of node image
	NodeImageVersion *string `json:"nodeImageVersion,omitempty" azure:"ro"`

	// READ-ONLY; The current deployment or provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ManagedClusterAutoUpgradeProfile - Auto upgrade profile for a managed cluster.
type ManagedClusterAutoUpgradeProfile struct {
	// For more information see setting the AKS cluster auto-upgrade channel [https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel].
	UpgradeChannel *UpgradeChannel `json:"upgradeChannel,omitempty"`
}

// ManagedClusterHTTPProxyConfig - Cluster HTTP proxy configuration.
type ManagedClusterHTTPProxyConfig struct {
	// The HTTP proxy server endpoint to use.
	HTTPProxy *string `json:"httpProxy,omitempty"`

	// The HTTPS proxy server endpoint to use.
	HTTPSProxy *string `json:"httpsProxy,omitempty"`

	// The endpoints that should not go through proxy.
	NoProxy []*string `json:"noProxy,omitempty"`

	// Alternative CA cert to use for connecting to proxy servers.
	TrustedCa *string `json:"trustedCa,omitempty"`
}

// ManagedClusterIdentity - Identity for the managed cluster.
type ManagedClusterIdentity struct {
	// For more information see use managed identities in AKS [https://docs.microsoft.com/azure/aks/use-managed-identity].
	Type *ResourceIdentityType `json:"type,omitempty"`

	// The keys must be ARM resource IDs in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*ManagedServiceIdentityUserAssignedIdentitiesValue `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal id of the system assigned identity which is used by master components.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant id of the system assigned identity which is used by master components.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// ManagedClusterListResult - The response from the List Managed Clusters operation.
type ManagedClusterListResult struct {
	// The list of managed clusters.
	Value []*ManagedCluster `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of managed cluster results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ManagedClusterLoadBalancerProfile - Profile of the managed cluster load balancer.
type ManagedClusterLoadBalancerProfile struct {
	// The desired number of allocated SNAT ports per VM. Allowed values are in the range of 0 to 64000 (inclusive). The default
	// value is 0 which results in Azure dynamically allocating ports.
	AllocatedOutboundPorts *int32 `json:"allocatedOutboundPorts,omitempty"`

	// The effective outbound IP resources of the cluster load balancer.
	EffectiveOutboundIPs []*ResourceReference `json:"effectiveOutboundIPs,omitempty"`

	// Enable multiple standard load balancers per AKS cluster or not.
	EnableMultipleStandardLoadBalancers *bool `json:"enableMultipleStandardLoadBalancers,omitempty"`

	// Desired outbound flow idle timeout in minutes. Allowed values are in the range of 4 to 120 (inclusive). The default value
	// is 30 minutes.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`

	// Desired managed outbound IPs for the cluster load balancer.
	ManagedOutboundIPs *ManagedClusterLoadBalancerProfileManagedOutboundIPs `json:"managedOutboundIPs,omitempty"`

	// Desired outbound IP Prefix resources for the cluster load balancer.
	OutboundIPPrefixes *ManagedClusterLoadBalancerProfileOutboundIPPrefixes `json:"outboundIPPrefixes,omitempty"`

	// Desired outbound IP resources for the cluster load balancer.
	OutboundIPs *ManagedClusterLoadBalancerProfileOutboundIPs `json:"outboundIPs,omitempty"`
}

// ManagedClusterLoadBalancerProfileManagedOutboundIPs - Desired managed outbound IPs for the cluster load balancer.
type ManagedClusterLoadBalancerProfileManagedOutboundIPs struct {
	// The desired number of IPv4 outbound IPs created/managed by Azure for the cluster load balancer. Allowed values must be
	// in the range of 1 to 100 (inclusive). The default value is 1.
	Count *int32 `json:"count,omitempty"`

	// The desired number of IPv6 outbound IPs created/managed by Azure for the cluster load balancer. Allowed values must be
	// in the range of 1 to 100 (inclusive). The default value is 0 for single-stack and
	// 1 for dual-stack.
	CountIPv6 *int32 `json:"countIPv6,omitempty"`
}

// ManagedClusterLoadBalancerProfileOutboundIPPrefixes - Desired outbound IP Prefix resources for the cluster load balancer.
type ManagedClusterLoadBalancerProfileOutboundIPPrefixes struct {
	// A list of public IP prefix resources.
	PublicIPPrefixes []*ResourceReference `json:"publicIPPrefixes,omitempty"`
}

// ManagedClusterLoadBalancerProfileOutboundIPs - Desired outbound IP resources for the cluster load balancer.
type ManagedClusterLoadBalancerProfileOutboundIPs struct {
	// A list of public IP resources.
	PublicIPs []*ResourceReference `json:"publicIPs,omitempty"`
}

// ManagedClusterManagedOutboundIPProfile - Profile of the managed outbound IP resources of the managed cluster.
type ManagedClusterManagedOutboundIPProfile struct {
	// The desired number of outbound IPs created/managed by Azure. Allowed values must be in the range of 1 to 16 (inclusive).
	// The default value is 1.
	Count *int32 `json:"count,omitempty"`
}

// ManagedClusterNATGatewayProfile - Profile of the managed cluster NAT gateway.
type ManagedClusterNATGatewayProfile struct {
	// The effective outbound IP resources of the cluster NAT gateway.
	EffectiveOutboundIPs []*ResourceReference `json:"effectiveOutboundIPs,omitempty"`

	// Desired outbound flow idle timeout in minutes. Allowed values are in the range of 4 to 120 (inclusive). The default value
	// is 4 minutes.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`

	// Profile of the managed outbound IP resources of the cluster NAT gateway.
	ManagedOutboundIPProfile *ManagedClusterManagedOutboundIPProfile `json:"managedOutboundIPProfile,omitempty"`
}

// ManagedClusterPodIdentity - Details about the pod identity assigned to the Managed Cluster.
type ManagedClusterPodIdentity struct {
	// REQUIRED; The user assigned identity details.
	Identity *UserAssignedIdentity `json:"identity,omitempty"`

	// REQUIRED; The name of the pod identity.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The namespace of the pod identity.
	Namespace *string `json:"namespace,omitempty"`

	// The binding selector to use for the AzureIdentityBinding resource.
	BindingSelector *string `json:"bindingSelector,omitempty"`

	// READ-ONLY
	ProvisioningInfo *ManagedClusterPodIdentityProvisioningInfo `json:"provisioningInfo,omitempty" azure:"ro"`

	// READ-ONLY; The current provisioning state of the pod identity.
	ProvisioningState *ManagedClusterPodIdentityProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ManagedClusterPodIdentityException - See disable AAD Pod Identity for a specific Pod/Application [https://azure.github.io/aad-pod-identity/docs/configure/application_exception/]
// for more details.
type ManagedClusterPodIdentityException struct {
	// REQUIRED; The name of the pod identity exception.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The namespace of the pod identity exception.
	Namespace *string `json:"namespace,omitempty"`

	// REQUIRED; The pod labels to match.
	PodLabels map[string]*string `json:"podLabels,omitempty"`
}

// ManagedClusterPodIdentityProfile - See use AAD pod identity [https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity]
// for more details on pod identity integration.
type ManagedClusterPodIdentityProfile struct {
	// Running in Kubenet is disabled by default due to the security related nature of AAD Pod Identity and the risks of IP spoofing.
	// See using Kubenet network plugin with AAD Pod Identity
	// [https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity#using-kubenet-network-plugin-with-azure-active-directory-pod-managed-identities]
	// for more information.
	AllowNetworkPluginKubenet *bool `json:"allowNetworkPluginKubenet,omitempty"`

	// Whether the pod identity addon is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// The pod identities to use in the cluster.
	UserAssignedIdentities []*ManagedClusterPodIdentity `json:"userAssignedIdentities,omitempty"`

	// The pod identity exceptions to allow.
	UserAssignedIdentityExceptions []*ManagedClusterPodIdentityException `json:"userAssignedIdentityExceptions,omitempty"`
}

// ManagedClusterPodIdentityProvisioningError - An error response from the pod identity provisioning.
type ManagedClusterPodIdentityProvisioningError struct {
	// Details about the error.
	Error *ManagedClusterPodIdentityProvisioningErrorBody `json:"error,omitempty"`
}

// ManagedClusterPodIdentityProvisioningErrorBody - An error response from the pod identity provisioning.
type ManagedClusterPodIdentityProvisioningErrorBody struct {
	// An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`

	// A list of additional details about the error.
	Details []*ManagedClusterPodIdentityProvisioningErrorBody `json:"details,omitempty"`

	// A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`

	// The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
}

type ManagedClusterPodIdentityProvisioningInfo struct {
	// Pod identity assignment error (if any).
	Error *ManagedClusterPodIdentityProvisioningError `json:"error,omitempty"`
}

// ManagedClusterPoolUpgradeProfile - The list of available upgrade versions.
type ManagedClusterPoolUpgradeProfile struct {
	// REQUIRED; The Kubernetes version (major.minor.patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`

	// REQUIRED; The operating system type. The default is Linux.
	OSType *OSType `json:"osType,omitempty"`

	// The Agent Pool name.
	Name *string `json:"name,omitempty"`

	// List of orchestrator types and versions available for upgrade.
	Upgrades []*ManagedClusterPoolUpgradeProfileUpgradesItem `json:"upgrades,omitempty"`
}

type ManagedClusterPoolUpgradeProfileUpgradesItem struct {
	// Whether the Kubernetes version is currently in preview.
	IsPreview *bool `json:"isPreview,omitempty"`

	// The Kubernetes version (major.minor.patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
}

// ManagedClusterProperties - Properties of the managed cluster.
type ManagedClusterProperties struct {
	// The Azure Active Directory configuration.
	AADProfile *ManagedClusterAADProfile `json:"aadProfile,omitempty"`

	// The access profile for managed cluster API server.
	APIServerAccessProfile *ManagedClusterAPIServerAccessProfile `json:"apiServerAccessProfile,omitempty"`

	// The profile of managed cluster add-on.
	AddonProfiles map[string]*ManagedClusterAddonProfile `json:"addonProfiles,omitempty"`

	// The agent pool properties.
	AgentPoolProfiles []*ManagedClusterAgentPoolProfile `json:"agentPoolProfiles,omitempty"`

	// Parameters to be applied to the cluster-autoscaler when enabled
	AutoScalerProfile *ManagedClusterPropertiesAutoScalerProfile `json:"autoScalerProfile,omitempty"`

	// The auto upgrade configuration.
	AutoUpgradeProfile *ManagedClusterAutoUpgradeProfile `json:"autoUpgradeProfile,omitempty"`

	// This cannot be updated once the Managed Cluster has been created.
	DNSPrefix *string `json:"dnsPrefix,omitempty"`

	// If set to true, getting static credentials will be disabled for this cluster. This must only be used on Managed Clusters
	// that are AAD enabled. For more details see disable local accounts
	// [https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview].
	DisableLocalAccounts *bool `json:"disableLocalAccounts,omitempty"`

	// This is of the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{encryptionSetName}'
	DiskEncryptionSetID *string `json:"diskEncryptionSetID,omitempty"`

	// (DEPRECATING) Whether to enable Kubernetes pod security policy (preview). This feature is set for removal on October 15th,
	// 2020. Learn more at aka.ms/aks/azpodpolicy.
	EnablePodSecurityPolicy *bool `json:"enablePodSecurityPolicy,omitempty"`

	// Whether to enable Kubernetes Role-Based Access Control.
	EnableRBAC *bool `json:"enableRBAC,omitempty"`

	// This cannot be updated once the Managed Cluster has been created.
	FqdnSubdomain *string `json:"fqdnSubdomain,omitempty"`

	// Configurations for provisioning the cluster with HTTP proxy servers.
	HTTPProxyConfig *ManagedClusterHTTPProxyConfig `json:"httpProxyConfig,omitempty"`

	// Identities associated with the cluster.
	IdentityProfile map[string]*UserAssignedIdentity `json:"identityProfile,omitempty"`

	// Both patch version (e.g. 1.20.13) and (e.g. 1.20) are supported. When is specified, the latest supported GA patch version
	// is chosen automatically. Updating the cluster with the same once it has been
	// created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a newer patch version is available. When you upgrade
	// a supported AKS cluster, Kubernetes minor versions cannot be skipped. All
	// upgrades must be performed sequentially by major version number. For example, upgrades between 1.14.x -> 1.15.x or 1.15.x
	// -> 1.16.x are allowed, however 1.14.x -> 1.16.x is not allowed. See upgrading
	// an AKS cluster [https://docs.microsoft.com/azure/aks/upgrade-cluster] for more details.
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`

	// The profile for Linux VMs in the Managed Cluster.
	LinuxProfile *LinuxProfile `json:"linuxProfile,omitempty"`

	// The network configuration profile.
	NetworkProfile *NetworkProfile `json:"networkProfile,omitempty"`

	// The name of the resource group containing agent pool nodes.
	NodeResourceGroup *string `json:"nodeResourceGroup,omitempty"`

	// See use AAD pod identity [https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity] for more details on AAD pod identity
	// integration.
	PodIdentityProfile *ManagedClusterPodIdentityProfile `json:"podIdentityProfile,omitempty"`

	// Private link resources associated with the cluster.
	PrivateLinkResources []*PrivateLinkResource `json:"privateLinkResources,omitempty"`

	// Allow or deny public network access for AKS
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Security profile for the managed cluster.
	SecurityProfile *ManagedClusterSecurityProfile `json:"securityProfile,omitempty"`

	// Information about a service principal identity for the cluster to use for manipulating Azure APIs.
	ServicePrincipalProfile *ManagedClusterServicePrincipalProfile `json:"servicePrincipalProfile,omitempty"`

	// Storage profile for the managed cluster.
	StorageProfile *ManagedClusterStorageProfile `json:"storageProfile,omitempty"`

	// The profile for Windows VMs in the Managed Cluster.
	WindowsProfile *ManagedClusterWindowsProfile `json:"windowsProfile,omitempty"`

	// READ-ONLY; The Azure Portal requires certain Cross-Origin Resource Sharing (CORS) headers to be sent in some responses,
	// which Kubernetes APIServer doesn't handle by default. This special FQDN supports CORS,
	// allowing the Azure Portal to function properly.
	AzurePortalFQDN *string `json:"azurePortalFQDN,omitempty" azure:"ro"`

	// READ-ONLY; If kubernetesVersion was a fully specified version , this field will be exactly equal to it. If kubernetesVersion
	// was , this field will contain the full version being used.
	CurrentKubernetesVersion *string `json:"currentKubernetesVersion,omitempty" azure:"ro"`

	// READ-ONLY; The FQDN of the master pool.
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`

	// READ-ONLY; The max number of agent pools for the managed cluster.
	MaxAgentPools *int32 `json:"maxAgentPools,omitempty" azure:"ro"`

	// READ-ONLY; The Power State of the cluster.
	PowerState *PowerState `json:"powerState,omitempty" azure:"ro"`

	// READ-ONLY; The FQDN of private cluster.
	PrivateFQDN *string `json:"privateFQDN,omitempty" azure:"ro"`

	// READ-ONLY; The current provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ManagedClusterPropertiesAutoScalerProfile - Parameters to be applied to the cluster-autoscaler when enabled
type ManagedClusterPropertiesAutoScalerProfile struct {
	// Valid values are 'true' and 'false'
	BalanceSimilarNodeGroups *string `json:"balance-similar-node-groups,omitempty"`

	// If not specified, the default is 'random'. See expanders [https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/FAQ.md#what-are-expanders]
	// for more information.
	Expander *Expander `json:"expander,omitempty"`

	// The default is 10.
	MaxEmptyBulkDelete *string `json:"max-empty-bulk-delete,omitempty"`

	// The default is 600.
	MaxGracefulTerminationSec *string `json:"max-graceful-termination-sec,omitempty"`

	// The default is '15m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	MaxNodeProvisionTime *string `json:"max-node-provision-time,omitempty"`

	// The default is 45. The maximum is 100 and the minimum is 0.
	MaxTotalUnreadyPercentage *string `json:"max-total-unready-percentage,omitempty"`

	// For scenarios like burst/batch scale where you don't want CA to act before the kubernetes scheduler could schedule all
	// the pods, you can tell CA to ignore unscheduled pods before they're a certain
	// age. The default is '0s'. Values must be an integer followed by a unit ('s' for seconds, 'm' for minutes, 'h' for hours,
	// etc).
	NewPodScaleUpDelay *string `json:"new-pod-scale-up-delay,omitempty"`

	// This must be an integer. The default is 3.
	OkTotalUnreadyCount *string `json:"ok-total-unready-count,omitempty"`

	// The default is '10m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	ScaleDownDelayAfterAdd *string `json:"scale-down-delay-after-add,omitempty"`

	// The default is the scan-interval. Values must be an integer followed by an 'm'. No unit of time other than minutes (m)
	// is supported.
	ScaleDownDelayAfterDelete *string `json:"scale-down-delay-after-delete,omitempty"`

	// The default is '3m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	ScaleDownDelayAfterFailure *string `json:"scale-down-delay-after-failure,omitempty"`

	// The default is '10m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	ScaleDownUnneededTime *string `json:"scale-down-unneeded-time,omitempty"`

	// The default is '20m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	ScaleDownUnreadyTime *string `json:"scale-down-unready-time,omitempty"`

	// The default is '0.5'.
	ScaleDownUtilizationThreshold *string `json:"scale-down-utilization-threshold,omitempty"`

	// The default is '10'. Values must be an integer number of seconds.
	ScanInterval *string `json:"scan-interval,omitempty"`

	// The default is true.
	SkipNodesWithLocalStorage *string `json:"skip-nodes-with-local-storage,omitempty"`

	// The default is true.
	SkipNodesWithSystemPods *string `json:"skip-nodes-with-system-pods,omitempty"`
}

// ManagedClusterSKU - The SKU of a Managed Cluster.
type ManagedClusterSKU struct {
	// The name of a managed cluster SKU.
	Name *ManagedClusterSKUName `json:"name,omitempty"`

	// If not specified, the default is 'Free'. See uptime SLA [https://docs.microsoft.com/azure/aks/uptime-sla] for more details.
	Tier *ManagedClusterSKUTier `json:"tier,omitempty"`
}

// ManagedClusterSecurityProfile - Security profile for the container service cluster.
type ManagedClusterSecurityProfile struct {
	// Azure Defender settings for the security profile.
	AzureDefender *ManagedClusterSecurityProfileAzureDefender `json:"azureDefender,omitempty"`
}

// ManagedClusterSecurityProfileAzureDefender - Azure Defender settings for the security profile.
type ManagedClusterSecurityProfileAzureDefender struct {
	// Whether to enable Azure Defender
	Enabled *bool `json:"enabled,omitempty"`

	// Resource ID of the Log Analytics workspace to be associated with Azure Defender. When Azure Defender is enabled, this field
	// is required and must be a valid workspace resource ID. When Azure Defender
	// is disabled, leave the field empty.
	LogAnalyticsWorkspaceResourceID *string `json:"logAnalyticsWorkspaceResourceId,omitempty"`
}

// ManagedClusterServicePrincipalProfile - Information about a service principal identity for the cluster to use for manipulating
// Azure APIs.
type ManagedClusterServicePrincipalProfile struct {
	// REQUIRED; The ID for the service principal.
	ClientID *string `json:"clientId,omitempty"`

	// The secret password associated with the service principal in plain text.
	Secret *string `json:"secret,omitempty"`
}

// ManagedClusterStorageProfile - Storage profile for the container service cluster.
type ManagedClusterStorageProfile struct {
	// AzureDisk CSI Driver settings for the storage profile.
	DiskCSIDriver *ManagedClusterStorageProfileDiskCSIDriver `json:"diskCSIDriver,omitempty"`

	// AzureFile CSI Driver settings for the storage profile.
	FileCSIDriver *ManagedClusterStorageProfileFileCSIDriver `json:"fileCSIDriver,omitempty"`

	// Snapshot Controller settings for the storage profile.
	SnapshotController *ManagedClusterStorageProfileSnapshotController `json:"snapshotController,omitempty"`
}

// ManagedClusterStorageProfileDiskCSIDriver - AzureDisk CSI Driver settings for the storage profile.
type ManagedClusterStorageProfileDiskCSIDriver struct {
	// Whether to enable AzureDisk CSI Driver. The default value is true.
	Enabled *bool `json:"enabled,omitempty"`
}

// ManagedClusterStorageProfileFileCSIDriver - AzureFile CSI Driver settings for the storage profile.
type ManagedClusterStorageProfileFileCSIDriver struct {
	// Whether to enable AzureFile CSI Driver. The default value is true.
	Enabled *bool `json:"enabled,omitempty"`
}

// ManagedClusterStorageProfileSnapshotController - Snapshot Controller settings for the storage profile.
type ManagedClusterStorageProfileSnapshotController struct {
	// Whether to enable Snapshot Controller. The default value is true.
	Enabled *bool `json:"enabled,omitempty"`
}

// ManagedClusterUpgradeProfile - The list of available upgrades for compute pools.
type ManagedClusterUpgradeProfile struct {
	// REQUIRED; The properties of the upgrade profile.
	Properties *ManagedClusterUpgradeProfileProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the upgrade profile.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the upgrade profile.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the upgrade profile.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedClusterUpgradeProfileProperties - Control plane and agent pool upgrade profiles.
type ManagedClusterUpgradeProfileProperties struct {
	// REQUIRED; The list of available upgrade versions for agent pools.
	AgentPoolProfiles []*ManagedClusterPoolUpgradeProfile `json:"agentPoolProfiles,omitempty"`

	// REQUIRED; The list of available upgrade versions for the control plane.
	ControlPlaneProfile *ManagedClusterPoolUpgradeProfile `json:"controlPlaneProfile,omitempty"`
}

// ManagedClusterWindowsProfile - Profile for Windows VMs in the managed cluster.
type ManagedClusterWindowsProfile struct {
	// REQUIRED; Specifies the name of the administrator account.
	// Restriction: Cannot end in "."
	// Disallowed values: "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123",
	// "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest",
	// "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
	// Minimum-length: 1 character
	// Max-length: 20 characters
	AdminUsername *string `json:"adminUsername,omitempty"`

	// Specifies the password of the administrator account.
	// Minimum-length: 8 characters
	// Max-length: 123 characters
	// Complexity requirements: 3 out of 4 conditions below need to be fulfilled
	// Has lower characters
	// Has upper characters
	// Has a digit
	// Has a special character (Regex match [\W_])
	// Disallowed values: "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1",
	// "Password22", "iloveyou!"
	AdminPassword *string `json:"adminPassword,omitempty"`

	// For more details on CSI proxy, see the CSI proxy GitHub repo [https://github.com/kubernetes-csi/csi-proxy].
	EnableCSIProxy *bool `json:"enableCSIProxy,omitempty"`

	// The Windows gMSA Profile in the Managed Cluster.
	GmsaProfile *WindowsGmsaProfile `json:"gmsaProfile,omitempty"`

	// The license type to use for Windows VMs. See Azure Hybrid User Benefits [https://azure.microsoft.com/pricing/hybrid-benefit/faq/]
	// for more details.
	LicenseType *LicenseType `json:"licenseType,omitempty"`
}

// ManagedClustersClientBeginCreateOrUpdateOptions contains the optional parameters for the ManagedClustersClient.BeginCreateOrUpdate
// method.
type ManagedClustersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientBeginDeleteOptions contains the optional parameters for the ManagedClustersClient.BeginDelete method.
type ManagedClustersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientBeginResetAADProfileOptions contains the optional parameters for the ManagedClustersClient.BeginResetAADProfile
// method.
type ManagedClustersClientBeginResetAADProfileOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientBeginResetServicePrincipalProfileOptions contains the optional parameters for the ManagedClustersClient.BeginResetServicePrincipalProfile
// method.
type ManagedClustersClientBeginResetServicePrincipalProfileOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientBeginRotateClusterCertificatesOptions contains the optional parameters for the ManagedClustersClient.BeginRotateClusterCertificates
// method.
type ManagedClustersClientBeginRotateClusterCertificatesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientBeginRunCommandOptions contains the optional parameters for the ManagedClustersClient.BeginRunCommand
// method.
type ManagedClustersClientBeginRunCommandOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientBeginStartOptions contains the optional parameters for the ManagedClustersClient.BeginStart method.
type ManagedClustersClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientBeginStopOptions contains the optional parameters for the ManagedClustersClient.BeginStop method.
type ManagedClustersClientBeginStopOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientBeginUpdateTagsOptions contains the optional parameters for the ManagedClustersClient.BeginUpdateTags
// method.
type ManagedClustersClientBeginUpdateTagsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientGetAccessProfileOptions contains the optional parameters for the ManagedClustersClient.GetAccessProfile
// method.
type ManagedClustersClientGetAccessProfileOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersClientGetCommandResultOptions contains the optional parameters for the ManagedClustersClient.GetCommandResult
// method.
type ManagedClustersClientGetCommandResultOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersClientGetOSOptionsOptions contains the optional parameters for the ManagedClustersClient.GetOSOptions method.
type ManagedClustersClientGetOSOptionsOptions struct {
	// The resource type for which the OS options needs to be returned
	ResourceType *string
}

// ManagedClustersClientGetOptions contains the optional parameters for the ManagedClustersClient.Get method.
type ManagedClustersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersClientGetUpgradeProfileOptions contains the optional parameters for the ManagedClustersClient.GetUpgradeProfile
// method.
type ManagedClustersClientGetUpgradeProfileOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersClientListByResourceGroupOptions contains the optional parameters for the ManagedClustersClient.ListByResourceGroup
// method.
type ManagedClustersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersClientListClusterAdminCredentialsOptions contains the optional parameters for the ManagedClustersClient.ListClusterAdminCredentials
// method.
type ManagedClustersClientListClusterAdminCredentialsOptions struct {
	// server fqdn type for credentials to be returned
	ServerFqdn *string
}

// ManagedClustersClientListClusterMonitoringUserCredentialsOptions contains the optional parameters for the ManagedClustersClient.ListClusterMonitoringUserCredentials
// method.
type ManagedClustersClientListClusterMonitoringUserCredentialsOptions struct {
	// server fqdn type for credentials to be returned
	ServerFqdn *string
}

// ManagedClustersClientListClusterUserCredentialsOptions contains the optional parameters for the ManagedClustersClient.ListClusterUserCredentials
// method.
type ManagedClustersClientListClusterUserCredentialsOptions struct {
	// Only apply to AAD clusters, specifies the format of returned kubeconfig. Format 'azure' will return azure auth-provider
	// kubeconfig; format 'exec' will return exec format kubeconfig, which requires
	// kubelogin binary in the path.
	Format *Format
	// server fqdn type for credentials to be returned
	ServerFqdn *string
}

// ManagedClustersClientListOptions contains the optional parameters for the ManagedClustersClient.List method.
type ManagedClustersClientListOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersClientListOutboundNetworkDependenciesEndpointsOptions contains the optional parameters for the ManagedClustersClient.ListOutboundNetworkDependenciesEndpoints
// method.
type ManagedClustersClientListOutboundNetworkDependenciesEndpointsOptions struct {
	// placeholder for future optional parameters
}

type ManagedServiceIdentityUserAssignedIdentitiesValue struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// MasterProfile - Profile for the container service master.
type MasterProfile struct {
	// REQUIRED; DNS prefix to be used to create the FQDN for the master pool.
	DNSPrefix *string `json:"dnsPrefix,omitempty"`

	// REQUIRED; Size of agent VMs.
	VMSize *ContainerServiceVMSizeTypes `json:"vmSize,omitempty"`

	// Number of masters (VMs) in the container service cluster. Allowed values are 1, 3, and 5. The default value is 1.
	Count *Count `json:"count,omitempty"`

	// FirstConsecutiveStaticIP used to specify the first static ip of masters.
	FirstConsecutiveStaticIP *string `json:"firstConsecutiveStaticIP,omitempty"`

	// OS Disk Size in GB to be used to specify the disk size for every machine in this master/agent pool. If you specify 0, it
	// will apply the default osDisk size according to the vmSize specified.
	OSDiskSizeGB *int32 `json:"osDiskSizeGB,omitempty"`

	// Storage profile specifies what kind of storage used. Choose from StorageAccount and ManagedDisks. Leave it empty, we will
	// choose for you based on the orchestrator choice.
	StorageProfile *ContainerServiceStorageProfileTypes `json:"storageProfile,omitempty"`

	// VNet SubnetID specifies the VNet's subnet identifier.
	VnetSubnetID *string `json:"vnetSubnetID,omitempty"`

	// READ-ONLY; FQDN for the master pool.
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`
}

// NetworkProfile - Profile of network configuration.
type NetworkProfile struct {
	// An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified
	// in serviceCidr.
	DNSServiceIP *string `json:"dnsServiceIP,omitempty"`

	// A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes
	// service address range.
	DockerBridgeCidr *string `json:"dockerBridgeCidr,omitempty"`

	// IP families are used to determine single-stack or dual-stack clusters. For single-stack, the expected value is IPv4. For
	// dual-stack, the expected values are IPv4 and IPv6.
	IPFamilies []*IPFamily `json:"ipFamilies,omitempty"`

	// Profile of the cluster load balancer.
	LoadBalancerProfile *ManagedClusterLoadBalancerProfile `json:"loadBalancerProfile,omitempty"`

	// The default is 'standard'. See Azure Load Balancer SKUs [https://docs.microsoft.com/azure/load-balancer/skus] for more
	// information about the differences between load balancer SKUs.
	LoadBalancerSKU *LoadBalancerSKU `json:"loadBalancerSku,omitempty"`

	// Profile of the cluster NAT gateway.
	NatGatewayProfile *ManagedClusterNATGatewayProfile `json:"natGatewayProfile,omitempty"`

	// This cannot be specified if networkPlugin is anything other than 'azure'.
	NetworkMode *NetworkMode `json:"networkMode,omitempty"`

	// Network plugin used for building the Kubernetes network.
	NetworkPlugin *NetworkPlugin `json:"networkPlugin,omitempty"`

	// Network policy used for building the Kubernetes network.
	NetworkPolicy *NetworkPolicy `json:"networkPolicy,omitempty"`

	// This can only be set at cluster creation time and cannot be changed later. For more information see egress outbound type
	// [https://docs.microsoft.com/azure/aks/egress-outboundtype].
	OutboundType *OutboundType `json:"outboundType,omitempty"`

	// A CIDR notation IP range from which to assign pod IPs when kubenet is used.
	PodCidr *string `json:"podCidr,omitempty"`

	// One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack
	// networking.
	PodCidrs []*string `json:"podCidrs,omitempty"`

	// A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
	ServiceCidr *string `json:"serviceCidr,omitempty"`

	// One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack
	// networking. They must not overlap with any Subnet IP ranges.
	ServiceCidrs []*string `json:"serviceCidrs,omitempty"`
}

// OSOptionProfile - The OS option profile.
type OSOptionProfile struct {
	// REQUIRED; The list of OS options.
	Properties *OSOptionPropertyList `json:"properties,omitempty"`

	// READ-ONLY; The ID of the OS option resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the OS option resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the OS option resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// OSOptionProperty - OS option property.
type OSOptionProperty struct {
	// REQUIRED; Whether the image is FIPS-enabled.
	EnableFipsImage *bool `json:"enable-fips-image,omitempty"`

	// REQUIRED; The OS type.
	OSType *string `json:"os-type,omitempty"`
}

// OSOptionPropertyList - The list of OS option properties.
type OSOptionPropertyList struct {
	// REQUIRED; The list of OS options.
	OSOptionPropertyList []*OSOptionProperty `json:"osOptionPropertyList,omitempty"`
}

// OperationListResult - The List Operation response.
type OperationListResult struct {
	// READ-ONLY; The list of operations
	Value []*OperationValue `json:"value,omitempty" azure:"ro"`
}

// OperationValue - Describes the properties of a Operation value.
type OperationValue struct {
	// Describes the properties of a Operation Value Display.
	Display *OperationValueDisplay `json:"display,omitempty"`

	// READ-ONLY; The name of the operation.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The origin of the operation.
	Origin *string `json:"origin,omitempty" azure:"ro"`
}

// OperationValueDisplay - Describes the properties of a Operation Value Display.
type OperationValueDisplay struct {
	// READ-ONLY; The description of the operation.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the operation.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The resource provider for the operation.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the resource the operation applies to.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OutboundEnvironmentEndpoint - Egress endpoints which AKS agent nodes connect to for common purpose.
type OutboundEnvironmentEndpoint struct {
	// The category of endpoints accessed by the AKS agent node, e.g. azure-resource-management, apiserver, etc.
	Category *string `json:"category,omitempty"`

	// The endpoints that AKS agent nodes connect to
	Endpoints []*EndpointDependency `json:"endpoints,omitempty"`
}

// OutboundEnvironmentEndpointCollection - Collection of OutboundEnvironmentEndpoint
type OutboundEnvironmentEndpointCollection struct {
	// REQUIRED; Collection of resources.
	Value []*OutboundEnvironmentEndpoint `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PowerState - Describes the Power State of the cluster
type PowerState struct {
	// Tells whether the cluster is Running or Stopped
	Code *Code `json:"code,omitempty"`
}

// PrivateEndpoint - Private endpoint which a connection belongs to.
type PrivateEndpoint struct {
	// The resource ID of the private endpoint
	ID *string `json:"id,omitempty"`
}

// PrivateEndpointConnection - A private endpoint connection
type PrivateEndpointConnection struct {
	// The properties of a private endpoint connection.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the private endpoint connection.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the private endpoint connection.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - A list of private endpoint connections
type PrivateEndpointConnectionListResult struct {
	// The collection value.
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// The resource of private endpoint.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// READ-ONLY; The current provisioning state.
	ProvisioningState *PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListOptions contains the optional parameters for the PrivateEndpointConnectionsClient.List
// method.
type PrivateEndpointConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Update
// method.
type PrivateEndpointConnectionsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// The group ID of the resource.
	GroupID *string `json:"groupId,omitempty"`

	// The ID of the private link resource.
	ID *string `json:"id,omitempty"`

	// The name of the private link resource.
	Name *string `json:"name,omitempty"`

	// The RequiredMembers of the resource
	RequiredMembers []*string `json:"requiredMembers,omitempty"`

	// The resource type.
	Type *string `json:"type,omitempty"`

	// READ-ONLY; The private link service ID of the resource, this field is exposed only to NRP internally.
	PrivateLinkServiceID *string `json:"privateLinkServiceID,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientListOptions contains the optional parameters for the PrivateLinkResourcesClient.List method.
type PrivateLinkResourcesClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesListResult - A list of private link resources
type PrivateLinkResourcesListResult struct {
	// The collection value.
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkServiceConnectionState - The state of a private link service connection.
type PrivateLinkServiceConnectionState struct {
	// The private link service connection description.
	Description *string `json:"description,omitempty"`

	// The private link service connection status.
	Status *ConnectionStatus `json:"status,omitempty"`
}

// ResolvePrivateLinkServiceIDClientPOSTOptions contains the optional parameters for the ResolvePrivateLinkServiceIDClient.POST
// method.
type ResolvePrivateLinkServiceIDClientPOSTOptions struct {
	// placeholder for future optional parameters
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceReference - A reference to an Azure resource.
type ResourceReference struct {
	// The fully qualified Azure resource id.
	ID *string `json:"id,omitempty"`
}

// RunCommandRequest - A run command request
type RunCommandRequest struct {
	// REQUIRED; The command to run.
	Command *string `json:"command,omitempty"`

	// AuthToken issued for AKS AAD Server App.
	ClusterToken *string `json:"clusterToken,omitempty"`

	// A base64 encoded zip file containing the files required by the command.
	Context *string `json:"context,omitempty"`
}

// RunCommandResult - run command result.
type RunCommandResult struct {
	// Properties of command result.
	Properties *CommandResultProperties `json:"properties,omitempty"`

	// READ-ONLY; The command id.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// SSHConfiguration - SSH configuration for Linux-based VMs running on Azure.
type SSHConfiguration struct {
	// REQUIRED; The list of SSH public keys used to authenticate with Linux-based VMs. A maximum of 1 key may be specified.
	PublicKeys []*SSHPublicKey `json:"publicKeys,omitempty"`
}

// SSHPublicKey - Contains information about SSH certificate public key data.
type SSHPublicKey struct {
	// REQUIRED; Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with
	// or without headers.
	KeyData *string `json:"keyData,omitempty"`
}

// Snapshot - A node pool snapshot resource.
type Snapshot struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Properties of a snapshot.
	Properties *SnapshotProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SnapshotListResult - The response from the List Snapshots operation.
type SnapshotListResult struct {
	// The list of snapshots.
	Value []*Snapshot `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of snapshot results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SnapshotProperties - Properties used to configure a node pool snapshot.
type SnapshotProperties struct {
	// CreationData to be used to specify the source agent pool resource ID to create this snapshot.
	CreationData *CreationData `json:"creationData,omitempty"`

	// The type of a snapshot. The default is NodePool.
	SnapshotType *SnapshotType `json:"snapshotType,omitempty"`

	// READ-ONLY; Whether to use a FIPS-enabled OS.
	EnableFIPS *bool `json:"enableFIPS,omitempty" azure:"ro"`

	// READ-ONLY; The version of Kubernetes.
	KubernetesVersion *string `json:"kubernetesVersion,omitempty" azure:"ro"`

	// READ-ONLY; The version of node image.
	NodeImageVersion *string `json:"nodeImageVersion,omitempty" azure:"ro"`

	// READ-ONLY; Specifies an OS SKU. This value must not be specified if OSType is Windows.
	OSSKU *OSSKU `json:"osSku,omitempty" azure:"ro"`

	// READ-ONLY; The operating system type. The default is Linux.
	OSType *OSType `json:"osType,omitempty" azure:"ro"`

	// READ-ONLY; The size of the VM.
	VMSize *string `json:"vmSize,omitempty" azure:"ro"`
}

// SnapshotsClientCreateOrUpdateOptions contains the optional parameters for the SnapshotsClient.CreateOrUpdate method.
type SnapshotsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SnapshotsClientDeleteOptions contains the optional parameters for the SnapshotsClient.Delete method.
type SnapshotsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SnapshotsClientGetOptions contains the optional parameters for the SnapshotsClient.Get method.
type SnapshotsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SnapshotsClientListByResourceGroupOptions contains the optional parameters for the SnapshotsClient.ListByResourceGroup
// method.
type SnapshotsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// SnapshotsClientListOptions contains the optional parameters for the SnapshotsClient.List method.
type SnapshotsClientListOptions struct {
	// placeholder for future optional parameters
}

// SnapshotsClientUpdateTagsOptions contains the optional parameters for the SnapshotsClient.UpdateTags method.
type SnapshotsClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// SubResource - Reference to another subresource.
type SubResource struct {
	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SysctlConfig - Sysctl settings for Linux agent nodes.
type SysctlConfig struct {
	// Sysctl setting fs.aio-max-nr.
	FsAioMaxNr *int32 `json:"fsAioMaxNr,omitempty"`

	// Sysctl setting fs.file-max.
	FsFileMax *int32 `json:"fsFileMax,omitempty"`

	// Sysctl setting fs.inotify.maxuserwatches.
	FsInotifyMaxUserWatches *int32 `json:"fsInotifyMaxUserWatches,omitempty"`

	// Sysctl setting fs.nr_open.
	FsNrOpen *int32 `json:"fsNrOpen,omitempty"`

	// Sysctl setting kernel.threads-max.
	KernelThreadsMax *int32 `json:"kernelThreadsMax,omitempty"`

	// Sysctl setting net.core.netdevmaxbacklog.
	NetCoreNetdevMaxBacklog *int32 `json:"netCoreNetdevMaxBacklog,omitempty"`

	// Sysctl setting net.core.optmem_max.
	NetCoreOptmemMax *int32 `json:"netCoreOptmemMax,omitempty"`

	// Sysctl setting net.core.rmem_default.
	NetCoreRmemDefault *int32 `json:"netCoreRmemDefault,omitempty"`

	// Sysctl setting net.core.rmem_max.
	NetCoreRmemMax *int32 `json:"netCoreRmemMax,omitempty"`

	// Sysctl setting net.core.somaxconn.
	NetCoreSomaxconn *int32 `json:"netCoreSomaxconn,omitempty"`

	// Sysctl setting net.core.wmem_default.
	NetCoreWmemDefault *int32 `json:"netCoreWmemDefault,omitempty"`

	// Sysctl setting net.core.wmem_max.
	NetCoreWmemMax *int32 `json:"netCoreWmemMax,omitempty"`

	// Sysctl setting net.ipv4.iplocalport_range.
	NetIPv4IPLocalPortRange *string `json:"netIpv4IpLocalPortRange,omitempty"`

	// Sysctl setting net.ipv4.neigh.default.gc_thresh1.
	NetIPv4NeighDefaultGcThresh1 *int32 `json:"netIpv4NeighDefaultGcThresh1,omitempty"`

	// Sysctl setting net.ipv4.neigh.default.gc_thresh2.
	NetIPv4NeighDefaultGcThresh2 *int32 `json:"netIpv4NeighDefaultGcThresh2,omitempty"`

	// Sysctl setting net.ipv4.neigh.default.gc_thresh3.
	NetIPv4NeighDefaultGcThresh3 *int32 `json:"netIpv4NeighDefaultGcThresh3,omitempty"`

	// Sysctl setting net.ipv4.tcpfintimeout.
	NetIPv4TCPFinTimeout *int32 `json:"netIpv4TcpFinTimeout,omitempty"`

	// Sysctl setting net.ipv4.tcpkeepaliveprobes.
	NetIPv4TCPKeepaliveProbes *int32 `json:"netIpv4TcpKeepaliveProbes,omitempty"`

	// Sysctl setting net.ipv4.tcpkeepalivetime.
	NetIPv4TCPKeepaliveTime *int32 `json:"netIpv4TcpKeepaliveTime,omitempty"`

	// Sysctl setting net.ipv4.tcpmaxsyn_backlog.
	NetIPv4TCPMaxSynBacklog *int32 `json:"netIpv4TcpMaxSynBacklog,omitempty"`

	// Sysctl setting net.ipv4.tcpmaxtw_buckets.
	NetIPv4TCPMaxTwBuckets *int32 `json:"netIpv4TcpMaxTwBuckets,omitempty"`

	// Sysctl setting net.ipv4.tcptwreuse.
	NetIPv4TCPTwReuse *bool `json:"netIpv4TcpTwReuse,omitempty"`

	// Sysctl setting net.ipv4.tcpkeepaliveintvl.
	NetIPv4TcpkeepaliveIntvl *int32 `json:"netIpv4TcpkeepaliveIntvl,omitempty"`

	// Sysctl setting net.netfilter.nfconntrackbuckets.
	NetNetfilterNfConntrackBuckets *int32 `json:"netNetfilterNfConntrackBuckets,omitempty"`

	// Sysctl setting net.netfilter.nfconntrackmax.
	NetNetfilterNfConntrackMax *int32 `json:"netNetfilterNfConntrackMax,omitempty"`

	// Sysctl setting vm.maxmapcount.
	VMMaxMapCount *int32 `json:"vmMaxMapCount,omitempty"`

	// Sysctl setting vm.swappiness.
	VMSwappiness *int32 `json:"vmSwappiness,omitempty"`

	// Sysctl setting vm.vfscachepressure.
	VMVfsCachePressure *int32 `json:"vmVfsCachePressure,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TagsObject - Tags object for patch operations.
type TagsObject struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// TimeInWeek - Time in a week.
type TimeInWeek struct {
	// The day of the week.
	Day *WeekDay `json:"day,omitempty"`

	// Each integer hour represents a time range beginning at 0m after the hour ending at the next hour (non-inclusive). 0 corresponds
	// to 00:00 UTC, 23 corresponds to 23:00 UTC. Specifying [0, 1] means the
	// 00:00 - 02:00 UTC time range.
	HourSlots []*int32 `json:"hourSlots,omitempty"`
}

// TimeSpan - For example, between 2021-05-25T13:00:00Z and 2021-05-25T14:00:00Z.
type TimeSpan struct {
	// The end of a time span
	End *time.Time `json:"end,omitempty"`

	// The start of a time span
	Start *time.Time `json:"start,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UserAssignedIdentity - Details about a user assigned identity.
type UserAssignedIdentity struct {
	// The client ID of the user assigned identity.
	ClientID *string `json:"clientId,omitempty"`

	// The object ID of the user assigned identity.
	ObjectID *string `json:"objectId,omitempty"`

	// The resource ID of the user assigned identity.
	ResourceID *string `json:"resourceId,omitempty"`
}

// VMDiagnostics - Profile for diagnostics on the container service VMs.
type VMDiagnostics struct {
	// REQUIRED; Whether the VM diagnostic agent is provisioned on the VM.
	Enabled *bool `json:"enabled,omitempty"`

	// READ-ONLY; The URI of the storage account where diagnostics are stored.
	StorageURI *string `json:"storageUri,omitempty" azure:"ro"`
}

// WindowsGmsaProfile - Windows gMSA Profile in the managed cluster.
type WindowsGmsaProfile struct {
	// Specifies the DNS server for Windows gMSA.
	// Set it to empty if you have configured the DNS server in the vnet which is used to create the managed cluster.
	DNSServer *string `json:"dnsServer,omitempty"`

	// Specifies whether to enable Windows gMSA in the managed cluster.
	Enabled *bool `json:"enabled,omitempty"`

	// Specifies the root domain name for Windows gMSA.
	// Set it to empty if you have configured the DNS server in the vnet which is used to create the managed cluster.
	RootDomainName *string `json:"rootDomainName,omitempty"`
}
