
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "abstractbuttoninterface_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"
#include "sidebarinterface_wrapper.h"

// inner classes
#include "abstractbuttoninterface_clickcontroller_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_AbstractButtonInterface_Type = nullptr;
static PyTypeObject *Sbk_AbstractButtonInterface_TypeF(void)
{
    return _Sbk_AbstractButtonInterface_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void AbstractButtonInterfaceWrapper::pysideInitQtMetaTypes()
{
}

void AbstractButtonInterfaceWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

AbstractButtonInterfaceWrapper::AbstractButtonInterfaceWrapper(::QObject * parent) : AbstractButtonInterface(parent)
{
}

void AbstractButtonInterfaceWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AbstractButtonInterface_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("AbstractButtonInterface", funcName, gil, pyOverride, event);
}

void AbstractButtonInterfaceWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AbstractButtonInterface_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("AbstractButtonInterface", funcName, gil, pyOverride, signal);
}

void AbstractButtonInterfaceWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AbstractButtonInterface_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("AbstractButtonInterface", funcName, gil, pyOverride, event);
}

void AbstractButtonInterfaceWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AbstractButtonInterface_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("AbstractButtonInterface", funcName, gil, pyOverride, signal);
}

bool AbstractButtonInterfaceWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AbstractButtonInterface_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return WebViewWrapper::sbk_o_event("AbstractButtonInterface", funcName, gil, pyOverride, event);
}

bool AbstractButtonInterfaceWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AbstractButtonInterface_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("AbstractButtonInterface", funcName, gil, pyOverride, watched, event);
}

::QString AbstractButtonInterfaceWrapper::id() const
{
    static const char *funcName = "id";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AbstractButtonInterface_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("AbstractButtonInterface.id");
        return ::QString();
    }
    return SideBarInterfaceWrapper::sbk_o_title("AbstractButtonInterface", funcName, gil, pyOverride);
}

::QString AbstractButtonInterfaceWrapper::name() const
{
    static const char *funcName = "name";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AbstractButtonInterface_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("AbstractButtonInterface.name");
        return ::QString();
    }
    return SideBarInterfaceWrapper::sbk_o_title("AbstractButtonInterface", funcName, gil, pyOverride);
}

void AbstractButtonInterfaceWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AbstractButtonInterface_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("AbstractButtonInterface", funcName, gil, pyOverride, event);
}

const QMetaObject *AbstractButtonInterfaceWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return AbstractButtonInterface::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int AbstractButtonInterfaceWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = AbstractButtonInterface::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *AbstractButtonInterfaceWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< AbstractButtonInterfaceWrapper *>(this));
    }
    return AbstractButtonInterface::qt_metacast(_clname);
}

AbstractButtonInterfaceWrapper::~AbstractButtonInterfaceWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_AbstractButtonInterface_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_AbstractButtonInterface_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PyTypeObject *type = self->ob_type;
    PyTypeObject *myType = Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]);
    if (type == myType) {
        Shiboken::Errors::setInstantiateAbstractClass("AbstractButtonInterface");
        return -1;
    }

    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::AbstractButtonInterface >()))
        return -1;

    AbstractButtonInterfaceWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:AbstractButtonInterface", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: AbstractButtonInterface::AbstractButtonInterface(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // AbstractButtonInterface(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // AbstractButtonInterface(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // AbstractButtonInterface(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) AbstractButtonInterfaceWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new AbstractButtonInterfaceWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< AbstractButtonInterface >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]);
    };


    return 1;
}

static PyObject *Sbk_AbstractButtonInterfaceFunc_badgeText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AbstractButtonInterfaceWrapper *>(reinterpret_cast< ::AbstractButtonInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // badgeText()const
        QString cppResult = const_cast<const AbstractButtonInterfaceWrapper *>(cppSelf)->badgeText();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_AbstractButtonInterfaceFunc_icon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AbstractButtonInterfaceWrapper *>(reinterpret_cast< ::AbstractButtonInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // icon()const
        QIcon cppResult = const_cast<const AbstractButtonInterfaceWrapper *>(cppSelf)->icon();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_AbstractButtonInterfaceFunc_id(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AbstractButtonInterfaceWrapper *>(reinterpret_cast< ::AbstractButtonInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // id()const
        if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
            Shiboken::Errors::setPureVirtualMethodError("AbstractButtonInterface.id");
            return {};
        }
        QString cppResult = const_cast<const AbstractButtonInterfaceWrapper *>(cppSelf)->id();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_AbstractButtonInterfaceFunc_isActive(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AbstractButtonInterfaceWrapper *>(reinterpret_cast< ::AbstractButtonInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isActive()const
        bool cppResult = const_cast<const AbstractButtonInterfaceWrapper *>(cppSelf)->isActive();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_AbstractButtonInterfaceFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AbstractButtonInterfaceWrapper *>(reinterpret_cast< ::AbstractButtonInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isValid()const
        bool cppResult = const_cast<const AbstractButtonInterfaceWrapper *>(cppSelf)->isValid();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_AbstractButtonInterfaceFunc_isVisible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AbstractButtonInterfaceWrapper *>(reinterpret_cast< ::AbstractButtonInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isVisible()const
        bool cppResult = const_cast<const AbstractButtonInterfaceWrapper *>(cppSelf)->isVisible();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_AbstractButtonInterfaceFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AbstractButtonInterfaceWrapper *>(reinterpret_cast< ::AbstractButtonInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // name()const
        if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
            Shiboken::Errors::setPureVirtualMethodError("AbstractButtonInterface.name");
            return {};
        }
        QString cppResult = const_cast<const AbstractButtonInterfaceWrapper *>(cppSelf)->name();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_AbstractButtonInterfaceFunc_setActive(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AbstractButtonInterfaceWrapper *>(reinterpret_cast< ::AbstractButtonInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: AbstractButtonInterface::setActive(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setActive(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setActive", errInfo, SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setActive(bool)
            cppSelf->setActive(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_AbstractButtonInterfaceFunc_setBadgeText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AbstractButtonInterfaceWrapper *>(reinterpret_cast< ::AbstractButtonInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: AbstractButtonInterface::setBadgeText(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setBadgeText(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setBadgeText", errInfo, SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setBadgeText(QString)
            cppSelf->setBadgeText(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_AbstractButtonInterfaceFunc_setIcon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AbstractButtonInterfaceWrapper *>(reinterpret_cast< ::AbstractButtonInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: AbstractButtonInterface::setIcon(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArg)))) {
        overloadId = 0; // setIcon(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setIcon", errInfo, SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setIcon(QIcon)
            cppSelf->setIcon(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_AbstractButtonInterfaceFunc_setTitle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AbstractButtonInterfaceWrapper *>(reinterpret_cast< ::AbstractButtonInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: AbstractButtonInterface::setTitle(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setTitle(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setTitle", errInfo, SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTitle(QString)
            cppSelf->setTitle(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_AbstractButtonInterfaceFunc_setToolTip(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AbstractButtonInterfaceWrapper *>(reinterpret_cast< ::AbstractButtonInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: AbstractButtonInterface::setToolTip(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setToolTip(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setToolTip", errInfo, SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setToolTip(QString)
            cppSelf->setToolTip(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_AbstractButtonInterfaceFunc_setVisible(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AbstractButtonInterfaceWrapper *>(reinterpret_cast< ::AbstractButtonInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: AbstractButtonInterface::setVisible(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setVisible", errInfo, SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setVisible(bool)
            cppSelf->setVisible(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_AbstractButtonInterfaceFunc_setWebView(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AbstractButtonInterfaceWrapper *>(reinterpret_cast< ::AbstractButtonInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: AbstractButtonInterface::setWebView(WebView*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebView_IDX]), (pyArg)))) {
        overloadId = 0; // setWebView(WebView*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setWebView", errInfo, SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::WebView *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setWebView(WebView*)
            cppSelf->setWebView(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_AbstractButtonInterfaceFunc_title(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AbstractButtonInterfaceWrapper *>(reinterpret_cast< ::AbstractButtonInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // title()const
        QString cppResult = const_cast<const AbstractButtonInterfaceWrapper *>(cppSelf)->title();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_AbstractButtonInterfaceFunc_toolTip(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AbstractButtonInterfaceWrapper *>(reinterpret_cast< ::AbstractButtonInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // toolTip()const
        QString cppResult = const_cast<const AbstractButtonInterfaceWrapper *>(cppSelf)->toolTip();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_AbstractButtonInterfaceFunc_webView(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AbstractButtonInterfaceWrapper *>(reinterpret_cast< ::AbstractButtonInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // webView()const
        WebView * cppResult = const_cast<const AbstractButtonInterfaceWrapper *>(cppSelf)->webView();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebView_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_AbstractButtonInterface_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_AbstractButtonInterface_methods[] = {
    {"badgeText", reinterpret_cast<PyCFunction>(Sbk_AbstractButtonInterfaceFunc_badgeText), METH_NOARGS, nullptr},
    {"icon", reinterpret_cast<PyCFunction>(Sbk_AbstractButtonInterfaceFunc_icon), METH_NOARGS, nullptr},
    {"id", reinterpret_cast<PyCFunction>(Sbk_AbstractButtonInterfaceFunc_id), METH_NOARGS, nullptr},
    {"isActive", reinterpret_cast<PyCFunction>(Sbk_AbstractButtonInterfaceFunc_isActive), METH_NOARGS, nullptr},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_AbstractButtonInterfaceFunc_isValid), METH_NOARGS, nullptr},
    {"isVisible", reinterpret_cast<PyCFunction>(Sbk_AbstractButtonInterfaceFunc_isVisible), METH_NOARGS, nullptr},
    {"name", reinterpret_cast<PyCFunction>(Sbk_AbstractButtonInterfaceFunc_name), METH_NOARGS, nullptr},
    {"setActive", reinterpret_cast<PyCFunction>(Sbk_AbstractButtonInterfaceFunc_setActive), METH_O, nullptr},
    {"setBadgeText", reinterpret_cast<PyCFunction>(Sbk_AbstractButtonInterfaceFunc_setBadgeText), METH_O, nullptr},
    {"setIcon", reinterpret_cast<PyCFunction>(Sbk_AbstractButtonInterfaceFunc_setIcon), METH_O, nullptr},
    {"setTitle", reinterpret_cast<PyCFunction>(Sbk_AbstractButtonInterfaceFunc_setTitle), METH_O, nullptr},
    {"setToolTip", reinterpret_cast<PyCFunction>(Sbk_AbstractButtonInterfaceFunc_setToolTip), METH_O, nullptr},
    {"setVisible", reinterpret_cast<PyCFunction>(Sbk_AbstractButtonInterfaceFunc_setVisible), METH_O, nullptr},
    {"setWebView", reinterpret_cast<PyCFunction>(Sbk_AbstractButtonInterfaceFunc_setWebView), METH_O, nullptr},
    {"title", reinterpret_cast<PyCFunction>(Sbk_AbstractButtonInterfaceFunc_title), METH_NOARGS, nullptr},
    {"toolTip", reinterpret_cast<PyCFunction>(Sbk_AbstractButtonInterfaceFunc_toolTip), METH_NOARGS, nullptr},
    {"webView", reinterpret_cast<PyCFunction>(Sbk_AbstractButtonInterfaceFunc_webView), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_AbstractButtonInterface_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::AbstractButtonInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<AbstractButtonInterfaceWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_AbstractButtonInterface_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_AbstractButtonInterface_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_AbstractButtonInterface_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_AbstractButtonInterface_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_AbstractButtonInterface_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_AbstractButtonInterface_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_AbstractButtonInterface_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_AbstractButtonInterface_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_AbstractButtonInterface_spec = {
    "1:PyFalkon.AbstractButtonInterface",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_AbstractButtonInterface_slots
};

} //extern "C"

static void *Sbk_AbstractButtonInterface_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::AbstractButtonInterface *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void AbstractButtonInterface_PythonToCpp_AbstractButtonInterface_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_AbstractButtonInterface_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_AbstractButtonInterface_PythonToCpp_AbstractButtonInterface_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_AbstractButtonInterface_TypeF()))
        return AbstractButtonInterface_PythonToCpp_AbstractButtonInterface_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *AbstractButtonInterface_PTR_CppToPython_AbstractButtonInterface(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::AbstractButtonInterface *>(const_cast<void *>(cppIn)), Sbk_AbstractButtonInterface_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *AbstractButtonInterface_SignatureStrings[] = {
    "PyFalkon.AbstractButtonInterface(self,parent:PySide6.QtCore.QObject=nullptr)",
    "PyFalkon.AbstractButtonInterface.badgeText(self)->QString",
    "PyFalkon.AbstractButtonInterface.icon(self)->PySide6.QtGui.QIcon",
    "PyFalkon.AbstractButtonInterface.id(self)->QString",
    "PyFalkon.AbstractButtonInterface.isActive(self)->bool",
    "PyFalkon.AbstractButtonInterface.isValid(self)->bool",
    "PyFalkon.AbstractButtonInterface.isVisible(self)->bool",
    "PyFalkon.AbstractButtonInterface.name(self)->QString",
    "PyFalkon.AbstractButtonInterface.setActive(self,active:bool)",
    "PyFalkon.AbstractButtonInterface.setBadgeText(self,badgeText:QString)",
    "PyFalkon.AbstractButtonInterface.setIcon(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap])",
    "PyFalkon.AbstractButtonInterface.setTitle(self,text:QString)",
    "PyFalkon.AbstractButtonInterface.setToolTip(self,toolTip:QString)",
    "PyFalkon.AbstractButtonInterface.setVisible(self,visible:bool)",
    "PyFalkon.AbstractButtonInterface.setWebView(self,view:PyFalkon.WebView)",
    "PyFalkon.AbstractButtonInterface.title(self)->QString",
    "PyFalkon.AbstractButtonInterface.toolTip(self)->QString",
    "PyFalkon.AbstractButtonInterface.webView(self)->PyFalkon.WebView",
    nullptr}; // Sentinel
#else
static constexpr size_t AbstractButtonInterface_SignatureByteSize = 283;
static constexpr uint8_t AbstractButtonInterface_SignatureBytes[283] = {
    0x78, 0xda, 0x95, 0x93, 0x31, 0x6f, 0x83, 0x30, 0x10, 0x85, 0xf7, 0xfc, 0x8a, 0x8e, 0x45, 0x72,
    0x3d, 0x76, 0x40, 0x6a, 0xa5, 0xa4, 0x52, 0x23, 0xa6, 0x80, 0x42, 0xd3, 0xa1, 0xea, 0x60, 0xc3,
    0x25, 0xba, 0xc6, 0xb1, 0x91, 0x39, 0x42, 0xf8, 0xf7, 0x25, 0x04, 0x08, 0xa9, 0x2a, 0xc5, 0xde,
    0x30, 0xd6, 0xf7, 0xde, 0xbb, 0x7b, 0x10, 0x37, 0xef, 0x42, 0xed, 0x8d, 0xe6, 0x73, 0x59, 0x92,
    0x15, 0x19, 0x2d, 0x2a, 0x22, 0xa3, 0x23, 0x4d, 0x60, 0xb7, 0x22, 0x83, 0xc7, 0x12, 0xd4, 0x96,
    0x15, 0xc2, 0x82, 0xa6, 0x30, 0x6e, 0xd6, 0x98, 0xc3, 0x33, 0x4f, 0xe8, 0xcd, 0x58, 0xe0, 0xc9,
    0x4a, 0xfe, 0x40, 0x46, 0x2f, 0xba, 0x52, 0xaa, 0x20, 0x1b, 0xcc, 0xe2, 0x3b, 0x62, 0x5c, 0x8a,
    0x7c, 0x07, 0x29, 0x9c, 0xa8, 0x93, 0x0d, 0x9e, 0x5e, 0x93, 0x35, 0x59, 0xd4, 0xbb, 0xfb, 0x24,
    0x66, 0x46, 0x0f, 0xd0, 0x35, 0xc6, 0xb2, 0x42, 0x9e, 0x44, 0xed, 0x95, 0x83, 0x40, 0xee, 0xef,
    0x59, 0xce, 0x33, 0xc2, 0x23, 0x0c, 0xa0, 0x34, 0x46, 0xb9, 0x50, 0x1b, 0xa1, 0xae, 0x6e, 0xce,
    0x10, 0x96, 0x28, 0x95, 0xa7, 0x97, 0x16, 0x07, 0xf0, 0x1e, 0xab, 0x04, 0x9a, 0xcc, 0xc5, 0x44,
    0xf7, 0x1c, 0x9e, 0x0d, 0x03, 0x27, 0x78, 0x71, 0x53, 0x22, 0x1b, 0x3b, 0x0d, 0xfb, 0x04, 0x6e,
    0x2a, 0xd1, 0x50, 0x28, 0x3b, 0x57, 0x1b, 0x52, 0x53, 0xb4, 0x28, 0xff, 0xd0, 0x68, 0xf4, 0xd7,
    0x3f, 0x05, 0xb3, 0x87, 0x3f, 0x2f, 0x63, 0x3c, 0x1d, 0x44, 0xf1, 0xed, 0x66, 0x96, 0x22, 0xf5,
    0xab, 0x65, 0xe4, 0x9d, 0x34, 0x6d, 0x37, 0x93, 0x62, 0xd1, 0xe3, 0x97, 0x83, 0x9f, 0xc2, 0xb4,
    0x5b, 0x76, 0xbc, 0x1c, 0x3c, 0x16, 0xfe, 0x09, 0x72, 0x83, 0x50, 0x0f, 0x38, 0xd4, 0xe1, 0x48,
    0xf5, 0x57, 0x0e, 0x3a, 0x34, 0xae, 0xc0, 0xe7, 0x5b, 0xa1, 0xc9, 0xec, 0x3e, 0x5c, 0x3d, 0x89,
    0xdc, 0xfd, 0xb1, 0xb7, 0x79, 0x67, 0xbf, 0xb8, 0xa2, 0xa9, 0x52
};
#endif

PyTypeObject *init_AbstractButtonInterface(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX].type;

    Shiboken::AutoDecRef Sbk_AbstractButtonInterface_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_AbstractButtonInterface_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "AbstractButtonInterface",
        "AbstractButtonInterface*",
        &Sbk_AbstractButtonInterface_spec,
        &Shiboken::callCppDestructor< AbstractButtonInterface >,
        Sbk_AbstractButtonInterface_Type_bases.object(),
        0);
    auto *pyType = _Sbk_AbstractButtonInterface_Type; // references _Sbk_AbstractButtonInterface_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, AbstractButtonInterface_SignatureStrings);
#else
    InitSignatureBytes(pyType, AbstractButtonInterface_SignatureBytes, AbstractButtonInterface_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_AbstractButtonInterface_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        AbstractButtonInterface_PythonToCpp_AbstractButtonInterface_PTR,
        is_AbstractButtonInterface_PythonToCpp_AbstractButtonInterface_PTR_Convertible,
        AbstractButtonInterface_PTR_CppToPython_AbstractButtonInterface);

    Shiboken::Conversions::registerConverterName(converter, "AbstractButtonInterface");
    Shiboken::Conversions::registerConverterName(converter, "AbstractButtonInterface*");
    Shiboken::Conversions::registerConverterName(converter, "AbstractButtonInterface&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::AbstractButtonInterface).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(AbstractButtonInterfaceWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_AbstractButtonInterface_TypeF(), &Sbk_AbstractButtonInterface_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::AbstractButtonInterface::staticMetaObject);
    AbstractButtonInterfaceWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::AbstractButtonInterface::staticMetaObject, sizeof(AbstractButtonInterfaceWrapper));

    return pyType;
}
