#include "eldbus_fprint_manager.h"

static int _log_main = -1;
#undef ERR
#define ERR(...) EINA_LOG_DOM_ERR(_log_main, __VA_ARGS__);

static void
cb_fprint_manager_get_devices(void *data, const Eldbus_Message *msg, Eldbus_Pending *pending)
{
   void *user_data = eldbus_pending_data_del(pending, "__user_data");
   Fprint_Manager_Get_Devices_Cb cb = data;
   const char *error, *error_msg;
   Eina_Value *value;
   Eldbus_Proxy *proxy = eldbus_pending_data_del(pending, "__user_proxy");
   if (eldbus_message_error_get(msg, &error, &error_msg))
     {
        Eldbus_Error_Info error_info = {error, error_msg};
        cb(proxy, user_data, pending, &error_info, NULL);
        return;
     }
   value = eldbus_message_to_eina_value(msg);
   cb(proxy, user_data, pending, NULL, value);
   eina_value_free(value);
   return;
}

Eldbus_Pending *
fprint_manager_get_devices_call(Eldbus_Proxy *proxy, Fprint_Manager_Get_Devices_Cb cb, const void *data)
{
   Eldbus_Message *msg;
   Eldbus_Pending *p;
   EINA_SAFETY_ON_NULL_RETURN_VAL(proxy, NULL);
   msg = eldbus_proxy_method_call_new(proxy, "GetDevices");
   if (!eldbus_message_arguments_append(msg, ""))
     {
        ERR("Error: Filling message.");
        eldbus_message_unref(msg);
        return NULL;
     }
   p = eldbus_proxy_send(proxy, msg, cb_fprint_manager_get_devices, cb, -1);
   if (data)
     eldbus_pending_data_set(p, "__user_data", data);
   eldbus_pending_data_set(p, "__user_proxy", proxy);
   return p;
}

static void
cb_fprint_manager_get_default_device(void *data, const Eldbus_Message *msg, Eldbus_Pending *pending)
{
   void *user_data = eldbus_pending_data_del(pending, "__user_data");
   Fprint_Manager_Get_Default_Device_Cb cb = data;
   const char *error, *error_msg;
   Eldbus_Proxy *proxy = eldbus_pending_data_del(pending, "__user_proxy");
   const char *device = NULL;
   if (eldbus_message_error_get(msg, &error, &error_msg))
     {
        Eldbus_Error_Info error_info = {error, error_msg};
        cb(proxy, user_data, pending, &error_info, device);
        return;
     }
   if (!eldbus_message_arguments_get(msg, "o", &device))
     {
        Eldbus_Error_Info error_info = {"", ""};
        ERR("Error: Getting arguments from message.");
        cb(proxy, user_data, pending, &error_info, device);
        return;
     }
   cb(proxy, user_data, pending, NULL, device);
   return;
}

Eldbus_Pending *
fprint_manager_get_default_device_call(Eldbus_Proxy *proxy, Fprint_Manager_Get_Default_Device_Cb cb, const void *data)
{
   Eldbus_Message *msg;
   Eldbus_Pending *p;
   EINA_SAFETY_ON_NULL_RETURN_VAL(proxy, NULL);
   msg = eldbus_proxy_method_call_new(proxy, "GetDefaultDevice");
   if (!eldbus_message_arguments_append(msg, ""))
     {
        ERR("Error: Filling message.");
        eldbus_message_unref(msg);
        return NULL;
     }
   p = eldbus_proxy_send(proxy, msg, cb_fprint_manager_get_default_device, cb, -1);
   if (data)
     eldbus_pending_data_set(p, "__user_data", data);
   eldbus_pending_data_set(p, "__user_proxy", proxy);
   return p;
}

void
fprint_manager_log_domain_set(int id)
{
   _log_main = id;
}

void
fprint_manager_proxy_unref(Eldbus_Proxy *proxy)
{
   Eldbus_Object *obj = eldbus_proxy_object_get(proxy);
   eldbus_proxy_unref(proxy);
   eldbus_object_unref(obj);
}

Eldbus_Proxy *
fprint_manager_proxy_get(Eldbus_Connection *conn, const char *bus, const char *path)
{
   Eldbus_Object *obj;
   Eldbus_Proxy *proxy;
   EINA_SAFETY_ON_NULL_RETURN_VAL(conn, NULL);
   EINA_SAFETY_ON_NULL_RETURN_VAL(bus, NULL);
   if (!path) path = "/";
   obj = eldbus_object_get(conn, bus, path);
   proxy = eldbus_proxy_get(obj, "net.reactivated.Fprint.Manager");
   return proxy;
}
