// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudtrail

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudtrail/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns Insights events generated on a trail that logs data events. You can
// list Insights events that occurred in a Region within the last 90 days.
//
// ListInsightsData supports the following Dimensions for Insights events:
//
//   - Event ID
//
//   - Event name
//
//   - Event source
//
// All dimensions are optional. The default number of results returned is 50, with
// a maximum of 50 possible. The response includes a token that you can use to get
// the next page of results.
//
// The rate of ListInsightsData requests is limited to two per second, per
// account, per Region. If this limit is exceeded, a throttling error occurs.
func (c *Client) ListInsightsData(ctx context.Context, params *ListInsightsDataInput, optFns ...func(*Options)) (*ListInsightsDataOutput, error) {
	if params == nil {
		params = &ListInsightsDataInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListInsightsData", params, optFns, c.addOperationListInsightsDataMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListInsightsDataOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListInsightsDataInput struct {

	// Specifies the category of events returned. To fetch Insights events, specify
	// InsightsEvents as the value of DataType
	//
	// This member is required.
	DataType types.ListInsightsDataType

	// The Amazon Resource Name(ARN) of the trail for which you want to retrieve
	// Insights events.
	//
	// This member is required.
	InsightSource *string

	// Contains a map of dimensions. Currently the map can contain only one item.
	Dimensions map[string]string

	// Specifies that only events that occur before or at the specified time are
	// returned. If the specified end time is before the specified start time, an error
	// is returned.
	EndTime *time.Time

	// The number of events to return. Possible values are 1 through 50. The default
	// is 50.
	MaxResults *int32

	// The token to use to get the next page of results after a previous API call.
	// This token must be passed in with the same parameters that were specified in the
	// original call. For example, if the original call specified a EventName as a
	// dimension with PutObject as a value, the call with NextToken should include
	// those same parameters.
	NextToken *string

	// Specifies that only events that occur after or at the specified time are
	// returned. If the specified start time is after the specified end time, an error
	// is returned.
	StartTime *time.Time

	noSmithyDocumentSerde
}

type ListInsightsDataOutput struct {

	// A list of events returned based on the InsightSource, DataType or Dimensions
	// specified. The events list is sorted by time. The most recent event is listed
	// first.
	Events []types.Event

	// The token to use to get the next page of results after a previous API call. If
	// the token does not appear, there are no more results to return. The token must
	// be passed in with the same parameters as the previous call. For example, if the
	// original call specified a EventName as a dimension with PutObject as a value,
	// the call with NextToken should include those same parameters.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListInsightsDataMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListInsightsData{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListInsightsData{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListInsightsData"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListInsightsDataValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListInsightsData(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListInsightsDataPaginatorOptions is the paginator options for ListInsightsData
type ListInsightsDataPaginatorOptions struct {
	// The number of events to return. Possible values are 1 through 50. The default
	// is 50.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListInsightsDataPaginator is a paginator for ListInsightsData
type ListInsightsDataPaginator struct {
	options   ListInsightsDataPaginatorOptions
	client    ListInsightsDataAPIClient
	params    *ListInsightsDataInput
	nextToken *string
	firstPage bool
}

// NewListInsightsDataPaginator returns a new ListInsightsDataPaginator
func NewListInsightsDataPaginator(client ListInsightsDataAPIClient, params *ListInsightsDataInput, optFns ...func(*ListInsightsDataPaginatorOptions)) *ListInsightsDataPaginator {
	if params == nil {
		params = &ListInsightsDataInput{}
	}

	options := ListInsightsDataPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListInsightsDataPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListInsightsDataPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListInsightsData page.
func (p *ListInsightsDataPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListInsightsDataOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListInsightsData(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListInsightsDataAPIClient is a client that implements the ListInsightsData
// operation.
type ListInsightsDataAPIClient interface {
	ListInsightsData(context.Context, *ListInsightsDataInput, ...func(*Options)) (*ListInsightsDataOutput, error)
}

var _ ListInsightsDataAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListInsightsData(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListInsightsData",
	}
}
