/* FileStore.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from FileStore.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include <glib-object.h>
#include <gio/gio.h>
#include "deja.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_FILE_STORE (file_store_get_type ())
#define FILE_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_STORE, FileStore))
#define FILE_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_STORE, FileStoreClass))
#define IS_FILE_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_STORE))
#define IS_FILE_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_STORE))
#define FILE_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_STORE, FileStoreClass))

typedef struct _FileStore FileStore;
typedef struct _FileStoreClass FileStoreClass;
typedef struct _FileStorePrivate FileStorePrivate;

#define FILE_STORE_TYPE_ITEM (file_store_item_get_type ())
#define FILE_STORE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILE_STORE_TYPE_ITEM, FileStoreItem))
#define FILE_STORE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILE_STORE_TYPE_ITEM, FileStoreItemClass))
#define FILE_STORE_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILE_STORE_TYPE_ITEM))
#define FILE_STORE_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILE_STORE_TYPE_ITEM))
#define FILE_STORE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILE_STORE_TYPE_ITEM, FileStoreItemClass))

typedef struct _FileStoreItem FileStoreItem;
typedef struct _FileStoreItemClass FileStoreItemClass;
enum  {
	FILE_STORE_0_PROPERTY,
	FILE_STORE_TREE_PROPERTY,
	FILE_STORE_CURRENT_PROPERTY,
	FILE_STORE_CAN_GO_UP_PROPERTY,
	FILE_STORE_SEARCH_FILTER_PROPERTY,
	FILE_STORE_NUM_PROPERTIES
};
static GParamSpec* file_store_properties[FILE_STORE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _FileStoreItemPrivate FileStoreItemPrivate;
enum  {
	FILE_STORE_ITEM_0_PROPERTY,
	FILE_STORE_ITEM_NODE_PROPERTY,
	FILE_STORE_ITEM_FILENAME_PROPERTY,
	FILE_STORE_ITEM_COLLATE_KEY_PROPERTY,
	FILE_STORE_ITEM_PATH_PROPERTY,
	FILE_STORE_ITEM_ICON_PROPERTY,
	FILE_STORE_ITEM_EMBLEM_PROPERTY,
	FILE_STORE_ITEM_DESCRIPTION_PROPERTY,
	FILE_STORE_ITEM_NUM_PROPERTIES
};
static GParamSpec* file_store_item_properties[FILE_STORE_ITEM_NUM_PROPERTIES];

struct _FileStore {
	GObject parent_instance;
	FileStorePrivate * priv;
};

struct _FileStoreClass {
	GObjectClass parent_class;
};

struct _FileStorePrivate {
	DejaDupFileTree* _tree;
	DejaDupFileTreeNode* _current;
	gboolean _can_go_up;
	gchar* _search_filter;
	GPtrArray* items;
};

struct _Block4Data {
	int _ref_count_;
	FileStore* self;
	gchar** needle_tokens;
	gint needle_tokens_length1;
};

struct _Block5Data {
	int _ref_count_;
	GPtrArray* self;
	GCompareFunc compare_func;
};

struct _FileStoreItem {
	GObject parent_instance;
	FileStoreItemPrivate * priv;
};

struct _FileStoreItemClass {
	GObjectClass parent_class;
};

struct _FileStoreItemPrivate {
	DejaDupFileTreeNode* _node;
	gchar* _collate_key;
	gchar* _path;
	GIcon* _icon;
	GIcon* _emblem;
	gchar* _description;
};

static gint FileStore_private_offset;
static gpointer file_store_parent_class = NULL;
static gint FileStoreItem_private_offset;
static gpointer file_store_item_parent_class = NULL;
static GListModelInterface * file_store_g_list_model_parent_iface = NULL;

VALA_EXTERN GType file_store_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileStore, g_object_unref)
VALA_EXTERN GType file_store_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileStoreItem, g_object_unref)
VALA_EXTERN void file_store_clear (FileStore* self);
static gint file_store_clear_full (FileStore* self);
VALA_EXTERN void file_store_set_file_tree (FileStore* self,
                               DejaDupFileTree* tree);
static void file_store_set_tree (FileStore* self,
                          DejaDupFileTree* value);
static void file_store_move_to (FileStore* self,
                         DejaDupFileTreeNode* node);
VALA_EXTERN gboolean file_store_go_down (FileStore* self,
                             guint position);
VALA_EXTERN DejaDupFileTreeNode* file_store_item_get_node (FileStoreItem* self);
VALA_EXTERN gboolean file_store_go_up (FileStore* self);
VALA_EXTERN gboolean file_store_get_can_go_up (FileStore* self);
VALA_EXTERN DejaDupFileTreeNode* file_store_get_current (FileStore* self);
VALA_EXTERN GFile* file_store_get_file (FileStore* self,
                            guint position);
static gchar* file_store_get_full_path (FileStore* self,
                                 guint position);
static GType file_store_real_get_item_type (GListModel* base);
static guint file_store_real_get_n_items (GListModel* base);
static GObject* file_store_real_get_item (GListModel* base,
                                   guint position);
VALA_EXTERN DejaDupFileTree* file_store_get_tree (FileStore* self);
VALA_EXTERN const gchar* file_store_item_get_path (FileStoreItem* self);
VALA_EXTERN const gchar* file_store_item_get_filename (FileStoreItem* self);
static void file_store_update_search (FileStore* self);
VALA_EXTERN const gchar* file_store_get_search_filter (FileStore* self);
static void file_store_recursive_search (FileStore* self,
                                  gchar** needle_tokens,
                                  gint needle_tokens_length1,
                                  DejaDupFileTreeNode* node);
static void file_store_sort (FileStore* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda7_ (Block4Data* _data4_,
                 const gchar* name,
                 DejaDupFileTreeNode* child);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void file_store_insert_file (FileStore* self,
                             DejaDupFileTreeNode* node);
static void ___lambda7__gh_func (gconstpointer key,
                          gconstpointer value,
                          gpointer self);
static void file_store_set_current (FileStore* self,
                             DejaDupFileTreeNode* value);
static void file_store_set_can_go_up (FileStore* self,
                               gboolean value);
static void __lambda5_ (FileStore* self,
                 const gchar* name,
                 DejaDupFileTreeNode* child);
static void ___lambda5__gh_func (gconstpointer key,
                          gconstpointer value,
                          gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gint ___lambda0__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
static gint __lambda6_ (FileStoreItem* a,
                 FileStoreItem* b);
VALA_EXTERN const gchar* file_store_item_get_collate_key (FileStoreItem* self);
static gint ___lambda6__gcompare_func (gconstpointer a,
                                gconstpointer b);
VALA_EXTERN FileStoreItem* file_store_item_new (DejaDupFileTreeNode* node,
                                    const gchar* collate_key,
                                    const gchar* path,
                                    GIcon* icon,
                                    GIcon* emblem,
                                    const gchar* description);
VALA_EXTERN FileStoreItem* file_store_item_construct (GType object_type,
                                          DejaDupFileTreeNode* node,
                                          const gchar* collate_key,
                                          const gchar* path,
                                          GIcon* icon,
                                          GIcon* emblem,
                                          const gchar* description);
VALA_EXTERN FileStore* file_store_new (void);
VALA_EXTERN FileStore* file_store_construct (GType object_type);
VALA_EXTERN void file_store_set_search_filter (FileStore* self,
                                   const gchar* value);
static void file_store_item_set_node (FileStoreItem* self,
                               DejaDupFileTreeNode* value);
static void file_store_item_set_collate_key (FileStoreItem* self,
                                      const gchar* value);
static void file_store_item_set_path (FileStoreItem* self,
                               const gchar* value);
VALA_EXTERN GIcon* file_store_item_get_icon (FileStoreItem* self);
static void file_store_item_set_icon (FileStoreItem* self,
                               GIcon* value);
VALA_EXTERN GIcon* file_store_item_get_emblem (FileStoreItem* self);
static void file_store_item_set_emblem (FileStoreItem* self,
                                 GIcon* value);
VALA_EXTERN const gchar* file_store_item_get_description (FileStoreItem* self);
static void file_store_item_set_description (FileStoreItem* self,
                                      const gchar* value);
static void file_store_item_finalize (GObject * obj);
static GType file_store_item_get_type_once (void);
static void _vala_file_store_item_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_file_store_item_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static GObject * file_store_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties);
static void _g_object_unref0_ (gpointer var);
static void _file_store_update_search_g_object_notify (GObject* _sender,
                                                GParamSpec* pspec,
                                                gpointer self);
static void file_store_finalize (GObject * obj);
static GType file_store_get_type_once (void);
static void _vala_file_store_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_file_store_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
file_store_get_instance_private (FileStore* self)
{
	return G_STRUCT_MEMBER_P (self, FileStore_private_offset);
}

void
file_store_clear (FileStore* self)
{
	gint removed = 0;
	g_return_if_fail (self != NULL);
	removed = file_store_clear_full (self);
	g_list_model_items_changed ((GListModel*) self, (guint) 0, (guint) removed, (guint) 0);
}

void
file_store_set_file_tree (FileStore* self,
                          DejaDupFileTree* tree)
{
	DejaDupFileTreeNode* _tmp0_;
	DejaDupFileTreeNode* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tree != NULL);
	file_store_set_tree (self, tree);
	_tmp0_ = deja_dup_file_tree_get_root (tree);
	_tmp1_ = _tmp0_;
	file_store_move_to (self, _tmp1_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gboolean
file_store_go_down (FileStore* self,
                    guint position)
{
	DejaDupFileTreeNode* child = NULL;
	GPtrArray* _tmp0_;
	gconstpointer _tmp1_;
	DejaDupFileTreeNode* _tmp2_;
	DejaDupFileTreeNode* _tmp3_;
	DejaDupFileTreeNode* _tmp4_;
	DejaDupFileTreeNode* _tmp5_;
	GFileType _tmp6_;
	GFileType _tmp7_;
	DejaDupFileTreeNode* _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->items;
	_tmp1_ = g_ptr_array_index (_tmp0_, position);
	_tmp2_ = file_store_item_get_node ((FileStoreItem*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	child = _tmp4_;
	_tmp5_ = child;
	_tmp6_ = deja_dup_file_tree_node_get_kind (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != G_FILE_TYPE_DIRECTORY) {
		result = FALSE;
		_g_object_unref0 (child);
		return result;
	}
	_tmp8_ = child;
	file_store_move_to (self, _tmp8_);
	result = TRUE;
	_g_object_unref0 (child);
	return result;
}

gboolean
file_store_go_up (FileStore* self)
{
	gboolean _tmp0_;
	DejaDupFileTreeNode* _tmp1_;
	DejaDupFileTreeNode* _tmp2_;
	DejaDupFileTreeNode* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_can_go_up;
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->_current;
	_tmp2_ = deja_dup_file_tree_node_get_parent (_tmp1_);
	_tmp3_ = _tmp2_;
	file_store_move_to (self, _tmp3_);
	result = TRUE;
	return result;
}

GFile*
file_store_get_file (FileStore* self,
                     guint position)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = file_store_get_full_path (self, position);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static GType
file_store_real_get_item_type (GListModel* base)
{
	FileStore * self;
	GType result;
	self = (FileStore*) base;
	result = DEJA_DUP_FILE_TREE_TYPE_NODE;
	return result;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static guint
file_store_real_get_n_items (GListModel* base)
{
	FileStore * self;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint result;
	self = (FileStore*) base;
	_tmp0_ = self->priv->items;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (guint) _tmp2_;
	return result;
}

static GObject*
file_store_real_get_item (GListModel* base,
                          guint position)
{
	FileStore * self;
	GPtrArray* _tmp0_;
	gconstpointer _tmp1_;
	GObject* _tmp2_;
	GObject* result;
	self = (FileStore*) base;
	_tmp0_ = self->priv->items;
	_tmp1_ = g_ptr_array_index (_tmp0_, position);
	_tmp2_ = _g_object_ref0 ((GObject*) ((FileStoreItem*) _tmp1_));
	result = _tmp2_;
	return result;
}

static gint
file_store_clear_full (FileStore* self)
{
	gint old_len = 0;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GPtrArray* _tmp3_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->items;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	old_len = _tmp2_;
	_tmp3_ = self->priv->items;
	g_ptr_array_remove_range (_tmp3_, (guint) 0, (guint) old_len);
	result = old_len;
	return result;
}

static gchar*
file_store_get_full_path (FileStore* self,
                          guint position)
{
	FileStoreItem* item = NULL;
	GPtrArray* _tmp0_;
	gconstpointer _tmp1_;
	FileStoreItem* _tmp2_;
	gchar* node_path = NULL;
	DejaDupFileTree* _tmp3_;
	DejaDupFileTree* _tmp4_;
	DejaDupFileTreeNode* _tmp5_;
	DejaDupFileTreeNode* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->items;
	_tmp1_ = g_ptr_array_index (_tmp0_, position);
	_tmp2_ = _g_object_ref0 ((FileStoreItem*) _tmp1_);
	item = _tmp2_;
	_tmp3_ = self->priv->_tree;
	_tmp4_ = self->priv->_tree;
	_tmp5_ = deja_dup_file_tree_get_root (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = deja_dup_file_tree_node_to_path (_tmp3_, _tmp6_);
	node_path = _tmp7_;
	_tmp8_ = file_store_item_get_path (item);
	_tmp9_ = _tmp8_;
	_tmp10_ = file_store_item_get_filename (item);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_build_filename ("/", node_path, _tmp9_, _tmp11_, NULL);
	result = _tmp12_;
	_g_free0 (node_path);
	_g_object_unref0 (item);
	return result;
}

static void
file_store_update_search (FileStore* self)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gchar** needle_tokens = NULL;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint needle_tokens_length1;
	gint _needle_tokens_size_;
	gint removed = 0;
	gchar** _tmp7_;
	gint _tmp7__length1;
	DejaDupFileTree* _tmp8_;
	DejaDupFileTreeNode* _tmp9_;
	DejaDupFileTreeNode* _tmp10_;
	GPtrArray* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_search_filter;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_search_filter;
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
	}
	if (_tmp0_) {
		DejaDupFileTreeNode* _tmp3_;
		_tmp3_ = self->priv->_current;
		file_store_move_to (self, _tmp3_);
		return;
	}
	_tmp4_ = self->priv->_search_filter;
	_tmp6_ = _tmp5_ = g_str_tokenize_and_fold (_tmp4_, "", NULL);
	needle_tokens = _tmp6_;
	needle_tokens_length1 = _vala_array_length (_tmp5_);
	_needle_tokens_size_ = needle_tokens_length1;
	removed = file_store_clear_full (self);
	_tmp7_ = needle_tokens;
	_tmp7__length1 = needle_tokens_length1;
	_tmp8_ = self->priv->_tree;
	_tmp9_ = deja_dup_file_tree_get_root (_tmp8_);
	_tmp10_ = _tmp9_;
	file_store_recursive_search (self, _tmp7_, (gint) _tmp7__length1, _tmp10_);
	file_store_sort (self);
	_tmp11_ = self->priv->items;
	_tmp12_ = vala_g_ptr_array_get_length (_tmp11_);
	_tmp13_ = _tmp12_;
	g_list_model_items_changed ((GListModel*) self, (guint) 0, (guint) removed, (guint) _tmp13_);
	needle_tokens = (_vala_array_free (needle_tokens, needle_tokens_length1, (GDestroyNotify) g_free), NULL);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		FileStore* self;
		self = _data4_->self;
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
__lambda7_ (Block4Data* _data4_,
            const gchar* name,
            DejaDupFileTreeNode* child)
{
	FileStore* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gboolean all_matched = FALSE;
	self = _data4_->self;
	g_return_if_fail (name != NULL);
	g_return_if_fail (child != NULL);
	_tmp0_ = child->search_tokens;
	_tmp0__length1 = child->search_tokens_length1;
	if (_tmp0_ == NULL) {
		gchar** unicode_tokens = NULL;
		gint unicode_tokens_length1 = 0;
		gint _unicode_tokens_size_ = 0;
		gchar** ascii_tokens = NULL;
		gint ascii_tokens_length1 = 0;
		gint _ascii_tokens_size_ = 0;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar** _tmp3_ = NULL;
		gchar** _tmp4_;
		gchar** _tmp5_;
		gchar** all_tokens = NULL;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar** _tmp7_;
		gint _tmp7__length1;
		gchar** _tmp8_;
		gint all_tokens_length1;
		gint _all_tokens_size_;
		gchar** _tmp24_;
		gint _tmp24__length1;
		gchar** _tmp25_;
		gint _tmp25__length1;
		_tmp1_ = deja_dup_file_tree_node_get_filename (child);
		_tmp2_ = _tmp1_;
		_tmp5_ = _tmp4_ = g_str_tokenize_and_fold (_tmp2_, "", &_tmp3_);
		ascii_tokens = (_vala_array_free (ascii_tokens, ascii_tokens_length1, (GDestroyNotify) g_free), NULL);
		ascii_tokens = _tmp3_;
		ascii_tokens_length1 = -1;
		_ascii_tokens_size_ = ascii_tokens_length1;
		ascii_tokens_length1 = _vala_array_length (ascii_tokens);
		unicode_tokens = (_vala_array_free (unicode_tokens, unicode_tokens_length1, (GDestroyNotify) g_free), NULL);
		unicode_tokens = _tmp5_;
		unicode_tokens_length1 = _vala_array_length (_tmp4_);
		_unicode_tokens_size_ = unicode_tokens_length1;
		_tmp6_ = unicode_tokens;
		_tmp6__length1 = unicode_tokens_length1;
		_tmp7_ = ascii_tokens;
		_tmp7__length1 = ascii_tokens_length1;
		_tmp8_ = g_new0 (gchar*, (_tmp6__length1 + _tmp7__length1) + 1);
		all_tokens = _tmp8_;
		all_tokens_length1 = _tmp6__length1 + _tmp7__length1;
		_all_tokens_size_ = all_tokens_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp9_ = FALSE;
				_tmp9_ = TRUE;
				while (TRUE) {
					gchar** _tmp11_;
					gint _tmp11__length1;
					gchar** _tmp12_;
					gint _tmp12__length1;
					gchar** _tmp13_;
					gint _tmp13__length1;
					const gchar* _tmp14_;
					gchar* _tmp15_;
					if (!_tmp9_) {
						gint _tmp10_;
						_tmp10_ = i;
						i = _tmp10_ + 1;
					}
					_tmp9_ = FALSE;
					_tmp11_ = unicode_tokens;
					_tmp11__length1 = unicode_tokens_length1;
					if (!(i < _tmp11__length1)) {
						break;
					}
					_tmp12_ = all_tokens;
					_tmp12__length1 = all_tokens_length1;
					_tmp13_ = unicode_tokens;
					_tmp13__length1 = unicode_tokens_length1;
					_tmp14_ = _tmp13_[i];
					_tmp15_ = g_strdup (_tmp14_);
					_g_free0 (_tmp12_[i]);
					_tmp12_[i] = _tmp15_;
				}
			}
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp16_ = FALSE;
				_tmp16_ = TRUE;
				while (TRUE) {
					gchar** _tmp18_;
					gint _tmp18__length1;
					gchar** _tmp19_;
					gint _tmp19__length1;
					gchar** _tmp20_;
					gint _tmp20__length1;
					gchar** _tmp21_;
					gint _tmp21__length1;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					if (!_tmp16_) {
						gint _tmp17_;
						_tmp17_ = i;
						i = _tmp17_ + 1;
					}
					_tmp16_ = FALSE;
					_tmp18_ = ascii_tokens;
					_tmp18__length1 = ascii_tokens_length1;
					if (!(i < _tmp18__length1)) {
						break;
					}
					_tmp19_ = all_tokens;
					_tmp19__length1 = all_tokens_length1;
					_tmp20_ = unicode_tokens;
					_tmp20__length1 = unicode_tokens_length1;
					_tmp21_ = ascii_tokens;
					_tmp21__length1 = ascii_tokens_length1;
					_tmp22_ = _tmp21_[i];
					_tmp23_ = g_strdup (_tmp22_);
					_g_free0 (_tmp19_[_tmp20__length1 + i]);
					_tmp19_[_tmp20__length1 + i] = _tmp23_;
				}
			}
		}
		_tmp24_ = all_tokens;
		_tmp24__length1 = all_tokens_length1;
		_tmp25_ = (_tmp24_ != NULL) ? _vala_array_dup1 (_tmp24_, _tmp24__length1) : _tmp24_;
		_tmp25__length1 = _tmp24__length1;
		child->search_tokens = (_vala_array_free (child->search_tokens, child->search_tokens_length1, (GDestroyNotify) g_free), NULL);
		child->search_tokens = _tmp25_;
		child->search_tokens_length1 = _tmp25__length1;
		all_tokens = (_vala_array_free (all_tokens, all_tokens_length1, (GDestroyNotify) g_free), NULL);
		ascii_tokens = (_vala_array_free (ascii_tokens, ascii_tokens_length1, (GDestroyNotify) g_free), NULL);
		unicode_tokens = (_vala_array_free (unicode_tokens, unicode_tokens_length1, (GDestroyNotify) g_free), NULL);
	}
	all_matched = TRUE;
	{
		gchar** needle_collection = NULL;
		gint needle_collection_length1 = 0;
		gint _needle_collection_size_ = 0;
		gint needle_it = 0;
		needle_collection = _data4_->needle_tokens;
		needle_collection_length1 = _data4_->needle_tokens_length1;
		for (needle_it = 0; needle_it < needle_collection_length1; needle_it = needle_it + 1) {
			gchar* _tmp26_;
			gchar* needle = NULL;
			_tmp26_ = g_strdup (needle_collection[needle_it]);
			needle = _tmp26_;
			{
				gboolean needle_matched = FALSE;
				gchar** _tmp27_;
				gint _tmp27__length1;
				needle_matched = FALSE;
				_tmp27_ = child->search_tokens;
				_tmp27__length1 = child->search_tokens_length1;
				{
					gchar** token_collection = NULL;
					gint token_collection_length1 = 0;
					gint _token_collection_size_ = 0;
					gint token_it = 0;
					token_collection = _tmp27_;
					token_collection_length1 = _tmp27__length1;
					for (token_it = 0; token_it < token_collection_length1; token_it = token_it + 1) {
						gchar* _tmp28_;
						gchar* token = NULL;
						_tmp28_ = g_strdup (token_collection[token_it]);
						token = _tmp28_;
						{
							const gchar* _tmp29_;
							const gchar* _tmp30_;
							_tmp29_ = token;
							_tmp30_ = needle;
							if (string_contains (_tmp29_, _tmp30_)) {
								needle_matched = TRUE;
								_g_free0 (token);
								break;
							}
							_g_free0 (token);
						}
					}
				}
				if (!needle_matched) {
					all_matched = FALSE;
					_g_free0 (needle);
					break;
				}
				_g_free0 (needle);
			}
		}
	}
	if (all_matched) {
		file_store_insert_file (self, child);
	}
	file_store_recursive_search (self, _data4_->needle_tokens, (gint) _data4_->needle_tokens_length1, child);
}

static void
___lambda7__gh_func (gconstpointer key,
                     gconstpointer value,
                     gpointer self)
{
	__lambda7_ (self, (const gchar*) key, (DejaDupFileTreeNode*) value);
}

static void
file_store_recursive_search (FileStore* self,
                             gchar** needle_tokens,
                             gint needle_tokens_length1,
                             DejaDupFileTreeNode* node)
{
	Block4Data* _data4_;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_data4_->needle_tokens = needle_tokens;
	_data4_->needle_tokens_length1 = needle_tokens_length1;
	_tmp0_ = deja_dup_file_tree_node_get_children (node);
	_tmp1_ = _tmp0_;
	g_hash_table_foreach (_tmp1_, ___lambda7__gh_func, _data4_);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
__lambda5_ (FileStore* self,
            const gchar* name,
            DejaDupFileTreeNode* child)
{
	g_return_if_fail (name != NULL);
	g_return_if_fail (child != NULL);
	file_store_insert_file (self, child);
}

static void
___lambda5__gh_func (gconstpointer key,
                     gconstpointer value,
                     gpointer self)
{
	__lambda5_ ((FileStore*) self, (const gchar*) key, (DejaDupFileTreeNode*) value);
}

static void
file_store_move_to (FileStore* self,
                    DejaDupFileTreeNode* node)
{
	gint removed = 0;
	DejaDupFileTreeNode* _tmp0_;
	DejaDupFileTree* _tmp1_;
	DejaDupFileTreeNode* _tmp2_;
	DejaDupFileTreeNode* _tmp3_;
	DejaDupFileTreeNode* _tmp4_;
	GHashTable* _tmp5_;
	GHashTable* _tmp6_;
	GPtrArray* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	removed = file_store_clear_full (self);
	g_list_model_items_changed ((GListModel*) self, (guint) 0, (guint) removed, (guint) 0);
	file_store_set_current (self, node);
	_tmp0_ = self->priv->_current;
	_tmp1_ = self->priv->_tree;
	_tmp2_ = deja_dup_file_tree_get_root (_tmp1_);
	_tmp3_ = _tmp2_;
	file_store_set_can_go_up (self, _tmp0_ != _tmp3_);
	_tmp4_ = self->priv->_current;
	_tmp5_ = deja_dup_file_tree_node_get_children (_tmp4_);
	_tmp6_ = _tmp5_;
	g_hash_table_foreach (_tmp6_, ___lambda5__gh_func, self);
	file_store_sort (self);
	_tmp7_ = self->priv->items;
	_tmp8_ = vala_g_ptr_array_get_length (_tmp7_);
	_tmp9_ = _tmp8_;
	g_list_model_items_changed ((GListModel*) self, (guint) 0, (guint) 0, (guint) _tmp9_);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		GPtrArray* self;
		self = _data5_->self;
		_g_ptr_array_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gint
__lambda0_ (Block5Data* _data5_,
            gconstpointer** a,
            gconstpointer** b)
{
	GPtrArray* self;
	gint result;
	self = _data5_->self;
	result = _data5_->compare_func ((gconstpointer**) (*a), (gconstpointer**) (*b));
	return result;
}

static gint
___lambda0__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda0_ (self, a, b);
	return result;
}

static void
vala_g_ptr_array_sort (GPtrArray* self,
                       GCompareFunc compare_func)
{
	Block5Data* _data5_;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_ptr_array_ref (self);
	_data5_->compare_func = compare_func;
	g_ptr_array_sort_with_data (self, ___lambda0__gcompare_data_func, _data5_);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static gint
__lambda6_ (FileStoreItem* a,
            FileStoreItem* b)
{
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = file_store_item_get_collate_key (a);
	_tmp2_ = _tmp1_;
	_tmp3_ = file_store_item_get_collate_key (b);
	_tmp4_ = _tmp3_;
	result = _tmp0_ (_tmp2_, _tmp4_);
	return result;
}

static gint
___lambda6__gcompare_func (gconstpointer a,
                           gconstpointer b)
{
	gint result;
	result = __lambda6_ ((FileStoreItem*) a, (FileStoreItem*) b);
	return result;
}

static void
file_store_sort (FileStore* self)
{
	GPtrArray* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->items;
	vala_g_ptr_array_sort (_tmp0_, ___lambda6__gcompare_func);
}

static void
file_store_insert_file (FileStore* self,
                        DejaDupFileTreeNode* node)
{
	const gchar* _tmp0_ = NULL;
	GFileType _tmp1_;
	GFileType _tmp2_;
	gchar* prefix = NULL;
	gchar* _tmp3_;
	gchar* key = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* collate_key = NULL;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	GFileType _tmp14_;
	GFileType _tmp15_;
	gchar* content_type = NULL;
	gchar* _tmp20_;
	GIcon* icon = NULL;
	const gchar* _tmp21_;
	GIcon* _tmp22_;
	GIcon* emblem = NULL;
	GFileType _tmp23_;
	GFileType _tmp24_;
	gchar* description = NULL;
	gchar* _tmp26_;
	GFileType _tmp27_;
	GFileType _tmp28_;
	DejaDupFileTreeNode* iter = NULL;
	gchar* path = NULL;
	gchar* _tmp33_;
	GPtrArray* _tmp57_;
	const gchar* _tmp58_;
	const gchar* _tmp59_;
	GIcon* _tmp60_;
	GIcon* _tmp61_;
	const gchar* _tmp62_;
	FileStoreItem* _tmp63_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp1_ = deja_dup_file_tree_node_get_kind (node);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == G_FILE_TYPE_DIRECTORY) {
		_tmp0_ = "0:";
	} else {
		_tmp0_ = "1:";
	}
	_tmp3_ = g_strdup (_tmp0_);
	prefix = _tmp3_;
	_tmp4_ = deja_dup_file_tree_node_get_filename (node);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_utf8_casefold (_tmp5_, (gssize) -1);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_utf8_collate_key_for_filename (_tmp7_, (gssize) -1);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	key = _tmp9_;
	_tmp10_ = prefix;
	_tmp11_ = key;
	_tmp12_ = g_strconcat (_tmp10_, _tmp11_, NULL);
	collate_key = _tmp12_;
	_tmp14_ = deja_dup_file_tree_node_get_kind (node);
	_tmp15_ = _tmp14_;
	if (_tmp15_ == G_FILE_TYPE_DIRECTORY) {
		gchar* _tmp16_;
		_tmp16_ = g_content_type_from_mime_type ("inode/directory");
		_g_free0 (_tmp13_);
		_tmp13_ = _tmp16_;
	} else {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp17_ = deja_dup_file_tree_node_get_filename (node);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_content_type_guess (_tmp18_, NULL, (gsize) 0, NULL);
		_g_free0 (_tmp13_);
		_tmp13_ = _tmp19_;
	}
	_tmp20_ = g_strdup (_tmp13_);
	content_type = _tmp20_;
	_tmp21_ = content_type;
	_tmp22_ = g_content_type_get_icon (_tmp21_);
	icon = _tmp22_;
	emblem = NULL;
	_tmp23_ = deja_dup_file_tree_node_get_kind (node);
	_tmp24_ = _tmp23_;
	if (_tmp24_ == G_FILE_TYPE_SYMBOLIC_LINK) {
		GThemedIcon* _tmp25_;
		_tmp25_ = (GThemedIcon*) g_themed_icon_new ("emblem-symbolic-link");
		_g_object_unref0 (emblem);
		emblem = (GIcon*) _tmp25_;
	}
	_tmp26_ = g_strdup (_ ("File"));
	description = _tmp26_;
	_tmp27_ = deja_dup_file_tree_node_get_kind (node);
	_tmp28_ = _tmp27_;
	if (_tmp28_ == G_FILE_TYPE_SYMBOLIC_LINK) {
		gchar* _tmp29_;
		_tmp29_ = g_strdup (_ ("Link"));
		_g_free0 (description);
		description = _tmp29_;
	} else {
		GFileType _tmp30_;
		GFileType _tmp31_;
		_tmp30_ = deja_dup_file_tree_node_get_kind (node);
		_tmp31_ = _tmp30_;
		if (_tmp31_ == G_FILE_TYPE_DIRECTORY) {
			gchar* _tmp32_;
			_tmp32_ = g_strdup (_ ("Folder"));
			_g_free0 (description);
			description = _tmp32_;
		}
	}
	iter = node;
	_tmp33_ = g_strdup ("");
	path = _tmp33_;
	while (TRUE) {
		DejaDupFileTreeNode* _tmp34_;
		DejaDupFileTreeNode* _tmp35_;
		DejaDupFileTreeNode* _tmp36_;
		DejaDupFileTree* _tmp37_;
		DejaDupFileTreeNode* _tmp38_;
		DejaDupFileTreeNode* _tmp39_;
		const gchar* _tmp40_;
		DejaDupFileTreeNode* _tmp54_;
		DejaDupFileTreeNode* _tmp55_;
		DejaDupFileTreeNode* _tmp56_;
		_tmp34_ = iter;
		_tmp35_ = deja_dup_file_tree_node_get_parent (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = self->priv->_tree;
		_tmp38_ = deja_dup_file_tree_get_root (_tmp37_);
		_tmp39_ = _tmp38_;
		if (!(_tmp36_ != _tmp39_)) {
			break;
		}
		_tmp40_ = path;
		if (g_strcmp0 (_tmp40_, "") == 0) {
			DejaDupFileTreeNode* _tmp41_;
			DejaDupFileTreeNode* _tmp42_;
			DejaDupFileTreeNode* _tmp43_;
			const gchar* _tmp44_;
			const gchar* _tmp45_;
			gchar* _tmp46_;
			_tmp41_ = iter;
			_tmp42_ = deja_dup_file_tree_node_get_parent (_tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = deja_dup_file_tree_node_get_filename (_tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = g_strdup (_tmp45_);
			_g_free0 (path);
			path = _tmp46_;
		} else {
			DejaDupFileTreeNode* _tmp47_;
			DejaDupFileTreeNode* _tmp48_;
			DejaDupFileTreeNode* _tmp49_;
			const gchar* _tmp50_;
			const gchar* _tmp51_;
			const gchar* _tmp52_;
			gchar* _tmp53_;
			_tmp47_ = iter;
			_tmp48_ = deja_dup_file_tree_node_get_parent (_tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = deja_dup_file_tree_node_get_filename (_tmp49_);
			_tmp51_ = _tmp50_;
			_tmp52_ = path;
			_tmp53_ = g_build_filename (_tmp51_, _tmp52_, NULL);
			_g_free0 (path);
			path = _tmp53_;
		}
		_tmp54_ = iter;
		_tmp55_ = deja_dup_file_tree_node_get_parent (_tmp54_);
		_tmp56_ = _tmp55_;
		iter = _tmp56_;
	}
	_tmp57_ = self->priv->items;
	_tmp58_ = collate_key;
	_tmp59_ = path;
	_tmp60_ = icon;
	_tmp61_ = emblem;
	_tmp62_ = description;
	_tmp63_ = file_store_item_new (node, _tmp58_, _tmp59_, _tmp60_, _tmp61_, _tmp62_);
	g_ptr_array_add (_tmp57_, _tmp63_);
	_g_free0 (path);
	_g_free0 (description);
	_g_object_unref0 (emblem);
	_g_object_unref0 (icon);
	_g_free0 (content_type);
	_g_free0 (_tmp13_);
	_g_free0 (collate_key);
	_g_free0 (key);
	_g_free0 (prefix);
}

FileStore*
file_store_construct (GType object_type)
{
	FileStore * self = NULL;
	self = (FileStore*) g_object_new (object_type, NULL);
	return self;
}

FileStore*
file_store_new (void)
{
	return file_store_construct (TYPE_FILE_STORE);
}

DejaDupFileTree*
file_store_get_tree (FileStore* self)
{
	DejaDupFileTree* result;
	DejaDupFileTree* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_tree;
	result = _tmp0_;
	return result;
}

static void
file_store_set_tree (FileStore* self,
                     DejaDupFileTree* value)
{
	DejaDupFileTree* old_value;
	g_return_if_fail (self != NULL);
	old_value = file_store_get_tree (self);
	if (old_value != value) {
		DejaDupFileTree* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_tree);
		self->priv->_tree = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, file_store_properties[FILE_STORE_TREE_PROPERTY]);
	}
}

DejaDupFileTreeNode*
file_store_get_current (FileStore* self)
{
	DejaDupFileTreeNode* result;
	DejaDupFileTreeNode* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current;
	result = _tmp0_;
	return result;
}

static void
file_store_set_current (FileStore* self,
                        DejaDupFileTreeNode* value)
{
	DejaDupFileTreeNode* old_value;
	g_return_if_fail (self != NULL);
	old_value = file_store_get_current (self);
	if (old_value != value) {
		DejaDupFileTreeNode* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_current);
		self->priv->_current = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, file_store_properties[FILE_STORE_CURRENT_PROPERTY]);
	}
}

gboolean
file_store_get_can_go_up (FileStore* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_can_go_up;
	return result;
}

static void
file_store_set_can_go_up (FileStore* self,
                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = file_store_get_can_go_up (self);
	if (old_value != value) {
		self->priv->_can_go_up = value;
		g_object_notify_by_pspec ((GObject *) self, file_store_properties[FILE_STORE_CAN_GO_UP_PROPERTY]);
	}
}

const gchar*
file_store_get_search_filter (FileStore* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_search_filter;
	result = _tmp0_;
	return result;
}

void
file_store_set_search_filter (FileStore* self,
                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = file_store_get_search_filter (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_search_filter);
		self->priv->_search_filter = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, file_store_properties[FILE_STORE_SEARCH_FILTER_PROPERTY]);
	}
}

static inline gpointer
file_store_item_get_instance_private (FileStoreItem* self)
{
	return G_STRUCT_MEMBER_P (self, FileStoreItem_private_offset);
}

FileStoreItem*
file_store_item_construct (GType object_type,
                           DejaDupFileTreeNode* node,
                           const gchar* collate_key,
                           const gchar* path,
                           GIcon* icon,
                           GIcon* emblem,
                           const gchar* description)
{
	FileStoreItem * self = NULL;
	g_return_val_if_fail (node != NULL, NULL);
	g_return_val_if_fail (collate_key != NULL, NULL);
	g_return_val_if_fail (icon != NULL, NULL);
	self = (FileStoreItem*) g_object_new (object_type, "node", node, "collate-key", collate_key, "path", path, "icon", icon, "emblem", emblem, "description", description, NULL);
	return self;
}

FileStoreItem*
file_store_item_new (DejaDupFileTreeNode* node,
                     const gchar* collate_key,
                     const gchar* path,
                     GIcon* icon,
                     GIcon* emblem,
                     const gchar* description)
{
	return file_store_item_construct (FILE_STORE_TYPE_ITEM, node, collate_key, path, icon, emblem, description);
}

DejaDupFileTreeNode*
file_store_item_get_node (FileStoreItem* self)
{
	DejaDupFileTreeNode* result;
	DejaDupFileTreeNode* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_node;
	result = _tmp0_;
	return result;
}

static void
file_store_item_set_node (FileStoreItem* self,
                          DejaDupFileTreeNode* value)
{
	DejaDupFileTreeNode* old_value;
	g_return_if_fail (self != NULL);
	old_value = file_store_item_get_node (self);
	if (old_value != value) {
		DejaDupFileTreeNode* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_node);
		self->priv->_node = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, file_store_item_properties[FILE_STORE_ITEM_NODE_PROPERTY]);
	}
}

const gchar*
file_store_item_get_filename (FileStoreItem* self)
{
	const gchar* result;
	DejaDupFileTreeNode* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_node;
	_tmp1_ = deja_dup_file_tree_node_get_filename (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

const gchar*
file_store_item_get_collate_key (FileStoreItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_collate_key;
	result = _tmp0_;
	return result;
}

static void
file_store_item_set_collate_key (FileStoreItem* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = file_store_item_get_collate_key (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_collate_key);
		self->priv->_collate_key = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, file_store_item_properties[FILE_STORE_ITEM_COLLATE_KEY_PROPERTY]);
	}
}

const gchar*
file_store_item_get_path (FileStoreItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_path;
	result = _tmp0_;
	return result;
}

static void
file_store_item_set_path (FileStoreItem* self,
                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = file_store_item_get_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_path);
		self->priv->_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, file_store_item_properties[FILE_STORE_ITEM_PATH_PROPERTY]);
	}
}

GIcon*
file_store_item_get_icon (FileStoreItem* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}

static void
file_store_item_set_icon (FileStoreItem* self,
                          GIcon* value)
{
	GIcon* old_value;
	g_return_if_fail (self != NULL);
	old_value = file_store_item_get_icon (self);
	if (old_value != value) {
		GIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_icon);
		self->priv->_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, file_store_item_properties[FILE_STORE_ITEM_ICON_PROPERTY]);
	}
}

GIcon*
file_store_item_get_emblem (FileStoreItem* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_emblem;
	result = _tmp0_;
	return result;
}

static void
file_store_item_set_emblem (FileStoreItem* self,
                            GIcon* value)
{
	GIcon* old_value;
	g_return_if_fail (self != NULL);
	old_value = file_store_item_get_emblem (self);
	if (old_value != value) {
		GIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_emblem);
		self->priv->_emblem = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, file_store_item_properties[FILE_STORE_ITEM_EMBLEM_PROPERTY]);
	}
}

const gchar*
file_store_item_get_description (FileStoreItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

static void
file_store_item_set_description (FileStoreItem* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = file_store_item_get_description (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, file_store_item_properties[FILE_STORE_ITEM_DESCRIPTION_PROPERTY]);
	}
}

static void
file_store_item_class_init (FileStoreItemClass * klass,
                            gpointer klass_data)
{
	file_store_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FileStoreItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_file_store_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_file_store_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = file_store_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILE_STORE_ITEM_NODE_PROPERTY, file_store_item_properties[FILE_STORE_ITEM_NODE_PROPERTY] = g_param_spec_object ("node", "node", "node", DEJA_DUP_FILE_TREE_TYPE_NODE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILE_STORE_ITEM_FILENAME_PROPERTY, file_store_item_properties[FILE_STORE_ITEM_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILE_STORE_ITEM_COLLATE_KEY_PROPERTY, file_store_item_properties[FILE_STORE_ITEM_COLLATE_KEY_PROPERTY] = g_param_spec_string ("collate-key", "collate-key", "collate-key", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILE_STORE_ITEM_PATH_PROPERTY, file_store_item_properties[FILE_STORE_ITEM_PATH_PROPERTY] = g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILE_STORE_ITEM_ICON_PROPERTY, file_store_item_properties[FILE_STORE_ITEM_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILE_STORE_ITEM_EMBLEM_PROPERTY, file_store_item_properties[FILE_STORE_ITEM_EMBLEM_PROPERTY] = g_param_spec_object ("emblem", "emblem", "emblem", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILE_STORE_ITEM_DESCRIPTION_PROPERTY, file_store_item_properties[FILE_STORE_ITEM_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
file_store_item_instance_init (FileStoreItem * self,
                               gpointer klass)
{
	self->priv = file_store_item_get_instance_private (self);
}

static void
file_store_item_finalize (GObject * obj)
{
	FileStoreItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILE_STORE_TYPE_ITEM, FileStoreItem);
	_g_object_unref0 (self->priv->_node);
	_g_free0 (self->priv->_collate_key);
	_g_free0 (self->priv->_path);
	_g_object_unref0 (self->priv->_icon);
	_g_object_unref0 (self->priv->_emblem);
	_g_free0 (self->priv->_description);
	G_OBJECT_CLASS (file_store_item_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
file_store_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FileStoreItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) file_store_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FileStoreItem), 0, (GInstanceInitFunc) file_store_item_instance_init, NULL };
	GType file_store_item_type_id;
	file_store_item_type_id = g_type_register_static (G_TYPE_OBJECT, "FileStoreItem", &g_define_type_info, 0);
	FileStoreItem_private_offset = g_type_add_instance_private (file_store_item_type_id, sizeof (FileStoreItemPrivate));
	return file_store_item_type_id;
}

GType
file_store_item_get_type (void)
{
	static gsize file_store_item_type_id__once = 0;
	if (g_once_init_enter (&file_store_item_type_id__once)) {
		GType file_store_item_type_id;
		file_store_item_type_id = file_store_item_get_type_once ();
		g_once_init_leave (&file_store_item_type_id__once, file_store_item_type_id);
	}
	return file_store_item_type_id__once;
}

static void
_vala_file_store_item_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	FileStoreItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILE_STORE_TYPE_ITEM, FileStoreItem);
	switch (property_id) {
		case FILE_STORE_ITEM_NODE_PROPERTY:
		g_value_set_object (value, file_store_item_get_node (self));
		break;
		case FILE_STORE_ITEM_FILENAME_PROPERTY:
		g_value_set_string (value, file_store_item_get_filename (self));
		break;
		case FILE_STORE_ITEM_COLLATE_KEY_PROPERTY:
		g_value_set_string (value, file_store_item_get_collate_key (self));
		break;
		case FILE_STORE_ITEM_PATH_PROPERTY:
		g_value_set_string (value, file_store_item_get_path (self));
		break;
		case FILE_STORE_ITEM_ICON_PROPERTY:
		g_value_set_object (value, file_store_item_get_icon (self));
		break;
		case FILE_STORE_ITEM_EMBLEM_PROPERTY:
		g_value_set_object (value, file_store_item_get_emblem (self));
		break;
		case FILE_STORE_ITEM_DESCRIPTION_PROPERTY:
		g_value_set_string (value, file_store_item_get_description (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_file_store_item_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	FileStoreItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILE_STORE_TYPE_ITEM, FileStoreItem);
	switch (property_id) {
		case FILE_STORE_ITEM_NODE_PROPERTY:
		file_store_item_set_node (self, g_value_get_object (value));
		break;
		case FILE_STORE_ITEM_COLLATE_KEY_PROPERTY:
		file_store_item_set_collate_key (self, g_value_get_string (value));
		break;
		case FILE_STORE_ITEM_PATH_PROPERTY:
		file_store_item_set_path (self, g_value_get_string (value));
		break;
		case FILE_STORE_ITEM_ICON_PROPERTY:
		file_store_item_set_icon (self, g_value_get_object (value));
		break;
		case FILE_STORE_ITEM_EMBLEM_PROPERTY:
		file_store_item_set_emblem (self, g_value_get_object (value));
		break;
		case FILE_STORE_ITEM_DESCRIPTION_PROPERTY:
		file_store_item_set_description (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_file_store_update_search_g_object_notify (GObject* _sender,
                                           GParamSpec* pspec,
                                           gpointer self)
{
	file_store_update_search ((FileStore*) self);
}

static GObject *
file_store_constructor (GType type,
                        guint n_construct_properties,
                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FileStore * self;
	GPtrArray* _tmp0_;
	parent_class = G_OBJECT_CLASS (file_store_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FILE_STORE, FileStore);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_g_ptr_array_unref0 (self->priv->items);
	self->priv->items = _tmp0_;
	g_signal_connect_object ((GObject*) self, "notify::search-filter", (GCallback) _file_store_update_search_g_object_notify, self, 0);
	return obj;
}

static void
file_store_class_init (FileStoreClass * klass,
                       gpointer klass_data)
{
	file_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FileStore_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_file_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_file_store_set_property;
	G_OBJECT_CLASS (klass)->constructor = file_store_constructor;
	G_OBJECT_CLASS (klass)->finalize = file_store_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILE_STORE_TREE_PROPERTY, file_store_properties[FILE_STORE_TREE_PROPERTY] = g_param_spec_object ("tree", "tree", "tree", DEJA_DUP_TYPE_FILE_TREE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILE_STORE_CURRENT_PROPERTY, file_store_properties[FILE_STORE_CURRENT_PROPERTY] = g_param_spec_object ("current", "current", "current", DEJA_DUP_FILE_TREE_TYPE_NODE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILE_STORE_CAN_GO_UP_PROPERTY, file_store_properties[FILE_STORE_CAN_GO_UP_PROPERTY] = g_param_spec_boolean ("can-go-up", "can-go-up", "can-go-up", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILE_STORE_SEARCH_FILTER_PROPERTY, file_store_properties[FILE_STORE_SEARCH_FILTER_PROPERTY] = g_param_spec_string ("search-filter", "search-filter", "search-filter", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
file_store_g_list_model_interface_init (GListModelInterface * iface,
                                        gpointer iface_data)
{
	file_store_g_list_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_item_type = (GType (*) (GListModel*)) file_store_real_get_item_type;
	iface->get_n_items = (guint (*) (GListModel*)) file_store_real_get_n_items;
	iface->get_item = (GObject* (*) (GListModel*, guint)) file_store_real_get_item;
}

static void
file_store_instance_init (FileStore * self,
                          gpointer klass)
{
	self->priv = file_store_get_instance_private (self);
	self->priv->_tree = NULL;
	self->priv->_can_go_up = FALSE;
	self->priv->_search_filter = NULL;
}

static void
file_store_finalize (GObject * obj)
{
	FileStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FILE_STORE, FileStore);
	_g_object_unref0 (self->priv->_tree);
	_g_object_unref0 (self->priv->_current);
	_g_free0 (self->priv->_search_filter);
	_g_ptr_array_unref0 (self->priv->items);
	G_OBJECT_CLASS (file_store_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
file_store_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FileStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) file_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FileStore), 0, (GInstanceInitFunc) file_store_instance_init, NULL };
	static const GInterfaceInfo g_list_model_info = { (GInterfaceInitFunc) file_store_g_list_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType file_store_type_id;
	file_store_type_id = g_type_register_static (G_TYPE_OBJECT, "FileStore", &g_define_type_info, 0);
	g_type_add_interface_static (file_store_type_id, g_list_model_get_type (), &g_list_model_info);
	FileStore_private_offset = g_type_add_instance_private (file_store_type_id, sizeof (FileStorePrivate));
	return file_store_type_id;
}

GType
file_store_get_type (void)
{
	static gsize file_store_type_id__once = 0;
	if (g_once_init_enter (&file_store_type_id__once)) {
		GType file_store_type_id;
		file_store_type_id = file_store_get_type_once ();
		g_once_init_leave (&file_store_type_id__once, file_store_type_id);
	}
	return file_store_type_id__once;
}

static void
_vala_file_store_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	FileStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FILE_STORE, FileStore);
	switch (property_id) {
		case FILE_STORE_TREE_PROPERTY:
		g_value_set_object (value, file_store_get_tree (self));
		break;
		case FILE_STORE_CURRENT_PROPERTY:
		g_value_set_object (value, file_store_get_current (self));
		break;
		case FILE_STORE_CAN_GO_UP_PROPERTY:
		g_value_set_boolean (value, file_store_get_can_go_up (self));
		break;
		case FILE_STORE_SEARCH_FILTER_PROPERTY:
		g_value_set_string (value, file_store_get_search_filter (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_file_store_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	FileStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FILE_STORE, FileStore);
	switch (property_id) {
		case FILE_STORE_TREE_PROPERTY:
		file_store_set_tree (self, g_value_get_object (value));
		break;
		case FILE_STORE_CURRENT_PROPERTY:
		file_store_set_current (self, g_value_get_object (value));
		break;
		case FILE_STORE_CAN_GO_UP_PROPERTY:
		file_store_set_can_go_up (self, g_value_get_boolean (value));
		break;
		case FILE_STORE_SEARCH_FILTER_PROPERTY:
		file_store_set_search_filter (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

