// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package idtui

import (
	"context"
	"dagger.io/dagger"
	tea "github.com/charmbracelet/bubbletea"
	"github.com/charmbracelet/huh"
	"github.com/dagger/dagger/dagql/dagui"
	"github.com/dagger/dagger/util/cleanups"
	sdklog "go.opentelemetry.io/otel/sdk/log"
	sdkmetric "go.opentelemetry.io/otel/sdk/metric"
	sdktrace "go.opentelemetry.io/otel/sdk/trace"
	"sync"
)

// Ensure, that FrontendMock does implement Frontend.
// If this is not the case, regenerate this file with moq.
var _ Frontend = &FrontendMock{}

// FrontendMock is a mock implementation of Frontend.
//
//	func TestSomethingThatUsesFrontend(t *testing.T) {
//
//		// make and configure a mocked Frontend
//		mockedFrontend := &FrontendMock{
//			BackgroundFunc: func(cmd tea.ExecCommand, raw bool) error {
//				panic("mock out the Background method")
//			},
//			HandleFormFunc: func(ctx context.Context, form *huh.Form) error {
//				panic("mock out the HandleForm method")
//			},
//			HandlePromptFunc: func(ctx context.Context, title string, prompt string, dest any) error {
//				panic("mock out the HandlePrompt method")
//			},
//			LogExporterFunc: func() sdklog.Exporter {
//				panic("mock out the LogExporter method")
//			},
//			MetricExporterFunc: func() sdkmetric.Exporter {
//				panic("mock out the MetricExporter method")
//			},
//			OptsFunc: func() *dagui.FrontendOpts {
//				panic("mock out the Opts method")
//			},
//			RevealAllSpansFunc: func()  {
//				panic("mock out the RevealAllSpans method")
//			},
//			RunFunc: func(ctx context.Context, opts dagui.FrontendOpts, f func(context.Context) (cleanups.CleanupF, error)) error {
//				panic("mock out the Run method")
//			},
//			SetClientFunc: func(client *dagger.Client)  {
//				panic("mock out the SetClient method")
//			},
//			SetCloudURLFunc: func(ctx context.Context, url string, msg string, logged bool)  {
//				panic("mock out the SetCloudURL method")
//			},
//			SetPrimaryFunc: func(spanID dagui.SpanID)  {
//				panic("mock out the SetPrimary method")
//			},
//			SetSidebarContentFunc: func(sidebarSection SidebarSection)  {
//				panic("mock out the SetSidebarContent method")
//			},
//			SetVerbosityFunc: func(n int)  {
//				panic("mock out the SetVerbosity method")
//			},
//			ShellFunc: func(ctx context.Context, handler ShellHandler)  {
//				panic("mock out the Shell method")
//			},
//			SpanExporterFunc: func() sdktrace.SpanExporter {
//				panic("mock out the SpanExporter method")
//			},
//		}
//
//		// use mockedFrontend in code that requires Frontend
//		// and then make assertions.
//
//	}
type FrontendMock struct {
	// BackgroundFunc mocks the Background method.
	BackgroundFunc func(cmd tea.ExecCommand, raw bool) error

	// HandleFormFunc mocks the HandleForm method.
	HandleFormFunc func(ctx context.Context, form *huh.Form) error

	// HandlePromptFunc mocks the HandlePrompt method.
	HandlePromptFunc func(ctx context.Context, title string, prompt string, dest any) error

	// LogExporterFunc mocks the LogExporter method.
	LogExporterFunc func() sdklog.Exporter

	// MetricExporterFunc mocks the MetricExporter method.
	MetricExporterFunc func() sdkmetric.Exporter

	// OptsFunc mocks the Opts method.
	OptsFunc func() *dagui.FrontendOpts

	// RevealAllSpansFunc mocks the RevealAllSpans method.
	RevealAllSpansFunc func()

	// RunFunc mocks the Run method.
	RunFunc func(ctx context.Context, opts dagui.FrontendOpts, f func(context.Context) (cleanups.CleanupF, error)) error

	// SetClientFunc mocks the SetClient method.
	SetClientFunc func(client *dagger.Client)

	// SetCloudURLFunc mocks the SetCloudURL method.
	SetCloudURLFunc func(ctx context.Context, url string, msg string, logged bool)

	// SetPrimaryFunc mocks the SetPrimary method.
	SetPrimaryFunc func(spanID dagui.SpanID)

	// SetSidebarContentFunc mocks the SetSidebarContent method.
	SetSidebarContentFunc func(sidebarSection SidebarSection)

	// SetVerbosityFunc mocks the SetVerbosity method.
	SetVerbosityFunc func(n int)

	// ShellFunc mocks the Shell method.
	ShellFunc func(ctx context.Context, handler ShellHandler)

	// SpanExporterFunc mocks the SpanExporter method.
	SpanExporterFunc func() sdktrace.SpanExporter

	// calls tracks calls to the methods.
	calls struct {
		// Background holds details about calls to the Background method.
		Background []struct {
			// Cmd is the cmd argument value.
			Cmd tea.ExecCommand
			// Raw is the raw argument value.
			Raw bool
		}
		// HandleForm holds details about calls to the HandleForm method.
		HandleForm []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Form is the form argument value.
			Form *huh.Form
		}
		// HandlePrompt holds details about calls to the HandlePrompt method.
		HandlePrompt []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Title is the title argument value.
			Title string
			// Prompt is the prompt argument value.
			Prompt string
			// Dest is the dest argument value.
			Dest any
		}
		// LogExporter holds details about calls to the LogExporter method.
		LogExporter []struct {
		}
		// MetricExporter holds details about calls to the MetricExporter method.
		MetricExporter []struct {
		}
		// Opts holds details about calls to the Opts method.
		Opts []struct {
		}
		// RevealAllSpans holds details about calls to the RevealAllSpans method.
		RevealAllSpans []struct {
		}
		// Run holds details about calls to the Run method.
		Run []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Opts is the opts argument value.
			Opts dagui.FrontendOpts
			// F is the f argument value.
			F func(context.Context) (cleanups.CleanupF, error)
		}
		// SetClient holds details about calls to the SetClient method.
		SetClient []struct {
			// Client is the client argument value.
			Client *dagger.Client
		}
		// SetCloudURL holds details about calls to the SetCloudURL method.
		SetCloudURL []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// URL is the url argument value.
			URL string
			// Msg is the msg argument value.
			Msg string
			// Logged is the logged argument value.
			Logged bool
		}
		// SetPrimary holds details about calls to the SetPrimary method.
		SetPrimary []struct {
			// SpanID is the spanID argument value.
			SpanID dagui.SpanID
		}
		// SetSidebarContent holds details about calls to the SetSidebarContent method.
		SetSidebarContent []struct {
			// SidebarSection is the sidebarSection argument value.
			SidebarSection SidebarSection
		}
		// SetVerbosity holds details about calls to the SetVerbosity method.
		SetVerbosity []struct {
			// N is the n argument value.
			N int
		}
		// Shell holds details about calls to the Shell method.
		Shell []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Handler is the handler argument value.
			Handler ShellHandler
		}
		// SpanExporter holds details about calls to the SpanExporter method.
		SpanExporter []struct {
		}
	}
	lockBackground        sync.RWMutex
	lockHandleForm        sync.RWMutex
	lockHandlePrompt      sync.RWMutex
	lockLogExporter       sync.RWMutex
	lockMetricExporter    sync.RWMutex
	lockOpts              sync.RWMutex
	lockRevealAllSpans    sync.RWMutex
	lockRun               sync.RWMutex
	lockSetClient         sync.RWMutex
	lockSetCloudURL       sync.RWMutex
	lockSetPrimary        sync.RWMutex
	lockSetSidebarContent sync.RWMutex
	lockSetVerbosity      sync.RWMutex
	lockShell             sync.RWMutex
	lockSpanExporter      sync.RWMutex
}

// Background calls BackgroundFunc.
func (mock *FrontendMock) Background(cmd tea.ExecCommand, raw bool) error {
	if mock.BackgroundFunc == nil {
		panic("FrontendMock.BackgroundFunc: method is nil but Frontend.Background was just called")
	}
	callInfo := struct {
		Cmd tea.ExecCommand
		Raw bool
	}{
		Cmd: cmd,
		Raw: raw,
	}
	mock.lockBackground.Lock()
	mock.calls.Background = append(mock.calls.Background, callInfo)
	mock.lockBackground.Unlock()
	return mock.BackgroundFunc(cmd, raw)
}

// BackgroundCalls gets all the calls that were made to Background.
// Check the length with:
//
//	len(mockedFrontend.BackgroundCalls())
func (mock *FrontendMock) BackgroundCalls() []struct {
	Cmd tea.ExecCommand
	Raw bool
} {
	var calls []struct {
		Cmd tea.ExecCommand
		Raw bool
	}
	mock.lockBackground.RLock()
	calls = mock.calls.Background
	mock.lockBackground.RUnlock()
	return calls
}

// HandleForm calls HandleFormFunc.
func (mock *FrontendMock) HandleForm(ctx context.Context, form *huh.Form) error {
	if mock.HandleFormFunc == nil {
		panic("FrontendMock.HandleFormFunc: method is nil but Frontend.HandleForm was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Form *huh.Form
	}{
		Ctx:  ctx,
		Form: form,
	}
	mock.lockHandleForm.Lock()
	mock.calls.HandleForm = append(mock.calls.HandleForm, callInfo)
	mock.lockHandleForm.Unlock()
	return mock.HandleFormFunc(ctx, form)
}

// HandleFormCalls gets all the calls that were made to HandleForm.
// Check the length with:
//
//	len(mockedFrontend.HandleFormCalls())
func (mock *FrontendMock) HandleFormCalls() []struct {
	Ctx  context.Context
	Form *huh.Form
} {
	var calls []struct {
		Ctx  context.Context
		Form *huh.Form
	}
	mock.lockHandleForm.RLock()
	calls = mock.calls.HandleForm
	mock.lockHandleForm.RUnlock()
	return calls
}

// HandlePrompt calls HandlePromptFunc.
func (mock *FrontendMock) HandlePrompt(ctx context.Context, title string, prompt string, dest any) error {
	if mock.HandlePromptFunc == nil {
		panic("FrontendMock.HandlePromptFunc: method is nil but Frontend.HandlePrompt was just called")
	}
	callInfo := struct {
		Ctx    context.Context
		Title  string
		Prompt string
		Dest   any
	}{
		Ctx:    ctx,
		Title:  title,
		Prompt: prompt,
		Dest:   dest,
	}
	mock.lockHandlePrompt.Lock()
	mock.calls.HandlePrompt = append(mock.calls.HandlePrompt, callInfo)
	mock.lockHandlePrompt.Unlock()
	return mock.HandlePromptFunc(ctx, title, prompt, dest)
}

// HandlePromptCalls gets all the calls that were made to HandlePrompt.
// Check the length with:
//
//	len(mockedFrontend.HandlePromptCalls())
func (mock *FrontendMock) HandlePromptCalls() []struct {
	Ctx    context.Context
	Title  string
	Prompt string
	Dest   any
} {
	var calls []struct {
		Ctx    context.Context
		Title  string
		Prompt string
		Dest   any
	}
	mock.lockHandlePrompt.RLock()
	calls = mock.calls.HandlePrompt
	mock.lockHandlePrompt.RUnlock()
	return calls
}

// LogExporter calls LogExporterFunc.
func (mock *FrontendMock) LogExporter() sdklog.Exporter {
	if mock.LogExporterFunc == nil {
		panic("FrontendMock.LogExporterFunc: method is nil but Frontend.LogExporter was just called")
	}
	callInfo := struct {
	}{}
	mock.lockLogExporter.Lock()
	mock.calls.LogExporter = append(mock.calls.LogExporter, callInfo)
	mock.lockLogExporter.Unlock()
	return mock.LogExporterFunc()
}

// LogExporterCalls gets all the calls that were made to LogExporter.
// Check the length with:
//
//	len(mockedFrontend.LogExporterCalls())
func (mock *FrontendMock) LogExporterCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockLogExporter.RLock()
	calls = mock.calls.LogExporter
	mock.lockLogExporter.RUnlock()
	return calls
}

// MetricExporter calls MetricExporterFunc.
func (mock *FrontendMock) MetricExporter() sdkmetric.Exporter {
	if mock.MetricExporterFunc == nil {
		panic("FrontendMock.MetricExporterFunc: method is nil but Frontend.MetricExporter was just called")
	}
	callInfo := struct {
	}{}
	mock.lockMetricExporter.Lock()
	mock.calls.MetricExporter = append(mock.calls.MetricExporter, callInfo)
	mock.lockMetricExporter.Unlock()
	return mock.MetricExporterFunc()
}

// MetricExporterCalls gets all the calls that were made to MetricExporter.
// Check the length with:
//
//	len(mockedFrontend.MetricExporterCalls())
func (mock *FrontendMock) MetricExporterCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockMetricExporter.RLock()
	calls = mock.calls.MetricExporter
	mock.lockMetricExporter.RUnlock()
	return calls
}

// Opts calls OptsFunc.
func (mock *FrontendMock) Opts() *dagui.FrontendOpts {
	if mock.OptsFunc == nil {
		panic("FrontendMock.OptsFunc: method is nil but Frontend.Opts was just called")
	}
	callInfo := struct {
	}{}
	mock.lockOpts.Lock()
	mock.calls.Opts = append(mock.calls.Opts, callInfo)
	mock.lockOpts.Unlock()
	return mock.OptsFunc()
}

// OptsCalls gets all the calls that were made to Opts.
// Check the length with:
//
//	len(mockedFrontend.OptsCalls())
func (mock *FrontendMock) OptsCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockOpts.RLock()
	calls = mock.calls.Opts
	mock.lockOpts.RUnlock()
	return calls
}

// RevealAllSpans calls RevealAllSpansFunc.
func (mock *FrontendMock) RevealAllSpans() {
	if mock.RevealAllSpansFunc == nil {
		panic("FrontendMock.RevealAllSpansFunc: method is nil but Frontend.RevealAllSpans was just called")
	}
	callInfo := struct {
	}{}
	mock.lockRevealAllSpans.Lock()
	mock.calls.RevealAllSpans = append(mock.calls.RevealAllSpans, callInfo)
	mock.lockRevealAllSpans.Unlock()
	mock.RevealAllSpansFunc()
}

// RevealAllSpansCalls gets all the calls that were made to RevealAllSpans.
// Check the length with:
//
//	len(mockedFrontend.RevealAllSpansCalls())
func (mock *FrontendMock) RevealAllSpansCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockRevealAllSpans.RLock()
	calls = mock.calls.RevealAllSpans
	mock.lockRevealAllSpans.RUnlock()
	return calls
}

// Run calls RunFunc.
func (mock *FrontendMock) Run(ctx context.Context, opts dagui.FrontendOpts, f func(context.Context) (cleanups.CleanupF, error)) error {
	if mock.RunFunc == nil {
		panic("FrontendMock.RunFunc: method is nil but Frontend.Run was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Opts dagui.FrontendOpts
		F    func(context.Context) (cleanups.CleanupF, error)
	}{
		Ctx:  ctx,
		Opts: opts,
		F:    f,
	}
	mock.lockRun.Lock()
	mock.calls.Run = append(mock.calls.Run, callInfo)
	mock.lockRun.Unlock()
	return mock.RunFunc(ctx, opts, f)
}

// RunCalls gets all the calls that were made to Run.
// Check the length with:
//
//	len(mockedFrontend.RunCalls())
func (mock *FrontendMock) RunCalls() []struct {
	Ctx  context.Context
	Opts dagui.FrontendOpts
	F    func(context.Context) (cleanups.CleanupF, error)
} {
	var calls []struct {
		Ctx  context.Context
		Opts dagui.FrontendOpts
		F    func(context.Context) (cleanups.CleanupF, error)
	}
	mock.lockRun.RLock()
	calls = mock.calls.Run
	mock.lockRun.RUnlock()
	return calls
}

// SetClient calls SetClientFunc.
func (mock *FrontendMock) SetClient(client *dagger.Client) {
	if mock.SetClientFunc == nil {
		panic("FrontendMock.SetClientFunc: method is nil but Frontend.SetClient was just called")
	}
	callInfo := struct {
		Client *dagger.Client
	}{
		Client: client,
	}
	mock.lockSetClient.Lock()
	mock.calls.SetClient = append(mock.calls.SetClient, callInfo)
	mock.lockSetClient.Unlock()
	mock.SetClientFunc(client)
}

// SetClientCalls gets all the calls that were made to SetClient.
// Check the length with:
//
//	len(mockedFrontend.SetClientCalls())
func (mock *FrontendMock) SetClientCalls() []struct {
	Client *dagger.Client
} {
	var calls []struct {
		Client *dagger.Client
	}
	mock.lockSetClient.RLock()
	calls = mock.calls.SetClient
	mock.lockSetClient.RUnlock()
	return calls
}

// SetCloudURL calls SetCloudURLFunc.
func (mock *FrontendMock) SetCloudURL(ctx context.Context, url string, msg string, logged bool) {
	if mock.SetCloudURLFunc == nil {
		panic("FrontendMock.SetCloudURLFunc: method is nil but Frontend.SetCloudURL was just called")
	}
	callInfo := struct {
		Ctx    context.Context
		URL    string
		Msg    string
		Logged bool
	}{
		Ctx:    ctx,
		URL:    url,
		Msg:    msg,
		Logged: logged,
	}
	mock.lockSetCloudURL.Lock()
	mock.calls.SetCloudURL = append(mock.calls.SetCloudURL, callInfo)
	mock.lockSetCloudURL.Unlock()
	mock.SetCloudURLFunc(ctx, url, msg, logged)
}

// SetCloudURLCalls gets all the calls that were made to SetCloudURL.
// Check the length with:
//
//	len(mockedFrontend.SetCloudURLCalls())
func (mock *FrontendMock) SetCloudURLCalls() []struct {
	Ctx    context.Context
	URL    string
	Msg    string
	Logged bool
} {
	var calls []struct {
		Ctx    context.Context
		URL    string
		Msg    string
		Logged bool
	}
	mock.lockSetCloudURL.RLock()
	calls = mock.calls.SetCloudURL
	mock.lockSetCloudURL.RUnlock()
	return calls
}

// SetPrimary calls SetPrimaryFunc.
func (mock *FrontendMock) SetPrimary(spanID dagui.SpanID) {
	if mock.SetPrimaryFunc == nil {
		panic("FrontendMock.SetPrimaryFunc: method is nil but Frontend.SetPrimary was just called")
	}
	callInfo := struct {
		SpanID dagui.SpanID
	}{
		SpanID: spanID,
	}
	mock.lockSetPrimary.Lock()
	mock.calls.SetPrimary = append(mock.calls.SetPrimary, callInfo)
	mock.lockSetPrimary.Unlock()
	mock.SetPrimaryFunc(spanID)
}

// SetPrimaryCalls gets all the calls that were made to SetPrimary.
// Check the length with:
//
//	len(mockedFrontend.SetPrimaryCalls())
func (mock *FrontendMock) SetPrimaryCalls() []struct {
	SpanID dagui.SpanID
} {
	var calls []struct {
		SpanID dagui.SpanID
	}
	mock.lockSetPrimary.RLock()
	calls = mock.calls.SetPrimary
	mock.lockSetPrimary.RUnlock()
	return calls
}

// SetSidebarContent calls SetSidebarContentFunc.
func (mock *FrontendMock) SetSidebarContent(sidebarSection SidebarSection) {
	if mock.SetSidebarContentFunc == nil {
		panic("FrontendMock.SetSidebarContentFunc: method is nil but Frontend.SetSidebarContent was just called")
	}
	callInfo := struct {
		SidebarSection SidebarSection
	}{
		SidebarSection: sidebarSection,
	}
	mock.lockSetSidebarContent.Lock()
	mock.calls.SetSidebarContent = append(mock.calls.SetSidebarContent, callInfo)
	mock.lockSetSidebarContent.Unlock()
	mock.SetSidebarContentFunc(sidebarSection)
}

// SetSidebarContentCalls gets all the calls that were made to SetSidebarContent.
// Check the length with:
//
//	len(mockedFrontend.SetSidebarContentCalls())
func (mock *FrontendMock) SetSidebarContentCalls() []struct {
	SidebarSection SidebarSection
} {
	var calls []struct {
		SidebarSection SidebarSection
	}
	mock.lockSetSidebarContent.RLock()
	calls = mock.calls.SetSidebarContent
	mock.lockSetSidebarContent.RUnlock()
	return calls
}

// SetVerbosity calls SetVerbosityFunc.
func (mock *FrontendMock) SetVerbosity(n int) {
	if mock.SetVerbosityFunc == nil {
		panic("FrontendMock.SetVerbosityFunc: method is nil but Frontend.SetVerbosity was just called")
	}
	callInfo := struct {
		N int
	}{
		N: n,
	}
	mock.lockSetVerbosity.Lock()
	mock.calls.SetVerbosity = append(mock.calls.SetVerbosity, callInfo)
	mock.lockSetVerbosity.Unlock()
	mock.SetVerbosityFunc(n)
}

// SetVerbosityCalls gets all the calls that were made to SetVerbosity.
// Check the length with:
//
//	len(mockedFrontend.SetVerbosityCalls())
func (mock *FrontendMock) SetVerbosityCalls() []struct {
	N int
} {
	var calls []struct {
		N int
	}
	mock.lockSetVerbosity.RLock()
	calls = mock.calls.SetVerbosity
	mock.lockSetVerbosity.RUnlock()
	return calls
}

// Shell calls ShellFunc.
func (mock *FrontendMock) Shell(ctx context.Context, handler ShellHandler) {
	if mock.ShellFunc == nil {
		panic("FrontendMock.ShellFunc: method is nil but Frontend.Shell was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Handler ShellHandler
	}{
		Ctx:     ctx,
		Handler: handler,
	}
	mock.lockShell.Lock()
	mock.calls.Shell = append(mock.calls.Shell, callInfo)
	mock.lockShell.Unlock()
	mock.ShellFunc(ctx, handler)
}

// ShellCalls gets all the calls that were made to Shell.
// Check the length with:
//
//	len(mockedFrontend.ShellCalls())
func (mock *FrontendMock) ShellCalls() []struct {
	Ctx     context.Context
	Handler ShellHandler
} {
	var calls []struct {
		Ctx     context.Context
		Handler ShellHandler
	}
	mock.lockShell.RLock()
	calls = mock.calls.Shell
	mock.lockShell.RUnlock()
	return calls
}

// SpanExporter calls SpanExporterFunc.
func (mock *FrontendMock) SpanExporter() sdktrace.SpanExporter {
	if mock.SpanExporterFunc == nil {
		panic("FrontendMock.SpanExporterFunc: method is nil but Frontend.SpanExporter was just called")
	}
	callInfo := struct {
	}{}
	mock.lockSpanExporter.Lock()
	mock.calls.SpanExporter = append(mock.calls.SpanExporter, callInfo)
	mock.lockSpanExporter.Unlock()
	return mock.SpanExporterFunc()
}

// SpanExporterCalls gets all the calls that were made to SpanExporter.
// Check the length with:
//
//	len(mockedFrontend.SpanExporterCalls())
func (mock *FrontendMock) SpanExporterCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockSpanExporter.RLock()
	calls = mock.calls.SpanExporter
	mock.lockSpanExporter.RUnlock()
	return calls
}
