// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by github.com/bufbuild/protocompile/internal/enum syntax.yaml. DO NOT EDIT.

package syntax

import (
	"fmt"
	"iter"
)

// Syntax is a known syntax pragma.
//
// Not only does this include "proto2" and "proto3", but also all of the
// editions.
//
// The integer values of the constants correspond to their the values of
// google.protobuf.Edition.
type Syntax int32

const (
	Unknown          Syntax = 0
	Proto2           Syntax = 998
	Proto3           Syntax = 999
	Edition2023      Syntax = 1000
	Edition2024      Syntax = 1001
	EditionLegacy    Syntax = 900
	EditionTest1     Syntax = 1
	EditionTest2     Syntax = 2
	EditionTest99997 Syntax = 99997
	EditionTest99998 Syntax = 99998
	EditionTest99999 Syntax = 99999
	EditionMax       Syntax = 0x7fff_ffff
)

// String implements [fmt.Stringer].
func (v Syntax) String() string {
	s, ok := _table_Syntax_String[v]
	if !ok {
		return fmt.Sprintf("Syntax(%v)", int(v))
	}
	return s
}

// GoString implements [fmt.GoStringer].
func (v Syntax) GoString() string {
	s, ok := _table_Syntax_GoString[v]
	if !ok {
		return fmt.Sprintf("syntax.Syntax(%v)", int(v))
	}
	return s
}

// Lookup looks up a syntax pragma by name.
//
// If name does not name a known pragma, returns [Unknown].
func Lookup(s string) Syntax {
	return _table_Syntax_Lookup[s]
}

var _table_Syntax_String = map[Syntax]string{
	Unknown:          "<unknown>",
	Proto2:           "proto2",
	Proto3:           "proto3",
	Edition2023:      "2023",
	Edition2024:      "2024",
	EditionLegacy:    "buf/legacy",
	EditionTest1:     "buf/1",
	EditionTest2:     "buf/2",
	EditionTest99997: "buf/99997",
	EditionTest99998: "buf/99998",
	EditionTest99999: "buf/99999",
	EditionMax:       "buf/max",
}

var _table_Syntax_GoString = map[Syntax]string{
	Unknown:          "Unknown",
	Proto2:           "Proto2",
	Proto3:           "Proto3",
	Edition2023:      "Edition2023",
	Edition2024:      "Edition2024",
	EditionLegacy:    "EditionLegacy",
	EditionTest1:     "EditionTest1",
	EditionTest2:     "EditionTest2",
	EditionTest99997: "EditionTest99997",
	EditionTest99998: "EditionTest99998",
	EditionTest99999: "EditionTest99999",
	EditionMax:       "EditionMax",
}

var _table_Syntax_Lookup = map[string]Syntax{
	"proto2":     Proto2,
	"proto3":     Proto3,
	"2023":       Edition2023,
	"2024":       Edition2024,
	"buf/legacy": EditionLegacy,
	"buf/1":      EditionTest1,
	"buf/2":      EditionTest2,
	"buf/99997":  EditionTest99997,
	"buf/99998":  EditionTest99998,
	"buf/99999":  EditionTest99999,
	"buf/max":    EditionMax,
}
var _ iter.Seq[int] // Mark iter as used.
