/* bookworm.c generated by valac 0.56.18, the Vala compiler
 * generated from bookworm.vala, do not modify */

/* Copyright 2017 Siddhartha Das (bablu.boy@gmail.com)
*
* This file is part of Bookworm and is the main Application class
*
* Bookworm is free software: you can redistribute it
* and/or modify it under the terms of the GNU General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* Bookworm is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with Bookworm. If not, see http://www.gnu.org/licenses/.
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <granite.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <webkit2/webkit2.h>
#include <float.h>
#include <math.h>

#define GETTEXT_PACKAGE "bookworm"
#define BOOKWORM_APP_CONSTANTS_bookworm_id "com.github.babluboy.bookworm"
#define BOOKWORM_APP_CONSTANTS_INSTALL_SCRIPTS_DIR "/usr/share/com.github.babluboy.bookworm/scripts"
#define BOOKWORM_APP_CONSTANTS_INSTALL_PREFIX "/usr/share"
#define BOOKWORM_APP_CONSTANTS_INSTALL_TASKS_DIR "/usr/share/com.github.babluboy.bookworm/scripts/tasks"
#define BOOKWORM_APP_CONSTANTS_INSTALL_MOBILIB_DIR "/usr/share/com.github.babluboy.bookworm/scripts/mobi_lib"
#define BOOKWORM_APP_CONSTANTS_bookworm_version "1.1.2"
#define BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "/com/github/babluboy/bookworm/"
#define BOOKWORM_APP_CONSTANTS_SELECTION_OPTION_IMAGE_SMALL_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "16-bookworm-selection-option.svg"
#define BOOKWORM_APP_CONSTANTS_SELECTION_CHECKED_IMAGE_SMALL_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "16-bookworm-selection-checked.svg"
#define BOOKWORM_APP_CONSTANTS_RATING_1_IMAGE_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "16-bookworm_rating_1.png"
#define BOOKWORM_APP_CONSTANTS_RATING_2_IMAGE_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "16-bookworm_rating_2.png"
#define BOOKWORM_APP_CONSTANTS_RATING_3_IMAGE_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "16-bookworm_rating_3.png"
#define BOOKWORM_APP_CONSTANTS_RATING_4_IMAGE_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "16-bookworm_rating_4.png"
#define BOOKWORM_APP_CONSTANTS_RATING_5_IMAGE_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "16-bookworm_rating_5.png"
#define BOOKWORM_APP_CONSTANTS_SELECT_BOOK_ICON_IMAGE_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "16-bookworm-object-select-symbolic.svg"
#define BOOKWORM_APP_CONSTANTS_ADD_BOOK_ICON_IMAGE_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "/16-bookworm-list-add.svg"
#define BOOKWORM_APP_CONSTANTS_REMOVE_BOOK_ICON_IMAGE_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "16-bookworm-list-remove.svg"
#define BOOKWORM_APP_CONSTANTS_LIBRARY_VIEW_LIST_IMAGE_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "16-bookworm-view-list-symbolic.svg"
#define BOOKWORM_APP_CONSTANTS_LIBRARY_VIEW_GRID_IMAGE_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "16-bookworm-view-grid-symbolic.svg"
#define BOOKWORM_APP_CONSTANTS_TEXT_ALIGN_LEFT_ICON_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "16-bookworm-format-justify-left.svg"
#define BOOKWORM_APP_CONSTANTS_TEXT_ALIGN_RIGHT_ICON_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "16-bookworm-format-justify-right.svg"
#define BOOKWORM_APP_CONSTANTS_BOOK_INFO_IMAGE_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "16-bookworm-help-info-symbolic.svg"
#define BOOKWORM_APP_CONSTANTS_TEXT_LARGER_IMAGE_ICON_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "16-bookworm-format-text-larger-symbolic.svg"
#define BOOKWORM_APP_CONSTANTS_HEADERBAR_PROPERTIES_IMAGE_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "24-bookworm-open-menu.svg"
#define BOOKWORM_APP_CONSTANTS_TEXT_SMALLER_IMAGE_ICON_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "16-bookworm-format-text-smaller-symbolic.svg"
#define BOOKWORM_APP_CONSTANTS_PREV_PAGE_ICON_IMAGE_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "16-bookworm-go-previous.svg"
#define BOOKWORM_APP_CONSTANTS_NEXT_PAGE_ICON_IMAGE_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "16-bookworm-go-next.svg"
#define BOOKWORM_APP_CONSTANTS_DYNAMIC_CSS_CONTENT " button.PROFILE_BUTTON_1 { color: <profile_1_color>; background-color:" \
" <profile_1_bgcolor>; border-color: #B0C4DE; } button.PROFILE_BUTTON_2" \
" { color: <profile_2_color>; background-color: <profile_2_bgcolor>; bo" \
"rder-color: #B0C4DE; } button.PROFILE_BUTTON_3 { color: <profile_3_col" \
"or>; background-color: <profile_3_bgcolor>; border-color: #B0C4DE; }  " \
"GtkButton.PROFILE_BUTTON_1 { color: <profile_1_color>; background-colo" \
"r:  <profile_1_bgcolor>; border-color: #B0C4DE; } GtkButton.PROFILE_BU" \
"TTON_2 { color: <profile_2_color>; background-color: <profile_2_bgcolo" \
"r>; border-color: #B0C4DE; } GtkButton.PROFILE_BUTTON_3 { color: <prof" \
"ile_3_color>; background-color: <profile_3_bgcolor>; border-color: #15" \
"1B1C; }"
#define BOOKWORM_APP_CONSTANTS_EBOOK_EXTRACTION_LOCATION "/tmp/" BOOKWORM_APP_CONSTANTS_bookworm_id "/"
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_HEADERBAR_LIBRARY_SEARCH _ ("Search by Title, Author and Tags")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_HEADERBAR_BOOK_SEARCH _ ("Search this book…")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_LIBRARY_BUTTON _ ("Library")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_RESUME_BUTTON _ ("Resume")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_UNKNOWN_TITLE _ ("Unknown Book")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_EXTRACTION_ISSUE _ ("Problem in extracting contents of book. Ensure there is a valid eBook " \
"file here: ")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_FORMAT_NOT_SUPPORTED _ ("Bookworm does not support the format of the file found here: ")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_PARSING_ISSUE _ ("eBook could not be parsed. Ensure there is a valid eBook file here: ")
#define BOOKWORM_APP_CONSTANTS_program_name "Bookworm"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOOKWORM_APP_TYPE_BOOKWORM (bookworm_app_bookworm_get_type ())
#define BOOKWORM_APP_BOOKWORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_BOOKWORM, BookwormAppBookworm))
#define BOOKWORM_APP_BOOKWORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_BOOKWORM, BookwormAppBookwormClass))
#define BOOKWORM_APP_IS_BOOKWORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_BOOKWORM))
#define BOOKWORM_APP_IS_BOOKWORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_BOOKWORM))
#define BOOKWORM_APP_BOOKWORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_BOOKWORM, BookwormAppBookwormClass))

typedef struct _BookwormAppBookworm BookwormAppBookworm;
typedef struct _BookwormAppBookwormClass BookwormAppBookwormClass;
typedef struct _BookwormAppBookwormPrivate BookwormAppBookwormPrivate;
enum  {
	BOOKWORM_APP_BOOKWORM_0_PROPERTY,
	BOOKWORM_APP_BOOKWORM_NUM_PROPERTIES
};
static GParamSpec* bookworm_app_bookworm_properties[BOOKWORM_APP_BOOKWORM_NUM_PROPERTIES];
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define BOOKWORM_APP_TYPE_SETTINGS (bookworm_app_settings_get_type ())
#define BOOKWORM_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettings))
#define BOOKWORM_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))
#define BOOKWORM_APP_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))

typedef struct _BookwormAppSettings BookwormAppSettings;
typedef struct _BookwormAppSettingsClass BookwormAppSettingsClass;

#define BOOKWORM_APP_TYPE_BOOK (bookworm_app_book_get_type ())
#define BOOKWORM_APP_BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBook))
#define BOOKWORM_APP_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))
#define BOOKWORM_APP_IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))

typedef struct _BookwormAppBook BookwormAppBook;
typedef struct _BookwormAppBookClass BookwormAppBookClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _bookworm_app_book_unref0(var) ((var == NULL) ? NULL : (var = (bookworm_app_book_unref (var), NULL)))
typedef struct _bookworm_app_bookworm_closeBookWormData bookworm_app_bookworm_closeBookWormData;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _BookwormAppBookworm {
	GraniteApplication parent_instance;
	BookwormAppBookwormPrivate * priv;
	gint exitCodeForCommand;
	GString* spawn_async_with_pipes_output;
};

struct _BookwormAppBookwormClass {
	GraniteApplicationClass parent_class;
};

struct _bookworm_app_bookworm_closeBookWormData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BookwormAppBookworm* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GeeHashMap* _tmp2_;
	const gchar* _tmp3_;
	gpointer _tmp4_;
	BookwormAppBook* _tmp5_;
	BookwormAppSettings* _tmp6_;
	const gchar* _tmp7_;
	BookwormAppSettings* _tmp8_;
	GeeIterator* _book_it;
	GeeHashMap* _tmp9_;
	GeeCollection* _tmp10_;
	GeeCollection* _tmp11_;
	GeeCollection* _tmp12_;
	GeeIterator* _tmp13_;
	GeeIterator* _tmp14_;
	GeeIterator* _tmp15_;
	BookwormAppBook* book;
	GeeIterator* _tmp16_;
	gpointer _tmp17_;
	BookwormAppBook* _tmp18_;
	BookwormAppBook* _tmp19_;
	gchar* checkBackgroundTask;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar** _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
};

static gpointer bookworm_app_bookworm_parent_class = NULL;
static BookwormAppBookworm* bookworm_app_bookworm_application;
static BookwormAppBookworm* bookworm_app_bookworm_application = NULL;
static gboolean bookworm_app_bookworm_isBookwormRunning;
static gboolean bookworm_app_bookworm_isBookwormRunning = FALSE;
VALA_EXTERN GraniteServicesPaths* bookworm_app_bookworm_app_xdg_path;
GraniteServicesPaths* bookworm_app_bookworm_app_xdg_path = NULL;
VALA_EXTERN gchar* bookworm_app_bookworm_bookworm_config_path;
gchar* bookworm_app_bookworm_bookworm_config_path = NULL;
VALA_EXTERN gchar** bookworm_app_bookworm_commandLineArgs;
VALA_EXTERN gint bookworm_app_bookworm_commandLineArgs_length1;
gchar** bookworm_app_bookworm_commandLineArgs = NULL;
gint bookworm_app_bookworm_commandLineArgs_length1 = 0;
VALA_EXTERN gboolean bookworm_app_bookworm_command_line_option_version;
gboolean bookworm_app_bookworm_command_line_option_version = FALSE;
VALA_EXTERN gboolean bookworm_app_bookworm_command_line_option_debug;
gboolean bookworm_app_bookworm_command_line_option_debug = FALSE;
VALA_EXTERN gboolean bookworm_app_bookworm_command_line_option_info;
gboolean bookworm_app_bookworm_command_line_option_info = FALSE;
VALA_EXTERN gboolean bookworm_app_bookworm_command_line_option_discover;
gboolean bookworm_app_bookworm_command_line_option_discover = FALSE;
static GOptionEntry* bookworm_app_bookworm_options;
static gint bookworm_app_bookworm_options_length1;
static GOptionEntry* bookworm_app_bookworm_options = NULL;
static gint bookworm_app_bookworm_options_length1 = 0;
static gint _bookworm_app_bookworm_options_size_ = 0;
VALA_EXTERN BookwormAppSettings* bookworm_app_bookworm_settings;
BookwormAppSettings* bookworm_app_bookworm_settings = NULL;
VALA_EXTERN GtkApplicationWindow* bookworm_app_bookworm_window;
GtkApplicationWindow* bookworm_app_bookworm_window = NULL;
VALA_EXTERN GtkIconTheme* bookworm_app_bookworm_default_theme;
GtkIconTheme* bookworm_app_bookworm_default_theme = NULL;
VALA_EXTERN GtkCssProvider* bookworm_app_bookworm_cssProvider;
GtkCssProvider* bookworm_app_bookworm_cssProvider = NULL;
VALA_EXTERN GtkBox* bookworm_app_bookworm_bookWormUIBox;
GtkBox* bookworm_app_bookworm_bookWormUIBox = NULL;
VALA_EXTERN GraniteWidgetsWelcome* bookworm_app_bookworm_welcomeWidget;
GraniteWidgetsWelcome* bookworm_app_bookworm_welcomeWidget = NULL;
VALA_EXTERN GraniteWidgetsModeButton* bookworm_app_bookworm_library_mode_button;
GraniteWidgetsModeButton* bookworm_app_bookworm_library_mode_button = NULL;
VALA_EXTERN GtkTreeModelFilter* bookworm_app_bookworm_libraryTreeModelFilter;
GtkTreeModelFilter* bookworm_app_bookworm_libraryTreeModelFilter = NULL;
VALA_EXTERN GtkButton* bookworm_app_bookworm_library_view_button;
GtkButton* bookworm_app_bookworm_library_view_button = NULL;
VALA_EXTERN GtkButton* bookworm_app_bookworm_content_list_button;
GtkButton* bookworm_app_bookworm_content_list_button = NULL;
VALA_EXTERN GtkButton* bookworm_app_bookworm_prefButton;
GtkButton* bookworm_app_bookworm_prefButton = NULL;
VALA_EXTERN GdkPixbuf* bookworm_app_bookworm_bookSelectionPix;
GdkPixbuf* bookworm_app_bookworm_bookSelectionPix = NULL;
VALA_EXTERN GdkPixbuf* bookworm_app_bookworm_bookSelectedPix;
GdkPixbuf* bookworm_app_bookworm_bookSelectedPix = NULL;
VALA_EXTERN GdkPixbuf* bookworm_app_bookworm_image_selection_option_small;
GdkPixbuf* bookworm_app_bookworm_image_selection_option_small = NULL;
VALA_EXTERN GdkPixbuf* bookworm_app_bookworm_image_selection_checked_small;
GdkPixbuf* bookworm_app_bookworm_image_selection_checked_small = NULL;
VALA_EXTERN GdkPixbuf* bookworm_app_bookworm_image_selection_transparent_small;
GdkPixbuf* bookworm_app_bookworm_image_selection_transparent_small = NULL;
VALA_EXTERN GdkPixbuf* bookworm_app_bookworm_image_selection_scaled;
GdkPixbuf* bookworm_app_bookworm_image_selection_scaled = NULL;
VALA_EXTERN GdkPixbuf* bookworm_app_bookworm_image_rating_1;
GdkPixbuf* bookworm_app_bookworm_image_rating_1 = NULL;
VALA_EXTERN GdkPixbuf* bookworm_app_bookworm_image_rating_2;
GdkPixbuf* bookworm_app_bookworm_image_rating_2 = NULL;
VALA_EXTERN GdkPixbuf* bookworm_app_bookworm_image_rating_3;
GdkPixbuf* bookworm_app_bookworm_image_rating_3 = NULL;
VALA_EXTERN GdkPixbuf* bookworm_app_bookworm_image_rating_4;
GdkPixbuf* bookworm_app_bookworm_image_rating_4 = NULL;
VALA_EXTERN GdkPixbuf* bookworm_app_bookworm_image_rating_5;
GdkPixbuf* bookworm_app_bookworm_image_rating_5 = NULL;
VALA_EXTERN GtkImage* bookworm_app_bookworm_select_book_image;
GtkImage* bookworm_app_bookworm_select_book_image = NULL;
VALA_EXTERN GtkImage* bookworm_app_bookworm_add_book_image;
GtkImage* bookworm_app_bookworm_add_book_image = NULL;
VALA_EXTERN GtkImage* bookworm_app_bookworm_remove_book_image;
GtkImage* bookworm_app_bookworm_remove_book_image = NULL;
VALA_EXTERN GtkImage* bookworm_app_bookworm_updateImageIcon;
GtkImage* bookworm_app_bookworm_updateImageIcon = NULL;
VALA_EXTERN GtkImage* bookworm_app_bookworm_add_scan_directory_image;
GtkImage* bookworm_app_bookworm_add_scan_directory_image = NULL;
VALA_EXTERN GtkImage* bookworm_app_bookworm_remove_scan_directory_image;
GtkImage* bookworm_app_bookworm_remove_scan_directory_image = NULL;
VALA_EXTERN GtkImage* bookworm_app_bookworm_library_list_button_image;
GtkImage* bookworm_app_bookworm_library_list_button_image = NULL;
VALA_EXTERN GtkImage* bookworm_app_bookworm_library_grid_button_image;
GtkImage* bookworm_app_bookworm_library_grid_button_image = NULL;
VALA_EXTERN GtkImage* bookworm_app_bookworm_content_list_button_image;
GtkImage* bookworm_app_bookworm_content_list_button_image = NULL;
VALA_EXTERN GtkImage* bookworm_app_bookworm_menu_icon_text_large;
GtkImage* bookworm_app_bookworm_menu_icon_text_large = NULL;
VALA_EXTERN GtkImage* bookworm_app_bookworm_menu_icon;
GtkImage* bookworm_app_bookworm_menu_icon = NULL;
VALA_EXTERN GtkImage* bookworm_app_bookworm_pref_menu_icon_text_large;
GtkImage* bookworm_app_bookworm_pref_menu_icon_text_large = NULL;
VALA_EXTERN GtkImage* bookworm_app_bookworm_pref_menu_icon_text_small;
GtkImage* bookworm_app_bookworm_pref_menu_icon_text_small = NULL;
VALA_EXTERN GtkImage* bookworm_app_bookworm_pref_menu_icon_align_left;
GtkImage* bookworm_app_bookworm_pref_menu_icon_align_left = NULL;
VALA_EXTERN GtkImage* bookworm_app_bookworm_pref_menu_icon_align_right;
GtkImage* bookworm_app_bookworm_pref_menu_icon_align_right = NULL;
VALA_EXTERN GtkImage* bookworm_app_bookworm_back_button_image;
GtkImage* bookworm_app_bookworm_back_button_image = NULL;
VALA_EXTERN GtkImage* bookworm_app_bookworm_forward_button_image;
GtkImage* bookworm_app_bookworm_forward_button_image = NULL;
VALA_EXTERN GtkImage* bookworm_app_bookworm_back_page_image;
GtkImage* bookworm_app_bookworm_back_page_image = NULL;
VALA_EXTERN GtkImage* bookworm_app_bookworm_forward_page_image;
GtkImage* bookworm_app_bookworm_forward_page_image = NULL;
VALA_EXTERN gchar* bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
gchar* bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = NULL;
VALA_EXTERN GeeHashMap* bookworm_app_bookworm_libraryViewMap;
GeeHashMap* bookworm_app_bookworm_libraryViewMap = NULL;
VALA_EXTERN gchar* bookworm_app_bookworm_locationOfEBookCurrentlyRead;
gchar* bookworm_app_bookworm_locationOfEBookCurrentlyRead = NULL;
VALA_EXTERN gchar** bookworm_app_bookworm_pathsOfBooksToBeAdded;
VALA_EXTERN gint bookworm_app_bookworm_pathsOfBooksToBeAdded_length1;
gchar** bookworm_app_bookworm_pathsOfBooksToBeAdded = NULL;
gint bookworm_app_bookworm_pathsOfBooksToBeAdded_length1 = 0;
VALA_EXTERN gint bookworm_app_bookworm_noOfBooksAddedFromCommand;
gint bookworm_app_bookworm_noOfBooksAddedFromCommand = 0;
VALA_EXTERN gboolean bookworm_app_bookworm_isBookBeingAddedToLibrary;
gboolean bookworm_app_bookworm_isBookBeingAddedToLibrary = FALSE;
VALA_EXTERN gboolean bookworm_app_bookworm_isPageScrollRequired;
gboolean bookworm_app_bookworm_isPageScrollRequired = FALSE;
VALA_EXTERN GString* bookworm_app_bookworm_pathsOfBooksInLibraryOnLoadStr;
GString* bookworm_app_bookworm_pathsOfBooksInLibraryOnLoadStr = NULL;
VALA_EXTERN GString* bookworm_app_bookworm_pathsOfBooksNotAddedStr;
GString* bookworm_app_bookworm_pathsOfBooksNotAddedStr = NULL;
VALA_EXTERN GString* bookworm_app_bookworm_onLoadJavaScript;
GString* bookworm_app_bookworm_onLoadJavaScript = NULL;
VALA_EXTERN gchar* bookworm_app_bookworm_bookwormScripts;
gchar* bookworm_app_bookworm_bookwormScripts = NULL;
VALA_EXTERN gchar* bookworm_app_bookworm_bookTextSearchString;
gchar* bookworm_app_bookworm_bookTextSearchString = NULL;
VALA_EXTERN GeeTreeMap* bookworm_app_bookworm_searchResultsMap;
GeeTreeMap* bookworm_app_bookworm_searchResultsMap = NULL;
VALA_EXTERN GString* bookworm_app_bookworm_aContentFileToBeSearched;
GString* bookworm_app_bookworm_aContentFileToBeSearched = NULL;
VALA_EXTERN gchar** bookworm_app_bookworm_profileColorList;
VALA_EXTERN gint bookworm_app_bookworm_profileColorList_length1;
gchar** bookworm_app_bookworm_profileColorList = NULL;
gint bookworm_app_bookworm_profileColorList_length1 = 0;
VALA_EXTERN gchar* bookworm_app_bookworm_no_of_books_per_page;
gchar* bookworm_app_bookworm_no_of_books_per_page = NULL;
VALA_EXTERN GeeArrayList* bookworm_app_bookworm_paginationlist;
GeeArrayList* bookworm_app_bookworm_paginationlist = NULL;
VALA_EXTERN gint bookworm_app_bookworm_current_page_counter;
gint bookworm_app_bookworm_current_page_counter = 0;
VALA_EXTERN GtkProgressBar* bookworm_app_app_window_bookAdditionBar;
VALA_EXTERN WebKitWebView* bookworm_app_app_window_aWebView;
VALA_EXTERN GtkScrolledWindow* bookworm_app_info_searchresults_scroll;
VALA_EXTERN GtkAdjustment* bookworm_app_app_window_pageAdjustment;
VALA_EXTERN GtkLabel* bookworm_app_app_window_infobarLabel;
VALA_EXTERN GtkInfoBar* bookworm_app_app_window_infobar;
VALA_EXTERN GtkScrolledWindow* bookworm_app_app_window_library_list_scroll;
VALA_EXTERN GtkScrolledWindow* bookworm_app_app_window_library_grid_scroll;
VALA_EXTERN GtkFlowBox* bookworm_app_app_window_library_grid;
VALA_EXTERN GtkBox* bookworm_app_app_window_bookLibrary_ui_box;
VALA_EXTERN GtkTreeView* bookworm_app_app_window_library_table_treeview;
VALA_EXTERN GtkSearchEntry* bookworm_app_app_header_bar_headerSearchBar;
VALA_EXTERN GtkBox* bookworm_app_app_window_bookReading_ui_box;
VALA_EXTERN GtkBox* bookworm_app_info_info_box;
VALA_EXTERN GtkButton* bookworm_app_app_header_bar_bookmark_active_button;
VALA_EXTERN GtkButton* bookworm_app_app_header_bar_bookmark_inactive_button;
VALA_EXTERN GtkStack* bookworm_app_info_stack;

VALA_EXTERN GType bookworm_app_bookworm_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppBookworm, g_object_unref)
VALA_EXTERN GType bookworm_app_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppSettings, g_object_unref)
VALA_EXTERN gpointer bookworm_app_book_ref (gpointer instance);
VALA_EXTERN void bookworm_app_book_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_book (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_book (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_book (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_book (const GValue* value);
VALA_EXTERN GType bookworm_app_book_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppBook, bookworm_app_book_unref)
static BookwormAppBookworm* bookworm_app_bookworm_new (void);
static BookwormAppBookworm* bookworm_app_bookworm_construct (GType object_type);
VALA_EXTERN BookwormAppBookworm* bookworm_app_bookworm_getAppInstance (void);
static gint bookworm_app_bookworm_real_command_line (GApplication* base,
                                              GApplicationCommandLine* command_line);
VALA_EXTERN gint bookworm_app_bookworm_processCommandLine (BookwormAppBookworm* self,
                                               gchar** args,
                                               gint args_length1);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
VALA_EXTERN void bookworm_app_background_tasks_performTasks (void);
static void bookworm_app_bookworm_real_activate (GApplication* base);
VALA_EXTERN BookwormAppSettings* bookworm_app_settings_get_instance (void);
VALA_EXTERN void bookworm_app_bookworm_loadCSSProvider (GtkCssProvider* cssProvider);
VALA_EXTERN void bookworm_app_bookworm_loadImages (BookwormAppBookworm* self);
VALA_EXTERN GtkHeaderBar* bookworm_app_app_header_bar_create_headerbar (void);
VALA_EXTERN GraniteWidgetsWelcome* bookworm_app_app_window_createWelcomeScreen (void);
VALA_EXTERN GtkBox* bookworm_app_app_window_createBoookwormUI (void);
VALA_EXTERN void bookworm_app_bookworm_loadBookwormState (BookwormAppBookworm* self);
VALA_EXTERN void bookworm_app_bookworm_toggleUIState (void);
static void ___lambda85_ (BookwormAppBookworm* self);
VALA_EXTERN void bookworm_app_bookworm_saveWindowState (BookwormAppBookworm* self);
static void ____lambda85__gtk_widget_size_allocate (GtkWidget* _sender,
                                             GtkAllocation* allocation,
                                             gpointer self);
static void ___lambda86_ (BookwormAppBookworm* self);
VALA_EXTERN void bookworm_app_bookworm_closeBookWorm (BookwormAppBookworm* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN void bookworm_app_bookworm_closeBookWorm_finish (BookwormAppBookworm* self,
                                                 GAsyncResult* _res_);
static void ____lambda86__gtk_widget_destroy (GtkWidget* _sender,
                                       gpointer self);
VALA_EXTERN gboolean bookworm_app_shortcuts_handleKeyPress (GdkEventKey* ev);
static gboolean _bookworm_app_shortcuts_handleKeyPress_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                            GdkEventKey* event,
                                                                            gpointer self);
VALA_EXTERN gboolean bookworm_app_shortcuts_handleKeyRelease (GdkEventKey* ev);
static gboolean _bookworm_app_shortcuts_handleKeyRelease_gtk_widget_key_release_event (GtkWidget* _sender,
                                                                                GdkEventKey* event,
                                                                                gpointer self);
VALA_EXTERN gboolean bookworm_app_app_window_handleWindowStateEvents (GdkEventWindowState* ev);
static gboolean _bookworm_app_app_window_handleWindowStateEvents_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                                         GdkEventWindowState* event,
                                                                                         gpointer self);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
VALA_EXTERN void bookworm_app_library_addBooksToLibrary (GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN void bookworm_app_library_addBooksToLibrary_finish (GAsyncResult* _res_);
VALA_EXTERN void bookworm_app_content_handler_performStartUpActions (void);
static void bookworm_app_bookworm_real_open (GApplication* base,
                                      GFile** files,
                                      gint files_length1,
                                      const gchar* hint);
VALA_EXTERN const gchar* bookworm_app_settings_get_list_of_profile_colors (BookwormAppSettings* self);
VALA_EXTERN gchar* bookworm_app_utils_fileOperations (const gchar* operation,
                                          const gchar* path,
                                          const gchar* filename,
                                          const gchar* contents);
VALA_EXTERN gint bookworm_app_settings_get_pos_x (BookwormAppSettings* self);
VALA_EXTERN gint bookworm_app_settings_get_pos_y (BookwormAppSettings* self);
VALA_EXTERN gboolean bookworm_app_settings_get_window_is_maximized (BookwormAppSettings* self);
VALA_EXTERN gint bookworm_app_settings_get_window_width (BookwormAppSettings* self);
VALA_EXTERN gint bookworm_app_settings_get_window_height (BookwormAppSettings* self);
VALA_EXTERN gboolean bookworm_app_settings_get_is_dark_theme_enabled (BookwormAppSettings* self);
VALA_EXTERN gint bookworm_app_settings_get_library_page_items (BookwormAppSettings* self);
VALA_EXTERN gboolean bookworm_app_db_initializeBookWormDB (const gchar* bookworm_config_path);
VALA_EXTERN const gchar* bookworm_app_settings_get_library_view_mode (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_library_paginateLibrary (const gchar* library_search_data,
                                           const gchar* mode);
VALA_EXTERN void bookworm_app_app_window_handleLibraryPageButtons (const gchar* mode,
                                                       gboolean isPaginateRequired);
static void bookworm_app_bookworm_closeBookWorm_data_free (gpointer _data);
static gboolean bookworm_app_bookworm_closeBookWorm_co (bookworm_app_bookworm_closeBookWormData* _data_);
VALA_EXTERN void bookworm_app_book_setBookScrollPos (BookwormAppBook* self,
                                         gint aBookScrollPos);
VALA_EXTERN gint bookworm_app_content_handler_getScrollPos (void);
VALA_EXTERN void bookworm_app_settings_set_book_being_read (BookwormAppSettings* self,
                                                const gchar* value);
static gboolean _bookworm_app_bookworm_closeBookWorm_co_gsource_func (gpointer self);
VALA_EXTERN gboolean bookworm_app_book_getWasBookOpened (BookwormAppBook* self);
VALA_EXTERN gboolean bookworm_app_db_updateBookToDataBase (BookwormAppBook* aBook);
VALA_EXTERN gchar* bookworm_app_utils_execute_sync_command (const gchar* cmd);
VALA_EXTERN gint bookworm_app_utils_execute_async_multiarg_command_pipes (gchar** spawn_args,
                                                              gint spawn_args_length1);
VALA_EXTERN void bookworm_app_settings_set_pos_x (BookwormAppSettings* self,
                                      gint value);
VALA_EXTERN void bookworm_app_settings_set_pos_y (BookwormAppSettings* self,
                                      gint value);
VALA_EXTERN void bookworm_app_settings_set_window_width (BookwormAppSettings* self,
                                             gint value);
VALA_EXTERN void bookworm_app_settings_set_window_height (BookwormAppSettings* self,
                                              gint value);
VALA_EXTERN void bookworm_app_settings_set_window_is_maximized (BookwormAppSettings* self,
                                                    gboolean value);
VALA_EXTERN void bookworm_app_settings_set_zoom_level (BookwormAppSettings* self,
                                           gdouble value);
VALA_EXTERN void bookworm_app_bookworm_readSelectedBook (BookwormAppBook* aBook);
VALA_EXTERN gchar* bookworm_app_book_getBookLocation (BookwormAppBook* self);
VALA_EXTERN GeeArrayList* bookworm_app_book_getBookContentList (BookwormAppBook* self);
VALA_EXTERN BookwormAppBook* bookworm_app_db_getBookMetaDataFromDB (BookwormAppBook* aBook);
VALA_EXTERN gchar* bookworm_app_book_to_string (BookwormAppBook* self);
VALA_EXTERN gint bookworm_app_book_getBookPageNumber (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookPageNumber (BookwormAppBook* self,
                                          gint aBookPageNumber);
VALA_EXTERN gboolean bookworm_app_settings_get_is_local_storage_enabled (BookwormAppSettings* self);
VALA_EXTERN gchar* bookworm_app_book_getBookExtractionLocation (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_utils_decodeHTMLChars (const gchar* inputString);
VALA_EXTERN void bookworm_app_book_setIsBookParsed (BookwormAppBook* self,
                                        gboolean isParsed);
VALA_EXTERN BookwormAppBook* bookworm_app_bookworm_genericParser (BookwormAppBook* aBook);
VALA_EXTERN gboolean bookworm_app_book_getIsBookParsed (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_app_window_showInfoBar (BookwormAppBook* aBook,
                                          GtkMessageType aMessageType);
VALA_EXTERN void bookworm_app_book_setBookTotalPages (BookwormAppBook* self,
                                          gint aBookTotalPages);
VALA_EXTERN void bookworm_app_book_setBookLastModificationDate (BookwormAppBook* self,
                                                    const gchar* aBookLastModificationDate);
VALA_EXTERN void bookworm_app_book_setWasBookOpened (BookwormAppBook* self,
                                         gboolean aWasBookOpened);
VALA_EXTERN GtkHeaderBar* bookworm_app_app_header_bar_get_headerbar (void);
VALA_EXTERN gchar* bookworm_app_utils_parseMarkUp (const gchar* inputString);
VALA_EXTERN gchar* bookworm_app_book_getBookTitle (BookwormAppBook* self);
VALA_EXTERN BookwormAppBook* bookworm_app_content_handler_renderPage (BookwormAppBook* aBook,
                                                          gchar* direction);
VALA_EXTERN void bookworm_app_content_handler_handleBookMark (const gchar* action);
VALA_EXTERN const gchar* bookworm_app_settings_get_current_info_tab (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_book_setBookAuthor (BookwormAppBook* self,
                                      const gchar* aBookAuthor);
VALA_EXTERN void bookworm_app_book_setBookTitle (BookwormAppBook* self,
                                     const gchar* aBookTitle);
VALA_EXTERN void bookworm_app_book_setParsingIssue (BookwormAppBook* self,
                                        const gchar* aParsingIssue);
VALA_EXTERN BookwormAppBook* bookworm_app_epub_reader_parseEPubBook (BookwormAppBook* aBook);
VALA_EXTERN BookwormAppBook* bookworm_app_pdf_reader_parsePDFBook (BookwormAppBook* aBook,
                                                       GError** error);
VALA_EXTERN BookwormAppBook* bookworm_app_comics_reader_parseComicsBook (BookwormAppBook* aBook,
                                                             const gchar* comicsFileType);
VALA_EXTERN BookwormAppBook* bookworm_app_mobi_reader_parseMobiBook (BookwormAppBook* aBook);
VALA_EXTERN BookwormAppBook* bookworm_app_fb2_reader_parseFictionBook (BookwormAppBook* aBook);
static GObject * bookworm_app_bookworm_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void bookworm_app_bookworm_finalize (GObject * obj);
static GType bookworm_app_bookworm_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

VALA_EXTERN const gchar* BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[8];

static BookwormAppBookworm*
bookworm_app_bookworm_construct (GType object_type)
{
	BookwormAppBookworm * self = NULL;
	GraniteServicesPaths* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
#line 118 "../src/bookworm.vala"
	self = (BookwormAppBookworm*) g_object_new (object_type, "application-id", BOOKWORM_APP_CONSTANTS_bookworm_id, "flags", G_APPLICATION_HANDLES_COMMAND_LINE, NULL);
#line 121 "../src/bookworm.vala"
	setlocale (LC_MESSAGES, "");
#line 122 "../src/bookworm.vala"
	textdomain (GETTEXT_PACKAGE);
#line 123 "../src/bookworm.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "utf-8");
#line 125 "../src/bookworm.vala"
	_tmp0_ = granite_services_paths_new ();
#line 125 "../src/bookworm.vala"
	_g_object_unref0 (bookworm_app_bookworm_app_xdg_path);
#line 125 "../src/bookworm.vala"
	bookworm_app_bookworm_app_xdg_path = _tmp0_;
#line 126 "../src/bookworm.vala"
	granite_services_paths_initialize (BOOKWORM_APP_CONSTANTS_bookworm_id, BOOKWORM_APP_CONSTANTS_INSTALL_SCRIPTS_DIR);
#line 127 "../src/bookworm.vala"
	_tmp1_ = granite_services_paths_get_user_data_folder ();
#line 127 "../src/bookworm.vala"
	_tmp2_ = _tmp1_;
#line 127 "../src/bookworm.vala"
	_tmp3_ = g_file_get_path (_tmp2_);
#line 127 "../src/bookworm.vala"
	_g_free0 (bookworm_app_bookworm_bookworm_config_path);
#line 127 "../src/bookworm.vala"
	bookworm_app_bookworm_bookworm_config_path = _tmp3_;
#line 128 "../src/bookworm.vala"
	g_debug ("bookworm.vala:128: %s", "Bookworm Install Directory: " BOOKWORM_APP_CONSTANTS_INSTALL_PREFIX);
#line 129 "../src/bookworm.vala"
	g_debug ("bookworm.vala:129: %s", "Bookworm Install Tasks Scripts Directory: " BOOKWORM_APP_CONSTANTS_INSTALL_TASKS_DIR);
#line 130 "../src/bookworm.vala"
	g_debug ("bookworm.vala:130: %s", "Bookworm Install Mobi Scripts Directory: " BOOKWORM_APP_CONSTANTS_INSTALL_MOBILIB_DIR);
#line 131 "../src/bookworm.vala"
	_tmp4_ = bookworm_app_bookworm_bookworm_config_path;
#line 131 "../src/bookworm.vala"
	_tmp5_ = g_strconcat ("Bookworm User Data Directory: ", _tmp4_, NULL);
#line 131 "../src/bookworm.vala"
	_tmp6_ = _tmp5_;
#line 131 "../src/bookworm.vala"
	g_debug ("bookworm.vala:131: %s", _tmp6_);
#line 131 "../src/bookworm.vala"
	_g_free0 (_tmp6_);
#line 117 "../src/bookworm.vala"
	return self;
#line 587 "bookworm.c"
}

static BookwormAppBookworm*
bookworm_app_bookworm_new (void)
{
#line 117 "../src/bookworm.vala"
	return bookworm_app_bookworm_construct (BOOKWORM_APP_TYPE_BOOKWORM);
#line 595 "bookworm.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 140 "../src/bookworm.vala"
	return self ? g_object_ref (self) : NULL;
#line 603 "bookworm.c"
}

BookwormAppBookworm*
bookworm_app_bookworm_getAppInstance (void)
{
	BookwormAppBookworm* _tmp0_;
	BookwormAppBookworm* _tmp2_;
	BookwormAppBookworm* _tmp3_;
	BookwormAppBookworm* result;
#line 135 "../src/bookworm.vala"
	_tmp0_ = bookworm_app_bookworm_application;
#line 135 "../src/bookworm.vala"
	if (_tmp0_ == NULL) {
#line 617 "bookworm.c"
		BookwormAppBookworm* _tmp1_;
#line 136 "../src/bookworm.vala"
		_tmp1_ = bookworm_app_bookworm_new ();
#line 136 "../src/bookworm.vala"
		_g_object_unref0 (bookworm_app_bookworm_application);
#line 136 "../src/bookworm.vala"
		bookworm_app_bookworm_application = _tmp1_;
#line 625 "bookworm.c"
	} else {
	}
#line 140 "../src/bookworm.vala"
	_tmp2_ = bookworm_app_bookworm_application;
#line 140 "../src/bookworm.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 140 "../src/bookworm.vala"
	result = _tmp3_;
#line 140 "../src/bookworm.vala"
	return result;
#line 636 "bookworm.c"
}

static gint
bookworm_app_bookworm_real_command_line (GApplication* base,
                                         GApplicationCommandLine* command_line)
{
	BookwormAppBookworm * self;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint result;
#line 143 "../src/bookworm.vala"
	self = (BookwormAppBookworm*) base;
#line 143 "../src/bookworm.vala"
	g_return_val_if_fail (command_line != NULL, 0);
#line 144 "../src/bookworm.vala"
	_tmp1_ = g_application_command_line_get_arguments (command_line, &_tmp0_);
#line 144 "../src/bookworm.vala"
	bookworm_app_bookworm_commandLineArgs = (_vala_array_free (bookworm_app_bookworm_commandLineArgs, bookworm_app_bookworm_commandLineArgs_length1, (GDestroyNotify) g_free), NULL);
#line 144 "../src/bookworm.vala"
	bookworm_app_bookworm_commandLineArgs = _tmp1_;
#line 144 "../src/bookworm.vala"
	bookworm_app_bookworm_commandLineArgs_length1 = _tmp0_;
#line 145 "../src/bookworm.vala"
	g_application_activate ((GApplication*) self);
#line 146 "../src/bookworm.vala"
	result = 0;
#line 146 "../src/bookworm.vala"
	return result;
#line 665 "bookworm.c"
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
#line 156 "../src/bookworm.vala"
	for (i = 0; i < stack_length; i++) {
#line 156 "../src/bookworm.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 156 "../src/bookworm.vala"
			return TRUE;
#line 680 "bookworm.c"
		}
	}
#line 156 "../src/bookworm.vala"
	return FALSE;
#line 685 "bookworm.c"
}

gint
bookworm_app_bookworm_processCommandLine (BookwormAppBookworm* self,
                                          gchar** args,
                                          gint args_length1)
{
	GError* _inner_error0_ = NULL;
	gint result;
#line 149 "../src/bookworm.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 697 "bookworm.c"
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp0_;
		GOptionContext* _tmp1_;
		GOptionContext* _tmp2_;
		GOptionEntry* _tmp3_;
		gint _tmp3__length1;
		gchar** tmpArgs = NULL;
		gint tmpArgs_length1;
		gint _tmpArgs_size_;
		GOptionContext* _tmp4_;
#line 151 "../src/bookworm.vala"
		_tmp0_ = g_option_context_new ("- bookworm");
#line 151 "../src/bookworm.vala"
		opt_context = _tmp0_;
#line 152 "../src/bookworm.vala"
		_tmp1_ = opt_context;
#line 152 "../src/bookworm.vala"
		g_option_context_set_help_enabled (_tmp1_, TRUE);
#line 153 "../src/bookworm.vala"
		_tmp2_ = opt_context;
#line 153 "../src/bookworm.vala"
		_tmp3_ = bookworm_app_bookworm_options;
#line 153 "../src/bookworm.vala"
		_tmp3__length1 = bookworm_app_bookworm_options_length1;
#line 153 "../src/bookworm.vala"
		g_option_context_add_main_entries (_tmp2_, _tmp3_, NULL);
#line 154 "../src/bookworm.vala"
		tmpArgs = args;
#line 154 "../src/bookworm.vala"
		tmpArgs_length1 = args_length1;
#line 154 "../src/bookworm.vala"
		_tmpArgs_size_ = tmpArgs_length1;
#line 155 "../src/bookworm.vala"
		_tmp4_ = opt_context;
#line 155 "../src/bookworm.vala"
		g_option_context_parse (_tmp4_, (gint*) (&tmpArgs_length1), &tmpArgs, &_inner_error0_);
#line 155 "../src/bookworm.vala"
		_tmpArgs_size_ = tmpArgs_length1;
#line 155 "../src/bookworm.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 739 "bookworm.c"
			gint _tmp5_ = -1;
#line 155 "../src/bookworm.vala"
			_g_option_context_free0 (opt_context);
#line 155 "../src/bookworm.vala"
			if (_inner_error0_->domain == G_OPTION_ERROR) {
#line 745 "bookworm.c"
				goto __catch0_g_option_error;
			}
#line 155 "../src/bookworm.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 155 "../src/bookworm.vala"
			g_clear_error (&_inner_error0_);
#line 155 "../src/bookworm.vala"
			return _tmp5_;
#line 754 "bookworm.c"
		}
#line 156 "../src/bookworm.vala"
		if (_vala_string_array_contains (args, args_length1, "--version")) {
#line 157 "../src/bookworm.vala"
			bookworm_app_bookworm_command_line_option_version = TRUE;
#line 760 "bookworm.c"
		}
#line 150 "../src/bookworm.vala"
		_g_option_context_free0 (opt_context);
#line 764 "bookworm.c"
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		const gchar* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 150 "../src/bookworm.vala"
		e = _inner_error0_;
#line 150 "../src/bookworm.vala"
		_inner_error0_ = NULL;
#line 160 "../src/bookworm.vala"
		_tmp6_ = args[0];
#line 160 "../src/bookworm.vala"
		g_info ("bookworm.vala:160: Run '%s --help' to see a full list of available com" \
"mand line options.\n", _tmp6_);
#line 161 "../src/bookworm.vala"
		_tmp7_ = e;
#line 161 "../src/bookworm.vala"
		_tmp8_ = _tmp7_->message;
#line 161 "../src/bookworm.vala"
		g_info ("bookworm.vala:161: error: %s\n", _tmp8_);
#line 162 "../src/bookworm.vala"
		result = 0;
#line 162 "../src/bookworm.vala"
		_g_error_free0 (e);
#line 162 "../src/bookworm.vala"
		return result;
#line 793 "bookworm.c"
	}
	__finally0:
#line 150 "../src/bookworm.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 798 "bookworm.c"
		gint _tmp9_ = -1;
#line 150 "../src/bookworm.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 150 "../src/bookworm.vala"
		g_clear_error (&_inner_error0_);
#line 150 "../src/bookworm.vala"
		return _tmp9_;
#line 806 "bookworm.c"
	}
#line 165 "../src/bookworm.vala"
	if (bookworm_app_bookworm_command_line_option_version) {
#line 166 "../src/bookworm.vala"
		g_print ("%s", "Bookworm Version " BOOKWORM_APP_CONSTANTS_bookworm_version "\n");
#line 812 "bookworm.c"
	}
#line 168 "../src/bookworm.vala"
	if (bookworm_app_bookworm_command_line_option_discover) {
#line 169 "../src/bookworm.vala"
		bookworm_app_background_tasks_performTasks ();
#line 818 "bookworm.c"
	}
#line 171 "../src/bookworm.vala"
	result = 0;
#line 171 "../src/bookworm.vala"
	return result;
#line 824 "bookworm.c"
}

static void
___lambda85_ (BookwormAppBookworm* self)
{
#line 217 "../src/bookworm.vala"
	bookworm_app_bookworm_saveWindowState (self);
#line 832 "bookworm.c"
}

static void
____lambda85__gtk_widget_size_allocate (GtkWidget* _sender,
                                        GtkAllocation* allocation,
                                        gpointer self)
{
#line 216 "../src/bookworm.vala"
	___lambda85_ ((BookwormAppBookworm*) self);
#line 842 "bookworm.c"
}

static void
___lambda86_ (BookwormAppBookworm* self)
{
#line 222 "../src/bookworm.vala"
	bookworm_app_bookworm_closeBookWorm (self, NULL, NULL);
#line 850 "bookworm.c"
}

static void
____lambda86__gtk_widget_destroy (GtkWidget* _sender,
                                  gpointer self)
{
#line 220 "../src/bookworm.vala"
	___lambda86_ ((BookwormAppBookworm*) self);
#line 859 "bookworm.c"
}

static gboolean
_bookworm_app_shortcuts_handleKeyPress_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                   GdkEventKey* event,
                                                                   gpointer self)
{
	gboolean result;
	result = bookworm_app_shortcuts_handleKeyPress (event);
#line 226 "../src/bookworm.vala"
	return result;
#line 871 "bookworm.c"
}

static gboolean
_bookworm_app_shortcuts_handleKeyRelease_gtk_widget_key_release_event (GtkWidget* _sender,
                                                                       GdkEventKey* event,
                                                                       gpointer self)
{
	gboolean result;
	result = bookworm_app_shortcuts_handleKeyRelease (event);
#line 227 "../src/bookworm.vala"
	return result;
#line 883 "bookworm.c"
}

static gboolean
_bookworm_app_app_window_handleWindowStateEvents_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                                GdkEventWindowState* event,
                                                                                gpointer self)
{
	gboolean result;
	result = bookworm_app_app_window_handleWindowStateEvents (event);
#line 229 "../src/bookworm.vala"
	return result;
#line 895 "bookworm.c"
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
#line 243 "../src/bookworm.vala"
	if (length >= 0) {
#line 904 "bookworm.c"
		gchar** result;
		gssize i;
#line 243 "../src/bookworm.vala"
		result = g_new0 (gchar*, length + 1);
#line 243 "../src/bookworm.vala"
		for (i = 0; i < length; i++) {
#line 911 "bookworm.c"
			gchar* _tmp0_;
#line 243 "../src/bookworm.vala"
			_tmp0_ = g_strdup (self[i]);
#line 243 "../src/bookworm.vala"
			result[i] = _tmp0_;
#line 917 "bookworm.c"
		}
#line 243 "../src/bookworm.vala"
		return result;
#line 921 "bookworm.c"
	}
#line 243 "../src/bookworm.vala"
	return NULL;
#line 925 "bookworm.c"
}

static void
bookworm_app_bookworm_real_activate (GApplication* base)
{
	BookwormAppBookworm * self;
	gchar** _tmp32_;
	gint _tmp32__length1;
#line 174 "../src/bookworm.vala"
	self = (BookwormAppBookworm*) base;
#line 175 "../src/bookworm.vala"
	granite_services_logger_initialize ("com.github.babluboy.bookworm");
#line 176 "../src/bookworm.vala"
	if (bookworm_app_bookworm_command_line_option_debug) {
#line 177 "../src/bookworm.vala"
		granite_services_logger_set_DisplayLevel (GRANITE_SERVICES_LOG_LEVEL_DEBUG);
#line 942 "bookworm.c"
	}
#line 179 "../src/bookworm.vala"
	if (bookworm_app_bookworm_command_line_option_info) {
#line 180 "../src/bookworm.vala"
		granite_services_logger_set_DisplayLevel (GRANITE_SERVICES_LOG_LEVEL_INFO);
#line 948 "bookworm.c"
	}
#line 182 "../src/bookworm.vala"
	g_info ("bookworm.vala:182: [START] [FUNCTION:activate]");
#line 184 "../src/bookworm.vala"
	if (!bookworm_app_bookworm_isBookwormRunning) {
#line 954 "bookworm.c"
		GtkApplicationWindow* _tmp0_;
		GtkIconTheme* _tmp1_;
		GtkIconTheme* _tmp2_;
		BookwormAppSettings* _tmp3_;
		GtkApplicationWindow* _tmp4_;
		GtkApplicationWindow* _tmp5_;
		GtkStyleContext* _tmp6_;
		GtkApplicationWindow* _tmp7_;
		GtkCssProvider* _tmp8_;
		GtkCssProvider* _tmp9_;
		GtkApplicationWindow* _tmp10_;
		GtkHeaderBar* _tmp11_;
		GtkHeaderBar* _tmp12_;
		GraniteWidgetsWelcome* _tmp13_;
		GraniteWidgetsWelcome* _tmp14_;
		GtkBox* _tmp15_;
		GeeHashMap* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		GtkApplicationWindow* _tmp23_;
		GtkApplicationWindow* _tmp24_;
		GtkApplicationWindow* _tmp25_;
		GtkApplicationWindow* _tmp26_;
		GtkApplicationWindow* _tmp27_;
		GtkApplicationWindow* _tmp28_;
		GtkApplicationWindow* _tmp29_;
		GtkApplicationWindow* _tmp30_;
#line 185 "../src/bookworm.vala"
		g_debug ("bookworm.vala:185: No instance of Bookworm found");
#line 186 "../src/bookworm.vala"
		_tmp0_ = (GtkApplicationWindow*) gtk_application_window_new ((GtkApplication*) self);
#line 186 "../src/bookworm.vala"
		g_object_ref_sink (_tmp0_);
#line 186 "../src/bookworm.vala"
		_g_object_unref0 (bookworm_app_bookworm_window);
#line 186 "../src/bookworm.vala"
		bookworm_app_bookworm_window = _tmp0_;
#line 187 "../src/bookworm.vala"
		_tmp1_ = gtk_icon_theme_get_default ();
#line 187 "../src/bookworm.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 187 "../src/bookworm.vala"
		_g_object_unref0 (bookworm_app_bookworm_default_theme);
#line 187 "../src/bookworm.vala"
		bookworm_app_bookworm_default_theme = _tmp2_;
#line 189 "../src/bookworm.vala"
		_tmp3_ = bookworm_app_settings_get_instance ();
#line 189 "../src/bookworm.vala"
		_g_object_unref0 (bookworm_app_bookworm_settings);
#line 189 "../src/bookworm.vala"
		bookworm_app_bookworm_settings = _tmp3_;
#line 191 "../src/bookworm.vala"
		_tmp4_ = bookworm_app_bookworm_window;
#line 191 "../src/bookworm.vala"
		gtk_container_set_border_width ((GtkContainer*) _tmp4_, (guint) 0);
#line 192 "../src/bookworm.vala"
		_tmp5_ = bookworm_app_bookworm_window;
#line 192 "../src/bookworm.vala"
		_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
#line 192 "../src/bookworm.vala"
		gtk_style_context_add_class (_tmp6_, "rounded");
#line 194 "../src/bookworm.vala"
		_tmp7_ = bookworm_app_bookworm_window;
#line 194 "../src/bookworm.vala"
		gtk_widget_set_size_request ((GtkWidget*) _tmp7_, 600, 350);
#line 196 "../src/bookworm.vala"
		_tmp8_ = gtk_css_provider_new ();
#line 196 "../src/bookworm.vala"
		_g_object_unref0 (bookworm_app_bookworm_cssProvider);
#line 196 "../src/bookworm.vala"
		bookworm_app_bookworm_cssProvider = _tmp8_;
#line 197 "../src/bookworm.vala"
		_tmp9_ = bookworm_app_bookworm_cssProvider;
#line 197 "../src/bookworm.vala"
		bookworm_app_bookworm_loadCSSProvider (_tmp9_);
#line 199 "../src/bookworm.vala"
		bookworm_app_bookworm_loadImages (self);
#line 201 "../src/bookworm.vala"
		_tmp10_ = bookworm_app_bookworm_window;
#line 201 "../src/bookworm.vala"
		_tmp11_ = bookworm_app_app_header_bar_create_headerbar ();
#line 201 "../src/bookworm.vala"
		_tmp12_ = _tmp11_;
#line 201 "../src/bookworm.vala"
		gtk_window_set_titlebar ((GtkWindow*) _tmp10_, (GtkWidget*) _tmp12_);
#line 201 "../src/bookworm.vala"
		_g_object_unref0 (_tmp12_);
#line 202 "../src/bookworm.vala"
		_tmp13_ = bookworm_app_app_window_createWelcomeScreen ();
#line 202 "../src/bookworm.vala"
		_tmp14_ = _tmp13_;
#line 202 "../src/bookworm.vala"
		_g_object_unref0 (_tmp14_);
#line 203 "../src/bookworm.vala"
		_tmp15_ = bookworm_app_app_window_createBoookwormUI ();
#line 203 "../src/bookworm.vala"
		_g_object_unref0 (bookworm_app_bookworm_bookWormUIBox);
#line 203 "../src/bookworm.vala"
		bookworm_app_bookworm_bookWormUIBox = _tmp15_;
#line 205 "../src/bookworm.vala"
		bookworm_app_bookworm_loadBookwormState (self);
#line 207 "../src/bookworm.vala"
		_tmp16_ = bookworm_app_bookworm_libraryViewMap;
#line 207 "../src/bookworm.vala"
		_tmp17_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp16_);
#line 207 "../src/bookworm.vala"
		_tmp18_ = _tmp17_;
#line 207 "../src/bookworm.vala"
		if (_tmp18_ == 0) {
#line 1064 "bookworm.c"
			GtkApplicationWindow* _tmp19_;
			GraniteWidgetsWelcome* _tmp20_;
#line 208 "../src/bookworm.vala"
			_tmp19_ = bookworm_app_bookworm_window;
#line 208 "../src/bookworm.vala"
			_tmp20_ = bookworm_app_bookworm_welcomeWidget;
#line 208 "../src/bookworm.vala"
			gtk_container_add ((GtkContainer*) _tmp19_, (GtkWidget*) _tmp20_);
#line 1073 "bookworm.c"
		} else {
			GtkApplicationWindow* _tmp21_;
			GtkBox* _tmp22_;
#line 210 "../src/bookworm.vala"
			_tmp21_ = bookworm_app_bookworm_window;
#line 210 "../src/bookworm.vala"
			_tmp22_ = bookworm_app_bookworm_bookWormUIBox;
#line 210 "../src/bookworm.vala"
			gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
#line 1083 "bookworm.c"
		}
#line 212 "../src/bookworm.vala"
		_tmp23_ = bookworm_app_bookworm_window;
#line 212 "../src/bookworm.vala"
		gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp23_);
#line 213 "../src/bookworm.vala"
		_tmp24_ = bookworm_app_bookworm_window;
#line 213 "../src/bookworm.vala"
		gtk_widget_show_all ((GtkWidget*) _tmp24_);
#line 214 "../src/bookworm.vala"
		bookworm_app_bookworm_toggleUIState ();
#line 216 "../src/bookworm.vala"
		_tmp25_ = bookworm_app_bookworm_window;
#line 216 "../src/bookworm.vala"
		g_signal_connect_object ((GtkWidget*) _tmp25_, "size-allocate", (GCallback) ____lambda85__gtk_widget_size_allocate, self, 0);
#line 220 "../src/bookworm.vala"
		_tmp26_ = bookworm_app_bookworm_window;
#line 220 "../src/bookworm.vala"
		g_signal_connect_object ((GtkWidget*) _tmp26_, "destroy", (GCallback) ____lambda86__gtk_widget_destroy, self, 0);
#line 225 "../src/bookworm.vala"
		_tmp27_ = bookworm_app_bookworm_window;
#line 225 "../src/bookworm.vala"
		gtk_widget_add_events ((GtkWidget*) _tmp27_, (gint) GDK_KEY_PRESS_MASK);
#line 226 "../src/bookworm.vala"
		_tmp28_ = bookworm_app_bookworm_window;
#line 226 "../src/bookworm.vala"
		g_signal_connect ((GtkWidget*) _tmp28_, "key-press-event", (GCallback) _bookworm_app_shortcuts_handleKeyPress_gtk_widget_key_press_event, NULL);
#line 227 "../src/bookworm.vala"
		_tmp29_ = bookworm_app_bookworm_window;
#line 227 "../src/bookworm.vala"
		g_signal_connect ((GtkWidget*) _tmp29_, "key-release-event", (GCallback) _bookworm_app_shortcuts_handleKeyRelease_gtk_widget_key_release_event, NULL);
#line 229 "../src/bookworm.vala"
		_tmp30_ = bookworm_app_bookworm_window;
#line 229 "../src/bookworm.vala"
		g_signal_connect ((GtkWidget*) _tmp30_, "window-state-event", (GCallback) _bookworm_app_app_window_handleWindowStateEvents_gtk_widget_window_state_event, NULL);
#line 231 "../src/bookworm.vala"
		bookworm_app_bookworm_isBookwormRunning = TRUE;
#line 232 "../src/bookworm.vala"
		g_debug ("bookworm.vala:232: Completed creating an instance of Bookworm");
#line 1123 "bookworm.c"
	} else {
		GtkApplicationWindow* _tmp31_;
#line 234 "../src/bookworm.vala"
		_tmp31_ = bookworm_app_bookworm_window;
#line 234 "../src/bookworm.vala"
		gtk_window_present ((GtkWindow*) _tmp31_);
#line 235 "../src/bookworm.vala"
		g_debug ("bookworm.vala:235: An instance of Bookworm is already running");
#line 1132 "bookworm.c"
	}
#line 238 "../src/bookworm.vala"
	_tmp32_ = bookworm_app_bookworm_commandLineArgs;
#line 238 "../src/bookworm.vala"
	_tmp32__length1 = bookworm_app_bookworm_commandLineArgs_length1;
#line 238 "../src/bookworm.vala"
	if (_tmp32__length1 > 1) {
#line 1140 "bookworm.c"
		gchar** _tmp33_;
		gint _tmp33__length1;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar** _tmp38_;
		gint _tmp38__length1;
		gchar** _tmp39_;
		gchar** _tmp40_;
		gint _tmp40__length1;
		gchar** _tmp41_;
		gint _tmp41__length1;
		GtkProgressBar* _tmp42_;
		GeeHashMap* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
#line 239 "../src/bookworm.vala"
		_tmp33_ = bookworm_app_bookworm_commandLineArgs;
#line 239 "../src/bookworm.vala"
		_tmp33__length1 = bookworm_app_bookworm_commandLineArgs_length1;
#line 239 "../src/bookworm.vala"
		_tmp34_ = g_strdup_printf ("%i", _tmp33__length1);
#line 239 "../src/bookworm.vala"
		_tmp35_ = _tmp34_;
#line 239 "../src/bookworm.vala"
		_tmp36_ = g_strconcat ("Book(s) to be added/opened based on command line parameters. Size of c" \
"ommand line attributes:", _tmp35_, NULL);
#line 239 "../src/bookworm.vala"
		_tmp37_ = _tmp36_;
#line 239 "../src/bookworm.vala"
		g_info ("bookworm.vala:239: %s", _tmp37_);
#line 239 "../src/bookworm.vala"
		_g_free0 (_tmp37_);
#line 239 "../src/bookworm.vala"
		_g_free0 (_tmp35_);
#line 242 "../src/bookworm.vala"
		_tmp38_ = bookworm_app_bookworm_commandLineArgs;
#line 242 "../src/bookworm.vala"
		_tmp38__length1 = bookworm_app_bookworm_commandLineArgs_length1;
#line 242 "../src/bookworm.vala"
		_tmp39_ = g_new0 (gchar*, _tmp38__length1 + 1);
#line 242 "../src/bookworm.vala"
		bookworm_app_bookworm_pathsOfBooksToBeAdded = (_vala_array_free (bookworm_app_bookworm_pathsOfBooksToBeAdded, bookworm_app_bookworm_pathsOfBooksToBeAdded_length1, (GDestroyNotify) g_free), NULL);
#line 242 "../src/bookworm.vala"
		bookworm_app_bookworm_pathsOfBooksToBeAdded = _tmp39_;
#line 242 "../src/bookworm.vala"
		bookworm_app_bookworm_pathsOfBooksToBeAdded_length1 = _tmp38__length1;
#line 243 "../src/bookworm.vala"
		_tmp40_ = bookworm_app_bookworm_commandLineArgs;
#line 243 "../src/bookworm.vala"
		_tmp40__length1 = bookworm_app_bookworm_commandLineArgs_length1;
#line 243 "../src/bookworm.vala"
		_tmp41_ = (_tmp40_ != NULL) ? _vala_array_dup1 (_tmp40_, _tmp40__length1) : _tmp40_;
#line 243 "../src/bookworm.vala"
		_tmp41__length1 = _tmp40__length1;
#line 243 "../src/bookworm.vala"
		bookworm_app_bookworm_pathsOfBooksToBeAdded = (_vala_array_free (bookworm_app_bookworm_pathsOfBooksToBeAdded, bookworm_app_bookworm_pathsOfBooksToBeAdded_length1, (GDestroyNotify) g_free), NULL);
#line 243 "../src/bookworm.vala"
		bookworm_app_bookworm_pathsOfBooksToBeAdded = _tmp41_;
#line 243 "../src/bookworm.vala"
		bookworm_app_bookworm_pathsOfBooksToBeAdded_length1 = _tmp41__length1;
#line 245 "../src/bookworm.vala"
		_tmp42_ = bookworm_app_app_window_bookAdditionBar;
#line 245 "../src/bookworm.vala"
		gtk_widget_show ((GtkWidget*) _tmp42_);
#line 246 "../src/bookworm.vala"
		bookworm_app_bookworm_isBookBeingAddedToLibrary = TRUE;
#line 248 "../src/bookworm.vala"
		_tmp43_ = bookworm_app_bookworm_libraryViewMap;
#line 248 "../src/bookworm.vala"
		_tmp44_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp43_);
#line 248 "../src/bookworm.vala"
		_tmp45_ = _tmp44_;
#line 248 "../src/bookworm.vala"
		if (_tmp45_ == 0) {
#line 1216 "bookworm.c"
			GtkApplicationWindow* _tmp46_;
			GraniteWidgetsWelcome* _tmp47_;
			GtkApplicationWindow* _tmp48_;
			GtkBox* _tmp49_;
			GtkBox* _tmp50_;
#line 250 "../src/bookworm.vala"
			_tmp46_ = bookworm_app_bookworm_window;
#line 250 "../src/bookworm.vala"
			_tmp47_ = bookworm_app_bookworm_welcomeWidget;
#line 250 "../src/bookworm.vala"
			gtk_container_remove ((GtkContainer*) _tmp46_, (GtkWidget*) _tmp47_);
#line 252 "../src/bookworm.vala"
			_tmp48_ = bookworm_app_bookworm_window;
#line 252 "../src/bookworm.vala"
			_tmp49_ = bookworm_app_bookworm_bookWormUIBox;
#line 252 "../src/bookworm.vala"
			gtk_container_add ((GtkContainer*) _tmp48_, (GtkWidget*) _tmp49_);
#line 253 "../src/bookworm.vala"
			_tmp50_ = bookworm_app_bookworm_bookWormUIBox;
#line 253 "../src/bookworm.vala"
			gtk_widget_show_all ((GtkWidget*) _tmp50_);
#line 254 "../src/bookworm.vala"
			bookworm_app_bookworm_toggleUIState ();
#line 1240 "bookworm.c"
		}
#line 257 "../src/bookworm.vala"
		bookworm_app_library_addBooksToLibrary (NULL, NULL);
#line 1244 "bookworm.c"
	}
#line 260 "../src/bookworm.vala"
	bookworm_app_content_handler_performStartUpActions ();
#line 261 "../src/bookworm.vala"
	bookworm_app_bookworm_toggleUIState ();
#line 262 "../src/bookworm.vala"
	g_info ("bookworm.vala:262: [END] [FUNCTION:activate]");
#line 1252 "bookworm.c"
}

static void
bookworm_app_bookworm_real_open (GApplication* base,
                                 GFile** files,
                                 gint files_length1,
                                 const gchar* hint)
{
	BookwormAppBookworm * self;
#line 265 "../src/bookworm.vala"
	self = (BookwormAppBookworm*) base;
#line 265 "../src/bookworm.vala"
	g_return_if_fail (hint != NULL);
#line 1266 "bookworm.c"
}

void
bookworm_app_bookworm_loadImages (BookwormAppBookworm* self)
{
	GError* _inner_error0_ = NULL;
#line 269 "../src/bookworm.vala"
	g_return_if_fail (self != NULL);
#line 270 "../src/bookworm.vala"
	g_info ("bookworm.vala:270: [START] [FUNCTION:loadImages]");
#line 1277 "bookworm.c"
	{
		GdkPixbuf* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_;
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_ = NULL;
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_ = NULL;
		GdkPixbuf* _tmp7_;
		GdkPixbuf* _tmp8_;
		GdkPixbuf* _tmp9_;
		GdkPixbuf* _tmp10_ = NULL;
		GdkPixbuf* _tmp11_;
		GdkPixbuf* _tmp12_;
		GdkPixbuf* _tmp13_ = NULL;
		GdkPixbuf* _tmp14_;
		GdkPixbuf* _tmp15_;
		GdkPixbuf* _tmp16_ = NULL;
		GdkPixbuf* _tmp17_;
		GdkPixbuf* _tmp18_;
		GdkPixbuf* _tmp19_ = NULL;
		GdkPixbuf* _tmp20_;
		GdkPixbuf* _tmp21_;
		GdkPixbuf* _tmp22_ = NULL;
		GdkPixbuf* _tmp23_;
		GdkPixbuf* _tmp24_;
		GtkIconTheme* _tmp25_;
		GtkIconTheme* _tmp28_;
		GtkIconTheme* _tmp31_;
		GtkIconTheme* _tmp34_;
		GtkIconTheme* _tmp37_;
		GtkIconTheme* _tmp40_;
		GtkIconTheme* _tmp45_;
		GtkIconTheme* _tmp50_;
		GtkIconTheme* _tmp55_;
		GtkIconTheme* _tmp60_;
		GtkIconTheme* _tmp65_;
		GtkIconTheme* _tmp70_;
		GtkIconTheme* _tmp75_;
		GtkIconTheme* _tmp80_;
		GtkIconTheme* _tmp85_;
		GtkIconTheme* _tmp88_;
		GtkIconTheme* _tmp91_;
		GtkIconTheme* _tmp94_;
#line 272 "../src/bookworm.vala"
		_tmp1_ = gdk_pixbuf_new_from_resource (BOOKWORM_APP_CONSTANTS_SELECTION_OPTION_IMAGE_SMALL_LOCATION, &_inner_error0_);
#line 272 "../src/bookworm.vala"
		_tmp0_ = _tmp1_;
#line 272 "../src/bookworm.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1328 "bookworm.c"
			goto __catch0_g_error;
		}
#line 272 "../src/bookworm.vala"
		_tmp2_ = _tmp0_;
#line 272 "../src/bookworm.vala"
		_tmp0_ = NULL;
#line 272 "../src/bookworm.vala"
		_g_object_unref0 (bookworm_app_bookworm_image_selection_option_small);
#line 272 "../src/bookworm.vala"
		bookworm_app_bookworm_image_selection_option_small = _tmp2_;
#line 273 "../src/bookworm.vala"
		_tmp4_ = gdk_pixbuf_new_from_resource (BOOKWORM_APP_CONSTANTS_SELECTION_CHECKED_IMAGE_SMALL_LOCATION, &_inner_error0_);
#line 273 "../src/bookworm.vala"
		_tmp3_ = _tmp4_;
#line 273 "../src/bookworm.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 273 "../src/bookworm.vala"
			_g_object_unref0 (_tmp0_);
#line 1347 "bookworm.c"
			goto __catch0_g_error;
		}
#line 273 "../src/bookworm.vala"
		_tmp5_ = _tmp3_;
#line 273 "../src/bookworm.vala"
		_tmp3_ = NULL;
#line 273 "../src/bookworm.vala"
		_g_object_unref0 (bookworm_app_bookworm_image_selection_checked_small);
#line 273 "../src/bookworm.vala"
		bookworm_app_bookworm_image_selection_checked_small = _tmp5_;
#line 274 "../src/bookworm.vala"
		_tmp7_ = gdk_pixbuf_new_from_resource (BOOKWORM_APP_CONSTANTS_SELECTION_CHECKED_IMAGE_SMALL_LOCATION, &_inner_error0_);
#line 274 "../src/bookworm.vala"
		_tmp6_ = _tmp7_;
#line 274 "../src/bookworm.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 274 "../src/bookworm.vala"
			_g_object_unref0 (_tmp3_);
#line 274 "../src/bookworm.vala"
			_g_object_unref0 (_tmp0_);
#line 1368 "bookworm.c"
			goto __catch0_g_error;
		}
#line 274 "../src/bookworm.vala"
		_tmp8_ = _tmp6_;
#line 274 "../src/bookworm.vala"
		_tmp6_ = NULL;
#line 274 "../src/bookworm.vala"
		_g_object_unref0 (bookworm_app_bookworm_image_selection_transparent_small);
#line 274 "../src/bookworm.vala"
		bookworm_app_bookworm_image_selection_transparent_small = _tmp8_;
#line 275 "../src/bookworm.vala"
		_tmp9_ = bookworm_app_bookworm_image_selection_transparent_small;
#line 275 "../src/bookworm.vala"
		gdk_pixbuf_fill (_tmp9_, (guint32) 0x00000000);
#line 276 "../src/bookworm.vala"
		_tmp11_ = gdk_pixbuf_new_from_resource (BOOKWORM_APP_CONSTANTS_RATING_1_IMAGE_LOCATION, &_inner_error0_);
#line 276 "../src/bookworm.vala"
		_tmp10_ = _tmp11_;
#line 276 "../src/bookworm.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 276 "../src/bookworm.vala"
			_g_object_unref0 (_tmp6_);
#line 276 "../src/bookworm.vala"
			_g_object_unref0 (_tmp3_);
#line 276 "../src/bookworm.vala"
			_g_object_unref0 (_tmp0_);
#line 1395 "bookworm.c"
			goto __catch0_g_error;
		}
#line 276 "../src/bookworm.vala"
		_tmp12_ = _tmp10_;
#line 276 "../src/bookworm.vala"
		_tmp10_ = NULL;
#line 276 "../src/bookworm.vala"
		_g_object_unref0 (bookworm_app_bookworm_image_rating_1);
#line 276 "../src/bookworm.vala"
		bookworm_app_bookworm_image_rating_1 = _tmp12_;
#line 277 "../src/bookworm.vala"
		_tmp14_ = gdk_pixbuf_new_from_resource (BOOKWORM_APP_CONSTANTS_RATING_2_IMAGE_LOCATION, &_inner_error0_);
#line 277 "../src/bookworm.vala"
		_tmp13_ = _tmp14_;
#line 277 "../src/bookworm.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 277 "../src/bookworm.vala"
			_g_object_unref0 (_tmp10_);
#line 277 "../src/bookworm.vala"
			_g_object_unref0 (_tmp6_);
#line 277 "../src/bookworm.vala"
			_g_object_unref0 (_tmp3_);
#line 277 "../src/bookworm.vala"
			_g_object_unref0 (_tmp0_);
#line 1420 "bookworm.c"
			goto __catch0_g_error;
		}
#line 277 "../src/bookworm.vala"
		_tmp15_ = _tmp13_;
#line 277 "../src/bookworm.vala"
		_tmp13_ = NULL;
#line 277 "../src/bookworm.vala"
		_g_object_unref0 (bookworm_app_bookworm_image_rating_2);
#line 277 "../src/bookworm.vala"
		bookworm_app_bookworm_image_rating_2 = _tmp15_;
#line 278 "../src/bookworm.vala"
		_tmp17_ = gdk_pixbuf_new_from_resource (BOOKWORM_APP_CONSTANTS_RATING_3_IMAGE_LOCATION, &_inner_error0_);
#line 278 "../src/bookworm.vala"
		_tmp16_ = _tmp17_;
#line 278 "../src/bookworm.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 278 "../src/bookworm.vala"
			_g_object_unref0 (_tmp13_);
#line 278 "../src/bookworm.vala"
			_g_object_unref0 (_tmp10_);
#line 278 "../src/bookworm.vala"
			_g_object_unref0 (_tmp6_);
#line 278 "../src/bookworm.vala"
			_g_object_unref0 (_tmp3_);
#line 278 "../src/bookworm.vala"
			_g_object_unref0 (_tmp0_);
#line 1447 "bookworm.c"
			goto __catch0_g_error;
		}
#line 278 "../src/bookworm.vala"
		_tmp18_ = _tmp16_;
#line 278 "../src/bookworm.vala"
		_tmp16_ = NULL;
#line 278 "../src/bookworm.vala"
		_g_object_unref0 (bookworm_app_bookworm_image_rating_3);
#line 278 "../src/bookworm.vala"
		bookworm_app_bookworm_image_rating_3 = _tmp18_;
#line 279 "../src/bookworm.vala"
		_tmp20_ = gdk_pixbuf_new_from_resource (BOOKWORM_APP_CONSTANTS_RATING_4_IMAGE_LOCATION, &_inner_error0_);
#line 279 "../src/bookworm.vala"
		_tmp19_ = _tmp20_;
#line 279 "../src/bookworm.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 279 "../src/bookworm.vala"
			_g_object_unref0 (_tmp16_);
#line 279 "../src/bookworm.vala"
			_g_object_unref0 (_tmp13_);
#line 279 "../src/bookworm.vala"
			_g_object_unref0 (_tmp10_);
#line 279 "../src/bookworm.vala"
			_g_object_unref0 (_tmp6_);
#line 279 "../src/bookworm.vala"
			_g_object_unref0 (_tmp3_);
#line 279 "../src/bookworm.vala"
			_g_object_unref0 (_tmp0_);
#line 1476 "bookworm.c"
			goto __catch0_g_error;
		}
#line 279 "../src/bookworm.vala"
		_tmp21_ = _tmp19_;
#line 279 "../src/bookworm.vala"
		_tmp19_ = NULL;
#line 279 "../src/bookworm.vala"
		_g_object_unref0 (bookworm_app_bookworm_image_rating_4);
#line 279 "../src/bookworm.vala"
		bookworm_app_bookworm_image_rating_4 = _tmp21_;
#line 280 "../src/bookworm.vala"
		_tmp23_ = gdk_pixbuf_new_from_resource (BOOKWORM_APP_CONSTANTS_RATING_5_IMAGE_LOCATION, &_inner_error0_);
#line 280 "../src/bookworm.vala"
		_tmp22_ = _tmp23_;
#line 280 "../src/bookworm.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 280 "../src/bookworm.vala"
			_g_object_unref0 (_tmp19_);
#line 280 "../src/bookworm.vala"
			_g_object_unref0 (_tmp16_);
#line 280 "../src/bookworm.vala"
			_g_object_unref0 (_tmp13_);
#line 280 "../src/bookworm.vala"
			_g_object_unref0 (_tmp10_);
#line 280 "../src/bookworm.vala"
			_g_object_unref0 (_tmp6_);
#line 280 "../src/bookworm.vala"
			_g_object_unref0 (_tmp3_);
#line 280 "../src/bookworm.vala"
			_g_object_unref0 (_tmp0_);
#line 1507 "bookworm.c"
			goto __catch0_g_error;
		}
#line 280 "../src/bookworm.vala"
		_tmp24_ = _tmp22_;
#line 280 "../src/bookworm.vala"
		_tmp22_ = NULL;
#line 280 "../src/bookworm.vala"
		_g_object_unref0 (bookworm_app_bookworm_image_rating_5);
#line 280 "../src/bookworm.vala"
		bookworm_app_bookworm_image_rating_5 = _tmp24_;
#line 282 "../src/bookworm.vala"
		_tmp25_ = gtk_icon_theme_get_default ();
#line 282 "../src/bookworm.vala"
		if (gtk_icon_theme_has_icon (_tmp25_, "object-select-symbolic")) {
#line 1522 "bookworm.c"
			GtkImage* _tmp26_;
#line 283 "../src/bookworm.vala"
			_tmp26_ = (GtkImage*) gtk_image_new_from_icon_name ("object-select-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 283 "../src/bookworm.vala"
			g_object_ref_sink (_tmp26_);
#line 283 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_select_book_image);
#line 283 "../src/bookworm.vala"
			bookworm_app_bookworm_select_book_image = _tmp26_;
#line 1532 "bookworm.c"
		} else {
			GtkImage* _tmp27_;
#line 285 "../src/bookworm.vala"
			_tmp27_ = (GtkImage*) gtk_image_new_from_resource (BOOKWORM_APP_CONSTANTS_SELECT_BOOK_ICON_IMAGE_LOCATION);
#line 285 "../src/bookworm.vala"
			g_object_ref_sink (_tmp27_);
#line 285 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_select_book_image);
#line 285 "../src/bookworm.vala"
			bookworm_app_bookworm_select_book_image = _tmp27_;
#line 1543 "bookworm.c"
		}
#line 287 "../src/bookworm.vala"
		_tmp28_ = gtk_icon_theme_get_default ();
#line 287 "../src/bookworm.vala"
		if (gtk_icon_theme_has_icon (_tmp28_, "list-add-symbolic")) {
#line 1549 "bookworm.c"
			GtkImage* _tmp29_;
#line 288 "../src/bookworm.vala"
			_tmp29_ = (GtkImage*) gtk_image_new_from_icon_name ("list-add-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 288 "../src/bookworm.vala"
			g_object_ref_sink (_tmp29_);
#line 288 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_add_book_image);
#line 288 "../src/bookworm.vala"
			bookworm_app_bookworm_add_book_image = _tmp29_;
#line 1559 "bookworm.c"
		} else {
			GtkImage* _tmp30_;
#line 290 "../src/bookworm.vala"
			_tmp30_ = (GtkImage*) gtk_image_new_from_resource (BOOKWORM_APP_CONSTANTS_ADD_BOOK_ICON_IMAGE_LOCATION);
#line 290 "../src/bookworm.vala"
			g_object_ref_sink (_tmp30_);
#line 290 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_add_book_image);
#line 290 "../src/bookworm.vala"
			bookworm_app_bookworm_add_book_image = _tmp30_;
#line 1570 "bookworm.c"
		}
#line 292 "../src/bookworm.vala"
		_tmp31_ = gtk_icon_theme_get_default ();
#line 292 "../src/bookworm.vala"
		if (gtk_icon_theme_has_icon (_tmp31_, "list-remove-symbolic")) {
#line 1576 "bookworm.c"
			GtkImage* _tmp32_;
#line 293 "../src/bookworm.vala"
			_tmp32_ = (GtkImage*) gtk_image_new_from_icon_name ("list-remove-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 293 "../src/bookworm.vala"
			g_object_ref_sink (_tmp32_);
#line 293 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_remove_book_image);
#line 293 "../src/bookworm.vala"
			bookworm_app_bookworm_remove_book_image = _tmp32_;
#line 1586 "bookworm.c"
		} else {
			GtkImage* _tmp33_;
#line 295 "../src/bookworm.vala"
			_tmp33_ = (GtkImage*) gtk_image_new_from_resource (BOOKWORM_APP_CONSTANTS_REMOVE_BOOK_ICON_IMAGE_LOCATION);
#line 295 "../src/bookworm.vala"
			g_object_ref_sink (_tmp33_);
#line 295 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_remove_book_image);
#line 295 "../src/bookworm.vala"
			bookworm_app_bookworm_remove_book_image = _tmp33_;
#line 1597 "bookworm.c"
		}
#line 297 "../src/bookworm.vala"
		_tmp34_ = gtk_icon_theme_get_default ();
#line 297 "../src/bookworm.vala"
		if (gtk_icon_theme_has_icon (_tmp34_, "list-add-symbolic")) {
#line 1603 "bookworm.c"
			GtkImage* _tmp35_;
#line 298 "../src/bookworm.vala"
			_tmp35_ = (GtkImage*) gtk_image_new_from_icon_name ("list-add-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 298 "../src/bookworm.vala"
			g_object_ref_sink (_tmp35_);
#line 298 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_add_scan_directory_image);
#line 298 "../src/bookworm.vala"
			bookworm_app_bookworm_add_scan_directory_image = _tmp35_;
#line 1613 "bookworm.c"
		} else {
			GtkImage* _tmp36_;
#line 300 "../src/bookworm.vala"
			_tmp36_ = (GtkImage*) gtk_image_new_from_resource (BOOKWORM_APP_CONSTANTS_ADD_BOOK_ICON_IMAGE_LOCATION);
#line 300 "../src/bookworm.vala"
			g_object_ref_sink (_tmp36_);
#line 300 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_add_scan_directory_image);
#line 300 "../src/bookworm.vala"
			bookworm_app_bookworm_add_scan_directory_image = _tmp36_;
#line 1624 "bookworm.c"
		}
#line 302 "../src/bookworm.vala"
		_tmp37_ = gtk_icon_theme_get_default ();
#line 302 "../src/bookworm.vala"
		if (gtk_icon_theme_has_icon (_tmp37_, "list-remove-symbolic")) {
#line 1630 "bookworm.c"
			GtkImage* _tmp38_;
#line 303 "../src/bookworm.vala"
			_tmp38_ = (GtkImage*) gtk_image_new_from_icon_name ("list-remove-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 303 "../src/bookworm.vala"
			g_object_ref_sink (_tmp38_);
#line 303 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_remove_scan_directory_image);
#line 303 "../src/bookworm.vala"
			bookworm_app_bookworm_remove_scan_directory_image = _tmp38_;
#line 1640 "bookworm.c"
		} else {
			GtkImage* _tmp39_;
#line 305 "../src/bookworm.vala"
			_tmp39_ = (GtkImage*) gtk_image_new_from_resource (BOOKWORM_APP_CONSTANTS_REMOVE_BOOK_ICON_IMAGE_LOCATION);
#line 305 "../src/bookworm.vala"
			g_object_ref_sink (_tmp39_);
#line 305 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_remove_scan_directory_image);
#line 305 "../src/bookworm.vala"
			bookworm_app_bookworm_remove_scan_directory_image = _tmp39_;
#line 1651 "bookworm.c"
		}
#line 307 "../src/bookworm.vala"
		_tmp40_ = gtk_icon_theme_get_default ();
#line 307 "../src/bookworm.vala"
		if (gtk_icon_theme_has_icon (_tmp40_, "view-list-symbolic")) {
#line 1657 "bookworm.c"
			GtkImage* _tmp41_;
#line 308 "../src/bookworm.vala"
			_tmp41_ = (GtkImage*) gtk_image_new_from_icon_name ("view-list-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
#line 308 "../src/bookworm.vala"
			g_object_ref_sink (_tmp41_);
#line 308 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_library_list_button_image);
#line 308 "../src/bookworm.vala"
			bookworm_app_bookworm_library_list_button_image = _tmp41_;
#line 1667 "bookworm.c"
		} else {
			GdkPixbuf* _tmp42_ = NULL;
			GdkPixbuf* _tmp43_;
			GtkImage* _tmp44_;
#line 310 "../src/bookworm.vala"
			_tmp43_ = gdk_pixbuf_new_from_resource_at_scale (BOOKWORM_APP_CONSTANTS_LIBRARY_VIEW_LIST_IMAGE_LOCATION, 16, 16, TRUE, &_inner_error0_);
#line 310 "../src/bookworm.vala"
			_tmp42_ = _tmp43_;
#line 310 "../src/bookworm.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 310 "../src/bookworm.vala"
				_g_object_unref0 (_tmp22_);
#line 310 "../src/bookworm.vala"
				_g_object_unref0 (_tmp19_);
#line 310 "../src/bookworm.vala"
				_g_object_unref0 (_tmp16_);
#line 310 "../src/bookworm.vala"
				_g_object_unref0 (_tmp13_);
#line 310 "../src/bookworm.vala"
				_g_object_unref0 (_tmp10_);
#line 310 "../src/bookworm.vala"
				_g_object_unref0 (_tmp6_);
#line 310 "../src/bookworm.vala"
				_g_object_unref0 (_tmp3_);
#line 310 "../src/bookworm.vala"
				_g_object_unref0 (_tmp0_);
#line 1694 "bookworm.c"
				goto __catch0_g_error;
			}
#line 310 "../src/bookworm.vala"
			_tmp44_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp42_);
#line 310 "../src/bookworm.vala"
			g_object_ref_sink (_tmp44_);
#line 310 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_library_list_button_image);
#line 310 "../src/bookworm.vala"
			bookworm_app_bookworm_library_list_button_image = _tmp44_;
#line 307 "../src/bookworm.vala"
			_g_object_unref0 (_tmp42_);
#line 1707 "bookworm.c"
		}
#line 312 "../src/bookworm.vala"
		_tmp45_ = gtk_icon_theme_get_default ();
#line 312 "../src/bookworm.vala"
		if (gtk_icon_theme_has_icon (_tmp45_, "view-grid-symbolic")) {
#line 1713 "bookworm.c"
			GtkImage* _tmp46_;
#line 313 "../src/bookworm.vala"
			_tmp46_ = (GtkImage*) gtk_image_new_from_icon_name ("view-grid-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
#line 313 "../src/bookworm.vala"
			g_object_ref_sink (_tmp46_);
#line 313 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_library_grid_button_image);
#line 313 "../src/bookworm.vala"
			bookworm_app_bookworm_library_grid_button_image = _tmp46_;
#line 1723 "bookworm.c"
		} else {
			GdkPixbuf* _tmp47_ = NULL;
			GdkPixbuf* _tmp48_;
			GtkImage* _tmp49_;
#line 315 "../src/bookworm.vala"
			_tmp48_ = gdk_pixbuf_new_from_resource_at_scale (BOOKWORM_APP_CONSTANTS_LIBRARY_VIEW_GRID_IMAGE_LOCATION, 16, 16, TRUE, &_inner_error0_);
#line 315 "../src/bookworm.vala"
			_tmp47_ = _tmp48_;
#line 315 "../src/bookworm.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 315 "../src/bookworm.vala"
				_g_object_unref0 (_tmp22_);
#line 315 "../src/bookworm.vala"
				_g_object_unref0 (_tmp19_);
#line 315 "../src/bookworm.vala"
				_g_object_unref0 (_tmp16_);
#line 315 "../src/bookworm.vala"
				_g_object_unref0 (_tmp13_);
#line 315 "../src/bookworm.vala"
				_g_object_unref0 (_tmp10_);
#line 315 "../src/bookworm.vala"
				_g_object_unref0 (_tmp6_);
#line 315 "../src/bookworm.vala"
				_g_object_unref0 (_tmp3_);
#line 315 "../src/bookworm.vala"
				_g_object_unref0 (_tmp0_);
#line 1750 "bookworm.c"
				goto __catch0_g_error;
			}
#line 315 "../src/bookworm.vala"
			_tmp49_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp47_);
#line 315 "../src/bookworm.vala"
			g_object_ref_sink (_tmp49_);
#line 315 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_library_grid_button_image);
#line 315 "../src/bookworm.vala"
			bookworm_app_bookworm_library_grid_button_image = _tmp49_;
#line 312 "../src/bookworm.vala"
			_g_object_unref0 (_tmp47_);
#line 1763 "bookworm.c"
		}
#line 317 "../src/bookworm.vala"
		_tmp50_ = gtk_icon_theme_get_default ();
#line 317 "../src/bookworm.vala"
		if (gtk_icon_theme_has_icon (_tmp50_, "format-justify-left-symbolic")) {
#line 1769 "bookworm.c"
			GtkImage* _tmp51_;
#line 318 "../src/bookworm.vala"
			_tmp51_ = (GtkImage*) gtk_image_new_from_icon_name ("format-justify-left-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
#line 318 "../src/bookworm.vala"
			g_object_ref_sink (_tmp51_);
#line 318 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_pref_menu_icon_align_left);
#line 318 "../src/bookworm.vala"
			bookworm_app_bookworm_pref_menu_icon_align_left = _tmp51_;
#line 1779 "bookworm.c"
		} else {
			GdkPixbuf* _tmp52_ = NULL;
			GdkPixbuf* _tmp53_;
			GtkImage* _tmp54_;
#line 320 "../src/bookworm.vala"
			_tmp53_ = gdk_pixbuf_new_from_resource_at_scale (BOOKWORM_APP_CONSTANTS_TEXT_ALIGN_LEFT_ICON_LOCATION, 16, 16, TRUE, &_inner_error0_);
#line 320 "../src/bookworm.vala"
			_tmp52_ = _tmp53_;
#line 320 "../src/bookworm.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 320 "../src/bookworm.vala"
				_g_object_unref0 (_tmp22_);
#line 320 "../src/bookworm.vala"
				_g_object_unref0 (_tmp19_);
#line 320 "../src/bookworm.vala"
				_g_object_unref0 (_tmp16_);
#line 320 "../src/bookworm.vala"
				_g_object_unref0 (_tmp13_);
#line 320 "../src/bookworm.vala"
				_g_object_unref0 (_tmp10_);
#line 320 "../src/bookworm.vala"
				_g_object_unref0 (_tmp6_);
#line 320 "../src/bookworm.vala"
				_g_object_unref0 (_tmp3_);
#line 320 "../src/bookworm.vala"
				_g_object_unref0 (_tmp0_);
#line 1806 "bookworm.c"
				goto __catch0_g_error;
			}
#line 320 "../src/bookworm.vala"
			_tmp54_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp52_);
#line 320 "../src/bookworm.vala"
			g_object_ref_sink (_tmp54_);
#line 320 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_pref_menu_icon_align_left);
#line 320 "../src/bookworm.vala"
			bookworm_app_bookworm_pref_menu_icon_align_left = _tmp54_;
#line 317 "../src/bookworm.vala"
			_g_object_unref0 (_tmp52_);
#line 1819 "bookworm.c"
		}
#line 322 "../src/bookworm.vala"
		_tmp55_ = gtk_icon_theme_get_default ();
#line 322 "../src/bookworm.vala"
		if (gtk_icon_theme_has_icon (_tmp55_, "format-justify-right-symbolic")) {
#line 1825 "bookworm.c"
			GtkImage* _tmp56_;
#line 323 "../src/bookworm.vala"
			_tmp56_ = (GtkImage*) gtk_image_new_from_icon_name ("format-justify-right-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
#line 323 "../src/bookworm.vala"
			g_object_ref_sink (_tmp56_);
#line 323 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_pref_menu_icon_align_right);
#line 323 "../src/bookworm.vala"
			bookworm_app_bookworm_pref_menu_icon_align_right = _tmp56_;
#line 1835 "bookworm.c"
		} else {
			GdkPixbuf* _tmp57_ = NULL;
			GdkPixbuf* _tmp58_;
			GtkImage* _tmp59_;
#line 325 "../src/bookworm.vala"
			_tmp58_ = gdk_pixbuf_new_from_resource_at_scale (BOOKWORM_APP_CONSTANTS_TEXT_ALIGN_RIGHT_ICON_LOCATION, 16, 16, TRUE, &_inner_error0_);
#line 325 "../src/bookworm.vala"
			_tmp57_ = _tmp58_;
#line 325 "../src/bookworm.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 325 "../src/bookworm.vala"
				_g_object_unref0 (_tmp22_);
#line 325 "../src/bookworm.vala"
				_g_object_unref0 (_tmp19_);
#line 325 "../src/bookworm.vala"
				_g_object_unref0 (_tmp16_);
#line 325 "../src/bookworm.vala"
				_g_object_unref0 (_tmp13_);
#line 325 "../src/bookworm.vala"
				_g_object_unref0 (_tmp10_);
#line 325 "../src/bookworm.vala"
				_g_object_unref0 (_tmp6_);
#line 325 "../src/bookworm.vala"
				_g_object_unref0 (_tmp3_);
#line 325 "../src/bookworm.vala"
				_g_object_unref0 (_tmp0_);
#line 1862 "bookworm.c"
				goto __catch0_g_error;
			}
#line 325 "../src/bookworm.vala"
			_tmp59_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp57_);
#line 325 "../src/bookworm.vala"
			g_object_ref_sink (_tmp59_);
#line 325 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_pref_menu_icon_align_right);
#line 325 "../src/bookworm.vala"
			bookworm_app_bookworm_pref_menu_icon_align_right = _tmp59_;
#line 322 "../src/bookworm.vala"
			_g_object_unref0 (_tmp57_);
#line 1875 "bookworm.c"
		}
#line 327 "../src/bookworm.vala"
		_tmp60_ = gtk_icon_theme_get_default ();
#line 327 "../src/bookworm.vala"
		if (gtk_icon_theme_has_icon (_tmp60_, "help-info-symbolic")) {
#line 1881 "bookworm.c"
			GtkImage* _tmp61_;
#line 328 "../src/bookworm.vala"
			_tmp61_ = (GtkImage*) gtk_image_new_from_icon_name ("help-info-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
#line 328 "../src/bookworm.vala"
			g_object_ref_sink (_tmp61_);
#line 328 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_content_list_button_image);
#line 328 "../src/bookworm.vala"
			bookworm_app_bookworm_content_list_button_image = _tmp61_;
#line 1891 "bookworm.c"
		} else {
			GdkPixbuf* _tmp62_ = NULL;
			GdkPixbuf* _tmp63_;
			GtkImage* _tmp64_;
#line 330 "../src/bookworm.vala"
			_tmp63_ = gdk_pixbuf_new_from_resource_at_scale (BOOKWORM_APP_CONSTANTS_BOOK_INFO_IMAGE_LOCATION, 24, 24, TRUE, &_inner_error0_);
#line 330 "../src/bookworm.vala"
			_tmp62_ = _tmp63_;
#line 330 "../src/bookworm.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 330 "../src/bookworm.vala"
				_g_object_unref0 (_tmp22_);
#line 330 "../src/bookworm.vala"
				_g_object_unref0 (_tmp19_);
#line 330 "../src/bookworm.vala"
				_g_object_unref0 (_tmp16_);
#line 330 "../src/bookworm.vala"
				_g_object_unref0 (_tmp13_);
#line 330 "../src/bookworm.vala"
				_g_object_unref0 (_tmp10_);
#line 330 "../src/bookworm.vala"
				_g_object_unref0 (_tmp6_);
#line 330 "../src/bookworm.vala"
				_g_object_unref0 (_tmp3_);
#line 330 "../src/bookworm.vala"
				_g_object_unref0 (_tmp0_);
#line 1918 "bookworm.c"
				goto __catch0_g_error;
			}
#line 330 "../src/bookworm.vala"
			_tmp64_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp62_);
#line 330 "../src/bookworm.vala"
			g_object_ref_sink (_tmp64_);
#line 330 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_content_list_button_image);
#line 330 "../src/bookworm.vala"
			bookworm_app_bookworm_content_list_button_image = _tmp64_;
#line 327 "../src/bookworm.vala"
			_g_object_unref0 (_tmp62_);
#line 1931 "bookworm.c"
		}
#line 332 "../src/bookworm.vala"
		_tmp65_ = gtk_icon_theme_get_default ();
#line 332 "../src/bookworm.vala"
		if (gtk_icon_theme_has_icon (_tmp65_, "format-text-larger-symbolic")) {
#line 1937 "bookworm.c"
			GtkImage* _tmp66_;
#line 333 "../src/bookworm.vala"
			_tmp66_ = (GtkImage*) gtk_image_new_from_icon_name ("format-text-larger-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
#line 333 "../src/bookworm.vala"
			g_object_ref_sink (_tmp66_);
#line 333 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_menu_icon_text_large);
#line 333 "../src/bookworm.vala"
			bookworm_app_bookworm_menu_icon_text_large = _tmp66_;
#line 1947 "bookworm.c"
		} else {
			GdkPixbuf* _tmp67_ = NULL;
			GdkPixbuf* _tmp68_;
			GtkImage* _tmp69_;
#line 335 "../src/bookworm.vala"
			_tmp68_ = gdk_pixbuf_new_from_resource_at_scale (BOOKWORM_APP_CONSTANTS_TEXT_LARGER_IMAGE_ICON_LOCATION, 24, 24, TRUE, &_inner_error0_);
#line 335 "../src/bookworm.vala"
			_tmp67_ = _tmp68_;
#line 335 "../src/bookworm.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 335 "../src/bookworm.vala"
				_g_object_unref0 (_tmp22_);
#line 335 "../src/bookworm.vala"
				_g_object_unref0 (_tmp19_);
#line 335 "../src/bookworm.vala"
				_g_object_unref0 (_tmp16_);
#line 335 "../src/bookworm.vala"
				_g_object_unref0 (_tmp13_);
#line 335 "../src/bookworm.vala"
				_g_object_unref0 (_tmp10_);
#line 335 "../src/bookworm.vala"
				_g_object_unref0 (_tmp6_);
#line 335 "../src/bookworm.vala"
				_g_object_unref0 (_tmp3_);
#line 335 "../src/bookworm.vala"
				_g_object_unref0 (_tmp0_);
#line 1974 "bookworm.c"
				goto __catch0_g_error;
			}
#line 335 "../src/bookworm.vala"
			_tmp69_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp67_);
#line 335 "../src/bookworm.vala"
			g_object_ref_sink (_tmp69_);
#line 335 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_menu_icon_text_large);
#line 335 "../src/bookworm.vala"
			bookworm_app_bookworm_menu_icon_text_large = _tmp69_;
#line 332 "../src/bookworm.vala"
			_g_object_unref0 (_tmp67_);
#line 1987 "bookworm.c"
		}
#line 337 "../src/bookworm.vala"
		_tmp70_ = gtk_icon_theme_get_default ();
#line 337 "../src/bookworm.vala"
		if (gtk_icon_theme_has_icon (_tmp70_, "open-menu")) {
#line 1993 "bookworm.c"
			GtkImage* _tmp71_;
#line 338 "../src/bookworm.vala"
			_tmp71_ = (GtkImage*) gtk_image_new_from_icon_name ("open-menu", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
#line 338 "../src/bookworm.vala"
			g_object_ref_sink (_tmp71_);
#line 338 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_menu_icon);
#line 338 "../src/bookworm.vala"
			bookworm_app_bookworm_menu_icon = _tmp71_;
#line 2003 "bookworm.c"
		} else {
			GdkPixbuf* _tmp72_ = NULL;
			GdkPixbuf* _tmp73_;
			GtkImage* _tmp74_;
#line 340 "../src/bookworm.vala"
			_tmp73_ = gdk_pixbuf_new_from_resource_at_scale (BOOKWORM_APP_CONSTANTS_HEADERBAR_PROPERTIES_IMAGE_LOCATION, 24, 24, TRUE, &_inner_error0_);
#line 340 "../src/bookworm.vala"
			_tmp72_ = _tmp73_;
#line 340 "../src/bookworm.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 340 "../src/bookworm.vala"
				_g_object_unref0 (_tmp22_);
#line 340 "../src/bookworm.vala"
				_g_object_unref0 (_tmp19_);
#line 340 "../src/bookworm.vala"
				_g_object_unref0 (_tmp16_);
#line 340 "../src/bookworm.vala"
				_g_object_unref0 (_tmp13_);
#line 340 "../src/bookworm.vala"
				_g_object_unref0 (_tmp10_);
#line 340 "../src/bookworm.vala"
				_g_object_unref0 (_tmp6_);
#line 340 "../src/bookworm.vala"
				_g_object_unref0 (_tmp3_);
#line 340 "../src/bookworm.vala"
				_g_object_unref0 (_tmp0_);
#line 2030 "bookworm.c"
				goto __catch0_g_error;
			}
#line 340 "../src/bookworm.vala"
			_tmp74_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp72_);
#line 340 "../src/bookworm.vala"
			g_object_ref_sink (_tmp74_);
#line 340 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_menu_icon);
#line 340 "../src/bookworm.vala"
			bookworm_app_bookworm_menu_icon = _tmp74_;
#line 337 "../src/bookworm.vala"
			_g_object_unref0 (_tmp72_);
#line 2043 "bookworm.c"
		}
#line 342 "../src/bookworm.vala"
		_tmp75_ = gtk_icon_theme_get_default ();
#line 342 "../src/bookworm.vala"
		if (gtk_icon_theme_has_icon (_tmp75_, "format-text-larger-symbolic")) {
#line 2049 "bookworm.c"
			GtkImage* _tmp76_;
#line 343 "../src/bookworm.vala"
			_tmp76_ = (GtkImage*) gtk_image_new_from_icon_name ("format-text-larger-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
#line 343 "../src/bookworm.vala"
			g_object_ref_sink (_tmp76_);
#line 343 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_pref_menu_icon_text_large);
#line 343 "../src/bookworm.vala"
			bookworm_app_bookworm_pref_menu_icon_text_large = _tmp76_;
#line 2059 "bookworm.c"
		} else {
			GdkPixbuf* _tmp77_ = NULL;
			GdkPixbuf* _tmp78_;
			GtkImage* _tmp79_;
#line 345 "../src/bookworm.vala"
			_tmp78_ = gdk_pixbuf_new_from_resource_at_scale (BOOKWORM_APP_CONSTANTS_TEXT_LARGER_IMAGE_ICON_LOCATION, 24, 24, TRUE, &_inner_error0_);
#line 345 "../src/bookworm.vala"
			_tmp77_ = _tmp78_;
#line 345 "../src/bookworm.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 345 "../src/bookworm.vala"
				_g_object_unref0 (_tmp22_);
#line 345 "../src/bookworm.vala"
				_g_object_unref0 (_tmp19_);
#line 345 "../src/bookworm.vala"
				_g_object_unref0 (_tmp16_);
#line 345 "../src/bookworm.vala"
				_g_object_unref0 (_tmp13_);
#line 345 "../src/bookworm.vala"
				_g_object_unref0 (_tmp10_);
#line 345 "../src/bookworm.vala"
				_g_object_unref0 (_tmp6_);
#line 345 "../src/bookworm.vala"
				_g_object_unref0 (_tmp3_);
#line 345 "../src/bookworm.vala"
				_g_object_unref0 (_tmp0_);
#line 2086 "bookworm.c"
				goto __catch0_g_error;
			}
#line 345 "../src/bookworm.vala"
			_tmp79_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp77_);
#line 345 "../src/bookworm.vala"
			g_object_ref_sink (_tmp79_);
#line 345 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_pref_menu_icon_text_large);
#line 345 "../src/bookworm.vala"
			bookworm_app_bookworm_pref_menu_icon_text_large = _tmp79_;
#line 342 "../src/bookworm.vala"
			_g_object_unref0 (_tmp77_);
#line 2099 "bookworm.c"
		}
#line 347 "../src/bookworm.vala"
		_tmp80_ = gtk_icon_theme_get_default ();
#line 347 "../src/bookworm.vala"
		if (gtk_icon_theme_has_icon (_tmp80_, "format-text-smaller-symbolic")) {
#line 2105 "bookworm.c"
			GtkImage* _tmp81_;
#line 348 "../src/bookworm.vala"
			_tmp81_ = (GtkImage*) gtk_image_new_from_icon_name ("format-text-smaller-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
#line 348 "../src/bookworm.vala"
			g_object_ref_sink (_tmp81_);
#line 348 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_pref_menu_icon_text_small);
#line 348 "../src/bookworm.vala"
			bookworm_app_bookworm_pref_menu_icon_text_small = _tmp81_;
#line 2115 "bookworm.c"
		} else {
			GdkPixbuf* _tmp82_ = NULL;
			GdkPixbuf* _tmp83_;
			GtkImage* _tmp84_;
#line 350 "../src/bookworm.vala"
			_tmp83_ = gdk_pixbuf_new_from_resource_at_scale (BOOKWORM_APP_CONSTANTS_TEXT_SMALLER_IMAGE_ICON_LOCATION, 24, 24, TRUE, &_inner_error0_);
#line 350 "../src/bookworm.vala"
			_tmp82_ = _tmp83_;
#line 350 "../src/bookworm.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 350 "../src/bookworm.vala"
				_g_object_unref0 (_tmp22_);
#line 350 "../src/bookworm.vala"
				_g_object_unref0 (_tmp19_);
#line 350 "../src/bookworm.vala"
				_g_object_unref0 (_tmp16_);
#line 350 "../src/bookworm.vala"
				_g_object_unref0 (_tmp13_);
#line 350 "../src/bookworm.vala"
				_g_object_unref0 (_tmp10_);
#line 350 "../src/bookworm.vala"
				_g_object_unref0 (_tmp6_);
#line 350 "../src/bookworm.vala"
				_g_object_unref0 (_tmp3_);
#line 350 "../src/bookworm.vala"
				_g_object_unref0 (_tmp0_);
#line 2142 "bookworm.c"
				goto __catch0_g_error;
			}
#line 350 "../src/bookworm.vala"
			_tmp84_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp82_);
#line 350 "../src/bookworm.vala"
			g_object_ref_sink (_tmp84_);
#line 350 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_pref_menu_icon_text_small);
#line 350 "../src/bookworm.vala"
			bookworm_app_bookworm_pref_menu_icon_text_small = _tmp84_;
#line 347 "../src/bookworm.vala"
			_g_object_unref0 (_tmp82_);
#line 2155 "bookworm.c"
		}
#line 352 "../src/bookworm.vala"
		_tmp85_ = gtk_icon_theme_get_default ();
#line 352 "../src/bookworm.vala"
		if (gtk_icon_theme_has_icon (_tmp85_, "go-previous-symbolic")) {
#line 2161 "bookworm.c"
			GtkImage* _tmp86_;
#line 353 "../src/bookworm.vala"
			_tmp86_ = (GtkImage*) gtk_image_new_from_icon_name ("go-previous-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 353 "../src/bookworm.vala"
			g_object_ref_sink (_tmp86_);
#line 353 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_back_button_image);
#line 353 "../src/bookworm.vala"
			bookworm_app_bookworm_back_button_image = _tmp86_;
#line 2171 "bookworm.c"
		} else {
			GtkImage* _tmp87_;
#line 355 "../src/bookworm.vala"
			_tmp87_ = (GtkImage*) gtk_image_new_from_resource (BOOKWORM_APP_CONSTANTS_PREV_PAGE_ICON_IMAGE_LOCATION);
#line 355 "../src/bookworm.vala"
			g_object_ref_sink (_tmp87_);
#line 355 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_back_button_image);
#line 355 "../src/bookworm.vala"
			bookworm_app_bookworm_back_button_image = _tmp87_;
#line 2182 "bookworm.c"
		}
#line 357 "../src/bookworm.vala"
		_tmp88_ = gtk_icon_theme_get_default ();
#line 357 "../src/bookworm.vala"
		if (gtk_icon_theme_has_icon (_tmp88_, "go-next-symbolic")) {
#line 2188 "bookworm.c"
			GtkImage* _tmp89_;
#line 358 "../src/bookworm.vala"
			_tmp89_ = (GtkImage*) gtk_image_new_from_icon_name ("go-next-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 358 "../src/bookworm.vala"
			g_object_ref_sink (_tmp89_);
#line 358 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_forward_button_image);
#line 358 "../src/bookworm.vala"
			bookworm_app_bookworm_forward_button_image = _tmp89_;
#line 2198 "bookworm.c"
		} else {
			GtkImage* _tmp90_;
#line 360 "../src/bookworm.vala"
			_tmp90_ = (GtkImage*) gtk_image_new_from_resource (BOOKWORM_APP_CONSTANTS_NEXT_PAGE_ICON_IMAGE_LOCATION);
#line 360 "../src/bookworm.vala"
			g_object_ref_sink (_tmp90_);
#line 360 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_forward_button_image);
#line 360 "../src/bookworm.vala"
			bookworm_app_bookworm_forward_button_image = _tmp90_;
#line 2209 "bookworm.c"
		}
#line 362 "../src/bookworm.vala"
		_tmp91_ = gtk_icon_theme_get_default ();
#line 362 "../src/bookworm.vala"
		if (gtk_icon_theme_has_icon (_tmp91_, "go-previous-symbolic")) {
#line 2215 "bookworm.c"
			GtkImage* _tmp92_;
#line 363 "../src/bookworm.vala"
			_tmp92_ = (GtkImage*) gtk_image_new_from_icon_name ("go-previous-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 363 "../src/bookworm.vala"
			g_object_ref_sink (_tmp92_);
#line 363 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_back_page_image);
#line 363 "../src/bookworm.vala"
			bookworm_app_bookworm_back_page_image = _tmp92_;
#line 2225 "bookworm.c"
		} else {
			GtkImage* _tmp93_;
#line 365 "../src/bookworm.vala"
			_tmp93_ = (GtkImage*) gtk_image_new_from_resource (BOOKWORM_APP_CONSTANTS_PREV_PAGE_ICON_IMAGE_LOCATION);
#line 365 "../src/bookworm.vala"
			g_object_ref_sink (_tmp93_);
#line 365 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_back_page_image);
#line 365 "../src/bookworm.vala"
			bookworm_app_bookworm_back_page_image = _tmp93_;
#line 2236 "bookworm.c"
		}
#line 367 "../src/bookworm.vala"
		_tmp94_ = gtk_icon_theme_get_default ();
#line 367 "../src/bookworm.vala"
		if (gtk_icon_theme_has_icon (_tmp94_, "go-next-symbolic")) {
#line 2242 "bookworm.c"
			GtkImage* _tmp95_;
#line 368 "../src/bookworm.vala"
			_tmp95_ = (GtkImage*) gtk_image_new_from_icon_name ("go-next-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 368 "../src/bookworm.vala"
			g_object_ref_sink (_tmp95_);
#line 368 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_forward_page_image);
#line 368 "../src/bookworm.vala"
			bookworm_app_bookworm_forward_page_image = _tmp95_;
#line 2252 "bookworm.c"
		} else {
			GtkImage* _tmp96_;
#line 370 "../src/bookworm.vala"
			_tmp96_ = (GtkImage*) gtk_image_new_from_resource (BOOKWORM_APP_CONSTANTS_NEXT_PAGE_ICON_IMAGE_LOCATION);
#line 370 "../src/bookworm.vala"
			g_object_ref_sink (_tmp96_);
#line 370 "../src/bookworm.vala"
			_g_object_unref0 (bookworm_app_bookworm_forward_page_image);
#line 370 "../src/bookworm.vala"
			bookworm_app_bookworm_forward_page_image = _tmp96_;
#line 2263 "bookworm.c"
		}
#line 271 "../src/bookworm.vala"
		_g_object_unref0 (_tmp22_);
#line 271 "../src/bookworm.vala"
		_g_object_unref0 (_tmp19_);
#line 271 "../src/bookworm.vala"
		_g_object_unref0 (_tmp16_);
#line 271 "../src/bookworm.vala"
		_g_object_unref0 (_tmp13_);
#line 271 "../src/bookworm.vala"
		_g_object_unref0 (_tmp10_);
#line 271 "../src/bookworm.vala"
		_g_object_unref0 (_tmp6_);
#line 271 "../src/bookworm.vala"
		_g_object_unref0 (_tmp3_);
#line 271 "../src/bookworm.vala"
		_g_object_unref0 (_tmp0_);
#line 2281 "bookworm.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp97_;
		const gchar* _tmp98_;
		gchar* _tmp99_;
		gchar* _tmp100_;
#line 271 "../src/bookworm.vala"
		e = _inner_error0_;
#line 271 "../src/bookworm.vala"
		_inner_error0_ = NULL;
#line 373 "../src/bookworm.vala"
		_tmp97_ = e;
#line 373 "../src/bookworm.vala"
		_tmp98_ = _tmp97_->message;
#line 373 "../src/bookworm.vala"
		_tmp99_ = g_strconcat ("Image could not be loaded. Error:", _tmp98_, NULL);
#line 373 "../src/bookworm.vala"
		_tmp100_ = _tmp99_;
#line 373 "../src/bookworm.vala"
		g_warning ("bookworm.vala:373: %s", _tmp100_);
#line 373 "../src/bookworm.vala"
		_g_free0 (_tmp100_);
#line 271 "../src/bookworm.vala"
		_g_error_free0 (e);
#line 2309 "bookworm.c"
	}
	__finally0:
#line 271 "../src/bookworm.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 271 "../src/bookworm.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 271 "../src/bookworm.vala"
		g_clear_error (&_inner_error0_);
#line 271 "../src/bookworm.vala"
		return;
#line 2320 "bookworm.c"
	}
#line 375 "../src/bookworm.vala"
	g_info ("bookworm.vala:375: [END] [FUNCTION:loadImages]");
#line 2324 "bookworm.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 2346 "bookworm.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 2350 "bookworm.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 2356 "bookworm.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 2360 "bookworm.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 2364 "bookworm.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 2372 "bookworm.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 2400 "bookworm.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 2409 "bookworm.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 2423 "bookworm.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 2432 "bookworm.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 2446 "bookworm.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 2455 "bookworm.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 2464 "bookworm.c"
}

void
bookworm_app_bookworm_loadCSSProvider (GtkCssProvider* cssProvider)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* dynamicCSSContent = NULL;
	gchar* _tmp4_;
	GdkScreen* _tmp60_;
	GError* _inner_error0_ = NULL;
#line 378 "../src/bookworm.vala"
	g_return_if_fail (cssProvider != NULL);
#line 379 "../src/bookworm.vala"
	_tmp0_ = gtk_css_provider_to_string (cssProvider);
#line 379 "../src/bookworm.vala"
	_tmp1_ = _tmp0_;
#line 379 "../src/bookworm.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:loadCSSProvider] cssProvider=", _tmp1_, NULL);
#line 379 "../src/bookworm.vala"
	_tmp3_ = _tmp2_;
#line 379 "../src/bookworm.vala"
	g_info ("bookworm.vala:379: %s", _tmp3_);
#line 379 "../src/bookworm.vala"
	_g_free0 (_tmp3_);
#line 379 "../src/bookworm.vala"
	_g_free0 (_tmp1_);
#line 380 "../src/bookworm.vala"
	_tmp4_ = g_strdup ("");
#line 380 "../src/bookworm.vala"
	dynamicCSSContent = _tmp4_;
#line 2498 "bookworm.c"
	{
		BookwormAppSettings* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar** _tmp8_;
		gchar** _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		gchar** _tmp21_;
		gint _tmp21__length1;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar** _tmp25_;
		gint _tmp25__length1;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar** _tmp29_;
		gint _tmp29__length1;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar** _tmp33_;
		gint _tmp33__length1;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar** _tmp37_;
		gint _tmp37__length1;
		const gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar** _tmp41_;
		gint _tmp41__length1;
		const gchar* _tmp42_;
		gchar* _tmp43_;
		const gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
#line 382 "../src/bookworm.vala"
		_tmp5_ = bookworm_app_bookworm_settings;
#line 382 "../src/bookworm.vala"
		_tmp6_ = bookworm_app_settings_get_list_of_profile_colors (_tmp5_);
#line 382 "../src/bookworm.vala"
		_tmp7_ = _tmp6_;
#line 382 "../src/bookworm.vala"
		_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, ",", 0);
#line 382 "../src/bookworm.vala"
		bookworm_app_bookworm_profileColorList = (_vala_array_free (bookworm_app_bookworm_profileColorList, bookworm_app_bookworm_profileColorList_length1, (GDestroyNotify) g_free), NULL);
#line 382 "../src/bookworm.vala"
		bookworm_app_bookworm_profileColorList = _tmp9_;
#line 382 "../src/bookworm.vala"
		bookworm_app_bookworm_profileColorList_length1 = _vala_array_length (_tmp8_);
#line 384 "../src/bookworm.vala"
		_tmp10_ = bookworm_app_bookworm_profileColorList;
#line 384 "../src/bookworm.vala"
		_tmp10__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 384 "../src/bookworm.vala"
		if (_tmp10__length1 < 9) {
#line 2563 "bookworm.c"
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar** _tmp20_;
#line 385 "../src/bookworm.vala"
			_tmp11_ = g_strdup ("#000000");
#line 385 "../src/bookworm.vala"
			_tmp12_ = g_strdup ("#fbfbfb");
#line 385 "../src/bookworm.vala"
			_tmp13_ = g_strdup ("#E8ED00");
#line 385 "../src/bookworm.vala"
			_tmp14_ = g_strdup ("#586e75");
#line 385 "../src/bookworm.vala"
			_tmp15_ = g_strdup ("#fdf6e3");
#line 385 "../src/bookworm.vala"
			_tmp16_ = g_strdup ("#87FF2B");
#line 385 "../src/bookworm.vala"
			_tmp17_ = g_strdup ("#93a1a1");
#line 385 "../src/bookworm.vala"
			_tmp18_ = g_strdup ("#002b36");
#line 385 "../src/bookworm.vala"
			_tmp19_ = g_strdup ("#3465A4");
#line 385 "../src/bookworm.vala"
			_tmp20_ = g_new0 (gchar*, 9 + 1);
#line 385 "../src/bookworm.vala"
			_tmp20_[0] = _tmp11_;
#line 385 "../src/bookworm.vala"
			_tmp20_[1] = _tmp12_;
#line 385 "../src/bookworm.vala"
			_tmp20_[2] = _tmp13_;
#line 385 "../src/bookworm.vala"
			_tmp20_[3] = _tmp14_;
#line 385 "../src/bookworm.vala"
			_tmp20_[4] = _tmp15_;
#line 385 "../src/bookworm.vala"
			_tmp20_[5] = _tmp16_;
#line 385 "../src/bookworm.vala"
			_tmp20_[6] = _tmp17_;
#line 385 "../src/bookworm.vala"
			_tmp20_[7] = _tmp18_;
#line 385 "../src/bookworm.vala"
			_tmp20_[8] = _tmp19_;
#line 385 "../src/bookworm.vala"
			bookworm_app_bookworm_profileColorList = (_vala_array_free (bookworm_app_bookworm_profileColorList, bookworm_app_bookworm_profileColorList_length1, (GDestroyNotify) g_free), NULL);
#line 385 "../src/bookworm.vala"
			bookworm_app_bookworm_profileColorList = _tmp20_;
#line 385 "../src/bookworm.vala"
			bookworm_app_bookworm_profileColorList_length1 = 9;
#line 2618 "bookworm.c"
		}
#line 387 "../src/bookworm.vala"
		_tmp21_ = bookworm_app_bookworm_profileColorList;
#line 387 "../src/bookworm.vala"
		_tmp21__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 387 "../src/bookworm.vala"
		_tmp22_ = _tmp21_[0];
#line 387 "../src/bookworm.vala"
		_tmp23_ = string_replace (BOOKWORM_APP_CONSTANTS_DYNAMIC_CSS_CONTENT, "<profile_1_color>", _tmp22_);
#line 387 "../src/bookworm.vala"
		_tmp24_ = _tmp23_;
#line 387 "../src/bookworm.vala"
		_tmp25_ = bookworm_app_bookworm_profileColorList;
#line 387 "../src/bookworm.vala"
		_tmp25__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 387 "../src/bookworm.vala"
		_tmp26_ = _tmp25_[1];
#line 387 "../src/bookworm.vala"
		_tmp27_ = string_replace (_tmp24_, "<profile_1_bgcolor>", _tmp26_);
#line 387 "../src/bookworm.vala"
		_tmp28_ = _tmp27_;
#line 387 "../src/bookworm.vala"
		_tmp29_ = bookworm_app_bookworm_profileColorList;
#line 387 "../src/bookworm.vala"
		_tmp29__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 387 "../src/bookworm.vala"
		_tmp30_ = _tmp29_[3];
#line 387 "../src/bookworm.vala"
		_tmp31_ = string_replace (_tmp28_, "<profile_2_color>", _tmp30_);
#line 387 "../src/bookworm.vala"
		_tmp32_ = _tmp31_;
#line 387 "../src/bookworm.vala"
		_tmp33_ = bookworm_app_bookworm_profileColorList;
#line 387 "../src/bookworm.vala"
		_tmp33__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 387 "../src/bookworm.vala"
		_tmp34_ = _tmp33_[4];
#line 387 "../src/bookworm.vala"
		_tmp35_ = string_replace (_tmp32_, "<profile_2_bgcolor>", _tmp34_);
#line 387 "../src/bookworm.vala"
		_tmp36_ = _tmp35_;
#line 387 "../src/bookworm.vala"
		_tmp37_ = bookworm_app_bookworm_profileColorList;
#line 387 "../src/bookworm.vala"
		_tmp37__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 387 "../src/bookworm.vala"
		_tmp38_ = _tmp37_[6];
#line 387 "../src/bookworm.vala"
		_tmp39_ = string_replace (_tmp36_, "<profile_3_color>", _tmp38_);
#line 387 "../src/bookworm.vala"
		_tmp40_ = _tmp39_;
#line 387 "../src/bookworm.vala"
		_tmp41_ = bookworm_app_bookworm_profileColorList;
#line 387 "../src/bookworm.vala"
		_tmp41__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 387 "../src/bookworm.vala"
		_tmp42_ = _tmp41_[7];
#line 387 "../src/bookworm.vala"
		_tmp43_ = string_replace (_tmp40_, "<profile_3_bgcolor>", _tmp42_);
#line 387 "../src/bookworm.vala"
		_g_free0 (dynamicCSSContent);
#line 387 "../src/bookworm.vala"
		dynamicCSSContent = _tmp43_;
#line 387 "../src/bookworm.vala"
		_g_free0 (_tmp40_);
#line 387 "../src/bookworm.vala"
		_g_free0 (_tmp36_);
#line 387 "../src/bookworm.vala"
		_g_free0 (_tmp32_);
#line 387 "../src/bookworm.vala"
		_g_free0 (_tmp28_);
#line 387 "../src/bookworm.vala"
		_g_free0 (_tmp24_);
#line 394 "../src/bookworm.vala"
		_tmp44_ = dynamicCSSContent;
#line 394 "../src/bookworm.vala"
		_tmp45_ = g_strconcat ("CSS for Profile Buttons:", _tmp44_, NULL);
#line 394 "../src/bookworm.vala"
		_tmp46_ = _tmp45_;
#line 394 "../src/bookworm.vala"
		g_debug ("bookworm.vala:394: %s", _tmp46_);
#line 394 "../src/bookworm.vala"
		_g_free0 (_tmp46_);
#line 395 "../src/bookworm.vala"
		_tmp47_ = dynamicCSSContent;
#line 395 "../src/bookworm.vala"
		_tmp48_ = dynamicCSSContent;
#line 395 "../src/bookworm.vala"
		_tmp49_ = strlen (_tmp48_);
#line 395 "../src/bookworm.vala"
		_tmp50_ = _tmp49_;
#line 395 "../src/bookworm.vala"
		gtk_css_provider_load_from_data (cssProvider, _tmp47_, (gssize) _tmp50_, &_inner_error0_);
#line 395 "../src/bookworm.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2714 "bookworm.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		GError* _tmp56_;
		const gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
#line 381 "../src/bookworm.vala"
		e = _inner_error0_;
#line 381 "../src/bookworm.vala"
		_inner_error0_ = NULL;
#line 397 "../src/bookworm.vala"
		_tmp51_ = dynamicCSSContent;
#line 397 "../src/bookworm.vala"
		_tmp52_ = g_strconcat ("Stylesheet could not be loaded from CSS Content[", _tmp51_, NULL);
#line 397 "../src/bookworm.vala"
		_tmp53_ = _tmp52_;
#line 397 "../src/bookworm.vala"
		_tmp54_ = g_strconcat (_tmp53_, "]. Error:", NULL);
#line 397 "../src/bookworm.vala"
		_tmp55_ = _tmp54_;
#line 397 "../src/bookworm.vala"
		_tmp56_ = e;
#line 397 "../src/bookworm.vala"
		_tmp57_ = _tmp56_->message;
#line 397 "../src/bookworm.vala"
		_tmp58_ = g_strconcat (_tmp55_, _tmp57_, NULL);
#line 397 "../src/bookworm.vala"
		_tmp59_ = _tmp58_;
#line 397 "../src/bookworm.vala"
		g_warning ("bookworm.vala:397: %s", _tmp59_);
#line 397 "../src/bookworm.vala"
		_g_free0 (_tmp59_);
#line 397 "../src/bookworm.vala"
		_g_free0 (_tmp55_);
#line 397 "../src/bookworm.vala"
		_g_free0 (_tmp53_);
#line 381 "../src/bookworm.vala"
		_g_error_free0 (e);
#line 2763 "bookworm.c"
	}
	__finally0:
#line 381 "../src/bookworm.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 381 "../src/bookworm.vala"
		_g_free0 (dynamicCSSContent);
#line 381 "../src/bookworm.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 381 "../src/bookworm.vala"
		g_clear_error (&_inner_error0_);
#line 381 "../src/bookworm.vala"
		return;
#line 2776 "bookworm.c"
	}
#line 399 "../src/bookworm.vala"
	_tmp60_ = gdk_screen_get_default ();
#line 399 "../src/bookworm.vala"
	gtk_style_context_add_provider_for_screen (_tmp60_, (GtkStyleProvider*) cssProvider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 404 "../src/bookworm.vala"
	g_info ("bookworm.vala:404: [END] [FUNCTION:loadCSSProvider]");
#line 378 "../src/bookworm.vala"
	_g_free0 (dynamicCSSContent);
#line 2786 "bookworm.c"
}

void
bookworm_app_bookworm_loadBookwormState (BookwormAppBookworm* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean _tmp15_ = FALSE;
	BookwormAppSettings* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	BookwormAppSettings* _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp32_;
	BookwormAppSettings* _tmp49_;
	gboolean _tmp50_;
	gboolean _tmp51_;
	BookwormAppSettings* _tmp53_;
	gint _tmp54_;
	gint _tmp55_;
	gchar* _tmp56_;
	const gchar* _tmp57_;
	BookwormAppSettings* _tmp58_;
	const gchar* _tmp59_;
	const gchar* _tmp60_;
	gchar* _tmp61_;
	GeeArrayList* _tmp62_;
#line 407 "../src/bookworm.vala"
	g_return_if_fail (self != NULL);
#line 408 "../src/bookworm.vala"
	g_info ("bookworm.vala:408: [START] [FUNCTION:loadBookwormState]");
#line 410 "../src/bookworm.vala"
	_tmp0_ = bookworm_app_utils_fileOperations ("CREATEDIR", BOOKWORM_APP_CONSTANTS_EBOOK_EXTRACTION_LOCATION, "", "");
#line 410 "../src/bookworm.vala"
	_tmp1_ = _tmp0_;
#line 410 "../src/bookworm.vala"
	_g_free0 (_tmp1_);
#line 413 "../src/bookworm.vala"
	_tmp2_ = bookworm_app_bookworm_bookworm_config_path;
#line 413 "../src/bookworm.vala"
	_tmp3_ = bookworm_app_utils_fileOperations ("CREATEDIR", _tmp2_, "", "");
#line 413 "../src/bookworm.vala"
	_tmp4_ = _tmp3_;
#line 413 "../src/bookworm.vala"
	_g_free0 (_tmp4_);
#line 416 "../src/bookworm.vala"
	_tmp5_ = bookworm_app_bookworm_bookworm_config_path;
#line 416 "../src/bookworm.vala"
	_tmp6_ = g_strconcat (_tmp5_, "/covers/", NULL);
#line 416 "../src/bookworm.vala"
	_tmp7_ = _tmp6_;
#line 416 "../src/bookworm.vala"
	_tmp8_ = bookworm_app_utils_fileOperations ("CREATEDIR", _tmp7_, "", "");
#line 416 "../src/bookworm.vala"
	_tmp9_ = _tmp8_;
#line 416 "../src/bookworm.vala"
	_g_free0 (_tmp9_);
#line 416 "../src/bookworm.vala"
	_g_free0 (_tmp7_);
#line 419 "../src/bookworm.vala"
	_tmp10_ = bookworm_app_bookworm_bookworm_config_path;
#line 419 "../src/bookworm.vala"
	_tmp11_ = g_strconcat (_tmp10_, "/books/", NULL);
#line 419 "../src/bookworm.vala"
	_tmp12_ = _tmp11_;
#line 419 "../src/bookworm.vala"
	_tmp13_ = bookworm_app_utils_fileOperations ("CREATEDIR", _tmp12_, "", "");
#line 419 "../src/bookworm.vala"
	_tmp14_ = _tmp13_;
#line 419 "../src/bookworm.vala"
	_g_free0 (_tmp14_);
#line 419 "../src/bookworm.vala"
	_g_free0 (_tmp12_);
#line 423 "../src/bookworm.vala"
	_tmp16_ = bookworm_app_bookworm_settings;
#line 423 "../src/bookworm.vala"
	_tmp17_ = bookworm_app_settings_get_pos_x (_tmp16_);
#line 423 "../src/bookworm.vala"
	_tmp18_ = _tmp17_;
#line 423 "../src/bookworm.vala"
	if (_tmp18_ == 0) {
#line 2881 "bookworm.c"
		BookwormAppSettings* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
#line 423 "../src/bookworm.vala"
		_tmp19_ = bookworm_app_bookworm_settings;
#line 423 "../src/bookworm.vala"
		_tmp20_ = bookworm_app_settings_get_pos_y (_tmp19_);
#line 423 "../src/bookworm.vala"
		_tmp21_ = _tmp20_;
#line 423 "../src/bookworm.vala"
		_tmp15_ = _tmp21_ == 0;
#line 2893 "bookworm.c"
	} else {
#line 423 "../src/bookworm.vala"
		_tmp15_ = FALSE;
#line 2897 "bookworm.c"
	}
#line 423 "../src/bookworm.vala"
	if (_tmp15_) {
#line 2901 "bookworm.c"
		GtkApplicationWindow* _tmp22_;
#line 424 "../src/bookworm.vala"
		_tmp22_ = bookworm_app_bookworm_window;
#line 424 "../src/bookworm.vala"
		gtk_window_set_position ((GtkWindow*) _tmp22_, GTK_WIN_POS_CENTER);
#line 2907 "bookworm.c"
	} else {
		GtkApplicationWindow* _tmp23_;
		BookwormAppSettings* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		BookwormAppSettings* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
#line 426 "../src/bookworm.vala"
		_tmp23_ = bookworm_app_bookworm_window;
#line 426 "../src/bookworm.vala"
		_tmp24_ = bookworm_app_bookworm_settings;
#line 426 "../src/bookworm.vala"
		_tmp25_ = bookworm_app_settings_get_pos_x (_tmp24_);
#line 426 "../src/bookworm.vala"
		_tmp26_ = _tmp25_;
#line 426 "../src/bookworm.vala"
		_tmp27_ = bookworm_app_bookworm_settings;
#line 426 "../src/bookworm.vala"
		_tmp28_ = bookworm_app_settings_get_pos_y (_tmp27_);
#line 426 "../src/bookworm.vala"
		_tmp29_ = _tmp28_;
#line 426 "../src/bookworm.vala"
		gtk_window_move ((GtkWindow*) _tmp23_, _tmp26_, _tmp29_);
#line 2932 "bookworm.c"
	}
#line 429 "../src/bookworm.vala"
	_tmp30_ = bookworm_app_bookworm_settings;
#line 429 "../src/bookworm.vala"
	_tmp31_ = bookworm_app_settings_get_window_is_maximized (_tmp30_);
#line 429 "../src/bookworm.vala"
	_tmp32_ = _tmp31_;
#line 429 "../src/bookworm.vala"
	if (_tmp32_) {
#line 2942 "bookworm.c"
		GtkApplicationWindow* _tmp33_;
#line 430 "../src/bookworm.vala"
		_tmp33_ = bookworm_app_bookworm_window;
#line 430 "../src/bookworm.vala"
		gtk_window_maximize ((GtkWindow*) _tmp33_);
#line 2948 "bookworm.c"
	} else {
		gboolean _tmp34_ = FALSE;
		BookwormAppSettings* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
#line 432 "../src/bookworm.vala"
		_tmp35_ = bookworm_app_bookworm_settings;
#line 432 "../src/bookworm.vala"
		_tmp36_ = bookworm_app_settings_get_window_width (_tmp35_);
#line 432 "../src/bookworm.vala"
		_tmp37_ = _tmp36_;
#line 432 "../src/bookworm.vala"
		if (_tmp37_ > 0) {
#line 2962 "bookworm.c"
			BookwormAppSettings* _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
#line 432 "../src/bookworm.vala"
			_tmp38_ = bookworm_app_bookworm_settings;
#line 432 "../src/bookworm.vala"
			_tmp39_ = bookworm_app_settings_get_window_height (_tmp38_);
#line 432 "../src/bookworm.vala"
			_tmp40_ = _tmp39_;
#line 432 "../src/bookworm.vala"
			_tmp34_ = _tmp40_ > 0;
#line 2974 "bookworm.c"
		} else {
#line 432 "../src/bookworm.vala"
			_tmp34_ = FALSE;
#line 2978 "bookworm.c"
		}
#line 432 "../src/bookworm.vala"
		if (_tmp34_) {
#line 2982 "bookworm.c"
			GtkApplicationWindow* _tmp41_;
			BookwormAppSettings* _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			BookwormAppSettings* _tmp45_;
			gint _tmp46_;
			gint _tmp47_;
#line 433 "../src/bookworm.vala"
			_tmp41_ = bookworm_app_bookworm_window;
#line 433 "../src/bookworm.vala"
			_tmp42_ = bookworm_app_bookworm_settings;
#line 433 "../src/bookworm.vala"
			_tmp43_ = bookworm_app_settings_get_window_width (_tmp42_);
#line 433 "../src/bookworm.vala"
			_tmp44_ = _tmp43_;
#line 433 "../src/bookworm.vala"
			_tmp45_ = bookworm_app_bookworm_settings;
#line 433 "../src/bookworm.vala"
			_tmp46_ = bookworm_app_settings_get_window_height (_tmp45_);
#line 433 "../src/bookworm.vala"
			_tmp47_ = _tmp46_;
#line 433 "../src/bookworm.vala"
			gtk_window_set_default_size ((GtkWindow*) _tmp41_, _tmp44_, _tmp47_);
#line 3006 "bookworm.c"
		} else {
			GtkApplicationWindow* _tmp48_;
#line 435 "../src/bookworm.vala"
			_tmp48_ = bookworm_app_bookworm_window;
#line 435 "../src/bookworm.vala"
			gtk_window_set_default_size ((GtkWindow*) _tmp48_, 1200, 700);
#line 3013 "bookworm.c"
		}
	}
#line 439 "../src/bookworm.vala"
	_tmp49_ = bookworm_app_bookworm_settings;
#line 439 "../src/bookworm.vala"
	_tmp50_ = bookworm_app_settings_get_is_dark_theme_enabled (_tmp49_);
#line 439 "../src/bookworm.vala"
	_tmp51_ = _tmp50_;
#line 439 "../src/bookworm.vala"
	if (_tmp51_) {
#line 3024 "bookworm.c"
		GtkSettings* _tmp52_;
#line 440 "../src/bookworm.vala"
		_tmp52_ = gtk_settings_get_default ();
#line 440 "../src/bookworm.vala"
		g_object_set (_tmp52_, "gtk-application-prefer-dark-theme", TRUE, NULL);
#line 3030 "bookworm.c"
	}
#line 443 "../src/bookworm.vala"
	_tmp53_ = bookworm_app_bookworm_settings;
#line 443 "../src/bookworm.vala"
	_tmp54_ = bookworm_app_settings_get_library_page_items (_tmp53_);
#line 443 "../src/bookworm.vala"
	_tmp55_ = _tmp54_;
#line 443 "../src/bookworm.vala"
	_tmp56_ = g_strdup_printf ("%i", _tmp55_);
#line 443 "../src/bookworm.vala"
	_g_free0 (bookworm_app_bookworm_no_of_books_per_page);
#line 443 "../src/bookworm.vala"
	bookworm_app_bookworm_no_of_books_per_page = _tmp56_;
#line 446 "../src/bookworm.vala"
	_tmp57_ = bookworm_app_bookworm_bookworm_config_path;
#line 446 "../src/bookworm.vala"
	bookworm_app_db_initializeBookWormDB (_tmp57_);
#line 448 "../src/bookworm.vala"
	_tmp58_ = bookworm_app_bookworm_settings;
#line 448 "../src/bookworm.vala"
	_tmp59_ = bookworm_app_settings_get_library_view_mode (_tmp58_);
#line 448 "../src/bookworm.vala"
	_tmp60_ = _tmp59_;
#line 448 "../src/bookworm.vala"
	_tmp61_ = g_strdup (_tmp60_);
#line 448 "../src/bookworm.vala"
	_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 448 "../src/bookworm.vala"
	bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp61_;
#line 450 "../src/bookworm.vala"
	_tmp62_ = bookworm_app_bookworm_paginationlist;
#line 450 "../src/bookworm.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp62_, "");
#line 451 "../src/bookworm.vala"
	bookworm_app_bookworm_current_page_counter = 0;
#line 452 "../src/bookworm.vala"
	bookworm_app_library_paginateLibrary ("", "PAGINATED_SEARCH");
#line 454 "../src/bookworm.vala"
	bookworm_app_app_window_handleLibraryPageButtons ("", FALSE);
#line 456 "../src/bookworm.vala"
	g_info ("bookworm.vala:456: [END] [FUNCTION:loadBookwormState]");
#line 3072 "bookworm.c"
}

static void
bookworm_app_bookworm_closeBookWorm_data_free (gpointer _data)
{
	bookworm_app_bookworm_closeBookWormData* _data_;
	_data_ = _data;
#line 25 "../src/bookworm.vala"
	_g_object_unref0 (_data_->self);
#line 25 "../src/bookworm.vala"
	g_slice_free (bookworm_app_bookworm_closeBookWormData, _data_);
#line 3084 "bookworm.c"
}

void
bookworm_app_bookworm_closeBookWorm (BookwormAppBookworm* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	bookworm_app_bookworm_closeBookWormData* _data_;
	BookwormAppBookworm* _tmp0_;
#line 25 "../src/bookworm.vala"
	g_return_if_fail (self != NULL);
#line 25 "../src/bookworm.vala"
	_data_ = g_slice_new0 (bookworm_app_bookworm_closeBookWormData);
#line 25 "../src/bookworm.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 25 "../src/bookworm.vala"
	g_task_set_task_data (_data_->_async_result, _data_, bookworm_app_bookworm_closeBookWorm_data_free);
#line 25 "../src/bookworm.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 25 "../src/bookworm.vala"
	_data_->self = _tmp0_;
#line 25 "../src/bookworm.vala"
	bookworm_app_bookworm_closeBookWorm_co (_data_);
#line 3108 "bookworm.c"
}

void
bookworm_app_bookworm_closeBookWorm_finish (BookwormAppBookworm* self,
                                            GAsyncResult* _res_)
{
	bookworm_app_bookworm_closeBookWormData* _data_;
#line 25 "../src/bookworm.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 3118 "bookworm.c"
}

static gboolean
_bookworm_app_bookworm_closeBookWorm_co_gsource_func (gpointer self)
{
	gboolean result;
	result = bookworm_app_bookworm_closeBookWorm_co (self);
#line 472 "../src/bookworm.vala"
	return result;
#line 3128 "bookworm.c"
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1185 "glib-2.0.vapi"
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1185 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1187 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1187 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 3152 "bookworm.c"
		gchar* _tmp2_;
#line 1188 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1188 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1188 "glib-2.0.vapi"
		return result;
#line 3160 "bookworm.c"
	} else {
#line 1190 "glib-2.0.vapi"
		result = -1;
#line 1190 "glib-2.0.vapi"
		return result;
#line 3166 "bookworm.c"
	}
}

static gboolean
bookworm_app_bookworm_closeBookWorm_co (bookworm_app_bookworm_closeBookWormData* _data_)
{
#line 459 "../src/bookworm.vala"
	switch (_data_->_state_) {
#line 459 "../src/bookworm.vala"
		case 0:
#line 3177 "bookworm.c"
		goto _state_0;
#line 459 "../src/bookworm.vala"
		case 1:
#line 3181 "bookworm.c"
		goto _state_1;
		default:
#line 459 "../src/bookworm.vala"
		g_assert_not_reached ();
#line 3186 "bookworm.c"
	}
	_state_0:
#line 460 "../src/bookworm.vala"
	g_info ("bookworm.vala:460: [START] [FUNCTION:closeBookWorm]");
#line 462 "../src/bookworm.vala"
	_data_->_tmp0_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 462 "../src/bookworm.vala"
	_data_->_tmp1_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[1];
#line 462 "../src/bookworm.vala"
	if (g_strcmp0 (_data_->_tmp0_, _data_->_tmp1_) == 0) {
#line 464 "../src/bookworm.vala"
		_data_->_tmp2_ = bookworm_app_bookworm_libraryViewMap;
#line 464 "../src/bookworm.vala"
		_data_->_tmp3_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 464 "../src/bookworm.vala"
		_data_->_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp2_, _data_->_tmp3_);
#line 464 "../src/bookworm.vala"
		_data_->_tmp5_ = (BookwormAppBook*) _data_->_tmp4_;
#line 464 "../src/bookworm.vala"
		bookworm_app_book_setBookScrollPos (_data_->_tmp5_, bookworm_app_content_handler_getScrollPos ());
#line 464 "../src/bookworm.vala"
		_bookworm_app_book_unref0 (_data_->_tmp5_);
#line 466 "../src/bookworm.vala"
		_data_->_tmp6_ = bookworm_app_bookworm_settings;
#line 466 "../src/bookworm.vala"
		_data_->_tmp7_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 466 "../src/bookworm.vala"
		bookworm_app_settings_set_book_being_read (_data_->_tmp6_, _data_->_tmp7_);
#line 3215 "bookworm.c"
	} else {
#line 469 "../src/bookworm.vala"
		_data_->_tmp8_ = bookworm_app_bookworm_settings;
#line 469 "../src/bookworm.vala"
		bookworm_app_settings_set_book_being_read (_data_->_tmp8_, "");
#line 3221 "bookworm.c"
	}
#line 472 "../src/bookworm.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _bookworm_app_bookworm_closeBookWorm_co_gsource_func, _data_, NULL);
#line 473 "../src/bookworm.vala"
	_data_->_state_ = 1;
#line 473 "../src/bookworm.vala"
	return FALSE;
#line 3229 "bookworm.c"
	_state_1:
	;
	{
#line 475 "../src/bookworm.vala"
		_data_->_tmp9_ = bookworm_app_bookworm_libraryViewMap;
#line 475 "../src/bookworm.vala"
		_data_->_tmp10_ = gee_abstract_map_get_values ((GeeAbstractMap*) _data_->_tmp9_);
#line 475 "../src/bookworm.vala"
		_data_->_tmp11_ = _data_->_tmp10_;
#line 475 "../src/bookworm.vala"
		_data_->_tmp12_ = _data_->_tmp11_;
#line 475 "../src/bookworm.vala"
		_data_->_tmp13_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp12_);
#line 475 "../src/bookworm.vala"
		_data_->_tmp14_ = _data_->_tmp13_;
#line 475 "../src/bookworm.vala"
		_g_object_unref0 (_data_->_tmp12_);
#line 475 "../src/bookworm.vala"
		_data_->_book_it = _data_->_tmp14_;
#line 475 "../src/bookworm.vala"
		while (TRUE) {
#line 475 "../src/bookworm.vala"
			_data_->_tmp15_ = _data_->_book_it;
#line 475 "../src/bookworm.vala"
			if (!gee_iterator_next (_data_->_tmp15_)) {
#line 475 "../src/bookworm.vala"
				break;
#line 3257 "bookworm.c"
			}
#line 475 "../src/bookworm.vala"
			_data_->_tmp16_ = _data_->_book_it;
#line 475 "../src/bookworm.vala"
			_data_->_tmp17_ = gee_iterator_get (_data_->_tmp16_);
#line 475 "../src/bookworm.vala"
			_data_->book = (BookwormAppBook*) _data_->_tmp17_;
#line 476 "../src/bookworm.vala"
			_data_->_tmp18_ = _data_->book;
#line 476 "../src/bookworm.vala"
			if (bookworm_app_book_getWasBookOpened (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp18_, BOOKWORM_APP_TYPE_BOOK, BookwormAppBook))) {
#line 477 "../src/bookworm.vala"
				_data_->_tmp19_ = _data_->book;
#line 477 "../src/bookworm.vala"
				bookworm_app_db_updateBookToDataBase (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp19_, BOOKWORM_APP_TYPE_BOOK, BookwormAppBook));
#line 478 "../src/bookworm.vala"
				g_debug ("bookworm.vala:478: Completed saving the book data into DB");
#line 3275 "bookworm.c"
			}
#line 475 "../src/bookworm.vala"
			_bookworm_app_book_unref0 (_data_->book);
#line 3279 "bookworm.c"
		}
#line 475 "../src/bookworm.vala"
		_g_object_unref0 (_data_->_book_it);
#line 3283 "bookworm.c"
	}
#line 482 "../src/bookworm.vala"
	_data_->_tmp20_ = bookworm_app_utils_execute_sync_command ("ps -ef");
#line 482 "../src/bookworm.vala"
	_data_->checkBackgroundTask = _data_->_tmp20_;
#line 483 "../src/bookworm.vala"
	_data_->_tmp21_ = _data_->checkBackgroundTask;
#line 483 "../src/bookworm.vala"
	if (string_index_of (_data_->_tmp21_, "bookworm --discover", 0) == -1) {
#line 484 "../src/bookworm.vala"
		_data_->_tmp22_ = g_strdup ("com.github.babluboy.bookworm");
#line 484 "../src/bookworm.vala"
		_data_->_tmp23_ = g_strdup ("--discover");
#line 484 "../src/bookworm.vala"
		_data_->_tmp24_ = g_strdup ("&");
#line 484 "../src/bookworm.vala"
		_data_->_tmp25_ = g_new0 (gchar*, 3 + 1);
#line 484 "../src/bookworm.vala"
		_data_->_tmp25_[0] = _data_->_tmp22_;
#line 484 "../src/bookworm.vala"
		_data_->_tmp25_[1] = _data_->_tmp23_;
#line 484 "../src/bookworm.vala"
		_data_->_tmp25_[2] = _data_->_tmp24_;
#line 484 "../src/bookworm.vala"
		_data_->_tmp26_ = _data_->_tmp25_;
#line 484 "../src/bookworm.vala"
		_data_->_tmp26__length1 = 3;
#line 484 "../src/bookworm.vala"
		bookworm_app_utils_execute_async_multiarg_command_pipes (_data_->_tmp26_, (gint) 3);
#line 484 "../src/bookworm.vala"
		_data_->_tmp26_ = (_vala_array_free (_data_->_tmp26_, _data_->_tmp26__length1, (GDestroyNotify) g_free), NULL);
#line 3315 "bookworm.c"
	} else {
#line 486 "../src/bookworm.vala"
		g_debug ("bookworm.vala:486: Bookworm discover process already running....");
#line 3319 "bookworm.c"
	}
#line 488 "../src/bookworm.vala"
	g_info ("bookworm.vala:488: [END] [FUNCTION:closeBookWorm]");
#line 459 "../src/bookworm.vala"
	_g_free0 (_data_->checkBackgroundTask);
#line 459 "../src/bookworm.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 459 "../src/bookworm.vala"
	if (_data_->_state_ != 0) {
#line 459 "../src/bookworm.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 459 "../src/bookworm.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3333 "bookworm.c"
		}
	}
#line 459 "../src/bookworm.vala"
	g_object_unref (_data_->_async_result);
#line 459 "../src/bookworm.vala"
	return FALSE;
#line 3340 "bookworm.c"
}

void
bookworm_app_bookworm_saveWindowState (BookwormAppBookworm* self)
{
	gint width = 0;
	gint height = 0;
	gint x = 0;
	gint y = 0;
	GtkApplicationWindow* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkApplicationWindow* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	BookwormAppSettings* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gboolean _tmp15_ = FALSE;
	BookwormAppSettings* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GtkApplicationWindow* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	BookwormAppSettings* _tmp29_;
	WebKitWebView* _tmp30_;
#line 491 "../src/bookworm.vala"
	g_return_if_fail (self != NULL);
#line 496 "../src/bookworm.vala"
	_tmp0_ = bookworm_app_bookworm_window;
#line 496 "../src/bookworm.vala"
	gtk_window_get_size ((GtkWindow*) _tmp0_, &_tmp1_, &_tmp2_);
#line 496 "../src/bookworm.vala"
	width = _tmp1_;
#line 496 "../src/bookworm.vala"
	height = _tmp2_;
#line 497 "../src/bookworm.vala"
	_tmp3_ = bookworm_app_bookworm_window;
#line 497 "../src/bookworm.vala"
	gtk_window_get_position ((GtkWindow*) _tmp3_, &_tmp4_, &_tmp5_);
#line 497 "../src/bookworm.vala"
	x = _tmp4_;
#line 497 "../src/bookworm.vala"
	y = _tmp5_;
#line 498 "../src/bookworm.vala"
	_tmp7_ = bookworm_app_bookworm_settings;
#line 498 "../src/bookworm.vala"
	_tmp8_ = bookworm_app_settings_get_pos_x (_tmp7_);
#line 498 "../src/bookworm.vala"
	_tmp9_ = _tmp8_;
#line 498 "../src/bookworm.vala"
	if (_tmp9_ != x) {
#line 498 "../src/bookworm.vala"
		_tmp6_ = TRUE;
#line 3397 "bookworm.c"
	} else {
		BookwormAppSettings* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
#line 498 "../src/bookworm.vala"
		_tmp10_ = bookworm_app_bookworm_settings;
#line 498 "../src/bookworm.vala"
		_tmp11_ = bookworm_app_settings_get_pos_y (_tmp10_);
#line 498 "../src/bookworm.vala"
		_tmp12_ = _tmp11_;
#line 498 "../src/bookworm.vala"
		_tmp6_ = _tmp12_ != y;
#line 3410 "bookworm.c"
	}
#line 498 "../src/bookworm.vala"
	if (_tmp6_) {
#line 3414 "bookworm.c"
		BookwormAppSettings* _tmp13_;
		BookwormAppSettings* _tmp14_;
#line 499 "../src/bookworm.vala"
		_tmp13_ = bookworm_app_bookworm_settings;
#line 499 "../src/bookworm.vala"
		bookworm_app_settings_set_pos_x (_tmp13_, x);
#line 500 "../src/bookworm.vala"
		_tmp14_ = bookworm_app_bookworm_settings;
#line 500 "../src/bookworm.vala"
		bookworm_app_settings_set_pos_y (_tmp14_, y);
#line 3425 "bookworm.c"
	}
#line 502 "../src/bookworm.vala"
	_tmp16_ = bookworm_app_bookworm_settings;
#line 502 "../src/bookworm.vala"
	_tmp17_ = bookworm_app_settings_get_window_width (_tmp16_);
#line 502 "../src/bookworm.vala"
	_tmp18_ = _tmp17_;
#line 502 "../src/bookworm.vala"
	if (_tmp18_ != width) {
#line 502 "../src/bookworm.vala"
		_tmp15_ = TRUE;
#line 3437 "bookworm.c"
	} else {
		BookwormAppSettings* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
#line 502 "../src/bookworm.vala"
		_tmp19_ = bookworm_app_bookworm_settings;
#line 502 "../src/bookworm.vala"
		_tmp20_ = bookworm_app_settings_get_window_height (_tmp19_);
#line 502 "../src/bookworm.vala"
		_tmp21_ = _tmp20_;
#line 502 "../src/bookworm.vala"
		_tmp15_ = _tmp21_ != height;
#line 3450 "bookworm.c"
	}
#line 502 "../src/bookworm.vala"
	if (_tmp15_) {
#line 3454 "bookworm.c"
		BookwormAppSettings* _tmp22_;
		BookwormAppSettings* _tmp23_;
#line 503 "../src/bookworm.vala"
		_tmp22_ = bookworm_app_bookworm_settings;
#line 503 "../src/bookworm.vala"
		bookworm_app_settings_set_window_width (_tmp22_, width);
#line 504 "../src/bookworm.vala"
		_tmp23_ = bookworm_app_bookworm_settings;
#line 504 "../src/bookworm.vala"
		bookworm_app_settings_set_window_height (_tmp23_, height);
#line 3465 "bookworm.c"
	}
#line 506 "../src/bookworm.vala"
	_tmp24_ = bookworm_app_bookworm_window;
#line 506 "../src/bookworm.vala"
	g_object_get ((GtkWindow*) _tmp24_, "is-maximized", &_tmp25_, NULL);
#line 506 "../src/bookworm.vala"
	_tmp26_ = _tmp25_;
#line 506 "../src/bookworm.vala"
	if (_tmp26_ == TRUE) {
#line 3475 "bookworm.c"
		BookwormAppSettings* _tmp27_;
#line 507 "../src/bookworm.vala"
		_tmp27_ = bookworm_app_bookworm_settings;
#line 507 "../src/bookworm.vala"
		bookworm_app_settings_set_window_is_maximized (_tmp27_, TRUE);
#line 3481 "bookworm.c"
	} else {
		BookwormAppSettings* _tmp28_;
#line 509 "../src/bookworm.vala"
		_tmp28_ = bookworm_app_bookworm_settings;
#line 509 "../src/bookworm.vala"
		bookworm_app_settings_set_window_is_maximized (_tmp28_, FALSE);
#line 3488 "bookworm.c"
	}
#line 511 "../src/bookworm.vala"
	_tmp29_ = bookworm_app_bookworm_settings;
#line 511 "../src/bookworm.vala"
	_tmp30_ = bookworm_app_app_window_aWebView;
#line 511 "../src/bookworm.vala"
	bookworm_app_settings_set_zoom_level (_tmp29_, webkit_web_view_get_zoom_level (_tmp30_));
#line 3496 "bookworm.c"
}

static gpointer
_bookworm_app_book_ref0 (gpointer self)
{
#line 519 "../src/bookworm.vala"
	return self ? bookworm_app_book_ref (self) : NULL;
#line 3504 "bookworm.c"
}

void
bookworm_app_bookworm_readSelectedBook (BookwormAppBook* aBook)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gboolean _tmp8_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GeeArrayList* _tmp15_;
	GeeArrayList* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	BookwormAppSettings* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	gchar* _tmp104_;
	gchar* _tmp105_;
	gchar* _tmp106_;
	gchar* _tmp107_;
#line 514 "../src/bookworm.vala"
	g_return_if_fail (aBook != NULL);
#line 515 "../src/bookworm.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 515 "../src/bookworm.vala"
	_tmp1_ = _tmp0_;
#line 515 "../src/bookworm.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:readSelectedBook] book.location=", _tmp1_, NULL);
#line 515 "../src/bookworm.vala"
	_tmp3_ = _tmp2_;
#line 515 "../src/bookworm.vala"
	g_info ("bookworm.vala:515: %s", _tmp3_);
#line 515 "../src/bookworm.vala"
	_g_free0 (_tmp3_);
#line 515 "../src/bookworm.vala"
	_g_free0 (_tmp1_);
#line 517 "../src/bookworm.vala"
	_tmp4_ = bookworm_app_book_getBookContentList (aBook);
#line 517 "../src/bookworm.vala"
	_tmp5_ = _tmp4_;
#line 517 "../src/bookworm.vala"
	_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
#line 517 "../src/bookworm.vala"
	_tmp7_ = _tmp6_;
#line 517 "../src/bookworm.vala"
	_tmp8_ = _tmp7_ < 1;
#line 517 "../src/bookworm.vala"
	_g_object_unref0 (_tmp5_);
#line 517 "../src/bookworm.vala"
	if (_tmp8_) {
#line 3570 "bookworm.c"
		BookwormAppBook* _tmp9_;
		BookwormAppBook* _tmp10_;
#line 519 "../src/bookworm.vala"
		_tmp9_ = _bookworm_app_book_ref0 (aBook);
#line 519 "../src/bookworm.vala"
		_tmp10_ = bookworm_app_db_getBookMetaDataFromDB (_tmp9_);
#line 519 "../src/bookworm.vala"
		_bookworm_app_book_unref0 (aBook);
#line 519 "../src/bookworm.vala"
		aBook = _tmp10_;
#line 3581 "bookworm.c"
	}
#line 521 "../src/bookworm.vala"
	_tmp11_ = bookworm_app_book_to_string (aBook);
#line 521 "../src/bookworm.vala"
	_tmp12_ = _tmp11_;
#line 521 "../src/bookworm.vala"
	_tmp13_ = g_strconcat ("Book details before attempting to open book for reading:", _tmp12_, NULL);
#line 521 "../src/bookworm.vala"
	_tmp14_ = _tmp13_;
#line 521 "../src/bookworm.vala"
	g_debug ("bookworm.vala:521: %s", _tmp14_);
#line 521 "../src/bookworm.vala"
	_g_free0 (_tmp14_);
#line 521 "../src/bookworm.vala"
	_g_free0 (_tmp12_);
#line 523 "../src/bookworm.vala"
	if (bookworm_app_book_getBookPageNumber (aBook) == -1) {
#line 524 "../src/bookworm.vala"
		bookworm_app_book_setBookPageNumber (aBook, 0);
#line 3601 "bookworm.c"
	} else {
#line 528 "../src/bookworm.vala"
		bookworm_app_bookworm_isPageScrollRequired = TRUE;
#line 3605 "bookworm.c"
	}
#line 531 "../src/bookworm.vala"
	_tmp15_ = bookworm_app_book_getBookContentList (aBook);
#line 531 "../src/bookworm.vala"
	_tmp16_ = _tmp15_;
#line 531 "../src/bookworm.vala"
	_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
#line 531 "../src/bookworm.vala"
	_tmp18_ = _tmp17_;
#line 531 "../src/bookworm.vala"
	_tmp19_ = bookworm_app_book_getBookPageNumber (aBook) >= _tmp18_;
#line 531 "../src/bookworm.vala"
	_g_object_unref0 (_tmp16_);
#line 531 "../src/bookworm.vala"
	if (_tmp19_) {
#line 3621 "bookworm.c"
		GeeArrayList* _tmp20_;
		GeeArrayList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
#line 532 "../src/bookworm.vala"
		_tmp20_ = bookworm_app_book_getBookContentList (aBook);
#line 532 "../src/bookworm.vala"
		_tmp21_ = _tmp20_;
#line 532 "../src/bookworm.vala"
		_tmp22_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp21_);
#line 532 "../src/bookworm.vala"
		_tmp23_ = _tmp22_;
#line 532 "../src/bookworm.vala"
		bookworm_app_book_setBookPageNumber (aBook, _tmp23_ - 1);
#line 532 "../src/bookworm.vala"
		_g_object_unref0 (_tmp21_);
#line 3638 "bookworm.c"
	}
#line 535 "../src/bookworm.vala"
	_tmp29_ = bookworm_app_bookworm_settings;
#line 535 "../src/bookworm.vala"
	_tmp30_ = bookworm_app_settings_get_is_local_storage_enabled (_tmp29_);
#line 535 "../src/bookworm.vala"
	_tmp31_ = _tmp30_;
#line 535 "../src/bookworm.vala"
	if (_tmp31_) {
#line 3648 "bookworm.c"
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
#line 536 "../src/bookworm.vala"
		_tmp32_ = bookworm_app_book_getBookExtractionLocation (aBook);
#line 536 "../src/bookworm.vala"
		_tmp33_ = _tmp32_;
#line 536 "../src/bookworm.vala"
		_tmp34_ = bookworm_app_utils_fileOperations ("DIR_EXISTS", _tmp33_, "", "");
#line 536 "../src/bookworm.vala"
		_tmp35_ = _tmp34_;
#line 536 "../src/bookworm.vala"
		_tmp28_ = g_strcmp0 ("true", _tmp35_) == 0;
#line 536 "../src/bookworm.vala"
		_g_free0 (_tmp35_);
#line 536 "../src/bookworm.vala"
		_g_free0 (_tmp33_);
#line 3667 "bookworm.c"
	} else {
#line 535 "../src/bookworm.vala"
		_tmp28_ = FALSE;
#line 3671 "bookworm.c"
	}
#line 535 "../src/bookworm.vala"
	if (_tmp28_) {
#line 3675 "bookworm.c"
		GeeArrayList* _tmp36_;
		GeeArrayList* _tmp37_;
#line 539 "../src/bookworm.vala"
		_tmp36_ = bookworm_app_book_getBookContentList (aBook);
#line 539 "../src/bookworm.vala"
		_tmp37_ = _tmp36_;
#line 539 "../src/bookworm.vala"
		_tmp27_ = _tmp37_ != NULL;
#line 539 "../src/bookworm.vala"
		_g_object_unref0 (_tmp37_);
#line 3686 "bookworm.c"
	} else {
#line 535 "../src/bookworm.vala"
		_tmp27_ = FALSE;
#line 3690 "bookworm.c"
	}
#line 535 "../src/bookworm.vala"
	if (_tmp27_) {
#line 3694 "bookworm.c"
		GeeArrayList* _tmp38_;
		GeeArrayList* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
#line 540 "../src/bookworm.vala"
		_tmp38_ = bookworm_app_book_getBookContentList (aBook);
#line 540 "../src/bookworm.vala"
		_tmp39_ = _tmp38_;
#line 540 "../src/bookworm.vala"
		_tmp40_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp39_);
#line 540 "../src/bookworm.vala"
		_tmp41_ = _tmp40_;
#line 540 "../src/bookworm.vala"
		_tmp26_ = _tmp41_ > 0;
#line 540 "../src/bookworm.vala"
		_g_object_unref0 (_tmp39_);
#line 3711 "bookworm.c"
	} else {
#line 535 "../src/bookworm.vala"
		_tmp26_ = FALSE;
#line 3715 "bookworm.c"
	}
#line 535 "../src/bookworm.vala"
	if (_tmp26_) {
#line 3719 "bookworm.c"
		GeeArrayList* _tmp42_;
		GeeArrayList* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
#line 541 "../src/bookworm.vala"
		_tmp42_ = bookworm_app_book_getBookContentList (aBook);
#line 541 "../src/bookworm.vala"
		_tmp43_ = _tmp42_;
#line 541 "../src/bookworm.vala"
		_tmp44_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp43_);
#line 541 "../src/bookworm.vala"
		_tmp45_ = _tmp44_;
#line 541 "../src/bookworm.vala"
		_tmp25_ = _tmp45_ >= bookworm_app_book_getBookPageNumber (aBook);
#line 541 "../src/bookworm.vala"
		_g_object_unref0 (_tmp43_);
#line 3736 "bookworm.c"
	} else {
#line 535 "../src/bookworm.vala"
		_tmp25_ = FALSE;
#line 3740 "bookworm.c"
	}
#line 535 "../src/bookworm.vala"
	if (_tmp25_) {
#line 3744 "bookworm.c"
		GeeArrayList* _tmp46_;
		GeeArrayList* _tmp47_;
		gpointer _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
#line 542 "../src/bookworm.vala"
		_tmp46_ = bookworm_app_book_getBookContentList (aBook);
#line 542 "../src/bookworm.vala"
		_tmp47_ = _tmp46_;
#line 542 "../src/bookworm.vala"
		_tmp48_ = gee_abstract_list_get ((GeeAbstractList*) _tmp47_, bookworm_app_book_getBookPageNumber (aBook));
#line 542 "../src/bookworm.vala"
		_tmp49_ = (gchar*) _tmp48_;
#line 542 "../src/bookworm.vala"
		_tmp50_ = bookworm_app_utils_decodeHTMLChars (_tmp49_);
#line 542 "../src/bookworm.vala"
		_tmp51_ = _tmp50_;
#line 542 "../src/bookworm.vala"
		_tmp52_ = bookworm_app_utils_fileOperations ("EXISTS", _tmp51_, "", "");
#line 542 "../src/bookworm.vala"
		_tmp53_ = _tmp52_;
#line 542 "../src/bookworm.vala"
		_tmp24_ = g_strcmp0 ("true", _tmp53_) == 0;
#line 542 "../src/bookworm.vala"
		_g_free0 (_tmp53_);
#line 542 "../src/bookworm.vala"
		_g_free0 (_tmp51_);
#line 542 "../src/bookworm.vala"
		_g_free0 (_tmp49_);
#line 542 "../src/bookworm.vala"
		_g_object_unref0 (_tmp47_);
#line 3779 "bookworm.c"
	} else {
#line 535 "../src/bookworm.vala"
		_tmp24_ = FALSE;
#line 3783 "bookworm.c"
	}
#line 535 "../src/bookworm.vala"
	if (_tmp24_) {
#line 3787 "bookworm.c"
		gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
#line 552 "../src/bookworm.vala"
		bookworm_app_book_setIsBookParsed (aBook, TRUE);
#line 553 "../src/bookworm.vala"
		_tmp54_ = bookworm_app_book_getBookExtractionLocation (aBook);
#line 553 "../src/bookworm.vala"
		_tmp55_ = _tmp54_;
#line 553 "../src/bookworm.vala"
		_tmp56_ = g_strconcat ("Book has already been extracted and the extracted contents exist at:", _tmp55_, NULL);
#line 553 "../src/bookworm.vala"
		_tmp57_ = _tmp56_;
#line 553 "../src/bookworm.vala"
		g_debug ("bookworm.vala:553: %s", _tmp57_);
#line 553 "../src/bookworm.vala"
		_g_free0 (_tmp57_);
#line 553 "../src/bookworm.vala"
		_g_free0 (_tmp55_);
#line 3808 "bookworm.c"
	} else {
		gchar* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
		gchar* _tmp69_;
		BookwormAppBook* _tmp70_;
		BookwormAppBook* _tmp71_;
#line 556 "../src/bookworm.vala"
		_tmp58_ = bookworm_app_book_getBookExtractionLocation (aBook);
#line 556 "../src/bookworm.vala"
		_tmp59_ = _tmp58_;
#line 556 "../src/bookworm.vala"
		_tmp60_ = g_strconcat ("Extracted contents of the book was not found at expected location [", _tmp59_, NULL);
#line 556 "../src/bookworm.vala"
		_tmp61_ = _tmp60_;
#line 556 "../src/bookworm.vala"
		_tmp62_ = g_strconcat (_tmp61_, "], attempting to load book from original location [", NULL);
#line 556 "../src/bookworm.vala"
		_tmp63_ = _tmp62_;
#line 556 "../src/bookworm.vala"
		_tmp64_ = bookworm_app_book_getBookLocation (aBook);
#line 556 "../src/bookworm.vala"
		_tmp65_ = _tmp64_;
#line 556 "../src/bookworm.vala"
		_tmp66_ = g_strconcat (_tmp63_, _tmp65_, NULL);
#line 556 "../src/bookworm.vala"
		_tmp67_ = _tmp66_;
#line 556 "../src/bookworm.vala"
		_tmp68_ = g_strconcat (_tmp67_, "]", NULL);
#line 556 "../src/bookworm.vala"
		_tmp69_ = _tmp68_;
#line 556 "../src/bookworm.vala"
		g_debug ("bookworm.vala:556: %s", _tmp69_);
#line 556 "../src/bookworm.vala"
		_g_free0 (_tmp69_);
#line 556 "../src/bookworm.vala"
		_g_free0 (_tmp67_);
#line 556 "../src/bookworm.vala"
		_g_free0 (_tmp65_);
#line 556 "../src/bookworm.vala"
		_g_free0 (_tmp63_);
#line 556 "../src/bookworm.vala"
		_g_free0 (_tmp61_);
#line 556 "../src/bookworm.vala"
		_g_free0 (_tmp59_);
#line 561 "../src/bookworm.vala"
		_tmp70_ = _bookworm_app_book_ref0 (aBook);
#line 561 "../src/bookworm.vala"
		_tmp71_ = bookworm_app_bookworm_genericParser (_tmp70_);
#line 561 "../src/bookworm.vala"
		_bookworm_app_book_unref0 (aBook);
#line 561 "../src/bookworm.vala"
		aBook = _tmp71_;
#line 563 "../src/bookworm.vala"
		if (!bookworm_app_book_getIsBookParsed (aBook)) {
#line 564 "../src/bookworm.vala"
			bookworm_app_app_window_showInfoBar (aBook, GTK_MESSAGE_WARNING);
#line 3874 "bookworm.c"
		}
	}
#line 568 "../src/bookworm.vala"
	if (bookworm_app_book_getIsBookParsed (aBook)) {
#line 3879 "bookworm.c"
		GeeArrayList* _tmp72_;
		GeeArrayList* _tmp73_;
		gint _tmp74_;
		gint _tmp75_;
		GDateTime* _tmp76_;
		GDateTime* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		GeeHashMap* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		GtkHeaderBar* _tmp84_;
		GtkHeaderBar* _tmp85_;
		gchar* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		gchar* _tmp89_;
		const gchar* _tmp90_;
		gchar* _tmp91_;
		GtkScrolledWindow* _tmp92_;
		GtkWidget* _tmp93_;
		GtkAdjustment* _tmp94_;
		GeeArrayList* _tmp95_;
		GeeArrayList* _tmp96_;
		gint _tmp97_;
		gint _tmp98_;
		GtkAdjustment* _tmp99_;
		BookwormAppBook* _tmp100_;
		gchar* _tmp101_;
		BookwormAppBook* _tmp102_;
		WebKitWebView* _tmp103_;
#line 570 "../src/bookworm.vala"
		_tmp72_ = bookworm_app_book_getBookContentList (aBook);
#line 570 "../src/bookworm.vala"
		_tmp73_ = _tmp72_;
#line 570 "../src/bookworm.vala"
		_tmp74_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp73_);
#line 570 "../src/bookworm.vala"
		_tmp75_ = _tmp74_;
#line 570 "../src/bookworm.vala"
		bookworm_app_book_setBookTotalPages (aBook, _tmp75_);
#line 570 "../src/bookworm.vala"
		_g_object_unref0 (_tmp73_);
#line 572 "../src/bookworm.vala"
		_tmp76_ = g_date_time_new_now_utc ();
#line 572 "../src/bookworm.vala"
		_tmp77_ = _tmp76_;
#line 572 "../src/bookworm.vala"
		_tmp78_ = g_strdup_printf ("%" G_GINT64_FORMAT, g_date_time_to_unix (_tmp77_));
#line 572 "../src/bookworm.vala"
		_tmp79_ = _tmp78_;
#line 572 "../src/bookworm.vala"
		bookworm_app_book_setBookLastModificationDate (aBook, _tmp79_);
#line 572 "../src/bookworm.vala"
		_g_free0 (_tmp79_);
#line 572 "../src/bookworm.vala"
		_g_date_time_unref0 (_tmp77_);
#line 573 "../src/bookworm.vala"
		bookworm_app_book_setWasBookOpened (aBook, TRUE);
#line 575 "../src/bookworm.vala"
		_tmp80_ = bookworm_app_bookworm_libraryViewMap;
#line 575 "../src/bookworm.vala"
		_tmp81_ = bookworm_app_book_getBookLocation (aBook);
#line 575 "../src/bookworm.vala"
		_tmp82_ = _tmp81_;
#line 575 "../src/bookworm.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp80_, _tmp82_, aBook);
#line 575 "../src/bookworm.vala"
		_g_free0 (_tmp82_);
#line 576 "../src/bookworm.vala"
		_tmp83_ = bookworm_app_book_getBookLocation (aBook);
#line 576 "../src/bookworm.vala"
		_g_free0 (bookworm_app_bookworm_locationOfEBookCurrentlyRead);
#line 576 "../src/bookworm.vala"
		bookworm_app_bookworm_locationOfEBookCurrentlyRead = _tmp83_;
#line 578 "../src/bookworm.vala"
		_tmp84_ = bookworm_app_app_header_bar_get_headerbar ();
#line 578 "../src/bookworm.vala"
		_tmp85_ = _tmp84_;
#line 578 "../src/bookworm.vala"
		_tmp86_ = bookworm_app_book_getBookTitle (aBook);
#line 578 "../src/bookworm.vala"
		_tmp87_ = _tmp86_;
#line 578 "../src/bookworm.vala"
		_tmp88_ = bookworm_app_utils_parseMarkUp (_tmp87_);
#line 578 "../src/bookworm.vala"
		_tmp89_ = _tmp88_;
#line 578 "../src/bookworm.vala"
		gtk_header_bar_set_title (_tmp85_, _tmp89_);
#line 578 "../src/bookworm.vala"
		_g_free0 (_tmp89_);
#line 578 "../src/bookworm.vala"
		_g_free0 (_tmp87_);
#line 578 "../src/bookworm.vala"
		_g_object_unref0 (_tmp85_);
#line 580 "../src/bookworm.vala"
		_tmp90_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[1];
#line 580 "../src/bookworm.vala"
		_tmp91_ = g_strdup (_tmp90_);
#line 580 "../src/bookworm.vala"
		_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 580 "../src/bookworm.vala"
		bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp91_;
#line 581 "../src/bookworm.vala"
		bookworm_app_bookworm_toggleUIState ();
#line 583 "../src/bookworm.vala"
		_tmp92_ = bookworm_app_info_searchresults_scroll;
#line 583 "../src/bookworm.vala"
		_tmp93_ = gtk_bin_get_child ((GtkBin*) _tmp92_);
#line 583 "../src/bookworm.vala"
		gtk_widget_destroy (_tmp93_);
#line 585 "../src/bookworm.vala"
		_tmp94_ = bookworm_app_app_window_pageAdjustment;
#line 585 "../src/bookworm.vala"
		_tmp95_ = bookworm_app_book_getBookContentList (aBook);
#line 585 "../src/bookworm.vala"
		_tmp96_ = _tmp95_;
#line 585 "../src/bookworm.vala"
		_tmp97_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp96_);
#line 585 "../src/bookworm.vala"
		_tmp98_ = _tmp97_;
#line 585 "../src/bookworm.vala"
		gtk_adjustment_set_upper (_tmp94_, (gdouble) _tmp98_);
#line 585 "../src/bookworm.vala"
		_g_object_unref0 (_tmp96_);
#line 586 "../src/bookworm.vala"
		_tmp99_ = bookworm_app_app_window_pageAdjustment;
#line 586 "../src/bookworm.vala"
		gtk_adjustment_set_value (_tmp99_, (gdouble) bookworm_app_book_getBookPageNumber (aBook));
#line 588 "../src/bookworm.vala"
		_tmp100_ = _bookworm_app_book_ref0 (aBook);
#line 588 "../src/bookworm.vala"
		_tmp101_ = g_strdup ("");
#line 588 "../src/bookworm.vala"
		_tmp102_ = bookworm_app_content_handler_renderPage (_tmp100_, _tmp101_);
#line 588 "../src/bookworm.vala"
		_bookworm_app_book_unref0 (aBook);
#line 588 "../src/bookworm.vala"
		aBook = _tmp102_;
#line 590 "../src/bookworm.vala"
		_tmp103_ = bookworm_app_app_window_aWebView;
#line 590 "../src/bookworm.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp103_);
#line 4024 "bookworm.c"
	}
#line 592 "../src/bookworm.vala"
	_tmp104_ = bookworm_app_book_getBookLocation (aBook);
#line 592 "../src/bookworm.vala"
	_tmp105_ = _tmp104_;
#line 592 "../src/bookworm.vala"
	_tmp106_ = g_strconcat ("[END] [FUNCTION:readSelectedBook] book.location=", _tmp105_, NULL);
#line 592 "../src/bookworm.vala"
	_tmp107_ = _tmp106_;
#line 592 "../src/bookworm.vala"
	g_info ("bookworm.vala:592: %s", _tmp107_);
#line 592 "../src/bookworm.vala"
	_g_free0 (_tmp107_);
#line 592 "../src/bookworm.vala"
	_g_free0 (_tmp105_);
#line 514 "../src/bookworm.vala"
	_bookworm_app_book_unref0 (aBook);
#line 4042 "bookworm.c"
}

void
bookworm_app_bookworm_toggleUIState (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkLabel* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	const gchar* _tmp66_;
	const gchar* _tmp67_;
	const gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
#line 596 "../src/bookworm.vala"
	_tmp0_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 596 "../src/bookworm.vala"
	_tmp1_ = g_strconcat ("[START] [FUNCTION:toggleUIState] bookworm current state:", _tmp0_, NULL);
#line 596 "../src/bookworm.vala"
	_tmp2_ = _tmp1_;
#line 596 "../src/bookworm.vala"
	g_info ("bookworm.vala:596: %s", _tmp2_);
#line 596 "../src/bookworm.vala"
	_g_free0 (_tmp2_);
#line 600 "../src/bookworm.vala"
	_tmp3_ = bookworm_app_app_window_infobarLabel;
#line 600 "../src/bookworm.vala"
	_tmp4_ = gtk_label_get_text (_tmp3_);
#line 600 "../src/bookworm.vala"
	_tmp5_ = strlen (_tmp4_);
#line 600 "../src/bookworm.vala"
	_tmp6_ = _tmp5_;
#line 600 "../src/bookworm.vala"
	if (_tmp6_ < 1) {
#line 4095 "bookworm.c"
		GtkInfoBar* _tmp7_;
#line 601 "../src/bookworm.vala"
		_tmp7_ = bookworm_app_app_window_infobar;
#line 601 "../src/bookworm.vala"
		gtk_widget_hide ((GtkWidget*) _tmp7_);
#line 4101 "bookworm.c"
	}
#line 604 "../src/bookworm.vala"
	_tmp10_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 604 "../src/bookworm.vala"
	_tmp11_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[0];
#line 604 "../src/bookworm.vala"
	if (g_strcmp0 (_tmp10_, _tmp11_) == 0) {
#line 604 "../src/bookworm.vala"
		_tmp9_ = TRUE;
#line 4111 "bookworm.c"
	} else {
		const gchar* _tmp12_;
		const gchar* _tmp13_;
#line 605 "../src/bookworm.vala"
		_tmp12_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 605 "../src/bookworm.vala"
		_tmp13_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[2];
#line 605 "../src/bookworm.vala"
		_tmp9_ = g_strcmp0 (_tmp12_, _tmp13_) == 0;
#line 4121 "bookworm.c"
	}
#line 604 "../src/bookworm.vala"
	if (_tmp9_) {
#line 604 "../src/bookworm.vala"
		_tmp8_ = TRUE;
#line 4127 "bookworm.c"
	} else {
		const gchar* _tmp14_;
		const gchar* _tmp15_;
#line 606 "../src/bookworm.vala"
		_tmp14_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 606 "../src/bookworm.vala"
		_tmp15_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[3];
#line 606 "../src/bookworm.vala"
		_tmp8_ = g_strcmp0 (_tmp14_, _tmp15_) == 0;
#line 4137 "bookworm.c"
	}
#line 604 "../src/bookworm.vala"
	if (_tmp8_) {
#line 4141 "bookworm.c"
		GtkScrolledWindow* _tmp16_;
		GtkScrolledWindow* _tmp17_;
		GtkFlowBox* _tmp18_;
		GtkBox* _tmp19_;
#line 608 "../src/bookworm.vala"
		_tmp16_ = bookworm_app_app_window_library_list_scroll;
#line 608 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp16_, FALSE);
#line 609 "../src/bookworm.vala"
		_tmp17_ = bookworm_app_app_window_library_grid_scroll;
#line 609 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp17_, TRUE);
#line 610 "../src/bookworm.vala"
		_tmp18_ = bookworm_app_app_window_library_grid;
#line 610 "../src/bookworm.vala"
		gtk_widget_show_all ((GtkWidget*) _tmp18_);
#line 611 "../src/bookworm.vala"
		_tmp19_ = bookworm_app_app_window_bookLibrary_ui_box;
#line 611 "../src/bookworm.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp19_);
#line 4162 "bookworm.c"
	}
#line 614 "../src/bookworm.vala"
	_tmp22_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 614 "../src/bookworm.vala"
	_tmp23_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[5];
#line 614 "../src/bookworm.vala"
	if (g_strcmp0 (_tmp22_, _tmp23_) == 0) {
#line 614 "../src/bookworm.vala"
		_tmp21_ = TRUE;
#line 4172 "bookworm.c"
	} else {
		const gchar* _tmp24_;
		const gchar* _tmp25_;
#line 615 "../src/bookworm.vala"
		_tmp24_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 615 "../src/bookworm.vala"
		_tmp25_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[6];
#line 615 "../src/bookworm.vala"
		_tmp21_ = g_strcmp0 (_tmp24_, _tmp25_) == 0;
#line 4182 "bookworm.c"
	}
#line 614 "../src/bookworm.vala"
	if (_tmp21_) {
#line 614 "../src/bookworm.vala"
		_tmp20_ = TRUE;
#line 4188 "bookworm.c"
	} else {
		const gchar* _tmp26_;
		const gchar* _tmp27_;
#line 616 "../src/bookworm.vala"
		_tmp26_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 616 "../src/bookworm.vala"
		_tmp27_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[7];
#line 616 "../src/bookworm.vala"
		_tmp20_ = g_strcmp0 (_tmp26_, _tmp27_) == 0;
#line 4198 "bookworm.c"
	}
#line 614 "../src/bookworm.vala"
	if (_tmp20_) {
#line 4202 "bookworm.c"
		GtkScrolledWindow* _tmp28_;
		GtkScrolledWindow* _tmp29_;
		GtkTreeView* _tmp30_;
		GtkTreeView* _tmp31_;
#line 618 "../src/bookworm.vala"
		_tmp28_ = bookworm_app_app_window_library_grid_scroll;
#line 618 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp28_, FALSE);
#line 619 "../src/bookworm.vala"
		_tmp29_ = bookworm_app_app_window_library_list_scroll;
#line 619 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp29_, TRUE);
#line 620 "../src/bookworm.vala"
		_tmp30_ = bookworm_app_app_window_library_table_treeview;
#line 620 "../src/bookworm.vala"
		gtk_widget_show_all ((GtkWidget*) _tmp30_);
#line 621 "../src/bookworm.vala"
		_tmp31_ = bookworm_app_app_window_library_table_treeview;
#line 621 "../src/bookworm.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp31_);
#line 4223 "bookworm.c"
	}
#line 624 "../src/bookworm.vala"
	_tmp35_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 624 "../src/bookworm.vala"
	_tmp36_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[0];
#line 624 "../src/bookworm.vala"
	if (g_strcmp0 (_tmp35_, _tmp36_) == 0) {
#line 624 "../src/bookworm.vala"
		_tmp34_ = TRUE;
#line 4233 "bookworm.c"
	} else {
		const gchar* _tmp37_;
		const gchar* _tmp38_;
#line 625 "../src/bookworm.vala"
		_tmp37_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 625 "../src/bookworm.vala"
		_tmp38_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[2];
#line 625 "../src/bookworm.vala"
		_tmp34_ = g_strcmp0 (_tmp37_, _tmp38_) == 0;
#line 4243 "bookworm.c"
	}
#line 624 "../src/bookworm.vala"
	if (_tmp34_) {
#line 624 "../src/bookworm.vala"
		_tmp33_ = TRUE;
#line 4249 "bookworm.c"
	} else {
		const gchar* _tmp39_;
		const gchar* _tmp40_;
#line 626 "../src/bookworm.vala"
		_tmp39_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 626 "../src/bookworm.vala"
		_tmp40_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[3];
#line 626 "../src/bookworm.vala"
		_tmp33_ = g_strcmp0 (_tmp39_, _tmp40_) == 0;
#line 4259 "bookworm.c"
	}
#line 624 "../src/bookworm.vala"
	if (_tmp33_) {
#line 624 "../src/bookworm.vala"
		_tmp32_ = TRUE;
#line 4265 "bookworm.c"
	} else {
		const gchar* _tmp41_;
		const gchar* _tmp42_;
#line 627 "../src/bookworm.vala"
		_tmp41_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 627 "../src/bookworm.vala"
		_tmp42_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[5];
#line 627 "../src/bookworm.vala"
		_tmp32_ = g_strcmp0 (_tmp41_, _tmp42_) == 0;
#line 4275 "bookworm.c"
	}
#line 624 "../src/bookworm.vala"
	if (_tmp32_) {
#line 4279 "bookworm.c"
		GtkSearchEntry* _tmp43_;
		GraniteWidgetsModeButton* _tmp44_;
		GtkButton* _tmp45_;
		GtkButton* _tmp46_;
		GtkBox* _tmp47_;
		GtkBox* _tmp48_;
		GtkBox* _tmp49_;
		GtkButton* _tmp50_;
		GtkButton* _tmp51_;
		GtkButton* _tmp52_;
#line 629 "../src/bookworm.vala"
		_tmp43_ = bookworm_app_app_header_bar_headerSearchBar;
#line 629 "../src/bookworm.vala"
		gtk_entry_set_placeholder_text ((GtkEntry*) _tmp43_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_HEADERBAR_LIBRARY_SEARCH);
#line 632 "../src/bookworm.vala"
		_tmp44_ = bookworm_app_bookworm_library_mode_button;
#line 632 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp44_, TRUE);
#line 633 "../src/bookworm.vala"
		_tmp45_ = bookworm_app_bookworm_content_list_button;
#line 633 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp45_, FALSE);
#line 634 "../src/bookworm.vala"
		_tmp46_ = bookworm_app_bookworm_library_view_button;
#line 634 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp46_, FALSE);
#line 635 "../src/bookworm.vala"
		_tmp47_ = bookworm_app_app_window_bookLibrary_ui_box;
#line 635 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp47_, TRUE);
#line 636 "../src/bookworm.vala"
		_tmp48_ = bookworm_app_app_window_bookReading_ui_box;
#line 636 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp48_, FALSE);
#line 637 "../src/bookworm.vala"
		_tmp49_ = bookworm_app_info_info_box;
#line 637 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp49_, FALSE);
#line 638 "../src/bookworm.vala"
		_tmp50_ = bookworm_app_bookworm_prefButton;
#line 638 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp50_, FALSE);
#line 639 "../src/bookworm.vala"
		_tmp51_ = bookworm_app_app_header_bar_bookmark_active_button;
#line 639 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp51_, FALSE);
#line 640 "../src/bookworm.vala"
		_tmp52_ = bookworm_app_app_header_bar_bookmark_inactive_button;
#line 640 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp52_, FALSE);
#line 641 "../src/bookworm.vala"
		if (!bookworm_app_bookworm_isBookBeingAddedToLibrary) {
#line 4332 "bookworm.c"
			GtkProgressBar* _tmp53_;
#line 642 "../src/bookworm.vala"
			_tmp53_ = bookworm_app_app_window_bookAdditionBar;
#line 642 "../src/bookworm.vala"
			gtk_widget_hide ((GtkWidget*) _tmp53_);
#line 4338 "bookworm.c"
		}
	}
#line 645 "../src/bookworm.vala"
	_tmp54_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 645 "../src/bookworm.vala"
	_tmp55_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[1];
#line 645 "../src/bookworm.vala"
	if (g_strcmp0 (_tmp54_, _tmp55_) == 0) {
#line 4347 "bookworm.c"
		GtkSearchEntry* _tmp56_;
		GraniteWidgetsModeButton* _tmp57_;
		GtkButton* _tmp58_;
		GtkButton* _tmp59_;
		GtkButton* _tmp60_;
		GtkBox* _tmp61_;
		GtkBox* _tmp62_;
		GtkBox* _tmp63_;
		GtkButton* _tmp64_;
		GtkProgressBar* _tmp65_;
#line 646 "../src/bookworm.vala"
		_tmp56_ = bookworm_app_app_header_bar_headerSearchBar;
#line 646 "../src/bookworm.vala"
		gtk_entry_set_placeholder_text ((GtkEntry*) _tmp56_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_HEADERBAR_BOOK_SEARCH);
#line 649 "../src/bookworm.vala"
		_tmp57_ = bookworm_app_bookworm_library_mode_button;
#line 649 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp57_, FALSE);
#line 650 "../src/bookworm.vala"
		_tmp58_ = bookworm_app_bookworm_content_list_button;
#line 650 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp58_, TRUE);
#line 651 "../src/bookworm.vala"
		_tmp59_ = bookworm_app_bookworm_library_view_button;
#line 651 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp59_, TRUE);
#line 652 "../src/bookworm.vala"
		_tmp60_ = bookworm_app_bookworm_library_view_button;
#line 652 "../src/bookworm.vala"
		gtk_button_set_label (_tmp60_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_LIBRARY_BUTTON);
#line 653 "../src/bookworm.vala"
		_tmp61_ = bookworm_app_app_window_bookLibrary_ui_box;
#line 653 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp61_, FALSE);
#line 654 "../src/bookworm.vala"
		_tmp62_ = bookworm_app_app_window_bookReading_ui_box;
#line 654 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp62_, TRUE);
#line 655 "../src/bookworm.vala"
		_tmp63_ = bookworm_app_info_info_box;
#line 655 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp63_, FALSE);
#line 656 "../src/bookworm.vala"
		_tmp64_ = bookworm_app_bookworm_prefButton;
#line 656 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp64_, TRUE);
#line 657 "../src/bookworm.vala"
		bookworm_app_content_handler_handleBookMark ("DISPLAY");
#line 658 "../src/bookworm.vala"
		_tmp65_ = bookworm_app_app_window_bookAdditionBar;
#line 658 "../src/bookworm.vala"
		gtk_widget_hide ((GtkWidget*) _tmp65_);
#line 4400 "bookworm.c"
	}
#line 661 "../src/bookworm.vala"
	_tmp66_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 661 "../src/bookworm.vala"
	_tmp67_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[4];
#line 661 "../src/bookworm.vala"
	if (g_strcmp0 (_tmp66_, _tmp67_) == 0) {
#line 4408 "bookworm.c"
		GtkSearchEntry* _tmp68_;
		GtkBox* _tmp69_;
		GraniteWidgetsModeButton* _tmp70_;
		GtkButton* _tmp71_;
		GtkButton* _tmp72_;
		GtkButton* _tmp73_;
		GtkBox* _tmp74_;
		GtkBox* _tmp75_;
		GtkBox* _tmp76_;
		GtkStack* _tmp77_;
		BookwormAppSettings* _tmp78_;
		const gchar* _tmp79_;
		const gchar* _tmp80_;
		GtkButton* _tmp81_;
		GtkButton* _tmp82_;
		GtkButton* _tmp83_;
		GtkProgressBar* _tmp84_;
#line 662 "../src/bookworm.vala"
		_tmp68_ = bookworm_app_app_header_bar_headerSearchBar;
#line 662 "../src/bookworm.vala"
		gtk_entry_set_placeholder_text ((GtkEntry*) _tmp68_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_HEADERBAR_LIBRARY_SEARCH);
#line 665 "../src/bookworm.vala"
		_tmp69_ = bookworm_app_info_info_box;
#line 665 "../src/bookworm.vala"
		gtk_widget_show_all ((GtkWidget*) _tmp69_);
#line 666 "../src/bookworm.vala"
		_tmp70_ = bookworm_app_bookworm_library_mode_button;
#line 666 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp70_, FALSE);
#line 667 "../src/bookworm.vala"
		_tmp71_ = bookworm_app_bookworm_content_list_button;
#line 667 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp71_, FALSE);
#line 668 "../src/bookworm.vala"
		_tmp72_ = bookworm_app_bookworm_library_view_button;
#line 668 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp72_, TRUE);
#line 669 "../src/bookworm.vala"
		_tmp73_ = bookworm_app_bookworm_library_view_button;
#line 669 "../src/bookworm.vala"
		gtk_button_set_label (_tmp73_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_RESUME_BUTTON);
#line 670 "../src/bookworm.vala"
		_tmp74_ = bookworm_app_app_window_bookLibrary_ui_box;
#line 670 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp74_, FALSE);
#line 671 "../src/bookworm.vala"
		_tmp75_ = bookworm_app_app_window_bookReading_ui_box;
#line 671 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp75_, FALSE);
#line 672 "../src/bookworm.vala"
		_tmp76_ = bookworm_app_info_info_box;
#line 672 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp76_, TRUE);
#line 673 "../src/bookworm.vala"
		_tmp77_ = bookworm_app_info_stack;
#line 673 "../src/bookworm.vala"
		_tmp78_ = bookworm_app_bookworm_settings;
#line 673 "../src/bookworm.vala"
		_tmp79_ = bookworm_app_settings_get_current_info_tab (_tmp78_);
#line 673 "../src/bookworm.vala"
		_tmp80_ = _tmp79_;
#line 673 "../src/bookworm.vala"
		gtk_stack_set_visible_child_name (_tmp77_, _tmp80_);
#line 674 "../src/bookworm.vala"
		_tmp81_ = bookworm_app_bookworm_prefButton;
#line 674 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp81_, FALSE);
#line 675 "../src/bookworm.vala"
		_tmp82_ = bookworm_app_app_header_bar_bookmark_active_button;
#line 675 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp82_, FALSE);
#line 676 "../src/bookworm.vala"
		_tmp83_ = bookworm_app_app_header_bar_bookmark_inactive_button;
#line 676 "../src/bookworm.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp83_, FALSE);
#line 677 "../src/bookworm.vala"
		_tmp84_ = bookworm_app_app_window_bookAdditionBar;
#line 677 "../src/bookworm.vala"
		gtk_widget_hide ((GtkWidget*) _tmp84_);
#line 4488 "bookworm.c"
	}
#line 679 "../src/bookworm.vala"
	_tmp85_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 679 "../src/bookworm.vala"
	_tmp86_ = g_strconcat ("[END] [FUNCTION:toggleUIState] bookworm current state:", _tmp85_, NULL);
#line 679 "../src/bookworm.vala"
	_tmp87_ = _tmp86_;
#line 679 "../src/bookworm.vala"
	g_info ("bookworm.vala:679: %s", _tmp87_);
#line 679 "../src/bookworm.vala"
	_g_free0 (_tmp87_);
#line 4500 "bookworm.c"
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
#line 1501 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1501 "glib-2.0.vapi"
	end = _tmp0_;
#line 1502 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1502 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1503 "glib-2.0.vapi"
		result = maxlen;
#line 1503 "glib-2.0.vapi"
		return result;
#line 4523 "bookworm.c"
	} else {
		gchar* _tmp2_;
#line 1505 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1505 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1505 "glib-2.0.vapi"
		return result;
#line 4532 "bookworm.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
#line 1512 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1514 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 4551 "bookworm.c"
	} else {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 4555 "bookworm.c"
	}
#line 1514 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1516 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 4561 "bookworm.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1518 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1518 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1518 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 4571 "bookworm.c"
	}
#line 1521 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1522 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1523 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 4579 "bookworm.c"
	} else {
#line 1525 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 4583 "bookworm.c"
	}
#line 1527 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1528 "glib-2.0.vapi"
		len = string_length - offset;
#line 4589 "bookworm.c"
	}
#line 1530 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1531 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1531 "glib-2.0.vapi"
	result = _tmp3_;
#line 1531 "glib-2.0.vapi"
	return result;
#line 4599 "bookworm.c"
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1194 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1194 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1195 "glib-2.0.vapi"
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1195 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1197 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1197 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 4623 "bookworm.c"
		gchar* _tmp2_;
#line 1198 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1198 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1198 "glib-2.0.vapi"
		return result;
#line 4631 "bookworm.c"
	} else {
#line 1200 "glib-2.0.vapi"
		result = -1;
#line 1200 "glib-2.0.vapi"
		return result;
#line 4637 "bookworm.c"
	}
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
#line 37 "glib-2.0.vapi"
	if (self) {
#line 4647 "bookworm.c"
		gchar* _tmp0_;
#line 38 "glib-2.0.vapi"
		_tmp0_ = g_strdup ("true");
#line 38 "glib-2.0.vapi"
		result = _tmp0_;
#line 38 "glib-2.0.vapi"
		return result;
#line 4655 "bookworm.c"
	} else {
		gchar* _tmp1_;
#line 40 "glib-2.0.vapi"
		_tmp1_ = g_strdup ("false");
#line 40 "glib-2.0.vapi"
		result = _tmp1_;
#line 40 "glib-2.0.vapi"
		return result;
#line 4664 "bookworm.c"
	}
}

BookwormAppBook*
bookworm_app_bookworm_genericParser (BookwormAppBook* aBook)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	gchar* ebookFileName = NULL;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	BookwormAppBook* _tmp65_;
	GError* _inner_error0_ = NULL;
	BookwormAppBook* result;
#line 684 "../src/bookworm.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 685 "../src/bookworm.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 685 "../src/bookworm.vala"
	_tmp1_ = _tmp0_;
#line 685 "../src/bookworm.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:genericParser] book.location=", _tmp1_, NULL);
#line 685 "../src/bookworm.vala"
	_tmp3_ = _tmp2_;
#line 685 "../src/bookworm.vala"
	g_info ("bookworm.vala:685: %s", _tmp3_);
#line 685 "../src/bookworm.vala"
	_g_free0 (_tmp3_);
#line 685 "../src/bookworm.vala"
	_g_free0 (_tmp1_);
#line 687 "../src/bookworm.vala"
	bookworm_app_book_setBookAuthor (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_UNKNOWN_TITLE);
#line 688 "../src/bookworm.vala"
	bookworm_app_book_setBookTitle (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_UNKNOWN_TITLE);
#line 690 "../src/bookworm.vala"
	_tmp4_ = bookworm_app_book_getBookLocation (aBook);
#line 690 "../src/bookworm.vala"
	_tmp5_ = _tmp4_;
#line 690 "../src/bookworm.vala"
	_tmp6_ = bookworm_app_utils_fileOperations ("EXISTS", "", _tmp5_, "");
#line 690 "../src/bookworm.vala"
	_tmp7_ = _tmp6_;
#line 690 "../src/bookworm.vala"
	_tmp8_ = g_strcmp0 ("false", _tmp7_) == 0;
#line 690 "../src/bookworm.vala"
	_g_free0 (_tmp7_);
#line 690 "../src/bookworm.vala"
	_g_free0 (_tmp5_);
#line 690 "../src/bookworm.vala"
	if (_tmp8_) {
#line 4731 "bookworm.c"
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		BookwormAppBook* _tmp13_;
#line 691 "../src/bookworm.vala"
		_tmp9_ = bookworm_app_book_getBookLocation (aBook);
#line 691 "../src/bookworm.vala"
		_tmp10_ = _tmp9_;
#line 691 "../src/bookworm.vala"
		_tmp11_ = g_strconcat ("EBook not found at provided location:", _tmp10_, NULL);
#line 691 "../src/bookworm.vala"
		_tmp12_ = _tmp11_;
#line 691 "../src/bookworm.vala"
		g_warning ("bookworm.vala:691: %s", _tmp12_);
#line 691 "../src/bookworm.vala"
		_g_free0 (_tmp12_);
#line 691 "../src/bookworm.vala"
		_g_free0 (_tmp10_);
#line 692 "../src/bookworm.vala"
		bookworm_app_book_setIsBookParsed (aBook, FALSE);
#line 693 "../src/bookworm.vala"
		bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_EXTRACTION_ISSUE);
#line 694 "../src/bookworm.vala"
		_tmp13_ = _bookworm_app_book_ref0 (aBook);
#line 694 "../src/bookworm.vala"
		result = _tmp13_;
#line 694 "../src/bookworm.vala"
		_bookworm_app_book_unref0 (aBook);
#line 694 "../src/bookworm.vala"
		return result;
#line 4763 "bookworm.c"
	}
#line 697 "../src/bookworm.vala"
	_tmp14_ = bookworm_app_book_getBookLocation (aBook);
#line 697 "../src/bookworm.vala"
	_tmp15_ = _tmp14_;
#line 697 "../src/bookworm.vala"
	_tmp16_ = g_file_new_for_path (_tmp15_);
#line 697 "../src/bookworm.vala"
	_tmp17_ = _tmp16_;
#line 697 "../src/bookworm.vala"
	_tmp18_ = g_file_get_basename (_tmp17_);
#line 697 "../src/bookworm.vala"
	_tmp19_ = _tmp18_;
#line 697 "../src/bookworm.vala"
	_g_object_unref0 (_tmp17_);
#line 697 "../src/bookworm.vala"
	_g_free0 (_tmp15_);
#line 697 "../src/bookworm.vala"
	ebookFileName = _tmp19_;
#line 698 "../src/bookworm.vala"
	_tmp20_ = ebookFileName;
#line 698 "../src/bookworm.vala"
	if (string_index_of (_tmp20_, ".", 0) != -1) {
#line 4787 "bookworm.c"
		gchar* fileExtension = NULL;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
#line 699 "../src/bookworm.vala"
		_tmp21_ = ebookFileName;
#line 699 "../src/bookworm.vala"
		_tmp22_ = ebookFileName;
#line 699 "../src/bookworm.vala"
		_tmp23_ = string_substring (_tmp21_, (glong) string_last_index_of (_tmp22_, ".", 0), (glong) -1);
#line 699 "../src/bookworm.vala"
		_tmp24_ = _tmp23_;
#line 699 "../src/bookworm.vala"
		_tmp25_ = g_utf8_strup (_tmp24_, (gssize) -1);
#line 699 "../src/bookworm.vala"
		_tmp26_ = _tmp25_;
#line 699 "../src/bookworm.vala"
		_g_free0 (_tmp24_);
#line 699 "../src/bookworm.vala"
		fileExtension = _tmp26_;
#line 4811 "bookworm.c"
		{
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			GQuark _tmp30_ = 0U;
#line 702 "../src/bookworm.vala"
			static GQuark _tmp29_label0 = 0;
#line 702 "../src/bookworm.vala"
			static GQuark _tmp29_label1 = 0;
#line 702 "../src/bookworm.vala"
			static GQuark _tmp29_label2 = 0;
#line 702 "../src/bookworm.vala"
			static GQuark _tmp29_label3 = 0;
#line 702 "../src/bookworm.vala"
			static GQuark _tmp29_label4 = 0;
#line 702 "../src/bookworm.vala"
			static GQuark _tmp29_label5 = 0;
#line 702 "../src/bookworm.vala"
			static GQuark _tmp29_label6 = 0;
#line 702 "../src/bookworm.vala"
			static GQuark _tmp29_label7 = 0;
#line 702 "../src/bookworm.vala"
			_tmp27_ = fileExtension;
#line 702 "../src/bookworm.vala"
			_tmp28_ = _tmp27_;
#line 702 "../src/bookworm.vala"
			_tmp30_ = (NULL == _tmp28_) ? 0 : g_quark_from_string (_tmp28_);
#line 702 "../src/bookworm.vala"
			if (_tmp30_ == ((0 != _tmp29_label0) ? _tmp29_label0 : (_tmp29_label0 = g_quark_from_static_string (".EPUB")))) {
#line 702 "../src/bookworm.vala"
				switch (0) {
#line 4842 "bookworm.c"
					default:
					{
						BookwormAppBook* _tmp31_;
						BookwormAppBook* _tmp32_;
#line 704 "../src/bookworm.vala"
						_tmp31_ = _bookworm_app_book_ref0 (aBook);
#line 704 "../src/bookworm.vala"
						_tmp32_ = bookworm_app_epub_reader_parseEPubBook (_tmp31_);
#line 704 "../src/bookworm.vala"
						_bookworm_app_book_unref0 (aBook);
#line 704 "../src/bookworm.vala"
						aBook = _tmp32_;
#line 705 "../src/bookworm.vala"
						break;
#line 4857 "bookworm.c"
					}
				}
			} else if (_tmp30_ == ((0 != _tmp29_label1) ? _tmp29_label1 : (_tmp29_label1 = g_quark_from_static_string (".PDF")))) {
#line 702 "../src/bookworm.vala"
				switch (0) {
#line 4863 "bookworm.c"
					default:
					{
						BookwormAppBook* _tmp33_ = NULL;
						BookwormAppBook* _tmp34_;
						BookwormAppBook* _tmp35_;
						BookwormAppBook* _tmp36_;
#line 707 "../src/bookworm.vala"
						_tmp34_ = _bookworm_app_book_ref0 (aBook);
#line 707 "../src/bookworm.vala"
						_tmp35_ = bookworm_app_pdf_reader_parsePDFBook (_tmp34_, &_inner_error0_);
#line 707 "../src/bookworm.vala"
						_tmp33_ = _tmp35_;
#line 707 "../src/bookworm.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4878 "bookworm.c"
							goto __catch0_g_error;
						}
#line 707 "../src/bookworm.vala"
						_tmp36_ = _tmp33_;
#line 707 "../src/bookworm.vala"
						_tmp33_ = NULL;
#line 707 "../src/bookworm.vala"
						_bookworm_app_book_unref0 (aBook);
#line 707 "../src/bookworm.vala"
						aBook = _tmp36_;
#line 708 "../src/bookworm.vala"
						_bookworm_app_book_unref0 (_tmp33_);
#line 708 "../src/bookworm.vala"
						break;
#line 4893 "bookworm.c"
					}
				}
			} else if (_tmp30_ == ((0 != _tmp29_label2) ? _tmp29_label2 : (_tmp29_label2 = g_quark_from_static_string (".CBR")))) {
#line 702 "../src/bookworm.vala"
				switch (0) {
#line 4899 "bookworm.c"
					default:
					{
						BookwormAppBook* _tmp37_;
						const gchar* _tmp38_;
						BookwormAppBook* _tmp39_;
#line 710 "../src/bookworm.vala"
						_tmp37_ = _bookworm_app_book_ref0 (aBook);
#line 710 "../src/bookworm.vala"
						_tmp38_ = fileExtension;
#line 710 "../src/bookworm.vala"
						_tmp39_ = bookworm_app_comics_reader_parseComicsBook (_tmp37_, _tmp38_);
#line 710 "../src/bookworm.vala"
						_bookworm_app_book_unref0 (aBook);
#line 710 "../src/bookworm.vala"
						aBook = _tmp39_;
#line 711 "../src/bookworm.vala"
						break;
#line 4917 "bookworm.c"
					}
				}
			} else if (_tmp30_ == ((0 != _tmp29_label3) ? _tmp29_label3 : (_tmp29_label3 = g_quark_from_static_string (".CBZ")))) {
#line 702 "../src/bookworm.vala"
				switch (0) {
#line 4923 "bookworm.c"
					default:
					{
						BookwormAppBook* _tmp40_;
						const gchar* _tmp41_;
						BookwormAppBook* _tmp42_;
#line 713 "../src/bookworm.vala"
						_tmp40_ = _bookworm_app_book_ref0 (aBook);
#line 713 "../src/bookworm.vala"
						_tmp41_ = fileExtension;
#line 713 "../src/bookworm.vala"
						_tmp42_ = bookworm_app_comics_reader_parseComicsBook (_tmp40_, _tmp41_);
#line 713 "../src/bookworm.vala"
						_bookworm_app_book_unref0 (aBook);
#line 713 "../src/bookworm.vala"
						aBook = _tmp42_;
#line 714 "../src/bookworm.vala"
						break;
#line 4941 "bookworm.c"
					}
				}
			} else if (_tmp30_ == ((0 != _tmp29_label4) ? _tmp29_label4 : (_tmp29_label4 = g_quark_from_static_string (".MOBI")))) {
#line 702 "../src/bookworm.vala"
				switch (0) {
#line 4947 "bookworm.c"
					default:
					{
						BookwormAppBook* _tmp43_;
						BookwormAppBook* _tmp44_;
#line 716 "../src/bookworm.vala"
						_tmp43_ = _bookworm_app_book_ref0 (aBook);
#line 716 "../src/bookworm.vala"
						_tmp44_ = bookworm_app_mobi_reader_parseMobiBook (_tmp43_);
#line 716 "../src/bookworm.vala"
						_bookworm_app_book_unref0 (aBook);
#line 716 "../src/bookworm.vala"
						aBook = _tmp44_;
#line 717 "../src/bookworm.vala"
						break;
#line 4962 "bookworm.c"
					}
				}
			} else if (_tmp30_ == ((0 != _tmp29_label5) ? _tmp29_label5 : (_tmp29_label5 = g_quark_from_static_string (".PRC")))) {
#line 702 "../src/bookworm.vala"
				switch (0) {
#line 4968 "bookworm.c"
					default:
					{
						BookwormAppBook* _tmp45_;
						BookwormAppBook* _tmp46_;
#line 719 "../src/bookworm.vala"
						_tmp45_ = _bookworm_app_book_ref0 (aBook);
#line 719 "../src/bookworm.vala"
						_tmp46_ = bookworm_app_mobi_reader_parseMobiBook (_tmp45_);
#line 719 "../src/bookworm.vala"
						_bookworm_app_book_unref0 (aBook);
#line 719 "../src/bookworm.vala"
						aBook = _tmp46_;
#line 720 "../src/bookworm.vala"
						break;
#line 4983 "bookworm.c"
					}
				}
			} else if (_tmp30_ == ((0 != _tmp29_label6) ? _tmp29_label6 : (_tmp29_label6 = g_quark_from_static_string (".ZIP")))) {
#line 702 "../src/bookworm.vala"
				switch (0) {
#line 4989 "bookworm.c"
					default:
					{
						const gchar* _tmp47_;
						gchar* _tmp48_;
						gchar* _tmp49_;
						gboolean _tmp50_;
#line 723 "../src/bookworm.vala"
						_tmp47_ = ebookFileName;
#line 723 "../src/bookworm.vala"
						_tmp48_ = g_utf8_strup (_tmp47_, (gssize) -1);
#line 723 "../src/bookworm.vala"
						_tmp49_ = _tmp48_;
#line 723 "../src/bookworm.vala"
						_tmp50_ = string_last_index_of (_tmp49_, ".FB2.ZIP", 0) != -1;
#line 723 "../src/bookworm.vala"
						_g_free0 (_tmp49_);
#line 723 "../src/bookworm.vala"
						if (_tmp50_) {
#line 5008 "bookworm.c"
							BookwormAppBook* _tmp51_;
							BookwormAppBook* _tmp52_;
#line 724 "../src/bookworm.vala"
							_tmp51_ = _bookworm_app_book_ref0 (aBook);
#line 724 "../src/bookworm.vala"
							_tmp52_ = bookworm_app_fb2_reader_parseFictionBook (_tmp51_);
#line 724 "../src/bookworm.vala"
							_bookworm_app_book_unref0 (aBook);
#line 724 "../src/bookworm.vala"
							aBook = _tmp52_;
#line 725 "../src/bookworm.vala"
							break;
#line 5021 "bookworm.c"
						} else {
#line 727 "../src/bookworm.vala"
							bookworm_app_book_setIsBookParsed (aBook, FALSE);
#line 728 "../src/bookworm.vala"
							bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_FORMAT_NOT_SUPPORTED);
#line 729 "../src/bookworm.vala"
							break;
#line 5029 "bookworm.c"
						}
					}
				}
			} else if (_tmp30_ == ((0 != _tmp29_label7) ? _tmp29_label7 : (_tmp29_label7 = g_quark_from_static_string (".FB2")))) {
#line 702 "../src/bookworm.vala"
				switch (0) {
#line 5036 "bookworm.c"
					default:
					{
						BookwormAppBook* _tmp53_;
						BookwormAppBook* _tmp54_;
#line 732 "../src/bookworm.vala"
						_tmp53_ = _bookworm_app_book_ref0 (aBook);
#line 732 "../src/bookworm.vala"
						_tmp54_ = bookworm_app_fb2_reader_parseFictionBook (_tmp53_);
#line 732 "../src/bookworm.vala"
						_bookworm_app_book_unref0 (aBook);
#line 732 "../src/bookworm.vala"
						aBook = _tmp54_;
#line 733 "../src/bookworm.vala"
						break;
#line 5051 "bookworm.c"
					}
				}
			} else {
#line 702 "../src/bookworm.vala"
				switch (0) {
#line 5057 "bookworm.c"
					default:
					{
#line 735 "../src/bookworm.vala"
						bookworm_app_book_setIsBookParsed (aBook, FALSE);
#line 736 "../src/bookworm.vala"
						bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_FORMAT_NOT_SUPPORTED);
#line 737 "../src/bookworm.vala"
						break;
#line 5066 "bookworm.c"
					}
				}
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp55_;
			const gchar* _tmp56_;
#line 701 "../src/bookworm.vala"
			e = _inner_error0_;
#line 701 "../src/bookworm.vala"
			_inner_error0_ = NULL;
#line 740 "../src/bookworm.vala"
			_tmp55_ = e;
#line 740 "../src/bookworm.vala"
			_tmp56_ = _tmp55_->message;
#line 740 "../src/bookworm.vala"
			g_info ("bookworm.vala:740: Error while parsing book: %s\n", _tmp56_);
#line 741 "../src/bookworm.vala"
			bookworm_app_book_setIsBookParsed (aBook, FALSE);
#line 742 "../src/bookworm.vala"
			bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_PARSING_ISSUE);
#line 701 "../src/bookworm.vala"
			_g_error_free0 (e);
#line 5093 "bookworm.c"
		}
		__finally0:
#line 701 "../src/bookworm.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 701 "../src/bookworm.vala"
			_g_free0 (fileExtension);
#line 701 "../src/bookworm.vala"
			_g_free0 (ebookFileName);
#line 701 "../src/bookworm.vala"
			_bookworm_app_book_unref0 (aBook);
#line 701 "../src/bookworm.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 701 "../src/bookworm.vala"
			g_clear_error (&_inner_error0_);
#line 701 "../src/bookworm.vala"
			return NULL;
#line 5110 "bookworm.c"
		}
#line 698 "../src/bookworm.vala"
		_g_free0 (fileExtension);
#line 5114 "bookworm.c"
	}
#line 746 "../src/bookworm.vala"
	if (!bookworm_app_book_getIsBookParsed (aBook)) {
#line 5118 "bookworm.c"
		GString* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		GString* _tmp60_;
#line 747 "../src/bookworm.vala"
		_tmp57_ = bookworm_app_bookworm_pathsOfBooksNotAddedStr;
#line 747 "../src/bookworm.vala"
		_tmp58_ = bookworm_app_book_getBookLocation (aBook);
#line 747 "../src/bookworm.vala"
		_tmp59_ = _tmp58_;
#line 747 "../src/bookworm.vala"
		_tmp60_ = g_string_append (_tmp57_, _tmp59_);
#line 747 "../src/bookworm.vala"
		g_string_append (_tmp60_, "~~");
#line 747 "../src/bookworm.vala"
		_g_free0 (_tmp59_);
#line 5135 "bookworm.c"
	}
#line 749 "../src/bookworm.vala"
	_tmp61_ = bool_to_string (bookworm_app_book_getIsBookParsed (aBook));
#line 749 "../src/bookworm.vala"
	_tmp62_ = _tmp61_;
#line 749 "../src/bookworm.vala"
	_tmp63_ = g_strconcat ("[END] [FUNCTION:genericParser] book.is book parsed=", _tmp62_, NULL);
#line 749 "../src/bookworm.vala"
	_tmp64_ = _tmp63_;
#line 749 "../src/bookworm.vala"
	g_info ("bookworm.vala:749: %s", _tmp64_);
#line 749 "../src/bookworm.vala"
	_g_free0 (_tmp64_);
#line 749 "../src/bookworm.vala"
	_g_free0 (_tmp62_);
#line 750 "../src/bookworm.vala"
	_tmp65_ = _bookworm_app_book_ref0 (aBook);
#line 750 "../src/bookworm.vala"
	result = _tmp65_;
#line 750 "../src/bookworm.vala"
	_g_free0 (ebookFileName);
#line 750 "../src/bookworm.vala"
	_bookworm_app_book_unref0 (aBook);
#line 750 "../src/bookworm.vala"
	return result;
#line 5161 "bookworm.c"
}

static GObject *
bookworm_app_bookworm_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BookwormAppBookworm * self;
	gchar* _tmp0_;
	GApplicationFlags _tmp1_;
	GApplicationFlags _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GOptionEntry* _tmp5_;
	GOptionEntry* _tmp6_;
	gint _tmp6__length1;
	GOptionEntry _tmp7_ = {0};
	GOptionEntry* _tmp8_;
	gint _tmp8__length1;
	GOptionEntry _tmp9_ = {0};
	GOptionEntry* _tmp10_;
	gint _tmp10__length1;
	GOptionEntry _tmp11_ = {0};
	GOptionEntry* _tmp12_;
	gint _tmp12__length1;
	GOptionEntry _tmp13_ = {0};
	GOptionEntry* _tmp14_;
	gint _tmp14__length1;
#line 102 "../src/bookworm.vala"
	parent_class = G_OBJECT_CLASS (bookworm_app_bookworm_parent_class);
#line 102 "../src/bookworm.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 102 "../src/bookworm.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOOKWORM_APP_TYPE_BOOKWORM, BookwormAppBookworm);
#line 103 "../src/bookworm.vala"
	_tmp0_ = g_strdup (BOOKWORM_APP_CONSTANTS_bookworm_version);
#line 103 "../src/bookworm.vala"
	_g_free0 (((GraniteApplication*) self)->build_version);
#line 103 "../src/bookworm.vala"
	((GraniteApplication*) self)->build_version = _tmp0_;
#line 104 "../src/bookworm.vala"
	g_application_set_application_id ((GApplication*) self, BOOKWORM_APP_CONSTANTS_bookworm_id);
#line 105 "../src/bookworm.vala"
	_tmp1_ = g_application_get_flags ((GApplication*) self);
#line 105 "../src/bookworm.vala"
	_tmp2_ = _tmp1_;
#line 105 "../src/bookworm.vala"
	g_application_set_flags ((GApplication*) self, _tmp2_ | G_APPLICATION_HANDLES_COMMAND_LINE);
#line 106 "../src/bookworm.vala"
	_tmp3_ = g_strdup (BOOKWORM_APP_CONSTANTS_program_name);
#line 106 "../src/bookworm.vala"
	_g_free0 (((GraniteApplication*) self)->program_name);
#line 106 "../src/bookworm.vala"
	((GraniteApplication*) self)->program_name = _tmp3_;
#line 107 "../src/bookworm.vala"
	_tmp4_ = g_strdup (BOOKWORM_APP_CONSTANTS_bookworm_id);
#line 107 "../src/bookworm.vala"
	_g_free0 (((GraniteApplication*) self)->exec_name);
#line 107 "../src/bookworm.vala"
	((GraniteApplication*) self)->exec_name = _tmp4_;
#line 109 "../src/bookworm.vala"
	_tmp5_ = g_new0 (GOptionEntry, 4);
#line 109 "../src/bookworm.vala"
	bookworm_app_bookworm_options = (g_free (bookworm_app_bookworm_options), NULL);
#line 109 "../src/bookworm.vala"
	bookworm_app_bookworm_options = _tmp5_;
#line 109 "../src/bookworm.vala"
	bookworm_app_bookworm_options_length1 = 4;
#line 109 "../src/bookworm.vala"
	_bookworm_app_bookworm_options_size_ = bookworm_app_bookworm_options_length1;
#line 110 "../src/bookworm.vala"
	_tmp6_ = bookworm_app_bookworm_options;
#line 110 "../src/bookworm.vala"
	_tmp6__length1 = bookworm_app_bookworm_options_length1;
#line 110 "../src/bookworm.vala"
	_tmp7_.long_name = "version";
#line 110 "../src/bookworm.vala"
	_tmp7_.short_name = (gchar) 0;
#line 110 "../src/bookworm.vala"
	_tmp7_.flags = (gint) 0;
#line 110 "../src/bookworm.vala"
	_tmp7_.arg = G_OPTION_ARG_NONE;
#line 110 "../src/bookworm.vala"
	_tmp7_.arg_data = &bookworm_app_bookworm_command_line_option_version;
#line 110 "../src/bookworm.vala"
	_tmp7_.description = _ ("Display version number");
#line 110 "../src/bookworm.vala"
	_tmp7_.arg_description = NULL;
#line 110 "../src/bookworm.vala"
	_tmp6_[0] = _tmp7_;
#line 111 "../src/bookworm.vala"
	_tmp8_ = bookworm_app_bookworm_options;
#line 111 "../src/bookworm.vala"
	_tmp8__length1 = bookworm_app_bookworm_options_length1;
#line 111 "../src/bookworm.vala"
	_tmp9_.long_name = "debug";
#line 111 "../src/bookworm.vala"
	_tmp9_.short_name = (gchar) 0;
#line 111 "../src/bookworm.vala"
	_tmp9_.flags = (gint) 0;
#line 111 "../src/bookworm.vala"
	_tmp9_.arg = G_OPTION_ARG_NONE;
#line 111 "../src/bookworm.vala"
	_tmp9_.arg_data = &bookworm_app_bookworm_command_line_option_debug;
#line 111 "../src/bookworm.vala"
	_tmp9_.description = _ ("Run Bookworm in debug mode");
#line 111 "../src/bookworm.vala"
	_tmp9_.arg_description = NULL;
#line 111 "../src/bookworm.vala"
	_tmp8_[1] = _tmp9_;
#line 112 "../src/bookworm.vala"
	_tmp10_ = bookworm_app_bookworm_options;
#line 112 "../src/bookworm.vala"
	_tmp10__length1 = bookworm_app_bookworm_options_length1;
#line 112 "../src/bookworm.vala"
	_tmp11_.long_name = "info";
#line 112 "../src/bookworm.vala"
	_tmp11_.short_name = (gchar) 0;
#line 112 "../src/bookworm.vala"
	_tmp11_.flags = (gint) 0;
#line 112 "../src/bookworm.vala"
	_tmp11_.arg = G_OPTION_ARG_NONE;
#line 112 "../src/bookworm.vala"
	_tmp11_.arg_data = &bookworm_app_bookworm_command_line_option_info;
#line 112 "../src/bookworm.vala"
	_tmp11_.description = _ ("Run Bookworm in info mode");
#line 112 "../src/bookworm.vala"
	_tmp11_.arg_description = NULL;
#line 112 "../src/bookworm.vala"
	_tmp10_[2] = _tmp11_;
#line 113 "../src/bookworm.vala"
	_tmp12_ = bookworm_app_bookworm_options;
#line 113 "../src/bookworm.vala"
	_tmp12__length1 = bookworm_app_bookworm_options_length1;
#line 113 "../src/bookworm.vala"
	_tmp13_.long_name = "discover";
#line 113 "../src/bookworm.vala"
	_tmp13_.short_name = (gchar) 0;
#line 113 "../src/bookworm.vala"
	_tmp13_.flags = (gint) 0;
#line 113 "../src/bookworm.vala"
	_tmp13_.arg = G_OPTION_ARG_NONE;
#line 113 "../src/bookworm.vala"
	_tmp13_.arg_data = &bookworm_app_bookworm_command_line_option_discover;
#line 113 "../src/bookworm.vala"
	_tmp13_.description = _ ("Automatically add new books from watched folders");
#line 113 "../src/bookworm.vala"
	_tmp13_.arg_description = NULL;
#line 113 "../src/bookworm.vala"
	_tmp12_[3] = _tmp13_;
#line 114 "../src/bookworm.vala"
	_tmp14_ = bookworm_app_bookworm_options;
#line 114 "../src/bookworm.vala"
	_tmp14__length1 = bookworm_app_bookworm_options_length1;
#line 114 "../src/bookworm.vala"
	g_application_add_main_option_entries ((GApplication*) self, _tmp14_);
#line 102 "../src/bookworm.vala"
	return obj;
#line 5322 "bookworm.c"
}

static void
bookworm_app_bookworm_class_init (BookwormAppBookwormClass * klass,
                                  gpointer klass_data)
{
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GeeHashMap* _tmp3_;
	gchar* _tmp4_;
	GString* _tmp5_;
	GString* _tmp6_;
	GString* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GeeTreeMap* _tmp10_;
	GString* _tmp11_;
	gchar* _tmp12_;
	GeeArrayList* _tmp13_;
#line 25 "../src/bookworm.vala"
	bookworm_app_bookworm_parent_class = g_type_class_peek_parent (klass);
#line 25 "../src/bookworm.vala"
	((GApplicationClass *) klass)->command_line = (gint (*) (GApplication*, GApplicationCommandLine*)) bookworm_app_bookworm_real_command_line;
#line 25 "../src/bookworm.vala"
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) bookworm_app_bookworm_real_activate;
#line 25 "../src/bookworm.vala"
	((GApplicationClass *) klass)->open = (void (*) (GApplication*, GFile**, gint, const gchar*)) bookworm_app_bookworm_real_open;
#line 25 "../src/bookworm.vala"
	G_OBJECT_CLASS (klass)->constructor = bookworm_app_bookworm_constructor;
#line 25 "../src/bookworm.vala"
	G_OBJECT_CLASS (klass)->finalize = bookworm_app_bookworm_finalize;
#line 30 "../src/bookworm.vala"
	_tmp0_ = g_strdup ("");
#line 30 "../src/bookworm.vala"
	bookworm_app_bookworm_bookworm_config_path = _tmp0_;
#line 83 "../src/bookworm.vala"
	_tmp1_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[0];
#line 83 "../src/bookworm.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 83 "../src/bookworm.vala"
	bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp2_;
#line 84 "../src/bookworm.vala"
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, BOOKWORM_APP_TYPE_BOOK, (GBoxedCopyFunc) bookworm_app_book_ref, (GDestroyNotify) bookworm_app_book_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 84 "../src/bookworm.vala"
	bookworm_app_bookworm_libraryViewMap = _tmp3_;
#line 85 "../src/bookworm.vala"
	_tmp4_ = g_strdup ("");
#line 85 "../src/bookworm.vala"
	bookworm_app_bookworm_locationOfEBookCurrentlyRead = _tmp4_;
#line 90 "../src/bookworm.vala"
	_tmp5_ = g_string_new ("");
#line 90 "../src/bookworm.vala"
	bookworm_app_bookworm_pathsOfBooksInLibraryOnLoadStr = _tmp5_;
#line 91 "../src/bookworm.vala"
	_tmp6_ = g_string_new ("");
#line 91 "../src/bookworm.vala"
	bookworm_app_bookworm_pathsOfBooksNotAddedStr = _tmp6_;
#line 92 "../src/bookworm.vala"
	_tmp7_ = g_string_new ("");
#line 92 "../src/bookworm.vala"
	bookworm_app_bookworm_onLoadJavaScript = _tmp7_;
#line 93 "../src/bookworm.vala"
	_tmp8_ = g_strdup ("");
#line 93 "../src/bookworm.vala"
	bookworm_app_bookworm_bookwormScripts = _tmp8_;
#line 94 "../src/bookworm.vala"
	_tmp9_ = g_strdup ("");
#line 94 "../src/bookworm.vala"
	bookworm_app_bookworm_bookTextSearchString = _tmp9_;
#line 95 "../src/bookworm.vala"
	_tmp10_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 95 "../src/bookworm.vala"
	bookworm_app_bookworm_searchResultsMap = _tmp10_;
#line 96 "../src/bookworm.vala"
	_tmp11_ = g_string_new ("");
#line 96 "../src/bookworm.vala"
	bookworm_app_bookworm_aContentFileToBeSearched = _tmp11_;
#line 98 "../src/bookworm.vala"
	_tmp12_ = g_strdup ("21");
#line 98 "../src/bookworm.vala"
	bookworm_app_bookworm_no_of_books_per_page = _tmp12_;
#line 99 "../src/bookworm.vala"
	_tmp13_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 99 "../src/bookworm.vala"
	bookworm_app_bookworm_paginationlist = _tmp13_;
#line 5409 "bookworm.c"
}

static void
bookworm_app_bookworm_instance_init (BookwormAppBookworm * self,
                                     gpointer klass)
{
	GString* _tmp0_;
#line 28 "../src/bookworm.vala"
	self->exitCodeForCommand = 0;
#line 39 "../src/bookworm.vala"
	_tmp0_ = g_string_new ("");
#line 39 "../src/bookworm.vala"
	self->spawn_async_with_pipes_output = _tmp0_;
#line 5423 "bookworm.c"
}

static void
bookworm_app_bookworm_finalize (GObject * obj)
{
	BookwormAppBookworm * self;
#line 25 "../src/bookworm.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOOKWORM_APP_TYPE_BOOKWORM, BookwormAppBookworm);
#line 39 "../src/bookworm.vala"
	_g_string_free0 (self->spawn_async_with_pipes_output);
#line 25 "../src/bookworm.vala"
	G_OBJECT_CLASS (bookworm_app_bookworm_parent_class)->finalize (obj);
#line 5436 "bookworm.c"
}

static GType
bookworm_app_bookworm_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BookwormAppBookwormClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookworm_app_bookworm_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookwormAppBookworm), 0, (GInstanceInitFunc) bookworm_app_bookworm_instance_init, NULL };
	GType bookworm_app_bookworm_type_id;
	bookworm_app_bookworm_type_id = g_type_register_static (GRANITE_TYPE_APPLICATION, "BookwormAppBookworm", &g_define_type_info, 0);
	return bookworm_app_bookworm_type_id;
}

GType
bookworm_app_bookworm_get_type (void)
{
	static volatile gsize bookworm_app_bookworm_type_id__once = 0;
	if (g_once_init_enter (&bookworm_app_bookworm_type_id__once)) {
		GType bookworm_app_bookworm_type_id;
		bookworm_app_bookworm_type_id = bookworm_app_bookworm_get_type_once ();
		g_once_init_leave (&bookworm_app_bookworm_type_id__once, bookworm_app_bookworm_type_id);
	}
	return bookworm_app_bookworm_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

