/* src/bazaar.p/bz-safety-row.h
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <glib-object.h>
#include "bz-context-row.h"

G_BEGIN_DECLS



#define BZ_TYPE_SAFETY_ROW (bz_safety_row_get_type ())
G_DECLARE_FINAL_TYPE (BzSafetyRow, bz_safety_row, BZ, SAFETY_ROW, GObject)

BzSafetyRow *
bz_safety_row_new (void);

BzImportance
bz_safety_row_get_importance (BzSafetyRow *self);

const char *
bz_safety_row_get_title (BzSafetyRow *self);

const char *
bz_safety_row_get_subtitle (BzSafetyRow *self);

const char *
bz_safety_row_get_icon_name (BzSafetyRow *self);

void
bz_safety_row_set_importance (BzSafetyRow *self,
    BzImportance importance);

void
bz_safety_row_set_title (BzSafetyRow *self,
    const char *title);

void
bz_safety_row_set_subtitle (BzSafetyRow *self,
    const char *subtitle);

void
bz_safety_row_set_icon_name (BzSafetyRow *self,
    const char *icon_name);

G_END_DECLS

/* End of src/bazaar.p/bz-safety-row.h */
