/* src/bazaar.p/bz-curated-image-info.h
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <glib-object.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS



#define BZ_TYPE_CURATED_IMAGE_INFO (bz_curated_image_info_get_type ())
G_DECLARE_FINAL_TYPE (BzCuratedImageInfo, bz_curated_image_info, BZ, CURATED_IMAGE_INFO, GObject)

BzCuratedImageInfo *
bz_curated_image_info_new (void);

const char *
bz_curated_image_info_get_uri (BzCuratedImageInfo *self);

const char *
bz_curated_image_info_get_light_uri (BzCuratedImageInfo *self);

const char *
bz_curated_image_info_get_dark_uri (BzCuratedImageInfo *self);

int
bz_curated_image_info_get_width (BzCuratedImageInfo *self);

int
bz_curated_image_info_get_height (BzCuratedImageInfo *self);

gboolean
bz_curated_image_info_get_can_shrink (BzCuratedImageInfo *self);

GtkContentFit
bz_curated_image_info_get_fit (BzCuratedImageInfo *self);

void
bz_curated_image_info_set_uri (BzCuratedImageInfo *self,
    const char *uri);

void
bz_curated_image_info_set_light_uri (BzCuratedImageInfo *self,
    const char *light_uri);

void
bz_curated_image_info_set_dark_uri (BzCuratedImageInfo *self,
    const char *dark_uri);

void
bz_curated_image_info_set_width (BzCuratedImageInfo *self,
    int width);

void
bz_curated_image_info_set_height (BzCuratedImageInfo *self,
    int height);

void
bz_curated_image_info_set_can_shrink (BzCuratedImageInfo *self,
    gboolean can_shrink);

void
bz_curated_image_info_set_fit (BzCuratedImageInfo *self,
    GtkContentFit fit);

G_END_DECLS

/* End of src/bazaar.p/bz-curated-image-info.h */
