/******************************************************************************
  This source file is part of the Avogadro project.
  This source code is released under the 3-Clause BSD License, (see "LICENSE").
******************************************************************************/

#include <QtCore/QtPlugin>

#include "/build/avogadrolibs/src/avogadrolibs/avogadro/qtplugins/plotconformer/plotconformer.h"


namespace Avogadro::QtPlugins {

class PlotConformerFactory : public QObject, public QtGui::ExtensionPluginFactory
{
  Q_OBJECT
  Q_PLUGIN_METADATA(IID "org.openchemistry.avogadro.ExtensionPluginFactory")
  Q_INTERFACES(Avogadro::QtGui::ExtensionPluginFactory)

public:
  explicit PlotConformerFactory(QObject* parent_ = nullptr) : QObject(parent_) {}

  QtGui::ExtensionPlugin* createInstance(QObject* parent_ = nullptr) override
  {
    auto* object = new PlotConformer(parent_);
    object->setObjectName("PlotConformer");
    return object;
  }

  QString identifier() const override { return "PlotConformer"; }

  QString description() const override { return "Create Conformer plots (RMSD and Energy)."; }

};

} // namespace Avogadro::QtPlugins

#include "PlotConformerPlugin.moc"
