/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|*  * MSP430 Disassembler                                                     *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#include "llvm/MC/MCInst.h"
#include "llvm/MC/MCSubtargetInfo.h"
#include "llvm/Support/DataTypes.h"
#include "llvm/Support/Debug.h"
#include "llvm/Support/LEB128.h"
#include "llvm/Support/raw_ostream.h"
#include "llvm/TargetParser/SubtargetFeature.h"
#include <assert.h>

namespace {

// Helper functions for extracting fields from encoded instructions.
// InsnType must either be integral or an APInt-like object that must:
// * be default-constructible and copy-constructible
// * Support extractBitsAsZExtValue(numBits, startBit)
// * Support the ~, &, ==, and != operators with other objects of the same type
// * Support the != and bitwise & with uint64_t
template <typename InsnType>
#if defined(_MSC_VER) && !defined(__clang__)
__declspec(noinline)
#endif
static std::enable_if_t<std::is_integral<InsnType>::value, InsnType>
fieldFromInstruction(const InsnType &insn, unsigned startBit,
                     unsigned numBits) {
  assert(startBit + numBits <= 64 && "Cannot support >64-bit extractions!");
  assert(startBit + numBits <= (sizeof(InsnType) * 8) &&
         "Instruction field out of bounds!");
  InsnType fieldMask;
  if (numBits == sizeof(InsnType) * 8)
    fieldMask = (InsnType)(-1LL);
  else
    fieldMask = (((InsnType)1 << numBits) - 1) << startBit;
  return (insn & fieldMask) >> startBit;
}

template <typename InsnType>
static std::enable_if_t<!std::is_integral<InsnType>::value, uint64_t>
fieldFromInstruction(const InsnType &insn, unsigned startBit,
                     unsigned numBits) {
  return insn.extractBitsAsZExtValue(numBits, startBit);
}

// Helper function for inserting bits extracted from an encoded instruction into
// an integer-typed field.
template <typename IntType>
static std::enable_if_t<std::is_integral_v<IntType>, void>
insertBits(IntType &field, IntType bits, unsigned startBit, unsigned numBits) {
  // Check that no bit beyond numBits is set, so that a simple bitwise |
  // is sufficient.
  assert((~(((IntType)1 << numBits) - 1) & bits) == 0 &&
           "bits has more than numBits bits set");
  assert(startBit + numBits <= sizeof(IntType) * 8);
  (void)numBits;
  field |= bits << startBit;
}

static bool Check(DecodeStatus &Out, DecodeStatus In) {
  Out = static_cast<DecodeStatus>(Out & In);
  return Out != MCDisassembler::Fail;
}

static const uint8_t DecoderTable16[] = {
/* 0 */       MCD::OPC_ExtractField, 13, 3,  // Inst{15-13} ...
/* 3 */       MCD::OPC_FilterValue, 0, 246, 0, // Skip to: 253
/* 7 */       MCD::OPC_ExtractField, 6, 7,  // Inst{12-6} ...
/* 10 */      MCD::OPC_FilterValue, 64, 25, 0, // Skip to: 39
/* 14 */      MCD::OPC_ExtractField, 4, 2,  // Inst{5-4} ...
/* 17 */      MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 25
/* 21 */      MCD::OPC_Decode, 177, 4, 0, // Opcode: RRC16r, DecodeIdx: 0
/* 25 */      MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 33
/* 29 */      MCD::OPC_Decode, 175, 4, 1, // Opcode: RRC16n, DecodeIdx: 1
/* 33 */      MCD::OPC_FilterValueOrFail, 3, 
/* 35 */      MCD::OPC_Decode, 176, 4, 1, // Opcode: RRC16p, DecodeIdx: 1
/* 39 */      MCD::OPC_FilterValue, 65, 25, 0, // Skip to: 68
/* 43 */      MCD::OPC_ExtractField, 4, 2,  // Inst{5-4} ...
/* 46 */      MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 54
/* 50 */      MCD::OPC_Decode, 181, 4, 2, // Opcode: RRC8r, DecodeIdx: 2
/* 54 */      MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 62
/* 58 */      MCD::OPC_Decode, 179, 4, 1, // Opcode: RRC8n, DecodeIdx: 1
/* 62 */      MCD::OPC_FilterValueOrFail, 3, 
/* 64 */      MCD::OPC_Decode, 180, 4, 1, // Opcode: RRC8p, DecodeIdx: 1
/* 68 */      MCD::OPC_FilterValue, 66, 25, 0, // Skip to: 97
/* 72 */      MCD::OPC_ExtractField, 4, 2,  // Inst{5-4} ...
/* 75 */      MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 83
/* 79 */      MCD::OPC_Decode, 239, 4, 0, // Opcode: SWPB16r, DecodeIdx: 0
/* 83 */      MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 91
/* 87 */      MCD::OPC_Decode, 237, 4, 1, // Opcode: SWPB16n, DecodeIdx: 1
/* 91 */      MCD::OPC_FilterValueOrFail, 3, 
/* 93 */      MCD::OPC_Decode, 238, 4, 1, // Opcode: SWPB16p, DecodeIdx: 1
/* 97 */      MCD::OPC_FilterValue, 68, 25, 0, // Skip to: 126
/* 101 */     MCD::OPC_ExtractField, 4, 2,  // Inst{5-4} ...
/* 104 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 112
/* 108 */     MCD::OPC_Decode, 169, 4, 0, // Opcode: RRA16r, DecodeIdx: 0
/* 112 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 120
/* 116 */     MCD::OPC_Decode, 167, 4, 1, // Opcode: RRA16n, DecodeIdx: 1
/* 120 */     MCD::OPC_FilterValueOrFail, 3, 
/* 122 */     MCD::OPC_Decode, 168, 4, 1, // Opcode: RRA16p, DecodeIdx: 1
/* 126 */     MCD::OPC_FilterValue, 69, 25, 0, // Skip to: 155
/* 130 */     MCD::OPC_ExtractField, 4, 2,  // Inst{5-4} ...
/* 133 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 141
/* 137 */     MCD::OPC_Decode, 173, 4, 2, // Opcode: RRA8r, DecodeIdx: 2
/* 141 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 149
/* 145 */     MCD::OPC_Decode, 171, 4, 1, // Opcode: RRA8n, DecodeIdx: 1
/* 149 */     MCD::OPC_FilterValueOrFail, 3, 
/* 151 */     MCD::OPC_Decode, 172, 4, 1, // Opcode: RRA8p, DecodeIdx: 1
/* 155 */     MCD::OPC_FilterValue, 70, 25, 0, // Skip to: 184
/* 159 */     MCD::OPC_ExtractField, 4, 2,  // Inst{5-4} ...
/* 162 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 170
/* 166 */     MCD::OPC_Decode, 187, 4, 0, // Opcode: SEXT16r, DecodeIdx: 0
/* 170 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 178
/* 174 */     MCD::OPC_Decode, 185, 4, 1, // Opcode: SEXT16n, DecodeIdx: 1
/* 178 */     MCD::OPC_FilterValueOrFail, 3, 
/* 180 */     MCD::OPC_Decode, 186, 4, 1, // Opcode: SEXT16p, DecodeIdx: 1
/* 184 */     MCD::OPC_FilterValue, 72, 14, 0, // Skip to: 202
/* 188 */     MCD::OPC_CheckField, 4, 2, 0, 4, 0, // Skip to: 198
/* 194 */     MCD::OPC_Decode, 162, 4, 1, // Opcode: PUSH16r, DecodeIdx: 1
/* 198 */     MCD::OPC_Decode, 160, 4, 3, // Opcode: PUSH16c, DecodeIdx: 3
/* 202 */     MCD::OPC_FilterValue, 73, 8, 0, // Skip to: 214
/* 206 */     MCD::OPC_CheckFieldOrFail, 4, 2, 0, 
/* 210 */     MCD::OPC_Decode, 163, 4, 4, // Opcode: PUSH8r, DecodeIdx: 4
/* 214 */     MCD::OPC_FilterValue, 74, 25, 0, // Skip to: 243
/* 218 */     MCD::OPC_ExtractField, 4, 2,  // Inst{5-4} ...
/* 221 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 229
/* 225 */     MCD::OPC_Decode, 212, 3, 1, // Opcode: CALLr, DecodeIdx: 1
/* 229 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 237
/* 233 */     MCD::OPC_Decode, 210, 3, 1, // Opcode: CALLn, DecodeIdx: 1
/* 237 */     MCD::OPC_FilterValueOrFail, 3, 
/* 239 */     MCD::OPC_Decode, 211, 3, 1, // Opcode: CALLp, DecodeIdx: 1
/* 243 */     MCD::OPC_FilterValueOrFail, 76, 
/* 245 */     MCD::OPC_CheckFieldOrFail, 0, 6, 0, 
/* 249 */     MCD::OPC_Decode, 165, 4, 5, // Opcode: RETI, DecodeIdx: 5
/* 253 */     MCD::OPC_FilterValueOrFail, 1, 
/* 255 */     MCD::OPC_CheckField, 10, 3, 7, 4, 0, // Skip to: 265
/* 261 */     MCD::OPC_Decode, 134, 4, 6, // Opcode: JMP, DecodeIdx: 6
/* 265 */     MCD::OPC_Decode, 133, 4, 7, // Opcode: JCC, DecodeIdx: 7
/* 269 */     MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTable32[] = {
/* 0 */       MCD::OPC_ExtractField, 4, 12,  // Inst{15-4} ...
/* 3 */       MCD::OPC_FilterValue, 129, 2, 4, 0, // Skip to: 12
/* 8 */       MCD::OPC_Decode, 174, 4, 8, // Opcode: RRC16m, DecodeIdx: 8
/* 12 */      MCD::OPC_FilterValue, 133, 2, 4, 0, // Skip to: 21
/* 17 */      MCD::OPC_Decode, 178, 4, 8, // Opcode: RRC8m, DecodeIdx: 8
/* 21 */      MCD::OPC_FilterValue, 137, 2, 4, 0, // Skip to: 30
/* 26 */      MCD::OPC_Decode, 236, 4, 8, // Opcode: SWPB16m, DecodeIdx: 8
/* 30 */      MCD::OPC_FilterValue, 145, 2, 4, 0, // Skip to: 39
/* 35 */      MCD::OPC_Decode, 166, 4, 8, // Opcode: RRA16m, DecodeIdx: 8
/* 39 */      MCD::OPC_FilterValue, 149, 2, 4, 0, // Skip to: 48
/* 44 */      MCD::OPC_Decode, 170, 4, 8, // Opcode: RRA8m, DecodeIdx: 8
/* 48 */      MCD::OPC_FilterValue, 153, 2, 4, 0, // Skip to: 57
/* 53 */      MCD::OPC_Decode, 184, 4, 8, // Opcode: SEXT16m, DecodeIdx: 8
/* 57 */      MCD::OPC_FilterValue, 163, 2, 8, 0, // Skip to: 70
/* 62 */      MCD::OPC_CheckFieldOrFail, 0, 4, 0, 
/* 66 */      MCD::OPC_Decode, 161, 4, 9, // Opcode: PUSH16i, DecodeIdx: 9
/* 70 */      MCD::OPC_FilterValue, 169, 2, 4, 0, // Skip to: 79
/* 75 */      MCD::OPC_Decode, 209, 3, 8, // Opcode: CALLm, DecodeIdx: 8
/* 79 */      MCD::OPC_FilterValueOrFail, 171, 2, 
/* 82 */      MCD::OPC_CheckFieldOrFail, 0, 4, 0, 
/* 86 */      MCD::OPC_Decode, 208, 3, 9, // Opcode: CALLi, DecodeIdx: 9
/* 90 */      MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableAlpha16[] = {
/* 0 */       MCD::OPC_ExtractField, 12, 4,  // Inst{15-12} ...
/* 3 */       MCD::OPC_FilterValue, 4, 27, 0, // Skip to: 34
/* 7 */       MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 10 */      MCD::OPC_FilterValue, 0, 14, 0, // Skip to: 28
/* 14 */      MCD::OPC_CheckField, 0, 4, 0, 4, 0, // Skip to: 24
/* 20 */      MCD::OPC_Decode, 207, 3, 10, // Opcode: Br, DecodeIdx: 10
/* 24 */      MCD::OPC_Decode, 145, 4, 11, // Opcode: MOV16rr, DecodeIdx: 11
/* 28 */      MCD::OPC_FilterValueOrFail, 4, 
/* 30 */      MCD::OPC_Decode, 156, 4, 12, // Opcode: MOV8rr, DecodeIdx: 12
/* 34 */      MCD::OPC_FilterValue, 5, 17, 0, // Skip to: 55
/* 38 */      MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 41 */      MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 49
/* 45 */      MCD::OPC_Decode, 197, 2, 13, // Opcode: ADD16rr, DecodeIdx: 13
/* 49 */      MCD::OPC_FilterValueOrFail, 4, 
/* 51 */      MCD::OPC_Decode, 209, 2, 14, // Opcode: ADD8rr, DecodeIdx: 14
/* 55 */      MCD::OPC_FilterValue, 6, 17, 0, // Skip to: 76
/* 59 */      MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 62 */      MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 70
/* 66 */      MCD::OPC_Decode, 221, 2, 13, // Opcode: ADDC16rr, DecodeIdx: 13
/* 70 */      MCD::OPC_FilterValueOrFail, 4, 
/* 72 */      MCD::OPC_Decode, 233, 2, 14, // Opcode: ADDC8rr, DecodeIdx: 14
/* 76 */      MCD::OPC_FilterValue, 7, 17, 0, // Skip to: 97
/* 80 */      MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 83 */      MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 91
/* 87 */      MCD::OPC_Decode, 223, 4, 13, // Opcode: SUBC16rr, DecodeIdx: 13
/* 91 */      MCD::OPC_FilterValueOrFail, 4, 
/* 93 */      MCD::OPC_Decode, 235, 4, 14, // Opcode: SUBC8rr, DecodeIdx: 14
/* 97 */      MCD::OPC_FilterValue, 8, 17, 0, // Skip to: 118
/* 101 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 104 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 112
/* 108 */     MCD::OPC_Decode, 199, 4, 13, // Opcode: SUB16rr, DecodeIdx: 13
/* 112 */     MCD::OPC_FilterValueOrFail, 4, 
/* 114 */     MCD::OPC_Decode, 211, 4, 14, // Opcode: SUB8rr, DecodeIdx: 14
/* 118 */     MCD::OPC_FilterValue, 9, 17, 0, // Skip to: 139
/* 122 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 125 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 133
/* 129 */     MCD::OPC_Decode, 224, 3, 11, // Opcode: CMP16rr, DecodeIdx: 11
/* 133 */     MCD::OPC_FilterValueOrFail, 4, 
/* 135 */     MCD::OPC_Decode, 236, 3, 12, // Opcode: CMP8rr, DecodeIdx: 12
/* 139 */     MCD::OPC_FilterValue, 10, 17, 0, // Skip to: 160
/* 143 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 146 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 154
/* 150 */     MCD::OPC_Decode, 248, 3, 13, // Opcode: DADD16rr, DecodeIdx: 13
/* 154 */     MCD::OPC_FilterValueOrFail, 4, 
/* 156 */     MCD::OPC_Decode, 132, 4, 14, // Opcode: DADD8rr, DecodeIdx: 14
/* 160 */     MCD::OPC_FilterValue, 11, 17, 0, // Skip to: 181
/* 164 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 167 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 175
/* 171 */     MCD::OPC_Decode, 192, 3, 11, // Opcode: BIT16rr, DecodeIdx: 11
/* 175 */     MCD::OPC_FilterValueOrFail, 4, 
/* 177 */     MCD::OPC_Decode, 204, 3, 12, // Opcode: BIT8rr, DecodeIdx: 12
/* 181 */     MCD::OPC_FilterValue, 12, 17, 0, // Skip to: 202
/* 185 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 188 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 196
/* 192 */     MCD::OPC_Decode, 144, 3, 13, // Opcode: BIC16rr, DecodeIdx: 13
/* 196 */     MCD::OPC_FilterValueOrFail, 4, 
/* 198 */     MCD::OPC_Decode, 156, 3, 14, // Opcode: BIC8rr, DecodeIdx: 14
/* 202 */     MCD::OPC_FilterValue, 13, 17, 0, // Skip to: 223
/* 206 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 209 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 217
/* 213 */     MCD::OPC_Decode, 168, 3, 13, // Opcode: BIS16rr, DecodeIdx: 13
/* 217 */     MCD::OPC_FilterValueOrFail, 4, 
/* 219 */     MCD::OPC_Decode, 180, 3, 14, // Opcode: BIS8rr, DecodeIdx: 14
/* 223 */     MCD::OPC_FilterValue, 14, 17, 0, // Skip to: 244
/* 227 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 230 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 238
/* 234 */     MCD::OPC_Decode, 131, 5, 13, // Opcode: XOR16rr, DecodeIdx: 13
/* 238 */     MCD::OPC_FilterValueOrFail, 4, 
/* 240 */     MCD::OPC_Decode, 143, 5, 14, // Opcode: XOR8rr, DecodeIdx: 14
/* 244 */     MCD::OPC_FilterValueOrFail, 15, 
/* 246 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 249 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 257
/* 253 */     MCD::OPC_Decode, 248, 2, 13, // Opcode: AND16rr, DecodeIdx: 13
/* 257 */     MCD::OPC_FilterValueOrFail, 4, 
/* 259 */     MCD::OPC_Decode, 132, 3, 14, // Opcode: AND8rr, DecodeIdx: 14
/* 263 */     MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableAlpha32[] = {
/* 0 */       MCD::OPC_ExtractField, 12, 4,  // Inst{15-12} ...
/* 3 */       MCD::OPC_FilterValue, 4, 17, 0, // Skip to: 24
/* 7 */       MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 10 */      MCD::OPC_FilterValue, 8, 4, 0, // Skip to: 18
/* 14 */      MCD::OPC_Decode, 139, 4, 15, // Opcode: MOV16mr, DecodeIdx: 15
/* 18 */      MCD::OPC_FilterValueOrFail, 12, 
/* 20 */      MCD::OPC_Decode, 150, 4, 16, // Opcode: MOV8mr, DecodeIdx: 16
/* 24 */      MCD::OPC_FilterValue, 5, 17, 0, // Skip to: 45
/* 28 */      MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 31 */      MCD::OPC_FilterValue, 8, 4, 0, // Skip to: 39
/* 35 */      MCD::OPC_Decode, 191, 2, 15, // Opcode: ADD16mr, DecodeIdx: 15
/* 39 */      MCD::OPC_FilterValueOrFail, 12, 
/* 41 */      MCD::OPC_Decode, 203, 2, 16, // Opcode: ADD8mr, DecodeIdx: 16
/* 45 */      MCD::OPC_FilterValue, 6, 17, 0, // Skip to: 66
/* 49 */      MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 52 */      MCD::OPC_FilterValue, 8, 4, 0, // Skip to: 60
/* 56 */      MCD::OPC_Decode, 215, 2, 15, // Opcode: ADDC16mr, DecodeIdx: 15
/* 60 */      MCD::OPC_FilterValueOrFail, 12, 
/* 62 */      MCD::OPC_Decode, 227, 2, 16, // Opcode: ADDC8mr, DecodeIdx: 16
/* 66 */      MCD::OPC_FilterValue, 7, 17, 0, // Skip to: 87
/* 70 */      MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 73 */      MCD::OPC_FilterValue, 8, 4, 0, // Skip to: 81
/* 77 */      MCD::OPC_Decode, 217, 4, 15, // Opcode: SUBC16mr, DecodeIdx: 15
/* 81 */      MCD::OPC_FilterValueOrFail, 12, 
/* 83 */      MCD::OPC_Decode, 229, 4, 16, // Opcode: SUBC8mr, DecodeIdx: 16
/* 87 */      MCD::OPC_FilterValue, 8, 17, 0, // Skip to: 108
/* 91 */      MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 94 */      MCD::OPC_FilterValue, 8, 4, 0, // Skip to: 102
/* 98 */      MCD::OPC_Decode, 193, 4, 15, // Opcode: SUB16mr, DecodeIdx: 15
/* 102 */     MCD::OPC_FilterValueOrFail, 12, 
/* 104 */     MCD::OPC_Decode, 205, 4, 16, // Opcode: SUB8mr, DecodeIdx: 16
/* 108 */     MCD::OPC_FilterValue, 9, 17, 0, // Skip to: 129
/* 112 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 115 */     MCD::OPC_FilterValue, 8, 4, 0, // Skip to: 123
/* 119 */     MCD::OPC_Decode, 218, 3, 15, // Opcode: CMP16mr, DecodeIdx: 15
/* 123 */     MCD::OPC_FilterValueOrFail, 12, 
/* 125 */     MCD::OPC_Decode, 230, 3, 16, // Opcode: CMP8mr, DecodeIdx: 16
/* 129 */     MCD::OPC_FilterValue, 10, 17, 0, // Skip to: 150
/* 133 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 136 */     MCD::OPC_FilterValue, 8, 4, 0, // Skip to: 144
/* 140 */     MCD::OPC_Decode, 242, 3, 15, // Opcode: DADD16mr, DecodeIdx: 15
/* 144 */     MCD::OPC_FilterValueOrFail, 12, 
/* 146 */     MCD::OPC_Decode, 254, 3, 16, // Opcode: DADD8mr, DecodeIdx: 16
/* 150 */     MCD::OPC_FilterValue, 11, 17, 0, // Skip to: 171
/* 154 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 157 */     MCD::OPC_FilterValue, 8, 4, 0, // Skip to: 165
/* 161 */     MCD::OPC_Decode, 186, 3, 15, // Opcode: BIT16mr, DecodeIdx: 15
/* 165 */     MCD::OPC_FilterValueOrFail, 12, 
/* 167 */     MCD::OPC_Decode, 198, 3, 16, // Opcode: BIT8mr, DecodeIdx: 16
/* 171 */     MCD::OPC_FilterValue, 12, 17, 0, // Skip to: 192
/* 175 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 178 */     MCD::OPC_FilterValue, 8, 4, 0, // Skip to: 186
/* 182 */     MCD::OPC_Decode, 138, 3, 15, // Opcode: BIC16mr, DecodeIdx: 15
/* 186 */     MCD::OPC_FilterValueOrFail, 12, 
/* 188 */     MCD::OPC_Decode, 150, 3, 16, // Opcode: BIC8mr, DecodeIdx: 16
/* 192 */     MCD::OPC_FilterValue, 13, 17, 0, // Skip to: 213
/* 196 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 199 */     MCD::OPC_FilterValue, 8, 4, 0, // Skip to: 207
/* 203 */     MCD::OPC_Decode, 162, 3, 15, // Opcode: BIS16mr, DecodeIdx: 15
/* 207 */     MCD::OPC_FilterValueOrFail, 12, 
/* 209 */     MCD::OPC_Decode, 174, 3, 16, // Opcode: BIS8mr, DecodeIdx: 16
/* 213 */     MCD::OPC_FilterValue, 14, 17, 0, // Skip to: 234
/* 217 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 220 */     MCD::OPC_FilterValue, 8, 4, 0, // Skip to: 228
/* 224 */     MCD::OPC_Decode, 253, 4, 15, // Opcode: XOR16mr, DecodeIdx: 15
/* 228 */     MCD::OPC_FilterValueOrFail, 12, 
/* 230 */     MCD::OPC_Decode, 137, 5, 16, // Opcode: XOR8mr, DecodeIdx: 16
/* 234 */     MCD::OPC_FilterValueOrFail, 15, 
/* 236 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 239 */     MCD::OPC_FilterValue, 8, 4, 0, // Skip to: 247
/* 243 */     MCD::OPC_Decode, 242, 2, 15, // Opcode: AND16mr, DecodeIdx: 15
/* 247 */     MCD::OPC_FilterValueOrFail, 12, 
/* 249 */     MCD::OPC_Decode, 254, 2, 16, // Opcode: AND8mr, DecodeIdx: 16
/* 253 */     MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableBeta16[] = {
/* 0 */       MCD::OPC_ExtractField, 12, 4,  // Inst{15-12} ...
/* 3 */       MCD::OPC_FilterValue, 4, 17, 0, // Skip to: 24
/* 7 */       MCD::OPC_ExtractField, 6, 2,  // Inst{7-6} ...
/* 10 */      MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 18
/* 14 */      MCD::OPC_Decode, 140, 4, 17, // Opcode: MOV16rc, DecodeIdx: 17
/* 18 */      MCD::OPC_FilterValueOrFail, 1, 
/* 20 */      MCD::OPC_Decode, 151, 4, 18, // Opcode: MOV8rc, DecodeIdx: 18
/* 24 */      MCD::OPC_FilterValue, 5, 17, 0, // Skip to: 45
/* 28 */      MCD::OPC_ExtractField, 6, 2,  // Inst{7-6} ...
/* 31 */      MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 39
/* 35 */      MCD::OPC_Decode, 192, 2, 19, // Opcode: ADD16rc, DecodeIdx: 19
/* 39 */      MCD::OPC_FilterValueOrFail, 1, 
/* 41 */      MCD::OPC_Decode, 204, 2, 20, // Opcode: ADD8rc, DecodeIdx: 20
/* 45 */      MCD::OPC_FilterValue, 6, 17, 0, // Skip to: 66
/* 49 */      MCD::OPC_ExtractField, 6, 2,  // Inst{7-6} ...
/* 52 */      MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 60
/* 56 */      MCD::OPC_Decode, 216, 2, 19, // Opcode: ADDC16rc, DecodeIdx: 19
/* 60 */      MCD::OPC_FilterValueOrFail, 1, 
/* 62 */      MCD::OPC_Decode, 228, 2, 20, // Opcode: ADDC8rc, DecodeIdx: 20
/* 66 */      MCD::OPC_FilterValue, 7, 17, 0, // Skip to: 87
/* 70 */      MCD::OPC_ExtractField, 6, 2,  // Inst{7-6} ...
/* 73 */      MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 81
/* 77 */      MCD::OPC_Decode, 218, 4, 19, // Opcode: SUBC16rc, DecodeIdx: 19
/* 81 */      MCD::OPC_FilterValueOrFail, 1, 
/* 83 */      MCD::OPC_Decode, 230, 4, 20, // Opcode: SUBC8rc, DecodeIdx: 20
/* 87 */      MCD::OPC_FilterValue, 8, 17, 0, // Skip to: 108
/* 91 */      MCD::OPC_ExtractField, 6, 2,  // Inst{7-6} ...
/* 94 */      MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 102
/* 98 */      MCD::OPC_Decode, 194, 4, 19, // Opcode: SUB16rc, DecodeIdx: 19
/* 102 */     MCD::OPC_FilterValueOrFail, 1, 
/* 104 */     MCD::OPC_Decode, 206, 4, 20, // Opcode: SUB8rc, DecodeIdx: 20
/* 108 */     MCD::OPC_FilterValue, 9, 17, 0, // Skip to: 129
/* 112 */     MCD::OPC_ExtractField, 6, 2,  // Inst{7-6} ...
/* 115 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 123
/* 119 */     MCD::OPC_Decode, 219, 3, 17, // Opcode: CMP16rc, DecodeIdx: 17
/* 123 */     MCD::OPC_FilterValueOrFail, 1, 
/* 125 */     MCD::OPC_Decode, 231, 3, 18, // Opcode: CMP8rc, DecodeIdx: 18
/* 129 */     MCD::OPC_FilterValue, 10, 17, 0, // Skip to: 150
/* 133 */     MCD::OPC_ExtractField, 6, 2,  // Inst{7-6} ...
/* 136 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 144
/* 140 */     MCD::OPC_Decode, 243, 3, 19, // Opcode: DADD16rc, DecodeIdx: 19
/* 144 */     MCD::OPC_FilterValueOrFail, 1, 
/* 146 */     MCD::OPC_Decode, 255, 3, 20, // Opcode: DADD8rc, DecodeIdx: 20
/* 150 */     MCD::OPC_FilterValue, 11, 17, 0, // Skip to: 171
/* 154 */     MCD::OPC_ExtractField, 6, 2,  // Inst{7-6} ...
/* 157 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 165
/* 161 */     MCD::OPC_Decode, 187, 3, 17, // Opcode: BIT16rc, DecodeIdx: 17
/* 165 */     MCD::OPC_FilterValueOrFail, 1, 
/* 167 */     MCD::OPC_Decode, 199, 3, 18, // Opcode: BIT8rc, DecodeIdx: 18
/* 171 */     MCD::OPC_FilterValue, 12, 17, 0, // Skip to: 192
/* 175 */     MCD::OPC_ExtractField, 6, 2,  // Inst{7-6} ...
/* 178 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 186
/* 182 */     MCD::OPC_Decode, 139, 3, 19, // Opcode: BIC16rc, DecodeIdx: 19
/* 186 */     MCD::OPC_FilterValueOrFail, 1, 
/* 188 */     MCD::OPC_Decode, 151, 3, 20, // Opcode: BIC8rc, DecodeIdx: 20
/* 192 */     MCD::OPC_FilterValue, 13, 17, 0, // Skip to: 213
/* 196 */     MCD::OPC_ExtractField, 6, 2,  // Inst{7-6} ...
/* 199 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 207
/* 203 */     MCD::OPC_Decode, 163, 3, 19, // Opcode: BIS16rc, DecodeIdx: 19
/* 207 */     MCD::OPC_FilterValueOrFail, 1, 
/* 209 */     MCD::OPC_Decode, 175, 3, 20, // Opcode: BIS8rc, DecodeIdx: 20
/* 213 */     MCD::OPC_FilterValue, 14, 17, 0, // Skip to: 234
/* 217 */     MCD::OPC_ExtractField, 6, 2,  // Inst{7-6} ...
/* 220 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 228
/* 224 */     MCD::OPC_Decode, 254, 4, 19, // Opcode: XOR16rc, DecodeIdx: 19
/* 228 */     MCD::OPC_FilterValueOrFail, 1, 
/* 230 */     MCD::OPC_Decode, 138, 5, 20, // Opcode: XOR8rc, DecodeIdx: 20
/* 234 */     MCD::OPC_FilterValueOrFail, 15, 
/* 236 */     MCD::OPC_ExtractField, 6, 2,  // Inst{7-6} ...
/* 239 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 247
/* 243 */     MCD::OPC_Decode, 243, 2, 19, // Opcode: AND16rc, DecodeIdx: 19
/* 247 */     MCD::OPC_FilterValueOrFail, 1, 
/* 249 */     MCD::OPC_Decode, 255, 2, 20, // Opcode: AND8rc, DecodeIdx: 20
/* 253 */     MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableBeta32[] = {
/* 0 */       MCD::OPC_ExtractField, 12, 4,  // Inst{15-12} ...
/* 3 */       MCD::OPC_FilterValue, 4, 17, 0, // Skip to: 24
/* 7 */       MCD::OPC_ExtractField, 6, 2,  // Inst{7-6} ...
/* 10 */      MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 18
/* 14 */      MCD::OPC_Decode, 135, 4, 21, // Opcode: MOV16mc, DecodeIdx: 21
/* 18 */      MCD::OPC_FilterValueOrFail, 3, 
/* 20 */      MCD::OPC_Decode, 146, 4, 21, // Opcode: MOV8mc, DecodeIdx: 21
/* 24 */      MCD::OPC_FilterValue, 5, 17, 0, // Skip to: 45
/* 28 */      MCD::OPC_ExtractField, 6, 2,  // Inst{7-6} ...
/* 31 */      MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 39
/* 35 */      MCD::OPC_Decode, 186, 2, 21, // Opcode: ADD16mc, DecodeIdx: 21
/* 39 */      MCD::OPC_FilterValueOrFail, 3, 
/* 41 */      MCD::OPC_Decode, 198, 2, 21, // Opcode: ADD8mc, DecodeIdx: 21
/* 45 */      MCD::OPC_FilterValue, 6, 17, 0, // Skip to: 66
/* 49 */      MCD::OPC_ExtractField, 6, 2,  // Inst{7-6} ...
/* 52 */      MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 60
/* 56 */      MCD::OPC_Decode, 210, 2, 21, // Opcode: ADDC16mc, DecodeIdx: 21
/* 60 */      MCD::OPC_FilterValueOrFail, 3, 
/* 62 */      MCD::OPC_Decode, 222, 2, 21, // Opcode: ADDC8mc, DecodeIdx: 21
/* 66 */      MCD::OPC_FilterValue, 7, 17, 0, // Skip to: 87
/* 70 */      MCD::OPC_ExtractField, 6, 2,  // Inst{7-6} ...
/* 73 */      MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 81
/* 77 */      MCD::OPC_Decode, 212, 4, 21, // Opcode: SUBC16mc, DecodeIdx: 21
/* 81 */      MCD::OPC_FilterValueOrFail, 3, 
/* 83 */      MCD::OPC_Decode, 224, 4, 21, // Opcode: SUBC8mc, DecodeIdx: 21
/* 87 */      MCD::OPC_FilterValue, 8, 17, 0, // Skip to: 108
/* 91 */      MCD::OPC_ExtractField, 6, 2,  // Inst{7-6} ...
/* 94 */      MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 102
/* 98 */      MCD::OPC_Decode, 188, 4, 21, // Opcode: SUB16mc, DecodeIdx: 21
/* 102 */     MCD::OPC_FilterValueOrFail, 3, 
/* 104 */     MCD::OPC_Decode, 200, 4, 21, // Opcode: SUB8mc, DecodeIdx: 21
/* 108 */     MCD::OPC_FilterValue, 9, 17, 0, // Skip to: 129
/* 112 */     MCD::OPC_ExtractField, 6, 2,  // Inst{7-6} ...
/* 115 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 123
/* 119 */     MCD::OPC_Decode, 213, 3, 21, // Opcode: CMP16mc, DecodeIdx: 21
/* 123 */     MCD::OPC_FilterValueOrFail, 3, 
/* 125 */     MCD::OPC_Decode, 225, 3, 21, // Opcode: CMP8mc, DecodeIdx: 21
/* 129 */     MCD::OPC_FilterValue, 10, 17, 0, // Skip to: 150
/* 133 */     MCD::OPC_ExtractField, 6, 2,  // Inst{7-6} ...
/* 136 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 144
/* 140 */     MCD::OPC_Decode, 237, 3, 21, // Opcode: DADD16mc, DecodeIdx: 21
/* 144 */     MCD::OPC_FilterValueOrFail, 3, 
/* 146 */     MCD::OPC_Decode, 249, 3, 21, // Opcode: DADD8mc, DecodeIdx: 21
/* 150 */     MCD::OPC_FilterValue, 11, 17, 0, // Skip to: 171
/* 154 */     MCD::OPC_ExtractField, 6, 2,  // Inst{7-6} ...
/* 157 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 165
/* 161 */     MCD::OPC_Decode, 181, 3, 21, // Opcode: BIT16mc, DecodeIdx: 21
/* 165 */     MCD::OPC_FilterValueOrFail, 3, 
/* 167 */     MCD::OPC_Decode, 193, 3, 21, // Opcode: BIT8mc, DecodeIdx: 21
/* 171 */     MCD::OPC_FilterValue, 12, 17, 0, // Skip to: 192
/* 175 */     MCD::OPC_ExtractField, 6, 2,  // Inst{7-6} ...
/* 178 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 186
/* 182 */     MCD::OPC_Decode, 133, 3, 21, // Opcode: BIC16mc, DecodeIdx: 21
/* 186 */     MCD::OPC_FilterValueOrFail, 3, 
/* 188 */     MCD::OPC_Decode, 145, 3, 21, // Opcode: BIC8mc, DecodeIdx: 21
/* 192 */     MCD::OPC_FilterValue, 13, 17, 0, // Skip to: 213
/* 196 */     MCD::OPC_ExtractField, 6, 2,  // Inst{7-6} ...
/* 199 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 207
/* 203 */     MCD::OPC_Decode, 157, 3, 21, // Opcode: BIS16mc, DecodeIdx: 21
/* 207 */     MCD::OPC_FilterValueOrFail, 3, 
/* 209 */     MCD::OPC_Decode, 169, 3, 21, // Opcode: BIS8mc, DecodeIdx: 21
/* 213 */     MCD::OPC_FilterValue, 14, 17, 0, // Skip to: 234
/* 217 */     MCD::OPC_ExtractField, 6, 2,  // Inst{7-6} ...
/* 220 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 228
/* 224 */     MCD::OPC_Decode, 248, 4, 21, // Opcode: XOR16mc, DecodeIdx: 21
/* 228 */     MCD::OPC_FilterValueOrFail, 3, 
/* 230 */     MCD::OPC_Decode, 132, 5, 21, // Opcode: XOR8mc, DecodeIdx: 21
/* 234 */     MCD::OPC_FilterValueOrFail, 15, 
/* 236 */     MCD::OPC_ExtractField, 6, 2,  // Inst{7-6} ...
/* 239 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 247
/* 243 */     MCD::OPC_Decode, 237, 2, 21, // Opcode: AND16mc, DecodeIdx: 21
/* 247 */     MCD::OPC_FilterValueOrFail, 3, 
/* 249 */     MCD::OPC_Decode, 249, 2, 21, // Opcode: AND8mc, DecodeIdx: 21
/* 253 */     MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableDelta16[] = {
/* 0 */       MCD::OPC_ExtractField, 12, 4,  // Inst{15-12} ...
/* 3 */       MCD::OPC_FilterValue, 4, 59, 0, // Skip to: 66
/* 7 */       MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 10 */      MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 18
/* 14 */      MCD::OPC_Decode, 143, 4, 11, // Opcode: MOV16rn, DecodeIdx: 11
/* 18 */      MCD::OPC_FilterValue, 3, 30, 0, // Skip to: 52
/* 22 */      MCD::OPC_CheckField, 8, 4, 1, 10, 0, // Skip to: 38
/* 28 */      MCD::OPC_CheckField, 0, 4, 0, 4, 0, // Skip to: 38
/* 34 */      MCD::OPC_Decode, 164, 4, 5, // Opcode: RET, DecodeIdx: 5
/* 38 */      MCD::OPC_CheckField, 8, 4, 1, 4, 0, // Skip to: 48
/* 44 */      MCD::OPC_Decode, 159, 4, 1, // Opcode: POP16r, DecodeIdx: 1
/* 48 */      MCD::OPC_Decode, 144, 4, 22, // Opcode: MOV16rp, DecodeIdx: 22
/* 52 */      MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 60
/* 56 */      MCD::OPC_Decode, 154, 4, 23, // Opcode: MOV8rn, DecodeIdx: 23
/* 60 */      MCD::OPC_FilterValueOrFail, 7, 
/* 62 */      MCD::OPC_Decode, 155, 4, 24, // Opcode: MOV8rp, DecodeIdx: 24
/* 66 */      MCD::OPC_FilterValue, 5, 33, 0, // Skip to: 103
/* 70 */      MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 73 */      MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 81
/* 77 */      MCD::OPC_Decode, 195, 2, 13, // Opcode: ADD16rn, DecodeIdx: 13
/* 81 */      MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 89
/* 85 */      MCD::OPC_Decode, 196, 2, 25, // Opcode: ADD16rp, DecodeIdx: 25
/* 89 */      MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 97
/* 93 */      MCD::OPC_Decode, 207, 2, 26, // Opcode: ADD8rn, DecodeIdx: 26
/* 97 */      MCD::OPC_FilterValueOrFail, 7, 
/* 99 */      MCD::OPC_Decode, 208, 2, 27, // Opcode: ADD8rp, DecodeIdx: 27
/* 103 */     MCD::OPC_FilterValue, 6, 33, 0, // Skip to: 140
/* 107 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 110 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 118
/* 114 */     MCD::OPC_Decode, 219, 2, 13, // Opcode: ADDC16rn, DecodeIdx: 13
/* 118 */     MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 126
/* 122 */     MCD::OPC_Decode, 220, 2, 25, // Opcode: ADDC16rp, DecodeIdx: 25
/* 126 */     MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 134
/* 130 */     MCD::OPC_Decode, 231, 2, 26, // Opcode: ADDC8rn, DecodeIdx: 26
/* 134 */     MCD::OPC_FilterValueOrFail, 7, 
/* 136 */     MCD::OPC_Decode, 232, 2, 27, // Opcode: ADDC8rp, DecodeIdx: 27
/* 140 */     MCD::OPC_FilterValue, 7, 33, 0, // Skip to: 177
/* 144 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 147 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 155
/* 151 */     MCD::OPC_Decode, 221, 4, 13, // Opcode: SUBC16rn, DecodeIdx: 13
/* 155 */     MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 163
/* 159 */     MCD::OPC_Decode, 222, 4, 25, // Opcode: SUBC16rp, DecodeIdx: 25
/* 163 */     MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 171
/* 167 */     MCD::OPC_Decode, 233, 4, 26, // Opcode: SUBC8rn, DecodeIdx: 26
/* 171 */     MCD::OPC_FilterValueOrFail, 7, 
/* 173 */     MCD::OPC_Decode, 234, 4, 27, // Opcode: SUBC8rp, DecodeIdx: 27
/* 177 */     MCD::OPC_FilterValue, 8, 33, 0, // Skip to: 214
/* 181 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 184 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 192
/* 188 */     MCD::OPC_Decode, 197, 4, 13, // Opcode: SUB16rn, DecodeIdx: 13
/* 192 */     MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 200
/* 196 */     MCD::OPC_Decode, 198, 4, 25, // Opcode: SUB16rp, DecodeIdx: 25
/* 200 */     MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 208
/* 204 */     MCD::OPC_Decode, 209, 4, 26, // Opcode: SUB8rn, DecodeIdx: 26
/* 208 */     MCD::OPC_FilterValueOrFail, 7, 
/* 210 */     MCD::OPC_Decode, 210, 4, 27, // Opcode: SUB8rp, DecodeIdx: 27
/* 214 */     MCD::OPC_FilterValue, 9, 33, 0, // Skip to: 251
/* 218 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 221 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 229
/* 225 */     MCD::OPC_Decode, 222, 3, 11, // Opcode: CMP16rn, DecodeIdx: 11
/* 229 */     MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 237
/* 233 */     MCD::OPC_Decode, 223, 3, 11, // Opcode: CMP16rp, DecodeIdx: 11
/* 237 */     MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 245
/* 241 */     MCD::OPC_Decode, 234, 3, 23, // Opcode: CMP8rn, DecodeIdx: 23
/* 245 */     MCD::OPC_FilterValueOrFail, 7, 
/* 247 */     MCD::OPC_Decode, 235, 3, 23, // Opcode: CMP8rp, DecodeIdx: 23
/* 251 */     MCD::OPC_FilterValue, 10, 33, 0, // Skip to: 288
/* 255 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 258 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 266
/* 262 */     MCD::OPC_Decode, 246, 3, 13, // Opcode: DADD16rn, DecodeIdx: 13
/* 266 */     MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 274
/* 270 */     MCD::OPC_Decode, 247, 3, 25, // Opcode: DADD16rp, DecodeIdx: 25
/* 274 */     MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 282
/* 278 */     MCD::OPC_Decode, 130, 4, 26, // Opcode: DADD8rn, DecodeIdx: 26
/* 282 */     MCD::OPC_FilterValueOrFail, 7, 
/* 284 */     MCD::OPC_Decode, 131, 4, 27, // Opcode: DADD8rp, DecodeIdx: 27
/* 288 */     MCD::OPC_FilterValue, 11, 33, 0, // Skip to: 325
/* 292 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 295 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 303
/* 299 */     MCD::OPC_Decode, 190, 3, 11, // Opcode: BIT16rn, DecodeIdx: 11
/* 303 */     MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 311
/* 307 */     MCD::OPC_Decode, 191, 3, 11, // Opcode: BIT16rp, DecodeIdx: 11
/* 311 */     MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 319
/* 315 */     MCD::OPC_Decode, 202, 3, 23, // Opcode: BIT8rn, DecodeIdx: 23
/* 319 */     MCD::OPC_FilterValueOrFail, 7, 
/* 321 */     MCD::OPC_Decode, 203, 3, 23, // Opcode: BIT8rp, DecodeIdx: 23
/* 325 */     MCD::OPC_FilterValue, 12, 33, 0, // Skip to: 362
/* 329 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 332 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 340
/* 336 */     MCD::OPC_Decode, 142, 3, 13, // Opcode: BIC16rn, DecodeIdx: 13
/* 340 */     MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 348
/* 344 */     MCD::OPC_Decode, 143, 3, 25, // Opcode: BIC16rp, DecodeIdx: 25
/* 348 */     MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 356
/* 352 */     MCD::OPC_Decode, 154, 3, 26, // Opcode: BIC8rn, DecodeIdx: 26
/* 356 */     MCD::OPC_FilterValueOrFail, 7, 
/* 358 */     MCD::OPC_Decode, 155, 3, 27, // Opcode: BIC8rp, DecodeIdx: 27
/* 362 */     MCD::OPC_FilterValue, 13, 33, 0, // Skip to: 399
/* 366 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 369 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 377
/* 373 */     MCD::OPC_Decode, 166, 3, 13, // Opcode: BIS16rn, DecodeIdx: 13
/* 377 */     MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 385
/* 381 */     MCD::OPC_Decode, 167, 3, 25, // Opcode: BIS16rp, DecodeIdx: 25
/* 385 */     MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 393
/* 389 */     MCD::OPC_Decode, 178, 3, 26, // Opcode: BIS8rn, DecodeIdx: 26
/* 393 */     MCD::OPC_FilterValueOrFail, 7, 
/* 395 */     MCD::OPC_Decode, 179, 3, 27, // Opcode: BIS8rp, DecodeIdx: 27
/* 399 */     MCD::OPC_FilterValue, 14, 33, 0, // Skip to: 436
/* 403 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 406 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 414
/* 410 */     MCD::OPC_Decode, 129, 5, 13, // Opcode: XOR16rn, DecodeIdx: 13
/* 414 */     MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 422
/* 418 */     MCD::OPC_Decode, 130, 5, 25, // Opcode: XOR16rp, DecodeIdx: 25
/* 422 */     MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 430
/* 426 */     MCD::OPC_Decode, 141, 5, 26, // Opcode: XOR8rn, DecodeIdx: 26
/* 430 */     MCD::OPC_FilterValueOrFail, 7, 
/* 432 */     MCD::OPC_Decode, 142, 5, 27, // Opcode: XOR8rp, DecodeIdx: 27
/* 436 */     MCD::OPC_FilterValueOrFail, 15, 
/* 438 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 441 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 449
/* 445 */     MCD::OPC_Decode, 246, 2, 13, // Opcode: AND16rn, DecodeIdx: 13
/* 449 */     MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 457
/* 453 */     MCD::OPC_Decode, 247, 2, 25, // Opcode: AND16rp, DecodeIdx: 25
/* 457 */     MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 465
/* 461 */     MCD::OPC_Decode, 130, 3, 26, // Opcode: AND8rn, DecodeIdx: 26
/* 465 */     MCD::OPC_FilterValueOrFail, 7, 
/* 467 */     MCD::OPC_Decode, 131, 3, 27, // Opcode: AND8rp, DecodeIdx: 27
/* 471 */     MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableDelta32[] = {
/* 0 */       MCD::OPC_ExtractField, 12, 4,  // Inst{15-12} ...
/* 3 */       MCD::OPC_FilterValue, 4, 17, 0, // Skip to: 24
/* 7 */       MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 10 */      MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 18
/* 14 */      MCD::OPC_Decode, 138, 4, 15, // Opcode: MOV16mn, DecodeIdx: 15
/* 18 */      MCD::OPC_FilterValueOrFail, 14, 
/* 20 */      MCD::OPC_Decode, 149, 4, 15, // Opcode: MOV8mn, DecodeIdx: 15
/* 24 */      MCD::OPC_FilterValue, 5, 33, 0, // Skip to: 61
/* 28 */      MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 31 */      MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 39
/* 35 */      MCD::OPC_Decode, 189, 2, 15, // Opcode: ADD16mn, DecodeIdx: 15
/* 39 */      MCD::OPC_FilterValue, 11, 4, 0, // Skip to: 47
/* 43 */      MCD::OPC_Decode, 190, 2, 15, // Opcode: ADD16mp, DecodeIdx: 15
/* 47 */      MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 55
/* 51 */      MCD::OPC_Decode, 201, 2, 15, // Opcode: ADD8mn, DecodeIdx: 15
/* 55 */      MCD::OPC_FilterValueOrFail, 15, 
/* 57 */      MCD::OPC_Decode, 202, 2, 15, // Opcode: ADD8mp, DecodeIdx: 15
/* 61 */      MCD::OPC_FilterValue, 6, 33, 0, // Skip to: 98
/* 65 */      MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 68 */      MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 76
/* 72 */      MCD::OPC_Decode, 213, 2, 15, // Opcode: ADDC16mn, DecodeIdx: 15
/* 76 */      MCD::OPC_FilterValue, 11, 4, 0, // Skip to: 84
/* 80 */      MCD::OPC_Decode, 214, 2, 15, // Opcode: ADDC16mp, DecodeIdx: 15
/* 84 */      MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 92
/* 88 */      MCD::OPC_Decode, 225, 2, 15, // Opcode: ADDC8mn, DecodeIdx: 15
/* 92 */      MCD::OPC_FilterValueOrFail, 15, 
/* 94 */      MCD::OPC_Decode, 226, 2, 15, // Opcode: ADDC8mp, DecodeIdx: 15
/* 98 */      MCD::OPC_FilterValue, 7, 33, 0, // Skip to: 135
/* 102 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 105 */     MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 113
/* 109 */     MCD::OPC_Decode, 215, 4, 15, // Opcode: SUBC16mn, DecodeIdx: 15
/* 113 */     MCD::OPC_FilterValue, 11, 4, 0, // Skip to: 121
/* 117 */     MCD::OPC_Decode, 216, 4, 15, // Opcode: SUBC16mp, DecodeIdx: 15
/* 121 */     MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 129
/* 125 */     MCD::OPC_Decode, 227, 4, 15, // Opcode: SUBC8mn, DecodeIdx: 15
/* 129 */     MCD::OPC_FilterValueOrFail, 15, 
/* 131 */     MCD::OPC_Decode, 228, 4, 15, // Opcode: SUBC8mp, DecodeIdx: 15
/* 135 */     MCD::OPC_FilterValue, 8, 33, 0, // Skip to: 172
/* 139 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 142 */     MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 150
/* 146 */     MCD::OPC_Decode, 191, 4, 15, // Opcode: SUB16mn, DecodeIdx: 15
/* 150 */     MCD::OPC_FilterValue, 11, 4, 0, // Skip to: 158
/* 154 */     MCD::OPC_Decode, 192, 4, 15, // Opcode: SUB16mp, DecodeIdx: 15
/* 158 */     MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 166
/* 162 */     MCD::OPC_Decode, 203, 4, 15, // Opcode: SUB8mn, DecodeIdx: 15
/* 166 */     MCD::OPC_FilterValueOrFail, 15, 
/* 168 */     MCD::OPC_Decode, 204, 4, 15, // Opcode: SUB8mp, DecodeIdx: 15
/* 172 */     MCD::OPC_FilterValue, 9, 33, 0, // Skip to: 209
/* 176 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 179 */     MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 187
/* 183 */     MCD::OPC_Decode, 216, 3, 15, // Opcode: CMP16mn, DecodeIdx: 15
/* 187 */     MCD::OPC_FilterValue, 11, 4, 0, // Skip to: 195
/* 191 */     MCD::OPC_Decode, 217, 3, 15, // Opcode: CMP16mp, DecodeIdx: 15
/* 195 */     MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 203
/* 199 */     MCD::OPC_Decode, 228, 3, 15, // Opcode: CMP8mn, DecodeIdx: 15
/* 203 */     MCD::OPC_FilterValueOrFail, 15, 
/* 205 */     MCD::OPC_Decode, 229, 3, 15, // Opcode: CMP8mp, DecodeIdx: 15
/* 209 */     MCD::OPC_FilterValue, 10, 33, 0, // Skip to: 246
/* 213 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 216 */     MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 224
/* 220 */     MCD::OPC_Decode, 240, 3, 15, // Opcode: DADD16mn, DecodeIdx: 15
/* 224 */     MCD::OPC_FilterValue, 11, 4, 0, // Skip to: 232
/* 228 */     MCD::OPC_Decode, 241, 3, 15, // Opcode: DADD16mp, DecodeIdx: 15
/* 232 */     MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 240
/* 236 */     MCD::OPC_Decode, 252, 3, 15, // Opcode: DADD8mn, DecodeIdx: 15
/* 240 */     MCD::OPC_FilterValueOrFail, 15, 
/* 242 */     MCD::OPC_Decode, 253, 3, 15, // Opcode: DADD8mp, DecodeIdx: 15
/* 246 */     MCD::OPC_FilterValue, 11, 33, 0, // Skip to: 283
/* 250 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 253 */     MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 261
/* 257 */     MCD::OPC_Decode, 184, 3, 15, // Opcode: BIT16mn, DecodeIdx: 15
/* 261 */     MCD::OPC_FilterValue, 11, 4, 0, // Skip to: 269
/* 265 */     MCD::OPC_Decode, 185, 3, 15, // Opcode: BIT16mp, DecodeIdx: 15
/* 269 */     MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 277
/* 273 */     MCD::OPC_Decode, 196, 3, 15, // Opcode: BIT8mn, DecodeIdx: 15
/* 277 */     MCD::OPC_FilterValueOrFail, 15, 
/* 279 */     MCD::OPC_Decode, 197, 3, 15, // Opcode: BIT8mp, DecodeIdx: 15
/* 283 */     MCD::OPC_FilterValue, 12, 33, 0, // Skip to: 320
/* 287 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 290 */     MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 298
/* 294 */     MCD::OPC_Decode, 136, 3, 15, // Opcode: BIC16mn, DecodeIdx: 15
/* 298 */     MCD::OPC_FilterValue, 11, 4, 0, // Skip to: 306
/* 302 */     MCD::OPC_Decode, 137, 3, 15, // Opcode: BIC16mp, DecodeIdx: 15
/* 306 */     MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 314
/* 310 */     MCD::OPC_Decode, 148, 3, 15, // Opcode: BIC8mn, DecodeIdx: 15
/* 314 */     MCD::OPC_FilterValueOrFail, 15, 
/* 316 */     MCD::OPC_Decode, 149, 3, 15, // Opcode: BIC8mp, DecodeIdx: 15
/* 320 */     MCD::OPC_FilterValue, 13, 33, 0, // Skip to: 357
/* 324 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 327 */     MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 335
/* 331 */     MCD::OPC_Decode, 160, 3, 15, // Opcode: BIS16mn, DecodeIdx: 15
/* 335 */     MCD::OPC_FilterValue, 11, 4, 0, // Skip to: 343
/* 339 */     MCD::OPC_Decode, 161, 3, 15, // Opcode: BIS16mp, DecodeIdx: 15
/* 343 */     MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 351
/* 347 */     MCD::OPC_Decode, 172, 3, 15, // Opcode: BIS8mn, DecodeIdx: 15
/* 351 */     MCD::OPC_FilterValueOrFail, 15, 
/* 353 */     MCD::OPC_Decode, 173, 3, 15, // Opcode: BIS8mp, DecodeIdx: 15
/* 357 */     MCD::OPC_FilterValue, 14, 33, 0, // Skip to: 394
/* 361 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 364 */     MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 372
/* 368 */     MCD::OPC_Decode, 251, 4, 15, // Opcode: XOR16mn, DecodeIdx: 15
/* 372 */     MCD::OPC_FilterValue, 11, 4, 0, // Skip to: 380
/* 376 */     MCD::OPC_Decode, 252, 4, 15, // Opcode: XOR16mp, DecodeIdx: 15
/* 380 */     MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 388
/* 384 */     MCD::OPC_Decode, 135, 5, 15, // Opcode: XOR8mn, DecodeIdx: 15
/* 388 */     MCD::OPC_FilterValueOrFail, 15, 
/* 390 */     MCD::OPC_Decode, 136, 5, 15, // Opcode: XOR8mp, DecodeIdx: 15
/* 394 */     MCD::OPC_FilterValueOrFail, 15, 
/* 396 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 399 */     MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 407
/* 403 */     MCD::OPC_Decode, 240, 2, 15, // Opcode: AND16mn, DecodeIdx: 15
/* 407 */     MCD::OPC_FilterValue, 11, 4, 0, // Skip to: 415
/* 411 */     MCD::OPC_Decode, 241, 2, 15, // Opcode: AND16mp, DecodeIdx: 15
/* 415 */     MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 423
/* 419 */     MCD::OPC_Decode, 252, 2, 15, // Opcode: AND8mn, DecodeIdx: 15
/* 423 */     MCD::OPC_FilterValueOrFail, 15, 
/* 425 */     MCD::OPC_Decode, 253, 2, 15, // Opcode: AND8mp, DecodeIdx: 15
/* 429 */     MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableGamma32[] = {
/* 0 */       MCD::OPC_ExtractField, 12, 4,  // Inst{15-12} ...
/* 3 */       MCD::OPC_FilterValue, 4, 62, 0, // Skip to: 69
/* 7 */       MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 10 */      MCD::OPC_FilterValue, 1, 14, 0, // Skip to: 28
/* 14 */      MCD::OPC_CheckField, 0, 4, 0, 4, 0, // Skip to: 24
/* 20 */      MCD::OPC_Decode, 206, 3, 28, // Opcode: Bm, DecodeIdx: 28
/* 24 */      MCD::OPC_Decode, 142, 4, 29, // Opcode: MOV16rm, DecodeIdx: 29
/* 28 */      MCD::OPC_FilterValue, 3, 19, 0, // Skip to: 51
/* 32 */      MCD::OPC_ExtractField, 8, 4,  // Inst{11-8} ...
/* 35 */      MCD::OPC_FilterValueOrFail, 0, 
/* 37 */      MCD::OPC_CheckField, 0, 4, 0, 4, 0, // Skip to: 47
/* 43 */      MCD::OPC_Decode, 205, 3, 9, // Opcode: Bi, DecodeIdx: 9
/* 47 */      MCD::OPC_Decode, 141, 4, 30, // Opcode: MOV16ri, DecodeIdx: 30
/* 51 */      MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 59
/* 55 */      MCD::OPC_Decode, 153, 4, 31, // Opcode: MOV8rm, DecodeIdx: 31
/* 59 */      MCD::OPC_FilterValueOrFail, 7, 
/* 61 */      MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 65 */      MCD::OPC_Decode, 152, 4, 32, // Opcode: MOV8ri, DecodeIdx: 32
/* 69 */      MCD::OPC_FilterValue, 5, 41, 0, // Skip to: 114
/* 73 */      MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 76 */      MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 84
/* 80 */      MCD::OPC_Decode, 194, 2, 33, // Opcode: ADD16rm, DecodeIdx: 33
/* 84 */      MCD::OPC_FilterValue, 3, 8, 0, // Skip to: 96
/* 88 */      MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 92 */      MCD::OPC_Decode, 193, 2, 34, // Opcode: ADD16ri, DecodeIdx: 34
/* 96 */      MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 104
/* 100 */     MCD::OPC_Decode, 206, 2, 35, // Opcode: ADD8rm, DecodeIdx: 35
/* 104 */     MCD::OPC_FilterValueOrFail, 7, 
/* 106 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 110 */     MCD::OPC_Decode, 205, 2, 36, // Opcode: ADD8ri, DecodeIdx: 36
/* 114 */     MCD::OPC_FilterValue, 6, 41, 0, // Skip to: 159
/* 118 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 121 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 129
/* 125 */     MCD::OPC_Decode, 218, 2, 33, // Opcode: ADDC16rm, DecodeIdx: 33
/* 129 */     MCD::OPC_FilterValue, 3, 8, 0, // Skip to: 141
/* 133 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 137 */     MCD::OPC_Decode, 217, 2, 34, // Opcode: ADDC16ri, DecodeIdx: 34
/* 141 */     MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 149
/* 145 */     MCD::OPC_Decode, 230, 2, 35, // Opcode: ADDC8rm, DecodeIdx: 35
/* 149 */     MCD::OPC_FilterValueOrFail, 7, 
/* 151 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 155 */     MCD::OPC_Decode, 229, 2, 36, // Opcode: ADDC8ri, DecodeIdx: 36
/* 159 */     MCD::OPC_FilterValue, 7, 41, 0, // Skip to: 204
/* 163 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 166 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 174
/* 170 */     MCD::OPC_Decode, 220, 4, 33, // Opcode: SUBC16rm, DecodeIdx: 33
/* 174 */     MCD::OPC_FilterValue, 3, 8, 0, // Skip to: 186
/* 178 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 182 */     MCD::OPC_Decode, 219, 4, 34, // Opcode: SUBC16ri, DecodeIdx: 34
/* 186 */     MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 194
/* 190 */     MCD::OPC_Decode, 232, 4, 35, // Opcode: SUBC8rm, DecodeIdx: 35
/* 194 */     MCD::OPC_FilterValueOrFail, 7, 
/* 196 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 200 */     MCD::OPC_Decode, 231, 4, 36, // Opcode: SUBC8ri, DecodeIdx: 36
/* 204 */     MCD::OPC_FilterValue, 8, 41, 0, // Skip to: 249
/* 208 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 211 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 219
/* 215 */     MCD::OPC_Decode, 196, 4, 33, // Opcode: SUB16rm, DecodeIdx: 33
/* 219 */     MCD::OPC_FilterValue, 3, 8, 0, // Skip to: 231
/* 223 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 227 */     MCD::OPC_Decode, 195, 4, 34, // Opcode: SUB16ri, DecodeIdx: 34
/* 231 */     MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 239
/* 235 */     MCD::OPC_Decode, 208, 4, 35, // Opcode: SUB8rm, DecodeIdx: 35
/* 239 */     MCD::OPC_FilterValueOrFail, 7, 
/* 241 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 245 */     MCD::OPC_Decode, 207, 4, 36, // Opcode: SUB8ri, DecodeIdx: 36
/* 249 */     MCD::OPC_FilterValue, 9, 41, 0, // Skip to: 294
/* 253 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 256 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 264
/* 260 */     MCD::OPC_Decode, 221, 3, 29, // Opcode: CMP16rm, DecodeIdx: 29
/* 264 */     MCD::OPC_FilterValue, 3, 8, 0, // Skip to: 276
/* 268 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 272 */     MCD::OPC_Decode, 220, 3, 30, // Opcode: CMP16ri, DecodeIdx: 30
/* 276 */     MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 284
/* 280 */     MCD::OPC_Decode, 233, 3, 31, // Opcode: CMP8rm, DecodeIdx: 31
/* 284 */     MCD::OPC_FilterValueOrFail, 7, 
/* 286 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 290 */     MCD::OPC_Decode, 232, 3, 32, // Opcode: CMP8ri, DecodeIdx: 32
/* 294 */     MCD::OPC_FilterValue, 10, 41, 0, // Skip to: 339
/* 298 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 301 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 309
/* 305 */     MCD::OPC_Decode, 245, 3, 33, // Opcode: DADD16rm, DecodeIdx: 33
/* 309 */     MCD::OPC_FilterValue, 3, 8, 0, // Skip to: 321
/* 313 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 317 */     MCD::OPC_Decode, 244, 3, 34, // Opcode: DADD16ri, DecodeIdx: 34
/* 321 */     MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 329
/* 325 */     MCD::OPC_Decode, 129, 4, 35, // Opcode: DADD8rm, DecodeIdx: 35
/* 329 */     MCD::OPC_FilterValueOrFail, 7, 
/* 331 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 335 */     MCD::OPC_Decode, 128, 4, 36, // Opcode: DADD8ri, DecodeIdx: 36
/* 339 */     MCD::OPC_FilterValue, 11, 41, 0, // Skip to: 384
/* 343 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 346 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 354
/* 350 */     MCD::OPC_Decode, 189, 3, 29, // Opcode: BIT16rm, DecodeIdx: 29
/* 354 */     MCD::OPC_FilterValue, 3, 8, 0, // Skip to: 366
/* 358 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 362 */     MCD::OPC_Decode, 188, 3, 30, // Opcode: BIT16ri, DecodeIdx: 30
/* 366 */     MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 374
/* 370 */     MCD::OPC_Decode, 201, 3, 31, // Opcode: BIT8rm, DecodeIdx: 31
/* 374 */     MCD::OPC_FilterValueOrFail, 7, 
/* 376 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 380 */     MCD::OPC_Decode, 200, 3, 32, // Opcode: BIT8ri, DecodeIdx: 32
/* 384 */     MCD::OPC_FilterValue, 12, 41, 0, // Skip to: 429
/* 388 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 391 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 399
/* 395 */     MCD::OPC_Decode, 141, 3, 33, // Opcode: BIC16rm, DecodeIdx: 33
/* 399 */     MCD::OPC_FilterValue, 3, 8, 0, // Skip to: 411
/* 403 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 407 */     MCD::OPC_Decode, 140, 3, 34, // Opcode: BIC16ri, DecodeIdx: 34
/* 411 */     MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 419
/* 415 */     MCD::OPC_Decode, 153, 3, 35, // Opcode: BIC8rm, DecodeIdx: 35
/* 419 */     MCD::OPC_FilterValueOrFail, 7, 
/* 421 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 425 */     MCD::OPC_Decode, 152, 3, 36, // Opcode: BIC8ri, DecodeIdx: 36
/* 429 */     MCD::OPC_FilterValue, 13, 41, 0, // Skip to: 474
/* 433 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 436 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 444
/* 440 */     MCD::OPC_Decode, 165, 3, 33, // Opcode: BIS16rm, DecodeIdx: 33
/* 444 */     MCD::OPC_FilterValue, 3, 8, 0, // Skip to: 456
/* 448 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 452 */     MCD::OPC_Decode, 164, 3, 34, // Opcode: BIS16ri, DecodeIdx: 34
/* 456 */     MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 464
/* 460 */     MCD::OPC_Decode, 177, 3, 35, // Opcode: BIS8rm, DecodeIdx: 35
/* 464 */     MCD::OPC_FilterValueOrFail, 7, 
/* 466 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 470 */     MCD::OPC_Decode, 176, 3, 36, // Opcode: BIS8ri, DecodeIdx: 36
/* 474 */     MCD::OPC_FilterValue, 14, 41, 0, // Skip to: 519
/* 478 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 481 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 489
/* 485 */     MCD::OPC_Decode, 128, 5, 33, // Opcode: XOR16rm, DecodeIdx: 33
/* 489 */     MCD::OPC_FilterValue, 3, 8, 0, // Skip to: 501
/* 493 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 497 */     MCD::OPC_Decode, 255, 4, 34, // Opcode: XOR16ri, DecodeIdx: 34
/* 501 */     MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 509
/* 505 */     MCD::OPC_Decode, 140, 5, 35, // Opcode: XOR8rm, DecodeIdx: 35
/* 509 */     MCD::OPC_FilterValueOrFail, 7, 
/* 511 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 515 */     MCD::OPC_Decode, 139, 5, 36, // Opcode: XOR8ri, DecodeIdx: 36
/* 519 */     MCD::OPC_FilterValueOrFail, 15, 
/* 521 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 524 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 532
/* 528 */     MCD::OPC_Decode, 245, 2, 33, // Opcode: AND16rm, DecodeIdx: 33
/* 532 */     MCD::OPC_FilterValue, 3, 8, 0, // Skip to: 544
/* 536 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 540 */     MCD::OPC_Decode, 244, 2, 34, // Opcode: AND16ri, DecodeIdx: 34
/* 544 */     MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 552
/* 548 */     MCD::OPC_Decode, 129, 3, 35, // Opcode: AND8rm, DecodeIdx: 35
/* 552 */     MCD::OPC_FilterValueOrFail, 7, 
/* 554 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 558 */     MCD::OPC_Decode, 128, 3, 36, // Opcode: AND8ri, DecodeIdx: 36
/* 562 */     MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableGamma48[] = {
/* 0 */       MCD::OPC_ExtractField, 12, 4,  // Inst{15-12} ...
/* 3 */       MCD::OPC_FilterValue, 4, 41, 0, // Skip to: 48
/* 7 */       MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 10 */      MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 18
/* 14 */      MCD::OPC_Decode, 137, 4, 37, // Opcode: MOV16mm, DecodeIdx: 37
/* 18 */      MCD::OPC_FilterValue, 11, 8, 0, // Skip to: 30
/* 22 */      MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 26 */      MCD::OPC_Decode, 136, 4, 38, // Opcode: MOV16mi, DecodeIdx: 38
/* 30 */      MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 38
/* 34 */      MCD::OPC_Decode, 148, 4, 37, // Opcode: MOV8mm, DecodeIdx: 37
/* 38 */      MCD::OPC_FilterValueOrFail, 15, 
/* 40 */      MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 44 */      MCD::OPC_Decode, 147, 4, 38, // Opcode: MOV8mi, DecodeIdx: 38
/* 48 */      MCD::OPC_FilterValue, 5, 41, 0, // Skip to: 93
/* 52 */      MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 55 */      MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 63
/* 59 */      MCD::OPC_Decode, 188, 2, 37, // Opcode: ADD16mm, DecodeIdx: 37
/* 63 */      MCD::OPC_FilterValue, 11, 8, 0, // Skip to: 75
/* 67 */      MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 71 */      MCD::OPC_Decode, 187, 2, 38, // Opcode: ADD16mi, DecodeIdx: 38
/* 75 */      MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 83
/* 79 */      MCD::OPC_Decode, 200, 2, 37, // Opcode: ADD8mm, DecodeIdx: 37
/* 83 */      MCD::OPC_FilterValueOrFail, 15, 
/* 85 */      MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 89 */      MCD::OPC_Decode, 199, 2, 38, // Opcode: ADD8mi, DecodeIdx: 38
/* 93 */      MCD::OPC_FilterValue, 6, 41, 0, // Skip to: 138
/* 97 */      MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 100 */     MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 108
/* 104 */     MCD::OPC_Decode, 212, 2, 37, // Opcode: ADDC16mm, DecodeIdx: 37
/* 108 */     MCD::OPC_FilterValue, 11, 8, 0, // Skip to: 120
/* 112 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 116 */     MCD::OPC_Decode, 211, 2, 38, // Opcode: ADDC16mi, DecodeIdx: 38
/* 120 */     MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 128
/* 124 */     MCD::OPC_Decode, 224, 2, 37, // Opcode: ADDC8mm, DecodeIdx: 37
/* 128 */     MCD::OPC_FilterValueOrFail, 15, 
/* 130 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 134 */     MCD::OPC_Decode, 223, 2, 38, // Opcode: ADDC8mi, DecodeIdx: 38
/* 138 */     MCD::OPC_FilterValue, 7, 41, 0, // Skip to: 183
/* 142 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 145 */     MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 153
/* 149 */     MCD::OPC_Decode, 214, 4, 37, // Opcode: SUBC16mm, DecodeIdx: 37
/* 153 */     MCD::OPC_FilterValue, 11, 8, 0, // Skip to: 165
/* 157 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 161 */     MCD::OPC_Decode, 213, 4, 38, // Opcode: SUBC16mi, DecodeIdx: 38
/* 165 */     MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 173
/* 169 */     MCD::OPC_Decode, 226, 4, 37, // Opcode: SUBC8mm, DecodeIdx: 37
/* 173 */     MCD::OPC_FilterValueOrFail, 15, 
/* 175 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 179 */     MCD::OPC_Decode, 225, 4, 38, // Opcode: SUBC8mi, DecodeIdx: 38
/* 183 */     MCD::OPC_FilterValue, 8, 41, 0, // Skip to: 228
/* 187 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 190 */     MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 198
/* 194 */     MCD::OPC_Decode, 190, 4, 37, // Opcode: SUB16mm, DecodeIdx: 37
/* 198 */     MCD::OPC_FilterValue, 11, 8, 0, // Skip to: 210
/* 202 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 206 */     MCD::OPC_Decode, 189, 4, 38, // Opcode: SUB16mi, DecodeIdx: 38
/* 210 */     MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 218
/* 214 */     MCD::OPC_Decode, 202, 4, 37, // Opcode: SUB8mm, DecodeIdx: 37
/* 218 */     MCD::OPC_FilterValueOrFail, 15, 
/* 220 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 224 */     MCD::OPC_Decode, 201, 4, 38, // Opcode: SUB8mi, DecodeIdx: 38
/* 228 */     MCD::OPC_FilterValue, 9, 41, 0, // Skip to: 273
/* 232 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 235 */     MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 243
/* 239 */     MCD::OPC_Decode, 215, 3, 37, // Opcode: CMP16mm, DecodeIdx: 37
/* 243 */     MCD::OPC_FilterValue, 11, 8, 0, // Skip to: 255
/* 247 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 251 */     MCD::OPC_Decode, 214, 3, 38, // Opcode: CMP16mi, DecodeIdx: 38
/* 255 */     MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 263
/* 259 */     MCD::OPC_Decode, 227, 3, 37, // Opcode: CMP8mm, DecodeIdx: 37
/* 263 */     MCD::OPC_FilterValueOrFail, 15, 
/* 265 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 269 */     MCD::OPC_Decode, 226, 3, 38, // Opcode: CMP8mi, DecodeIdx: 38
/* 273 */     MCD::OPC_FilterValue, 10, 41, 0, // Skip to: 318
/* 277 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 280 */     MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 288
/* 284 */     MCD::OPC_Decode, 239, 3, 37, // Opcode: DADD16mm, DecodeIdx: 37
/* 288 */     MCD::OPC_FilterValue, 11, 8, 0, // Skip to: 300
/* 292 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 296 */     MCD::OPC_Decode, 238, 3, 38, // Opcode: DADD16mi, DecodeIdx: 38
/* 300 */     MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 308
/* 304 */     MCD::OPC_Decode, 251, 3, 37, // Opcode: DADD8mm, DecodeIdx: 37
/* 308 */     MCD::OPC_FilterValueOrFail, 15, 
/* 310 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 314 */     MCD::OPC_Decode, 250, 3, 38, // Opcode: DADD8mi, DecodeIdx: 38
/* 318 */     MCD::OPC_FilterValue, 11, 41, 0, // Skip to: 363
/* 322 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 325 */     MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 333
/* 329 */     MCD::OPC_Decode, 183, 3, 37, // Opcode: BIT16mm, DecodeIdx: 37
/* 333 */     MCD::OPC_FilterValue, 11, 8, 0, // Skip to: 345
/* 337 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 341 */     MCD::OPC_Decode, 182, 3, 38, // Opcode: BIT16mi, DecodeIdx: 38
/* 345 */     MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 353
/* 349 */     MCD::OPC_Decode, 195, 3, 37, // Opcode: BIT8mm, DecodeIdx: 37
/* 353 */     MCD::OPC_FilterValueOrFail, 15, 
/* 355 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 359 */     MCD::OPC_Decode, 194, 3, 38, // Opcode: BIT8mi, DecodeIdx: 38
/* 363 */     MCD::OPC_FilterValue, 12, 41, 0, // Skip to: 408
/* 367 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 370 */     MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 378
/* 374 */     MCD::OPC_Decode, 135, 3, 37, // Opcode: BIC16mm, DecodeIdx: 37
/* 378 */     MCD::OPC_FilterValue, 11, 8, 0, // Skip to: 390
/* 382 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 386 */     MCD::OPC_Decode, 134, 3, 38, // Opcode: BIC16mi, DecodeIdx: 38
/* 390 */     MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 398
/* 394 */     MCD::OPC_Decode, 147, 3, 37, // Opcode: BIC8mm, DecodeIdx: 37
/* 398 */     MCD::OPC_FilterValueOrFail, 15, 
/* 400 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 404 */     MCD::OPC_Decode, 146, 3, 38, // Opcode: BIC8mi, DecodeIdx: 38
/* 408 */     MCD::OPC_FilterValue, 13, 41, 0, // Skip to: 453
/* 412 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 415 */     MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 423
/* 419 */     MCD::OPC_Decode, 159, 3, 37, // Opcode: BIS16mm, DecodeIdx: 37
/* 423 */     MCD::OPC_FilterValue, 11, 8, 0, // Skip to: 435
/* 427 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 431 */     MCD::OPC_Decode, 158, 3, 38, // Opcode: BIS16mi, DecodeIdx: 38
/* 435 */     MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 443
/* 439 */     MCD::OPC_Decode, 171, 3, 37, // Opcode: BIS8mm, DecodeIdx: 37
/* 443 */     MCD::OPC_FilterValueOrFail, 15, 
/* 445 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 449 */     MCD::OPC_Decode, 170, 3, 38, // Opcode: BIS8mi, DecodeIdx: 38
/* 453 */     MCD::OPC_FilterValue, 14, 41, 0, // Skip to: 498
/* 457 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 460 */     MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 468
/* 464 */     MCD::OPC_Decode, 250, 4, 37, // Opcode: XOR16mm, DecodeIdx: 37
/* 468 */     MCD::OPC_FilterValue, 11, 8, 0, // Skip to: 480
/* 472 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 476 */     MCD::OPC_Decode, 249, 4, 38, // Opcode: XOR16mi, DecodeIdx: 38
/* 480 */     MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 488
/* 484 */     MCD::OPC_Decode, 134, 5, 37, // Opcode: XOR8mm, DecodeIdx: 37
/* 488 */     MCD::OPC_FilterValueOrFail, 15, 
/* 490 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 494 */     MCD::OPC_Decode, 133, 5, 38, // Opcode: XOR8mi, DecodeIdx: 38
/* 498 */     MCD::OPC_FilterValueOrFail, 15, 
/* 500 */     MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 503 */     MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 511
/* 507 */     MCD::OPC_Decode, 239, 2, 37, // Opcode: AND16mm, DecodeIdx: 37
/* 511 */     MCD::OPC_FilterValue, 11, 8, 0, // Skip to: 523
/* 515 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 519 */     MCD::OPC_Decode, 238, 2, 38, // Opcode: AND16mi, DecodeIdx: 38
/* 523 */     MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 531
/* 527 */     MCD::OPC_Decode, 251, 2, 37, // Opcode: AND8mm, DecodeIdx: 37
/* 531 */     MCD::OPC_FilterValueOrFail, 15, 
/* 533 */     MCD::OPC_CheckFieldOrFail, 8, 4, 0, 
/* 537 */     MCD::OPC_Decode, 250, 2, 38, // Opcode: AND8mi, DecodeIdx: 38
/* 541 */     MCD::OPC_Fail,
  0
};

// Handling 39 cases.
template <typename InsnType>
static DecodeStatus decodeToMCInst(unsigned Idx, DecodeStatus S, InsnType insn, MCInst &MI, uint64_t Address, const MCDisassembler *Decoder, bool &DecodeComplete) {
  DecodeComplete = true;
  using TmpType = std::conditional_t<std::is_integral<InsnType>::value, InsnType, uint64_t>;
  TmpType tmp;
  switch (Idx) {
  default: llvm_unreachable("Invalid index!");
  case 0:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 1:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 2:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 3:
    tmp = fieldFromInstruction(insn, 0, 6);
    if (!Check(S, DecodeCGImm(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 4:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 5:
    return S;
  case 6:
    tmp = fieldFromInstruction(insn, 0, 10);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 7:
    tmp = fieldFromInstruction(insn, 0, 10);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 8:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 4), 0, 4);
    insertBits(tmp, fieldFromInstruction(insn, 16, 16), 4, 16);
    if (!Check(S, DecodeMemOperand(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 9:
    tmp = fieldFromInstruction(insn, 16, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 10:
    tmp = fieldFromInstruction(insn, 8, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 11:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 8, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 12:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 8, 4);
    if (!Check(S, DecodeGR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 13:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 8, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 14:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 8, 4);
    if (!Check(S, DecodeGR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 15:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 4), 0, 4);
    insertBits(tmp, fieldFromInstruction(insn, 16, 16), 4, 16);
    if (!Check(S, DecodeMemOperand(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 8, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 16:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 4), 0, 4);
    insertBits(tmp, fieldFromInstruction(insn, 16, 16), 4, 16);
    if (!Check(S, DecodeMemOperand(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 8, 4);
    if (!Check(S, DecodeGR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 17:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 4, 2), 4, 2);
    insertBits(tmp, fieldFromInstruction(insn, 8, 4), 0, 4);
    if (!Check(S, DecodeCGImm(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 18:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 4, 2), 4, 2);
    insertBits(tmp, fieldFromInstruction(insn, 8, 4), 0, 4);
    if (!Check(S, DecodeCGImm(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 19:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 4, 2), 4, 2);
    insertBits(tmp, fieldFromInstruction(insn, 8, 4), 0, 4);
    if (!Check(S, DecodeCGImm(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 20:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 4, 2), 4, 2);
    insertBits(tmp, fieldFromInstruction(insn, 8, 4), 0, 4);
    if (!Check(S, DecodeCGImm(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 21:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 4), 0, 4);
    insertBits(tmp, fieldFromInstruction(insn, 16, 16), 4, 16);
    if (!Check(S, DecodeMemOperand(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 4, 2), 4, 2);
    insertBits(tmp, fieldFromInstruction(insn, 8, 4), 0, 4);
    if (!Check(S, DecodeCGImm(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 22:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 8, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 8, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 23:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 8, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 24:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 8, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 8, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 25:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 8, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 8, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 26:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 8, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 27:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 8, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 8, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 28:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 8, 4), 0, 4);
    insertBits(tmp, fieldFromInstruction(insn, 16, 16), 4, 16);
    if (!Check(S, DecodeMemOperand(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 29:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 8, 4), 0, 4);
    insertBits(tmp, fieldFromInstruction(insn, 16, 16), 4, 16);
    if (!Check(S, DecodeMemOperand(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 30:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 31:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 8, 4), 0, 4);
    insertBits(tmp, fieldFromInstruction(insn, 16, 16), 4, 16);
    if (!Check(S, DecodeMemOperand(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 32:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 33:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 8, 4), 0, 4);
    insertBits(tmp, fieldFromInstruction(insn, 16, 16), 4, 16);
    if (!Check(S, DecodeMemOperand(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 34:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 35:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 8, 4), 0, 4);
    insertBits(tmp, fieldFromInstruction(insn, 16, 16), 4, 16);
    if (!Check(S, DecodeMemOperand(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 36:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 37:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 4), 0, 4);
    insertBits(tmp, fieldFromInstruction(insn, 32, 16), 4, 16);
    if (!Check(S, DecodeMemOperand(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 8, 4), 0, 4);
    insertBits(tmp, fieldFromInstruction(insn, 16, 16), 4, 16);
    if (!Check(S, DecodeMemOperand(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 38:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 4), 0, 4);
    insertBits(tmp, fieldFromInstruction(insn, 32, 16), 4, 16);
    if (!Check(S, DecodeMemOperand(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  }
}

static unsigned decodeNumToSkip(const uint8_t *&Ptr) {
  unsigned NumToSkip = *Ptr++;
  NumToSkip |= (*Ptr++) << 8;
  return NumToSkip;
}

template <typename InsnType>
static DecodeStatus decodeInstruction(const uint8_t DecodeTable[], MCInst &MI,
                                      InsnType insn, uint64_t Address,
                                      const MCDisassembler *DisAsm,
                                      const MCSubtargetInfo &STI) {

  const uint8_t *Ptr = DecodeTable;
  uint64_t CurFieldValue = 0;
  DecodeStatus S = MCDisassembler::Success;
  while (true) {
    ptrdiff_t Loc = Ptr - DecodeTable;
    const uint8_t DecoderOp = *Ptr++;
    switch (DecoderOp) {
    default:
      errs() << Loc << ": Unexpected decode table opcode: "
             << (int)DecoderOp << '\n';
      return MCDisassembler::Fail;
    case MCD::OPC_ExtractField: {
      // Decode the start value.
      unsigned Start = decodeULEB128AndIncUnsafe(Ptr);
      unsigned Len = *Ptr++;
      CurFieldValue = fieldFromInstruction(insn, Start, Len);
      LLVM_DEBUG(dbgs() << Loc << ": OPC_ExtractField(" << Start << ", "
                   << Len << "): " << CurFieldValue << "\n");
      break;
    }
    case MCD::OPC_FilterValue:
    case MCD::OPC_FilterValueOrFail: {
      bool IsFail = DecoderOp == MCD::OPC_FilterValueOrFail;
      // Decode the field value.
      uint64_t Val = decodeULEB128AndIncUnsafe(Ptr);
      bool Failed = Val != CurFieldValue;
      unsigned NumToSkip = IsFail ? 0 : decodeNumToSkip(Ptr);

      // Note: Print NumToSkip even for OPC_FilterValueOrFail to simplify debug
      // prints.
      LLVM_DEBUG({
        StringRef OpName = IsFail ? "OPC_FilterValueOrFail" : "OPC_FilterValue";
        dbgs() << Loc << ": " << OpName << '(' << Val << ", " << NumToSkip
                << ") " << (Failed ? "FAIL:" : "PASS:")
                << " continuing at " << (Ptr - DecodeTable) << '\n';
      });

      // Perform the filter operation.
      if (Failed) {
        if (IsFail)
          return MCDisassembler::Fail;
        Ptr += NumToSkip;
      }
      break;
    }
    case MCD::OPC_CheckField:
    case MCD::OPC_CheckFieldOrFail: {
      bool IsFail = DecoderOp == MCD::OPC_CheckFieldOrFail;
      // Decode the start value.
      unsigned Start = decodeULEB128AndIncUnsafe(Ptr);
      unsigned Len = *Ptr;
      uint64_t FieldValue = fieldFromInstruction(insn, Start, Len);
      // Decode the field value.
      unsigned PtrLen = 0;
      uint64_t ExpectedValue = decodeULEB128(++Ptr, &PtrLen);
      Ptr += PtrLen;
      bool Failed = ExpectedValue != FieldValue;
      unsigned NumToSkip = IsFail ? 0 : decodeNumToSkip(Ptr);

      LLVM_DEBUG({
        StringRef OpName = IsFail ? "OPC_CheckFieldOrFail" : "OPC_CheckField";
        dbgs() << Loc << ": " << OpName << '(' << Start << ", " << Len << ", "
                << ExpectedValue << ", " << NumToSkip << "): FieldValue = "
                << FieldValue << ", ExpectedValue = " << ExpectedValue << ": "
                << (Failed ? "FAIL\n" : "PASS\n");
      });

      // If the actual and expected values don't match, skip or fail.
      if (Failed) {
        if (IsFail)
          return MCDisassembler::Fail;
        Ptr += NumToSkip;
      }
      break;
    }
    case MCD::OPC_Decode: {
      // Decode the Opcode value.
      unsigned Opc = decodeULEB128AndIncUnsafe(Ptr);
      unsigned DecodeIdx = decodeULEB128AndIncUnsafe(Ptr);

      MI.clear();
      MI.setOpcode(Opc);
      bool DecodeComplete;
      S = decodeToMCInst(DecodeIdx, S, insn, MI, Address, DisAsm, DecodeComplete);
      assert(DecodeComplete);

      LLVM_DEBUG(dbgs() << Loc << ": OPC_Decode: opcode " << Opc
                   << ", using decoder " << DecodeIdx << ": "
                   << (S != MCDisassembler::Fail ? "PASS\n" : "FAIL\n"));
      return S;
    }
    case MCD::OPC_Fail: {
      LLVM_DEBUG(dbgs() << Loc << ": OPC_Fail\n");
      return MCDisassembler::Fail;
    }
    }
  }
  llvm_unreachable("bogosity detected in disassembler state machine!");
}


} // namespace
