/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* AArch64PostLegalizerCombinerImpl Combiner Match Table                      *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GICOMBINER_DEPS
#include "llvm/ADT/SparseBitVector.h"
namespace llvm {
extern cl::OptionCategory GICombinerOptionCategory;
} // end namespace llvm
#endif // ifdef GET_GICOMBINER_DEPS

#ifdef GET_GICOMBINER_TYPES
struct AArch64PostLegalizerCombinerImplRuleConfig {
  SparseBitVector<> DisabledRules;

  bool isRuleEnabled(unsigned RuleID) const;
  bool parseCommandLineOption();
  bool setRuleEnabled(StringRef RuleIdentifier);
  bool setRuleDisabled(StringRef RuleIdentifier);
};

static std::optional<uint64_t> getRuleIdxForIdentifier(StringRef RuleIdentifier) {
  uint64_t I;
  // getAtInteger(...) returns false on success
  bool Parsed = !RuleIdentifier.getAsInteger(0, I);
  if (Parsed)
    return I;

#ifndef NDEBUG
  switch (RuleIdentifier.size()) {
  default: break;
  case 9:	 // 3 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "opy_prop", 8) != 0)
        break;
      return 0;	 // "copy_prop"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ul_const", 8) != 0)
        break;
      return 24;	 // "mul_const"
    case 'o':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "r_to_bsp", 8) != 0)
        break;
      return 85;	 // "or_to_bsp"
    }
    break;
  case 10:	 // 2 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "2p_to_p2i", 9) != 0)
        break;
      return 56;	 // "i2p_to_p2i"
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "2i_to_i2p", 9) != 0)
        break;
      return 55;	 // "p2i_to_i2p"
    }
    break;
  case 11:	 // 3 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "dd_sub_reg", 10) != 0)
        break;
      return 61;	 // "add_sub_reg"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "atch_addos", 10) != 0)
        break;
      return 32;	 // "match_addos"
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nmerge_cst", 10) != 0)
        break;
      return 42;	 // "unmerge_cst"
    }
    break;
  case 12:	 // 4 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtmultomull", 11) != 0)
        break;
      return 94;	 // "extmultomull"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "edundant_or", 11) != 0)
        break;
      return 23;	 // "redundant_or"
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ext_of_sext", 11) != 0)
        break;
      return 6;	 // "sext_of_sext"
    case 'z':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ext_of_zext", 11) != 0)
        break;
      return 4;	 // "zext_of_zext"
    }
    break;
  case 13:	 // 6 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'l':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "oad_and_mask", 12) != 0)
        break;
      return 16;	 // "load_and_mask"
    case 'm':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "tch_selects", 11) != 0)
          break;
        return 37;	 // "match_selects"
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "rge_unmerge", 11) != 0)
          break;
        return 41;	 // "merge_unmerge"
      }
      break;
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "edundant_and", 12) != 0)
        break;
      return 20;	 // "redundant_and"
    case 'u':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "nmerge_", 7) != 0)
        break;
      switch (RuleIdentifier[8]) {
      default: break;
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+9, "erge", 4) != 0)
          break;
        return 40;	 // "unmerge_merge"
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+9, "ndef", 4) != 0)
          break;
        return 43;	 // "unmerge_undef"
      }
      break;
    }
    break;
  case 14:	 // 6 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'a':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "nyext_of_", 9) != 0)
        break;
      switch (RuleIdentifier[10]) {
      default: break;
      case 's':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+11, "ext", 3) != 0)
          break;
        return 10;	 // "anyext_of_sext"
      case 'z':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+11, "ext", 3) != 0)
          break;
        return 9;	 // "anyext_of_zext"
      }
      break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "inop_same_val", 13) != 0)
        break;
      return 52;	 // "binop_same_val"
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "neg_fneg_fold", 13) != 0)
        break;
      return 58;	 // "fneg_fneg_fold"
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ext_of_anyext", 13) != 0)
        break;
      return 7;	 // "sext_of_anyext"
    case 'z':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ext_of_anyext", 13) != 0)
        break;
      return 5;	 // "zext_of_anyext"
    }
    break;
  case 15:	 // 3 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtending_loads", 14) != 0)
        break;
      return 15;	 // "extending_loads"
    case 'o':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "verlapping_and", 14) != 0)
        break;
      return 70;	 // "overlapping_and"
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "elect_same_val", 14) != 0)
        break;
      return 50;	 // "select_same_val"
    }
    break;
  case 16:	 // 7 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nyext_of_anyext", 15) != 0)
        break;
      return 8;	 // "anyext_of_anyext"
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_mul_cmlt", 15) != 0)
        break;
      return 92;	 // "combine_mul_cmlt"
    case 's':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "elect_", 6) != 0)
        break;
      switch (RuleIdentifier[7]) {
      default: break;
      case 't':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+8, "o_minmax", 8) != 0)
          break;
        return 84;	 // "select_to_minmax"
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+8, "ndef_cmp", 8) != 0)
          break;
        return 34;	 // "select_undef_cmp"
      }
      break;
    case 't':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "runcate_of_", 11) != 0)
        break;
      switch (RuleIdentifier[12]) {
      default: break;
      case 's':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+13, "ext", 3) != 0)
          break;
        return 2;	 // "truncate_of_sext"
      case 'z':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+13, "ext", 3) != 0)
          break;
        return 1;	 // "truncate_of_zext"
      }
      break;
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ndef_to_fp_zero", 15) != 0)
        break;
      return 72;	 // "undef_to_fp_zero"
    }
    break;
  case 17:	 // 4 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nyext_trunc_fold", 16) != 0)
        break;
      return 57;	 // "anyext_trunc_fold"
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "rase_undef_store", 16) != 0)
        break;
      return 82;	 // "erase_undef_store"
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "elect_to_iminmax", 16) != 0)
        break;
      return 36;	 // "select_to_iminmax"
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ndef_to_int_zero", 16) != 0)
        break;
      return 73;	 // "undef_to_int_zero"
    }
    break;
  case 18:	 // 4 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "inop_left_to_zero", 17) != 0)
        break;
      return 53;	 // "binop_left_to_zero"
    case 'f':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'o':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ld_merge_to_zext", 16) != 0)
          break;
        return 38;	 // "fold_merge_to_zext"
      case 'p':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "trunc_fpext_fold", 16) != 0)
          break;
        return 66;	 // "fptrunc_fpext_fold"
      }
      break;
    case 't':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "runcate_of_anyext", 17) != 0)
        break;
      return 3;	 // "truncate_of_anyext"
    }
    break;
  case 19:	 // 10 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "inop_right_to_zero", 18) != 0)
        break;
      return 54;	 // "binop_right_to_zero"
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "onstant_fold_binop", 18) != 0)
        break;
      return 48;	 // "constant_fold_binop"
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nteger_of_truncate", 18) != 0)
        break;
      return 13;	 // "integer_of_truncate"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "erge_of_x_and_zero", 18) != 0)
        break;
      return 47;	 // "merge_of_x_and_zero"
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "tr_add_immed_chain", 18) != 0)
        break;
      return 69;	 // "ptr_add_immed_chain"
    case 'r':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'i':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ght_identity_zero", 17) != 0)
          break;
        return 51;	 // "right_identity_zero"
      case 'o':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "tate_out_of_range", 17) != 0)
          break;
        return 30;	 // "rotate_out_of_range"
      }
      break;
    case 's':	 // 2 strings to match.
      if (RuleIdentifier[1] != 'e')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'l':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "ect_constant_cmp", 16) != 0)
          break;
        return 35;	 // "select_constant_cmp"
      case 'x':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "t_trunc_sextload", 16) != 0)
          break;
        return 18;	 // "sext_trunc_sextload"
      }
      break;
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nary_undef_to_zero", 18) != 0)
        break;
      return 77;	 // "unary_undef_to_zero"
    }
    break;
  case 20:	 // 6 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "itcast_bitcast_fold", 19) != 0)
        break;
      return 65;	 // "bitcast_bitcast_fold"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "erge_of_x_and_undef", 19) != 0)
        break;
      return 46;	 // "merge_of_x_and_undef"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "edundant_sext_inreg", 19) != 0)
        break;
      return 25;	 // "redundant_sext_inreg"
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "plit_store_zero_128", 19) != 0)
        break;
      return 71;	 // "split_store_zero_128"
    case 'u':	 // 2 strings to match.
      if (RuleIdentifier[1] != 'n')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "ry_undef_to_undef", 17) != 0)
          break;
        return 78;	 // "unary_undef_to_undef"
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "erge_zext_to_zext", 17) != 0)
          break;
        return 45;	 // "unmerge_zext_to_zext"
      }
      break;
    }
    break;
  case 21:	 // 5 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_concat_vector", 20) != 0)
        break;
      return 86;	 // "combine_concat_vector"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "utate_anyext_to_zext", 20) != 0)
        break;
      return 14;	 // "mutate_anyext_to_zext"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ight_identity_one_fp", 20) != 0)
        break;
      return 60;	 // "right_identity_one_fp"
    case 'u':	 // 2 strings to match.
      if (RuleIdentifier[1] != 'n')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "ef_to_negative_one", 18) != 0)
          break;
        return 74;	 // "undef_to_negative_one"
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "erge_dead_to_trunc", 18) != 0)
          break;
        return 44;	 // "unmerge_dead_to_trunc"
      }
      break;
    }
    break;
  case 22:	 // 5 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "onstant_fold_fp_binop", 21) != 0)
        break;
      return 49;	 // "constant_fold_fp_binop"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "atch_subo_no_overflow", 21) != 0)
        break;
      return 33;	 // "match_subo_no_overflow"
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ropagate_undef_any_op", 21) != 0)
        break;
      return 79;	 // "propagate_undef_any_op"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ight_identity_one_int", 21) != 0)
        break;
      return 59;	 // "right_identity_one_int"
    case 't':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "runc_buildvector_fold", 21) != 0)
        break;
      return 63;	 // "trunc_buildvector_fold"
    }
    break;
  case 23:	 // 2 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "uildvector_of_truncate", 22) != 0)
        break;
      return 12;	 // "buildvector_of_truncate"
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ropagate_undef_all_ops", 22) != 0)
        break;
      return 80;	 // "propagate_undef_all_ops"
    }
    break;
  case 24:	 // 3 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "inop_left_undef_to_zero", 23) != 0)
        break;
      return 75;	 // "binop_left_undef_to_zero"
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ext_inreg_of_sext_inreg", 23) != 0)
        break;
      return 11;	 // "sext_inreg_of_sext_inreg"
    case 'x':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "or_of_and_with_same_reg", 23) != 0)
        break;
      return 21;	 // "xor_of_and_with_same_reg"
    }
    break;
  case 25:	 // 5 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'i':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+2, "tfield_extract_from_", 20) != 0)
          break;
        switch (RuleIdentifier[22]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+23, "nd", 2) != 0)
            break;
          return 27;	 // "bitfield_extract_from_and"
        case 's':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+23, "hr", 2) != 0)
            break;
          return 28;	 // "bitfield_extract_from_shr"
        }
        break;
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ildvector_identity_fold", 23) != 0)
          break;
        return 62;	 // "buildvector_identity_fold"
      }
      break;
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtract_vec_elt_build_vec", 24) != 0)
        break;
      return 89;	 // "extract_vec_elt_build_vec"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ight_identity_neg_one_fp", 24) != 0)
        break;
      return 68;	 // "right_identity_neg_one_fp"
    }
    break;
  case 26:	 // 5 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "inop_right_undef_to_undef", 25) != 0)
        break;
      return 76;	 // "binop_right_undef_to_undef"
    case 'c':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "om", 2) != 0)
        break;
      switch (RuleIdentifier[3]) {
      default: break;
      case 'b':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+4, "ine_indexed_load_store", 22) != 0)
          break;
        return 17;	 // "combine_indexed_load_store"
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+4, "ute_fp_constant_to_rhs", 22) != 0)
          break;
        return 88;	 // "commute_fp_constant_to_rhs"
      }
      break;
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtractvecelt_pairwise_add", 25) != 0)
        break;
      return 22;	 // "extractvecelt_pairwise_add"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ight_identity_neg_zero_fp", 25) != 0)
        break;
      return 67;	 // "right_identity_neg_zero_fp"
    }
    break;
  case 27:	 // 4 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "om", 2) != 0)
        break;
      switch (RuleIdentifier[3]) {
      default: break;
      case 'b':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+4, "ine_use_vector_truncate", 23) != 0)
          break;
        return 93;	 // "combine_use_vector_truncate"
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+4, "ute_int_constant_to_rhs", 23) != 0)
          break;
        return 87;	 // "commute_int_constant_to_rhs"
      }
      break;
    case 't':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "runc_lshr_buildvector_fold", 26) != 0)
        break;
      return 64;	 // "trunc_lshr_buildvector_fold"
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nmerge_anyext_build_vector", 26) != 0)
        break;
      return 39;	 // "unmerge_anyext_build_vector"
    }
    break;
  case 28:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "propagate_undef_shuffle_mask", 28) != 0)
      break;
    return 81;	 // "propagate_undef_shuffle_mask"
  case 29:	 // 2 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "itfield_extract_from_shr_and", 28) != 0)
        break;
      return 29;	 // "bitfield_extract_from_shr_and"
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "cmp_to_true_false_known_bits", 28) != 0)
        break;
      return 31;	 // "icmp_to_true_false_known_bits"
    }
    break;
  case 32:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "bitfield_extract_from_sext_inreg", 32) != 0)
      break;
    return 26;	 // "bitfield_extract_from_sext_inreg"
  case 34:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "extract_all_elts_from_build_vector", 34) != 0)
      break;
    return 90;	 // "extract_all_elts_from_build_vector"
  case 36:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "insert_extract_vec_elt_out_of_bounds", 36) != 0)
      break;
    return 83;	 // "insert_extract_vec_elt_out_of_bounds"
  case 37:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "hoist_logic_op_with_same_opcode_hands", 37) != 0)
      break;
    return 19;	 // "hoist_logic_op_with_same_opcode_hands"
  case 46:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "push_freeze_to_prevent_poison_from_propagating", 46) != 0)
      break;
    return 91;	 // "push_freeze_to_prevent_poison_from_propagating"
  }
#endif // ifndef NDEBUG

  return std::nullopt;
}
static std::optional<std::pair<uint64_t, uint64_t>> getRuleRangeForIdentifier(StringRef RuleIdentifier) {
  std::pair<StringRef, StringRef> RangePair = RuleIdentifier.split('-');
  if (!RangePair.second.empty()) {
    const auto First = getRuleIdxForIdentifier(RangePair.first);
    const auto Last = getRuleIdxForIdentifier(RangePair.second);
    if (!First || !Last)
      return std::nullopt;
    if (First >= Last)
      report_fatal_error("Beginning of range should be before end of range");
    return {{*First, *Last + 1}};
  }
  if (RangePair.first == "*") {
    return {{0, 95}};
  }
  const auto I = getRuleIdxForIdentifier(RangePair.first);
  if (!I)
    return std::nullopt;
  return {{*I, *I + 1}};
}

bool AArch64PostLegalizerCombinerImplRuleConfig::setRuleEnabled(StringRef RuleIdentifier) {
  auto MaybeRange = getRuleRangeForIdentifier(RuleIdentifier);
  if (!MaybeRange)
    return false;
  for (auto I = MaybeRange->first; I < MaybeRange->second; ++I)
    DisabledRules.reset(I);
  return true;
}

bool AArch64PostLegalizerCombinerImplRuleConfig::setRuleDisabled(StringRef RuleIdentifier) {
  auto MaybeRange = getRuleRangeForIdentifier(RuleIdentifier);
  if (!MaybeRange)
    return false;
  for (auto I = MaybeRange->first; I < MaybeRange->second; ++I)
    DisabledRules.set(I);
  return true;
}

static std::vector<std::string> AArch64PostLegalizerCombinerOption;
static cl::list<std::string> AArch64PostLegalizerCombinerDisableOption(
    "aarch64postlegalizercombiner-disable-rule",
    cl::desc("Disable one or more combiner rules temporarily in the AArch64PostLegalizerCombiner pass"),
    cl::CommaSeparated,
    cl::Hidden,
    cl::cat(GICombinerOptionCategory),
    cl::callback([](const std::string &Str) {
      AArch64PostLegalizerCombinerOption.push_back(Str);
    }));
static cl::list<std::string> AArch64PostLegalizerCombinerOnlyEnableOption(
    "aarch64postlegalizercombiner-only-enable-rule",
    cl::desc("Disable all rules in the AArch64PostLegalizerCombiner pass then re-enable the specified ones"),
    cl::Hidden,
    cl::cat(GICombinerOptionCategory),
    cl::callback([](const std::string &CommaSeparatedArg) {
      StringRef Str = CommaSeparatedArg;
      AArch64PostLegalizerCombinerOption.push_back("*");
      do {
        auto X = Str.split(",");
        AArch64PostLegalizerCombinerOption.push_back(("!" + X.first).str());
        Str = X.second;
      } while (!Str.empty());
    }));


bool AArch64PostLegalizerCombinerImplRuleConfig::isRuleEnabled(unsigned RuleID) const {
    return  !DisabledRules.test(RuleID);
}
bool AArch64PostLegalizerCombinerImplRuleConfig::parseCommandLineOption() {
  for (StringRef Identifier : AArch64PostLegalizerCombinerOption) {
    bool Enabled = Identifier.consume_front("!");
    if (Enabled && !setRuleEnabled(Identifier))
      return false;
    if (!Enabled && !setRuleDisabled(Identifier))
      return false;
  }
  return true;
}

#endif // ifdef GET_GICOMBINER_TYPES

#ifdef GET_GICOMBINER_TYPES
const unsigned MAX_SUBTARGET_PREDICATES = 0;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GICOMBINER_TYPES

#ifdef GET_GICOMBINER_CLASS_MEMBERS
PredicateBitset AvailableModuleFeatures;
mutable PredicateBitset AvailableFunctionFeatures;
PredicateBitset getAvailableFeatures() const {
  return AvailableModuleFeatures | AvailableFunctionFeatures;
}
PredicateBitset
computeAvailableModuleFeatures(const AArch64Subtarget *Subtarget) const;
PredicateBitset
computeAvailableFunctionFeatures(const AArch64Subtarget *Subtarget,
                                 const MachineFunction *MF) const;
void setupGeneratedPerFunctionState(MachineFunction &MF) override;
#endif // ifdef GET_GICOMBINER_CLASS_MEMBERS
#ifdef GET_GICOMBINER_CLASS_MEMBERS
  mutable MatcherState State;
  typedef ComplexRendererFns(AArch64PostLegalizerCombinerImpl::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(AArch64PostLegalizerCombinerImpl::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static AArch64PostLegalizerCombinerImpl::ComplexMatcherMemFn ComplexPredicateFns[];
  static AArch64PostLegalizerCombinerImpl::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testMOPredicate_MO(unsigned PredicateID, const MachineOperand &MO, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GICOMBINER_CLASS_MEMBERS

#ifdef GET_GICOMBINER_IMPL
// LLT Objects.
enum {
  GILLT_s1,
};
const static size_t NumTypeObjects = 1;
const static LLT TypeObjects[] = {
  LLT::scalar(1),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
};

PredicateBitset AArch64PostLegalizerCombinerImpl::
computeAvailableModuleFeatures(const AArch64Subtarget *Subtarget) const {
  PredicateBitset Features{};
  return Features;
}

void AArch64PostLegalizerCombinerImpl::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const AArch64Subtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset AArch64PostLegalizerCombinerImpl::
computeAvailableFunctionFeatures(const AArch64Subtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

AArch64PostLegalizerCombinerImpl::ComplexMatcherMemFn
AArch64PostLegalizerCombinerImpl::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

enum {
  GICXXPred_MI_Predicate_GICombiner0 = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_GICombiner1,
  GICXXPred_MI_Predicate_GICombiner2,
};
bool AArch64PostLegalizerCombinerImpl::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_GICombiner0: {
    return Helper.matchConstantFPOp(State.MIs[0]->getOperand(2), 1.0);
  }
  case GICXXPred_MI_Predicate_GICombiner1: {
    return Helper.matchConstantFPOp(State.MIs[0]->getOperand(2), -0.0);
  }
  case GICXXPred_MI_Predicate_GICombiner2: {
    return Helper.matchConstantFPOp(State.MIs[0]->getOperand(2), -1.0);
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AArch64PostLegalizerCombinerImpl::testMOPredicate_MO(unsigned PredicateID, const MachineOperand & MO, const MatcherState &State) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AArch64PostLegalizerCombinerImpl::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AArch64PostLegalizerCombinerImpl::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AArch64PostLegalizerCombinerImpl::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
enum {
  GICXXPred_Simple_IsRule0Enabled = GICXXPred_Invalid + 1,
  GICXXPred_Simple_IsRule1Enabled,
  GICXXPred_Simple_IsRule2Enabled,
  GICXXPred_Simple_IsRule3Enabled,
  GICXXPred_Simple_IsRule4Enabled,
  GICXXPred_Simple_IsRule5Enabled,
  GICXXPred_Simple_IsRule6Enabled,
  GICXXPred_Simple_IsRule7Enabled,
  GICXXPred_Simple_IsRule8Enabled,
  GICXXPred_Simple_IsRule9Enabled,
  GICXXPred_Simple_IsRule10Enabled,
  GICXXPred_Simple_IsRule11Enabled,
  GICXXPred_Simple_IsRule12Enabled,
  GICXXPred_Simple_IsRule13Enabled,
  GICXXPred_Simple_IsRule14Enabled,
  GICXXPred_Simple_IsRule15Enabled,
  GICXXPred_Simple_IsRule16Enabled,
  GICXXPred_Simple_IsRule17Enabled,
  GICXXPred_Simple_IsRule18Enabled,
  GICXXPred_Simple_IsRule19Enabled,
  GICXXPred_Simple_IsRule20Enabled,
  GICXXPred_Simple_IsRule21Enabled,
  GICXXPred_Simple_IsRule22Enabled,
  GICXXPred_Simple_IsRule23Enabled,
  GICXXPred_Simple_IsRule24Enabled,
  GICXXPred_Simple_IsRule25Enabled,
  GICXXPred_Simple_IsRule26Enabled,
  GICXXPred_Simple_IsRule27Enabled,
  GICXXPred_Simple_IsRule28Enabled,
  GICXXPred_Simple_IsRule29Enabled,
  GICXXPred_Simple_IsRule30Enabled,
  GICXXPred_Simple_IsRule31Enabled,
  GICXXPred_Simple_IsRule32Enabled,
  GICXXPred_Simple_IsRule33Enabled,
  GICXXPred_Simple_IsRule34Enabled,
  GICXXPred_Simple_IsRule35Enabled,
  GICXXPred_Simple_IsRule36Enabled,
  GICXXPred_Simple_IsRule37Enabled,
  GICXXPred_Simple_IsRule38Enabled,
  GICXXPred_Simple_IsRule39Enabled,
  GICXXPred_Simple_IsRule40Enabled,
  GICXXPred_Simple_IsRule41Enabled,
  GICXXPred_Simple_IsRule42Enabled,
  GICXXPred_Simple_IsRule43Enabled,
  GICXXPred_Simple_IsRule44Enabled,
  GICXXPred_Simple_IsRule45Enabled,
  GICXXPred_Simple_IsRule46Enabled,
  GICXXPred_Simple_IsRule47Enabled,
  GICXXPred_Simple_IsRule48Enabled,
  GICXXPred_Simple_IsRule49Enabled,
  GICXXPred_Simple_IsRule50Enabled,
  GICXXPred_Simple_IsRule51Enabled,
  GICXXPred_Simple_IsRule52Enabled,
  GICXXPred_Simple_IsRule53Enabled,
  GICXXPred_Simple_IsRule54Enabled,
  GICXXPred_Simple_IsRule55Enabled,
  GICXXPred_Simple_IsRule56Enabled,
  GICXXPred_Simple_IsRule57Enabled,
  GICXXPred_Simple_IsRule58Enabled,
  GICXXPred_Simple_IsRule59Enabled,
  GICXXPred_Simple_IsRule60Enabled,
  GICXXPred_Simple_IsRule61Enabled,
  GICXXPred_Simple_IsRule62Enabled,
  GICXXPred_Simple_IsRule63Enabled,
  GICXXPred_Simple_IsRule64Enabled,
  GICXXPred_Simple_IsRule65Enabled,
  GICXXPred_Simple_IsRule66Enabled,
  GICXXPred_Simple_IsRule67Enabled,
  GICXXPred_Simple_IsRule68Enabled,
  GICXXPred_Simple_IsRule69Enabled,
  GICXXPred_Simple_IsRule70Enabled,
  GICXXPred_Simple_IsRule71Enabled,
  GICXXPred_Simple_IsRule72Enabled,
  GICXXPred_Simple_IsRule73Enabled,
  GICXXPred_Simple_IsRule74Enabled,
  GICXXPred_Simple_IsRule75Enabled,
  GICXXPred_Simple_IsRule76Enabled,
  GICXXPred_Simple_IsRule77Enabled,
  GICXXPred_Simple_IsRule78Enabled,
  GICXXPred_Simple_IsRule79Enabled,
  GICXXPred_Simple_IsRule80Enabled,
  GICXXPred_Simple_IsRule81Enabled,
  GICXXPred_Simple_IsRule82Enabled,
  GICXXPred_Simple_IsRule83Enabled,
  GICXXPred_Simple_IsRule84Enabled,
  GICXXPred_Simple_IsRule85Enabled,
  GICXXPred_Simple_IsRule86Enabled,
  GICXXPred_Simple_IsRule87Enabled,
  GICXXPred_Simple_IsRule88Enabled,
  GICXXPred_Simple_IsRule89Enabled,
  GICXXPred_Simple_IsRule90Enabled,
  GICXXPred_Simple_IsRule91Enabled,
  GICXXPred_Simple_IsRule92Enabled,
  GICXXPred_Simple_IsRule93Enabled,
  GICXXPred_Simple_IsRule94Enabled,
};

bool AArch64PostLegalizerCombinerImpl::testSimplePredicate(unsigned Predicate) const {
    return RuleConfig.isRuleEnabled(Predicate - GICXXPred_Invalid - 1);
}
// Custom renderers.
enum {
  GICR_Invalid,
};
AArch64PostLegalizerCombinerImpl::CustomRendererFn
AArch64PostLegalizerCombinerImpl::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool AArch64PostLegalizerCombinerImpl::tryCombineAll(MachineInstr &I) const {
  const TargetSubtargetInfo &ST = MF.getSubtarget();
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  B.setInstrAndDebugLoc(I);
  State.MIs.clear();
  State.MIs.push_back(&I);
  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), *ST.getInstrInfo(), MRI, *MRI.getTargetRegisterInfo(), *ST.getRegBankInfo(), AvailableFeatures, /*CoverageInfo*/ nullptr)) {
    return true;
  }

  return false;
}

enum {
  GICXXCustomAction_GICombiner0 = GICXXCustomAction_Invalid + 1,
  GICXXCustomAction_GICombiner1,
  GICXXCustomAction_GICombiner2,
  GICXXCustomAction_GICombiner3,
  GICXXCustomAction_GICombiner4,
  GICXXCustomAction_GICombiner5,
  GICXXCustomAction_GICombiner6,
  GICXXCustomAction_GICombiner7,
  GICXXCustomAction_GICombiner8,
  GICXXCustomAction_GICombiner9,
  GICXXCustomAction_GICombiner10,
  GICXXCustomAction_GICombiner11,
  GICXXCustomAction_GICombiner12,
  GICXXCustomAction_GICombiner13,
  GICXXCustomAction_GICombiner14,
  GICXXCustomAction_GICombiner15,
  GICXXCustomAction_GICombiner16,
  GICXXCustomAction_GICombiner17,
  GICXXCustomAction_GICombiner18,
  GICXXCustomAction_GICombiner19,
  GICXXCustomAction_GICombiner20,
  GICXXCustomAction_GICombiner21,
  GICXXCustomAction_GICombiner22,
  GICXXCustomAction_GICombiner23,
  GICXXCustomAction_GICombiner24,
  GICXXCustomAction_GICombiner25,
  GICXXCustomAction_GICombiner26,
  GICXXCustomAction_GICombiner27,
  GICXXCustomAction_GICombiner28,
  GICXXCustomAction_GICombiner29,
  GICXXCustomAction_GICombiner30,
  GICXXCustomAction_GICombiner31,
  GICXXCustomAction_GICombiner32,
  GICXXCustomAction_GICombiner33,
  GICXXCustomAction_GICombiner34,
  GICXXCustomAction_GICombiner35,
  GICXXCustomAction_GICombiner36,
  GICXXCustomAction_GICombiner37,
  GICXXCustomAction_GICombiner38,
  GICXXCustomAction_GICombiner39,
  GICXXCustomAction_GICombiner40,
  GICXXCustomAction_GICombiner41,
  GICXXCustomAction_GICombiner42,
  GICXXCustomAction_GICombiner43,
  GICXXCustomAction_GICombiner44,
  GICXXCustomAction_GICombiner45,
  GICXXCustomAction_GICombiner46,
  GICXXCustomAction_GICombiner47,
  GICXXCustomAction_GICombiner48,
  GICXXCustomAction_GICombiner49,
  GICXXCustomAction_GICombiner50,
  GICXXCustomAction_GICombiner51,
  GICXXCustomAction_GICombiner52,
  GICXXCustomAction_GICombiner53,
  GICXXCustomAction_GICombiner54,
  GICXXCustomAction_GICombiner55,
  GICXXCustomAction_GICombiner56,
  GICXXCustomAction_GICombiner57,
  GICXXCustomAction_GICombiner58,
  GICXXCustomAction_GICombiner59,
  GICXXCustomAction_GICombiner60,
  GICXXCustomAction_GICombiner61,
  GICXXCustomAction_GICombiner62,
  GICXXCustomAction_GICombiner63,
  GICXXCustomAction_GICombiner64,
  GICXXCustomAction_GICombiner65,
  GICXXCustomAction_GICombiner66,
  GICXXCustomAction_GICombiner67,
  GICXXCustomAction_GICombiner68,
  GICXXCustomAction_GICombiner69,
  GICXXCustomAction_GICombiner70,
  GICXXCustomAction_GICombiner71,
  GICXXCustomAction_GICombiner72,
  GICXXCustomAction_GICombiner73,
  GICXXCustomAction_GICombiner74,
};
bool AArch64PostLegalizerCombinerImpl::runCustomAction(unsigned ApplyID, const MatcherState &State, NewMIVector &OutMIs) const {
  Helper.getBuilder().setInstrAndDebugLoc(*State.MIs[0]);
  switch(ApplyID) {
  case GICXXCustomAction_GICombiner0:{
    // Match Patterns
    if(![&](){return Helper.matchCombineCopy(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineCopy(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner1:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchTruncateOfExt(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner2:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtOfExt(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner3:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchRedundantSextInReg(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner4:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCastOfBuildVector(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner5:{
    APInt GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCastOfInteger(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner6:{
    // Match Patterns
    if(![&](){return matchMutateAnyExtToZExt(*State.MIs[0], MRI);}()) {
      return false;
    }
    // Apply Patterns
    applyMutateAnyExtToZExt(*State.MIs[0], MRI, B, Observer);
    return true;
  }
  case GICXXCustomAction_GICombiner7:{
    PreferredTuple GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineExtendingLoads(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineExtendingLoads(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner8:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineLoadWithAndMask(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner9:{
    IndexedLoadStoreMatchInfo GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineIndexedLoadStore(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineIndexedLoadStore(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner10:{
    // Match Patterns
    if(![&](){return Helper.matchSextTruncSextLoad(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applySextTruncSextLoad(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner11:{
    InstructionStepsMatchInfo GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchHoistLogicOpWithSameOpcodeHands(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildInstructionSteps(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner12:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchRedundantAnd(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner13:{
    std::pair<Register, Register> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchXorOfAndWithSameReg(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyXorOfAndWithSameReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner14:{
    std::tuple<unsigned, LLT, Register> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return matchExtractVecEltPairwiseAdd(*State.MIs[0], MRI, GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    applyExtractVecEltPairwiseAdd(*State.MIs[0], MRI, B, GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner15:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchRedundantOr(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner16:{
    std::function<void(MachineIRBuilder&, Register)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return matchAArch64MulConstCombine(*State.MIs[0], MRI, GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    applyAArch64MulConstCombine(*State.MIs[0], MRI, B, GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner17:{
    // Match Patterns
    if(![&](){return Helper.matchRedundantSExtInReg(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], 1);
    return true;
  }
  case GICXXCustomAction_GICombiner18:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchBitfieldExtractFromSExtInReg(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner19:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchBitfieldExtractFromAnd(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner20:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchBitfieldExtractFromShr(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner21:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchBitfieldExtractFromShrAnd(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner22:{
    // Match Patterns
    if(![&](){return Helper.matchRotateOutOfRange(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyRotateOutOfRange(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner23:{
    int64_t GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchICmpToTrueFalseKnownBits(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner24:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchAddOverflow(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner25:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSuboCarryOut(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner26:{
    unsigned GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchConstantSelectCmp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner27:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchSelectIMinMax(State.MIs[0]->getOperand(0), GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner28:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSelect(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner29:{
    // Match Patterns
    if(![&](){return matchFoldMergeToZext(*State.MIs[0], MRI);}()) {
      return false;
    }
    // Apply Patterns
    applyFoldMergeToZext(*State.MIs[0], MRI, B, Observer);
    return true;
  }
  case GICXXCustomAction_GICombiner30:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchUnmergeValuesAnyExtBuildVector(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner31:{
    SmallVector<Register> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineUnmergeMergeToPlainValues(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineUnmergeMergeToPlainValues(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner32:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineMergeUnmerge(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner33:{
    SmallVector<APInt, 8> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineUnmergeConstant(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineUnmergeConstant(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner34:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineUnmergeUndef(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner35:{
    // Match Patterns
    if(![&](){return Helper.matchCombineUnmergeWithDeadLanesToTrunc(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineUnmergeWithDeadLanesToTrunc(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner36:{
    // Match Patterns
    if(![&](){return Helper.matchCombineUnmergeZExtToZExt(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineUnmergeZExtToZExt(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner37:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchMergeXAndUndef(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner38:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchMergeXAndZero(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner39:{
    APInt GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchConstantFoldBinOp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner40:{
    ConstantFP* GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchConstantFoldFPBinOp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithFConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner41:{
    // Match Patterns
    if(![&](){return Helper.matchSelectSameVal(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], 2);
    return true;
  }
  case GICXXCustomAction_GICombiner42:{
    // Match Patterns
    if(![&](){return Helper.matchOperandIsZero(*State.MIs[0], 1);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], 1);
    return true;
  }
  case GICXXCustomAction_GICombiner43:{
    Register GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineI2PToP2I(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineI2PToP2I(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner44:{
    Register GIMatchData_info;
    // Match Patterns
    if(![&](){GIMatchData_info = State.MIs[1]->getOperand(1).getReg(); return true;}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineP2IToI2P(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner45:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineAnyExtTrunc(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner46:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchBuildVectorIdentityFold(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner47:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchTruncBuildVectorFold(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner48:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchTruncLshrBuildVectorFold(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner49:{
    // Match Patterns
    if(![&](){return MRI.getType(State.MIs[1]->getOperand(1).getReg()) == MRI.getType(State.MIs[0]->getOperand(0).getReg());}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], State.MIs[1]->getOperand(1).getReg());
    return true;
  }
  case GICXXCustomAction_GICombiner50:{
    PtrAddChain GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchPtrAddImmedChain(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyPtrAddImmedChain(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner51:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchOverlappingAnd(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner52:{
    // Match Patterns
    if(![&](){return matchSplitStoreZero128(*State.MIs[0], MRI);}()) {
      return false;
    }
    // Apply Patterns
    applySplitStoreZero128(*State.MIs[0], MRI, B, Observer);
    return true;
  }
  case GICXXCustomAction_GICombiner53:{
    // Match Patterns
    if(![&](){return Helper.matchAnyExplicitUseIsUndef(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithFConstant(*State.MIs[0], 0.0);
    return true;
  }
  case GICXXCustomAction_GICombiner54:{
    // Match Patterns
    if(![&](){return Helper.matchAnyExplicitUseIsUndef(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], 0);
    return true;
  }
  case GICXXCustomAction_GICombiner55:{
    // Match Patterns
    if(![&](){return Helper.matchAnyExplicitUseIsUndef(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], -1);
    return true;
  }
  case GICXXCustomAction_GICombiner56:{
    // Match Patterns
    if(![&](){return Helper.matchOperandIsUndef(*State.MIs[0], 1);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], 0);
    return true;
  }
  case GICXXCustomAction_GICombiner57:{
    // Match Patterns
    if(![&](){return Helper.matchOperandIsUndef(*State.MIs[0], 2);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner58:{
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]->getOperand(0).getParent());
    return true;
  }
  case GICXXCustomAction_GICombiner59:{
    // Match Patterns
    if(![&](){return Helper.matchAnyExplicitUseIsUndef(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner60:{
    // Match Patterns
    if(![&](){return Helper.matchAllExplicitUsesAreUndef(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner61:{
    // Match Patterns
    if(![&](){return Helper.matchUndefShuffleVectorMask(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner62:{
    // Match Patterns
    if(![&](){return Helper.matchUndefStore(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.eraseInst(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner63:{
    // Match Patterns
    if(![&](){return Helper.matchInsertExtractVecEltOutOfBounds(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner64:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchSimplifySelectToMinMax(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner65:{
    std::tuple<Register, Register, Register> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return matchOrToBSP(*State.MIs[0], MRI, GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    applyOrToBSP(*State.MIs[0], MRI, B, GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner66:{
    SmallVector<Register> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineConcatVectors(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineConcatVectors(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner67:{
    // Match Patterns
    if(![&](){return Helper.matchCommuteConstantToRHS(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCommuteBinOpOperands(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner68:{
    // Match Patterns
    if(![&](){return Helper.matchCommuteFPConstantToRHS(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCommuteBinOpOperands(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner69:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractVecEltBuildVec(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyExtractVecEltBuildVec(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner70:{
    SmallVector<std::pair<Register, MachineInstr*>> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractAllEltsFromBuildVector(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyExtractAllEltsFromBuildVector(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner71:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return !isGuaranteedNotToBePoison(State.MIs[0]->getOperand(1).getReg(), MRI) && Helper.matchFreezeOfSingleMaybePoisonOperand(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner72:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return matchCombineMulCMLT(*State.MIs[0], MRI, GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    applyCombineMulCMLT(*State.MIs[0], MRI, B, GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner73:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchUseVectorTruncate(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyUseVectorTruncate(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner74:{
    std::tuple<bool, Register, Register> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return matchExtMulToMULL(*State.MIs[0], MRI, VT, GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    applyExtMulToMULL(*State.MIs[0], MRI, B, Observer, GIMatchData_matchinfo);
    return true;
  }
  }
  llvm_unreachable("Unknown Apply Action");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *AArch64PostLegalizerCombinerImpl::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
     /*    0 */ GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(20), GIMT_Encode2(245), /*)*//*default:*//*Label 75*/ GIMT_Encode4(3650),
     /*   10 */ /*TargetOpcode::COPY*//*Label 0*/ GIMT_Encode4(910), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  142 */ /*TargetOpcode::G_ADD*//*Label 1*/ GIMT_Encode4(922),
     /*  146 */ /*TargetOpcode::G_SUB*//*Label 2*/ GIMT_Encode4(1047),
     /*  150 */ /*TargetOpcode::G_MUL*//*Label 3*/ GIMT_Encode4(1093),
     /*  154 */ /*TargetOpcode::G_SDIV*//*Label 4*/ GIMT_Encode4(1206),
     /*  158 */ /*TargetOpcode::G_UDIV*//*Label 5*/ GIMT_Encode4(1229),
     /*  162 */ /*TargetOpcode::G_SREM*//*Label 6*/ GIMT_Encode4(1263),
     /*  166 */ /*TargetOpcode::G_UREM*//*Label 7*/ GIMT_Encode4(1286), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  178 */ /*TargetOpcode::G_AND*//*Label 8*/ GIMT_Encode4(1320),
     /*  182 */ /*TargetOpcode::G_OR*//*Label 9*/ GIMT_Encode4(1459),
     /*  186 */ /*TargetOpcode::G_XOR*//*Label 10*/ GIMT_Encode4(1573), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  226 */ /*TargetOpcode::G_UNMERGE_VALUES*//*Label 11*/ GIMT_Encode4(1652), GIMT_Encode4(0),
     /*  234 */ /*TargetOpcode::G_MERGE_VALUES*//*Label 12*/ GIMT_Encode4(1719),
     /*  238 */ /*TargetOpcode::G_BUILD_VECTOR*//*Label 13*/ GIMT_Encode4(1804),
     /*  242 */ /*TargetOpcode::G_BUILD_VECTOR_TRUNC*//*Label 14*/ GIMT_Encode4(1852),
     /*  246 */ /*TargetOpcode::G_CONCAT_VECTORS*//*Label 15*/ GIMT_Encode4(1864),
     /*  250 */ /*TargetOpcode::G_PTRTOINT*//*Label 16*/ GIMT_Encode4(1876),
     /*  254 */ /*TargetOpcode::G_INTTOPTR*//*Label 17*/ GIMT_Encode4(1919),
     /*  258 */ /*TargetOpcode::G_BITCAST*//*Label 18*/ GIMT_Encode4(1952),
     /*  262 */ /*TargetOpcode::G_FREEZE*//*Label 19*/ GIMT_Encode4(1995), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  302 */ /*TargetOpcode::G_LOAD*//*Label 20*/ GIMT_Encode4(2007),
     /*  306 */ /*TargetOpcode::G_SEXTLOAD*//*Label 21*/ GIMT_Encode4(2030),
     /*  310 */ /*TargetOpcode::G_ZEXTLOAD*//*Label 22*/ GIMT_Encode4(2053), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  326 */ /*TargetOpcode::G_STORE*//*Label 23*/ GIMT_Encode4(2076), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  462 */ /*TargetOpcode::G_ANYEXT*//*Label 24*/ GIMT_Encode4(2110),
     /*  466 */ /*TargetOpcode::G_TRUNC*//*Label 25*/ GIMT_Encode4(2217), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  498 */ /*TargetOpcode::G_SEXT*//*Label 26*/ GIMT_Encode4(2369),
     /*  502 */ /*TargetOpcode::G_SEXT_INREG*//*Label 27*/ GIMT_Encode4(2412),
     /*  506 */ /*TargetOpcode::G_ZEXT*//*Label 28*/ GIMT_Encode4(2467),
     /*  510 */ /*TargetOpcode::G_SHL*//*Label 29*/ GIMT_Encode4(2510),
     /*  514 */ /*TargetOpcode::G_LSHR*//*Label 30*/ GIMT_Encode4(2578),
     /*  518 */ /*TargetOpcode::G_ASHR*//*Label 31*/ GIMT_Encode4(2657), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  530 */ /*TargetOpcode::G_ROTR*//*Label 32*/ GIMT_Encode4(2736),
     /*  534 */ /*TargetOpcode::G_ROTL*//*Label 33*/ GIMT_Encode4(2771),
     /*  538 */ /*TargetOpcode::G_ICMP*//*Label 34*/ GIMT_Encode4(2806), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  554 */ /*TargetOpcode::G_SELECT*//*Label 35*/ GIMT_Encode4(2818),
     /*  558 */ /*TargetOpcode::G_UADDO*//*Label 36*/ GIMT_Encode4(2913), GIMT_Encode4(0),
     /*  566 */ /*TargetOpcode::G_USUBO*//*Label 37*/ GIMT_Encode4(2936), GIMT_Encode4(0),
     /*  574 */ /*TargetOpcode::G_SADDO*//*Label 38*/ GIMT_Encode4(2948), GIMT_Encode4(0),
     /*  582 */ /*TargetOpcode::G_SSUBO*//*Label 39*/ GIMT_Encode4(2971), GIMT_Encode4(0),
     /*  590 */ /*TargetOpcode::G_UMULO*//*Label 40*/ GIMT_Encode4(2983),
     /*  594 */ /*TargetOpcode::G_SMULO*//*Label 41*/ GIMT_Encode4(2995),
     /*  598 */ /*TargetOpcode::G_UMULH*//*Label 42*/ GIMT_Encode4(3007),
     /*  602 */ /*TargetOpcode::G_SMULH*//*Label 43*/ GIMT_Encode4(3019),
     /*  606 */ /*TargetOpcode::G_UADDSAT*//*Label 44*/ GIMT_Encode4(3031),
     /*  610 */ /*TargetOpcode::G_SADDSAT*//*Label 45*/ GIMT_Encode4(3043), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  630 */ /*TargetOpcode::G_SMULFIX*//*Label 46*/ GIMT_Encode4(3055),
     /*  634 */ /*TargetOpcode::G_UMULFIX*//*Label 47*/ GIMT_Encode4(3067),
     /*  638 */ /*TargetOpcode::G_SMULFIXSAT*//*Label 48*/ GIMT_Encode4(3079),
     /*  642 */ /*TargetOpcode::G_UMULFIXSAT*//*Label 49*/ GIMT_Encode4(3091), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  662 */ /*TargetOpcode::G_FADD*//*Label 50*/ GIMT_Encode4(3103),
     /*  666 */ /*TargetOpcode::G_FSUB*//*Label 51*/ GIMT_Encode4(3149),
     /*  670 */ /*TargetOpcode::G_FMUL*//*Label 52*/ GIMT_Encode4(3161), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  682 */ /*TargetOpcode::G_FDIV*//*Label 53*/ GIMT_Encode4(3227), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  730 */ /*TargetOpcode::G_FNEG*//*Label 54*/ GIMT_Encode4(3239), GIMT_Encode4(0),
     /*  738 */ /*TargetOpcode::G_FPTRUNC*//*Label 55*/ GIMT_Encode4(3269),
     /*  742 */ /*TargetOpcode::G_FPTOSI*//*Label 56*/ GIMT_Encode4(3291),
     /*  746 */ /*TargetOpcode::G_FPTOUI*//*Label 57*/ GIMT_Encode4(3313),
     /*  750 */ /*TargetOpcode::G_SITOFP*//*Label 58*/ GIMT_Encode4(3335),
     /*  754 */ /*TargetOpcode::G_UITOFP*//*Label 59*/ GIMT_Encode4(3347), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  782 */ /*TargetOpcode::G_FMINNUM*//*Label 60*/ GIMT_Encode4(3359),
     /*  786 */ /*TargetOpcode::G_FMAXNUM*//*Label 61*/ GIMT_Encode4(3371),
     /*  790 */ /*TargetOpcode::G_FMINNUM_IEEE*//*Label 62*/ GIMT_Encode4(3383),
     /*  794 */ /*TargetOpcode::G_FMAXNUM_IEEE*//*Label 63*/ GIMT_Encode4(3395),
     /*  798 */ /*TargetOpcode::G_FMINIMUM*//*Label 64*/ GIMT_Encode4(3407),
     /*  802 */ /*TargetOpcode::G_FMAXIMUM*//*Label 65*/ GIMT_Encode4(3419), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  842 */ /*TargetOpcode::G_PTR_ADD*//*Label 66*/ GIMT_Encode4(3431), GIMT_Encode4(0),
     /*  850 */ /*TargetOpcode::G_SMIN*//*Label 67*/ GIMT_Encode4(3477),
     /*  854 */ /*TargetOpcode::G_SMAX*//*Label 68*/ GIMT_Encode4(3500),
     /*  858 */ /*TargetOpcode::G_UMIN*//*Label 69*/ GIMT_Encode4(3523),
     /*  862 */ /*TargetOpcode::G_UMAX*//*Label 70*/ GIMT_Encode4(3546),
     /*  866 */ /*TargetOpcode::G_ABS*//*Label 71*/ GIMT_Encode4(3569), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  898 */ /*TargetOpcode::G_INSERT_VECTOR_ELT*//*Label 72*/ GIMT_Encode4(3581),
     /*  902 */ /*TargetOpcode::G_EXTRACT_VECTOR_ELT*//*Label 73*/ GIMT_Encode4(3593),
     /*  906 */ /*TargetOpcode::G_SHUFFLE_VECTOR*//*Label 74*/ GIMT_Encode4(3627),
     /*  910 */ // Label 0: @910
     /*  910 */ GIM_Try, /*On fail goto*//*Label 76*/ GIMT_Encode4(921), // Rule ID 0 //
     /*  915 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule0Enabled),
     /*  918 */   // MIs[0] d
     /*  918 */   // No operand predicates
     /*  918 */   // MIs[0] s
     /*  918 */   // No operand predicates
     /*  918 */   // Combiner Rule #0: copy_prop
     /*  918 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner0),
     /*  921 */ // Label 76: @921
     /*  921 */ GIM_Reject,
     /*  922 */ // Label 1: @922
     /*  922 */ GIM_Try, /*On fail goto*//*Label 77*/ GIMT_Encode4(933), // Rule ID 60 //
     /*  927 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule48Enabled),
     /*  930 */   // Combiner Rule #48: constant_fold_binop; wip_match_opcode 'G_ADD'
     /*  930 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /*  933 */ // Label 77: @933
     /*  933 */ GIM_Try, /*On fail goto*//*Label 78*/ GIMT_Encode4(944), // Rule ID 141 //
     /*  938 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule79Enabled),
     /*  941 */   // Combiner Rule #79: propagate_undef_any_op; wip_match_opcode 'G_ADD'
     /*  941 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner59),
     /*  944 */ // Label 78: @944
     /*  944 */ GIM_Try, /*On fail goto*//*Label 79*/ GIMT_Encode4(955), // Rule ID 153 //
     /*  949 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule87Enabled),
     /*  952 */   // Combiner Rule #87: commute_int_constant_to_rhs; wip_match_opcode 'G_ADD'
     /*  952 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner67),
     /*  955 */ // Label 79: @955
     /*  955 */ GIM_Try, /*On fail goto*//*Label 80*/ GIMT_Encode4(989), // Rule ID 110 //
     /*  960 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule61Enabled),
     /*  963 */   // MIs[0] dst
     /*  963 */   // No operand predicates
     /*  963 */   // MIs[0] __add_sub_reg_match_0.tmp
     /*  963 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  967 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  971 */   // MIs[1] src
     /*  971 */   // No operand predicates
     /*  971 */   // MIs[1] __add_sub_reg_match_0.x
     /*  971 */   // No operand predicates
     /*  971 */   // MIs[0] __add_sub_reg_match_0.x
     /*  971 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  976 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /*  981 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  983 */   // Combiner Rule #61: add_sub_reg @ [__add_sub_reg_match_0[1]]
     /*  983 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /*  988 */   GIR_EraseRootFromParent_Done,
     /*  989 */ // Label 80: @989
     /*  989 */ GIM_Try, /*On fail goto*//*Label 81*/ GIMT_Encode4(1023), // Rule ID 109 //
     /*  994 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule61Enabled),
     /*  997 */   // MIs[0] dst
     /*  997 */   // No operand predicates
     /*  997 */   // MIs[0] __add_sub_reg_match_0.x
     /*  997 */   // No operand predicates
     /*  997 */   // MIs[0] __add_sub_reg_match_0.tmp
     /*  997 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1001 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1005 */   // MIs[1] src
     /* 1005 */   // No operand predicates
     /* 1005 */   // MIs[1] __add_sub_reg_match_0.x
     /* 1005 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/1, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 1010 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1015 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1017 */   // Combiner Rule #61: add_sub_reg @ [__add_sub_reg_match_0[0]]
     /* 1017 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1022 */   GIR_EraseRootFromParent_Done,
     /* 1023 */ // Label 81: @1023
     /* 1023 */ GIM_Try, /*On fail goto*//*Label 82*/ GIMT_Encode4(1046), // Rule ID 84 //
     /* 1028 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule51Enabled),
     /* 1031 */   // MIs[0] dst
     /* 1031 */   // No operand predicates
     /* 1031 */   // MIs[0] lhs
     /* 1031 */   // No operand predicates
     /* 1031 */   // MIs[0] Operand 2
     /* 1031 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 1035 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1040 */   // Combiner Rule #51: right_identity_zero @ [__right_identity_zero_match_0[1]]
     /* 1040 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1045 */   GIR_EraseRootFromParent_Done,
     /* 1046 */ // Label 82: @1046
     /* 1046 */ GIM_Reject,
     /* 1047 */ // Label 2: @1047
     /* 1047 */ GIM_Try, /*On fail goto*//*Label 83*/ GIMT_Encode4(1058), // Rule ID 68 //
     /* 1052 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule48Enabled),
     /* 1055 */   // Combiner Rule #48: constant_fold_binop; wip_match_opcode 'G_SUB'
     /* 1055 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 1058 */ // Label 83: @1058
     /* 1058 */ GIM_Try, /*On fail goto*//*Label 84*/ GIMT_Encode4(1069), // Rule ID 142 //
     /* 1063 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule79Enabled),
     /* 1066 */   // Combiner Rule #79: propagate_undef_any_op; wip_match_opcode 'G_SUB'
     /* 1066 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner59),
     /* 1069 */ // Label 84: @1069
     /* 1069 */ GIM_Try, /*On fail goto*//*Label 85*/ GIMT_Encode4(1092), // Rule ID 83 //
     /* 1074 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule51Enabled),
     /* 1077 */   // MIs[0] dst
     /* 1077 */   // No operand predicates
     /* 1077 */   // MIs[0] lhs
     /* 1077 */   // No operand predicates
     /* 1077 */   // MIs[0] Operand 2
     /* 1077 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 1081 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1086 */   // Combiner Rule #51: right_identity_zero @ [__right_identity_zero_match_0[0]]
     /* 1086 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1091 */   GIR_EraseRootFromParent_Done,
     /* 1092 */ // Label 85: @1092
     /* 1092 */ GIM_Reject,
     /* 1093 */ // Label 3: @1093
     /* 1093 */ GIM_Try, /*On fail goto*//*Label 86*/ GIMT_Encode4(1104), // Rule ID 31 //
     /* 1098 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /* 1101 */   // Combiner Rule #24: mul_const; wip_match_opcode 'G_MUL'
     /* 1101 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner16),
     /* 1104 */ // Label 86: @1104
     /* 1104 */ GIM_Try, /*On fail goto*//*Label 87*/ GIMT_Encode4(1115), // Rule ID 65 //
     /* 1109 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule48Enabled),
     /* 1112 */   // Combiner Rule #48: constant_fold_binop; wip_match_opcode 'G_MUL'
     /* 1112 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 1115 */ // Label 87: @1115
     /* 1115 */ GIM_Try, /*On fail goto*//*Label 88*/ GIMT_Encode4(1126), // Rule ID 125 //
     /* 1120 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule73Enabled),
     /* 1123 */   // Combiner Rule #73: undef_to_int_zero; wip_match_opcode 'G_MUL'
     /* 1123 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner54),
     /* 1126 */ // Label 88: @1126
     /* 1126 */ GIM_Try, /*On fail goto*//*Label 89*/ GIMT_Encode4(1137), // Rule ID 154 //
     /* 1131 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule87Enabled),
     /* 1134 */   // Combiner Rule #87: commute_int_constant_to_rhs; wip_match_opcode 'G_MUL'
     /* 1134 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner67),
     /* 1137 */ // Label 89: @1137
     /* 1137 */ GIM_Try, /*On fail goto*//*Label 90*/ GIMT_Encode4(1148), // Rule ID 185 //
     /* 1142 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule92Enabled),
     /* 1145 */   // Combiner Rule #92: combine_mul_cmlt; wip_match_opcode 'G_MUL'
     /* 1145 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner72),
     /* 1148 */ // Label 90: @1148
     /* 1148 */ GIM_Try, /*On fail goto*//*Label 91*/ GIMT_Encode4(1171), // Rule ID 102 //
     /* 1153 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule54Enabled),
     /* 1156 */   // MIs[0] dst
     /* 1156 */   // No operand predicates
     /* 1156 */   // MIs[0] lhs
     /* 1156 */   // No operand predicates
     /* 1156 */   // MIs[0] zero
     /* 1156 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 1160 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/2,
     /* 1165 */   // Combiner Rule #54: binop_right_to_zero
     /* 1165 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/2,
     /* 1170 */   GIR_EraseRootFromParent_Done,
     /* 1171 */ // Label 91: @1171
     /* 1171 */ GIM_Try, /*On fail goto*//*Label 92*/ GIMT_Encode4(1194), // Rule ID 107 //
     /* 1176 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule59Enabled),
     /* 1179 */   // MIs[0] dst
     /* 1179 */   // No operand predicates
     /* 1179 */   // MIs[0] x
     /* 1179 */   // No operand predicates
     /* 1179 */   // MIs[0] Operand 2
     /* 1179 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
     /* 1183 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1188 */   // Combiner Rule #59: right_identity_one_int
     /* 1188 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1193 */   GIR_EraseRootFromParent_Done,
     /* 1194 */ // Label 92: @1194
     /* 1194 */ GIM_Try, /*On fail goto*//*Label 93*/ GIMT_Encode4(1205), // Rule ID 187 //
     /* 1199 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule94Enabled),
     /* 1202 */   // MIs[0] dst
     /* 1202 */   // No operand predicates
     /* 1202 */   // MIs[0] src1
     /* 1202 */   // No operand predicates
     /* 1202 */   // MIs[0] src2
     /* 1202 */   // No operand predicates
     /* 1202 */   // Combiner Rule #94: extmultomull
     /* 1202 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner74),
     /* 1205 */ // Label 93: @1205
     /* 1205 */ GIM_Reject,
     /* 1206 */ // Label 4: @1206
     /* 1206 */ GIM_Try, /*On fail goto*//*Label 94*/ GIMT_Encode4(1217), // Rule ID 71 //
     /* 1211 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule48Enabled),
     /* 1214 */   // Combiner Rule #48: constant_fold_binop; wip_match_opcode 'G_SDIV'
     /* 1214 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 1217 */ // Label 94: @1217
     /* 1217 */ GIM_Try, /*On fail goto*//*Label 95*/ GIMT_Encode4(1228), // Rule ID 98 //
     /* 1222 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule53Enabled),
     /* 1225 */   // Combiner Rule #53: binop_left_to_zero; wip_match_opcode 'G_SDIV'
     /* 1225 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner42),
     /* 1228 */ // Label 95: @1228
     /* 1228 */ GIM_Reject,
     /* 1229 */ // Label 5: @1229
     /* 1229 */ GIM_Try, /*On fail goto*//*Label 96*/ GIMT_Encode4(1240), // Rule ID 70 //
     /* 1234 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule48Enabled),
     /* 1237 */   // Combiner Rule #48: constant_fold_binop; wip_match_opcode 'G_UDIV'
     /* 1237 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 1240 */ // Label 96: @1240
     /* 1240 */ GIM_Try, /*On fail goto*//*Label 97*/ GIMT_Encode4(1251), // Rule ID 99 //
     /* 1245 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule53Enabled),
     /* 1248 */   // Combiner Rule #53: binop_left_to_zero; wip_match_opcode 'G_UDIV'
     /* 1248 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner42),
     /* 1251 */ // Label 97: @1251
     /* 1251 */ GIM_Try, /*On fail goto*//*Label 98*/ GIMT_Encode4(1262), // Rule ID 128 //
     /* 1256 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule75Enabled),
     /* 1259 */   // Combiner Rule #75: binop_left_undef_to_zero; wip_match_opcode 'G_UDIV'
     /* 1259 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner56),
     /* 1262 */ // Label 98: @1262
     /* 1262 */ GIM_Reject,
     /* 1263 */ // Label 6: @1263
     /* 1263 */ GIM_Try, /*On fail goto*//*Label 99*/ GIMT_Encode4(1274), // Rule ID 73 //
     /* 1268 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule48Enabled),
     /* 1271 */   // Combiner Rule #48: constant_fold_binop; wip_match_opcode 'G_SREM'
     /* 1271 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 1274 */ // Label 99: @1274
     /* 1274 */ GIM_Try, /*On fail goto*//*Label 100*/ GIMT_Encode4(1285), // Rule ID 100 //
     /* 1279 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule53Enabled),
     /* 1282 */   // Combiner Rule #53: binop_left_to_zero; wip_match_opcode 'G_SREM'
     /* 1282 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner42),
     /* 1285 */ // Label 100: @1285
     /* 1285 */ GIM_Reject,
     /* 1286 */ // Label 7: @1286
     /* 1286 */ GIM_Try, /*On fail goto*//*Label 101*/ GIMT_Encode4(1297), // Rule ID 72 //
     /* 1291 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule48Enabled),
     /* 1294 */   // Combiner Rule #48: constant_fold_binop; wip_match_opcode 'G_UREM'
     /* 1294 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 1297 */ // Label 101: @1297
     /* 1297 */ GIM_Try, /*On fail goto*//*Label 102*/ GIMT_Encode4(1308), // Rule ID 101 //
     /* 1302 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule53Enabled),
     /* 1305 */   // Combiner Rule #53: binop_left_to_zero; wip_match_opcode 'G_UREM'
     /* 1305 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner42),
     /* 1308 */ // Label 102: @1308
     /* 1308 */ GIM_Try, /*On fail goto*//*Label 103*/ GIMT_Encode4(1319), // Rule ID 129 //
     /* 1313 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule75Enabled),
     /* 1316 */   // Combiner Rule #75: binop_left_undef_to_zero; wip_match_opcode 'G_UREM'
     /* 1316 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner56),
     /* 1319 */ // Label 103: @1319
     /* 1319 */ GIM_Reject,
     /* 1320 */ // Label 8: @1320
     /* 1320 */ GIM_Try, /*On fail goto*//*Label 104*/ GIMT_Encode4(1331), // Rule ID 18 //
     /* 1325 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule16Enabled),
     /* 1328 */   // Combiner Rule #16: load_and_mask; wip_match_opcode 'G_AND'
     /* 1328 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner8),
     /* 1331 */ // Label 104: @1331
     /* 1331 */ GIM_Try, /*On fail goto*//*Label 105*/ GIMT_Encode4(1342), // Rule ID 24 //
     /* 1336 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule19Enabled),
     /* 1339 */   // Combiner Rule #19: hoist_logic_op_with_same_opcode_hands; wip_match_opcode 'G_AND'
     /* 1339 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner11),
     /* 1342 */ // Label 105: @1342
     /* 1342 */ GIM_Try, /*On fail goto*//*Label 106*/ GIMT_Encode4(1353), // Rule ID 27 //
     /* 1347 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule20Enabled),
     /* 1350 */   // Combiner Rule #20: redundant_and; wip_match_opcode 'G_AND'
     /* 1350 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner12),
     /* 1353 */ // Label 106: @1353
     /* 1353 */ GIM_Try, /*On fail goto*//*Label 107*/ GIMT_Encode4(1364), // Rule ID 62 //
     /* 1358 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule48Enabled),
     /* 1361 */   // Combiner Rule #48: constant_fold_binop; wip_match_opcode 'G_AND'
     /* 1361 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 1364 */ // Label 107: @1364
     /* 1364 */ GIM_Try, /*On fail goto*//*Label 108*/ GIMT_Encode4(1375), // Rule ID 120 //
     /* 1369 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule70Enabled),
     /* 1372 */   // Combiner Rule #70: overlapping_and; wip_match_opcode 'G_AND'
     /* 1372 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner51),
     /* 1375 */ // Label 108: @1375
     /* 1375 */ GIM_Try, /*On fail goto*//*Label 109*/ GIMT_Encode4(1386), // Rule ID 124 //
     /* 1380 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule73Enabled),
     /* 1383 */   // Combiner Rule #73: undef_to_int_zero; wip_match_opcode 'G_AND'
     /* 1383 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner54),
     /* 1386 */ // Label 109: @1386
     /* 1386 */ GIM_Try, /*On fail goto*//*Label 110*/ GIMT_Encode4(1397), // Rule ID 155 //
     /* 1391 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule87Enabled),
     /* 1394 */   // Combiner Rule #87: commute_int_constant_to_rhs; wip_match_opcode 'G_AND'
     /* 1394 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner67),
     /* 1397 */ // Label 110: @1397
     /* 1397 */ GIM_Try, /*On fail goto*//*Label 111*/ GIMT_Encode4(1434), // Rule ID 34 //
     /* 1402 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule27Enabled),
     /* 1405 */   // MIs[0] root
     /* 1405 */   // No operand predicates
     /* 1405 */   // MIs[0] shift
     /* 1405 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1409 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
     /* 1413 */   // MIs[1] x
     /* 1413 */   // No operand predicates
     /* 1413 */   // MIs[1] lsb
     /* 1413 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 1417 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1421 */   // MIs[2] imm1
     /* 1421 */   // No operand predicates
     /* 1421 */   // MIs[0] mask
     /* 1421 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /* 1425 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1429 */   // MIs[3] imm2
     /* 1429 */   // No operand predicates
     /* 1429 */   GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /* 1431 */   // Combiner Rule #27: bitfield_extract_from_and
     /* 1431 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner19),
     /* 1434 */ // Label 111: @1434
     /* 1434 */ GIM_Try, /*On fail goto*//*Label 112*/ GIMT_Encode4(1458), // Rule ID 93 //
     /* 1439 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule52Enabled),
     /* 1442 */   // MIs[0] dst
     /* 1442 */   // No operand predicates
     /* 1442 */   // MIs[0] src
     /* 1442 */   // No operand predicates
     /* 1442 */   // MIs[0] src
     /* 1442 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 1447 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1452 */   // Combiner Rule #52: binop_same_val @ [__binop_same_val_match_0[0]]
     /* 1452 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1457 */   GIR_EraseRootFromParent_Done,
     /* 1458 */ // Label 112: @1458
     /* 1458 */ GIM_Reject,
     /* 1459 */ // Label 9: @1459
     /* 1459 */ GIM_Try, /*On fail goto*//*Label 113*/ GIMT_Encode4(1470), // Rule ID 25 //
     /* 1464 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule19Enabled),
     /* 1467 */   // Combiner Rule #19: hoist_logic_op_with_same_opcode_hands; wip_match_opcode 'G_OR'
     /* 1467 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner11),
     /* 1470 */ // Label 113: @1470
     /* 1470 */ GIM_Try, /*On fail goto*//*Label 114*/ GIMT_Encode4(1481), // Rule ID 30 //
     /* 1475 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule23Enabled),
     /* 1478 */   // Combiner Rule #23: redundant_or; wip_match_opcode 'G_OR'
     /* 1478 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner15),
     /* 1481 */ // Label 114: @1481
     /* 1481 */ GIM_Try, /*On fail goto*//*Label 115*/ GIMT_Encode4(1492), // Rule ID 66 //
     /* 1486 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule48Enabled),
     /* 1489 */   // Combiner Rule #48: constant_fold_binop; wip_match_opcode 'G_OR'
     /* 1489 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 1492 */ // Label 115: @1492
     /* 1492 */ GIM_Try, /*On fail goto*//*Label 116*/ GIMT_Encode4(1503), // Rule ID 126 //
     /* 1497 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule74Enabled),
     /* 1500 */   // Combiner Rule #74: undef_to_negative_one; wip_match_opcode 'G_OR'
     /* 1500 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner55),
     /* 1503 */ // Label 116: @1503
     /* 1503 */ GIM_Try, /*On fail goto*//*Label 117*/ GIMT_Encode4(1514), // Rule ID 156 //
     /* 1508 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule87Enabled),
     /* 1511 */   // Combiner Rule #87: commute_int_constant_to_rhs; wip_match_opcode 'G_OR'
     /* 1511 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner67),
     /* 1514 */ // Label 117: @1514
     /* 1514 */ GIM_Try, /*On fail goto*//*Label 118*/ GIMT_Encode4(1538), // Rule ID 94 //
     /* 1519 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule52Enabled),
     /* 1522 */   // MIs[0] dst
     /* 1522 */   // No operand predicates
     /* 1522 */   // MIs[0] src
     /* 1522 */   // No operand predicates
     /* 1522 */   // MIs[0] src
     /* 1522 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 1527 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1532 */   // Combiner Rule #52: binop_same_val @ [__binop_same_val_match_0[1]]
     /* 1532 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1537 */   GIR_EraseRootFromParent_Done,
     /* 1538 */ // Label 118: @1538
     /* 1538 */ GIM_Try, /*On fail goto*//*Label 119*/ GIMT_Encode4(1561), // Rule ID 85 //
     /* 1543 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule51Enabled),
     /* 1546 */   // MIs[0] dst
     /* 1546 */   // No operand predicates
     /* 1546 */   // MIs[0] lhs
     /* 1546 */   // No operand predicates
     /* 1546 */   // MIs[0] Operand 2
     /* 1546 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 1550 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1555 */   // Combiner Rule #51: right_identity_zero @ [__right_identity_zero_match_0[2]]
     /* 1555 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1560 */   GIR_EraseRootFromParent_Done,
     /* 1561 */ // Label 119: @1561
     /* 1561 */ GIM_Try, /*On fail goto*//*Label 120*/ GIMT_Encode4(1572), // Rule ID 151 //
     /* 1566 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule85Enabled),
     /* 1569 */   // MIs[0] dst
     /* 1569 */   // No operand predicates
     /* 1569 */   // MIs[0] src1
     /* 1569 */   // No operand predicates
     /* 1569 */   // MIs[0] src2
     /* 1569 */   // No operand predicates
     /* 1569 */   // Combiner Rule #85: or_to_bsp
     /* 1569 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner65),
     /* 1572 */ // Label 120: @1572
     /* 1572 */ GIM_Reject,
     /* 1573 */ // Label 10: @1573
     /* 1573 */ GIM_Try, /*On fail goto*//*Label 121*/ GIMT_Encode4(1584), // Rule ID 26 //
     /* 1578 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule19Enabled),
     /* 1581 */   // Combiner Rule #19: hoist_logic_op_with_same_opcode_hands; wip_match_opcode 'G_XOR'
     /* 1581 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner11),
     /* 1584 */ // Label 121: @1584
     /* 1584 */ GIM_Try, /*On fail goto*//*Label 122*/ GIMT_Encode4(1595), // Rule ID 28 //
     /* 1589 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule21Enabled),
     /* 1592 */   // Combiner Rule #21: xor_of_and_with_same_reg; wip_match_opcode 'G_XOR'
     /* 1592 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 1595 */ // Label 122: @1595
     /* 1595 */ GIM_Try, /*On fail goto*//*Label 123*/ GIMT_Encode4(1606), // Rule ID 69 //
     /* 1600 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule48Enabled),
     /* 1603 */   // Combiner Rule #48: constant_fold_binop; wip_match_opcode 'G_XOR'
     /* 1603 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 1606 */ // Label 123: @1606
     /* 1606 */ GIM_Try, /*On fail goto*//*Label 124*/ GIMT_Encode4(1617), // Rule ID 143 //
     /* 1611 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule79Enabled),
     /* 1614 */   // Combiner Rule #79: propagate_undef_any_op; wip_match_opcode 'G_XOR'
     /* 1614 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner59),
     /* 1617 */ // Label 124: @1617
     /* 1617 */ GIM_Try, /*On fail goto*//*Label 125*/ GIMT_Encode4(1628), // Rule ID 157 //
     /* 1622 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule87Enabled),
     /* 1625 */   // Combiner Rule #87: commute_int_constant_to_rhs; wip_match_opcode 'G_XOR'
     /* 1625 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner67),
     /* 1628 */ // Label 125: @1628
     /* 1628 */ GIM_Try, /*On fail goto*//*Label 126*/ GIMT_Encode4(1651), // Rule ID 86 //
     /* 1633 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule51Enabled),
     /* 1636 */   // MIs[0] dst
     /* 1636 */   // No operand predicates
     /* 1636 */   // MIs[0] lhs
     /* 1636 */   // No operand predicates
     /* 1636 */   // MIs[0] Operand 2
     /* 1636 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 1640 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1645 */   // Combiner Rule #51: right_identity_zero @ [__right_identity_zero_match_0[3]]
     /* 1645 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1650 */   GIR_EraseRootFromParent_Done,
     /* 1651 */ // Label 126: @1651
     /* 1651 */ GIM_Reject,
     /* 1652 */ // Label 11: @1652
     /* 1652 */ GIM_Try, /*On fail goto*//*Label 127*/ GIMT_Encode4(1663), // Rule ID 51 //
     /* 1657 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule39Enabled),
     /* 1660 */   // Combiner Rule #39: unmerge_anyext_build_vector; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 1660 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner30),
     /* 1663 */ // Label 127: @1663
     /* 1663 */ GIM_Try, /*On fail goto*//*Label 128*/ GIMT_Encode4(1674), // Rule ID 52 //
     /* 1668 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule40Enabled),
     /* 1671 */   // Combiner Rule #40: unmerge_merge; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 1671 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner31),
     /* 1674 */ // Label 128: @1674
     /* 1674 */ GIM_Try, /*On fail goto*//*Label 129*/ GIMT_Encode4(1685), // Rule ID 54 //
     /* 1679 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule42Enabled),
     /* 1682 */   // Combiner Rule #42: unmerge_cst; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 1682 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner33),
     /* 1685 */ // Label 129: @1685
     /* 1685 */ GIM_Try, /*On fail goto*//*Label 130*/ GIMT_Encode4(1696), // Rule ID 55 //
     /* 1690 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule43Enabled),
     /* 1693 */   // Combiner Rule #43: unmerge_undef; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 1693 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner34),
     /* 1696 */ // Label 130: @1696
     /* 1696 */ GIM_Try, /*On fail goto*//*Label 131*/ GIMT_Encode4(1707), // Rule ID 56 //
     /* 1701 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule44Enabled),
     /* 1704 */   // Combiner Rule #44: unmerge_dead_to_trunc; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 1704 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner35),
     /* 1707 */ // Label 131: @1707
     /* 1707 */ GIM_Try, /*On fail goto*//*Label 132*/ GIMT_Encode4(1718), // Rule ID 57 //
     /* 1712 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule45Enabled),
     /* 1715 */   // Combiner Rule #45: unmerge_zext_to_zext; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 1715 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner36),
     /* 1718 */ // Label 132: @1718
     /* 1718 */ GIM_Reject,
     /* 1719 */ // Label 12: @1719
     /* 1719 */ GIM_Try, /*On fail goto*//*Label 133*/ GIMT_Encode4(1730), // Rule ID 50 //
     /* 1724 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule38Enabled),
     /* 1727 */   // Combiner Rule #38: fold_merge_to_zext; wip_match_opcode 'G_MERGE_VALUES'
     /* 1727 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner29),
     /* 1730 */ // Label 133: @1730
     /* 1730 */ GIM_Try, /*On fail goto*//*Label 134*/ GIMT_Encode4(1741), // Rule ID 53 //
     /* 1735 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule41Enabled),
     /* 1738 */   // Combiner Rule #41: merge_unmerge; wip_match_opcode 'G_MERGE_VALUES'
     /* 1738 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner32),
     /* 1741 */ // Label 134: @1741
     /* 1741 */ GIM_Try, /*On fail goto*//*Label 135*/ GIMT_Encode4(1803),
     /* 1746 */   GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
     /* 1749 */   GIM_Try, /*On fail goto*//*Label 136*/ GIMT_Encode4(1770), // Rule ID 58 //
     /* 1754 */     GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule46Enabled),
     /* 1757 */     // MIs[0] root
     /* 1757 */     // No operand predicates
     /* 1757 */     // MIs[0] x
     /* 1757 */     // No operand predicates
     /* 1757 */     // MIs[0] undef
     /* 1757 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1761 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 1765 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1767 */     // Combiner Rule #46: merge_of_x_and_undef
     /* 1767 */     GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner37),
     /* 1770 */   // Label 136: @1770
     /* 1770 */   GIM_Try, /*On fail goto*//*Label 137*/ GIMT_Encode4(1802), // Rule ID 59 //
     /* 1775 */     GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule47Enabled),
     /* 1778 */     // MIs[0] root
     /* 1778 */     // No operand predicates
     /* 1778 */     // MIs[0] x
     /* 1778 */     // No operand predicates
     /* 1778 */     // MIs[0] zero
     /* 1778 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1782 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1786 */     // MIs[1] Operand 1
     /* 1786 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/1, GIMT_Encode8(0),
     /* 1797 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1799 */     // Combiner Rule #47: merge_of_x_and_zero
     /* 1799 */     GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 1802 */   // Label 137: @1802
     /* 1802 */   GIM_Reject,
     /* 1803 */ // Label 135: @1803
     /* 1803 */ GIM_Reject,
     /* 1804 */ // Label 13: @1804
     /* 1804 */ GIM_Try, /*On fail goto*//*Label 138*/ GIMT_Encode4(1815), // Rule ID 112 //
     /* 1809 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule62Enabled),
     /* 1812 */   // Combiner Rule #62: buildvector_identity_fold; wip_match_opcode 'G_BUILD_VECTOR'
     /* 1812 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner46),
     /* 1815 */ // Label 138: @1815
     /* 1815 */ GIM_Try, /*On fail goto*//*Label 139*/ GIMT_Encode4(1826), // Rule ID 145 //
     /* 1820 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule80Enabled),
     /* 1823 */   // Combiner Rule #80: propagate_undef_all_ops; wip_match_opcode 'G_BUILD_VECTOR'
     /* 1823 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner60),
     /* 1826 */ // Label 139: @1826
     /* 1826 */ GIM_Try, /*On fail goto*//*Label 140*/ GIMT_Encode4(1837), // Rule ID 183 //
     /* 1831 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule90Enabled),
     /* 1834 */   // Combiner Rule #90: extract_all_elts_from_build_vector; wip_match_opcode 'G_BUILD_VECTOR'
     /* 1834 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner70),
     /* 1837 */ // Label 140: @1837
     /* 1837 */ GIM_Try, /*On fail goto*//*Label 141*/ GIMT_Encode4(1851), // Rule ID 186 //
     /* 1842 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule93Enabled),
     /* 1845 */   GIM_CheckNumOperandsGE, /*MI*/0, /*Expected*/2,
     /* 1848 */   // MIs[0] dst
     /* 1848 */   // No operand predicates
     /* 1848 */   // MIs[0] unused
     /* 1848 */   // No operand predicates
     /* 1848 */   // Combiner Rule #93: combine_use_vector_truncate
     /* 1848 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner73),
     /* 1851 */ // Label 141: @1851
     /* 1851 */ GIM_Reject,
     /* 1852 */ // Label 14: @1852
     /* 1852 */ GIM_Try, /*On fail goto*//*Label 142*/ GIMT_Encode4(1863), // Rule ID 111 //
     /* 1857 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule62Enabled),
     /* 1860 */   // Combiner Rule #62: buildvector_identity_fold; wip_match_opcode 'G_BUILD_VECTOR_TRUNC'
     /* 1860 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner46),
     /* 1863 */ // Label 142: @1863
     /* 1863 */ GIM_Reject,
     /* 1864 */ // Label 15: @1864
     /* 1864 */ GIM_Try, /*On fail goto*//*Label 143*/ GIMT_Encode4(1875), // Rule ID 152 //
     /* 1869 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 1872 */   // Combiner Rule #86: combine_concat_vector; wip_match_opcode 'G_CONCAT_VECTORS'
     /* 1872 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner66),
     /* 1875 */ // Label 143: @1875
     /* 1875 */ GIM_Reject,
     /* 1876 */ // Label 16: @1876
     /* 1876 */ GIM_Try, /*On fail goto*//*Label 144*/ GIMT_Encode4(1897), // Rule ID 104 //
     /* 1881 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule56Enabled),
     /* 1884 */   // MIs[0] dst
     /* 1884 */   // No operand predicates
     /* 1884 */   // MIs[0] t
     /* 1884 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1888 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTTOPTR),
     /* 1892 */   // MIs[1] ptr
     /* 1892 */   // No operand predicates
     /* 1892 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1894 */   // Combiner Rule #56: i2p_to_p2i
     /* 1894 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner44),
     /* 1897 */ // Label 144: @1897
     /* 1897 */ GIM_Try, /*On fail goto*//*Label 145*/ GIMT_Encode4(1918), // Rule ID 137 //
     /* 1902 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule78Enabled),
     /* 1905 */   // MIs[0] dst
     /* 1905 */   // No operand predicates
     /* 1905 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 1905 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1909 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 1913 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1915 */   // Combiner Rule #78: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[3]]
     /* 1915 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner58),
     /* 1918 */ // Label 145: @1918
     /* 1918 */ GIM_Reject,
     /* 1919 */ // Label 17: @1919
     /* 1919 */ GIM_Try, /*On fail goto*//*Label 146*/ GIMT_Encode4(1930), // Rule ID 103 //
     /* 1924 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule55Enabled),
     /* 1927 */   // Combiner Rule #55: p2i_to_i2p; wip_match_opcode 'G_INTTOPTR'
     /* 1927 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner43),
     /* 1930 */ // Label 146: @1930
     /* 1930 */ GIM_Try, /*On fail goto*//*Label 147*/ GIMT_Encode4(1951), // Rule ID 138 //
     /* 1935 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule78Enabled),
     /* 1938 */   // MIs[0] dst
     /* 1938 */   // No operand predicates
     /* 1938 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 1938 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1942 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 1946 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1948 */   // Combiner Rule #78: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[4]]
     /* 1948 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner58),
     /* 1951 */ // Label 147: @1951
     /* 1951 */ GIM_Reject,
     /* 1952 */ // Label 18: @1952
     /* 1952 */ GIM_Try, /*On fail goto*//*Label 148*/ GIMT_Encode4(1973), // Rule ID 115 //
     /* 1957 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule65Enabled),
     /* 1960 */   // MIs[0] dst
     /* 1960 */   // No operand predicates
     /* 1960 */   // MIs[0] src1
     /* 1960 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1964 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BITCAST),
     /* 1968 */   // MIs[1] src0
     /* 1968 */   // No operand predicates
     /* 1968 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1970 */   // Combiner Rule #65: bitcast_bitcast_fold
     /* 1970 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner49),
     /* 1973 */ // Label 148: @1973
     /* 1973 */ GIM_Try, /*On fail goto*//*Label 149*/ GIMT_Encode4(1994), // Rule ID 135 //
     /* 1978 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule78Enabled),
     /* 1981 */   // MIs[0] dst
     /* 1981 */   // No operand predicates
     /* 1981 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 1981 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1985 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 1989 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1991 */   // Combiner Rule #78: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[1]]
     /* 1991 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner58),
     /* 1994 */ // Label 149: @1994
     /* 1994 */ GIM_Reject,
     /* 1995 */ // Label 19: @1995
     /* 1995 */ GIM_Try, /*On fail goto*//*Label 150*/ GIMT_Encode4(2006), // Rule ID 184 //
     /* 2000 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule91Enabled),
     /* 2003 */   // MIs[0] dst
     /* 2003 */   // No operand predicates
     /* 2003 */   // MIs[0] src
     /* 2003 */   // No operand predicates
     /* 2003 */   // Combiner Rule #91: push_freeze_to_prevent_poison_from_propagating
     /* 2003 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner71),
     /* 2006 */ // Label 150: @2006
     /* 2006 */ GIM_Reject,
     /* 2007 */ // Label 20: @2007
     /* 2007 */ GIM_Try, /*On fail goto*//*Label 151*/ GIMT_Encode4(2018), // Rule ID 15 //
     /* 2012 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule15Enabled),
     /* 2015 */   // Combiner Rule #15: extending_loads; wip_match_opcode 'G_LOAD'
     /* 2015 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner7),
     /* 2018 */ // Label 151: @2018
     /* 2018 */ GIM_Try, /*On fail goto*//*Label 152*/ GIMT_Encode4(2029), // Rule ID 19 //
     /* 2023 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule17Enabled),
     /* 2026 */   // Combiner Rule #17: combine_indexed_load_store; wip_match_opcode 'G_LOAD'
     /* 2026 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner9),
     /* 2029 */ // Label 152: @2029
     /* 2029 */ GIM_Reject,
     /* 2030 */ // Label 21: @2030
     /* 2030 */ GIM_Try, /*On fail goto*//*Label 153*/ GIMT_Encode4(2041), // Rule ID 16 //
     /* 2035 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule15Enabled),
     /* 2038 */   // Combiner Rule #15: extending_loads; wip_match_opcode 'G_SEXTLOAD'
     /* 2038 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner7),
     /* 2041 */ // Label 153: @2041
     /* 2041 */ GIM_Try, /*On fail goto*//*Label 154*/ GIMT_Encode4(2052), // Rule ID 20 //
     /* 2046 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule17Enabled),
     /* 2049 */   // Combiner Rule #17: combine_indexed_load_store; wip_match_opcode 'G_SEXTLOAD'
     /* 2049 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner9),
     /* 2052 */ // Label 154: @2052
     /* 2052 */ GIM_Reject,
     /* 2053 */ // Label 22: @2053
     /* 2053 */ GIM_Try, /*On fail goto*//*Label 155*/ GIMT_Encode4(2064), // Rule ID 17 //
     /* 2058 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule15Enabled),
     /* 2061 */   // Combiner Rule #15: extending_loads; wip_match_opcode 'G_ZEXTLOAD'
     /* 2061 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner7),
     /* 2064 */ // Label 155: @2064
     /* 2064 */ GIM_Try, /*On fail goto*//*Label 156*/ GIMT_Encode4(2075), // Rule ID 21 //
     /* 2069 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule17Enabled),
     /* 2072 */   // Combiner Rule #17: combine_indexed_load_store; wip_match_opcode 'G_ZEXTLOAD'
     /* 2072 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner9),
     /* 2075 */ // Label 156: @2075
     /* 2075 */ GIM_Reject,
     /* 2076 */ // Label 23: @2076
     /* 2076 */ GIM_Try, /*On fail goto*//*Label 157*/ GIMT_Encode4(2087), // Rule ID 22 //
     /* 2081 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule17Enabled),
     /* 2084 */   // Combiner Rule #17: combine_indexed_load_store; wip_match_opcode 'G_STORE'
     /* 2084 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner9),
     /* 2087 */ // Label 157: @2087
     /* 2087 */ GIM_Try, /*On fail goto*//*Label 158*/ GIMT_Encode4(2098), // Rule ID 147 //
     /* 2092 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule82Enabled),
     /* 2095 */   // Combiner Rule #82: erase_undef_store; wip_match_opcode 'G_STORE'
     /* 2095 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner62),
     /* 2098 */ // Label 158: @2098
     /* 2098 */ GIM_Try, /*On fail goto*//*Label 159*/ GIMT_Encode4(2109), // Rule ID 121 //
     /* 2103 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule71Enabled),
     /* 2106 */   // MIs[0] src
     /* 2106 */   // No operand predicates
     /* 2106 */   // MIs[0] addr
     /* 2106 */   // No operand predicates
     /* 2106 */   // Combiner Rule #71: split_store_zero_128
     /* 2106 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner52),
     /* 2109 */ // Label 159: @2109
     /* 2109 */ GIM_Reject,
     /* 2110 */ // Label 24: @2110
     /* 2110 */ GIM_Try, /*On fail goto*//*Label 160*/ GIMT_Encode4(2121), // Rule ID 14 //
     /* 2115 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule14Enabled),
     /* 2118 */   // Combiner Rule #14: mutate_anyext_to_zext; wip_match_opcode 'G_ANYEXT'
     /* 2118 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner6),
     /* 2121 */ // Label 160: @2121
     /* 2121 */ GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(2132), // Rule ID 105 //
     /* 2126 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule57Enabled),
     /* 2129 */   // Combiner Rule #57: anyext_trunc_fold; wip_match_opcode 'G_ANYEXT'
     /* 2129 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 2132 */ // Label 161: @2132
     /* 2132 */ GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(2153), // Rule ID 8 //
     /* 2137 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule8Enabled),
     /* 2140 */   // MIs[0] root
     /* 2140 */   // No operand predicates
     /* 2140 */   // MIs[0] second
     /* 2140 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2144 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /* 2148 */   // MIs[1] src
     /* 2148 */   // No operand predicates
     /* 2148 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2150 */   // Combiner Rule #8: anyext_of_anyext
     /* 2150 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner2),
     /* 2153 */ // Label 162: @2153
     /* 2153 */ GIM_Try, /*On fail goto*//*Label 163*/ GIMT_Encode4(2174), // Rule ID 10 //
     /* 2158 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule10Enabled),
     /* 2161 */   // MIs[0] root
     /* 2161 */   // No operand predicates
     /* 2161 */   // MIs[0] second
     /* 2161 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2165 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /* 2169 */   // MIs[1] src
     /* 2169 */   // No operand predicates
     /* 2169 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2171 */   // Combiner Rule #10: anyext_of_sext
     /* 2171 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner2),
     /* 2174 */ // Label 163: @2174
     /* 2174 */ GIM_Try, /*On fail goto*//*Label 164*/ GIMT_Encode4(2195), // Rule ID 9 //
     /* 2179 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule9Enabled),
     /* 2182 */   // MIs[0] root
     /* 2182 */   // No operand predicates
     /* 2182 */   // MIs[0] second
     /* 2182 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2186 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /* 2190 */   // MIs[1] src
     /* 2190 */   // No operand predicates
     /* 2190 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2192 */   // Combiner Rule #9: anyext_of_zext
     /* 2192 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner2),
     /* 2195 */ // Label 164: @2195
     /* 2195 */ GIM_Try, /*On fail goto*//*Label 165*/ GIMT_Encode4(2216), // Rule ID 136 //
     /* 2200 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule78Enabled),
     /* 2203 */   // MIs[0] dst
     /* 2203 */   // No operand predicates
     /* 2203 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 2203 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2207 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 2211 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2213 */   // Combiner Rule #78: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[2]]
     /* 2213 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner58),
     /* 2216 */ // Label 165: @2216
     /* 2216 */ GIM_Reject,
     /* 2217 */ // Label 25: @2217
     /* 2217 */ GIM_Try, /*On fail goto*//*Label 166*/ GIMT_Encode4(2228), // Rule ID 113 //
     /* 2222 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule63Enabled),
     /* 2225 */   // Combiner Rule #63: trunc_buildvector_fold; wip_match_opcode 'G_TRUNC'
     /* 2225 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner47),
     /* 2228 */ // Label 166: @2228
     /* 2228 */ GIM_Try, /*On fail goto*//*Label 167*/ GIMT_Encode4(2239), // Rule ID 114 //
     /* 2233 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule64Enabled),
     /* 2236 */   // Combiner Rule #64: trunc_lshr_buildvector_fold; wip_match_opcode 'G_TRUNC'
     /* 2236 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner48),
     /* 2239 */ // Label 167: @2239
     /* 2239 */ GIM_Try, /*On fail goto*//*Label 168*/ GIMT_Encode4(2260), // Rule ID 3 //
     /* 2244 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule3Enabled),
     /* 2247 */   // MIs[0] root
     /* 2247 */   // No operand predicates
     /* 2247 */   // MIs[0] ext
     /* 2247 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2251 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /* 2255 */   // MIs[1] src
     /* 2255 */   // No operand predicates
     /* 2255 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2257 */   // Combiner Rule #3: truncate_of_anyext
     /* 2257 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner1),
     /* 2260 */ // Label 168: @2260
     /* 2260 */ GIM_Try, /*On fail goto*//*Label 169*/ GIMT_Encode4(2284), // Rule ID 12 //
     /* 2265 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule12Enabled),
     /* 2268 */   // MIs[0] root
     /* 2268 */   // No operand predicates
     /* 2268 */   // MIs[0] bv
     /* 2268 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2272 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR),
     /* 2276 */   GIM_CheckNumOperandsGE, /*MI*/1, /*Expected*/2,
     /* 2279 */   // MIs[1] unused
     /* 2279 */   // No operand predicates
     /* 2279 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2281 */   // Combiner Rule #12: buildvector_of_truncate
     /* 2281 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner4),
     /* 2284 */ // Label 169: @2284
     /* 2284 */ GIM_Try, /*On fail goto*//*Label 170*/ GIMT_Encode4(2305), // Rule ID 2 //
     /* 2289 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule2Enabled),
     /* 2292 */   // MIs[0] root
     /* 2292 */   // No operand predicates
     /* 2292 */   // MIs[0] ext
     /* 2292 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2296 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /* 2300 */   // MIs[1] src
     /* 2300 */   // No operand predicates
     /* 2300 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2302 */   // Combiner Rule #2: truncate_of_sext
     /* 2302 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner1),
     /* 2305 */ // Label 170: @2305
     /* 2305 */ GIM_Try, /*On fail goto*//*Label 171*/ GIMT_Encode4(2326), // Rule ID 1 //
     /* 2310 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule1Enabled),
     /* 2313 */   // MIs[0] root
     /* 2313 */   // No operand predicates
     /* 2313 */   // MIs[0] ext
     /* 2313 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2317 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /* 2321 */   // MIs[1] src
     /* 2321 */   // No operand predicates
     /* 2321 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2323 */   // Combiner Rule #1: truncate_of_zext
     /* 2323 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner1),
     /* 2326 */ // Label 171: @2326
     /* 2326 */ GIM_Try, /*On fail goto*//*Label 172*/ GIMT_Encode4(2347), // Rule ID 134 //
     /* 2331 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule78Enabled),
     /* 2334 */   // MIs[0] dst
     /* 2334 */   // No operand predicates
     /* 2334 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 2334 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2338 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 2342 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2344 */   // Combiner Rule #78: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[0]]
     /* 2344 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner58),
     /* 2347 */ // Label 172: @2347
     /* 2347 */ GIM_Try, /*On fail goto*//*Label 173*/ GIMT_Encode4(2368), // Rule ID 13 //
     /* 2352 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule13Enabled),
     /* 2355 */   // MIs[0] root
     /* 2355 */   // No operand predicates
     /* 2355 */   // MIs[0] int
     /* 2355 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2359 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 2363 */   // MIs[1] imm
     /* 2363 */   // No operand predicates
     /* 2363 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2365 */   // Combiner Rule #13: integer_of_truncate
     /* 2365 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner5),
     /* 2368 */ // Label 173: @2368
     /* 2368 */ GIM_Reject,
     /* 2369 */ // Label 26: @2369
     /* 2369 */ GIM_Try, /*On fail goto*//*Label 174*/ GIMT_Encode4(2390), // Rule ID 7 //
     /* 2374 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule7Enabled),
     /* 2377 */   // MIs[0] root
     /* 2377 */   // No operand predicates
     /* 2377 */   // MIs[0] second
     /* 2377 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2381 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /* 2385 */   // MIs[1] src
     /* 2385 */   // No operand predicates
     /* 2385 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2387 */   // Combiner Rule #7: sext_of_anyext
     /* 2387 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner2),
     /* 2390 */ // Label 174: @2390
     /* 2390 */ GIM_Try, /*On fail goto*//*Label 175*/ GIMT_Encode4(2411), // Rule ID 6 //
     /* 2395 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule6Enabled),
     /* 2398 */   // MIs[0] root
     /* 2398 */   // No operand predicates
     /* 2398 */   // MIs[0] second
     /* 2398 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2402 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /* 2406 */   // MIs[1] src
     /* 2406 */   // No operand predicates
     /* 2406 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2408 */   // Combiner Rule #6: sext_of_sext
     /* 2408 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner2),
     /* 2411 */ // Label 175: @2411
     /* 2411 */ GIM_Reject,
     /* 2412 */ // Label 27: @2412
     /* 2412 */ GIM_Try, /*On fail goto*//*Label 176*/ GIMT_Encode4(2423), // Rule ID 23 //
     /* 2417 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule18Enabled),
     /* 2420 */   // Combiner Rule #18: sext_trunc_sextload; wip_match_opcode 'G_SEXT_INREG'
     /* 2420 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner10),
     /* 2423 */ // Label 176: @2423
     /* 2423 */ GIM_Try, /*On fail goto*//*Label 177*/ GIMT_Encode4(2434), // Rule ID 32 //
     /* 2428 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule25Enabled),
     /* 2431 */   // Combiner Rule #25: redundant_sext_inreg; wip_match_opcode 'G_SEXT_INREG'
     /* 2431 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner17),
     /* 2434 */ // Label 177: @2434
     /* 2434 */ GIM_Try, /*On fail goto*//*Label 178*/ GIMT_Encode4(2445), // Rule ID 33 //
     /* 2439 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule26Enabled),
     /* 2442 */   // Combiner Rule #26: bitfield_extract_from_sext_inreg; wip_match_opcode 'G_SEXT_INREG'
     /* 2442 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner18),
     /* 2445 */ // Label 178: @2445
     /* 2445 */ GIM_Try, /*On fail goto*//*Label 179*/ GIMT_Encode4(2466), // Rule ID 11 //
     /* 2450 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule11Enabled),
     /* 2453 */   // MIs[0] dst
     /* 2453 */   // No operand predicates
     /* 2453 */   // MIs[0] x
     /* 2453 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2457 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /* 2461 */   // MIs[1] src
     /* 2461 */   // No operand predicates
     /* 2461 */   // MIs[1] a
     /* 2461 */   // No operand predicates
     /* 2461 */   // MIs[0] b
     /* 2461 */   // No operand predicates
     /* 2461 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2463 */   // Combiner Rule #11: sext_inreg_of_sext_inreg
     /* 2463 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner3),
     /* 2466 */ // Label 179: @2466
     /* 2466 */ GIM_Reject,
     /* 2467 */ // Label 28: @2467
     /* 2467 */ GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(2488), // Rule ID 5 //
     /* 2472 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule5Enabled),
     /* 2475 */   // MIs[0] root
     /* 2475 */   // No operand predicates
     /* 2475 */   // MIs[0] second
     /* 2475 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2479 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /* 2483 */   // MIs[1] src
     /* 2483 */   // No operand predicates
     /* 2483 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2485 */   // Combiner Rule #5: zext_of_anyext
     /* 2485 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner2),
     /* 2488 */ // Label 180: @2488
     /* 2488 */ GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(2509), // Rule ID 4 //
     /* 2493 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule4Enabled),
     /* 2496 */   // MIs[0] root
     /* 2496 */   // No operand predicates
     /* 2496 */   // MIs[0] second
     /* 2496 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2500 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /* 2504 */   // MIs[1] src
     /* 2504 */   // No operand predicates
     /* 2504 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2506 */   // Combiner Rule #4: zext_of_zext
     /* 2506 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner2),
     /* 2509 */ // Label 181: @2509
     /* 2509 */ GIM_Reject,
     /* 2510 */ // Label 29: @2510
     /* 2510 */ GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(2521), // Rule ID 67 //
     /* 2515 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule48Enabled),
     /* 2518 */   // Combiner Rule #48: constant_fold_binop; wip_match_opcode 'G_SHL'
     /* 2518 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 2521 */ // Label 182: @2521
     /* 2521 */ GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(2532), // Rule ID 95 //
     /* 2526 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule53Enabled),
     /* 2529 */   // Combiner Rule #53: binop_left_to_zero; wip_match_opcode 'G_SHL'
     /* 2529 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner42),
     /* 2532 */ // Label 183: @2532
     /* 2532 */ GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(2543), // Rule ID 127 //
     /* 2537 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule75Enabled),
     /* 2540 */   // Combiner Rule #75: binop_left_undef_to_zero; wip_match_opcode 'G_SHL'
     /* 2540 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner56),
     /* 2543 */ // Label 184: @2543
     /* 2543 */ GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(2554), // Rule ID 130 //
     /* 2548 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule76Enabled),
     /* 2551 */   // Combiner Rule #76: binop_right_undef_to_undef; wip_match_opcode 'G_SHL'
     /* 2551 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner57),
     /* 2554 */ // Label 185: @2554
     /* 2554 */ GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(2577), // Rule ID 87 //
     /* 2559 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule51Enabled),
     /* 2562 */   // MIs[0] dst
     /* 2562 */   // No operand predicates
     /* 2562 */   // MIs[0] lhs
     /* 2562 */   // No operand predicates
     /* 2562 */   // MIs[0] Operand 2
     /* 2562 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 2566 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2571 */   // Combiner Rule #51: right_identity_zero @ [__right_identity_zero_match_0[4]]
     /* 2571 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2576 */   GIR_EraseRootFromParent_Done,
     /* 2577 */ // Label 186: @2577
     /* 2577 */ GIM_Reject,
     /* 2578 */ // Label 30: @2578
     /* 2578 */ GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(2589), // Rule ID 36 //
     /* 2583 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule28Enabled),
     /* 2586 */   // Combiner Rule #28: bitfield_extract_from_shr; wip_match_opcode 'G_LSHR'
     /* 2586 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner20),
     /* 2589 */ // Label 187: @2589
     /* 2589 */ GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(2600), // Rule ID 38 //
     /* 2594 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule29Enabled),
     /* 2597 */   // Combiner Rule #29: bitfield_extract_from_shr_and; wip_match_opcode 'G_LSHR'
     /* 2597 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 2600 */ // Label 188: @2600
     /* 2600 */ GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(2611), // Rule ID 64 //
     /* 2605 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule48Enabled),
     /* 2608 */   // Combiner Rule #48: constant_fold_binop; wip_match_opcode 'G_LSHR'
     /* 2608 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 2611 */ // Label 189: @2611
     /* 2611 */ GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(2622), // Rule ID 96 //
     /* 2616 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule53Enabled),
     /* 2619 */   // Combiner Rule #53: binop_left_to_zero; wip_match_opcode 'G_LSHR'
     /* 2619 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner42),
     /* 2622 */ // Label 190: @2622
     /* 2622 */ GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(2633), // Rule ID 132 //
     /* 2627 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule76Enabled),
     /* 2630 */   // Combiner Rule #76: binop_right_undef_to_undef; wip_match_opcode 'G_LSHR'
     /* 2630 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner57),
     /* 2633 */ // Label 191: @2633
     /* 2633 */ GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(2656), // Rule ID 89 //
     /* 2638 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule51Enabled),
     /* 2641 */   // MIs[0] dst
     /* 2641 */   // No operand predicates
     /* 2641 */   // MIs[0] lhs
     /* 2641 */   // No operand predicates
     /* 2641 */   // MIs[0] Operand 2
     /* 2641 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 2645 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2650 */   // Combiner Rule #51: right_identity_zero @ [__right_identity_zero_match_0[6]]
     /* 2650 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2655 */   GIR_EraseRootFromParent_Done,
     /* 2656 */ // Label 192: @2656
     /* 2656 */ GIM_Reject,
     /* 2657 */ // Label 31: @2657
     /* 2657 */ GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(2668), // Rule ID 35 //
     /* 2662 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule28Enabled),
     /* 2665 */   // Combiner Rule #28: bitfield_extract_from_shr; wip_match_opcode 'G_ASHR'
     /* 2665 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner20),
     /* 2668 */ // Label 193: @2668
     /* 2668 */ GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(2679), // Rule ID 37 //
     /* 2673 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule29Enabled),
     /* 2676 */   // Combiner Rule #29: bitfield_extract_from_shr_and; wip_match_opcode 'G_ASHR'
     /* 2676 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 2679 */ // Label 194: @2679
     /* 2679 */ GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(2690), // Rule ID 63 //
     /* 2684 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule48Enabled),
     /* 2687 */   // Combiner Rule #48: constant_fold_binop; wip_match_opcode 'G_ASHR'
     /* 2687 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 2690 */ // Label 195: @2690
     /* 2690 */ GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(2701), // Rule ID 97 //
     /* 2695 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule53Enabled),
     /* 2698 */   // Combiner Rule #53: binop_left_to_zero; wip_match_opcode 'G_ASHR'
     /* 2698 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner42),
     /* 2701 */ // Label 196: @2701
     /* 2701 */ GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(2712), // Rule ID 131 //
     /* 2706 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule76Enabled),
     /* 2709 */   // Combiner Rule #76: binop_right_undef_to_undef; wip_match_opcode 'G_ASHR'
     /* 2709 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner57),
     /* 2712 */ // Label 197: @2712
     /* 2712 */ GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(2735), // Rule ID 88 //
     /* 2717 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule51Enabled),
     /* 2720 */   // MIs[0] dst
     /* 2720 */   // No operand predicates
     /* 2720 */   // MIs[0] lhs
     /* 2720 */   // No operand predicates
     /* 2720 */   // MIs[0] Operand 2
     /* 2720 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 2724 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2729 */   // Combiner Rule #51: right_identity_zero @ [__right_identity_zero_match_0[5]]
     /* 2729 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2734 */   GIR_EraseRootFromParent_Done,
     /* 2735 */ // Label 198: @2735
     /* 2735 */ GIM_Reject,
     /* 2736 */ // Label 32: @2736
     /* 2736 */ GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(2747), // Rule ID 39 //
     /* 2741 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule30Enabled),
     /* 2744 */   // Combiner Rule #30: rotate_out_of_range; wip_match_opcode 'G_ROTR'
     /* 2744 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner22),
     /* 2747 */ // Label 199: @2747
     /* 2747 */ GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(2770), // Rule ID 92 //
     /* 2752 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule51Enabled),
     /* 2755 */   // MIs[0] dst
     /* 2755 */   // No operand predicates
     /* 2755 */   // MIs[0] lhs
     /* 2755 */   // No operand predicates
     /* 2755 */   // MIs[0] Operand 2
     /* 2755 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 2759 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2764 */   // Combiner Rule #51: right_identity_zero @ [__right_identity_zero_match_0[9]]
     /* 2764 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2769 */   GIR_EraseRootFromParent_Done,
     /* 2770 */ // Label 200: @2770
     /* 2770 */ GIM_Reject,
     /* 2771 */ // Label 33: @2771
     /* 2771 */ GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(2782), // Rule ID 40 //
     /* 2776 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule30Enabled),
     /* 2779 */   // Combiner Rule #30: rotate_out_of_range; wip_match_opcode 'G_ROTL'
     /* 2779 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner22),
     /* 2782 */ // Label 201: @2782
     /* 2782 */ GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(2805), // Rule ID 91 //
     /* 2787 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule51Enabled),
     /* 2790 */   // MIs[0] dst
     /* 2790 */   // No operand predicates
     /* 2790 */   // MIs[0] lhs
     /* 2790 */   // No operand predicates
     /* 2790 */   // MIs[0] Operand 2
     /* 2790 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 2794 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2799 */   // Combiner Rule #51: right_identity_zero @ [__right_identity_zero_match_0[8]]
     /* 2799 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2804 */   GIR_EraseRootFromParent_Done,
     /* 2805 */ // Label 202: @2805
     /* 2805 */ GIM_Reject,
     /* 2806 */ // Label 34: @2806
     /* 2806 */ GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(2817), // Rule ID 41 //
     /* 2811 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule31Enabled),
     /* 2814 */   // Combiner Rule #31: icmp_to_true_false_known_bits; wip_match_opcode 'G_ICMP'
     /* 2814 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner23),
     /* 2817 */ // Label 203: @2817
     /* 2817 */ GIM_Reject,
     /* 2818 */ // Label 35: @2818
     /* 2818 */ GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(2829), // Rule ID 47 //
     /* 2823 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule35Enabled),
     /* 2826 */   // Combiner Rule #35: select_constant_cmp; wip_match_opcode 'G_SELECT'
     /* 2826 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner26),
     /* 2829 */ // Label 204: @2829
     /* 2829 */ GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(2840), // Rule ID 49 //
     /* 2834 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule37Enabled),
     /* 2837 */   // Combiner Rule #37: match_selects; wip_match_opcode 'G_SELECT'
     /* 2837 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner28),
     /* 2840 */ // Label 205: @2840
     /* 2840 */ GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(2851), // Rule ID 82 //
     /* 2845 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule50Enabled),
     /* 2848 */   // Combiner Rule #50: select_same_val; wip_match_opcode 'G_SELECT'
     /* 2848 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner41),
     /* 2851 */ // Label 206: @2851
     /* 2851 */ GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(2862), // Rule ID 150 //
     /* 2856 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 2859 */   // Combiner Rule #84: select_to_minmax; wip_match_opcode 'G_SELECT'
     /* 2859 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner64),
     /* 2862 */ // Label 207: @2862
     /* 2862 */ GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(2883), // Rule ID 48 //
     /* 2867 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule36Enabled),
     /* 2870 */   // MIs[0] root
     /* 2870 */   // No operand predicates
     /* 2870 */   // MIs[0] tst
     /* 2870 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2874 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 2878 */   // MIs[1] tst1
     /* 2878 */   // No operand predicates
     /* 2878 */   // MIs[1] a
     /* 2878 */   // No operand predicates
     /* 2878 */   // MIs[1] b
     /* 2878 */   // No operand predicates
     /* 2878 */   // MIs[0] x
     /* 2878 */   // No operand predicates
     /* 2878 */   // MIs[0] y
     /* 2878 */   // No operand predicates
     /* 2878 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2880 */   // Combiner Rule #36: select_to_iminmax
     /* 2880 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner27),
     /* 2883 */ // Label 208: @2883
     /* 2883 */ GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(2912), // Rule ID 46 //
     /* 2888 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule34Enabled),
     /* 2891 */   // MIs[0] dst
     /* 2891 */   // No operand predicates
     /* 2891 */   // MIs[0] undef
     /* 2891 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2895 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 2899 */   // MIs[0] x
     /* 2899 */   // No operand predicates
     /* 2899 */   // MIs[0] y
     /* 2899 */   // No operand predicates
     /* 2899 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/3,
     /* 2904 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2906 */   // Combiner Rule #34: select_undef_cmp
     /* 2906 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/3,
     /* 2911 */   GIR_EraseRootFromParent_Done,
     /* 2912 */ // Label 209: @2912
     /* 2912 */ GIM_Reject,
     /* 2913 */ // Label 36: @2913
     /* 2913 */ GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(2924), // Rule ID 43 //
     /* 2918 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule32Enabled),
     /* 2921 */   // Combiner Rule #32: match_addos; wip_match_opcode 'G_UADDO'
     /* 2921 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner24),
     /* 2924 */ // Label 210: @2924
     /* 2924 */ GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(2935), // Rule ID 162 //
     /* 2929 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule87Enabled),
     /* 2932 */   // Combiner Rule #87: commute_int_constant_to_rhs; wip_match_opcode 'G_UADDO'
     /* 2932 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner67),
     /* 2935 */ // Label 211: @2935
     /* 2935 */ GIM_Reject,
     /* 2936 */ // Label 37: @2936
     /* 2936 */ GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(2947), // Rule ID 45 //
     /* 2941 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule33Enabled),
     /* 2944 */   // Combiner Rule #33: match_subo_no_overflow; wip_match_opcode 'G_USUBO'
     /* 2944 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 2947 */ // Label 212: @2947
     /* 2947 */ GIM_Reject,
     /* 2948 */ // Label 38: @2948
     /* 2948 */ GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(2959), // Rule ID 42 //
     /* 2953 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule32Enabled),
     /* 2956 */   // Combiner Rule #32: match_addos; wip_match_opcode 'G_SADDO'
     /* 2956 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner24),
     /* 2959 */ // Label 213: @2959
     /* 2959 */ GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(2970), // Rule ID 163 //
     /* 2964 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule87Enabled),
     /* 2967 */   // Combiner Rule #87: commute_int_constant_to_rhs; wip_match_opcode 'G_SADDO'
     /* 2967 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner67),
     /* 2970 */ // Label 214: @2970
     /* 2970 */ GIM_Reject,
     /* 2971 */ // Label 39: @2971
     /* 2971 */ GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(2982), // Rule ID 44 //
     /* 2976 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule33Enabled),
     /* 2979 */   // Combiner Rule #33: match_subo_no_overflow; wip_match_opcode 'G_SSUBO'
     /* 2979 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 2982 */ // Label 215: @2982
     /* 2982 */ GIM_Reject,
     /* 2983 */ // Label 40: @2983
     /* 2983 */ GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(2994), // Rule ID 164 //
     /* 2988 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule87Enabled),
     /* 2991 */   // Combiner Rule #87: commute_int_constant_to_rhs; wip_match_opcode 'G_UMULO'
     /* 2991 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner67),
     /* 2994 */ // Label 216: @2994
     /* 2994 */ GIM_Reject,
     /* 2995 */ // Label 41: @2995
     /* 2995 */ GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(3006), // Rule ID 165 //
     /* 3000 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule87Enabled),
     /* 3003 */   // Combiner Rule #87: commute_int_constant_to_rhs; wip_match_opcode 'G_SMULO'
     /* 3003 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner67),
     /* 3006 */ // Label 217: @3006
     /* 3006 */ GIM_Reject,
     /* 3007 */ // Label 42: @3007
     /* 3007 */ GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(3018), // Rule ID 166 //
     /* 3012 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule87Enabled),
     /* 3015 */   // Combiner Rule #87: commute_int_constant_to_rhs; wip_match_opcode 'G_UMULH'
     /* 3015 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner67),
     /* 3018 */ // Label 218: @3018
     /* 3018 */ GIM_Reject,
     /* 3019 */ // Label 43: @3019
     /* 3019 */ GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(3030), // Rule ID 167 //
     /* 3024 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule87Enabled),
     /* 3027 */   // Combiner Rule #87: commute_int_constant_to_rhs; wip_match_opcode 'G_SMULH'
     /* 3027 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner67),
     /* 3030 */ // Label 219: @3030
     /* 3030 */ GIM_Reject,
     /* 3031 */ // Label 44: @3031
     /* 3031 */ GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(3042), // Rule ID 168 //
     /* 3036 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule87Enabled),
     /* 3039 */   // Combiner Rule #87: commute_int_constant_to_rhs; wip_match_opcode 'G_UADDSAT'
     /* 3039 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner67),
     /* 3042 */ // Label 220: @3042
     /* 3042 */ GIM_Reject,
     /* 3043 */ // Label 45: @3043
     /* 3043 */ GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(3054), // Rule ID 169 //
     /* 3048 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule87Enabled),
     /* 3051 */   // Combiner Rule #87: commute_int_constant_to_rhs; wip_match_opcode 'G_SADDSAT'
     /* 3051 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner67),
     /* 3054 */ // Label 221: @3054
     /* 3054 */ GIM_Reject,
     /* 3055 */ // Label 46: @3055
     /* 3055 */ GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(3066), // Rule ID 170 //
     /* 3060 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule87Enabled),
     /* 3063 */   // Combiner Rule #87: commute_int_constant_to_rhs; wip_match_opcode 'G_SMULFIX'
     /* 3063 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner67),
     /* 3066 */ // Label 222: @3066
     /* 3066 */ GIM_Reject,
     /* 3067 */ // Label 47: @3067
     /* 3067 */ GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(3078), // Rule ID 171 //
     /* 3072 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule87Enabled),
     /* 3075 */   // Combiner Rule #87: commute_int_constant_to_rhs; wip_match_opcode 'G_UMULFIX'
     /* 3075 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner67),
     /* 3078 */ // Label 223: @3078
     /* 3078 */ GIM_Reject,
     /* 3079 */ // Label 48: @3079
     /* 3079 */ GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(3090), // Rule ID 172 //
     /* 3084 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule87Enabled),
     /* 3087 */   // Combiner Rule #87: commute_int_constant_to_rhs; wip_match_opcode 'G_SMULFIXSAT'
     /* 3087 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner67),
     /* 3090 */ // Label 224: @3090
     /* 3090 */ GIM_Reject,
     /* 3091 */ // Label 49: @3091
     /* 3091 */ GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(3102), // Rule ID 173 //
     /* 3096 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule87Enabled),
     /* 3099 */   // Combiner Rule #87: commute_int_constant_to_rhs; wip_match_opcode 'G_UMULFIXSAT'
     /* 3099 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner67),
     /* 3102 */ // Label 225: @3102
     /* 3102 */ GIM_Reject,
     /* 3103 */ // Label 50: @3103
     /* 3103 */ GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(3114), // Rule ID 78 //
     /* 3108 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule49Enabled),
     /* 3111 */   // Combiner Rule #49: constant_fold_fp_binop; wip_match_opcode 'G_FADD'
     /* 3111 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner40),
     /* 3114 */ // Label 226: @3114
     /* 3114 */ GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(3125), // Rule ID 174 //
     /* 3119 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule88Enabled),
     /* 3122 */   // Combiner Rule #88: commute_fp_constant_to_rhs; wip_match_opcode 'G_FADD'
     /* 3122 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner68),
     /* 3125 */ // Label 227: @3125
     /* 3125 */ GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(3148), // Rule ID 117 //
     /* 3130 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule67Enabled),
     /* 3133 */   // MIs[0] dst
     /* 3133 */   // No operand predicates
     /* 3133 */   // MIs[0] x
     /* 3133 */   // No operand predicates
     /* 3133 */   // MIs[0] y
     /* 3133 */   // No operand predicates
     /* 3133 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner1),
     /* 3137 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3142 */   // Combiner Rule #67: right_identity_neg_zero_fp
     /* 3142 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3147 */   GIR_EraseRootFromParent_Done,
     /* 3148 */ // Label 228: @3148
     /* 3148 */ GIM_Reject,
     /* 3149 */ // Label 51: @3149
     /* 3149 */ GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(3160), // Rule ID 79 //
     /* 3154 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule49Enabled),
     /* 3157 */   // Combiner Rule #49: constant_fold_fp_binop; wip_match_opcode 'G_FSUB'
     /* 3157 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner40),
     /* 3160 */ // Label 229: @3160
     /* 3160 */ GIM_Reject,
     /* 3161 */ // Label 52: @3161
     /* 3161 */ GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(3172), // Rule ID 80 //
     /* 3166 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule49Enabled),
     /* 3169 */   // Combiner Rule #49: constant_fold_fp_binop; wip_match_opcode 'G_FMUL'
     /* 3169 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner40),
     /* 3172 */ // Label 230: @3172
     /* 3172 */ GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(3183), // Rule ID 175 //
     /* 3177 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule88Enabled),
     /* 3180 */   // Combiner Rule #88: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMUL'
     /* 3180 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner68),
     /* 3183 */ // Label 231: @3183
     /* 3183 */ GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(3206), // Rule ID 108 //
     /* 3188 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule60Enabled),
     /* 3191 */   // MIs[0] dst
     /* 3191 */   // No operand predicates
     /* 3191 */   // MIs[0] x
     /* 3191 */   // No operand predicates
     /* 3191 */   // MIs[0] y
     /* 3191 */   // No operand predicates
     /* 3191 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner0),
     /* 3195 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3200 */   // Combiner Rule #60: right_identity_one_fp
     /* 3200 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3205 */   GIR_EraseRootFromParent_Done,
     /* 3206 */ // Label 232: @3206
     /* 3206 */ GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(3226), // Rule ID 118 //
     /* 3211 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule68Enabled),
     /* 3214 */   // MIs[0] dst
     /* 3214 */   // No operand predicates
     /* 3214 */   // MIs[0] x
     /* 3214 */   // No operand predicates
     /* 3214 */   // MIs[0] y
     /* 3214 */   // No operand predicates
     /* 3214 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner2),
     /* 3218 */   // Combiner Rule #68: right_identity_neg_one_fp
     /* 3218 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_FNEG),
     /* 3221 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /* 3223 */   GIR_RootToRootCopy, /*OpIdx*/1, // x
     /* 3225 */   GIR_EraseRootFromParent_Done,
     /* 3226 */ // Label 233: @3226
     /* 3226 */ GIM_Reject,
     /* 3227 */ // Label 53: @3227
     /* 3227 */ GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(3238), // Rule ID 81 //
     /* 3232 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule49Enabled),
     /* 3235 */   // Combiner Rule #49: constant_fold_fp_binop; wip_match_opcode 'G_FDIV'
     /* 3235 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner40),
     /* 3238 */ // Label 234: @3238
     /* 3238 */ GIM_Reject,
     /* 3239 */ // Label 54: @3239
     /* 3239 */ GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(3268), // Rule ID 106 //
     /* 3244 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule58Enabled),
     /* 3247 */   // MIs[0] dst
     /* 3247 */   // No operand predicates
     /* 3247 */   // MIs[0] t
     /* 3247 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3251 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FNEG),
     /* 3255 */   // MIs[1] src
     /* 3255 */   // No operand predicates
     /* 3255 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 3260 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3262 */   // Combiner Rule #58: fneg_fneg_fold
     /* 3262 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 3267 */   GIR_EraseRootFromParent_Done,
     /* 3268 */ // Label 235: @3268
     /* 3268 */ GIM_Reject,
     /* 3269 */ // Label 55: @3269
     /* 3269 */ GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(3290), // Rule ID 116 //
     /* 3274 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule66Enabled),
     /* 3277 */   // MIs[0] dst
     /* 3277 */   // No operand predicates
     /* 3277 */   // MIs[0] src1
     /* 3277 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3281 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FPEXT),
     /* 3285 */   // MIs[1] src0
     /* 3285 */   // No operand predicates
     /* 3285 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3287 */   // Combiner Rule #66: fptrunc_fpext_fold
     /* 3287 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner49),
     /* 3290 */ // Label 236: @3290
     /* 3290 */ GIM_Reject,
     /* 3291 */ // Label 56: @3291
     /* 3291 */ GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(3312), // Rule ID 139 //
     /* 3296 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule78Enabled),
     /* 3299 */   // MIs[0] dst
     /* 3299 */   // No operand predicates
     /* 3299 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 3299 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3303 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 3307 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3309 */   // Combiner Rule #78: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[5]]
     /* 3309 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner58),
     /* 3312 */ // Label 237: @3312
     /* 3312 */ GIM_Reject,
     /* 3313 */ // Label 57: @3313
     /* 3313 */ GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(3334), // Rule ID 140 //
     /* 3318 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule78Enabled),
     /* 3321 */   // MIs[0] dst
     /* 3321 */   // No operand predicates
     /* 3321 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 3321 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3325 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 3329 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3331 */   // Combiner Rule #78: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[6]]
     /* 3331 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner58),
     /* 3334 */ // Label 238: @3334
     /* 3334 */ GIM_Reject,
     /* 3335 */ // Label 58: @3335
     /* 3335 */ GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(3346), // Rule ID 123 //
     /* 3340 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule72Enabled),
     /* 3343 */   // Combiner Rule #72: undef_to_fp_zero; wip_match_opcode 'G_SITOFP'
     /* 3343 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner53),
     /* 3346 */ // Label 239: @3346
     /* 3346 */ GIM_Reject,
     /* 3347 */ // Label 59: @3347
     /* 3347 */ GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(3358), // Rule ID 122 //
     /* 3352 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule72Enabled),
     /* 3355 */   // Combiner Rule #72: undef_to_fp_zero; wip_match_opcode 'G_UITOFP'
     /* 3355 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner53),
     /* 3358 */ // Label 240: @3358
     /* 3358 */ GIM_Reject,
     /* 3359 */ // Label 60: @3359
     /* 3359 */ GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(3370), // Rule ID 176 //
     /* 3364 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule88Enabled),
     /* 3367 */   // Combiner Rule #88: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMINNUM'
     /* 3367 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner68),
     /* 3370 */ // Label 241: @3370
     /* 3370 */ GIM_Reject,
     /* 3371 */ // Label 61: @3371
     /* 3371 */ GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(3382), // Rule ID 177 //
     /* 3376 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule88Enabled),
     /* 3379 */   // Combiner Rule #88: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMAXNUM'
     /* 3379 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner68),
     /* 3382 */ // Label 242: @3382
     /* 3382 */ GIM_Reject,
     /* 3383 */ // Label 62: @3383
     /* 3383 */ GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(3394), // Rule ID 178 //
     /* 3388 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule88Enabled),
     /* 3391 */   // Combiner Rule #88: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMINNUM_IEEE'
     /* 3391 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner68),
     /* 3394 */ // Label 243: @3394
     /* 3394 */ GIM_Reject,
     /* 3395 */ // Label 63: @3395
     /* 3395 */ GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(3406), // Rule ID 179 //
     /* 3400 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule88Enabled),
     /* 3403 */   // Combiner Rule #88: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMAXNUM_IEEE'
     /* 3403 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner68),
     /* 3406 */ // Label 244: @3406
     /* 3406 */ GIM_Reject,
     /* 3407 */ // Label 64: @3407
     /* 3407 */ GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(3418), // Rule ID 180 //
     /* 3412 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule88Enabled),
     /* 3415 */   // Combiner Rule #88: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMINIMUM'
     /* 3415 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner68),
     /* 3418 */ // Label 245: @3418
     /* 3418 */ GIM_Reject,
     /* 3419 */ // Label 65: @3419
     /* 3419 */ GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(3430), // Rule ID 181 //
     /* 3424 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule88Enabled),
     /* 3427 */   // Combiner Rule #88: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMAXIMUM'
     /* 3427 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner68),
     /* 3430 */ // Label 246: @3430
     /* 3430 */ GIM_Reject,
     /* 3431 */ // Label 66: @3431
     /* 3431 */ GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(3442), // Rule ID 61 //
     /* 3436 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule48Enabled),
     /* 3439 */   // Combiner Rule #48: constant_fold_binop; wip_match_opcode 'G_PTR_ADD'
     /* 3439 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 3442 */ // Label 247: @3442
     /* 3442 */ GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(3453), // Rule ID 119 //
     /* 3447 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule69Enabled),
     /* 3450 */   // Combiner Rule #69: ptr_add_immed_chain; wip_match_opcode 'G_PTR_ADD'
     /* 3450 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner50),
     /* 3453 */ // Label 248: @3453
     /* 3453 */ GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(3476), // Rule ID 90 //
     /* 3458 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule51Enabled),
     /* 3461 */   // MIs[0] dst
     /* 3461 */   // No operand predicates
     /* 3461 */   // MIs[0] lhs
     /* 3461 */   // No operand predicates
     /* 3461 */   // MIs[0] Operand 2
     /* 3461 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 3465 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3470 */   // Combiner Rule #51: right_identity_zero @ [__right_identity_zero_match_0[7]]
     /* 3470 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3475 */   GIR_EraseRootFromParent_Done,
     /* 3476 */ // Label 249: @3476
     /* 3476 */ GIM_Reject,
     /* 3477 */ // Label 67: @3477
     /* 3477 */ GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(3488), // Rule ID 74 //
     /* 3482 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule48Enabled),
     /* 3485 */   // Combiner Rule #48: constant_fold_binop; wip_match_opcode 'G_SMIN'
     /* 3485 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 3488 */ // Label 250: @3488
     /* 3488 */ GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(3499), // Rule ID 158 //
     /* 3493 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule87Enabled),
     /* 3496 */   // Combiner Rule #87: commute_int_constant_to_rhs; wip_match_opcode 'G_SMIN'
     /* 3496 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner67),
     /* 3499 */ // Label 251: @3499
     /* 3499 */ GIM_Reject,
     /* 3500 */ // Label 68: @3500
     /* 3500 */ GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(3511), // Rule ID 75 //
     /* 3505 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule48Enabled),
     /* 3508 */   // Combiner Rule #48: constant_fold_binop; wip_match_opcode 'G_SMAX'
     /* 3508 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 3511 */ // Label 252: @3511
     /* 3511 */ GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(3522), // Rule ID 159 //
     /* 3516 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule87Enabled),
     /* 3519 */   // Combiner Rule #87: commute_int_constant_to_rhs; wip_match_opcode 'G_SMAX'
     /* 3519 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner67),
     /* 3522 */ // Label 253: @3522
     /* 3522 */ GIM_Reject,
     /* 3523 */ // Label 69: @3523
     /* 3523 */ GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(3534), // Rule ID 76 //
     /* 3528 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule48Enabled),
     /* 3531 */   // Combiner Rule #48: constant_fold_binop; wip_match_opcode 'G_UMIN'
     /* 3531 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 3534 */ // Label 254: @3534
     /* 3534 */ GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(3545), // Rule ID 160 //
     /* 3539 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule87Enabled),
     /* 3542 */   // Combiner Rule #87: commute_int_constant_to_rhs; wip_match_opcode 'G_UMIN'
     /* 3542 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner67),
     /* 3545 */ // Label 255: @3545
     /* 3545 */ GIM_Reject,
     /* 3546 */ // Label 70: @3546
     /* 3546 */ GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(3557), // Rule ID 77 //
     /* 3551 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule48Enabled),
     /* 3554 */   // Combiner Rule #48: constant_fold_binop; wip_match_opcode 'G_UMAX'
     /* 3554 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 3557 */ // Label 256: @3557
     /* 3557 */ GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(3568), // Rule ID 161 //
     /* 3562 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule87Enabled),
     /* 3565 */   // Combiner Rule #87: commute_int_constant_to_rhs; wip_match_opcode 'G_UMAX'
     /* 3565 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner67),
     /* 3568 */ // Label 257: @3568
     /* 3568 */ GIM_Reject,
     /* 3569 */ // Label 71: @3569
     /* 3569 */ GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(3580), // Rule ID 133 //
     /* 3574 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 3577 */   // Combiner Rule #77: unary_undef_to_zero; wip_match_opcode 'G_ABS'
     /* 3577 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner56),
     /* 3580 */ // Label 258: @3580
     /* 3580 */ GIM_Reject,
     /* 3581 */ // Label 72: @3581
     /* 3581 */ GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(3592), // Rule ID 148 //
     /* 3586 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule83Enabled),
     /* 3589 */   // Combiner Rule #83: insert_extract_vec_elt_out_of_bounds; wip_match_opcode 'G_INSERT_VECTOR_ELT'
     /* 3589 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner63),
     /* 3592 */ // Label 259: @3592
     /* 3592 */ GIM_Reject,
     /* 3593 */ // Label 73: @3593
     /* 3593 */ GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(3604), // Rule ID 29 //
     /* 3598 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule22Enabled),
     /* 3601 */   // Combiner Rule #22: extractvecelt_pairwise_add; wip_match_opcode 'G_EXTRACT_VECTOR_ELT'
     /* 3601 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /* 3604 */ // Label 260: @3604
     /* 3604 */ GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(3615), // Rule ID 149 //
     /* 3609 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule83Enabled),
     /* 3612 */   // Combiner Rule #83: insert_extract_vec_elt_out_of_bounds; wip_match_opcode 'G_EXTRACT_VECTOR_ELT'
     /* 3612 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner63),
     /* 3615 */ // Label 261: @3615
     /* 3615 */ GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(3626), // Rule ID 182 //
     /* 3620 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule89Enabled),
     /* 3623 */   // Combiner Rule #89: extract_vec_elt_build_vec; wip_match_opcode 'G_EXTRACT_VECTOR_ELT'
     /* 3623 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner69),
     /* 3626 */ // Label 262: @3626
     /* 3626 */ GIM_Reject,
     /* 3627 */ // Label 74: @3627
     /* 3627 */ GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(3638), // Rule ID 144 //
     /* 3632 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule80Enabled),
     /* 3635 */   // Combiner Rule #80: propagate_undef_all_ops; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 3635 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner60),
     /* 3638 */ // Label 263: @3638
     /* 3638 */ GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(3649), // Rule ID 146 //
     /* 3643 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule81Enabled),
     /* 3646 */   // Combiner Rule #81: propagate_undef_shuffle_mask; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 3646 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner61),
     /* 3649 */ // Label 264: @3649
     /* 3649 */ GIM_Reject,
     /* 3650 */ // Label 75: @3650
     /* 3650 */ GIM_Reject,
     /* 3651 */ }; // Size: 3651 bytes
  return MatchTable0;
}
#undef GIMT_Encode2
#undef GIMT_Encode4
#undef GIMT_Encode8

#endif // ifdef GET_GICOMBINER_IMPL

#ifdef GET_GICOMBINER_CONSTRUCTOR_INITS
AvailableModuleFeatures(computeAvailableModuleFeatures(&STI)),
AvailableFunctionFeatures()
#endif // ifdef GET_GICOMBINER_CONSTRUCTOR_INITS
#ifdef GET_GICOMBINER_CONSTRUCTOR_INITS
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GICOMBINER_CONSTRUCTOR_INITS

