// Copyright (C) 2018 The Android Open Source Project
// Copyright (C) 2018 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Autogenerated module goldfish_vk_counting_guest
//
// (impl) generated by genvk.py
//
// Please do not modify directly;
// re-run mesa3d/src/gfxstream/codegen/generate-gfxstream-vulkan.sh,
// or directly from Python by defining:
// VULKAN_REGISTRY_XML_DIR : Directory containing vk.xml
// VULKAN_REGISTRY_SCRIPTS_DIR : Directory containing genvk.py
// CEREAL_OUTPUT_DIR: Where to put the generated sources.
//
// python3 $VULKAN_REGISTRY_SCRIPTS_DIR/genvk.py -registry $VULKAN_REGISTRY_XML_DIR/vk.xml cereal -o $CEREAL_OUTPUT_DIR
//

#include "goldfish_vk_counting_guest.h"
#include "goldfish_vk_extension_structs_guest.h"
#include "goldfish_vk_private_defs.h"

#include <cstring>

#include <cstdlib>

namespace gfxstream {
namespace vk {

void count_extension_struct(
    uint32_t featureBits,
    VkStructureType rootType,
    const void* structExtension,
    size_t* count);

#ifdef VK_BASE_VERSION_1_0
void count_VkExtent2D(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExtent2D* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
}

void count_VkExtent3D(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExtent3D* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
}

void count_VkOffset2D(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkOffset2D* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(int32_t);
    *count += sizeof(int32_t);
}

void count_VkOffset3D(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkOffset3D* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(int32_t);
    *count += sizeof(int32_t);
    *count += sizeof(int32_t);
}

void count_VkRect2D(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRect2D* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    count_VkOffset2D(featureBits, rootType, (VkOffset2D*)(&toCount->offset), count);
    count_VkExtent2D(featureBits, rootType, (VkExtent2D*)(&toCount->extent), count);
}

void count_VkBaseInStructure(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBaseInStructure* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
}

void count_VkBaseOutStructure(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBaseOutStructure* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
}

void count_VkBufferMemoryBarrier(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBufferMemoryBarrier* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkAccessFlags);
    *count += sizeof(VkAccessFlags);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkDeviceSize);
}

void count_VkImageSubresourceRange(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageSubresourceRange* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkImageAspectFlags);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
}

void count_VkImageMemoryBarrier(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageMemoryBarrier* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkAccessFlags);
    *count += sizeof(VkAccessFlags);
    *count += sizeof(VkImageLayout);
    *count += sizeof(VkImageLayout);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    count_VkImageSubresourceRange(featureBits, rootType, (VkImageSubresourceRange*)(&toCount->subresourceRange), count);
}

void count_VkMemoryBarrier(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryBarrier* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkAccessFlags);
    *count += sizeof(VkAccessFlags);
}

void count_VkAllocationCallbacks(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkAllocationCallbacks* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pUserData)
    {
        *count += sizeof(uint8_t);
    }
    *count += 8;
    *count += 8;
    *count += 8;
    *count += 8;
    *count += 8;
}

void count_VkApplicationInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkApplicationInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    if (featureBits & VULKAN_STREAM_FEATURE_NULL_OPTIONAL_STRINGS_BIT)
    {
        // WARNING PTR CHECK
        *count += 8;
        if (toCount->pApplicationName)
        {
            *count += sizeof(uint32_t) + (toCount->pApplicationName ? strlen(toCount->pApplicationName) : 0);
        }
    }
    else
    {
        *count += sizeof(uint32_t) + (toCount->pApplicationName ? strlen(toCount->pApplicationName) : 0);
    }
    *count += sizeof(uint32_t);
    if (featureBits & VULKAN_STREAM_FEATURE_NULL_OPTIONAL_STRINGS_BIT)
    {
        // WARNING PTR CHECK
        *count += 8;
        if (toCount->pEngineName)
        {
            *count += sizeof(uint32_t) + (toCount->pEngineName ? strlen(toCount->pEngineName) : 0);
        }
    }
    else
    {
        *count += sizeof(uint32_t) + (toCount->pEngineName ? strlen(toCount->pEngineName) : 0);
    }
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
}

void count_VkFormatProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkFormatProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkFormatFeatureFlags);
    *count += sizeof(VkFormatFeatureFlags);
    *count += sizeof(VkFormatFeatureFlags);
}

void count_VkImageFormatProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageFormatProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    count_VkExtent3D(featureBits, rootType, (VkExtent3D*)(&toCount->maxExtent), count);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(VkSampleCountFlags);
    *count += sizeof(VkDeviceSize);
}

void count_VkInstanceCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkInstanceCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkInstanceCreateFlags);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pApplicationInfo)
    {
        count_VkApplicationInfo(featureBits, rootType, (const VkApplicationInfo*)(toCount->pApplicationInfo), count);
    }
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < toCount->enabledLayerCount; ++i)
        {
            *count += sizeof(uint32_t) + (toCount->ppEnabledLayerNames[i] ? strlen(toCount->ppEnabledLayerNames[i]) : 0);
        }
    }
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < toCount->enabledExtensionCount; ++i)
        {
            *count += sizeof(uint32_t) + (toCount->ppEnabledExtensionNames[i] ? strlen(toCount->ppEnabledExtensionNames[i]) : 0);
        }
    }
}

void count_VkMemoryHeap(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryHeap* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkMemoryHeapFlags);
}

void count_VkMemoryType(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryType* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkMemoryPropertyFlags);
    *count += sizeof(uint32_t);
}

void count_VkPhysicalDeviceFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceLimits(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceLimits* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkDeviceSize);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += 3 * sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += 3 * sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(float);
    *count += sizeof(float);
    *count += sizeof(uint32_t);
    *count += 2 * sizeof(uint32_t);
    *count += 2 * sizeof(float);
    *count += sizeof(uint32_t);
    *count += 8;
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkDeviceSize);
    *count += sizeof(int32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(int32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(float);
    *count += sizeof(float);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(VkSampleCountFlags);
    *count += sizeof(VkSampleCountFlags);
    *count += sizeof(VkSampleCountFlags);
    *count += sizeof(VkSampleCountFlags);
    *count += sizeof(uint32_t);
    *count += sizeof(VkSampleCountFlags);
    *count += sizeof(VkSampleCountFlags);
    *count += sizeof(VkSampleCountFlags);
    *count += sizeof(VkSampleCountFlags);
    *count += sizeof(VkSampleCountFlags);
    *count += sizeof(uint32_t);
    *count += sizeof(VkBool32);
    *count += sizeof(float);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += 2 * sizeof(float);
    *count += 2 * sizeof(float);
    *count += sizeof(float);
    *count += sizeof(float);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkDeviceSize);
}

void count_VkPhysicalDeviceMemoryProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceMemoryProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)VK_MAX_MEMORY_TYPES; ++i)
    {
        count_VkMemoryType(featureBits, rootType, (VkMemoryType*)(toCount->memoryTypes + i), count);
    }
    *count += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)VK_MAX_MEMORY_HEAPS; ++i)
    {
        count_VkMemoryHeap(featureBits, rootType, (VkMemoryHeap*)(toCount->memoryHeaps + i), count);
    }
}

void count_VkPhysicalDeviceSparseProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceSparseProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(VkPhysicalDeviceType);
    *count += VK_MAX_PHYSICAL_DEVICE_NAME_SIZE * sizeof(char);
    *count += VK_UUID_SIZE * sizeof(uint8_t);
    count_VkPhysicalDeviceLimits(featureBits, rootType, (VkPhysicalDeviceLimits*)(&toCount->limits), count);
    count_VkPhysicalDeviceSparseProperties(featureBits, rootType, (VkPhysicalDeviceSparseProperties*)(&toCount->sparseProperties), count);
}

void count_VkQueueFamilyProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkQueueFamilyProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkQueueFlags);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    count_VkExtent3D(featureBits, rootType, (VkExtent3D*)(&toCount->minImageTransferGranularity), count);
}

void count_VkDeviceQueueCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceQueueCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkDeviceQueueCreateFlags);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        *count += toCount->queueCount * sizeof(const float);
    }
}

void count_VkDeviceCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkDeviceCreateFlags);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->queueCreateInfoCount; ++i)
        {
            count_VkDeviceQueueCreateInfo(featureBits, rootType, (const VkDeviceQueueCreateInfo*)(toCount->pQueueCreateInfos + i), count);
        }
    }
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < toCount->enabledLayerCount; ++i)
        {
            *count += sizeof(uint32_t) + (toCount->ppEnabledLayerNames[i] ? strlen(toCount->ppEnabledLayerNames[i]) : 0);
        }
    }
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < toCount->enabledExtensionCount; ++i)
        {
            *count += sizeof(uint32_t) + (toCount->ppEnabledExtensionNames[i] ? strlen(toCount->ppEnabledExtensionNames[i]) : 0);
        }
    }
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pEnabledFeatures)
    {
        count_VkPhysicalDeviceFeatures(featureBits, rootType, (const VkPhysicalDeviceFeatures*)(toCount->pEnabledFeatures), count);
    }
}

void count_VkExtensionProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExtensionProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += VK_MAX_EXTENSION_NAME_SIZE * sizeof(char);
    *count += sizeof(uint32_t);
}

void count_VkLayerProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkLayerProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += VK_MAX_EXTENSION_NAME_SIZE * sizeof(char);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += VK_MAX_DESCRIPTION_SIZE * sizeof(char);
}

void count_VkSubmitInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSubmitInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    if (toCount->waitSemaphoreCount)
    {
        *count += toCount->waitSemaphoreCount * 8;
    }
    if (toCount)
    {
        *count += toCount->waitSemaphoreCount * sizeof(const VkPipelineStageFlags);
    }
    *count += sizeof(uint32_t);
    if (toCount->commandBufferCount)
    {
        *count += toCount->commandBufferCount * 8;
    }
    *count += sizeof(uint32_t);
    if (toCount->signalSemaphoreCount)
    {
        *count += toCount->signalSemaphoreCount * 8;
    }
}

void count_VkMappedMemoryRange(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMappedMemoryRange* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkDeviceSize);
}

void count_VkMemoryAllocateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryAllocateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkDeviceSize);
    *count += sizeof(uint32_t);
}

void count_VkMemoryRequirements(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryRequirements* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkDeviceSize);
    *count += sizeof(uint32_t);
}

void count_VkSparseMemoryBind(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSparseMemoryBind* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkDeviceSize);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkSparseMemoryBindFlags);
}

void count_VkSparseBufferMemoryBindInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSparseBufferMemoryBindInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->bindCount; ++i)
        {
            count_VkSparseMemoryBind(featureBits, rootType, (const VkSparseMemoryBind*)(toCount->pBinds + i), count);
        }
    }
}

void count_VkSparseImageOpaqueMemoryBindInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSparseImageOpaqueMemoryBindInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->bindCount; ++i)
        {
            count_VkSparseMemoryBind(featureBits, rootType, (const VkSparseMemoryBind*)(toCount->pBinds + i), count);
        }
    }
}

void count_VkImageSubresource(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageSubresource* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkImageAspectFlags);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
}

void count_VkSparseImageMemoryBind(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSparseImageMemoryBind* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    count_VkImageSubresource(featureBits, rootType, (VkImageSubresource*)(&toCount->subresource), count);
    count_VkOffset3D(featureBits, rootType, (VkOffset3D*)(&toCount->offset), count);
    count_VkExtent3D(featureBits, rootType, (VkExtent3D*)(&toCount->extent), count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkSparseMemoryBindFlags);
}

void count_VkSparseImageMemoryBindInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSparseImageMemoryBindInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->bindCount; ++i)
        {
            count_VkSparseImageMemoryBind(featureBits, rootType, (const VkSparseImageMemoryBind*)(toCount->pBinds + i), count);
        }
    }
}

void count_VkBindSparseInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBindSparseInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    if (toCount->waitSemaphoreCount)
    {
        *count += toCount->waitSemaphoreCount * 8;
    }
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->bufferBindCount; ++i)
        {
            count_VkSparseBufferMemoryBindInfo(featureBits, rootType, (const VkSparseBufferMemoryBindInfo*)(toCount->pBufferBinds + i), count);
        }
    }
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->imageOpaqueBindCount; ++i)
        {
            count_VkSparseImageOpaqueMemoryBindInfo(featureBits, rootType, (const VkSparseImageOpaqueMemoryBindInfo*)(toCount->pImageOpaqueBinds + i), count);
        }
    }
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->imageBindCount; ++i)
        {
            count_VkSparseImageMemoryBindInfo(featureBits, rootType, (const VkSparseImageMemoryBindInfo*)(toCount->pImageBinds + i), count);
        }
    }
    *count += sizeof(uint32_t);
    if (toCount->signalSemaphoreCount)
    {
        *count += toCount->signalSemaphoreCount * 8;
    }
}

void count_VkSparseImageFormatProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSparseImageFormatProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkImageAspectFlags);
    count_VkExtent3D(featureBits, rootType, (VkExtent3D*)(&toCount->imageGranularity), count);
    *count += sizeof(VkSparseImageFormatFlags);
}

void count_VkSparseImageMemoryRequirements(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSparseImageMemoryRequirements* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    count_VkSparseImageFormatProperties(featureBits, rootType, (VkSparseImageFormatProperties*)(&toCount->formatProperties), count);
    *count += sizeof(uint32_t);
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkDeviceSize);
}

void count_VkFenceCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkFenceCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkFenceCreateFlags);
}

void count_VkSemaphoreCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSemaphoreCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkSemaphoreCreateFlags);
}

void count_VkQueryPoolCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkQueryPoolCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkQueryPoolCreateFlags);
    *count += sizeof(VkQueryType);
    *count += sizeof(uint32_t);
    *count += sizeof(VkQueryPipelineStatisticFlags);
}

void count_VkBufferCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBufferCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBufferCreateFlags);
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkBufferUsageFlags);
    *count += sizeof(VkSharingMode);
    *count += sizeof(uint32_t);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pQueueFamilyIndices)
    {
        if (toCount)
        {
            *count += toCount->queueFamilyIndexCount * sizeof(const uint32_t);
        }
    }
}

void count_VkImageCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkImageCreateFlags);
    *count += sizeof(VkImageType);
    *count += sizeof(VkFormat);
    count_VkExtent3D(featureBits, rootType, (VkExtent3D*)(&toCount->extent), count);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(VkSampleCountFlagBits);
    *count += sizeof(VkImageTiling);
    *count += sizeof(VkImageUsageFlags);
    *count += sizeof(VkSharingMode);
    *count += sizeof(uint32_t);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pQueueFamilyIndices)
    {
        if (toCount)
        {
            *count += toCount->queueFamilyIndexCount * sizeof(const uint32_t);
        }
    }
    *count += sizeof(VkImageLayout);
}

void count_VkSubresourceLayout(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSubresourceLayout* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkDeviceSize);
}

void count_VkComponentMapping(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkComponentMapping* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkComponentSwizzle);
    *count += sizeof(VkComponentSwizzle);
    *count += sizeof(VkComponentSwizzle);
    *count += sizeof(VkComponentSwizzle);
}

void count_VkImageViewCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageViewCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkImageViewCreateFlags);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkImageViewType);
    *count += sizeof(VkFormat);
    count_VkComponentMapping(featureBits, rootType, (VkComponentMapping*)(&toCount->components), count);
    count_VkImageSubresourceRange(featureBits, rootType, (VkImageSubresourceRange*)(&toCount->subresourceRange), count);
}

void count_VkCommandPoolCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCommandPoolCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkCommandPoolCreateFlags);
    *count += sizeof(uint32_t);
}

void count_VkCommandBufferAllocateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCommandBufferAllocateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkCommandBufferLevel);
    *count += sizeof(uint32_t);
}

void count_VkCommandBufferInheritanceInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCommandBufferInheritanceInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(uint32_t);
    uint64_t cgen_var_1;
    (void)cgen_var_1;
    *count += 1 * 8;
    *count += sizeof(VkBool32);
    *count += sizeof(VkQueryControlFlags);
    *count += sizeof(VkQueryPipelineStatisticFlags);
}

void count_VkCommandBufferBeginInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCommandBufferBeginInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkCommandBufferUsageFlags);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pInheritanceInfo)
    {
        count_VkCommandBufferInheritanceInfo(featureBits, rootType, (const VkCommandBufferInheritanceInfo*)(toCount->pInheritanceInfo), count);
    }
}

void count_VkBufferCopy(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBufferCopy* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkDeviceSize);
}

void count_VkImageSubresourceLayers(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageSubresourceLayers* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkImageAspectFlags);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
}

void count_VkBufferImageCopy(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBufferImageCopy* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkDeviceSize);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    count_VkImageSubresourceLayers(featureBits, rootType, (VkImageSubresourceLayers*)(&toCount->imageSubresource), count);
    count_VkOffset3D(featureBits, rootType, (VkOffset3D*)(&toCount->imageOffset), count);
    count_VkExtent3D(featureBits, rootType, (VkExtent3D*)(&toCount->imageExtent), count);
}

void count_VkImageCopy(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageCopy* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    count_VkImageSubresourceLayers(featureBits, rootType, (VkImageSubresourceLayers*)(&toCount->srcSubresource), count);
    count_VkOffset3D(featureBits, rootType, (VkOffset3D*)(&toCount->srcOffset), count);
    count_VkImageSubresourceLayers(featureBits, rootType, (VkImageSubresourceLayers*)(&toCount->dstSubresource), count);
    count_VkOffset3D(featureBits, rootType, (VkOffset3D*)(&toCount->dstOffset), count);
    count_VkExtent3D(featureBits, rootType, (VkExtent3D*)(&toCount->extent), count);
}

#endif
#ifdef VK_COMPUTE_VERSION_1_0
void count_VkDispatchIndirectCommand(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDispatchIndirectCommand* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
}

void count_VkPipelineCacheHeaderVersionOne(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineCacheHeaderVersionOne* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(uint32_t);
    *count += sizeof(VkPipelineCacheHeaderVersion);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += VK_UUID_SIZE * sizeof(uint8_t);
}

void count_VkEventCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkEventCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkEventCreateFlags);
}

void count_VkBufferViewCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBufferViewCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBufferViewCreateFlags);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkFormat);
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkDeviceSize);
}

void count_VkShaderModuleCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkShaderModuleCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkShaderModuleCreateFlags);
    *count += 8;
    if (toCount)
    {
        *count += (toCount->codeSize / 4) * sizeof(const uint32_t);
    }
}

void count_VkPipelineCacheCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineCacheCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkPipelineCacheCreateFlags);
    *count += 8;
    if (toCount)
    {
        *count += toCount->initialDataSize * sizeof(const uint8_t);
    }
}

void count_VkSpecializationMapEntry(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSpecializationMapEntry* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += 8;
}

void count_VkSpecializationInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSpecializationInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->mapEntryCount; ++i)
        {
            count_VkSpecializationMapEntry(featureBits, rootType, (const VkSpecializationMapEntry*)(toCount->pMapEntries + i), count);
        }
    }
    *count += 8;
    if (toCount)
    {
        *count += toCount->dataSize * sizeof(const uint8_t);
    }
}

void count_VkPipelineShaderStageCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineShaderStageCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkPipelineShaderStageCreateFlags);
    *count += sizeof(VkShaderStageFlagBits);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(uint32_t) + (toCount->pName ? strlen(toCount->pName) : 0);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pSpecializationInfo)
    {
        count_VkSpecializationInfo(featureBits, rootType, (const VkSpecializationInfo*)(toCount->pSpecializationInfo), count);
    }
}

void count_VkComputePipelineCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkComputePipelineCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkPipelineCreateFlags);
    count_VkPipelineShaderStageCreateInfo(featureBits, rootType, (VkPipelineShaderStageCreateInfo*)(&toCount->stage), count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    uint64_t cgen_var_1;
    (void)cgen_var_1;
    *count += 1 * 8;
    *count += sizeof(int32_t);
}

void count_VkPushConstantRange(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPushConstantRange* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkShaderStageFlags);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
}

void count_VkPipelineLayoutCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineLayoutCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkPipelineLayoutCreateFlags);
    *count += sizeof(uint32_t);
    if (toCount->setLayoutCount)
    {
        *count += toCount->setLayoutCount * 8;
    }
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->pushConstantRangeCount; ++i)
        {
            count_VkPushConstantRange(featureBits, rootType, (const VkPushConstantRange*)(toCount->pPushConstantRanges + i), count);
        }
    }
}

void count_VkSamplerCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSamplerCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkSamplerCreateFlags);
    *count += sizeof(VkFilter);
    *count += sizeof(VkFilter);
    *count += sizeof(VkSamplerMipmapMode);
    *count += sizeof(VkSamplerAddressMode);
    *count += sizeof(VkSamplerAddressMode);
    *count += sizeof(VkSamplerAddressMode);
    *count += sizeof(float);
    *count += sizeof(VkBool32);
    *count += sizeof(float);
    *count += sizeof(VkBool32);
    *count += sizeof(VkCompareOp);
    *count += sizeof(float);
    *count += sizeof(float);
    *count += sizeof(VkBorderColor);
    *count += sizeof(VkBool32);
}

void count_VkCopyDescriptorSet(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCopyDescriptorSet* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    uint64_t cgen_var_1;
    (void)cgen_var_1;
    *count += 1 * 8;
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
}

void count_VkDescriptorBufferInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorBufferInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkDeviceSize);
}

void count_VkDescriptorImageInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorImageInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    uint64_t cgen_var_1;
    (void)cgen_var_1;
    *count += 1 * 8;
    *count += sizeof(VkImageLayout);
}

void count_VkDescriptorPoolSize(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorPoolSize* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkDescriptorType);
    *count += sizeof(uint32_t);
}

void count_VkDescriptorPoolCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorPoolCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkDescriptorPoolCreateFlags);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->poolSizeCount; ++i)
        {
            count_VkDescriptorPoolSize(featureBits, rootType, (const VkDescriptorPoolSize*)(toCount->pPoolSizes + i), count);
        }
    }
}

void count_VkDescriptorSetAllocateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorSetAllocateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(uint32_t);
    if (toCount->descriptorSetCount)
    {
        *count += toCount->descriptorSetCount * 8;
    }
}

void count_VkDescriptorSetLayoutBinding(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorSetLayoutBinding* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(uint32_t);
    *count += sizeof(VkDescriptorType);
    *count += sizeof(uint32_t);
    *count += sizeof(VkShaderStageFlags);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pImmutableSamplers)
    {
        if (toCount->descriptorCount)
        {
            *count += toCount->descriptorCount * 8;
        }
    }
}

void count_VkDescriptorSetLayoutCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorSetLayoutCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkDescriptorSetLayoutCreateFlags);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->bindingCount; ++i)
        {
            count_VkDescriptorSetLayoutBinding(featureBits, rootType, (const VkDescriptorSetLayoutBinding*)(toCount->pBindings + i), count);
        }
    }
}

void count_VkWriteDescriptorSet(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkWriteDescriptorSet* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(VkDescriptorType);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pImageInfo)
    {
        if ((!(featureBits & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || ((VK_DESCRIPTOR_TYPE_SAMPLER == toCount->descriptorType) || (VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER == toCount->descriptorType) || (VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE == toCount->descriptorType) || (VK_DESCRIPTOR_TYPE_STORAGE_IMAGE == toCount->descriptorType) || (VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT == toCount->descriptorType))))
        {
            if (toCount)
            {
                for (uint32_t i = 0; i < (uint32_t)toCount->descriptorCount; ++i)
                {
                    count_VkDescriptorImageInfo(featureBits, rootType, (const VkDescriptorImageInfo*)(toCount->pImageInfo + i), count);
                }
            }
        }
    }
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pBufferInfo)
    {
        if ((!(featureBits & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || ((VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER == toCount->descriptorType) || (VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC == toCount->descriptorType) || (VK_DESCRIPTOR_TYPE_STORAGE_BUFFER == toCount->descriptorType) || (VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC == toCount->descriptorType))))
        {
            if (toCount)
            {
                for (uint32_t i = 0; i < (uint32_t)toCount->descriptorCount; ++i)
                {
                    count_VkDescriptorBufferInfo(featureBits, rootType, (const VkDescriptorBufferInfo*)(toCount->pBufferInfo + i), count);
                }
            }
        }
    }
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pTexelBufferView)
    {
        if ((!(featureBits & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || ((VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER == toCount->descriptorType) || (VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER == toCount->descriptorType))))
        {
            if (toCount->descriptorCount)
            {
                *count += toCount->descriptorCount * 8;
            }
        }
    }
}

void count_VkClearColorValue(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkClearColorValue* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += 4 * sizeof(float);
}

#endif
#ifdef VK_GRAPHICS_VERSION_1_0
void count_VkDrawIndexedIndirectCommand(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDrawIndexedIndirectCommand* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(int32_t);
    *count += sizeof(uint32_t);
}

void count_VkDrawIndirectCommand(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDrawIndirectCommand* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
}

void count_VkVertexInputBindingDescription(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkVertexInputBindingDescription* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(VkVertexInputRate);
}

void count_VkVertexInputAttributeDescription(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkVertexInputAttributeDescription* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(VkFormat);
    *count += sizeof(uint32_t);
}

void count_VkPipelineVertexInputStateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineVertexInputStateCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkPipelineVertexInputStateCreateFlags);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->vertexBindingDescriptionCount; ++i)
        {
            count_VkVertexInputBindingDescription(featureBits, rootType, (const VkVertexInputBindingDescription*)(toCount->pVertexBindingDescriptions + i), count);
        }
    }
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->vertexAttributeDescriptionCount; ++i)
        {
            count_VkVertexInputAttributeDescription(featureBits, rootType, (const VkVertexInputAttributeDescription*)(toCount->pVertexAttributeDescriptions + i), count);
        }
    }
}

void count_VkPipelineInputAssemblyStateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineInputAssemblyStateCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkPipelineInputAssemblyStateCreateFlags);
    *count += sizeof(VkPrimitiveTopology);
    *count += sizeof(VkBool32);
}

void count_VkPipelineTessellationStateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineTessellationStateCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkPipelineTessellationStateCreateFlags);
    *count += sizeof(uint32_t);
}

void count_VkViewport(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkViewport* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(float);
    *count += sizeof(float);
    *count += sizeof(float);
    *count += sizeof(float);
    *count += sizeof(float);
    *count += sizeof(float);
}

void count_VkPipelineViewportStateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineViewportStateCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkPipelineViewportStateCreateFlags);
    *count += sizeof(uint32_t);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pViewports)
    {
        if (toCount)
        {
            for (uint32_t i = 0; i < (uint32_t)toCount->viewportCount; ++i)
            {
                count_VkViewport(featureBits, rootType, (const VkViewport*)(toCount->pViewports + i), count);
            }
        }
    }
    *count += sizeof(uint32_t);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pScissors)
    {
        if (toCount)
        {
            for (uint32_t i = 0; i < (uint32_t)toCount->scissorCount; ++i)
            {
                count_VkRect2D(featureBits, rootType, (const VkRect2D*)(toCount->pScissors + i), count);
            }
        }
    }
}

void count_VkPipelineRasterizationStateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineRasterizationStateCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkPipelineRasterizationStateCreateFlags);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkPolygonMode);
    *count += sizeof(VkCullModeFlags);
    *count += sizeof(VkFrontFace);
    *count += sizeof(VkBool32);
    *count += sizeof(float);
    *count += sizeof(float);
    *count += sizeof(float);
    *count += sizeof(float);
}

void count_VkPipelineMultisampleStateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineMultisampleStateCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkPipelineMultisampleStateCreateFlags);
    *count += sizeof(VkSampleCountFlagBits);
    *count += sizeof(VkBool32);
    *count += sizeof(float);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pSampleMask)
    {
        if (toCount)
        {
            *count += (((toCount->rasterizationSamples) + 31) / 32) * sizeof(const VkSampleMask);
        }
    }
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkStencilOpState(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkStencilOpState* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStencilOp);
    *count += sizeof(VkStencilOp);
    *count += sizeof(VkStencilOp);
    *count += sizeof(VkCompareOp);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
}

void count_VkPipelineDepthStencilStateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineDepthStencilStateCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkPipelineDepthStencilStateCreateFlags);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkCompareOp);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    count_VkStencilOpState(featureBits, rootType, (VkStencilOpState*)(&toCount->front), count);
    count_VkStencilOpState(featureBits, rootType, (VkStencilOpState*)(&toCount->back), count);
    *count += sizeof(float);
    *count += sizeof(float);
}

void count_VkPipelineColorBlendAttachmentState(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineColorBlendAttachmentState* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkBool32);
    *count += sizeof(VkBlendFactor);
    *count += sizeof(VkBlendFactor);
    *count += sizeof(VkBlendOp);
    *count += sizeof(VkBlendFactor);
    *count += sizeof(VkBlendFactor);
    *count += sizeof(VkBlendOp);
    *count += sizeof(VkColorComponentFlags);
}

void count_VkPipelineColorBlendStateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineColorBlendStateCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkPipelineColorBlendStateCreateFlags);
    *count += sizeof(VkBool32);
    *count += sizeof(VkLogicOp);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->attachmentCount; ++i)
        {
            count_VkPipelineColorBlendAttachmentState(featureBits, rootType, (const VkPipelineColorBlendAttachmentState*)(toCount->pAttachments + i), count);
        }
    }
    *count += 4 * sizeof(float);
}

void count_VkPipelineDynamicStateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineDynamicStateCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkPipelineDynamicStateCreateFlags);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        *count += toCount->dynamicStateCount * sizeof(const VkDynamicState);
    }
}

void count_VkGraphicsPipelineCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkGraphicsPipelineCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    uint32_t hasRasterization = 1;
    if (featureBits & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT)
    {
        hasRasterization = ((((0 == toCount->pRasterizationState)) ? (0) : (!((*(toCount->pRasterizationState)).rasterizerDiscardEnable))) || (((0 == toCount->pDynamicState)) ? (0) : (arrayany((*(toCount->pDynamicState)).pDynamicStates, 0, (*(toCount->pDynamicState)).dynamicStateCount, [](VkDynamicState s) { return (s == VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE); }))));
        *count += 4;
    }
    uint32_t hasTessellation = 1;
    if (featureBits & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT)
    {
        hasTessellation = arrayany(toCount->pStages, 0, toCount->stageCount, [](VkPipelineShaderStageCreateInfo s) { return ((s.stage == VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT) || (s.stage == VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT)); });
        *count += 4;
    }
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkPipelineCreateFlags);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->stageCount; ++i)
        {
            count_VkPipelineShaderStageCreateInfo(featureBits, rootType, (const VkPipelineShaderStageCreateInfo*)(toCount->pStages + i), count);
        }
    }
    // WARNING PTR CHECK
    if (featureBits & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT)
    {
        *count += 8;
    }
    if ((!(featureBits & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || toCount->pVertexInputState))
    {
        count_VkPipelineVertexInputStateCreateInfo(featureBits, rootType, (const VkPipelineVertexInputStateCreateInfo*)(toCount->pVertexInputState), count);
    }
    // WARNING PTR CHECK
    if (featureBits & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT)
    {
        *count += 8;
    }
    if ((!(featureBits & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || toCount->pInputAssemblyState))
    {
        count_VkPipelineInputAssemblyStateCreateInfo(featureBits, rootType, (const VkPipelineInputAssemblyStateCreateInfo*)(toCount->pInputAssemblyState), count);
    }
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pTessellationState)
    {
        if (hasTessellation)
        {
            count_VkPipelineTessellationStateCreateInfo(featureBits, rootType, (const VkPipelineTessellationStateCreateInfo*)(toCount->pTessellationState), count);
        }
    }
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pViewportState)
    {
        if (hasRasterization)
        {
            count_VkPipelineViewportStateCreateInfo(featureBits, rootType, (const VkPipelineViewportStateCreateInfo*)(toCount->pViewportState), count);
        }
    }
    // WARNING PTR CHECK
    if (featureBits & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT)
    {
        *count += 8;
    }
    if ((!(featureBits & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || toCount->pRasterizationState))
    {
        count_VkPipelineRasterizationStateCreateInfo(featureBits, rootType, (const VkPipelineRasterizationStateCreateInfo*)(toCount->pRasterizationState), count);
    }
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pMultisampleState)
    {
        if (hasRasterization)
        {
            count_VkPipelineMultisampleStateCreateInfo(featureBits, rootType, (const VkPipelineMultisampleStateCreateInfo*)(toCount->pMultisampleState), count);
        }
    }
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pDepthStencilState)
    {
        if (hasRasterization)
        {
            count_VkPipelineDepthStencilStateCreateInfo(featureBits, rootType, (const VkPipelineDepthStencilStateCreateInfo*)(toCount->pDepthStencilState), count);
        }
    }
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pColorBlendState)
    {
        if (hasRasterization)
        {
            count_VkPipelineColorBlendStateCreateInfo(featureBits, rootType, (const VkPipelineColorBlendStateCreateInfo*)(toCount->pColorBlendState), count);
        }
    }
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pDynamicState)
    {
        count_VkPipelineDynamicStateCreateInfo(featureBits, rootType, (const VkPipelineDynamicStateCreateInfo*)(toCount->pDynamicState), count);
    }
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    uint64_t cgen_var_1;
    (void)cgen_var_1;
    *count += 1 * 8;
    *count += sizeof(uint32_t);
    uint64_t cgen_var_2;
    (void)cgen_var_2;
    *count += 1 * 8;
    *count += sizeof(int32_t);
}

void count_VkAttachmentDescription(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkAttachmentDescription* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkAttachmentDescriptionFlags);
    *count += sizeof(VkFormat);
    *count += sizeof(VkSampleCountFlagBits);
    *count += sizeof(VkAttachmentLoadOp);
    *count += sizeof(VkAttachmentStoreOp);
    *count += sizeof(VkAttachmentLoadOp);
    *count += sizeof(VkAttachmentStoreOp);
    *count += sizeof(VkImageLayout);
    *count += sizeof(VkImageLayout);
}

void count_VkAttachmentReference(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkAttachmentReference* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(uint32_t);
    *count += sizeof(VkImageLayout);
}

void count_VkFramebufferCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkFramebufferCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkFramebufferCreateFlags);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(uint32_t);
    if ((!(featureBits & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || (((toCount->flags & VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT) == 0))))
    {
        if (toCount->attachmentCount)
        {
            *count += toCount->attachmentCount * 8;
        }
    }
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
}

void count_VkSubpassDescription(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSubpassDescription* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkSubpassDescriptionFlags);
    *count += sizeof(VkPipelineBindPoint);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->inputAttachmentCount; ++i)
        {
            count_VkAttachmentReference(featureBits, rootType, (const VkAttachmentReference*)(toCount->pInputAttachments + i), count);
        }
    }
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->colorAttachmentCount; ++i)
        {
            count_VkAttachmentReference(featureBits, rootType, (const VkAttachmentReference*)(toCount->pColorAttachments + i), count);
        }
    }
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pResolveAttachments)
    {
        if (toCount)
        {
            for (uint32_t i = 0; i < (uint32_t)toCount->colorAttachmentCount; ++i)
            {
                count_VkAttachmentReference(featureBits, rootType, (const VkAttachmentReference*)(toCount->pResolveAttachments + i), count);
            }
        }
    }
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pDepthStencilAttachment)
    {
        count_VkAttachmentReference(featureBits, rootType, (const VkAttachmentReference*)(toCount->pDepthStencilAttachment), count);
    }
    *count += sizeof(uint32_t);
    if (toCount)
    {
        *count += toCount->preserveAttachmentCount * sizeof(const uint32_t);
    }
}

void count_VkSubpassDependency(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSubpassDependency* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(VkPipelineStageFlags);
    *count += sizeof(VkPipelineStageFlags);
    *count += sizeof(VkAccessFlags);
    *count += sizeof(VkAccessFlags);
    *count += sizeof(VkDependencyFlags);
}

void count_VkRenderPassCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderPassCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkRenderPassCreateFlags);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->attachmentCount; ++i)
        {
            count_VkAttachmentDescription(featureBits, rootType, (const VkAttachmentDescription*)(toCount->pAttachments + i), count);
        }
    }
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->subpassCount; ++i)
        {
            count_VkSubpassDescription(featureBits, rootType, (const VkSubpassDescription*)(toCount->pSubpasses + i), count);
        }
    }
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->dependencyCount; ++i)
        {
            count_VkSubpassDependency(featureBits, rootType, (const VkSubpassDependency*)(toCount->pDependencies + i), count);
        }
    }
}

void count_VkClearDepthStencilValue(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkClearDepthStencilValue* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(float);
    *count += sizeof(uint32_t);
}

void count_VkClearValue(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkClearValue* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    count_VkClearColorValue(featureBits, rootType, (VkClearColorValue*)(&toCount->color), count);
}

void count_VkClearAttachment(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkClearAttachment* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkImageAspectFlags);
    *count += sizeof(uint32_t);
    count_VkClearValue(featureBits, rootType, (VkClearValue*)(&toCount->clearValue), count);
}

void count_VkClearRect(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkClearRect* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    count_VkRect2D(featureBits, rootType, (VkRect2D*)(&toCount->rect), count);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
}

void count_VkImageBlit(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageBlit* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    count_VkImageSubresourceLayers(featureBits, rootType, (VkImageSubresourceLayers*)(&toCount->srcSubresource), count);
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        count_VkOffset3D(featureBits, rootType, (VkOffset3D*)(toCount->srcOffsets + i), count);
    }
    count_VkImageSubresourceLayers(featureBits, rootType, (VkImageSubresourceLayers*)(&toCount->dstSubresource), count);
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        count_VkOffset3D(featureBits, rootType, (VkOffset3D*)(toCount->dstOffsets + i), count);
    }
}

void count_VkImageResolve(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageResolve* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    count_VkImageSubresourceLayers(featureBits, rootType, (VkImageSubresourceLayers*)(&toCount->srcSubresource), count);
    count_VkOffset3D(featureBits, rootType, (VkOffset3D*)(&toCount->srcOffset), count);
    count_VkImageSubresourceLayers(featureBits, rootType, (VkImageSubresourceLayers*)(&toCount->dstSubresource), count);
    count_VkOffset3D(featureBits, rootType, (VkOffset3D*)(&toCount->dstOffset), count);
    count_VkExtent3D(featureBits, rootType, (VkExtent3D*)(&toCount->extent), count);
}

void count_VkRenderPassBeginInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderPassBeginInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    uint64_t cgen_var_1;
    (void)cgen_var_1;
    *count += 1 * 8;
    count_VkRect2D(featureBits, rootType, (VkRect2D*)(&toCount->renderArea), count);
    *count += sizeof(uint32_t);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pClearValues)
    {
        if (toCount)
        {
            for (uint32_t i = 0; i < (uint32_t)toCount->clearValueCount; ++i)
            {
                count_VkClearValue(featureBits, rootType, (const VkClearValue*)(toCount->pClearValues + i), count);
            }
        }
    }
}

#endif
#ifdef VK_BASE_VERSION_1_1
void count_VkBindBufferMemoryInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBindBufferMemoryInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    uint64_t cgen_var_1;
    (void)cgen_var_1;
    *count += 1 * 8;
    *count += sizeof(VkDeviceSize);
}

void count_VkBindImageMemoryInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBindImageMemoryInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    uint64_t cgen_var_1;
    (void)cgen_var_1;
    *count += 1 * 8;
    *count += sizeof(VkDeviceSize);
}

void count_VkMemoryDedicatedRequirements(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryDedicatedRequirements* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkMemoryDedicatedAllocateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryDedicatedAllocateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    uint64_t cgen_var_1;
    (void)cgen_var_1;
    *count += 1 * 8;
}

void count_VkMemoryAllocateFlagsInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryAllocateFlagsInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkMemoryAllocateFlags);
    *count += sizeof(uint32_t);
}

void count_VkDeviceGroupCommandBufferBeginInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceGroupCommandBufferBeginInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
}

void count_VkDeviceGroupSubmitInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceGroupSubmitInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        *count += toCount->waitSemaphoreCount * sizeof(const uint32_t);
    }
    *count += sizeof(uint32_t);
    if (toCount)
    {
        *count += toCount->commandBufferCount * sizeof(const uint32_t);
    }
    *count += sizeof(uint32_t);
    if (toCount)
    {
        *count += toCount->signalSemaphoreCount * sizeof(const uint32_t);
    }
}

void count_VkDeviceGroupBindSparseInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceGroupBindSparseInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
}

void count_VkBindBufferMemoryDeviceGroupInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBindBufferMemoryDeviceGroupInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        *count += toCount->deviceIndexCount * sizeof(const uint32_t);
    }
}

void count_VkBindImageMemoryDeviceGroupInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBindImageMemoryDeviceGroupInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        *count += toCount->deviceIndexCount * sizeof(const uint32_t);
    }
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->splitInstanceBindRegionCount; ++i)
        {
            count_VkRect2D(featureBits, rootType, (const VkRect2D*)(toCount->pSplitInstanceBindRegions + i), count);
        }
    }
}

void count_VkPhysicalDeviceGroupProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceGroupProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    *count += VK_MAX_DEVICE_GROUP_SIZE * sizeof(VkPhysicalDevice);
    *count += sizeof(VkBool32);
}

void count_VkDeviceGroupDeviceCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceGroupDeviceCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    if (toCount->physicalDeviceCount)
    {
        *count += toCount->physicalDeviceCount * 8;
    }
}

void count_VkBufferMemoryRequirementsInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBufferMemoryRequirementsInfo2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
}

void count_VkImageMemoryRequirementsInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageMemoryRequirementsInfo2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
}

void count_VkImageSparseMemoryRequirementsInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageSparseMemoryRequirementsInfo2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
}

void count_VkMemoryRequirements2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryRequirements2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    count_VkMemoryRequirements(featureBits, rootType, (VkMemoryRequirements*)(&toCount->memoryRequirements), count);
}

void count_VkSparseImageMemoryRequirements2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSparseImageMemoryRequirements2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    count_VkSparseImageMemoryRequirements(featureBits, rootType, (VkSparseImageMemoryRequirements*)(&toCount->memoryRequirements), count);
}

void count_VkPhysicalDeviceFeatures2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceFeatures2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    count_VkPhysicalDeviceFeatures(featureBits, rootType, (VkPhysicalDeviceFeatures*)(&toCount->features), count);
}

void count_VkPhysicalDeviceProperties2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceProperties2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    count_VkPhysicalDeviceProperties(featureBits, rootType, (VkPhysicalDeviceProperties*)(&toCount->properties), count);
}

void count_VkFormatProperties2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkFormatProperties2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    count_VkFormatProperties(featureBits, rootType, (VkFormatProperties*)(&toCount->formatProperties), count);
}

void count_VkImageFormatProperties2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageFormatProperties2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    count_VkImageFormatProperties(featureBits, rootType, (VkImageFormatProperties*)(&toCount->imageFormatProperties), count);
}

void count_VkPhysicalDeviceImageFormatInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceImageFormatInfo2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkFormat);
    *count += sizeof(VkImageType);
    *count += sizeof(VkImageTiling);
    *count += sizeof(VkImageUsageFlags);
    *count += sizeof(VkImageCreateFlags);
}

void count_VkQueueFamilyProperties2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkQueueFamilyProperties2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    count_VkQueueFamilyProperties(featureBits, rootType, (VkQueueFamilyProperties*)(&toCount->queueFamilyProperties), count);
}

void count_VkPhysicalDeviceMemoryProperties2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceMemoryProperties2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    count_VkPhysicalDeviceMemoryProperties(featureBits, rootType, (VkPhysicalDeviceMemoryProperties*)(&toCount->memoryProperties), count);
}

void count_VkSparseImageFormatProperties2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSparseImageFormatProperties2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    count_VkSparseImageFormatProperties(featureBits, rootType, (VkSparseImageFormatProperties*)(&toCount->properties), count);
}

void count_VkPhysicalDeviceSparseImageFormatInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceSparseImageFormatInfo2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkFormat);
    *count += sizeof(VkImageType);
    *count += sizeof(VkSampleCountFlagBits);
    *count += sizeof(VkImageUsageFlags);
    *count += sizeof(VkImageTiling);
}

void count_VkImageViewUsageCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageViewUsageCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkImageUsageFlags);
}

void count_VkPhysicalDeviceProtectedMemoryFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceProtectedMemoryFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceProtectedMemoryProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceProtectedMemoryProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkDeviceQueueInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceQueueInfo2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkDeviceQueueCreateFlags);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
}

void count_VkProtectedSubmitInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkProtectedSubmitInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkBindImagePlaneMemoryInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBindImagePlaneMemoryInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkImageAspectFlagBits);
}

void count_VkImagePlaneMemoryRequirementsInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImagePlaneMemoryRequirementsInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkImageAspectFlagBits);
}

void count_VkExternalMemoryProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExternalMemoryProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkExternalMemoryFeatureFlags);
    *count += sizeof(VkExternalMemoryHandleTypeFlags);
    *count += sizeof(VkExternalMemoryHandleTypeFlags);
}

void count_VkPhysicalDeviceExternalImageFormatInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalImageFormatInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkExternalMemoryHandleTypeFlagBits);
}

void count_VkExternalImageFormatProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExternalImageFormatProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    count_VkExternalMemoryProperties(featureBits, rootType, (VkExternalMemoryProperties*)(&toCount->externalMemoryProperties), count);
}

void count_VkPhysicalDeviceExternalBufferInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalBufferInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBufferCreateFlags);
    *count += sizeof(VkBufferUsageFlags);
    *count += sizeof(VkExternalMemoryHandleTypeFlagBits);
}

void count_VkExternalBufferProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExternalBufferProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    count_VkExternalMemoryProperties(featureBits, rootType, (VkExternalMemoryProperties*)(&toCount->externalMemoryProperties), count);
}

void count_VkPhysicalDeviceIDProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceIDProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += VK_UUID_SIZE * sizeof(uint8_t);
    *count += VK_UUID_SIZE * sizeof(uint8_t);
    *count += VK_LUID_SIZE * sizeof(uint8_t);
    *count += sizeof(uint32_t);
    *count += sizeof(VkBool32);
}

void count_VkExternalMemoryImageCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExternalMemoryImageCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkExternalMemoryHandleTypeFlags);
}

void count_VkExternalMemoryBufferCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExternalMemoryBufferCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkExternalMemoryHandleTypeFlags);
}

void count_VkExportMemoryAllocateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExportMemoryAllocateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkExternalMemoryHandleTypeFlags);
}

void count_VkPhysicalDeviceExternalFenceInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalFenceInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkExternalFenceHandleTypeFlagBits);
}

void count_VkExternalFenceProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExternalFenceProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkExternalFenceHandleTypeFlags);
    *count += sizeof(VkExternalFenceHandleTypeFlags);
    *count += sizeof(VkExternalFenceFeatureFlags);
}

void count_VkExportFenceCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExportFenceCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkExternalFenceHandleTypeFlags);
}

void count_VkExportSemaphoreCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExportSemaphoreCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkExternalSemaphoreHandleTypeFlags);
}

void count_VkPhysicalDeviceExternalSemaphoreInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalSemaphoreInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkExternalSemaphoreHandleTypeFlagBits);
}

void count_VkExternalSemaphoreProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExternalSemaphoreProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkExternalSemaphoreHandleTypeFlags);
    *count += sizeof(VkExternalSemaphoreHandleTypeFlags);
    *count += sizeof(VkExternalSemaphoreFeatureFlags);
}

#endif
#ifdef VK_COMPUTE_VERSION_1_1
void count_VkPhysicalDeviceSubgroupProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceSubgroupProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    *count += sizeof(VkShaderStageFlags);
    *count += sizeof(VkSubgroupFeatureFlags);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDevice16BitStorageFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevice16BitStorageFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceVariablePointersFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVariablePointersFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkDescriptorUpdateTemplateEntry(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorUpdateTemplateEntry* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(VkDescriptorType);
    *count += 8;
    *count += 8;
}

void count_VkDescriptorUpdateTemplateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorUpdateTemplateCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkDescriptorUpdateTemplateCreateFlags);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->descriptorUpdateEntryCount; ++i)
        {
            count_VkDescriptorUpdateTemplateEntry(featureBits, rootType, (const VkDescriptorUpdateTemplateEntry*)(toCount->pDescriptorUpdateEntries + i), count);
        }
    }
    *count += sizeof(VkDescriptorUpdateTemplateType);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkPipelineBindPoint);
    uint64_t cgen_var_1;
    (void)cgen_var_1;
    *count += 1 * 8;
    *count += sizeof(uint32_t);
}

void count_VkPhysicalDeviceMaintenance3Properties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance3Properties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    *count += sizeof(VkDeviceSize);
}

void count_VkDescriptorSetLayoutSupport(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorSetLayoutSupport* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkSamplerYcbcrConversionCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSamplerYcbcrConversionCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkFormat);
    *count += sizeof(VkSamplerYcbcrModelConversion);
    *count += sizeof(VkSamplerYcbcrRange);
    count_VkComponentMapping(featureBits, rootType, (VkComponentMapping*)(&toCount->components), count);
    *count += sizeof(VkChromaLocation);
    *count += sizeof(VkChromaLocation);
    *count += sizeof(VkFilter);
    *count += sizeof(VkBool32);
}

void count_VkSamplerYcbcrConversionInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSamplerYcbcrConversionInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
}

void count_VkPhysicalDeviceSamplerYcbcrConversionFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceSamplerYcbcrConversionFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkSamplerYcbcrConversionImageFormatProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSamplerYcbcrConversionImageFormatProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
}

#endif
#ifdef VK_GRAPHICS_VERSION_1_1
void count_VkDeviceGroupRenderPassBeginInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceGroupRenderPassBeginInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->deviceRenderAreaCount; ++i)
        {
            count_VkRect2D(featureBits, rootType, (const VkRect2D*)(toCount->pDeviceRenderAreas + i), count);
        }
    }
}

void count_VkPhysicalDevicePointClippingProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevicePointClippingProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkPointClippingBehavior);
}

void count_VkInputAttachmentAspectReference(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkInputAttachmentAspectReference* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(VkImageAspectFlags);
}

void count_VkRenderPassInputAttachmentAspectCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderPassInputAttachmentAspectCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->aspectReferenceCount; ++i)
        {
            count_VkInputAttachmentAspectReference(featureBits, rootType, (const VkInputAttachmentAspectReference*)(toCount->pAspectReferences + i), count);
        }
    }
}

void count_VkPipelineTessellationDomainOriginStateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineTessellationDomainOriginStateCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkTessellationDomainOrigin);
}

void count_VkRenderPassMultiviewCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderPassMultiviewCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        *count += toCount->subpassCount * sizeof(const uint32_t);
    }
    *count += sizeof(uint32_t);
    if (toCount)
    {
        *count += toCount->dependencyCount * sizeof(const int32_t);
    }
    *count += sizeof(uint32_t);
    if (toCount)
    {
        *count += toCount->correlationMaskCount * sizeof(const uint32_t);
    }
}

void count_VkPhysicalDeviceMultiviewFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceMultiviewFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceMultiviewProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceMultiviewProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
}

void count_VkPhysicalDeviceShaderDrawParametersFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderDrawParametersFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

#endif
#ifdef VK_BASE_VERSION_1_2
void count_VkPhysicalDeviceVulkan11Features(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan11Features* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceVulkan11Properties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan11Properties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += VK_UUID_SIZE * sizeof(uint8_t);
    *count += VK_UUID_SIZE * sizeof(uint8_t);
    *count += VK_LUID_SIZE * sizeof(uint8_t);
    *count += sizeof(uint32_t);
    *count += sizeof(VkBool32);
    *count += sizeof(uint32_t);
    *count += sizeof(VkShaderStageFlags);
    *count += sizeof(VkSubgroupFeatureFlags);
    *count += sizeof(VkBool32);
    *count += sizeof(VkPointClippingBehavior);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(VkBool32);
    *count += sizeof(uint32_t);
    *count += sizeof(VkDeviceSize);
}

void count_VkPhysicalDeviceVulkan12Features(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan12Features* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkConformanceVersion(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkConformanceVersion* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(uint8_t);
    *count += sizeof(uint8_t);
    *count += sizeof(uint8_t);
    *count += sizeof(uint8_t);
}

void count_VkPhysicalDeviceVulkan12Properties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan12Properties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkDriverId);
    *count += VK_MAX_DRIVER_NAME_SIZE * sizeof(char);
    *count += VK_MAX_DRIVER_INFO_SIZE * sizeof(char);
    count_VkConformanceVersion(featureBits, rootType, (VkConformanceVersion*)(&toCount->conformanceVersion), count);
    *count += sizeof(VkShaderFloatControlsIndependence);
    *count += sizeof(VkShaderFloatControlsIndependence);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(uint32_t);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(VkResolveModeFlags);
    *count += sizeof(VkResolveModeFlags);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(uint64_t);
    *count += sizeof(VkSampleCountFlags);
}

void count_VkImageFormatListCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageFormatListCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        *count += toCount->viewFormatCount * sizeof(const VkFormat);
    }
}

void count_VkPhysicalDeviceDriverProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceDriverProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkDriverId);
    *count += VK_MAX_DRIVER_NAME_SIZE * sizeof(char);
    *count += VK_MAX_DRIVER_INFO_SIZE * sizeof(char);
    count_VkConformanceVersion(featureBits, rootType, (VkConformanceVersion*)(&toCount->conformanceVersion), count);
}

void count_VkPhysicalDeviceVulkanMemoryModelFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkanMemoryModelFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceHostQueryResetFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceHostQueryResetFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceTimelineSemaphoreFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceTimelineSemaphoreFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceTimelineSemaphoreProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceTimelineSemaphoreProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint64_t);
}

void count_VkSemaphoreTypeCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSemaphoreTypeCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkSemaphoreType);
    *count += sizeof(uint64_t);
}

void count_VkTimelineSemaphoreSubmitInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkTimelineSemaphoreSubmitInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pWaitSemaphoreValues)
    {
        if (toCount)
        {
            *count += toCount->waitSemaphoreValueCount * sizeof(const uint64_t);
        }
    }
    *count += sizeof(uint32_t);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pSignalSemaphoreValues)
    {
        if (toCount)
        {
            *count += toCount->signalSemaphoreValueCount * sizeof(const uint64_t);
        }
    }
}

void count_VkSemaphoreWaitInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSemaphoreWaitInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkSemaphoreWaitFlags);
    *count += sizeof(uint32_t);
    if (toCount->semaphoreCount)
    {
        *count += toCount->semaphoreCount * 8;
    }
    if (toCount)
    {
        *count += toCount->semaphoreCount * sizeof(const uint64_t);
    }
}

void count_VkSemaphoreSignalInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSemaphoreSignalInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(uint64_t);
}

void count_VkPhysicalDeviceBufferDeviceAddressFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceBufferDeviceAddressFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkBufferDeviceAddressInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBufferDeviceAddressInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
}

void count_VkBufferOpaqueCaptureAddressCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBufferOpaqueCaptureAddressCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint64_t);
}

void count_VkMemoryOpaqueCaptureAddressAllocateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryOpaqueCaptureAddressAllocateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint64_t);
}

void count_VkDeviceMemoryOpaqueCaptureAddressInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceMemoryOpaqueCaptureAddressInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
}

#endif
#ifdef VK_COMPUTE_VERSION_1_2
void count_VkPhysicalDevice8BitStorageFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevice8BitStorageFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceShaderAtomicInt64Features(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderAtomicInt64Features* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceShaderFloat16Int8Features(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderFloat16Int8Features* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceFloatControlsProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceFloatControlsProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkShaderFloatControlsIndependence);
    *count += sizeof(VkShaderFloatControlsIndependence);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkDescriptorSetLayoutBindingFlagsCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorSetLayoutBindingFlagsCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pBindingFlags)
    {
        if (toCount)
        {
            *count += toCount->bindingCount * sizeof(const VkDescriptorBindingFlags);
        }
    }
}

void count_VkPhysicalDeviceDescriptorIndexingFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceDescriptorIndexingFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceDescriptorIndexingProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceDescriptorIndexingProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
}

void count_VkDescriptorSetVariableDescriptorCountAllocateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorSetVariableDescriptorCountAllocateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        *count += toCount->descriptorSetCount * sizeof(const uint32_t);
    }
}

void count_VkDescriptorSetVariableDescriptorCountLayoutSupport(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorSetVariableDescriptorCountLayoutSupport* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
}

void count_VkPhysicalDeviceScalarBlockLayoutFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceScalarBlockLayoutFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkSamplerReductionModeCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSamplerReductionModeCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkSamplerReductionMode);
}

void count_VkPhysicalDeviceSamplerFilterMinmaxProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceSamplerFilterMinmaxProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceUniformBufferStandardLayoutFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

#endif
#ifdef VK_GRAPHICS_VERSION_1_2
void count_VkAttachmentDescription2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkAttachmentDescription2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkAttachmentDescriptionFlags);
    *count += sizeof(VkFormat);
    *count += sizeof(VkSampleCountFlagBits);
    *count += sizeof(VkAttachmentLoadOp);
    *count += sizeof(VkAttachmentStoreOp);
    *count += sizeof(VkAttachmentLoadOp);
    *count += sizeof(VkAttachmentStoreOp);
    *count += sizeof(VkImageLayout);
    *count += sizeof(VkImageLayout);
}

void count_VkAttachmentReference2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkAttachmentReference2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    *count += sizeof(VkImageLayout);
    *count += sizeof(VkImageAspectFlags);
}

void count_VkSubpassDescription2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSubpassDescription2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkSubpassDescriptionFlags);
    *count += sizeof(VkPipelineBindPoint);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->inputAttachmentCount; ++i)
        {
            count_VkAttachmentReference2(featureBits, rootType, (const VkAttachmentReference2*)(toCount->pInputAttachments + i), count);
        }
    }
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->colorAttachmentCount; ++i)
        {
            count_VkAttachmentReference2(featureBits, rootType, (const VkAttachmentReference2*)(toCount->pColorAttachments + i), count);
        }
    }
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pResolveAttachments)
    {
        if (toCount)
        {
            for (uint32_t i = 0; i < (uint32_t)toCount->colorAttachmentCount; ++i)
            {
                count_VkAttachmentReference2(featureBits, rootType, (const VkAttachmentReference2*)(toCount->pResolveAttachments + i), count);
            }
        }
    }
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pDepthStencilAttachment)
    {
        count_VkAttachmentReference2(featureBits, rootType, (const VkAttachmentReference2*)(toCount->pDepthStencilAttachment), count);
    }
    *count += sizeof(uint32_t);
    if (toCount)
    {
        *count += toCount->preserveAttachmentCount * sizeof(const uint32_t);
    }
}

void count_VkSubpassDependency2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSubpassDependency2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(VkPipelineStageFlags);
    *count += sizeof(VkPipelineStageFlags);
    *count += sizeof(VkAccessFlags);
    *count += sizeof(VkAccessFlags);
    *count += sizeof(VkDependencyFlags);
    *count += sizeof(int32_t);
}

void count_VkRenderPassCreateInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderPassCreateInfo2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkRenderPassCreateFlags);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->attachmentCount; ++i)
        {
            count_VkAttachmentDescription2(featureBits, rootType, (const VkAttachmentDescription2*)(toCount->pAttachments + i), count);
        }
    }
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->subpassCount; ++i)
        {
            count_VkSubpassDescription2(featureBits, rootType, (const VkSubpassDescription2*)(toCount->pSubpasses + i), count);
        }
    }
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->dependencyCount; ++i)
        {
            count_VkSubpassDependency2(featureBits, rootType, (const VkSubpassDependency2*)(toCount->pDependencies + i), count);
        }
    }
    *count += sizeof(uint32_t);
    if (toCount)
    {
        *count += toCount->correlatedViewMaskCount * sizeof(const uint32_t);
    }
}

void count_VkSubpassBeginInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSubpassBeginInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkSubpassContents);
}

void count_VkSubpassEndInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSubpassEndInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
}

void count_VkSubpassDescriptionDepthStencilResolve(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSubpassDescriptionDepthStencilResolve* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkResolveModeFlagBits);
    *count += sizeof(VkResolveModeFlagBits);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pDepthStencilResolveAttachment)
    {
        count_VkAttachmentReference2(featureBits, rootType, (const VkAttachmentReference2*)(toCount->pDepthStencilResolveAttachment), count);
    }
}

void count_VkPhysicalDeviceDepthStencilResolveProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceDepthStencilResolveProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkResolveModeFlags);
    *count += sizeof(VkResolveModeFlags);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkImageStencilUsageCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageStencilUsageCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkImageUsageFlags);
}

void count_VkPhysicalDeviceImagelessFramebufferFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceImagelessFramebufferFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkFramebufferAttachmentImageInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkFramebufferAttachmentImageInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkImageCreateFlags);
    *count += sizeof(VkImageUsageFlags);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        *count += toCount->viewFormatCount * sizeof(const VkFormat);
    }
}

void count_VkFramebufferAttachmentsCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkFramebufferAttachmentsCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->attachmentImageInfoCount; ++i)
        {
            count_VkFramebufferAttachmentImageInfo(featureBits, rootType, (const VkFramebufferAttachmentImageInfo*)(toCount->pAttachmentImageInfos + i), count);
        }
    }
}

void count_VkRenderPassAttachmentBeginInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderPassAttachmentBeginInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    if (toCount->attachmentCount)
    {
        *count += toCount->attachmentCount * 8;
    }
}

void count_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkAttachmentReferenceStencilLayout(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkAttachmentReferenceStencilLayout* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkImageLayout);
}

void count_VkAttachmentDescriptionStencilLayout(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkAttachmentDescriptionStencilLayout* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkImageLayout);
    *count += sizeof(VkImageLayout);
}

#endif
#ifdef VK_BASE_VERSION_1_3
void count_VkPhysicalDeviceVulkan13Features(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan13Features* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceVulkan13Properties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan13Properties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(VkShaderStageFlags);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkBool32);
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkBool32);
    *count += sizeof(VkDeviceSize);
}

void count_VkPhysicalDeviceToolProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceToolProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += VK_MAX_EXTENSION_NAME_SIZE * sizeof(char);
    *count += VK_MAX_EXTENSION_NAME_SIZE * sizeof(char);
    *count += sizeof(VkToolPurposeFlags);
    *count += VK_MAX_DESCRIPTION_SIZE * sizeof(char);
    *count += VK_MAX_EXTENSION_NAME_SIZE * sizeof(char);
}

void count_VkPhysicalDevicePrivateDataFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevicePrivateDataFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkDevicePrivateDataCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDevicePrivateDataCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
}

void count_VkPrivateDataSlotCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPrivateDataSlotCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkPrivateDataSlotCreateFlags);
}

void count_VkMemoryBarrier2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryBarrier2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkPipelineStageFlags2);
    *count += sizeof(VkAccessFlags2);
    *count += sizeof(VkPipelineStageFlags2);
    *count += sizeof(VkAccessFlags2);
}

void count_VkBufferMemoryBarrier2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBufferMemoryBarrier2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkPipelineStageFlags2);
    *count += sizeof(VkAccessFlags2);
    *count += sizeof(VkPipelineStageFlags2);
    *count += sizeof(VkAccessFlags2);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkDeviceSize);
}

void count_VkImageMemoryBarrier2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageMemoryBarrier2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkPipelineStageFlags2);
    *count += sizeof(VkAccessFlags2);
    *count += sizeof(VkPipelineStageFlags2);
    *count += sizeof(VkAccessFlags2);
    *count += sizeof(VkImageLayout);
    *count += sizeof(VkImageLayout);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    count_VkImageSubresourceRange(featureBits, rootType, (VkImageSubresourceRange*)(&toCount->subresourceRange), count);
}

void count_VkDependencyInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDependencyInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkDependencyFlags);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->memoryBarrierCount; ++i)
        {
            count_VkMemoryBarrier2(featureBits, rootType, (const VkMemoryBarrier2*)(toCount->pMemoryBarriers + i), count);
        }
    }
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->bufferMemoryBarrierCount; ++i)
        {
            count_VkBufferMemoryBarrier2(featureBits, rootType, (const VkBufferMemoryBarrier2*)(toCount->pBufferMemoryBarriers + i), count);
        }
    }
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->imageMemoryBarrierCount; ++i)
        {
            count_VkImageMemoryBarrier2(featureBits, rootType, (const VkImageMemoryBarrier2*)(toCount->pImageMemoryBarriers + i), count);
        }
    }
}

void count_VkSemaphoreSubmitInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSemaphoreSubmitInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(uint64_t);
    *count += sizeof(VkPipelineStageFlags2);
    *count += sizeof(uint32_t);
}

void count_VkCommandBufferSubmitInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCommandBufferSubmitInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(uint32_t);
}

void count_VkSubmitInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSubmitInfo2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkSubmitFlags);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->waitSemaphoreInfoCount; ++i)
        {
            count_VkSemaphoreSubmitInfo(featureBits, rootType, (const VkSemaphoreSubmitInfo*)(toCount->pWaitSemaphoreInfos + i), count);
        }
    }
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->commandBufferInfoCount; ++i)
        {
            count_VkCommandBufferSubmitInfo(featureBits, rootType, (const VkCommandBufferSubmitInfo*)(toCount->pCommandBufferInfos + i), count);
        }
    }
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->signalSemaphoreInfoCount; ++i)
        {
            count_VkSemaphoreSubmitInfo(featureBits, rootType, (const VkSemaphoreSubmitInfo*)(toCount->pSignalSemaphoreInfos + i), count);
        }
    }
}

void count_VkPhysicalDeviceSynchronization2Features(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceSynchronization2Features* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkBufferCopy2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBufferCopy2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkDeviceSize);
}

void count_VkCopyBufferInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCopyBufferInfo2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    uint64_t cgen_var_1;
    (void)cgen_var_1;
    *count += 1 * 8;
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->regionCount; ++i)
        {
            count_VkBufferCopy2(featureBits, rootType, (const VkBufferCopy2*)(toCount->pRegions + i), count);
        }
    }
}

void count_VkImageCopy2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageCopy2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    count_VkImageSubresourceLayers(featureBits, rootType, (VkImageSubresourceLayers*)(&toCount->srcSubresource), count);
    count_VkOffset3D(featureBits, rootType, (VkOffset3D*)(&toCount->srcOffset), count);
    count_VkImageSubresourceLayers(featureBits, rootType, (VkImageSubresourceLayers*)(&toCount->dstSubresource), count);
    count_VkOffset3D(featureBits, rootType, (VkOffset3D*)(&toCount->dstOffset), count);
    count_VkExtent3D(featureBits, rootType, (VkExtent3D*)(&toCount->extent), count);
}

void count_VkCopyImageInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCopyImageInfo2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkImageLayout);
    uint64_t cgen_var_1;
    (void)cgen_var_1;
    *count += 1 * 8;
    *count += sizeof(VkImageLayout);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->regionCount; ++i)
        {
            count_VkImageCopy2(featureBits, rootType, (const VkImageCopy2*)(toCount->pRegions + i), count);
        }
    }
}

void count_VkBufferImageCopy2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBufferImageCopy2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkDeviceSize);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    count_VkImageSubresourceLayers(featureBits, rootType, (VkImageSubresourceLayers*)(&toCount->imageSubresource), count);
    count_VkOffset3D(featureBits, rootType, (VkOffset3D*)(&toCount->imageOffset), count);
    count_VkExtent3D(featureBits, rootType, (VkExtent3D*)(&toCount->imageExtent), count);
}

void count_VkCopyBufferToImageInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCopyBufferToImageInfo2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    uint64_t cgen_var_1;
    (void)cgen_var_1;
    *count += 1 * 8;
    *count += sizeof(VkImageLayout);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->regionCount; ++i)
        {
            count_VkBufferImageCopy2(featureBits, rootType, (const VkBufferImageCopy2*)(toCount->pRegions + i), count);
        }
    }
}

void count_VkCopyImageToBufferInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCopyImageToBufferInfo2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkImageLayout);
    uint64_t cgen_var_1;
    (void)cgen_var_1;
    *count += 1 * 8;
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->regionCount; ++i)
        {
            count_VkBufferImageCopy2(featureBits, rootType, (const VkBufferImageCopy2*)(toCount->pRegions + i), count);
        }
    }
}

void count_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceTextureCompressionASTCHDRFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkFormatProperties3(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkFormatProperties3* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkFormatFeatureFlags2);
    *count += sizeof(VkFormatFeatureFlags2);
    *count += sizeof(VkFormatFeatureFlags2);
}

void count_VkPhysicalDeviceMaintenance4Features(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance4Features* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceMaintenance4Properties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance4Properties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkDeviceSize);
}

void count_VkDeviceBufferMemoryRequirements(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceBufferMemoryRequirements* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    count_VkBufferCreateInfo(featureBits, rootType, (const VkBufferCreateInfo*)(toCount->pCreateInfo), count);
}

void count_VkDeviceImageMemoryRequirements(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceImageMemoryRequirements* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    count_VkImageCreateInfo(featureBits, rootType, (const VkImageCreateInfo*)(toCount->pCreateInfo), count);
    *count += sizeof(VkImageAspectFlagBits);
}

#endif
#ifdef VK_COMPUTE_VERSION_1_3
void count_VkPipelineCreationFeedback(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineCreationFeedback* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkPipelineCreationFeedbackFlags);
    *count += sizeof(uint64_t);
}

void count_VkPipelineCreationFeedbackCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineCreationFeedbackCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    count_VkPipelineCreationFeedback(featureBits, rootType, (VkPipelineCreationFeedback*)(toCount->pPipelineCreationFeedback), count);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->pipelineStageCreationFeedbackCount; ++i)
        {
            count_VkPipelineCreationFeedback(featureBits, rootType, (VkPipelineCreationFeedback*)(toCount->pPipelineStageCreationFeedbacks + i), count);
        }
    }
}

void count_VkPhysicalDeviceShaderTerminateInvocationFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderTerminateInvocationFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDevicePipelineCreationCacheControlFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineCreationCacheControlFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceImageRobustnessFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceImageRobustnessFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceSubgroupSizeControlFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceSubgroupSizeControlFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceSubgroupSizeControlProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceSubgroupSizeControlProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(VkShaderStageFlags);
}

void count_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineShaderStageRequiredSubgroupSizeCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
}

void count_VkPhysicalDeviceInlineUniformBlockFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceInlineUniformBlockFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceInlineUniformBlockProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceInlineUniformBlockProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
}

void count_VkWriteDescriptorSetInlineUniformBlock(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkWriteDescriptorSetInlineUniformBlock* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        *count += toCount->dataSize * sizeof(const uint8_t);
    }
}

void count_VkDescriptorPoolInlineUniformBlockCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorPoolInlineUniformBlockCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
}

void count_VkPhysicalDeviceShaderIntegerDotProductFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderIntegerDotProductFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceShaderIntegerDotProductProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderIntegerDotProductProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceTexelBufferAlignmentProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceTexelBufferAlignmentProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkBool32);
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkBool32);
}

#endif
#ifdef VK_GRAPHICS_VERSION_1_3
void count_VkImageBlit2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageBlit2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    count_VkImageSubresourceLayers(featureBits, rootType, (VkImageSubresourceLayers*)(&toCount->srcSubresource), count);
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        count_VkOffset3D(featureBits, rootType, (VkOffset3D*)(toCount->srcOffsets + i), count);
    }
    count_VkImageSubresourceLayers(featureBits, rootType, (VkImageSubresourceLayers*)(&toCount->dstSubresource), count);
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        count_VkOffset3D(featureBits, rootType, (VkOffset3D*)(toCount->dstOffsets + i), count);
    }
}

void count_VkBlitImageInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBlitImageInfo2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkImageLayout);
    uint64_t cgen_var_1;
    (void)cgen_var_1;
    *count += 1 * 8;
    *count += sizeof(VkImageLayout);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->regionCount; ++i)
        {
            count_VkImageBlit2(featureBits, rootType, (const VkImageBlit2*)(toCount->pRegions + i), count);
        }
    }
    *count += sizeof(VkFilter);
}

void count_VkImageResolve2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageResolve2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    count_VkImageSubresourceLayers(featureBits, rootType, (VkImageSubresourceLayers*)(&toCount->srcSubresource), count);
    count_VkOffset3D(featureBits, rootType, (VkOffset3D*)(&toCount->srcOffset), count);
    count_VkImageSubresourceLayers(featureBits, rootType, (VkImageSubresourceLayers*)(&toCount->dstSubresource), count);
    count_VkOffset3D(featureBits, rootType, (VkOffset3D*)(&toCount->dstOffset), count);
    count_VkExtent3D(featureBits, rootType, (VkExtent3D*)(&toCount->extent), count);
}

void count_VkResolveImageInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkResolveImageInfo2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkImageLayout);
    uint64_t cgen_var_1;
    (void)cgen_var_1;
    *count += 1 * 8;
    *count += sizeof(VkImageLayout);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->regionCount; ++i)
        {
            count_VkImageResolve2(featureBits, rootType, (const VkImageResolve2*)(toCount->pRegions + i), count);
        }
    }
}

void count_VkRenderingAttachmentInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderingAttachmentInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkImageLayout);
    *count += sizeof(VkResolveModeFlagBits);
    uint64_t cgen_var_1;
    (void)cgen_var_1;
    *count += 1 * 8;
    *count += sizeof(VkImageLayout);
    *count += sizeof(VkAttachmentLoadOp);
    *count += sizeof(VkAttachmentStoreOp);
    count_VkClearValue(featureBits, rootType, (VkClearValue*)(&toCount->clearValue), count);
}

void count_VkRenderingInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderingInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkRenderingFlags);
    count_VkRect2D(featureBits, rootType, (VkRect2D*)(&toCount->renderArea), count);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->colorAttachmentCount; ++i)
        {
            count_VkRenderingAttachmentInfo(featureBits, rootType, (const VkRenderingAttachmentInfo*)(toCount->pColorAttachments + i), count);
        }
    }
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pDepthAttachment)
    {
        count_VkRenderingAttachmentInfo(featureBits, rootType, (const VkRenderingAttachmentInfo*)(toCount->pDepthAttachment), count);
    }
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pStencilAttachment)
    {
        count_VkRenderingAttachmentInfo(featureBits, rootType, (const VkRenderingAttachmentInfo*)(toCount->pStencilAttachment), count);
    }
}

void count_VkPipelineRenderingCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineRenderingCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pColorAttachmentFormats)
    {
        if (toCount)
        {
            *count += toCount->colorAttachmentCount * sizeof(const VkFormat);
        }
    }
    *count += sizeof(VkFormat);
    *count += sizeof(VkFormat);
}

void count_VkPhysicalDeviceDynamicRenderingFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceDynamicRenderingFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkCommandBufferInheritanceRenderingInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCommandBufferInheritanceRenderingInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkRenderingFlags);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        *count += toCount->colorAttachmentCount * sizeof(const VkFormat);
    }
    *count += sizeof(VkFormat);
    *count += sizeof(VkFormat);
    *count += sizeof(VkSampleCountFlagBits);
}

#endif
#ifdef VK_BASE_VERSION_1_4
void count_VkPhysicalDeviceVulkan14Features(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan14Features* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceVulkan14Properties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan14Properties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(VkBool32);
    *count += sizeof(uint32_t);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(uint32_t);
    *count += sizeof(VkBool32);
    *count += sizeof(VkPipelineRobustnessBufferBehavior);
    *count += sizeof(VkPipelineRobustnessBufferBehavior);
    *count += sizeof(VkPipelineRobustnessBufferBehavior);
    *count += sizeof(VkPipelineRobustnessImageBehavior);
    *count += sizeof(uint32_t);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pCopySrcLayouts)
    {
        if (toCount)
        {
            *count += toCount->copySrcLayoutCount * sizeof(VkImageLayout);
        }
    }
    *count += sizeof(uint32_t);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pCopyDstLayouts)
    {
        if (toCount)
        {
            *count += toCount->copyDstLayoutCount * sizeof(VkImageLayout);
        }
    }
    *count += VK_UUID_SIZE * sizeof(uint8_t);
    *count += sizeof(VkBool32);
}

void count_VkDeviceQueueGlobalPriorityCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceQueueGlobalPriorityCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkQueueGlobalPriority);
}

void count_VkPhysicalDeviceGlobalPriorityQueryFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceGlobalPriorityQueryFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkQueueFamilyGlobalPriorityProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkQueueFamilyGlobalPriorityProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    *count += VK_MAX_GLOBAL_PRIORITY_SIZE * sizeof(VkQueueGlobalPriority);
}

void count_VkPhysicalDeviceIndexTypeUint8Features(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceIndexTypeUint8Features* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkMemoryMapInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryMapInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkMemoryMapFlags);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkDeviceSize);
}

void count_VkMemoryUnmapInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryUnmapInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkMemoryUnmapFlags);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
}

void count_VkPhysicalDeviceMaintenance5Features(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance5Features* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceMaintenance5Properties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance5Properties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkImageSubresource2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageSubresource2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    count_VkImageSubresource(featureBits, rootType, (VkImageSubresource*)(&toCount->imageSubresource), count);
}

void count_VkDeviceImageSubresourceInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceImageSubresourceInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    count_VkImageCreateInfo(featureBits, rootType, (const VkImageCreateInfo*)(toCount->pCreateInfo), count);
    count_VkImageSubresource2(featureBits, rootType, (const VkImageSubresource2*)(toCount->pSubresource), count);
}

void count_VkSubresourceLayout2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSubresourceLayout2* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    count_VkSubresourceLayout(featureBits, rootType, (VkSubresourceLayout*)(&toCount->subresourceLayout), count);
}

void count_VkBufferUsageFlags2CreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBufferUsageFlags2CreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBufferUsageFlags2);
}

void count_VkPhysicalDeviceMaintenance6Features(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance6Features* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceMaintenance6Properties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance6Properties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(uint32_t);
    *count += sizeof(VkBool32);
}

void count_VkBindMemoryStatus(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBindMemoryStatus* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkResult);
}

void count_VkPhysicalDeviceHostImageCopyFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceHostImageCopyFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceHostImageCopyProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceHostImageCopyProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pCopySrcLayouts)
    {
        if (toCount)
        {
            *count += toCount->copySrcLayoutCount * sizeof(VkImageLayout);
        }
    }
    *count += sizeof(uint32_t);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pCopyDstLayouts)
    {
        if (toCount)
        {
            *count += toCount->copyDstLayoutCount * sizeof(VkImageLayout);
        }
    }
    *count += VK_UUID_SIZE * sizeof(uint8_t);
    *count += sizeof(VkBool32);
}

void count_VkMemoryToImageCopy(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryToImageCopy* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(const uint8_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    count_VkImageSubresourceLayers(featureBits, rootType, (VkImageSubresourceLayers*)(&toCount->imageSubresource), count);
    count_VkOffset3D(featureBits, rootType, (VkOffset3D*)(&toCount->imageOffset), count);
    count_VkExtent3D(featureBits, rootType, (VkExtent3D*)(&toCount->imageExtent), count);
}

void count_VkImageToMemoryCopy(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageToMemoryCopy* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint8_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    count_VkImageSubresourceLayers(featureBits, rootType, (VkImageSubresourceLayers*)(&toCount->imageSubresource), count);
    count_VkOffset3D(featureBits, rootType, (VkOffset3D*)(&toCount->imageOffset), count);
    count_VkExtent3D(featureBits, rootType, (VkExtent3D*)(&toCount->imageExtent), count);
}

void count_VkCopyMemoryToImageInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCopyMemoryToImageInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkHostImageCopyFlags);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkImageLayout);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->regionCount; ++i)
        {
            count_VkMemoryToImageCopy(featureBits, rootType, (const VkMemoryToImageCopy*)(toCount->pRegions + i), count);
        }
    }
}

void count_VkCopyImageToMemoryInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCopyImageToMemoryInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkHostImageCopyFlags);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkImageLayout);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->regionCount; ++i)
        {
            count_VkImageToMemoryCopy(featureBits, rootType, (const VkImageToMemoryCopy*)(toCount->pRegions + i), count);
        }
    }
}

void count_VkCopyImageToImageInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCopyImageToImageInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkHostImageCopyFlags);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkImageLayout);
    uint64_t cgen_var_1;
    (void)cgen_var_1;
    *count += 1 * 8;
    *count += sizeof(VkImageLayout);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->regionCount; ++i)
        {
            count_VkImageCopy2(featureBits, rootType, (const VkImageCopy2*)(toCount->pRegions + i), count);
        }
    }
}

void count_VkHostImageLayoutTransitionInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkHostImageLayoutTransitionInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkImageLayout);
    *count += sizeof(VkImageLayout);
    count_VkImageSubresourceRange(featureBits, rootType, (VkImageSubresourceRange*)(&toCount->subresourceRange), count);
}

void count_VkSubresourceHostMemcpySize(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSubresourceHostMemcpySize* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkDeviceSize);
}

void count_VkHostImageCopyDevicePerformanceQuery(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkHostImageCopyDevicePerformanceQuery* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

#endif
#ifdef VK_COMPUTE_VERSION_1_4
void count_VkPhysicalDeviceShaderSubgroupRotateFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderSubgroupRotateFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceShaderFloatControls2Features(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderFloatControls2Features* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceShaderExpectAssumeFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderExpectAssumeFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkPipelineCreateFlags2CreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineCreateFlags2CreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkPipelineCreateFlags2);
}

void count_VkPhysicalDevicePushDescriptorProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevicePushDescriptorProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
}

void count_VkBindDescriptorSetsInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBindDescriptorSetsInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkShaderStageFlags);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    if (toCount->descriptorSetCount)
    {
        *count += toCount->descriptorSetCount * 8;
    }
    *count += sizeof(uint32_t);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pDynamicOffsets)
    {
        if (toCount)
        {
            *count += toCount->dynamicOffsetCount * sizeof(const uint32_t);
        }
    }
}

void count_VkPushConstantsInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPushConstantsInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkShaderStageFlags);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        *count += toCount->size * sizeof(const uint8_t);
    }
}

void count_VkPushDescriptorSetInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPushDescriptorSetInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkShaderStageFlags);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->descriptorWriteCount; ++i)
        {
            count_VkWriteDescriptorSet(featureBits, rootType, (const VkWriteDescriptorSet*)(toCount->pDescriptorWrites + i), count);
        }
    }
}

void count_VkPushDescriptorSetWithTemplateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPushDescriptorSetWithTemplateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    uint64_t cgen_var_1;
    (void)cgen_var_1;
    *count += 1 * 8;
    *count += sizeof(uint32_t);
    *count += sizeof(const uint8_t);
}

void count_VkPhysicalDevicePipelineProtectedAccessFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineProtectedAccessFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDevicePipelineRobustnessFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineRobustnessFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDevicePipelineRobustnessProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineRobustnessProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkPipelineRobustnessBufferBehavior);
    *count += sizeof(VkPipelineRobustnessBufferBehavior);
    *count += sizeof(VkPipelineRobustnessBufferBehavior);
    *count += sizeof(VkPipelineRobustnessImageBehavior);
}

void count_VkPipelineRobustnessCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineRobustnessCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkPipelineRobustnessBufferBehavior);
    *count += sizeof(VkPipelineRobustnessBufferBehavior);
    *count += sizeof(VkPipelineRobustnessBufferBehavior);
    *count += sizeof(VkPipelineRobustnessImageBehavior);
}

#endif
#ifdef VK_GRAPHICS_VERSION_1_4
void count_VkPhysicalDeviceLineRasterizationFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceLineRasterizationFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceLineRasterizationProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceLineRasterizationProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
}

void count_VkPipelineRasterizationLineStateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineRasterizationLineStateCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkLineRasterizationMode);
    *count += sizeof(VkBool32);
    *count += sizeof(uint32_t);
    *count += sizeof(uint16_t);
}

void count_VkPhysicalDeviceVertexAttributeDivisorProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVertexAttributeDivisorProperties* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    *count += sizeof(VkBool32);
}

void count_VkVertexInputBindingDivisorDescription(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkVertexInputBindingDivisorDescription* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
}

void count_VkPipelineVertexInputDivisorStateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineVertexInputDivisorStateCreateInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->vertexBindingDivisorCount; ++i)
        {
            count_VkVertexInputBindingDivisorDescription(featureBits, rootType, (const VkVertexInputBindingDivisorDescription*)(toCount->pVertexBindingDivisors + i), count);
        }
    }
}

void count_VkPhysicalDeviceVertexAttributeDivisorFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVertexAttributeDivisorFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkRenderingAreaInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderingAreaInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pColorAttachmentFormats)
    {
        if (toCount)
        {
            *count += toCount->colorAttachmentCount * sizeof(const VkFormat);
        }
    }
    *count += sizeof(VkFormat);
    *count += sizeof(VkFormat);
}

void count_VkPhysicalDeviceDynamicRenderingLocalReadFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceDynamicRenderingLocalReadFeatures* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkRenderingAttachmentLocationInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderingAttachmentLocationInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pColorAttachmentLocations)
    {
        if (toCount)
        {
            *count += toCount->colorAttachmentCount * sizeof(const uint32_t);
        }
    }
}

void count_VkRenderingInputAttachmentIndexInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderingInputAttachmentIndexInfo* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pColorAttachmentInputIndices)
    {
        if (toCount)
        {
            *count += toCount->colorAttachmentCount * sizeof(const uint32_t);
        }
    }
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pDepthInputAttachmentIndex)
    {
        *count += sizeof(const uint32_t);
    }
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pStencilInputAttachmentIndex)
    {
        *count += sizeof(const uint32_t);
    }
}

#endif
#ifdef VK_KHR_external_semaphore_fd
void count_VkImportSemaphoreFdInfoKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImportSemaphoreFdInfoKHR* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkSemaphoreImportFlags);
    *count += sizeof(VkExternalSemaphoreHandleTypeFlagBits);
    *count += sizeof(int);
}

void count_VkSemaphoreGetFdInfoKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSemaphoreGetFdInfoKHR* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkExternalSemaphoreHandleTypeFlagBits);
}

#endif
#ifdef VK_KHR_incremental_present
void count_VkRectLayerKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRectLayerKHR* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    count_VkOffset2D(featureBits, rootType, (VkOffset2D*)(&toCount->offset), count);
    count_VkExtent2D(featureBits, rootType, (VkExtent2D*)(&toCount->extent), count);
    *count += sizeof(uint32_t);
}

void count_VkPresentRegionKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPresentRegionKHR* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(uint32_t);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pRectangles)
    {
        if (toCount)
        {
            for (uint32_t i = 0; i < (uint32_t)toCount->rectangleCount; ++i)
            {
                count_VkRectLayerKHR(featureBits, rootType, (const VkRectLayerKHR*)(toCount->pRectangles + i), count);
            }
        }
    }
}

void count_VkPresentRegionsKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPresentRegionsKHR* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pRegions)
    {
        if (toCount)
        {
            for (uint32_t i = 0; i < (uint32_t)toCount->swapchainCount; ++i)
            {
                count_VkPresentRegionKHR(featureBits, rootType, (const VkPresentRegionKHR*)(toCount->pRegions + i), count);
            }
        }
    }
}

#endif
#ifdef VK_KHR_external_fence_fd
void count_VkImportFenceFdInfoKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImportFenceFdInfoKHR* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkFenceImportFlags);
    *count += sizeof(VkExternalFenceHandleTypeFlagBits);
    *count += sizeof(int);
}

void count_VkFenceGetFdInfoKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkFenceGetFdInfoKHR* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkExternalFenceHandleTypeFlagBits);
}

#endif
#ifdef VK_KHR_pipeline_executable_properties
void count_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkPipelineInfoKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineInfoKHR* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
}

void count_VkPipelineExecutablePropertiesKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineExecutablePropertiesKHR* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkShaderStageFlags);
    *count += VK_MAX_DESCRIPTION_SIZE * sizeof(char);
    *count += VK_MAX_DESCRIPTION_SIZE * sizeof(char);
    *count += sizeof(uint32_t);
}

void count_VkPipelineExecutableInfoKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineExecutableInfoKHR* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(uint32_t);
}

void count_VkPipelineExecutableStatisticValueKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineExecutableStatisticValueKHR* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkBool32);
}

void count_VkPipelineExecutableStatisticKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineExecutableStatisticKHR* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += VK_MAX_DESCRIPTION_SIZE * sizeof(char);
    *count += VK_MAX_DESCRIPTION_SIZE * sizeof(char);
    *count += sizeof(VkPipelineExecutableStatisticFormatKHR);
    count_VkPipelineExecutableStatisticValueKHR(featureBits, rootType, (VkPipelineExecutableStatisticValueKHR*)(&toCount->value), count);
}

void count_VkPipelineExecutableInternalRepresentationKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineExecutableInternalRepresentationKHR* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += VK_MAX_DESCRIPTION_SIZE * sizeof(char);
    *count += VK_MAX_DESCRIPTION_SIZE * sizeof(char);
    *count += sizeof(VkBool32);
    *count += 8;
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pData)
    {
        if (toCount)
        {
            *count += toCount->dataSize * sizeof(uint8_t);
        }
    }
}

#endif
#ifdef VK_ANDROID_native_buffer
void count_VkNativeBufferUsage2ANDROID(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkNativeBufferUsage2ANDROID* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(uint64_t);
    *count += sizeof(uint64_t);
}

void count_VkNativeBufferANDROID(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkNativeBufferANDROID* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->handle)
    {
        *count += sizeof(const uint32_t);
    }
    *count += sizeof(int);
    *count += sizeof(int);
    *count += sizeof(int);
    count_VkNativeBufferUsage2ANDROID(featureBits, rootType, (VkNativeBufferUsage2ANDROID*)(&toCount->usage2), count);
}

void count_VkSwapchainImageCreateInfoANDROID(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSwapchainImageCreateInfoANDROID* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkSwapchainImageUsageFlagsANDROID);
}

void count_VkPhysicalDevicePresentationPropertiesANDROID(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevicePresentationPropertiesANDROID* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_transform_feedback
void count_VkPhysicalDeviceTransformFeedbackFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceTransformFeedbackFeaturesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceTransformFeedbackPropertiesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceTransformFeedbackPropertiesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(VkDeviceSize);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkPipelineRasterizationStateStreamCreateInfoEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineRasterizationStateStreamCreateInfoEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkPipelineRasterizationStateStreamCreateFlagsEXT);
    *count += sizeof(uint32_t);
}

#endif
#ifdef VK_EXT_depth_clip_enable
void count_VkPhysicalDeviceDepthClipEnableFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceDepthClipEnableFeaturesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkPipelineRasterizationDepthClipStateCreateInfoEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineRasterizationDepthClipStateCreateInfoEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkPipelineRasterizationDepthClipStateCreateFlagsEXT);
    *count += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_blend_operation_advanced
void count_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkPipelineColorBlendAdvancedStateCreateInfoEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineColorBlendAdvancedStateCreateInfoEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBlendOverlapEXT);
}

#endif
#ifdef VK_EXT_image_drm_format_modifier
void count_VkDrmFormatModifierPropertiesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDrmFormatModifierPropertiesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(uint64_t);
    *count += sizeof(uint32_t);
    *count += sizeof(VkFormatFeatureFlags);
}

void count_VkDrmFormatModifierPropertiesListEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDrmFormatModifierPropertiesListEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pDrmFormatModifierProperties)
    {
        if (toCount)
        {
            for (uint32_t i = 0; i < (uint32_t)toCount->drmFormatModifierCount; ++i)
            {
                count_VkDrmFormatModifierPropertiesEXT(featureBits, rootType, (VkDrmFormatModifierPropertiesEXT*)(toCount->pDrmFormatModifierProperties + i), count);
            }
        }
    }
}

void count_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceImageDrmFormatModifierInfoEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint64_t);
    *count += sizeof(VkSharingMode);
    *count += sizeof(uint32_t);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pQueueFamilyIndices)
    {
        if (toCount)
        {
            *count += toCount->queueFamilyIndexCount * sizeof(const uint32_t);
        }
    }
}

void count_VkImageDrmFormatModifierListCreateInfoEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageDrmFormatModifierListCreateInfoEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        *count += toCount->drmFormatModifierCount * sizeof(const uint64_t);
    }
}

void count_VkImageDrmFormatModifierExplicitCreateInfoEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageDrmFormatModifierExplicitCreateInfoEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint64_t);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        for (uint32_t i = 0; i < (uint32_t)toCount->drmFormatModifierPlaneCount; ++i)
        {
            count_VkSubresourceLayout(featureBits, rootType, (const VkSubresourceLayout*)(toCount->pPlaneLayouts + i), count);
        }
    }
}

void count_VkImageDrmFormatModifierPropertiesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageDrmFormatModifierPropertiesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint64_t);
}

void count_VkDrmFormatModifierProperties2EXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDrmFormatModifierProperties2EXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(uint64_t);
    *count += sizeof(uint32_t);
    *count += sizeof(VkFormatFeatureFlags2);
}

void count_VkDrmFormatModifierPropertiesList2EXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDrmFormatModifierPropertiesList2EXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pDrmFormatModifierProperties)
    {
        if (toCount)
        {
            for (uint32_t i = 0; i < (uint32_t)toCount->drmFormatModifierCount; ++i)
            {
                count_VkDrmFormatModifierProperties2EXT(featureBits, rootType, (VkDrmFormatModifierProperties2EXT*)(toCount->pDrmFormatModifierProperties + i), count);
            }
        }
    }
}

#endif
#ifdef VK_EXT_vertex_attribute_divisor
void count_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
}

#endif
#ifdef VK_EXT_fragment_density_map
void count_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceFragmentDensityMapFeaturesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceFragmentDensityMapPropertiesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    count_VkExtent2D(featureBits, rootType, (VkExtent2D*)(&toCount->minFragmentDensityTexelSize), count);
    count_VkExtent2D(featureBits, rootType, (VkExtent2D*)(&toCount->maxFragmentDensityTexelSize), count);
    *count += sizeof(VkBool32);
}

void count_VkRenderPassFragmentDensityMapCreateInfoEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderPassFragmentDensityMapCreateInfoEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    count_VkAttachmentReference(featureBits, rootType, (VkAttachmentReference*)(&toCount->fragmentDensityMapAttachment), count);
}

void count_VkRenderingFragmentDensityMapAttachmentInfoEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderingFragmentDensityMapAttachmentInfoEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    uint64_t cgen_var_0;
    (void)cgen_var_0;
    *count += 1 * 8;
    *count += sizeof(VkImageLayout);
}

#endif
#ifdef VK_EXT_memory_budget
void count_VkPhysicalDeviceMemoryBudgetPropertiesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceMemoryBudgetPropertiesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += VK_MAX_MEMORY_HEAPS * sizeof(VkDeviceSize);
    *count += VK_MAX_MEMORY_HEAPS * sizeof(VkDeviceSize);
}

#endif
#ifdef VK_EXT_provoking_vertex
void count_VkPhysicalDeviceProvokingVertexFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceProvokingVertexFeaturesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceProvokingVertexPropertiesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceProvokingVertexPropertiesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineRasterizationProvokingVertexStateCreateInfoEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkProvokingVertexModeEXT);
}

#endif
#ifdef VK_EXT_extended_dynamic_state
void count_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_texel_buffer_alignment
void count_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_device_memory_report
void count_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceDeviceMemoryReportFeaturesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkDeviceMemoryReportCallbackDataEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceMemoryReportCallbackDataEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkDeviceMemoryReportFlagsEXT);
    *count += sizeof(VkDeviceMemoryReportEventTypeEXT);
    *count += sizeof(uint64_t);
    *count += sizeof(VkDeviceSize);
    *count += sizeof(VkObjectType);
    *count += sizeof(uint64_t);
    *count += sizeof(uint32_t);
}

void count_VkDeviceDeviceMemoryReportCreateInfoEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceDeviceMemoryReportCreateInfoEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkDeviceMemoryReportFlagsEXT);
    *count += 8;
    *count += sizeof(uint8_t);
}

#endif
#ifdef VK_EXT_custom_border_color
void count_VkSamplerCustomBorderColorCreateInfoEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSamplerCustomBorderColorCreateInfoEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    count_VkClearColorValue(featureBits, rootType, (VkClearColorValue*)(&toCount->customBorderColor), count);
    *count += sizeof(VkFormat);
}

void count_VkPhysicalDeviceCustomBorderColorPropertiesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceCustomBorderColorPropertiesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
}

void count_VkPhysicalDeviceCustomBorderColorFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceCustomBorderColorFeaturesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_graphics_pipeline_library
void count_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

void count_VkGraphicsPipelineLibraryCreateInfoEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkGraphicsPipelineLibraryCreateInfoEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkGraphicsPipelineLibraryFlagsEXT);
}

#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
void count_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_image_compression_control
void count_VkPhysicalDeviceImageCompressionControlFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceImageCompressionControlFeaturesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkImageCompressionControlEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageCompressionControlEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkImageCompressionFlagsEXT);
    *count += sizeof(uint32_t);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pFixedRateFlags)
    {
        if (toCount)
        {
            *count += toCount->compressionControlPlaneCount * sizeof(VkImageCompressionFixedRateFlagsEXT);
        }
    }
}

void count_VkImageCompressionPropertiesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageCompressionPropertiesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkImageCompressionFlagsEXT);
    *count += sizeof(VkImageCompressionFixedRateFlagsEXT);
}

#endif
#ifdef VK_EXT_4444_formats
void count_VkPhysicalDevice4444FormatsFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevice4444FormatsFeaturesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_primitive_topology_list_restart
void count_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_frame_boundary
void count_VkPhysicalDeviceFrameBoundaryFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceFrameBoundaryFeaturesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkFrameBoundaryEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkFrameBoundaryEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkFrameBoundaryFlagsEXT);
    *count += sizeof(uint64_t);
    *count += sizeof(uint32_t);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pImages)
    {
        if (toCount->imageCount)
        {
            *count += toCount->imageCount * 8;
        }
    }
    *count += sizeof(uint32_t);
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pBuffers)
    {
        if (toCount->bufferCount)
        {
            *count += toCount->bufferCount * 8;
        }
    }
    *count += sizeof(uint64_t);
    *count += 8;
    // WARNING PTR CHECK
    *count += 8;
    if (toCount->pTag)
    {
        if (toCount)
        {
            *count += toCount->tagSize * sizeof(const uint8_t);
        }
    }
}

#endif
#ifdef VK_EXT_extended_dynamic_state2
void count_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
    *count += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_color_write_enable
void count_VkPhysicalDeviceColorWriteEnableFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceColorWriteEnableFeaturesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

void count_VkPipelineColorWriteCreateInfoEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineColorWriteCreateInfoEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    if (toCount)
    {
        *count += toCount->attachmentCount * sizeof(const VkBool32);
    }
}

#endif
#ifdef VK_GOOGLE_gfxstream
void count_VkImportColorBufferGOOGLE(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImportColorBufferGOOGLE* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
}

void count_VkImportBufferGOOGLE(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImportBufferGOOGLE* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
}

void count_VkCreateBlobGOOGLE(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCreateBlobGOOGLE* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint32_t);
    *count += sizeof(uint32_t);
    *count += sizeof(uint64_t);
}

void count_VkDebugMetadataGuestProcessNameGOOGLE(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDebugMetadataGuestProcessNameGOOGLE* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    if (featureBits & VULKAN_STREAM_FEATURE_NULL_OPTIONAL_STRINGS_BIT)
    {
        // WARNING PTR CHECK
        *count += 8;
        if (toCount->pName)
        {
            *count += sizeof(uint32_t) + (toCount->pName ? strlen(toCount->pName) : 0);
        }
    }
    else
    {
        *count += sizeof(uint32_t) + (toCount->pName ? strlen(toCount->pName) : 0);
    }
}

void count_VkDebugMetadataGuestProcessIdGOOGLE(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDebugMetadataGuestProcessIdGOOGLE* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint64_t);
}

void count_VkDebugMetadataGuestThreadNameGOOGLE(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDebugMetadataGuestThreadNameGOOGLE* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    if (featureBits & VULKAN_STREAM_FEATURE_NULL_OPTIONAL_STRINGS_BIT)
    {
        // WARNING PTR CHECK
        *count += 8;
        if (toCount->pName)
        {
            *count += sizeof(uint32_t) + (toCount->pName ? strlen(toCount->pName) : 0);
        }
    }
    else
    {
        *count += sizeof(uint32_t) + (toCount->pName ? strlen(toCount->pName) : 0);
    }
}

void count_VkDebugMetadataGuestThreadIdGOOGLE(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDebugMetadataGuestThreadIdGOOGLE* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(uint64_t);
}

void count_VkDebugMetadataGOOGLE(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDebugMetadataGOOGLE* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
}

#endif
#ifdef VK_EXT_image_compression_control_swapchain
void count_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT* toCount,
    size_t* count)
{
    (void)featureBits;
    (void)rootType;
    (void)toCount;
    (void)count;
    *count += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = toCount->sType;
    }
    count_extension_struct(featureBits, rootType, toCount->pNext, count);
    *count += sizeof(VkBool32);
}

#endif
void count_extension_struct(
    uint32_t featureBits,
    VkStructureType rootType,
    const void* structExtension,
    size_t* count)
{
    VkInstanceCreateInfo* structAccess = (VkInstanceCreateInfo*)(structExtension);
    size_t currExtSize = goldfish_vk_extension_struct_size_with_stream_features(featureBits, rootType, structExtension);
    if (!currExtSize && structExtension)
    {
        // unknown struct extension; skip and call on its pNext field
        count_extension_struct(featureBits, rootType, (void*)structAccess->pNext, count);
        return;
    }
    else
    {
        // known or null extension struct
        *count += sizeof(uint32_t);
        if (!currExtSize)
        {
            // exit if this was a null extension struct (size == 0 in this branch)
            return;
        }
    }
    *count += sizeof(VkStructureType);
    if (!structExtension)
    {
        return;
    }
    uint32_t structType = (uint32_t)goldfish_vk_struct_type(structExtension);
    switch(structType)
    {
#ifdef VK_COMPUTE_VERSION_1_0
        case VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO:
        {
            count_VkShaderModuleCreateInfo(featureBits, rootType, reinterpret_cast<const VkShaderModuleCreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO:
        {
            count_VkPipelineLayoutCreateInfo(featureBits, rootType, reinterpret_cast<const VkPipelineLayoutCreateInfo*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_BASE_VERSION_1_1
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS:
        {
            count_VkMemoryDedicatedRequirements(featureBits, rootType, reinterpret_cast<const VkMemoryDedicatedRequirements*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO:
        {
            count_VkMemoryDedicatedAllocateInfo(featureBits, rootType, reinterpret_cast<const VkMemoryDedicatedAllocateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO:
        {
            count_VkMemoryAllocateFlagsInfo(featureBits, rootType, reinterpret_cast<const VkMemoryAllocateFlagsInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO:
        {
            count_VkDeviceGroupCommandBufferBeginInfo(featureBits, rootType, reinterpret_cast<const VkDeviceGroupCommandBufferBeginInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO:
        {
            count_VkDeviceGroupSubmitInfo(featureBits, rootType, reinterpret_cast<const VkDeviceGroupSubmitInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO:
        {
            count_VkDeviceGroupBindSparseInfo(featureBits, rootType, reinterpret_cast<const VkDeviceGroupBindSparseInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO:
        {
            count_VkBindBufferMemoryDeviceGroupInfo(featureBits, rootType, reinterpret_cast<const VkBindBufferMemoryDeviceGroupInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO:
        {
            count_VkBindImageMemoryDeviceGroupInfo(featureBits, rootType, reinterpret_cast<const VkBindImageMemoryDeviceGroupInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO:
        {
            count_VkDeviceGroupDeviceCreateInfo(featureBits, rootType, reinterpret_cast<const VkDeviceGroupDeviceCreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
        {
            count_VkPhysicalDeviceFeatures2(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceFeatures2*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO:
        {
            count_VkImageViewUsageCreateInfo(featureBits, rootType, reinterpret_cast<const VkImageViewUsageCreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
        {
            count_VkPhysicalDeviceProtectedMemoryFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceProtectedMemoryFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES:
        {
            count_VkPhysicalDeviceProtectedMemoryProperties(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceProtectedMemoryProperties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO:
        {
            count_VkProtectedSubmitInfo(featureBits, rootType, reinterpret_cast<const VkProtectedSubmitInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO:
        {
            count_VkBindImagePlaneMemoryInfo(featureBits, rootType, reinterpret_cast<const VkBindImagePlaneMemoryInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO:
        {
            count_VkImagePlaneMemoryRequirementsInfo(featureBits, rootType, reinterpret_cast<const VkImagePlaneMemoryRequirementsInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO:
        {
            count_VkPhysicalDeviceExternalImageFormatInfo(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceExternalImageFormatInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES:
        {
            count_VkExternalImageFormatProperties(featureBits, rootType, reinterpret_cast<const VkExternalImageFormatProperties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES:
        {
            count_VkPhysicalDeviceIDProperties(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceIDProperties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO:
        {
            count_VkExternalMemoryImageCreateInfo(featureBits, rootType, reinterpret_cast<const VkExternalMemoryImageCreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO:
        {
            count_VkExternalMemoryBufferCreateInfo(featureBits, rootType, reinterpret_cast<const VkExternalMemoryBufferCreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO:
        {
            count_VkExportMemoryAllocateInfo(featureBits, rootType, reinterpret_cast<const VkExportMemoryAllocateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO:
        {
            count_VkExportFenceCreateInfo(featureBits, rootType, reinterpret_cast<const VkExportFenceCreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO:
        {
            count_VkExportSemaphoreCreateInfo(featureBits, rootType, reinterpret_cast<const VkExportSemaphoreCreateInfo*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_COMPUTE_VERSION_1_1
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES:
        {
            count_VkPhysicalDeviceSubgroupProperties(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceSubgroupProperties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
        {
            count_VkPhysicalDevice16BitStorageFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDevice16BitStorageFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
        {
            count_VkPhysicalDeviceVariablePointersFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceVariablePointersFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES:
        {
            count_VkPhysicalDeviceMaintenance3Properties(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance3Properties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO:
        {
            count_VkSamplerYcbcrConversionInfo(featureBits, rootType, reinterpret_cast<const VkSamplerYcbcrConversionInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
        {
            count_VkPhysicalDeviceSamplerYcbcrConversionFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceSamplerYcbcrConversionFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES:
        {
            count_VkSamplerYcbcrConversionImageFormatProperties(featureBits, rootType, reinterpret_cast<const VkSamplerYcbcrConversionImageFormatProperties*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_GRAPHICS_VERSION_1_1
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO:
        {
            count_VkDeviceGroupRenderPassBeginInfo(featureBits, rootType, reinterpret_cast<const VkDeviceGroupRenderPassBeginInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES:
        {
            count_VkPhysicalDevicePointClippingProperties(featureBits, rootType, reinterpret_cast<const VkPhysicalDevicePointClippingProperties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO:
        {
            count_VkRenderPassInputAttachmentAspectCreateInfo(featureBits, rootType, reinterpret_cast<const VkRenderPassInputAttachmentAspectCreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO:
        {
            count_VkPipelineTessellationDomainOriginStateCreateInfo(featureBits, rootType, reinterpret_cast<const VkPipelineTessellationDomainOriginStateCreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO:
        {
            count_VkRenderPassMultiviewCreateInfo(featureBits, rootType, reinterpret_cast<const VkRenderPassMultiviewCreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
        {
            count_VkPhysicalDeviceMultiviewFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceMultiviewFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES:
        {
            count_VkPhysicalDeviceMultiviewProperties(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceMultiviewProperties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
        {
            count_VkPhysicalDeviceShaderDrawParametersFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceShaderDrawParametersFeatures*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_BASE_VERSION_1_2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
        {
            count_VkPhysicalDeviceVulkan11Features(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan11Features*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES:
        {
            count_VkPhysicalDeviceVulkan11Properties(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan11Properties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
        {
            count_VkPhysicalDeviceVulkan12Features(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan12Features*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES:
        {
            count_VkPhysicalDeviceVulkan12Properties(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan12Properties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO:
        {
            count_VkImageFormatListCreateInfo(featureBits, rootType, reinterpret_cast<const VkImageFormatListCreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES:
        {
            count_VkPhysicalDeviceDriverProperties(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceDriverProperties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
        {
            count_VkPhysicalDeviceVulkanMemoryModelFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceVulkanMemoryModelFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
        {
            count_VkPhysicalDeviceHostQueryResetFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceHostQueryResetFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
        {
            count_VkPhysicalDeviceTimelineSemaphoreFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceTimelineSemaphoreFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES:
        {
            count_VkPhysicalDeviceTimelineSemaphoreProperties(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceTimelineSemaphoreProperties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO:
        {
            count_VkSemaphoreTypeCreateInfo(featureBits, rootType, reinterpret_cast<const VkSemaphoreTypeCreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO:
        {
            count_VkTimelineSemaphoreSubmitInfo(featureBits, rootType, reinterpret_cast<const VkTimelineSemaphoreSubmitInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
        {
            count_VkPhysicalDeviceBufferDeviceAddressFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceBufferDeviceAddressFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO:
        {
            count_VkBufferOpaqueCaptureAddressCreateInfo(featureBits, rootType, reinterpret_cast<const VkBufferOpaqueCaptureAddressCreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO:
        {
            count_VkMemoryOpaqueCaptureAddressAllocateInfo(featureBits, rootType, reinterpret_cast<const VkMemoryOpaqueCaptureAddressAllocateInfo*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_COMPUTE_VERSION_1_2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
        {
            count_VkPhysicalDevice8BitStorageFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDevice8BitStorageFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
        {
            count_VkPhysicalDeviceShaderAtomicInt64Features(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceShaderAtomicInt64Features*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
        {
            count_VkPhysicalDeviceShaderFloat16Int8Features(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceShaderFloat16Int8Features*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES:
        {
            count_VkPhysicalDeviceFloatControlsProperties(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceFloatControlsProperties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO:
        {
            count_VkDescriptorSetLayoutBindingFlagsCreateInfo(featureBits, rootType, reinterpret_cast<const VkDescriptorSetLayoutBindingFlagsCreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
        {
            count_VkPhysicalDeviceDescriptorIndexingFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceDescriptorIndexingFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES:
        {
            count_VkPhysicalDeviceDescriptorIndexingProperties(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceDescriptorIndexingProperties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO:
        {
            count_VkDescriptorSetVariableDescriptorCountAllocateInfo(featureBits, rootType, reinterpret_cast<const VkDescriptorSetVariableDescriptorCountAllocateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT:
        {
            count_VkDescriptorSetVariableDescriptorCountLayoutSupport(featureBits, rootType, reinterpret_cast<const VkDescriptorSetVariableDescriptorCountLayoutSupport*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
        {
            count_VkPhysicalDeviceScalarBlockLayoutFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceScalarBlockLayoutFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO:
        {
            count_VkSamplerReductionModeCreateInfo(featureBits, rootType, reinterpret_cast<const VkSamplerReductionModeCreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES:
        {
            count_VkPhysicalDeviceSamplerFilterMinmaxProperties(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceSamplerFilterMinmaxProperties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
        {
            count_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceUniformBufferStandardLayoutFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
        {
            count_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_GRAPHICS_VERSION_1_2
        case VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE:
        {
            count_VkSubpassDescriptionDepthStencilResolve(featureBits, rootType, reinterpret_cast<const VkSubpassDescriptionDepthStencilResolve*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES:
        {
            count_VkPhysicalDeviceDepthStencilResolveProperties(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceDepthStencilResolveProperties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO:
        {
            count_VkImageStencilUsageCreateInfo(featureBits, rootType, reinterpret_cast<const VkImageStencilUsageCreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
        {
            count_VkPhysicalDeviceImagelessFramebufferFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceImagelessFramebufferFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO:
        {
            count_VkFramebufferAttachmentsCreateInfo(featureBits, rootType, reinterpret_cast<const VkFramebufferAttachmentsCreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO:
        {
            count_VkRenderPassAttachmentBeginInfo(featureBits, rootType, reinterpret_cast<const VkRenderPassAttachmentBeginInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
        {
            count_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT:
        {
            count_VkAttachmentReferenceStencilLayout(featureBits, rootType, reinterpret_cast<const VkAttachmentReferenceStencilLayout*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT:
        {
            count_VkAttachmentDescriptionStencilLayout(featureBits, rootType, reinterpret_cast<const VkAttachmentDescriptionStencilLayout*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_BASE_VERSION_1_3
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
        {
            count_VkPhysicalDeviceVulkan13Features(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan13Features*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES:
        {
            count_VkPhysicalDeviceVulkan13Properties(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan13Properties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
        {
            count_VkPhysicalDevicePrivateDataFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDevicePrivateDataFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO:
        {
            count_VkDevicePrivateDataCreateInfo(featureBits, rootType, reinterpret_cast<const VkDevicePrivateDataCreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_BARRIER_2:
        {
            count_VkMemoryBarrier2(featureBits, rootType, reinterpret_cast<const VkMemoryBarrier2*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
        {
            count_VkPhysicalDeviceSynchronization2Features(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceSynchronization2Features*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
        {
            count_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceTextureCompressionASTCHDRFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3:
        {
            count_VkFormatProperties3(featureBits, rootType, reinterpret_cast<const VkFormatProperties3*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
        {
            count_VkPhysicalDeviceMaintenance4Features(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance4Features*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES:
        {
            count_VkPhysicalDeviceMaintenance4Properties(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance4Properties*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_COMPUTE_VERSION_1_3
        case VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO:
        {
            count_VkPipelineCreationFeedbackCreateInfo(featureBits, rootType, reinterpret_cast<const VkPipelineCreationFeedbackCreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
        {
            count_VkPhysicalDeviceShaderTerminateInvocationFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceShaderTerminateInvocationFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
        {
            count_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
        {
            count_VkPhysicalDevicePipelineCreationCacheControlFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDevicePipelineCreationCacheControlFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
        {
            count_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
        {
            count_VkPhysicalDeviceImageRobustnessFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceImageRobustnessFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
        {
            count_VkPhysicalDeviceSubgroupSizeControlFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceSubgroupSizeControlFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES:
        {
            count_VkPhysicalDeviceSubgroupSizeControlProperties(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceSubgroupSizeControlProperties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO:
        {
            count_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(featureBits, rootType, reinterpret_cast<const VkPipelineShaderStageRequiredSubgroupSizeCreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
        {
            count_VkPhysicalDeviceInlineUniformBlockFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceInlineUniformBlockFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES:
        {
            count_VkPhysicalDeviceInlineUniformBlockProperties(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceInlineUniformBlockProperties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK:
        {
            count_VkWriteDescriptorSetInlineUniformBlock(featureBits, rootType, reinterpret_cast<const VkWriteDescriptorSetInlineUniformBlock*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO:
        {
            count_VkDescriptorPoolInlineUniformBlockCreateInfo(featureBits, rootType, reinterpret_cast<const VkDescriptorPoolInlineUniformBlockCreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
        {
            count_VkPhysicalDeviceShaderIntegerDotProductFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceShaderIntegerDotProductFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES:
        {
            count_VkPhysicalDeviceShaderIntegerDotProductProperties(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceShaderIntegerDotProductProperties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES:
        {
            count_VkPhysicalDeviceTexelBufferAlignmentProperties(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceTexelBufferAlignmentProperties*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_GRAPHICS_VERSION_1_3
        case VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO:
        {
            count_VkPipelineRenderingCreateInfo(featureBits, rootType, reinterpret_cast<const VkPipelineRenderingCreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
        {
            count_VkPhysicalDeviceDynamicRenderingFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceDynamicRenderingFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO:
        {
            count_VkCommandBufferInheritanceRenderingInfo(featureBits, rootType, reinterpret_cast<const VkCommandBufferInheritanceRenderingInfo*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_BASE_VERSION_1_4
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES:
        {
            count_VkPhysicalDeviceVulkan14Features(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan14Features*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_PROPERTIES:
        {
            count_VkPhysicalDeviceVulkan14Properties(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan14Properties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO:
        {
            count_VkDeviceQueueGlobalPriorityCreateInfo(featureBits, rootType, reinterpret_cast<const VkDeviceQueueGlobalPriorityCreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES:
        {
            count_VkPhysicalDeviceGlobalPriorityQueryFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceGlobalPriorityQueryFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES:
        {
            count_VkQueueFamilyGlobalPriorityProperties(featureBits, rootType, reinterpret_cast<const VkQueueFamilyGlobalPriorityProperties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES:
        {
            count_VkPhysicalDeviceIndexTypeUint8Features(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceIndexTypeUint8Features*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES:
        {
            count_VkPhysicalDeviceMaintenance5Features(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance5Features*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_PROPERTIES:
        {
            count_VkPhysicalDeviceMaintenance5Properties(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance5Properties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_BUFFER_USAGE_FLAGS_2_CREATE_INFO:
        {
            count_VkBufferUsageFlags2CreateInfo(featureBits, rootType, reinterpret_cast<const VkBufferUsageFlags2CreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES:
        {
            count_VkPhysicalDeviceMaintenance6Features(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance6Features*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_PROPERTIES:
        {
            count_VkPhysicalDeviceMaintenance6Properties(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance6Properties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_MEMORY_STATUS:
        {
            count_VkBindMemoryStatus(featureBits, rootType, reinterpret_cast<const VkBindMemoryStatus*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES:
        {
            count_VkPhysicalDeviceHostImageCopyFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceHostImageCopyFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_PROPERTIES:
        {
            count_VkPhysicalDeviceHostImageCopyProperties(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceHostImageCopyProperties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_SUBRESOURCE_HOST_MEMCPY_SIZE:
        {
            count_VkSubresourceHostMemcpySize(featureBits, rootType, reinterpret_cast<const VkSubresourceHostMemcpySize*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_HOST_IMAGE_COPY_DEVICE_PERFORMANCE_QUERY:
        {
            count_VkHostImageCopyDevicePerformanceQuery(featureBits, rootType, reinterpret_cast<const VkHostImageCopyDevicePerformanceQuery*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_COMPUTE_VERSION_1_4
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES:
        {
            count_VkPhysicalDeviceShaderSubgroupRotateFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceShaderSubgroupRotateFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES:
        {
            count_VkPhysicalDeviceShaderFloatControls2Features(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceShaderFloatControls2Features*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES:
        {
            count_VkPhysicalDeviceShaderExpectAssumeFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceShaderExpectAssumeFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_CREATE_FLAGS_2_CREATE_INFO:
        {
            count_VkPipelineCreateFlags2CreateInfo(featureBits, rootType, reinterpret_cast<const VkPipelineCreateFlags2CreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES:
        {
            count_VkPhysicalDevicePushDescriptorProperties(featureBits, rootType, reinterpret_cast<const VkPhysicalDevicePushDescriptorProperties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES:
        {
            count_VkPhysicalDevicePipelineProtectedAccessFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDevicePipelineProtectedAccessFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES:
        {
            count_VkPhysicalDevicePipelineRobustnessFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDevicePipelineRobustnessFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_PROPERTIES:
        {
            count_VkPhysicalDevicePipelineRobustnessProperties(featureBits, rootType, reinterpret_cast<const VkPhysicalDevicePipelineRobustnessProperties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_ROBUSTNESS_CREATE_INFO:
        {
            count_VkPipelineRobustnessCreateInfo(featureBits, rootType, reinterpret_cast<const VkPipelineRobustnessCreateInfo*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_GRAPHICS_VERSION_1_4
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES:
        {
            count_VkPhysicalDeviceLineRasterizationFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceLineRasterizationFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES:
        {
            count_VkPhysicalDeviceLineRasterizationProperties(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceLineRasterizationProperties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO:
        {
            count_VkPipelineRasterizationLineStateCreateInfo(featureBits, rootType, reinterpret_cast<const VkPipelineRasterizationLineStateCreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES:
        {
            count_VkPhysicalDeviceVertexAttributeDivisorProperties(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceVertexAttributeDivisorProperties*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO:
        {
            count_VkPipelineVertexInputDivisorStateCreateInfo(featureBits, rootType, reinterpret_cast<const VkPipelineVertexInputDivisorStateCreateInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES:
        {
            count_VkPhysicalDeviceVertexAttributeDivisorFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceVertexAttributeDivisorFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES:
        {
            count_VkPhysicalDeviceDynamicRenderingLocalReadFeatures(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceDynamicRenderingLocalReadFeatures*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_LOCATION_INFO:
        {
            count_VkRenderingAttachmentLocationInfo(featureBits, rootType, reinterpret_cast<const VkRenderingAttachmentLocationInfo*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_RENDERING_INPUT_ATTACHMENT_INDEX_INFO:
        {
            count_VkRenderingInputAttachmentIndexInfo(featureBits, rootType, reinterpret_cast<const VkRenderingInputAttachmentIndexInfo*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_KHR_incremental_present
        case VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR:
        {
            count_VkPresentRegionsKHR(featureBits, rootType, reinterpret_cast<const VkPresentRegionsKHR*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_KHR_pipeline_executable_properties
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR:
        {
            count_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(featureBits, rootType, reinterpret_cast<const VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_ANDROID_native_buffer
        case VK_STRUCTURE_TYPE_NATIVE_BUFFER_ANDROID:
        {
            count_VkNativeBufferANDROID(featureBits, rootType, reinterpret_cast<const VkNativeBufferANDROID*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_IMAGE_CREATE_INFO_ANDROID:
        {
            count_VkSwapchainImageCreateInfoANDROID(featureBits, rootType, reinterpret_cast<const VkSwapchainImageCreateInfoANDROID*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENTATION_PROPERTIES_ANDROID:
        {
            count_VkPhysicalDevicePresentationPropertiesANDROID(featureBits, rootType, reinterpret_cast<const VkPhysicalDevicePresentationPropertiesANDROID*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_EXT_transform_feedback
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
        {
            count_VkPhysicalDeviceTransformFeedbackFeaturesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceTransformFeedbackFeaturesEXT*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT:
        {
            count_VkPhysicalDeviceTransformFeedbackPropertiesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceTransformFeedbackPropertiesEXT*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT:
        {
            count_VkPipelineRasterizationStateStreamCreateInfoEXT(featureBits, rootType, reinterpret_cast<const VkPipelineRasterizationStateStreamCreateInfoEXT*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_EXT_depth_clip_enable
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
        {
            count_VkPhysicalDeviceDepthClipEnableFeaturesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceDepthClipEnableFeaturesEXT*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT:
        {
            count_VkPipelineRasterizationDepthClipStateCreateInfoEXT(featureBits, rootType, reinterpret_cast<const VkPipelineRasterizationDepthClipStateCreateInfoEXT*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_EXT_blend_operation_advanced
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT:
        {
            count_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT:
        {
            count_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT:
        {
            count_VkPipelineColorBlendAdvancedStateCreateInfoEXT(featureBits, rootType, reinterpret_cast<const VkPipelineColorBlendAdvancedStateCreateInfoEXT*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_EXT_image_drm_format_modifier
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT:
        {
            count_VkDrmFormatModifierPropertiesListEXT(featureBits, rootType, reinterpret_cast<const VkDrmFormatModifierPropertiesListEXT*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT:
        {
            count_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceImageDrmFormatModifierInfoEXT*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT:
        {
            count_VkImageDrmFormatModifierListCreateInfoEXT(featureBits, rootType, reinterpret_cast<const VkImageDrmFormatModifierListCreateInfoEXT*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT:
        {
            count_VkImageDrmFormatModifierExplicitCreateInfoEXT(featureBits, rootType, reinterpret_cast<const VkImageDrmFormatModifierExplicitCreateInfoEXT*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT:
        {
            count_VkDrmFormatModifierPropertiesList2EXT(featureBits, rootType, reinterpret_cast<const VkDrmFormatModifierPropertiesList2EXT*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_EXT_vertex_attribute_divisor
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT:
        {
            count_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_EXT_fragment_density_map
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT:
        {
            switch(rootType)
            {
                case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
                {
                    count_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceFragmentDensityMapFeaturesEXT*>(structExtension), count);
                    break;
                }
                case VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO:
                {
                    count_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceFragmentDensityMapFeaturesEXT*>(structExtension), count);
                    break;
                }
                case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO:
                {
                    count_VkImportColorBufferGOOGLE(featureBits, rootType, reinterpret_cast<const VkImportColorBufferGOOGLE*>(structExtension), count);
                    break;
                }
                default:
                {
                    count_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceFragmentDensityMapFeaturesEXT*>(structExtension), count);
                    break;
                }
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT:
        {
            switch(rootType)
            {
                case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2:
                {
                    count_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceFragmentDensityMapPropertiesEXT*>(structExtension), count);
                    break;
                }
                case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO:
                {
                    count_VkCreateBlobGOOGLE(featureBits, rootType, reinterpret_cast<const VkCreateBlobGOOGLE*>(structExtension), count);
                    break;
                }
                default:
                {
                    count_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceFragmentDensityMapPropertiesEXT*>(structExtension), count);
                    break;
                }
            }
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT:
        {
            switch(rootType)
            {
                case VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO:
                {
                    count_VkRenderPassFragmentDensityMapCreateInfoEXT(featureBits, rootType, reinterpret_cast<const VkRenderPassFragmentDensityMapCreateInfoEXT*>(structExtension), count);
                    break;
                }
                case VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2:
                {
                    count_VkRenderPassFragmentDensityMapCreateInfoEXT(featureBits, rootType, reinterpret_cast<const VkRenderPassFragmentDensityMapCreateInfoEXT*>(structExtension), count);
                    break;
                }
                case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO:
                {
                    count_VkImportBufferGOOGLE(featureBits, rootType, reinterpret_cast<const VkImportBufferGOOGLE*>(structExtension), count);
                    break;
                }
                default:
                {
                    count_VkRenderPassFragmentDensityMapCreateInfoEXT(featureBits, rootType, reinterpret_cast<const VkRenderPassFragmentDensityMapCreateInfoEXT*>(structExtension), count);
                    break;
                }
            }
            break;
        }
        case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT:
        {
            count_VkRenderingFragmentDensityMapAttachmentInfoEXT(featureBits, rootType, reinterpret_cast<const VkRenderingFragmentDensityMapAttachmentInfoEXT*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_EXT_memory_budget
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT:
        {
            count_VkPhysicalDeviceMemoryBudgetPropertiesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceMemoryBudgetPropertiesEXT*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_EXT_provoking_vertex
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
        {
            count_VkPhysicalDeviceProvokingVertexFeaturesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceProvokingVertexFeaturesEXT*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT:
        {
            count_VkPhysicalDeviceProvokingVertexPropertiesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceProvokingVertexPropertiesEXT*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT:
        {
            count_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(featureBits, rootType, reinterpret_cast<const VkPipelineRasterizationProvokingVertexStateCreateInfoEXT*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_EXT_extended_dynamic_state
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
        {
            count_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_EXT_texel_buffer_alignment
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
        {
            count_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_EXT_device_memory_report
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT:
        {
            count_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceDeviceMemoryReportFeaturesEXT*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT:
        {
            count_VkDeviceDeviceMemoryReportCreateInfoEXT(featureBits, rootType, reinterpret_cast<const VkDeviceDeviceMemoryReportCreateInfoEXT*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_EXT_custom_border_color
        case VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT:
        {
            count_VkSamplerCustomBorderColorCreateInfoEXT(featureBits, rootType, reinterpret_cast<const VkSamplerCustomBorderColorCreateInfoEXT*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT:
        {
            count_VkPhysicalDeviceCustomBorderColorPropertiesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceCustomBorderColorPropertiesEXT*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
        {
            count_VkPhysicalDeviceCustomBorderColorFeaturesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceCustomBorderColorFeaturesEXT*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_EXT_graphics_pipeline_library
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT:
        {
            count_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT:
        {
            count_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT:
        {
            count_VkGraphicsPipelineLibraryCreateInfoEXT(featureBits, rootType, reinterpret_cast<const VkGraphicsPipelineLibraryCreateInfoEXT*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
        {
            count_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_EXT_image_compression_control
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT:
        {
            count_VkPhysicalDeviceImageCompressionControlFeaturesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceImageCompressionControlFeaturesEXT*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT:
        {
            count_VkImageCompressionControlEXT(featureBits, rootType, reinterpret_cast<const VkImageCompressionControlEXT*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_PROPERTIES_EXT:
        {
            count_VkImageCompressionPropertiesEXT(featureBits, rootType, reinterpret_cast<const VkImageCompressionPropertiesEXT*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_EXT_4444_formats
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
        {
            count_VkPhysicalDevice4444FormatsFeaturesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDevice4444FormatsFeaturesEXT*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_EXT_primitive_topology_list_restart
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
        {
            count_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_EXT_frame_boundary
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAME_BOUNDARY_FEATURES_EXT:
        {
            count_VkPhysicalDeviceFrameBoundaryFeaturesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceFrameBoundaryFeaturesEXT*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_FRAME_BOUNDARY_EXT:
        {
            count_VkFrameBoundaryEXT(featureBits, rootType, reinterpret_cast<const VkFrameBoundaryEXT*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_EXT_extended_dynamic_state2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
        {
            count_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_EXT_color_write_enable
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
        {
            count_VkPhysicalDeviceColorWriteEnableFeaturesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceColorWriteEnableFeaturesEXT*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT:
        {
            count_VkPipelineColorWriteCreateInfoEXT(featureBits, rootType, reinterpret_cast<const VkPipelineColorWriteCreateInfoEXT*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_GOOGLE_gfxstream
        case VK_STRUCTURE_TYPE_IMPORT_COLOR_BUFFER_GOOGLE:
        {
            count_VkImportColorBufferGOOGLE(featureBits, rootType, reinterpret_cast<const VkImportColorBufferGOOGLE*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_IMPORT_BUFFER_GOOGLE:
        {
            count_VkImportBufferGOOGLE(featureBits, rootType, reinterpret_cast<const VkImportBufferGOOGLE*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_CREATE_BLOB_GOOGLE:
        {
            count_VkCreateBlobGOOGLE(featureBits, rootType, reinterpret_cast<const VkCreateBlobGOOGLE*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_DEBUG_METADATA_GUEST_PROCESS_NAME_GOOGLE:
        {
            count_VkDebugMetadataGuestProcessNameGOOGLE(featureBits, rootType, reinterpret_cast<const VkDebugMetadataGuestProcessNameGOOGLE*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_DEBUG_METADATA_GUEST_PROCESS_ID_GOOGLE:
        {
            count_VkDebugMetadataGuestProcessIdGOOGLE(featureBits, rootType, reinterpret_cast<const VkDebugMetadataGuestProcessIdGOOGLE*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_DEBUG_METADATA_GUEST_THREAD_NAME_GOOGLE:
        {
            count_VkDebugMetadataGuestThreadNameGOOGLE(featureBits, rootType, reinterpret_cast<const VkDebugMetadataGuestThreadNameGOOGLE*>(structExtension), count);
            break;
        }
        case VK_STRUCTURE_TYPE_DEBUG_METADATA_GUEST_THREAD_ID_GOOGLE:
        {
            count_VkDebugMetadataGuestThreadIdGOOGLE(featureBits, rootType, reinterpret_cast<const VkDebugMetadataGuestThreadIdGOOGLE*>(structExtension), count);
            break;
        }
#endif
#ifdef VK_EXT_image_compression_control_swapchain
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT:
        {
            count_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(featureBits, rootType, reinterpret_cast<const VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT*>(structExtension), count);
            break;
        }
#endif
        default:
        {
            // fatal; the switch is only taken if the extension struct is known
            abort();
        }
    }
}


}  // namespace vk
}  // namespace gfxstream
