/* src/bazaar.p/bz-state-info.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-state-info.h"



struct _BzStateInfo
{
  GObject parent_instance;

  GListModel *all_entries;
  GListModel *all_entry_groups;
  GListModel *all_installed_entry_groups;
  GListModel *all_user_data_entry_groups;
  gboolean allow_manual_sync;
  BzApplicationMapFactory *application_factory;
  BzAuthState *auth_state;
  GListModel *available_updates;
  BzBackend *backend;
  char *background_task_label;
  GListModel *blocklists;
  BzContentProvider *blocklists_provider;
  gboolean busy;
  double busy_progress;
  char *busy_progress_label;
  char *busy_step_label;
  BzEntryCacheManager *cache_manager;
  gboolean checking_for_updates;
  GListModel *curated_configs;
  BzContentProvider *curated_provider;
  gboolean debug_mode;
  gboolean disable_blocklists;
  gboolean donation_prompt_dismissed;
  BzApplicationMapFactory *entry_factory;
  BzFlathubState *flathub;
  gboolean have_connection;
  gboolean hide_eol;
  BzMainConfig *main_config;
  gboolean metered_connection;
  gboolean online;
  GListModel *repositories;
  BzSearchEngine *search_engine;
  GSettings *settings;
  gboolean show_only_flathub;
  gboolean show_only_foss;
  gboolean show_only_verified;
  gboolean syncing;
  BzTransactionManager *transaction_manager;
  GListModel *txt_blocklists;
  BzContentProvider *txt_blocklists_provider;
  GtkIconTheme *user_icon_theme;
  GtkIconTheme *system_icon_theme;
};

G_DEFINE_FINAL_TYPE (BzStateInfo, bz_state_info, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_ALL_ENTRIES,
  PROP_ALL_ENTRY_GROUPS,
  PROP_ALL_INSTALLED_ENTRY_GROUPS,
  PROP_ALL_USER_DATA_ENTRY_GROUPS,
  PROP_ALLOW_MANUAL_SYNC,
  PROP_APPLICATION_FACTORY,
  PROP_AUTH_STATE,
  PROP_AVAILABLE_UPDATES,
  PROP_BACKEND,
  PROP_BACKGROUND_TASK_LABEL,
  PROP_BLOCKLISTS,
  PROP_BLOCKLISTS_PROVIDER,
  PROP_BUSY,
  PROP_BUSY_PROGRESS,
  PROP_BUSY_PROGRESS_LABEL,
  PROP_BUSY_STEP_LABEL,
  PROP_CACHE_MANAGER,
  PROP_CHECKING_FOR_UPDATES,
  PROP_CURATED_CONFIGS,
  PROP_CURATED_PROVIDER,
  PROP_DEBUG_MODE,
  PROP_DISABLE_BLOCKLISTS,
  PROP_DONATION_PROMPT_DISMISSED,
  PROP_ENTRY_FACTORY,
  PROP_FLATHUB,
  PROP_HAVE_CONNECTION,
  PROP_HIDE_EOL,
  PROP_MAIN_CONFIG,
  PROP_METERED_CONNECTION,
  PROP_ONLINE,
  PROP_REPOSITORIES,
  PROP_SEARCH_ENGINE,
  PROP_SETTINGS,
  PROP_SHOW_ONLY_FLATHUB,
  PROP_SHOW_ONLY_FOSS,
  PROP_SHOW_ONLY_VERIFIED,
  PROP_SYNCING,
  PROP_TRANSACTION_MANAGER,
  PROP_TXT_BLOCKLISTS,
  PROP_TXT_BLOCKLISTS_PROVIDER,
  PROP_USER_ICON_THEME,
  PROP_SYSTEM_ICON_THEME,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_state_info_dispose (GObject *object)
{
  BzStateInfo *self = BZ_STATE_INFO (object);

  g_clear_pointer (&self->all_entries, g_object_unref);
  g_clear_pointer (&self->all_entry_groups, g_object_unref);
  g_clear_pointer (&self->all_installed_entry_groups, g_object_unref);
  g_clear_pointer (&self->all_user_data_entry_groups, g_object_unref);
  g_clear_pointer (&self->application_factory, g_object_unref);
  g_clear_pointer (&self->auth_state, g_object_unref);
  g_clear_pointer (&self->available_updates, g_object_unref);
  g_clear_pointer (&self->backend, g_object_unref);
  g_clear_pointer (&self->background_task_label, g_free);
  g_clear_pointer (&self->blocklists, g_object_unref);
  g_clear_pointer (&self->blocklists_provider, g_object_unref);
  g_clear_pointer (&self->busy_progress_label, g_free);
  g_clear_pointer (&self->busy_step_label, g_free);
  g_clear_pointer (&self->cache_manager, g_object_unref);
  g_clear_pointer (&self->curated_configs, g_object_unref);
  g_clear_pointer (&self->curated_provider, g_object_unref);
  g_clear_pointer (&self->entry_factory, g_object_unref);
  g_clear_pointer (&self->flathub, g_object_unref);
  g_clear_pointer (&self->main_config, g_object_unref);
  g_clear_pointer (&self->repositories, g_object_unref);
  g_clear_pointer (&self->search_engine, g_object_unref);
  g_clear_pointer (&self->settings, g_object_unref);
  g_clear_pointer (&self->transaction_manager, g_object_unref);
  g_clear_pointer (&self->txt_blocklists, g_object_unref);
  g_clear_pointer (&self->txt_blocklists_provider, g_object_unref);
  g_clear_pointer (&self->user_icon_theme, g_object_unref);
  g_clear_pointer (&self->system_icon_theme, g_object_unref);

  G_OBJECT_CLASS (bz_state_info_parent_class)->dispose (object);
}

static void
bz_state_info_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzStateInfo *self = BZ_STATE_INFO (object);

  switch (prop_id)
    {
    case PROP_ALL_ENTRIES:
      g_value_set_object (value, bz_state_info_get_all_entries (self));
      break;
    case PROP_ALL_ENTRY_GROUPS:
      g_value_set_object (value, bz_state_info_get_all_entry_groups (self));
      break;
    case PROP_ALL_INSTALLED_ENTRY_GROUPS:
      g_value_set_object (value, bz_state_info_get_all_installed_entry_groups (self));
      break;
    case PROP_ALL_USER_DATA_ENTRY_GROUPS:
      g_value_set_object (value, bz_state_info_get_all_user_data_entry_groups (self));
      break;
    case PROP_ALLOW_MANUAL_SYNC:
      g_value_set_boolean (value, bz_state_info_get_allow_manual_sync (self));
      break;
    case PROP_APPLICATION_FACTORY:
      g_value_set_object (value, bz_state_info_get_application_factory (self));
      break;
    case PROP_AUTH_STATE:
      g_value_set_object (value, bz_state_info_get_auth_state (self));
      break;
    case PROP_AVAILABLE_UPDATES:
      g_value_set_object (value, bz_state_info_get_available_updates (self));
      break;
    case PROP_BACKEND:
      g_value_set_object (value, bz_state_info_get_backend (self));
      break;
    case PROP_BACKGROUND_TASK_LABEL:
      g_value_set_string (value, bz_state_info_get_background_task_label (self));
      break;
    case PROP_BLOCKLISTS:
      g_value_set_object (value, bz_state_info_get_blocklists (self));
      break;
    case PROP_BLOCKLISTS_PROVIDER:
      g_value_set_object (value, bz_state_info_get_blocklists_provider (self));
      break;
    case PROP_BUSY:
      g_value_set_boolean (value, bz_state_info_get_busy (self));
      break;
    case PROP_BUSY_PROGRESS:
      g_value_set_double (value, bz_state_info_get_busy_progress (self));
      break;
    case PROP_BUSY_PROGRESS_LABEL:
      g_value_set_string (value, bz_state_info_get_busy_progress_label (self));
      break;
    case PROP_BUSY_STEP_LABEL:
      g_value_set_string (value, bz_state_info_get_busy_step_label (self));
      break;
    case PROP_CACHE_MANAGER:
      g_value_set_object (value, bz_state_info_get_cache_manager (self));
      break;
    case PROP_CHECKING_FOR_UPDATES:
      g_value_set_boolean (value, bz_state_info_get_checking_for_updates (self));
      break;
    case PROP_CURATED_CONFIGS:
      g_value_set_object (value, bz_state_info_get_curated_configs (self));
      break;
    case PROP_CURATED_PROVIDER:
      g_value_set_object (value, bz_state_info_get_curated_provider (self));
      break;
    case PROP_DEBUG_MODE:
      g_value_set_boolean (value, bz_state_info_get_debug_mode (self));
      break;
    case PROP_DISABLE_BLOCKLISTS:
      g_value_set_boolean (value, bz_state_info_get_disable_blocklists (self));
      break;
    case PROP_DONATION_PROMPT_DISMISSED:
      g_value_set_boolean (value, bz_state_info_get_donation_prompt_dismissed (self));
      break;
    case PROP_ENTRY_FACTORY:
      g_value_set_object (value, bz_state_info_get_entry_factory (self));
      break;
    case PROP_FLATHUB:
      g_value_set_object (value, bz_state_info_get_flathub (self));
      break;
    case PROP_HAVE_CONNECTION:
      g_value_set_boolean (value, bz_state_info_get_have_connection (self));
      break;
    case PROP_HIDE_EOL:
      g_value_set_boolean (value, bz_state_info_get_hide_eol (self));
      break;
    case PROP_MAIN_CONFIG:
      g_value_set_object (value, bz_state_info_get_main_config (self));
      break;
    case PROP_METERED_CONNECTION:
      g_value_set_boolean (value, bz_state_info_get_metered_connection (self));
      break;
    case PROP_ONLINE:
      g_value_set_boolean (value, bz_state_info_get_online (self));
      break;
    case PROP_REPOSITORIES:
      g_value_set_object (value, bz_state_info_get_repositories (self));
      break;
    case PROP_SEARCH_ENGINE:
      g_value_set_object (value, bz_state_info_get_search_engine (self));
      break;
    case PROP_SETTINGS:
      g_value_set_object (value, bz_state_info_get_settings (self));
      break;
    case PROP_SHOW_ONLY_FLATHUB:
      g_value_set_boolean (value, bz_state_info_get_show_only_flathub (self));
      break;
    case PROP_SHOW_ONLY_FOSS:
      g_value_set_boolean (value, bz_state_info_get_show_only_foss (self));
      break;
    case PROP_SHOW_ONLY_VERIFIED:
      g_value_set_boolean (value, bz_state_info_get_show_only_verified (self));
      break;
    case PROP_SYNCING:
      g_value_set_boolean (value, bz_state_info_get_syncing (self));
      break;
    case PROP_TRANSACTION_MANAGER:
      g_value_set_object (value, bz_state_info_get_transaction_manager (self));
      break;
    case PROP_TXT_BLOCKLISTS:
      g_value_set_object (value, bz_state_info_get_txt_blocklists (self));
      break;
    case PROP_TXT_BLOCKLISTS_PROVIDER:
      g_value_set_object (value, bz_state_info_get_txt_blocklists_provider (self));
      break;
    case PROP_USER_ICON_THEME:
      g_value_set_object (value, bz_state_info_get_user_icon_theme (self));
      break;
    case PROP_SYSTEM_ICON_THEME:
      g_value_set_object (value, bz_state_info_get_system_icon_theme (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_state_info_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzStateInfo *self = BZ_STATE_INFO (object);

  switch (prop_id)
    {
    case PROP_ALL_ENTRIES:
      bz_state_info_set_all_entries (self, g_value_get_object (value));
      break;
    case PROP_ALL_ENTRY_GROUPS:
      bz_state_info_set_all_entry_groups (self, g_value_get_object (value));
      break;
    case PROP_ALL_INSTALLED_ENTRY_GROUPS:
      bz_state_info_set_all_installed_entry_groups (self, g_value_get_object (value));
      break;
    case PROP_ALL_USER_DATA_ENTRY_GROUPS:
      bz_state_info_set_all_user_data_entry_groups (self, g_value_get_object (value));
      break;
    case PROP_ALLOW_MANUAL_SYNC:
      bz_state_info_set_allow_manual_sync (self, g_value_get_boolean (value));
      break;
    case PROP_APPLICATION_FACTORY:
      bz_state_info_set_application_factory (self, g_value_get_object (value));
      break;
    case PROP_AUTH_STATE:
      bz_state_info_set_auth_state (self, g_value_get_object (value));
      break;
    case PROP_AVAILABLE_UPDATES:
      bz_state_info_set_available_updates (self, g_value_get_object (value));
      break;
    case PROP_BACKEND:
      bz_state_info_set_backend (self, g_value_get_object (value));
      break;
    case PROP_BACKGROUND_TASK_LABEL:
      bz_state_info_set_background_task_label (self, g_value_get_string (value));
      break;
    case PROP_BLOCKLISTS:
      bz_state_info_set_blocklists (self, g_value_get_object (value));
      break;
    case PROP_BLOCKLISTS_PROVIDER:
      bz_state_info_set_blocklists_provider (self, g_value_get_object (value));
      break;
    case PROP_BUSY:
      bz_state_info_set_busy (self, g_value_get_boolean (value));
      break;
    case PROP_BUSY_PROGRESS:
      bz_state_info_set_busy_progress (self, g_value_get_double (value));
      break;
    case PROP_BUSY_PROGRESS_LABEL:
      bz_state_info_set_busy_progress_label (self, g_value_get_string (value));
      break;
    case PROP_BUSY_STEP_LABEL:
      bz_state_info_set_busy_step_label (self, g_value_get_string (value));
      break;
    case PROP_CACHE_MANAGER:
      bz_state_info_set_cache_manager (self, g_value_get_object (value));
      break;
    case PROP_CHECKING_FOR_UPDATES:
      bz_state_info_set_checking_for_updates (self, g_value_get_boolean (value));
      break;
    case PROP_CURATED_CONFIGS:
      bz_state_info_set_curated_configs (self, g_value_get_object (value));
      break;
    case PROP_CURATED_PROVIDER:
      bz_state_info_set_curated_provider (self, g_value_get_object (value));
      break;
    case PROP_DEBUG_MODE:
      bz_state_info_set_debug_mode (self, g_value_get_boolean (value));
      break;
    case PROP_DISABLE_BLOCKLISTS:
      bz_state_info_set_disable_blocklists (self, g_value_get_boolean (value));
      break;
    case PROP_DONATION_PROMPT_DISMISSED:
      bz_state_info_set_donation_prompt_dismissed (self, g_value_get_boolean (value));
      break;
    case PROP_ENTRY_FACTORY:
      bz_state_info_set_entry_factory (self, g_value_get_object (value));
      break;
    case PROP_FLATHUB:
      bz_state_info_set_flathub (self, g_value_get_object (value));
      break;
    case PROP_HAVE_CONNECTION:
      bz_state_info_set_have_connection (self, g_value_get_boolean (value));
      break;
    case PROP_HIDE_EOL:
      bz_state_info_set_hide_eol (self, g_value_get_boolean (value));
      break;
    case PROP_MAIN_CONFIG:
      bz_state_info_set_main_config (self, g_value_get_object (value));
      break;
    case PROP_METERED_CONNECTION:
      bz_state_info_set_metered_connection (self, g_value_get_boolean (value));
      break;
    case PROP_ONLINE:
      bz_state_info_set_online (self, g_value_get_boolean (value));
      break;
    case PROP_REPOSITORIES:
      bz_state_info_set_repositories (self, g_value_get_object (value));
      break;
    case PROP_SEARCH_ENGINE:
      bz_state_info_set_search_engine (self, g_value_get_object (value));
      break;
    case PROP_SETTINGS:
      bz_state_info_set_settings (self, g_value_get_object (value));
      break;
    case PROP_SHOW_ONLY_FLATHUB:
      bz_state_info_set_show_only_flathub (self, g_value_get_boolean (value));
      break;
    case PROP_SHOW_ONLY_FOSS:
      bz_state_info_set_show_only_foss (self, g_value_get_boolean (value));
      break;
    case PROP_SHOW_ONLY_VERIFIED:
      bz_state_info_set_show_only_verified (self, g_value_get_boolean (value));
      break;
    case PROP_SYNCING:
      bz_state_info_set_syncing (self, g_value_get_boolean (value));
      break;
    case PROP_TRANSACTION_MANAGER:
      bz_state_info_set_transaction_manager (self, g_value_get_object (value));
      break;
    case PROP_TXT_BLOCKLISTS:
      bz_state_info_set_txt_blocklists (self, g_value_get_object (value));
      break;
    case PROP_TXT_BLOCKLISTS_PROVIDER:
      bz_state_info_set_txt_blocklists_provider (self, g_value_get_object (value));
      break;
    case PROP_USER_ICON_THEME:
      bz_state_info_set_user_icon_theme (self, g_value_get_object (value));
      break;
    case PROP_SYSTEM_ICON_THEME:
      bz_state_info_set_system_icon_theme (self, g_value_get_object (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_state_info_class_init (BzStateInfoClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);



  object_class->set_property = bz_state_info_set_property;
  object_class->get_property = bz_state_info_get_property;
  object_class->dispose      = bz_state_info_dispose;

  props[PROP_ALL_ENTRIES] =
      g_param_spec_object (
          "all-entries",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_ALL_ENTRY_GROUPS] =
      g_param_spec_object (
          "all-entry-groups",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_ALL_INSTALLED_ENTRY_GROUPS] =
      g_param_spec_object (
          "all-installed-entry-groups",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_ALL_USER_DATA_ENTRY_GROUPS] =
      g_param_spec_object (
          "all-user-data-entry-groups",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_ALLOW_MANUAL_SYNC] =
      g_param_spec_boolean (
          "allow-manual-sync",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_APPLICATION_FACTORY] =
      g_param_spec_object (
          "application-factory",
          NULL, NULL,
          BZ_TYPE_APPLICATION_MAP_FACTORY,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_AUTH_STATE] =
      g_param_spec_object (
          "auth-state",
          NULL, NULL,
          BZ_TYPE_AUTH_STATE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_AVAILABLE_UPDATES] =
      g_param_spec_object (
          "available-updates",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_BACKEND] =
      g_param_spec_object (
          "backend",
          NULL, NULL,
          BZ_TYPE_BACKEND,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_BACKGROUND_TASK_LABEL] =
      g_param_spec_string (
          "background-task-label",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_BLOCKLISTS] =
      g_param_spec_object (
          "blocklists",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_BLOCKLISTS_PROVIDER] =
      g_param_spec_object (
          "blocklists-provider",
          NULL, NULL,
          BZ_TYPE_CONTENT_PROVIDER,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_BUSY] =
      g_param_spec_boolean (
          "busy",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_BUSY_PROGRESS] =
      g_param_spec_double (
          "busy-progress",
          NULL, NULL,
          0.0, G_MAXDOUBLE, 0.0,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_BUSY_PROGRESS_LABEL] =
      g_param_spec_string (
          "busy-progress-label",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_BUSY_STEP_LABEL] =
      g_param_spec_string (
          "busy-step-label",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_CACHE_MANAGER] =
      g_param_spec_object (
          "cache-manager",
          NULL, NULL,
          BZ_TYPE_ENTRY_CACHE_MANAGER,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_CHECKING_FOR_UPDATES] =
      g_param_spec_boolean (
          "checking-for-updates",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_CURATED_CONFIGS] =
      g_param_spec_object (
          "curated-configs",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_CURATED_PROVIDER] =
      g_param_spec_object (
          "curated-provider",
          NULL, NULL,
          BZ_TYPE_CONTENT_PROVIDER,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_DEBUG_MODE] =
      g_param_spec_boolean (
          "debug-mode",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_DISABLE_BLOCKLISTS] =
      g_param_spec_boolean (
          "disable-blocklists",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_DONATION_PROMPT_DISMISSED] =
      g_param_spec_boolean (
          "donation-prompt-dismissed",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_ENTRY_FACTORY] =
      g_param_spec_object (
          "entry-factory",
          NULL, NULL,
          BZ_TYPE_APPLICATION_MAP_FACTORY,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_FLATHUB] =
      g_param_spec_object (
          "flathub",
          NULL, NULL,
          BZ_TYPE_FLATHUB_STATE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_HAVE_CONNECTION] =
      g_param_spec_boolean (
          "have-connection",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_HIDE_EOL] =
      g_param_spec_boolean (
          "hide-eol",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_MAIN_CONFIG] =
      g_param_spec_object (
          "main-config",
          NULL, NULL,
          BZ_TYPE_MAIN_CONFIG,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_METERED_CONNECTION] =
      g_param_spec_boolean (
          "metered-connection",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_ONLINE] =
      g_param_spec_boolean (
          "online",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_REPOSITORIES] =
      g_param_spec_object (
          "repositories",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_SEARCH_ENGINE] =
      g_param_spec_object (
          "search-engine",
          NULL, NULL,
          BZ_TYPE_SEARCH_ENGINE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_SETTINGS] =
      g_param_spec_object (
          "settings",
          NULL, NULL,
          G_TYPE_SETTINGS,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_SHOW_ONLY_FLATHUB] =
      g_param_spec_boolean (
          "show-only-flathub",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_SHOW_ONLY_FOSS] =
      g_param_spec_boolean (
          "show-only-foss",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_SHOW_ONLY_VERIFIED] =
      g_param_spec_boolean (
          "show-only-verified",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_SYNCING] =
      g_param_spec_boolean (
          "syncing",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_TRANSACTION_MANAGER] =
      g_param_spec_object (
          "transaction-manager",
          NULL, NULL,
          BZ_TYPE_TRANSACTION_MANAGER,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_TXT_BLOCKLISTS] =
      g_param_spec_object (
          "txt-blocklists",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_TXT_BLOCKLISTS_PROVIDER] =
      g_param_spec_object (
          "txt-blocklists-provider",
          NULL, NULL,
          BZ_TYPE_CONTENT_PROVIDER,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_USER_ICON_THEME] =
      g_param_spec_object (
          "user-icon-theme",
          NULL, NULL,
          GTK_TYPE_ICON_THEME,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_SYSTEM_ICON_THEME] =
      g_param_spec_object (
          "system-icon-theme",
          NULL, NULL,
          GTK_TYPE_ICON_THEME,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_state_info_init (BzStateInfo *self)
{
}

BzStateInfo *
bz_state_info_new (void){
  return g_object_new (BZ_TYPE_STATE_INFO, NULL);
}

GListModel *
bz_state_info_get_all_entries (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->all_entries;
}

GListModel *
bz_state_info_get_all_entry_groups (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->all_entry_groups;
}

GListModel *
bz_state_info_get_all_installed_entry_groups (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->all_installed_entry_groups;
}

GListModel *
bz_state_info_get_all_user_data_entry_groups (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->all_user_data_entry_groups;
}

gboolean
bz_state_info_get_allow_manual_sync (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), FALSE);
  return self->allow_manual_sync;
}

BzApplicationMapFactory *
bz_state_info_get_application_factory (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->application_factory;
}

BzAuthState *
bz_state_info_get_auth_state (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->auth_state;
}

GListModel *
bz_state_info_get_available_updates (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->available_updates;
}

BzBackend *
bz_state_info_get_backend (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->backend;
}

const char *
bz_state_info_get_background_task_label (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->background_task_label;
}

GListModel *
bz_state_info_get_blocklists (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->blocklists;
}

BzContentProvider *
bz_state_info_get_blocklists_provider (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->blocklists_provider;
}

gboolean
bz_state_info_get_busy (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), FALSE);
  return self->busy;
}

double
bz_state_info_get_busy_progress (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), 0.0);
  return self->busy_progress;
}

const char *
bz_state_info_get_busy_progress_label (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->busy_progress_label;
}

const char *
bz_state_info_get_busy_step_label (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->busy_step_label;
}

BzEntryCacheManager *
bz_state_info_get_cache_manager (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->cache_manager;
}

gboolean
bz_state_info_get_checking_for_updates (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), FALSE);
  return self->checking_for_updates;
}

GListModel *
bz_state_info_get_curated_configs (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->curated_configs;
}

BzContentProvider *
bz_state_info_get_curated_provider (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->curated_provider;
}

gboolean
bz_state_info_get_debug_mode (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), FALSE);
  return self->debug_mode;
}

gboolean
bz_state_info_get_disable_blocklists (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), FALSE);
  return self->disable_blocklists;
}

gboolean
bz_state_info_get_donation_prompt_dismissed (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), FALSE);
  return self->donation_prompt_dismissed;
}

BzApplicationMapFactory *
bz_state_info_get_entry_factory (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->entry_factory;
}

BzFlathubState *
bz_state_info_get_flathub (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->flathub;
}

gboolean
bz_state_info_get_have_connection (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), FALSE);
  return self->have_connection;
}

gboolean
bz_state_info_get_hide_eol (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), FALSE);
  return self->hide_eol;
}

BzMainConfig *
bz_state_info_get_main_config (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->main_config;
}

gboolean
bz_state_info_get_metered_connection (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), FALSE);
  return self->metered_connection;
}

gboolean
bz_state_info_get_online (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), FALSE);
  return self->online;
}

GListModel *
bz_state_info_get_repositories (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->repositories;
}

BzSearchEngine *
bz_state_info_get_search_engine (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->search_engine;
}

GSettings *
bz_state_info_get_settings (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->settings;
}

gboolean
bz_state_info_get_show_only_flathub (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), FALSE);
  return self->show_only_flathub;
}

gboolean
bz_state_info_get_show_only_foss (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), FALSE);
  return self->show_only_foss;
}

gboolean
bz_state_info_get_show_only_verified (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), FALSE);
  return self->show_only_verified;
}

gboolean
bz_state_info_get_syncing (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), FALSE);
  return self->syncing;
}

BzTransactionManager *
bz_state_info_get_transaction_manager (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->transaction_manager;
}

GListModel *
bz_state_info_get_txt_blocklists (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->txt_blocklists;
}

BzContentProvider *
bz_state_info_get_txt_blocklists_provider (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->txt_blocklists_provider;
}

GtkIconTheme *
bz_state_info_get_user_icon_theme (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->user_icon_theme;
}

GtkIconTheme *
bz_state_info_get_system_icon_theme (BzStateInfo *self){
  g_return_val_if_fail (BZ_IS_STATE_INFO (self), NULL);
  return self->system_icon_theme;
}

void
bz_state_info_set_all_entries (BzStateInfo *self,
    GListModel *all_entries){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (all_entries == self->all_entries)
    return;

  g_clear_pointer (&self->all_entries, g_object_unref);
  if (all_entries != NULL)
    self->all_entries = g_object_ref (all_entries);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_ALL_ENTRIES]);
}

void
bz_state_info_set_all_entry_groups (BzStateInfo *self,
    GListModel *all_entry_groups){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (all_entry_groups == self->all_entry_groups)
    return;

  g_clear_pointer (&self->all_entry_groups, g_object_unref);
  if (all_entry_groups != NULL)
    self->all_entry_groups = g_object_ref (all_entry_groups);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_ALL_ENTRY_GROUPS]);
}

void
bz_state_info_set_all_installed_entry_groups (BzStateInfo *self,
    GListModel *all_installed_entry_groups){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (all_installed_entry_groups == self->all_installed_entry_groups)
    return;

  g_clear_pointer (&self->all_installed_entry_groups, g_object_unref);
  if (all_installed_entry_groups != NULL)
    self->all_installed_entry_groups = g_object_ref (all_installed_entry_groups);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_ALL_INSTALLED_ENTRY_GROUPS]);
}

void
bz_state_info_set_all_user_data_entry_groups (BzStateInfo *self,
    GListModel *all_user_data_entry_groups){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (all_user_data_entry_groups == self->all_user_data_entry_groups)
    return;

  g_clear_pointer (&self->all_user_data_entry_groups, g_object_unref);
  if (all_user_data_entry_groups != NULL)
    self->all_user_data_entry_groups = g_object_ref (all_user_data_entry_groups);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_ALL_USER_DATA_ENTRY_GROUPS]);
}

void
bz_state_info_set_allow_manual_sync (BzStateInfo *self,
    gboolean allow_manual_sync){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (!!allow_manual_sync == !!self->allow_manual_sync)
    return;

  self->allow_manual_sync = allow_manual_sync;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_ALLOW_MANUAL_SYNC]);
}

void
bz_state_info_set_application_factory (BzStateInfo *self,
    BzApplicationMapFactory *application_factory){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (application_factory == self->application_factory)
    return;

  g_clear_pointer (&self->application_factory, g_object_unref);
  if (application_factory != NULL)
    self->application_factory = g_object_ref (application_factory);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_APPLICATION_FACTORY]);
}

void
bz_state_info_set_auth_state (BzStateInfo *self,
    BzAuthState *auth_state){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (auth_state == self->auth_state)
    return;

  g_clear_pointer (&self->auth_state, g_object_unref);
  if (auth_state != NULL)
    self->auth_state = g_object_ref (auth_state);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_AUTH_STATE]);
}

void
bz_state_info_set_available_updates (BzStateInfo *self,
    GListModel *available_updates){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (available_updates == self->available_updates)
    return;

  g_clear_pointer (&self->available_updates, g_object_unref);
  if (available_updates != NULL)
    self->available_updates = g_object_ref (available_updates);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_AVAILABLE_UPDATES]);
}

void
bz_state_info_set_backend (BzStateInfo *self,
    BzBackend *backend){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (backend == self->backend)
    return;

  g_clear_pointer (&self->backend, g_object_unref);
  if (backend != NULL)
    self->backend = g_object_ref (backend);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_BACKEND]);
}

void
bz_state_info_set_background_task_label (BzStateInfo *self,
    const char *background_task_label){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (background_task_label == self->background_task_label || (background_task_label != NULL && self->background_task_label != NULL && g_strcmp0(background_task_label, self->background_task_label) == 0))
    return;

  g_clear_pointer (&self->background_task_label, g_free);
  if (background_task_label != NULL)
    self->background_task_label = g_strdup (background_task_label);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_BACKGROUND_TASK_LABEL]);
}

void
bz_state_info_set_blocklists (BzStateInfo *self,
    GListModel *blocklists){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (blocklists == self->blocklists)
    return;

  g_clear_pointer (&self->blocklists, g_object_unref);
  if (blocklists != NULL)
    self->blocklists = g_object_ref (blocklists);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_BLOCKLISTS]);
}

void
bz_state_info_set_blocklists_provider (BzStateInfo *self,
    BzContentProvider *blocklists_provider){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (blocklists_provider == self->blocklists_provider)
    return;

  g_clear_pointer (&self->blocklists_provider, g_object_unref);
  if (blocklists_provider != NULL)
    self->blocklists_provider = g_object_ref (blocklists_provider);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_BLOCKLISTS_PROVIDER]);
}

void
bz_state_info_set_busy (BzStateInfo *self,
    gboolean busy){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (!!busy == !!self->busy)
    return;

  self->busy = busy;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_BUSY]);
}

void
bz_state_info_set_busy_progress (BzStateInfo *self,
    double busy_progress){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (busy_progress == self->busy_progress)
    return;

  self->busy_progress = busy_progress;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_BUSY_PROGRESS]);
}

void
bz_state_info_set_busy_progress_label (BzStateInfo *self,
    const char *busy_progress_label){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (busy_progress_label == self->busy_progress_label || (busy_progress_label != NULL && self->busy_progress_label != NULL && g_strcmp0(busy_progress_label, self->busy_progress_label) == 0))
    return;

  g_clear_pointer (&self->busy_progress_label, g_free);
  if (busy_progress_label != NULL)
    self->busy_progress_label = g_strdup (busy_progress_label);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_BUSY_PROGRESS_LABEL]);
}

void
bz_state_info_set_busy_step_label (BzStateInfo *self,
    const char *busy_step_label){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (busy_step_label == self->busy_step_label || (busy_step_label != NULL && self->busy_step_label != NULL && g_strcmp0(busy_step_label, self->busy_step_label) == 0))
    return;

  g_clear_pointer (&self->busy_step_label, g_free);
  if (busy_step_label != NULL)
    self->busy_step_label = g_strdup (busy_step_label);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_BUSY_STEP_LABEL]);
}

void
bz_state_info_set_cache_manager (BzStateInfo *self,
    BzEntryCacheManager *cache_manager){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (cache_manager == self->cache_manager)
    return;

  g_clear_pointer (&self->cache_manager, g_object_unref);
  if (cache_manager != NULL)
    self->cache_manager = g_object_ref (cache_manager);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_CACHE_MANAGER]);
}

void
bz_state_info_set_checking_for_updates (BzStateInfo *self,
    gboolean checking_for_updates){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (!!checking_for_updates == !!self->checking_for_updates)
    return;

  self->checking_for_updates = checking_for_updates;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_CHECKING_FOR_UPDATES]);
}

void
bz_state_info_set_curated_configs (BzStateInfo *self,
    GListModel *curated_configs){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (curated_configs == self->curated_configs)
    return;

  g_clear_pointer (&self->curated_configs, g_object_unref);
  if (curated_configs != NULL)
    self->curated_configs = g_object_ref (curated_configs);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_CURATED_CONFIGS]);
}

void
bz_state_info_set_curated_provider (BzStateInfo *self,
    BzContentProvider *curated_provider){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (curated_provider == self->curated_provider)
    return;

  g_clear_pointer (&self->curated_provider, g_object_unref);
  if (curated_provider != NULL)
    self->curated_provider = g_object_ref (curated_provider);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_CURATED_PROVIDER]);
}

void
bz_state_info_set_debug_mode (BzStateInfo *self,
    gboolean debug_mode){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (!!debug_mode == !!self->debug_mode)
    return;

  self->debug_mode = debug_mode;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_DEBUG_MODE]);
}

void
bz_state_info_set_disable_blocklists (BzStateInfo *self,
    gboolean disable_blocklists){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (!!disable_blocklists == !!self->disable_blocklists)
    return;

  self->disable_blocklists = disable_blocklists;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_DISABLE_BLOCKLISTS]);
}

void
bz_state_info_set_donation_prompt_dismissed (BzStateInfo *self,
    gboolean donation_prompt_dismissed){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (!!donation_prompt_dismissed == !!self->donation_prompt_dismissed)
    return;

  self->donation_prompt_dismissed = donation_prompt_dismissed;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_DONATION_PROMPT_DISMISSED]);
}

void
bz_state_info_set_entry_factory (BzStateInfo *self,
    BzApplicationMapFactory *entry_factory){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (entry_factory == self->entry_factory)
    return;

  g_clear_pointer (&self->entry_factory, g_object_unref);
  if (entry_factory != NULL)
    self->entry_factory = g_object_ref (entry_factory);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_ENTRY_FACTORY]);
}

void
bz_state_info_set_flathub (BzStateInfo *self,
    BzFlathubState *flathub){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (flathub == self->flathub)
    return;

  g_clear_pointer (&self->flathub, g_object_unref);
  if (flathub != NULL)
    self->flathub = g_object_ref (flathub);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_FLATHUB]);
}

void
bz_state_info_set_have_connection (BzStateInfo *self,
    gboolean have_connection){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (!!have_connection == !!self->have_connection)
    return;

  self->have_connection = have_connection;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_HAVE_CONNECTION]);
}

void
bz_state_info_set_hide_eol (BzStateInfo *self,
    gboolean hide_eol){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (!!hide_eol == !!self->hide_eol)
    return;

  self->hide_eol = hide_eol;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_HIDE_EOL]);
}

void
bz_state_info_set_main_config (BzStateInfo *self,
    BzMainConfig *main_config){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (main_config == self->main_config)
    return;

  g_clear_pointer (&self->main_config, g_object_unref);
  if (main_config != NULL)
    self->main_config = g_object_ref (main_config);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_MAIN_CONFIG]);
}

void
bz_state_info_set_metered_connection (BzStateInfo *self,
    gboolean metered_connection){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (!!metered_connection == !!self->metered_connection)
    return;

  self->metered_connection = metered_connection;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_METERED_CONNECTION]);
}

void
bz_state_info_set_online (BzStateInfo *self,
    gboolean online){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (!!online == !!self->online)
    return;

  self->online = online;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_ONLINE]);
}

void
bz_state_info_set_repositories (BzStateInfo *self,
    GListModel *repositories){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (repositories == self->repositories)
    return;

  g_clear_pointer (&self->repositories, g_object_unref);
  if (repositories != NULL)
    self->repositories = g_object_ref (repositories);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_REPOSITORIES]);
}

void
bz_state_info_set_search_engine (BzStateInfo *self,
    BzSearchEngine *search_engine){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (search_engine == self->search_engine)
    return;

  g_clear_pointer (&self->search_engine, g_object_unref);
  if (search_engine != NULL)
    self->search_engine = g_object_ref (search_engine);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_SEARCH_ENGINE]);
}

void
bz_state_info_set_settings (BzStateInfo *self,
    GSettings *settings){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (settings == self->settings)
    return;

  g_clear_pointer (&self->settings, g_object_unref);
  if (settings != NULL)
    self->settings = g_object_ref (settings);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_SETTINGS]);
}

void
bz_state_info_set_show_only_flathub (BzStateInfo *self,
    gboolean show_only_flathub){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (!!show_only_flathub == !!self->show_only_flathub)
    return;

  self->show_only_flathub = show_only_flathub;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_SHOW_ONLY_FLATHUB]);
}

void
bz_state_info_set_show_only_foss (BzStateInfo *self,
    gboolean show_only_foss){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (!!show_only_foss == !!self->show_only_foss)
    return;

  self->show_only_foss = show_only_foss;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_SHOW_ONLY_FOSS]);
}

void
bz_state_info_set_show_only_verified (BzStateInfo *self,
    gboolean show_only_verified){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (!!show_only_verified == !!self->show_only_verified)
    return;

  self->show_only_verified = show_only_verified;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_SHOW_ONLY_VERIFIED]);
}

void
bz_state_info_set_syncing (BzStateInfo *self,
    gboolean syncing){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (!!syncing == !!self->syncing)
    return;

  self->syncing = syncing;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_SYNCING]);
}

void
bz_state_info_set_transaction_manager (BzStateInfo *self,
    BzTransactionManager *transaction_manager){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (transaction_manager == self->transaction_manager)
    return;

  g_clear_pointer (&self->transaction_manager, g_object_unref);
  if (transaction_manager != NULL)
    self->transaction_manager = g_object_ref (transaction_manager);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_TRANSACTION_MANAGER]);
}

void
bz_state_info_set_txt_blocklists (BzStateInfo *self,
    GListModel *txt_blocklists){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (txt_blocklists == self->txt_blocklists)
    return;

  g_clear_pointer (&self->txt_blocklists, g_object_unref);
  if (txt_blocklists != NULL)
    self->txt_blocklists = g_object_ref (txt_blocklists);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_TXT_BLOCKLISTS]);
}

void
bz_state_info_set_txt_blocklists_provider (BzStateInfo *self,
    BzContentProvider *txt_blocklists_provider){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (txt_blocklists_provider == self->txt_blocklists_provider)
    return;

  g_clear_pointer (&self->txt_blocklists_provider, g_object_unref);
  if (txt_blocklists_provider != NULL)
    self->txt_blocklists_provider = g_object_ref (txt_blocklists_provider);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_TXT_BLOCKLISTS_PROVIDER]);
}

void
bz_state_info_set_user_icon_theme (BzStateInfo *self,
    GtkIconTheme *user_icon_theme){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (user_icon_theme == self->user_icon_theme)
    return;

  g_clear_pointer (&self->user_icon_theme, g_object_unref);
  if (user_icon_theme != NULL)
    self->user_icon_theme = g_object_ref (user_icon_theme);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_USER_ICON_THEME]);
}

void
bz_state_info_set_system_icon_theme (BzStateInfo *self,
    GtkIconTheme *system_icon_theme){
  g_return_if_fail (BZ_IS_STATE_INFO (self));

  if (system_icon_theme == self->system_icon_theme)
    return;

  g_clear_pointer (&self->system_icon_theme, g_object_unref);
  if (system_icon_theme != NULL)
    self->system_icon_theme = g_object_ref (system_icon_theme);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_SYSTEM_ICON_THEME]);
}

/* End of src/bazaar.p/bz-state-info.c */
