/** @file zopt.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.23
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt */

#ifndef ZOPT_H
#define ZOPT_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE "zmap"
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define CMDLINE_PARSER_PACKAGE_NAME "zmap"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION "v4.3.4"
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  char * target_ports_arg;	/**< @brief comma-delimited list of ports and port ranges to scan (for TCP and UDP scans).  */
  char * target_ports_orig;	/**< @brief comma-delimited list of ports and port ranges to scan (for TCP and UDP scans) original value given at command line.  */
  const char *target_ports_help; /**< @brief comma-delimited list of ports and port ranges to scan (for TCP and UDP scans) help description.  */
  char * output_file_arg;	/**< @brief Output file.  */
  char * output_file_orig;	/**< @brief Output file original value given at command line.  */
  const char *output_file_help; /**< @brief Output file help description.  */
  char * blocklist_file_arg;	/**< @brief File of subnets to exclude, in CIDR notation, e.g. 192.168.0.0/16.  */
  char * blocklist_file_orig;	/**< @brief File of subnets to exclude, in CIDR notation, e.g. 192.168.0.0/16 original value given at command line.  */
  const char *blocklist_file_help; /**< @brief File of subnets to exclude, in CIDR notation, e.g. 192.168.0.0/16 help description.  */
  char * allowlist_file_arg;	/**< @brief File of subnets to constrain scan to, in CIDR notation, e.g. 192.168.0.0/16.  */
  char * allowlist_file_orig;	/**< @brief File of subnets to constrain scan to, in CIDR notation, e.g. 192.168.0.0/16 original value given at command line.  */
  const char *allowlist_file_help; /**< @brief File of subnets to constrain scan to, in CIDR notation, e.g. 192.168.0.0/16 help description.  */
  char * list_of_ips_file_arg;	/**< @brief List of individual addresses to scan in random order. Use --allowlist-file unless >1 million IPs.  */
  char * list_of_ips_file_orig;	/**< @brief List of individual addresses to scan in random order. Use --allowlist-file unless >1 million IPs original value given at command line.  */
  const char *list_of_ips_file_help; /**< @brief List of individual addresses to scan in random order. Use --allowlist-file unless >1 million IPs help description.  */
  int rate_arg;	/**< @brief Set send rate in packets/sec.  */
  char * rate_orig;	/**< @brief Set send rate in packets/sec original value given at command line.  */
  const char *rate_help; /**< @brief Set send rate in packets/sec help description.  */
  char * bandwidth_arg;	/**< @brief Set send rate in bits/second (supports suffixes G, M and K).  */
  char * bandwidth_orig;	/**< @brief Set send rate in bits/second (supports suffixes G, M and K) original value given at command line.  */
  const char *bandwidth_help; /**< @brief Set send rate in bits/second (supports suffixes G, M and K) help description.  */
  int batch_arg;	/**< @brief Set batch size for how many packets to send in a single syscall. Advantageous on Linux or with netmap (default=64).  */
  char * batch_orig;	/**< @brief Set batch size for how many packets to send in a single syscall. Advantageous on Linux or with netmap (default=64) original value given at command line.  */
  const char *batch_help; /**< @brief Set batch size for how many packets to send in a single syscall. Advantageous on Linux or with netmap (default=64) help description.  */
  char * max_targets_arg;	/**< @brief Cap number of targets to probe (as a number '-n 1000' or a percentage '-n 1%' of the target search space). A target is an IP/port pair, if scanning multiple ports, and an IP otherwise..  */
  char * max_targets_orig;	/**< @brief Cap number of targets to probe (as a number '-n 1000' or a percentage '-n 1%' of the target search space). A target is an IP/port pair, if scanning multiple ports, and an IP otherwise. original value given at command line.  */
  const char *max_targets_help; /**< @brief Cap number of targets to probe (as a number '-n 1000' or a percentage '-n 1%' of the target search space). A target is an IP/port pair, if scanning multiple ports, and an IP otherwise. help description.  */
  int max_runtime_arg;	/**< @brief Cap length of time for sending packets.  */
  char * max_runtime_orig;	/**< @brief Cap length of time for sending packets original value given at command line.  */
  const char *max_runtime_help; /**< @brief Cap length of time for sending packets help description.  */
  int max_results_arg;	/**< @brief Cap number of results to return.  */
  char * max_results_orig;	/**< @brief Cap number of results to return original value given at command line.  */
  const char *max_results_help; /**< @brief Cap number of results to return help description.  */
  int probes_arg;	/**< @brief Number of probes to send to each IP/Port pair (default='1').  */
  char * probes_orig;	/**< @brief Number of probes to send to each IP/Port pair original value given at command line.  */
  const char *probes_help; /**< @brief Number of probes to send to each IP/Port pair help description.  */
  int cooldown_time_arg;	/**< @brief How long to continue receiving after sending last probe (default='8').  */
  char * cooldown_time_orig;	/**< @brief How long to continue receiving after sending last probe original value given at command line.  */
  const char *cooldown_time_help; /**< @brief How long to continue receiving after sending last probe help description.  */
  #if defined(HAVE_LONG_LONG) || defined(HAVE_LONG_LONG_INT)
  long long int seed_arg;	/**< @brief Seed used to select address permutation.  */
  #else
  long seed_arg;	/**< @brief Seed used to select address permutation.  */
  #endif
  char * seed_orig;	/**< @brief Seed used to select address permutation original value given at command line.  */
  const char *seed_help; /**< @brief Seed used to select address permutation help description.  */
  int retries_arg;	/**< @brief Max number of times to try to send packet if send fails (default='10').  */
  char * retries_orig;	/**< @brief Max number of times to try to send packet if send fails original value given at command line.  */
  const char *retries_help; /**< @brief Max number of times to try to send packet if send fails help description.  */
  const char *dryrun_help; /**< @brief Don't actually send packets help description.  */
  const char *fast_dryrun_help; /**< @brief Don't actually send packets, print out a binary representation probe dst IP and dst Port. Used for faster integration tests, not for general use. help description.  */
  int shards_arg;	/**< @brief Set the total number of shards (default='1').  */
  char * shards_orig;	/**< @brief Set the total number of shards original value given at command line.  */
  const char *shards_help; /**< @brief Set the total number of shards help description.  */
  int shard_arg;	/**< @brief Set which shard this scan is (0 indexed) (default='0').  */
  char * shard_orig;	/**< @brief Set which shard this scan is (0 indexed) original value given at command line.  */
  const char *shard_help; /**< @brief Set which shard this scan is (0 indexed) help description.  */
  char * source_port_arg;	/**< @brief Source port(s) for scan packets.  */
  char * source_port_orig;	/**< @brief Source port(s) for scan packets original value given at command line.  */
  const char *source_port_help; /**< @brief Source port(s) for scan packets help description.  */
  char * validate_source_port_arg;	/**< @brief Override to validate if probe responses have a valid src port corresponding to sent probe's dst port. \"enable\" or \"disable\".  */
  char * validate_source_port_orig;	/**< @brief Override to validate if probe responses have a valid src port corresponding to sent probe's dst port. \"enable\" or \"disable\" original value given at command line.  */
  const char *validate_source_port_help; /**< @brief Override to validate if probe responses have a valid src port corresponding to sent probe's dst port. \"enable\" or \"disable\" help description.  */
  char * source_ip_arg;	/**< @brief Source address(es) for scan packets.  */
  char * source_ip_orig;	/**< @brief Source address(es) for scan packets original value given at command line.  */
  const char *source_ip_help; /**< @brief Source address(es) for scan packets help description.  */
  char * gateway_mac_arg;	/**< @brief Specify gateway MAC address.  */
  char * gateway_mac_orig;	/**< @brief Specify gateway MAC address original value given at command line.  */
  const char *gateway_mac_help; /**< @brief Specify gateway MAC address help description.  */
  char * source_mac_arg;	/**< @brief Source MAC address.  */
  char * source_mac_orig;	/**< @brief Source MAC address original value given at command line.  */
  const char *source_mac_help; /**< @brief Source MAC address help description.  */
  char * interface_arg;	/**< @brief Specify network interface to use.  */
  char * interface_orig;	/**< @brief Specify network interface to use original value given at command line.  */
  const char *interface_help; /**< @brief Specify network interface to use help description.  */
  const char *iplayer_help; /**< @brief Sends IP packets instead of Ethernet (for VPNs) help description.  */
  char * netmap_wait_ping_arg;	/**< @brief Wait for IP to respond to ping before commencing scan (netmap only).  */
  char * netmap_wait_ping_orig;	/**< @brief Wait for IP to respond to ping before commencing scan (netmap only) original value given at command line.  */
  const char *netmap_wait_ping_help; /**< @brief Wait for IP to respond to ping before commencing scan (netmap only) help description.  */
  char * probe_module_arg;	/**< @brief Select probe module (default='tcp_synscan').  */
  char * probe_module_orig;	/**< @brief Select probe module original value given at command line.  */
  const char *probe_module_help; /**< @brief Select probe module help description.  */
  char * probe_args_arg;	/**< @brief Arguments to pass to probe module.  */
  char * probe_args_orig;	/**< @brief Arguments to pass to probe module original value given at command line.  */
  const char *probe_args_help; /**< @brief Arguments to pass to probe module help description.  */
  int probe_ttl_arg;	/**< @brief Set TTL value for probe IP packets (default='64').  */
  char * probe_ttl_orig;	/**< @brief Set TTL value for probe IP packets original value given at command line.  */
  const char *probe_ttl_help; /**< @brief Set TTL value for probe IP packets help description.  */
  const char *list_probe_modules_help; /**< @brief List available probe modules help description.  */
  char * output_fields_arg;	/**< @brief Fields that should be output in result set.  */
  char * output_fields_orig;	/**< @brief Fields that should be output in result set original value given at command line.  */
  const char *output_fields_help; /**< @brief Fields that should be output in result set help description.  */
  char * output_module_arg;	/**< @brief Select output module.  */
  char * output_module_orig;	/**< @brief Select output module original value given at command line.  */
  const char *output_module_help; /**< @brief Select output module help description.  */
  char * output_args_arg;	/**< @brief Arguments to pass to output module.  */
  char * output_args_orig;	/**< @brief Arguments to pass to output module original value given at command line.  */
  const char *output_args_help; /**< @brief Arguments to pass to output module help description.  */
  char * output_filter_arg;	/**< @brief Specify a filter over the response fields to limit what responses get sent to the output module.  */
  char * output_filter_orig;	/**< @brief Specify a filter over the response fields to limit what responses get sent to the output module original value given at command line.  */
  const char *output_filter_help; /**< @brief Specify a filter over the response fields to limit what responses get sent to the output module help description.  */
  const char *list_output_modules_help; /**< @brief List available output modules help description.  */
  const char *list_output_fields_help; /**< @brief List all fields that can be output by selected probe module help description.  */
  const char *no_header_row_help; /**< @brief Precludes outputting any header rows in data (e.g., CSV headers) help description.  */
  char * dedup_method_arg;	/**< @brief Specifies how response deduplication should be performed. Options: default, none, full, window.  */
  char * dedup_method_orig;	/**< @brief Specifies how response deduplication should be performed. Options: default, none, full, window original value given at command line.  */
  const char *dedup_method_help; /**< @brief Specifies how response deduplication should be performed. Options: default, none, full, window help description.  */
  int dedup_window_size_arg;	/**< @brief Specifies window size for how many recent responses to keep in memory for deduplication (default='1000000').  */
  char * dedup_window_size_orig;	/**< @brief Specifies window size for how many recent responses to keep in memory for deduplication original value given at command line.  */
  const char *dedup_window_size_help; /**< @brief Specifies window size for how many recent responses to keep in memory for deduplication help description.  */
  int verbosity_arg;	/**< @brief Level of log detail (0-5) (default='3').  */
  char * verbosity_orig;	/**< @brief Level of log detail (0-5) original value given at command line.  */
  const char *verbosity_help; /**< @brief Level of log detail (0-5) help description.  */
  char * log_file_arg;	/**< @brief Write log entries to file.  */
  char * log_file_orig;	/**< @brief Write log entries to file original value given at command line.  */
  const char *log_file_help; /**< @brief Write log entries to file help description.  */
  char * log_directory_arg;	/**< @brief Write log entries to a timestamped file in this directory.  */
  char * log_directory_orig;	/**< @brief Write log entries to a timestamped file in this directory original value given at command line.  */
  const char *log_directory_help; /**< @brief Write log entries to a timestamped file in this directory help description.  */
  char * metadata_file_arg;	/**< @brief Output file for scan metadata (JSON).  */
  char * metadata_file_orig;	/**< @brief Output file for scan metadata (JSON) original value given at command line.  */
  const char *metadata_file_help; /**< @brief Output file for scan metadata (JSON) help description.  */
  char * status_updates_file_arg;	/**< @brief Write scan progress updates to CSV file.  */
  char * status_updates_file_orig;	/**< @brief Write scan progress updates to CSV file original value given at command line.  */
  const char *status_updates_file_help; /**< @brief Write scan progress updates to CSV file help description.  */
  const char *quiet_help; /**< @brief Do not print status updates help description.  */
  const char *disable_syslog_help; /**< @brief Disables logging messages to syslog help description.  */
  char * notes_arg;	/**< @brief Inject user-specified notes into scan metadata.  */
  char * notes_orig;	/**< @brief Inject user-specified notes into scan metadata original value given at command line.  */
  const char *notes_help; /**< @brief Inject user-specified notes into scan metadata help description.  */
  char * user_metadata_arg;	/**< @brief Inject user-specified JSON metadata into scan metadata.  */
  char * user_metadata_orig;	/**< @brief Inject user-specified JSON metadata into scan metadata original value given at command line.  */
  const char *user_metadata_help; /**< @brief Inject user-specified JSON metadata into scan metadata help description.  */
  char * config_arg;	/**< @brief Read a configuration file, which can specify any of these options (default='/etc/zmap/zmap.conf').  */
  char * config_orig;	/**< @brief Read a configuration file, which can specify any of these options original value given at command line.  */
  const char *config_help; /**< @brief Read a configuration file, which can specify any of these options help description.  */
  int max_sendto_failures_arg;	/**< @brief Maximum NIC sendto failures before scan is aborted (default='-1').  */
  char * max_sendto_failures_orig;	/**< @brief Maximum NIC sendto failures before scan is aborted original value given at command line.  */
  const char *max_sendto_failures_help; /**< @brief Maximum NIC sendto failures before scan is aborted help description.  */
  float min_hitrate_arg;	/**< @brief Minimum hitrate that scan can hit before scan is aborted (default='0.0').  */
  char * min_hitrate_orig;	/**< @brief Minimum hitrate that scan can hit before scan is aborted original value given at command line.  */
  const char *min_hitrate_help; /**< @brief Minimum hitrate that scan can hit before scan is aborted help description.  */
  int sender_threads_arg;	/**< @brief Threads used to send packets (default='4').  */
  char * sender_threads_orig;	/**< @brief Threads used to send packets original value given at command line.  */
  const char *sender_threads_help; /**< @brief Threads used to send packets help description.  */
  char * cores_arg;	/**< @brief Comma-separated list of cores to pin to.  */
  char * cores_orig;	/**< @brief Comma-separated list of cores to pin to original value given at command line.  */
  const char *cores_help; /**< @brief Comma-separated list of cores to pin to help description.  */
  const char *ignore_blocklist_errors_help; /**< @brief Ignore invalid entries in allowlist/blocklist file. help description.  */
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  
  unsigned int target_ports_given ;	/**< @brief Whether target-ports was given.  */
  unsigned int output_file_given ;	/**< @brief Whether output-file was given.  */
  unsigned int blocklist_file_given ;	/**< @brief Whether blocklist-file was given.  */
  unsigned int allowlist_file_given ;	/**< @brief Whether allowlist-file was given.  */
  unsigned int list_of_ips_file_given ;	/**< @brief Whether list-of-ips-file was given.  */
  unsigned int rate_given ;	/**< @brief Whether rate was given.  */
  unsigned int bandwidth_given ;	/**< @brief Whether bandwidth was given.  */
  unsigned int batch_given ;	/**< @brief Whether batch was given.  */
  unsigned int max_targets_given ;	/**< @brief Whether max-targets was given.  */
  unsigned int max_runtime_given ;	/**< @brief Whether max-runtime was given.  */
  unsigned int max_results_given ;	/**< @brief Whether max-results was given.  */
  unsigned int probes_given ;	/**< @brief Whether probes was given.  */
  unsigned int cooldown_time_given ;	/**< @brief Whether cooldown-time was given.  */
  unsigned int seed_given ;	/**< @brief Whether seed was given.  */
  unsigned int retries_given ;	/**< @brief Whether retries was given.  */
  unsigned int dryrun_given ;	/**< @brief Whether dryrun was given.  */
  unsigned int fast_dryrun_given ;	/**< @brief Whether fast-dryrun was given.  */
  unsigned int shards_given ;	/**< @brief Whether shards was given.  */
  unsigned int shard_given ;	/**< @brief Whether shard was given.  */
  unsigned int source_port_given ;	/**< @brief Whether source-port was given.  */
  unsigned int validate_source_port_given ;	/**< @brief Whether validate-source-port was given.  */
  unsigned int source_ip_given ;	/**< @brief Whether source-ip was given.  */
  unsigned int gateway_mac_given ;	/**< @brief Whether gateway-mac was given.  */
  unsigned int source_mac_given ;	/**< @brief Whether source-mac was given.  */
  unsigned int interface_given ;	/**< @brief Whether interface was given.  */
  unsigned int iplayer_given ;	/**< @brief Whether iplayer was given.  */
  unsigned int netmap_wait_ping_given ;	/**< @brief Whether netmap-wait-ping was given.  */
  unsigned int probe_module_given ;	/**< @brief Whether probe-module was given.  */
  unsigned int probe_args_given ;	/**< @brief Whether probe-args was given.  */
  unsigned int probe_ttl_given ;	/**< @brief Whether probe-ttl was given.  */
  unsigned int list_probe_modules_given ;	/**< @brief Whether list-probe-modules was given.  */
  unsigned int output_fields_given ;	/**< @brief Whether output-fields was given.  */
  unsigned int output_module_given ;	/**< @brief Whether output-module was given.  */
  unsigned int output_args_given ;	/**< @brief Whether output-args was given.  */
  unsigned int output_filter_given ;	/**< @brief Whether output-filter was given.  */
  unsigned int list_output_modules_given ;	/**< @brief Whether list-output-modules was given.  */
  unsigned int list_output_fields_given ;	/**< @brief Whether list-output-fields was given.  */
  unsigned int no_header_row_given ;	/**< @brief Whether no-header-row was given.  */
  unsigned int dedup_method_given ;	/**< @brief Whether dedup-method was given.  */
  unsigned int dedup_window_size_given ;	/**< @brief Whether dedup-window-size was given.  */
  unsigned int verbosity_given ;	/**< @brief Whether verbosity was given.  */
  unsigned int log_file_given ;	/**< @brief Whether log-file was given.  */
  unsigned int log_directory_given ;	/**< @brief Whether log-directory was given.  */
  unsigned int metadata_file_given ;	/**< @brief Whether metadata-file was given.  */
  unsigned int status_updates_file_given ;	/**< @brief Whether status-updates-file was given.  */
  unsigned int quiet_given ;	/**< @brief Whether quiet was given.  */
  unsigned int disable_syslog_given ;	/**< @brief Whether disable-syslog was given.  */
  unsigned int notes_given ;	/**< @brief Whether notes was given.  */
  unsigned int user_metadata_given ;	/**< @brief Whether user-metadata was given.  */
  unsigned int config_given ;	/**< @brief Whether config was given.  */
  unsigned int max_sendto_failures_given ;	/**< @brief Whether max-sendto-failures was given.  */
  unsigned int min_hitrate_given ;	/**< @brief Whether min-hitrate was given.  */
  unsigned int sender_threads_given ;	/**< @brief Whether sender-threads was given.  */
  unsigned int cores_given ;	/**< @brief Whether cores was given.  */
  unsigned int ignore_blocklist_errors_given ;	/**< @brief Whether ignore-blocklist-errors was given.  */
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */

  char **inputs ; /**< @brief unnamed options (options without names) */
  unsigned inputs_num ; /**< @brief unnamed options number */
} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief the description string of the program */
extern const char *gengetopt_args_info_description;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * The config file parser (deprecated version)
 * @param filename the name of the config file
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_config_file() instead
 */
int cmdline_parser_configfile (const char *filename,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The config file parser
 * @param filename the name of the config file
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_config_file (const char *filename,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* ZOPT_H */
