//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.10
//
// <auto-generated>
//
// Generated from file `Registry.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef ICEGRID_API_EXPORTS
#   define ICEGRID_API_EXPORTS
#endif
#include <IceGrid/Registry.h>
#include <IceUtil/PushDisableWarnings.h>
#include <Ice/LocalException.h>
#include <Ice/ValueFactory.h>
#include <Ice/OutgoingAsync.h>
#include <Ice/InputStream.h>
#include <Ice/OutputStream.h>
#include <Ice/LocalException.h>
#include <Ice/SlicedData.h>
#include <IceUtil/PopDisableWarnings.h>

#if defined(_MSC_VER)
#   pragma warning(disable:4458) // declaration of ... hides class member
#elif defined(__clang__)
#   pragma clang diagnostic ignored "-Wshadow"
#elif defined(__GNUC__)
#   pragma GCC diagnostic ignored "-Wshadow"
#endif

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 10
#       error Ice patch level mismatch!
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace
{

const ::std::string iceC_IceGrid_Query_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::Query"
};
const ::std::string iceC_IceGrid_Query_ops[] =
{
    "findAllObjectsByType",
    "findAllReplicas",
    "findObjectById",
    "findObjectByType",
    "findObjectByTypeOnLeastLoadedNode",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};
const ::std::string iceC_IceGrid_Query_findObjectById_name = "findObjectById";
const ::std::string iceC_IceGrid_Query_findObjectByType_name = "findObjectByType";
const ::std::string iceC_IceGrid_Query_findObjectByTypeOnLeastLoadedNode_name = "findObjectByTypeOnLeastLoadedNode";
const ::std::string iceC_IceGrid_Query_findAllObjectsByType_name = "findAllObjectsByType";
const ::std::string iceC_IceGrid_Query_findAllReplicas_name = "findAllReplicas";

const ::std::string iceC_IceGrid_Registry_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::Registry"
};
const ::std::string iceC_IceGrid_Registry_ops[] =
{
    "createAdminSession",
    "createAdminSessionFromSecureConnection",
    "createSession",
    "createSessionFromSecureConnection",
    "getACMTimeout",
    "getSessionTimeout",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};
const ::std::string iceC_IceGrid_Registry_createSession_name = "createSession";
const ::std::string iceC_IceGrid_Registry_createAdminSession_name = "createAdminSession";
const ::std::string iceC_IceGrid_Registry_createSessionFromSecureConnection_name = "createSessionFromSecureConnection";
const ::std::string iceC_IceGrid_Registry_createAdminSessionFromSecureConnection_name = "createAdminSessionFromSecureConnection";
const ::std::string iceC_IceGrid_Registry_getSessionTimeout_name = "getSessionTimeout";
const ::std::string iceC_IceGrid_Registry_getACMTimeout_name = "getACMTimeout";

const ::std::string iceC_IceGrid_Locator_ids[3] =
{
    "::Ice::Locator",
    "::Ice::Object",
    "::IceGrid::Locator"
};
const ::std::string iceC_IceGrid_Locator_ops[] =
{
    "findAdapterById",
    "findObjectById",
    "getLocalQuery",
    "getLocalRegistry",
    "getRegistry",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};
const ::std::string iceC_IceGrid_Locator_getLocalRegistry_name = "getLocalRegistry";
const ::std::string iceC_IceGrid_Locator_getLocalQuery_name = "getLocalQuery";

}

bool
IceGrid::Query::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_Query_ids, iceC_IceGrid_Query_ids + 2, s);
}

::std::vector<::std::string>
IceGrid::Query::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceGrid_Query_ids[0], &iceC_IceGrid_Query_ids[2]);
}

::std::string
IceGrid::Query::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::Query::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::Query";
    return typeId;
}

/// \cond INTERNAL
bool
IceGrid::Query::_iceD_findObjectById(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::Ice::Identity iceP_id;
    istr->readAll(iceP_id);
    inS.endReadParams();
    ::std::shared_ptr<::Ice::ObjectPrx> ret = this->findObjectById(::std::move(iceP_id), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Query::_iceD_findObjectByType(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_type;
    istr->readAll(iceP_type);
    inS.endReadParams();
    ::std::shared_ptr<::Ice::ObjectPrx> ret = this->findObjectByType(::std::move(iceP_type), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Query::_iceD_findObjectByTypeOnLeastLoadedNode(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_type;
    LoadSample iceP_sample;
    istr->readAll(iceP_type, iceP_sample);
    inS.endReadParams();
    ::std::shared_ptr<::Ice::ObjectPrx> ret = this->findObjectByTypeOnLeastLoadedNode(::std::move(iceP_type), iceP_sample, current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Query::_iceD_findAllObjectsByType(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_type;
    istr->readAll(iceP_type);
    inS.endReadParams();
    ::Ice::ObjectProxySeq ret = this->findAllObjectsByType(::std::move(iceP_type), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Query::_iceD_findAllReplicas(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::shared_ptr<::Ice::ObjectPrx> iceP_proxy;
    istr->readAll(iceP_proxy);
    inS.endReadParams();
    ::Ice::ObjectProxySeq ret = this->findAllReplicas(::std::move(iceP_proxy), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Query::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_Query_ops, iceC_IceGrid_Query_ops + 9, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_Query_ops)
    {
        case 0:
        {
            return _iceD_findAllObjectsByType(in, current);
        }
        case 1:
        {
            return _iceD_findAllReplicas(in, current);
        }
        case 2:
        {
            return _iceD_findObjectById(in, current);
        }
        case 3:
        {
            return _iceD_findObjectByType(in, current);
        }
        case 4:
        {
            return _iceD_findObjectByTypeOnLeastLoadedNode(in, current);
        }
        case 5:
        {
            return _iceD_ice_id(in, current);
        }
        case 6:
        {
            return _iceD_ice_ids(in, current);
        }
        case 7:
        {
            return _iceD_ice_isA(in, current);
        }
        case 8:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
IceGrid::Registry::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_Registry_ids, iceC_IceGrid_Registry_ids + 2, s);
}

::std::vector<::std::string>
IceGrid::Registry::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceGrid_Registry_ids[0], &iceC_IceGrid_Registry_ids[2]);
}

::std::string
IceGrid::Registry::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::Registry::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::Registry";
    return typeId;
}

/// \cond INTERNAL
bool
IceGrid::Registry::_iceD_createSession(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_userId;
    ::std::string iceP_password;
    istr->readAll(iceP_userId, iceP_password);
    inS.endReadParams();
    ::std::shared_ptr<SessionPrx> ret = this->createSession(::std::move(iceP_userId), ::std::move(iceP_password), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Registry::_iceD_createAdminSession(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_userId;
    ::std::string iceP_password;
    istr->readAll(iceP_userId, iceP_password);
    inS.endReadParams();
    ::std::shared_ptr<AdminSessionPrx> ret = this->createAdminSession(::std::move(iceP_userId), ::std::move(iceP_password), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Registry::_iceD_createSessionFromSecureConnection(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    inS.readEmptyParams();
    ::std::shared_ptr<SessionPrx> ret = this->createSessionFromSecureConnection(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Registry::_iceD_createAdminSessionFromSecureConnection(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    inS.readEmptyParams();
    ::std::shared_ptr<AdminSessionPrx> ret = this->createAdminSessionFromSecureConnection(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Registry::_iceD_getSessionTimeout(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    int ret = this->getSessionTimeout(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Registry::_iceD_getACMTimeout(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    int ret = this->getACMTimeout(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Registry::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_Registry_ops, iceC_IceGrid_Registry_ops + 10, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_Registry_ops)
    {
        case 0:
        {
            return _iceD_createAdminSession(in, current);
        }
        case 1:
        {
            return _iceD_createAdminSessionFromSecureConnection(in, current);
        }
        case 2:
        {
            return _iceD_createSession(in, current);
        }
        case 3:
        {
            return _iceD_createSessionFromSecureConnection(in, current);
        }
        case 4:
        {
            return _iceD_getACMTimeout(in, current);
        }
        case 5:
        {
            return _iceD_getSessionTimeout(in, current);
        }
        case 6:
        {
            return _iceD_ice_id(in, current);
        }
        case 7:
        {
            return _iceD_ice_ids(in, current);
        }
        case 8:
        {
            return _iceD_ice_isA(in, current);
        }
        case 9:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
IceGrid::Locator::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_Locator_ids, iceC_IceGrid_Locator_ids + 3, s);
}

::std::vector<::std::string>
IceGrid::Locator::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceGrid_Locator_ids[0], &iceC_IceGrid_Locator_ids[3]);
}

::std::string
IceGrid::Locator::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::Locator::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::Locator";
    return typeId;
}

/// \cond INTERNAL
bool
IceGrid::Locator::_iceD_getLocalRegistry(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::std::shared_ptr<RegistryPrx> ret = this->getLocalRegistry(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Locator::_iceD_getLocalQuery(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::std::shared_ptr<QueryPrx> ret = this->getLocalQuery(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Locator::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_Locator_ops, iceC_IceGrid_Locator_ops + 9, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_Locator_ops)
    {
        case 0:
        {
            return _iceD_findAdapterById(in, current);
        }
        case 1:
        {
            return _iceD_findObjectById(in, current);
        }
        case 2:
        {
            return _iceD_getLocalQuery(in, current);
        }
        case 3:
        {
            return _iceD_getLocalRegistry(in, current);
        }
        case 4:
        {
            return _iceD_getRegistry(in, current);
        }
        case 5:
        {
            return _iceD_ice_id(in, current);
        }
        case 6:
        {
            return _iceD_ice_ids(in, current);
        }
        case 7:
        {
            return _iceD_ice_isA(in, current);
        }
        case 8:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::QueryPrx::_iceI_findObjectById(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>& outAsync, const ::Ice::Identity& iceP_id, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Query_findObjectById_name);
    outAsync->invoke(iceC_IceGrid_Query_findObjectById_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_id);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::QueryPrx::_iceI_findObjectByType(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>& outAsync, const ::std::string& iceP_type, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Query_findObjectByType_name);
    outAsync->invoke(iceC_IceGrid_Query_findObjectByType_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_type);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::QueryPrx::_iceI_findObjectByTypeOnLeastLoadedNode(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>& outAsync, const ::std::string& iceP_type, LoadSample iceP_sample, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Query_findObjectByTypeOnLeastLoadedNode_name);
    outAsync->invoke(iceC_IceGrid_Query_findObjectByTypeOnLeastLoadedNode_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_type, iceP_sample);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::QueryPrx::_iceI_findAllObjectsByType(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::ObjectProxySeq>>& outAsync, const ::std::string& iceP_type, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Query_findAllObjectsByType_name);
    outAsync->invoke(iceC_IceGrid_Query_findAllObjectsByType_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_type);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::QueryPrx::_iceI_findAllReplicas(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::ObjectProxySeq>>& outAsync, const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_proxy, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Query_findAllReplicas_name);
    outAsync->invoke(iceC_IceGrid_Query_findAllReplicas_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_proxy);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceGrid::QueryPrx::_newInstance() const
{
    return ::IceInternal::createProxy<QueryPrx>();
}
/// \endcond

const ::std::string&
IceGrid::QueryPrx::ice_staticId()
{
    return Query::ice_staticId();
}

/// \cond INTERNAL
void
IceGrid::RegistryPrx::_iceI_createSession(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::SessionPrx>>>& outAsync, const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Registry_createSession_name);
    outAsync->invoke(iceC_IceGrid_Registry_createSession_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_userId, iceP_password);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const PermissionDeniedException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::RegistryPrx::_iceI_createAdminSession(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::AdminSessionPrx>>>& outAsync, const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Registry_createAdminSession_name);
    outAsync->invoke(iceC_IceGrid_Registry_createAdminSession_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_userId, iceP_password);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const PermissionDeniedException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::RegistryPrx::_iceI_createSessionFromSecureConnection(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::SessionPrx>>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Registry_createSessionFromSecureConnection_name);
    outAsync->invoke(iceC_IceGrid_Registry_createSessionFromSecureConnection_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const PermissionDeniedException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::RegistryPrx::_iceI_createAdminSessionFromSecureConnection(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::AdminSessionPrx>>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Registry_createAdminSessionFromSecureConnection_name);
    outAsync->invoke(iceC_IceGrid_Registry_createAdminSessionFromSecureConnection_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const PermissionDeniedException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::RegistryPrx::_iceI_getSessionTimeout(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Registry_getSessionTimeout_name);
    outAsync->invoke(iceC_IceGrid_Registry_getSessionTimeout_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::RegistryPrx::_iceI_getACMTimeout(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Registry_getACMTimeout_name);
    outAsync->invoke(iceC_IceGrid_Registry_getACMTimeout_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceGrid::RegistryPrx::_newInstance() const
{
    return ::IceInternal::createProxy<RegistryPrx>();
}
/// \endcond

const ::std::string&
IceGrid::RegistryPrx::ice_staticId()
{
    return Registry::ice_staticId();
}

/// \cond INTERNAL
void
IceGrid::LocatorPrx::_iceI_getLocalRegistry(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::RegistryPrx>>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Locator_getLocalRegistry_name);
    outAsync->invoke(iceC_IceGrid_Locator_getLocalRegistry_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::LocatorPrx::_iceI_getLocalQuery(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::QueryPrx>>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Locator_getLocalQuery_name);
    outAsync->invoke(iceC_IceGrid_Locator_getLocalQuery_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceGrid::LocatorPrx::_newInstance() const
{
    return ::IceInternal::createProxy<LocatorPrx>();
}
/// \endcond

const ::std::string&
IceGrid::LocatorPrx::ice_staticId()
{
    return Locator::ice_staticId();
}

#else // C++98 mapping

namespace
{

const ::std::string iceC_IceGrid_Query_findObjectById_name = "findObjectById";

const ::std::string iceC_IceGrid_Query_findObjectByType_name = "findObjectByType";

const ::std::string iceC_IceGrid_Query_findObjectByTypeOnLeastLoadedNode_name = "findObjectByTypeOnLeastLoadedNode";

const ::std::string iceC_IceGrid_Query_findAllObjectsByType_name = "findAllObjectsByType";

const ::std::string iceC_IceGrid_Query_findAllReplicas_name = "findAllReplicas";

const ::std::string iceC_IceGrid_Registry_createSession_name = "createSession";

const ::std::string iceC_IceGrid_Registry_createAdminSession_name = "createAdminSession";

const ::std::string iceC_IceGrid_Registry_createSessionFromSecureConnection_name = "createSessionFromSecureConnection";

const ::std::string iceC_IceGrid_Registry_createAdminSessionFromSecureConnection_name = "createAdminSessionFromSecureConnection";

const ::std::string iceC_IceGrid_Registry_getSessionTimeout_name = "getSessionTimeout";

const ::std::string iceC_IceGrid_Registry_getACMTimeout_name = "getACMTimeout";

const ::std::string iceC_IceGrid_Locator_getLocalRegistry_name = "getLocalRegistry";

const ::std::string iceC_IceGrid_Locator_getLocalQuery_name = "getLocalQuery";

}

/// \cond INTERNAL
ICEGRID_API ::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(Query* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< Query>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new Query;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceGrid::Query::_iceI_begin_findObjectById(const ::Ice::Identity& iceP_id, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Query_findObjectById_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Query_findObjectById_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Query_findObjectById_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_id);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Query_findObjectById_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::ObjectPrx
IceProxy::IceGrid::Query::end_findObjectById(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Query_findObjectById_name);
    ::Ice::ObjectPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Query::_iceI_begin_findObjectByType(const ::std::string& iceP_type, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Query_findObjectByType_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Query_findObjectByType_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Query_findObjectByType_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_type);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Query_findObjectByType_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::ObjectPrx
IceProxy::IceGrid::Query::end_findObjectByType(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Query_findObjectByType_name);
    ::Ice::ObjectPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Query::_iceI_begin_findObjectByTypeOnLeastLoadedNode(const ::std::string& iceP_type, ::IceGrid::LoadSample iceP_sample, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Query_findObjectByTypeOnLeastLoadedNode_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Query_findObjectByTypeOnLeastLoadedNode_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Query_findObjectByTypeOnLeastLoadedNode_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_type);
        ostr->write(iceP_sample);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Query_findObjectByTypeOnLeastLoadedNode_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::ObjectPrx
IceProxy::IceGrid::Query::end_findObjectByTypeOnLeastLoadedNode(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Query_findObjectByTypeOnLeastLoadedNode_name);
    ::Ice::ObjectPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Query::_iceI_begin_findAllObjectsByType(const ::std::string& iceP_type, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Query_findAllObjectsByType_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Query_findAllObjectsByType_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Query_findAllObjectsByType_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_type);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Query_findAllObjectsByType_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::ObjectProxySeq
IceProxy::IceGrid::Query::end_findAllObjectsByType(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Query_findAllObjectsByType_name);
    ::Ice::ObjectProxySeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Query::_iceI_begin_findAllReplicas(const ::Ice::ObjectPrx& iceP_proxy, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Query_findAllReplicas_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Query_findAllReplicas_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Query_findAllReplicas_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_proxy);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Query_findAllReplicas_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::ObjectProxySeq
IceProxy::IceGrid::Query::end_findAllReplicas(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Query_findAllReplicas_name);
    ::Ice::ObjectProxySeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::Query::_newInstance() const
{
    return new Query;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::Query::ice_staticId()
{
    return ::IceGrid::Query::ice_staticId();
}

/// \cond INTERNAL
ICEGRID_API ::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(Registry* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< Registry>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new Registry;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceGrid::Registry::_iceI_begin_createSession(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Registry_createSession_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Registry_createSession_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Registry_createSession_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_userId);
        ostr->write(iceP_password);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Registry_createSession_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::SessionPrx
IceProxy::IceGrid::Registry::end_createSession(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Registry_createSession_name);
    ::IceGrid::SessionPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::PermissionDeniedException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Registry::_iceI_begin_createAdminSession(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Registry_createAdminSession_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Registry_createAdminSession_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Registry_createAdminSession_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_userId);
        ostr->write(iceP_password);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Registry_createAdminSession_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::AdminSessionPrx
IceProxy::IceGrid::Registry::end_createAdminSession(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Registry_createAdminSession_name);
    ::IceGrid::AdminSessionPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::PermissionDeniedException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Registry::_iceI_begin_createSessionFromSecureConnection(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Registry_createSessionFromSecureConnection_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Registry_createSessionFromSecureConnection_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Registry_createSessionFromSecureConnection_name, ::Ice::Normal, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Registry_createSessionFromSecureConnection_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::SessionPrx
IceProxy::IceGrid::Registry::end_createSessionFromSecureConnection(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Registry_createSessionFromSecureConnection_name);
    ::IceGrid::SessionPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::PermissionDeniedException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Registry::_iceI_begin_createAdminSessionFromSecureConnection(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Registry_createAdminSessionFromSecureConnection_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Registry_createAdminSessionFromSecureConnection_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Registry_createAdminSessionFromSecureConnection_name, ::Ice::Normal, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Registry_createAdminSessionFromSecureConnection_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::AdminSessionPrx
IceProxy::IceGrid::Registry::end_createAdminSessionFromSecureConnection(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Registry_createAdminSessionFromSecureConnection_name);
    ::IceGrid::AdminSessionPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::PermissionDeniedException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Registry::_iceI_begin_getSessionTimeout(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Registry_getSessionTimeout_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Registry_getSessionTimeout_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Registry_getSessionTimeout_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Registry_getSessionTimeout_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::Int
IceProxy::IceGrid::Registry::end_getSessionTimeout(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Registry_getSessionTimeout_name);
    ::Ice::Int ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Registry::_iceI_begin_getACMTimeout(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Registry_getACMTimeout_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Registry_getACMTimeout_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Registry_getACMTimeout_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Registry_getACMTimeout_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::Int
IceProxy::IceGrid::Registry::end_getACMTimeout(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Registry_getACMTimeout_name);
    ::Ice::Int ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::Registry::_newInstance() const
{
    return new Registry;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::Registry::ice_staticId()
{
    return ::IceGrid::Registry::ice_staticId();
}

/// \cond INTERNAL
ICEGRID_API ::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(Locator* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< Locator>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new Locator;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceGrid::Locator::_iceI_begin_getLocalRegistry(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Locator_getLocalRegistry_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Locator_getLocalRegistry_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Locator_getLocalRegistry_name, ::Ice::Idempotent, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Locator_getLocalRegistry_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::RegistryPrx
IceProxy::IceGrid::Locator::end_getLocalRegistry(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Locator_getLocalRegistry_name);
    ::IceGrid::RegistryPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Locator::_iceI_begin_getLocalQuery(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Locator_getLocalQuery_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Locator_getLocalQuery_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Locator_getLocalQuery_name, ::Ice::Idempotent, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Locator_getLocalQuery_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::QueryPrx
IceProxy::IceGrid::Locator::end_getLocalQuery(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Locator_getLocalQuery_name);
    ::IceGrid::QueryPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::Locator::_newInstance() const
{
    return new Locator;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::Locator::ice_staticId()
{
    return ::IceGrid::Locator::ice_staticId();
}

IceGrid::Query::~Query()
{
}

/// \cond INTERNAL
ICEGRID_API ::Ice::Object* IceGrid::upCast(Query* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceGrid_Query_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::Query"
};

}

bool
IceGrid::Query::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_Query_ids, iceC_IceGrid_Query_ids + 2, s);
}

::std::vector< ::std::string>
IceGrid::Query::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_Query_ids[0], &iceC_IceGrid_Query_ids[2]);
}

const ::std::string&
IceGrid::Query::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::Query::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::Query";
    return typeId;
#else
    return iceC_IceGrid_Query_ids[1];
#endif
}

/// \cond INTERNAL
bool
IceGrid::Query::_iceD_findObjectById(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::Ice::Identity iceP_id;
    istr->read(iceP_id);
    inS.endReadParams();
    ::Ice::ObjectPrx ret = this->findObjectById(iceP_id, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Query::_iceD_findObjectByType(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_type;
    istr->read(iceP_type);
    inS.endReadParams();
    ::Ice::ObjectPrx ret = this->findObjectByType(iceP_type, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Query::_iceD_findObjectByTypeOnLeastLoadedNode(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_type;
    LoadSample iceP_sample;
    istr->read(iceP_type);
    istr->read(iceP_sample);
    inS.endReadParams();
    ::Ice::ObjectPrx ret = this->findObjectByTypeOnLeastLoadedNode(iceP_type, iceP_sample, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Query::_iceD_findAllObjectsByType(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_type;
    istr->read(iceP_type);
    inS.endReadParams();
    ::Ice::ObjectProxySeq ret = this->findAllObjectsByType(iceP_type, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Query::_iceD_findAllReplicas(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::Ice::ObjectPrx iceP_proxy;
    istr->read(iceP_proxy);
    inS.endReadParams();
    ::Ice::ObjectProxySeq ret = this->findAllReplicas(iceP_proxy, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceGrid_Query_all[] =
{
    "findAllObjectsByType",
    "findAllReplicas",
    "findObjectById",
    "findObjectByType",
    "findObjectByTypeOnLeastLoadedNode",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};

}

/// \cond INTERNAL
bool
IceGrid::Query::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_Query_all, iceC_IceGrid_Query_all + 9, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_Query_all)
    {
        case 0:
        {
            return _iceD_findAllObjectsByType(in, current);
        }
        case 1:
        {
            return _iceD_findAllReplicas(in, current);
        }
        case 2:
        {
            return _iceD_findObjectById(in, current);
        }
        case 3:
        {
            return _iceD_findObjectByType(in, current);
        }
        case 4:
        {
            return _iceD_findObjectByTypeOnLeastLoadedNode(in, current);
        }
        case 5:
        {
            return _iceD_ice_id(in, current);
        }
        case 6:
        {
            return _iceD_ice_ids(in, current);
        }
        case 7:
        {
            return _iceD_ice_isA(in, current);
        }
        case 8:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceGrid::Query::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< Query, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::Query::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< Query, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(QueryPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = QueryPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(Query::ice_staticId(), v);
    }
}
/// \endcond

IceGrid::Registry::~Registry()
{
}

/// \cond INTERNAL
ICEGRID_API ::Ice::Object* IceGrid::upCast(Registry* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceGrid_Registry_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::Registry"
};

}

bool
IceGrid::Registry::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_Registry_ids, iceC_IceGrid_Registry_ids + 2, s);
}

::std::vector< ::std::string>
IceGrid::Registry::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_Registry_ids[0], &iceC_IceGrid_Registry_ids[2]);
}

const ::std::string&
IceGrid::Registry::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::Registry::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::Registry";
    return typeId;
#else
    return iceC_IceGrid_Registry_ids[1];
#endif
}

/// \cond INTERNAL
bool
IceGrid::Registry::_iceD_createSession(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_userId;
    ::std::string iceP_password;
    istr->read(iceP_userId);
    istr->read(iceP_password);
    inS.endReadParams();
    SessionPrx ret = this->createSession(iceP_userId, iceP_password, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Registry::_iceD_createAdminSession(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_userId;
    ::std::string iceP_password;
    istr->read(iceP_userId);
    istr->read(iceP_password);
    inS.endReadParams();
    AdminSessionPrx ret = this->createAdminSession(iceP_userId, iceP_password, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Registry::_iceD_createSessionFromSecureConnection(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    inS.readEmptyParams();
    SessionPrx ret = this->createSessionFromSecureConnection(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Registry::_iceD_createAdminSessionFromSecureConnection(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    inS.readEmptyParams();
    AdminSessionPrx ret = this->createAdminSessionFromSecureConnection(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Registry::_iceD_getSessionTimeout(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::Int ret = this->getSessionTimeout(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Registry::_iceD_getACMTimeout(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::Int ret = this->getACMTimeout(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceGrid_Registry_all[] =
{
    "createAdminSession",
    "createAdminSessionFromSecureConnection",
    "createSession",
    "createSessionFromSecureConnection",
    "getACMTimeout",
    "getSessionTimeout",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};

}

/// \cond INTERNAL
bool
IceGrid::Registry::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_Registry_all, iceC_IceGrid_Registry_all + 10, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_Registry_all)
    {
        case 0:
        {
            return _iceD_createAdminSession(in, current);
        }
        case 1:
        {
            return _iceD_createAdminSessionFromSecureConnection(in, current);
        }
        case 2:
        {
            return _iceD_createSession(in, current);
        }
        case 3:
        {
            return _iceD_createSessionFromSecureConnection(in, current);
        }
        case 4:
        {
            return _iceD_getACMTimeout(in, current);
        }
        case 5:
        {
            return _iceD_getSessionTimeout(in, current);
        }
        case 6:
        {
            return _iceD_ice_id(in, current);
        }
        case 7:
        {
            return _iceD_ice_ids(in, current);
        }
        case 8:
        {
            return _iceD_ice_isA(in, current);
        }
        case 9:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceGrid::Registry::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< Registry, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::Registry::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< Registry, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(RegistryPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = RegistryPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(Registry::ice_staticId(), v);
    }
}
/// \endcond

IceGrid::Locator::~Locator()
{
}

/// \cond INTERNAL
ICEGRID_API ::Ice::Object* IceGrid::upCast(Locator* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceGrid_Locator_ids[3] =
{
    "::Ice::Locator",
    "::Ice::Object",
    "::IceGrid::Locator"
};

}

bool
IceGrid::Locator::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_Locator_ids, iceC_IceGrid_Locator_ids + 3, s);
}

::std::vector< ::std::string>
IceGrid::Locator::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_Locator_ids[0], &iceC_IceGrid_Locator_ids[3]);
}

const ::std::string&
IceGrid::Locator::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::Locator::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::Locator";
    return typeId;
#else
    return iceC_IceGrid_Locator_ids[2];
#endif
}

/// \cond INTERNAL
bool
IceGrid::Locator::_iceD_getLocalRegistry(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    RegistryPrx ret = this->getLocalRegistry(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Locator::_iceD_getLocalQuery(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    QueryPrx ret = this->getLocalQuery(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceGrid_Locator_all[] =
{
    "findAdapterById",
    "findObjectById",
    "getLocalQuery",
    "getLocalRegistry",
    "getRegistry",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};

}

/// \cond INTERNAL
bool
IceGrid::Locator::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_Locator_all, iceC_IceGrid_Locator_all + 9, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_Locator_all)
    {
        case 0:
        {
            return _iceD_findAdapterById(in, current);
        }
        case 1:
        {
            return _iceD_findObjectById(in, current);
        }
        case 2:
        {
            return _iceD_getLocalQuery(in, current);
        }
        case 3:
        {
            return _iceD_getLocalRegistry(in, current);
        }
        case 4:
        {
            return _iceD_getRegistry(in, current);
        }
        case 5:
        {
            return _iceD_ice_id(in, current);
        }
        case 6:
        {
            return _iceD_ice_ids(in, current);
        }
        case 7:
        {
            return _iceD_ice_isA(in, current);
        }
        case 8:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceGrid::Locator::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< Locator, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::Locator::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< Locator, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(LocatorPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = LocatorPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(Locator::ice_staticId(), v);
    }
}
/// \endcond

namespace Ice
{
}

#endif
