//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.10
//
// <auto-generated>
//
// Generated from file `Router.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef GLACIER2_API_EXPORTS
#   define GLACIER2_API_EXPORTS
#endif
#include <Glacier2/Router.h>
#include <IceUtil/PushDisableWarnings.h>
#include <Ice/LocalException.h>
#include <Ice/ValueFactory.h>
#include <Ice/OutgoingAsync.h>
#include <Ice/InputStream.h>
#include <Ice/OutputStream.h>
#include <Ice/LocalException.h>
#include <Ice/SlicedData.h>
#include <IceUtil/PopDisableWarnings.h>

#if defined(_MSC_VER)
#   pragma warning(disable:4458) // declaration of ... hides class member
#elif defined(__clang__)
#   pragma clang diagnostic ignored "-Wshadow"
#elif defined(__GNUC__)
#   pragma GCC diagnostic ignored "-Wshadow"
#endif

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 10
#       error Ice patch level mismatch!
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit<::Glacier2::SessionNotExistException> iceC_Glacier2_SessionNotExistException_init("::Glacier2::SessionNotExistException");

const ::std::string iceC_Glacier2_Router_ids[3] =
{
    "::Glacier2::Router",
    "::Ice::Object",
    "::Ice::Router"
};
const ::std::string iceC_Glacier2_Router_ops[] =
{
    "addProxies",
    "createSession",
    "createSessionFromSecureConnection",
    "destroySession",
    "getACMTimeout",
    "getCategoryForClient",
    "getClientProxy",
    "getServerProxy",
    "getSessionTimeout",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "refreshSession"
};
const ::std::string iceC_Glacier2_Router_getCategoryForClient_name = "getCategoryForClient";
const ::std::string iceC_Glacier2_Router_createSession_name = "createSession";
const ::std::string iceC_Glacier2_Router_createSessionFromSecureConnection_name = "createSessionFromSecureConnection";
const ::std::string iceC_Glacier2_Router_refreshSession_name = "refreshSession";
const ::std::string iceC_Glacier2_Router_destroySession_name = "destroySession";
const ::std::string iceC_Glacier2_Router_getSessionTimeout_name = "getSessionTimeout";
const ::std::string iceC_Glacier2_Router_getACMTimeout_name = "getACMTimeout";

}

Glacier2::SessionNotExistException::~SessionNotExistException()
{
}

const ::std::string&
Glacier2::SessionNotExistException::ice_staticId()
{
    static const ::std::string typeId = "::Glacier2::SessionNotExistException";
    return typeId;
}

bool
Glacier2::Router::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_Glacier2_Router_ids, iceC_Glacier2_Router_ids + 3, s);
}

::std::vector<::std::string>
Glacier2::Router::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_Glacier2_Router_ids[0], &iceC_Glacier2_Router_ids[3]);
}

::std::string
Glacier2::Router::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
Glacier2::Router::ice_staticId()
{
    static const ::std::string typeId = "::Glacier2::Router";
    return typeId;
}

/// \cond INTERNAL
bool
Glacier2::Router::_iceD_getCategoryForClient(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::std::string ret = this->getCategoryForClient(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::Router::_iceD_createSession(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_userId;
    ::std::string iceP_password;
    istr->readAll(iceP_userId, iceP_password);
    inS.endReadParams();
    inS.setFormat(::Ice::FormatType::SlicedFormat);
    auto inA = ::IceInternal::IncomingAsync::create(inS);
    auto responseCB = [inA](const ::std::shared_ptr<SessionPrx>& ret)
    {
        auto ostr = inA->startWriteParams();
        ostr->writeAll(ret);
        inA->endWriteParams();
        inA->completed();
    };
    this->createSessionAsync(::std::move(iceP_userId), ::std::move(iceP_password), responseCB, inA->exception(), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::Router::_iceD_createSessionFromSecureConnection(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    inS.readEmptyParams();
    inS.setFormat(::Ice::FormatType::SlicedFormat);
    auto inA = ::IceInternal::IncomingAsync::create(inS);
    auto responseCB = [inA](const ::std::shared_ptr<SessionPrx>& ret)
    {
        auto ostr = inA->startWriteParams();
        ostr->writeAll(ret);
        inA->endWriteParams();
        inA->completed();
    };
    this->createSessionFromSecureConnectionAsync(responseCB, inA->exception(), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::Router::_iceD_refreshSession(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    inS.readEmptyParams();
    auto inA = ::IceInternal::IncomingAsync::create(inS);
    this->refreshSessionAsync(inA->response(), inA->exception(), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::Router::_iceD_destroySession(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    inS.readEmptyParams();
    this->destroySession(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::Router::_iceD_getSessionTimeout(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    long long int ret = this->getSessionTimeout(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::Router::_iceD_getACMTimeout(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    int ret = this->getACMTimeout(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::Router::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_Glacier2_Router_ops, iceC_Glacier2_Router_ops + 14, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_Glacier2_Router_ops)
    {
        case 0:
        {
            return _iceD_addProxies(in, current);
        }
        case 1:
        {
            return _iceD_createSession(in, current);
        }
        case 2:
        {
            return _iceD_createSessionFromSecureConnection(in, current);
        }
        case 3:
        {
            return _iceD_destroySession(in, current);
        }
        case 4:
        {
            return _iceD_getACMTimeout(in, current);
        }
        case 5:
        {
            return _iceD_getCategoryForClient(in, current);
        }
        case 6:
        {
            return _iceD_getClientProxy(in, current);
        }
        case 7:
        {
            return _iceD_getServerProxy(in, current);
        }
        case 8:
        {
            return _iceD_getSessionTimeout(in, current);
        }
        case 9:
        {
            return _iceD_ice_id(in, current);
        }
        case 10:
        {
            return _iceD_ice_ids(in, current);
        }
        case 11:
        {
            return _iceD_ice_isA(in, current);
        }
        case 12:
        {
            return _iceD_ice_ping(in, current);
        }
        case 13:
        {
            return _iceD_refreshSession(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::RouterPrx::_iceI_getCategoryForClient(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::string>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_Glacier2_Router_getCategoryForClient_name);
    outAsync->invoke(iceC_Glacier2_Router_getCategoryForClient_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::RouterPrx::_iceI_createSession(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Glacier2::SessionPrx>>>& outAsync, const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_Glacier2_Router_createSession_name);
    outAsync->invoke(iceC_Glacier2_Router_createSession_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::SlicedFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_userId, iceP_password);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const CannotCreateSessionException&)
            {
                throw;
            }
            catch(const PermissionDeniedException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::RouterPrx::_iceI_createSessionFromSecureConnection(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Glacier2::SessionPrx>>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_Glacier2_Router_createSessionFromSecureConnection_name);
    outAsync->invoke(iceC_Glacier2_Router_createSessionFromSecureConnection_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::SlicedFormat, context,
        nullptr,
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const CannotCreateSessionException&)
            {
                throw;
            }
            catch(const PermissionDeniedException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::RouterPrx::_iceI_refreshSession(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_Glacier2_Router_refreshSession_name);
    outAsync->invoke(iceC_Glacier2_Router_refreshSession_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const SessionNotExistException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::RouterPrx::_iceI_destroySession(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_Glacier2_Router_destroySession_name);
    outAsync->invoke(iceC_Glacier2_Router_destroySession_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const SessionNotExistException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::RouterPrx::_iceI_getSessionTimeout(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<long long int>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_Glacier2_Router_getSessionTimeout_name);
    outAsync->invoke(iceC_Glacier2_Router_getSessionTimeout_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::RouterPrx::_iceI_getACMTimeout(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_Glacier2_Router_getACMTimeout_name);
    outAsync->invoke(iceC_Glacier2_Router_getACMTimeout_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
Glacier2::RouterPrx::_newInstance() const
{
    return ::IceInternal::createProxy<RouterPrx>();
}
/// \endcond

const ::std::string&
Glacier2::RouterPrx::ice_staticId()
{
    return Router::ice_staticId();
}

#else // C++98 mapping

namespace
{

const ::std::string iceC_Glacier2_Router_getCategoryForClient_name = "getCategoryForClient";

const ::std::string iceC_Glacier2_Router_createSession_name = "createSession";

const ::std::string iceC_Glacier2_Router_createSessionFromSecureConnection_name = "createSessionFromSecureConnection";

const ::std::string iceC_Glacier2_Router_refreshSession_name = "refreshSession";

const ::std::string iceC_Glacier2_Router_destroySession_name = "destroySession";

const ::std::string iceC_Glacier2_Router_getSessionTimeout_name = "getSessionTimeout";

const ::std::string iceC_Glacier2_Router_getACMTimeout_name = "getACMTimeout";

}

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::Glacier2::SessionNotExistException> iceC_Glacier2_SessionNotExistException_init("::Glacier2::SessionNotExistException");

}

#ifdef ICE_CPP11_COMPILER
Glacier2::SessionNotExistException::~SessionNotExistException()
{
}
#else
Glacier2::SessionNotExistException::~SessionNotExistException() throw()
{
}
#endif

::std::string
Glacier2::SessionNotExistException::ice_id() const
{
    return "::Glacier2::SessionNotExistException";
}

Glacier2::SessionNotExistException*
Glacier2::SessionNotExistException::ice_clone() const
{
    return new SessionNotExistException(*this);
}

void
Glacier2::SessionNotExistException::ice_throw() const
{
    throw *this;
}

/// \cond STREAM
void
Glacier2::SessionNotExistException::_writeImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice("::Glacier2::SessionNotExistException", -1, true);
    ::Ice::StreamWriter< SessionNotExistException, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
Glacier2::SessionNotExistException::_readImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< SessionNotExistException, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

Glacier2::AMD_Router_createSession::~AMD_Router_createSession()
{
}

Glacier2::AMD_Router_createSessionFromSecureConnection::~AMD_Router_createSessionFromSecureConnection()
{
}

Glacier2::AMD_Router_refreshSession::~AMD_Router_refreshSession()
{
}

/// \cond INTERNAL
IceAsync::Glacier2::AMD_Router_createSession::AMD_Router_createSession(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::Glacier2::AMD_Router_createSession::ice_response(const ::Glacier2::SessionPrx& ret)
{
    ::Ice::OutputStream* ostr = startWriteParams();
    ostr->write(ret);
    endWriteParams();
    completed();
}
/// \endcond

/// \cond INTERNAL
IceAsync::Glacier2::AMD_Router_createSessionFromSecureConnection::AMD_Router_createSessionFromSecureConnection(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::Glacier2::AMD_Router_createSessionFromSecureConnection::ice_response(const ::Glacier2::SessionPrx& ret)
{
    ::Ice::OutputStream* ostr = startWriteParams();
    ostr->write(ret);
    endWriteParams();
    completed();
}
/// \endcond

/// \cond INTERNAL
IceAsync::Glacier2::AMD_Router_refreshSession::AMD_Router_refreshSession(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::Glacier2::AMD_Router_refreshSession::ice_response()
{
    writeEmptyParams();
    completed();
}
/// \endcond

/// \cond INTERNAL
GLACIER2_API ::IceProxy::Ice::Object* ::IceProxy::Glacier2::upCast(Router* p) { return p; }

void
::IceProxy::Glacier2::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< Router>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new Router;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::Glacier2::Router::_iceI_begin_getCategoryForClient(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_Glacier2_Router_getCategoryForClient_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Glacier2_Router_getCategoryForClient_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Glacier2_Router_getCategoryForClient_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_Glacier2_Router_getCategoryForClient_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::std::string
IceProxy::Glacier2::Router::end_getCategoryForClient(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Glacier2_Router_getCategoryForClient_name);
    ::std::string ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::Glacier2::Router::_iceI_begin_createSession(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_Glacier2_Router_createSession_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Glacier2_Router_createSession_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Glacier2_Router_createSession_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::SlicedFormat);
        ostr->write(iceP_userId);
        ostr->write(iceP_password);
        result->endWriteParams();
        result->invoke(iceC_Glacier2_Router_createSession_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Glacier2::SessionPrx
IceProxy::Glacier2::Router::end_createSession(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Glacier2_Router_createSession_name);
    ::Glacier2::SessionPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Glacier2::CannotCreateSessionException&)
        {
            throw;
        }
        catch(const ::Glacier2::PermissionDeniedException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::Glacier2::Router::_iceI_begin_createSessionFromSecureConnection(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_Glacier2_Router_createSessionFromSecureConnection_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Glacier2_Router_createSessionFromSecureConnection_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Glacier2_Router_createSessionFromSecureConnection_name, ::Ice::Normal, context);
        result->writeEmptyParams();
        result->invoke(iceC_Glacier2_Router_createSessionFromSecureConnection_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Glacier2::SessionPrx
IceProxy::Glacier2::Router::end_createSessionFromSecureConnection(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Glacier2_Router_createSessionFromSecureConnection_name);
    ::Glacier2::SessionPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Glacier2::CannotCreateSessionException&)
        {
            throw;
        }
        catch(const ::Glacier2::PermissionDeniedException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::Glacier2::Router::_iceI_begin_refreshSession(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_Glacier2_Router_refreshSession_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Glacier2_Router_refreshSession_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Glacier2_Router_refreshSession_name, ::Ice::Normal, context);
        result->writeEmptyParams();
        result->invoke(iceC_Glacier2_Router_refreshSession_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::Glacier2::Router::end_refreshSession(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Glacier2_Router_refreshSession_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Glacier2::SessionNotExistException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::Glacier2::Router::_iceI_begin_destroySession(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_Glacier2_Router_destroySession_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Glacier2_Router_destroySession_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Glacier2_Router_destroySession_name, ::Ice::Normal, context);
        result->writeEmptyParams();
        result->invoke(iceC_Glacier2_Router_destroySession_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::Glacier2::Router::end_destroySession(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Glacier2_Router_destroySession_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Glacier2::SessionNotExistException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::Glacier2::Router::_iceI_begin_getSessionTimeout(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_Glacier2_Router_getSessionTimeout_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Glacier2_Router_getSessionTimeout_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Glacier2_Router_getSessionTimeout_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_Glacier2_Router_getSessionTimeout_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::Long
IceProxy::Glacier2::Router::end_getSessionTimeout(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Glacier2_Router_getSessionTimeout_name);
    ::Ice::Long ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::Glacier2::Router::_iceI_begin_getACMTimeout(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_Glacier2_Router_getACMTimeout_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Glacier2_Router_getACMTimeout_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Glacier2_Router_getACMTimeout_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_Glacier2_Router_getACMTimeout_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::Int
IceProxy::Glacier2::Router::end_getACMTimeout(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Glacier2_Router_getACMTimeout_name);
    ::Ice::Int ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::Glacier2::Router::_newInstance() const
{
    return new Router;
}
/// \endcond

const ::std::string&
IceProxy::Glacier2::Router::ice_staticId()
{
    return ::Glacier2::Router::ice_staticId();
}

Glacier2::Router::~Router()
{
}

/// \cond INTERNAL
GLACIER2_API ::Ice::Object* Glacier2::upCast(Router* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_Glacier2_Router_ids[3] =
{
    "::Glacier2::Router",
    "::Ice::Object",
    "::Ice::Router"
};

}

bool
Glacier2::Router::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_Glacier2_Router_ids, iceC_Glacier2_Router_ids + 3, s);
}

::std::vector< ::std::string>
Glacier2::Router::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_Glacier2_Router_ids[0], &iceC_Glacier2_Router_ids[3]);
}

const ::std::string&
Glacier2::Router::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
Glacier2::Router::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::Glacier2::Router";
    return typeId;
#else
    return iceC_Glacier2_Router_ids[0];
#endif
}

/// \cond INTERNAL
bool
Glacier2::Router::_iceD_getCategoryForClient(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::std::string ret = this->getCategoryForClient(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::Router::_iceD_createSession(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_userId;
    ::std::string iceP_password;
    istr->read(iceP_userId);
    istr->read(iceP_password);
    inS.endReadParams();
    inS.setFormat(::Ice::SlicedFormat);
    this->createSession_async(new IceAsync::Glacier2::AMD_Router_createSession(inS), iceP_userId, iceP_password, current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::Router::_iceD_createSessionFromSecureConnection(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    inS.readEmptyParams();
    inS.setFormat(::Ice::SlicedFormat);
    this->createSessionFromSecureConnection_async(new IceAsync::Glacier2::AMD_Router_createSessionFromSecureConnection(inS), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::Router::_iceD_refreshSession(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    inS.readEmptyParams();
    this->refreshSession_async(new IceAsync::Glacier2::AMD_Router_refreshSession(inS), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::Router::_iceD_destroySession(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    inS.readEmptyParams();
    this->destroySession(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::Router::_iceD_getSessionTimeout(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::Long ret = this->getSessionTimeout(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::Router::_iceD_getACMTimeout(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::Int ret = this->getACMTimeout(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_Glacier2_Router_all[] =
{
    "addProxies",
    "createSession",
    "createSessionFromSecureConnection",
    "destroySession",
    "getACMTimeout",
    "getCategoryForClient",
    "getClientProxy",
    "getServerProxy",
    "getSessionTimeout",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "refreshSession"
};

}

/// \cond INTERNAL
bool
Glacier2::Router::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_Glacier2_Router_all, iceC_Glacier2_Router_all + 14, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_Glacier2_Router_all)
    {
        case 0:
        {
            return _iceD_addProxies(in, current);
        }
        case 1:
        {
            return _iceD_createSession(in, current);
        }
        case 2:
        {
            return _iceD_createSessionFromSecureConnection(in, current);
        }
        case 3:
        {
            return _iceD_destroySession(in, current);
        }
        case 4:
        {
            return _iceD_getACMTimeout(in, current);
        }
        case 5:
        {
            return _iceD_getCategoryForClient(in, current);
        }
        case 6:
        {
            return _iceD_getClientProxy(in, current);
        }
        case 7:
        {
            return _iceD_getServerProxy(in, current);
        }
        case 8:
        {
            return _iceD_getSessionTimeout(in, current);
        }
        case 9:
        {
            return _iceD_ice_id(in, current);
        }
        case 10:
        {
            return _iceD_ice_ids(in, current);
        }
        case 11:
        {
            return _iceD_ice_isA(in, current);
        }
        case 12:
        {
            return _iceD_ice_ping(in, current);
        }
        case 13:
        {
            return _iceD_refreshSession(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
Glacier2::Router::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< Router, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
Glacier2::Router::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< Router, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::_icePatchObjectPtr(RouterPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = RouterPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(Router::ice_staticId(), v);
    }
}
/// \endcond

namespace Ice
{
}

#endif
