//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.10
//
// <auto-generated>
//
// Generated from file `PermissionsVerifier.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef GLACIER2_API_EXPORTS
#   define GLACIER2_API_EXPORTS
#endif
#include <Glacier2/PermissionsVerifier.h>
#include <IceUtil/PushDisableWarnings.h>
#include <Ice/LocalException.h>
#include <Ice/ValueFactory.h>
#include <Ice/OutgoingAsync.h>
#include <Ice/InputStream.h>
#include <Ice/OutputStream.h>
#include <Ice/LocalException.h>
#include <Ice/SlicedData.h>
#include <IceUtil/PopDisableWarnings.h>

#if defined(_MSC_VER)
#   pragma warning(disable:4458) // declaration of ... hides class member
#elif defined(__clang__)
#   pragma clang diagnostic ignored "-Wshadow"
#elif defined(__GNUC__)
#   pragma GCC diagnostic ignored "-Wshadow"
#endif

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 10
#       error Ice patch level mismatch!
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit<::Glacier2::PermissionDeniedException> iceC_Glacier2_PermissionDeniedException_init("::Glacier2::PermissionDeniedException");

const ::std::string iceC_Glacier2_PermissionsVerifier_ids[2] =
{
    "::Glacier2::PermissionsVerifier",
    "::Ice::Object"
};
const ::std::string iceC_Glacier2_PermissionsVerifier_ops[] =
{
    "checkPermissions",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};
const ::std::string iceC_Glacier2_PermissionsVerifier_checkPermissions_name = "checkPermissions";

const ::std::string iceC_Glacier2_SSLPermissionsVerifier_ids[2] =
{
    "::Glacier2::SSLPermissionsVerifier",
    "::Ice::Object"
};
const ::std::string iceC_Glacier2_SSLPermissionsVerifier_ops[] =
{
    "authorize",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};
const ::std::string iceC_Glacier2_SSLPermissionsVerifier_authorize_name = "authorize";

}

Glacier2::PermissionDeniedException::~PermissionDeniedException()
{
}

const ::std::string&
Glacier2::PermissionDeniedException::ice_staticId()
{
    static const ::std::string typeId = "::Glacier2::PermissionDeniedException";
    return typeId;
}

::std::shared_ptr<::Ice::SlicedData>
Glacier2::PermissionDeniedException::ice_getSlicedData() const
{
    return _slicedData;
}

/// \cond STREAM
void
Glacier2::PermissionDeniedException::_write(::Ice::OutputStream* ostr) const
{
    ostr->startException(_slicedData);
    _writeImpl(ostr);
    ostr->endException();
}

void
Glacier2::PermissionDeniedException::_read(::Ice::InputStream* istr)
{
    istr->startException();
    _readImpl(istr);
    _slicedData = istr->endException(true);
}
/// \endcond

bool
Glacier2::PermissionsVerifier::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_Glacier2_PermissionsVerifier_ids, iceC_Glacier2_PermissionsVerifier_ids + 2, s);
}

::std::vector<::std::string>
Glacier2::PermissionsVerifier::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_Glacier2_PermissionsVerifier_ids[0], &iceC_Glacier2_PermissionsVerifier_ids[2]);
}

::std::string
Glacier2::PermissionsVerifier::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
Glacier2::PermissionsVerifier::ice_staticId()
{
    static const ::std::string typeId = "::Glacier2::PermissionsVerifier";
    return typeId;
}

/// \cond INTERNAL
bool
Glacier2::PermissionsVerifier::_iceD_checkPermissions(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_userId;
    ::std::string iceP_password;
    istr->readAll(iceP_userId, iceP_password);
    inS.endReadParams();
    inS.setFormat(::Ice::FormatType::SlicedFormat);
    ::std::string iceP_reason;
    bool ret = this->checkPermissions(::std::move(iceP_userId), ::std::move(iceP_password), iceP_reason, current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(iceP_reason, ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::PermissionsVerifier::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_Glacier2_PermissionsVerifier_ops, iceC_Glacier2_PermissionsVerifier_ops + 5, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_Glacier2_PermissionsVerifier_ops)
    {
        case 0:
        {
            return _iceD_checkPermissions(in, current);
        }
        case 1:
        {
            return _iceD_ice_id(in, current);
        }
        case 2:
        {
            return _iceD_ice_ids(in, current);
        }
        case 3:
        {
            return _iceD_ice_isA(in, current);
        }
        case 4:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
Glacier2::SSLPermissionsVerifier::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_Glacier2_SSLPermissionsVerifier_ids, iceC_Glacier2_SSLPermissionsVerifier_ids + 2, s);
}

::std::vector<::std::string>
Glacier2::SSLPermissionsVerifier::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_Glacier2_SSLPermissionsVerifier_ids[0], &iceC_Glacier2_SSLPermissionsVerifier_ids[2]);
}

::std::string
Glacier2::SSLPermissionsVerifier::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
Glacier2::SSLPermissionsVerifier::ice_staticId()
{
    static const ::std::string typeId = "::Glacier2::SSLPermissionsVerifier";
    return typeId;
}

/// \cond INTERNAL
bool
Glacier2::SSLPermissionsVerifier::_iceD_authorize(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    SSLInfo iceP_info;
    istr->readAll(iceP_info);
    inS.endReadParams();
    inS.setFormat(::Ice::FormatType::SlicedFormat);
    ::std::string iceP_reason;
    bool ret = this->authorize(::std::move(iceP_info), iceP_reason, current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(iceP_reason, ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::SSLPermissionsVerifier::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_Glacier2_SSLPermissionsVerifier_ops, iceC_Glacier2_SSLPermissionsVerifier_ops + 5, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_Glacier2_SSLPermissionsVerifier_ops)
    {
        case 0:
        {
            return _iceD_authorize(in, current);
        }
        case 1:
        {
            return _iceD_ice_id(in, current);
        }
        case 2:
        {
            return _iceD_ice_ids(in, current);
        }
        case 3:
        {
            return _iceD_ice_isA(in, current);
        }
        case 4:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::PermissionsVerifierPrx::_iceI_checkPermissions(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<PermissionsVerifier::CheckPermissionsResult>>& outAsync, const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_Glacier2_PermissionsVerifier_checkPermissions_name);
    outAsync->invoke(iceC_Glacier2_PermissionsVerifier_checkPermissions_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::SlicedFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_userId, iceP_password);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const PermissionDeniedException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        },
        [](::Ice::InputStream* istr)
        {
            PermissionsVerifier::CheckPermissionsResult v;
            istr->readAll(v.reason, v.returnValue);
            return v;
        });
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
Glacier2::PermissionsVerifierPrx::_newInstance() const
{
    return ::IceInternal::createProxy<PermissionsVerifierPrx>();
}
/// \endcond

const ::std::string&
Glacier2::PermissionsVerifierPrx::ice_staticId()
{
    return PermissionsVerifier::ice_staticId();
}

/// \cond INTERNAL
void
Glacier2::SSLPermissionsVerifierPrx::_iceI_authorize(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<SSLPermissionsVerifier::AuthorizeResult>>& outAsync, const SSLInfo& iceP_info, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_Glacier2_SSLPermissionsVerifier_authorize_name);
    outAsync->invoke(iceC_Glacier2_SSLPermissionsVerifier_authorize_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::SlicedFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_info);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const PermissionDeniedException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        },
        [](::Ice::InputStream* istr)
        {
            SSLPermissionsVerifier::AuthorizeResult v;
            istr->readAll(v.reason, v.returnValue);
            return v;
        });
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
Glacier2::SSLPermissionsVerifierPrx::_newInstance() const
{
    return ::IceInternal::createProxy<SSLPermissionsVerifierPrx>();
}
/// \endcond

const ::std::string&
Glacier2::SSLPermissionsVerifierPrx::ice_staticId()
{
    return SSLPermissionsVerifier::ice_staticId();
}

#else // C++98 mapping

namespace
{

const ::std::string iceC_Glacier2_PermissionsVerifier_checkPermissions_name = "checkPermissions";

const ::std::string iceC_Glacier2_SSLPermissionsVerifier_authorize_name = "authorize";

}

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::Glacier2::PermissionDeniedException> iceC_Glacier2_PermissionDeniedException_init("::Glacier2::PermissionDeniedException");

}

Glacier2::PermissionDeniedException::PermissionDeniedException(const ::std::string& reason) :
    ::Ice::UserException(),
    reason(reason)
{
}

#ifdef ICE_CPP11_COMPILER
Glacier2::PermissionDeniedException::~PermissionDeniedException()
{
}
#else
Glacier2::PermissionDeniedException::~PermissionDeniedException() throw()
{
}
#endif

::std::string
Glacier2::PermissionDeniedException::ice_id() const
{
    return "::Glacier2::PermissionDeniedException";
}

Glacier2::PermissionDeniedException*
Glacier2::PermissionDeniedException::ice_clone() const
{
    return new PermissionDeniedException(*this);
}

void
Glacier2::PermissionDeniedException::ice_throw() const
{
    throw *this;
}

::Ice::SlicedDataPtr
Glacier2::PermissionDeniedException::ice_getSlicedData() const
{
    return _slicedData;
}

void
Glacier2::PermissionDeniedException::_write(::Ice::OutputStream* ostr) const
{
    ostr->startException(_slicedData);
    _writeImpl(ostr);
    ostr->endException();
}

void
Glacier2::PermissionDeniedException::_read(::Ice::InputStream* istr)
{
    istr->startException();
    _readImpl(istr);
    _slicedData = istr->endException(true);
}

/// \cond STREAM
void
Glacier2::PermissionDeniedException::_writeImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice("::Glacier2::PermissionDeniedException", -1, true);
    ::Ice::StreamWriter< PermissionDeniedException, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
Glacier2::PermissionDeniedException::_readImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< PermissionDeniedException, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
GLACIER2_API ::IceProxy::Ice::Object* ::IceProxy::Glacier2::upCast(PermissionsVerifier* p) { return p; }

void
::IceProxy::Glacier2::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< PermissionsVerifier>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new PermissionsVerifier;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::Glacier2::PermissionsVerifier::_iceI_begin_checkPermissions(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_Glacier2_PermissionsVerifier_checkPermissions_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Glacier2_PermissionsVerifier_checkPermissions_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Glacier2_PermissionsVerifier_checkPermissions_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::SlicedFormat);
        ostr->write(iceP_userId);
        ostr->write(iceP_password);
        result->endWriteParams();
        result->invoke(iceC_Glacier2_PermissionsVerifier_checkPermissions_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

bool
IceProxy::Glacier2::PermissionsVerifier::end_checkPermissions(::std::string& iceP_reason, const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Glacier2_PermissionsVerifier_checkPermissions_name);
    bool ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Glacier2::PermissionDeniedException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(iceP_reason);
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

void IceProxy::Glacier2::PermissionsVerifier::_iceI_end_checkPermissions(::std::string& iceP_reason, bool& ret, const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Glacier2_PermissionsVerifier_checkPermissions_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Glacier2::PermissionDeniedException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(iceP_reason);
    istr->read(ret);
    result->_endReadParams();
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::Glacier2::PermissionsVerifier::_newInstance() const
{
    return new PermissionsVerifier;
}
/// \endcond

const ::std::string&
IceProxy::Glacier2::PermissionsVerifier::ice_staticId()
{
    return ::Glacier2::PermissionsVerifier::ice_staticId();
}

/// \cond INTERNAL
GLACIER2_API ::IceProxy::Ice::Object* ::IceProxy::Glacier2::upCast(SSLPermissionsVerifier* p) { return p; }

void
::IceProxy::Glacier2::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< SSLPermissionsVerifier>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new SSLPermissionsVerifier;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::Glacier2::SSLPermissionsVerifier::_iceI_begin_authorize(const ::Glacier2::SSLInfo& iceP_info, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_Glacier2_SSLPermissionsVerifier_authorize_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Glacier2_SSLPermissionsVerifier_authorize_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Glacier2_SSLPermissionsVerifier_authorize_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::SlicedFormat);
        ostr->write(iceP_info);
        result->endWriteParams();
        result->invoke(iceC_Glacier2_SSLPermissionsVerifier_authorize_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

bool
IceProxy::Glacier2::SSLPermissionsVerifier::end_authorize(::std::string& iceP_reason, const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Glacier2_SSLPermissionsVerifier_authorize_name);
    bool ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Glacier2::PermissionDeniedException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(iceP_reason);
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

void IceProxy::Glacier2::SSLPermissionsVerifier::_iceI_end_authorize(::std::string& iceP_reason, bool& ret, const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Glacier2_SSLPermissionsVerifier_authorize_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Glacier2::PermissionDeniedException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(iceP_reason);
    istr->read(ret);
    result->_endReadParams();
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::Glacier2::SSLPermissionsVerifier::_newInstance() const
{
    return new SSLPermissionsVerifier;
}
/// \endcond

const ::std::string&
IceProxy::Glacier2::SSLPermissionsVerifier::ice_staticId()
{
    return ::Glacier2::SSLPermissionsVerifier::ice_staticId();
}

Glacier2::PermissionsVerifier::~PermissionsVerifier()
{
}

/// \cond INTERNAL
GLACIER2_API ::Ice::Object* Glacier2::upCast(PermissionsVerifier* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_Glacier2_PermissionsVerifier_ids[2] =
{
    "::Glacier2::PermissionsVerifier",
    "::Ice::Object"
};

}

bool
Glacier2::PermissionsVerifier::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_Glacier2_PermissionsVerifier_ids, iceC_Glacier2_PermissionsVerifier_ids + 2, s);
}

::std::vector< ::std::string>
Glacier2::PermissionsVerifier::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_Glacier2_PermissionsVerifier_ids[0], &iceC_Glacier2_PermissionsVerifier_ids[2]);
}

const ::std::string&
Glacier2::PermissionsVerifier::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
Glacier2::PermissionsVerifier::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::Glacier2::PermissionsVerifier";
    return typeId;
#else
    return iceC_Glacier2_PermissionsVerifier_ids[0];
#endif
}

/// \cond INTERNAL
bool
Glacier2::PermissionsVerifier::_iceD_checkPermissions(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_userId;
    ::std::string iceP_password;
    istr->read(iceP_userId);
    istr->read(iceP_password);
    inS.endReadParams();
    inS.setFormat(::Ice::SlicedFormat);
    ::std::string iceP_reason;
    bool ret = this->checkPermissions(iceP_userId, iceP_password, iceP_reason, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(iceP_reason);
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_Glacier2_PermissionsVerifier_all[] =
{
    "checkPermissions",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};

}

/// \cond INTERNAL
bool
Glacier2::PermissionsVerifier::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_Glacier2_PermissionsVerifier_all, iceC_Glacier2_PermissionsVerifier_all + 5, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_Glacier2_PermissionsVerifier_all)
    {
        case 0:
        {
            return _iceD_checkPermissions(in, current);
        }
        case 1:
        {
            return _iceD_ice_id(in, current);
        }
        case 2:
        {
            return _iceD_ice_ids(in, current);
        }
        case 3:
        {
            return _iceD_ice_isA(in, current);
        }
        case 4:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
Glacier2::PermissionsVerifier::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< PermissionsVerifier, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
Glacier2::PermissionsVerifier::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< PermissionsVerifier, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::_icePatchObjectPtr(PermissionsVerifierPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = PermissionsVerifierPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(PermissionsVerifier::ice_staticId(), v);
    }
}
/// \endcond

Glacier2::SSLPermissionsVerifier::~SSLPermissionsVerifier()
{
}

/// \cond INTERNAL
GLACIER2_API ::Ice::Object* Glacier2::upCast(SSLPermissionsVerifier* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_Glacier2_SSLPermissionsVerifier_ids[2] =
{
    "::Glacier2::SSLPermissionsVerifier",
    "::Ice::Object"
};

}

bool
Glacier2::SSLPermissionsVerifier::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_Glacier2_SSLPermissionsVerifier_ids, iceC_Glacier2_SSLPermissionsVerifier_ids + 2, s);
}

::std::vector< ::std::string>
Glacier2::SSLPermissionsVerifier::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_Glacier2_SSLPermissionsVerifier_ids[0], &iceC_Glacier2_SSLPermissionsVerifier_ids[2]);
}

const ::std::string&
Glacier2::SSLPermissionsVerifier::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
Glacier2::SSLPermissionsVerifier::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::Glacier2::SSLPermissionsVerifier";
    return typeId;
#else
    return iceC_Glacier2_SSLPermissionsVerifier_ids[0];
#endif
}

/// \cond INTERNAL
bool
Glacier2::SSLPermissionsVerifier::_iceD_authorize(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    SSLInfo iceP_info;
    istr->read(iceP_info);
    inS.endReadParams();
    inS.setFormat(::Ice::SlicedFormat);
    ::std::string iceP_reason;
    bool ret = this->authorize(iceP_info, iceP_reason, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(iceP_reason);
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_Glacier2_SSLPermissionsVerifier_all[] =
{
    "authorize",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};

}

/// \cond INTERNAL
bool
Glacier2::SSLPermissionsVerifier::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_Glacier2_SSLPermissionsVerifier_all, iceC_Glacier2_SSLPermissionsVerifier_all + 5, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_Glacier2_SSLPermissionsVerifier_all)
    {
        case 0:
        {
            return _iceD_authorize(in, current);
        }
        case 1:
        {
            return _iceD_ice_id(in, current);
        }
        case 2:
        {
            return _iceD_ice_ids(in, current);
        }
        case 3:
        {
            return _iceD_ice_isA(in, current);
        }
        case 4:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
Glacier2::SSLPermissionsVerifier::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< SSLPermissionsVerifier, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
Glacier2::SSLPermissionsVerifier::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< SSLPermissionsVerifier, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::_icePatchObjectPtr(SSLPermissionsVerifierPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = SSLPermissionsVerifierPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(SSLPermissionsVerifier::ice_staticId(), v);
    }
}
/// \endcond

namespace Ice
{
}

#endif
