/* NotificationEntry.c generated by valac 0.56.17, the Vala compiler
 * generated from NotificationEntry.vala, do not modify */

/*-
 * Copyright (c) 2015-2018 elementary LLC. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "notifications.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <handy.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gdesktopappinfo.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <granite.h>
#include <gdk/gdk.h>

#define NOTIFICATIONS_NOTIFICATION_ENTRY_ICON_SIZE_PRIMARY 48
#define NOTIFICATIONS_NOTIFICATION_ENTRY_ICON_SIZE_SECONDARY 24
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NOTIFICATIONS_NOTIFICATION_ENTRY_0_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_ENTRY_NOTIFICATION_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_ENTRY_REVEALER_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_ENTRY_NUM_PROPERTIES
};
static GParamSpec* notifications_notification_entry_properties[NOTIFICATIONS_NOTIFICATION_ENTRY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define NOTIFICATIONS_NOTIFICATION_ENTRY_TYPE_DELETE_AFFORDANCE (notifications_notification_entry_delete_affordance_get_type ())
#define NOTIFICATIONS_NOTIFICATION_ENTRY_DELETE_AFFORDANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOTIFICATIONS_NOTIFICATION_ENTRY_TYPE_DELETE_AFFORDANCE, NotificationsNotificationEntryDeleteAffordance))
#define NOTIFICATIONS_NOTIFICATION_ENTRY_DELETE_AFFORDANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOTIFICATIONS_NOTIFICATION_ENTRY_TYPE_DELETE_AFFORDANCE, NotificationsNotificationEntryDeleteAffordanceClass))
#define NOTIFICATIONS_NOTIFICATION_ENTRY_IS_DELETE_AFFORDANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOTIFICATIONS_NOTIFICATION_ENTRY_TYPE_DELETE_AFFORDANCE))
#define NOTIFICATIONS_NOTIFICATION_ENTRY_IS_DELETE_AFFORDANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOTIFICATIONS_NOTIFICATION_ENTRY_TYPE_DELETE_AFFORDANCE))
#define NOTIFICATIONS_NOTIFICATION_ENTRY_DELETE_AFFORDANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOTIFICATIONS_NOTIFICATION_ENTRY_TYPE_DELETE_AFFORDANCE, NotificationsNotificationEntryDeleteAffordanceClass))

typedef struct _NotificationsNotificationEntryDeleteAffordance NotificationsNotificationEntryDeleteAffordance;
typedef struct _NotificationsNotificationEntryDeleteAffordanceClass NotificationsNotificationEntryDeleteAffordanceClass;
typedef struct _NotificationsNotificationEntryDeleteAffordancePrivate NotificationsNotificationEntryDeleteAffordancePrivate;
enum  {
	NOTIFICATIONS_NOTIFICATION_ENTRY_DELETE_AFFORDANCE_0_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_ENTRY_DELETE_AFFORDANCE_ALIGNMENT_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_ENTRY_DELETE_AFFORDANCE_NUM_PROPERTIES
};
static GParamSpec* notifications_notification_entry_delete_affordance_properties[NOTIFICATIONS_NOTIFICATION_ENTRY_DELETE_AFFORDANCE_NUM_PROPERTIES];
typedef struct _Block2Data Block2Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
enum  {
	NOTIFICATIONS_NOTIFICATION_ENTRY_CLEAR_SIGNAL,
	NOTIFICATIONS_NOTIFICATION_ENTRY_NUM_SIGNALS
};
static guint notifications_notification_entry_signals[NOTIFICATIONS_NOTIFICATION_ENTRY_NUM_SIGNALS] = {0};

struct _NotificationsNotificationEntryPrivate {
	NotificationsNotification* _notification;
	GtkRevealer* _revealer;
	guint timeout_id;
};

struct _NotificationsNotificationEntryDeleteAffordance {
	GtkGrid parent_instance;
	NotificationsNotificationEntryDeleteAffordancePrivate * priv;
};

struct _NotificationsNotificationEntryDeleteAffordanceClass {
	GtkGridClass parent_class;
};

struct _NotificationsNotificationEntryDeleteAffordancePrivate {
	GtkAlign _alignment;
};

struct _Block2Data {
	int _ref_count_;
	NotificationsNotificationEntry* self;
	GtkLabel* time_label;
	GtkRevealer* delete_revealer;
	GtkOverlay* overlay;
	HdyDeck* deck;
};

static gint NotificationsNotificationEntry_private_offset;
static gpointer notifications_notification_entry_parent_class = NULL;
static GtkCssProvider* notifications_notification_entry_provider;
static GtkCssProvider* notifications_notification_entry_provider = NULL;
static GRegex* notifications_notification_entry_entity_regex;
static GRegex* notifications_notification_entry_entity_regex = NULL;
static GRegex* notifications_notification_entry_tag_regex;
static GRegex* notifications_notification_entry_tag_regex = NULL;
static gint NotificationsNotificationEntryDeleteAffordance_private_offset;
static gpointer notifications_notification_entry_delete_affordance_parent_class = NULL;

static void ___lambda4_ (NotificationsNotificationEntry* self);
static void ____lambda4__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static GVariant* _variant_new1 (guint32 value);
static gchar* notifications_notification_entry_fix_markup (NotificationsNotificationEntry* self,
                                                    const gchar* markup);
static GType notifications_notification_entry_delete_affordance_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static NotificationsNotificationEntryDeleteAffordance* notifications_notification_entry_delete_affordance_new (GtkAlign alignment);
static NotificationsNotificationEntryDeleteAffordance* notifications_notification_entry_delete_affordance_construct (GType object_type,
                                                                                                              GtkAlign alignment);
static GtkAlign notifications_notification_entry_delete_affordance_get_alignment (NotificationsNotificationEntryDeleteAffordance* self);
static void notifications_notification_entry_delete_affordance_set_alignment (NotificationsNotificationEntryDeleteAffordance* self,
                                                                       GtkAlign value);
static GObject * notifications_notification_entry_delete_affordance_constructor (GType type,
                                                                          guint n_construct_properties,
                                                                          GObjectConstructParam * construct_properties);
static void notifications_notification_entry_delete_affordance_finalize (GObject * obj);
static GType notifications_notification_entry_delete_affordance_get_type_once (void);
static void _vala_notifications_notification_entry_delete_affordance_get_property (GObject * object,
                                                                            guint property_id,
                                                                            GValue * value,
                                                                            GParamSpec * pspec);
static void _vala_notifications_notification_entry_delete_affordance_set_property (GObject * object,
                                                                            guint property_id,
                                                                            const GValue * value,
                                                                            GParamSpec * pspec);
static GObject * notifications_notification_entry_constructor (GType type,
                                                        guint n_construct_properties,
                                                        GObjectConstructParam * construct_properties);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void _notifications_notification_entry___lambda5_ (NotificationsNotificationEntry* self);
static void __notifications_notification_entry___lambda5__gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static gboolean _notifications_notification_entry___lambda6_ (Block2Data* _data2_,
                                                       GdkEventCrossing* event);
static gboolean __notifications_notification_entry___lambda6__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                                      GdkEventCrossing* event,
                                                                                      gpointer self);
static gboolean _notifications_notification_entry___lambda7_ (Block2Data* _data2_,
                                                       GdkEventCrossing* event);
static gboolean __notifications_notification_entry___lambda7__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                                      GdkEventCrossing* event,
                                                                                      gpointer self);
static gboolean _notifications_notification_entry___lambda8_ (Block2Data* _data2_);
static gboolean __notifications_notification_entry___lambda8__gsource_func (gpointer self);
static void _notifications_notification_entry___lambda9_ (Block2Data* _data2_);
static void __notifications_notification_entry___lambda9__g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self);
static void _notifications_notification_entry___lambda10_ (Block2Data* _data2_);
static void __notifications_notification_entry___lambda10__g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self);
static void notifications_notification_entry_finalize (GObject * obj);
static GType notifications_notification_entry_get_type_once (void);
static void _vala_notifications_notification_entry_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec);
static void _vala_notifications_notification_entry_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
notifications_notification_entry_get_instance_private (NotificationsNotificationEntry* self)
{
	return G_STRUCT_MEMBER_P (self, NotificationsNotificationEntry_private_offset);
}

NotificationsNotificationEntry*
notifications_notification_entry_construct (GType object_type,
                                            NotificationsNotification* notification)
{
	NotificationsNotificationEntry * self = NULL;
	g_return_val_if_fail (notification != NULL, NULL);
	self = (NotificationsNotificationEntry*) g_object_new (object_type, "notification", notification, NULL);
	return self;
}

NotificationsNotificationEntry*
notifications_notification_entry_new (NotificationsNotification* notification)
{
	return notifications_notification_entry_construct (NOTIFICATIONS_TYPE_NOTIFICATION_ENTRY, notification);
}

static void
___lambda4_ (NotificationsNotificationEntry* self)
{
	GtkRevealer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->_revealer;
	_tmp1_ = gtk_revealer_get_child_revealed (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		gtk_widget_destroy ((GtkWidget*) self);
	}
}

static void
____lambda4__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	___lambda4_ ((NotificationsNotificationEntry*) self);
}

static GVariant*
_variant_new1 (guint32 value)
{
	return g_variant_ref_sink (g_variant_new_uint32 (value));
}

void
notifications_notification_entry_dismiss (NotificationsNotificationEntry* self)
{
	GtkRevealer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	NotificationsNotification* _tmp5_;
	guint32 _tmp6_;
	guint32 _tmp7_;
	g_return_if_fail (self != NULL);
	g_source_remove (self->priv->timeout_id);
	_tmp0_ = self->priv->_revealer;
	_tmp1_ = gtk_revealer_get_child_revealed (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		gtk_widget_destroy ((GtkWidget*) self);
	} else {
		GtkRevealer* _tmp3_;
		GtkRevealer* _tmp4_;
		_tmp3_ = self->priv->_revealer;
		g_signal_connect_object ((GObject*) _tmp3_, "notify::child-revealed", (GCallback) ____lambda4__g_object_notify, self, 0);
		_tmp4_ = self->priv->_revealer;
		gtk_revealer_set_reveal_child (_tmp4_, FALSE);
	}
	_tmp5_ = self->priv->_notification;
	_tmp6_ = notifications_notification_get_server_id (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ > ((guint32) 0)) {
		GActionGroup* action_group = NULL;
		GActionGroup* _tmp8_;
		GActionGroup* _tmp9_;
		const GVariantType* _tmp10_;
		NotificationsNotification* _tmp11_;
		guint32 _tmp12_;
		guint32 _tmp13_;
		GVariant* _tmp14_;
		GVariant** _tmp15_;
		GVariant** _tmp16_;
		gint _tmp16__length1;
		GVariant* _tmp17_;
		GVariant* _tmp18_;
		_tmp8_ = gtk_widget_get_action_group ((GtkWidget*) self, NOTIFICATIONS_NOTIFICATIONS_LIST_ACTION_GROUP_PREFIX);
		action_group = _tmp8_;
		_tmp9_ = action_group;
		_tmp10_ = G_VARIANT_TYPE_UINT32;
		_tmp11_ = self->priv->_notification;
		_tmp12_ = notifications_notification_get_server_id (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _variant_new1 (_tmp13_);
		_tmp15_ = g_new0 (GVariant*, 1 + 1);
		_tmp15_[0] = _tmp14_;
		_tmp16_ = _tmp15_;
		_tmp16__length1 = 1;
		_tmp17_ = g_variant_new_array (_tmp10_, _tmp16_, 1);
		g_variant_ref_sink (_tmp17_);
		_tmp18_ = _tmp17_;
		g_action_group_activate_action (_tmp9_, "close", _tmp18_);
		_g_variant_unref0 (_tmp18_);
		_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_variant_unref), NULL);
	}
}

/**
     * Copied from gnome-shell, fixes the mess of markup that is sent to us
     */
static gchar*
notifications_notification_entry_fix_markup (NotificationsNotificationEntry* self,
                                             const gchar* markup)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (markup != NULL, NULL);
	_tmp0_ = g_strdup (markup);
	text = _tmp0_;
	{
		gchar* _tmp1_ = NULL;
		GRegex* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp2_ = notifications_notification_entry_entity_regex;
		_tmp3_ = strlen (markup);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_replace (_tmp2_, markup, (gssize) _tmp4_, 0, "&amp;", 0, &_inner_error0_);
		_tmp1_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp1_;
		_tmp1_ = NULL;
		_g_free0 (text);
		text = _tmp6_;
		_tmp8_ = notifications_notification_entry_tag_regex;
		_tmp9_ = text;
		_tmp10_ = text;
		_tmp11_ = strlen (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_regex_replace (_tmp8_, _tmp9_, (gssize) _tmp12_, 0, "&lt;", 0, &_inner_error0_);
		_tmp7_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			goto __catch0_g_error;
		}
		_tmp14_ = _tmp7_;
		_tmp7_ = NULL;
		_g_free0 (text);
		text = _tmp14_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		g_warning ("NotificationEntry.vala:343: Invalid regex: %s", _tmp16_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (text);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = text;
	return result;
}

NotificationsNotification*
notifications_notification_entry_get_notification (NotificationsNotificationEntry* self)
{
	NotificationsNotification* result;
	NotificationsNotification* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_notification;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
notifications_notification_entry_set_notification (NotificationsNotificationEntry* self,
                                                   NotificationsNotification* value)
{
	NotificationsNotification* old_value;
	g_return_if_fail (self != NULL);
	old_value = notifications_notification_entry_get_notification (self);
	if (old_value != value) {
		NotificationsNotification* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_notification);
		self->priv->_notification = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, notifications_notification_entry_properties[NOTIFICATIONS_NOTIFICATION_ENTRY_NOTIFICATION_PROPERTY]);
	}
}

GtkRevealer*
notifications_notification_entry_get_revealer (NotificationsNotificationEntry* self)
{
	GtkRevealer* result;
	GtkRevealer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_revealer;
	result = _tmp0_;
	return result;
}

static void
notifications_notification_entry_set_revealer (NotificationsNotificationEntry* self,
                                               GtkRevealer* value)
{
	GtkRevealer* old_value;
	g_return_if_fail (self != NULL);
	old_value = notifications_notification_entry_get_revealer (self);
	if (old_value != value) {
		GtkRevealer* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_revealer);
		self->priv->_revealer = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, notifications_notification_entry_properties[NOTIFICATIONS_NOTIFICATION_ENTRY_REVEALER_PROPERTY]);
	}
}

static inline gpointer
notifications_notification_entry_delete_affordance_get_instance_private (NotificationsNotificationEntryDeleteAffordance* self)
{
	return G_STRUCT_MEMBER_P (self, NotificationsNotificationEntryDeleteAffordance_private_offset);
}

static NotificationsNotificationEntryDeleteAffordance*
notifications_notification_entry_delete_affordance_construct (GType object_type,
                                                              GtkAlign alignment)
{
	NotificationsNotificationEntryDeleteAffordance * self = NULL;
	self = (NotificationsNotificationEntryDeleteAffordance*) g_object_new (object_type, "alignment", alignment, NULL);
	return self;
}

static NotificationsNotificationEntryDeleteAffordance*
notifications_notification_entry_delete_affordance_new (GtkAlign alignment)
{
	return notifications_notification_entry_delete_affordance_construct (NOTIFICATIONS_NOTIFICATION_ENTRY_TYPE_DELETE_AFFORDANCE, alignment);
}

static GtkAlign
notifications_notification_entry_delete_affordance_get_alignment (NotificationsNotificationEntryDeleteAffordance* self)
{
	GtkAlign result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_alignment;
	return result;
}

static void
notifications_notification_entry_delete_affordance_set_alignment (NotificationsNotificationEntryDeleteAffordance* self,
                                                                  GtkAlign value)
{
	GtkAlign old_value;
	g_return_if_fail (self != NULL);
	old_value = notifications_notification_entry_delete_affordance_get_alignment (self);
	if (old_value != value) {
		self->priv->_alignment = value;
		g_object_notify_by_pspec ((GObject *) self, notifications_notification_entry_delete_affordance_properties[NOTIFICATIONS_NOTIFICATION_ENTRY_DELETE_AFFORDANCE_ALIGNMENT_PROPERTY]);
	}
}

static GObject *
notifications_notification_entry_delete_affordance_constructor (GType type,
                                                                guint n_construct_properties,
                                                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NotificationsNotificationEntryDeleteAffordance * self;
	GtkImage* image = NULL;
	GtkImage* _tmp0_;
	GtkImage* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkCssProvider* _tmp3_;
	GtkLabel* label = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkLabel* _tmp6_ = NULL;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkStyleContext* _tmp9_;
	GtkCssProvider* _tmp10_;
	GtkGrid* delete_internal_grid = NULL;
	GtkAlign _tmp11_;
	GtkGrid* _tmp12_ = NULL;
	GtkGrid* _tmp13_;
	GtkImage* _tmp14_;
	GtkGrid* _tmp15_;
	GtkLabel* _tmp16_;
	GtkGrid* _tmp17_;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp18_;
	GtkStyleContext* _tmp19_;
	GtkStyleContext* _tmp20_;
	GtkCssProvider* _tmp21_;
	parent_class = G_OBJECT_CLASS (notifications_notification_entry_delete_affordance_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NOTIFICATIONS_NOTIFICATION_ENTRY_TYPE_DELETE_AFFORDANCE, NotificationsNotificationEntryDeleteAffordance);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("edit-delete-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp0_);
	image = _tmp0_;
	_tmp1_ = image;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	_tmp3_ = notifications_notification_entry_provider;
	gtk_style_context_add_provider (_tmp2_, (GtkStyleProvider*) _tmp3_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp4_ = g_strdup_printf ("<small>%s</small>", _ ("Delete"));
	_tmp5_ = _tmp4_;
	_tmp6_ = (GtkLabel*) gtk_label_new (_tmp5_);
	gtk_label_set_use_markup (_tmp6_, TRUE);
	g_object_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	label = _tmp7_;
	_tmp8_ = label;
	_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _tmp8_);
	_tmp10_ = notifications_notification_entry_provider;
	gtk_style_context_add_provider (_tmp9_, (GtkStyleProvider*) _tmp10_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp11_ = self->priv->_alignment;
	_tmp12_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp12_, _tmp11_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp12_, TRUE);
	gtk_grid_set_row_spacing (_tmp12_, 3);
	gtk_widget_set_valign ((GtkWidget*) _tmp12_, GTK_ALIGN_CENTER);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp12_, TRUE);
	g_object_ref_sink (_tmp12_);
	delete_internal_grid = _tmp12_;
	_tmp13_ = delete_internal_grid;
	_tmp14_ = image;
	gtk_grid_attach (_tmp13_, (GtkWidget*) _tmp14_, 0, 0, 1, 1);
	_tmp15_ = delete_internal_grid;
	_tmp16_ = label;
	gtk_grid_attach (_tmp15_, (GtkWidget*) _tmp16_, 0, 1, 1, 1);
	_tmp17_ = delete_internal_grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp17_);
	_tmp18_ = gtk_widget_get_style_context ((GtkWidget*) self);
	context = _tmp18_;
	_tmp19_ = context;
	gtk_style_context_add_class (_tmp19_, "delete-affordance");
	_tmp20_ = context;
	_tmp21_ = notifications_notification_entry_provider;
	gtk_style_context_add_provider (_tmp20_, (GtkStyleProvider*) _tmp21_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_object_unref0 (delete_internal_grid);
	_g_object_unref0 (label);
	_g_object_unref0 (image);
	return obj;
}

static void
notifications_notification_entry_delete_affordance_class_init (NotificationsNotificationEntryDeleteAffordanceClass * klass,
                                                               gpointer klass_data)
{
	notifications_notification_entry_delete_affordance_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NotificationsNotificationEntryDeleteAffordance_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_notifications_notification_entry_delete_affordance_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_notifications_notification_entry_delete_affordance_set_property;
	G_OBJECT_CLASS (klass)->constructor = notifications_notification_entry_delete_affordance_constructor;
	G_OBJECT_CLASS (klass)->finalize = notifications_notification_entry_delete_affordance_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATIONS_NOTIFICATION_ENTRY_DELETE_AFFORDANCE_ALIGNMENT_PROPERTY, notifications_notification_entry_delete_affordance_properties[NOTIFICATIONS_NOTIFICATION_ENTRY_DELETE_AFFORDANCE_ALIGNMENT_PROPERTY] = g_param_spec_enum ("alignment", "alignment", "alignment", gtk_align_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
notifications_notification_entry_delete_affordance_instance_init (NotificationsNotificationEntryDeleteAffordance * self,
                                                                  gpointer klass)
{
	self->priv = notifications_notification_entry_delete_affordance_get_instance_private (self);
}

static void
notifications_notification_entry_delete_affordance_finalize (GObject * obj)
{
	NotificationsNotificationEntryDeleteAffordance * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NOTIFICATIONS_NOTIFICATION_ENTRY_TYPE_DELETE_AFFORDANCE, NotificationsNotificationEntryDeleteAffordance);
	G_OBJECT_CLASS (notifications_notification_entry_delete_affordance_parent_class)->finalize (obj);
}

static GType
notifications_notification_entry_delete_affordance_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotificationsNotificationEntryDeleteAffordanceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notifications_notification_entry_delete_affordance_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotificationsNotificationEntryDeleteAffordance), 0, (GInstanceInitFunc) notifications_notification_entry_delete_affordance_instance_init, NULL };
	GType notifications_notification_entry_delete_affordance_type_id;
	notifications_notification_entry_delete_affordance_type_id = g_type_register_static (gtk_grid_get_type (), "NotificationsNotificationEntryDeleteAffordance", &g_define_type_info, 0);
	NotificationsNotificationEntryDeleteAffordance_private_offset = g_type_add_instance_private (notifications_notification_entry_delete_affordance_type_id, sizeof (NotificationsNotificationEntryDeleteAffordancePrivate));
	return notifications_notification_entry_delete_affordance_type_id;
}

static GType
notifications_notification_entry_delete_affordance_get_type (void)
{
	static volatile gsize notifications_notification_entry_delete_affordance_type_id__once = 0;
	if (g_once_init_enter (&notifications_notification_entry_delete_affordance_type_id__once)) {
		GType notifications_notification_entry_delete_affordance_type_id;
		notifications_notification_entry_delete_affordance_type_id = notifications_notification_entry_delete_affordance_get_type_once ();
		g_once_init_leave (&notifications_notification_entry_delete_affordance_type_id__once, notifications_notification_entry_delete_affordance_type_id);
	}
	return notifications_notification_entry_delete_affordance_type_id__once;
}

static void
_vala_notifications_notification_entry_delete_affordance_get_property (GObject * object,
                                                                       guint property_id,
                                                                       GValue * value,
                                                                       GParamSpec * pspec)
{
	NotificationsNotificationEntryDeleteAffordance * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NOTIFICATIONS_NOTIFICATION_ENTRY_TYPE_DELETE_AFFORDANCE, NotificationsNotificationEntryDeleteAffordance);
	switch (property_id) {
		case NOTIFICATIONS_NOTIFICATION_ENTRY_DELETE_AFFORDANCE_ALIGNMENT_PROPERTY:
		g_value_set_enum (value, notifications_notification_entry_delete_affordance_get_alignment (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_notifications_notification_entry_delete_affordance_set_property (GObject * object,
                                                                       guint property_id,
                                                                       const GValue * value,
                                                                       GParamSpec * pspec)
{
	NotificationsNotificationEntryDeleteAffordance * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NOTIFICATIONS_NOTIFICATION_ENTRY_TYPE_DELETE_AFFORDANCE, NotificationsNotificationEntryDeleteAffordance);
	switch (property_id) {
		case NOTIFICATIONS_NOTIFICATION_ENTRY_DELETE_AFFORDANCE_ALIGNMENT_PROPERTY:
		notifications_notification_entry_delete_affordance_set_alignment (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		NotificationsNotificationEntry* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->deck);
		_g_object_unref0 (_data2_->overlay);
		_g_object_unref0 (_data2_->delete_revealer);
		_g_object_unref0 (_data2_->time_label);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
_notifications_notification_entry___lambda5_ (NotificationsNotificationEntry* self)
{
	g_signal_emit (self, notifications_notification_entry_signals[NOTIFICATIONS_NOTIFICATION_ENTRY_CLEAR_SIGNAL], 0);
}

static void
__notifications_notification_entry___lambda5__gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	_notifications_notification_entry___lambda5_ ((NotificationsNotificationEntry*) self);
}

static gboolean
_notifications_notification_entry___lambda6_ (Block2Data* _data2_,
                                              GdkEventCrossing* event)
{
	NotificationsNotificationEntry* self;
	GtkRevealer* _tmp0_;
	gboolean result;
	self = _data2_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = _data2_->delete_revealer;
	gtk_revealer_set_reveal_child (_tmp0_, TRUE);
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
__notifications_notification_entry___lambda6__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                             GdkEventCrossing* event,
                                                                             gpointer self)
{
	gboolean result;
	result = _notifications_notification_entry___lambda6_ (self, event);
	return result;
}

static gboolean
_notifications_notification_entry___lambda7_ (Block2Data* _data2_,
                                              GdkEventCrossing* event)
{
	NotificationsNotificationEntry* self;
	GtkRevealer* _tmp0_;
	gboolean result;
	self = _data2_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = _data2_->delete_revealer;
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
__notifications_notification_entry___lambda7__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                             GdkEventCrossing* event,
                                                                             gpointer self)
{
	gboolean result;
	result = _notifications_notification_entry___lambda7_ (self, event);
	return result;
}

static gboolean
_notifications_notification_entry___lambda8_ (Block2Data* _data2_)
{
	NotificationsNotificationEntry* self;
	GtkLabel* _tmp0_;
	NotificationsNotification* _tmp1_;
	GDateTime* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean result;
	self = _data2_->self;
	_tmp0_ = _data2_->time_label;
	_tmp1_ = self->priv->_notification;
	_tmp2_ = _tmp1_->timestamp;
	_tmp3_ = granite_date_time_get_relative_datetime (_tmp2_);
	_tmp4_ = _tmp3_;
	gtk_label_set_label (_tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
	result = G_SOURCE_CONTINUE;
	return result;
}

static gboolean
__notifications_notification_entry___lambda8__gsource_func (gpointer self)
{
	gboolean result;
	result = _notifications_notification_entry___lambda8_ (self);
	return result;
}

static void
_notifications_notification_entry___lambda9_ (Block2Data* _data2_)
{
	NotificationsNotificationEntry* self;
	gboolean _tmp0_ = FALSE;
	HdyDeck* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data2_->self;
	_tmp1_ = _data2_->deck;
	_tmp2_ = hdy_deck_get_transition_running (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == FALSE) {
		HdyDeck* _tmp4_;
		GtkWidget* _tmp5_;
		GtkWidget* _tmp6_;
		GtkOverlay* _tmp7_;
		_tmp4_ = _data2_->deck;
		_tmp5_ = hdy_deck_get_visible_child (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _data2_->overlay;
		_tmp0_ = _tmp6_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_signal_emit (self, notifications_notification_entry_signals[NOTIFICATIONS_NOTIFICATION_ENTRY_CLEAR_SIGNAL], 0);
	}
}

static void
__notifications_notification_entry___lambda9__g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self)
{
	_notifications_notification_entry___lambda9_ (self);
}

static void
_notifications_notification_entry___lambda10_ (Block2Data* _data2_)
{
	NotificationsNotificationEntry* self;
	gboolean _tmp0_ = FALSE;
	HdyDeck* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data2_->self;
	_tmp1_ = _data2_->deck;
	_tmp2_ = hdy_deck_get_transition_running (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == FALSE) {
		HdyDeck* _tmp4_;
		GtkWidget* _tmp5_;
		GtkWidget* _tmp6_;
		GtkOverlay* _tmp7_;
		_tmp4_ = _data2_->deck;
		_tmp5_ = hdy_deck_get_visible_child (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _data2_->overlay;
		_tmp0_ = _tmp6_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_signal_emit (self, notifications_notification_entry_signals[NOTIFICATIONS_NOTIFICATION_ENTRY_CLEAR_SIGNAL], 0);
	}
}

static void
__notifications_notification_entry___lambda10__g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self)
{
	_notifications_notification_entry___lambda10_ (self);
}

static GObject *
notifications_notification_entry_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NotificationsNotificationEntry * self;
	Block2Data* _data2_;
	GtkImage* app_image = NULL;
	GtkImage* _tmp0_;
	NotificationsNotification* _tmp1_;
	const gchar* _tmp2_;
	GtkOverlay* image_overlay = NULL;
	GtkOverlay* _tmp15_;
	GtkOverlay* _tmp16_;
	gboolean _tmp17_ = FALSE;
	NotificationsNotification* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* entry_title = NULL;
	NotificationsNotification* _tmp55_;
	const gchar* _tmp56_;
	gchar* _tmp57_;
	NotificationsNotification* _tmp58_;
	const gchar* _tmp59_;
	GtkLabel* title_label = NULL;
	const gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	GtkLabel* _tmp78_ = NULL;
	GtkLabel* _tmp79_;
	NotificationsNotification* _tmp80_;
	GDateTime* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	GtkLabel* _tmp84_ = NULL;
	GtkLabel* _tmp85_;
	GtkLabel* _tmp86_;
	GtkStyleContext* _tmp87_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp88_ = NULL;
	GtkStyleContext* grid_context = NULL;
	GtkGrid* _tmp89_;
	GtkStyleContext* _tmp90_;
	GtkStyleContext* _tmp91_;
	GtkStyleContext* _tmp92_;
	GtkCssProvider* _tmp93_;
	GtkImage* delete_image = NULL;
	GtkImage* _tmp94_;
	GtkImage* _tmp95_;
	GtkStyleContext* _tmp96_;
	GtkCssProvider* _tmp97_;
	GtkButton* delete_button = NULL;
	GtkImage* _tmp98_;
	GtkWidget* _tmp99_;
	GtkButton* _tmp100_ = NULL;
	GtkButton* _tmp101_;
	GtkStyleContext* _tmp102_;
	GtkButton* _tmp103_;
	GtkStyleContext* _tmp104_;
	GtkCssProvider* _tmp105_;
	GtkRevealer* _tmp106_ = NULL;
	GtkRevealer* _tmp107_;
	GtkButton* _tmp108_;
	GtkGrid* _tmp109_;
	GtkOverlay* _tmp110_;
	GtkGrid* _tmp111_;
	GtkLabel* _tmp112_;
	GtkGrid* _tmp113_;
	GtkLabel* _tmp114_;
	gchar* entry_body = NULL;
	NotificationsNotification* _tmp115_;
	const gchar* _tmp116_;
	gchar* _tmp117_;
	const gchar* _tmp118_;
	gchar* body = NULL;
	const gchar* _tmp122_;
	gchar* _tmp123_;
	GtkLabel* body_label = NULL;
	const gchar* _tmp124_;
	GtkLabel* _tmp125_ = NULL;
	const gchar* _tmp126_;
	GtkGrid* _tmp149_;
	GtkLabel* _tmp150_;
	NotificationsNotification* _tmp151_;
	GList* _tmp152_;
	NotificationsNotificationEntryDeleteAffordance* delete_left = NULL;
	NotificationsNotificationEntryDeleteAffordance* _tmp161_ = NULL;
	NotificationsNotificationEntryDeleteAffordance* _tmp162_;
	GtkStyleContext* _tmp163_;
	NotificationsNotificationEntryDeleteAffordance* delete_right = NULL;
	NotificationsNotificationEntryDeleteAffordance* _tmp164_ = NULL;
	NotificationsNotificationEntryDeleteAffordance* _tmp165_;
	GtkStyleContext* _tmp166_;
	GtkOverlay* _tmp167_;
	GtkOverlay* _tmp168_;
	GtkGrid* _tmp169_;
	GtkOverlay* _tmp170_;
	GtkRevealer* _tmp171_;
	HdyDeck* _tmp172_ = NULL;
	HdyDeck* _tmp173_;
	NotificationsNotificationEntryDeleteAffordance* _tmp174_;
	HdyDeck* _tmp175_;
	GtkOverlay* _tmp176_;
	HdyDeck* _tmp177_;
	NotificationsNotificationEntryDeleteAffordance* _tmp178_;
	HdyDeck* _tmp179_;
	GtkOverlay* _tmp180_;
	GtkRevealer* _tmp181_ = NULL;
	GtkRevealer* _tmp182_;
	GtkRevealer* _tmp183_;
	HdyDeck* _tmp184_;
	GtkEventBox* eventbox = NULL;
	GtkEventBox* _tmp185_;
	GtkEventBox* _tmp186_;
	GtkEventBox* _tmp187_;
	GdkEventMask _tmp188_;
	GdkEventMask _tmp189_;
	GtkEventBox* _tmp190_;
	GtkRevealer* _tmp191_;
	GtkEventBox* _tmp192_;
	GtkButton* _tmp193_;
	GtkEventBox* _tmp194_;
	GtkEventBox* _tmp195_;
	HdyDeck* _tmp196_;
	HdyDeck* _tmp197_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (notifications_notification_entry_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NOTIFICATIONS_TYPE_NOTIFICATION_ENTRY, NotificationsNotificationEntry);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp0_);
	app_image = _tmp0_;
	_tmp1_ = self->priv->_notification;
	_tmp2_ = _tmp1_->app_icon;
	if (string_contains (_tmp2_, "/")) {
		GFile* file = NULL;
		NotificationsNotification* _tmp3_;
		const gchar* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		_tmp3_ = self->priv->_notification;
		_tmp4_ = _tmp3_->app_icon;
		_tmp5_ = g_file_new_for_uri (_tmp4_);
		file = _tmp5_;
		_tmp6_ = file;
		if (g_file_query_exists (_tmp6_, NULL)) {
			GtkImage* _tmp7_;
			GFile* _tmp8_;
			GFileIcon* _tmp9_;
			GFileIcon* _tmp10_;
			_tmp7_ = app_image;
			_tmp8_ = file;
			_tmp9_ = (GFileIcon*) g_file_icon_new (_tmp8_);
			_tmp10_ = _tmp9_;
			g_object_set (_tmp7_, "gicon", (GIcon*) _tmp10_, NULL);
			_g_object_unref0 (_tmp10_);
		} else {
			GtkImage* _tmp11_;
			_tmp11_ = app_image;
			g_object_set (_tmp11_, "icon-name", "dialog-information", NULL);
		}
		_g_object_unref0 (file);
	} else {
		GtkImage* _tmp12_;
		NotificationsNotification* _tmp13_;
		const gchar* _tmp14_;
		_tmp12_ = app_image;
		_tmp13_ = self->priv->_notification;
		_tmp14_ = _tmp13_->app_icon;
		g_object_set (_tmp12_, "icon-name", _tmp14_, NULL);
	}
	_tmp15_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp15_);
	image_overlay = _tmp15_;
	_tmp16_ = image_overlay;
	gtk_widget_set_valign ((GtkWidget*) _tmp16_, GTK_ALIGN_START);
	_tmp18_ = self->priv->_notification;
	_tmp19_ = notifications_notification_get_image_path (_tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_ != NULL) {
		NotificationsNotification* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		_tmp21_ = self->priv->_notification;
		_tmp22_ = notifications_notification_get_image_path (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp17_ = g_strcmp0 (_tmp23_, "") != 0;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		{
			gint scale = 0;
			GtkStyleContext* _tmp24_;
			GdkPixbuf* pixbuf = NULL;
			NotificationsNotification* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			GdkPixbuf* _tmp28_;
			NotificationsMaskedImage* masked_image = NULL;
			GdkPixbuf* _tmp29_;
			NotificationsMaskedImage* _tmp30_;
			GtkImage* _tmp31_;
			GtkImage* _tmp32_;
			GtkImage* _tmp33_;
			GtkOverlay* _tmp34_;
			NotificationsMaskedImage* _tmp35_;
			GtkOverlay* _tmp36_;
			GtkImage* _tmp37_;
			_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) self);
			scale = gtk_style_context_get_scale (_tmp24_);
			_tmp25_ = self->priv->_notification;
			_tmp26_ = notifications_notification_get_image_path (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = gdk_pixbuf_new_from_file_at_size (_tmp27_, NOTIFICATIONS_NOTIFICATION_ENTRY_ICON_SIZE_PRIMARY * scale, NOTIFICATIONS_NOTIFICATION_ENTRY_ICON_SIZE_PRIMARY * scale, &_inner_error0_);
			pixbuf = _tmp28_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp29_ = pixbuf;
			_tmp30_ = notifications_masked_image_new (_tmp29_);
			g_object_ref_sink (_tmp30_);
			masked_image = _tmp30_;
			_tmp31_ = app_image;
			gtk_image_set_pixel_size (_tmp31_, NOTIFICATIONS_NOTIFICATION_ENTRY_ICON_SIZE_SECONDARY);
			_tmp32_ = app_image;
			_tmp33_ = app_image;
			gtk_widget_set_valign ((GtkWidget*) _tmp33_, GTK_ALIGN_END);
			gtk_widget_set_halign ((GtkWidget*) _tmp32_, GTK_ALIGN_END);
			_tmp34_ = image_overlay;
			_tmp35_ = masked_image;
			gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) _tmp35_);
			_tmp36_ = image_overlay;
			_tmp37_ = app_image;
			gtk_overlay_add_overlay (_tmp36_, (GtkWidget*) _tmp37_);
			_g_object_unref0 (masked_image);
			_g_object_unref0 (pixbuf);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp38_;
			const gchar* _tmp39_;
			GtkImage* _tmp40_;
			GtkOverlay* _tmp41_;
			GtkImage* _tmp42_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp38_ = e;
			_tmp39_ = _tmp38_->message;
			g_critical ("NotificationEntry.vala:79: Unable to mask image: %s", _tmp39_);
			_tmp40_ = app_image;
			gtk_image_set_pixel_size (_tmp40_, NOTIFICATIONS_NOTIFICATION_ENTRY_ICON_SIZE_PRIMARY);
			_tmp41_ = image_overlay;
			_tmp42_ = app_image;
			gtk_container_add ((GtkContainer*) _tmp41_, (GtkWidget*) _tmp42_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (image_overlay);
			_g_object_unref0 (app_image);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
	} else {
		GtkImage* _tmp43_;
		GtkOverlay* _tmp44_;
		GtkImage* _tmp45_;
		NotificationsNotification* _tmp46_;
		GIcon* _tmp47_;
		GIcon* _tmp48_;
		_tmp43_ = app_image;
		gtk_image_set_pixel_size (_tmp43_, NOTIFICATIONS_NOTIFICATION_ENTRY_ICON_SIZE_PRIMARY);
		_tmp44_ = image_overlay;
		_tmp45_ = app_image;
		gtk_container_add ((GtkContainer*) _tmp44_, (GtkWidget*) _tmp45_);
		_tmp46_ = self->priv->_notification;
		_tmp47_ = notifications_notification_get_badge_icon (_tmp46_);
		_tmp48_ = _tmp47_;
		if (_tmp48_ != NULL) {
			GtkImage* badge_image = NULL;
			NotificationsNotification* _tmp49_;
			GIcon* _tmp50_;
			GIcon* _tmp51_;
			GtkImage* _tmp52_ = NULL;
			GtkOverlay* _tmp53_;
			GtkImage* _tmp54_;
			_tmp49_ = self->priv->_notification;
			_tmp50_ = notifications_notification_get_badge_icon (_tmp49_);
			_tmp51_ = _tmp50_;
			_tmp52_ = (GtkImage*) gtk_image_new_from_gicon (_tmp51_, (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
			gtk_widget_set_halign ((GtkWidget*) _tmp52_, GTK_ALIGN_END);
			gtk_widget_set_valign ((GtkWidget*) _tmp52_, GTK_ALIGN_END);
			gtk_image_set_pixel_size (_tmp52_, NOTIFICATIONS_NOTIFICATION_ENTRY_ICON_SIZE_SECONDARY);
			g_object_ref_sink (_tmp52_);
			badge_image = _tmp52_;
			_tmp53_ = image_overlay;
			_tmp54_ = badge_image;
			gtk_overlay_add_overlay (_tmp53_, (GtkWidget*) _tmp54_);
			_g_object_unref0 (badge_image);
		}
	}
	_tmp55_ = self->priv->_notification;
	_tmp56_ = _tmp55_->summary;
	_tmp57_ = g_strdup (_tmp56_);
	entry_title = _tmp57_;
	_tmp58_ = self->priv->_notification;
	_tmp59_ = _tmp58_->message_body;
	if (g_strcmp0 (_tmp59_, "") == 0) {
		gboolean _tmp60_ = FALSE;
		NotificationsNotification* _tmp61_;
		const gchar* _tmp62_;
		NotificationsNotification* _tmp70_;
		const gchar* _tmp71_;
		gchar* _tmp72_;
		_tmp61_ = self->priv->_notification;
		_tmp62_ = _tmp61_->app_name;
		if (g_strcmp0 (_tmp62_, "") == 0) {
			NotificationsNotification* _tmp63_;
			GDesktopAppInfo* _tmp64_;
			_tmp63_ = self->priv->_notification;
			_tmp64_ = _tmp63_->app_info;
			_tmp60_ = _tmp64_ != NULL;
		} else {
			_tmp60_ = FALSE;
		}
		if (_tmp60_) {
			NotificationsNotification* _tmp65_;
			NotificationsNotification* _tmp66_;
			GDesktopAppInfo* _tmp67_;
			const gchar* _tmp68_;
			gchar* _tmp69_;
			_tmp65_ = self->priv->_notification;
			_tmp66_ = self->priv->_notification;
			_tmp67_ = _tmp66_->app_info;
			_tmp68_ = g_app_info_get_display_name ((GAppInfo*) _tmp67_);
			_tmp69_ = g_strdup (_tmp68_);
			_g_free0 (_tmp65_->app_name);
			_tmp65_->app_name = _tmp69_;
		}
		_tmp70_ = self->priv->_notification;
		_tmp71_ = _tmp70_->app_name;
		_tmp72_ = g_strdup (_tmp71_);
		_g_free0 (entry_title);
		entry_title = _tmp72_;
	}
	_tmp73_ = entry_title;
	_tmp74_ = notifications_notification_entry_fix_markup (self, _tmp73_);
	_tmp75_ = _tmp74_;
	_tmp76_ = g_strdup_printf ("<b>%s</b>", _tmp75_);
	_tmp77_ = _tmp76_;
	_tmp78_ = (GtkLabel*) gtk_label_new (_tmp77_);
	gtk_label_set_ellipsize (_tmp78_, PANGO_ELLIPSIZE_END);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp78_, TRUE);
	gtk_label_set_width_chars (_tmp78_, 27);
	gtk_label_set_max_width_chars (_tmp78_, 27);
	gtk_label_set_use_markup (_tmp78_, TRUE);
	gtk_label_set_xalign (_tmp78_, (gfloat) 0);
	g_object_ref_sink (_tmp78_);
	_tmp79_ = _tmp78_;
	_g_free0 (_tmp77_);
	_g_free0 (_tmp75_);
	title_label = _tmp79_;
	_tmp80_ = self->priv->_notification;
	_tmp81_ = _tmp80_->timestamp;
	_tmp82_ = granite_date_time_get_relative_datetime (_tmp81_);
	_tmp83_ = _tmp82_;
	_tmp84_ = (GtkLabel*) gtk_label_new (_tmp83_);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp84_, 6);
	g_object_ref_sink (_tmp84_);
	_tmp85_ = _tmp84_;
	_g_free0 (_tmp83_);
	_data2_->time_label = _tmp85_;
	_tmp86_ = _data2_->time_label;
	_tmp87_ = gtk_widget_get_style_context ((GtkWidget*) _tmp86_);
	gtk_style_context_add_class (_tmp87_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp88_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp88_, TRUE);
	gtk_grid_set_column_spacing (_tmp88_, 6);
	g_object_set ((GtkWidget*) _tmp88_, "margin", 12, NULL);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp88_, 9);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp88_, 9);
	g_object_ref_sink (_tmp88_);
	grid = _tmp88_;
	_tmp89_ = grid;
	_tmp90_ = gtk_widget_get_style_context ((GtkWidget*) _tmp89_);
	grid_context = _tmp90_;
	_tmp91_ = grid_context;
	gtk_style_context_add_class (_tmp91_, GRANITE_STYLE_CLASS_CARD);
	_tmp92_ = grid_context;
	_tmp93_ = notifications_notification_entry_provider;
	gtk_style_context_add_provider (_tmp92_, (GtkStyleProvider*) _tmp93_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp94_ = (GtkImage*) gtk_image_new_from_icon_name ("window-close-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp94_);
	delete_image = _tmp94_;
	_tmp95_ = delete_image;
	_tmp96_ = gtk_widget_get_style_context ((GtkWidget*) _tmp95_);
	_tmp97_ = notifications_notification_entry_provider;
	gtk_style_context_add_provider (_tmp96_, (GtkStyleProvider*) _tmp97_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp98_ = delete_image;
	_tmp99_ = _g_object_ref0 ((GtkWidget*) _tmp98_);
	_tmp100_ = (GtkButton*) gtk_button_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp100_, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) _tmp100_, GTK_ALIGN_START);
	gtk_button_set_image (_tmp100_, _tmp99_);
	_g_object_unref0 (_tmp99_);
	g_object_ref_sink (_tmp100_);
	delete_button = _tmp100_;
	_tmp101_ = delete_button;
	_tmp102_ = gtk_widget_get_style_context ((GtkWidget*) _tmp101_);
	gtk_style_context_add_class (_tmp102_, "close");
	_tmp103_ = delete_button;
	_tmp104_ = gtk_widget_get_style_context ((GtkWidget*) _tmp103_);
	_tmp105_ = notifications_notification_entry_provider;
	gtk_style_context_add_provider (_tmp104_, (GtkStyleProvider*) _tmp105_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp106_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp106_, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) _tmp106_, GTK_ALIGN_START);
	gtk_revealer_set_reveal_child (_tmp106_, FALSE);
	gtk_revealer_set_transition_duration (_tmp106_, (guint) GRANITE_TRANSITION_DURATION_CLOSE);
	gtk_revealer_set_transition_type (_tmp106_, GTK_REVEALER_TRANSITION_TYPE_CROSSFADE);
	g_object_ref_sink (_tmp106_);
	_data2_->delete_revealer = _tmp106_;
	_tmp107_ = _data2_->delete_revealer;
	_tmp108_ = delete_button;
	gtk_container_add ((GtkContainer*) _tmp107_, (GtkWidget*) _tmp108_);
	_tmp109_ = grid;
	_tmp110_ = image_overlay;
	gtk_grid_attach (_tmp109_, (GtkWidget*) _tmp110_, 0, 0, 1, 2);
	_tmp111_ = grid;
	_tmp112_ = title_label;
	gtk_grid_attach (_tmp111_, (GtkWidget*) _tmp112_, 1, 0, 1, 1);
	_tmp113_ = grid;
	_tmp114_ = _data2_->time_label;
	gtk_grid_attach (_tmp113_, (GtkWidget*) _tmp114_, 2, 0, 1, 1);
	_tmp115_ = self->priv->_notification;
	_tmp116_ = _tmp115_->message_body;
	_tmp117_ = g_strdup (_tmp116_);
	entry_body = _tmp117_;
	_tmp118_ = entry_body;
	if (g_strcmp0 (_tmp118_, "") == 0) {
		NotificationsNotification* _tmp119_;
		const gchar* _tmp120_;
		gchar* _tmp121_;
		_tmp119_ = self->priv->_notification;
		_tmp120_ = _tmp119_->summary;
		_tmp121_ = g_strdup (_tmp120_);
		_g_free0 (entry_body);
		entry_body = _tmp121_;
	}
	_tmp122_ = entry_body;
	_tmp123_ = notifications_notification_entry_fix_markup (self, _tmp122_);
	body = _tmp123_;
	_tmp124_ = body;
	_tmp125_ = (GtkLabel*) gtk_label_new (_tmp124_);
	gtk_label_set_ellipsize (_tmp125_, PANGO_ELLIPSIZE_END);
	gtk_label_set_lines (_tmp125_, 2);
	gtk_label_set_use_markup (_tmp125_, TRUE);
	gtk_widget_set_valign ((GtkWidget*) _tmp125_, GTK_ALIGN_START);
	g_object_set (_tmp125_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	g_object_set (_tmp125_, "wrap", TRUE, NULL);
	gtk_label_set_xalign (_tmp125_, (gfloat) 0);
	g_object_ref_sink (_tmp125_);
	body_label = _tmp125_;
	_tmp126_ = body;
	if (string_contains (_tmp126_, "\n")) {
		gchar** lines = NULL;
		const gchar* _tmp127_;
		gchar** _tmp128_;
		gchar** _tmp129_;
		gint lines_length1;
		gint _lines_size_;
		gchar* stripped_body = NULL;
		gchar** _tmp130_;
		gint _tmp130__length1;
		const gchar* _tmp131_;
		gchar* _tmp132_;
		GtkLabel* _tmp144_;
		const gchar* _tmp145_;
		gchar* _tmp146_;
		gchar* _tmp147_;
		GtkLabel* _tmp148_;
		_tmp127_ = body;
		_tmp129_ = _tmp128_ = g_strsplit (_tmp127_, "\n", 0);
		lines = _tmp129_;
		lines_length1 = _vala_array_length (_tmp128_);
		_lines_size_ = lines_length1;
		_tmp130_ = lines;
		_tmp130__length1 = lines_length1;
		_tmp131_ = _tmp130_[0];
		_tmp132_ = g_strconcat (_tmp131_, "\n", NULL);
		stripped_body = _tmp132_;
		{
			gint i = 0;
			i = 1;
			{
				gboolean _tmp133_ = FALSE;
				_tmp133_ = TRUE;
				while (TRUE) {
					gchar** _tmp135_;
					gint _tmp135__length1;
					const gchar* _tmp136_;
					gchar** _tmp137_;
					gint _tmp137__length1;
					const gchar* _tmp138_;
					gchar* _tmp139_;
					gchar* _tmp140_;
					gchar* _tmp141_;
					gchar* _tmp142_;
					gchar* _tmp143_;
					if (!_tmp133_) {
						gint _tmp134_;
						_tmp134_ = i;
						i = _tmp134_ + 1;
					}
					_tmp133_ = FALSE;
					_tmp135_ = lines;
					_tmp135__length1 = lines_length1;
					if (!(i < _tmp135__length1)) {
						break;
					}
					_tmp136_ = stripped_body;
					_tmp137_ = lines;
					_tmp137__length1 = lines_length1;
					_tmp138_ = _tmp137_[i];
					_tmp139_ = string_strip (_tmp138_);
					_tmp140_ = _tmp139_;
					_tmp141_ = g_strconcat (_tmp140_, " ", NULL);
					_tmp142_ = _tmp141_;
					_tmp143_ = g_strconcat (_tmp136_, _tmp142_, NULL);
					_g_free0 (stripped_body);
					stripped_body = _tmp143_;
					_g_free0 (_tmp142_);
					_g_free0 (_tmp140_);
				}
			}
		}
		_tmp144_ = body_label;
		_tmp145_ = stripped_body;
		_tmp146_ = string_strip (_tmp145_);
		_tmp147_ = _tmp146_;
		gtk_label_set_label (_tmp144_, _tmp147_);
		_g_free0 (_tmp147_);
		_tmp148_ = body_label;
		gtk_label_set_lines (_tmp148_, 1);
		_g_free0 (stripped_body);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp149_ = grid;
	_tmp150_ = body_label;
	gtk_grid_attach (_tmp149_, (GtkWidget*) _tmp150_, 1, 1, 2, 1);
	_tmp151_ = self->priv->_notification;
	_tmp152_ = _tmp151_->buttons;
	if (g_list_length (_tmp152_) > ((guint) 0)) {
		GtkBox* action_area = NULL;
		GtkBox* _tmp153_ = NULL;
		GtkGrid* _tmp154_;
		GtkBox* _tmp155_;
		NotificationsNotification* _tmp156_;
		GList* _tmp157_;
		_tmp153_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
		gtk_widget_set_margin_top ((GtkWidget*) _tmp153_, 12);
		gtk_widget_set_halign ((GtkWidget*) _tmp153_, GTK_ALIGN_END);
		gtk_box_set_homogeneous (_tmp153_, TRUE);
		g_object_ref_sink (_tmp153_);
		action_area = _tmp153_;
		_tmp154_ = grid;
		_tmp155_ = action_area;
		gtk_grid_attach (_tmp154_, (GtkWidget*) _tmp155_, 0, 2, 3, 1);
		_tmp156_ = self->priv->_notification;
		_tmp157_ = _tmp156_->buttons;
		{
			GList* button_collection = NULL;
			GList* button_it = NULL;
			button_collection = _tmp157_;
			for (button_it = button_collection; button_it != NULL; button_it = button_it->next) {
				GtkButton* _tmp158_;
				GtkButton* button = NULL;
				_tmp158_ = _g_object_ref0 ((GtkButton*) button_it->data);
				button = _tmp158_;
				{
					GtkBox* _tmp159_;
					GtkButton* _tmp160_;
					_tmp159_ = action_area;
					_tmp160_ = button;
					gtk_box_pack_end (_tmp159_, (GtkWidget*) _tmp160_, TRUE, TRUE, (guint) 0);
					_g_object_unref0 (button);
				}
			}
		}
		_g_object_unref0 (action_area);
	}
	_tmp161_ = notifications_notification_entry_delete_affordance_new (GTK_ALIGN_END);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp161_, 9);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp161_, 9);
	g_object_ref_sink (_tmp161_);
	delete_left = _tmp161_;
	_tmp162_ = delete_left;
	_tmp163_ = gtk_widget_get_style_context ((GtkWidget*) _tmp162_);
	gtk_style_context_add_class (_tmp163_, "left");
	_tmp164_ = notifications_notification_entry_delete_affordance_new (GTK_ALIGN_START);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp164_, 9);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp164_, 9);
	g_object_ref_sink (_tmp164_);
	delete_right = _tmp164_;
	_tmp165_ = delete_right;
	_tmp166_ = gtk_widget_get_style_context ((GtkWidget*) _tmp165_);
	gtk_style_context_add_class (_tmp166_, "right");
	_tmp167_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp167_);
	_data2_->overlay = _tmp167_;
	_tmp168_ = _data2_->overlay;
	_tmp169_ = grid;
	gtk_container_add ((GtkContainer*) _tmp168_, (GtkWidget*) _tmp169_);
	_tmp170_ = _data2_->overlay;
	_tmp171_ = _data2_->delete_revealer;
	gtk_overlay_add_overlay (_tmp170_, (GtkWidget*) _tmp171_);
	_tmp172_ = (HdyDeck*) hdy_deck_new ();
	hdy_deck_set_can_swipe_back (_tmp172_, TRUE);
	hdy_deck_set_can_swipe_forward (_tmp172_, TRUE);
	hdy_deck_set_transition_type (_tmp172_, HDY_DECK_TRANSITION_TYPE_SLIDE);
	g_object_ref_sink (_tmp172_);
	_data2_->deck = _tmp172_;
	_tmp173_ = _data2_->deck;
	_tmp174_ = delete_left;
	gtk_container_add ((GtkContainer*) _tmp173_, (GtkWidget*) _tmp174_);
	_tmp175_ = _data2_->deck;
	_tmp176_ = _data2_->overlay;
	gtk_container_add ((GtkContainer*) _tmp175_, (GtkWidget*) _tmp176_);
	_tmp177_ = _data2_->deck;
	_tmp178_ = delete_right;
	gtk_container_add ((GtkContainer*) _tmp177_, (GtkWidget*) _tmp178_);
	_tmp179_ = _data2_->deck;
	_tmp180_ = _data2_->overlay;
	hdy_deck_set_visible_child (_tmp179_, (GtkWidget*) _tmp180_);
	_tmp181_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_reveal_child (_tmp181_, TRUE);
	gtk_revealer_set_transition_duration (_tmp181_, (guint) 200);
	gtk_revealer_set_transition_type (_tmp181_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_UP);
	g_object_ref_sink (_tmp181_);
	_tmp182_ = _tmp181_;
	notifications_notification_entry_set_revealer (self, _tmp182_);
	_g_object_unref0 (_tmp182_);
	_tmp183_ = self->priv->_revealer;
	_tmp184_ = _data2_->deck;
	gtk_container_add ((GtkContainer*) _tmp183_, (GtkWidget*) _tmp184_);
	_tmp185_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp185_);
	eventbox = _tmp185_;
	_tmp186_ = eventbox;
	_tmp187_ = eventbox;
	_tmp188_ = gtk_widget_get_events ((GtkWidget*) _tmp187_);
	_tmp189_ = _tmp188_;
	gtk_widget_set_events ((GtkWidget*) _tmp187_, _tmp189_ | (GDK_ENTER_NOTIFY_MASK & GDK_LEAVE_NOTIFY_MASK));
	_tmp190_ = eventbox;
	_tmp191_ = self->priv->_revealer;
	gtk_container_add ((GtkContainer*) _tmp190_, (GtkWidget*) _tmp191_);
	_tmp192_ = eventbox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp192_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp193_ = delete_button;
	g_signal_connect_object (_tmp193_, "clicked", (GCallback) __notifications_notification_entry___lambda5__gtk_button_clicked, self, 0);
	_tmp194_ = eventbox;
	g_signal_connect_data ((GtkWidget*) _tmp194_, "enter-notify-event", (GCallback) __notifications_notification_entry___lambda6__gtk_widget_enter_notify_event, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp195_ = eventbox;
	g_signal_connect_data ((GtkWidget*) _tmp195_, "leave-notify-event", (GCallback) __notifications_notification_entry___lambda7__gtk_widget_leave_notify_event, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	self->priv->timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 60, __notifications_notification_entry___lambda8__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	_tmp196_ = _data2_->deck;
	g_signal_connect_data ((GObject*) _tmp196_, "notify::visible-child", (GCallback) __notifications_notification_entry___lambda9__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp197_ = _data2_->deck;
	g_signal_connect_data ((GObject*) _tmp197_, "notify::transition-running", (GCallback) __notifications_notification_entry___lambda10__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_g_object_unref0 (eventbox);
	_g_object_unref0 (delete_right);
	_g_object_unref0 (delete_left);
	_g_object_unref0 (body_label);
	_g_free0 (body);
	_g_free0 (entry_body);
	_g_object_unref0 (delete_button);
	_g_object_unref0 (delete_image);
	_g_object_unref0 (grid);
	_g_object_unref0 (title_label);
	_g_free0 (entry_title);
	_g_object_unref0 (image_overlay);
	_g_object_unref0 (app_image);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return obj;
}

static void
notifications_notification_entry_class_init (NotificationsNotificationEntryClass * klass,
                                             gpointer klass_data)
{
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	GError* _inner_error0_ = NULL;
	notifications_notification_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NotificationsNotificationEntry_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_notifications_notification_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_notifications_notification_entry_set_property;
	G_OBJECT_CLASS (klass)->constructor = notifications_notification_entry_constructor;
	G_OBJECT_CLASS (klass)->finalize = notifications_notification_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATIONS_NOTIFICATION_ENTRY_NOTIFICATION_PROPERTY, notifications_notification_entry_properties[NOTIFICATIONS_NOTIFICATION_ENTRY_NOTIFICATION_PROPERTY] = g_param_spec_object ("notification", "notification", "notification", NOTIFICATIONS_TYPE_NOTIFICATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATIONS_NOTIFICATION_ENTRY_REVEALER_PROPERTY, notifications_notification_entry_properties[NOTIFICATIONS_NOTIFICATION_ENTRY_REVEALER_PROPERTY] = g_param_spec_object ("revealer", "revealer", "revealer", gtk_revealer_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	notifications_notification_entry_signals[NOTIFICATIONS_NOTIFICATION_ENTRY_CLEAR_SIGNAL] = g_signal_new ("clear", NOTIFICATIONS_TYPE_NOTIFICATION_ENTRY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = gtk_css_provider_new ();
	_g_object_unref0 (notifications_notification_entry_provider);
	notifications_notification_entry_provider = _tmp0_;
	_tmp1_ = notifications_notification_entry_provider;
	gtk_css_provider_load_from_resource (_tmp1_, "io/elementary/wingpanel/notifications/NotificationEntry.css");
	{
		GRegex* _tmp2_ = NULL;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* _tmp5_ = NULL;
		GRegex* _tmp6_;
		GRegex* _tmp7_;
		_tmp3_ = g_regex_new ("&(?!amp;|quot;|apos;|lt;|gt;|nbsp;|#39)", 0, 0, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		_g_regex_unref0 (notifications_notification_entry_entity_regex);
		notifications_notification_entry_entity_regex = _tmp4_;
		_tmp6_ = g_regex_new ("<(?!\\/?[biu]>)", 0, 0, &_inner_error0_);
		_tmp5_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp2_);
			goto __catch0_g_error;
		}
		_tmp7_ = _tmp5_;
		_tmp5_ = NULL;
		_g_regex_unref0 (notifications_notification_entry_tag_regex);
		notifications_notification_entry_tag_regex = _tmp7_;
		_g_regex_unref0 (_tmp5_);
		_g_regex_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("NotificationEntry.vala:45: Invalid regex: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
}

static void
notifications_notification_entry_instance_init (NotificationsNotificationEntry * self,
                                                gpointer klass)
{
	self->priv = notifications_notification_entry_get_instance_private (self);
}

static void
notifications_notification_entry_finalize (GObject * obj)
{
	NotificationsNotificationEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NOTIFICATIONS_TYPE_NOTIFICATION_ENTRY, NotificationsNotificationEntry);
	_g_object_unref0 (self->priv->_notification);
	_g_object_unref0 (self->priv->_revealer);
	G_OBJECT_CLASS (notifications_notification_entry_parent_class)->finalize (obj);
}

static GType
notifications_notification_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotificationsNotificationEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notifications_notification_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotificationsNotificationEntry), 0, (GInstanceInitFunc) notifications_notification_entry_instance_init, NULL };
	GType notifications_notification_entry_type_id;
	notifications_notification_entry_type_id = g_type_register_static (gtk_list_box_row_get_type (), "NotificationsNotificationEntry", &g_define_type_info, 0);
	NotificationsNotificationEntry_private_offset = g_type_add_instance_private (notifications_notification_entry_type_id, sizeof (NotificationsNotificationEntryPrivate));
	return notifications_notification_entry_type_id;
}

GType
notifications_notification_entry_get_type (void)
{
	static volatile gsize notifications_notification_entry_type_id__once = 0;
	if (g_once_init_enter (&notifications_notification_entry_type_id__once)) {
		GType notifications_notification_entry_type_id;
		notifications_notification_entry_type_id = notifications_notification_entry_get_type_once ();
		g_once_init_leave (&notifications_notification_entry_type_id__once, notifications_notification_entry_type_id);
	}
	return notifications_notification_entry_type_id__once;
}

static void
_vala_notifications_notification_entry_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec)
{
	NotificationsNotificationEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NOTIFICATIONS_TYPE_NOTIFICATION_ENTRY, NotificationsNotificationEntry);
	switch (property_id) {
		case NOTIFICATIONS_NOTIFICATION_ENTRY_NOTIFICATION_PROPERTY:
		g_value_set_object (value, notifications_notification_entry_get_notification (self));
		break;
		case NOTIFICATIONS_NOTIFICATION_ENTRY_REVEALER_PROPERTY:
		g_value_set_object (value, notifications_notification_entry_get_revealer (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_notifications_notification_entry_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec)
{
	NotificationsNotificationEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NOTIFICATIONS_TYPE_NOTIFICATION_ENTRY, NotificationsNotificationEntry);
	switch (property_id) {
		case NOTIFICATIONS_NOTIFICATION_ENTRY_NOTIFICATION_PROPERTY:
		notifications_notification_entry_set_notification (self, g_value_get_object (value));
		break;
		case NOTIFICATIONS_NOTIFICATION_ENTRY_REVEALER_PROPERTY:
		notifications_notification_entry_set_revealer (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

