/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_SOURCE)

#include "JSMediaSource.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSDedicatedWorkerGlobalScope.h"
#include "JSEventListener.h"
#include "JSMediaSourceInit.h"
#include "JSSourceBuffer.h"
#include "JSSourceBufferList.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

#if ENABLE(MEDIA_SOURCE_IN_WORKERS)
#include "JSMediaSourceHandle.h"
#endif

namespace WebCore {
using namespace JSC;

String convertEnumerationToString(MediaSource::EndOfStreamError enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 2> values {
        MAKE_STATIC_STRING_IMPL("network"),
        MAKE_STATIC_STRING_IMPL("decode"),
    };
    static_assert(static_cast<size_t>(MediaSource::EndOfStreamError::Network) == 0, "MediaSource::EndOfStreamError::Network is not 0 as expected");
    static_assert(static_cast<size_t>(MediaSource::EndOfStreamError::Decode) == 1, "MediaSource::EndOfStreamError::Decode is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, MediaSource::EndOfStreamError enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<MediaSource::EndOfStreamError> parseEnumerationFromString<MediaSource::EndOfStreamError>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, MediaSource::EndOfStreamError>, 2> mappings {
        std::pair<ComparableASCIILiteral, MediaSource::EndOfStreamError> { "decode"_s, MediaSource::EndOfStreamError::Decode },
        std::pair<ComparableASCIILiteral, MediaSource::EndOfStreamError> { "network"_s, MediaSource::EndOfStreamError::Network },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<MediaSource::EndOfStreamError> parseEnumeration<MediaSource::EndOfStreamError>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<MediaSource::EndOfStreamError>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<MediaSource::EndOfStreamError>()
{
    return "\"network\", \"decode\""_s;
}

String convertEnumerationToString(MediaSource::ReadyState enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 3> values {
        MAKE_STATIC_STRING_IMPL("closed"),
        MAKE_STATIC_STRING_IMPL("open"),
        MAKE_STATIC_STRING_IMPL("ended"),
    };
    static_assert(static_cast<size_t>(MediaSource::ReadyState::Closed) == 0, "MediaSource::ReadyState::Closed is not 0 as expected");
    static_assert(static_cast<size_t>(MediaSource::ReadyState::Open) == 1, "MediaSource::ReadyState::Open is not 1 as expected");
    static_assert(static_cast<size_t>(MediaSource::ReadyState::Ended) == 2, "MediaSource::ReadyState::Ended is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, MediaSource::ReadyState enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<MediaSource::ReadyState> parseEnumerationFromString<MediaSource::ReadyState>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, MediaSource::ReadyState>, 3> mappings {
        std::pair<ComparableASCIILiteral, MediaSource::ReadyState> { "closed"_s, MediaSource::ReadyState::Closed },
        std::pair<ComparableASCIILiteral, MediaSource::ReadyState> { "ended"_s, MediaSource::ReadyState::Ended },
        std::pair<ComparableASCIILiteral, MediaSource::ReadyState> { "open"_s, MediaSource::ReadyState::Open },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<MediaSource::ReadyState> parseEnumeration<MediaSource::ReadyState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<MediaSource::ReadyState>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<MediaSource::ReadyState>()
{
    return "\"closed\", \"open\", \"ended\""_s;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsMediaSourcePrototypeFunction_addSourceBuffer);
static JSC_DECLARE_HOST_FUNCTION(jsMediaSourcePrototypeFunction_removeSourceBuffer);
static JSC_DECLARE_HOST_FUNCTION(jsMediaSourcePrototypeFunction_endOfStream);
static JSC_DECLARE_HOST_FUNCTION(jsMediaSourcePrototypeFunction_setLiveSeekableRange);
static JSC_DECLARE_HOST_FUNCTION(jsMediaSourcePrototypeFunction_clearLiveSeekableRange);
static JSC_DECLARE_HOST_FUNCTION(jsMediaSourceConstructorFunction_isTypeSupported);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsMediaSourceConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaSource_detachable);
#if ENABLE(MEDIA_SOURCE_IN_WORKERS)
static JSC_DECLARE_CUSTOM_GETTER(jsMediaSource_handle);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsMediaSource_sourceBuffers);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaSource_activeSourceBuffers);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaSource_readyState);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaSource_duration);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaSource_duration);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaSource_onsourceopen);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaSource_onsourceopen);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaSource_onsourceended);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaSource_onsourceended);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaSource_onsourceclose);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaSource_onsourceclose);
#if ENABLE(MEDIA_SOURCE_IN_WORKERS)
static JSC_DECLARE_CUSTOM_GETTER(jsMediaSourceConstructor_canConstructInDedicatedWorker);
#endif

class JSMediaSourcePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMediaSourcePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaSourcePrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaSourcePrototype>(vm)) JSMediaSourcePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaSourcePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaSourcePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaSourcePrototype, JSMediaSourcePrototype::Base);

using JSMediaSourceDOMConstructor = JSDOMConstructor<JSMediaSource>;

/* Hash table for constructor */

static const std::array<HashTableValue, 2> JSMediaSourceConstructorTableValues {
#if ENABLE(MEDIA_SOURCE_IN_WORKERS)
    HashTableValue { "canConstructInDedicatedWorker"_s, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaSourceConstructor_canConstructInDedicatedWorker, 0 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    HashTableValue { "isTypeSupported"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaSourceConstructorFunction_isTypeSupported, 1 } },
};

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSMediaSourceDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSMediaSourceDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (!context) [[unlikely]]
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "MediaSource"_s);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto initConversionResult = convert<IDLDictionary<MediaSourceInit>>(*lexicalGlobalObject, argument0.value());
    if (initConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = MediaSource::create(*context, initConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<MediaSource>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<MediaSource>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSMediaSourceDOMConstructorConstruct, JSMediaSourceDOMConstructor::construct);

template<> const ClassInfo JSMediaSourceDOMConstructor::s_info = { "MediaSource"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaSourceDOMConstructor) };

template<> JSValue JSMediaSourceDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSMediaSourceDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "MediaSource"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSMediaSource::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSMediaSource::info(), JSMediaSourceConstructorTableValues, *this);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 15> JSMediaSourcePrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaSourceConstructor, 0 } },
    HashTableValue { "detachable"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaSource_detachable, 0 } },
#if ENABLE(MEDIA_SOURCE_IN_WORKERS)
    HashTableValue { "handle"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaSource_handle, 0 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    HashTableValue { "sourceBuffers"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaSource_sourceBuffers, 0 } },
    HashTableValue { "activeSourceBuffers"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaSource_activeSourceBuffers, 0 } },
    HashTableValue { "readyState"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaSource_readyState, 0 } },
    HashTableValue { "duration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaSource_duration, setJSMediaSource_duration } },
    HashTableValue { "onsourceopen"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaSource_onsourceopen, setJSMediaSource_onsourceopen } },
    HashTableValue { "onsourceended"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaSource_onsourceended, setJSMediaSource_onsourceended } },
    HashTableValue { "onsourceclose"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaSource_onsourceclose, setJSMediaSource_onsourceclose } },
    HashTableValue { "addSourceBuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaSourcePrototypeFunction_addSourceBuffer, 1 } },
    HashTableValue { "removeSourceBuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaSourcePrototypeFunction_removeSourceBuffer, 1 } },
    HashTableValue { "endOfStream"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaSourcePrototypeFunction_endOfStream, 0 } },
    HashTableValue { "setLiveSeekableRange"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaSourcePrototypeFunction_setLiveSeekableRange, 2 } },
    HashTableValue { "clearLiveSeekableRange"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaSourcePrototypeFunction_clearLiveSeekableRange, 0 } },
};

const ClassInfo JSMediaSourcePrototype::s_info = { "MediaSource"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaSourcePrototype) };

void JSMediaSourcePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaSource::info(), JSMediaSourcePrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().detachableMediaSourceEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "detachable"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#if ENABLE(MEDIA_SOURCE_IN_WORKERS)
    if (!((globalObject())->inherits<JSDedicatedWorkerGlobalScope>() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().mediaSourceInWorkerEnabled)) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "handle"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSMediaSource::s_info = { "MediaSource"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaSource) };

JSMediaSource::JSMediaSource(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaSource>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<MediaSource> JSMediaSource::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, MediaSource>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSMediaSource::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSMediaSourcePrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSMediaSourcePrototype::create(vm, &globalObject, structure);
}

JSObject* JSMediaSource::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMediaSource>(vm, globalObject);
}

JSValue JSMediaSource::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaSourceDOMConstructor, DOMConstructorID::MediaSource>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaSourceConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaSourcePrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMediaSource::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsMediaSource_detachableGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.detachable())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaSource_detachable, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSource>::get<jsMediaSource_detachableGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#if ENABLE(MEDIA_SOURCE_IN_WORKERS)
static inline JSValue jsMediaSource_handleGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<MediaSourceHandle>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.handle())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaSource_handle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSource>::get<jsMediaSource_handleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSValue jsMediaSource_sourceBuffersGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SourceBufferList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.sourceBuffers())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaSource_sourceBuffers, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSource>::get<jsMediaSource_sourceBuffersGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaSource_activeSourceBuffersGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SourceBufferList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.activeSourceBuffers())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaSource_activeSourceBuffers, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSource>::get<jsMediaSource_activeSourceBuffersGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaSource_readyStateGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<MediaSource::ReadyState>>(lexicalGlobalObject, throwScope, impl.readyState())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaSource_readyState, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSource>::get<jsMediaSource_readyStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaSource_durationGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.duration())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaSource_duration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSource>::get<jsMediaSource_durationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMediaSource_durationSetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setDuration(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaSource_duration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSource>::set<setJSMediaSource_durationSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMediaSource_onsourceopenGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().sourceopenEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaSource_onsourceopen, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSource>::get<jsMediaSource_onsourceopenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMediaSource_onsourceopenSetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().sourceopenEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaSource_onsourceopen, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSource>::set<setJSMediaSource_onsourceopenSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMediaSource_onsourceendedGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().sourceendedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaSource_onsourceended, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSource>::get<jsMediaSource_onsourceendedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMediaSource_onsourceendedSetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().sourceendedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaSource_onsourceended, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSource>::set<setJSMediaSource_onsourceendedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMediaSource_onsourcecloseGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().sourcecloseEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaSource_onsourceclose, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSource>::get<jsMediaSource_onsourcecloseGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMediaSource_onsourcecloseSetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().sourcecloseEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaSource_onsourceclose, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSource>::set<setJSMediaSource_onsourcecloseSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#if ENABLE(MEDIA_SOURCE_IN_WORKERS)
static inline JSValue jsMediaSourceConstructor_canConstructInDedicatedWorkerGetter(JSGlobalObject& lexicalGlobalObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return jsUndefined();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, MediaSource::canConstructInDedicatedWorker(*context))));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaSourceConstructor_canConstructInDedicatedWorker, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSource>::getStatic<jsMediaSourceConstructor_canConstructInDedicatedWorkerGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSC::EncodedJSValue jsMediaSourcePrototypeFunction_addSourceBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaSource>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<SourceBuffer>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.addSourceBuffer(typeConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaSourcePrototypeFunction_addSourceBuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaSource>::call<jsMediaSourcePrototypeFunction_addSourceBufferBody>(*lexicalGlobalObject, *callFrame, "addSourceBuffer");
}

static inline JSC::EncodedJSValue jsMediaSourcePrototypeFunction_removeSourceBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaSource>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto bufferConversionResult = convert<IDLInterface<SourceBuffer>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "buffer"_s, "MediaSource"_s, "removeSourceBuffer"_s, "SourceBuffer"_s); });
    if (bufferConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.removeSourceBuffer(*bufferConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaSourcePrototypeFunction_removeSourceBuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaSource>::call<jsMediaSourcePrototypeFunction_removeSourceBufferBody>(*lexicalGlobalObject, *callFrame, "removeSourceBuffer");
}

static inline JSC::EncodedJSValue jsMediaSourcePrototypeFunction_endOfStreamBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaSource>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto errorConversionResult = convert<IDLOptional<IDLEnumeration<MediaSource::EndOfStreamError>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "error"_s, "MediaSource"_s, "endOfStream"_s, expectedEnumerationValues<MediaSource::EndOfStreamError>()); });
    if (errorConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.endOfStream(errorConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaSourcePrototypeFunction_endOfStream, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaSource>::call<jsMediaSourcePrototypeFunction_endOfStreamBody>(*lexicalGlobalObject, *callFrame, "endOfStream");
}

static inline JSC::EncodedJSValue jsMediaSourcePrototypeFunction_setLiveSeekableRangeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaSource>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto startConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (startConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto endConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument1.value());
    if (endConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setLiveSeekableRange(startConversionResult.releaseReturnValue(), endConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaSourcePrototypeFunction_setLiveSeekableRange, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaSource>::call<jsMediaSourcePrototypeFunction_setLiveSeekableRangeBody>(*lexicalGlobalObject, *callFrame, "setLiveSeekableRange");
}

static inline JSC::EncodedJSValue jsMediaSourcePrototypeFunction_clearLiveSeekableRangeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaSource>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.clearLiveSeekableRange(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaSourcePrototypeFunction_clearLiveSeekableRange, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaSource>::call<jsMediaSourcePrototypeFunction_clearLiveSeekableRangeBody>(*lexicalGlobalObject, *callFrame, "clearLiveSeekableRange");
}

static inline JSC::EncodedJSValue jsMediaSourceConstructorFunction_isTypeSupportedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, MediaSource::isTypeSupported(*context, typeConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaSourceConstructorFunction_isTypeSupported, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaSource>::callStatic<jsMediaSourceConstructorFunction_isTypeSupportedBody>(*lexicalGlobalObject, *callFrame, "isTypeSupported");
}

JSC::GCClient::IsoSubspace* JSMediaSource::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSMediaSource, UseCustomHeapCellType::No>(vm, "JSMediaSource"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForMediaSource.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForMediaSource = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForMediaSource.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForMediaSource = std::forward<decltype(space)>(space); }
    );
}

void JSMediaSource::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMediaSource*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSMediaSourceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsMediaSource = jsCast<JSMediaSource*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsMediaSource->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMediaSourceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMediaSource = static_cast<JSMediaSource*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsMediaSource->protectedWrapped().ptr(), jsMediaSource);
}

MediaSource* JSMediaSource::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaSource*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_SOURCE)
