/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSIDBDatabase.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMStringList.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSIDBObjectStore.h"
#include "JSIDBTransaction.h"
#include "JSIDBTransactionDurability.h"
#include "JSIDBTransactionMode.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<IDBDatabase::ObjectStoreParameters>> convertDictionary<IDBDatabase::ObjectStoreParameters>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    IDBDatabase::ObjectStoreParameters result;
    JSValue autoIncrementValue;
    if (isNullOrUndefined)
        autoIncrementValue = jsUndefined();
    else {
        autoIncrementValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "autoIncrement"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto autoIncrementConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, autoIncrementValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (autoIncrementConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.autoIncrement = autoIncrementConversionResult.releaseReturnValue();
    JSValue keyPathValue;
    if (isNullOrUndefined)
        keyPathValue = jsUndefined();
    else {
        keyPathValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "keyPath"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto keyPathConversionResult = convertOptionalWithDefault<IDLNullable<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>>>(lexicalGlobalObject, keyPathValue, [&]() -> ConversionResult<IDLNullable<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>>> { return typename Converter<IDLNullable<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>>>::ReturnType { std::nullopt }; });
    if (keyPathConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.keyPath = keyPathConversionResult.releaseReturnValue();
    return result;
}

template<> ConversionResult<IDLDictionary<IDBDatabase::TransactionOptions>> convertDictionary<IDBDatabase::TransactionOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    IDBDatabase::TransactionOptions result;
    JSValue durabilityValue;
    if (isNullOrUndefined)
        durabilityValue = jsUndefined();
    else {
        durabilityValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "durability"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto durabilityConversionResult = convertOptionalWithDefault<IDLEnumeration<IDBTransactionDurability>>(lexicalGlobalObject, durabilityValue, [&]() -> ConversionResult<IDLEnumeration<IDBTransactionDurability>> { return Converter<IDLEnumeration<IDBTransactionDurability>>::ReturnType { IDBTransactionDurability::Default }; });
    if (durabilityConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.durability = durabilityConversionResult.releaseReturnValue();
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsIDBDatabasePrototypeFunction_transaction);
static JSC_DECLARE_HOST_FUNCTION(jsIDBDatabasePrototypeFunction_close);
static JSC_DECLARE_HOST_FUNCTION(jsIDBDatabasePrototypeFunction_createObjectStore);
static JSC_DECLARE_HOST_FUNCTION(jsIDBDatabasePrototypeFunction_deleteObjectStore);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsIDBDatabaseConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBDatabase_name);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBDatabase_version);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBDatabase_objectStoreNames);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBDatabase_onabort);
static JSC_DECLARE_CUSTOM_SETTER(setJSIDBDatabase_onabort);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBDatabase_onclose);
static JSC_DECLARE_CUSTOM_SETTER(setJSIDBDatabase_onclose);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBDatabase_onerror);
static JSC_DECLARE_CUSTOM_SETTER(setJSIDBDatabase_onerror);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBDatabase_onversionchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSIDBDatabase_onversionchange);

class JSIDBDatabasePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSIDBDatabasePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIDBDatabasePrototype* ptr = new (NotNull, JSC::allocateCell<JSIDBDatabasePrototype>(vm)) JSIDBDatabasePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIDBDatabasePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIDBDatabasePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIDBDatabasePrototype, JSIDBDatabasePrototype::Base);

using JSIDBDatabaseDOMConstructor = JSDOMConstructorNotConstructable<JSIDBDatabase>;

template<> const ClassInfo JSIDBDatabaseDOMConstructor::s_info = { "IDBDatabase"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBDatabaseDOMConstructor) };

template<> JSValue JSIDBDatabaseDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSIDBDatabaseDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "IDBDatabase"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSIDBDatabase::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 12> JSIDBDatabasePrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBDatabaseConstructor, 0 } },
    HashTableValue { "name"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBDatabase_name, 0 } },
    HashTableValue { "version"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBDatabase_version, 0 } },
    HashTableValue { "objectStoreNames"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBDatabase_objectStoreNames, 0 } },
    HashTableValue { "onabort"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBDatabase_onabort, setJSIDBDatabase_onabort } },
    HashTableValue { "onclose"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBDatabase_onclose, setJSIDBDatabase_onclose } },
    HashTableValue { "onerror"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBDatabase_onerror, setJSIDBDatabase_onerror } },
    HashTableValue { "onversionchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBDatabase_onversionchange, setJSIDBDatabase_onversionchange } },
    HashTableValue { "transaction"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBDatabasePrototypeFunction_transaction, 1 } },
    HashTableValue { "close"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBDatabasePrototypeFunction_close, 0 } },
    HashTableValue { "createObjectStore"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBDatabasePrototypeFunction_createObjectStore, 1 } },
    HashTableValue { "deleteObjectStore"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBDatabasePrototypeFunction_deleteObjectStore, 1 } },
};

const ClassInfo JSIDBDatabasePrototype::s_info = { "IDBDatabase"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBDatabasePrototype) };

void JSIDBDatabasePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIDBDatabase::info(), JSIDBDatabasePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSIDBDatabase::s_info = { "IDBDatabase"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBDatabase) };

JSIDBDatabase::JSIDBDatabase(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IDBDatabase>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<IDBDatabase> JSIDBDatabase::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, IDBDatabase>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSIDBDatabase::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSIDBDatabasePrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSIDBDatabasePrototype::create(vm, &globalObject, structure);
}

JSObject* JSIDBDatabase::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSIDBDatabase>(vm, globalObject);
}

JSValue JSIDBDatabase::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBDatabaseDOMConstructor, DOMConstructorID::IDBDatabase>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBDatabaseConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIDBDatabasePrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSIDBDatabase::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsIDBDatabase_nameGetter(JSGlobalObject& lexicalGlobalObject, JSIDBDatabase& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.name())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBDatabase_name, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBDatabase>::get<jsIDBDatabase_nameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIDBDatabase_versionGetter(JSGlobalObject& lexicalGlobalObject, JSIDBDatabase& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.version())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBDatabase_version, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBDatabase>::get<jsIDBDatabase_versionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIDBDatabase_objectStoreNamesGetter(JSGlobalObject& lexicalGlobalObject, JSIDBDatabase& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DOMStringList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.objectStoreNames())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBDatabase_objectStoreNames, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBDatabase>::get<jsIDBDatabase_objectStoreNamesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIDBDatabase_onabortGetter(JSGlobalObject& lexicalGlobalObject, JSIDBDatabase& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().abortEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBDatabase_onabort, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBDatabase>::get<jsIDBDatabase_onabortGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSIDBDatabase_onabortSetter(JSGlobalObject& lexicalGlobalObject, JSIDBDatabase& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().abortEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSIDBDatabase_onabort, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBDatabase>::set<setJSIDBDatabase_onabortSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsIDBDatabase_oncloseGetter(JSGlobalObject& lexicalGlobalObject, JSIDBDatabase& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().closeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBDatabase_onclose, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBDatabase>::get<jsIDBDatabase_oncloseGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSIDBDatabase_oncloseSetter(JSGlobalObject& lexicalGlobalObject, JSIDBDatabase& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().closeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSIDBDatabase_onclose, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBDatabase>::set<setJSIDBDatabase_oncloseSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsIDBDatabase_onerrorGetter(JSGlobalObject& lexicalGlobalObject, JSIDBDatabase& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBDatabase_onerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBDatabase>::get<jsIDBDatabase_onerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSIDBDatabase_onerrorSetter(JSGlobalObject& lexicalGlobalObject, JSIDBDatabase& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().errorEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSIDBDatabase_onerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBDatabase>::set<setJSIDBDatabase_onerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsIDBDatabase_onversionchangeGetter(JSGlobalObject& lexicalGlobalObject, JSIDBDatabase& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().versionchangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBDatabase_onversionchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBDatabase>::get<jsIDBDatabase_onversionchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSIDBDatabase_onversionchangeSetter(JSGlobalObject& lexicalGlobalObject, JSIDBDatabase& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().versionchangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSIDBDatabase_onversionchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBDatabase>::set<setJSIDBDatabase_onversionchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsIDBDatabasePrototypeFunction_transactionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBDatabase>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto storeNamesConversionResult = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>>(*lexicalGlobalObject, argument0.value());
    if (storeNamesConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto modeConversionResult = convertOptionalWithDefault<IDLEnumeration<IDBTransactionMode>>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLEnumeration<IDBTransactionMode>> { return Converter<IDLEnumeration<IDBTransactionMode>>::ReturnType { IDBTransactionMode::Readonly }; }, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "mode"_s, "IDBDatabase"_s, "transaction"_s, expectedEnumerationValues<IDBTransactionMode>()); });
    if (modeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto optionsConversionResult = convert<IDLDictionary<IDBDatabase::TransactionOptions>>(*lexicalGlobalObject, argument2.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBTransaction>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.transaction(storeNamesConversionResult.releaseReturnValue(), modeConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsIDBDatabasePrototypeFunction_transaction, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBDatabase>::call<jsIDBDatabasePrototypeFunction_transactionBody>(*lexicalGlobalObject, *callFrame, "transaction");
}

static inline JSC::EncodedJSValue jsIDBDatabasePrototypeFunction_closeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBDatabase>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.close(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsIDBDatabasePrototypeFunction_close, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBDatabase>::call<jsIDBDatabasePrototypeFunction_closeBody>(*lexicalGlobalObject, *callFrame, "close");
}

static inline JSC::EncodedJSValue jsIDBDatabasePrototypeFunction_createObjectStoreBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBDatabase>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto nameConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (nameConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto parametersConversionResult = convert<IDLDictionary<IDBDatabase::ObjectStoreParameters>>(*lexicalGlobalObject, argument1.value());
    if (parametersConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBObjectStore>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createObjectStore(nameConversionResult.releaseReturnValue(), parametersConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsIDBDatabasePrototypeFunction_createObjectStore, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBDatabase>::call<jsIDBDatabasePrototypeFunction_createObjectStoreBody>(*lexicalGlobalObject, *callFrame, "createObjectStore");
}

static inline JSC::EncodedJSValue jsIDBDatabasePrototypeFunction_deleteObjectStoreBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBDatabase>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto nameConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (nameConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.deleteObjectStore(nameConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsIDBDatabasePrototypeFunction_deleteObjectStore, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBDatabase>::call<jsIDBDatabasePrototypeFunction_deleteObjectStoreBody>(*lexicalGlobalObject, *callFrame, "deleteObjectStore");
}

JSC::GCClient::IsoSubspace* JSIDBDatabase::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSIDBDatabase, UseCustomHeapCellType::No>(vm, "JSIDBDatabase"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForIDBDatabase.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForIDBDatabase = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForIDBDatabase.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForIDBDatabase = std::forward<decltype(space)>(space); }
    );
}

void JSIDBDatabase::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSIDBDatabase*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSIDBDatabaseOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsIDBDatabase = jsCast<JSIDBDatabase*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsIDBDatabase->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSIDBDatabaseOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsIDBDatabase = static_cast<JSIDBDatabase*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsIDBDatabase->protectedWrapped().ptr(), jsIDBDatabase);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<IDBDatabase>&& impl)
{
    return createWrapper<IDBDatabase>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, IDBDatabase& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

IDBDatabase* JSIDBDatabase::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSIDBDatabase*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
