/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSIDBCursorDirection.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(IDBCursorDirection enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 4> values {
        MAKE_STATIC_STRING_IMPL("next"),
        MAKE_STATIC_STRING_IMPL("nextunique"),
        MAKE_STATIC_STRING_IMPL("prev"),
        MAKE_STATIC_STRING_IMPL("prevunique"),
    };
    static_assert(static_cast<size_t>(IDBCursorDirection::Next) == 0, "IDBCursorDirection::Next is not 0 as expected");
    static_assert(static_cast<size_t>(IDBCursorDirection::Nextunique) == 1, "IDBCursorDirection::Nextunique is not 1 as expected");
    static_assert(static_cast<size_t>(IDBCursorDirection::Prev) == 2, "IDBCursorDirection::Prev is not 2 as expected");
    static_assert(static_cast<size_t>(IDBCursorDirection::Prevunique) == 3, "IDBCursorDirection::Prevunique is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, IDBCursorDirection enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<IDBCursorDirection> parseEnumerationFromString<IDBCursorDirection>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, IDBCursorDirection>, 4> mappings {
        std::pair<ComparableASCIILiteral, IDBCursorDirection> { "next"_s, IDBCursorDirection::Next },
        std::pair<ComparableASCIILiteral, IDBCursorDirection> { "nextunique"_s, IDBCursorDirection::Nextunique },
        std::pair<ComparableASCIILiteral, IDBCursorDirection> { "prev"_s, IDBCursorDirection::Prev },
        std::pair<ComparableASCIILiteral, IDBCursorDirection> { "prevunique"_s, IDBCursorDirection::Prevunique },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<IDBCursorDirection> parseEnumeration<IDBCursorDirection>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<IDBCursorDirection>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<IDBCursorDirection>()
{
    return "\"next\", \"nextunique\", \"prev\", \"prevunique\""_s;
}

} // namespace WebCore

