/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUStorageTextureAccess.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(GPUStorageTextureAccess enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 3> values {
        MAKE_STATIC_STRING_IMPL("write-only"),
        MAKE_STATIC_STRING_IMPL("read-only"),
        MAKE_STATIC_STRING_IMPL("read-write"),
    };
    static_assert(static_cast<size_t>(GPUStorageTextureAccess::WriteOnly) == 0, "GPUStorageTextureAccess::WriteOnly is not 0 as expected");
    static_assert(static_cast<size_t>(GPUStorageTextureAccess::ReadOnly) == 1, "GPUStorageTextureAccess::ReadOnly is not 1 as expected");
    static_assert(static_cast<size_t>(GPUStorageTextureAccess::ReadWrite) == 2, "GPUStorageTextureAccess::ReadWrite is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, GPUStorageTextureAccess enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<GPUStorageTextureAccess> parseEnumerationFromString<GPUStorageTextureAccess>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, GPUStorageTextureAccess>, 3> mappings {
        std::pair<ComparableASCIILiteral, GPUStorageTextureAccess> { "read-only"_s, GPUStorageTextureAccess::ReadOnly },
        std::pair<ComparableASCIILiteral, GPUStorageTextureAccess> { "read-write"_s, GPUStorageTextureAccess::ReadWrite },
        std::pair<ComparableASCIILiteral, GPUStorageTextureAccess> { "write-only"_s, GPUStorageTextureAccess::WriteOnly },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<GPUStorageTextureAccess> parseEnumeration<GPUStorageTextureAccess>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<GPUStorageTextureAccess>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<GPUStorageTextureAccess>()
{
    return "\"write-only\", \"read-only\", \"read-write\""_s;
}

} // namespace WebCore

