/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSAnimationPlaybackEvent.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSAnimationPlaybackEventInit.h"
#include "JSCSSNumericValue.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsAnimationPlaybackEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsAnimationPlaybackEvent_currentTime);
static JSC_DECLARE_CUSTOM_GETTER(jsAnimationPlaybackEvent_timelineTime);

class JSAnimationPlaybackEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAnimationPlaybackEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAnimationPlaybackEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSAnimationPlaybackEventPrototype>(vm)) JSAnimationPlaybackEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAnimationPlaybackEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAnimationPlaybackEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAnimationPlaybackEventPrototype, JSAnimationPlaybackEventPrototype::Base);

using JSAnimationPlaybackEventDOMConstructor = JSDOMConstructor<JSAnimationPlaybackEvent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSAnimationPlaybackEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSAnimationPlaybackEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto eventInitDictConversionResult = convert<IDLDictionary<AnimationPlaybackEventInit>>(*lexicalGlobalObject, argument1.value());
    if (eventInitDictConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = AnimationPlaybackEvent::create(typeConversionResult.releaseReturnValue(), eventInitDictConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<AnimationPlaybackEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<AnimationPlaybackEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSAnimationPlaybackEventDOMConstructorConstruct, JSAnimationPlaybackEventDOMConstructor::construct);

template<> const ClassInfo JSAnimationPlaybackEventDOMConstructor::s_info = { "AnimationPlaybackEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAnimationPlaybackEventDOMConstructor) };

template<> JSValue JSAnimationPlaybackEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSAnimationPlaybackEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "AnimationPlaybackEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSAnimationPlaybackEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 3> JSAnimationPlaybackEventPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsAnimationPlaybackEventConstructor, 0 } },
    HashTableValue { "currentTime"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAnimationPlaybackEvent_currentTime, 0 } },
    HashTableValue { "timelineTime"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAnimationPlaybackEvent_timelineTime, 0 } },
};

const ClassInfo JSAnimationPlaybackEventPrototype::s_info = { "AnimationPlaybackEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAnimationPlaybackEventPrototype) };

void JSAnimationPlaybackEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAnimationPlaybackEvent::info(), JSAnimationPlaybackEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSAnimationPlaybackEvent::s_info = { "AnimationPlaybackEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAnimationPlaybackEvent) };

JSAnimationPlaybackEvent::JSAnimationPlaybackEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AnimationPlaybackEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<AnimationPlaybackEvent> JSAnimationPlaybackEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, AnimationPlaybackEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSAnimationPlaybackEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSAnimationPlaybackEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSAnimationPlaybackEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSAnimationPlaybackEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAnimationPlaybackEvent>(vm, globalObject);
}

JSValue JSAnimationPlaybackEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAnimationPlaybackEventDOMConstructor, DOMConstructorID::AnimationPlaybackEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsAnimationPlaybackEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAnimationPlaybackEventPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAnimationPlaybackEvent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsAnimationPlaybackEvent_currentTimeGetter(JSGlobalObject& lexicalGlobalObject, JSAnimationPlaybackEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.currentTime())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAnimationPlaybackEvent_currentTime, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAnimationPlaybackEvent>::get<jsAnimationPlaybackEvent_currentTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsAnimationPlaybackEvent_timelineTimeGetter(JSGlobalObject& lexicalGlobalObject, JSAnimationPlaybackEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.timelineTime())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAnimationPlaybackEvent_timelineTime, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAnimationPlaybackEvent>::get<jsAnimationPlaybackEvent_timelineTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSAnimationPlaybackEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSAnimationPlaybackEvent, UseCustomHeapCellType::No>(vm, "JSAnimationPlaybackEvent"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForAnimationPlaybackEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForAnimationPlaybackEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForAnimationPlaybackEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForAnimationPlaybackEvent = std::forward<decltype(space)>(space); }
    );
}

void JSAnimationPlaybackEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAnimationPlaybackEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AnimationPlaybackEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22AnimationPlaybackEventE[]; }
#endif
template<std::same_as<AnimationPlaybackEvent> T>
static inline void verifyVTable(AnimationPlaybackEvent* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7AnimationPlaybackEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore22AnimationPlaybackEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // AnimationPlaybackEvent has subclasses. If AnimationPlaybackEvent has subclasses that get passed
        // to toJS() we currently require AnimationPlaybackEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<AnimationPlaybackEvent>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<AnimationPlaybackEvent>(impl.ptr());
#endif
    return createWrapper<AnimationPlaybackEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, AnimationPlaybackEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
