/*
 * menu_video.h - SDL video settings menus.
 *
 * Written by
 *  Marco van den Heuvel <blackystardust68@yahoo.com>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#ifndef VICE_MENU_VIDEO_H
#define VICE_MENU_VIDEO_H

#include "vice.h"
#include "types.h"
#include "uimenu.h"

extern const ui_menu_entry_t c128_video_menu[];
extern const ui_menu_entry_t c64_video_menu[];
extern const ui_menu_entry_t c64dtv_video_menu[];
extern const ui_menu_entry_t c64sc_video_menu[];
extern const ui_menu_entry_t cbm5x0_video_menu[];
extern const ui_menu_entry_t cbm6x0_7x0_video_menu[];
extern const ui_menu_entry_t pet_video_menu[];
extern const ui_menu_entry_t plus4_video_menu[];
extern const ui_menu_entry_t vic20_video_menu[];

void uipalette_menu_create(char *chip1_name, char *chip2_name);
void uipalette_menu_shutdown(void);

#endif
