/* i386-bsd.elf-entry.h
   created from i386-bsd.elf-entry.bin, 31121 (0x7991) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) Markus Franz Xaver Johannes Oberhumer
   Copyright (C) Laszlo Molnar
   Copyright (C) John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_I386_BSD_ELF_ENTRY_SIZE    31121
#define STUB_I386_BSD_ELF_ENTRY_ADLER32 0xb6a45f4f
#define STUB_I386_BSD_ELF_ENTRY_CRC32   0x5f8ac0b5

unsigned char stub_i386_bsd_elf_entry[31121] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */  20, 36,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */   0,  0,  0,  0,232, 54,  0,  0,  0, 96,139,116, 36, 36,139,124,
/* 0x0040 */  36, 44,131,205,255,235,  3,164,235,  3,138,  6, 70,136,  7, 71,
/* 0x0050 */   1,219,117,  7,139, 30,131,238,252, 17,219,114,  1, 49,192, 64,
/* 0x0060 */ 138,  7,114,255,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,131,
/* 0x0070 */ 238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252, 17,
/* 0x0080 */ 219,115,255,  1,219,115,255,117,  9,139, 30,131,238,252, 17,219,
/* 0x0090 */ 115,255, 49,201,131,232,  3,114, 13,193,224,  8,138,  6, 70,131,
/* 0x00a0 */ 240,255,116,255,137,197,  1,219,117,  7,139, 30,131,238,252, 17,
/* 0x00b0 */ 219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,
/* 0x00c0 */ 117,255, 65,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,
/* 0x00d0 */   1,219,117,  7,139, 30,131,238,252, 17,219,115, 48,  1,219,115,
/* 0x00e0 */  48,117,  9,139, 30,131,238,252, 17,219,115, 48, 65, 65,131,193,
/* 0x00f0 */   2,129,253,  0,243,255,255,131,209,  1, 86,141, 52, 47,243,164,
/* 0x0100 */  94,233,252,255,255,255,141, 20, 47,131,253,252,138,  4, 15,118,
/* 0x0110 */ 255,138,  2, 66,136,  7, 71, 73,117,247,233,252,255,255,255,139,
/* 0x0120 */   2,131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,207,
/* 0x0130 */ 233,252,255,255,255,235,  3,164,235,  3,138,  6, 70,136,  7, 71,
/* 0x0140 */   1,219,117,  7,139, 30,131,238,252, 17,219,114,  1, 49,192, 64,
/* 0x0150 */ 138,  7,114,255,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,131,
/* 0x0160 */ 238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252, 17,
/* 0x0170 */ 219,114, 15,  1,219,115, 11,117, 15,139, 30,131,238,252, 17,219,
/* 0x0180 */ 114, 15, 72,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,
/* 0x0190 */ 235,255, 49,201,131,232,  3,114, 17,193,224,  8,138,  6, 70,131,
/* 0x01a0 */ 240,255,116,255,209,248,137,197,235, 11,  1,219,117,  7,139, 30,
/* 0x01b0 */ 131,238,252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252,
/* 0x01c0 */  17,219, 17,201,117,255, 65,  1,219,117,  7,139, 30,131,238,252,
/* 0x01d0 */  17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,115,
/* 0x01e0 */  68,  1,219,115, 68,117,  9,139, 30,131,238,252, 17,219,115, 68,
/* 0x01f0 */  65, 65,131,193,  2,129,253,  0,251,255,255,131,209,  1, 86,141,
/* 0x0200 */  52, 47,243,164, 94,233,252,255,255,255,141, 20, 47,131,253,252,
/* 0x0210 */ 138,  4, 15,118,255,138,  2, 66,136,  7, 71, 73,117,247,233,252,
/* 0x0220 */ 255,255,255,139,  2,131,194,  4,137,  7,131,199,  4,131,233,  4,
/* 0x0230 */ 119,241,  1,207,233,252,255,255,255,235,  3,164,235,  3,138,  6,
/* 0x0240 */  70,136,  7, 71,  1,219,117,  7,139, 30,131,238,252, 17,219,114,
/* 0x0250 */   1, 49,192, 64,138,  7,114,255,184,  1,  0,  0,  0,  1,219,117,
/* 0x0260 */   7,139, 30,131,238,252, 17,219, 17,192,  1,219,117,  7,139, 30,
/* 0x0270 */ 131,238,252, 17,219,114, 30,  1,219,115, 11,117, 30,139, 30,131,
/* 0x0280 */ 238,252, 17,219,114, 30, 72,  1,219,117,  7,139, 30,131,238,252,
/* 0x0290 */  17,219, 17,192,235,255,  1,219,117,  7,139, 30,131,238,252, 17,
/* 0x02a0 */ 219, 17,201,235,255, 49,201,131,232,  3,114, 17,193,224,  8,138,
/* 0x02b0 */   6, 70,131,240,255,116,255,209,248,137,197,235, 11,  1,219,117,
/* 0x02c0 */   7,139, 30,131,238,252, 17,219,114,204, 65,  1,219,117,  7,139,
/* 0x02d0 */  30,131,238,252, 17,219,114,190,  1,219,117,  7,139, 30,131,238,
/* 0x02e0 */ 252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,
/* 0x02f0 */ 115, 81,  1,219,115, 81,117,  9,139, 30,131,238,252, 17,219,115,
/* 0x0300 */  81, 65, 65,131,193,  2,129,253,  0,251,255,255,131,209,  2, 86,
/* 0x0310 */ 141, 52, 47,243,164, 94,233,252,255,255,255,141, 20, 47,131,253,
/* 0x0320 */ 252,138,  4, 15,118,255,138,  2, 66,136,  7, 71, 73,117,247,233,
/* 0x0330 */ 252,255,255,255,139,  2,131,194,  4,137,  7,131,199,  4,131,233,
/* 0x0340 */   4,119,241,  1,207,233,252,255,255,255,137,229,141,156, 36,  0,
/* 0x0350 */   0,  0,  0, 49,192, 80, 57,220,117,251, 70, 70, 83,104,  0,  0,
/* 0x0360 */   0,  0, 87,131,195,  4, 83,104,  0,  0,  0,  0, 86,131,195,  4,
/* 0x0370 */  83, 80,199,  3,  0,  0,  0,  0,137,229,139, 85, 40,172, 74,136,
/* 0x0380 */ 193, 36,  7,192,233,  3,187,  0,253,255,255,211,227,141,164, 92,
/* 0x0390 */ 144,241,255,255,131,228,224,106,  0,106,  0,137,227, 83,131,195,
/* 0x03a0 */   4,139, 77, 48,255, 49, 87, 83,131,195,  4,136, 67,  2,172, 74,
/* 0x03b0 */ 136,193, 36, 15,136,  3,192,233,  4,136, 75,  1, 82, 86, 83, 80,
/* 0x03c0 */  85, 87,191,  0,  0,  0,  0, 86, 83,131,236,100,139, 84, 36,120,
/* 0x03d0 */ 199, 68, 36, 92,  0,  0,  0,  0,141, 66,  4,137, 68, 36, 96,184,
/* 0x03e0 */   1,  0,  0,  0, 15,182, 74,  2,137,195,211,227,137,217, 73,137,
/* 0x03f0 */  76, 36, 88, 15,182, 74,  1,211,224,139,140, 36,144,  0,  0,  0,
/* 0x0400 */  72,137, 68, 36, 84,139,132, 36,132,  0,  0,  0, 15,182, 50,199,
/* 0x0410 */  68, 36, 76,  0,  0,  0,  0,199,  0,  0,  0,  0,  0,184,  0,  3,
/* 0x0420 */   0,  0,199, 68, 36, 72,  1,  0,  0,  0,137,116, 36, 80,199, 68,
/* 0x0430 */  36, 68,  1,  0,  0,  0,199, 68, 36, 64,  1,  0,  0,  0,199, 68,
/* 0x0440 */  36, 60,  1,  0,  0,  0,199,  1,  0,  0,  0,  0, 15,182, 74,  1,
/* 0x0450 */   1,241,211,224,141,136, 54,  7,  0,  0, 57, 76, 36, 92,115, 14,
/* 0x0460 */ 139, 68, 36, 96,102,199,  0,  0,  4,131,192,  2,226,246,139,108,
/* 0x0470 */  36,124,199, 68, 36, 48,  0,  0,  0,  0,199, 68, 36, 52,255,255,
/* 0x0480 */ 255,255,186,  0,  0,  0,  0,137,235,  3,156, 36,128,  0,  0,  0,
/* 0x0490 */ 137, 92, 36, 56, 59,108, 36, 56, 15,132,128,  8,  0,  0,193,100,
/* 0x04a0 */  36, 48,  8, 66, 15,182, 69,  0, 69,  9, 68, 36, 48,131,250,  4,
/* 0x04b0 */ 126,226,139,180, 36,140,  0,  0,  0, 57,116, 36, 92, 15,131,226,
/* 0x04c0 */   1,  0,  0,139,132, 36,136,  0,  0,  0,137, 68, 36, 24,139, 84,
/* 0x04d0 */  36, 92, 35, 84, 36, 88,139, 68, 36, 76,139, 76, 36, 96,193,224,
/* 0x04e0 */   4,137, 84, 36, 44,  1,208,129,124, 36, 52,255,255,255,  0,141,
/* 0x04f0 */  52, 65,119, 29, 59,108, 36, 56, 15,132, 32,  8,  0,  0,193,100,
/* 0x0500 */  36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36,
/* 0x0510 */  48,139, 68, 36, 52,102,139, 22,193,232, 11, 15,183,202, 15,175,
/* 0x0520 */ 193, 57, 68, 36, 48, 15,131, 80,  2,  0,  0,137, 68, 36, 52,184,
/* 0x0530 */   0,  8,  0,  0, 41,200,138, 76, 36, 80,193,248,  5,187,  1,  0,
/* 0x0540 */   0,  0,141,  4,  2,102,137,  6,139, 68, 36, 92, 35, 68, 36, 84,
/* 0x0550 */ 139,116, 36, 96,211,224,137,249, 15,182,209,185,  8,  0,  0,  0,
/* 0x0560 */  43, 76, 36, 80,211,250,  1,208,105,192,  0,  6,  0,  0,131,124,
/* 0x0570 */  36, 76,  6,141,132, 48,108, 14,  0,  0,137, 68, 36, 20, 15,142,
/* 0x0580 */  72,  1,  0,  0,139, 68, 36, 92, 43, 68, 36, 72,139,148, 36,136,
/* 0x0590 */   0,  0,  0, 15,182,  4, 16,137, 68, 36, 40,235, 46,137, 68, 36,
/* 0x05a0 */  52,184,  0,  8,  0,  0, 41,216,137,251,193,248,  5,133,210,141,
/* 0x05b0 */   4,  1,102,137,134,  0,  2,  0,  0, 15,133,106,  1,  0,  0,129,
/* 0x05c0 */ 251,255,  0,  0,  0, 15,143,143,  0,  0,  0,209,100, 36, 40,139,
/* 0x05d0 */  84, 36, 40,141, 60, 27,139, 76, 36, 20,129,226,  0,  1,  0,  0,
/* 0x05e0 */ 129,124, 36, 52,255,255,255,  0,141,  4, 81,141, 52, 56,119, 29,
/* 0x05f0 */  59,108, 36, 56, 15,132, 36,  7,  0,  0,193,100, 36, 48,  8,193,
/* 0x0600 */ 100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36,
/* 0x0610 */  52,102,139,142,  0,  2,  0,  0,193,232, 11, 15,183,217, 15,175,
/* 0x0620 */ 195, 57, 68, 36, 48, 15,130,114,255,255,255, 41, 68, 36, 52, 41,
/* 0x0630 */  68, 36, 48,137,200,102,193,232,  5,141, 95,  1,102, 41,193,133,
/* 0x0640 */ 210,102,137,142,  0,  2,  0,  0, 15,132,219,  0,  0,  0,129,251,
/* 0x0650 */ 255,  0,  0,  0, 15,142,113,255,255,255,139, 84, 36, 24,137,223,
/* 0x0660 */ 136, 26, 66,255, 68, 36, 92,131,124, 36, 76,  3,137, 84, 36, 24,
/* 0x0670 */  15,143,215,  0,  0,  0,199, 68, 36, 76,  0,  0,  0,  0,139,132,
/* 0x0680 */  36,140,  0,  0,  0, 57, 68, 36, 92, 15,130, 63,254,255,255,129,
/* 0x0690 */ 124, 36, 52,255,255,255,  0,119, 12, 59,108, 36, 56,184,  1,  0,
/* 0x06a0 */   0,  0,116, 32, 69, 43,108, 36,124,184,  0,  0,  0,  0,139,148,
/* 0x06b0 */  36,132,  0,  0,  0,139, 92, 36, 92,139,140, 36,144,  0,  0,  0,
/* 0x06c0 */ 137, 42,137, 25,131,196,100,233, 46,  8,  0,  0,129,124, 36, 52,
/* 0x06d0 */ 255,255,255,  0,141, 52, 27,139, 68, 36, 20,141, 28,  6,119, 29,
/* 0x06e0 */  59,108, 36, 56, 15,132, 52,  6,  0,  0,193,100, 36, 48,  8,193,
/* 0x06f0 */ 100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36,
/* 0x0700 */  52,102,139, 11,193,232, 11, 15,183,209, 15,175,194, 57, 68, 36,
/* 0x0710 */  48,115, 79,137, 68, 36, 52,184,  0,  8,  0,  0, 41,208,193,248,
/* 0x0720 */   5,141,  4,  1,102,137,  3,137,243,129,251,255,  0,  0,  0,126,
/* 0x0730 */ 155,139, 84, 36, 24,137,223,136, 26, 66,255, 68, 36, 92,131,124,
/* 0x0740 */  36, 76,  3,137, 84, 36, 24, 15,142, 41,255,255,255,131,124, 36,
/* 0x0750 */  76,  9, 15,143,107,  6,  0,  0,131,108, 36, 76,  3,233, 28,255,
/* 0x0760 */ 255,255, 41, 68, 36, 52, 41, 68, 36, 48,137,200,102,193,232,  5,
/* 0x0770 */ 102, 41,193,102,137, 11,141, 94,  1,235,174,139, 92, 36, 52, 41,
/* 0x0780 */  68, 36, 48, 41,195,137,208,102,193,232,  5,139, 76, 36, 76,102,
/* 0x0790 */  41,194,129,251,255,255,255,  0,102,137, 22,139,116, 36, 96,141,
/* 0x07a0 */  60, 78,119, 27, 59,108, 36, 56, 15,132,112,  5,  0,  0,193,100,
/* 0x07b0 */  36, 48,  8, 15,182, 69,  0,193,227,  8,  9, 68, 36, 48, 69,102,
/* 0x07c0 */ 139,151,128,  1,  0,  0,137,216,193,232, 11, 15,183,202, 15,175,
/* 0x07d0 */ 193, 57, 68, 36, 48, 15,131,228,  2,  0,  0,137,198,184,  0,  8,
/* 0x07e0 */   0,  0, 41,200,139, 92, 36, 96,193,248,  5,131,124, 36, 76,  6,
/* 0x07f0 */ 141,  4,  2,139, 76, 36, 72,139, 84, 36, 68,102,137,135,128,  1,
/* 0x0800 */   0,  0,139, 68, 36, 64,137, 76, 36, 68,137, 68, 36, 60,184,  0,
/* 0x0810 */   0,  0,  0, 15,159,192,137, 84, 36, 64,141,  4, 64,129,195,100,
/* 0x0820 */   6,  0,  0,137, 68, 36, 76,129,254,255,255,255,  0,119, 27, 59,
/* 0x0830 */ 108, 36, 56, 15,132,229,  4,  0,  0,193,100, 36, 48,  8, 15,182,
/* 0x0840 */  69,  0,193,230,  8,  9, 68, 36, 48, 69,102,139, 19,137,240,193,
/* 0x0850 */ 232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,102,  3,
/* 0x0860 */   0,  0,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,100, 36,
/* 0x0870 */  44,  4,193,248,  5,139, 76, 36, 44,141,  4,  2,199, 68, 36, 32,
/* 0x0880 */   0,  0,  0,  0,102,137,  3,141, 92, 25,  4,137, 92, 36, 16,199,
/* 0x0890 */  68, 36, 36,  3,  0,  0,  0,139,124, 36, 36,186,  1,  0,  0,  0,
/* 0x08a0 */ 235, 25,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,248,  5,
/* 0x08b0 */  79,141,  4,  2,137,242,102,137,  3,116, 97,129,124, 36, 52,255,
/* 0x08c0 */ 255,255,  0,141, 52, 18,139, 68, 36, 16,141, 28,  6,119, 29, 59,
/* 0x08d0 */ 108, 36, 56, 15,132, 69,  4,  0,  0,193,100, 36, 48,  8,193,100,
/* 0x08e0 */  36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,
/* 0x08f0 */ 102,139, 19,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48,
/* 0x0900 */ 114,160, 41, 68, 36, 52, 41, 68, 36, 48,137,208,102,193,232,  5,
/* 0x0910 */ 102, 41,194, 79,102,137, 19,141, 86,  1,117,159,138, 76, 36, 36,
/* 0x0920 */ 184,  1,  0,  0,  0,211,224, 41,194,  3, 84, 36, 32,131,124, 36,
/* 0x0930 */  76,  3,137, 84, 36, 12, 15,143,254,  3,  0,  0,131, 68, 36, 76,
/* 0x0940 */   7,131,250,  3,137,208,126,  5,184,  3,  0,  0,  0,139, 92, 36,
/* 0x0950 */  96,193,224,  7,191,  6,  0,  0,  0,141,132, 24, 96,  3,  0,  0,
/* 0x0960 */ 137, 68, 36,  8,184,  1,  0,  0,  0,235, 25,137, 68, 36, 52,184,
/* 0x0970 */   0,  8,  0,  0, 41,200,193,248,  5, 79,141,  4,  2,102,137,  3,
/* 0x0980 */ 137,240,116, 97,129,124, 36, 52,255,255,255,  0,141, 52,  0,139,
/* 0x0990 */  68, 36,  8,141, 28,  6,119, 29, 59,108, 36, 56, 15,132,124,  3,
/* 0x09a0 */   0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0,
/* 0x09b0 */  69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 19,193,232, 11, 15,
/* 0x09c0 */ 183,202, 15,175,193, 57, 68, 36, 48,114,160, 41, 68, 36, 52, 41,
/* 0x09d0 */  68, 36, 48,137,208,102,193,232,  5,102, 41,194, 79,102,137, 19,
/* 0x09e0 */ 141, 70,  1,117,159,141, 80,192,131,250,  3,137, 84, 36,  4, 15,
/* 0x09f0 */ 142, 54,  3,  0,  0,137,211,137,208,131,227,  1,209,248,131,203,
/* 0x0a00 */   2,131,250, 13,141,120,255, 15,143, 66,  4,  0,  0,137,249,139,
/* 0x0a10 */ 116, 36, 96,211,227,  1,210,141,  4, 94,137, 92, 36,  4, 41,208,
/* 0x0a20 */   5, 94,  5,  0,  0,137,  4, 36,184,  1,  0,  0,  0,199, 68, 36,
/* 0x0a30 */  28,  1,  0,  0,  0,235, 33,137, 68, 36, 52,184,  0,  8,  0,  0,
/* 0x0a40 */  41,200,193,248,  5,141,  4,  2,102,137,  3,137,240,209,100, 36,
/* 0x0a50 */  28, 79, 15,132,211,  2,  0,  0,129,124, 36, 52,255,255,255,  0,
/* 0x0a60 */ 141, 52,  0,139, 12, 36,141, 28, 14,119, 29, 59,108, 36, 56, 15,
/* 0x0a70 */ 132,169,  2,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,
/* 0x0a80 */ 182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 19,193,
/* 0x0a90 */ 232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48,114,153, 41, 68,
/* 0x0aa0 */  36, 52, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194,141,
/* 0x0ab0 */  70,  1,102,137, 19,139, 92, 36, 28,  9, 92, 36,  4,235,142, 41,
/* 0x0ac0 */ 195, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194,129,251,
/* 0x0ad0 */ 255,255,255,  0,102,137,151,128,  1,  0,  0, 15,134,107,  1,  0,
/* 0x0ae0 */   0,102,139,143,152,  1,  0,  0,137,218,193,234, 11, 15,183,193,
/* 0x0af0 */  15,175,208, 57, 84, 36, 48, 15,131,134,  1,  0,  0,190,  0,  8,
/* 0x0b00 */   0,  0,137,211, 41,198,137,240,193,248,  5,141,  4,  1,139, 76,
/* 0x0b10 */  36, 44,102,137,135,152,  1,  0,  0,139, 68, 36, 76,193,224,  5,
/* 0x0b20 */   3, 68, 36, 96,129,250,255,255,255,  0,141, 60, 72,119, 27, 59,
/* 0x0b30 */ 108, 36, 56, 15,132,229,  1,  0,  0,193,100, 36, 48,  8, 15,182,
/* 0x0b40 */  69,  0,193,227,  8,  9, 68, 36, 48, 69,102,139,151,224,  1,  0,
/* 0x0b50 */   0,137,216,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48,
/* 0x0b60 */  15,131,103,  2,  0,  0,137, 68, 36, 52,184,  0,  8,  0,  0, 41,
/* 0x0b70 */ 200,193,248,  5,141,  4,  2,102,137,135,224,  1,  0,  0,139, 68,
/* 0x0b80 */  36, 92,133,192, 15,132,148,  1,  0,  0,131,124, 36, 76,  6,184,
/* 0x0b90 */   0,  0,  0,  0,139,156, 36,136,  0,  0,  0,139, 84, 36, 24, 15,
/* 0x0ba0 */ 159,192,141, 68,  0,  9,137, 68, 36, 76,139, 68, 36, 92, 43, 68,
/* 0x0bb0 */  36, 72, 15,182, 60, 24,137,248,136,  2, 66,255, 68, 36, 92,137,
/* 0x0bc0 */  84, 36, 24,233,182,250,255,255, 41,198, 41, 68, 36, 48,137,208,
/* 0x0bd0 */ 102,193,232,  5,102, 41,194,129,254,255,255,255,  0,102,137, 19,
/* 0x0be0 */ 119, 27, 59,108, 36, 56, 15,132, 50,  1,  0,  0,193,100, 36, 48,
/* 0x0bf0 */   8, 15,182, 69,  0,193,230,  8,  9, 68, 36, 48, 69,102,139, 83,
/* 0x0c00 */   2,137,240,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48,
/* 0x0c10 */  15,131,119,  1,  0,  0,137, 68, 36, 52,184,  0,  8,  0,  0, 41,
/* 0x0c20 */ 200,193,100, 36, 44,  4,193,248,  5,139,116, 36, 44,141,  4,  2,
/* 0x0c30 */ 199, 68, 36, 32,  8,  0,  0,  0,102,137, 67,  2,141,156, 30,  4,
/* 0x0c40 */   1,  0,  0,137, 92, 36, 16,233, 67,252,255,255, 59,108, 36, 56,
/* 0x0c50 */  15,132,200,  0,  0,  0,193,100, 36, 48,  8,193,227,  8,102,139,
/* 0x0c60 */ 143,152,  1,  0,  0, 15,182, 69,  0,137,218,  9, 68, 36, 48,193,
/* 0x0c70 */ 234, 11, 15,183,193, 69, 15,175,208, 57, 84, 36, 48, 15,130,122,
/* 0x0c80 */ 254,255,255,137,200, 41,211,102,193,232,  5, 41, 84, 36, 48,102,
/* 0x0c90 */  41,193,129,251,255,255,255,  0,102,137,143,152,  1,  0,  0,119,
/* 0x0ca0 */  23, 59,108, 36, 56,116,119,193,100, 36, 48,  8, 15,182, 69,  0,
/* 0x0cb0 */ 193,227,  8,  9, 68, 36, 48, 69,102,139,151,176,  1,  0,  0,137,
/* 0x0cc0 */ 216,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,
/* 0x0cd0 */  22,  1,  0,  0,137,198,184,  0,  8,  0,  0, 41,200,193,248,  5,
/* 0x0ce0 */ 141,  4,  2,102,137,135,176,  1,  0,  0,139, 68, 36, 68,139, 84,
/* 0x0cf0 */  36, 72,137, 68, 36, 72,137, 84, 36, 68,131,124, 36, 76,  6,184,
/* 0x0d00 */   0,  0,  0,  0,139, 92, 36, 96, 15,159,192,129,195,104, 10,  0,
/* 0x0d10 */   0,141, 68, 64,  8,137, 68, 36, 76,233,  9,251,255,255,131,196,
/* 0x0d20 */ 100,184,  1,  0,  0,  0,233,207,  1,  0,  0,139,116, 36,  4, 70,
/* 0x0d30 */ 137,116, 36, 72, 15,132, 85,249,255,255,139, 76, 36, 12,139, 68,
/* 0x0d40 */  36, 92,131,193,  2, 57, 68, 36, 72,119,211,137,194,139,132, 36,
/* 0x0d50 */ 136,  0,  0,  0, 43, 68, 36, 72,  3,148, 36,136,  0,  0,  0,  3,
/* 0x0d60 */  68, 36, 92, 15,182, 56, 64,137,251,136, 26, 66,255, 68, 36, 92,
/* 0x0d70 */ 255, 68, 36, 24, 73, 15,132,  3,249,255,255,139,180, 36,140,  0,
/* 0x0d80 */   0,  0, 57,116, 36, 92,114,219,233,  2,249,255,255, 41,198, 41,
/* 0x0d90 */  68, 36, 48,137,208,137,116, 36, 52,102,193,232,  5,199, 68, 36,
/* 0x0da0 */  32, 16,  0,  0,  0,102, 41,194,199, 68, 36, 36,  8,  0,  0,  0,
/* 0x0db0 */ 102,137, 83,  2,129,195,  4,  2,  0,  0,137, 92, 36, 16,233,212,
/* 0x0dc0 */ 250,255,255,131,108, 36, 76,  6,233,177,248,255,255,137,222, 41,
/* 0x0dd0 */  68, 36, 48, 41,198,137,208,102,193,232,  5,102, 41,194,102,137,
/* 0x0de0 */ 151,224,  1,  0,  0,233, 16,255,255,255, 41,195, 41, 68, 36, 48,
/* 0x0df0 */ 137,208,102,193,232,  5,102, 41,194,129,251,255,255,255,  0,102,
/* 0x0e00 */ 137,151,176,  1,  0,  0, 15,134,165,  0,  0,  0,102,139,151,200,
/* 0x0e10 */   1,  0,  0,137,216,193,232, 11, 15,183,202, 15,175,193, 57, 68,
/* 0x0e20 */  36, 48, 15,131,169,  0,  0,  0,137,198,184,  0,  8,  0,  0, 41,
/* 0x0e30 */ 200,193,248,  5,141,  4,  2,102,137,135,200,  1,  0,  0,139, 68,
/* 0x0e40 */  36, 64,139, 92, 36, 68,137, 92, 36, 64,233,159,254,255,255,141,
/* 0x0e50 */  80,251,129,124, 36, 52,255,255,255,  0,119, 29, 59,108, 36, 56,
/* 0x0e60 */  15,132,184,254,255,255,193,100, 36, 48,  8,193,100, 36, 52,  8,
/* 0x0e70 */  15,182, 69,  0, 69,  9, 68, 36, 48,209,108, 36, 52,  1,219,139,
/* 0x0e80 */  68, 36, 52, 57, 68, 36, 48,114,  7, 41, 68, 36, 48,131,203,  1,
/* 0x0e90 */  74,117,191,139, 84, 36, 96,193,227,  4,191,  4,  0,  0,  0,137,
/* 0x0ea0 */  92, 36,  4,129,194, 68,  6,  0,  0,137, 20, 36,233,119,251,255,
/* 0x0eb0 */ 255, 59,108, 36, 56, 15,132, 99,254,255,255,193,100, 36, 48,  8,
/* 0x0ec0 */  15,182, 69,  0,193,227,  8,  9, 68, 36, 48, 69,233, 59,255,255,
/* 0x0ed0 */ 255,137,222, 41, 68, 36, 48, 41,198,137,208,102,193,232,  5,139,
/* 0x0ee0 */  76, 36, 64,102, 41,194,139, 68, 36, 60,102,137,151,200,  1,  0,
/* 0x0ef0 */   0,137, 76, 36, 60,233, 72,255,255,255, 91, 94, 95, 93, 85, 87,
/* 0x0f00 */ 191,  0,  0,  0,  0, 86, 83,131,236,100,139, 84, 36,120,199, 68,
/* 0x0f10 */  36, 92,  0,  0,  0,  0,141, 66,  4,137, 68, 36, 96,184,  1,  0,
/* 0x0f20 */   0,  0, 15,182, 74,  2,137,195,211,227,137,217, 73,137, 76, 36,
/* 0x0f30 */  88, 15,182, 74,  1,211,224,139,140, 36,144,  0,  0,  0, 72,137,
/* 0x0f40 */  68, 36, 84,139,132, 36,132,  0,  0,  0, 15,182, 50,199, 68, 36,
/* 0x0f50 */  76,  0,  0,  0,  0,199,  0,  0,  0,  0,  0,184,  0,  3,  0,  0,
/* 0x0f60 */ 199, 68, 36, 72,  1,  0,  0,  0,137,116, 36, 80,199, 68, 36, 68,
/* 0x0f70 */   1,  0,  0,  0,199, 68, 36, 64,  1,  0,  0,  0,199, 68, 36, 60,
/* 0x0f80 */   1,  0,  0,  0,199,  1,  0,  0,  0,  0, 15,182, 74,  1,  1,241,
/* 0x0f90 */ 211,224,141,136, 54,  7,  0,  0, 57, 76, 36, 92,115, 14,139, 68,
/* 0x0fa0 */  36, 96,102,199,  0,  0,  4,131,192,  2,226,246,139,108, 36,124,
/* 0x0fb0 */ 199, 68, 36, 48,  0,  0,  0,  0,199, 68, 36, 52,255,255,255,255,
/* 0x0fc0 */ 186,  0,  0,  0,  0,137,235,  3,156, 36,128,  0,  0,  0,137, 92,
/* 0x0fd0 */  36, 56, 59,108, 36, 56, 15,132,128,  8,  0,  0,193,100, 36, 48,
/* 0x0fe0 */   8, 66, 15,182, 69,  0, 69,  9, 68, 36, 48,131,250,  4,126,226,
/* 0x0ff0 */ 139,180, 36,140,  0,  0,  0, 57,116, 36, 92, 15,131,226,  1,  0,
/* 0x1000 */   0,139,132, 36,136,  0,  0,  0,137, 68, 36, 24,139, 84, 36, 92,
/* 0x1010 */  35, 84, 36, 88,139, 68, 36, 76,139, 76, 36, 96,193,224,  4,137,
/* 0x1020 */  84, 36, 44,  1,208,129,124, 36, 52,255,255,255,  0,141, 52, 65,
/* 0x1030 */ 119, 29, 59,108, 36, 56, 15,132, 32,  8,  0,  0,193,100, 36, 48,
/* 0x1040 */   8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139,
/* 0x1050 */  68, 36, 52,102,139, 22,193,232, 11, 15,183,202, 15,175,193, 57,
/* 0x1060 */  68, 36, 48, 15,131, 80,  2,  0,  0,137, 68, 36, 52,184,  0,  8,
/* 0x1070 */   0,  0, 41,200,138, 76, 36, 80,193,248,  5,187,  1,  0,  0,  0,
/* 0x1080 */ 141,  4,  2,102,137,  6,139, 68, 36, 92, 35, 68, 36, 84,139,116,
/* 0x1090 */  36, 96,211,224,137,249, 15,182,209,185,  8,  0,  0,  0, 43, 76,
/* 0x10a0 */  36, 80,211,250,  1,208,105,192,  0,  6,  0,  0,131,124, 36, 76,
/* 0x10b0 */   6,141,132, 48,108, 14,  0,  0,137, 68, 36, 20, 15,142, 72,  1,
/* 0x10c0 */   0,  0,139, 68, 36, 92, 43, 68, 36, 72,139,148, 36,136,  0,  0,
/* 0x10d0 */   0, 15,182,  4, 16,137, 68, 36, 40,235, 46,137, 68, 36, 52,184,
/* 0x10e0 */   0,  8,  0,  0, 41,216,137,251,193,248,  5,133,210,141,  4,  1,
/* 0x10f0 */ 102,137,134,  0,  2,  0,  0, 15,133,106,  1,  0,  0,129,251,255,
/* 0x1100 */   0,  0,  0, 15,143,143,  0,  0,  0,209,100, 36, 40,139, 84, 36,
/* 0x1110 */  40,141, 60, 27,139, 76, 36, 20,129,226,  0,  1,  0,  0,129,124,
/* 0x1120 */  36, 52,255,255,255,  0,141,  4, 81,141, 52, 56,119, 29, 59,108,
/* 0x1130 */  36, 56, 15,132, 36,  7,  0,  0,193,100, 36, 48,  8,193,100, 36,
/* 0x1140 */  52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,
/* 0x1150 */ 139,142,  0,  2,  0,  0,193,232, 11, 15,183,217, 15,175,195, 57,
/* 0x1160 */  68, 36, 48, 15,130,114,255,255,255, 41, 68, 36, 52, 41, 68, 36,
/* 0x1170 */  48,137,200,102,193,232,  5,141, 95,  1,102, 41,193,133,210,102,
/* 0x1180 */ 137,142,  0,  2,  0,  0, 15,132,219,  0,  0,  0,129,251,255,  0,
/* 0x1190 */   0,  0, 15,142,113,255,255,255,139, 84, 36, 24,137,223,136, 26,
/* 0x11a0 */  66,255, 68, 36, 92,131,124, 36, 76,  3,137, 84, 36, 24, 15,143,
/* 0x11b0 */ 215,  0,  0,  0,199, 68, 36, 76,  0,  0,  0,  0,139,132, 36,140,
/* 0x11c0 */   0,  0,  0, 57, 68, 36, 92, 15,130, 63,254,255,255,129,124, 36,
/* 0x11d0 */  52,255,255,255,  0,119, 12, 59,108, 36, 56,184,  1,  0,  0,  0,
/* 0x11e0 */ 116, 32, 69, 43,108, 36,124,184,  0,  0,  0,  0,139,148, 36,132,
/* 0x11f0 */   0,  0,  0,139, 92, 36, 92,139,140, 36,144,  0,  0,  0,137, 42,
/* 0x1200 */ 137, 25,131,196,100,233, 46,  8,  0,  0,129,124, 36, 52,255,255,
/* 0x1210 */ 255,  0,141, 52, 27,139, 68, 36, 20,141, 28,  6,119, 29, 59,108,
/* 0x1220 */  36, 56, 15,132, 52,  6,  0,  0,193,100, 36, 48,  8,193,100, 36,
/* 0x1230 */  52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,
/* 0x1240 */ 139, 11,193,232, 11, 15,183,209, 15,175,194, 57, 68, 36, 48,115,
/* 0x1250 */  79,137, 68, 36, 52,184,  0,  8,  0,  0, 41,208,193,248,  5,141,
/* 0x1260 */   4,  1,102,137,  3,137,243,129,251,255,  0,  0,  0,126,155,139,
/* 0x1270 */  84, 36, 24,137,223,136, 26, 66,255, 68, 36, 92,131,124, 36, 76,
/* 0x1280 */   3,137, 84, 36, 24, 15,142, 41,255,255,255,131,124, 36, 76,  9,
/* 0x1290 */  15,143,107,  6,  0,  0,131,108, 36, 76,  3,233, 28,255,255,255,
/* 0x12a0 */  41, 68, 36, 52, 41, 68, 36, 48,137,200,102,193,232,  5,102, 41,
/* 0x12b0 */ 193,102,137, 11,141, 94,  1,235,174,139, 92, 36, 52, 41, 68, 36,
/* 0x12c0 */  48, 41,195,137,208,102,193,232,  5,139, 76, 36, 76,102, 41,194,
/* 0x12d0 */ 129,251,255,255,255,  0,102,137, 22,139,116, 36, 96,141, 60, 78,
/* 0x12e0 */ 119, 27, 59,108, 36, 56, 15,132,112,  5,  0,  0,193,100, 36, 48,
/* 0x12f0 */   8, 15,182, 69,  0,193,227,  8,  9, 68, 36, 48, 69,102,139,151,
/* 0x1300 */ 128,  1,  0,  0,137,216,193,232, 11, 15,183,202, 15,175,193, 57,
/* 0x1310 */  68, 36, 48, 15,131,228,  2,  0,  0,137,198,184,  0,  8,  0,  0,
/* 0x1320 */  41,200,139, 92, 36, 96,193,248,  5,131,124, 36, 76,  6,141,  4,
/* 0x1330 */   2,139, 76, 36, 72,139, 84, 36, 68,102,137,135,128,  1,  0,  0,
/* 0x1340 */ 139, 68, 36, 64,137, 76, 36, 68,137, 68, 36, 60,184,  0,  0,  0,
/* 0x1350 */   0, 15,159,192,137, 84, 36, 64,141,  4, 64,129,195,100,  6,  0,
/* 0x1360 */   0,137, 68, 36, 76,129,254,255,255,255,  0,119, 27, 59,108, 36,
/* 0x1370 */  56, 15,132,229,  4,  0,  0,193,100, 36, 48,  8, 15,182, 69,  0,
/* 0x1380 */ 193,230,  8,  9, 68, 36, 48, 69,102,139, 19,137,240,193,232, 11,
/* 0x1390 */  15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,102,  3,  0,  0,
/* 0x13a0 */ 137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,100, 36, 44,  4,
/* 0x13b0 */ 193,248,  5,139, 76, 36, 44,141,  4,  2,199, 68, 36, 32,  0,  0,
/* 0x13c0 */   0,  0,102,137,  3,141, 92, 25,  4,137, 92, 36, 16,199, 68, 36,
/* 0x13d0 */  36,  3,  0,  0,  0,139,124, 36, 36,186,  1,  0,  0,  0,235, 25,
/* 0x13e0 */ 137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,248,  5, 79,141,
/* 0x13f0 */   4,  2,137,242,102,137,  3,116, 97,129,124, 36, 52,255,255,255,
/* 0x1400 */   0,141, 52, 18,139, 68, 36, 16,141, 28,  6,119, 29, 59,108, 36,
/* 0x1410 */  56, 15,132, 69,  4,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,
/* 0x1420 */   8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139,
/* 0x1430 */  19,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48,114,160,
/* 0x1440 */  41, 68, 36, 52, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,
/* 0x1450 */ 194, 79,102,137, 19,141, 86,  1,117,159,138, 76, 36, 36,184,  1,
/* 0x1460 */   0,  0,  0,211,224, 41,194,  3, 84, 36, 32,131,124, 36, 76,  3,
/* 0x1470 */ 137, 84, 36, 12, 15,143,254,  3,  0,  0,131, 68, 36, 76,  7,131,
/* 0x1480 */ 250,  3,137,208,126,  5,184,  3,  0,  0,  0,139, 92, 36, 96,193,
/* 0x1490 */ 224,  7,191,  6,  0,  0,  0,141,132, 24, 96,  3,  0,  0,137, 68,
/* 0x14a0 */  36,  8,184,  1,  0,  0,  0,235, 25,137, 68, 36, 52,184,  0,  8,
/* 0x14b0 */   0,  0, 41,200,193,248,  5, 79,141,  4,  2,102,137,  3,137,240,
/* 0x14c0 */ 116, 97,129,124, 36, 52,255,255,255,  0,141, 52,  0,139, 68, 36,
/* 0x14d0 */   8,141, 28,  6,119, 29, 59,108, 36, 56, 15,132,124,  3,  0,  0,
/* 0x14e0 */ 193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9,
/* 0x14f0 */  68, 36, 48,139, 68, 36, 52,102,139, 19,193,232, 11, 15,183,202,
/* 0x1500 */  15,175,193, 57, 68, 36, 48,114,160, 41, 68, 36, 52, 41, 68, 36,
/* 0x1510 */  48,137,208,102,193,232,  5,102, 41,194, 79,102,137, 19,141, 70,
/* 0x1520 */   1,117,159,141, 80,192,131,250,  3,137, 84, 36,  4, 15,142, 54,
/* 0x1530 */   3,  0,  0,137,211,137,208,131,227,  1,209,248,131,203,  2,131,
/* 0x1540 */ 250, 13,141,120,255, 15,143, 66,  4,  0,  0,137,249,139,116, 36,
/* 0x1550 */  96,211,227,  1,210,141,  4, 94,137, 92, 36,  4, 41,208,  5, 94,
/* 0x1560 */   5,  0,  0,137,  4, 36,184,  1,  0,  0,  0,199, 68, 36, 28,  1,
/* 0x1570 */   0,  0,  0,235, 33,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,
/* 0x1580 */ 193,248,  5,141,  4,  2,102,137,  3,137,240,209,100, 36, 28, 79,
/* 0x1590 */  15,132,211,  2,  0,  0,129,124, 36, 52,255,255,255,  0,141, 52,
/* 0x15a0 */   0,139, 12, 36,141, 28, 14,119, 29, 59,108, 36, 56, 15,132,169,
/* 0x15b0 */   2,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,
/* 0x15c0 */   0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 19,193,232, 11,
/* 0x15d0 */  15,183,202, 15,175,193, 57, 68, 36, 48,114,153, 41, 68, 36, 52,
/* 0x15e0 */  41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194,141, 70,  1,
/* 0x15f0 */ 102,137, 19,139, 92, 36, 28,  9, 92, 36,  4,235,142, 41,195, 41,
/* 0x1600 */  68, 36, 48,137,208,102,193,232,  5,102, 41,194,129,251,255,255,
/* 0x1610 */ 255,  0,102,137,151,128,  1,  0,  0, 15,134,107,  1,  0,  0,102,
/* 0x1620 */ 139,143,152,  1,  0,  0,137,218,193,234, 11, 15,183,193, 15,175,
/* 0x1630 */ 208, 57, 84, 36, 48, 15,131,134,  1,  0,  0,190,  0,  8,  0,  0,
/* 0x1640 */ 137,211, 41,198,137,240,193,248,  5,141,  4,  1,139, 76, 36, 44,
/* 0x1650 */ 102,137,135,152,  1,  0,  0,139, 68, 36, 76,193,224,  5,  3, 68,
/* 0x1660 */  36, 96,129,250,255,255,255,  0,141, 60, 72,119, 27, 59,108, 36,
/* 0x1670 */  56, 15,132,229,  1,  0,  0,193,100, 36, 48,  8, 15,182, 69,  0,
/* 0x1680 */ 193,227,  8,  9, 68, 36, 48, 69,102,139,151,224,  1,  0,  0,137,
/* 0x1690 */ 216,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,
/* 0x16a0 */ 103,  2,  0,  0,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,
/* 0x16b0 */ 248,  5,141,  4,  2,102,137,135,224,  1,  0,  0,139, 68, 36, 92,
/* 0x16c0 */ 133,192, 15,132,148,  1,  0,  0,131,124, 36, 76,  6,184,  0,  0,
/* 0x16d0 */   0,  0,139,156, 36,136,  0,  0,  0,139, 84, 36, 24, 15,159,192,
/* 0x16e0 */ 141, 68,  0,  9,137, 68, 36, 76,139, 68, 36, 92, 43, 68, 36, 72,
/* 0x16f0 */  15,182, 60, 24,137,248,136,  2, 66,255, 68, 36, 92,137, 84, 36,
/* 0x1700 */  24,233,182,250,255,255, 41,198, 41, 68, 36, 48,137,208,102,193,
/* 0x1710 */ 232,  5,102, 41,194,129,254,255,255,255,  0,102,137, 19,119, 27,
/* 0x1720 */  59,108, 36, 56, 15,132, 50,  1,  0,  0,193,100, 36, 48,  8, 15,
/* 0x1730 */ 182, 69,  0,193,230,  8,  9, 68, 36, 48, 69,102,139, 83,  2,137,
/* 0x1740 */ 240,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,
/* 0x1750 */ 119,  1,  0,  0,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,
/* 0x1760 */ 100, 36, 44,  4,193,248,  5,139,116, 36, 44,141,  4,  2,199, 68,
/* 0x1770 */  36, 32,  8,  0,  0,  0,102,137, 67,  2,141,156, 30,  4,  1,  0,
/* 0x1780 */   0,137, 92, 36, 16,233, 67,252,255,255, 59,108, 36, 56, 15,132,
/* 0x1790 */ 200,  0,  0,  0,193,100, 36, 48,  8,193,227,  8,102,139,143,152,
/* 0x17a0 */   1,  0,  0, 15,182, 69,  0,137,218,  9, 68, 36, 48,193,234, 11,
/* 0x17b0 */  15,183,193, 69, 15,175,208, 57, 84, 36, 48, 15,130,122,254,255,
/* 0x17c0 */ 255,137,200, 41,211,102,193,232,  5, 41, 84, 36, 48,102, 41,193,
/* 0x17d0 */ 129,251,255,255,255,  0,102,137,143,152,  1,  0,  0,119, 23, 59,
/* 0x17e0 */ 108, 36, 56,116,119,193,100, 36, 48,  8, 15,182, 69,  0,193,227,
/* 0x17f0 */   8,  9, 68, 36, 48, 69,102,139,151,176,  1,  0,  0,137,216,193,
/* 0x1800 */ 232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131, 22,  1,
/* 0x1810 */   0,  0,137,198,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,
/* 0x1820 */   2,102,137,135,176,  1,  0,  0,139, 68, 36, 68,139, 84, 36, 72,
/* 0x1830 */ 137, 68, 36, 72,137, 84, 36, 68,131,124, 36, 76,  6,184,  0,  0,
/* 0x1840 */   0,  0,139, 92, 36, 96, 15,159,192,129,195,104, 10,  0,  0,141,
/* 0x1850 */  68, 64,  8,137, 68, 36, 76,233,  9,251,255,255,131,196,100,184,
/* 0x1860 */   1,  0,  0,  0,233,207,  1,  0,  0,139,116, 36,  4, 70,137,116,
/* 0x1870 */  36, 72, 15,132, 85,249,255,255,139, 76, 36, 12,139, 68, 36, 92,
/* 0x1880 */ 131,193,  2, 57, 68, 36, 72,119,211,137,194,139,132, 36,136,  0,
/* 0x1890 */   0,  0, 43, 68, 36, 72,  3,148, 36,136,  0,  0,  0,  3, 68, 36,
/* 0x18a0 */  92, 15,182, 56, 64,137,251,136, 26, 66,255, 68, 36, 92,255, 68,
/* 0x18b0 */  36, 24, 73, 15,132,  3,249,255,255,139,180, 36,140,  0,  0,  0,
/* 0x18c0 */  57,116, 36, 92,114,219,233,  2,249,255,255, 41,198, 41, 68, 36,
/* 0x18d0 */  48,137,208,137,116, 36, 52,102,193,232,  5,199, 68, 36, 32, 16,
/* 0x18e0 */   0,  0,  0,102, 41,194,199, 68, 36, 36,  8,  0,  0,  0,102,137,
/* 0x18f0 */  83,  2,129,195,  4,  2,  0,  0,137, 92, 36, 16,233,212,250,255,
/* 0x1900 */ 255,131,108, 36, 76,  6,233,177,248,255,255,137,222, 41, 68, 36,
/* 0x1910 */  48, 41,198,137,208,102,193,232,  5,102, 41,194,102,137,151,224,
/* 0x1920 */   1,  0,  0,233, 16,255,255,255, 41,195, 41, 68, 36, 48,137,208,
/* 0x1930 */ 102,193,232,  5,102, 41,194,129,251,255,255,255,  0,102,137,151,
/* 0x1940 */ 176,  1,  0,  0, 15,134,165,  0,  0,  0,102,139,151,200,  1,  0,
/* 0x1950 */   0,137,216,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48,
/* 0x1960 */  15,131,169,  0,  0,  0,137,198,184,  0,  8,  0,  0, 41,200,193,
/* 0x1970 */ 248,  5,141,  4,  2,102,137,135,200,  1,  0,  0,139, 68, 36, 64,
/* 0x1980 */ 139, 92, 36, 68,137, 92, 36, 64,233,159,254,255,255,141, 80,251,
/* 0x1990 */ 129,124, 36, 52,255,255,255,  0,119, 29, 59,108, 36, 56, 15,132,
/* 0x19a0 */ 184,254,255,255,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182,
/* 0x19b0 */  69,  0, 69,  9, 68, 36, 48,209,108, 36, 52,  1,219,139, 68, 36,
/* 0x19c0 */  52, 57, 68, 36, 48,114,  7, 41, 68, 36, 48,131,203,  1, 74,117,
/* 0x19d0 */ 191,139, 84, 36, 96,193,227,  4,191,  4,  0,  0,  0,137, 92, 36,
/* 0x19e0 */   4,129,194, 68,  6,  0,  0,137, 20, 36,233,119,251,255,255, 59,
/* 0x19f0 */ 108, 36, 56, 15,132, 99,254,255,255,193,100, 36, 48,  8, 15,182,
/* 0x1a00 */  69,  0,193,227,  8,  9, 68, 36, 48, 69,233, 59,255,255,255,137,
/* 0x1a10 */ 222, 41, 68, 36, 48, 41,198,137,208,102,193,232,  5,139, 76, 36,
/* 0x1a20 */  64,102, 41,194,139, 68, 36, 60,102,137,151,200,  1,  0,  0,137,
/* 0x1a30 */  76, 36, 60,233, 72,255,255,255, 91, 94, 95, 93,  3,115,252,  3,
/* 0x1a40 */ 123,248, 49,192,141,140, 36,  0,255,255,255,137,236, 80, 57,204,
/* 0x1a50 */ 117,251,137,236, 49,201,139, 84, 36, 36,  3, 84, 36, 40, 57,214,
/* 0x1a60 */ 116,  1, 72, 43,124, 36, 44,139, 84, 36, 48,137, 58,137, 68, 36,
/* 0x1a70 */  28, 97,195,235,  4, 90, 88, 89,151, 96, 49,219,187,  0,  0,  0,
/* 0x1a80 */   0,106, 15, 88,138,100, 36, 32,106, 15, 91,138,124, 36, 32,138,
/* 0x1a90 */  84, 36, 32,233,252,255,255,255, 15,183, 47, 43,110, 12, 41,221,
/* 0x1aa0 */ 117,255,131,237,  1,115,255,136, 95,255, 73,136,  7, 71,139,  7,
/* 0x1ab0 */ 156,102,193,232,  8,193,192, 16,134,196,157,115,255,176,  0, 15,
/* 0x1ac0 */ 200,115,255,193,232,  1,115,  4,254,203, 75, 35, 30,125,  2,  3,
/* 0x1ad0 */  30,137,  4,156,235,255,141, 20, 24, 15,182,210, 35, 22, 59, 22,
/* 0x1ae0 */ 114,  2, 43, 22,139,  4,148,254,203, 75, 35, 30,125,  2,  3, 30,
/* 0x1af0 */ 139, 44,156,133,237,117,  9, 80,139, 70,  4,254,200, 72, 35,  6,
/* 0x1b00 */ 125,  2,  3,  6, 49,237,137, 70,  4,135,108,132,  4, 88,137, 44,
/* 0x1b10 */ 148,137,  4,156, 41,248,131,233,  4,  3, 70, 16,  1,240,137,  7,
/* 0x1b20 */ 131,199,  4,235,255,233,252,255,255,255, 80,176,233,176,232, 80,
/* 0x1b30 */ 106,  0, 83,137,230, 94,137,218,178,233,178,232, 67,106,  0,254,
/* 0x1b40 */ 203, 75,117,255, 15,183,  7,131,199,  1, 60,128,114,  4, 60,143,
/* 0x1b50 */ 118,255, 41,208, 43, 70,  8,131,232,  2,116,255,131,232,  1,114,
/* 0x1b60 */ 255,115,255,122,  0,123,  0,248,235,255,131,233,  1,127,255,137,
/* 0x1b70 */ 231,185,  4,  1,  0,  0,139, 14,131,193,  5,139, 14,131,193,  4,
/* 0x1b80 */  49,192,243,171,137,252, 86, 97,151, 81, 80, 82,195,137,254,235,
/* 0x1b90 */  31,138,  7, 71, 60,128,114, 10, 60,143,119,  6,128,127,254, 15,
/* 0x1ba0 */ 116,  5, 44,232, 60,  1,119,255,131,249,  4,114,  4,139,  7, 40,
/* 0x1bb0 */ 208,117,255,134,196,193,192, 16,134,196, 41,248,  1,240,131,233,
/* 0x1bc0 */   4,171,131,233,  1,114,  4,138,  7, 71,235, 13,131,233,  1,115,
/* 0x1bd0 */   3,185,  0,  0,  0,  0,137,254,138,  7, 71, 44,232, 60,  1,119,
/* 0x1be0 */ 247,128, 63,  0,117,  6,139,  7,138, 95,  4,102,193,232,  8,134,
/* 0x1bf0 */ 196,193,192, 16,134,196, 41,248,128,235,232,  1,240,137,  7,131,
/* 0x1c00 */ 199,  5,136,216,226, 11,185,  0,  0,  0,  0,176,232,176,233,242,
/* 0x1c10 */ 174,117,  6,128, 63,  0,117,255,139,  7,102,193,232,  8,134,196,
/* 0x1c20 */ 193,192, 16,134,196, 41,248,  1,240,171,235,  4, 97,195,106, 29,
/* 0x1c30 */ 232, 29,  0,  0,  0, 80, 82, 79, 84, 95, 69, 88, 69, 67,124, 80,
/* 0x1c40 */  82, 79, 84, 95, 87, 82, 73, 84, 69, 32,102, 97,105,108,101,100,
/* 0x1c50 */  46, 10,106,  2, 80,106,  4, 88,205,128,106,127, 80,106,  1, 88,
/* 0x1c60 */ 205,128, 94,173,131,224,252, 80,141, 69,247, 43,  0,137,194,  3,
/* 0x1c70 */  64, 72,  5,255, 15,  0,  0, 37,  0,240,255,255,106,  0,106,  1,
/* 0x1c80 */  80, 49,201, 81, 81, 81,106,255,104, 18, 16,  0,  0,181, 16,106,
/* 0x1c90 */   7, 81, 80, 82,184,197,  0,  0,  0,205,128, 15,130,252,255,255,
/* 0x1ca0 */ 255,146, 91, 83,252,173, 80,137,225, 80, 81, 82,173, 80,173,137,
/* 0x1cb0 */  68, 36, 12, 86,255,213,131,196, 60,195, 93,232, 48,  0,  0,  0,
/* 0x1cc0 */   0,  0,  0,  0,102,105,108,101, 32,102,111,114,109, 97,116, 32,
/* 0x1cd0 */ 101,108,102, 51, 50, 45,105, 51, 56, 54, 10, 10, 83,101, 99,116,
/* 0x1ce0 */ 105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32,
/* 0x1cf0 */  32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32,
/* 0x1d00 */  32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32,
/* 0x1d10 */  32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32,
/* 0x1d20 */  65,108,103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32,
/* 0x1d30 */  76, 69, 88, 69, 67, 48, 48, 48, 32, 32, 32, 32, 32, 32, 48, 53,
/* 0x1d40 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 52, 32, 32, 50, 42, 42,
/* 0x1d50 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 49, 32,
/* 0x1d60 */  76, 69, 88, 69, 67, 48, 48, 57, 32, 32, 32, 32, 32, 32, 48, 32,
/* 0x1d70 */  32, 48, 32, 32, 48, 32, 32, 48, 51, 57, 32, 32, 50, 42, 42, 48,
/* 0x1d80 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 50, 32, 76,
/* 0x1d90 */  69, 88, 69, 67, 48, 49, 48, 32, 32, 32, 32, 32, 32, 48, 99, 32,
/* 0x1da0 */  32, 48, 32, 32, 48, 32, 32, 48, 51, 57, 32, 32, 50, 42, 42, 48,
/* 0x1db0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 51, 32, 78,
/* 0x1dc0 */  50, 66, 83, 77, 65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 51, 32,
/* 0x1dd0 */  32, 48, 32, 32, 48, 32, 32, 48, 52, 53, 32, 32, 50, 42, 42, 48,
/* 0x1de0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 52, 32, 78,
/* 0x1df0 */  50, 66, 70, 65, 83, 49, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32,
/* 0x1e00 */  32, 48, 32, 32, 48, 32, 32, 48, 52, 56, 32, 32, 50, 42, 42, 48,
/* 0x1e10 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 53, 32, 78,
/* 0x1e20 */  50, 66, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32, 48, 54, 32,
/* 0x1e30 */  32, 48, 32, 32, 48, 32, 32, 48, 52, 97, 32, 32, 50, 42, 42, 48,
/* 0x1e40 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 54, 32, 78,
/* 0x1e50 */  50, 66, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32, 32, 48, 98, 32,
/* 0x1e60 */  32, 48, 32, 32, 48, 32, 32, 48, 53, 48, 32, 32, 50, 42, 42, 48,
/* 0x1e70 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 55, 32, 78,
/* 0x1e80 */  50, 66, 83, 77, 65, 50, 48, 32, 32, 32, 32, 32, 32, 48, 53, 32,
/* 0x1e90 */  32, 48, 32, 32, 48, 32, 32, 48, 53, 98, 32, 32, 50, 42, 42, 48,
/* 0x1ea0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 56, 32, 78,
/* 0x1eb0 */  50, 66, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32, 32, 48, 57, 32,
/* 0x1ec0 */  32, 48, 32, 32, 48, 32, 32, 48, 54, 48, 32, 32, 50, 42, 42, 48,
/* 0x1ed0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 57, 32, 78,
/* 0x1ee0 */  50, 66, 68, 69, 67, 50, 48, 32, 32, 32, 32, 32, 32, 48,100, 32,
/* 0x1ef0 */  32, 48, 32, 32, 48, 32, 32, 48, 54, 57, 32, 32, 50, 42, 42, 48,
/* 0x1f00 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 48, 32, 78,
/* 0x1f10 */  50, 66, 83, 77, 65, 51, 48, 32, 32, 32, 32, 32, 32, 48,100, 32,
/* 0x1f20 */  32, 48, 32, 32, 48, 32, 32, 48, 55, 54, 32, 32, 50, 42, 42, 48,
/* 0x1f30 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 49, 32, 78,
/* 0x1f40 */  50, 66, 70, 65, 83, 51, 48, 32, 32, 32, 32, 32, 32, 48,102, 32,
/* 0x1f50 */  32, 48, 32, 32, 48, 32, 32, 48, 56, 51, 32, 32, 50, 42, 42, 48,
/* 0x1f60 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 50, 32, 78,
/* 0x1f70 */  50, 66, 68, 69, 67, 51, 48, 32, 32, 32, 32, 32, 32, 48, 51,101,
/* 0x1f80 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 57, 50, 32, 32, 50, 42, 42,
/* 0x1f90 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 51, 32,
/* 0x1fa0 */  78, 50, 66, 83, 77, 65, 52, 48, 32, 32, 32, 32, 32, 32, 48,100,
/* 0x1fb0 */  32, 32, 48, 32, 32, 48, 32, 32, 48,100, 48, 32, 32, 50, 42, 42,
/* 0x1fc0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 52, 32,
/* 0x1fd0 */  78, 50, 66, 70, 65, 83, 52, 48, 32, 32, 32, 32, 32, 32, 48,102,
/* 0x1fe0 */  32, 32, 48, 32, 32, 48, 32, 32, 48,100,100, 32, 32, 50, 42, 42,
/* 0x1ff0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 53, 32,
/* 0x2000 */  78, 50, 66, 83, 77, 65, 53, 48, 32, 32, 32, 32, 32, 32, 48, 50,
/* 0x2010 */  32, 32, 48, 32, 32, 48, 32, 32, 48,101, 99, 32, 32, 50, 42, 42,
/* 0x2020 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 54, 32,
/* 0x2030 */  78, 50, 66, 70, 65, 83, 53, 48, 32, 32, 32, 32, 32, 32, 48, 51,
/* 0x2040 */  32, 32, 48, 32, 32, 48, 32, 32, 48,101,101, 32, 32, 50, 42, 42,
/* 0x2050 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 55, 32,
/* 0x2060 */  78, 50, 66, 68, 69, 67, 53, 48, 32, 32, 32, 32, 32, 32, 48, 57,
/* 0x2070 */  32, 32, 48, 32, 32, 48, 32, 32, 48,102, 49, 32, 32, 50, 42, 42,
/* 0x2080 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 56, 32,
/* 0x2090 */  78, 50, 66, 83, 77, 65, 54, 48, 32, 32, 32, 32, 32, 32, 48, 99,
/* 0x20a0 */  32, 32, 48, 32, 32, 48, 32, 32, 48,102, 97, 32, 32, 50, 42, 42,
/* 0x20b0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 57, 32,
/* 0x20c0 */  78, 50, 66, 70, 65, 83, 54, 48, 32, 32, 32, 32, 32, 32, 48, 49,
/* 0x20d0 */  57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 48, 54, 32, 32, 50,
/* 0x20e0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50,
/* 0x20f0 */  48, 32, 78, 50, 66, 70, 65, 83, 54, 49, 32, 32, 32, 32, 32, 32,
/* 0x2100 */  48, 49, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 49,102, 32,
/* 0x2110 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2120 */  32, 50, 49, 32, 78, 50, 66, 68, 69, 67, 54, 48, 32, 32, 32, 32,
/* 0x2130 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 51, 53, 32,
/* 0x2140 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2150 */  32, 50, 50, 32, 78, 50, 68, 83, 77, 65, 49, 48, 32, 32, 32, 32,
/* 0x2160 */  32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 51, 53,
/* 0x2170 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2180 */  10, 32, 50, 51, 32, 78, 50, 68, 70, 65, 83, 49, 48, 32, 32, 32,
/* 0x2190 */  32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 51,
/* 0x21a0 */  56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x21b0 */  83, 10, 32, 50, 52, 32, 78, 50, 68, 70, 65, 83, 49, 49, 32, 32,
/* 0x21c0 */  32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x21d0 */  51, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x21e0 */  84, 83, 10, 32, 50, 53, 32, 78, 50, 68, 68, 69, 67, 49, 48, 32,
/* 0x21f0 */  32, 32, 32, 32, 32, 48, 98, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2200 */  49, 52, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2210 */  78, 84, 83, 10, 32, 50, 54, 32, 78, 50, 68, 83, 77, 65, 50, 48,
/* 0x2220 */  32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2230 */  48, 49, 52, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2240 */  69, 78, 84, 83, 10, 32, 50, 55, 32, 78, 50, 68, 70, 65, 83, 50,
/* 0x2250 */  48, 32, 32, 32, 32, 32, 32, 48, 57, 32, 32, 48, 32, 32, 48, 32,
/* 0x2260 */  32, 48, 49, 53, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2270 */  84, 69, 78, 84, 83, 10, 32, 50, 56, 32, 78, 50, 68, 68, 69, 67,
/* 0x2280 */  50, 48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48,
/* 0x2290 */  32, 32, 48, 49, 53, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x22a0 */  78, 84, 69, 78, 84, 83, 10, 32, 50, 57, 32, 78, 50, 68, 83, 77,
/* 0x22b0 */  65, 51, 48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32,
/* 0x22c0 */  48, 32, 32, 48, 49, 54, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x22d0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 48, 32, 78, 50, 68, 70,
/* 0x22e0 */  65, 83, 51, 48, 32, 32, 32, 32, 32, 32, 48,102, 32, 32, 48, 32,
/* 0x22f0 */  32, 48, 32, 32, 48, 49, 55, 51, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2300 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 49, 32, 78, 50, 68,
/* 0x2310 */  68, 69, 67, 51, 48, 32, 32, 32, 32, 32, 32, 48, 53, 50, 32, 32,
/* 0x2320 */  48, 32, 32, 48, 32, 32, 48, 49, 56, 50, 32, 32, 50, 42, 42, 48,
/* 0x2330 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 50, 32, 78,
/* 0x2340 */  50, 68, 83, 77, 65, 52, 48, 32, 32, 32, 32, 32, 32, 48,100, 32,
/* 0x2350 */  32, 48, 32, 32, 48, 32, 32, 48, 49,100, 52, 32, 32, 50, 42, 42,
/* 0x2360 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 51, 32,
/* 0x2370 */  78, 50, 68, 70, 65, 83, 52, 48, 32, 32, 32, 32, 32, 32, 48,102,
/* 0x2380 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49,101, 49, 32, 32, 50, 42,
/* 0x2390 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 52,
/* 0x23a0 */  32, 78, 50, 68, 83, 77, 65, 53, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x23b0 */  50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,102, 48, 32, 32, 50,
/* 0x23c0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51,
/* 0x23d0 */  53, 32, 78, 50, 68, 70, 65, 83, 53, 48, 32, 32, 32, 32, 32, 32,
/* 0x23e0 */  48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,102, 50, 32, 32,
/* 0x23f0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2400 */  51, 54, 32, 78, 50, 68, 68, 69, 67, 53, 48, 32, 32, 32, 32, 32,
/* 0x2410 */  32, 48, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,102, 53, 32,
/* 0x2420 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2430 */  32, 51, 55, 32, 78, 50, 68, 83, 77, 65, 54, 48, 32, 32, 32, 32,
/* 0x2440 */  32, 32, 48, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,102,101,
/* 0x2450 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2460 */  10, 32, 51, 56, 32, 78, 50, 68, 70, 65, 83, 54, 48, 32, 32, 32,
/* 0x2470 */  32, 32, 32, 48, 49, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50,
/* 0x2480 */  48, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2490 */  84, 83, 10, 32, 51, 57, 32, 78, 50, 68, 70, 65, 83, 54, 49, 32,
/* 0x24a0 */  32, 32, 32, 32, 32, 48, 49, 54, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x24b0 */  48, 50, 50, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x24c0 */  69, 78, 84, 83, 10, 32, 52, 48, 32, 78, 50, 68, 68, 69, 67, 54,
/* 0x24d0 */  48, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x24e0 */  48, 50, 51, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x24f0 */  69, 78, 84, 83, 10, 32, 52, 49, 32, 78, 50, 69, 83, 77, 65, 49,
/* 0x2500 */  48, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32,
/* 0x2510 */  32, 48, 50, 51, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2520 */  84, 69, 78, 84, 83, 10, 32, 52, 50, 32, 78, 50, 69, 70, 65, 83,
/* 0x2530 */  49, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48,
/* 0x2540 */  32, 32, 48, 50, 51, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2550 */  78, 84, 69, 78, 84, 83, 10, 32, 52, 51, 32, 78, 50, 69, 70, 65,
/* 0x2560 */  83, 49, 49, 32, 32, 32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32,
/* 0x2570 */  48, 32, 32, 48, 50, 51,101, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2580 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 52, 32, 78, 50, 69, 68,
/* 0x2590 */  69, 67, 49, 48, 32, 32, 32, 32, 32, 32, 48, 98, 32, 32, 48, 32,
/* 0x25a0 */  32, 48, 32, 32, 48, 50, 52, 52, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x25b0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 53, 32, 78, 50, 69,
/* 0x25c0 */  83, 77, 65, 50, 48, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48,
/* 0x25d0 */  32, 32, 48, 32, 32, 48, 50, 52,102, 32, 32, 50, 42, 42, 48, 32,
/* 0x25e0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 54, 32, 78, 50,
/* 0x25f0 */  69, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32, 32, 48, 57, 32, 32,
/* 0x2600 */  48, 32, 32, 48, 32, 32, 48, 50, 53, 52, 32, 32, 50, 42, 42, 48,
/* 0x2610 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 55, 32, 78,
/* 0x2620 */  50, 69, 68, 69, 67, 50, 48, 32, 32, 32, 32, 32, 32, 48,100, 32,
/* 0x2630 */  32, 48, 32, 32, 48, 32, 32, 48, 50, 53,100, 32, 32, 50, 42, 42,
/* 0x2640 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 56, 32,
/* 0x2650 */  78, 50, 69, 83, 77, 65, 51, 48, 32, 32, 32, 32, 32, 32, 48,100,
/* 0x2660 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 54, 97, 32, 32, 50, 42,
/* 0x2670 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 57,
/* 0x2680 */  32, 78, 50, 69, 70, 65, 83, 51, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x2690 */ 102, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 55, 55, 32, 32, 50,
/* 0x26a0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53,
/* 0x26b0 */  48, 32, 78, 50, 69, 68, 69, 67, 51, 48, 32, 32, 32, 32, 32, 32,
/* 0x26c0 */  48, 53,102, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 56, 54, 32,
/* 0x26d0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x26e0 */  32, 53, 49, 32, 78, 50, 69, 83, 77, 65, 52, 48, 32, 32, 32, 32,
/* 0x26f0 */  32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50,101, 53,
/* 0x2700 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2710 */  10, 32, 53, 50, 32, 78, 50, 69, 70, 65, 83, 52, 48, 32, 32, 32,
/* 0x2720 */  32, 32, 32, 48,102, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50,102,
/* 0x2730 */  50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2740 */  83, 10, 32, 53, 51, 32, 78, 50, 69, 83, 77, 65, 53, 48, 32, 32,
/* 0x2750 */  32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51,
/* 0x2760 */  48, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2770 */  84, 83, 10, 32, 53, 52, 32, 78, 50, 69, 70, 65, 83, 53, 48, 32,
/* 0x2780 */  32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2790 */  51, 48, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x27a0 */  78, 84, 83, 10, 32, 53, 53, 32, 78, 50, 69, 68, 69, 67, 53, 48,
/* 0x27b0 */  32, 32, 32, 32, 32, 32, 48, 57, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x27c0 */  48, 51, 48, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x27d0 */  69, 78, 84, 83, 10, 32, 53, 54, 32, 78, 50, 69, 83, 77, 65, 54,
/* 0x27e0 */  48, 32, 32, 32, 32, 32, 32, 48, 99, 32, 32, 48, 32, 32, 48, 32,
/* 0x27f0 */  32, 48, 51, 48,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2800 */  84, 69, 78, 84, 83, 10, 32, 53, 55, 32, 78, 50, 69, 70, 65, 83,
/* 0x2810 */  54, 48, 32, 32, 32, 32, 32, 32, 48, 49, 57, 32, 32, 48, 32, 32,
/* 0x2820 */  48, 32, 32, 48, 51, 49, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2830 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 56, 32, 78, 50, 69, 70,
/* 0x2840 */  65, 83, 54, 49, 32, 32, 32, 32, 32, 32, 48, 49, 54, 32, 32, 48,
/* 0x2850 */  32, 32, 48, 32, 32, 48, 51, 51, 52, 32, 32, 50, 42, 42, 48, 32,
/* 0x2860 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 57, 32, 78, 50,
/* 0x2870 */  69, 68, 69, 67, 54, 48, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48,
/* 0x2880 */  32, 32, 48, 32, 32, 48, 51, 52, 97, 32, 32, 50, 42, 42, 48, 32,
/* 0x2890 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 48, 32, 76, 90,
/* 0x28a0 */  77, 65, 95, 68, 69, 67, 48, 48, 32, 32, 32, 32, 48, 50,101, 32,
/* 0x28b0 */  32, 48, 32, 32, 48, 32, 32, 48, 51, 52, 97, 32, 32, 50, 42, 42,
/* 0x28c0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 49, 32,
/* 0x28d0 */  76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32, 48, 52,
/* 0x28e0 */  56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 55, 56, 32, 32, 50,
/* 0x28f0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54,
/* 0x2900 */  50, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 32, 32, 32,
/* 0x2910 */  48, 98, 51,101, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 99, 48,
/* 0x2920 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2930 */  10, 32, 54, 51, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32,
/* 0x2940 */  32, 32, 32, 48, 98, 51,101, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2950 */ 101,102,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2960 */  78, 84, 83, 10, 32, 54, 52, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2970 */  51, 48, 32, 32, 32, 32, 48, 49, 97, 32, 32, 48, 32, 32, 48, 32,
/* 0x2980 */  32, 48, 49, 97, 51, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2990 */  78, 84, 69, 78, 84, 83, 10, 32, 54, 53, 32, 76, 69, 88, 69, 67,
/* 0x29a0 */  48, 49, 53, 32, 32, 32, 32, 32, 32, 48, 49,100, 32, 32, 48, 32,
/* 0x29b0 */  32, 48, 32, 32, 48, 49, 97, 53, 54, 32, 32, 50, 42, 42, 48, 32,
/* 0x29c0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 54, 32, 76, 88,
/* 0x29d0 */  85, 78, 70, 48, 48, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32,
/* 0x29e0 */  48, 32, 32, 48, 32, 32, 48, 49, 97, 55, 51, 32, 32, 50, 42, 42,
/* 0x29f0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 55, 32,
/* 0x2a00 */  76, 88, 85, 78, 70, 48, 48, 50, 32, 32, 32, 32, 32, 32, 48, 53,
/* 0x2a10 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 55, 53, 32, 32, 50,
/* 0x2a20 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54,
/* 0x2a30 */  56, 32, 77, 82, 85, 66, 89, 84, 69, 48, 32, 32, 32, 32, 32, 32,
/* 0x2a40 */  48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 55, 97, 32,
/* 0x2a50 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2a60 */  32, 54, 57, 32, 76, 88, 77, 82, 85, 48, 48, 53, 32, 32, 32, 32,
/* 0x2a70 */  32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 55,
/* 0x2a80 */  99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2a90 */  83, 10, 32, 55, 48, 32, 76, 88, 77, 82, 85, 48, 48, 54, 32, 32,
/* 0x2aa0 */  32, 32, 32, 32, 48, 55, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x2ab0 */  97, 56, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2ac0 */  78, 84, 83, 10, 32, 55, 49, 32, 76, 88, 77, 82, 85, 48, 48, 55,
/* 0x2ad0 */  32, 32, 32, 32, 32, 32, 48, 55, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2ae0 */  48, 49, 97, 56, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2af0 */  84, 69, 78, 84, 83, 10, 32, 55, 50, 32, 76, 88, 85, 78, 70, 48,
/* 0x2b00 */  48, 56, 32, 32, 32, 32, 32, 32, 48, 52, 32, 32, 48, 32, 32, 48,
/* 0x2b10 */  32, 32, 48, 49, 97, 56,102, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2b20 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 51, 32, 76, 88, 85, 78,
/* 0x2b30 */  70, 48, 49, 48, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32,
/* 0x2b40 */  32, 48, 32, 32, 48, 49, 97, 57, 51, 32, 32, 50, 42, 42, 48, 32,
/* 0x2b50 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 52, 32, 76, 88,
/* 0x2b60 */  74, 67, 67, 48, 49, 48, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32,
/* 0x2b70 */  48, 32, 32, 48, 32, 32, 48, 49, 97, 57, 56, 32, 32, 50, 42, 42,
/* 0x2b80 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 53, 32,
/* 0x2b90 */  76, 88, 77, 82, 85, 48, 52, 53, 32, 32, 32, 32, 32, 32, 48, 51,
/* 0x2ba0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 57, 98, 32, 32, 50,
/* 0x2bb0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55,
/* 0x2bc0 */  54, 32, 76, 88, 77, 82, 85, 48, 52, 54, 32, 32, 32, 32, 32, 32,
/* 0x2bd0 */  48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 57,101, 32,
/* 0x2be0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2bf0 */  32, 55, 55, 32, 76, 88, 74, 67, 67, 48, 50, 48, 32, 32, 32, 32,
/* 0x2c00 */  32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 97,
/* 0x2c10 */  48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2c20 */  83, 10, 32, 55, 56, 32, 76, 88, 74, 67, 67, 48, 50, 49, 32, 32,
/* 0x2c30 */  32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x2c40 */  97, 97, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2c50 */  78, 84, 83, 10, 32, 55, 57, 32, 76, 88, 74, 67, 67, 48, 50, 51,
/* 0x2c60 */  32, 32, 32, 32, 32, 32, 48, 55, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2c70 */  48, 49, 97, 97, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2c80 */  84, 69, 78, 84, 83, 10, 32, 56, 48, 32, 76, 88, 85, 78, 70, 48,
/* 0x2c90 */  51, 55, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48,
/* 0x2ca0 */  32, 32, 48, 49, 97, 97,101, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2cb0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 49, 32, 76, 88, 85, 78,
/* 0x2cc0 */  70, 51, 56, 54, 32, 32, 32, 32, 32, 32, 48, 49, 32, 32, 48, 32,
/* 0x2cd0 */  32, 48, 32, 32, 48, 49, 97, 98, 48, 32, 32, 50, 42, 42, 48, 32,
/* 0x2ce0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 50, 32, 76, 88,
/* 0x2cf0 */  85, 78, 70, 51, 56, 55, 32, 32, 32, 32, 32, 32, 48, 57, 32, 32,
/* 0x2d00 */  48, 32, 32, 48, 32, 32, 48, 49, 97, 98, 49, 32, 32, 50, 42, 42,
/* 0x2d10 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 51, 32,
/* 0x2d20 */  76, 88, 85, 78, 70, 51, 56, 56, 32, 32, 32, 32, 32, 32, 48, 51,
/* 0x2d30 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 98, 97, 32, 32, 50,
/* 0x2d40 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56,
/* 0x2d50 */  52, 32, 76, 88, 85, 78, 70, 52, 56, 54, 32, 32, 32, 32, 32, 32,
/* 0x2d60 */  48, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 98,100, 32,
/* 0x2d70 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2d80 */  32, 56, 53, 32, 76, 88, 85, 78, 70, 52, 56, 55, 32, 32, 32, 32,
/* 0x2d90 */  32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 99,
/* 0x2da0 */  49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2db0 */  83, 10, 32, 56, 54, 32, 76, 88, 77, 82, 85, 48, 54, 53, 32, 32,
/* 0x2dc0 */  32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x2dd0 */  97, 99, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2de0 */  78, 84, 83, 10, 32, 56, 55, 32, 77, 82, 85, 66, 89, 84, 69, 51,
/* 0x2df0 */  32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2e00 */  48, 49, 97, 99, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2e10 */  84, 69, 78, 84, 83, 10, 32, 56, 56, 32, 77, 82, 85, 65, 82, 66,
/* 0x2e20 */  51, 48, 32, 32, 32, 32, 32, 32, 48, 49, 32, 32, 48, 32, 32, 48,
/* 0x2e30 */  32, 32, 48, 49, 97, 99, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2e40 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 57, 32, 77, 82, 85, 66,
/* 0x2e50 */  73, 84, 83, 51, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32,
/* 0x2e60 */  32, 48, 32, 32, 48, 49, 97, 99, 98, 32, 32, 50, 42, 42, 48, 32,
/* 0x2e70 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 48, 32, 77, 82,
/* 0x2e80 */  85, 65, 82, 66, 52, 48, 32, 32, 32, 32, 32, 32, 48, 52, 32, 32,
/* 0x2e90 */  48, 32, 32, 48, 32, 32, 48, 49, 97, 99,100, 32, 32, 50, 42, 42,
/* 0x2ea0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 49, 32,
/* 0x2eb0 */  76, 88, 77, 82, 85, 48, 55, 48, 32, 32, 32, 32, 32, 32, 48, 56,
/* 0x2ec0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97,100, 49, 32, 32, 50,
/* 0x2ed0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57,
/* 0x2ee0 */  50, 32, 77, 82, 85, 66, 89, 84, 69, 52, 32, 32, 32, 32, 32, 32,
/* 0x2ef0 */  48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97,100, 57, 32,
/* 0x2f00 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2f10 */  32, 57, 51, 32, 77, 82, 85, 66, 73, 84, 83, 52, 32, 32, 32, 32,
/* 0x2f20 */  32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97,100,
/* 0x2f30 */  99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2f40 */  83, 10, 32, 57, 52, 32, 77, 82, 85, 65, 82, 66, 53, 48, 32, 32,
/* 0x2f50 */  32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x2f60 */  97,100,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2f70 */  78, 84, 83, 10, 32, 57, 53, 32, 76, 88, 77, 82, 85, 48, 56, 48,
/* 0x2f80 */  32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2f90 */  48, 49, 97,101, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2fa0 */  84, 69, 78, 84, 83, 10, 32, 57, 54, 32, 77, 82, 85, 66, 89, 84,
/* 0x2fb0 */  69, 53, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48,
/* 0x2fc0 */  32, 32, 48, 49, 97,101, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2fd0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 55, 32, 77, 82, 85, 65,
/* 0x2fe0 */  82, 66, 54, 48, 32, 32, 32, 32, 32, 32, 48, 49, 32, 32, 48, 32,
/* 0x2ff0 */  32, 48, 32, 32, 48, 49, 97,101, 57, 32, 32, 50, 42, 42, 48, 32,
/* 0x3000 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 56, 32, 77, 82,
/* 0x3010 */  85, 66, 73, 84, 83, 53, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32,
/* 0x3020 */  48, 32, 32, 48, 32, 32, 48, 49, 97,101, 97, 32, 32, 50, 42, 42,
/* 0x3030 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 57, 32,
/* 0x3040 */  77, 82, 85, 65, 82, 66, 55, 48, 32, 32, 32, 32, 32, 32, 48, 52,
/* 0x3050 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97,101, 99, 32, 32, 50,
/* 0x3060 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 48,
/* 0x3070 */  48, 32, 76, 88, 77, 82, 85, 48, 57, 48, 32, 32, 32, 32, 32, 32,
/* 0x3080 */  48, 98, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97,102, 48, 32,
/* 0x3090 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x30a0 */  49, 48, 49, 32, 77, 82, 85, 66, 89, 84, 69, 54, 32, 32, 32, 32,
/* 0x30b0 */  32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97,102,
/* 0x30c0 */  98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x30d0 */  83, 10, 49, 48, 50, 32, 77, 82, 85, 65, 82, 66, 56, 48, 32, 32,
/* 0x30e0 */  32, 32, 32, 32, 48, 49, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x30f0 */  97,102,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3100 */  78, 84, 83, 10, 49, 48, 51, 32, 77, 82, 85, 66, 73, 84, 83, 54,
/* 0x3110 */  32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x3120 */  48, 49, 97,102,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3130 */  84, 69, 78, 84, 83, 10, 49, 48, 52, 32, 77, 82, 85, 65, 82, 66,
/* 0x3140 */  57, 48, 32, 32, 32, 32, 32, 32, 48, 52, 32, 32, 48, 32, 32, 48,
/* 0x3150 */  32, 32, 48, 49, 98, 48, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3160 */  79, 78, 84, 69, 78, 84, 83, 10, 49, 48, 53, 32, 76, 88, 77, 82,
/* 0x3170 */  85, 49, 48, 48, 32, 32, 32, 32, 32, 32, 48, 49, 48, 32, 32, 48,
/* 0x3180 */  32, 32, 48, 32, 32, 48, 49, 98, 48, 52, 32, 32, 50, 42, 42, 48,
/* 0x3190 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 48, 54, 32, 76,
/* 0x31a0 */  88, 85, 78, 70, 48, 52, 48, 32, 32, 32, 32, 32, 32, 48, 53, 32,
/* 0x31b0 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 49, 52, 32, 32, 50, 42,
/* 0x31c0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 48, 55,
/* 0x31d0 */  32, 76, 88, 77, 82, 85, 49, 49, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x31e0 */  51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 49, 57, 32, 32,
/* 0x31f0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49,
/* 0x3200 */  48, 56, 32, 76, 88, 77, 82, 85, 49, 49, 49, 32, 32, 32, 32, 32,
/* 0x3210 */  32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 49, 99,
/* 0x3220 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x3230 */  10, 49, 48, 57, 32, 76, 88, 85, 78, 70, 48, 52, 49, 32, 32, 32,
/* 0x3240 */  32, 32, 32, 48, 55, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98,
/* 0x3250 */  49,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x3260 */  84, 83, 10, 49, 49, 48, 32, 76, 88, 85, 78, 70, 48, 52, 50, 32,
/* 0x3270 */  32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x3280 */  98, 50, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3290 */  78, 84, 83, 10, 49, 49, 49, 32, 76, 69, 88, 69, 67, 48, 49, 54,
/* 0x32a0 */  32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x32b0 */  48, 49, 98, 50, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x32c0 */  84, 69, 78, 84, 83, 10, 49, 49, 50, 32, 76, 88, 77, 82, 85, 48,
/* 0x32d0 */  49, 48, 32, 32, 32, 32, 32, 32, 48, 49, 32, 32, 48, 32, 32, 48,
/* 0x32e0 */  32, 32, 48, 49, 98, 50, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x32f0 */  79, 78, 84, 69, 78, 84, 83, 10, 49, 49, 51, 32, 76, 88, 74, 77,
/* 0x3300 */  80, 65, 48, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32,
/* 0x3310 */  32, 48, 32, 32, 48, 49, 98, 50, 98, 32, 32, 50, 42, 42, 48, 32,
/* 0x3320 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 49, 52, 32, 76, 88,
/* 0x3330 */  67, 65, 76, 76, 66, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32,
/* 0x3340 */  48, 32, 32, 48, 32, 32, 48, 49, 98, 50,100, 32, 32, 50, 42, 42,
/* 0x3350 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 49, 53, 32,
/* 0x3360 */  76, 88, 85, 78, 70, 48, 50, 49, 32, 32, 32, 32, 32, 32, 48, 54,
/* 0x3370 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 50,102, 32, 32, 50,
/* 0x3380 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 49,
/* 0x3390 */  54, 32, 76, 88, 77, 82, 85, 48, 50, 50, 32, 32, 32, 32, 32, 32,
/* 0x33a0 */  48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 51, 53, 32,
/* 0x33b0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x33c0 */  49, 49, 55, 32, 76, 88, 74, 77, 80, 65, 48, 49, 32, 32, 32, 32,
/* 0x33d0 */  32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 51,
/* 0x33e0 */  56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x33f0 */  83, 10, 49, 49, 56, 32, 76, 88, 67, 65, 76, 76, 66, 49, 32, 32,
/* 0x3400 */  32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x3410 */  98, 51, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3420 */  78, 84, 83, 10, 49, 49, 57, 32, 77, 82, 85, 66, 73, 84, 83, 49,
/* 0x3430 */  32, 32, 32, 32, 32, 32, 48, 49, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x3440 */  48, 49, 98, 51, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3450 */  84, 69, 78, 84, 83, 10, 49, 50, 48, 32, 76, 88, 77, 82, 85, 48,
/* 0x3460 */  51, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48,
/* 0x3470 */  32, 32, 48, 49, 98, 51,100, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3480 */  79, 78, 84, 69, 78, 84, 83, 10, 49, 50, 49, 32, 77, 82, 85, 66,
/* 0x3490 */  89, 84, 69, 49, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32,
/* 0x34a0 */  32, 48, 32, 32, 48, 49, 98, 51,102, 32, 32, 50, 42, 42, 48, 32,
/* 0x34b0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 50, 50, 32, 77, 82,
/* 0x34c0 */  85, 65, 82, 66, 49, 48, 32, 32, 32, 32, 32, 32, 48, 49, 32, 32,
/* 0x34d0 */  48, 32, 32, 48, 32, 32, 48, 49, 98, 52, 49, 32, 32, 50, 42, 42,
/* 0x34e0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 50, 51, 32,
/* 0x34f0 */  76, 88, 77, 82, 85, 48, 52, 48, 32, 32, 32, 32, 32, 32, 48, 50,
/* 0x3500 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 52, 50, 32, 32, 50,
/* 0x3510 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 50,
/* 0x3520 */  52, 32, 76, 88, 85, 78, 70, 48, 51, 48, 32, 32, 32, 32, 32, 32,
/* 0x3530 */  48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 52, 52, 32,
/* 0x3540 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x3550 */  49, 50, 53, 32, 76, 88, 74, 67, 67, 48, 48, 48, 32, 32, 32, 32,
/* 0x3560 */  32, 32, 48, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 52,
/* 0x3570 */  97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3580 */  83, 10, 49, 50, 54, 32, 76, 88, 67, 74, 48, 77, 82, 85, 32, 32,
/* 0x3590 */  32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x35a0 */  98, 53, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x35b0 */  78, 84, 83, 10, 49, 50, 55, 32, 76, 88, 67, 74, 49, 77, 82, 85,
/* 0x35c0 */  32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x35d0 */  48, 49, 98, 53, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x35e0 */  84, 69, 78, 84, 83, 10, 49, 50, 56, 32, 76, 88, 67, 65, 76, 74,
/* 0x35f0 */  77, 80, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48,
/* 0x3600 */  32, 32, 48, 49, 98, 53, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3610 */  79, 78, 84, 69, 78, 84, 83, 10, 49, 50, 57, 32, 76, 88, 67, 65,
/* 0x3620 */  76, 76, 48, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32,
/* 0x3630 */  32, 48, 32, 32, 48, 49, 98, 53, 97, 32, 32, 50, 42, 42, 48, 32,
/* 0x3640 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 51, 48, 32, 76, 88,
/* 0x3650 */  67, 65, 76, 76, 48, 49, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32,
/* 0x3660 */  48, 32, 32, 48, 32, 32, 48, 49, 98, 53, 99, 32, 32, 50, 42, 42,
/* 0x3670 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 51, 49, 32,
/* 0x3680 */  76, 88, 67, 74, 50, 77, 82, 85, 32, 32, 32, 32, 32, 32, 48, 50,
/* 0x3690 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 53,102, 32, 32, 50,
/* 0x36a0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 51,
/* 0x36b0 */  50, 32, 76, 88, 67, 74, 52, 77, 82, 85, 32, 32, 32, 32, 32, 32,
/* 0x36c0 */  48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 54, 49, 32,
/* 0x36d0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x36e0 */  49, 51, 51, 32, 76, 88, 67, 74, 54, 77, 82, 85, 32, 32, 32, 32,
/* 0x36f0 */  32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 54,
/* 0x3700 */  51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3710 */  83, 10, 49, 51, 52, 32, 76, 88, 67, 74, 55, 77, 82, 85, 32, 32,
/* 0x3720 */  32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x3730 */  98, 54, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3740 */  78, 84, 83, 10, 49, 51, 53, 32, 76, 88, 67, 74, 56, 77, 82, 85,
/* 0x3750 */  32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x3760 */  48, 49, 98, 54, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3770 */  84, 69, 78, 84, 83, 10, 49, 51, 54, 32, 76, 88, 85, 78, 70, 48,
/* 0x3780 */  51, 52, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48,
/* 0x3790 */  32, 32, 48, 49, 98, 54, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x37a0 */  79, 78, 84, 69, 78, 84, 83, 10, 49, 51, 55, 32, 76, 88, 77, 82,
/* 0x37b0 */  85, 48, 53, 53, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32,
/* 0x37c0 */  32, 48, 32, 32, 48, 49, 98, 54,102, 32, 32, 50, 42, 42, 48, 32,
/* 0x37d0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 51, 56, 32, 77, 82,
/* 0x37e0 */  85, 66, 89, 84, 69, 50, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32,
/* 0x37f0 */  48, 32, 32, 48, 32, 32, 48, 49, 98, 55, 49, 32, 32, 50, 42, 42,
/* 0x3800 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 51, 57, 32,
/* 0x3810 */  77, 82, 85, 66, 73, 84, 83, 50, 32, 32, 32, 32, 32, 32, 48, 53,
/* 0x3820 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 55, 54, 32, 32, 50,
/* 0x3830 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 52,
/* 0x3840 */  48, 32, 77, 82, 85, 65, 82, 66, 50, 48, 32, 32, 32, 32, 32, 32,
/* 0x3850 */  48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 55, 98, 32,
/* 0x3860 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x3870 */  49, 52, 49, 32, 76, 88, 77, 82, 85, 48, 53, 55, 32, 32, 32, 32,
/* 0x3880 */  32, 32, 48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 56,
/* 0x3890 */  48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x38a0 */  83, 10, 49, 52, 50, 32, 76, 88, 77, 82, 85, 48, 53, 56, 32, 32,
/* 0x38b0 */  32, 32, 32, 32, 48, 49, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x38c0 */  98, 56, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x38d0 */  78, 84, 83, 10, 49, 52, 51, 32, 76, 88, 85, 78, 70, 48, 51, 53,
/* 0x38e0 */  32, 32, 32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x38f0 */  48, 49, 98, 56, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3900 */  84, 69, 78, 84, 83, 10, 49, 52, 52, 32, 99,116,111,107, 51, 50,
/* 0x3910 */  46, 48, 48, 32, 32, 32, 32, 32, 48, 55, 32, 32, 48, 32, 32, 48,
/* 0x3920 */  32, 32, 48, 49, 98, 56,100, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3930 */  79, 78, 84, 69, 78, 84, 83, 10, 49, 52, 53, 32, 99,116,111,107,
/* 0x3940 */  51, 50, 46, 49, 48, 32, 32, 32, 32, 32, 48,101, 32, 32, 48, 32,
/* 0x3950 */  32, 48, 32, 32, 48, 49, 98, 57, 52, 32, 32, 50, 42, 42, 48, 32,
/* 0x3960 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 52, 54, 32, 99,116,
/* 0x3970 */ 111,107, 51, 50, 46, 50, 48, 32, 32, 32, 32, 32, 48, 50, 48, 32,
/* 0x3980 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 97, 50, 32, 32, 50, 42,
/* 0x3990 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 52, 55,
/* 0x39a0 */  32, 99,116,111,107, 51, 50, 46, 51, 48, 32, 32, 32, 32, 32, 48,
/* 0x39b0 */  97, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 99, 50, 32, 32,
/* 0x39c0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49,
/* 0x39d0 */  52, 56, 32, 99,116,111,107, 51, 50, 46, 52, 48, 32, 32, 32, 32,
/* 0x39e0 */  32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 99, 99,
/* 0x39f0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x3a00 */  10, 49, 52, 57, 32, 67, 65, 76, 76, 84, 82, 48, 48, 32, 32, 32,
/* 0x3a10 */  32, 32, 32, 48, 49, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x3a20 */  98,100, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3a30 */  78, 84, 83, 10, 49, 53, 48, 32, 67, 84, 67, 76, 69, 86, 69, 49,
/* 0x3a40 */  32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x3a50 */  48, 49, 98,101, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3a60 */  84, 69, 78, 84, 83, 10, 49, 53, 49, 32, 67, 65, 76, 76, 84, 82,
/* 0x3a70 */  48, 49, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48,
/* 0x3a80 */  32, 32, 48, 49, 98,101, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3a90 */  79, 78, 84, 69, 78, 84, 83, 10, 49, 53, 50, 32, 67, 84, 66, 83,
/* 0x3aa0 */  72, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 52, 32, 32, 48, 32,
/* 0x3ab0 */  32, 48, 32, 32, 48, 49, 98,101, 98, 32, 32, 50, 42, 42, 48, 32,
/* 0x3ac0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 53, 51, 32, 67, 84,
/* 0x3ad0 */  66, 82, 79, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32,
/* 0x3ae0 */  48, 32, 32, 48, 32, 32, 48, 49, 98,101,102, 32, 32, 50, 42, 42,
/* 0x3af0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 53, 52, 32,
/* 0x3b00 */  67, 84, 66, 83, 87, 65, 48, 49, 32, 32, 32, 32, 32, 32, 48, 53,
/* 0x3b10 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98,102, 49, 32, 32, 50,
/* 0x3b20 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 53,
/* 0x3b30 */  53, 32, 67, 65, 76, 76, 84, 82, 48, 50, 32, 32, 32, 32, 32, 32,
/* 0x3b40 */  48, 49, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98,102, 54,
/* 0x3b50 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x3b60 */  10, 49, 53, 54, 32, 67, 65, 76, 76, 84, 82, 49, 48, 32, 32, 32,
/* 0x3b70 */  32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 99,
/* 0x3b80 */  48, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x3b90 */  84, 83, 10, 49, 53, 55, 32, 67, 65, 76, 76, 84, 82, 69, 56, 32,
/* 0x3ba0 */  32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x3bb0 */  49, 99, 48, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3bc0 */  69, 78, 84, 83, 10, 49, 53, 56, 32, 67, 65, 76, 76, 84, 82, 69,
/* 0x3bd0 */  57, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32,
/* 0x3be0 */  32, 48, 49, 99, 48,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x3bf0 */  78, 84, 69, 78, 84, 83, 10, 49, 53, 57, 32, 67, 65, 76, 76, 84,
/* 0x3c00 */  82, 49, 49, 32, 32, 32, 32, 32, 32, 48, 52, 32, 32, 48, 32, 32,
/* 0x3c10 */  48, 32, 32, 48, 49, 99, 48,102, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3c20 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 54, 48, 32, 67, 84, 67,
/* 0x3c30 */  76, 69, 86, 69, 50, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48,
/* 0x3c40 */  32, 32, 48, 32, 32, 48, 49, 99, 49, 51, 32, 32, 50, 42, 42, 48,
/* 0x3c50 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 54, 49, 32, 67,
/* 0x3c60 */  65, 76, 76, 84, 82, 49, 50, 32, 32, 32, 32, 32, 32, 48, 50, 32,
/* 0x3c70 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 99, 49, 56, 32, 32, 50, 42,
/* 0x3c80 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 54, 50,
/* 0x3c90 */  32, 67, 84, 66, 83, 72, 82, 49, 49, 32, 32, 32, 32, 32, 32, 48,
/* 0x3ca0 */  52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 99, 49, 97, 32, 32,
/* 0x3cb0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49,
/* 0x3cc0 */  54, 51, 32, 67, 84, 66, 82, 79, 82, 49, 49, 32, 32, 32, 32, 32,
/* 0x3cd0 */  32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 99, 49,101,
/* 0x3ce0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x3cf0 */  10, 49, 54, 52, 32, 67, 84, 66, 83, 87, 65, 49, 49, 32, 32, 32,
/* 0x3d00 */  32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 99,
/* 0x3d10 */  50, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x3d20 */  84, 83, 10, 49, 54, 53, 32, 67, 65, 76, 76, 84, 82, 49, 51, 32,
/* 0x3d30 */  32, 32, 32, 32, 32, 48, 55, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x3d40 */  49, 99, 50, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3d50 */  69, 78, 84, 83, 10, 49, 54, 54, 32, 76, 69, 88, 69, 67, 48, 49,
/* 0x3d60 */  55, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32,
/* 0x3d70 */  32, 48, 49, 99, 50, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x3d80 */  78, 84, 69, 78, 84, 83, 10, 49, 54, 55, 32, 76, 69, 88, 69, 67,
/* 0x3d90 */  48, 50, 48, 32, 32, 32, 32, 32, 32, 48, 52,101, 32, 32, 48, 32,
/* 0x3da0 */  32, 48, 32, 32, 48, 49, 99, 50,101, 32, 32, 50, 42, 42, 48, 32,
/* 0x3db0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 54, 56, 32, 76, 85,
/* 0x3dc0 */  78, 77, 80, 48, 48, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32,
/* 0x3dd0 */  48, 32, 32, 48, 32, 32, 48, 49, 99, 55, 99, 32, 32, 50, 42, 42,
/* 0x3de0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 54, 57, 32,
/* 0x3df0 */  76, 85, 78, 77, 80, 48, 48, 49, 32, 32, 32, 32, 32, 32, 48, 50,
/* 0x3e00 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 99, 55,101, 32, 32, 50,
/* 0x3e10 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 55,
/* 0x3e20 */  48, 32, 76, 69, 88, 69, 67, 48, 50, 53, 32, 32, 32, 32, 32, 32,
/* 0x3e30 */  48, 52, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 99, 56, 48,
/* 0x3e40 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x3e50 */  10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48,
/* 0x3e60 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3e70 */  78, 50, 66, 83, 77, 65, 49, 48, 32, 48, 32, 78, 50, 66, 83, 77,
/* 0x3e80 */  65, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3e90 */  32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 49, 49, 32, 48, 32,
/* 0x3ea0 */  78, 50, 66, 70, 65, 83, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3eb0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67,
/* 0x3ec0 */  49, 48, 32, 48, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x3ed0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x3ee0 */  50, 66, 68, 69, 67, 50, 48, 32, 48, 32, 78, 50, 66, 68, 69, 67,
/* 0x3ef0 */  50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3f00 */  32,100, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48, 32, 48, 32, 78,
/* 0x3f10 */  50, 66, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f20 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 53,
/* 0x3f30 */  48, 32, 48, 32, 78, 50, 66, 68, 69, 67, 53, 48, 10, 48, 48, 48,
/* 0x3f40 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x3f50 */  66, 70, 65, 83, 54, 49, 32, 48, 32, 78, 50, 66, 70, 65, 83, 54,
/* 0x3f60 */  49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3f70 */ 100, 32, 32, 78, 50, 66, 68, 69, 67, 54, 48, 32, 48, 32, 78, 50,
/* 0x3f80 */  66, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3f90 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 49, 48,
/* 0x3fa0 */  32, 48, 32, 78, 50, 68, 83, 77, 65, 49, 48, 10, 48, 48, 48, 48,
/* 0x3fb0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68,
/* 0x3fc0 */  70, 65, 83, 49, 49, 32, 48, 32, 78, 50, 68, 70, 65, 83, 49, 49,
/* 0x3fd0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3fe0 */  32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 32, 48, 32, 78, 50, 68,
/* 0x3ff0 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4000 */  32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 50, 48, 32,
/* 0x4010 */  48, 32, 78, 50, 68, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x4020 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68,
/* 0x4030 */  69, 67, 51, 48, 32, 48, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10,
/* 0x4040 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4050 */  32, 78, 50, 68, 68, 69, 67, 53, 48, 32, 48, 32, 78, 50, 68, 68,
/* 0x4060 */  69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4070 */  32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 54, 49, 32, 48,
/* 0x4080 */  32, 78, 50, 68, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48,
/* 0x4090 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69,
/* 0x40a0 */  67, 54, 48, 32, 48, 32, 78, 50, 68, 68, 69, 67, 54, 48, 10, 48,
/* 0x40b0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x40c0 */  78, 50, 69, 83, 77, 65, 49, 48, 32, 48, 32, 78, 50, 69, 83, 77,
/* 0x40d0 */  65, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x40e0 */  32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 49, 49, 32, 48, 32,
/* 0x40f0 */  78, 50, 69, 70, 65, 83, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4100 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67,
/* 0x4110 */  49, 48, 32, 48, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x4120 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x4130 */  50, 69, 68, 69, 67, 50, 48, 32, 48, 32, 78, 50, 69, 68, 69, 67,
/* 0x4140 */  50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x4150 */  32,100, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 32, 48, 32, 78,
/* 0x4160 */  50, 69, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4170 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 53,
/* 0x4180 */  48, 32, 48, 32, 78, 50, 69, 68, 69, 67, 53, 48, 10, 48, 48, 48,
/* 0x4190 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x41a0 */  69, 70, 65, 83, 54, 49, 32, 48, 32, 78, 50, 69, 70, 65, 83, 54,
/* 0x41b0 */  49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x41c0 */ 100, 32, 32, 78, 50, 69, 68, 69, 67, 54, 48, 32, 48, 32, 78, 50,
/* 0x41d0 */  69, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x41e0 */ 108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85, 78, 70, 48, 49, 48,
/* 0x41f0 */  32, 48, 32, 76, 88, 85, 78, 70, 48, 49, 48, 10, 48, 48, 48, 48,
/* 0x4200 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 74,
/* 0x4210 */  67, 67, 48, 49, 48, 32, 48, 32, 76, 88, 74, 67, 67, 48, 49, 48,
/* 0x4220 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4230 */  32, 32, 76, 88, 85, 78, 70, 48, 51, 55, 32, 48, 32, 76, 88, 85,
/* 0x4240 */  78, 70, 48, 51, 55, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4250 */  32, 32, 32, 32,100, 32, 32, 76, 88, 77, 82, 85, 48, 55, 48, 32,
/* 0x4260 */  48, 32, 76, 88, 77, 82, 85, 48, 55, 48, 10, 48, 48, 48, 48, 48,
/* 0x4270 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 77, 82,
/* 0x4280 */  85, 49, 48, 48, 32, 48, 32, 76, 88, 77, 82, 85, 49, 48, 48, 10,
/* 0x4290 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x42a0 */  32, 76, 88, 85, 78, 70, 48, 52, 48, 32, 48, 32, 76, 88, 85, 78,
/* 0x42b0 */  70, 48, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x42c0 */  32, 32, 32,100, 32, 32, 76, 88, 85, 78, 70, 48, 52, 50, 32, 48,
/* 0x42d0 */  32, 76, 88, 85, 78, 70, 48, 52, 50, 10, 48, 48, 48, 48, 48, 48,
/* 0x42e0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 77, 82, 85,
/* 0x42f0 */  48, 51, 48, 32, 48, 32, 76, 88, 77, 82, 85, 48, 51, 48, 10, 48,
/* 0x4300 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x4310 */  76, 88, 85, 78, 70, 48, 51, 48, 32, 48, 32, 76, 88, 85, 78, 70,
/* 0x4320 */  48, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4330 */  32, 32,100, 32, 32, 76, 88, 67, 74, 56, 77, 82, 85, 32, 48, 32,
/* 0x4340 */  76, 88, 67, 74, 56, 77, 82, 85, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4350 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85, 78, 70, 48,
/* 0x4360 */  51, 52, 32, 48, 32, 76, 88, 85, 78, 70, 48, 51, 52, 10, 48, 48,
/* 0x4370 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,
/* 0x4380 */ 116,111,107, 51, 50, 46, 48, 48, 32, 48, 32, 99,116,111,107, 51,
/* 0x4390 */  50, 46, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x43a0 */  32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46, 49, 48, 32,
/* 0x43b0 */  48, 32, 99,116,111,107, 51, 50, 46, 49, 48, 10, 48, 48, 48, 48,
/* 0x43c0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,
/* 0x43d0 */ 107, 51, 50, 46, 50, 48, 32, 48, 32, 99,116,111,107, 51, 50, 46,
/* 0x43e0 */  50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x43f0 */  32,100, 32, 32, 99,116,111,107, 51, 50, 46, 52, 48, 32, 48, 32,
/* 0x4400 */  99,116,111,107, 51, 50, 46, 52, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x4410 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84,
/* 0x4420 */  82, 48, 48, 32, 48, 32, 67, 65, 76, 76, 84, 82, 48, 48, 10, 48,
/* 0x4430 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x4440 */  67, 65, 76, 76, 84, 82, 49, 48, 32, 48, 32, 67, 65, 76, 76, 84,
/* 0x4450 */  82, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4460 */  32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 49, 32, 48, 32,
/* 0x4470 */  67, 65, 76, 76, 84, 82, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4480 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82,
/* 0x4490 */  49, 51, 32, 48, 32, 67, 65, 76, 76, 84, 82, 49, 51, 10, 48, 48,
/* 0x44a0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x44b0 */  69, 88, 69, 67, 48, 50, 48, 32, 48, 32, 76, 69, 88, 69, 67, 48,
/* 0x44c0 */  50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x44d0 */  32,100, 32, 32, 76, 69, 88, 69, 67, 48, 50, 53, 32, 48, 32, 76,
/* 0x44e0 */  69, 88, 69, 67, 48, 50, 53, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x44f0 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 69, 88, 69, 67, 48, 48,
/* 0x4500 */  48, 32, 48, 32, 76, 69, 88, 69, 67, 48, 48, 48, 10, 48, 48, 48,
/* 0x4510 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 69,
/* 0x4520 */  88, 69, 67, 48, 48, 57, 32, 48, 32, 76, 69, 88, 69, 67, 48, 48,
/* 0x4530 */  57, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4540 */ 100, 32, 32, 76, 69, 88, 69, 67, 48, 49, 48, 32, 48, 32, 76, 69,
/* 0x4550 */  88, 69, 67, 48, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4560 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 49, 48,
/* 0x4570 */  32, 48, 32, 78, 50, 66, 70, 65, 83, 49, 48, 10, 48, 48, 48, 48,
/* 0x4580 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66,
/* 0x4590 */  83, 77, 65, 50, 48, 32, 48, 32, 78, 50, 66, 83, 77, 65, 50, 48,
/* 0x45a0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x45b0 */  32, 32, 78, 50, 66, 70, 65, 83, 50, 48, 32, 48, 32, 78, 50, 66,
/* 0x45c0 */  70, 65, 83, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x45d0 */  32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 51, 48, 32,
/* 0x45e0 */  48, 32, 78, 50, 66, 83, 77, 65, 51, 48, 10, 48, 48, 48, 48, 48,
/* 0x45f0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70,
/* 0x4600 */  65, 83, 51, 48, 32, 48, 32, 78, 50, 66, 70, 65, 83, 51, 48, 10,
/* 0x4610 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4620 */  32, 78, 50, 66, 83, 77, 65, 52, 48, 32, 48, 32, 78, 50, 66, 83,
/* 0x4630 */  77, 65, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4640 */  32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 52, 48, 32, 48,
/* 0x4650 */  32, 78, 50, 66, 70, 65, 83, 52, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x4660 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77,
/* 0x4670 */  65, 53, 48, 32, 48, 32, 78, 50, 66, 83, 77, 65, 53, 48, 10, 48,
/* 0x4680 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x4690 */  78, 50, 66, 70, 65, 83, 53, 48, 32, 48, 32, 78, 50, 66, 70, 65,
/* 0x46a0 */  83, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x46b0 */  32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 54, 48, 32, 48, 32,
/* 0x46c0 */  78, 50, 66, 83, 77, 65, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x46d0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83,
/* 0x46e0 */  54, 48, 32, 48, 32, 78, 50, 66, 70, 65, 83, 54, 48, 10, 48, 48,
/* 0x46f0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x4700 */  50, 68, 70, 65, 83, 49, 48, 32, 48, 32, 78, 50, 68, 70, 65, 83,
/* 0x4710 */  49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x4720 */  32,100, 32, 32, 78, 50, 68, 83, 77, 65, 50, 48, 32, 48, 32, 78,
/* 0x4730 */  50, 68, 83, 77, 65, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4740 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 50,
/* 0x4750 */  48, 32, 48, 32, 78, 50, 68, 70, 65, 83, 50, 48, 10, 48, 48, 48,
/* 0x4760 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x4770 */  68, 83, 77, 65, 51, 48, 32, 48, 32, 78, 50, 68, 83, 77, 65, 51,
/* 0x4780 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4790 */ 100, 32, 32, 78, 50, 68, 70, 65, 83, 51, 48, 32, 48, 32, 78, 50,
/* 0x47a0 */  68, 70, 65, 83, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x47b0 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 52, 48,
/* 0x47c0 */  32, 48, 32, 78, 50, 68, 83, 77, 65, 52, 48, 10, 48, 48, 48, 48,
/* 0x47d0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68,
/* 0x47e0 */  70, 65, 83, 52, 48, 32, 48, 32, 78, 50, 68, 70, 65, 83, 52, 48,
/* 0x47f0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4800 */  32, 32, 78, 50, 68, 83, 77, 65, 53, 48, 32, 48, 32, 78, 50, 68,
/* 0x4810 */  83, 77, 65, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4820 */  32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 53, 48, 32,
/* 0x4830 */  48, 32, 78, 50, 68, 70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48,
/* 0x4840 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83,
/* 0x4850 */  77, 65, 54, 48, 32, 48, 32, 78, 50, 68, 83, 77, 65, 54, 48, 10,
/* 0x4860 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4870 */  32, 78, 50, 68, 70, 65, 83, 54, 48, 32, 48, 32, 78, 50, 68, 70,
/* 0x4880 */  65, 83, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4890 */  32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 49, 48, 32, 48,
/* 0x48a0 */  32, 78, 50, 69, 70, 65, 83, 49, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x48b0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77,
/* 0x48c0 */  65, 50, 48, 32, 48, 32, 78, 50, 69, 83, 77, 65, 50, 48, 10, 48,
/* 0x48d0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x48e0 */  78, 50, 69, 70, 65, 83, 50, 48, 32, 48, 32, 78, 50, 69, 70, 65,
/* 0x48f0 */  83, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4900 */  32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 51, 48, 32, 48, 32,
/* 0x4910 */  78, 50, 69, 83, 77, 65, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4920 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83,
/* 0x4930 */  51, 48, 32, 48, 32, 78, 50, 69, 70, 65, 83, 51, 48, 10, 48, 48,
/* 0x4940 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x4950 */  50, 69, 83, 77, 65, 52, 48, 32, 48, 32, 78, 50, 69, 83, 77, 65,
/* 0x4960 */  52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x4970 */  32,100, 32, 32, 78, 50, 69, 70, 65, 83, 52, 48, 32, 48, 32, 78,
/* 0x4980 */  50, 69, 70, 65, 83, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4990 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 53,
/* 0x49a0 */  48, 32, 48, 32, 78, 50, 69, 83, 77, 65, 53, 48, 10, 48, 48, 48,
/* 0x49b0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x49c0 */  69, 70, 65, 83, 53, 48, 32, 48, 32, 78, 50, 69, 70, 65, 83, 53,
/* 0x49d0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x49e0 */ 100, 32, 32, 78, 50, 69, 83, 77, 65, 54, 48, 32, 48, 32, 78, 50,
/* 0x49f0 */  69, 83, 77, 65, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4a00 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 54, 48,
/* 0x4a10 */  32, 48, 32, 78, 50, 69, 70, 65, 83, 54, 48, 10, 48, 48, 48, 48,
/* 0x4a20 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77,
/* 0x4a30 */  65, 95, 68, 69, 67, 48, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68,
/* 0x4a40 */  69, 67, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4a50 */  32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,
/* 0x4a60 */  32, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48, 48,
/* 0x4a70 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x4a80 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 48, 32, 76, 90, 77, 65,
/* 0x4a90 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4aa0 */ 108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x4ab0 */  50, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x4ac0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4ad0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 48, 32, 76, 90,
/* 0x4ae0 */  77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4af0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 69, 88, 69, 67, 48,
/* 0x4b00 */  49, 53, 32, 48, 32, 76, 69, 88, 69, 67, 48, 49, 53, 10, 48, 48,
/* 0x4b10 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x4b20 */  88, 85, 78, 70, 48, 48, 48, 32, 48, 32, 76, 88, 85, 78, 70, 48,
/* 0x4b30 */  48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x4b40 */  32,100, 32, 32, 76, 88, 85, 78, 70, 48, 48, 50, 32, 48, 32, 76,
/* 0x4b50 */  88, 85, 78, 70, 48, 48, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4b60 */  32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 66, 89, 84, 69,
/* 0x4b70 */  48, 32, 48, 32, 77, 82, 85, 66, 89, 84, 69, 48, 10, 48, 48, 48,
/* 0x4b80 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88,
/* 0x4b90 */  77, 82, 85, 48, 48, 53, 32, 48, 32, 76, 88, 77, 82, 85, 48, 48,
/* 0x4ba0 */  53, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4bb0 */ 100, 32, 32, 76, 88, 77, 82, 85, 48, 48, 54, 32, 48, 32, 76, 88,
/* 0x4bc0 */  77, 82, 85, 48, 48, 54, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4bd0 */ 108, 32, 32, 32, 32,100, 32, 32, 76, 88, 77, 82, 85, 48, 48, 55,
/* 0x4be0 */  32, 48, 32, 76, 88, 77, 82, 85, 48, 48, 55, 10, 48, 48, 48, 48,
/* 0x4bf0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85,
/* 0x4c00 */  78, 70, 48, 48, 56, 32, 48, 32, 76, 88, 85, 78, 70, 48, 48, 56,
/* 0x4c10 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4c20 */  32, 32, 76, 88, 77, 82, 85, 48, 52, 53, 32, 48, 32, 76, 88, 77,
/* 0x4c30 */  82, 85, 48, 52, 53, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4c40 */  32, 32, 32, 32,100, 32, 32, 76, 88, 77, 82, 85, 48, 52, 54, 32,
/* 0x4c50 */  48, 32, 76, 88, 77, 82, 85, 48, 52, 54, 10, 48, 48, 48, 48, 48,
/* 0x4c60 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 74, 67,
/* 0x4c70 */  67, 48, 50, 48, 32, 48, 32, 76, 88, 74, 67, 67, 48, 50, 48, 10,
/* 0x4c80 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4c90 */  32, 76, 88, 74, 67, 67, 48, 50, 49, 32, 48, 32, 76, 88, 74, 67,
/* 0x4ca0 */  67, 48, 50, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4cb0 */  32, 32, 32,100, 32, 32, 76, 88, 74, 67, 67, 48, 50, 51, 32, 48,
/* 0x4cc0 */  32, 76, 88, 74, 67, 67, 48, 50, 51, 10, 48, 48, 48, 48, 48, 48,
/* 0x4cd0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85, 78, 70,
/* 0x4ce0 */  51, 56, 54, 32, 48, 32, 76, 88, 85, 78, 70, 51, 56, 54, 10, 48,
/* 0x4cf0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x4d00 */  76, 88, 85, 78, 70, 51, 56, 55, 32, 48, 32, 76, 88, 85, 78, 70,
/* 0x4d10 */  51, 56, 55, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4d20 */  32, 32,100, 32, 32, 76, 88, 85, 78, 70, 51, 56, 56, 32, 48, 32,
/* 0x4d30 */  76, 88, 85, 78, 70, 51, 56, 56, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4d40 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85, 78, 70, 52,
/* 0x4d50 */  56, 54, 32, 48, 32, 76, 88, 85, 78, 70, 52, 56, 54, 10, 48, 48,
/* 0x4d60 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x4d70 */  88, 85, 78, 70, 52, 56, 55, 32, 48, 32, 76, 88, 85, 78, 70, 52,
/* 0x4d80 */  56, 55, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x4d90 */  32,100, 32, 32, 76, 88, 77, 82, 85, 48, 54, 53, 32, 48, 32, 76,
/* 0x4da0 */  88, 77, 82, 85, 48, 54, 53, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4db0 */  32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 66, 89, 84, 69,
/* 0x4dc0 */  51, 32, 48, 32, 77, 82, 85, 66, 89, 84, 69, 51, 10, 48, 48, 48,
/* 0x4dd0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82,
/* 0x4de0 */  85, 65, 82, 66, 51, 48, 32, 48, 32, 77, 82, 85, 65, 82, 66, 51,
/* 0x4df0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4e00 */ 100, 32, 32, 77, 82, 85, 66, 73, 84, 83, 51, 32, 48, 32, 77, 82,
/* 0x4e10 */  85, 66, 73, 84, 83, 51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4e20 */ 108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 65, 82, 66, 52, 48,
/* 0x4e30 */  32, 48, 32, 77, 82, 85, 65, 82, 66, 52, 48, 10, 48, 48, 48, 48,
/* 0x4e40 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85,
/* 0x4e50 */  66, 89, 84, 69, 52, 32, 48, 32, 77, 82, 85, 66, 89, 84, 69, 52,
/* 0x4e60 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4e70 */  32, 32, 77, 82, 85, 66, 73, 84, 83, 52, 32, 48, 32, 77, 82, 85,
/* 0x4e80 */  66, 73, 84, 83, 52, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4e90 */  32, 32, 32, 32,100, 32, 32, 77, 82, 85, 65, 82, 66, 53, 48, 32,
/* 0x4ea0 */  48, 32, 77, 82, 85, 65, 82, 66, 53, 48, 10, 48, 48, 48, 48, 48,
/* 0x4eb0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 77, 82,
/* 0x4ec0 */  85, 48, 56, 48, 32, 48, 32, 76, 88, 77, 82, 85, 48, 56, 48, 10,
/* 0x4ed0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4ee0 */  32, 77, 82, 85, 66, 89, 84, 69, 53, 32, 48, 32, 77, 82, 85, 66,
/* 0x4ef0 */  89, 84, 69, 53, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4f00 */  32, 32, 32,100, 32, 32, 77, 82, 85, 65, 82, 66, 54, 48, 32, 48,
/* 0x4f10 */  32, 77, 82, 85, 65, 82, 66, 54, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x4f20 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 66, 73,
/* 0x4f30 */  84, 83, 53, 32, 48, 32, 77, 82, 85, 66, 73, 84, 83, 53, 10, 48,
/* 0x4f40 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x4f50 */  77, 82, 85, 65, 82, 66, 55, 48, 32, 48, 32, 77, 82, 85, 65, 82,
/* 0x4f60 */  66, 55, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4f70 */  32, 32,100, 32, 32, 76, 88, 77, 82, 85, 48, 57, 48, 32, 48, 32,
/* 0x4f80 */  76, 88, 77, 82, 85, 48, 57, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4f90 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 66, 89, 84,
/* 0x4fa0 */  69, 54, 32, 48, 32, 77, 82, 85, 66, 89, 84, 69, 54, 10, 48, 48,
/* 0x4fb0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77,
/* 0x4fc0 */  82, 85, 65, 82, 66, 56, 48, 32, 48, 32, 77, 82, 85, 65, 82, 66,
/* 0x4fd0 */  56, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x4fe0 */  32,100, 32, 32, 77, 82, 85, 66, 73, 84, 83, 54, 32, 48, 32, 77,
/* 0x4ff0 */  82, 85, 66, 73, 84, 83, 54, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5000 */  32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 65, 82, 66, 57,
/* 0x5010 */  48, 32, 48, 32, 77, 82, 85, 65, 82, 66, 57, 48, 10, 48, 48, 48,
/* 0x5020 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88,
/* 0x5030 */  77, 82, 85, 49, 49, 48, 32, 48, 32, 76, 88, 77, 82, 85, 49, 49,
/* 0x5040 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x5050 */ 100, 32, 32, 76, 88, 77, 82, 85, 49, 49, 49, 32, 48, 32, 76, 88,
/* 0x5060 */  77, 82, 85, 49, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5070 */ 108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85, 78, 70, 48, 52, 49,
/* 0x5080 */  32, 48, 32, 76, 88, 85, 78, 70, 48, 52, 49, 10, 48, 48, 48, 48,
/* 0x5090 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 69, 88,
/* 0x50a0 */  69, 67, 48, 49, 54, 32, 48, 32, 76, 69, 88, 69, 67, 48, 49, 54,
/* 0x50b0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x50c0 */  32, 32, 76, 88, 77, 82, 85, 48, 49, 48, 32, 48, 32, 76, 88, 77,
/* 0x50d0 */  82, 85, 48, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x50e0 */  32, 32, 32, 32,100, 32, 32, 76, 88, 74, 77, 80, 65, 48, 48, 32,
/* 0x50f0 */  48, 32, 76, 88, 74, 77, 80, 65, 48, 48, 10, 48, 48, 48, 48, 48,
/* 0x5100 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 67, 65,
/* 0x5110 */  76, 76, 66, 48, 32, 48, 32, 76, 88, 67, 65, 76, 76, 66, 48, 10,
/* 0x5120 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5130 */  32, 76, 88, 85, 78, 70, 48, 50, 49, 32, 48, 32, 76, 88, 85, 78,
/* 0x5140 */  70, 48, 50, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x5150 */  32, 32, 32,100, 32, 32, 76, 88, 77, 82, 85, 48, 50, 50, 32, 48,
/* 0x5160 */  32, 76, 88, 77, 82, 85, 48, 50, 50, 10, 48, 48, 48, 48, 48, 48,
/* 0x5170 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 74, 77, 80,
/* 0x5180 */  65, 48, 49, 32, 48, 32, 76, 88, 74, 77, 80, 65, 48, 49, 10, 48,
/* 0x5190 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x51a0 */  76, 88, 67, 65, 76, 76, 66, 49, 32, 48, 32, 76, 88, 67, 65, 76,
/* 0x51b0 */  76, 66, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x51c0 */  32, 32,100, 32, 32, 77, 82, 85, 66, 73, 84, 83, 49, 32, 48, 32,
/* 0x51d0 */  77, 82, 85, 66, 73, 84, 83, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x51e0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 66, 89, 84,
/* 0x51f0 */  69, 49, 32, 48, 32, 77, 82, 85, 66, 89, 84, 69, 49, 10, 48, 48,
/* 0x5200 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77,
/* 0x5210 */  82, 85, 65, 82, 66, 49, 48, 32, 48, 32, 77, 82, 85, 65, 82, 66,
/* 0x5220 */  49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x5230 */  32,100, 32, 32, 76, 88, 77, 82, 85, 48, 52, 48, 32, 48, 32, 76,
/* 0x5240 */  88, 77, 82, 85, 48, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5250 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 74, 67, 67, 48, 48,
/* 0x5260 */  48, 32, 48, 32, 76, 88, 74, 67, 67, 48, 48, 48, 10, 48, 48, 48,
/* 0x5270 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88,
/* 0x5280 */  67, 74, 48, 77, 82, 85, 32, 48, 32, 76, 88, 67, 74, 48, 77, 82,
/* 0x5290 */  85, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x52a0 */ 100, 32, 32, 76, 88, 67, 74, 49, 77, 82, 85, 32, 48, 32, 76, 88,
/* 0x52b0 */  67, 74, 49, 77, 82, 85, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x52c0 */ 108, 32, 32, 32, 32,100, 32, 32, 76, 88, 67, 65, 76, 74, 77, 80,
/* 0x52d0 */  32, 48, 32, 76, 88, 67, 65, 76, 74, 77, 80, 10, 48, 48, 48, 48,
/* 0x52e0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 67,
/* 0x52f0 */  65, 76, 76, 48, 48, 32, 48, 32, 76, 88, 67, 65, 76, 76, 48, 48,
/* 0x5300 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x5310 */  32, 32, 76, 88, 67, 65, 76, 76, 48, 49, 32, 48, 32, 76, 88, 67,
/* 0x5320 */  65, 76, 76, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x5330 */  32, 32, 32, 32,100, 32, 32, 76, 88, 67, 74, 50, 77, 82, 85, 32,
/* 0x5340 */  48, 32, 76, 88, 67, 74, 50, 77, 82, 85, 10, 48, 48, 48, 48, 48,
/* 0x5350 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 67, 74,
/* 0x5360 */  52, 77, 82, 85, 32, 48, 32, 76, 88, 67, 74, 52, 77, 82, 85, 10,
/* 0x5370 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5380 */  32, 76, 88, 67, 74, 54, 77, 82, 85, 32, 48, 32, 76, 88, 67, 74,
/* 0x5390 */  54, 77, 82, 85, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x53a0 */  32, 32, 32,100, 32, 32, 76, 88, 67, 74, 55, 77, 82, 85, 32, 48,
/* 0x53b0 */  32, 76, 88, 67, 74, 55, 77, 82, 85, 10, 48, 48, 48, 48, 48, 48,
/* 0x53c0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 77, 82, 85,
/* 0x53d0 */  48, 53, 53, 32, 48, 32, 76, 88, 77, 82, 85, 48, 53, 53, 10, 48,
/* 0x53e0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x53f0 */  77, 82, 85, 66, 89, 84, 69, 50, 32, 48, 32, 77, 82, 85, 66, 89,
/* 0x5400 */  84, 69, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x5410 */  32, 32,100, 32, 32, 77, 82, 85, 66, 73, 84, 83, 50, 32, 48, 32,
/* 0x5420 */  77, 82, 85, 66, 73, 84, 83, 50, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5430 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 65, 82, 66,
/* 0x5440 */  50, 48, 32, 48, 32, 77, 82, 85, 65, 82, 66, 50, 48, 10, 48, 48,
/* 0x5450 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x5460 */  88, 77, 82, 85, 48, 53, 55, 32, 48, 32, 76, 88, 77, 82, 85, 48,
/* 0x5470 */  53, 55, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x5480 */  32,100, 32, 32, 76, 88, 77, 82, 85, 48, 53, 56, 32, 48, 32, 76,
/* 0x5490 */  88, 77, 82, 85, 48, 53, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x54a0 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85, 78, 70, 48, 51,
/* 0x54b0 */  53, 32, 48, 32, 76, 88, 85, 78, 70, 48, 51, 53, 10, 48, 48, 48,
/* 0x54c0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,
/* 0x54d0 */ 111,107, 51, 50, 46, 51, 48, 32, 48, 32, 99,116,111,107, 51, 50,
/* 0x54e0 */  46, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x54f0 */  32, 32,100, 32, 32, 67, 84, 67, 76, 69, 86, 69, 49, 32, 48, 32,
/* 0x5500 */  67, 84, 67, 76, 69, 86, 69, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5510 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82,
/* 0x5520 */  48, 49, 32, 48, 32, 67, 65, 76, 76, 84, 82, 48, 49, 10, 48, 48,
/* 0x5530 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x5540 */  84, 66, 83, 72, 82, 48, 49, 32, 48, 32, 67, 84, 66, 83, 72, 82,
/* 0x5550 */  48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x5560 */  32,100, 32, 32, 67, 84, 66, 82, 79, 82, 48, 49, 32, 48, 32, 67,
/* 0x5570 */  84, 66, 82, 79, 82, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5580 */  32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 87, 65, 48,
/* 0x5590 */  49, 32, 48, 32, 67, 84, 66, 83, 87, 65, 48, 49, 10, 48, 48, 48,
/* 0x55a0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65,
/* 0x55b0 */  76, 76, 84, 82, 48, 50, 32, 48, 32, 67, 65, 76, 76, 84, 82, 48,
/* 0x55c0 */  50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x55d0 */ 100, 32, 32, 67, 65, 76, 76, 84, 82, 69, 56, 32, 48, 32, 67, 65,
/* 0x55e0 */  76, 76, 84, 82, 69, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x55f0 */ 108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 69, 57,
/* 0x5600 */  32, 48, 32, 67, 65, 76, 76, 84, 82, 69, 57, 10, 48, 48, 48, 48,
/* 0x5610 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 67,
/* 0x5620 */  76, 69, 86, 69, 50, 32, 48, 32, 67, 84, 67, 76, 69, 86, 69, 50,
/* 0x5630 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x5640 */  32, 32, 67, 65, 76, 76, 84, 82, 49, 50, 32, 48, 32, 67, 65, 76,
/* 0x5650 */  76, 84, 82, 49, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x5660 */  32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 72, 82, 49, 49, 32,
/* 0x5670 */  48, 32, 67, 84, 66, 83, 72, 82, 49, 49, 10, 48, 48, 48, 48, 48,
/* 0x5680 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 82,
/* 0x5690 */  79, 82, 49, 49, 32, 48, 32, 67, 84, 66, 82, 79, 82, 49, 49, 10,
/* 0x56a0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x56b0 */  32, 67, 84, 66, 83, 87, 65, 49, 49, 32, 48, 32, 67, 84, 66, 83,
/* 0x56c0 */  87, 65, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x56d0 */  32, 32, 32,100, 32, 32, 76, 69, 88, 69, 67, 48, 49, 55, 32, 48,
/* 0x56e0 */  32, 76, 69, 88, 69, 67, 48, 49, 55, 10, 48, 48, 48, 48, 48, 48,
/* 0x56f0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 85, 78, 77, 80,
/* 0x5700 */  48, 48, 48, 32, 48, 32, 76, 85, 78, 77, 80, 48, 48, 48, 10, 48,
/* 0x5710 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x5720 */  76, 85, 78, 77, 80, 48, 48, 49, 32, 48, 32, 76, 85, 78, 77, 80,
/* 0x5730 */  48, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32,
/* 0x5740 */  32, 32, 32, 32, 32, 76, 69, 88, 69, 67, 48, 48, 48, 32, 48, 32,
/* 0x5750 */  95,115,116, 97,114,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5760 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,
/* 0x5770 */ 108,122,109, 97, 95,115,116, 97, 99,107, 95, 97,100,106,117,115,
/* 0x5780 */ 116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x5790 */  32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,108,122,109, 97, 95,
/* 0x57a0 */ 117, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x57b0 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,108,
/* 0x57c0 */ 122,109, 97, 95, 99, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48,
/* 0x57d0 */  48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,
/* 0x57e0 */  32, 48, 32,108,122,109, 97, 95,112,114,111,112,101,114,116,105,
/* 0x57f0 */ 101,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x5800 */  32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32, 78, 77, 82, 85,
/* 0x5810 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,
/* 0x5820 */  32, 32, 42, 85, 78, 68, 42, 32, 48, 32,102,105,108,116,101,114,
/* 0x5830 */  95,108,101,110,103,116,104, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5840 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48,
/* 0x5850 */  32,102,105,108,116,101,114, 95, 99,116,111, 10, 48, 48, 48, 48,
/* 0x5860 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x5870 */  68, 42, 32, 48, 32, 79, 95, 66, 73, 78, 70, 79, 10, 10, 82, 69,
/* 0x5880 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x5890 */  32, 70, 79, 82, 32, 91, 76, 69, 88, 69, 67, 48, 48, 48, 93, 58,
/* 0x58a0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x58b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x58c0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x58d0 */  95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 76, 69, 88,
/* 0x58e0 */  69, 67, 48, 50, 53, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x58f0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x5900 */  50, 66, 83, 77, 65, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x5910 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5920 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x5930 */  48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x5940 */  32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10,
/* 0x5950 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x5960 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 49, 48,
/* 0x5970 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x5980 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x5990 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,
/* 0x59a0 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x59b0 */  50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x59c0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x59d0 */  91, 78, 50, 66, 83, 77, 65, 50, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x59e0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x59f0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x5a00 */  48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x5a10 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 83, 77, 65, 49, 48,
/* 0x5a20 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x5a30 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83,
/* 0x5a40 */  50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x5a50 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5a60 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82,
/* 0x5a70 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5a80 */  32, 78, 50, 66, 70, 65, 83, 49, 49, 10, 10, 82, 69, 76, 79, 67,
/* 0x5a90 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x5aa0 */  82, 32, 91, 78, 50, 66, 83, 77, 65, 51, 48, 93, 58, 10, 79, 70,
/* 0x5ab0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x5ac0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x5ad0 */  48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x5ae0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67,
/* 0x5af0 */  50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x5b00 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70,
/* 0x5b10 */  65, 83, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x5b20 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5b30 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51,
/* 0x5b40 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x5b50 */  32, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x5b60 */  48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x5b70 */  32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10,
/* 0x5b80 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x5b90 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 68, 69, 67, 51,
/* 0x5ba0 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x5bb0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x5bc0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 49, 32, 82, 95,
/* 0x5bd0 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5be0 */  78, 50, 66, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 50,
/* 0x5bf0 */ 102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x5c00 */  32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 53, 48, 10, 10, 82, 69,
/* 0x5c10 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x5c20 */  32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 52, 48, 93, 58,
/* 0x5c30 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x5c40 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x5c50 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54,
/* 0x5c60 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66,
/* 0x5c70 */  68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x5c80 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x5c90 */  50, 66, 70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x5ca0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5cb0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x5cc0 */  48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x5cd0 */  32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 48,
/* 0x5ce0 */  48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x5cf0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67,
/* 0x5d00 */  51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x5d10 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83,
/* 0x5d20 */  77, 65, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x5d30 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5d40 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56,
/* 0x5d50 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x5d60 */  32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76,
/* 0x5d70 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x5d80 */  70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 54, 48, 93, 58, 10,
/* 0x5d90 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x5da0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x5db0 */  10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95,
/* 0x5dc0 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 70,
/* 0x5dd0 */  65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95,
/* 0x5de0 */  51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5df0 */  78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x5e00 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x5e10 */  32, 91, 78, 50, 66, 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70,
/* 0x5e20 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x5e30 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x5e40 */  48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x5e50 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49,
/* 0x5e60 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x5e70 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77,
/* 0x5e80 */  65, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x5e90 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5ea0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x5eb0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x5ec0 */  32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79,
/* 0x5ed0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x5ee0 */  79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 49, 48, 93, 58, 10, 79,
/* 0x5ef0 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x5f00 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x5f10 */  48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x5f20 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69,
/* 0x5f30 */  67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x5f40 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68,
/* 0x5f50 */  83, 77, 65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x5f60 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5f70 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5f80 */  49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x5f90 */  32, 32, 32, 32, 78, 50, 68, 83, 77, 65, 49, 48, 10, 10, 82, 69,
/* 0x5fa0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x5fb0 */  32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 50, 48, 93, 58,
/* 0x5fc0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x5fd0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x5fe0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54,
/* 0x5ff0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68,
/* 0x6000 */  70, 65, 83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x6010 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x6020 */  50, 68, 83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x6030 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6040 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x6050 */  48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x6060 */  32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10,
/* 0x6070 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x6080 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 51, 48,
/* 0x6090 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x60a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x60b0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51,
/* 0x60c0 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x60d0 */  50, 68, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101,
/* 0x60e0 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x60f0 */  32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76,
/* 0x6100 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x6110 */  70, 79, 82, 32, 91, 78, 50, 68, 68, 69, 67, 51, 48, 93, 58, 10,
/* 0x6120 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x6130 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x6140 */  10, 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95,
/* 0x6150 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68,
/* 0x6160 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 50, 49, 32, 82, 95,
/* 0x6170 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6180 */  78, 50, 68, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 52,
/* 0x6190 */  51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x61a0 */  32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 53, 48, 10, 10, 82, 69,
/* 0x61b0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x61c0 */  32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 52, 48, 93, 58,
/* 0x61d0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x61e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x61f0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54,
/* 0x6200 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68,
/* 0x6210 */  68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x6220 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x6230 */  50, 68, 70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x6240 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6250 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x6260 */  48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x6270 */  32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 48,
/* 0x6280 */  48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x6290 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67,
/* 0x62a0 */  51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x62b0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83,
/* 0x62c0 */  77, 65, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x62d0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x62e0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56,
/* 0x62f0 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x6300 */  32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76,
/* 0x6310 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x6320 */  70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 54, 48, 93, 58, 10,
/* 0x6330 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x6340 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x6350 */  10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95,
/* 0x6360 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 70,
/* 0x6370 */  65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95,
/* 0x6380 */  51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6390 */  78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x63a0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x63b0 */  32, 91, 78, 50, 68, 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70,
/* 0x63c0 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x63d0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x63e0 */  48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x63f0 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49,
/* 0x6400 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x6410 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77,
/* 0x6420 */  65, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x6430 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6440 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x6450 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x6460 */  32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79,
/* 0x6470 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x6480 */  79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 49, 48, 93, 58, 10, 79,
/* 0x6490 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x64a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x64b0 */  48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x64c0 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69,
/* 0x64d0 */  67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x64e0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69,
/* 0x64f0 */  83, 77, 65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x6500 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6510 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x6520 */  49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x6530 */  32, 32, 32, 32, 78, 50, 69, 83, 77, 65, 49, 48, 10, 10, 82, 69,
/* 0x6540 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x6550 */  32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 50, 48, 93, 58,
/* 0x6560 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x6570 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x6580 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54,
/* 0x6590 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69,
/* 0x65a0 */  70, 65, 83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x65b0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x65c0 */  50, 69, 83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x65d0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x65e0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x65f0 */  48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x6600 */  32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10,
/* 0x6610 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x6620 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 51, 48,
/* 0x6630 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x6640 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x6650 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51,
/* 0x6660 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x6670 */  50, 69, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101,
/* 0x6680 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x6690 */  32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76,
/* 0x66a0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x66b0 */  70, 79, 82, 32, 91, 78, 50, 69, 68, 69, 67, 51, 48, 93, 58, 10,
/* 0x66c0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x66d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x66e0 */  10, 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95,
/* 0x66f0 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68,
/* 0x6700 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 49,101, 32, 82, 95,
/* 0x6710 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6720 */  78, 50, 69, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48, 51,
/* 0x6730 */  48, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x6740 */  32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 54, 48, 10, 10, 82, 69,
/* 0x6750 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x6760 */  32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 52, 48, 93, 58,
/* 0x6770 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x6780 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x6790 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54,
/* 0x67a0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69,
/* 0x67b0 */  68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x67c0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x67d0 */  50, 69, 70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x67e0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x67f0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x6800 */  48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x6810 */  32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 48,
/* 0x6820 */  48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x6830 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67,
/* 0x6840 */  51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x6850 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83,
/* 0x6860 */  77, 65, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x6870 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6880 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56,
/* 0x6890 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x68a0 */  32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76,
/* 0x68b0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x68c0 */  70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 54, 48, 93, 58, 10,
/* 0x68d0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x68e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x68f0 */  10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95,
/* 0x6900 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 70,
/* 0x6910 */  65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95,
/* 0x6920 */  51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6930 */  78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x6940 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x6950 */  32, 91, 78, 50, 69, 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70,
/* 0x6960 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x6970 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x6980 */  48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x6990 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49,
/* 0x69a0 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x69b0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95,
/* 0x69c0 */  68, 69, 67, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x69d0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x69e0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x69f0 */  53, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x6a00 */  32, 32, 32, 32,108,122,109, 97, 95,115,116, 97, 99,107, 95, 97,
/* 0x6a10 */ 100,106,117,115,116, 10, 48, 48, 48, 48, 48, 48, 49, 52, 32, 82,
/* 0x6a20 */  95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6a30 */  32,108,122,109, 97, 95,117, 95,108,101,110, 10, 48, 48, 48, 48,
/* 0x6a40 */  48, 48, 49,101, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32,
/* 0x6a50 */  32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95, 99, 95,108,101,
/* 0x6a60 */ 110, 10, 48, 48, 48, 48, 48, 48, 50, 97, 32, 82, 95, 51, 56, 54,
/* 0x6a70 */  95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109,
/* 0x6a80 */  97, 95,112,114,111,112,101,114,116,105,101,115, 10, 10, 82, 69,
/* 0x6a90 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x6aa0 */  32, 70, 79, 82, 32, 91, 76, 88, 85, 78, 70, 48, 48, 48, 93, 58,
/* 0x6ab0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x6ac0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x6ad0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x6ae0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 85,
/* 0x6af0 */  78, 70, 48, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x6b00 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76,
/* 0x6b10 */  88, 77, 82, 85, 48, 48, 53, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x6b20 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6b30 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x6b40 */  48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32,
/* 0x6b50 */  32, 32, 32, 32, 32, 32, 78, 77, 82, 85, 10, 10, 82, 69, 76, 79,
/* 0x6b60 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x6b70 */  79, 82, 32, 91, 76, 88, 85, 78, 70, 48, 49, 48, 93, 58, 10, 79,
/* 0x6b80 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x6b90 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x6ba0 */  48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x6bb0 */  67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 85, 78, 70,
/* 0x6bc0 */  48, 52, 50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x6bd0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 74,
/* 0x6be0 */  67, 67, 48, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x6bf0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6c00 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x6c10 */  49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x6c20 */  32, 32, 32, 32, 76, 88, 85, 78, 70, 48, 51, 52, 10, 10, 82, 69,
/* 0x6c30 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x6c40 */  32, 70, 79, 82, 32, 91, 76, 88, 74, 67, 67, 48, 50, 49, 93, 58,
/* 0x6c50 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x6c60 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x6c70 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54,
/* 0x6c80 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 85,
/* 0x6c90 */  78, 70, 48, 51, 52, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x6ca0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76,
/* 0x6cb0 */  88, 85, 78, 70, 51, 56, 56, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x6cc0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6cd0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x6ce0 */  48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x6cf0 */  32, 32, 32, 32, 32, 32, 76, 88, 85, 78, 70, 48, 52, 48, 10, 10,
/* 0x6d00 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x6d10 */  68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 85, 78, 70, 52, 56, 55,
/* 0x6d20 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x6d30 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x6d40 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,
/* 0x6d50 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x6d60 */  88, 85, 78, 70, 48, 52, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x6d70 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x6d80 */  91, 76, 88, 77, 82, 85, 48, 54, 53, 93, 58, 10, 79, 70, 70, 83,
/* 0x6d90 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x6da0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x6db0 */  48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x6dc0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 77, 82, 85, 48, 55, 48,
/* 0x6dd0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x6de0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 77, 82, 85, 48,
/* 0x6df0 */  55, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x6e00 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6e10 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82,
/* 0x6e20 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6e30 */  32, 76, 88, 85, 78, 70, 48, 52, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x6e40 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x6e50 */  82, 32, 91, 76, 88, 77, 82, 85, 48, 57, 48, 93, 58, 10, 79, 70,
/* 0x6e60 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x6e70 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x6e80 */  48, 48, 48, 48, 48, 48, 54, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x6e90 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 77, 82, 85, 49,
/* 0x6ea0 */  48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x6eb0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 85, 78,
/* 0x6ec0 */  70, 48, 52, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x6ed0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6ee0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 54,
/* 0x6ef0 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x6f00 */  32, 32, 32, 76, 88, 85, 78, 70, 48, 51, 52, 10, 10, 82, 69, 76,
/* 0x6f10 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x6f20 */  70, 79, 82, 32, 91, 76, 69, 88, 69, 67, 48, 49, 54, 93, 58, 10,
/* 0x6f30 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x6f40 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x6f50 */  10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95,
/* 0x6f60 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 85, 78,
/* 0x6f70 */  70, 48, 52, 50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x6f80 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88,
/* 0x6f90 */  77, 82, 85, 48, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x6fa0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6fb0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x6fc0 */  48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x6fd0 */  32, 32, 32, 32, 32, 76, 88, 77, 82, 85, 48, 51, 48, 10, 10, 82,
/* 0x6fe0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x6ff0 */  83, 32, 70, 79, 82, 32, 91, 76, 88, 74, 67, 67, 48, 48, 48, 93,
/* 0x7000 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x7010 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x7020 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 55, 32, 82, 95, 51, 56,
/* 0x7030 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88,
/* 0x7040 */  74, 67, 67, 48, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x7050 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x7060 */  76, 88, 67, 65, 76, 76, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x7070 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7080 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x7090 */  48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x70a0 */  32, 32, 32, 32, 32, 32, 32, 76, 88, 85, 78, 70, 48, 51, 55, 10,
/* 0x70b0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x70c0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 67, 74, 50, 77, 82,
/* 0x70d0 */  85, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x70e0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x70f0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95,
/* 0x7100 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7110 */  76, 88, 85, 78, 70, 48, 51, 55, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x7120 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x7130 */  32, 91, 76, 88, 67, 74, 52, 77, 82, 85, 93, 58, 10, 79, 70, 70,
/* 0x7140 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x7150 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x7160 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x7170 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 85, 78, 70, 48, 51,
/* 0x7180 */  52, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x7190 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 67, 74, 54,
/* 0x71a0 */  77, 82, 85, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x71b0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x71c0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x71d0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x71e0 */  32, 32, 76, 88, 67, 74, 56, 77, 82, 85, 10, 10, 82, 69, 76, 79,
/* 0x71f0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x7200 */  79, 82, 32, 91, 76, 88, 67, 74, 55, 77, 82, 85, 93, 58, 10, 79,
/* 0x7210 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x7220 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x7230 */  48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x7240 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 67, 74, 56,
/* 0x7250 */  77, 82, 85, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x7260 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 67,
/* 0x7270 */  74, 56, 77, 82, 85, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x7280 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7290 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x72a0 */  50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x72b0 */  32, 32, 32, 32, 76, 88, 85, 78, 70, 48, 51, 55, 10, 10, 82, 69,
/* 0x72c0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x72d0 */  32, 70, 79, 82, 32, 91, 76, 88, 85, 78, 70, 48, 51, 52, 93, 58,
/* 0x72e0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x72f0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x7300 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54,
/* 0x7310 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 85,
/* 0x7320 */  78, 70, 48, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x7330 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,
/* 0x7340 */ 116,111,107, 51, 50, 46, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x7350 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7360 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x7370 */  48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x7380 */  32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 50, 48,
/* 0x7390 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x73a0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51, 50,
/* 0x73b0 */  46, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x73c0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x73d0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,100, 32,
/* 0x73e0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x73f0 */  32, 32, 99,116,111,107, 51, 50, 46, 50, 48, 10, 10, 82, 69, 76,
/* 0x7400 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x7410 */  70, 79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 50, 48, 93, 58,
/* 0x7420 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x7430 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x7440 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54,
/* 0x7450 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,
/* 0x7460 */ 107, 51, 50, 46, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32,
/* 0x7470 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x7480 */  32, 32, 99,116,111,107, 51, 50, 46, 52, 48, 10, 48, 48, 48, 48,
/* 0x7490 */  48, 48, 49, 48, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x74a0 */  32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 52, 48,
/* 0x74b0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x74c0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51, 50,
/* 0x74d0 */  46, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x74e0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x74f0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32,
/* 0x7500 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x7510 */  32, 32, 99,116,111,107, 51, 50, 46, 52, 48, 10, 48, 48, 48, 48,
/* 0x7520 */  48, 48, 48, 57, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x7530 */  32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 49, 48,
/* 0x7540 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x7550 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51, 50,
/* 0x7560 */  46, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x7570 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7580 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32,
/* 0x7590 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x75a0 */  32, 32, 99,116,111,107, 51, 50, 46, 48, 48, 10, 10, 82, 69, 76,
/* 0x75b0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x75c0 */  70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 48, 48, 93, 58, 10,
/* 0x75d0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x75e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x75f0 */  10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95,
/* 0x7600 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,
/* 0x7610 */ 101,114, 95,108,101,110,103,116,104, 10, 10, 82, 69, 76, 79, 67,
/* 0x7620 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x7630 */  82, 32, 91, 67, 84, 67, 76, 69, 86, 69, 49, 93, 58, 10, 79, 70,
/* 0x7640 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x7650 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x7660 */  48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 56, 32,
/* 0x7670 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114,
/* 0x7680 */  95, 99,116,111, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95,
/* 0x7690 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x76a0 */  67, 65, 76, 76, 84, 82, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x76b0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x76c0 */  32, 91, 67, 65, 76, 76, 84, 82, 48, 50, 93, 58, 10, 79, 70, 70,
/* 0x76d0 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x76e0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x76f0 */  48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x7700 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 48,
/* 0x7710 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x7720 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84,
/* 0x7730 */  82, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x7740 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7750 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x7760 */  82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7770 */  32, 32,102,105,108,116,101,114, 95,108,101,110,103,116,104, 10,
/* 0x7780 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x7790 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49,
/* 0x77a0 */  49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x77b0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x77c0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95,
/* 0x77d0 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x77e0 */  67, 65, 76, 76, 84, 82, 49, 51, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x77f0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x7800 */  32, 91, 67, 84, 67, 76, 69, 86, 69, 50, 93, 58, 10, 79, 70, 70,
/* 0x7810 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x7820 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x7830 */  48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32,
/* 0x7840 */  32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95,
/* 0x7850 */  99,116,111, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51,
/* 0x7860 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67,
/* 0x7870 */  65, 76, 76, 84, 82, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x7880 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x7890 */  91, 67, 65, 76, 76, 84, 82, 49, 51, 93, 58, 10, 79, 70, 70, 83,
/* 0x78a0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x78b0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x78c0 */  48, 48, 48, 48, 54, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x78d0 */  32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 49, 48,
/* 0x78e0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x78f0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 69, 88, 69, 67, 48,
/* 0x7900 */  50, 53, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x7910 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7920 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 51, 99, 32, 82,
/* 0x7930 */  95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x7940 */  32, 76, 69, 88, 69, 67, 48, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x7950 */  52, 48, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32,
/* 0x7960 */  32, 32, 32, 32, 32, 79, 95, 66, 73, 78, 70, 79, 10, 48, 48, 48,
/* 0x7970 */  48, 48, 48, 49,100, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50,
/* 0x7980 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 69, 88, 69, 67, 48, 50, 48,
/* 0x7990 */  10
};
