// python wrapper for ttkProjectionFromField
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkProjectionFromField.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkProjectionFromField(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkProjectionFromField_ClassNew(); }


static PyObject *
PyttkProjectionFromField_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkProjectionFromField::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkProjectionFromField_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkProjectionFromField *op = static_cast<ttkProjectionFromField *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkProjectionFromField::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkProjectionFromField_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkProjectionFromField *tempr = ttkProjectionFromField::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkProjectionFromField_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkProjectionFromField *op = static_cast<ttkProjectionFromField *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkProjectionFromField *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkProjectionFromField::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkProjectionFromField_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkProjectionFromField::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkProjectionFromField_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkProjectionFromField *op = static_cast<ttkProjectionFromField *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkProjectionFromField::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkProjectionFromField_SetUseTextureCoordinates(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseTextureCoordinates");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkProjectionFromField *op = static_cast<ttkProjectionFromField *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseTextureCoordinates(temp0);
    }
    else
    {
      op->ttkProjectionFromField::SetUseTextureCoordinates(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkProjectionFromField_GetUseTextureCoordinates(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseTextureCoordinates");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkProjectionFromField *op = static_cast<ttkProjectionFromField *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseTextureCoordinates() :
      op->ttkProjectionFromField::GetUseTextureCoordinates());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkProjectionFromField_SetUse3DCoordinatesArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUse3DCoordinatesArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkProjectionFromField *op = static_cast<ttkProjectionFromField *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUse3DCoordinatesArray(temp0);
    }
    else
    {
      op->ttkProjectionFromField::SetUse3DCoordinatesArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkProjectionFromField_GetUse3DCoordinatesArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUse3DCoordinatesArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkProjectionFromField *op = static_cast<ttkProjectionFromField *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUse3DCoordinatesArray() :
      op->ttkProjectionFromField::GetUse3DCoordinatesArray());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkProjectionFromField_SetProjectPersistenceDiagram(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetProjectPersistenceDiagram");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkProjectionFromField *op = static_cast<ttkProjectionFromField *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetProjectPersistenceDiagram(temp0);
    }
    else
    {
      op->ttkProjectionFromField::SetProjectPersistenceDiagram(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkProjectionFromField_GetProjectPersistenceDiagram(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProjectPersistenceDiagram");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkProjectionFromField *op = static_cast<ttkProjectionFromField *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetProjectPersistenceDiagram() :
      op->ttkProjectionFromField::GetProjectPersistenceDiagram());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkProjectionFromField_Methods[] = {
  {"IsTypeOf", PyttkProjectionFromField_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkProjectionFromField_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkProjectionFromField_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkProjectionFromField\nC++: static ttkProjectionFromField *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkProjectionFromField_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkProjectionFromField\nC++: ttkProjectionFromField *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkProjectionFromField_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkProjectionFromField_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetUseTextureCoordinates", PyttkProjectionFromField_SetUseTextureCoordinates, METH_VARARGS,
   "SetUseTextureCoordinates(self, _arg:bool) -> None\nC++: virtual void SetUseTextureCoordinates(bool _arg)\n\n"},
  {"GetUseTextureCoordinates", PyttkProjectionFromField_GetUseTextureCoordinates, METH_VARARGS,
   "GetUseTextureCoordinates(self) -> bool\nC++: virtual bool GetUseTextureCoordinates()\n\n"},
  {"SetUse3DCoordinatesArray", PyttkProjectionFromField_SetUse3DCoordinatesArray, METH_VARARGS,
   "SetUse3DCoordinatesArray(self, _arg:bool) -> None\nC++: virtual void SetUse3DCoordinatesArray(bool _arg)\n\n"},
  {"GetUse3DCoordinatesArray", PyttkProjectionFromField_GetUse3DCoordinatesArray, METH_VARARGS,
   "GetUse3DCoordinatesArray(self) -> bool\nC++: virtual bool GetUse3DCoordinatesArray()\n\n"},
  {"SetProjectPersistenceDiagram", PyttkProjectionFromField_SetProjectPersistenceDiagram, METH_VARARGS,
   "SetProjectPersistenceDiagram(self, _arg:bool) -> None\nC++: virtual void SetProjectPersistenceDiagram(bool _arg)\n\n"},
  {"GetProjectPersistenceDiagram", PyttkProjectionFromField_GetProjectPersistenceDiagram, METH_VARARGS,
   "GetProjectPersistenceDiagram(self) -> bool\nC++: virtual bool GetProjectPersistenceDiagram()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkProjectionFromField_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("use_texture_coordinates"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkProjectionFromField_GetUseTextureCoordinates(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkProjectionFromField_SetUseTextureCoordinates(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkProjectionFromField_SetUseTextureCoordinates(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseTextureCoordinates/SetUseTextureCoordinates\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use3d_coordinates_array"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkProjectionFromField_GetUse3DCoordinatesArray(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkProjectionFromField_SetUse3DCoordinatesArray(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkProjectionFromField_SetUse3DCoordinatesArray(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUse3DCoordinatesArray/SetUse3DCoordinatesArray\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("project_persistence_diagram"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkProjectionFromField_GetProjectPersistenceDiagram(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkProjectionFromField_SetProjectPersistenceDiagram(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkProjectionFromField_SetProjectPersistenceDiagram(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetProjectPersistenceDiagram/SetProjectPersistenceDiagram\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkProjectionFromField_Doc =
  "ttkProjectionFromField - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Julien Tierny <julien.tierny@lip6.fr>\\date November 2014.\n\n"
  "TTK VTK-filter which projects a data-set to 2D given two point-data\n"
  "scalar fields to be used as 2D coordinates.\n\n"
  "\\param Input Input data-set, with at least two point data scalar\n"
  "    fields or\n"
  "texture coordinates (vtkPointSet)\n"
  "\\param Output Output projected data-set (vtkPointSet)\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "The input data array for the first component (u) needs to be\n"
  "specified via the standard VTK call\n"
  "vtkAlgorithm::SetInputArrayToProcess() with the following parameters:\n"
  "\\param idx 0 (FIXED: the first array the algorithm requires)\n"
  "\\param port 0 (FIXED: first port)\n"
  "\\param connection 0 (FIXED: first connection)\n"
  "\\param fieldAssociation 0 (FIXED: point data)\n"
  "\\param arrayName (DYNAMIC: string identifier of the input array)\n\n"
  "The input data array for the second component (v) needs to be\n"
  "specified via the standard VTK call\n"
  "vtkAlgorithm::SetInputArrayToProcess() with the following parameters:\n"
  "\\param idx 1 (FIXED: the second array the algorithm requires)\n"
  "\\param port 0 (FIXED: first port)\n"
  "\\param connection 0 (FIXED: first connection)\n"
  "\\param fieldAssociation 0 (FIXED: point data)\n"
  "\\param arrayName (DYNAMIC: string identifier of the input array)\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "\\sa vtkTextureMapFromField\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/builtInExample2/\"\n"
  "  > Builtin example 2\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkProjectionFromField_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkProjectionFromField.ttkProjectionFromField", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkProjectionFromField_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkProjectionFromField_StaticNew()
{
  return ttkProjectionFromField::New();
}

PyObject *PyttkProjectionFromField_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkProjectionFromField_Type, PyttkProjectionFromField_Methods,
    "ttkProjectionFromField",
 &PyttkProjectionFromField_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkProjectionFromField_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkProjectionFromField(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkProjectionFromField_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkProjectionFromField", o) != 0)
  {
    Py_DECREF(o);
  }

}

