// python wrapper for ttkCinemaQuery
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkCinemaQuery.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkCinemaQuery(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkCinemaQuery_ClassNew(); }


static PyObject *
PyttkCinemaQuery_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkCinemaQuery::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaQuery_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaQuery *op = static_cast<ttkCinemaQuery *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkCinemaQuery::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaQuery_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkCinemaQuery *tempr = ttkCinemaQuery::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaQuery_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaQuery *op = static_cast<ttkCinemaQuery *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkCinemaQuery *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkCinemaQuery::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaQuery_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkCinemaQuery::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaQuery_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaQuery *op = static_cast<ttkCinemaQuery *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkCinemaQuery::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaQuery_SetSQLStatement(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSQLStatement");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaQuery *op = static_cast<ttkCinemaQuery *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSQLStatement(temp0);
    }
    else
    {
      op->ttkCinemaQuery::SetSQLStatement(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaQuery_GetSQLStatement(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSQLStatement");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaQuery *op = static_cast<ttkCinemaQuery *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetSQLStatement() :
      op->ttkCinemaQuery::GetSQLStatement());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaQuery_SetExcludeColumnsWithRegexp(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExcludeColumnsWithRegexp");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaQuery *op = static_cast<ttkCinemaQuery *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExcludeColumnsWithRegexp(temp0);
    }
    else
    {
      op->ttkCinemaQuery::SetExcludeColumnsWithRegexp(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaQuery_GetExcludeColumnsWithRegexp(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExcludeColumnsWithRegexp");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaQuery *op = static_cast<ttkCinemaQuery *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetExcludeColumnsWithRegexp() :
      op->ttkCinemaQuery::GetExcludeColumnsWithRegexp());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaQuery_SetRegexpString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRegexpString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaQuery *op = static_cast<ttkCinemaQuery *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRegexpString(temp0);
    }
    else
    {
      op->ttkCinemaQuery::SetRegexpString(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaQuery_GetRegexpString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRegexpString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaQuery *op = static_cast<ttkCinemaQuery *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetRegexpString() :
      op->ttkCinemaQuery::GetRegexpString());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkCinemaQuery_Methods[] = {
  {"IsTypeOf", PyttkCinemaQuery_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkCinemaQuery_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkCinemaQuery_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkCinemaQuery\nC++: static ttkCinemaQuery *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkCinemaQuery_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkCinemaQuery\nC++: ttkCinemaQuery *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkCinemaQuery_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkCinemaQuery_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetSQLStatement", PyttkCinemaQuery_SetSQLStatement, METH_VARARGS,
   "SetSQLStatement(self, _arg:str) -> None\nC++: virtual void SetSQLStatement(const std::string &_arg)\n\n"},
  {"GetSQLStatement", PyttkCinemaQuery_GetSQLStatement, METH_VARARGS,
   "GetSQLStatement(self) -> str\nC++: virtual std::string GetSQLStatement()\n\n"},
  {"SetExcludeColumnsWithRegexp", PyttkCinemaQuery_SetExcludeColumnsWithRegexp, METH_VARARGS,
   "SetExcludeColumnsWithRegexp(self, _arg:bool) -> None\nC++: virtual void SetExcludeColumnsWithRegexp(bool _arg)\n\n"},
  {"GetExcludeColumnsWithRegexp", PyttkCinemaQuery_GetExcludeColumnsWithRegexp, METH_VARARGS,
   "GetExcludeColumnsWithRegexp(self) -> bool\nC++: virtual bool GetExcludeColumnsWithRegexp()\n\n"},
  {"SetRegexpString", PyttkCinemaQuery_SetRegexpString, METH_VARARGS,
   "SetRegexpString(self, _arg:str) -> None\nC++: virtual void SetRegexpString(const std::string &_arg)\n\n"},
  {"GetRegexpString", PyttkCinemaQuery_GetRegexpString, METH_VARARGS,
   "GetRegexpString(self) -> str\nC++: virtual std::string GetRegexpString()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkCinemaQuery_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("sql_statement"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaQuery_GetSQLStatement(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaQuery_SetSQLStatement(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaQuery_SetSQLStatement(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSQLStatement/SetSQLStatement\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("exclude_columns_with_regexp"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaQuery_GetExcludeColumnsWithRegexp(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaQuery_SetExcludeColumnsWithRegexp(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaQuery_SetExcludeColumnsWithRegexp(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExcludeColumnsWithRegexp/SetExcludeColumnsWithRegexp\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("regexp_string"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaQuery_GetRegexpString(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaQuery_SetRegexpString(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaQuery_SetRegexpString(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRegexpString/SetRegexpString\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkCinemaQuery_Doc =
  "ttkCinemaQuery - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Jonas Lukasczyk <jl@jluk.de>\\date 01.09.2018\n\n"
  "TTK VTK-filter that uses a SQL statement to select a subset of a\n"
  "vtkTable.\n\n"
  "This filter creates a temporary SQLite3 database from the input\n"
  "table, performs a SQL query, and then returns the result as a\n"
  "vtkTable.\n\n"
  "VTK wrapping code for the ttk::CinemaQuery package.\n\n"
  "\\param Input Input table (vtkTable)\n"
  "\\param Output Output table (vtkTable)\n\n"
  "sa ttk::CinemaQuery\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/cinemaIO/\">Cinema\n"
  "   IO example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/clusteringKelvinHelmholtzInstabilities/\"\n"
  "  > Clustering Kelvin Helmholtz Instabilities example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/contourTreeAlignment/\"\n"
  "  >Contour Tree Alignment example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/mergeTreeFeatureTracking/\"\n"
  "  >Merge Tree Feature Tracking example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/nestedTrackingFromOverlap/\"\n"
  "  >Nested Tracking from Overlap example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkCinemaQuery_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkCinemaQuery.ttkCinemaQuery", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkCinemaQuery_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkCinemaQuery_StaticNew()
{
  return ttkCinemaQuery::New();
}

PyObject *PyttkCinemaQuery_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkCinemaQuery_Type, PyttkCinemaQuery_Methods,
    "ttkCinemaQuery",
 &PyttkCinemaQuery_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkCinemaQuery_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkCinemaQuery(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkCinemaQuery_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkCinemaQuery", o) != 0)
  {
    Py_DECREF(o);
  }

}

