const char uuid_lua[] =
"-- uuid.lua (internal file)\n"
"\n"
"local ffi = require(\"ffi\")\n"
"local buffer = require('buffer')\n"
"local builtin = ffi.C\n"
"\n"
"ffi.cdef[[\n"
"void\n"
"tt_uuid_create(struct tt_uuid *uu);\n"
"int\n"
"tt_uuid_from_string(const char *in, struct tt_uuid *uu);\n"
"void\n"
"tt_uuid_to_string(const struct tt_uuid *uu, char *out);\n"
"void\n"
"tt_uuid_bswap(struct tt_uuid *uu);\n"
"bool\n"
"tt_uuid_is_nil(const struct tt_uuid *uu);\n"
"bool\n"
"tt_uuid_is_equal(const struct tt_uuid *lhs, const struct tt_uuid *rhs);\n"
"int\n"
"tt_uuid_compare(const struct tt_uuid *a, const struct tt_uuid *b);\n"
"extern const struct tt_uuid uuid_nil;\n"
"]]\n"
"\n"
"local uuid_t = ffi.typeof('struct tt_uuid')\n"
"local UUID_STR_LEN = 36\n"
"local UUID_LEN = ffi.sizeof(uuid_t)\n"
"local uuid_stash = buffer.ffi_stash_new(uuid_t)\n"
"local uuid_stash_take = uuid_stash.take\n"
"local uuid_stash_put = uuid_stash.put\n"
"\n"
"local uuid_str_stash =\n"
"    buffer.ffi_stash_new(string.format('char[%s]', UUID_STR_LEN + 1))\n"
"local uuid_str_stash_take = uuid_str_stash.take\n"
"local uuid_str_stash_put = uuid_str_stash.put\n"
"\n"
"local is_uuid = function(value)\n"
"    return ffi.istype(uuid_t, value)\n"
"end\n"
"\n"
"local uuid_tostring = function(uu)\n"
"    if not is_uuid(uu) then\n"
"        return error('Usage: uuid:str()')\n"
"    end\n"
"    local strbuf = uuid_str_stash_take()\n"
"    builtin.tt_uuid_to_string(uu, strbuf)\n"
"    uu = ffi.string(strbuf, UUID_STR_LEN)\n"
"    uuid_str_stash_put(strbuf)\n"
"    return uu\n"
"end\n"
"\n"
"local uuid_fromstr = function(str)\n"
"    if type(str) ~= 'string' then\n"
"        error(\"fromstr(str)\")\n"
"    end\n"
"    local uu = ffi.new(uuid_t)\n"
"    local rc = builtin.tt_uuid_from_string(str, uu)\n"
"    if rc ~= 0 then\n"
"        return nil\n"
"    end\n"
"    return uu\n"
"end\n"
"\n"
"local need_bswap = function(order)\n"
"    if order == nil or order == 'l' or order == 'h' or order == 'host' then\n"
"        return false\n"
"    elseif order == 'b' or order == 'n' or order == 'network' then\n"
"        return true\n"
"    else\n"
"        error('invalid byteorder, valid is l, b, h, n')\n"
"    end\n"
"end\n"
"\n"
"local uuid_tobin = function(uu, byteorder)\n"
"    if not is_uuid(uu) then\n"
"        return error('Usage: uuid:bin([byteorder])')\n"
"    end\n"
"    if need_bswap(byteorder) then\n"
"        local uuidbuf = uuid_stash_take()\n"
"        ffi.copy(uuidbuf, uu, UUID_LEN)\n"
"        builtin.tt_uuid_bswap(uuidbuf)\n"
"        uu = ffi.string(ffi.cast('char *', uuidbuf), UUID_LEN)\n"
"        uuid_stash_put(uuidbuf)\n"
"        return uu\n"
"    end\n"
"    return ffi.string(ffi.cast('char *', uu), UUID_LEN)\n"
"end\n"
"\n"
"local uuid_frombin = function(bin, byteorder)\n"
"    if type(bin) ~= 'string' or #bin ~= UUID_LEN then\n"
"        error(\"frombin(bin, [byteorder])\")\n"
"    end\n"
"    local uu = ffi.new(uuid_t)\n"
"    ffi.copy(uu, bin, UUID_LEN)\n"
"    if need_bswap(byteorder) then\n"
"        builtin.tt_uuid_bswap(uu)\n"
"    end\n"
"    return uu\n"
"end\n"
"\n"
"local uuid_isnil = function(uu)\n"
"    if not is_uuid(uu) then\n"
"        return error('Usage: uuid:isnil()')\n"
"    end\n"
"    return builtin.tt_uuid_is_nil(uu)\n"
"end\n"
"\n"
"local function error_convert_arg(arg_index)\n"
"    local err_fmt = 'incorrect value to convert to uuid as %d argument'\n"
"    error(err_fmt:format(arg_index), 3)\n"
"end\n"
"\n"
"local uuid_eq = function(lhs, rhs)\n"
"    if not is_uuid(lhs) then\n"
"        lhs, rhs = rhs, lhs\n"
"    elseif is_uuid(rhs) then\n"
"        return builtin.tt_uuid_is_equal(lhs, rhs)\n"
"    end\n"
"    if type(rhs) ~= 'string' then\n"
"        return false\n"
"    end\n"
"    local buf = uuid_stash_take()\n"
"    local rc = builtin.tt_uuid_from_string(rhs, buf) == 0\n"
"    if rc then\n"
"        rc = builtin.tt_uuid_is_equal(lhs, buf)\n"
"    else\n"
"        rc = false\n"
"    end\n"
"    uuid_stash_put(buf)\n"
"    return rc\n"
"end\n"
"\n"
"local uuid_new = function()\n"
"    local uu = ffi.new(uuid_t)\n"
"    builtin.tt_uuid_create(uu)\n"
"    return uu\n"
"end\n"
"\n"
"local uuid_new_bin = function(byteorder)\n"
"    local uuidbuf = uuid_stash_take()\n"
"    builtin.tt_uuid_create(uuidbuf)\n"
"    local res = uuid_tobin(uuidbuf, byteorder)\n"
"    uuid_stash_put(uuidbuf)\n"
"    return res\n"
"end\n"
"local uuid_new_str = function()\n"
"    local uuidbuf = uuid_stash_take()\n"
"    builtin.tt_uuid_create(uuidbuf)\n"
"    local res = uuid_tostring(uuidbuf)\n"
"    uuid_stash_put(uuidbuf)\n"
"    return res\n"
"end\n"
"\n"
"local uuid_cmp = function(lhs, rhs)\n"
"    local buf\n"
"    if is_uuid(lhs) then\n"
"        if is_uuid(rhs) then\n"
"            -- Fast path.\n"
"           return builtin.tt_uuid_compare(lhs, rhs)\n"
"        end\n"
"        if type(rhs) ~= 'string' then\n"
"            return error_convert_arg(2)\n"
"        end\n"
"        buf = uuid_stash_take()\n"
"        if builtin.tt_uuid_from_string(rhs, buf) ~= 0 then\n"
"            uuid_stash_put(buf)\n"
"            return error_convert_arg(2)\n"
"        end\n"
"        rhs = buf\n"
"    else\n"
"        if type(lhs) ~= 'string' then\n"
"            return error_convert_arg(1)\n"
"        end\n"
"        buf = uuid_stash_take()\n"
"        if builtin.tt_uuid_from_string(lhs, buf) ~= 0 then\n"
"            uuid_stash_put(buf)\n"
"            return error_convert_arg(1)\n"
"        end\n"
"        lhs = buf\n"
"    end\n"
"    local rc = builtin.tt_uuid_compare(lhs, rhs)\n"
"    uuid_stash_put(buf)\n"
"    return rc\n"
"end\n"
"local uuid_lt = function(lhs, rhs)\n"
"    return uuid_cmp(lhs, rhs) < 0\n"
"end\n"
"local uuid_le = function(lhs, rhs)\n"
"    return uuid_cmp(lhs, rhs) <= 0\n"
"end\n"
"\n"
"local uuid_mt = {\n"
"    __tostring = uuid_tostring;\n"
"    __eq = uuid_eq;\n"
"    __lt = uuid_lt;\n"
"    __le = uuid_le;\n"
"    __index = {\n"
"        isnil = uuid_isnil;\n"
"        bin   = uuid_tobin;    -- binary host byteorder\n"
"        str   = uuid_tostring; -- RFC4122 string\n"
"    }\n"
"}\n"
"\n"
"ffi.metatype(uuid_t, uuid_mt)\n"
"\n"
"return setmetatable({\n"
"    NULL        = builtin.uuid_nil;\n"
"    new         = uuid_new;\n"
"    fromstr     = uuid_fromstr;\n"
"    frombin     = uuid_frombin;\n"
"    bin         = uuid_new_bin;   -- optimized shortcut for new():bin()\n"
"    str         = uuid_new_str;   -- optimized shortcut for new():str()\n"
"    is_uuid     = is_uuid;\n"
"}, {\n"
"    __call = uuid_new; -- shortcut for new()\n"
"})\n"
""
;
