const char buffer_lua[] =
"-- buffer.lua (internal file)\n"
"\n"
"local ffi = require('ffi')\n"
"local utils = require('internal.utils')\n"
"local READAHEAD = 16320\n"
"\n"
"ffi.cdef[[\n"
"struct slab_cache;\n"
"struct slab_cache *\n"
"tarantool_lua_slab_cache();\n"
"\n"
"struct ibuf *\n"
"cord_ibuf_take(void);\n"
"\n"
"void\n"
"cord_ibuf_put(struct ibuf *ibuf);\n"
"\n"
"void\n"
"cord_ibuf_drop(struct ibuf *ibuf);\n"
"\n"
"struct ibuf\n"
"{\n"
"    struct slab_cache *slabc;\n"
"    char *buf;\n"
"    /** Start of input. */\n"
"    char *rpos;\n"
"    /** End of useful input */\n"
"    char *wpos;\n"
"    /** End of ibuf. */\n"
"    char *epos;\n"
"    size_t start_capacity;\n"
"};\n"
"\n"
"void\n"
"ibuf_create(struct ibuf *ibuf, struct slab_cache *slabc, size_t start_capacity);\n"
"\n"
"void\n"
"ibuf_destroy(struct ibuf *ibuf);\n"
"\n"
"void\n"
"ibuf_reinit(struct ibuf *ibuf);\n"
"\n"
"void *\n"
"ibuf_reserve_slow(struct ibuf *ibuf, size_t size);\n"
"\n"
"/*\n"
" * prbuf iterface; see src/lib/core/prbuf.c for details.\n"
" */\n"
"\n"
"struct prbuf_header;\n"
"struct prbuf_record;\n"
"\n"
"struct prbuf {\n"
"    struct prbuf_header *header;\n"
"};\n"
"\n"
"struct prbuf_entry {\n"
"    size_t size;\n"
"    char *ptr;\n"
"};\n"
"\n"
"struct prbuf_iterator {\n"
"    struct prbuf *buf;\n"
"    struct prbuf_record *current;\n"
"};\n"
"\n"
"void\n"
"prbuf_create(struct prbuf *buf, void *mem, size_t size);\n"
"\n"
"int\n"
"prbuf_open(struct prbuf *buf, void *mem);\n"
"\n"
"void *\n"
"prbuf_prepare(struct prbuf *buf, size_t size);\n"
"\n"
"void\n"
"prbuf_commit(struct prbuf *buf);\n"
"\n"
"void\n"
"prbuf_iterator_create(struct prbuf *buf, struct prbuf_iterator *iter);\n"
"\n"
"int\n"
"prbuf_iterator_next(struct prbuf_iterator *iter, struct prbuf_entry *res);\n"
"]]\n"
"\n"
"local builtin = ffi.C\n"
"local ibuf_t = ffi.typeof('struct ibuf')\n"
"\n"
"local function errorf(s, ...)\n"
"    error(string.format(s, ...))\n"
"end\n"
"\n"
"local function checkibuf(buf, method)\n"
"    if not ffi.istype(ibuf_t, buf) then\n"
"        errorf('Attempt to call method without object, use ibuf:%s()', method)\n"
"    end\n"
"end\n"
"\n"
"local function ibuf_capacity(buf)\n"
"    checkibuf(buf, 'capacity')\n"
"    return tonumber(buf.epos - buf.buf)\n"
"end\n"
"\n"
"local function ibuf_pos(buf)\n"
"    checkibuf(buf, 'pos')\n"
"    return tonumber(buf.rpos - buf.buf)\n"
"end\n"
"\n"
"local function ibuf_used(buf)\n"
"    checkibuf(buf, 'size')\n"
"    return tonumber(buf.wpos - buf.rpos)\n"
"end\n"
"\n"
"local function ibuf_unused(buf)\n"
"    checkibuf(buf, 'unused')\n"
"    return tonumber(buf.epos - buf.wpos)\n"
"end\n"
"\n"
"local function ibuf_recycle(buf)\n"
"    checkibuf(buf, 'recycle')\n"
"    builtin.ibuf_reinit(buf)\n"
"end\n"
"\n"
"local function ibuf_poison_unallocated(buf)\n"
"    utils.poison_memory_region(buf.wpos, buf.epos - buf.wpos);\n"
"end\n"
"\n"
"local function ibuf_unpoison_unallocated(buf)\n"
"    utils.unpoison_memory_region(buf.wpos, buf.epos - buf.wpos);\n"
"end\n"
"\n"
"local function ibuf_reset(buf)\n"
"    checkibuf(buf, 'reset')\n"
"    buf.rpos = buf.buf\n"
"    buf.wpos = buf.buf\n"
"    ibuf_poison_unallocated(buf)\n"
"end\n"
"\n"
"local function ibuf_reserve_slow(buf, size)\n"
"    local ptr = builtin.ibuf_reserve_slow(buf, size)\n"
"    if ptr == nil then\n"
"        errorf(\"Failed to allocate %d bytes in ibuf\", size)\n"
"    end\n"
"    return ffi.cast('char *', ptr)\n"
"end\n"
"\n"
"local function ibuf_reserve(buf, size)\n"
"    checkibuf(buf, 'reserve')\n"
"    if buf.wpos + size <= buf.epos then\n"
"        ibuf_unpoison_unallocated(buf)\n"
"        return buf.wpos\n"
"    end\n"
"    return ibuf_reserve_slow(buf, size)\n"
"end\n"
"\n"
"local function ibuf_alloc(buf, size)\n"
"    checkibuf(buf, 'alloc')\n"
"    local wpos\n"
"    if buf.wpos + size <= buf.epos then\n"
"        --\n"
"        -- In case of using same buffer we need to unpoison newly\n"
"        -- allocated memory after previous ibuf_alloc or poison after\n"
"        -- newly allocated memory after previous ibuf_reserve.\n"
"        --\n"
"        ibuf_unpoison_unallocated(buf)\n"
"        wpos = buf.wpos\n"
"    else\n"
"        wpos = ibuf_reserve_slow(buf, size)\n"
"    end\n"
"    buf.wpos = buf.wpos + size\n"
"    ibuf_poison_unallocated(buf)\n"
"    return wpos\n"
"end\n"
"\n"
"local function checksize(buf, size)\n"
"    if buf.rpos + size > buf.wpos then\n"
"        errorf(\"Attempt to read out of range bytes: needed=%d size=%d\",\n"
"            tonumber(size), ibuf_used(buf))\n"
"    end\n"
"end\n"
"\n"
"local function ibuf_checksize(buf, size)\n"
"    checkibuf(buf, 'checksize')\n"
"    checksize(buf, size)\n"
"    return buf.rpos\n"
"end\n"
"\n"
"local function ibuf_read(buf, size)\n"
"    checkibuf(buf, 'read')\n"
"    checksize(buf, size)\n"
"    local rpos = buf.rpos\n"
"    buf.rpos = rpos + size\n"
"    return rpos\n"
"end\n"
"\n"
"local function ibuf_consume(buf, size)\n"
"    checkibuf(buf, 'consume')\n"
"    checksize(buf, size)\n"
"    utils.poison_memory_region(buf.rpos, size);\n"
"    buf.rpos = buf.rpos + size\n"
"end\n"
"\n"
"local function ibuf_serialize(buf)\n"
"    local properties = { rpos = buf.rpos, wpos = buf.wpos }\n"
"    return { ibuf = properties }\n"
"end\n"
"\n"
"local ibuf_methods = {\n"
"    recycle = ibuf_recycle;\n"
"    reset = ibuf_reset;\n"
"\n"
"    reserve = ibuf_reserve;\n"
"    alloc = ibuf_alloc;\n"
"\n"
"    checksize = ibuf_checksize;\n"
"    read = ibuf_read;\n"
"    consume = ibuf_consume;\n"
"    __serialize = ibuf_serialize;\n"
"\n"
"    size = ibuf_used;\n"
"    capacity = ibuf_capacity;\n"
"    pos = ibuf_pos;\n"
"    unused = ibuf_unused;\n"
"}\n"
"\n"
"local function ibuf_tostring(self)\n"
"    return '<ibuf>'\n"
"end\n"
"local ibuf_mt = {\n"
"    __gc = ibuf_recycle;\n"
"    __index = ibuf_methods;\n"
"    __tostring = ibuf_tostring;\n"
"};\n"
"\n"
"ffi.metatype(ibuf_t, ibuf_mt);\n"
"\n"
"local function ibuf_new(arg)\n"
"    local buf = ffi.new(ibuf_t)\n"
"    local slabc = builtin.tarantool_lua_slab_cache()\n"
"    builtin.ibuf_create(buf, slabc, READAHEAD)\n"
"    if arg == nil then\n"
"        return buf\n"
"    elseif type(arg) == 'number' then\n"
"        ibuf_reserve(buf, arg)\n"
"        return buf\n"
"    end\n"
"    errorf('Usage: ibuf([size])')\n"
"end\n"
"\n"
"local prbuf_t = ffi.typeof('struct prbuf')\n"
"local prbuf_iterator_t = ffi.typeof('struct prbuf_iterator')\n"
"local prbuf_entry_t = ffi.typeof('struct prbuf_entry')\n"
"\n"
"local function prbuf_open(mem)\n"
"    if not ffi.istype(ffi.typeof('char *'), mem) then\n"
"        errorf('Attempt to prbuf_open() with argument of wrong type, '..\n"
"               'expected <char *>')\n"
"    end\n"
"    local buf = ffi.new(prbuf_t)\n"
"    local rc = builtin.prbuf_open(buf, mem)\n"
"    if rc ~= 0 then\n"
"        errorf(\"Failed to open prbuf\")\n"
"    end\n"
"    return buf\n"
"end\n"
"\n"
"local function prbuf_create(mem, size)\n"
"    if not ffi.istype(ffi.typeof('char *'), mem) then\n"
"        errorf('Attempt to prbuf_create() with argument of wrong type, '..\n"
"               'expected <char *>')\n"
"    end\n"
"    local buf = ffi.new(prbuf_t)\n"
"    builtin.prbuf_create(buf, mem, size)\n"
"    return buf\n"
"end\n"
"\n"
"local function prbuf_prepare(buf, size)\n"
"    if not ffi.istype(prbuf_t, buf) then\n"
"        errorf('Attempt to call method without object, use prbuf:prepare()')\n"
"    end\n"
"    local ptr = builtin.prbuf_prepare(buf, size)\n"
"    if ptr == nil then return nil end\n"
"    return ffi.cast('char *', ptr)\n"
"end\n"
"\n"
"\n"
"local function prbuf_commit(buf)\n"
"    if not ffi.istype(prbuf_t, buf) then\n"
"        errorf('Attempt to call method without object, use prbuf:commit()')\n"
"    end\n"
"    builtin.prbuf_commit(buf)\n"
"end\n"
"\n"
"local function prbuf_iterator_create(buf)\n"
"    if not ffi.istype(prbuf_t, buf) then\n"
"        errorf('Attempt to call method without object, use prbuf:create()')\n"
"    end\n"
"    local iterator = ffi.new(prbuf_iterator_t)\n"
"    builtin.prbuf_iterator_create(buf, iterator)\n"
"    return iterator\n"
"end\n"
"\n"
"local prbuf_methods = {\n"
"    prepare = prbuf_prepare;\n"
"    commit = prbuf_commit;\n"
"    iterator_create = prbuf_iterator_create;\n"
"}\n"
"\n"
"local function prbuf_iterator_next(iterator)\n"
"    if not ffi.istype(prbuf_iterator_t, iterator) then\n"
"        errorf('Attempt to iterator:next() without object, use iterator:next()')\n"
"    end\n"
"    local entry = ffi.new(prbuf_entry_t)\n"
"    local rc = builtin.prbuf_iterator_next(iterator, entry)\n"
"    if rc ~= 0 then return nil end\n"
"    return entry\n"
"end\n"
"\n"
"local function prbuf_entry_data(entry)\n"
"    if not ffi.istype(prbuf_entry_t, entry) then\n"
"        errorf('Attempt to entry:data() without object, use entry:data()')\n"
"    end\n"
"    return ffi.string(entry.ptr, tonumber(entry.size))\n"
"end\n"
"\n"
"local prbuf_iterator_methods = {\n"
"    next = prbuf_iterator_next;\n"
"}\n"
"\n"
"local prbuf_iterator_mt = {\n"
"    __index = prbuf_iterator_methods;\n"
"}\n"
"\n"
"ffi.metatype(prbuf_iterator_t, prbuf_iterator_mt);\n"
"\n"
"local prbuf_entry_methods = {\n"
"    data = prbuf_entry_data;\n"
"}\n"
"\n"
"local prbuf_entry_mt = {\n"
"    __index = prbuf_entry_methods;\n"
"}\n"
"\n"
"ffi.metatype(prbuf_entry_t, prbuf_entry_mt);\n"
"\n"
"local function prbuf_tostring(self)\n"
"    return '<prbuf>'\n"
"end\n"
"\n"
"local prbuf_mt = {\n"
"    __index = prbuf_methods;\n"
"    __tostring = prbuf_tostring;\n"
"};\n"
"\n"
"ffi.metatype(prbuf_t, prbuf_mt);\n"
"\n"
"--\n"
"-- Stash keeps an FFI object for re-usage and helps to ensure the proper\n"
"-- ownership. Is supposed to be used in yield-free code when almost always it is\n"
"-- possible to put the taken object back.\n"
"-- Then cost of the stash is almost the same as ffi.new() for small objects like\n"
"-- 'int[1]' even when jitted. Examples:\n"
"--\n"
"-- * ffi.new('int[1]') is about ~0.4ns, while the stash take() + put() is about\n"
"--   ~0.8ns;\n"
"--\n"
"-- * Much better on objects > 128 bytes in size. ffi.new('struct uri[1]') is\n"
"--   ~300ns, while the stash is still ~0.8ns;\n"
"--\n"
"-- * For structs not allocated as an array is also much better than ffi.new().\n"
"--   For instance, ffi.new('struct tt_uuid') is ~300ns, the stash is ~0.8ns.\n"
"--   Even though 'struct tt_uuid' is 16 bytes;\n"
"--\n"
"local function ffi_stash_new(c_type)\n"
"    local item = nil\n"
"\n"
"    local function take()\n"
"        local res\n"
"        -- This line is guaranteed to be GC-safe. GC is not invoked. Because\n"
"        -- there are no allocation. So it can be considered 'atomic'.\n"
"        res, item = item, nil\n"
"        -- The next lines don't need to be atomic and can survive GC. The only\n"
"        -- important part was to take the global item and set it to nil.\n"
"        if res then\n"
"            return res\n"
"        end\n"
"        return ffi.new(c_type)\n"
"    end\n"
"\n"
"    local function put(i)\n"
"        -- It is ok to rewrite the existing global item if it was set. Does\n"
"        -- not matter. They are all the same.\n"
"        item = i\n"
"    end\n"
"\n"
"    -- Due to some random reason if the stash returns a table with methods it\n"
"    -- works faster than returning them as multiple values. Regardless of how\n"
"    -- the methods are used later. Even if the caller will cache take and put\n"
"    -- methods anyway.\n"
"    return {\n"
"        take = take,\n"
"        put = put,\n"
"    }\n"
"end\n"
"\n"
"--\n"
"-- Cord buffer is useful for the places, where\n"
"--\n"
"-- * Want to reuse the already allocated memory which might be stored in the\n"
"--   cord buf. Although sometimes the buffer is recycled, so should not rely on\n"
"--   being able to reuse it always. When reused, the win is the biggest -\n"
"--   becomes about x20 times faster than a new buffer creation (~5ns vs ~100ns);\n"
"--\n"
"-- * Want to avoid allocation of a new ibuf because it produces a new GC object\n"
"--   which is additional load for Lua GC. Although according to benches it is\n"
"--   not super expensive;\n"
"--\n"
"-- * Almost always can put the buffer back manually. Not rely on it being\n"
"--   recycled automatically. It is recycled, but still should not rely on that;\n"
"--\n"
"-- It is important to wrap the C functions, not expose them directly. Because\n"
"-- JIT works a bit better when C functions are called as 'ffi.C.func()' than\n"
"-- 'func()' with func being cached. The only pros is to cache 'ffi.C' itself.\n"
"-- It is quite strange though how having them wrapped into a Lua function is\n"
"-- faster than cached directly as C functions.\n"
"--\n"
"local function cord_ibuf_take()\n"
"    return builtin.cord_ibuf_take()\n"
"end\n"
"\n"
"local function cord_ibuf_put(buf)\n"
"    return builtin.cord_ibuf_put(buf)\n"
"end\n"
"\n"
"local function cord_ibuf_drop(buf)\n"
"    return builtin.cord_ibuf_drop(buf)\n"
"end\n"
"\n"
"local internal = {\n"
"    cord_ibuf_take = cord_ibuf_take,\n"
"    cord_ibuf_put = cord_ibuf_put,\n"
"    cord_ibuf_drop = cord_ibuf_drop,\n"
"}\n"
"\n"
"return {\n"
"    internal = internal,\n"
"    ibuf = ibuf_new;\n"
"    prbuf_open = prbuf_open;\n"
"    prbuf_create = prbuf_create;\n"
"    READAHEAD = READAHEAD;\n"
"    ffi_stash_new = ffi_stash_new,\n"
"}\n"
""
;
