/* opensearch.c generated by valac 0.56.17, the Vala compiler
 * generated from opensearch.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "plugins.h"
#include <gee.h>
#include <glib-object.h>
#include <synapse-core.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#define SYNAPSE_GOOGLE_SEARCH_XML "\n" \
"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" \
"<OpenSearchDescription xmlns=\"http://a9.com/-/spec/opensearch/1.1/\">" \
"\n" \
"  <ShortName>Google</ShortName>\n" \
"  <Description>Search the web using google.com</Description>\n" \
"  <Url type=\"text/html\" method=\"get\" template=\"http://www.google." \
"com/search?q={searchTerms}&amp;hl={language}\"/>\n" \
"  <Url type=\"application/x-suggestions+json\" template=\"http://sugge" \
"stqueries.google.com/complete/search?output=firefox&amp;client=firefox" \
"&amp;hl=en&amp;q={searchTerms}\"/>\n" \
"\n" \
"  <Developer>Synapse dev team</Developer>\n" \
"  <InputEncoding>UTF-8</InputEncoding>\n" \
"</OpenSearchDescription>\n"
#define SYNAPSE_GOOGLE_MAPS_XML "\n" \
"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" \
"<OpenSearchDescription xmlns=\"http://a9.com/-/spec/opensearch/1.1/\">" \
"\n" \
"  <ShortName>Google Maps</ShortName>\n" \
"  <Description>Search using Google Maps</Description>\n" \
"  <Url type=\"text/html\" method=\"get\" template=\"http://maps.google" \
".com/maps?q={searchTerms}&amp;hl={language}\"/>\n" \
"\n" \
"  <Developer>Synapse dev team</Developer>\n" \
"  <InputEncoding>UTF-8</InputEncoding>\n" \
"</OpenSearchDescription>\n"
#define SYNAPSE_DUCKDUCKGO_SEARCH_XML "\n" \
"<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" \
"<OpenSearchDescription xmlns=\"http://a9.com/-/spec/opensearch/1.1/\">" \
" \n" \
"  <ShortName>DuckDuckGo</ShortName> \n" \
"  <Description>Search DuckDuckGo</Description> \n" \
"  <InputEncoding>UTF-8</InputEncoding> \n" \
"  <LongName>DuckDuckGo Search</LongName> \n" \
"  <Url type=\"text/html\" method=\"get\" template=\"https://duckduckgo" \
".com/?q={searchTerms}\"/>\n" \
"  <Url type=\"application/x-suggestions+json\" template=\"https://ac.d" \
"uckduckgo.com/ac/?q={searchTerms}&amp;type=list\"/>\n" \
"</OpenSearchDescription> \n"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_SEARCH_ACTION (synapse_open_search_plugin_search_action_get_type ())
#define SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_SEARCH_ACTION, SynapseOpenSearchPluginSearchAction))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_SEARCH_ACTION, SynapseOpenSearchPluginSearchActionClass))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_IS_SEARCH_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_SEARCH_ACTION))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_IS_SEARCH_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_SEARCH_ACTION))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_SEARCH_ACTION, SynapseOpenSearchPluginSearchActionClass))

typedef struct _SynapseOpenSearchPluginSearchAction SynapseOpenSearchPluginSearchAction;
typedef struct _SynapseOpenSearchPluginSearchActionClass SynapseOpenSearchPluginSearchActionClass;

#define SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_CONFIG (synapse_open_search_plugin_config_get_type ())
#define SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_CONFIG, SynapseOpenSearchPluginConfig))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_CONFIG, SynapseOpenSearchPluginConfigClass))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_CONFIG))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_CONFIG))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_CONFIG, SynapseOpenSearchPluginConfigClass))

typedef struct _SynapseOpenSearchPluginConfig SynapseOpenSearchPluginConfig;
typedef struct _SynapseOpenSearchPluginConfigClass SynapseOpenSearchPluginConfigClass;
enum  {
	SYNAPSE_OPEN_SEARCH_PLUGIN_0_PROPERTY,
	SYNAPSE_OPEN_SEARCH_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_OPEN_SEARCH_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_open_search_plugin_properties[SYNAPSE_OPEN_SEARCH_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_OPEN_SEARCH_PARSER (synapse_open_search_plugin_open_search_parser_get_type ())
#define SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_OPEN_SEARCH_PARSER, SynapseOpenSearchPluginOpenSearchParser))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_OPEN_SEARCH_PARSER, SynapseOpenSearchPluginOpenSearchParserClass))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_IS_OPEN_SEARCH_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_OPEN_SEARCH_PARSER))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_IS_OPEN_SEARCH_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_OPEN_SEARCH_PARSER))
#define SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_OPEN_SEARCH_PARSER, SynapseOpenSearchPluginOpenSearchParserClass))

typedef struct _SynapseOpenSearchPluginOpenSearchParser SynapseOpenSearchPluginOpenSearchParser;
typedef struct _SynapseOpenSearchPluginOpenSearchParserClass SynapseOpenSearchPluginOpenSearchParserClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseOpenSearchPluginLoadXmlsData SynapseOpenSearchPluginLoadXmlsData;
typedef struct _SynapseOpenSearchPluginOpenSearchParserPrivate SynapseOpenSearchPluginOpenSearchParserPrivate;
enum  {
	SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_0_PROPERTY,
	SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_SHORT_NAME_PROPERTY,
	SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_DESCRIPTION_PROPERTY,
	SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_QUERY_URL_PROPERTY,
	SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_SUGGESTION_URL_PROPERTY,
	SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_NUM_PROPERTIES
};
static GParamSpec* synapse_open_search_plugin_open_search_parser_properties[SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_NUM_PROPERTIES];
#define _g_markup_parse_context_unref0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_unref (var), NULL)))
typedef struct _SynapseOpenSearchPluginSearchActionPrivate SynapseOpenSearchPluginSearchActionPrivate;
enum  {
	SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_0_PROPERTY,
	SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_DEFAULT_RELEVANCY_PROPERTY,
	SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_QUERY_TEMPLATE_PROPERTY,
	SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_NUM_PROPERTIES
};
static GParamSpec* synapse_open_search_plugin_search_action_properties[SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_NUM_PROPERTIES];
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _SynapseOpenSearchPluginConfigPrivate SynapseOpenSearchPluginConfigPrivate;
enum  {
	SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_0_PROPERTY,
	SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_USE_INTERNAL_PROPERTY,
	SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_SEARCH_ENGINES_PROPERTY,
	SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_NUM_PROPERTIES
};
static GParamSpec* synapse_open_search_plugin_config_properties[SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_NUM_PROPERTIES];

struct _SynapseOpenSearchPluginPrivate {
	gboolean _enabled;
	GeeList* actions;
	SynapseOpenSearchPluginConfig* config;
};

struct _SynapseOpenSearchPluginLoadXmlsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseOpenSearchPlugin* self;
	SynapseOpenSearchPluginOpenSearchParser* parser;
	SynapseOpenSearchPluginConfig* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeList* internals;
	GeeArrayList* _tmp3_;
	GeeList* _tmp4_;
	GeeList* _tmp5_;
	GeeList* _tmp6_;
	GeeList* _s_list;
	GeeList* _tmp7_;
	gint _s_size;
	GeeList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _s_index;
	gint _tmp11_;
	gint _tmp12_;
	const gchar* s;
	GeeList* _tmp13_;
	gpointer _tmp14_;
	SynapseOpenSearchPluginOpenSearchParser* _tmp15_;
	SynapseOpenSearchPluginOpenSearchParser* _tmp16_;
	const gchar* _tmp17_;
	SynapseOpenSearchPluginOpenSearchParser* _tmp18_;
	GeeList* _tmp19_;
	SynapseOpenSearchPluginOpenSearchParser* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	SynapseOpenSearchPluginOpenSearchParser* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	SynapseOpenSearchPluginOpenSearchParser* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	SynapseOpenSearchPluginSearchAction* _tmp29_;
	SynapseOpenSearchPluginSearchAction* _tmp30_;
	gchar** xmls;
	SynapseOpenSearchPluginConfig* _tmp31_;
	gchar** _tmp32_;
	gint _tmp32__length1;
	gint _tmp33_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	gchar** _tmp35_;
	gint _tmp35__length1;
	gint xmls_length1;
	gint _xmls_size_;
	gchar** _tmp36_;
	gint _tmp36__length1;
	gchar** xml_collection;
	gint xml_collection_length1;
	gint _xml_collection_size_;
	gint xml_it;
	const gchar* xml;
	gchar* xml_path;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	GFile* f;
	const gchar* _tmp45_;
	GFile* _tmp46_;
	guint8* file_contents;
	gint file_contents_length1;
	gint _file_contents_size_;
	gchar* contents;
	gsize len;
	GFile* _tmp47_;
	guint8* _tmp48_;
	gsize _tmp49_;
	guint8* _tmp50_;
	gint _tmp50__length1;
	gchar* _tmp51_;
	guint8* _tmp52_;
	gint _tmp52__length1;
	SynapseOpenSearchPluginOpenSearchParser* _tmp53_;
	SynapseOpenSearchPluginOpenSearchParser* _tmp54_;
	const gchar* _tmp55_;
	SynapseOpenSearchPluginOpenSearchParser* _tmp56_;
	GeeList* _tmp57_;
	SynapseOpenSearchPluginOpenSearchParser* _tmp58_;
	const gchar* _tmp59_;
	const gchar* _tmp60_;
	SynapseOpenSearchPluginOpenSearchParser* _tmp61_;
	const gchar* _tmp62_;
	const gchar* _tmp63_;
	SynapseOpenSearchPluginOpenSearchParser* _tmp64_;
	const gchar* _tmp65_;
	const gchar* _tmp66_;
	SynapseOpenSearchPluginSearchAction* _tmp67_;
	SynapseOpenSearchPluginSearchAction* _tmp68_;
	const gchar* _tmp69_;
	GError* err;
	const gchar* _tmp70_;
	GError* _tmp71_;
	const gchar* _tmp72_;
	GError* _inner_error0_;
};

struct _SynapseOpenSearchPluginOpenSearchParser {
	GObject parent_instance;
	SynapseOpenSearchPluginOpenSearchParserPrivate * priv;
};

struct _SynapseOpenSearchPluginOpenSearchParserClass {
	GObjectClass parent_class;
};

struct _SynapseOpenSearchPluginOpenSearchParserPrivate {
	GMarkupParseContext* context;
	gboolean is_opensearch;
	gboolean in_name_elem;
	gboolean in_description_elem;
	gboolean has_name;
	gboolean has_desc;
	gboolean has_url;
	gchar* _short_name;
	gchar* _description;
	gchar* _query_url;
	gchar* _suggestion_url;
};

struct _SynapseOpenSearchPluginSearchAction {
	SynapseMatch parent_instance;
	SynapseOpenSearchPluginSearchActionPrivate * priv;
};

struct _SynapseOpenSearchPluginSearchActionClass {
	SynapseMatchClass parent_class;
};

struct _SynapseOpenSearchPluginSearchActionPrivate {
	gint _default_relevancy;
	gchar* _query_template;
};

struct _SynapseOpenSearchPluginConfig {
	SynapseConfigObject parent_instance;
	SynapseOpenSearchPluginConfigPrivate * priv;
};

struct _SynapseOpenSearchPluginConfigClass {
	SynapseConfigObjectClass parent_class;
};

struct _SynapseOpenSearchPluginConfigPrivate {
	gboolean _use_internal;
	gchar** _search_engines;
	gint _search_engines_length1;
	gint __search_engines_size_;
};

static gint SynapseOpenSearchPlugin_private_offset;
static gpointer synapse_open_search_plugin_parent_class = NULL;
static gint SynapseOpenSearchPluginOpenSearchParser_private_offset;
static gpointer synapse_open_search_plugin_open_search_parser_parent_class = NULL;
static gint SynapseOpenSearchPluginSearchAction_private_offset;
static gpointer synapse_open_search_plugin_search_action_parent_class = NULL;
static gint SynapseOpenSearchPluginConfig_private_offset;
static gpointer synapse_open_search_plugin_config_parent_class = NULL;
static SynapseActivatableIface * synapse_open_search_plugin_synapse_activatable_parent_iface = NULL;
static SynapseActionProviderIface * synapse_open_search_plugin_synapse_action_provider_parent_iface = NULL;

static GType synapse_open_search_plugin_search_action_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType synapse_open_search_plugin_config_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void synapse_open_search_plugin_real_activate (SynapseActivatable* base);
static void synapse_open_search_plugin_load_xmls (SynapseOpenSearchPlugin* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static void synapse_open_search_plugin_load_xmls_finish (SynapseOpenSearchPlugin* self,
                                                  GAsyncResult* _res_);
static void synapse_open_search_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_open_search_plugin_register_plugin (void);
static void _synapse_open_search_plugin_register_plugin_synapse_plugin_register_func (void);
static void synapse_open_search_plugin_load_xmls_data_free (gpointer _data);
static gboolean synapse_open_search_plugin_load_xmls_co (SynapseOpenSearchPluginLoadXmlsData* _data_);
static GType synapse_open_search_plugin_open_search_parser_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gboolean synapse_open_search_plugin_config_get_use_internal (SynapseOpenSearchPluginConfig* self);
static SynapseOpenSearchPluginOpenSearchParser* synapse_open_search_plugin_open_search_parser_new (void);
static SynapseOpenSearchPluginOpenSearchParser* synapse_open_search_plugin_open_search_parser_construct (GType object_type);
static gboolean synapse_open_search_plugin_open_search_parser_parse (SynapseOpenSearchPluginOpenSearchParser* self,
                                                              const gchar* content,
                                                              GError** error);
static gboolean synapse_open_search_plugin_open_search_parser_has_valid_result (SynapseOpenSearchPluginOpenSearchParser* self);
static const gchar* synapse_open_search_plugin_open_search_parser_get_short_name (SynapseOpenSearchPluginOpenSearchParser* self);
static const gchar* synapse_open_search_plugin_open_search_parser_get_description (SynapseOpenSearchPluginOpenSearchParser* self);
static const gchar* synapse_open_search_plugin_open_search_parser_get_query_url (SynapseOpenSearchPluginOpenSearchParser* self);
static SynapseOpenSearchPluginSearchAction* synapse_open_search_plugin_search_action_new (const gchar* name,
                                                                                   const gchar* description,
                                                                                   const gchar* url);
static SynapseOpenSearchPluginSearchAction* synapse_open_search_plugin_search_action_construct (GType object_type,
                                                                                         const gchar* name,
                                                                                         const gchar* description,
                                                                                         const gchar* url);
static gchar** synapse_open_search_plugin_config_get_search_engines (SynapseOpenSearchPluginConfig* self,
                                                              gint* result_length1);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void synapse_open_search_plugin_load_xmls_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static gboolean synapse_open_search_plugin_real_handles_unknown (SynapseActionProvider* base);
static SynapseResultSet* synapse_open_search_plugin_real_find_for_match (SynapseActionProvider* base,
                                                                  SynapseQuery* query,
                                                                  SynapseMatch* match);
static gint synapse_open_search_plugin_search_action_get_default_relevancy (SynapseOpenSearchPluginSearchAction* self);
static void synapse_open_search_plugin_open_search_parser_start (SynapseOpenSearchPluginOpenSearchParser* self,
                                                          GMarkupParseContext* ctx,
                                                          const gchar* name,
                                                          gchar** attr_names,
                                                          gint attr_names_length1,
                                                          gchar** attr_vals,
                                                          gint attr_vals_length1,
                                                          GError** error);
static void _synapse_open_search_plugin_open_search_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                                                             const gchar* element_name,
                                                                                             gchar** attribute_names,
                                                                                             gchar** attribute_values,
                                                                                             gpointer self,
                                                                                             GError** error);
static void synapse_open_search_plugin_open_search_parser_end (SynapseOpenSearchPluginOpenSearchParser* self,
                                                        GMarkupParseContext* ctx,
                                                        const gchar* name,
                                                        GError** error);
static void _synapse_open_search_plugin_open_search_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context,
                                                                                         const gchar* element_name,
                                                                                         gpointer self,
                                                                                         GError** error);
static void synapse_open_search_plugin_open_search_parser_text (SynapseOpenSearchPluginOpenSearchParser* self,
                                                         GMarkupParseContext* ctx,
                                                         const gchar* text,
                                                         gsize text_len,
                                                         GError** error);
static void _synapse_open_search_plugin_open_search_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context,
                                                                                   const gchar* text,
                                                                                   gsize text_len,
                                                                                   gpointer self,
                                                                                   GError** error);
static void synapse_open_search_plugin_open_search_parser_process_url (SynapseOpenSearchPluginOpenSearchParser* self,
                                                                gchar** attrs,
                                                                gint attrs_length1,
                                                                gchar** vals,
                                                                gint vals_length1);
static void synapse_open_search_plugin_open_search_parser_set_query_url (SynapseOpenSearchPluginOpenSearchParser* self,
                                                                  const gchar* value);
static void synapse_open_search_plugin_open_search_parser_set_suggestion_url (SynapseOpenSearchPluginOpenSearchParser* self,
                                                                       const gchar* value);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void synapse_open_search_plugin_open_search_parser_set_short_name (SynapseOpenSearchPluginOpenSearchParser* self,
                                                                   const gchar* value);
static void synapse_open_search_plugin_open_search_parser_set_description (SynapseOpenSearchPluginOpenSearchParser* self,
                                                                    const gchar* value);
static const gchar* synapse_open_search_plugin_open_search_parser_get_suggestion_url (SynapseOpenSearchPluginOpenSearchParser* self);
static GObject * synapse_open_search_plugin_open_search_parser_constructor (GType type,
                                                                     guint n_construct_properties,
                                                                     GObjectConstructParam * construct_properties);
static void synapse_open_search_plugin_open_search_parser_finalize (GObject * obj);
static GType synapse_open_search_plugin_open_search_parser_get_type_once (void);
static void _vala_synapse_open_search_plugin_open_search_parser_get_property (GObject * object,
                                                                       guint property_id,
                                                                       GValue * value,
                                                                       GParamSpec * pspec);
static void _vala_synapse_open_search_plugin_open_search_parser_set_property (GObject * object,
                                                                       guint property_id,
                                                                       const GValue * value,
                                                                       GParamSpec * pspec);
static void synapse_open_search_plugin_search_action_real_execute (SynapseMatch* base,
                                                            SynapseMatch* match);
static gchar* synapse_open_search_plugin_search_action_get_query_url (SynapseOpenSearchPluginSearchAction* self,
                                                               const gchar* query);
static const gchar* synapse_open_search_plugin_search_action_get_query_template (SynapseOpenSearchPluginSearchAction* self);
static gchar* synapse_open_search_plugin_search_action_get_lang (SynapseOpenSearchPluginSearchAction* self);
static void synapse_open_search_plugin_search_action_set_default_relevancy (SynapseOpenSearchPluginSearchAction* self,
                                                                     gint value);
static void synapse_open_search_plugin_search_action_set_query_template (SynapseOpenSearchPluginSearchAction* self,
                                                                  const gchar* value);
static void synapse_open_search_plugin_search_action_finalize (GObject * obj);
static GType synapse_open_search_plugin_search_action_get_type_once (void);
static void _vala_synapse_open_search_plugin_search_action_get_property (GObject * object,
                                                                  guint property_id,
                                                                  GValue * value,
                                                                  GParamSpec * pspec);
static void _vala_synapse_open_search_plugin_search_action_set_property (GObject * object,
                                                                  guint property_id,
                                                                  const GValue * value,
                                                                  GParamSpec * pspec);
static SynapseOpenSearchPluginConfig* synapse_open_search_plugin_config_new (void);
static SynapseOpenSearchPluginConfig* synapse_open_search_plugin_config_construct (GType object_type);
static void synapse_open_search_plugin_config_set_use_internal (SynapseOpenSearchPluginConfig* self,
                                                         gboolean value);
static void synapse_open_search_plugin_config_set_search_engines (SynapseOpenSearchPluginConfig* self,
                                                           gchar** value,
                                                           gint value_length1);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static void synapse_open_search_plugin_config_finalize (GObject * obj);
static GType synapse_open_search_plugin_config_get_type_once (void);
static void _vala_synapse_open_search_plugin_config_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec);
static void _vala_synapse_open_search_plugin_config_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec);
static GObject * synapse_open_search_plugin_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static void synapse_open_search_plugin_finalize (GObject * obj);
static GType synapse_open_search_plugin_get_type_once (void);
static void _vala_synapse_open_search_plugin_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_synapse_open_search_plugin_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GMarkupParser SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_parser = {_synapse_open_search_plugin_open_search_parser_start_gmarkup_parser_start_element_func, _synapse_open_search_plugin_open_search_parser_end_gmarkup_parser_end_element_func, _synapse_open_search_plugin_open_search_parser_text_gmarkup_parser_text_func, NULL, NULL};

static inline gpointer
synapse_open_search_plugin_get_instance_private (SynapseOpenSearchPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseOpenSearchPlugin_private_offset);
}

static void
synapse_open_search_plugin_real_activate (SynapseActivatable* base)
{
	SynapseOpenSearchPlugin * self;
	GeeArrayList* _tmp0_;
#line 65 "opensearch.vala"
	self = (SynapseOpenSearchPlugin*) base;
#line 67 "opensearch.vala"
	_tmp0_ = gee_array_list_new (SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_SEARCH_ACTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 67 "opensearch.vala"
	_g_object_unref0 (self->priv->actions);
#line 67 "opensearch.vala"
	self->priv->actions = (GeeList*) _tmp0_;
#line 68 "opensearch.vala"
	synapse_open_search_plugin_load_xmls (self, NULL, NULL);
#line 484 "opensearch.c"
}

static void
synapse_open_search_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseOpenSearchPlugin * self;
#line 71 "opensearch.vala"
	self = (SynapseOpenSearchPlugin*) base;
#line 493 "opensearch.c"
}

static void
_synapse_open_search_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 251 "opensearch.vala"
	synapse_open_search_plugin_register_plugin ();
#line 501 "opensearch.c"
}

static void
synapse_open_search_plugin_register_plugin (void)
{
	SynapsePluginRegistry* _tmp0_;
	SynapsePluginRegistry* _tmp1_;
#line 251 "opensearch.vala"
	_tmp0_ = synapse_plugin_registry_get_default ();
#line 251 "opensearch.vala"
	_tmp1_ = _tmp0_;
#line 251 "opensearch.vala"
	synapse_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_OPEN_SEARCH_PLUGIN, "OpenSearch", _ ("Search the web."), "applications-internet", _synapse_open_search_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
#line 251 "opensearch.vala"
	_g_object_unref0 (_tmp1_);
#line 517 "opensearch.c"
}

static void
synapse_open_search_plugin_load_xmls_data_free (gpointer _data)
{
	SynapseOpenSearchPluginLoadXmlsData* _data_;
	_data_ = _data;
#line 61 "opensearch.vala"
	_g_object_unref0 (_data_->self);
#line 61 "opensearch.vala"
	g_slice_free (SynapseOpenSearchPluginLoadXmlsData, _data_);
#line 529 "opensearch.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 61 "opensearch.vala"
	return self ? g_object_ref (self) : NULL;
#line 537 "opensearch.c"
}

static void
synapse_open_search_plugin_load_xmls (SynapseOpenSearchPlugin* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	SynapseOpenSearchPluginLoadXmlsData* _data_;
	SynapseOpenSearchPlugin* _tmp0_;
#line 61 "opensearch.vala"
	g_return_if_fail (self != NULL);
#line 61 "opensearch.vala"
	_data_ = g_slice_new0 (SynapseOpenSearchPluginLoadXmlsData);
#line 61 "opensearch.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 61 "opensearch.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_open_search_plugin_load_xmls_data_free);
#line 61 "opensearch.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 61 "opensearch.vala"
	_data_->self = _tmp0_;
#line 61 "opensearch.vala"
	synapse_open_search_plugin_load_xmls_co (_data_);
#line 561 "opensearch.c"
}

static void
synapse_open_search_plugin_load_xmls_finish (SynapseOpenSearchPlugin* self,
                                             GAsyncResult* _res_)
{
	SynapseOpenSearchPluginLoadXmlsData* _data_;
#line 61 "opensearch.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 571 "opensearch.c"
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
#line 309 "opensearch.vala"
	if (length >= 0) {
#line 580 "opensearch.c"
		gchar** result;
		gssize i;
#line 309 "opensearch.vala"
		result = g_new0 (gchar*, length + 1);
#line 309 "opensearch.vala"
		for (i = 0; i < length; i++) {
#line 587 "opensearch.c"
			gchar* _tmp0_;
#line 309 "opensearch.vala"
			_tmp0_ = g_strdup (self[i]);
#line 309 "opensearch.vala"
			result[i] = _tmp0_;
#line 593 "opensearch.c"
		}
#line 309 "opensearch.vala"
		return result;
#line 597 "opensearch.c"
	}
#line 309 "opensearch.vala"
	return NULL;
#line 601 "opensearch.c"
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
#line 1501 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1501 "glib-2.0.vapi"
	end = _tmp0_;
#line 1502 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1502 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1503 "glib-2.0.vapi"
		result = maxlen;
#line 1503 "glib-2.0.vapi"
		return result;
#line 624 "opensearch.c"
	} else {
		gchar* _tmp2_;
#line 1505 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1505 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1505 "glib-2.0.vapi"
		return result;
#line 633 "opensearch.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
#line 1512 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1514 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 652 "opensearch.c"
	} else {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 656 "opensearch.c"
	}
#line 1514 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1516 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 662 "opensearch.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1518 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1518 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1518 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 672 "opensearch.c"
	}
#line 1521 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1522 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1523 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 680 "opensearch.c"
	} else {
#line 1525 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 684 "opensearch.c"
	}
#line 1527 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1528 "glib-2.0.vapi"
		len = string_length - offset;
#line 690 "opensearch.c"
	}
#line 1530 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1531 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1531 "glib-2.0.vapi"
	result = _tmp3_;
#line 1531 "glib-2.0.vapi"
	return result;
#line 700 "opensearch.c"
}

static void
synapse_open_search_plugin_load_xmls_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	SynapseOpenSearchPluginLoadXmlsData* _data_;
#line 324 "opensearch.vala"
	_data_ = _user_data_;
#line 324 "opensearch.vala"
	_data_->_source_object_ = source_object;
#line 324 "opensearch.vala"
	_data_->_res_ = _res_;
#line 324 "opensearch.vala"
	synapse_open_search_plugin_load_xmls_co (_data_);
#line 717 "opensearch.c"
}

static gboolean
synapse_open_search_plugin_load_xmls_co (SynapseOpenSearchPluginLoadXmlsData* _data_)
{
#line 283 "opensearch.vala"
	switch (_data_->_state_) {
#line 283 "opensearch.vala"
		case 0:
#line 727 "opensearch.c"
		goto _state_0;
#line 283 "opensearch.vala"
		case 1:
#line 731 "opensearch.c"
		goto _state_1;
		default:
#line 283 "opensearch.vala"
		g_assert_not_reached ();
#line 736 "opensearch.c"
	}
	_state_0:
#line 286 "opensearch.vala"
	_data_->_tmp0_ = _data_->self->priv->config;
#line 286 "opensearch.vala"
	_data_->_tmp1_ = synapse_open_search_plugin_config_get_use_internal (_data_->_tmp0_);
#line 286 "opensearch.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 286 "opensearch.vala"
	if (_data_->_tmp2_) {
#line 288 "opensearch.vala"
		_data_->_tmp3_ = gee_array_list_new (G_TYPE_STRING, NULL, NULL, NULL, NULL, NULL);
#line 288 "opensearch.vala"
		_data_->internals = (GeeList*) _data_->_tmp3_;
#line 289 "opensearch.vala"
		_data_->_tmp4_ = _data_->internals;
#line 289 "opensearch.vala"
		gee_collection_add ((GeeCollection*) _data_->_tmp4_, SYNAPSE_DUCKDUCKGO_SEARCH_XML);
#line 290 "opensearch.vala"
		_data_->_tmp5_ = _data_->internals;
#line 290 "opensearch.vala"
		gee_collection_add ((GeeCollection*) _data_->_tmp5_, SYNAPSE_GOOGLE_SEARCH_XML);
#line 291 "opensearch.vala"
		_data_->_tmp6_ = _data_->internals;
#line 291 "opensearch.vala"
		gee_collection_add ((GeeCollection*) _data_->_tmp6_, SYNAPSE_GOOGLE_MAPS_XML);
#line 763 "opensearch.c"
		{
#line 292 "opensearch.vala"
			_data_->_tmp7_ = _data_->internals;
#line 292 "opensearch.vala"
			_data_->_s_list = _data_->_tmp7_;
#line 292 "opensearch.vala"
			_data_->_tmp8_ = _data_->_s_list;
#line 292 "opensearch.vala"
			_data_->_tmp9_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp8_);
#line 292 "opensearch.vala"
			_data_->_tmp10_ = _data_->_tmp9_;
#line 292 "opensearch.vala"
			_data_->_s_size = _data_->_tmp10_;
#line 292 "opensearch.vala"
			_data_->_s_index = -1;
#line 292 "opensearch.vala"
			while (TRUE) {
#line 292 "opensearch.vala"
				_data_->_s_index = _data_->_s_index + 1;
#line 292 "opensearch.vala"
				_data_->_tmp11_ = _data_->_s_index;
#line 292 "opensearch.vala"
				_data_->_tmp12_ = _data_->_s_size;
#line 292 "opensearch.vala"
				if (!(_data_->_tmp11_ < _data_->_tmp12_)) {
#line 292 "opensearch.vala"
					break;
#line 791 "opensearch.c"
				}
#line 292 "opensearch.vala"
				_data_->_tmp13_ = _data_->_s_list;
#line 292 "opensearch.vala"
				_data_->_tmp14_ = gee_list_get (_data_->_tmp13_, _data_->_s_index);
#line 292 "opensearch.vala"
				_data_->s = (const gchar*) _data_->_tmp14_;
#line 294 "opensearch.vala"
				_data_->_tmp15_ = synapse_open_search_plugin_open_search_parser_new ();
#line 294 "opensearch.vala"
				_g_object_unref0 (_data_->parser);
#line 294 "opensearch.vala"
				_data_->parser = _data_->_tmp15_;
#line 805 "opensearch.c"
				{
#line 297 "opensearch.vala"
					_data_->_tmp16_ = _data_->parser;
#line 297 "opensearch.vala"
					_data_->_tmp17_ = _data_->s;
#line 297 "opensearch.vala"
					synapse_open_search_plugin_open_search_parser_parse (_data_->_tmp16_, _data_->_tmp17_, &_data_->_inner_error0_);
#line 297 "opensearch.vala"
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 815 "opensearch.c"
						goto __catch0_g_error;
					}
#line 298 "opensearch.vala"
					_data_->_tmp18_ = _data_->parser;
#line 298 "opensearch.vala"
					if (synapse_open_search_plugin_open_search_parser_has_valid_result (_data_->_tmp18_)) {
#line 300 "opensearch.vala"
						_data_->_tmp19_ = _data_->self->priv->actions;
#line 300 "opensearch.vala"
						_data_->_tmp20_ = _data_->parser;
#line 300 "opensearch.vala"
						_data_->_tmp21_ = synapse_open_search_plugin_open_search_parser_get_short_name (_data_->_tmp20_);
#line 300 "opensearch.vala"
						_data_->_tmp22_ = _data_->_tmp21_;
#line 300 "opensearch.vala"
						_data_->_tmp23_ = _data_->parser;
#line 300 "opensearch.vala"
						_data_->_tmp24_ = synapse_open_search_plugin_open_search_parser_get_description (_data_->_tmp23_);
#line 300 "opensearch.vala"
						_data_->_tmp25_ = _data_->_tmp24_;
#line 300 "opensearch.vala"
						_data_->_tmp26_ = _data_->parser;
#line 300 "opensearch.vala"
						_data_->_tmp27_ = synapse_open_search_plugin_open_search_parser_get_query_url (_data_->_tmp26_);
#line 300 "opensearch.vala"
						_data_->_tmp28_ = _data_->_tmp27_;
#line 300 "opensearch.vala"
						_data_->_tmp29_ = synapse_open_search_plugin_search_action_new (_ (_data_->_tmp22_), _ (_data_->_tmp25_), _data_->_tmp28_);
#line 300 "opensearch.vala"
						_data_->_tmp30_ = _data_->_tmp29_;
#line 300 "opensearch.vala"
						gee_collection_add ((GeeCollection*) _data_->_tmp19_, _data_->_tmp30_);
#line 300 "opensearch.vala"
						_g_object_unref0 (_data_->_tmp30_);
#line 850 "opensearch.c"
					}
				}
				goto __finally0;
				__catch0_g_error:
				{
#line 295 "opensearch.vala"
					g_clear_error (&_data_->_inner_error0_);
#line 858 "opensearch.c"
				}
				__finally0:
#line 295 "opensearch.vala"
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 295 "opensearch.vala"
					_g_object_unref0 (_data_->internals);
#line 295 "opensearch.vala"
					_g_object_unref0 (_data_->parser);
#line 295 "opensearch.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 295 "opensearch.vala"
					g_clear_error (&_data_->_inner_error0_);
#line 295 "opensearch.vala"
					g_object_unref (_data_->_async_result);
#line 295 "opensearch.vala"
					return FALSE;
#line 875 "opensearch.c"
				}
			}
		}
#line 286 "opensearch.vala"
		_g_object_unref0 (_data_->internals);
#line 881 "opensearch.c"
	}
#line 309 "opensearch.vala"
	_data_->_tmp31_ = _data_->self->priv->config;
#line 309 "opensearch.vala"
	_data_->_tmp33_ = 0;
#line 309 "opensearch.vala"
	_data_->_tmp32_ = synapse_open_search_plugin_config_get_search_engines (_data_->_tmp31_, &_data_->_tmp33_);
#line 309 "opensearch.vala"
	_data_->_tmp32__length1 = _data_->_tmp33_;
#line 309 "opensearch.vala"
	_data_->_tmp34_ = _data_->_tmp32_;
#line 309 "opensearch.vala"
	_data_->_tmp34__length1 = _data_->_tmp32__length1;
#line 309 "opensearch.vala"
	_data_->_tmp35_ = (_data_->_tmp34_ != NULL) ? _vala_array_dup1 (_data_->_tmp34_, _data_->_tmp34__length1) : _data_->_tmp34_;
#line 309 "opensearch.vala"
	_data_->_tmp35__length1 = _data_->_tmp34__length1;
#line 309 "opensearch.vala"
	_data_->xmls = _data_->_tmp35_;
#line 309 "opensearch.vala"
	_data_->xmls_length1 = _data_->_tmp35__length1;
#line 309 "opensearch.vala"
	_data_->_xmls_size_ = _data_->xmls_length1;
#line 310 "opensearch.vala"
	_data_->_tmp36_ = _data_->xmls;
#line 310 "opensearch.vala"
	_data_->_tmp36__length1 = _data_->xmls_length1;
#line 909 "opensearch.c"
	{
#line 310 "opensearch.vala"
		_data_->xml_collection_length1 = 0;
#line 310 "opensearch.vala"
		_data_->_xml_collection_size_ = 0;
#line 310 "opensearch.vala"
		_data_->xml_collection = _data_->_tmp36_;
#line 310 "opensearch.vala"
		_data_->xml_collection_length1 = _data_->_tmp36__length1;
#line 310 "opensearch.vala"
		for (_data_->xml_it = 0; _data_->xml_it < _data_->xml_collection_length1; _data_->xml_it = _data_->xml_it + 1) {
#line 310 "opensearch.vala"
			_data_->xml = _data_->xml_collection[_data_->xml_it];
#line 923 "opensearch.c"
			{
#line 312 "opensearch.vala"
				_data_->_tmp37_ = _data_->xml;
#line 312 "opensearch.vala"
				_data_->_tmp38_ = g_strdup (_data_->_tmp37_);
#line 312 "opensearch.vala"
				_data_->xml_path = _data_->_tmp38_;
#line 313 "opensearch.vala"
				_data_->_tmp39_ = _data_->xml_path;
#line 313 "opensearch.vala"
				if (g_str_has_prefix (_data_->_tmp39_, "~")) {
#line 315 "opensearch.vala"
					_data_->_tmp40_ = g_get_home_dir ();
#line 315 "opensearch.vala"
					_data_->_tmp41_ = _data_->xml_path;
#line 315 "opensearch.vala"
					_data_->_tmp42_ = string_substring (_data_->_tmp41_, (glong) 1, (glong) -1);
#line 315 "opensearch.vala"
					_data_->_tmp43_ = _data_->_tmp42_;
#line 315 "opensearch.vala"
					_data_->_tmp44_ = g_strconcat (_data_->_tmp40_, _data_->_tmp43_, NULL);
#line 315 "opensearch.vala"
					_g_free0 (_data_->xml_path);
#line 315 "opensearch.vala"
					_data_->xml_path = _data_->_tmp44_;
#line 315 "opensearch.vala"
					_g_free0 (_data_->_tmp43_);
#line 951 "opensearch.c"
				}
#line 318 "opensearch.vala"
				_data_->_tmp45_ = _data_->xml_path;
#line 318 "opensearch.vala"
				_data_->_tmp46_ = g_file_new_for_path (_data_->_tmp45_);
#line 318 "opensearch.vala"
				_data_->f = _data_->_tmp46_;
#line 959 "opensearch.c"
				{
#line 321 "opensearch.vala"
					_data_->file_contents_length1 = 0;
#line 321 "opensearch.vala"
					_data_->_file_contents_size_ = 0;
#line 324 "opensearch.vala"
					_data_->_tmp47_ = _data_->f;
#line 324 "opensearch.vala"
					_data_->_tmp48_ = NULL;
#line 324 "opensearch.vala"
					_data_->_tmp49_ = 0;
#line 324 "opensearch.vala"
					_data_->_state_ = 1;
#line 324 "opensearch.vala"
					g_file_load_contents_async (_data_->_tmp47_, NULL, synapse_open_search_plugin_load_xmls_ready, _data_);
#line 324 "opensearch.vala"
					return FALSE;
#line 977 "opensearch.c"
					_state_1:
#line 324 "opensearch.vala"
					g_file_load_contents_finish (_data_->_tmp47_, _data_->_res_, &_data_->_tmp48_, &_data_->_tmp49_, NULL, &_data_->_inner_error0_);
#line 324 "opensearch.vala"
					_data_->file_contents = (g_free (_data_->file_contents), NULL);
#line 324 "opensearch.vala"
					_data_->file_contents = _data_->_tmp48_;
#line 324 "opensearch.vala"
					_data_->file_contents_length1 = _data_->_tmp49_;
#line 324 "opensearch.vala"
					_data_->_file_contents_size_ = _data_->file_contents_length1;
#line 324 "opensearch.vala"
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 324 "opensearch.vala"
						_g_free0 (_data_->contents);
#line 324 "opensearch.vala"
						_data_->file_contents = (g_free (_data_->file_contents), NULL);
#line 995 "opensearch.c"
						goto __catch1_g_error;
					}
#line 325 "opensearch.vala"
					_data_->_tmp50_ = _data_->file_contents;
#line 325 "opensearch.vala"
					_data_->_tmp50__length1 = _data_->file_contents_length1;
#line 325 "opensearch.vala"
					_data_->_tmp51_ = g_strdup ((const gchar*) _data_->_tmp50_);
#line 325 "opensearch.vala"
					_g_free0 (_data_->contents);
#line 325 "opensearch.vala"
					_data_->contents = _data_->_tmp51_;
#line 326 "opensearch.vala"
					_data_->_tmp52_ = _data_->file_contents;
#line 326 "opensearch.vala"
					_data_->_tmp52__length1 = _data_->file_contents_length1;
#line 326 "opensearch.vala"
					_data_->len = (gsize) _data_->_tmp52__length1;
#line 328 "opensearch.vala"
					_data_->_tmp53_ = synapse_open_search_plugin_open_search_parser_new ();
#line 328 "opensearch.vala"
					_g_object_unref0 (_data_->parser);
#line 328 "opensearch.vala"
					_data_->parser = _data_->_tmp53_;
#line 329 "opensearch.vala"
					_data_->_tmp54_ = _data_->parser;
#line 329 "opensearch.vala"
					_data_->_tmp55_ = _data_->contents;
#line 329 "opensearch.vala"
					synapse_open_search_plugin_open_search_parser_parse (_data_->_tmp54_, _data_->_tmp55_, &_data_->_inner_error0_);
#line 329 "opensearch.vala"
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 329 "opensearch.vala"
						_g_free0 (_data_->contents);
#line 329 "opensearch.vala"
						_data_->file_contents = (g_free (_data_->file_contents), NULL);
#line 1032 "opensearch.c"
						goto __catch1_g_error;
					}
#line 330 "opensearch.vala"
					_data_->_tmp56_ = _data_->parser;
#line 330 "opensearch.vala"
					if (synapse_open_search_plugin_open_search_parser_has_valid_result (_data_->_tmp56_)) {
#line 332 "opensearch.vala"
						_data_->_tmp57_ = _data_->self->priv->actions;
#line 332 "opensearch.vala"
						_data_->_tmp58_ = _data_->parser;
#line 332 "opensearch.vala"
						_data_->_tmp59_ = synapse_open_search_plugin_open_search_parser_get_short_name (_data_->_tmp58_);
#line 332 "opensearch.vala"
						_data_->_tmp60_ = _data_->_tmp59_;
#line 332 "opensearch.vala"
						_data_->_tmp61_ = _data_->parser;
#line 332 "opensearch.vala"
						_data_->_tmp62_ = synapse_open_search_plugin_open_search_parser_get_description (_data_->_tmp61_);
#line 332 "opensearch.vala"
						_data_->_tmp63_ = _data_->_tmp62_;
#line 332 "opensearch.vala"
						_data_->_tmp64_ = _data_->parser;
#line 332 "opensearch.vala"
						_data_->_tmp65_ = synapse_open_search_plugin_open_search_parser_get_query_url (_data_->_tmp64_);
#line 332 "opensearch.vala"
						_data_->_tmp66_ = _data_->_tmp65_;
#line 332 "opensearch.vala"
						_data_->_tmp67_ = synapse_open_search_plugin_search_action_new (_data_->_tmp60_, _data_->_tmp63_, _data_->_tmp66_);
#line 332 "opensearch.vala"
						_data_->_tmp68_ = _data_->_tmp67_;
#line 332 "opensearch.vala"
						gee_collection_add ((GeeCollection*) _data_->_tmp57_, _data_->_tmp68_);
#line 332 "opensearch.vala"
						_g_object_unref0 (_data_->_tmp68_);
#line 1067 "opensearch.c"
					} else {
#line 336 "opensearch.vala"
						_data_->_tmp69_ = _data_->xml;
#line 336 "opensearch.vala"
						g_warning ("opensearch.vala:336: Unable to parse search plugin [%s]", _data_->_tmp69_);
#line 1073 "opensearch.c"
					}
#line 319 "opensearch.vala"
					_g_free0 (_data_->contents);
#line 319 "opensearch.vala"
					_data_->file_contents = (g_free (_data_->file_contents), NULL);
#line 1079 "opensearch.c"
				}
				goto __finally1;
				__catch1_g_error:
				{
#line 319 "opensearch.vala"
					_data_->err = _data_->_inner_error0_;
#line 319 "opensearch.vala"
					_data_->_inner_error0_ = NULL;
#line 340 "opensearch.vala"
					_data_->_tmp70_ = _data_->xml;
#line 340 "opensearch.vala"
					_data_->_tmp71_ = _data_->err;
#line 340 "opensearch.vala"
					_data_->_tmp72_ = _data_->_tmp71_->message;
#line 340 "opensearch.vala"
					g_warning ("opensearch.vala:340: Unable to load search plugin [%s]: %s", _data_->_tmp70_, _data_->_tmp72_);
#line 319 "opensearch.vala"
					_g_error_free0 (_data_->err);
#line 1098 "opensearch.c"
				}
				__finally1:
#line 319 "opensearch.vala"
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 319 "opensearch.vala"
					_g_object_unref0 (_data_->f);
#line 319 "opensearch.vala"
					_g_free0 (_data_->xml_path);
#line 319 "opensearch.vala"
					_data_->xmls = (_vala_array_free (_data_->xmls, _data_->xmls_length1, (GDestroyNotify) g_free), NULL);
#line 319 "opensearch.vala"
					_g_object_unref0 (_data_->parser);
#line 319 "opensearch.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 319 "opensearch.vala"
					g_clear_error (&_data_->_inner_error0_);
#line 319 "opensearch.vala"
					g_object_unref (_data_->_async_result);
#line 319 "opensearch.vala"
					return FALSE;
#line 1119 "opensearch.c"
				}
#line 310 "opensearch.vala"
				_g_object_unref0 (_data_->f);
#line 310 "opensearch.vala"
				_g_free0 (_data_->xml_path);
#line 1125 "opensearch.c"
			}
		}
	}
#line 283 "opensearch.vala"
	_data_->xmls = (_vala_array_free (_data_->xmls, _data_->xmls_length1, (GDestroyNotify) g_free), NULL);
#line 283 "opensearch.vala"
	_g_object_unref0 (_data_->parser);
#line 283 "opensearch.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 283 "opensearch.vala"
	if (_data_->_state_ != 0) {
#line 283 "opensearch.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 283 "opensearch.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1141 "opensearch.c"
		}
	}
#line 283 "opensearch.vala"
	g_object_unref (_data_->_async_result);
#line 283 "opensearch.vala"
	return FALSE;
#line 1148 "opensearch.c"
}

static gboolean
synapse_open_search_plugin_real_handles_unknown (SynapseActionProvider* base)
{
	SynapseOpenSearchPlugin * self;
	gboolean result;
#line 345 "opensearch.vala"
	self = (SynapseOpenSearchPlugin*) base;
#line 347 "opensearch.vala"
	result = TRUE;
#line 347 "opensearch.vala"
	return result;
#line 1162 "opensearch.c"
}

static SynapseResultSet*
synapse_open_search_plugin_real_find_for_match (SynapseActionProvider* base,
                                                SynapseQuery* query,
                                                SynapseMatch* match)
{
	SynapseOpenSearchPlugin * self;
	gboolean _tmp0_ = FALSE;
	SynapseQueryFlags my_flags = 0U;
	SynapseQuery _tmp1_;
	gboolean query_empty = FALSE;
	SynapseQuery _tmp2_;
	const gchar* _tmp3_;
	SynapseResultSet* results = NULL;
	SynapseResultSet* _tmp4_;
	SynapseResultSet* result;
#line 350 "opensearch.vala"
	self = (SynapseOpenSearchPlugin*) base;
#line 350 "opensearch.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 350 "opensearch.vala"
	g_return_val_if_fail (match != NULL, NULL);
#line 352 "opensearch.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_UNKNOWN_MATCH)) {
#line 352 "opensearch.vala"
		_tmp0_ = TRUE;
#line 1190 "opensearch.c"
	} else {
#line 352 "opensearch.vala"
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_TEXT_MATCH);
#line 1194 "opensearch.c"
	}
#line 352 "opensearch.vala"
	if (!_tmp0_) {
#line 352 "opensearch.vala"
		result = NULL;
#line 352 "opensearch.vala"
		return result;
#line 1202 "opensearch.c"
	}
#line 354 "opensearch.vala"
	my_flags = SYNAPSE_QUERY_FLAGS_ACTIONS | SYNAPSE_QUERY_FLAGS_INTERNET;
#line 355 "opensearch.vala"
	_tmp1_ = *query;
#line 355 "opensearch.vala"
	if ((_tmp1_.query_type & my_flags) == 0) {
#line 355 "opensearch.vala"
		result = NULL;
#line 355 "opensearch.vala"
		return result;
#line 1214 "opensearch.c"
	}
#line 357 "opensearch.vala"
	_tmp2_ = *query;
#line 357 "opensearch.vala"
	_tmp3_ = _tmp2_.query_string;
#line 357 "opensearch.vala"
	query_empty = g_strcmp0 (_tmp3_, "") == 0;
#line 358 "opensearch.vala"
	_tmp4_ = synapse_result_set_new ();
#line 358 "opensearch.vala"
	results = _tmp4_;
#line 360 "opensearch.vala"
	if (query_empty) {
#line 1228 "opensearch.c"
		{
			GeeList* _action_list = NULL;
			GeeList* _tmp5_;
			gint _action_size = 0;
			GeeList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _action_index = 0;
#line 362 "opensearch.vala"
			_tmp5_ = self->priv->actions;
#line 362 "opensearch.vala"
			_action_list = _tmp5_;
#line 362 "opensearch.vala"
			_tmp6_ = _action_list;
#line 362 "opensearch.vala"
			_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
#line 362 "opensearch.vala"
			_tmp8_ = _tmp7_;
#line 362 "opensearch.vala"
			_action_size = _tmp8_;
#line 362 "opensearch.vala"
			_action_index = -1;
#line 362 "opensearch.vala"
			while (TRUE) {
#line 1253 "opensearch.c"
				gint _tmp9_;
				gint _tmp10_;
				SynapseOpenSearchPluginSearchAction* action = NULL;
				GeeList* _tmp11_;
				gpointer _tmp12_;
				SynapseResultSet* _tmp13_;
				SynapseOpenSearchPluginSearchAction* _tmp14_;
				SynapseOpenSearchPluginSearchAction* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
#line 362 "opensearch.vala"
				_action_index = _action_index + 1;
#line 362 "opensearch.vala"
				_tmp9_ = _action_index;
#line 362 "opensearch.vala"
				_tmp10_ = _action_size;
#line 362 "opensearch.vala"
				if (!(_tmp9_ < _tmp10_)) {
#line 362 "opensearch.vala"
					break;
#line 1274 "opensearch.c"
				}
#line 362 "opensearch.vala"
				_tmp11_ = _action_list;
#line 362 "opensearch.vala"
				_tmp12_ = gee_list_get (_tmp11_, _action_index);
#line 362 "opensearch.vala"
				action = (SynapseOpenSearchPluginSearchAction*) _tmp12_;
#line 364 "opensearch.vala"
				_tmp13_ = results;
#line 364 "opensearch.vala"
				_tmp14_ = action;
#line 364 "opensearch.vala"
				_tmp15_ = action;
#line 364 "opensearch.vala"
				_tmp16_ = synapse_open_search_plugin_search_action_get_default_relevancy (_tmp15_);
#line 364 "opensearch.vala"
				_tmp17_ = _tmp16_;
#line 364 "opensearch.vala"
				synapse_result_set_add (_tmp13_, (SynapseMatch*) _tmp14_, _tmp17_);
#line 362 "opensearch.vala"
				_g_object_unref0 (action);
#line 1296 "opensearch.c"
			}
		}
	} else {
		GeeList* matchers = NULL;
		SynapseQuery _tmp18_;
		const gchar* _tmp19_;
		GeeList* _tmp20_;
#line 369 "opensearch.vala"
		_tmp18_ = *query;
#line 369 "opensearch.vala"
		_tmp19_ = _tmp18_.query_string;
#line 369 "opensearch.vala"
		_tmp20_ = synapse_query_get_matchers_for_query (_tmp19_, 0, G_REGEX_CASELESS);
#line 369 "opensearch.vala"
		matchers = _tmp20_;
#line 1312 "opensearch.c"
		{
			GeeList* _item_list = NULL;
			GeeList* _tmp21_;
			gint _item_size = 0;
			GeeList* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			gint _item_index = 0;
#line 371 "opensearch.vala"
			_tmp21_ = self->priv->actions;
#line 371 "opensearch.vala"
			_item_list = _tmp21_;
#line 371 "opensearch.vala"
			_tmp22_ = _item_list;
#line 371 "opensearch.vala"
			_tmp23_ = gee_collection_get_size ((GeeCollection*) _tmp22_);
#line 371 "opensearch.vala"
			_tmp24_ = _tmp23_;
#line 371 "opensearch.vala"
			_item_size = _tmp24_;
#line 371 "opensearch.vala"
			_item_index = -1;
#line 371 "opensearch.vala"
			while (TRUE) {
#line 1337 "opensearch.c"
				gint _tmp25_;
				gint _tmp26_;
				SynapseOpenSearchPluginSearchAction* item = NULL;
				GeeList* _tmp27_;
				gpointer _tmp28_;
#line 371 "opensearch.vala"
				_item_index = _item_index + 1;
#line 371 "opensearch.vala"
				_tmp25_ = _item_index;
#line 371 "opensearch.vala"
				_tmp26_ = _item_size;
#line 371 "opensearch.vala"
				if (!(_tmp25_ < _tmp26_)) {
#line 371 "opensearch.vala"
					break;
#line 1353 "opensearch.c"
				}
#line 371 "opensearch.vala"
				_tmp27_ = _item_list;
#line 371 "opensearch.vala"
				_tmp28_ = gee_list_get (_tmp27_, _item_index);
#line 371 "opensearch.vala"
				item = (SynapseOpenSearchPluginSearchAction*) _tmp28_;
#line 1361 "opensearch.c"
				{
					GeeList* _matcher_list = NULL;
					GeeList* _tmp29_;
					gint _matcher_size = 0;
					GeeList* _tmp30_;
					gint _tmp31_;
					gint _tmp32_;
					gint _matcher_index = 0;
#line 373 "opensearch.vala"
					_tmp29_ = matchers;
#line 373 "opensearch.vala"
					_matcher_list = _tmp29_;
#line 373 "opensearch.vala"
					_tmp30_ = _matcher_list;
#line 373 "opensearch.vala"
					_tmp31_ = gee_collection_get_size ((GeeCollection*) _tmp30_);
#line 373 "opensearch.vala"
					_tmp32_ = _tmp31_;
#line 373 "opensearch.vala"
					_matcher_size = _tmp32_;
#line 373 "opensearch.vala"
					_matcher_index = -1;
#line 373 "opensearch.vala"
					while (TRUE) {
#line 1386 "opensearch.c"
						gint _tmp33_;
						gint _tmp34_;
						GeeMapEntry* matcher = NULL;
						GeeList* _tmp35_;
						gpointer _tmp36_;
						GeeMapEntry* _tmp37_;
						gconstpointer _tmp38_;
						gconstpointer _tmp39_;
						SynapseOpenSearchPluginSearchAction* _tmp40_;
						const gchar* _tmp41_;
						const gchar* _tmp42_;
#line 373 "opensearch.vala"
						_matcher_index = _matcher_index + 1;
#line 373 "opensearch.vala"
						_tmp33_ = _matcher_index;
#line 373 "opensearch.vala"
						_tmp34_ = _matcher_size;
#line 373 "opensearch.vala"
						if (!(_tmp33_ < _tmp34_)) {
#line 373 "opensearch.vala"
							break;
#line 1408 "opensearch.c"
						}
#line 373 "opensearch.vala"
						_tmp35_ = _matcher_list;
#line 373 "opensearch.vala"
						_tmp36_ = gee_list_get (_tmp35_, _matcher_index);
#line 373 "opensearch.vala"
						matcher = (GeeMapEntry*) _tmp36_;
#line 375 "opensearch.vala"
						_tmp37_ = matcher;
#line 375 "opensearch.vala"
						_tmp38_ = gee_map_entry_get_key (_tmp37_);
#line 375 "opensearch.vala"
						_tmp39_ = _tmp38_;
#line 375 "opensearch.vala"
						_tmp40_ = item;
#line 375 "opensearch.vala"
						_tmp41_ = synapse_match_get_title ((SynapseMatch*) _tmp40_);
#line 375 "opensearch.vala"
						_tmp42_ = _tmp41_;
#line 375 "opensearch.vala"
						if (g_regex_match ((GRegex*) _tmp39_, _tmp42_, 0, NULL)) {
#line 1430 "opensearch.c"
							SynapseResultSet* _tmp43_;
							SynapseOpenSearchPluginSearchAction* _tmp44_;
							GeeMapEntry* _tmp45_;
							gconstpointer _tmp46_;
							gconstpointer _tmp47_;
#line 377 "opensearch.vala"
							_tmp43_ = results;
#line 377 "opensearch.vala"
							_tmp44_ = item;
#line 377 "opensearch.vala"
							_tmp45_ = matcher;
#line 377 "opensearch.vala"
							_tmp46_ = gee_map_entry_get_value (_tmp45_);
#line 377 "opensearch.vala"
							_tmp47_ = _tmp46_;
#line 377 "opensearch.vala"
							synapse_result_set_add (_tmp43_, (SynapseMatch*) _tmp44_, (gint) ((gintptr) _tmp47_));
#line 378 "opensearch.vala"
							_g_object_unref0 (matcher);
#line 378 "opensearch.vala"
							break;
#line 1452 "opensearch.c"
						}
#line 373 "opensearch.vala"
						_g_object_unref0 (matcher);
#line 1456 "opensearch.c"
					}
				}
#line 371 "opensearch.vala"
				_g_object_unref0 (item);
#line 1461 "opensearch.c"
			}
		}
#line 360 "opensearch.vala"
		_g_object_unref0 (matchers);
#line 1466 "opensearch.c"
	}
#line 384 "opensearch.vala"
	result = results;
#line 384 "opensearch.vala"
	return result;
#line 1472 "opensearch.c"
}

SynapseOpenSearchPlugin*
synapse_open_search_plugin_construct (GType object_type)
{
	SynapseOpenSearchPlugin * self = NULL;
#line 61 "opensearch.vala"
	self = (SynapseOpenSearchPlugin*) g_object_new (object_type, NULL);
#line 61 "opensearch.vala"
	return self;
#line 1483 "opensearch.c"
}

SynapseOpenSearchPlugin*
synapse_open_search_plugin_new (void)
{
#line 61 "opensearch.vala"
	return synapse_open_search_plugin_construct (SYNAPSE_TYPE_OPEN_SEARCH_PLUGIN);
#line 1491 "opensearch.c"
}

static gboolean
synapse_open_search_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseOpenSearchPlugin* self;
#line 63 "opensearch.vala"
	self = (SynapseOpenSearchPlugin*) base;
#line 63 "opensearch.vala"
	result = self->priv->_enabled;
#line 63 "opensearch.vala"
	return result;
#line 1505 "opensearch.c"
}

static void
synapse_open_search_plugin_real_set_enabled (SynapseActivatable* base,
                                             gboolean value)
{
	SynapseOpenSearchPlugin* self;
	gboolean old_value;
#line 63 "opensearch.vala"
	self = (SynapseOpenSearchPlugin*) base;
#line 63 "opensearch.vala"
	old_value = synapse_open_search_plugin_real_get_enabled (base);
#line 63 "opensearch.vala"
	if (old_value != value) {
#line 63 "opensearch.vala"
		self->priv->_enabled = value;
#line 63 "opensearch.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_open_search_plugin_properties[SYNAPSE_OPEN_SEARCH_PLUGIN_ENABLED_PROPERTY]);
#line 1524 "opensearch.c"
	}
}

static inline gpointer
synapse_open_search_plugin_open_search_parser_get_instance_private (SynapseOpenSearchPluginOpenSearchParser* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseOpenSearchPluginOpenSearchParser_private_offset);
}

static void
_synapse_open_search_plugin_open_search_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                                                        const gchar* element_name,
                                                                                        gchar** attribute_names,
                                                                                        gchar** attribute_values,
                                                                                        gpointer self,
                                                                                        GError** error)
{
#line 77 "opensearch.vala"
	synapse_open_search_plugin_open_search_parser_start ((SynapseOpenSearchPluginOpenSearchParser*) self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
#line 1544 "opensearch.c"
}

static void
_synapse_open_search_plugin_open_search_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context,
                                                                                    const gchar* element_name,
                                                                                    gpointer self,
                                                                                    GError** error)
{
#line 77 "opensearch.vala"
	synapse_open_search_plugin_open_search_parser_end ((SynapseOpenSearchPluginOpenSearchParser*) self, context, element_name, error);
#line 1555 "opensearch.c"
}

static void
_synapse_open_search_plugin_open_search_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context,
                                                                              const gchar* text,
                                                                              gsize text_len,
                                                                              gpointer self,
                                                                              GError** error)
{
#line 77 "opensearch.vala"
	synapse_open_search_plugin_open_search_parser_text ((SynapseOpenSearchPluginOpenSearchParser*) self, context, text, text_len, error);
#line 1567 "opensearch.c"
}

static gboolean
synapse_open_search_plugin_open_search_parser_parse (SynapseOpenSearchPluginOpenSearchParser* self,
                                                     const gchar* content,
                                                     GError** error)
{
	gboolean _tmp0_ = FALSE;
	GMarkupParseContext* _tmp1_;
	GError* _inner_error0_ = NULL;
	gboolean result;
#line 101 "opensearch.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 101 "opensearch.vala"
	g_return_val_if_fail (content != NULL, FALSE);
#line 103 "opensearch.vala"
	_tmp1_ = self->priv->context;
#line 103 "opensearch.vala"
	_tmp0_ = g_markup_parse_context_parse (_tmp1_, content, (gssize) -1, &_inner_error0_);
#line 103 "opensearch.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 103 "opensearch.vala"
		if (_inner_error0_->domain == G_MARKUP_ERROR) {
#line 1591 "opensearch.c"
			gboolean _tmp2_ = FALSE;
#line 103 "opensearch.vala"
			g_propagate_error (error, _inner_error0_);
#line 103 "opensearch.vala"
			return _tmp2_;
#line 1597 "opensearch.c"
		} else {
			gboolean _tmp3_ = FALSE;
#line 103 "opensearch.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 103 "opensearch.vala"
			g_clear_error (&_inner_error0_);
#line 103 "opensearch.vala"
			return _tmp3_;
#line 1606 "opensearch.c"
		}
	}
#line 103 "opensearch.vala"
	result = _tmp0_;
#line 103 "opensearch.vala"
	return result;
#line 1613 "opensearch.c"
}

static gboolean
synapse_open_search_plugin_open_search_parser_has_valid_result (SynapseOpenSearchPluginOpenSearchParser* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
#line 106 "opensearch.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 108 "opensearch.vala"
	if (self->priv->is_opensearch) {
#line 108 "opensearch.vala"
		_tmp2_ = self->priv->has_name;
#line 1629 "opensearch.c"
	} else {
#line 108 "opensearch.vala"
		_tmp2_ = FALSE;
#line 1633 "opensearch.c"
	}
#line 108 "opensearch.vala"
	if (_tmp2_) {
#line 108 "opensearch.vala"
		_tmp1_ = self->priv->has_desc;
#line 1639 "opensearch.c"
	} else {
#line 108 "opensearch.vala"
		_tmp1_ = FALSE;
#line 1643 "opensearch.c"
	}
#line 108 "opensearch.vala"
	if (_tmp1_) {
#line 108 "opensearch.vala"
		_tmp0_ = self->priv->has_url;
#line 1649 "opensearch.c"
	} else {
#line 108 "opensearch.vala"
		_tmp0_ = FALSE;
#line 1653 "opensearch.c"
	}
#line 108 "opensearch.vala"
	result = _tmp0_;
#line 108 "opensearch.vala"
	return result;
#line 1659 "opensearch.c"
}

static void
synapse_open_search_plugin_open_search_parser_process_url (SynapseOpenSearchPluginOpenSearchParser* self,
                                                           gchar** attrs,
                                                           gint attrs_length1,
                                                           gchar** vals,
                                                           gint vals_length1)
{
	guint len = 0U;
	gboolean main_type = FALSE;
	gboolean suggestion_type = FALSE;
#line 111 "opensearch.vala"
	g_return_if_fail (self != NULL);
#line 113 "opensearch.vala"
	len = g_strv_length (attrs);
#line 114 "opensearch.vala"
	main_type = FALSE;
#line 115 "opensearch.vala"
	suggestion_type = FALSE;
#line 1680 "opensearch.c"
	{
		guint i = 0U;
#line 117 "opensearch.vala"
		i = (guint) 0;
#line 1685 "opensearch.c"
		{
			gboolean _tmp0_ = FALSE;
#line 117 "opensearch.vala"
			_tmp0_ = TRUE;
#line 117 "opensearch.vala"
			while (TRUE) {
#line 1692 "opensearch.c"
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				GQuark _tmp5_ = 0U;
#line 119 "opensearch.vala"
				static GQuark _tmp4_label0 = 0;
#line 119 "opensearch.vala"
				static GQuark _tmp4_label1 = 0;
#line 117 "opensearch.vala"
				if (!_tmp0_) {
#line 1702 "opensearch.c"
					guint _tmp1_;
#line 117 "opensearch.vala"
					_tmp1_ = i;
#line 117 "opensearch.vala"
					i = _tmp1_ + 1;
#line 1708 "opensearch.c"
				}
#line 117 "opensearch.vala"
				_tmp0_ = FALSE;
#line 117 "opensearch.vala"
				if (!(i < len)) {
#line 117 "opensearch.vala"
					break;
#line 1716 "opensearch.c"
				}
#line 119 "opensearch.vala"
				_tmp2_ = attrs[i];
#line 119 "opensearch.vala"
				_tmp3_ = _tmp2_;
#line 119 "opensearch.vala"
				_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
#line 119 "opensearch.vala"
				if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("type")))) {
#line 119 "opensearch.vala"
					switch (0) {
#line 1728 "opensearch.c"
						default:
						{
							const gchar* _tmp6_;
#line 122 "opensearch.vala"
							_tmp6_ = vals[i];
#line 122 "opensearch.vala"
							if (g_strcmp0 (_tmp6_, "text/html") == 0) {
#line 122 "opensearch.vala"
								main_type = TRUE;
#line 1738 "opensearch.c"
							} else {
								const gchar* _tmp7_;
#line 123 "opensearch.vala"
								_tmp7_ = vals[i];
#line 123 "opensearch.vala"
								if (g_strcmp0 (_tmp7_, "application/x-suggestions+json") == 0) {
#line 123 "opensearch.vala"
									suggestion_type = TRUE;
#line 1747 "opensearch.c"
								}
							}
#line 124 "opensearch.vala"
							break;
#line 1752 "opensearch.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("template")))) {
#line 119 "opensearch.vala"
					switch (0) {
#line 1758 "opensearch.c"
						default:
						{
#line 126 "opensearch.vala"
							if (main_type) {
#line 1763 "opensearch.c"
								const gchar* _tmp8_;
#line 128 "opensearch.vala"
								_tmp8_ = vals[i];
#line 128 "opensearch.vala"
								synapse_open_search_plugin_open_search_parser_set_query_url (self, _tmp8_);
#line 129 "opensearch.vala"
								self->priv->has_url = TRUE;
#line 1771 "opensearch.c"
							} else {
#line 131 "opensearch.vala"
								if (suggestion_type) {
#line 1775 "opensearch.c"
									const gchar* _tmp9_;
#line 131 "opensearch.vala"
									_tmp9_ = vals[i];
#line 131 "opensearch.vala"
									synapse_open_search_plugin_open_search_parser_set_suggestion_url (self, _tmp9_);
#line 1781 "opensearch.c"
								}
							}
#line 132 "opensearch.vala"
							break;
#line 1786 "opensearch.c"
						}
					}
				} else {
#line 119 "opensearch.vala"
					switch (0) {
#line 1792 "opensearch.c"
						default:
						{
#line 133 "opensearch.vala"
							break;
#line 1797 "opensearch.c"
						}
					}
				}
			}
		}
	}
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
#line 144 "opensearch.vala"
	for (i = 0; i < stack_length; i++) {
#line 144 "opensearch.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 144 "opensearch.vala"
			return TRUE;
#line 1818 "opensearch.c"
		}
	}
#line 144 "opensearch.vala"
	return FALSE;
#line 1823 "opensearch.c"
}

static void
synapse_open_search_plugin_open_search_parser_start (SynapseOpenSearchPluginOpenSearchParser* self,
                                                     GMarkupParseContext* ctx,
                                                     const gchar* name,
                                                     gchar** attr_names,
                                                     gint attr_names_length1,
                                                     gchar** attr_vals,
                                                     gint attr_vals_length1,
                                                     GError** error)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
#line 141 "opensearch.vala"
	static GQuark _tmp1_label0 = 0;
#line 141 "opensearch.vala"
	static GQuark _tmp1_label1 = 0;
#line 141 "opensearch.vala"
	static GQuark _tmp1_label2 = 0;
#line 141 "opensearch.vala"
	static GQuark _tmp1_label3 = 0;
#line 141 "opensearch.vala"
	static GQuark _tmp1_label4 = 0;
#line 141 "opensearch.vala"
	static GQuark _tmp1_label5 = 0;
#line 141 "opensearch.vala"
	static GQuark _tmp1_label6 = 0;
#line 141 "opensearch.vala"
	static GQuark _tmp1_label7 = 0;
#line 138 "opensearch.vala"
	g_return_if_fail (self != NULL);
#line 138 "opensearch.vala"
	g_return_if_fail (ctx != NULL);
#line 138 "opensearch.vala"
	g_return_if_fail (name != NULL);
#line 141 "opensearch.vala"
	_tmp0_ = name;
#line 141 "opensearch.vala"
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
#line 141 "opensearch.vala"
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("SearchPlugin")))) {
#line 141 "opensearch.vala"
		switch (0) {
#line 1868 "opensearch.c"
			default:
			{
#line 144 "opensearch.vala"
				if (_vala_string_array_contains (attr_names, attr_names_length1, "xmlns:os")) {
#line 145 "opensearch.vala"
					self->priv->is_opensearch = TRUE;
#line 1875 "opensearch.c"
				}
#line 146 "opensearch.vala"
				break;
#line 1879 "opensearch.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("OpenSearchDescription")))) {
#line 141 "opensearch.vala"
		switch (0) {
#line 1885 "opensearch.c"
			default:
			{
#line 147 "opensearch.vala"
				self->priv->is_opensearch = TRUE;
#line 147 "opensearch.vala"
				break;
#line 1892 "opensearch.c"
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("os:ShortName")))) || (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("ShortName"))))) {
#line 141 "opensearch.vala"
		switch (0) {
#line 1898 "opensearch.c"
			default:
			{
#line 149 "opensearch.vala"
				self->priv->has_name = TRUE;
#line 149 "opensearch.vala"
				self->priv->in_name_elem = TRUE;
#line 149 "opensearch.vala"
				break;
#line 1907 "opensearch.c"
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("os:Description")))) || (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("Description"))))) {
#line 141 "opensearch.vala"
		switch (0) {
#line 1913 "opensearch.c"
			default:
			{
#line 151 "opensearch.vala"
				self->priv->has_desc = TRUE;
#line 151 "opensearch.vala"
				self->priv->in_description_elem = TRUE;
#line 151 "opensearch.vala"
				break;
#line 1922 "opensearch.c"
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("os:Url")))) || (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("Url"))))) {
#line 141 "opensearch.vala"
		switch (0) {
#line 1928 "opensearch.c"
			default:
			{
#line 153 "opensearch.vala"
				synapse_open_search_plugin_open_search_parser_process_url (self, attr_names, (gint) attr_names_length1, attr_vals, (gint) attr_vals_length1);
#line 153 "opensearch.vala"
				break;
#line 1935 "opensearch.c"
			}
		}
	} else {
#line 141 "opensearch.vala"
		switch (0) {
#line 1941 "opensearch.c"
			default:
			{
#line 154 "opensearch.vala"
				break;
#line 1946 "opensearch.c"
			}
		}
	}
}

static void
synapse_open_search_plugin_open_search_parser_end (SynapseOpenSearchPluginOpenSearchParser* self,
                                                   GMarkupParseContext* ctx,
                                                   const gchar* name,
                                                   GError** error)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
#line 160 "opensearch.vala"
	static GQuark _tmp1_label0 = 0;
#line 160 "opensearch.vala"
	static GQuark _tmp1_label1 = 0;
#line 160 "opensearch.vala"
	static GQuark _tmp1_label2 = 0;
#line 160 "opensearch.vala"
	static GQuark _tmp1_label3 = 0;
#line 158 "opensearch.vala"
	g_return_if_fail (self != NULL);
#line 158 "opensearch.vala"
	g_return_if_fail (ctx != NULL);
#line 158 "opensearch.vala"
	g_return_if_fail (name != NULL);
#line 160 "opensearch.vala"
	_tmp0_ = name;
#line 160 "opensearch.vala"
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
#line 160 "opensearch.vala"
	if ((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("os:ShortName")))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("ShortName"))))) {
#line 160 "opensearch.vala"
		switch (0) {
#line 1982 "opensearch.c"
			default:
			{
#line 163 "opensearch.vala"
				self->priv->in_name_elem = FALSE;
#line 163 "opensearch.vala"
				break;
#line 1989 "opensearch.c"
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("os:Description")))) || (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("Description"))))) {
#line 160 "opensearch.vala"
		switch (0) {
#line 1995 "opensearch.c"
			default:
			{
#line 165 "opensearch.vala"
				self->priv->in_description_elem = FALSE;
#line 165 "opensearch.vala"
				break;
#line 2002 "opensearch.c"
			}
		}
	} else {
#line 160 "opensearch.vala"
		switch (0) {
#line 2008 "opensearch.c"
			default:
			{
#line 166 "opensearch.vala"
				break;
#line 2013 "opensearch.c"
			}
		}
	}
}

static void
synapse_open_search_plugin_open_search_parser_text (SynapseOpenSearchPluginOpenSearchParser* self,
                                                    GMarkupParseContext* ctx,
                                                    const gchar* text,
                                                    gsize text_len,
                                                    GError** error)
{
#line 170 "opensearch.vala"
	g_return_if_fail (self != NULL);
#line 170 "opensearch.vala"
	g_return_if_fail (ctx != NULL);
#line 170 "opensearch.vala"
	g_return_if_fail (text != NULL);
#line 172 "opensearch.vala"
	if (self->priv->in_name_elem) {
#line 172 "opensearch.vala"
		synapse_open_search_plugin_open_search_parser_set_short_name (self, text);
#line 2036 "opensearch.c"
	} else {
#line 173 "opensearch.vala"
		if (self->priv->in_description_elem) {
#line 173 "opensearch.vala"
			synapse_open_search_plugin_open_search_parser_set_description (self, text);
#line 2042 "opensearch.c"
		}
	}
}

static SynapseOpenSearchPluginOpenSearchParser*
synapse_open_search_plugin_open_search_parser_construct (GType object_type)
{
	SynapseOpenSearchPluginOpenSearchParser * self = NULL;
#line 75 "opensearch.vala"
	self = (SynapseOpenSearchPluginOpenSearchParser*) g_object_new (object_type, NULL);
#line 75 "opensearch.vala"
	return self;
#line 2055 "opensearch.c"
}

static SynapseOpenSearchPluginOpenSearchParser*
synapse_open_search_plugin_open_search_parser_new (void)
{
#line 75 "opensearch.vala"
	return synapse_open_search_plugin_open_search_parser_construct (SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_OPEN_SEARCH_PARSER);
#line 2063 "opensearch.c"
}

static const gchar*
synapse_open_search_plugin_open_search_parser_get_short_name (SynapseOpenSearchPluginOpenSearchParser* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 91 "opensearch.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 91 "opensearch.vala"
	_tmp0_ = self->priv->_short_name;
#line 91 "opensearch.vala"
	result = _tmp0_;
#line 91 "opensearch.vala"
	return result;
#line 2079 "opensearch.c"
}

static void
synapse_open_search_plugin_open_search_parser_set_short_name (SynapseOpenSearchPluginOpenSearchParser* self,
                                                              const gchar* value)
{
	gchar* old_value;
#line 91 "opensearch.vala"
	g_return_if_fail (self != NULL);
#line 91 "opensearch.vala"
	old_value = synapse_open_search_plugin_open_search_parser_get_short_name (self);
#line 91 "opensearch.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2093 "opensearch.c"
		gchar* _tmp0_;
#line 91 "opensearch.vala"
		_tmp0_ = g_strdup (value);
#line 91 "opensearch.vala"
		_g_free0 (self->priv->_short_name);
#line 91 "opensearch.vala"
		self->priv->_short_name = _tmp0_;
#line 91 "opensearch.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_open_search_plugin_open_search_parser_properties[SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_SHORT_NAME_PROPERTY]);
#line 2103 "opensearch.c"
	}
}

static const gchar*
synapse_open_search_plugin_open_search_parser_get_description (SynapseOpenSearchPluginOpenSearchParser* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 92 "opensearch.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 92 "opensearch.vala"
	_tmp0_ = self->priv->_description;
#line 92 "opensearch.vala"
	result = _tmp0_;
#line 92 "opensearch.vala"
	return result;
#line 2120 "opensearch.c"
}

static void
synapse_open_search_plugin_open_search_parser_set_description (SynapseOpenSearchPluginOpenSearchParser* self,
                                                               const gchar* value)
{
	gchar* old_value;
#line 92 "opensearch.vala"
	g_return_if_fail (self != NULL);
#line 92 "opensearch.vala"
	old_value = synapse_open_search_plugin_open_search_parser_get_description (self);
#line 92 "opensearch.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2134 "opensearch.c"
		gchar* _tmp0_;
#line 92 "opensearch.vala"
		_tmp0_ = g_strdup (value);
#line 92 "opensearch.vala"
		_g_free0 (self->priv->_description);
#line 92 "opensearch.vala"
		self->priv->_description = _tmp0_;
#line 92 "opensearch.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_open_search_plugin_open_search_parser_properties[SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_DESCRIPTION_PROPERTY]);
#line 2144 "opensearch.c"
	}
}

static const gchar*
synapse_open_search_plugin_open_search_parser_get_query_url (SynapseOpenSearchPluginOpenSearchParser* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 93 "opensearch.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 93 "opensearch.vala"
	_tmp0_ = self->priv->_query_url;
#line 93 "opensearch.vala"
	result = _tmp0_;
#line 93 "opensearch.vala"
	return result;
#line 2161 "opensearch.c"
}

static void
synapse_open_search_plugin_open_search_parser_set_query_url (SynapseOpenSearchPluginOpenSearchParser* self,
                                                             const gchar* value)
{
	gchar* old_value;
#line 93 "opensearch.vala"
	g_return_if_fail (self != NULL);
#line 93 "opensearch.vala"
	old_value = synapse_open_search_plugin_open_search_parser_get_query_url (self);
#line 93 "opensearch.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2175 "opensearch.c"
		gchar* _tmp0_;
#line 93 "opensearch.vala"
		_tmp0_ = g_strdup (value);
#line 93 "opensearch.vala"
		_g_free0 (self->priv->_query_url);
#line 93 "opensearch.vala"
		self->priv->_query_url = _tmp0_;
#line 93 "opensearch.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_open_search_plugin_open_search_parser_properties[SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_QUERY_URL_PROPERTY]);
#line 2185 "opensearch.c"
	}
}

static const gchar*
synapse_open_search_plugin_open_search_parser_get_suggestion_url (SynapseOpenSearchPluginOpenSearchParser* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 94 "opensearch.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 94 "opensearch.vala"
	_tmp0_ = self->priv->_suggestion_url;
#line 94 "opensearch.vala"
	result = _tmp0_;
#line 94 "opensearch.vala"
	return result;
#line 2202 "opensearch.c"
}

static void
synapse_open_search_plugin_open_search_parser_set_suggestion_url (SynapseOpenSearchPluginOpenSearchParser* self,
                                                                  const gchar* value)
{
	gchar* old_value;
#line 94 "opensearch.vala"
	g_return_if_fail (self != NULL);
#line 94 "opensearch.vala"
	old_value = synapse_open_search_plugin_open_search_parser_get_suggestion_url (self);
#line 94 "opensearch.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2216 "opensearch.c"
		gchar* _tmp0_;
#line 94 "opensearch.vala"
		_tmp0_ = g_strdup (value);
#line 94 "opensearch.vala"
		_g_free0 (self->priv->_suggestion_url);
#line 94 "opensearch.vala"
		self->priv->_suggestion_url = _tmp0_;
#line 94 "opensearch.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_open_search_plugin_open_search_parser_properties[SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_SUGGESTION_URL_PROPERTY]);
#line 2226 "opensearch.c"
	}
}

static GObject *
synapse_open_search_plugin_open_search_parser_constructor (GType type,
                                                           guint n_construct_properties,
                                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseOpenSearchPluginOpenSearchParser * self;
	GMarkupParseContext* _tmp0_;
#line 96 "opensearch.vala"
	parent_class = G_OBJECT_CLASS (synapse_open_search_plugin_open_search_parser_parent_class);
#line 96 "opensearch.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 96 "opensearch.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_OPEN_SEARCH_PARSER, SynapseOpenSearchPluginOpenSearchParser);
#line 98 "opensearch.vala"
	_tmp0_ = g_markup_parse_context_new (&SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_parser, 0, self, NULL);
#line 98 "opensearch.vala"
	_g_markup_parse_context_unref0 (self->priv->context);
#line 98 "opensearch.vala"
	self->priv->context = _tmp0_;
#line 96 "opensearch.vala"
	return obj;
#line 2253 "opensearch.c"
}

static void
synapse_open_search_plugin_open_search_parser_class_init (SynapseOpenSearchPluginOpenSearchParserClass * klass,
                                                          gpointer klass_data)
{
#line 75 "opensearch.vala"
	synapse_open_search_plugin_open_search_parser_parent_class = g_type_class_peek_parent (klass);
#line 75 "opensearch.vala"
	g_type_class_adjust_private_offset (klass, &SynapseOpenSearchPluginOpenSearchParser_private_offset);
#line 75 "opensearch.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_open_search_plugin_open_search_parser_get_property;
#line 75 "opensearch.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_open_search_plugin_open_search_parser_set_property;
#line 75 "opensearch.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_open_search_plugin_open_search_parser_constructor;
#line 75 "opensearch.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_open_search_plugin_open_search_parser_finalize;
#line 75 "opensearch.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_SHORT_NAME_PROPERTY, synapse_open_search_plugin_open_search_parser_properties[SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_SHORT_NAME_PROPERTY] = g_param_spec_string ("short-name", "short-name", "short-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 75 "opensearch.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_DESCRIPTION_PROPERTY, synapse_open_search_plugin_open_search_parser_properties[SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 75 "opensearch.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_QUERY_URL_PROPERTY, synapse_open_search_plugin_open_search_parser_properties[SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_QUERY_URL_PROPERTY] = g_param_spec_string ("query-url", "query-url", "query-url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 75 "opensearch.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_SUGGESTION_URL_PROPERTY, synapse_open_search_plugin_open_search_parser_properties[SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_SUGGESTION_URL_PROPERTY] = g_param_spec_string ("suggestion-url", "suggestion-url", "suggestion-url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2280 "opensearch.c"
}

static void
synapse_open_search_plugin_open_search_parser_instance_init (SynapseOpenSearchPluginOpenSearchParser * self,
                                                             gpointer klass)
{
#line 75 "opensearch.vala"
	self->priv = synapse_open_search_plugin_open_search_parser_get_instance_private (self);
#line 83 "opensearch.vala"
	self->priv->is_opensearch = FALSE;
#line 84 "opensearch.vala"
	self->priv->in_name_elem = FALSE;
#line 85 "opensearch.vala"
	self->priv->in_description_elem = FALSE;
#line 87 "opensearch.vala"
	self->priv->has_name = FALSE;
#line 88 "opensearch.vala"
	self->priv->has_desc = FALSE;
#line 89 "opensearch.vala"
	self->priv->has_url = FALSE;
#line 2301 "opensearch.c"
}

static void
synapse_open_search_plugin_open_search_parser_finalize (GObject * obj)
{
	SynapseOpenSearchPluginOpenSearchParser * self;
#line 75 "opensearch.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_OPEN_SEARCH_PARSER, SynapseOpenSearchPluginOpenSearchParser);
#line 82 "opensearch.vala"
	_g_markup_parse_context_unref0 (self->priv->context);
#line 91 "opensearch.vala"
	_g_free0 (self->priv->_short_name);
#line 92 "opensearch.vala"
	_g_free0 (self->priv->_description);
#line 93 "opensearch.vala"
	_g_free0 (self->priv->_query_url);
#line 94 "opensearch.vala"
	_g_free0 (self->priv->_suggestion_url);
#line 75 "opensearch.vala"
	G_OBJECT_CLASS (synapse_open_search_plugin_open_search_parser_parent_class)->finalize (obj);
#line 2322 "opensearch.c"
}

static GType
synapse_open_search_plugin_open_search_parser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseOpenSearchPluginOpenSearchParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_open_search_plugin_open_search_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseOpenSearchPluginOpenSearchParser), 0, (GInstanceInitFunc) synapse_open_search_plugin_open_search_parser_instance_init, NULL };
	GType synapse_open_search_plugin_open_search_parser_type_id;
	synapse_open_search_plugin_open_search_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseOpenSearchPluginOpenSearchParser", &g_define_type_info, 0);
	SynapseOpenSearchPluginOpenSearchParser_private_offset = g_type_add_instance_private (synapse_open_search_plugin_open_search_parser_type_id, sizeof (SynapseOpenSearchPluginOpenSearchParserPrivate));
	return synapse_open_search_plugin_open_search_parser_type_id;
}

static GType
synapse_open_search_plugin_open_search_parser_get_type (void)
{
	static volatile gsize synapse_open_search_plugin_open_search_parser_type_id__once = 0;
	if (g_once_init_enter (&synapse_open_search_plugin_open_search_parser_type_id__once)) {
		GType synapse_open_search_plugin_open_search_parser_type_id;
		synapse_open_search_plugin_open_search_parser_type_id = synapse_open_search_plugin_open_search_parser_get_type_once ();
		g_once_init_leave (&synapse_open_search_plugin_open_search_parser_type_id__once, synapse_open_search_plugin_open_search_parser_type_id);
	}
	return synapse_open_search_plugin_open_search_parser_type_id__once;
}

static void
_vala_synapse_open_search_plugin_open_search_parser_get_property (GObject * object,
                                                                  guint property_id,
                                                                  GValue * value,
                                                                  GParamSpec * pspec)
{
	SynapseOpenSearchPluginOpenSearchParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_OPEN_SEARCH_PARSER, SynapseOpenSearchPluginOpenSearchParser);
#line 75 "opensearch.vala"
	switch (property_id) {
#line 75 "opensearch.vala"
		case SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_SHORT_NAME_PROPERTY:
#line 75 "opensearch.vala"
		g_value_set_string (value, synapse_open_search_plugin_open_search_parser_get_short_name (self));
#line 75 "opensearch.vala"
		break;
#line 75 "opensearch.vala"
		case SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_DESCRIPTION_PROPERTY:
#line 75 "opensearch.vala"
		g_value_set_string (value, synapse_open_search_plugin_open_search_parser_get_description (self));
#line 75 "opensearch.vala"
		break;
#line 75 "opensearch.vala"
		case SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_QUERY_URL_PROPERTY:
#line 75 "opensearch.vala"
		g_value_set_string (value, synapse_open_search_plugin_open_search_parser_get_query_url (self));
#line 75 "opensearch.vala"
		break;
#line 75 "opensearch.vala"
		case SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_SUGGESTION_URL_PROPERTY:
#line 75 "opensearch.vala"
		g_value_set_string (value, synapse_open_search_plugin_open_search_parser_get_suggestion_url (self));
#line 75 "opensearch.vala"
		break;
#line 2381 "opensearch.c"
		default:
#line 75 "opensearch.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 75 "opensearch.vala"
		break;
#line 2387 "opensearch.c"
	}
}

static void
_vala_synapse_open_search_plugin_open_search_parser_set_property (GObject * object,
                                                                  guint property_id,
                                                                  const GValue * value,
                                                                  GParamSpec * pspec)
{
	SynapseOpenSearchPluginOpenSearchParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_OPEN_SEARCH_PARSER, SynapseOpenSearchPluginOpenSearchParser);
#line 75 "opensearch.vala"
	switch (property_id) {
#line 75 "opensearch.vala"
		case SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_SHORT_NAME_PROPERTY:
#line 75 "opensearch.vala"
		synapse_open_search_plugin_open_search_parser_set_short_name (self, g_value_get_string (value));
#line 75 "opensearch.vala"
		break;
#line 75 "opensearch.vala"
		case SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_DESCRIPTION_PROPERTY:
#line 75 "opensearch.vala"
		synapse_open_search_plugin_open_search_parser_set_description (self, g_value_get_string (value));
#line 75 "opensearch.vala"
		break;
#line 75 "opensearch.vala"
		case SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_QUERY_URL_PROPERTY:
#line 75 "opensearch.vala"
		synapse_open_search_plugin_open_search_parser_set_query_url (self, g_value_get_string (value));
#line 75 "opensearch.vala"
		break;
#line 75 "opensearch.vala"
		case SYNAPSE_OPEN_SEARCH_PLUGIN_OPEN_SEARCH_PARSER_SUGGESTION_URL_PROPERTY:
#line 75 "opensearch.vala"
		synapse_open_search_plugin_open_search_parser_set_suggestion_url (self, g_value_get_string (value));
#line 75 "opensearch.vala"
		break;
#line 2425 "opensearch.c"
		default:
#line 75 "opensearch.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 75 "opensearch.vala"
		break;
#line 2431 "opensearch.c"
	}
}

static inline gpointer
synapse_open_search_plugin_search_action_get_instance_private (SynapseOpenSearchPluginSearchAction* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseOpenSearchPluginSearchAction_private_offset);
}

static void
synapse_open_search_plugin_search_action_real_execute (SynapseMatch* base,
                                                       SynapseMatch* match)
{
	SynapseOpenSearchPluginSearchAction * self;
	GError* _inner_error0_ = NULL;
#line 182 "opensearch.vala"
	self = (SynapseOpenSearchPluginSearchAction*) base;
#line 182 "opensearch.vala"
	g_return_if_fail (match != NULL);
#line 2451 "opensearch.c"
	{
		gchar* _tmp0_ = NULL;
		gchar* what = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
#line 186 "opensearch.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_TEXT_MATCH)) {
#line 2460 "opensearch.c"
			gchar* _tmp1_;
#line 187 "opensearch.vala"
			_tmp1_ = synapse_text_match_get_text (G_TYPE_CHECK_INSTANCE_CAST (match, SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatch));
#line 187 "opensearch.vala"
			_g_free0 (_tmp0_);
#line 187 "opensearch.vala"
			_tmp0_ = _tmp1_;
#line 2468 "opensearch.c"
		} else {
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			gchar* _tmp4_;
#line 187 "opensearch.vala"
			_tmp2_ = synapse_match_get_title (match);
#line 187 "opensearch.vala"
			_tmp3_ = _tmp2_;
#line 187 "opensearch.vala"
			_tmp4_ = g_strdup (_tmp3_);
#line 187 "opensearch.vala"
			_g_free0 (_tmp0_);
#line 187 "opensearch.vala"
			_tmp0_ = _tmp4_;
#line 2483 "opensearch.c"
		}
#line 186 "opensearch.vala"
		_tmp5_ = g_strdup (_tmp0_);
#line 186 "opensearch.vala"
		what = _tmp5_;
#line 188 "opensearch.vala"
		_tmp6_ = synapse_open_search_plugin_search_action_get_query_url (self, what);
#line 188 "opensearch.vala"
		_tmp7_ = _tmp6_;
#line 188 "opensearch.vala"
		g_app_info_launch_default_for_uri (_tmp7_, NULL, &_inner_error0_);
#line 188 "opensearch.vala"
		_g_free0 (_tmp7_);
#line 188 "opensearch.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 188 "opensearch.vala"
			_g_free0 (what);
#line 188 "opensearch.vala"
			_g_free0 (_tmp0_);
#line 2503 "opensearch.c"
			goto __catch0_g_error;
		}
#line 184 "opensearch.vala"
		_g_free0 (what);
#line 184 "opensearch.vala"
		_g_free0 (_tmp0_);
#line 2510 "opensearch.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
#line 184 "opensearch.vala"
		err = _inner_error0_;
#line 184 "opensearch.vala"
		_inner_error0_ = NULL;
#line 192 "opensearch.vala"
		_tmp8_ = err;
#line 192 "opensearch.vala"
		_tmp9_ = _tmp8_->message;
#line 192 "opensearch.vala"
		g_warning ("opensearch.vala:192: %s", _tmp9_);
#line 184 "opensearch.vala"
		_g_error_free0 (err);
#line 2530 "opensearch.c"
	}
	__finally0:
#line 184 "opensearch.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 184 "opensearch.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 184 "opensearch.vala"
		g_clear_error (&_inner_error0_);
#line 184 "opensearch.vala"
		return;
#line 2541 "opensearch.c"
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 2564 "opensearch.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 2568 "opensearch.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 2574 "opensearch.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 2578 "opensearch.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 2582 "opensearch.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 2590 "opensearch.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 2618 "opensearch.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 2627 "opensearch.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 2641 "opensearch.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 2650 "opensearch.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 2664 "opensearch.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 2673 "opensearch.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 2682 "opensearch.c"
}

static gchar*
synapse_open_search_plugin_search_action_get_query_url (SynapseOpenSearchPluginSearchAction* self,
                                                        const gchar* query)
{
	gchar* _result_ = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
#line 196 "opensearch.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 196 "opensearch.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 199 "opensearch.vala"
	_tmp0_ = self->priv->_query_template;
#line 199 "opensearch.vala"
	_tmp1_ = g_uri_escape_string (query, "", FALSE);
#line 199 "opensearch.vala"
	_tmp2_ = _tmp1_;
#line 199 "opensearch.vala"
	_tmp3_ = string_replace (_tmp0_, "{searchTerms}", _tmp2_);
#line 199 "opensearch.vala"
	_g_free0 (_result_);
#line 199 "opensearch.vala"
	_result_ = _tmp3_;
#line 199 "opensearch.vala"
	_g_free0 (_tmp2_);
#line 201 "opensearch.vala"
	_tmp4_ = _result_;
#line 201 "opensearch.vala"
	_tmp5_ = synapse_open_search_plugin_search_action_get_lang (self);
#line 201 "opensearch.vala"
	_tmp6_ = _tmp5_;
#line 201 "opensearch.vala"
	_tmp7_ = string_replace (_tmp4_, "{language}", _tmp6_);
#line 201 "opensearch.vala"
	_g_free0 (_result_);
#line 201 "opensearch.vala"
	_result_ = _tmp7_;
#line 201 "opensearch.vala"
	_g_free0 (_tmp6_);
#line 204 "opensearch.vala"
	result = _result_;
#line 204 "opensearch.vala"
	return result;
#line 2735 "opensearch.c"
}

static gchar*
synapse_open_search_plugin_search_action_get_lang (SynapseOpenSearchPluginSearchAction* self)
{
	gchar* _result_ = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
#line 207 "opensearch.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 209 "opensearch.vala"
	_result_ = NULL;
#line 210 "opensearch.vala"
	_tmp1_ = _tmp0_ = g_get_language_names ();
#line 2754 "opensearch.c"
	{
		gchar** lang_collection = NULL;
		gint lang_collection_length1 = 0;
		gint _lang_collection_size_ = 0;
		gint lang_it = 0;
#line 210 "opensearch.vala"
		lang_collection = _tmp1_;
#line 210 "opensearch.vala"
		lang_collection_length1 = _vala_array_length (_tmp0_);
#line 210 "opensearch.vala"
		for (lang_it = 0; lang_it < lang_collection_length1; lang_it = lang_it + 1) {
#line 2766 "opensearch.c"
			const gchar* lang = NULL;
#line 210 "opensearch.vala"
			lang = lang_collection[lang_it];
#line 2770 "opensearch.c"
			{
				const gchar* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
#line 212 "opensearch.vala"
				_tmp2_ = lang;
#line 212 "opensearch.vala"
				_tmp3_ = strlen (_tmp2_);
#line 212 "opensearch.vala"
				_tmp4_ = _tmp3_;
#line 212 "opensearch.vala"
				if (_tmp4_ == 2) {
#line 2783 "opensearch.c"
					const gchar* _tmp5_;
					gchar* _tmp6_;
#line 214 "opensearch.vala"
					_tmp5_ = lang;
#line 214 "opensearch.vala"
					_tmp6_ = g_strdup (_tmp5_);
#line 214 "opensearch.vala"
					_g_free0 (_result_);
#line 214 "opensearch.vala"
					_result_ = _tmp6_;
#line 215 "opensearch.vala"
					break;
#line 2796 "opensearch.c"
				}
			}
		}
	}
#line 219 "opensearch.vala"
	_tmp8_ = _result_;
#line 219 "opensearch.vala"
	_tmp7_ = _tmp8_;
#line 219 "opensearch.vala"
	if (_tmp7_ == NULL) {
#line 219 "opensearch.vala"
		_tmp7_ = "en";
#line 2809 "opensearch.c"
	}
#line 219 "opensearch.vala"
	_tmp9_ = g_strdup (_tmp7_);
#line 219 "opensearch.vala"
	result = _tmp9_;
#line 219 "opensearch.vala"
	_g_free0 (_result_);
#line 219 "opensearch.vala"
	return result;
#line 2819 "opensearch.c"
}

static SynapseOpenSearchPluginSearchAction*
synapse_open_search_plugin_search_action_construct (GType object_type,
                                                    const gchar* name,
                                                    const gchar* description,
                                                    const gchar* url)
{
	SynapseOpenSearchPluginSearchAction * self = NULL;
#line 222 "opensearch.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 222 "opensearch.vala"
	g_return_val_if_fail (description != NULL, NULL);
#line 222 "opensearch.vala"
	g_return_val_if_fail (url != NULL, NULL);
#line 224 "opensearch.vala"
	self = (SynapseOpenSearchPluginSearchAction*) g_object_new (object_type, "title", name, "description", description, "query-template", url, "has-thumbnail", FALSE, "icon-name", "applications-internet", NULL);
#line 222 "opensearch.vala"
	return self;
#line 2839 "opensearch.c"
}

static SynapseOpenSearchPluginSearchAction*
synapse_open_search_plugin_search_action_new (const gchar* name,
                                              const gchar* description,
                                              const gchar* url)
{
#line 222 "opensearch.vala"
	return synapse_open_search_plugin_search_action_construct (SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_SEARCH_ACTION, name, description, url);
#line 2849 "opensearch.c"
}

static gint
synapse_open_search_plugin_search_action_get_default_relevancy (SynapseOpenSearchPluginSearchAction* self)
{
	gint result;
#line 179 "opensearch.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 179 "opensearch.vala"
	result = self->priv->_default_relevancy;
#line 179 "opensearch.vala"
	return result;
#line 2862 "opensearch.c"
}

static void
synapse_open_search_plugin_search_action_set_default_relevancy (SynapseOpenSearchPluginSearchAction* self,
                                                                gint value)
{
	gint old_value;
#line 179 "opensearch.vala"
	g_return_if_fail (self != NULL);
#line 179 "opensearch.vala"
	old_value = synapse_open_search_plugin_search_action_get_default_relevancy (self);
#line 179 "opensearch.vala"
	if (old_value != value) {
#line 179 "opensearch.vala"
		self->priv->_default_relevancy = value;
#line 179 "opensearch.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_open_search_plugin_search_action_properties[SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_DEFAULT_RELEVANCY_PROPERTY]);
#line 2880 "opensearch.c"
	}
}

static const gchar*
synapse_open_search_plugin_search_action_get_query_template (SynapseOpenSearchPluginSearchAction* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 180 "opensearch.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 180 "opensearch.vala"
	_tmp0_ = self->priv->_query_template;
#line 180 "opensearch.vala"
	result = _tmp0_;
#line 180 "opensearch.vala"
	return result;
#line 2897 "opensearch.c"
}

static void
synapse_open_search_plugin_search_action_set_query_template (SynapseOpenSearchPluginSearchAction* self,
                                                             const gchar* value)
{
	gchar* old_value;
#line 180 "opensearch.vala"
	g_return_if_fail (self != NULL);
#line 180 "opensearch.vala"
	old_value = synapse_open_search_plugin_search_action_get_query_template (self);
#line 180 "opensearch.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2911 "opensearch.c"
		gchar* _tmp0_;
#line 180 "opensearch.vala"
		_tmp0_ = g_strdup (value);
#line 180 "opensearch.vala"
		_g_free0 (self->priv->_query_template);
#line 180 "opensearch.vala"
		self->priv->_query_template = _tmp0_;
#line 180 "opensearch.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_open_search_plugin_search_action_properties[SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_QUERY_TEMPLATE_PROPERTY]);
#line 2921 "opensearch.c"
	}
}

static void
synapse_open_search_plugin_search_action_class_init (SynapseOpenSearchPluginSearchActionClass * klass,
                                                     gpointer klass_data)
{
#line 177 "opensearch.vala"
	synapse_open_search_plugin_search_action_parent_class = g_type_class_peek_parent (klass);
#line 177 "opensearch.vala"
	g_type_class_adjust_private_offset (klass, &SynapseOpenSearchPluginSearchAction_private_offset);
#line 177 "opensearch.vala"
	((SynapseMatchClass *) klass)->execute = (void (*) (SynapseMatch*, SynapseMatch*)) synapse_open_search_plugin_search_action_real_execute;
#line 177 "opensearch.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_open_search_plugin_search_action_get_property;
#line 177 "opensearch.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_open_search_plugin_search_action_set_property;
#line 177 "opensearch.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_open_search_plugin_search_action_finalize;
#line 177 "opensearch.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_DEFAULT_RELEVANCY_PROPERTY, synapse_open_search_plugin_search_action_properties[SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_DEFAULT_RELEVANCY_PROPERTY] = g_param_spec_int ("default-relevancy", "default-relevancy", "default-relevancy", G_MININT, G_MAXINT, (gint) SYNAPSE_MATCH_SCORE_INCREMENT_MINOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 177 "opensearch.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_QUERY_TEMPLATE_PROPERTY, synapse_open_search_plugin_search_action_properties[SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_QUERY_TEMPLATE_PROPERTY] = g_param_spec_string ("query-template", "query-template", "query-template", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 2945 "opensearch.c"
}

static void
synapse_open_search_plugin_search_action_instance_init (SynapseOpenSearchPluginSearchAction * self,
                                                        gpointer klass)
{
#line 177 "opensearch.vala"
	self->priv = synapse_open_search_plugin_search_action_get_instance_private (self);
#line 179 "opensearch.vala"
	self->priv->_default_relevancy = (gint) SYNAPSE_MATCH_SCORE_INCREMENT_MINOR;
#line 2956 "opensearch.c"
}

static void
synapse_open_search_plugin_search_action_finalize (GObject * obj)
{
	SynapseOpenSearchPluginSearchAction * self;
#line 177 "opensearch.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_SEARCH_ACTION, SynapseOpenSearchPluginSearchAction);
#line 180 "opensearch.vala"
	_g_free0 (self->priv->_query_template);
#line 177 "opensearch.vala"
	G_OBJECT_CLASS (synapse_open_search_plugin_search_action_parent_class)->finalize (obj);
#line 2969 "opensearch.c"
}

static GType
synapse_open_search_plugin_search_action_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseOpenSearchPluginSearchActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_open_search_plugin_search_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseOpenSearchPluginSearchAction), 0, (GInstanceInitFunc) synapse_open_search_plugin_search_action_instance_init, NULL };
	GType synapse_open_search_plugin_search_action_type_id;
	synapse_open_search_plugin_search_action_type_id = g_type_register_static (SYNAPSE_TYPE_MATCH, "SynapseOpenSearchPluginSearchAction", &g_define_type_info, 0);
	SynapseOpenSearchPluginSearchAction_private_offset = g_type_add_instance_private (synapse_open_search_plugin_search_action_type_id, sizeof (SynapseOpenSearchPluginSearchActionPrivate));
	return synapse_open_search_plugin_search_action_type_id;
}

static GType
synapse_open_search_plugin_search_action_get_type (void)
{
	static volatile gsize synapse_open_search_plugin_search_action_type_id__once = 0;
	if (g_once_init_enter (&synapse_open_search_plugin_search_action_type_id__once)) {
		GType synapse_open_search_plugin_search_action_type_id;
		synapse_open_search_plugin_search_action_type_id = synapse_open_search_plugin_search_action_get_type_once ();
		g_once_init_leave (&synapse_open_search_plugin_search_action_type_id__once, synapse_open_search_plugin_search_action_type_id);
	}
	return synapse_open_search_plugin_search_action_type_id__once;
}

static void
_vala_synapse_open_search_plugin_search_action_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec)
{
	SynapseOpenSearchPluginSearchAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_SEARCH_ACTION, SynapseOpenSearchPluginSearchAction);
#line 177 "opensearch.vala"
	switch (property_id) {
#line 177 "opensearch.vala"
		case SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_DEFAULT_RELEVANCY_PROPERTY:
#line 177 "opensearch.vala"
		g_value_set_int (value, synapse_open_search_plugin_search_action_get_default_relevancy (self));
#line 177 "opensearch.vala"
		break;
#line 177 "opensearch.vala"
		case SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_QUERY_TEMPLATE_PROPERTY:
#line 177 "opensearch.vala"
		g_value_set_string (value, synapse_open_search_plugin_search_action_get_query_template (self));
#line 177 "opensearch.vala"
		break;
#line 3016 "opensearch.c"
		default:
#line 177 "opensearch.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 177 "opensearch.vala"
		break;
#line 3022 "opensearch.c"
	}
}

static void
_vala_synapse_open_search_plugin_search_action_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec)
{
	SynapseOpenSearchPluginSearchAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_SEARCH_ACTION, SynapseOpenSearchPluginSearchAction);
#line 177 "opensearch.vala"
	switch (property_id) {
#line 177 "opensearch.vala"
		case SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_DEFAULT_RELEVANCY_PROPERTY:
#line 177 "opensearch.vala"
		synapse_open_search_plugin_search_action_set_default_relevancy (self, g_value_get_int (value));
#line 177 "opensearch.vala"
		break;
#line 177 "opensearch.vala"
		case SYNAPSE_OPEN_SEARCH_PLUGIN_SEARCH_ACTION_QUERY_TEMPLATE_PROPERTY:
#line 177 "opensearch.vala"
		synapse_open_search_plugin_search_action_set_query_template (self, g_value_get_string (value));
#line 177 "opensearch.vala"
		break;
#line 3048 "opensearch.c"
		default:
#line 177 "opensearch.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 177 "opensearch.vala"
		break;
#line 3054 "opensearch.c"
	}
}

static inline gpointer
synapse_open_search_plugin_config_get_instance_private (SynapseOpenSearchPluginConfig* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseOpenSearchPluginConfig_private_offset);
}

static SynapseOpenSearchPluginConfig*
synapse_open_search_plugin_config_construct (GType object_type)
{
	SynapseOpenSearchPluginConfig * self = NULL;
#line 231 "opensearch.vala"
	self = (SynapseOpenSearchPluginConfig*) synapse_config_object_construct (object_type);
#line 231 "opensearch.vala"
	return self;
#line 3072 "opensearch.c"
}

static SynapseOpenSearchPluginConfig*
synapse_open_search_plugin_config_new (void)
{
#line 231 "opensearch.vala"
	return synapse_open_search_plugin_config_construct (SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_CONFIG);
#line 3080 "opensearch.c"
}

static gboolean
synapse_open_search_plugin_config_get_use_internal (SynapseOpenSearchPluginConfig* self)
{
	gboolean result;
#line 233 "opensearch.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 233 "opensearch.vala"
	result = self->priv->_use_internal;
#line 233 "opensearch.vala"
	return result;
#line 3093 "opensearch.c"
}

static void
synapse_open_search_plugin_config_set_use_internal (SynapseOpenSearchPluginConfig* self,
                                                    gboolean value)
{
	gboolean old_value;
#line 233 "opensearch.vala"
	g_return_if_fail (self != NULL);
#line 233 "opensearch.vala"
	old_value = synapse_open_search_plugin_config_get_use_internal (self);
#line 233 "opensearch.vala"
	if (old_value != value) {
#line 233 "opensearch.vala"
		self->priv->_use_internal = value;
#line 233 "opensearch.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_open_search_plugin_config_properties[SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_USE_INTERNAL_PROPERTY]);
#line 3111 "opensearch.c"
	}
}

static gchar**
synapse_open_search_plugin_config_get_search_engines (SynapseOpenSearchPluginConfig* self,
                                                      gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
#line 238 "opensearch.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 240 "opensearch.vala"
	_tmp0_ = self->priv->_search_engines;
#line 240 "opensearch.vala"
	_tmp0__length1 = self->priv->_search_engines_length1;
#line 240 "opensearch.vala"
	_tmp1_ = _tmp0_;
#line 240 "opensearch.vala"
	_tmp1__length1 = _tmp0__length1;
#line 240 "opensearch.vala"
	if (result_length1) {
#line 240 "opensearch.vala"
		*result_length1 = _tmp1__length1;
#line 3138 "opensearch.c"
	}
#line 240 "opensearch.vala"
	result = _tmp1_;
#line 240 "opensearch.vala"
	return result;
#line 3144 "opensearch.c"
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
#line 244 "opensearch.vala"
	if (length >= 0) {
#line 3153 "opensearch.c"
		gchar** result;
		gssize i;
#line 244 "opensearch.vala"
		result = g_new0 (gchar*, length + 1);
#line 244 "opensearch.vala"
		for (i = 0; i < length; i++) {
#line 3160 "opensearch.c"
			gchar* _tmp0_;
#line 244 "opensearch.vala"
			_tmp0_ = g_strdup (self[i]);
#line 244 "opensearch.vala"
			result[i] = _tmp0_;
#line 3166 "opensearch.c"
		}
#line 244 "opensearch.vala"
		return result;
#line 3170 "opensearch.c"
	}
#line 244 "opensearch.vala"
	return NULL;
#line 3174 "opensearch.c"
}

static void
synapse_open_search_plugin_config_set_search_engines (SynapseOpenSearchPluginConfig* self,
                                                      gchar** value,
                                                      gint value_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
#line 242 "opensearch.vala"
	g_return_if_fail (self != NULL);
#line 244 "opensearch.vala"
	_tmp0_ = (value != NULL) ? _vala_array_dup2 (value, value_length1) : value;
#line 244 "opensearch.vala"
	_tmp0__length1 = value_length1;
#line 244 "opensearch.vala"
	self->priv->_search_engines = (_vala_array_free (self->priv->_search_engines, self->priv->_search_engines_length1, (GDestroyNotify) g_free), NULL);
#line 244 "opensearch.vala"
	self->priv->_search_engines = _tmp0_;
#line 244 "opensearch.vala"
	self->priv->_search_engines_length1 = _tmp0__length1;
#line 244 "opensearch.vala"
	self->priv->__search_engines_size_ = self->priv->_search_engines_length1;
#line 242 "opensearch.vala"
	g_object_notify_by_pspec ((GObject *) self, synapse_open_search_plugin_config_properties[SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_SEARCH_ENGINES_PROPERTY]);
#line 3200 "opensearch.c"
}

static void
synapse_open_search_plugin_config_class_init (SynapseOpenSearchPluginConfigClass * klass,
                                              gpointer klass_data)
{
#line 231 "opensearch.vala"
	synapse_open_search_plugin_config_parent_class = g_type_class_peek_parent (klass);
#line 231 "opensearch.vala"
	g_type_class_adjust_private_offset (klass, &SynapseOpenSearchPluginConfig_private_offset);
#line 231 "opensearch.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_open_search_plugin_config_get_property;
#line 231 "opensearch.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_open_search_plugin_config_set_property;
#line 231 "opensearch.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_open_search_plugin_config_finalize;
#line 231 "opensearch.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_USE_INTERNAL_PROPERTY, synapse_open_search_plugin_config_properties[SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_USE_INTERNAL_PROPERTY] = g_param_spec_boolean ("use-internal", "use-internal", "use-internal", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 231 "opensearch.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_SEARCH_ENGINES_PROPERTY, synapse_open_search_plugin_config_properties[SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_SEARCH_ENGINES_PROPERTY] = g_param_spec_boxed ("search-engines", "search-engines", "search-engines", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3221 "opensearch.c"
}

static void
synapse_open_search_plugin_config_instance_init (SynapseOpenSearchPluginConfig * self,
                                                 gpointer klass)
{
#line 231 "opensearch.vala"
	self->priv = synapse_open_search_plugin_config_get_instance_private (self);
#line 233 "opensearch.vala"
	self->priv->_use_internal = TRUE;
#line 3232 "opensearch.c"
}

static void
synapse_open_search_plugin_config_finalize (GObject * obj)
{
	SynapseOpenSearchPluginConfig * self;
#line 231 "opensearch.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_CONFIG, SynapseOpenSearchPluginConfig);
#line 235 "opensearch.vala"
	self->priv->_search_engines = (_vala_array_free (self->priv->_search_engines, self->priv->_search_engines_length1, (GDestroyNotify) g_free), NULL);
#line 231 "opensearch.vala"
	G_OBJECT_CLASS (synapse_open_search_plugin_config_parent_class)->finalize (obj);
#line 3245 "opensearch.c"
}

static GType
synapse_open_search_plugin_config_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseOpenSearchPluginConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_open_search_plugin_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseOpenSearchPluginConfig), 0, (GInstanceInitFunc) synapse_open_search_plugin_config_instance_init, NULL };
	GType synapse_open_search_plugin_config_type_id;
	synapse_open_search_plugin_config_type_id = g_type_register_static (SYNAPSE_TYPE_CONFIG_OBJECT, "SynapseOpenSearchPluginConfig", &g_define_type_info, 0);
	SynapseOpenSearchPluginConfig_private_offset = g_type_add_instance_private (synapse_open_search_plugin_config_type_id, sizeof (SynapseOpenSearchPluginConfigPrivate));
	return synapse_open_search_plugin_config_type_id;
}

static GType
synapse_open_search_plugin_config_get_type (void)
{
	static volatile gsize synapse_open_search_plugin_config_type_id__once = 0;
	if (g_once_init_enter (&synapse_open_search_plugin_config_type_id__once)) {
		GType synapse_open_search_plugin_config_type_id;
		synapse_open_search_plugin_config_type_id = synapse_open_search_plugin_config_get_type_once ();
		g_once_init_leave (&synapse_open_search_plugin_config_type_id__once, synapse_open_search_plugin_config_type_id);
	}
	return synapse_open_search_plugin_config_type_id__once;
}

static void
_vala_synapse_open_search_plugin_config_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec)
{
	SynapseOpenSearchPluginConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_CONFIG, SynapseOpenSearchPluginConfig);
#line 231 "opensearch.vala"
	switch (property_id) {
#line 231 "opensearch.vala"
		case SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_USE_INTERNAL_PROPERTY:
#line 231 "opensearch.vala"
		g_value_set_boolean (value, synapse_open_search_plugin_config_get_use_internal (self));
#line 231 "opensearch.vala"
		break;
#line 231 "opensearch.vala"
		case SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_SEARCH_ENGINES_PROPERTY:
#line 3288 "opensearch.c"
		{
			int length;
#line 231 "opensearch.vala"
			g_value_set_boxed (value, synapse_open_search_plugin_config_get_search_engines (self, &length));
#line 3293 "opensearch.c"
		}
#line 231 "opensearch.vala"
		break;
#line 3297 "opensearch.c"
		default:
#line 231 "opensearch.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 231 "opensearch.vala"
		break;
#line 3303 "opensearch.c"
	}
}

static void
_vala_synapse_open_search_plugin_config_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec)
{
	SynapseOpenSearchPluginConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_CONFIG, SynapseOpenSearchPluginConfig);
#line 231 "opensearch.vala"
	switch (property_id) {
#line 231 "opensearch.vala"
		case SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_USE_INTERNAL_PROPERTY:
#line 231 "opensearch.vala"
		synapse_open_search_plugin_config_set_use_internal (self, g_value_get_boolean (value));
#line 231 "opensearch.vala"
		break;
#line 231 "opensearch.vala"
		case SYNAPSE_OPEN_SEARCH_PLUGIN_CONFIG_SEARCH_ENGINES_PROPERTY:
#line 3325 "opensearch.c"
		{
			gpointer boxed;
#line 231 "opensearch.vala"
			boxed = g_value_get_boxed (value);
#line 231 "opensearch.vala"
			synapse_open_search_plugin_config_set_search_engines (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
#line 3332 "opensearch.c"
		}
#line 231 "opensearch.vala"
		break;
#line 3336 "opensearch.c"
		default:
#line 231 "opensearch.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 231 "opensearch.vala"
		break;
#line 3342 "opensearch.c"
	}
}

static GObject *
synapse_open_search_plugin_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseOpenSearchPlugin * self;
	SynapseConfigService* cs = NULL;
	SynapseConfigService* _tmp0_;
	SynapseConfigService* _tmp1_;
	SynapseConfigObject* _tmp2_;
#line 277 "opensearch.vala"
	parent_class = G_OBJECT_CLASS (synapse_open_search_plugin_parent_class);
#line 277 "opensearch.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 277 "opensearch.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_OPEN_SEARCH_PLUGIN, SynapseOpenSearchPlugin);
#line 279 "opensearch.vala"
	_tmp0_ = synapse_config_service_get_default ();
#line 279 "opensearch.vala"
	cs = _tmp0_;
#line 280 "opensearch.vala"
	_tmp1_ = cs;
#line 280 "opensearch.vala"
	_tmp2_ = synapse_config_service_get_config (_tmp1_, "plugins", "opensearch", SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_CONFIG);
#line 280 "opensearch.vala"
	_g_object_unref0 (self->priv->config);
#line 280 "opensearch.vala"
	self->priv->config = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, SYNAPSE_OPEN_SEARCH_PLUGIN_TYPE_CONFIG, SynapseOpenSearchPluginConfig);
#line 277 "opensearch.vala"
	_g_object_unref0 (cs);
#line 277 "opensearch.vala"
	return obj;
#line 3380 "opensearch.c"
}

static void
synapse_open_search_plugin_class_init (SynapseOpenSearchPluginClass * klass,
                                       gpointer klass_data)
{
	const gchar* dummy = NULL;
#line 61 "opensearch.vala"
	synapse_open_search_plugin_parent_class = g_type_class_peek_parent (klass);
#line 61 "opensearch.vala"
	g_type_class_adjust_private_offset (klass, &SynapseOpenSearchPlugin_private_offset);
#line 61 "opensearch.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_open_search_plugin_get_property;
#line 61 "opensearch.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_open_search_plugin_set_property;
#line 61 "opensearch.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_open_search_plugin_constructor;
#line 61 "opensearch.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_open_search_plugin_finalize;
#line 61 "opensearch.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_OPEN_SEARCH_PLUGIN_ENABLED_PROPERTY, synapse_open_search_plugin_properties[SYNAPSE_OPEN_SEARCH_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 262 "opensearch.vala"
	synapse_open_search_plugin_register_plugin ();
#line 266 "opensearch.vala"
	dummy = N_ ("DuckDuckGo");
#line 267 "opensearch.vala"
	dummy = N_ ("Search the web using duckduckgo.com");
#line 268 "opensearch.vala"
	dummy = N_ ("Google");
#line 269 "opensearch.vala"
	dummy = N_ ("Search the web using google.com");
#line 270 "opensearch.vala"
	dummy = N_ ("Google Maps");
#line 271 "opensearch.vala"
	dummy = N_ ("Search using Google Maps");
#line 3416 "opensearch.c"
}

static void
synapse_open_search_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                               gpointer iface_data)
{
#line 61 "opensearch.vala"
	synapse_open_search_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 61 "opensearch.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_open_search_plugin_real_activate;
#line 61 "opensearch.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_open_search_plugin_real_deactivate;
#line 61 "opensearch.vala"
	iface->get_enabled = synapse_open_search_plugin_real_get_enabled;
#line 61 "opensearch.vala"
	iface->set_enabled = synapse_open_search_plugin_real_set_enabled;
#line 3433 "opensearch.c"
}

static void
synapse_open_search_plugin_synapse_action_provider_interface_init (SynapseActionProviderIface * iface,
                                                                   gpointer iface_data)
{
#line 61 "opensearch.vala"
	synapse_open_search_plugin_synapse_action_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 61 "opensearch.vala"
	iface->handles_unknown = (gboolean (*) (SynapseActionProvider*)) synapse_open_search_plugin_real_handles_unknown;
#line 61 "opensearch.vala"
	iface->find_for_match = (SynapseResultSet* (*) (SynapseActionProvider*, SynapseQuery*, SynapseMatch*)) synapse_open_search_plugin_real_find_for_match;
#line 3446 "opensearch.c"
}

static void
synapse_open_search_plugin_instance_init (SynapseOpenSearchPlugin * self,
                                          gpointer klass)
{
#line 61 "opensearch.vala"
	self->priv = synapse_open_search_plugin_get_instance_private (self);
#line 63 "opensearch.vala"
	self->priv->_enabled = TRUE;
#line 3457 "opensearch.c"
}

static void
synapse_open_search_plugin_finalize (GObject * obj)
{
	SynapseOpenSearchPlugin * self;
#line 61 "opensearch.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_OPEN_SEARCH_PLUGIN, SynapseOpenSearchPlugin);
#line 274 "opensearch.vala"
	_g_object_unref0 (self->priv->actions);
#line 275 "opensearch.vala"
	_g_object_unref0 (self->priv->config);
#line 61 "opensearch.vala"
	G_OBJECT_CLASS (synapse_open_search_plugin_parent_class)->finalize (obj);
#line 3472 "opensearch.c"
}

static GType
synapse_open_search_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseOpenSearchPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_open_search_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseOpenSearchPlugin), 0, (GInstanceInitFunc) synapse_open_search_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_open_search_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_action_provider_info = { (GInterfaceInitFunc) synapse_open_search_plugin_synapse_action_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_open_search_plugin_type_id;
	synapse_open_search_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseOpenSearchPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_open_search_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_open_search_plugin_type_id, SYNAPSE_TYPE_ACTION_PROVIDER, &synapse_action_provider_info);
	SynapseOpenSearchPlugin_private_offset = g_type_add_instance_private (synapse_open_search_plugin_type_id, sizeof (SynapseOpenSearchPluginPrivate));
	return synapse_open_search_plugin_type_id;
}

GType
synapse_open_search_plugin_get_type (void)
{
	static volatile gsize synapse_open_search_plugin_type_id__once = 0;
	if (g_once_init_enter (&synapse_open_search_plugin_type_id__once)) {
		GType synapse_open_search_plugin_type_id;
		synapse_open_search_plugin_type_id = synapse_open_search_plugin_get_type_once ();
		g_once_init_leave (&synapse_open_search_plugin_type_id__once, synapse_open_search_plugin_type_id);
	}
	return synapse_open_search_plugin_type_id__once;
}

static void
_vala_synapse_open_search_plugin_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	SynapseOpenSearchPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_OPEN_SEARCH_PLUGIN, SynapseOpenSearchPlugin);
#line 61 "opensearch.vala"
	switch (property_id) {
#line 61 "opensearch.vala"
		case SYNAPSE_OPEN_SEARCH_PLUGIN_ENABLED_PROPERTY:
#line 61 "opensearch.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 61 "opensearch.vala"
		break;
#line 3517 "opensearch.c"
		default:
#line 61 "opensearch.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 61 "opensearch.vala"
		break;
#line 3523 "opensearch.c"
	}
}

static void
_vala_synapse_open_search_plugin_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	SynapseOpenSearchPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_OPEN_SEARCH_PLUGIN, SynapseOpenSearchPlugin);
#line 61 "opensearch.vala"
	switch (property_id) {
#line 61 "opensearch.vala"
		case SYNAPSE_OPEN_SEARCH_PLUGIN_ENABLED_PROPERTY:
#line 61 "opensearch.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 61 "opensearch.vala"
		break;
#line 3543 "opensearch.c"
		default:
#line 61 "opensearch.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 61 "opensearch.vala"
		break;
#line 3549 "opensearch.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

