/* BlackList.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BlackList.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2011 Collabora Ltd.
 * Copyright (c) 2012 Manish Sinha <manishsinha@ubuntu.com>
 * Copyright (c) 2014 elementary LLC. (http://launchpad.net/switchboard-plug-security-privacy)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 * Authored by: Corentin Noël <tintou@mailoo.org>
 *              Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com> (from Activity-Log-Manager)
 *              Seif Lotfy <seif@lotfy.com> (from Activity-Log-Manager)
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "security-privacy.h"
#include <zeitgeist-datamodel.h>
#include <zeitgeist.h>
#include <gtk/gtk.h>
#include <gobject/gvaluecollector.h>
#include <gee.h>

#define SECURITY_PRIVACY_SIG_EVENT "asaasay"
#define SECURITY_PRIVACY_SIG_BLACKLIST "a{s(" SECURITY_PRIVACY_SIG_EVENT ")}"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SECURITY_PRIVACY_TYPE_BLACKLIST_INTERFACE (security_privacy_blacklist_interface_get_type ())
#define SECURITY_PRIVACY_BLACKLIST_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SECURITY_PRIVACY_TYPE_BLACKLIST_INTERFACE, SecurityPrivacyBlacklistInterface))
#define SECURITY_PRIVACY_IS_BLACKLIST_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SECURITY_PRIVACY_TYPE_BLACKLIST_INTERFACE))
#define SECURITY_PRIVACY_BLACKLIST_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SECURITY_PRIVACY_TYPE_BLACKLIST_INTERFACE, SecurityPrivacyBlacklistInterfaceIface))

typedef struct _SecurityPrivacyBlacklistInterface SecurityPrivacyBlacklistInterface;
typedef struct _SecurityPrivacyBlacklistInterfaceIface SecurityPrivacyBlacklistInterfaceIface;

#define SECURITY_PRIVACY_TYPE_BLACKLIST_INTERFACE_PROXY (security_privacy_blacklist_interface_proxy_get_type ())
enum  {
	SECURITY_PRIVACY_BLACKLIST_INTERFACE_TEMPLATE_ADDED_SIGNAL,
	SECURITY_PRIVACY_BLACKLIST_INTERFACE_TEMPLATE_REMOVED_SIGNAL,
	SECURITY_PRIVACY_BLACKLIST_INTERFACE_NUM_SIGNALS
};
static guint security_privacy_blacklist_interface_signals[SECURITY_PRIVACY_BLACKLIST_INTERFACE_NUM_SIGNALS] = {0};
typedef GDBusProxy SecurityPrivacyBlacklistInterfaceProxy;
typedef GDBusProxyClass SecurityPrivacyBlacklistInterfaceProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _security_privacy_blacklist_unref0(var) ((var == NULL) ? NULL : (var = (security_privacy_blacklist_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _SecurityPrivacyBlacklistFindEventsData SecurityPrivacyBlacklistFindEventsData;
typedef struct _SecurityPrivacyParamSpecBlacklist SecurityPrivacyParamSpecBlacklist;
enum  {
	SECURITY_PRIVACY_BLACKLIST_TEMPLATE_ADDED_SIGNAL,
	SECURITY_PRIVACY_BLACKLIST_TEMPLATE_REMOVED_SIGNAL,
	SECURITY_PRIVACY_BLACKLIST_INCOGNITO_TOGGLED_SIGNAL,
	SECURITY_PRIVACY_BLACKLIST_NUM_SIGNALS
};
static guint security_privacy_blacklist_signals[SECURITY_PRIVACY_BLACKLIST_NUM_SIGNALS] = {0};
typedef struct _SecurityPrivacyParamSpecFileTypeBlacklist SecurityPrivacyParamSpecFileTypeBlacklist;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _SecurityPrivacyParamSpecPathBlacklist SecurityPrivacyParamSpecPathBlacklist;
enum  {
	SECURITY_PRIVACY_PATH_BLACKLIST_FOLDER_ADDED_SIGNAL,
	SECURITY_PRIVACY_PATH_BLACKLIST_FOLDER_REMOVED_SIGNAL,
	SECURITY_PRIVACY_PATH_BLACKLIST_NUM_SIGNALS
};
static guint security_privacy_path_blacklist_signals[SECURITY_PRIVACY_PATH_BLACKLIST_NUM_SIGNALS] = {0};
typedef struct _SecurityPrivacyParamSpecApplicationBlacklist SecurityPrivacyParamSpecApplicationBlacklist;
enum  {
	SECURITY_PRIVACY_APPLICATION_BLACKLIST_APPLICATION_ADDED_SIGNAL,
	SECURITY_PRIVACY_APPLICATION_BLACKLIST_APPLICATION_REMOVED_SIGNAL,
	SECURITY_PRIVACY_APPLICATION_BLACKLIST_NUM_SIGNALS
};
static guint security_privacy_application_blacklist_signals[SECURITY_PRIVACY_APPLICATION_BLACKLIST_NUM_SIGNALS] = {0};

struct _SecurityPrivacyBlacklistInterfaceIface {
	GTypeInterface parent_iface;
	GVariant* (*get_templates) (SecurityPrivacyBlacklistInterface* self, GError** error);
	void (*add_template) (SecurityPrivacyBlacklistInterface* self, const gchar* blacklist_id, GVariant* blacklist_template, GError** error);
	void (*remove_template) (SecurityPrivacyBlacklistInterface* self, const gchar* blacklist_id, GError** error);
};

struct _SecurityPrivacyBlacklistPrivate {
	SecurityPrivacyBlacklistInterface* blacklist;
	GHashTable* blacklists;
	ZeitgeistLog* log;
	gchar* incognito_id;
	ZeitgeistEvent* incognito_event;
};

struct _SecurityPrivacyBlacklistFindEventsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SecurityPrivacyBlacklist* self;
	gchar* id;
	GtkTreeIter iter;
	GtkListStore* store;
	ZeitgeistEvent* event;
	ZeitgeistEvent* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GPtrArray* events;
	GPtrArray* _tmp3_;
	ZeitgeistEvent* _tmp4_;
	ZeitgeistEvent* event2;
	ZeitgeistEvent* _tmp5_;
	ZeitgeistSubject* subj;
	ZeitgeistSubject* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	ZeitgeistEvent* _tmp9_;
	guint32* results;
	ZeitgeistLog* _tmp10_;
	ZeitgeistTimeRange* _tmp11_;
	ZeitgeistTimeRange* _tmp12_;
	gint _tmp13_;
	guint32* _tmp14_;
	guint32* _tmp15_;
	gint _tmp15__length1;
	gint results_length1;
	gint _results_size_;
	gint counter;
	GtkTreeIter _tmp16_;
	GValue _tmp17_;
	GError* e;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GError* _inner_error0_;
};

struct _SecurityPrivacyParamSpecBlacklist {
	GParamSpec parent_instance;
};

struct _SecurityPrivacyFileTypeBlacklistPrivate {
	SecurityPrivacyBlacklist* blacklist_interface;
	GeeHashSet* all_blocked_filetypes;
};

struct _SecurityPrivacyParamSpecFileTypeBlacklist {
	GParamSpec parent_instance;
};

struct _SecurityPrivacyPathBlacklistPrivate {
	SecurityPrivacyBlacklist* blacklist_interface;
	GeeHashSet* all_blocked_folder;
};

struct _SecurityPrivacyParamSpecPathBlacklist {
	GParamSpec parent_instance;
};

struct _SecurityPrivacyApplicationBlacklistPrivate {
	SecurityPrivacyBlacklist* blacklist_interface;
	GeeHashSet* all_blocked_apps;
};

struct _SecurityPrivacyParamSpecApplicationBlacklist {
	GParamSpec parent_instance;
};

static gint SecurityPrivacyBlacklist_private_offset;
static gpointer security_privacy_blacklist_parent_class = NULL;
static gint SecurityPrivacyFileTypeBlacklist_private_offset;
static gpointer security_privacy_file_type_blacklist_parent_class = NULL;
gchar* security_privacy_file_type_blacklist_interpretation_prefix = NULL;
static gint SecurityPrivacyPathBlacklist_private_offset;
static gpointer security_privacy_path_blacklist_parent_class = NULL;
gchar* security_privacy_path_blacklist_folder_prefix = NULL;
static gchar* security_privacy_path_blacklist_suffix;
static gchar* security_privacy_path_blacklist_suffix = NULL;
static gint SecurityPrivacyApplicationBlacklist_private_offset;
static gpointer security_privacy_application_blacklist_parent_class = NULL;
gchar* security_privacy_application_blacklist_interpretation_prefix = NULL;
gchar* security_privacy_application_blacklist_launcher_prefix = NULL;

VALA_EXTERN GType security_privacy_blacklist_interface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint security_privacy_blacklist_interface_register_object (void* object,
                                                            GDBusConnection* connection,
                                                            const gchar* path,
                                                            GError** error);
VALA_EXTERN GType security_privacy_blacklist_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GVariant* security_privacy_blacklist_interface_get_templates (SecurityPrivacyBlacklistInterface* self,
                                                              GError** error);
VALA_EXTERN void security_privacy_blacklist_interface_add_template (SecurityPrivacyBlacklistInterface* self,
                                                        const gchar* blacklist_id,
                                                        GVariant* blacklist_template,
                                                        GError** error);
VALA_EXTERN void security_privacy_blacklist_interface_remove_template (SecurityPrivacyBlacklistInterface* self,
                                                           const gchar* blacklist_id,
                                                           GError** error);
static void g_cclosure_user_marshal_VOID__STRING_VARIANT (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static GType security_privacy_blacklist_interface_get_type_once (void);
static void security_privacy_blacklist_interface_proxy_g_signal (GDBusProxy* proxy,
                                                          const gchar* sender_name,
                                                          const gchar* signal_name,
                                                          GVariant* parameters);
static void _dbus_handle_security_privacy_blacklist_interface_template_added (SecurityPrivacyBlacklistInterface* self,
                                                                       GVariant* parameters);
static void _dbus_handle_security_privacy_blacklist_interface_template_removed (SecurityPrivacyBlacklistInterface* self,
                                                                         GVariant* parameters);
static GVariant* security_privacy_blacklist_interface_proxy_get_templates (SecurityPrivacyBlacklistInterface* self,
                                                                    GError** error);
static void security_privacy_blacklist_interface_proxy_add_template (SecurityPrivacyBlacklistInterface* self,
                                                              const gchar* blacklist_id,
                                                              GVariant* blacklist_template,
                                                              GError** error);
static void security_privacy_blacklist_interface_proxy_remove_template (SecurityPrivacyBlacklistInterface* self,
                                                                 const gchar* blacklist_id,
                                                                 GError** error);
static void security_privacy_blacklist_interface_proxy_security_privacy_blacklist_interface_interface_init (SecurityPrivacyBlacklistInterfaceIface* iface);
static void _dbus_security_privacy_blacklist_interface_get_templates (SecurityPrivacyBlacklistInterface* self,
                                                               GVariant* _parameters_,
                                                               GDBusMethodInvocation* invocation);
static void _dbus_security_privacy_blacklist_interface_add_template (SecurityPrivacyBlacklistInterface* self,
                                                              GVariant* _parameters_,
                                                              GDBusMethodInvocation* invocation);
static void _dbus_security_privacy_blacklist_interface_remove_template (SecurityPrivacyBlacklistInterface* self,
                                                                 GVariant* _parameters_,
                                                                 GDBusMethodInvocation* invocation);
static void security_privacy_blacklist_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                                      const gchar* sender,
                                                                      const gchar* object_path,
                                                                      const gchar* interface_name,
                                                                      const gchar* method_name,
                                                                      GVariant* parameters,
                                                                      GDBusMethodInvocation* invocation,
                                                                      gpointer user_data);
static GVariant* security_privacy_blacklist_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                                            const gchar* sender,
                                                                            const gchar* object_path,
                                                                            const gchar* interface_name,
                                                                            const gchar* property_name,
                                                                            GError** error,
                                                                            gpointer user_data);
static gboolean security_privacy_blacklist_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                                           const gchar* sender,
                                                                           const gchar* object_path,
                                                                           const gchar* interface_name,
                                                                           const gchar* property_name,
                                                                           GVariant* value,
                                                                           GError** error,
                                                                           gpointer user_data);
static void _dbus_security_privacy_blacklist_interface_template_added (GObject* _sender,
                                                                const gchar* blacklist_id,
                                                                GVariant* blacklist_template,
                                                                gpointer* _data);
static void _dbus_security_privacy_blacklist_interface_template_removed (GObject* _sender,
                                                                  const gchar* blacklist_id,
                                                                  GVariant* blacklist_template,
                                                                  gpointer* _data);
static void _security_privacy_blacklist_interface_unregister_object (gpointer user_data);
static void security_privacy_blacklist_on_template_added (SecurityPrivacyBlacklist* self,
                                                   const gchar* blacklist_id,
                                                   GVariant* blacklist_template);
static void _security_privacy_blacklist_on_template_added_security_privacy_blacklist_interface_template_added (SecurityPrivacyBlacklistInterface* _sender,
                                                                                                        const gchar* blacklist_id,
                                                                                                        GVariant* blacklist_template,
                                                                                                        gpointer self);
static void security_privacy_blacklist_on_template_removed (SecurityPrivacyBlacklist* self,
                                                     const gchar* blacklist_id,
                                                     GVariant* blacklist_template);
static void _security_privacy_blacklist_on_template_removed_security_privacy_blacklist_interface_template_removed (SecurityPrivacyBlacklistInterface* _sender,
                                                                                                            const gchar* blacklist_id,
                                                                                                            GVariant* blacklist_template,
                                                                                                            gpointer self);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void security_privacy_blacklist_find_events_data_free (gpointer _data);
static gboolean security_privacy_blacklist_find_events_co (SecurityPrivacyBlacklistFindEventsData* _data_);
static void security_privacy_blacklist_find_events_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void g_cclosure_user_marshal_VOID__STRING_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void security_privacy_blacklist_finalize (SecurityPrivacyBlacklist * obj);
static GType security_privacy_blacklist_get_type_once (void);
static void security_privacy_file_type_blacklist_on_blacklist_added (SecurityPrivacyFileTypeBlacklist* self,
                                                              const gchar* blacklist_id,
                                                              ZeitgeistEvent* ev);
static void _security_privacy_file_type_blacklist_on_blacklist_added_security_privacy_blacklist_template_added (SecurityPrivacyBlacklist* _sender,
                                                                                                         const gchar* blacklist_id,
                                                                                                         ZeitgeistEvent* blacklist_template,
                                                                                                         gpointer self);
static void security_privacy_file_type_blacklist_on_blacklist_removed (SecurityPrivacyFileTypeBlacklist* self,
                                                                const gchar* blacklist_id,
                                                                ZeitgeistEvent* ev);
static void _security_privacy_file_type_blacklist_on_blacklist_removed_security_privacy_blacklist_template_removed (SecurityPrivacyBlacklist* _sender,
                                                                                                             const gchar* blacklist_id,
                                                                                                             ZeitgeistEvent* blacklist_template,
                                                                                                             gpointer self);
static void security_privacy_file_type_blacklist_populate_file_types (SecurityPrivacyFileTypeBlacklist* self);
static gchar* security_privacy_file_type_blacklist_get_name (SecurityPrivacyFileTypeBlacklist* self,
                                                      const gchar* interpretation);
static void security_privacy_file_type_blacklist_finalize (SecurityPrivacyFileTypeBlacklist * obj);
static GType security_privacy_file_type_blacklist_get_type_once (void);
static void security_privacy_path_blacklist_on_blacklist_added (SecurityPrivacyPathBlacklist* self,
                                                         const gchar* blacklist_id,
                                                         ZeitgeistEvent* ev);
static void _security_privacy_path_blacklist_on_blacklist_added_security_privacy_blacklist_template_added (SecurityPrivacyBlacklist* _sender,
                                                                                                    const gchar* blacklist_id,
                                                                                                    ZeitgeistEvent* blacklist_template,
                                                                                                    gpointer self);
static void security_privacy_path_blacklist_on_blacklist_removed (SecurityPrivacyPathBlacklist* self,
                                                           const gchar* blacklist_id,
                                                           ZeitgeistEvent* ev);
static void _security_privacy_path_blacklist_on_blacklist_removed_security_privacy_blacklist_template_removed (SecurityPrivacyBlacklist* _sender,
                                                                                                        const gchar* blacklist_id,
                                                                                                        ZeitgeistEvent* blacklist_template,
                                                                                                        gpointer self);
static void security_privacy_path_blacklist_get_blocked_folder (SecurityPrivacyPathBlacklist* self);
static gchar* security_privacy_path_blacklist_get_folder (SecurityPrivacyPathBlacklist* self,
                                                   ZeitgeistEvent* ev);
static void security_privacy_path_blacklist_finalize (SecurityPrivacyPathBlacklist * obj);
static GType security_privacy_path_blacklist_get_type_once (void);
static void security_privacy_application_blacklist_on_blacklist_added (SecurityPrivacyApplicationBlacklist* self,
                                                                const gchar* blacklist_id,
                                                                ZeitgeistEvent* ev);
static void _security_privacy_application_blacklist_on_blacklist_added_security_privacy_blacklist_template_added (SecurityPrivacyBlacklist* _sender,
                                                                                                           const gchar* blacklist_id,
                                                                                                           ZeitgeistEvent* blacklist_template,
                                                                                                           gpointer self);
static void security_privacy_application_blacklist_on_blacklist_removed (SecurityPrivacyApplicationBlacklist* self,
                                                                  const gchar* blacklist_id,
                                                                  ZeitgeistEvent* ev);
static void _security_privacy_application_blacklist_on_blacklist_removed_security_privacy_blacklist_template_removed (SecurityPrivacyBlacklist* _sender,
                                                                                                               const gchar* blacklist_id,
                                                                                                               ZeitgeistEvent* blacklist_template,
                                                                                                               gpointer self);
static GeeHashSet* security_privacy_application_blacklist_get_blocked_apps (SecurityPrivacyApplicationBlacklist* self);
static void security_privacy_application_blacklist_finalize (SecurityPrivacyApplicationBlacklist * obj);
static GType security_privacy_application_blacklist_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GDBusArgInfo _security_privacy_blacklist_interface_dbus_arg_info_get_templates_result = {-1, "result", "a{s(asaasay)}", NULL};
static const GDBusArgInfo * const _security_privacy_blacklist_interface_dbus_arg_info_get_templates_in[] = {NULL};
static const GDBusArgInfo * const _security_privacy_blacklist_interface_dbus_arg_info_get_templates_out[] = {&_security_privacy_blacklist_interface_dbus_arg_info_get_templates_result, NULL};
static const GDBusMethodInfo _security_privacy_blacklist_interface_dbus_method_info_get_templates = {-1, "GetTemplates", (GDBusArgInfo **) (&_security_privacy_blacklist_interface_dbus_arg_info_get_templates_in), (GDBusArgInfo **) (&_security_privacy_blacklist_interface_dbus_arg_info_get_templates_out), NULL};
static const GDBusArgInfo _security_privacy_blacklist_interface_dbus_arg_info_add_template_blacklist_id = {-1, "blacklist_id", "s", NULL};
static const GDBusArgInfo _security_privacy_blacklist_interface_dbus_arg_info_add_template_blacklist_template = {-1, "blacklist_template", "(asaasay)", NULL};
static const GDBusArgInfo * const _security_privacy_blacklist_interface_dbus_arg_info_add_template_in[] = {&_security_privacy_blacklist_interface_dbus_arg_info_add_template_blacklist_id, &_security_privacy_blacklist_interface_dbus_arg_info_add_template_blacklist_template, NULL};
static const GDBusArgInfo * const _security_privacy_blacklist_interface_dbus_arg_info_add_template_out[] = {NULL};
static const GDBusMethodInfo _security_privacy_blacklist_interface_dbus_method_info_add_template = {-1, "AddTemplate", (GDBusArgInfo **) (&_security_privacy_blacklist_interface_dbus_arg_info_add_template_in), (GDBusArgInfo **) (&_security_privacy_blacklist_interface_dbus_arg_info_add_template_out), NULL};
static const GDBusArgInfo _security_privacy_blacklist_interface_dbus_arg_info_remove_template_blacklist_id = {-1, "blacklist_id", "s", NULL};
static const GDBusArgInfo * const _security_privacy_blacklist_interface_dbus_arg_info_remove_template_in[] = {&_security_privacy_blacklist_interface_dbus_arg_info_remove_template_blacklist_id, NULL};
static const GDBusArgInfo * const _security_privacy_blacklist_interface_dbus_arg_info_remove_template_out[] = {NULL};
static const GDBusMethodInfo _security_privacy_blacklist_interface_dbus_method_info_remove_template = {-1, "RemoveTemplate", (GDBusArgInfo **) (&_security_privacy_blacklist_interface_dbus_arg_info_remove_template_in), (GDBusArgInfo **) (&_security_privacy_blacklist_interface_dbus_arg_info_remove_template_out), NULL};
static const GDBusMethodInfo * const _security_privacy_blacklist_interface_dbus_method_info[] = {&_security_privacy_blacklist_interface_dbus_method_info_get_templates, &_security_privacy_blacklist_interface_dbus_method_info_add_template, &_security_privacy_blacklist_interface_dbus_method_info_remove_template, NULL};
static const GDBusArgInfo _security_privacy_blacklist_interface_dbus_arg_info_template_added_blacklist_id = {-1, "blacklist_id", "s", NULL};
static const GDBusArgInfo _security_privacy_blacklist_interface_dbus_arg_info_template_added_blacklist_template = {-1, "blacklist_template", "(asaasay)", NULL};
static const GDBusArgInfo * const _security_privacy_blacklist_interface_dbus_arg_info_template_added[] = {&_security_privacy_blacklist_interface_dbus_arg_info_template_added_blacklist_id, &_security_privacy_blacklist_interface_dbus_arg_info_template_added_blacklist_template, NULL};
static const GDBusSignalInfo _security_privacy_blacklist_interface_dbus_signal_info_template_added = {-1, "TemplateAdded", (GDBusArgInfo **) (&_security_privacy_blacklist_interface_dbus_arg_info_template_added), NULL};
static const GDBusArgInfo _security_privacy_blacklist_interface_dbus_arg_info_template_removed_blacklist_id = {-1, "blacklist_id", "s", NULL};
static const GDBusArgInfo _security_privacy_blacklist_interface_dbus_arg_info_template_removed_blacklist_template = {-1, "blacklist_template", "(asaasay)", NULL};
static const GDBusArgInfo * const _security_privacy_blacklist_interface_dbus_arg_info_template_removed[] = {&_security_privacy_blacklist_interface_dbus_arg_info_template_removed_blacklist_id, &_security_privacy_blacklist_interface_dbus_arg_info_template_removed_blacklist_template, NULL};
static const GDBusSignalInfo _security_privacy_blacklist_interface_dbus_signal_info_template_removed = {-1, "TemplateRemoved", (GDBusArgInfo **) (&_security_privacy_blacklist_interface_dbus_arg_info_template_removed), NULL};
static const GDBusSignalInfo * const _security_privacy_blacklist_interface_dbus_signal_info[] = {&_security_privacy_blacklist_interface_dbus_signal_info_template_added, &_security_privacy_blacklist_interface_dbus_signal_info_template_removed, NULL};
static const GDBusPropertyInfo * const _security_privacy_blacklist_interface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _security_privacy_blacklist_interface_dbus_interface_info = {-1, "org.gnome.zeitgeist.Blacklist", (GDBusMethodInfo **) (&_security_privacy_blacklist_interface_dbus_method_info), (GDBusSignalInfo **) (&_security_privacy_blacklist_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_security_privacy_blacklist_interface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _security_privacy_blacklist_interface_dbus_interface_vtable = {security_privacy_blacklist_interface_dbus_interface_method_call, security_privacy_blacklist_interface_dbus_interface_get_property, security_privacy_blacklist_interface_dbus_interface_set_property};

GVariant*
security_privacy_blacklist_interface_get_templates (SecurityPrivacyBlacklistInterface* self,
                                                    GError** error)
{
	SecurityPrivacyBlacklistInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SECURITY_PRIVACY_BLACKLIST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->get_templates) {
		return _iface_->get_templates (self, error);
	}
	return NULL;
}

void
security_privacy_blacklist_interface_add_template (SecurityPrivacyBlacklistInterface* self,
                                                   const gchar* blacklist_id,
                                                   GVariant* blacklist_template,
                                                   GError** error)
{
	SecurityPrivacyBlacklistInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SECURITY_PRIVACY_BLACKLIST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->add_template) {
		_iface_->add_template (self, blacklist_id, blacklist_template, error);
	}
}

void
security_privacy_blacklist_interface_remove_template (SecurityPrivacyBlacklistInterface* self,
                                                      const gchar* blacklist_id,
                                                      GError** error)
{
	SecurityPrivacyBlacklistInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SECURITY_PRIVACY_BLACKLIST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->remove_template) {
		_iface_->remove_template (self, blacklist_id, error);
	}
}

static void
g_cclosure_user_marshal_VOID__STRING_VARIANT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_VARIANT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_VARIANT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_VARIANT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_variant (param_values + 2), data2);
}

static void
security_privacy_blacklist_interface_default_init (SecurityPrivacyBlacklistInterfaceIface * iface,
                                                   gpointer iface_data)
{
	security_privacy_blacklist_interface_signals[SECURITY_PRIVACY_BLACKLIST_INTERFACE_TEMPLATE_ADDED_SIGNAL] = g_signal_new ("template-added", SECURITY_PRIVACY_TYPE_BLACKLIST_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_VARIANT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_VARIANT);
	security_privacy_blacklist_interface_signals[SECURITY_PRIVACY_BLACKLIST_INTERFACE_TEMPLATE_REMOVED_SIGNAL] = g_signal_new ("template-removed", SECURITY_PRIVACY_TYPE_BLACKLIST_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_VARIANT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_VARIANT);
}

static GType
security_privacy_blacklist_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SecurityPrivacyBlacklistInterfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) security_privacy_blacklist_interface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType security_privacy_blacklist_interface_type_id;
	security_privacy_blacklist_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "SecurityPrivacyBlacklistInterface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (security_privacy_blacklist_interface_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (security_privacy_blacklist_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) security_privacy_blacklist_interface_proxy_get_type);
	g_type_set_qdata (security_privacy_blacklist_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.zeitgeist.Blacklist");
	g_type_set_qdata (security_privacy_blacklist_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_security_privacy_blacklist_interface_dbus_interface_info));
	g_type_set_qdata (security_privacy_blacklist_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) security_privacy_blacklist_interface_register_object);
	return security_privacy_blacklist_interface_type_id;
}

GType
security_privacy_blacklist_interface_get_type (void)
{
	static volatile gsize security_privacy_blacklist_interface_type_id__once = 0;
	if (g_once_init_enter (&security_privacy_blacklist_interface_type_id__once)) {
		GType security_privacy_blacklist_interface_type_id;
		security_privacy_blacklist_interface_type_id = security_privacy_blacklist_interface_get_type_once ();
		g_once_init_leave (&security_privacy_blacklist_interface_type_id__once, security_privacy_blacklist_interface_type_id);
	}
	return security_privacy_blacklist_interface_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (SecurityPrivacyBlacklistInterfaceProxy, security_privacy_blacklist_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (SECURITY_PRIVACY_TYPE_BLACKLIST_INTERFACE, security_privacy_blacklist_interface_proxy_security_privacy_blacklist_interface_interface_init) )
static void
security_privacy_blacklist_interface_proxy_class_init (SecurityPrivacyBlacklistInterfaceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = security_privacy_blacklist_interface_proxy_g_signal;
}

static void
_dbus_handle_security_privacy_blacklist_interface_template_added (SecurityPrivacyBlacklistInterface* self,
                                                                  GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* blacklist_id = NULL;
	GVariant* _tmp0_;
	GVariant* blacklist_template = NULL;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	blacklist_id = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	blacklist_template = g_variant_iter_next_value (&_arguments_iter);
	g_signal_emit_by_name (self, "template-added", blacklist_id, blacklist_template);
	_g_free0 (blacklist_id);
	_g_variant_unref0 (blacklist_template);
}

static void
_dbus_handle_security_privacy_blacklist_interface_template_removed (SecurityPrivacyBlacklistInterface* self,
                                                                    GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* blacklist_id = NULL;
	GVariant* _tmp1_;
	GVariant* blacklist_template = NULL;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	blacklist_id = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	blacklist_template = g_variant_iter_next_value (&_arguments_iter);
	g_signal_emit_by_name (self, "template-removed", blacklist_id, blacklist_template);
	_g_free0 (blacklist_id);
	_g_variant_unref0 (blacklist_template);
}

static void
security_privacy_blacklist_interface_proxy_g_signal (GDBusProxy* proxy,
                                                     const gchar* sender_name,
                                                     const gchar* signal_name,
                                                     GVariant* parameters)
{
	if (strcmp (signal_name, "TemplateAdded") == 0) {
		_dbus_handle_security_privacy_blacklist_interface_template_added ((SecurityPrivacyBlacklistInterface*) proxy, parameters);
	} else if (strcmp (signal_name, "TemplateRemoved") == 0) {
		_dbus_handle_security_privacy_blacklist_interface_template_removed ((SecurityPrivacyBlacklistInterface*) proxy, parameters);
	}
}

static void
security_privacy_blacklist_interface_proxy_init (SecurityPrivacyBlacklistInterfaceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_security_privacy_blacklist_interface_dbus_interface_info));
}

static GVariant*
security_privacy_blacklist_interface_proxy_get_templates (SecurityPrivacyBlacklistInterface* self,
                                                          GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GVariant* _result = NULL;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.zeitgeist.Blacklist", "GetTemplates");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result = g_variant_iter_next_value (&_reply_iter);
	g_object_unref (_reply_message);
	return _result;
}

static void
security_privacy_blacklist_interface_proxy_add_template (SecurityPrivacyBlacklistInterface* self,
                                                         const gchar* blacklist_id,
                                                         GVariant* blacklist_template,
                                                         GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.zeitgeist.Blacklist", "AddTemplate");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (blacklist_id));
	g_variant_builder_add_value (&_arguments_builder, blacklist_template);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
security_privacy_blacklist_interface_proxy_remove_template (SecurityPrivacyBlacklistInterface* self,
                                                            const gchar* blacklist_id,
                                                            GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.zeitgeist.Blacklist", "RemoveTemplate");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (blacklist_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
security_privacy_blacklist_interface_proxy_security_privacy_blacklist_interface_interface_init (SecurityPrivacyBlacklistInterfaceIface* iface)
{
	iface->get_templates = security_privacy_blacklist_interface_proxy_get_templates;
	iface->add_template = security_privacy_blacklist_interface_proxy_add_template;
	iface->remove_template = security_privacy_blacklist_interface_proxy_remove_template;
}

static void
_dbus_security_privacy_blacklist_interface_get_templates (SecurityPrivacyBlacklistInterface* self,
                                                          GVariant* _parameters_,
                                                          GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = security_privacy_blacklist_interface_get_templates (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, result);
	_g_variant_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_security_privacy_blacklist_interface_add_template (SecurityPrivacyBlacklistInterface* self,
                                                         GVariant* _parameters_,
                                                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* blacklist_id = NULL;
	GVariant* _tmp2_;
	GVariant* blacklist_template = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	blacklist_id = g_variant_dup_string (_tmp2_, NULL);
	g_variant_unref (_tmp2_);
	blacklist_template = g_variant_iter_next_value (&_arguments_iter);
	security_privacy_blacklist_interface_add_template (self, blacklist_id, blacklist_template, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (blacklist_id);
	_g_variant_unref0 (blacklist_template);
	;
}

static void
_dbus_security_privacy_blacklist_interface_remove_template (SecurityPrivacyBlacklistInterface* self,
                                                            GVariant* _parameters_,
                                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* blacklist_id = NULL;
	GVariant* _tmp3_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	blacklist_id = g_variant_dup_string (_tmp3_, NULL);
	g_variant_unref (_tmp3_);
	security_privacy_blacklist_interface_remove_template (self, blacklist_id, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (blacklist_id);
	;
}

static void
security_privacy_blacklist_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* method_name,
                                                                 GVariant* parameters,
                                                                 GDBusMethodInvocation* invocation,
                                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetTemplates") == 0) {
		_dbus_security_privacy_blacklist_interface_get_templates (object, parameters, invocation);
	} else if (strcmp (method_name, "AddTemplate") == 0) {
		_dbus_security_privacy_blacklist_interface_add_template (object, parameters, invocation);
	} else if (strcmp (method_name, "RemoveTemplate") == 0) {
		_dbus_security_privacy_blacklist_interface_remove_template (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
security_privacy_blacklist_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                                  const gchar* sender,
                                                                  const gchar* object_path,
                                                                  const gchar* interface_name,
                                                                  const gchar* property_name,
                                                                  GError** error,
                                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
security_privacy_blacklist_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                                  const gchar* sender,
                                                                  const gchar* object_path,
                                                                  const gchar* interface_name,
                                                                  const gchar* property_name,
                                                                  GVariant* value,
                                                                  GError** error,
                                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_security_privacy_blacklist_interface_template_added (GObject* _sender,
                                                           const gchar* blacklist_id,
                                                           GVariant* blacklist_template,
                                                           gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (blacklist_id));
	g_variant_builder_add_value (&_arguments_builder, blacklist_template);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.zeitgeist.Blacklist", "TemplateAdded", _arguments, NULL);
}

static void
_dbus_security_privacy_blacklist_interface_template_removed (GObject* _sender,
                                                             const gchar* blacklist_id,
                                                             GVariant* blacklist_template,
                                                             gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (blacklist_id));
	g_variant_builder_add_value (&_arguments_builder, blacklist_template);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.zeitgeist.Blacklist", "TemplateRemoved", _arguments, NULL);
}

guint
security_privacy_blacklist_interface_register_object (gpointer object,
                                                      GDBusConnection* connection,
                                                      const gchar* path,
                                                      GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_security_privacy_blacklist_interface_dbus_interface_info), &_security_privacy_blacklist_interface_dbus_interface_vtable, data, _security_privacy_blacklist_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "template-added", (GCallback) _dbus_security_privacy_blacklist_interface_template_added, data);
	g_signal_connect (object, "template-removed", (GCallback) _dbus_security_privacy_blacklist_interface_template_removed, data);
	return result;
}

static void
_security_privacy_blacklist_interface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_security_privacy_blacklist_interface_template_added, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_security_privacy_blacklist_interface_template_removed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
security_privacy_blacklist_get_instance_private (SecurityPrivacyBlacklist* self)
{
	return G_STRUCT_MEMBER_P (self, SecurityPrivacyBlacklist_private_offset);
}

static void
_security_privacy_blacklist_on_template_added_security_privacy_blacklist_interface_template_added (SecurityPrivacyBlacklistInterface* _sender,
                                                                                                   const gchar* blacklist_id,
                                                                                                   GVariant* blacklist_template,
                                                                                                   gpointer self)
{
	security_privacy_blacklist_on_template_added ((SecurityPrivacyBlacklist*) self, blacklist_id, blacklist_template);
}

static void
_security_privacy_blacklist_on_template_removed_security_privacy_blacklist_interface_template_removed (SecurityPrivacyBlacklistInterface* _sender,
                                                                                                       const gchar* blacklist_id,
                                                                                                       GVariant* blacklist_template,
                                                                                                       gpointer self)
{
	security_privacy_blacklist_on_template_removed ((SecurityPrivacyBlacklist*) self, blacklist_id, blacklist_template);
}

SecurityPrivacyBlacklist*
security_privacy_blacklist_construct (GType object_type)
{
	SecurityPrivacyBlacklist* self = NULL;
	ZeitgeistLog* _tmp6_;
	ZeitgeistEvent* _tmp7_;
	GError* _inner_error0_ = NULL;
	self = (SecurityPrivacyBlacklist*) g_type_create_instance (object_type);
	{
		SecurityPrivacyBlacklistInterface* _tmp0_ = NULL;
		SecurityPrivacyBlacklistInterface* _tmp1_;
		SecurityPrivacyBlacklistInterface* _tmp2_;
		SecurityPrivacyBlacklistInterface* _tmp3_;
		SecurityPrivacyBlacklistInterface* _tmp4_;
		_tmp1_ = (SecurityPrivacyBlacklistInterface*) g_initable_new (SECURITY_PRIVACY_TYPE_BLACKLIST_INTERFACE_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.gnome.zeitgeist.Engine", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/zeitgeist/blacklist", "g-interface-name", "org.gnome.zeitgeist.Blacklist", NULL);
		_tmp0_ = (SecurityPrivacyBlacklistInterface*) _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->blacklist);
		self->priv->blacklist = _tmp2_;
		_tmp3_ = self->priv->blacklist;
		g_signal_connect (_tmp3_, "template-added", (GCallback) _security_privacy_blacklist_on_template_added_security_privacy_blacklist_interface_template_added, self);
		_tmp4_ = self->priv->blacklist;
		g_signal_connect (_tmp4_, "template-removed", (GCallback) _security_privacy_blacklist_on_template_removed_security_privacy_blacklist_interface_template_removed, self);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e->message;
		g_error ("BlackList.vala:71: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp6_ = zeitgeist_log_new ();
	_g_object_unref0 (self->priv->log);
	self->priv->log = _tmp6_;
	_tmp7_ = zeitgeist_event_new ();
	_g_object_unref0 (self->priv->incognito_event);
	self->priv->incognito_event = _tmp7_;
	return self;
}

SecurityPrivacyBlacklist*
security_privacy_blacklist_new (void)
{
	return security_privacy_blacklist_construct (SECURITY_PRIVACY_TYPE_BLACKLIST);
}

void
security_privacy_blacklist_add_template (SecurityPrivacyBlacklist* self,
                                         const gchar* blacklist_id,
                                         ZeitgeistEvent* blacklist_template)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (blacklist_id != NULL);
	g_return_if_fail (blacklist_template != NULL);
	{
		SecurityPrivacyBlacklistInterface* _tmp0_;
		GVariant* _tmp1_;
		GVariant* _tmp2_;
		_tmp0_ = self->priv->blacklist;
		_tmp1_ = zeitgeist_event_to_variant (blacklist_template);
		_tmp2_ = _tmp1_;
		security_privacy_blacklist_interface_add_template (_tmp0_, blacklist_id, _tmp2_, &_inner_error0_);
		_g_variant_unref0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_critical ("BlackList.vala:94: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
security_privacy_blacklist_remove_template (SecurityPrivacyBlacklist* self,
                                            const gchar* blacklist_id)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (blacklist_id != NULL);
	{
		SecurityPrivacyBlacklistInterface* _tmp0_;
		_tmp0_ = self->priv->blacklist;
		security_privacy_blacklist_interface_remove_template (_tmp0_, blacklist_id, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_critical ("BlackList.vala:102: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
security_privacy_blacklist_set_incognito (SecurityPrivacyBlacklist* self,
                                          gboolean status)
{
	g_return_if_fail (self != NULL);
	if (status) {
		const gchar* _tmp0_;
		ZeitgeistEvent* _tmp1_;
		_tmp0_ = self->priv->incognito_id;
		_tmp1_ = self->priv->incognito_event;
		security_privacy_blacklist_add_template (self, _tmp0_, _tmp1_);
	} else {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->incognito_id;
		security_privacy_blacklist_remove_template (self, _tmp2_);
	}
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

GHashTable*
security_privacy_blacklist_get_templates (SecurityPrivacyBlacklist* self)
{
	GError* _inner_error0_ = NULL;
	GHashTable* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GVariant* var_blacklists = NULL;
		SecurityPrivacyBlacklistInterface* _tmp0_;
		GVariant* _tmp1_;
		GHashTable* _tmp2_;
		GHashTable* _tmp3_;
		GHashTable* _tmp4_;
		_tmp0_ = self->priv->blacklist;
		_tmp1_ = security_privacy_blacklist_interface_get_templates (_tmp0_, &_inner_error0_);
		var_blacklists = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = security_privacy_utilities_from_variant (var_blacklists);
		_g_hash_table_unref0 (self->priv->blacklists);
		self->priv->blacklists = _tmp2_;
		_tmp3_ = self->priv->blacklists;
		_tmp4_ = _g_hash_table_ref0 (_tmp3_);
		result = _tmp4_;
		_g_variant_unref0 (var_blacklists);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		GHashTable* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_critical ("BlackList.vala:121: %s", _tmp6_);
		_tmp7_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_object_unref0_);
		result = _tmp7_;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
security_privacy_blacklist_on_template_added (SecurityPrivacyBlacklist* self,
                                              const gchar* blacklist_id,
                                              GVariant* blacklist_template)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (blacklist_id != NULL);
	g_return_if_fail (blacklist_template != NULL);
	{
		ZeitgeistEvent* ev = NULL;
		ZeitgeistEvent* _tmp0_;
		const gchar* _tmp1_;
		GHashTable* _tmp2_;
		gchar* _tmp3_;
		ZeitgeistEvent* _tmp4_;
		_tmp0_ = zeitgeist_event_new_from_variant (blacklist_template, &_inner_error0_);
		ev = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_signal_emit (self, security_privacy_blacklist_signals[SECURITY_PRIVACY_BLACKLIST_TEMPLATE_ADDED_SIGNAL], 0, blacklist_id, ev);
		_tmp1_ = self->priv->incognito_id;
		if (g_strcmp0 (blacklist_id, _tmp1_) == 0) {
			g_signal_emit (self, security_privacy_blacklist_signals[SECURITY_PRIVACY_BLACKLIST_INCOGNITO_TOGGLED_SIGNAL], 0, TRUE);
		}
		_tmp2_ = self->priv->blacklists;
		_tmp3_ = g_strdup (blacklist_id);
		_tmp4_ = _g_object_ref0 (ev);
		g_hash_table_insert (_tmp2_, _tmp3_, _tmp4_);
		_g_object_unref0 (ev);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_critical ("BlackList.vala:136: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
security_privacy_blacklist_on_template_removed (SecurityPrivacyBlacklist* self,
                                                const gchar* blacklist_id,
                                                GVariant* blacklist_template)
{
	const gchar* _tmp3_;
	GHashTable* _tmp4_;
	gconstpointer _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (blacklist_id != NULL);
	g_return_if_fail (blacklist_template != NULL);
	{
		ZeitgeistEvent* ev = NULL;
		ZeitgeistEvent* _tmp0_;
		_tmp0_ = zeitgeist_event_new_from_variant (blacklist_template, &_inner_error0_);
		ev = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_signal_emit (self, security_privacy_blacklist_signals[SECURITY_PRIVACY_BLACKLIST_TEMPLATE_REMOVED_SIGNAL], 0, blacklist_id, ev);
		_g_object_unref0 (ev);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_critical ("BlackList.vala:145: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp3_ = self->priv->incognito_id;
	if (g_strcmp0 (blacklist_id, _tmp3_) == 0) {
		g_signal_emit (self, security_privacy_blacklist_signals[SECURITY_PRIVACY_BLACKLIST_INCOGNITO_TOGGLED_SIGNAL], 0, FALSE);
	}
	_tmp4_ = self->priv->blacklists;
	_tmp5_ = g_hash_table_lookup (_tmp4_, blacklist_id);
	if (((ZeitgeistEvent*) _tmp5_) != NULL) {
		GHashTable* _tmp6_;
		_tmp6_ = self->priv->blacklists;
		g_hash_table_remove (_tmp6_, blacklist_id);
	}
}

gboolean
security_privacy_blacklist_get_incognito (SecurityPrivacyBlacklist* self)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	GList* _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->blacklists;
	if (_tmp0_ == NULL) {
		GHashTable* _tmp1_;
		GHashTable* _tmp2_;
		_tmp1_ = security_privacy_blacklist_get_templates (self);
		_tmp2_ = _tmp1_;
		_g_hash_table_unref0 (_tmp2_);
	}
	_tmp3_ = security_privacy_blacklist_get_all_templates (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_hash_table_get_values (_tmp4_);
	{
		GList* ev_collection = NULL;
		GList* ev_it = NULL;
		ev_collection = _tmp5_;
		for (ev_it = ev_collection; ev_it != NULL; ev_it = ev_it->next) {
			ZeitgeistEvent* ev = NULL;
			ev = (ZeitgeistEvent*) ev_it->data;
			{
				ZeitgeistEvent* _tmp6_;
				ZeitgeistEvent* _tmp7_;
				_tmp6_ = ev;
				_tmp7_ = self->priv->incognito_event;
				if (security_privacy_utilities_matches_event_template (_tmp6_, _tmp7_)) {
					result = TRUE;
					(ev_collection == NULL) ? NULL : (ev_collection = (g_list_free (ev_collection), NULL));
					return result;
				}
			}
		}
		(ev_collection == NULL) ? NULL : (ev_collection = (g_list_free (ev_collection), NULL));
	}
	result = FALSE;
	return result;
}

static void
security_privacy_blacklist_find_events_data_free (gpointer _data)
{
	SecurityPrivacyBlacklistFindEventsData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->store);
	_security_privacy_blacklist_unref0 (_data_->self);
	g_slice_free (SecurityPrivacyBlacklistFindEventsData, _data_);
}

static gpointer
_security_privacy_blacklist_ref0 (gpointer self)
{
	return self ? security_privacy_blacklist_ref (self) : NULL;
}

void
security_privacy_blacklist_find_events (SecurityPrivacyBlacklist* self,
                                        const gchar* id,
                                        GtkTreeIter* iter,
                                        GtkListStore* store,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	SecurityPrivacyBlacklistFindEventsData* _data_;
	SecurityPrivacyBlacklist* _tmp0_;
	gchar* _tmp1_;
	GtkTreeIter _tmp2_;
	GtkListStore* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (iter != NULL);
	g_return_if_fail (store != NULL);
	_data_ = g_slice_new0 (SecurityPrivacyBlacklistFindEventsData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, security_privacy_blacklist_find_events_data_free);
	_tmp0_ = _security_privacy_blacklist_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	_tmp2_ = *iter;
	_data_->iter = _tmp2_;
	_tmp3_ = _g_object_ref0 (store);
	_g_object_unref0 (_data_->store);
	_data_->store = _tmp3_;
	security_privacy_blacklist_find_events_co (_data_);
}

void
security_privacy_blacklist_find_events_finish (SecurityPrivacyBlacklist* self,
                                               GAsyncResult* _res_)
{
	SecurityPrivacyBlacklistFindEventsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
security_privacy_blacklist_find_events_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	SecurityPrivacyBlacklistFindEventsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	security_privacy_blacklist_find_events_co (_data_);
}

static gboolean
security_privacy_blacklist_find_events_co (SecurityPrivacyBlacklistFindEventsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = zeitgeist_event_new ();
	_data_->event = _data_->_tmp0_;
	zeitgeist_event_set_manifestation (_data_->event, ZEITGEIST_ZG_USER_ACTIVITY);
	_data_->_tmp1_ = g_strdup_printf ("application://%s", _data_->id);
	_data_->_tmp2_ = _data_->_tmp1_;
	zeitgeist_event_set_actor (_data_->event, _data_->_tmp2_);
	_g_free0 (_data_->_tmp2_);
	_data_->_tmp3_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data_->events = _data_->_tmp3_;
	_data_->_tmp4_ = _g_object_ref0 (_data_->event);
	g_ptr_array_add (_data_->events, _data_->_tmp4_);
	_data_->_tmp5_ = zeitgeist_event_new ();
	_data_->event2 = _data_->_tmp5_;
	zeitgeist_event_set_manifestation (_data_->event2, ZEITGEIST_ZG_USER_ACTIVITY);
	_data_->_tmp6_ = zeitgeist_subject_new ();
	_data_->subj = _data_->_tmp6_;
	_data_->_tmp7_ = g_strdup_printf ("application://%s", _data_->id);
	_data_->_tmp8_ = _data_->_tmp7_;
	zeitgeist_subject_set_uri (_data_->subj, _data_->_tmp8_);
	_g_free0 (_data_->_tmp8_);
	zeitgeist_event_add_subject (_data_->event2, _data_->subj);
	_data_->_tmp9_ = _g_object_ref0 (_data_->event2);
	g_ptr_array_add (_data_->events, _data_->_tmp9_);
	{
		_data_->_tmp10_ = _data_->self->priv->log;
		_data_->_tmp11_ = zeitgeist_time_range_new_anytime ();
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp13_ = 0;
		_data_->_state_ = 1;
		zeitgeist_log_find_event_ids (_data_->_tmp10_, _data_->_tmp12_, _data_->events, ZEITGEIST_STORAGE_STATE_ANY, (guint32) 0, ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENTS, NULL, security_privacy_blacklist_find_events_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp14_ = zeitgeist_log_find_event_ids_finish (_data_->_tmp10_, _data_->_res_, &_data_->_tmp13_, &_data_->_inner_error0_);
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp15__length1 = _data_->_tmp13_;
		_g_object_unref0 (_data_->_tmp12_);
		_data_->results = _data_->_tmp15_;
		_data_->results_length1 = _data_->_tmp15__length1;
		_data_->_results_size_ = _data_->results_length1;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->counter = _data_->results_length1 / 100;
		_data_->_tmp16_ = _data_->iter;
		memset (&_data_->_tmp17_, 0, sizeof (GValue));
		g_value_init (&_data_->_tmp17_, G_TYPE_INT);
		g_value_set_int (&_data_->_tmp17_, _data_->counter);
		gtk_list_store_set_value (_data_->store, &_data_->_tmp16_, 5, &_data_->_tmp17_);
		G_IS_VALUE (&_data_->_tmp17_) ? (g_value_unset (&_data_->_tmp17_), NULL) : NULL;
		_data_->results = (g_free (_data_->results), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp18_ = _data_->e;
		_data_->_tmp19_ = _data_->_tmp18_->message;
		g_warning ("BlackList.vala:198: %s", _data_->_tmp19_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->subj);
		_g_object_unref0 (_data_->event2);
		_g_ptr_array_unref0 (_data_->events);
		_g_object_unref0 (_data_->event);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->subj);
	_g_object_unref0 (_data_->event2);
	_g_ptr_array_unref0 (_data_->events);
	_g_object_unref0 (_data_->event);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
security_privacy_blacklist_get_count_for_app (SecurityPrivacyBlacklist* self,
                                              const gchar* app_id,
                                              GtkTreeIter* iter,
                                              GtkListStore* store)
{
	GtkTreeIter _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app_id != NULL);
	g_return_if_fail (iter != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = *iter;
	security_privacy_blacklist_find_events (self, app_id, &_tmp0_, store, NULL, NULL);
}

GHashTable*
security_privacy_blacklist_get_all_templates (SecurityPrivacyBlacklist* self)
{
	GHashTable* result;
	GHashTable* _tmp0_;
	GHashTable* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->blacklists;
	if (_tmp0_ == NULL) {
		GHashTable* _tmp1_;
		GHashTable* _tmp2_;
		_tmp1_ = security_privacy_blacklist_get_templates (self);
		_tmp2_ = _tmp1_;
		_g_hash_table_unref0 (_tmp2_);
	}
	_tmp3_ = self->priv->blacklists;
	result = _tmp3_;
	return result;
}

static void
g_cclosure_user_marshal_VOID__STRING_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_OBJECT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
security_privacy_value_blacklist_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
security_privacy_value_blacklist_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		security_privacy_blacklist_unref (value->data[0].v_pointer);
	}
}

static void
security_privacy_value_blacklist_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = security_privacy_blacklist_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
security_privacy_value_blacklist_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
security_privacy_value_blacklist_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SecurityPrivacyBlacklist * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = security_privacy_blacklist_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
security_privacy_value_blacklist_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	SecurityPrivacyBlacklist ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = security_privacy_blacklist_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
security_privacy_param_spec_blacklist (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	SecurityPrivacyParamSpecBlacklist* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SECURITY_PRIVACY_TYPE_BLACKLIST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
security_privacy_value_get_blacklist (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SECURITY_PRIVACY_TYPE_BLACKLIST), NULL);
	return value->data[0].v_pointer;
}

void
security_privacy_value_set_blacklist (GValue* value,
                                      gpointer v_object)
{
	SecurityPrivacyBlacklist * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SECURITY_PRIVACY_TYPE_BLACKLIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SECURITY_PRIVACY_TYPE_BLACKLIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		security_privacy_blacklist_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		security_privacy_blacklist_unref (old);
	}
}

void
security_privacy_value_take_blacklist (GValue* value,
                                       gpointer v_object)
{
	SecurityPrivacyBlacklist * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SECURITY_PRIVACY_TYPE_BLACKLIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SECURITY_PRIVACY_TYPE_BLACKLIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		security_privacy_blacklist_unref (old);
	}
}

static void
security_privacy_blacklist_class_init (SecurityPrivacyBlacklistClass * klass,
                                       gpointer klass_data)
{
	security_privacy_blacklist_parent_class = g_type_class_peek_parent (klass);
	((SecurityPrivacyBlacklistClass *) klass)->finalize = security_privacy_blacklist_finalize;
	g_type_class_adjust_private_offset (klass, &SecurityPrivacyBlacklist_private_offset);
	security_privacy_blacklist_signals[SECURITY_PRIVACY_BLACKLIST_TEMPLATE_ADDED_SIGNAL] = g_signal_new ("template-added", SECURITY_PRIVACY_TYPE_BLACKLIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_OBJECT, G_TYPE_NONE, 2, G_TYPE_STRING, ZEITGEIST_TYPE_EVENT);
	security_privacy_blacklist_signals[SECURITY_PRIVACY_BLACKLIST_TEMPLATE_REMOVED_SIGNAL] = g_signal_new ("template-removed", SECURITY_PRIVACY_TYPE_BLACKLIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_OBJECT, G_TYPE_NONE, 2, G_TYPE_STRING, ZEITGEIST_TYPE_EVENT);
	security_privacy_blacklist_signals[SECURITY_PRIVACY_BLACKLIST_INCOGNITO_TOGGLED_SIGNAL] = g_signal_new ("incognito-toggled", SECURITY_PRIVACY_TYPE_BLACKLIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

static void
security_privacy_blacklist_instance_init (SecurityPrivacyBlacklist * self,
                                          gpointer klass)
{
	gchar* _tmp0_;
	self->priv = security_privacy_blacklist_get_instance_private (self);
	_tmp0_ = g_strdup ("block-all");
	self->priv->incognito_id = _tmp0_;
	self->ref_count = 1;
}

static void
security_privacy_blacklist_finalize (SecurityPrivacyBlacklist * obj)
{
	SecurityPrivacyBlacklist * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SECURITY_PRIVACY_TYPE_BLACKLIST, SecurityPrivacyBlacklist);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->blacklist);
	_g_hash_table_unref0 (self->priv->blacklists);
	_g_object_unref0 (self->priv->log);
	_g_free0 (self->priv->incognito_id);
	_g_object_unref0 (self->priv->incognito_event);
}

static GType
security_privacy_blacklist_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { security_privacy_value_blacklist_init, security_privacy_value_blacklist_free_value, security_privacy_value_blacklist_copy_value, security_privacy_value_blacklist_peek_pointer, "p", security_privacy_value_blacklist_collect_value, "p", security_privacy_value_blacklist_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SecurityPrivacyBlacklistClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) security_privacy_blacklist_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SecurityPrivacyBlacklist), 0, (GInstanceInitFunc) security_privacy_blacklist_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType security_privacy_blacklist_type_id;
	security_privacy_blacklist_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SecurityPrivacyBlacklist", &g_define_type_info, &g_define_type_fundamental_info, 0);
	SecurityPrivacyBlacklist_private_offset = g_type_add_instance_private (security_privacy_blacklist_type_id, sizeof (SecurityPrivacyBlacklistPrivate));
	return security_privacy_blacklist_type_id;
}

GType
security_privacy_blacklist_get_type (void)
{
	static volatile gsize security_privacy_blacklist_type_id__once = 0;
	if (g_once_init_enter (&security_privacy_blacklist_type_id__once)) {
		GType security_privacy_blacklist_type_id;
		security_privacy_blacklist_type_id = security_privacy_blacklist_get_type_once ();
		g_once_init_leave (&security_privacy_blacklist_type_id__once, security_privacy_blacklist_type_id);
	}
	return security_privacy_blacklist_type_id__once;
}

gpointer
security_privacy_blacklist_ref (gpointer instance)
{
	SecurityPrivacyBlacklist * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
security_privacy_blacklist_unref (gpointer instance)
{
	SecurityPrivacyBlacklist * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SECURITY_PRIVACY_BLACKLIST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
security_privacy_file_type_blacklist_get_instance_private (SecurityPrivacyFileTypeBlacklist* self)
{
	return G_STRUCT_MEMBER_P (self, SecurityPrivacyFileTypeBlacklist_private_offset);
}

static void
_security_privacy_file_type_blacklist_on_blacklist_added_security_privacy_blacklist_template_added (SecurityPrivacyBlacklist* _sender,
                                                                                                    const gchar* blacklist_id,
                                                                                                    ZeitgeistEvent* blacklist_template,
                                                                                                    gpointer self)
{
	security_privacy_file_type_blacklist_on_blacklist_added ((SecurityPrivacyFileTypeBlacklist*) self, blacklist_id, blacklist_template);
}

static void
_security_privacy_file_type_blacklist_on_blacklist_removed_security_privacy_blacklist_template_removed (SecurityPrivacyBlacklist* _sender,
                                                                                                        const gchar* blacklist_id,
                                                                                                        ZeitgeistEvent* blacklist_template,
                                                                                                        gpointer self)
{
	security_privacy_file_type_blacklist_on_blacklist_removed ((SecurityPrivacyFileTypeBlacklist*) self, blacklist_id, blacklist_template);
}

SecurityPrivacyFileTypeBlacklist*
security_privacy_file_type_blacklist_construct (GType object_type,
                                                SecurityPrivacyBlacklist* blacklist_inter)
{
	SecurityPrivacyFileTypeBlacklist* self = NULL;
	SecurityPrivacyBlacklist* _tmp0_;
	SecurityPrivacyBlacklist* _tmp1_;
	SecurityPrivacyBlacklist* _tmp2_;
	GeeHashSet* _tmp3_;
	g_return_val_if_fail (blacklist_inter != NULL, NULL);
	self = (SecurityPrivacyFileTypeBlacklist*) g_type_create_instance (object_type);
	_tmp0_ = _security_privacy_blacklist_ref0 (blacklist_inter);
	_security_privacy_blacklist_unref0 (self->priv->blacklist_interface);
	self->priv->blacklist_interface = _tmp0_;
	_tmp1_ = self->priv->blacklist_interface;
	g_signal_connect (_tmp1_, "template-added", (GCallback) _security_privacy_file_type_blacklist_on_blacklist_added_security_privacy_blacklist_template_added, self);
	_tmp2_ = self->priv->blacklist_interface;
	g_signal_connect (_tmp2_, "template-removed", (GCallback) _security_privacy_file_type_blacklist_on_blacklist_removed_security_privacy_blacklist_template_removed, self);
	_tmp3_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->all_blocked_filetypes);
	self->priv->all_blocked_filetypes = _tmp3_;
	security_privacy_file_type_blacklist_populate_file_types (self);
	return self;
}

SecurityPrivacyFileTypeBlacklist*
security_privacy_file_type_blacklist_new (SecurityPrivacyBlacklist* blacklist_inter)
{
	return security_privacy_file_type_blacklist_construct (SECURITY_PRIVACY_TYPE_FILE_TYPE_BLACKLIST, blacklist_inter);
}

static gchar*
security_privacy_file_type_blacklist_get_name (SecurityPrivacyFileTypeBlacklist* self,
                                               const gchar* interpretation)
{
	gchar** names = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint names_length1;
	gint _names_size_;
	gchar* name = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (interpretation != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (interpretation, "#", 0);
	names = _tmp1_;
	names_length1 = _vala_array_length (_tmp0_);
	_names_size_ = names_length1;
	_tmp2_ = names[names_length1 - 1];
	_tmp3_ = g_utf8_strdown (_tmp2_, (gssize) -1);
	name = _tmp3_;
	_tmp4_ = security_privacy_file_type_blacklist_interpretation_prefix;
	_tmp5_ = g_strdup_printf ("%s%s", _tmp4_, name);
	result = _tmp5_;
	_g_free0 (name);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
security_privacy_file_type_blacklist_populate_file_types (SecurityPrivacyFileTypeBlacklist* self)
{
	SecurityPrivacyBlacklist* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->blacklist_interface;
	_tmp1_ = security_privacy_blacklist_get_all_templates (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_hash_table_get_keys (_tmp2_);
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
		key_collection = _tmp3_;
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			gchar* _tmp4_;
			gchar* key = NULL;
			_tmp4_ = g_strdup ((const gchar*) key_it->data);
			key = _tmp4_;
			{
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				_tmp5_ = key;
				_tmp6_ = security_privacy_file_type_blacklist_interpretation_prefix;
				if (g_str_has_prefix (_tmp5_, _tmp6_)) {
					gchar* inter = NULL;
					SecurityPrivacyBlacklist* _tmp7_;
					GHashTable* _tmp8_;
					GHashTable* _tmp9_;
					const gchar* _tmp10_;
					gconstpointer _tmp11_;
					ZeitgeistSubject* _tmp12_;
					ZeitgeistSubject* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					GeeHashSet* _tmp18_;
					const gchar* _tmp19_;
					_tmp7_ = self->priv->blacklist_interface;
					_tmp8_ = security_privacy_blacklist_get_all_templates (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp10_ = key;
					_tmp11_ = g_hash_table_lookup (_tmp9_, _tmp10_);
					_tmp12_ = zeitgeist_event_get_subject ((ZeitgeistEvent*) _tmp11_, 0);
					_tmp13_ = _tmp12_;
					_tmp14_ = zeitgeist_subject_get_interpretation (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = g_strdup (_tmp15_);
					_tmp17_ = _tmp16_;
					_g_object_unref0 (_tmp13_);
					inter = _tmp17_;
					_tmp18_ = self->priv->all_blocked_filetypes;
					_tmp19_ = inter;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp19_);
					_g_free0 (inter);
				}
				_g_free0 (key);
			}
		}
		(key_collection == NULL) ? NULL : (key_collection = (g_list_free (key_collection), NULL));
	}
}

void
security_privacy_file_type_blacklist_block (SecurityPrivacyFileTypeBlacklist* self,
                                            const gchar* interpretation)
{
	ZeitgeistEvent* ev = NULL;
	ZeitgeistEvent* _tmp0_;
	ZeitgeistSubject* sub = NULL;
	ZeitgeistSubject* _tmp1_;
	SecurityPrivacyBlacklist* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (interpretation != NULL);
	_tmp0_ = zeitgeist_event_new ();
	ev = _tmp0_;
	_tmp1_ = zeitgeist_subject_new ();
	sub = _tmp1_;
	zeitgeist_subject_set_interpretation (sub, interpretation);
	zeitgeist_event_add_subject (ev, sub);
	_tmp2_ = self->priv->blacklist_interface;
	_tmp3_ = security_privacy_file_type_blacklist_get_name (self, interpretation);
	_tmp4_ = _tmp3_;
	security_privacy_blacklist_add_template (_tmp2_, _tmp4_, ev);
	_g_free0 (_tmp4_);
	_g_object_unref0 (sub);
	_g_object_unref0 (ev);
}

void
security_privacy_file_type_blacklist_unblock (SecurityPrivacyFileTypeBlacklist* self,
                                              const gchar* interpretation)
{
	SecurityPrivacyBlacklist* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (interpretation != NULL);
	_tmp0_ = self->priv->blacklist_interface;
	_tmp1_ = security_privacy_file_type_blacklist_get_name (self, interpretation);
	_tmp2_ = _tmp1_;
	security_privacy_blacklist_remove_template (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
}

static void
security_privacy_file_type_blacklist_on_blacklist_added (SecurityPrivacyFileTypeBlacklist* self,
                                                         const gchar* blacklist_id,
                                                         ZeitgeistEvent* ev)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (blacklist_id != NULL);
	g_return_if_fail (ev != NULL);
	_tmp0_ = security_privacy_file_type_blacklist_interpretation_prefix;
	if (g_str_has_prefix (blacklist_id, _tmp0_)) {
		GeeHashSet* _tmp1_;
		ZeitgeistSubject* _tmp2_;
		ZeitgeistSubject* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp1_ = self->priv->all_blocked_filetypes;
		_tmp2_ = zeitgeist_event_get_subject (ev, 0);
		_tmp3_ = _tmp2_;
		_tmp4_ = zeitgeist_subject_get_interpretation (_tmp3_);
		_tmp5_ = _tmp4_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp5_);
		_g_object_unref0 (_tmp3_);
	}
}

static void
security_privacy_file_type_blacklist_on_blacklist_removed (SecurityPrivacyFileTypeBlacklist* self,
                                                           const gchar* blacklist_id,
                                                           ZeitgeistEvent* ev)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (blacklist_id != NULL);
	g_return_if_fail (ev != NULL);
	_tmp0_ = security_privacy_file_type_blacklist_interpretation_prefix;
	if (g_str_has_prefix (blacklist_id, _tmp0_)) {
		gchar* inter = NULL;
		ZeitgeistSubject* _tmp1_;
		ZeitgeistSubject* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GeeHashSet* _tmp7_;
		const gchar* _tmp8_;
		_tmp1_ = zeitgeist_event_get_subject (ev, 0);
		_tmp2_ = _tmp1_;
		_tmp3_ = zeitgeist_subject_get_interpretation (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp2_);
		inter = _tmp6_;
		_tmp7_ = self->priv->all_blocked_filetypes;
		_tmp8_ = inter;
		if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp7_, _tmp8_) == TRUE) {
			GeeHashSet* _tmp9_;
			ZeitgeistSubject* _tmp10_;
			ZeitgeistSubject* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp9_ = self->priv->all_blocked_filetypes;
			_tmp10_ = zeitgeist_event_get_subject (ev, 0);
			_tmp11_ = _tmp10_;
			_tmp12_ = zeitgeist_subject_get_interpretation (_tmp11_);
			_tmp13_ = _tmp12_;
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp9_, _tmp13_);
			_g_object_unref0 (_tmp11_);
		}
		_g_free0 (inter);
	}
}

GeeHashSet*
security_privacy_file_type_blacklist_get_all_filetypes (SecurityPrivacyFileTypeBlacklist* self)
{
	GeeHashSet* result;
	GeeHashSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->all_blocked_filetypes;
	result = _tmp0_;
	return result;
}

static void
security_privacy_value_file_type_blacklist_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
security_privacy_value_file_type_blacklist_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		security_privacy_file_type_blacklist_unref (value->data[0].v_pointer);
	}
}

static void
security_privacy_value_file_type_blacklist_copy_value (const GValue* src_value,
                                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = security_privacy_file_type_blacklist_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
security_privacy_value_file_type_blacklist_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
security_privacy_value_file_type_blacklist_collect_value (GValue* value,
                                                          guint n_collect_values,
                                                          GTypeCValue* collect_values,
                                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SecurityPrivacyFileTypeBlacklist * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = security_privacy_file_type_blacklist_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
security_privacy_value_file_type_blacklist_lcopy_value (const GValue* value,
                                                        guint n_collect_values,
                                                        GTypeCValue* collect_values,
                                                        guint collect_flags)
{
	SecurityPrivacyFileTypeBlacklist ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = security_privacy_file_type_blacklist_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
security_privacy_param_spec_file_type_blacklist (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags)
{
	SecurityPrivacyParamSpecFileTypeBlacklist* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SECURITY_PRIVACY_TYPE_FILE_TYPE_BLACKLIST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
security_privacy_value_get_file_type_blacklist (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SECURITY_PRIVACY_TYPE_FILE_TYPE_BLACKLIST), NULL);
	return value->data[0].v_pointer;
}

void
security_privacy_value_set_file_type_blacklist (GValue* value,
                                                gpointer v_object)
{
	SecurityPrivacyFileTypeBlacklist * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SECURITY_PRIVACY_TYPE_FILE_TYPE_BLACKLIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SECURITY_PRIVACY_TYPE_FILE_TYPE_BLACKLIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		security_privacy_file_type_blacklist_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		security_privacy_file_type_blacklist_unref (old);
	}
}

void
security_privacy_value_take_file_type_blacklist (GValue* value,
                                                 gpointer v_object)
{
	SecurityPrivacyFileTypeBlacklist * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SECURITY_PRIVACY_TYPE_FILE_TYPE_BLACKLIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SECURITY_PRIVACY_TYPE_FILE_TYPE_BLACKLIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		security_privacy_file_type_blacklist_unref (old);
	}
}

static void
security_privacy_file_type_blacklist_class_init (SecurityPrivacyFileTypeBlacklistClass * klass,
                                                 gpointer klass_data)
{
	gchar* _tmp0_;
	security_privacy_file_type_blacklist_parent_class = g_type_class_peek_parent (klass);
	((SecurityPrivacyFileTypeBlacklistClass *) klass)->finalize = security_privacy_file_type_blacklist_finalize;
	g_type_class_adjust_private_offset (klass, &SecurityPrivacyFileTypeBlacklist_private_offset);
	_tmp0_ = g_strdup ("interpretation-");
	security_privacy_file_type_blacklist_interpretation_prefix = _tmp0_;
}

static void
security_privacy_file_type_blacklist_instance_init (SecurityPrivacyFileTypeBlacklist * self,
                                                    gpointer klass)
{
	self->priv = security_privacy_file_type_blacklist_get_instance_private (self);
	self->ref_count = 1;
}

static void
security_privacy_file_type_blacklist_finalize (SecurityPrivacyFileTypeBlacklist * obj)
{
	SecurityPrivacyFileTypeBlacklist * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SECURITY_PRIVACY_TYPE_FILE_TYPE_BLACKLIST, SecurityPrivacyFileTypeBlacklist);
	g_signal_handlers_destroy (self);
	_security_privacy_blacklist_unref0 (self->priv->blacklist_interface);
	_g_object_unref0 (self->priv->all_blocked_filetypes);
}

static GType
security_privacy_file_type_blacklist_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { security_privacy_value_file_type_blacklist_init, security_privacy_value_file_type_blacklist_free_value, security_privacy_value_file_type_blacklist_copy_value, security_privacy_value_file_type_blacklist_peek_pointer, "p", security_privacy_value_file_type_blacklist_collect_value, "p", security_privacy_value_file_type_blacklist_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SecurityPrivacyFileTypeBlacklistClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) security_privacy_file_type_blacklist_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SecurityPrivacyFileTypeBlacklist), 0, (GInstanceInitFunc) security_privacy_file_type_blacklist_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType security_privacy_file_type_blacklist_type_id;
	security_privacy_file_type_blacklist_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SecurityPrivacyFileTypeBlacklist", &g_define_type_info, &g_define_type_fundamental_info, 0);
	SecurityPrivacyFileTypeBlacklist_private_offset = g_type_add_instance_private (security_privacy_file_type_blacklist_type_id, sizeof (SecurityPrivacyFileTypeBlacklistPrivate));
	return security_privacy_file_type_blacklist_type_id;
}

GType
security_privacy_file_type_blacklist_get_type (void)
{
	static volatile gsize security_privacy_file_type_blacklist_type_id__once = 0;
	if (g_once_init_enter (&security_privacy_file_type_blacklist_type_id__once)) {
		GType security_privacy_file_type_blacklist_type_id;
		security_privacy_file_type_blacklist_type_id = security_privacy_file_type_blacklist_get_type_once ();
		g_once_init_leave (&security_privacy_file_type_blacklist_type_id__once, security_privacy_file_type_blacklist_type_id);
	}
	return security_privacy_file_type_blacklist_type_id__once;
}

gpointer
security_privacy_file_type_blacklist_ref (gpointer instance)
{
	SecurityPrivacyFileTypeBlacklist * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
security_privacy_file_type_blacklist_unref (gpointer instance)
{
	SecurityPrivacyFileTypeBlacklist * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SECURITY_PRIVACY_FILE_TYPE_BLACKLIST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
security_privacy_path_blacklist_get_instance_private (SecurityPrivacyPathBlacklist* self)
{
	return G_STRUCT_MEMBER_P (self, SecurityPrivacyPathBlacklist_private_offset);
}

static void
_security_privacy_path_blacklist_on_blacklist_added_security_privacy_blacklist_template_added (SecurityPrivacyBlacklist* _sender,
                                                                                               const gchar* blacklist_id,
                                                                                               ZeitgeistEvent* blacklist_template,
                                                                                               gpointer self)
{
	security_privacy_path_blacklist_on_blacklist_added ((SecurityPrivacyPathBlacklist*) self, blacklist_id, blacklist_template);
}

static void
_security_privacy_path_blacklist_on_blacklist_removed_security_privacy_blacklist_template_removed (SecurityPrivacyBlacklist* _sender,
                                                                                                   const gchar* blacklist_id,
                                                                                                   ZeitgeistEvent* blacklist_template,
                                                                                                   gpointer self)
{
	security_privacy_path_blacklist_on_blacklist_removed ((SecurityPrivacyPathBlacklist*) self, blacklist_id, blacklist_template);
}

SecurityPrivacyPathBlacklist*
security_privacy_path_blacklist_construct (GType object_type,
                                           SecurityPrivacyBlacklist* blacklist_inter)
{
	SecurityPrivacyPathBlacklist* self = NULL;
	SecurityPrivacyBlacklist* _tmp0_;
	SecurityPrivacyBlacklist* _tmp1_;
	SecurityPrivacyBlacklist* _tmp2_;
	g_return_val_if_fail (blacklist_inter != NULL, NULL);
	self = (SecurityPrivacyPathBlacklist*) g_type_create_instance (object_type);
	_tmp0_ = _security_privacy_blacklist_ref0 (blacklist_inter);
	_security_privacy_blacklist_unref0 (self->priv->blacklist_interface);
	self->priv->blacklist_interface = _tmp0_;
	_tmp1_ = self->priv->blacklist_interface;
	g_signal_connect (_tmp1_, "template-added", (GCallback) _security_privacy_path_blacklist_on_blacklist_added_security_privacy_blacklist_template_added, self);
	_tmp2_ = self->priv->blacklist_interface;
	g_signal_connect (_tmp2_, "template-removed", (GCallback) _security_privacy_path_blacklist_on_blacklist_removed_security_privacy_blacklist_template_removed, self);
	security_privacy_path_blacklist_get_blocked_folder (self);
	return self;
}

SecurityPrivacyPathBlacklist*
security_privacy_path_blacklist_new (SecurityPrivacyBlacklist* blacklist_inter)
{
	return security_privacy_path_blacklist_construct (SECURITY_PRIVACY_TYPE_PATH_BLACKLIST, blacklist_inter);
}

gboolean
security_privacy_path_blacklist_is_duplicate (SecurityPrivacyPathBlacklist* self,
                                              const gchar* path)
{
	GeeHashSet* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = self->priv->all_blocked_folder;
	result = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, path);
	return result;
}

static void
security_privacy_path_blacklist_get_blocked_folder (SecurityPrivacyPathBlacklist* self)
{
	GeeHashSet* _tmp0_;
	SecurityPrivacyBlacklist* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GList* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->all_blocked_folder);
	self->priv->all_blocked_folder = _tmp0_;
	_tmp1_ = self->priv->blacklist_interface;
	_tmp2_ = security_privacy_blacklist_get_all_templates (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_hash_table_get_keys (_tmp3_);
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
		key_collection = _tmp4_;
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			gchar* _tmp5_;
			gchar* key = NULL;
			_tmp5_ = g_strdup ((const gchar*) key_it->data);
			key = _tmp5_;
			{
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = key;
				_tmp7_ = security_privacy_path_blacklist_folder_prefix;
				if (g_str_has_prefix (_tmp6_, _tmp7_) == TRUE) {
					gchar* folder = NULL;
					SecurityPrivacyBlacklist* _tmp8_;
					GHashTable* _tmp9_;
					GHashTable* _tmp10_;
					const gchar* _tmp11_;
					gconstpointer _tmp12_;
					gchar* _tmp13_;
					const gchar* _tmp14_;
					_tmp8_ = self->priv->blacklist_interface;
					_tmp9_ = security_privacy_blacklist_get_all_templates (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = key;
					_tmp12_ = g_hash_table_lookup (_tmp10_, _tmp11_);
					_tmp13_ = security_privacy_path_blacklist_get_folder (self, (ZeitgeistEvent*) _tmp12_);
					folder = _tmp13_;
					_tmp14_ = folder;
					if (_tmp14_ != NULL) {
						GeeHashSet* _tmp15_;
						const gchar* _tmp16_;
						_tmp15_ = self->priv->all_blocked_folder;
						_tmp16_ = folder;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp16_);
					}
					_g_free0 (folder);
				}
				_g_free0 (key);
			}
		}
		(key_collection == NULL) ? NULL : (key_collection = (g_list_free (key_collection), NULL));
	}
}

static void
security_privacy_path_blacklist_on_blacklist_added (SecurityPrivacyPathBlacklist* self,
                                                    const gchar* blacklist_id,
                                                    ZeitgeistEvent* ev)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (blacklist_id != NULL);
	g_return_if_fail (ev != NULL);
	_tmp0_ = security_privacy_path_blacklist_folder_prefix;
	if (g_str_has_prefix (blacklist_id, _tmp0_)) {
		gchar* uri = NULL;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = security_privacy_path_blacklist_get_folder (self, ev);
		uri = _tmp1_;
		_tmp2_ = uri;
		if (_tmp2_ != NULL) {
			const gchar* _tmp3_;
			GeeHashSet* _tmp4_;
			const gchar* _tmp5_;
			_tmp3_ = uri;
			g_signal_emit (self, security_privacy_path_blacklist_signals[SECURITY_PRIVACY_PATH_BLACKLIST_FOLDER_ADDED_SIGNAL], 0, _tmp3_);
			_tmp4_ = self->priv->all_blocked_folder;
			_tmp5_ = uri;
			if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp4_, _tmp5_) == FALSE) {
				GeeHashSet* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = self->priv->all_blocked_folder;
				_tmp7_ = uri;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp7_);
			}
		}
		_g_free0 (uri);
	}
}

static void
security_privacy_path_blacklist_on_blacklist_removed (SecurityPrivacyPathBlacklist* self,
                                                      const gchar* blacklist_id,
                                                      ZeitgeistEvent* ev)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (blacklist_id != NULL);
	g_return_if_fail (ev != NULL);
	_tmp0_ = security_privacy_path_blacklist_folder_prefix;
	if (g_str_has_prefix (blacklist_id, _tmp0_)) {
		gchar* uri = NULL;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = security_privacy_path_blacklist_get_folder (self, ev);
		uri = _tmp1_;
		_tmp2_ = uri;
		if (_tmp2_ != NULL) {
			const gchar* _tmp3_;
			GeeHashSet* _tmp4_;
			const gchar* _tmp5_;
			_tmp3_ = uri;
			g_signal_emit (self, security_privacy_path_blacklist_signals[SECURITY_PRIVACY_PATH_BLACKLIST_FOLDER_REMOVED_SIGNAL], 0, _tmp3_);
			_tmp4_ = self->priv->all_blocked_folder;
			_tmp5_ = uri;
			if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp4_, _tmp5_) == TRUE) {
				GeeHashSet* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = self->priv->all_blocked_folder;
				_tmp7_ = uri;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp6_, _tmp7_);
			}
		}
		_g_free0 (uri);
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
security_privacy_path_blacklist_get_folder (SecurityPrivacyPathBlacklist* self,
                                            ZeitgeistEvent* ev)
{
	ZeitgeistSubject* sub = NULL;
	ZeitgeistSubject* _tmp0_;
	gchar* uri = NULL;
	ZeitgeistSubject* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GFile* blocked_uri = NULL;
	const gchar* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ev != NULL, NULL);
	_tmp0_ = zeitgeist_event_get_subject (ev, 0);
	sub = _tmp0_;
	_tmp1_ = sub;
	_tmp2_ = zeitgeist_subject_get_uri (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = security_privacy_path_blacklist_suffix;
	_tmp5_ = string_replace (_tmp3_, _tmp4_, "");
	uri = _tmp5_;
	_tmp6_ = uri;
	_tmp7_ = g_file_new_for_uri (_tmp6_);
	blocked_uri = _tmp7_;
	_tmp8_ = blocked_uri;
	if (g_file_query_exists (_tmp8_, NULL) == TRUE) {
		GFile* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = blocked_uri;
		_tmp10_ = g_file_get_path (_tmp9_);
		result = _tmp10_;
		_g_object_unref0 (blocked_uri);
		_g_free0 (uri);
		_g_object_unref0 (sub);
		return result;
	}
	result = NULL;
	_g_object_unref0 (blocked_uri);
	_g_free0 (uri);
	_g_object_unref0 (sub);
	return result;
}

void
security_privacy_path_blacklist_block (SecurityPrivacyPathBlacklist* self,
                                       const gchar* folder)
{
	ZeitgeistEvent* ev = NULL;
	ZeitgeistEvent* _tmp0_;
	ZeitgeistSubject* sub = NULL;
	ZeitgeistSubject* _tmp1_;
	GFile* block_path = NULL;
	GFile* _tmp2_;
	gchar* uri = NULL;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	ZeitgeistSubject* _tmp9_;
	const gchar* _tmp10_;
	ZeitgeistEvent* _tmp11_;
	ZeitgeistSubject* _tmp12_;
	SecurityPrivacyBlacklist* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	ZeitgeistEvent* _tmp17_;
	GeeHashSet* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (folder != NULL);
	_tmp0_ = zeitgeist_event_new ();
	ev = _tmp0_;
	_tmp1_ = zeitgeist_subject_new ();
	sub = _tmp1_;
	_tmp2_ = g_file_new_for_path (folder);
	block_path = _tmp2_;
	_tmp3_ = block_path;
	_tmp4_ = g_file_get_uri (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = security_privacy_path_blacklist_suffix;
	_tmp7_ = g_strdup_printf ("%s%s", _tmp5_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp5_);
	uri = _tmp8_;
	_tmp9_ = sub;
	_tmp10_ = uri;
	zeitgeist_subject_set_uri (_tmp9_, _tmp10_);
	_tmp11_ = ev;
	_tmp12_ = sub;
	zeitgeist_event_add_subject (_tmp11_, _tmp12_);
	_tmp13_ = self->priv->blacklist_interface;
	_tmp14_ = security_privacy_path_blacklist_folder_prefix;
	_tmp15_ = g_strdup_printf ("%s%s", _tmp14_, folder);
	_tmp16_ = _tmp15_;
	_tmp17_ = ev;
	security_privacy_blacklist_add_template (_tmp13_, _tmp16_, _tmp17_);
	_g_free0 (_tmp16_);
	_tmp18_ = self->priv->all_blocked_folder;
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp18_, folder) == FALSE) {
		GeeHashSet* _tmp19_;
		_tmp19_ = self->priv->all_blocked_folder;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, folder);
	}
	_g_free0 (uri);
	_g_object_unref0 (block_path);
	_g_object_unref0 (sub);
	_g_object_unref0 (ev);
}

void
security_privacy_path_blacklist_unblock (SecurityPrivacyPathBlacklist* self,
                                         const gchar* folder)
{
	SecurityPrivacyBlacklist* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GeeHashSet* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (folder != NULL);
	_tmp0_ = self->priv->blacklist_interface;
	_tmp1_ = security_privacy_path_blacklist_folder_prefix;
	_tmp2_ = g_strdup_printf ("%s%s", _tmp1_, folder);
	_tmp3_ = _tmp2_;
	security_privacy_blacklist_remove_template (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->all_blocked_folder;
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp4_, folder) == TRUE) {
		GeeHashSet* _tmp5_;
		_tmp5_ = self->priv->all_blocked_folder;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp5_, folder);
	}
}

GeeHashSet*
security_privacy_path_blacklist_get_all_folders (SecurityPrivacyPathBlacklist* self)
{
	GeeHashSet* result;
	GeeHashSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->all_blocked_folder;
	result = _tmp0_;
	return result;
}

static void
security_privacy_value_path_blacklist_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
security_privacy_value_path_blacklist_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		security_privacy_path_blacklist_unref (value->data[0].v_pointer);
	}
}

static void
security_privacy_value_path_blacklist_copy_value (const GValue* src_value,
                                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = security_privacy_path_blacklist_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
security_privacy_value_path_blacklist_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
security_privacy_value_path_blacklist_collect_value (GValue* value,
                                                     guint n_collect_values,
                                                     GTypeCValue* collect_values,
                                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SecurityPrivacyPathBlacklist * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = security_privacy_path_blacklist_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
security_privacy_value_path_blacklist_lcopy_value (const GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
	SecurityPrivacyPathBlacklist ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = security_privacy_path_blacklist_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
security_privacy_param_spec_path_blacklist (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags)
{
	SecurityPrivacyParamSpecPathBlacklist* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SECURITY_PRIVACY_TYPE_PATH_BLACKLIST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
security_privacy_value_get_path_blacklist (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SECURITY_PRIVACY_TYPE_PATH_BLACKLIST), NULL);
	return value->data[0].v_pointer;
}

void
security_privacy_value_set_path_blacklist (GValue* value,
                                           gpointer v_object)
{
	SecurityPrivacyPathBlacklist * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SECURITY_PRIVACY_TYPE_PATH_BLACKLIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SECURITY_PRIVACY_TYPE_PATH_BLACKLIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		security_privacy_path_blacklist_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		security_privacy_path_blacklist_unref (old);
	}
}

void
security_privacy_value_take_path_blacklist (GValue* value,
                                            gpointer v_object)
{
	SecurityPrivacyPathBlacklist * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SECURITY_PRIVACY_TYPE_PATH_BLACKLIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SECURITY_PRIVACY_TYPE_PATH_BLACKLIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		security_privacy_path_blacklist_unref (old);
	}
}

static void
security_privacy_path_blacklist_class_init (SecurityPrivacyPathBlacklistClass * klass,
                                            gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	security_privacy_path_blacklist_parent_class = g_type_class_peek_parent (klass);
	((SecurityPrivacyPathBlacklistClass *) klass)->finalize = security_privacy_path_blacklist_finalize;
	g_type_class_adjust_private_offset (klass, &SecurityPrivacyPathBlacklist_private_offset);
	security_privacy_path_blacklist_signals[SECURITY_PRIVACY_PATH_BLACKLIST_FOLDER_ADDED_SIGNAL] = g_signal_new ("folder-added", SECURITY_PRIVACY_TYPE_PATH_BLACKLIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	security_privacy_path_blacklist_signals[SECURITY_PRIVACY_PATH_BLACKLIST_FOLDER_REMOVED_SIGNAL] = g_signal_new ("folder-removed", SECURITY_PRIVACY_TYPE_PATH_BLACKLIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	_tmp0_ = g_strdup ("dir-");
	security_privacy_path_blacklist_folder_prefix = _tmp0_;
	_tmp1_ = g_strdup ("/*");
	security_privacy_path_blacklist_suffix = _tmp1_;
}

static void
security_privacy_path_blacklist_instance_init (SecurityPrivacyPathBlacklist * self,
                                               gpointer klass)
{
	self->priv = security_privacy_path_blacklist_get_instance_private (self);
	self->ref_count = 1;
}

static void
security_privacy_path_blacklist_finalize (SecurityPrivacyPathBlacklist * obj)
{
	SecurityPrivacyPathBlacklist * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SECURITY_PRIVACY_TYPE_PATH_BLACKLIST, SecurityPrivacyPathBlacklist);
	g_signal_handlers_destroy (self);
	_security_privacy_blacklist_unref0 (self->priv->blacklist_interface);
	_g_object_unref0 (self->priv->all_blocked_folder);
}

static GType
security_privacy_path_blacklist_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { security_privacy_value_path_blacklist_init, security_privacy_value_path_blacklist_free_value, security_privacy_value_path_blacklist_copy_value, security_privacy_value_path_blacklist_peek_pointer, "p", security_privacy_value_path_blacklist_collect_value, "p", security_privacy_value_path_blacklist_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SecurityPrivacyPathBlacklistClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) security_privacy_path_blacklist_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SecurityPrivacyPathBlacklist), 0, (GInstanceInitFunc) security_privacy_path_blacklist_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType security_privacy_path_blacklist_type_id;
	security_privacy_path_blacklist_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SecurityPrivacyPathBlacklist", &g_define_type_info, &g_define_type_fundamental_info, 0);
	SecurityPrivacyPathBlacklist_private_offset = g_type_add_instance_private (security_privacy_path_blacklist_type_id, sizeof (SecurityPrivacyPathBlacklistPrivate));
	return security_privacy_path_blacklist_type_id;
}

GType
security_privacy_path_blacklist_get_type (void)
{
	static volatile gsize security_privacy_path_blacklist_type_id__once = 0;
	if (g_once_init_enter (&security_privacy_path_blacklist_type_id__once)) {
		GType security_privacy_path_blacklist_type_id;
		security_privacy_path_blacklist_type_id = security_privacy_path_blacklist_get_type_once ();
		g_once_init_leave (&security_privacy_path_blacklist_type_id__once, security_privacy_path_blacklist_type_id);
	}
	return security_privacy_path_blacklist_type_id__once;
}

gpointer
security_privacy_path_blacklist_ref (gpointer instance)
{
	SecurityPrivacyPathBlacklist * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
security_privacy_path_blacklist_unref (gpointer instance)
{
	SecurityPrivacyPathBlacklist * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SECURITY_PRIVACY_PATH_BLACKLIST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
security_privacy_application_blacklist_get_instance_private (SecurityPrivacyApplicationBlacklist* self)
{
	return G_STRUCT_MEMBER_P (self, SecurityPrivacyApplicationBlacklist_private_offset);
}

static void
_security_privacy_application_blacklist_on_blacklist_added_security_privacy_blacklist_template_added (SecurityPrivacyBlacklist* _sender,
                                                                                                      const gchar* blacklist_id,
                                                                                                      ZeitgeistEvent* blacklist_template,
                                                                                                      gpointer self)
{
	security_privacy_application_blacklist_on_blacklist_added ((SecurityPrivacyApplicationBlacklist*) self, blacklist_id, blacklist_template);
}

static void
_security_privacy_application_blacklist_on_blacklist_removed_security_privacy_blacklist_template_removed (SecurityPrivacyBlacklist* _sender,
                                                                                                          const gchar* blacklist_id,
                                                                                                          ZeitgeistEvent* blacklist_template,
                                                                                                          gpointer self)
{
	security_privacy_application_blacklist_on_blacklist_removed ((SecurityPrivacyApplicationBlacklist*) self, blacklist_id, blacklist_template);
}

SecurityPrivacyApplicationBlacklist*
security_privacy_application_blacklist_construct (GType object_type,
                                                  SecurityPrivacyBlacklist* blacklist)
{
	SecurityPrivacyApplicationBlacklist* self = NULL;
	SecurityPrivacyBlacklist* _tmp0_;
	SecurityPrivacyBlacklist* _tmp1_;
	SecurityPrivacyBlacklist* _tmp2_;
	GeeHashSet* _tmp3_;
	GeeHashSet* _tmp4_;
	g_return_val_if_fail (blacklist != NULL, NULL);
	self = (SecurityPrivacyApplicationBlacklist*) g_type_create_instance (object_type);
	_tmp0_ = _security_privacy_blacklist_ref0 (blacklist);
	_security_privacy_blacklist_unref0 (self->priv->blacklist_interface);
	self->priv->blacklist_interface = _tmp0_;
	_tmp1_ = self->priv->blacklist_interface;
	g_signal_connect (_tmp1_, "template-added", (GCallback) _security_privacy_application_blacklist_on_blacklist_added_security_privacy_blacklist_template_added, self);
	_tmp2_ = self->priv->blacklist_interface;
	g_signal_connect (_tmp2_, "template-removed", (GCallback) _security_privacy_application_blacklist_on_blacklist_removed_security_privacy_blacklist_template_removed, self);
	_tmp3_ = security_privacy_application_blacklist_get_blocked_apps (self);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp4_);
	return self;
}

SecurityPrivacyApplicationBlacklist*
security_privacy_application_blacklist_new (SecurityPrivacyBlacklist* blacklist)
{
	return security_privacy_application_blacklist_construct (SECURITY_PRIVACY_TYPE_APPLICATION_BLACKLIST, blacklist);
}

void
security_privacy_application_blacklist_get_count_for_app (SecurityPrivacyApplicationBlacklist* self,
                                                          const gchar* id,
                                                          GtkTreeIter* iter,
                                                          GtkListStore* store)
{
	SecurityPrivacyBlacklist* _tmp0_;
	GtkTreeIter _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (iter != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = self->priv->blacklist_interface;
	_tmp1_ = *iter;
	security_privacy_blacklist_get_count_for_app (_tmp0_, id, &_tmp1_, store);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static GeeHashSet*
security_privacy_application_blacklist_get_blocked_apps (SecurityPrivacyApplicationBlacklist* self)
{
	GeeHashSet* _tmp0_;
	SecurityPrivacyBlacklist* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GList* _tmp4_;
	GeeHashSet* _tmp12_;
	GeeHashSet* _tmp13_;
	GeeHashSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->all_blocked_apps);
	self->priv->all_blocked_apps = _tmp0_;
	_tmp1_ = self->priv->blacklist_interface;
	_tmp2_ = security_privacy_blacklist_get_all_templates (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_hash_table_get_keys (_tmp3_);
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
		key_collection = _tmp4_;
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			gchar* _tmp5_;
			gchar* key = NULL;
			_tmp5_ = g_strdup ((const gchar*) key_it->data);
			key = _tmp5_;
			{
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = key;
				_tmp7_ = security_privacy_application_blacklist_interpretation_prefix;
				if (g_str_has_prefix (_tmp6_, _tmp7_) == TRUE) {
					gchar* app = NULL;
					const gchar* _tmp8_;
					gchar* _tmp9_;
					GeeHashSet* _tmp10_;
					const gchar* _tmp11_;
					_tmp8_ = key;
					_tmp9_ = string_substring (_tmp8_, (glong) 4, (glong) -1);
					app = _tmp9_;
					_tmp10_ = self->priv->all_blocked_apps;
					_tmp11_ = app;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
					_g_free0 (app);
				}
				_g_free0 (key);
			}
		}
		(key_collection == NULL) ? NULL : (key_collection = (g_list_free (key_collection), NULL));
	}
	_tmp12_ = self->priv->all_blocked_apps;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	result = _tmp13_;
	return result;
}

static void
security_privacy_application_blacklist_on_blacklist_added (SecurityPrivacyApplicationBlacklist* self,
                                                           const gchar* blacklist_id,
                                                           ZeitgeistEvent* ev)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (blacklist_id != NULL);
	g_return_if_fail (ev != NULL);
	_tmp0_ = security_privacy_application_blacklist_interpretation_prefix;
	if (g_str_has_prefix (blacklist_id, _tmp0_) == TRUE) {
		gchar* app = NULL;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		GeeHashSet* _tmp3_;
		GeeHashSet* _tmp4_;
		const gchar* _tmp5_;
		_tmp1_ = string_substring (blacklist_id, (glong) 4, (glong) -1);
		app = _tmp1_;
		_tmp2_ = app;
		g_signal_emit (self, security_privacy_application_blacklist_signals[SECURITY_PRIVACY_APPLICATION_BLACKLIST_APPLICATION_ADDED_SIGNAL], 0, _tmp2_, ev);
		_tmp3_ = security_privacy_application_blacklist_get_all_apps (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = app;
		if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp4_, _tmp5_) == FALSE) {
			GeeHashSet* _tmp6_;
			GeeHashSet* _tmp7_;
			const gchar* _tmp8_;
			_tmp6_ = security_privacy_application_blacklist_get_all_apps (self);
			_tmp7_ = _tmp6_;
			_tmp8_ = app;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp8_);
		}
		_g_free0 (app);
	}
}

static void
security_privacy_application_blacklist_on_blacklist_removed (SecurityPrivacyApplicationBlacklist* self,
                                                             const gchar* blacklist_id,
                                                             ZeitgeistEvent* ev)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (blacklist_id != NULL);
	g_return_if_fail (ev != NULL);
	_tmp0_ = security_privacy_application_blacklist_interpretation_prefix;
	if (g_str_has_prefix (blacklist_id, _tmp0_) == TRUE) {
		gchar* app = NULL;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		GeeHashSet* _tmp3_;
		GeeHashSet* _tmp4_;
		const gchar* _tmp5_;
		_tmp1_ = string_substring (blacklist_id, (glong) 4, (glong) -1);
		app = _tmp1_;
		_tmp2_ = app;
		g_signal_emit (self, security_privacy_application_blacklist_signals[SECURITY_PRIVACY_APPLICATION_BLACKLIST_APPLICATION_REMOVED_SIGNAL], 0, _tmp2_, ev);
		_tmp3_ = security_privacy_application_blacklist_get_all_apps (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = app;
		if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp4_, _tmp5_) == TRUE) {
			GeeHashSet* _tmp6_;
			GeeHashSet* _tmp7_;
			const gchar* _tmp8_;
			_tmp6_ = security_privacy_application_blacklist_get_all_apps (self);
			_tmp7_ = _tmp6_;
			_tmp8_ = app;
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp7_, _tmp8_);
		}
		_g_free0 (app);
	}
}

void
security_privacy_application_blacklist_block (SecurityPrivacyApplicationBlacklist* self,
                                              const gchar* application)
{
	ZeitgeistEvent* ev = NULL;
	ZeitgeistEvent* _tmp0_;
	ZeitgeistEvent* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ZeitgeistSubject* sub = NULL;
	ZeitgeistSubject* _tmp4_;
	ZeitgeistEvent* _tmp5_;
	ZeitgeistSubject* _tmp6_;
	ZeitgeistEvent* launch_ev = NULL;
	ZeitgeistEvent* _tmp7_;
	ZeitgeistSubject* launch_sub = NULL;
	ZeitgeistSubject* _tmp8_;
	ZeitgeistSubject* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	ZeitgeistEvent* _tmp12_;
	ZeitgeistSubject* _tmp13_;
	SecurityPrivacyBlacklist* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	ZeitgeistEvent* _tmp18_;
	SecurityPrivacyBlacklist* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	ZeitgeistEvent* _tmp23_;
	GeeHashSet* _tmp24_;
	GeeHashSet* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (application != NULL);
	_tmp0_ = zeitgeist_event_new ();
	ev = _tmp0_;
	_tmp1_ = ev;
	_tmp2_ = g_strdup_printf ("application://%s", application);
	_tmp3_ = _tmp2_;
	zeitgeist_event_set_actor (_tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = zeitgeist_subject_new ();
	sub = _tmp4_;
	_tmp5_ = ev;
	_tmp6_ = sub;
	zeitgeist_event_add_subject (_tmp5_, _tmp6_);
	_tmp7_ = zeitgeist_event_new ();
	launch_ev = _tmp7_;
	_tmp8_ = zeitgeist_subject_new ();
	launch_sub = _tmp8_;
	_tmp9_ = launch_sub;
	_tmp10_ = g_strdup_printf ("application://%s", application);
	_tmp11_ = _tmp10_;
	zeitgeist_subject_set_uri (_tmp9_, _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = launch_ev;
	_tmp13_ = launch_sub;
	zeitgeist_event_add_subject (_tmp12_, _tmp13_);
	_tmp14_ = self->priv->blacklist_interface;
	_tmp15_ = security_privacy_application_blacklist_interpretation_prefix;
	_tmp16_ = g_strdup_printf ("%s%s", _tmp15_, application);
	_tmp17_ = _tmp16_;
	_tmp18_ = ev;
	security_privacy_blacklist_add_template (_tmp14_, _tmp17_, _tmp18_);
	_g_free0 (_tmp17_);
	_tmp19_ = self->priv->blacklist_interface;
	_tmp20_ = security_privacy_application_blacklist_launcher_prefix;
	_tmp21_ = g_strdup_printf ("%s%s", _tmp20_, application);
	_tmp22_ = _tmp21_;
	_tmp23_ = launch_ev;
	security_privacy_blacklist_add_template (_tmp19_, _tmp22_, _tmp23_);
	_g_free0 (_tmp22_);
	_tmp24_ = security_privacy_application_blacklist_get_all_apps (self);
	_tmp25_ = _tmp24_;
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp25_, application) == FALSE) {
		GeeHashSet* _tmp26_;
		GeeHashSet* _tmp27_;
		_tmp26_ = security_privacy_application_blacklist_get_all_apps (self);
		_tmp27_ = _tmp26_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, application);
	}
	_g_object_unref0 (launch_sub);
	_g_object_unref0 (launch_ev);
	_g_object_unref0 (sub);
	_g_object_unref0 (ev);
}

void
security_privacy_application_blacklist_unblock (SecurityPrivacyApplicationBlacklist* self,
                                                const gchar* application)
{
	SecurityPrivacyBlacklist* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	SecurityPrivacyBlacklist* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GeeHashSet* _tmp8_;
	GeeHashSet* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (application != NULL);
	_tmp0_ = self->priv->blacklist_interface;
	_tmp1_ = security_privacy_application_blacklist_interpretation_prefix;
	_tmp2_ = g_strdup_printf ("%s%s", _tmp1_, application);
	_tmp3_ = _tmp2_;
	security_privacy_blacklist_remove_template (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->blacklist_interface;
	_tmp5_ = security_privacy_application_blacklist_launcher_prefix;
	_tmp6_ = g_strdup_printf ("%s%s", _tmp5_, application);
	_tmp7_ = _tmp6_;
	security_privacy_blacklist_remove_template (_tmp4_, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = security_privacy_application_blacklist_get_all_apps (self);
	_tmp9_ = _tmp8_;
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp9_, application) == TRUE) {
		GeeHashSet* _tmp10_;
		GeeHashSet* _tmp11_;
		_tmp10_ = security_privacy_application_blacklist_get_all_apps (self);
		_tmp11_ = _tmp10_;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp11_, application);
	}
}

GeeHashSet*
security_privacy_application_blacklist_get_all_apps (SecurityPrivacyApplicationBlacklist* self)
{
	GeeHashSet* result;
	GeeHashSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->all_blocked_apps;
	result = _tmp0_;
	return result;
}

static void
security_privacy_value_application_blacklist_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
security_privacy_value_application_blacklist_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		security_privacy_application_blacklist_unref (value->data[0].v_pointer);
	}
}

static void
security_privacy_value_application_blacklist_copy_value (const GValue* src_value,
                                                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = security_privacy_application_blacklist_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
security_privacy_value_application_blacklist_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
security_privacy_value_application_blacklist_collect_value (GValue* value,
                                                            guint n_collect_values,
                                                            GTypeCValue* collect_values,
                                                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SecurityPrivacyApplicationBlacklist * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = security_privacy_application_blacklist_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
security_privacy_value_application_blacklist_lcopy_value (const GValue* value,
                                                          guint n_collect_values,
                                                          GTypeCValue* collect_values,
                                                          guint collect_flags)
{
	SecurityPrivacyApplicationBlacklist ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = security_privacy_application_blacklist_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
security_privacy_param_spec_application_blacklist (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags)
{
	SecurityPrivacyParamSpecApplicationBlacklist* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SECURITY_PRIVACY_TYPE_APPLICATION_BLACKLIST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
security_privacy_value_get_application_blacklist (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SECURITY_PRIVACY_TYPE_APPLICATION_BLACKLIST), NULL);
	return value->data[0].v_pointer;
}

void
security_privacy_value_set_application_blacklist (GValue* value,
                                                  gpointer v_object)
{
	SecurityPrivacyApplicationBlacklist * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SECURITY_PRIVACY_TYPE_APPLICATION_BLACKLIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SECURITY_PRIVACY_TYPE_APPLICATION_BLACKLIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		security_privacy_application_blacklist_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		security_privacy_application_blacklist_unref (old);
	}
}

void
security_privacy_value_take_application_blacklist (GValue* value,
                                                   gpointer v_object)
{
	SecurityPrivacyApplicationBlacklist * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SECURITY_PRIVACY_TYPE_APPLICATION_BLACKLIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SECURITY_PRIVACY_TYPE_APPLICATION_BLACKLIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		security_privacy_application_blacklist_unref (old);
	}
}

static void
security_privacy_application_blacklist_class_init (SecurityPrivacyApplicationBlacklistClass * klass,
                                                   gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	security_privacy_application_blacklist_parent_class = g_type_class_peek_parent (klass);
	((SecurityPrivacyApplicationBlacklistClass *) klass)->finalize = security_privacy_application_blacklist_finalize;
	g_type_class_adjust_private_offset (klass, &SecurityPrivacyApplicationBlacklist_private_offset);
	security_privacy_application_blacklist_signals[SECURITY_PRIVACY_APPLICATION_BLACKLIST_APPLICATION_ADDED_SIGNAL] = g_signal_new ("application-added", SECURITY_PRIVACY_TYPE_APPLICATION_BLACKLIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_OBJECT, G_TYPE_NONE, 2, G_TYPE_STRING, ZEITGEIST_TYPE_EVENT);
	security_privacy_application_blacklist_signals[SECURITY_PRIVACY_APPLICATION_BLACKLIST_APPLICATION_REMOVED_SIGNAL] = g_signal_new ("application-removed", SECURITY_PRIVACY_TYPE_APPLICATION_BLACKLIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_OBJECT, G_TYPE_NONE, 2, G_TYPE_STRING, ZEITGEIST_TYPE_EVENT);
	_tmp0_ = g_strdup ("app-");
	security_privacy_application_blacklist_interpretation_prefix = _tmp0_;
	_tmp1_ = g_strdup ("launch-");
	security_privacy_application_blacklist_launcher_prefix = _tmp1_;
}

static void
security_privacy_application_blacklist_instance_init (SecurityPrivacyApplicationBlacklist * self,
                                                      gpointer klass)
{
	self->priv = security_privacy_application_blacklist_get_instance_private (self);
	self->ref_count = 1;
}

static void
security_privacy_application_blacklist_finalize (SecurityPrivacyApplicationBlacklist * obj)
{
	SecurityPrivacyApplicationBlacklist * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SECURITY_PRIVACY_TYPE_APPLICATION_BLACKLIST, SecurityPrivacyApplicationBlacklist);
	g_signal_handlers_destroy (self);
	_security_privacy_blacklist_unref0 (self->priv->blacklist_interface);
	_g_object_unref0 (self->priv->all_blocked_apps);
}

static GType
security_privacy_application_blacklist_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { security_privacy_value_application_blacklist_init, security_privacy_value_application_blacklist_free_value, security_privacy_value_application_blacklist_copy_value, security_privacy_value_application_blacklist_peek_pointer, "p", security_privacy_value_application_blacklist_collect_value, "p", security_privacy_value_application_blacklist_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SecurityPrivacyApplicationBlacklistClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) security_privacy_application_blacklist_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SecurityPrivacyApplicationBlacklist), 0, (GInstanceInitFunc) security_privacy_application_blacklist_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType security_privacy_application_blacklist_type_id;
	security_privacy_application_blacklist_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SecurityPrivacyApplicationBlacklist", &g_define_type_info, &g_define_type_fundamental_info, 0);
	SecurityPrivacyApplicationBlacklist_private_offset = g_type_add_instance_private (security_privacy_application_blacklist_type_id, sizeof (SecurityPrivacyApplicationBlacklistPrivate));
	return security_privacy_application_blacklist_type_id;
}

GType
security_privacy_application_blacklist_get_type (void)
{
	static volatile gsize security_privacy_application_blacklist_type_id__once = 0;
	if (g_once_init_enter (&security_privacy_application_blacklist_type_id__once)) {
		GType security_privacy_application_blacklist_type_id;
		security_privacy_application_blacklist_type_id = security_privacy_application_blacklist_get_type_once ();
		g_once_init_leave (&security_privacy_application_blacklist_type_id__once, security_privacy_application_blacklist_type_id);
	}
	return security_privacy_application_blacklist_type_id__once;
}

gpointer
security_privacy_application_blacklist_ref (gpointer instance)
{
	SecurityPrivacyApplicationBlacklist * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
security_privacy_application_blacklist_unref (gpointer instance)
{
	SecurityPrivacyApplicationBlacklist * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SECURITY_PRIVACY_APPLICATION_BLACKLIST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

