/* Token.c generated by valac 0.56.17, the Vala compiler
 * generated from Token.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2015 Adam Bieńkowski (https://launchpad.net/switchboard-plug-parental-controls)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 * Authored by: Adam Bieńkowski <donadigos159@gmail.com>
 */

#include "screentime-limits.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#define PC_PAM_TOKEN_SERVICES_INDEX 0
#define PC_PAM_TOKEN_TTYS_INDEX 1
#define PC_PAM_TOKEN_USERS_INDEX 2
#define PC_PAM_TOKEN_TIMES_INDEX 3
#define PC_PAM_TOKEN_TYPE_SEPARATOR ";"
#define PC_PAM_TOKEN_LIST_SEPARATOR "|"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _PCPAMParamSpecTimeInfo PCPAMParamSpecTimeInfo;
enum  {
	PC_PAM_TOKEN_0_PROPERTY,
	PC_PAM_TOKEN_NUM_PROPERTIES
};
static GParamSpec* pc_pam_token_properties[PC_PAM_TOKEN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _pc_pam_time_info_unref0(var) ((var == NULL) ? NULL : (var = (pc_pam_time_info_unref (var), NULL)))

struct _PCPAMParamSpecTimeInfo {
	GParamSpec parent_instance;
};

static gpointer pc_pam_time_info_parent_class = NULL;
static gpointer pc_pam_token_parent_class = NULL;

static void pc_pam_time_info_finalize (PCPAMTimeInfo * obj);
static GType pc_pam_time_info_get_type_once (void);
static void pc_pam_token_finalize (GObject * obj);
static GType pc_pam_token_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

PCPAMDayType
pc_pam_day_type_to_enum (const gchar* str)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	PCPAMDayType result;
	g_return_val_if_fail (str != NULL, 0);
	_tmp0_ = str;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("Al")))) {
		switch (0) {
			default:
			{
				result = PC_PAM_DAY_TYPE_ALL;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("Wk")))) {
		switch (0) {
			default:
			{
				result = PC_PAM_DAY_TYPE_WEEKDAY;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("Wd")))) {
		switch (0) {
			default:
			{
				result = PC_PAM_DAY_TYPE_WEEKEND;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = PC_PAM_DAY_TYPE_UNKNOWN;
				return result;
			}
		}
	}
}

gchar*
pc_pam_day_type_to_string (PCPAMDayType self)
{
	gchar* result;
	switch (self) {
		case PC_PAM_DAY_TYPE_ALL:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("Al");
			result = _tmp0_;
			return result;
		}
		case PC_PAM_DAY_TYPE_WEEKDAY:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("Wk");
			result = _tmp1_;
			return result;
		}
		case PC_PAM_DAY_TYPE_WEEKEND:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("Wd");
			result = _tmp2_;
			return result;
		}
		default:
		case PC_PAM_DAY_TYPE_UNKNOWN:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("unknown");
			result = _tmp3_;
			return result;
		}
	}
}

static GType
pc_pam_day_type_get_type_once (void)
{
	static const GEnumValue values[] = {{PC_PAM_DAY_TYPE_UNKNOWN, "PC_PAM_DAY_TYPE_UNKNOWN", "unknown"}, {PC_PAM_DAY_TYPE_ALL, "PC_PAM_DAY_TYPE_ALL", "all"}, {PC_PAM_DAY_TYPE_WEEKDAY, "PC_PAM_DAY_TYPE_WEEKDAY", "weekday"}, {PC_PAM_DAY_TYPE_WEEKEND, "PC_PAM_DAY_TYPE_WEEKEND", "weekend"}, {0, NULL, NULL}};
	GType pc_pam_day_type_type_id;
	pc_pam_day_type_type_id = g_enum_register_static ("PCPAMDayType", values);
	return pc_pam_day_type_type_id;
}

GType
pc_pam_day_type_get_type (void)
{
	static volatile gsize pc_pam_day_type_type_id__once = 0;
	if (g_once_init_enter (&pc_pam_day_type_type_id__once)) {
		GType pc_pam_day_type_type_id;
		pc_pam_day_type_type_id = pc_pam_day_type_get_type_once ();
		g_once_init_leave (&pc_pam_day_type_type_id__once, pc_pam_day_type_type_id);
	}
	return pc_pam_day_type_type_id__once;
}

PCPAMTimeInfo*
pc_pam_time_info_construct (GType object_type)
{
	PCPAMTimeInfo* self = NULL;
	self = (PCPAMTimeInfo*) g_type_create_instance (object_type);
	return self;
}

PCPAMTimeInfo*
pc_pam_time_info_new (void)
{
	return pc_pam_time_info_construct (PC_PAM_TYPE_TIME_INFO);
}

static void
pc_pam_value_time_info_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
pc_pam_value_time_info_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		pc_pam_time_info_unref (value->data[0].v_pointer);
	}
}

static void
pc_pam_value_time_info_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = pc_pam_time_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
pc_pam_value_time_info_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
pc_pam_value_time_info_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PCPAMTimeInfo * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = pc_pam_time_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
pc_pam_value_time_info_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	PCPAMTimeInfo ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = pc_pam_time_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
pc_pam_param_spec_time_info (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	PCPAMParamSpecTimeInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PC_PAM_TYPE_TIME_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
pc_pam_value_get_time_info (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PC_PAM_TYPE_TIME_INFO), NULL);
	return value->data[0].v_pointer;
}

void
pc_pam_value_set_time_info (GValue* value,
                            gpointer v_object)
{
	PCPAMTimeInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PC_PAM_TYPE_TIME_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PC_PAM_TYPE_TIME_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		pc_pam_time_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pc_pam_time_info_unref (old);
	}
}

void
pc_pam_value_take_time_info (GValue* value,
                             gpointer v_object)
{
	PCPAMTimeInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PC_PAM_TYPE_TIME_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PC_PAM_TYPE_TIME_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pc_pam_time_info_unref (old);
	}
}

static void
pc_pam_time_info_class_init (PCPAMTimeInfoClass * klass,
                             gpointer klass_data)
{
	pc_pam_time_info_parent_class = g_type_class_peek_parent (klass);
	((PCPAMTimeInfoClass *) klass)->finalize = pc_pam_time_info_finalize;
}

static void
pc_pam_time_info_instance_init (PCPAMTimeInfo * self,
                                gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->day_type = PC_PAM_DAY_TYPE_UNKNOWN;
	_tmp0_ = g_strdup ("");
	self->from = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->to = _tmp1_;
	self->ref_count = 1;
}

static void
pc_pam_time_info_finalize (PCPAMTimeInfo * obj)
{
	PCPAMTimeInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PC_PAM_TYPE_TIME_INFO, PCPAMTimeInfo);
	g_signal_handlers_destroy (self);
	_g_free0 (self->from);
	_g_free0 (self->to);
}

static GType
pc_pam_time_info_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { pc_pam_value_time_info_init, pc_pam_value_time_info_free_value, pc_pam_value_time_info_copy_value, pc_pam_value_time_info_peek_pointer, "p", pc_pam_value_time_info_collect_value, "p", pc_pam_value_time_info_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PCPAMTimeInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pc_pam_time_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PCPAMTimeInfo), 0, (GInstanceInitFunc) pc_pam_time_info_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType pc_pam_time_info_type_id;
	pc_pam_time_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PCPAMTimeInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return pc_pam_time_info_type_id;
}

GType
pc_pam_time_info_get_type (void)
{
	static volatile gsize pc_pam_time_info_type_id__once = 0;
	if (g_once_init_enter (&pc_pam_time_info_type_id__once)) {
		GType pc_pam_time_info_type_id;
		pc_pam_time_info_type_id = pc_pam_time_info_get_type_once ();
		g_once_init_leave (&pc_pam_time_info_type_id__once, pc_pam_time_info_type_id);
	}
	return pc_pam_time_info_type_id__once;
}

gpointer
pc_pam_time_info_ref (gpointer instance)
{
	PCPAMTimeInfo * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
pc_pam_time_info_unref (gpointer instance)
{
	PCPAMTimeInfo * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PC_PAM_TIME_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

PCPAMToken*
pc_pam_token_parse_line (const gchar* line)
{
	gchar** strv = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint strv_length1;
	gint _strv_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	PCPAMToken* token = NULL;
	PCPAMToken* _tmp3_;
	PCPAMToken* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	PCPAMToken* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	PCPAMToken* _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	const gchar* _tmp16_;
	gchar** _tmp17_;
	gchar** _tmp18_;
	PCPAMToken* _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	const gchar* _tmp21_;
	gchar** _tmp22_;
	gchar** _tmp23_;
	PCPAMToken* result;
	g_return_val_if_fail (line != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (line, PC_PAM_TOKEN_TYPE_SEPARATOR, 0);
	strv = _tmp1_;
	strv_length1 = _vala_array_length (_tmp0_);
	_strv_size_ = strv_length1;
	_tmp2_ = strv;
	_tmp2__length1 = strv_length1;
	if (_tmp2__length1 != 4) {
		result = NULL;
		strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp3_ = pc_pam_token_new ();
	token = _tmp3_;
	_tmp4_ = token;
	_tmp5_ = strv;
	_tmp5__length1 = strv_length1;
	_tmp6_ = _tmp5_[PC_PAM_TOKEN_SERVICES_INDEX];
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, PC_PAM_TOKEN_LIST_SEPARATOR, 0);
	_tmp4_->services = (_vala_array_free (_tmp4_->services, _tmp4_->services_length1, (GDestroyNotify) g_free), NULL);
	_tmp4_->services = _tmp8_;
	_tmp4_->services_length1 = _vala_array_length (_tmp7_);
	_tmp9_ = token;
	_tmp10_ = strv;
	_tmp10__length1 = strv_length1;
	_tmp11_ = _tmp10_[PC_PAM_TOKEN_TTYS_INDEX];
	_tmp13_ = _tmp12_ = g_strsplit (_tmp11_, PC_PAM_TOKEN_LIST_SEPARATOR, 0);
	_tmp9_->ttys = (_vala_array_free (_tmp9_->ttys, _tmp9_->ttys_length1, (GDestroyNotify) g_free), NULL);
	_tmp9_->ttys = _tmp13_;
	_tmp9_->ttys_length1 = _vala_array_length (_tmp12_);
	_tmp14_ = token;
	_tmp15_ = strv;
	_tmp15__length1 = strv_length1;
	_tmp16_ = _tmp15_[PC_PAM_TOKEN_USERS_INDEX];
	_tmp18_ = _tmp17_ = g_strsplit (_tmp16_, PC_PAM_TOKEN_LIST_SEPARATOR, 0);
	_tmp14_->users = (_vala_array_free (_tmp14_->users, _tmp14_->users_length1, (GDestroyNotify) g_free), NULL);
	_tmp14_->users = _tmp18_;
	_tmp14_->users_length1 = _vala_array_length (_tmp17_);
	_tmp19_ = token;
	_tmp20_ = strv;
	_tmp20__length1 = strv_length1;
	_tmp21_ = _tmp20_[PC_PAM_TOKEN_TIMES_INDEX];
	_tmp23_ = _tmp22_ = g_strsplit (_tmp21_, PC_PAM_TOKEN_LIST_SEPARATOR, 0);
	_tmp19_->times = (_vala_array_free (_tmp19_->times, _tmp19_->times_length1, (GDestroyNotify) g_free), NULL);
	_tmp19_->times = _tmp23_;
	_tmp19_->times_length1 = _vala_array_length (_tmp22_);
	result = token;
	strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GList*
pc_pam_token_parse (const gchar* str)
{
	GList* list = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	GList* result;
	g_return_val_if_fail (str != NULL, NULL);
	list = NULL;
	_tmp1_ = _tmp0_ = g_strsplit (str, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp1_;
		line_collection_length1 = _vala_array_length (_tmp0_);
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp2_;
			gchar* line = NULL;
			_tmp2_ = g_strdup (line_collection[line_it]);
			line = _tmp2_;
			{
				PCPAMToken* token = NULL;
				const gchar* _tmp3_;
				PCPAMToken* _tmp4_;
				PCPAMToken* _tmp5_;
				_tmp3_ = line;
				_tmp4_ = pc_pam_token_parse_line (_tmp3_);
				token = _tmp4_;
				_tmp5_ = token;
				if (_tmp5_ != NULL) {
					PCPAMToken* _tmp6_;
					PCPAMToken* _tmp7_;
					_tmp6_ = token;
					_tmp7_ = _g_object_ref0 (_tmp6_);
					list = g_list_append (list, _tmp7_);
				}
				_g_object_unref0 (token);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = list;
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

gchar*
pc_pam_token_construct_pam_restriction (gchar** services,
                                        gint services_length1,
                                        gchar** ttys,
                                        gint ttys_length1,
                                        gchar** users,
                                        gint users_length1,
                                        gchar** times,
                                        gint times_length1)
{
	gchar* services_str = NULL;
	gchar* _tmp0_;
	gchar* ttys_str = NULL;
	gchar* _tmp1_;
	gchar* users_str = NULL;
	gchar* _tmp2_;
	gchar* times_str = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = _vala_g_strjoinv (PC_PAM_TOKEN_LIST_SEPARATOR, services, (gint) services_length1);
	services_str = _tmp0_;
	_tmp1_ = _vala_g_strjoinv (PC_PAM_TOKEN_LIST_SEPARATOR, ttys, (gint) ttys_length1);
	ttys_str = _tmp1_;
	_tmp2_ = _vala_g_strjoinv (PC_PAM_TOKEN_LIST_SEPARATOR, users, (gint) users_length1);
	users_str = _tmp2_;
	_tmp3_ = _vala_g_strjoinv (PC_PAM_TOKEN_LIST_SEPARATOR, times, (gint) times_length1);
	times_str = _tmp3_;
	_tmp4_ = g_strdup_printf ("%s;%s;%s;%s", services_str, ttys_str, users_str, times_str);
	result = _tmp4_;
	_g_free0 (times_str);
	_g_free0 (users_str);
	_g_free0 (ttys_str);
	_g_free0 (services_str);
	return result;
}

gchar*
pc_pam_token_construct_pam_restriction_simple (gchar** users,
                                               gint users_length1,
                                               gchar** times,
                                               gint times_length1)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	_tmp0_ = g_strdup ("*");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	_tmp3_ = g_strdup ("*");
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	_tmp6_ = pc_pam_token_construct_pam_restriction (_tmp2_, (gint) 1, _tmp5_, (gint) 1, users, (gint) users_length1, times, (gint) times_length1);
	_tmp7_ = _tmp6_;
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp7_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gpointer
_pc_pam_time_info_ref0 (gpointer self)
{
	return self ? pc_pam_time_info_ref (self) : NULL;
}

GList*
pc_pam_token_get_times_info (PCPAMToken* self)
{
	GList* list = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	list = NULL;
	_tmp0_ = self->times;
	_tmp0__length1 = self->times_length1;
	if (_tmp0__length1 == 0) {
		result = list;
		return result;
	}
	_tmp1_ = self->times;
	_tmp1__length1 = self->times_length1;
	{
		gchar** time_collection = NULL;
		gint time_collection_length1 = 0;
		gint _time_collection_size_ = 0;
		gint time_it = 0;
		time_collection = _tmp1_;
		time_collection_length1 = _tmp1__length1;
		for (time_it = 0; time_it < time_collection_length1; time_it = time_it + 1) {
			gchar* _tmp2_;
			gchar* time = NULL;
			_tmp2_ = g_strdup (time_collection[time_it]);
			time = _tmp2_;
			{
				gchar** bounds = NULL;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar** _tmp6_;
				gchar** _tmp7_;
				gchar** _tmp8_;
				gint _tmp8__length1;
				gint bounds_length1;
				gint _bounds_size_;
				gchar** _tmp9_;
				gint _tmp9__length1;
				PCPAMTimeInfo* info = NULL;
				PCPAMTimeInfo* _tmp10_;
				PCPAMTimeInfo* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				PCPAMTimeInfo* _tmp15_;
				gchar** _tmp16_;
				gint _tmp16__length1;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				PCPAMTimeInfo* _tmp19_;
				gchar** _tmp20_;
				gint _tmp20__length1;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				PCPAMTimeInfo* _tmp23_;
				PCPAMTimeInfo* _tmp24_;
				_tmp3_ = time;
				_tmp4_ = string_substring (_tmp3_, (glong) 2, (glong) -1);
				_tmp5_ = _tmp4_;
				_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "-", 0);
				_tmp8_ = _tmp7_;
				_tmp8__length1 = _vala_array_length (_tmp6_);
				_g_free0 (_tmp5_);
				bounds = _tmp8_;
				bounds_length1 = _tmp8__length1;
				_bounds_size_ = bounds_length1;
				_tmp9_ = bounds;
				_tmp9__length1 = bounds_length1;
				if (_tmp9__length1 < 2) {
					bounds = (_vala_array_free (bounds, bounds_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (time);
					continue;
				}
				_tmp10_ = pc_pam_time_info_new ();
				info = _tmp10_;
				_tmp11_ = info;
				_tmp12_ = time;
				_tmp13_ = string_slice (_tmp12_, (glong) 0, (glong) 2);
				_tmp14_ = _tmp13_;
				_tmp11_->day_type = pc_pam_day_type_to_enum (_tmp14_);
				_g_free0 (_tmp14_);
				_tmp15_ = info;
				_tmp16_ = bounds;
				_tmp16__length1 = bounds_length1;
				_tmp17_ = _tmp16_[0];
				_tmp18_ = g_strdup (_tmp17_);
				_g_free0 (_tmp15_->from);
				_tmp15_->from = _tmp18_;
				_tmp19_ = info;
				_tmp20_ = bounds;
				_tmp20__length1 = bounds_length1;
				_tmp21_ = _tmp20_[1];
				_tmp22_ = g_strdup (_tmp21_);
				_g_free0 (_tmp19_->to);
				_tmp19_->to = _tmp22_;
				_tmp23_ = info;
				_tmp24_ = _pc_pam_time_info_ref0 (_tmp23_);
				list = g_list_append (list, _tmp24_);
				_pc_pam_time_info_unref0 (info);
				bounds = (_vala_array_free (bounds, bounds_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (time);
			}
		}
	}
	result = list;
	return result;
}

gchar*
pc_pam_token_get_user_arg0 (PCPAMToken* self)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->users;
	_tmp0__length1 = self->users_length1;
	if (_tmp0__length1 == 0) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->users;
	_tmp2__length1 = self->users_length1;
	_tmp3_ = _tmp2_[0];
	_tmp4_ = g_strdup (_tmp3_);
	result = _tmp4_;
	return result;
}

gchar*
pc_pam_token_to_string (PCPAMToken* self)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->services;
	_tmp0__length1 = self->services_length1;
	_tmp1_ = self->ttys;
	_tmp1__length1 = self->ttys_length1;
	_tmp2_ = self->users;
	_tmp2__length1 = self->users_length1;
	_tmp3_ = self->times;
	_tmp3__length1 = self->times_length1;
	_tmp4_ = pc_pam_token_construct_pam_restriction (_tmp0_, (gint) _tmp0__length1, _tmp1_, (gint) _tmp1__length1, _tmp2_, (gint) _tmp2__length1, _tmp3_, (gint) _tmp3__length1);
	result = _tmp4_;
	return result;
}

void
pc_pam_token_get_weekday_hours (PCPAMToken* self,
                                gint* from,
                                gint* to)
{
	gint _vala_from = 0;
	gint _vala_to = 0;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** bounds = NULL;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gint bounds_length1;
	gint _bounds_size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** _tmp9_;
	gint _tmp9__length1;
	const gchar* _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	const gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->times;
	_tmp0__length1 = self->times_length1;
	if (_tmp0__length1 < 1) {
		_vala_from = 0;
		_vala_to = 0;
		if (from) {
			*from = _vala_from;
		}
		if (to) {
			*to = _vala_to;
		}
		return;
	}
	_tmp1_ = self->times;
	_tmp1__length1 = self->times_length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = string_substring (_tmp2_, (glong) 2, (glong) -1);
	_tmp4_ = _tmp3_;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, "-", 0);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _vala_array_length (_tmp5_);
	_g_free0 (_tmp4_);
	bounds = _tmp7_;
	bounds_length1 = _tmp7__length1;
	_bounds_size_ = bounds_length1;
	_tmp8_ = bounds;
	_tmp8__length1 = bounds_length1;
	if (_tmp8__length1 < 2) {
		_vala_from = 0;
		_vala_to = 0;
		bounds = (_vala_array_free (bounds, bounds_length1, (GDestroyNotify) g_free), NULL);
		if (from) {
			*from = _vala_from;
		}
		if (to) {
			*to = _vala_to;
		}
		return;
	}
	_tmp9_ = bounds;
	_tmp9__length1 = bounds_length1;
	_tmp10_ = _tmp9_[0];
	_vala_from = atoi (_tmp10_);
	_tmp11_ = bounds;
	_tmp11__length1 = bounds_length1;
	_tmp12_ = _tmp11_[1];
	_vala_to = atoi (_tmp12_);
	bounds = (_vala_array_free (bounds, bounds_length1, (GDestroyNotify) g_free), NULL);
	if (from) {
		*from = _vala_from;
	}
	if (to) {
		*to = _vala_to;
	}
}

void
pc_pam_token_get_weekend_hours (PCPAMToken* self,
                                gint* from,
                                gint* to)
{
	gint _vala_from = 0;
	gint _vala_to = 0;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** bounds = NULL;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint bounds_length1;
	gint _bounds_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->times;
	_tmp0__length1 = self->times_length1;
	if (_tmp0__length1 < 2) {
		_vala_from = 0;
		_vala_to = 0;
		if (from) {
			*from = _vala_from;
		}
		if (to) {
			*to = _vala_to;
		}
		return;
	}
	_tmp1_ = self->times;
	_tmp1__length1 = self->times_length1;
	_tmp2_ = _tmp1_[1];
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, "-", 0);
	bounds = _tmp4_;
	bounds_length1 = _vala_array_length (_tmp3_);
	_bounds_size_ = bounds_length1;
	_tmp5_ = bounds;
	_tmp5__length1 = bounds_length1;
	if (_tmp5__length1 < 2) {
		_vala_from = 0;
		_vala_to = 0;
		bounds = (_vala_array_free (bounds, bounds_length1, (GDestroyNotify) g_free), NULL);
		if (from) {
			*from = _vala_from;
		}
		if (to) {
			*to = _vala_to;
		}
		return;
	}
	_tmp6_ = bounds;
	_tmp6__length1 = bounds_length1;
	_tmp7_ = _tmp6_[0];
	_vala_from = atoi (_tmp7_);
	_tmp8_ = bounds;
	_tmp8__length1 = bounds_length1;
	_tmp9_ = _tmp8_[1];
	_vala_to = atoi (_tmp9_);
	bounds = (_vala_array_free (bounds, bounds_length1, (GDestroyNotify) g_free), NULL);
	if (from) {
		*from = _vala_from;
	}
	if (to) {
		*to = _vala_to;
	}
}

PCPAMToken*
pc_pam_token_construct (GType object_type)
{
	PCPAMToken * self = NULL;
	self = (PCPAMToken*) g_object_new (object_type, NULL);
	return self;
}

PCPAMToken*
pc_pam_token_new (void)
{
	return pc_pam_token_construct (PC_PAM_TYPE_TOKEN);
}

static void
pc_pam_token_class_init (PCPAMTokenClass * klass,
                         gpointer klass_data)
{
	pc_pam_token_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = pc_pam_token_finalize;
}

static void
pc_pam_token_instance_init (PCPAMToken * self,
                            gpointer klass)
{
}

static void
pc_pam_token_finalize (GObject * obj)
{
	PCPAMToken * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PC_PAM_TYPE_TOKEN, PCPAMToken);
	self->services = (_vala_array_free (self->services, self->services_length1, (GDestroyNotify) g_free), NULL);
	self->ttys = (_vala_array_free (self->ttys, self->ttys_length1, (GDestroyNotify) g_free), NULL);
	self->users = (_vala_array_free (self->users, self->users_length1, (GDestroyNotify) g_free), NULL);
	self->times = (_vala_array_free (self->times, self->times_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (pc_pam_token_parent_class)->finalize (obj);
}

static GType
pc_pam_token_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PCPAMTokenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pc_pam_token_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PCPAMToken), 0, (GInstanceInitFunc) pc_pam_token_instance_init, NULL };
	GType pc_pam_token_type_id;
	pc_pam_token_type_id = g_type_register_static (G_TYPE_OBJECT, "PCPAMToken", &g_define_type_info, 0);
	return pc_pam_token_type_id;
}

GType
pc_pam_token_get_type (void)
{
	static volatile gsize pc_pam_token_type_id__once = 0;
	if (g_once_init_enter (&pc_pam_token_type_id__once)) {
		GType pc_pam_token_type_id;
		pc_pam_token_type_id = pc_pam_token_get_type_once ();
		g_once_init_leave (&pc_pam_token_type_id__once, pc_pam_token_type_id);
	}
	return pc_pam_token_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

