/* Writer.c generated by valac 0.56.17, the Vala compiler
 * generated from Writer.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2015 Adam Bieńkowski (https://launchpad.net/switchboard-plug-parental-controls)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 * Authored by: Adam Bieńkowski <donadigos159@gmail.com>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gstdio.h>

#define PC_CONSTANTS_PAM_TIME_CONF_PATH "/etc/security/time.conf"
#define PC_CONSTANTS_PAM_CONF_START "## PANTHEON_PARENTAL_CONTROLS_START"
#define PC_CONSTANTS_PAM_CONF_END "## PANTHEON_PARENTAL_CONTROLS_END"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PC_PAM_TYPE_WRITER (pc_pam_writer_get_type ())
#define PC_PAM_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_PAM_TYPE_WRITER, PCPAMWriter))
#define PC_PAM_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_PAM_TYPE_WRITER, PCPAMWriterClass))
#define PC_PAM_IS_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_PAM_TYPE_WRITER))
#define PC_PAM_IS_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_PAM_TYPE_WRITER))
#define PC_PAM_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_PAM_TYPE_WRITER, PCPAMWriterClass))

typedef struct _PCPAMWriter PCPAMWriter;
typedef struct _PCPAMWriterClass PCPAMWriterClass;
typedef struct _PCPAMWriterPrivate PCPAMWriterPrivate;
enum  {
	PC_PAM_WRITER_0_PROPERTY,
	PC_PAM_WRITER_NUM_PROPERTIES
};
static GParamSpec* pc_pam_writer_properties[PC_PAM_WRITER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define PC_PAM_TYPE_TOKEN (pc_pam_token_get_type ())
#define PC_PAM_TOKEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_PAM_TYPE_TOKEN, PCPAMToken))
#define PC_PAM_TOKEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_PAM_TYPE_TOKEN, PCPAMTokenClass))
#define PC_PAM_IS_TOKEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_PAM_TYPE_TOKEN))
#define PC_PAM_IS_TOKEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_PAM_TYPE_TOKEN))
#define PC_PAM_TOKEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_PAM_TYPE_TOKEN, PCPAMTokenClass))

typedef struct _PCPAMToken PCPAMToken;
typedef struct _PCPAMTokenClass PCPAMTokenClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _PCPAMWriter {
	GObject parent_instance;
	PCPAMWriterPrivate * priv;
};

struct _PCPAMWriterClass {
	GObjectClass parent_class;
};

struct _PCPAMWriterPrivate {
	gchar* filename;
};

static gint PCPAMWriter_private_offset;
static gpointer pc_pam_writer_parent_class = NULL;

VALA_EXTERN GType pc_pam_writer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCPAMWriter, g_object_unref)
VALA_EXTERN PCPAMWriter* pc_pam_writer_new_for_time (void);
VALA_EXTERN PCPAMWriter* pc_pam_writer_new (const gchar* filename);
VALA_EXTERN PCPAMWriter* pc_pam_writer_construct (GType object_type,
                                      const gchar* filename);
VALA_EXTERN void pc_pam_writer_add_restriction_for_user (PCPAMWriter* self,
                                             const gchar* input,
                                             gboolean clean);
VALA_EXTERN GType pc_pam_token_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCPAMToken, g_object_unref)
VALA_EXTERN PCPAMToken* pc_pam_token_parse_line (const gchar* line);
VALA_EXTERN gchar* pc_pam_token_get_user_arg0 (PCPAMToken* self);
VALA_EXTERN gchar* pc_pam_reader_get_config (const gchar* contents,
                                 gint* start_idx,
                                 gint* end_idx);
VALA_EXTERN GList* pc_pam_token_parse (const gchar* str);
VALA_EXTERN gchar* pc_pam_token_to_string (PCPAMToken* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN void pc_pam_writer_remove_restriction_for_user (PCPAMWriter* self,
                                                const gchar* username);
static void pc_pam_writer_finalize (GObject * obj);
static GType pc_pam_writer_get_type_once (void);

static inline gpointer
pc_pam_writer_get_instance_private (PCPAMWriter* self)
{
	return G_STRUCT_MEMBER_P (self, PCPAMWriter_private_offset);
}

PCPAMWriter*
pc_pam_writer_new_for_time (void)
{
	PCPAMWriter* _tmp0_;
	PCPAMWriter* result;
	_tmp0_ = pc_pam_writer_new (PC_CONSTANTS_PAM_TIME_CONF_PATH);
	result = _tmp0_;
	return result;
}

PCPAMWriter*
pc_pam_writer_construct (GType object_type,
                         const gchar* filename)
{
	PCPAMWriter * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (PCPAMWriter*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (filename);
	_g_free0 (self->priv->filename);
	self->priv->filename = _tmp0_;
	return self;
}

PCPAMWriter*
pc_pam_writer_new (const gchar* filename)
{
	return pc_pam_writer_construct (PC_PAM_TYPE_WRITER, filename);
}

static gchar*
string_splice (const gchar* self,
               glong start,
               glong end,
               const gchar* str)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gsize str_size = 0UL;
	const gchar* _result_ = NULL;
	void* _tmp6_;
	gchar* dest = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	if (str == NULL) {
		str_size = (gsize) 0;
	} else {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = strlen ((const gchar*) str);
		_tmp5_ = _tmp4_;
		str_size = (gsize) _tmp5_;
	}
	_tmp6_ = g_malloc0 (((string_length - (end - start)) + str_size) + 1);
	_result_ = _tmp6_;
	_tmp7_ = _result_;
	dest = (gchar*) _tmp7_;
	_tmp8_ = dest;
	memcpy (_tmp8_, self, (gsize) start);
	_tmp9_ = dest;
	dest = _tmp9_ + start;
	if (str != NULL) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = dest;
		memcpy (_tmp10_, str, str_size);
		_tmp11_ = dest;
		dest = _tmp11_ + str_size;
	}
	_tmp12_ = dest;
	memcpy (_tmp12_, ((gchar*) self) + end, (gsize) (string_length - end));
	_tmp13_ = _result_;
	_result_ = NULL;
	result = (gchar*) _tmp13_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
pc_pam_writer_add_restriction_for_user (PCPAMWriter* self,
                                        const gchar* input,
                                        gboolean clean)
{
	gchar* clean_username = NULL;
	gchar* contents = NULL;
	gint start_idx = 0;
	gint end_idx = 0;
	gchar* config = NULL;
	const gchar* _tmp8_;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gchar* _tmp11_;
	gboolean _tmp12_ = FALSE;
	GString* builder = NULL;
	GString* _tmp15_;
	GString* _tmp16_;
	const gchar* _tmp17_;
	GList* _tmp18_;
	GString* _tmp30_;
	GString* _tmp31_;
	GString* _tmp32_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (input != NULL);
	clean_username = NULL;
	if (clean) {
		PCPAMToken* token = NULL;
		PCPAMToken* _tmp0_;
		PCPAMToken* _tmp1_;
		_tmp0_ = pc_pam_token_parse_line (input);
		token = _tmp0_;
		_tmp1_ = token;
		if (_tmp1_ != NULL) {
			PCPAMToken* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = token;
			_tmp3_ = pc_pam_token_get_user_arg0 (_tmp2_);
			_g_free0 (clean_username);
			clean_username = _tmp3_;
		}
		_g_object_unref0 (token);
	}
	{
		const gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		_tmp4_ = self->priv->filename;
		g_file_get_contents (_tmp4_, &_tmp5_, NULL, &_inner_error0_);
		_g_free0 (contents);
		contents = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (contents);
			_g_free0 (clean_username);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("Writer.vala:48: %s", _tmp7_);
		_g_error_free0 (e);
		_g_free0 (contents);
		_g_free0 (clean_username);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (contents);
		_g_free0 (clean_username);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp8_ = contents;
	_tmp11_ = pc_pam_reader_get_config (_tmp8_, &_tmp9_, &_tmp10_);
	start_idx = _tmp9_;
	end_idx = _tmp10_;
	config = _tmp11_;
	if (start_idx != -1) {
		_tmp12_ = end_idx != -1;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = contents;
		_tmp14_ = string_splice (_tmp13_, (glong) (start_idx - 1), (glong) end_idx, NULL);
		_g_free0 (contents);
		contents = _tmp14_;
	}
	_tmp15_ = g_string_new (PC_CONSTANTS_PAM_CONF_START);
	builder = _tmp15_;
	_tmp16_ = builder;
	g_string_append (_tmp16_, "\n");
	_tmp17_ = config;
	_tmp18_ = pc_pam_token_parse (_tmp17_);
	{
		GList* token_collection = NULL;
		GList* token_it = NULL;
		token_collection = _tmp18_;
		for (token_it = token_collection; token_it != NULL; token_it = token_it->next) {
			PCPAMToken* _tmp19_;
			PCPAMToken* token = NULL;
			_tmp19_ = _g_object_ref0 ((PCPAMToken*) token_it->data);
			token = _tmp19_;
			{
				PCPAMToken* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				const gchar* _tmp23_;
				gboolean _tmp24_;
				GString* _tmp25_;
				PCPAMToken* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				GString* _tmp29_;
				_tmp20_ = token;
				_tmp21_ = pc_pam_token_get_user_arg0 (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = clean_username;
				_tmp24_ = g_strcmp0 (_tmp22_, _tmp23_) == 0;
				_g_free0 (_tmp22_);
				if (_tmp24_) {
					_g_object_unref0 (token);
					continue;
				}
				_tmp25_ = builder;
				_tmp26_ = token;
				_tmp27_ = pc_pam_token_to_string (_tmp26_);
				_tmp28_ = _tmp27_;
				g_string_append (_tmp25_, _tmp28_);
				_g_free0 (_tmp28_);
				_tmp29_ = builder;
				g_string_append (_tmp29_, "\n");
				_g_object_unref0 (token);
			}
		}
		(token_collection == NULL) ? NULL : (token_collection = (_g_list_free__g_object_unref0_ (token_collection), NULL));
	}
	_tmp30_ = builder;
	g_string_append (_tmp30_, input);
	_tmp31_ = builder;
	g_string_append (_tmp31_, "\n");
	_tmp32_ = builder;
	g_string_append (_tmp32_, PC_CONSTANTS_PAM_CONF_END);
	{
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		GString* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		_tmp33_ = self->priv->filename;
		_tmp34_ = contents;
		_tmp35_ = builder;
		_tmp36_ = _tmp35_->str;
		_tmp37_ = g_strdup_printf ("%s\n%s", _tmp34_, _tmp36_);
		_tmp38_ = _tmp37_;
		g_file_set_contents (_tmp33_, _tmp38_, (gssize) -1, &_inner_error0_);
		_g_free0 (_tmp38_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch1_g_file_error;
			}
			_g_string_free0 (builder);
			_g_free0 (config);
			_g_free0 (contents);
			_g_free0 (clean_username);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp39_;
		const gchar* _tmp40_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp39_ = e;
		_tmp40_ = _tmp39_->message;
		g_warning ("Writer.vala:79: %s\n", _tmp40_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_string_free0 (builder);
		_g_free0 (config);
		_g_free0 (contents);
		_g_free0 (clean_username);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_string_free0 (builder);
	_g_free0 (config);
	_g_free0 (contents);
	_g_free0 (clean_username);
}

void
pc_pam_writer_remove_restriction_for_user (PCPAMWriter* self,
                                           const gchar* username)
{
	gchar* contents = NULL;
	gint start_idx = 0;
	gint end_idx = 0;
	gchar* config = NULL;
	const gchar* _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	GString* builder = NULL;
	GString* _tmp11_;
	GString* _tmp12_;
	const gchar* _tmp13_;
	GList* _tmp14_;
	GString* _tmp25_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (username != NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		_tmp0_ = self->priv->filename;
		g_file_get_contents (_tmp0_, &_tmp1_, NULL, &_inner_error0_);
		_g_free0 (contents);
		contents = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (contents);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("Writer.vala:88: %s", _tmp3_);
		_g_error_free0 (e);
		_g_free0 (contents);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp4_ = contents;
	_tmp7_ = pc_pam_reader_get_config (_tmp4_, &_tmp5_, &_tmp6_);
	start_idx = _tmp5_;
	end_idx = _tmp6_;
	config = _tmp7_;
	if (start_idx != -1) {
		_tmp8_ = end_idx != -1;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = contents;
		_tmp10_ = string_splice (_tmp9_, (glong) (start_idx - 1), (glong) end_idx, NULL);
		_g_free0 (contents);
		contents = _tmp10_;
	} else {
		_g_free0 (config);
		_g_free0 (contents);
		return;
	}
	_tmp11_ = g_string_new (PC_CONSTANTS_PAM_CONF_START);
	builder = _tmp11_;
	_tmp12_ = builder;
	g_string_append (_tmp12_, "\n");
	_tmp13_ = config;
	_tmp14_ = pc_pam_token_parse (_tmp13_);
	{
		GList* token_collection = NULL;
		GList* token_it = NULL;
		token_collection = _tmp14_;
		for (token_it = token_collection; token_it != NULL; token_it = token_it->next) {
			PCPAMToken* _tmp15_;
			PCPAMToken* token = NULL;
			_tmp15_ = _g_object_ref0 ((PCPAMToken*) token_it->data);
			token = _tmp15_;
			{
				PCPAMToken* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gboolean _tmp19_;
				GString* _tmp20_;
				PCPAMToken* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				GString* _tmp24_;
				_tmp16_ = token;
				_tmp17_ = pc_pam_token_get_user_arg0 (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_strcmp0 (_tmp18_, username) == 0;
				_g_free0 (_tmp18_);
				if (_tmp19_) {
					_g_object_unref0 (token);
					continue;
				}
				_tmp20_ = builder;
				_tmp21_ = token;
				_tmp22_ = pc_pam_token_to_string (_tmp21_);
				_tmp23_ = _tmp22_;
				g_string_append (_tmp20_, _tmp23_);
				_g_free0 (_tmp23_);
				_tmp24_ = builder;
				g_string_append (_tmp24_, "\n");
				_g_object_unref0 (token);
			}
		}
		(token_collection == NULL) ? NULL : (token_collection = (_g_list_free__g_object_unref0_ (token_collection), NULL));
	}
	_tmp25_ = builder;
	g_string_append (_tmp25_, PC_CONSTANTS_PAM_CONF_END);
	{
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		GString* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp26_ = self->priv->filename;
		_tmp27_ = contents;
		_tmp28_ = builder;
		_tmp29_ = _tmp28_->str;
		_tmp30_ = g_strdup_printf ("%s\n%s", _tmp27_, _tmp29_);
		_tmp31_ = _tmp30_;
		g_file_set_contents (_tmp26_, _tmp31_, (gssize) -1, &_inner_error0_);
		_g_free0 (_tmp31_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch1_g_file_error;
			}
			_g_string_free0 (builder);
			_g_free0 (config);
			_g_free0 (contents);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp32_;
		const gchar* _tmp33_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp32_ = e;
		_tmp33_ = _tmp32_->message;
		g_warning ("Writer.vala:119: %s\n", _tmp33_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_string_free0 (builder);
		_g_free0 (config);
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_string_free0 (builder);
	_g_free0 (config);
	_g_free0 (contents);
}

static void
pc_pam_writer_class_init (PCPAMWriterClass * klass,
                          gpointer klass_data)
{
	pc_pam_writer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PCPAMWriter_private_offset);
	G_OBJECT_CLASS (klass)->finalize = pc_pam_writer_finalize;
}

static void
pc_pam_writer_instance_init (PCPAMWriter * self,
                             gpointer klass)
{
	self->priv = pc_pam_writer_get_instance_private (self);
}

static void
pc_pam_writer_finalize (GObject * obj)
{
	PCPAMWriter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PC_PAM_TYPE_WRITER, PCPAMWriter);
	_g_free0 (self->priv->filename);
	G_OBJECT_CLASS (pc_pam_writer_parent_class)->finalize (obj);
}

static GType
pc_pam_writer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PCPAMWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pc_pam_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PCPAMWriter), 0, (GInstanceInitFunc) pc_pam_writer_instance_init, NULL };
	GType pc_pam_writer_type_id;
	pc_pam_writer_type_id = g_type_register_static (G_TYPE_OBJECT, "PCPAMWriter", &g_define_type_info, 0);
	PCPAMWriter_private_offset = g_type_add_instance_private (pc_pam_writer_type_id, sizeof (PCPAMWriterPrivate));
	return pc_pam_writer_type_id;
}

GType
pc_pam_writer_get_type (void)
{
	static volatile gsize pc_pam_writer_type_id__once = 0;
	if (g_once_init_enter (&pc_pam_writer_type_id__once)) {
		GType pc_pam_writer_type_id;
		pc_pam_writer_type_id = pc_pam_writer_get_type_once ();
		g_once_init_leave (&pc_pam_writer_type_id__once, pc_pam_writer_type_id);
	}
	return pc_pam_writer_type_id__once;
}

