/* NightLightView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from NightLightView.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-2.0-or-later
 * SPDX-FileCopyrightText: 2017-2023 elementary, Inc. (https://elementary.io)
 */

#include "display.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <granite-7.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <adwaita.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DISPLAY_NIGHT_LIGHT_VIEW_0_PROPERTY,
	DISPLAY_NIGHT_LIGHT_VIEW_NUM_PROPERTIES
};
static GParamSpec* display_night_light_view_properties[DISPLAY_NIGHT_LIGHT_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _Block2Data {
	int _ref_count_;
	DisplayNightLightView* self;
	GraniteTimePicker* from_time;
	GraniteTimePicker* to_time;
	GSettings* settings;
};

static gpointer display_night_light_view_parent_class = NULL;

static void display_night_light_view_clear_snooze (DisplayNightLightView* self);
static gdouble display_night_light_view_date_time_double (GDateTime* date_time);
static GDateTime* display_night_light_view_double_date_time (gdouble dbl);
static GObject * display_night_light_view_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void _display_night_light_view___lambda29_ (DisplayNightLightView* self);
static void __display_night_light_view___lambda29__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                      gpointer self);
static void _display_night_light_view___lambda30_ (DisplayNightLightView* self);
static void __display_night_light_view___lambda30__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                          gpointer self);
static void _display_night_light_view___lambda31_ (Block2Data* _data2_);
static void __display_night_light_view___lambda31__granite_time_picker_time_changed (GraniteTimePicker* _sender,
                                                                              gpointer self);
static void _display_night_light_view___lambda32_ (Block2Data* _data2_);
static void __display_night_light_view___lambda32__granite_time_picker_time_changed (GraniteTimePicker* _sender,
                                                                              gpointer self);
static gboolean _display_night_light_view___lambda33_ (DisplayNightLightView* self,
                                                gboolean state);
static gboolean __display_night_light_view___lambda33__gtk_switch_state_set (GtkSwitch* _sender,
                                                                      gboolean state,
                                                                      gpointer self);
static GType display_night_light_view_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static void
display_night_light_view_clear_snooze (DisplayNightLightView* self)
{
	DisplayNightLightManager* _tmp0_;
	DisplayNightLightManager* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = display_night_light_manager_get_instance ();
	_tmp1_ = _tmp0_;
	display_night_light_manager_set_snoozed (_tmp1_, FALSE);
	_g_object_unref0 (_tmp1_);
}

static gdouble
display_night_light_view_date_time_double (GDateTime* date_time)
{
	gdouble time_double = 0.0;
	gdouble result;
	g_return_val_if_fail (date_time != NULL, 0.0);
	time_double = (gdouble) 0;
	time_double += (gdouble) g_date_time_get_hour (date_time);
	time_double += ((gdouble) g_date_time_get_minute (date_time)) / 60;
	result = time_double;
	return result;
}

static GDateTime*
display_night_light_view_double_date_time (gdouble dbl)
{
	gint hours = 0;
	gint minutes = 0;
	GDateTime* date_time = NULL;
	GDateTime* _tmp0_;
	GDateTime* result;
	hours = (gint) dbl;
	minutes = (gint) round ((dbl - hours) * 60);
	_tmp0_ = g_date_time_new_local (1, 1, 1, hours, minutes, 0.0);
	date_time = _tmp0_;
	result = date_time;
	return result;
}

DisplayNightLightView*
display_night_light_view_construct (GType object_type)
{
	DisplayNightLightView * self = NULL;
	self = (DisplayNightLightView*) g_object_new (object_type, NULL);
	return self;
}

DisplayNightLightView*
display_night_light_view_new (void)
{
	return display_night_light_view_construct (DISPLAY_TYPE_NIGHT_LIGHT_VIEW);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		DisplayNightLightView* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->settings);
		_g_object_unref0 (_data2_->to_time);
		_g_object_unref0 (_data2_->from_time);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_display_night_light_view___lambda29_ (DisplayNightLightView* self)
{
	display_night_light_view_clear_snooze (self);
}

static void
__display_night_light_view___lambda29__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                 gpointer self)
{
	_display_night_light_view___lambda29_ ((DisplayNightLightView*) self);
}

static void
_display_night_light_view___lambda30_ (DisplayNightLightView* self)
{
	display_night_light_view_clear_snooze (self);
}

static void
__display_night_light_view___lambda30__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                     gpointer self)
{
	_display_night_light_view___lambda30_ ((DisplayNightLightView*) self);
}

static void
_display_night_light_view___lambda31_ (Block2Data* _data2_)
{
	DisplayNightLightView* self;
	GSettings* _tmp0_;
	GraniteTimePicker* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	self = _data2_->self;
	_tmp0_ = _data2_->settings;
	_tmp1_ = _data2_->from_time;
	_tmp2_ = granite_time_picker_get_time (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_double (_tmp0_, "night-light-schedule-from", display_night_light_view_date_time_double (_tmp3_));
	display_night_light_view_clear_snooze (self);
}

static void
__display_night_light_view___lambda31__granite_time_picker_time_changed (GraniteTimePicker* _sender,
                                                                         gpointer self)
{
	_display_night_light_view___lambda31_ (self);
}

static void
_display_night_light_view___lambda32_ (Block2Data* _data2_)
{
	DisplayNightLightView* self;
	GSettings* _tmp0_;
	GraniteTimePicker* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	self = _data2_->self;
	_tmp0_ = _data2_->settings;
	_tmp1_ = _data2_->to_time;
	_tmp2_ = granite_time_picker_get_time (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_double (_tmp0_, "night-light-schedule-to", display_night_light_view_date_time_double (_tmp3_));
	display_night_light_view_clear_snooze (self);
}

static void
__display_night_light_view___lambda32__granite_time_picker_time_changed (GraniteTimePicker* _sender,
                                                                         gpointer self)
{
	_display_night_light_view___lambda32_ (self);
}

static gboolean
_display_night_light_view___lambda33_ (DisplayNightLightView* self,
                                       gboolean state)
{
	gboolean result;
	if (state) {
		display_night_light_view_clear_snooze (self);
	}
	result = FALSE;
	return result;
}

static gboolean
__display_night_light_view___lambda33__gtk_switch_state_set (GtkSwitch* _sender,
                                                             gboolean state,
                                                             gpointer self)
{
	gboolean result;
	result = _display_night_light_view___lambda33_ ((DisplayNightLightView*) self, state);
	return result;
}

static GObject *
display_night_light_view_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DisplayNightLightView * self;
	Block2Data* _data2_;
	GraniteHeaderLabel* nightlight_header = NULL;
	gchar* _tmp0_;
	GraniteHeaderLabel* _tmp1_ = NULL;
	GtkSwitch* nightlight_switch = NULL;
	GtkSwitch* _tmp2_ = NULL;
	GtkAdjustment* temp_adjustment = NULL;
	GtkAdjustment* _tmp3_;
	GtkScale* temp_scale = NULL;
	GtkAdjustment* _tmp4_;
	GtkScale* _tmp5_ = NULL;
	GtkScale* _tmp6_;
	GtkScale* _tmp7_;
	GtkScale* _tmp8_;
	GtkScale* _tmp9_;
	GtkGrid* nightlight_grid = NULL;
	GtkGrid* _tmp10_ = NULL;
	GtkGrid* _tmp11_;
	GraniteHeaderLabel* _tmp12_;
	GtkGrid* _tmp13_;
	GtkSwitch* _tmp14_;
	GtkGrid* _tmp15_;
	GtkScale* _tmp16_;
	GraniteHeaderLabel* schedule_header = NULL;
	GraniteHeaderLabel* _tmp17_;
	GtkCheckButton* schedule_sunset_radio = NULL;
	GtkCheckButton* _tmp18_;
	GtkLabel* from_label = NULL;
	GtkLabel* _tmp19_;
	GraniteTimePicker* _tmp20_ = NULL;
	GtkLabel* to_label = NULL;
	GtkLabel* _tmp21_;
	GraniteTimePicker* _tmp22_ = NULL;
	GtkBox* schedule_manual_box = NULL;
	GtkBox* _tmp23_;
	GtkBox* _tmp24_;
	GtkLabel* _tmp25_;
	GtkBox* _tmp26_;
	GraniteTimePicker* _tmp27_;
	GtkBox* _tmp28_;
	GtkLabel* _tmp29_;
	GtkBox* _tmp30_;
	GraniteTimePicker* _tmp31_;
	GtkCheckButton* schedule_manual_radio = NULL;
	GtkCheckButton* _tmp32_;
	GtkCheckButton* _tmp33_;
	GtkCheckButton* _tmp34_ = NULL;
	GtkBox* _tmp35_;
	GtkCheckButton* _tmp36_;
	GtkGrid* schedule_grid = NULL;
	GtkGrid* _tmp37_ = NULL;
	GtkGrid* _tmp38_;
	GraniteHeaderLabel* _tmp39_;
	GtkGrid* _tmp40_;
	GtkCheckButton* _tmp41_;
	GtkGrid* _tmp42_;
	GtkCheckButton* _tmp43_;
	GtkBox* box = NULL;
	GtkBox* _tmp44_;
	GtkBox* _tmp45_;
	GtkGrid* _tmp46_;
	GtkBox* _tmp47_;
	GtkGrid* _tmp48_;
	AdwClamp* clamp = NULL;
	GtkBox* _tmp49_;
	GtkWidget* _tmp50_;
	AdwClamp* _tmp51_ = NULL;
	AdwClamp* _tmp52_;
	GSettings* _tmp53_;
	GSettings* _tmp54_;
	GtkSwitch* _tmp55_;
	GSettings* _tmp56_;
	GtkGrid* _tmp57_;
	GSettings* _tmp58_;
	GtkScale* _tmp59_;
	GSettings* _tmp60_;
	GtkCheckButton* _tmp61_;
	GSettings* _tmp62_;
	GtkCheckButton* _tmp63_;
	GSettings* _tmp64_;
	GtkBox* _tmp65_;
	GSettings* _tmp66_;
	GtkAdjustment* _tmp67_;
	GtkCheckButton* _tmp68_;
	GtkAdjustment* _tmp69_;
	GraniteTimePicker* _tmp70_;
	GSettings* _tmp71_;
	GDateTime* _tmp72_;
	GDateTime* _tmp73_;
	GraniteTimePicker* _tmp74_;
	GraniteTimePicker* _tmp75_;
	GSettings* _tmp76_;
	GDateTime* _tmp77_;
	GDateTime* _tmp78_;
	GraniteTimePicker* _tmp79_;
	GtkSwitch* _tmp80_;
	parent_class = G_OBJECT_CLASS (display_night_light_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DISPLAY_TYPE_NIGHT_LIGHT_VIEW, DisplayNightLightView);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = g_strdup (_ ("Making the colors of your display warmer may help prevent eye strain a" \
"nd sleeplessness"));
	_tmp1_ = granite_header_label_new (_ ("Night Light"));
	granite_header_label_set_secondary_text (_tmp1_, _tmp0_);
	_g_free0 (_tmp0_);
	g_object_ref_sink (_tmp1_);
	nightlight_header = _tmp1_;
	_tmp2_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp2_, GTK_ALIGN_END);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	gtk_widget_set_valign ((GtkWidget*) _tmp2_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp2_);
	nightlight_switch = _tmp2_;
	_tmp3_ = gtk_adjustment_new ((gdouble) 0, (gdouble) 1500, (gdouble) 6000, (gdouble) 10, (gdouble) 0, (gdouble) 0);
	g_object_ref_sink (_tmp3_);
	temp_adjustment = _tmp3_;
	_tmp4_ = temp_adjustment;
	_tmp5_ = (GtkScale*) gtk_scale_new (GTK_ORIENTATION_HORIZONTAL, _tmp4_);
	gtk_scale_set_draw_value (_tmp5_, FALSE);
	gtk_scale_set_has_origin (_tmp5_, FALSE);
	gtk_range_set_inverted ((GtkRange*) _tmp5_, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp5_, 12);
	g_object_ref_sink (_tmp5_);
	temp_scale = _tmp5_;
	_tmp6_ = temp_scale;
	gtk_scale_add_mark (_tmp6_, (gdouble) 1500, GTK_POS_BOTTOM, _ ("More Warm"));
	_tmp7_ = temp_scale;
	gtk_scale_add_mark (_tmp7_, (gdouble) 4500, GTK_POS_BOTTOM, NULL);
	_tmp8_ = temp_scale;
	gtk_scale_add_mark (_tmp8_, (gdouble) 6000, GTK_POS_BOTTOM, _ ("Less Warm"));
	_tmp9_ = temp_scale;
	gtk_widget_add_css_class ((GtkWidget*) _tmp9_, "warmth");
	_tmp10_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp10_, 12);
	g_object_ref_sink (_tmp10_);
	nightlight_grid = _tmp10_;
	_tmp11_ = nightlight_grid;
	_tmp12_ = nightlight_header;
	gtk_grid_attach (_tmp11_, (GtkWidget*) _tmp12_, 0, 0, 1, 1);
	_tmp13_ = nightlight_grid;
	_tmp14_ = nightlight_switch;
	gtk_grid_attach (_tmp13_, (GtkWidget*) _tmp14_, 1, 0, 1, 1);
	_tmp15_ = nightlight_grid;
	_tmp16_ = temp_scale;
	gtk_grid_attach (_tmp15_, (GtkWidget*) _tmp16_, 0, 1, 2, 1);
	_tmp17_ = granite_header_label_new (_ ("Schedule"));
	g_object_ref_sink (_tmp17_);
	schedule_header = _tmp17_;
	_tmp18_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Sunset to Sunrise"));
	g_object_ref_sink (_tmp18_);
	schedule_sunset_radio = _tmp18_;
	_tmp19_ = (GtkLabel*) gtk_label_new (_ ("From:"));
	g_object_ref_sink (_tmp19_);
	from_label = _tmp19_;
	_tmp20_ = granite_time_picker_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp20_, TRUE);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp20_, 6);
	g_object_ref_sink (_tmp20_);
	_data2_->from_time = _tmp20_;
	_tmp21_ = (GtkLabel*) gtk_label_new (_ ("To:"));
	g_object_ref_sink (_tmp21_);
	to_label = _tmp21_;
	_tmp22_ = granite_time_picker_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp22_, TRUE);
	g_object_ref_sink (_tmp22_);
	_data2_->to_time = _tmp22_;
	_tmp23_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp23_);
	schedule_manual_box = _tmp23_;
	_tmp24_ = schedule_manual_box;
	_tmp25_ = from_label;
	gtk_box_append (_tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = schedule_manual_box;
	_tmp27_ = _data2_->from_time;
	gtk_box_append (_tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = schedule_manual_box;
	_tmp29_ = to_label;
	gtk_box_append (_tmp28_, (GtkWidget*) _tmp29_);
	_tmp30_ = schedule_manual_box;
	_tmp31_ = _data2_->to_time;
	gtk_box_append (_tmp30_, (GtkWidget*) _tmp31_);
	_tmp32_ = schedule_sunset_radio;
	_tmp33_ = _g_object_ref0 (_tmp32_);
	_tmp34_ = (GtkCheckButton*) gtk_check_button_new ();
	gtk_check_button_set_group (_tmp34_, _tmp33_);
	_g_object_unref0 (_tmp33_);
	g_object_ref_sink (_tmp34_);
	schedule_manual_radio = _tmp34_;
	_tmp35_ = schedule_manual_box;
	_tmp36_ = schedule_manual_radio;
	gtk_widget_set_parent ((GtkWidget*) _tmp35_, (GtkWidget*) _tmp36_);
	_tmp37_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp37_, 6);
	gtk_grid_set_row_spacing (_tmp37_, 6);
	g_object_ref_sink (_tmp37_);
	schedule_grid = _tmp37_;
	_tmp38_ = schedule_grid;
	_tmp39_ = schedule_header;
	gtk_grid_attach (_tmp38_, (GtkWidget*) _tmp39_, 0, 3, 1, 1);
	_tmp40_ = schedule_grid;
	_tmp41_ = schedule_sunset_radio;
	gtk_grid_attach (_tmp40_, (GtkWidget*) _tmp41_, 0, 5, 1, 1);
	_tmp42_ = schedule_grid;
	_tmp43_ = schedule_manual_radio;
	gtk_grid_attach (_tmp42_, (GtkWidget*) _tmp43_, 0, 6, 1, 1);
	_tmp44_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 24);
	g_object_ref_sink (_tmp44_);
	box = _tmp44_;
	_tmp45_ = box;
	_tmp46_ = nightlight_grid;
	gtk_box_append (_tmp45_, (GtkWidget*) _tmp46_);
	_tmp47_ = box;
	_tmp48_ = schedule_grid;
	gtk_box_append (_tmp47_, (GtkWidget*) _tmp48_);
	_tmp49_ = box;
	_tmp50_ = _g_object_ref0 ((GtkWidget*) _tmp49_);
	_tmp51_ = (AdwClamp*) adw_clamp_new ();
	adw_clamp_set_child (_tmp51_, _tmp50_);
	_g_object_unref0 (_tmp50_);
	g_object_ref_sink (_tmp51_);
	clamp = _tmp51_;
	_tmp52_ = clamp;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp52_);
	gtk_widget_set_margin_start ((GtkWidget*) self, 12);
	gtk_widget_set_margin_end ((GtkWidget*) self, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 12);
	_tmp53_ = g_settings_new ("org.gnome.settings-daemon.plugins.color");
	_data2_->settings = _tmp53_;
	_tmp54_ = _data2_->settings;
	_tmp55_ = nightlight_switch;
	g_settings_bind (_tmp54_, "night-light-enabled", (GObject*) _tmp55_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp56_ = _data2_->settings;
	_tmp57_ = schedule_grid;
	g_settings_bind (_tmp56_, "night-light-enabled", (GObject*) _tmp57_, "sensitive", G_SETTINGS_BIND_GET);
	_tmp58_ = _data2_->settings;
	_tmp59_ = temp_scale;
	g_settings_bind (_tmp58_, "night-light-enabled", (GObject*) _tmp59_, "sensitive", G_SETTINGS_BIND_GET);
	_tmp60_ = _data2_->settings;
	_tmp61_ = schedule_sunset_radio;
	g_settings_bind (_tmp60_, "night-light-schedule-automatic", (GObject*) _tmp61_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp62_ = _data2_->settings;
	_tmp63_ = schedule_manual_radio;
	g_settings_bind (_tmp62_, "night-light-schedule-automatic", (GObject*) _tmp63_, "active", G_SETTINGS_BIND_INVERT_BOOLEAN);
	_tmp64_ = _data2_->settings;
	_tmp65_ = schedule_manual_box;
	g_settings_bind (_tmp64_, "night-light-schedule-automatic", (GObject*) _tmp65_, "sensitive", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_INVERT_BOOLEAN);
	_tmp66_ = _data2_->settings;
	_tmp67_ = temp_adjustment;
	g_settings_bind (_tmp66_, "night-light-temperature", (GObject*) _tmp67_, "value", G_SETTINGS_BIND_DEFAULT);
	_tmp68_ = schedule_sunset_radio;
	g_signal_connect_object (_tmp68_, "toggled", (GCallback) __display_night_light_view___lambda29__gtk_check_button_toggled, self, 0);
	_tmp69_ = temp_adjustment;
	g_signal_connect_object (_tmp69_, "value-changed", (GCallback) __display_night_light_view___lambda30__gtk_adjustment_value_changed, self, 0);
	_tmp70_ = _data2_->from_time;
	_tmp71_ = _data2_->settings;
	_tmp72_ = display_night_light_view_double_date_time (g_settings_get_double (_tmp71_, "night-light-schedule-from"));
	_tmp73_ = _tmp72_;
	granite_time_picker_set_time (_tmp70_, _tmp73_);
	_g_date_time_unref0 (_tmp73_);
	_tmp74_ = _data2_->from_time;
	g_signal_connect_data (_tmp74_, "time-changed", (GCallback) __display_night_light_view___lambda31__granite_time_picker_time_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp75_ = _data2_->to_time;
	_tmp76_ = _data2_->settings;
	_tmp77_ = display_night_light_view_double_date_time (g_settings_get_double (_tmp76_, "night-light-schedule-to"));
	_tmp78_ = _tmp77_;
	granite_time_picker_set_time (_tmp75_, _tmp78_);
	_g_date_time_unref0 (_tmp78_);
	_tmp79_ = _data2_->to_time;
	g_signal_connect_data (_tmp79_, "time-changed", (GCallback) __display_night_light_view___lambda32__granite_time_picker_time_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp80_ = nightlight_switch;
	g_signal_connect_object (_tmp80_, "state-set", (GCallback) __display_night_light_view___lambda33__gtk_switch_state_set, self, 0);
	_g_object_unref0 (clamp);
	_g_object_unref0 (box);
	_g_object_unref0 (schedule_grid);
	_g_object_unref0 (schedule_manual_radio);
	_g_object_unref0 (schedule_manual_box);
	_g_object_unref0 (to_label);
	_g_object_unref0 (from_label);
	_g_object_unref0 (schedule_sunset_radio);
	_g_object_unref0 (schedule_header);
	_g_object_unref0 (nightlight_grid);
	_g_object_unref0 (temp_scale);
	_g_object_unref0 (temp_adjustment);
	_g_object_unref0 (nightlight_switch);
	_g_object_unref0 (nightlight_header);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return obj;
}

static void
display_night_light_view_class_init (DisplayNightLightViewClass * klass,
                                     gpointer klass_data)
{
	display_night_light_view_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = display_night_light_view_constructor;
}

static void
display_night_light_view_instance_init (DisplayNightLightView * self,
                                        gpointer klass)
{
}

static GType
display_night_light_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DisplayNightLightViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) display_night_light_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DisplayNightLightView), 0, (GInstanceInitFunc) display_night_light_view_instance_init, NULL };
	GType display_night_light_view_type_id;
	display_night_light_view_type_id = g_type_register_static (gtk_box_get_type (), "DisplayNightLightView", &g_define_type_info, 0);
	return display_night_light_view_type_id;
}

GType
display_night_light_view_get_type (void)
{
	static volatile gsize display_night_light_view_type_id__once = 0;
	if (g_once_init_enter (&display_night_light_view_type_id__once)) {
		GType display_night_light_view_type_id;
		display_night_light_view_type_id = display_night_light_view_get_type_once ();
		g_once_init_leave (&display_night_light_view_type_id__once, display_night_light_view_type_id);
	}
	return display_night_light_view_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

