/* GalaDBus.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from GalaDBus.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-2.0-or-later
 * SPDX-FileCopyrightText: 2024 elementary, Inc. (https://elementary.io)
 */

#include "display.h"
#include <gio/gio.h>
#include <glib.h>
#include <string.h>
#include <stdlib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef GDBusProxy GalaDBusProxy;
typedef GDBusProxyClass GalaDBusProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

static GType gala_dbus_get_type_once (void);
static void gala_dbus_proxy_g_signal (GDBusProxy* proxy,
                               const gchar* sender_name,
                               const gchar* signal_name,
                               GVariant* parameters);
static void gala_dbus_proxy_show_monitor_labels (GalaDBus* self,
                                          MonitorLabelInfo* label_infos,
                                          gint label_infos_length1,
                                          GError** error);
static void gala_dbus_proxy_hide_monitor_labels (GalaDBus* self,
                                          GError** error);
static void gala_dbus_proxy_gala_dbus_interface_init (GalaDBusIface* iface);
static void _vala_MonitorLabelInfo_array_free (MonitorLabelInfo * array,
                                        gssize array_length);
static void _dbus_gala_dbus_show_monitor_labels (GalaDBus* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation);
static void _dbus_gala_dbus_hide_monitor_labels (GalaDBus* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation);
static void gala_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                           const gchar* sender,
                                           const gchar* object_path,
                                           const gchar* interface_name,
                                           const gchar* method_name,
                                           GVariant* parameters,
                                           GDBusMethodInvocation* invocation,
                                           gpointer user_data);
static GVariant* gala_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GError** error,
                                                 gpointer user_data);
static gboolean gala_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GVariant* value,
                                                GError** error,
                                                gpointer user_data);
static void _gala_dbus_unregister_object (gpointer user_data);

static const GDBusArgInfo _gala_dbus_dbus_arg_info_show_monitor_labels_label_infos = {-1, "label_infos", "a(isssii)", NULL};
static const GDBusArgInfo * const _gala_dbus_dbus_arg_info_show_monitor_labels_in[] = {&_gala_dbus_dbus_arg_info_show_monitor_labels_label_infos, NULL};
static const GDBusArgInfo * const _gala_dbus_dbus_arg_info_show_monitor_labels_out[] = {NULL};
static const GDBusMethodInfo _gala_dbus_dbus_method_info_show_monitor_labels = {-1, "ShowMonitorLabels", (GDBusArgInfo **) (&_gala_dbus_dbus_arg_info_show_monitor_labels_in), (GDBusArgInfo **) (&_gala_dbus_dbus_arg_info_show_monitor_labels_out), NULL};
static const GDBusArgInfo * const _gala_dbus_dbus_arg_info_hide_monitor_labels_in[] = {NULL};
static const GDBusArgInfo * const _gala_dbus_dbus_arg_info_hide_monitor_labels_out[] = {NULL};
static const GDBusMethodInfo _gala_dbus_dbus_method_info_hide_monitor_labels = {-1, "HideMonitorLabels", (GDBusArgInfo **) (&_gala_dbus_dbus_arg_info_hide_monitor_labels_in), (GDBusArgInfo **) (&_gala_dbus_dbus_arg_info_hide_monitor_labels_out), NULL};
static const GDBusMethodInfo * const _gala_dbus_dbus_method_info[] = {&_gala_dbus_dbus_method_info_show_monitor_labels, &_gala_dbus_dbus_method_info_hide_monitor_labels, NULL};
static const GDBusSignalInfo * const _gala_dbus_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _gala_dbus_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gala_dbus_dbus_interface_info = {-1, "org.pantheon.gala.daemon", (GDBusMethodInfo **) (&_gala_dbus_dbus_method_info), (GDBusSignalInfo **) (&_gala_dbus_dbus_signal_info), (GDBusPropertyInfo **) (&_gala_dbus_dbus_property_info), NULL};
static const GDBusInterfaceVTable _gala_dbus_dbus_interface_vtable = {gala_dbus_dbus_interface_method_call, gala_dbus_dbus_interface_get_property, gala_dbus_dbus_interface_set_property};

void
gala_dbus_show_monitor_labels (GalaDBus* self,
                               MonitorLabelInfo* label_infos,
                               gint label_infos_length1,
                               GError** error)
{
	GalaDBusIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_DBUS_GET_INTERFACE (self);
	if (_iface_->show_monitor_labels) {
		_iface_->show_monitor_labels (self, label_infos, label_infos_length1, error);
	}
}

void
gala_dbus_hide_monitor_labels (GalaDBus* self,
                               GError** error)
{
	GalaDBusIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_DBUS_GET_INTERFACE (self);
	if (_iface_->hide_monitor_labels) {
		_iface_->hide_monitor_labels (self, error);
	}
}

static void
gala_dbus_default_init (GalaDBusIface * iface,
                        gpointer iface_data)
{
}

static GType
gala_dbus_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaDBusIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_dbus_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gala_dbus_type_id;
	gala_dbus_type_id = g_type_register_static (G_TYPE_INTERFACE, "GalaDBus", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gala_dbus_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (gala_dbus_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gala_dbus_proxy_get_type);
	g_type_set_qdata (gala_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.pantheon.gala.daemon");
	g_type_set_qdata (gala_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_gala_dbus_dbus_interface_info));
	g_type_set_qdata (gala_dbus_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gala_dbus_register_object);
	return gala_dbus_type_id;
}

GType
gala_dbus_get_type (void)
{
	static volatile gsize gala_dbus_type_id__once = 0;
	if (g_once_init_enter (&gala_dbus_type_id__once)) {
		GType gala_dbus_type_id;
		gala_dbus_type_id = gala_dbus_get_type_once ();
		g_once_init_leave (&gala_dbus_type_id__once, gala_dbus_type_id);
	}
	return gala_dbus_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (GalaDBusProxy, gala_dbus_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_GALA_DBUS, gala_dbus_proxy_gala_dbus_interface_init) )
static void
gala_dbus_proxy_class_init (GalaDBusProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = gala_dbus_proxy_g_signal;
}

static void
gala_dbus_proxy_g_signal (GDBusProxy* proxy,
                          const gchar* sender_name,
                          const gchar* signal_name,
                          GVariant* parameters)
{
}

static void
gala_dbus_proxy_init (GalaDBusProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_gala_dbus_dbus_interface_info));
}

static void
gala_dbus_proxy_show_monitor_labels (GalaDBus* self,
                                     MonitorLabelInfo* label_infos,
                                     gint label_infos_length1,
                                     GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	MonitorLabelInfo* _tmp2_;
	GVariantBuilder _tmp3_;
	gint _tmp4_;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.pantheon.gala.daemon", "ShowMonitorLabels");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_tmp2_ = label_infos;
	g_variant_builder_init (&_tmp3_, G_VARIANT_TYPE ("a(isssii)"));
	for (_tmp4_ = 0; _tmp4_ < label_infos_length1; _tmp4_++) {
		GVariantBuilder _tmp5_;
		g_variant_builder_init (&_tmp5_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp5_, g_variant_new_int32 ((*_tmp2_).monitor));
		g_variant_builder_add_value (&_tmp5_, g_variant_new_string ((*_tmp2_).label));
		g_variant_builder_add_value (&_tmp5_, g_variant_new_string ((*_tmp2_).background_color));
		g_variant_builder_add_value (&_tmp5_, g_variant_new_string ((*_tmp2_).text_color));
		g_variant_builder_add_value (&_tmp5_, g_variant_new_int32 ((*_tmp2_).x));
		g_variant_builder_add_value (&_tmp5_, g_variant_new_int32 ((*_tmp2_).y));
		g_variant_builder_add_value (&_tmp3_, g_variant_builder_end (&_tmp5_));
		_tmp2_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp3_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
gala_dbus_proxy_hide_monitor_labels (GalaDBus* self,
                                     GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.pantheon.gala.daemon", "HideMonitorLabels");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
gala_dbus_proxy_gala_dbus_interface_init (GalaDBusIface* iface)
{
	iface->show_monitor_labels = gala_dbus_proxy_show_monitor_labels;
	iface->hide_monitor_labels = gala_dbus_proxy_hide_monitor_labels;
}

static void
_vala_MonitorLabelInfo_array_free (MonitorLabelInfo * array,
                                   gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			monitor_label_info_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_dbus_gala_dbus_show_monitor_labels (GalaDBus* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	MonitorLabelInfo* label_infos = NULL;
	gint label_infos_length1 = 0;
	GVariant* _tmp6_;
	MonitorLabelInfo* _tmp7_;
	gint _tmp7__length;
	gint _tmp7__size;
	gint _tmp7__length1;
	GVariantIter _tmp8_;
	GVariant* _tmp9_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp7_ = g_new (MonitorLabelInfo, 5);
	_tmp7__length = 0;
	_tmp7__size = 4;
	_tmp7__length1 = 0;
	g_variant_iter_init (&_tmp8_, _tmp6_);
	for (; (_tmp9_ = g_variant_iter_next_value (&_tmp8_)) != NULL; _tmp7__length1++) {
		MonitorLabelInfo _tmp10_;
		GVariantIter _tmp11_;
		GVariant* _tmp12_;
		GVariant* _tmp13_;
		GVariant* _tmp14_;
		GVariant* _tmp15_;
		GVariant* _tmp16_;
		GVariant* _tmp17_;
		if (_tmp7__size == _tmp7__length) {
			_tmp7__size = 2 * _tmp7__size;
			_tmp7_ = g_renew (MonitorLabelInfo, _tmp7_, _tmp7__size + 1);
		}
		g_variant_iter_init (&_tmp11_, _tmp9_);
		_tmp12_ = g_variant_iter_next_value (&_tmp11_);
		_tmp10_.monitor = g_variant_get_int32 (_tmp12_);
		g_variant_unref (_tmp12_);
		_tmp13_ = g_variant_iter_next_value (&_tmp11_);
		_tmp10_.label = g_variant_dup_string (_tmp13_, NULL);
		g_variant_unref (_tmp13_);
		_tmp14_ = g_variant_iter_next_value (&_tmp11_);
		_tmp10_.background_color = g_variant_dup_string (_tmp14_, NULL);
		g_variant_unref (_tmp14_);
		_tmp15_ = g_variant_iter_next_value (&_tmp11_);
		_tmp10_.text_color = g_variant_dup_string (_tmp15_, NULL);
		g_variant_unref (_tmp15_);
		_tmp16_ = g_variant_iter_next_value (&_tmp11_);
		_tmp10_.x = g_variant_get_int32 (_tmp16_);
		g_variant_unref (_tmp16_);
		_tmp17_ = g_variant_iter_next_value (&_tmp11_);
		_tmp10_.y = g_variant_get_int32 (_tmp17_);
		g_variant_unref (_tmp17_);
		_tmp7_[_tmp7__length++] = _tmp10_;
		g_variant_unref (_tmp9_);
	}
	label_infos_length1 = _tmp7__length1;
	label_infos = _tmp7_;
	g_variant_unref (_tmp6_);
	gala_dbus_show_monitor_labels (self, label_infos, label_infos_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	label_infos = (_vala_MonitorLabelInfo_array_free (label_infos, label_infos_length1), NULL);
	;
}

static void
_dbus_gala_dbus_hide_monitor_labels (GalaDBus* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	gala_dbus_hide_monitor_labels (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
gala_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                      const gchar* sender,
                                      const gchar* object_path,
                                      const gchar* interface_name,
                                      const gchar* method_name,
                                      GVariant* parameters,
                                      GDBusMethodInvocation* invocation,
                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ShowMonitorLabels") == 0) {
		_dbus_gala_dbus_show_monitor_labels (object, parameters, invocation);
	} else if (strcmp (method_name, "HideMonitorLabels") == 0) {
		_dbus_gala_dbus_hide_monitor_labels (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
gala_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                       const gchar* sender,
                                       const gchar* object_path,
                                       const gchar* interface_name,
                                       const gchar* property_name,
                                       GError** error,
                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
gala_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                       const gchar* sender,
                                       const gchar* object_path,
                                       const gchar* interface_name,
                                       const gchar* property_name,
                                       GVariant* value,
                                       GError** error,
                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
gala_dbus_register_object (gpointer object,
                           GDBusConnection* connection,
                           const gchar* path,
                           GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gala_dbus_dbus_interface_info), &_gala_dbus_dbus_interface_vtable, data, _gala_dbus_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_gala_dbus_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
monitor_label_info_copy (const MonitorLabelInfo* self,
                         MonitorLabelInfo* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	(*dest).monitor = (*self).monitor;
	_tmp0_ = (*self).label;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).label);
	(*dest).label = _tmp1_;
	_tmp2_ = (*self).background_color;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).background_color);
	(*dest).background_color = _tmp3_;
	_tmp4_ = (*self).text_color;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).text_color);
	(*dest).text_color = _tmp5_;
	(*dest).x = (*self).x;
	(*dest).y = (*self).y;
}

void
monitor_label_info_destroy (MonitorLabelInfo* self)
{
	_g_free0 ((*self).label);
	_g_free0 ((*self).background_color);
	_g_free0 ((*self).text_color);
}

MonitorLabelInfo*
monitor_label_info_dup (const MonitorLabelInfo* self)
{
	MonitorLabelInfo* dup;
	dup = g_new0 (MonitorLabelInfo, 1);
	monitor_label_info_copy (self, dup);
	return dup;
}

void
monitor_label_info_free (MonitorLabelInfo* self)
{
	monitor_label_info_destroy (self);
	g_free (self);
}

static GType
monitor_label_info_get_type_once (void)
{
	GType monitor_label_info_type_id;
	monitor_label_info_type_id = g_boxed_type_register_static ("MonitorLabelInfo", (GBoxedCopyFunc) monitor_label_info_dup, (GBoxedFreeFunc) monitor_label_info_free);
	return monitor_label_info_type_id;
}

GType
monitor_label_info_get_type (void)
{
	static volatile gsize monitor_label_info_type_id__once = 0;
	if (g_once_init_enter (&monitor_label_info_type_id__once)) {
		GType monitor_label_info_type_id;
		monitor_label_info_type_id = monitor_label_info_get_type_once ();
		g_once_init_leave (&monitor_label_info_type_id__once, monitor_label_info_type_id);
	}
	return monitor_label_info_type_id__once;
}

