/* Startup.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Startup.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2013-2023 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Akshay Shekher <voldyman666@gmail.com>
 *              Julien Spautz <spautz.julien@gmail.com>
 */

#include "applications.h"
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <granite-7.h>
#include <switchboard.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	STARTUP_PLUG_0_PROPERTY,
	STARTUP_PLUG_NUM_PROPERTIES
};
static GParamSpec* startup_plug_properties[STARTUP_PLUG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GdkFileList_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkFileList_free (var), NULL)))

struct _StartupPlugPrivate {
	StartupController* controller;
	GtkListBox* list;
	StartupWidgetsAppChooser* app_chooser;
};

struct _Block2Data {
	int _ref_count_;
	StartupPlug* self;
	StartupBackendKeyFile* key_file;
};

static gint StartupPlug_private_offset;
static gpointer startup_plug_parent_class = NULL;

static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda25_ (Block2Data* _data2_,
                  gboolean active);
static void ___lambda25__startup_widgets_app_row_active_changed (StartupWidgetsAppRow* _sender,
                                                          gboolean active,
                                                          gpointer self);
static void startup_plug_create_file (StartupPlug* self,
                               const gchar* path);
VALA_EXTERN StartupBackendKeyFile* startup_backend_key_file_factory_get_or_create (const gchar* path);
static gchar* startup_plug_get_path_from_uri (StartupPlug* self,
                                       const gchar* uri);
static gint startup_plug_sort_function (StartupPlug* self,
                                 GtkListBoxRow* row1,
                                 GtkListBoxRow* row2);
static gboolean startup_plug_on_drag_data_received (StartupPlug* self,
                                             GtkDropTarget* drop_target,
                                             GValue* val,
                                             gdouble x,
                                             gdouble y);
static GdkFileList* _vala_GdkFileList_copy (GdkFileList* self);
static void _vala_GdkFileList_free (GdkFileList* self);
static GObject * startup_plug_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
VALA_EXTERN void startup_backend_key_file_factory_init (void);
static gint _startup_plug_sort_function_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                         GtkListBoxRow* row2,
                                                         gpointer self);
static void _startup_plug___lambda27_ (StartupPlug* self);
static void __startup_plug___lambda27__gtk_button_clicked (GtkButton* _sender,
                                                    gpointer self);
static void _startup_plug___lambda28_ (StartupPlug* self,
                                const gchar* path);
static void __startup_plug___lambda28__startup_widgets_app_chooser_app_chosen (StartupWidgetsAppChooser* _sender,
                                                                        const gchar* path,
                                                                        gpointer self);
static void _startup_plug___lambda29_ (StartupPlug* self,
                                const gchar* command);
static void __startup_plug___lambda29__startup_widgets_app_chooser_custom_command_chosen (StartupWidgetsAppChooser* _sender,
                                                                                   const gchar* command,
                                                                                   gpointer self);
static gboolean _startup_plug_on_drag_data_received_gtk_drop_target_drop (GtkDropTarget* _sender,
                                                                   GValue* value,
                                                                   gdouble x,
                                                                   gdouble y,
                                                                   gpointer self);
static void _startup_plug___lambda30_ (StartupPlug* self,
                                const gchar* path);
static void __startup_plug___lambda30__startup_backend_monitor_file_created (StartupBackendMonitor* _sender,
                                                                      const gchar* path,
                                                                      gpointer self);
static void _startup_plug___lambda31_ (StartupPlug* self,
                                const gchar* path);
static void __startup_plug___lambda31__startup_backend_monitor_file_deleted (StartupBackendMonitor* _sender,
                                                                      const gchar* path,
                                                                      gpointer self);
static void startup_plug_finalize (GObject * obj);
static GType startup_plug_get_type_once (void);

static inline gpointer
startup_plug_get_instance_private (StartupPlug* self)
{
	return G_STRUCT_MEMBER_P (self, StartupPlug_private_offset);
}

StartupPlug*
startup_plug_construct (GType object_type)
{
	StartupPlug * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("preferences-desktop-startup");
	_tmp1_ = _tmp0_;
	self = (StartupPlug*) g_object_new (object_type, "title", _ ("Startup"), "icon", _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

StartupPlug*
startup_plug_new (void)
{
	return startup_plug_construct (STARTUP_TYPE_PLUG);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		StartupPlug* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->key_file);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda25_ (Block2Data* _data2_,
             gboolean active)
{
	StartupPlug* self;
	self = _data2_->self;
	startup_backend_key_file_set_active (_data2_->key_file, active);
	startup_backend_key_file_write_to_file (_data2_->key_file);
}

static void
___lambda25__startup_widgets_app_row_active_changed (StartupWidgetsAppRow* _sender,
                                                     gboolean active,
                                                     gpointer self)
{
	__lambda25_ (self, active);
}

void
startup_plug_add_app (StartupPlug* self,
                      StartupBackendKeyFile* key_file)
{
	Block2Data* _data2_;
	StartupBackendKeyFile* _tmp0_;
	StartupEntityAppInfo app_info = {0};
	StartupEntityAppInfo _tmp1_ = {0};
	GtkWidget* child = NULL;
	GtkListBox* _tmp2_;
	GtkWidget* _tmp3_;
	StartupWidgetsAppRow* row = NULL;
	StartupEntityAppInfo _tmp13_;
	StartupWidgetsAppRow* _tmp14_;
	GtkListBox* _tmp15_;
	StartupWidgetsAppRow* _tmp16_;
	StartupWidgetsAppRow* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key_file != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (key_file);
	_g_object_unref0 (_data2_->key_file);
	_data2_->key_file = _tmp0_;
	startup_backend_key_file_create_app_info (_data2_->key_file, &_tmp1_);
	app_info = _tmp1_;
	_tmp2_ = self->priv->list;
	_tmp3_ = gtk_widget_get_first_child ((GtkWidget*) _tmp2_);
	child = _tmp3_;
	while (TRUE) {
		GtkWidget* _tmp4_;
		gboolean _tmp5_ = FALSE;
		GtkWidget* _tmp6_;
		GtkWidget* _tmp11_;
		GtkWidget* _tmp12_;
		_tmp4_ = child;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		_tmp6_ = child;
		if (STARTUP_WIDGETS_IS_APP_ROW (_tmp6_)) {
			GtkWidget* _tmp7_;
			StartupEntityAppInfo _tmp8_ = {0};
			StartupEntityAppInfo _tmp9_;
			StartupEntityAppInfo _tmp10_;
			_tmp7_ = child;
			startup_widgets_app_row_get_app_info (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, STARTUP_WIDGETS_TYPE_APP_ROW, StartupWidgetsAppRow), &_tmp8_);
			_tmp9_ = _tmp8_;
			_tmp10_ = app_info;
			_tmp5_ = startup_entity_app_info_equal (&_tmp9_, &_tmp10_);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			startup_entity_app_info_destroy (&app_info);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			return;
		}
		_tmp11_ = child;
		_tmp12_ = gtk_widget_get_next_sibling (_tmp11_);
		child = _tmp12_;
	}
	_tmp13_ = app_info;
	_tmp14_ = startup_widgets_app_row_new (&_tmp13_);
	g_object_ref_sink (_tmp14_);
	row = _tmp14_;
	_tmp15_ = self->priv->list;
	_tmp16_ = row;
	gtk_list_box_append (_tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = row;
	g_signal_connect_data (_tmp17_, "active-changed", (GCallback) ___lambda25__startup_widgets_app_row_active_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_g_object_unref0 (row);
	startup_entity_app_info_destroy (&app_info);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

void
startup_plug_remove_app_from_path (StartupPlug* self,
                                   const gchar* path)
{
	GtkWidget* child = NULL;
	GtkListBox* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->list;
	_tmp1_ = gtk_widget_get_first_child ((GtkWidget*) _tmp0_);
	child = _tmp1_;
	while (TRUE) {
		GtkWidget* _tmp2_;
		gboolean _tmp3_ = FALSE;
		GtkWidget* _tmp4_;
		GtkWidget* _tmp11_;
		GtkWidget* _tmp12_;
		_tmp2_ = child;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp4_ = child;
		if (STARTUP_WIDGETS_IS_APP_ROW (_tmp4_)) {
			GtkWidget* _tmp5_;
			StartupEntityAppInfo _tmp6_ = {0};
			StartupEntityAppInfo _tmp7_;
			const gchar* _tmp8_;
			_tmp5_ = child;
			startup_widgets_app_row_get_app_info (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, STARTUP_WIDGETS_TYPE_APP_ROW, StartupWidgetsAppRow), &_tmp6_);
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_.path;
			_tmp3_ = g_strcmp0 (_tmp8_, path) == 0;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			GtkListBox* _tmp9_;
			GtkWidget* _tmp10_;
			_tmp9_ = self->priv->list;
			_tmp10_ = child;
			gtk_list_box_remove (_tmp9_, (GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, STARTUP_WIDGETS_TYPE_APP_ROW, StartupWidgetsAppRow));
			return;
		}
		_tmp11_ = child;
		_tmp12_ = gtk_widget_get_next_sibling (_tmp11_);
		child = _tmp12_;
	}
}

void
startup_plug_init_app_chooser (StartupPlug* self,
                               GeeCollection* app_infos)
{
	StartupWidgetsAppChooser* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app_infos != NULL);
	_tmp0_ = self->priv->app_chooser;
	startup_widgets_app_chooser_init_list (_tmp0_, app_infos);
}

static void
startup_plug_create_file (StartupPlug* self,
                          const gchar* path)
{
	StartupBackendKeyFile* key_file = NULL;
	StartupBackendKeyFile* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = startup_backend_key_file_factory_get_or_create (path);
	key_file = _tmp0_;
	startup_backend_key_file_set_active (key_file, TRUE);
	startup_backend_key_file_copy_to_local (key_file);
	startup_plug_add_app (self, key_file);
	_g_object_unref0 (key_file);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
startup_plug_get_path_from_uri (StartupPlug* self,
                                const gchar* uri)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	if (g_str_has_prefix (uri, "#")) {
		_tmp0_ = TRUE;
	} else {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = string_strip (uri);
		_tmp2_ = _tmp1_;
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
		_g_free0 (_tmp2_);
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	{
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = g_filename_from_uri (uri, NULL, &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		result = _tmp5_;
		_g_free0 (_tmp3_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_warning ("Startup.vala:153: Could not convert URI of dropped item to filename");
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("Startup.vala:154: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	return result;
}

static gint
startup_plug_sort_function (StartupPlug* self,
                            GtkListBoxRow* row1,
                            GtkListBoxRow* row2)
{
	gchar* name_1 = NULL;
	StartupEntityAppInfo _tmp0_ = {0};
	StartupEntityAppInfo _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* name_2 = NULL;
	StartupEntityAppInfo _tmp4_ = {0};
	StartupEntityAppInfo _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	startup_widgets_app_row_get_app_info (G_TYPE_CHECK_INSTANCE_CAST (row1, STARTUP_WIDGETS_TYPE_APP_ROW, StartupWidgetsAppRow), &_tmp0_);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_.name;
	_tmp3_ = g_strdup (_tmp2_);
	name_1 = _tmp3_;
	startup_widgets_app_row_get_app_info (G_TYPE_CHECK_INSTANCE_CAST (row2, STARTUP_WIDGETS_TYPE_APP_ROW, StartupWidgetsAppRow), &_tmp4_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_.name;
	_tmp7_ = g_strdup (_tmp6_);
	name_2 = _tmp7_;
	result = g_utf8_collate (name_1, name_2);
	_g_free0 (name_2);
	_g_free0 (name_1);
	return result;
}

static GdkFileList*
_vala_GdkFileList_copy (GdkFileList* self)
{
	return g_boxed_copy (gdk_file_list_get_type (), self);
}

static gpointer
__vala_GdkFileList_copy0 (gpointer self)
{
	return self ? _vala_GdkFileList_copy (self) : NULL;
}

static void
_vala_GdkFileList_free (GdkFileList* self)
{
	g_boxed_free (gdk_file_list_get_type (), self);
}

static gboolean
startup_plug_on_drag_data_received (StartupPlug* self,
                                    GtkDropTarget* drop_target,
                                    GValue* val,
                                    gdouble x,
                                    gdouble y)
{
	GdkFileList* file_list = NULL;
	GValue _tmp0_;
	GdkFileList* _tmp1_;
	GSList* files = NULL;
	GdkFileList* _tmp2_;
	GSList* _tmp3_;
	GSList* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (drop_target != NULL, FALSE);
	g_return_val_if_fail (val != NULL, FALSE);
	_tmp0_ = *val;
	_tmp1_ = __vala_GdkFileList_copy0 (g_value_get_boxed (&_tmp0_));
	file_list = _tmp1_;
	_tmp2_ = file_list;
	_tmp3_ = gdk_file_list_get_files (_tmp2_);
	files = _tmp3_;
	_tmp4_ = files;
	{
		GSList* file_collection = NULL;
		GSList* file_it = NULL;
		file_collection = _tmp4_;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			GFile* file = NULL;
			file = (GFile*) file_it->data;
			{
				gchar* path = NULL;
				GFile* _tmp5_;
				gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp5_ = file;
				_tmp6_ = g_file_get_path (_tmp5_);
				path = _tmp6_;
				_tmp7_ = path;
				if (_tmp7_ != NULL) {
					const gchar* _tmp8_;
					_tmp8_ = path;
					startup_plug_create_file (self, _tmp8_);
				}
				_g_free0 (path);
			}
		}
	}
	result = FALSE;
	(files == NULL) ? NULL : (files = (g_slist_free (files), NULL));
	__vala_GdkFileList_free0 (file_list);
	return result;
}

static gint
_startup_plug_sort_function_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                    GtkListBoxRow* row2,
                                                    gpointer self)
{
	gint result;
	result = startup_plug_sort_function ((StartupPlug*) self, row1, row2);
	return result;
}

static void
_startup_plug___lambda27_ (StartupPlug* self)
{
	StartupWidgetsAppChooser* _tmp0_;
	GtkRoot* _tmp1_;
	StartupWidgetsAppChooser* _tmp2_;
	_tmp0_ = self->priv->app_chooser;
	_tmp1_ = gtk_widget_get_root ((GtkWidget*) self);
	gtk_window_set_transient_for ((GtkWindow*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow));
	_tmp2_ = self->priv->app_chooser;
	gtk_window_present ((GtkWindow*) _tmp2_);
}

static void
__startup_plug___lambda27__gtk_button_clicked (GtkButton* _sender,
                                               gpointer self)
{
	_startup_plug___lambda27_ ((StartupPlug*) self);
}

static void
_startup_plug___lambda28_ (StartupPlug* self,
                           const gchar* path)
{
	g_return_if_fail (path != NULL);
	startup_plug_create_file (self, path);
}

static void
__startup_plug___lambda28__startup_widgets_app_chooser_app_chosen (StartupWidgetsAppChooser* _sender,
                                                                   const gchar* path,
                                                                   gpointer self)
{
	_startup_plug___lambda28_ ((StartupPlug*) self, path);
}

static void
_startup_plug___lambda29_ (StartupPlug* self,
                           const gchar* command)
{
	StartupBackendKeyFile* _tmp0_;
	StartupBackendKeyFile* _tmp1_;
	g_return_if_fail (command != NULL);
	_tmp0_ = startup_backend_key_file_new_from_command (command);
	_tmp1_ = _tmp0_;
	startup_plug_add_app (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
}

static void
__startup_plug___lambda29__startup_widgets_app_chooser_custom_command_chosen (StartupWidgetsAppChooser* _sender,
                                                                              const gchar* command,
                                                                              gpointer self)
{
	_startup_plug___lambda29_ ((StartupPlug*) self, command);
}

static gboolean
_startup_plug_on_drag_data_received_gtk_drop_target_drop (GtkDropTarget* _sender,
                                                          GValue* value,
                                                          gdouble x,
                                                          gdouble y,
                                                          gpointer self)
{
	gboolean result;
	result = startup_plug_on_drag_data_received ((StartupPlug*) self, _sender, value, x, y);
	return result;
}

static void
_startup_plug___lambda30_ (StartupPlug* self,
                           const gchar* path)
{
	StartupBackendKeyFile* _tmp0_;
	StartupBackendKeyFile* _tmp1_;
	g_return_if_fail (path != NULL);
	_tmp0_ = startup_backend_key_file_factory_get_or_create (path);
	_tmp1_ = _tmp0_;
	startup_plug_add_app (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
}

static void
__startup_plug___lambda30__startup_backend_monitor_file_created (StartupBackendMonitor* _sender,
                                                                 const gchar* path,
                                                                 gpointer self)
{
	_startup_plug___lambda30_ ((StartupPlug*) self, path);
}

static void
_startup_plug___lambda31_ (StartupPlug* self,
                           const gchar* path)
{
	g_return_if_fail (path != NULL);
	startup_plug_remove_app_from_path (self, path);
}

static void
__startup_plug___lambda31__startup_backend_monitor_file_deleted (StartupBackendMonitor* _sender,
                                                                 const gchar* path,
                                                                 gpointer self)
{
	_startup_plug___lambda31_ ((StartupPlug*) self, path);
}

static GObject *
startup_plug_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	StartupPlug * self;
	GranitePlaceholder* empty_alert = NULL;
	gchar* _tmp0_;
	GranitePlaceholder* _tmp1_ = NULL;
	GtkListBox* _tmp2_ = NULL;
	GtkListBox* _tmp3_;
	GtkListBox* _tmp4_;
	GranitePlaceholder* _tmp5_;
	GtkListBox* _tmp6_;
	GtkDropTarget* drop_target = NULL;
	GtkDropTarget* _tmp7_;
	GtkListBox* _tmp8_;
	GtkDropTarget* _tmp9_;
	GtkEventController* _tmp10_;
	GtkScrolledWindow* scrolled = NULL;
	GtkListBox* _tmp11_;
	GtkWidget* _tmp12_;
	GtkScrolledWindow* _tmp13_ = NULL;
	GtkBox* add_button_box = NULL;
	GtkBox* _tmp14_;
	GtkBox* _tmp15_;
	GtkImage* _tmp16_;
	GtkImage* _tmp17_;
	GtkBox* _tmp18_;
	GtkLabel* _tmp19_;
	GtkLabel* _tmp20_;
	GtkButton* add_button = NULL;
	GtkBox* _tmp21_;
	GtkWidget* _tmp22_;
	GtkButton* _tmp23_ = NULL;
	GtkButton* _tmp24_;
	GtkActionBar* actionbar = NULL;
	GtkActionBar* _tmp25_;
	GtkActionBar* _tmp26_;
	GtkActionBar* _tmp27_;
	GtkButton* _tmp28_;
	GtkBox* box = NULL;
	GtkBox* _tmp29_;
	GtkBox* _tmp30_;
	GtkScrolledWindow* _tmp31_;
	GtkBox* _tmp32_;
	GtkActionBar* _tmp33_;
	GtkFrame* frame = NULL;
	GtkBox* _tmp34_;
	GtkWidget* _tmp35_;
	GtkFrame* _tmp36_ = NULL;
	GtkFrame* _tmp37_;
	StartupWidgetsAppChooser* _tmp38_ = NULL;
	StartupBackendMonitor* monitor = NULL;
	StartupBackendMonitor* _tmp39_;
	StartupController* _tmp40_;
	GtkButton* _tmp41_;
	StartupWidgetsAppChooser* _tmp42_;
	StartupWidgetsAppChooser* _tmp43_;
	GtkDropTarget* _tmp44_;
	StartupBackendMonitor* _tmp45_;
	StartupBackendMonitor* _tmp46_;
	parent_class = G_OBJECT_CLASS (startup_plug_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, STARTUP_TYPE_PLUG, StartupPlug);
	startup_backend_key_file_factory_init ();
	_tmp0_ = g_strdup (_ ("Add apps to the Startup list by clicking the icon in the toolbar below" \
"."));
	_tmp1_ = granite_placeholder_new (_ ("Launch Apps on Startup"));
	granite_placeholder_set_description (_tmp1_, _tmp0_);
	_g_free0 (_tmp0_);
	g_object_ref_sink (_tmp1_);
	empty_alert = _tmp1_;
	_tmp2_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp2_, TRUE);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->list);
	self->priv->list = _tmp2_;
	_tmp3_ = self->priv->list;
	gtk_widget_add_css_class ((GtkWidget*) _tmp3_, GRANITE_STYLE_CLASS_RICH_LIST);
	_tmp4_ = self->priv->list;
	_tmp5_ = empty_alert;
	gtk_list_box_set_placeholder (_tmp4_, (GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->list;
	gtk_list_box_set_sort_func (_tmp6_, _startup_plug_sort_function_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp7_ = gtk_drop_target_new (gdk_file_list_get_type (), GDK_ACTION_COPY);
	drop_target = _tmp7_;
	_tmp8_ = self->priv->list;
	_tmp9_ = drop_target;
	_tmp10_ = _g_object_ref0 ((GtkEventController*) _tmp9_);
	gtk_widget_add_controller ((GtkWidget*) _tmp8_, _tmp10_);
	_tmp11_ = self->priv->list;
	_tmp12_ = _g_object_ref0 ((GtkWidget*) _tmp11_);
	_tmp13_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp13_, _tmp12_);
	_g_object_unref0 (_tmp12_);
	g_object_ref_sink (_tmp13_);
	scrolled = _tmp13_;
	_tmp14_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp14_);
	add_button_box = _tmp14_;
	_tmp15_ = add_button_box;
	_tmp16_ = (GtkImage*) gtk_image_new_from_icon_name ("application-add-symbolic");
	g_object_ref_sink (_tmp16_);
	_tmp17_ = _tmp16_;
	gtk_box_append (_tmp15_, (GtkWidget*) _tmp17_);
	_g_object_unref0 (_tmp17_);
	_tmp18_ = add_button_box;
	_tmp19_ = (GtkLabel*) gtk_label_new (_ ("Add Startup App…"));
	g_object_ref_sink (_tmp19_);
	_tmp20_ = _tmp19_;
	gtk_box_append (_tmp18_, (GtkWidget*) _tmp20_);
	_g_object_unref0 (_tmp20_);
	_tmp21_ = add_button_box;
	_tmp22_ = _g_object_ref0 ((GtkWidget*) _tmp21_);
	_tmp23_ = (GtkButton*) gtk_button_new ();
	gtk_button_set_child (_tmp23_, _tmp22_);
	_g_object_unref0 (_tmp22_);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp23_, 3);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp23_, 3);
	g_object_ref_sink (_tmp23_);
	add_button = _tmp23_;
	_tmp24_ = add_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp24_, GRANITE_STYLE_CLASS_FLAT);
	_tmp25_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp25_);
	actionbar = _tmp25_;
	_tmp26_ = actionbar;
	gtk_widget_add_css_class ((GtkWidget*) _tmp26_, GRANITE_STYLE_CLASS_FLAT);
	_tmp27_ = actionbar;
	_tmp28_ = add_button;
	gtk_action_bar_pack_start (_tmp27_, (GtkWidget*) _tmp28_);
	_tmp29_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp29_);
	box = _tmp29_;
	_tmp30_ = box;
	_tmp31_ = scrolled;
	gtk_box_append (_tmp30_, (GtkWidget*) _tmp31_);
	_tmp32_ = box;
	_tmp33_ = actionbar;
	gtk_box_append (_tmp32_, (GtkWidget*) _tmp33_);
	_tmp34_ = box;
	_tmp35_ = _g_object_ref0 ((GtkWidget*) _tmp34_);
	_tmp36_ = (GtkFrame*) gtk_frame_new (NULL);
	gtk_frame_set_child (_tmp36_, _tmp35_);
	_g_object_unref0 (_tmp35_);
	g_object_ref_sink (_tmp36_);
	frame = _tmp36_;
	_tmp37_ = frame;
	switchboard_settings_page_set_child ((SwitchboardSettingsPage*) self, (GtkWidget*) _tmp37_);
	switchboard_settings_page_set_show_end_title_buttons ((SwitchboardSettingsPage*) self, TRUE);
	_tmp38_ = startup_widgets_app_chooser_new ();
	gtk_window_set_modal ((GtkWindow*) _tmp38_, TRUE);
	g_object_ref_sink (_tmp38_);
	_g_object_unref0 (self->priv->app_chooser);
	self->priv->app_chooser = _tmp38_;
	_tmp39_ = startup_backend_monitor_new ();
	monitor = _tmp39_;
	_tmp40_ = startup_controller_new (self);
	_g_object_unref0 (self->priv->controller);
	self->priv->controller = _tmp40_;
	_tmp41_ = add_button;
	g_signal_connect_object (_tmp41_, "clicked", (GCallback) __startup_plug___lambda27__gtk_button_clicked, self, 0);
	_tmp42_ = self->priv->app_chooser;
	g_signal_connect_object (_tmp42_, "app-chosen", (GCallback) __startup_plug___lambda28__startup_widgets_app_chooser_app_chosen, self, 0);
	_tmp43_ = self->priv->app_chooser;
	g_signal_connect_object (_tmp43_, "custom-command-chosen", (GCallback) __startup_plug___lambda29__startup_widgets_app_chooser_custom_command_chosen, self, 0);
	_tmp44_ = drop_target;
	g_signal_connect_object (_tmp44_, "drop", (GCallback) _startup_plug_on_drag_data_received_gtk_drop_target_drop, self, 0);
	_tmp45_ = monitor;
	g_signal_connect_object (_tmp45_, "file-created", (GCallback) __startup_plug___lambda30__startup_backend_monitor_file_created, self, 0);
	_tmp46_ = monitor;
	g_signal_connect_object (_tmp46_, "file-deleted", (GCallback) __startup_plug___lambda31__startup_backend_monitor_file_deleted, self, 0);
	_g_object_unref0 (monitor);
	_g_object_unref0 (frame);
	_g_object_unref0 (box);
	_g_object_unref0 (actionbar);
	_g_object_unref0 (add_button);
	_g_object_unref0 (add_button_box);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (drop_target);
	_g_object_unref0 (empty_alert);
	return obj;
}

static void
startup_plug_class_init (StartupPlugClass * klass,
                         gpointer klass_data)
{
	startup_plug_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &StartupPlug_private_offset);
	G_OBJECT_CLASS (klass)->constructor = startup_plug_constructor;
	G_OBJECT_CLASS (klass)->finalize = startup_plug_finalize;
}

static void
startup_plug_instance_init (StartupPlug * self,
                            gpointer klass)
{
	self->priv = startup_plug_get_instance_private (self);
}

static void
startup_plug_finalize (GObject * obj)
{
	StartupPlug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, STARTUP_TYPE_PLUG, StartupPlug);
	_g_object_unref0 (self->priv->controller);
	_g_object_unref0 (self->priv->list);
	_g_object_unref0 (self->priv->app_chooser);
	G_OBJECT_CLASS (startup_plug_parent_class)->finalize (obj);
}

static GType
startup_plug_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (StartupPlugClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) startup_plug_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StartupPlug), 0, (GInstanceInitFunc) startup_plug_instance_init, NULL };
	GType startup_plug_type_id;
	startup_plug_type_id = g_type_register_static (SWITCHBOARD_TYPE_SETTINGS_PAGE, "StartupPlug", &g_define_type_info, 0);
	StartupPlug_private_offset = g_type_add_instance_private (startup_plug_type_id, sizeof (StartupPlugPrivate));
	return startup_plug_type_id;
}

GType
startup_plug_get_type (void)
{
	static volatile gsize startup_plug_type_id__once = 0;
	if (g_once_init_enter (&startup_plug_type_id__once)) {
		GType startup_plug_type_id;
		startup_plug_type_id = startup_plug_get_type_once ();
		g_once_init_leave (&startup_plug_type_id__once, startup_plug_type_id);
	}
	return startup_plug_type_id__once;
}

