//------------------------------------------------------------------------------
// GB_JITpackage.c: packaged GraphBLAS source code for the JIT
//------------------------------------------------------------------------------

// SuiteSparse:GraphBLAS, Timothy A. Davis, (c) 2017-2025, All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0

//------------------------------------------------------------------------------

#include "GB_JITpackage.h"

#ifdef NJIT
// JIT is disabled at compile time
int GB_JITpackage_nfiles_get (void) { return (0) ; }
static GB_JITpackage_index_struct GB_JITpackage_index [1] =
   {{0, 0, NULL, NULL}} ;
#else
int GB_JITpackage_nfiles_get (void) { return (360) ; }

// ../CUDA/apply/template/GB_jit_kernel_cuda_apply_bind1st.cu:
uint8_t GB_JITpackage_0 [675] = {
 40,181, 47,253, 96,118,  4,205, 20,  0,102, 97,105, 33,224, 90, 23,  3,204,117,
107, 95,117, 84, 46,154,153, 35,228,134,210,143, 34,108, 30,181,229,196,206,176,
107,196, 24,  9, 49,252,  2, 96,  0, 94,  0, 96,  0, 79,177,222, 35,198,122,122,
 75,245,152, 26, 75,116,163,249, 44,183,205, 58,109,250, 13,254,103, 53, 75,221,
172, 47,202,110, 52, 97,102, 76, 90, 87,106,181, 26,237,104,178, 74, 19,159,173,
 91,155, 26,201, 51, 85,178, 22, 93,177, 78, 93,178,183,133,247,168,239,234, 60,
203,223,114, 92,161, 87, 53,230,151, 50, 70, 89, 89,230,120, 24,118, 22,  4, 57,
 18,235, 77,126, 51, 38, 93, 83, 16, 39,164,102,101,240,212,160,194, 17, 84,121,
166,200,115, 55,241,190,134,166,198, 86,174,143,132, 32, 37, 67,194,102,190,  2,
146, 59,185,109, 99,103,172,125,211, 97, 58, 21,207,138,149,122, 18, 22,124,223,
231,120, 10, 41,120,215,170,119,107,119,137,245, 70,175,182,214, 27, 33, 68, 71,
247, 45,253,112,184,227,218,181, 65,173, 31,156,123,122,112, 19,234, 88, 16, 44,
211, 50, 47, 96,134,  3, 94,108, 23,241,124,182, 83,177,  4,190,192,179,190, 59,
189, 89, 22,203, 98,167,195,224,248,131,195, 87,191,209,128, 98,229,  3, 94,210,
183,212,251,214,  1, 39, 39, 76,214,123, 32,167, 11, 63, 48, 18,187,227,151,149,
241,134, 93,211, 86,223, 72,175,222,179,164, 55,  1,112,132, 63,190,186,131,251,
234,219, 46, 24, 59,227,122,125,146, 76,172, 75,104,118,152,227,213,166, 29, 89,
204, 59,  4,  2,249,134,248,182, 61, 30,143,163,245,247,133,243,169, 77,101,118,
137,170,241,234, 45,106,215, 26,220,232, 24,238, 59,169,191,104, 68, 17,252, 62,
143, 88,159, 53,107, 95,125, 13,113,142,123,253, 11,173, 87,168,176, 25,134,158,
204, 57,192, 59, 28, 80, 20, 59,241,242,117, 94, 24,118,159,197, 39, 77, 71,195,
217,216,142,152,136,100, 42,158, 13,133,155, 77,103,195,105,168,113,161, 82,202,
140,144,140,  4,137,146, 74, 99, 48,132, 32,229,204,182,  1,146,168,160,164,243,
204, 84, 52,170,168,164, 82,217,159, 53, 29,100, 82,  7,160, 18, 80,  7,202,200,
239, 61, 13,130, 61,174,153,116, 36,211, 70, 39, 51,102,216,208, 64, 75,212, 27,
123,251, 32,141,198,193,110,110,255,173,  5,250, 21, 75, 18,169,  8,126, 40,230,
224, 45,119,216,254,103,124,221, 54, 97, 64,128,216, 32, 73,133,174,131,  1,247,
106,127,  2, 13, 88, 85, 80,184, 41,115,176,100,136,122, 60, 58,133,119, 66,181,
153,197,149, 19,101,210,222,  7, 16,102,150,222,192, 95,215,180,176,218, 27,156,
100, 15, 65, 72, 65, 74,157, 51,  5,127, 47, 69, 63, 13, 14, 35,201,147,165,187,
 27,213,131, 73,124,224,237, 48, 83,200, 14, 37,169, 78,204,251,228,134,102, 51,
230, 31, 65,136,133,  4,229,147,148,227, 51,231,217,178,183, 14,220,114, 80,179,
150, 77,  1,132,193,211, 78,101,108,190, 60,162,197, 88,233, 99,235,213,129,157,
194,130,126, 29,157,227,135,141,255, 72,155, 50,173, 69, 21,
} ;

// ../CUDA/apply/template/GB_jit_kernel_cuda_apply_bind2nd.cu:
uint8_t GB_JITpackage_1 [674] = {
 40,181, 47,253, 96,114,  4,197, 20,  0,134,161,105, 33,224, 88, 61,160,156,146,
135,123, 66,133,134,139,166,185, 55, 46,243, 12, 23,225,151, 25, 20,169, 75,121,
202, 96,134, 97,154,135,  3, 94,  0, 95,  0, 95,  0, 39,199, 35, 14,205,110,110,
 50,172,127,106,222,241,229, 62,184,214, 81,228, 61,187,236,255, 47,122,141,121,
243,108,186,226, 70,136, 91,131, 87, 53,150, 37,190, 88, 68,133,162, 38, 83,127,
239,136, 65,114, 28,221,107,150, 40,146,143,110, 78,233,142,121, 46, 73, 50,252,
 28,226,210,204, 39,188,127,180,181,137,186,174,237, 61,175, 94,107, 55,145,251,
144,124,222, 90,148, 69, 65,131, 83,164,100,127, 22, 78, 26, 98, 10,201, 17,124,
238, 69,221, 31, 51, 71,156,218,244, 33,158,157, 96,110, 21,105,113,103,  1,200,
 61,216, 47,163,111,141,189,166, 94, 56,148,199,253, 40,244, 69, 90,208,117,221,
246,167,131, 80, 31,163,245,239,237,161,230,221,204,252,222, 26, 58,128,222,236,
121,244,  6,195,111,143, 61,150, 81,250,217,115,127,190,213,124, 56,247,195,186,
176, 43,150, 91, 33,157,238,114, 40,149, 64, 23,248,205,115, 63,243,117,181,174,
 86,201,144,189,254,204,208,209,215,100,236, 71,241,216, 44,122,237,172,175,113,
172,164,164, 49,253,106, 55,213,235, 44,164,245,219,103,212,214,157,245, 24, 86,
190,  6, 86,250,245,130, 15,  9,128,190,136, 27,124,227,203,223,184, 47,191, 95,
197,162,111, 77,159,147, 34, 81,243,145,185, 55, 17,103, 78,234, 31, 87, 75,171,
 14,135,227,181,195,107, 90,163,209,120,147,126, 94,233, 77,114, 82,184, 85,223,
  9,103,222, 63,236, 57,183,221,196, 94,207, 18,250,150,204,247,217,174,235,124,
244, 55, 71,245,204, 31, 59, 60,199, 61,253,149, 73, 63,113,210,162,231,117, 48,
207,  1,158,179,177,223, 87, 63, 75, 87, 31,158, 87,187,219,117, 41,195,201,108,
 52, 23,130, 65, 64, 48, 31, 79,163,169,215,179,152,141, 13,102,168, 65,161, 82,
202,144,144, 12,  5,137,210,202, 26, 48, 68, 96, 20,100,183, 13,178,176,124, 42,
212, 14, 89, 68, 34, 37, 37,149,202,254,172,  1, 25,100, 78, 95, 80,186, 89,  7,
 57,159,167, 37, 24,197, 34, 46,107, 69,105,244,242, 55,166, 94,119,155, 40, 63,
 99, 23, 54,168,200,154,130,  7,230,228,123, 66, 26,219,129,169,  8,125, 16,113,
131,183,221,187,214,120,106,215,165, 12,  6,132,199, 30, 35,149,190,158, 25, 80,
193,253,  8,  8,185,197, 32, 10, 69,117,176, 97, 90,151,153,219,158, 72,183,237,
142,201,177,226,164,113,250, 69,242,123,144, 90,134,243,202,123,  1,167,165,213,
100,184, 71,  1, 65,195,190,157, 59,252,141, 41,240, 83,114,128,145,252, 44,125,
123,138,116, 73,178, 62,246, 24,225,132,193,144,147,234, 54, 51, 73,190, 53, 39,
222, 19, 76, 42, 36, 53, 38, 55,226, 25,111,218,250,119,148, 15, 93, 31,185,190,
 38,142,225,203,218, 85,121,175,151,103,176, 34,176,177,219,136,  4,118,132,165,
 11, 48,  8,119, 22,216,152, 66,220, 41, 83, 74, 84,  1,
} ;

// ../CUDA/apply/template/GB_jit_kernel_cuda_apply_unop.cu:
uint8_t GB_JITpackage_2 [1196] = {
 40,181, 47,253, 96,222, 14, 21, 37,  0,230, 46,145, 41,192,146,177, 14,218,152,
 67, 95,179,253,106,160, 39,  6, 11,183,185, 84,193,166, 84,100,228,  1, 22,100,
169, 72, 17, 38, 26,211,101,192, 52,  9,  2,210, 36,  7,  1,130,  0,135,  0,130,
  0, 17, 25,136,117, 76,213,132,125, 36,111,142, 20,176,114,173,156, 49,173,156,
149,191, 10, 71, 25,228,255, 68, 77,179,233,109, 16,180,149,126,144, 52,173,141,
239,100, 21, 29,194, 25, 59,117,126, 32,156, 38,  6,  5,132,132,119, 73,210,207,
227,160,194,167,206,105, 10,240, 62,238,160, 57, 57, 49,  4, 53,140,221,199, 69,
 58,199,105, 67,157,  3,222,221, 55, 57, 42,  5,176,253,234,253,192, 22,201, 28,
111,219, 90,185, 55, 23, 45,238, 80,164,255, 80,137,191,105,146, 28,131,193,160,
166,113, 30, 96,  5,226, 77,165,167, 59,129,163,131,144,180,128,184, 58, 59,191,
222,201,252,198,145,251,156,159, 39, 98, 99, 40,203,206, 84, 29,131,177,120,160,
168, 67,126, 65,140,182,164,124, 79,165,222,223,140,162, 63,247,231,145,  8,134,
166, 98,  9,177, 44,203, 58,157, 12, 29, 50,149, 27,140,162,226, 82,177,214, 90,
111,195,219,144,144, 82,202, 11, 39,194,195,227,218,198,193, 54, 27,220, 46, 30,
217,209,150,124, 68, 49,192, 94, 81,191, 62,194, 14, 97,230,228,205,184, 47,132,
144,107, 27,140,138,234, 23, 48,163,129,155, 37,163,109, 52, 11,117,143, 20,168,
 74, 52, 82,183, 96,180,183, 74, 22,163, 78,153,216, 47, 55,134,182, 78,252, 28,
235,244,100, 28, 39,232, 86, 66,231,195,208, 34,133,170,201,228,122,198, 87,122,
186,234,229, 14,253,181,123,205,239,186, 41,215, 34,122,219,146,188, 72,227, 27,
 45,110, 60,251,163,178, 44, 11,187,101,111,141, 50,234, 27, 77,198, 34, 50, 43,
 55,112,125,212, 73,200, 81,239, 71,127, 84,230,142, 87,149,189,213,193,168, 99,
176, 83,129,  0,232,184, 10, 74, 52,126, 34,161,126,171,231, 58,237, 41,138,207,
144,161, 65,210,201,251,193, 84,210,197,190,  5,163,238,  2,121,211,  7,118, 18,
133, 66,185,133,112,203,154, 76, 38,199, 20,173,215,227, 40,105, 11,197,190,121,
171,126,175,150,113,196,228,134,160, 62,161,217, 54, 45,203, 44, 54,234,244,126,
185,239, 43,132, 95, 23,245,170,132,169, 47,132,100,183, 77,100, 88, 69,131,200,
114, 67, 83,161,225,108, 32,  6,102,179,193, 32, 70,203,112,180,  9,136, 89, 44,
 50, 88,113,145,120, 64, 22,112,122, 59,143,250, 35,  2,121,215,248,163, 31, 36,
 50, 99,232, 86,250,218,157, 70, 78,195,102, 92, 98,158,103, 73, 55,211,  6, 73,
 58,170,130, 73,204,179,187,138,128,128,128,192,  6,129,  8,168,145,189,145,161,
 25, 17,145, 36, 73,210, 28,113,  8, 65, 12, 98,202,210, 14,162,136, 36,139, 17,
 21,  4, 57,104,  8, 34, 74, 64, 16, 17, 52, 34, 34, 10, 82, 80,152, 66,177, 24,
 21,167,185,129, 32, 89,  7, 77,144,206, 53,237, 64,143, 63,119,169,235,191,156,
178,103,173,148,136,150, 19,149,154,  4,213, 34,221, 77, 22,  8, 39,100,240, 48,
 13,136, 25,136,184, 53,  2,196,182,241,173, 96, 11,117,242, 33, 80,  8, 70, 28,
 87,112,208,132,250,193, 40, 50,237,177,172,119,137,219,180, 43,115,178,134, 83,
131,199,128, 90,129,183,116,215,135,236,161,134, 89,118,174,195, 76, 84,111, 87,
190,203, 35,172,155, 44, 77,129, 54, 17, 21, 39, 71,117, 58,107,183,172,133,233,
240,186,135,206,184,231, 92, 52,198,230,198,184, 55,131,139, 51,120,105, 74,235,
221, 11, 85,193, 30,203,220, 53,169,151, 16, 72, 41, 32,253, 32,237,186,147,149,
255, 56,244, 29,124,152, 75,229, 94,238, 37, 99, 23,175, 78,168,130,172,134,220,
175, 99,204, 44, 14, 64,175, 80, 34,136,128,170, 95, 77, 50,142, 71, 56, 25,245,
 28,244,211, 53, 52,184,144,155, 86, 52, 58, 87,150,107,162,172, 97,118,179,122,
 81, 13,103,131,189, 78, 88,145,104, 97, 65, 15,130, 72,232,217,152,168, 27,230,
198,120,135,235,129,129, 26,161,137, 74, 13, 26,211,255,129,170,128, 27, 88, 21,
 53, 35,141, 36, 82, 81,194,113, 19, 73, 72,170,175,226,133,219,222, 22,246, 70,
163,179,154,191, 31,157,125, 91,124, 81,151, 67,190,  2,102,200, 29, 73, 97,238,
237,114,209,184,172,122, 13,187, 51,230,243,133,220, 72, 26,163,202, 50,241,132,
232, 91, 89, 32,101, 59,131, 29, 41,247,223,218,220,253,229,244, 35, 51, 35, 46,
117,144,124, 79,139,173,141,246,197,224, 50,217, 30,206, 52, 16,  5, 66,123, 95,
101,152, 89,  9,133, 56,128,117, 94,  1,  3, 23, 42, 48, 88,230,121,112, 88, 46,
224,151,  5, 39, 58,153,254, 97,161,146, 97,244, 14,120,160,130, 75, 11, 62,213,
147,220,111,139,168, 69, 71,154,217,  5,151,228,252, 22,100, 87,249,111,100,228,
115,125,222, 25, 49, 27, 50,197,176,171, 93,125, 19,148,188,249, 80,210, 31,182,
195,192,227,192, 24, 89,166, 13,146,125,199, 27,243, 47, 88,209,236, 81,248,111,
 49, 83, 79,184,233, 67, 28, 28, 27,147,238,195,242,111, 79,208, 56,179, 41,186,
113, 59, 51,132,181,212, 16, 41,222,116,106,190,203,105,246,134,200,213, 75,244,
 61, 77, 24,163,235,208,132,236, 60,159, 13,156,102,  5,251, 93, 48, 95, 20, 64,
 55,233,210,162, 63,230,151,122,244,199,116,202,131, 82, 23, 40, 56,244,207,123,
147, 20,205,101,186,  0, 35,234, 78, 93,224, 52, 83, 42,174,  2,
} ;

// ../CUDA/cumsum/template/GB_cuda_cumsum.cuh:
uint8_t GB_JITpackage_3 [944] = {
 40,181, 47,253, 96,154, 10, 53, 29,  0,230,233,128, 40,192, 82, 85, 29,200,165,
181,199, 86,134,192,207,229,180, 94,151,118, 38,146,189,164,190, 74,253, 51, 83,
250,184, 44,178,147,251, 12,176, 44,130, 64, 32,168, 64,118,  0,118,  0,114,  0,
219,148,222,229,213,215, 84,163,184,118,166,137,244,173, 61,233, 21,185,200, 80,
 72,178,  6,125,125,187,243,139,183, 13,218, 57,199, 93, 62, 33, 84, 38,149,136,
  2,101, 82,185, 52,163, 79,151,130,100,230,146,203, 67, 27,182, 29,173,248, 84,
245,253,164,135, 53,166, 25,131,210,141, 60, 20, 17,239, 13,191,218,135,228,247,
201,107,246,111, 16,125,213,229,219,201, 44,207,248, 16, 65, 53,150,156,215, 53,
166, 46, 25, 15,134,194, 46,215,195,230,201, 47,226, 20,  5, 35, 20, 21, 19,197,
160,254,179,175,239, 15,122, 39,156,237,164, 31,190,253,197, 88,112, 28, 15, 18,
112,165, 17,172,185,113,246, 58, 59,173, 86, 53,241, 33, 70,124,237, 22, 35,132,
 12, 15,129, 19,154,201,178,208, 96,158, 11,115, 97, 69, 16, 24,223,229,218,237,
133, 48,132, 33, 12,151,122, 67,126, 22,223, 24,179,232,221, 31,196, 65,160,198,
175,235, 18, 45,171,  3,  1, 29,182, 60, 37,212, 39,207,134,119,150,185, 89,187,
 82,  1,184,241, 96,155,107,157, 85,141, 10,192,137,164, 18,233, 93,198,174,166,
170,170,156, 88, 79, 10,234, 76, 85,125,170,190, 82,138,190, 77, 76, 59, 46,254,
244,219, 56,244,137,199,241,  5,207,168,  5,117,127,218,172,217, 33,114,203,181,
 24,250,108,215, 93,156,182,155,220,226,240,122, 93,158,137, 91,  0, 94,105,244,
138,142,133, 97,151,203, 49,123,131, 32, 80,130,161,110,230,200, 49,229,135,227,
228,116, 59,217, 31,198,166,138,111,181,208, 98,249,189,210,251,244,158,145, 42,
111,179, 91, 12, 63, 85, 42,193,217, 11, 80,163, 89,109,  1, 24,  2, 25, 48,204,
194, 96, 60, 24,172,185,  3,193,137, 21, 30, 78,244,250,101,220, 95, 99,121,139,
159, 53, 71,165, 22, 93,163,  4,159, 40,143,142,209,225,108,172, 77,196,112,174,
171,126, 90,104,202,169, 75,205,125,178,205,162,168,254,179,218, 55,  6, 46, 69,
175,122, 74,239, 62,127, 92, 92, 54,209,202,208, 96,151,240, 20, 80, 53,178,129,
 87,146, 13,136,174,225, 74, 63, 79, 34,136,190,137, 46,193,121,136,135,133,185,
 44,181,206, 56, 62,135,211, 20,128,177,168, 81,169, 98,138,212,208, 72,146,130,
 84,134, 49, 32,132, 24,165,172,170, 14,178,153, 22,135, 56,206, 24, 71,140, 82,
 70,198, 66,145, 96,130,130,210,114, 74, 92, 13,111,208,173,127,204,220,174,199,
159, 63, 14, 74, 64, 61,240,112, 36,105,171,201,173, 37, 73, 24, 52,156,138,179,
242,193,234,139,202,136,122, 59,242,146,237,187,  5, 86,195,128, 19,227,150, 75,
238,200,179,191,200,225,108,244, 78,159,118,217,246,129,177, 85,124, 48,206,243,
142,102,246,159,  4,145,139, 95,178,  0,141,177,193,101,208, 30, 68,115, 44,215,
214, 54, 83, 77,211,224,184,193,182,232, 56,178,209, 98, 77,177,192, 95, 92,217,
 69,135,193, 59,204,150,206,232,223, 84,153,208,225, 80, 57, 19,106,  9, 49,177,
184,138,162,194,107,175,124,102, 74, 43,241,139, 13,138,152,127, 22,218,137,237,
 60,180, 40,243,100, 81,113, 72,184,109,237,112, 53,119,179,230,150,225,154, 58,
228, 50,185,118, 92, 82,131, 48,100,196,189,110,221,129,168,209, 77,122,204,124,
 56,237,  8, 78,  9,233, 48,124, 96,122, 42,172, 23,  8,194,195,152,232, 70,136,
 84,218, 37, 60, 56,126,118, 36, 13, 90,130, 13, 84, 35,122, 84, 30, 10, 32, 74,
131,153,241,236,147, 68,185,  1,150,  5,  0,119, 72,  6,202, 13,174,131,174,140,
 53,242, 60,204, 79,125,235, 60,149, 50, 59,224, 76,125,213, 56,130,149,115,134,
223,  7,187,105,240,  2,106,123,179,225,234, 16,128, 35,111, 74, 76, 47,138, 51,
159, 72, 14, 54, 64, 60,100,124,166,194,204,230,156,168,104,101,  8,192, 96,240,
109,119,117,129,254, 99,147,  8,190,155, 21,168,240, 29, 95, 13,252,147,123,161,
 34,  1,175, 97,188,249,204,247,144,  7, 86,105,167,136,186, 54, 36, 92,145,205,
 65,179,170,222,244,175, 98,  3,165,129,  6, 78,154, 47,137,141,115, 69,114, 40,
 91,149,  6,152,
} ;

// ../CUDA/cumsum/template/GB_cuda_threadblock_sum_uint64.cuh:
uint8_t GB_JITpackage_4 [1278] = {
 40,181, 47,253, 96, 53, 11,165, 39,  0,118, 60,170, 39,224,148, 56,  7, 80, 54,
232, 95,119,155, 36,102,249,214,194,189,212,168, 90, 56, 53,125,177,  0,124,153,
 76,  9,125,231,234,199,115,  6, 51,140, 97,120, 33,172,  0,151,  0,154,  0,212,
 69,247,250,149,250, 70, 75,114,223,253, 75, 47,221,187, 39,125,238,216,196, 50,
 93, 40,123, 61,151,105,142,161,203, 21, 87,185, 80,130,178, 45,247,241,  4,165,
 99, 99,129, 65,233, 68, 81, 33,145,161,185,168,176,184,168,112,184, 70, 98, 35,
177, 65, 81,112,161, 91, 54, 29,142,217,200,213,155,175,140,  9,110,135,110,239,
197,187, 94, 22, 95, 60, 70,205, 37,131,139,229, 66, 65, 24,176, 92, 30, 61,232,
 82,115,199,109, 62,105,190, 93,117, 98,156,113,  9,179, 77, 93,134,177,149, 53,
140,201,165,189,169,224,160, 74,214, 40, 76,107, 42,228,205,200,129,110,233, 85,
 41,  7,181, 71, 53, 68, 84,182,186,152, 97, 91, 43,154,141,134, 67,  5, 67, 51,
209,112,101,142, 70,188, 82,153, 80, 42,149, 39,153, 68,147,232, 58,255, 39,208,
228,113,103, 33, 69,157,162, 86,114,148, 76, 81,147,201,103,125,244,204, 24,103,
245,173,114,249,113, 85,105,221,252,235,241,229,185,  4,247,195,114,210,235,122,
110,223, 75,181,150,251,200,130, 22, 20,184, 82,151, 81,176,154,110,233,251, 36,
 39,215,215,166, 92,109,107,238, 45,231, 82,  4, 61,185,245, 20, 65, 84,243, 85,
 79,103,117,184, 43, 63,229,155,191,116,175,122,169,106,153,228,203, 10,234, 98,
205,120, 40,221, 63, 77,109,228,250,149, 92, 45,124,109, 13,187, 37, 89, 96,161,
 22,159,100,128,239,102, 91,253, 80,251, 52,184,244, 87,101,207,151,186, 12,155,
 14, 83, 82,230,209, 53, 70,103, 69, 55,123, 72,248,194, 66,101,110, 62,  6,242,
  0,  5,122,192, 71,166, 17, 40,145,249,212, 68,246,116, 94,118,111,252,197, 51,
179,187, 47,231, 48,106,243,189,114,213, 56,151, 46,  4, 91,140, 14,163,147, 66,
206,183, 38, 25,219, 15,247,172,183, 96,147, 90,210,209, 75, 18,228, 25,239,142,
 89,233, 98,229,199, 49,195,216,130, 46,245,172,146, 37,191,183, 51, 57,238, 93,
229, 98,216,124,223,109,232,112,171,117, 41,225,209,161,103,166, 40,250, 52,116,
  2,140, 33,244,141,214,197,230, 90,191,158,212, 92,124, 92, 73, 55,100,227, 28,
 54, 93, 14,166, 73,119, 29,206,171, 46,246,174,238,170,183,  2,147, 73,  9,116,
 73,181,186,116,146,219,217, 75,150,227, 80,103, 69,157, 81,231,185, 11,113, 16,
221,171, 86,252,211, 38,157,228,170,227,174,199,200,158, 79,186,159,141,186,238,
125,150, 99,254,193,240, 40,130,174,  0,193,173,205, 35, 91,241,183, 40,231, 37,
 75,134,216, 12, 80,109, 66,234,160,124,114, 55,231,137,  5, 23,203,192, 51,191,
128,100, 20, 62, 50, 97,188,233,165, 76,187,178,147,158,  9,191, 57, 74,157,116,
111,246, 67,232,244,156,242,213, 44,185, 58, 70,110,247, 54,151,108,116, 98,139,
173,  6,119, 43, 83,142,204, 63, 32, 71,150,103,160, 87,252,225, 65, 81,127, 92,
 93,109, 76, 53,223, 53,106,189,244,112,169,187, 58,129,  4,168,145, 29, 67,200,
208,140,140, 36,  5, 73, 10,141,  1, 33, 12,130, 64,148,133, 57,118,  3, 82,208,
128,146,232,184,161, 25,145,  9,149, 20,164,140,212,107, 57,116, 42, 44, 59,  9,
164, 38, 80, 87, 87, 18,235,  2,145, 69, 36, 71, 54,249, 72,195,223,197,207,142,
162,235,174, 87,134,233,229, 57, 19,181,231, 34,206,131,232, 31,154, 38,126, 93,
171,171, 23,144,246,116,229, 95,  2, 72,167,166,249,184,  1, 55, 97, 23, 67, 66,
108,196,144,160,129, 83,162, 15,154,212,133, 11,  3,113,200, 97, 76,166, 85, 64,
155,207, 15,228, 28,103,252,195,155,125,209,115, 30, 17, 18, 58, 88, 22,229, 86,
 80, 79, 65,111,186, 54, 93,175,162, 44, 68,126,211,122, 88, 42,184, 83, 45,206,
 50,106,110, 40,  5,119, 33,158,109,103, 56,214,160,136, 73,210, 83,154,118,220,
246, 72,210,246, 91,130, 46,144,103, 86,148,143, 33,207,173,200,238, 35,144, 94,
 37,135, 68, 21, 45,132,216,128,230, 69,122, 63, 55,181,203, 50, 13,119,213,216,
138,205,163,140, 53,205,103, 71, 38,225,182, 84, 91, 96,255,127, 33,235,214, 86,
 34,236,154,220, 19,105, 50, 77,  4, 10,122, 29,110, 45,217,202,196, 34,132, 37,
111,195,247, 28,148,125,129,144, 49,234,178, 86, 36,113,139,135, 60,250,121,175,
209,  3, 46,205,246,151, 21, 80,121,  1, 45,214, 75,194,138,225,184,134,205, 84,
252, 12,233,107,252,241, 88,252,108,176,134, 78,110, 97,197, 79, 43,238,171,105,
161,163, 16, 69, 54,204, 93,217,145,225, 82,100, 96, 60, 16, 67,162, 48,191,133,
103, 78, 75, 22,229,  1,176,  1,194,173,116, 96,147,197,223, 73, 75, 41, 48,175,
174,200,160,193, 42, 79, 18, 34,102, 99, 43,136,190,126,198,165, 22,157, 45,123,
110, 50,109,114, 50,186,216, 53,129, 19,161,215, 11,163,209, 10, 13,174, 31,185,
 41,240,240,183,178, 39,179,  5,255, 16,195,228, 67,111,252,177,252,243, 60,142,
138, 48, 71,101, 28,141, 28,208, 92, 56, 64, 45,162,253, 43,138, 69, 35,218, 22,
237,171,253, 63,230,217, 97, 50, 43, 25,139,198, 17, 36,230, 62,149, 50,113,121,
245,190, 24,139,  2,150,120,121,227, 25, 57,103,204, 84, 53, 85, 86,232,182, 45,
 25, 74,127,129,224,212, 68,156,174,  5,103,205, 44, 27,171,253, 39,179, 80, 57,
115,224,221,175,107, 86,  5,244,134,246, 80,  0,204, 66,232,217, 77, 82, 26, 40,
192,173, 23,100, 50,130, 94, 95, 45, 72,237,159, 58,232, 81,119, 73, 29,117,225,
227,167,110,185, 40, 51,124, 96, 18,171,131,105, 21, 32,128,191,173, 59,152, 63,
  2,204, 77, 55,177,170, 15,153,168,200,190, 75, 58,109,169, 22,184,  3,
} ;

// ../CUDA/cumsum/template/GB_cuda_tile_sum_uint64.cuh:
uint8_t GB_JITpackage_5 [760] = {
 40,181, 47,253, 96,186,  8,117, 23,  0,182,166,113, 32,  0,121,115,110, 60, 34,
 84,141,194,202, 62, 45,217,  5, 80, 25, 25,122,109, 53,167,112,105, 72,209,179,
255,255,123,255,123,  1,109,  0,105,  0,101,  0,175,237,129, 50,142, 81,148, 43,
123, 94,173, 87,106,207, 99,164, 28, 91, 32, 12,  8, 66,227, 96, 64, 92,176,  5,
142,213, 70,193,203, 51,202, 85,158,157,167,  6, 29,123,112,165,240,251,176,237,
251,185,170,156,109,183,203, 49,125,100, 20, 71,194, 71, 97,234,127,120,119,203,
 20, 12, 43,251,106,167, 91, 53,142,109, 53,200,221, 77,171, 96, 10,108, 97,252,
 78,108, 11,148, 75,200, 82,248, 80, 52, 21,239,131, 20,243, 66,225, 34, 20, 10,
  1, 76, 61,123,111,131,124,204,222, 79,246, 37,135, 99, 73,118, 61,124,173,147,
110, 55, 66,212,173,118,248, 63, 50,153,154,156, 22, 59,175,102,221,252,215,116,
171,204, 29,158,206,238,252,169,236, 74,227, 51, 95, 92, 47,140, 22, 66,130,112,
249, 84,254,160,220, 93, 91,201, 92,134,192, 85,242,214, 26,194,232,210,249, 80,
154,109, 56, 25, 16,197,195,233,120, 56,150, 83, 50,151,140,104,163, 64, 80,213,
 55, 45,127,112,236, 46, 28, 95,155,107,228,214,  1,161,112,156,113, 56, 22,184,
100,192, 21,110,143,112,235, 79, 85,219,178,  4,136,196, 37,146,  7,222, 53, 96,
218, 87, 57, 33, 23, 60,240, 77,170, 84,175,205,244, 86,201,191, 88,151,224,194,
 38,171,136,105,155,145,164,253,191,  2,151,236, 40, 91,211,174,105,188, 53,138,
 57, 77,171,158,125,140,240,167, 73,187,215,110,126, 82, 94,217, 59,159,113,113,
122,103,207, 94,246, 57, 24,215,213,186, 32, 23, 24, 30, 37,217,169, 25,227,172,
247,216,180,183,125, 91,225,198,193, 73, 73,159,160, 63,147, 13, 79, 49,222, 14,
  5,189,199,216,169, 27, 84, 81,206, 91,182,115, 99,227,173, 76, 47,233,181, 76,
187,230,100,235,112,201,196,240,  9,228,135, 79, 38,146, 91,174, 93, 55,111,101,
  7, 98,156, 84,222,195, 83,  9,210, 15, 64,231, 49,199, 49,197, 49,196,177,195,
 41,123,182, 57,112,  9,107,119,168, 65,161, 83,204,208,  4, 34, 34,179, 32, 73,
 33,195,  1, 64, 68, 32,  6,153,233, 14, 82,  8, 57, 78, 85,216, 24, 68,  2, 10,
 37,146,137,127, 38,160,120,  7,108,121,  4,166, 71,186,100,116, 89, 49,121, 44,
140, 19,186,245,153,208, 41, 33, 17,  7,121,193, 37, 12, 28,183,130,119,110,153,
 50,246,109,176,242,161,161,168,190,254,180,247,221,194, 30,202, 31,  3,194, 58,
204,227,206, 54, 85,242, 44, 63,208,108, 87,127,167, 90, 44, 97,163,131,129,  5,
 35, 96,217,228,185,242, 51, 52,201, 35,240, 98,  2, 29, 22, 58,161,199, 67, 36,
198,129, 36,187,240,252, 17, 32,219,248, 19,103, 53, 65, 43,231,100, 82,199, 25,
 54,130,  5, 28, 61,181, 31,201,167, 77, 80, 91, 19,198, 67, 77, 17,102, 90,107,
219, 19,201,112,213,217,211,123, 74,175, 22,137,147,114,152, 91,232,177, 98,246,
 46,208, 27,199,227,235,142,  6,250,124,  0,163,180,216,232, 50,225,246,118,247,
166,207,182,187,167,204,218, 29,139, 88, 38, 95,131, 68, 33,222,114,252, 28,121,
  4,228,152, 49, 26,138, 57, 84,210,179, 72,  9,213, 57,161,144, 30,191,158,229,
 25,195, 12, 88,178, 71,222,206, 50,233, 89,109,119, 49,125,104,123,212, 93,144,
203, 25, 62,154, 49,129,222, 68, 82, 97, 56, 18, 36,128,124,  4,168,180,  2,192,

} ;

// ../CUDA/include/GB_cuda_atomics.cuh:
uint8_t GB_JITpackage_6 [2801] = {
 40,181, 47,253, 96, 53, 88, 61, 87,  0, 74, 83,120, 15, 46,160, 78, 25,235,178,
125, 21,120,231, 73,167, 54,144, 50,100,102, 15,112, 30,  6,104, 48,168,115, 24,
121,168, 47, 81,189,191,182, 34,244, 53,196,215,132,215,225,117,112, 58,188, 82,
  1,229,  0,240,  0,234,  0,189, 77, 89,173,246,140, 58, 63,150,210, 28,101,203,
233,177,151,203,121,110,183,185,247,141,127, 81,147,118,203,157,189,246,157, 60,
 63,127,120, 11,221, 88,231,166,181,219, 89,252, 58, 47,107,124,183,153, 55,227,
 41, 15,209,240, 70,  3, 36, 99,219,121,119,242,171,189,124,182,213, 15,193,180,
235,237,  9,207,224,130,106,103,214,106,199,185,167,229,165, 70,227, 46,210,233,
  1,241,168, 96,148, 79,110, 79,206,204,181, 37,124, 52,174,173,205,203,163, 65,
  5,131,221, 11,169, 44,152, 73,151,133,185,172,233, 18,172, 64,139, 42, 66,114,
 67,156,109, 58,103, 39,131,200,246,220,198,125, 29,231, 78,198,188, 78,169,244,
 71, 64,226, 32,121, 20,120,112,144,220,161, 69,127,120,122, 98,229, 16,233,161,
 78,182,219,204,254, 38,141,111,228,176,206,179,195, 26,215,114,254, 79, 58,157,
  6,193,218,220,108,142,154, 40, 59, 77, 67,177, 68, 58, 71,202,109,157, 35, 82,
 37, 51, 69, 48,233, 66,233,112,241, 90, 30,137, 52, 30,145, 72, 84,150,201, 96,
134, 81, 50, 88,  5,117,101,166,200, 34, 85, 72,149,103, 24, 80,216,195,184, 36,
 10, 78, 20,  6,251,187, 76,217, 68, 93,212,133, 34, 81, 20, 11, 94, 89,101,253,
162,170, 11,235,114,145, 40,176,103, 21,101, 65,253,144, 10, 85,  1,165,203,132,
193,202, 41, 44,131,185,164, 75,102,130,217, 37, 97, 46, 77, 84, 25,156,192,200,
224,  5, 82, 36,138,233,162, 42, 62,241,172, 44,131, 21,240,242,204,170,158,101,
 40,127,150, 10, 86, 50,151,169,130,127, 24,  5,179, 74,186,224,  5, 83,  1,127,
 89,199, 48,234,194, 52,160, 48, 42,149,116,  1,  2, 48, 41, 66,132, 99, 23, 85,
185, 88, 20,207, 40, 44,240,194,192, 80, 24,148, 87, 40,235,194,156,186,164,139,
108,194,194,142, 65,138, 12,227,122,167,214, 28,254, 39,115, 44,230,200,227,252,
190,178,246,109,238,205, 67,248, 90,156,103,111,177,206,174, 48,141,243,118,142,
219,175,141,196, 92,123,235, 52, 43,223, 90, 39,235,132,220,222,102,164, 26,205,
127,217,214,223, 99, 55,113,198,156,113, 39, 57,246,120,146,  3, 81,128,134, 71,
 13,209, 29,175,113,124,  7, 82, 59,174,206,203,110,201, 80,101, 48,181,155,160,
 89, 10,  2,189,119,237,230,215,130,226,171,115,115, 68,127,157,149,209, 82,206,
  4,247, 54,243,107, 41,163,230, 33,170,137,144,152, 38, 52, 20,144,229, 61,187,
163,209,115,250,228,241,124, 71,102,218,189,118,231, 35,129,136,190,117,198,141,
 52,254,133, 40,141,157, 59,110,179,218,109,254,147,177, 51,174, 16,130,111, 63,
 57,227, 78,  2, 38, 77,215,114, 92,135,143,219, 74,173, 55,127, 14,137,135,191,
172, 49,144,235,236,254,168,181,155,232, 77, 55,145,206,232,137, 88,218, 78, 14,
109, 30,146,199,195,109,133,155, 11,229,106,237,115,237,219,156, 72, 97,210,136,
 69, 40, 38,136,129, 22, 21,233, 19,240, 47, 99, 29, 67,186,128, 24,116, 80, 24,
188,176,168,169,162, 44,240, 98,161,170,103,217,132, 73, 23, 69,113,113, 89,149,
 85,145, 46, 28,152,204,117, 81, 25,196, 46, 75,202, 30,133,101, 48,235,242,  3,
 24, 53, 65,139,139,194, 42,150,101,121,141,134,133,135,  4, 15,127, 14,127,121,
 94,205,114,254,248, 27,155,106,145,220,248, 17,207, 33, 92,168,215, 54,  0,213,
107, 85,251, 73,227,249,201,115,115,237,  6, 20, 65, 17, 20, 65, 49, 58,135,243,
 87,103, 69,157, 27,  0, 11,239, 77,242,108,184,227,105, 62, 93, 15, 88,153,224,
146,218,203,222, 58,140, 31,  6, 68,231,252, 56,223,200,101,196,109,210,216,183,
163,197,126,181,151, 82,  2, 53,125, 15, 34, 36,158,  4,194,193,164,206, 71,166,
179,219,212,102,112, 56,103, 50, 60,238,121,162, 39, 56,151, 81, 45,205,152,184,
118, 93,215, 89,112, 68,209, 59, 26,136,242,204, 28, 43, 52, 28,141, 63,100,243,
243,255,255,141,168,161,  0,193, 21, 32,224,216,234,192,121,110, 30, 33,113,  9,
196, 65,157,187,173, 33,250, 95, 39,173,179, 81,107,  4,197,  3,119,100,127, 55,
115,111,200,162,203,105, 61,215,104, 52,154, 43,200, 16,188,209,104,173,218,199,
 45, 35, 94,142,161,  1,234, 63,250, 26, 15,201, 56,106,182,198,190,220,237,222,
104,179,243,  9,131, 27,168,178,108,210, 57, 53, 50, 34,146, 36, 73, 97, 24,  3,
146, 40,  4,  2, 89, 32,140, 98,170,213,  1, 66,153, 32, 79, 50, 12,136, 32, 66,
  8, 49,132, 16, 69,  8, 17, 18, 66,  4, 34, 18, 17,137, 68,166,170, 60,160,  5,
172, 79, 50, 65,162, 39,191, 27, 45,195, 35,192, 13, 77,196, 25, 73,129,253,155,
 82,209,123,155,143,  6, 11,212, 56, 25,165, 50, 81, 37,192,233,202,  4,171, 30,
201,166, 13, 80,174,176, 38,107,209,170,102, 39,173, 24, 45, 74,243,235,126,173,
227, 20,  8,  3, 34, 45,  0,232,129, 41,140, 99,254, 54, 98, 34,194, 43,117,107,
171,210, 60, 10, 79, 99,130, 18, 32,221,128,156, 25,230,153,128,172, 18, 78,234,
 14,175, 73, 94, 35,216, 20, 18, 15, 55, 64, 55,  2,120, 42, 50, 80,204,154, 16,
114, 71, 67, 33,251,104,199, 70,128,127,169,  5, 24,124,132, 46,  9, 78,188, 16,
133,132,201, 40,174, 85,248,215,116,188,145,219,232,120, 99,  9,116,152, 86, 79,
185,231,102, 89, 14, 80, 41, 11,220,235, 90, 80, 22,210, 33,160,234, 45, 53,247,
 45,242,200, 16,100, 46,140,164,195,211, 25,128, 29,129,171, 34,100, 89,231,208,
 77,107, 18,156, 20,114, 34, 84,157,182, 33, 23,239,136,168,155,175,226,188, 79,
 37,  4,147,232, 54, 86,152, 78, 66,100, 89,148, 45,  7,231,183,160,228,  8,170,
238, 22,129, 80,214,145,133,109,129,127, 66,126,199,159,157, 67, 78, 94, 56, 39,
 14,115,132,188, 43, 87,215,125,  6,222,  0,181,225, 53, 16, 61,132,105, 51,165,
 11,190,252, 64,107, 23, 17,174,209,163, 14,197,138, 69,140, 57, 74,146, 28,202,
 45, 99,197, 33,200, 99,194, 42,136, 76,137, 43,246, 92,104, 20, 52,  8, 25, 33,
 23,173, 27,191, 73,148,227,170,195,  7,118,191,233, 71,194, 96,176,  6,132, 10,
108,153,254,211,219,128,230,238, 17, 84, 57,205,106, 33,246,171,152,253, 72,175,
 82,164,162,130,112, 92,  4,107,199,127, 62, 41,135,  6,112,239,162, 42,148,208,
157,234,216, 65,184,161, 95,235, 75, 54,188,217, 18, 68, 53, 26,131,184,  5, 75,
181, 53,110,161, 44, 17, 65,157,144, 80,206, 57, 84, 49, 93, 89,102,201, 90,197,
  5,162,156,128,203, 95,144,167, 25,238,129,219, 60,107, 78,204, 51, 70,130,200,
 87,194, 72,232, 18, 60,151,123,191,181,  9,198, 12, 35,235,175, 65,244, 34,122,
  5, 54, 18, 94,254,  0,199,225,175,164,247, 29, 45, 68, 11,242, 29,140,252,139,
 13,244,183,199,  5,184, 61, 66,142,124,188,109,116,140,254, 71,160, 24, 92, 58,
 38,187,182,145, 80, 66, 14,248,167, 95,  2,255, 47,208, 63, 45,248, 81,167, 72,
123,211, 49, 52, 97,226,229,232,103, 28,103, 25,106,248, 17,221,163, 66, 89,181,
170, 32,145,134, 65,  7,101,185,172, 35,108,148,175, 87,151,215, 91,165,230,  7,
194, 29,211,200,183,118,158,152, 61, 84,  5, 93,232,224,104, 57, 73,130, 99,177,
199, 99,191,  9,194, 31,241, 66, 26,160,208, 93,131,167, 94,151, 37,198, 33,198,
172,155,246, 65, 24,206,120,184, 16,143, 62, 28, 72,223,129, 11,224,158,112,161,
 96,213,144, 71,117,129,220,210,131,255,242,  3,169,  7,189, 84,222,247, 88,190,
 85,224,227,  3, 87, 80,248,245, 97,206,209, 38,251,248,192,147,  4,250,129,  3,
196, 31,143,253,110, 75, 14, 30, 15, 93, 41, 60,147,226, 45, 24, 21,231,227,253,
129,210,195,189,194, 32,137,  1,195, 88,126,104, 10,116,156,  3,159, 47,195, 72,
 96, 21, 96,193,123,248, 47, 68,174,108, 74, 51, 69,204,212,104, 73, 84,143,205,
 43,200,124,101,209,144, 64,126,163, 56,196, 25, 83,133,185,137,200, 68, 45,183,
216, 11,115,  2, 16, 95,152,177, 74,126,101,210, 95, 38, 42, 75,156, 70,249,128,
 66,178,227, 36,106,  2,159,174,206,148, 62,183, 97,185, 62,218,120, 66, 41,216,
 63,211,224,  8,130,193,203, 10,244, 56,193, 26, 93,101,194, 18, 50, 25, 86,182,
118,239, 47,201,248,151,215, 75, 30,194, 92,218,255, 67,241,184,192,123,187, 28,
175, 15,167,244,211,107,222,241,180,185,  0,105, 65, 66,219,149, 43,133,206,161,
141,134, 35, 91,153, 71,152,218,190,143,109, 41,230,167,136,200, 67,109,215, 67,
192,100,  2,208,252,210,160,210,192,249, 67, 26,223, 36,133,251, 19, 95,126,131,
 66,167, 13,155,169,222, 10, 18,221,156, 28,194,  1,139, 36,218,127, 58,120, 79,
 47, 45,204, 82,150,211,154, 32,242,178,188,162, 12,113, 34, 94, 10, 76, 53,189,
 82,190,243,197,106,140,103, 51, 58, 84,231,158, 65,244, 52, 89,223, 66, 54,103,
 22,116,146, 97,115,230,232,163, 19,116,  0,  2, 85,114,222,183,  8, 78, 65,178,
209,145,240,246, 60,134,197, 84, 63,209,147,228,103, 46, 47,203, 74,229, 13,244,
183,140, 48,157,226,167,178,222, 44,196, 82,205, 13,210, 98,103,154,  9,202, 13,
184,163,141, 59, 94, 73,124,135,139, 23,120, 71, 99,122,214, 75,132, 85, 33,109,
190, 71,228,108,243,184,  9,106,230,125,134,118,140, 53,  5,144,204, 28,209,143,
208,121,191,159, 25,206, 60, 99,  0,222, 78, 10,133,145, 91, 96,180,232, 89, 49,
 14,137,146, 74,217,174,219,106,250,193,111, 29,141,214,131,102,140,230,  8,153,
 17,110,235,175,198,227,221,103, 31,224,145, 74,208,226,  0,  1, 95,247, 65,136,
 66, 55,156,124,141,142,204,147, 73, 68,250, 26,137,247,253, 49, 15, 93,  9, 64,
  6,201, 94,214, 33,137,114,136, 71,103,178, 77, 81,191,182, 27, 39,241, 52,158,
126,226,133, 12,127,131, 66,171, 65,215, 52,126, 16, 83,125,206, 70,  2,101, 44,
170,  9,243,114,220, 99, 73, 86,214,108,  1,143, 28,128,131,110,177,168,188,141,
116,138,112, 62,191,160, 62,239, 74,211,254, 95,252,150,110, 96,141,250, 59,117,
134, 68, 89,172,139,  3, 66, 57,127, 77,227, 11,130, 22,224,242,159,228,242,108,
242,205, 34, 35,250, 38, 36, 75,140, 86, 26,208, 27, 20,106,185,102,242, 20,123,
209, 81,123, 85, 14,153,102, 36,144,  0,228, 76,138,105,216,  9, 78, 58, 77,140,
139,  5, 33,188,  9, 55, 67,223,  4,148,115,177,  1, 54,126,223,137,169, 85, 33,
241,139,107,188, 37, 81,240,143,242, 88,  6, 65,156,169,221, 30, 66,207, 32, 79,
 51, 49,  2,  6,190,249,248,115, 86, 31, 23,131,137, 77,207, 43, 53, 67,  7,  6,
 50,133,240, 26, 97, 84,244,205, 74, 24,162, 23,254, 82, 98, 53,  6,208,197, 44,
 10,248,135,  5, 16,193, 42,130,143,206,120, 22,  2, 57,151,124,160,160, 62,219,
150,169,150,130,130, 37,122,114,236,151, 50,116, 64,203, 72, 70, 19, 53,143, 23,
120, 14, 12,186,123,  8,112,221,  4,184,213,177, 68,102,250,144,218,146,246,126,
 30,253,196,218, 74,177, 39, 32,209,242,127,  3,181,113, 61,250,149,189,249,  5,
 21,122,171,  9,167, 56,155,136,194,163,133, 81,158,  5,212,162,234,114,101,225,
 28, 79,  6,239,212, 78, 29, 12, 86,226, 54,220, 86, 50,114, 30, 42,134,183,142,
237,149,158, 66,  9, 89,  4, 37, 83,240, 22,133,240,130,186,178, 16, 67, 36,113,
153,237,151, 79,184,188,  6, 21,216, 68,195,190, 33,100,177, 13, 99, 20,173, 42,
122,136,225,133,248, 97,114, 95, 11, 56, 13, 23, 28,251, 43, 50, 87, 36, 26, 50,
121,245,  2, 28,149, 25,231,120,123,135,180,244,231,146,231,  3,228, 12, 45,194,
 16,225, 27,146,154, 58,253,201,  5, 64,125,136,228, 98,188,  9, 80, 90, 81,  0,
 18, 23, 19, 86,157, 35, 46,177,107, 10, 61,220,  4, 81,165,242, 66, 84, 76, 95,
119,  5,144,213, 55,167,157,212,157, 83, 57,248,235,163,242, 44,146,177, 52, 83,
193,105,108,244, 49,104,166,196, 29, 74, 97,185, 49, 93, 57,193,125,248, 35,113,
 90,250, 59,  9,107,110,221,131, 95,131,254, 14,126,136,213, 81,  7,216,152,107,
200,130,211, 49, 21, 47,239, 71,130,205, 34, 96,151, 24,152, 16, 28,157, 81, 80,
171,131, 66,165,195, 36,190, 51,187,239,106, 83,191, 54,190,223,255,176,194,109,
 46,125,158,186,120,  8, 22,199, 28, 26,132,114, 53, 25,212,172,105,176,153, 34,
202,208,243,193, 67, 11,204, 84,158,178, 98,226,215,180,  1,230,116, 96,199,205,
111,178,222,114,  1,168, 28,254, 73,135,193,148,234,167, 12,179,166, 85,245,153,
  7,
} ;

// ../CUDA/include/GB_cuda_error.hpp:
uint8_t GB_JITpackage_7 [535] = {
 40,181, 47,253, 96,104,  6,109, 16,  0,150,156, 90, 33,  0,213, 54, 86,202,246,
218,  9, 44,  9, 74,230, 79,109,135,124,  3, 16,  2, 83, 49,252,105,139, 12,185,
108,248,255,223,186,  4, 16, 81,  0, 81,  0, 81,  0,  8,133, 83, 32,193, 43,125,
 71, 31,196, 15,153,151,194, 61,138,174,198,171,235,117,254,200,204,239, 91,102,
230, 22, 75,253,217,245,190, 30,  2, 63,  4,189,226,207,235, 24,238, 23,185,127,
 46,138, 31,232, 23, 73,134,135, 60,230,252,244,171, 37, 72, 53,206,202, 32,155,
135,149,201, 58, 45, 36,191,204,185,101, 77,131,101,  5,186, 48,110,215,121,180,
190,203,143,135,174,232, 23,229, 50, 31, 95,251, 85, 48, 49, 24,  9,245, 46,158,
183, 81,170,113,110,191, 98,123,  5, 19,113, 80, 24, 62,  4, 63, 50,243, 43,255,
181,119,227,175, 19,195,107,252,224,237, 12, 28,  8,230, 80,127,148, 95,191,231,
122,135,160,235,185, 40,102, 94, 45, 20,  8,133,129,145,  8, 52,114,161,154,205,
197,225, 20, 30,239,254,192, 81, 20,179, 82, 30, 69, 95,105, 52, 26,215, 71,139,
 39, 84,203, 28,230, 84, 21,192,158, 58,112,125,  3,  4,119,119, 19,165,245,131,
 96,153,  1, 16,220, 94,204,189,225,190,233,230,238,211,227,166,233,113,170, 66,
152,218,110,124, 51,233, 63, 26, 69,159,253,218, 42,156, 73, 36,115,218, 91,241,
 11,230, 60,157, 48,167, 70,139,115,185, 63, 99,222,117, 25,221, 54, 47, 66,183,
 78,243, 54, 26,135, 57,101,153,116,148,110,221, 36, 66,169, 87, 20,  8,223,188,
 51,251,185,138,218,248, 18,168,138,175,248,226,181,174,  7,215, 85, 95,188,159,
117,204, 55, 24,142,106, 36,206, 47,239,120,151,202, 86,  9, 61, 32, 48,132, 24,
 35,197,110,134, 47,168, 64,180,104,161, 88,197, 92, 74,190,  2,146, 50,159,165,
  7,192,232,129,167,231, 82,141, 54, 77,128,143,242,190,137, 58, 45,  2,  6, 24,
155,  1, 39, 48,198, 21,170, 70,196,103,106,116,133,  1, 30, 70,193,200,173,153,
239,  4,102, 64, 25,102, 12, 48,  7, 37, 51, 52,101,163,109,209,219,103,145,149,
 15,150,220,200,162, 33,102,201, 30, 43,115,199, 99,118, 59,182,213,119, 81, 18,
  3, 23, 53,107, 92,162,138,  3, 34,208,122,182, 55,239,157,100,238,107,153, 29,
  5,254, 32,224, 12, 59,121, 65,200,211,116,117, 25,212, 10,230,160,169, 33, 55,
105,219,149,146,168,181,242,144, 99,174,234,170, 21,  5,110,
} ;

// ../CUDA/include/GB_cuda_geometry.hpp:
uint8_t GB_JITpackage_8 [395] = {
 40,181, 47,253, 96,104,  3, 13, 12,  0, 70, 85, 69, 33, 16,241, 54,240, 90, 88,
 32, 44,221,  6,166, 89,160, 14,114,127,170,152, 56,165, 28,124, 40,194, 72,126,
128, 17,  1,128,  2, 74,  5, 60,  0, 57,  0, 57,  0,158,192,  9, 26,115, 42,195,
161,201,203,187,195, 13,230,156,176,120, 61, 86,113,251,141,201,237, 17,197, 11,
149,227,254, 77,248,152,174, 90,210,235,168,107,190, 37,179,  7,226, 57, 49, 40,
213,220,166,140,186, 98, 29, 47,159,243, 41,204, 25,245,199,187,253, 11, 29, 32,
240,239, 96,237, 26, 47,204, 23,255,187,125,107, 50,227,101,206,213,195, 98,185,
125,225,249,193,241, 53,254, 64,246, 57,227,235,215, 92,239,139,193,154,231, 60,
 57,225, 64, 35, 90, 72, 72, 17,245, 65, 79,163,171,104,156,  5,145, 88, 87,231,
223, 91,240,195,  0,205, 97, 14, 11, 86,223, 58,188,119,135, 23,183,175,201,207,
248,115,141, 47,231, 14,253,248,215,109,224, 65,252,189,  5,184,198, 62,152,243,
185, 94,125,  7,177,107, 27,207,243, 97, 11,254,100,130,112, 24, 37,214,205,198,
151,200, 64, 35,196,129, 58, 69, 40, 34,131, 75,150,  5,219, 30, 17, 74,163, 82,
 56,189, 36, 89, 71,165,131, 75, 16,140,241,168, 36, 25,213, 89,155, 54, 77,182,
142,171,172,204,218,180,111,239,243,235, 41, 32, 48, 70, 52, 82,237,  1, 53,  0,
100,205,128,235,130,190,  0,104, 37,200,178, 36,126,202,130,  8,154,197,  0,224,
 43,  2, 31,165,146, 84, 70,  4,  0,194, 51, 96,180,172,210,102,255, 89, 14, 55,
155,252, 28, 18,215,188,228, 26, 78, 10,208, 60,  9, 86,240, 59,192,255,  0,219,
 48,253,105,150,242,230, 70,123, 14, 44,111, 40,  0, 26, 51,164, 24,113,199, 65,
192, 49, 53, 33,132, 74,  2,  1,  0, 31, 12, 10, 21,  5, 67,
} ;

// ../CUDA/include/GB_cuda_kernel.cuh:
uint8_t GB_JITpackage_9 [781] = {
 40,181, 47,253, 96,139, 10, 29, 24,  0,214, 39,118, 39,240,208,230,  1,200,177,
  6,227, 38, 73,106, 40, 27, 17,111, 49,204,179,147, 22,147, 82,126,154, 81,227,
 97,251,185,196, 80,136,131, 56, 44, 98,161,149, 10,112,  0,107,  0,106,  0,212,
133,178,200, 32, 72,230, 37,163,101, 39,253,220,179,212, 29, 71,170, 58, 52,155,
182,102,233,187,143,107,246, 61,202, 66, 18, 36,  5,146,200,130, 65,129,100,  7,
154,192, 66,168,135,248,178, 18,101, 47,247,209,114,206, 66, 38, 77, 39,203, 77,
191,215, 77, 68,119,103,244, 44,133,209,223,161,123,186,218,137,171, 77,122, 13,
103,131, 24, 87,181,177, 10,196,212,207, 79, 90,253, 19,229, 82, 97,153, 54, 20,
 76,197, 73,158, 16, 59, 77, 81,100,154,  2, 83,  2, 68,145,244, 52,186, 93, 24,
183,106, 90,247, 35,108,247,113,105,125,114, 33, 78,170, 64,108,  5,121,157, 39,
238, 55,237, 84,186,188,180, 43, 15,197, 41,247,169, 93,137, 67, 69, 52, 88, 61,
219,205, 67, 93,237,123,188,241,161,111, 21,208, 85,125, 13, 58,192, 82,223,168,
 64,146, 68,218, 53,150,148,157,204,118,143, 63,236,138,138, 52,133,221, 28, 19,
185,184, 80,108,230,148, 50, 19, 20,135,162,153,160,208, 76, 88,150, 18,187, 27,
113, 68, 15,203, 99, 53,250, 33,165,147,166,  7, 99,140, 61,100, 40, 76,134, 98,
 22,206,102, 97,  5,136,160, 63,232,219,252,249,233, 62,134,179, 31, 58,230, 33,
163,121,144, 96,219, 12,187,221, 88,210,182, 24,238,  7, 58,173, 84,214, 56, 63,
172, 67,254, 60, 91,198, 88,155,  4,185, 81,  6,106,241,117,166, 78,149,162,123,
182, 30,122,245,180,241,124,214,242,122,  7,250,110,249,107, 32, 32,176,116,131,
113,217,250,112, 81, 91,254,180,185, 21,159,103,156,179, 59,162,172,160, 24, 31,
155, 45,175,131, 75,106, 48,141, 31, 65,141, 59,239,241,183, 58,159, 50, 16,229,
  7,205,206,152, 93,113, 59,166,225,115,114, 63,230,121,232, 83, 94, 51, 90,253,
188,155, 63,105,197, 70,217,253,171, 22, 67, 80,120,215, 38, 55,101,215,100,232,
237, 29, 43,110,252,100, 88,101,255,213,161,113, 54,141,174,160, 63,156,212, 21,
131,101,100,149, 13,117,160,129, 21, 83, 10,  9, 81, 32, 51,113, 90, 40, 12,  7,
 32,132, 16,227,152, 21, 55,143, 25,165,188, 90, 86, 16, 69, 96,144, 72, 65, 88,
 89,112, 36, 74,124, 19, 39,252,192, 65, 16, 59,230, 42, 47,132,109, 35, 26,113,
 71,233,112, 91, 24,129,199, 43,  6,241,110, 38,206,218,100,245,140,136,171,229,
146,148, 73,151, 88, 28,116,111,124,134,184,114, 32,180,  8,188, 57, 29,136,165,
150, 51,203,186, 99,113, 75, 69, 94,230,134,194,250, 11,166,244, 30, 70,155,231,
157,220, 66,240, 91,231,180,138,226,196, 60,195,142,106, 55, 47,141,108, 38,227,
117, 42,219,138, 18,165,167, 64,141, 94,225,130,135,220,177, 17, 34,239,144,220,
114,192,129, 32,135,  5, 88,  8,176, 68,107,125,244, 77,118,  3, 79, 75,222, 12,
 16,113,137, 82,157,  8, 33, 78, 36,196, 85, 82, 53, 81, 73,239,195,180, 82, 62,
 91,128,211,171,110, 66, 73,131,186, 17,117,  0,124,192, 68, 96, 52, 28, 27, 31,
 68,185, 67,209, 76, 66, 49, 98,113,220,160,166,107,252,157, 44,191,252, 26,252,
137,208,180,132, 65, 14, 13, 92, 74,192,241, 18,235,123,108, 72,208, 55,238, 82,
174,178,101,181,239,110,146,179,  8, 29,113,122,192,  7,204,252,189, 67,254,205,
205,192,208,155, 96, 85,235, 58,228, 64, 14,  2, 17, 41,206, 64, 53, 86, 41, 10,
192,
} ;

// ../CUDA/include/GB_cuda_timer.hpp:
uint8_t GB_JITpackage_10 [435] = {
 40,181, 47,253, 96,146,  3, 77, 13,  0,150, 22, 73, 33, 16,209, 60,115,141,216,
 76,  1,215,101, 52,113, 10,236,253, 22,155,162,141,125,178,134,115, 39,109,125,
  7, 34,  2,  0,168,210, 25, 65,  0, 64,  0, 63,  0, 80,161,162,170,200, 48,160,
 42, 23,124,143, 67,186, 98,102,230,210,229,153,112,223, 75,237, 28, 58,188,206,
 19,115,191,235,200, 73,140, 67, 41,255,165,110,111,210,241,243, 20,140,105,235,
223,211,149, 77,176,137,187, 28,138, 16,207,204,240,105,146,209, 52,  5, 31,126,
 19, 95,126,200, 95,193,186,237, 83, 45,122,109,255,171,142,168,146, 73,184,156,
 37, 72, 68,235,174, 45, 34,217, 34,152, 95, 90,166, 81, 32,132, 42,103,240,197,
252,240, 98,  5, 93,215,176,147,232, 99,242,235,223, 92,239,208, 82, 55, 23,197,
203,  3,243, 51, 38,120,164,133,175,181,243,220,218,183,183,237, 99, 22,238,238,
114, 35,187, 17, 51,124,127, 99,222, 90, 38, 66,201,142, 25,225, 79, 71,241,179,
111, 43,248, 20, 32, 37,146,134,183, 45, 30, 90,231,121, 10,134,131, 79, 45, 88,
  1,146,146,170, 40, 82,130,149,218,  7, 72,105, 57, 71,114,108, 30,247,103,135,
  2,207,107,170,189, 57,252,108,134,123,250, 26, 79,113,225,123, 94, 17,196, 23,
 95,202, 33,154,239,247, 27,231,180, 94,140, 63,153,155,183,254,172,195,193,215,
 18,  4,158,223,  1, 55, 32, 96, 36, 16, 65,172,  3,244,114, 97,211,  1,221,140,
 29, 36,206,177,241, 37,131,163,  7, 12,202, 28, 33, 41, 24, 23,100,193, 38,242,
 23, 92,136,218,152, 20,137, 19, 47, 52,250,161, 50,212,218,  0,161, 89, 85,113,
233, 69,192,  1,209,  2, 92, 14,113, 12,124,136,113,134,201,140,159, 47,158, 78,
 24, 26,224, 69,224, 10, 55, 32,180, 84,201, 48,164, 23, 21,184,225,122,185,192,
203, 90, 58,183,150,178, 38,161, 35, 19,129,203,157,251,110, 40,247, 63, 45,179,
173,155,134,133, 10, 43,125,  1,144,247, 70,139,162,206, 13,
} ;

// ../CUDA/include/GraphBLAS_cuda.hpp:
uint8_t GB_JITpackage_11 [480] = {
 40,181, 47,253, 96,150,  3,181, 14,  0,150, 88, 80, 33,  0,181, 30,214,170, 36,
216,140,197,198,135, 94, 84,107,165,141, 96, 85, 24,172,178,132, 76,172,155, 97,
 59, 75,255,239,245, 33,  4, 71,  0, 68,  0, 71,  0,150,125,145,254,241, 57, 31,
247,253, 96,206, 65,112, 58, 33,129, 21,176,106, 97, 40, 96, 46,240,  2, 78, 24,
177,168, 66,220,154, 94,186, 59,  4, 97,141, 19, 24, 63,234, 42,118,191,113,168,
147,162,120,173,106, 67, 30,189, 38,100,163, 93,221,220,178, 43, 86, 61,241,235,
146,213,117,  5,154, 25,145,108, 50,218, 37,155,248,247, 54,127, 24,112,173,210,
135,109,  8,242, 93,239,246, 49,135,120,227,140,191,183,126, 93,238,238,210, 77,
146,210, 40,207,250, 55,233,101,193,194,170,191, 94, 21,167, 51,244,227, 15,239,
252,182, 82,253,152,223,195, 91,213,129,100,  2, 52, 35, 77,220, 31,187,134,224,
231, 96, 48,236, 30, 31,119, 87,144,231,112, 29,126, 62,190, 88,218, 78,122,208,
  7,  3, 77, 82,104, 39,178,101, 44, 24,141,102, 29, 41, 79,227, 39,227,172,235,
 72, 63,136, 69, 80,232, 81,215, 18,189,165,217,228,162,252,109,  8,244,242,135,
109,254, 15, 82, 82,162,120,173,146,222, 15, 10,255, 67,183, 14, 61,117,123, 88,
239,241,181,172, 80,146,139, 64, 54,140,132,202,185,109,149,203,228, 80, 50,147,
 11,  1,164,148,  6,239, 48,156, 54, 45,180,155, 20,154,  9, 48, 65,  7, 36, 29,
 18, 66,241,120,208, 19, 10,109,195, 55,197, 14,154, 36, 59, 32, 64, 70, 32,197,
142,234,  1, 24, 36,  0,162, 15,254,145,169,128,181, 99, 21,233,240, 17, 32, 14,
124,183,160, 66,194, 73,102,108,236,151,111,110,195, 64,227,114,119,  9,215,199,
 72,126,246,114,  7,213, 15,172, 10,228,  0,111, 10,227,  5, 90, 26,150,  1,  0,
 56,100,148,128,130,157,153, 81,150,117, 92,  5, 89, 33, 92, 64,187,208,153,  1,
188, 51,221,  5,  0,  3,171,183,139,  2,252, 66,190,  3, 36,205,191,180, 26, 14,
 56,242,230,131, 90,196, 57,206,205, 85, 77, 30, 42, 44,253,  4,167,219,232,134,
 77, 15,154, 26,114, 19,109,223, 86,210,177,150,231, 70,189,160, 22, 20,  5,110,

} ;

// ../CUDA/mxm/template/GB_cuda_jit_AxB_dot3_dense_phase1.cuh:
uint8_t GB_JITpackage_12 [1395] = {
 40,181, 47,253, 96,232, 15, 77, 43,  0, 70, 62,181, 40,208,210, 56,  7,152, 64,
163,133,189,229, 90, 13, 84, 52,113,227,206,238,230,137, 82, 69, 59, 29, 40,  6,
168, 22, 17,240,252, 68,171, 95,224,139,135, 80,106, 94,180,  0,151,  0,174,  0,
 80,118,207,184,147, 31,143, 84,127,121,215,125,160,202,132, 94,243,231, 75,225,
 53,215, 34,252,169,  4, 93, 98, 64,177, 76,118,203,224,204,252, 66,151, 65,220,
113, 53,206, 36,227,137,137,198,198,162, 67, 41,133,162,130,227,201, 92, 84, 88,
 92, 84, 88,207,112, 54,156, 12,138,  4, 11, 37, 77,105,253,178, 29,131, 94,121,
243, 80,180, 21,209,173,123,241,218, 91,136, 47,222,117,153, 87, 10, 22,  3,203,
132,225,192,192,114, 42,155, 94, 85, 22,193,205, 41,153,147,182,150, 30,123, 94,
 93,182, 82, 56, 59,219,252,117, 36,219,151, 81, 14,182,194,109, 98, 91,227,106,
 24, 66, 75, 13,211,140, 50, 88,243,  7,  6,181, 47,195, 52, 17,149,109,216, 77,
111,187,146,217, 96, 88,149, 78,102, 66,179, 77, 72, 35, 94,169, 72, 38,149, 74,
108,113,173,219, 48,178, 70,165,204, 30,226, 90,225,181,220,117,240,240,149,127,
182,150,202,174,149, 50,156,231, 42,254,252, 56, 41,187, 95, 48, 74,253, 26,118,
125,109,190,172,189,245, 84,190, 90,254,120,178,116,248, 30,136,149,169,143,138,
 39,235, 36,218,113,191,175,145, 97, 71,184,245, 57, 42, 59, 91, 81,243,227, 82,
172,123,178,175, 45,229, 15,100,233, 57, 42, 67,222,193,150,221,223,244,100,198,
 85,232,117,252,100,150,193,203,142,252,186, 28,236, 87,145, 31,233,118, 75,186,
165, 73,148,241,187,245,107,132, 89,125,183,145, 46, 39,161, 68,201,205, 77,225,
 60,108,168,133, 34,103, 17,118,240,115, 45, 30,221, 94,141, 66, 93,163, 80,139,
176, 43,231,193,117,124,179, 62,166,203,173,185,203,134,188,218,202, 33,242, 28,
136, 79,241,116,  8,142,230,170,224,160,187, 53, 71,232, 49, 59,172, 83,108,109,
 32, 40, 34, 56, 29,140, 45,238,181,225, 84, 41,122,211, 59, 19,153, 12, 10, 12,
243,108, 69,209,123, 99,  9, 11, 29, 25,196, 90,220,209,200, 99, 97, 92,120, 58,
152, 68, 39,  3,112, 16,  7, 48, 51, 55,124, 62, 76,174, 83,211, 49,159,215, 49,
172, 51,166, 93,151, 98, 24,193, 33, 44, 54, 60,216,172, 50,175,174,222,144, 68,
 68, 66, 93, 93,189,191,  3,189,178, 62, 98,218,240,194, 52, 52,226,210,159,172,
244, 55,255, 95, 50, 73, 52,150,162, 99,152,236, 66, 24, 70,119,146,182, 74,189,
172,127,107, 73,  9, 18,201,  8,197,253,  5,212,116,130, 83,  0, 83,195,197,212,
171,209, 53,221,211,201, 88,212,196,222, 59, 41, 63, 91,187, 29, 97,107,233,108,
224,178,221,178,141,151,113, 94,175,170,107, 98,206, 53, 96, 46, 30,215,232,170,
248,218,175,131,162, 89,224,  0,187, 91,173, 54, 95,  4,  4,  4,  4,230,171,210,
188,166, 63, 56,204,175,183, 98,155,113,183, 83,118,178,  3,117,133, 29,247,234,
160,162, 28,124, 66,242, 46,187, 86, 57,171,145, 85, 25, 93, 21,249, 90,121,235,
 71,214, 40,143, 55,152,130, 82,244,238,176, 37,174, 24,102,  9, 57, 56,124, 68,
 25,105,156, 99,222,149, 50,104, 78, 23, 46,147,221, 71,131, 75,183,158,171, 77,
 52,166,235,113, 31,190,225,185,248,109,153,124, 21,249,160,141, 28,129, 34,168,
 97, 49,114,166, 68, 68, 68, 36, 73,146, 76,  7, 81, 12, 98,136,229,188,132,119,
194,224, 76,202,241, 16, 97, 16,145, 10,100, 68, 38, 39, 73, 74, 10, 82,174,  3,
129,128,106,177,162, 49,214, 22,240,109,174, 67,222, 54, 47, 39,193,139,160, 76,
111,197,154,120, 26, 96,153,201,180,212, 29,168,106,141,239, 20,154, 39, 67,203,
 66, 71,226,247,180,231, 82, 16, 50, 16,148,223,113, 15,146, 18, 58, 62,252,157,
 29,228,189, 41,163,245, 32,135,187, 95,241, 25,146,160, 55, 74,220,139,119,219,
205,224, 68, 32,243,148, 43,100, 21,206,105, 39, 44,179,111, 53, 29,249,134, 67,
 56, 39, 87,153,154, 93,134,120, 90,187, 38,108,132,158,196, 61,128,239, 76,  7,
 95, 11,101,140,123,123,113,127,134, 31,132, 88,243,233,226, 84,236,216, 24,233,
 38,156,145,221,112, 81, 85,102,110, 21,224,129,209,134,206,155,246,137,182,235,
 16, 83,154, 94,146,231,151,101, 23,197,122,135,111, 67,162,133, 40,  2,223,187,
156, 80,231,135,255,230,182, 33,168,156,145, 12, 40,  9, 92, 32,207,201,184, 71,
172,251,140,255, 74, 65, 96, 82,248,179, 24,229,178,176, 89,188,215, 64,  5,198,
200,240,151, 22, 25,120, 35,238,224,183, 61,190,163, 23,117,248, 80, 58, 65,100,
255,195,  7,195,153, 46,  3, 45,228,142,113,107, 86, 26, 12,241,237, 76, 20,143,
247,110,193,159,108, 59,192, 93,227,163, 77, 86, 58,240, 16,141,109, 39,170, 55,
157,208,195, 70, 63,127,167,129, 30, 86,208,175,250,218,136,225, 65, 15,116, 53,
 82,248,101, 77, 34,182, 96,205,228,102,238,162,169,203, 15,123,191,227,146,125,
165,206, 70,101, 10,  9, 41, 92,  1, 84, 39, 43,249,181,177,179,168,131,220,  6,
157,179, 82,238, 37,232,190, 92, 91, 76,112, 46, 62,249, 70, 35, 81, 16, 75, 77,
 84,221,172,144, 75,105,153,248,160,235,221,144,134,154,110,252,103,194,247,142,
142,128,192,214,253, 42, 34,189,246,193, 75,160, 50,203,242,229,104,121, 63,  9,
153,138,160,150,193,  0,  4,131,176,114, 64,223, 23, 69,191,  7,  7,246,221,135,
 86, 41,205, 44, 76, 89, 83,189,155,169,114,239,144, 92,205,122, 30,124,117,183,
 22,206, 35,  0,152,124,  8,181, 88,  8, 44, 14,116, 98, 16,180, 30, 68, 78,  8,
247, 96,166,135, 16,239,118,135, 17, 85,132, 75,223,113, 89,117, 48,250,215,208,
  8,192,115,173,196,166, 92,175,177, 31,167, 27, 52,178,125,249,171, 52,170,199,
  8,175, 32, 68,209, 86, 27,246,107, 10, 52, 10, 98,243, 63, 52,220,146, 92,142,
206,109,170,  5, 21, 65,213,224,108,193,  3,227,147, 17,167, 53,242, 81, 81,163,
144,246,204,134, 72,159,224,  0,133,102,230,  5,194,209,237,161,160, 36,223,208,
 14,238, 75, 15,231,189, 40,240,195,161, 78, 13,231,135,130, 53,129,202,192, 46,
 97,178,176,175,206,203,116, 84, 63, 68,205, 12, 26,114,124,224,203,223,110,153,
 56,221,180,173,138,106, 75,153, 16,188,226,180,234,  8,238,
} ;

// ../CUDA/mxm/template/GB_cuda_jit_AxB_dot3_phase1.cuh:
uint8_t GB_JITpackage_13 [3717] = {
 40,181, 47,253, 96,220, 59,221,115,  0,234,118,128, 21, 46,160,142,145,205,  1,
 42,185,249,105,216,179,191, 81, 21, 66,104,120, 84,191,180,244,230, 95,111,107,
111,239,150, 57,248,164, 72,172,132,206, 69, 45, 87,240, 58,188,142, 28, 47, 77,
 16, 68,  1, 75,  1, 76,  1,145,117,169, 52,160, 28, 76, 24, 29,245,174,119,242,
165,140, 55,114,247,241,182, 63, 85, 68,157,245,182,241, 55,250,203,246, 55,251,
 52, 90, 61, 46,139,124,107,109,148,217,111,127,114, 68,189,163,247, 26,215,254,
 44,112,149,241, 82,140,141,221,157, 31,205,178,217,183,140,137,247,208,  4, 63,
251,179,242,189,209, 59,173,252, 33,153,116,158,185,123, 59, 99,102, 47,121, 86,
198, 64,248,126, 94, 71,179, 87,  1,  2,126, 39, 87,222,182,214, 48,149,122,124,
114,180,181,241,244, 78,218,183,111,141,222,227,141,218,181, 25,207, 49, 59,155,
 81, 70,236, 90,164,242, 89, 75,138,117, 27,123,233,144,229,198, 58,250, 33,225,
234,189,210,237,119,126,220, 33,123, 25,147,125, 24,157,113, 94,147,253, 97,144,
135, 40, 66,194, 92, 22, 61,120,169,114,111,125, 39,107, 22, 18,182,147,179,190,
144, 68,160,176, 88,181, 70, 24, 25, 22, 23,168,145, 97,209,200,160, 14, 45, 40,
 44, 30, 96, 16,136,168, 27,143, 82,151, 88,246,118,219,220, 37,210, 56, 83,217,
178,198,237,229, 56, 90,227, 82,194, 67,  5, 34, 30, 34, 36,  7, 32, 30, 34,254,
100,206, 33,219,153, 72,241,  8,126,195, 93,218,245,229,144,196,182, 70,207,226,
219,159,  5,225,190, 44,130, 96, 27, 57,239, 26,112,169,118, 77, 26,120,221,238,
184,162,246,101,215, 84, 49,225, 27,165,215,241,157, 64, 10,  7,212,196,130, 23,
 19,231,197, 90,241,201,  4, 34,153, 76,  2, 23,116,128, 16, 66, 24,167,105,154,
166,  9, 66,  8, 33,196,128,225, 21, 75,  3, 90, 44,231, 23,141,138,101,193,231,
 99,118,206,173, 11,248,  0, 99,178,204, 72, 80,158,113,102,118, 26,205,133,114,
160,113,177,174,  6, 22,  4,208,221,237,121,222,214,218,100,137,115,  9, 36,213,
 31,231,148,115,213,175,235,102, 93,175,229,122, 93, 14,191, 92, 29, 26, 21,139,
  4,  6,151,101,113, 85, 91,  7,128,170,203, 28,144, 11,144,231, 19,172,174,213,
 52,218,253,210,217,201, 56,123,131,168,107,186,222, 88, 93, 83,173,152,204,126,
 32, 34,206,164,117,229,112,248,189,  8, 24,144,102, 95,227, 27, 51, 42,101,228,
 10,113, 32,151,214, 52,243,235,186,174,205,140,221,185,219, 30,182,169,237,141,
158, 39,149, 44,214,252,253,176, 67, 12, 46,208, 82,169,208,168, 84,246,155,202,
 25,204,122, 96, 61,168,204,221,230, 67,255,165,138,197, 84,101, 76,184, 34,141,
165,140,153, 70,185,203, 29,111,174,215,113,141,151, 78,127,148,245,214, 25,123,
146, 51, 57,  8,120, 26,146, 28,120,202,159, 14,168, 29, 10, 86,218,217,217,241,
 78,154,157,203,154,243, 56,244, 80,206,199,156,231,143,182, 80, 83,212,202,200,
209,166,210,142,187,203,136, 81,201,193,183,171, 71,247,217,115,166,111,148, 95,
247, 93, 91,123,155,119,122,208,219,219,183,145,187,213, 68,149, 63,122,156,107,
145, 43,119, 95,217,251, 38,214, 26,223, 53,  5, 38,163, 18,147,108, 48,201,253,
232, 31,144,234,102,141,102, 87,  5, 81,179,217,202,184, 85,175,116,107,201,171,
 14, 65,149, 71, 57, 70,130,178, 81,121, 20,174,169,160,174, 62, 25, 51,199, 84,
215,227,217, 93,229,203,218, 39,226,149,172,105,204,146,114, 30, 26, 20,109, 67,
 67, 67,131,119,232,195,171,156, 39,152,240,190,203,246,226,172, 37,123, 84,218,
223, 72,229,246,107,163,196, 28,130,128,232,181,150,122, 16,165,169, 38, 93, 89,
204, 33,167, 68, 62,102,247,137,235,138,224,160, 82, 19,105, 52,139, 83, 60,137,
 89,147, 68,214,110,244,  1, 44,215,239,102,124,155,203,106,188,  3, 75,197, 99,
181, 25,157,123,148, 74,158,223,229,174,239,227,111, 60,102,126, 92,  6,101,216,
192, 46, 60,145,200,196,177, 75,252,225,148, 99,191,179, 29, 41,105,157,223, 99,
199, 17,171, 87,249,218,230,224, 42,153, 59,116,203, 27, 20,174, 77,141, 44,179,
  5,154,135, 55, 80, 54, 88, 71,235,198, 25,154,113, 61, 99,159, 49,122,174,213,
168,205,120, 45,166,178,183,225, 54, 48, 20,206, 81,167,188,195, 57,173,244,102,
156, 57,119,175,196,149,217,182, 71,228, 91,255,105,231, 83,197,102,198, 13,143,
194, 67,224,137,248,196,196, 49,206,217,126,151, 42, 85,  4,139,  5,212,159,166,
 40, 42, 24, 21, 22,214,213,212, 53, 65,175,116,154,166,105,154,166,105,154, 38,
236,129,184,228, 93,107,210, 31,236,109,236,226,108,228, 46,168,209,116, 63,151,
174,224,207,197,133,  3,140, 83, 40,151,224, 56, 18,  2, 16, 72,134,  8, 22,137,
 92,226,144,204,178,140,116,242,165, 24, 87,126,150,235,163, 39,194,185, 38, 41,
 23,105,156,137,246, 83,202, 24,185,123,208,  9,113,166,237, 39, 51, 77, 37,122,
 28, 73,228, 54, 58,189,151,241,179,192, 16,119, 57, 38,203, 67,179,251, 36,181,
 27, 76, 19,205, 99,108,188,246,242, 58,190,103,142, 88,233,181,188,142, 47,146,
196, 93,156,215,165,113,141,156,189,174,238,179,186,143,122,  2,203,162,  1, 33,
 92, 24,144,178,174,  6, 84,198,197,161,137, 25, 51,107,146, 36,108, 99,205,201,
230,198, 70,143,115, 93,145,200,134,  5, 64,109,244, 26,214,102,223,131,214,239,
198,107, 63,217,222,206,192,214, 98, 97, 80, 76, 32,219, 11, 44,176,186, 88, 76,
145, 95, 66, 82, 58,123, 54,229, 90,134, 91,172,200, 31,  7, 64,231,117,207, 51,
224, 19, 14,127, 30,  0,159,221,221,225,  8, 78, 73,240,  7,210,196,206,179,  8,
 34, 32, 78,153,136, 60,148, 59, 91,178, 25,155,121,128, 72,247,163, 88,180,108,
165,202, 37,  3,  3, 50,169,240,134,134, 63, 14,108,  8, 97, 71,  8, 59, 66,  8,
 33,132,241, 16,  7, 33,236,  8,161,247,157,231,233,188, 36,229,183,189,210,123,
177,155,216,110, 64, 68, 54, 58, 40, 80,228,243,240,  4,147,119,201, 41, 79, 67,
195,161, 14, 72,211,135,188,137,155,160,136,  1,222,135,161, 84,118, 96,135,180,
201,215,228, 29,154, 60,238,162,229, 40,137, 63,152, 67, 92,229,188,186,184, 14,
233,225,175,222, 87,207,227,252, 98,  5,132, 37,168, 99,217,130, 18, 66,102,102,
102, 36, 73, 82, 40,116,179,113, 16, 16, 14, 18, 18, 73,163,170,164,123,147,224,
242,129,168, 22, 69, 36, 56, 67,129, 20, 99,136,225,  8, 18, 16, 98,  4, 73, 68,
 36, 16, 17, 17,  5,153,107, 25,  1,220, 37, 66,222,130,194,186,135,126,232,252,
199,213, 72,161,164,192, 92, 80,201, 91,249,173, 47, 31,245, 54,229, 11,182,122,
 43,182,  5,104, 61, 24,208,208, 95,197, 37,245,223,192,181, 13,121,196,102,100,
140, 44, 24,156,122,136, 41,101,137,163,208, 37,231,176,251, 24,  1,201,223, 20,
 54,243,118,213,173, 20,148,246,175, 93,227,213, 92, 93, 76,211,228,120, 62,138,
220, 82,133,221,119, 99,113,219, 66, 86, 20,178,182,150, 75,  4,136,143,109,102,
242,215, 54,176,  2,169,109,108,  2, 22, 53,102, 44, 40, 20,  6, 47,172, 72,139,
202, 81,196, 45,138,178,210, 93,135,239,140,182, 12, 45,211,140, 27,146, 89, 23,
 40,144, 93,149, 94, 34,145,159, 37,147,  9,248,205, 92,184,124, 92, 41,168, 92,
227,136,  7,105,208, 97,190,106, 55,210, 87,231,  6,196,167,207,149, 59,129,125,
255,129,129,118, 72,139,  9,130,224, 66,241, 98,214,231, 88, 31,176,195,121,128,
 37, 83, 58,184,251, 10, 42,144,119, 91,253,225,134,159,127, 17, 32,172,241,178,
155, 70,  4,245,  9, 58,151,138,111,131, 27,189,229,167, 51, 58, 75, 41,136,193,
151, 39, 18,197, 13, 49, 67,209,131, 16,240,242, 86,126, 58, 76, 32,110,226,166,
120,144,149,250,206, 41,192,104, 80, 57, 88,179,231, 14,112,128,242,199,122,151,
225, 72, 32, 28, 33,158,242,153,237,147, 20, 91, 69,182, 53,229,175,250, 99,216,
244,159, 53,185,133,238,127, 99,145,187,237,154,231, 94, 21, 93,199,166, 19,245,
100,180, 67,137,129,136,148,184, 59,249, 16, 88, 15, 98,139,194,156, 63,143, 44,
141,213,128, 16,253, 41, 91, 77,140, 56, 29,210,133, 30,174, 89, 63,135, 47, 37,
 38, 15, 30,221,139,114,104,  1, 92, 94,251,208, 17,211, 81,119,231, 94,207, 57,
 88, 68,131,192,245, 91, 44,144,131,156,234,207,120,167,116, 64,168,128, 56,189,
120, 31,252,220,149,246,133,200, 98,183,172, 25,241,153,199,175, 10,194,222, 37,
 11,252, 27,232,244,174,255, 73, 27, 59,247,  4,197,184,159,217,231, 68, 47,224,
147,170,170,206, 56, 51, 59,194,141,114,109, 12,104, 75,244,153, 55,208, 25, 16,
217, 85, 11,101,191,117,181,112, 40, 99,  6,160,171,223, 27,158, 57,  3,207,160,
 12,213,205, 88,141,165,  7,119,132,120, 64, 68,146,187, 50, 56, 89, 94,129,145,
 30,249,133,142,  3,148, 25,202,137,183, 27, 29,195,124,204,211, 95,171, 43,108,
108,156,  3,219, 34,224, 26,180, 38,158,  2,188,248,130,208,213, 24, 83,229,  8,
238, 97, 63,204,174,202, 54,122, 76,248,149, 41, 71,105,204,220,209,128, 71, 87,
169,213,108,174, 47,152, 52,143,255,135,230,181, 82, 88,137,106, 61, 90,128,107,
176, 59, 97, 31,180, 53,243,207, 32, 77, 99,187,210,127,235, 58,245,170, 74, 50,
238, 23,168,177, 75, 77, 23,185, 70, 78,253, 51, 10,103, 98,167,205,232,133,130,
100,144,146,251, 89,134,250,138,183, 61,  3,233, 32,122,251,158, 72,150,247,106,
 29,111,113,254, 19,  6,114,136,105,185,  3,110,171,252,225,141,  3,185, 11,216,
250,227,144,242,  7,208,137,171,176,  6,149, 91,234, 28,130,233, 36,178, 16, 40,
146,233, 39,152,234,242,209,200, 84, 12,158,224,146,120,130, 16,216, 51,153,120,
195, 97,143,187, 12,124, 56,  3,162,137,236,183, 13,141, 67,  7,166,247,146,199,
141, 67,151, 45, 40,102,  4,162,186,177,246, 65,132, 79, 71,145, 28, 92,115,228,
 97, 45,  4,253,192, 47,139,226,132,163,242,204,191, 80, 95,121,  8,136, 43, 22,
198,129,167, 27,159, 40,144,157,253, 21,  5, 45,224, 73, 62, 83,219,  3, 64,219,
 52,115,155, 52,230,238,168,146,248,199, 85, 17, 57, 85,163,180,232, 62,131,250,
159, 55,239,103,241, 54, 11, 10,213,123,183,149,208,142,184,204,231, 95,157,165,
163, 90,244,118,174,219,150,  5,146,207, 88,240,148,139,168,  9,215, 76,198,205,
 96,123,222,221, 76,136,229,130,104,119,234, 62, 67,  4,181,221,  4, 22, 56, 33,
 62,222,190,152,164,237,115,108, 33, 18,202,150, 79,207,207,  0,235,170,203,151,
189,152,117,211, 12,131,170, 59,179,185,207,181, 59,251, 19,167,151, 53,230,230,
159,242,254, 56,177, 44,157,203,210, 73, 55, 56,208,  3, 28,242, 52,142,130, 82,
 42,149,250,172, 97, 17, 68, 37,  8,177,172,230,192,197, 74, 37,110, 48,148, 65,
143, 75,143, 18,218,205,  7,234,119,170,135,213, 82,144,176, 20,156,161, 27,181,
 51,  8,246,195,175, 57,241,218,164,186,237, 10, 69,141,  0,118,143,141,145, 34,
  6,155, 19,224,  3,135,128, 61, 47, 96, 87, 97,  3, 15,171,111,100,137, 84,125,
204,142, 43,144,157,229,139,173,151, 59, 37,  5,205,133,138, 19,100,242,161, 97,
251,225,169, 97,243, 97, 92, 14, 77,121, 62,237, 92,169,220,144,101, 85,245, 47,
 51, 12,150, 41,216,227,224,246,143,126,239, 72, 53, 20,144, 55,130,123, 29, 50,
120,102,211,186, 65,195,252,  8,163,169,191, 64,185,226, 82,224, 59,211,101, 33,
155,129,208,  4, 19,103,195, 96,252,115, 21,240, 93,154,  3,246, 45, 58, 35, 18,
223, 42, 87, 53, 96,170, 37,253, 15, 90, 27, 24, 85,137,132,221,155,246,243, 66,
 76,247, 34,101,214, 66, 49,171,209,189, 27,154,216,177, 38,143,107, 84,147,151,
186,226,240, 40, 67,186, 51,134, 59, 58, 55,191, 43,195,164, 90,193, 40, 69,147,
231, 47,220,180, 29, 31, 40, 30,  0,177,219, 31,145, 84,237,123,140,225,106,200,
  7, 29,100,120, 96,  0,  9, 12,197, 49,158,221, 58,225,197, 17, 18,127, 99, 84,
131, 94, 49, 73, 73,220,151,183, 11, 76, 33,108,131,189,187,188, 65,170,134,175,
  6, 21,163,140, 54,213,174,255, 84, 73, 75,135, 77,228,163,255, 77, 46, 54, 21,
136,254, 24,207,152, 87, 32,230,117, 87, 52,241, 48, 28,132,  2,212, 56,200,163,
165, 14, 73, 22,160,154,100,247,235,153,171,223,185, 31, 62, 53, 88, 93, 72, 40,
  2,155, 46,131,215,  3,225,201,208,156,174, 40,100,228,157,155, 37, 65,127,114,
 51,253,242,102,144,189,122,235, 77,169, 25,111,199,146, 85, 89, 12, 45,127,246,
141, 55, 26,136,141, 99,143,213,159,172, 12,253,233,230, 34,106,252,125,159,134,
244, 81, 45, 16,137, 61,174,152,127,108, 86,111,  1,210,  6, 99,148,149,161,184,
 56,211, 95,104,239,200,172,155,106,201,149,209,145, 38,  3,209, 43,210,238, 99,
100,250,162, 60, 48, 58,100,  6,142,251, 94,160,199, 98,104,153, 71,116,152, 32,
 77, 25,164,107, 70,180,125,206,216,176,131,187, 10, 64,206,133,183,100,193,106,
152,154,161,224, 98,  7,171, 97, 45, 57,134, 33, 47,  2, 49, 88, 69,204,249, 89,
 51, 40, 98,195, 46, 74,108,198, 62,230, 31, 73,228, 49,131, 40,232,  3,197,238,
 94,192, 43, 11, 35,205,250, 48,  6,147,236, 73,229,200,224, 39, 64,  1,218,216,
 21,131, 42,163, 48,105,254, 70,137, 38,171,139, 94, 58,207,171, 73,146,210, 26,
135,233,100, 57,214,  7, 69, 59,239,126, 90,138, 62,230,153,123, 51,138,163, 36,
166, 56, 20,  3, 32,133,236, 56, 81, 50, 34, 98,134,  9, 63,106, 92,207,181, 19,
102,100,190,184, 66, 10,178,249, 43,  4,242, 51, 40,235, 29,218,245,217, 91, 49,
 64,164,110, 93, 32, 47, 17, 31,255, 73,112, 71,158,206, 72,249,247,  9,155, 80,
225,110,238,196,201, 89,184,129,102,208,152,244, 82,174,151, 77,242,122, 95,208,
 25,228,193,108, 86,102,144,162, 86, 82,102,213, 60,198,  5,176,176,200,235,161,
193,194,175,114,210,221, 16,218, 51,138, 81,159, 13,127,209, 17, 91,220,102,155,
114,228, 66, 69, 35,124,  5, 67,175,153,138,135, 59,138, 34,167, 82,148, 88,132,
134,191,185,228, 47,  0,174, 54, 63,108, 13,186,237,122,214, 16,101,195, 15, 65,
 12, 98,196, 67, 31,192,141,254, 81,174, 14, 82,202,199,210, 42,108, 55,253, 89,
 87,253,142,  1,210,162,215, 85,  6,137,250, 74, 13,141,110,206,108, 73, 42, 77,
118, 99, 84, 83,104, 39,225, 17, 69,185,106, 69, 92,107, 84, 75,128,138,182, 61,
 45,251,156,251,125,220,213, 42, 57, 30,181,251, 20,154,218,157,129,117,133, 78,
176, 11,226,190,186, 51,219, 68,179,228,251,212, 83,200,188,131,158,105,157,105,
 45, 89,106,  1,247,246,137,137,  0,132, 91,  1,175,  2,128,171, 12,172,124,204,
115,120,229, 41, 22, 16,137,185,217,103,204,129, 53, 69, 45,170,137,223,221, 36,
231,183,230,  3,133,107,255, 70,164, 56,132,154,138, 18, 95,103,132, 21,114,229,
 23,136, 63,143,205, 57, 19,149,191, 56, 25,211,134, 60,158,187,148,125,118,208,
150,132,131,216, 86,148,205, 50,171,181, 63, 47, 19, 20,170,144,245,145,168,161,
 84,  9,  4,105, 41, 33,130, 61, 42, 78,192,235,199,205,  5,225,231,208, 25,133,
161,  8, 20,167,127, 58,154,208,173,148, 25, 91, 49,214, 47,105, 33, 24,108,125,
172, 67,181, 44, 75,252,156, 94,144,113,236,109, 92,137, 65, 67,228,164,113, 74,
168,181,112,142, 27,143, 31, 45,251,194,169, 11,228,123, 66, 89,217,204,147,150,
 99,242,125,246,115,226,238, 67, 59, 24,232,132,113, 26,201, 50, 10,212, 91,  6,
 97,102,  1, 58,199,116,215,247, 94,157,201,249, 21, 59, 55, 58,201, 97, 17,124,
142,176,109,130, 72, 95, 29,242, 78,250,205, 91,156,214,  3,  4,162,  2,250, 75,
 42, 45, 78, 42, 67, 13,104,249, 36,198,146, 97,127,168, 67, 21,192,173, 75,239,
149,188, 28,148,196,135, 71,161, 16, 67,198, 78,163,222,160, 40,198,128,114,240,
137,  9,167,254, 10,107,163,214,196,102, 66,156,197,172,152,186,137,  8, 31,181,
183,156,238, 79, 42,186,136,154,128,227, 39,101, 60, 22,173,208,122,239,207, 45,
130, 76,142, 36,204, 97,227,167, 19,236,200,166,117, 31,116, 72,137, 23, 38,244,
 21,169, 15, 41, 20,231,184, 55, 63, 18, 90,123,106, 23,239, 74,175,144, 72,133,
223, 49, 27, 68,175,245,169,143,  9,164,192,210,246,245,236,150,184,217,128,240,
131, 24,114,160,249,108,110,251, 50, 59,205,143,171,230,138,183,158, 58, 49, 66,
 85, 52, 97,120,128,139, 63,176, 92,115, 64,124,153, 52,  9,  8,149,224,110, 56,
157,202,117,  0,226, 37,110, 74, 97, 38,255,171,143,157, 75,164, 34,126,182,190,
106, 93,145,151,127, 72, 95,112, 58, 74, 59,140,  1,202,202,145,255,184,192,176,
139, 55,169,116,113,168, 16, 19, 87,246,  7,162,174,139,211, 89,  1,
} ;

// ../CUDA/mxm/template/GB_cuda_jit_AxB_dot3_phase2.cuh:
uint8_t GB_JITpackage_14 [1205] = {
 40,181, 47,253, 96, 42, 13, 93, 37,  0, 38, 53,156, 39,208,178, 88,  7,200,165,
 81,153,181,242, 28,136,241, 66,174, 75,199,189, 22, 50, 20, 44, 34,220,196, 20,
105, 20,195,203,115,169, 91,228,106,  6,188,112,190,154,  0,135,  0,149,  0,157,
243,213,151, 22,136, 50, 85, 36,124, 61,151, 81,183, 84,142, 86,236,201, 80, 35,
 97, 59,249, 69,  8,  9,198,194, 68, 85,235, 20, 33,161,161,160, 54, 18, 19, 27,
137,204, 41,205,130,198, 34,130,160, 82, 63, 25,205,220,194, 50, 90,183,241,162,
152, 32,123, 42, 91,222,220,246,213,137,155, 75, 73, 93, 42,168, 80, 42,146,  3,
  1, 74,229,145, 23, 93,178,209,227, 22, 62, 81,255, 92, 77,177, 72,113,201,194,
182,186,172,226,142,183,130,174,251,166, 10, 91,119,101,109,160, 41,108, 24, 15,
170,117,220,104, 14,222,215, 48, 13, 19,110, 39, 51,140,123, 66, 45, 84,100, 38,
 21,  5,129,185, 50, 87, 27, 62,153, 64,146,201, 36, 52,139,167, 72, 40,254,137,
 51,227, 45,116, 92, 45,250,172,186,142,183,173,209,250,112, 14,185,114, 79,174,
 52,  4, 36,178, 60, 18,189, 53,126,209,195,176,181, 74, 39,205, 64,  8,151,174,
105,183,110,  4,  6,155,255,135, 64,250,221,218, 22,154, 98,187,202, 25,253,116,
207,158, 61,177,239, 99, 59,233,171, 23, 66,142, 50,203,220,153,115,218,207,222,
153,113,206, 91,239,110,123, 70,135,189,221,213,175,180,223,188,214,223,229,181,
184, 93,219,103, 18, 28,207,113,164,116, 25,143,104,113,157,224,120, 84, 98,108,
 51,199,187,156, 75,199,161, 50,209, 98, 22,189,237,201, 88,135, 61,180,114, 71,
246, 56,135,  8, 37,122, 70, 91,199,169,177,237,220,113,149,118,149, 97, 76, 97,
177, 96,110,126, 42,197, 24,115,151,149,148, 66, 53,177,161, 46, 90,  4,149,169,
218, 67, 70,  2, 66,146, 18, 44, 22,206,125,183, 24,114,246,233,202,192,130,192,
221,116,175, 58,127, 68,233,226,227,172,  2,129, 34,144,157,  7,144,160, 38,130,
145,122, 90,227, 25,229,140,173, 97,183, 98, 79,180, 87, 62, 15,  6, 12,194, 67,
160,144, 75,192, 47, 13, 74,144,  8,183,235,112,237,116, 92,139, 68, 19,140, 29,
 18,200,108,175,116,158,187,122,155,235, 43,181,206,146, 19,237, 12, 16, 20,  2,
 33, 92,138, 46, 80,105, 63,246,112,188,  4,241,187,144,235,105, 87,230, 96,119,
190,109, 69,193,240,144,169,192, 68,216, 91,116,222,183,214, 47,214,182, 92, 91,
179, 64,142, 86,132, 20,123,211,121, 41,154,  4, 36,251,113,181, 58, 56,233,116,
179,111,198, 28,174,127, 39,121, 86,230,104,151, 75,209,167, 72,132, 93,203,125,
 51,140,190,127,228, 99, 41,163, 55, 63,118,138, 68,205,198,171, 67,174, 17,240,
136, 64, 64,  4,144,241,232, 22,130,199,228,  1, 53,151,223, 90, 90,159, 59,228,
234,220,161,163, 16,174, 29,108,149,179,118, 73, 64, 56,229,151,195,128,243,168,
145, 33, 68, 74, 70, 68, 68, 36, 73, 82, 40,116, 32,132, 16,132,172,200, 60,130,
168, 76,204,115, 44,164,160, 34, 82,145,  4, 50, 34, 18,148, 81, 92, 80, 80,218,
  1,155,241, 16, 85, 53, 71, 20, 43,222,223,205, 63, 66, 22,188, 96,166,149, 33,
157,194,104, 46,102, 22,118, 89,222, 43,172, 49, 21, 32, 24,173, 43,212, 57, 33,
155,  9,101,245,228,151,219,184,219,148,212, 96, 40,112,177,177,174, 37,  4,123,
 21, 25,100,111,135,  4, 73, 16, 18,105, 93, 42,132,154, 49,148,255,154,113,164,
 76,  5,235,166,  4,143,148,111, 63,216,207,100,136,237,150,141,249,131, 98,218,
 16,214, 17, 50,  4, 23, 55,214,224,  7, 84,  0,251,185, 37, 17, 93,141, 11,220,
140,223,183, 13,197,172,148,167, 21,199, 88,213, 99,213,172,254,101, 50,120,208,
118, 70,162,  3, 26,242,136, 75, 98,249,169,119,253,231,250, 19,107,156,241,228,
232,240, 16, 92, 10,121, 47, 71,218,106,206,147,249, 15, 58,228,  5,186,156, 81,
 26, 99,145,251,205,234,108, 65,127, 57, 32,162,156,176,193, 44,187, 36,207, 63,
244, 46,220,173,199,161,107,237,161, 15, 49,165,211,196, 94,206, 38, 32, 51, 53,
102,120,123,147,205,101, 27,255,140, 77, 20,204,206,114, 45,155,244,193,  8,176,
172,134, 63, 73,133,165,156,174,133, 49, 34, 60, 15, 65, 21,175,194,159,179,155,
 39,227, 55,247, 49,159,203,117,114,225,209,217,210,  3,232, 12, 58,  3,140,200,
246, 23,233,224,147,184, 75,129,174,157, 94,236, 63,119,225, 31,164,242,107,133,
 35,209,247,112, 58,164,177,254,142,184, 25,235, 80,117, 13, 76,139,253, 51,144,
177,  4,  7,101,191, 56,154,156,172, 51, 37, 53, 72,125,135,197,185, 13,127, 74,
190, 52,211,172, 94,217, 27,176, 67,  4, 67, 71,217,254, 32, 75,  4,176,131,248,
137, 64,174,116,233,230,144, 76, 98,224,154,126, 65, 77,207,123,226,126, 16, 84,
140, 18,135, 59,155,140, 16,110, 79,209,193,158, 32,248,211, 47, 90,186, 60,  4,
155,177, 65,226, 98, 45,200,233,155,140, 84,117, 34,141, 95,140,101, 72,211,245,
112, 90, 26, 72,236, 53, 75, 62,130,241, 24, 98,127, 96,173,253, 41,163,112,205,
 74,112, 34, 86,172,216, 47,176, 17, 91,132,207,217,216,139, 33,224, 81, 36, 83,
199,173,204, 55,  4,148,230,180, 59, 42, 72,224, 56, 52,245, 30, 72,210,109,223,
 21,192, 39,246,185,183,  4, 47, 72,146,245, 27,134, 91,  5,167,131,245,  3,  3,
 72,249,162, 99,255,177, 49,112,186,105, 93,125,192, 39, 25,  2, 46,241,148,226,
101, 82, 26,  6, 77,
} ;

// ../CUDA/mxm/template/GB_cuda_jit_AxB_dot3_phase2end.cuh:
uint8_t GB_JITpackage_15 [1779] = {
 40,181, 47,253, 96,200, 21, 77, 55,  0, 90, 65, 24, 12, 41,208,210, 56,  7,104,
  2,253,190,217, 75,101, 92, 70,144, 55,  2, 26,136, 76,238,204,201,234, 54, 26,
 53,153,165,192, 95, 64,  1, 84,186,140, 82, 15, 60, 96,121,  1,188,  0,180,  0,
179,  0,151,206, 95,247,243,102,255, 63, 85, 81, 91, 83,144, 67,  8,161,189, 76,
210,190,208,101, 12, 81, 57, 58,115,247,242, 34,121, 86, 38, 65,170,130, 89, 38,
204,105,209,211,252, 82,185, 69,125, 39,111,157,  9,219,201, 90, 75, 76, 54, 56,
 21, 23,181, 98, 20,158, 14,134,198,194, 83, 97,225,201,174,233,112, 58, 26, 20,
  7,150,122,242,104,246, 11,203, 22,221, 54,135,129,109, 12, 82,217,178,197,237,
229, 70,109,113, 41, 53,191, 16, 44, 21,203, 68,161,160, 98,185,165, 85,191,108,
131, 68,206, 49,205, 79,220,165, 93, 99,252,186,176,173,209,187,224,219,223,  5,
197,125, 26,182, 77,182,176,141,156,  7, 13, 46,221,224,198,164,129,183, 61, 96,
220, 62, 13,110, 32, 40,124,163,244, 58,190, 20, 13, 39, 35,163, 92,104, 36, 54,
156, 23, 43,196, 41, 20,106, 66,161,  4,223,106,188,150,100, 43,123, 39, 14, 68,
250,156,203,158,185, 71,245, 74,175,198, 32,231, 46,233,194,165, 95,108,187, 68,
 37,183, 14,190,176,112, 82,245,139, 59,212,209,144,120,219,162,190,213,213, 29,
 58,155,  9, 79, 71,101,238, 54,223,206,142,215,242,184,186,202,126, 58,200,251,
188,179, 79,218,149,138,178, 95,166, 68, 40,139,154,248, 54,227,179, 91,158, 92,
 57,212,125,179,251,127,101, 55,197,  9,184,169, 16, 54,100,118,207,100, 30, 50,
 53, 91, 32,185,186,207,118,223,229,221,143, 18, 92,119,126, 27, 59, 39,167,208,
196,132,117,205, 33,105, 84,134, 38, 23, 24, 14, 17, 89,198,134,226, 20,135,180,
189,136,254, 20,107,141, 23,157,113, 94,173,235,181, 92, 33, 36,248,133,  7,  9,
119,246,175,157, 84,187,108, 27,237, 30,147,107, 47,215,214, 22,121,172,181,180,
 87,251, 42,198,218,108, 19,111,179, 35,199, 47, 81,106,  4, 83, 32, 25, 85, 18,
 16, 40, 36, 98, 73, 36, 11, 15, 29,243, 74,232,213,165,164,117,126,143,221, 40,
 86, 47,  0,244,129,167,206, 86,190,182, 71, 92, 79, 45,127, 50,130,220, 74, 40,
140,222,203,248,125,240,121,251,197,221,209,100, 25,207,124,217, 94, 34,250,217,
125,146, 39,189,157, 37, 58,219,225, 86,117,130,155, 48,211,214,145,100, 48,142,
193,236, 18,199,242,174,243, 99, 37, 90,127,146,204,253, 58, 77,146,141, 23,131,
 43,119, 69,205,217, 45, 82,137,121, 51, 76,178, 91, 85,103, 14, 21, 28, 24,144,
227, 64,  1,209,185,128,157, 89,140,175,253, 60,126,145,190, 49, 79,203,116,251,
177, 59,185,155,163,182, 54, 94, 86, 20, 53,210, 16,239,228,142,165,215,245,101,
236,248,219,183,253,234,249, 27, 24,132,134,226, 61, 74,229,198,163,202,221, 29,
 24, 57, 91,201, 31,169, 88, 21, 81, 91,  0, 12, 12, 86,159, 71, 51,114,218,233,
 60, 38,164,101,156, 45,250, 88,168,112, 76,193,143,177,110,218, 48, 32,137,  4,
244,249, 60,152, 42, 23,232,201, 55,244, 25,181,159, 62, 81,201, 86, 22,137,190,
203,198,154,101, 25,233,228,219,181,116,182, 23, 15,199, 51,249,214, 23,163,247,
118, 52,169,228,208,231,237, 95, 45,214,107,226, 47, 84,127,198,186,170,138,162,
 51,209, 57,193, 51,146,  5,104, 25, 81,153, 57, 36,205,143,211, 62, 16,110, 92,
 35,103, 33,108,216,216,180, 53, 60, 93, 28, 38, 54, 58, 15,147,126,227, 27, 43,
123,244,114, 90,103, 19,  5,  1,129,186,168,177, 45, 51, 35, 50, 34, 34,146, 36,
 73,134, 49, 49, 12,130, 24,  7,179, 84,238,  1,226,128, 84, 69,148,152,129, 12,
 17,194,  8,  9,  5, 34, 18, 36, 72, 81,138,146, 66, 14,185,149,245,189,148,154,
105,134, 96,238,226, 55, 39, 29,233, 93,171,118,162, 63,205,159,135,194,200, 24,
 66,255,199,217,176,161,238,191,116,103,201,124,227, 46,238, 51,223,181,233,178,
233, 64,111,221,141, 14,190,213,231, 73,124, 60,  5, 87, 41,135,245, 23, 73,166,
171, 55,219,110,143, 12,158, 13, 27, 74,121, 12,196,220,  7,253,229, 91,142,176,
 46,104, 37, 60, 17,114, 82,210,101,127,105,125,179,  6,130,149,169,159,228, 88,
182, 15,244,189,176,239, 85,173, 40,248,185,218,116,238, 18,244,245, 74,170,107,
215,  8, 98, 49,166, 20,239,108,112,119, 26,178, 35,199, 64, 89, 27,250,190,134,
 82,155, 46,134,161,144,183,227,179,211,249,196,184,103,108,208,160,  3,145, 16,
131, 43, 58,111, 91,238, 78,238,119,136, 84, 66,158,128, 51,137, 74,202,112,243,
157,165,122,201,137,193, 65, 54,237, 84, 66,152, 37,225,212, 89, 21,187, 97, 12,
219,218,242, 61,  9,137,158,148,186,122, 15,116, 72,184, 33,137, 28,  8,226, 11,
242,228, 16,120, 38,222, 79, 38,247, 35,213,108, 32, 84,180,245, 55,  7,251, 20,
180, 86, 32, 42, 57,149,216,166,236,142, 23, 85, 74, 11,  9,208, 11,147,171, 79,
117,199,141, 26,170,157,237, 65, 63, 40, 18, 96, 46,224, 12,101, 19, 34, 95, 21,
 22, 81,209, 60, 25,186, 38,  6,  5,165, 61, 36, 60, 72,200, 72, 80,137,136,127,
184,228,246, 34, 25,145,209,164,118, 57,  0,120,151,237,154,180,213,213,244,242,
221,144, 48,185, 40, 22,240,  3,192,156,254,111,137, 17,125, 81,234, 60,111, 41,
 18,254, 16, 24,131,229, 59,112, 36, 12,185, 28,246,242,208,195,151,209,157, 21,
232,251,202, 72, 36,154,190,110,111,148, 57,189,  6,223, 87,  4,122,117, 91,146,
242, 23, 35,145,110,178, 54, 99,101,213,230,219,200, 47,174,228,216,197, 13,200,
132,152, 79,161, 47,167, 48, 29,144,200, 52,230,228,217, 35, 96,  7,212,214, 28,
212,222,189,181,214,153, 47,127,204,231, 65, 97,222,100,165, 95,108,154, 69, 99,
 65,221,197, 53,237,180, 11,156, 53,186,105,220,245,246,206,181,167,246,114, 57,
 47, 21, 97,104, 24, 25, 80,216,109,138,245,133,140, 17,  0, 43,144, 40, 26, 85,
 91, 68,237, 89,113, 48, 87, 49,143,  9,165,176, 66,141,  9,132, 64,244, 85, 84,
 11,230,251, 62, 52,241,241,108, 83,144,155,157,111,191, 15, 64, 53,182,224,111,
 74,129, 79, 40, 70, 70, 12,250, 31,  1, 38,  1, 26, 11,145, 13, 87,195, 59,186,
 32, 20, 60, 23, 48,181, 91,205, 91,168,205, 67, 84,117, 44,184,143,168,175, 64,
207, 62,192,143, 31,178, 55,155,  9, 48, 87,132,201, 74,228,100, 45,105, 65, 29,
186, 29,156,229, 40,108,  5,199,247,130,194, 61, 68,116, 53,181,156, 44,240, 29,
160,108,104,218,  2, 18, 29, 21,116,160,  8, 61, 43,202,182,223,217, 84,242, 40,
 77,163,190,111,  1, 51,114,  0,215,165, 88, 48,  4, 44,  9,  9, 88, 91, 97,193,
128, 41,221,194, 69,211,199,249,195, 38, 57,244,223, 72,251,211, 22,109, 55,200,
 67, 40,152,249,124,169,172,241,114,195, 21,139,144,145,201,150, 35,191, 37,  4,
153,229,199,169,180, 75, 31,216,  7,104,214, 42,169, 61,139,169, 33, 32, 39, 73,
142,196,139,127,110,136, 40, 29,135,179, 52,168, 94, 39, 30, 81,179, 27,230, 55,
241, 58, 42,227,138,101,  8, 65,163,225,158,194, 47,119, 12,111,173,238,178, 23,
212,137,221, 54,  4,123,186, 30,139, 98, 58,126,158,148,115, 66,170, 51,201, 91,
 73, 28,168,253, 85,148, 75, 36,189,104,179,165, 99,190,  0,169, 63,125,130,132,
183,159,110, 77, 68,244,138,177,223,229,228,213,143, 24, 21, 15,163,112,173, 29,
129, 36,201,156, 20,197,115,190,121,101,173,230,149, 57,110,198, 96,  9,232,205,
148,151,112,176, 75,154,  1, 74,163, 65,223, 96,199, 30, 14,240, 81,145,122,250,
241,198, 80, 81,137,139,175, 96,110,204,122,126,130,109, 65, 19, 71,213, 67, 34,
 31,178,116,206,228, 79, 38, 86,108,146,208,106,164,177,112, 12,138,160, 72,190,
143,210,200, 80,212,191, 18, 37,193,125,  9, 76,  1,141,202,236,216,  0,178,148,
242,208, 93,156,100, 78,129,248,179,189,  8, 29,172,  9,  4,131,148,  3, 28,246,
225,152,121, 77, 55, 61,213,135,112,242,193,252, 46, 81,135,170,  7,192,  9,
} ;

// ../CUDA/mxm/template/GB_cuda_jit_AxB_dot3_phase3_dndn.cuh:
uint8_t GB_JITpackage_16 [2241] = {
 40,181, 47,253, 96,121, 31,189, 69,  0, 10, 83, 60, 15, 45,160, 78, 89,231,218,
 50,227,229,205,111,127,180,206, 34,155,243,201,199,155, 70,  1,116, 89,243,204,
 88,188,238,124,105,100,127,221,254, 21, 99,114, 24, 47,199,139,225,229, 88,  5,
231,  0,223,  0,237,  0,251,113,200, 41,223,209,153, 97,249,125,107,206,184,180,
 52, 78, 85,167, 63,175,191,121, 25, 63,251,146,252,126,184,190,179,154,228,203,
217,117, 51,163, 52, 25, 47,177,136,128,185,224,235,122,158,102,218,177,187,246,
153,209,207,204,183, 70, 50,229,110,235,119,235,215,205, 62,109, 82,239,220, 74,
186,155, 55, 30,166,135, 99,183, 44,122,240, 17,116, 57,195, 45, 87,155, 56,182,
202,205,152,226,128, 16,177,184, 80, 58, 85, 42, 38, 24,104,169,176,176, 84, 84,
135,147,200,228, 65,165,192,131,122,188, 89, 61, 98, 57,206,188,242,134,153,180,
229,208,173,107,121,237, 77,195,150,115, 28,188,100,224,241,240,112, 32, 32,240,
240,120,148, 65,151, 42,115, 98,228, 19,188,103,235,217, 49,230, 82,196, 86, 26,
189,203, 54,127,151,198,246,101,147,212,164,118, 65,108,141,155,119, 65,244,212,
 46,170,  3,175,102,140, 43,106, 95,118, 81, 20, 14,219,145,243,186,109,  7, 24,
185,168, 28, 46,144, 66,109, 94,164, 20,119,112,104, 56, 28, 28,  2, 12, 21,139,
  4,131,129, 22,215,101,  2,224, 25, 14, 64,193, 94,205, 27, 21, 26, 81, 35,246,
110,205,208, 85,206,140,162, 62, 79, 50,220, 84,171,254,151, 42,235,162, 40,197,
255, 55, 32,141, 39,231,215,197, 69,108,114,154,235,186, 40, 76,232, 84,205,223,
102,154, 65, 35, 23,179,165, 92,148,156,209,180,232,225, 60,110,238,235,164,216,
 81,139,147,251,220,208,249,137,114,244, 62,227,171,204,152, 82,253, 30, 73, 17,
245,145,151,224, 71, 66,157, 69,186, 88,247,201, 47,135, 69,166,145,243,248,128,
 56,164,126, 90,236,149,235, 76, 29,109,  2, 57,246, 94, 74,103,170, 82,172, 90,
 92, 26,128,223,153, 58,142,204,122, 41, 66, 96,147, 77, 14,211,152,106,168,138,
135,130,223,122, 98,239, 38,205, 84, 58, 59,147,187,117, 91, 51,157, 26, 46,106,
 91, 35,230,240,104,253,150, 51, 57,228,114, 88, 35,249, 20,195,  0,120,200,171,
207,126,203,152,241,205,248,180,252, 79, 85,210,237,142,222, 61,205,181, 78, 26,
  2, 78,161, 92, 48,216, 96,208, 41,222, 68,232, 16,131,226, 51, 64, 14, 61,105,
179,160, 91,215, 70,215,243,108, 22,133,  9,116, 78, 64, 75,189,199, 12,223,227,
 77,197, 84, 23, 22,204,229,114,112,129,171, 73,141,220,142,116,189, 57, 51, 79,
179,132,  8,122,  4,204,  4, 83,145, 68, 38,151,196,  2, 41,149, 36,178,149,139,
153,218,149, 59,123, 97,112,118,110, 78,172,170, 92,245, 70,193, 41, 88,222,132,
179,  5,105,184,132,130, 91, 30,100,121,104,203,253,150,197,141,128, 40,134,  1,
 17, 75, 17, 80,132, 33, 49, 84,125, 31, 62, 17, 65,199, 88, 36,151, 11,148,203,
113,180,237,108,189,186, 88,183,205,231, 98,207,142, 62,178,131,126,161,192,  7,
149,135,236, 83,224,192,215,242, 91,198,186,249,161, 40, 12,123, 95,  9, 90,178,
  5,180, 48, 19, 10,114,220,151, 57,157,247, 98,215,140,157,238,214,188,219,134,
 97,105, 96, 61,178,216,226, 71, 28,145, 84, 40, 38,151,139,171,170,162, 40, 42,
195,154, 92,  5,127,103,194,  1, 35,232,144,119, 96,215,165,215, 21,141,198,  5,
 41,170, 18, 18,112,104, 66,226,154, 22,175,140,187,217,113,226,217,231,225,208,
161,235,122, 67, 67,246,217,202, 45,196,170, 48, 23, 22, 81,  7,210,109,247,207,
102,232,146,  9,101, 85, 52, 60, 92,188,244,112,137, 73,227,230,246,173, 95,204,
 22,187,196,151, 36,232,115, 93,144, 87,141,167,156,221, 35, 84,224,183,162,138,
160, 76,122,106, 99, 65,221,169, 61, 99, 54,248, 36,109,199,140,181,150,124, 25,
 95,119, 19,123,138,160, 11,146,147,155,155, 70,239,210, 32,255,196,  3, 66, 98,
 57,238,235,154,184, 73, 91,206,108,233,110,223,158,156,207,200,  2,233,  1,225,
225,228,156,162,248,158,146,206, 75, 81,245,196, 12, 46, 86,134, 42,207,190,182,
 43, 63,229, 35, 36, 22,132,  9,131,175,222, 65,215,131, 23, 48, 11, 20, 69, 97,
194, 49,  8,157,219,  0,141, 11, 12, 24,151,160, 71, 34, 16, 67,185,176, 40,234,
210, 47,109, 26,160,119,169,  3, 47, 97, 36, 20, 24,212, 25, 30,177,180,129,224,
 27, 36,190,217,236, 71,251,  2,  2,130, 54,168,194,203,146, 33,134,102,132,100,
130, 36, 41, 72,134,  3,162, 32,  4,  2,105, 50,105, 98, 43, 15,  2,145, 52, 86,
 97,140,129,202, 16, 68, 16, 17,144, 18,136,  4, 18,136,136,  4, 18,137, 40, 40,
136,211,  1,145, 81, 85,182, 60,  8,200,220, 68, 10,206,179,100, 87,149,124,170,
144, 54,247, 67,198, 35,131, 65,210,245,125,232,206,250, 37,108,191, 78,206, 67,
 17,200, 17,174, 12,209,158, 25, 48,156, 93,163,193, 51,114, 27,116, 32,  3,252,
 60, 16, 45, 24, 56, 15, 41, 16, 18, 51, 99,159,  0, 16,210,202,133, 54,188,122,
206,104,143, 80,228,168, 53,112,232,122,211, 78,238,104,224,133,210,181,136,180,
239, 50,112, 63,242, 60, 17, 46,252,138,215, 45,139, 10,103,135, 64, 41,  0,218,
228,167, 41,225,178, 65, 53, 21,  9, 65, 90,198,197, 24,188,249,105,114,183, 47,
142,127,223,128,198,175, 28,233,234,142,244,136,198, 41,188, 40, 19, 58,113,209,
 19,176,163,129, 61, 63,114,200,200,158,172,236, 81, 36, 45,119,108,170, 33, 36,
224, 64,197,228, 51, 70,162,213, 63, 18,238, 32,242,223,130, 81,  1, 69, 31,192,
109,138, 76, 66,219,191,248,141, 97,184, 28,198, 84,187, 82,100,102,167,192, 83,
  5, 35, 90,158,227, 15, 49,  6,166, 48, 75,120, 11,126, 90, 39,140,167, 56,122,
136, 53,139,122, 90,170,  3,167,220,233,197,253, 69,231,234,  8,177,124,209, 21,
 84, 25, 12,251, 18,119,123,181,157,123,183,225, 29,137, 44, 69, 28,182,239, 69,
158, 91, 44,199,136,252,109, 36,230,234, 97,115,249,148,222,196, 49,180,190,156,
  6,211, 48, 65, 97,248,214, 76,242, 38,220, 31,108,215,175,175,106,182,187, 18,
 85, 54,  5, 68, 62, 17,189, 72, 87, 41, 26, 91,188,123, 17,208,200,229, 71,196,
208,168, 37,  1,203,223,195,195, 42, 65,235,128,171, 21, 61,171,152, 87, 19,121,
167,192, 45, 58, 12,125,108,170,108, 91,138,104,249,148,248,245,211,249, 60,130,
166,244, 18,241, 12,106,172,135, 93,  4, 77,132, 80, 96, 83,146, 29,198,230,191,
112, 33,151,102, 74,116,149,146,165,192,200,159,132, 56, 32,  3, 87, 56,245,206,
 11,202,198, 74,167,212, 80,213,139,250, 85,248,  4,197,192,126, 31,146,195, 51,
 94,124,153, 14,201, 39,  8,180, 29,146,129,215, 98,179,108,245,131,180,244,115,
169, 46,129,160,129, 82, 83,108,222,165,144, 38,  5,171, 51,138, 46,208,220, 44,
120,102,220, 11,150,196, 63,146, 34,208,102,232,125,251, 97,153, 17, 98,165, 66,
 24, 99, 46,183,252,196, 37,228,181, 71,123, 69,154,202,102,107,160, 19, 65,182,
 27,170,154,113,160, 89, 35, 92, 67,178, 18,232, 15,129,249,159,210, 12,  0, 88,
255, 59,147,137, 80, 86,231,126, 78, 57,249,248,185,101,246, 95, 83,161,138,153,
 15, 29, 51,188,222, 27,231, 89,254,156,133,199,102,243,143,100, 12,223,213,177,
 78,203,  4, 65, 32, 39,  2,193, 86,  9,154,121, 56, 10, 44,111,135, 56, 97,124,
 68,197,248,175,114,144,221, 21,110, 54, 25, 12,131, 54, 78,154,134,201, 79,179,
109,227, 58,  5, 80,186,160,136, 83,189,151,165,180,160,196, 67, 41,164,136,232,
139, 79, 16,181,  0, 33,175,154,213,158, 98, 27,171, 83,230,202,111,250,249,139,
130, 90, 76,102,165,  7, 85,255,238, 18, 28,173,197, 24,129, 51,158,135, 23, 16,
233,207, 78, 66,170,130,190,230,220, 48, 46,148,  8, 36, 76,117, 67, 88,125,178,
126,106, 65, 41,184,  0, 75, 19, 97,219,109, 57,114,184,222,173,  9, 96,  7,164,
 33, 71, 76, 76, 56,107,  5, 96,190,123, 11, 94, 33,125,219, 69,153, 10, 80, 12,
 62,184, 76,136,228,190, 69, 97, 13,211,214,192,130, 75,130,169, 42,166,219, 70,
 89,175, 49, 82,227,129,208,115,140,145,241,190, 79, 66,117, 92, 30,154,251,191,
116, 20,126, 62, 38, 20, 92,146, 33,135,131,179,209,143,220,150,255,  1,  0, 86,
204, 52, 27,172, 35,195, 98,118,203,  5, 84, 78,238, 84,230,138,113,176,229, 78,
179, 11,151,152, 24,161,212,  1,208, 41, 46,  3, 21,130, 58,173, 34,151,165,225,
 39, 83,232, 74, 10,219,203, 28,188,252,210, 12,159,170, 24, 69, 90,227, 85, 67,
 33, 70, 67,203,100,175,191, 99, 36, 25,246,166, 66,236,234,131,109,140,132,188,
243, 11,253, 56,148, 27, 84, 41,191,123, 68, 70,189,139,252,127, 46, 10, 83,250,
196,212,174, 39,166, 66, 48,146,159,180,133,201, 40, 67,199,140, 48, 14,177,  3,
 17,181,101,193, 97,143,117,166,200,140,  5, 28,147, 18,158,132, 57, 32, 54,160,
143, 98, 68,199, 14, 58, 76, 19,123,182,201, 93, 65,127, 21, 98,161,212, 83, 70,
184,205,115,180,240,102, 28, 44,102,184,182,175, 18,167,153,  3, 72,125,228, 66,
192,176, 17,238,240,107,135,161,223,115, 47,251, 59,145,136,117, 83,110,233, 49,
179, 68,188,123, 60, 29,130, 98, 84, 51, 96,238,210,167,122,120,114, 55,216, 66,
 53, 42, 12,196,158,185,229,134,255, 18,169,161, 31, 22,199,240,105, 79,235, 65,
 61, 79, 60, 13,119, 28, 42,184,  0, 66, 53, 71,163,111, 18,202,113, 63,145,153,
 54, 36, 45,213, 21, 85,213, 60, 39, 99, 12,210,243,225, 11,109, 38, 86, 16,201,
 53,212,134, 98,206, 37, 64, 68, 17,213,253,190,  1,106,135, 52, 98,248, 85,190,
 72,123,210,228,199, 79, 49, 45,137,126,108,202,227,116,248,128, 15,209,184,100,
  8,190,119,253, 28,  0, 59, 19, 25,176, 79,  1,  2,216,159,173,177,204, 61,210,
102,205,245, 47,167, 66,231,146, 96,122,227, 19,178, 68,  6,161,251,142,195,130,
226,114,143,149,116, 84,158, 84,253,102,136, 42,165,227,225,148,211,225, 71, 92,
152,127, 46, 50, 54,250,166, 34, 90, 72,190, 50, 23, 16, 56,133,174,233, 46, 31,
  8,
} ;

// ../CUDA/mxm/template/GB_cuda_jit_AxB_dot3_phase3_mp.cuh:
uint8_t GB_JITpackage_17 [2609] = {
 40,181, 47,253, 96,203, 33, 61, 81,  0,186, 97,240, 17, 45,176,204,140,115,154,
  0,166,  9,209,118,219, 49, 25, 65,190,163,236, 90,150, 13,232,152,169,  8,  2,
223,176,142, 48,146,106,179,131, 15,174,228,150,230, 78,233, 79,179,255, 99, 28,
 14,  1,  8,  1, 25,  1,182, 99,207, 99,178,167, 55,179,225,194,128,119,201,171,
211,251, 59,229,198,121,227, 15,238,255, 97,103,229,123, 37,119,208,109, 75, 43,
135, 28,147,206,202,214,214,205,223,201,149, 53,154,198,158,221,222, 56,197, 85,
 62,170,207,237,184,219,209, 95,158,222, 83,243, 28,234,235,195,216,236, 79,186,
109,244,130,216,148,167, 92, 96,100,226,187,101, 14,116,187, 94,185,221,158,110,
220,107,232,239,102,118,117,244,198,246,156,221, 91,190, 58,140, 86,238, 26,207,
202,157, 71,144,199,131,131,179, 75,114,239,145,202,173,233, 59, 25,171, 56,216,
 78,190,154,194,241, 96,114,129,169,245, 81, 97, 81,201,188,139,197,197,197,162,
250,171, 76, 42, 14, 42, 10, 60, 84, 16, 71,171, 71, 88,107,205,109,103,153,  7,
198,158,202,150, 47,183, 55,219,244,229,154,246, 78, 25,120,128, 60, 56, 16, 56,
 64, 30, 62, 93,210, 41,219, 30, 57,249,227, 29,148, 93,186,117,230, 84,132,109,
149, 28,134,111,119,152, 40,235,174,  7,183, 69,  2,108,101,198, 69,  2,151, 98,
 17,126, 94,188,205,137, 18,235,174,  8, 39, 26,248, 74,141,219,248, 54,188, 73,
131,170,  1,243, 40, 96,198,201, 58,241,134,134,200,209,208, 16,145,188, 11,215,
 78,122,193,103,161, 52, 28, 28,145,140, 78,165, 27, 20,163, 40,  9,107,234,121,
140,154,180,168,182,137, 49,250, 35,137,236,193, 91,223,136, 51,214,105,215,108,
  1, 17,194,215,113,179, 95,199,202,205,114,181,206,114,173, 44, 17,214,137, 91,
190, 26, 36,107,149,151, 59, 87,  7, 23,206,182,182,228, 94,169,199, 17,113,237,
111, 44,112, 64,195,202,160,113,115,187,110,252,246,135,169, 42, 53,121, 89,121,
 37,118, 65,154, 38, 55,190,151, 98, 91,101,238,148,157,148,109,229,171, 57,181,
 40,231,246, 86,186, 15,178,142,241,156,124,231,  6,165,108,247,137,154, 66, 19,
 20, 55,167, 66,243, 19, 55,210,236,237,146, 75,178,102,201,174,210,115,249, 64,
224, 18,251,  7, 91,183,218,231,241,193, 42,146, 91,191, 76,241,121, 88, 13,165,
164,197, 36, 87,  1,253,207, 99,235,  9,181,167, 38, 14,157,139,106, 22,214, 21,
242, 53,165, 38,173, 99,146,106,199,152,239,148, 85,118, 27, 89,111, 91,218,130,
131,166,212, 76,198, 94,233,  4,189, 54,207, 83,179,207,150,106,215, 65,218,149,
 26, 87,248, 66,115,222,114,182,101,183, 43,221,104,242,153,131, 55,149,183,  7,
 49, 59,199, 82, 93,211, 25,149,190,115,201, 57, 95, 64,153,184, 80, 44, 49, 67,
 97, 80, 53, 80,240,129, 92,225,145, 91,217, 90,  9, 81,224, 18, 18,175, 52, 50,
218,  2,113,141, 78, 39,146, 32, 70,191,188,249,116,  9,195, 15, 17, 17,145,224,
194,128,169,169,136,244, 36, 19,135,106,169, 58, 87,229,  6,131, 68,234,116,216,
 67,207, 81,170,125,182,180,124,186,198,100,145, 50,206, 89,166, 99,147,165,243,
164,113,118,212, 52, 57, 77, 82,148, 58, 98,146, 95, 34,100, 99,  4,107,125, 99,
 92, 96,144, 28,235,251, 73,229,151, 45,  4, 36,212,221,217,113, 91, 27, 13, 65,
  8, 27, 66,  8, 33,132, 16, 90,112,114,184,227, 91, 99, 30,  9,114,219,138,153,
149, 89,124,159, 79,247,244,200, 19,124,162,160,104, 80,113,137,228, 24,146,132,
 17, 95,198,201, 56,146, 95,236,153,242,193,137,130,185,188, 11,204, 37, 72,120,
230, 66,193, 96, 30,132, 28,199,113, 15, 66,248,222,171,204,129,178, 71, 89,198,
185, 44,232,238,230, 36, 28,150, 79,156,133,179,244,167,158, 80, 42, 38, 42,152,
216, 85, 85, 29, 66,  8,161,166, 33,254,143,132,227, 77,210, 37,255,188,199,120,
 45,215, 24, 23, 42, 46,148, 76,230, 93, 68, 76,  5,192, 53, 45, 32,138, 16, 77,
  1, 81, 52,129,154,236,148,112, 84,146,194, 37,137,136, 99,152,140, 87,111,244,
 74,  9,  5,133, 67, 46, 69, 93, 20, 29, 98,146, 98,156, 90, 58,165,  2, 45, 22,
 12, 12, 87, 72,222,118,119,117,138,170, 50, 13, 46,166, 79,181,241,230,112,125,
218, 24, 84,111,193,  4, 74, 10,197,103,151,100,139, 49,207, 73,183, 99, 84,188,
  8,197,242,160,162,192,162,146,126, 77,144,149, 30,143,203,149,179,243,165,158,
211,201, 70,106,154,139,  5,107,155,217,150, 59, 77,122, 28, 91,103, 53, 90,185,
214,222,123, 15, 66,  8, 29,120,147, 50,251,237,223,206,186,149, 32,209,132,  0,
246,118,155, 24,  0, 98, 64, 12,  8, 49,250,245,131,  7, 92,  4,249, 69,133, 66,
 65,188,176,156,103,107, 24,155,210,118,132,  8,233, 26,  8, 57,150, 67,242,208,
108, 25, 53,121,233,133, 56,196,246,135, 35,232,246, 37,135,240,190,164, 99,100,
 42,153, 10,202,164, 18, 57, 29, 75, 58,236, 72,233,143,114,121, 20, 21,101,130,
  1,161, 17, 51,108,236,  7, 49, 98, 92,101,102, 99,228,244,117,190, 29,183,209,
 11,114, 50, 56,  8, 33,228, 64,  8, 33,180, 32,132, 16, 66,  7,134,119,  6,167,
241,164,160,240,233, 83,220, 59, 69,157,122, 32,192,117,157,248, 58,167, 50,139,
116, 75,130,174,168, 18, 51,211, 33,166, 72,100, 36, 41, 72,161,208, 24,194, 41,
  4,  2, 97, 36,230, 89,136, 15,194,144, 52,139,131, 20,133, 44, 81,132, 40, 34,
 66, 35, 34, 34, 18, 68,146, 36,133,114,  3, 49,129,178,139, 17,241, 28,166, 60,
169, 30,157,217,234,105, 60,167, 70,144,222, 70, 40,195,188,234, 17,162,215, 71,
127, 69,120,  5,239,127, 58,195, 69, 37, 85, 83,125, 30, 47,149,226, 53,142,131,
 55,240,151,191, 80,176,249,202, 82, 56,236,241,244, 85,140, 77,137,243,225,128,
 90, 55,242, 80,101, 29,113, 79, 63,145,191,201, 86, 62, 17,112,139, 45,142,  0,
192, 45,154,189,184, 62,220, 68, 24,113, 85, 12, 70, 90, 85,136,213,226,101,208,
 73,215, 89,186,  3,184,219,210,252,114,110, 56,196, 17, 92,228,117, 76, 32, 53,
 65,196,  6,133,121, 55,220, 68,217,214, 29,135,176, 50,224,242, 25, 95,  0,139,
 83,217,144,189,193, 74, 28,146,227, 93, 79, 79,134,203, 78,205,102,169,212,124,
  8,249,216, 94, 53,206, 74,177, 38,191,134, 30,130,155,234, 10,120,165, 70, 55,
152,102, 99,139,108,162, 84, 11,209, 50,217,139,112, 68, 12,127,111,100, 12, 62,
236, 76, 68, 24, 71, 29, 50,153,118,135,149, 55, 30, 90, 63,231, 41, 45,122,122,
236,219,110, 68,208,112, 81,190,140,148,136,168,160,109,200,127, 92,105,128,107,
 87, 10, 58,239,154,150,220,189, 56, 83, 52, 57, 64,109,118,199,224,177, 92,171,
135,212,  1,124,  6,213, 80, 79, 35,246,  0,226,171,213, 66,199, 14,190,177, 82,
232,216,145,111, 34,  4,130,112,205,133,232,147, 69,  3, 82,202, 99, 23, 68,139,
 58, 28, 12,103,174,167, 95,244, 26,167,102,110,141,171,205, 31, 60,132,176,236,
 53, 44,165, 34, 76,233,133,245, 33,134,204,102, 52,176, 13, 51,152,143,233,  3,
162, 67,137,134,195,193,114, 28,114, 82,144,137, 42, 64,225, 81,232, 71,170, 89,
 97,139, 90,144,235,  4, 34,102,203,215, 73, 76,164, 58,246,205, 40,219, 98, 58,
  2,223, 68,249,245, 40, 86,153, 91,235,140, 80,159, 42,210, 16, 36, 40,180, 29,
211,  3,209,253, 31, 65, 14,198, 46,220,214, 48, 29,189,221,243,244, 15, 98,175,
172,  4, 25,134, 14, 27, 74,242, 75, 34, 32, 32,206, 48, 30,129, 62,230,249, 61,
 45,142,135,115, 73,218,197,158, 75,246,149,116,214,104,169,103,212,140,243, 75,
198,202, 33, 11,249,196,239,222,206, 74,114,145,161,179,250,112, 11,164,129,188,
218, 92,  6, 67, 68, 82,160,174,  7,246, 60,209, 77,151,251,101,205,159,234, 62,
 35,228,138,118,110, 38, 81, 89, 93,105, 95,207,134,151,149,161,  0, 49,118,136,
 87,149,189,212, 52, 91,  4, 16,190, 34,203, 68,216, 14, 42,224,188, 87, 24, 51,
104, 19, 21,230, 83,  2, 47, 11,106, 93,226, 25, 93, 19,  5, 78,196,113, 38,149,
122,154, 61, 33, 62,238, 76,154, 77, 86,161, 96, 35, 96,163,  1,  6, 27, 10,148,
 82,199, 66,221,140, 75,134, 35,175,227,148, 21, 68,  7, 57, 20, 77, 76,  0, 93,
198, 29,115, 37, 93, 23, 25,185,150,224,183, 93, 66,116,255, 35,194,113, 16, 41,
249,104,163,166, 46, 85,108,102,152,175,117, 56, 56,232, 37, 85, 77, 49, 10, 58,
202, 68,117,200,236,  2,132,254, 66, 13, 85,219,230,204, 17, 59, 39,107,224,147,
136,  7,106,162,251, 95,152,144,137,118,199,154,128,220,142,194,232, 86,235, 49,
101,217, 51,134,196,122, 96,157, 40,224,  8, 19, 18, 20,186,102,200, 30,  4, 78,
130,109, 70,132,217, 72, 13, 24,138,163,182,203,  1,223,112, 25,159,147, 30,224,
 93, 39,219,127,  1, 28,173, 53,211,227, 17,225, 57, 34,149, 69,136,253,194,201,
  9,213, 38,130, 69,186,231,209, 30, 55, 10, 77, 49,178,223,164, 86,175,  4,161,
142, 46, 34, 71,120,241, 53,151, 12,220, 68, 98, 14,112,107, 50, 42,178,204,200,
208,  5,182, 24, 33, 68,165, 77, 88,178,200, 94, 68,241,240,201, 72, 47,181,241,
 61,198,207, 63,211,138, 74, 64,123,140, 58,174, 79,165,131,230, 43,214,166,114,
130,201,  7,172,133,248, 16,  7,121,118, 20, 35,253, 26,228, 85,115, 27,  6,  6,
164,254,113,211,144,211, 33, 77,  6, 37,243,168,253, 98, 33,217,215,229,143, 43,
 83, 41,179,248, 31, 75,121,223,217,  0, 35, 29,108,243,160, 11, 32, 42, 11, 63,
 18,144, 44, 24, 19, 12,170, 56,128,108,  5,166, 44, 96,177,245,185, 37,213,196,
  7, 95,116,  1,138,208, 51, 80, 64,139, 54,165,152,253,109, 23,115, 42,164, 16,
113,  4,243, 68,248, 20,221, 99, 32, 84,107,154,  3,129, 58,176,252,121,157,204,
100, 40,144,176,239,  0,102,242,105, 78,226,  6,116,199,229, 17, 21,196,220,219,
  1,244,136,214,224,205,163, 71, 55,201,129,111,150,206,206,135, 57,124, 27, 38,
  6,179, 23,142, 43,204, 20,242,  3,119, 77, 60, 39, 82, 45,148,147, 54,175,  2,
 64,174, 99, 24, 37,236, 98,204, 24,138, 78, 50,172, 33, 63,146,  7,119, 70,175,
 93,224,208,137,250, 45,216,175,152,134,255, 72, 15,217, 30,196,116, 50,112,134,
186,206,116,105,116,132,234,106, 25,114, 10, 37,227,138,139,136,159,  1,157,176,
215,135,157,237,  0,151, 62,177,  6,199,226,185,126,234,128,104, 76, 71,  4, 84,
146, 52,  6,214, 75,175,  0, 17,152, 18, 37,141, 40, 52,136, 31,201,200, 23,229,
201,172, 97,  0,103, 77, 66,221, 13,222,112,180, 73, 62,228, 81,133,254, 15,233,
207,236, 78, 18, 15,149,232,208, 97,139,210,255,230, 60, 50,205, 33,253, 13,139,
 90, 84,179,  7,  1,  6,110,151,129, 38,229,184,  4,129, 12, 86,102, 36, 93, 13,
243,188,180, 47,157,196,228, 39,208,222, 29, 79, 16, 98, 98, 14,122, 35,102, 16,
111,128,241, 89,103,198,249, 42,234, 69,140, 83,113,161,222,104, 91,212, 23,122,
228,119,126,123,  5, 27,210,177,179,213, 91, 66,212,200, 12,182,210, 46,229, 66,
  3,  0,198, 60, 14,202,170, 81,245,234,196, 34, 12, 54,197,140,171,175,117,225,
 90, 88,  8, 79,110,210,192,217,240,210, 11,131,136,205, 91, 60, 49,145, 17, 76,
 71,139, 93,221,135, 23,146, 41, 84, 95,  4,105,221,149,243,121,181,182,248,  2,
 83, 32,132,130, 64,195,198,214,206,199,227,180, 85, 89,124,227,188,  3, 58,202,
187, 45, 94, 75,236,128,196, 72,118,225, 12,240, 78,196, 58,163,155, 12,130, 80,
 68,156, 61,234,205, 11,243, 20,141, 67, 91,127, 44, 32,228,117,118, 67,228,158,
187, 16, 37,142, 94,131,208,210,141, 48,190,158, 44,223,234,140, 42,181, 57, 77,
157,209, 65, 75, 48,148, 52, 12,248, 63,166, 48,140,227,166,188,173, 79,119,162,
 34,242, 93,210,209,122,240,205,  3,
} ;

// ../CUDA/mxm/template/GB_cuda_jit_AxB_dot3_phase3_mp_guts.cuh:
uint8_t GB_JITpackage_18 [1773] = {
 40,181, 47,253, 96,157, 36, 29, 55,  0,102,116,156, 40,176, 84, 85, 29, 84, 72,
 34,175, 99,252, 55,210,251,144, 54,159,217,107,111,193,224,155,118,198,134,177,
139, 16,169,149,224,152,246,  7,253,  7,203,252, 76, 23,140,  0,141,  0,141,  0,
153,253,116,170,139, 70,243,173,115,156,116,234, 98, 77,199,213, 82,124,231,151,
189,110,222,163, 28,214,174, 12, 93,187, 61, 99,249, 48, 93,231, 64,130, 75,186,
 36, 40, 88,110, 85, 21, 56, 73,183,142, 69,236,205,140, 47,183, 46, 82,177,231,
120,128,144, 43,237,238, 30, 93,172, 17,248, 67,206, 45,212, 61, 40,246,234, 28,
 11,213,158,  7,109,233,  2,  2,151, 28, 78, 17,138,227,181, 57,155, 33, 81,155,
 87,122,240,175,231, 43, 51, 62,117,173,206,136,121,210,165,207, 15,245,132,176,
111,246, 31, 42,179,205,255,110,238,107, 85, 30,123, 71,111, 62, 85,169, 92, 18,
243, 94,155,121,178, 43, 39,254,119,101,165,157,138, 34,146, 24, 70,112,202, 33,
 37, 93,194, 22, 42,237,162,104,179,159,153,252,120,199,147,147,121,130,148,137,
100,145,169,200, 68,  6,136, 15, 73,181, 79, 49, 62,225, 47, 48,248,215,249,212,
104,  8,117,248,135,206,201,250, 39,170,221, 63,180, 92,250,214, 23,238,218,208,
175,223,233,125, 86,251, 42, 61,249,243,218,238,185,202,208,103,  8,132,102,159,
 25,228,117, 54,235,238,126,247, 21,222,221,151,190,148,213, 15, 15, 64, 41,106,
114, 94, 79,142,152,122,242,127,206,100,157,195,113, 30, 56,138,  6, 58,234,192,
  5,249,214, 49, 47,103, 32,205, 94,239,217,106,247,100,233, 81,243,227,206,238,
151, 84, 38, 34,128, 73, 69,130,205,251,247, 55,221,138,162,252, 26,178,149,251,
188,242,248, 54,116,235,221,147,109,165,185,206,110,222,172, 82, 16,136, 38,169,
 31, 66,139,224,214, 85,125,251, 58,227,153, 37,149,137,228, 66, 81,215,245,203,
 52,193,138,170,206,  1,117,232,205,152,106,239,174,221,104,  5,125,118,166,133,
146,243,213, 78,111,106,149, 82,212,251,228,179,174, 93,107,179,209,116, 72,221,
 50,253,176,146, 62,153, 36, 11,213,125,142,245,235,250, 36,101, 27, 66, 61,174,
147,  5, 18,  9,237,238,166, 24,230, 77,173,130,  2, 14,159,  9,254, 81,143,224,
171, 81,119,119,143, 54,133, 87,135,221,144,224,135,109, 89,110, 93,250, 68,  3,
 38,162, 33,  3, 67,115, 17, 51, 48, 50, 24, 38, 74,100, 26,174,234,171,114, 32,
 99,208, 41, 54,251, 71, 86,218,221,153,207,101,211,147, 93,227,160,201,216,168,
 86, 41,237, 73,199, 64,108, 48, 21, 49, 67,227,112,145,161,120,136, 23, 21, 32,
 92,231,147, 83, 78,110,116,226,207,132,150,116,107, 58,135,134,226, 97,131,217,
208, 68,204, 70, 99,  1,145,137, 29, 16, 22,153, 77,166,  2,131, 17, 41, 22, 48,
155,184,201, 44,104, 80, 92, 68,140,141,  6,116, 99,180,170,250,107, 81,130, 10,
168, 34,252,142, 41, 18,145,145, 36,  5, 73, 99, 18, 49,132,161,120,172, 38,122,
151,  7,162,112, 32,142, 33, 17,196, 40,163, 16, 50,  6, 18, 98,  4, 34, 34, 36,
 34,129,  4, 19, 36,104,210,100, 56, 88, 33,  5,243, 45,141,216,111, 52,194,172,
 78, 86, 82,241, 19,  4,156,121, 63,196,184,184, 98, 23, 79,163,166,199,243, 45,
 44, 55, 55, 96, 24, 43, 42, 30, 13, 96,158,142, 72,220, 38,173,212, 45,238,160,
103,239,151, 50,244,186, 68, 41,236, 86, 70,168,114, 45,149,208, 14, 40,  8,222,
156,244,162, 79, 13,126,  6,103,212, 73,213, 99,237,140, 36,176,155,155, 15,123,
216,216, 74,216,241,241, 87,112, 76,  9, 80,  4,225,149,176,144,184,236, 33,176,
 29, 65,166,164, 61, 51,168, 10,240,195, 67, 49,210, 86,212,200, 70, 19, 70,147,
180,174,109, 83,160, 98,187, 26,179, 99,234,145,  4,100,181,131, 53, 29, 61,109,
156,150, 43,143, 73,121, 90,236, 38, 59, 20, 47,201,149,198,212,109, 54, 74, 25,
  9,212,243,164, 20,224, 36, 84, 76,123,242, 66,203,245, 43, 76,183, 14,239, 74,
103, 86,147,204,138,104,146,179, 92,129, 70, 26,186,150, 76,157, 14, 71,115, 84,
 34,196,147,224,250,245,231,136,210,116,180, 15, 20, 53,169, 98,189,238,198,  0,
180, 61,112,251,150,185,113,184,205, 30,204, 13, 38,114,176,150,107, 38,237,112,
155,111, 93,167, 35,210,222,196,121,245,189, 19,226,151,186,169, 38, 80, 57,219,
 85, 67,144,252,247,185,173,245,167, 99,115, 69,  2,169,144, 84, 23, 81,177,186,
186, 33,113,230,210,171,197, 55,254, 61, 31,128,163, 52, 82,185, 22,232, 66,197,
 84, 59,199, 32,189,192,162,128,152, 38, 81,210,236,206,124, 24,162, 64, 65,195,
 61,106, 64,254, 87,126, 32,127, 42,162,199,178,  2, 33,211,150,247,128, 67, 75,
199, 53,116, 28,192, 77, 56, 88,221,244, 27,  8,  6,176, 88, 98,215,153,  5,118,
 54,131,  6,233, 18,137,196,151, 81,  5,175,161,160, 69,170,146,  5,  9,117, 62,
 12,252,244,  5,152, 40, 24,108, 49,219, 72,192,110,103, 22, 96,  4,180,239,146,
 34,  4, 85, 70, 57,158,  6, 18, 93,  0,102,137,230, 33, 55, 24, 71, 18,248,253,
215, 73, 91,186, 73,114, 92, 73,153,103,123, 17,149, 18, 73, 14,230, 86,168, 66,
 59, 87,206,195,162,216, 73,123, 92,223, 68,130,231,174,145,255,148,106, 32,119,
209,154,106,252,141, 49,169, 53, 53,158,149, 98,107,140,108,103,112,179,229,149,
 99,244,253,  7,159,214,101, 23,121,  9,104, 48,217, 49, 52,153, 95,219,175,  5,
226, 17,121,244,156, 50,187, 30,208,123,184,248,254,101,220,181, 22,238,  7,126,
 46, 98,  2,128, 67,133, 49,169, 48, 13, 95,213,224,136, 56,137,207,  0, 28,214,
208, 68,253, 33,142,198,135,206,124,138,200,201, 27,213, 22,  9,248, 72, 19,193,
 84, 71, 72,  8,125, 21, 58, 14, 35,176,  8, 30,219,162,198,116, 73,184,104,219,
221,231,238,213,102,212, 92,186,125,146,114,115, 54, 50,217,148,192,158,216,147,
 90, 17,188,178,114,235,153,105,175,161, 32,212, 37,177,186, 75,137, 85,159,101,
205,169, 84,140,236, 65, 49,165,208,171, 77,127, 23, 30,165,248,132,150,113,171,
  4,139,175, 81, 59,213, 67, 37, 35,  8,153,181,  5,244, 19, 64,103,135,148, 84,
 44, 39,118, 47,111, 59, 44, 26, 54,246,109, 40,235, 31,238,219, 97, 97, 57,253,
189,253,  5, 69, 75,225,184,122, 64,140,129, 79,180, 58,205,163,202,128,194,  3,
211, 62, 63, 60,155,213,128, 70,128,208,  1,226,104, 21,193, 98,187,205, 10,229,
208, 10,147, 12,102,255,184,195,215, 19, 90,217,109,108,  5,111, 41, 51, 68, 58,
 39,174, 80,217,195,112, 90,166, 17, 65, 71,  5, 95,242, 30, 65,221, 43,127, 89,
183,252,230,216,114,237, 10,254, 48,159, 15, 34,100,239,142,141,170,134,132,161,
249,117,214, 48, 36,196,143,202, 49, 83, 84,241, 90, 46,  8,118,223,101,218,231,
 97, 21,129,  8, 56,  5,122,206,213,163,138,  9,104,140, 36,233,228, 64,203, 17,
193,113, 97,174,224,128,119,228, 54,243,244,210, 18,181, 73,193,120, 56, 57,213,
 46, 92,245, 15,221, 15, 18, 50,104, 69,100,211,220, 90,129, 59, 99,169, 36,199,
117,195,162,189,196,233,207,147,148,114,130,129,234, 56,136,178, 59,212,229, 16,
168,153,231,  2,191, 98, 40, 40, 80,158, 85, 61, 20, 28, 71,160,248, 44,250, 99,
190,244,118,168,236, 53,209,252,  1, 38,233,205,151,172, 56, 65,108, 64,182, 63,
 90, 76,190, 78, 37,235,143,243, 35, 20, 51,195,  2,227, 97,170, 16,181,224,217,
  1, 60,183,142,219, 15, 33,110, 62,111,225,249, 50,225,203,149, 17,224, 91,152,
110,177,105,109,142, 18,245, 79,167, 11,193,203,  5, 44,237, 35, 32,211,246, 69,
 88,108, 39,148,231,222,  8,230,  6,254, 44,227,133,103,152,246,114,225, 43, 53,
 20,217,200,212,217,214,195,107,238,130,147,240,185,105,133,202,212,217, 91, 64,
157, 59,168, 67,123,232,128,199, 11,232,138,107, 25, 59,211, 67, 84,204,118,170,
 86, 67, 41,  7,107, 32,180, 11,233,229, 13,191,229,249, 22, 22,104,208, 56,107,
255, 72, 34,180,100, 66,200,132,150,199, 50,111,198,
} ;

// ../CUDA/mxm/template/GB_cuda_jit_AxB_dot3_phase3_spdn.cuh:
uint8_t GB_JITpackage_19 [2562] = {
 40,181, 47,253, 96,208, 42,197, 79,  0,138, 92, 12, 17, 45,160,142, 25,231,154,
176,131,  4,193, 88,109,155, 12, 33,111, 40,248, 83, 63, 76, 66,192,157, 93,213,
 45,250,191,183, 92,  6,  5,240,151,107,226,186,130,215,225,117,192, 41, 60, 85,
  3,  1,255,  0,  4,  1,175, 17,118,156, 59, 46,225,254, 37, 52, 78,174, 21,110,
247,168, 77,229,228,143, 72,148,113,114,  7, 20,138,175,145, 39,123, 60,125, 29,
171,221,113,138, 39,148, 84,163, 26,218,106, 72, 62,194,203,122, 42,158, 63,218,
 26,241, 21,251, 81,130, 64,210,218, 43,194, 91, 48, 52, 56,207,157,242,230, 81,
123, 86,  8, 58,189,236,168,247,200, 87,142,216, 51,210, 32,166,103,172,158,178,
 21,186,228,220,174,113,156,156, 29,  2, 33,145,136, 48,102,193,205,125, 50,185,
 61, 93, 35, 95,151,  8,211,200, 86, 91, 68, 34, 84, 48, 54,115, 74, 50, 23, 23,
142,211, 92, 96,104, 46,170,187, 75,229,  2, 33, 83, 64, 98,122,108,178,250,132,
181,246,156, 54,198,145, 92, 44,154, 76, 89,115, 90, 49,142,214, 92,211,220, 41,
  3, 18, 16, 18, 17,  4, 17, 16, 18,159, 44,233, 20,109, 17,172, 92,226,238,129,
 85,  9,106,206,169,  9,211,  9,183, 13,215, 14,109, 32, 88,200,146,196,107,163,
143,  0, 83,136,109,143, 64,149,215,219,145,123,181, 63, 15, 94, 33,235,109,197,
  3, 87,168,109, 32,174, 15,174,146, 81, 61,108,156,197, 98, 27,156, 21,127,120,
128, 68, 30, 30,  2,187,187,157,221,221,221,221,221, 78,167,190,  4,148, 71,214,
 68,144,169,182,109,219,230,186,177, 15,246,193,124,194, 52,166, 63,117,197,146,
169,184,108, 94, 87, 85,181,187,187, 19,255,136, 34,226, 38,233,148,143,220,223,
171,148,231,123, 13, 25,141,133,195,113, 24,144, 24,192, 67,139, 20, 90,159,  4,
248,148,115,242,228,156,244,127,154, 44, 44, 50, 24, 44,134,195,112, 46,187,135,
 76, 56,  3,195, 39, 77,131, 91,176,112,203, 70,227, 48, 54,111,115,145, 36,  9,
192, 61, 45,224,243,138, 80,  6,117,141, 64, 32, 21, 32, 19,  4,214,134, 74,163,
180,118, 93,104,139,237, 50,138,169, 90,136,242,172, 48,111,103,  5,133,136,200,
100,227,217,148, 29,242,162, 42,103, 86,104, 27,174,200,245, 83,122, 78,103,195,
237, 83, 86,139, 69,167,234,132,149,190,190,  2,  7,106,236,255,135, 72, 87, 75,
209,223,211, 96, 71,106, 28,239,189,145,132, 82,144, 10,232,143, 36,160,174, 72,
122,170, 18,113,245,220, 42,175, 79, 31,170,165,234,124,150,245,153, 37,181,206,
  5,121,242, 60,211, 16,139, 36,145, 69,205, 17,123, 27,  6,184, 83, 94, 93,214,
149,203,251,100, 29,233,155, 65,233,206,162,113, 22,149,165,194, 88, 61, 71,108,
 26, 58,229,159,206,238,238,103,119,119, 63,187,187,219,217,221,221,237, 55, 80,
 46,190,152,227,246,137,166,133, 60, 27,  4,213,238,156,246, 93,132, 67,111,156,
194,192,112,106,212,167, 54,119,138,162, 36,  8,108,161,236, 81, 46, 59,133, 97,
164, 99, 30,246,207,228,205,  3,195, 84,247,244,198,148,207, 62,153, 10,199,242,
160,202, 96, 48,130, 56,195,164, 78,166, 20, 78,188,192, 41, 40,170,108,227,141,
153, 56,133, 44,155, 44,160,252,234,135,121,101,142, 79, 20,135,  9,  5, 83, 83,
 19,201, 81, 38,111,223, 38,236,152, 24, 93, 23,  7,138,148,101, 44,146,223,164,
212, 30, 27, 98, 78,225, 40, 53, 13, 62, 66,233,188,216,239, 35, 90, 24,142,198,
178,217,184,143,  8,146,190,177,112, 16, 50,211, 36, 61, 41,202,174, 93, 39,220,
222,117,138, 15,250, 20,176,214,245, 61,136,143, 80,141, 33,238, 14, 72,126,236,
110,239,238,238,238,238, 20,241,200, 65,125,137, 36,  8, 90,187,243, 48, 10,177,
231, 70,163,238,233,147, 47,120,230, 20,202, 53, 38,141,231,176, 15,246,137, 46,
 16,200,  5,106,162,145, 34, 82, 73, 12,210, 41, 20,252,186,224,179, 26, 36, 43,
164,184,245,  1,217, 66,144, 79, 76, 18,125,175,165, 91, 46,139,185,112,112,176,
 62,104,119, 87,167,168,138,147,129, 49,141, 42,  8, 16,131,206,181,103,199, 79,
 73, 31,239,209,171,101,148,160,107,100,220,196,130,137,112, 97,112,200,197,230,
242,  0, 76,151,110, 69, 15, 42,221, 35, 66,  9,107, 13,209,228,172, 81, 90, 60,
 25, 59, 87, 41,186,172,112, 64,205,163,185,160,160,165, 29, 94,214, 83, 14,105,
 80,244,200,228,237,160, 16,229,249,160,178, 52,168, 56,155, 11,140,199,217, 92,
 34, 88,158,131, 75,  5, 95,251, 60,161,102,177,  8,210,221,205, 62, 89,127, 54,
163,186,157,115,110, 55,233,150, 10,141,  5, 99, 49, 54, 81,216,120,199, 73, 23,
 46,104, 48, 54,104,114, 61,197,211,207, 44, 92,230,130,209, 88, 56,143,115, 81,
249, 80,210, 43, 21,199,177,200,192, 52,236,158,218,159,202, 28, 70, 25,188,116,
199,177, 84,100, 13,159,154,202, 36,231,145, 29,114,190,142, 56,238, 21,124,115,
248,110, 28,154,245,225, 18,173,180, 71,252, 60,234,213,167, 92,194,219,146,174,
193,185,112, 50,150,130,168,168, 34, 51,145, 41, 67, 67, 51, 34,  5, 73, 82,200,
112,226, 33,132,193, 88, 36,198,129, 74, 59,194,120, 44, 10,100, 12,201, 56, 67,
  8, 35,132, 32,101,136,136,136,136,136,  4, 34, 34, 82,144,182, 13, 58, 48, 55,
131, 65,  2, 48,119,227,209,244,254, 88,227,160,166,179,238,224,244,120,180,171,
 13,240, 95,127,158,106, 51, 22,198, 51,176, 48,255, 29,165,150, 65,158, 77,251,
239,  9, 38,214, 65, 10,128, 87,121, 57,244,229,101,111, 15, 65,110,141, 29, 13,
 16,241,167, 83,114,132,172, 12,143,208, 93, 23, 42, 13, 46,254, 98, 41,210,142,
 10,192,103,148,220, 21, 59,202,146,199, 17,104, 55,132, 89, 56,201,138, 27, 50,
 65,234,166,175,199, 30,130, 70,237, 83,186,156,231, 71,155,209, 85, 26,220,200,
 48,137, 89,136, 40,143,204,240,170,167, 73,100,239, 69, 71, 78, 16, 43, 66,202,
 27,  2, 32,185, 36,220,157, 33,182, 76,234,134, 62,145,228, 96,116, 16,180,103,
143,231, 56,131,151, 97, 99,147,153,  0, 95,248, 94, 54, 12,  1,114,105,162, 84,
214,145, 49,212, 95, 94, 55,104,195,190,  8, 49,151, 81,111, 64,156,230,208,177,
224, 45,144, 62,  8, 26,117, 86,230,161, 70,237,210,137,190,132,229,172,219,140,
182,250, 29,252,155, 69,187,178, 44, 14, 44,126,230,120,  4, 37,147,113,248,  6,
170, 96,149,130,172, 35,181,190, 64,142,195, 65,254,206,239,187,169,215,198,176,
 97,  2,123,153,204, 64,234, 76,218,252, 46, 41,208,156,189,137,224,154,153,205,
238, 71,203, 95,  7,129,211, 26,206, 83,123,243,117, 55,152,192,233,207, 14, 59,
 90,111,253, 46,125,125,211,117,124,118,255, 71,122, 77,239, 94, 24,157, 73,236,
 59,112,205, 89,238,  7,102,115,127,194,106,110,117,213,138,100, 27,209, 42, 59,
237,214, 44, 22,254,169,206,249,222,115,252,209, 98,246,202,168,232, 22,178,164,
 51,246,184,179,249,154,126,178,249, 38,230,237,250, 10,152,197,190,123, 79, 40,
196,167,110,116, 40,137, 89,212,142,243,199, 61,220,  9,142, 96,228, 56,215,208,
107, 10,193,100,100,176, 40,115,175,229,185,206,122,210,217,125,150,235,103,219,
158,253, 81,103,136,175, 87,147,164,128,150, 49,160, 65, 30, 33,123, 31,158, 66,
170,132,212, 20,149, 69,161, 74,111,178,  8,  0, 30, 94,197,106, 52,139,220, 97,
220,205, 97, 19,128,103, 10,228,193,250,221, 24,171,252,246,  3,110,116,165,186,
229, 35,103, 97,220,214, 90, 34, 90, 49, 28,223, 98, 18, 30,184, 30,172,247,  6,
199, 13,197,229, 69, 53,222,158,161, 46,161, 32, 28,201,179,117, 46,150,194, 43,
 38,  2,158, 31, 65,252, 95,184,  1,136,152,150,233,179, 99,208,150,140,250,  9,
170,108,111,166, 80,171,231, 16,243,132,243,230,189, 44, 13,193, 50,190, 50, 33,
 86,242,209,165,118,  3,208,176, 33,115, 54, 73, 72,235, 26,255,145,212, 24,235,
153,132,  6,209, 50,210, 58,179,144,136, 18, 11,214,203, 72, 87, 25,137, 19,116,
152, 83,214, 34,104,199, 83,208,193,234,203,206,181,247, 57,105, 47,188, 45, 89,
111,130,139,  8,225,186, 12, 70,135, 44,134, 58,204,132,110, 81, 87,  2, 20,223,
 42,188,237,  5, 94, 68, 59,115,250, 13, 41,243, 30,120,115,114,239,  8, 70,238,
129, 81,228,151, 29, 91,120,122, 70,247, 48,201,223, 77,124, 27, 15,219,209,164,
204,124,156, 52, 47,249,  9, 26,185, 83,133,  2,233, 45,240,174, 15, 50,112,114,
251,147,247,134,251, 60,196,218, 80,228, 84,130, 39, 68, 16, 99,207, 82, 41,199,
253, 87,201,203,140,209,139, 93,231, 65,  2, 29,  3,187,252,105,240,228,120, 13,
213, 73,139,161, 85, 78,124, 93, 86, 36, 20, 96, 38,212,221, 64,121,100, 21, 84,
 56,  0,183, 23,106, 45, 11,183,233,184, 86, 49,123,180, 77, 31,177,135, 91, 63,
201,183, 14,159,193, 39,177,151,188,214, 30,146,114, 24, 91,109,217,121, 34,179,
 48,168, 65, 33, 57,217,172,109, 79, 13,253, 95, 17,206,183, 55, 93, 34,144,232,
 54,151,222, 86, 12,202,202, 60, 90,197,  1,241,101,238,231,114, 67, 34,195, 25,
120, 57,246, 66,212, 27,210,245,166,141, 62,176, 49,151,249, 17, 81, 58, 28,  1,
149,115, 74, 56,175, 49,138,132, 82, 59, 17, 77,167,238,214,217,205,108, 87, 65,
 74, 84,108,194,124,129,136,250, 43, 65,231,  5,238,114,235,217, 63,248, 60,144,
247,191, 11, 80,206,210,224,140,110,211, 68, 47,  0,138, 30,179, 77, 56, 12,240,
 24,193,  7,146, 16,  3,248, 47,  8,101, 57, 18, 60,244, 27, 53, 64,255,204,205,
  5,155,116, 24,148,130, 17, 22,105,133,129,187,204, 82, 63, 48,143,103, 94,252,
117, 45,122, 48,166, 63,156,126,192,253,215,231, 45,129, 92, 24, 92,215,146,161,
163,139,245, 50, 30,243, 66,  4,209, 29, 42,114, 28,119,169,152,120, 14,241,176,
 44, 53,110, 55,164,150, 14,108,185,156, 25, 99,133,161,219,128,212,165,100, 18,
 53,249,205,132,191,119,149,179,139, 46,209, 76,146, 94,175,245,250, 73,182, 87,
159, 38,106,  1, 70, 74,108,  2,110, 34,249,110,  8,104,164,228,199,163, 16,193,
244,236,120,135,207,127,125,  6, 79, 15, 21, 80,191,140,  9,192,147, 74,229, 40,
200,187,255,  0,100,117, 87,232,216,183,105,221,193,249,141, 60,227,244, 65,182,
105, 80,128, 16, 46,185,188, 40,179,  5,169, 33, 86,144, 26,205, 36, 46, 40,163,
181,220,  6, 62, 80,137, 13,220, 97,116,214,160,225, 68, 18,156,108,167,201, 58,
202, 63,213,  0,189,138,107,224,197, 18, 44, 25, 55, 49,148, 72, 40, 25,113,221,
  2,255,189, 55,129,212,104,246,125,226,132, 97,208, 48, 13,  8,152,154,196,113,
 53, 88,183, 38,224,106,219,238,117,231,168,255,133,251, 86,109, 17,202, 62, 30,
209,208,  2,224, 70, 94, 72,225,235,100, 72,106,149,170,166,  5,207, 68,199,184,
159,  2,148,254,192, 37, 18,149, 36, 60,  3,110,135,196,146,176, 15, 65, 37,203,
 37,  8, 98,129, 90,175,208, 15,154, 95, 45, 67,189,155,210,244,175, 86,  9,106,
124,187, 10,116,103,229,246, 59,204, 95,145,178, 50,224, 14, 98,255,140,197, 71,
109,193, 77,103,113, 64,137,241, 97,  5,176, 69, 33,117, 15, 31,203, 43,127,208,
228, 39,243,188, 91, 38, 25,112,160,  2,121, 20, 41,219, 13, 74,130,136,196, 58,
234,  2, 13, 80,154,  6, 27, 99,124, 20,228, 15, 17, 57,245,112, 55,123,170,150,
106,127,116,254, 39,  6, 67,203,103, 50,132,168, 71,157,248,216,234, 94, 40, 85,
234, 49, 60,150,167,154,164, 90, 83, 29,218,164,186, 97,116, 24, 70, 77,165, 60,
239,194, 71, 52,152,  5,125, 19, 32,218, 16,113, 37,186, 77,224, 20,246,166,142,
 27, 40,
} ;

// ../CUDA/mxm/template/GB_cuda_jit_AxB_dot3_phase3_vsdn.cuh:
uint8_t GB_JITpackage_20 [2344] = {
 40,181, 47,253, 96,210, 39,245, 72,  0, 26, 90,188, 16, 46,160, 78, 89,231,170,
243, 51,  4,  1, 44,218, 38,200,  8, 76,240,247,103,101,180, 10, 26,218,195, 48,
115, 50,  8,209, 78, 60, 48,253, 27, 91,156,226, 10, 94,135,215, 65,235,240, 84,
  1,  4,  1,252,  0,251,  0,173,157,227,218,194,103,214,118,210,211, 58, 67, 17,
143,122,243, 22,168,183,125, 66,200, 48, 73, 24,248,100,  0,226,147,196,133,126,
200,126,214,169, 89,248, 20,178, 18,  3,  5, 34, 78,189,155,164,141,  9, 20,217,
218,242,139, 84,122,177,249,121,247,201,109,218,122,244,235,115,211,171,115,187,
153,156, 85,187,175,220, 97, 90,137, 61,123,196,126,234, 42,229, 92,195,174,220,
220,235,219,139,121, 50, 90,191,255, 15,199,131, 67, 68,100,106,152,252,224, 39,
117, 54,167,175, 55, 51, 75,100, 90,111, 98,109, 17,137, 64,193,104,106,117,184,
 92, 88, 46,152,185,192,100, 46,170, 67, 11,197,242,224, 34, 17, 81, 55, 62, 90,
125, 50,185,230,220,182,118, 57,100,243, 83,167,157,153,219,171, 85,232,204, 57,
 14,126, 42, 16,241, 16, 17, 57,  0,241, 16,113,  9,139, 62,217,254, 72,202, 29,
224, 55,180, 75,187,190, 62, 77,166,173,242,211,204,219, 30,141, 67,243, 96, 14,
 94,102, 63,145,192,180, 82,251, 34,129, 75,179,200, 32, 24,111,119,162,204, 60,
 88,228, 10,201,188,146,251,186,121, 37,144,130, 81, 73, 52,208,130,181, 79,214,
138, 75, 36,142,136, 68, 18,159, 92,193, 47,167,168, 75,136,162, 75, 18, 34,212,
 58, 90,  7,155, 31, 15, 50, 51,111,152,153,153,153,153, 55,155, 27, 17, 80,247,
 38,247,145,211,114,223,247,125, 16, 66,173,163,117,172, 75, 86, 91,125,169, 41,
149, 75,133, 69, 19,187,170,170,138,153,153, 19,252, 32,138,  8,148,162, 83,  7,
193,199,120,177,174,215,206, 26,227,227,215, 37, 83,185, 46,136,113,112, 58,243,
  2,108,112, 30,189,157,  4,120,165,181, 78,  9, 66,230,255,146,100, 97,129,177,
  0,  3,173,203,194, 76,225, 13, 13,151, 50, 21,140,  4,  6,199,128,225, 21, 77,
  6, 98, 52, 81, 99,137, 48,138, 34,  0,231,180,128, 87, 26,177,179,235, 27,113,
 92,112, 72, 14,121, 31, 23, 99,104,125,170,172,200,181, 66,  3, 34, 50,201,248,
 86,169,  5,154,253,211,157, 27,230,225, 71,230,205,233, 86,121,237,111,148, 48,
112,189,254,127,199,163,172,233,231, 49,114,114, 67,185, 10, 49, 70,199, 21, 92,
233, 53,243,  6,247,117,119,122, 33,220,172,180, 44, 80,215, 43,187, 95,206, 83,
 61, 50,241,202, 49,177,117,222,217,201, 42, 49, 14,211,195,201,143,252, 13,135,
149, 12,180,168, 42,148,199,  0,234,157, 13, 51,115, 39,227, 20, 51,115,135,153,
153, 55,204,204,204, 29,238, 63,168,108,102,115,122,223, 39, 28,231,225,188,210,
127,178,187,189,185,237, 67,  8, 72,103, 80,156,110,104,248, 52,129,250,211,  7,
 63, 77, 83,  4,129,207,179, 81,202,197,  9,246, 52,137,224,246, 73,179,162, 91,
 81,123,167,206,111, 67,251,172,242,214, 51, 79,246, 53,182,140,107, 86,165,223,
 58, 23,138,230, 65,188, 42, 14, 42, 12,138,250,  2,208,195, 27, 38,183, 78,107,
 37,196,204, 40,230,205, 87,231,208, 39,144, 56,  5, 69,181, 93, 35,227,109, 37,
208,200,152, 40,160,158,117,116, 72,157,169,163,234, 27,245,122,243,206, 10,207,
186, 86, 56,  5,153,232,154,242,216, 48,202,109, 14, 57,200,  1,148, 89, 32,212,
183, 45, 58, 53, 61,202,113,242,145, 83,155,232,117, 12,121,152,117,101, 42, 26,
 13, 12,121, 93,116,141,  5,124,112,185,158,135, 98,159,189,233,104,232,127,130,
 63,132, 60,204,204,204,204,204,204, 44, 65, 60,242,174,179, 79,244,112,234,246,
246, 38,106, 86,106, 17,130, 64,221, 82, 14, 71,134,137, 34, 82, 69, 13,143, 40,
 38,158,101, 50, 98,221,209, 43,169,189,125, 59,175,228, 60,157,  7,195,228, 47,
 52, 52, 80, 83,244,216,121,176,144, 20, 61,218,214,110,228,209,190,125,171,252,
 98, 70,253, 20, 33, 27, 39, 38,215, 55,198,201,212,238, 63,207, 59,143,212,209,
 43, 22,182, 46, 32,144,238,234,211, 84, 93, 24, 24,  9, 84,221,225,160,170, 48,
168, 46,205,  5, 38, 94, 26, 75,132, 74,108, 96,169, 46,127,251,179, 74, 14,155,
 31,105,153,121,235,108,221,225,109,234,134, 16, 66,  8, 33,228,232,149,138, 76,
197,194,166,134, 73, 26, 25,223,192, 40, 67,  6, 78,122,221,213,121, 79,113,250,
155,156,213,  2, 94, 44, 86,166,114,197,235,130,242,232, 76,209, 41, 20,120, 89,
 96, 88,252,137,255,105,131,128,224,167,222,228,163,195,171, 82,177, 61,190, 65,
 56,244,160,153,121,125, 11,180,254,130,166,167,193, 16,200,196, 55, 61,245, 74,
 30, 78, 17,161,206, 33,207,187,240,200,122,113,163,155,150,147, 28,219,160, 25,
 57, 74, 55, 27,183, 79,125,194, 27,139, 46,225,178, 92,151, 10,197, 18, 59,219,
 38, 58,111, 50, 10,130, 82,168,178, 90, 33, 99,  6,209,200,200, 72,146, 36,133,
225, 50, 42,  6,226, 88, 30,134, 57, 92, 15,162, 96, 48,145,177, 12,132,192, 16,
 65,132, 17, 98,148, 33, 34, 34, 34, 34, 34, 34, 34, 82, 18,235, 82,143, 84,  2,
 68,115,233, 90,  1,221, 91, 82, 95, 61,151, 57,115, 12,165,209, 28, 69, 75, 40,
 36,235, 18,181, 99,228, 39,215,249, 67,230,198, 12, 53,100,  9, 47,232,  1, 62,
200,174,151,154,253, 97,  5, 78,134,116, 14,236,233, 27,101, 54, 69,107,183,118,
156,166, 24, 32, 33,184,151,166,181,250,193,150,231,114, 18,126,  0, 28, 69,184,
 78,209,121, 52, 42,  2,181,215,250,161,184,106,243,182,221,245, 41, 55,179, 21,
 77,100,183,192,183,210, 90, 34, 81, 93, 26,146, 95,  8,155, 28, 95, 28,188,253,
 57,222, 79,212, 33,116,159,130, 36, 35,202,157, 15,175,235, 19, 20,145,104,102,
109,188,204,150,148,143, 23, 78,244, 48,102,250,175,216,195,129,245,144,176, 36,
232,147,131,207,188, 54,186,197,215, 21,238,209, 11,188,124, 98,148, 66,148, 25,
187,146, 14, 39,201,195,253,214,115,231,232, 89,160, 52,229,232,  7,107,255,128,
164, 56,179,217,221, 29,244, 44, 73,218,246, 37,213, 67,184,124, 42,109, 53,225,
189,171,176, 36, 37,116,168,213, 84, 23,248, 46, 90,132,136, 12,139,182,140,202,
 45,161, 31,255,101,185,243,191, 90, 35,215,198,198, 19,249,139, 87, 52, 84,  6,
 92,238,152, 96,134, 23,110, 87, 52,255, 82, 48, 82, 90,202,110,132,204,220,184,
200,113,233,250,205, 19,170,234,147,120, 18, 40,182,153,164,200,216, 62, 35,  9,
215,153, 64, 92,119,223,249,150,104,168,179,217,164,133, 92,151,104,194,202,124,
189,140,245,182,151,194,198, 35, 39, 18,211, 29,121,215,221,192,142, 33,208, 26,
243,204,230,132,213,152,  0, 38,142, 22, 73,213,201,131,107,166, 26, 42, 34,255,
 82, 37,121, 42,105,144, 53, 99,117,153,209, 76, 84,  2, 98,244,114,141,248,152,
 92,155,203, 27, 21,  1, 19,226,114, 30,170,228,254,  3,224,217, 83,129, 22,157,
214,203,104, 83,187,242, 73, 34, 31,249,210,185,133, 78,136, 27,244,  6,186,182,
 96,128,138,205, 17,127,179,100,135,125,251,186,145,179,  1,170,226,157, 73,130,
107, 75,221,172,226, 59, 89,222,232,  0, 18,210, 98, 16,203,135,231,194,132,188,
 70,206,  7,199, 82, 40,145, 51,229,135,142,235, 27,216,  7, 79,113, 49,219,228,
186,221,165,156,115, 66, 45,209,137, 24,186,160,  0,196,146, 69, 40, 81,156,141,
 77,213, 68, 64, 28,152, 28, 83,172,113,251,187, 26,103,243,210,228, 37, 13,140,
202, 13,160,119,176,146,  2, 43,193,175,218,213,149, 72, 43, 73,  2, 28,186,215,
105, 15,225, 92,103,153, 85, 15,100, 51, 38, 35,137, 77,205, 88,122,251, 98, 47,
168,132,233,176, 74, 25, 83, 98, 91, 25,151, 15,236,134, 75,150,199, 46,169,236,
191,236, 44,167,109,143, 78, 32,230, 95,129,  1,213,162, 54,105, 51,250,171,197,
155,148,209, 47, 50,214, 93, 39,189,134,  5,158,176, 21,212,  3,191,229, 75,184,
 15,208,163, 75,184,  1,113,242, 81, 21,190,234, 84,113,152, 34,198,222,234,246,
131,146,176,224,181,208, 54, 24,221, 36,107, 19,186, 75,225,143,178,252,120,102,
126,152,161, 88, 20,228,  4,123, 93,  0,180,111, 60,102,136,245,117,243,181,232,
 63,110, 47,187,197,211,130, 60, 52,234,166, 36, 91,180,227,200, 33,151, 48, 31,
146,165, 49, 22, 66,249,190, 31,141,249,  8, 77, 74,237,172,222, 24,216, 61,  4,
164,167,235,210, 66,232, 33, 69, 58,  4, 23, 77,166,240,248,245,231,116,253,164,
 29,155, 99, 49,105,215,140, 88, 81,127,220,107,177, 28,204,230,197,144,161,252,
153,241,137,155,194,201, 28, 74, 36, 20,193,236,187, 39, 21, 10,132,250,182, 12,
135, 13, 89, 64, 60,224,158, 90,250, 51,152,143,230,179,198,177, 54,215,254,197,
154,134,199,226,136,227,195,167,197, 32, 52,198, 34, 69, 16,158, 36, 18, 60,196,
140, 54, 59,133,234,237,111, 48,153,150,185, 16,248, 11, 67,241,203, 24, 27,237,
106,141, 23, 44,172, 46, 36, 14,163, 79, 91,249, 91,125,187,151, 45,  7,182,  7,
140, 60, 99, 61,109,212,229, 47, 34, 46,234, 80,107, 68, 71,138, 83,234, 54,113,
 41,124,203,122,163,219,217, 50, 20,216,178,156, 89,218,243, 43, 24,124,236,220,
 28, 61,233,153, 60,253,168,203, 87,146,113,233,253,248, 27,106, 91,112,254,106,
 62, 16, 18, 48,205,200,191, 65, 82,145,135,192,144,169,204,148, 73,119,202,228,
105, 27,243,131,134,179,178,254,128,  2, 37,116, 88, 79,165,223,162,  2,154, 73,
244,219,145, 84, 94,  7, 78, 56, 58,173,238,132,252,244,204,144,146,197, 72, 97,
156, 70, 58, 82,233, 82,231, 88,146,252,138,250, 10,140, 25, 25, 26,184, 38,199,
 45,214,197, 12, 16,170,119,  2,254, 48, 15, 22,108, 21,126, 66,127,105,160, 14,
 90,138, 85,203,193, 41, 43, 53, 64,232,203, 73, 87, 50, 69, 35,133,  2,253,251,
215, 31, 45, 31,230, 53,179, 32, 27,212, 44, 21, 12,210,217,169, 31,104,237,125,
 90,142,119,132,145, 37, 72, 63, 35,183, 29,  1,131,192,  6, 26, 13, 29, 18, 77,
130,202,159, 21,197, 28,  4,101, 17,227,151, 46,128,234, 59, 24, 62,201,169, 59,
226,150, 89,214, 35,  3,224,196, 99, 11, 54, 29,149,146,  2,215,242, 95, 43,135,
 33, 28, 50,145,114,  9,228, 90, 28, 48,166,140,103, 22, 78,208,193,120, 19, 57,
 52, 50, 59,134, 20,190, 88,157,166,164,222,148,186,150,  9, 92,151,156, 79, 64,
122,164, 59,  1,205, 48,224,  7, 53, 49,206,181,163,212,249, 41, 29,210,107,113,
231,208, 50,240,113, 34,140,130,190,105,171, 22,202,174,178,180,  9,156, 34,218,
212,225, 14,  4,
} ;

// ../CUDA/mxm/template/GB_cuda_jit_AxB_dot3_phase3_vssp.cuh:
uint8_t GB_JITpackage_21 [2234] = {
 40,181, 47,253, 96, 27, 32,133, 69,  0,122, 82, 60, 15, 45,160,236,138,117,246,
 30, 16,164,216,242,141, 66, 16,251, 15,  7,127,171, 55,122,171, 75,102,114,213,
196, 14,166, 76,244,109,253,158,180,201,190, 43,120, 29, 94,  7,124,114,212, 12,
223,  0,232,  0,231,  0,191,122,130,252, 61, 13, 86, 83,251,120, 47, 18, 97,118,
 28, 42,219,101, 22,110,151,237, 87,227,216, 88, 79,189,211,245,194,203,227, 90,
113,171,105, 48, 90,125,121, 96,173,240,198,204,226, 48,195,163, 22,101,141,217,
181,181, 33,125,157,215,138, 32, 13, 18,215,254, 62,  3,  7,110,199,193, 74,208,
 94, 48, 86,  1,182,223,113,216,154, 98,218, 75, 20, 16,153, 53,181,234,234,250,
129,221,201, 14, 23,215,204,123, 36,124,157,154, 75,209,202,120,189, 78, 73,237,
 61,175, 29,229, 37,217,191, 21, 82,248, 10, 53,143, 21,242, 37,225,221, 71,202,
219,248,105,251,136,221,203,136,133, 92,218,176,219,117,126,104,240,152, 85, 97,
180, 13,158, 10,101, 87,135,183,209,114, 46,103,219, 26, 65,110, 27,203, 68, 48,
142,229, 64,173,  5,121,  5,162,133, 24,125,  5,238,188, 30,119,220,187,189,121,
240,226, 88,143, 43, 38,241, 66,141,110,241, 78, 28,197,  6, 53,193, 56, 11,198,
 40,172, 21,159, 76, 34, 13,147, 73,167,115,106,191, 80,162,  8,122,144,156,125,
155,190,107,250, 39, 62,246, 73, 68,173,239,123,209,163, 67,143,114, 62,217,239,
 35, 55,232, 24, 11,215,224,226,225,195,137,102,141,159,142, 67,231,178, 64,184,
221,163,201,  9,253, 74, 78,236,106,155, 31,102,102,102,102,102,102,174, 56,130,
120,195,183,190, 64,160,  7,123,187,122,152,133,216,115,157, 78,119,244,136, 35,
120,100, 97,177,113,241,105, 58,  7,  4, 61,226,120, 14,219, 96,155,233, 86,  4,
145,208, 49, 51, 51, 51, 51,165,148, 58,231, 92, 84,193,104,184, 12,204, 37, 72,
120, 70,163,130,193, 56, 12,219,104, 40,184, 60,186,244,165, 31, 53, 69,229,162,
194,130,121, 77, 81, 20,117,102,102,214, 52,229,239, 76, 52,184,  8,250,244,142,
251,123,215,178,177,190,199,240, 74,  6, 71,230, 66,163,146,201,184,140,135,177,
 60,  7,224,154, 22, 16,137, 16,137, 34,240, 50, 92, 43,167,197,238, 34,121, 64,
 52, 68,116,252,158,234, 87,148,173,137,215,179, 58, 67,230, 37, 73,127,  4,122,
  1,142, 78, 24, 38, 72,170,134,248,177, 78, 77,172,110, 43,140,148, 66,216,143,
 16, 73, 48, 76,206, 92,117,188, 33, 51,253,194,130,132,196, 81,  8, 11,153,247,
 87,220,108,132,104,146,128,174,185, 21,109,141,243,214,184,245,229,148, 48, 98,
152,153,210, 48, 65,141,237, 78,124,218,156,149,231,246,149,241,234, 79,127,240,
182,160,115,100, 44,153,139, 10,133,229,109,178, 10, 58,119,  6,161,187,138,134,
179,160, 42, 20,188, 97,102,222, 48, 51,115,197,204,204,204, 27,134,144,120,116,
199, 39, 71,181, 24, 45, 44, 92,234,244, 37,234, 46,185,141, 68,160,  0,229,100,
 79,114,244,214,  3, 67, 52,120,219,119,127, 68,212, 82,  4,228, 90, 67,121,148,
 93,194, 46,208, 47, 15,227,138,104,107,164, 30,236, 66, 93,211,247,200, 58,142,
 93,234,124,182,137,100, 96, 48, 13, 94,166,194,128,218, 72,208,121,248,194,163,
181,208,192, 39, 38, 78,101, 29,125,105,138, 71, 71,  4,130,233, 87,191, 73,114,
138,196, 35,167, 92,146,101,144,236,  8, 50,  3,145,200,  4,202, 68,157,242,200,
 82,208,194,161,  9,137,235,130,207,234,109, 94,120,105,162, 21,134,124,218,219,
183,241, 66,141,179,113, 44, 11,254, 15,159,184,245,121,184,240,162,156,191, 98,
225, 11,  6, 37,178, 62,210, 70,106, 41,128,132,  0,224, 26, 96,251,210,165,105,
  3, 30,  0,210, 92,217,149, 78, 38,167, 72, 36,214, 71, 97,194,165, 14,117,137,
202,108,100,244, 39,133,232, 65, 97,130,  4, 61, 82,207,253,188,104,113,174, 88,
159,  2,  6,165, 16, 57,244,232,144, 71, 66,  7,  5,200,146, 30,235,160,192,128,
170, 40,160, 50, 24,140,140,151,193, 88, 28, 84,222,  2, 11, 53, 73,206,148, 97,
226,156,115,151, 42,231,186,234,  8,200,244,127,187, 73,131,178,183, 26,111,  6,
 99,173,110,225, 46, 44,151,136,161, 87, 42, 52, 42,151,151,193,160,136, 31, 53,
110,159,247,118,162,140, 53,203,178, 79, 19,101,250,137, 75, 11,221,252,247,182,
139,125,116,165, 28,226,146, 95, 77,212, 32, 26, 96, 71,216,216,245,202,120, 85,
104,217,190, 96, 69, 97,136,126, 40,130, 91,168,194,106,173, 82,140,102,164, 73,
 65,210,118,  2, 34,132, 34,113,166,102,157,102,  7, 34,121, 68,135,161, 12, 68,
 49, 68,  8, 83,132, 24,132,200,140,136,136, 72,144,160,160, 48, 73,210,  1, 48,
 22,193,209,254, 17,155,137,255,214,208,191, 22,  4,247,171,150, 97,240,116,148,
213,204, 58,200, 16, 40, 80,239, 96, 85,163, 35,243,230,218,186, 43,249,213,  9,
171, 57,126,184,  3,182,216, 85,130, 89,189, 50,191,155,229,103,218,105,114,235,
230, 71,139, 69, 18,134,255,118,129,243, 38,123, 12,230, 79,175,144,250,217,211,
 19,137,130, 19, 51, 66, 97, 79, 53, 86,208, 73,195, 29,204,  8,  7,242,  3,176,
228,250,113,211, 24,241, 49,246,166, 62,133,218, 57,156, 11,  3, 77,173, 73,144,
173,219,190,168,190,168,138,180,164,134, 51, 76,121,234,149, 72,156,216, 72, 61,
112,161,128,158,160, 67, 25,112, 41, 15, 99, 45,186,229, 17,198,182, 23, 88, 83,
 19,136,229,  2,255,  0, 68,155,205, 84, 39, 98,153,  8,131,216,  6,250,137, 24,
 49, 40,146,120, 71,133,137,196, 54, 76,119, 72,  9, 74,158, 99, 52, 96, 27, 93,
236, 41,180,155,164, 40, 46, 31,161, 86,253,191, 49,224, 91, 34,217, 25, 27,109,
 74,133,  0,106,141,108,203,111,201, 45,180,179,  2,129, 27, 77, 40, 50, 75, 86,
 33,140,223,219,134, 59,120,165, 33, 99,191, 33,115, 80,142,171,155, 54,128,164,
173,247,  1,109,153, 75, 13,175,169,177, 38, 33,200,237, 67,112,205,194,106,242,
152,133, 76,107, 43, 83, 41,116,219,203,154,  3, 85, 58,212,140,177,226, 12,155,
132, 76,209,170,244, 36,213, 33,154,  4,183,189,243,107,120,223,105,244,134, 46,
212,  6,  8,168,  8,207,213, 22,197,220,247,148, 60,222,215,223, 51,251, 78,107,
155,214,194, 61,146,131, 52,198, 65, 82,155, 70, 65,170,215,117, 95,160, 87, 79,
151, 60, 14, 47,118, 34,104,102, 59, 20, 80,196,135,166, 51, 63,198, 71,124, 25,
151, 98,104, 90,250, 37,239, 64, 69, 80, 48,134, 57, 19,144,174, 34, 73, 59,238,
  4,114, 67,214,195, 11,150,186, 31,208,171,153,217,190, 17,179, 57,177,155,160,
112, 32,182,170, 72,174,170,132, 65,210,154,150,180,228,158, 10, 43, 77, 85, 15,
179,120, 57,226,228,203,141,188,207, 70,124, 64, 46, 32, 65,234, 67, 93,145, 96,
 85,251,176,174,176,220, 39,174,249,100,  4,143, 12, 31,  1, 10,  5,188,195,228,
232, 49, 73,204,  8,125,106, 84,211, 77,233,218,184, 87,180,120,198,166,245,227,
 50, 82, 72,252, 40,161,192, 17,  9,163,164,254, 99, 28, 68, 83,  7, 84,186, 19,
223,159,245,242,229,134,  0,217,202,130,134,165, 70, 46,230,198,  5,203, 80,155,
192,187, 59,140,101, 10,237,136, 69,  4, 66, 92, 97, 13,243,169, 99, 61,229,101,
177,209,247, 82, 98,  3,  2,234,162,105,104, 94,  0, 90, 34,204,255,178,204,101,
170,  0,170,102,178, 19,226, 76,242,141,103,158,113, 55,140, 80, 15,103,143,118,
 66, 57,234,154,137,192,255,255,114, 92,253,127, 23,215,227, 97,127,238, 43, 59,
181, 27,  0,106,255, 77,237,217,221,207,106,194, 64, 81,185,210, 60, 78, 68, 18,
  2, 14,106, 70,250,218,249, 85,178,151,124, 47, 34,201,157,119,195,171,224,105,
  0,197,230,225, 16, 63,111,126,211,135, 40,188,119,209,110,102, 82, 26,228, 19,
136,  7,165,106, 55,127, 36,232, 95, 83,169, 67, 21,169,147,200,149,187,140,  3,
 29, 17,220, 24,121, 46,205,112, 34,149,129,238, 19,227,131,104, 86,217,236, 96,
  9, 26,189,227, 67,192,165,158,211,102,228, 48, 15,149,130, 40, 80,241, 20,225,
179,195,221,218,174, 32,  8,  9,133, 68,170,112,139,138, 18,128,200,149,227, 98,
 57, 24, 79, 82, 43, 12,121,207,126,227, 42,197,227, 81,228, 23, 53, 36,143,138,
155,111,  5, 37,220,127, 28,104, 48,254, 95,222,207, 14,134,248,200,148,226,103,
 60, 43,208,136,216, 52,229, 35,178, 27, 77, 35,123,208,133,134,132,126, 37,170,
138,184, 13, 72,112,227,252,  9, 39,136,191,233,154, 59,221,123,120, 75,151,210,
227,105,156, 99, 73,148, 74, 60, 68, 28, 79,210,120,135, 67,  7, 63,179,  4,231,
194,155,128,229,165, 37, 63,210,150, 80,165,180,126,249,242,224,236,229,247, 14,
186,217, 10, 57,239, 61,241, 28, 14, 26,159, 15,  9, 31,147,250,143,104, 93,146,
250, 33,248, 83, 24, 93,207, 44,181,153, 20,226, 81,169,209,169, 63, 98, 32,214,
202,143, 18, 64, 89,236, 44,242,128,181,204,184, 27, 12,111,139, 31,206, 48,240,
247,193,153,247, 86,191,  2,130,  0, 76,151, 17,240,104,150, 14,140,141,208, 47,
 75,143,206,106,162,109,235,217,223,113,196, 99, 48,101, 94,251,226, 33, 74,230,
135,159,210,112,208, 87,116,130, 35,210, 89, 90,247,240,135,182, 72,235,135,233,
193,223, 47,229,  2,  6,240,168, 64,164, 46,123,  2,154,255, 69, 99,248,113, 13,
 48,183, 73, 64,208,172, 74,127,177,238, 99,  3,  4,  9,191, 18,166,180, 53, 89,
 22,135, 63,203,152,147,224, 21, 35,146, 73,133,232,130,  6, 40,130, 46,180, 64,
129,  9,  0, 85,211, 23,203,206,202,174,243,152,152,234,196, 77,230,139,236,115,
113,115, 97, 21,179, 32, 91,  5, 67,  0,236, 74,140,171, 63, 41, 27,241,167,134,
249,108,217,  2,  3, 90,252, 37, 22,182, 98, 81,149, 56, 40, 30, 63, 28,144,160,
176,251,113, 94,184, 85, 45,123, 48,191,103, 37, 32,246,159,118, 86, 86,180,181,
 43, 66,165, 36,157, 90,  2,230,160, 52,125, 80, 33,226,225,  9, 73,232, 81,106,
 37, 44, 43,229,175,252,188, 80, 18, 61,204,162, 54,220,152,185,176, 20, 80,171,
  2,193,103,149,166,  0,129, 83,164, 53,165, 61,141,  1,
} ;

// ../CUDA/mxm/template/GB_cuda_jit_AxB_dot3_phase3_vsvs.cuh:
uint8_t GB_JITpackage_22 [1953] = {
 40,181, 47,253, 96, 62, 23,189, 60,  0, 42, 78,184, 14, 41,192,146,117, 14,106,
 13,  7, 77,  3,109,219,  4,109,248,251, 82,196, 56, 83,223,  8,227, 60,254,237,
141,249,255, 75, 73,198,187,172, 98,255, 77, 81,100,155, 14,  4,222,  0,221,  0,
223,  0, 30, 97,115, 97,139,172,234,100,153, 40,124,187,142,147, 43,230,205,150,
 14,254,138,162,219, 47,212, 56, 20,199,254,103,195,107,189,252,176,207, 85,123,
187,124,236, 30,174,224,187,220, 31, 63,125, 99,231,143,  4,126, 98,234,155,235,
230, 34,241,161,216,248,218,210,127,  2,137,133,114, 48,177,221, 86, 71,249,203,
181, 45,234, 28, 90, 46,155, 88, 28,218,173, 53,147,140,140, 71,187,151,194,233,
100, 32,249,233,120, 62,157,235, 50,203,100, 23,156,132,131,123, 26,197,235, 23,
251,181,232,184, 59, 16,133,179,165,107,177,253, 28,231,206,163, 63,255, 62,121,
 75,225,192,114, 48, 97, 48,176, 28,188,218,168, 91,184, 75, 53,115,138,252,169,
203, 34,216,160, 91, 23,139,111, 29, 53,155,155,164, 73, 58,210, 70,193, 37, 92,
162,  8, 22,215,110,164,  8, 89,228,232, 52, 73,154,123, 68, 43, 71,218,232,148,
168,216, 92,191, 17,180,185, 34, 51, 22, 87, 69,147,154,217,141,245, 74,188, 82,
145, 76, 42,149,178,162,142,185, 73,158,210,188, 97,123, 41, 37, 56,230,209,  0,
113, 62, 24,  8, 36, 61, 84,203,168,  4,184,168,  5, 36, 33,146, 74, 82, 51, 65,
222,166,220, 88, 23,157, 87,162,195, 96,114,225,184,119,197, 15,145,251, 45,235,
151, 80, 92,139,165, 83,250,213,144,248,121, 80, 74,  3, 72, 20, 36, 97, 26,112,
203,145,190, 45,108,  1,  9,182, 29,  2, 69,144,231,144, 36,110, 23, 51,137, 11,
217,175,243,177,197,164, 91,  6,199,125, 11,210,216,219,196,111,206, 41, 73, 99,
216,114,  3,254,194,223, 87,237,246, 83,189,183,102,235,109,164, 73,112,139, 47,
 18, 39, 14,207,183,102,252, 76, 19, 22, 46, 22,172,183,122, 64,194,211, 11, 14,
 18,154,142,177,106,196,136,149,176,112,107,193,224, 86, 66,  8,238,131,224,219,
107,187,143, 91, 32,184,178,160,112,112,204, 65, 10,198,161,120,240,138, 30, 95,
189,245,184, 22,236,107,241, 43, 38,217,175,218, 46,231,141,196,137,119, 60, 23,
214,119, 14,251,  1,150, 28,143, 79,245,227,171,199,125,249, 95,170,182, 46,148,
188,119,171,219, 80,223,208,238,163,107,199, 83,119,123,235, 55,215, 69,253, 14,
143,227,138,247, 70, 18,237, 66,187,160, 32,172,226,178,136, 48, 89, 62,240, 95,
242,181, 24,215,132,135,135,171,131,227,189,233,224,184, 64, 96,206, 53, 13,169,
206,245,245,192, 20,220,129,192, 68,  1, 59, 83,112, 19,197,196,101,  5,199,220,
243,168,234,213,169,219, 80,164, 97, 83,144, 16,164,174,105,228,  5,199, 18,210,
 19, 72,154,115,246,156,115,206, 57,231, 12,205,202,224,147,131,205,149, 40, 11,
206, 29,162, 29,174, 29,149, 38, 83,119,245,203, 33, 94,105, 52, 22,156, 99, 48,
215,160, 40, 13, 42,187, 81, 55,194,124,179,165,176,202,113,206, 57,231,156,227,
 56,142, 82, 74, 89, 97,218, 71,122,180,139,136, 28,244,193, 52, 77, 74,186,110,
244,153,216,188,218,244,166, 95,117,  6,227, 72,100, 26,237,235,186,174,207, 57,
231, 20,117,195,111,122,152,  4, 18,201,200,173,135,201, 69, 13,156,122,112, 56,
199, 85,186, 53, 40,230,106,249,131,133, 18, 53,245,170,169, 99,217,220,116, 26,
 10, 10,222,125, 85,150,233,186,117,129, 44, 60, 21,151,156,168,184,176,137, 11,
164,117, 60, 20,164,101, 25, 24,165,200,174, 89, 67, 51,212,212,188,189,162,200,
134,178,188, 91,216, 13, 14, 35, 95, 13, 27,188, 54,123,213,222,144, 70,114,178,
 13, 38,241,193, 54, 20,212,177,125,115,104,159, 77, 54,244,234,171,182, 60, 74,
 62, 68,132,161, 48, 58,154,136, 15,118,209,233, 72,112,178, 79,182,193, 52,170,
161,159, 76, 90,104,230, 12,201,218,213,156,227,  7,  6, 28, 46, 71,234,246,235,
238,163,138,112,155, 44,253, 68, 49,116,202,189,241,222,168,107,128, 50, 16,  7,
203,100,116,228,133,168,207,246, 42,117,137,125,164,230,194, 50,115, 52,231,156,
163, 57,231,156,161, 57,231,156,115,142,166, 65, 65,115, 28, 35,199,207, 86,  3,
  3,183, 76,125,107,148,183, 44,235,  0, 97, 36,121,162,248,209,129,240,168,  1,
 89,102, 70, 68, 68,100, 36, 73,146,202,112, 17,  9, 33, 10, 82,201,140, 30,242,
192, 64,138, 98,140, 65,218, 16,130, 20,  9,164, 70, 68, 68, 74, 10, 74, 10,146,
106,  3,197, 10,208,107,190, 95,141,208,125,180,118, 67, 89,227,160,221, 45,149,
 55, 86, 66, 37, 92, 66,150,148, 59, 97, 68,224, 79, 71,181,181, 52,137,171,109,
169, 77, 40,183, 20, 34,208,  7, 81, 34, 12,194,207, 62,126, 72,108, 38,246,136,
136,149, 80, 29,160, 44, 96,158,193,206,205, 17,117,193,249,138,213,182,192,211,
144,183, 28,206, 46, 50,192,219,241, 28,  2, 86,252,111, 29, 83,160,205,111, 17,
192,146,215,223,166,194,221,  1, 23,156,198, 83,213,216, 78,175, 81,115,157, 50,
 28,245,237,224,227,206,128, 15,182, 39,176,213, 63,150,153,155,  5,227,  5, 72,
 65,139, 48,108,136, 71, 16,177,224, 83, 13, 37, 85,172, 75,  3,152,137,231,114,
214, 67,220, 16, 18,186, 46, 40,215, 60,223,220, 24,206,107, 96, 24,160,142,167,
178,100,210, 40, 94,201,127,197, 89,146,195,168,223,  5,203, 91,254, 34,102, 60,
132, 99,245,112,166,185,146, 71, 65,133, 99,111, 19, 15, 78,  5,213, 60,171, 77,
194, 40,162,  5,237,156, 45,180, 18,165,145, 41,155, 48, 58, 62,157, 25,230,  4,
134,150, 77,226, 97, 87,  8, 38,109,145, 27, 30,190, 35,238, 61, 86,148,229,249,
165,224, 21, 79,128,169,113, 24,192,230,  3,206,136, 48, 94,212,104,174,252,253,
187,152, 76,184, 61,  9, 27,120,154, 37,129,250, 15,204, 95,185,  5,157,119, 30,
252,154, 65, 70,117,135,192, 83, 12,102,  0,130, 56,196,  9,  8,167, 17, 97, 24,
134,224,100,213,236, 73,127,124, 45, 72,135, 11,240,  5, 86,131,228, 34,205, 66,
145,237,144, 29,228,112,158,153, 38,249, 94,111, 76, 23,177,148,118, 55, 57,176,
245,215,129,216,152,180, 85,232, 37, 58,245,150, 55,148, 40,180, 56,231,216,105,
 99, 87, 33,255,103,114,164,232,101,  1,165,100,172,202, 98,236,154, 13, 22,238,
197,241, 39,190, 84,136,152, 69,101, 80,127, 75,  3,  4, 78, 28, 21,174,177,154,
 90, 58,154, 50,  8, 62, 54,121, 55,136,121,230,  6,168,226, 94,134,206,132,246,
 30,135,212, 15,135, 70, 64,185,201, 12, 45,249,184,162, 97,185,230,150, 16, 63,
183, 74,228, 92,208, 11,180,213,  7, 24,179,132,179,219,  3, 91, 91,244,191,168,
173,  4,242, 27,179,227,229,181, 32,245,150,104,185,111,100, 14, 41, 94,178, 69,
 28, 56,105, 71, 30,  1, 97,141, 58, 30, 52,122,170,150,118,136, 67,130, 20, 54,
232,244, 30,200,132, 98, 49, 66,248,161, 21, 52,135,112,127, 65,116, 71, 66,  5,
 24, 32,  8,155, 22,112,231, 29, 38,144,  6,248, 13, 80, 64, 32,138,  9,178, 76,
225, 24,129,176,195,253, 47,195, 42,195,153,231, 88, 72, 53,  4, 75,164, 38, 73,
125,139,242,133, 75, 28,197,  4,245,216,185,176,254, 21,126,119, 55, 70,203, 60,
152, 40, 97,196, 81, 89,160,154, 23, 50,175,236,148, 23, 60,209, 64, 74,100,197,
149,213,  6,125, 86,104,153,243, 10,208,102,179, 77,193,208, 85,177, 85,175, 13,
162, 27,  5,  0,184, 72, 65,227, 96,167, 40, 14,  9,100,158,212,120,164,128, 52,
 75,189,163,240,152,248,109, 30,183,170,  0,167,200, 61,220, 41,177,112, 94, 37,
 48, 90, 61, 38, 52,172,  4, 12, 88,204,148,245,113,235,166,167,221,255,248,140,
 63, 13,103,211,130, 44,231,167,240,214, 49,243, 38, 39, 64,180,159, 96,145,192,
 99,128, 55,146,200,191,141, 77,211, 98,119, 40,166, 61,188,  5,248,159,196,156,
148,192, 59, 31,203,156, 12, 98, 70,206, 55, 95,129,158,188,169,247, 57,170,124,
 22,153, 73,116,132,102,231, 97,170,249,243,174,178,215,101, 46, 71, 68,103,138,
200,230, 35,157,224, 67,130, 95, 46, 17, 19,  2,153, 35, 35,252, 69, 23, 10, 87,
  0,224, 40,120, 28, 68,162,129, 25,197,125,248,188,126,242,235,146,134,  2, 19,
190, 89, 15,128,186,233, 30,118,178,136, 92,241,  0, 76,210,201,  3,212,173,216,
248, 95,130, 89, 75,201, 71, 99,201, 60,181,219, 47,178,124,173, 97,232, 92,106,
126,175, 51,209, 54, 69, 84,187, 37,  3,  5,132, 86, 39,  6,  4,201, 59,158, 95,
179, 50,176,139,162,194,151,211,146,191,188,234,101,205,  8,206,247, 29,186,135,
 97, 19,101,  1,255, 54, 49, 72, 13, 59,254, 39,126, 71,105,249,130, 91,169,150,
119, 62, 46,101,181, 32,165,131,206, 26,248,152,113,158,159,162, 49,120,186, 73,
176, 26, 50, 87, 12,174,129, 83,212,170,106,  7, 39,
} ;

// ../CUDA/mxm/template/GB_jit_kernel_cuda_AxB_dot3.cu:
uint8_t GB_JITpackage_23 [4734] = {
 40,181, 47,253, 96,177,103,165,147,  0, 58,139,156, 25, 46,144, 78, 93,231, 86,
 21, 97, 87,179,231, 50,205,206,168, 90,243,120,224,129,128,141,160,191, 64,156,
129,112, 52,116,  2,216, 19, 59, 59,131, 15,233, 78, 36,  2,  0,128, 16,137,  0,
  8,141,  1,145,  1,133,  1, 19,160,172, 83,218, 94,157, 59,197,193, 60,155, 14,
 40, 19,105,162, 79,196,255, 59, 58,214, 18, 87,231,166, 89,  6, 53,235,221, 64,
129,203,214,203,177, 73,235,216, 70,175, 11,252,170, 92, 99,202,123, 64,187, 72,
117, 34,184, 40, 17,158,224, 23, 51,216,  2,195,203,173, 49,123, 87, 98,112, 54,
114,255,100, 35,149, 27,  6,143,186,139, 60,207, 26,178,181, 18, 13, 61,238,150,
 73, 36,153,249, 35,205,225,140,166,115, 51, 13, 47, 91,246,222,124, 35, 39, 39,
 24,118,239,147,189,252, 85, 38,221,227,104, 24,103, 69,101,196,207, 98,129,224,
185,133,181,123,232, 43, 63, 57, 53, 78, 90,254, 66,106,177,116,183,171,229,226,
247,  7,162,141,103, 35,225,217,156,227, 24,108, 72,199,185,145,206, 29,190,222,
 99, 84,239, 55,172,103, 27,146,164,196, 45,142,145,236, 40, 67,109,121,205,232,
 29, 13,207,112, 91,173,229,  0,142,172,227, 96, 35,241,  9,109, 52,205, 72, 94,
206,225, 96, 90,150,129, 36,152,202, 17,119,  1, 28,142,136, 69,197,  4,173,239,
170,119,249,251,217,187, 39, 81,217,225, 51, 15,  2, 24,  6,162,243,224,152, 68,
 46,  8,123, 92,  4,177, 91, 44,203,145,188,148,187, 13,132,155, 50, 39, 57, 16,
  7, 17, 21, 33,107, 35,158,207, 70,132,129, 62, 21,160,143,230,216, 38, 98,195,
192,227,112,217, 19, 88, 53,183,240,148,163,183,244, 68,145,142, 77,150,155, 65,
239,235,145, 36,232,115, 98,183, 10, 92,147, 11,114,128, 50,185, 94,113,212,173,
150,166, 24,241,  8,246,147,119,235, 39, 69,183, 44,220, 54,130, 33,190, 50, 12,
 57, 66, 46, 82,185,181,211, 50, 25,152, 22,187,144,211,180,204,132,164, 39, 83,
203, 37,237,202, 11,  9, 22, 97,161,145,132, 48, 78,198,  3,163,157,184, 68,226,
128, 72, 36,  1, 12,231, 46,156, 28,125, 44,224, 16, 49, 16,158,136,234,129, 58,
 55,229,206,225,205,211,187,101,177, 80,146, 87,140,107,161,167,248,137, 38,206,
 95,236, 42,167, 57, 54, 28,151, 11,187,106,193,131, 54, 98,156,103,245, 48, 30,
155,165,189,245,125,235,124, 71,239,170,  8, 89,104,231,137,184,  4,123, 87, 42,
 66,222,141, 32,164,195, 91,192,207,186, 20,136,176,138,147,101,147,133,178,180,
169, 77,148, 16,131, 16,  3, 75,  6,187,119,235, 22,127, 43,165,254, 40, 41,141,
245,108,147,233,124, 32,104, 14, 11,142, 47,164,124, 37,108, 99, 71,227, 59,212,
 51,126, 81,168,230, 12, 71, 22, 24,191, 43, 55,139,186, 37, 99, 97, 87, 69,115,
203, 50,120,242,250, 45,223,137, 84, 32,119, 72,146, 35,122, 41, 91, 30,121, 92,
228, 91, 85, 36, 18, 41,217,138,241, 74, 59,102,250,102,185,125, 85,131,122, 51,
  5, 82,239,193,240,167,237, 29,223, 16,252, 42,119,139,195, 67,162,140, 66, 99,
145,241, 92, 46,113,225,118,113,171,100, 81,143,136,192, 68, 28,139, 78, 38,115,
235,162,180,101, 36,127,252, 86,  6,118, 75,150,226,169, 99,162,108,130, 59,114,
159,148, 73, 27,111,203, 36,158, 51,126, 93, 77,142,  1, 64, 93,222,208,112,235,
198, 58, 71,225, 45,  7,  3,151,202,  6, 31,142,  4, 40, 99,240,209, 50,208,199,
 51,177,209, 32, 84, 86,126,220,108, 53, 43, 99, 56, 65,234,180, 74, 38, 85, 23,
153, 63, 94, 73,171, 68, 97,199, 52, 92, 34,113, 76,120, 54,160, 77, 39, 11,101,
 32, 13,180,193, 44, 56, 21, 90,245, 25,169,252, 44, 95,141, 91,167,192, 50, 80,
 70,147,216,112, 79,166,208,100, 10, 52,162,208,167, 66, 19,133, 54, 14, 50,109,
193, 70,179,113, 57,135,246, 30,243,190, 45, 51, 88,187,144,156,  5,  9,175, 50,
160,133,129, 84, 22,215,198, 27,138, 80,126, 43, 82,205, 48, 90,147,  9,133,193,
196,225,178, 38, 19,  4,143, 83,108,234, 29, 13,235,198, 27,151,228,148, 24,204,
 81,217,191, 52, 94, 91,223,205,211,138, 83,226,143, 60,110, 53, 85,210,121,163,
175,221,183,249, 90,248, 86,207, 53, 77,191,112,142,106,135, 53, 36, 81,121, 99,
169,227,101, 83,244, 94,111,228,110,243,136,148,157, 83,121, 91,111,131, 97,169,
214,217,124,154,180,254,202, 91,119,134,205, 54,126,130,159,236,240,139, 92,  2,
180,118,103,140, 55,141,156,244, 48,110,117,191,178,149,122, 39, 47, 30,165,169,
 41, 90,237, 41,244,221, 80,117, 42,187, 29, 57,151, 39,168, 83,124,168, 83,157,
180,164, 87, 62,217,221, 98,160, 18,186, 41,224, 22, 42,129,193,130, 44,185,105,
228,222,183,235,215, 95, 63,110, 81,247,108, 58,163,170, 89,222,190, 80,242,138,
114, 72,195, 49,167,104, 93,154, 27,125,165, 65, 63,234, 33, 14,198,192,163, 93,
238,227,185, 49,  9, 12, 51,151,223,243,248,213, 42,125,179,149, 97,  5,182,103,
142,109,156, 28,119, 92,133,128,104,167,239,152,143,180,147,173, 31,127, 26,179,
 29, 93, 30,162,208, 96,153,172,179, 17,121, 44, 64, 93,226,226, 54,103,228,126,
153,116,185,154,229, 79,138, 66,112,130,250, 71,244,  1, 85,104, 21, 78,230,  1,
101, 20,154, 38,218, 44, 96,208, 48,252,102,112,189, 28, 13, 71,191, 93,189,  6,
 63, 80, 86,241, 64, 65, 22,  2, 97, 23, 24,130,153,205,115,171,210,232, 25, 64,
253,  1,232,211,201, 58,167, 12,161, 29,165,112, 71, 15,212, 52, 72,134,250,128,
  1,175, 56, 28, 11,137, 95,184,240, 10,172, 35,218,100, 48,138, 98, 78,154,184,
211,208,152, 45,131,167,125,161,132,111,156,224,199, 55, 14,199,134,227,242, 42,
 20,202, 52, 26,139,208, 31,147,201,132, 66, 73, 48,124,163,189, 85, 97, 59,  2,
 27,108,218,121, 34,104,183,  1, 54,248, 93,127,252,241,211,214,167,104,109,100,
 27, 47,173, 93,180, 38,177, 55, 95,238,129,170, 38,215, 85,177,168, 74,197,218,
184, 40, 15, 15, 23,101,195, 43, 31,207,219,187, 25, 86,175, 45, 88,168,123,220,
149, 24,253,127,114,136,202,106,136,  6,229,126,153,177,242, 10,192,117,234,209,
 90,190, 97,237,188, 14,231,168, 33, 45, 59,  7,112,109,221, 48,  0, 19, 48, 45,
224,130,105,120,111, 45,  3,244,132,  8,151,115,207, 56, 98, 90, 53, 42,181, 89,
235,102,245, 60,115,215, 77, 33, 32, 19,168,156,241, 86, 38, 89,190,163,248,235,
186, 54, 38, 52,108,214,143,121,232,228,221, 48, 84, 66, 67,195,  3, 85, 79,189,
186, 46,202, 33,111,144, 80,159,146,185, 99,126, 77, 54,241,188,145, 20, 65,171,
251, 95,216, 95,200,189,226,124, 52,172, 92,189,148, 36,187,227, 45,221,173, 83,
166,227,110,230, 56,172,219, 68,132,160, 38,114,149,211,177,181, 60, 98, 91,113,
 57,116,138, 91,154, 58,140,114,113,130,183, 92,176,206,  4, 74, 61, 42,  7,203,
132,138,112, 59,242,252,109,112,  0,161,236, 65,  2,238, 19,141,140,209, 29, 95,
 59,137,143, 38,178,248,104, 25, 59, 65,157,218,240,178,189, 97,125,188,162,250,
227, 15, 12, 41, 13,153,  1,183, 42, 75,243,169,168,  7,125, 92, 21,  9,  5,163,
 93,143,156,182,206,198,  0,118, 35, 94, 43,115, 11,187, 69,157,118,215,195,226,
108, 50,205,198, 69, 41, 96,193,225,130, 24, 57, 24,208,184, 28,193,245,122,169,
 51, 84, 24,168,142, 27,140, 51,171,222,223, 73,  6, 34, 23, 69,192, 79,129,181,
115, 75,  3,  1,  1, 97, 89, 15, 15, 15,191, 84, 84,133, 33,168,211, 25,162, 18,
 58,165,104, 70, 70,210, 86,134, 49,179,128, 48, 32, 52, 42,168, 14, 38,179,113,
244, 13,211,  1, 18,185, 88, 16,152,194, 73,  8,132, 24, 18,130,  8, 65,132, 56,
 98,  8, 17, 48, 66, 12, 17, 17, 17,147,186,233,157,214, 96,169,109, 50,  4,  3,
217,214,148,188,226,130,246,  5, 34, 71,166,189,115,229,135,236,110,134, 31,123,
112,238, 61,240,119, 31, 22,179,158,  9,133,159, 39,143,117,208,145, 85,119,158,
 72, 75,235, 70,210, 53,252,212,232, 36, 76,154,146,255,195,206,129,196,231,250,
 41,  6,238,116,202, 34,186,172,  3, 92,167, 68,226, 47,  0, 71,195, 28,  8,197,
 73,147,237,162, 16,255, 81,238,117, 87,147,139,120, 87, 14,242, 71, 55, 43, 77,
128,101,  1, 28,192,164, 28, 88,209, 38,160, 74, 36, 63,230,193,  9,213,206, 14,
 91, 93,190, 84,185,211,128,175,133,104, 52,252, 27, 76,188,225,143,215,111,225,
235,248,203, 61,192, 74,144, 20,248, 90,176, 96,160,176,127,126, 69, 42,210,  2,
 12,157,218,160,160,115, 67,174, 57,119, 40, 24,243,114,116, 37, 59,183,126, 53,
165,204,162,  6,242, 20,102,141,185, 62, 58,254,128,231, 29,131, 48,209,194,213,
198,244,124,224,244,  8, 69, 93, 36,182,175, 39,208, 41, 63,154,120,190,251,225,
219,221,191,160,217,178,154,192, 79,184,186,229,  7, 62,126,233, 32, 65, 89,143,
134,243,244, 50, 67,187, 20,143,253, 33,242,236, 27,255,  8,184,237, 32, 12, 34,
 55, 77,141,143,135, 20,144,185,183,  7, 33,162,118, 24,235,139,132,114,  0, 15,
132, 38,134, 81, 76,188, 55,195,232, 17,204,162, 44,133,195,174, 38,246,246,104,
 78,192, 14,254, 31, 68, 80, 25,166,  2,220, 54,115, 73,  9,195,136,229,  4, 42,
 89,124,143,136, 63,198, 20,180,198,243, 33,177, 32, 24,241, 15,152,221, 14,109,
  3,  1,106, 80, 76,209,180, 54,200, 20,  4, 58, 24, 85,114,126,150,216, 10, 10,
129, 49, 96,142,136, 21,148,230,173, 45,  4,240,127,155, 87,158,107,197,218,190,
211,125, 62,104, 74,235, 13,100, 68,  4, 92,123,147,209,178, 89, 54, 10, 36, 88,
175, 34,227,149,228, 55,217,217, 60,230,252,211, 43,221,216,240,180, 10,245, 89,
123,108,208,153, 71,216,239, 79, 26,206, 49,200,149,  5,115,235, 38,248, 91,146,
246,106,183, 49,240,143,114,235, 21,166,110,219, 49,183,161,205,182,190, 61, 52,
143,115,200,199,178,234,220, 84,  1,222, 25,198,171, 38,121,204,115,103,  7,110,
177,226,  1,134,245,234, 73,133,109,251, 75,225,124,227,137, 22,150,229, 98,252,
127, 69,190,109,232,146,  7,189,120,102, 97, 35, 19,126,214, 62,143,  8,254,208,
  2,200, 74,255,163, 65,170,221,150,130,228,136, 77,162,202,173, 56, 28,132, 21,
149,220, 56,152,171,105,241, 86, 53,250,225,248,208,195,255, 81, 23,  0,188,224,
133, 56,180, 49, 31,169, 58,243, 21,231,244,233,218, 47,  0,147,197,222,168, 75,
 97, 63,  9,175,115,212,172, 71,154, 96,163, 11, 65, 38, 24,  4, 67, 35,179,181,
 42, 94, 23, 83, 33,136,  3,219,  4,130,236,105,214,241,149, 36,240,193,180,163,
144, 72,  2,193, 46,160,140,161,165, 92,177,162,119,163, 13,216, 13,149,  4,103,
 28,152,222,162, 74,234,  8,247, 77,212, 20, 15,166,205,133, 58,131,107,174, 11,
126, 75, 94,173, 38,185,197,253, 26, 48, 92,112, 83,140, 40,145, 73,124,183, 69,
 23,228,126,232,183, 27,123,125, 75, 48, 12,123,123,125,143,148, 72,215,198, 35,
115,248,136, 47,218,127,178,133,172,248,229,192,155, 55,149, 88,131,223, 10,231,
 66,232,  9,231,237,175,104, 17,160, 26, 23,158, 75,216,253, 80,146,227,101,199,
212,199,220,115, 20,160, 53,160, 15, 63,169,207,149, 89,117,208,162, 15, 59, 69,
 36, 97, 29, 52, 34,125,194, 67,198,171,227,139,229, 80,163,137,231, 75,133,  5,
183, 48,178,163,109,193, 26,  6, 73,  1,  2,176,130, 26, 68,102,193, 71,129,158,
  6,162, 15,210,187,172,230,180, 60,224, 77, 61,153, 27,215, 25, 39,171, 70, 10,
253,131,135, 86,239,251,170,161, 56, 59, 98,164,148, 75,239, 71,200,168,214,210,
 83, 97,192,110,246,191,123,253,135,128,122,119,162,134, 27,139, 74, 98,141, 96,
148, 32, 71,194,210,198,229, 40,247,246, 19, 17,193, 59,236,113,155,124,226, 32,
252, 46,117, 10, 90,118, 94,243, 74,  3,228, 19,  7, 89, 26,201,109, 79,186,171,
187,143,177,160,200,120,153, 49,250, 56,104,177,199, 52, 89,153,247, 17,181,131,
162,143,224,136,181,214,197, 53,175,110,140,240, 29,170,225, 80,236,173,108, 97,
153, 54,  9,110,220, 50,  5,214,227, 80,160, 90,255,106,101, 48, 22, 61,159, 11,
172, 80, 72,113,161, 29, 56, 43,202,203,174, 47,  5,233,151,196, 92,186,245, 46,
  8,203, 30,  2,221,114,196,179, 77,233,218,197,248, 27,193,181,170,196,146,116,
 89, 18,169,210,240,139, 88, 27,150,245, 30,197, 13, 98,233,112, 45,122, 27,  4,
  0,128,162,231,203, 64,209,122,116,163, 33,  7,118, 41, 36,148,128,172, 81,233,
  1, 75, 99, 40,169, 52,185,238,109,113,200, 35,224,111,133,134,  2, 76,132, 15,
113, 94,174,164,  3,150, 23, 23,106,193,251, 81,191,146,174,  8,138,244,248,102,
 36,162,193, 68, 68,121,  0,249, 32,135, 57, 73,157,136,108,123, 24, 27, 24,164,
 75,219, 76,112,110,229,184, 54,116,144, 49,141,129, 35, 74, 81,188, 45, 74,163,
189,200,183, 50, 82,182,212,139,185,191, 48,109,203,148,  6,168,197,211, 17, 46,
188,145,193, 72,140,175,  4,159, 47,122,127, 26,105, 10,231, 98, 45,254,229,115,
  9,108,129, 16,  0, 21, 44, 11, 31,211,107,  3,154, 44,  8,250,130,221, 90, 90,
 55,180,136,104,208,212,236, 78, 81,178, 23, 10,155,138,  3,241,108, 56,120,138,
 24,201,146,131, 74,137,203, 99, 23,134, 58, 90, 18,191,242,138, 90,245,214,228,
238, 42, 91,162,227,121,  5, 39, 64, 38, 61, 31,162,234,132,113, 57,146, 89,122,
 42,142,173,201,196,131,194, 30,178,132,231,111,194, 41,172,183,250,146,211,215,
112,  3,105,169,119,197,143,134,249,108,220,114,250,175, 96,136,173, 36, 61, 56,
117, 78,229, 59,190,160,225,221, 27,115, 87, 32,248,229, 98,144,210,169,168,200,
 57,135,116,114, 64,148, 78,181, 22,195, 10, 69,183,228,180, 41,195,207, 68,140,
160,253,151, 97,160, 75,176, 52, 60,170,193,184,240,234,218, 11,143,213,  3,247,
 64,178,201,197,210,233,127,195,136, 94, 27,121, 72, 59,101,235, 16, 68, 24,223,
188, 22,253,244,223, 56,126,  1,148,226,227,  1, 12,165,149,241,129, 21,147,184,
 35,247,128,  4,123,250,148,137, 99,  4,147,223,100, 63,107, 49,138,208,128, 83,
172,250,172,252,196, 10, 65, 14,169, 25,208,200,177, 69,162,233,153,143, 40,124,
160, 13, 31,114,  9,150,245,223, 79, 63,  5,182,163,102,131,  3,111, 49, 65, 78,
 94,100,  4,209, 43,251,166,109,142,221,190,202,142,147,  0,226,183,232,166,202,
239,107, 30,255, 55,146,189,150,  6,166, 94, 94,124,217, 32,127,135,  0,209, 30,
 68,205, 13,134,112,187,147,197,185,197,237,227, 96,201,116, 35,219,112,133,196,
165,  6,196,159,227,208,152,204,183,148,254,243, 91, 36,108, 37,159,166,154,154,
242,117,197,135, 88,166, 73, 78, 74, 25,126, 47, 17, 50, 90,196,211,101,154, 27,
129,221,222, 16,241, 95,176,209, 99, 72, 70, 73,185,131,152, 10,208,250,206,108,
  7,169,  7,171,178, 35,211, 38,153, 85, 48,211,144,157, 26,223, 76, 28,211, 34,
 98, 20,131,162,132,247,201,  6, 70, 47, 76,230, 92,169, 42,221, 83,192,167,110,
184,103,  4, 79,204,220,  6, 33,234,203, 16,191,  1, 39, 16,  1,200,106,139,141,
105,199,  2,120,223, 41,123,140, 58,218,188,144,171,141,117, 76,201,241, 51,183,
225,216, 83,183,224, 66,147,226,210, 14, 91,175,171, 58, 52,219,  0, 42,154,250,
191,129, 35, 53, 26,232, 15,169,113,139,235, 76, 36,180,  9,212,201,198, 10, 59,
200,157, 87,151,125, 12, 98, 36,219,167, 33,219, 64, 43,216,142,105, 67, 50, 15,
163, 66,154,186,250, 31, 42, 95, 59,126, 91, 68,213, 58, 98,100,127,136, 25,189,
217, 18,246,224,  7,137, 49, 12, 81,170,131,124,101,  2, 33, 33, 35,173,226,118,
 14, 41,178,123, 96,135, 21,118,153, 53, 63,121, 70,108,198,126, 97,222,105,242,
153, 49, 33, 37, 85, 62, 26, 96,201, 25,108,232, 27, 18,193,203, 99, 20, 61,171,
173, 77,184, 41, 67,164,191, 75, 35,  1,231, 56,253, 30,196, 78, 23, 18,155,204,
243,130, 52,181,153, 88,102,119, 71, 85,  5, 18,138,211, 60,231,151,227,134, 84,
120, 68,  0,225,144, 52, 98,106,137,243, 49,215,  2, 34,156, 49, 36, 40, 97,188,
 26, 76, 28,238,214,114,170,162,144,178, 72,176, 55,181,124,132,240,150, 58,231,
 79,114,229,185, 93,226, 50,147,131,126, 61, 86,144,  5,225,176,174, 92,210,148,
 78,  1,193, 78, 86, 78,152, 28, 14, 52,240,126, 27, 45, 63, 32,  0,193,  4,236,
 56,175, 40, 31,188,132,210,254, 16, 49, 32,151,175,204,202,143,105,242,148,216,
 56,181,235,137,227, 16, 82,163,236,144, 87,125,100, 65,146,133,191,160,151,219,
192,213,118, 75,177, 57, 82,178, 15,118,144,148, 38, 42,143,147, 73,112,204,203,
 20,174,100, 74, 96, 93,145,133, 16,137, 90,177, 36, 60, 10,  6, 44, 68,170,198,
 55,144,253,140,206,114,152,203,151, 55,144, 67, 50,244,196,116,151, 49,112, 22,
 54, 14,118,100,135, 57,234,237,104,127,164,155, 26,211, 16,169,110,222,161,106,
  8,125,  7,109, 84,147,119,205, 96,192,134, 71,240,216,221, 74, 86,232,203, 71,
109,144,148, 96,169, 12, 80, 10,216,171, 95,200,181, 37,188,147, 55,195,  3,183,
210,110, 74,247,217, 60,231,164,220,217, 21,220,147,  4,145,160, 91, 40, 88,229,
230, 15,119, 63,178,100, 73,106, 64,110,171, 24, 51, 31, 67, 58,105,220,182,197,
247,122, 88, 58, 37, 87,116,232, 95, 44,173,247,110,104, 46,224,231, 82, 86,255,
 66, 12,232,163,159,138,247, 82,223,164, 97, 39,107,198, 95,218,  9,178,103, 82,
146, 84,120,200,111,240,106, 73,216, 21,131,216,182,146,162, 14, 99, 39,104,  9,
166, 41, 72,132,173, 56, 53, 18,244, 66,124,146,183, 57,177,180, 25,253,196, 66,
166,105,  4,199, 18,189,  8,227,173,179,128,  1, 34,216,161, 76,240, 77, 32, 69,
106, 61,  5,130,181, 32,217, 31,188, 58, 71,203,140,177,128,126,158,113,  4,110,
255, 81,243, 18,108, 99,124,192,214,182, 64,245,191,141,224,209, 15,196,231,159,
 45,  1, 63, 39, 99, 50, 15,192,237,135,242,179,234, 47, 99,195,189, 69,138,193,
 57, 35,159, 83, 66, 98, 88,224,159, 76,248,215,182, 89, 52,200, 27, 80, 13,252,
131, 30,181, 55,240,150,181,253,228,125, 93,237, 52, 72, 77, 89,155,188,140, 11,
235,145,246,147,196,228,177,178,154,190, 28,239, 38,186, 46,224,219, 88,157,183,
191,130,243,123,102,228, 70,220, 78,202,234,  4,143,236,111, 90, 88,188,198, 75,
244, 95,136,213,234, 62,119, 85,163,197, 27, 46,135,232, 50, 24,138,152, 14, 28,
 32,249,204, 86,212,179, 39,144,212,116,238,119,182,205,165,127,227, 21,166,170,
 82, 28,233, 96, 25, 70,212,134,154, 13,186,197,202,243, 47,248, 30,224,216,212,
  0,198,195,202,171, 99,121,111,212, 57,247,254, 76,235, 41,236, 30, 62,  2,211,
 70,194,208, 31,226,156,100, 23, 52,105,202,106, 35, 17, 61,193,217, 42, 31,127,
 44, 11,227,191,202,208, 97, 89, 87, 69,109, 40,147,103, 81, 46,149,230, 67, 43,
254, 20,143, 98,253, 19,200,103, 76,208,168,190, 48,189,165,152, 94, 62,107, 92,
 71, 43, 28,135,146,251,129,155, 36, 42,186, 40, 94,210,126, 70,204,110,  7,217,
 73, 36, 45, 92,169, 10,149,117, 10,  9,121,128, 41, 44,249,234, 13,149, 86,129,
223, 82, 70, 47,191,196,134,196,234,178,217,217, 34,106, 39, 73, 62, 71, 18,147,
 81,126, 77, 23,156,183,193,170,203,192,140, 53,214,226, 73, 86, 55, 72, 44, 63,
145,179, 61, 17, 51,255, 70, 85,224, 59,207, 90, 82, 98,118,201,202,165, 34,139,
162,  4,138, 82,245, 32, 78, 14, 11, 82,131,160,204, 53, 88, 33, 47,142, 65,123,
164, 21, 29,206,220, 59,176,177,171,179,  8,163, 47, 93,152,108, 54, 74,203,235,
227,164, 95,151,229, 91,  9, 86,191,125,133,247,186,143, 77,  9,102,230,128,219,
176,141, 41,202, 97,201,181, 71,223,156,159, 28, 21,  8, 57, 60,  2,107, 20,245,
174,241,208,242,145,160,109, 86, 67,107, 10,245,205,119,  3, 19,218,171,115,228,
216,155, 23,132,249,248,120,194,252,109,163, 91,200,219, 20,157,177,186, 48,200,
163, 47, 52,199, 58,135,245,127,183,151,103, 88,179,209, 11, 23,251, 19,125,108,
  2,156,130, 81,227,138, 71,218,240,149,158,120,166, 23, 42,202,  3,128, 55, 19,
240,216, 75, 93,152,229,131,170,195,243, 82, 63,136,168,128,160,228, 93,156,132,
157,106,166,207, 46,112,116,128,212,142, 80, 14,190,177,141,117,101, 96,156,252,
240,144, 36,127, 80, 42,112,207,118,107,116,199,198,234,232, 15,252, 84,222,136,
 57, 56, 57,147,130,103,169,246,189,197, 92, 86, 92,145, 30,147, 35,200,165, 32,
 58, 26,175, 24,142,154,115,146,120,160,218,241, 28, 92,119, 56,  5, 50,  7,254,
210, 55, 18, 38,252, 76,133, 84,204,121,111, 25,149,174,193,119,150, 62, 52,141,
 48,111,122,159,253,184,155,249, 99,181, 18, 30,137,200, 92, 65,171, 31,134,213,
 34, 55,213, 53, 91,125,254, 96,173,196,226, 94,198,185, 84,212,107,230,215,250,
 87,140,207, 17, 12, 37,175,225, 89,127,103,252,131,116,232,242,245, 50, 81,239,
220, 79, 53,139,243,179,178,135, 37,214,117, 32,243,127, 32,201, 99,177,121, 65,
244,134,228,250, 14,166,139,135,210, 18,181,236,226, 61, 57,159, 50, 95,  8,128,
224,118,189,208,158, 22,232, 81,103,174,218, 21, 89,233,124,111,190,138, 69,222,
122,231,116,180,208,144,152, 91,238, 25,216,223,222,100, 36,151,155,174,174, 71,
 69,242, 97,195, 35,109,209, 73, 86,169,213,130,209, 54,
} ;

// ../CUDA/mxm/template/GB_jit_kernel_cuda_colscale.cu:
uint8_t GB_JITpackage_24 [1231] = {
 40,181, 47,253, 96,210, 12, 45, 38,  0, 38,117,160, 40,192, 84,177, 14,228,122,
129,215, 95,178,228,175, 42,228, 62, 14,  1, 77, 44,129, 65,134, 94,126,152, 51,
 68,144,130, 78, 40,  4,179,219,166, 40,104,155, 14,  4,144,  0,153,  0,145,  0,
 46,199,104, 36,154, 34,140,163,170,131,230,205, 16,227, 93,238,196,255, 71, 82,
 68,187,222,246,188,166, 48, 98,106,227,229,180, 32,127,143,194,141,165, 31,239,
 69, 81,195, 66,130,194, 91,100,214, 45,139,111,225,195,210, 40, 10,200,182,136,
208,113, 82,252, 60,253,160,220,226,164, 51,164,218,167,115, 64,  4,112, 59,203,
246, 28,251,150, 19,215,121, 92,237,204,177,110,156,183,220,104,172, 83,224,217,
214, 91,249,201,  4,107,155,189, 31,175, 65,102,134,183, 53,107,227, 59, 66, 13,
247,  7,214,127,212,137,183, 40,162,252,186,220,179,172,140,196,187, 76,188,235,
228,180, 20,  8,161,155,107, 63,203,218, 59,203,189, 85, 27, 63, 77,218,169,141,
147,238,222,230, 50,  1, 48, 18, 97,240, 10, 69,250,181,156, 27,128,100, 69,166,
188,224, 32,132,207,196,120,162,165, 27, 57,239,204,181, 95,157, 15, 75,216, 55,
203,245,141, 97, 60,165, 27,103,162,193, 79,158,155,218, 20,  4, 62,191,  6,135,
235,226,144,152, 68, 42,148,142,185, 44,138,140,205, 38,191,135, 92,231,134,195,
208, 84, 92, 34,206,148,181,179, 78,214,209, 52, 77,155,158,161, 32, 33,185,133,
101,220,  6,246,176, 10,233,156, 41, 80, 85, 85,133,193, 92, 40,  7, 89, 14,220,
 39,233, 17,  7,185,191,151, 35,238,251, 94,193,173, 13, 15,205, 11,  4,  4,  4,
  4, 34,154,147,110,169,104, 91,110,252, 52, 75,241, 51,180,148,147, 49,164,158,
 83, 10,155, 13, 63, 42,244,153, 42,149,140,239,228, 76,216,115,109,200, 67,180,
218, 75,191,173,133,178, 73,199,  6,169,141,105,151, 36, 84,210, 55, 52, 44,172,
162,195,234,143, 10,179,136,219,202,183,180,241,154,125,227, 25,210,167,184,135,
242,196, 23,106,248,253,129,248, 24,102,175, 52, 55,225,116,138,162, 52,214,196,
212,233, 72,233, 23, 43,227,174,202,194, 12,132,216, 11, 63, 57, 72,206, 71,109,
156,116, 46, 43, 28,208, 30,241,249,190,157,133,124,234, 80, 83,114,199,243,238,
117, 62, 81, 73, 68,249,132, 97, 86, 85,113, 96,210,235,221,114, 95,204, 41,119,
170,146,110,177, 88,168, 10,150,170,189, 89,172, 33,236,  3,251,102,236,247, 90,
 25,195, 43,247,  4,150,206,240,153,210,226,105, 57,168, 48,210,  1,220, 52, 85,
210, 47, 52, 30,198,186, 46, 24, 28, 22,154,140,133, 97, 14,187,168,220,229,122,
 81,158, 29,233, 26, 26,141,204,198,179, 46, 87, 97,151, 70,245, 46, 43, 35, 99,
 93, 60,135,225,168,158,166,194, 34,160, 10,120,189,157, 65, 45,197, 26,194,  8,
211,165,191,135,103,  4,161,181,164,183,242,111,188,193,216,155,203,150,221,117,
 50, 41,201,178,142,230,161,140, 76,  6, 21,152,105,203,129,  8,168,113, 65, 50,
 51, 35, 34, 35, 73,146,148, 58,145, 12, 65,204, 82,232,204,  7,  2,105, 68, 76,
145, 44,101, 24, 68,196, 32, 34,115, 50,162,160, 48, 69,169, 20, 90,  3,159,236,
158, 55,  8,142, 27, 35,186, 62, 95,212,217,  3, 67, 78,211, 59,244,254,135, 77,
242, 83, 27,111, 33,228, 64, 12, 53, 81, 61,129,139, 88, 86, 56, 50,231,243,193,
 92,135, 30, 64,252,194,112,208, 75, 73,230, 19, 76,189, 51,178,123, 69, 34, 25,
169, 59,114,  8,133,116,183,248, 94,164, 68, 73, 72,184,121,161, 11,139,161,149,
179,102, 64,254,  0, 53,142, 69, 17, 25, 82,213,  8,115,180,209,229,194,219,207,
228,158, 83, 90, 81, 81, 61, 13, 64,185,100, 36, 33, 95,186,248, 44,199, 65, 54,
127,149,152,112,194, 22,254,153,165,212, 67,216, 45,199,107,141,101, 52, 82,137,
131, 28,116,159, 83, 94,136, 79, 22, 44, 73,124,127,161, 52, 54, 55, 67,217,184,
 38,110,219,192,229,211, 18,151,  3,144,133,197,151, 72,243, 43, 17,138,173,218,
173,116,156, 41,182,207,148,124, 17,166,236,123,151,130,213, 33, 20,122,235,246,
182,123, 78, 21,105, 74,249,178, 22,148, 98,140,233, 99,223, 35,141,131,171, 42,
 98,  4,101,127, 83, 33,120,125,232,121,110,164,181,147, 57,105, 46,120,164,209,
 82,171,101,172,199, 16,230,140,119,154,178,120,118,123, 92,  4,220,  0,195, 15,
 76,202,188, 50,160,158,210, 88,106,192, 45,253,223,128,167,179, 75,118,243, 97,
108, 98,126, 52,156, 20, 24,102,255,150, 74,218,176, 68, 13,136,219,199, 92,141,
 23,251, 39,180, 72,  6,243,254,110, 99,199,247, 41, 23,167,166,144,175,104, 11,
 68, 42, 16,255,219, 91,203, 28,157, 30,231,127,128, 90,120,201,240,217,240, 33,
  5, 62, 36,112,112,255,251, 27,103,102,102, 70,203, 73, 41, 76, 81,163, 39,179,
154,194, 19,175,138, 24,127,242,171,209, 30, 23,  4,177, 92, 24,251,131,237,132,
167, 52, 22,138,114,203, 83,206,244, 99,243,111,186, 39,115,168,194, 40,119, 40,
226,187,220,132,144,206, 10, 55,238, 15,209,136, 92, 20, 84, 17, 94, 73,170,  1,
179,163, 21,155,250,227,159,184,253,189,168, 61,108,117, 44,  5,250,217,173,244,
234,164, 29,205, 52, 35,203, 21, 79,209,189,172,211, 57, 41, 14, 64,136,163,219,
 47, 60, 62,198, 53,240,236,235,223, 65,151, 23,243,117,132, 85,148, 50, 95,147,
145,153, 56,192,185,153,219, 78, 49,  6, 60, 89,203, 79,179,135,194,153,128,134,
  2, 79,225, 21, 58, 99,229, 85,246,243,238,164, 18,244,164, 11,113,147,168,160,
  3,113,196,172,155, 13,170,153,186, 93, 21,
} ;

// ../CUDA/mxm/template/GB_jit_kernel_cuda_rowscale.cu:
uint8_t GB_JITpackage_25 [780] = {
 40,181, 47,253, 96,101,  6, 21, 24,  0, 22,163,109, 33,224, 90, 23,  3, 80,245,
107, 63, 57, 18,121, 77,137, 33,253, 45, 93,104,127,127, 82,114, 12,165, 31,189,
215,192, 12, 67, 48,239,  5,100,  0,100,  0, 98,  0,191,119,127, 76,172,239, 29,
220,106, 60,155,203,109,147, 44, 63, 45, 76,195,104,183,213,159, 89,239,240,114,
169,150,252, 63,150, 97, 37, 76,106, 76,186,184, 20,126, 76, 85,169,111, 56,162,
 62, 99, 46, 83,191,183, 20,138,101, 41,116,175,121, 66,149, 58,116,113, 42,239,
 80,227, 83, 89,126,142, 63,225,201,196,166,144,124,136,204, 38, 10,195, 26,247,
 60,238, 90,251, 69, 46,149, 28,147, 25,132, 71, 65, 90,180, 79,248, 57, 82, 30,
 31,243,110,144, 62,101, 73,252,224,167,193,148,187, 49,235,208, 31, 55, 73,102,
184,201,147,184,148, 18,191,175, 98,225,121,156, 72,227, 26,139, 20,179,119,158,
157, 96, 68,113, 95,198, 38,179,134,187,108, 40, 20,148, 71, 18,231,156,179,246,
111,226,114,221,130, 31,167,  1,111,118, 80,166, 52,  3, 82, 74, 51,223,174,214,
 90, 41,165,141,159,144, 66,119, 45,251,227,103, 23, 29,167,222, 13,165, 18,168,
129,147, 26,239, 19, 99,175, 65, 69,212,236,154,140,  5, 41, 29, 75, 79,250,109,
148,197,220,253,241, 45,127, 59,187,111, 27, 43,201,121,204,206,217,143,243,170,
237, 70, 91,206,232, 65,229, 79, 60,170, 74,253,141, 67, 63, 28, 26,215,182,156,
169, 36, 99, 47,140, 34,243,110, 93,211, 78,223, 68,154,157, 94,145, 74,  0,127,
 16,238,104, 60,126,202,174, 75,208, 24,226,216, 11,107, 92,  3, 65, 91, 43,  7,
204, 78,106,212,198,154,126,235,190,213,236, 16,  8,100,115, 56, 28, 55,179, 99,
 86, 38, 75, 45,250,144, 43,208, 20, 98,189,193,107,109,183, 25,122, 27, 75,178,
155,217, 19,166, 60, 66, 10,149,118,217,  1,154,102,201,220,206,122,244,194,169,
108, 62, 11,130, 28,104,169, 28,245, 46,182,243, 40,179,201,124,154,107, 61,174,
130,157,204,119, 61,139,249,172,229,114,  1,128,155,168, 65, 61, 98,136, 38, 16,
 33, 73, 65, 10, 10, 25, 14, 80,132,  8,221,217, 54,130, 73,178,140, 36, 51,200,
 24, 33,146, 10,196,164, 52,251,179,  6,200,198, 51, 68,159,227,  6,228,214,151,
 97,136, 79,162,  9,138,155,209,204,203,164,101,205,208, 55,175,121,169,123,209,
176, 63,107,247, 52,  0, 25, 59, 70,164,  9,168,104,142,187, 46,173, 70,179, 90,
197, 63,173,173, 45,125,246,131,175,176,166, 42, 28,145, 64, 81,185, 19,162,148,
155, 38,217,170,109,188,242,195, 17, 98,145, 69,104,100, 43,169, 85, 22, 28,116,
252,213,146,187,133, 41,207,134,101,164,241, 41,126, 64, 24,150, 76,141,122,247,
  7, 68,241,231,158,180,165,244,  4,183,119,183,107, 17,228,217,  7,141,109, 40,
138, 67,114,135,228,103, 95,140, 42,180,114,114,193, 18,118,243,249,179,248, 45,
 64, 44, 44,  0,162,231, 98, 25, 24,240, 65,216,205, 84, 19,136, 79,218,191,120,
146,177,120,118, 93,229, 53, 64,116, 71, 72, 24, 64, 70, 85, 39, 70, 79, 68,242,
238,197,  0, 79,152, 90,221,160, 48, 59, 15,143,214,207, 62, 83,115,115, 53,239,
 87,142, 53,  3,237,225, 65,208, 92, 89,238, 21,249,  5, 81, 74,200,141,237, 37,
 17, 92,189, 94,223,  6,149, 54,195,157,199,122,156, 67,252,  0, 72, 64,216, 47,
239, 80,185, 34, 23, 83, 56,216,232, 41, 99,129, 51, 58,128,  7, 93,132,199, 31,
239, 33,147,144,134, 64,240, 49,120,208,207,168, 73, 69, 76, 83,166,141,169,  2,

} ;

// ../CUDA/reduce/template/GB_cuda_threadblock_reduce_ztype.cuh:
uint8_t GB_JITpackage_26 [1109] = {
 40,181, 47,253, 96, 95,  9, 93, 34,  0, 22,181,153, 40,208,210, 86,  7, 72, 82,
 69, 86, 24,213,107,201,  8, 50,107,239,168, 26, 24, 13,139,219,  7,142,137, 19,
 13, 29, 56, 63,207,152,182,131, 92, 13, 86,224,247,  2,155,  0,132,  0,136,  0,
238,159,169, 98, 89, 38,124, 61, 71,202,252, 66,185, 69,109, 37,195,206,132,171,
228,215, 16, 19,139,141,  4,136, 82,203, 19,209,  9,101, 62, 17, 18,159,  8,205,
 51,157, 77,135,194, 83, 96,161, 25,105,106,126,225,216,162,215,190, 66, 22,228,
 15,202,149, 63,175,246, 26,245,231, 49,102, 46, 49,176, 84, 44, 19,132,129,138,
229,213,163, 46,169,253,225, 54,183, 50,207, 46, 59,177, 14, 93,114,225, 74, 29,
  9,196,182, 47,104,186,238,179,152,148,217, 82,227,119, 33,211,214,241,102,228,
128,142,233,101,155,131,247,181,134,  7, 10, 91, 23, 73, 24, 91, 74,102, 51,161,
161,128, 50, 16, 13, 23,201,209,135, 83, 40,211,132, 66,  9, 79, 94, 23, 31, 89,
 82,238,200, 56, 14, 43,115, 96, 87,222,189,186,235,112, 94,150, 49,251, 26,163,
123,183,174,137, 76,213, 20,221,199,255,137,154,206,145,184,  8, 53,140,214,248,
245,  7,195,214,222, 26,203,142,178, 91,107,150,209,140,135,210,189, 84,207,178,
 69, 12,111,235,197, 46,192,240,198, 39, 27,224, 92,112, 96,101,223,134,221,250,
203, 54,200,153, 58, 18, 54, 53, 86,197,177, 47,251,144,235,165, 14,123,202,137,
 93,242, 71,143,206,151,253,149,252,162,121,234,162,123,245, 28, 71,178,235,221,
207,244,210,189,214, 73, 95,253, 11,236,129,  9,245,128,135, 88, 33,176,131,249,
188, 30,124, 58, 47, 93,229,120, 11,200, 36,221,157, 57, 14,227,157,239,182,237,
229,184,196, 66,144,197,232, 48, 58, 61,191,197,114,190, 94,217,216,185,212,117,
218, 87,176, 73, 71,210,209, 75, 98,116,167, 83,116,  9,236,232,222,140,119,191,
176,116,209,246,235, 72,194,122, 68, 53,136,249,130,194,245, 28, 95, 82,167,149,
179,109, 91,217,175, 19,100,200, 44,111,167,124,237, 87,212,147, 89,181, 70,151,
 48,229, 43,225,213,169,134,177,170,170, 84,169, 19, 96, 13,169,103,212, 50, 54,
121,244, 43,211, 52, 66, 93,210,107,153, 94, 60,151,107, 48,188,170,168, 43, 80,
144,109,237, 16,206,162,156,207,108,151,108,149,243,193, 46, 81, 15,129, 60, 17,
154,118, 17,234,132, 60,156, 77,167,113, 62, 25,  8, 13,103, 83,105,139, 46, 91,
182,131,181, 25,160,119,242,131,212, 65, 41, 91,114,205, 28, 72,116,  3,199,220,
178,129, 81,192,122, 83,171,109,  7,153, 54,173, 61,146,209,137, 49,198, 23,158,
109,211,138,  4,204, 53, 96, 87,149, 99,168,139, 90, 35,163,181,191,182,206,214,
 75,197,110,181,241, 86,166,135, 76,221, 85, 43,  9,230,143,238, 21,163, 76,226,
 36,124, 97,193, 54,236, 26,128,210,168,113,169, 83,104,102, 68, 68, 82,146, 20,
 36,195,  1, 32,132, 16,130, 24, 67, 59, 98,184,136,146, 40, 41, 57, 98, 34, 19,
 40, 40,167,164, 82,143,229,130,201,162,156, 98, 19, 32, 42, 80, 39, 95,154,164,
156,252, 36,161,103,138,  7,151, 43, 63, 43, 21,229,204,219,242, 52, 49,215,112,
192,212,251,180, 80, 47,147,111,121,153,105, 32,117,210,152,113,128,186,  7,239,
170,229, 26, 42,  0,110,219,246,157,143, 26,178,202,102,156,134,228,134, 19,237,
227,164,206, 95,215, 89, 50,  9, 21,171, 71, 34,203,173, 63,154,206,187, 30,164,
234, 33,212,145,186,201, 64,122,237,136, 84,208, 65,107,216,112, 44, 46, 15,213,
 53, 47, 84,127,  7,106,128, 48,226,218,175,253, 90, 54,175,196,141,  1,219, 52,
106,115, 40, 46, 76,  2, 80,221,191,182,236,255,115,151,111,219,186,104, 70,207,
 78,133, 89,215,194,197,161,112, 28, 65,166,198,203,128,183,111, 12,213, 29,103,
 62, 47, 72,131,228,101,240,144,176,168, 79, 68, 97, 15, 93,224, 70, 86,164,165,
194,193,240, 24, 46, 36,111,123,111, 58, 23,224, 87,250,219,181,121,156,224,200,
225, 54, 52,181,199, 86,249,159, 72, 86,249, 30,143,  9, 93,166,224,120,242, 69,
  0,179, 21,145, 71,119,203,168, 95,176, 12,181, 46,153,167, 62,186,  9,176, 25,
248,177, 47,244,132,209, 70,147,223, 74, 17,184,241, 32, 83,126,167,173, 51,237,
237, 18,108,131, 76,216, 43, 70, 32,139,199, 79,231,184,167,122, 90,193,175, 42,
 83,120, 59,250,167,120, 80,219,148,161, 78,175, 46,187,105,165,194, 74,139, 20,
207, 19, 40,107,109,208,116, 59, 88,219, 37,214, 12, 93,139, 65,222,248,162,117,
199, 39, 71, 96, 14,133,231,  8,238,170,144,218, 70,103, 47, 39,100,230,154, 23,
 71, 76, 79, 71, 52, 38,214, 51,109,126,  9,144, 40, 36, 31,164,225,202,172,113,
255,218,200,155, 93, 68, 36, 27,133,233,175,195, 60, 25,147,230,103,180, 78,152,
217, 30,109,238, 15, 66,178, 19, 36,220, 67,200, 34,253, 52,226,255,126, 48,103,
199,233,240,173,  3, 18,248,251,118, 96, 95, 28,204,142,222,116, 84, 67,166,  2,
242, 27, 56,229,104, 75,181, 64, 12,
} ;

// ../CUDA/reduce/template/GB_cuda_tile_reduce_ztype.cuh:
uint8_t GB_JITpackage_27 [1802] = {
 40,181, 47,253, 96,118, 23,  5, 56,  0,122, 66,  4, 12, 40,208, 86, 81,  7,  4,
 22,145,200,183,144,221,206, 85,181,  9,146,180,224,252,112,165,120,106, 87,193,
 18,  7, 75,197, 32,169,123,191,140, 82, 15, 14, 70, 81,  1,189,  0,171,  0,181,
  0, 32,107, 67,220, 42,151,139,241,250,106,125,200,199,162,214,187, 93, 63,249,
 80, 20, 49,235,101,218,148,118,118,250, 30, 42,  7, 21,207,134,195, 51,114, 57,
227,134,139, 81, 84,118,194,189,216,162,242,225,201,216,144,210,114,129, 65,241,
233,104, 96,100,104, 96, 60,188, 67,225,161,232,184, 64,192,200, 17, 23, 31,158,
217,199,217, 39,107, 31, 11,182, 33,185,115, 53, 62, 91,  3,177,198,223,235,188,
 74,192, 20, 96, 42, 11,  6,  5,152, 83,215,244,106,114, 72, 61,183,116, 62,210,
 58,110,252,121,149,217, 41,149,219,216,230,110, 67,154, 48,114,255,109,104, 95,
133,147, 42,250, 51, 90,119, 89,150, 27,245,137,181, 87,135,173,180,246,113, 91,
138,117,151,229, 32,113,217,214,199,109,219,151,142,135,227,225,178,209,177,112,
208, 56,149, 18,191, 92,164,202,229, 18, 74, 77,115,235,224,136,228,112, 67, 12,
122,117,194,147,175, 93,172,137, 94, 25, 84, 98,191,224, 91,148,217,231,130,160,
202,175, 92,205, 35,  5,110,247, 52, 52,161, 80, 13, 39,152,158, 49,198,125,237,
142,219,226,245,152,205, 77,198,172,119,102,213,100,217,104,170, 15, 92,237,243,
 91, 62,191,228, 60,  6,245, 61, 23,251,148,250,244,154,143,162,254,212, 46, 93,
205, 41,106,178, 38,107, 61, 89,216,134,211, 80,114,197, 71, 98,157, 76, 11, 32,
131, 57,120, 22,247,129, 32,207,133,156, 45,246,214,235, 55,164,218, 87,244,157,
145,227,180,169,217, 23, 20,251, 37, 50,138, 30,251, 20,247,101,188,140,211,117,
 98,186, 82,235, 41,138,239,233,155,226,183,236,165,220,220, 77,225, 39,215, 69,
 25,159,  8,  8,139,  6, 77,202, 53, 31,193, 28,136,180,197,208,144,187,163,188,
175, 78,246, 60,228, 57, 82,209,179, 46, 27, 21, 23, 28, 19, 15, 23,146,165,161,
246,132, 17,195,164, 78,214,200, 13,197,206,246, 97,221,187, 76, 22,224,255, 37,
137, 58, 68,  8,197,  6,  3,112, 78, 65,100,128,124,172,144,215, 65,217,245, 74,
168, 25,203, 44,129,157,118,193,248,216,159, 87,235,114, 59, 59,144,212,103, 97,
251, 48,168,218,155, 55,126,175,204,237,207, 43,236, 69,109,211,112,234, 51, 81,
219,101, 50,156, 79,131, 53,121,250, 62, 18, 29,113,241,170,140,222, 83, 14, 81,
211,220,215,140,145, 43,138,220,245, 75,242,158,221,246, 12,203,190,148, 91, 39,
 92,142, 83, 77,235,  8, 15,183,106,222,112,158,193,248,217, 65,222, 94, 97,  2,
243,  5,146,148, 34,105, 78,101, 38,103,124, 25, 11, 50, 59,187, 87, 51,246,155,
223, 83, 47, 76,163, 36,121,252,252,239,233,179,184,109,221,236,178,144,106,127,
143, 69,163,  7, 99,199,139,128, 87,  1,211, 81, 98, 76,217,112, 52, 55, 56,135,
243, 82, 12, 48,  8, 12,167, 60,158,142,230,148,130,129,230,109,178,112, 39, 79,
222, 92,107, 22, 97,135,122, 73,148, 36, 77,146,234,159,153,164,140,114, 79, 96,
115,149, 18, 26,160,228,  0, 10, 69, 64, 16,146,175,  8,  8, 26, 52, 47,248,102,
122, 47, 74,216, 93, 55,144, 74, 14, 96,183,214,133, 49,106, 46, 53,212,212,203,
141,220,123, 65, 40, 85, 53,240, 75, 19,198, 49,  4,249, 65,182,172,189, 56,180,
152,101,101,140,193,213, 60,142,251,117,219, 53,227, 99, 17, 82,156,129,138,  6,
 68,  7, 70,129,204,168,145, 45, 67, 67, 35, 34, 34,  5, 73, 82, 40, 12,  7, 49,
  8,130, 64, 32,170, 41, 61, 15,210,136, 68,138, 84, 72,163, 12, 83, 18,145, 72,
 32,161, 36,145,130,146,130, 20,235,127, 34, 12,101,194,138,120, 98, 59, 14,145,
154,132,131, 24, 93,190,172,163, 67, 49, 65,  6, 52,127, 19,255,209,134, 45, 53,
 92,160, 83, 27,237,149,229, 97,102,113, 39, 20, 45,101,169,145,210, 36,252,153,
170,163,229, 93, 23,178,161, 77,160, 57,165,223, 81,197,170,197,167, 50, 53,152,
229, 39,  5,122,242, 59,212,138,253, 26, 50, 14,233,157,135, 40, 78,123,138,218,
 84, 44,167,127, 99,134,109, 18,  0,  2,  2,240, 98, 30,180,226, 93,216, 59,121,
217,  2,125,183,191,106,  9,166, 63,105,230,202,210, 18,170,126, 84, 53, 67,158,
 78,161,127, 30,161,143, 43,197, 92,151,126,169,247,160,143, 60, 73,220, 54,172,
117,195, 79,117,185,159, 89, 86,229,137,247,189,138, 32,243,196, 96, 91, 65,152,
130, 67, 10, 77, 70, 97,125, 80, 49, 33,250, 38, 98,157,161, 80, 90,159,  5,207,
224,182, 93, 70,193, 24, 21, 79, 14,249, 99,147,170,142,143,134,255, 49,  4,116,
143, 77,214,102, 47, 94,  1, 90,114, 35, 29,169,203,159, 94,114, 82,159, 72, 95,
 33, 39, 70, 86,243,161,213, 30,179, 66,247,175, 34,  9,162,134,137,119,244, 22,
249,111,216, 13,217,  7,179,187, 62, 74,162, 30,136,169,247, 76,169, 88,134,219,
216,238,227,254,235, 28,123, 36,234, 95,134,118,203,147,168, 10,195,111,204, 62,
 58,205,210,115,130,127,153, 10,213,114,213,123, 96,227,231,167,206, 75,173,  9,
204,247,106, 58,242, 48,129,220, 48,213, 70,216,215,128,100, 91,  5, 87,206,240,
127,140, 67, 49,130, 52,223,180,  2, 13,191,155,176, 76, 82, 56, 57,216, 81, 65,
183,118,128,243,247, 83,132,171,183,183,166, 82,127,154, 40, 73, 11, 38,140, 84,
 48, 49,226, 52,163,210,253, 43, 10,128, 24,184,130, 98, 51,105, 40,121,  2, 40,
 28,  2,220,229,174,148,  5, 88, 25,200, 35, 84,121, 50,233,123, 43,178,143,100,
  7, 54, 19,  3, 68,156,185, 98,176,  3, 93,160,122,110, 43,209,142,232,  3,142,
222,130, 52, 47,167,167,255,144,242, 69, 26,136,  1,180, 62,247,213, 73, 19,249,
174,252,130,250, 39,126,113, 10,228, 55, 18,193,240,160,126,220,108,236, 15,104,
 63,140, 33,116,140,208,220, 25,132, 53, 57,140,251,158, 13,227,209,139, 91,178,
229, 87,107, 59,  0, 88, 76,128,114, 64,182, 95, 38, 96,102,200, 17, 37,117,214,
  1, 90, 18,179,123,195, 40,109, 24,209, 25,158,113,189,144,230,155,124,  0,109,
114,152,  7,133,201, 20,158,  1,170,157, 27, 66,132, 20,222,220,142,152,138,  6,
 67,109,  7, 16,182,166, 52,153,163,  4,219,171,  4,113,177, 36, 86,216, 41,220,
 93, 34,203,113,195,158,204,226,182,104,101, 77,195, 87, 45, 40,177, 89,175,113,
 96, 41,201,102,237,123,175,154, 28, 21,221,  3,192,207,148,158,101,120, 77,232,
246,207, 25,205, 66,211,114, 10, 96,232, 26,122,191,128,230, 18,106,  1,127,119,
205,158,177,181, 23,202, 43,182,102, 32,103,103,209,139,142,163, 61,206,167,107,
118,205,254,155,233,132,117,209, 74,117, 18, 24,181, 58, 83,114,  9, 61,209,220,
  5, 75,143,216,217,121,227,185,198,165, 89, 48,241, 43,  3, 16,185, 66, 76,129,
 61,114,128,192, 98,157, 50,221,176,249, 80,212, 81,210, 48, 69, 55,110,236,133,
180, 96,232, 25,192, 35,137, 86,  2,124,204,235, 33, 45, 68, 98, 52, 60,177, 32,
138,201, 48,228,166, 10,100, 30, 23,100,154,253,148,221,209, 57,171,135, 31,198,
106, 50,175, 28, 81, 93,170, 26,245,205,138,127,221,148, 19, 74,158, 80,217, 69,
112, 38,219,208,210, 72,164,241,221,154, 94,176,206,247, 39, 14,111, 32,128,239,
 24,  0,  4,143,216, 20, 92,247, 64, 68, 84,170, 48,223,238, 71,103,159,117,143,
200,206,202, 85,254,232,107,149,183,163,174,232,136,216, 50,156,225,128,221,176,
 75,124,186, 41,235,207,190, 99,234,147,144,210, 82,164,194,238,178, 82,194,176,
 40,187,177,195,239, 39,137,230,137,158, 85,103, 16, 22,180, 58,122,126,158,120,
208, 13, 15,110,247,149,181, 71,230,  6, 50,139,137,134, 47,182, 76, 14,246, 95,
 84,124,113,133, 18,135,136, 18,  6, 58,246, 21, 48, 40,  9, 10,134,213, 24, 74,
231,131, 21,110,162, 25, 58, 91,249,105,202, 53,184,223, 99, 74,188,241, 37,117,
226,146, 83,138,176, 12, 29, 48, 10,241, 89,121, 62,134,246, 53, 95,153,108,225,
168,159,  7, 24, 48,221,164,171, 50,199,  4,132,121,  9, 47,143,128, 77, 41, 13,
192,  3,
} ;

// ../CUDA/reduce/template/GB_jit_kernel_cuda_reduce.cu:
uint8_t GB_JITpackage_28 [2025] = {
 40,181, 47,253, 96,112, 27,253, 62,  0,170, 77,112, 14, 44,176,170,172,234,106,
 55,129,172,137, 50,133, 17, 79,197,164,181, 13, 19,136,127,173,166,135,109,120,
 98, 46,147,187, 46,175,144,107, 64, 21,208, 39, 63,232, 63,216,158,210,205,217,
  0,211,  0,217,  0,241,119,147, 94,197,241,180, 59,124,142,198, 83, 61, 61, 84,
126, 44, 90, 37,182,245,251,197,114,250, 84, 31, 14,147, 78,177,213,169,113,177,
109,135,127,253,213,132,141, 51,110,247,241, 21,159,186, 50, 10, 54,208,234, 15,
132, 15,162,241,157,122,235, 31,105,113, 68,  0, 37,182,242,248,251, 95, 82,121,
 71, 11,213,163,209,221, 22, 63,235, 16,219,178, 35, 49,109, 14,107,244,165,189,
 73, 75, 35,  1, 37,147, 89, 91, 93, 48,216,198,210, 96, 50, 26,204,228, 22, 70,
193, 36, 46, 14, 15, 11,250,234,228,144,158,178,243, 43,187, 77,197,117,133,237,
219,154, 95,220,121,164,230,115, 90,167,  0, 60, 22, 30, 13,  1, 12, 11,143, 79,
155,116,234,202,138, 72,121,101, 29,212,225,234,201,205, 41, 72, 95, 27,191,172,
177,204, 89,148,183,170,183,204,181,133,145,203, 27,148, 84, 28,119, 54,181, 77,
  1,177,108,224,176, 40,156,137, 35,179, 44,146,238,139,182,114,135, 35,106, 56,
 28,  1,115,163,  0,224,195, 83,103,245,104,120,  4,162,222, 41, 79, 77, 18,  7,
103,167,187, 85, 91,188,111,142, 91,107,143,182,168,223,227,241,205,222,189, 14,
 75, 91, 61, 51,222,246,119,144,141, 21,167,113,123,232,194,158, 18,119, 36, 71,
 25,214,109,253,228,182,118,206,209,204,184,173,214, 54, 66,244,224,193, 49, 25,
  6, 39, 29,249,112,139,197,130,215,165, 33, 64,101,167, 57,132, 40,207, 88,209,
168, 87,218,174,104,250, 57,165,197,173, 83,156, 76,165,190,105,109, 12,203, 55,
150,214,226,202,170,213,  6,191, 24,251, 43,  6, 19, 67, 99, 98, 80,208, 36,138,
 74, 84,122,175,170, 42, 65, 91,160, 81, 55, 87, 17, 71,238, 56,127, 84,122,157,
107,246, 72, 76,235,246,  1,  9,247,151, 90,212,214,126,143,123, 62,114,237,184,
 45,159,170, 83,227,169,252, 69,144,255, 84,158,164,212,123,138,194,192, 73,235,
233,112,149, 84,247,222,106,183,200,245,205,111, 27,211,  2,131,111,193,165, 37,
 37, 68, 20, 32,254, 41, 36,252,147, 32, 95,229, 26, 82, 82,174, 75,  5,203,160,
244, 80,105, 51,247,219, 82,243,106,136, 98,235,110,203, 46, 76,130,  0, 51,  1,
 51,171,128,237,238, 53,  5,224,149,105,172, 76,  6, 59, 66, 24,222, 95,229,240,
229,211,110,237, 54,  6,105,119, 56,141, 61,127, 99, 87,113,178,210,234,113, 13,
154,241, 20,197,128,176,124,248, 36, 93,193,  6,219, 92, 46, 10,  6, 47,141,101,
153, 92, 20,170,169,244, 66,175,253,137,104, 88,159,164, 71, 32,196,155,180,248,
182,133, 48,225,120,187, 49, 36,101,228, 32,154, 34,235, 33, 26,143, 33,181, 88,
 56, 23,105, 70,137, 41,137,169, 65,122,167,118, 72,222,227, 27,123, 30,199, 83,
120,230, 80,  2,  4,231, 15,231,250,255,145, 20,113,178, 86, 28,194, 25,181, 58,
 61, 16,122,111,105, 49,237,207, 25, 33, 81,  8, 50,186,188, 85, 14,  1, 48,149,
 25,122,217,209, 56,206,143,241,230,114, 81,116, 17, 61,124,202,178,107, 50,225,
100,210,169,205,184, 45, 37, 17, 17, 17,113,106,225, 20,  4,  4,196,175,244, 14,
 73, 90, 45, 40,243,112, 54,189, 90,123,225, 27, 45,184, 43,210, 15, 96,184,217,
 29,165, 81, 58,197,114, 21,184, 64, 11, 18,186, 82,131, 39,185,236,192,196,146,
 92, 21,204,  6,163,201,192,107,194,161, 92, 26,104,185, 46,154,235,192,  6, 51,
192,152, 48,142, 63, 77,115,156, 52,119,142,111,237, 46, 22, 72, 72, 72,128,188,
119, 69,188,125,169,  8,136, 79, 94,126,152, 66, 19, 52,127, 17,223,184, 93,176,
141,  5,227, 72,164, 67,208,196, 91, 91,201,253,241,153, 17, 81, 96, 64, 64, 57,
182,214,176,125,115,198,129, 19, 12,  1,102, 99,193,137,134, 57, 31,210, 70, 65,
183,154, 36, 88,233, 65, 50, 18,209,180,200, 53, 12,  7,124,209,195, 82,235,123,
 49,103,238, 16,192,244,171,180,239,108,132,232, 98,146,190, 83, 31, 75,250,181,
177, 40, 25, 14,164, 92, 44,104,109,174,202, 39, 41,238, 31,222,153,  6,129,214,
168,129,173, 67, 36, 51, 34, 34,  5, 73, 10,146,198, 49,  8,130, 64, 28, 13, 90,
135,118,194,200, 68,205, 67,136, 41,  3,137,140,140,  4, 34,129,136,132, 18,136,
 40, 39,133,213,  1, 84,212,161,149,126, 75,  0,190,167,224,110,116,219,123, 50,
152, 40,150,194,187,168,145, 94,228, 24,179, 59,234,183, 40,176,  9, 61,214, 49,
 88,208,227,138,  6, 97,  0,176,137, 96,190,243, 47,157, 94,115,209, 78,  2,  4,
232,156, 40,189,234, 29,202, 83, 39, 46,183,209, 60,126,223,240,105, 78,117,244,
 78,197, 17, 73, 64, 30, 45,232, 48,251,235, 21,249,231, 66,236, 82,224,173,174,
121,128, 33, 23,108, 47, 46,140,103, 91,180,186, 30,246,219, 40,112,  1, 71,236,
 94,196,  3,181,212, 69,189,199, 33, 21,154,145, 60,178,137,148,167, 94,170,208,
 52,176, 50,140,122,  8,222,122,112,153,155,156,209,177,  3,  4,164,187, 94,191,
 48,125, 66, 63,  1, 86, 78,208, 60,131,205, 47,226,  6,142,209,126,141, 49,240,
117,102,102, 11,140,129, 10, 30,159, 57,122,251,158,229,159,150,174,241,104,141,
142,251, 44, 45,192,205, 13,212,  4, 66,247, 64,130, 32, 74,  6,177,102, 66,106,
139,  8,210,181, 35, 35, 41,174, 82,127,187,133,143, 92,162, 41,214,236,173,229,
109, 98,192,102, 59,238,151,170, 59, 80,100,157, 56,150,105, 77,104, 23,159,191,
237,168,220,251,149, 84, 34, 39,100,199,223, 88,222,193,211, 81, 56,241,168, 11,
138,223, 63, 68, 54,116, 69, 85,100,200, 94,106, 64,131,126,188,182,208, 16,183,
184,149,216, 67,147,197, 95,159,213, 53,221, 91, 82,218,138, 86,148, 77,177, 32,
100,  1, 60,255,103, 99, 66,201,200,214,185,204,105, 59, 48,180,226, 17, 96,160,
  3, 85,189,153,222, 11, 15,182,168,215, 25,222,186,145, 61,134,255,143,217, 21,
145, 17,239, 18, 57,167,142,198, 80, 62, 16, 60,245,100,181, 83,137, 72,198, 69,
140, 64,176,142, 26,179,224,181,195,209, 60,239,209,118, 40, 35, 11,237,191,146,
104,238,  6, 28, 68,146, 75, 68,111,126,236,136, 18,166, 72, 56, 67,198,233,  9,
224,255,142, 39, 84,111,222,195,214,254,247,153,110,130,223, 22,195, 10,148, 77,
194,234, 81, 22, 48, 20, 59,228,227,203, 80,146,247,241,224,199, 12, 24, 90, 95,
214,107,172,244,158,215,  4,205, 30, 60,136,169,143, 55,193, 59,105,150, 14, 83,
193, 16, 67, 98, 36,173,233,121, 38, 59, 23,170,234,124,167, 50,240, 74,107,223,
164,158,170,122, 19,140, 14, 68, 75, 78, 98, 15,116, 65,234, 40,229,141,100,227,
124, 43,  0, 64,199, 13, 26, 73,194,236,156,124, 26, 21, 12,158,113, 58,125, 95,
203,201,195,166,176,247,211,156, 52,209,210, 68,127, 50,240,253,223,170,150,188,
190, 24,105, 57,209,183, 98,227, 86, 70,111,240, 11,170,136, 68,104, 42, 45,180,
158, 17,155, 97,192, 50,184, 26,210,245, 58, 10,115,182,220,164, 50,141, 42, 51,
239,254,185,219, 71,114, 91, 66,226, 81,144,239,181,168,  3,135,146,240, 42, 45,
165, 28, 64, 11, 11,121,221, 97,143,202, 58, 71,149,179, 63,106, 13, 38,236,  6,
 18, 99, 65,233,135, 52, 93,210,196,246,101,204,156, 23,232,200,167,136,213,  4,
 55,148,192, 66, 68, 30, 87,122,184,138, 25,173,195, 13,124,179, 82,233, 83,122,
106,220,152, 12,247,154,162,128, 74,162, 74,112,141, 81,157,154,110,191,  7,174,
150,246,235,144, 88,176, 45,  5,184,106,114,239,  6, 34, 68,140, 70,254, 36,156,
  0,133,  1, 91,182,  0,232,191,  0,189,231, 38, 12,181,119,190, 18, 40,166,138,
226,165, 17,152,  3, 29,143,  0,230,143, 29, 89,181,217, 24,  1,193, 65,169,192,
174,161,104,226,153,196, 48,126, 18,205,121,201,105, 55,111,218, 93, 80,192, 83,
236,196, 33,193, 43, 71,247,231,  7, 62,234,253, 92,200,165, 63, 24, 18,101,104,
114, 39,154, 60,176,  6,176,173,135, 45,130,117,142, 37,200, 66, 87,148,252,218,
113,250, 40, 43,244,109,184, 66,160,100,238,  6,101,236,110,130,233,203, 11,160,
  2,149, 18,140, 32,128,241,139,  7, 72,102,236, 63,229,151,221,154,148, 53, 44,
 54, 54,189,231,182,154, 30,102,167, 69, 91,156,203,177,227,172,230,138,218,244,
179,201,134,120, 10,210,246, 97,242,145,229,223,230, 29,238, 31, 47, 15,207, 23,
231, 92, 90,122, 10, 47,224, 98, 65,247, 55,200, 73,110,101, 67,130, 54,102,220,
157,191,224,105,131, 66, 52,233,226, 96, 76,112,224, 30,214,207, 20,252,202,126,
116, 29, 12,  7,236, 77,234, 28,233,205, 29, 65, 70, 76,224, 43, 39, 72, 35, 34,
 44, 80, 92,150,217, 59,  3, 40, 89,151, 97,220,114,199, 81,229,185,167,138,204,
244,122,137, 71,118, 41,162, 95,235,220, 36,150,130,181,233, 22,145, 22,204,206,
173, 57,171,  7, 11,130, 81,137, 12,138,136,213,140, 31,140,142, 27,106, 81,215,
 36,219, 59,230,  3, 43,243,167,155,156,170,138, 32,225,205,117,  4, 24,149,136,
 90, 41, 26,104,  2,
} ;

// ../CUDA/select/template/GB_jit_kernel_cuda_select_bitmap.cu:
uint8_t GB_JITpackage_29 [940] = {
 40,181, 47,253, 96,117,  7, 21, 29,  0, 54,108,137, 40,192,148, 85,  7, 84,178,
 46,159,126,215, 43,131, 77,181,247, 66,208,244, 83,143,100,154, 73,246,141, 50,
136,  8,  0, 56,188,164, 40,246,223, 20,  5,174,226, 92,123,  0,127,  0,125,  0,
 21,197,122,105,214,150, 22,155,169,155,255,159,226,196, 49,173,252,177,159,236,
122,138,182, 53,230, 24,252, 54, 61,144,239,114, 82,228,113,163,221,233, 67,243,
 56,209, 38,185,146,  2, 72,161,118,208,240,208,116,134,219,133,114, 11, 53,  4,
110,201,125, 29,119,192,121, 11, 57,141, 78,135, 93, 24,121,220,  2,195, 71,192,
101,110, 54,248,133, 94, 29, 45,131,204,150,149, 63,207,211,206,154,252, 64,238,
 36,253,136, 78, 48,156,166,202, 59,157,106,175, 43, 36,177,153,205,153,206, 14,
222,  4,  2,213,235,216,102, 29,209, 23,116, 83, 51,121,233,160,180,113,182,217,
 79,248,229, 31,243,199,138,116, 33,101, 14,  4, 12,241, 42,125,239,  8,149,241,
154,206, 53,225,161, 98,252,228,151,139,104,104,136, 46, 23,129, 42,139,140,147,
 89,140,179, 85,199,220, 40, 87, 94,194, 24, 84,167,226, 47, 47, 85,223,109,109,
214,  6,185,238, 78,126,129, 52,178,173,168,103,172,231,179,152,198,115,129, 46,
 77,124,199, 20, 16, 97, 12,172, 95,222,161,183, 34,107,242, 94,  8,146,137,154,
 62,104, 72,106,145, 73,131,212,211,  2,  9,191, 92,166,248,230, 66,144,235,155,
 52,154, 85,182,200,187,215, 79,160,222,108, 45,220,184,126, 85,134,112,203,111,
106,179,171,252,222, 96,216,253, 76,231, 47, 82, 25,132, 31,145,121,170, 44,244,
  1, 89,112,192, 73,106,144,147, 32, 84, 59,119,248,117,158,118,  4,132,146,146,
202, 21, 10, 10, 78,197,107,132, 50,207,181, 18,159,189, 46, 58, 21,198,102,216,
149, 33,120, 80, 12,252,155,156,146, 87, 56,164,179, 73, 78, 81,223, 41,162, 42,
190, 90, 81,102,  3,192,241,109, 92, 10,110,249,247, 74,124,211, 84, 50, 85, 78,
 97,216,101, 89, 23, 88, 60,173, 97,115,165, 84,167, 88,241, 24, 12,230,148,132,
 83, 44, 22,203,193,120, 30,153,212,171, 36,141,138, 96,157,228,218, 24,245, 90,
175,  6,101,167,121, 19, 95,241,177,224,104, 42,172, 79, 39, 67,141,128,241, 12,
221,220,176, 10,171,202, 92,155,158, 30,159,236, 19,  2,109,102, 93,157, 11,219,
206,229,  9, 93, 21, 91,105, 46,172,205, 56, 20,  1, 86,192,105,229, 46,241, 68,
161, 34, 65,140, 24,203,183, 77, 46,168,205,206,107,121, 82,207,144,131,220,114,
251,194,128,168,168,161,157, 66, 10,137,140,204, 40, 40, 76,146,229, 48,132, 16,
196, 88,217, 14,162,184, 48,220, 65,157, 49, 19,140,205, 72,138,203, 76,101,143,
 53, 81,103, 32, 76,108, 60,181, 17,194, 52, 65,160,112, 20,111, 59, 73, 74,151,
  5,182, 38,146,191,186, 80, 97,148,114, 62,114, 19,122,177,134,195,212,173,221,
200, 88,149,195, 89,  8,242, 91,197,133,223, 69, 56,144,255,119,191, 42,154,184,
132, 72,156, 96, 24, 81,234, 17,205,142,156,203,168,117,190,117,166,200, 41,138,
167, 92,142,146,  2,146, 22, 32,149, 38,110,156,123,211, 58,134,171,  1, 21, 83,
175, 41,  9, 67, 51,113,124, 37,234,199,  3,226,245, 10, 51,178, 37, 18,232, 73,
150, 14,103, 51, 67,204,213, 75,212,126, 98, 33,207, 43, 41,126,240, 70, 56, 82,
213,114,216, 78,164, 77,255, 22,157, 13,238, 19,158, 77,132,208,232,186,125, 82,
129,121,211,163,212,205, 60,108, 49,213,209, 39,128, 57, 91, 22,236,145, 84, 96,
131,134, 16, 84, 64, 27,198,125, 69, 81,138,  6,140,194,131,112,129, 76,163, 38,
126, 19,126,181,195,226, 50, 63, 28, 27, 20, 72, 40,197,  0,141, 60, 49, 90,182,
108, 86,116,202, 83, 95, 58,194,242,112,123,154, 39,140,103, 89, 66,229,205, 30,
215,141, 12,202, 34, 33,232,148,192,172, 82,209,186,188,209, 37,145,105,150,130,
225,196,205,147, 68,  6, 49, 15,136,112,242,180, 21, 80,217, 79,109, 64,229,102,
  3,104,133,112,188, 42,253, 12, 19,123,206,119, 91,118,232,192,242,215,118,247,
 21,224, 54, 36,  1,  9,189,  9,135, 49,  1,  8, 72, 55, 37,168,166, 98, 32, 72,
147, 51,231,189,147,130,179,243,238,  8,221, 80, 98,138,128,  1,153,124,184, 10,

} ;

// ../CUDA/select/template/GB_jit_kernel_cuda_select_sparse.cu:
uint8_t GB_JITpackage_30 [8096] = {
 40,181, 47,253, 96,207,156,181,252,  0,106,180,252, 32, 46,144,142, 89,231,122,
157,180,221,238,114,248,  0,107,170,246,248,168, 19,206, 23,195,163, 61,178,232,
124,151,115,199,143,254,231,185,  1,195, 67,190, 42,  0,  0,  0,  0, 98, 68,  2,
 33,232,  1, 34,  2,253,  1,247,134, 90,127, 22,148, 34, 16, 95,222,203, 51,244,
174, 59,243,114,184, 49, 85,140,158,213, 94,161, 15,191, 64, 92,163, 31, 28,170,
 30, 24,110,218, 50,105,183,173, 36,243,215, 19, 27, 72,251,208, 57,234, 60,138,
180, 56,113,190, 50,227,107, 14, 19, 85, 97,249,  6, 37,190, 53,227,  6,181, 44,
209,236, 51,208, 47,223,208,172,132,174,241,188,  5,210,180,236, 96,189,158,119,
 61,109,215, 76,249,136, 74,176,111,164,245, 77,107,215,125, 97,229, 14,186, 53,
 68,101,  1,174, 73,191, 40, 27,230,198, 91,115,243,195, 27,168, 59,140,211,196,
117,  7,149,174, 79,253, 26,166,182, 48, 49,136,134, 30, 55,121,196,  2,165,210,
  5,109,144,204,167, 38, 48,196,239,142,153,229, 23,130, 33,119,249,219,217, 35,
165,107, 87,182,181, 18,119,221,244,121,190,111,103, 31,121,156,236,227,239,235,
124,143,155, 94, 72,222, 43,111,101,197,101,197, 57, 83, 15,222,234,121,238,207,
 94, 78,162, 44, 78, 89,241, 35, 40, 59,206, 92,120, 51,166,149, 59,158,255,179,
109,208,168,233,  4,111,231,238, 94,243, 99,215,148, 74, 14,191,175,196, 77, 91,
 30,155,164, 91,152,131,  6,134,118, 61,226,198,210,179,175,188,102, 58, 79, 67,
181, 59,  6,201,190, 29,208,203,243,214,207, 39, 67,245,203,141, 35, 36,218,105,
 28,101, 11,246,115,165,199,179,163,242,177, 98,207,188,165,235,175,  3,134, 28,
239,206, 71,217, 69,243,102,  9, 62,135,150, 78,206, 79,105, 96, 80,188,189,124,
 90,255, 41,147,254,203,181, 31,211, 32,219,108,160,108,210,240,238,168, 96, 95,
 12, 83,241, 32,147,224, 13,147, 83, 88,100, 42, 50,156, 55,157,158,238,  2, 64,
 42,234,146,180,199, 73,155, 29,187, 61, 61, 51,211,238, 50,146,198,180,185,169,
145, 60,152,192,160,186,238,184,141, 59,227, 56,123,159,153,241,239,203, 30, 31,
174,234,146, 20,176,170,235, 19, 39, 61,226,217, 33, 39, 78,101, 31,121,185,130,
147,243,136,109, 58,207,112,  3,105,124,165,197, 91,230,250,107,188,201, 46,228,
182,175,233,109,208,150, 39,199, 38, 65, 49,233, 44, 63, 11,118,158,100, 19, 26,
218,100,147,105, 36, 60, 43, 47,197, 39, 19,136,100, 50,  9, 93,227,144,134, 87,
246,199,253,131, 99,129,217, 18, 92,108, 24, 13, 77,214, 96,227,108, 48,156,234,
241, 22, 71,156,210, 61,191,204,108,102,166,232,101,210,179,205,227,200,236,236,
 59,241, 20,117,135,196, 54,123,140,153,  5,101, 89,196,242, 75,103, 73,176,204,
158, 78,153, 59,201, 69,250, 35,151, 73,126,  3, 30, 99,180,153,244,  8,136,236,
201, 88,126,160,109,  4, 90, 32, 46,207,248, 78,143,109, 91, 63, 92, 25, 58, 99,
  9,195, 36,162,192, 57,209,205,251,249, 37,  2, 65,137,186,140,244,101,183,220,
193, 63,176,229,123,127,164,  5,155,131, 97, 23,104,157, 52,236, 13, 70, 70,230,
 96,179,200,180,205,182,177, 60, 34, 70,136,203,223,201,170,105,144,192,176,141,
237,147, 92,213,108, 91,215, 87,122,120,219, 38, 73,122,195,  8,  2,  4,145,232,
129,231,113,100, 40,216, 54,153, 45, 27, 48,224,211,130, 57,103,198, 78,146,205,
 50, 55,111,198,125,183,205, 18, 33,201,126,249,244,  5,155,197,197,182,153,176,
192, 96, 96, 38,164,123,120,124,146,178,231,254, 64, 46, 64,166,188, 57, 84,242,
168,  1, 18, 43, 54,137,139,117, 93,  5, 35,206, 54, 58, 55,106, 45,137,132, 91,
145,216, 80,245,135,202,187, 97, 73, 40,170,146,112, 80,180, 64,101,  4,101, 13,
199, 96, 64,224,108, 19, 24, 11,138,204,102,227,200, 48,156, 67,155,195, 42, 65,
186, 89, 59,190,109,159,236,212,239,179,109,155, 68,124,168, 28,226, 94,174,157,
 28, 78,215,117, 77, 19,105, 34,195,100, 40,224,108, 25, 24,140,109, 83,129,225,
100,176,  9, 75,  7,103,  7,226,234,215,201, 45,143,193,206,243,186,174, 11, 82,
145,153, 96,160, 93,104, 36,182,139,226, 66,179, 97, 54, 25, 27, 71,195,104, 48,
155,205,194, 68,200,108, 24, 88,104, 40,208,168,219,159, 43, 63,174,111,198, 33,
120, 59,202, 29,126,178,195,227, 68,157,105,102,122,160, 60, 60, 84,164, 63,200,
 42,182,138,197,177,200,104, 28, 34,191,107,108,209,104, 50, 26,126, 80, 40,215,
101, 89,150,111,143,213,230, 96,128,116,  8, 25, 23, 21,152,138, 95,128, 76, 56,
 70,203, 48, 54, 12, 50, 46, 28,108, 24, 76, 70,  2,207,236,104,  7,160, 60, 17,
147, 78,200, 65, 96, 31, 73,252,216,248,235,175,122,206,224,133, 28,197, 16,126,
 28,157,150, 99, 27,214,251,217,170,164, 16,  8,213,221, 12, 73,154,155, 29,183,
 30, 12,165,217, 87,218,209, 55,177,228,158,195, 78, 39,251,246, 23, 71, 95,166,
 29,  4,142,229, 29,174, 42, 79,233,160,156, 93,116,216,196,215,219, 22,104,165,
199, 19,199,148,146,167,113,181, 54,196, 63,134,161,110,119,192,144,254,147,119,
 86,252,174, 59, 74, 39,157, 51,203, 99,214,117, 73,183,166,  9,131, 56,128,212,
 80,121,184, 30,167,201, 55,155,147,176,116, 10, 56, 59,233,156, 12,204,102,147,
 61,200,174, 75,155,186,198,179,163,111, 68,196, 47, 24,100,194, 83,186,118,233,
 19, 26,140,  2,139,141, 66,185, 64,112,215,101, 69,166, 40, 93, 36, 65,203,202,
155,229, 26,141,134,197,230,224,154,175, 30,154,233, 43, 63,206,179,137,102,135,
171, 96,132,228,114,207,182,117, 95,207,134,129,150, 73, 96, 40, 48, 22, 26, 25,
152,214,153, 57, 26,122, 14,226,100,231,107,112,230,208,182,189,191, 78, 88, 59,
233, 23,156,139, 12, 12, 13,198, 34,  3,195,128,147, 89,192,160, 49,156,222,206,
162,206,184,122,143,145,136,213,106, 71, 67, 58, 61,182,179,196, 19,  4,170, 52,
 43, 85,218, 69,211,180,140, 61,207,227,176,214, 90,177,113,168,221,182, 35, 15,
207,190,242,149,138,165,233, 43,125,205,253, 85, 47, 52,111,232,186,174,107,218,
 56,132,102,181,234, 26,119, 93,213,113,227,112,131,214,107,215,117, 85,149,198,
 57, 56, 84, 32,109,242,241, 85, 47,106, 86, 52,181, 42,179, 81,212,154,197,109,
195,142,164,221, 29,233, 29, 63,210, 14,203, 80,115,116,226, 99, 42,123,250,171,
249,163,175,179,156, 93,131,224,196, 50,212,244, 50,207, 91, 32,164, 75, 94,101,
 44,153, 44,169,250, 53,123, 90,103,158,184, 90,145,197,  2, 89,192,145,173, 28,
  0,145, 72,116,177,  1, 96,185, 68, 98,153,166, 54, 45,  9, 30,157,162, 13,246,
229,186,123,197, 49,114,185,102,187,234,229,  6,187,198,178, 35,177, 50, 13, 43,
199, 53,173, 31,117, 60,211,195,143, 92,140, 26, 37,138,180,199, 73,249,160, 42,
 18,231,198,150,174,239, 12, 43,244,125, 79,213, 39, 41,166,159,137,177,252,120,
254,181, 46,249, 37, 66, 77,151,152, 55, 25,106,202,167, 38,202,129,  4,122,164,
  1,116,208, 52,186, 21,108,240,151, 89,118, 88,194, 57, 58,194,212,116,233,219,
 54,105,232, 44, 63,125, 63, 31,185, 97,213, 71, 36, 50,223,128, 97, 27, 19,171,
102,180, 36, 17,138,194, 85,190,210, 62, 16,200, 71,254, 66,220,215,211,162,173,
120,149,138,131,101, 69, 12, 64,166,138, 84, 89,175, 96, 16, 15,143, 83,240, 76,
111,138,108,180, 63,207,139,147, 68,129,125,193,190,  9,190,142,148, 92, 47, 90,
233,245,195,195,191,113,135,138, 78,207, 67,107,218,131,195,229,224, 64,161,228,
 35,142,147,244,215,188, 65, 69,110,163,178,172,  9, 53,223,157,106, 60, 67, 85,
125,180, 64, 90,103,142, 18,246,189,197,130,228,121, 60,127,251, 67,235, 55, 81,
 40, 87,135,186, 75,185, 40,229, 98, 65,225,150,  4,244,255, 30, 63,182,242,131,
 77,210,253,190,153,113,215, 93,135,177,167, 47,189,160,213,226,190, 87,195,243,
182,199,226, 88, 20,138, 18,165, 73,218,176, 34,182, 38, 76, 58,182, 40, 20,142,
 98,201,126, 25,201, 44, 79, 25,122,237,176,139,137, 11, 10,103, 44,111,127, 53,
111, 54, 24, 77,211,216, 84, 47, 87,122,203,252, 39, 61,143, 18, 34,138, 71, 77,
146, 26,133,187,240,103,222, 26,106,122, 57,166, 97, 55,229,237,162, 80,209, 51,
 17,220,139, 31,  1,158,214,198,129,138, 67, 37,234, 83, 73, 89,218,149,179, 73,
186, 13,177,235, 12,116,  2, 22,218,143,116,174,241, 63,  2,142,209,  9, 12,210,
 61,153,206,107,243, 37, 18,173,119,180,217, 76,247, 98, 50,150,154,220, 20,210,
 25, 92, 68, 58, 27, 38, 82, 68, 68,  4, 40,251,102,252, 88, 61, 70,  8,204,186,
  2,205, 66, 35,211,124,163,129,162,254,200, 39,139, 10,229,151, 27, 87,214,132,
 39,142,198,133,116,122,195,220,247,146, 46,107, 13,120,156, 36,169,201, 42, 40,
202,209,156,113,188,221,209,161,170,160, 43, 50,158,162,254,100, 73,183, 79,221,
254, 72, 42,193, 87, 84,100,212, 57,250,104,165, 54,178, 44, 67,137,178, 73,219,
104,210, 99,168,222,238,124,102,183,111,197, 85,226,190,182,175,228, 86,137,115,
227,174, 46,139, 18,170, 52,227,249,189, 27,123,120,128,186, 78, 94,213, 84,105,
119,151, 72, 24,  4, 19,101,241,213, 39,159,109, 84,183,223, 53,136,235,158,183,
 44, 15,203,163, 18, 89, 82,114,137,199,  1,138,129, 23, 40, 96,192,195,227,154,
  6, 34,244,216, 55, 30, 44,203,250, 15, 20,120,133, 82, 93,130,205,164,202,131,
  3,229,151, 85, 29,155, 38,166, 96,248, 85,238,107,239,209,128, 85,128,193,131,
 65,126,221,197, 41,138,  7,168, 52,180, 43, 84,169,132,136,132,  4, 16,  0,  2,
  8, 35, 81, 24, 20, 18, 14, 78,230,114,185,100,228,116, 36,227,197, 24, 13,155,
 68, 76, 69,241, 65, 48,138,  2, 35,140,130, 32,138, 97,128, 16,  3,  4,  8,  0,
100,136,  1, 99,192,210, 12,238, 47,246, 40,205,116,246,182, 36,  5,230,190,171,
211,  9,206,202,221, 30, 52,201,174,226,206,220, 40,167,191, 69, 45,224, 52,130,
228, 51,226, 50,  4, 84,108, 20,207,107,203,130, 13, 34,126, 22,172, 38,161,128,
210,117,169,221,140, 22,118,116,203,236, 44, 62, 21,100,245,254,107,165,  0, 41,
 98, 17, 32,128, 81, 23,154,225,137,222,139,127, 27,253, 48, 22,207, 99,156, 54,
145, 83,123,211,133, 53, 24,251,208,148, 92,247,205,237,167, 74,183, 89,158,  9,
148,155,202, 93,203,154,  6,136, 19,210,210, 63, 20, 98,234,160, 93,238, 74, 28,
 83,218,163, 48,101, 34, 87,155, 96,118, 21, 68, 65,165, 51,250, 89, 90,204,201,
241, 52,112, 53,170,102,251, 54,125, 80, 37,200, 90, 62,253,  5,145,157, 22,141,
  5,136,202,224, 91,196, 35,111, 25,231,212,164,  1,104,205,197, 12, 68, 44, 97,
181, 94,226,233,100, 71,102,141,137,206,246, 25,194, 10, 38,  7, 56,243,138,158,
 89,208, 36, 90,147,175,153,236,118,236,208, 45,147, 59,104,206, 75,117,237,  0,
135, 79, 28,195, 24,118,  8, 33, 22,140,219,215,140,201,158, 81,203,239,101,174,
199,178,208, 67,247,151, 92,108, 34,200, 26,  3,241,128,110, 40,244,210,231, 37,
  8,154,  6, 56, 95, 59, 26, 15,184,229,164,  1, 38,217,105,163, 74,135, 16,209,
212,134,  9,224, 40, 61,176, 32, 95, 94,153,108,134,149, 10,249,245,190,165,250,
113,102,110,190,173,  8,198,156,135,192, 39, 89, 17,154, 18, 53, 72,148,223, 58,
 36,217, 75,170, 82,120,121, 23,186,247, 68,201, 20, 22,238,230, 19, 43,172,247,
170,158,181,203,137,222, 47, 32,225,124, 54,164,217, 13, 32, 33,  2,199,192,210,
 32,220,219,106,248, 53,130, 46,243,116,157,230,148,106, 22,106, 38, 63,226,220,
185,  0,240,163,184,170,136,206,228, 93,252,184, 47,122,  9,228,165,210,  2, 41,
 20, 79,222,187,221,184, 20, 93,219,246,242,241,229, 36,161, 38, 25,220,140, 64,
120, 43, 61, 86,131,183,251,162,177,172,212,101, 55, 16,155,139,195,119,125,136,
252,124, 11,172,181,144,115,252,  5, 74,197,233,125,220, 99, 72, 77, 67,172, 34,
 38,218, 91,134,243,  5,194, 33, 12,134,  0,203, 14,152, 21,252,189, 32,132,176,
 35,177, 95,248,194,151,200,247,  8,109,100,136,236,225,183,206,120,151,101, 85,
 52,  3,  1,187,158,138, 30,187,164,105,104,223, 70, 95,121, 70,216, 41,243, 70,
 96, 63,203, 42,176,  2,226, 25, 63,151, 62, 34,199,209,230, 84, 84,175,158, 65,
124,145, 38,222,135, 56, 87, 21,  4,243,223,188,214,  3,190, 92, 64,106, 17,202,
187,248,152,247,202, 19,155,176, 57, 33,191,196,165,150,203,142, 95,130,170,114,
248,146,236, 49, 89,168,199, 75,152, 65,106,  5, 72,  9,207,204,137, 75, 84,160,
132,196, 14,255,170,186,132,127,204,147,  5,170, 21, 96,205,109, 64,185, 46,110,
  6,192,  2,172,126,226, 74, 57,242,234,118,116, 22,188, 82,130,249,159,  2,  7,
228,117,165,177, 67,170,226, 66,163,132,239,151,197, 87,181, 22, 17,201,233,254,
131,  1,221,100,251,157,  0, 27,  7,169,187,242, 20,252,106,216, 26,224,166,233,
249, 89, 98, 18, 50,246,184,132, 60,132, 75,195,120, 56,152,200, 51,106,116,233,
244,239,175,205,158,124,121,155, 61,132, 66, 79,  7, 95,189,224, 42,113,171, 47,
 42, 44, 87,221,229, 13,243,241,251, 47, 45,150, 93,203,112, 75,149,136, 57,103,
 37, 40,246,110, 80,172,123,150, 27,199,157,237,230, 49,175,156,157,186,107,120,
134,220,  8, 47, 53,240, 66, 49, 79,153, 47, 70,224,164, 55,100,105,239, 34,116,
222, 31, 77, 54,  5,240,121,  0, 11,128, 80,  2,188, 12,  0, 83,198,216,247,100,
 23, 19,205, 97,215,228,147,  3,  5,119,177,131, 41,144,129,185,111,119, 67, 23,
 30,115,251,147,217,210, 60,215,175, 35,195, 24,231,  4,147,221,207,217,206, 91,
167,142,191, 43, 39, 46, 34,149,129, 85,190, 89, 16,114,170,162,158,122,175,246,
169, 88, 85,171,105,161,247,172,154,184, 72,219,132, 52,188,110,191,199,119,136,
255,201, 32, 63,222, 67, 58, 89,128, 45,203,116, 96,153, 70,222,147, 29,121, 28,
 22, 92, 79, 38,180, 93,185,173, 13,191, 16,  3,  6,253,164,170,  6,249,208, 22,
 11,221, 59,131, 41,228,214, 30,111, 37,190,  9,196, 63,150,199,179,204, 36,216,
221,130, 15, 98,  6,121, 35, 25,106, 17, 17, 20, 96, 66, 35,190,125, 79,245,126,
129, 47,  8,199, 17, 45, 65,216, 35,147,194,245, 88, 75,178,121, 99,252, 19,246,
180,148,211,182,139,126,212,169,101,231, 88,180, 68,135, 41,164, 24, 22, 42,120,
  5, 51,  5,150, 24,111, 25, 21, 84, 30,226, 11, 42,187, 73,159, 25, 27,104,113,
173, 32, 35,103,186,196, 69,173,180,252, 64,132,113,111, 59, 58,213,135,201,175,
155,224, 56,192,149,242, 23,214,154, 62,210, 86,195, 26,159,118,157,189, 80,127,
208, 27, 75,142,195,246,164,197, 93,114, 46, 86,197, 77,  1,120,233, 47, 51,105,
202,  9, 26, 30, 85,  5,179,155,  0,204, 78,224,235,177,107,114,213, 78,156,205,
223,129, 75, 31,145,  0,144, 10,159,245,107,130,121,173, 90, 88, 25, 59,175,118,
 97,140,194,223,183,174,176, 83,  0,113,115, 50,178,176,235,150,252, 89,174,156,
 93,240,187,155, 27, 28, 72, 76, 53,202, 32, 13,191,171, 53,  8, 51,225,177,217,
 29, 48,185,213,118,  9, 69,  9,149,185, 36, 68,107,169, 14, 44,  9,  9,  0,133,
177,105,225, 33, 84, 22,  0, 10,213,142,189, 17,197, 66,176,197,145,188, 17,205,
 97,165,252, 67,230, 14, 40,196,180,248,120,113,111,  4,117,230,118, 94,  3,181,
100,123, 79,122, 43,202,  3,133,230,222, 72, 94,127,187,128,220,103, 37,186,121,
212,180,213, 29, 40,101,249,140,248, 13, 93,190, 50,127, 74,  2,  4, 43,213,  1,
198, 19,183,230, 45,100,160,169,  7, 57,  1, 22,187,207, 38,167,203,  9, 85,196,
162, 64, 34,116,204,231,145,197,170, 30, 89,100,138,239, 38,244, 98,186,145,209,
126,217,212,138,111,209, 64, 76, 68,145, 77,112, 42, 19, 17,105, 98,192, 64,226,
205, 94,242,220,192,102, 85,117, 72,144,138,250, 83,239, 67,143, 96,183, 50,155,
 96, 70,248,200, 36,118,250,117,134,203, 79, 27, 91, 76,167,132,247,142,154, 86,
229, 45, 34,150,  2,220, 72,231,202,165,191,192,121,248,235,170,  1, 64,  8, 62,
224, 25,215, 30, 48,243,176,  3,176,189,195,195, 48, 35, 80,109, 79,126,  0, 92,
153,160, 92,228, 86,196, 87,169,250,224,221,118,118,228, 64,191, 72,  2,151,172,
237, 88,174,110, 74,222,108,110, 25,171,182,124,105,216, 84,194,146, 65,  8,181,
 42,106,114,141,236, 54,151, 63,115,103, 17,240, 97,233,229,124,237, 80,236,219,
 60,120,182, 15,189,124,177, 18, 50,173,155,181,130,176,167,148, 12, 20, 79, 30,
 99,145,137, 32, 93, 74,214,235,212, 42, 59,  9,249, 61,255, 95,241,110,141,190,
210,192,  6, 10,248,104, 23, 31,187,  7,163, 67,197, 39,204, 87,253,143,111,  8,
 87,208,211,200, 65, 88, 18, 95,233,221,153,245, 52, 28,122,243,244,128,113,166,
248,133,167,253,203, 38,144,142,233,166, 72,237,228,111,104,  6,196,120,155,158,
124,147, 12,226, 12, 90, 65,  6, 50,149, 58, 47, 52,220, 76,200,171,116, 36,  3,
251,183, 93, 97,204, 80,128,139,193,209,  6,169,184, 16,202,239, 41,219,246, 16,
231, 27,146,148,  5, 52, 32,126,123, 61,238,223, 10, 72,140,109, 51,161,249,212,
131,204,194, 84,124,215,210,206, 74,114, 92, 57,100,140,156, 80, 70,  6, 36, 59,
 90, 86, 66, 23,124,109, 73,244,121,112,218,127,143,120,  9, 76,173, 84,102, 11,
 64, 57,100,225,200, 80,142,176,120,182, 52, 72,244, 87,132, 69,  4,137,176, 77,
144,174,140, 27,182, 84,146, 81,194, 81,245,198,196, 96, 41,212, 65,164,135,237,
164, 34,253, 57,249,228,176, 38, 61, 90,  2, 34, 87,186,114,255, 17,205, 99,236,
187, 15,176,137, 85,245,181,192, 81, 86,  1, 14,204,195,234,248, 78,102, 58,168,
197,225,177,145,238,212,  8,144,210,151,133,167, 31,232,180, 69,124,189, 93,203,
 39, 33,216,235, 77, 13,107,211, 12,119,167,165,173,137,117,125,116,157,142, 25,
172,254,243,222, 76,  9, 16,142, 80, 21,138, 57,167, 22,175,136,  1,180,243,185,
108,162,203,165,250, 83,162, 68, 39,232,208, 39,134, 32,252,109, 85, 71, 41, 39,
206,124,241,158,231,159,221,151,157,172,202,154, 38, 89,160, 98, 90,241, 18,125,
 58,234,175,200,165,207,171, 77,247, 60,104, 38, 38,159, 21, 73, 68, 89,113,186,
 98, 76,187,153, 31, 19,250,194, 38,140, 39,172,154,168,216,128,168,122,131,107,
123,175,251,  5,238, 50, 15,203,227,144,203, 83,233,246, 24, 21,  0,169,164,160,
 15,201, 19, 41, 58,162, 60, 63,181,249,  5,196,124, 67, 24, 13, 66,166,204, 61,
 71,133,104,108,210,226,127,239, 97,143,159, 76, 50,189,218,255,180,123, 20,188,
  1, 85,248,177, 79, 85,112, 16,228,235, 66,220,184,234,  0,167,253,141,104,195,
158, 42, 21, 73, 91,102, 71,147, 51,224,102, 31, 55,  3,111, 60,155, 99, 49, 79,
210,167, 69, 69,238,  0, 10,250, 84,234,150,229,112,156,142, 24,217,160,190,118,
 40,196, 98,149,161,252,115,128, 74,238,118,211, 76,171,224,  6, 10, 21,  9, 43,
116,138,118, 35, 89,110, 34,161, 40,198, 92,235,241,100,222,150,218, 15,164,  8,
 88,242, 41, 89,216, 93, 59,250,  3, 94,184, 58,223,170,229,195,255,225,192,218,
217,194, 83, 62,213,161,166,172,130, 12, 13, 84, 95, 38, 77, 53,  5,130,103,100,
160, 39,200,168, 49, 79,126,132, 45,207,123,188,203,122,207, 84, 68, 53,253,233,
  0, 17,214, 71, 81, 21,139, 21,166, 59,217,151,  1,121,108, 27,167,232,216,127,
167,222,226, 32,124,145,135, 36, 19, 23,127,163,  5,177, 13,247,174,220,190,240,
173,179, 26,247, 79,194,205, 67,228,136,251,227,234, 74, 54,141, 89,241,207,173,
149,205,104,112, 76, 44,172,137, 55,178, 21, 54, 23,226, 84,147, 76,141,236,200,
 50,101, 63, 58,104,241,163,131,  5,112, 12, 25,254,228,144, 17,187,113, 25, 19,
231,202,129, 38,159, 99,136,162, 23, 76,162,144, 77,160, 97,212,  0,182,213,236,
 84, 53,209,172,196,131,135, 77, 66,178, 25, 43, 12,171,159, 14, 54, 92,178,117,
142,194,196, 63, 74, 19,129,138, 45, 28,159,241,246,193, 56,163, 41,196,192,242,
 38,211,199,184,217,197,232,148,183, 53, 23,228, 17,114,199,194, 38,100,125,216,
138,126, 46,138, 75,247,224, 13,  5,112, 39, 40, 17,185,219, 11, 61,236,165, 21,
178,203,200,254,150,170,109, 86, 39,238, 71, 75, 24, 72,147,173,  4,123, 25,  5,
108,206, 86,202, 69,129,188,135,149,236, 92,118,221,106, 75,222,230,  2, 84, 38,
 30, 38,227,240,215,212, 66,151, 51,103, 52,123,213,232, 49,217,140,126,107,221,
244,160,  1, 80,148,  1,145,213, 40,151, 46,162,100,147, 34,163,  5,140, 60,104,
155,187, 58, 90,186, 17,187,  0,198,161,133, 72,195, 65, 13,135, 36,245, 50, 37,
233, 62,  4,205,212,250,148,159, 13, 89,243,159, 92,159,189,167, 20, 30,195,141,
 36,200, 23,168, 82, 39, 66,146,209,148, 90, 44, 85, 98, 79,247, 46, 76,139,209,
 27,155, 99,107,143,168, 93,143,243, 96,187, 91,142, 85,161,182, 82, 68,217,170,
122,237,116,100, 13, 33,142, 61, 11,120, 46, 17,219, 96,184, 86,164,230,173,116,
 26, 49,165,205, 53,159,234,159,110,125,208, 10, 77, 11, 53,211,194, 75,125,138,
245,206,199,206, 40,242,152,196, 45,201,194, 70,147,221,253,  9,179,177, 17,  3,
110, 90, 89, 58,170, 74, 12,195, 20,185, 79, 96, 96,210,198,214,202, 19,225,100,
 15, 68, 75,133,161, 64,191,120, 34, 42, 88,144,188, 29,227,129,  0,157,207,244,
 38,155, 68,  1,116, 37, 93,104,210, 58,254,159, 43, 89, 24, 65,200,213, 20, 33,
160, 84, 88,252, 22,163, 46,105,238,254,109,246, 19, 70,238,207, 85, 37, 57,122,
248,240, 27, 10, 62, 86, 15,101,234, 72,111,230, 39,133,191,187,209,184,100, 93,
 48,204,138,119, 88,126,102,255,128,255, 80,125, 25,205, 75,216,  9,  9,  0,227,
208,195,157,230, 99,107,173,199, 27, 91,121,103,194,230, 12, 56, 54,182,250, 16,
218,  9,183, 51, 79,236,153, 11, 50,146,130,178,181,203, 27,180,171, 99,202,117,
 67,206,100,  4,209, 29, 37,  9,206,116,152,255, 59,138,172,191, 76, 81,115,119,
228,191,237,165,208,158,217,130,189,101, 96,225, 54, 41, 75, 73,226,108,129, 73,
250,226,224,  9, 77,106, 58,247,115,168, 32,102, 96,126, 72, 74,138,181,171,102,
  4, 19, 42,149, 68,195, 97,167, 28, 64, 89,138, 96,189, 73, 84, 41,105,144,186,
  7, 33,137,103,  1, 62,146, 94,206,255,134, 94, 28,178, 54,127, 93,152,134, 77,
232,166,117, 50,232, 84,213, 43,186,148,193,151,201,125,196, 17, 18,170,216,164,
  0,188,184,253,116,161,163, 54, 11, 17,243,215,197,  4,107, 18,194,169,176,190,
 54, 88,209,138,237,167,179,  8,226, 76, 30,214,141,255, 41,225, 57,200, 53,216,
157, 56,  3,219,150, 50, 65, 95, 56, 21, 85,215, 22, 66, 27,148,165, 73,135, 36,
132, 18,162,186,  7,114, 88,197,125,171, 26,177, 58,139,156,201, 80,158, 14,149,
183,224,232,125,143,123,106,252,  5,137, 30,  4, 99,182,198, 59, 73, 33,129, 65,
222, 99,107, 48,130,142,119,146,191,187,  2,102,175, 43,211, 22,185,192,251,253,
 36,173,  5,121, 93,136,190, 98, 51,  8,247, 22, 95,108, 41, 73, 94,197,164,123,
124, 32, 59,191,  8,102,  3, 69, 30,145, 79,136,  5, 12,208,205,239, 99,178,132,
 11, 76, 90, 47,228,195,114,106,  5,162,156,117,243,132,165,162,109,125,104, 78,
 47,  0,123,116, 38, 64, 77,178, 35,163,239,137, 52, 70,215,173,  5,  3,116,222,
183, 25, 18,237,116,199,130, 11,147,  5,211, 74, 61,233,169,183,227,104,183,114,
250, 46, 43, 34,  3,104, 18, 14,132,219,156,196, 33, 83, 43,216,142,125,112,102,
108, 32,168, 73,189, 42,194,122,239,130,151,139, 52,  9,220, 10,217,129,189, 12,
 97, 91,128,238, 37, 24,219,164,246,  2,176,235,179,  4,194,247,230,184,251,252,
191,204,177,218, 55, 45,226, 99,196,163,131,250, 75,197,220,186, 19, 74,184,190,
 73, 12,196,  0,178,232,209,  7,198, 98, 39,  7,134, 98,136,249,238, 25, 27,126,
 34,172, 55, 75, 44,186,160,145, 86,112, 37, 36,174,128,117,188, 35,185, 47, 89,
 71, 35,226, 39,  1,128, 99,101,193, 68,203, 28, 20,131,233,242,169, 61,217, 64,
 66,  3, 33, 28,142, 88,147,175,222,227,139, 82, 25, 46,148,192,  4,213,183,204,
168, 13,249,138, 76, 46,173,193, 40, 95, 19,113, 25, 59, 83, 49,221,111,121,167,
 27,234, 22,  5,253,189,218,  2,130, 50, 80,216,226,130,118, 67, 86,139,155,228,
 27,  0,233,112,201,220,180,204,119,  7,234,167,118,161, 37,129,254, 27,101,206,
  4, 14,127,123,214,211,165,171, 75, 64,201,233,241,174, 26,240, 42,122,252,  2,
200, 99,160, 84, 82,122,212,  6,158,216,156,  5,174,  7, 65,191,129,163,188,152,
178,141, 59, 68, 92,151, 68, 88,254, 84,207,  2, 21,101,215, 19,208, 11, 21,221,
184, 55,192,177, 81,238, 92,252,  2,101,145,  9,100, 16,194,212,184,170,174,113,
 46,160, 64,143,219,130,170, 67,192, 23,146,231,253, 23,217,155,253,245, 44,219,
 33, 93,212,116,108,169,142,118,210, 97,145,112,240,  1, 22,240,179,124,161,113,
183, 96,118,242, 28,102,250, 26,112, 56,246, 91, 30,232, 16, 48,233,100,124, 92,
227,178,245,164,150, 16,147,159,126,206, 26,165, 56,247, 92,183,212,152,230,137,
 83,122, 97,253,192,101,204, 59, 18,150,  9,219,144, 72,176,  8,211,249, 52,167,
118,116, 72,227, 12,174, 53,  3,197, 86, 58,107,225,233,242,177,234, 79,196,146,
 81,189,  0,221,193,116,141,208, 52,212,183,201,208,233,195, 58,103,178, 41,115,
134, 87,  9,106, 70, 90,171, 70,166, 55, 63, 42, 94,  3,208,188,141, 81,212,148,
109,109, 26,235,195,204,230,185,150,  7, 20,133,252,151,248, 56, 67,109,164,105,
212,105, 54,231,174,175,207,178,141, 29,147,222,213,170,225,228,166,231,130, 64,
 76, 79,148,251,221,222,238,101,111, 55,229, 74,171, 82, 63,234,208,212, 90,148,
 47,158,  8,249,170, 91,219,  3,183,196,169,224, 73,180, 93,224,168, 64, 96, 99,
155, 42,173,110, 52, 78,182,190,148,240,129, 59, 99,158, 90,204,236, 99,233, 42,
 24,152,111,223,224,124, 92,239,172,  9,182,123, 57,111, 19, 16, 87, 37,139, 46,
162, 62,226,157, 71,236,174, 54, 90,166,202, 84,  1,  0,215,203, 85,106,109,238,
234, 22,105, 80,245,241, 36,210, 77, 15,147, 73, 80, 75, 20,197,111, 76,115,141,
190,159,150, 40, 24, 78,149, 48,197,  8,188,181, 78,138,241,205, 17,114, 33, 63,
 17, 39, 66,169,225, 18, 66, 15,249, 48,135,171,  0, 28,160,  0,154,225, 73,255,
213,221,160, 36,255,164,  8, 93,187,131,223, 17, 15, 54,246,219, 82,158, 16,136,
110,  5, 84,226, 49,157, 76, 18,219, 59,103,203,124,231, 58,177,213, 89,240,187,
120, 75, 46,  8,  5, 15,118, 34,163,162,158, 91,  6,221,136,245,152,196,109,203,
249,120, 70,169,195, 77,111, 42,142,203, 50, 62, 72,168, 36,203, 68,157,127,187,
133,152,133,147, 11,  4, 76, 93,187,193, 66,237, 81,192, 57, 10, 57,118, 74,209,
254, 96,101,126,193,251,133, 95,127, 53,174,201, 35,253,  1,140,236,121, 98, 87,
 69,245, 30,208, 22,190,192,179,238,244, 96,241,  4, 38,136,  4,224,204,108,155,
170,163,240, 92,113,243,176, 59,252,148, 60, 21, 69, 74, 79,132,144,233,103,227,
224, 54, 77,145,174, 22, 79,228,101,171,146,108,110,228,136,160,245,163,222, 19,
 74,141,165, 80,178,105,186,214,243,229, 55,180, 45,134,178,123,167,136, 50,177,
205,149,130,123,172,215,106, 40,252,187,  4,128,242, 66,234,110, 17,160, 25, 68,
131, 86, 39,125,166, 95,235,126,165, 79,154,108,228, 27, 27,  8, 21,250, 60, 26,
154, 55, 53, 57, 33, 31,241,131, 53,251,144,230,114, 55,197,163,139,221,211,246,
234,215,148, 15, 16,151, 25, 29,117,122,176, 70, 54,212,199, 82,147, 39,233,108,
216, 58, 18,239,255, 59,221, 19,157, 56,137,156,201, 37, 72,122,206,137, 52,205,
149, 69,195,142,  7, 32,107,207,204,183, 87,240, 79,103, 55, 26, 16,238,115, 79,
150, 38, 35, 36,111,108, 44, 25,211, 75,187,194,118, 82,197,160,134,104,108,131,
129,247,224,169,149,116, 58, 89,138,187, 13,106, 85, 50,237,234,118,117,143, 84,
158, 64,228,214,183,  0,126,128, 64,185, 22, 92,203, 75,  0,246,130, 26,103, 26,
137,179, 14,228,138, 24, 89,164,116,118,217,204,216,164,138,225, 10,120, 52, 20,
221, 92, 46,193,248, 37,117,104,129,137, 17, 97, 59,234, 27,247,185,149,245, 76,
 46,251,137, 85, 68,104,200, 87,226,113,124,139,195,146, 60,127, 70,166, 60, 45,
 86, 61, 73,213,214,  5, 55,225, 30,153,111,147,147,101,200, 56, 80, 34,251,246,
  0,199,123,116, 85,  7,154, 79,166,141,133,148,120,243, 51, 76,200,129,  9, 97,
113,159,169, 69,135,146,  1,236, 34, 68,236, 13, 68,137, 35,128,152,192,157, 99,
 26,186, 64, 73, 20,105, 84,233,164,109, 67,  7,170,206, 86,106,122,124,217,197,
153, 23,242,192,108,245, 82, 66, 68, 92,111, 30, 11, 97, 75,136,161,136,149,145,
140,138,108, 55, 62,160,  4, 97, 69,204,209,181, 50, 34, 50, 30,120, 89, 64, 16,
 12, 40,124, 99,210,187, 26, 24, 54, 35,171,107,198, 47,185,138, 46,139,138,129,
 32, 92,192,226, 81, 66, 71,212, 38, 73,142, 16,105, 14,  2, 66, 36, 34,142, 96,
238, 33, 35, 19,  2, 90, 50, 32,145, 88, 91, 32,225, 64,214,116, 38, 95,228, 26,
129,157,243,179,162,208,238,120, 39, 83, 81,156, 91,136, 50,114, 34, 41,159,142,
 23,224,142, 31,194,104,137,210,116, 80, 84,116, 17, 13, 42,216, 84,124, 48,166,
172, 31, 98, 79, 48,192,131, 33,135,191,112,242,225,243,224,160, 24,154, 79,165,
 54,203,238, 51,187, 27,228, 35,222, 37, 83,180, 20,100,118,203,224, 84,102, 73,
183,148,216,130,238, 39, 19, 52,118,190, 82,224, 95, 45,236,159,171, 61,204, 64,
 54, 17,183,234, 40,163,  5, 46,102, 51, 49,228,193,  3, 77, 79,206, 10,161, 98,
 89,226,171,198,200,246,  7, 54, 22, 69, 54, 30, 71, 48,200,193,193,248,150, 55,
106,117, 81,  4, 15,244,243,  7, 79,129,203,203,153,193,179, 73, 23, 68,116,105,
168, 52,102, 49,159, 23, 71,110, 34,105,251,225,151,110,177, 86,171,  8, 78,216,
109,253,126,235, 31,184,129,205,232, 32,244,119,120,255,120,173,150,223, 87, 52,
 99,109, 13, 91,150, 64,123,245,146, 84,244, 77,212, 52, 64, 39,125,252,  3,  3,
 13,101,194, 76,101, 17,124,229,157,204,102,200,  5,146,170,254,253,156, 54,191,
 37,210,221,102,145, 41,204,114,193, 49,232,  9, 80,217, 92,246,155,123,137,134,
153, 36,101,251,176,232,  6, 52,238, 84,236, 57,196, 36, 81,232, 58,216,171, 53,
 18, 67, 56,238, 93,163, 38,200, 27, 67,170,  7,207,195,  3,218,173,201,118,117,
 16,172,159, 10,236,252,240,108,118, 11,186, 76,235,216, 35,105, 26, 56, 50, 33,
 20, 57,142, 87,177,211,196,195,101,210,106,242,179, 49,139, 57,226,208, 35,  0,
 38,209,220,  6,209,234,196,235,166,142,149,129,133, 54, 28,104,179,229,136, 11,
 94, 16,151, 80, 47, 44,141,121,117,195,154,125, 24,138,226,165, 88,223,134,198,
245, 48, 56, 98,161, 67,186,155,151,140,159,119,165,209,103,246,223, 34, 86,110,
 53,154,235,116,134,169,150,105, 95, 53,240,243,129,184,214,248,248, 30, 30,144,
 38,163,144, 53,225,247,211, 24, 41,155, 99, 78,101, 83,250,105,  3, 19,223, 44,
179, 48, 63,200,174,148,196,163,211, 71, 72,199, 14,166,205,155,162,195,117, 13,
123,228, 17,223,230,190, 11, 80, 61,213,235, 84,184,  0,224,106,232,124, 47, 93,
 23,186,199,230,123,230,190, 48,142, 63, 62,186, 36,137, 86,134,236,112,  2,106,
 22, 33,240,  4, 11,171,236,223,214,143, 32,208,181,124,158, 22, 42, 16,196, 74,
164, 59, 51,148,255,213,  2,172,136,115, 30,114, 59,249,185, 82,198,238,188, 68,
 12,130, 17, 21, 64,236,249,113,207, 82,212,216, 18,211, 62,207, 51, 25, 72,113,
 27,173, 62, 74,244, 11, 54,128, 18, 74,112, 35,102,152,120,103,153,120,168, 49,
 57, 12, 88,233,102,140,172, 65,227,108,  3, 56, 91,199,142,200, 86, 51,109, 53,
241, 26, 36,158,132, 22,166,118, 18,145,188, 44, 69,203,222, 92,190,145,208,251,
  2,  6, 83, 41,  0,164,160, 90, 73,133, 75,152, 61,145, 48,184,125, 85,212, 81,
 34, 74,  0, 33,131,220,132, 68, 82, 14,128, 18, 15, 22, 82, 92, 49, 71, 67,233,
 16,194,253, 97, 71,187, 26, 74,170,170, 72,154,103, 79, 61,180, 91, 66, 40, 59,
233,226, 89, 36,211,179,171,183, 42, 64,188,188,227,212, 96,130,153,208,120, 96,
 21, 94, 90,138,  2, 10,168,138, 58, 94,157,138,239,186,196,166, 23, 26, 44,154,
141, 15,182, 60,240, 18,  0,119, 44, 15,200,229,185, 17,195,162,173, 52,205, 12,
158, 76,157, 78, 38, 43,235,240, 36, 79, 70,116,147,171, 83, 93,245, 77,183, 97,
162,114, 51, 15, 23, 82,144,115,208,234,132, 23, 39,205,202,234,208,123, 16, 43,
143, 28, 44, 25,130,156, 84, 10,190, 67, 15, 25, 28, 15,222,144,178, 26, 45, 53,
103,189,251,206,151, 41,224,181,249,205, 49,221, 62, 29,157,  0, 89,130,109, 14,
 40, 56,  1,202,117, 86,186, 68,102,201, 24,210,178,242, 67,152, 82, 84,187, 63,
  4,196,219, 32,116,196,125,246,111,116, 52, 87,122, 67, 88,139, 22,169, 62, 11,
165,146, 96,155, 15,145,127,130,248,166,152,237, 55,230,189,125,225, 28,185,168,
113,184,126,232,106, 84,153, 89,200,188, 27,107, 98,101,231,114,151,249,121,106,
230, 44,251, 46,150,144,163, 73,198,192,127,137,204, 85,113, 93,235,110,  5,198,
135,  3,232, 92,159,229,244,148, 25,198, 73,155, 54,252,  2,138,199, 23, 83, 99,
 94, 47,123, 29,  6,226, 31, 38,238,122, 87, 36,208,246, 29,255, 76, 59,251,106,
 80,100, 31,176, 36, 22, 63,137,115, 87,192,169,134, 42,164, 89,224,148, 29, 90,
 16,193, 27, 47, 80,163,108, 11, 39,  6, 69, 83, 40, 16,240,246, 14,223, 78, 30,
 16,176,176,101, 67,180,  2, 80,194,168,153, 54,181, 35,144,203, 69, 36,239,224,
 53,125, 16,232,180,211, 73,177,134, 80,200,161,234, 65, 43,136, 88,222,172,136,
 20, 94, 23,182, 72,  6, 53,197,170,  2,242, 24, 48, 43,191, 93,255,208, 91,248,
  9, 13,241, 57,198, 51,  1,159,246,107,104,165,101, 35,245, 46,188,119, 17,147,
 16,144,228,149, 93,243, 70,140, 92,224,208,  3, 32,  1,232,224,250,165, 96, 55,
134,  9, 46, 17,161,168,161, 86,240, 20, 33, 63,176,134, 44, 16,195,241, 55, 55,
233,185,211, 84, 15, 45,105,151,  1,197, 71,247, 76, 65,173, 56,230,  6,131, 15,
 92,230,117,224, 24,192,220,228,127,247,  5,182, 44, 29, 38,  2, 75,205, 92, 99,
218,142,195,167,106, 24, 50, 48,248, 64,204, 13,105,130, 79,252,243, 15,179,106,
193, 41,171,143, 19,202,224, 28,241,219,241, 80, 64,247, 39, 80,104,211, 72, 90,
165,170,  3, 29,162,114, 67,241,193,115,176, 92, 84, 34,223,  2, 92, 11,204,120,
245, 92, 66,196,130,164, 40, 37, 13,141, 41, 19,225, 15,135,239, 21, 32,167,224,
 72,  5,167,206,200, 62,177, 82, 36,235,181, 69,189,149, 84, 81, 93,230,237,  7,
 63, 62,153, 15,146, 51,187,  1,193,239, 53,  7, 14, 50, 64, 46,223, 16, 84, 94,
157, 60, 62, 36, 11,102, 41,179,122,179,251, 23, 21, 48, 87, 64,190,132, 30,149,
  0, 19,  6,246,170,191,242,  8,120, 11,188,188,175, 98, 22, 13, 24, 41,214,132,
 25, 65, 26,  1, 37, 45,251,253, 61, 16, 83,151, 58,238,247,245, 83,249,240,196,
 67,162,152,243, 11,252,176,  5,210,190, 71, 89, 92, 85, 22, 23,225,218,223, 78,
234,  9,146, 68,220, 78,136, 55,211, 80,200,148,188,222,250, 65,137,137, 43, 38,
 46, 76,152, 93, 34, 33, 67,181,252,152,223,208, 89,138,194,218, 28,148,119, 42,
151, 27,149, 45,110,112,125, 96, 10,126,240, 53,106,226, 44,182, 17, 17,226, 71,
117, 11,225, 93,106,173,177,147,198,187, 63,242, 78,182,231,  1,100,137,111, 40,
 49, 28,  0,229,100, 46,184, 90,103,121, 97,247, 14, 75, 57,177, 28,121,167,195,
  7,191,  3, 90,216,159, 84,141,100, 88,164, 80,254,161,235,117,159, 69,193,  4,
 76,168,176,162, 96,131,123, 85,186,186, 99,130, 25, 88,137, 82,195,221,236,221,
150,114,138,195,107, 12,197,205, 41,138, 93,131, 67,118,162, 87,248,  1,201, 43,
107,102,  6,200, 30, 86,  1,123, 36, 75,128, 76,195,  1, 33, 10,191,243,236,102,
245,143,113,  1,249,212, 74,157,136, 70, 91, 57,137,244,  7,207, 56,254,116,222,
171, 69,123, 64,196,155, 86,191, 43, 44, 74,165,160,188, 63,104,134,247,111, 50,
185,195,125,242, 61,130, 22,156,118, 72, 19,173, 30, 56, 10, 25,
} ;

// ../CUDA/select/template/GB_jit_kernel_cuda_select_sparse_OLD.cu:
uint8_t GB_JITpackage_31 [3262] = {
 40,181, 47,253, 96,110, 52,165,101,  0, 10, 94,200, 17, 40,160,152,209,  3,100,
220, 70,  4, 20,105, 55,197, 52,127, 72,156,120,106, 46, 18,115, 43, 63,  5,150,
235, 19, 61,234,250, 24,237,210,228,120, 57,218, 48, 30, 84, 20,  1, 13,  1, 17,
  1, 19, 30,205,  2,116, 89,150, 23,164, 58, 58, 80, 40, 14,140, 49,166, 38,106,
 18, 89,200,173, 35,227, 69,229,213,206,254,198, 43,132, 37,250,101, 57,199,107,
116,169, 63, 75, 89,224, 90, 70,199, 72, 78,104,160,138,206, 38,107,188,188, 35,
 65, 33,185, 77,128,180, 12,109,194,114,175,  6,156, 84, 87,181, 83,  5,209, 81,
 53,239,249,145, 18, 25, 43,240, 45, 21, 24,182,173, 86,213,213, 75,226, 82,126,
179,116,191, 17, 41,127,135, 24,188, 89,106,230, 60, 29,255, 99,248,230,194,188,
181,189,156,107, 46,175, 39,197,242,117,158, 88,203,205,253,247,218, 45,  8,  8,
 85,133,169,  8,121,164,196,140,220,239,162,121,116, 54, 12, 16,201, 34,147,218,
 38,146,163, 76,243,104,155,140, 19,164,236,100, 67,202,109, 60,158,104,195,148,
 76,  6,131,145, 27,191,222,164,106,185,225,216,198,128,229, 29,162,208, 71,251,
248, 73,  5,226, 90, 22, 51, 54, 12, 81,104, 67,106,154,136,194,223, 86,239, 59,
 48,212, 96,133,134,220,193,115,245,211,242,244,114,118, 33, 39, 37, 42, 16,126,
207, 15,131,191, 43,254, 93,248,113,182,  6, 84,213,198, 53, 14,111, 30,145, 79,
 82,247,204,143,239,229,252,185,137,245,131,211,250,136,173, 58, 12,209, 18,109,
181,183,106,253, 25,163,254,238,218,125,201,178,211, 83, 37,223, 53,151,228, 39,
185,110,127,135, 37,191,184,158, 37,155,209,131,135, 92, 44,  7, 87,201,253,190,
228,255,218,242,139, 37, 85,178,120,222,117, 93, 53,191, 47, 40,171, 66, 91,  7,
  0, 85,179,154,201, 83,156, 31,140,  6,147,178, 41,224,184,182,  6, 94,208,213,
237,149, 38,208,149,110,183,215,237,228, 54,  9,141,166, 20,114, 62, 69,154, 69,
138,123, 23,251,230, 62, 77,208, 53,182,238,107,253,118,174,209, 62, 28, 29, 10,
108,  4,210, 36, 69, 72,106, 36, 79,212,144,163, 77, 27, 77,207, 95,127,143,117,
245,232, 94,245, 15,243,118,236,186, 76,152,247,127,170,177, 90, 34,182,117,238,
124,183,211,125,242,127,146,169, 55, 28, 15,137,248,195, 79,145, 70, 73, 77, 56,
 58,134, 69,156,202,219,254,105,195,241,136, 13, 30,186,249,153,238,185,191,239,
  6,  6,  6,  6,176, 99, 24,142,150, 67, 60,224,112,227,251,105,223,243,126,222,
214,243, 59, 57,118,193, 82,224,201,  5,214,137,174,230, 17,231, 24,248,195,195,
131,163, 14, 80, 93,231,196,221,175,180,117,174, 30,182, 60, 95,143,227,220,147,
216,105, 98,167,229,  1,151, 12,253,149,171, 52,255,254,206, 53, 23,215,150,189,
153,114, 54,181,129,243,243,222, 46,207, 89,219,122,122,246, 87, 88,142, 17,170,
236, 60,183,174,124, 15, 15,190,195,203,105, 52,221,214,126,249,116, 38, 48,178,
144, 71,194,242,235,210,160, 14,176, 10, 24, 22, 48,142, 93,  8, 87,180, 76,172,
181,252,171,207, 89,110,235,101,162, 45,207,128,181,115, 20, 20,203, 71, 34,109,
219, 98, 38,  1, 35,131,145,152,199, 67,  2, 57,199, 55, 54,213,175,103, 59,167,
124, 75,252,243,252,186, 29, 98, 91,159,114,158, 68,213, 18,119, 65,  8, 11,199,
 61,153,202, 23,124, 80,254,103,111,227, 27, 70, 22, 37,180, 10,237,211, 25,129,
 72, 34,239, 59,205,217,208,243, 19, 55, 75,223,247, 39,185,171, 41, 52, 10,137,
 50, 60, 26, 72,164, 97,140, 58, 23, 39, 85, 37,171,184,205,191, 81,223, 93,186,
 31,244,173, 47,117,204, 35,205, 78, 25,151,101,149, 83, 19,158, 32,167,112,133,
 92,220,226, 28,  0,171,146,167, 44,147, 50, 61, 43,249,232,118,187,238,190, 75,
125,207,120,138, 24, 42, 67,161, 66,178,204, 98, 57, 64,101,117, 87,125,113,184,
185,249, 35,159,159,218,  7, 63,115,223,249,213,211, 59, 78,251, 37,106,  2, 85,
149, 18, 17,178,117,104,218,  4, 86,215, 42,251, 58,251,247,163,166,  9, 42, 56,
208, 12,103, 14,222,237,180, 23,135,150,117, 89, 41,138, 63,123,254, 37,255,190,
108,228, 85,106, 50,209,203, 94, 43, 57,110,255,243,111, 58, 70,179, 72,169,117,
 48, 59, 28,130,159, 41, 14, 64,207,143, 83,212,255, 43, 77, 75,118,138,187,212,
 55,243,251,211, 81,  3,198,160, 41,249,156, 34, 34,254, 58,156,153,103, 22,102,
 70,147,113,212,252, 96, 20,188,251,106, 40,225, 26,204,197,162,201, 96,246,220,
 54, 45,203, 72, 27, 86,177, 32,157,128, 95,172,146,241,125,186,175,245, 77,106,
 99,240, 47,142, 99,152,  4,170,194, 49, 44,179,170,204,187, 30,224,223,220,119,
119,159, 49, 77,163,179,145, 60, 25,168, 35, 63,164,237,147,193, 48,250,193,203,
125, 73,239,234,116,215, 18,139,173, 23, 71, 83,186, 96,209, 49, 11,  2,  2,  2,
195, 30, 46,110,145,129, 72,209,227,238,154,138, 74,200,101,111,124,163,179, 84,
 61, 63,255,115,243,195,155,132,132,143,  4,215, 19,123,123,189, 74,117,202,136,
 20,178,220,230,112,127,238,124, 83, 13,120, 23,187,184,129,235,111,122,226,231,
178,172,111, 94, 87,186,175, 39,160, 34, 86,  3,131,153,168, 82,196,212, 41, 18,
 17,145, 36, 73,161,176,140,  1,146, 24,  4,226, 88,160, 38, 98,160,237,  1, 18,
129, 48,203,145, 52, 99, 20, 81,  4, 17,162,200,140,  4, 34, 18, 72, 32, 50, 34,
 65, 65,210, 52,  7,179,100,148,164,  6,208, 67, 46, 86, 54, 73,170,153,  6,  2,
 80,200, 32,114, 74,174, 87, 52,126, 39,181,179,106, 17,226,161,131,167,197,242,
191, 31,214,174, 94,116,167,117,222,183,  5, 62,216,133,161, 52,166,236,255,124,
215, 40,225,151,198,122,208,161,179, 32, 22,229,239,133, 29, 73,104,237,200, 44,
 44, 27,252, 29,154,235,  5,104, 49, 52, 70,247,178,248, 81, 66,158, 65, 40,184,
 46,187,253, 49, 17,157, 24, 14,149,218, 18, 14,  2,117, 61,184,229, 69,166,  3,
 20,  0,135,132,156,240, 27,120,  4, 60,102,219, 46,203,217,178,105,170,211, 49,
226,124, 90,203, 19,196, 33, 21,147,243, 31,182,210,170,254, 91, 50, 74,128,251,
117, 90,101, 19,185, 36,223, 70, 91,  4,194,190,120,153, 27, 94,106,  8,119, 60,
 18,148, 22,219, 40, 73,208, 97, 92, 28,252, 60,177,121,232, 63, 90,161,236,209,
 36,204, 17, 23,221,  1,  4, 23,197,194,235,120,127,118,219,182,151, 52,236, 22,
 67,107,208,186,214, 54, 60,159, 20, 41,163,114, 78, 68, 56, 83,248,247, 88, 39,
 29, 96,135,109, 91,236, 26,254, 30,185,215, 56,176,131,144, 33,174,147,236, 20,
132, 87,221,211,108,103, 81,208,146,111,224,101,  6,190,220,230,  4,238,208,132,
 59,204, 54, 98,146,233,  4,140,194,112,195,229,231,176,215,136, 90,197,163, 20,
 74, 72,112,161, 19, 62,176,204,242,226,221, 25,162,149,  2,188,210,147,  9,118,
184, 29,  4,180,154,232,129,114,107, 95,  0,101,214, 61,103,224,176,117,140,223,
 17, 90,236, 16,176,158, 76,  0,189,118,159, 14,157,189,220,180,151, 65,213,204,
209,218,198,195,229,251, 24,154,186, 96,139, 27,223, 24, 76,136, 75,195,143, 31,
103,241,189, 31,180,158,209,163,  1,183,100, 78, 76,246,214, 41,156,  0, 63, 59,
 90, 17,237, 41, 22, 10,133,134,  5,101, 48, 81,232, 80, 67,180, 97,160,161,  1,
 57, 56, 21,106,255,180,104,209,158,186, 87,159,  2, 59,217,217,165,117,184,177,
  2,235,203,115,235, 41, 12,156,175,193, 41,  3, 42,161,153, 46,175,210, 68,239,
 80,158,126,188,212, 15, 73,  3,137, 64,  9, 83, 98, 65, 43, 82, 18,193, 81,174,
235,248,168,136,123,188, 52, 24,179, 58, 49, 18,168,192, 68,224, 45,123,217,248,
 67, 20, 68, 64, 27,126, 86,212, 33,149,126, 67,195, 88,135,237,142,240,146,183,
197, 16,  6,204,114, 39, 94,193,128, 55,252,112, 27,  4, 57, 32, 57, 49,182, 54,
  4,147,166,197,161,197, 62,155, 43, 99, 64,196,149,107,240,121,234, 19,146, 92,
 28,  0,138,100,180, 16,211,240,106,234,212, 75,  9,162, 87,215, 27, 12, 81, 78,
  6,105,216, 83,  6,178,238,  6, 42, 12,108,218,213,187, 10, 78, 74,236, 20,160,
152, 26,151,148,187,  3,220,  6, 88, 97, 66,208,160,234,226,217,227,218,239, 16,
205,206,134, 41, 89, 23,160,110,122,214,224,181, 37,196, 48,197,115,103,201,231,
144,134,  4, 84, 91, 50, 78,228,219, 94,166,236, 77,248, 81,170,145, 71, 55,246,
 23,130, 80,124, 88,134,150, 85,173,124, 70,144,177, 16,170, 73,109, 89, 20,102,
238, 16, 25, 15, 27,133, 33,191, 90,227,226,100,199,251, 57,222,241, 93,204, 52,
171, 87,187, 21,244,114, 45,177,201, 22, 17,159,101, 21,203,236,255,193,116,103,
170, 69,148, 32,100, 19,161, 33, 12,200, 55,214,225,146,250,176,230,231,205, 61,
158,109, 26, 42,  7,205,109,214,162,197,  5,121,141,230, 28,196, 35,253,201,190,
  5, 39,136,196,117,118, 57,214,183,  3, 26, 32,197,238,181, 88,176,117, 40,  5,
253,236, 52,213,144,136,156, 52,226,243,119,  7, 16, 99, 26, 54,116, 52, 36, 21,
 15,138,174,188,221, 62, 79, 87, 91, 34, 75, 85,120,160,183, 39, 94, 78, 27,231,
115, 41, 50, 64, 72, 64,109,175,178, 54,200,223,108,148,222, 49, 80, 74,162,199,
 94,157,  0,222,  9,122,161,232,196, 39, 52,115,173,242,249,100,120,125,165,247,
240,159, 46, 54,100,197, 78,148,185,170,161,189,255, 59,216, 20,189,181,172,233,
 39,214,123,152,171, 79,129,130,130, 43,170, 23,  6,188,  8,252,235, 60, 41, 76,
221,182, 14,145, 87, 94,170,  0,218,122, 33,150,193,240,114, 32,231, 64,119, 58,
220, 67,103,252,213,195, 68, 13,250,164,104, 23,204,210, 17,222, 78, 10, 59, 92,
142,154, 69, 22,138,146,186, 67, 56, 36,189,120,245, 81, 83, 74, 11,253, 46,220,
152, 12,199, 80,109,237,233,233,145, 77,168, 25,172,165,180,153,235,162,178, 43,
118, 32, 47,137,228,116, 54,163,160,229, 28,  6,245,190,231, 69,238, 45,168, 84,
 14, 98,124,163, 73, 98,107, 72, 83,110,203,129, 52, 13,223,211,255,173, 82, 53,
242,249,173, 74, 27,145, 20, 40,104, 73,101,  6, 75,168, 50,205,246,252,138, 58,
144,193, 50,141, 79,158, 90,176,119, 46, 89,  3, 52,129,214,156, 84,101, 84, 39,
147, 78, 20,108, 52,109, 17,156,236, 61,250, 50,195,219,178,173, 13,201,195, 49,
169,237, 37,120,161, 71,226,109,178,127,136, 48, 53,196,  9,  1, 38,100,104,102,
170,103, 12, 25,100, 60,149,107,233,168,128, 83,135, 96,160,117,117, 69, 85,232,
120,218,104, 31, 74,224, 51,138,103,135,132,108, 64,108,141,102,175,190,240,156,
113, 38, 34, 69, 72,115,119, 91,198,223, 75, 68, 93,132, 34,  3, 18,126,200,177,
 58,183, 72,139, 54, 35, 62, 18,136,246, 12, 52,121, 15, 49,230,184,  1,160,149,
 69, 16,220,204,241,174, 26,232,229,234, 20,125, 30,112,207,183, 31, 61, 91,252,
186, 81,120,187,180,198, 10, 45,182,234,  8, 98,148,144,116, 76,175,163,139,175,
132,230,151, 59,  7, 18, 12,172,203,132,150,  4,231, 45,112,236,166,243,184,172,
 18, 18, 73,124,123, 30, 90,210,129, 19,124,180,246,161,170, 16,199,140,160,127,
195, 34,181,220, 67, 81,179,230,103, 91, 81, 90, 20,133,251, 80,117,231, 73, 47,
180,155, 64,125,239, 89, 39,  0,151,  9, 27,206, 94,172,  6,138, 70, 98, 89,249,
124,168,149,117, 38,137,103, 65,250,  9,171,114, 55, 59,  1, 57,180,222,203,127,
 82, 83,146,138,234, 93,188, 99, 72,152, 37,220,149, 21,151, 30,203, 23,241, 89,
 38,205,245, 92,162, 95, 64,116,238,100,229,233, 78,232,186,251,230,242, 23,240,
207,139, 83,150,144,175,101,152,214, 34, 93,148,205,159, 71,235, 39,239, 73,108,
242, 95, 35,132,245,117,194,230,251, 17,105, 87,255,200, 29, 27, 73,135, 17,241,
164, 19, 74,  4,104,244,255, 39,216, 15, 63,114, 39, 64, 27,123,  8,210,212, 40,
245,241,  8, 97,126, 62,192,255, 96,254, 50,173,228,239,132,209, 47,150,120,142,
 45, 36,228,156,111, 60,117,104,196,133,174, 67,  0, 64, 70,241,145,219,197,153,
231,104,164, 50, 87,118, 12,154,180, 14,  3, 84, 58,128,165, 82,208, 69, 25,124,
187,201,175,251,  2,124,236,195,133, 12, 16, 70, 18,228,175, 34, 68,187, 49,100,
135,134,136,  3,138,100, 14,140,104,108, 71, 30, 36, 20, 72,114,187, 12, 37,133,
 87, 98,251, 82,100,  7,166, 33,  4, 32, 27, 79,131,180, 84, 81,100, 70,170, 29,
166,146,254, 93,182,219,137, 64,241,192, 65, 13, 27, 20, 69,224,144, 91,231,  3,
134,162, 52,113,214, 79, 74, 20,198,215,133,115,125,170, 74,193,146, 55,109,222,
 81, 68,230, 13, 83, 85,156, 96,  4,106, 35, 84, 53, 87, 54, 57,161,249, 47,151,
148,198, 35,235,187,225,109,189,169, 41, 37,199, 91,137,235,  0,251, 52,249,134,
 44,167, 27, 18,168,182,177, 15,144,155,164,161,189, 52, 28,160, 84,207,  2,147,
 61, 28,176,162, 46, 61,141,224, 90, 79,150, 80,153,106, 30,175, 59,238, 10,134,
177,245,149,  5, 88, 11, 98,163,135,198, 14, 99,105,253,148, 67,210,  7,163, 15,
123,144,104,210, 95,168, 12,153,140,240, 89,199,105,225, 49,153,125,182,125,117,
202,164,226, 17,135,  7,164,244,225, 21,125, 36, 62,213, 81,157, 53,129,  7,224,
147, 54, 84,142,220,187,224,172, 95,173,253, 92, 39,224, 34,147,239, 26, 44,124,
112,208, 25,166, 21,238,157,139,125, 37,247,246, 54, 61,140,215, 79,  3,214,113,
167, 64,196, 94,  8,168, 57,139, 26,189,182,120,204, 75,132, 38,  0,193, 95, 40,
255, 66, 62, 25,143, 65,191, 46,128,184, 84,242, 95,134,102, 77,196,105,219,  5,
116, 55, 66,254, 28,124,175, 79,243,105,103, 96,221, 24, 11, 57,177, 32,153, 16,
 58,154,  9, 67,108,  9, 13, 75,123,218, 29,130,  9,205, 78,166,170, 62, 64, 34,
235,159, 33,197, 14, 25,210, 94,172,235,241,198, 20,165, 75, 29,231,226,114, 22,
207, 58,171,206, 69, 26,207, 96,131,117,  2, 17,189, 98,134,146,211, 46,128,210,
198, 66, 16,162,132,252, 76,215,221,179, 60, 12,  8, 30,180, 30, 17,128,207,102,
228, 21, 24,211,179, 96,152, 58,230,189, 25,105, 81,151,199,212,166,176,248, 96,
185,181,113,  1,109,251, 24,184, 32, 45,206,184, 54, 73,165,140,158,128,200,160,
244, 29, 33, 36, 10,123, 39, 70,107,192,100,250,188,  8,190,100,195,103,154,210,
236,102, 43,221,253, 62, 17,107,  5, 97,239,245,130, 84,  6, 27,161, 52,108,224,
254,  1,215,149, 99,173, 45, 74,164,214, 43, 18, 74,144,162,192,107,136,226,225,
218, 99, 32,170,226,209,221, 20,132, 20, 67, 14,144, 37, 80,212, 47,100,174, 19,
255, 71, 93,159,220,176,216,246,177, 10,198,218,118, 21,247, 83,212, 25, 11,218,
 88,132,142,236,190,243,111,  2, 14,  7,216, 81, 12,165, 40,224,200, 82,135, 93,
 55,173,
} ;

// ../CUDA/slice/template/GB_cuda_ek_slice.cuh:
uint8_t GB_JITpackage_32 [2942] = {
 40,181, 47,253, 96,109, 43,165, 91,  0,106, 95,160, 16, 44,208,174,106,115,104,
 72,232, 45, 90, 89,218, 94, 59, 85,135,216,170,234, 58,208,102,220,103,233,137,
 10, 38, 69, 19, 44, 87, 86, 76,254,210, 51,214,102,169,135, 65, 47,  3, 74,  6,
  1,240,  0,251,  0,148,198, 84,203,182,103, 93,216, 77,  3, 92,104, 25, 89,106,
 56,156,  8,235,180, 84,219,111, 28,212,170,119, 33, 30,147,106, 46, 44,  3, 96,
168,221,214, 61,  0,199,184,119, 18,194,188,252, 81, 64, 40,159,252, 81,222,234,
128,114,206,194,206, 11,234,235, 84,135,238,124,101,153,182,252,124,115,103,202,
 88,194,124,111,123, 11,186,205, 93,159,173,201,177, 11,149, 10,171,214,170, 15,
 29,230,221,116,167,197, 96,244, 45,175,212,106, 28,124,103,202, 85,173,215, 29,
174,142,  7, 41,  2,162,213,148,143,114,  9,212,197,108, 55,165, 42, 16,229,166,
211, 58,128, 76,168,184,200,128, 80,130, 96, 81,209,160, 96, 88, 92, 96, 88, 36,
 56,165, 82, 81,145,  0, 97, 64,  4,236, 60,151,224, 18,101,139, 57,111,165, 33,
 81,170,129,202,138,113,238, 42,179, 24,103,140,242,136, 64,196, 67,  4,196,  0,
196, 67,196,161,233,121,196,171,201,138, 75,148,119,170,118,215,106, 60,146, 40,
195,124, 25,218, 27, 51, 28, 85,156, 36,157,150,177,197, 82, 75, 82,113,178, 32,
 96, 16,209, 78,246, 46,237,  8,165, 34, 66,130, 72,  6,197,  1,130,234, 37,100,
240, 72,196,  1,137, 68,  2,207, 49,214,182, 23,212, 86,138,181,154, 96, 42,191,
  3,179,237,229,110,211,119,212,139,173,108,153,206,140,229,163,  5,144,213, 98,
 53, 61, 11, 39,175, 63, 46,180,124,222,246,250,228, 10,181,218, 28, 98,210,156,
236, 93,242,102,184,152,119, 78,168, 29,223,229, 38,139,179,169,102, 51,122, 69,
230,188,244,222,220,246,178,123,239,116,253,106, 74,237,228,230,205,157,210, 14,
 91, 78,213,184, 75, 78, 38, 28,223, 58,213, 22,115,225, 61,168,212,114,163, 82,
155, 91,165, 89, 92, 42,194,  5,  3,118,112,202, 63,231,216, 59,171,126,166,237,
133,141,160,106,116,227, 26, 72, 82,164, 48,246, 20, 97,243,179,147,170,218,226,
125,133,168, 66,187, 98,180,231,104,196, 89, 29,170, 16,237, 67,121,135,179,121,
125,157,206, 71,225, 11,241,152,248,187,196,219,176, 40,188,162, 64,247,136,119,
111,125,242, 10,208,227, 49,113,235, 18,127,248,228,214, 35,129,152,155,222,185,
156, 82,232,154,207,251,222, 43,187,247, 34, 63,231,141, 99,204, 97,206,121, 74,
 25,170, 38, 97,203,233,  1, 61, 37,199, 53,171,219, 88,110, 27,199,123,137, 33,
147, 67, 79,244, 28, 66,229, 65,229,225, 20,151, 56,244, 92,  3, 67, 65, 70,  6,
 69,218,144, 36, 41,178, 44,105, 56, 48, 56, 32,199, 47,  7, 49, 14,239,116, 12,
  3,129,136, 44,150,206,149,140,215,114,232,248, 58, 70,148, 40,106,203,128,  2,
221,246,209,163, 56, 92,227, 45,161, 40,119, 69,220,241,181,125, 36,242,255,142,
135, 90,167,185, 69,163,148,197,114, 10,141,235,149,109,226,154,129,201, 32,152,
218,118,155, 99, 86, 28,184,209,130,238,230,209,214,208,197,203, 82, 23,116,152,
109, 17,210, 92,187,  4, 99,121, 49,139,152, 14,107, 78,  2,117,195, 45,255,  3,
 46,115,109,174, 57, 86,120,187,118,160,  3,147, 89, 39,109,231, 78,181,185,132,
 53, 90,120, 54, 83,234, 49,181,176, 25, 66, 45,204,156, 57, 78,188,212, 37, 10,
 30, 76,168, 56,226, 35,182,168,180, 90, 35,229,221, 88, 40,204,138, 85,219, 93,
235,136,163, 99,150,103,174,116,186,166,148, 35,239, 37,  8,136, 68, 51, 45,225,
235,180, 60,183,205,110,110,178, 14, 93, 79,170,209,206,107,155,149, 53, 14, 71,
134, 71,130, 30,139,101,106, 29,222,160,112,182,216,122, 91,142, 30, 71,186,182,
226,147,199,  4, 71,226, 80,149,201,159,134,134,134,136, 66, 99,130,123,207,108,
245, 94,226,226,139,  7, 77,159,197, 30,106,119,178,  8, 23,  9, 56,170,181, 27,
189, 28,159,245, 50,181,136,233,132,250, 92, 53, 45,198, 47, 61,162,141,104, 74,
101,200,122, 26, 26,220, 33,144, 83,124,227,151, 56,244, 92,217, 86,155,170,175,
109,  8,197,123,206,177,200,178, 34,106, 97,228,166, 80, 51,153,189, 84,153,189,
222,251,142,151,166,237, 90,203,201,225,209, 42, 19, 29,124,190, 53,243, 72,128,
  8,226, 17, 73,209,107,173,242, 75, 20,115, 85,148, 16,211, 42,159,170,119,227,
136,174,112,219,242, 50, 43,107, 17,186,  6, 61, 30,137, 99,  8,136,228,225,101,
128, 64,145, 67,143, 68,173,102,169,  0,167, 32,254,128, 76,110, 53,137,210,139,
 21, 81,160, 94,174,216,154, 69, 86,248,  6, 99, 43,108,155, 76, 53, 89,109, 14,
 40,160,204, 52, 67,195, 33,135, 71,  8,176, 88, 44,215,194,190,  3,  3,  4,181,
 37, 66, 64,183,141,159,104, 60,199,184,231,152,137,245,240, 56,126, 20,131, 51,
168, 66,148,210, 41,133,100, 68, 68, 68,146, 36, 73,  7, 82, 32,  8,  2, 98,129,
152, 10,130,207,  7, 34,144, 60,204,164,140,133, 16, 36,  8, 25, 25, 17, 17,137,
 36, 18,145, 32, 82,144,148, 54, 99, 42,222,110,183, 54, 89,180,  6,186, 15, 65,
241,150, 92, 77,240, 25,153, 24,210, 91,213,243,168,254,210, 15,205, 36,171,127,
 92,202,139,178,249,178, 36,165, 78, 99, 24, 10,184,154,118, 85, 43, 18, 93,140,
200,146, 82,112,201, 78,156, 77,211, 43,128,212,141,241,  8,131, 18,116, 83,222,
149,169,116, 44, 74, 75,250,140,158,170,239, 83,212,247,  2, 68,187, 66, 47,166,
238,252,203, 78, 70,112,192, 45, 15, 22,178, 85, 43, 52,232,208, 75,100, 40,109,
165,138, 56,134, 50,203, 82, 43,228, 26, 89, 17, 35, 98,110,181,134,110,  2,227,
134, 20,142,127,217, 57,  7,235,185,128, 31,154,201, 51,158, 80,  8,206,163,112,
248, 12,145,208, 37, 60,232, 49,163,135,208,199, 98,124,138,116,175,218,191,162,
195,204,180, 12,172, 39,109,165,113,249, 46, 33, 22, 65,190, 36,110, 13, 76,127,
116,253,203, 61,212,169, 49,106,165, 59,  4, 41,148, 89, 74, 62,235, 22,  2,143,
206,214,245,217, 14,142,242,111, 35,249,125,136, 49,192,  0,219, 33, 70, 98,156,
149,136,158,106, 81, 28,185,107,126,244, 12,130,237, 10, 14,152,  8,159,164,168,
 84,162, 48,155,211,109,158,110,167,104,145, 44,166,200,238,166, 95,159,188,228,
  3,  3,196,244,  4, 62,103,237,173,108,235,196, 31, 80,236,160, 65, 58,163,  6,
 91,215, 98,218,122,194, 99,223,171, 80, 80,238,111, 66, 53,240,186,208,106,234,
149,192,211, 62,141, 38,  3,150,235,166,138, 61,122,142, 57, 84, 32,221,112,189,
232,168,211,255,103,114, 46, 60,137, 95, 46, 80,218,202, 75, 60,240, 76,238, 12,
232, 87,156,109, 87, 50,128,141, 38, 50, 35,226,114,228, 75, 43,  6,214,128,236,
121, 39,229,249,230,223,125,202, 34,157,227,238,191, 31, 96, 46,210,109,218,217,
238, 49, 52, 37,  3,128, 22,103,254,224,182,251, 76, 60, 58,126,155, 58, 25, 86,
233,170,255, 40,226,245,170,162, 51, 64,195, 45, 20,135,235, 31, 17,192,151,143,
101, 65,204,176,138,245,186, 19, 80,188,  6, 69,142, 21, 36,195,139,158,218, 39,
 13,130,176,228, 56,213,203, 77, 59,204,112, 76,235, 17, 81,240,103, 36,130, 74,
 77,163,198, 83, 48,249,230,229,201, 74,135,230, 98,188,107,143, 19,129,252, 92,
183,196, 33,162, 61, 95, 22, 12, 82,105, 31,164,175,187,199,224, 41,249,129,154,
247,123,245,167,193, 27,108,253,116,221,150,225,180, 36,174,  9, 50,136,151,207,
149, 19,156,188, 22,167, 10, 47,170,133,239,138, 53,107, 91,110,238, 26, 90,214,
213, 42, 10, 96, 69,140,221, 92, 10,104, 17,240,215, 55,123,186, 74, 10,211, 13,
 87,190,232,233, 32,244, 48,  9, 75,162, 11, 53,177, 78,218,212,253,206,178, 61,
 21,194,135, 82,228, 85,  6, 21,105,199, 22,245, 14,129,199, 85,131, 62,214,136,
196, 40,235,214,100,104,131,104, 57, 63, 45, 99, 97,221, 79,251,162,195,210,179,
 30,247, 71,195,167,178, 60,186,119, 20,176, 35, 45, 64, 29, 79,215, 62,246,115,
212,153,168,173, 37,228, 41,227,207,  7, 57, 75,116,126,177, 56,141, 68,234,237,
231, 71,248,249,102,147,184,156,210, 38,209,166,106,104,173, 11,102,  4, 70, 37,
157,254,159,232,162, 98,215, 15,167,100,110, 88,  0,176, 21,251,118, 58,  4,202,
199,123,129,220,107, 89, 50,188,206,108, 36,116,192,  1, 15, 55, 86,145,172, 30,
 86, 38, 80, 64, 43,165, 61,167, 40, 12,121,178,215,155, 88, 17,102, 86, 38,  4,
176,195, 96,155, 19,140,182,118, 51,207,135,146,162,169,151, 60,216,110, 35,146,
184,198, 65, 27, 84,122,167,122, 14,217,249, 57, 88,189,216,233, 33, 37,159,248,
114,200, 43,208,150, 39,199,177,  7,201, 34,164, 59,156,223, 84, 34, 33,167, 25,
 55,166, 92,165,206,242, 16,118, 16,186,203,236, 64, 76,143,157, 97, 31,  6, 99,
103,205, 15,155, 95,174, 70, 44,178,235,242,103, 63,226, 56, 56,233,107,213,136,
177,255, 49,164,129,191, 96,237,197, 39,204,119, 72,160,126,127,116,252,  5, 65,
 47,178, 51,254,197, 40,230,239,133, 97,175,253,136, 40,118,248,159,219, 29,254,
 46,139, 54,132,156,  3,224,157,130,205, 93, 55, 47,  2,118,166,  4, 71,215, 46,
141,184, 56,208, 68,221, 45, 96,137,156,238, 25,206,  6, 42,235, 56,252,103, 87,
232,177, 64, 81,207,  4, 39, 60,247,242, 88,  0,171, 96,172,248, 69,241, 20,121,
157,129,255,227, 34,171,217, 72,104, 37, 85,  0, 76,  9,220, 21,157,226,250, 36,
233, 41,145,131,163,191,107,204,112,241,228,143,125,  1,127, 44,119, 68, 91, 26,
166, 91, 95,173, 13, 49,  2, 50, 39, 14,113, 77, 66,145,132,188,  2, 74, 77,148,
106,107,207,238,175,172,  4,185,103,219,219,194,204, 73, 56,141,101, 57,184, 21,
 56, 79, 80,101,110,230,214, 51, 89,186, 49, 44,146, 54, 58,111,100,201, 17, 45,
 61,123, 65,159,148,239,125,195,107,189,241, 64, 55,  8, 16, 87,189,154,255,165,
208,132,139,217,243,120,250,144,106,243,128,169, 62,245,202, 45, 69,165,183,  5,
 76, 98,207,161,113,166, 25, 40,131,150, 99, 22,218, 74,254,182,141,219, 52, 35,
248,166,244,206,178,241,138, 94,243, 14, 52,110,238,220,128,  1,107,245, 40, 83,
135,182,143,207, 98, 38,233, 33,217,228, 95,173,241, 16, 12, 69,140,248, 57,192,
129, 58,165,210,142,248,244,169,146,139, 10,128,198,105,241,112,228, 61, 39,143,
 99,183, 97,159, 17,210,120, 98, 31,199,220,131,217,172,199, 48, 48, 13, 47, 73,
 60,116, 83,146,143, 76, 39,232, 60,110,224, 33,177, 52, 52, 36,222, 23,164, 95,
 64,131,104,130,238, 68,230,120, 75,115, 88,  7,122,118,169,245,139,227, 63, 79,
146,243, 85,246,  5, 19, 11, 78,251,138, 53,206,175, 58, 26, 73,247, 16, 40, 85,
 54, 72,111, 69,136,170,228,141,233, 29, 35,  0,173,134,  7, 96, 85, 70,235, 66,
184, 44, 60,144,202,116,159,232,175, 75,  4,141, 35, 15,139,146,135,200,247, 48,
102,156,209,162,192,111,146, 78,244,110,157,132,103, 85,203,239,162, 99,128,  7,
 72,224, 23,164,121, 98, 70,222, 40,137,173,110, 26, 42,166, 88,105,151,117,118,
101,152,247,204, 28,  8,228,129,  5, 51, 88,139, 85,173,244,219, 57,253,232, 33,
211,226,190,179, 62,130, 22,106, 85,159,227,214, 26,215,134,171,177,100,237,128,
 24,252, 16, 26,115,101,  8,223,184,  2,160, 31,218, 47,195,107, 98, 80,224,146,
 40,125, 60,206, 89,129,148, 28,173,230,135,210,227,141, 81,199,146, 36,169, 71,
 19,184,169,183,152, 38,215,221,237, 60,146, 68, 63, 31, 49,148,176,242,141,162,
 14, 40, 19,164,231,211, 33, 53, 18,230, 31, 72,137,147,  0,119,168,140,253, 60,
 37, 72,236,185,252,107,223, 52, 68, 15,216,114, 69,228,167,142,202,178,223,184,
 68, 68, 71,112,114,253, 11,170,181,107, 21,230,222, 79, 26, 12,130,235, 21,182,
156,105,205, 22,111,  7,157,203,158, 40, 50, 82, 49,227,168,232,199,252, 17, 28,
147,148, 52, 26,105,129,147, 82,159,  2,136,218,234, 69, 47,120,166,118, 65,185,
174, 26, 89,222,220,134,137, 53,214,122,210,243,156,243,140, 42,127,178,124, 21,
117,102,134, 27,141,233,206,127,156,249,215, 50,152, 82, 20,103, 23, 10,139, 58,
 53,133,254,112,148,141,191, 99,245, 90, 74,121,213, 51,129,223,215,124,173, 29,
247,205, 42, 60,144, 43,162, 85, 38,128,172, 33, 79, 94,198,115,111,186, 10,170,
 35,177,165,119, 57,220, 39, 39, 24,124, 36,208,210, 42,220,204,250,223, 47, 90,
212,248,122, 37, 47,120,126,150,159,217,211,  1,217,207,160,105,135, 66,211,123,
252, 56,237,225,193,223, 76, 70, 83,164,232,212,145,232, 35,145, 77,238, 91,112,
 92, 34, 20,123,129, 75, 97,156, 50, 89,254, 64,220, 51,152,225,169,106, 80, 31,
141, 50,134, 57,225, 60,199, 51,194,  6, 59,101, 87, 68,117, 78,115, 68, 15,198,
130, 82, 37,109,113,201, 64,157,132, 42,126, 51, 41,221, 51,247, 59,210,231,136,
203,152, 62,  2,164, 53, 25,245,172,140, 73,215,  9,196,136, 48,244, 26,140,100,
 45, 80,116,227, 53,219, 63,172,120, 54,  7, 25, 61,208,130,196,110, 95, 36,212,
138,164,134,248,250,  2, 84,180,200,104, 82, 55, 17, 58,244, 25,148,129,225,179,
225,244, 39,165,204, 88,185,169, 83, 43, 66, 90,128, 25, 12, 39, 44,167,213, 49,
157,  7,
} ;

// ../Include/GraphBLAS.h:
uint8_t GB_JITpackage_33 [52064] = {
 40,181, 47,253,160,126,104,  6,  0,180,  3,  1, 90,201,184, 36, 45,176,174,172,
 27,186,140,104,219,242,183,159,123,100, 12,205, 88,171,100,109, 44,244,  9, 10,
125,147,220,136,181,108, 39, 11,175,132, 82, 66,153, 80,115,167,244,167,233,221,
113,  9, 28,  2, 72,  2, 77,  2, 61,113,184, 66, 93, 50, 10,243, 53,117, 43, 10,
 32,122,104, 52,136, 26,152, 91, 68,221, 58,136,194,201, 48,190, 80, 25,214,136,
  3,  4, 96, 17, 67, 70, 81,244,152,100, 20, 71,157,155, 97,245,222,109,102, 29,
156,238,125,108,207, 90, 61, 30, 57, 57,106,173, 39,240,164, 42,185,251,  8,172,
101,135,196,177, 44, 23,141,133, 70, 89, 58, 85,156, 77,173,143, 60,204,249,156,
213, 70,142,214,205,191,226,159, 51,  4,255,190,253,203, 53, 68, 39,248,214,185,
118,143,103,123,234,252,124, 33,245,138,  0, 14, 12, 13, 99, 67,113, 46,184,115,
142,118, 50,192,165,109, 59,252, 88,182,125,110, 87,198,191,155, 83,240, 84,166,
 50,114,167,124,120,202,244,243,255, 95,127,118,114,115, 16,227,107, 67,253,247,
213,110,253,221, 75,171,136, 46,248,126,119,220, 92,227, 38, 61,208,214,111, 52,
 35,238, 97,218, 27,187, 13,111,123,199,155,180, 78,253, 66,155,166,234,246,211,
202,110,221,203,254,125,219, 60,124, 43,229,251,225, 55,186,161,135,163,124,  9,
226,209,156,189, 73,234,109,126,249,195,151,210,227,148,181,202,  5,139, 66,252,
 62, 61, 77, 55, 26,118, 28,242,142, 41,102,201,185,112,110, 84,  6,216,172,127,
 72,101, 95, 90, 55,246, 41, 59,126,233,101,210,111,178, 63,190,180, 63, 62,157,
243,111, 15,255,231, 93,105,235,109,183, 27,111,216, 26,242,175,109,199, 14,146,
255,110,193, 25,118,214, 67, 21,228, 36,168,218,207, 13, 47,245,217, 32, 25, 86,
112,118,219,155,140,239,219,104,163,190, 53,  5,174,235,101,206,229,  4,193,102,
234, 94,  3,102,233, 29, 28, 93,218,252,182,142,174, 75,219, 32,230,252,202, 79,
 78, 26,242,253,250,205,254,144,227,127,168,180,242,243,182, 30,255,204,230,156,
163,126, 69,206,180,219, 58, 88, 89, 36,237,237,143,255,250,187,183, 73, 47,196,
145,179,205,209,190,223, 85,238, 79,178, 95,159,224, 87, 55,110,126,201, 14,137,
 52,137,184, 71, 49,197,186,236,228,165,206, 93, 17,127,234,155,188, 68, 52, 44,
 27,137,115,144,245,119, 14,255,245, 62,146,195,115, 82, 28, 11, 76, 36,147,136,
129, 73, 50, 97,200,246,224,248, 18,212, 22,150, 40, 30,121,183,126, 50,227,232,
240, 79,111,108, 13,178,123,151,109,237,248,105,149, 87, 82,217, 57,199, 20, 79,
226,  8,  4,132, 99,146, 34, 36,201,196, 24,117,169,120, 96,219, 11,138,191,109,
 16,243, 43, 67,140, 33, 32,  2,155,164,104, 26,212,229,114,101,168,140,150, 72,
  4,164, 73, 18,  9,196, 41, 99, 97,174, 31, 73, 19, 42, 33, 17, 81, 18, 39, 15,
107, 67,121,217, 97,150,174,124,143, 76,249,251,126, 35,247,169,236, 79,243,198,
230,222,102,187, 82,166,248, 79, 84, 36,208,180,109,  3, 81,166, 46,203,149,145,
209,180,170,202,200,104, 60,253,190,219,  6,206, 41,211, 80,165, 27,180,211,192,
182, 90, 11,185,180,  7, 30,192, 16,136,125, 64, 30, 15,200,227, 17, 65,114, 29,
232,214,152,137, 36,193,219,246,177,  8, 43,199,142,137, 49, 13,167,162, 48, 26,
  6, 97,238,193, 16, 25,237,195, 66,163, 34, 32, 97,161,224,171, 77, 34, 42, 11,
139,219, 85,137,249, 57,186, 31,217,228,117,207, 23, 82,190, 84, 86,176,130,225,
243,183, 71,145, 13,162,242,179,126,175, 95,164, 58,167,135,248,187,  1,252,168,
131,181,139,112,132, 38, 18, 67, 28,106,144,240, 16, 26, 56, 98, 23,212,197, 66,
171,226,197,245,215, 42, 45, 65,236,159,188, 76, 67,203,183,153,115,142,107,  9,
130,170,167,157,106, 42, 12, 99,137, 80, 98, 38,189,127,111, 93,109,125,206,122,
215, 77,231,228,117, 27,126,164,111,244,247,223,224,168,146,193, 86,134,134,117,
 17, 65, 60,240,  3,132,  3, 18,114,113,142,230,165,110,109,184, 61,120,226,128,
127,225,127, 79, 72,  8, 20,152,160, 76, 76, 76, 23,201, 68, 49, 48,105, 26,128,
135,195,113,153, 36,146,137,137, 41, 28, 81,184,231,195,  9,110,154,230,147,105,
162,255, 62,217, 67,206,104, 46,204, 34,186,112, 24,181,131,218,227,202,177,127,
 58,252,208,158,177,193,199,  1,  3, 70, 30,238, 37,215, 73,201, 68,117, 37,132,
179, 53, 52,242,141,  7,219,122,103,216,207,146,255,149, 52,132, 88, 34,252,233,
 89, 45, 24,137,210, 71,242, 71,198,210,200,182,253,170,237, 56,210,202,213,149,
 81,115,114,154,198,245, 94, 91, 35,127,168,114, 84, 54,232,138, 51,142,102,163,
 97,105,151,139,229, 34, 67, 93, 48, 96,184, 92, 27,140,166,210, 46, 86,150,185,
180,  7,199,202,208, 42, 12,163, 73,160,180,219, 59, 23,159,147,149,214, 15, 50,
137,216, 88,104, 88,231,178,241, 13, 57, 41,244,220,156,163, 92,168,138,230,114,
 97,125,202, 78,114,180, 82,241,239,184, 39, 53,136, 68, 34, 13,203,129,136, 56,
106,152,139,  7,179, 20,161,149,186,135,174,183,247, 30,170, 30,199,159, 78,173,
111,216,112,219,234,123,229,172,203,105,155,253,235,115, 12, 85,234, 94,136,125,
235, 78,193,207,234,249, 70,207,204,236,128,176,133,185,178, 76,135,163,101,215,
  2, 13,  0, 11, 16,192,144, 71,103,253,246,228,246,165,196,251,132,149, 58, 91,
219, 86, 69, 93,213,101, 97,209,193, 70, 19,  7, 28, 13,198,194,104, 22, 26, 77,
 82,109,234,101,234,151,155, 46, 59, 11,211, 28, 88, 40,139,115,161,170,119,253,
 59, 16, 25,113,237,118, 26,112,144,109, 48,150,150,101,157,141,183, 73, 92,247,
171, 92,  1,140, 42,163, 48,216, 69, 97, 52,150,231,104, 88,  9,112,237, 95,125,
166,152,212, 63, 49, 34, 98,201,200, 92, 62,225,104, 54, 26,231, 22,152,122,156,
 34, 89,101, 45,168,104, 52,139,245,224,186, 80,153, 43,211,249,176, 61,145,199,
137,  3, 18,  3, 22, 43,195, 58, 20,134,134, 21,190, 67, 40, 68,249,160,226,196,
 21,108,117, 46,154, 12,133,182,140, 18,174, 96, 12,179,170,234,186, 79,171,187,
173, 31,119,215, 12,187, 16, 95,201,157,228,247,219,205,212,134,215, 45, 53, 91,
 66, 38,142, 48, 68, 34,193,  8, 16, 64, 42, 18,137,  9,147,105,128,149,247,253,
 99, 53, 40, 10, 14,239,246,242,147, 92,148, 76,191,112,114,168, 90,138,200, 57,
122, 93,112, 52, 84, 13, 95,219, 15,149,163,238, 35,134,186, 48,142,215,186,103,
202, 11, 73,114,206, 14,145, 98,219, 78,229,133, 74,138, 41,232, 12,120,244,185,
245,  5, 14, 21,102,233, 67,219,  1, 79,219,209,219,166, 55,224, 13,105, 45,151,
215,231,244, 13, 79,137,105, 43,221, 86, 12, 59,248,215,  5, 61,167,196,108, 24,
190,183,110,216,223,107,251, 11, 25, 48,133, 74, 27,195,145,222, 79, 46,176,110,
253,251, 36,  3,246, 81,115, 56,110,225, 12,185, 17,197,113, 99,171,182,194, 20,
168, 87, 34, 37,130, 28,211, 68,170,254,105,253,184, 75,233, 28, 45,153,139,  1,
 59,200, 80,108,113, 89, 50,154,138, 57, 26,198,172, 43,203, 80, 28, 14,213,  0,
 35,187, 26, 68,236,194,168, 10, 55, 68,192, 46,126, 41, 57,183, 29,146, 87,218,
144,253,116,168,231,251,164, 29,136,135,248,216, 42,181, 20, 10,133,104,132,219,
 12,122, 42,135,213,  1,179,228, 27,109, 73,229, 38,242,176,142,152,  2,210, 16,
161, 33,194,131, 51, 56, 50,115, 22,150,177,170,235,210, 64, 35, 72,163, 43,105,
135, 49,  2, 40,254, 22,249,135, 90, 44,128, 37,185, 97,108,189,186,160, 91,152,
165,127,  8,  8, 10,120,175, 71, 35, 52, 52,100, 29, 77,133,242, 56,220,176,122,
218, 33, 58, 36,147,136,201,132, 55,183, 76,204, 92,137,200, 92,146,137, 57,154,
  5, 20, 70,130,227, 52, 97,218, 11, 50,202,210,208,192, 22,134,202,104, 16,200,
229,210,145, 72, 36,211,  3,196, 19,126,180,149,202, 47,218, 74,161,191,199, 79,
  7,249,180,254,153,220, 76,177, 48, 14,181,193,172,236,234, 56, 40,108,123,134,
  1, 97,135,128,196, 36,130, 39, 17, 18, 19, 75, 76, 87, 59,112, 32,227,139, 70,
 67,169, 64,219, 96, 88, 55,144, 98,235,148,255,144,  7,127,224,231,247, 82,110,
 41, 19,183,245,  4,221, 54,133,164,194, 48,201,148,113,152, 83, 97,152,100,202,
170, 74, 34,137, 83,166, 85,152, 21, 97,158,216,177,225,  7,201, 27,149, 20,233,
 81,234,140,136,150,229,194, 46,137,234,130, 60, 30, 22,214,137, 86, 74, 32,220,
131, 11, 68, 60,  2,183,142, 64, 81,127,100,  0,109,239,218,234, 93,121, 67, 78,
 63,237, 20, 24, 25, 26, 18, 11, 10, 92, 56,191,215,237,189,152,  0,118, 93, 26,
104, 56, 15,126, 16,187, 13,183,136,105, 66, 39,138,201,229,112, 24, 96,144,233,
 96, 84, 18, 24, 70,246, 26, 11,141,123,208, 30,104, 24,170,243, 43, 11,179,149,
 33,246, 62, 56,195, 40,200,196, 15,126, 96,253, 69,110, 49,139,211,117,206,180,
114, 20, 63,234,208,236,  7, 87, 31,171,117, 11,221,183, 94,140, 72, 43, 91,159,
245,218,106,221, 29,190,144,130,131,228,230,104,158, 58, 87, 69, 73,141,236,165,
238, 14, 16, 73,113,  5, 37,211, 88,124,206,123,229,180, 30,136,130, 81, 61,189,
217, 16,140,112,181,126, 50, 36,234,103, 91,144,191, 53,248,219, 67,244, 39,190,
  3,173, 63,138,148,140,  6,203,160, 46, 58,134,158,231,245,190, 49, 30,212, 34,
249, 49,229, 81, 49, 83, 28,108, 52, 40,172,235,170,141,204,240,221,242,135, 91,
231,210,122,156,147,225, 69,104,235, 13,155,255, 25,242,120,105, 67,247,108,248,
137, 64, 17, 20, 63,209, 71, 37,199,202,  3, 69, 43,149, 30, 55,197, 98, 97, 40,
202, 52,234,208,164,154, 10, 62,109, 27, 95, 70,190, 51,201, 38,115,121,110,115,
110,157,147,255,125,106,255,125,249,128, 74, 73,124, 80, 33, 43,126,218,254,241,
 84, 17, 63, 91,169,231,250, 71,139,211,201,170, 14, 39,195, 34,  3,140,194, 60,
160, 96, 73, 69, 69,241,128, 33, 89,172, 30, 21,156,  0,131,160,226, 72, 47,105,
227,251, 11,251,118,146,171,104, 85,212,101, 99,113, 56,187,116, 40, 11,139, 34,
125,149,160,246,220, 83, 47,115,243,165,199,147, 43,170, 68,148,136,205, 51,108,
 99, 24, 89,  1, 53, 35,219,180,147, 81,176,189,120,208, 40,211,180,133,183, 57,
 90,249, 93,206,  6, 43,228, 31,161, 58,113,145,185, 24, 84,154, 75, 37,131, 25,
205, 79,211,174, 86,206, 71,147,163, 14,222,206,167,247,145, 37, 91, 55,182, 58,
 61,204,115,202,208,247,205, 18, 91, 23, 75,134,194,152, 51,164,142, 12,127,169,
211,234,224,146,209,104,216, 53,233,108, 46,234,132,224,104, 56, 28, 75, 34, 22,
192, 44, 25, 48,180,  1,138,122,168, 68, 53,  8,186,152,132, 16, 13, 13, 72,  0,
128, 32,  0,227,128,  0, 12, 20, 14, 19,134,195,201,180, 76, 31,180, 66,142,  8,
 17, 72,196,167, 17,129, 20,163, 97, 72,192, 48,131,  1,  2,  4,192,  8, 36, 24,
152,  9,  0, 10,216,  1, 90,229,205,140,188, 42,247,236,223,243, 20,160,  5,147,
 10, 65, 25, 38,159,138,162,156,134,179,  7,122,176, 15,231,111, 89,231,101,102,
  8, 92,102,165, 97, 29,145, 60,154, 26,235,119,107, 60,119, 85,198,123,104,171,
252, 85, 61, 76,218,129, 54,165,194,163,184, 82,116,243,233,179,116, 82,103,222,
136,  7,134,158,105, 69,173,  5, 60,217,  5,194,115, 62, 59,233,164,200,209,184,
214, 52,146,171,130, 27,142,135,136,236,185,162, 89, 19, 88, 87, 13,  6,215,101,
156,164,188,153,246, 70,212, 25,206,196,112,242,221,108,156, 68,197,  4,105,203,
184, 66, 67,220,233,106, 41,219,163,226, 76, 96,249,211,213, 75, 73, 51, 86,194,
 90, 33,139,100,173, 64,127,124,148,238,228,200, 46, 70,114,110,249,143, 60,159,
198,168,  2,253,209,132,180,116,254, 90, 33,136, 51,190, 98,103, 52,133,144, 53,
214,249,142,120, 51, 35, 42, 72,152, 46,208, 92,176,113,211,217, 77,202, 54, 66,
252,192,141, 35,  8, 43,222, 47,140,255,218,137,205, 64,115,144, 38,100, 58,219,
 28,180, 22,207, 60,231, 55, 94,102,198,205,  7,245,105,124,179, 73,  3,209,148,
200, 15,112, 98,227, 40, 96, 35,178, 77,105, 50,205, 29,241,244, 78, 84,220, 75,
 98,248,246, 25,139,161,171,141, 64, 11,148,132, 41,  7,246,206,202,116,  2,239,
113,223,153,175,102, 57,125, 16,209,175, 33,243,172,189, 71, 83,132,186,217, 48,
 38, 78, 20,193,176,122, 15, 74, 19, 77, 38,112,210,191,217,184,237,221, 40,  1,
 87, 59,180,155, 20, 79,166, 99,196,101, 83,  0,184,191, 85, 81, 63,138,  5,227,
 40,211,211,179,154,  3, 39, 15,103,249, 83,203,230, 93,146, 25,251,107,164, 84,
110, 97,196,127,209, 10,123, 74,193, 80,132,137,198,175,187,111, 57,108, 72, 65,
 80,128,234,123, 33, 99,160, 23,116,187,244,153,251,119,170, 62,191, 83,174,154,
 19, 76,244, 93,179, 58,146,130,163,123,252,245,116,178,171,135,173,182, 20,199,
168,117,184, 43,205,  3,235,190,178,186,  1,165,117,111, 85,163,  4,201, 34, 40,
104,203, 69,139,131,152, 50, 12,157,121,244, 41,192,209,169,179,125, 80,104,151,
 49, 24, 76, 54, 71,220, 40,230, 43,131,131,183, 34,199,210,111,226,232,199,151,
231,170,214, 29, 88, 92, 37, 66, 41,  8,151,126, 94, 65, 22,248, 82,200,137, 19,
144, 22, 61, 11,236,198,128,107, 53,217,251,142, 81,248,110, 93,235,162,147,140,
113, 49,128,126,175,249, 96,161, 60, 49, 43, 95,219,  6,156,244, 46, 78,190,157,
  2, 16, 19,201,127,164, 70, 29,144,113, 36,182,124,177, 66, 76,193,  1, 57, 61,
 74,246, 32,100,231, 57,  4, 17, 23,101, 30,113,214, 26,162,140,117,136, 41,165,
242, 46,234, 23,204,150,144,206,135,250,180, 32,228, 72, 26, 12,175, 38,213, 89,
162, 74,136,102,166, 96,192, 57,210,146,149,159,234,230,115,204,166,123,119,166,
158, 84,138, 27,  4,207,168,198, 52,200, 50, 21,110,119, 14, 67,250,193,182, 30,
205,176,100, 54,112, 31,  6,100,214,198,103,221,254,226, 96,236,123,  4,100,110,
 66, 81,223,212,161,204, 84,252, 11,123, 24,111,  7,234, 84,153,149, 39, 87, 78,
153,168, 85, 26,206,106,108,210, 43, 47,111,169, 88, 17,107,230, 88,128,111, 12,
 26,122,112, 49, 27,225,102,203, 34,246,189,127, 11,150,129,231, 35,165,218,157,
 25,133, 86, 38,  5, 71, 58,115,243,131,242,136, 22, 88,104, 80,104, 65,123,166,
252,173, 96,112,204,232, 74, 67,162,133,180,120,  2, 91,  4,122,234, 32, 87,123,
 26, 74,109,247,238,225,183, 50,124,125, 12, 35,249,217,176,208,249, 25,163,147,
 31,254, 41,132,  2,107, 53,138, 16,178,110, 68, 21,194, 35, 71,181,152, 72, 39,
180,  8,195,194, 62,220,  7, 11, 55,156, 26, 22, 20,209, 69, 67,255, 96, 55, 99,
 72,253, 54, 78, 44, 36, 50,222,183, 22,153,186,164, 70, 79,182,219,176,120,155,
 86, 40,247,  7,  6,120, 41, 95, 11,111, 15, 22,142,164,112,216,110,255, 24,200,
224,212,133,  9, 55,189,168, 24, 73,255,119,103,  0, 62, 21, 12,147,252, 82, 46,
162, 39, 56, 37, 37,220,134,216,235,131,148,216, 16,179, 48,186, 95, 73,163,192,
176,133,231,127, 33, 60,225,139,111,144,197, 90,206,195, 78,186,132,184,145, 72,
 23, 95,179,104,123,132, 71,156, 91,188, 39, 17, 10,189,243,  0, 41,192,219, 94,
134, 48, 66, 96,158, 13,133,100, 78, 71,134,236,251, 66, 58,141,111,121,247,255,
187,185,  7,202,128,193, 40, 15,114,221,198,243,242, 55, 45, 73,246,233,127, 64,
 94,227,158, 52,142, 49, 72,252, 49,173,163,107, 30, 90, 99,136,186,169,167,234,
 31,144, 17, 16, 52,120, 17,150,105,117,193,181,159, 99,199, 99, 84, 25,158, 88,
233,229,  7,234,126,200,  2,124, 53,  7,161,124,154,151,209,124,194,236,150,212,
222, 11, 90, 52, 59,233,120,202, 16, 57, 15, 12, 59,245,157,112,218,113,114,163,
223,227,155, 24,144, 13,  9,230, 42,188, 91, 75,195,231, 38, 12,254,153,109, 72,
106, 68,149,245, 48,  1,217, 31,123, 99, 11, 55,211, 88,110, 43,174,154,251, 70,
 74,147,178, 98, 16, 85, 48,  9,183, 30, 78, 11,187,245,100, 68,138,132,137, 21,
 45,198,232,207, 38, 95, 21,203,155,  8,163,171,240,  3,157,242, 39,212,110,189,
200,137,171, 70,113,162,171,188,248, 87,219,197, 78, 17,157,232,108, 11,199,239,
 66, 50,109,165,  5, 11,  3,106, 40, 18, 80, 12,241, 81,206,101,239, 72,192,197,
 77, 91, 93,135, 77,168,121, 20,175,150,240,169,208,156, 10, 87, 34, 51, 22,214,
 27, 53,106,106,113,167,115, 59,150, 43,229, 90,  5,  9,170,207, 25, 68,  3, 66,
165, 68,  0,116,115,136, 94,210,140, 85, 30,  4,107, 14, 98,122, 43,194, 10, 12,
103,148, 98,226,234, 30,154,125, 26,171, 90,195,101, 70,239,157, 13,148,252,194,
177, 69,151,164,102,133,245,212, 63, 12,167, 59,116,135,235, 22,106,163,162,116,
 26,118,228, 36,216,155,149,173,127,203,252, 48,217, 48, 39, 27, 81,107, 21,135,
  8,239, 26,119,213, 52, 15,161,165,128, 69,196,118, 65,138,  0,221, 88, 12,186,
214, 73,178, 68, 82, 76,131,168, 18,254,162,163,237, 42, 44,120, 22,185,118,133,
233,245,150,101,  8,162, 50,255, 77,153,122,234, 36, 96, 94, 37, 77,101,109, 28,
149,223,154, 75, 79, 70,169,155, 21,  9, 52, 76, 80,115,243,119,  8,106, 36, 79,
112,143,169,169, 68, 48,242,210, 88, 19,199,206, 18, 85,189, 18,173,232,145,194,
 97,131, 98,148, 16,101,  5, 21,115,136, 33, 62,211, 82,197,148,194, 17,  5,  6,
199,213,195,249, 37,193,193, 17, 45, 16,116,147,193,216, 14,131,121, 57,156, 86,
 44,229, 24,209,193,207, 49, 41, 81, 97,207,  9,199, 63, 23,195, 11,111,192,151,
194,176,  7, 99, 40,192,150, 46, 38,222,201, 41,176,200,242, 48,119,164, 86,226,
 83, 10,210, 70, 63,  3,115, 43,128,206, 70,155,191,117,  4,240,251,232, 89,240,
146,226,132,103, 67, 34,219,254, 64, 58, 80,171, 40, 53,207,190,149,250, 13, 14,
177, 35,238,190,135,119, 98, 19,196,208, 53,207,240, 41,218, 82, 31, 85, 50,176,
114, 51,  5,  1,154,183,125,101,201,  0, 11,244,144,  5, 78,169,243,223,104,241,
208, 34,212,131,237, 88,181,103,220,249, 49,246,174,115,163, 33,121,156,237, 95,
 52,107,117,  9,230,127,144,105,123,188,169,155, 85,103, 37, 60,186,206,186,215,
 35, 71,164,177, 85,181, 77,121,130, 69,  3,156,194, 15,255,115, 72, 48, 81,208,
 38, 36,176, 93,129, 12, 27, 90, 82,152,229,138, 68, 49,111,250,217,185, 33,104,
 32,210, 76,169,230, 21, 37, 62,137, 26, 62,170, 26, 64, 11,144,206, 83,  3,122,
134, 61, 95, 23,  7,163,233,196, 26,229,158, 94, 82, 61,148, 27,197,254,238,153,
 83,  4,127,139,229,100,139,232, 82,133, 63,129, 93,253, 70, 50,240, 70, 28,150,
229,159,211, 96, 40,156,141,209, 93,219, 33, 86, 77,106, 55,165, 56,110,216, 91,
 91,  5,233,192, 14, 73, 39,138, 83,128,211,213,183,237,189,179, 20,152,184, 67,
200,189,216,247,104, 56, 27,196,  6,201,  3, 27,233,158,118,255,170,217,  2,  9,
171,137,139, 30,190,121, 43,226,115,188,255, 52, 63, 81, 72, 77,  1,143, 91,115,
 65,241, 65,249,112,124,116,163,163,245,  9,152,225,219, 36,167,161, 54, 91,210,
 25, 21,180,  4,232,245, 63,253, 56, 82, 51, 64,219, 36, 78,  2,204,245,142, 15,
161,118, 30,228,124, 86, 33,174,134,225,216,137,167,195, 21,244,141,  3, 47,201,
162, 21,246,228, 92, 10,163,162,109,216, 41, 65,142,235,185,141,194, 26,234, 74,
 67,206, 39,205,193,  6,211,191, 16,129, 84, 77,226,162,164, 88,132,252,211, 61,
 29,171, 68, 57, 49,138, 17, 19, 21,192,244, 73,168, 84,255,158,  5,  2,185,193,
 18, 90,126,204,133,178,205, 30,237,123,131, 30,  1,123,200, 61, 30,199,122,233,
 58,118,184, 92,175, 85, 94,236, 39, 32,143,  3, 69,157, 86,105, 48,  4, 97,  4,
 77, 17,195,  1,224,209, 38,155,214,118,245,204,180,105, 51,159,202,114, 65, 57,
227, 54,250, 23, 45, 65,255, 16,170,165,181, 66,114, 23, 22,216, 47,190,226,226,
165, 74,  8, 58,155,161, 60,  8,145,162,205,143,133, 19, 24,192,162,173,168, 75,
 82, 23,  6,194,  1,  2, 15, 17,102, 54,200,228,129, 25,128,103, 64,190,163, 22,
 59, 99,209,249, 52, 94, 87,164,  2,226,183,147, 73,162,239, 19, 24,106,  9,  8,
203, 28, 77,225, 20, 62, 54, 48, 42, 15,122,  1,103,101,165, 49,251,130,  7,144,
201,254,123,  2,182,194, 37,164,195,139,174,122, 83,223,  3,164, 27,  5,233,208,
 15,213,225,221, 19,148,107,195,174, 33, 70,  8, 44, 72,160,240, 62,150,228,179,
165,145, 12,185, 27,180, 96, 46,252, 33, 21,120, 16,252, 12, 55,201,225, 41,108,
242,227, 92,111,143, 57, 26,143,106,133, 86,108, 90,232,202,  6, 10, 41, 91,221,
 42, 11,247,131,203, 20,178, 34,119,242,169, 82, 94,137,163,161,221,138, 43,189,
116,152,191, 36,245,  0,161, 72,200,112,193,253,133, 10,161, 50,142,241,143,  8,
149,248,237,178,197, 11, 42,217,130,  1, 63, 44,  3,149, 91,128, 99,188,145, 78,
 59, 11,206, 54, 23,  1, 38,202,111,197,190,244, 62, 82,240,226, 43,155, 25, 53,
141, 88,182,206, 57,199,206, 52,184,  3,152,236, 92,176,  0,228,213, 50, 76,163,
250,140,241,222,195,170,121,207, 97,173,109,191, 89,222, 48,  7,138, 67,156,118,
138,133,185,118,214, 57,182, 35,254,181,  5,227,163,148,113, 41,137, 25,233,136,
 37,113,134,125,119,231,145, 10,180, 59,254, 22, 87,170,117,229,181, 91,134,124,
174,210, 43, 25,186,157, 50,102,237,240, 17, 23, 13, 46, 91,162,173, 45,186,239,
123,175, 73,181,213,203,149,248,195,188,184,172,187, 49, 23, 75,187,164,226,131,
166,144,154,240,241,211,  1,127,155,192,189,100, 93,117,105,148,158,226, 44,140,
241, 92, 29,164,109, 15,134, 80,142,108,195, 30, 67, 91,151, 50,253,151,188,  1,
162,216,230, 48, 48, 67,149,172, 96,113, 26,241, 21,253,107,232,178,123,131,  1,
165,147,  4, 47,240,  3, 28,159, 83,151,148,186,231,253,206,108,166,246,215, 48,
191,140,220, 42,181,235, 30,143, 60, 77, 80, 96, 82,124, 57,135,131,137, 34,182,
 12,115,242,200,148, 80,201,143,139, 74, 21,113,242,217,109,130, 39, 15, 73,177,
117,180,174,106, 75,  0, 41,188, 62, 51,141,  1,115,235,209,220,  4,138,161,187,
136,230,229,199,236, 61, 23,111,180,123,168,160,134,114,135,137,241, 66,196, 87,
206,129, 43, 69,182,246,180, 46,240,219,172, 90,  5,150, 16,148, 19, 58, 55,103,
 32,  7,222,142,217,190,230, 27,110,144, 23,167,254,216,111, 21,199,161, 49, 97,
162,110,  7, 38,162,118,  5, 15, 16,241, 28,138, 65, 57,119, 35,174,201,176,245,
161,113, 24,235,162,107, 69,  7,194,123,199,120,222,109,167, 77,127,192, 53, 66,
 22,122,240, 38,201, 82,150, 87, 24, 18,246, 40, 64,246,196,200,206,133,125, 46,
182, 11, 86,151,195,226,178,244,192, 35,255, 23,214,171, 82,  2,235, 51,191,170,
183, 38,188,162, 49, 42,253, 15,159,218, 36, 54, 95,146, 42,167, 33,243, 60, 28,
 34, 15, 13, 36, 43, 57,247, 73,171,154, 11,241, 11,139,206,184,191,176,125,165,
 89, 70,117,218, 64,234, 20,245,237, 85,182, 79,219,165, 93,196,168,223,146,110,
194,120, 10, 45,216,213,245, 91, 30, 66, 44,184,230, 15,242,239, 90, 18,188,134,
 67,254, 71,141, 64,237, 12,226,203,148,233, 71,231, 22,226,103,222,247,  2, 69,
247,124, 68,252, 69, 24,115, 84, 91,133, 95,242,223, 39,146,190,220, 90,172,149,
201,  3,198, 86, 72,102, 92,210, 77,  1, 86,255,123,244,129,193,140,236, 66, 33,
221, 94,  7,133, 80,221, 81,  7, 71,134,213,245, 72, 97, 26,244, 30, 11,112,224,
 55,178,247,239,236,194, 92, 31, 58, 94,214, 48, 45,223,165, 33,216,177,158,204,
129,231,220, 39, 67,132, 78,208,165,  7,245,192,156,131,208,201,163,  5,188,163,
 86,192, 33, 82, 90, 44, 75,164,114, 29, 43,167,146, 13, 71,158,164, 21, 91, 14,
122, 35,148,103, 75,249, 68, 33,159,214, 28,210,211, 74,164,188,154,255,227, 65,
236, 43,203,203, 96,142, 57,233, 74, 58,153,216,214,152, 30,187,178,161,226, 99,
 68,212,223,  7,196,158,214, 82,  0, 92,227, 75,113,137,171,122, 65,117,239,169,
 93, 89, 96,132, 70,  8, 50,181, 16, 98, 96,131,241,153,142,198,169,111,240,  0,
 10, 51, 59, 37,192,146, 47, 68,110,246,128,145,144, 71,136,139,185,211,172, 34,
148,132, 42, 36, 98, 26,104, 97, 90, 35,253,180,173,208,127, 91, 84,179,180,  2,
 48, 29,189,226, 78,173,102, 86,146, 83,151,208, 99, 59,163,248, 50,158,246,187,
100,159,139,135,113,146,120,216,183, 96, 25,101,143,162, 41,101, 17, 20,110, 66,
169,242,193,183, 66, 25,160,249,225,  4, 48,203,223, 31,134,199,173,120,208,160,
  5, 11, 37, 41, 18, 30,192,196,  6,200, 53,248,237,  4, 73,119,165, 50,254,148,
119, 21,  6,162,239,196,169,208, 16,124,201,153, 88,206,254,232,  4,172,139, 87,
144, 10,245, 18,141,170,239,186, 16,118, 40, 29,167,153, 96,100,196, 58,121,131,
 33, 27,180, 15, 71,215, 82,199,249, 82, 91,118,241,152,  5, 27,165,224,239,112,
219,145, 63, 91,153,205,203,131, 92, 82,242, 66,218,178,122,135,255, 93,119,131,
  3, 32,103,163,105, 18,125, 77, 24,255,250,115, 69, 48,216,148,197,148,187, 17,
 82,  8, 50,194,134, 13,221, 39, 44,243, 55,139,142, 77,159,210,197, 12, 92,137,
 95,193,103,139,225,220,190,227,215, 91,109, 93, 93, 23,158, 80, 98,208,159,144,
  5,244,242, 94, 42,100,  2, 93,  3,202,123, 20,128,244, 83, 59,129,137, 64,  5,
255, 85,201,250, 93,138,203,198, 31,118, 24,234, 55,207, 77,115,149, 95,137, 22,
 51,202,170, 84, 12, 14, 87,144,213,129,235,252,116,185,142, 30, 61,206,169,184,
116, 39, 48,253,130,242, 51, 31, 14,110,167,184,135,128,207,100,182,146, 86, 44,
180,235,224,253,193,139,184, 65, 68,131,182,229,216, 99,141,169,254, 53,166, 83,
180,253,208,145,110, 63,134,116, 33, 33, 85, 48,225,173, 72,219,199,209, 98,197,
 75,196, 17,249,144,100,205, 77, 37, 64, 83,163,186,223,251,113, 30,123,188, 82,
136,216,134, 87,232,203,104,109, 56,136,251,251,106,210, 78, 72, 75, 14,182, 67,
 41,130, 73,229,255,154,172,216,229, 82, 78, 60, 85, 65,199, 79,159, 85, 27,  4,
 44,234,194,147, 90,123, 31,205,133,185,216, 19, 93,134,120,126,192,226, 44, 99,
 76,172, 46,152, 88, 69, 16, 55, 17,157,237,140,230,138,135, 23,105,132,146, 48,
214, 72, 36, 86,119,156,222,223,126,  0, 43,238, 83, 42,156, 67,108, 89,171, 52,
 46, 20,111,182, 88,184,185,  4,198,126,140, 69, 11, 48,191,195,170, 43,  3, 86,
 92, 98, 47,115,193, 52,242,104,129, 77,245,217,210, 80,161,185,248,236,  8,174,
229,119, 70,236,123,144, 63,  6,252,169,151,202, 32, 63,219,209,229,233,128, 34,
 12,205, 32, 11,237,178,  3,142,147,135, 43, 93,234, 69,103,166,180,241,201,107,
  4,164,161,243,  6,195, 89,126, 60, 28,132,101, 92,254,170,186, 76,153,194,178,
 43, 83, 13,203,213, 39, 67,231,123, 38, 47,208, 29, 62, 54,163,198,204, 73,195,
  2,210,186,184,  0,169,222, 23, 88, 62, 16,102,109,143,131,226, 18,198,  7, 59,
169,208,215, 92, 64,143,212,  9, 63, 96,135, 20, 14,174,128,135, 30,148,135,129,
252, 89, 40, 47, 34,133,232,104,205, 60,163, 44, 13, 12,158,153,146,146, 36, 13,
180,224,166,201,221, 60, 90,246,108,111,251,109,141,187,  7, 82, 14,  5,158, 57,
 27,247,246,238, 37,181,141,102,178, 51, 85, 31, 87, 60,210, 99,240, 34, 31, 23,
 22,207, 51, 72, 21,167,103, 19, 29,253, 29,153, 19,139, 40,107, 66,227,235,163,
224,231,159, 38,123, 27,243,113,169,211,199, 31, 31,232,238,142, 82,205,166,129,
227,122, 37, 57, 51,164, 92, 64,178,153, 16,128,130,192,152, 31,145, 93,254, 14,
206,224, 72,140, 56, 14,160, 42,176,117,216,124, 79,229,133,128,194, 18,230, 61,
 80, 82, 94,202,185,196, 26,234,221, 37, 46,141,128, 64,145, 73, 15, 49,137,253,
238, 99, 65, 71, 89,240,208,  4,  7, 41, 96, 63, 19,104,153,128,158,122,123, 30,
  0,186,179, 47,253, 93,135,248, 80, 67,226,140, 40,110, 24,244, 66,113, 15, 49,
  1, 11, 16,203,103,177, 33, 22,147,  0,199,195,185,186,116,177,119,238, 99,182,
207,226,183, 44,242,180,171,140,116,233,151,122, 64,108, 55,225, 34,196,146, 52,
204, 92,236, 19,102,177,106,141,158,148, 65, 89, 38,144, 11,152, 54, 21,148,222,
158,143,198, 80, 75, 32,212,208,163, 48,170,165,  6, 46,246,  2,  3, 46, 15,173,
196, 83,201, 89,197,140,185, 12, 14, 57, 74,229,169, 52,231,195,140, 72,226, 64,
132,102, 73, 94, 16,255,248,123, 86, 29, 41, 99,184, 82,183, 43,194,183,  3,227,
215, 94,169, 34, 30,117, 21,103,102,  3, 47, 35,152,185, 47,207,223, 30, 41, 47,
133,211, 26, 72, 78,203,166,201, 10,209,252,249, 71,141,222, 87,225,234,177,212,
 60, 48,147,  8,208, 80,  6,179,138,219, 78,184, 96, 13,141,170,192,154, 44,105,
219, 73,192, 14, 14, 42, 34,223, 71,227,185, 17,155,208,101,249,250, 81,102,109,
  2,209,167,223,  9,232,231, 36,228,225,182,112,151,240,163,242, 50,143,202,213,
227, 25,190, 37,155, 60,105, 90, 41, 31,116,143,253,139,173,124,173,183,239,160,
  6,185, 94, 89, 47,119,169,193, 38,190,180, 98, 29,245,123,197,143, 33,113,202,
 34,225, 63,195, 46,182,122, 16,168,138,183, 55, 48,160,134, 27,233,168, 84,119,
 51,  0,207, 84,211, 24, 71, 91, 39,  0, 33,131, 25,117,141, 27,108, 27,113,197,
 97,117, 76,206,125,102,182,148, 24,160,199,196, 33,145, 95,254, 31, 79, 37,125,
153,135,  7,173,233,112,133, 98,246,  1,133,238,102,182,150,169,107, 58,172,  0,
179,224, 54, 10,146, 57, 13,158,216, 57,183, 98,  3,210, 96, 74, 38,190, 82, 74,
 62, 23, 63, 61,130,184, 18,223,199, 27,181,220, 43,158, 70,213,109,206,190,121,
115, 13,200, 76,194, 11,104,206, 57,145,142, 16, 13,149, 68, 97,100, 44,227,135,
 68,  3,210, 88,121,206, 88,125,134, 68,169, 35,105, 73,117,202,121, 10, 72,182,
235,184, 37,148,224,190,143, 28,207,103,  8,209,245,156,253,115, 51,204,206, 86,
 65,148,173, 72, 54, 48, 32,199,161,242,115, 67,114,218, 20, 62,180, 27, 24,144,
 12,118,242,243,200, 88, 62,148,179,225,239, 88,139,174, 68, 53, 50,  0, 72,246,
 57, 78,105,160,169,123,253, 70,146,178, 42,231,173,102,166,101,  9, 40,113,129,
216, 25,211, 38, 60,125,117,156,103,194, 94,173,236,157,253,158,140,105,252,149,
165,102, 74, 50,108,112,247,153,127,158, 27,161, 77,149, 91,  9, 38,156,134,163,
168,184, 66, 73,207,108,245, 12,159,213,247, 90, 25, 33, 31, 75,  9,107, 16, 10,
175,105,225,183,211,192,126, 65,106,157, 51,238,167,152,233, 86,152, 45,120, 31,
  1,125,143,117,  4,134, 69,171, 72, 76,201,217,200, 96, 65,198,123,137,249, 49,
153, 40,204,  0,200,134, 91, 84,214, 29,122,143,  3,237, 28,137,208, 89,221, 98,
  9,189,190,243,123, 61,124, 77, 64,255,238,225,239,213,183,115,133, 11,239,144,
252,111,168,  4, 71, 14,240,106, 33,160,137,156,245,172, 22, 14,182,168,237,201,
 83, 38,159,  6,164, 58, 92,133,146, 54,180,141,195, 28,179, 13, 85, 10,219,137,
  0,210, 11, 42, 44, 19, 23,142, 73,251,121,253,  2, 29, 31,210,224,  5,  3, 34,
 50,113,214, 68, 47,199, 41,170, 89,247, 48,204,250, 81, 36,157, 60, 47, 14, 20,
162, 67,181, 15,141,181, 31,207, 15,135,249,223,108,103, 92, 12,150,141,177,  9,
 14,184,168, 95,  7, 82,135,  5,133, 68, 58,146,154,115,  1, 14,121,211,172,  7,
240, 18,134,176,102,150,139,134,105,168, 22, 79,111,138, 62,133, 41,130, 41,  6,
231,190,161,167,144,165,  8,185,193,212, 44,139, 80,182,255, 12,221,209,178,190,
161,155,225, 75,245,236,118,246, 31, 40, 10,224,172, 26,187, 45,170,163,110, 58,
 31,140, 16, 36,  5, 71, 16, 26,140, 27,240,134, 36, 87,251,140, 93, 71,130,  4,
  7,110,234,173, 21,  0,125,187, 29,147,  0, 78, 35,117, 45, 61,227, 42, 39,  5,
135, 75,151, 27, 88,206, 47,108,239,121,234,201, 50,216,126,143, 94,240, 98,219,
168, 63, 42, 56,180,155,241,192, 24,189,197, 42,162,132, 82, 91, 70,158, 80,186,
 83, 71, 88,208,119,229,182,225,168,114,170,224, 20,202, 74,127, 82,247,180, 74,
 86,253, 10, 89, 37, 41,129, 98,239, 48,183,  6,170,158, 99, 34, 99,185,155,252,
 40,174,132,  2,235, 74, 91, 46,101,237, 10, 67,135,218,119,192,151,200, 63,177,
 44,216,119, 36,111, 63,201,201, 79, 18, 67,218,104,  1,146, 17,  2, 17,130, 80,
 33,146, 13,183, 23,152,133,201,119,219,108,209,254,251,215, 61,188,  6,112,163,
 28, 52,112,204, 90, 25, 73,225,154, 50, 78, 58,  2,177, 32,127, 49,105,170, 35,
 30, 20,116,  9,127,152, 49, 14, 65,190,168,148,149,182, 96,108, 83,131, 12, 83,
 81,  6,254,  1,218, 20,235, 57, 92,145,125, 41,105, 53, 21, 10, 90, 54,123,  8,
  0,226,246, 33,253,120,  9, 43, 14, 21, 18, 48, 61,119, 58,148,229, 32, 84,166,
 86,149,182,186,140, 38,195,242, 73,214, 23,200, 22,114,208,167,190,  0,175,140,
 29,124, 26, 23,203,229,189,143, 67,201,220,  5, 50,162,114, 81, 21, 85,219,180,
131,169,170, 58, 40, 45, 36, 60,107,225,252, 31,182,167, 45,225,116, 78,213, 46,
147,128,210,217, 94, 44,209, 25,  2, 30,117, 31,248,201, 79,159,112,246,211,102,
 73,140, 30, 45,132, 73,167, 95, 16,207, 12,205, 65, 10, 62,200, 78, 22,142,194,
236, 24, 96, 49, 20,249,157,250,146,196,115,255,150,188,254,152,169,145, 54,  3,
  4, 87, 90, 51, 32,130,220,109,194, 99,216,183,139, 24, 32, 85, 49, 52, 95, 45,
188,124, 25, 47, 66,220, 13, 88,  7,156,  3,147,  9, 59,191, 12, 25, 94,216, 84,
102,226,167, 11,146,163,  9, 14,244,120,121,242, 27,105,127,213, 88, 34,227, 92,
228,179,126,162, 81, 81,127,125, 17, 73,139,138,139, 28, 84,224,123, 43, 41,113,
  0,208,220, 22,138,239,145,249,  0, 55,215, 36, 13,214,167,229, 46,153, 91,117,
 93,104,231,130,145, 88,100, 10,221, 38,216,214, 79,145,200,237,217,148,  7, 33,
 80,192,  6,188, 48, 69,201,169, 64,245, 21,  5,171,188,149,186,250,249,178, 58,
117,205, 36,166,233,246,170, 87,  4, 82, 66,145,195,183, 49,  1,109,186,172,113,
243,251, 15,253, 40,202,150,240,  6,228,193, 47, 90,249,146, 77,131,228, 77,110,
246,200,129,127,188,247,179,  9,199,125,163,  3,171,120,164, 91, 98,  9, 36, 59,
115, 26,120, 27,123, 75,  8,240,240,255, 35, 11, 42, 41,176,132,119,182,185,225,
130,124,121,162,120, 71,248,250,120,136,215, 84,254,163,231, 13,183,107,125,100,
120, 85,184,140, 61, 34,111, 32,170,240,170, 39,  2, 47, 25,174, 65,217,193, 71,
 62, 76,162,137,140,206,148,189, 47,141,179, 36,109,154, 73,255,203,207,103,  6,
 31, 58,248,209,183, 28,116,164, 47,236,180,207,  0,136, 67,181,132,177, 84,185,
 36,101,  3, 29,250,233,224,241, 18, 98,211,234,119,220, 60,105,125, 92, 34, 67,
 99,137,106,112, 45,173,237, 53,132,138, 43,112, 54,238,225,165,213, 33, 96,227,
178, 95, 84,142,198,147, 76,148, 24,  1, 66,116, 91, 18,241, 51, 94,135,111,195,
117,215, 79, 13, 63, 28,110,129,157,136,112, 28, 33,  0, 22, 34,  0, 28, 17,249,
 94,109, 72,149,212,229, 31,210,195,225,192,218,146,248,195,149, 40, 97,104, 45,
142,  6, 76,201, 21,147,199,  2,208, 81,218,252,181,156,158,172,101, 50, 80,  1,
 95, 54, 82, 87, 92, 32,137,118,210,250,205, 97,122,247,209,124,179, 77,214,242,
133, 82,108,186,175,215,203,134,204,211,186,172,118, 67,178,198,211,184,114, 98,
143,202,  8, 12, 25,144, 53, 96,149,121,221, 58, 68, 67, 93,252,137,179, 42,210,
130,139,178,227, 37, 31,172,153, 78, 75,253,126, 18,227,161,208,205,213,196,189,
115, 53,123, 17,227, 27,176,115,248, 65, 96,  4, 39, 39,160,147,163,163, 52,124,
221,119,123,227, 40,122, 32,232,196,100, 13,231,254,  3, 83,193, 93, 85, 30,223,
135, 61,201,168,183,241, 15,100, 92,193,186,100, 48,184, 52, 21,168,169, 77,241,
236,242,170,239,227, 82,157,146, 33,222, 80,249,239, 71, 22,180,138, 69, 88,156,
 10, 36,162,240,124,209,142, 33,177, 88, 77,201,234,194, 59, 19,172,181,110, 93,
 75,206, 18,136,160, 22, 18,100,103,170,189,142,148,147, 42,113,230,164,250,153,
  5,137,193,240,236, 75,139, 68,226,210,162,159, 57,102,192, 12, 79,184,172,233,
140, 80,  6,204,132,207,120,  5,183,245,243, 41,151, 16, 32,178, 54, 19,245, 58,
 57, 60, 81, 93,247,231, 99, 42,239,242, 64,110, 94,181,229,170,  5,  3,115,140,
160, 93,176, 24,246, 35,154, 96, 85,104,240, 42,167,171,172,155,190, 98,  8, 19,
183,222,246,196,130, 94,216, 54,171,126,108, 56,246,  9, 76,  9, 76,114,149, 81,
 25, 65,246, 10,  8, 80, 57, 98, 42, 81,132,  8, 21, 60,171,233, 64,145,176,223,
137,157,109, 82,196, 35, 27,  1, 76, 57,248,181,184,108, 37,192, 32, 42,197, 28,
 93,  8, 65,113, 69,247,185, 37,248, 91,158,230, 58,115,129, 49,203, 58, 49,142,
174,224,111,162,235,169, 83, 99, 62,165, 60,226, 39,161, 30, 57,150, 79,240, 79,
127,228,211, 18,170,143,152,187,120,  3,191,163, 57, 42,177,194,249, 90,246, 32,
 33, 16,147, 13,210,119,140,200, 57, 18, 91,178,209, 63,236, 54,111,101,226,157,
 47,248,141,227, 63,239,193,115,161,212,104,111,245,230, 38,170, 69, 34,246,252,
108,148,  9,112,171,  9,183, 12,134, 95, 12,187,148, 62,106,106, 29, 72,233,202,
127, 19,217,231, 15,110,250, 21, 71, 15,144,216,131,214, 83, 28,113,111,186,210,
  8,127,156,174,  0, 38, 59,182, 41,208,240,186,  1, 80, 90,  8,231, 19,167, 47,
 46,229,141,196,220, 41, 25,204,153,241, 65,127, 20,206,149,247, 33,179,140,229,
 94,156,246,  7, 87,120,234,  1, 92,  2,174,  0,171,  0,169,  0, 23, 14, 20,177,
135,161,131, 68,162,103,176, 57, 49,144, 17, 54,103,  8,169,116,223,231,121,156,
133,219,180,138,167,138, 86,244,212,131,145,232, 46, 33,233, 33,148,117,217, 70,
227, 85,186,173, 58,190,214, 83, 31,114,241,190,  8, 77, 67, 26,139, 26,151, 58,
152,154,154, 36, 28,127, 75,240,125, 31,101,117, 42,178,150,114,113, 88, 17,125,
 81, 69,235, 56, 10,235, 73, 64,143, 83,  7,104, 40, 14,162,181,233,125, 14,252,
 29, 76, 18, 89,108,107,231,118, 92, 38,204, 76, 86,108, 54,135,240, 51, 30, 11,
166,213, 99,  9,  4, 73,215,189,150,158,116,169,101, 83,156,169,170,170, 75,114,
 79, 30,201,177,100, 49,104,169, 81,150,170,233,243, 54,210, 20,164,198,  9,156,
148,124,  1, 50,187,211, 56,142,164,  3, 21, 25,  7,174, 71, 35,253,100, 24,237,
243, 48,153,138,  7,241, 61,164,226,199,134,216,122, 20,173, 83,253,188,174,101,
203,174,150, 34,243,184,122,233,205,211, 36,127, 70,232, 83, 70, 15,235,135, 26,
183,185,116, 51, 52, 68,104,121, 50,201,222,151, 94,145, 99, 45,218,166, 51,119,
103,188, 30,167,240,122,213, 95, 65,174,108, 92,151, 80,113,195,249,182, 12, 32,
 23, 84,217, 26,243,163, 50,225,101,154,195,142, 40,154, 70,243,109,157, 39,131,
 89,146,223,185, 62,122, 10,108, 72, 29,178,204, 89,126,167, 35, 18, 75,211, 46,
235,186,122,237, 54,176,254,253, 47,187,100,152, 77,116,144,135, 31,129,232, 60,
 12,141,226,187, 60,180,210,239,125, 92, 69,144,130,197,142,229,211, 50, 12, 38,
 11,115,210,140,231, 50,106,198, 68,169,168,140, 73, 79, 30, 27,132,232,146,234,
 76,157, 43,122,127,130, 94, 16,  3,252, 29,235, 32,225,190,236,251,161,211,224,
162, 47,  1,209,182,128,173,  2,116, 90, 22,187,103,164, 34,240,175, 99,252,151,
113, 89,197, 49,140,150,142,205, 91,159,131, 62,136, 43,189,151,182,189, 91,245,
159,143,159,164,144, 19,124,126,122,142,165,251,186,213,171,237,204,123,250,162,
151, 54,149,159, 95,252,241, 53,210,142,100,120, 93,218, 21,103, 99,217, 30, 22,
 36, 50,107,240,245,177, 47,172, 25,168,108, 77, 33,208,139, 37, 44,103,171, 49,
248,161,123,191,115, 71,233,232,139,143,171,104,180, 11, 69, 20,121, 46,  5, 93,
150,132,100, 51,253,116, 34,183,146,  2, 95,203, 60, 90,100,142,147, 99,182,192,
244,182,220, 92, 90, 78, 10,195,104, 41,207,200,232, 20,247,  7,215,170,189, 57,
113, 75,106,106,  0,233,125, 51,175,142,128,  0, 81,128, 76, 73,137,225,111,116,
222, 97,150,213, 18,172,219,  3, 43,152, 29, 57, 64, 80,104, 77,211, 54, 43,119,
 44,250,161,248,186,191,241, 31,  1,199, 23,191,207, 57, 27,155, 88, 99,226,251,
136,138,154,130, 26,154,214,214, 16,109,119,229, 97,227, 59,187,115,133, 88,212,
251,117, 83, 83, 63,250,145, 41,248, 21,144, 50,153, 19,240,169, 24,242,144,110,
 30, 24,  8,101,223, 25,  9,  7,142,118,161,162,203,143,173,222, 35,210,231,250,
168,101, 85,183,137, 70,210, 20, 57, 66, 96, 96, 64,204,249, 91,138,123,168,132,
186, 69, 45, 35,  2,  4,147,180,  0,  8, 52,139, 72,  3,138, 26,199,129,245,  1,
212,  0, 75,132,148,199, 67,210, 65,161, 24,240,141,193,198, 32,192,  4, 16,  0,
  0, 64,  0, 16,  0,  0,  0,  0, 29,165, 54,144,222, 74,225, 66,232,254, 26,177,
102, 46, 43, 96, 31, 54, 64,143, 86, 82,180,218,125, 94,210,223,128,152,246,144,
 85, 60,167,224,230, 44,255,133,153, 12,114, 66,238,124,214,170,132,182, 49,250,
220, 87, 75,238,  7,214,198,  0,223,224,152, 62,253, 67,174,236,163,119, 65,179,
215, 11,187,194, 64, 56, 58,216,196,239,207, 39,109,165,152,189,212,  7,252,212,
164, 72, 90,169,161,146,176,101, 39, 71,190,218,101, 54,138, 95, 99,160,135, 24,
202, 30,130, 47,183,209, 48, 79,143,120,215, 47, 35,  2,127,192,148, 97,152,184,
 34,123,  5, 12,131,113,161, 69,123,  7,255,163, 88, 35,224,188, 55,227, 27,134,
 29, 62,121,136,219, 45, 49, 27,165, 97,101,176,226,145,107, 92, 97,103, 88,123,
201,138,212,167,209,117,216,210,126,159,230,187,131,132, 35, 91,235,166,221,180,
198,228, 42,  2,213,126, 30,133, 24, 43,140, 72,165,202,143,165,189,113,162,102,
 94, 41, 42,228,  4, 77,161,144,142,231, 66,219,228, 60,128, 42,240, 29, 98, 47,
 20,131,249,126, 68,108,210,184, 79, 11,137,122,218, 96,132,  7,233, 69,  0,214,
102,183, 90,251, 21,  5,210,  0, 11,222,176,194, 20,153, 79,198, 53,168,215,254,
 23, 89, 83,208,214,174, 86,  6, 37, 68,236, 89,138,223, 21,148,215,180,184, 15,
 80, 61,235, 99, 73,137, 67,212, 66, 61, 57,196,102,148,109,152,173,227, 95, 58,
189, 64, 87, 97,121, 20, 58,192,244,  9, 49,147,177,241,108,216, 20, 23,210,254,
208,134,168,183, 92,211,127,238,122,204,194, 70,116,101,114,134,243, 15,172,205,
205, 56,213, 65,148,181, 47, 27,214,200,  6,146,146, 13, 51, 52,195,251, 64,  0,
 54, 35,217,101, 87, 52,174,106, 27,122,165,162, 62,239,140, 16,148, 96, 65, 28,
 39, 80,249,120, 52,192,237, 71,118,148, 35,196, 13, 57, 51, 90,117,201,177, 14,
126,138,109,121, 11,188, 66, 21,170,138,203,115, 98,171,212,188,229, 42,195, 91,
108, 44,153,127,192,124,132,215, 53,247,166,213,183, 83,241,131,208,227,159,227,
 56,164,165,254, 64, 30,207, 14,248,124,191, 69, 71,179, 97,205,  4,131,224,199,
189,124,143,  9, 93, 44,160,100,234, 12,185,  7, 78,120,170,106, 36, 24, 60,156,
217, 51, 64, 52, 99,213, 71,119, 39,194,159,170, 34,201,  8,121,210, 95,245,217,
210,198,188,209,202, 26, 12,234, 52,242,  2,180, 21,231,141,206,  1, 72,195,247,
 53, 41,230, 75,183,191,230,147, 52,179, 72, 56,117, 59,231,161,236,137, 66, 92,
185,199,112,194,158,217,254, 34,161, 89,198,234,183,221, 77,210,146, 13,117, 31,
 75, 67, 32, 83, 57, 51,102,192,227, 98,184, 28,  8,146,231,234,225, 93,196,148,
211,173, 63, 87, 76,127,162,190,146,245,200,253,231,192,177,  6,148,  5,  2, 58,
222,218, 39,211,107,122, 53,  5, 56, 26, 62,174, 37,123,224,244, 42,218,103, 68,
148,250, 80, 46,175,228,100, 45,196,113,132, 69,185,226,130,121,  9, 44, 68,132,
238,124,117,191,220, 24, 92,160,118, 96,129, 45, 77, 83, 47,250,153,147, 58,208,
 74,  1, 13,155, 95, 94, 37,155,156,163,193,233,191, 94,  8, 84,  7,118, 87,208,
180, 80, 23, 54,  8,139, 83, 30,146,  5,248,224, 98,169, 77,137, 77, 91, 59, 37,
 48,212,152, 97, 69,112,115,  4,178,237,233, 82,245,176,190,179,130,171,219,138,
186,184, 68,206,125,138,227,167,109,  9, 36, 81,141,112,224,171, 88, 69,111,237,
145, 65,205,100,  6,123,167,150,226,123, 20, 56, 64,106,211, 68,154,252,223,165,
 92,239,192,245, 71, 74,122, 75, 89,139,146,151,197, 50,137,250,198,230,241, 18,
134, 23, 29,204,224,128,  2, 94,136,131,147,204, 39, 21,215, 74, 59,222,214,216,
145, 23, 73,203,249, 29,172,147, 46,106,142,142,  4,253,101, 32,204,187, 70,244,
 59,241,161, 28,155,160,225,201,187,194,203, 12,254, 23,108, 24,119,135,208,119,
228,198,115, 98,215,210,219,234,111, 57,209,249,180,148, 28, 95,101, 53, 66, 32,
218, 88, 62, 31,171, 21, 23, 21,107,209, 81,160,152,241,170,252,105,159, 42, 74,
100, 71, 35, 51, 97, 84, 61, 61,147,242, 14, 61,162,214,188, 17, 33,157,168,169,
210, 17, 73, 69,214,226,222,  6,146, 42,229,144, 99,144,111,207, 78,207,231,246,
 31,214,  0,142,101,122, 68, 40, 24,150,180,230, 27,237,115,  0, 68, 39,220, 54,
 57,100, 48,221, 62,242, 66,252, 36,127,236,203,  9,249, 14,125, 72, 88,226,243,
192, 41, 70,148,216,208,114, 46,202,157,166, 62, 22, 37,167, 20,236,249, 66,202,
  6, 97,123,112,192,149,229,166,125,180, 75,207,  2, 44,137, 16,142, 51,195, 10,
  5,124,153,179, 92,158,224, 64,222,201,135,221,247,106, 30, 84, 73,255,177,217,
 63,205, 46,249, 33,133, 96, 95, 40,104, 31, 87,250,207,246,  3,235, 12,171,163,
233,103,213,182,117,228,208, 26, 14,197,  1,157,132, 99,146,180,207,218,145,253,
  9, 62, 44,247,106,197,197,208, 82,227,197,243, 15,232, 69,187,116,221,120, 50,
228,211,227,119,118,231,243, 83, 79,239,151, 29,235, 10,107, 78,132,110, 84, 88,
 20, 69, 78,150,120, 12, 56, 37,129,140,250,105,190,236, 93, 37,164, 56,251,223,
170,  0,110,210,247, 95,189,120,211,200, 10,234, 38, 46,  2,190,  2,177,141,227,
221,105, 30,171,212,166, 80, 11, 11,219,133, 10,103,216,176,246,253, 13,253,243,
 92, 22,167,125, 37,130,  8,  7, 57, 60, 74,117,224, 51,186,147,249,214,196, 52,
116, 77, 85, 91,251,224, 87, 17,151, 98,  6,158, 40,195, 37,243,137, 28, 45,140,
212, 67,241, 89,249,189, 59,172,248, 30, 99,181, 28,135,165, 96,105,103, 17,196,
154, 71,232,203,128, 73,145,212,188, 61,139, 54, 73,115,192,140,255, 24,143, 33,
122,223, 51,157, 45,  9, 78, 88, 72, 42,245,100,108, 58,196,213,115,138,188,154,
134, 62,222,176, 45,208,172,118,133, 18,112,180,197,151,237,160, 79,196, 25,180,
244,225, 10, 55, 98,160,102, 37,195, 72,187,115,182, 66,252,221, 39, 23,223,171,
 62, 60, 74,218,209, 72,201,207,247,128,174,  1, 54, 82,120,133, 92,210, 37,158,
159,107,151, 62, 22, 56, 47,172, 69,126,237,129,185,136, 42,245,139,219,145,142,
146,193, 18,244,181, 95,209,217,135,239, 98, 45,203,211, 32, 38,137,109, 80,149,
 44,  2,252,211,174,185, 56,  2,172, 24, 75,220, 65,202,119,109, 14, 94,126, 62,
 12, 67, 65,  3, 19,221,251,199, 63, 33,223, 81,204, 44,239,209,250,195,159,240,
 80,231,113, 50,168,120,214, 41,210,122,137, 72,234,155,181,184, 18,  4,147,194,
 52, 44, 73, 78,138,159, 75, 42, 35, 28,157,196,141, 51,198,167, 58,150, 50, 62,
246, 15,146,183,147, 80,216, 80,164,222,142,194, 72, 47,173,248, 84,242, 86,  6,
114,102, 43, 32,251,230,134,113,152,248, 47,206,196, 47,137, 64, 21, 18,192, 80,
233, 47,164,121,229, 34,  2,250, 59, 26,244,146,232,219,151, 82,208,168,173,236,
184, 33,225, 50, 80,122, 85,138, 47,169,232, 22, 39,101, 57,100,153, 99,229, 72,
232, 80, 11, 44, 50, 54,187, 81, 69, 92,  0, 92,149,189,231, 93,168, 74,194,203,
 15, 46, 64,191, 40,185,  6,129, 26,217, 56, 41,158, 78, 17,  5,157,138, 18,148,
141,203, 87, 49,175,124,  9, 80,226,219,148, 20,136,141, 39, 57,215,103, 72,  8,
235,224, 28,191, 23,245, 61,140,185,222,145,251, 90,221,231,150,201,244,231, 17,
227,235, 38,168,180,155,151, 58,134,210, 25,102, 37, 15, 21,222, 22, 32,193, 32,
192, 66,167,129,114,151,191, 10, 73,  2,228, 26, 13, 77, 40,192,234, 15, 26,  4,
236,107,  9,143, 73,  8, 37,252,  2,186, 68, 69, 88, 90, 11,104, 36, 72,192, 91,
137,237,251,241,228,180,164, 13,229, 28,130,172, 36,113,168,194,117,220,127, 57,
197,237,197,161,234,132, 10, 48,102, 96, 82,147,195, 74, 34,204,243,  0,143, 32,
 86,226, 80, 54,158,152, 78, 24,175,254, 65,154, 17, 27,131,192,189, 93,210,175,
236,223,236,242,103, 47,157,175,206, 40,182,188,148,113,134,104, 56,238, 79,184,
 44, 33, 46, 21, 43,218, 70,197,181, 39, 28,233,118, 45,219,238, 45, 34,146,135,
102, 31,226,151,215,242,147, 28, 60,103,104,160, 72, 70, 67,188,119,202,140, 58,
210, 55,219,228,205,172,102, 30,112,128,248, 76,240, 63, 99, 30,179,118, 94,131,
 41, 95,193,255,206, 83,232,161,107, 79,145,227,184,204,160,181,108,174, 22,226,
237,103,192,124,194,240, 43, 54, 57,235,146,166, 57,229, 44, 75,238,216,121, 56,
121,144,213, 31,200,120,215, 98, 78,152,238,128,183, 10, 95,140, 64,153,127,234,
159, 46,126,174, 99, 70,243,168,179,108, 80,230,233,206,250, 67,128,238, 95,207,
122,184,243, 15,148,115,108, 76, 11,115, 17,255, 35,128,136,115,100,229,254, 46,
177,120, 38,181,180,  1, 13,169,183,  2, 15,167,179,173,215, 54,218,119, 80,165,
189, 79,238,188, 12,218,187,165,179,232,  7,104,211,162, 43, 61,209, 59, 19,130,
128,237,223,  0,196, 38,215,164,164,163, 63, 27, 26,118,196, 55, 50,149,137,132,
210,231,  4, 83,122,129,200, 66, 88,170, 76, 85, 61,174,183,165, 32, 35,207,223,
244, 12, 79, 62,171,171, 93, 56, 57,143,108, 53,187,135, 52, 65, 90,123,212,228,
108, 95, 31,119, 88, 68, 82,140, 72,196,132,240,119, 51,242,124,247, 59,112, 93,
116,160,172,145, 42,180,214,167,193,205, 47, 46,226, 67, 94,194, 39,183, 94,131,
128,235,164,138,186, 64,  8,178,245,225,160,136, 84,191,225,161,205, 27,139,246,
227, 18,140,223, 34,179,162, 29,183,  5,149, 41,142,148, 32,151, 17, 38,152, 87,
 57, 25,120,239,111,248,213,165, 74,146,172, 81,180, 86,198,160,187,165, 52, 45,
223,136, 13,144,118,167,138,176,128,164,224,249,143,200,172,111,192,  9, 94, 40,
 67, 23, 18,142, 76,114,  9,198, 70, 49, 58,179, 24,158,  4,155,  0,250,253,254,
  4,187, 20, 66,254, 24, 37,124, 39, 68,160, 56,231, 48,203, 33,130, 98,228,  0,
206,180,115,190,164,135,243, 62, 91,118,201,  4,135,174,221, 56,126,124,252,209,
159, 40, 35,183,157, 21, 71,223,253, 14,146, 89,190, 48,  8,236,126,224, 52,226,
125,129,125,212, 83, 32,243, 81,156, 18, 45,157,  0, 72,122,131,144, 88,114,216,
144,225,203,221, 67, 59, 67,208, 43,219,239,206,169, 92,238,231,122,233, 13,173,
209, 40,203, 56, 92,208, 89,185, 88, 16,245,217,103,168,129, 17,181, 53,163,130,
  6, 76,236,113,175,189,  5,229,167, 24,197,241,  0,213,164,171,228,108,133,186,
190,174,205,240,234,137, 42,103,  1,177, 59, 39, 73, 45,225, 36,153,122, 44,124,
 74, 45, 47, 87, 82, 55,227,141, 84, 60,162, 26, 46,174,179,255,144,196, 41,204,
242, 21, 57,182,144, 70,173,135, 54, 83,246,144,213,182,203,225,172,202, 63, 24,
 56, 56,155,142, 88, 38,238,213, 67,100,100,196, 88,  7,175, 67,222, 22,131, 66,
 67, 46, 75,120, 42,151, 50,172,152,169, 50,143,130,104, 59,157, 97,122,154, 40,
137, 78, 66,253,179,234, 60, 97, 90,154,222, 71, 14,187, 22,170,132, 65,125,227,
180, 31,232,177,200, 90,248, 77,154, 50, 17,215,193, 19,169,195, 86, 51,247, 65,
159, 50,  7,226,217, 87, 56, 26, 47,195,136,253,153, 40,233,135, 41, 64,200,  0,
 45,102,238,199,  9, 61, 10,248,182,191,177,119,127,197,173,236,215,248,  2, 70,
199, 89,229,245, 50,130,194, 18, 10,249,212, 49,138,142,227, 18,135, 75,  0,157,
141,109, 48, 61, 41, 96,251,228, 85, 67,135, 67, 17, 17,251, 30, 16, 77,121,122,
 63, 56,117,121, 17,192, 89, 49,166,230,  9, 90,105,181,248,145, 98,134,156, 56,
116,220, 11, 88,253, 36,231,140,216,131, 76,  3,125,113,202,172,  9,137, 79,114,
146, 96, 11,156,151,180, 82,152, 55,255, 91,229, 23, 99,165,233,253,232,233,106,
147,216,225,118, 23,  1, 60,176,216, 30, 53,218,247, 34, 10,107, 96, 87, 81, 59,
189,196, 34,154,  7,228, 23, 23,112, 34, 98, 47, 25,213,233,132,203, 37,151,156,
 55,234,134, 73, 71,131,146,191, 56,216,166,118, 65,236, 97,246, 51,160,146, 24,
 95, 76, 84,  0, 69,227,131, 76,  1,  5,  5,102,199, 35, 58,172,223,183,227,  2,
253, 50, 65, 43,124, 13,210, 52,203, 30,246,115, 26,244,165, 86,138, 66,116, 56,
 22,150,112,150,120,182, 38, 27,153,238,101, 31,202, 28,  4,134,145, 84, 17,236,
202,182, 64,102, 88,235,214, 28,174,  4, 69, 42, 10, 59, 44,255,216, 76,161,  5,
 53,122,163, 14, 18,130, 29,130,123, 31, 78,148,  1,170, 71, 59,149,155,111, 34,
 50,195,197,218,  5,180,104,155,  7, 70,196,139, 22,251,217, 86, 79,189, 92,204,
  7,234,172,123,243, 69, 67, 45,235,154, 52,  0,212,178, 53,214,193,167, 53,218,
131, 49,164, 16, 65, 65,236,156,123,116,154, 15,234,181,112,125, 85, 27,152,155,
 61, 53,211, 67,155,229, 87,194,205, 85,133,148,219, 65,236,201,  6,165,219, 19,
236,133,  4,155,213,104,196, 41,  5,168,111,247, 11,120, 25, 54,201, 79, 73, 22,
243,  7, 75, 13, 82,143, 86, 97,187,172,143,249,113,182, 28, 61,182, 29, 24, 65,
 19, 61,150, 83, 42,  6,103, 96, 60,  6, 74,103,211, 33, 73,147,182, 19, 33,127,
104,190, 53, 81,153, 37, 60,123, 45,  0, 82,125,224, 67,140, 24, 60,  1, 19, 31,
  8,157,194, 21,153,132,223,146,250, 82, 48,102,140, 11,245,137,158, 62,224, 92,
 48,  4,193, 44,215, 50,190,244,223,217,222, 65,192,215, 50, 26, 60, 67,226,206,
146,193, 16, 89, 33,200,207, 36,214, 70,231,169,106, 53,198,140, 66,227,247,124,
186, 54,109,207, 66,154,233, 74,133, 81,102,  2, 46,130,252,211, 70,212, 44,103,
160, 13, 14, 20,129,231, 75,193,198,124,100, 98, 62,141,124,171, 49,246,100, 17,
239,157,171, 59,140, 58, 89,130, 51,234,144,136,183,145, 78,198,193,149, 58,166,
196, 55,201,206, 59,123, 47,185, 49, 99,244,181,252,222,107, 99, 16, 48, 30,109,
 49,198, 93, 78,181,249,107,156,132,191,228, 98,124, 22,  9, 47,218,216,177,235,
  5,111, 52,184,  7,162,  8, 66,110,111, 31, 58,232, 80,133,254, 17,138,246, 16,
168,109, 45,191,152,124,130, 75, 57, 75, 49,209,181,128,149,254,216,134,239, 70,
236, 73,179,190,104, 80, 84, 87,153,221, 93,237, 95,  0,115, 90,  3,158, 14, 80,
114,182, 70,209, 88, 24,111,112,208,199,183,196,164, 50,254,116, 24,164, 94,122,
167, 89, 32,187,109,161,155,  7,111, 33, 32,126, 78,131,221, 49, 33,140, 53,204,
183,113,172, 64, 60, 49, 43,162, 39, 52,212, 53,100,187,111, 46, 47,184,131, 75,
 85, 89, 89,175,127, 56, 63,232,220, 37,114,107,194,207,240,156, 17,133, 74, 67,
 38, 31,195,  8, 86, 17,206,  0,199, 22,196,204, 84, 70, 36, 53, 77,220,220, 33,
126,160,130,188,249, 31, 19,200,146,135, 40,136,182,237, 72, 11,139,230,253, 32,
179,211, 50,  3,114,151,116, 97, 59,147,131,215,159, 85, 44,254,100,147,194, 54,
 69, 66,112,238,200, 28,229, 40,193,140,  7,139,  9,113,  7,173, 83,138, 12, 22,
228,142, 80,187, 16, 22, 14,128,150, 38,224,102,210,244,252,247,240,195, 85,125,
 68, 11,202, 47,212,140, 39, 99,234,  5, 64,139,100,232,182, 84,116,136,224, 14,
124,121, 83,121, 62,202,188, 95,223,168,206,163, 63,240,235,102,235,118,116,188,
 90,231,124,177,134,134, 54, 88,245, 95,234, 44,244, 81,  8,245,228,  9, 92, 16,
162,194, 50,208,104, 88,236,252,116, 49,151,214, 48,224,140,131,177, 28,188,132,
 83, 52,169,181,167,149,125,159, 74,247,161, 39,211, 23,162, 80,  4,130, 55, 50,
237, 76, 81,220,178, 44,134,121, 84, 92,184, 49,  9,121,109,142,231, 68, 25, 71,
232,195,228,132,158,154,150,  9,138, 77, 38,168, 44, 13,119,  8,149,124,232,225,
 53,214, 63, 67,205,163,  6, 44,  5,189,144, 74,181, 40,206, 74,116, 20,133, 92,
 98,194,159, 80,250, 62,129,221, 32, 99,155, 79, 92,  8, 69,160,107, 61,209,233,
105, 38,137,194, 85, 10,211,129, 82, 78,103,172,131,156,137,192, 69,215,206,185,
148, 97,156, 33,141,128, 35,  8,  9,197,162, 15,201,113, 67,197,  0,244,108, 72,
109,191, 19, 56, 14, 87,241,148, 83, 84,246,204,108,233, 37,208, 64, 28, 63,222,
134, 40,  5,138, 83,  1, 76,161,244, 55, 71,135,243, 22,179,105,100,248,201,222,
230,186,205,  2,112,125,114,134,148,241, 87,232, 75, 23,147,148,157,252, 71, 66,
111,229, 92, 50,121,172,150, 40,118, 99,233,254, 71,111,172, 40, 73,157, 22,106,
216, 57, 45, 63,210,178,155,101,252,240,226,  9, 60, 24, 70,224, 80,104,  2,228,
 29, 46, 16,212,224,209, 76,225, 79,133,206, 88,234,120,160,129,206, 68, 88, 37,
 48,181,184,230, 56,179,183,172, 46,169,106, 73,192,105, 67, 48,102,115, 71, 40,
 57,  8, 65,177, 16,127,124,102, 77,175,175, 10,146, 41, 77, 81,149, 17,212,250,
  8,104,146,226, 28,162, 20,234, 25, 45,  4,228,164, 54, 41, 60,203, 50,233,113,
154,221, 33, 72,114, 67,  8, 61,246,  7,237,210,201,173,141,162,222, 41, 72,121,
228,161,198,136,154, 38,  2,193,148,188,207,156,167, 40,195,186, 50, 72,224, 13,
 92, 46,137, 18,244, 24,246, 58, 31, 34, 28,  7,100,119, 41,133,128,  8, 64, 36,
146,215,176,166, 78, 63, 25,  3, 92,141,165,192, 90,156,234,131,214,169,203, 72,
 43,177,180,161, 97,245, 74,188, 60,  3,103,247, 20,147, 15, 17, 86,235, 24,235,
240,180,105,174,132,139,123,211,236,173, 39, 64, 16, 66, 18,  0, 48,197,255, 41,
137,127, 48, 87,168,198,255,254,  0,111,240,154,153,130,188,154,126,177,  9, 19,
 20, 46, 18,222, 27, 64, 70, 86, 77,191,145,161,  6,221,151,130,190,165, 21,137,
 35,117,237, 76,249,  1,137,191,238,244,186,226,178,229,136,221,142,221,126,141,
255,188, 27,232, 98,  5, 14, 55,202,169,119,198, 70, 40,188,214, 30,137,146,174,
115,253,206,226,115,153, 71,209, 17,188, 70,163,163,149, 17,219, 19,193,112, 33,
 52,105, 74,212, 96,  6, 21,191, 86,172,124,103,242, 54, 88, 42,246, 75,200, 94,
 76,233, 70,133,113,166, 74,136, 11,149,156, 29,141, 75,185,164, 24,254,121,182,
241,132,203,183, 38,131,  0,248,177,181,132, 66,148, 32, 14, 96,155, 22,145,167,
 64, 97,210, 74,148,219,252, 52, 21, 69,202, 13,237,206,109,213,164,236, 80, 32,
236,160, 64, 65,101, 11, 30,202,158, 30, 25, 77,210, 24,199,253,110, 87, 19,110,
 29,168, 96,131,206,136,217,220, 50,135,225, 29,110, 99, 11,112,181, 28,  9, 53,
230,173,115, 43, 73,214, 62,193,180,140,135, 90,131, 86,125, 87,242, 79, 11,144,
 32,171,164,123,198,108,170,128, 78, 61,160, 48,240, 81, 35,216,139,198,125,222,
202,199,127, 72,186,157,  3,214,242,138,208,104, 76, 47,  9, 46,214,  4,189, 96,
 98,117, 57,234,162,233,  2, 91,146,177, 43,109, 59,  6,  1,205,133,  4,192,183,
184, 65,236, 98,244,177,237,120,193, 56,  0,228,219,200, 17,  1,172,210,197, 99,
213,240, 53, 44,105,212,  5,112,177, 85,169, 94,104,186,137, 41, 68, 53,236,175,
 26,251, 57,137,176,132, 77, 76,107, 83,  1,201, 83, 26, 46,198,128,209,239,132,
 91,123, 75, 74,112,122,126,167,217, 42,121,232,136,104, 33, 39,145, 16,120, 42,
 65,249,160, 56, 60, 30,127, 38,167,178,210,139, 95,  5, 40, 79,202,217,255,105,
 40, 58,179,163, 22, 27, 56, 63,  9,171, 79, 80,247,236,168, 51,169,154, 16,198,
184,178,197,113,239,125, 93,231,160,180,176,215,200,120, 52, 40,134,131, 76,248,
184, 60,232, 71,109, 72, 16,112, 12,199,150,235, 16,236, 59,231, 29, 36,128,153,
174,238, 60, 44, 35,141,213,228,216,168,127,162,148, 52,101,117,105, 97, 51,107,
123, 73,211,143, 39, 68,217,225, 14,120,120,157,119,123,131,229,180,176,114,148,
174, 31,228,112, 64,138,162,244,187, 39,186, 15,184,146,165,100,100,237,110,224,
118,  4, 63, 31,212, 47,148,247, 42,242,248, 78, 24,  3,153,247,152, 10,145,191,
162, 30, 84,100, 99,205,  2,172,145,187,108,212, 42, 60, 10, 91, 12, 17, 27,123,
137, 75,222, 31, 61,214,  0,166,163,212,165,228,219,244, 71,113, 51,116,235,168,
222,233,229,  8,160,175, 24, 65,190,166,163, 83,225, 68,136, 58,106, 86,107,159,
 65,208,103,245,116,230,121,187,144,204,163,206,143,255,219,245, 36,171,229, 14,
217,126,183, 59,133, 58, 41,125, 52,152, 51,100,  4, 80,124, 22, 81, 37,211,123,
 23,138, 45, 55,207,147,190,  1,227, 85, 24,155, 35,101,214,203, 33, 16,179, 77,
 78, 46, 47, 85,255, 17,188,152,235, 60, 48,159,208,142, 33,102,115,235,141,134,
179,110, 57,170,148, 13,236, 36, 34,165,183,206, 17,172,187, 60, 14,122, 99,223,
239,202,226,  5,230,196,193, 79,188,145, 49,170,205, 85, 93,132, 17,175,  6,143,
 60,188,157, 41, 13,  2,237,250, 65,237,254,185,126,107, 53,220, 18, 62,225, 50,
152, 53,102,225,244,154, 28, 57, 81, 36, 93,106,250,149, 35, 66,250,  0,217,  4,
 55,235,127,189, 53,168, 88,144,106, 46,216, 28,134, 40, 45,140,  5,252,157,100,
 82, 41,164, 20, 77,215,185,215,195,139,107,249, 22,100, 54, 76,199, 34, 72,136,
108,130,222, 45,  3, 79,132, 71,228,246, 22,199,166,  3, 79, 74, 57,212, 42,162,
 45, 79, 67,234,133,205,238, 55,169,183,165,120, 24,166, 59,118,137, 77,194, 24,
100,242, 40,166,210, 70,220, 73,200,238,148, 45,172,  0,245, 82,175,  8, 94, 13,
240, 48, 59,209, 26,141, 52,176,160,104,219,228,150,215,142,179,  3,151,175,145,
164, 86, 12,152,156, 64,251,177,239,180,255,236,180,135,192,186, 92,127, 84,170,
104,207, 38,198,230, 14,  1,162, 65,252,252, 28,147, 93, 89,178, 60,148, 99, 65,
  5,100, 22,168,157,  5,214, 11, 31,215,249,154,197, 76,207,230, 28,180,226,141,
 12,240,144, 23,158,157,214, 93,170, 11, 32,234,123,147,  1,129,167,142, 66, 76,
 93,170,  2,148,140, 59,128,246,164, 26, 60,188,150, 10,  3,190,245, 82, 85, 67,
 48,191,160,154, 85, 21,228,217,196,141,231, 69,148,212,  0, 42, 71,248, 13, 41,
176,208,221,  6,108,188,153,134, 68, 92, 91,140, 53, 45,124, 28, 55,135, 37,213,
 38,193,141, 80,137,159,152, 54, 25, 55,164,  7, 83,251,131,254,131,210,157, 14,
  7,209,  0,219,  0,210,  0, 26, 53, 57, 62,189,175, 26,182,207,203, 62, 47,252,
137,228,178, 54,221, 38,241,101,223,101,227,172, 63,101, 65,106,134,211, 48,127,
144,213,168, 77, 31,158,209, 13,133,180,191,213, 23,  4, 66,237,190, 26, 97, 95,
144,169, 45,132, 12, 90,200,  5,104,157, 56, 57, 22,161,165,184, 58,116,137,213,
131, 20,171, 92,127, 62, 57, 64,163,241, 20, 76, 19, 93, 16,241,201,109, 95,168,
177,232, 31,100,177,199,193,144,109, 25, 81,138, 81,233,  1,158,202, 47,239,124,
254,182, 27,143, 48,105, 61,125,209, 83,120,202,176,148, 74, 37,158,  0,208, 10,
103,248, 99,127, 17,182,102, 30,101, 18,  1, 96, 76,211, 47,137,176,221, 22,216,
 66,244, 22, 99,148,103, 61,149,248,114,113, 76, 82, 31,254,152,166,155, 60,151,
 39,138, 79,123,250,  5,137,205,233,225, 15,255, 82,202, 37, 84,129,212,117, 73,
128, 97,129, 74,167, 93,253, 35, 52,175,185,172, 27,254, 90, 23,151, 58,122,206,
 11, 42,243,104, 51,134, 52, 58,250, 84,136,200,105, 62,187,196,167, 89, 65, 52,
223,134,196, 91,231,178,194, 93, 62,241, 66,186, 91,167,117,235, 31,208, 36,125,
 81,162,161,210, 43,232, 91, 69,180,123,106, 31,105, 97, 58, 81, 51,114,217,  6,
162,164,108, 32, 58, 93, 96, 77, 87,173,181, 66,225, 62,113, 66, 25,248,105, 67,
228,180,173, 71, 98,112, 69,170,236,161,178,105, 99,171, 33,  9,183,140, 51,114,
 40, 23,229, 35, 15, 25,141, 62,  2,138, 32,101, 96,  2, 90,242,150, 88,222, 23,
 62, 30, 14,108,107, 52,107,236, 88,101,226,129, 91,  6,241,121, 26,211,146,234,
 38,131,  8, 55,159, 70, 10,229, 26, 27,  7,140,124,152,221,103,254,170,171, 43,
 11,181,134,112,194,109,182,144, 19, 37, 27,132,  6, 94,217,167,109,188,145,141,
112,153, 22,102, 54,175,243,180,140,215, 72, 53,193,151,137, 13,172, 80, 62, 98,
249,155,158,  1, 53, 97, 70,139, 25,181,141, 68, 56,114,  1, 19,201, 21,129, 96,
 97, 70,244,142,227,117, 97,245,234,227, 25,238,243, 56, 99,216,209, 78, 52,107,
236,207,108,117,121, 65,137,140,195,229, 13,234,139,234, 11,174, 45,149,218,173,
169,144, 65,105,  0,241,  5,191,240, 90, 78, 91, 14, 81,159, 63,  6,196, 12,148,
 15, 47,243,158,210,145,181, 23,190, 47,135,175,198,166,140,122,124, 39,127,130,
141,136,189,248,243,190, 36,141, 45,249,167, 69, 13,252, 15, 28,142, 81,186,156,
188,199,176, 12,135,168,215,254,217,228,133, 34,117, 64,233, 44,252, 39,132,125,
181,133,133, 98, 35,212,157,188,234,207, 59,245,121,247, 37,253, 91, 50,143, 67,
176,136,159,121, 75,244,244, 96,246, 99,109,242,158,216,131,145, 85,123,200, 32,
 66,219,154,  8,149,165, 53, 96,178, 10,132,180,159,123,154, 24,125,177,182, 93,
148,120,244,240, 23, 70,220, 96,  0, 46,136,217, 66,112,211, 50, 34,135,233,170,
182, 50, 26,152,  5,227,168, 55, 77, 81,228,190,254,254,211,127,202,156, 53, 70,
201, 19,147,142,253,187,214,250, 27,165,211, 41,117, 42, 10, 68, 99, 72,197,138,
 92, 35,134,167,180,163, 51,143,106, 45, 93,151,198,185,164, 99,153,230, 91,214,
245,143, 85,253,158, 82,152, 92, 87,144,191,180,206, 39,233, 56,244,  5,135,135,
165,208,223,186,174, 42,106,139,119, 58, 82,118,157, 82, 71,163, 41, 81,231,116,
102,135,196,170,234, 61,209,175, 16,135, 75, 84,142, 97,214,163,102,156, 23,171,
106,169,244,127, 75,102,198,100,198,170,201, 21, 60,232,198, 37,200,146, 50,157,
166,177, 87,116, 27,131, 70,225,155,191,167,188, 24,168,180, 39,  4,204,124, 25,
231,  1,147, 93,170, 99,210, 24,186,236,  3,120,135,237, 69,184,180, 64, 29,219,
164, 61, 31, 24, 12,177, 33,253,185,144,176,223,123,185,108,123,164, 31,171, 61,
 26,185,180,140, 28,250,106,141,131,213, 90,161,  4,138,123,168, 84,249,103,165,
 43,  2,  0, 99,114,  0, 12, 18,140,142,228, 82,129, 26,104,138,126, 68,225,202,
133,145, 72,  3,210, 66,242, 40, 28,135,130, 17,134,  3, 64,  1,  2,  6,  0, 36,
 48,  2,  2,224,  0,  0,129,212, 13,175,139,201,199,145,251,182,148,185,241,  5,
 26, 98, 74, 12, 66,157,107,123,149,  4,190,196,233, 43,217,111,197,175,  7,196,
 59,109,126,180,254,138,  3, 18,127,218,195, 65,231,194, 72, 28,189,114, 73,154,
 89, 71, 12,147,121,191,237,120,127, 54,101,148,133,  4, 13,222, 11,126, 96,112,
135, 16,  4, 53,171,127,194, 36,212,160,238,163, 37, 82,164,149,148, 84,168,227,
 28, 28, 88, 87, 15, 38,100,148, 24,115,139,100,197, 91,110, 29, 90, 30,245,104,
239,197,  1, 13,116, 31,115, 31,224,191,242, 59,228,134, 91, 14, 87,251,208,235,
246,237, 13, 50,246,141, 78,162,  5, 23,253,137,143,232,228, 34,225, 13, 86,218,
  7,186,205,  3,162, 70, 44,210,143, 16,165, 45, 90,116,161,235,198,182,105, 60,
157,102,150,193,223,203,111, 17,203, 31,100,206, 34, 19,106,109,137,103, 21,178,
144, 86,175,229,133, 56,110, 34,174,201, 74,206, 86,232,175, 74, 91,191,246,233,
 38, 43,216,240, 28,128, 85,167,112, 89, 85,111, 82,104,244,176,217, 43, 13,183,
 38,112, 33, 85,229,230, 75,113,248, 62,104, 19, 72,240,207, 94,202, 68,221, 68,
120,114,126, 87,208, 63,233, 23, 13,  1, 91,138,174,176,180,140, 50,255,202, 70,
158, 63,108,200,163,182,149, 76,178, 49,219, 49, 22, 67,255, 48,173,205, 64,108,
 52,230,143,113, 64, 51,120,102,226, 91, 32,224, 22, 13,143,123,233, 58, 11,238,
 97,133,  3, 29,  0,222,115,123,188,174,149, 55,178,245, 93,200,245,203, 69,201,
121, 54,191,159, 97,213,127,165, 72,109, 19, 36,  3,  0,173, 86,166,143, 93, 81,
 53, 75,112,102, 85,167,197, 88, 32,149,  0, 75,214, 69, 54, 89,244, 80,199, 75,
152,242,115,114, 64,163, 19,172,240,231,100,129,150,156,137, 42, 15, 46,155, 48,
 13,100, 60,106, 79,113, 12, 52,132, 34,147,114,250, 62,224, 25,161,178,164,182,
  0, 78,154,214, 69, 92, 71,184,115,127,143,100, 29,152,228,104,172,248, 89,236,
 18,112,145, 43,161,211,239,111, 64, 86,171,132,178,177,200, 69, 68,167,200, 99,
176,229, 86,  6,212,195, 21,244,244, 14, 16, 91,222, 91,229,131,253,113, 63,170,
255, 26, 44,231,101,206,164,105,215,107,162,153,103, 79,188,180, 48, 14,151,156,
 97,202,207, 51, 44,255, 47, 50, 57,242, 26,  0,179, 51,  0,145,194,103,150,190,
117,138, 38,122,220, 18,199,179, 74,144,114, 45,213, 23,163,231, 69, 86,189,250,
159,118, 26, 71, 86, 32,235, 11,178,111, 18, 24,229, 65,249,104,104, 83,138,120,
156,248,121,213, 62,239,244,104, 36,  9,118,217,218,184, 38,171,  4,147,172,208,
118,231,222,140,161,219,139,129,117, 76,115, 14,210,252, 57,179,180,118, 70,155,
190,126,251,131, 41,250,112, 96,143, 17,228, 95,203, 59,  8,229,243, 58,254,254,
 58,102, 96, 99, 15,250,175,197, 52, 22,114,243,194, 10,232,116,128,190,116,198,
 11,154,230,179, 47,160,202, 38, 93, 64, 17,157,221,158, 35,244, 66,165,238,185,
145,118, 16, 44,241,244, 90, 24,185, 82,194, 44,144, 28, 12,199,181,196, 57,183,
109,203, 18,224,110,204, 47,156,164,186,219, 57,148,205,241, 73,146,151,237,148,
 54,150,211, 89, 87,235,  5,135, 88,185,155,123, 39,117, 14, 57,226,217,150,140,
124, 12,  1,190,145, 49,214,210,127,160, 73,172,227,217, 56,  0,235,199,137,154,
 90,120,245,185, 11, 64,238,126,109,121, 55, 48,151,211,160,141,199,223,243,173,
209,250,  6,150,249,131,121, 88, 41,252,147,228, 76,161,102,227,100, 90,240,201,
161,128,214, 43,167,214,128,238,  5,234,212,139,164,206,182,107,225,185,249, 88,
 33, 63, 96,223, 21,239, 64,132,205,253,254,254,172,201,109,116, 99,100,108,186,
174, 22, 86, 29,155,125,169,110,121, 27,134, 60, 55,230, 78,128, 48, 45, 29, 23,
240, 58,124,228, 10, 83, 73,151, 68, 82, 55,144,232,171,198,200,181,191,180, 86,
213,222,254,117, 75, 69,118,115, 20,121, 84,154, 62,165,196, 32,195,223,153, 73,
 68,159,146,179,222,211,139, 90,142, 60,150,148,225,242,157, 47, 26,163,220,174,
 20,146,210,200, 40, 27, 23,128,213, 37, 46,219, 13,244,140, 25,255,165,120, 35,
113,120,125,164, 69,199,175,136,116,202, 93,190,231,140,123,105, 38,231,250,144,
 64,221,248,221,152, 27, 62,124,114,189, 19, 65, 37,236, 12, 34,142,242,204, 31,
 97, 92,225, 64, 53,178,  8, 50, 79,169,239,244,198, 56,117,228, 20, 81,201, 46,
  2, 16, 48, 74,172, 79,138, 80,100, 51,130,  8,152,154, 64, 68,192, 81,179, 29,
193, 66,161, 48,176,133, 57,220,101, 50, 54, 61, 94,246,234,191,175,  4,238, 88,
 43,153, 97,110,  9,102,202, 54,166,196, 50,103,248, 72, 38,176,196,171, 47,171,
  8, 32,  4,117,134,227,175,120,191, 63,122, 31,118, 62, 45, 16,140, 31,156, 84,
 23, 77, 42, 84,172, 78,233,155,204,130, 76,180,129,100,111, 55,224,110, 55, 19,
208, 74,213,110, 45, 13,174, 39,142,152,187, 30, 33,214, 49, 19, 44, 15,231, 64,
139, 91,207, 41, 59,133,  9,184,165, 96,214,148, 26,141,168,209,  5,222,227,223,
182,191,126, 95,181,104,198,241, 36,  3,178,152,229,203,164,208, 56,209,180,238,
 79,143,217,247,229, 67,211,202,125, 11,139,138, 96,216,143,122, 45,243,149, 94,
 95,104, 57, 15,161,  6,173, 37,115,247,254, 87,159, 80, 74,238,115,127, 15,229,
 36,179,252, 29,240,224, 61,230,126, 75,100, 77, 21,179, 10, 51, 47,226,217,210,
200,238,140,171,159,117,132,117,252, 72,157, 54, 67,188,245, 84, 28, 22,220,240,
243, 34,  8,168,171, 99, 26,174, 85,246, 66,127,186, 18, 20,213, 98, 59, 79, 62,
124,243,111,144, 66, 11,231, 82, 46,145,146,252,251, 77, 59, 44, 66,246,153, 29,
154,113, 39,213, 56, 72,200,120, 16,124, 64,232, 53,139,162,  2,235, 50,149,150,
186, 59, 37, 46,241, 32,158, 20,130, 49, 98,108, 21,139,185,239,  2,100, 16,251,
154,158,156,161, 60,255,140,218,204,216,188,198,214,119,254, 89,186,198,148,234,
106, 67, 12,108,109,  8,  8,128,  0,157,119,213,224, 22,159,  6,109,  2,197,218,
126,117,137, 47,105, 66,236,245,227,242, 53, 31,  4,196,104,164, 93,120, 36,167,
232, 10,115,111, 31,178,249,150, 35, 23, 94,240,121,192,161,162,123, 58, 76,245,
242,140, 22,211,173,198,244, 62,121, 47,125, 97,153, 91,233, 73, 52,151, 40,211,
163,206,241,175,220, 30,154,223, 49, 48, 48,236,237,254,126,106, 25, 20,250,174,
136,  6,221, 74,105,232, 11,108, 53,157, 27, 98,237,155,249, 14,227,222,139,161,
156, 92,162,147,238, 66,130, 79, 14, 68,116,142,145,138,230, 39, 35,  4,110,246,
197,140, 32,101,213,129,214, 34, 88,115, 86, 32,219, 75, 75, 56, 43,142,110,  2,
209,139, 36,120, 85,210,107, 20, 21,236, 97,186,141,139,255,134,111,237, 21,122,
199,  7,140,232, 73, 83,188, 73,133,143,124, 94,184,135,138, 52,198,123,162,207,
121,129,245, 86,  7,245,207, 34, 99,142,107,185, 12,196,179,235,124, 43,144, 39,
255,168,124,115, 28, 53,212, 77,118,147,  0,234, 94, 42,214,175,234,199,  1,250,
 45,141,153,148,170,230,229,  9,195,  7,177,199,173,  1,145, 67,227,251, 78,237,
 96,174,141,108, 96, 88,195,  1, 22, 87,172,205,182,227, 74,173,198,177,184, 94,
113,104,178,152, 52,210, 36,189,149, 91, 31,255,150, 11,172, 95, 29, 69,228,171,
130,189,138, 65,255,209, 34,152, 72,  2, 60,105,120, 71,146,120,184,112, 97, 93,
201,216,103,188,171,195, 23, 69,156,195,142,109,184, 33, 25,151, 56, 46, 69,243,
 41,166,156, 73,159,181,232, 24, 93,247,143, 26,169, 60, 68,164,237,123, 12,150,
156,  7,102, 56, 60, 36,185,141,183,225, 54,194,140,  7,212,187, 67, 18,161,208,
 21,175, 55,197,147, 60,203,163, 36,130,114, 24, 53,209,124,102,235, 17, 35, 73,
 21,158,  0,142,172,233,  7,214,112, 24, 32, 27, 32,  9,219, 80, 18,213,202,232,
228, 60,210, 22,102,182,220, 78,110,182,252, 74, 11,163,129,223, 10,119,101,190,
  9,237,124,204,145,196, 22,141,220,151, 36,150, 96, 60, 28, 80,160,118, 61,140,
202,248,236, 75,135, 60, 49,116,215,108, 37,128, 80, 98, 63,  2,186,138, 28,142,
116,143,  2, 93, 31,115,  3,133,255,147,110,175, 97, 18,125,105,175,123,225,210,
 65,100,122,222,122, 47,240,255,177,220, 72, 10,205,  9,116, 26, 42, 17,236,163,
248,223,220, 18, 92,161,190,140,159,213,159, 63, 14,158,254, 52, 18,134,191,154,
197, 72,145,244,172,199, 57, 61,218,132,220,186, 22, 72,161,142, 71,148, 95,144,
230,229, 87, 70,203,188,215,  0,  4,168, 48,160, 43,109, 38,133, 38,111,209,  2,
210,109,206,111, 52,  8, 37,203,167, 29, 79, 35, 57,154, 44, 13,101,188,132,192,
103,172,  2, 78,211,166,163, 20,180,202, 95,198, 69,105, 51, 39,235, 19,147, 82,
 30,195, 56,  7,180,203, 89, 59, 84,121, 26,253,127,155,154,228,249, 33, 98,225,
218,111, 62,  1, 26,143,100,170,143,125,125,170, 98,160,176, 12, 77,122,169, 15,
207, 10,244,146,  3,117,147,106,  3,157,205,127,218,163,163,157,169,181,167,154,
 92,182, 23, 83,101,  1,162,112,248,178, 56, 47,255, 22,100,249, 63,193, 96,202,
152,123, 93,252,  4,184, 36, 67, 76,247, 87, 80,101,113,204,135, 53,218, 26, 95,
163,250,184, 74, 92,160,238, 88,  9, 31,106,244, 85,214,116, 41,165,110,245,172,
145, 59,180,  3, 15, 17, 76, 38, 66,214,174, 33,219, 91,120, 12, 40,108,185,168,
 28,147,135, 87,244, 35,215,206,219,152,130,145,112, 21,141,176,207, 25, 95,  3,
163, 40,248,161, 65,167,203,182,110,221, 50,166,165, 77, 80,111,113,  2,115,210,
133,231,239,138, 10, 58, 52,219,164, 40,191, 20, 77,226, 16,121,216,119, 49, 12,
 66,217, 61, 26,244,196,235,118,188,110,241, 24, 45,215,235, 92,158,226, 99,156,
 92, 41,  3,116,110,104,184, 96, 61,198, 91,186, 16, 80, 44,184, 43,178,127, 96,
147,148,172,174, 98,169,230,100, 69,163, 32, 41, 83,112, 87,199,238,140,203,215,
  5,220,186, 94,101,126,168, 31,190,213,196, 62,104, 11, 90,142,149,245, 18,233,
223, 37,150,196,216,226,201, 75,  2, 48, 88, 29, 36, 15,179, 21,248,240,236, 64,
169, 11,116,196,190,142,241, 72, 68, 34,204,179,133,202, 14,226, 89, 48,198, 41,
201,236, 14,151,205,199, 11, 21,216,182,155,134, 91, 23,179,116,124,145, 37, 97,
235,220,127,191,199, 78,235, 25,  1, 25,112, 74,228,199,220,159,103, 10, 94,180,
251,  4, 58,132, 95,245, 68,122,251,181, 62, 12,131,  9,202,175,141, 21, 46,246,
181,209, 77, 98,106,118, 77,198,145, 11,182,223,123, 74,119,129, 44,250,166,100,
102,110,220,114,188, 84,204,  8, 48,164,221, 74, 20,153, 37,197, 41,234, 63,252,
226, 23,218,191, 95,106, 77, 89,168, 72, 20, 32,138, 42,243,  0,246,125, 12,157,
169,244,152,224, 27,228,163, 22,228,134,180,  5, 91,131,  1,177,175, 77,133,226,
168,184,207, 10, 88, 47, 44, 40, 23, 19,207,108, 36,181,144,193,129,234, 94,199,
236,233,246, 74, 88, 33,138,182, 49,173, 39,171,218, 43, 37,239,228,186, 64, 27,
192, 61,189, 71,  8,  7,172,224,161,101,221,189, 53, 68,193,101,176,210, 90,180,
177,227, 34,225,134, 80, 66,180,244, 33, 69, 47,229, 12, 76,144,101,228,175,160,
 93,245,195, 87, 84,182,138, 66,134, 56, 34,237, 82,198,197,148,207,232, 76, 12,
 95, 29,170,  1, 49,154, 43, 51, 75,182, 13, 41, 47,114,135, 43,140,176, 61,155,
 60,209, 12,  6, 10,222,150, 86,  2, 48, 61,121,245,148,100,140,228,166,167, 31,
143, 83,114,137,145, 56,185,233,228, 89,250, 70,233, 70,211, 55,138, 68, 64, 17,
  7,110, 78, 46, 49, 44,119,158, 69,181,140,247,255, 40,204, 76, 99,157,117,163,
232,172, 15,225,183,221,157,127,147, 87,  1,203,110,145,148,188,178,111,184,130,
 69, 86, 53, 53, 92,109,201,141,164, 63,126,209, 26,166,155,  8, 56,158,166, 40,
197, 27, 86,205, 32,210, 35, 53,115,118,111,115, 30, 55, 85, 76,222, 55,200,129,
 37,118,133,143, 27,168,146, 54,128, 44, 49, 91,172, 92, 97, 91,254,173,105,146,
178,203,155,168, 87,201,231, 16,  6, 32, 98, 50, 62, 90, 11, 56, 50, 37, 97,153,
200,222,135,139,239,179,123,  1,208,103, 62,240, 63,231,107,127, 38, 61, 31,170,
 34, 62, 77, 20, 17,125,238,134,190, 67,155,212, 73,178, 69,139,189, 96,169,130,
181, 31,207, 31,164, 99,143, 61,240, 89,217,155,167,232,209, 39, 78, 26, 51,188,
 24,155,199,  2,235, 64,189,234,249,123, 95,200,218,114,133,227,158,169, 98, 21,
158,194,181,234, 79, 41,225,129, 81, 95, 25,211,138,251,108, 17, 74,  4,252,252,
 75,176,143,  5,178, 78, 15,217,102, 64,156,169,157, 70,148,220,  4,126, 79,225,
237, 92, 22,177, 87,194,  5, 61,182,159, 92, 75, 29, 95,182,206,208,208, 62,188,
 82, 19, 12,143,181,224,166,230,123, 37, 42, 97,154,  0, 72,  3,124,168,111, 18,
124, 18,196,167, 22,  8,162, 20, 93,116,195,172, 10, 96,111, 46,201, 13, 20, 26,
  2, 49,115,175,185,117,107,238,  6,  7, 99, 30, 29,212,243,223,  6,233, 65, 39,
 80,155, 27,101,163, 64,199,194, 91, 53,242,139,144,204, 99,233,211,105,180, 83,
139,201,206,204, 73, 56,191, 76,253,181,155,186, 17,182, 35,209,  0,127, 55,170,
  7,142,238,194,240,234,147, 12, 61,  5,182, 83, 50, 58,254,212,  2, 21, 39,237,
251,232,223,113,  4, 38, 95,251,154,119,132,  1,150,177,163,248, 88,248,148,215,
 14,210, 53,244,206,186,247,170, 11,221,244, 25, 20, 69,173,205,191, 13,172,140,
112, 27, 48,175,237,115, 70, 19, 37, 32,  8,179,168,242, 48, 27,157,147,  5,157,
 77,103, 36,170,144,192, 38, 69, 59,225, 38,101,  2, 24,213,207,122,109,205, 44,
146,177,201, 14,250, 28,105,200, 35, 23,159,180, 31,202,159, 13,248,133, 64,148,
 93, 25,136,236, 29, 77,139, 73, 22,179,193,148, 79,154,  2, 87,195,133,125, 63,
241,103,131,145,  3,146,174,128, 24,254,217,244,189, 48, 30,144,181,146, 18, 59,
105, 37,176,103,252, 80,154, 27, 72,255, 71,163,171,239,131,165,244,136, 50,243,
 17, 36,207,178,169,164,137, 86,227,197, 76, 57, 55,  3, 33,173, 87,227,126,116,
219, 10, 10,150, 34,132,244,254,118,174, 90,156, 83, 43, 45,140, 38,  8,205,237,
237,157, 92,247, 63,239,126,  0,241,137, 76,218, 98,226,117, 51,212,105,172,  1,
169,210,148, 54,152,123,208,140,196,194, 49, 29,  2,208,254,109,236, 78, 42, 70,
121, 19, 82,216,196,105, 89, 81,144, 58, 54,164,120, 83, 15, 61,192,163, 70,127,
156,143, 38, 36,185, 40,241,211,229,248,164,196, 20,130,123,238, 57, 58,150, 32,
 23,228, 77,227, 74,135,167, 55, 18, 36, 73,194,193, 28, 71,139,  4,108,  2, 86,
 51,198, 32,220, 43,227, 73,160, 88,116, 99, 93,148,208,224,  8,169, 56,118, 66,
 23, 94, 55,160,182, 51,110,212, 73,165, 97,162,181,119, 91, 97,  2,165,110,126,
160,139, 65,200, 23,102,240,  2,186, 99,236,119,221,159, 33, 84,174,117,183,255,
148, 95, 82,193,  5, 98,140, 35, 71, 33,133, 14, 30, 85,143,255, 37,232,117,117,
136,248, 46,155,160, 58,136,203, 87,  0, 50, 20, 46, 79, 58,118,197, 16,188, 12,
101, 33, 92,248,153, 30, 87, 80, 32,127, 53, 17, 49,223, 27, 47,240, 19,211,187,
 61,183,216, 69,202, 27,133,  2,109, 54,132, 16,204, 89, 31,194,192,  7,130,153,
 36,164, 14,144,114,162,165,  9,140,111,210,160, 45,124,243, 91, 68,181, 93, 88,
179, 53, 75,170, 92,226,220, 93, 12,207,210, 45, 19,189, 60,120, 65,177, 90, 54,
208,191, 70,128, 60,143,195, 51,100,205,165, 35, 10, 57,230,246, 81, 99, 42,128,
 94,167,199,100, 99, 98,182,179,107, 81,  4,249,  2,234, 52, 94, 16, 64,101, 43,
 98, 92,221,139,201,156,201, 12, 57,177, 98, 10,117, 51,202, 39,149, 13,182,129,
  7,174, 64, 66,241,188, 81,194,159,142,130, 77, 72,  8,244, 42,125, 30,152,  8,
  9,193,248, 97, 50,219,  8,131, 49,115,  4, 44,  4, 72,178, 56, 57,147,201,189,
 21, 40,211,228,204,  3,225,118,169,209,  6,136,101, 65,224,218, 89,228, 74,183,
247,150,174,239,113,  3, 24, 47, 68,180, 20,200,221, 84,248,145, 18, 87,110,165,
140, 32,100,170, 34, 79,228, 26, 90,117, 60,211,217,230,230, 57,177, 26,251,163,
 12, 88, 34,163,  0,122, 43,250,  1, 27,126, 20,252,118, 15, 88,223,116,197,144,
174,172,209,111, 88, 98, 48, 74,185, 70,207, 59,124,  2,158,177, 17,110, 77, 55,
170,138,142,152, 98,188,244,  1,110,169,180,252,176, 79,237, 44,132, 92,217, 23,
 23,208,127, 38, 12,225, 71,197,  5,149,157,147, 98,124,111, 12,250, 70,179,  0,
 77,187,149,175,250, 93, 99,102,192,140, 94,195, 32,158, 77, 30,215,163,191, 77,
154,167,224,192,  8,253, 13,185,244, 16,152, 48, 58,172, 54,  5, 98, 92,162,110,
184, 78,131, 68, 53, 73, 22,125, 70,142,166,118, 25,196,197, 61, 90,187, 77,  0,
 73, 76,219,216,121,179,125, 37, 58, 77, 14, 93,230, 65,233, 17,141,130, 63, 14,
163, 36,254, 78, 97,202, 96,217, 22,224, 38,146, 23, 34,  9,157, 61,170, 71,102,
 81,136,172,183, 20, 60,107,244, 27,222, 35,  8,105, 12,164,151,  8,198,146,193,
155,240,218,251,236,251,190, 80,210, 11, 40,122,234,134,  5,149,141,243,224, 62,
 88,123, 85, 28,223,168,164,206,231,215,106,197, 26,193,175,178,218,114,241,161,
 84,166,116,  0,131, 73,106,116, 44,202, 55, 89, 89, 71,123,  5,218, 20, 64,186,
222,162, 45,  6,189,188, 28,173,210,218, 54,107,146,189,126,165,120,191,189, 59,
 20,232,246,153, 34,248,226, 66, 15,118,241,145, 78, 29,218, 40,231, 92,122, 53,
197, 87,221, 82,175,108,146, 98,240, 48,123, 46,174,181,244,244, 42, 59,215,109,
 61, 23,206,219, 65, 33,224,226,200, 81,137,159, 85,141,147,147,188, 94,170,233,
197, 11, 32,246, 44,137,187,122, 89,107, 25,107, 37, 96,187, 71,178, 80,191,182,
108,228, 66,160, 78, 28,250,220, 18, 93, 13,168,119,  7, 98,117, 35,137, 68, 62,
 43, 78, 74,  8,199, 16, 26, 20,222,122,109, 15,113,143, 83, 77,248,168,248,118,
 27,139,185, 32, 52,171,205,244,104, 14,115,171,  6,175,138,172,116,199,192,248,
163, 90, 43, 50,138, 47,178,139,216,210, 10,231,249, 10,103, 76,147,151, 76,  1,
 22, 26, 51, 50,145,243,249, 86,158, 83,108,155,230,219, 74,105, 60,115,118,117,
181,130,194, 53,119, 59,114, 85,117,177, 91,116,217, 17, 34,222,196,232,187,156,
102,209, 52, 47, 25,182,229, 49,200, 49, 49,209,135,140,150,110,234, 26,255,217,
130,240, 21,122, 70,122,219, 68,130, 93, 21,133,139,132,117,  3,189,207, 43, 55,
 15,210,244,152,143,181, 12,184,180, 21,225, 45, 38,118, 11,220,  8, 26,235, 75,
188, 57,116, 80, 19, 11,134, 16,  5, 23, 90,227,177, 77,118, 28, 98, 76, 68,  7,
226,113,  9,105,255, 52,195, 61,  1,174,108, 21,166,  7,104,228, 51,  3, 68,  4,
 84, 32,172, 33,248,203,238,240, 18,  0, 66,221,255, 27, 32, 75,206,222,144,253,
252,168,146,  5,157,227,229, 31,227,145,229,177, 83, 28,  7, 93,  0,139,181, 67,
208,  5, 87,215, 33,209,225,217, 34,171, 14,138, 63, 16,165,123,215,253, 66,154,
 89, 54,203, 60,191,205, 93,163,108,203, 82,  3, 14,179, 57, 65, 39, 52,157, 49,
226,220, 53, 79,251,235,200,248, 18,253, 12,143, 75,143, 56,128,177,207,  9, 11,
255,250, 23, 38,140,201, 72,203,  0, 17,172,210,138, 22,  4, 27,  2,232,159,174,
 32,183, 15,138, 25,131,101,180, 98,224, 88,232, 41, 61,190, 30,220,169,159,241,
209,210,197, 41,220, 23,154,102,226,136,113,166,135,251, 25,197,134,  9,175,171,
 78, 59,195,162,158,201,143,124, 37,232, 77,227, 66,175,232,104,105, 62, 29, 16,
 35, 48,131,241, 35, 11,129,104, 87,188, 50, 80,194,114, 86,164,127,143,236,208,
232,191,212, 49, 70,243, 73, 13,231, 17,126,238, 16, 95,225,166, 71, 27,188,252,
253, 30,  5, 59, 72,123,180, 73,236, 89,250,160, 71,233,171, 42,118,  8, 37,137,
 27, 10,252, 12,219, 13,200,135,255, 19,220,108,228,149,251, 16,123, 44,218,221,
120,176,178, 37,213,151, 64,211,142, 51,247, 15,228,130, 21,  1, 79,248,215,216,
 62,150,250,145,182,136,  2,187, 38,179, 57,204,164, 38,248,254,164,165,140,123,
 42,  1,202,135,194, 74, 34, 99,137, 91,149,215,156, 50,196,134, 60,  0,248,247,
 73, 85, 52, 46,172, 64, 90,213,201,150,  5, 66, 94,181,191,  1,110,184, 42, 37,
163,  4,221,207,194,145,203,253,  2, 52,251,104,148,245,246, 13, 85, 37,164,186,
170, 34,131, 26,252,155,  3, 16,217, 14,147,179,  0,246,145,149, 59, 14, 96,205,
154,  2,215, 17,217, 25, 78,180,118,197,215,157, 38,200,183, 72, 86, 75, 39,129,
 82,151,246, 61,212,128,226,135,114, 36,181,123,165,104,232,134,165,183, 74,201,
195,204,156,117, 74,201,233,  9, 57,111,148,114,227,128,165,110, 14,167,185,248,
164,138,136,  7,155, 16,104,228,243,164,243,151,243,250, 91, 77, 69,115, 64,115,
119,223,118,177,230, 10,133, 81, 75, 21,178,  5, 86,214,132,147, 28,163,207,191,
112,221,192,222,198,231,125,  5,228,157,243,235, 30,145,182, 97, 75,249, 75, 69,
160, 10, 85, 74,230,  9,142,225,248,104,235,244,138, 31,114,152, 35,253, 83,240,
136, 87,170,170, 59,184, 10, 62, 63,225,252,167, 16,113, 26,198,183,  3, 77, 51,
152, 37,228, 25, 43, 30, 35, 18,193,159,151, 81,103, 77,135,186, 20,112, 90, 53,
 59,163,176,109, 64,  6,138,182, 68, 86, 28,  7,229,170,126,107, 16, 42,226,159,
227,203,156, 39, 90,182,179,241,165,235, 65, 32, 58, 36,218, 77,186,252,214, 51,
174,207,121,155,143,201,136,138, 14, 24,127,149,139,  2,144,  4,240,198,207,226,
 46,229, 10,235,253, 63, 13,203, 72,133,111,248, 95,230, 25,219,150, 93,166, 24,
 49,176,184,104,238, 71,210,252, 94,123,128, 35,202, 86, 18,237, 55,  0, 68,144,
 82,192,169, 49,117,162,225, 13, 64,178,187, 78, 66, 72, 65, 87,  1,137, 78,198,
 51, 86,241,173, 90, 50,125,  1, 96, 14, 26,231,226, 12, 72,  0,168,183,210, 97,
145,210,242,186,126,156,198,111,228,237, 21,135,210,180,192,133, 20, 97, 17, 46,
 40, 66,182, 68, 52,206,247, 96,109,185,157,101,245,113, 55,224,116,190,232, 14,
134,185, 84, 14,146,  0, 82, 26, 97, 89, 74, 81,169,254,223,167,224, 51,164,254,
106,244,254, 78, 81,185, 67,  6, 51, 81,196,218, 50,229, 43,156, 89,133,106, 17,
 36,187,117,167,  3, 41,  7, 44,147, 29, 34, 78, 75,  0,212, 28,147,189,239,179,
115, 29, 30,136, 38,252, 32, 12,208,105, 66,251,172,172,128, 44, 92,144,230,  8,
 79,199,147, 60, 61,171, 77,210, 81,106, 99,134, 77,247,101, 74, 96, 16, 34,241,
168,222, 38,116,111,180,113,136,199, 86,234, 71,150, 43,130, 70,169, 21, 74,219,
236,170,177,112, 34, 79,127,126,109,111, 42, 76,149,243,190, 44,156,105, 90,154,
 26, 78, 64, 21,139, 47,201,251, 76,203,146, 21,120,248,130, 44, 61, 73,132,177,
180, 58, 49, 60, 55, 82,180, 44,184,215, 87,244,146,245, 89,173, 15, 80,244, 75,
 36,208,144, 37,223,220,  8,222,255, 45,132, 19, 36, 21, 94,248, 16,115,163,113,
 56,162, 88,228, 64,242,112,124, 80,147,117,111, 89, 14,241, 65,146, 65,223,237,
118,112, 44, 65,209, 44, 20,162,122, 65, 29,156, 66,240,175,138,236, 91, 68, 48,
 28,101,123,120,227,211,151,244,170,156, 52,184, 81, 20,227,159, 93,195,117, 42,
165,  1,  1,  9, 17,162,171, 19,219, 67,208, 19,176, 27,220,235,194,216,248,124,
 51, 40, 72,175,137,193,165, 43,253,113, 95, 27,251, 81,181,192,134,196, 81, 83,
178, 71,149,138,  3, 77,239,131,187, 37, 52,169,232, 87, 43, 48,  9,251,135,144,
 66, 18,247,  4,201,113,113, 95, 31, 12,209,220,218,197,248,198, 83,211, 93,113,
210,222, 51, 54, 81,228, 87,200, 98,222,212, 15,137,173,166, 12,  7, 42, 35, 98,
136, 80,192,138,186,239, 85,148,202, 71,  3, 46, 64,  5, 81,128,129, 38, 85,246,
 31,195,135,226, 34,146,111,143,214, 37, 17, 94,238, 12,155, 13,195,248,  0, 92,
208, 93,245,133,175, 98, 44,  7,118, 43,201, 51,140,137, 38,218, 26, 29, 13,216,
137,183,101, 83,213,127,193, 20,148, 35,244, 61,223, 30,145, 29, 20,224,  8,146,
 51, 39,219, 13,106, 90,  3,138, 38,170,252,237,209,214,  7,178,154,169,206,188,
 74,174,187,122, 62,101, 61,170,  7, 44,163,138,255, 54,137, 17,229, 43, 64,185,
250,135,  2,234,101,  7, 47, 51,170, 80,139,215,101,152,130,181,183,  9,165, 68,
 12,142,191, 85, 95,250, 43,139, 86, 23,126, 71,215,140,253,124, 76, 36,215, 42,
 86,225, 40,238,127, 75,186,  0,115, 41,237,138,180,243,158,114, 76, 69, 44,153,
126,153, 10,186, 85, 44, 56,172,252, 90, 69,167,174,181,100, 21,124,117,172, 25,
212,188, 58,  0,139,114, 76, 49, 73,  1, 90, 48,229, 33,152,146, 57,165,250,101,
 89, 10, 47, 21,101,173,112, 75,145, 91,  0, 75,173,202,208,172,133,132,108,114,
176,209,168,128,138, 81,237, 75,235, 49,113,181,150,219, 51,148, 82,146, 87, 10,
 67,129, 58,114, 47, 82,247, 71,110,201, 65,  5,  9, 44,137, 16, 63,244,138,152,
130, 53, 42,215,209,128, 30, 71, 61,  3, 24,229, 25, 24, 72,162,122,191,207,206,
176,250,136,252, 76,120,244,214, 63,114, 32,238, 76,216,  5,203,152, 86, 30,142,
247,196,107,216, 30,141,183, 57,173,217,183, 52,104,152,223,135,200,101,234, 11,
154, 62, 73,111,203,123,168, 33, 27, 68,178,224,140, 38,229,183,231,142,114, 34,
119,117,227,222, 29,216,245, 77, 43,  3,201,129,204, 73,240,252, 11,  9,237,183,
 78,199,238,172,165,192,126,118, 18, 39,135,156,198, 56, 44,117,129,251, 39,235,
130, 26,165,152,214,163,198,  1,101,114, 44, 73,135,200, 32,146,166, 34,141,175,
145,159,  2,199,190,217,238, 80, 89, 78,139,158,140,241,  8,153, 68,207,201,190,
203, 39, 46, 31,  9,222, 33,246,189,243, 12, 50,146,168,187, 56,134,105, 65,  2,
170, 58,229,152, 29,233, 90, 53, 76,140, 52, 36,  1,216, 19,149,162,128,237,  1,
247,  8,173,100,168, 23, 66,130,253,222, 27,168,160, 65,196,211, 64, 20,133,217,
  3, 34, 18, 54,234, 64,207,156,242, 16,217,  1,220,221,242,250, 80, 35, 67,  0,
253,128,220, 63, 21,218, 88, 68, 75,232,229,241,137,187,226,130, 71,218, 59,113,
254,228,254,135,124,220, 13,239,125,216,145,207, 33,156,152,182,248,245, 49,193,
 90,219,171,220,167,117,206, 55,144, 75, 65,127, 96,235,105,194,245,197, 18,206,
253,188, 78,249,  8,199, 10,106, 30,163,196, 19,215, 23,156, 72,  4, 92, 70,  0,
 18, 70, 22, 25,112,207,  3,250,159, 12, 49, 25, 96, 32, 41,210,250, 66,185,215,
  7, 41,147, 42,176,250,255, 77,  9,207, 57,175,251,113,148,195, 38, 72,230,106,
153, 25, 91,149,170,  8, 21,140,174,217, 48,115,181,204,140, 93,150, 38,137,  3,
132,125, 37,139,114,177, 33,177, 47,132,253, 36,124,154,252,250,247, 72,208, 86,
200,195,152,178,  5,180, 45,191,255,  0,205,  2,138,123,168, 84,255, 40,  0,131,
 91,  0, 64, 87, 74, 41,199, 70,156,  7,100, 64,  2,  1,197,  1,193,147,129,132,
 11,128,233,  1, 64,  0, 24,  1, 24, 80,  0, 16, 64,  0,  1, 68,  8, 80, 17,  7,
 44, 53,224, 41,124,192,148,202, 47,  5,189,172,248,151, 83,  1,232,151,105, 68,
253, 44,212,249,  0, 72,134,137,115, 40, 86,188,  3, 96, 96,229,164,211,212, 28,
 41,140,255,155,  7,103,110,  6, 60,232, 56,170,103,114,237, 57, 80,  5,176,198,
 85,217,201,159,  8, 69, 32, 54, 46, 31, 62,  5,207,237, 61, 63, 40,141, 36,187,
 38,  1,237,148,207,159, 66,111, 68, 97, 99,154,236, 94, 27,172,160,147,241,104,
 18,104, 41,169,221,117,133,127, 88, 30, 34,190, 37,155,167, 54,248,115, 77,170,
207,191,110,171,243,180, 69, 41,  9,195, 34,122,248,131,174,235,229,118,184,252,
123, 32,104,139, 85,142,137, 68,151,187, 81,160,238,150,145, 75, 18, 74,127, 95,
154, 10, 56,230, 30, 14, 61, 93,101,146, 27, 69,145, 37,  5,154, 98, 83, 46,115,
 50,197,130, 72,203,238,209,134,241,151, 97,  6,189, 32,113, 14, 29,125, 27, 18,
 69,175, 36, 60,116,244, 97, 73,100,119, 37, 93,249,178,  6, 73,210, 47,140,140,
208,  4,153, 31,140,118, 17,142, 12, 69, 24, 90,205,  4, 77,  2, 89,  7,213,140,
183,111, 23,144,155,216,234,137, 54,240, 18, 45, 83, 54,180, 97, 86, 40,105, 65,
180,133,233,136, 63,155,165, 75,184,  8, 96,171, 47, 67,219,  0,247, 72,202,115,
254, 26, 38,169, 99,161,176,210, 83,219,130, 41, 56,128,  8,103,248,228,134,  8,
244, 41,239,  6, 42, 11,115,109, 65,232,237,207,161, 64,  3,215,254, 41,146,223,
155,156,235, 67,105,244,196,125,224, 37, 13,123,155,156, 40,139,112, 14, 76, 21,
 34,168,173, 29,148,202, 52,227, 87,179, 34,193,108, 63,  3,  3, 10,152,246,169,
 16,246,223,138, 47,105,132,153, 81,122,106, 27,120, 17, 77, 75, 26,218, 24, 23,
148,108, 65,212,194,116,196,159,227,161,195,160,  8, 67,171,145,161,109,128,123,
 36,229, 57,127,141, 20,194, 50,223,106, 46,133,190, 57, 94,215,230,136, 48,247,
 14,254,  8,149,213,184,150,207,254, 86,107,176,201,205, 34,127, 53, 95, 82,198,
246, 93, 37,191,104, 69,213,164,228,205, 58,255,100, 94, 82,195,205,175, 24,254,
 70,108,173, 51,107, 55,225,195,172,139,213,202, 98,237,205, 79,156, 88, 13,192,
190,208,  4,253,225,238,227,107,133,  8,179,180, 39, 74, 42, 77, 62, 96, 48,109,
184, 84,  8, 26,139,155, 91, 56, 52,186,184,112,215,102,206,198, 45,183, 44,  7,
 93, 18, 53,238,176,213,215,119,186, 81, 63,157,192, 17, 53, 26, 26,120,238,208,
 91,135, 83, 45,163, 26, 88,102,135,127,134,180,116, 83, 16,165,218,232,166, 89,
182,211, 21,156,163,251,165, 89,151,214, 81,160,219, 23,225,247,228, 40,209, 18,
 83,110,159, 35,217,109,221,211,221,211,104,122,119, 90,135, 46,246, 45, 66,143,
116,128, 34, 22,209, 37,117,210,229,181,252, 64, 87, 21,216,197, 92,114,235,162,
  7,134, 96,212,  4, 56, 24,252, 14,107,199,  4, 31, 87,224,133,183,122, 56,139,
 46, 58, 48,138,150, 18,132,232,171,141, 20, 92,203,173, 90, 89, 87,237,187,102,
 85,130,197,  0,204,217,174, 89, 44,179,145,130, 52, 93, 80, 39,  1,243,208, 35,
137,112,100, 19, 65,136,150,152,157,202, 35,157, 84,241,188, 33,  8, 66,158,145,
 37,192, 97,240,123, 88, 59, 38,248,184,128, 47,188,213,195, 89,116,209,192, 88,
180,148, 32, 68, 95,173, 70,229, 26,200,  1,139,131, 34, 67,215,170, 37,100, 55,
222,126, 35,101,142,131, 58,202, 19,220, 58,128,138,252,152,237,136,193,219,109,
 72, 41,  1,172, 67,219,136, 47,174,207,181, 91,112,  4, 21, 18, 66,  2, 55,138,
144,233,240, 26,227,133,167, 83,122,  5,175, 92,185, 49,132,164,148, 71, 15,132,
  3,143,171, 24,211,172,148,188, 87, 37,163,194, 40,198,114, 14, 29, 33,133, 44,
138, 97,231,  8,118,184, 26, 70, 40, 80,178,247,103,124,158,136, 93, 81,141,195,
215, 92,163,120,115, 84,208,166, 61,239,212,  4,166,143, 18,143, 27, 19,250, 18,
  2,108,189,170,113,228, 36, 38, 86,  0,144,110, 73, 49, 80, 72,  8,  9,220, 40,
 66,142,195,107,140, 23,158, 78,233, 25,188,114,229,198, 16,146, 82, 30, 61, 16,
 14, 60,174, 34, 12,108,213, 90,105, 32,144,195, 25, 78, 45, 81,137, 57,101,212,
102,191, 39,138, 88,105,174, 44,119, 20,241,134,165,  4,193,181,210,236,228, 92,
123,169, 85,110,170,131,225,173,102,177,235,209,188,233,197, 10, 65, 31,246,127,
236,  3,185, 18,116, 99,178, 31,223,  7, 52,101,145,181,135,253, 58, 41,158, 20,
 19,223, 20,198, 65,210,175, 86,  5,222, 28,246, 43,164,182, 56,245,123,181, 97,
 92,219,231,  4,249, 48,197, 64,123, 72, 40, 64,140,101, 14,196,  4,240, 90, 82,
 55, 50,188,179,253,119,221,249,119, 34,150,220,170, 69, 45,191,151,143,241,241,
115, 30,117,159, 97,  1,124, 18, 28,145,253,187, 28,172,158, 92, 35,104,251,240,
 14, 62,  3, 78,143, 61,195,113,164, 36, 67,133,170, 59,239,199, 71,208, 41,177,
 77,114,199,167,181,169, 37,182,242, 49,124,248,157,151,221, 49, 11,124, 18,  9,
 82, 80,167,185, 49,248,248, 16, 62, 16,215,117,171, 57,247,  4,  1,179, 30, 28,
143, 62,  8,104, 82,119,114, 17, 79,197,244,245,131,182,204, 59,213,186,162,  0,
251,114, 64, 35,109, 89,241,191, 13,227, 24,105,223,160,113,233,205,131,247, 29,
225,154,172,123, 22,100, 22, 50,160, 28,187,227, 64, 56,216, 83,237,208,159,  5,
109,248, 73,104,169, 12,215, 34, 56, 10,157, 81,194, 41,117, 24,190,248, 89,204,
 38,188, 95,119, 83, 26,124, 46,180,  4,  3,233,169, 22,154, 39,100, 70,249, 76,
 97,136,  5,209, 88,190,176,101,140,149,141, 81,114, 58,162,185,142, 47, 35,250,
243,185,154,109,166,165,154, 52,161, 23,244,224,252,207,231,134, 10, 83,123,231,
 61, 63,134,132,122,106, 91, 87,214, 27,179,100,181,166,251,198,166,  7, 67, 73,
127,162,218,186,209,184,215,164,166,128,115,184,187, 57,248,255, 60, 84,188,233,
191, 57,224,127,205, 20, 78,127,100,  1,230, 96,168,240,166,255,230,128,102, 98,
 77,  0, 65,157, 93,162,125, 60,186,110, 72,128, 66,202, 56,180, 56, 39, 39, 75,
117,181, 95,119,109,175, 21,253, 65,168,230, 84,178,143, 47,109,140, 74,111,125,
 10, 30,161, 75,253,159,205,  3,213,165, 63, 77,251,254,220,197, 20,180, 19, 76,
 63, 10, 73,101,163,200, 30,233, 80, 17,153,224, 95,160, 28,196, 37,199,237,129,
241, 93,253, 59,194,242, 84,218, 54,192, 63, 68,208,184,151,110,197,186,213,111,
 36,160, 40,106,210, 81,247, 29, 20, 45, 77,  9,233,122,152, 67, 68,133,234,252,
191, 41,158, 54, 75,227, 96,150,160, 66, 85,239,254, 18, 93,171,214,117,180, 56,
164,211,141,105, 97,217,254,191, 65,242, 74,194,142,217,161, 53,251,  0,180,175,
 40,223,119,141,189,225,116,242,127, 56,220,173, 63, 39,106,  7, 93,212,244, 28,
227,224,138,194,190,163, 21,118, 92, 21,255,197,162, 61,245,212, 71,221,107,  7,
117,187,110,240,238,204, 74,247,184, 58,232,116, 79,127,134, 37, 36,238,255,119,
180, 23,  1,184,217, 78,  2, 25,  6,183, 42,169,222, 67,107, 91,253,178, 81,130,
106,142, 86,150,146, 38, 39,149, 60,219, 94, 13, 73, 52,106,106,237,171,245,209,
188,162, 75, 35,227, 28,219, 94,109, 64, 52,106, 74,252,215,244,212, 46, 12,173,
 60, 68,210,198,213, 74,121, 97,120,214,201,254, 51,239,192,122,144,129,254,166,
 57, 96,203,183, 14,152,  0, 90,  7,174,243,176,219,123, 27,  8, 39,146,153,208,
183,231,140, 70,219,188,240, 55,  0,114,234, 85,197,100,165,215, 14, 46,118,153,
255, 10,171,111,186,246, 92, 68,185, 68, 13, 69,158,206,158,219,151, 16, 85,151,
182,116,208, 56,204,185,141, 90,212,248, 13, 53,135, 74,210,124,134,154,155, 42,
234, 68, 67,157, 67, 85,107,186,161,206,161, 22, 53,191,161,166,251,112,100,107,
177,149,102, 65,101, 93,252,  7,107,169,135,180,167, 43,106, 70,128,118,  5,213,
216,254,162,219, 80,166, 89, 63,114,194,204,152,104, 80,243,215,228, 67, 53,215,
 16,109, 34, 70, 26,234, 56, 54, 17, 35, 13,117, 78,107, 96, 88,232,122,247,177,
243,204,167,178,123,223,147,103, 56,149,222,250,115, 68,184, 68,210, 14,174,159,
 26,115,196,176,109,219,196,152,139,119,193,126,187, 94,128,197,146,205,252, 13,
177,151,105, 67,108,112, 32,116,139, 61,185,192,226, 10,104,  5, 39,119,174, 10,
100,122,119, 94,253, 67, 17,244, 17, 62, 37,157,176,236,174,116,183,153,103, 13,
157,169, 31,198,156,115,168, 36, 11, 78,137,174, 47, 32,210, 65,176,235, 18,105,
165,192, 20, 88,173,115,122,  4,112, 12,243,178, 40,146, 91,217, 65,175,221, 66,
 77, 69,235,121,  8,248, 54,234,113, 26, 87, 66, 58,232,113,  5,139,243, 81,248,
178,203, 44,215, 52,204, 80,177,225,  4, 23, 55,186, 45,205,145, 77,250,251, 49,
246,155, 21,190,161,249,197,244,114,214,133,146,191, 93,180,204,124,184, 28,188,
233,161,219, 25,133,222,253,239,176,130, 47, 38,108,207,176, 88,136,213,127, 56,
110,225, 20, 51,194,126,132,161,127,238,222, 82, 21, 91,101,240, 87,101,148, 11,
196,226, 23,189,100,115,181,218,230,170,154,  8,109, 84,236, 32,123, 11,214,114,
 32, 64,231,  7,125,253,167,209,135,123, 46,172, 11, 71,254,  7,135,118,162, 70,
241, 85, 63,183,174,142,246, 15,165,131,126,132,247, 23, 31,104,154,192,226, 21,
 67,143, 36, 34, 70,156,157, 66, 47,220, 81,197,151,150,217,101, 10, 93, 39,224,
109, 93,172,200,117,153,210, 17,152,247, 63, 92,179,143,191, 17, 81, 14,150,115,
135,235,120, 16,175, 39, 30, 96,112,150, 22,244,137,  1,106, 91, 12, 17, 45,160,
 78, 93, 55,250,218,149,180, 72,183, 31, 17, 39,250,160,227,219,105,119,172,105,
 44, 98,197,157, 22,160,121, 86,188,220, 36, 57,164, 85, 49, 25,199,203,241,114,
200,240, 26, 66, 19,  1,253,  0,  1,  1, 20,187, 81,110,118, 18, 70, 26, 91,216,
 46,133, 49, 38, 23,252, 81,152, 76, 12, 76, 30,147, 72,128,178, 64, 40, 39, 73,
115, 52, 27,210,153,  6, 36, 84,  4,206, 99,105,198,223,212, 32, 99,181,254,228,
111,200, 14,157, 77,198,141,204,213, 71,161,164,157, 27, 78,168,141,133, 66, 66,
 88,150,  4,212,222,  9,197,116,162, 34, 65,180,232, 36, 13,  4, 40,111,118,223,
 48, 87,220, 14, 51,150,204,119,215,234,  9, 44,129,153,  0,  0,  0,139,184, 93,
  4,179,200,155,102,166, 27,123,199, 27,114, 51,111,252,235, 70,195,107,177,171,
193, 70,168, 99,110,187, 23,227, 17, 67,141,177,129, 15, 72,152, 57, 98,177, 24,
 76, 32, 64,176, 91, 20, 99,152, 58,179,178,211, 45,131,179, 19,163, 32, 18, 25,
141,208, 20, 84, 51,150, 96, 48, 22,101,245,  3,200, 20, 25,  5, 85,  3, 63, 67,
131,126, 70,153, 50,202, 60,242,192, 25,151,179, 81,207,125, 19,225,128,207, 96,
201, 51,128,154,  2, 72, 25, 76,165, 33,210,224,246,214, 10, 10, 12,131,209, 54,
255,  1,133,140,136,176,248,122,109,133,132,  5,226,202,100,212,163, 16,155,137,
231, 42,131,194,154,201,128,  9,  5, 46,105, 76,147,  8,213,238, 18, 93,125,220,
 20,146,  3, 13,  1, 13,158,109, 66,  7,176,138,111,103,136, 98,223, 29,  0, 96,
202,133,201,224,  0, 67,227, 23,252,186,248,138,135, 76,189,171,209,237,214, 43,
163,252, 53,243,245,251, 60,247,186,182,215,218, 21, 54,122,179,201, 44,160,144,
155,141,  8,182,179,247,230,234,105,154, 92,211,149,166, 53,176, 98,147,  0,226,
178,168,176,248, 91, 83,128,154,207, 94, 89,227,155,203, 55, 81,115, 81,238,130,
 25, 71,163,173,113,202, 47,118, 96, 17,115,229,185, 71,233, 68, 14,  8, 44,101,
221,139,252,180,254,  4,180,254,197,239,223,242,223,231, 15,249,191,159, 44,242,
143, 29,248,185,250, 56,154,177,112,244, 63, 82,207,124,139,209, 70, 59,  9, 17,
 24,217,214,247, 60, 87,185,206,252,200,157, 58,221,177, 25,121,162,127,253,243,
207,167, 55,156,220,237, 14, 33,100, 24,253,  1,129, 71, 56, 27,141, 81, 72, 57,
207,117,154,  0,166,142,105,200,141,175,110, 63,172,214,209,  8,114,232,250,132,
209,239,155, 48,193, 67, 55,114,219,107,121,106, 73,130,163, 44,131,175,109,119,
204,222, 17,133,147, 29,203, 17, 97, 84,146, 36,201,  5,192,  6,163,136,213, 36,
186,118,187,117,227, 58, 53,203,224,170,165,219,  6,155,194, 13,185,185, 51,204,
 85,173, 84,237,192, 43,134,206,152,115,110,198,113,199, 76,147,122,102,100,143,
 61,233,185,  5,181,231, 20,207, 58,232,241,208, 32, 20,  4,  4,177,174,121,145,
 77,130, 36, 91,202,  0,120,116, 57,111,116,220,106,118,144, 91, 32,102, 16,100,
122, 40,232,225,255, 92,  5,193,231,204,135,101,186,189,127,237, 90,167,197, 32,
143,221, 10,128,239,150, 34, 59,147, 74,139, 81, 69, 46, 48, 62, 23, 24,245,194,
106, 54,106,216, 40,243,166,252,208,181,174, 69,134,  4, 18,158,220, 78,177,174,
159,217,159,134, 14, 27,159,143, 71, 26, 94,237, 54, 39, 91,118,226,190,126,148,
195, 96, 48, 68,163, 40,202,  2,  5,177, 18,138,217, 66,196, 35, 23,212, 67,159,
 99,129,130,196,178, 27, 33,194, 15,172,125, 30, 54,214, 11,136,102,177,173, 92,
 43,160,181,116,118,120,210,  3, 46,242, 18,229,229,114, 65, 94, 62, 41,163,148,
 31,118,203,191,143,179,229,150, 91,150,117,177, 52, 23,  5, 83,254, 98, 93, 46,
214,229, 98,189,180,100,228,219,209,184,219,219,189,123, 18,210,191,175,251,228,
195,247,185, 42,251,101, 58,186, 10, 31, 28,154,232, 82, 80,157,214, 49,119,133,
 75,133, 10, 87,  5,237,241, 89,157, 92,231,185,224,115,181,106,245,167,105,187,
 22,219, 58,179, 80, 91, 19, 10,226,215, 42, 73, 60, 37,112,118,245, 87,196,220,
223,  8,138, 85, 93,236,210,187,189,186,164,245,203, 71,206,198,188, 90,191,188,
115,237,114,159,236, 90,159,246,106, 97, 95,176,189,242,185,207,  8,161,108, 78,
142,114,216,185,159,156,  7, 54, 31,147,172,116, 28,150,147,191,242,228,202,226,
235,126, 60, 30, 15, 77,122,216, 14,195,100,232,122,200,242,138, 75, 15, 93,246,
208,236, 64,  8, 76,210,161,194,243, 28,184,201,139, 83, 39, 33,127, 36,140, 74,
 87, 84,103,  8,219,166, 54,177,202, 82,156,164, 74,156, 58,212, 69,144,136, 78,
 74,175,227, 38,136, 52, 25, 29, 34,135,200,171, 84, 42, 92, 57,162,195,241,112,
184,  3,  4,219,117, 37, 74,182,179, 99,175,196, 70, 61,141, 43,239,211,188,200,
177,161, 71,135,136,102,204,135,112, 87,238,109, 47,103,217,244,175,217,255,255,
255,255,255,255,255,123,245,207,  1,148,254,168, 36,251,245,114, 38,  0,  0,147,
243,  0, 12, 14,141,138,132, 18,145, 28,  5, 50,203, 62,180,224,134,195,139,197,
130, 14, 66,131,195,  0, 29,128,192, 16, 12, 16,130, 13, 96,  0,  5,  0, 44,128,
  1, 16,130,160,136, 34,210, 34, 37, 85, 18,  0,167, 33,236,220, 72,193,202,141,
 15,100,173, 64,148,131,  3, 82, 55, 99,171,156,132,  8,214,216,192,223, 40,229,
 19, 77, 75,226,111,114, 65, 81, 80, 43,  4, 49,142,  5,176,118,  1, 32, 98,194,
134,226, 35,216,155,144,184, 11,210,208,125, 78, 44, 58, 93, 40,255,220,150, 52,
 89, 35,112, 51,128,143, 45, 73,177,201,103, 31, 53, 20,197, 92,168,160,156, 25,
194,136, 77,186, 70,133,187,158,110,204, 54,136,137,252, 88,255,116,214,246,141,
  6, 14, 76,183,183,237, 25, 82,252,125,165, 39,151,129,218,200, 74, 35, 81, 97,
  7,176,132, 18, 24,119,133,102, 90, 78,254,138,228,103,146,  6,122,194,133,214,
 18,213,225, 68,128,  4,252, 86,171, 36,146,141, 60, 12,137,156,235, 56, 10,162,
137, 16, 14, 16,167, 77,196,195, 41,118,250,242,150, 43,111, 22,246,224,123, 81,
234,128, 56,164,237,240,212,  3,230,209,105,106,174,187, 43, 71,206, 59,164, 38,
126,179,199,251,247,235, 28, 92, 15,227,  6, 12,197, 37, 68,118, 50, 57, 61, 50,
111,162,248, 39,129, 14,132,  3,147, 10, 31, 55, 10,250,221,141,132,254,140,109,
 76, 39, 17,168, 69,  3,152,220,126, 13,169,216,249, 90,172,223,122, 68, 35,171,
100,217,246,233,177, 81,254, 68,154,107, 19,132, 82, 77,217, 92,163,202, 81,232,
160, 58, 49, 50,174, 82,127, 88,192,171,128,117,201,117, 24,  8, 57,109,162,102,
107,215, 93,195,230,253,174, 78, 64, 43,117,141,214, 69,  9,188,109,214, 54, 90,
153, 50,186,182,131, 47, 82, 86,167,174,  2,217, 28,246, 71, 10,  9,135,141, 31,
222, 64,253, 46,178,119,251,179,111,138,113,181,191,172, 18,184,119, 15, 38,  1,
 54, 87, 87,175,153,167, 37,230,219,178,215, 90,  9,149,184,249, 82,101, 62,157,
 49,170,120, 36, 54, 30, 66,237,167,184,120, 58,137, 97,178,252,190,194,209,140,
143,101,144, 25, 57,106, 51, 60,  1, 18,214,101,128,101,147, 52,200,138, 78,115,
 56,120,167,242,248,145, 21,115,134,220, 69,125,211, 24,218, 13,253,103, 20,115,
 27,234,177, 13,178,148,183, 51, 82,104, 54, 68, 67,151, 12,127, 49, 15,172,111,
 40,165,119,241,176,198,151,104,110,198,245,122,210, 64,241,134,255,169,148, 68,
 94, 43,124,138, 88,195,219,252,167,125,188,136,138,108,132,140,125,105, 60,220,
 80, 43,115, 38,124, 71, 36,170, 78, 71, 18, 27, 75,166,192, 80, 59, 83,245,108,
157, 26, 22, 27,249,234,174, 81,153,137,206,142, 22,134,209,231,175,158,176,175,
228, 19,117,216,241,172, 90,130,214, 51,141,242,177, 42, 87,189, 26,  5,143,145,
129, 56,211, 57,220,220,187,123,140, 25,219,227,108,183,151,255, 10,104, 90,198,
 37, 97,185, 42, 93,184,184, 61,129,  7,229,120, 52,132,  4, 15,185, 33,118,238,
 86,184, 43,237,244,221, 55, 28, 74,140, 94,186, 97,220, 33, 52,153, 50, 77, 88,
157, 46, 22, 30,163,  1,  9,250,241, 71,198, 44,116,162, 63, 60,155,200, 18,132,
159, 17,226,152,197,132,242,189, 60, 54, 76, 13,190, 57, 45,  0, 52,119, 83,243,
249,172,255,114,105,245, 78,  0, 46,253,151, 68,118,100,162,203,148,126, 19,  1,
136,158,238,247,212,  2,208, 13, 77, 86,104,153, 90, 33,104,159,112,155,221, 62,
 40, 18,133, 65, 19,215, 52, 26, 96,138,113,  5,188, 63, 20,201,  6,183, 74,172,
 22, 87, 40,221,  0,153, 63,128, 85, 84, 81, 39,  7, 83,140,236, 68, 36,210,128,
193, 19, 48,185,203,143, 41,200,173,199, 84, 86, 25,150,253,  8, 55,247,  6,227,
194,190,179, 37,118,138,253, 48, 26,243,147,117,113, 66,160,204, 85,212, 31,132,
163, 72,112, 31,102, 56,140,  6,196,164,207, 99,187,193,159, 43, 92,231,255,134,
 12,165,134,253,127, 67, 93,176,160, 81, 26, 58, 41,140,250, 98, 68, 21, 19,184,
 56, 19,241,253, 58,178,  2, 66,181,244,143, 52,187, 77,229, 48,212,194, 79,216,
144, 99,116,221,226,255,113, 96, 51,183, 25, 54,237,127, 32,217, 87,  1, 65, 37,
150, 68,241,224, 95,255, 17, 20,  4,219, 80, 38, 12,114, 28,134,240,224,223,201,
174,185,135,108,216, 90,156, 36,236, 68, 59,200,166,168,201, 56,158,250,181,242,
185,109, 92,118, 43, 17, 44, 69,170,203,153,119,223,200, 47, 77, 77, 67, 83, 43,
 99, 45,229,211,185, 14,245, 69, 53, 42,117,145,202, 18,226,193, 63,152, 55,110,
249, 81,160, 66,192, 24,147, 55, 98,161,182,177,126,191,248, 34,102, 30, 99, 57,
 29, 19,143,196,109,119,106,105, 12, 86,192,139,158,113,153,171,145,240,  5,159,
216,136,162, 15,186, 25,234,222,134, 15,149,120,208,167, 67,  2, 84, 31,178,  3,
 55, 79, 29, 72, 96, 31,241,229,  6, 25,204,130, 58,150,194,108, 85, 80, 14,176,
240,119, 67, 50, 60,211,101,101, 37, 16,199, 24,180, 52,166, 40, 85, 97,189, 52,
108, 47,176,134,130,219, 70, 96,  9,251, 86,138,131,179, 12,208,109,102, 17,218,
 66,205,147,187,237, 97, 74,199,136,185, 53,172,188,241,175, 64,117,196, 20,159,
 50,112,105,219,224, 82,104,246, 85, 90, 35,174,196, 40, 46, 38,187,160, 38, 45,
 60, 75,203,132,236,252,151,127,131,175, 75, 17, 85, 31, 77,192, 39,184,222, 37,
 93,166,193,129,184,229,238, 84,219,111,214, 50, 92, 38,  8,244,245,250,197,134,
 74,109, 34, 81, 77, 39, 45,143,179,211, 51, 88, 92, 38,217,  3,206, 63, 34, 51,
  3,228, 77, 32,  5,124, 50,225, 97,100,126,110,176,181,157,204, 62,111,135,107,
 28, 42,145,108, 41, 21,246,171,107,254, 99,115,250,196,189, 51,162,194, 80,132,
  8, 14,101,188,155,186, 64,236,149, 31,200, 68, 22,120,253,128, 47,  7,119,134,
148,128,247,235, 60,  0,223,224, 91,  2,139, 20,206, 86,165,175, 18,128,123,184,
 97, 29,212, 66,159,130,  5,211,220,122,163,149,103,109,219, 55,181, 50,123,194,
132,  5,152,174, 28,  2,255, 39,128, 92, 40,148, 88,103, 60,187,  0, 74, 28,119,
182, 47, 20, 10,122,153,111, 53, 20,128, 37, 87, 14, 69, 58, 88, 22,209, 86,151,
138,219,229,153,240,154, 46,250,166,230,242,214, 35,  6,  8, 75, 76,186,217, 53,
211,196, 48, 98, 87, 99, 76, 64,168,244, 90,133,147, 74, 39,196,253, 51,176,134,
 19,176,  3,223, 40,101,100, 56,182, 80, 92,228,242,168,236,120,100,104,216, 14,
223, 22,247,229, 51, 28,134, 76,225,212, 88, 77,100,180, 83,102,185,  7, 93, 25,
188,153,197, 54,  6,226,210,235,151,154, 44, 23,213,164,231, 56, 81,130,192,191,
 48,165,207,222,104,248,246,113,136,219,187,230,109, 26,214,139,253,  3,226, 95,
176,217,109,174,136,103, 89,201, 27, 20,246,172, 71,  2,136, 70,104,237,154, 82,
187, 33, 21, 71,115, 23,135,111,216,121, 24, 20, 36,133,189, 98,230, 29,248, 70,
 55,133,150,207,108, 24, 31,132,152,194, 27, 75,108,203, 64,239,238,206,219,172,
179,212, 19,154,246, 18,219, 81, 18, 90, 33,180,197, 96, 60,178,192,201, 70,140,
 13, 10,214, 63,179,109, 10,  5,202,198, 92,196,209,  8, 93,  0, 23,134, 42,  0,
176,161, 18,138, 30, 39,218,130,204, 17, 21,104, 88,253, 12,173,124, 20,139,  8,
 89, 74,  3,226, 33, 63, 13, 61,113, 44,  9, 15,126,135, 63,115,156,144,237,134,
 98,144,155, 40,115, 47, 49, 70, 92,202, 65,182, 70,131,122, 16,201, 45, 29,151,
107, 73, 26,104,100,  6,160, 35,201,185,178,209,156,244,142, 83,144,237,159,  9,
  3,189,212,165,158,123,  3,229,127,214,210,115,230,200,163,112,228,117, 15,202,
 22,165,106, 97, 20, 13,103,194,208,124,126, 70,196,189, 61, 42,242, 98,103, 35,
 18,109, 98,185, 37,237,204,233,252,125,113,194,222, 37,101,248, 33,214, 41,  3,
197, 52, 10,174, 19, 91,157,164,169,150, 10,196,179,111, 94, 82, 10,188,207,149,
117,251, 84,125,242, 91,148,100,231, 17, 19,190,102, 86, 60, 24,202,162,236, 27,
  6,128, 90, 70,143,123, 74, 36,124,112,222,196,130,111,135, 50,  6,175,240,134,
160,194,251,249, 46,189,157,110, 67,138,183, 23,197, 48,112,138,227,134, 75, 36,
 43,229,183,187,169,191,  8, 32, 94, 14, 81,227, 30,111,210, 74,220, 36,196,137,
 12,194, 35,173, 11,201,111,165,103, 39,189,146,221,  6,233, 20,166,118,119,170,
180,158,139, 85, 56,138, 81, 75, 47, 94,241, 35, 27, 31,216,139, 78, 21, 14,154,
246, 39,110,235, 27,246,141, 81, 74, 97,235,180,131,119,100,146, 69, 49,195,111,
161,234,105,167, 50,  0,174, 26,254,239,132, 40,154,  9,151,233,217, 34,112,116,
187,  5, 80,165,117,173, 79, 60,242,184,168,188,152, 39, 54, 84,195,171, 14,173,
162, 90,227, 78,143, 57,  4,230, 57,212, 16,157, 43,108, 93,103, 56,246,212,102,
 78,207,  4,167,172, 70,175,161, 93,218, 36,227,170,154, 76, 89, 50,239,246, 82,
 94,158, 30,221,218,123, 35,246, 25,118, 19, 62,219, 56,233, 19,144,210, 13,184,
 15,122,  0, 49,157,188,249,255,252,242,222, 95,187,131, 77,253,176,115,217,231,
199,111,156, 53,167, 89,252, 84, 32,105, 70, 48,141,234, 64,182,217,101, 31,224,
 20,177,219, 95, 66,184,134,215,171,112,221,109, 34,243,173, 67, 49,171,127,210,
193,219,102,189, 49,150,138,130,175, 79,220,199,221, 50,195,232,129,173, 79,111,
 52,  6,122, 90, 79,248,210,140,176, 87,175, 96,109, 52, 88, 83, 41, 43, 74,221,
 74, 76,246,226, 46, 12,163,222,  8,108,252,248,149,152, 70,250,227,253,113,  4,
177,213, 73, 65,184,165, 26,  5,179,169,109,128, 51,187, 59,255,  9,143,189,189,
 91,221, 48,218,196,197, 99, 75, 92,220,143,100, 15,207, 54,133,238, 69,183,186,
174,130,244,157, 61, 12, 35, 42,107,199,193,181, 80, 31, 12,115,191,114,202,241,
170,155,207,122,233,135,237, 31,187,132,114,255, 66,213,248,109, 82, 54,125,218,
238,165,246,132,210, 22, 49,194, 16, 87,160,163,226,122, 44,125,207,204,181,247,
146,212, 46,122,187,250,  7,198,235,161, 73,189,154,143,139, 73, 34,118,131,  3,
  9,236,113,214, 83,127, 52,112, 75,196,109, 48,118,160,168,181,229, 73,250,223,
186,148,216,244, 27, 10, 96,195,229,239,214,159,  6,216,164,197,141,149, 94,173,
179, 65, 38,150,234,181,251,138,226, 19,101, 12, 49,240, 48, 36,160,196,213,240,
220, 13,178,244,  9,166,  0, 32,106, 98,240,201,112,236,  3,231, 30,206,126,127,
 31,147, 23, 32,223, 93,222,128,229,187, 10,114,161,106,248,151,222,232, 60,127,
250,147,244,204,248,216,127, 39, 18,189,144, 88,219, 91, 20, 68,137,190, 86,120,
190, 61, 52, 30, 68,146,140, 25,248,174,174, 20,254,222,118,179, 44, 70,125,236,
 54, 77, 73,130,135,150, 75,186, 71,214, 55, 74, 33,  6,125, 28,237,214,175,137,
 96, 99,  7, 67,163,240,149, 31,149,133, 59, 12,129,199, 28, 62,172, 43, 28,112,
  0, 78,240,205,101,108,105, 40,190,110, 52,233,232, 92,188,200,242, 73,107,233,
 21,  5,157, 92, 12,179, 17, 41,253,184,240, 77,147,225,202, 31,187,  2,108,132,
237,131, 19,132,165,189,110, 21,167,255, 28, 27, 37,105,157, 69,  7, 43, 99,147,
 58,167,162,151,223, 50, 95, 42,204,101, 38, 53,244,157, 50,121, 89,123,  5,132,
214,130, 10,166,185,186,199,175,196, 93,181, 96,245,170, 52,213, 33,141,145,172,
206,122, 31, 86, 53, 39,187,134, 72,216, 72,244,191, 42,169,139, 50,202,236, 87,
 19,252, 88, 60,174,224,123, 81, 83,188,205,167,255, 92,152,177,205,195, 85,167,
210,119, 71, 84, 94, 90,103, 74, 85, 39, 81,150,148,128,195,242,143, 11,127,220,
 60,176,229, 60,149,248,231,242,149,165, 94,213,233,220,132,228,231, 48,157,166,
 83,247,125,183,106, 76,107, 30, 65, 25,134, 40,168, 73,142, 98, 10,165,251,136,
 41,125, 80,229,119, 76,199,209,169,185,158, 14, 73,173,223, 14,246, 75,142,195,
210,126, 12,249, 56,124,103,140, 62, 53, 96, 27,171,247,128,238, 93,117, 82, 62,
124,164,177, 48,219,249, 78, 10,138,  7, 88, 66, 80, 78,167, 57,127,248, 29,190,
188,234, 35, 16,117, 30,102,117, 65, 14,184, 65,248,183, 68,160,  2,213,  0,  8,
126, 16, 33,141,158,131,195, 20,  5, 49,130,194,175,167,  8, 39,108, 62,167, 42,
 55,112,141,183, 23,201,249,170,170,228,105, 64, 19, 34, 58,119,129, 12,252, 96,
 93, 11,239,209,245,154,162,204,105, 28, 12,178, 50,  4,188,146, 19,245, 44, 66,
168,242, 55,175,114,176,189,160,141, 69,208,118,220,191, 78,216, 36,  2, 75,189,
183,204,168, 27,233,144, 36, 91,191,106,  4,172,141,135,231, 17, 83, 73,162, 97,
 16, 37,  0,109, 19, 13, 66,237,196,204,116,202,168, 38, 91,107,139,208, 53,150,
  0, 98, 11, 29, 74,209,131, 39,176, 70,220, 17,143,159,138, 92,221, 13,168, 32,
 26, 41, 62,208, 49,146, 29, 63,177,242, 85,154, 86,110,186,223,210,162,180,159,
207,197, 25,146,166,190, 97,104, 98, 21, 93, 90,134,210, 25, 64,229,  6, 36,184,
 74,183,121, 68,208, 32,167,174,124,175,160,108,133, 53, 22,185, 51,192, 66,139,
 13,236, 63, 76,142,244, 62,169, 72,231, 21,100,237,245, 62,  0, 95, 15,230,200,
 53, 88, 60,100,253,232,131,176,149, 28,228,168,202,101,120, 83,153, 11,226, 62,
251, 41, 40,215, 96, 25, 55,236, 39, 70, 11,238,195,170,211, 69, 16, 63,161,237,
213, 59, 55, 92,208,214, 11, 90,121, 91, 39,141, 53, 56,219, 34,217,116,151,246,
186,171, 65,255,233,250,164,196,149,205,224, 34, 73,231,104, 74,154, 77,122,130,
237,176,254, 45,215,231,229,189,160, 85,242, 91,223,146,114,149,213, 45,206,220,
 71, 25,100,174,173,181, 10,151, 22, 54,228, 54, 66, 73,126,147, 50,191, 46,  9,
131,  7,150,218, 76,193,164,149, 57,184,244, 45, 74,167, 90,199, 55,236, 73, 26,
 81,153,148,160,112,185,190,145, 78, 14, 52,173,169,187, 85,183,145,174,101, 82,
169,221,146,133,150,224, 90,  8,166,229, 93,251, 89,243,112, 97,153,196, 45,178,
164,158, 74,101,174,218, 35,154, 15, 83,203, 86,112, 93,181,239,165, 83, 45,166,
 39, 55, 48, 21,180,100, 65,225,  5,147, 47,237, 87, 26,251,136, 34,205,117,106,
172,105, 77,206, 75,156,202,140, 67,169,  2,  6, 95,  5,118, 47,132, 25, 26,185,
172,105, 95,186, 44,206,213,198,154, 36, 39,194, 88,130, 73,209, 62,203,123,161,
 27, 79,237, 52,137,148, 83, 67, 88,208, 72,135,179, 58, 33, 20,140, 59,168,116,
 85, 83,220, 56,229, 98,112,209,231,238,197,174,203,228, 82,191,146, 33,203,183,
127,228,209,254, 97,185,230,154,152,220,217, 92,138,143,210, 62,200, 71, 33, 15,
162,231,192, 71,178, 90,157,246,223,164,125,104,120,192,195, 64, 75,142, 40, 90,
133,217,108,158,102, 59,192,139, 27,224, 80,239, 24, 95, 78, 48,229, 77,156, 29,
 93, 44, 47, 49,208,227, 95,175, 34,246, 52,190, 47,  0,123,177,107,190,132,208,
185, 96,239,127,222,123, 70, 13,115,144,163,157,243,223,137,251, 54, 29,185, 15,
235,125,118, 66, 45,152,252,173,181, 97, 44,129,186, 25, 75,121, 36,114, 46, 66,
234,150, 34,165,  2, 88,108,129,122,253,159, 89,175, 17,129,120,179, 78,228,154,
159, 78,119, 71, 83, 20,212, 94, 61, 29,129,116,  9,129, 20, 45, 93,126, 59,164,
126,192,223, 39, 36,111,139, 95, 12,247,164, 20, 62,153, 97, 89,251,197,109,114,
123,  2,116, 48,108,128,223,144, 68,254,159, 62, 61,242,195, 97,145,158,252,107,
229,254,110,201, 50,193, 33, 29,  1,225,116, 52,159, 89, 53, 87, 27, 70,247,207,
152, 58,128,198,205, 94, 48,227,169, 23,221,203,180, 45,135,250, 48, 57, 96, 40,
 48, 18,121,167,143, 31, 90,232,  0, 42, 50,122, 56,  9,161, 33,129, 54,120,204,
 24, 43,114, 71,146,191, 21,171,112,253,255,100,149,147, 82,186, 50,171,112,  8,
242,190,169,200,  5, 13, 15,240,128,168,184, 46,170,249,109,224,144, 27,177,208,
175,126,194, 97, 69,236,211,202,245,  0, 25,241, 34,174,147, 82, 43,  6, 54, 32,
 14, 79,248, 16,106,254, 33,119,201, 56, 91, 48, 86,168,  2, 32, 89, 84,243, 94,
132,122,  8,249,124,119, 29,249, 88, 96,222, 87, 23, 16, 79, 72,147, 40,  7,240,
160, 79, 80, 74,183, 89,140,163, 82,125,  4, 15,158, 57, 14,118,  2,177, 55, 42,
 90, 57,237,237, 24,202, 45,201,167, 75,117,194,135, 26, 11, 40,137,128,191, 22,
  3,143,254,101, 15,110, 71,  0,124,236,253,156,206,127,236, 82, 65,109, 48, 46,
136,240,250,188,159,  5, 82, 22, 52,241,148,101,146,162,168, 37, 22, 25,116, 98,
254,193,146, 57, 31,236, 83,174,117, 94, 78,239, 51,226,149,216,136,  4,  0, 25,
182,219, 51,145,106, 50,145,  0,108,  5, 82, 13, 10,101, 15,133,133,131,  3, 16,
204,194,113,129,157,160, 12,232, 20,177, 71, 10,121,116,202, 62,109,101, 99,107,
 50,  9, 32, 42,206,178, 42, 43, 56,248, 98,177, 60, 82, 95, 18, 16, 49, 73, 68,
166, 44, 57,121, 65, 21, 58,118,105, 60, 70, 63,238,226,245,220,234,198, 41, 36,
 36,  2,235, 94, 58,141, 74,223,144,250, 81,107, 24,117,171,  1,133, 84,188, 39,
 20,168,228,233,193,125,214,241,160,169,252,200,123,196,138, 46,149,162,128,160,
106, 51,  6,185,207,112,200,173,109,119,100,100,148,101,160,193, 66, 91,253, 77,
 65, 79,130, 15, 67,182,240,114,210,169, 88, 22,122,248,241,142, 81, 23,243,210,
  8, 77, 82,141,225,252, 87,137,239,185, 13, 25, 23, 86, 17,169,214,  5, 38,  0,
155,254, 38, 52,184,112, 90,231, 65, 29, 72,132, 81,251,106, 81,203,182, 42,110,
  2,163, 16, 98,255,142,164,203,116,159, 74,138,171,126,153,127,236,113,137,255,
137, 85,196, 97,119,129,176, 72,149,242,120,246,209, 67,153,190,186, 94,211, 21,
112,208, 84,168,125,102,161,159,127,206,194, 52, 94,232,145,164,235,147, 42,113,
 65,  2,221, 92,218,150,162,224,186,184,173, 86, 76,141,240, 57,148,165, 78,157,
245, 53, 58,210, 92, 65,243, 62,192,249, 32,227,155,244,127,106,165, 52, 44,222,
179,112, 97, 85,  5,185,108,221, 64, 94,216,  4, 54,190,141,136,129,209,254, 84,
 38,111,126,129, 28,154,209, 72, 72,141, 39,133, 58,232,158,121,225, 80, 73, 10,
 11,184, 18, 43,137, 18, 67,226, 19,137,  1, 58, 77,126, 47, 55,129,205,226, 46,
 68,191, 94, 28,193,139, 95,201,212,243,239,182,142,202,104,  1,140,187, 26,126,
 91,  6, 88, 15, 78,223,254,179,162,178,103,  3, 90, 27,168,255, 76,205,205, 42,
 56,109,188, 57,156, 82, 23,125,205, 27, 51,166,249, 90,  5,132, 24,172,147,  7,
207,162,211, 21, 78, 40,188,240,128,210, 23,214, 12,206,255,  3,117, 85, 45,165,
154,107,173,223,223,118,109,245,242,193,  5,176, 74,171, 35,235, 85, 24,255,  8,
 73,200,221, 45, 32, 26,  1,126,228,178,166, 33, 25,239, 28, 46, 44, 34, 25,161,
 89,244, 65,124,  2, 71, 46,150, 70,247,165, 43,225,219,163,248,146,114,150, 48,
211,247,213,104, 40, 32, 50, 18,103,215, 68, 43,148,  1,144, 36, 30, 79,147,156,
210, 64,186,249, 56, 49,143,215,240, 97, 17,185,140,127,228, 58, 98,243,208, 78,
145,239,160,210,220,172, 82,125,250,136,  0,220,188,148,117,171,138,248,211,216,
  7,130,193,200,179,197,232,235,193, 96,204,169, 24,134, 59,243, 24,164, 80,  2,
212,197, 71,165,195,245,111,150,234,195,245, 12, 29, 58, 65, 53, 48, 25,184, 69,
220,212,211,127,242,121,241, 17,112, 58,248, 53, 42,197, 50,176,  5,209, 84,172,
 47,101,248,215,167,212,217, 58,223,250, 36,117, 72,110,172, 93,115,224, 87,249,
 68, 61,146, 75,106,  2, 99, 46,164,154,109,  8, 41, 12, 42,133, 76, 43, 77,189,
 37,223,226,179, 30,165,162,135,234,165, 16,164,195, 25,238,153,221,164, 56,104,
  6,151, 30,236,177, 72, 34,118,172,185, 59,180, 32,178, 81, 41,156, 80,164,107,
 84,145, 10,113,193, 91, 34, 26,167,241,134,111, 16,194,161,124,198,228,193,182,
  9,128,218,  6,237,229,  9,  3, 13,133,107, 34,137, 84,163,  1,180,142,232, 15,
 87,216,184, 35,  7,158, 32, 10, 94, 63,227,232, 58,199,124,113, 74,107,186, 59,
116,119,211,221,240,169,105,192,247, 64,163, 92, 47,174, 90, 49, 15,186,104, 52,
 86,175,240, 44,122,140, 16,209, 27, 92,111, 45, 46, 52, 63,138,238,176, 98,174,
114, 52,250, 89, 29,109, 36,242,241, 80,167,124,162,206,245,234, 23,120,215,161,
 31,139,182,225, 30,105,229,150,234,123,201, 18,215,223, 14,210,  4, 79,  2, 48,
 20, 83,226,240,204, 50, 70,220,250,198,211,109,224,  8,191,188, 93, 62,183,178,
 55,187,104,124,  9, 60,107,157,213,134,147,133,129,118,184,  2, 50,211,  3, 37,
173,112, 97, 67, 66, 74, 78,  0,226,156,246,204,213,212,180, 42, 28,131, 39,219,
 32,188,131, 13,132, 15, 69, 54,119,113, 19, 97,213,160,241, 94,172,173, 44,224,
155,230, 62,  2,114, 20, 67, 32,197, 36,121,154,195,  7,170,228,207,176,168, 59,
192,157,180,131,  6,215,  9,140,197, 60, 31,152,248, 99,147,209,  1,155, 43,103,
120,181,109,130,200,165, 45, 90,192, 11, 25, 67, 81,246,237,  9,210,250,197, 60,
 50, 36, 69,125,165, 38,227,153,151,237, 70,225, 79,139,165,143, 83,116,118,203,
251,233,  2,214,236, 28, 76,204,110,109, 62, 78,151,110, 25,178, 68,246, 38,200,
174,209, 78,235,131, 55,213, 62,199,182,175, 66,235, 42,253,113,121,159, 74,158,
181, 58,101, 64,170,115,154,249, 28,204,160,140,  0,120, 55,  1,100,241,203,190,
200,  3,  7,251, 79,168, 39,145,236,101,255,117,194, 11,162,174,233,194,131, 28,
 49, 48, 27, 57, 22,134,255,121,110,192,129,115,187, 42, 69,129,233,154,215, 97,
 11,154,188,205,237,230,225,216,238,105, 52, 52,127,243, 62,138, 93,161,197,244,
212,215,148, 38,113,161,196,128,204,238,113,184, 37,212, 63,187, 77,208,188, 21,
 86, 70,161,253,241,166,229,185,186,152,167,154,117, 63,  5,109,182, 10,247, 36,
 19,232,118,  5,133,238,202, 61,157, 18,233,133,128,205, 55,217,219,148,147,148,
  0, 13,234,219, 66,248,255,252,207,111,243,216,126, 78,  9,223,218, 64,212, 75,
 12,226,188, 21,220,187,133,196, 76,246, 60, 16,104, 20,181, 50, 62,  2, 89,222,
 57, 14, 97,104,238,105,101, 87,143, 69, 78,105,246,252, 30,166, 43,179,182, 58,
  7,193,178, 90, 92,213,150, 84, 53,160,  3, 81, 91,128, 80, 91,  3, 71,109, 88,
177,172,169,208,154,201,146, 23,140, 10,106,227,107,242,158,117,203,127,  7,190,
117, 92,  0,136, 72,155,182,152, 26,179,186,  5,112, 69, 42, 81,181, 89,  8,133,
 56, 22, 31,242,107, 54,149,  9,123,136,139,204,163, 47,118, 43,236,223, 89,177,
147,195,  1,100,128, 91,169,137, 13, 51, 76,177,145,172,  2,243,155,127, 98, 81,
 38,  5, 98,100,202,144, 88,139,238,240,129,206,191,113,194,131,151,202, 97, 95,
207,133,219, 29, 92,134,194, 30,247,129, 25, 30,125, 50,110,  6,133,192, 36, 50,
 18,116,221,187, 63,115,201,118,160,115, 29, 30,152,187,143,144,195,130,152,139,
207, 47, 64, 20,175,238,156,255,114, 78, 92, 11, 71,222, 64,182,205, 43,102,171,
170,195, 13, 24,164,237,126,184,248,209,173,194,189,239, 88,146,255,156,247, 32,
213, 83,187, 10, 86,241,167,101,241,116,152, 58, 56,160,212,165,106,115,201,226,
 61,180,118,106, 57, 34,129,171, 17,132,241,249, 43,181, 50,158,249, 53,233, 86,
 55, 82, 69,201, 52, 10, 74,221, 33,  8, 63, 82, 72,149,190,148,145, 36,202, 65,
243, 23,188,233,129, 31, 25,239,190, 68,250, 83,163,127,117,242,155, 69,227,154,
  8,215,147,225,129,  4,250,  8,112,251,196,160, 14, 78,115, 42, 56,251,214,201,
255,202,219, 71,153,209, 96,223, 33, 76,108,  1, 88,224, 15,179, 82,151,145,131,
 31, 10,163, 51, 46, 88, 50, 40, 58,217,112,158,177, 81, 64,173, 28, 85, 52, 99,
 45,119, 37, 32,220, 79,209,147,238, 91, 32,177, 15,146, 57, 33,157,  6,143,230,
 66, 50,191, 25, 87,179, 39, 10,183,217, 14,138, 29, 74,249,153,147,166,112,162,
240,147, 44,  7,171, 45, 99,237, 75,187,137,174,151,174,  6, 73,121, 99,225, 98,
 45,  4,133, 65,197,159,100, 15,222, 95,240,247,216,232,132,159, 57,198,147,159,
253,222,160,132,186,123,162, 45, 20,144, 95,196, 81, 52, 52,227, 19, 74, 12,212,
204, 21,226, 68,171,109,237,176,114,137, 54, 59, 13,223, 19, 37, 19, 38,218,253,
150, 93,251,103,147, 68, 19, 14,187, 38,254,131,144,219,  0,234,110, 52,162,218,
187,138,195, 44,188,186,220,201, 39,113,184,130, 54, 97,  4,221,205, 48,151, 33,
215, 14,229,157,226, 59,155,141, 11, 24, 80,134,111, 60,239, 20,234, 46, 62, 93,
  5, 34,233,206,241,135,254,174,113, 23, 39,224,250, 88,146, 35,182, 64, 79, 66,
  4,104,244, 36,206,101,205,160, 93, 87, 66,250,174,185, 20,121,136, 83, 80,200,
 77, 92,177, 42,103,234,225,  1, 29, 76,242, 20,190, 65, 13,220,103, 39,  2, 47,
109, 72, 49,123,214, 44,101,212,110,193,250,212, 78,157, 17, 88, 61,156,120, 89,
 14,146, 48,192,162,184,203, 27,136,222, 27,105, 54, 68,225,150,166, 64,238, 10,
 58,216, 28,155,155,114,217,238, 50, 42,209,150, 38,130, 32,243, 47,140,112,  6,
 96,235,124,140,182,116, 81,198,194,  9, 38,219,154,249,140, 51,199, 47, 70,206,
126,150,212,182,160,234, 78, 46,164,199,139,139,219,165,151,239, 86,227,162,  3,
196, 35,167,251,164,183,229,186,117,128, 92, 60, 76, 40,103, 94,172,118,207, 26,
 18,209,104,227,214,  4,209, 29, 89,226, 55,187,186, 75,163, 69,166, 89,205, 66,
 57,161,168,254,103,131,126, 58, 83,219, 55, 58, 28,247,141,198, 34,190,101, 77,
  3, 43, 76, 92,210,147,131,222,107,119, 91, 34,147, 39,248, 31,169,129,251, 33,
 66,151, 62, 65,134,  6,180,192, 67,119, 87,135, 84, 58, 96, 75,188,239, 44,208,
  1, 97,161,103,209,141,122, 96,241, 97,148,219, 28,  9,177,  0,189, 46,117, 65,
202,165,183, 70,213, 89,233,171, 39,206,224,224, 91,237, 10,129,255, 94, 22, 24,
 17,142,227,231,168, 98,250,141, 69, 10,191,  3, 84,139,227, 62, 83, 39, 70,213,
 72, 64, 69, 66, 42,187,100,155,225,154,183,255,102,228, 53, 59,154, 62, 23, 22,
164, 30,175,221,107,113,221,217,190,206, 19, 40, 48, 40,  2,118, 48,163,107,148,
205, 56,  3,141, 42,227, 16,111,202,242,181, 55, 64, 72, 19,229,214, 77,101, 40,
250,145,151,172,  2, 32,255, 45,211,115, 45, 82, 90,184, 34,151, 37,176, 55,  9,
140,199,233, 30, 68,119, 53,209,103, 18,162, 19,190,168,158,  8,164, 74, 95,211,
 60, 84,121, 56,128,104, 43,178,202,248,166,184,176, 63,  5,  9,100, 79,249, 29,
  4,138,114, 86,135, 31, 50,139, 79,143, 26,  4,149, 13,192,101, 18,104,235,185,
171,193, 13, 77,115,101,  8, 56,218,188, 24,240,121,129, 66,215,213, 28,143, 29,
118,234,249,101,219,106,170,145, 18, 72, 31,  9,113,228, 97, 21,109,219, 64,  6,
147, 75,  3,205,193,  6,130,105, 60,191,101, 19,207, 64, 72, 47,214,141,204,196,
 41,182,103, 52,139,202, 28,133,209,238, 24,234, 49,173, 14,201, 20, 40,120,108,
 12,249,238, 64,220, 23,138,109,219, 70,123, 59,152,135, 70,146, 31, 74,220,207,
136,169, 68, 83,101, 73, 46,188,238,137,138,237,217,228,227, 26,213,240, 20,190,
 89,120,197,145, 31, 84,206, 48,168,155,252, 10, 48,144,189,110, 88, 66,202,199,
198,121,193,241, 33,141,158, 34, 62,164, 79,185,143, 49, 88, 42,245,201, 58,136,
233,188, 18,245,162,239, 51,  5, 75,203,182,208, 82,163,184, 72,  4,162,192,137,
 41,108,163,144, 84,109,176,240,177,  8,231,144, 79, 65,245, 80,153,236, 39,186,
133,138, 11, 54,136,161,142,161,134, 56, 80, 88,193,153, 30,107, 59,  3,108,199,
103,254,235,173,185, 82,206,106,104, 36,244, 41, 24,237,223,174,  8, 81,152, 24,
178, 21, 68, 39, 85, 69, 77, 68,210,112, 96,124, 67,226, 32,247, 18, 23,193,173,
 82,241,171,151, 86,249, 63,181,207,253, 57,207,130,178,139,  2,217,109,236, 60,
207,135, 76, 98, 87,100,141,163,111,226,171,142,226, 33,  8,125,138,194,121, 66,
207,120, 54,235, 80,172,192,212, 70,124, 29,251,228,159, 31,251, 68,254,205,163,
141,196,112,119, 94,170, 96,110,140,103,195, 99,207, 66,196,244,194,227, 38,158,
157,116,176,237,204, 24,120,255,151,177,128, 67,237, 17, 22, 67, 62, 87,195,242,
 74,232, 24, 11, 45, 78,253,191,237,220,112,218,  4,154, 25, 44, 88,162,193,167,
169, 96,151,141,106,215, 32, 36,  3,239,225,  4,132,140,127,143,104, 75, 96,231,
 30,  7,241,191,112,202,203, 81,  0, 12, 93,255,203,  1,191,210, 23,150, 19, 57,
115,218,116,216, 67,249,203,235, 45,231,251,133,230, 98, 34,158,108,251,210, 27,
201, 91,182,107,  4,215, 89,  5, 84,174, 68,159,208,160, 63, 64, 69,204, 18,225,
 90,249, 32,180, 51,  9,160,189,203, 88, 33,208,236,  8,202,204,224,132, 83,176,
 96,115,252,154,200,212,206,164,183, 98, 23, 85,  3, 76,218,237,112,  5,124,171,
 86, 38,172,232, 33,168,201,191,108,220,189,105,224, 47, 98,221,169, 84, 95, 21,
224,117,108,120, 11, 81, 82,202,255,233, 67,123, 81,184,118,177,145,249, 29,247,
134, 90,198,255, 22,196, 20,198, 69, 54,127,225, 97,251,171, 36,  3,252,233,161,
145, 43,158,117, 20,216, 41, 94,230,254,186,122,191,255,183,163,117, 19,154,220,
  7,138, 24, 99,127,108,221, 88,131,252,113, 92,169, 67,195, 61, 36, 31,240,242,
128, 82, 63,227,116,  0,108,  7,183, 20, 76, 45,228, 67,190,222, 88,197, 86, 11,
185,149,194, 57,206,185,  1,  7,234, 81,168,214, 11, 87, 22,  3,169,172,223,  1,
171, 14,  2,222,156,117,100, 54, 37,197,161, 89,236,163,103, 82, 79,220, 78, 72,
240,133,  4, 58,246,169,197,225, 13,207, 13,237,221,247, 26, 75, 95, 35,153, 21,
 19,203, 78,146,144,195,173,200, 56,183,148, 72,220,128,242, 38, 27,160,138, 36,
239,191, 60,143,130,163, 31,161,  2,142, 75,  9,194,145, 12,109,252, 79,155, 29,
146,125, 72,140, 47,103, 76, 40, 20,155,128, 36,227,162, 24, 18,122, 57, 65,140,
253,231, 90,179,108,208,125,173, 14,190, 81,118, 11, 29,126,218,148,143, 20,247,
 16,115, 40,226,249, 83,194,149, 41, 19,132, 27,171, 22,141,  9,  0,218,249,223,
210,118,199,184,109, 81, 82,238,209, 69,145,154,110, 69,159, 79,131,150, 68, 67,
238,152,100,184, 99,114,243,199,244, 56,207,192, 50, 42,103,204,222,104,154, 59,
210, 75, 64,  2,241,236, 19,255, 57, 80,251,103,  8,103, 73,139,196,190,104, 85,
 77,226,239,142, 27, 58,168,151,244, 85,221, 12,155,125, 78,123,239, 30, 96, 18,
154,247, 99, 33,215,187, 39,145,205,113,202,192, 82,219,126,  1,  8,201,237,206,
168,  9,145, 25, 82,142,122, 43,176,169, 42,165, 48, 54, 23, 38,187,234, 10,103,
234,  2, 42,112, 78, 22,199,143,242,166,203,199,135,110, 45, 97, 57, 78,201,206,
 88,104, 78, 99, 16,149,153, 58,241,140,140,120,172, 26,177, 39, 16,216,231, 30,
254, 36,160,149,244, 56, 38,  0,222,238,243,120,211,137,183,217, 24, 68,190,252,
105,152, 82,200, 43, 32,131,  8, 99,142,229, 28,109, 56, 48, 73, 40, 26,254,  4,
173,253,162,215, 16, 79, 26, 48,251,255,175,112,104,219,138, 59, 99,202, 91,212,
105,121, 94,220,174, 86,122, 96,107, 34, 41,154, 21, 55, 17,103,194,205,163,155,
 80,222,104,236,176, 40,226,222,164,129,254, 47,153,198,213,242,173, 64,166, 70,
172,106,209,140,175, 90,197,215,118,178,  0, 85,183, 55, 95,126,183, 78, 20,158,
134, 74,183,244,146,116,236, 50, 93,198,163, 61,158,180,114,  1,  7,243,132, 71,
191,215, 58, 48, 48,140,143,192,116,132,252,  1,212, 79,110,100,148,145, 49, 60,
 51, 10,  4,170, 50,202,107,196,198,165,208, 83,188,210,247,184,191, 41,245,242,
146,  6,190, 96,186, 77,184,230, 36,242,  5,240,224,253,146, 99,116,158,251,  8,
231,136,156,206,239,187,193, 59,252,183, 93, 66,  1,231,234,205, 29,173, 25,230,
189,131,203,237, 90, 40,194,155,187,183,208,244,198,201, 67, 28,161,180,241, 45,
  7, 96,143,252, 86, 20,153,111, 24, 35,  0, 92,187,121, 58, 56,137,  9, 43, 58,
 70,241, 27, 57,176,180, 36,103,246, 62, 93, 46,116,220,198, 84, 98,158,114,128,
152, 61, 55,219,193,144,209,110, 21,177,241,205,173, 50, 32,  4,120,197, 58, 90,
 43,110, 55,102,176, 72,154, 41,249, 21, 44,221,172,150,110, 32,253,107, 88,207,
150,146, 43, 46,165,137,230, 85,112,155, 71,167,220,243,249,109, 65, 26,112,188,
194,140, 86, 96,179,251,206,  7,246,164,224, 37, 21,181, 16,223,168,154,211,166,
224,100, 12,129, 47, 39, 31,  0, 80,228,213,218,  2,163,  2, 44,118, 20,176, 40,
170,153, 66,167,  2,223, 29,  7, 47,170, 35, 88, 36, 49, 72, 73, 25, 36, 40,218,
 69,  3,  7,108, 18, 64, 36,197,119,231,110, 15,140, 98,141,223,182, 88, 80,  8,
192, 70,213,167,  9,  0,194,218,110,144, 97, 80,160,247, 87, 97, 33,188,211, 88,
 75, 69, 29, 60,106,148,133,194,210,166,133,156,120,244,235,147, 93,201,187,165,
241, 18,  0,126,189, 22, 51,225,200, 78, 84,202, 61,105,126,134, 85,153,  9,138,
149,202,184, 23,147, 27,249, 38,181,149,167, 97,  5,170,166,223,246, 10,255, 46,
192,138,221, 86,176,110, 33,225,105,141,128,192,223,164, 98,146, 34,214,178,172,
124,104,214, 59, 90,  1,112,169,237, 61,218,  6,108, 13,  6,172, 73,231,221,  2,
163,215, 96,199,112,143,  8, 77,227,213,160,  9, 40,156, 50,130,195,188, 58, 26,
219, 59,253,  8, 63, 52,102,166,200, 33, 65,162,194,163, 85,118,115,157,175,113,
  2,196,156, 13,128,217,163,243,245,218, 45, 58, 88,186,248, 43,252,253,148, 27,
 79,154, 57, 52,150,185, 41,147, 88,107, 68, 50,218,203,125,116,216,229, 17, 65,
112,101,164,166, 57, 10, 14,160, 72,114,250, 49,171,  1, 19,233,195,  2,238, 89,
197,  9,239, 54,100,187,137,130,229, 88, 75, 13, 18,202, 94,142, 40,229, 35, 82,
 35,103,214,  6,138,218,  2, 86,  9, 13, 45, 13,151, 17,156,198,127,186,137, 31,
 57, 88,231, 71,221, 58,207,159, 87, 73, 83, 37, 98,203,  3, 25, 70,204,  7,194,
 94, 88, 83,138,144,212,204,128,  6, 57, 65, 86, 79,170, 65, 94,107, 76,132,207,
 28, 66,208, 43, 96, 20, 73,222, 18, 87,255, 71, 51, 91, 49,225, 51,192,105,234,
142,132, 72, 27,117,106, 48,202,165,186,172, 67, 48,234,123, 69, 91, 38,108, 96,
 51, 36, 47, 25,180,127,108, 53,128,141,150,  8, 48,209,124,131,172,102,186,243,
129, 72,187,  1, 63,254, 55,146, 10,185,141,192, 42, 96,226,147,152, 24,  8,242,
 57, 93, 35,122,223, 67,193,116,177,247, 54,198,103,126, 99,182, 99,154,105, 72,
 95, 93, 85, 81,163, 75,136, 13, 84, 20,170,151,200,246, 48,232, 30,246, 40,163,
132,107,207,217,  7,193,170,145,237,179,126, 88,109, 33,160,186,120,102,180,101,
 54,198,172, 15,146,153,152,196,194,244,111,231, 97,200, 22,111,181, 35, 18,101,
 36,121,160, 57,170,162,197,228,163,124,195, 29,  0, 77,229,213,150,142,194,183,
 97, 66, 89,216,146,247,203,  3,188,107,172, 18, 71,205,170, 50,140,229,116,161,
 26,  9, 59,244, 98, 84,145,136, 42,156,254,101,137,104, 36,116,175,237, 13,116,
228,193, 21,195,238,100, 81, 19,207,146, 58,246, 69,  2,221, 64, 68, 14, 85, 18,
 79, 36,  4,243,219, 47,196,245,174,228,147, 52,215, 28,  0,111, 89,127,131, 91,
 75, 49,245,  9,174, 39, 23,238,241, 31, 49,111,209,183,165,184,206,189,204, 63,
 71, 63,114,158, 73,169,136, 78,133,  5,132, 80,  5,253,249, 15,133, 71,176,185,
135, 51,165, 12,  7,218,244, 24,188,118,163,160,180,122, 67,112,183, 66,209, 58,
169,121, 25, 38,160,230,212,189,194, 88,245,130,225, 36,104, 59, 41,195, 46, 29,
 28,109,189,248,201, 52,164,139,194,  3,188,179,134, 62,133, 30,186,162,102,118,
106, 89,108, 40,244,119, 13,  6,127, 63, 41, 32,217,237,  3, 36,237,177, 48,110,
147, 64,101, 42,136, 23, 99,  8, 61,184,226, 97,192,234,244,205,248, 53, 37, 11,
147, 56, 59,203,202, 21,139,135, 37,234, 47,225, 32, 68, 77, 84,211, 91,150, 60,
102,200, 32, 62, 20,151,211,188, 98,242,118, 95,174, 56,201, 55,223, 36,170,157,
107,103,194,187,207,161,111, 70,114,220,228, 38,229, 81,155,233,208,128, 88,215,
  6, 82,242,248, 58, 81,175, 52,232, 28,154,133, 50,112, 78,170,177,139,147,121,
 64,237,190, 34,241,204,173,214, 75,206, 81,133,152,171,118, 24,  4,251,171, 48,
 60, 20, 48,254,234, 75, 52, 84, 19, 50,230,  3, 61,245,249, 51,174, 50,  0,100,
 68, 35, 55, 82,112, 57, 28, 25, 86, 12,151,160,180,124, 46,126, 55, 64,103,128,
130,  4,156, 31, 17, 70,  0,174,237,137, 91, 11,201, 14,113,187,150,224,105,183,
 27,119, 59,153,124,241, 96,116,103, 42, 42,219,254,215,207,248,173,139,206,172,
163, 16,156,184, 67,106,140, 76,249, 36,132,222,144,241,144,251, 27,227, 65,157,
240, 83, 27, 88,232,153,102, 55, 21,166, 91, 43,238,206,241,146,120,186,181, 40,
204,244, 52,196,190,179, 54, 40,244,105,101,239, 15,231,114, 83,  4,189,  9,249,
200,136,148, 17,160, 51,185, 52,169,128,239, 64,156,103,226,  0, 93,116,232,  8,
162,137,245, 83, 63,203, 53, 61,159,108,237,210,182,  8,162,185,  2,126,135,163,
 78, 63, 68,132, 94,117,246,143, 99, 27,178, 73,119,250, 77,108,224,129,222,121,
 15,131,156,200,210,116,179, 93,124,  4, 64,237,138,  0, 96,204,131,105,204,255,
124, 17,251,203, 97,152,145,246, 97,  5,121, 24,  8, 78,196, 89,212,249, 35, 63,
 37,215, 97,163, 32,183, 97, 76,184,116,117,174,196,110, 10,237,141,  9, 62,226,
230,253, 72,103, 16, 59,245,165,226,139,243, 19,183, 40, 71,251,103,242,224,107,
145,187, 67,187, 29, 51, 73, 12, 21,113,181,179, 61,168,182, 11,147,157,151,137,
145,  3,134, 30,221,195,138, 37, 69,176, 38,213, 29, 74,121,130, 83, 95,201, 58,
 13, 33,133,253,133,163,107,248, 23,227, 94,119,141,219, 29, 72,153,131,180,141,
114,115,250, 22, 10, 42,119,157, 32,  6,221, 43, 65,120, 70, 27,138,136,116,181,
220,101, 43,193,241,142,171,224,230,147,168, 34,186,169, 24, 82,105, 67, 78,109,
211,134,194, 38, 39,145,112,249,162,187,177,234,245,189,108,241,106,125,149,141,
124,175,187,212,207,171, 65, 42,181, 48,101, 54,114, 79,149,254,176, 28,213,138,
126,100, 42,126, 62,174,142,124,114, 18, 97,206, 32, 81,163,189, 37, 72,112,229,
241,167,212, 80, 98, 31, 32,142, 91,184,149, 99,211,101, 27,231,134,212,175,165,
221,185,232,171, 25,142,  4,134, 62,238,109,191,171,114, 23, 16, 82,209,145,207,
140, 37, 99, 67,  5, 64,173,145,100,  3,168,152,110, 18,128,  3, 50, 66,148,159,
205, 92, 39,186, 17,193,234,202,208,193, 33,245,203, 13,145, 10,123,224, 94,242,
 29, 39, 60,152, 52,222, 23,224,246, 36,142, 35,223,143,113, 92, 15, 30, 52,  0,
200,128,215,175,239,242, 27,170,163,  3,115,149,222, 44,239,204,249,149,246,151,
168,224,123, 63,184, 56,127, 76, 64,169, 81, 19,232, 59, 72,180,160,107, 24,249,
222, 39,245, 15, 65,227,141, 78, 73,165, 48,223, 98,243, 63, 56,118,243,155,187,
253, 91, 93,221,190,125,210, 54,148, 51,130,190,185,201,109, 46,190, 84, 29,246,
229, 19, 37,246, 74,248, 87,179,251,139,135,118,180,132, 86,114,251,232,167, 23,
 40,192,  8,119,115, 21, 44, 30,185, 98,112,  3, 35, 70,193,174, 21,101,254,143,
174,107, 31,124,185,218,146, 83,164,  5, 17,230,160, 75, 31,117,219,  5,148, 21,
100,218, 15,161,249, 82,207,113, 75,141,122,189,140, 84,248,194,129,153, 96,  4,
 30, 39, 99,136,164,248, 51,219,198,189,171,112,141, 15,141,164,106, 70,  0,252,
231, 44, 37,244,128,247,222,161, 31, 49,162,167, 24,  6, 44, 71, 95,170,103,143,
 63,199, 82, 91,126, 23, 76,164,184,112,140,172,182,220, 27,201,252, 76, 60,149,
 85,126, 67, 97,156, 56,234,171,138,127, 97, 98,151,178,182,105,224, 47,156,103,
 28,148,197, 36,111,224,205, 35,198,197,241, 79, 42, 22,229,137,199,145,151, 71,
249,125,225, 91,231, 86,157, 42, 50,155,192, 95,122,191,204,215, 53, 33,217,  6,
 76,248, 73,  3, 58,239, 35, 67,255,229,243, 44,126,188, 57, 37, 30,203,231, 38,
 36,225,238, 54,218,178,145, 65,181,194,  1, 25,238,155,164,176, 91, 12,161,134,
 88,247,228, 20,242,112,119, 80,255,213,119, 17, 19, 42,163, 34,174,126,102,193,
 53,233,189, 73,225,183,134,254, 61,216,136,138,148, 23, 16,177,210, 53,236,125,
 46,194,219, 91,224,125,198,156,216,133,254,131,167,248,120, 55,130, 24,111,220,
200,104,225,244,113,182,  3,247,115,242, 69,132,114,140, 83,125,248, 58,132,179,
202,140,107,164, 18,147, 91,166, 32, 86,194,  8, 17, 44, 76,183,153, 87,162, 58,
154,177, 52, 93,163, 65,158,250,245,146,167,157,130,182,177,224,  2,120,180,245,
 59,227,233,136, 19,163,249,186,168,116,100, 37, 58, 97,202,205,135, 30,238,107,
152,131,150, 45, 84,232, 51,194, 46,206,154, 82,127,109,143, 97,126,133,178, 40,
171,188,116,229,  3,149, 95,253,178, 99, 15,167, 63,152,246,224, 36,146,  6,104,
209,255,249,237,225,143,242,  2,160,248,215, 37,147,193,111, 77, 15, 78, 74, 79,
 49, 34,197, 66,225, 89,152,241, 41,216, 57, 41,120,216,184,217,165,110,129,176,
 80,126, 14, 55,160,154,113,179, 40,140, 31, 70, 71,150,  5,105, 88, 76,196,138,
201, 44, 23, 58, 69,156,143, 94, 89, 51, 79,239, 44,214,135, 27,191, 64, 48,240,
167,160,222, 67, 10,210,109,243, 53, 81,  2, 26,200, 30, 74,110,251,223,218,253,
131,253,234,119,188,153,176,129,194,188, 11, 90,122,120, 58,198,224,  4, 47, 69,
 42,250,150,240, 83,  5,109, 73, 53,129,253, 82,157,166,  4, 74,145, 86,164,151,
  7, 38, 23, 41,234,132, 68, 68,114,252,255, 35, 40, 56, 44,185,243, 61,187, 55,
148,237, 43,176, 95,197,155,227, 38,232,193,192,163, 20,149,156, 95,162, 83,153,
  5, 68,  3,120, 88,123,178,166,184,157,132,164,181, 23, 10,160,205, 48,245, 88,
 16, 17, 21, 17,227,166,148, 98,110, 86,201,143, 90,250, 56,209, 56,134, 86, 25,
165,  0,167, 61,181,175, 64,  8, 96,221, 69,248,254,203,125, 55, 48,161,248,222,
235,116,143, 34,148,222,209, 81, 35, 45,197,200,155, 33,  5, 85, 15,227,212,134,
  8, 43,232,205,116,120,247,117, 76,  6, 52, 65,126,209,104,  2,146, 64,122,142,
180, 82,220,108, 44, 59,141,170,222,173,201, 27, 47, 80,175, 32,233,124,153,115,
 26,216,115,188, 49,250, 65,188, 84,168,141,161,250,200,219,109,126,171,193,165,
 76,214,237, 90,215, 52, 34, 34, 13,252, 75,165,159,150, 45, 38,182,157, 75,156,
103, 58,207,113, 38, 36, 18, 70, 95,105,106, 64, 48,141,  3, 17, 90,143, 59,167,
252,254,108, 19, 90,147,236,203, 82,147,113,181,212,104, 94, 90,197,105, 17, 44,
197,159,147,107,126,113, 45,122,203,141,118, 85,200,105, 34, 95,157,152, 13, 34,
170, 21, 75, 58,210, 33, 27,116, 21,205,102, 84, 57, 34, 10,225,184,195, 82, 26,
 45,103,213,238,225, 14,129,216,219,170,176, 40, 14,248, 27,148,135,150,167, 25,
  4, 45,192, 40, 70,131, 24,209,249, 17,176, 24, 93,133,144, 64,208,139,200,238,
 76,248,153,158, 84, 95, 56, 39, 22,214,182,166,197, 15, 85,121,205,141,108,  5,
200, 25,113,206, 70, 71,122, 55,153, 92,179,129, 30, 84,225, 16, 99, 69,139, 52,
 63,176,141,235,236,147,169,140,173,229,  1,168,183,  3,182, 77,190,221,168,  1,
 11, 53,201,110, 27, 50, 53,141,226,114, 68,245, 81, 32, 28, 32, 20, 13,229,129,
249, 20, 24, 73,186,249, 82,245, 48,206,255,228, 92, 98, 42, 49,206,  6,171, 71,
210,147, 96,199, 44,189, 56,110,111, 97, 68, 33, 68, 98,138,147,225,104, 65,237,
246,131,235,179,137,154,112,221,  9,  3,137,186, 57,146, 85,177,  4,106,156,108,
169,112,229,229,247,158,228, 68,154, 11,213, 57,153, 47, 34,188, 63, 28,167,138,
 24,200, 96, 24,249,161, 81,217, 95,153,169,204,168,125,153,156,157,129,200,134,
 36,240, 91,209,125,165,209,252, 44, 71,217,211,203,222,163,245,193,221, 59, 84,
210,109, 74,219, 84, 40,251,200,241, 14,244, 33, 70,103,128,  0,207,216,253,198,
156,220, 54, 17, 87,232,111,176, 76,154,112,227, 46,  4, 54, 72, 73,171, 19,172,
239,124,184,232,122,136,201,230, 51,194,222,153,220, 84,255,209,194, 87, 15, 74,
220,213,139,210, 74, 77, 94,198,125, 17,186,155,241, 44,102,120,129, 12,224,223,
142, 15,114, 27, 82,209,  1,185,116,232, 52, 94, 80,204,232,235, 57,  6,112,176,
117, 47, 83,  7, 48,198, 64,109,244,130,  3, 69,135, 96,107,114,129,153,147, 49,
168,101, 15, 27, 68, 82,187, 81, 32, 19, 21,190,171,131,113,113, 88, 79, 96, 69,
126, 93, 54,196,  5,240,110, 44,206, 98,203,115,245, 68,157,171, 97,  4,142,249,
 33,112,118,216, 99,230,178,158,221, 17, 36,155,  6, 50, 40,210, 71,212,202, 71,
 78, 53,159, 25, 53,  4,147,224,  6,  3,194,247, 26, 16,236, 23, 66,237, 47,101,
109, 65,218, 26,177, 59,123,192, 53,134,  4,202,182,213, 29,253,226,131, 46, 23,
111, 40, 86,175, 12, 64,173,177,159, 44,165, 10,212,220, 94,180, 41,226,254,201,
214, 40,170,100,112,219,251, 97,135, 74,136, 98,110,252, 88,204, 50,101,236,140,
137,248,150,141,154,146,168,117,183, 89, 98, 59,215,211, 45, 43,137, 82,211, 61,
238,130,194, 46, 46, 29,218,101, 69,222,152, 35, 38, 85,219,102, 27, 31, 35,141,
 50, 66,141,192,169, 35, 81, 17,234, 85, 80,232,106, 88,244, 65,103,151,222, 14,
 82,107,195,209,  2,211,195, 29, 68,107,  9, 92, 92,  3,166, 75,222,100,237,129,
219,153,114, 62,147,249, 85,117,137,104,104, 86,255, 11,210,153,146,200, 18,209,
153,160,139,175,243,149,102,151, 91,110, 36,108, 34, 82,197, 16, 71, 62,230,105,
 96,201,145,233,201,210,112,190,239,145,143,139, 84,159,193,128,115,107, 29,109,
 90,242,  0,157, 46,251,231, 93, 36, 68, 96, 65,186,112, 50,160, 68, 66, 58,176,
240, 64, 65, 94,176, 83,160,  0,163, 34,  5, 43,217, 41,223, 57, 20, 44,129, 65,
112, 29,108, 31,156, 88, 65, 80,136, 60,226,152,216,252, 58,182,181,158,146, 15,
147,211,251, 22,229,171, 69, 73, 15,248,148,  3,101, 56,141, 24, 63,216, 69,222,
 82, 25,117,207, 36,111,197,237, 40, 57,  0,113, 75,207, 63,123, 26,219,120,135,
173,152,  2, 50,232, 21, 92, 32,194,114, 26,  9, 73, 77, 96,140, 21, 14,228, 47,
111,251, 41,  2,127, 90,170, 33,230,255,220,157, 99,221, 65,215, 36,243,152, 79,
 69, 89,197,124,193,113,148,165,195, 61, 45,249, 81,106,244, 68,239,242,  4,240,
182,111,167,213,146,  4,164,194,140,200, 19,210,160,159, 19,136,114,153, 98,147,
 58,126,138, 11,156, 35,242, 88, 86, 13,174,192,224, 65,128, 65,192,129,182, 84,
 94,225, 10, 77,  3,172, 79,138,166, 27,158, 12,100, 16, 21,202,148,217,  9, 44,
229,121, 75,  8, 68,  8,112,243,218,  8,212,119,193,  1, 97,236, 49,119,163,178,
 36,240,114, 10, 92,189,188,241,249,190,208, 28, 56,126,164, 82, 83,158, 29,238,
 54, 56, 22, 97, 64, 67, 60, 18,212, 32, 98, 51, 60,116,111, 48,161, 39,240,106,
 28, 79,158, 35,243,175, 25,134, 39,192, 53,230, 35,180, 79, 39,177,168,198,168,
157, 98, 80,104,128, 60,183, 25,216, 87,205,142,184,177, 76,245, 36, 42, 57,171,
 36,198, 18,134, 90,  9,213, 57, 96,170,113,  8, 21, 65,202,235,157,153, 42,231,
 27, 90,215, 45, 78, 54,103, 94, 52,  3,209, 52, 19,139,149,140, 18,151, 81, 53,
166, 76,109, 54, 91,177,173,108,188, 54, 47,207, 64,118,200,108, 90,133,170, 70,
176,114, 46,204, 89, 94,220,130,136,158,  3,191,248,202,180, 13,196,217, 69,  8,
101, 94,  8, 70,149, 53,130,230,241,112, 11, 34, 86,189,160,153, 54,  0,188, 35,
107, 38,112, 49, 35,156,195, 16, 71,100, 20,161, 18,248, 94, 72,113, 79,238,126,
203,241,152, 51,103, 33,202,  9, 19, 32,240, 79, 62,228,221,138,142,101, 32,116,
 16, 18,123, 18,209,117, 52,136,254,211,233,123, 56,229,140, 88,197, 40, 53,243,
146, 32, 51, 68, 96,183,152,236, 26, 13,  8,  4, 77, 98,137, 68,152, 89, 55,129,
 42, 90, 41, 96, 38,247,126,136,149,151,143,172,  8, 47,174,115, 75,  7, 29,  3,
 69, 67,181, 41, 24,240, 17,201,245, 68,158,129, 76, 87, 81, 31, 19,146,155, 94,
 51,133, 70,205,200, 73,116,128,224, 38, 69, 80, 22, 43,  5, 44, 84,  9, 97,243,
248, 68,165,138,160,121,227,  3,164,101,119,243,159,234,241,113,113,209,143, 25,
245, 35,115,204, 75,225, 30, 36,174,  5, 28, 74, 31, 89,146, 74, 76,146,105,134,
 38,152,211, 56,236,240,164,  4,254, 13,154, 37, 43, 93,  1, 19,178, 72,126, 45,
 41,158, 35, 90, 71,131,232,251,167,222, 52,156,124, 83,192,209,  2,105,112,103,
 61, 40, 18, 67,211, 81,157, 10, 61,254,131,108,127, 37,220, 17,110, 23, 61,163,
211,154,232,144, 78,202, 97,211,  4,173,182,126,123,  1,101,170,148, 60,223, 45,
 36, 39, 16, 54,110, 92,115, 27, 48,227,242, 90, 98,105,146,106, 62,174,229,112,
163,171,109, 85, 74,165, 53,135, 14,103, 41,108,208,213, 11,173, 93,137,249,241,
 64, 56,240,235,215, 24,117,  1,157,198,164, 73,216,150,210,196, 90,240,135,208,
 64,168, 16,133,164,233, 39, 62,166,137, 29, 19,155, 46, 48,193,202,245,162,  7,
242,179,168, 29, 73,194,192, 58,110,154,229,117,151,200,165, 68,167,252, 61,210,
191, 99,162,190,163,110, 85,216,171,127, 93, 65,173, 40, 25, 55,239,183,211,179,
245, 34, 16,106,243,221, 93,154, 19, 37,  2,246,172,243,206, 35, 86,136, 34,217,
200,102,136, 10, 20,144,180, 75, 10, 28,162,206, 63, 17,  2,  1,126,227,154, 50,
167,119, 95,174,108,178,211,235, 66, 99,131,249,202, 71,111,194, 94,121, 60,191,
148,211, 25,130, 88,111,212, 57,153, 27, 85,147, 72, 71,202, 45,161,215, 41, 20,
188,129, 33, 21,112, 69,241,194,100, 29,202,102,185, 52, 17,206,104,  8,218,187,
210,133,154,175,154,135,196, 27,199,194,241, 65, 76,154,180,167,217,234, 53,164,
124,233,208,213,106,154,123, 17,112, 30, 67,204,128,135,199,  5, 80,219,237,100,
222,141, 52, 97, 19,112,110,226,136,227, 69,181,105, 13,237,237,133,230, 24,192,
240,167,154,134,219, 70,109,173,205, 63,221,207, 54,234,191,188,249,131, 36, 83,
 33, 52,241, 66,127,152, 37, 33,179,155, 15, 56, 72, 72,188, 23,243,214,139, 16,
 87,147, 60, 49, 77, 45,116, 89,230,150,  0, 11,145, 38,185,220, 70,157,208,105,
 45,188, 36, 16,148, 83, 10,165, 33,234,181,108, 33,174,148, 74,179,106, 36,130,
110,  5,118, 88,193,165,132, 86, 44, 26, 35,200,113,132,181,243, 20,113,137,218,
141, 53,213, 34, 22, 97, 69,245,162,210,189,234, 36, 75, 32,227, 71,157,208,162,
147, 65,  0,167,202,165,102,172, 17,108, 83, 11, 19,147,240, 92,253, 72, 67,238,
198, 86,179,113,216, 25,198, 14,214,140,223, 96,  4,102,  5,159,194,196, 56,247,
 98,168,127,178,104,107,242,185,  4,105, 64,154,128, 12, 11,234, 38,210,165,142,
250, 54, 78,162, 25,122,148,132,233,211, 68, 26, 62,103, 98,168, 18,234,212,107,
 53, 19,236,162, 79,203,246,140,102,154,159, 70,252, 86,163, 89,174, 36,  9,155,
162, 31, 55,241, 91, 70,  0,206, 66,217, 81,207,208, 75, 73,218,206,244,108, 52,
185, 94, 92, 50,213,108,169,178,148,190, 55,141,192,155,128,  8, 34,232,186, 92,
 69,138,255, 28,192, 54,245, 47, 99,208, 97, 27,209, 66, 85, 75,233,123,106, 10,
110, 94,115,  0, 98,137, 62,138, 97, 54,249,191,152, 36, 19,241,168,141, 26,232,
189, 93, 22,111, 32, 92,164, 34, 78,106,166,250,234,228, 71,165,140, 87,153,179,
158,133, 76,150, 81, 33,192,151,238,166,169,139,141,188, 20, 27,214,  0,222,232,
108, 66, 64,  3, 98,178,149, 58, 71,255, 95,208, 82,142,  7,239, 31,213, 67,165,
 28, 32,116, 13,188,101,243,104,146,204, 23,  9,146,217,189,255,110,228,229,189,
 40, 30, 67,248, 12, 30,232, 28, 28, 17,249, 30, 32,117, 98,134,251,128,  3,  4,
 36,164,  1,186, 88,124, 16, 39,176, 26,117,  3, 52, 90, 96,189,214,146,181,155,
218,218,157, 10,174,148, 49, 27,236, 26,214,103, 10, 29,134,100,201,  3, 71,212,
 15,250, 15,186, 59, 59,224,248,  0,  0,  1,  1,  1, 54,118,104, 53, 46, 95,207,
250, 73,151, 63,171,176,246, 97,214,202,120,242,153,124,158,211,173, 14, 99,178,
 59,220,248,118,122,130,  3,163,102, 68, 88,219,  7, 97,215, 62, 39,132, 55, 75,
108,246,131,197,  4, 68,123,199, 69,233,213,191,216,151,102,181, 95, 25,243,217,
224, 53, 86,116,211,238,202,170,235,226, 46, 35,112,119,123,109,147, 55,237,158,
 92,114,217,149, 39,163,195,243,208,241,112,120,216,200,241,203, 79,225,109,206,
 90,101,101, 85, 85,229,193, 94,123, 85,133,242, 13, 85,203,229, 34,187,102,111,
195,146, 46,193,208, 67, 25,155,182,123, 58,172, 26, 25, 32, 14, 19, 82,134, 46,
165,123,187, 39,116,208,173,251, 89,116,192,152,104,168,160,245,161,127, 96,115,
248, 86,105,249,135,133, 85, 18,184,148, 53, 12, 67,255, 66,235, 78,243,147, 94,
150,154,118,  8, 60,190, 40,221,189,243,142,102,215,161, 80,138,178,125, 75, 71,
112,138, 80, 41, 40,178,187,252, 50, 72, 57,234,156,209, 70, 51,133,131,181,122,
164, 22, 20,  1,229,119,191, 15, 53,239, 43,191,182,110, 90, 50, 66, 64,128,130,
  3,219, 37,118,115,234, 64,108, 90,167, 95,172,122,  9,187,207,234,140,193, 48,
  6,223,208,101,101,180,205,251,100, 38,205, 65, 20,117,222,111,153, 43, 84, 69,
 17,205, 23, 59,128,143, 53, 27, 67,179,193,134, 58, 28,101,236,254,126,158,127,
187, 25,159,104, 50, 83,230,  0, 20,175,251,159,202,110,149, 95,157,118,221,107,
 93,160,203, 37, 74,128,224,199,204, 33,219,231,140,153,140, 55,238, 27,218,225,
233, 90,165,183, 97, 94, 99, 68,124, 16,252,175, 92,245,123,105, 30,174,250,119,
103,100, 80, 29,142,142,111,112, 56, 87,231,204,128,117, 86, 29,198,144, 55,182,
148, 98,134,151,177,235,126,209,117, 12,135,175,107, 78,191,243,126,220,149, 81,
 32, 77,185,255,228,142, 74, 25,231,141, 32, 32,  1, 14, 50, 65,104, 93,192,220,
239,195,226, 86,126, 42,188, 24,133, 57,123,  5, 65,179,161,166,205, 65,  8,248,
 38, 31,206,  0, 59, 53,109,168, 46,145,164,145,207,130, 46,166,104, 71, 29, 14,
169, 88, 60,150,251, 86, 98,142,229,143,234, 14,254, 13, 29,191,252,246, 67,236,
128, 61, 76, 72,110,122,193, 55, 22,150,189,151, 29,183,125, 57,  7,152,139,141,
 50,161,213,225,206, 94,249, 61, 12,235,181,111,251,170,106,113,114, 89, 62,145,
217,171, 51,105, 41,165, 24,155, 50,180,220,196,201,160, 35, 79,194, 76, 84,226,
112, 65,129,129,245,209, 32,122,182,230, 54,220,118, 59,177, 29, 23, 96, 93,213,
181,154, 53,217, 62, 26, 88,164,  2,247,192,183, 26,238,160,112,226,127,228,  0,
104, 66,120, 67, 82,215,196,154, 89, 86,180,183, 42, 45, 35,231, 35, 76,218,122,
158,165,250,114, 31,254,104,219,187,248,210,102,190,104,168,117, 44,181, 59,161,
 86,179,123,227, 43,227,156, 38, 73,218, 72, 61, 77,210, 70,211,147,166, 37, 77,
107, 52,210, 19,118, 16, 38,107,211,185,155,114,159,131,253,128, 26, 82,195, 59,
 49,107, 52,237,112,168, 59, 77, 93,252, 70,232,217,237,189,124,101, 58,243,216,
243,120, 79,110,103, 50,158, 57,232,130,  3, 43, 81,208,110, 52,  1,107, 42,117,
 36,250,115,242, 18,155,101,163, 89,179,251,221, 39, 95,221, 55,116,116,238,151,
135,189, 74, 77,199,230,182,234,118,222,115, 46,151, 36, 11, 52,205,237, 37, 35,
157,119,131, 55,132, 92,205, 88,171, 48,236, 18, 10,  3, 82,210,214,224,252, 35,
 45,193, 42,189,191,105,211,109,177,116, 12, 16,166, 13,130,180,217,235,113, 62,
103,212,156,167,132,183, 61, 37,198,150, 41,177,161,229,134,  1,129, 64, 15,250,
  8,  2, 85, 51, 95, 29,206,220,134,230,206,141,227,220,  3,182, 27,119, 81,126,
  0,229, 51,137,189,206, 31,254, 78,176,102,239,207,105, 47,220, 93, 34,225,165,
 52,249, 46,169,198,214,197,113,159,101,170,195,238, 89,150, 73,152, 43,127,133,
 47,178,244,251,179, 41,213,244, 41,206,  2,149, 95, 91,232,255,110,186,117,103,
182,137,166,178, 94,152,251, 84, 78,207,148,210,250,244,178,178, 37,227, 25,157,
 82, 98,154,227,254,233,103,159, 79, 45,201, 70,250, 83,169,151,101,203,161,112,
240,229,254,165, 23, 80,206,165,130,118, 89, 50,  2, 16, 57, 10, 17, 70,165,119,
 38,179, 88, 80, 16,177,247, 25,101,146,122, 62, 30,173,186,232,177,193,139, 44,
189, 56,211, 57,123,165,122,170,197,  0, 52,249,255, 68,212,180, 76,155, 79,192,
109,234, 45,144,157,247,210, 64, 54,191, 71,113, 84,198,108,239,199,125, 92,190,
 44,  4,147,234,168,244, 90, 54,109,  2,  8,  0, 19,162,  0,  8, 12,138, 75,  4,
130,145, 56,145,197, 32,102, 31,196,224,  6,131, 76,199, 66, 79,130, 68,195,192,
148,128,192, 24, 16, 18,130, 15, 80,  0,135, 48, 56, 66,  1, 12,130,144, 12,197,
 64,208, 48, 43,173,  1, 70,160, 42,215,113,192, 63, 84,143, 73,137,235,112,166,
131,150, 96,246,225,113,227,182, 61, 26, 18,109, 54,192,115,106,161,206, 36,  2,
 35, 10, 37, 75, 30, 96,174,156,133,131,233, 88,240, 95,220,133,143,240,117, 21,
 27, 49,234,181,  4,154,202, 54, 78, 54,181,  9,238,132,103,242, 43,142,202,196,
106,213,255,150,140, 66, 48, 38,130, 82,109,136, 33, 83,185, 98,119,248,152,149,
 20, 24,202,236, 76, 37,108, 39, 10,101, 64, 20,156, 59, 29, 74,214,138,251, 44,
 90,239,236,184,245,134,236,247, 12, 97,201,185,196, 62,150,182,224, 64, 50,233,
135,103,240,211,124,192, 85, 55,208, 85, 50,247,104, 29,210,203,225,140,204,195,
219, 59, 69,123,123,183,104, 45,107, 86, 72, 80,202, 68,218,  0, 94, 38,228, 18,
155,252, 71, 35, 10,  6,  0,249, 30, 98,206,127, 33, 70, 51,  1, 36, 31, 83,210,
230,116,164,201,198, 16,156,142, 71, 74, 78,135,219, 11,108,215,168, 15, 34, 83,
103,219,160,193,131,150,113,248,213,191, 79, 39, 50,254, 42,136,107,249, 43, 89,
161,185, 71, 74,200,136, 13,244,197,251,  1,136,228, 38,224,159,184,181, 24, 97,
118,159, 58,127,153, 31,206,190,151,105,140,151,144,190,217, 51,155, 32,132, 14,
 59,132,196, 36, 24,164,140,105,170,215,137,150,186,185,132, 52,194, 68,176,196,
105,151,253,230,150, 67, 73,228,115,116,228,217, 10,228, 68,186,245,223,  5,113,
123, 51,222,100, 28, 71,129,210,108,156,192, 50, 25,  5,254,231,125,151,163,149,
212,217,109,178,247,144, 78,196, 19,225, 87,164,186,171,110, 41,248,234,121, 96,
164,171,131, 74,236,100,183,204,158, 50,113,142, 25,214,168,163, 61,217,107, 64,
154, 96,103, 80,124, 83, 38, 15,207,105,166, 20,194,223,200, 26, 78, 31,231, 68,
252,160,124,127,174,154, 42, 99,168,203,154, 97, 42,247,  1,170,104, 48,154,110,
 98,230, 62,116,126,131, 98,248,216, 93,201, 54,162, 78,210,171, 31,  5,102, 11,
 70,107,119, 59,  3, 82,201, 73, 39,114, 46,228, 15,195, 11,106,219,219, 70,172,
 38,231,210, 32, 93, 26,208, 51,169,211,231,157,138,205,120,194, 44, 93,178,209,
211,240, 70, 59, 59,209, 13, 96, 50, 43,242,223,201, 15,  8,250,167,176, 68,153,
245, 23, 74,175, 88,170, 26, 52,162, 19,247,  0, 72,155,226, 17, 44,151, 64,114,
109, 82,112,149, 64,217, 45, 85,141, 50,141,191,198,126, 86,228, 42,148,130, 24,
135,174,107, 30,102,213, 90, 30,179, 71,143,231, 34, 64,214, 60, 90,239,125,106,
 79,122,  1,215, 78,  0,183,238,239, 90,211,250, 41,140,103,197, 26,248,105, 11,
 75, 19,109,121, 86, 12,196, 60, 49,151,125, 17,235, 38,115, 71, 57, 46,182, 63,
 91, 80,201,170,224,147,214,194,245,172,126, 92,249,241,141,142, 77,171,139,127,
 55,203,211,206, 78, 96, 51,128,231,230,242,252,209, 34,252, 10,237,  1,229,107,
 65,195, 69,133,255,149, 61,227, 20,155,215,175,231,164, 33,253,101, 71, 34,193,
213,127,145, 16,139, 87,218,226, 66,231,226,202, 44,  2,236, 71, 93, 10, 88,221,
159,  8,169,113,  0,  8,211,129,197,  5,172,152,172,  5, 58,233, 61,233, 94, 98,
242,149,124,230,151,221,135,118,170,182,249,193, 80,175,159,  7, 91,129,223,  8,
 43,209, 79,138, 55,224,103, 99,187, 16,135,161, 55, 72,124,185, 48,223, 89,133,
 95,210, 96,137,111, 17,143,123,163,215,132,137,175,102, 66,234,122,134, 25, 53,
234, 58,214,132,244, 96,182,166,244, 12,249, 94,126,150, 41, 27, 37,103,249, 47,
149,103,  1,  6,155,166,202,192, 25,225,202, 41,113,117,202,188,178, 68,216,106,
124, 10,136,154,113,216, 20,107, 99, 28,105,158, 84, 44,127, 14,205,176,220,151,
 88, 55,137,149,171, 88, 64,194, 42, 45, 84, 61, 99,133,181, 85, 39,146, 31,132,
197,136,243,177, 30,242, 41,223,181,183,253,253,231, 24,  2, 81,219, 23,  1, 67,
140, 82, 33, 42, 73,180, 34,104,219, 45,107,157, 16,153,231,126,245,241, 68,195,
 50,193,207,194, 14, 34, 72,132, 47,  5, 61, 32,180, 12, 40,206, 56, 34, 46,155,
 72,128,161, 36,242,133,135,145,187, 83,180,195, 95, 57,157, 66,110, 59,157,182,
234, 85,217,107,236,  0, 49,216,194,196,177,110, 59, 27, 74, 80,144,137, 98,249,
209,129, 11, 94,212,228,124,251,174,115,248,235, 34,223,106,171, 80, 37,224, 64,
233, 77,213,240,148,172,209, 26,207, 47,250,203,209, 81,119,  0, 31,185,121,246,
152, 17, 52, 23,205,225, 29,152,162,111,162,194,153,200,168, 32, 88,102, 82,154,
202,216, 17,243,153,205,202,175,199,237,  6, 56,220,207,226,167, 62,189,208, 33,
132,107,  2, 51, 97,242,204, 82, 26,202,224,198,159,142,182, 11,233,214,  6,230,
223,233, 40,232,246, 69, 19,129,251,  3, 96, 20,113, 15,146,236,155,203, 71,235,
110,169, 53,122, 23, 11,187,199, 18, 12,129,136,199,116, 51,246,167,182, 75,240,
210,109,218, 21,237,144,221, 64, 22,223,206, 43,196, 57,156, 46, 29, 28,123,  8,
132,254,142,170,143,231,247,147, 16,  5, 44,189,120, 58, 14, 81,109, 73, 96, 43,
215, 45,241, 26, 48,149,229,225, 36,234, 71, 33, 35,103,146, 76,237, 31, 88,238,
116, 66, 80, 56,173, 33,191, 11, 82, 51, 12,242,100,156, 64, 40,199,103, 84, 13,
160, 12,138, 90, 61,179,155, 73,134,233, 51,238,252, 69, 13,102, 14,151, 94, 83,
121,192,160, 35, 65,174, 77,207,153,227,194,200, 41,167,113, 61,124, 78,  0,198,
133, 57, 73,112,169,102,159, 47,106, 48,100,235,254,215,139,176,174, 64,191, 57,
164,186, 52, 44,222,118,  0, 73,180,206,213,125,  6,203,176, 75, 98,127,175,209,
 75,193, 98,113,170,  6, 15,206,233,  1,123, 38, 19,253, 76, 38,226,189,157,207,
 42, 79,135,146,201, 47,189, 89, 42,167,132,128,227, 23, 70,143,252,240, 88,  0,
173, 77,247,174,247,221,167, 76,165, 41,247, 61,198,130,213, 70,110,151,178, 95,
191, 72,  0, 43,214,188,  3,224, 88,158,189, 90, 19, 88,  5,122,  5,185, 84,213,
 35, 33,175, 40, 40, 45,  4,146,153,221, 44, 73,242,121,251, 14,168,138,156,246,
151, 15, 58, 50,120, 57,118, 89,205,116,164,155,253,118, 92,  4,207,139,129, 36,
 55,106,236,246, 24, 26, 82,215,218, 65, 33,197,156,167,154, 64,124,  1,218,  8,
 14,116,189,161,253, 10, 66,230, 80, 31,  5, 11,113,120,211,231,237, 79, 72, 82,
 31,210, 54, 63, 14, 98,240, 16, 83,247,248, 72,108,244,168, 39,239,118, 54,130,
 48,149,117,134, 89,100, 16,112,114, 52, 69, 20,149,204,110, 94,117,241,166,  0,
 14,136,196,246, 65, 95,  9,155, 85,197, 27,  4,120, 44,244,136, 51, 77,103, 54,
100, 66,  6, 22,232, 39,254, 81, 40,213,163,250,246,120,234,210,148,117, 62,127,
139, 36,155,  5, 87,173,165,117, 72,228, 16, 51,105,229,107,215,203,200,174, 66,
 70,103, 27,222,215, 61, 78,205,156,171,109,145,203,246, 32,  4, 20,137,225,255,
120,142,141, 19, 96, 34, 67,127,121, 30,203, 66,177, 28,187,158,172, 76,220,200,
133, 17,187, 54, 19,131,142,215, 50,185,197,216, 24,223,117,102, 82, 36, 17,129,
 64, 37, 95,  8, 53,196, 26, 25, 13, 29, 24, 92, 48,126,158, 33, 94,242, 54, 34,
139,193, 69, 70,118,  4, 75, 56, 92, 68,223, 69,177,174,168,111, 81, 91,103,130,
252,138, 74, 93, 56,142, 48,124, 54,130, 93,  8,149,214, 94,208,  0,198,254,133,
135, 10, 28,148, 19,250, 43,152,242,111, 99,217,122,162,223,255, 36,236, 76,253,
 82,  5, 37, 31,144,  5,110,159, 45,127,113, 48,224,129,141, 34, 23, 43,229,191,
141, 24,157, 25,209,114, 64,159,196, 40, 73,189,161,228,110, 17,126, 52,138,181,
112, 43,166,122,171, 54,131,216,206,125,117,  6,244, 40,210,198, 65,175,106, 86,
216,181, 21, 51,103, 66,147,  3, 74,116,144,198,137, 76, 15,254, 16, 90, 73,178,
123,255,142,128, 38, 91,107, 87,141,159,103,  1,208,237, 53,162, 68, 20, 18, 90,
169,246, 80, 58,160,142,253,168,250, 43,136,171,121,242,184,161,238,251,156,209,
 47,104, 28,212, 83,238, 10,244,155, 52,223, 84,175,221, 83, 65,123,161, 32,190,
140,110, 91, 22,137,124,204,150,177,211, 98,100,141,142, 89,155, 28,184,196,248,
 26, 53, 63, 72, 77,152,113, 11,119,142, 40,153,193,245, 84,216,  8, 15,122,206,
 17,214,221, 52,111, 24,209,122, 82, 54, 16,164,200, 20,248,207, 90,  4, 25,200,
222,227,109, 59,236,235,184,226,170,233, 34,155, 72,131, 91,253, 10, 49, 68, 44,
 85,139,  7,132,161,172,159, 47, 83,174,112, 78,107, 34, 10,255, 35,181, 28,210,
148,147,154,206,166, 91, 93,246,155, 74,129,164,248, 90,232,185,183, 83, 29,134,
102,130, 30,105, 85, 79,198,  9, 89, 28,163,150,240,190, 16,224,188, 45, 35,214,
 32, 18,134,234,168, 81, 48,211,160,182,218,168, 66, 77, 14,222, 70,136, 20,137,
 67,  2,118, 43,129,189,240,114, 27,143,111,176, 88,112, 46, 79,153,237,224, 44,
174, 57, 45,165,215, 38,149,233, 86,174, 21,107,199,150, 64, 79,121, 49, 88,202,
234,152, 59,150, 33, 99,153,247, 38, 75,212,154,220, 72, 56, 49,183, 98,206,181,
164,184, 66, 55,  3,172,234,130,255,247,167,220,213, 45,171, 57, 28,178,198,217,
111,  1, 76,246,193, 70,226,203,243,209,236,102,104, 33,252, 39,194, 78, 62,193,
 48,170,  8,  0, 45, 36,138,170, 24,225, 88,218,173, 81, 52,172, 33,113,112, 83,
195,180,136,146,242, 80, 40,134,235,127,147, 66,225, 20,189, 63, 56,145,204,139,
 33, 47,133,126,  8,239, 88,167, 56,108,154, 94, 51, 99,100,220,127, 90, 17, 20,
  1, 29, 35,230, 94, 34,196, 79,214,224,189,  8, 31,193,177,138, 32, 34,237, 27,
 69,198,253,149, 34, 67,162,243,188,242,171, 13,212,148,132,169, 69, 80,222, 13,
 84,236,209, 67,214,185,123, 14,  3, 32,115,248,155, 92,255,158,219,163, 53, 54,
241, 93,114,186,185, 44,132,251,  8,211,100,173, 91, 29,231, 16, 31,204,220,145,
141, 99,229,229,178, 18, 29,132,210,131, 57,111, 49,138,  0, 46, 75, 26, 43, 26,
173,204,165,174,  7, 70,181, 37,113, 90,201,207, 56,113,220, 76,221,225, 50,147,
146,157, 97,195, 56, 85,109, 19,120,218,181,146,113,243,227,188, 66,205, 73,143,
 31,  7, 69,228,117,198, 29, 73,248,115, 58, 80, 11,148,111,191,  0, 47, 22, 40,
142, 96, 34, 34, 99,180, 21,157, 49,132, 67, 96,126, 28,166,124,197, 38,169,226,
209,148,213,181,221, 69, 46, 39, 55,217, 13,204,147, 52, 39,213,171, 99,205,173,
 96, 26, 12,169,164, 41, 64, 25,251, 24, 58,148, 92,170,166, 95, 19, 83, 76,164,
 50, 83,247, 33,239, 88, 30, 61,  0,176,192,160, 39,108, 11,180, 19, 10,219, 71,
117, 30,236, 62,159, 71,224,103,247, 61, 77,236, 88, 17, 68,185,184,141,247, 11,
206,199,231, 88,146, 43,249,227, 33,195,173,231,145,195,190,185, 21,248, 64, 11,
 85,150, 39, 60,169, 44, 88, 74, 93,164,255,172, 59,159, 66,194,207,  8, 81, 39,
 20,208,237,158,192,106,118, 76,102,148,241, 51,217, 57,192, 87, 35,134, 88,138,
 51,238, 74, 43, 79, 97,171, 82,129,132, 43, 70, 95,192,161,167,143,125, 89,138,
 49, 40, 11,215,196,  2,115,142,195, 75,  1, 59, 37,211,154,230, 76, 97,229, 90,
 59,110,114, 79,225, 71, 67,125,197, 85, 50,147,106,  9, 94,156,193, 16,223, 55,
 54,168,232,154,109, 22,254,  8,187,106,239,  0,121,  8, 10,218, 42, 49,174,168,
 44, 23,196, 54,150,  1, 81, 52, 53, 45, 21,125, 24, 49, 70, 72, 25,177,  6, 48,
173,177,103,190, 39,192, 13, 36, 43, 39,219,191, 63,239,248,199, 27, 87, 23,197,
 70,122,252,228, 33, 99, 97, 38,135, 44,138,  2, 37,194,177,191,108,209, 89,228,
 23, 78,153,203,150,  5,105, 26, 67,191,203, 33,181,165, 23,235,232, 36,188,208,
151, 50,139, 20,251,184,175, 29,179,201,130, 15, 56, 89, 64, 66, 85,185,182,253,
 39,178, 81,152, 15,249,137,193,149, 56,119, 70, 74, 24,105, 67,141,168, 19,134,
115,197,  9, 39,172,182, 59,178,  9,151,125,185,102,219, 21,176,160,146, 38,138,
 53,182,225,129,141,126, 77,104,240,144,140,119, 42,204, 78,198,187,173,  2,106,
186, 29, 55,130,244,207, 48, 62,170,202,161, 39,128,245,240,114, 69, 69,  0, 37,
121,246,202,215,164,169,167,182,212, 29, 99,240, 53, 85, 81,221, 23,111,223, 68,
 42, 37, 54,251, 84, 84, 57,198,187,170,  1, 31,224, 45,  7,216,151,176,252, 91,
 84,153,203,137, 43, 20,106,235,  4,120,234,201, 55,210,194,107, 14,198, 47,207,
 68, 80,216,236, 78,226,217,178,114, 91,194,190, 48,177,202,198, 90,  9,248,158,
254,102,  8,150,180,148, 49, 18,195, 95,133,136, 78,180,223,247, 98,140, 79, 22,
102, 83, 78,152,197, 74, 20,149, 37,108, 68, 88,224, 22,108,110,175,220,  4,219,
204,237,113, 40,210,147,156,163,213, 68, 85, 82,166, 12,139,186, 48,149,127,239,
 33,209,199, 83, 66, 96, 10, 58,152, 72,231, 92,162, 64, 29, 68,107, 77, 71,237,
231,171,152,164, 37, 37,218,227,232,127, 12,134,241,219,251,160, 79, 96,142,112,
173,217,  6, 16, 53,250,233,168, 27,212, 12,113,229,176,162, 39, 64,226,127,249,
  9,195, 33, 35,175, 15, 61,156, 64,253,125, 51,197, 31,  0,171,215, 33,139, 82,
142, 94, 28, 79, 68, 49, 86, 47, 54,106, 15, 80,146, 14, 22,208,129, 43,127,212,
167,172, 20,151, 58, 43,192,132,106,112, 15,109, 98, 77,125, 93,  7,165, 27, 31,
210,  1, 43,193, 30,136,171, 33,131,160,153,162,248,180,147,193,227, 43, 61,148,
 75, 17,224,168,218, 34,175,142, 59,118,204, 32, 34,244,245,171,228,118, 33, 41,
180, 12, 84, 82,134, 56,145,  8,100,180, 60, 91, 96,232,197,174,222, 55,240, 91,
 34,250,183,194,164, 86,221, 54,180, 98,  7, 38, 87, 86,254,161,166,131,232,168,
110, 32, 97,129,201,204, 52,223, 58, 88,203,130,116,167, 38, 75,139,241,176,240,
 31, 39,125, 88,185,202,146,221, 17,150, 11,105,213,209,254, 80,216,157,136,211,
227, 15,136,191, 85,218, 13,162, 58,181, 81,240, 42,181,125, 68, 43,201,153, 88,
114,167,240, 67,121,170,208,151,118, 77,156, 17, 78,157, 77,194,116, 20,168,197,
 62, 13,214,223, 43,206, 27,208,158, 37,163, 48, 53, 17,  4, 10,133, 77,121,138,
241,199,112,206, 28,241,171, 77,223,137, 60, 32,107,131,176, 89, 55, 85, 24, 73,
 20, 70,173,168,122,250,207,182,131, 96, 17,160,242,185,185,171, 13,150,190,159,
 35,150,  7,153,244,225,204, 55, 50,134, 24,113, 44, 75,164, 81,113,240, 80,217,
175, 46,  1,177,162,146, 73, 42,114, 38,205, 43,138, 75,231,228, 94, 18, 38, 88,
120,109, 70,  1, 97,179,212,181, 92,124,142,127,134, 39,106,238, 24,126, 63,120,
108, 63, 47,193,115, 47,  1,159,159,206,145,207, 57, 73,216, 73, 14,128,168, 16,
 69,204,124,123,105, 10,130,210,183,230,130,199,215,230,138, 86,213,198, 76, 53,
152, 73, 15,213, 92,  2,155,159,173,175,231,197,225,184,158, 91, 26,177, 78, 24,
185, 97, 67, 74,102,173,110,250,187,200, 19, 35, 81,200, 78,149, 39,219, 91,143,
248,226, 96,183, 43,192, 53,181,196, 20,195,  2, 53,111,205, 72,164, 74,170, 13,
156,230,188, 16,211,244,144, 40,111,  4,180, 62, 34,131, 77,130, 31,220,103, 23,
 98,162,221, 98,219, 12,103, 94, 68, 10, 40,174, 84,226,171,225,163,214, 99, 50,
200,156, 51,230,202,  8,145,140, 62,120,237,178,209,225, 68,192,193,164,174, 94,
166,247,  7, 68,250,142,192,151,  0, 85,237,200,215,200,192,198, 19,107, 52,181,
 40, 64,171,170,120,178,184,192,247, 52,152,206, 52, 87, 82, 69, 98,209,202,102,
 59, 40,104,101,237,255,  2, 84,251,252,202,140,125, 25, 41,208,118,205, 24, 49,
218,166,143, 18,173,  7,223, 16,113,241,247,122, 26,132, 25,255, 82,123,167,165,
 94, 85, 31, 93, 75, 26,  2, 39,190, 30,147,209,224,113,248,100, 90,117, 50,149,
 71,  7, 16, 96,125,157,108,217,245,102,216,190,172,142, 24, 79,154,168, 88,227,
101, 46, 47,103, 97,120,135, 29, 23,246, 49, 64, 74,104,244, 64,132,223,250,178,
124,209, 73,222,148,106,135, 98, 30,103,212,107, 20,136,250,101, 79,163, 48, 74,
 27,249,170,198, 10, 91,204, 68,218,208,135, 80,212,226, 66, 44, 46,109,209,196,
127,207,152,218, 39, 74, 98, 39, 43, 75, 12,163,164,133, 41,211,237,162, 99,182,
 86,188, 88, 12, 90,128, 84, 70, 39, 57, 52, 13,172,202,185, 10,162,198, 58,173,
243,  0,187, 94,238,253,217,147, 25,134,223, 21, 72, 83,136, 93,127,152,159,198,
101, 91,235,136, 52,124, 85, 89,183,228, 35,145, 66,137,153, 44,167,164,157,138,
 74, 74,101, 34,200, 34, 40,114, 84,198, 47,171, 47,163,226,144, 40, 28, 31,  6,
 78,164,112,179,136,  1,193, 21, 19,  1, 14, 77,116, 50,249,166,245, 14, 55,115,
209,107, 49,137,192,136,206,113, 40, 87, 15, 31,104, 90,128,183, 79,152,230,149,
210,  6,210, 13, 71,165, 16,237,104,199, 13,195, 38, 43,248, 44,185,166,252, 44,
214,225,  7, 16, 54, 89,143, 67,  4,120,166,186,  5,234, 44,211,  9,153,157, 16,
 27, 66, 93,181, 65, 28, 99, 88,181,128,184,173, 69,192, 23,  0, 89,149, 24, 76,
145,185,239,133, 66, 19,196,160, 26,165,227, 18,190,139, 69, 21, 88,131, 90, 51,
109,236,163, 46,112,111,133, 22,186,246,194,249, 45,201, 36,129, 98, 22,186,250,
 16, 47, 99,159,172, 35,244,101,223,193,202, 58, 81, 33,222, 32,116,108, 18,203,
 62,102, 64,104,210, 69, 27, 56, 34,163,198, 72,159,151,194,198, 62, 15,190, 66,
 69,136, 63, 33, 55,  7,213,157, 98,122, 33,161, 34,122,195, 57, 20,125,215, 23,
124,207,209, 33,209, 70,223,214, 70, 88,209,255,132,134, 83, 36, 38,135, 49,210,
 72,182, 72, 71, 56,243, 68, 23,172, 33,141,135, 62, 34,144,213, 58, 68,122, 67,
 41, 92,171,163,198, 93, 48,120, 32, 65, 83,134,142,184, 22,  4, 78, 93,251,193,
147,240,217,166,144,188, 15, 33, 69,  7,190, 77,139, 12,133,104,193, 42, 38, 50,
212,116, 72,120, 66, 57,127,197, 46,227,152,241,233,125, 61,  6,128,  7, 36, 36,
  4, 34, 27,156,157,132, 17, 66,127,232, 11,198, 18,181,230,184,132, 20, 82,235,
138,206, 23, 79,248, 75, 21,170, 50, 44, 68, 74, 91, 94, 91,125, 68,199,219, 85,
 27, 12, 48,243,165, 31,213,231,130, 50, 81,221, 83, 14,248,203,113,  8,105,193,
247,213, 65,176,  2,228,178, 48,217,131,198,201, 27, 16,  8,145, 55, 98,155,135,
 83, 71,209, 32, 57, 32,237, 26,109, 43,129, 60, 76, 41, 12, 56,  7, 23, 40,115,
223, 37, 15,200,155,226, 15,211,206,154,233,178,224,176,223,227, 87, 44, 68, 26,
209,  7,191, 57, 28, 39,185,178, 20,131,112,189,  3, 12, 67, 33,236, 62,  6,167,
 99,168,145, 16, 57, 80,219,134,106,141, 78, 15, 21,244,101,241, 30,248,190,156,
 55, 78,181,  1,159,233,198,180, 85, 33,142,168,137, 71, 18, 92,129, 25, 28, 39,
161,112, 67, 72,160,157,154, 12,119,249, 81,244,195,160, 29,250, 94,120, 28, 55,
 40,111, 70,198,255,161, 65,135, 96,188,227,253,153, 69,213, 88, 24,102, 28,158,
252,108,179,  2,215, 62, 69, 58,130, 95,254,206,246,169,234,233,156,102, 17, 34,
192,143, 84,158,229, 29, 22,136, 71, 83,142, 70,113,177, 76,162,152,239,179,248,
180, 64,237,147,216,101,222,226,192,150,180, 47,210,188,106,184, 46,155,143,203,
 67,208, 22, 80, 74, 90,233, 80, 86,212, 28, 93, 87, 33,137,141,212,191,  3,107,
186, 44,206, 39,155,134,162, 76,204,250, 67, 84,218, 31,174,232,133, 25,169,106,
119, 90,229,225,104,164,196,136,177, 66, 17, 81, 98,170,137, 72, 89, 22, 98, 83,
108, 86, 32,244,155, 37,232,168, 85, 17,101,192, 11,178,196,  6, 64,136,243, 33,
106, 40,132,122, 35, 22, 84, 79,161,148,195, 50,140,131,  0,252,190,160,  2,217,
114,128, 29, 53,170, 63,  6,  1, 71,123,135,146,157,168, 89, 22, 59,136, 82,105,
 16, 56, 81,180, 37, 77,232,112,248,121,114, 60,148,255,128,128,129, 45,228, 30,
182, 64,170, 20, 30, 20,223,238,252,234,133, 39,173, 76,  1,165, 15, 52,125,236,
182,  6, 98,154,210,197, 60,164,175, 32,122, 50, 72,122,179,223, 20,232, 40, 97,
 84,217,105,170,194, 65,159,236, 89, 25,221,107, 25, 86,212,248, 92,155, 85,173,
173,110,127, 53,218, 30, 80,116, 27, 95, 33,208, 87,251, 22, 46,219,140,104,181,
 58, 81, 62,192,160,183,209,224,168,195,123,182, 56,128, 71, 12, 82, 13,174,165,
 49, 32, 28, 59,198, 42,  4,252,198, 88, 58,157, 80,202,223,179,217,137,106, 52,
 76, 34, 45,228,142,106, 79,204,106,122,144,124, 64, 38, 33,160, 77,255,151,201,
187,222,219, 66,104,223,206,192, 23,245,106,198,105, 94, 85, 59,108, 49, 97, 12,
217,227,185, 73, 26, 78,204,169,177,191,119,138, 86,166,235,238, 16, 78,223, 64,
127,155, 28,119,223, 91,102,  7,168, 55, 22, 10,142,101, 99,240,126,114, 36, 68,
158, 45,139,116,123,115,179,218, 56, 37, 48,202,123, 24,150,161,224,237,219,124,
 85,  2,187,129, 61,164,168,200,181,117, 83, 14, 79,103,176, 77,117,238,164,220,
161, 55, 69,216, 67, 28, 33,180, 39,239,187, 62,114,211,178, 96, 97,132,192,217,
 10,230, 37,150,137, 53, 13,117,255, 83, 82, 53, 43,141,204, 41,160,112,195,190,
173,203, 24, 24,198, 48, 29,177, 74, 55, 11, 93, 28,157, 50,  9, 24, 81,203, 38,
 93, 59,115, 85,119,127,179, 65,156,  4, 95, 17,133,201,114,191,180,173, 51,177,
222,196,126,168,227,170, 67,  7,188,146, 46,176, 23, 45, 52, 68,212,234, 38,118,
250,104,252,247, 53,110,136, 51, 38, 99,202, 29,228,219, 31, 86,159,232, 77,112,
 23,148,146, 74,109,  6, 92, 61, 30,178, 27,  3,229, 45,233,203, 13, 70,161,145,
 93,121, 84,108, 22, 72, 84, 85, 89,204, 11,124, 10,113,169,241,142,109,201,171,
 34, 88,142,178,123,149, 19,  3,179,229,201,205,209,190, 65, 29, 55, 22, 39, 43,
 94,128, 92,194, 30,205,223,177,111, 96, 31, 94,165, 81,161,254, 51,111,116,183,
164,201,  9,221,237, 84,  6, 88,114,159,127,188, 59,232,229, 50,105,239, 78, 98,
133,122, 71,254, 36,116,126,219, 53,138, 69,193,106, 41,170,202, 60, 74,132, 98,
 58,210,249,185,152, 83,205,181,103,205,105, 50,160,126,158,155,121,127,178, 46,
  2, 81,132,129,219,134, 11, 37,226,211,211,221,240,207, 65,246, 33,145, 34,  4,
171, 74,184,227,130, 56,122,251,200, 27,242, 68, 91,122, 86, 40,139,195,107,180,
 31,161,169,232,157,130,187, 12, 27, 15, 18,224,102,117, 88,  8, 11,204,104,235,
 89,151, 18,156, 65, 16, 52, 60,153, 13,159, 61, 19, 39,234, 43,197,108,146,122,
 54, 89, 87,  2,163, 10,119, 66, 29,151,  2,183, 83,251,138,123,234, 38,143,169,
 93,145, 82,113,182,  8,116, 11,234,110, 22,208,167, 62, 16,245,213, 10, 64,111,
140,186, 91, 97,194,242,200, 17, 61,179,223,242, 80,227, 83,145,124, 70,135,  9,
222, 58,249, 77,187, 31, 27,  5,  6,125,127, 94,252,199, 61,168,230, 76,218,252,
 70, 44,197,180, 29, 84,154, 83, 40,147,101, 36,204, 33,192, 13,189, 56,  6, 36,
214, 67,177,213, 81,167, 56,186,114,161,178, 80, 67,161, 72,161,146,190,129,238,
105,189, 15,226,254, 13,157, 34,174, 27,118,245,192,102, 28,171, 38,230, 98,187,
237,158,  9,175, 78,191,151,141, 98,247, 57, 21, 56, 70,100,119,110,180, 70,161,
 86,226,118, 58, 85,  5,168, 55,179, 20,186,154,224,241,140,151,119,133,186, 46,
254,137, 57, 42,160,191,121,199,200,104,138,233, 98,170, 85,244,220,102,123, 53,
 81,159, 64, 48,117,222, 53,145, 45,221,188,117,211,107,  7, 42, 14,185, 71,150,
 22,221,176,200,146,225,178, 83,133,189,234,248,  0, 17, 90, 66,240,126,169, 85,
233,  6,  4,  7,168,120,220, 52,132,  3, 74, 16,213,129,101,191,166,220,174, 51,
252,194, 89,219,182,146, 99, 57,176,104,188,167, 98, 85, 47, 97, 23,159,134,145,
115, 23, 50,131,217,255, 36, 65,199,103,169,234,145, 35, 36, 19,251,104, 50,229,
 94, 64,120, 27,112, 34, 21,154,131,  1, 90,117,112, 14,100,200,184, 81, 23,184,
194, 11,113,178,253,117,223, 91,200,196,106, 85,240,168, 33,232, 22, 91,143, 58,
143,236,110,158,103,200,210,  2,114,171,240,202,213,228,236,153, 16,  8, 80,251,
134,177,176,185,240,250,211, 41,238,238,127, 47,201,136, 53, 59,244,154,169,137,
 32, 30, 91, 57,103, 81,109,216, 56,246,104,140, 60,207, 93, 15,151, 62,196, 88,
107,223,208,141,151,181, 68,102, 70,116, 18,237, 81, 30,163,153,197,217, 31,188,
161,217,108,122,158,103,139, 74,156,149,158,131, 68, 79, 26,115, 52,150,203,183,
 34,212,131,  5,108,107, 16,186,187, 42, 35, 52, 70,143, 95,151, 65,212, 73,217,
225,223, 89,153, 60, 98, 56, 34, 21,114,194,212,163,  9,133, 74, 45,171, 21,142,
210,145, 82, 23,114, 69, 25,124,251,121,235, 20, 84,209,231, 79, 33,250,230, 20,
 10,190, 16, 59,252,177,205,164,187, 15,245,139,250,167, 59,226,255, 99,114,177,
 97,206,206,146,146,109,240, 69,245,118,192, 59,227,184,175,103,  0, 24,123,160,
192,139,215,255,252, 19, 88,155,112,192, 57, 74,158, 33,229,212, 83,112, 43, 47,
146,202,199,199, 66, 37,115, 20,148,186,  8,122,130, 44, 67, 21,174,187,230,118,
189,159, 51,121, 59, 58,188, 99,199, 70,138,153,252,  4, 68,116,255, 14,181,133,
 69,121, 98, 44,128,129, 41, 20,188,209,  7,150, 22, 77, 45, 11, 71,211,106,120,
123,209,145,  5,114,236,103, 50,209, 36, 91,188,  7, 56,132, 39,250,110,118,230,
251, 43,188,251,153,200, 86, 88, 31,150, 24,129, 30, 21,245,217, 11,204,160,231,
 31,255,210,124,130,120, 50,246,238,175,227, 66,168,146,127,132, 45,166, 65,176,
 21, 87, 19,255,189,183, 40,127,112,166, 20,117, 20,132, 69,234,163,173,152, 49,
119, 28,252,  7,  5,193, 87, 39,117, 53, 22,118, 69,148, 69,225,252,120, 32,243,
 82, 44,210,235, 26,116,101, 92,164,246,108, 33,180,189,  7,198,126, 79, 92, 11,
 30, 71,177, 67,169,249,193,109, 13,129, 17,155,176,130, 43, 36,131, 60,176,168,
 29, 95,183, 56,254,251,  0,  9,224,160,183,191,173,127,  5,232, 42,248, 29, 30,
181,237, 68,238,107, 23,198,166,213,216,159,103,130,167,216, 70,151,131, 55,238,
 64,109,255, 31,248,252,101,233,231,208, 33,188,141,198,220,133,126, 58, 76,213,
131, 98,181,246,244,138,114, 87,107,147, 40,254, 70,206, 59,216,120,132,246, 83,
 35,203,123,178, 76,128, 89,194, 48,180,167,244,151, 59, 12,127,  5,  6,128,129,
 35, 76, 27,224,  9,237, 54, 85, 64,109, 76,210, 38,118, 92,252, 12,112, 66, 39,
 53,228,124, 54, 43, 98, 29,103,187,112, 98, 78, 20, 35, 85, 99, 84, 85,106,221,
103,153,234,132, 38, 87,163,220,144, 17,137, 17,  4, 27,152,190, 94,186, 67,199,
156, 33,124,  7,250,201, 57,119,100,156, 98,214, 85,148,143, 82, 77, 81,122,101,
143,128,223,147,173, 52, 23,255,144,237,180,128,226,223, 97,185,199, 17,  4, 13,
196,254, 87,109, 44, 11,204,231, 35, 45, 86,209,144,123, 19, 38,162, 10, 12,  5,
130,191,247, 98,234, 15,139,207,161, 59,163, 99, 50,148, 72,  7,114,167,111,227,
 82,183,108,139, 45,144,182,117, 85,137,185,165, 16,192,233, 34,194,141,220,180,
203, 75,151,135, 34,  8,106,153,145,191,217,132,121,255,190,160,154,168, 42,193,
109,219,216,146, 96,242,161, 67, 92,120,  6, 14, 38, 84,159, 46, 89,184, 34,232,
171,180, 88,134,  7,128,100,174,105, 48,157,150,233,151, 92,135,151,248,125,171,
118, 76, 39,180, 67, 74,192,245,181,226,151,  0, 16, 21,176,207,237, 41, 72,198,
182,  4,229, 57, 54, 27, 17,171, 48,191,  5,244, 53,213,184,189,214, 36,136,156,
132,238,101,110,  1, 82, 21, 89, 71,253,129,222, 20, 94, 42,108,158,185,200, 49,
 56, 97,226,191,161, 13,208,252, 72,225, 98,217, 11,229, 40, 96,112,168,231,241,
253,161, 55,148,120,124,180, 18,  8,197,246,115,160, 84, 76, 30,187,204, 34,253,
132,214,122, 17,174,227,116,179,113,107, 14, 47,228, 77, 11,  0,147, 88,250, 77,
  2,136, 29,255, 87, 42,112, 49,248, 17,195, 16, 85,143,242,167,147,228,194,187,
 29,  4, 76, 11,223,  7,167,181,162, 60, 25,  0, 59, 29,231,217,101,135, 52,179,
232,195, 75, 52,129,254, 65, 12, 86, 29, 97,159,105, 20,174,  2,255,237, 58, 86,
116,169,224,228, 13, 75,138, 74,211, 36,111,121,179,107,254, 63, 32,200,241, 51,
138,181,213, 55, 50,230,  8,  1,160, 26,159, 43, 90,158, 57,128,215,108, 38,126,
 57, 74,123,252,197, 50, 87,162,158,192,185,225,195,246, 27, 83,125, 84, 15,132,
209,134, 16,138,110,165,211, 16, 26,241, 61, 94,244, 43,112, 14, 12, 37, 52,235,
 41,165, 26,213,  6,127,129,113, 39,162,122,196, 77,159,249,158,233, 11,178, 23,
  9, 91,154, 48,153,199,113,228, 33,176,198, 58,141,223,109,191, 84,196, 19,135,
119, 75, 12, 45,139,143,224,210,185,149, 88,103,  6,186,  1,225,171,167, 85,255,
137,158, 75,155, 53, 49, 43,212,169,158,140, 20, 82,112,201,139, 88, 20, 92,111,
161,196,  0,114, 92,207,232,133, 71, 44,198, 50,234,141,193,129,104,202,102, 11,
 80, 23,130, 39, 65,197, 98,  1,104, 35, 68, 93, 52,186,211,228, 97,110, 52,160,
185,172, 50,124, 88,156, 60,191, 49, 88,186,100,252, 82,204,105, 89,203, 38, 12,
199, 48,143,187,198,244,159,243,228,141, 74, 18, 59, 55,  9,247,131, 21,185, 29,
 99,242,  0, 17,  6, 12,243,244,124,170,189,119,129,163, 76,138,226, 32,227,183,
135,185,221, 21,148,182, 95,228,189,118, 83,242, 93,183,223, 88,241, 21, 14, 59,
184,129,219,  2,151, 72,250, 92, 30,135,174,199, 36, 32,169,199,209, 86, 69, 57,
212,245,245,133, 84,247,239, 96,200,194, 73,123, 20, 33,183, 90,182,211,164, 89,
 34, 39,137,175,223, 16, 46,125,130, 65,132,171,240,149,179, 11,132,248,113,236,
123, 72, 32,175,  5, 16, 45, 95,196,137,213, 20,154, 10, 98,110,161, 98, 51,228,
245, 25,119,224,148, 81, 70,181,188,190, 97,188, 34,  2,179,144,121,229,170, 81,
 85,247,248, 80, 41,111,211,155,101,157,193,204, 86,  0, 35,241, 55,193,127,249,
132,128, 36,124, 25, 96,187,120, 28, 99, 20, 52,175, 93, 37,233, 62, 27,108,191,
 45, 36,223, 75,165,197,142, 50, 45,185,143,207,238,208, 87,  1,123, 59,157, 78,
 34,113,238,148, 10,153,  8,172, 95, 45,207,240,222, 81,229, 83,119,178,224,135,
141,211, 19, 95,211, 70,100, 94, 43,166,162,234, 10,107, 75,154,199, 37, 63,213,
 51,248, 43,185,180, 12,160,  8, 78,181, 35,151,123, 79,166,157,135,100, 40, 54,
184,173, 45,161,149,223,165, 31,118,191,124,170,193,226, 74, 42,155,186,130,222,
228,192, 61, 82, 35, 87, 22,243,240,249, 64,188,165,133, 68, 87, 19,129,161,201,
242, 65, 56,132,142, 16,127, 96, 16, 53,215,112,241, 74,196,194, 88,212,174,173,
 26, 44,171,  2, 24,137,129,174,147,141,107,134, 75,197,175,  1,114,253,252, 89,
108,194, 38, 89,213, 34, 75, 38,132,  4,158,165, 61, 82,140,144,201,113,  9,170,
 83,131,121,218,182,183, 42,168, 31,168,194, 85, 83,112,240, 73,147,139,148, 57,
 82,253,133,122, 76,188, 97, 14,104,119,236,153, 20,132,189,188, 15,241,236,149,
 92, 23,  3,236, 64,211,251,122,101, 51, 50, 94, 94,214,144,119,198,203,216, 82,
240,  6,144, 80, 41, 44,100,168,166, 39,159,  2,147,154,216, 50, 48,135,165,164,
 26, 20,255,137, 48,110,105,128, 48,169,191, 96,231, 25, 18,230,240,157, 79, 16,
  3,217, 78,241,  9,187,  9,178,167,236,226, 41,126,217, 52,105,  0,157,236,138,
 55, 67, 48, 95, 66, 94,198,126, 99,229, 73,152,101,197,194,192,  2, 26, 72, 76,
220,245,227, 49,240,155,157,154, 51,181,127, 88,240,119,102, 50,243,251, 64,101,
199,  1, 65,182, 86,193,192, 87, 80,241, 35,150,152, 30, 80,126, 84,186, 82, 13,
113,170,118,103,231,221,124, 69,107,237,173, 48, 78,241,196, 66,250, 31,105,193,
176,247, 16,241,165, 44,161, 95,143,143, 41,148, 72, 91, 34, 25,204,246, 32,100,
195, 72, 83, 28,153, 80,116,183, 77,133, 43, 87,229,232,192,235,107,206,128,244,
135,237, 12, 96,145,231, 25, 44,220, 80,246, 42, 73, 28,139,243, 25,136,216, 20,
 53,130,192,215,132, 69,185,194,121, 51,163, 12,152,117, 32,145,225, 68,226,186,
 84,100, 86,107, 99,  7, 40,  4,239,217, 65,  5,205,213,245, 84,225,237,173, 72,
 55,212,219, 61,123, 22, 86,170, 20, 59,221, 13,217, 87,125,132,155, 28,143,230,
 73, 21, 78,157, 52, 88,177,  8,218,182,  7,141,252,126, 17,  7, 52, 66, 89,208,
198, 71, 17,195,163,138,101,147,106, 68,  5,149, 24, 54, 65, 54, 65, 65,173,152,
195, 63,162,232,227,  0,136, 81,161, 59,240,105, 47, 41,  7,131,229, 32,181,129,
 42,206,205, 89,223, 73, 97,102,  3,141, 42, 54,188,146, 69,182,251,178,161,206,
129, 80, 51,202,206, 31,184,183,253, 77,110,214,217, 33,144,250,162,180, 17,176,
101,209,147, 59,172, 30,202,131,135,188, 15,124,151,241,246, 21, 51,160, 19,110,
 98, 27,179,182,240,153,183, 25,176,153,100, 53,161,196,180, 35,165, 48,131, 60,
237, 37,106,164,149, 33, 42, 12, 60,243,103, 22, 26, 10,156, 27,190, 80,249,161,
199,250, 49, 83,103,238,179,173,227,188,129, 14,217, 88, 56,250,205,245, 31,  4,
 55,120,150,  4,  7,138,222, 61,161,160,102, 69,212, 22,167,174,142, 38,180,210,
253, 50, 84,188,  4,133,250, 34,158, 19, 49,221,147,183,  1, 27,162,161, 94,236,
 33,184,134, 14, 40,154,244,165, 80,117,207,101,245,136,  6,113,237, 52,171,245,
 58, 49,162,215,231, 99,200, 61, 86,238,232,154, 61,129,163,126,234, 28, 14,148,
128,222, 54,214,238, 36, 12,124,223,  1, 94,  7,186, 18, 59,183,226,200, 32,179,
106,202,146,241,165,241, 79,170,165, 31,173,252, 56, 65,234, 43,200,163,139,228,
164,187,223, 33,229,223,238, 79,  4, 33,161, 92,191,167, 43, 25, 74,184,139, 56,
121, 69, 92, 38,141,215,227,166,105,139, 74, 52,178,178,134,103, 15,225,142,159,
  8,109,152, 93,234, 27,175,144,  8,214,151, 19, 55, 22,215, 25,221,172, 63, 22,
142, 81, 75,192,163,208,132,123, 25, 56,146,132,139,179,129,132, 77,213,130, 38,
 40, 31, 89,103,211,229,205,223,  8,171, 88,220,196, 19,156, 19,197, 44, 11,128,
156,161,184, 88, 46,211,159, 32,248,189, 80,110,245,148,231, 58,119,204, 51,221,
 96,183,155,239, 78, 57, 25,135, 26,  2,111,118, 14,239,  5, 52,163,252, 11,129,
 18,198,152, 97,220,213,227, 92,130,182,147, 47, 72,203,185,123,  6,152,135, 37,
140,194,200,117,176, 60,201,122,197, 25,199,127,136,208,225,238, 88,198, 38,105,
169, 83, 22,175, 44,207, 24,130,130,207,198,  4,  6,193, 88, 25,215,137, 87,168,
 32,205,  2,101, 97, 55,166,184,166, 20, 37, 13,237, 31, 47,246, 66,208, 87, 67,
248, 73, 87,254,189,254, 32,194,107, 43,172,123,144,133,138,  8,  6, 51,122,215,
170,133, 78,181,247,  2, 23, 70, 88, 85,181, 23,111,158,114,141, 36, 17, 15,175,
132,206, 38, 82, 46, 35, 79,173, 78, 82,204, 41,162,198,  1,170,129, 21, 97,194,
 68, 25,  6, 47, 76, 46, 89, 13, 32,233, 18,200, 25, 77,255,134, 63, 90,192,129,
253, 40,141, 29,130,196, 34,162,255,117,127,167, 76, 20,234,249,213,110,143,  1,
205,229,124,161,175,  0, 51,162,210,130,133,220,117, 22, 98,251,232,114, 64, 94,
198,156, 93,176,  8,147, 70,108,236,231,101, 67, 58,  7,152,229,227,147,130,208,
 23,192, 34, 48,229, 49, 37,105,223, 40,247,130,  5, 16,130,104,126,193, 62, 99,
153,193, 77,174,233, 61,219,181,124,142,201,128,167,196,246,121,191,154, 73, 48,
229, 13,246,246, 72,194, 89,235, 90,164,131,102,162,207, 22, 20,204,154, 24,233,
220,205, 37,101,102, 43, 67,138,184,220, 52,121,236,213,130,  8,139, 22,253,231,
 68, 94, 58,118, 99,  7,135,157,208,189,176,189, 13,255,188,113,152,214,237, 28,
 86, 78,179,141,198,111, 81, 55,196,130, 46,209,151,197,172,169, 94, 47, 74,123,
 18,204,190, 49,123,  8,223, 34, 96, 32,118, 11, 39, 65, 55,186,196,153,191, 55,
177, 66,134,226, 16,163,100,  6,130,200,184,204,137,163, 59, 56, 80,244,209,237,
147,123,114,238,119, 51, 72, 85, 23,143,132,187,240,195,184,135,113, 60, 94,209,
239, 98,232,164,238,197,135,194,243,143,191,181,170,  3, 22, 32,187, 78,148,129,
 95,232,210, 67,  6,194, 24,  6, 65,233, 87,250,179,137,247, 26, 75,116, 30,104,
 25,152,146,212, 76,199,249, 73,111,103,251, 61,241,161,242,110,118,179, 27, 46,
 53, 67,177,139,139,124,208,177,106, 10,165,246,150, 21, 21, 21,141, 54,245,145,
 24,112,245, 93,199, 89,122,  4,168, 21,153,215,176, 45, 45,189,168, 17, 71, 27,
  9, 82, 61, 95,136,107, 82, 94,211,151,130, 11,230,116, 12, 89,244,218,135, 16,
205,116, 92,174,160,241, 60,113, 34,200, 65,115, 66,230, 11,237, 98, 67,236, 24,
133, 61,108,176,196,136, 59, 79,213,139, 99,166,128, 11,101,  8, 88,128, 10, 45,
210, 83, 58, 10, 15, 22,  0,174,244,228,122, 57,118,200, 36,235, 28,119,244,143,
107,182, 44,180,141,248,158,233,179,146,204,250,195,131, 78, 45,247,202, 16,157,
 74,175,101, 63, 88,218,124,179, 22,206,174,191, 85, 76, 61, 22, 54,  5, 46,116,
186, 41,240, 86,162,247,138,233,150,223,228,167,123,177, 82,163, 56,134,194,111,
 33, 75, 52, 29, 21,133,110,152,123,115,  4,122, 78, 62,252,125,254,127,165, 14,
 98, 78,242,211,105,154,253, 41,150,141,147, 96,134,151,214,232, 68, 54,  9,201,
 97, 90, 90, 35, 24,206,237, 73,215,239, 80, 25, 24,206,  9,182,176,142,229, 45,
182,158,229, 77, 38, 44,169,222,132,118, 74,105, 71,244, 18,168, 61,248,124,230,
 33,158,143, 86,250,167, 53,172,203, 38,186,166, 22, 36,245,164, 67, 86, 29,133,
 14,109,246,112,206,227, 10, 66,202,100, 52, 20, 49,194, 62, 57,199,254,148,238,
 48,187,133,158,  8,234,  2,124,146, 74, 54,196, 26,140,127,171, 70, 44,166,110,
 66,248,201, 39,131,122,246, 34,200,235, 31,104,139,  9,125, 86,208, 76,209, 85,
 76, 42, 57, 80, 98,  7,  9,158,205, 50,245,142,142, 26,202, 89, 51, 34,  1, 86,
 18, 39,120, 28, 33,246,137,160, 99, 70,210,158, 49, 17,209,193,155,231, 84, 85,
216,132,  0,136, 91,205, 24, 42,116, 63, 32,152,152, 75, 26,  3,199,141, 56, 42,
215,  4, 96,  0, 79, 46,239,125, 19, 80, 10,  4,182,113, 16, 16, 21,214, 13, 17,
159,202,158,  2, 60,102,218,141,241, 19,221,129,145, 33,106,173, 47,241,  6, 67,
 83,225, 93, 15,123,117, 68, 11,106,170,181, 76,239,216, 49, 93,103,232,108,117,
 19,180,178,188, 18,123,  8,125,229,173,158,143, 84,232,219,145, 75,236,193,  3,
124,186,202,166,250,168, 25,185, 58, 81,199, 88, 91, 88,230, 46,249,120, 87,125,
148,231,197,244,163,178, 67,137, 91, 74,132, 86,236, 73,115,187,225, 46,216, 76,
 86, 45,188,168,166,  2,112,138, 28,189,232,150, 66,111,108, 85, 76, 73, 96, 13,
179, 15, 34, 90,197,170,185,208,127,121,205,239,110, 11, 92, 28,209, 29, 49, 43,
 13,127,248, 11,  8,126,198,208,154,133,250,159,120,217,164,251,222, 40, 18, 79,
 19,  6,219,120,227,122, 20,205,108, 18,  3,  2,163,  6,217,233,138,151,150,105,
249, 98,109,215,108,123, 83,134,210,127, 55,174,159,184,184,176,184,254,154,163,
120,137,135,195,182,141,215,  1,146,234,254, 36,170,215, 90, 83,154,207,161, 44,
125,  4,130, 85,169,157,110,152, 30, 48, 49,214,239, 63, 10, 82, 77, 81,177, 44,
 91, 21,247, 80,109,113,236, 73, 43,103, 34, 66,150,220, 57,104, 15, 67, 63,124,
162,177,100, 51, 62,246, 70,142,174,103,173,245, 14,148,232, 49,103, 79,128, 40,
213,248,204, 32,229, 20,196,153, 74, 27,174,106,  7,251,104, 65,210,198,100,247,
246,151, 31,133,189,249, 38,147,114, 24, 20,167,249,243, 25,208, 68, 49, 11, 57,
 24, 46,146,239,131,149,105,166, 17,205, 56, 44, 12, 55, 33,144, 67,221,242,141,
 37, 86,162,240,  7, 99,175,156,188,189,198, 36, 77,240, 11,125,210, 91, 94, 32,
 58, 40, 47, 83,226,162,209,247,112,  8,  3, 91,212,115, 29,180,230, 28, 54,200,
 99, 11,160,101,  0,163,224,  1, 16, 83,118,  9,173,  5,121,254,240,199,189,208,
125,178,156,173,116, 20, 38,100,216, 51,133,247,151, 76, 27,163,119, 46,249,126,
140, 35, 90,174,171, 33, 84,200,234,179, 28,156,125, 51, 60,197,225, 14, 96,154,
 37,112,145,215,213, 36,165,121, 62, 71,132,139, 39,184,  9,205,193,125,158,122,
 99,204,239,162,209, 29,142,  9,230, 10, 74,135,124,133, 83,236, 55,243,149,229,
162,122, 13,245, 68,239, 41,223, 39,185, 23,149,101,229,210,239,164,137, 98,229,
102,134,100, 80, 23,250, 44,145,156,198,211,163, 59,127, 66,102, 72, 78,202, 74,
210,132, 88,223, 84,247,230,115, 73,199,103,252,160,  9, 58,132,162,105,241,208,
100,205, 42,244,154,  4,  8,195, 55,165,120, 60,134, 30, 99,233,255, 14,104, 20,
128,250,  2,226, 34, 90,184,120,167,  2,186, 43, 95,158,212,204, 97,107, 95, 74,
 69,109, 56,184,234,205, 64, 42,212,184, 53,112, 43,151,102,183,176,252, 48,168,
 80,137,137,133, 48,108, 35, 37, 60, 95, 51,205,198,162,191,114,206, 76, 78, 30,
 14,166, 94,122, 46,100,222,192,142, 54, 44,149, 63,163,135, 98,186, 15,150,120,
168,124,250,116, 38,233,190,222,122,120,242, 11,225, 50,138,143,166, 26,224, 91,
 42,140, 11,129,198,150,250, 82,108, 55,  2,192,102,193,233,118,169, 66,  6,213,
102, 53,112, 12,155, 42,200, 69,174,121,  9,131, 72, 77,160,167, 16, 53,145, 21,
192,118, 97, 70,168,198,203,115, 28,187,240,  1,173, 57,  2,210, 26,134,185,219,
249,197,131,213, 58,235,142, 39,232, 58,  2,106, 90,164,190,243,154, 14,166,  0,
208,103, 14,188,126,195,202,183,216,121, 87,150,120, 62,118,117,205, 96,188, 72,
186,209, 18,170,105,189,143, 10, 33, 79,189,254,  2,206,194,134, 69,140,157,193,
 11,145,211, 47,235,167,233,169,158,219,108, 51,195,221,237,161,102,242, 31, 15,
  8,176, 31, 32,138,194, 41, 84, 12,  4,194,124, 84, 33,216,160,153, 18,197,236,
209, 11, 45,118, 44, 65,151,222, 50, 16, 80,248,127, 59, 21,168, 61,230, 34, 41,
 56,  3,103,226, 76,128,237,129,139,161,179,  0,110, 34, 84, 82,134,132, 15, 88,
228, 41,206,226,194,190,149,244,194, 62, 63, 64,200, 10,151, 82,  4,181,230,141,
233,169, 75, 26,133,109,246,224,127, 18,  7,182, 56,  8,166,243,170,237,  3,179,
112, 49,107,147, 94, 76, 15,138, 17,220,183, 43,220, 62, 64, 67,130,159, 15,209,
100,226, 44,253, 62, 36,182, 63, 76,156,110,219, 42,101,  8,116, 90,219, 45,214,
128,150, 69, 73,121,234,187,176, 34,162, 57, 85,158,210,180,167,207,154,131, 75,
137,170,185, 57,116,176,228,142,222, 23,100, 23,217, 10, 31,244,135,203,237,120,
176,247,107,168,191,115,150, 53, 79,223, 70, 35, 48,167,218, 15,248, 26,149, 31,
 38,194,217, 52, 74,233,125, 73,148,234,  5, 44,253, 78, 11,229,  7, 61, 42,188,
136,105,238,172,202, 54,157,179, 95,114, 37,177,251, 24,145,191, 47,136, 52,113,
206,  3, 51,194, 10, 97, 78,245, 13, 74,113, 23, 93,148,209,219,164, 81,163,193,
130, 11,255, 24,196, 29, 20, 13,228,157,182,146, 31, 75, 72,175, 77,105,226,243,
154,187,216, 83,140,  1,235,227,206, 11, 77, 48,215, 81, 72,239,184,237, 59,122,
160,240, 46, 69, 88,111,144,188,203, 25, 41, 22,167,163,120,176,225,176,108, 66,
 54,206, 19,154,169,196,  1, 38, 45,158, 56,209,206,171, 16,227,141,142,229,209,
138, 73,184, 65,196,124, 34,  5, 57,120, 54,  9,203,125,207,116, 78,122,241,101,
168,120,213,129,143,219, 56, 11,129,142, 70,231, 32,178,119, 18,111,146,244, 82,
 87, 90,230,132,162, 13, 18, 30, 19,131, 48,135,217, 44,247,137,169,209,235,111,
169,150,  9,236,227,195, 51,201,141,100,151, 17, 35,238, 73,248, 39, 79, 32,182,
214,124,212, 91,197, 20,  9, 11,215,142,158, 60,179,107,169,192,134, 65,186,178,
  0,  9,238, 14,166,193,  0,215,172, 98, 79,118, 17, 52,240,142, 68,118, 31, 59,
173,171,204,184, 71, 89,197,114,237, 65,245,228,159, 90,186, 70,199,172, 28, 18,
  1,159, 91,130,185,199,138,108,122,162,252, 89,  8, 74,128, 57,112,145,  5,150,
129,100, 20,137,242,153,178, 40, 67, 21, 98,130,169, 83,172, 46, 84, 73,101, 92,
110,165, 56,229,125,169,133, 89,144, 56,156,205, 52,103,105,181, 90, 73,180,124,
 88, 52,160, 98,  7, 35, 96,193,186, 70,210,153,171, 64,229, 32,131,233, 77, 86,
106,168, 40,103,180,163,129, 91,160,232,124,191,230, 87, 53,140,220,108, 24, 80,
 22,223,  1, 63,187,182,181,220, 90,125,142,232,118,125, 90,242,255,233,239,177,
235,186, 75,165,149, 17, 55, 49,241,218,181,178,158, 15, 49, 92,  3, 70,224,210,
 77,165, 51,201,210, 95,  6,103,137, 13, 37,117,219, 91,184,182,175, 37, 98,185,
 31, 89,160, 70,112,150,239, 41, 56,202, 20,145, 74,230, 53,241, 14,132,249, 21,
 89, 23, 11,140,126, 90, 89,223, 41, 40,181, 69,210, 94, 34,189,203, 47, 30,241,
227,189,171,213, 48,156,192,184,127, 31,  6, 17, 90,219, 63, 47,159,190, 56,123,
 78, 36, 56,161,178,118, 46,251,  3, 35,229,119, 96, 54,129,153, 58,138, 39, 16,
122, 43,247, 55, 96, 93,106, 77,165,178,  3,136,180,134,  4,220, 64,165,219,213,
145, 14,146,113, 90, 47, 28,146,106, 98, 92, 96, 47,163, 88,221, 71, 49,219,101,
132,208,215,136,191,206, 36,200,193, 74,240,120,134, 85,195,156,114,230,176,151,
164,125,  5, 72, 11,149,180, 87,194,136, 34,187,214, 39,137, 76,230,242,237,157,
170, 42,120,250,120, 48,207,162,196,169,186,126, 82,224, 29,232, 68,220,205,241,
 99,224, 96,237,211,131,229,225,230,183, 93,130, 76,251,203, 82, 36, 48,207,140,
132, 79, 10, 53,128,150, 75,240,178, 88,227,194,211,  5, 89, 25, 80, 33,183,144,
 28, 79, 30,238, 21,164,112, 52, 34, 78,226, 82,171,172,253,227,187,230,177,113,
123,171,189,203,132,109, 81, 99,246,214,135, 56, 75,130,218,182, 13, 58, 37,142,
216,196, 62, 89,110,143,145,246,254,239, 19, 25, 72, 87, 42,182,106,232, 68, 10,
177,155, 40,204, 62, 30, 71,182,180, 63,192, 15,216, 33,  2, 78, 49,  4, 91, 37,
185, 93,111,190, 69,205, 77,143,  7, 12, 13,174,102,132,195,184,111, 54, 29,136,
  1,128,253,  3, 32, 76,105, 71,252, 52,249,162, 52,149,211,173, 64, 80,213,227,
172, 15, 33, 49, 28,231,108,212,187, 34, 93,206, 58, 37,251, 50, 87, 93,198,100,
171,200, 23,112,233,152,244,185,252,231,162, 56,168, 89,181, 74,226,103,238,232,
225,104,140,240, 19,253, 36,142,106,228,215, 67,186, 50, 60,186,146, 39, 63, 65,
 52,177,188, 77,173, 22, 36,  4,  2, 66, 44, 84, 52,173,255, 76,182,194, 63, 31,
 14,171,142,226,235, 54,109,222, 63,240, 92,217, 55,186,185,176,139,137,241, 78,
138, 61,163,183,128,113, 16,  7,228, 44, 13, 56,  4,177,112,112, 39, 71,116,183,
255,  9,226,171, 36,100, 87, 85,245, 91,197,178,188,170,145,253, 20, 30, 35,207,
169,231, 56, 15, 63,183,142, 42, 98,204, 84,  0,137, 75, 98, 96, 25,241,179,229,
118, 75,149, 32,234,115,  6, 69, 57, 32,140,137, 83,186, 40, 12,117, 65,234, 11,
196,152,109,234,159, 54,108,108,235,127,188,190, 56,100,210,127,253,129,220, 66,
193, 98,119, 89,109,140,114,118, 15, 87, 61,  9,226,142,143, 76, 75, 50,192,229,
144, 91,244,187,135,182, 28,163,208,239,148, 24,170,244, 72,199,176,120, 91,218,
211, 80,145,166,124,166,146,  0,155,238, 47,230,220, 78,144,141,206, 12, 79, 28,
138,233,236, 65,195,132,  8, 84,213,166,229,147, 24, 39,172,159,234, 93, 91, 48,
189, 84,164,125,245, 24,208, 12,221,215,158,132,200, 68, 69, 71, 98,  2,253, 22,
140,131,137,118,152,221,193,157,211,108,116,254,136, 67, 14,154, 10, 84,235, 12,
 93,139,223,100,228,199,227,112,178,214, 42, 13,199,133, 66,166,213,251,152, 12,
202,215,135,236, 30,196, 56,248, 11,206, 69,  3, 50,135,151, 88,128,224,178,  2,
177, 21, 41,216,196,121,182, 36,161, 80,211,127,189, 10,  1, 60,188,101,161,205,
 11, 80, 97,159,164, 89, 83, 91, 79,113,101, 12,153, 46,146, 74,  2,246, 45,226,
 36, 79,165, 19,  7, 94,121,  1,110, 17, 86,182,229, 12,149,144,  8, 79,104,119,
 10,134,136, 65,200,148,152,186, 21,153, 62,222, 26, 64,245,  4,170,130,202,144,
  3,212,137,169,216,167,164, 37,192, 96,149,187,222, 90,105, 23,198,178,201, 27,
 55, 49,215,216,  8,  6, 66,197, 42,207, 52,  5, 38, 48,  6, 88, 28,137,112, 79,
156, 66,238, 54, 15, 48,240,242, 60,199,248, 75,230, 49, 64,229,126,200, 11,228,
227,126,168, 43,104,225,115,118,146,251,132, 45,126, 87,207,241,181,127, 46,199,
 92,168,166,218, 75,147,177,198,  2, 55,  9,169, 78,107,202,176,157,122,231, 65,
 54,222, 40, 42, 59, 47,126, 21, 22,171, 89,193,244, 50, 29,155,204,136,115,140,
114,238,  6,  8,121, 50, 36,193,105,163,153,111,219, 40,229, 45,214,190, 31,218,
173, 31,183,156, 73,208, 43,236,225,118, 77,168, 50,243, 27,152,138, 38,246,  9,
 12, 44,114, 34,139, 29,  7,  2,193, 88,134,118, 75, 40,101,239,255, 61, 44, 25,
229, 93, 92,243,171,167,126,230,208,  1, 16,144, 36, 65,  9,225, 35,  3,105, 48,
198, 23,241,212,106,144, 85,126, 51, 68,162,107,166,136, 35,218,172,144,146,200,
  3, 55, 51,162, 60, 36, 40,178, 72,172, 72,130,138,172,206, 21, 16,207, 75, 61,
137,229,246,201,203, 60,165, 99, 64,204,233, 12,217, 90,249,152,167,215,144,131,
229,163, 34, 63,194,208, 25, 89, 83, 57,114, 97, 28, 16,146,133,216,255,129,215,
  9,123, 94,117,216,201,187,  9,103, 28, 56,230,180, 39, 45,130, 97, 53,110,131,
202,132,186, 61,128,193,147, 49, 83,146,161,180,179,217,146,  6, 80,191,247, 63,
147,184,119,140,118, 68, 76, 70, 84,253, 26, 36,207,218,102,226,158, 33,112, 12,
 85, 12,152,168,145,  2,217,  1,118,163, 66,207, 12,235,250, 58,173,141,233,167,
 72,224,165,176,179, 11,192, 21,159,182, 39,174, 63,223,178,178, 74,147,101, 75,
 22, 99, 52,101,207,192,202,206,236,192,119, 24,138,226,148, 13, 83, 43,219,149,
 59,204,178,217,195,192,200,114,107,177,178, 87, 45,203,  6,104,221, 87, 39,252,
101,131, 62,171,223,203,  8, 12, 46,103,  4,186,113, 62, 78,185, 58,229,201,209,
  3,157,216, 33,255, 70,248, 80,174,238,182,180,174, 92, 99,147,102, 53,199,208,
203, 78,164,151, 72, 96, 23,188, 76,163, 47,131,169, 24, 84,117,191,233, 67,157,
240,161,154, 27, 64,167,142, 37, 79, 57,208,225,157,154,125, 69, 19,183,  9,228,
116, 45,226,191,211, 48,146,167,189,109,218, 86,132,207,193,167, 35,202,125,250,
 62, 10, 30,240,167,226, 14, 80, 45, 31, 30, 34,249,235, 71,127, 90, 13,168, 63,
 41,145, 17, 30, 11,112, 31,216,169,128,250, 89,  0,253,145, 75,101,137,126,155,
 86,145,126,183, 43, 69,167,163, 35,237, 84,175,157, 10,127,204, 35,208, 64, 53,
 68,217,209, 31, 13,158,114,114,135,207, 88,159,224,150, 51, 24,122,156,243, 84,
 46, 94,131,238,236,169, 84, 26, 64,104, 77,243, 20, 74, 42, 40,118,152, 48,184,
136,173,208,191, 60,153,143,106,106,164,192,181, 76, 62, 17, 99,211,175,225,121,
 76, 43,125,190,221,120, 21,109,219,244,221, 68,233,207,125,140,107,122,253, 32,
253, 57,219,175, 56, 71,146, 45,221, 96,171,178,142,105,197,152, 77,153, 60,175,
168, 42,166,  2, 73, 25, 18,104,129,233, 27, 62, 65,252, 18,139,200, 33,108, 15,
 84,170, 10,203,148,178,142, 16,148,175,253, 29, 31, 93, 64,149, 65,242,207,  9,
 61,226,147,143,187,104,237, 35,204, 21, 58, 71,139,150,224,209,116, 56,245,150,
167, 41,174,218, 46,109,162,163,146, 30, 72, 47, 70,149, 92,205,242, 38,101,139,
254,150,160,201,145,201,252,148,158,178, 96,224,238, 81, 98, 13, 23, 48,222,176,
 46,117,101,215, 37, 81,125, 16,231, 75,226,191,111,143,194, 99,180,240,248, 54,
203,124,224,199,143,174,132, 84, 48, 72,230,255, 75,178, 71,241, 25,232, 42,253,
 40, 28,221,183,118,134, 25, 70, 47,249, 38, 72,156,146,180,209, 50, 59, 88,104,
 43,184,  0, 76, 22,135,141, 42, 27,112,181,130, 22,238,175,209,234,127,108, 20,
 51,236, 81, 89,108,110,167, 45, 48,133, 72,201, 11,171,133,101, 49,  0,153, 63,
173,205,254,210,228,132,250, 74,250,213, 79,143,105,225,246,208,178, 47,158, 67,
242, 13,184,156,118,243,249, 91,144,141, 43, 83, 88,179,197,182, 70,145, 33,224,
 91,188,166, 72,205,101, 25,127, 22,187, 83, 91, 84,114, 18,136, 96,241,244,173,
 70,240, 32,  2,114,103, 64,139,252, 77,129,198,194,179,183, 98,  1,124,115,215,
 51,  1,127, 52,198,146, 39,  2,206, 27, 63,249,123, 50, 14,  3,222,193, 68, 61,
 28, 63,241,146,171, 79, 87,150,162, 27,205, 53,159, 60,249,247, 57,204,120, 41,
 35,116,159,247, 55,252,193, 49, 32, 50,  9,160,232, 41, 92, 41,  3,  4,222,169,
 97,177, 74, 85,189, 34,  9,122,106, 70,250, 99, 88, 78, 38,118, 86,133,199,167,
 48,147,199,113,150,150,215,143,107,113,176,131, 14,161,193, 35,162,130, 50, 71,
193, 22, 14, 46,  5, 10, 54, 52,  4, 40,167,249,229,228,185,133, 20, 37,209,123,
 67,  3,  4, 84, 16,159, 52, 67,142,229,173,209, 23, 33, 12,228,255, 41, 44,168,
  1, 65,214, 19,147,248,195, 23,171,248, 89,207,207,228,214,132,191, 42, 64, 74,
 61, 38,217, 45,116, 84,  9,225,  7,  8,198,134,252, 44,146,193,235, 98,158, 68,
208,101, 80,101, 32, 37, 59,197,208,229,  3,199,  9,254,119, 60,233,189,164,214,
 67,164, 16,118,155, 91,190,219, 70, 23, 12,180,175,170, 21,136, 60,124, 55,233,
 56,248,188,  2, 33,120,241,239, 25,  1, 41,231,221,163,132, 63, 53, 81, 32, 16,
228,166,249,122,211,154,202, 66, 17,109,184,212,  4, 83,128,244,196, 88,229,214,
222,246,164,243,133,151, 53,231,207,115, 94,183, 60,192, 37,175,105,194,131,144,
139, 73,227,122,  9,221, 61,144,165, 91,150,124,233,119,172,224, 78,234, 73,106,
 16, 73,138, 78, 99,155, 95,144,200,112, 19,208,255, 74, 80,181, 62, 18, 27,  3,
150,161,117,127, 79, 16,212, 99,100,125,172,141,219,179,145, 49,226, 86,156,158,
 35, 23,130, 10,214,202, 41,216, 25,110,224,153,164,128, 49, 67, 84,165,245, 67,
 83,  3,215, 27,103,232,195,106, 33,129, 86, 79, 52, 62,109,232,240, 12, 20,  6,
 65, 43,  3,241, 46, 79,137,201, 87,235,120,165,133,101,149,169, 13,131, 77,189,
196,164,177,132, 57,144, 79,228,159,249, 48, 31,121, 57,142, 49,171, 45, 66, 70,
241,147, 52,252, 79, 58,157,193,112,242,128, 44,100, 48,  7, 82,240,174,136,177,
 56, 11, 16, 69, 68,128,119, 95, 69, 31,230, 63,106,  1,199, 54,130,  2,226,149,
 10,125,163,247,224,134,  9,154,203,  1,  4,142, 92,  1, 82,  0,141,242,209,111,
 57, 90, 89,238,223,207,186,  9,164,121,217, 74,166,232, 58, 67,191,252, 81,189,
 41, 29, 71, 80,206, 71,252, 24,156, 13,159,145, 36,158,237,118, 90, 64,178, 11,
 80,211,  7,195,177,228,153, 83, 77, 38, 87,226,247,186, 25,  4, 12,234,127, 78,
228, 22, 21,  7,197,193,201, 10, 60,196,205, 85,195,  6, 88,128,128, 94,145, 50,
 43,105, 83,249, 51,208,149,158, 41,106, 51,193,175,250,134, 22, 64, 47, 18,226,
112, 96,112,213,126, 24, 92, 25, 39, 32,253, 32,147, 43,120, 95,198, 91,213,131,
187,209,150,  3,175,255, 14,192,227,234,199,171,131, 28,130,198, 29,101,  3, 74,
 61,113,228, 15,129,164,185,  4, 99,240,118, 90, 84,200,114,145,199,132,111, 34,
 69,133, 56, 67, 34,156,140, 17, 32,  7, 99,209,178, 98, 16,148,119,232,233,  2,
160, 98, 78, 78,107,116,  5,232,216,238, 72, 95,232,162,157, 28,104, 31,200,132,
  4,161,111,  8,199,235,  1,213, 94,  0,243, 77, 43, 43,157, 78,167,115,191, 78,
167,211,233,232,176,120,232,200,216,120, 16,241,160, 26,196,187, 25, 74,167, 53,
123,157, 78,167,187,163,105, 31, 68,167, 35,209,105, 40, 25,233, 50,112,158,156,
156,156, 72, 42,157,156,108, 84,137, 78,136, 39,158,204,105,131, 32,197, 14,193,
 16,  4, 61,243,228,228,100,202, 25, 27,227,252,158,217, 62, 59, 54,181,200, 28,
 61,145,253,207, 62,148,185, 23,181,184, 38,163,201, 72, 18,168,118, 30, 54, 52,
 30, 28, 58,196, 34,  2, 35, 99,163,195,162,118, 38, 38, 36, 48, 28, 48, 94,187,
 19,238,195,157,175,123,185,156,156,216, 43,111,132, 87,238,114,103,174,  9, 21,
 90,157, 13,101,149, 53,177,186,144,165,225,246,111,233,116,226, 56,179,129,148,
229,244,216, 33, 87,  5,133,111,172, 99, 78, 75, 82, 72,187,  1,131,195, 16, 12,
 34,144, 76,198,153, 26,131, 65,163, 44,246,  1, 20, 37,124,117,179, 96, 61, 40,
217,170, 96, 24,231,206, 42, 44,236,177, 85,246, 18,185,  0,254,181,132, 37,221,
145,121, 74,221, 51,247,193,211,100, 40,  0, 25,  2,  2,242,119, 28,247,238,  5,
 54,242, 92, 42,221,157,160, 91, 93, 84,164,  9, 42,179,252,232, 84,133,250, 86,
201, 66, 15,181,194,135,255, 71,112,232, 39,101,154,188,130,171,220,147, 21, 80,
191,205, 89,252,176,180,206,134,122,203, 75,145, 59,145,119, 75, 23,103,  3,135,
131, 73,119,118, 91, 14,  9, 96, 38,152,123, 50,151,204, 58,215, 97,130, 50, 53,
 87,100,172, 48,178, 78,196,162, 86,218,228,136,116,140,103,224,231,218,214,130,
139,117,180,144,156,129,125,207,213,243,129,170,219,166, 99,114, 83,160,109,129,
203, 94, 40,180,240,229, 54,193, 73,110, 49, 13, 25,139,  1, 40, 61, 30,198,138,
 63, 56,103, 29,212,122,233, 32, 82,246,  2,147,241,140, 93,161,163,179, 46, 19,
 29,154, 20,121, 81, 67,237,178,127,115,197,174,185,  0,176,128, 43, 19,210, 36,
156,177, 53,162,222,107, 97,240,142, 28,  8,105, 88,166, 41, 42,123,148, 90,167,
 38,100, 11,125,117, 42,205,190, 82, 13, 16,202,131,252, 85, 11,136, 82, 26,248,
186,117,103,129,229,129, 24, 59,136,144, 82,232, 66, 99,214,208,224,151,244,197,
156, 38,  9, 49, 45,253,182,237,141, 65,158,161,221,  3,108,137,180, 25,166,133,
143,194,123,201, 54, 35,177,229,136,167,130,202,222,223, 10,200,224, 18,234,194,
151,171, 40,  6,226,202, 84,151, 92, 44,149,195,198, 43,245,  2,240,254,126,244,
 34,240, 17, 31, 37,245,144,197, 93, 87,184,171, 28,190,221, 80, 21,221,149, 42,
 97, 94,222,149,117, 70,106,143,187,225, 36,243, 27,249,123,214,190, 61, 23,217,
121,  5,141,108, 89,  4,169,132,238,242,154,  0,242, 16,130, 30, 99,181,240,188,
220,122, 92,173, 54,236,148,161, 38, 46,237, 68,177,122,220,114, 37, 85,193,210,
115, 93, 92,215,138,201,170, 64,165, 21, 71,189,126, 46, 49,142, 68,156,150, 22,
168, 81,106,234,181,104,114, 69,248,219, 48,157,103, 93,237, 38,232,216,207,128,
171,169,  4,151, 97,150,135, 45, 27,146,196,208, 19, 72,134,173, 21,  8,131,149,
  5,248, 66,153,240,217,149, 60, 22,157,195, 27, 83,250, 45,151,253, 28, 65,118,
146,168, 80,239, 77, 54,100,208,151,141, 15,222,175,192,  0,116,112,159, 67,199,
225, 11, 72, 66, 61,  8,111,175,129,170,137,196, 92, 15,226,155,128,185, 50,118,
 60, 74,166,194, 52,115, 40, 69,162,193,225, 30,  2,253, 47,172, 96, 78,163,125,
165,161,  9,179,176,137,  2, 53, 21, 21, 94, 73,248,106, 18,229,186, 30, 24,129,
186,101, 57,  2, 92,120, 74,135, 15, 60,233,112,  2,221,205, 35,  1,151, 54,147,
 38,141,228,230,215,121,132, 12,127,  6,142, 71, 99,216,200,145, 11, 96,  1, 96,
 76,169, 56,191,223, 79,203,220,167, 66,166,101, 73,141, 82, 90,134, 76, 32,132,
 36,  6,123,203, 24, 41, 65, 82,137,134,120, 83,240,240,  7, 38,116, 12,172,233,
 76,185,146,134, 40,145,  1,129,141,216,228, 34, 23,226,170,117,198, 34, 40,122,
144,239,203, 41,222, 47, 39,143,229, 25,128,253,156, 48, 96, 66, 68,242,252,177,
212,128,230,121,  1,240, 66,122,185,206,100,122, 75, 13, 87,163, 41,164,  6,199,
163,179, 95, 78,145,171, 59,129, 39,116, 62,  8, 35,229,224,252, 18,229,104,241,
228,249,153, 34,253,101,106,  3, 60, 47,134,219, 64,199, 16, 37,196, 53,186,195,
228, 95, 35,112,175,227, 22, 29,166,  2, 67,106,113,112, 31,228,208,203, 73,113,
243, 49, 22,182,250, 49, 69,206,253, 14, 67, 73,186, 89, 35,215, 61,246,108,112,
216,131,228, 54, 68, 66, 33,185,140,244, 35,109,113,248,122,150,  4,202, 44,  0,
 49,108,243,112, 70,231, 31,182,182,198,100,255, 66,171,145, 75, 49,130,251, 78,
 36, 12,106, 77,118,207,101,197,230, 55,168,245, 97,230,115,240,162, 35,101,102,
121,  5,115, 96,214, 56, 34, 52, 91,243,182, 61,160, 97, 39, 58,109, 31,147, 79,
138, 94, 97,181, 60,170, 55,208,194, 63,219, 26,100,126, 66,202,240,107, 15,200,
228, 78, 14,246,193,111,139,245, 40, 13, 12,182,244,164,112, 37, 39,124,160,135,
  1,152,102,129,  7, 12, 76,179,219, 57,105,  0,251,230,247,153, 11,192, 79,113,
 31, 25,170, 25,255, 97, 41, 28,237,110,135, 72,109, 44,229,205,140, 74, 10,195,
249,184,166, 67, 21,119,172, 53,208,211, 12,114,114,253,239, 85,143, 98, 65,206,
 27,139,116,205,157, 40,227,220, 58, 46,104,217,104,238,223,231,143,255,199, 76,
 43, 28,254,145,184,255, 56, 20,  1,180,235, 13, 89,104,234, 87, 61,127,136,121,
143,158,163, 77, 88, 45,226,163,117,204,209, 31, 27,161, 37, 28,156,178,103,160,
169,  5,161, 21,224, 18,231,120,  9,175, 13, 53, 12,119,255,197, 37, 64,211,160,
 46,142,121, 33,154,128, 92, 32,221, 79, 24, 33,106,145,203,241, 64,208,103, 70,
171,118, 20,168, 12,132,120,163, 70,  6, 35,151,238,185,161,209, 11,169,185, 71,
 36,146,241,153,250,176, 56, 23,153,167,  5,164,157, 47,116,101,157, 34, 32,  6,
147, 91,110,102, 69,178,231,  1,191, 73,166, 59,201, 24, 13,178,188,106, 35,  8,
156,  6, 45,195,104, 30,108,227, 28,209,206,241, 65, 50,  9,149, 91, 54,254, 82,
 25,148,206,132, 37,176,206, 42,230,188,150, 57,213, 23, 98,233,254,239,173,218,
 13,129,106,128,181,133, 49, 90,112,141, 83, 44, 46,254,149,219, 40,111,163,100,
 50, 40, 30,111,206,170,228,229, 43, 17, 27,166, 29,179, 20,185,228,177,151,  9,
 83, 89, 17,200,222,155, 98,  9,164, 51,249,219,244,109, 20,128, 49,231,178,  7,
 27, 41, 80, 99,138,252,  3,248, 97, 53,229, 48,  4,111,250, 79, 11, 38,109,  2,
 90, 18, 56,216, 41, 67,113, 33,199, 26, 99,104,210, 58, 52,197,238, 19, 39,119,
108,216,236,166,115,197,208, 66,194,150,222,217,155, 83,224, 20,185, 53,107,145,
 74, 35, 36, 77, 95, 26, 94, 38,  9, 71,242, 69, 73,213,127, 94,139,  8,181,203,
106,149,194, 74,176, 91,166,166, 98, 81, 98,172,218, 15,215,129,227,157, 60,  2,
 36,136,244,229,157,111,185,231, 29,204,110,166,119,210,213, 76,167,142,225, 47,
226, 11,220,127,155, 66,182,251,237,227, 88, 13,132, 70, 99, 72, 51,107,163,161,
208,210,177,181,135, 72, 47,246, 61, 32, 57,152,129,130, 55, 77,129,167,189,230,
 32,  3,210, 48,141,130,105, 22, 91,125,160,184, 21, 63, 35, 17,144, 53, 43,180,
 45,102,196, 17, 84,252, 11, 23,215, 16,240,181,105,140,164, 96,188, 62,  8, 92,
100,213, 82,229,163, 24,152,204,212,107,239,241,230,154, 36,194,  2,105,142, 16,
 26, 72,150, 41,215, 39,138,163, 21, 67,224,215,205,254,158,136,179,190,181,207,
180,255,244,142,243,167,127,212,215,211,131,118, 47, 66, 87, 26,232,132,186, 70,
218,246,144,130,113, 57,177,146, 17, 54,128,164, 66,102, 70, 26,200, 43, 48,106,
 98,249,229,153,241,161,209,249,145,221, 36, 81, 15,140, 75,137, 13, 17, 23,160,
154,224, 94,232, 23, 40,114,161,162,251, 80,  5, 18,119,161,  0,198,127,  1,245,
219,224,237,135,  7,254,  0,125,134,113,183,159, 23,231,153,140,219,200,179, 71,
126, 18,105,245, 80,151,108,124,124, 18, 67, 64, 82, 17, 94, 98,161,104, 59, 38,
177,153, 88, 26,164, 17, 27,203, 42,110, 92, 78,181,113,232,161,227, 25,113, 85,
210,141,230,212,212,181, 56,160,244,229,  3, 18, 36, 89, 52, 60,159,190,204,160,
110,108,250, 45, 17, 68, 15,249,201,129, 61, 85, 40,180,225, 84,255, 72,180, 60,
 43, 72,111, 19,156, 97,246, 60, 93, 39,248, 35,137,151,230, 36,239,  6,137,200,
177, 81,247,  1,186,226, 20,134,114,  0,128, 48, 48, 52,217, 30,211, 71,114, 84,
229,170,204,236,236,234,194, 99,135, 21,  7, 72,  5,117, 24,209, 71, 11,139,161,
173, 90,158,247,225, 23, 40,123,210, 54, 70,234,214, 83,254, 26,166, 79,  9,127,
 95, 68,139, 37,192, 47,205, 89,250,165, 30, 23,209,210, 70,135, 69,234,162,131,
 34,178,228, 93,124,129, 99,245, 87,223, 11, 32, 95,254,139,172,255,227,182,247,
175,127, 50,141,178, 69,242, 22, 75,236, 33,239, 15,204, 10,161, 53,180, 82, 92,
 64,233, 78,136,220, 46,156, 30,141, 15,192, 25,102,198,186,159, 54, 94,229,148,
 50,251, 43,227,200,113, 28,203, 35,108,  5,213,135, 98, 36, 46,162,143,116, 22,
 51,157, 85,159,188,235,123,246,216, 85, 89, 21,143,179,224,131,188,198,  2,194,
 29,215,225, 15,235, 24,173, 58,157,101,239,244,210, 33, 92,254,191,118, 54,110,
219,101,252,185,178,187, 88, 69, 46,180,251,236, 69,159, 15,181,169,190,219,250,
 64,194,119, 75,190, 85,125,131,166,199,214, 74,  2,138,174,242, 58,100,216,167,
167,139,254, 59,187, 37,106,115,241,120, 71, 85, 72,173,129, 39, 10,150, 54, 28,
 66, 94, 34, 56,158, 72,121,  6,190,213, 48,135, 84,135,177,200,195, 21, 78,205,
142,198,217, 51,108,183,155,134,199, 22,144, 99,117,250,217,201,138,197,154,246,
 29,145,121, 27,197,  9, 63, 21, 98,  4, 96,126,218,235, 69,246,216,123,141, 62,
 85,157, 11, 49,192, 29, 29, 20, 68,247,184, 40, 68, 61, 62, 18,249, 60,179,212,
241, 39, 17, 91, 45, 16,195,109, 32, 16,199, 67,  4, 77, 71,107,196, 31,192,143,
242, 54,131,121, 65,206,131, 44,193,227, 85,138,127,  9,125, 94,238, 56,194, 98,
157, 65,160, 63,176,216,203,131,116,  0,207, 52, 63,164, 30,172,148,194, 61,146,
209,138, 29,191,200,215,132, 60, 22, 69, 20, 44,192,135,236,110,237, 71, 40, 92,
168,196, 82,119,201, 46,191, 71,194,113,224,101, 27,202,160, 64,155, 53,148,128,
112, 76,  3, 22, 78,183,131,150,215,165, 99, 47,152,146,111, 57, 80,101, 96, 28,
 81,110,119, 73,230,252,140, 15, 76,228,238, 28, 41, 72,136, 48, 45,150, 35,254,
 27,175,122,124,210,224,188, 19,185, 67, 99, 30,249, 11,183,137, 61,219,192,190,
131,106,119,175,136,167,159, 74,237,  3,  6,139,143,141,114,131,148,176,244,181,
 42, 90, 72,194,158, 60,178,177,138,165,104,253,  7,139, 22,202, 53,177,138, 69,
174,216,105,120,154,196,251, 47, 55,179, 64, 61, 94,172, 25,129,172,252, 69,221,
189, 38, 92, 84, 52,190,222, 46,193,251, 32,181,229,224,220,143,211, 80,170, 69,
166,221,239, 21,188,116, 25,151,241, 38, 72, 29,131,213,116, 98,204, 19,164,137,
 95, 32,150,229,133,231, 90,232,125, 29,152,  9,100, 32,133, 30, 10, 87,  2, 94,
154,173, 39, 61,225, 90, 58,  8,201, 52, 30,161,187,117, 84,205, 35, 91, 37,159,
119,252,203,  3, 43, 68,192, 60,135, 21, 34, 91, 54,139,228, 57, 49,139,174,189,
201, 78, 89,132,129,164, 55, 92,245,118,  3,186,124,125,244,168,181,102,120,137,
223,135, 53,103,184, 82,184, 33,158,131, 43, 60, 14, 61,109,118,101, 40,221,154,
152,248, 69, 68, 63, 60,127, 90,164, 97,  2, 79,231,143,110, 74, 84,131,184, 31,
139,244,127, 13, 43, 61,175, 10,151,197,214,186, 55,189, 23, 72, 16,109, 44,138,
 98,165,  4, 13,253,116,168,162, 84, 96, 24, 81,131,162, 69,133, 94, 67, 81,199,
193,131,220,117, 44,243,180,175,114,244, 58,216,132, 95, 84, 84, 35,117,174, 39,
 22,211,230,238,102, 97,  9,201, 45, 74,236,109,105,111,  3,152,121,146,227,125,
 68,  1,124,209,149,116,163,190, 94,194,231,238,134,157,195,161,188, 67,185,230,
162,220,171,187,172,170, 78, 47,171, 99, 10,191,201, 22, 51,140,115, 77,  0,131,
106,227,212,189,151,186, 70,203, 79, 95,129,215,223, 89,162,116,115,122, 14,250,
154,154,169, 69,130, 79,143,198,251,123,215, 70,145, 56,170,233,112,216,171, 80,
230,174,253,140,127, 67,146,177,115,224,  8,153,231,196,150,119,215,218, 61,197,
119,  4,252, 26,215, 85,111,233, 94,172,121,190,222,185,143,200,111,162,151,192,
 89, 40,164,230,245, 63,142, 94, 10,185,165,143,129,235,149,151, 51,126, 72,187,
 61,240, 60,171,199, 38, 27,197, 31, 78,  7,247,242,  1,  6,208,207,208, 47, 71,
184,105, 96, 57, 47,100, 13,158, 41,201, 76,  7,142,213, 51, 63, 59,117,119, 51,
147, 54,120,111, 23, 15,249,208, 90, 42,  4, 14,  5,100, 26,142,193,132,145, 33,
 68,124, 54,230,148,252,116,140, 42,172, 28,  1,202,102, 23, 92,100,252,193, 59,
102, 17, 97,189,136, 55,235,241, 28,207,122,141,235,156,106,196,141,203, 76,228,
 76,141,183,132, 87,152,108,  1,167,174, 69, 49,115, 64,202, 87,104, 17,183,211,
196,169,222,148,227,191, 24,232,208, 41,138,166,170, 92, 71,187,  7, 65,  9,158,
 83,100,149,157, 86,173,179, 32,209,194, 90, 12, 21,119,221,136,132, 33, 58,155,
215,246,110,  4, 21,101,206, 54, 42,129,102,117, 75, 24,  3,247, 40, 76,231, 84,
 35,193, 46, 46, 38,127,254, 30, 38,139,210, 67,172,212, 43, 80,  9,119,217, 50,
 99, 11,185,  3,
} ;

// ../Source/add/template/GB_add_bitmap_M_bitmap.c:
uint8_t GB_JITpackage_34 [730] = {
 40,181, 47,253, 96,146, 17,133, 22,  0, 38,157, 92, 33,240, 88, 55,244,195,246,
113,190, 11, 23, 53, 53, 49,207,237, 87, 76, 35,244,129,107,239,161, 28,121,227,
146, 77,100, 16, 88,121,  1, 84,  0, 81,  0, 83,  0,175,255,227,122,135, 36,252,
241,156,171, 99, 11,  5, 66, 97, 96, 36, 16, 10,191, 60,130, 99, 26,159,110,197,
 15,213, 83,225, 38, 69,204, 57,182, 85,142, 13,203,107, 98, 30,175,205, 91,110,
191,241,185,209,156, 79, 48,211, 28,115,138, 99,182, 80, 37, 19, 77, 16,161,248,
 67,235,202, 43,110, 60,234,190,239,118, 22,227, 89, 70, 13, 89, 22,231,200,247,
 21, 77, 18,244,212,198,218, 83,127,186,161,219,154,175,121,110,239, 52,183,254,
 51,223,147,155, 31,110,252,254,141,215,177, 77,142,223,239,241,197,207,165, 72,
122,142,185, 73,186,166,177, 83, 40,226,160, 48,124,232,221,178,250,195,124, 12,
226, 61,254,151, 49,188, 30,223,195, 28, 67,168,226, 57,124,127, 50,  3, 35,137,
151,176,232,153, 36, 71, 78, 69,126,149,132, 31,177, 38,163,117,156,  5,227,224,
127,227, 41,176, 86,227,174, 66,252,226,112, 64, 23,103,177,252,210,  8,238,169,
 26,151,177,221,150,233, 44,134,224,220,199,178,109, 21, 16,113,127, 91,168, 46,
241,137, 22,113, 10,196,221,157,210, 21,165,135, 31, 73,223,250,126,246,125,125,
  7,148,182,220,125, 69, 65,252,141,142,215, 13,243,203, 84,152,105,236,214, 49,
141,243,183,  2,222,129,161,232,178,223, 55,151,226,239,128,255,119,102,111, 12,
 55, 57,242, 55,175,181,181,174, 56,150,206,199,178,233,184,140,  6,196,128,171,
 51,233, 11, 98,136, 95,175,194, 90,116, 12,197,109,149,162, 13,  6,142,141, 52,
130,107, 93,128,160,160,  1,166, 50, 35, 35, 34, 19, 37, 73, 33,173,  1,128, 70,
134,136,108,115, 46, 40,139,101,209, 34, 61,100,159,  5,201,234,227,177,150, 57,
 90,180,132, 95, 80, 58,216,177,178,180,204,160,225, 88, 90,164, 15,199,210,159,
  3,205, 90, 32, 48, 42, 90,217, 37,208,145,148, 68,127, 97,173,225,129,  1,113,
 65,116,142, 43, 35, 74, 33, 10, 29,100, 31,106, 80, 77, 71,117, 44, 83, 48, 51,
128,156,206, 83, 38,147,155,158,103,138,166,181,221,116,150,149, 15,140,100,151,
 13,135,153,253,178,203, 92, 50,110,139, 87, 44,208, 64,228,211,213, 97, 15, 75,
 38,196, 88, 63, 18,104,  5,135,  6,  0, 79, 80, 93,193,200,  0,103,  0,103,102,
 57,255,180, 24,123,224,115, 96, 15,206, 52,221, 32,236,135,215,240,230, 39,128,
184,199, 69, 72,194, 19, 48, 51,147,189,154, 71, 74, 65,231, 54,243,124,185, 29,
 73,117, 55,231,116,210,118,  3, 96, 71,234, 17, 70,244, 90, 76,147, 83,186, 24,
 55,114,164,176,235, 17, 71,140, 26,140,121,164, 51, 98,248,169, 75,198,101, 20,
153, 70, 42,200,101, 35,  5,  3, 10,135, 70,147,  9, 70, 10, 27, 55, 67,196,216,
 85, 97, 58,163,115, 54,219,237,219, 67, 92, 34,103,104,166, 96,141,  6,142,211,
 49, 29, 40,118, 25,134, 34,111,115,127, 45, 78, 84,250,233,125,149, 32, 22, 72,
  9, 20,149,  6,140, 83,155,182,136, 13, 67,112, 23, 98,159,153, 54, 77,217,110,
212,165, 33,220, 64, 33,103,154,233,155,230, 70,101,166,246,  9, 86,235,146, 65,
176,118, 36, 46, 70,211,204, 43,170,242,
} ;

// ../Source/add/template/GB_add_bitmap_M_bitmap_27.c:
uint8_t GB_JITpackage_35 [843] = {
 40,181, 47,253, 96,201, 11, 13, 26,  0,182,165,115, 40,208,240, 56,  7,254,167,
122,237,247, 13,176, 93, 64,190, 21,166,199, 48,226, 25, 38, 84, 71,207, 23,252,
 30,156,172,172,114,205,252, 69,174,102,192, 11,231, 11,108,  0, 98,  0,103,  0,
119,235,140, 35,105,187, 53, 38, 25, 36, 17,154,207, 36,107, 82,109,219, 14,183,
 87,179,144, 14,159, 19,254, 17, 88, 42, 22,137,129, 64,197,114,  8, 70,253, 89,
 73, 98,205, 39,240, 26,218,229, 70, 50,244,  7,130, 12,149, 70,185,110, 46,109,
 43, 83, 80, 95,217,129,166, 57, 59, 17,165,122,182,241, 31,252,235, 28,115,235,
175,138,192, 76, 66,231,129, 96,253, 98, 96,233, 68,202,163, 43,175,152,101, 28,
171,205, 41,148, 73, 66,161,  4,124, 45,213,179,203, 90,195,236, 33, 91,180, 40,
155,113, 87,237,198, 81, 39,250,236, 57,185, 50, 61, 29,113,231,145,  5, 87,250,
192, 60,147,247,119,147, 25,167,221,238,252,255,167,169, 52, 77, 19,237,114,215,
187, 50,156, 92,187,139,117,245,218,238, 38,147, 94, 91,187,178, 47,183,101,125,
183, 30,245,164, 35, 14,251,123,229,222,177,242,214, 84,153, 88, 36,173, 97, 76,
225, 47,181,165, 72,  6, 21,245,234,250,187, 32,117, 24,175,106,243,204,249, 55,
 30,100,125,187,190,190, 49,102,157,179,127,221,213,123, 43, 15,185,120,146,186,
144, 35,234, 34, 74,125,129,211,137, 33,133, 13,194,233, 49,207,252,239,109,108,
 24,245,  6, 15, 39,196,  9, 57,192, 79,196,176,124,255,178,173,233,223,173,124,
 45,253,141,  3,  5,165, 72,228,  8,199,188,242, 12,  5,177, 27,118,137, 80, 27,
 39, 47, 86, 63, 81, 28,130,201, 27,211,212, 81,185,220,118, 43, 51, 47, 69,176,
103, 94, 65, 39,126, 89, 16,222,230,219, 23,100,145,204, 54, 43,114, 55, 86, 81,
226,227,177, 94, 85,158,140,217,200, 26,157,220,240, 32, 31, 29,  2,148,173, 39,
233,  0,167, 22,245,143, 71,  1,196,129, 80,168,170,139,179, 50,210,191, 12,248,
119, 33, 89,  3, 61, 12,213, 35,240,153, 91, 47, 65,174,  7,  4,156,219,206,190,
206,193,113,198, 52, 26, 24, 61, 32,142,168, 51,145,124,  4,128,157,160,145, 37,
 51,138,208,136,144, 36,  5, 41,100, 88,  3, 64,132, 24, 67,102, 55,  7,201, 98,
 63, 80,156,107,171,178, 51,142, 24,180,114,176, 32, 86,113,113,222, 29,  0,141,
 43,116, 11,243,216,  0,204,123, 89, 32,156, 76, 76, 34,  4, 94, 72,149,  4,120,
112,226,229,142, 23,162, 58,134,136,179,105, 28,227,137,192,190,128,120, 18,189,
158, 82,129,  1,197,230, 65,245,178,181, 51,249,104,172,201, 71,185, 13,132, 44,
 16,223, 15,  8,  7,  4,  3, 12,168,182,253, 42, 32, 79,161,243,192, 37,244,154,
 33,104,131,192,236,231, 95, 10,224,242,224,246,178,133, 14,143,106,236,126,101,
225, 12, 50, 76,  2,202,  0, 78,232, 46, 38,118,102,181,156,199,120,173, 96,168,
128, 45,129,215,128, 20, 38,184,  6, 55,131,184,187,128, 61,181,135, 69,151, 79,
134,  1,145,102, 48,156,195, 99, 14, 39,110,242,115,214,101, 60, 73,154,  0, 31,
 34, 64,248,171, 26,224,220,156, 80,116,120,  5, 83, 65,  0,233,246, 71,141,108,
129, 91,  1, 97,200,127,223,148,233,214, 56,240,255,101, 87, 75,167,122,189, 53,
199,  4,225,102, 52,139,233,183,255,141,207, 57, 82,178,198,108,194, 52, 25,243,
239, 36,190,  8, 57,102, 93, 62,106,128,141, 53,140, 94,176,161,179,219,179,146,
180,126,235, 38,  6,112,198,224,  3,103,202,203,  9, 22, 26, 21, 53, 43, 10, 63,
 50,138,237, 22,195,109, 20,204, 84, 23,  7, 99, 55, 10, 89,228,118,244,228, 52,
223, 36,178, 66,210, 17,183,186, 91,224,157,176, 49,106,235,105, 55,218,116,  6,
174,179,105, 62, 42, 51,177,131, 94,155,127, 28, 61,135, 14,189,136,253, 28, 34,
 41, 10,238,
} ;

// ../Source/add/template/GB_add_bitmap_M_bitmap_28.c:
uint8_t GB_JITpackage_36 [1137] = {
 40,181, 47,253, 96, 78, 16, 61, 35,  0,230,170,130, 40,208,208, 88,  7,248,109,
236, 91,186,252, 34,208, 23,224,162,195, 96,127, 56,155, 36,210, 44,222, 47,198,
166, 59, 59,246,196, 59,101, 59,200,213,176,  2,191, 23,124,  0,113,  0,121,  0,
 16,202,163, 55,108, 90,248,202,109,170,209, 92, 59,195, 60, 26,215,198, 40,195,
 99,226,178,129,100, 29,186,141,219,225, 56,111, 24,212,225, 28,  7,255,  8, 40,
 18,202,195, 96, 34,161,124,194,164, 63, 76, 67,243,114,  8,188,198,150,187, 15,
133,248,123,128, 12,113,179,243, 42, 84, 26,223,105, 31, 58, 83,208, 67,116,219,
106,108, 17,136,197,143,127, 28,  7,210, 34,240,101, 94,253,250,139, 20,180, 16,
 50,  0,150,235,149,  3, 74, 70,218,249,201,148, 35,179,108,202,168,240, 72, 36,
122, 68, 34,  1,109,255,242,181,207,114,160,128,131,162,110,169, 46,185, 37, 77,
184, 98, 21, 74,170, 29,205,216,125,100,241,  9,163,121,102, 44, 53,  7,202,122,
195,240,167, 42, 47,  9,103,179,239,150,229,  7,164,157,107,110,218,127,126, 48,
230,181,  0,213, 51,154,159, 43,141,175, 96,214,109,185,255, 63,138, 56,162,  8,
130, 33, 55, 47, 40, 99,160,155,113,131,184, 25,250,237, 45,211,126, 86,231, 95,
238,106,214,185,246,167, 57,251,233,176,223,238, 25, 76,127, 69,146, 87,164,209,
172, 94,178,203, 18, 74,138,141,230,106,204,117, 71,228,246,175, 54, 23,122,192,
237,163,119, 39, 55, 49, 44, 47,233, 27, 77,135,169,180,127, 25,240,175, 67,231,
  5,106, 24,102,110,206, 41,120,235, 83,231, 81,169, 33, 34,225,  1, 35,145, 32,
231,229,  2,165,230,  1,163,117, 86, 53,250,199,129,210,161,228, 68,133, 91,159,
207,242,224, 29,250,145,174, 89,233, 11,152,140,132, 72, 80,176, 84,183,254,247,
 54, 42, 38,189, 65,131,129,192, 64, 56,192,141,244,224,153,255,178, 26, 81,212,
209, 65, 81,147, 56, 55,203,205, 78,140,156, 79,147, 91, 24, 61, 69,169,165,122,
188, 93,198, 58,244, 45,123,222,212,233,208,188, 89,192,250, 53, 77, 40,251,222,
243,200,104,165,195,141,231,111,139,210,163,220, 58,152, 78,158, 87,145,226,181,
206,190,183,252,172, 82,205, 82,253,213, 47, 42, 44,147,135,209,207,172, 26, 89,
164,  8,224, 74, 77,174, 58, 70,165,210,211, 50,222,122, 99,148,195, 81,102,124,
169,230, 17,200,184,118,152,132,154,183,126, 97, 43,206,  9,129, 11,168,225, 41,
 50, 51, 34, 34, 35, 73,146,100, 89,  3, 65, 12,162, 48,167,177,156, 30,210,136,
 80, 74, 50, 16, 75,128,136, 35,  4, 17, 66,  8, 18,136, 40,161, 36, 73,145, 20,
 36, 15, 92, 73, 13, 21,122, 90,193,203, 16,144,163,109, 40, 85,148,193,231,187,
100, 61, 68, 97,185, 66,169, 20,124, 31,163,162, 40,155, 72,254, 89, 85,179,252,
169,136,125,200, 72,224,174, 49,198,121,113,191, 21,158,100, 75, 66, 81, 36,  0,
 33,159,181, 39,105,224,118,170,191,  2,114,235,144,216,166,147, 23,187,241,109,
 34,252, 16,128,247,236,166, 22,124,156,238, 21, 84, 53, 73, 94, 15, 12, 76,252,
200, 67,176, 90,165,245,187, 11, 10,225,121, 55,157, 66,170,253,132,177,255, 83,
167, 18, 61, 38,248, 12,247, 83, 44,104, 89,156,142,217,212, 38,110, 89, 37, 89,
 25, 25,238,247, 48, 71,214,131,148,  0,144, 78,227,237, 73,121,113,  4,241, 16,
 66, 35,253,136,226, 18,241, 70,249,163,178, 15, 40, 68,  4,163,206,250, 69,101,
232,217,224,157,208,250, 95,243,134,139,208,  2,152,235,179,148,205,177, 22, 55,
180,194,157, 27,152,234,168, 67,210, 93, 18, 91, 53, 39, 18,142, 55, 24,161,133,
  5, 57,147,159, 23,155, 57,128,251,  8, 42, 27, 47,240, 39,150,115,251,113, 68,
191, 20,193,150,245,170,104,168, 55, 80,121,222, 73, 89, 42, 66, 18, 10, 21,210,
104, 28,145, 58, 63,196,128,  6,246,145,  8,157, 13,218,  3,107, 86,116, 65, 33,
162, 65,117, 20, 16,  0,248,255, 99,132,  0,237, 78,161,128,171,167,  3,215,223,
138, 70,117,166,246, 94,109,113,243,239,123, 52, 39, 57, 46,110,116,254,236, 80,
117,134, 87,103,126,  7,232,111,102,227, 11, 67,104,243,171,132,209,212, 64,205,
 97,138,170, 28,  9,195,204, 52,147,124,  7, 42,120, 58,  3,120, 51,228,200, 37,
 87, 67,155,214,250, 21,145,225,110, 49,251,252,192,238,151, 28,136,126,112,  8,
116, 13, 24, 19, 56, 34,254, 28, 39,151,187,141,251, 61, 47,  4,140,130,118,179,
 46,137,182,116,210,  7, 47,201, 64, 95,191,151,185,109,220,193,239,102,245,227,
100,235,174,  3,190,112,107, 28,132,190,153, 70, 63,215,124,142,150,190,146, 57,
190,110, 86, 76,199,164,232,176, 60,181, 69,150,165,233,  2,216,105,238,188,160,
  0,184,178, 51,233,  5, 79, 23,152,  7,249,229, 26,231,191,103,116,246,215, 60,
192, 88, 22,222,131, 84,142,125,230,121,236,148,  8,108,166, 27,237,233, 57, 21,
227,240,240, 96, 71, 35,106, 85,167,120, 63, 90,158,167,180, 18,116, 18,140, 23,
106,241,153,166,210, 46,167,172, 57,225,198,218,  3,161, 33, 55, 77, 84,101, 38,
185,228,157,117,146, 83,186, 78,191,254,250,137, 51, 41,109, 29,  3,
} ;

// ../Source/add/template/GB_add_bitmap_M_bitmap_29.c:
uint8_t GB_JITpackage_37 [1138] = {
 40,181, 47,253, 96, 78, 16, 69, 35,  0, 38,107,131, 40,192,208,170, 14,248,125,
236,107,162, 11,184,  8,203, 38, 55, 85,207,249,123,221, 70,125, 48, 44,116,119,
 57,171, 37, 23, 41,198, 93,112, 93, 69, 65,144, 13,102,125,  0,114,  0,122,  0,
 18,  8,229,209, 92, 54,109,124,229, 54,221,104,174,173,101, 30,141,107,103,180,
225, 49,129,225, 64,180, 14,221,198,253,112,156, 57, 12,250,112,207,139,135,  4,
 20,  9,229, 97, 48,145, 80, 62,101,210, 33,166,161,137, 57, 36, 94,131,203,223,
135, 66, 28,118, 98,131,197,217,121, 23, 42,141,239,180,157,206, 20,212,137,110,
 91, 13, 46,  2,177,248,241,208,243, 64, 91,196,130,154, 91,126, 29, 90, 84,172,
 18, 52,  0,151,235, 21,  4,138, 70,218,249,201, 20,147,154, 54,165,181,240, 72,
 36,122, 68, 34,  1,109, 15,243,181,207,114,160,128,131,162,126,177, 92,242, 74,
154,112,205, 42,148, 84, 63,154,179,251,200,226, 83, 70,243,204, 88,106, 15,164,
 53,151,225, 79, 85, 94, 18,214,102, 95, 46,203, 15,104,187,215,222,180,255,252,
 96,204,107,  1, 44,215,104,126,174, 52,222, 98,105, 31,151, 91,243,255,143, 34,
142, 40,130, 96,203,155, 23,148, 51,208,205,184, 65,222, 12,253, 54,151,105, 95,
171,243, 48,127, 85,235, 92,251,211,158,253,124,217,239,119, 13,166,191,162,216,
 21,109, 84,171,151,252,178,180, 36,  5,103,115,221,106,236,117, 71,228,246,176,
182, 23,122,192,237,225,157,222,204,176,188,164,115, 54, 31,166,210, 30,102, 88,
135, 30,138, 97,226,166,193, 58,245,201, 89,111,190,250,228,129, 84,114,136, 80,
232,100, 36, 20, 36,134,193, 68,185,233,100,182,214,234, 70, 15, 49, 75,186, 37,
177,234,216,179, 60,184,135,126,164,111, 86, 58, 67, 70, 35, 33, 20, 22, 46,150,
 87, 63,132, 27, 53,147,238,176,201, 64,100, 32, 30, 34, 71,118,120,230, 67,173,
  6, 81,212,209, 65, 81,147,142,152,123,230,198, 60,143,113, 82,113,154,188,202,
232, 41, 74, 47,150,199,251,229,172, 67,231,114,  7, 39, 79,135,230,205,  2,213,
175,105, 66, 89,  8, 97, 39,163,229,116,135, 92,148, 30, 37,231,193,148,203, 83,
  7, 43, 82,252,246,217, 55,151,175, 85,186, 93,222,117,183,252,162,226, 50,129,
 25,253,204,170,161, 69,138,  0,174,212,244, 48, 42,149, 93,203,248,234,157, 81,
 15, 71,153,241,165, 91, 39,144,113,253, 50,  9,133,189,250,133,173,120,129, 10,
168,209, 45, 50, 51, 34, 34, 35, 73,146,100, 89,  3, 65, 12,130, 48,231,173,156,
 30,210,120, 92, 72, 82, 12, 74,160,136, 36,132, 32, 66,  4, 70,112,164, 36,160,
 72,153,  5,105, 27, 76, 73,165,149,121, 90,185,203, 94,  0,163,217, 40, 42,160,
 48,234,225, 14,197, 46,130, 15,148,138,218,123,146, 76, 20, 69, 19,109,125,190,
 48,203,110, 43,242, 65,122,188,226, 34,169, 75,105, 90,240,131, 54,127, 61, 74,
209, 20, 74,184,118,142,  3,211, 78, 21, 25,240, 91, 39,147, 85,255,134, 83, 94,
174,228,153,186, 73, 99,205,  5,134, 10,152, 15,242, 41,108, 65, 65,147,164,191,
165,173,126,236,  8,137,105,118,107,111,151,209,227,124, 47, 79,173,184, 61,210,
236, 77,142,179,129,126, 62,188,135,251,185, 27,180, 46, 62, 98, 20,214,244, 90,
182, 73,150,  4,246,254, 84, 39,112, 61,112, 73,128,210, 88,222,163,148, 19, 71,
112, 15,209,106,217,145, 80,151, 48,157,159, 63,253,250, 86, 66,152,107,234,197,
 46,120, 71,143,167,220,189, 54, 18,219,188, 88,228, 54, 48,105,102,225,154,115,
 45, 53,105, 37,219,236,154,246, 58,252,255, 80, 26,118,102, 43,224,140,196, 17,
 13, 46, 18,124,205,126, 82, 54,223, 21, 46, 37,128, 41, 53,204,159, 96,  3,110,
 34,127,212, 55, 40,203,  8,164, 80,198, 10,181,231,214,159,133, 19, 91,160, 36,
152,246,228,101,166,182,130,167,104,117, 62, 20,195,103, 83,241, 12, 57, 43,154,
128, 16, 61, 57,159, 98, 92, 32,238, 15,131,144,137,201, 40, 68, 84,131, 16,119,
128,135,143, 69, 71, 73,146,234,142,178,176,243,178,235,125,167, 88, 60,223,  0,
253,148,160,237,155, 40,218,204, 78,208, 49,179, 73, 12, 35,180,  9, 30,115, 91,
199, 57, 31,229,154, 76, 74,179,166, 52,207, 91,149, 82, 14, 92, 17, 33,106,249,
 93, 47,235,186,173,101,127,145,200,243,183,209,253,231,234, 69, 26, 51,250,185,
113,214,  5, 97,197,113,180,255,112, 38,200,119,166, 55, 85, 14, 26,152, 14,237,
178, 46,110, 87,234,230,132, 65,119, 64,206,161, 60,249,150,121,226,184,149, 95,
191,  2,127, 26, 96,251,145, 86,120, 26,111,133, 62, 77, 87,191, 30,158,  7,145,
 94,243,172, 81,247,137, 51,120,146,129,240,153,218, 49, 11,231,200, 61, 84,193,
142, 92, 89,  0, 80,217,184, 52,179, 63, 26,166, 73,152,120,  5, 23,191, 11,116,
102,212, 60,197, 88, 86,238, 65, 84,234, 63,131,247, 12, 21, 77, 54,175,138, 86,
247, 92,140,113, 68,240,160,161,208,112,138,113, 71, 23,120,118, 43,180,147,  8,
108,161,132,207, 95, 42,201,229,212,197,249, 53,162, 22,168, 71,114,211, 52,149,
153,248, 75, 41, 90, 39,229, 75,151,234,215, 65, 63,101, 74,122,176,198,
} ;

// ../Source/add/template/GB_add_bitmap_M_sparse.c:
uint8_t GB_JITpackage_38 [1478] = {
 40,181, 47,253, 96, 57, 24,229, 45,  0,214, 57,168, 39,208, 84,113, 14,104, 43,
122, 89, 89,174,143,100,217, 75, 27,185,203,152, 36,231,187, 97,131, 55, 99,153,
 56, 18, 60, 83,145, 50, 45,114, 53,  3, 94, 56, 95,159,  0,149,  0,160,  0,239,
109,216,133, 97,124,165,203,239,117, 95, 37, 91, 34,124, 87, 87,155, 17,251,  8,
220,115,104,179,195,181,190,153, 42,100,141, 31,237, 83,180,207,137, 12, 44,152,
  2,206,172,149,211, 25, 38, 55,214, 21,242,213, 41, 96, 10,217,234,138,130,141,
135, 11,203,197,161,201,148, 49, 78,107,230,209, 24,127,111,186, 75,192, 24, 96,
 10, 22, 14, 12, 48,167, 88,210, 29,237,208, 62,220, 50,125, 36,171, 81,235,140,
 59,207, 84,177,201,228, 78,  9, 15,215,222, 60,145, 69,106,209,250,  5,247,147,
229, 72,118, 57,117,119,206,221,166, 50,105, 28, 40,128,  6,206, 25,152,206,149,
180,162, 42,185, 90,237, 79,117, 93, 91,109, 36,126,185, 68,  5,151, 75,167, 72,
244, 90,158, 89,173,180, 13,254,241,123, 59, 87, 94,106,241,171,121,236,148,  2,
 24,130,185,149, 74, 10,162, 91, 97,101, 95,230, 30,176, 43, 16, 87,212, 53,103,
171, 31,165,170, 74,103, 99, 32,130,215, 10, 65, 33, 86,104, 81, 75,156, 76, 18,
235,223,110, 32,252,186,125,106,195,189,163,142,197,195,201,181,174,132,253, 10,
153,242,148,180,169,243,228, 44,100,227,207, 71, 30,140,155, 87,166,107, 78,249,
112, 45, 69,153, 83, 42, 16, 93, 74,122,  6,  6,132,199, 51,185,189,181,205, 74,
 97,180, 32,103,245,174, 70,136,117,254,255,155, 87, 62, 93,243,115, 62,227,221,
255, 71,209, 75,162,200, 18,143,194,216,181,105,228, 44,195,114,160,193,156,183,
183,161,172,118,200, 29,108,200,252, 57,221,236, 36, 58,193, 92,243, 14,201,241,
 15,167, 95,209,188, 53,239, 75, 76,210, 84,187, 19,241, 76, 28,170,106,237, 47,
198, 15,111,179, 98, 13,154,171, 53,100,126,205, 41, 57, 99,181, 56,244,172,130,
 28,229,131, 67, 59,107,230,144, 95,232,  4,255,184,230, 28, 73, 57,168,200,142,
115,206,185, 11,242, 93, 69, 73,233,211, 69,149,  1, 33,145,185,203, 40,233, 84,
149,109, 36, 62,104,103,149,  2,114, 12, 82,189, 96, 99, 13,  7, 61,243,103,222,
193,241,168,164, 82,105,120,230,  6,215,252,106,137,114,224,172,214, 22,142, 92,
 18,191,237,226,204,162,  1, 81,116,114, 98, 48,227, 21,187,174,213, 79,202,133,
 81, 86, 26, 37,220,144,248,104,230,209, 90,164,119, 20,165, 43,191,179,138,240,
225,210,218,161,155, 22, 25, 70,172,165,207,248,233,147,179,218,220, 27,  8, 79,
201, 21, 32,162, 30,113,174,197, 25,169,204,191,217,208,174, 38, 73, 19, 69, 17,
214, 23, 84,160,111,177,132,205,221,227,147,229,103, 85,212, 25,118,128,101, 65,
192, 84, 23,174,251,164,198, 53,224,124,109,207,130, 89,141,159,243,220,205,192,
192, 41, 21, 21, 26, 17, 55, 49,249,197, 68,101,116, 54,149,167, 83, 77,210, 43,
 32, 44, 48, 32, 40,170,140,206,  4,198, 23,214,  2, 32,186, 26,221,222, 88, 95,
 81,227,252,150, 23,129, 89,168,193, 37, 67, 52, 35, 34,146, 20,164,160, 80,104,
 12, 97, 12, 66,144,148,152,170, 59,114,168, 52,206,225, 16,101,144, 53,  2, 69,
  8, 17,136,145, 64,  2,137, 36, 26,  9, 37, 32,173, 27,102,148,156, 32, 71,  3,
205,166,255, 36, 23,251,244,226,158, 45,205,211,251,120,103,209,175,211,204, 22,
139, 24,103,195,250,166,163,185,205, 90,118, 77, 15,113,154, 13,255, 76,183, 97,
153,161,218,185, 51,204, 86,254,165, 39,113,151,149,176,126,236, 44, 85,208, 87,
114, 61, 63,243,136, 69, 71, 43,147,143,131, 42,203,187,241,231, 25,245,152, 41,
153, 62, 53,161,190,151,175, 28, 37,150,195,233, 49,195, 50,160, 88, 44,249, 74,
 61, 27, 58, 71, 46,113,152, 45,217,125, 34,187,178,193, 87,135,233,217,244, 98,
 47,177, 44, 93,172,186, 75, 99, 80, 24,133, 82,  9,145, 97, 76,157, 38,196,  1,
147,181,126, 32,144, 93, 11,237,182,192,179,234, 82,236,145,189,  4,131, 86,143,
219,192, 71,132,109,167,169,142, 84,246, 81, 11,160, 80,193, 57,218,  9, 45,  3,
214,170,  8,174,137, 29, 97,173, 29,142,138, 93, 44,216,209, 98,159, 86,101, 80,
156,  3, 21,240,241,192, 96, 34,229,  8, 94,192, 77, 21,234, 34,178, 34,184,214,
209, 88,207,109,155,216,192,189,172, 65,101, 41, 33, 71,138,165,112, 82,213,153,
 58,161, 70,223,247,250, 21,231,186, 88,163,171,202,215, 92, 32,126, 56,251, 17,
 55, 29, 79, 15,184,  3,133,237, 37,250, 81, 57,115,193,187, 18, 77, 14, 49,170,
252,243,  6,225,  1,235,209,169,129,116, 34,146,151,  9,176, 40,117,  1,  6,220,
  9,163,104,194,170,115, 44,140,163,  0,233,224,178,168, 32, 77, 44, 79, 22,161,
127, 62,188,120,184,108,154,199,245,102,155, 96,240,199, 74,215,  1,177, 53,212,
112, 59,206, 25, 29,187, 78,102,241, 16,237, 34,190, 48,142, 33,103, 31,249,232,
 65,174,254,155, 33,118, 78, 89,100,222,111,166,214, 91, 74,197, 17,161, 27, 99,
 55, 57,168,116, 24,212,114, 19,152, 88,245,202,197, 13,157,113, 95,250, 46, 58,
235,133, 95,203,142,228, 72,241,199, 62,148,185,111, 61,180,113,155,207, 70,202,
227,140,212, 30,154, 41,164, 87,190,172,148, 64, 17,  1,124,182,226,130,106,104,
216,230,109,179,198, 45,227, 84, 32,150,190,198,255, 76,246,220,248, 28,180, 29,
 29, 95,204,189,252,124, 69,228,214,251,187,207, 20,172, 31, 49,233,178,150,193,
118,205, 11,194,184, 68,  9, 20, 84, 18, 40,249, 67,239, 96, 60,131,153,147, 24,
173, 46, 41,204,190, 67,174,179,140,111, 86, 27,108,  8,119, 68, 17,  3,153, 22,
113,113, 70,133,247,245,237,108, 11,145,134, 73,240,239,165, 66,230,176,  6,178,
214, 80, 57,182,243,195,182,198, 88, 14, 44,  0,226, 36,179,208,162,244,139, 74,
215,135, 32,102,145,189,199,140,129, 71,170, 41,155,113,175,255,206,220,118,122,
 64,203,201,236, 42, 20,  8,145,193,235,148, 68,139,205,136,241,170, 97, 65,172,
170, 64,198, 21, 67, 91,180,224, 16,157, 55,196,115, 17,166, 92, 20,186,244, 36,
128,232, 29,224, 17,231, 18, 82, 92,184,128,241,233,205,214, 75, 59,158,  1,208,
 47,220,206,  2, 40,170, 93,142,  0, 42,236, 34, 63, 23,200,101,162, 89,242, 65,
168,195, 29,152, 58, 14, 95,149,236, 23,120,  7, 59,158,249,192,  8, 36,242,160,
  9,152,107, 35, 67, 52,123,192,188,163,122,217, 99,245,133,125, 74,241,  2, 50,
 43,231, 43, 69, 74,  3, 40, 77,185,157,242,141,118, 34, 21,205, 55,205,253,  7,
 38, 86, 39, 28,207,175,214, 59,162, 23,157, 39,129, 87,169, 99,117,  2,
} ;

// ../Source/add/template/GB_add_bitmap_M_sparse_24.c:
uint8_t GB_JITpackage_39 [835] = {
 40,181, 47,253, 96,148, 11,205, 25,  0,  6,229,113, 40,208,178, 88,  7, 42,121,
236, 91,186, 77,  9,254,197, 94,240,220,246,164, 35, 98,133, 84,248,230, 22,152,
 26,  8,130,120,163,156,246,  1, 95, 60, 40,114,127,  1,106,  0, 99,  0,100,  0,
 85,198,233, 48,161,200,116, 40,152, 12, 93,137, 37,196,113,214, 50, 38,196, 41,
125,119,  6,150,138,101,130, 64, 80,177, 60, 18,165, 59, 60, 67,157, 57,229,189,
 67,203,219,103, 70,220,121,158, 67,165,217,190, 13, 23,143,204, 19,228,137, 40,
  5,101, 83,229,222, 49, 87,218, 14,109,250,230,238,214, 93, 37,121,212,194,  6,
 64,193,250,165,192,  2, 37,190,109, 49,220, 64,219,159, 60, 47,136, 97, 13,171,
134, 79, 83, 52,153,166, 88,146, 20,132, 73, 45,226, 71, 42,180, 36,140,181,188,
 90,134, 31, 80,253,221,178, 83, 73,105,223,182,183,159,237,253,201,232,107,  3,
 48,199,102,126,174,243,119,187,187, 68,220,  6, 64, 42,176, 96,155,150,229,230,
255, 31, 69, 31, 81, 68,209,242,118, 93,222,126,245,114,149, 31, 73,237,103,139,
199,106,127,131,231,173,168, 66,177, 76,164, 22,219,190, 95,174,156,217,204, 85,
 98,154,137,196,  1,238,122,210, 31,188,170,134,198,100,  6,201,235,181,163,245,
 13,223,109, 87,122, 28,207, 71, 52,220,148,168, 71,233, 25,230, 24,214,226,151,
117,234,241, 25, 38, 40,220, 30,115,234,119,206,163, 70,233, 15, 28, 77,132, 38,
  2,226,117,224,  6,238,124,135, 85,105,239,242,237,140,237, 51, 44, 56,248,144,
 72,174,128,121,229,148, 20,193,180, 67, 53, 94, 36, 82,221,102,142,247,209,197,
 35,113,230,206,  1, 81, 20, 82,201, 91, 61,158,212, 63, 36,241,212,123,157,229,
245, 58,155, 88,181,224,150, 97,  5, 43, 58, 28,235,213,109,218, 17,195,214, 44,
237,  7,137, 25, 16, 66, 48, 85, 73, 67, 23,184,181,164,119, 56, 12, 30,205,  4,
 67, 85, 93, 27,158,240,221,217, 59,142,119,167, 49, 59,243, 56, 14,213, 37,239,
212,173, 95, 31, 24,120, 75, 76,229,117, 16,144,119, 38,243, 32,199,163,201, 36,
150,205,128, 74,122,117,217,  7,128,157,160,161,169, 50, 37, 37, 34, 34, 41, 72,
 10, 82,104, 12, 64,132, 16, 66,119,182,  1,201, 98, 31, 44,154,183,177,130, 78,
 22,241,199, 42,100,  2, 95,178,227,182,211,192,158,157,208, 22, 51, 20,104, 27,
195,181, 63, 14, 38, 52,193,185, 76,132,194,205,164,196, 66, 64, 30, 47,119,188,
  8, 53,102, 25,124,173,217, 18,170,241,139,208,154,152,120, 33,124, 33,221,  2,
 35,148,109, 52,213,220,117,179,251,192,104, 38, 20,233,165, 16, 25,100,240, 17,
216, 10,  2, 48,176,240, 58,237,171,134, 60, 69, 78,246,  2,225, 45, 12,163, 13,
 25,102, 38,223, 74,129,174, 71, 28, 59,187, 16,192, 17,237,234, 87, 86,230,191,
210, 37,178, 10,124, 65,127,221,146, 80,204,187,199,236,129,104,115,  3,  5, 54,
  0,184,134,161,187, 50, 13,196,155,  6, 90,211,225,112,235,114, 51, 96,240, 96,
 38,211,156, 65, 33, 45, 85,208,229, 84, 30,129,212,126, 44, 80, 62, 59, 70, 86,
 13,114,238, 78, 29,218,117,  9, 64,145, 44,  1,153,147, 78, 68,217, 98,216, 67,
132,196,191, 56, 99,154,  2,165,161,252,170,123,181,252, 20,159,183,240, 80, 60,
126, 70,179, 48,141,248,207,228,105,230,244,150,147, 95,142, 44,204,244,157,128,
 47, 66,  7, 86,204,101,218, 67,227,230,136,139,123,  3,110,218, 47, 18,  9,252,
  9,192, 10,124,224, 57,133, 39,213,168,173, 22,124, 71,248, 34, 46, 24, 66, 18,
210, 19, 11,154,132, 51, 43,143,168, 51, 35,107, 69,216, 33, 12,131,146, 90,155,
105,113,145,  2, 55, 48, 26,108,196,132,235,108,154,157, 63,152,108,133, 47, 74,
 10,216, 73, 68,232,113, 93, 49,198, 73, 62, 40, 69,175, 24,
} ;

// ../Source/add/template/GB_add_bitmap_M_sparse_25.c:
uint8_t GB_JITpackage_40 [1081] = {
 40,181, 47,253, 96,  4, 15,125, 33,  0, 38, 43,131, 40,224,208,232, 24,248,189,
 18,180, 60,171,193,207,242,134, 75,250, 13,146,129,170, 11,201,126,217,148,179,
169,140, 12,126,254,166,121,154, 48, 67, 74,140,  9,  1,124,  0,115,  0,122,  0,
145,199,196, 65, 55,108, 98,120, 74,166, 85,171,251,210, 12,227,160,250, 82,172,
 46, 56, 32, 44,155, 71, 70, 67,153,106,218,112,189,183,138,218,112,107,225, 95,
193, 36, 50,113, 28, 72, 34,147, 79,152,244,167,107,104, 90,254,128,199,216,118,
199,213,206, 31,  7, 46,196, 13,207,124,161,112,232,174, 22,156,200, 90, 11, 13,
  2,255, 50,197, 24, 27,228,241,101, 94,253,250,139, 20,180, 18, 50,  0,149,235,
148,130,137,164, 58, 79,172,101, 70,226,201,237,234,145, 89, 54,101,188, 28,  2,
137, 28, 16, 72,115,255,101,151,226,191,157,241,183, 36, 48,208,160,168, 87,170,
 71,110, 73,147,182, 51,116, 49, 10, 37,221,174,110, 44, 63,154,248,132,213, 61,
183,150,168,181,200,232,134,233, 79, 87, 94,146,206, 38,205,219,150,156,197,213,
110,169,181, 51, 79,124,204,117,159, 92,197,204, 56,160,122, 86,247,247,173,207,
221,225, 31,101,122, 25,  0,169, 96,146,117,219,166,153,255,127, 20,105, 68,209,
 35,254,193,125, 41, 71, 45,230, 58,236,217,157,215,245, 25, 93,127, 69,  1,185,
106,160,129,173,111,135, 81,243,145, 86,179,123,201,110, 75, 40, 35, 54,154,139,
106, 75, 55, 32,239, 82, 27,186,192,241,163,151,167,157,152,150,151,244,141,166,
211, 85,226,191, 11,248,247,169,211,  2, 53, 11,115, 83,207, 41,120,235,211,231,
 85,137,193, 65,129,131,121, 80,144,211, 98,129, 82,195,193,104, 52,187, 90, 13,
168, 62,225, 63, 15,148, 14,165, 39, 94,110,125,126, 75,132, 91,167,192, 18,247,
 92,210,181, 74,117,235, 47,227, 98,210, 25, 52,152, 14,166,211,  0, 55, 18,164,
  3, 81,180,177, 65, 81,146, 24,231,134,237,140,124,254,106,140,158, 75,110, 85,
 88,245,122,170,222,122,173, 84,191,245,152,187,141,209,208,183, 13,122,211,167,
 59,213,153,134,102,222,  3,214,175, 73, 66,225,247, 30, 72, 70, 44, 29,110,100,
 71,225,  2,250,219,162,244, 40,183,143,174, 19,232, 81,164,120,173,195,167,219,
126,118,171, 86,169,254,234, 20, 18, 21,201,195, 42, 55, 47, 70, 22, 39,  3,250,
 82,211, 86,175,184, 85,130,168,140,183, 78,177,106,117,148, 91,  7,128,243,168,
241,169, 50, 52, 34, 50, 83, 80, 80,170, 52,  6, 48,132, 24, 83,102, 52, 15,210,
136, 68,139, 66, 24, 73, 40,137,128, 17, 67,  8, 65,130, 19,  8, 74,102,162, 22,
 85,  7, 44, 67, 28,122, 30,216, 10,217,  0,144, 20,242,123, 80,141, 11,  9,253,
 57,  0,126,160,162,183, 16,237,167, 59, 32, 82,182,172,186, 88, 64, 28,114, 29,
174,172,111,132, 32,210, 92, 20,202,189, 48,156,188,173,185,176,168,248, 43,182,
 37,150,164, 35,198,214, 13, 24,  6, 19,216,240,254, 70,  2, 46, 85,128, 83,136,
 70, 30,222, 21,102, 26,156,201,201,234,136, 56,178,123,105, 29, 33, 24,139,133,
140,132, 54,  8,123,195,178,236, 20,132, 98,241,126,173, 92, 75,  4, 73,173,144,
179, 31,202, 84,143,122,103,116,245, 28,101, 82, 32, 52,162,234,  1,  5, 52, 33,
129,126,227,179, 20,195,247,135,168, 18,175,156, 95, 28,163,224,176, 55, 67, 91,
 75, 86,175, 34, 30,212, 33,117,118, 95,206,  7, 78,224,108,234,124,192, 81, 34,
224,207,251,195, 44,117,206,  9,155, 30, 56, 80, 33,129,146,204,140,  2,170, 57,
 88,226,127,148, 75,129,214, 68,115,110,124,220,166, 25,  9,164,172, 56, 50, 64,
 73,138,106,143,187, 19,178, 80,132, 36, 84, 26, 81,114, 78, 71,234,  4,200,  3,
138,241,  3, 23, 61,237, 78,159,215, 73,120,194,194,140,100,145,248,150,  2,150,
255, 34, 73, 76, 64,167, 46,184,106,134, 64, 32,106,223, 68,156,212,223, 61,  0,
248,136,188, 44, 81,252, 12,  2,194,183, 80,135,102,179, 15, 86,220,192, 10,108,
124, 74, 52, 50, 53, 25,205,195, 29,117,142,  4, 78, 51,250, 50,116,119,162, 28,
 15, 37, 56, 58,192,196,197,173,200,246,145,250, 49,173,165,187, 95, 59,146,216,
118, 67,126,204,159,225, 86,183,193,220, 88, 38,204, 51, 60,185,152,202,223,187,
192, 48,109,116, 36,246,176,104,159,239, 40, 36,230, 76,148, 52, 50,158, 47,254,
213,253,169,192,196, 14, 16,  6, 69,227, 74,154,207,244,247,221, 79, 63, 60, 74,
229, 46,179,181,101,223, 19,125,130,105,225,144,182, 22, 86,129, 33,  7,236, 52,
241, 95,194,  1, 10,216, 99, 73,126,124, 80, 56, 96,136, 18,229, 81,170,114,167,
145, 85,244,127, 51,  5,153,117,196,161, 59,154, 22,110,120, 14,147, 90,  8,201,
 91, 64,220, 78, 45,140,198,218, 52,106,130,146, 55, 72,201, 36, 65,185,105, 82,
127, 48,137,202,230,149, 38, 89, 39,249,205,107,231, 57,153, 36,127,149,210, 64,
 30,
} ;

// ../Source/add/template/GB_add_bitmap_M_sparse_26.c:
uint8_t GB_JITpackage_41 [1085] = {
 40,181, 47,253, 96,  2, 15,157, 33,  0,  6,235,129, 39,208,208,234, 24,248,189,
 20, 59, 43,165,218,117, 57, 23,124,148,226, 76, 41, 65, 67,202,230,215, 71,235,
 39,102,118,150,250, 43, 90,228,106,  6,252, 96,150,124,  0,114,  0,119,  0,143,
137,163,110,116,230,120,202, 87,173,102, 55,174, 25,198, 81, 53,174,212, 46, 56,
 32, 44,155, 71, 86, 63, 95,213,181,225,122,111, 21,182,225,247,198,195,130, 73,
100,226, 56,144, 68, 38,151,104,116,168,237,103, 90,254,136,199,216,182,215,217,
206, 33, 39, 46, 88, 91,158,223,133,194,169,219, 90,112,160,123, 45, 52,136,117,
248,213,140,177, 65, 30, 97,230,212,175, 67,107,138, 85, 66,  6,160,114,157, 98,
 48,145, 85,127, 51,107,153,145,121,118,219, 98, 50,203,166,180, 46,135, 64, 32,
  7,  4, 18, 13,113, 35, 57, 61,247, 97,134,107, 62,220,223,220, 58,127, 75,  2,
  3,141,105,122,133,122,228, 85, 36,233, 59, 63,152, 82,166,  8,123,118,211,239,
208,196, 37,106,247,220, 58,170,215, 34,171, 27,213,151,176,188, 34,157,205,250,
109, 91,118, 22, 88,251,173,247,206,111,230,231,206,251,236, 42,230,151,  3,168,
103,118,127, 99,251,207,123,230,109,187,102,254,255, 16,164,  1, 65,143,120,104,
109, 92,187,122,115,231,209,103,120, 94,219,103,180,253,  5, 69,  2,  3, 91, 99,
143, 78,216, 33,205,102,248,146,222,150,150,140,216,104,174, 91, 85,223,186,  1,
121, 62,196,245,126, 46,240,124,248,205, 59,169,150, 87,244,141,198,211, 86,230,
195, 11,235,208, 99, 49, 75,212, 44, 88,159, 62,183,124,231,171, 75, 30,104, 35,
  6,  7,  5, 14,230, 65, 65, 98, 22, 75,148, 26, 14, 70,171, 25,214,108,  0,117,
 41, 31, 98, 86,116, 75, 98,214,229,213,177,111,137,240,234, 20, 89,226,216, 21,
 93,171, 60,159,122,117,152,129,105,116,  6, 13,166,131,233,  4, 16,180, 49, 77,
146, 24,119,157,187, 98, 49,226, 57,180,143,113, 78, 81, 66, 41, 74,221,126,178,
213,109,133,250,171,199,207,219,180,126,190,109, 14, 74,158,250,153,223, 30,168,
126, 73,146, 41, 67,  8, 57, 25,243, 70,118, 20, 46,220,225, 22,163, 71,185,121,
180,221,182,196, 65, 74, 20,175,121,249,117,219,207,176,213, 42,231,184, 83,167,
144,168, 72, 32,181,221,196, 24, 89,156, 12,104, 44,227,167,121, 43,176,149, 92,
149,241,213, 43,181, 87, 71,185,245,103, 53, 46,128,246,168,  1, 42, 26, 26, 17,
145, 20, 20,164, 36,133,198, 48,132, 16,163, 24, 82, 30,146,128,104,146,164, 24,
150, 17, 32, 35,128,196,  8,  8, 81,130, 19,204,  4, 18, 86, 20,163,234, 27, 67,
 14,  2,226, 60, 61, 21, 18, 10, 60, 20,210,229, 10,209, 66, 54, 31,108,207, 98,
 87,136,101, 33,229,251,167,136,136, 68,247, 73, 41,197,208,122,126, 57,230, 18,
 33,162,225,242,149,227, 48, 56,121, 59,184,176,251,184, 93,116, 53,137, 19,235,
 78,159,  8, 22, 11,250, 77, 62,198,213, 61,216, 96, 26,225,114, 19,156,111, 68,
 35,221,114,199,108, 12,103,203, 92,151, 91, 55,229, 43,227,136, 56,207,218,200,
 18, 90,209,177,  7, 47,203,206, 65, 12, 86,204,172, 41,181,196,146,252,199,224,
189, 82,152,135,215, 53,171, 59,113,108, 75,  1,228,200,231,  1, 37,241,237, 36,
 36, 18,191,239, 52, 75,123,125,189, 17,206,243, 14, 49,139, 97,164, 48,241,206,
215, 56,102,201,101, 17, 91,234, 16, 48, 19,136,220,  8, 78,201,217,120,  9, 67,
199, 41, 25,248,128,109,161, 47,161,229,225,232, 24,161,193,148, 96,120,110,182,
 15,170,141, 88, 18, 96,147,114,143,229,196, 77,176,184, 57, 35,  4,212,172, 24,
153,160, 94,146, 21,154,141,227, 44, 72, 66, 18, 42, 35,163,164,221,107,170,106,
152, 17, 74,229, 79,100,126,106,244, 49,203, 19,197, 66,127,140,101,145,249, 94,
  7,246,240,139, 71, 81,154, 78, 13, 32, 46, 18,168, 46,225,183, 47, 34,129, 55,
158,  0, 65,124,170, 36, 80,166,205, 75, 13,155,103,125,  1,207,156,217, 11,132,
218, 54,102,199,137,215,133,250,  7,146, 46,147,119,173,129,152,  5, 92, 57,238,
131,129,141,244,117,254, 23,199,218,117,103,237, 15,148,162,200,251,185,163, 46,
 22,167, 41, 45,219,141, 83, 87,204, 94,129,204,139,135,110,154, 52, 33,221, 91,
  0, 37,155, 29,137, 43, 44, 90,253, 45,157,140,238, 73,185, 90,  6,123,149, 89,
 89, 60, 13, 55, 23, 28, 92,131, 47, 68,203, 76,215, 95,124,158,197,150, 84,105,
153,195,163,236,104,126, 78,102, 64, 24,193, 26, 58, 68,134,104,109,223,215, 97,
  0, 54,123,151,196,241, 43,143, 85, 50, 40,155,154, 59, 41, 76,210, 80, 43,179,
159,249, 99,172,172, 24, 19,  9,134,100, 14,121,  6,133,193,113, 49,122, 45, 88,
 82,183, 73,242,112,146, 31,106, 87,107,116, 67, 91, 24,168,162,161, 75,153,  8,
 61,155, 38,244,  7,211,168,108,169,244,243, 57,137,111,190,244, 60, 22,147, 36,
132, 82, 26,200,  3,
} ;

// ../Source/add/template/GB_add_bitmap_noM.c:
uint8_t GB_JITpackage_42 [476] = {
 40,181, 47,253, 96,103,  6,149, 14,  0, 54,212, 65, 33,  0,211,230, 87, 31,107,
 24,153,192,129,104,196,223,213, 65,220, 37, 52,225,154,177,253,237, 20, 14, 22,
118,210,255,111,255,161,  4, 57,  0, 56,  0, 53,  0,155,203,120, 69,207,  1,203,
 12,  6,115,159, 54, 26,169,224,120, 73, 71,162, 51,121,199,173, 75,172,217,102,
 61,153, 57,253,116,236, 83, 29,208,  5,246,132, 36, 35,218,241, 98, 74,108,177,
158,119,109,117,220,178, 38,101, 89,  1,150,232, 25, 31,155,132,234,162, 26,236,
238, 72,159, 32, 27,127,184, 20,219,203,168,206, 98,119, 56, 66, 85, 24,148,202,
235, 13,217,185,181,231, 18,188, 96,237, 97, 72, 63, 29, 46,194, 69, 33, 10,132,
235, 82, 23,125,202, 56, 16,203,101,143,175,189, 15, 11, 42, 64,113,169,222,227,
177, 25, 91, 26,157,211, 26,219, 70,115,245,250,193,233, 23,199,110, 89,255, 63,
103,103,206, 42, 12, 53,223,155,188,226,233,201,  6, 75,220,147,191,146,  2,115,
126,126,  8,250,240,252,176, 39, 26, 58, 95,100,143, 28,208,154,194,254,  4,186,
170,112, 89,171,203, 27,142,152, 46,  3,111, 79, 19,118,162, 39,222, 83,169, 66,
208, 41, 84,194,101,213,110,153,165,209, 59,145,198, 68,107,  4, 85,160,193,177,
 52, 51, 19, 20,148, 36, 41,148,171,  1, 64,134,136,177,185, 30,228, 36,139,102,
 65,149, 94, 89, 42, 78,138,146,249,104, 30,163,133, 19, 47,145, 84, 88, 56,106,
 70,210,101,120, 67,232, 49,112,  6,181, 72,  7, 68, 93,189, 57, 40,208,248,165,
 98,179,195, 42, 29,227, 68,180,214, 38,165, 14, 76,243, 72,220, 85,171,224,139,
151,249, 52, 44,212,243, 32,105,165,196,112, 61, 50, 92, 62,201,124,185,180,141,
 53,  2,208,172, 76,212, 18,142,244,167, 10,220, 23,230,118,198, 71, 24, 46,  2,
104, 56, 90,220, 59, 75,150,244,131,112,172,160,202,232, 53,163,129,157,225,147,
229, 52,181, 41,  2,135,155, 96, 29,  5,216, 30,190,237, 28,104, 28,179,  6,120,
 89,163,210,130,179,  5, 62,  2,216, 61,208, 71,  3,183,184,148,193, 77, 83, 71,
101, 38,119,  5, 43, 61, 81,148,136, 78,  2, 27, 83,138,  2, 61,
} ;

// ../Source/add/template/GB_add_bitmap_noM_21.c:
uint8_t GB_JITpackage_43 [687] = {
 40,181, 47,253, 96, 19,  9, 45, 21,  0, 70, 93, 92, 32,224,220, 28,  3, 28,146,
176,166,194,249, 74, 52,132, 37, 37, 14,140,171,  9,170,161,225,229,170,140,148,
193, 12,195, 35, 31, 14, 83,  0, 81,  0, 82,  0,182,115,189, 85,169,219,121, 24,
206, 75,134,  2,161, 40, 56, 18,  8,197,  7, 31,119,169,239,171, 82,110,152,143,
169,182,216,186,159, 75,207,196,116,170, 92, 71, 11,196,234,177,102,143,221,215,
229,217,186,131,184,126, 94,222,187,236,  8,115,226, 29,146, 80,208,140,136,105,
174,173,125, 79, 20,  4, 43,237, 44, 63, 28,182,194,225, 16,152,122,156,  6,171,
 29, 85,155,182, 92,248,163,136,122,104,199,154,159, 91,226,107, 43, 85,199, 12,
136, 28,188,251, 27,223, 48,172,114, 94,130,162,106,219,204,255,127,219,102,155,
 29,171,190,247, 54,132, 65, 81,176,170,175,230,121,200,104, 47,234,110,108,193,
 75,193,106,108,191,139, 41,136, 40, 28,  3,104, 95,163,213,  1,153,244,211,252,
228,223, 55,125, 80, 40,147,110, 60, 23,148,  5, 81, 87, 18,249,228,151, 82,134,
 63,238,154,205,229,115,249,116, 38,135,178,116,221,151, 32,182,249,114,143,117,
235,252, 77, 23,141, 25,129,112, 73,228,136, 79,184,129, 14,235, 11,127, 16,  2,
135,197,187,191,241, 91,233,131,239,238,186, 53,103, 67, 23,168, 63,  8,219, 86,
 35,124,222,156,117,219,211,156,168, 11, 98,143,138,155,118,116,196,217,120,239,
198, 26,214, 79,211,170,202, 97,213,128, 46,160,150, 56, 96, 27,190, 30,120,246,
184,115, 54, 21,207, 37, 84,233,186,147,168, 47,205,151,176,121,185,186,149, 82,
230,  6,211,157, 48, 88,201,203,125,187, 64,192, 29,101,117,104, 35,221,105,180,
155,  2,128,132,160,241,169, 66, 52,193, 72, 82,148, 20, 50,172,  1, 64,132, 24,
 83,118,245,201,130,102,128,244, 57, 44, 98,153,139,238,106, 51,  7, 47,235,  4,
143,192, 11,119,168, 68,197, 61, 12,242,153, 20, 15,108,202,  0, 23, 77, 65, 79,
134,154, 86,194,146,154,208,242, 45,115, 42,146, 96, 18, 17, 11, 41,100,187,186,
184,254, 94, 30,229, 67, 12,183, 64,230,131, 90,182, 18,224, 32, 28, 77,139,172,
238, 48,  4,198,170,216, 87,209, 11,168, 50,192,135,  3,156,155,117,210, 34,166,
  2,171,131, 34,199,221, 60,218, 54,148,245, 99, 42, 11,216,172, 16,239,163,161,
  8,117, 40, 89,166,  0,102,107, 19,189,160,107, 64,111,  4, 99, 57, 19, 92,138,
 11, 53, 87, 68,109,128,164,  5,216,161, 40, 73, 62,156, 60, 38,200, 58,100, 56,
  5,251, 87,186,136,  4, 87,188,169,210, 66,147, 27,104, 43,213, 90, 89, 58,241,
183,214,135,  8,  6,  1,196,145,161, 47, 76, 45, 62,243, 60,183, 78, 17,148,153,
100, 44,  9, 78,203, 41,  3, 38,124,204,210, 44,107,  6,  9, 99, 24,112,189, 13,
160,182,189, 69, 18,241, 62,130,113,  0, 11,152,121,206,  7, 15,207,140, 82, 48,
 69, 56,106, 63,160, 40, 11,187, 28, 72,132,204, 22,169, 51, 43,  9,133,142, 66,
 15,122,109, 48,152, 75, 89,185,105,122, 84,102,186, 59,180,194, 27,140,152,  9,
 39,109,131, 41, 69,221, 19,
} ;

// ../Source/add/template/GB_add_bitmap_noM_22.c:
uint8_t GB_JITpackage_44 [1012] = {
 40,181, 47,253, 96, 35, 13, 85, 31,  0,166,231,120, 40,208,176,170, 14,248,205,
 92,124, 51,191,196,247,253, 43,121, 40,253, 41,207, 12,255, 99,172, 47,140,216,
  5,136,162,118,205,143,210, 44,245, 48,232,101, 64,  9,112,  0,106,  0,110,  0,
212, 99,106, 87, 91,120,202,157, 52,163,185, 78, 12,243,152,184,206,139, 46, 60,
 36, 46, 26,  8, 54, 63,119,226,233,112,156,181, 11,234,240,109,131,127,  4,148,
132,122, 24, 76, 36,212,165, 43,250,195,244,211,151, 67,224, 53,180,220,113,244,
225,111,  3, 23,162,102,251, 42, 80, 54, 51, 83,140, 13,116,167,213,208, 34, 19,
223,182,248, 17,254,221,250,139, 19,172,172, 83, 40, 74, 50,116, 85,218,230, 50,
229, 72, 12,107, 25, 21, 30,137, 64,143, 72, 36, 28,211,100,185,125,229,146, 87,
183,145,116,209,220, 25, 71,115,195,192,166,118,225, 72,114, 24,245,183,203,190,
205,109,235, 91,174,123,115, 23,125,173,125,150,  3,  5,185,210,137,183, 89,185,
132,177,158, 87,203, 85, 90,127, 27,245,130,127, 28, 43,186,134,189,184,201, 29,
186, 92,160,204,108, 48,217,196, 50, 10,240,219,189, 50,111, 31, 30,171,125,172,
211,242,100,248,255, 67, 16,  7,  4, 65,226, 15, 49,189,  5, 73, 32,  1,183, 51,
182,216,131, 59,215,169,183,139, 74,165,103,202,248,234,243,162, 27,142, 50,227,
 75, 51,143, 64,198,181, 67,120,224,173, 63,245,234, 87, 22,148, 81,172, 90,178,
203, 18,202,  9, 77,198,234,136,212,185,125, 30,240,219, 91, 95, 88, 90,209, 53,
153,202,165, 14, 83,105,255, 50,224, 95,135,118,116, 40, 47, 48,179,208,121,114,
 62, 73,157, 71,163, 91, 13, 25, 76,  3, 68,194,  6, 19,145, 32, 59,122, 86,185,
133,165,120,245,126,150,  7, 15, 16,212, 81, 77,211, 52,233,136,173,217,173, 59,
127, 52, 70,206,171, 20, 61,163,159,104,117,106,169,252,213,163,189, 93,190,230,
231, 90,246, 60,169, 51, 63,125,179,192, 59,150, 52,153,236,123,239,189, 63, 25,
109,116,168,145, 15,  9, 10,158, 63, 45, 70,143, 82,171,222,193, 84,242, 60, 74,
 20,159,117,207, 83,203,199, 42,205, 44,149,203, 83,112, 88, 48, 10, 73,148, 41,
170, 29,205,215,173,184, 52,121, 23,229,186,106, 96,145, 18,  8,128,226,168,193,
169, 66, 51, 51, 34,146, 36, 73, 97, 89,  3, 32,132, 24,164,202,138, 30,226,144,
 60, 13, 51, 44, 66, 24,145,  2, 99,132, 78, 32,193,  5, 18, 72, 40,  1,  5,133,
 37,106,  3,201,106,196,235, 17,107, 82, 70, 25, 34, 56, 91, 12,177, 32, 28,239,
112,142,251,252,116,113,224,241, 43,113, 69,212, 65, 47,  6,172, 18,239,127, 17,
 47,183, 21, 95, 46, 72,241,  4, 91,127,218,212,151,141,224,101,125, 35,129, 83,
174,210,112, 59,223, 46, 50,119,166,196,201,241,147, 37, 68, 28, 13,252,160, 49,
201,173,184, 96,113, 30,208,225,103,184,184, 92, 91,100,185,185,160, 56,105, 62,
146,234, 93, 55, 82,209, 50,167,224, 24,206, 64,219,203, 98,200, 48,129,105,130,
160,168,226, 65,205,186,165, 50,146,202,162,178, 47,214,116,222,122,211,198,112,
 14, 24, 41,226, 25,209, 60,104, 20,195, 15,203, 41, 49,232,171, 19,129,209,185,
 70,128,144,117,128, 44,188, 72,  1,199,220,170,154,132,100,164, 81,145,138,142,
252,116,134, 39, 71,155,159,118,193,220,250,120,217,226,130, 38,236,207, 77, 94,
241, 36, 60,226,  0, 49,236,  3,136, 26, 96,160, 40,193, 77,227,217, 29, 89, 31,
 30, 14, 87, 74, 10,132, 19, 71,156, 68, 20,178, 22,217,190, 71,171, 65,140, 89,
227,244,129,138, 91, 17, 92,215,237,143, 89, 88,196,  0, 10, 47, 82, 88, 99,232,
166, 27,245,194,134,185,147, 92,245, 71,108,252,107, 76,244,249,184,178, 50,168,
 40,  1,215, 16, 25,235, 32, 88, 22,226,  1, 26, 68,153,  0, 58,106,250, 31, 45,
 14,  7,233,191,205, 20,103, 66,139, 57, 50,156,197,239,153,210,154,  2,214,151,
 32,161, 66, 69,224,113,190,167,123,216,252,150,169,224,216,201,131,170, 92,146,
 40,193,218,242, 70, 97,116,251, 31, 51,207,155,255,124, 77, 38,117, 84, 33, 46,
 77, 88,245,193, 64, 95,211,238, 13, 80, 45, 69,150, 69,176,200,207, 32,148, 71,
 95,144,224, 41,188,113,247,124,172, 26,177,139, 21,238,  8, 77,112,184, 24,140,
 98, 83, 20, 81,192, 45,116,249,110,228,142, 28,106,155,205,201,152,188,208,191,
138,196, 83, 64, 75, 41,147, 22, 66,216,191,247, 25, 79, 76, 17, 24, 50, 66, 93,
 10,142, 49, 10, 79,176,209, 90,159, 56,201, 77,147, 85,131,105,171,234,  2,243,
169,249,197,213,151,229,108,195,168, 84, 11,156,
} ;

// ../Source/add/template/GB_add_bitmap_noM_23.c:
uint8_t GB_JITpackage_45 [1016] = {
 40,181, 47,253, 96, 34, 13,117, 31,  0, 54,104,122, 40,208,208, 88,  7,120,107,
239,101,162,191,  2, 46, 19,224,197, 71, 41,214,147,212, 47,249,224,117, 75,140,
254,116, 77,242,243, 60, 96, 59,200,213,176,  2,191, 23,113,  0,107,  0,113,  0,
147, 71,207, 76, 90,120,202,109,186,209, 92, 91,203, 60, 26,215,206, 40,195, 99,
226,178, 25,208, 26,116, 27,247,195,113,158, 24,244,225, 28,  7,255, 12, 38,145,
201,  3, 65, 18,153,124,202,164, 63, 76, 65,242,242,  1,248,208,204,221,135, 66,
252,113, 32,131, 53,173,188, 24, 10,167, 51,205,224, 68,214,223,109, 27,154,144,
198, 87, 90,124,248,247,235,207,162, 96,117,157, 66, 48,137, 13, 93,141, 86,126,
 50,197,162,166,201,104, 97, 14,129, 68, 15,  8, 36,199,158, 99,194, 57, 40,202,
114,251,202, 35,175,110,165, 41,163, 89,102, 44, 53,151,161,245,204,176, 20, 63,
 25,245,183,219,206, 53,199,201,219, 79,119,249,193,144,215,218,231, 88,112,144,
 43,109,204,117,229, 19,214,100,223,153,107,188,254, 54,106,102,253, 97,151,244,
144,205, 62,253,121,116,185,192,168,225,100,182,214, 54, 10,240,219,189,210, 87,
222,186, 86,229,181,110,230,110,248,255, 71, 17, 71,  4, 49,253, 21, 69,  6,  2,
 50, 99,139, 61, 88,230, 74, 73, 14,163,210,232,233,  8, 95,189, 51,202, 97, 24,
 51,190,116,243,  8,100, 92,187,138,194,  3,115, 18, 84, 51,236,213, 21,109, 84,
171, 87,236,114,180, 34,197, 70,115,221,234,128,212,230, 64, 15,184,253,187,146,
147, 25,142,151,244,141,166,195, 52,218, 63, 13,235,175, 67, 49,233, 86,188, 64,
 13,131,117,234,114, 90, 78,190,250,212,121, 84,114,208,100, 28, 34, 22, 56, 25,
137,133,136, 73,223, 42,191,176, 21,199,172, 87,  1, 81,212, 81, 81, 20, 37,233,
128, 50, 55,214,249,163,135, 80, 86, 10, 78,210, 55,122,170,162,213,169,165,242,
 87,135,246,118, 57,107,208,103,246,188,169,211, 32,121,179,192, 59,215, 36,161,
236,123,239,189,191,  8,237, 38, 66, 44, 96, 60,127, 19, 74,135,113, 90,152, 87,
239, 96, 58,243,228,121, 20,  9,126,235,158,123,230,107,149,110,150,202,227, 43,
 56, 44, 26,165, 80, 82,237,104,206,174,197, 39,201,203,232, 71,214,144,  6, 39,
  2, 55,128,225,168,225, 45, 34, 26, 17,145, 36, 41, 72, 97, 89,  3, 32,132, 24,
163,152, 21, 61,210, 88, 92,148,167, 48,134, 32,130,  5,136,  8,136, 20, 76, 52,
 34,129,101, 20, 36,  5, 45, 54, 41,107, 98,205, 67,189, 36, 93, 43,135, 58,103,
 24,162, 58, 56, 56,152,194,246, 41,184,222,211,241, 29,124, 88,130, 62, 47, 15,
 87, 85, 97,127, 55,188, 94, 86, 14,184, 32,231, 89,220, 15, 77,137,102, 42,220,
226,226,127,224,248,234, 70,234,190, 93, 17, 21,142, 38,209,202,201, 13,141, 94,
 60, 47,226,154,226,185, 76, 58, 50,229,  7, 69,133, 21,  0, 48,254, 99,  3, 47,
238,223, 57,143, 78,153,  4,137,246, 22, 88, 22, 73, 88, 42, 72,238,250,137, 46,
 34, 87, 52,216,126,144,  6, 85, 12, 85, 35,178,196, 34,137,  8,169,251,163, 29,
189, 81,127,222, 56,204,243,144, 50,200,200,234, 97,170,250, 40, 86, 78, 34,222,
183, 22, 65,164, 51, 66,192,  8, 59,  0, 91,120, 65,179, 77,220, 89, 26, 49, 51,
 60, 87,196, 44,144,236,104, 54,201,121,207, 56, 93,122,184,122, 89, 75, 47,240,
145,113,172,253, 23,152, 87,229, 92,226,148,131,230,  1,199, 30, 14,132,188,203,
 17,213,144, 73,174, 76,168, 48,156,160,207, 41, 78,161,181, 40,195,145,106,245,
  4,152, 53,142, 59,168, 84, 61,135,253, 99, 35,101,137,  8,102,168,224,178,  2,
103,163,237,187,173, 47, 92, 32, 49,202,255, 62,237,227,238, 52,202, 48, 65,240,
 85, 66, 22,180, 64,102,185,134,203, 24, 67,130,156, 13,  2, 40,150, 41,  3,152,
 52,208, 15,179,207, 14, 80,250,221,190,243,232, 53,211,228,160, 78,249,  0, 24,
 68, 39,186,251, 33, 94,244,254,162, 35,253,195,142,181,175, 31, 71,110, 46, 87,
231, 26, 52,173,128, 19,219,249,166,222,114,110,190, 57,175,223,100,238,198, 37,
101,214,206,137,111,105,182, 80,219,196,198,203,104,148,135, 50,176, 50,108,222,
 46,198, 10,148,210, 72,164, 84,158, 73,247,193, 91, 62,123, 65,240,241,171,241,
 11,151,126, 17,239, 71,185,138, 41,132,156,179,219,199,145, 65,237,213, 20, 48,
172,147,208,169,162,238, 41,124,162, 81,208,229,142,225,238,185, 36,158,164,182,
 95,  9,185,134, 73,231, 52,205,136, 26, 15,184,108, 46, 55,205,166,  6,211, 94,
209, 42, 76, 21,251,133,255,109, 85,106,171, 18,165,  7,224,  4,
} ;

// ../Source/add/template/GB_add_bitmap_template.c:
uint8_t GB_JITpackage_46 [734] = {
 40,181, 47,253, 96, 62,  8,165, 22,  0,134,103,118, 40,208,208, 88,  7, 52, 58,
177,179,237,158,184,159, 33, 99, 53, 92,195,156,189,136,209,149, 34,124,198,156,
 70, 68, 63,120, 64,181,116, 25,165, 30,120,192,242,  2,112,  0, 98,  0,108,  0,
191, 68,146,105, 18,225,236, 57, 90,157, 82,185,177,190,146, 97, 67,132,173,228,
215,154,200,  4,  6, 98,130, 12,170,108,185,115,123,179,138,238, 60,198,234, 82,
193, 68, 50,137, 28, 12, 72, 38,135,188,199, 37,219, 32,135,249, 84, 61,148,221,
169,117,196, 37, 79,165,177,100,212,213,  5, 10,219,234,168,135,111,111,158,232,
 10,150, 35,225,114,201, 34, 80, 85, 46,167,240,117,145,106,124, 47,234,180,219,
159, 11, 66,119, 89, 22, 78, 81, 81,132,162,  2,135,108, 45,191,231,126,167,188,
 88, 46, 85,199,230, 45,111,209,129, 32, 71, 40, 93,  6,177,  0, 36,235, 83, 62,
110,217,186,247,  9, 18,157,214,151,206,135, 98,116,175,239,188, 84, 11, 89,119,
174,238, 22,206,236,178,246, 24,221,227,161, 72,169,251,188, 87,114,191,198, 48,
134,210, 93,226,186,221,183,213,107, 31,186,109, 31,146,238, 12,114,217,165,123,
183,110, 97,157,118,206, 34,254,201,118,175,243,213,116, 37, 91,174,212,202,120,
240, 84,214,197,217,104, 50,155, 78,230,225,138,104,112,192, 24, 98,237, 64,184,
228,149,219,232, 64,242,253, 94,  4,  6, 87,246,180,209,221,150,248,185, 72, 35,
178,177,134, 83, 59,127, 46,191, 27,149, 77,225, 96, 56, 17,167,168,255,143,162,
140, 40,154, 56, 54,246, 10,217,112,139, 79,182,227,156,221,135, 62,135, 44, 27,
 99,232,192, 96,170,139,227,105,200, 94,103, 23,178, 47, 77,219, 88,  7, 81,180,
 17, 33, 60,133,200,229, 87,157,151,237,235, 16,141, 70, 98,243, 74,229, 86, 20,
 97, 13,229,246, 57,172,243, 18,219,203,162, 88,206, 95,235, 56,254,186, 95,202,
 15,131, 47, 93,167,213,137, 89,162,163, 36,200, 87,178,198,145,106,243, 85,166,
161,140, 98, 72, 39,  3, 65,193,112, 13,141,103, 60,157, 10,194,115, 89,143, 99,
 29,121, 35,224, 77,214,148, 84,192, 57,198, 13,147,175, 94, 57,187,205,155,236,
206,207,235,124,220, 18, 97, 32, 32,132, 16,162, 20,218, 13, 44, 67, 44, 24, 49,
246,182, 64, 10, 11, 99,151,186,151,131, 75, 15, 10,180, 75,112,108,130, 80, 40,
207,179,  1,175,  3, 88,241,107,244,250,162, 12, 44,216,103,  9, 14,  8,130,228,
110,  1,  0,204,  5,202, 31, 26,128, 49, 24,111,  2,246, 33,167, 23, 99,162, 26,
188,179,206, 27,199,253,200, 97,110,  6, 43, 88, 97,214,  1,  1,129,195,134, 25,
198,239, 36,130,199,  2,  3, 18,218, 26, 97, 97, 52,223,193,207, 52,213,  2,113,
109,165, 72,248, 35,  1, 22,  5, 48,137, 45,238,138, 42,141,188,142,253,198,  5,
 46, 72, 46,169,108,  2, 82,225, 49, 19,142,  0,110,133,132,140,145,  8,159,112,
 46,159,195, 45, 87, 89, 70, 16,224, 32, 67, 65, 36, 96, 54, 26,105, 21,165,145,
 23, 27, 48,147, 19,178,139, 15, 90,222,187,142,138,196, 68,194,193,  3,179, 36,
 53,192,190,245,243, 50,184,197,186,110,  2, 34, 88,129,148,198, 99, 64, 50, 54,
180,165,185, 88,195,200,123,252, 54,224,126,101, 23,185,121,211,212, 60, 51,217,
182,120, 53, 87,  0, 49, 52,177,128, 75, 86, 20,  5,110,
} ;

// ../Source/add/template/GB_add_full_30.c:
uint8_t GB_JITpackage_47 [360] = {
 40,181, 47,253, 96,143,  2,245, 10,  0,246,212, 66, 33, 16,179,142,  1,252,219,
 96, 71,195, 39,190,181, 97,136, 22,169,171,155, 59, 84,110, 37,132, 58,220, 85,
 76,140,  8,  0,160,202,103, 57,  0, 58,  0, 55,  0,151, 83, 23, 23,204,123,186,
 16,244, 46,229, 50,155, 15,218,229,170, 27,  7,187,117,205,153, 13,239, 38,139,
183,186,158,158,251,234,231, 37,118,  4,157,166,  2,251,193, 34,104, 24,111, 48,
 26,199, 85,141, 54, 94, 85,145,170,170,161,133,252,255, 99,  4, 69, 75,112, 81,
182,219,106,158, 63,104,123, 49, 55,252, 44,231,160,236,254,236,118, 31,148,101,
 33, 17,112,150,163,237,182,147,239,176,203,220,201, 49,158,151,133,203,186, 40,
195,192,186, 46,109,209,229, 14,137,231, 35,110, 93,241, 28,253,143,210,118,195,
 26,238,200,226, 13,103,187,109, 95,250, 52, 44,218, 92,181,186, 11, 53,111,243,
 93,131,152, 99,139,113,213, 53, 63,123,224,171,151,169, 58,  3, 48,174,114, 94,
114, 96, 23, 49,134, 98,168,250, 44,230, 60,240,140, 69,151, 68, 24,153,163,194,
160,244, 18,157, 34, 46,129,251,106,243, 50, 95,118,230,165,230,214,232, 83, 91,
204,200, 67,163, 13,250,105, 94,113, 73, 35,111,116,236,160,105,250,124,219,  3,
 32, 32,112, 34, 19,164,235,  1, 94,  2,223,109,198,216, 22, 27,  2, 28, 12, 72,
 58,135, 17,228,151,211,149, 53,104,140, 34, 59,251, 25,100,195, 99,136, 53, 91,
168,173,193,187,170, 36,216,235, 64, 33,115,197,168, 76,146,207, 53,163,112, 65,
114, 69,205,160,233,121,102, 90,219,128,171,185,  0,100, 18,175, 90,209,233,  6,

} ;

// ../Source/add/template/GB_add_full_31.c:
uint8_t GB_JITpackage_48 [466] = {
 40,181, 47,253, 96,125,  4, 69, 14,  0, 54,152, 76, 33,240,182,142,  1, 20, 86,
130, 82,150,229,127,109,217,118,230,230,226,115,106,100,197,192,194,183,216, 70,
112,192, 51, 48, 17, 24, 74, 66,  0, 68,  0, 64,  0,199,180, 37, 81,199,  7,242,
166,112,143, 34,139, 57,214, 73,201, 22, 98,154, 33,138,170, 51,197, 93,221,118,
212, 85,152,138,182,253, 92,219,111,199, 94, 51,189,252, 39,210,115, 95,108,  2,
217,224,174, 40, 28,230,189, 35,112,126, 31,157, 27,228,154, 86,101,154, 22,199,
162,241, 84,  4,162, 25,  3, 22,223, 24,238, 58,249,255, 87, 21,170, 34, 12, 12,
 89, 13, 61,138,229, 21,185, 90,208,110,177,126,145,172,106,177,122, 86,146,109,
 28,150,193, 87, 73,185,234,122,185,222, 33,200, 94,126,175, 60,134, 48, 16, 12,
 89,162, 64, 48,252,242,172,146,237,  2,249,198,175, 16,102,173,115,247,224,206,
 63,155,117,208,190, 66,  9,  4, 39,209, 59,227,248,139, 19,222, 56,182,254, 87,
151,103, 55,221,218,170,119,244,213,208,211,191,196,201, 89,250,163, 53,135,123,
138, 70,226,243,  8,254,214,123,105,166, 56, 85,149,  2,237, 39,114,115,220, 83,
 78,142,165,194,101,122,169,167, 39,221,245, 67,169, 68, 40,153, 46,  2, 90, 64,
213,183,166, 52,177, 94,210,  3,199,156,117, 75,229,209, 69, 52,143,109,251, 88,
223, 22,191, 70,109,167, 60,134,143,149,228,177,144,165,214,229,116,200, 74, 61,
 32, 80,136,144,148,157,  7,177,  0, 76,225,200, 97, 28,178,115, 96, 74,225,162,
209,232, 24,192, 30,194,192, 10, 56,195,193,175, 12,232,129, 13, 92,  0,185,225,
  0, 69,144, 11, 21,  1, 26,173,193,162, 19,144, 97,173, 62,248,244, 96,122,192,
 89, 55, 81,113,194, 57,208,183, 95,204, 39, 49,254,130,165,  1, 81, 15,200, 96,
101,158,120, 95, 23, 11,220, 56,232, 24,125,246,139,230, 48,234, 66,190,161,251,
 64, 36,143,161,193,250, 88,232,110,131,145, 85,161,181, 31, 12, 13,112, 39,202,
 14,169, 52,163,236,130,228,128,154, 65,243,121,102,106, 91,227,213,114, 70, 68,
245,239,250, 20,189, 67,
} ;

// ../Source/add/template/GB_add_full_32.c:
uint8_t GB_JITpackage_49 [784] = {
 40,181, 47,253, 96,253,  7, 53, 24,  0, 86,228,109, 33,224, 90, 23,  3,212, 55,
226,218,115,225, 39,109,246, 29, 42,165, 30,106,239,154,128, 89, 97,189, 64,132,
 59, 17, 99, 36,196,240, 11,103,  0,101,  0,100,  0,132,171,243,253,112,133,240,
137,100, 10,224, 85,149, 87, 95,205,245, 14, 75, 88,115, 81,236, 62, 25,137, 67,
130,224, 64, 28, 18,215,190,236, 83, 99,149,141,188,208,157, 21,238, 17,133, 57,
159,155,174, 66, 67,210,150,147,199,230,110,156,218, 96,229, 37, 89,161,225,234,
210,146,250, 26,159,126,254,150,246,221,193,108,239,125,210, 65,199,121,255, 35,
161,168,162,152, 34, 85, 16,180,149, 78,110, 48, 96,  4,131, 33,220, 53,211,196,
217,189,187, 46, 24,202,165, 35,217, 80, 60,146,186,161,144,176,107, 48,104,229,
239,144,147,223,126, 56,119, 50,251,143,105, 31,222,118,235,236,138, 41,240,134,
159,190,150,171,151,105,208,222, 50,220, 21,149,202, 47, 71,210,197, 43,138,246,
 36,106,188, 69,149,108, 73,  2, 94,142,223,192, 49,220,215,242,255,199, 48, 23,
118, 40, 36,  8, 55,252, 44,217,253, 81, 94, 76,194, 59, 95,144, 18, 24,101, 51,
 11,164,219, 19,130,210,110, 77,234,147,182, 59, 15,172,184,189,148,113, 61,221,
 74,207,253,126, 88,212,180,110, 93, 98,210, 73,240, 93, 23,141,157,241,183,206,
227,135,145, 48,152,189, 58,238,218, 85, 80,  6,227, 93, 45,222,151, 33, 95, 81,
245,192,201,207,210,138,246,211,213,203,158,193,108,215, 70,141,107,247, 73,126,
174,186, 79, 19,182,217,187, 26,233, 48, 21,187,239,232,131,238,  1,216, 11,123,
153, 62, 49,165,163,227, 15,184, 99,238, 24,178,253,220, 41, 89,142,251,187,170,
135,251, 52, 53,211, 85,217,114,111, 23,220,116,238, 30,169, 33,  6,228, 60, 54,
231,156, 96,190,159,149,146,217,187, 76,229, 72, 38,167,207,144,102,167, 53,164,
147,115, 55,105, 28,110,237, 52, 31, 25, 61,105,252,190,225, 62,152, 49,  9,242,
211,183,127,187, 40,116,238, 16, 16, 35,230, 23,128,141,168,129, 37, 83,136, 70,
 68,100,164,164, 32, 73, 26,  3, 48,132, 32, 83,102,230,  1,146,144, 96,150,100,
 64,202, 88, 66,136, 70,  1,201, 80, 70,202, 40, 41, 41,122,145, 64,201,138,187,
160,172,224,148,  8,153,205,123, 83,214, 92,  3,106,240,139, 72,125,  2,165,236,
 46,138,129, 91, 10, 16,  4,166, 56,220, 45,129, 46, 47,189,189,104, 60,138,140,
 23,233, 59, 43,249, 27,216,236, 75, 51,136, 66,189,249,198, 14,255,137, 20, 24,
 35,192,  7,248,226, 15, 73,  1,146, 64,192,239, 82, 17,197,102, 68, 44,102, 81,
104,232, 55,128,118, 62, 94,116, 10,144,  0,211,117,102, 73,174, 51,243,119,167,
138,229, 97, 57, 64,158, 68,  4,203,140, 27,150, 43, 12, 94, 30,230,241, 18,186,
100, 74,168, 82, 64,101, 88,116,234,105,189,146,183,227,157,246,240,201, 64, 67,
189,115, 31,149, 59, 32, 50,192,137,147, 29,137, 59,248,228, 91, 67,166,127,164,
192, 71,134, 30,233,248,160,206, 29,114,144, 39,195, 18,224, 82, 18, 12,150,169,
201, 90,109, 15, 33,172, 73, 67,160,244,253,224,169, 37,210,142,106, 21,  4,  3,
223,120, 74, 81, 86, 67,200, 14, 96,231,107,225,146,237,217,193,107, 73,243,167,
126, 77, 50, 47,225,102,253,  2,238,190,181, 53,175,132,138,209,183, 85,162,232,
207,207,236,116,157, 84, 50, 95,162, 68, 80,174, 70,224,  6,181, 54, 96,113, 40,
 65,155, 28,180,208,160,201,254, 96, 50, 85,  5,163, 80,  8,124, 50, 78,  0,150,
 84,105, 64, 12,
} ;

// ../Source/add/template/GB_add_full_33.c:
uint8_t GB_JITpackage_50 [467] = {
 40,181, 47,253, 96,128,  4, 77, 14,  0,118, 24, 77, 33,240,182,142,  1, 20, 86,
176, 98,184,161,111,105, 88,114,230,230,226,115,202,224, 22,197,210,177,212,109,
117,192, 51, 48, 17, 24, 74, 66,  0, 69,  0, 65,  0,199,246, 37, 85,199,  7,242,
 38,112, 20, 69, 23,115,140,147,146,  9,230,170, 33, 10,187,117,205,156, 29,239,
136,171,114, 21,141,247,243,125, 47,143,221,234,250,121, 47,172,223,190,152,  2,
217,216,126,197,225, 64, 49, 30,125,212,243, 42,157,144,107, 90,149,105, 90,249,
 89, 36,190,138, 64, 85,103,192,194, 19,193,209, 78,254,255, 85,133,170,  8,  3,
 67,102,193,174,102,121,133,182,247,187, 99,104,189, 72,102,119,104,187, 43,201,
 54, 14,203,192,179, 36,109,183,189,124,143, 32,232, 94,142,177, 60,134, 48, 16,
 12, 89,162, 64, 48,252,234,172,178, 34,153, 23,200, 55,126,133,176,107,125,187,
 39,119,254,145,214,191,251, 10, 37, 16,156,194,238,140,231, 47, 78,120,227,217,
250, 95, 93,221, 29,235,184, 45,139, 71,158,  5,187,253, 43,164,155,181,189,106,
 53, 56, 82,209, 40,188, 22,191, 99,139,113,213, 53, 85,149,250,174, 23,110, 84,
 28,233,164, 28, 75,101,251,212, 21,215,110,211, 10,102, 92, 41,149,  8, 37,195,
 69,190, 11,176, 27,219,148, 22, 90, 76,122,224,121,179,110,169, 60,184,136,230,
 49,231,199,250, 92,252, 18,247,165,242, 88, 62, 86,146,199, 66,183, 90,151,212,
 17, 60, 32, 80,134,144,152,153,  7, 73,  0,168,230,200,129, 53, 88,  5, 39,184,
126,250,130,105,101,162, 64,  2,105, 92,  0,192, 12,248,119, 43,113,193, 28, 53,
248,158,  8,110,  0, 70, 89,213, 96, 14,139, 85, 64, 40,180,202,193,231,  5,115,
  7,156,113,147, 21, 39,144,163,125,251,197, 92,137,177, 23,172, 13,216,122, 64,
134,149,121,249,157, 93, 44,112,226,  0, 99,244,217, 47,152,195,175, 11,226,134,
 54,  3,161, 60,134,  6,235, 99,161,186, 13,126, 86,117,107, 63, 56, 26,231, 78,
180, 24, 84,  9, 70, 57,  3,201,  1, 53,131, 38,230,153,233, 54,199, 87,203, 27,
 65,  5,176,181, 40, 90,220,
} ;

// ../Source/add/template/GB_add_full_34.c:
uint8_t GB_JITpackage_51 [790] = {
 40,181, 47,253, 96,  0,  8,101, 24,  0, 86,228,109, 40,224,176, 88,  7,248,157,
220,153,122,131,216, 42, 94,128,133,  3,161,103, 36, 44,142,251, 77,236,159, 27,
204,154, 40,246,197,147, 34,101, 48,195, 48,140, 23,  2,102,  0, 99,  0, 98,  0,
143,198,181,175,201,240,152, 80,192, 12, 96,221,185,141,251,225, 56, 75,140,249,
112, 74,223,221,129, 36, 34,121, 36, 16, 68, 36,143, 46,232, 14,207, 78, 84,248,
192,187,134,204,219,102, 66,220,101, 30, 67, 37,109,188,149, 73,166,243,228,100,
158,219, 86, 67, 66, 26,223,104,241,241,252,187,123,223,248,234, 88,141,183, 62,
 85,210,163,172,127, 98, 80,  0, 41,229,100, 16,195, 34,172, 42,135, 64,158,  7,
  4, 18,150,198, 83,143, 52,110, 66,183,206,225,112,177, 56, 68, 44,100, 44, 18,
 11, 48, 99,201, 38,135, 36,109,212,235,148,219, 79,143,156,186,133,162,107,230,
152, 49,212,148,131,181,188,240,163, 10, 45,  8, 99,177,175,204,112,195,169,191,
 91,118,218,148,198,219,205,246,184,193,136,215,  2,252,110,159,176, 77,230,110,
248,255, 63, 15,199, 19, 25,144, 60, 90, 94,209,190, 79,110,207,108,230,218,152,
 37,115, 19,171,  6,246,166, 75,  4,110,204,216, 98, 13,199, 92,225,187, 20,233,
116,140, 58,161,214,240,157,122, 95,147,226,  7, 51,190, 51,211,  4,158,161,  1,
 66,174,243, 25,215,237,122,178,137, 85, 11,110, 25, 86,144,  2,115,177, 94, 53,
166,221,  1,169, 77, 59, 15,184,189,187,145,198, 11, 67, 11, 58,230, 50, 61,218,
240,132,246, 46,163,186,211,204, 11,232, 21, 84,120, 23,134,234,210,163, 12,207,
211,241,116,104,238,230,223,139,243, 18,245, 73,125, 74,143, 50,253,212,159,189,
 91,190,186,115,153, 53, 23,105,186, 19,111,158, 46,112,205,169, 91, 54, 34,144,
172,251,227,156,115, 88,237, 59,248, 44,  6, 66, 44, 84,180, 59,249,160, 63, 40,
171,202,169,107,240,148, 57,210,220,  4,122,207,182,231,150,249, 88,157, 25,229,
218,167,127,186, 69,197,169, 83,176, 73,224,174,128,144,168,177, 37, 83,136, 68,
 68, 36, 41, 73, 10,133,198, 48,132, 32, 83,102,230,  1,146,136,116, 20,101, 36,
132, 20, 33, 68, 82,129, 76, 77, 82, 82, 30, 37, 69, 15,145, 65,201, 22,215,193,
166, 21,134,114, 74, 53, 53, 37, 78,154, 18, 38, 40,191,113,113,125,190,115,  4,
 15, 20, 13,247, 88, 12,192, 20,184, 33,176,199,161, 75,  9,124,121,149,246, 50,
174, 62,227,247,255,206,151,124,  5,206,251,250,  6,254,173,183,104, 44,249,109,
 83,240,141,224, 31, 96,137, 35, 33,133, 74,  2,132,126,167,139, 40,154,113,177,
152,134, 98,164,222,200,218,179,242,  2, 81,128,184,128,  8, 51,123,115, 77, 50,
107,118,154, 84, 22,203,153, 49, 72, 14,153,136,102,121,184,185,114,123,192, 33,
193, 60, 95,130,150, 12, 21,170,  6,208, 24,214,159,106, 90,148,188,127,248, 78,
 27,184, 50,248,171, 63,239, 59,117,  7, 41,  3, 74,156,  3, 73,238,  1,157, 47,
134,192,  5, 82,128,191, 25, 31, 73,121,253, 74, 30,114, 74,101,252, 58,112, 18,
205, 80, 91, 81,141, 16, 33,172,153, 66,160,250, 26,121,194,228, 38, 59,217,153,
176,155, 81,194,139,232, 48,216, 29, 21, 19, 93,172, 85,242, 99,249,253, 76,162,
157, 38,174, 15, 73,173, 47,150,181,212,  6, 15,222,154,231,  5, 97,105,244, 68,
 21,211,131,147, 40,252, 60,166,214,169, 10,253,146, 58, 86,164, 21, 24,138, 47,
 56,170,121,193,118, 81,158, 57, 57,104,205, 65,147,253,193, 36,149,138, 77, 33,
 33,248,100, 73,  1,140,168,134,193, 24,
} ;

// ../Source/add/template/GB_add_full_template.c:
uint8_t GB_JITpackage_52 [675] = {
 40,181, 47,253, 96,251, 11,205, 20,  0, 54, 93, 90, 33,224, 88,231,136, 23, 28,
 41, 58, 98,173, 85,102, 38,104, 96,113, 45, 51,126,152, 66,101,134,223, 25,220,
 49,140, 49, 16, 70,120,  1, 81,  0, 78,  0, 78,  0,109, 42, 27,183,231, 56,131,
 35,235,249,189,244,214,  2, 97, 64, 92,141,131,  1,113, 66, 55,184,133,173,169,
 74,142,209,163,192, 60,134,246,115,107,163, 25, 13, 36,107, 89,113, 52, 46, 43,
185,117,182,165,109, 30,219, 71,254,208, 10, 20, 18,249, 29,157,235, 37,195,206,
220,189,165,143,243,188,202,105,149,103,217,188,178, 44,222,  8,230, 14,223,184,
193,252,111, 60, 70, 32,107,152,173,232,229,248,178, 73, 20,104,225,183,232,222,
 45,141,167, 71,110, 53,182,167,178,  7,207, 98,227, 46,201,231, 81,212,156,132,
107,248,  6, 63, 63, 54, 13, 24,226,106,176,171, 36,189,163,108,251,217, 44,182,
103,185, 26,139,221,217,204, 21,146,116, 48, 47,147,109,163,143,147,207,156,130,
145, 69,155,154, 18,  9,229, 56,155,229,107, 79,252,108, 96, 78,108,244, 62,230,
143, 68, 11, 86,240,141, 43, 72, 30, 91, 48,223,242,196,250, 17,219,207,130,105,
 47,156, 30,242,200,245, 44,251,255, 57,177, 91, 67,155,201,241,168,123,107,103,
243,152,201, 16,133,235,187,172,199,  1,115,126,214, 19, 59, 48, 87,147,254, 23,
  8, 62,171, 72, 80,170, 53,254,172, 39, 34, 26, 31, 58, 84,243,177,104,216, 94,
251,131,222, 94,  1, 58,204,144,200,  0,111,175,116, 59,241, 94,205,162,183, 34,
  4, 77, 32, 56,133,163,131,167, 50,147,141,103,130,225, 62,150,139,118,149,138,
195,150,163,132, 76,  6,180, 57,  4,114,205,224, 31, 79,128,134,160,241,177, 35,
 50, 34,146, 20, 20, 20,164, 52, 28,112, 70,132,136,172, 27, 29,164,149, 27, 10,
127,233,113, 66, 23,148,206,106,190,  6, 58,134, 52,247, 55, 38, 68,113,111, 95,
 68,166,  8,177,127,206, 59,159, 97, 81, 36, 50,209, 44, 80,197, 50, 37,161,196,
223,240, 16, 79, 37,225,144,239,208,218,208,155,217, 98, 56, 81, 78,100,  8, 31,
114, 24, 68,177,231, 29, 78, 56,162,103,198, 53,124,252,145,190, 66,120, 77,138,
 50,222, 86, 32,208, 65,124,217,105,  1,184, 68, 71,110, 56, 60,116,124,119,  7,
199,253,195,205,216,247, 28,177,175,170,232,180,222,121, 43,189, 82,155, 57, 33,
193, 75, 99,167, 78,247, 54,220,139,102,225,101,132, 47,182,  8, 73,126,173,181,
 47,104, 97, 56,198,238,117,175,249, 12, 22,169,136, 12,209, 66, 21,148,  9,192,
  7,  1, 35,  9, 26,145,229, 86,179,168,178,173,  3,165,155,102,  7, 40,193, 73,
 92, 38,118,167, 67, 13, 45,176, 40,145,190, 70,101,217,230,187,  9,142, 66,211,
  9,215, 29,  2,245, 67, 65,  2, 53,157,  2, 23,217,216, 64,107, 56,195,166,155,
198, 51,173, 89, 31,107, 11,236, 72,195,196,176,111,146,129,254,200,133,186, 64,
 83,239, 33,230, 56,189,192, 22,  5,110, 41, 45, 97,194,134, 44,223,174, 73, 51,
230,103,166, 59, 64, 87,248,127, 84,254, 92,127, 69, 65, 25,
} ;

// ../Source/add/template/GB_add_sparse_M_bitmap.c:
uint8_t GB_JITpackage_53 [1639] = {
 40,181, 47,253, 96, 97, 56,237, 50,  0,166, 58,171, 40,192, 22,117, 14, 84,176,
105,194,193,122,180,126, 93,183,103,128, 83,178,249, 16,172,234,159, 13,186,224,
136,226,194, 43,115,128,144,109, 83, 20,  8,174,155,  1,164,  0,148,  0,162,  0,
 16,100,217, 46,189,206, 85, 62,194, 41,235,119,177,175, 94,251, 77,233,121,214,
201, 79,151,118,175,244, 25,223,142, 57,158, 30, 71,177,243,245,143,228,126, 37,
126,139,237, 87, 16,198, 98, 64,192, 27, 38, 61,248, 76,229,214,250,118,156, 73,
 16,176,237, 24,107, 10,  2,142,135, 11, 75,198,158,202,150, 49,110,239, 22,210,
 24,159, 19,126, 66, 48,192, 24, 16, 40, 20, 96, 12, 94,193,162, 79,182, 61,242,
225, 22,248,207,118, 41,215, 25,159, 58,144, 34,110,158,172, 16,153, 14,223,254,
 58,208,171, 79,149,189,207,118, 57,245, 41, 74,112,227, 80, 53, 84, 68,166, 76,
 68, 61,227, 73,238,246,101, 85, 22,219, 42, 61,107,101,153,180, 34,196, 47, 23,
136,224,114,  9, 81,245,203, 33,207, 76, 72, 84, 86,  6,  7,  2,178,220,207,187,
 31,125, 71, 79, 93,163,103,147,182,150,177, 47,227,250,219,204,245,221,176, 42,
217, 94,214, 91,194,167,221,109,150,201,115,229, 45,164,235,219,116,122, 37,156,
223,194,125, 24, 86,105,215,175,124,229,124,198, 61, 61, 79, 82, 59,229,175,253,
184,243,118,223,177,135,181,126,198,246, 59, 95,183, 31, 73, 50,229,179,249,209,
205,142, 88,201,253,211,201,219,113, 99,173,105,252, 79,101,207,109, 63,163,219,
101,238,182,183, 12,128,255,143,151, 14,191,249, 41,  0,250, 40, 81,175,188,221,
230, 87,170,125,154,243,211,254, 31,130,126, 18,144,  3,113,233, 45, 73,111,184,
119,205, 49,223, 60,146, 51,246,181,181, 53, 11,246,245,205,230, 38,157,136,188,
 60,131, 80, 80,253, 68,235,120,122, 62,112,145,111,160, 24, 49, 56, 23, 29, 17,
 71, 65,121,  5, 70,231,116, 48,224, 69,199,234, 72, 96,112, 58, 29,104,169, 92,
149, 94, 50, 25,221,114,245,110,185,235,237,248,115,202,179, 71,110,231, 52,122,
 91,233,197,216, 51,229,151,181,167,179,174,127,191,107,210,  0, 84, 44, 77,243,
 10,247,169, 36,163,  3,169, 74, 64,224,149,202,251,116, 85,209, 43,235,218, 92,
164,185, 79, 74,175,107,222,151,126,171,188,214,218,188,242,126,173,131,132,219,
 53,244,241, 74, 71,220,245, 53,206,186, 47,128,228, 29, 16,148, 18, 99,132, 16,
 94,218, 93,115, 53,158,143,175,244, 48, 37,198, 24, 99,140,209,225,208,131, 16,
 70, 24,157,103,111, 36, 28, 82,153,123,  6, 99,  0, 35,  3,140, 29, 11,206,124,
101, 22, 26, 32,188, 44, 47, 95, 16, 66, 24,159, 81,184, 82, 40,139, 94, 43, 90,
 29, 23, 22,212, 99, 74,149, 83, 98,214,170,176,144,168,208,144,155, 55, 63, 69,
171,225,241,115, 61,142,111, 59,  1,  3, 65, 41,146, 68,121, 90,201,133,197,  6,
 39,198,120, 81,219, 86,  9,252, 36,210, 50, 58,180, 30,160,  5,133,133,230, 13,
 66,121, 30,239,137,162,216, 78,214, 92,146,176, 23,112, 58, 48,226,194,122,120,
128,  1,241, 18,252,230,212,163,199, 88,169,120,151, 14,189, 79, 29,129,135,168,
113, 53, 51, 36, 34, 34, 34, 34,146, 36, 73, 26,  3,145, 12, 65,136, 49,232, 32,
 52, 15,178, 96, 72, 13,129, 12,  4, 49,  4,134, 16, 69,  4, 72, 72,144, 80, 10,
136,128, 16, 37,144, 18,150, 72,201,213,  1, 33,136,200,112, 36, 52,208,177,161,
243,148, 76, 62,229,213,165,192,105,149, 28,231,126, 38,100,133,205, 19, 89,186,
228,109,245, 10,193,109, 85, 23,217, 80,118,  2, 18,138,173, 95,125,206, 38, 48,
212,159, 43,105,227,240, 60, 96,  6, 34,253,234,153, 68,191,250, 58,255,170,239,
 65, 85,114, 66,181,133, 70,178,235,120, 54,120,224,106,105,114, 25,133, 52,204,
202,222,107, 60,217,151,149,238,  5,140, 61, 63, 50, 72,131, 35,207, 29,254, 81,
 41, 12, 98,231, 10, 82,212, 19,226,187, 72,195, 91,170, 16,  9,107,206,170, 56,
162,137,206,128,112, 97, 37,220, 63, 63,101,124, 57, 69, 19,  9, 32, 26, 52,120,
 74,175,233, 90,158,244,139,254, 61,132,  4, 82,201,  1, 21,  2,209, 97,173,  3,
 74,221, 49,250, 92,248, 81,196,180,236, 87,  4, 82, 66,247, 32, 13,202,225, 72,
228,  0,225, 72, 41, 58, 55,252,202,141,254,219,200, 63, 59,130,207, 44,137,146,
 51,150,249,202, 49,254,254,188,145,242,124, 85, 78, 33,189, 49,144, 30, 57,103,
 87, 75, 63,193,189,128,165,  6,130,191,124,148,160,160,154, 81,100,162,144,147,
121,  6,238, 32, 98, 98, 81,115,249,109, 12,184, 44,  0, 10, 30, 17,249, 32,172,
126,206,117,210,231,138, 96,143,143,173,246,135, 65,117,130, 11,119,191,  9,149,
 60,211,253,245, 32,180,168,142,103,157, 91, 17, 80,188,221, 96,105, 66,171,192,
250, 31,233,225, 43, 64, 64, 20, 70,189,127,112,212,252,  9,117, 40, 48,107, 35,
178,224, 27, 88,228,189, 11, 19, 86, 96,114, 35,  8,191, 18, 68, 32,221, 19, 72,
135, 64,104,  1, 77,  8, 38,161, 23, 74, 92, 28,121,191, 74,156,232, 36, 97,183,
 38,192,159,111,112, 46,104,236, 75,186,230, 20,173,169,220, 33,207,250, 58,184,
182,155,105,191,179, 39,105,  5, 35,  1, 11,  9, 64,177,148,116,139, 88,102,103,
148,199,241, 46, 13,211,169, 61,255, 87, 57, 36, 54,190,251,  0,209,193, 38,160,
131,217,249,129,249,113,113,172, 24,218, 82,146, 23, 92,119, 53, 66, 24,  1,199,
 36,164,186,251,128,199,195, 83,  5,131,206,144, 65, 72, 38, 38, 76,103, 56,177,
 81, 66, 13,213,249, 92, 62, 34, 60,232, 90, 68,132, 60,254,137, 40,248, 39, 10,
145,129,140,133,127,  0,145,146,193, 46, 66,134,208,144,121,170,181, 60, 77, 92,
 94,147,116,212,200,250,135, 33, 42, 83, 63,208, 66, 67, 79,164, 31,247,230,163,
 52, 57,140,173, 73,205, 57,173, 32, 87, 75, 47, 83, 79,228,132,232,  5,150,116,
 35,216, 10,142, 51,158,211, 96, 74,212, 25, 48,139,124, 54,112,  9,109,178,  5,
 42,114,222,144,108,200,167, 24,128, 33,175,206, 15,  2, 80,254,228,177, 83,205,
181,102, 32, 80,108,114,153,255, 92,251, 88,105,176,  1,111,103, 35, 70, 22,177,
 42,254, 16, 48, 95,  9,193,133,119, 34, 97,199,214, 78,208, 23,120, 42,192, 77,
202,201,174, 16,209,  0,114,222,117,154,  2, 73,  1, 63, 10, 59,179,227,221, 75,
  4,110,203, 47,126,206, 68,184, 19,198, 37,242, 73,178,195, 46, 54,133,166, 26,
212,131, 22, 40,140, 99,176,194, 28,255, 88, 85,142,150,205,111,135, 80,135,177,
251,182,141,164,241,109,101, 69, 46, 43, 61,220, 41, 71, 31,152,137,213,206,227,
 36,194,236,135,176,145,200,187,129,  8, 67,130, 18,201, 49,185, 47,102,241, 32,
 21,134,202,113,120, 64,  3, 97,209,194, 24,144,184, 55,197,  1, 66, 46,136,164,
 59,238, 39, 40,147,224,109, 36, 68,167,169, 69,122, 33, 56, 73,134,235, 54, 60,
151, 21,181, 49,232, 11,201,118, 92,252, 24, 48, 66,239,154,130, 93,203, 90,101,
 19, 54, 49, 65, 38, 37, 68,114, 65,109,157, 75,111,151,  3, 25,215,130, 75,216,
 70, 58,129, 29, 16, 47,107,  9, 16, 80,152, 29,148,185,167, 60, 70, 13, 85, 77,
 33,  1,208,211,223, 14, 22,138,168, 86,  0, 33,145,254,129,186, 94,154,111, 75,
 25,229,113, 98, 95,142, 32,118, 89,161,114,137,205,217, 52,137,127, 48, 57, 43,
 26, 45,154,175,135,150,137, 13,236,183,179, 94,238,151,250,107, 18,192,  3,
} ;

// ../Source/add/template/GB_add_sparse_M_sparse.c:
uint8_t GB_JITpackage_54 [2543] = {
 40,181, 47,253, 96,132, 49, 45, 79,  0, 90, 83, 24, 15, 45,192,172,170,115, 62,
 59,254,187,209,111,186,183, 30,175,219,115, 44,203,140,234, 62, 92,173, 84,103,
204,198, 69,237,149,169,226, 62, 55,245,227, 40, 35,219,166, 40,116, 20,231,  2,
228,  0,228,  0,230,  0,103,142,180,148, 22, 43,219,149, 70, 93,176,221,120,163,
  2,107,138, 95,219,151,137, 79, 34, 87,233,189, 24,227,172,221,103,244,151,173,
213,217, 75,237,106,109,130, 84,  1,121, 76,211, 20, 57,138,103, 68,169,227, 39,
189,229, 43,233,255,119, 13,232,194,202, 91,241,236,236,121,134, 77,174, 30, 14,
121,124,242,200,253, 86,  4, 12,220,217,182, 31,227, 47,111,184,178, 54,225,209,
 63,121,165,217,185,238,178,253,255, 59, 28, 26, 14,199,244, 74,111,157,171,116,
 52, 76,145,  7,107,151,228,222, 37,149, 59,235, 59, 25,179, 60,216, 78,190,250,
242,120, 64,201, 76, 24, 99, 84,182, 44,113,123,181, 77, 75,124,219,222,165,  2,
145,134,200,227,  0,164, 33,114,232,122, 46,217,198,144,148, 79,239, 29,237, 82,
 78, 79, 92,210,188, 11,212, 56, 89, 33, 52,124,187,211, 56, 42,115, 29,141,225,
241,216,148,167, 46,193,232, 77, 18, 68,  4,144,133, 36,121,168, 75, 98,197,182,
 74,206, 86, 24, 38, 43,  8,113,  6,  6,199,131,129, 33,147, 83,152, 22, 28,169,
210, 75,219,214,101, 63,140, 78,177,237, 78,239, 59,149, 49, 36,108,229,245, 77,
246,197,156,133,158,101, 43, 84, 56,  4,217, 78,198,228,243, 64,248, 22,226,  5,
  8,120, 21,167, 77, 90,116,219, 92, 94, 83,231, 54,179,230,159,108, 91,105,253,
209,177, 30,242, 19,187,237, 95,203, 17, 99, 43,123,147,144,195,131, 17, 56,251,
156,229,174,119,242,183, 77, 30,130, 60, 18,108,163,218,175,237, 56,183, 14,103,
203,147, 74,156,228,220,182, 46,157, 83, 94,135,111,218,100,237,238,213,213,107,
173,211,251,120,203,181, 59,  9, 92, 63,105,223,198,  0, 92, 88,201,121,199, 74,
  6,112,214, 38, 54, 32, 17,215,240, 73,130,138, 11,138, 75,110,113,  5,177,162,
183,186,200, 58,126, 50, 57,116,113,169,  2, 97,137, 18, 19,153,107, 39,189, 46,
105, 21,137,119,161,180,  8,193,  0, 86, 40, 25, 99, 89,  7,136, 15,135, 46, 23,
  6, 17,159, 44,124, 66,162,162,209, 60,168,195,209,235, 28, 51,118,249, 92,139,
183, 50,175,172,221,230,207,203,241,149,193,191,147,251,234, 44,227,115, 34,104,
192,243, 75,  8,220,123, 41, 17, 24,170,162,169, 50, 24,190,186, 94,201, 57,115,
213,174, 68,226,  0, 69, 24, 31,188, 36, 98,145, 65, 61,207, 96, 28, 84, 32,180,
104,198,187,100,209,146,242, 48,151,  9,159,195,158,188, 97, 60,146,250, 61,127,
 85, 67, 76,161, 45,231, 82,134,230, 81,177, 43, 40,142,226,221,151, 40, 40,114,
151,186, 41,234, 33, 58,167,  1, 69, 17,130,135, 55,124,242,167, 18,193, 34,129,
153,160, 42, 13, 42, 74,180,104,170, 23, 33,158, 68, 70,250,187,  4,  2,193,168,
118, 25, 66,120,109,237,172,122,253,199, 99,155,101,180,122,199,104, 44, 11,127,
102,103,140,197, 56,249,173,242,218,138,226,168,211, 89,249, 94,201, 61, 92,155,
108,140,174,215,118,119,118,244,250,213, 27,181, 56, 29,251,  9, 70, 85, 50,199,
 73,190, 83, 86,217,109,180,251,217,119,242,169,189,  4, 29,242,201,228, 21,205,
 91,144,169, 40,148,247, 28,122,124,230, 31,  1, 14,199,198, 36,178,  1,161,212,
184, 77, 90, 27, 84, 69,111,245, 42,  8, 25, 12,181, 81,229, 38, 47, 91,201,203,
 86,  4,198, 18,193, 32,138, 40, 46,138,126, 42,155, 80,150,  5, 33,180,160,  5,
 33,180, 32,132,208,178, 32,244, 92, 83,177, 92, 50,241,113,  2, 46, 69, 28, 90,
234,247,170,130, 92,109,211,149,147,147,181,188,205,238, 19,232,102,251, 89, 86,
 63,143, 30,199,117, 23,148,110,191,184, 30, 38, 54, 59,154,201,247,112,238,102,
 95,104,193,162, 57,223, 40,181, 14, 31,189,214, 64,240,248, 48,134,212, 14,193,
 10,142,226,214,123, 36, 76,242,181, 28,135, 27, 42, 14, 51, 72, 48, 20, 76,100,
239,214,201,219,247, 79, 44, 85,190,114,235,108,140,245,197,216,229,205,166, 45,
 87, 41,179, 76,157,126,231,202,148,111,  7,163, 55,161, 40,182,117, 84,179,143,
 86,106,143,207, 90, 94,191,242,218, 85, 37,203,105,153, 98,135,158,104,217,202,
107, 97,224,208, 11,227,185,105,203,152,131,127,234, 76,201,121,103, 85,250, 23,
130,183,168,226,211,142, 41,165,134, 68, 68,146, 36,201,176,  6,210, 40,132,194,
104,160,167,106, 42,125,210, 96, 68, 11, 98, 16,  4, 17, 21, 49,196, 16, 98,136,
 17,136,136,136, 72, 32, 82,146, 20,180, 48,205,  1, 91,172,125, 97, 34, 85,140,
128,220,194, 92, 15,134, 32,188, 77, 83, 10, 76,213,114,143,179,198, 93,203,112,
 67, 57,252,115, 19,156,239, 21,100,200, 65,116,135, 33,101,232,127, 45,201,214,
 29,247,176, 39,218,102,178,157,173,105,164, 80,109,122,146,255, 76,171, 61,205,
208, 85,249,141,  0,168,124, 20, 92, 58, 56, 57,223,195,159, 14, 73,200,194, 67,
 44, 74, 70,200,184,105,107,  2, 12, 48, 72,153,136,146, 47,114,138, 13,  8,154,
 15,108, 52, 17,102,148,122, 87, 53, 18,100,141, 71, 56,138,100,125, 59,181, 16,
156, 46, 73, 68,128,146,102,164, 89,225,249,161, 16,125, 16,226, 64,  9,137,116,
136,251,243,104,231,250,248,171,201,181,233,157,232,227, 56,199,197, 38, 52,222,
153,184,150,  6,142,197,118,254,216, 84,213, 67, 44,118,158,155, 12,193,225, 99,
242,253, 75, 24,166, 47, 29,115,  6,199, 66,113,253, 49,120, 38,123, 46, 45, 66,
113, 91,  8,190,107, 29, 35,138,151,192,222, 57,133, 87,151,111,167,123, 62,224,
 73,157,218, 96,209,103, 77, 60, 56,121, 75, 37, 47, 78, 58,185, 24,226,118,107,
176,247, 42,209, 53, 53, 49,131,255,124, 62,227,141,204,206, 71, 32,146, 29,212,
166,247,189,229,113,110,152, 41,110,228, 17, 68, 91,  5, 71,240, 23,102, 22,209,
248,  2,107,202,234, 14, 16, 47, 71, 57, 40,141,176,  9,242, 27, 20,115, 13, 63,
208,242,160,146, 11, 23, 71,  5,197, 40,126, 87,193,126,147, 50, 20,211, 94, 35,
225,242, 32, 73,234,184,188,174, 40,204,120,250, 94, 48, 99, 72,177, 46,202,120,
135,  4,204,149, 91,244,244,162,162,208,125, 88,184, 17, 82,116,118, 86, 99, 84,
221,252,145, 20,161,150,188,204,183,172, 20,168,167,193, 20,117, 60,108,197,241,
226, 83, 39, 28,215, 78, 38, 77,  1, 95,220,223, 43, 74,119, 77,208, 24,243,126,
157, 13,114,185, 92,  1,145, 54,  0,184,157, 34,118,151,101,159,146, 95, 11,  5,
 56,127, 13,  9,169,214, 65,231,230,227, 96,146,162,188,182,132,254, 65,152,229,
166,225,170, 16,112,180, 36, 35,145, 45,239,135,192, 43,  0,157,106, 19,168, 59,
 28,190,245,183, 60,152, 32,196,212,243,170, 32,250,177,132,161,127, 54,246,175,
229, 95,133,120, 73, 46,244, 19,200, 12,234,116,223,151,165,198,212,227, 76, 90,
 67,243,139, 42,170,139, 91, 30,245,187, 78,163, 24, 20,123,172,133, 61,249,110,
109,166, 78,151, 81, 10,145, 95,218,199, 27, 65, 64, 21, 80, 89,240,236,  1, 77,
168,193,153,151,100, 60, 48, 42, 93, 18,  1,137,227, 95, 72, 85, 64,221,208,191,
151,204, 34,226, 26,134, 69,157,165,253,226,244, 58,108, 94, 28, 13, 39,172,180,
191, 61,169,144,  2,200, 27,237,  8, 13,196,177,220,105, 98,179,168,149,176,215,
157,134,242,117,146,  8, 37,141,121,121,231,252,175,179,185, 20,167,244, 46,209,
 17, 94,221,188, 89, 65,218, 64,170,  7, 32,206,244,144, 88, 35, 35,153, 72,160,
175, 49,172,169,148,152,114, 55, 52, 58,  9, 92, 26,106,161, 54,173,124,247, 10,
246,  8,214,227,137,142, 64, 87,143,209,132,171,184,227,116, 24,134,221, 95, 11,
113,  8,243, 97,112, 54, 36,246,255,190,239,113,220,215,115, 13, 86,137,227,  1,
215,250, 42,243,181,110,133, 86, 59, 84,  4, 40, 84, 83,215,215, 68,191, 59,  7,
194,109,239, 20, 92,222,  6, 52, 25,137,198,192, 54, 94,199,173, 81,202, 18,185,
  5, 84,176, 76,212,231,140,138,162,120, 55,207,129,188,189,184,125,195, 14,  0,
 55,193,108, 60,254,179, 33, 95,109, 19,101,201,196,165,137, 49, 65, 70,175, 16,
121, 56,118,210,194,251,232,165,167,225,212, 98, 29, 61,  4,234, 56, 74,199, 72,
215, 55, 10, 74, 35, 81, 30,185, 76, 65,151,239,157, 95,200,247, 25, 16,141,147,
208, 39, 20,147,240, 62,184, 41, 50,196, 20,137,179,190, 23, 40, 28,152, 43,219,
 40, 65,248,127, 24,110,191,202, 58,128, 60,222,198,166, 76, 70,222,154,225, 26,
156,141,184, 82,174, 60,209,236,143, 48,246, 41, 38,227,107, 82,137,105,206,219,
101, 81,231, 96, 40, 97,206, 27, 19,251,110,118,254,188,184, 15,  7,124, 82,105,
 98,  2,211, 44,109,121, 14,218,223,114,105, 33,105, 99,244,232, 59,133,212, 39,
237,227,109,206,239, 48, 84,111,252, 73, 47,137,  3, 65, 19, 86,208, 66,196,  4,
154, 48, 36, 12,113, 75,134, 73, 13,  3,143,108,102,205, 11,240, 51,127,  7, 35,
122, 56, 99,179, 77,104,118,145,206,233,194, 24, 75, 50,254,116,164,115, 10, 44,
211, 28,166,158, 37,244,201, 84,  5, 12,130,164, 96,250,153,190, 51,183,254,139,
160, 40,136,  1, 18,249,125, 22,  3,112,128, 86, 41,145,153,178, 28,146,209,110,
 58, 19,241, 40,150,143, 37, 22,132, 13, 99,130,225, 29, 86, 65, 18, 78,185,180,
 33,165,249,102,177,135,106, 34,  1, 78,113,113, 41, 52,143, 30, 43,  6,243, 54,
112,130,203,111,129,175,181, 57,127,206,179, 46,144,213,176,134, 98,133, 95,255,
123,237, 99,127, 43, 77,131,177, 90, 30, 16,121, 67,243, 32,183, 55,173,207,199,
 91,210,235,  7,137,146,159,248, 69, 96,128, 11,179, 91, 54,100,220,225,241,201,
 31, 48,209,185, 37,  2, 61, 73, 81,196,107,214,128,187, 37,176,220, 44,124,100,
 47,239, 87, 62,174, 16,249, 69,  4,192, 62, 40, 30,165,143,220, 49,244,226, 35,
237,  1, 87,249,254,224,199,196, 56,134,103,232,238, 68,229, 57,105, 15, 26, 24,
127, 48,239,120,  8,129,169, 77,243,145,227,173,103,163, 41,229,215,205,113, 96,
139,191, 69, 18, 68,  3,247,120,148,215,236,185,129,218, 88,145,133, 78, 84, 35,
195,  8,158, 92,179,177, 18,139,  3, 35, 91, 79, 53,147,183,167,  7,200, 84, 38,
 58,127,206,176,228,249,213, 69, 18,221, 24,189,183,102, 42,165,106, 86,190, 50,
248, 12,173,148, 56,158, 64, 86,  9, 14,153,246,119, 60, 78, 95,  2,208,  7,126,
219,121, 25,182, 14,103, 13,158,212, 59,151, 89,130, 86, 33,144,169,237,186, 86,
240,228,179,228, 58,126,248,186,  6, 85,133, 23, 37,135,  0, 93,204, 85,236,185,
230,246, 66,101,197,255,131,149,  6,106,179,194,164,151,133, 87,244, 95,189,163,
233,136,173,178, 11, 88, 15, 31, 69, 86, 18,  7,252,174,207,254,243,121, 37,204,
 61, 73,  4,106,219, 25, 77,139,217, 53, 77,228, 62,156,186, 16, 67,157, 80, 17,
 34, 80,153,125, 95, 66,222, 57,199, 57,  4,  6, 89,121,166,247,198,144,131,  7,
235, 94, 81,173, 94,167,  6, 91,159,202,154,184,211,141, 54, 83,128, 11,230, 68,
116, 20, 66,226, 91,132,109,121, 85,174,145,195,158, 98, 11,178,160,244, 74,200,
121,231,131,117, 81,135, 62,164,219, 60, 24, 46,190,112,143,180,118, 68, 19,219,
 39,149,119,154,130, 56, 13,213,128,144, 12,156,127,163,144,124,211,108,180,192,
132,215, 38,235, 30, 12,145,119,206, 42,102,148, 52, 28,232,112,194,156,224,234,
 48, 81,  3,
} ;

// ../Source/add/template/GB_add_sparse_noM.c:
uint8_t GB_JITpackage_55 [2064] = {
 40,181, 47,253, 96, 27, 67, 53, 64,  0, 74, 71, 12, 13, 40,176,148,177, 14,232,
130,192,235, 29,115,129,216, 15, 49,239, 91,147,133,173,148, 13, 89, 15, 32,140,
163,147,184, 77,  3, 52, 63,225,159,210,159,166,119,199, 37,195,  0,194,  0,202,
  0, 24, 75,251,185,101,107,118, 55, 91, 83, 45,197,207, 51, 42,111,253,214,121,
229,241, 44,245,205,210,244,219, 85,237, 28, 39,175,121, 40,119,102,201,157,218,
220,225,  3,208, 96, 57,124,245,247,205,175,121,231,246,108, 54,103,173,204, 29,
118,128,223,122, 43,211,137,231,181,207,149, 30,247, 63,255,255,201,100,100,114,
177,100, 42,115, 43, 73,251,174,185,179,181,206,116,102,158,202,196,116,150, 90,
162,114,193,  9, 89,178,249,113, 39,158,162,227,188,113,180,232, 28,247,110, 29,
100, 46,153, 74,  2,230,146, 57,165, 68,221,194,253, 33, 57,183,188,135,108,185,
154,154,116,107,244, 36,224,102,229,133,208,140,102,238,110, 52,241,192,210,244,
 74,111,221,105, 67, 54,130, 95,183, 96,245, 54,148, 14, 75, 67, 93,215,124, 42,
141, 19, 95,105,113,204, 50, 25, 33,196,  9,  8, 38, 21,  2,130,152,155, 37,216,
 43,249,205, 69,104, 71,201,242,242,113,136, 60,113, 90, 61,189, 51,103,105, 63,
 55,210,111,121,191, 85, 59,158,156,237,242, 57,104,103,116, 90,173, 30,  4,247,
 73, 63,157, 84,189,227,173,212,219,233, 86,110,121, 10,193,186,135,112,180,126,
132,146,105,215, 14,220, 89,156, 87, 70, 24, 51, 42,227,163, 28,243,205,230, 69,
132, 34,135,243,168,107, 29,  0, 25, 78, 17,117, 66, 24, 17, 39, 33, 57,229, 81,
239,140, 68, 47, 52,138, 35, 79,132, 16,212, 73,162,206,104,244, 44, 20,236,183,
 18, 96, 58, 51, 73, 29,207,190,153,206,249, 33,183,155,180,122,124,107, 46,205,
143,115,178,203,250,163, 51,218, 22,199,117,154,149,166,220,216,150, 43,  6,159,
101,203,125,122, 54,115,  7,171,183,185,126,139,132,  4,197,196,177,124, 86,183,
 60, 77,199,189,229,215,124,218,207,102, 28, 29,118,121,124, 39,  7, 71,223,153,
213,210,181,250, 73,155, 59, 85,142,171,154, 38,163, 93,189,210,227,214,211, 69,
 29,139,206, 68, 20,129,226,  2,230,146,137,215,232, 19, 69, 29,  9, 79,232, 83,
201,205,114, 18, 98, 24, 86,128,117,119, 87,154,  1, 43,185, 98,205,241, 69,140,
 16,232,186,146,147, 37, 28,171, 74,230,137, 77,128, 60, 19, 20, 26, 43,211,113,
171, 65, 46,234, 33,144, 69,  7, 66,136, 81,135, 21,119,  4,121,183, 58, 90, 82,
127,145,243, 64, 18, 32,109,102, 20, 66, 10,229, 61,136,254,230, 27, 26,239,190,
101, 95,253,178,183,250,234,188,186,109,248,234,125,211,212,175,170,106,184, 61,
195, 47,223,220, 62, 71,  3,132, 76,155,234,100,120, 68, 32,210,213,169,136,156,
143,103, 20,223,  7,226,137, 66,207, 88,114,176, 51,190,173,197,215, 27,121, 29,
119, 91,190,230, 26,204,229, 35, 32,112,109,  6,147, 73,201,101, 43,236,  2, 33,
 70,201, 45, 87,134,172, 77, 14,254,214,191,203, 66,  8, 33,132, 16, 66,135,191,
247, 94,223,202, 80,224, 19, 16,160, 62,185,222, 78,109,146, 56,119, 21,147, 23,
 12,132, 16,194,247,222,131,215, 44,200, 74,133,242,172,192,173, 76, 65, 91,253,
190,149,174,156, 56,134, 92, 73, 27,211,206,213,138, 97, 94,121,246,155,107,251,
 25,109, 45,163, 51, 66,251,134,195,  9,173,157, 75, 19,223,153,105,139, 80,250,
 10,149, 91,169, 51, 41, 12, 60, 83,112,135,201,131,  9, 15,118,149, 49,230,243,
 86,109, 98,199,243, 26,132,134,247,224, 53,  7, 85,181,161,241,134, 85, 72, 54,
184,116, 67,  9,161,133,126,226,106, 77, 51, 91, 18,191,223, 34,239,180,149, 51,
  1,186, 58,163, 76,193,245, 16, 73, 35,145,231,193,170,157,117,121,132,187,226,
 78,174, 65, 50,150,  5,204,105, 63,130,  4,168,226,219, 16, 57,133, 72, 68, 68,
 10, 82,144, 36,141,  1,114, 41,132,194, 72, 26,  6,153,226,226,  3, 66,128, 56,
 14,225, 12,131, 64,  8,  2, 17, 34, 68,134, 80,  1, 33,132, 24, 66, 68,100, 36,
 24, 17, 17, 34,206,  1,134,136,242,121,233,230,204,  4, 45,135, 72, 14,220,135,
 79,139,173,212, 65, 54, 71,195,199, 10,180,166,105,109, 35,188, 86, 13,132, 38,
229,112,147,250, 42,225,157,172,192, 50, 15,112,228,170, 56,226, 56, 45,214,228,
250,  6,137, 79,217,224,134, 58, 88, 39,118, 56, 77, 50,165,234,132,111, 83,159,
171,168,124,  2, 16,201,152,162,194, 27,139, 24,156, 11, 30, 68,169, 82,208, 85,
187, 94,212, 33, 85,218,165,242,109, 11,153, 27, 95, 88,112,135,229, 33,213, 63,
 42,195,174,227,219,160,189,174, 64, 59,227,181,123, 11, 60,245,236,222,226,146,
168, 81,182,180, 22,191,119,125, 85,185,174, 10,199,138, 81, 83,100,186,209,248,
 52,169,165,241, 96,133, 16,231,135,230,245,217, 88, 41,185,169,197, 36, 11,133,
 20,205, 98, 40,221,221,  0, 39, 65, 81,174, 39,172,231,201, 29, 55,  8, 49,110,
247,106,245,197,104,173, 48,177, 69, 73, 26,104, 11,127, 80, 56,216,182,205,199,
152,223,  7,118,250,127, 27,137,151,163, 52,212,167,240,135, 65, 42,245,242,  0,
 25, 16,213,120, 30, 28,147,171,245, 22,190,154,  6,254, 70,  0, 14,220,144,221,
159, 67,216, 78, 99,160,178,128, 63,138, 88,188, 42,238, 88, 66,134,189, 80,  0,
 75, 20,120,165,165,155, 24, 29,145, 84, 65, 81,  8,166,134,158,217,208, 69,158,
 49, 69,176, 70, 50,228,  3, 81,  4,114,189,  2,140,241,174, 53,128, 93,103, 78,
145, 63,139, 78, 26, 68, 43,152,148,163,245,160,243, 25, 72,122, 75,203,155,177,
  9, 93, 93,103,  5,224,199,176,100,  8,  9, 48,178, 27, 97,139,104,215, 84,164,
173,174,128, 96, 38,174,237,216,116,216, 83,215,114,113,113, 78,243, 98,245, 59,
114,124,107,  5,159,251,114,171,212, 82,163,  1, 99,171,  0,151,123, 91,187,  5,
 60, 54,124,125,219,175,181, 59,242,130,214,213,173,112, 45, 74, 49, 10,133,168,
187, 78,239,192, 84,  6, 13, 78,171, 35,156,120,142,233,  0,231, 44, 16, 68, 50,
224, 28, 44, 66,191,133, 29,235, 31, 77,195,112,209, 65, 56,226, 46,187,238,133,
130,147,195,216, 97,252,141,255,211,113,115,  1,185,208,174,135, 85,220,165,164,
 23, 48,189,  5,130,222,175,162,183,225,236, 21,158,121,150,243,121, 69,149, 66,
157, 32,254,177,255, 14,127,232, 85,147,232,224,173,176,209,110,130, 78,210,194,
155,127,120,211,157,139,233, 34,191,183,101,145, 13,139,163,240, 55,159,255, 57,
244,209,252, 38,128,231,123,254,144, 83, 17,111,241,182,233, 24,229,239, 65, 38,
170,255,211,135, 75,181,190, 50, 97,235, 71,103,245, 29, 98,214,130,236,251, 16,
141,188,  1,204,137,187, 58,  0,125,205, 44,118, 87,242,134, 10,197,209,111,243,
 86, 39, 83, 72,141,211,191,215,221,103, 72, 63, 18,  7,116,134, 78,209,113,253,
198,119, 32,183,252, 10,  2, 95,187, 82,197,  1,109, 21,120, 91, 83,109,158,240,
117,133,237,174,129,188, 19,132, 48, 57, 77,170, 35,202, 40,  7,194,241,123,248,
185,179,163,129,159,251, 46,186,130, 79,107,130,223,116, 51, 77, 95,156,235,144,
 57,  0, 39,143,183,173, 78, 25,254,116,179, 51, 52, 39,  4,102,203,119, 31, 88,
193, 25,  6, 30, 72,205,231,110,200,116,  1,221, 88,132,234,136,192, 87,251, 98,
242, 46,153,225,184,175,115,231,  3, 61, 68,209,254,117,140,149, 44,242,189, 38,
 87,228,136, 78,140, 15, 88,172,135,118,251,161,219, 16,239, 51, 66,248,  1, 21,
185, 25, 19,160,244, 75,141,163,131,  0,174,193,217, 10, 71,176, 99,  5,139, 44,
236,227, 24,217,109, 80,202, 98, 33, 21,110, 47,  5,236, 75,118,250, 24,209,110,
167,202,120, 64, 58, 80,104,177,157,193,221,112, 93,237, 66,222,208,173, 20,235,
198, 82,105,117,198, 75, 19, 40,157, 80,193,189,184,245,  0,  2, 42,128,211, 57,
124, 33, 41,115, 65, 50,  9,253,207,146,  4, 57, 17, 96,214,148,  4,161,155,144,
 37,162,163,249,204,138, 51,135, 32, 26,149, 83,122, 49,193, 28, 31,231, 44, 33,
250,247, 13,241, 29,229, 21,111, 54, 79,171,219,171,160,  9, 65,106,125,161, 95,
169,  7,227,248,142, 18,198, 80,241, 73,  4, 14,249, 84, 15, 60,197,112, 76, 54,
152,152,213, 52, 69,153, 86,254, 47,230,  9, 91,152,207, 43, 67,209, 69, 16,238,
244, 71,239,135, 38,239,122,118,149,195,206, 80, 48,229,239,140,166,238, 27, 35,
 52, 78,240,253, 24,190,233,133,134,166,128,239,186,137,235, 32, 90, 46,219,178,
 96,120,118, 68,171,136, 35,182,148,206,117, 99,235,113, 36, 97, 32,214,163,104,
144,136,  0, 60, 47,253,122,135,173, 15, 59, 95, 96,227,150,151,203, 35,109,174,
152,114,  3,162,237, 74, 45, 30,245, 27,164, 99,248,253,  8,230, 21,175,200,108,
241, 28,163, 81, 83,133,194,189, 86, 12,220,143, 42,103,215,114,115,  9,115, 76,
 27, 89,121, 75, 41, 19,128,231,145,132,156,212,150,163,105,221, 81,181, 22, 49,
137,112,250,135, 32,178,188, 97, 58, 55,247, 99,179, 78, 22,129, 11,109,184,117,
214,116,121, 57,  8, 99,  7,194,129, 45,200,223,188,157,218,184,172,133, 89, 75,
 16, 60, 38,112, 12, 47, 89, 62,242,113,181, 62, 52, 83,160,162,222,228,140, 67,
  7,205,233, 16, 76,173, 54,171,102,  0,199, 28,179,134,206,157, 23,167, 37,158,
 42,103,160, 15,
} ;

// ../Source/add/template/GB_add_sparse_template.c:
uint8_t GB_JITpackage_56 [1733] = {
 40,181, 47,253, 96,254, 34,221, 53,  0,  6,253,178, 40,192, 84,177, 14,104, 89,
224,245,150,180,253, 21, 50,184,248, 22,191,189,145,102,196,192,176, 96,168, 50,
 69, 34, 56,115,192, 68,179,219,166, 40,116, 20,231,  2,169,  0,159,  0,166,  0,
157, 55, 27,170, 88,  7,149, 13, 58,150,  0, 26,235,145,194, 79,125,225,113, 99,
242,102, 24,250,221,106,  6,159, 69,  0,104, 62,231,150, 89, 24,202, 18, 84,157,
250,171,220,189,178, 78,161,100,126,235, 41,  4, 84,129,165, 53, 12, 90,247,204,
109,153,201, 76, 59, 70, 88, 26,211,198, 36,199,146,209, 96, 65,197,  6,185,141,
219,115,156,181, 14,233,249,156,238,211, 65,  1, 65,129, 37,  1, 67, 80,112,  9,
139, 62, 97,  9,  2, 27, 78,185,143,104,185,134,228,197,167,143,227, 60,205,194,
251,144,249,116,150,219,135,114,219,142,104,151, 99,121,235,180,181,144, 47,116,
 52,214,167, 87,113,149,245,103, 58,195,105, 67,157,175,198, 23, 90,124,197,  8,
175,247,240,203,133, 98,185, 92,  2,152,  9,147, 33, 72, 71, 98,212,115,139,173,
 97,248, 18,189,172,  8, 71,216, 87,203, 87,104,163,179,231,132, 23,218, 31,134,
 58,224,181,  2,214, 11, 36,143, 41, 19, 89,215, 48,216,167,242,184,229,205,180,
159,233, 86,177,103, 48, 47,161, 80,164, 40,211,183, 94,241,167,251,166, 53,102,
110,117,160, 70, 64,143, 88,106,217,250,197,182,155,113,158, 27,238,251,172, 30,
223, 26, 27,111,  0, 83, 99,136,189,103,164, 80,123,174,180,198,135,212, 25,171,
150, 59,244,214, 46,126,170,241,132,217,  7,134,161,107,100, 90, 11,143,233,221,
114,223,143,100, 73, 13, 52,134,154,173,249, 28, 14,  6,197, 49, 60,149,143,141,
 49,180,157,211,214,242,167, 24,206,186, 76, 70,218, 27,149,153, 74, 22,233,167,
226,109,144,166, 18,166, 98, 89,201,178,214,218, 60, 68, 68,191,240,108, 62, 31,
135,169, 88,150,226,248,111, 89, 28,105, 95,147,101, 73,168,  7, 38, 29,179,249,
 56,  8,139,171,161,193,  9,124,124,210,172,232,214,165,189,135, 87,247,176,180,
252, 49,121, 84, 26, 42, 15,130,235,173, 33, 90,241,133, 21,107, 60,251,228, 88,
131,188,103, 86,223,152,156,248,240,180, 30,119,134,183,109, 61,124,244,140,246,
148, 48,150, 87, 85,116, 53,149,217,103,173,160,103, 12,167,  2,197,177,241,140,
 37,231,226,213, 51,190, 50,251,120,190, 12, 16, 50,149,183,102, 43, 47,134, 59,
230,220, 29,149, 10,190,230, 10, 39,120,245, 40,115, 20, 20,202,137,157, 62,213,
 45, 43,202,234,132, 84,102, 39,191,110,197,242,234, 52,238, 72,158,141,133,  6,
196, 77, 76,190,249,120,156,197,231,250, 68, 92,157,  0,140,234, 84,122,  9,120,
199,109, 98,116,226,227, 58, 87,  5,  5,103, 67,225,217, 76, 92, 23, 17, 18, 89,
199, 91, 95,121,245,133,  9,105,149,217, 86,205,123, 15,244,222,  3,129,222,123,
239,129,222,123,239,189,247,222,123,239,189,247,222, 36,223,123,239, 68,202,247,
 64,240,133,203, 73, 28,169,132,141,105, 71,152, 47,204,248,202, 78,165,131,152,
202,228, 92,100, 23, 56, 62, 54,158,185,199, 25, 46,185,171,230,203,138,126,101,
166,205,225,220,115,110, 12,218,176,188,134, 73, 45,228, 19,  7,198, 66, 81,148,
179, 27, 23,113,147,116,211,  3,129,193,168,129,181, 82, 70, 70, 68, 68,164, 32,
 73, 10,105, 12,209, 12, 33,198, 65,  9,105,121,146,160, 36, 13,114, 20,130,224,
136, 33,134, 16, 72, 12, 65,  2, 25, 17,  9,132, 36,102, 68, 68,197,  3,233,  1,
 74,221,218,194,250, 41, 35,215,247, 26,108,233, 50,198, 33, 70,235, 80, 61,105,
 90, 84, 15,112, 80, 85, 35,233, 26,207, 81,223,187, 82,132, 81, 39, 25,155, 52,
 30,168,254,185,  5,176,210,114,219,169,161,189,176,159, 23,118,156,147, 91, 11,
 58, 75, 29,216, 35,242, 38,241, 25, 28,221, 90,142,178,153, 75, 87,135, 13,209,
135,136, 18,254,249,169,194,160, 51,186,178, 58,223, 59,160,112,198,218, 84,155,
181,101,109, 11, 30, 67,196,224,116,138,  2,214,148,218,232,213, 64, 38,172, 26,
  7,145, 62,154,160, 76, 73,246,226, 68,  5,115,216, 46, 87, 47, 86,226, 53,133,
220,186,121,195,212,129,  6,242, 19,210,106,230,169,194,104,230,226,105, 85, 24,
255, 13,123, 89,174, 35,147, 35,233, 29,220,104,183,124, 71,183,122,  9, 60,200,
 38, 25,103,211,126, 55,172,168,218,136,120,231, 15, 76,162, 73,183, 40,152,135,
 35, 66,219, 41,113,186,150, 51,227,116,197,103,162, 23, 48,172, 88,243,224,168,
 15,246,131,108,102,213,243, 62, 59,148,111,239,225,110,185,209,246,113,228,243,
142,136,146,155,208, 28, 65,143,124,207,101, 13,141,  1,234, 53, 50, 44,255,181,
252,128, 68,174,115,134,160, 25,109,218,156,183,111, 45, 13,214,202, 54, 51, 76,
 82, 41, 37,122,130,137, 30, 24, 72,240,112,192,250,160, 96,204,134,114,218,111,
232, 26, 25, 34, 87, 50,170,  8, 49,109, 69,  8,217,136, 47,141,138,137,117,149,
180, 64, 59,189,198,115, 59,190, 31, 80,184, 32,151,131,  2,115,114,128,133, 49,
 31,216,130,154,132, 13,228,251,152,165,  3,219,139, 37, 92,182,112,121, 90,225,
 84, 68,136,222, 63,136,130, 98, 19,102,190, 59,117,239,174,190,124,155, 55,105,
 54,227, 51,255,163, 42,112,132,186, 53, 89,  7,150,100,141, 39, 29,145,132,227,
130,173, 18, 18, 99,221,125,222,208,250, 67,142,138, 47, 13,  5,112, 32,187,252,
226,  9,198, 42,128, 36, 98,120,154, 29,146, 12,139, 96, 64,190,212,213,133,118,
233,137,195,218,190,108,201,240,216,124, 61, 54,215, 99, 10,167, 56,180,149,197,
244, 79, 95,205,104,204,146,129, 24,218,  5,102,246, 85,138,168, 93, 95, 58,203,
211, 84, 80, 97, 62, 95,184,225,195, 44, 52, 73,130,141, 93, 69,100, 30,170,204,
 44,236,204,222, 58,209, 46, 39, 86,243,246,196,166, 47,191,107, 49,161,  4,162,
107,111,215,100,107, 16, 45,155,202,161, 61,142, 12,192,136,156, 77,  9,192,243,
130, 38,142,  9,212,144, 49, 11,128,202,193, 82,215, 10,135,247,165,212, 64, 12,
 99,214,184, 59,181,251, 39, 40,102, 39, 54,168,214,213, 57,123,243,  4,  0,120,
218,185, 15, 68,236,100,143, 85,172,  4, 15,223, 90, 92, 94,241,126,250, 94,161,
142, 42, 93, 64,172, 68,213, 46,185,158,215,210, 43, 60, 49,176,123,122,158,231,
183, 92,133,191, 93, 45, 54,123,101,111,133,177,129, 74,127, 17,  5, 95,111,129,
211,220, 66,109, 38,162,130, 47,210,212,120,121,129,106,207,113,251, 62,138,117,
110, 37,210,142,190,  9,  6,125,141,  0, 95, 68, 63,171,243,135,173,208,220,191,
 69,192,  1, 40, 17, 33,102,118,129,188, 97,228,158,245,219,234, 69, 22, 18,135,
 48,182, 38,154,215,  8,220, 22,236,187,236, 13,177,153, 42,224, 74,230, 62,195,
194,121,139, 59,249,169,209,246,134, 26, 40,125,241,213,  0, 21, 48,110, 65,222,
 74,132, 63,230,206, 13,153,233, 36, 97, 74,177,110,182, 21,170,237,230,135,132,
 72, 89,185, 21,  7,239, 82,193,222, 49,  3,149,112,190, 11, 20, 46, 81, 20, 35,
154,161,227, 93,238,158,174, 37,109,243,139,165, 51, 10, 61, 73, 39,172,135,190,
 96,249,255,100, 20,124,170,176, 48,105,255, 43,243,212,151,251,167,114, 30, 35,
 80,138,208,147, 69,145,215,243,193,112,130, 16,141,245, 33,  3,149,242,119,111,
103,152,101,197, 64,212,160,111, 98, 59, 75,200,209,212,115, 38, 55,130,  2, 12,
126,221, 92,153, 80,216,  2,188,194,192,140,240,192,107,  8,158,170, 44,247,156,
 66,228,199,178,206, 81, 62,156,194,172, 44,162,112,123, 34, 16,235, 75, 27, 72,
 15, 90, 57,112,173,180,164, 81,133,255, 21, 15, 52,104,198,229,229,179,143,161,
139,251,140, 94,164,135, 75,  7,249,152, 52, 47,254, 96,  2, 84, 82,200, 67,175,
119,152,245,247,203,199,145, 71,139,170,149,107, 12,
} ;

// ../Source/add/template/GB_add_template.c:
uint8_t GB_JITpackage_57 [1725] = {
 40,181, 47,253, 96,133, 25,157, 53,  0,198,253,184, 40,192, 84,117, 14,228, 94,
 61,159,223, 62,243,235,117,123, 70,152, 78,202,114,132,127, 75,103,125,  9,148,
  8,  9,153,  4,147, 15, 22,251,111,138,  2,193,117, 51,169,  0,174,  0,173,  0,
 25,237,219,122,220, 21,204,182,191,221, 11,188,185,124,156,109,136, 67,143,231,
 16,251,180,117,141,115,253,124,246,124,237,113, 95,237,150,138,189,213, 98, 92,
211, 98,227,154,209, 19,238, 28,126,222,157,209, 65,133,162, 52,151,209, 47,222,
  2,118,221,106,182,173,105, 40,141,109,103,117, 67,209,192,120, 42, 90,131,128,
141,251,115,156,185,142,250,121,215,197, 79, 11,212,  1, 69,105, 64, 56,160, 62,
201,164, 79,184,130, 80,204, 43,241, 33, 46, 95,175,130, 62, 89,113, 35,185,143,
130, 20,150,198, 32,253,172,206, 53,180, 34,128,136, 10, 98,126,146,  5,241, 50,
 15,222,237,148,102,233, 17, 26, 83,238,251, 45,157,105,247,121,157, 47, 77,163,
151,164,184,129, 65, 68, 49, 48,  8,221,189, 88,227,174, 61,177,  2,105,228, 71,
189, 92,177, 11,215, 43, 70,155, 12,231,147,185,184, 64, 26,139,173,181,173, 10,
216,238, 64, 20, 24,176,  8, 10, 22,159,179, 10,102,220, 32,193,243,229, 80,107,
173,241,  3,242, 60,124,146,177,189,217,167, 47, 74,207,124,226,102,102, 48,215,
 23, 31,174,213,108,235,172, 62,201, 79,241,185, 59, 30, 69, 35, 81,116,144, 27,
147,242,  5,239,232, 47,243,150,108, 27, 55,248,213, 79, 60,166, 42,197,111, 21,
225,156,142,134,131,145,177, 52, 25,153,203,210,180,173, 91,107,  2,150, 45,132,
 93, 11,177,133,210,  6,188, 16,123, 97,246,  6,233,113,238, 66,220,224,212, 93,
135,173,152,118, 86, 59,124,176,226, 15, 76,243,219,214,137,191, 50,193,155,179,
  6,225,  2, 23,  6, 19,109, 37,171, 96,219,238,152,112,215, 22,236,143,135,232,
118, 90, 65, 62, 81,212, 43,218,229,114,123,207,116,251,110,246,182, 23,188,248,
 19,120, 51,253,105,166,154,237,175,181, 92, 67,216, 67,157,189,215, 26,135,  8,
216,222,154,235,169,151, 68, 80,242,100, 18, 34,221, 34, 33,125, 34, 85,143, 62,
  2,240,173, 62, 92, 64, 19,227,  3,178, 66, 79,213,153,215,133, 21,175,  9,  9,
201, 37,240, 94, 25,235, 19, 61, 22,254, 84, 84,  7,251, 11,113,213,129,247,124,
181, 72,197, 33, 25,207,  6,232,218,108, 48, 56, 85, 85, 85, 85, 85, 85,149,148,
 82, 74, 41,165,148, 82, 74, 41,165,220,170,102, 31,168,132,122,113,125, 99, 15,
 81,239, 50,158,203, 83,238, 66,175,251,163,118, 54,148,126,  9, 81, 36,109, 40,
 80,114,113,157, 72, 50,132,226,154,141, 75,230,172, 35,151,151,143,160, 12,197,
 35,199,229, 36, 37, 38,201,201, 20,191, 41, 36, 74,241,194,196,206, 38, 55,  6,
 82,124, 97,159, 60, 42, 29,176,223,237, 92,155,200,233,104, 64, 26,171,227,185,
 56, 26,208, 70,131, 33, 59,234,133,246, 22, 42, 10,200, 42,  6,  1,111, 45,236,
 50, 59, 57,216, 32,109, 37, 92, 63,179,218, 93,204, 11, 97,132, 92,113, 99,154,
 61,225, 22,233, 90,215,220, 37, 98,237, 69,108, 38, 29,179,201, 84,112,230,172,
 83,173,115,206,249,205,111, 86, 85, 85, 73, 41, 37,199,113,156,188,178,115,231,
156, 83, 74, 41, 99,140, 29, 41, 47, 82, 78,252, 93, 23,110, 23, 79,  0,233,160,
 79,198,178,226,228,212, 47, 23,129,199, 10, 79,129,207,168, 81, 77,132, 70, 70,
 68, 68, 10,146,164,144,214,241, 12, 33, 10, 66,  6,217,121,130,120, 56, 17,161,
 20,130,115,132, 49, 98,148, 64,  2, 17,  9,100,  2, 17,138, 34, 73,146, 54,166,
 22,128, 26,232, 67,176, 67,197,189,150,151, 11,224,106,246,117,  7,225, 25,167,
100, 95,120,137,117, 75, 74,161,127, 33,125,100, 35,239, 42, 93, 89,179,147,105,
196,192,145, 55, 66,215, 78,169,  0, 13,144, 89, 66, 18,172,171,  5,215, 73,238,
231,242, 86,124,188,188,114, 31,237,182,145,135,169,233,106, 69,168,221, 44,159,
 90,215, 82,190,168,146,165, 62,193,140, 47,192, 95,  1, 51, 64,166, 58, 16, 91,
166,123, 43,194,110, 29, 70, 53,222, 11,238,213,198,155,208, 65, 61, 63, 40,216,
125,225,161,112,118,130,170,171,165, 54, 41,147, 22,  5,146,130,176, 83, 42,135,
183, 58,209, 31,169,164,233,144,224, 40, 43, 84, 97,235,188,128,233,105, 47, 58,
214,178, 29, 60,243,171,142, 82,156,205, 32,144, 98,147,165,104,166,229, 33, 88,
137, 88, 56,232,125, 11,176, 12, 49,138,251,141,214,226, 51, 84, 35, 24,  4,247,
 93,248,253,229,  4,135, 13, 73,241,237, 37,176, 58,133,184,215, 53,106,151,226,
208,213,171, 94,194, 31,111,191, 74,205,244, 22,208,  9,167,109,224, 91,107,151,
102, 97, 71,140,  4,  2, 11, 23,141, 71,233, 21,116, 76,150,200,135,229,111,174,
 18,248,253, 10,139, 99, 49,144,  7, 54, 33,107,238, 52,149, 44, 20, 98,222,182,
254,154, 93,136, 97,200, 78, 11,124,194, 97,254,126, 84,239,130,163, 41,104,186,
253,209, 43,132, 18, 54,207,200, 71,141,121,119, 60,187, 33,165,130, 94, 90,195,
240,239,226,156,144,201,147, 81,152,124,250,132, 66,221, 90, 70,120,164,236, 14,
144, 45,  2,  4, 70,130, 98, 93,242,197,234,224,148, 19,  3,225,163,113,249, 91,
242,219,174,141, 38,242,184,223,191,159,104,  0, 11,113, 72, 34, 57, 91, 97,109,
  1,143, 87,128,157,174, 83,193,154,253, 88,243,204,117,216,  7,184,199,147, 95,
 97, 16,107,247, 86, 49, 66, 99, 38, 35,106, 22, 10, 84,210,203, 41,111,230,144,
 15,229,205,  4, 48,151, 17,205, 65,128,249,  3, 17, 96,146,240,210,128,214,114,
151,173, 67, 40, 81,180,158,120,182,113,  9, 49, 12,132,208,196,145,141, 70,226,
 15,162,247,158, 23, 24, 87,129,  6,192,129, 57, 72,220, 32,168,136,225,231,136,
113,227, 37, 10, 28,102,133,137, 28,152, 42,210, 11,139,176,221,198,119,156, 23,
163,241,167, 47,200, 37,113, 73,220, 72,118,139,162,143, 42,175, 48, 66,244,148,
 94, 81,186,222, 34, 74,146,113, 29, 79, 43,249, 90, 97,184,238,223,122,137,118,
201,  4,203,108,222, 46,  3, 73,227,119,114,162, 18,150,193, 91, 30,233,188,247,
 10,100, 38,161,135, 34,166,  3,200,245,207,116,135, 68, 68, 12,176,135, 25,193,
199,237, 21, 99, 33, 51,141,222,128,209,149,220,129,254,115,236, 24,205, 20,109,
 91, 44,119, 51, 51,242, 11,122, 86,248,179,197,111,174, 68,166,  0, 52,244, 99,
104,164, 93,118, 99,177, 20, 69, 18,  3,110,217,138, 41, 42,107,231,102,165, 24,
 40, 23, 24, 76, 46,189,  1,194, 14,247, 69, 84,107,199,110,247, 53,209, 53,161,
136, 78, 86,249,149,160,135,181,167,228,162,114,101,187, 45,250,120, 61,214,181,
176, 27,179,114,189, 87,206,124,123,164, 84, 93,240,104,174,162, 61, 66, 40, 95,
191,119, 21,117, 68,251,185,134,214, 68,220,246,252,246,207,100,187,126,224,161,
244, 30, 82,138, 60, 62, 50,183,241,130, 18, 72, 32, 92,  7,128,236,234,201, 78,
217, 43, 66, 98,145,168, 70, 51, 32,197,132,239, 44,193, 63,173, 48, 27,174, 93,
216,144, 35, 11,166, 86,157, 81, 89,233, 65,129,148,191, 55, 79,191,116,105, 92,
216,110, 20,135, 15, 18,229, 28,202,251, 89,155, 43,185,222,125,218,  9,208,165,
128,147,241,194,173,122, 81,139,112,132,161, 83,145,191,222,236, 35, 93, 30,168,
219, 88,170,211, 49,197,188, 87,247,168,195, 39,125,156,166, 27,197,  6,109, 64,
 89,220, 22,177,  2, 87,155, 64,  3,152, 29,234,217, 51, 29,193,220,186, 56, 46,
138, 54, 26,190,128,  0,239,132,197,212,118,149,189, 43,  2, 67, 86, 59, 58, 16,
151, 73,234,159,123, 62,183,184, 57,  4, 75,189,208,167,210, 42,147, 50,106,249,
 90, 70,243,155,155,102,171, 50,211,191, 13,201,174,193,132,214,225,110,152,224,
 89,165,135,204,  9,
} ;

// ../Source/apply/template/GB_apply_bind1st_template.c:
uint8_t GB_JITpackage_58 [394] = {
 40,181, 47,253, 96, 63,  2,  5, 12,  0,102,151, 74, 33,  0,181,142,  1,202,145,
 96,116,103,248,176, 53, 67,250,175, 42, 10,181,213,164,118,168,131,136, 70,112,
 23,243,255,127,175, 15, 33, 66,  0, 67,  0, 62,  0,135,207, 77,126,210, 55, 84,
 33, 39, 88, 23,113,219,  3, 93,204,167,139, 53,161, 92,174, 95,132, 97,245, 87,
243,197,238, 11, 94,226,164, 83, 40,159,189, 63, 30, 94,103,216, 93,187, 12,178,
 59,219,218,192,193, 87,203, 68, 93,206, 53,163,145, 23, 10,145, 42, 20,  2,215,
 52,190,193,188, 65, 47, 11,175, 79, 41, 56, 86,217, 96,178,235,127, 36,197,138,
112,160, 44,183,213,108,157,241,217,219,185, 27, 91,142,132,178, 26,219,237, 78,
 40, 13,164, 66,224,216,208,103,181,181, 92,111,206,115, 45,239, 58,235, 83,226,
 80, 29,168,133,161, 10,141, 87,127, 60,203,255,113,110,119,215,173,165,237, 64,
142,229, 54,253,137,165,230, 84,251,113, 59,  3,129,248,159,215,121,103,187,174,
126, 53, 63,131,188, 87,144,167,126, 57,144,191, 51,132, 98,227, 75, 41,165,115,
110, 48,227,155,133, 82, 10, 30, 49,150, 98,169,250, 20, 94,242, 21, 10,118,145,
100, 48,171,187,218,249,148, 63,133,244, 19,  6,139,204,207,213,228, 41,102,177,
 38, 23,  6,177, 32,190, 27,123,219,231,204,159, 52, 42, 79, 51,141, 70,  0,242,
157,251,120,210, 96, 48,194,218, 29,207, 15, 34, 32, 96,130, 49,166,243, 78,  8,
 80,184,246, 29,199,  1, 73,233,106, 63, 12,175, 84,235, 29,160, 98,206,177, 35,
131, 17,107, 91,164,182,102,194,189,217, 29,220,129,212,221,105, 38, 70,  4, 48,
 95,251,168,  8,220,111,208,112,204, 70,144,167, 53,230,147, 23,157, 98,189, 65,
147,134, 48, 19, 58,  2,172,161, 14, 56, 90, 20,117,110,
} ;

// ../Source/apply/template/GB_apply_bind2nd_template.c:
uint8_t GB_JITpackage_59 [393] = {
 40,181, 47,253, 96, 63,  2,253, 11,  0,134,215, 74, 32,  0,179, 60,108,107, 33,
176,174,128, 85,246,157, 75,175,223, 85,155, 56,193, 54,221,129,133,102, 11, 15,
 27,255,255,187, 63,188, 65,  0, 67,  0, 62,  0,213, 75, 44,254,228,248, 99, 31,
 79,160,255,105,157,219,240,229,167,133, 74, 28,218,182, 29, 68,113,121,103,183,
229,118,236, 89,160,252, 38,141,191,185,111, 60,200,122,197,237, 54,239,237,246,
154,233, 42,211,120, 83,191,188,183,173, 14,200, 79, 19,148,166, 41,148, 46,190,
123,187,123, 92,  5, 89, 47,163,224, 47,138,230, 82,173,255,135, 34, 72, 17, 42,
233,106,152,221,244, 21,221,197, 28,220,245,205, 34,210,229,250, 98, 88, 34,101,
 30, 20, 66,118, 63,221,229,183,242,188,107, 29, 92,249,156,233,207, 67, 69, 85,
 82,162, 64,  5,191,120,234, 27,191,227,255, 67,137,225,110, 59,143, 55,123,217,
213, 48,254, 82, 71,158,217,219,105,189,110,158,254,142,227,124,190, 57,219,206,
238,223, 27,247,118,235,216,110,  7,246,247,106, 64,116,141,165,252, 98, 20,124,
255, 26,141, 43,136,210, 16,142,224,136,250, 73,253,252,172,248,148,201,101,137,
 96,174,203,179,229,252,220, 63, 65,244,231,229,130, 72, 15,182,241,233, 85,161,
 18,235,122, 92, 79,227,174, 57,236,165,220, 63, 55, 52, 62,173, 27,  7,  4, 16,
159,131, 31,190,104, 48,  8,105,251,140,223,  1, 33, 32,112,  2, 25, 91,121, 14,
217,236,130,195,128,164,187,218, 14,195, 95,170, 22,  7,168,124,231,208,145, 33,
136,181, 45,178, 90, 51,225,222,236, 14,237, 80,134,121, 34,219,123,198,195, 24,
 46,236, 81, 10,147,  8,249,138, 33, 79,107,204, 39, 47, 58,197,122,131, 38, 25,
194, 76,232,  8,176,134, 58,224,104, 81,180,184,  1,
} ;

// ../Source/apply/template/GB_apply_unop_ijp_template.c:
uint8_t GB_JITpackage_60 [751] = {
 40,181, 47,253, 96, 80,  8, 45, 23,  0, 54,228,107, 32,240, 24,231,172, 23, 52,
  1,145,122,103,181,114, 99,169,  2,218,191, 41, 90,184, 43, 49, 44,234,  1, 48,
 97,113, 24,232,121, 47,101,  0, 95,  0, 97,  0,152, 54, 55, 51,132, 79,101, 83,
232, 26,117, 27, 55,231, 56,127,164,201, 57,  8,106,143,139,196, 33, 65,104, 32,
 14,137,103, 28,246,136, 39, 74, 86, 94,208,190,250,114, 13,167,231,177,163,101,
 38,159,149,247,226,104,124,165,237,116,158,167,206, 85, 58,137,206,142,182,237,
238, 49,211,176,219,250,200, 41,119,116,150,160, 13, 59,111,182, 52, 55, 91,233,
105, 91,129,214,202,109,114,185,193,112, 17, 12,134,205, 77, 16,107, 91,198,119,
122,166,103,110,222,140,251, 10,158, 55,  5, 35,211,249,140,233,255,235, 98, 93,
 87,225, 54,  8, 74,238,253,229, 83,237, 97,189,222,187,158,182,114, 35,  9,129,
242,104,101,152,231,232,125,229, 41,239,168,156,148,138, 31,241,188,118, 15,243,
131,163,240, 84,122,143, 78, 37,119,237, 58, 20, 18,132,254, 56,105,181, 59,110,
 79,111,102,218, 29,134,208,  1,216,227,162, 80,  4,  4,229,179,188,233,214,212,
 43, 61,238,218,157, 74,238,205,193,  0,242,248,225, 17, 12, 17,185, 25, 74,186,
234,176,  6, 79, 93,127, 28,126, 70, 55, 13,195,157,236,251,229, 45, 60,209,223,
234, 29,188,210,222,134,245, 50, 36,201,107,  3,221,204,223, 64, 73,235,204, 19,
 87,251,200, 85,148, 63,158,184,224,202,140, 45, 54, 97,153,233, 64,130,143,205,
212,155,246,200,  3,215,229,117, 71, 79,129,235,106, 93, 45,139,125,163,217, 64,
153,205, 70, 19,217, 80,159,232,204, 89,102, 31, 71,163,201,  5,128,221,155,135,
220,254,113,155,149, 16,131,152,209,  6, 81,210,218, 24, 99,140, 29,237,199, 77,
179,155,205, 99,185, 60, 30, 63,109,251, 38,151, 18,158, 95,254,106,116, 90,223,
117,150,183,109,125,143, 94,243, 85,217,189,250,220,209,233, 29,114,211, 31,207,
 50, 71,116,  4,128,128,168, 81,181, 66,166, 70, 68,  2,  9, 68, 36, 77, 10,233,
 48, 66,130, 16,179,236,210,216, 68,136,243,140, 18, 64, 67,202, 36, 94,137, 68,
242,199,  7,128,233, 56,205,154, 17,105, 98,171,253,191,219,211, 52,112,171, 31,
191,180, 14, 74, 71,195, 68,171, 15,137, 11,213,230, 46,214,183, 88,248,119,153,
 22,108, 26,200,181,128,156,130, 28, 48,153,215,118,108,143,190,250, 74, 50,177,
 85,150,156,247,215,101, 54,107,191,100,122, 20,169,148, 45, 37,167,210,134, 49,
141,124,215,191, 99,196, 50, 16,114,149,223, 42, 29, 10,159,237, 32, 88, 12,134,
 43,223, 15,121,193, 48,182, 83,136, 69, 12, 73,163, 29,  1, 38,162, 30, 33,198,
149, 11, 95, 27,131,208, 52,192,220,105, 43,226, 11,246, 94, 81,125,197,171,157,
190, 25,153,192, 87, 83,134,247, 21, 92,135, 28,146,  9, 59,  9,137, 90,165, 49,
 89,107,224,191,138, 23, 49, 87,103,107, 97, 41,177,116, 43,140,  4,148,221,218,
  5, 54,192,117,134, 77,115, 41,180,132, 72,238,242,111,115, 94,177, 97,  9, 70,
109, 40,111, 57, 29,159,132, 91, 69,242,242,106,221,173,144,242,228, 38,101,159,
 66, 31, 35,133, 22,151,140, 11,179, 79, 77,207,105,111, 66,  7,135, 65,247, 47,
 17, 61, 62,130, 66,  3,205,150,244, 50,105,170,220, 37,198,252,166,137, 82,204,
180, 99,152,  1,250, 34, 67, 41,250, 50,  1,
} ;

// ../Source/apply/template/GB_apply_unop_ip_template.c:
uint8_t GB_JITpackage_61 [432] = {
 40,181, 47,253, 96,239,  3, 53, 13,  0,102,153, 78, 32,240,150,117, 20,152,213,
139, 95, 27,  6,124,  1,150,134,254,234, 29,146, 83, 80, 71,179,158,219, 61,101,
192, 38, 50, 14, 92, 84, 69,  0, 70,  0, 68,  0,115,114, 66,188,105,203, 29, 71,
 57,191, 54,209, 18,217,238,244, 40,141,198,222,188,155,206,244,219, 64,122,219,
221, 84,109,119,145,165,153,237,219,217, 47, 43, 86,191,221, 33,151,188,209,121,
214,203,117,150,151,202,219,217, 79,154,234,189, 83, 70, 40, 47, 20,224,160, 80,
  8, 23,166,143,215, 42, 63, 33,235, 26,226,190,209, 59,116, 59,177, 71,104, 32,
 32,  6,189, 97,243,198, 55,188,166, 26,205,182,179,202,160,177,109,140, 90,  6,
157, 73,134,144, 53,201,107,220,154,227,188,137,168,230,181,198, 95, 10,132,  1,
 49, 96, 28, 12,136, 91, 88,245, 11, 83, 82, 93,191,172, 55, 12,223,178, 50, 86,
 56,155,237,109, 89,114,159,189,215,105,175, 93,235,244,230,253,229,186, 79, 78,
 52,189, 27,184,147,203, 52,132,202,196, 11,167, 18,145,155,138,140, 50, 66,169,
174, 57,126,159,101, 98,145, 45, 45, 73,254,255, 16,162, 32, 36, 72, 58,252, 16,
106,157,217, 47,  0, 97,170,214, 79,187,215,121,125, 77,219, 47,220,184, 54, 76,
 89,247,215,173,158,193, 72,143, 37,147,177,172,209, 69,171, 59,222,159,165,217,
118,216, 45,208,253, 60, 20,  1, 71,  9,  4, 39, 59,255,248,189,227,134, 67,126,
 43, 11,163,121,102, 92,  5, 39, 32, 32, 68,160, 20,186,187,  1, 82,238,222,193,
 40,216, 50, 76,  6,194, 51,131,  9,151, 99,149,132, 16, 75, 14,245,  7, 11,144,
199,172,140,160, 24, 64,202, 22,240, 75,228, 70,172, 91,240,225, 98, 29, 91,108,
  3, 26,188,  0,207,105, 93, 67,195,199, 30, 48, 22, 47,219,123,128,193, 76,245,
181,127,  2, 89,102,244, 80,200, 64, 54,134, 94,178,136,213, 59, 54, 77,134, 48,
147, 59, 38,172,225, 93, 82, 81,168, 40, 24,  2,
} ;

// ../Source/assign/include/GB_assign_shared_definitions.h:
uint8_t GB_JITpackage_62 [13774] = {
 40,181, 47,253,160,147,142,  1,  0, 21,174,  1,154,254,184, 45, 49,160,108,140,
234,  1,218,177,234,137,218, 72,224, 52, 61, 77,235,246, 65,250,224, 74,185,107,
147,132,127,122, 32,177,222, 28,204,180, 60, 37, 60,185,241,197,157,153,240, 58,
188, 14,158,151,163,102,217,  2,202,  2,193,  2, 22,155,197,180,113, 29, 66,149,
 61,151,153, 46, 76,175, 41, 98,194,136, 41,227,113, 32,133,  1,140,238,103,227,
 90, 13,229,196,  8,246,207,104,182,163, 86,207,180,175, 56,168,158, 48,  9, 48,
 80,155,199,233, 72,129,126, 54, 17,  0,231, 31,139, 80,206, 81,227,117, 69,133,
254,127,255,241,130,153,120, 91, 76,128, 33,182,164, 51,107, 51, 15,  0, 78, 63,
 94, 66, 76,232, 23,157,126, 96,153, 42,164, 11,  6,202,  9,115,153,204,  9, 33,
216,215,182,236, 43,191,166, 43,199,244, 51,218,241,241, 76,165,148, 19,179,107,
116, 20, 39,204,196,129,148, 16,206,249,126, 21,250,225,250, 57, 45, 39, 23, 72,
137,147,135, 60,181, 66,231,235,209,146,198,181, 95,245,185, 35,223,214,170,183,
187,188,105,222,149,102, 20,102, 74,148,  7, 19, 98, 38, 11,204,132,156, 72,180,
132,212,210,156,115,206, 57,231,156,115,206, 57,231,156,115, 78,  8, 33,132, 16,
 66,  8, 33,132, 16, 66,  8, 33,132, 16, 66, 41,165,148, 82, 74, 41,165,148, 82,
 74, 41,229, 63,134,225,111,  7,  1, 54,107,177,220,235, 18,129, 39,243,146,101,
156, 69,  1, 49,225,159, 98, 79, 64,137,145, 26, 76, 83,154, 34, 38, 82, 92, 48,
115,211, 44, 53,201,158,144,150, 56, 61,152, 80, 74,180,132,212, 82,253,141,126,
168, 72, 15, 40, 20,138, 74, 75, 36, 13,157,238,178,106, 27,111, 84,203,159,233,
178, 92,253, 94,142,154, 46,144,  2,227,140,180, 35,105,171,114,214,148, 49,165,
158,205,243,202, 82, 29,207,114, 98,133,  2, 98,194, 76, 40, 37,132, 17,170,222,
114, 96,238, 85,217,187,206,182,182, 37,117, 67, 25,245,219,116, 50, 97,129,153,
 20, 30, 64, 52,248,133,241,207,215, 55,123,183,190,142,125,235,114, 71, 76,179,
 98,145, 48, 82, 69,130,152, 60, 76, 15,147, 11,140,152, 83,197,129, 52, 39,108,
 64, 49,157,170, 22,107,175,182,138, 48,165,132,112,206,126, 21,147,205,211,117,
209,239,186,240,142,199, 83,191,140,159,178,129, 41,198,226, 98,145, 19,249,228,
105,  0,  6,185,126, 63,141,186, 85,156,158,176, 76, 76, 15, 46, 19,  8, 13, 65,
130,  6,154, 66,129, 93, 69,253,102,180,103, 87,142, 49,221,186,107, 51, 69,173,
174, 42,245, 59,209, 15, 35, 73, 56,206,158,169,192,153, 54,127, 51,149,115,182,
251,181, 58, 99, 78,235,206,226,126,149,189,178,107,173, 81, 63,203, 40,213,247,
189,122, 92,191,253,210,166,254,122,117,141, 40, 93, 38,149,137,131,201, 89, 95,
 85, 15, 32, 65,164,  3, 72, 48,137,112, 98, 62,184, 88, 32, 76,147,201,  5,162,
 90,149,215,198,180, 43,247, 43,169, 28,115,149,131,104, 28,214, 56, 42,161, 33,
161,189,226, 50,170,126,  0,  9, 44,219, 20,119, 51,174,150,106,191,178,189, 20,
213, 18, 60, 32,  7,  6,191, 40,186,193,142,174,191,245,185,122, 37, 49, 56,174,
 78, 61,133,161,226, 97,  2,170,156,227, 58,246, 75,227,124,105,252,165,179, 12,
246, 35,192,225,225,192, 80,  0,228,225,208, 15,229,244,195,207, 65, 31, 26,130,
221, 93,217,106,143,233, 55, 33,165,193,181,209,235, 32,114,124,233, 54, 61, 63,
 55, 19,224,204,235,245,141,206,112,248, 90,171, 59,186, 32, 92,237,231,175,111,
121, 53, 85,126,233,133,167,170,241, 24,211,169,129,131,110,104, 72,192,208,208,
 16,185,186,230,217,228, 90,155,187,242,170,162, 93,221, 51, 93, 61,155,151, 29,
211,198,158,105,181,113, 25,127,134,255,202,221, 81,148,109, 92,238,118, 14,122,
 69,207,170,143, 30,248, 90,210,  9, 72,  4, 34, 48, 48,196,135, 42,247,140, 95,
110,125,150,169, 80,252,155, 11, 11,245,114,121,130,153, 80,156,222,108,199,102,
147,  1,183,206,201,136, 91,119,209,245,235,112,250,162,223,198,233,150, 44,116,
 19, 12,164, 80, 64,  8, 97,132,142,240, 20,158,184, 57,206, 66,119,183, 81,154,
107,  0, 84,254,226,219, 68,  7,247, 83,160,224,245,132, 61,117,159,201, 29, 79,
 78, 68,188,192,201,156,178,133, 31,230,108,110,  8, 67, 85, 61,114,141,234,220,
  3, 95, 57,141,198,111, 81,175, 15,209, 13, 93,142,162, 44,213, 78,209,219,184,
159,115,184, 70,219, 66,220,150,121,150,209, 75,183,203, 85,149, 83, 92,101,175,
103,186,163, 90,107,188, 98,217,190,168, 75, 29,119,133, 98, 78, 36,202,132, 84,
160, 32,126, 47,116,190, 52,227, 73,234,247,224,183,196, 79,102, 37,190,173, 94,
 53,160,128, 74,  0, 39,209,106,175,109,205, 94,171,177,107,241,123,227,218,103,
134,  7,226, 88,154,194,220,198,117,125, 25, 48,170, 98,124,226, 59, 61,145, 26,
 72,203,197,139, 91,156,254,183,184,245,  4,197,  3,139,133, 50,205,217,142,185,
190,168,191, 52, 89,246,112, 56,224,129, 25, 60,250, 13,240,104,155,251,241,144,
152, 34,255,166, 97, 84,211,111,236,245, 53,175,218,226,140,230,239, 23, 57,179,
171,198,101,150,162,115,235,234, 28, 15,105,215, 90,215,183,214,216, 44,131, 50,
 48,140,150,192, 50, 30,163,165,150,116,252, 87, 85,206, 90,118,195,126,175, 95,
191, 52, 29, 55,168,250,118,107, 74, 31,236,189, 51,187,187,185, 62,245,187,202,
252,114, 18, 50, 74,253,117,141,171,  9, 13, 93,207,153,110, 77,125,102, 51, 90,
247, 72, 60,201,137,146,217,151,  6,103,239,149,123,227, 54,172,205,154, 62, 71,
 63, 17,123,241,157,216,111,117, 52,161, 77, 61,166,153, 57,231,156,115,206, 57,
231,  0, 12, 58,130,  8,230,156,243,255,255,186,174,107,206, 57,233,205, 27,239,
 57,165,126,155, 57, 57,  8,128,169, 72, 20,146,233,204,185,153, 93, 49, 41,147,
202,101,242, 96,194, 72, 18, 93,165,215, 57,188, 54,254,158,179,131, 93, 91,116,
 93,119,105, 70, 41, 76, 41,117, 32,140,224,220,205,175, 65,193,194,182,108, 59,
151, 81,142,126, 25, 15,140,135, 82,104,176,158, 82,  8, 97, 67,  8, 33,132, 16,
 66,  8, 33,132, 23,252,255,135, 16, 66, 72, 97, 75, 50,237, 11, 97,195,126, 15,
 85,120,224,230, 56,189,208, 27,216, 29,159,  7,183,183,129, 15,123, 58, 89, 76,
 88, 96,215,117,142,133,197,102,179,113, 42, 42, 58, 58, 58,156,139,139,142,142,
174,219,116,196, 11,106, 83, 17,187,103,  1,157,142,108,182,190,164,187,180, 54,
216, 80,224,180, 76, 76, 88, 44, 46,176, 34, 53,232,174,220,239,102,251,218, 76,
 51, 78,227, 40,138, 74,138, 24,161,148, 82, 74, 41,165, 35,165,148,218,230,201,
100,164,  1, 82, 74, 41,229,255,255,117, 93,151,148, 82, 74,233,151,246,149,185,
 76, 63, 40,165,246, 64,154, 33,234,  7,206,191,217,252,  7,150,  4,101,202, 49,
126, 43, 63,149, 86, 39, 54,166, 24,130,221,109,150,178,213, 86, 91,171,125, 92,
233,139,116, 93,140, 16,137, 83,236, 72, 71, 26, 20,166, 10, 75,255, 33,236, 53,
191,146, 43,219,  6,241, 69, 21, 24, 24,144, 83,213,175, 91,158,221,111,164,250,
151,129,209,144, 99,119,235,187,108,227, 10,147, 83,213, 98,175,213,184, 22, 51,
248,197,244,113,151,241,231, 45,196,  7, 37,121, 65,125,145,248,244,163, 17,168,
176, 25, 95,155, 81,141,164,114,244, 57,112,254, 46,131,169,100,107, 69,178,148,
  4,115,180,186,148,210, 88,173, 62,108,183,134, 32,204,101, 25,205,187, 44,163,
220,253,235,213,181,110,241,173,170, 87,105,126, 21, 70,143, 67, 81, 76,228,158,
169, 72, 79,203,155,111, 92,186,117, 24, 75,165, 34, 69,114,125,139,225,175,182,
 11,215,100, 94,246, 52,123,117,173, 86,159,102,219,198, 91, 99, 43,124, 60,150,
 35, 53, 14, 67, 96, 67, 28,101,237,128,205,157, 29,191,215,224, 42,179,151,165,
149,103,170,140,179,185, 47,205, 94,123,252,200,133,  8,162,207,241,107, 44,212,
 51,230, 58,242,224,165, 93,165,154,140,156,152, 57,139,189,170,158, 43,173, 79,
 53,191, 13,227, 68,246,133, 81, 59,135,205, 80,171,193,247,190, 92, 41,135,103,
126,239,203,  8,  2,228,213, 98,234,247, 85,142,175,115, 80, 47,  2, 35, 65,232,
178,140,113, 63, 88,103, 63,217, 15, 86,200,178,222, 25,223,183, 58,202, 50,215,
 52,134, 32,168,161,138,216,221, 17,180,165,  2, 89,182,171, 18, 82, 87,126,223,
250,134,221, 93,219,239,152,219,188,230,215,122,216, 47,196,118,195,149, 94,232,
 56,163, 86,119,153,115,124,166,220,178,188,167, 24,201, 25, 71,173,237, 47,133,
189,130, 72, 36, 15,116, 58,106,125, 20, 54,148,208,145, 12,215,167, 25,194,208,
101, 24, 32,152, 68,162,223, 75,164,126,113,242,141,207, 54,222, 56, 83, 80, 69,
  4, 29, 69,150,124,200,182, 29,113,120,119,111, 84,154,101,222,171,156, 70,165,
 23, 85,185,135, 62,202,121,235, 43,171,193,133,168,241, 90, 61,231,191,154,235,
 28, 22, 74, 56, 62,235,110,183,108, 91, 25,189,170,111,208,220,213, 53,156,242,
120, 60, 64,143,199,227, 97,171,182,215,  3,244,226,  3, 84,  1,145,200, 24, 65,
 38, 56,101, 52,164, 97,199,198,128,209,169,212,181,126,  9,217, 86,  9,  9, 15,
  9, 90, 87, 19, 46,205,184,152,192,  0, 97,154,219, 51, 78, 63, 32,114,  1, 92,
224, 25,154,245,131, 11,160,  5, 21,209,123,207,131, 57, 18, 79, 98, 35,117,182,
 60,107,235,155,129,243, 96,191,104, 57, 75, 81, 19,136, 68, 74,  1, 34, 76, 95,
206, 66, 12,224, 14, 16,204, 65, 15,162, 68,177,192,  4, 33, 77,149, 11,  5,102,
114,193,153, 62,229, 91,254,182, 56,195,220,126,159,123,192,111, 71, 17,127,140,
 54, 91, 47,  6, 16,136,231, 91, 99,239,227,120,230,213,198,165, 90,198,142,255,
113,232, 60,203,124,166,184,163,154,140,254,163,150,244, 94,229, 20,205, 54,191,
 49,194,116,211, 18,167,161, 76, 95,198,191,113,183,149,117,125,  2,187,117,140,
 61,171, 46,213,240,219,207, 18, 39, 83,139,104,159,109,155,123,181,149, 77,  7,
 93,215,117, 11,221,207,128,204,175,169,163,214,  7,202, 36,162, 50, 73, 57,  1,
208, 13, 79, 20, 57,215,117, 93, 16,103,148, 67, 97, 67,181,142, 74,121,166,217,
166,121,142, 49, 66,  8, 39,217, 17,126, 56,123,132, 83, 63,185,225, 19,196, 83,
132, 41,128, 61,  2,249, 59,210,207,163, 19,120, 22, 16,112, 42,223,160,252,170,
238,154,252,151,102,112,126,191,174,233,167,123, 22, 28, 28,176, 13,134, 97, 88,
164,227, 63, 47,145, 60, 17,107,  4, 28,199,121,156,238, 12,248, 56,143,163,128,
 17,161,157,  5,  8, 42,162,239,201,226,175,190, 53,215,179, 69,187,242,235,208,
101,174,237,  7,123,250, 34,133,169,126,132,161, 51, 32, 11,157,134, 65, 24, 30,
 39,170,127,237,  4, 49, 12,251, 40,233,247, 38,232,209,234,237, 26,151,102,141,
223, 47,135,171,207, 57,137,145, 98, 94, 76,253, 28,182,182, 56,163, 78, 26,175,
 83, 63, 10,156,227,244,  0, 12,166,140,102,155, 91,210,141, 31,238,248,140, 82,
 76, 73, 17,187,210,248,  3,240,203, 89,141,195,144,238,250, 27,183,209,171,233,
104,130, 98,  2, 94, 32,188,238,  7,211,180,141,132, 81,102,200, 13,163, 51,245,
121,222,185, 88, 38,  9, 73, 74, 41,165,148, 82, 74, 41,255,103,254,108,155, 63,
 31,111, 62,175,103,246,158,232, 98,129,152, 94,196,156,142, 81,  2,163,234, 99,
 81,125, 13,207, 96,  9, 81, 66,227,191, 22,155,211,233, 57,231,156,115,206, 57,
231,156,115,206, 57,231,156, 16, 66,167, 33,132, 16, 66,  8, 33,132, 16, 66,  8,
 33,132, 16, 74, 41,165,148, 82, 74, 41,165,148, 82, 74, 41,101,132,216,175, 27,
 83,208, 15,123,155,183,152, 98,191, 43, 98,219,195,156, 24,163,213, 81,236,138,
234,180, 98,235,170, 62, 68, 71, 21,152, 11,196, 56,116,183, 84,223, 91,224,157,
 74,255, 82,207,118,  1,  5, 57,109,112,219, 94,228, 72,248,228,214,241, 90,  2,
 77,198,  9,  3,144,201,132, 17, 19,147,213,216, 33, 12,206, 68, 51, 40,  3,163,
 91,178,209, 13,150, 75,156, 82, 61,160,  0,  2,  4,120,  2, 60,136,207,199, 20,
188,121,189,135, 99,122,109, 83, 85, 81,236,162,223,197,133,164,187,252, 23,253,
204, 87,145,251,122,126,137, 10,233, 97, 46,247,123, 51,194,254, 89,113,209,150,
213,230, 66, 69, 75,250, 34,211,135,131,  3,196,128,  7,164,223,  1, 12, 12,128,
 76, 85,165,211,115,192, 78, 89, 32, 96, 34, 18, 18, 18, 79,170,253,158,244, 98,
 63,  5,206,164,161,157, 41,191, 95,101,174, 65,219,234, 51,141,164, 83, 63,195,
 29, 77,162, 68,153,211,164, 98,121, 32, 44, 19,134,194,226,248,133, 44, 68, 76,
 10,167,232,214,158, 41,101,163, 74,180, 80, 40,144,106,108,227,234,219, 70,175,
 74,229,241,120, 84,  8,178, 85,227, 97,247,240,144, 41, 85,127,118, 67,232,241,
136, 98, 55,244, 17,148,162, 60,219,232, 84,219,239, 55, 75,245, 55,124,184,123,
196,199,163, 31,241, 45, 69,173,232, 25,234,184,243,198,171, 59,238,  8,126,239,
106,236,213, 15,106,212,247, 76,195,198, 28,143,135,197,  5, 83,153, 76, 20,  4,
 61, 64,143, 70,  8, 65, 21,105,114, 80,145, 30, 42,147,  9,232,225,209,216,245,
186,192,178,237,153,102, 76, 63, 95, 75,213,207,196, 46,243,251,158, 81, 56,123,
106,117,146, 37,168,180,212,108,123,146, 57, 53, 50,  3,  0,  0,  4, 20,179,130,
 24, 20, 14,136,142,100, 50,185, 88, 19,213,246, 84,193,  9,  5, 81, 72,202,  2,
  4, 72,225, 81, 88, 12, 50,128,  3, 66,112, 24,136,226, 51,  8,  3,  0,  0,195,
 33,  8,128,177,136,133,138,179, 59, 51,143,169,143, 48,  4, 10,150, 44, 40,209,
114, 61, 92,234,130,164,206, 60, 65,142,235, 75,128,154,232, 64,175, 84, 66,132,
199,210, 45, 98,196,167,213, 97,232,147,218,215, 64,  5,164, 70,139, 99,168, 18,
 66,181,198,207,186,159, 31,252, 35,215, 74,159,161, 83,  0,148, 74,255,  1,  8,
221,232,130,221,120,150, 46,255, 25,120,111,232,207,157, 59,211,121,238,238,231,
 97, 16,105,178,149,254,123,168,248, 78,156,  7,  3,135, 79, 31,165,235,126,176,
247,209,127,115,212, 69,144,125, 16,211, 83,116,235, 26, 45, 72, 20,189, 85,121,
 39, 64, 72,127,120, 95,153, 35,166, 28, 86, 36,  4,  4, 38,231,167, 70,255,138,
 85,165, 82, 84,228, 33,239, 47,148, 98,127,221,233,  3,116,231,135,138, 28, 33,
191, 62,  6,251, 80,149,142, 35,189, 41,210, 40, 88, 97, 23,129, 82,158,178, 59,
132,235,146,131,244,158,232,151,134,144,110,131, 36, 36,245, 81,149,124,200, 93,
 20, 61,152, 34,125,160,186,123, 36, 82, 68, 48,185,137,180,121,179, 20, 31, 27,
228,232, 24,  5,153, 98, 12,107,211,221, 35, 93,246,214,111,138,240, 75, 50, 79,
252, 72,112, 22,  3, 36,119,138,  3, 32,160, 77,225, 75, 91, 38,231,103, 54,225,
139, 57, 12,205,183,208,233,139, 27,142, 64,231, 39, 86, 79, 31,138, 76,248,163,
134,147, 96,254, 22,177,220,239,169, 94,198, 78,144,211, 17, 85,181, 62,  2, 95,
209, 17, 63,249, 94, 26,104, 87,148, 11,227,160,  2,247, 40,216,164,232, 17,  2,
 54, 18,166,224, 33, 12, 90, 79,168,180, 30,118, 40,229,120, 73, 48, 87,179, 87,
194,234, 31, 22,182, 69,223,137,209,  8, 71, 69, 34,114,172, 60,136, 59,247,124,
222,102,126, 79,105,236, 23,251, 88,103,159, 47, 70,199,187,245, 98,250, 70, 73,
 52, 47,166, 35, 63,242, 21,109,235,  7,177, 72, 41,229,248,106, 94,241, 17, 75,
232, 18, 19,212,101,146, 89,194,211,240,238,250, 90,128,118, 11,199, 18,170, 57,
 68,153, 98,109, 36,189, 83,130,103,  5,195, 78, 27, 67,192, 95,217,244, 54, 89,
109,130,231,183,163,192, 42, 29,136, 41, 72,241, 61, 90,108,138, 99,196,111,193,
 99, 40, 81,235,208,102,203,119,221,228,186,233,218, 26, 21,211, 81, 70,167,111,
255, 49,200,253, 66, 45,124,145, 37, 77, 70,191, 41,123,163,254,157, 21,140,162,
183, 67, 34,248,237,189, 30,255,136, 72,161, 53, 15,212,  7,114, 93,154,104,182,
223, 61,210,192, 56,127, 15,  6, 59, 14,236,  1,233,117, 87,239,122,242, 20,115,
133,209, 31, 45, 73, 57,188, 71,233, 40,198,178,123,211,110,211,167,241, 36,222,
190, 71,149,168,169,120,177,154, 95,162,181, 53,208, 56, 34,166, 95,  2,122,144,
  7, 97,113,241,115,196,162,109,152,  0,  7,206,120,163,143, 13,134,  8,186,  5,
182, 62, 80,144,124, 77,156,120, 36,128,135,145,140, 66,218, 42, 41, 62, 97, 35,
 42, 40, 27, 42, 25,184,193,164,234,147,154, 30,170,102, 36,152, 20, 64,187,178,
183,216, 19, 40,135, 28,133,183,146, 33,199, 24,231, 90,150, 64, 96,141,243, 48,
229, 88, 69,244, 58,183,241,210,247,250, 57,198, 45, 75, 81, 92,159, 15, 27,  3,
  1,207, 99,188,226, 79,196,162,125,158,250, 33,205,162,213,166,143,141,237, 48,
239,214,198, 53, 46, 96,223,196,102,125,169,166,122, 43, 77,246,129, 47, 98, 78,
174,114, 68,217,146,152, 64,194, 57,133,234,172,122, 68,213,194, 34,139, 73,143,
159, 39,116,170,126,113,226,159,231,  4,195,222,254, 25,  0, 95, 39,187, 98,  8,
 44,132, 27,112,249,  1,251, 90,170, 94, 82, 82,225,180, 32,246,  1,239,205,147,
132,186, 26,133,185, 84, 44, 92, 23,219,252,127,111,139, 37,135, 94, 83, 38, 71,
  2, 70,106,237, 63, 36,176, 18,208, 45,107, 66, 49,163, 88,135,167,190,154, 43,
194,116,100,228, 73, 18,247,234,194,169,130, 92,162, 37,226, 76,113,154,207, 35,
150,229,119,164, 49,201, 54, 94,107,251,218, 62, 68, 38,236,240, 62,233,160, 99,
  8,201,184,239,182,170,160, 63,162, 45,225,116,110, 34,147, 47,145,138,134,114,
 95,121,241, 70,255,208,168,  3, 82, 30, 43,116, 13,228,248,130, 45,216,152,255,
191, 14,203, 76, 81, 95,158,255,131,212, 55,134, 61,173,197, 70,184,196, 44, 96,
 45, 17, 16,247,189,254,209,136,137,250,166, 95, 76,104, 39,206,179,237,245,165,
 98,103,177,138,228,113,133,193,204,197, 89, 11,154,160,253,130,253,101, 72,127,
243,226, 74, 21, 20, 87, 52,226,171,136,172,116, 20,192, 54,223,207, 92, 59, 69,
133,204,225, 35, 25,155, 79,171,115,177,161,166,213, 98, 94, 84, 77, 42,240, 45,
239,229, 46,150,185,185, 19, 96, 72,232,129,193,184, 54,214,163,135,167,169,238,
 74,219, 99,180,174, 25,135, 84,189, 65,117, 69,219,210, 93, 45,227,204,194,114,
105,  6, 42,215, 80, 12, 17,237, 29, 62,233, 73, 81,182, 47,197,129, 54,105, 30,
151, 13,146,104,141,144,231,197, 10, 24,109,  9,100, 48,  2, 38,  3,110,245,126,
122,203, 70,203,217,250, 76,145,116, 99, 52,235, 98,118,231,212,213,212,228,157,
157, 40,231,245,234,137,  8, 44,219, 51,105,211,166,244,223, 62,  7,131, 54, 13,
167,159,146,140, 73,225, 64, 64, 82,142, 23, 89,177,157,218, 28, 24,221,238,231,
214, 45,220,175,108,176, 73,168, 17,106,248, 22, 54,241, 80, 77, 43,  9,244,200,
169,236, 38, 30,215,158, 39,145, 48,159,130,190,119,241, 91,143,159,110, 29,103,
253,120,111, 36,193,223,142,133,210,137,198,  7, 42,144,183,126,121,160, 60,100,
175,166,148, 93, 16,133, 96,153,211, 75, 40, 99,100, 24,224,103,105, 64,127, 22,
 44,102,174, 54, 69,127, 53, 66,157,132,184, 78,156, 95,207,219,245,241, 94,209,
 61,211,252,160,217,171,  1,219,101, 76, 91,114,166,161,168,172, 89,201,148,252,
140,136, 85, 34,149, 49,  3, 74,169,220, 52,157, 16, 43, 87,  2,187, 77,226, 56,
206,199, 68,184,145,173,  6,  2, 99,101, 90, 20, 18,103, 30,217, 15,202,168,118,
130,147,223,251,127,125,164, 25,132,169,203,166, 63,249,165, 38,162, 66,220,157,
121,136, 56,149, 37, 35, 86,125, 42,236,156,219,102,139, 33, 69, 87,235,169,122,
 87,122,104, 62,190,232,236,238, 98, 59,161,250,  0,212, 54,157,230,125,188,185,
181,159,100,  9,125,152,246, 22,102,209,232,240,184, 54,239, 82,227, 71,204,125,
227,185, 44, 90, 25, 33,234, 24,224, 33,158,113, 96,194,  4,157,246, 24, 71, 79,
160,225,153, 97,223,229,147, 14, 72,131,237,251,156,  2,225, 74,193,246,162, 64,
229,245,188,196,245,176,146, 88, 25, 72, 49,  7,123,246,220,122,122, 10,134,139,
 52,183,135,203,166, 76, 32,107, 96, 20,139,194, 56,189,141,129,220,228,164, 56,
242,  5, 46, 10,132,161,202,211, 38,111, 31,102,163,155, 43, 26,133,135, 90, 77,
 19, 30,152,195, 69, 46,162, 10, 71, 70,201,153,247,108,180, 16,247,134,182,248,
 19,142, 64,126,173, 89,126,136,231, 27,128,136,243,215,218, 31, 52,167,215,117,
 52,208,159,  4, 79, 79,177,  3,157, 50, 38,229, 36,  0,191,254,174,180,211,128,
238,206,150, 52,137,  1, 28, 58, 18, 15,178,233, 79,  0,167, 26,211, 52,192, 35,
 51,114,252,141,235,  2, 39, 90,252,211, 65, 52,163, 95, 16, 24,143,153,176,232,
 51,189,103, 61, 24, 22,117,  7, 95,115,219,212,123,  0, 32,237,239,231,200, 92,
172, 70,243, 41, 50,241,167,165,171, 12,223,141, 49, 43,147,118,136,121,239,246,
 46,110,234, 35, 46,236,214,233,216,154, 61,183,122, 86,135,154, 51,  8,243,145,
136,243,201,196,229,122,140,175,112, 61,133,176, 49,227, 23, 16, 74,202,175,197,
252, 94,240,138, 71,229, 28, 48,198,100, 29, 15,184, 68,131, 65, 87, 57,168,200,
 87, 39, 48, 19,154,152,193,  0,141, 61,216,  3, 96, 86,204, 63, 44,139,175,165,
 53,  2, 65,130,113,244, 27,120, 13, 79, 24, 37,207,244,239,228, 35,154, 49,198,
145,125, 88, 25, 30,188, 97, 63,121, 69, 50,229,190,  2,159,215,247, 44,205,191,
121, 89,125, 17,175, 92,152,195,219,255,135, 76,171,239,109,121, 33, 10,180,173,
 67,198,233, 90,172, 81,204,219,132,152,159, 62,191, 77,255,107,219, 73,162,195,
188,242,167,175,214, 19,148, 36,175, 59,176, 63,255, 58,254, 61,183, 25, 22,133,
135,230,240,154,131,181, 92,189,136,249,104,115,189,186,125,105,212,150,118,215,
 23,156,119,160,190, 37, 54,204,114, 60,218,161,232,243,185,181,142,217, 14,213,
 77,208,  6,191, 20,192,166, 55,176, 87,240,106, 81, 17,245,211, 54, 12,226, 39,
 39,248,  4,236, 29,120,146,110,112, 24, 31,102, 16,174,183, 61,232, 15,199,115,
203,  8,129,129,232,159,170,160,197, 73,124,178, 97, 15,140,101,163,152,168, 27,
 84,217,244,166,161,130, 32, 27,194,133,121,133,247,147,238,188, 58,252,106, 83,
135, 17, 46,  8,167,232,176,172, 60,132, 22,116,233,104,123,204,121,165,231,233,
154,123,114,130, 46, 32, 87,255,230,116,216, 30,218, 69,116,  5, 82, 64, 98, 75,
231,115, 81,176, 52, 37,224, 68,151,  1,224,212,202,247, 20, 11, 38,  5,103,179,
 56,220, 16, 47, 77,211,194, 38,138, 71, 44,188, 80, 52,102,226,124,255, 72,130,
213,219,105, 23, 48,125,208,  9,195, 74,122,193,104,196, 20,143,237,  6,180,200,
146,194, 62, 19,113,122,252,153,241, 32, 53,163,108,134,184,145,164,188,147, 42,
 37, 98,148,140, 20,253, 47,229,117, 53, 98,186,230, 42,  7,110, 87,210,122,222,
 62,139, 49,123, 38,235, 62,142, 83, 83, 83,190,  3,162,124,103, 66,159,113, 58,
176,254,129, 66, 25, 55,231,204,189,170,156, 98, 95,108, 14,183, 15,244, 45, 32,
116,104,135, 65, 90,152, 84, 75, 21, 65, 81,109,111, 41, 42,196,182, 41,247,122,
 45,221,234, 12,234,246,194,232, 40, 69,118, 47,119,252,231,208,251,213, 58, 89,
161, 86,185,133,116,  0, 17,136,115, 87,164, 97, 81,181,150,174, 72, 88, 57,149,
  6,175, 44,122,167,198, 24, 28,149,125,193,  4, 16, 26,112, 77,116, 73,248,206,
115,104,146,218, 44,198, 81,247,127, 24, 39,202,143, 61, 16, 16,149,113, 25,216,
185,157,154,150,121, 83,207,  8, 87,247,180, 43, 34,224, 53,118,105,205,131,237,
 62,155,138,204,178,220, 21,134, 18,192, 90,132,198,143,164,  7,152,105,184,141,
175,232, 45,150,214, 78,199,100,  0,244,217,196,164,230,226,109, 88, 67, 43, 24,
194,187,197,245,200, 29,115, 30,134,154,234,134, 73, 82, 41,243,189, 26, 19,230,
 62,218, 92, 58,123,  9,168, 11, 66,197,208, 46,188,100,  6, 51, 48, 84,221,203,
120,158, 92,152,114,134,169,  9,238,148,156,106, 25, 94,115, 91,172, 60, 19, 57,
223, 56, 19,165,129,223,  0, 93,205, 43, 48,168,227, 89, 27,145,198, 79,164, 59,
136,227,201, 21, 99, 18,144, 26,241, 77, 73,160, 74,114,221,130, 56,204, 12, 40,
140,228,149, 39,255, 19,211,109,171, 55,  7,  3,245, 19,199,  9, 29,255, 84,213,
233, 81,239, 92,137,153, 30,  0,201,156,185,102,183,154,  4, 69,242,112, 41, 55,
 96,175, 42,203,191, 72, 40, 52, 81,182, 36, 60,133, 21,183,192,235,108,173, 44,
149,123,241,123,125,247,125,226,175,176,109,114,  1,103,110,238,138,155,  8,101,
218,187,130,  3,156,226,164, 14,  3,221,193, 65, 27, 26, 79,169, 99,195,186,175,
 64,160,166, 39,246, 44,175, 89,150,112,247,210,136,118,204,101,  0,  1, 97,154,
102, 41, 49, 32, 37,249,158, 68,160,136,174,147,  4, 90,222,182, 95, 69, 58,241,
 13, 60, 20, 34,227, 16, 66,192,129,184, 65, 62,245, 51,152, 43,163,203,  2, 23,
158,141,157, 83,138, 68,230, 13,137, 73,155,  9,150,157,120,231, 78, 17, 90, 27,
219, 98,104,136,  1,137, 54, 21, 36,231, 29, 26,118,126,  4,  0, 37, 27, 33,  6,
218,201, 93, 76,186,156, 38, 46,168,229, 93, 90, 34, 40, 99,217,231, 40,113, 33,
143,178,242,238, 35,249, 87,123,143,105, 91, 90, 87,200,140,110,101,218, 66,191,
248,104,165,189,142,235,249,180,105,156,178,190,132,158,171,217, 61, 70,141,173,
117, 59,249,218, 55,177,217,109,103,142, 86,167,249, 96,252,181, 13, 12, 17, 91,
 83,137,230, 15,156,142, 71,207,129,229, 90,168,126, 96, 91,224,163,124, 54,178,
 28,221,236,169,206,245, 26,228, 37, 23,248,194,137,115,  6, 63, 54,196,194, 82,
151,188,101, 96, 76, 33,178,216,246,172,180,191,203, 98, 82,178, 90, 11, 57,227,
137,174,108,206,153, 27,203,135,204,135,242,120, 32,101,204, 33,149,  7,158,101,
135,176,144, 25,224,164, 76,202,156,211,111,183,133,218,250,128,127,121,140,130,
143,145,186,105,  1, 61, 20, 87,217,157,134,229,193,106,146, 99, 25,171,176,239,
183,182,167, 19, 16,167,222,125,111,187,181,128,141,  2,200,166,166, 55,134, 46,
164, 37,193, 79, 57,193, 68, 50, 38,225, 76,236,230,165, 96,154,  0,207, 42, 48,
164, 49,  1, 46,183, 59, 18,208,143,108,194, 35, 90, 96, 57,119, 22,237, 35,100,
229,233,190,124,117,170,104,130,234, 87,185, 43,244,243,111, 91, 26,121,145,132,
 69,141,101, 96, 49, 96,165,117,189,187,173,101, 15, 19,139,110,178,141, 32,151,
154,172,159,140,135, 50,174,253, 66,252, 95,126,205,253,249,115,198, 66,207, 30,
 30,145, 98,221,145,128,136, 91,215, 33, 23, 66,221, 68,180,236, 68, 14,239, 95,
180, 65, 98, 15,175,115,175,115,190, 70,241, 91,242, 34,109, 13,128, 78,105,131,
118,176,140,248,211,179, 61, 51,212,119,210,  3,125,144,153,135, 49,102,103,218,
 13, 58, 52,  3, 90,240,202,113, 63,152,131,111, 12,203,231, 18,124,220,237, 21,
120,117,176,243,106,127, 13,225,173, 53,248, 68,196,180,171,141, 58, 83, 51, 92,
166,202,196, 36, 99,202,251,255,210, 91,145,152,163, 72, 71,194,211,120,  2,126,
180,142, 61,168,216,170,241,177,  8,  5,121, 81, 25, 79,241, 75,122, 40,117, 50,
 99,162,  8,121,  7,215,134,125, 16, 66,146,124, 51, 56,222, 56,169,195,245,208,
206, 71, 13, 40,197, 76, 62, 36,135,133, 21,  9, 65,210,127, 22,135,157, 82,125,
234,210,200,225,216,237, 49, 20,235,180,207,175,169,143, 67,105,216,206,123,240,
 11, 37,167,130,247,251,249,208, 76, 96, 24,197, 46, 78, 33,128, 75,198, 48, 49,
206,223,169, 74, 75, 47,117, 94,216, 80,  4, 47, 70,169, 22, 94, 67,195, 54, 95,
179,158, 53,  5,241, 32,248, 84,183,138, 68, 92,  2,249,197,101, 78,189,133,116,
 53,229, 50,237,175,169,212,148, 58,151, 15, 98, 58, 83, 39, 73,222,110,  2,145,
212, 90, 20,254,191,121,199,127,140, 51, 41, 55,  5, 36, 24, 77, 82, 53, 81, 81,
105,191, 12, 59, 20,188, 89,192,120,254,156,179, 53,177, 77,  1, 76,228,220,112,
229,151,128,244,251,168, 14,119,213,157, 35, 31,196,183, 63,141,237, 90,119,244,
222,106,140, 57,211,194,159, 89,143,152,  8, 22,167,205,248,106,213,214, 75, 75,
189, 70,189,209, 74,110, 50, 71,195,127, 11, 94,153,104,116,149, 23,164, 82,224,
162,140,194,136,168,190, 30,120,209,158, 43, 60, 54, 98,126,  1, 76,231, 51,192,
 70,177,106,182,203, 24, 20,195,219,172,173, 40,195,183,238,157,184,252, 74, 96,
219,129,202,185,115,231,185,117,167,131,244,146,122,133,155, 39,142,227, 48,241,
239,147,115,149, 77,124, 95, 59,  4,218,115, 60,100,173, 92,177,141,167,223,188,
 46, 93,179, 67, 37,  6, 52, 94,244, 20,102, 38, 95,112, 34,159,247,193,181,131,
161, 43,170,102, 23,170,150,141, 78,135,155, 95, 32, 78,130, 67, 59, 23,100,240,
207,161,207,140, 86,  2,116,195, 51,251, 13,248,249,212,226, 41,167, 87, 38, 93,
213, 75,136,  1,232, 96,  7,208,245,243,186,142, 61,103, 70,119, 97,121,185,209,
254,187, 87,100,169,220,197, 98,253,250, 24,166,120, 73, 92,208,219,151,199, 12,
140,120,108,115,  2,113, 28,219,127, 66, 53, 75,150,234, 35,106,175,195, 54,185,
 62,145,214,129,111, 96,236,148,249,130,246, 14,185,  3, 84,120,  4,218,131,217,
206,226,195,102,165,159, 18, 72,110, 52,234,171,216,168,215,139,129,194, 71,217,
156, 79, 14, 65,197, 95,146, 20, 66,  0,169, 77, 92,154,214, 48,105, 31,177, 93,
 88, 83, 73, 18,231,129,163, 70,237, 78, 45,117,175,193, 61,144, 23, 37,132,114,
224, 24,178,165,202,  6,205,248,192,141,183,156, 28,223,147,236,118, 60,185,126,
130, 68,207,249,109,  5,236, 83, 30, 92,147, 87,112, 31,208,129,142, 99,162,255,
 16,  9,141,155, 97, 59,196,137,189, 70,198, 84,192,127, 19,187, 51, 79,208, 25,
 38, 17,238,155,136,119,182,246, 99,240, 54,135,218, 61,114, 43,208, 48,191, 48,
151,176,127, 12,215,160,  2,205,  7, 69, 87,124,120,190, 61,154,170,116, 77,202,
146,  0,  8,116, 37,148, 32,172,147, 32,216, 45, 57,114,141,146,112,165,135,134,
210,125, 91, 47,135, 16,174, 11,107, 46, 65,184,165,232, 26,208,117,159,163,120,
104,247, 17,143,254,145, 80, 38,177,210, 49,188,237, 98, 90, 26,103,115, 22,195,
138,240,103, 57,224, 45,136,124, 46, 64, 49, 12,189,144,103, 10,117,204, 48,183,
 58,118,116, 47,136,  8,171, 71,226,118,230,180, 19, 65, 87,242,131,246, 76,211,
103,225, 37,255,183, 54,159,207,203,137,130,190, 86, 67,145,188,240,  6,176,149,
147,224,116,115, 83, 66,115,208,239,181,250, 92,112,136, 72, 40,140,167,170, 76,
 63,131,138, 27, 60,209,130, 24,217, 29,  0,154,215,146,235,253, 81,237,254,207,
  3, 43,  8,224,223, 16, 55, 48, 53,  3, 55, 44,115, 51, 66, 89,170,175,233,243,
 60,182,183,180,124, 45,184,128,129,121, 78, 69,155, 45, 86,237, 42,162,179, 16,
 11, 47,  9, 42, 87, 32, 65, 29, 62,224,245, 88,138,210,157, 51,116,240,139,109,
193, 33,150,186, 27, 74,  4, 24, 32, 18,251,116,212, 18,212, 77, 88,139, 28,103,
 14, 53,154,109,132,215,120,107,198,185, 40,234,108, 77,148,155,102, 26,133,104,
245, 59,212,160, 65,206,171,  5, 59,126,130, 40,125,217,234,216,  5, 45,129, 93,
148, 30, 29,139,228,121,235,225, 77,226,126,204,118,162, 94,161, 47,237,204, 49,
228,189,252, 92,206, 68,181, 69,228,195,155,148, 73, 54, 92, 73,235,227,192,  0,
228, 75, 20,178,162,238,230,233, 19,207,233,170,  8, 88, 90,233, 64,120,224,213,
 53, 94, 93, 17,125,198,  2,168, 20,  1, 97,155, 21,233,186, 68, 34,237,183,152,
 91,148,192,208, 43, 30,200, 27,165, 97,238,186,211,120,125,159, 55,243, 63, 40,
111,110,175,221,170,  6, 47,123,  7,141, 18,  1, 67,120,  3,178, 86,176, 66,201,
177,116,126, 98, 46,108,191,170,234, 76, 43,186,225,105, 34,145,248,246,238,  4,
 52, 27, 84, 25,155, 13,194,216, 56,130,162,130,134,121,226,227, 56, 82,148, 32,
  2,172,184,238,121, 99,151, 29, 83, 84,141,150,214, 88,172,181, 43,176, 39, 41,
177,250,210,218, 59,158, 37,215,131,165,136,107,155, 51,125, 13,143,  1,169, 16,
215,254,251, 28, 73,105, 85,173,162, 30, 75,109, 66,122,151, 90,153,226, 80, 61,
132,  5,  9,117,239,170, 55, 77, 25,238, 78,159,195, 70,132,204,186,116,104,213,
173, 79, 30, 43,236,112, 19, 52, 11,164,131,125,120, 92,199,149,147,173,202,131,
 65, 53,196, 60,226,152, 32,  5, 94,190,243, 37, 49,  4,158, 71,232,156,162,183,
124,235, 71,118,172,236, 62,  2,189,190,230, 73,245,139,164, 84,179,131,177,205,
 74,166,186,114,189, 97,202,209, 63, 92,124, 51,183, 88,181, 14,158,242,228,206,
102,107, 89,163,234,187,243, 38,210, 29, 60,188,  9,116,197,206, 32,190, 49, 94,
236,  4,  9,228,  3,  2,142, 73,251,238,195,126, 81, 28,194,208,225, 70,164,190,
 71,149, 68,148, 87,138, 43,108, 54, 17, 19,121,214,  4,  6, 97, 76,112,129,223,
209,224, 93,170,163,253, 74,154,104, 60, 45, 24,242,121,194,227,251, 70, 21, 13,
122, 39, 67,166,105,194,124, 12, 58,205, 89,150,188,  0, 19, 58,172,146,217,211,
 82,145, 46,  5,242, 40, 24, 30, 64, 72,155, 64,235, 44, 29,164,194, 71,116,156,
 90, 75,126, 99, 30,178, 64,146,216, 71, 48,240,148,202, 83,241, 70,226,  2, 57,
150,175,  8, 98, 79,100,171, 40,240,150, 71, 32, 43, 82,110,194,248, 11,253, 74,
221, 81,123, 64,243,  5,100, 26,102,130, 45, 78,218,147,102, 90, 83,122, 42, 18,
160,117,216,253,241,121, 52,163,153,134,110,212,193,100,203, 97,149,102,250, 87,
203, 82, 59,197,123, 10, 64,195,168, 67, 43, 13, 40,240,236,186,129,145,175,237,
 96,152,208,187,186,236, 70,242, 90,201,167,212,169,202,111, 35,166,230,143,166,
 86,132, 29, 44,106,237,110,236,188,248,  8, 75, 28,213,186,118,167,116, 49, 62,
211,131, 75,200, 43,125,158,212, 67,143,142, 48, 94, 89, 37, 23,156,223,196, 57,
 94,166,137, 22, 31,195, 74,187,107,255,184,244,223,141,165,199,197,145, 20, 52,
 51, 76,109,255, 20, 40, 64,152,122,161, 46,115,192,212, 66, 20,  4, 12,141, 82,
 23,123,255,240,245, 91, 66, 17,115,109,189, 29, 48,158,168, 86, 44,174,132,163,
211,  6,241, 88,238, 17,237,224,130,118, 93,123,105,123, 31, 17,105,247, 20,212,
129,195,105,146,127, 45,173,246,222, 82,161,137,249, 77,187,180,255,254, 61,144,
131,136,219, 78, 72,216, 27,134, 54, 52,189, 36,190,114,143, 52,231,102, 63, 15,
 91,196,129,104,  0, 41, 28, 25, 14, 36,229,186,227, 17,110, 87,191,103, 57,  2,
  6, 73, 34,134, 55,114, 97, 95,231, 49, 75,156,136,115,185,  4, 63, 38, 62,102,
 41,208,130,101,237,207,190,217,158,193, 47, 99,231,172, 43, 93,125,196,177,120,
 93,217, 87,203, 36,222,250,222,222, 28,201, 93, 72,240, 81,244,115, 40, 12,205,
216,180,202,224, 40, 71,229,245,216,235,101,225,215,209,166, 58,119,126, 82, 17,
149, 71,222, 85, 51,127,121, 31,255, 17,114, 26, 20,219,249,198,129, 42,161, 47,
 47, 36,251,217,174,136,245, 97,  2, 74,  2, 77,159,161,151,242,185, 31, 16, 72,
130,  0, 98,201,255, 30,127, 16,182, 79,167, 11, 42,169,155, 27, 15, 21, 83, 23,
103,  8,218, 36,  8,243, 91, 74,245,  3, 58, 89, 21,132,125, 99,246,176,150,197,
186, 11,  8,195,196,120,169,206,118,168,162, 53,133, 61, 76,130, 19,188, 39, 77,
 90,  2,227, 24, 57,171,153,169,196, 44,136,229, 23,223, 53, 43, 36,150,223,228,
131, 92,218,248,198,152, 16, 69, 19, 22,254, 21, 73, 21,119,103, 38,  8, 74,186,
158,255,255,217,151,194, 90, 18,241, 37, 96,107,200, 60,171,141, 73, 30,144,141,
236, 51, 29,218, 76,211,242,239,235, 23,139, 62, 64, 95,166,245,219, 87,162, 93,
157,120,  1,245,248, 75, 66, 96,  1,162, 58,167,168,251,104,126, 19, 59,122,190,
105,160,178, 75,239,152,223, 97,250,186,196, 48,114, 82, 12, 57,230, 51,  9, 86,
238,201,247,220,  7, 50,233,205,210, 53, 44,222, 87, 18, 93,218, 49,172, 74,104,
 74,161,249,243,250,154, 89,226,145, 74,233, 68,236,193,243,115,243,  1, 94, 28,
240, 27,154,183,231,183,198,203,107,118,103, 54,203, 29, 22,194,102,  9,144, 49,
174,153, 45,139, 67, 84, 12, 22,179,255, 39, 63,184, 71,142,155,100,  8, 75,177,
220,232,101, 63, 54, 25,116, 40,178,191,171,238,242,120, 26,176,139,238,233,  3,
 13,148,113,220,215,126, 67,114,232,143,164,107,150,145, 91,123, 49, 36,117,216,
216,183,101,147,254,175,192,  2, 37,100,210, 94,226,186,187,229, 55,196,249,253,
236,  3, 91,  1, 18,139, 22,116,181,221,190,252,194,137, 32, 95,115,203,  3,173,
147,253,  7,208,216,159, 56, 22,176,105,  5, 46,220, 52,126,239, 98, 37, 33, 90,
225,173,189,188, 59, 23,194, 90,118, 88,224,118,206,238,  5,248,  8, 39,112,226,
 31, 89,113,174,157,246, 50, 52, 23,  8,159,127,126,179, 99, 48,249,  1,221,213,
 15,127,127,100,135, 34,138, 13, 35,174, 43,112,181, 11,111, 35, 83,  1,213,208,
 44,211,155, 70,149,132,157, 16,137,230, 58, 66, 86,  1,  3,127, 80,147,196, 67,
 64,224,170, 81,208,239, 86,209,244,179, 91,246,197,189,174, 32,251, 45,234, 98,
133, 63,227, 48,125,198, 71,  1,128, 97,142,  0,233,131, 51, 45,215, 71,192,127,
 94,169,147, 71,226,255,211, 54,  8,204,251,135, 14,159,193, 79,216, 65,187, 11,
 64, 44, 61,187,154, 18,207,100, 78,182, 29, 48,133,168,132, 63,172,115,157,204,
169, 24,  5,196,196,194, 90, 46,169,197, 98, 38, 75, 33,244,145, 13,150,186,188,
 26,195,127,106, 10,109, 99,113,139,202,107, 78,224,202,166, 27,228,204,124, 98,
 71,170,179,120, 48,122,202,141,217, 35,198,127,195, 39,192, 84,174, 95,139,217,
110,123,173,  9,253,128,115,133,249, 72,111,176,111, 13,186, 76,205, 62,130, 23,
157, 93,159,178,  6, 92,241,211, 95,198,116,218,204,129,213,158,119,206,106,170,
160,157,217, 18,236,201, 16, 83,204,117, 16,148, 22,221,142,195,232,109,236, 73,
243,138, 30,130,156,148,254,209, 64,168, 16, 97,104, 37, 89,207, 93,217, 29,221,
244,238,200,159,176, 59,165,165, 18,247,167, 40,241,118, 33, 25,136,226, 53,200,
 99,151,230, 39,159, 92,189,155,201,110,160, 19,169, 49,211, 40,212,114,119,252,
248,148, 51,183, 78,125,255,182,209,234,161,110,208, 83,192,207,221,204, 14,200,
 56, 76,122,133, 37,246, 28, 17,179, 26, 57,108, 46,158,229, 95,149,204,204,198,
231,253,100,130, 45,  6, 70,193,221,251,253, 42, 15,213,209, 84,212,188,211,  5,
 31, 79,  2, 61, 14, 50,201, 67, 53, 77, 84,231,138,149,150, 86, 66,143, 96,250,
 52, 21,184,  9, 36,100,205,196,112,168, 84,133,200,184,201,208,242, 47, 74, 71,
147, 92,179,182,137, 39,174, 40, 49, 22,154,163,149, 34,147,235,244, 52, 16, 52,
 12,228,172,245, 99,154,189, 47, 48, 79,124, 57,108,123,208, 43,170,183,243,131,
175,195,246,234,117, 90,211, 83,155,139, 32, 72, 60,238, 62,131, 37, 14,112,208,
  4, 60,250, 63, 63,142,213, 21, 36,157,  4,118, 19,101,149,192,217,219,124, 37,
105, 52,203,208, 52,  5,134,216,  4, 17, 46, 51,237,199,139,119,138,170, 50, 62,
 44, 24,243,231, 38,217, 46,249, 49,188,169,100, 78,149,176, 73,247,182,130, 62,
 90,151,225,116,250,175,137,225,129, 67,115, 75, 94,168, 81,129,119,233,187,129,
167, 66, 48,178, 14, 13,249,124,195, 94,194,174,151,  8,232, 16, 73, 18, 13, 36,
 27, 40, 73,123, 61,116, 10,140, 79, 63, 38,158, 48,  0, 58, 89, 53, 13,139,173,
231, 92, 91, 46, 46,236,171,146, 13,154,127, 73,226,181,170, 84,179, 53,240,177,
227, 23,255,  4,  8,185,170,105,209,216,  3,121,156,178,107,188,244,  7, 81,239,
 90,115,230,239,163,129,176, 48,214,247, 49,222,141, 25,170, 11,120, 44, 13,193,
  3, 75,217,228, 14,219, 26,236,  7, 20,119,178,138,241,128, 30, 68,110, 33,252,
248,102,163,247,196,156, 23, 95,255,117,173,237,  2, 30,127,182,238, 16, 71,110,
191,207,148, 82,119, 76, 14,188,240,255, 14,206,162, 28,115,214,240, 88, 84,238,
201, 13,216,222,152,124,159,135,105,142, 11, 89, 30,137,110, 67,115,196, 26,222,
 48,144,188,178, 28,171,203,242,  3, 13,165,203,105, 78,160,161, 37,126,224, 63,
230,101,149, 41, 53,219, 40, 35, 80, 99, 40, 74,155,123,101,225,208,157, 94,111,
 79,246,231, 65,184,185, 76,136,  3, 22,174, 76, 48,228,252, 74,121,162, 46, 61,
167,153,105, 99,146,142, 69, 84, 52,150,102,147, 91, 25,234,141,136, 55, 40,215,
203,139,160,237,119,214,187,133,234, 49,223,105,  9,255, 31, 10,245, 67, 26, 72,
183, 19, 18,135, 90,197,  9,104, 94, 14,251,104,208,179,207,228,250, 81,223, 73,
 26, 39, 89, 49, 52, 91, 32,118,176,129, 37, 88,211,144, 15, 88, 25,178, 64, 15,
191, 41,250, 51, 85, 66, 48, 71,204,107,118,139,249, 51, 76,187,244,202,104, 15,
210, 80,236,111,151, 42,235, 91,248, 37,188,148, 65,232,139, 23,170,195,153,176,
253, 62,232, 98,148,220, 34,140,124,110, 44, 68, 86,100, 23,189, 12,128,191,231,
 85,160,121, 11,243, 26, 89, 87,140,142,162, 41, 61, 64, 68, 71, 62, 41,203, 56,
200,140,123,164, 77, 12, 78,159,229,  5, 60,153, 75,149, 68, 30, 99, 55,163, 18,
106, 82, 92, 89, 73, 59,150,203, 59, 58,139, 89,140, 99,176,153,248, 85,186,218,
 82,130, 41, 26,187,105, 66,213,253,134, 21,207, 31,198,152,153,182,203,121,228,
 79,  9, 53,103, 74,166,110,129, 69,142,183,134, 56,213, 84,216,172,132,116,145,
185,130, 32, 28, 89, 14,109,233, 64,  5, 14,161, 18,206,247, 61,  2,  3, 88,205,
113, 84,125,216,160,232,200, 89, 82, 21,149, 24, 91,255,186,233, 18,172,139,218,
237, 87, 92,197, 11,192,213,214,109, 91,133, 75, 33,174,204,239, 85,170,109,217,
 31, 94,126, 98,140,233,162,180,222, 81,205, 58,123, 90,129,150,201,228,221,133,
  4,131,112,227,243,155,138,248, 36,213,213, 83,197, 97,138,102,161,150,169,165,
152,106,250, 20,106,  9, 75, 42, 60,214, 16,173, 23,233,196,172,137,  1, 18,187,
 24,175,218,204,163, 99, 57,131,174,182,105,153,204,121,191, 35,169,134,  5,129,
 17, 85,189, 65,220, 86, 70, 15, 27, 18,131,134, 32, 31, 74, 77, 90, 60,  9, 22,
251,  8,247,159,202, 29,112,222,232,230,160,131, 38, 71,  7, 84, 57,101,251, 84,
230,194,154,184, 86, 24, 27,180, 22,235,201,251,131,191,108, 23,195,199, 90,174,
 36,202,212,227,141,136,200,138, 19, 10,  6, 65,139,195,115,157,149,129, 47,241,
 32,233,238, 21,100,  4,207,255,194,169, 67,129, 21, 65,136, 94, 90,174, 75, 71,
122, 18, 26,235,184, 46, 45, 82, 46, 92,151,113,139,207,190,110,211,217,248, 70,
186,160, 46, 60,202, 71,185,248, 41,169,248,162,201,191, 41, 65, 65,154,134,223,
253,183,189,166,242,126, 19,205, 93, 82,125, 16,220,231, 62,  9, 65,244,115, 40,
192,230, 25,254, 38,251, 62, 79, 49,109, 28,227,241,162,184,145,146,  1,143,173,
 26,249, 52,133, 35,  1,159, 36,164,  0, 36, 25,  5,171,156, 76, 29,232,204,157,
 62,173,150, 32,  5, 15,212,232, 43, 41, 66,121,213, 85,176, 75,228, 49,241, 65,
 12,196, 66,109,152, 78, 84, 99,228, 84,187,124,138, 11, 20, 69,  8, 57,  1,210,
 69,198,238,112,192,218,188,151,172,131,120, 63,158, 15,247, 74,  9, 19,224,123,
  0,161,135,132, 16,251,196,180,157,237, 33,212, 39,167,119,157,  2, 88,100,112,
 13,141,173,214, 97, 92, 46,212, 87,184,165,145, 77,  2,255,251,103,228,181,214,
 76,206,224, 43,169, 18, 51,112,101,164,184, 52, 45, 50, 61,126, 21,218,163, 17,
 96, 72,253,149,124, 14,199,239,247, 92,168, 49, 16,219,162,125, 69, 49,231, 66,
236, 78, 54,185,131,144,163,100,201,207,228,  0, 71,229,  0, 33, 69,198, 13,130,
166,239, 86,253, 35,100, 49, 88, 88,107, 65, 24, 61,230, 79, 75, 97, 88,160,122,
110,159, 54,153, 71, 29,102, 57,144,227,138,100,228,106, 24,125,229, 88,191, 37,
160,200,201,216,168,141,228,252,146,100,112,255,152,253, 73,105,142,206,206,  1,
 98,178, 27,171, 63, 76, 69,194,134, 56,145,224, 66,242, 28,134, 40, 34,168,117,
179,207,132, 52,114,250, 53, 69,205,157,165, 36,217,172, 50,252,194,155,150, 37,
191,112,150,241, 97, 94,  2, 30,100,164, 81,112,208, 58,146, 57,220, 63, 24,182,
236, 84,143,116,120, 96, 26,159,202,185, 54, 67,153,146,171,245, 29,112,178,232,
233, 32,  1, 92,173, 19, 49,202,140,214,153,138,237, 54,235, 80,118, 57,201,187,
143, 31,250, 96, 37,188, 76,235,143, 86,121,212,211,158, 77,254, 36, 31,128,200,
162, 11,141,245, 33,230,192, 69,168, 17, 79,236, 51,178,214, 86,182,141,252,237,
127,216,101, 82, 23,109,127,170, 17, 17, 64, 84,220,113,182,103,156,242, 17, 94,
185,253,239,229, 27, 22,161, 50,182,237,253, 39,146, 20,184,238,224,108,235, 73,
226,  1,170,242,174, 14, 32, 38, 92,  3,169,237, 64, 26,231,193, 89, 86, 33, 25,
119,164,124,231,207, 82,  3, 91,136, 14, 76, 63,214,128, 16,237, 75, 67, 80,123,
 64, 91,236, 78,158, 78,200, 78, 61,251, 87,116,226, 36, 15,  9, 76,231, 63, 81,
  5, 48, 76,128, 22,124, 45, 14, 24,254, 96,168,211,129,248,192,149, 34,226, 49,
255,185,139, 98,147, 96,119,203,123,243,191,129,124,246, 30, 28, 75,241,188,172,
111,201, 66,176, 97, 45, 82,120,217, 18,144, 54, 51,251, 71, 39,197, 52,159,118,
 27,143,234,116,185,  6,249, 62,116,127,147, 23, 68, 67, 91, 16, 87, 72,  5,215,
204, 73,146,151,248, 76, 91, 10,107,148, 78,111,147, 56, 47,142,177,175,  3, 89,
 95, 29,218,186,176,  7,184,160,  2,179,125,217,152,250,248, 60,131,222,111,195,
 29, 54,190,224, 12, 77, 33,104,148,131, 41,235, 53,240, 75, 56, 44,156, 35,132,
138,175,192, 74,179,237, 20, 71, 97,106,159,224,131, 58, 92,218,206,199, 54, 44,
155, 60,120, 81,235,134,238,  9,220,248, 70,103, 95, 57,145,229,202, 32,161, 33,
 83,198,150, 10,200,  4, 14,142,118,147,208, 22,122,119, 88,230, 32,134,106, 73,
 81,202, 34,209,247, 41,253,156,190, 45,220,227, 24,147, 74, 99,105,  1,107,  0,
 28,165, 55,  6,106, 10, 19, 57, 89,124,148,133,115,237, 38, 18,233,127,208, 92,
189,192, 42,  3,228, 48, 88, 35,199,196, 10, 66,231,  6, 91,209,114, 92,130,163,
147,  8,227,249, 78,136,216,171,155,133, 29, 55,255,145,220,243, 32, 17,158, 85,
 42, 51, 98,246, 67, 61,255,213, 63,214,117, 89,167, 37, 73,112,121, 41,196,159,
111,192,195, 93,224, 15,103, 64,117, 92, 87,175, 28,112, 51,242,103,218,204,137,
 25,165,204,210,177,147, 16,200,229, 71,161, 14,182,  4,135,146,242,169,154,  1,
 56, 58, 93,212,196,107, 72,165,237, 40,249,194, 10,198,140, 61,138,205, 33, 11,
 91, 83,173,231,138, 19,209, 76,207,  9,  0, 25, 77,  7, 47, 36,124, 48,115,152,
150, 21,249, 69,174, 15,208,159, 64, 82,  0,133,210,  2,135, 73, 32,164,137, 94,
 52,162,192,166,101,217, 31,118,244,193, 51, 37, 15, 39,147, 83, 30, 30, 66, 84,
 18,146, 43,205,245,157, 76,151, 94,165,230,137, 68,  1,108,216, 70, 85, 40, 92,
197, 46, 53,233,233,169, 73,114,236,253,239,225, 97,151,113,166,228,245,  0,189,
 35, 14,251,169, 57,  2,234,  9, 95,136,126,144,221, 49,211,207, 83,166,202,145,
 76, 68,  0, 23,252, 98,143,145, 21,178, 12,116, 65,170, 12,150,217,  1,183,110,
184,224, 48,178,193,188,188,177,159, 99,159, 36,  2,245, 54, 80,160,151, 46,126,
184,171,239,179,237,145, 24,  3,130,164, 20, 36,209,173, 14,113,140,141,  8, 90,
153,113, 26,137, 32,214, 93, 69,192,150, 89,206,207, 58,  1,131,209, 28, 39,165,
163,155, 65,179, 24,225,247,229,180, 96, 86,102,204, 61, 25,164, 59,244,126,205,
248,230,144,181,  0, 35,137,228,145, 86,202,221,151, 99, 54, 30,137,165, 94,242,
136,153,154, 70,208, 30, 37, 26,165, 64,240,102,152, 61, 65, 39, 90,241,161, 77,
151, 33,138,248,216,131, 65,102,132,143, 31, 29,248, 63, 22, 66,171, 85, 63,207,
 53,158,202, 31,243,149,254,244,115, 57,151,170,104,173,111,104, 18,134,115,254,
 43, 37, 35,181, 29,214,208,160,232,191,  2,184, 90,  3, 12,105,255, 70,175,175,
239, 51,192,237, 72,185,255,131,103,253,244,196, 70, 77, 13,237,159, 53,108,230,
107,118,139,237,114,135,171,174, 98, 54, 64,235, 53,124,221,105,141,197,113,231,
115,245,237, 57,140,199, 76,107,  7, 25,150, 77,145,  2,146, 86,  5,150, 79, 54,
167,165,151,139, 87,219,227,215,128,251, 58,  8,220,151,208,140,167,168,231, 51,
 10, 22,100,133, 26,173, 36,156,  0,206, 69,147,202, 77,226, 28, 93, 94,133,137,
 43,234,236,179, 84,190, 10, 25,203, 42,166,216,180,226, 83, 62,233, 95, 36,241,
180,121,253,  7, 55, 61,145,111,105,163, 82,103,  7,126,180,247, 44, 96,129,134,
 35, 96, 31,155,198, 26,128,134,102,179,226, 57,233, 51,150, 60, 22,  5, 55,217,
150,117,236,250, 59, 52, 24,163,207, 34,122,101,144,163,206, 96, 12,174,201, 91,
 40,125,152,216, 43,132,  4,151,212,236,132,119,156,103,160,213,225,101, 84, 97,
158,246, 38,228, 55,227,162,116,245, 84, 15,233,251,126, 94, 13, 92,196, 71,128,
175,217,188, 21,187,199, 30, 71,  5, 68,149, 51,207,206,201,129, 75,147, 91,106,
144, 22, 61,186,169, 13,123, 38,226,116,252,225, 33,253,115,192,123,232, 84, 45,
145, 26, 25,244,  3,142, 36, 26, 94,216,228,199, 68, 34, 86,147, 26,195,250, 38,
179,171, 28,186, 45, 13,123, 56,216, 30,164,152, 67,243,111,223,210, 69,131, 28,
176, 96,144,236,255, 88,109,119,103,240, 82, 33, 72,164,197,177,120,198, 14, 28,
 90, 61,212, 33,133,155,  2,151,  0,213, 24, 93,  7,239,180, 33,183,167, 49,185,
 36,237,226,219, 56,174, 21, 81,232,193,112, 47,216, 93,153,121, 63, 67, 87,160,
145,191, 55,165,218,166, 95,196,  7,159, 44,192, 48, 42,147, 18,201, 54, 88,182,
251, 50,135,214,212, 43, 61,138,222,140,163,  6,198,148,153,  4, 65,220,145,145,
 96,126,131, 92,213, 75,238, 17, 35, 22,236,216,237,  2,208, 27,133, 41,187,170,
  2,  3,125,  5,140,145, 62,113,252, 77,104,138, 71, 20, 74,204, 47,180, 49, 50,
 90, 10, 95, 76, 97,243, 53, 56, 91,164,212, 45,195,145,115,  4,110,142,131,168,
 48, 58,185, 26, 21, 46, 14, 29,218,241, 97, 47,  4,203, 66,101,178,151,237,240,
221,147, 82,183,162, 34,102,229,171, 64,172,185,128,155, 72,  2, 11,207, 52, 68,
244,121, 21, 96, 18,163,251,  6, 81,202,251,110,191, 83,112,119,226,193,200, 54,
 44,195, 63,113,248, 35, 74, 96,209, 97,119,227,147, 12,122,164, 91,121,148,200,
 97,219,192,199, 37,201,188, 32, 51,146,207,146, 51, 49,135,235,184,177,243,248,
147,  9,149,204, 90, 32, 69,252, 70,247, 27, 51, 18, 76,125,213, 81, 66, 57,171,
146, 46,220,104,222,239,222, 14, 97, 61, 70,251,  1,255, 51, 98,130,209, 85,223,
190,153,183, 85,125, 22,155,142,113,230, 34,170,230, 67,139,135,105, 53,168, 29,
 97,247, 93, 61, 38, 42,106,102,171,206, 35, 73,162, 72,121,171, 65,247, 26, 62,
200, 58, 90,222,241, 49,124,148, 82, 75,126,240, 16, 43, 46,228,116, 90, 28,238,
124, 24,212,  2,121, 56, 41,239,241,130, 83, 81, 93,247,186,128, 24, 15, 82,137,
182, 96, 76, 45, 40,199,178, 81,132, 95,209,136,111, 37,217, 63,143,226,252, 81,
  7,221,210,179,218, 94,  5,232,169,130, 74,255,130,217,147, 40,232, 95, 41, 21,
 84,208, 14,188,206,  6,156,137, 16, 95, 87,207,146, 36,167,137,253,254,164, 52,
134,136, 81,148,147, 85,213,102,122,158, 61,  7,234,209,239, 67,  0, 55, 58,163,
139, 28, 79,149,244,102,101,237,226,107,240,142, 23,226, 19,  7,132, 14, 69,203,
233,172, 31, 48, 28,246, 67,235,254, 59, 49,205, 40, 72, 59, 78,226,172, 77,112,
207, 19,144,223, 88, 69, 11,121,234, 72,222,205,104,227, 12,120, 94,129,167,148,
195, 29, 28,232, 24,  9,184, 57,160,179,155,179, 11, 53,163,161,213,136,151,126,
185,  1,180,106,148,100, 80, 21,251,201,205,210,198, 18,252,163,198,108, 10,175,
 85,225, 96,176,139, 38, 81,109,  3, 91,165,214,227,108, 60,108, 68, 35,111,209,
 38,159, 23, 72,108,192, 68, 34, 31,148, 95, 88, 77,185,250,205,197,193,219,130,
111,  9,237, 69, 19, 67,196,169, 72,118,141,140, 83,161,161,213,219,192,177,179,
148,145,117,121, 46,187, 50,222,155, 83,205, 61, 50,252, 20, 95,188,125,166, 51,
 16, 71,173, 47,167,141,122, 14,  9,177, 87,163,144,  4,145,231,137, 30, 45,198,
110,236, 54,247, 31,219, 62, 96,164,204,179,198, 58,226, 76, 93, 98,163,185,225,
152, 40,110,137,179,  4, 35, 79,120, 46,118,115,109, 99,145, 64, 68,148,181,155,
 40,123,252,  3, 80,131, 17,240, 45,214,124,204, 54, 48,200, 81, 70,115, 30,129,
209, 74, 91, 54,116, 84, 55,166,177,131, 12,121, 19, 95,111,196,  9, 25,184,254,
 60, 61, 42,227, 57,111, 84,242,226,155, 47,245, 46, 39,112,190, 57,107,130, 83,
 99,107, 80, 93,162, 82, 11,148, 93, 65,129,232, 61, 37,254,122,108, 63,135,  0,
134, 20,104, 62, 66,139,232, 72,193,245,160,100,125, 84,145,221, 81, 16, 39,232,
242, 65, 71, 38,149,173, 79, 33, 39,239,167, 74, 71,162, 80,221,171, 56,183,241,
109,193, 58,216,172, 48, 21,255,252,166,121,175,228, 86,119,  2, 42,137,109,169,
 20,197,143,214, 28,236,157,209,228,216, 87, 61,202, 39, 91,  5, 12,211,125, 11,
 49,123, 92, 38,185,135,229,141, 86, 40, 27,103, 70,  4, 80,157, 55, 22,  0, 81,
 99, 31,  1, 82,107,215,134,182, 64, 29,233,159,221,145,227,159,  6,230,239,205,
 86,  5,184,239, 54,  1,206, 54,102, 47, 26, 87, 69,117, 17,192,107,137,168,130,
 89,208,  8,177,132,224, 36,210, 81, 51,152, 71, 10, 93,115, 89, 75, 84,204, 53,
224,197, 85,157, 75, 94, 23,179, 40,150, 98,150,111, 14,197,  1, 20,209, 17,187,
 12,144,110, 24,  1,147,193,179,191,  2,183,198, 39, 39,147, 98,146, 46,114,150,
117,240, 97, 90,155,247, 35,158, 88,148, 34,241,147,124, 82,203,193, 40,106,150,
 48,198,107, 81,230,187, 72,214,162, 16,157,147, 14,138, 90,118,177, 42, 69,178,
 67,130,106,219,228,181,138,105, 32,137, 89, 23, 63, 78,177,163,181, 35, 24, 85,
178,217, 72,196, 32,174, 43,106,134, 26, 99,187, 37,160, 96,214,235, 16,  1,211,
147,205,178,104,235,114, 62,130,229,123, 28, 17,147,164,144,212, 67,202,133,141,
 64, 14,253, 13,252,200,236, 22,154, 25,213,203, 67,114,103,110,141,205,153, 15,
210, 53,207, 15,121, 99, 91, 47,152, 39,  3, 30,  8,217,223, 14,231, 56,187, 50,
108,101, 48,217,195,125, 77,129,  0, 81,183,185,170, 37, 70,250,  6, 79,248, 66,
154,134,105, 45,224,136,210,206, 98,234, 95,209,149,131, 16, 88,126, 36,109,111,
110, 11,253, 24,174,152,255,129,210, 51,220, 35,163,128, 34,173, 97, 24,106,  9,
117,118,123,230,179,115,177, 52, 83,198,239, 22,201, 24,210,207,215, 88, 36, 69,
116,195,221,181,132, 63, 83,114, 58,171, 44,188,225,215, 18, 10,155,253,  2, 84,
226, 34, 75,226, 96, 85,133, 19,120,110, 58,212,  6,237, 73,232,150,255,114,199,
251, 67, 92,107,212,185,135, 41,106,  0,214,128, 35,144, 63,109,104, 97, 78, 97,
130,215,244,211, 35,236,240,160,109, 84, 34, 97,243,238,  8,190, 60,182,212,115,
107, 48, 73, 39, 81,189,133,196, 15, 67, 54, 34, 20,145, 67, 81, 52, 39, 57,249,
 52, 43, 37,202,141,217,  6,149, 99, 99,167,240,194, 82,112,162, 68, 71,163, 58,
175, 42,188,214,133, 25,100,220,116,138,138,108,200, 22, 46,220, 59, 54,117,179,
170,216,196, 61,134,113, 73,147,165,221, 76,219, 81,113, 45, 82,158,148, 34,219,
183, 51, 82,199, 62, 94, 63,117,165,145, 85,117,213, 26,100,249, 76,202,139, 93,
137, 53,210, 58,  4,209, 29, 27,176,196,120,253,101, 84,244, 17, 64,117,239, 93,
 54,201, 63,174,160, 67,110, 66,227,194,132, 26,219, 13, 69, 29,234, 48,225,245,
184, 73,147,104,204, 38,189,251,165,128, 46, 78,144,209,140, 96,227,244, 69,129,
253, 59, 39, 97,204, 85,188, 49, 38,214, 97,  3, 42, 38,161, 50,121, 61,248,111,
162,145,215,198,203,158,178,168,158, 71,156, 83, 36,241,125,187, 18,216,218,234,
210,213, 88, 24, 28,120,109,129,221,171,146,220,154,  5,176,124,165,244, 39, 95,
  9,160,192, 94,156,173,101,213,  4, 21,177, 51, 77,216,202,112, 50,233, 90,120,
 87, 68,146, 49,129,233, 42,155,206, 91,147, 62, 42,222, 17,134,229, 71, 31,101,
124, 25,141,198,  7,136,108,  8,144,103,242,246,215,140,  2,241, 21, 46,238,100,
143, 69,122,126,188,112, 79,133,101,240,188,125, 88,158,252,231,246, 12,192,  3,
 80, 51, 11, 64, 36,193,255, 96, 84,201,107, 23,249, 77, 45,255,231,177,166,122,
 73,131,151, 67,230, 68, 78, 31,237, 52, 22,199,188,190,198, 40,113,160, 48,245,
 65,225, 58,223,142, 30,172,102, 47,212, 88, 66, 86, 94,219,200,174, 91,213, 15,
250,121,148, 63,  3,136,237, 43,141,107,  1,116,180, 43,251, 34,233,175, 63,161,
  6,208,167, 61,244, 32,198,163,214, 84, 92,168, 34, 61,174,219, 18, 31, 12,106,
178, 88,  8,  5,141, 83, 85,136,151,226,126,144, 63, 88,237, 72,211,187, 70,157,
114, 43,163, 86, 30,150,248,140, 23,210, 42,157,191,230, 92,158,209,195, 45,208,
 67,133,196,149,169,  8,165,243,197, 40,  0, 29,249,166, 83, 64,194,192,218,215,
187, 28, 45,187, 53, 33, 29, 47, 50,254, 18,117,227, 69,248, 24, 90, 29, 12, 86,
 28, 30,209,226, 52,173, 46,216, 64, 22,218,227,245,193,149, 98,  6,140,123,171,
 37,245, 29, 88,164, 29, 90, 76,206, 55, 11,232,195, 13,205,227,240,163,236,219,
235,172, 97,142, 15,119, 53, 22,204, 60,140, 54,200, 52,194,118, 64, 26,140, 61,
224, 58,161,113,219,  9, 74,101, 51,113,180,104,170, 16, 34, 26,122,175,203,127,
171,205,160,174,255,206,173, 29, 72,193,137,130,143, 28,220,219,223,181,140,113,
113, 11,198, 41, 48,149, 29,237,210,216,177, 79, 96,237,146,184,166,  0,207,244,
121,171,212, 51,213, 34, 52,  4,  4, 77,122,179, 91, 11, 94,250, 23, 25,101,129,
  1, 44, 56, 63, 23,197, 88,162, 69,197,145,240,201, 83,164,148,153, 35, 29,217,
172, 95,124, 91,228,130,  8, 12,133,253, 61, 37,250,171,157, 65, 63,116,218, 12,
177, 19, 57, 34,139,214,124, 46,216,241,196,131, 69, 76,186,119,106,108,203,132,
100, 48,103,115, 85,158, 40,174,222,171, 97,158,156,  5,166,143,169,153,121, 92,
213,157,108,222,224,152, 58, 55,116, 81,113,170, 81, 19,171,246, 29, 83,142,115,
252,201,210,177,179, 64,  4, 27,136,101, 11, 49, 32,215,162,212,227, 97,232,170,
139,180,102, 89,187,102,139,127,237, 73, 35,217, 19,126,158,131, 58,209,213, 66,
245, 72, 50,156,  0,233, 65,126, 27, 53,240,173, 42,109, 53,144,253, 30,227,118,
162, 64, 64, 66,156,207,240,179,230,177,213,252,126, 28,197,220,210,129,129,141,
166,159, 58,179,206,143,225,  3,141,161,180,211,216,120, 56,126,211, 21,169,187,
 25,117, 26,229,118,213, 90,  8,134, 37,144,210, 72, 99, 17,145,110,210, 14,112,
129,144,183,147,238,132,106,132,221,240, 38, 39,128,108, 75,128,  4,  4, 98,141,
 63,248,196,102, 40, 12,228,187,128,194,211,179, 90, 63,105,185, 31,153,134,213,
116, 30,174,117,105,210, 63,214,135, 64,203, 10,175,180, 80,155,123,126, 37,101,
 93, 64,162,122,193,200, 81,176, 48, 91, 32,161, 60,105,133,197,111,198, 84,209,
138,188, 99,158,  0, 35,108,158,241,130,126,106,156,105,204,165,172,193, 43,174,
100,188,140,143, 53, 99,212,182,144, 91,147,  4, 81,103,133, 92,131,109,  3,153,
195, 68, 99, 22, 57,191, 13, 46,197,234, 24, 33,100,210,213,147,243, 86,130,177,
 96,234,172,146,111,144,109,160,115,144,104,229,151, 73,234, 13,197,176,203, 57,
109, 80, 57, 86,198, 24,161,147,168,158,156,183, 18,140,  5, 83,103,149,124,131,
108,  3, 29,  7, 79,137, 38,219,113, 78, 26, 84,174,149,102, 44,104, 72,172, 39,
102, 43,205,218, 53,  6, 65, 60,248, 84, 26, 67,233,129,178,250,  6,109,196, 70,
129,207, 77, 91, 45,182, 74, 86,142,248, 38, 95,243,139, 38,192, 78,132,145, 16,
212,164, 60,144,154, 39,207,136, 58,240, 46, 35,220,107,236,180,247,211, 61, 76,
245, 59, 96, 26,216,237,202, 23,168,  7, 58,213,102,  1, 41,  3, 63,217,  2,173,
125, 50,  4, 84,246, 55, 32,154,198,207,121, 84,118,130, 49,184, 99,224, 29, 65,
230,108,220,214,126,181,  9, 96,205,134, 53,204, 89,193,158,238,236,193,148,170,
  6, 59,213, 53,145,141,183,  2,199,169, 91, 10, 27, 42,240,128, 39,255, 77, 97,
211,181,140, 23, 32,255,197,198, 97, 74,230,  4, 97,192, 65, 83,108,151,111,192,
111,225,119,163, 22, 51, 28,110,254, 28,114,195,194,138, 35,122,149,248, 94, 52,
153,215,133, 49, 89,159,  4,220,235,228,212, 71, 61,202, 63,119, 83, 37, 93,176,
236,201, 77,187, 96,117,242, 63,158, 76,207,251,137, 94, 66,160,191,224, 51,108,
 57, 69,180,105,113, 23, 98, 37,200,197, 49,208,143,114,254,  8,231, 55, 65,110,
 15,113,202, 10,  1,140,  7,247,231,215, 67, 41,204,  6,  1,213,139, 40,238,173,
193,246,214,201,212,235, 48,162,111,209,162,126, 18,226,138, 26,128,144, 88,  2,
 68, 43,221, 88,105,252,130, 82, 49,107,149,134,225,154,  6,254,203,  3,251,129,
214, 50, 56,209,192, 27,160,255, 71,121,137,168,145, 28,144,215,154,169,146,180,
177,204,209, 65,196,121,204, 95,133,204, 63,124,117,164,236, 35,112,215, 27,187,
110,254,160, 39, 24,156, 25, 65,165,218,161, 60,252,103, 92,190, 53,156, 94, 22,
 35,222, 62, 42,184,233,192,238,128,234,203,224, 37,185,233,216,  8,  0,179,  6,
 98, 53,219, 17,101,191,179, 73,118,110, 80, 98,164, 50,101,243,164, 12,197,128,
202, 98, 72,184, 35,205,171,151,164,172,115,184,  4,151,241,121, 36, 80,139,190,
 63,178, 11,150,236, 47, 52,145,216,166, 41,110,159,153,222, 59,177, 48,116,142,
188,216,154, 57,179,175,  9,202, 84, 91, 77,172, 23,  9,
} ;

// ../Source/assign/include/GB_bitmap_scatter.h:
uint8_t GB_JITpackage_63 [237] = {
 40,181, 47,253, 96, 99,  1, 29,  7,  0,226,205, 44, 24, 48,219,  1,180,166,187,
130, 15,213, 20, 94, 66,208,178,132,240,165,132,179,193,194,209,  0,  6,  0, 64,
230, 49,253,197,187,137, 83, 50, 11, 75,220, 23,144,243, 46, 13,251,  0,168,192,
109,234,186, 39,226, 64,237,193, 58, 11, 34,127, 76,201, 28,  0,201,177, 24,111,
138,120,125,220, 97, 63,147,121,167, 63, 90,198,235,244,197,124, 25,159,164, 29,
227,187,236,235,223, 92,111,179,204,155,159,231,227,  5,179, 36,139,209, 40,201,
226,131, 40,120,161,179,139, 37, 63, 30,127,205,173,162,185,243,130,123, 46,200,
 92, 49, 75, 57,175, 89,188,114,191,115,203,  1,122, 84,205,253,168, 19,105,153,
181,198,172, 74,186, 78,213,188,115,154,201, 31,221, 49, 15,246,247,198,162,  6,
 87,140,238, 28,130, 16,229,  8,  2, 24,  8, 18, 16,  0,118,  0,118, 66, 48,238,
189, 74,  9, 35,169,123, 66,105,  7, 84, 18, 63,127,153, 81,135, 32, 90,247,160,
249,243,204, 20,109, 23, 91, 45,183, 24,180,128, 84, 92, 20,  5,110,
} ;

// ../Source/assign/template/GB_bitmap_assign_1_template.c:
uint8_t GB_JITpackage_64 [1819] = {
 40,181, 47,253, 96,172, 39,141, 56,  0,170, 65, 80, 12, 41,192,146,117, 14,106,
101,245,124,239,117,153,221, 45, 27, 99,229, 98,110, 68, 41,225, 69,150,120,144,
 61,194,172,132,108,192,161,199,128,105, 18,  4,  0, 44,159,  1,185,  0,184,  0,
190,  0,184,178, 44,234, 31, 85,204,244,147, 87,111, 84,155, 87,222,112, 99, 75,
123, 20,115,248,129,155,230,129,105,133,197, 14, 75,222, 51,120,169, 95,  4,111,
229,219,184,197, 48,187, 38,  0,128, 13, 91,180, 66, 35,190,124, 70,242, 42,194,
194,168,134,140, 97, 78,147,133, 98, 48,105,111,163,161,252, 37,118,237,106,190,
205, 97,147,198,183,183,202,153, 92, 60, 80, 80,184, 30,137,141,219,115,156,189,
142,234,185,181,242, 22,130,129,197, 96,162,112,177, 24,188,218,168, 91,184,142,
232,195, 41,242, 37, 47,131, 95,  5,221,250, 72,142,131, 23, 82,113,115, 53, 22,
105,248,233, 92,199,207,244,141,219, 70,239,229, 74,186,101,237,216, 85,178, 91,
159,191, 58, 83, 27,126,157,181,139,118, 59, 42,198, 84, 11,233,151,107, 72,115,
216,188, 82,153, 38,149, 74,149,197,154, 34,234,187, 46, 90, 71,183, 34, 62,176,
 91, 75,187,171,154,216, 96,159,143,236,106, 99,234,133,207,183, 63,204, 41,178,
206,212, 56, 94, 85, 13, 82,241,119,235,  3,244,145, 51, 27, 24,184, 21,202,168,
103, 90,200, 97, 67, 61,115, 11,130,161, 79, 26,175,178,208,162, 34, 48, 81,253,
 94,250, 58, 75, 71,239, 81,205, 91,119, 93,191,189, 12,230,172, 98, 78, 41,241,
145,153, 71,114,228,252,104, 82,155, 26, 72,179,193,121, 12,111,125,238,142,255,
255, 52,133, 76, 19,133,204, 64,152,131,230,233, 64,104,125,171,192,196,225, 72,
 77,163,241, 64,188,107,238,142,  2,211, 68,193,245, 93,125,201, 94,240, 92,231,
182,205,189, 67,191,116, 59,238, 42,230,219,191, 90,108,210,231, 59,204,130, 27,
  9, 20,111, 93,220,173, 30, 34,181,116, 11,  1, 27, 69,171,  4,188,185,209,110,
183,134,159,127,127, 20, 99,234, 61,123,139,237,145,166, 95,141,233, 54, 85,222,
150, 43,  9, 59, 84,124, 46, 34,242,135,  9, 76, 66,  3,121, 52, 37, 77,  3,146,
156, 10, 73,117, 41, 24,145, 72,176,165,163,155, 49, 32,174,218,188,117,107, 78,
234, 83,  3,179,230, 33,130,164, 77,195,160,232,204, 74,193,199,124, 65,165,194,
124, 99,134, 25,153,135,182,103,109,161,234,142,201, 60, 11,159,181,131,132,124,
235, 67,100,104,205,144,146,240,116, 44,180,136, 11,172, 68, 73,207,212,203,199,
 37,154,241,185, 75,143,  9, 46, 37,139,235, 47, 14,231,210,120, 42, 64, 21, 16,
 19,215,153,114,225,104,109,205,184,177,237, 44, 54,190,149,  4,222,121,  9,125,
 76, 75, 21, 82,161,121, 93,158,  1,184,184,110,251,174,138,172, 41,202,170,  5,
183,211, 52, 50, 97, 94,125, 62,154, 57,197, 13, 85, 89,172,  0, 43,155,183,244,
214, 46,224,214,164, 46,209,209, 46, 48, 15, 72,102,218,132,121, 38,219, 17, 95,
113,204, 45, 78, 76,102,114, 11, 64, 53, 45,185,241, 45, 34,235,170, 46,235,214,
137, 66,  2,109,135,142,169,  1,152,231,187,227, 82,108, 53, 29,183,122, 25,228,
126,245,  5,239, 59,236,167,100, 60,150, 46,197, 30, 91,123,219, 51, 22,107,247,
 11, 55,198, 52, 60, 72,202,111, 60,190,194,238, 11, 46, 69,151, 92, 86, 74, 74,
 89,239, 55, 94,110, 91,145,133,113, 58, 83, 78,145,  8,230,173, 71, 95,229, 70,
 13,147, 57, 41,133, 38,151,211,227,250, 79, 86,170,225,179,232,120, 74, 18, 41,
 55,164,196, 36,189,164, 46,127,235, 69,149,202, 43,219,145, 74,137,185,  7,109,
 49, 20,129,176,168,193, 45, 98,102, 68, 68, 36,  5, 73,146,101, 13,129, 16, 49,
138, 65,230,152,234, 13,130,120, 44,196, 50, 16, 70,241,  8, 33,142, 56, 66, 16,
 17, 18, 97,132, 16, 67, 72, 32, 35, 38,146,244,239,126,186,149, 11, 38,207, 81,
160, 61,222, 61,204,249,122, 36,117,230, 24,117,247, 63,218,113, 24, 24,111,146,
240,137,237,191,185,106, 76,105,247, 32, 10, 48,140, 64,127, 68,255,118,228, 91,
156, 59,230,105,140, 40,157, 67, 31, 75, 90,237, 45,254, 22,154,255, 98, 27, 15,
  6, 99,169,129,228, 62, 74, 62,162,164, 34,172,156,222,176,241,  5,235, 77, 69,
 58, 40,221, 91, 28,229,232, 43,223, 90, 76,254, 69,209, 79,178, 39,214,252, 70,
 88,246, 74,234,181,212,240,192, 73, 51,219,104,188,112, 56, 15,237,222,197,236,
165, 55,151,127,185, 81,122,246,253,240,  5,  7, 79, 69,198,121, 36, 51,131,140,
 19, 66,201,252,113,238,149,242,245,231, 21,208,  8, 67,230,192,153,210,155,208,
107,101,180,180,247,178,253, 65,219,255,130,204,246,239,111,227,218, 16,121,  9,
  4,  4, 87,231, 48,102, 45,205,152, 90,175, 93,215,196,109, 86, 38,132, 49, 14,
218, 96,194, 18,161,169,215,118, 52,228, 55,155, 50,253,149, 45,138,231,104,251,
156,128,193, 28, 23,195,240, 83,122, 94, 71, 25,244,114, 41,199,197, 29,143, 83,
 88,129, 90,134, 26,109,230,197, 22, 99,176, 44,118,248,151, 21,182,229, 56,110,
 37,108, 72, 73,142, 74,216, 85,108,128,236, 80,204,228,249, 88, 15, 96,147,177,
181,179,109,181,238, 36,217,205,159,162, 50, 32,201,240, 29, 97,236, 70,114, 46,
 35,156,185, 72,198, 83,132,177, 18,201, 77, 16,201,171,  2, 52,170,221,  5, 16,
169,139,193,107,113, 11,104,194,  2, 77, 15,232, 49, 67,134,136,188, 80,163, 44,
 92,147, 83,200,218,132,188, 30, 33, 42,  3, 33,187, 59, 72, 28, 13, 82, 48, 49,
218,145, 18,170, 41, 60,225, 19, 36,225,112,  2,124,164,177, 51, 17, 36,  5,229,
147,131, 45,224,137, 41, 11,113, 20,218,143, 92, 70,231,164,146, 32, 79,161, 65,
  3,201, 74,154,165, 64,139, 29, 61, 44, 72, 27,115,228, 39,147, 63, 36, 72,242,
 68,174,  0,  5,207,153, 40,151,202,238, 77,209,191,164,159,100,254,117, 85, 16,
 53,120,240,236,138,  6,191,215,226,112, 83, 73,131,108,183, 69,247, 42,246, 93,
147, 17, 26, 22,235, 44,233,168,253,  8,229,104, 82,198,221,132,160,104, 96, 86,
118, 46,172, 74,216,133, 65,120,143, 10,201,246, 91, 77,212,212,221, 38,187,189,
148, 45, 57, 36,207,212,149,215, 35, 76,140, 25,172, 37, 55,240, 80,180,171,219,
149,112,148,165,146,100, 20, 81, 64,104,247, 26,253, 93, 95,207, 34, 73, 90,109,
105, 21, 67,171, 16,155,114, 22,204,126, 76,149,166,103, 96,178,181, 45, 92,237,
 13,112, 49,194,255, 17,184, 77,124,225,  9, 70, 63,158, 62,196,110,166, 34,120,
122, 81, 37,113,152, 63,  0,122, 78,215, 70, 51,117, 73,242, 55,238, 42,106,235,
232,136,222,141,175, 82,227, 35,205,211,249,123,124, 58, 37, 45,107, 28,208,132,
219,192, 92,106, 34, 44, 54, 49, 48, 68,249, 41, 15,203,196,147, 82,  1,128, 61,
 10,142,165,253, 79,201, 59,210,229,127, 24, 69,103, 88,246,247,118, 26,212,  7,
 31, 19, 84, 64, 68,118,131,174,181,103, 90, 69, 48, 50, 57,245,184,206,170,230,
185,181, 90,250,237,139,203,200, 17, 35,121,189, 78, 11,121,181,219,131, 14,134,
241, 81, 87, 96,227,137,112, 64, 29,185,122,188, 60,172,224,190, 33, 27,197,159,
241,157, 12,227,231,175, 45, 94, 13,123,140,186,100, 15,205, 40,148,212, 27, 69,
245,237,186,162, 59,248, 72,208,212,144,148, 68,182,179,196, 38, 71, 59, 20,196,
127,136, 43,225,  5, 62,210,157,  0, 19, 85,112,192,203, 56, 11, 38, 59, 81, 58,
133, 20,128, 88,186,246,101,181,109, 76,125,214, 73, 77,250,  4,210,102, 32,195,
239, 12,167,150,112,201,186,146,107,197, 10, 25,188,217, 65,137,109, 18,  6,169,
103,248, 52,157,210,157,116, 96,207,194,136,180, 94,253,154,130, 94,253,124,192,
241,  9, 41,236, 89,105, 76, 95,115,144,250,221, 58,  1,231,209, 38,  9,201,149,
 93, 24, 56,244,187,170,169,253,176, 43,180, 11, 76, 83,  5, 43,184, 31,231,158,
 71, 32,  7,218, 75,195,173,206, 16,170,139,163,211,199,157, 80,109,249,133,165,
113,159,158, 34,222,148,162,148, 19, 49,140, 16,185,  0, 70, 11,188,154,215, 99,
 18, 32,101,154, 70, 77, 38,193,190,108,  6, 51, 99, 87, 92,216,  5,206, 77, 12,
 49, 90,101,166,190, 25, 13,199, 49,181,217,196,199,189, 90,181,114,141,  1,
} ;

// ../Source/assign/template/GB_bitmap_assign_1_whole_template.c:
uint8_t GB_JITpackage_65 [1567] = {
 40,181, 47,253, 96,  7, 54,173, 48,  0, 54, 50,152, 40,176,146, 85, 29,170, 74,
139,128, 56,175, 71,140, 69,139,229,198,188, 71, 82,174, 84, 62,235,251, 87,251,
 97,245, 10, 90, 12,118,205,157,210,159, 38,103,199, 51,142,  0,136,  0,141,  0,
158,245,138,  4,176, 94,127, 16, 11,225,199, 95, 10,206, 96, 45, 72, 73,162, 76,
 14, 36,189,101,212,139,175,124, 93,181,154,111,131, 54,146,198,183,179,202,145,
 84, 52, 72, 76, 64, 45,250, 26,183,231, 56,111, 27,213,115,107,227, 33,194,  1,
229, 64,146, 96, 64, 57, 56,149, 77,135,184,138,104,195, 39,241, 31, 91,238,184,
250, 57,188, 34,  7,179,121,244,211, 84, 26,127,212,187, 58,215,208, 37,113,161,
 44,163,223,114, 29, 29, 90, 27,210, 42,235,240,242,149,206,212,122, 92,231,217,
182,219, 70,211, 96,222,141,138, 49,157, 30,229,114,197, 38, 70,243,170,146, 36,
 85, 21, 17,226,138,150, 39,114,162,188,102,156,114,126, 50, 26,156, 67,222,173,
207,189,241,255,151,164, 16, 73,146,136,214,103,131,153,158,142,195,236, 91,  5,
 36, 14, 39,206, 76,198,227,112,173, 65, 55, 36, 32, 73, 19, 92,175,213,127,216,
219, 29,212,185,109,131,222,216, 47,205,142,251,246, 43,253,245,232,242,218,134,
186, 93,205, 25,125,115, 20, 79,175,128,110,237,248,168,165, 25,166, 32,156,238,
 81,191, 76,185, 88,233,140, 78, 89,201, 25,110,108,105,135,190,236,113, 93, 54,
 59, 48,165,240,215,222,199,246,220,221,233,255,186,195,124, 27,247, 23,150, 23,
 20, 96, 75, 69, 55, 27, 28,147,150, 83, 29,174, 83, 30,202,233,114,118,121,118,
124,221, 40,155, 22, 18,157,138,224, 30,242,  4, 21, 69,249,229,212, 53,203, 51,
164,119,113, 76,254,114, 44,123,158, 10,249,214,  9,194,211,161,152, 15, 27,249,
 10, 21,161,217, 92, 87,212, 42,166,155,247,124,155,235,172, 90,108,185,132,213,
145, 83,227, 20,213, 32, 21,115,135, 30,159, 43, 74,107, 96,224, 16,179,166, 91,
 19,195,104,166, 95,110,187, 14,187,132,113, 74,122,112,122,216,112, 84,238, 31,
 29,152,114,154,165,162,183,168,230,172, 53,173,223, 91,238,178, 53, 33,101,146,
 52, 34, 89, 78, 93, 87, 70,202,137,107, 98, 62,205, 68, 81, 96,192,225,173, 67,
121, 75,111,213,  2, 14,229,116,136,206,172,216,120, 62,158,204,117, 69,203, 47,
 12, 18,153,109,  8,247,247,251,133,114,127, 35,  0,160,206,221,253,104,219, 44,
198,120, 42,122, 48,198,120,174,251,180, 10,102, 48,114, 84, 26, 67,168,120,208,
165, 84,156, 30, 39,134,235,227,251,235,109,244,200,225, 76, 56, 92, 68,228, 84,
156,126,109,162, 36,  5,100, 19, 89,  5,188, 65, 33,155,221, 58,114,145,156,162,
213, 83, 28,176, 78,242, 31, 51,243,137,156,137,130,138,224,148, 65, 99,219, 35,
  1,129,138,168, 17,158,161, 25, 17, 17, 17, 73,146, 20, 10,141,  1,177, 24, 33,
  8, 57,198, 20, 68, 15, 66, 96, 36,  6, 52, 24, 66, 97,  8,132, 80,  8, 66,  4,
 68, 64, 40, 33, 17, 18, 34,128, 68,208,132, 72,240,114, 27, 97, 25, 76,110, 77,
 35,107, 87, 34,189,152,106,141,145, 85,149, 20, 92,  7,113,170, 78,243, 80, 69,
153,210, 58,150,126,163, 75, 83,100, 71,  6, 25, 73,184, 41,209, 21, 55, 69,141,
 22,214,  9, 29, 58, 29, 31,214, 32, 15,112,204, 65,201,113, 93,  8, 52, 35, 96,
 56,237,121,199,131,153, 98,219, 53, 61,202,222, 16,225, 97,238,189,104,103, 60,
 21, 90, 32,141,201,150,151,142,169, 47,115,185,159, 24,157, 14,161, 25,203,124,
126, 47,154,190, 16,153,230, 91,198, 79,241,145,115,233, 74, 52, 79,193,127,211,
 50,  5,136,165, 35, 70,252, 61,168,  2, 13, 98,227,  9,190,  5, 33,172,158,227,
134, 90,232,204,118,180,182,250,140, 26, 47,179,130,132,153,116,156,113, 32, 47,
148, 57, 87,  1, 84,225,  2,169, 93,223,114,246,  5,168,210,253, 41, 14,146,139,
171, 58, 40, 68,228,228, 72,138, 83,  8,229,108, 82, 94, 98,196,136,230,248,193,
132, 79,126, 75, 46, 65,248,130,105,161, 35, 56,140, 57, 60,245, 74, 97, 95,105,
158,  6,  6,172, 56,110, 35,239,108,101,  7,202,227,200, 73,162, 57, 71, 28,188,
207, 59,211, 55, 69,181,226,214,238, 85, 56, 56, 60,154,215,148,200, 16,248,110,
254, 58,238, 50,132,110, 43,100, 12, 68,200, 22, 37,205,218, 98,145,103,157, 20,
128,102,142,205,193,167,109,210,192,145,141, 28, 70,184,136, 11,123,172,  9,122,
197, 46, 58, 36, 88,216, 57,144,164,207,181, 93,193,115,  0, 35,193,144,182,165,
237, 78, 39,140,168,116, 65,  0, 16,223,111,  4,182, 50, 91, 60, 83,127, 36, 27,
 13,136,254,116, 67,131, 62,  2, 81,216,164, 15,172,239,192, 27,205,112, 98,230,
 70,241,222,153, 36, 81,136,171, 41,225, 35,128,  9, 24,197,128, 55,245,162, 66,
212,  7, 64,212,249,175,110,253,249, 94,245,159,154, 78, 75,116, 13, 85,234, 51,
101,183,192, 45,109,232,183,114, 17, 53, 10, 18,194,130,119, 95,  9,223, 28, 20,
162,206,  7,219,138, 79,158,107,191,141, 27, 38, 50, 50,225, 41,124, 46, 77, 43,
157,248,171,145, 42, 88,128,175,121, 33,136,204,195,188, 92,210,208,214,220,149,
126,106, 14,200,186,132,  1,128, 15, 32, 74,224, 86,147, 66, 24,  5, 83,152,228,
182,166,205,191,112, 38,236,138,120, 11,120, 47,254, 10,214, 48,138,187,108, 87,
230, 32,226, 93,115,227,158, 48,205, 86,155,142, 41,164,189,240,  1,  9,137, 93,
  7, 15,158, 76,130, 58,109, 72,182,160,216, 26,215,177, 32, 53, 16,  5, 37, 47,
227,159,131,233,180, 11,166,205,146, 33,166, 53, 73, 20, 81,106,130,  6, 80,170,
225, 52,201,111, 64, 62,152,241, 10,226, 76,147,198, 83,141,156,238,232, 60, 46,
119,225,147,137,117,111,154,173,150, 85,252,178,  6, 13,156,148,155,163,156,221,
116,134,169, 25,153, 76, 96,  5,178,221, 27, 40,129, 59,174, 75,  8,  9,222,110,
 29,216,187,132,154,  5,208, 69, 65,144,247,176,145,184,255,247, 46, 65, 39, 66,
255, 42, 91,227,135,  7, 34, 64,188, 71, 25, 17, 96, 89, 23,245, 25,164, 60,168,
112,234,110,  1,100,179,218,  6, 39,107, 68,123,171, 41,223, 43,133, 44, 54,187,
180,135,228,207,201,201, 59, 12,135,188,225, 69, 50, 52,222,215,106, 18,  2, 66,
125, 57,248,142,134,135,219,156, 96,160,208,202,196,114,242,246,197,147,218, 47,
 51, 21,103,194,105, 51, 16,108,222,237, 55,235, 16, 65, 93,247,255,170, 84,217,
240,155,116, 84,  2, 45, 75, 52,244,176,254, 25,194,107, 19, 29,145,143, 83,224,
121, 53, 82,222, 64, 82, 52,166,145,204,196, 64,200, 49,236,182,211,141,  4,171,
160,200,167, 22,182,128, 83,191,144,158,111, 78,221, 46,118, 72, 79,203,126,238,
231, 98,  5, 22,133,247, 89, 13, 66, 96,202, 92, 62,127,130,123,120,170,208,177,
221,224,165,225,232,234,228,131,101, 67,116,235,146, 35,135,186,211,161,173,161,
116, 24,206, 25,177,155,177,217,105,160,201, 10, 66,158,166,206, 10,103, 18,121,
194, 99, 57, 91, 52,208, 17, 49,208,172,126,102,138,126,138, 10,247,124,245,133,
216, 73, 25, 74,203,171, 19,
} ;

// ../Source/assign/template/GB_bitmap_assign_2_template.c:
uint8_t GB_JITpackage_66 [1823] = {
 40,181, 47,253, 96,236, 35,173, 56,  0,250, 68,168, 12, 40,192, 84,117, 14,228,
 90,225,218,222,243,164, 95, 47,217,243,211,132, 84,166,145, 14, 79,162, 52,113,
175,194, 92, 22,119, 55,140, 48, 96,154,  4,  1,  0,203,103,192,  0,190,  0,197,
  0,162,239, 62,190,  2,217, 26,114,105, 71, 53, 76,197, 56,125,164,222, 76, 61,
217, 26,197,102,149, 53,220,184,163, 29,222, 12,122,159,134,133, 96, 74,225,219,
224,136,123,254,236,244,223,239, 49,219,198,125,193,235,213,  4,  0,232,192,190,
 49, 11,241,229, 53,167, 40,162, 53, 57, 92, 13, 83,146, 46,149,  3, 74,115, 26,
  5,229,171,219,117,171,217, 54,200,162, 52,182,173,213, 13, 69,  3,226,162,  2,
106,145,219,184, 59,199,153,  3,169,157,119,157,124, 76, 56,184, 28, 80, 22, 48,
151,131, 83,218,244,136,171,  8,133,120, 69,126,196,229,207,171,159, 71,143,220,
 60,112, 32,189, 19, 85,227, 75, 65, 79,231, 26,122, 36, 47,212, 52,250,207, 62,
118, 93,184, 89,174,199,207, 87,157,105,  7,122,157,177,  3,204,130, 84,140, 41,
  6, 82, 47,215, 12,123,152,184,197, 34, 81, 44,150,225,200, 82, 28,162, 53,167,
 61,227, 91,183, 87,184, 49,166,224, 63, 81,126,227,240,213,102, 83, 69,116, 48,
 62, 24, 18, 47,161,166,111,181, 49,229,192,204, 47, 46,206,196, 62, 78, 81, 77,
 82,177,247, 56,242,241,200,121, 13, 12, 60,102,215,244, 11,203, 30, 38,166,107,
222,125, 95,118,169,227,212,  5,198,137,194, 10, 85,239,222,214, 81,145,183, 72,
205, 90,111, 91,191,185,252,229, 10,143,188, 58,114, 35,167,  7,147,216,196, 62,
 17, 19,191,132,115,  8,218,250,220, 32,255,127, 73, 42,145,164, 11,121,125,172,
  7,172,195,145,192,218, 86,  1,105,179,145, 88, 68, 68, 71,226, 91,131,108, 40,
 32, 73,149, 81,219,239, 25,211,238,158,233, 65,108,245, 14,178, 84,222, 47,226,
250,173, 30,212,185,187,  6,189,179, 91,170, 29,183,237, 87,125, 91,244,249,205,
234, 62, 45,191,222,183, 57,145,244,170, 49,213, 36,138,211,114, 21,225,  7, 12,
207, 77, 76, 14, 97, 97, 85, 96,159, 78,196,201,201,197,  0,147, 57,245,225,138,
205,199,199, 57,167, 79,236,203, 88,200,253, 68, 26,182,113,193,177, 20,124,100,
190,192,242,140,230, 23,248,140, 33, 40, 72, 48,106, 88, 20, 35,214,109, 29, 81,
209, 51,229,242,241,136,102,140,  9, 48,239, 58,250, 81,135,235,179, 89, 89, 76,
 88, 30,143,204,182, 61, 41, 64,171, 76, 75,192, 27, 20,118,154,173, 39, 39,153,
 83,152,107,166,107, 40,199, 54,103,158,185,199,  4, 57,158,205,107,158,105,207,
 24, 67,182, 20,192, 75,168,  9, 78, 21, 29, 78,  6, 70, 97,205, 80,172, 46,215,
124,183, 73,168, 42,214, 41,155,207,141, 95,221,111,147, 42,162,175,235,236,152,
 30,124,121,190, 65, 44,197, 93,  4,136,173,220,  7,122,213,246,179,175,100, 28,
146,116, 34,101, 78,121, 60, 17,115,222,137,137,186,196,128, 95,243, 29, 13,120,
156,211, 43, 56,152,134,213,249,200, 11,211,174,193,246,134,185, 47,101,217, 23,
 92,134,110,112, 89, 39, 41,171,245, 66,140,237, 46, 20,173, 13,103,202, 25,186,
 95,214, 90,196,171, 32, 17,  7,202,164,140, 50, 10,230,244,184,222,147,117,114,
240, 50, 56, 29,135,255,255, 17,164,252, 61,164,252,255,255,255,255,255,150,148,
186,251, 99,197,129,224,124, 48,  8,141, 67,170,117,118,204,229, 14,148, 95,250,
246,188,247,221,237,210,238, 52,132,140,130,192,240, 54,182,245,224, 52, 50, 49,
 21,168,187,251, 86, 67,113,134,174, 74, 93,226, 12, 77,222,255,170, 62, 84,105,
 53,255, 73,217,184,235, 42,119, 33,149, 50,243, 16,218, 55,  3,143,233,223, 30,
197,152,114,  1,129,157,168,129,169,114,104, 70, 68, 68,146, 36, 41, 12,107,113,
 12, 49,202, 65,199, 28,228, 13,162,144, 60, 69, 67, 20,132,129,  8, 33,136, 16,
 66,148,128, 16, 66,  4,136,  8,132,140,140,208, 72, 32, 98,221,170, 58, 95,124,
 35,225,192, 78, 43,128, 97, 67, 42,180, 11, 84, 64,141,  3,177,202,145,200, 25,
171, 51, 42,165,  9,188,215, 37, 43,134,251,108, 10,252,163, 44,195,123, 31,234,
 15,127, 13,163,127, 79,180,212, 35,130, 64, 89,165, 69,208,250, 15,254,245, 27,
129, 29,165,189,224,248,143, 67,126,208,197,208,148, 84,238,120,148,234, 85, 12,
 83,212, 15, 81,152, 23, 69,183,  2, 79, 52,223,134, 37,205, 90,241, 27, 84, 70,
  9, 32,120, 67,232,120,210,144,253,173, 32,121, 50,211,244,144,252, 51,192, 53,
250,157,232,161,212, 66,150, 75,253,147, 92,123,217,164,  6,196, 71, 13,215,183,
 96,181,206, 48, 89,247,110, 89, 17,107,248,170, 14, 43, 22,  4,124, 71,188,170,
  1,123,158, 64,172,228, 93, 83,205,172, 71, 44, 85,213,152, 41,174,244,143,108,
152,218,133, 16,168,255, 98,157, 94,131,105,250, 35,118,233,132,  3,163, 68,169,
109,172,115,225,115, 30,253,157, 51,  9,165,122,200,156,215, 28, 71,  4,248, 40,
136,194,144,186, 76,149, 74,243, 99,237,  6, 12, 42,236,152, 24,109, 15, 36,114,
117,235,228,152,221, 34,187,138, 67, 61,156, 18,216, 68,249,195, 72, 57, 82,  2,
244,168, 18,164,134,248, 11,106,240, 76,150,173,104,  5,136,123, 29,167,233,140,
165,139,118,179,243,230, 69,230,124,171,247,188, 34,251, 45,111,181,113,249,193,
108,183,250,188,136, 12, 78,  3,144, 77,121, 15, 44, 33, 70,236, 90,235,226, 31,
123, 67, 35, 58,162, 91,112,131, 81,219, 55, 37, 91,198, 26, 76, 61, 62, 79,216,
 10,  2,177,233,250, 96,178, 45,210, 69, 11,176, 55, 16,164,160,233, 61, 45,240,
135,229,209, 74,255,131,161,185,246, 44,  7, 40, 94, 66,119, 12,129, 85,161,225,
132, 16,  7,164,215,154,129,162,159,171, 61,148, 18,255,203, 11, 53,148,202,128,
 23, 72, 65,169, 50, 97, 68,169,  8,125,114, 44, 77, 47,  6, 17,252,  5, 77,216,
157,116, 48, 88,157,137, 48,168, 48,225,  0, 16,229,133,136,160, 94,204,161,200,
 74,250, 89, 10,134,162, 63,178,  6, 82,143,151, 60, 57,240,204, 29,243,107,  9,
193, 25,180, 90, 81,124,177,169, 14,178, 14,150,134,217,227,104,141,225,212, 23,
190,160, 52,230,248,162,171,192,175, 92, 85,176, 29,138, 84,183,122, 95,115,238,
 95, 22,  3, 17,250, 10, 35,119, 96,227,152,138,195,109,192,150,192,133, 96, 89,
121,224, 39,107,172, 95,254, 81,249,133, 55,231, 70,  8,131,161,201, 20,228, 81,
235, 68,155,206,254,  2,  4, 74,168, 47, 35, 34,248,252,140, 19,245, 72, 62,100,
 81,229,169, 27, 65,  2, 11, 23,191, 97,211,177,233,147, 87,113,199, 29,239,168,
136,113,104,  9, 67, 91, 27,248,247, 52,220,211, 23, 83,236,  4,161, 72, 67,212,
 66, 55,206,100,175, 13,126,151, 33,  6, 40,198,  9, 32,229,198, 17,176,241,105,
234, 78,169, 34,198, 16, 66,109, 71, 59,  2, 25,137,192, 19,115, 66,188, 82,150,
233, 11, 72, 13,197, 65, 53,236,197,117, 86,154,195,226, 16,120, 36,164,123,216,
 14, 12,147,193,228, 35,168,233,185, 52,147,224,247,111,109,243,176,  9, 91,238,
 81,101,153,183,  8, 69, 70, 35,146,117, 78,192,205,140,166,232, 65,  9,134,109,
149,128,129,252,189,200, 27, 66, 11,125,222,138,133,211,112,198,128, 45, 14, 33,
180,219, 90, 53, 59, 44,241,188,160,124,188,122,166,142,226,127,246,146, 24,243,
171,100,192, 53, 80, 63, 20, 19,125, 48, 35, 42,123, 47,194,192, 70,  9,226, 66,
180,130,215,235, 85,233,175,175,169,183,245,237,169, 33, 32, 45,182,251,227,189,
 62,243,230,101, 10, 34, 72, 51,  4,185,215,159, 18, 83,  1,143,137,115,130,194,
243, 60,180,217,242,110, 56, 82, 61,231,  1,249, 25, 14, 77, 77,135, 49,255,114,
 46,127,173,123,180, 67,124,116,125,106, 42,198,113,187,172,204, 35,203, 90,130,
118,  5,  5,236,158,166, 39,178, 17, 84, 83, 26, 22,165,144, 95,227,130, 21,153,
126, 85, 25, 67, 16,225,174,243, 96, 62, 18,173, 99,204, 92,118,134,  2,173,202,
  7,203,236, 84,171, 85, 14, 15,244, 82, 35,157,145, 25,133,128, 40,196,142,111,
114, 28,223,120,172,184, 46,114, 29, 80, 38, 92,161,220,236,123, 38,132, 76, 77,
140,  5,136, 81,  6, 24, 67,101,166,248,  2,252,229, 22, 37,222, 17,205,158,174,
250,182,152,
} ;

// ../Source/assign/template/GB_bitmap_assign_2_whole_template.c:
uint8_t GB_JITpackage_67 [1523] = {
 40,181, 47,253, 96,136, 49, 77, 47,  0,182,117,160, 40,176, 84, 85, 29,104,161,
167, 34,206, 73,  3, 17,213,164, 57, 75,229, 44,153, 28,148, 82,219, 64, 19,143,
 44,168, 26,144,  8,229,210, 31,244, 31,108, 79,233,102,150,  0,144,  0,152,  0,
185,179,211,127,187,195,108, 27,247,245,170, 99, 36,  0,192,230,245,133,215,135,
 31,175, 57, 67,181, 32, 37,201, 66,185, 76, 90,195,168, 23,143,185, 93,179,154,
109,143, 60,147,198,182,177,250,153, 84, 52, 72, 80, 70,237,113, 27,119,232, 56,
107, 27, 53,244,109,139,135,  8, 23,203,101,146, 96, 96,185,156,194,166, 67, 92,
 61,104,195, 41,241, 33, 90,238,184, 42, 58,180,226,103,163,121,244,118, 48,141,
 47,245,172,206,245,179, 36,238,195, 48,250,206, 30,110,219,151, 85,170,195,203,
 99, 58,211,205,227, 58,207,222, 58,237, 99, 94,166,221,168, 24,211,233, 81, 46,
215,107,110, 58,175, 84,164, 73,165, 18,253,214,114,151, 33,172, 88,133,226, 39,
 74,107,198, 41,167,136,211,193,249,243,108,125,238,141,255,191, 36,141, 72,146,
 68,172, 68,158,205, 12,129, 28,102,219, 42, 32,125, 62,113,114, 56, 33,135,103,
 61,178,159,128, 36, 81, 66,218,118,207,152,246,246, 76,191, 97, 43,198,149,251,
200,210,120, 59,136,235,179,250, 81,231,222,122,244,190,110, 41,118,220,182,143,
233,219, 31,151,207, 60,148,237,106,198,232,155,163,120,250, 49, 35, 91, 59, 46,
221, 40,134, 41,  8,167,131,212,155, 41, 23, 27,163, 83, 98, 50,134, 27,111,180,
191,155, 61,174,195,102,  7,166, 20,190,237,133,104, 15, 61,250, 54,204,214, 18,
131,137, 37,171,167, 56, 96,157,228, 27,111, 93, 98,185,102,186,166,224,120,163,
 30, 54,103,110,144, 57,213,225, 58,229,225,161,148,211,229,236,242,236,184,221,
  7, 54, 45, 36, 64, 21,130,131,200, 19, 60,203, 60, 67,122, 23,191,228, 53,191,
176,231,169,144,109,165,164, 55, 65,132, 64, 20,243,193, 35, 15,143,161, 34, 58,
 30,203,138, 89,109, 76, 53,239,217, 54,151,185, 68,  5,146, 83,227, 20,213, 34,
 21,115,135, 32, 34, 43,202,106, 96,224,240,170,166, 87,243,218,116,166,107,190,
117,221,117,  9,227, 84,229,193,233,193,195, 81,185,119, 96,202,101, 27,245,120,
123,212,140,117,150,  5,146, 84, 34,101, 78, 89, 22, 71,202,  9,107,110,110,103,
162, 44, 48,224,240,213,225, 70,109,205,  2, 14,229,116,  8,208,172,240,132, 68,
 33,142,101, 69,134,137,204,219,135,251,222,222, 47,247, 45, 57,136, 15,185, 62,
234,220,217,231,239,186,129,166,194, 85,203,247,186, 59, 14,184,238,102,135,177,
160, 32, 70, 42,122, 48, 70,106,226, 17,237,171,101,123,  8, 66, 57, 17,139, 29,
 90, 14, 47, 57, 61, 55,230,154,219, 54,250,172,187,252,165,189, 97, 37, 20,140,
 28,149,198,195, 43, 78,143,243,194,245,241,125, 91,251,248,231, 51,225,112, 18,
146, 83,113,186,229,137,146, 20,128, 81,100, 37,224,  1,129, 98,168,  1,162, 33,
 18, 17, 17, 17, 73,146, 20, 10,141,  1,113, 16, 66, 20,130,210, 41,237, 54, 98,
104, 40,197, 83, 16,  3, 81,  8,194, 16, 32,  8,130, 17, 16, 34, 36,  4, 19, 16,
 33, 35, 68, 64,136,192,145, 32, 93,213,  1,226, 24, 80,240,182, 33, 27,150,176,
  5, 29,164,212, 14,232, 41,142, 21,252, 39, 86, 86, 89, 38,211,234, 97,217, 41,
202,229, 86,153, 18,135,212, 83,197,186,246, 84, 88,235,184,  2,212,151, 56,191,
 46, 45,129,109,169, 27,167,171,190,182,200, 97,254,  8, 63,226, 79, 54,  7,125,
119,116, 68,  6,173,128, 38,174,229,164, 88,  5,100,141, 21,173, 64, 89,143, 36,
 73,178,154, 20,229,103, 96,247,166,203,222,230,  4, 15, 36,225, 93,221,225, 11,
193, 26,155,164, 82,250, 87,185, 68,244, 65,113,162, 47,148,  7,188,240,153, 68,
245, 16,  2,217,250,180,111,180,145,193,209,164, 61, 10,156,165,244, 90,242,191,
 96,104,207,186, 21, 15, 46, 88, 29,165,121,102, 67,  7, 58,192,130,248,172, 35,
 32,  0,116,246,248,152,113,124, 43, 64,144, 14, 74,210,152, 73,230,108,113,195,
  1, 15,167,186,249, 85,228, 24, 40, 63,113,120,167, 95,232,215,230,  1,112,238,
159,152,245, 56, 24,230, 99,224, 93,166, 60,150,101,178, 33, 51,246, 40,255,100,
  0,205, 73, 50,216, 30, 35, 50,202, 72, 14, 50,202,200, 30,131,121,  5, 73, 66,
 76,188,116,175,231,  4,198, 92, 83,186,178,  1, 21, 19,179, 95, 78,175, 45,156,
161, 55,158,178,112, 88,208, 80,168,148, 73, 18,177,244,107, 34, 57,182,215, 22,
 37,146,101,169, 64, 14,242, 75,184,196, 49, 23,237, 86,105,162, 24, 75,141,249,
184, 65, 77, 36,173, 94,117, 74,130,244,241,143, 11,106,222,164, 76, 43,189,141,
 56,106, 77,165,142,159, 22,188, 91,231, 29,153,232, 81,238, 92, 25, 21,160,224,
176,192,  8,201,159,177,103,210,130, 80,166, 80,152,162,230, 24, 51, 88,  5, 71,
184,  2,250,171, 28, 33,140, 71, 19,253,251,217, 82, 57,193,226,226, 27, 18,236,
 62,222,233,114, 69, 61, 36, 79,217, 26,118,160,132,172, 12,173,228,132, 39, 60,
118,175,214,209, 65,  6,204,198, 16, 43,100,  3, 32,232, 81, 85, 41, 29, 51,175,
 28, 92,252,166, 54,145, 75,225, 39,232, 74,104,245,237, 49,185,  1,168, 98,136,
142, 67,143,169,  8, 51,128,118,157,142,170, 23,  6, 23,103, 79,145,102, 13,237,
140,139,206,148,176,245,217, 80, 75, 63,228,208,242, 66,144,136,130,171, 43, 12,
122, 89, 76, 21,  9, 70, 28,136,167,165,244,116, 92, 73,144,239,203, 26, 10,114,
123,187,155,172, 91,253,  1,148,221,165, 96,150,120,202,158,  9,151, 96, 19, 41,
 26,173,215,  1,  1,196,246,178, 24,211,151, 90,129,202,180,  1,233,235, 90, 55,
 80,131,173, 36,  5,133, 60, 46,102, 85,255,221, 62, 77, 10,173, 95,193, 18,185,
129,182, 81,101, 89,  6,194, 55,164, 47,170, 33,134,220,163,240, 83, 71,169,217,
235, 54, 37, 91,218, 68, 32,178, 33,169,221,199,213,196,228,196,172,237,147,103,
177,233,130, 25,253, 53, 98, 82, 35,212,229,217, 30, 25,213,240,205, 61, 27,190,
124, 17,196, 30,161, 21,191,234,131,103, 89,179, 45,222,167,214,129, 12,121,221,
 87,215, 71, 85, 15,222,108,160, 90,  0,185,197,185,239,110,157, 58,167,114,180,
198, 54, 15,104, 36,150,152,  2,253, 20,225, 83, 26, 42, 75,222,209, 29,158,120,
219, 67,125, 77,165, 24, 53,238, 33, 27,  4,162, 71,165, 97,124,235, 97,204,221,
 75,222, 32, 50,131,226,222, 30,229,127,225, 33,242,151,244,234,216, 36,127, 63,
 22,110, 68,144,177, 82, 14,194,194,115, 24,249, 24,246, 56,196,122, 96, 21,225,
196,249,160,234, 63, 99,115, 25, 85, 73, 33,199, 16, 99,165, 65,173, 61,120,121,
172,123,191,195,183,222, 29,250,  4,216,128,125, 13,216,209,207, 56,142,177,118,
187,130, 57,147, 97,150,249,153, 41,219, 97, 89,156, 67, 99,234, 50,158,210, 83,
234,181,156,
} ;

// ../Source/assign/template/GB_bitmap_assign_3_template.c:
uint8_t GB_JITpackage_68 [1718] = {
 40,181, 47,253, 96, 86, 37,101, 53,  0,214, 60,182, 40,176,148,177, 14,172, 64,
228,245,143, 57, 24,116, 98,176,217, 42,130,192, 91, 18, 35,186,161, 87,152,142,
 17, 51, 59,105,150,242,245,131,254,131,254,207, 14, 56,171,  0,167,  0,176,  0,
 87,206, 76, 55,227,198,220, 36, 93, 93,201,102,242,  3, 79,139,227, 76,164,108,
107,245,107,255,151,107,227,190, 29,246, 43,114, 93,223, 55, 50,225,195,115, 38,
183, 32,158,167, 82,192, 18, 34, 69, 93, 42, 25, 74,111,217,236,224,175,219,148,
 68,115,109,205, 67,105, 92, 59,163, 31, 10, 70,  3, 69, 69,107,144,219,184, 65,
199,121,235,160,160,115, 28,252, 43,200, 92, 50,148,  3,204, 37,115, 43,171,254,
 48,  5,153, 13,175,192,159,182,108, 75, 84,244, 23,130, 31,134,173,155,247,225,
 10,117,166,166, 16, 85, 50,101,217,252,150,105,200,223,237,238,180, 89, 26,223,
217,225, 99,127,143,191, 58, 79,174, 43,117,150, 26, 89, 59, 40,198, 83,118,179,
148,233, 72, 50, 60,220, 98,161, 40, 22, 75, 23,129, 58,215, 73, 44,134, 10, 14,
231, 13, 18,158,  8, 41, 32,112,137,  7, 79, 40,  4,171, 92,187,212, 91,190,213,
 50,190,148,100,243,227,243,109,144,106,179, 95,248,218, 87, 75,109,253,251,245,
249, 84, 56,188, 34, 70,136,201, 78,244,124, 66, 32,248,129, 49, 36,161,140, 82,
212,121,208,234,252,131,127,216, 95,124,238,142,255, 63, 69,145, 80, 20,  5,196,
 68, 30,  6,  9,154,112,144, 93,105,  0,245,249, 64,217,233,128, 28, 78,106,173,
154,  2, 40,170,130,233, 73,244, 39,174,218,107,157,155,107,237, 61,122,157,217,
113,211,155,107,255,234,219, 33,143, 39,121, 56,155,133,216,251,247, 75,171,244,
227, 78,110,102,248, 85, 23,161, 55,207, 18,188,254,171,179, 41,227,  3,182,100,
181, 63,123,123,164,148,109,189,  7,205,174, 11, 87, 58,115,181,217, 67,108, 13,
125,160,133, 68,148, 19, 18,150,199,163, 21,182,101,179, 51,163, 24,111,177,223,
206,153,194, 80,110,105,172,190,246, 65, 96,120, 32, 68, 60, 22, 69,  1,100, 21,
137, 89,  0,222,154,137,203, 42, 45, 57,201,142,  8,126, 42, 38, 22,166, 49,215,
 37,155, 79, 38,152,155, 32, 53,111,110, 89, 76,101,252,251,139,221,159, 72,172,
 30,165,205,242,227,218,144, 76,102, 80, 76, 68,145,104, 93,206,217,112, 44,  3,
 63, 97,186,229,  1,203,230, 28,177,211,248,104,148, 61, 75,  4,146,141, 91,177,
171, 34, 64, 19, 23, 50, 34,  4,177, 11,123,169, 82,142,155,191,150,132,249,117,
205, 23, 56,239,186, 63,158, 37,129, 65,174,116,243, 42, 20, 85, 66,109,110,133,
 66,157, 24,239, 67,101, 93, 30,192,195,  0,254, 98,245,136,  9,137,225,  1,137,
206, 81,160, 68,206,132,251,190, 94, 83,238,219,217,236,240,187, 47,137, 66,137,
 86,108, 16, 59,154,215, 58, 87,147,205,126,210,102, 95,110,254,149, 11,163,201,
 28,115,185,  2,229, 23,143,119, 89,215,187, 26,207,173,251,150,107,115, 90,157,
219,175,125,124,201, 94,210,177,223,217, 92,246,171, 59, 55,225,105,  2, 33,  7,
132,176,243, 64, 74,163,117,158, 90,103,226, 56,154,241, 68,147,111,227, 74, 49,
189, 21, 61, 94,164,149,230, 34,241,202, 96, 58, 42,221,172,174, 26,197,195,234,
240,149,222,131,206,107, 15, 53,155,107, 50, 26,173,233,195,100, 48, 39, 18,213,
  2,129,144,168,241,165, 50, 51, 35, 34, 10,146,164,160,144,214, 97, 12, 66, 16,
115, 78, 50,204, 60,130, 64, 52,142, 71, 64,136,162, 17,101,136, 33,  2, 67,  8,
 81, 68, 72,136,  0, 17,162, 68, 18,208,136,172,  7,100,206,192, 14, 83,249,118,
180,201, 38, 11, 21, 13, 19,125,108,156,192,228, 34, 71,102,175,192, 91,147,162,
 26, 88, 52, 20,244, 24,218,176,170,183, 81, 24,156, 34,121, 85,165, 40, 72, 75,
166,140,181,138, 87, 47,  8,170,255, 43,137,168, 27, 73,  4,109, 36,194,128, 37,
145,124, 45, 36,149, 37,144, 50,232,209, 15,208,109, 63, 58,175, 83,161,136,  0,
123,161,184,111, 84,170,230,162,  2, 25,114, 32, 67,223, 40, 17, 98, 65,248, 10,
208, 55, 38, 84, 34,145,182,165,164, 36,209,169,212,173, 71, 80,  8, 79, 15,166,
141,182, 76,190,201, 29,234,248,241,197,248,193,145,103, 35, 80, 39,100,120, 15,
 85,251,194,223,121, 39,154,208,195, 94, 61, 48, 77, 48,224,236,  8, 68,251, 63,
128,156,101, 58,113,232,223, 49,131, 83,254,180,168,129, 28,169,  4,115, 27,244,
 56, 30, 50, 44,  0,203,227, 72, 94, 70,216,231, 65, 63,239,147, 98, 11,193,177,
 44,212,153,250,157,151, 23, 98,225,185, 40,247, 43,189,203, 12, 71,199, 96, 52,
172, 93,183, 86,  2, 25,118, 42, 83, 55,164,172, 69,220,233, 70,166, 77,205,149,
243, 49,227,175, 28, 92,149,134, 33,217,161,214,187, 60,238,137,136, 11,140,133,
170, 94,  2,224,185, 72,200,220,149,157,196,190, 56,188,152, 32, 99,  1, 69,246,
249, 72,185,  4,177,175,119,204, 71, 25,196, 55,255,144,210, 15,249,108,127,176,
239,112, 36, 31,206,179,177,231,131,224, 83,  6,241, 70,142,129, 69,247,146,214,
 75,166,157,121, 74, 50,145, 10,143, 45, 11,159, 61,134,100, 61, 36, 32,140,  4,
156,106,  3,152,186, 32,237,160,153, 79, 94, 30, 82,221, 35,148, 75,128,168,113,
164,234,148,150, 35,162,143,100,140,142,196, 85, 21,130, 18, 92, 50,194,139,178,
154,152,228, 66,234, 11,115,213,109,155,214, 89,214, 26, 64, 91, 69, 15,146, 30,
 56, 73,235,178,106, 77, 64,141,141,146, 81,  7, 50,180,188,107, 70, 68,215,112,
230, 26,117, 56, 20,171,124,170,178, 77,204,169,137,247,247, 42,196,  2,117,102,
200, 25,102,190, 35,230, 91, 91,211,  0,167, 14,225, 24, 64,244, 58, 50,178, 75,
215,193,126,174,198, 98,137,254, 91,192, 48,221, 33,136,125,120, 57,156, 90, 24,
 86,139,208, 71,234,245,136,173,102,153,177,135, 30,222,115, 94, 63,242,158,221,
 75,159, 74, 68,249,227,215,162,157,254,154,145,237,156,236, 34, 10,151,131,110,
170,244,154,127, 68, 83,111,134,130, 82,112, 97,168,194,114,186,191,191, 68,188,
 38,124, 48, 99,227, 32,212, 76,213,104, 82, 82, 91, 54,142, 54,174,131, 48, 80,
163, 62, 30,199,252,226,185,117,237,183, 45,158, 37,252,225, 42, 91,152,114,147,
 37,250,138,100,104,193, 62,171, 45,146,130,140,212,143, 64, 79,130,144, 18,137,
 24,176,190, 23,  0, 90, 72,114,244, 62, 43,238,135,179, 51,172,  4,169,200,131,
168,102, 55, 89, 40,222,195,116,202, 81,145, 56, 11,160,141,112,139,152,153,100,
174, 24,246, 93,194,211,231, 89,176,254,206,162,141, 21,113,223,242, 19, 96,101,
 26,  1,197,102,  3, 61, 38, 66,212, 20, 64,149, 28,140,134, 86, 58, 40,127,249,
241, 77, 19,103,104,103,214,241,155, 82, 46,176,202,142,137, 79,231,  4,170,195,
 39,250, 27, 12, 99,204,163,  0, 91, 88, 34,110,185, 40,135,236,212,233, 16,245,
 43, 95, 52, 27,201,128,176,104,153,  9, 20,206, 35, 53, 19,153, 61,146, 56, 61,
 70,248,240, 28, 45, 92, 18,156,218, 45, 72,247,218, 48,247,117,235,  7, 50, 29,
107,226,168,111,214,114,252,123, 31, 95,127,237, 36,132,103,211,  5, 99,146,213,
229,203,115,248,226, 37, 37, 25, 72, 20,227, 30,177,157,227,188,246,231,244,251,
113,157, 35, 61, 82,191, 39,204, 21, 59, 72, 88,229, 14, 91,217,252,110, 67,246,
  5, 87,162,132, 24,142, 66,193, 14,118,168,196,178,217, 68,100,136,103, 13,235,
241,  4,  4, 12,  1,190, 57,186, 19,206,145,178,220,243,195,222, 76,  2,158,240,
 43,250, 37,141,228,  7,142, 38,213, 11,134,  8, 38, 77,205,106, 28, 60, 46,246,
114, 40,254, 98,179, 10,249, 72,157,103, 63, 43,174,221, 66, 29,168,155, 24, 99,
 17,106, 48,121,213,222,211, 16, 89,121, 38,247,223,167, 43,221,  1,121,
} ;

// ../Source/assign/template/GB_bitmap_assign_3_whole_template.c:
uint8_t GB_JITpackage_69 [1800] = {
 40,181, 47,253, 96,184, 59,245, 55,  0, 70,118,163, 40,192, 84,177, 14,228, 90,
 25,117, 30,188, 74, 64, 80, 78,235,131,192,137,224, 58,111,189,162,233, 74, 69,
151,132, 64, 74,164,131,  6, 76,147, 32, 32, 77,114, 16,151,  0,146,  0,154,  0,
 86,250,221,254,151,109,227,190, 92,117, 42,102, 92,223,215,233,240,225, 25,  8,
222, 80, 45,196, 40, 50, 40,176, 76, 26,163,147,131,167,110, 87, 79,205,182,175,
204,164,177,109, 90, 53,147,140,  7,139,130,171, 65,110,227,222, 28,103,204,163,
110,158,101,240, 15,193, 98, 96,153, 36, 84, 12, 44,159,168,244,135, 43,200,124,
120,  1,124,  8,203,155, 86, 57,127, 22,212, 56, 96,220,188, 17,148,213,185,118,
 86,164,117,148,206, 99,185,130,254,110,115, 33,140,210,248, 78, 14,191,250,123,
 60,213,121,102,156,214, 89,118,182, 97, 32,121, 32,173, 71,197,120, 74,110,106,
185,118,164, 67,196, 41,148,104, 66,161,  4, 19, 69, 68,198,178,160,148,109,107,
141,229,111,215, 69,140,176,146,152,152,209, 88, 27,168,129,209,146, 80, 70,201,
193, 68, 92,118,254,193,191,234, 47, 62,183,199,255, 63,138, 70,162,200,  2, 86,
156,140,131,220, 84, 64,200,182, 85, 32,210,104,160,196, 96, 54, 16,247,244,101,
 59,129, 40, 42,192,245,158,250, 80,102,183, 95,157, 59,235,235,221,185,157,244,
184,109,159,234,219,160,199,123, 50,147,221,106,166,243,173, 77, 44,253,212,101,
235,231,206,108, 82,252,164,135,212,155,167,  6,169,159,106, 58,101, 60,149,105,
119, 51,110,156, 77, 15,167,109, 84,126,240,156,178,172,243,228, 45,211,134,171,
140,127,127,145,251, 11,137,210,163,220,178,252,220, 13, 68,165,134, 69, 69, 72,
172, 88, 46,255,204,190,157,201,  4,103, 19,196,230, 11,174,148,129, 87,241,  3,
148,198,147, 78,210, 49,154, 43,  8,143,112,124,138,156, 52,177,169,192,144, 18,
153,120, 80,177, 84,182,219, 34,218, 63, 42,253, 79, 25,156,129,194,182,110,244,
160,205, 94, 62,225,107,246,197,240,  7,207,108,159,135,173,180,102, 88,126, 90,
 86, 22,105, 93,104, 44,228,  6,195,225, 60, 78,188,216,112, 44, 57, 97,193, 74,
250,237,156, 39,197,178,250,224,169,217,250,233,227, 85,169,122,  8,163,179,127,
 55,207, 45, 29,145,219,120,231,  0,167,  2, 81, 84, 18, 93, 62, 89, 22, 38,198,
 11, 75, 58, 92,131,128,191,248,108,218,234,  9,152,168,144, 25,153, 13,  7, 86,
146,179,193, 88, 22, 60, 67,195, 36,102, 29,238,123,123,187,220,183,233,228,240,
187,175,167,132, 34, 83, 77, 42,147, 95, 13, 67,  7,  7, 16,194, 11,195, 59,244,
 89, 42, 76,144,123, 48,126,203,182, 30,118, 24,134,  8,226,181,237,122,126,103,
103,244,193,143, 58,225,244,215,129,210,161,236,224,122,248,190,141,129,174,209,
 92, 64,156,132,228, 19,148,110,101, 96,150, 77, 89,149, 52,206, 58,138,  2,104,
 65,164,  4,188,175, 46,163,182,150,148, 80, 57,235,102, 72, 98, 56, 80,115, 65,
112, 64, 64, 80,185, 60,129,223,168, 81, 34,145, 17, 17, 17,145,164,160,160, 32,
105, 12,177, 16, 33, 70, 57,229,152,100,119, 98, 72, 48,140, 71, 48,132,161, 16,
132, 65, 16,132,  0, 36, 36,132, 16,129, 17, 56,  1, 33,  2, 34, 20,197,136,168,
213, 24,158, 51,248,202, 47,139,193,236, 57,227, 29,251, 38, 93,229,238, 10,234,
173,233,192,  1,140,201,149,241,170,102,129, 85, 10,118,176, 22,202,156,213, 88,
178, 20,108,161,116,184, 89,226,241,223,219,175,138,246, 80, 24,214, 40,120,159,
140,211,138,130,247,157, 48, 80,222,223, 22,204,150, 25,161,191,  4,250,206,229,
174, 77,172,225, 41,220,179,221, 60,211,  1, 69, 83,153,188, 64,184,131,107,137,
111, 93, 77, 42, 57, 59,156,175, 30,154,146,234,145,153, 92,  4,204,145,166,241,
210, 68, 47,120,  7,182,136, 95, 57,234,124,228,120,195, 15,214,122, 95,100,155,
 45,176,219, 74,145,181,126,175,123, 90,234,183,173, 62, 19,227,240,  7, 96, 83,
148,243,157, 41,223,120, 30,247,155, 43,253, 23, 61, 75,192, 27, 21,227,238,125,
 64,241,136, 45, 19, 30,199,236, 22, 96,128, 58, 76, 69, 25, 72, 24,101,172,136,
 18,250,112,230, 18, 84,145, 63,110, 43,247,  0,150,  3,177,181,114,119,238,187,
 27,  1,133, 64,160,234,137,246, 57, 65,107,207,228,239, 90, 57, 57, 91,239,193,
138, 88,  8,254,130,130, 48,125, 17,118, 26,217,204,162, 52,157,123,157,240,158,
244, 71,144, 19,143, 44,238, 61, 51,125, 20,166, 68,125,157, 66, 16,124,142,102,
130, 34,221,187, 25, 82,120,108,237, 97,206,208,183,115,251,121, 43, 40, 73,194,
232,118,116, 56,251,220,204,149,134,249,199, 28,163,144,148,248,185,143, 70,146,
182,227,104,189,185,132,182,179, 54, 90,196, 26,134, 38,  3,202,140, 60, 21,154,
127,178, 83, 48,150, 42,235,199,211, 54,255,169,234,  7,  9,159, 81,  6,210, 18,
206,101, 99, 79, 48,160, 70,139, 95,212,214,123,218, 70,206,130,255,201,250, 91,
244,226,192,135,174,119, 48, 24,241, 15,146, 27, 89,  5, 12,175,118, 41,221,180,
 87,245,208,174,169,243, 39, 26, 11,202, 21,166, 19,226,117,137, 92, 18, 81, 52,
236, 38,225, 92, 50,164, 43, 92,147,136,153, 38,170,251, 91, 49,168, 69, 87,  4,
127,235, 29,149, 98, 49,111, 85,143,  1,  1,119,249,217, 71,193,251,  0, 24,124,
124,  0,119,185, 30, 64,187, 71,121,128, 39,158, 10,179,159, 29,235, 73, 50,182,
 19, 12, 53, 71,187,228,160,190,197,209, 49,  8, 14, 18,168, 55, 58, 66,110, 80,
 89, 27,189,142, 13,122,183, 70,203, 73, 13, 50,148, 70,201,  5,138,114, 68,100,
199,129, 11,225,254,124,130,193,152,177,251, 98,247,228,170,227,  3,195, 63, 59,
 57,240,  9, 10,198,115,224,102,188,205,206,108,142,179, 32,117,255, 57, 88,186,
 23,204,119, 67, 45, 85,131,119, 82,114,139,218,110, 51,243,219,110,241,227,108,
112,119,154, 31,252,  5, 46,122,163, 63, 13,177,220,218, 60, 37, 54,216,185,141,
 31,218,197, 18,135,188, 57,134, 92,221,194, 51,198,  9,100,246, 11,220, 95, 16,
167,111,119,136, 66,204,246,101,187, 25, 19, 86, 27,141, 14,143, 36,173, 14,157,
 18,244,145, 65,  1,198,211, 38, 86,114, 19,188,156, 97,230, 88, 58, 79, 95, 23,
229,126,231,192, 97,240, 32, 52, 78,205,  9, 67, 63,192, 16,242, 93,192,144,203,
 20,160,121,  1,227, 23, 16,207,129,214,156,138,240,227, 94,212,162,127, 93,182,
 81,114, 49,228, 65,170,148,158,126,140, 58,176, 16,216,167, 97,167, 18,138,155,
160, 15,228, 43,113, 54,  7,225, 65,224, 14,248,158, 14,107, 56,124,249,228,188,
 13, 52, 31, 28,114, 55,144, 42, 48, 70,104,245, 11,197,128, 77,162,156,118, 74,
245,138,199, 97, 13,119,211,161,156,156,223, 41,232, 75,100, 24,229,159, 39, 94,
 67,177, 18,182,169,102,212,243, 96,157,243, 89,214,250,246,167, 50,153,250,134,
 58, 31,211,227, 29, 98,141, 32,211,199,143, 29,197, 50, 99, 93,221, 99, 31, 88,
  9, 81, 53, 65, 81,249,254, 89,  7,122,110,116,180, 71,216,188,192,  8, 18, 41,
166,143,205, 15, 32, 91,  3, 36,145, 64,244, 44,218,157,101,212,240,246, 35,246,
 94,235,147,223,100,249,148,166, 16,200,251,192, 76, 41,216, 24, 16, 13,138,215,
 64,182,114,122,139,210,244,104,197,241,174, 73, 99,105,194,224,118,178, 55, 50,
  5,227,148,168,103,234,237,249,182, 65,195, 79,240, 33, 56,204,  6,150, 53, 23,
172,126,  2,153,227, 96,142,124,169, 55,183,161, 75,137, 77, 54,157,111,156, 87,
 25,191, 60, 12,  4,164,167,220,133,236,208, 88,215,220,189, 82,201,170,241,186,
127,222,186,100, 94,141,196,155,117,106, 20,249,240,  9,140, 67,136, 73, 44, 13,
 33,  3,185,106, 47,233, 50,248, 48,160,168,  5,108,131, 28,251,117,139,156, 76,
246, 39, 12, 11, 81, 33,  2,192,129,186,153,211, 38,  5,179, 83,249,188,204,163,
235,172, 96,111,240, 85,215, 27,221,176,  2, 61,183,104, 41,135,219, 14,158,152,
203,149,194, 67, 44, 11,  0,179, 33,134,129,120, 52,176, 55,  6, 33,252,242,140,
180,225, 31, 76, 78,101, 15,  3,145, 16,249,135, 30,149,146, 80, 53,105,145,  1,

} ;

// ../Source/assign/template/GB_bitmap_assign_4_template.c:
uint8_t GB_JITpackage_70 [1802] = {
 40,181, 47,253, 96,113, 46,  5, 56,  0,134,122,175, 40,160, 88,177, 14,192, 67,
232, 59,224,234, 77, 66,  5,235,155, 60, 68, 10,194,238, 65,155, 43, 25,249,215,
118, 20, 53,198, 78, 93,142,151,227,197,112,188, 56,  4,164,  0,155,  0,167,  0,
 25, 55,214,100,136,219,236,140, 37, 88, 82,154,214,133,178,173,191,246,175,114,
109,220,151,187,110, 65,141,235, 91,137,116,248,239,156, 83, 20,149,103,114,184,
 26,160, 36, 97, 14, 52,150, 22, 77,201,189, 91,183,105,136,230,218,153,199,210,
184,246,164, 31, 75, 71,  4,198, 65,214, 38,183,113,131,142,179,104,132,130,174,
105,239,149,130,  6,163,177, 44,100, 48,154, 83,115,122,133,169,137,140,248,193,
 59,138, 40,219,141,102,188,194,222,  7, 66,196,201, 59, 97, 97,157,105,135, 73,
 91, 55,167,188,173,175,110,115, 40,162, 75,227, 43, 57,252,235,213,225,173,206,
 82,227,182,206, 49, 33,214, 17,138,177,140,156,220, 50, 21,137, 16, 19,191, 92,
 36,203,229, 18,175,244, 20, 73, 69,167,235,162, 41,251,215,134,174, 57,199,224,
 33,144,251,184,  8, 60,188,205,149,254,250,237,156,  1,174,216,129,158, 15,  6,
122,159,  7,177,248, 34,140, 25,157,  9,156, 59,174,210,231, 30,249,255, 75, 82,
138, 36, 97,188, 43,195,  3, 17, 65, 23, 18,177, 43, 21,144, 62,159, 23, 59, 29,
144,196, 67,157,213, 78, 64,146, 14, 80,186,218,103, 44, 91,123,150, 31,169, 20,
 99,186, 61,171,242,239,218, 10,211,135,232,179,206,173,117,246, 22,121,149,243,
184,233,205,181,111,245,237,209,225, 67, 30,205,206,145,189,175,110,101,149,150,
 92,169,201,137,167,159,208,155,229,246,126,171,167,140,240, 86,158,221, 13, 52,
194, 87,175, 32,247,234,  4, 78,135,209,230, 88,114,237,104, 70, 15,140, 11,120,
 41, 56,129, 47,160, 28, 54,156,139,204,231,200,  0,114,170,175,173, 40, 58, 60,
 20, 39,158,107,154,180, 14,161, 17, 97,225,169,136, 54, 31, 62,223, 54,177, 26,
211,209,181,248,118,115,218, 87, 75,111,125, 62, 26, 18,191,214,202,181, 55,139,
  9, 15,134,189,233, 33, 74,101,122,174,187,100,122,109, 44, 69,  9, 35,171, 33,
100, 77, 51,154, 12, 74,136,102,118,179,217, 43, 18, 58, 95,113, 78, 66,183,223,
194,156,243, 91,184, 82,153,171,157, 31,217, 26, 48, 15,174, 75,192, 59,235,180,
 89, 41,246,121, 27, 22, 48, 94, 88, 80,144,155, 42, 64, 23, 28,177,  2,123, 87,
  9,150,219, 91,148,  3,146,180, 34,109, 78, 97, 88,  7,194, 59, 49, 81,152, 42,
192,214, 87, 23,188, 38,  3, 94,193,233, 21, 23,177,195,  3,202, 56,199,193,  2,
179,214,225,190,175,183,203,125,123, 74, 14,191,251,134,  0, 50, 64, 29,235,  8,
127,232, 96, 15, 70,132, 76, 99, 57,127,209,236,188, 92,219,154,  8,126,179, 55,
244,235,173, 36,188,119, 41,120,143,122, 92,245, 36,250,206, 50,227, 58,132,205,
 13, 12,242,109, 92,233,136,130, 36, 21,164,211,201, 72,165,162, 12,197, 77, 34,
111,250, 35,161, 82,210, 52, 25, 47,130,129, 43, 91,155, 48, 99, 65,184,138,202,
 19, 40, 15,164,190,177,158,240,  7,142,180, 98,177, 96, 48, 21,229,103, 78, 64,
208, 88,235,149,  9,107,210,164,230,205, 55,167, 44, 14,129,197,168, 33, 34,154,
 33, 17,145, 20,164, 36,201,176,  6, 97,  8, 49, 10, 65,  7,161,117, 30,114,112,
 36, 83, 49, 36,196, 80, 28,129, 33,152,128,  8, 16, 49,  2, 66,136,160,  8,136,
 33,161,145, 17, 60, 29,217,214, 64, 59,102,198,133,167, 99,156,129, 85,126,111,
149, 78, 65,120,205,189,103, 90, 64,254,134, 24,112, 17,198, 82,213, 52, 77, 76,
236,176, 49,142,249, 57,109,146, 22,106,116, 11, 98,224, 47,205,147, 84,  7,127,
246,  1,227,100,155, 45,235,112, 46, 79,145, 18,212,175, 72,181,150,210,159,133,
 41,  7, 61,198,  1,107,141,134,162, 55,100, 48, 31,117,222,144, 96, 25,117, 57,
152,163, 86, 71, 51, 97,168, 95,171,210, 72, 30,112, 66,154,116, 36, 30,225,232,
198,109,196, 45,158, 41, 89, 53,124, 60, 59,242,184,146,216,177,163,250,168,167,
 23, 17, 28, 34, 85,146,105, 98,190, 11,133,  9,224, 86,216,208, 22, 85,134,188,
214, 50,115,179,107,173,203,231, 25,182, 26,122, 46, 53, 29, 73,111,219,142, 61,
252,176,251,253,122, 31,150,214,243, 46, 91, 94, 37,202,253,231,224, 44,165,114,
 11,162, 37,215,254,226, 36, 62, 73,202, 12,253,118,242, 74, 74, 39,209,238,178,
141,241,191, 26,153,178,185, 38,137,149,234, 56, 89,250, 71,254, 91,184,251,120,
239,126, 12, 75,215, 84,198,  9,146, 67, 84, 42, 30, 23, 33,168,130,163,214, 70,
 44,247,221, 98,153,226,195,200, 90, 53,116,114, 80,225,201,213,183,124, 46,127,
100, 60,140, 66, 70,122, 72, 41, 30,249,105, 63,150,168,177, 81,101,119,162,170,
100,194, 90,173,111, 80, 44, 87,147, 33,100,139,132,160, 16,186,171,113,138, 13,
132, 98,191, 92,232, 56, 76, 75,130,124,112,190,245, 94,174,188,198,146, 60, 33,
136,165,106, 52,136,159,164,246, 93,148,136, 53,158, 46, 13,208, 26,154,103,  2,
 21,174, 93,126,176, 33,116, 46, 14, 70,148, 83,  0,213,248,249,232, 93, 21,149,
 44,220,  5,  7,134,248,100,104,254, 91,214,204,149, 94,239,130, 34,127, 64,202,
  0,107,241,127,228,251, 43,136,  5,195,153,138, 48, 13,203, 75,117, 23, 17,212,
180, 14,137,104,146,137, 14,244, 96,170, 87, 52,215,223,171, 67,181, 23, 52, 80,
  7,192,188, 70,168,207, 30,200,177,133,150,233,138,132,221,  2, 67, 59, 26,224,
201,154,194,183, 31, 67,138,204, 46,238,242,200,  8,143,203,119,147,233,191, 57,
185, 62, 38,148,108, 16,125, 98, 46, 21,146,138,195, 48, 98, 40,252, 25, 33,200,
135, 65,139, 65, 48,207, 16, 56,167,  2,200,175,212,193,112, 53,107, 83, 86, 14,
 93, 77,118,120, 81, 39,186, 81,145, 58,126, 57,134, 29, 35, 46,113,112, 48, 78,
  8,177, 25, 47,228,166, 95,131,162, 72,185,192, 58, 94,219,215,247,104, 89,105,
125,165,  4,233,137,178, 26, 13,210,120,205, 18,253,174,216,224,214, 74,221, 77,
239, 23,144,146,215,181, 45,206,107,143,  7, 84,138,141, 88, 37, 59,153,238, 80,
164, 64,194, 59,169, 99, 62,206, 78,138,  5,207,115, 67,132, 67,126, 65,225,102,
 47, 60, 48,248, 84,115, 33, 62,  5, 59, 20,115,230, 71,148,224,178,224,186,170,
124,213,193, 23,241, 25, 80, 32, 91, 31, 14,  8,213, 44, 99, 35,  8,111,250, 86,
 50,195,121,236,114,168, 87,244,222, 66,156,104, 84,186,202,123,234,148,192, 75,
218, 83,206,169,111,103,127,138,219,196,153,198, 11, 82, 26,208, 85,121, 79,194,
174,  1,190,135, 51,244,157,131,149,237, 96,214, 56,198, 94,173, 72, 88,  6,220,
190,197,102,156,147,241, 27, 87,114,104, 72,206, 39,218,150,146, 63,196, 35,148,
 51,162,214,164, 14,142,187,130,120, 35,129, 26, 61,157, 68,250,169,233, 62,164,
 83,118,127,213, 46, 80,239, 90,157,165,193,135, 98,245,203, 50,102,202, 74,192,
149,161, 71, 55, 33, 30, 50,188, 61, 75, 56,132, 29,218,124,198,129,163,195, 89,
240,224, 30, 76, 33,100,198, 78,215, 67, 12,228,254, 57, 42, 81, 14, 59,232,182,
  2,155, 73,169,191, 25,202,  1,210,132, 84,232,233, 50,178,239, 22,164,121,159,
175,180,157, 58, 42,184, 19, 80, 34,112,178,252, 70,119,115,235, 59,215, 76,153,
207, 70, 35, 96,211,160, 30, 48, 91,179, 68,243, 47, 54,107,170,183, 20,221,105,
221,148, 19,221,163, 75,123,205, 85,235,225, 77,176, 41, 43, 89,126,105,252,113,
250,163, 33,107, 74,  4,164,244,129,230,200,211,219,239, 81,223,223, 60, 28,219,
 10,114, 52,232,255,198,167,  7,246,126,188,148,188, 28,250,180,154,134, 65,133,
 76, 17,178,144,167,229,148,117,131,217,134,246,167, 12,185,220, 61, 49, 88, 78,
 87,  7, 67,  0, 66,104,114,206, 10, 66,230, 73, 67,208,133, 35,199,116,226,249,
  2,194,129,188,213, 34,200, 70, 14,166,115,104, 88,197,184, 44, 20,231,116,161,
102,179,126,  2, 68,152,193,212, 33,154,202, 53,230,159,167,  8,143, 53,219,  4,
234,137, 17, 54, 82,131,105, 88,209,112,152,200,110,191, 56,255, 61, 91,233,104,
205,  3,
} ;

// ../Source/assign/template/GB_bitmap_assign_4_whole_template.c:
uint8_t GB_JITpackage_71 [1872] = {
 40,181, 47,253, 96,214, 73, 53, 58,  0,150,185,171, 40,192, 84,177, 14,232, 84,
 74,157,  7, 55,  9,  8,202,105,125, 16, 48,137, 84,164,179,211, 88,193, 60,255,
169,172, 65, 92,164,131,  6, 76,147, 32, 32, 77,114, 16,161,  0,154,  0,164,  0,
 88,155,161,110,227,168,  4,193,147,210, 52, 81, 40,115,246,114,255,203,182,113,
223,206,122, 21,181,174,239,  3,137,240,225, 53,103,176, 22,162, 36, 89, 10, 48,
148,206,232,236,224,171,219, 53, 84,179,109,140, 67,105,108,155,214, 14, 37,195,
161,162,  0,235,144,219,184, 61,199, 57,243,168,158,107, 26,252, 67,192, 88, 48,
148,132,139,  5,115,138, 78,127,184,134, 76,135, 23,192,143,100,153,219,234,231,
239,130,157,134,172,155, 23,162,186, 58, 87,209, 37,109, 34, 74,231, 57,251,119,
187, 27,201, 42,141,239,236,240,173,191,199, 87,157,167,214,109,157,101,107, 92,
 54,146,  7,210,122, 84,140,167,236,230,150, 43, 72, 54, 64,188, 82,145, 40,149,
 74,154,255, 89, 85,182,189, 81, 19, 16,156,235,130, 83, 60,151,109,125,103,249,
118,206, 84,196,227, 76,  0,150,220, 68, 78,231,242,192, 14,140,151,132, 50,202,
207,  6,  2,103, 81,103,235,115,123,252,255, 37,169, 68,146, 42,160,245,225, 52,
 72, 15,197,131,108, 91,  5,164, 78,  7,202,205,198,243,240, 80, 99, 86, 36, 32,
 73,  5, 35,109,185,103, 60, 91,123,158,247,176, 21,227,186, 29,179,243,240,114,
 15,215,135,234,177,206,173, 53,246,  6,221, 78,122,220,182, 95,245,237,209,227,
 67, 28,202,114, 53,211,249,222, 38,158,254, 10,179, 21,228, 78,109, 82, 60, 93,
164,222, 60, 55,248, 87, 77,167,140,175, 50, 21,221,140, 59,152, 72,163,182,254,
164,202,154,104, 94,  8,  8, 46,153, 83, 28,174, 50,254,253,197,238, 79, 36, 78,
143,146,203, 18,228,114, 35, 42, 53, 42, 40, 68, 44, 76,230, 32,179, 47, 40,115,
 10,  5,107, 51,196,230, 76,101,224, 86,252, 64,165,241,164,212,244,140,230, 58,
194, 37, 28,167, 98, 55, 73,120, 40, 48,100,  4, 39, 26, 92, 48, 23,238, 54,201,
246,247, 81,233,255,202,114, 77,133,109,157,217,114,244, 35,206,102, 78, 97,108,
246,205,112,182,207,195, 86, 90, 53, 44, 65, 90, 90, 24,121, 89,116, 42,164,103,
243,249,188, 79,180,240,124, 46, 41,113, 65,235, 89,127,210,  2,193,115,179,245,
212,199,171,147,245,140,206,254,229, 66,199, 92, 67,240,142,216,109, 28,244,146,
116, 34,101, 78, 93,215, 38, 70,139, 75, 54, 92,136,137,178,  4,252,113, 54, 94,
155,182,134,  2,254,226,116,  9, 10,153,193,241,124,160, 37, 63,158,205,117,193,
107, 24, 40, 49,107, 34,220,247,246,138,114,223,166,179,195,239,190,161, 19,131,
203,172, 33,156,125,150,235,232,207, 98,112,161,252,  0,107,152,153, 14, 32,132,
199,236,252, 69, 99, 49,104, 14,162,207, 82,129,130,221,131, 48,115,138,196,206,
233, 87,  7, 94, 76, 72,248, 27,196,111,220, 13,253,206,214,232,131, 31,117, 66,
234, 15,  4,167, 67,  9,122,223,206, 70,135,239,116, 44, 30,110, 98,114, 10, 78,
191, 56,240,105,218,148, 86,168, 54,214, 90,146,  2,104, 65,172,  4,188,  3,129,
229,168, 49,162, 25, 25, 17, 17,145, 36, 37,  5, 73, 99,177, 12, 33,  6, 57,198,
160,195,118, 98, 96, 36,  7, 36, 28,130,112, 12,130, 32,  8,130, 16, 16, 68, 72,
136,192,  8, 58,  1, 17, 16, 33, 38,100,148, 21,117,225, 24, 76,173, 17,242, 10,
116,239, 31,120, 71, 63, 79,229, 41, 98,214,  5, 26,162,201,150,210, 70,128,209,
157,129, 49,237,155, 13, 58, 59,228,  4, 52,116, 58, 28, 69,123,191,165,158,207,
208,  4,173, 90,196, 47,224, 10,199,133, 26, 37,163,  9,223, 15,190, 66,162,155,
 16,243,121, 24,195, 34, 89, 43, 93,118,213, 96,198, 34, 41,186,252,228, 42,134,
114,108,100,  0,129,148, 21, 46,175,248, 55,209,176,253,137,201,138,  3, 43,215,
228, 24,219,173,132, 93,117, 20,191,103,172,162,143,149,251, 11,178,235,208, 72,
139,163,175, 13,240, 95,130,158,132,227,239, 12,  3,102,164,254,129,131,183,138,
 48,116,219,151, 94, 12,252, 35, 42,232,174,  5, 38, 48, 23,224,157,171, 42, 35,
206, 73,142, 76,189,212, 15,126,225,154, 16, 29,  3,188,154,147,133,193,129,118,
  3, 86, 53,215, 37,245, 38, 76,242,185, 85,220, 21, 43, 75, 40, 24,204,103,101,
 56,  5,252, 66,193,138, 62,  7,112,171,121,173,236, 41, 23,223, 66,  3,138,248,
128,129,188, 35,  7,215, 28,  3,161, 52, 93,253, 96,105,170,  2,196,215, 94,126,
 26,204,109, 13,131,103,101, 46,215,217, 30, 73,188, 91,116,140,161,122,222, 66,
193,  9,187,253,153, 63,104, 92,255,122,204, 94, 89,146,  9, 40, 16, 39, 81,231,
244,142,126,164,233,230,130,  4,157, 37,151,188,160,138,219,150,215,246, 91,  4,
218,104,248,100,201,221,223,238,240,138,163, 52,180,175,251,100, 16,177, 11, 90,
234,  2, 17,248, 39, 16, 93,158,236, 43,127, 45,224,  5,195, 38,235, 75,149,190,
183,246,  4,172,174, 27,144,202, 18,157,  6,161,212,131,231, 34, 23, 56, 25,235,
 52,235,200,123,160, 57,203,195, 69,100,173, 49,178,242,  5, 85,101, 72, 72,132,
 82,108,140,225,125, 59, 90,124,100,235,251,159,164,159,117,150, 68, 61,  9,192,
 45, 14,144, 89, 15,205, 54,  4,214,218,131,184,183,168, 18, 44,190, 50,209,213,
149,133,155, 91,209, 96,158,232, 42,169,242,147,148, 12,  5,202,147, 41,153,183,
 59, 79,248,196,156,159, 32,144, 41,126,243,135,245,141,112,226,235,216, 33,  2,
 63,219,194,181, 21, 22, 93,144,220, 14,124, 68,127, 30,  4,131,108,160, 67,126,
  6, 30,162, 86, 12,124, 32, 57,205,234,196, 66, 42,105,186,224, 11,160,106,157,
 16,101,194, 15,210, 21, 43, 35, 43, 82,174,170,248,  7, 81, 49,173, 41,162, 35,
 41,190, 88, 20, 59, 16, 20, 25,232,137,119,206,145, 68,127, 48,199,129,114,  2,
194, 44,119,254, 60, 21,224, 58, 89,205,209, 82,104,118,125,190, 94, 43,224,130,
250,175,106, 26, 94,245, 46,209,247,189,210,242,185,206, 48, 58,216, 21, 65,120,
229,122, 27,204, 61, 33,248, 26,202,190,185,141, 94, 94,171, 52, 68,204, 39,188,
180,154, 94, 71, 76,136,  4,145,237, 42, 88,241,133,130,203,100,244,113, 11,189,
 34,234, 10, 52,112, 27,144,254,  3,224,159, 91,148,251, 15,220, 93,167,195,216,
 87,246,177,152,115, 53,109, 33,241, 82, 90,194, 73, 54,122,209, 30, 13,217, 22,
 37,190,216,208,147, 48,151,237, 83,130,159, 48, 40,176,203,196, 82, 21,152,205,
 57,  4, 84,154,  5, 33,237,121,  0, 90,184, 16,129, 21,197, 83,172,186,229, 65,
 66,232, 84, 33,207,117,135,213, 85,165,113,221, 23,107,121, 24, 47,144,122,208,
 62, 32,165,251, 65, 16,115,216, 66,211,141, 73,118, 38,253,104,231, 64,168,147,
100, 19,106,245, 38,193, 77,136,185,111, 57,199, 89, 75,132,254,136,202,203,161,
 78, 82,197, 25, 83,118,145,136,155,132, 59,  9, 66, 23,218,122,175,158,125, 99,
116,177,234,187,194,237,188, 49,109,108,110,177,184, 65,245, 94,152,145,215,136,
118,160,144,168,135,205, 44,229,217,116, 53,120, 55,235, 81,129,  4,145, 16,221,
143,131,126, 64, 56, 72,150,  6, 42,223,116,164,192,192, 95, 75,127,133,196,231,
 49,138,217,191, 53,111,101,233, 90,113,  4, 72, 13,180, 36,  2,254, 15, 56,  2,
  9,144,151,148,  8,244, 69, 16,245, 16,131,229,149, 96,138, 61,225, 18,198, 44,
161,172,  2, 32, 22, 92, 12,182, 86,160, 95,161,180,210, 13,183, 93,234, 25,164,
169,183,239,227,129,109, 72,201,167,142,117, 21,156,109,149,212,186,239,218, 25,
 36,113,135, 73,217,197,207,121, 48, 76,163,222,166, 63, 30,200,  2, 19, 91,197,
 15, 20, 56, 65,179,169,219,180, 69,167, 44,183, 58,129,252,118, 95,174,113, 85,
101,189, 41,157,130, 55, 73, 37,244,254, 36,158, 70,121, 21,252,250,250, 25, 88,
136,136, 76,127,249, 74,196,183, 55, 16,111, 68,185,238,112,159,135, 61, 84,103,
 52,164,100,104,  7,241,103,105,214, 65,  6, 18,250, 34,229,221, 27,188,101, 88,
175, 13,178,205,235,231,187,242, 71,122,230,114, 98, 34, 65, 26, 36,208, 23,214,
 29, 25,  2,122, 96, 82,166, 67,162,  6, 65,163,229,247,119,117,149,221,142,204,
 24,231,110,  9,106, 90,168,214,194,248, 21,  4, 51, 89,118,  3,102,216,229,240,
 80,129,161,254, 34,197, 77,108,181, 91,224, 70,140,179,178, 63,152,192, 21,221,
204,147, 51,246, 14,213, 52,197, 83, 10, 93,243,
} ;

// ../Source/assign/template/GB_bitmap_assign_5_template.c:
uint8_t GB_JITpackage_72 [1403] = {
 40,181, 47,253, 96,133, 25,141, 43,  0,214,119,166, 40,208,178, 88,  7,228,222,
108,241, 54, 90,  2, 56, 47,128,  5,255,115, 62, 79,233,101,142,209,174, 46, 26,
177,137,227, 94,234,182,152, 47,188,224,104, 25,213, 11,157,  0,144,  0,163,  0,
167, 84, 30,179,191,178,169,245,140, 55, 14,  7, 96,175,219,252,142,107, 65, 20,
  0,213,250,122, 54,188,160,240,119, 75,228,211,131,203, 72, 11, 10, 48,138, 42,
147,  2, 73,103,150,212,222,169,219, 19,155,185,246,149,145, 52,174,109, 77,141,
196,162, 97, 98,114,181,199,109,220,156,227,156,109, 76,206, 41,125,119,  6,  5,
149,  2,201,  1, 65,165,224,147, 37,221,225,233, 33, 27, 62,121, 15,101,217,126,
102,231,174,122, 26,134, 76,147, 23, 67, 53,190, 82,171, 58,207,173,138, 62,155,
101,201,103,121,130,238, 54,183,245,238,240, 84,103, 73,181, 79,231,104, 16,235,
198,196, 88, 70, 77,126,242,244, 68,  6,204, 41,148, 72, 66,161,  4,199,250,170,
155,  0, 54, 31,162,213,254,234,220,180,175,183,231,149,234,219,160,195,201,116,
 53,222,234, 38, 29, 83, 42,173,103,214,204, 64,119, 90, 95,141,  1,243,144,231,
 87,211,171,214,110,207, 67,151,236, 75,177,204,222, 88,102,157,127,114,117,174,
253,105,250,121, 40,107,159,126,149,175, 14,207, 99,153,169, 63, 18,191,179, 44,
157, 90, 11,100,239, 29,117,213,217,113, 37,149, 22,158, 40,221, 28,190,187,173,
133, 50,233, 31,243,102,249,121,185, 54,238,171,181, 37, 35,164,178,133, 49,149,
216,175,125,111, 55,107, 31,107,197, 14, 44,187,218,186,161,160,195, 61,111,174,
 29, 47,138,  2,172, 73,164,  4,188,175,141, 90,117,134,132,226,165,243, 52, 20,
145,198,180, 67, 34, 17, 76,165, 71,205,  4, 30,152,240,201,226, 25,225,221, 29,
212,238, 62,160,116, 24,109,142, 86,188,152,144,128,148,129,127,192, 15, 76,149,
 91, 18,174,  1, 53,140,123,224, 45,247, 88,207, 17, 33,215,153,241,169,175,117,
 80,147, 32, 56, 18, 21,241,193, 34,243,240,145,121,157,191, 22,163, 30,129,201,
 84,213,187, 22, 78, 19, 27,  9, 24, 33,170,183,  1,144,142, 77,123,109, 40, 32,
124,156,167,121,176,138, 47,194,216,185, 96,112,222,180, 58,159,123,227,255, 31,
 69, 32, 81, 52,241, 54,157, 12, 67,228, 72, 56,196,174, 83, 32,210,104, 94,188,
 92, 56, 14,  1, 81, 20, 18, 37,124,170,170, 11,132, 20, 85,100,184, 24,105,170,
184,128,195,128, 59, 40, 29, 66, 34, 90,100, 56,157,183,137, 29,206,165,170, 94,
194, 45, 11, 18, 72, 55,220,247,245,110,185, 47, 54,175,218,  2,144,192, 34,121,
101,130, 81, 84,201,141, 43, 22, 11,199,252, 96,111,143,153,173,198,176,190,197,
 79,216,112, 56,138, 90,107,162, 28,213, 26,149, 59,244, 73,223,206,126,245,213,
 93,159,183, 44, 31,207,168,114,108, 10, 68, 47,242,158,198,123, 79,203,188,232,
234, 44, 47,109,163,116,102, 28,161,  8,242,109, 92,231, 29,200,214,227,249,  9,
114, 56, 56,  9, 60, 31,112,210, 36, 15,252,147,254, 94,231, 57,166, 12,129, 49,
168,161,169, 82,102,102, 68, 68,146, 36,201,178,  6,113, 20, 98, 16,179,208, 49,
221,  1,130,120, 64, 73,145,  8,  4,100,132, 16,196,136, 33, 66, 66,  8, 33,132,
200,136, 68, 20,140, 72,148,220,213,  5,142, 57, 59,109, 80, 86, 67, 59,251, 94,
254, 82,194, 77,105,125, 85,  5, 17,253,251, 79,107, 74,204, 50, 82, 83, 91,162,
 78,222,151,136, 13, 10,114,  3,118,191,221,213,218,194,185,121,191,234, 37,232,
182,106,186, 25,223,137,118, 32,250, 74, 27,205, 19, 67,108, 60,203,157,116, 92,
 82,187, 11, 65,109, 81,108, 99, 72,184, 66, 21,246, 41, 18,196,200, 12,  3, 91,
218,170,131,100,208,221,240,151, 10,233,145, 40, 96,  9,162, 77, 54,150,167,237,
150,224,234,236, 39,247,238, 71, 29,110,163,162,154,230,200,  9, 90,249,243, 40,
 48, 83,211,190,169, 29,172,234,131,252,136, 68, 54,  3,137,149, 88,229, 16, 17,
101, 69,162, 98, 66,125, 83,235,  0,  4, 38, 56, 21,229,237,133,168,249,106,179,
 27,219,203,140,163,185,217, 33,102, 37,163,100,181,182,222, 45,128,192,178,248,
225,159, 83,216,102, 49,220,178, 24,145, 44,134,178,132, 75,154,174,127,129,205,
120, 44,147,155,110,156,171, 76, 44,207, 98,157,196,  5,252,209, 48,  6,120,143,
239,221, 99,119,247, 98,135, 91, 70, 33,151, 75, 64,146, 69, 68,109, 54,111,160,
159, 64, 90,157, 70,240,139, 44, 73,175, 91,  0, 11,165, 55,141, 23,233,236, 23,
 67, 92,  2, 87,247,  6,185,108, 58,210,133, 83,240,205,190, 28,111, 29,255, 10,
174,103,216, 29,128,190,166, 72,169,197, 78,100, 43,114,200, 31, 56,126, 49,  1,
162, 77,187, 24,214,213,172,176,131,  8,179,231,219,119, 68, 78,204,  2,157,206,
187,221, 43, 43,209, 62, 37,144,150,176, 20,214,198,139,138,158,163,193, 50,233,
210, 46,195,  2, 38,233,240,247, 52,179,225,239,212, 34,144,208, 12, 64,208, 80,
171, 71,207, 95, 41,155, 75, 98,162, 26,144,145, 28,160,154,187, 22,200,228,120,
218, 42,253, 73,  2, 84,120, 62,184,  3,252,196,232,105, 16,240,156,  2,145,247,
 15, 86,  1,139,133, 84,107,  3,102, 16,163, 98,114,  0,140,182,158,215,224,247,
 86,226, 67, 66,178,187, 85,157,199,241,196,105,196, 69,132,107,243,158,  1, 70,
 11,180, 40,162, 69, 30,166, 12,245,193,208,  0, 86,240,158, 39,157,207,190,137,
175, 20, 98,  1, 93,158, 43,120,149, 30,111,174, 78,245,  1, 50,217, 99,167,187,
167, 58,214,133, 31,174, 39,253,232, 74,150, 88,157, 70,178, 43,180,127, 82, 47,
121,160,  3, 99,144, 52,245,154, 84,168, 49,235, 66,113,132,254, 47, 34,167,253,
220, 89,251,233, 51,245,218, 23,113,234,128, 52,180, 17,196, 76, 76, 19,128,195,
 43,187,122,248,  4,110, 59, 81,239, 67,247,140,212, 82,222, 36,222,117, 98,141,
 43,142, 21, 65,115,163,109,225,136, 41,110,127, 42,254, 82,152, 22,208,254, 57,
128, 37,192, 52,248, 46,160, 85,169,200, 35, 50, 76, 49,167, 64, 89,126,109,179,
161,180,159,154,202, 33,193,122, 35, 90, 73,128,121, 20, 51,241,113,  3,158,155,
127,173,220,  6, 33,178,  5,110,130,136, 46, 26,172, 77, 65, 68, 91,178, 98,140,
208, 68,177,184,137, 50,178,178,202, 76,196,144,229,218, 31, 96,211,125, 87, 53,
105,141,  1,
} ;

// ../Source/assign/template/GB_bitmap_assign_5_whole_template.c:
uint8_t GB_JITpackage_73 [1483] = {
 40,181, 47,253, 96,124, 36, 13, 46,  0,118,182,160, 40,208,178, 88,  7, 72, 27,
 66,223,162, 59,126,236, 64, 14, 55,207,108,159, 18,226,137, 53,167,222,152,114,
168,174,109,115,181, 36,139, 22,185,154,  1, 47,156, 47,152,  0,138,  0,156,  0,
246,240, 87, 54,181,158, 49,183, 49,217,235, 54,159,227,218, 16,  5, 64,183,190,
 32, 14,255, 93, 97,242,133,  4, 24, 69,151, 10,  1,165, 51, 75,110,239,212,237,
137,205, 92,251,218, 80, 26,215,182, 38,135, 82,193, 32, 81,185,186,227, 54,110,
207,113,206, 52,166,231,148,190, 79,  5,  4, 23,  2,138,193,192,133,224,146, 37,
249,132,103,135,100,120,229,189,203,178,213,230,231, 83,245, 56,152,108,147, 87,
 67, 53,190,114,171, 58, 79,174,138, 52,206,178,228,179, 60, 67,159, 58,183,245,
211,225,169,206,146,110, 90,231,216,212,102,161, 88, 16,171,198,196, 88,198, 77,
106,121,130, 34, 70,115,139, 37,162, 88, 44,  1,180,175, 55,232,149,234,219,161,
195,202,101,179,220, 90,126,157,199,157, 12,113,159, 48,125,102,205, 44,132,209,
188,  3,253,106,122,213,218, 13,122,119,201,190, 20,203,236,141,101,246,249, 43,
 87,231,218, 90, 83,237, 93,222,180,126,149,175,157,229, 79,120, 30,219, 72,213,
206,108,201,183, 38,177,228,212, 85, 39,199,149, 84, 90, 88,162,148,155,240,167,
219, 91,151, 73,238, 49,111,150,218,203,181,113,223,173, 45, 25, 33,149, 45,140,
169,196,126,237,155,187,121,211,172, 21, 57,176,236,106,107,231, 20,236,219,217,
187,102,220,243,230,218,167, 84, 30, 11,208, 18,240,190, 56,106,213, 25,  9,233,
 98,230,243, 56, 19,147,198,180, 67, 16, 46, 89, 60, 35,252,244,  9,110,159, 60,
160,228, 48,218, 28,173,104, 33, 17, 97, 17,184,  7,188,128,116,185,  2,194, 51,
224,118,113, 16,188,194, 65,214,115, 60,200,117, 98, 92,130,155,228,193, 19, 65,
 17, 29, 54, 16,158, 58,132,102, 83, 85,239, 90, 40, 73,116, 34, 96,124,168, 94,
  7, 64,114,108,118,150,111,175,206,  4,132,207,243, 56, 15, 86,241, 69, 24, 63,
 25, 13,206,220, 86,231,115,107,252,255,163,  8, 36,138, 36, 94,231,179,193, 68,
 79, 68, 67,236, 58, 35, 17,135,243, 98, 38,227,105, 56,214, 87,229, 34,216,124,
 71,171,253,213,185,  3, 81, 20, 18, 33, 92,170,170, 12,132, 19, 85,196, 92,141,
228, 50,  5,124,186, 22, 59, 12,120,136,136, 21, 27,207,231,117,226,199,147,161,
 28,174,151,203,125,177,121,213,142, 92, 44, 15,169,125, 84,235,211,229, 19, 40,
 55,214, 90,139, 42,191,250,234,174, 92,150,235,124, 87,123, 93, 73,169,252, 43,
189, 81,185,187,103, 91, 59,251, 60,186, 28,155,145,247,222,123,151,222, 54,189,
247,107,127,133, 47, 80,224,100,130,169,236,168, 25,225,  3,239,202,110, 50,189,
141, 41,223,195,243,240,125, 59, 11, 73, 79,114, 14,103,162, 33, 86,155,231, 33,
181,136,179, 92, 63,225,174,214,230,231,238,139,  5, 88,149,129, 91,168,225,161,
 65,104, 70, 68, 68, 36, 73, 82, 40, 52,  6,113, 20, 66,144,146, 16, 42, 70, 15,
162,104, 48, 16,129,  8,  5,145,  8, 50,132, 24,  1, 17, 16,  2,133, 19,  1, 19,
 16, 34, 16,  9,144,  4,104,219,196,  8,236,164, 87,229,103,155,198,227, 20, 42,
 73, 76,250,125, 34,243, 62, 84,233,  0,185, 64, 89,176,173,171,245,207, 92,128,
253, 11, 86, 26,125,132, 29,155,131, 49,200,153, 85,231,146,120,248,134,157,117,
  1, 77, 33,112,211,218,193,135, 14,134,103, 84,255, 97,134,162, 61, 37,213, 21,
172,216,133,202, 72,188,253,175, 89,252,211,139,159,211, 52, 88,  1,255, 45, 13,
164,222, 10,252, 81,215,205, 68,175,175,158,116,221, 35, 37,185, 41, 72,218,106,
 63,155, 59,147,202,126,109,154,143, 68,170,253,201,134,192,212,201,208, 45,172,
236,214,199, 90, 10,112, 90, 13, 68,241, 69,230,168,166, 91,111,159,122, 31,111,
236,245,118,196,210,201,148,148, 84, 51,202,107, 63,152,155,195,223,146,216, 90,
106,199,190,112,  5, 76, 63,136, 12, 48,141,124,187,200, 91,180,  7,226,163, 99,
199,117,140, 25, 42, 49,134,149, 97, 29, 33,147,184, 32,236, 79, 17, 32,228,137,
118, 54,216,208, 92, 29,216,222,184,244, 50,239,245,219,230, 60,125,109, 40,175,
 31,228,125,150,153,108,105, 96,193, 71,  9,148,231, 36,171,  1,129,150, 92,220,
 80,101, 81, 79, 31,155,146,165, 84,178, 10,202, 46,239,202, 42, 87,153, 76, 41,
145,249,120,220,160, 49,200, 98, 46,188,  5,131, 84,177,233, 49,172,193, 48, 91,
 43,162, 56, 39, 18,236,238,210, 79, 34,160,137,110,234,109,174,243, 65,144,144,
244,  7,206,173,  3,111, 49,143,152,120, 61, 99,243,111,237,172, 73,223,183,176,
177,182,102,249,234, 41,114,224,128, 55,229,234,  0, 85, 11, 42,143,119, 32,  5,
223,121,  8, 33,133,133,184, 67,116,188, 34,162, 37, 52,154, 42,186,114, 28, 76,
199,186,204, 74,  8,163, 38,204, 63,170,207, 62,116,241,244, 40, 25, 99,140,194,
223, 72,102,151, 68,185,196, 12,170,193,224,222,105,108,203,192, 66,129, 60,194,
 41, 46,204,204,140, 26,140, 23,118,241,143,162,184,215, 68, 17, 84,226, 57,193,
158,225,113, 71,181, 71,180,223,134,114, 10, 51,183, 68,199,106,144,128,229, 41,
 94, 40,196, 90, 40, 97, 65,  8,220,164,138,126,157,248,163,123,136,136,177, 57,
 85, 52, 18,251,125, 99, 66, 19,183, 67,129, 59, 43,155, 62,230, 12,  8,126,184,
 22,136,108, 67,192,  0,165, 34, 18,132, 23, 62,193,208, 59,174,141, 34,115,119,
155, 58,202,130,  1,249,135,137,142,102,102,159, 18,157,131, 52,106, 53,183,130,
212,203,118,  7, 12,120, 70, 86, 70,126,110,  3,124,244, 88,192,144,190, 60,192,
 13,  0, 65, 91,120,202,143, 97,153,212, 95,155,227, 87, 23,243,104,246,221,246,
 42,136,101,219, 85,119, 93, 84,112,226, 77,188, 80,  8,130,212,229,228,103,190,
123,210, 20, 31, 73,100, 18,212,249,170, 70, 52,190,116,251,149,221, 98, 92,213,
143, 17,220,129, 39,202,214,108, 44, 88, 52,126,123, 27,154,  6, 21,252,210, 43,
 88, 14, 24, 36, 41,111,226, 75,148,121, 45,190, 91,  9, 29,217, 41,246,154, 91,
 98,140, 15,118,159,238, 11,211, 12,217,144,106,132,132,227, 25,136, 74,131,166,
 38, 15, 31,128,144,178,166,160,  6, 46,131,125, 72,215,137,250,155, 24,161,163,
 75,172,170,224, 11,150, 19, 84,111,212,154,177,210, 57,116,150,227,142,153,196,
 10,228,244,187, 68,211,197,209,  5,158,100,  6, 42,  5,213, 16,147,179, 38, 93,
205,176,141,115,215,125, 59,117, 56,151,210,162, 24,165,242,165, 12, 35,213, 67,
 57,173, 81, 15,172, 38,227, 11,248, 51,211,168, 37,157,245,202,182,159, 82, 83,
 58,178,154,
} ;

// ../Source/assign/template/GB_bitmap_assign_6_template.c:
uint8_t GB_JITpackage_74 [1437] = {
 40,181, 47,253, 96,  3, 22,157, 44,  0,134,186,173, 40,176, 84, 85, 29,212, 26,
129,215, 17, 10, 24,  8, 42, 38,205,217, 19,103,201,224,  1,156, 46,  3, 71, 46,
 28,168, 26,144,200,173,210, 31,244, 31,108, 79,233,102,164,  0,154,  0,160,  0,
207, 84, 99,116, 78, 89,223, 78, 58,149, 49,140, 55,250,249,237,222,223,205, 30,
215, 97, 19,  4,211,182,157,221,156,146, 16,  2,  0,108, 94,223,235,195, 13, 12,
143,191,124,146,128,149,212,192, 32,163,200, 66, 49,152,180,134, 81, 47,158,186,
 93, 63, 53,219,206,170, 73, 99,219, 88,213, 76, 50, 30, 42, 40, 89,135,220,198,
221, 57,206,154, 71,237,124,219,226,225,129,129,197, 96,146, 80, 96, 49,248,132,
 73,135,184,134,208,135, 83,226, 67, 90,238,184,234, 57,180,162,198, 65,243,232,
205, 80,141, 47,245,172,206,245,179, 34,238,195, 48,186,121,103, 15, 47, 79,117,
166,155,199,117,158,  8,211,122, 84,140,233,244, 40,151,235, 53, 29, 50,175, 84,
162, 73,165, 18,146, 50,129,186,173,175,119,214, 97,217,187,177,148,209,206,216,
214, 99,152,169,150,111,171,159, 34,129,241,165, 30,125, 15,229, 63,221,143, 47,
237, 13,211,114,200,210, 11,164,200, 84,150, 21,111,247,129,183, 67, 26,212, 69,
252,148, 41,107,252,217, 79,195,170,  6,146, 78,243,119, 29,198,206, 94,203, 21,
244,172,211,114,115, 90,190,135,173,155,231,144,121,232,122,214, 91,102,169,214,
152, 98,199, 85,243,252, 92,111,220, 67,217,227,250,150,222,182,150, 15, 51, 75,
143,235, 55,255, 84, 91,135,129,186,123, 72,101,182,130, 92,186, 81, 12, 79,219,
246, 65,124,120,219, 11,105,210, 69,234,205,148,139,217, 54,238,235,  5,151, 95,
216,243, 84,200,182,114,124,146,158, 52,209,225, 96, 76,137, 74,126,212, 55,222,
186,196,242,203,241, 70, 67, 22, 62, 77,124,181,108, 15, 69, 40, 55, 98,177, 67,
203,225, 37, 37,174,185, 14,233, 46,250,238,198, 95,  8,109,217,246,189,223,165,
238,246,200,187,252,137,130,148,116,201,220,248,212, 47,151, 63, 80, 84, 19,147,
100,146, 26, 83,205,235, 68, 77,148,214,140, 83, 78, 15, 38,131,243,231,217,250,
220, 30,255,255, 40, 34,137,162,138,184,241, 84, 14,179,195,129,152,109,171, 64,
164,209,196,137,193,116, 32,254,233,204,126,  2,161,182,221, 51,166,189, 61, 83,
140, 43, 23,111,247,169,207, 58,247,118,221,118,189,167,250, 54,232,  1, 81, 84,
 18, 45,124,178, 44,140,148, 22,214,116,184, 25,201,  2,  3, 58, 43,191,209,128,
 67, 41,125,130, 51, 51,170,142, 39,110,166,167,131,105,152,200,188,125,184,239,
237,253,114,223, 17, 75,165, 91,154,120, 65, 49, 99,140,177, 35,198,159,100,138,
 94, 21,163,130,139,102,222,151,117,190,141,109,253, 36, 63,160,172,146,188,124,
242, 36, 17,249, 40, 61,126, 84,106,107,180, 16, 20,116,184, 78,121,248, 67, 17,
 41, 93,206, 46, 79,144,219,129,176,169, 81,193,169, 12, 92, 68,126,160, 50,193,
140, 74, 66,164,250,182,201, 83,175,216,112,228,156,176,226,  6,160, 36,  0,163,
200, 74,192, 59,251, 54,204, 86,140, 21, 37,135,162,164,224, 23,233,151, 73, 94,
120,135,244, 54,126,201,  7,129, 61,168,209, 41, 82, 51, 50, 34,146, 36, 73,166,
 53, 97, 20, 98,148,131,208, 65,236,  1,194,168, 60,  8,129, 28,135, 56,226,140,
 49, 66,194,136, 64, 72, 32, 18,136,148,136, 36,  9, 90,232,  1, 92,  5,186,198,
181,154,223,206,172,172,228, 41,253, 73,215,201,  4,204,103, 87, 79,  9, 82,175,
 52, 62,  2,218,200,184,235,122, 17, 85, 58, 57, 61,232, 83, 47, 33,106, 30,  1,
 92,154,102, 26,114,100,134,198, 89, 57, 65,194, 92,191,139, 57,249, 80, 82,190,
135, 15,111, 54,168,151, 45,120,  1,205, 51,197, 51,175, 56,244, 28, 74,245,249,
 59,247,  3,186,245,168,137,  9, 23,  9, 23,153,133,150,108, 94,232, 61, 18, 47,
199,228, 66,230, 30,112, 33,173, 37,135,  6, 74,186, 73,109,159,229,186,246, 17,
207, 59,109,113, 59,212,116,156, 79,103,133,182,185,133, 38, 67, 93, 56,247, 30,
135, 85,190,171,245,164,120,180, 32,228,197, 92, 74, 72,108,241,196,  0,184, 45,
160, 60, 28,125,120,153, 51,102,211, 50,208,254,112,143,210,204,201, 81, 26,110,
254,131, 73,  6,242, 88,156, 30,231, 77, 82, 49, 54,145,128,  2,102,237, 21,187,
 11,109,238,135,197,248, 51, 18, 49,220,165,103,251, 74,165, 94, 49,128,158, 67,
182,196, 50,167,126,184,130,245,  6,214,152, 22,188,181, 44,162, 57,116,227, 13,
 21,252, 75,167, 20,113,197,197, 16,224, 46,229,173, 74, 17,104, 50,222,144,123,
211, 14, 33,186, 70, 16, 95,170,235,241, 30,220,114, 75,153,  0, 61, 30,116, 90,
160,154,  3,150, 76, 44,152,183,229, 26,216, 63,229, 92,116, 60,193, 19,109, 70,
245, 99, 63,239,124,118, 23,135,247,239, 98,142,231, 25,102,219,206, 10, 20,169,
217, 68,146,190, 48, 36, 29, 34, 67,207,134,103,179,  0,204,247,208, 78,217,106,
 58,155,204,190,195, 94, 96,239,222,114, 98,111, 94,  8, 20, 29, 65, 74, 82,201,
208,118, 92,153,245,220,199,242, 39, 28,243,221,  8,122,227,  8,175,246,105, 20,
 69,244,152,137,  5,213,  7,114,241, 64, 46, 33,117,138,181,125,208,175,255, 48,
 18, 75,134,199,198,151,  7, 71, 17,128,242, 19,240,151,  4, 91, 45,109,178,  1,
232,154, 47,156,192, 92, 76,251, 46,186,193,107,101,133,205,189, 89,135,146,151,
 73,234,110,127,222,185,162, 83,212, 17, 46,182, 23, 52, 40,235,116,  5,241,132,
136, 46,187, 17,158, 30,210,161,110,182, 61,169,192,111,172,228, 48,184,145, 71,
130, 44,203, 62,152, 22,133,219,177,184,176,118, 37,  7, 30,162, 38,154,170, 44,
225, 91,  5,238, 73, 11, 19,127,227,182,221,113,239,128,140, 90,137,211, 30, 46,
 11, 49,218,227, 28, 57, 45, 33,204,127,254,178, 10,154, 80, 76,102,204, 81,121,
241,177, 33, 27,198, 30,213,185,171,155,254,174,246, 67,222,127,  0,137,119,  5,
 48,  1, 14,201,219,212,165,221,237,102, 69,190, 27,189, 76,117,163, 59,108,124,
137,125, 96,111,129, 16, 28, 12,  0,124,  5,242, 50, 96,154, 69,210,108, 78,169,
122, 90,132,202,154,220, 74,166,132,213,131,112,196,199, 15, 82, 78, 95, 15, 32,
147,164,200, 59,139, 65,  2,197,153,217,140,129, 45, 72,148,228, 72, 37, 91,235,
 48, 81, 20,219,244, 94,138,119,232, 39, 38, 51,208, 12,207,142, 41,148,113, 37,
170,204, 52,234, 80,210,188,241,  7, 37, 19,218, 87,169,162, 87, 60,
} ;

// ../Source/assign/template/GB_bitmap_assign_6b_whole_template.c:
uint8_t GB_JITpackage_75 [553] = {
 40,181, 47,253, 96,175,  5,253, 16,  0,214, 29, 95, 33,208, 90, 61, 64, 29,218,
 45,212,170,154, 88, 44, 81, 16,248, 64, 65,200, 44,148,194,237, 53,193, 41,255,
 50, 74, 61,240,  2,165,  4, 86,  0, 85,  0, 84,  0, 37,237,253, 56,214,167,  7,
  3,103,208, 18,  5,206,240,  2, 48,123,202,117, 10, 63,158, 80,159, 37,118, 20,
169, 53, 79,191,218, 57,196, 18,155, 18, 69,230, 38, 46,191,220,245,249, 97,228,
  9,130,216,242,168,253,244,237, 43,114,199, 99, 73,230,126,243,136, 18, 85,119,
132,184,187,164, 57,199,183,196,100,215,163,235,144,252,182, 97,218,182,  5,140,
183, 94,237,170,253,110,189,246,106, 32,146,127,140,247,179,220,250,123, 46,253,
255, 63,134,189, 11,195, 50,213,162,153, 56,174,135,137,220,188,117,  0,235,186,
122, 33, 16, 47,242,164, 28,238, 51,128,113,  4,131,150, 69, 16,151,245, 21,102,
214, 36,221,119, 14, 39, 90,230, 59,131,186,211, 60,143, 12, 33,204, 41, 51,243,
236, 61,239, 98,217,219,139,234,215,164,241,253,100, 48,118, 27,188,168,138,108,
  9,250,149,253,193,230, 10,189,160,150,212,150, 89,197,195,116, 46,101, 82,185,
103, 60, 31,113,106,131,139, 23, 92, 30,226,108,138,125, 63, 93, 97,178,181,193,
167,220,211,145,205,190,103, 78,102,210,204, 37, 75,220,120,253,112,227,231,250,
237,103, 51,139,170,167,245,  3, 24,246,194, 22, 47,248, 62,136,181,155,239, 58,
 76, 73,198, 81,192,143,120,107, 18,224,169,205,190,130,185,158,137,167,169,150,
171,241, 32,223, 87,251,120,242,109,158, 61,155, 13,205,182, 54,206,254,235, 42,
231,114, 43,  0, 36,212, 13,240, 57, 60, 71,112,235,215,226, 11, 35,107,233,201,
 68,169, 64,138,226,250, 86, 90, 43,181, 37, 93,217, 59, 32, 48,132, 32, 52,117,
197,  3,187, 17, 40, 65,118,153,  1,216,225,118,182,126, 21, 28, 87,222, 55, 66,
216,251,100, 19,145,128, 50, 96,118,130,  6, 32,  1, 64,233,201, 24, 61, 73,186,
 79, 76, 56,233, 78,156,157,236,151, 60,249, 19, 76,216,155, 25,188, 94, 12,196,
 69,  2,  0, 56,  7, 85,  4,201, 53,176,  3,122,173, 34, 64, 69,192,203,224,110,
 56,189, 23,100,129,161, 23, 76, 52, 90, 66,135, 98, 11,  3, 17,240,206,207, 41,
 45,214,119,178,202, 93,185,107, 90, 79,128,119, 86,120,180,227, 77, 34,167,232,
134,217, 25,202, 31, 14, 92,184, 81,  7, 68,150,192, 12,154,155,103, 38,219, 42,
172,214, 41,142, 74, 84, 20, 25, 27,138,162,192, 13,
} ;

// ../Source/assign/template/GB_bitmap_assign_7_template.c:
uint8_t GB_JITpackage_76 [1386] = {
 40,181, 47,253, 96,104, 26,  5, 43,  0,230,117,162, 40,208,178, 88,  7,228,107,
182,120,123,210, 96,100,202,105,127, 68,166,156,183,196, 67,  9,217,180,  8,203,
 74, 28,199, 61,215,109, 49, 95,120,193,209, 50,170, 23,151,  0,146,  0,157,  0,
191,219, 79,101,219,184, 47,103,189,130,149,235, 75,125, 58,252,119,  5,201,167,
  7,106, 35, 45, 88,  0,  9, 48,138, 44, 20,204,164,179, 41,185,247,234, 54,  5,
209,108, 27,219, 76, 26,219,158,148, 51,185,104,152,160, 96,253,113, 27,119,231,
 56,103, 28,180,243, 90,223,169,  2,140,  5, 51, 49,184, 88, 48,159,166,116, 10,
211, 15,217,112,202,123, 40,203,155, 70, 61,167,174,199, 97,200, 56,121, 53,213,
213,153,118, 87,164,117,115,202,103,153,130,156,186,205,133,178, 74,227, 43, 57,
124, 11,224,212,225,171,206,178,114, 90,231,104, 16, 45,  7,197, 88, 70, 78,106,
153,126, 34,131,230,149, 74, 52,169, 84,  2,152, 13,200,101,252,  3,191,101, 75,
111,221,  3, 75,237,157,229,223,206,153,  2,194,103,197, 12,220,112,174,206,227,
 60,120,197, 23, 97,244,100, 52, 56,119,156,165,207,205,241,255,143, 34,145, 40,
154,120,150,103,195, 16, 59, 18, 14,177, 45, 21,136, 56,156, 23, 51,153,142,195,
 65,141,217, 78, 32,138, 40,152, 30, 68, 31,170,118, 59,214,185,107, 99,239,207,
173,156,199, 77,111,182,253,170,111,131, 28, 30,180,169,219,  4,217,238,169, 87,
152,165, 30, 87, 86, 57, 49, 37, 61,132,222, 44,181, 87,245,148,177,113,149, 85,
158,184,187,155, 57,109,155,209,  3,203,169,214, 14,148, 55, 43,  5,209, 72, 40,
102, 60,143, 67,113,105, 92,123,  4,225, 18,  9,174,242,195,102,132, 79, 27,166,
 17,158, 58,  5,185, 83, 33, 80, 58,140, 91,142, 30,119,  3,153, 17, 99, 66,  2,
 86,  6,254, 16,248,129,202,244,153,  8, 10,255,204,231,120,144, 45,189,136,198,
167,190, 27,245,112,177,121,  8,217,188, 86, 89, 93,100,138,208,108,174,235, 49,
104,164,131,168, 70, 16,218,176, 11,230,130, 97,155, 54, 79, 41,188,131,106,127,
101,185,194, 95, 97, 75,101,182,219, 60,200,102,  3, 38,197,170,  4,188,177,174,
 78, 75, 47,206,171,136,128, 81, 34, 98,130,156,  4,209,145,176,136, 16,215,179,
 44,253,212, 65, 81,201,122, 40,155,178,127, 55,208,  3, 81, 52, 18, 33,124,186,
174, 12,132, 20, 87,100,184, 26,105,178, 80,  1,212,225,171,180, 20, 20,112, 10,
 74,135,144,136, 23,155,142,231, 89,209,211,201, 92,215, 67,184,194,194,  4,230,
218,225,190,183,183,203,125,123, 74, 14,191,251,130, 44, 11,129,136,101, 50,193,
 52,203,231,186, 61,  8, 44, 95,152, 28,  3,208, 88,102, 92,103,249, 93,179, 99,
 86, 30, 94,219, 46,232,214,175,236, 58,223,127,201,123, 27,239,253,127,220,230,
 17,112, 88,154, 97, 46, 88,103,137,113, 93,173, 52, 99,201, 37,223,198,150, 98,
250,  9,118, 80,144, 74,240,242,  9,129, 19, 39,125,224,147,254,110,233, 59,168,
124,  1,129, 47,160,193, 45, 66, 51, 35, 50, 82,144,130,130, 36,173,  1,113, 16,
 98, 20,131,206, 57,141,  7, 89, 17, 88, 50,  8, 41, 65,250,167,198, 95,109,112,
199, 32,142, 27, 56,186,151, 14,118,237,249,253, 70,247,232, 90, 78,216, 72, 54,
192,116,109,205, 84, 86,165,165, 48, 68, 36, 79,209,103, 40, 85,226, 61,157,177,
133,204,108,107,127,130, 80,141, 99, 64,157,233,  5,177,213,145, 73,  2,155,  7,
 37,205, 99, 64,254,194, 36, 63,164,160,136,191, 56, 68,212,137, 33,254, 54, 94,
 16, 66, 61,  9,162,238,  6,136, 67, 25,140,  8,151,119,203,113,235, 38, 69,160,
154,148,131,200,176, 62,108, 79,108,  8,133,110,166,105, 73,118,187,160,200, 90,
 63,181,142, 84,163,132,  4, 60,200,250,169,195,154,151,163,230, 28,201, 64,174,
167, 84,197, 52,136,112, 56,108,  2,205,177,196,167,194, 49, 96,115, 74,245,156,
115, 68, 58,130, 96,160,113,232,153,233,171,  5, 45,224, 28,116, 57, 93,157,  0,
 24,230,137, 74, 67,213, 65,146,227,140, 56,209,224, 92,  9,134,117,  7, 59, 37,
192, 53, 35,189,160, 47, 11,117,221,  6,221,162,143,143, 81,200, 20,130, 50,188,
197, 15,207, 76, 15, 87,243,118, 27, 10,246, 48,252,  4, 87, 96, 55,157, 57, 61,
 85, 79, 54,102, 55,165,169,130,174,188, 59, 27, 18,126, 46,204, 66, 52,121,  7,
 96,208,137,237, 38,234,142,142,131,189,180,118,242, 32,130,102, 98,227,164,165,
150,221, 51,222,129,165, 77, 72, 86, 96, 84,180,249,135, 27,  0, 72,179, 46,213,
  5,180,137,168, 71,167,173,184,226,114,  7,178, 69,196,169,167,232,209,156,190,
163,214,102,196, 77, 45,  1, 96,112, 39,222, 42,174,152,148, 33,  6,214, 34,251,
 30, 69,207,142,231, 49, 22, 95,  8,164, 93,  2,137, 48,  4,209,142, 38, 57,116,
 88,212,165,212,130,243, 11,129,138,  2, 92,114, 53,103,233,173,152, 53,203, 22,
165, 14,128,227, 36,148,125,158, 41,105,221,187, 43, 49,252, 97,  8,137,235,237,
 37,151, 25,161, 39,151,106, 76,238,142,160, 24,138,205,182,199,207,155,150,121,
 66, 31,112, 87,166, 64,  6, 53, 65,155,198,105, 32, 10,153, 91, 64,223,181,105,
219,225,201,220, 50, 76,212, 32, 28,168,117,241,130,190,146,173,128, 36, 18,131,
214, 12, 56, 14, 48,175, 89,212,194,141,130,114,122, 64,  4,210,159,174, 50,  8,
 73,138,174, 12,225,  2,140,110, 46, 56,231,197,141,109, 67, 52,234,  3,115,172,
 56,  5,230, 29,101, 76,222, 93, 41, 85,210,153,239, 96,128, 22,163, 45, 24,125,
200,180, 97, 75,131,144, 41,188,114,188,113,184,105, 38,144, 13,221,177, 43,204,
 74,172,224,205, 35, 20,220, 77,158, 32,168,119,142, 78,185,177, 10,231,245,137,
131,235, 32,253, 85,159, 91,206, 79,234, 20,199,242,184, 23,122,147, 87,140, 20,
155, 11,169, 74, 16, 79,158, 32,187,239, 60, 24,  6,124,101, 29, 83,178,173, 11,
 66,196,174,195, 64, 24,136,168,101,163, 12,185, 22,  4, 22,178,200,  7, 97,142,
 60,147,118,120,152, 73, 61,247,196, 51,134,208, 21,224, 74,171,198,152,155, 21,
204,107,166,145, 40,141,  4, 98,236, 30, 78,210, 88,  6,228,200,204,179, 25, 32,
192, 53,163,195,134,137, 65,150, 81,131, 73, 90,181, 47, 54, 15, 52, 93, 83,232,
223, 63,166, 20,  5,156,
} ;

// ../Source/assign/template/GB_bitmap_assign_7_whole_template.c:
uint8_t GB_JITpackage_77 [1699] = {
 40,181, 47,253, 96, 89, 62,205, 52,  0, 54, 55,166, 40,176,146, 85, 29,170,172,
172,134, 63, 79, 29,152,  9,184,111,163,242,174,246,208,216, 78, 23, 40,109,123,
 83,214,108, 68, 22, 18,165, 63,232, 63,216,158,210,205,154,  0,149,  0,159,  0,
185,179,211,111,247, 87,217, 54,238,235, 93,183,226,230,245,173, 62, 31, 62,188,
 66,228, 11, 23, 64, 66,148,164,202,196, 34,105,141, 78, 15,222,186, 93, 65, 53,
219,206, 52,146,198,182,105,221, 72, 42, 26, 38, 38, 89,115,220,198,205, 57,206,
154, 70,229,124,219,224, 43,  3, 75,197, 34, 57, 32,168, 88, 78,209,233, 21,174,
 28,179,225, 19,248,145,150, 59,174,118, 94, 97,112,195,160,121,243,102, 44,172,
115,253, 48,137,251, 40,157,215,114, 21,189,186,237,141, 52, 74,227, 59, 61,252,
 11,224,213,227,173,206,115,243,184,206,178,183, 78, 19,201,  3,105, 53, 42,198,
 83,122,147,203,245, 35, 25, 50,167, 80, 36,  9,133, 18,245,212, 70, 85,167,235,
 35,141,206,254,237, 64,183,100, 68,239,226,159,235,183,115,246,196,  8, 47,137,
137,154, 13,198,129, 27, 24, 49,  9,101,148, 29, 76,230,151,112,254, 60, 91,159,
 91,227,255, 47, 73, 31,146, 52,  1,175,142,134, 65,114, 36, 28,100,219, 42, 32,
109, 54, 80, 98, 48, 28,135,131, 58,179,159,128, 36, 77,112, 61,168,126,180,217,
238, 89,231,222, 58,123,127,110, 39, 61,110,219,183,250,182,232,241, 32, 13,101,
187,154,233,124,115, 19, 79,191,149,217, 26,186,115,155, 20, 87,211, 59,234,205,
147,131, 86,211, 41, 27,111,211,202, 20,247,119,179,199,117, 84,134,240,164,182,
237,  3,  5,191,179, 55, 90,177,140, 36,166,  3, 55,158,  8,193,229,161,217,247,
 19,137,224,109,114,216,124,185,156,234,112,149,241,213,171,232,189,234,136,211,
163,236,178, 12,221, 78, 68,165,197,132, 68,236,160, 12,252,  2,136, 31,160, 52,
158,148,154,174,209, 92, 69,248,  3,227, 84,244, 38,  8,142,  4,133,124,208,196,
  3,220,162, 34, 50, 26, 12,131, 12,153,233,160,202,117, 89,  1,129,133,160,187,
237,193,229,141, 74,255, 91,149, 43, 88,216,214,142, 94,212,217,203, 41,156,205,
190, 26,206, 86,195, 86, 90, 55, 44, 67, 45, 45, 18,243,108, 38, 36,  7,211,233,
 84,157,232,225,116, 48,  9,129,193,171,186, 94,197,233,242, 10,225,201,189,181,
124, 27,146, 20, 34, 93, 78, 97, 24, 38, 70, 15, 38, 25,110,102,170,  4,188,170,
226,183, 25,  0, 33, 33, 43, 52,156, 14,188,100,135,131,193, 48, 72,175,176, 32,
137,219,135,251,222,222, 47,247,109, 58, 61,252,238, 11, 10,137,208, 92,146,109,
155,242, 42, 80,144, 60,235,204, 78, 56,138, 16, 64,248,195,233, 32,133,127,232,
179, 68,160,160, 87, 65, 24,223,101,251,121,221,161, 81,164,130, 27,117, 66,234,
213,  7, 78,135,242,131,235,225,251,182, 38,250,102,227,113, 56,  8,200, 41, 56,
 29,211,192, 11,182,117,114,125, 27,111, 45, 73,  1,116, 18, 41,  1,239,236,219,
168,173, 33, 33, 86,222,190,121,137,  4,215,130, 74, 60,215, 93, 80,129,169,168,
 33, 38,161, 25, 17, 17, 73, 65, 65, 65, 65,210, 24,145, 16, 49,134, 57,  6, 29,
 59, 59,114, 72, 40, 77, 82, 12,197, 80, 12,194, 32,  8,130, 96,136,144, 16,  1,
 38, 56, 66, 73,  8, 97,130, 19, 93, 81, 58,224, 28,204, 80,211,182, 99,190,167,
 57,231,  0, 66, 99,171,112,108, 13,171, 14,116,110,157,198,112,181, 90,170,249,
234,247,  5,203, 64,142,168, 26,206,169, 52,219,239,134,241,139, 30,165,244,180,
108, 69, 37,101, 16,231, 55,174, 10,186, 79,  7,247,  3,131,219, 71,208,250, 86,
175,226, 88,238, 86,129,199,221,194,151,144, 84, 41,194,114,122,200,119, 62,112,
 18,143, 42,161,108, 21,248,233,  1, 42,166, 19, 75, 85, 39,179, 75,250,132,141,
140, 86, 63,216,  3,176,244, 89, 17,108,100,129,170,135,206, 38, 12, 88,103,105,
 48,183,225, 64,151, 45,241, 72,188,242, 77,160,190, 58,  6,157, 59,230,195,167,
156,180, 45,134,143, 44, 26, 46,191, 24, 35,  1,129,228, 98,214,235,228,245,109,
 80, 40,109,155, 54,146,176, 48, 44,116, 90, 33, 99, 97,246,232, 22, 19,211,141,
 75,250, 89, 55, 29,121, 23, 23,209, 24, 13,225,136, 63,206,235,113,145,198, 88,
 52, 16,102, 19,137, 21,206, 33,  3,134,138, 50, 16, 56,108,  2,130,185, 44,117,
 27,201, 36,182, 69, 25,171, 64, 10,251, 68, 22, 85, 27, 63,169,160,223, 83, 65,
 98, 44,216, 68,190,109,196, 26, 17,197, 17,245,232, 33, 82,220,203,193, 65,152,
 41, 84, 87,161, 72, 57,192,194,232,222, 34, 14,208,220, 83, 99,203,199,225,193,
162,154,124, 16,101,200, 21, 56,208,253,238,205,213,243,203,228,159,220,174, 49,
 63,177,183, 41, 70, 33,144,200,218,230, 33,123, 46,172,118,213,191,122,159,154,
 87,198,201, 14,114,114,120,156,147, 68,150,210, 25, 43,203,166, 73, 22,110, 58,
146,232,179, 68,175,238, 40, 28,207,113,252, 69,128,201,179,240, 24,  0,118, 48,
191, 13,158, 30,237, 79, 85,215,173,191,106,164, 52,180,131,209,218,154,251, 31,
172,158, 78,101, 58,247,221,252,161, 92,190,167,212,106, 36, 91,147, 95,  0, 75,
 29,127, 26,170,116, 57, 17,199,110,104, 88,147,164,170, 84,208,121, 51,132,102,
102, 17,148, 43,100, 37,  6,120,160,216, 37, 66,108, 79,135, 35,134, 58,  4,145,
169,214,158,156, 64,132,212, 56,231,127, 36,  1,165,243, 92, 35,210,166,200, 54,
  7,198,230,129,122, 89,218, 17,254,235,177,215,  4, 38, 12, 17,105,216,224, 44,
161,111, 92, 81,249,237,132, 77, 94, 74, 97, 37,172,  9,215,137,132,159, 36, 19,
220,174, 97,208,100,200, 98, 46, 92,250,  7, 82,225,102,246, 97,166, 49,172,207,
249,199, 23, 95,216, 21, 75, 83,108, 16, 62, 15, 89, 12, 83,168,217, 26, 39,228,
140,179,172,208,153,192,157,150,196,139,125, 70, 22,234,149, 50,114,110, 51,178,
 98,103,212,131, 47, 90,  3, 29,140,203,159,  4, 14,242,242,110,234, 93,236,248,
 13,201,172,123, 10,182, 79, 87, 38,131,211,152, 84,  7,216,235,192,217,149, 39,
167, 31,151,223,218,209,132,185,220, 67, 72,228, 76, 20,205, 40,164, 43,213,  7,
  3,178,121, 56, 60, 94,182,251,180,100,163,  1,163, 46, 13,157, 29,  8,144,133,
115, 13, 18, 98,201,100,155,204,255,194,  8, 58,150,245,174, 30,108,111,131,135,
250, 85,163,208, 38,239,187, 49, 92,224, 59,  0,227, 95,  0, 14, 81,213,193, 95,
104, 41,  3,117,223,239, 20,211, 41, 14, 80,185,181,  5, 42, 57,178,170,245, 82,
144,169,123,182,225,137,213,133, 38,215, 33,137, 74, 81,106,255, 43,142,239, 13,
164,199,164, 66,151, 62,227,202,201, 56, 78,212, 72,171,201, 85, 13,159,106,168,
133, 26,211, 56, 19,179,189,133, 49,226,123,172,121,196, 41,249, 87, 73,234, 65,
220, 23,150,141,203,221,198,232, 73, 26,178,191,189,240, 26, 10,143,210,152,185,
 39, 22,245,233,118,165, 47,233,187,109,114,136,127,197,122,246,167,216,175, 56,
166,  7,168, 43,138, 27,  4,168,236, 21,241,230,196,241, 17,179,174, 75,142,238,
 79,231,205, 49, 20, 62, 34, 57,144,225,207,205,211,213,169,194,233,123,113,110,
 56,121,147,137,183,233,212,136,239, 25,  7,  8,129,204,202, 44,133,118,227,200,
210, 74,162, 78,126, 38,167,146,119,155, 91, 96, 21,175,222,138,201, 21, 69, 70,
 88, 20, 77, 28,184, 18,145, 79,214, 20, 97,238, 40, 31,195,194,243, 20,227, 49,
 71,106, 28,111,234,149,188, 99,206,120,209,199, 80,180, 36,196, 72, 25, 73,102,
 83,202,241, 55, 32,129,128, 78,196, 93,224, 37,222,137, 99, 14, 35, 84, 98,168,
 73,253,193,244, 85,118,247, 80, 72,172,131,106, 84, 10,129,210,145,229,  4,
} ;

// ../Source/assign/template/GB_bitmap_assign_8_template.c:
uint8_t GB_JITpackage_78 [1508] = {
 40,181, 47,253, 96, 32, 31,213, 46,  0, 22,120,167, 39,176, 24,177, 14,204,167,
 81,241, 73,187, 10,  1,121,220,201, 39,126,  2,210,134,118,212,187,121,128,183,
133,174,116, 20,176,210, 31,244, 31,236,255,233,112,158,  0,149,  0,161,  0, 36,
 88, 78,148,118, 90,182, 85,250,181, 63,149,107,227,190,156,245, 13,164, 92, 95,
 10,212,225,191,115, 62, 81, 80,149,244, 96,  1, 56,192, 40,202, 92, 52,150, 14,
 97,146,123,223,220,158,218,204,181,179,202,210,184, 54, 54, 61,150,142,  8,140,
 75,214, 37,183,113,127,142,115, 72,100,126, 78,233, 59,165,160,201,104, 44, 11,
  7, 25,205, 39, 76, 58,133,103,137,140,248,229, 29, 37,148,237, 54, 51, 78, 93,
207,  3, 17,226,228,157,216, 92,157,103,119, 69, 91,135, 97,242,182,158,186,205,
161,132, 48,141,175,228,240, 45,128, 83,135,223,116,150,148,219, 58, 71,134, 88,
 69, 38,198, 50,114,114,203, 19, 20, 33, 38,142,193, 68, 22, 12, 38,215,156, 99,
240, 16,200,125, 28,212,161,124,155,235,188,245,219, 57, 91,177,  3, 43,207,245,
121,158,  7,175,248, 34,140, 25,157,  9,156, 59,174,206,231, 22,249,255, 71, 81,
 74, 20, 97, 60, 43,163,130,136,159, 11,137,216,117, 10, 68, 30,207,139,157,206,
 71,226, 90,103,181, 19,136,162, 11, 74, 87,251,140,101,211,103,121,145, 58, 49,
158,219,179, 42,143,231,223,181, 20,158,215,230,179,206, 77, 59,123,131, 94, 37,
118,220,243,230,218,223,244,109,147,195,107, 21,181,152,137,189,167,190,201,234,
 36,185,146, 74, 12, 83,210, 79,230,205,114,123,141,201,216,152,202, 77,198,112,
119, 55,115,155,197, 98, 31,153,242, 69, 43, 92, 55,  9,130, 37,131,103, 40,191,
 49,237, 21, 76,101, 73,205, 13,159, 44,158, 17,158, 58,  5,185, 83, 39, 80, 58,
140, 54, 71,146,107, 77,176,232,129,113,  1, 49,  5, 63,129, 47,152, 28, 26, 56,
  7, 97,127, 10,200,167,190,150,162,232,168, 40, 78,170, 83, 42, 55,185,246,246,
148,201, 98,162,186,174,  7, 49, 33, 93,155,239,  8, 89,207,  3,205,  1,138, 54,
 51,187,217,236,212,200,196, 78,113, 62, 50,183,127,147, 57,231,223,224, 58,101,
174, 22,187,137,173, 15,192, 46, 22, 38,224,157,117, 20,171,243,242,188, 13, 11,
 24, 47, 44, 38,200, 73, 21,159, 11,142, 88,113, 61,107,171,243,211,  8, 53, 37,
235, 33, 76,246,175,213,  2, 81,180, 18, 53,124,186,174, 14,132,119, 66,154, 50,
 84,192,225,169, 12, 56,  5,165, 87, 92,196,142,234,147,145,241,233, 52,156,243,
 96,129,153,118,184,239,235,237,114,223,198, 36,135,251,106, 22,193,  0,156, 42,
  8,191,217,171,221, 58,190,178, 41,118,139,233,251, 47,176,115, 61, 24,109,118,
155,255,190,118,187,173,255,165, 75, 44, 72,190, 27, 66, 35,194,162,170,136,154,
125,103, 19,231,206,174, 92, 69,229,  7,  9,117, 54,205,170, 12,189,132,247, 48,
  5, 15,121,239,113,213, 67, 16,169, 51,164,201, 58,203,140,235, 40,157, 25, 31,
 24, 24,204,  4,208, 73,190,141, 77, 38, 56, 66,193, 57,113, 18,  8, 62,233,239,
117,  6,129, 91,168,225, 37, 66, 67, 35, 34, 82,144, 20,164,144,214,129, 16, 49,
 74, 65,  7,161,227,  3,130, 88, 76,148,  3, 65,134,  1, 25,  1,113,132, 16,194,
136,128, 16,161, 17, 16, 35, 48, 18, 81, 32, 34, 53,109, 12,  6, 65,109, 41,214,
252, 95, 10, 25, 47,218,255, 91,247, 13,219, 69,202,168, 72, 26,153,203,239,212,
 49, 15,199, 10,174,160,173,115, 21, 62, 90,225, 34, 75,119,232,147,104,247,215,
223,143, 55,222,156,252,232, 76,186, 66,174, 98, 11,177, 19,  0,  3,156,193,138,
212, 85,172, 27,167, 89, 73,233,138,204, 46,116, 63,192,207,216,209,185,242,214,
 61,145,122,243,132, 59, 74,114,194,121,243,120, 94, 96,206,202,128,224,206,  3,
 94, 89, 91,196,180,209,172,144, 78,  8,160,218,123, 40,253,126,132, 64,111,128,
 46,187, 91,207, 40,191,192,199, 63,209,170, 49, 44,145,183,163, 34, 21,143, 95,
211, 96,215,141,211, 54,234,104,101,215,  7, 84, 98,125, 36,118,160,128,102,203,
  6, 85, 77, 34, 13,247,  0, 59,155,173, 56,194,181,144,112, 45,207,210,240,235,
 40,130,244,209,187,219,132, 48, 91,140,216,162,148, 76,246,200,123,210,167, 99,
 12,223, 92,246,244,109, 30,230,122, 32, 58,161, 26,244, 85,113, 43, 64,102,137,
144, 59,  0,163,140, 14, 12, 68,204,112,200, 11, 73,160,238, 25,185,232, 95,133,
218, 54, 53,250,170, 98,215, 34, 66, 86,244,159, 29,214, 18,113, 98,101,227,100,
 69,199,192,135,109,192,  6,116,  0, 30,185,224,  1,226, 60,158, 48, 48, 19, 80,
195,193,162,  4,106,202, 40,235,142,234,218, 16,154, 94,  1, 15,113,125,159,154,
183,121,137,190,229, 59,160, 92,148,214,187,234, 82, 77, 57, 27,114,  0,146,180,
 56, 86, 86,208, 67, 48,177,133,237, 19,154, 76,236,237, 14, 48,234,218,164,201,
217,  8,142, 30,169, 23, 70,151,171,141,198,200, 41,186,209,152,  8, 63,133, 13,
161,175, 65, 97,170,205, 77,131,196,165, 59, 57, 61, 52,161, 38,249, 58, 76,139,
154,114, 68,180,217,101,236,238, 58,103, 27, 58,193, 34,150,  4,113,214,226,229,
 37,  5,  5, 71,117,  5,162,156,179, 13,206, 92, 60, 33,159,164, 91,245, 86,232,
 77,112,242, 15,173, 33,251,227,199,220, 35,125, 62,187,178,187,250, 20,228, 48,
142,  5,156,  2,160,151, 65, 42,239,255, 90, 94,207,121,203,116,173, 13, 66,250,
127, 81, 73,205,229,137,117,  6, 82,248,  6, 94, 91,220,139, 18,131,197, 43, 98,
211, 91, 10,186,237,  3, 11,  5, 55,168, 96, 24,  2,250,141,170, 53,  6,248, 43,
 37,249,220, 79,104,177, 53,221, 49,202,111, 91,178, 45,174,165,160,101, 57,108,
163, 29,164, 13,150,122,224,212, 48,176,132,  6,122,174, 73,  3,168,149,254,  5,
 30, 78,155,204, 96,248,113,222,188,140,168, 93, 55,178,112,234, 44,163, 72,178,
105,101,109, 29, 87,170,241,146, 40, 24,191,153,198, 84,160, 14,247,127,144, 49,
255, 68,135, 90, 14,228, 95, 75,145,192, 78, 37, 82,222, 52, 36,132,172,251, 27,
 26,163, 55,147,113, 69,215,221,186, 48, 98,112,187, 95,215,210,234,157,252, 38,
 30, 42, 23, 38,187, 12,249,252,119,234,157, 18,206,  3,184, 82,224,  3,  1,179,
 23,136,252,175,195,100, 49,140,163, 63,234,243, 64,186, 81,143, 38,144,227, 12,
159,103,  9, 26, 73,101,141,186,202, 97,225,149,198,107, 55, 25,154,186,175,143,
198,113, 56, 48, 89,185, 66,148,221, 76,160,  1, 17, 56,203, 15,141,139,151,  0,
175,252,153,197,113,111, 22,  6,111,  8, 41,161, 36,119,208, 99,198,165,250,238,
133, 14,131,239,172, 98,240,156,103,126, 83,193, 46, 50,173, 88, 15,204,103,211,
117, 98,183,205,206,  2,203,196, 16, 67,168,193,244, 87, 26, 35,  3,209,133, 99,
 84,254,125, 23,165,239,192,  9,
} ;

// ../Source/assign/template/GB_bitmap_assign_8_whole_template.c:
uint8_t GB_JITpackage_79 [1658] = {
 40,181, 47,253, 96, 68, 64,133, 51,  0, 22,248,166, 40,192, 84,177, 14,232, 84,
 74,157,  7,175, 18, 16,148,211,250, 32,112, 34,184,206, 91,175,104,226,169,115,
 75,219,121, 92,164,131,  6, 76,147, 32, 32, 77,114, 16,157,  0,149,  0,158,  0,
120, 82,154, 38,  2,101,206, 78,191,220,255,178,109,220,183,179, 94, 69,173,235,
251, 62, 34,124,248,204, 25, 44,128,133, 40, 73,149,130,203,164, 51, 58, 59,248,
234,118,  5,213,108, 27,219, 76, 26,219,166,149, 51,193,112,168, 40,192,250,227,
 54,238,206,113,206, 58,106,231,154,  6,255, 16, 46,149,203, 36,193, 82,185,156,
162,211, 31,174, 31,211,225,  5,240, 33, 89,230,182,234,249,187, 32,167, 33,235,
230,133,168,174,206, 85,116, 73,155,136,210,121,206,254,221,238, 66, 50, 74,227,
 59, 59,124, 11,224,239,241, 85,231,169,117, 91,103,217, 26,151,141,164,130,180,
 29, 21,227, 41,187,185,229,250,145, 13, 16,167, 80,164,  9,133, 18,  4,231,136,
157,198, 63,157,229,115,217,214, 91,191,157,179, 37, 53,113,195,185, 58,144,  3,
227, 37,161,140,210,163,129,192, 89,212,217,250,220, 29,255,127, 73, 26,145,164,
 10,104,121, 54, 13,178, 67,241, 32,219, 86,  1,137,195,129, 82,163,233, 60, 28,
212,152, 21,  9, 72, 82, 65, 72, 91,238, 25,207,214,158,231, 59,108,197,184,110,
199,236, 60,174,135,151,123,184, 30, 84,143,117,110,173,177,247,231,118,210,227,
182,253,170,111,143, 30, 15,218, 80,150,171,153,206,247, 54,241,244, 87,152,173,
161, 59,181, 73,241,155, 14, 82,111,158, 27,108, 58,101, 99,109, 86,153,226, 22,
221,220,109, 28,149,161,161,217,247, 67, 64,128,181,249, 97, 51,  6,115,138,195,
 85,198,191,191,216,253,129,196,233, 81,114, 89,134, 46, 55,162, 50,163,130,  2,
228, 63,101,224, 22, 64,252,  0,165,241,164,212,244,140,230, 58,194, 35, 27,167,
 98, 55, 73,116, 40, 46,100,196, 38, 30,224, 21, 53,  1,177,185, 46, 56, 29, 84,
 55,204,192,114,177,112,183, 69,182, 63,143, 74,255, 87,149,103, 42,108,235,204,
150,163, 31,113,246,152, 83, 24,155,125, 51,156,109,135,173,180,106, 88,134, 90,
 90,127, 23,121, 89,112, 42,100, 71,227,241, 60, 79,180,232,120, 46, 41,113, 65,
235, 89,127,113,186,180, 66,120,110,182,158,242,120,117,178,158,209,217,191, 28,
232,151,103,  2,146, 84, 34, 97, 78, 93,151, 38, 70,139, 75, 54, 92,136,137,170,
  4,252,113,246,239,241,218,180, 21, 20, 32, 65, 33, 49, 54, 29, 15,180,164,167,
163,185, 46,248, 12,195, 36,106, 34,220,247,246,138,114,223,166,179,195,239,190,
160, 18,  3,203,228,  0,107, 88,121, 38,147, 33,248,  1,132, 63, 92,200,252, 67,
159,165,  2,  5,187,  7, 97,132,150,174, 59,244,160, 71,157,144,250,251,192,233,
 80,126,222,183,179,209, 57, 28,139,135,147,144,156,130,211,175, 13,196, 96, 91,
231,214,183,177,214,146, 20, 64, 11, 34, 37,224,141,137, 52,106,107, 73,201,171,
172,137,230,100,130,235, 13, 42,241, 27,119, 65,191,179, 53, 90,185,220,130,121,
129,149,168,  1,170, 25, 18, 17, 17,145,130,164,160, 32,105, 12,145, 16, 49, 72,
 65,  6, 29, 51, 59,114, 88, 48, 10, 51, 24,131, 96, 12,130, 64,  8, 17, 48,130,
194,  8, 17, 18, 98,133,132,  8,148,224,  4,115, 55, 25, 14, 98, 29, 80,169,155,
212,114,176,118,135,199,123,225, 17,  6, 33,255, 98, 48,100,181,138,169, 76, 23,
 47, 72,172,241, 58,221,249, 71,246, 22, 67,174,115, 94, 41, 88, 43,165, 81, 86,
 58, 87,174,167,129,235, 43, 89, 15, 14,138,229, 95, 38,154,175,136,114, 59, 88,
132,208,199, 91, 34,146,222, 47,150, 21,197,107, 44,158,129,190,107,224, 78,244,
163,118,250, 64,220,250,238,221,212,251, 42,222,128,102,170,221, 10, 65,203,209,
189,115,130,243,173,194,251, 96,112, 35,135, 38,237, 67, 84, 95, 22,226,149,208,
 15, 33,158,135, 10,225,206,192,145, 26, 57,169, 72, 26, 82, 32,154,144,136,183,
145, 92,124,140,183, 75,169,146,169,141, 55,113,246, 33,105,  9,141,238,210,243,
200, 60,135, 87, 13, 32,141, 62,248,227,146,166,192,158,156, 76,182,252,220, 10,
 77,241,130,160,240,144,113, 83,132, 52, 89,165,  3, 60, 85,244,159,210, 90, 79,
165,239,128,134, 80, 43,203,167,255,178, 24, 98, 68,134, 74, 33,186,134,212, 90,
117,128,112,160,114,204, 34,161, 69,  8,108,183,221,178,196, 61,231,175,175, 38,
 75,154, 15, 45,241,203,209,  0,187,119,221,218,249,241,252,201,  4,207,188, 88,
 31,135, 14,129,213,147,240, 80,138,223, 70,140,192,185,130,144, 46,231, 12,237,
 24, 70, 21, 18, 75,212,102,229,178, 35,142,168,147,227,  9, 84,194,230,115,137,
  7,217,142,118, 36,157, 38,136, 65, 40, 74, 48, 52, 18,248,198,105,207,206, 68,
  2,247,149,129, 57, 40,175,145,196,108, 26,195, 48,247,243, 34,235,208,140,185,
228, 75, 84, 87, 99,188,169, 67, 89,197, 75, 27, 26,193,220,217,255,102,135,117,
163,121,236,255,223,220, 47, 37,254, 59,167,111,205, 56, 40, 51, 78, 61,112,122,
204,104,111, 50,180, 38,163,117, 60,133, 70,196, 66, 71,177, 51,  4,218, 48,116,
 75,146, 80,195,172, 24,161, 81,156,185, 98, 55,171,135,240,253,118,113, 34,225,
 84,137, 60, 61, 35, 65, 99, 53, 49,199, 31,193,170,178,217, 50,114,146, 32,102,
 31,  1, 43,176, 65, 23, 96, 81,191, 14,243,157,  8, 91,  9, 40,132,248, 56, 24,
156,182, 14,  7, 10,235, 82,101,181,  9,146, 98, 62,240, 36,166,151,115,  1,160,
131,131,155,199, 64,230, 80,233, 41,225,135,145, 49,198,141,149,139,122, 22, 77,
231, 28, 67,  3,118,144,213, 94,208,206,254, 27,164,162, 55,207, 64,  7, 98,181,
211,225,220, 58,  8,126, 33,232,141,181,179,  3,180,163,178,191,223, 61, 13,215,
 28,189,160, 27, 80,119,141,  6,158, 78, 53,172,137, 90, 76,158,131, 92, 29,159,
164,  2,215,142,255, 23, 43,246, 11,133, 81, 78,124,100, 78,224,229,  4,232, 84,
  1,252,170,160, 73,136, 63,161, 24, 47,154,129,116, 58,183, 38,137, 52,241,180,
 16,221,220,150,224,109, 99, 53,158,  4,186,170, 62,221,225,183,  6,191,102,168,
 15,228, 17, 96,220, 10,172,  6,205, 92,219,111,216,171,146,189,165,198,140,194,
216,144,127, 18,176, 88, 48, 85, 10,225,210, 33, 63,  0,134, 63,170, 56,117, 55,
 47,  0, 97, 13, 91,245,145,166,247, 19, 21, 10,212,130,143,216, 90,197,219,194,
144,192,145, 48, 41,185,133,209, 59,198, 13,141,116,221, 37,  4, 51,135,255,131,
 88,195, 11, 81,128,  8, 11,145,  4,112,255, 82, 26,147,209,198, 66, 26, 79,246,
 67, 41, 42,231,182,120, 95, 34,139, 61,  4, 83,157, 22, 29,110,205, 28,122, 36,
 80,188, 18, 78, 89,242, 16,130,189,247,251,160, 33,141, 32,246, 69,175,143,237,
242,196, 78,119,105,187,162, 84,130,193,155,135, 20,234,147, 82,136,245,207,129,
171,227,148,192,187,207, 62,  3,175,  8,106, 77,107,189, 47, 54, 64, 64,224, 92,
151,196,243,247, 67,161,162,160,194, 17, 54, 16, 91, 65, 38, 27, 50,146, 43, 39,
138,184,244,189,175,234,228,108, 55,211, 42,249, 22, 24, 14, 57,167,154,167, 31,
130, 37,142, 89, 64,122, 35, 47,118,203,115,224,168,188, 40, 35, 31,199, 60,220,
 38,156,251,120,221,215, 53, 28, 72, 10,110,110, 41,212, 13,143, 19, 50,204,165,
 88, 33, 94,  4, 25,128, 27,  6,107, 15,236,180,156,155,152,  5, 81,158,129,166,
255,131, 73, 82,209,103, 31, 42,  9,238,129,161, 82,216, 74,147, 86, 30,
} ;

// ../Source/assign/template/GB_bitmap_assign_A_template.c:
uint8_t GB_JITpackage_80 [1302] = {
 40,181, 47,253, 96,197, 14,101, 40,  0,166,247,163, 40,208, 84,173, 14, 84, 58,
148,180,172,233, 98, 49,241,  2,213, 17, 21,153, 66,  3,120, 53,254, 62, 24, 30,
164,128,  8, 33,235,192,243,133, 23, 28, 71,179,  2,  1,151,  0,147,  0,154,  0,
213,102,184,239,181,177,102,120, 59,179,151, 21,222,157,  4, 98,214,188,185,246,
251,202,167, 20,226,227,121,125, 40,  4, 23,  3, 75, 95, 17,102,238,152,219,211,
154,185,182,172, 44,141,107,199,201,177,108, 60, 92, 92,100,139,110,227,238, 28,
231, 11,100,118, 78,169,123, 67, 48, 32, 48,176, 40, 20, 16, 24,124,138,210, 27,
158, 34,248,240,139,251,232,202, 22,155,159, 55,143,227, 56, 92, 25,188, 16,152,
198, 23,102,158,206, 51,228,161, 80,183,185,206,231,218,216,127,173,117,119,251,
198,183, 69,240,230, 99, 58, 67,154, 97,157,159,123, 21,100, 98, 12, 95,  6,177,
 60, 63,158,  3,196,  7,  6, 40,150,129,129, 23, 22, 23, 86, 66,105,175,220, 45,
223,126,114,237,144, 72,227,143, 16,150,157,231, 45,238,107,117,181,210, 10,101,
216,133,178, 51,140, 22,207,204,175, 70,112,205, 49,  8,195, 92,159,123,230, 83,
126,  7,  9, 45, 78,138, 31,168,159,147,190,233, 56, 14,181,121,120, 19,157,141,
  6,  6,143, 88, 74,173,117, 12, 47, 59,182, 28, 73,216,151,194,198,160,107, 71,
222, 25,135,176, 83,159,255,114, 33,133, 17, 31, 62,219,122, 60,159,171,255, 66,
105,200,250,181,111,111,120,116,245,199, 43,140,119,255,197,222,  8,177, 79,116,
 44, 52,158, 68,229,112,232,109, 10,105, 83,162, 94,231, 71, 32,117,202,215,220,
133, 76, 46,203, 58,173, 51,100, 62, 97, 26, 70,122,153,123,112,104, 50,188,173,
199,109,229,107,195,173, 89,169, 48, 72, 19,166, 80, 84, 35,166, 34, 85, 59,115,
188, 29,159, 10, 90,156, 24,172, 35, 41, 53, 13,201,190, 34,254, 36, 61, 44, 84,
105, 83, 10, 47,204,158, 97,246, 16,  3,129, 55, 11,144, 51, 63,215,204, 13, 46,
112, 97,198, 89,  5,210,204, 53,238,101,124,167,  5,122,142,243,102,220, 87,224,
 25, 87, 27, 79,222, 98,139,106,131,197,189,242,183,133, 55, 39,109, 84,157,143,
163,120, 27,170,226,120, 36,237,235,149,212,250,192,217, 68, 84, 60,119,147,137,
195,193,168,184, 70,115,107,246, 41, 20, 19, 74, 20,202,  9,197,154,178,118, 70,
 83,241,112, 92, 70,  5,245, 44, 42,172,150,213,154,  1,148, 19,151, 73,  2,149,
127, 98,219,141,155,  2,222,126, 46,110, 68,171,189,197,216, 40,207, 81,133,199,
240,186,251,241, 60,133,108,140, 59, 70,  8,194,206, 77,201, 53,120,106,218, 87,
 52,175,170,249, 86,205, 57, 59, 84,103,158,166,143, 15,  7,  8,  0,134,204,179,
137,202,188, 54, 21, 81, 23,208,156,128,202,170,165, 54, 74,188, 61, 84, 84, 19,
 79,162, 53,  9,233, 31, 79,197,145,168, 30,117,109,142, 45,250,149, 65,147, 11,
 41,168,180,169,170, 89,214, 90,107, 77,214,126,123, 46,187,120,159, 13,  4,232,
237,114,210,221,187, 28, 32,  2,129, 23,168, 49,181, 68,102,100, 68, 68, 68,146,
 36, 41, 52,  6, 65,  8,130, 40, 14, 67, 16,237,194,  0, 69, 16,146,204, 40,194,
140,136,144,200, 36, 37, 41, 40,191,221,149,197,128,159,215, 59,130,185, 91, 22,
112, 91, 64,140, 58,244,172, 98,168,162, 40,180, 50,253,171,114,254,207,178, 46,
 94, 23,123,136, 57,231,198,200, 47,205, 98, 54, 83,154,171,142,236,117, 82,144,
 26,159,214,159, 87, 74, 57,199,246,176, 19,160,136, 50, 96,197,217,122,176,175,
245,204, 81, 76, 93,104, 35,  5,203, 13,122,146, 69, 15, 14, 15,167,241, 96, 49,
178, 45,164,234,187,162,  8,134,136,187,247,137, 72,199,174,106, 37, 63,147, 33,
 80, 94,  0,198, 70,207,205,115, 49,107,251,130,240,118, 28, 72,147, 52,148,223,
109,132,232, 46, 13,143, 97,192,109,125, 31, 97,193,231,251,142,233,188,  8,238,
254,243,  7, 16,127,240,129, 17,106, 38, 85, 28,225,  0,120, 84,235, 84, 49,123,
211,157,108,214,160,107,136,223, 18, 22,139,102,175, 50,105, 53,211,130, 65,158,
202,  6,  4, 37,212, 58,198, 24,  4, 98, 15,101,184,255, 94,230, 88,200, 75, 43,
237,150, 71, 85,227, 86, 13,203,108,106,210,220,235, 66,178, 22,195, 65,102, 17,
172, 53,186,200,  8,167,186,244,  9,189,244,169, 69, 23, 89,118,241,136,212, 48,
140,  7, 25,210, 65, 73, 60, 49,209,209,155,205,176, 54, 50, 71,133,144, 41,108,
 83,192,200,220, 74,102, 15,136, 39, 91, 80,187, 19, 93,161, 43, 69,155,192,159,
195,189,240,204,123,228, 88,112,191,235,156,  3,212, 18, 79, 94, 13,200, 31,200,
  1,113, 62,128, 76, 16, 30, 52,136,102,  3, 44,153,190,  3, 19, 43,  5,252,186,
 65, 63, 11,219,101, 91, 29, 21, 25,182,109, 31,140, 54,226,200,137, 42,163,176,
239, 15,147, 69,100, 75, 19,163,143, 16,171,  3,247,231,175,216,250,207,136, 19,
162,129, 52,154,152, 47,196,209,130, 92,165, 67, 18,163,255, 19,189, 75,168,243,
  4, 31,100, 30, 87,134,116,211,205, 30,115, 55,150,233,121,173,234, 74, 85, 40,
194, 46, 96,144,  6, 93, 56, 92,192,132, 16, 43,195, 87,243,223,245,  6,220,108,
 38, 65,121,157, 11,  5,178,206,127, 22, 52,164,244,  5,102, 16, 79,108,198,125,
 51,196,101, 22, 49, 66,246, 31,107, 40, 68,248, 97,118,184,155,238,101,146,173,
 28, 34,204,146, 10, 26,212,121, 14,167,135,139, 28, 92, 26,194,131, 34,144, 21,
200,191,180,121,156,228,227,212, 61, 46,102, 77, 43,106,108,163,157,177,157, 91,
 46,  1,127,130, 83,193, 60,190, 95,122, 52,205,217, 20,240,192,208, 78, 40,180,
153,230, 55,174,129, 88,248,246, 50,185, 89, 53, 25,192, 89,130,148,116, 50,163,
186, 42,123,160, 60,254, 19,148,129,182,246,  8,254,225,176, 11,130,  5,244,234,
147,111,154,255,103, 38, 48, 81,204,224,161, 53,189, 20, 93,149,211, 45,165,225,
181,  9,
} ;

// ../Source/assign/template/GB_bitmap_assign_A_whole_template.c:
uint8_t GB_JITpackage_81 [1190] = {
 40,181, 47,253, 96,153, 13,229, 36,  0,198,242,149, 40,192,148,173, 14,172,128,
104, 37, 48,162,195,110,245,133,199,115,125, 36,208,180,  0,123, 17,  7,206,127,
 15,224,208,172,254,132,  5,215, 85, 20,166,162,  0,  4,138,  0,134,  0,140,  0,
210, 94,202,231,235,126, 78,248,250,126,203, 43, 52,185, 88, 48, 21,190, 42,152,
185,103, 44, 75, 75, 94,202,209, 83,225,166, 92,201, 79, 37,131,129,194, 18,153,
100,185, 25,244,190,151,135,  4,125, 78,247, 86,128,185, 96, 42,  7,  3, 23,204,
169,106,122,107, 73,130, 12,183,184,151,174, 91, 49, 25,122,171,112,159,133, 43,
131,182, 33,195,109, 97, 86,193, 87,142, 42, 38,156,215, 75,229, 47,101,236,183,
213,186, 59,183,101, 18,180,247, 25,190,112,102, 24,223,199,179, 94, 33,207, 61,
234, 33,187,225,203, 32,118,101,199, 91,104,184,128,192,164, 34, 32, 16, 53, 90,
163, 12,179, 48,242,133, 85,109,121,181,203, 55,111, 81,195, 75,159,187,230,212,
125,  4,  6,173,146,179,159,136,159,155,222,  1,185, 15,167,195,240, 32, 64, 29,
140, 76,135,212, 57,171,245,134,143, 92,113, 44, 69,200,118, 66,110,145,173, 33,
220, 35,236,156,208,111,177,112,194,170, 15,223,242,215, 67,205, 57,178,110,165,
211,109,125,151, 46,238, 56,133,213,221,111,169,182,130,216, 33, 64, 19, 24,239,
193,227,122,244, 70,125, 52, 57,113, 78,229, 75, 30, 84, 70, 90,179,102,107,107,
 69, 47,180,156,213, 71, 10,239, 46,  2, 49, 43, 85,134, 50,209, 42,111,101, 55,
 78, 13,180, 74, 98,144,150,226,196,115, 20,249,170,250,212,244,176, 17,157, 60,
 39,124,134,213, 67,204,  3,218, 12, 32,202,251, 75, 53,199, 60,192,194,219, 25,
  5, 78,205, 55,238,221,182,210, 18,253, 86,210,222,102, 27,240,219,180, 86, 37,
111, 21,147,168, 66,197,157,242, 55,132, 55, 55,101,120, 64, 33, 23,241, 58, 28,
207,167, 34, 78,190,222,  8,165, 12,159,142,131,196,115, 39,161, 62, 31, 11,137,
111, 54,231, 79, 38, 36, 19,138,  9,138, 26, 97,172,215,229,118, 95, 67,151,242,
  8,132,187, 99,212,145,175,124,109,182, 22,211,147, 73,201,196,146,154, 13,165,
226,227, 46, 36, 56,111, 66,194,226, 72, 45,  9, 48, 41,153, 74,147,214,215,198,
 74, 87,150, 40,124,195,235,238,111,249,136,200,221, 92, 85, 80,212,206, 53,248,
122,202,165,244, 60,153,160,249, 55,119,153,230,156,  7,252,227,155, 95, 56,153,
173,183, 98,210,175, 43,162, 62,  6, 40,141,162, 60, 73, 46,203, 90,107,173, 69,
202,111,207,101, 20, 47,212,105, 16,189, 93,110,186,123,215, 66,195,  7,229,110,
164,210,122,130,230, 84,166,101,166,187,167, 57,135,198,230,194, 87,250,230, 26,
 79, 21,110, 73, 10, 37, 97,162,122, 66, 18, 13,128,254,168, 65, 49, 68,166,100,
 68, 68, 70, 82, 80,144,194,112, 32,132, 16,163, 88, 93, 55,226,240, 60, 14,162,
 24, 82,134, 17,155,128, 38, 40, 41, 41, 41,191,221,149,204,154,  6, 64,168,133,
147,108,182,201,  2,  0, 35,172,221,  6,229,146, 83,205,115,247, 34,201,200, 69,
107,110,141, 73,156,101, 14,147,106, 69, 91,142,226, 17,  9,127, 87, 22,197, 36,
 45, 49, 56,112,210,105, 17,156,102,165, 72,205,  4, 59,129, 90, 85, 64,150,186,
159,197, 61,145,171,195,160,144,189,119, 12,253,226,139,224, 78, 42,146,  8,117,
 88,180,130,129, 62,224,139,231,247, 22,100,  6,163, 51, 19,239,238,238, 61, 30,
210,237,242, 94, 44,  5,107,181,108,  5, 27,129, 13,228,178,221, 84,167, 97, 94,
 54, 31, 75,217,203, 39,231,146, 43,237,164,149, 60, 31,157, 60,197,114,144,136,
125, 91,134,169,104,215,106,219,239,166, 53, 96,139,244, 17, 73,198,127,202, 18,
 48, 25,237, 74,157, 65, 78, 37,249, 19, 75,105,232, 22,183, 50,231, 11,116,164,
245, 97,133, 50, 52, 73,137, 72,204,238,232,128,205, 35,  0,101, 24,  3,  3,166,
222, 82,248,200, 58,171,105, 31,  0, 91,150,159,214, 99,214,107,122,124, 28,175,
 24,237,208, 22, 54,241,109, 59, 60,107,136,235,144, 64, 84,246,147,183, 15, 66,
  6,194, 19, 29,  3,156, 23, 22,129, 70, 46,108, 24, 75,134,183,104, 82, 65,  1,
163,110, 56, 96,153,119,153,157,139,164,205,216,238,  7,103, 27, 17,231,134,170,
 39,  3,255,251,121, 17, 19,211,196, 70, 18, 98, 27,220,191,228,215,185,178,194,
159, 65, 71,139,  4,130,180,129, 47,196,215, 66,153, 66,139,137, 81,254,145, 64,
 40,246, 80,247, 65,193,251,202,144,180,187, 13, 37,141,125,233,144, 21,  4,161,
158, 89, 64,176,128, 55, 21,187,168,216,181,132, 43,203, 24,232, 90,241,252,174,
131,230,216,115, 37, 53,111, 70,108, 93,248,227,135, 74,135,244,124, 97, 34, 16,
 35,104,167, 27, 79, 48, 23,209, 22, 82,230, 25,227, 34,236,175, 91,199,100,234,
131, 79,176,240,170,179,145, 42,170,168, 13, 30,186, 30,176,101, 73,210, 33,191,
 25, 65,103,135,175,157,228,113, 16,238,203, 44,215,102, 47,  6,140,101, 43, 98,
210, 49,159,155,162,254, 98, 21,184,134, 48,221,110,142,215, 38,143, 22,165,195,
 31,246, 83,112,242,135, 19, 63,144,101,210,115,202, 49, 37, 85,207,163, 29, 45,
 80,139, 22,180, 48,168,161,142, 49, 29,171,203,  9,112,141,222, 68, 14,240,  2,
 16,203,196, 33, 31, 90, 41,253, 33,107,183,179,105,174,159,153,154, 70, 54,194,
 69,222,  2,179,201,224,148,238, 64, 19,
} ;

// ../Source/assign/template/GB_bitmap_assign_C_template.c:
uint8_t GB_JITpackage_82 [1107] = {
 40,181, 47,253, 96, 86, 17, 77, 34,  0,  6,175,142, 40,208,210, 56,  7,168, 42,
108,223,106,146,212,107,180,242,181, 36, 57,172,104,140,184, 14, 97, 75,  2,193,
 38, 11, 96, 27, 85,192,142,102,169,135, 65, 15, 14, 94,131,  0,123,  0,128,  0,
157, 61, 99,118,  0, 99,157,140,179, 35,103, 45, 36, 89, 40,  4, 19,214, 34,228,
 50,191, 84,238,172,239,100,204,154,176,157, 28,251, 97, 82,193, 16, 65,193,120,
 84,217,242,231,246,106, 25,253,185,148,153, 87,  6,  4, 22,130,  9,194,128,133,
224, 84,156, 94,217, 30, 65,134, 83, 50,247,208, 46,221, 58,244, 10,148,121,208,
104, 28,172,155, 11,219, 10, 57, 16,223,238, 64,210,123, 71,215, 11,183, 31,190,
242,136,190,242,237, 95,248, 66,201,109,124,175,119,205,140,182, 22, 94, 28,220,
110,139, 46,205,230,149,138, 52,169, 84,  2, 17, 41, 99,108,102, 29,185,253, 10,
 99,107, 57,198, 78,165, 44,250,181,221,246, 71,225, 78,194,209,121,212, 55,114,
150,241,237,184,141,198, 79, 24, 57, 86,231, 10, 53,108, 42, 41,187,172, 82,106,
 37,188,237, 13, 11, 55,107,155,125, 76,178,118,138,232, 29,155,240, 24,143,179,
120,199,235,219,150,114,191,240,212,211,168, 94, 79,239, 30,117,210, 91,142, 94,
139,173,113, 84, 28,165, 50,163,247,192,168,232,172,221, 87,154,157,214,  8,183,
 59,124, 60, 20, 23,199,122,240,150,103,103,140,157,101,240,218,137,101,135,177,
 22,237,169,233,218,186, 41, 89, 74, 88, 33,119,110,163,135, 91,  6,172, 92,  4,
235,219,  1,183,171,218,152,157, 22, 95,109,141,141,222,100, 49,200, 85,187,243,
150, 87,214,116, 11,243,215,191, 87,193,193,157,253,107, 39,141, 79,202, 95, 14,
177,177, 64,160,204, 69,225,249, 88, 24, 43,189,145, 71,159, 91, 39,105,124, 69,
 93, 22,  2, 58, 10,239,151, 59,121, 59,  7,173,191, 36,129, 80,216,236,141,233,
 90,188,205, 97,255, 95,  2,145,164,172,177,201, 17, 41,225, 84,135,171, 52,122,
155,  2,146, 20,114,185,178,131,156, 14, 43,164, 34, 32,144,225, 14,114, 42,195,
 85,143,155, 42,172, 78, 35,  1, 18,117,246,210,116,  0, 68,202,197,146,106, 28,
 21,128, 83,168, 75,  3, 40,243,174,119, 11,207, 31,189, 65,203,169, 44, 77,221,
116,119,119,119, 55,230, 22,142,198,131,231, 93,166,133,132,111, 64,174, 34,140,
  4,244,144,153,128,120,151,  7, 34,132,155,168,206,100, 41, 32,249,107,238, 10,
  9,199,124, 58,132,199, 10, 89,161, 79, 38,226,218,176,240,190,194, 38, 87,183,
 94, 79,  3, 68, 34, 81, 72,184,229,152,201, 74, 56,154,241, 34,153, 98,189, 56,
 21,251,  6,128,227,168,225,169, 98, 51, 34,146, 20,164, 36,149,214, 80,134,200,
 80,149,205,  3,162,160, 56,140,146, 24,227,  4, 12, 49,  1, 36, 35, 34, 49, 50,
 18, 35, 18, 72, 52,179, 77,  7,220,  2, 67,226,138,140,243,102,163,119,103,147,
186,  0, 66,132, 35,  1,203,121,103,153, 63,117,109, 69,139, 81, 54,119,252,210,
 72, 92, 73, 52, 11,120,105,154,209, 76, 22, 48,176,241,170,189,152,229,193, 89,
191,  8,211, 78,191, 42,131,191, 89,169,  1,104,116,184, 88,190,124,145, 67,195,
 35,160,185, 35,167, 80, 38,102, 78,184, 74, 78,153,158,201,233, 35,  2,146, 10,
  5,241,149,163,228,  6, 80,174,113, 54, 29,226, 79,213,177, 32,189,102, 11, 27,
 66,102,212,112,109,212,150,208,247, 27,177, 20,126,150,241,117, 16, 28, 38, 88,
178,196,  8, 88,236,151, 21,199,234, 29,154,201,183, 57,196, 99,172,149,178,190,
173,  2,158, 16,223, 35, 63,132,108, 46,218, 56, 64,232,178,110, 18,134,218,222,
 34,137,166,169,117, 98, 81, 40,189, 82,199,200,184,171,  4,209, 68,  9, 17,234,
198, 25, 95,102, 61,135,216,  8, 24, 52,  3,234,112,188, 71, 81,220, 95,132, 28,
164, 20,138,179, 41,155, 90,241,172,210,110,206, 19, 30, 30, 43, 94,209,156, 21,
 18,106,105,127, 79,183, 29,180, 36,173,252,113,177, 90,223, 28, 98,132,  5, 12,
 70,153,196, 80, 15,168,228, 11, 91,171, 92,138,  2, 98,  8,240, 23,202, 40,189,
103,119, 51,106, 44,141,222,140,102, 94,107,149,158,225, 17,149,133,154, 65, 10,
174,189,131,145,100, 55, 70,106,167, 16, 72,212,162, 43, 74, 65, 90, 89,161, 68,
 36, 41,246,201,128,146, 97,227, 19,106,199, 77,141, 65,222, 83,153, 47, 80,152,
206,228,103,240,199,168,197,138,207,119, 37,236, 28,236,188,188,168, 82, 88, 31,
177,221, 32, 35, 95, 96,232,222, 77,173,178,196,180, 29, 40, 32,127,154, 17,218,
142,189,144,186,129,215, 78, 80, 66,150, 15, 88, 41,162,  9,215, 19,239, 95,194,
103,116, 28,117,253,182,237,188,158, 15,153, 28,243, 96,141,121,229,247,218, 40,
184, 32, 92,233,173,108,157, 21,173,143, 11,218,156, 21, 10,112,120, 50, 12,119,
  2,126, 71, 57,224, 11, 80,134, 89,243,176,223,196,180, 38, 11, 13, 89,190, 71,
202,218,125,252,247, 83,244,111,154,166,202, 76, 65,138,131,204, 39,190, 61, 51,
 57,203,228,170, 59,240,  4,
} ;

// ../Source/assign/template/GB_bitmap_assign_C_whole_template.c:
uint8_t GB_JITpackage_83 [749] = {
 40,181, 47,253, 96,140,  5, 29, 23,  0,102,229,113, 40,192,146,177, 14,168,170,
140, 58, 75, 90,  6,129,189,128,251,200, 37,201, 78,205,104, 72,225, 34,171,220,
 11,  2,126,137, 55,170, 67,182, 77, 81,208, 54, 29,  8,104,  0, 99,  0,101,  0,
 86, 50,108,  7,  9, 69, 66,196,228,226, 80,101,203,156,219,155,129,154,243, 24,
 51,167,  8, 42,148,138,196, 64,128, 82,249,  4,165, 83,182, 67, 47,225,147,204,
 57,178, 59,181,246,156,234,100, 28, 16, 50,250,234,130,133,109,125,180,195,183,
183, 78,228,190,209,245, 62,237,127,175, 28,154,175,124,251, 22,190, 47, 82,141,
175,197,113,102, 26,150,179, 36,168,173,125, 22,125,218,237,143,133,176,240,170,
138, 36, 85, 21,154, 70,147,253, 43,114,246,201,199,253,146,239, 23,142, 86,124,
195,245,109, 59,233,239,251,228, 48, 40,215,146, 59, 71,149,243,150,206,103,176,
 51, 13,138,206, 25,177,121,142,107,126,206,217,125,157,216,103,133, 79,123,  3,
  7, 98,194, 98,208,184,119,203,178, 49,190,206,177,177,131,100,  7,240,181, 69,
 40, 27,114,206, 60, 17,101, 82,145,112,  6, 31,205,220, 82,185,177,190,146, 47,
141,132,  3, 91,  6, 79,109, 60,173, 67, 66,  9,115,123, 61,174,217,149,191,178,
127,173,156,112, 50, 89, 40,139,228, 98,172,170,255,143, 60,162,  8,235, 75, 50,
 36,186,124,218, 80, 10,163, 53,  9, 18, 97,124, 73,172, 33,183, 79, 93,108, 45,
 67,184,169,147, 63,191,118,211,238, 38,188,197, 23, 58,135,250, 66,198, 48,190,
 27,213, 38,188,124,144, 65,179,177, 60, 10, 11, 84,140, 27, 86,231,180,241,221,
118,134,125,  1, 81,244,129,137,116, 28, 50, 18, 15,206,130,120,248,144,166,205,
 43,140,203, 37,199,144, 59,192,251,  7,151, 99, 46,253,  1, 66,227,209,120, 56,
153,  8, 43,195,190,123,234,146, 76,221,250,174,181, 28,253,181,  6, 10, 34,145,
131,203, 41,199, 72,147,141, 47, 36,161, 37, 34,193,250,200,226, 19,236,251,174,
149, 56,110, 23,103,208,126,146, 44,109,147,145,235,163,167,218,252,211, 64,175,
 82,200,213,247,191, 69,101,200,124,168,161, 45, 51, 35,  1,137,204,164, 41, 73,
146,198, 32,132, 24,164,238,108,  3,210,232, 88, 75,180, 84,217, 36, 10, 90, 82,
169,255,221,149,144, 60,125,230,246,157, 58, 48, 17, 26,248,127, 57,153, 74,193,
184, 97, 41,241, 22,  9,210,249,141,199, 53, 18, 34,  8,148,255, 77,136, 67,161,
162,  2,102,200,188,113,141, 55,100,199,193,109,  7,164, 72,127,102, 40,108,178,
105, 38,169,179, 93,207,109, 27,  2,135,174, 41, 66, 16,188, 55,180, 18, 51,160,
117, 32, 26,247,  1,191,245, 15,  3,205,245, 86, 32, 27,101,211, 30,170,142,  1,
112,238,162, 69, 13,183,226, 15,105, 38,164,243, 43,153, 33, 24,  7,212,176, 86,
 82, 16,156,180,121, 66,252, 67, 33,176, 64,168, 21,161, 64,171, 51, 49,  3,158,
 48,198,213, 89, 72,184,202,173,172, 78,170,129,168,173,212,214,246,  9, 52, 34,
118,119,241,121, 38,  9, 48,227,240,235,106,218,166,188,196, 15, 32, 71, 30,219,
230,185,222, 27, 28, 28,135,199,121, 79,149, 57,162,205, 93, 48,124,172, 46,128,
116,218,  6,  7,130, 87, 42,227,190,215, 51, 76,123, 81,169,227,116,236, 66, 29,
203, 19,146, 78,210, 23, 53,225,235,212,166, 73,127,102,138, 53, 80,203, 51,190,
 41,251,160,145,  3, 74, 15,  0, 15,
} ;

// ../Source/assign/template/GB_bitmap_assign_IxJ_template.c:
uint8_t GB_JITpackage_84 [1372] = {
 40,181, 47,253, 96,109, 16,149, 42,  0,198,120,166, 39,176, 88,113, 14,192, 63,
131,164, 25,247,116,250, 88,249,186, 22, 92, 95, 46,232,106, 73,207,161,190,100,
130, 72, 87,245, 20,237, 15,250, 15,150,126,112, 46,154,  0,148,  0,156,  0,147,
136, 99,169,122, 47,211,230, 55,107,158, 31, 83,161,  8,155,116,187,124,220, 91,
233,171,254,213,234, 37,191,229,228,202, 61, 55,203,146,193, 24, 92, 86,131,111,
163,174,161,203, 25, 87,185,152,117,217,150, 11,185,115,233,120,184,192, 96, 59,
162,219,139,241,174, 26,136, 49, 30, 35,117,135, 96,144, 49,184, 40, 20,100, 12,
 62, 65,233,174,121,244, 30,142,161,126,162,213, 25, 98,207, 93,  6,213,113,208,
182, 71, 37, 52,219,244,109, 25,162, 12,203,196,113,150, 84, 61,155,143,241,157,
238,104,158,110,229,107,182,190,184,133,182, 94, 28, 19,235,146, 32,238,126,215,
246, 66,149, 63,151,131,196,  9,  8, 44, 23,  2,130,157,142, 70,197, 55,175,205,
 29,143,192, 43, 20,209,218,215, 72,191,170, 41,153, 49,206,236, 77, 95,132,139,
 93,238,126,190,163,167,253,  4,123, 75,107,139, 66, 95,248,182, 30,161,179,100,
130,152,108,233, 71,212,187, 45, 29,219,109,123, 37,253,165,239, 21,213, 27, 39,
157,125,106, 83, 57,248,104, 53,217, 87,209, 22,154,240, 32,201,251,161, 54,238,
 17, 42, 28,149,203,201,231,162, 98,169,124, 81,184,169,111,125,199,182,123, 33,
 52, 97, 90, 95,232,149,  7, 83, 85,185,189,116,251,137,172, 83,158,206,215,166,
 34,  8,231,227,235, 71, 43, 71,228,152,124,183, 94,155, 35,159,191,116,181,146,
  7,156,141,188, 94,  7,  9,116,214,141, 41,236,197, 94, 23,244,129,  1,  6,169,
227, 27, 73,168, 25,144, 40,200,167,  2,  7, 57,244,228,  9, 38,109, 20, 97,171,
193,254, 36, 93, 33,145,140, 75,223,246, 45, 52,255, 66,160, 71, 55,  0,140,171,
 92,153, 70,232,114, 88,242, 46,224, 22, 23, 32,125,194,226, 41,147,  4, 57,246,
 45,150,148,201,  5, 72,247,192,176,160,128,160,184, 32, 32, 48, 34, 38,246, 92,
253,244,212, 42, 87, 68,178,125, 58, 51,249,224, 43,127,246,210, 12,179,114, 98,
 83, 62,227, 59,108,235,131, 19,219, 79,195,165,250,230,114,227,232,119,141, 77,
173,110,232,  2, 34,205,101, 90,190, 74, 94,120,230,122,189, 22, 30, 22,203,202,
102, 96,133,218,238,170, 77,250,  4,134,  5,199,197,233,192, 72,173,158, 68, 57,
143, 33, 96, 10,106,138, 81,148,189,249,213, 51,150,222, 43,150,168,129,205, 45,
139,239, 44,134,  5,118,146, 37,189,154, 40,202,146, 20, 53, 85, 34, 78, 35, 45,
  8,108,158,169, 54, 57,227,132,156,187,135, 10,107,226,226, 56,199,145,238,201,
176, 58, 28,171,194,228,220,122, 41,157,176, 18,217, 48, 80, 34,205, 43,167,182,
195, 29,125, 35, 72,114, 54,223,229,124,111,243, 79,122,102, 73,185,149,190,218,
 23,197, 83,193, 69, 90,201,217,227,156,159,140, 49,185, 25, 29,106,163,162,186,
 44, 42,178,197,100,198,  0,175,253,226,  2, 38,228,227,155,215,166,  1,129, 57,
168,113,181, 67, 51, 34, 50, 34,  5, 73,146, 66,107, 81,  8, 66, 16,195, 78, 76,
 59,226,216, 88,198, 67,202, 32, 74,136,204,153,  9, 68,130,164,160, 60,202,242,
 85,  5, 85,231, 32,107,202, 74,143,172,171,103, 31,220, 27,157,120, 57,116,  5,
 42,211, 23, 94, 36,103,165,112,171, 12,132,126, 11,146,  0,106, 61,250, 22, 56,
 89,205, 21, 41,  2,223,114,  5,223, 56,139,150,133,105,  7,217, 47, 96,230,136,
243,213, 12,114,139, 56,201,118,226,162,253, 51, 89,121,204, 53,251, 27, 66,151,
156,234, 72,195, 18, 56,224,202,  8,223,207,112,160, 48, 21,122,249, 19,  6,121,
 28, 44, 64,201, 54,199, 64,125,112,211,170, 11,232,  3, 30,195,139,169,159,232,
135, 23,155,156, 21, 64, 33, 75,153,  1,253, 47, 30, 53,111, 83,120, 29,243,236,
 48,244, 37,147,144, 86,  9,181, 95,156,150,168,181, 38, 19, 89,147,213,161, 96,
 49, 53,181,214, 50,177,133,113,228,252, 28, 91, 84,192,254,  9, 21, 27, 45, 38,
 61,224,196, 33, 67, 78, 74, 94, 40, 40,190,177, 10,222, 20,238, 87, 20,127, 32,
197, 70,104,187,238, 11,223, 99, 67,108, 10, 55,223, 78, 99,  8, 20, 34,130, 12,
223, 77,246,153, 52, 50,151,184,165,113, 64, 51, 94, 95, 68,105,197, 82, 14, 18,
 47, 99, 46,229, 60,120, 25, 36, 22,236, 83,226,178,185, 96,194,159,  0, 75,161,
127,109,254,  0,175, 96,124,162,  1, 12,198, 40, 72,153,253,142,101,182, 67,103,
241,167,229,123,206,141,210, 23, 86,158,236, 87, 83, 36,109,224,154, 35,160,102,
 58,103, 80, 10,132,183, 55,136,152,128,180,193,127,115,132, 84,151,248,239, 57,
142,142,213, 13, 40,221,132,120,196,141, 11, 89,219,178, 91, 61, 24, 90,208, 58,
129,227, 63,174, 60,205,194, 53,209,253,249, 36,152,134,  8,153, 25, 57,253, 53,
 55,  1,  1,181,159, 43,229,204, 56, 58,  1,163, 50, 51, 16, 52,207, 88,152, 19,
166,125,196, 78,  6,146,230, 29,244,148,125, 44, 92, 43,  3,164, 44,147, 20,100,
234,  6, 32, 28,182, 39, 33,193,162,215,218,240,234, 74,245,213,212, 95,150,  0,
137, 36,117, 82,150,145,169,159,195,140, 69,121,248,120, 55, 26,251,170,191, 18,
 56, 17, 29,181,188,239, 33, 13, 36,170, 69,160, 15, 33, 64,204,221, 11, 14,128,
163, 10, 83, 27, 58, 60,152,138, 23,195,109,212,  9,160,123, 45, 64, 27, 13, 93,
224,213,  4,149,124,157,127,195,168, 45,120,130,244, 81, 19,198, 62,160,  2,229,
 67,123,234,132, 76,167,100,148, 61,240, 78,143,222,169, 39, 41, 20,194, 82,209,
 57, 47, 16, 37,  5, 31,106, 95, 72, 15,175,  1,197, 25,212,128,141,228, 80,  5,
 30,228, 19,166,205, 23,145,124, 45, 10, 51,157, 28,209,180, 47,172,113,215,171,
252,255,212,193,133, 80,131, 82,204,218,141, 72,155,148, 69, 27,205,218,115,  1,
251,  0,114, 85,119,158, 69, 72, 83,183, 45,  7,  8,239,192,186,122,218, 34, 44,
230, 28,233, 49, 71,194,136, 72,118, 96,252, 33, 49, 80, 39, 36, 19,  5,150, 46,
117, 55,139,233, 53,176,250,183,105,222,131, 88,222, 52,149,122, 76,104,107,160,
228,255,193, 35,181,211, 83,140,210, 48,224,  4,
} ;

// ../Source/assign/template/GB_bitmap_assign_M_all_template.c:
uint8_t GB_JITpackage_85 [975] = {
 40,181, 47,253, 96,214,  9, 45, 30,  0,102, 44,135, 40,192,240, 58,  7,250,175,
179,182,247,252, 33,173, 85,230, 26,245, 67,195, 22,224,246, 60,137,145,110,127,
168,  2,255,217,  4,232,203,200,182, 41, 10,  4,215,205,124,  0,120,  0,126,  0,
221,241,113,189,156, 36,214,  4,210,157, 70,195,235,148,219,149,171,217,246,182,
129, 52,182,173, 85, 14,100, 34,161, 99,109, 93,186,141,219,115,156,187, 80,245,
220,243,174,199,130,137,100,  2, 57, 24,144, 76, 94,105,212, 35,174, 37,154,112,
235,122, 70,151,193,175,126, 30,179,139,131,233, 66,122, 53, 20, 26,102,157, 43,
 41,155, 28, 52,155, 44,187, 46,200, 93,190,241,237, 18,189,249,167,116,166, 94,
248,117,158,158, 71,167,156, 54, 84, 49,166, 51,164, 95,174,160,137,209, 60, 18,
153, 32,145, 72,149, 87, 28, 14,132,194, 57, 56, 94, 97,212, 59,151,252,108, 48,
 51,219, 80,255,120, 50, 89,118,253,255,180, 49,121,160,143, 36,122,131,110,169,
 22,137, 96, 22, 22,222,130, 53, 83, 13,244,158, 27,227,214, 52,122,140, 61,142,
 48,253,222, 93,174,164, 40,202, 74,101,216, 46,213,208,169,194,111,109,125,233,
229,109, 61,238,122,233, 55, 75, 31, 43,  9, 64,125,235, 76, 10, 63, 80, 11,217,
218, 32,203,178,126,121,197, 16, 55, 20,130,180, 96,191,229,121, 36,238, 25,180,
143,183,195,140, 21, 37, 82,192,105,254,162,226,242,141,199,195, 82,185,228, 23,
170,194, 30, 45, 89,141,242,160,180,251,201,226,213, 64,212,234, 71,109,198, 70,
181, 71,218,186,211,240, 43, 10,111,180,111,151,231, 71,178, 94,123, 30,189, 52,
124,248,129,167, 95,136,222, 48, 96,171,249,147, 11, 92,154,113,136,179,125, 80,
111,142,122,202, 95,222, 90,245,176,156, 25,223,202,141,158,181,122, 51,238, 43,
240, 60,  9, 12,178,173,207,216,130, 90,195,195, 76,200,112, 48, 18,130, 65, 82,
207,100,158,171,147,121, 50, 29,138,133,211,212, 49,113,181,114,121,100,156, 43,
194,  1,155, 15, 14, 92,111,150,171,  1, 83,  7, 22, 82,111,240, 60, 72,204,134,
236,178,237,149,176, 11, 60,194, 90, 79,157,251, 30, 49,178, 11,147,151,139,234,
119, 15,  4, 65,150,202, 67, 41,194,176, 99,250,214,168,248,253, 81,140, 81,111,
166,223, 41,229,130, 89,235,210,187, 60, 26,120,196,112, 19, 99,140,113,179,253,
 56,101, 72,253,234,204, 79, 70, 83,121,236, 36,117, 57, 59,140,230,151, 75, 17,
174,149, 60,  7, 62,119,151,191,217,202,221, 82,121,128,185,168, 81, 61, 51, 50,
 50, 34, 35, 34, 73, 65, 82, 72,  7, 48,132, 16,164,204,138, 27, 66,249, 52, 81,
 33,140,140, 33, 98, 40,146,  9, 68,130, 20,164,160,252,121,149,234,135, 14,128,
128,142,151, 72,211, 90, 49,208, 97,  4,221,101, 21, 81, 47,122, 52,197, 27,180,
 53, 87, 32,248,107, 96, 94,115,140,170,192,252, 64, 27,123, 45,156, 86, 25, 73,
  0, 78,  2,223, 79,203,  8, 41,183, 52,162, 80, 57,220, 48,110,213,239,253,206,
 33, 77, 97,245, 24,210, 89,213, 36, 27, 25,242, 30,226,  5,185,237,160, 12,223,
177,140,148, 36,163,116,148, 29, 15,233,254,121,171,209,239,152, 10, 81,140,255,
  9,215,219,163,139,156,188,248,138,218, 46,178, 29, 10,  0,104,134,107, 19, 75,
 91, 34, 68, 81,179, 87,225,187, 21,180,200,155,140, 96,202, 14,  3,211, 58, 66,
 13, 12, 79, 40,136, 64,176, 85,195,125, 98,182, 82,152, 46,200,238,113,129,200,
 65,214, 80, 35,136, 25,218,132,200, 99, 55,190,125,201,168, 11, 98,167, 32, 82,
114, 16, 37, 86,  8, 61,224, 39,243,167,229,211,181, 66,140,191,105, 77, 10,204,
  5,192,172, 41,133,152, 95,151,161,144,252,101,166,153, 79, 87, 26, 18,111, 43,
252, 50,185,172,211, 52,228,  4, 33, 33,206,156, 68, 66,243, 15, 58,243,149, 74,
 56, 24, 25,152,246,  1, 30, 81,148,185,161,128,240,160,147, 38, 46,141, 32,145,
231, 41, 35, 80, 33, 34,201,134,191,192, 37, 64, 92,221, 13,168,134,255,242, 25,
 91,133,228,226, 81, 19, 91,114,239, 73,100,245,141,178,158,166,230,227,203, 81,
 44,189,239, 12,105, 13,218, 45,156,231, 71,158,203,202, 99,109, 94,233,141,193,
232,157, 14, 92, 14,111, 59,135,228,236,124,241,231,204,166,171,187,224, 13, 51,
219,134, 96, 78, 88,250,164,233,105,136, 36,217, 65, 32, 84,201, 77,179,165,130,
105,171,104,109,210, 85, 92,114, 31,162,182, 74,195,  0, 15,
} ;

// ../Source/assign/template/GB_bitmap_assign_M_col_template.c:
uint8_t GB_JITpackage_86 [931] = {
 40,181, 47,253, 96,153,  9,205, 28,  0,214,233,129, 40,208,240,232, 24, 58,179,
 70,  5,181, 13, 29, 31,229, 13,183,244,179,240,112,188, 12,106,252,141,115,213,
 31,229, 98, 83, 21,138,249,131, 43, 60,210, 65,252,  2,119,  0,121,  0,115,  0,
159,245, 74,174,118,179, 27, 87,109, 83, 85,141,107,102, 57,149,  4,130,  7,162,
 85, 82,174,186,126,174, 55, 23,178,159,223,107, 61, 14, 80, 36,148,170, 96, 34,
161,156,202,224,163,182, 36,138,112,136,245, 18,183,189,206, 58, 60, 98, 22,  7,
195,125, 52,107, 42, 85,103,250, 97,117,219, 17, 54, 53,104, 54, 24,102, 77, 78,
231,202,222,118,249,170,115, 37,209,188,255, 74,221,244,126, 93,221,243,122,217,
148, 19,135,172,214,116,126,180,219, 22, 52, 49,154, 71, 34, 83, 21,137,  4, 83,
128, 96, 99,251,173,177,151, 49,116, 38, 66,134,131,145, 15, 11, 18, 62,131,125,
 44, 15,246,201,120, 38, 20, 44,167, 56,156,135,132,115,112,156,186,224, 61,150,
116,216, 96, 38,182,129,119,248,100,254,127,218,152, 46,168, 27, 93,188,130,142,
105,118, 13,211,199,200, 33,247,142,182,  8,132,186,174,119, 81, 31,236,186,190,
 89,120, 12,239, 51, 49, 57,102,216,188,105,247,236, 93,231,250,149,184, 79,170,
 18,168,162,112,189,164,131,234,130,167,215,246,114,146, 64, 40, 85,229, 50, 26,
149, 88,129,151,247,166,121,249, 45, 40, 46,127, 60, 12, 44,151,252,  2, 41,125,
 41,  9,103,149,  7,196,158,221, 89,254, 84,113,106, 18, 51,219, 81, 92,210, 96,
189, 35,173,114,153, 62,  5,181, 70,107,230,246,236, 70,248,214,123,105,166,223,
191,206, 59,237, 66, 52,127,  0,154,221,151, 60, 46,100, 52,151, 95, 23,148,  7,
100,186,245,167, 69,154,110,252,160,215,242, 16,182, 83, 84,167,252,229, 53,179,
 87,203,185,117,182,155,232, 59,179,121,235,154,  3,190,  3,211,212, 49,109,214,
114,121, 96, 28, 11,162,225,154,157,134,173,106,120,179,  0, 83,199,245,193, 51,
124, 58, 17,147,  1,179,174,  7, 60, 62, 43,237,225, 55, 91, 53,172,238, 30, 51,
 48,235,146, 23,182,251,245, 60,144,129,229,242,179,144, 80,124, 33,214, 27,194,
 86, 87,178,236,237,172,146,206,109, 81,164, 36,147, 71,252,228,167, 24, 99,140,
 26,174,143, 83,126,240,150,103, 82,162, 71, 78,194,203,201, 97, 52, 23,109, 41,
249,205,251,174,220,190,134,237,118,  3,203,169,128,170,168, 81, 45, 67,200,204,
136,136,136, 72,146,130, 36, 29, 32,132, 16,196,148, 25, 55,226,184, 80,138, 67,
140, 33, 98, 12, 53, 18,216,  4,  9, 74, 74, 82,254, 60,149,226,167,  7,144, 98,
239,181,138,173,205, 11, 14, 24, 45,216,150, 17, 99, 65,143,174, 72, 41, 27,216,
 24,  4,175,216, 56,190,137,124,161, 99, 88, 53,249,179, 91,253,149, 45,111,106,
114,111,224, 96, 56, 48, 24,217,132, 27, 31,166,156,147, 77, 92, 82,195,247, 19,
145,209,144, 52,230,100,241, 31,110,172,209, 31,231,  8, 11,111,216,174, 32, 81,
114,240,164,195,162, 26,117, 59,  7,230,202,249, 27,229,  6, 12,111,221, 17,207,
216,133,244,167,126, 97,102,185,164,182, 62,  1,185,181,135, 23,210, 27, 72,  7,
 85,111,224, 40,135,142,160, 45,109,225,141, 61,173, 11,204,182, 38,194, 37,151,
 70, 25,  8, 68, 65,206,138,248, 19,220,150,174,116,188,140,241,139,129, 28,212,
 66,109, 74,204,225,206, 69, 94,220, 24,133, 86, 70,197, 32, 98,234,113,138, 42,
 98,176, 98,219,  3, 72,100,251,212,122, 69,245,222, 35, 49, 69,113,241,102,107,
106,134,160,191,200,134,  3,203,223, 16,225,255,102, 36,214,255,177,  9,202,151,
139, 97, 60,233, 72, 88,215,217, 52,254, 33,231,131,199, 92,160, 18, 98,  0,253,
204, 17, 46,117,211, 88, 61,  2,185,156, 96, 83, 78,202,  7,254, 29, 96,145, 28,
 97,225,147,  1,168,144,208,216, 72,  8, 35, 42,146,184, 14, 68,245,111, 44,208,
151, 91,141,116,231,  8, 59, 61, 65,231, 78,197,185,116,226,163,187,125,114,156,
  3,221,205, 69,162,101,166,199,132, 20,124, 72,246,  1,216,191,192,  0, 48,223,
 45, 26,137,230,137, 83,101,180,232,223, 16, 25, 59, 78, 55, 77,136, 98, 38,182,
 11, 45,112,203, 51,137,118, 83,186,  3, 76,
} ;

// ../Source/assign/template/GB_bitmap_assign_M_row_template.c:
uint8_t GB_JITpackage_87 [950] = {
 40,181, 47,253, 96,194,  9,101, 29,  0,182, 43,134, 40,208,240,232, 24, 58,179,
 70,  5,149, 13, 13, 26,207, 76,246, 96,255,128, 19,209, 51,151,197,156,198,196,
 61,194,197,166, 42, 21,243,  7, 87,120,164,131,248,  5,124,  0,124,  0,119,  0,
 16,138, 69, 59,109,126,215, 43,153, 86,174,238, 75,183,141, 69,245,165, 90,229,
 88, 19,  8, 29,200, 70, 73,153,106,234,185,222, 29,168,122,110,237,117, 56, 64,
145, 80,172,130,137,132,242, 74,163, 14,117, 37, 77,132, 67,174,151,186,141,189,
250,112,152, 93, 28, 76,247,205,172,169, 80,157,231,151,209, 93, 71,217,212,160,
217,100,217, 37, 37, 28, 60, 25,115,143,167, 58, 83,210,204,251,175,208, 61,237,
231,209, 45, 49,112,150, 81, 94, 80,213,122,202,111,122,187,126, 36, 70,243, 72,
100,178, 34,145,  1,223, 82,128, 96,223,250,173, 47,214, 24, 28, 36, 66,134,131,
137, 16, 11,145,122, 38,243, 92,157,204,147,233, 80, 40, 88, 94,113, 56, 16,  9,
231,224,160,222,185,226,195,  6, 35,179, 13,245,  7, 79,230,255,167,141,201,126,
188, 81,232,244,243, 59,181,111,119, 30, 70, 14,177,118,196, 69, 32,149,199, 98,
 44,227, 87, 88,134, 97,231, 42,117, 12,156, 97,198, 91,163,164,207,111,124, 15,
 51,106,222,211,123,198,215,153,126,165,238,149, 87, 55,210,129,133, 81, 86,233,
 99, 77, 62,175,235,227, 36,  9, 55,176,188,170, 64,  9,245,120, 60,201,203,127,
 81,113,249,227, 97, 96,185,228, 23,170,210,118,146,174, 86,121, 80, 23,215,173,
101, 11,168, 85,111,222,210, 70, 81, 59,218,104,167,233, 87,148,222, 38,205,221,
150,222,232, 90,106,237,204,243,251,231,225, 79, 15, 52,243,  7,176,213,125,201,
225, 38,163,185, 28,171,147, 95, 46,191,212,146, 34,229,  1,121,110,253,105,145,
158,251, 62,166,181, 28,116,171, 20, 81, 25,127, 57,213,170,213, 81,110,157, 43,
 39,250,214,106,222,154,230,211,212, 49,113,213,114,121,100,156, 43,162,  1,147,
 14, 13, 28,221, 46, 87,  1,166, 14,236,163,206,224,113,144,144, 12,217,133, 61,
224, 17, 67,167, 26, 85,123,135, 25,217,133,197, 80,245,110, 49,254,108, 84,  6,
231,234,  7, 41,229,125,233, 39,207,248,146,231, 74,175,103,247,189,185,144, 84,
124,  3,169,  5,221,170, 43,185,219, 34, 88,197,208,228,  1,191,248,  9, 66,  8,
225,118,233,161,140, 31,245,171, 35, 69,135, 93,164, 30,101, 23, 67,186,118,187,
138,231,240, 55,237,246,183, 91,185,128,172,168, 97, 49, 83,104,102, 68, 68, 10,
 82,144,146,164,  3, 48,132, 16,164,202,174,  3,242,168,104, 10, 66, 80, 41,129,
 49, 84, 77, 64, 50, 73, 57, 41,127, 30,149,155, 22, 99,128,158,240, 37,103, 91,
146, 11, 64, 49,202,162,178, 66, 36,  1, 97,141, 27,133,236, 99, 55,198,154,139,
204, 71, 42,102, 12,221,138, 58,216, 25,171,166,141, 73,198, 64,118,140, 21, 77,
211, 84, 56, 38, 42, 85,126,112,  0, 83,232,231,169,  0, 79,206, 45, 96,191,105,
 11, 17,122, 34,233,119, 31,162, 62,222,  8,108, 76, 78, 50,123,134, 48,150,232,
175, 66,255,249,149,251, 29, 29,209,137, 18,102, 53,167,230, 93, 57, 13,223, 21,
177, 28, 19, 14,237,160,137, 76, 77,248,104, 38,242,  1, 85, 87,109, 97,236,219,
146,237,185,188,221,155,168, 13,171,251, 65, 19,114, 86,172,115, 47, 16,200, 74,
246, 39,122,148,206,100, 37,186, 24,202, 65,109,106,147,196, 28, 52, 85, 36,135,
141, 74,175,100,182,131,171, 41,217, 20,120, 68,105, 21,209,  3,240, 50,198,215,
 30,171, 24,248, 72,  8,138, 66,145,231,206,168, 67, 78,190,144,  6, 54,128, 98,
162,103, 38, 66,249,106,239,120,190,235,177, 82,224,207,211, 62, 10,113, 47, 90,
188, 75,249,193, 57,215,175,  4, 11,135, 87,164, 64, 40,233,139,111, 30, 27,224,
 18,220,  4, 31, 90, 94,238, 89,199, 48,255,139,177, 97,  1,139,248,230,211, 57,
 63,  6,129,177,151, 12, 43,  3,156,112,  7,130,249,238, 41,196, 23,223,140, 56,
130,123,116,122,129,126,232,122,224,154,244, 75,141,160,126,  8, 64, 82,239,237,
138,246, 75, 35,  1,118, 67, 51,119, 19,105,230, 40, 33,199, 29,112,127, 49, 69,
197,161,167,168, 82,182,157, 38, 95,238, 48, 70,150,110,154, 20,197, 76,171,203,
 29,112,139, 61,137, 54, 80,165,221, 59,
} ;

// ../Source/assign/template/GB_bitmap_assign_M_sub_template.c:
uint8_t GB_JITpackage_88 [1063] = {
 40,181, 47,253, 96,175, 10,237, 32,  0, 86,240,146, 40,176,146,217, 28,170,170,
186,227,  6,252, 66, 61,132, 78,163,197,172,157,191, 34, 59,133,  4,132, 50,245,
141,219, 54, 89,119, 58, 53,119, 74,127, 26,244,  7,187,136,  0,131,  0,137,  0,
159,136,123, 14,239,229,216,226, 70,119,124,108, 63,165, 73, 69,137,116,167, 85,
209,122,101,108,203,217,124,123,195, 34,141,111,107,150, 19,153, 80,232, 84, 91,
143,198,198,237, 57,206, 93,200,122,254,125,214,101,  1,101, 66,137, 28, 12, 76,
 40,167,180,233, 18,219, 81, 85,120,101,125,163,203, 33,104, 63,151,153,197,193,
116, 98, 29, 53,149, 42,102,157,173, 40,147, 28, 52, 88,150, 89, 24,136,108, 12,
185,207, 55, 30,123, 84,199,252, 87, 58,215, 79,  4, 59, 83,144,  8,211, 73,111,
200, 98, 92,169, 88,193,108, 65, 20,163,185, 68, 34, 69, 36,146,167, 56, 28,136,
133,123,120, 76,239, 88,243,131, 97,104,134, 77,255,120, 50, 89,102,253,191,212,
 33,125, 32, 80,228,189, 65,191, 85,147, 92,130,237,175,107, 92, 76,175,226, 27,
239, 98,218,138, 99,191,252,178,239,177,187, 12,121,225,203,147,151,237,238,243,
 87, 83,252, 13,109,174, 90,248, 61,215, 75, 12, 92,193,119,151,169,233,201,105,
167,141,219, 35, 27,122, 93,248,171,173,199,250,249,107,143,219,142,245,219,173,
151,212,  4,152,190,117, 22,137, 96,168,133,174,109, 80, 85, 85,191, 36, 76,  4,
106, 35,177,233,250,171, 47,216, 82,243, 92,248,188, 93,203, 29,193,114,170, 34,
 43,211,231, 67,137,254,162,226,242, 14,  8,  4,193,242,201, 47, 19,133,191, 58,
186, 90,  5, 50,105,227, 37,139, 83,  3, 82,179, 96,189, 27,219,212,159,104,235,
 78,195,167, 38,188,213, 30,187, 76, 65,209,253,250, 34, 24,190,130,161, 58,138,
  1,155,205,167, 92, 96,172, 25,139, 56, 95, 72,253, 40, 70,211,249,203, 91,179,
 31,158, 52,227,209,114, 24,207,154, 29, 51,238, 81,224,153, 18, 24,228,107,159,
241, 13,181,134,  7,170,144,225, 96, 38,196,102, 78,207,100, 30,171,147,121, 50,
 29, 10,  6, 75,146,244, 33,113, 54,224,  2,201, 56, 86,132,195, 69, 31, 28,184,
222, 46,103,  3,164,143, 75,156,222,224,121,144,160, 13,153,  5,193, 46, 21, 28,
176,  6,106, 47, 49,107, 63,157,  3,197, 75,141,105, 93,211,179,224,191, 48,  4,
 33, 88, 46,222,254, 70,215,  5, 46,159, 92,226, 13,191, 80,219, 88,140,205,229,
244, 46, 55, 25,198,217, 92,149,133,235,155,195,226, 55, 88,241,113,237, 62, 47,
 65, 34, 60,134, 89,235,209,187,140,225, 13, 64,164,136, 73, 41,165,220,110, 95,
210, 41, 78,183, 58,244,147,209, 88, 46,187, 57,125,210, 14,163,249,229,211, 11,
128,205,168, 81,185, 50,134, 70, 68, 70, 68,146,130,130, 36, 29, 32,132, 16,164,
152,221, 54,114,249, 64,  9, 26,104,144, 18,144, 98,145, 80, 16,  5, 41, 41, 40,
127, 29,149,249,155,  2,117, 15,  6, 40, 64,190, 41, 12, 48, 20, 81,101, 27, 51,
 70,152,235, 48, 80,214,135, 53,195, 65,226, 63, 64,174,161,128, 42,174, 20,  5,
 30, 42,101,238,121, 20,169,153, 56,211, 62,187,  5,251,170,233, 73,157,192,104,
 49, 38, 12,  6,139,209,126,122,254,152,177,111,218, 41,225,155, 28, 33, 72, 45,
 12,254, 44, 84, 29,206, 66,232,126,131,240, 77,153,118,208,233, 98,129,239,145,
203, 16,215,181,161, 50, 78,163,120,138,115, 80, 34, 23, 49, 98,111,157,203, 40,
250, 75, 21, 65,244,113, 89,209, 36,231, 60, 79,101, 60,150, 83,234,174,248,217,
 34,171, 39, 69,112, 58,126,145,193,218, 33, 73,  5, 53,188, 42, 63, 91,123, 54,
 24,201, 72,187,181, 37, 48,221, 17,218,176,167, 80, 92,  7,  2, 82, 21,244,  9,
208, 74,119, 58, 33,  3,116,241, 30,212,197, 95, 52, 81,195, 37,230,120,167, 35,
205,220, 56,132, 79, 38,118,160,158,210,159,194,139,168,175,168,127,  0, 47,217,
131,180,158, 85,143,135,137, 74,237,185,154,144,107,254,132,174, 95,142,  1, 66,
 70,104, 22,205,213,181,177, 12,249,  5, 63, 72,238,107, 26,  8,249, 42,212, 85,
135, 36,169, 63,255, 27,248,115,138,106,137, 29, 78,105,250, 28,144,112,161, 67,
 83, 90, 12,194, 78, 68, 29,243, 60,112,142,128,108,242,243, 68,165, 72,137,235,
132, 35,231,109,153, 30,  8,239, 33,208,195, 63,218, 63, 86, 65,185, 88,211, 36,
 86,158,124,219, 88,253,147,172, 70,212, 12, 62,253,222,221, 17, 42,232,213, 93,
236,113,135, 46,100,132,144,140, 98, 57, 35,182,254,128, 22,123, 53,  6,229,140,
170,254, 89,156,218, 82, 56,165,120,238,177,247,166,214,106, 99, 39, 12,212, 17,
239,212,194,169,179,220,125, 35,193,126,152, 51,216, 59, 29,244,129, 95,216, 62,
168,148,138,220, 52, 43, 42,152,214,234,182, 44,181,197, 43,212, 36,106,174,210,
  3,184,  3,
} ;

// ../Source/assign/template/GB_bitmap_assign_M_template.c:
uint8_t GB_JITpackage_89 [819] = {
 40,181, 47,253, 96, 51,  7, 77, 25,  0, 86,104,123, 40,208,208, 58,  7,122,199,
 25,194, 71, 18,152,209, 85,213, 22,242,242,  7,122,149,151,169,124,195, 18,189,
  5, 24,227,144,137,141,211, 31, 92,225, 17, 31,224, 18,111,  0,106,  0,111,  0,
145,139,119,246,118,129,180,157,173, 69, 12,100, 98, 65, 19,217,250, 83,219,246,
230,246,118, 23,113,115, 41,171, 79,  5,146,  1,  9,196,128, 96, 64,242,135, 38,
125,178,241,195, 11,143, 84, 15,117,151,122,145,243,233,170, 48,148,238,227,106,
153,180,173,252, 93,125,163,231,138,172,211, 59,227,239,108,239,175,148, 59, 60,
125,219,218, 31,174,247,147,190, 44, 63,175, 47,  6,177,121, 17,173,101,236, 99,
239,198, 12,163, 88, 78, 81, 17,132,162,  2,143,116, 42,  5, 93,246,214, 90,148,
246,179, 59,123, 72,110,220, 85,242, 45,119,135,145, 87,122, 91,251, 11,117,240,
143,100,214, 45,172,175,226, 25,214, 47,223,118,237, 14, 52,209,170,177,247,135,
 77, 70,  2,123,184, 42,200,241,243,137,224,  9,  9, 48,254,129, 49, 69,201,250,
188, 92,251,163,219,228, 79,240, 25,236,189, 99,217,227, 98,189,179,223,221,189,
148,108,111, 99,199,137,  6, 34, 18, 72,119, 26,127,213, 39,181,  3,154,107, 83,
209, 80, 52, 28,252,129,193, 68, 48,156,131,227, 15, 75,186,166,130,156, 11,  5,
187, 46,210, 57,155,202,117, 85,255, 31,109, 68, 50,243, 60, 24,239,236,147, 53,
 74, 74, 15, 71, 89,214,157,177,198,139, 25,107,223,203,154,245,216,210, 13,  2,
192,119,151,102, 63,248, 60,170, 97,112,246,215,219,140,178,103,237,206,229,220,
118,161,172, 39,221, 38,  6, 89,218, 26,185,206, 39,136,221,202,215,126, 51,126,
147,221,189,235,125,119,156,  7, 81,212, 17,117, 76,174,244,112,149,121, 44, 70,
201,160, 68, 92, 92,220,102, 75,182,110,249,173, 17, 45,165, 90, 42, 87,101, 97,
 25,  8,174,183,201, 89, 24,211,101,122, 30, 73, 53, 76,198, 58,120,135,187,102,
  1, 90,  4,163,  2,222,155, 71,106, 51, 10, 84,122,181,254,240,244,112,152,172,
 40, 41, 64,  4,235, 19, 16,173,167,168, 71,159, 28,194,114,193, 36, 50,155,182,
172,109, 60,182, 25, 59,210, 59,237, 70,144,125,200, 96, 11, 21, 12,  5, 70, 56,
 64,233,149,107, 83,  5,128,134,168,113,165, 98,136,104, 70, 38, 72,146, 82,161,
 49, 48,132, 16,196, 92,114,  3,210,248, 76,146, 65, 40,112,130, 18, 81, 48, 35,
161,  4,164,172,146,146, 24, 27,198,170, 51,147, 49,252, 70,231, 99,182, 94, 26,
 52,238,191,112,220,203, 14,148,191,241, 61,  4, 88,193, 94, 40,210,200,234,129,
166,130,208, 34, 17, 81,168,146, 80, 88,222,128, 96,191,231, 55, 62,210,144,  0,
 49,176, 68, 87,240, 48,246,193,208,251,133,120,216,135,215,225,238, 14,181, 69,
 68,131, 30, 16, 69,232,201,142,250, 10,137,225, 98, 24, 82,200,199, 47,137, 81,
 27, 41, 95, 45, 42,131,205,163, 20, 71, 39, 57,108,103, 69,180,248,142,180, 54,
167,121,181, 76, 35,155, 74,112,  5,227, 19,166,236,150,143,109,106, 61,189,175,
233,204, 42,236,120,200,118,167, 36, 83,108, 42,184,188,225,110, 75,125,138,230,
 91, 33,  0, 15,156,  5,239, 40,216, 99,100,103, 74,104, 48,132, 70, 27,204,191,
226, 73, 32,237, 87,140, 80,230, 19, 97,141,238, 44, 22,250,210, 43,142,138,135,
 27, 71,166, 18,  1,126,137, 11,196, 62, 47,172,104,126,109, 68, 44,142,141,225,
193, 46,  7, 67,210,135,142, 57, 13,225,185, 35,200,225,168,212, 43,209,115, 90,
141, 78,112, 18,121,141, 34,158,128,204, 29,134,130, 51,118,152,151, 15,114,211,
124,127,102,250, 34, 74,216, 67,117,111, 26, 95,239, 19, 99,170,135, 27,  6,
} ;

// ../Source/assign/template/GB_subassign_01_template.c:
uint8_t GB_JITpackage_90 [1321] = {
 40,181, 47,253, 96,135, 26,253, 40,  0,102,123,177, 40,192,148,113, 14,104,146,
181,176,210,164, 18,  7, 54,177,161, 12, 87, 33,190,  1,207,202,  4,229,242, 53,
 50, 34,240,181, 36, 10,101,192, 52,  9,130, 72,144,131,168,  0,162,  0,166,  0,
 37, 20,138, 39,187,158, 29,239, 74,111, 81, 54,110,237,179,125,105,213, 46,171,
251, 52, 77,178,198, 54, 98,124, 57, 73,242,186,170,197,143, 43, 63,159, 10,208,
 45,204,229, 91, 53, 53, 79, 80, 46,  5, 25, 11,155, 52,233, 93,183, 44, 79,210,
108,202, 91,102,225, 75, 89,155, 31, 11,198, 67,168, 96,227,147,229,203,162,223,
 54,149,166,232, 28,119,189, 74,200, 92, 50,150,  5,204, 37,243,138, 70,189,186,
243, 36, 31, 94,112,125,196,212,181,155,163, 87,240,250, 56,152, 60,105, 59, 22,
 95, 43, 61,200, 61, 63, 72,129, 47,209,121,191,107,110, 37, 39,181,251,205, 43,
158, 42,163,176, 91,220,146,243, 58,238,136,185, 68, 90,154,247,202,142,239, 70,
135,206, 13, 12, 40, 22,  3,131,152,243,149, 38,143,131,101, 31, 24, 61, 24, 89,
  4,117, 50,  8, 47,135, 10, 88, 97, 88, 72,192,188,170, 46,117,139, 99,142,147,
 86,134,102, 55,239, 71, 14, 16,232,252, 68,191,246, 39, 60,169,158,147,215,242,
 73,218, 30,253,  5,166,158, 33,223,142,141,240, 70,171,119,217,218,170,157, 77,
 45,191,209,175,146,206, 86, 30,158,206, 95,158,182, 41,199,206, 15,132,237,239,
124,197,196, 99, 50, 96,146,153, 80,178,196, 29,197,235,125,229, 17,201,206,113,
242, 61, 53,156,236,102,123, 20,183, 88,115, 40,186, 62, 23,  6,185,239,215, 29,
251, 53,199,226,136,211,209,124,  4,179,143,  4,188, 70, 49, 99, 20,154,224,220,
254, 60, 58,223, 92,250,255, 83, 40,  1,161, 10,  9, 10,138, 79,197,163,218, 40,
 91,144, 86,174,106,158, 87, 15,160, 76, 34,122, 42,143, 87, 30,202,147,109,142,
 97, 21,230, 33,185,  6,205,251,218, 73,250,248,230, 30,239,136,160,208,116,222,
105,106, 91, 91,227, 19,247,167,121,229, 85, 91,217, 55, 94,147, 58,134,  3,175,
136, 80, 20, 81,140, 66,153,  8,131,156,135,104,107,123,211,106,151,183, 19, 16,
 92,250,134,107,126,249,230,219,252,184,178, 41,106, 17, 80,180,206,214,236, 41,
 27,175, 96, 42,109,118,146,142,108, 20,115,223,198, 38,237,190, 66,169,187, 73,
182,166,142,221, 71,111,189,123, 93,189,236, 74,210,122,  1,151, 57,239,107,246,
222,218,230,125,175, 46,207,142,174,146,156, 91,178,213,110,  5, 20,202, 73,115,
223,165,246,107,182, 34,211,182,236,152,100,114,146, 78, 82,102, 36,226, 64, 80,
150, 85, 89,102,227,182,245, 70, 75, 64, 64,243,137, 10, 56, 81,129,197, 14, 40,
123,  0,113,172,204, 73,232, 18, 93,156, 88, 20,108, 17,166, 21,122, 17, 19,175,
 74, 53,135, 17,187,124,154,220,185,153, 99,140, 74, 95, 97,175,125,171,242,107,
131, 93,166,174, 29, 24, 26,183,245, 24, 95,142, 79,  8,  8,226,219,242,165,243,
212, 45,121,171,106,202,151,173,119,231, 39,  7,230,215, 11, 52, 14, 64,157, 52,
 41,115, 39, 56, 33,117, 24,167, 67,135,186,128,192, 43, 13,135, 30,245, 13, 87,
107,199, 27, 52,223,252,154,152, 71, 85,193, 88, 30,161, 71, 29, 34, 66,140, 99,
 17,  3,128,243,168, 97,169, 82,138,148,136,136,136, 36, 73, 65, 50, 28, 48,132,
 16, 68,170,204,182,  1, 18,121, 56, 71, 85, 32, 99, 12, 33,140, 48, 66, 68, 18,
140, 68, 18, 74,140,  4, 34,129,216, 46,140,  1,116,209, 65,128,168,244, 22,241,
 19,236,243,220,  5, 11,104,151, 52,114,224, 79,235,  2, 90,155,149,201,218,116,
111,176,252,140,255, 91,239, 74, 48,165,218,183,253,203, 83, 22, 28,180,104, 19,
 63, 73,181,133,183,245, 78,227,189,179,122, 47,205,  0,102,163, 14,212,208,233,
178, 31, 96, 41,252,173,137,  0,121,162,249,239, 22, 72,142,100,226,  9,236,218,
246,199,167, 88,222,145, 34,226, 83,202,251, 16, 79,228, 25, 14, 10, 43,180, 61,
129,246, 12,  3, 42,145,136,135,192, 35,224,159,155, 16, 10,192, 93,  0,140,  1,
 49,230, 81,237,249,  7, 98,104, 48,124, 23, 64, 99,150,223,112,173,252,182,100,
 60,144,161,120,167,196,137,128,169, 22,224,177, 45,171,162, 49,226,174,114,159,
 71, 83,203, 38,240,107,205, 41,171, 26, 20, 20, 37,219, 48,103,104,135, 85,148,
150,254, 29,178,219, 13, 48,145,120,206,135, 23,171, 59,231,220, 49, 61,215,160,
124, 33,117,180, 37,189, 87,212,122,132, 34,130,155, 81, 22,193, 10,160, 66,180,
131,157, 80,134, 28, 27,218, 53,142, 45,116, 30, 30, 78,227, 72,116,136,255,121,
 25, 60, 69,237, 58, 92,123,165,103, 27, 75,236,194, 85, 82,223,122,131, 44,164,
192,132,  6, 36,126, 31,116,128,204,216,234,202,130, 79,  8, 94,139, 58,226, 64,
 16,174,105,  3,110,  7,129, 49,124, 65,225,  4, 91,204, 93,140, 15,144,173,160,
201, 36,216,232,152,245, 51,228, 75,126, 19,188,235,155,112, 13,160,115, 89, 14,
181, 53,226, 32,186, 21, 61,128,246,183, 19,215, 33,250,131,162,181, 57,212,188,
188,103, 68,181, 34,173,194, 93, 25,  6,210, 42,155,177,105,149, 51,251,160, 28,
133, 41,249,146,217,153,232,114,212, 96,207, 29, 46,146,196,130, 30,200,128,208,
105, 76, 64,205,122,218,185,159,182,157,191,166,235, 67,180,107, 52,115, 33, 84,
216, 90,159,254,141,  0,137,195, 71, 39, 37,148, 69,171,238,102,189, 68, 89, 86,
 17,141,193,119,240,139,183,188,  2, 88,160,137, 80,177,  2, 11, 53,116,206, 10,
 14,175, 16, 72,170, 25, 18,247,106, 76,113,189,223,117, 61,179,143,209,237, 67,
213,244,  1,177,211,195,161,  4,242, 93, 12,166,238, 97,  0,112,100,127, 63,143,
181,221,238, 80, 11,175, 72,220,155,108,138,  7,158, 33,143, 47,250, 71,197, 38,
134,187,109,101,182, 36,204,246, 89,186, 57,106, 82,205,  1, 56,192,160, 11,101,
 48,224,135, 35,238,190,105,206, 63, 51,157, 49,134,  0,244,197, 38,213, 36,176,
  3,
} ;

// ../Source/assign/template/GB_subassign_02_template.c:
uint8_t GB_JITpackage_91 [2201] = {
 40,181, 47,253, 96,165, 72,125, 68,  0, 58, 83, 32, 15, 45,160, 14, 29,235,184,
200,105, 11,209,238,161, 14,166,  2,220,241,140,196,205, 48,  2,159,255,207, 26,
 77, 89,237,229,200,153, 12,187,176,131,248, 10, 94,135,215,  1,167,240, 84,  1,
231,  0,226,  0,230,  0,125,199, 38,185,153, 45,196,171,150, 28,190,206,184,227,
110,253,146, 91,145, 99,113,144,156,  3, 47,140,  3,248, 56, 49,  2, 71,243, 96,
193,185,179,116, 62,247,231,139,133,133,197,194,209,183,251, 40, 79,252, 17,149,
153,236,249,216,184,123,181,109,157,231,183,222, 74, 46,207,206,115,165,175, 22,
 89,103,172,187, 25,211,138, 85,204,155, 37,247, 42,174,195, 48,137,245,141, 86,
227, 77,122, 42,203, 85, 44,134,176,196, 96, 34, 50,175, 34,143,103, 85,203,253,
176,120, 56, 34,141,214, 48,105,223,171,219,211, 51, 51,237,236,106, 52,166,141,
 77, 76, 67,162,162,113,100, 45,186,141,123,115,156,181,207,220,124,219,222, 41,
  2,145, 71,164, 97,  0,242,136,124,194,164, 83,120,138,100,229,142,247,145,150,
 43, 55, 57,167,224,195, 80, 52, 43,175, 67,213,248, 74, 11, 59,207, 14, 46,224,
 63,116,226,238,146,191, 79, 62, 93,168, 75,178, 94,117,150,155,229, 58,199,200,
 35,210,207,196, 88,118, 58, 28, 41, 14,111,104, 88, 52, 26, 26,  2, 89,154,104,
197,144,104,157, 25,187, 95, 76,248,  4,161,176,201, 73, 58,202,164,222,186,172,
 53, 12,127,162, 18,206,100, 95, 45, 71,174,163,191,213,115,123,203,213, 75,238,
 35,175, 13,128,231, 31,238,205,118, 57,163,109,159,105, 87,177,204,118,167,112,
207, 14, 87, 43,188,179,236,139,189,130,188,177,212,236,  4, 79, 61,  9,  2,  2,
167,241,109,145,188,185,241,214, 23, 44,214,133,129,241, 34,113,197,140,195,  5,
225,163, 68,192, 75,197,117, 79,253, 45,104,222,  3,231,162, 68,120,197, 39,221,
 51,167, 71,228,212,129,  2,  3, 34,144,  7,228, 20,  2, 10, 75,213,214,219, 38,
175,212, 56, 94,215, 57,196,125,237, 71,180, 53,138,103, 61, 43,103,157,162,106,
167,245,183, 61,158,153,125,212, 26,231,119, 92,185, 77,110,226,103,169, 81, 52,
 87,241,251,202, 15,200,168,252,194, 49, 77,144, 49, 61,169,  2,165,210,229,167,
 57,  8, 60, 31,186,149,226,173,229, 87,124, 42,107, 58, 57, 89,209,144,241, 78,
231,113,211,153,206,191,143,108,197,222,196,210,114,237, 60, 43, 78,207,183, 49,
157,239,212,187,  3, 64, 37,193,211, 92,209, 52,191, 74,206, 96, 64, 27, 97,195,
201, 88,162,133, 99,193, 88, 42,146,195,104,201,111,219,204, 88, 66,  2, 55, 87,
177,238,188,154,222,185,183,206, 46,189,146,175,114,165,111, 74, 76,252,214, 83,
128,220,113,107,  2,  0,133,103, 39,222,121,111,154,124,130,212,132,210, 97,156,
 12, 12,159, 18, 28, 90,137,118,213,  3,191,213,218, 97,216,  4,146, 79,254,102,
205,121,102,210,243,212,247,231, 54,247,145,164,104, 68, 46, 95, 51,201,105,111,
162,119,  1,  7,217, 67,123, 10, 36,157, 65,132,150,229, 65,212, 68, 56,128,128,
192, 76, 32,170,130,114, 75, 32,121,198,119,122, 66,159, 28,244, 28,  7, 20,200,
116,226, 57,143,111,205, 88,139,114,119, 42, 95,153,113,124, 83, 58,196,  2, 95,
  3, 77,220, 64,112, 52,215,198,130,150, 74,188, 53,219,121, 49,220,217, 91,203,
 12,  6,166, 79,112,201, 31,159, 60,155, 33, 44,  3,139,197,133,188,117,184,239,
233,237,114,223, 10,115,147,191,157,209, 41,185,190,125, 43,253,204, 72,  4, 66,
208,148,145,179,177,192,204,117, 81, 87, 36,235,124, 43,142, 21,  3, 67, 68,242,
135,  8,248, 16, 97, 69,135,204, 85,201, 88,170,136,125, 67,250,132,113,232,200,
 58,227, 78,106, 21,253, 59,176,212, 46, 60,  8,231,179,135,243, 61, 43,146,218,
225,214,219,212, 40, 46,167, 42,153,203, 65,188, 92,164,203, 69,235,196, 21,125,
 90, 55, 60,111, 61,104,226,151, 79,110,129, 30,132, 16, 66,  8, 41,144,  2, 37,
 32,132,144,  2, 97, 80,246, 73,127,209, 42,  8, 77,188, 58,232, 11, 62, 73,161,
138, 93,102,183, 69, 87, 90,  7,133,137,103, 60, 49,156, 79,158,197,230,134, 47,
 79,235,113,103,121,219,214,191,216,116,122, 14,105, 72,196,154,163,132, 83,160,
 83,246,221,158,122, 86,122,197,162,  9,157,210, 36, 72,215, 42,233,133, 66,161,
 83,248,182, 29,105,154,183,129, 16, 33,241, 85,138, 91, 52,183,211,174,210, 83,
214,107,129,247,168,145,173, 66, 70, 70, 68, 68, 68, 36, 73, 65,146, 14,177,  8,
 49,  8, 57,  6,169,179, 58,178,104, 64,200,115, 16,194,112,  4,132,  8, 24, 33,
132, 24,  1, 33,132, 32, 66,  8, 33,136, 68, 18,140,136, 21, 85, 99,254,100, 40,
 10, 21,173, 74,242, 76,146,134,150, 72,  8,242,193, 89,229,154,255,133, 60,185,
164, 23,247,166,  4,175, 98,129,111,179,248,236,216, 54,  8,196,152,254,223,221,
214,154,137,255,196, 99,244,184,159,199,121,  5,117,255,230, 92,178,194,224, 39,
250,103,243,163,163,  6,223, 69,221,224, 29,176,201,255,169, 62,128,160,134, 31,
201, 64,208,182,156,  6, 37,183,147,104,  6,110,  7,230,176,252, 64,119, 37, 95,
121, 14, 15,177, 91,147,225,222,111,  7,200,252, 30,237, 88,195,248, 85, 90,240,
 79,  6, 76,239, 23,154,169,  1, 56,168,116, 12,230,161,225, 55,194,189,225, 17,
191, 90,238,165, 45, 54, 77, 67,215,196,135,  4,180, 92,253,141,134,174,188, 66,
249,150,161, 63, 44, 66,194,128, 26,186,185,150,151, 67,120,200,107,179,162,132,
119, 25,181,200, 75, 86,225,120, 80,  8, 24, 21,  3,162, 66, 53,180,140, 73,190,
 33, 34, 70, 48,113, 99,125,178,176,172,100,198,191, 14,236, 36,174,115,129,167,
187,100, 30, 58, 19,205,226, 88,219, 37,241,219,132,113,196,185,242, 99, 33, 13,
  1,193, 35,153,231,104, 79,200,166, 60,221, 89, 31,195, 47,149, 63,110,206, 27,
201, 68, 87, 91, 16, 36, 95,253, 66,224,235,192,161,223, 50, 21, 38,  3, 86,234,
194,  0,  4,162,197,238,209,196, 61,  2,254,209,240, 68,101,154, 63, 10, 13, 39,
 44,233,234,223, 78,188, 66, 68, 34, 52,139, 14,145,190,  2,176,108,165,159,127,
144, 54,116,102, 16,193,243,254,232, 41, 78, 47,134, 90, 31, 13,245,101, 14,175,
113,132,244,214,156,137,196, 59,120,  0,145,111,169, 61, 66,200,210, 94,  4, 12,
254, 57, 16,130,200, 48,209,152,212,201, 65,  4,220, 54,  4, 24,229,138, 42, 39,
152, 10,249,153,  0,162, 35,185,182,199,134,111, 62,237, 65,127, 31,107,114,223,
113, 92,209,197,133,252,  6,  8,223, 34, 42,155,217, 18,201,133,233,  2, 18,146,
239, 34,207,195, 44, 71,150,164, 73, 41,244,111, 22, 13,145, 84,221,182,152, 61,
 95,127,146, 85,172,239,111,157, 96, 21,179,106,109, 32,218,209,149, 96,144, 20,
238, 55, 36,211,  5,247, 64, 45,214, 97,159, 12,176,153,246, 93, 92,126,133,  4,
103,126,204, 21, 16,109,241,197,132,111,127, 31,  6, 17,131,222,225,144,149,177,
 67,133, 12,110,128, 20,182,217, 15, 94,135,137, 42,202,131,207,156,245,233, 15,
235,174, 48, 40,  2,121,116, 38, 28,116,221,204,  4,154,119,123,204,  7,109,108,
 36,235, 73, 46,163, 48, 37, 34, 83,208, 78, 37, 58,242,114,144,110, 96, 10,  9,
152, 68,191,143,149, 35,167, 48, 85,222, 14,224, 49, 49,236,162, 62, 70,145, 88,
132,228, 66, 57, 13,181,  5,248,223,210,115,242,225,253,116, 66,229,198,226,236,
109,216,166, 94, 93,208,211, 14,177, 63,173,118, 65,247, 69,223,219,145,233,194,
127,253,  5,197, 91, 17, 56,159,216,168,171,110, 13,149,171, 35,189,225,139,106,
 86, 56,144,155,142, 93,243,218, 66, 80,130,230, 78,180, 79,168,195,199, 23, 70,
156, 83,248, 34,228, 42,132,228,  7, 24,158,116, 98,228,254,145,184,195, 81,127,
142, 92,223,208,224,225,102, 10,120,158, 22,169, 88, 62, 72,151, 59,  7,193,253,
 42,100,239, 78, 69,160, 77,196,121, 88,  5, 17, 73,101, 68,159,164, 16, 91, 58,
 30, 76, 91, 48, 48,216,105,146,194,  9, 38, 48,230, 35,103, 55,215,151,229, 91,
 13,147,232,206,244, 60,123, 39,253,  8,  1, 27,138,120,162,246, 56,245, 39,236,
166,223,146,178,191, 45,160, 58, 99,184, 33,135, 41, 29, 71, 41,147, 78, 59, 42,
 78,188, 42,238,139, 12,121,168,111,200,118,252,216,145,103, 79, 53,  4,113,116,
143,102, 81,191,100,141, 89, 17,209,145,100,213,108,165,179,228,171, 14,  5, 69,
163,217, 35, 74,137,199,237,180, 68,158, 89,128,168, 66, 48, 13,120, 23,242,  1,
 25,108, 66, 58,167,231, 11, 70, 39,  1,122,111,197,209,137,230,158, 67, 71,177,
  7,244, 41, 46, 96, 13,104, 74, 12, 25,238, 50,208,194, 54,157,220,250,  8, 39,
202,188,250, 68, 14,246, 89,201, 72,202,173,208,218, 89, 61, 14,191,179, 12, 32,
115,135,205, 80,182,  4,134, 58,  0,204,182,167,244,180,100, 17,212,187,  9, 42,
 14,232,204,134,177, 97, 72,100,250,200,209,158,138,168, 96,254, 92,228,133,120,
213,165,196, 53, 10, 45,241,182, 68,248,215,110, 55,210,113,249, 86, 89,151,224,
128,151,105,236,104,201,162,171, 63,163, 22,203, 71,193, 82, 33, 42, 97,199,117,
148, 32,135, 73,206, 80, 51,151,122,141, 59, 63, 95,122,138, 19,182, 12,211,235,
108,208, 55,146, 94, 36, 99,227, 73,144,157,236, 56, 95,155,178,189,118, 34, 83,
  2, 14,120, 18,202,  1, 23,106,  2,160, 72,137,205, 57,200,145, 76,189,100,187,
240,252,126,116, 70,243,135, 92,204, 19,135,181,164,234, 72, 89, 66,159, 34,148,
220, 30,221, 95,149,248,125,234, 29, 22, 71, 27,246,157, 55,234, 13, 17,213,158,
 65, 51,249,160, 15,217,118,247,119, 53, 40,123, 19,146,106,159, 96,245,172,110,
240,250, 59,180, 76,118,187,219,  7,241, 64,110,140, 69, 26, 38,190,120, 83,229,
203,161,140, 25,100,138,232,189, 47, 44, 69, 86, 56, 25,228, 11, 16, 11,145,147,
233, 68,204,  9,173, 66,155, 38,137, 98, 38,224,  3, 77, 59,110,176, 85, 10, 13,
154,
} ;

// ../Source/assign/template/GB_subassign_03_template.c:
uint8_t GB_JITpackage_92 [1297] = {
 40,181, 47,253, 96, 68, 26, 61, 40,  0, 38,122,174, 40,176,148,177, 14,104, 73,
224,165, 39, 13,142, 53,101,180, 82,222,  8, 69,166,112,111, 34, 15,161,  4,147,
 73, 98,223,  2, 96,126,194, 63,165, 63, 77,239,142, 75,164,  0,161,  0,162,  0,
245, 22,101,235,172,125, 55,227,106,181, 43,215,198,125,189,238,211, 52,217, 90,
223,136, 53,166,146,228,117, 86,139, 30, 88,126, 62, 20,160, 91,  6,151,111,150,
203, 45, 65,185, 16,100, 44,205,105,210,187,110,221,158,164,153,107,111,153,165,
113,109,109,126, 44, 23, 14, 33,130,173, 65,110,227, 22, 29,103,174, 52, 69,167,
244,122,133,144,185,100, 44, 10,152, 75,230,148, 54,189,194, 19, 68, 58,156,224,
250,  8,151,109, 55, 71,175,224,245,105,224, 60,121, 59, 86,227, 43, 61,216,121,
126,144,  2, 95,170, 19,127,215,252, 74, 42, 53,252, 77,229,148,167,202, 38,236,
 86,103, 73,189,174,115,204, 92, 98, 45, 77,140, 37,199,135, 99, 67,231,  5,  5,
 20, 75, 65, 65,178,175,118, 11,243,198,146,243, 56, 88,246,129,209,115,145, 69,
 80, 39,131,240,106,160,128,212,130,  2,  2,230, 85,133,167, 91,180, 41,149, 87,
134,102, 55,113,131, 96,184, 60, 67,190, 29, 27,233,173, 90, 15,247,189, 86,123,
115, 89,126,171,159, 37,189,175, 60,124,157,199, 61,111,174,156, 59,191,143,190,
199,243,148,137,199,100,192, 36, 51,153,100,169,187,137, 91,252,202, 35,146,157,
 82,249, 60, 53, 84,118, 51,123, 19,183, 90,115,209,245,185, 48, 24, 37, 40, 48,
236,130,157,241,215, 29,251, 53,199,226,136,211,209,124,  4,179, 79,  4,188, 70,
 17, 99, 20,146,224,224,252,121,117, 62,119,233,255, 79,161,148, 80, 40,158,236,
242,228,120,182,  1, 17, 19, 19, 31,170,163,218,106, 91,176, 90,106, 53,207, 43,
  7, 80, 22, 17, 61, 85,199, 43,207,228,201, 54,199,176,147,236, 43,172, 67, 82,
  6,205, 51,190,147,228,241,205, 59,158,227, 65, 66,174, 19, 79, 46, 95,155,181,
  6,233,252,105, 78,189,202, 87,102, 28,175, 57, 29,195,129, 23, 68, 40,138, 38,
 70,161, 76,132, 65,142, 67,188, 54,123,243,106,184,183, 87, 42,184,158,225,154,
 95,190,249, 54, 61,176,204, 83,181, 42, 83,181, 51,107,247, 20,141, 83,152, 74,
155,157,172, 35,219,212,244,219,154,211,240,169, 58,225, 77,246,229,114,236,190,
250,235,221,235,236,101, 87,146,215, 11,104,234,125,185,189,103,109,243,190, 87,
184, 39, 71,103, 73,222, 57, 20,202, 73,166, 31,238,251,122,191,220, 87,100,222,
 44,187, 38,153, 84,214, 73,202,140, 68, 28,  8,202,178, 42,203,108,157,175,197,
209, 18, 16,208, 92,130,  2,198, 14, 40,115,  0,113,172,204, 73,232, 18, 89,156,
 88, 19,204, 34, 93,109,190,133, 94,196,196, 75,115, 24, 49,220, 32,147,190,115,
211,190, 24,161,158, 71,253,170, 96, 27,236,226,178,229,184,200,248,181,199, 26,
211, 62,169, 84,226,243,109, 92,231,167, 91,242, 86,133,231,231,  6,230,215,  9,
 50, 14, 48,157, 52, 55,167,106, 83, 16, 56,225,116, 24,103, 67,103,186,128,192,
 41,134, 67,111,250,134, 90,203,113,  6,205, 55,191, 38,214, 81, 81, 24,203, 35,
244,166, 63, 68,136,113, 42, 98,136, 34,128,238,168, 81,169, 82,202,208,136,136,
136, 36, 73, 65, 50, 28, 48,132, 16,100,170,170,230,  1,  2,153, 52, 72, 85,204,
 32, 67, 20, 17, 48, 66,132, 50, 18, 74, 36, 49, 18,136,  4, 98,187, 48,  6,116,
209,  1,129,161,242, 51,193, 61,207,195,177, 64,187,165,145,131,122,162, 27,203,
146,196, 76, 72,178,123, 93,101,  1, 81,192,177,215,184, 83,218,248,251,231,165,
119, 38,220,181,186, 73,158,168,218,234,131,202, 73, 56, 20,204,239, 91,219,103,
 73,136, 46, 93, 53,159,248,142, 39, 45,  0, 25,235,155,252,  1,176, 10,129,102,
 83,230, 65,140,233, 54,183,139,223,243,120, 96, 91,207, 38,126,236, 53,190, 44,
 46, 25, 19,215, 14,246, 73, 48,  1,193, 12, 13,218,145, 16,177, 48,167,129, 19,
 24,  9,140,136, 87,169,168, 40,135,177,199,112,207, 79, 16,220,129,153,123,  0,
 65,115,252,172,107,165,110, 43,198,  3, 25,170,247,206,156,218,143,170,  5, 10,
110,123,149, 31, 32,238, 42,245, 17,  3,  9, 51,127, 18,207, 21, 63,168,  0,106,
 87, 82,150,172, 97,134,104,185,172,101, 77,248,159,240,190, 13,192, 34, 55,186,
237,194, 29, 16,222,214,187, 38,165,131,100,128, 94,165, 16, 27, 13,142,248,138,
232,115,  6,181,160,125, 80,  5,235,225,238,  0, 65,184,238,115, 29,198,  6, 14,
135,135, 29, 57, 26, 29, 98,126,251, 12,203, 69, 17, 38,252,178,242,217, 14,151,
 93,240, 43,169, 43,189, 97, 49,164,120, 10,  5,211,243,174,116, 68,155,209,206,
 22, 33, 60,  1, 27, 41, 96,220,229,236,  6, 13,234,134,  1,248,130,168,  9, 31,
155,133,152,228, 64,176,  2, 92,147,160, 72,  7,187,  9,233, 72,114,160,160, 13,
180,  9,197,  0, 58, 95,203, 16,151, 63,142,190, 57, 50,186,172,127,211,225,172,
148,138,236,149,189,187,207,  3,104,101,218, 21, 15, 21,206,229, 50,144, 91,121,
 25,239,173,172,238, 85,228, 40, 79, 73,229,231,107,162,190,167, 10,240, 27,248,
230,254,141,160,181,215,213, 21,131,201, 82,115, 21,106,110, 95,244,135,220,223,
237, 32,202, 26, 33, 45,116,235,144,237,  7, 59,204,250,138,180,240,110,177,195,
241, 26,172,133, 78,238, 17,152,234,219,160,253,227, 69,114,232, 33, 66, 87, 51,
 36,174,172,177,141, 23,  6,  6, 28,169,153,180,242,170,170,130, 63,144,164, 71,
 30, 43,153,248,150, 71,215, 67, 13, 96,238,126,200, 31,105,118, 27,147, 13, 80,
237,181,111, 46, 81, 11,192, 44,225,252,114, 25, 58,241,162,229, 83,140, 35,246,
 77, 42,136,137, 14,  3, 58,153,155,243,  8,240,  0, 67, 41,148,105, 95, 18, 72,
220,125,211,188,127,102, 50,107,  8,  6,233, 12, 25,170, 35, 16,  6,
} ;

// ../Source/assign/template/GB_subassign_04_template.c:
uint8_t GB_JITpackage_93 [2395] = {
 40,181, 47,253, 96, 52, 72,141, 74,  0, 26, 86,168, 15, 45,160, 78, 25,235,184,
 34,137, 29,221,238,  9,  5,122, 98,180,227,  9,249, 14, 99,232, 62,231,181,227,
120, 56, 65,144,203,252, 58,245, 48, 30, 86, 93,193,235,240, 58,104, 29,158, 42,
241,  0,236,  0,237,  0,151, 63, 50,163, 38,179,165,120,205,111, 92,103,229, 23,
 86,197,198, 73, 64,  9,139,170,114,175, 51,222,180, 87,127,229, 21,220, 92, 34,
 42,223, 60, 43,211,224,185, 13,132,176,209, 72, 92,112,222, 44,149,207,221,185,
195, 97,193,225,136,244,221, 30,202, 18, 63, 68, 35, 22, 91, 30, 54,101,163,150,
101,198,115,165,167, 28, 88,231,107,187, 25,211,122,109,200,155,163,230, 50,109,
220,215,106,219,117,197,171, 47,172, 26,207,200,177, 90,189,224,  7,199, 76,198,
 98,226,212,  0,201,177,154,229,150,112, 72, 34, 20, 72,103, 87,180,238,212,109,
201,145,153, 54,102, 65, 26,211,190,100,  6,114,  1,161,137, 96, 13,186,141,187,
226, 56,103, 29, 89,241, 57,221, 39,  2, 20,  9,  5, 98, 96, 34,161, 92,186,162,
 79, 88,130, 34,196, 35,238,161, 44, 87, 77,110, 62, 61,151,121,200,108,188, 17,
 84,227, 27,237,235, 44,183,231,120,239, 80,137,183, 87,238,110,121, 92,194, 76,
 86, 84,157,234, 28,167,213, 58, 67,138,  4,210,142,196, 56,102,108, 24, 62, 68,
188,161,193,  1,105,104,  8,219, 39,220, 50, 67,171, 21,250, 94,167, 38,210,139,
 40, 30,108, 26,207,190,112,169,172,204,131,152, 11, 11, 78, 68, 88,239,185,  7,
139,135,117,196,108, 88,183,160,113, 18, 27,235,  1, 62, 11,186, 72,146, 80, 62,
 29,152, 80, 38,146,201, 39,  4,152,154,125,163, 38, 50, 37,144,  0,224,128,187,
192, 36,203, 82,163,194,180, 49,172,106,213, 53,106,246,190,113,202, 28, 51,141,
214, 42,126,223,248, 72,103,151,204, 52, 62,209, 45,250,220,170,209, 87,110, 20,
250,206, 24, 43,118,135, 91,226, 45,102, 27, 45,223, 57, 82,169,221,206,167,241,
138,241,162,125,155,195,145, 24,173,145,  7,197,105,127, 98,166,224,248,214, 34,
254, 36,105, 24, 22, 63,114, 70,127, 15,119, 78,253,108,124, 27, 20,111,126,104,
 90, 77, 98, 45, 75,210,155,104,135,176,216,119,198,255, 61,111, 25,159, 36,201,
 69, 21, 40,141, 98,167, 53, 10, 44,223, 56,102,246, 88,222, 71, 48,186, 85, 14,
125, 24,173, 22,247,189,245,234, 44, 31,163,241, 19,214, 89,186, 83,153,105, 63,
116, 27, 20, 84,186, 79,238, 17,  0, 84,148, 55,154,214,252, 90,249,227,241,108,
252,156, 50,227,139,139,169, 59, 52,102,215,165, 87,143, 78,197, 83,185, 82, 39,
 47, 48,126,235, 39, 76, 30,121,133,  1, 96,130,179, 24,207,112, 78,178, 92,122,
147,124,209, 31,148, 12, 12,151, 28,254,108,244, 62,107,205,168, 60,172, 67,229,
150, 59, 89,115,150, 88,228, 56,245,221,185,173, 61, 20, 53, 32,148,199, 87,172,
114,218, 19,228, 46,224, 30,251,103, 63,121,162, 47,128,175,186, 56,128, 26,139,
  6, 20, 20, 25,201, 51, 81, 47, 78,135,202, 51,190,146,243,185,229,158,103, 56,
160, 64,166,242,214,124, 53,232, 83,190, 49, 99,232,100,244,201,229, 57,  6, 26,
 88, 65,177,209, 88, 21,213,187, 64,192, 91,179,149,247,194,141,253,241,192,244,
 14,175, 92,114,203, 49,249,193, 49, 71, 18,165, 30, 17,173, 50, 95,247, 14,  9,
151, 38,211, 37,181, 72, 67, 88,212,115,195, 58,187,240, 37, 26,225, 44, 67,109,
163,246,143, 90, 39, 94, 27,  0,247,180, 91,110,251, 76,183,122,117,142,152, 13,
 14,199,133, 60, 55,220,247,244,110,185,111,  5, 57,227,164, 80,158, 71, 70,184,
169,184,188,  9,203,154, 44, 10,214,249, 86, 12, 41,  6,  6, 74,229, 18, 22, 79,
194,162,130, 17, 19, 22,196,196,133,162,216, 67,162, 71,240,111, 99, 84, 70,173,
111,223, 74, 59,238, 57, 41,157,253,147,206, 89, 80,204,254,102, 79,153,105, 96,
 62, 65, 76, 88, 13, 32,  6, 19, 97, 44, 90, 37,222,232,211, 58,177,188,245, 30,
140, 99,110,121,229,113,239,189,247,222,123,120, 15,239,226,189,247, 30, 38, 15,
247,137,238,160, 77,240,193, 56,117,207, 21, 92,138, 62,245,122,196,110,131,154,
190,111,180,145,  9, 24,207, 88,102, 54,183, 92,114,226,199,211,122,220, 57,222,
182,245,191,131, 77, 37,231, 19,200,  5,172, 25, 70,248,228,249,100,157,179,159,
156,141, 14,113,209,124, 62,101, 17,162,103, 84,228, 62,159,207,156, 27,231,183,
126,194,183,109, 40,211,184,138,  7,112,  2, 93,229, 15, 86,184, 65,114,190,115,
207,182,209, 61, 42, 75,149,229,154,225, 42, 40, 61,223,198,  1,130, 76,168,242,
187,208, 49, 67, 52, 35, 34,146, 36,  5,201,112,242, 24,  4,226, 72,158,  5,155,
216,222,242,160, 44,201,241, 12, 50, 78, 64,136,  0, 17, 66, 16, 17, 24, 66,136,
 33,129,136,136,132, 50, 34, 69,211,140,  1,126, 97,129,255, 78,  7,148,228,209,
164, 51,206, 18,104,194, 65,163, 92,182,254, 66,238, 21,164, 23,114,166,  4,149,
 98, 39,218,172,206,182,178, 13, 18, 84,204,196,143,204,137,180, 54, 48,179, 51,
122,224, 17,127,  8,125,237, 60,166,249,131,128,222,115,204,176, 26,152,143,186,
 65,  8,131, 73,182,211,250, 94,157, 14, 70, 34,235,216, 42, 39,105,144,219,105,
180,114, 66, 93,117,116,  4, 70,171,234,180, 43, 73,137,113,248,135,253, 63, 77,
116,122,133,  5, 16,193, 63, 27, 55,194,180, 71, 77,225,  3, 14,102,207, 11,180,
216, 96,246,199, 17,134, 72,232,195,202,174, 42,154,109, 35,229, 70,218, 96, 51,
 10, 34, 34, 38,238,192, 40,132,127, 78,208,155, 23,190, 62,  8,218, 88,129,149,
223, 20,104,116, 92,243,230, 85,139,209,226,177,224, 65,  0, 33,212, 20, 29, 39,
 42,253,101,232,249, 96,196,133,140, 90, 19, 82, 67,217,105,245,186,  4,205, 36,
230,242,248, 81,226, 44, 31,234,255, 16,220,110, 55,241,161, 12,253,248,254, 37,
116, 52, 68, 72,  2,161, 39,239, 17,149, 73,232,241,  2,151, 57, 70,109, 17, 51,
 95,179,126,145,179,206, 67,  1, 54,  9,157, 88,164, 72,185,140,149, 60,190, 35,
 15,114, 75,248, 62,186, 54,124, 68,203, 71,185, 33, 20,203, 83,210,182,133, 10,
163,196,224,139,  8,105, 68,  1,188,149,195,159, 62, 64,141,184, 25,195,152, 62,
250, 52, 93,251,139, 71,225, 10, 82,  3, 59, 28, 64,120,167,119,253,241,122,112,
 23,202, 54,126, 59,204, 96, 66,160,223,228,247,127, 86,166,161,241, 98, 84,  4,
107, 39, 97, 59,195, 32, 44, 35, 97,171,217,252,237,163,248,227, 48, 83, 27,203,
187,235,211,192,247, 88,246, 47, 81,175,205, 92, 47,174,195,180, 27, 66,104,205,
100,176,136,193,166, 99, 25,233,142,174,  4, 33,102,150,161, 10,146,245,  6,215,
 89,226,253,191, 84, 70, 70,134,186,205, 74,246,194,251,  3, 50, 98, 70,172, 51,
129, 26, 15,226,209, 89, 41,116, 67,235,175, 43,230, 79,213,118,133,160,195,141,
  3,210, 68,104, 26,153, 75,240,251, 64,214, 81, 90,141,117,254,197,206,220,255,
 31, 33,140,145,207,239, 44, 72, 18,240, 69, 35, 12, 96,107, 65,242, 95,170,251,
 42, 93, 61,  8,230, 51, 12, 26,225, 19,196,182, 72,102, 80,166, 78,134, 89,159,
  9, 71,196,106,132,163, 43, 17, 36, 35,  0,247,176,120,174,140,199,178, 13, 69,
 11, 27, 99, 54,168,251,140,131, 55,235, 98,148,189,172,162,  8,206,105,181,227,
216,167,233,208,121, 61, 55,162, 70,192,198,163, 26,205,207, 98,110,243, 57, 15,
197,170,231,194,230,177,102,249, 63,183, 97,108,173, 51,229,160,224,124, 38,103,
 14, 25,133,196, 48,200, 64,242,137, 63,134,128, 35,102,250,200,135, 47,225,252,
 86,137, 13, 35, 17,200, 39, 88,147,114,117,208, 35,112, 71, 79,186,166,206,211,
 24,123, 97, 44,120, 39,147,126,125, 29,182,161, 46,141, 85,150,222,250,124, 62,
  0,182,251, 43,243, 31, 78,242, 85,101,182,132,123, 15,220,120,159,146,208,216,
108,133, 33,139, 55,176, 25, 49,219,  5, 68,198, 43, 20,172, 74,218,226,250,248,
 55,137,213,192, 35, 73,152, 40, 73,173, 32, 85,194, 84, 13,100,240,176,211,140,
186,  4,166,196,129,237,103, 14,235, 24, 74, 86, 67,126,185, 97,205,156,151,225,
 95, 26,240, 18,224,235, 57, 48,170, 63,176,214,223,207,218, 39, 20,168,159, 44,
188,160,182,240,245,190,128,158,128,  3,170,250,196, 43,194, 96, 17,251,208, 76,
161,161,227,231, 12,116,247,180, 82, 80,245, 63, 90, 98,253,152,183, 89,208,119,
 35,137, 53,211,249, 19,249,162,166,180,105,156,141,184, 75, 80,251,  7, 17,  1,
206,216, 39, 21, 92, 52,174,189,201,  3,178, 55, 31,131, 19,236,133, 90, 23,  2,
 45, 91, 97,125,194,157,164, 87, 32,147,192, 44,  5,159,212,120, 75,200,163,240,
 49,143,230,181,224, 61,156,192,142,112, 81, 46,211,  7, 50,176,102, 97,145,149,
251, 50,196, 88,245, 49,253,157, 63, 64, 75, 16,210, 74, 97,116,191,  4,179, 58,
 25,206,106, 82, 60, 84, 71,  3,  0,214,  5, 87,124, 44,103,210, 99,134,181,  3,
 82,160, 21, 76, 40,208,227,253,244,228, 17,218, 47, 84,196,124,214,127,116, 96,
136,231, 23, 72,116, 82, 45, 18,207, 36, 64,184,237, 54,187, 44, 84,205,162, 20,
  6,145, 87,193,163, 68,169, 63,218, 67,236,230,100,243, 45,175,214,253, 17,229,
 86,229,133, 84,168,186,183, 77,114, 37,  4, 26, 37, 85,150, 73, 14,104, 39, 19,
136,180,204,192,253,137,130,136,118, 17,125,141, 21,212,126, 30,168,242,158, 95,
197, 49,118,228,219, 17, 44, 15,111, 91, 63, 70,168,163,  8,163,196, 47,254,130,
 93,153,188,187,201,185, 99,211, 28,147, 50,249,  2,137, 79,215,238,103, 76, 20,
251,223, 79, 76, 46, 69,116, 76, 67,140, 91,192,108, 77,119, 76,161, 65,248,227,
205,249, 43, 68,203,141, 97,  4, 67, 92, 62,149, 71,209, 53, 84,151, 12,204, 63,
 40,201,138,191,178, 94,224,134, 19,193, 82, 16,211, 46, 60,159, 95,164,253, 29,
207, 83, 59, 63, 76, 62,184,171, 26,133,115, 50,238,130,184,168,205,246, 71,221,
197, 95,118,169, 64,212, 32,144,194,204,234,173,192, 12,230,248,234, 18,108,153,
152, 96, 79,167,128,137,217, 29,181,152,129, 97,  4, 71,131,102, 82,251,157,105,
 82, 35, 85,246,172, 15,235, 21,199,153,153,193, 37,128, 68,195,214,112,250,207,
236,120, 36,194, 75,240,248, 61,148,224,204,120,217,140, 79, 82, 91,192,222,148,
161,127,112,116,224,153,102,159,232, 12,188,213, 77, 85, 84,158,255,155,159,162,
161, 76, 18, 45,175,252,  9,194, 83,154, 57,  0,203,  3, 62,178,127,119, 72,197,
170,253, 23,167,122,147,171, 77,181,  9,159,251,135, 21,137, 41,111,139,218,  6,
 67,101,244,  2,212, 94,209,223,229,119,170, 10,  9, 43,115,150,190, 64,140, 68,
 43,135, 49,147,205, 70,138, 37,152,235,200,159,  6,120,164,101, 28,234, 12,221,
 52,219,  3, 51, 33, 34,204,206,200, 15,121, 90,237,159, 64,
} ;

// ../Source/assign/template/GB_subassign_05_template.c:
uint8_t GB_JITpackage_94 [1855] = {
 40,181, 47,253, 96,122, 39,173, 57,  0, 74, 79, 96, 14, 45,160, 78, 25,235,242,
 94,179,178,199, 46,128, 42,228, 73,113,225, 43,245,135,105,248, 93,213,243,  0,
115,214, 79,109, 21,213,137,144,  4,  2, 13, 87,240, 58,188, 14, 90,135,167, 10,
216,  0,211,  0,219,  0,109,255,153, 80,131,217,237,205, 47,157,159, 26, 60,233,
164, 44, 22,139, 75,182, 93, 23,228, 11, 74,141,235,115,108, 37,228,104, 25,189,
 30,134,133,119,178,229,170,125,122,184,207,254,181, 77,129,255,129,217, 43,237,
138,185,149,237,236,187,109, 46, 69,150,123,147,209,140, 79,224,121, 58,161, 71,
190, 44, 57,158, 55,159,240,186,229,174,119,242,233,133,192,195, 35,197, 46, 87,
141,135, 71,196,193,216,  5, 53,234, 83,229,230,244,157, 28, 43, 14,182,147,175,
182, 56, 26, 72, 96, 30,145, 61,149, 45,103,110, 47,118,209,153, 75, 73, 93, 34,
 16,121,136, 56, 12, 64, 30, 34,143, 46,232,146,109, 15,148,248,131,250,  7,187,
 52,107,205, 37,139,178, 68, 96, 26,172, 19, 19,219, 10, 53,139,111,111, 86,195,
 58,157,151,188, 66,  9, 47,251,201, 15, 84, 16, 81,  2,169,  2,185, 79,124,161,
212, 50,190,143,192,195,155, 23,109, 45,220,108,246, 69, 76,220,193,161,225,112,
112,  8,124,205,182,191, 19, 90,150,255,108,118,187,196, 22, 94,191,182,210,  9,
 51,154,208,  5,149,  2,182,216,215, 54, 12, 74,229,239,197,181, 35,124,228, 58,
210,  4,185,115,232,177,171, 66,182,112,246,230,240,216,237,  9,247,150,105,180,
141,105, 98,164, 89,165,135, 81,219, 30, 39,124,156, 27,229,156, 55,179, 47,102,
199, 73, 53,203,181,210, 75,130, 76,162,142,212, 80,245, 15,118, 65,126,165,  8,
254, 71, 20, 85, 80,198,156, 16,188,224,172,226,182,207,212, 74,149,148,240,149,
 61,244,124, 97,229,219,217, 25,187,255, 36, 97,214, 87,171, 56,189,103, 75,165,
228, 25,202, 66, 57,171,162,176, 40,138,151,161, 96, 28, 80,188,232,225,  7,230,
  1,135,131, 62, 57,132, 45,196,180,247,152,237,147,148,218, 73, 47,190,118,203,
238,126,201,221,211, 80, 38, 36,215, 88, 21,139,  2,139,210, 60,  7, 26, 76, 69,
177,119,211,248,226,255,223,104, 84,104, 52, 62, 55,153,228,149,163, 44,192,184,
132, 85,208,171,135, 69, 76,116, 42,236, 98,188,  3, 37,132,164, 57, 24,159, 28,
227,247, 13, 40,112,103, 75, 14,161, 96, 94,166, 66,131,169,100,156, 69,145,120,
149, 94,173,235,101, 57,190,161, 97, 30,226,146, 63,124,242,216,208,212,  0, 93,
245, 13,  8,143, 32,210,213, 25,156,159,  8,177,220, 34, 99,151,125, 52, 33, 27,
 33, 87,236,190,108,155,175,148,115,237, 90, 70, 15,179, 11, 88,181,  0, 44,181,
237,178,246, 59, 55,122, 73,210,220, 62, 65, 30, 89,110,178,173, 35,121, 84, 65,
167,184,138,197,122,148, 75,197,187, 76, 84, 44,139,138,176,176, 34, 73,130,110,
239,121, 54,199,225,206,126,117,190, 90,218, 79,146,165,132, 21, 98, 30,179,  0,
181,178,179,102,207,185,194, 27,104, 60,172, 83,128,118,155,240,221,238,100,  9,
 61,189, 73,224,211, 89, 43,107, 31, 44,178,189,216, 51,157,133,  4, 22, 36,156,
180,111,199,  8, 63,169,  8,  2,177, 79,190,156,141,198,133, 43, 55,203,245,179,
110,151, 43,103,180,132, 17, 77,134, 98, 93, 42,  0, 34,  0, 34, 40, 18,249, 86,
106,223,196,192, 16,145,188,178,176, 42, 11,247, 38, 46, 21,137, 11,133,235,169,
189,196,156,150,167,247, 24, 23,220,108,180,110, 62,185,115,246, 64,236, 82, 82,
 83,  4, 67,101, 24, 52, 52,188,232,143,199,235, 52,116, 10,151,161, 40,214,115,
144,161, 46,149,136,199,217, 28,103,183, 75,216, 74,110, 52, 46, 60,200,163,158,
123,116, 90,246,180,124,  3, 58, 47, 57,234, 31,141, 94,159,162, 83,147, 67,159,
224,167,  6, 15, 94,233, 35, 64, 78,221, 61,160, 88, 23,215, 85, 55,213,239, 52,
103,180,205, 46, 81,208, 88,148,171, 24, 24, 30, 85,218,165,205,166,111,223, 78,
160, 20,167,255,145,147,186,134, 28,132,228,145, 35,243,140, 92, 39,154, 44, 61,
238,186, 21, 94,251,156,187, 92,  7, 99,161,160,162,194,226,156,228,188,205,190,
 17,116,142,118,199,227,228, 87,105,159, 60, 99,118,  2,129,117,168,113,169, 82,
134,102, 68,  2, 17,  9,146, 36, 73, 58, 81,  8, 66, 20, 37, 33,117,212, 60,194,
136, 60, 72, 66,  9, 34,132, 40, 67, 16, 33,  2, 66,148, 72,  4, 67,  2,145, 64,
  2, 17,  9, 68,196,108, 58,116, 36,  1,240,247, 68,184, 60,133, 29, 22, 40, 26,
130,181,213,134,213, 36, 39,220,179,  2,230, 74,120,249, 18, 41,167,254,138,146,
 89,156,148,191,221,214,228, 39,107,171,201,159, 51,202,187,108,201, 35,134,119,
 91, 94, 68, 81,164,117, 24,213, 28, 20,173, 90,102,246,134,201, 95,161, 64,164,
 75,165,116, 92, 60,152, 21,160,178,178, 60,215, 22, 48,187,107,159, 62, 48,157,
195,170,143,201,166,216, 14,172,125,227, 74,142, 66,232,120,188,212, 41,115,110,
125,237,227, 80, 93, 93, 92,203,227, 99,100,134, 36,154,  0,  7,144, 33,131,198,
150,167,100,159, 66, 19,101,215,182,239, 42,152,243,194,187,194,238,156, 63, 80,
 65,254,167,138,221,167,152,218, 66, 61,247,123,216,227,149,190, 88,128, 71,114,
221,249,122,189,113,158, 17, 16,155, 99,  2,140,132, 36, 73,160, 37,206,153,155,
159, 37, 52,246,100,152,240,239,191,226,184,224,190,190, 44,151, 67,105, 37,207,
198,106,234, 42, 45, 77,  2,109,255,109,197, 61,207,193, 86,240, 92,133, 11,111,
127,174,152, 93,208,141, 20, 39,149,187, 40,131, 94, 84,178,112,125, 55, 96,203,
131, 85, 81, 74, 81,  1, 70,182,140, 76, 48, 15,199,  5,176,201,164,111, 69,115,
145, 96, 34,127,127, 74,207,151,109, 76,160,169, 54,231,214, 42,233, 43,  0,137,
131,131,123, 54,147, 16,130,222,211, 90,174,174,241,107,146, 28,254,155,132,224,
193, 56,155,  2,164,163, 39,190, 12,211, 80,207,130,137, 53, 70,115,221,124,137,
141,202,211, 57,220,109,231,127,101,190, 31, 20, 38,255,151,225, 38,169,154, 66,
 13, 37, 43,109, 11,245,163,  2,225,220, 38,155,221, 65, 64, 49,133, 10, 83,129,
 64,194, 38,211, 67,102, 68,144, 30,130,208,106,173, 57,191,164,144,230, 43, 13,
 36, 79,231,106,130,177,204, 52,174, 88,109, 50, 22,147, 56,  9,180,107,193,184,
145,103,225,226,172,146, 34,102,146,114,104,212, 94,180, 64, 79, 48,153,  2,146,
 76,161, 34,121,103, 88,130, 96, 28, 50,116, 72,  1,186,207,253,252,  6,239,  6,
  3,172,213,245, 17,232,  4, 33, 49, 89,  0,160,248, 65,143,248,136,158, 66,175,
 88,231,237,143, 90,251, 41,  3,129,242, 74,131,211,102, 33,206,193,210,142, 67,
170, 64,229,195,102,236, 27,236,171, 46, 23,153, 26,127, 63,226,253,186, 35, 75,
190,  8, 51,201,187, 20, 31,130, 53, 77,161, 36, 68, 58,  3,158, 41,168,172, 44,
243,107,187,188,132,107,171, 63,136, 18,215,248, 40,247,205,174,188,224,188,114,
192,183, 80, 87,142,162,100,232, 30,218,159, 21,250,203, 93,207,227, 78, 84,241,
244, 44,248,102,113,169,249,140,250, 74, 89,220,242,129, 62, 31, 44,196,188,146,
109,200,232,226,117, 78, 40,127,186,129,190,  4, 48, 24, 23, 99,196,138,149,  7,
225,233, 28, 65,237,107,150,106,115, 18,196,113,209,130,153, 51,140,100,130, 76,
163,136,200,205,148, 72, 62, 91,165,167,181, 17,111,174,197,156,203, 20, 22,223,
138, 32, 13, 45,191,124,155,221, 28, 55,132,247, 34, 49, 28,195,118,141,154,146,
 72,161, 91,160,119,174,142, 81,180, 39,238,132, 41,251, 55,  7, 16, 73, 15, 63,
159,122, 28, 69,182,136, 95,209,127, 17,188,254,  4,146, 25, 51,100, 19, 40, 15,
 61,144,106,254, 83,184,223,103,199,  9,148, 66,193,  7,100, 12,163,122, 97,186,
 25, 80,135, 84,137, 19, 43, 21,141, 14, 86,114,187, 26,197,183,167,  8, 77, 56,
 17,224,106,162, 76,222,142,137, 38,140,242, 84,168,177, 55,  9,188,222, 99,214,
138,195, 95,143,182,226,202, 32,118,205,223,115, 34,235, 33, 64,207, 99,188, 91,
151,168,221,149,183,188,153,155,226,133,202, 96,211, 83,137,126,124,174,153, 99,
 11,105,106, 64,152, 46, 61,129, 92,148,162,135, 23, 40, 56,187,157, 13,103,232,
225, 98,103,113,170,105,156, 50,131, 89,254, 16,242, 48, 49,139,114, 29, 81,246,
 77,179, 72, 49,211,156,241,129,209, 23,255, 84,147,129, 24,
} ;

// ../Source/assign/template/GB_subassign_05d_template.c:
uint8_t GB_JITpackage_95 [1369] = {
 40,181, 47,253, 96,  3, 17,125, 42,  0, 54, 59,179, 40,176, 22,217, 28, 84, 52,
127,  7,122,196, 67,237, 16, 90,210,226, 73, 82, 91,232,  3,127,198, 52,186, 13,
 94,248,150,214,192, 27,254, 41,253,105,208, 31,236,  2,166,  0,168,  0,169,  0,
152, 94, 23,239,101, 72,193, 92, 61, 98,135, 33,239, 18,191, 61,183,116,187,204,
182,113,139,225, 45,156,204,126,237, 47, 23,233, 71, 55, 60, 89,164, 69, 58,119,
189,220, 87,116, 80,144, 80,105,111,163, 33,117,139,216,181,171,217, 54,183,169,
 52,182,189, 85, 78,133, 67,211, 41,224,186, 68,108,220,216,113,246, 68, 42,246,
239,163, 46, 23, 18, 14, 18, 42, 13,  8,  7,  9,159, 54,233, 18,215, 18,170,121,
  1,245,144,151, 47, 88,181,203,140,226,100,188,144,138, 19,150,198, 34, 13,179,
206,117,204,162,239, 27,187,227,250,234, 45,182,103,114,208, 49,135,184, 30,170,
 91, 58,211, 47,  4, 59, 79,110,225, 96, 90,145,138, 49,245,140,120,102, 38,110,
 96, 16, 85, 12, 12,  2,210,  2,195,216,152, 28, 27, 76,163,174,105, 85, 27, 78,
 54,113, 95,123,243,196, 90, 13,199,162,184,152, 23,230,104,139,158,196,217,206,
235, 22, 70,113, 42, 75,115,169,191,157,221,204,140,136, 63,118,244,182,115,125,
 82,113,229,163, 35, 73,255, 94,239, 91,190, 22,105,231, 17, 74, 20,165, 92, 62,
229,169,192,144,109,189, 20,177,117,171, 95,207, 75,122,  7,163, 51, 45, 48,107,
227, 63, 74,  4,242,182, 53,128,154,150,133, 73,188,107,206,142,  1, 81, 84,128,
187,138,223,231,229,106,242,208,215, 98,198, 35,248, 92,159, 71,113,124, 40,215,
144,165,239, 18,234, 85,246, 90,138,195,201,184,  0,199,109,163,189,181, 56,171,
190, 37,111,163,152,113,227,143,118, 33,120,183,249,  9,135,120,198, 98,237, 62,
239, 42,  1,193,195,229,  7,199, 72, 19,130,220, 42, 72,109,136,147,250, 27,185,
246, 54,252, 73,154,224,104, 47,222,238,225, 67,240,158,130, 34, 84, 12,185, 90,
 85,175,170,234, 85,212, 85,206,246,132,  1,152,184,206,235,223,189, 30,142,117,
129, 89, 22, 83,219,116, 53,  0,162,210, 97, 40,131,182,191,146,107,  2, 73,183,
 60,226, 90,149,129,105,217,180,200,168, 73,  2, 93,143,172, 78,135,230,193,220,
115, 61,111, 85,204,184,197,129,231,233, 80,107,173,158,231,121, 23,166,117,176,
189,219,101, 24, 94, 23, 87,136, 74,  5, 48, 97, 76,141,197,201, 92, 25, 21,210,
 53,204,202, 50,234, 58,103,233,171,231, 22,185,220,186,196, 66, 84,174, 19,252,
210,225,  1, 81,202, 36, 65, 90, 70, 85,147,199,211, 81,138,148, 18, 84, 73,175,
230,205,115,118,116, 48,182, 99, 30, 82,133, 31,  7,213, 74,128,249, 31, 46, 63,
230, 87,104,121,108, 48, 12,173,178, 52,166,230,218,100,147,186, 38, 40,172, 51,
159,175,253, 40,174,  7, 81, 58,212,165,109, 50, 51,219, 76,128, 11,  8,116, 35,
151,  1,204, 52, 82,101,124,243,113,182,245,134,175, 66,  4,  2, 57,133,161,124,
 36, 37,103,251, 50,227,121,133,210,169,206,212,172,137,207, 53,189,204,196,  8,
174, 33,207,237, 61,215,153,138, 29,222,183,231, 55,127,122,119,159, 57, 91,187,
 63, 92, 62, 89,164, 69, 10,249,184, 38,230,251,232, 51,253, 71,188, 38,191,246,
184, 47,103,219,203,207,152,126,159,129, 29,168, 65,189, 51, 68, 34, 34, 35, 73,
 65,146,202,112, 97, 12, 98, 24,116, 20,181, 14,226,184, 52, 20,194,148, 66,208,
200, 17,  9, 68, 66,  9,146,119,178,230,  1,176, 20,112,118,149,147,242, 80,171,
118, 43,195,244,105,230,137, 49,129,128,206, 57,115, 66, 34, 87,129, 56,124, 38,
243, 71,244,228,135, 46,191,139,246, 83,117, 56, 50,103, 57, 40, 86,179,249,236,
125,  1,240, 16,103,117, 58,163,234,228,136,204,195,188,220, 58,206, 61,181,175,
212, 58,196, 94,254,239,162,151,145,104, 98,253, 34,207,185,232,125,151,234, 48,
 25,  6,205, 24,226,215, 68,222,120, 68, 25, 78,200, 65,245,239, 17,128,173,130,
123, 38,179,250, 12, 53,212, 90,170,147,205,127,117,139, 16,193,149,200, 32, 44,
 13,129, 55, 72,195,223, 99, 60, 54,114,108,159, 65,148,137, 50, 61, 92,236, 11,
 56,129,109,144,117,232,210, 13,236,193,137,153,170, 68,179,171,214,146, 20, 45,
178, 71,176, 16, 72,138, 17,207, 33,194,247,168, 26,192, 19,249, 65, 46, 83,150,
227, 97,216,209, 20,180, 24, 57, 26,131,210,244,  7, 19, 54, 58,200, 42, 29,168,
 92,190,134,227, 13,253,139, 21,136,195, 17, 81,235, 60,119,169,144,136, 49, 92,
 61,156,  2,230, 92,232,  3,123, 95,168,  5,174,173,110,247,104, 92, 64,128, 67,
 13,255,196,216,197,195,134,135,166, 46,129,175, 43,186,  7,231, 27, 43,130,250,
183, 27, 27,185,  8,143, 58,220, 39, 68,171,116,109,  0,227, 83,220,248, 89,148,
 71,240, 93,251,168, 98, 21,214,173, 98,120,209,247,  0, 75,102, 98, 16,210, 87,
 36,155, 25, 73,169,112,188,225,105, 58,252,127, 50,  5, 55,168,117, 22, 20,137,
133, 90,232,221, 83,216, 93,149,178,148,191,177,221, 63, 25,139, 88,130, 27,143,
200, 91,115, 83, 22,113,220,121,195, 53, 77, 55,157,124, 99, 13, 48,190,  2,110,
117,198,152, 14,248,247,132,237,  9,195, 12,128,208,225, 58,207, 80, 13, 38,139,
 41,170,  1,164, 76,180,200, 14, 47, 20, 75, 20, 39,172,240, 39, 80, 55, 15,201,
122,201,189,103, 12,187, 18,250,122,106,253,250, 14, 76,190,241, 25,101,219,248,
 32,112,219,152,252,143,105,128,188, 83,159,231,219, 52,218, 56, 32, 37, 62,250,
229, 63,  5,103, 46,189, 16, 52, 81,197,109, 39,  9,194,137, 78,220, 17, 19, 62,
 96, 61, 44, 23,154,134, 47, 40, 73, 32,241,192,115,140,199,148,203,105, 70,110,
119,239,163,247,179,234,126,125, 34, 59, 16,120, 79,167,188,100, 20, 65, 76,230,
 66,108,115, 14,147, 61, 21, 14,246, 25,240,105, 90,210, 67,138,218, 50, 84,199,
168, 15,168, 32,170, 46,157,185,161, 75,153,158,130,199, 92,182,112,253, 93,162,
222,110,184,177, 70, 18, 13,236,244, 31,  4, 70,205, 55,130,  1,186,129,179, 81,
204, 89,162,  4, 78, 21, 98,114, 62, 50,  0,148, 61,180,105, 94,127,102,154, 49,
  2,  4,244,197,111,165, 14,  0, 15,
} ;

// ../Source/assign/template/GB_subassign_06d_template.c:
uint8_t GB_JITpackage_96 [2811] = {
 40,181, 47,253, 96,230, 84,141, 87,  0,186, 81, 24, 15, 45,160, 78, 25,235, 62,
193,137, 29,109, 70,180, 46,198,196, 96,131, 47,245,195,112,212,105,138,129,224,
130,142, 51,100,117,  7,146,  8,249, 61,131, 43,142,167,240, 58, 56, 29, 94,169,
223,  0,227,  0,231,  0, 87,135,109, 20, 55,229,104,155,  5,220,101, 25,235,220,
181, 49,220,244,102,219,223, 46,127,164,214,142,155, 90,166,156, 55,231, 25,119,
218, 29,109, 55,107,201,160, 55, 79, 13, 86, 42, 23, 23,173,187,174,217,215,172,
 92, 95, 25,239,246,254,148,175,238,102,220,184,206, 14,167,109,151,252,224,  9,
191,229,191,108, 27,247,229, 62, 97,141, 39,173,243,125,231,225, 49, 59,111,249,
195,142,233,227,159,230,155,189,228,210,244,166,232,216,150,229,182, 56, 30, 34,
 17,144,206,174,201,193, 79,183,105,135,102,219, 88,  5,105,108,251,162, 21,136,
  3, 74, 38,130, 53,232, 54,110,235, 56,103, 30,106,189, 86,248, 71, 32,226, 33,
  2, 98,  0,226, 33,226,210, 21,253, 97, 10,154,148, 71,224, 67, 89,222, 52,186,
249,211,192, 10, 69,198,205, 91, 49, 53,190,147,211,116,166,157,198,  1, 63,249,
  4,148,136,159, 58,207,202,105,157, 37, 86,224, 65, 90, 15,197,120,114, 58, 44,
 41, 42,238,224,224,128, 56, 56,  4,216,236,155, 61,252,193, 51, 91,  9,111,193,
206,232,148, 10,165,224, 34, 33,101,193, 74,164, 40, 31,219,101,215, 49, 72,157,
 93,133,134,239, 79,181,107,157,119,102, 46, 92,136,223, 88,148, 70,  3, 59, 20,
179,253, 63, 41,  3, 94,106, 56,149,121,176,145, 81, 20,125,163,129,209, 34, 61,
200,189, 12, 24, 89,104,160, 69, 58,128, 29,202, 32,153,128,228,249, 44,219,  2,
197, 19,144, 45,  1,132, 17, 90, 54, 21,133,212, 84, 19,137,169,140,175,219,102,
183, 11,231,142,179, 52,183,231, 14, 13,135, 99, 67,114, 41,203,  1,  5,158,199,
210,139,214,150, 48,122,  6,147,145, 22, 22,213,224,191,134, 67,194,219, 82,  6,
 40, 41,202, 74,240, 78, 99,182, 99,  8,217,249,  6,205, 44,194,153,128,196,124,
 27, 91,138,209, 86,234,208, 99,109,226,119,158,125, 51,110, 44,209, 90,103,116,
123, 59,231,201,221,118,150, 59,213, 31,105,143,157,217,245,220, 91,247, 80,166,
 56,211,247,135,111,115,161,204,206,235,241,143,196,111, 88,  7, 49,198, 24, 51,
164, 12,  0, 15, 16,224, 29,117,116, 77,  5, 50,136, 72,119,203,215,236,252, 93,
244,182,109, 79,244,218,246,246,  7,235, 76, 67,245, 82, 44,196,233,236,134,105,
182,249, 35,146,118,183,206,102, 67, 93, 61,243, 24, 81,168, 54,136,230,171, 59,
157,190,157,101,218,151,138, 74,110, 21,234, 98, 81, 22,114, 83, 45,136, 49, 70,
 76, 37, 99,169,114,227,219,110,206,241,204,190,137, 23,214, 70, 35,223,211,176,
165,248,182, 43,104,158,195,129,207, 23,189, 25,247,109,248,179, 60, 64, 41,205,
178, 12, 90,155,204,227,184,138, 75, 69,185, 80, 25, 11,140,164, 80, 21, 10,203,
197,  2, 24, 93, 67, 85, 20, 22, 12,  4,  0, 27,127,  7,254, 96,244,  8, 11, 11,
211, 64, 58,168,172, 13,180, 72, 42, 86, 21, 77,227,218, 27, 13, 63, 16,125, 58,
196, 17, 92,130,248, 36,250,159, 49, 53,249,247,162,111,214,113, 13,  8, 59,183,
 61,119,214,207, 99,172,219, 94,123,195, 35,  4, 92, 13,178,143,127,242,207,221,
 48,222,149,211,109, 24, 14,142,142,225, 19,135,165,205,241,108, 21, 70,135,216,
  6,  5,161,178, 48,155, 72, 49,128,144, 62, 30, 33,132,239, 17, 47, 40,148, 37,
 41,150, 74, 35,161,165,  2, 90,153, 56,105,152,196,200, 65, 60,222,123, 48, 35,
 55, 84,197,  7,202,140, 66,131,158,229,207,159, 68, 65, 66,242,143, 52,189, 41,
146,124, 66,132, 73,158, 19,151,128,120, 23,213,166, 13, 97, 17,111,224, 30,179,
126,  2,101,198,151,118, 62, 51, 94, 66,185,137,233, 43,220, 74,220,225, 72, 88,
209,128,248,228,193,129,209, 47,152,106, 83,109, 44,152,145,239,229, 43,161,196,
244,136,236, 70,243,117,143,209,124,  7,196, 31, 39, 70,207,141,181,214,254, 50,
 98,244, 56,129,123, 60, 36,206, 93,242,135,136,230,153,113,212,181,195, 58,187,
112, 36,181,206,114,231,180,237, 83,243,204,203,113,159,234,148, 64,224,251,118,
134,241, 39, 93,185,255, 32,111,140,130, 40,246,105,138, 18,108,175,247,240,247,
228,150, 37,  5, 58,229,131, 12,198, 49,225, 33,130,116,109,117,130, 48, 87,244,
131,  0,168,146,164, 80, 33, 51, 52, 34, 34, 73, 10,146, 66, 99, 98, 24,  8,  4,
194, 56, 78,243, 64, 85, 61,146,128, 48,209,224,  8, 68,113,  8, 49,138,  8, 12,
 33,  2,162,  8, 34, 50,145,  4, 18,145,136,136,216,164, 57,133, 65,160, 18, 53,
143,148, 19, 90,188,193,183,  9, 29, 42,  1, 98, 23,140,240, 98, 97,137, 50, 61,
170,228,  9, 48,191,208, 71,151,107, 48,185, 26,178, 76, 32,255,172,159,  1, 75,
226, 67,125, 68,115,180,131, 42,188, 60,200,149,206,158,159,121,131,  2,125,131,
 94, 41, 81, 93,212,234,103, 64,210, 17,250,199, 55,154,107,126, 15, 29,203,237,
161,118,154,250, 61, 25,143,231,  2,134,144,151,160,148,132, 71,104,199, 91,143,
112, 16,193, 30,  9, 85, 76,  2,116,109,152,151, 78, 68,148,242,163,201,198,252,
218, 63,129, 50,221, 58,191,108,190,140,207,124, 27, 77,210,233, 68, 86, 99,119,
 41,230, 58, 41, 33, 28,  0,136,173,101,231,243, 30,122,172, 36,191,218, 17,147,
121,205,186,195,192,135, 40,109,119,185, 24,133, 92,165,112,114,203, 33,163,112,
  0,235,155,254,241, 73,187, 70,149,208,241, 31, 16,136,132,221, 83,200, 96, 11,
163,248, 14,178,238,232, 33,191,186,127,249, 92,172,223,215,212, 21, 33, 68,231,
 59, 11, 99,136,227,225, 11,182, 16,224, 66,202, 32,  8, 92, 96, 78,  5,142,204,
  4,168, 75, 92, 64,  6, 62,185,  0, 16,141,137, 97, 48,193, 44, 48,116, 40,136,
157, 72,160, 13, 32,160, 80, 28, 56,103, 48,208,  0, 20,176,106,  7,131, 24, 48,
  7,  4,248,  5, 25, 68,  4, 23,200,170,  2,126,161,233, 35,  2, 23,159,168, 12,
184, 94,166, 23,223, 92,113, 92,254,238,122,244,145,188, 94, 30,182,212,123,  7,
211,155,206,236, 42,226,148,218, 68,193,144,239, 26,195,241,254, 24,129,120,211,
 37,188,179,192,203, 23,120,224,187,166,211,251,174, 23,238, 58,106,111, 93, 95,
159,137, 76, 81, 83,164,  2, 38,116,129, 92,106,121, 77,214,215,226,223, 39,138,
 82,171, 71, 48, 82,  6,183,201,103,246,224,226,233,144, 67, 30,105,190, 58,140,
 81,138,192, 94, 18,185,187,203, 28,100,177,188,112,255,219,184, 26, 23,170,186,
 45,245, 61,198,229,199, 65,  3,169,170, 44, 91,111,153, 19,163,247, 52, 68,197,
106, 49,141, 86,138,229, 10,177,157,106,155,175, 26, 50,213,131, 85,200,103,237,
 79,166,109,125, 84,209,152,116,118, 85, 88, 26,160, 37, 94,234, 86, 34,188, 53,
 66,102,  6,193,146,160,160, 36, 66, 31,111,156,210, 21,105,165,214,  5,147, 42,
 14,123,252,166,151,243,171,138,180, 92,166, 67,190, 81, 49,175,176,134, 14,104,
109,234,176,246, 21,168,169, 30, 10,187,114,207,113,101,228, 14, 18,172,255,153,
159,101, 21,178,177,243,185,215,192, 50,101, 48,206,164,105,242,211, 41, 50,130,
 40,174,230,124, 89, 52,199, 16,167,213, 97, 18,200,107, 34,145,217,228,240,189,
 54,164,250,231,116,224,248, 55,235, 81,151,119,164,243,190,111,169,137,219,155,
153, 93,188, 41, 52,253,167, 92, 23, 50,247,230, 40,193, 35,115,170,128,222, 26,
 32, 82,115,138,180, 45, 33, 52,161,181, 53,157, 17,113,215,195, 73, 15, 31,156,
117,195,102,157,157,  4, 62,102,201,215, 81,119,121, 69, 38, 30, 54,233, 58,250,
133,128,113,193,181,238,  9,213,  8, 26,205,186,106,113,181, 47, 20, 40,165,166,
 30, 29,145, 62,151,193,167,248, 76,238, 10,103,152,145, 90,174,153,153, 58,133,
132, 90, 29, 14, 26,224, 80,171, 58, 66, 40, 25, 73, 19, 51,226,204,170,231,133,
159,167,121,217, 91,157, 73,115,184,126, 18,228,166, 44,247, 12,232, 41,149, 22,
218, 89, 70, 61,104, 92, 51,121, 88,233,181, 78,114, 74,162,215,119,200,106,133,
187,216,227, 55,105,210,130,245,230,155,240,195,113,104,204,119,127,241,153, 48,
187, 13,223, 47,173,224,210, 96,200, 46,170, 66, 20, 56, 52,197, 64, 96,204, 66,
125,130,208, 84, 63,244,235, 96,191,238,  1,174,  1, 52,234, 89,220,161,134, 19,
193,145,146, 38,209, 96,127,203, 41,221,243,237,164,163,143,  0,116,  7, 57,211,
 19,117, 87,242, 69, 66, 64, 27, 29,148, 56,178,197, 36,  2,122, 94, 61,113, 78,
181, 22,113,114,206, 77, 40, 66,105,204, 79,145,231, 83, 61,232,186,151,195,255,
187,208,200, 52,242,231, 84,198, 81,155,209, 37, 73,136,148,200, 95,170, 99,146,
210,124,242,123,184,216,218,143,173,230,218, 44,236,211,109, 94,112, 44, 69,178,
 17,101, 31, 10,101, 61, 15,106, 71,  4,230,179,157,208,103, 73,162,177,238,254,
 85, 80,243,194,165, 86,202, 82, 85,126,129, 69,242,130, 68,121,160,141,227, 91,
 86, 83, 57,162,111,142,129,104, 77, 48, 22, 70, 85,  3,253,144, 29,107,131,123,
 62, 81,123,100,251,124, 30,165,241,182,140,165, 19,  3,179,  6,220,150,225, 84,
 43,245,142,119,165,249,179,  3,179, 55, 47, 64, 72,100,117, 37, 52,255, 19,181,
 71, 97,135,176,105,132, 70,195, 90,237,240,212,243,148, 89,139,167,163,201, 30,
 98,163,250,147,100,121,133,108, 59,110,251, 67,156,119,199,212,162, 55, 92, 20,
122,127,125,250, 79,155, 27,233, 28,249,160, 75,101, 55, 49,218, 42,103,231, 78,
 54,189,212,131,  1, 26,248,140,105,228,145,207, 51, 65, 53,142,207,174, 59, 38,
184, 88,142, 72,210,139,136,188,  4,130,152,170, 85,103,206,153, 13,192, 13,129,
 33,250, 21,222, 88,181,216,209, 54,249,164,155,223,189,211,131,205,  7,178, 49,
 35,187,102, 80, 82,206,117, 17,119, 29,124, 24, 75, 86,245,111,106,  5, 81,166,
133,119, 52, 57,124,  1,175,193,248,141,  0,219,165, 12,119, 28, 95,152,222,  7,
119,158, 19,135,173,119,188,136, 46,128,117,165, 52, 28, 62, 82,164,255,117,206,
 89, 42,194, 72,121,  6,218,161,138,111,133,121, 48,120, 18,203,122,139,138,196,
160,224,244,130,182, 11,188,174,100,137, 41,156,172,207,188,120, 17, 91, 60, 84,
225,207,175,104, 97,152, 96,139,141,138, 78,204,162, 93,249, 45, 75, 24,  4, 72,
 94,161,238,228,200, 96, 52, 13,142,170,205, 21,250,192,  2,133,171, 86,194,201,
112,162, 41,186,156, 13,100, 39,193,154, 82, 48,117,228,101,244,  6,134,202,194,
 51,113,186,238,219,130,148,141,162,130, 61, 38,225,155, 64, 57,211, 25, 59, 40,
 76, 38, 81, 38,202,214,183,202,132, 44,191, 42,121, 25,242, 42,  3, 88, 12, 72,
236,106,100, 31,224, 64,241, 17,214,143,243,178,203,140,220,251,129, 26,219,159,
254, 13,161, 81,227,249, 30,122,229,204,104, 37,226,127,158, 55, 98, 16,156,142,
168, 45, 56, 19,  0,216,100,253,141, 65,209, 52,195, 51, 42,145,162,100,208,163,
 20,145, 76, 95, 42,145,193,176,162, 13,235, 90,149,  4,116,254,  2, 29, 60, 87,
141, 46, 55, 91, 29,  2,224,251,  5, 81,211, 36, 20,  5,108,129,134,147,127, 51,
243, 96,145,177, 64, 10,117,211,172,132, 21, 66,129,147,163, 76,183, 35,194,244,
 19,216, 78,106,183,156,112,215,174,142,133,193,223, 44,127,218, 12, 66,219, 12,
169,  6,179, 85,160,  0,125,120,186,230,  1,244, 47,139, 91,173,253,202, 93,222,
 39,130, 64,197,239,  1, 87,116,208,103,191, 67,123,150, 77, 67,209,167,165,130,
 72, 27,250,225, 18,136, 28,157,195, 87,252, 11, 34, 23, 49, 78, 32, 14,  3,233,
111, 22,207,142, 26, 20,156, 72,152, 85,123,181,173, 84, 56, 85, 91,122, 85, 50,
 10,137, 74, 45,103,127,200,249,  6, 87, 28, 46,171, 87,181, 47, 68, 94,107, 68,
222,106,186, 82,237, 94, 19,139, 76, 65, 82,199, 37,144,225,155,160,208,160, 26,
 81,157, 68,100,100,107, 11,167,232,172, 14,119, 86,251,112, 93,104,  8, 83, 86,
200, 41,149, 94,158,183,184,200,236,188, 14,214,147,131,176,255, 28,127, 33, 78,
158,164,246,214,153,207,214,138,116,251, 46,127,  6,204,220,253,167,155, 77, 17,
  2, 24,178,129,236,130, 29,164, 72,  5, 42,207, 58, 90,122, 81,206, 27,184,212,
 25,156, 42, 34,198, 70, 16,156, 33, 72, 55,147, 32, 76, 66,193,232,202,111,171,
 18, 48,220, 41, 78,180, 77,128,105,173,179,250,186, 72,193,112, 23, 49,147,118,
 69, 45, 46,187, 29,172,148,132,197, 49,179,165, 26,198,166, 75, 37,252,  5,  5,
 80,235, 39, 40, 71,  7, 60,202,227,230,102, 85,  0,153, 81,109,154,129,  7,102,
234,242,114, 49,240,221, 74,235,123,106, 12,
} ;

// ../Source/assign/template/GB_subassign_06n_template.c:
uint8_t GB_JITpackage_97 [2546] = {
 40,181, 47,253, 96,135, 66, 69, 79,  0,250, 95, 56, 17, 45,192,204,138,115,216,
146,248, 73,134,113,189,168, 42,131,188, 37,188, 73,194, 21,161,203,133,182, 77,
176,129, 86,115, 85,153,105, 89, 85, 80,134,233,138,253, 55, 69,161,163, 56, 23,
  2,  1,  6,  1, 11,  1,178, 25,171,210, 94, 48,219, 12,  9,177, 79,229, 51,  5,
173, 87, 40, 89,243, 71,226, 74,186,158,135,106,109,180,182,228,174,221,107, 27,
114,132,149,202,204,252,145, 58,165, 59,221,207,210,197, 52, 36,149,168, 35, 49,
 84, 85,109,173,141,189,180,187, 57, 71, 92, 15,199,199,200, 26,167,250,205,151,
 72, 75,134,217,210, 83,151,139,213, 75,215,151,194, 83,191, 36,188, 59,135, 63,
 45,136,122,126,183,161,175,156,114,131,105,133,153,147,144,176,152,200, 54,203,
130,107,193,168, 45,125,212,118,132, 28, 45,155,214,243, 52,172,114,123,169,246,
233,215,196,234, 86, 15, 73,100,  2, 89,204,130,154,251, 68,151, 57, 92,229, 94,
 23,200,182, 92,139, 37, 32, 23, 10, 42, 34,215,126,232,246, 98,222, 21,203, 96,
204, 99,116,151, 10, 76, 36, 19,200,  1,  7,201,228,145,  5, 93,106,254, 64,  5,
143,184,115, 96,117,102,172,185,148,113, 18, 16,152,  6,105,196,180, 77,161,150,
217,202, 91,230,145,249,148,167,220,189,242,135, 10, 65,212, 64,186, 64,212,167,
173, 48,106,217,214, 39, 13, 72,158,204,224,110,184,217,250, 65, 68,188,161,225,
  1,105,104,  8,219, 49,139, 15, 72, 10, 72,222, 84,164,242,240,200, 65,175,214,
198,109, 73, 87, 99,198,110,126, 21,225,160, 80,242,230, 83,163,246, 70, 39,231,
189,152, 69,225,182, 84,189, 37,180,250, 90,201, 25,220,216,221, 56,  6,190, 46,
248,104, 55, 90,161, 74,206,166,203, 17,247,195, 90, 47,189, 52, 79,103,181,246,
  3,123,153,158, 51, 31,224, 22,188, 20, 69, 22, 67,  4,161,140, 25, 33,  1, 81,
  5,117, 72,  9, 81,124, 90,135, 67,158,241,245,153, 46,233,202,238,245, 17, 48,
 80, 37,111,108, 48,107, 15,144, 79, 79,240,168, 82, 57,198,  3,196,105, 24,207,
  9,248,197,243, 19,121,232, 66,184,228,160, 95,145,183,205,195, 30, 93,141,  3,
131,238,128,194, 85, 12, 50,142,193,195, 88, 42, 48, 24,188, 72,242,135,203,  7,
  8,  5,189,114,135,109,136,105,175,151, 55,217,236,120,187,253, 56, 96,246, 56,
103,215,222,178, 83, 78, 61,141, 37,130,114, 77,230, 34,225, 32,227, 52, 15, 67,
 83, 81, 89,186,110,154,228,215,205,248,255, 63, 30, 20, 30,116, 94,186,224,214,
150,213,181,189,189, 73,131, 89,229, 13, 53,235,169,103, 72,174,114, 90,199, 42,
107,188, 82, 88,251,  1,111,141, 25,163,227,136,114,190,110,155, 75, 20, 67, 20,
  2,202,143,213, 57, 81, 29,202,130, 95, 88,184, 69, 81, 22,213,161, 38,157, 22,
213,145, 27, 63,206, 57, 24, 73, 29,232,174,194,194,  1,  5,133,132,228,180,168,
 35, 77,144,163,124, 55,201, 53,130,206,209, 14,249, 37,247, 85,218, 43,239,144,
157,140,242,138,178, 60,240, 92,194, 42,232,213,195, 32, 34, 58, 21, 86, 61, 82,
  7, 70,  4,148,215,166,204,241,188,114, 79,115,140,240, 91, 55,202, 29, 44, 21,
 15, 67,161,169,184, 96,168,140, 69,193,163,179,106, 76,173,222,235, 12, 12,242,
  8, 78,185,228,149, 95, 12, 77, 12, 16,149,240,200, 65,178, 56,131,146,227,130,
 54,110,215, 98, 86, 63,146, 80, 95,112, 41, 86, 95,182, 73, 45,155,135, 89,  6,
164, 90,128,141,218,118,201,213, 94,229, 54,173, 10, 47,109,187,244,173,112,169,
245,201,225,215,198, 77,182,117, 40,183, 80, 23,137,204,179, 76, 80,188,137,136,
 75, 38,227, 32, 44, 50,145, 36, 21,128,222,158,134,245, 43,153,211, 48,173,207,
234,107,113,236, 79, 21, 17,142,140,173,144,214,134, 29, 28, 55, 70,184,146, 99,
221,230, 45,206,232,204,136,240, 20, 70,206,184, 59,143, 71,133, 26,183, 94,122,
 73,183,186,244,151,220, 14,142,112, 66,249,155,184, 76,168,237,237,148,  8,154,
204,126,211,194,194,132,242,202, 34, 83, 89, 80, 47, 98,226,162, 96,194, 18, 89,
108, 49,107,233,151,195,241,179,222, 99,193,205, 54,233,166,246,214,249,126, 32,
150,189,221, 52,169,112, 24,  8,145,202, 95,152,125, 63,115,  3, 95, 55, 22,171,
179, 47, 93, 43,119, 55,111,136, 29, 94, 99,229,165,198,124,239, 54,133,129,225,
 69,175,116, 91,114, 36, 34, 73,182,180,205, 51,103,132,206,128,194, 56, 75,230,
 97, 96,220,196,  5,  2,102, 27,  6, 70, 51, 97,121, 22,141, 69, 34, 70,174,125,
113,209,145,200, 93,243, 15, 32, 90, 88,248, 67,154, 12,120,153,203, 99, 39,177,
251,223,115,160, 26,220, 38,231,117, 88,218,142,251,120, 84,120, 14,207, 61,234,
 77,217,251,225,248,173, 27,247,146,219,133,101, 65,137,250,172,119,231,208,166,
245, 41,186,171, 28,250,  4, 63, 93, 68, 56,157,159,224,112,119, 42,130, 99,118,
172,193, 88, 24,180,107, 87, 74,190, 36,115, 44,153,  9,138, 43,102,199,167, 16,
 69,219,193,157, 93,170,180, 75, 27, 21,116, 77,198, 81, 85,229,130, 82,168,194,
171,210, 49,133, 16,205,140, 20, 52, 73,101, 56,146, 32,132,  1, 73,168,  4, 99,
 52,247,162,144, 68,  7,211, 12, 49,204, 24, 66, 12, 33,132, 16, 38, 32,132,136,
  4, 34, 20, 73, 32,129,  4, 83, 53,109,116, 81,  0,  2, 15, 62,206,206,209,119,
 70,172, 92,149, 67,  9, 41,224,240, 17,183, 13, 43,113,239, 62, 11,206, 81,243,
200, 64,228,188,174, 21,109,216,173, 24,247,143, 98, 45,218,216,156, 54, 18, 96,
210,  8,237,202, 73,174,  6, 14, 53, 26, 15,146, 60,153,240,  0, 42,163, 19,160,
207,220, 59, 43, 90,123,168, 51,103,143, 40, 40,120,160,151, 24,101,  9, 19,138,
 33,252,126,153, 53, 64,  7, 63,164, 46, 61, 49,161, 79,224,106,194,227,171, 21,
254,153,105, 14,121, 77, 67,196, 50, 77,132,165,107, 90, 99,129,116, 49,235,218,
182,108,137, 80, 26,125,178,201,251, 48,190,217,104,104, 91, 64, 95, 12,141,255,
114, 52,103,208, 54,145, 69,125, 68, 96,219,103, 72,210,143,192, 93, 75,158, 90,
 26,108,169,191, 28,151, 18,196,123,153, 58,114,169,130,116,235, 94, 47,170,234,
135, 86, 10, 73,117, 67,191,215,160, 60,248,126,167, 39, 81,175, 63,206,128, 37,
 64,122, 37,147,144, 34,152,  8,251,201, 34, 11, 80, 60, 50, 76,  0,158, 98,157,
144, 72,189,120, 15,177,222,193,138,137,237, 14,229,206,249,175, 71,239,233,190,
178,131, 65,232, 47,132,164, 57,207,196,221,246,169,129, 90, 18, 54, 80,249,206,
 10, 26,  1,  8, 79, 43, 35, 98, 68, 99,216, 22,172,195,138,  9, 69,148, 14,239,
146,  4, 97, 46,  8, 52, 77, 67,195,115, 46, 65, 79,168,235,205,104,149, 58,161,
151,213, 26,217, 17, 86, 90,147, 96,160, 73, 57,157,202, 17, 73, 20,185,141,229,
121,255, 96,145,167,111, 79,245,102,144, 82, 34, 57, 71, 48, 97, 12, 98,187, 99,
197, 71,244,193,104, 59,205,  0,248, 29,164,162,177,215,129, 88, 25, 81,157, 76,
130,232, 70, 67,134, 42, 99, 13, 25, 27, 12,170, 25, 81,163,239,205, 35, 70,193,
 93,212, 66, 41, 77, 56, 30, 39,153,102,168,163,224,175, 84,125, 59,219, 93, 41,
121,  5, 33,188, 82,196, 37, 28,223,152,111,110,153, 41,  0, 59,173,186, 70, 77,
 43, 83,241,153,169,112,183,238,112,  5, 67, 80, 77,  3,  2,112,158, 76, 40,229,
 96,115,137,138,196,136,167, 14,223,166, 44, 10, 83,181,233, 29,241, 60, 90,189,
236,201, 70,218,184,226, 19,205,174,  3,124,210,226,140,172,166,  5, 23,148, 47,
 94, 43,246,  3,105, 51,185, 39,  8, 38, 15, 81,238,132,216, 85,237, 13,212,108,
 32,240, 71,188, 69,225,232, 33, 57,120,230,145,222, 20,129, 23, 26, 48,113, 38,
228, 53, 35,129,200,180, 40,164, 48,121,112,215, 82,130,184,126,130,101, 72,144,
154,122,103, 90,204,215, 10, 83, 54, 70,116,148,207,238,121,  0,178, 60, 75, 48,
 51,228,166,194, 40,172, 25,117,235, 83, 93,214,  6,142, 77,210,212, 46,226, 20,
145, 40, 26,106,188, 10,130, 50, 10,129,137,144,129,241,152, 38, 86, 89,247, 16,
 38,163, 61,119, 68,141,250, 80,159, 24,127,251,216,109,197,244,124, 13,  7,198,
 29,115, 25,192,154,160, 90, 72, 63,117,166,192,244,104,188,117, 20, 40, 48, 27,
229, 11,167,189,167,214, 87,140,124,  2,120, 51, 89, 88, 16, 27,132,205,227,252,
 33, 12, 74,206, 39, 70,252,175,154, 69,119,222, 23,141, 89, 64,179,153,181,135,
 34,133,152, 80,169,122,104,109, 99,117,112,152,217, 41,172,222,168, 17,172, 33,
212,208, 60,182,107, 67, 93, 83,159,220, 77,187, 12, 33,194,240,154, 44,194,124,
 72,109, 75,225,125,245, 96,202, 35,123,182, 34, 94,188,165, 17,222, 93,185,119,
 45, 53, 40,139, 73,162,101,163,106,220,131,150,169, 42,127,189, 40,179, 20,194,
 37, 38,198,156,241, 44, 69,232, 73,216, 48, 41,191, 60, 16, 43,135,120,152, 77,
 12,150,153,189, 89,  8,242, 43,200,140,216,100,185, 85, 28,121,198, 92,209, 26,
200,239, 28,116,168, 28,124,255,111, 74,140,222,  3,248,  8,140,194, 12, 98,140,
  3,224,240, 31,193, 80,139,100, 63,192, 71,239,249, 59,128,123,113,  6,118,215,
 21,165,191, 27, 49,234,146, 43,  7,155,246, 15,173,161, 30,124, 19,134,252,239,
 37,110,191, 36,224, 92,224,252,121,230,243, 97,129, 81,234,234,138,230,  7, 72,
 20, 44, 69,192,169, 50,242, 58,194,123,249, 32,149, 79, 29,234, 32,131,143, 70,
162,171,  5, 39, 31,194,169,  6, 70,157,188,176,130,155, 11,230,188,158,131,116,
  6,175,179, 59,105, 71,103,131,167,202,121,210, 25,136,237,109,183,229,179,200,
162, 44,222, 77, 17,167,250,206, 21,  6,246,215,245, 46, 38,  8,205,107, 74,211,
207,188,120,156,185,133,109, 76,174, 35,118,132, 82, 40,251,138, 43,187,249,239,
243,245,245, 75,139, 51,241, 44,231,173,139, 23,205, 41,175,138, 87,  3,135, 77,
167,162,206, 24,163,128,235,221,245,176, 68, 32, 33, 52, 52, 13, 18, 64,163, 84,
249,180,236,124,161,121,144, 41,245, 78,144,238,120, 51,145,252,193, 42,  4,217,
 91, 11, 67,127, 33,170,158,230,118, 12,196,195, 66, 74,181,228, 21,200, 71,250,
246,254,116, 28,152, 16,209,161,190, 11, 19, 10,255, 41, 80,194,215, 34, 81,216,
 26,144,231,176,160, 79, 74, 58,253, 30, 59,177, 61, 17, 81, 99,164,170,251,243,
217,219, 99,162, 40,117,141, 61, 29,212, 10,175, 99,  1,113,181,108, 99,236, 38,
198, 28,143, 55,249,127,107,183, 24,235,150, 64,122,150,151, 39,102,184,  2,247,
155, 97, 17,193, 25,169,232,167,148,185,145, 47,108,121,124, 85,207, 40,199, 63,
237,245,246, 33,  7, 12, 50,197,127,109, 66, 65, 80,181,225, 11,175, 82,234,222,
 84,166,154,178,236, 26, 74,246, 64, 34, 85,111, 26,244,214, 11, 66,  7,191, 29,
130, 71,241,205,159,140, 12, 87, 12,140, 14,172,228,209, 49,185,130,243, 77,218,
131,112, 43, 46,194,116,132, 28,  8,169,  6,207,117,131, 78,204, 47, 22,136,  8,
 11,238, 13,161, 44,227, 74, 93,228,230,162, 24,158,175, 46, 78,238,205, 88,134,
183,203,142,156,174,250,177, 19,  0, 55,100, 66,139, 54, 87,193, 75,122,185,121,
253, 89, 47,105,172, 29,165,192,210,150, 42, 50,215,196,196, 24,106,248,188,172,
143,222,140,252,124,149,177, 49,217,162, 73,  5,164,250, 86, 82, 41,  3, 40,128,
 83, 76,133, 67, 98, 12, 92, 86,145,209, 75,  2,236,172, 39,159, 29, 53,100,  7,
179, 32,  6, 61, 13,  1, 64,166,192,139, 77,147, 30,152,  9, 25, 49,170, 71,126,
 96,174,149, 51, 13,  4,
} ;

// ../Source/assign/template/GB_subassign_06s_template.c:
uint8_t GB_JITpackage_98 [2514] = {
 40,181, 47,253, 96,250, 91, 69, 78,  0,202, 89,108, 16, 45,176,142,140,117,104,
112,221,202, 18, 89,143,177, 56, 19,131,205,200, 71,235,116,204,217, 17,205, 91,
 16, 33, 77,152, 19,145,204, 86, 97,206,229,130,237, 15,250, 15,246, 55,118, 37,
253,  0,244,  0,253,  0, 46,186, 64,105, 20,105, 78,245,115, 18,207, 73, 64,206,
101, 19, 65,  2, 82,110,117,198,155,118,203, 79,185,  5,118, 46, 17,148,119, 94,
149,105,240, 92,  7, 70,232,108,172, 11,206,155,165,242,185, 45,222,104, 96,104,
 52, 32,125,183,103,100,137,159, 65,227,132,197,150,135,141,183, 83,115,110, 54,
106, 89,122,158, 43, 61,213,192,154,214, 11, 67,222, 28, 53,151,201, 56,152,208,
182,235,138,191,250, 66, 11,149, 47,220,120,198, 79,111, 55, 91,173, 94, 48,132,
 99,166,141,251,218, 83,167,  8, 72,142,213, 44,183,213,136, 64, 38,143,206,174,
104,221,169,219,242, 35, 51,109,172,122, 52,166,125,201,204,131,  2, 98,  3,193,
250,226, 54,110,206,113,206, 44, 36,231,115,186, 79,  5, 38,145,201,227,128, 36,
 50,185,116, 69,159,176,188,136, 16,135,184,103,100,185,106,178,243,233,185,204,
 67,102,227,141,160, 26,223,104, 95,103,185,189,198,187,  5,149,120, 59,229,238,
149, 43,176, 26,126,235, 45,  7,  9, 51, 85,145,229, 84,231, 56,173,214, 25, 98,
  3, 17, 72, 45, 36,198,209,179, 97,248, 16,241,  1,  3, 26,143,  1,  3,  2,218,
 70,237,173, 86, 31, 53,139,120, 45,  0,237,183,126,222,  0, 65,147,121,148,  6,
 66,211,185,195, 61,237, 70,219, 62,211,173, 94,152,221, 62,225,150, 30,173, 94,
120,231,216,247, 58, 37,121,227,152, 89, 41,210, 64,232, 52,142, 55, 55,158,157,
225, 98,169, 50, 15, 98, 40, 42, 56, 17, 81,189,231, 30, 28, 60, 42,181,136,193,
168,230, 60,134,141,179, 58,213,  3,124, 21,116,145, 20,153,124, 66, 96,128,192,
 68, 18,145,124, 74, 64, 32,242,105, 18, 57,142,254, 28,238,212,236, 57,227,141,
 27,218,161,216,233, 44,235,180, 24,109, 53, 96,125,229, 86,161,175,228,136,162,
 69,107,154,104, 43,174,211,  2,145,146,229,240,255, 35,123, 54, 62,  4,107,207,
177,185,213,108,234, 43,111,205,217, 22,174,221,250,185,109, 79,227,165, 29, 75,
 58,221, 56,165, 38,241,251,198, 91,199,104,252,244, 62,185,127,170, 31, 82,121,
175,249, 25,219,230, 69,229,100,221,154,175,190,120, 60,149,199, 45,111,166,253,
 79, 61,128,119,150,143,229,181,247,237,204,194, 37, 73,139, 44,234, 20, 32, 73,
207, 33,  5,157,137, 11,188,116, 46, 25,202,131,150, 57,101,198, 20, 20,184,181,
122,181,231,148,244,206, 61, 27,123,116, 42,158,162,168,248,173,167, 32, 57,228,
150,138,  6,169, 93,218, 88, 26, 75,244,203,155,224,104,160,132,133,227, 46, 15,
 70,224,184,  9, 76,101,229, 74,221,243,230, 57,150,178,129,130,179, 21,247, 56,
 39, 57,249, 38,249,162, 63, 40,  3,  4,184,228,240,135,209,173,126,158,195, 58,
 80, 94,185,147, 53,103,137, 69,238, 83,223, 22,183,181,103, 68, 11,143,201,227,
 43,102,189, 82,185,244,136, 48,144,246, 89,171,199,162,124,178,168,200,162,156,
246,188,112, 23, 80,185,253,179,159, 64,209, 25,192,103,185, 60,128, 27,  7, 13,
 52,154,140,  4,154,168, 23,167,  3,229, 25, 95,249,  9,189,114,208, 51, 36, 96,
 32, 83,153,183, 79,249,198,140,161,147,209, 37,151,231, 36, 54,144,163,233,108,
 42,142,229, 93, 32,224,173,217,202,123,225,198,238,112,224, 83, 30,121,229,152,
 12,225,152, 35,137, 82,142,136, 86,153,175,251,198,132, 75,146,233,146, 90,164,
 25, 88,212,115,195, 58,187,240, 37, 26, 97, 44,246,205, 50, 12,141, 70,134, 60,
 55, 76,239,150,251,246,  5, 57,227,228,159, 76, 30, 72, 70,216,225, 84,213, 84,
125,130,117,190, 21, 67, 42, 64,128,  9,229,150,131,103, 57,176,192,136,137, 10,
 98,226, 66, 77,220,115,120,139, 25, 70,187, 31,130, 99,150,193,189,231,164,116,
246, 79, 58,103, 47, 98,246, 55,123,202,204,194, 37,204, 39,136,137,170,  1,196,
 96, 34, 76, 69,171,196, 24,125, 90, 39,150,183, 30, 84,113,204, 43,183,128,220,
123,239,189,247, 30,222,195,163,120,239,189,  7,137,195,133,162, 59,104, 21,132,
 42, 78, 29,244,  5,151,162, 80,189, 30,177,219, 23, 55, 90,  8,133,138,103, 44,
 51,157, 87,156,189,228,196,143,167,245,184,115,188,109,235,127,  7,155,202,207,
 37,143, 87, 78,  1,107,134, 18, 62,129, 62, 89,119,251,201,217,232, 16,151,205,
 38,244, 41,147, 16, 61,123, 84,228, 66,161,208,109,155,145,109, 28,  7,  2,148,
 64, 87, 41,238, 11, 57, 79,183, 74,111,113,174,226, 44, 89,174, 30,135,  3, 74,
207,183, 49,149,238, 16,247,169,225,157,202,103,100,140,166, 53,191, 82,238,112,
 60,155, 33,  2, 39,130, 87,168,162,203, 18, 50,164,132, 70, 68, 36, 73, 10,146,
225, 18, 25,132,226, 56,154, 68,186,216, 74, 15,194,160, 40,139,130, 16,133, 24,
 66,  8, 35,132, 16,130,  4,132, 16, 66,  4,132, 16, 70, 68,  2,  9, 68,196,136,
147, 14,126, 65,145,153,154,  2,208, 57, 14,167, 52,130, 76, 76, 95,209,171,233,
 55,199,116, 75,161,254,150, 67,119, 27, 32, 79,135,217, 87,101,104,208,195,159,
 51,183,  9,161,175, 95,160, 68,228, 33,241, 42, 92,113, 67,  6,133,  3,221,163,
168,234, 24,143, 58,154, 68,253, 40,109,229,168, 91,201,237, 72,218,176,232,  0,
199,197, 81,122,247,196, 44, 17,234,250,203, 78, 26, 51, 97,236, 58,202,206,111,
114, 79,255,184, 75, 69, 69, 97, 55, 61,126, 87, 13, 78, 64, 75, 48,210,190,188,
  0,253,238,104,126,133, 76,  0, 45,156, 42,108,188, 86,105,227,231, 38, 34,222,
232, 89,113,215, 97, 68,251,175,233,162,121,206, 35,129,206, 85,160,138, 11, 82,
167,149,168,243,163,233, 92, 53, 20,216,244,215,101, 41,161,115,152, 56,186, 37,
 39,248,219,  1,103,135, 79,118,217,148,223,174, 37,253,155, 98,234, 48, 83,  9,
139,221,213,171,223,104,124,126, 86, 89,217, 88, 95, 15, 97,158,251,177,189, 70,
  3, 96,103, 76, 96,  8,105, 71, 91, 50, 26,128, 18, 23, 74,204,194,162, 46,247,
172, 90,249,226,161, 45,225,  1,177, 21,106,162,229, 72,182,197,115,124,188,111,
189,118,173,135,211,125,134,226,  0, 21,111,254,163,  9,129, 83, 92,208, 99, 29,
 92,201,180, 18, 94,220, 48,105,202,198,113, 48,113,  9, 47,132,199,184,246, 49,
109,218,255,215,167,190,173, 24, 20, 65, 50,136,187, 44, 55,241,252, 16,165,159,
253,205, 83,160, 13,141, 36,193,187, 79,144,235, 48,112, 45,186, 18,218,208, 74,
 44,122,146, 37, 45, 26,230,133, 71,243,189,202, 52,255,192,202,106,202,  7,165,
211,202, 17, 33, 34,180, 22,124,242, 59,199, 78,  3,195, 34,120,135,  4, 90,136,
138,127,172, 96, 54,134,185,235, 51,118,181,153,239, 44,236, 78, 89,224,157, 52,
157,186,250,128,151, 81,195, 24,  4,131,187, 12,187, 58, 47,240, 77, 82,123,221,
160,111,196,167, 20,  7, 44, 29, 28, 33,102, 96, 98, 45,234,201,134,163, 16, 41,
138, 34, 93, 93,137, 11,243, 34,141,223,230, 73, 78,249,151, 51, 31,251, 91,  2,
 33,146, 22,110,205,192,158, 22,127,229, 23,127,250,173, 50,172,117, 84,253,  8,
162,158, 96,159,  9, 67,170, 92,  3, 76,237,193,211,151,163,  3, 54,  6, 33,205,
119,188, 58,250,105,134, 93, 47,103,174,174,245,213, 66,108,239, 31,169,136,129,
 69,118, 91, 72,107, 16,134, 24, 23,  2, 13,219,255,186,115, 43,208, 31,183,240,
226,202, 68, 19,241, 11, 51,130, 35,147,211, 94,  5,109, 66, 16,185, 88,216,198,
190,202,121, 11, 16,179,154,171,120,213,246,  4,228,196, 66,185,116,215,194,210,
179, 76,110,255,120,129,161, 67, 19,134,170, 24,178,112, 60,101,111,150, 14,235,
 54, 48,217, 78, 70,  4, 69,177,239, 31,149,117, 31,172,127,117, 44,116,141,242,
 34,157, 17, 61,220,174, 84, 23, 81,  6, 17, 12,218,158, 40, 18,130, 72,134,233,
 44,241,170,137,112, 44, 18, 38,129,236,210,228,174,208, 12,215,134,143, 47, 40,
105,226,128,197,214,231,  6,169, 52,121, 52,201,131, 74,244,190, 94, 12,110,173,
149,119, 32,  5, 63,227, 89,214,124,  4, 34,233, 46,153,157,248, 45,225,176, 25,
165,220,216,163,235,162,153,145,253, 44,173, 17,221, 68,213, 68,169,181,226,235,
125,194, 97,213,243,112,125,252, 38,218,104, 18,199,239,217,172, 70,111,  6, 52,
228, 61, 42,115,144, 72,175,221, 30,115,212,255, 86,137,173, 43, 28,246,135,  2,
152,232,  6, 36,229,111,243, 58,128,246, 85, 49,134,219,119, 47,241, 57, 77, 58,
 44, 12,  1,222, 43, 94,137,140,130, 82,173,103, 44, 40,139,148,206,214,227,213,
 28,154,119,118, 61,128,209,  6, 76, 89, 68,142,144,121,  8,172, 73, 74, 45,249,
243,175, 25,194,122, 61,  5,  6, 59,106,220,183,105,192, 21, 78,187, 62, 83,162,
146,194,246,243, 20,199,191,104, 31,109,208,163,167,108,230,224,107,109,130,158,
110,160,150,122,131, 83, 74,249,107,117,167,180,160,  1, 58, 60, 43, 86,234,125,
127, 69,105, 53,177,119,244,106,134,102, 67,149,182,148,107,246,244, 89,197, 59,
 21,130,147,244, 78, 87,142,231,230,171,220,138, 69, 67,134, 17,  7, 73,175,241,
118, 68,186, 41,202,165, 34, 79, 26,147,141,241,  1, 48, 55, 73,128,179,241, 98,
240, 20,  0,217,178,162,117,130, 39, 48,116,  4, 28,  1, 43,  5,250,213,240,149,
  0,159,186,165,215,131,187,172, 66,193, 22,189, 12, 30,129,222,190,118,116, 50,
181,105,147, 97,219,207,248,144,149, 43,173,198,239,101,  1,  8,110,234,194,151,
112,188,149,128, 15, 51,164, 50, 64,212,182, 85,226, 55,197,  3,  3, 93,182, 20,
 67,139,223,121, 52,152,223,176, 24,230,219,  1,243,  0,108,210, 21,229,111,177,
 17,161, 73, 28, 49, 64, 96,153,190,134,165, 96, 36, 32,169, 64, 18,231, 73,  0,
154,118, 91,251,163,195, 47, 75, 56,178,100, 50,190,142,246,223, 58, 11, 17,184,
219,177, 85,250,208, 83, 77, 96,101, 98, 78,168, 94,248,163,121,122,254,145, 38,
 17, 18, 93, 94,179, 85, 78, 33, 71,192,180, 83, 47,195,246, 77, 54,149, 83,127,
252, 16,139, 99,  1,  7,  9,190, 99, 32,119, 93,113,239, 99,106, 68, 44,102,142,
 75, 74, 98,131, 33,228,249, 28, 91,195,167, 47,167,117,224, 94,215, 55,236,194,
193, 70,174, 93,  2, 62,229,161,138,152,224, 69, 11, 46, 73,214, 83,166, 25,234,
  1,133, 44,116, 27, 63, 65, 81,206,237,208, 22,250, 82,153,169, 97,229,101, 73,
 85,213,178, 62,187,125,105, 92, 86, 89,210,226,199,140, 99,238, 70, 36, 77, 84,
109, 54,225,168,172, 25,245,  0, 52,222, 77,111,112,136,103,107,225,196,160,119,
 42,238,233,175,222,221, 58,  8,190, 55, 49, 36,192, 98, 70, 42,106,149,238,130,
222,138,232,255, 25,233,207,158, 81, 10,249,107,  4,145,142,192, 72, 86,152,226,
 38,159,188, 35,241, 33,194,194, 31,144, 35,139, 65,111, 85,120, 34,111, 18, 82,
177, 18,215, 28, 31,130, 26,  4, 24, 20,141, 49,251, 54,234, 62,182, 79, 52,  5,
103, 30, 52, 21,111,101, 49,217, 93,135, 42,150,140, 65, 99,129, 77,177, 98,142,
 25,152, 22, 13,252,254, 21, 25,224,180,  2, 25,154, 18, 91, 51,198, 76,181,117,
 64,216,199,212,113, 27,167,236,170,202, 70,217, 76,235,180,170, 11,194,166,201,
124, 96, 38,119, 36, 73,176, 29, 34,168,154,  4,232,  3,
} ;

// ../Source/assign/template/GB_subassign_07_template.c:
uint8_t GB_JITpackage_99 [1561] = {
 40,181, 47,253, 96,145, 36,125, 48,  0, 74, 67, 76, 12, 40,176,146, 85, 29,168,
 70,159,138, 65,162, 91, 88, 19, 44,207,143, 89, 23,178,164,115,149,239,220,218,
237,166, 43,201, 86,112,120, 20, 59, 59, 59,123,214,190,148,186,  0,182,  0,184,
  0,185, 53,254,255, 16,136,  7,  4, 50,202, 19,127, 84,165, 39,187, 60, 61,207,
 21,164,171,173, 87,213,125,154, 38, 91,147,212,235, 27,225, 95,121,157,213, 26,
 83,249,249,181,239, 87, 89,251,110,198, 49,132,101,174,141,251,122,175, 14, 40,
223, 44,151, 27,131, 80, 38, 22, 73,115,154,244,174, 87,183,231,103,230,218, 91,
 70,210,184,182, 54, 33, 36, 21, 12,155,201,214,162,219,184, 57,199,153,211,152,
156, 83,122,157, 42,176, 80, 44,146,131, 10,197,242, 73,147, 78,225, 41,146, 12,
159, 92, 31,113,217,118,179,115, 42,187, 32, 22, 56, 79, 94, 76,213,248, 74, 47,
235, 60,191, 12,146,221,214, 91,191,146, 74, 13, 63, 33,114,  5, 12, 97,114,160,
 50, 18,124,213, 89, 82,175,235, 28, 15, 40,177,106, 76,140,165,231,195,113,  1,
243,129,  1,136,100, 96, 32,237, 61,215,207,106, 55,215,126,103,185,121,223,169,
119,110,218, 91,253, 94, 85,190, 53,245,116, 31,168, 74,237, 23,152,129,200,226,
 69, 19, 17, 53,152, 76,150, 93, 11, 18,217,116, 64, 73,199, 33, 44,243,187,206,
207, 64,174,243,216, 91,155, 20,191,162, 77,169,188,114, 51,169,  6, 92,158, 27,
183,152, 94,255,100,118, 19,127,116, 91,244,190,242, 91,149,159, 20, 96,249,238,
 36,254, 43, 42,187,153,189,136,219,252,198,150, 90,231, 92, 16, 23,204, 34, 38,
  1,225,133, 53,100, 87, 67,228, 92, 54, 22, 13,113,162, 92,225, 85, 65,  2,165,
 39,188,210, 88,114, 94,196, 61, 61,157,237,136,221, 56,142,100,119,106, 45,174,
 86,235,140,191,238,240,183, 14, 99,231,130,177,222,201, 50, 16, 15,217,213,137,
 22,157, 13,118,193,249,243,234,124,211, 99,241,241,124, 53,129,168, 74,130,160,
169, 54, 21, 65, 77,106, 92,123,203, 87,102, 12, 53,  8,218, 72, 60, 68, 68, 64,
 64,235,225,190, 23, 90,239,175,206, 60, 73,255,120,151,124,171, 29, 49,175,163,
130, 58,235, 24,188, 76,132, 78,113,152,116, 44,114, 11, 24, 16,246,143, 61,151,
 67, 20, 72, 82,  4,235, 25,223,249,  9, 61,225,161,231, 72, 96,144,235,196,147,
203,175,243, 88,107,209,223,249,179, 94,185,108, 34, 39,162,179,201,112, 96,118,
 97,136,215,102,111, 94, 13,247,246,230,114, 36, 82,143,112,235,148, 39,124,155,
 82,173, 34, 82,181, 51,107,247, 16,140, 79, 21, 74,155,157,172,163, 77,106,250,
109,205,105,248, 83,149,240, 38,251,114, 57,118, 95,253,181,159,123,247, 58,123,
217,105,200,235,  5, 52,245,190,124,141, 58,183, 26, 16,200, 71,166, 31,238,251,
122,191,220,151, 99,222, 44, 59, 42, 45, 29,206, 37,211,100,  0, 44,  0,147,100,
217, 58, 95,139, 99, 37, 32, 96,177,142, 73,100,152,  4,140, 24, 77,134, 65,115,
209,222, 92,115, 90,223, 91,124,170, 63,147,222,230,135, 52,233,249,236,245,188,
118,139, 36,247,238,149,101,115,113, 40, 34,145, 56, 61,223,198,117, 78, 38,246,
 19, 65, 83,122,  3,228, 92,151, 44, 90,112, 46, 77,102, 97,131,248,187,213,141,
105,127,196, 74,188,112,139, 38,125,197,136,122,222,244, 43,  2, 19, 46,189,146,
175, 42, 46,126,237, 51, 42,191, 14, 47, 46,153,  6, 78,108,206,107, 30, 52,187,
 99,226,238, 20, 71, 39,187, 32, 38, 32,240,137,242,120,102,158,199, 27,246,154,
 18, 54,162,213, 62,127,158, 83,112, 74, 16,193,250,214, 91,119,229,180, 43, 91,
214,129, 48,168,145,165, 50,202,140,136,136,200, 72,146,164, 48, 28, 97,  8, 33,
140,114,208, 66,105,  7,  2,113, 72,  5,100, 20, 99,  8, 81,136, 24, 35,100,196,
  8, 67, 36, 16,  9, 36,144, 64, 34, 17, 52,234,116, 44, 32,128, 60,241,244,119,
  9,190,106,108,163, 15,201,183, 99,161, 69,201,177,252,236,104,116, 53,246, 87,
228,144,205,190,  3, 21,112,147,214,183,155, 22,228, 25,118, 43,200, 31,102,145,
 71,216,143, 23, 11,175,181,104, 17, 21,169,244,161,182,115, 68, 72, 40,204, 17,
208, 69,247,165, 13, 62,196,122,201, 67,213,162, 17, 56,  1,244, 44, 46, 61,213,
 89, 97, 69,136, 57, 41,110,236,171, 74,167,135, 62, 45,149, 61,238, 21, 44,114,
104, 96,  7,131, 74, 41,198,120,121, 23,142, 64,111, 68, 99, 47,141,145,253,129,
 56, 84,116,  7,101,208,128,118,191, 19,203, 94,179,  2,241, 98,130,242, 11,248,
198,219,156, 12,251,232,180,239, 17,197,121,100, 10,146,212, 78,243, 78,175, 86,
 89, 26, 91,135,  2,  0, 56,174,245,219,141,113, 91, 20, 20, 36, 42, 35, 81, 74,
150,107, 21, 70,119, 86,155,245,140,253,245, 82, 46,164,115,137,139, 62, 98,141,
  1,159,242, 99,154,103,112,180,228,205, 88,149,199, 57,240,219, 70, 65,192,162,
118,240,  6,251, 96,  2,178,208,188,146, 99,242, 27,149,154,161, 17,138,144, 10,
238,132, 88,196, 62, 73,115,232, 73,237, 37,215, 11,207,125, 30, 82,197,123, 35,
100,  8,141, 10, 38,230,155,207,  0,163, 14,  4, 83, 34,109,112,165,  4, 25, 91,
155, 47,141,173, 82,209,238,176,100, 29,168,134, 41,115,197,101,162, 93,248,114,
182, 61,113, 17,240,192,133,108,  7,118,205,151,185,190,243, 25,209,239,182,108,
132, 10,184,217, 61,216,228,136,224,254, 27, 41, 26,244,138, 30,120,115,222,137,
151, 29,218, 46,127,215, 64,162, 23, 55, 39,226,199, 50, 18, 67,188,194, 46,  1,
125,100, 11,144,140,219, 76,123, 59, 64,146,202,164, 85, 17, 93, 98,120,253, 23,
185,190,192,178,129, 86,254,175, 91,235,221,211,199,200,208, 40, 53,199,134,  3,
204,206,166,204, 98,250, 38, 65, 40, 86,137, 19,165, 53,102,118,159,179, 82,132,
152,129,234,222,109,111,174,130, 64,101, 24,116,153,123,156, 44, 87,  5,166,103,
 56, 21, 67, 71, 66,225,160, 25, 58,  6,221, 95, 25,163,124,  7,204, 36, 48,189,
 34,152,216,  1,172,243, 51,230,156, 16,203, 15,  4,250, 47,219,190,200, 12,  6,
104, 87,100,124,172, 65, 48,168,220,106, 36,149,103,102,242, 29,155,132,251,247,
 98,112, 17, 43,182,241,220,242,214,134, 85,154,250,112,177, 29,226,207,128,  5,
  5, 26,213,109, 94,134,203,  0,222,189, 18,194, 41,108,103,115,199,185, 98,136,
170, 75,108,108,206, 83,  7, 78,227,113, 39, 39,237,103,133,235,  6,149,145, 45,
244,231, 14,226,  7, 77, 88, 72,160, 39,180, 63,233, 32,195,227, 15,107,209,201,
 62,159, 25, 75, 49, 37, 16,183, 16,123,105, 35,225, 86, 46,141, 34,140,164,251,
 79, 91, 57,123, 32, 35, 53, 91, 28,232,143, 85,217,220, 16,158, 27,214,172,194,
 92,137,254,155,241,154, 39,202, 17,  4,250, 60,198, 65, 22,195, 32, 66,117,186,
222,156,164,100, 65, 74,  1, 98, 44,231,236,186,244,157,239,185, 65,243, 56,123,
156,210,236, 37, 66,229,183,207, 42, 80,146,215, 67,241, 93,189,104,  9, 80, 17,
219,138, 23, 72, 37,208,166,137,255,204, 68,216,248,182,233,140, 87,165, 73,224,
 14,
} ;

// ../Source/assign/template/GB_subassign_08n_template.c:
uint8_t GB_JITpackage_100 [3005] = {
 40,181, 47,253, 96, 18, 84,157, 93,  0,250,100,112, 18, 45,176,204,138,117,202,
160,  2, 92,247, 75,148, 81,135, 42,  0,155,213,217, 81, 88, 23, 23, 53,100, 27,
  5,107,102,129, 36,117, 87,170,  0, 28, 99,197,181, 63,232, 63, 88,254,193,185,
 18,  1, 32,  1, 23,  1, 20, 34, 16,206,179, 61,124,  5,136, 76, 44,239,215,140,
183,215,246,  7, 95,250, 76, 29, 57,143, 79,206, 54, 98,218, 43,245,156, 65,241,
158,222, 79,218,215,138,153, 12, 12,167,114,112,114,217, 56,  5, 26, 18,247,238,
233,219,233, 69,190,214,110,240,193,201,147,237, 87,247, 96,216, 70,235, 55, 98,
247,179,127,241,173,108,103,159,107,188,229,238,100,116,  2, 91,179,237,165,220,
 60,231,206,103,180, 94,189,162,197,236,118,231, 55,194,147,206,143,174, 55,102,
142,202, 54,203,138,108, 69,169,113,133,213, 79,105, 25,181,216,202,232,121,165,
231, 83,215,218,234,181, 16,100,227,157,108,185,106,167,126, 81,236,242,139, 64,
 72, 40, 14,140, 89, 81,115,167, 42,183,167,239,228, 11,227,192,118,178,213, 24,
 14, 13, 40, 52, 36, 23,135, 42, 91,214,220, 94,172,163, 53,151,210,125, 34, 64,
129,160, 56, 24,152, 64, 80, 46, 89,209, 39,219,161, 72,113,137, 59,  8,118,105,
214,156, 79, 27,135, 49,129,105,177, 86, 80,108,107,212, 54,124,123,219, 68, 54,
167,243,149,187, 91, 26, 46,241, 34, 36,139,  9, 19, 85,167,248, 70,169,101,124,
225, 60,  0,  1,103, 71, 91, 27, 59,155,133, 19, 21,127,120,136, 56, 60, 60,  4,
183,125, 43,197, 44,189,206,161,202,216,109,190,  7,243, 75, 46,174,124, 53,119,
236,197, 60,255, 24, 36,142,109,229,139,221,131,200, 73,223, 39, 73,114,209, 39,
204, 25,125,118, 22,253,  3,179,205, 70,143, 29,156,101, 92, 34, 99,214, 87,163,
108,169,100, 23, 29,  3, 99, 35,  1,220, 96, 44,208, 54,116, 13, 48, 26,206,219,
168, 42,247, 20, 64,205, 69,195,129,  2, 40, 65, 92,226, 83,194,161,138,110,249,
 37,165,118, 82,235,218, 45,171, 32,231, 82, 81, 57,103,131,193,184,216, 56, 14,
116,192,209,120,151,136,189,155, 54,251,151, 59, 30,161, 80,249,167, 35,204, 96,
 96, 69,  6, 67,145,185,  0,160, 84,  0, 68,231,104, 46,155,141,163, 80, 40, 33,
 13, 13, 29,179,175,201,218,189, 68, 34, 81, 15,252,116,229,210,  4, 66,102, 11,
 65, 98, 22, 93, 65,165,113,151, 13,116,160,113, 25,204,  4, 53, 27,179,106,100,
123,144, 26,103,119,206, 86,242, 67, 42,135, 19,232, 96,  5,177,219, 30,150, 67,
 45, 79, 73,231,203,146,175,185, 53, 56,136,212, 52,233,174,161,178, 60, 58, 69,
 53,120, 16, 97,114,247,234, 65,229, 26, 27, 23, 25, 25, 24,240,178,201, 92, 40,
 96,213, 15, 12,151,170,207, 84,117, 84,221, 67,175,109, 32, 74,229,175,197,181,
175, 51, 60, 72,215,199,211, 15,244,106, 93, 45,203, 23,118, 27, 26, 30,241,202,
 33,110,249,213,209,164, 26,162, 42, 77, 38,171,179, 56, 65,174,136,165,  8,106,
 25,125,204, 58, 98,213,  2,176,212,182,251,223,185, 81,107,226, 27, 47,141,186,
208, 92, 24,100,224,133,227,170, 12, 12, 12,167,225,104, 72,160,202, 12,156,133,
133,197,164,146, 90,152, 79, 20, 25,204,197,156, 48,207, 65,122,225,100,175,200,
 21,179,147, 39,180,133,141,193, 89,136,162, 95,100, 80,  4,124, 56,164,237,211,
132, 81, 93, 40,158,197,161,201,241, 11,  7, 20,  0,153, 30, 30,220, 47, 77,239,
 83, 21,209,204,115,154,  7,149, 50, 98, 22, 98, 28,209,175,109, 89, 89,  3,193,
110,111, 95,141,173, 15,230,144, 84,122, 41,219,163, 47, 43,214,201,211,191,219,
 68,236, 16,189,238,141,143,182,127,251,211, 37, 82,100,225,120,167, 52, 36,108,
161,  7,  4, 83,201,245, 29,179,229,118, 49,102,217, 75,150,146,218, 79,209,106,
169,245, 61,219,102,192,160,150,199,172, 45,171,180, 67, 70, 73, 85,233,141,114,
179, 13,210,255,224,107,246, 57,139,214, 89,238,122, 39,159,122,220,140, 78, 79,
 44, 59,209,246, 45,173, 60, 97,210, 89,185,147,109, 51,206,104, 57,212,200,179,
229,227,127,133, 98,189,  1,145, 72, 72,166,  2,179,217,184,137,141,205,149,155,
229,250, 89,183,203, 85, 70, 10,133, 66,161, 80, 46,190,149, 90, 72, 45, 44, 80,
 54, 54, 92,217,211, 18,100,197,206, 70,107,231,147,185,243,201, 46, 37, 69,  9,
209,216,208,112, 26,  6,239,185,247,250,126,240,164, 91,103, 97, 33, 58,203,198,
 60, 60,244,  1, 54,218,137,231, 80,196,254,105,104,129,113,206, 85,158,253, 54,
149,218,  7,159,162,168,139,102,131,179,145,192,189,152,105, 11,237,186, 35, 56,
169,215,140,182, 25, 46,209, 48, 91,202, 62, 94,116,206,198, 85, 47,162,242, 51,
252,227, 60, 17,213, 45, 85,165, 85,159,234,178,  0, 82,205,114,173,212,170, 62,
 53, 94,235, 34, 94, 55,116,205,219,236, 91,161,194,123,217, 29, 44,159, 48, 63,
 17,228,106, 25, 91,144,197,152,117,144,213,155,132,247,222,167,247,222,123,239,
 77,188,137,247,222, 11,153, 52, 76,150, 33,247,105,210, 92,164, 73, 72, 17, 64,
 15, 78,253,147,137,162, 71,168,131,142,224, 18,230,110,177, 28, 68,173,202, 33,
158, 33, 21, 73,132,  7,191,197,105, 30, 26,111,172,172, 81,119, 10,240,154, 12,
157,246,105,226,224, 52, 16,246,137, 50,162,242,107,107,123, 64,183, 28,100,219,
 90, 28,186,148,241,124,183,202, 53, 25,154,106, 83,  3,131,  4,168,226,203,218,
 40,101, 72,100, 68, 10,146,130, 36,195,  1,242, 32,132,  1, 57,156,134,153, 28,
115, 30,178,112, 72, 71,115, 16,133, 56,  4, 25,162,  8, 65,132, 16, 34, 32, 68,
 32,134,136,140,  4, 18,141, 72,149, 36, 29,116,  1, 27,157,144,208,170,165,198,
209,112, 89,149,202,130, 27, 41,202,  9,142,115, 17,174,138,107, 11,196,195, 45,
238,  1,205, 68,238,  1,116,129, 55, 81, 45,198,163,198,166,197, 68,204,216,188,
 14,175,230, 23, 27,250, 17,156, 95, 24,155, 17, 20,237,149,195, 20, 62, 44,187,
142,245,243,107,210,182, 80, 67, 29, 20, 40, 22,171, 77,255,226, 23, 50,103, 84,
 89,244,  1,238, 10,137, 45,168,167,240, 27,217, 24,190,230,186, 69, 96,224,174,
127, 23, 81, 70,  3,142, 82,154,177, 24, 29,130,227, 30,240,150,147, 42,207, 54,
142, 11,156,102,240,241, 62,122, 10,150, 85,146, 61, 41,  2,138,252, 48,253,115,
168, 95,148,229, 86, 63, 80,128,159,122,  8, 77, 85,189, 18, 22, 35, 30, 94,125,
 59,228,255,136,133,218, 95,164,148, 62, 72,108, 93,192,166,135,195,178, 13, 29,
 50, 79,134,248,194,100,185,157,148, 23,214, 90,135,114, 93, 25,118, 78,232,127,
156, 47, 48, 34,171,250,109, 57,171,112,181,  3,185,224, 88, 75, 83, 96,182,215,
206,220,133, 74, 37, 33, 61, 87, 71,159, 78, 46, 18, 44,135, 61, 34,114, 72,180,
110,232, 72,230,144,144,130,253,198, 76,243,114,112,245, 98, 97,135,181,159,242,
164,150, 23, 39, 62,154,111,173,107, 51,233, 17, 45,  1,130, 89,190, 27,247,172,
 11,108, 32, 82,116,149,183, 67,140,175,113,232,146, 59,186,168, 95, 58,218,124,
222,  6,135,165, 80,137,252,236, 39,231,  7,100,200,126,182, 34,  2, 93,108,219,
 22,243,221, 38,134,100,221,215,217,102,154,148,144,236,127,163,135,155, 15,145,
172,132, 59, 44, 46,164,  9, 62, 33,115,229, 64,254,131,103, 34,225,232,182, 11,
237, 94,  9,171,102,142,240, 80,  5,102, 29,147,219, 15, 44,148, 11,216,152,113,
 58,100, 67,138,192,153,197, 74,158,240, 10,248, 82,239,131,113, 34,252, 10,216,
 46,  1,166,226,164,198,111, 40,125,112,126,142,130,209,  0,113, 76, 34, 75, 55,
 32,165, 69,231,196, 15,215, 67,254,229,  6,159, 22, 60, 17,251,122,  1,130,202,
149,105,154, 75, 98, 37,223,235,126, 48, 49,112, 24,210,162, 35, 27, 26,126, 13,
 13,220,192,162,107,190, 33,109, 96,163, 95, 65,143,175, 16,175,209, 78,213, 93,
113,163,199,254, 17,190,235, 90,202,115, 88, 77,232, 57,207, 76,203,170,174, 14,
120,169,  2,194, 91,101,136,184,195,185,  6, 25,176,250,141, 98,101,249, 26, 52,
 46,151, 96, 58, 37,150,131, 40,169,135,208,198,217,161, 54,  6,121,211, 23, 70,
232,161,116,144, 94, 78, 12,222, 63,  8,131,122, 16, 13,248,188,205, 52,173,104,
 29, 59,155,122, 16, 33,238, 36,  3, 22, 40,128, 78,178,210,218,207,182, 14,170,
197, 32, 79, 19,184,168,218,204, 13,196,159, 98,190,133, 78,238,  8,110, 99,101,
 68,230, 82,100, 28,210,224, 77,103, 48,131,243, 92, 44,194,253,156,234,142,113,
 10, 37, 18,139,215,153,135,161,171, 81, 37, 79,204,100,176, 55, 27,181, 86,165,
116, 33, 86,117,236, 68,159, 33,236,237, 18, 14, 55, 35,  9, 60, 70, 12,122,178,
187,227, 37, 13,232,223, 76,233, 32,194,237,124,199,  2, 20,163,102,152, 58, 89,
142,217,239,198,132,251,  0,227,167,208,247,187, 69,215,205,254,237,201,233,228,
 81, 78,244,133, 86, 41,147, 79,113,  4,243,149, 56,137, 77, 75,105,103, 43, 36,
207,125,109, 81,195,237,244,218, 56,164,242, 11,109, 72,188,237,182,  1,  4, 62,
156,240,166, 22,184, 49,189,113,189,205,136, 64,111,158, 28, 66,164, 94,197, 55,
243, 29,121,168,223, 85,128, 70,146,233,202, 78,161,198, 71,249, 66, 98, 52, 58,
 25,172,109,134,137,108, 20,243,181, 89,217, 10, 76,145,  4,119, 46,213,121, 94,
146,195, 97,236,186,213,118,  2,103,105, 16, 83, 14, 96, 24, 63,173,160,171,144,
107,224,249, 70,154,253,179,225,126, 27,131,180, 40,252,148,110,227,204,113,180,
 42, 79,233, 66,215,200,171,129, 79, 29,134,155,203,173, 95, 21, 18,255,219,111,
246, 20,196,221, 24,124,153, 47, 51, 55,193,170, 17,175,142, 73,253,158,128,186,
145, 72,245, 57, 93,202,242,171,  9,108,242,195,172,124,231,245,  9, 59,249,136,
 82,  3,171,203, 57,222,220,162,252,  0,184,242,208,133,248,129, 75, 47,172,185,
200,  2,129,132,148,232,157, 68, 66, 94,176,138,230, 16, 14, 73,182,146, 80, 20,
149,163,163, 91, 67,127,200,111,148,237, 43,103,111,111,238,216,  9, 77, 25,149,
 63,238,123, 58,245,130,167, 19,157,228, 53,178,244,  0,156,  1,117,165,234,  8,
217,178,  4,150, 54,192,240,  6,  5,127, 72,  9, 77, 90,231, 25,143, 77,101,204,
  6, 56,216, 73,232,188, 42,180,137,167, 62,173,138,162,189,114,167, 46,174,173,
 11,183, 41,184,162,234,125,121,213, 86,228, 76,120,163,156,177,161, 36,120,136,
 35, 82,157, 70,185,239, 60,230, 47,251,206,184,  8,252, 90,142, 26, 37,213,165,
 50, 45,138,232, 90, 63,242,121,146,117,244,188,170,203, 42, 70,144,145, 58,106,
 87,216, 50,222, 20,  0,222,195,148,105,105, 83,112,223,174,133,173,159,  9,166,
 97,207, 30,246,233,213,  0, 83,183, 18,136,145, 64, 26, 31,193, 54,202,131,222,
184,122,242,128,221, 60,196,248,225,104,232,195,131,198,249,179,160,191, 92,247,
121, 67,201,208, 41, 43,249, 80,176,117, 69,240, 53, 35,133,  6,130,110, 21,174,
152, 73,143, 35, 43,162,109, 45, 12,181,186,114,184,165,253, 82,183,233,221,170,
219,164, 50, 49, 43,  4,152,  2,225,165, 90,155,161,190, 93,228,109, 69,132, 78,
 15, 69,119,174,250,159,132,214,122, 45, 59, 59,132,252, 54,227, 37,156,151,142,
246,215,227,122,132,172,252,249, 13,173,133,167,134,229,140,127, 67, 40, 66, 74,
  9, 61, 62,193,179,191,101,146, 17,203, 47,150,143, 98,225, 20, 36, 60,189, 80,
217, 88, 49,  1, 80, 77,154, 78, 21,160,225, 68,205,184,220,164, 40,205, 53,  3,
 29,101,199,123,170,115,235, 92,204,224,141,202, 31,211,232,150, 36,101, 66,161,
 76, 80, 73,251,166,124,182,228,254,251,174, 89,140,  4, 44, 87,125, 18, 30, 54,
131, 66, 62, 32,207,152, 71,110, 15,200,204,180, 74, 17, 55,241,122,243,129,114,
173,184,135, 91, 64, 19, 56,136,237, 95,122,140,109,215, 51, 24,128,106,217,136,
147, 71,214, 83,220, 51,198,251, 10,111, 70, 67, 33,135,214,191,248, 30,113,250,
 42,171,223,211,166, 37,230, 85,105,244,191,145,236, 40, 82, 16,210,143,159,244,
226, 95,  4,170,134, 27,252,245, 39,239,164, 95, 95,221,229,196, 30,164,211,246,
 63,249,  7,180,247,114,104,253,252,119,208, 14,171,126,112,182,  4,208,212,206,
155,241, 40,195, 57, 73,201, 43,163,108,199, 70,204,208,117,226,167, 74,196, 19,
 26,138, 17, 43, 95,171, 39, 94,184,156,191,214,201,100,  6, 67,184,125, 39,220,
 55, 58,168,255,175,229,248, 90, 92,132, 52, 75,203,136, 60,192,227, 72, 38, 88,
 41, 47, 16,224, 34, 94,245,210, 37,232,192,186,129,196,  4, 37,167,174, 59,170,
200, 18,  7,244,  3, 19,150,107, 78,166,135, 90, 27, 20,103, 32,244,183,239, 10,
145, 19,106,103,131,217,130, 37,222, 12,131,187,153,194, 54,131, 15,107, 48,216,
 87, 29, 16,125,234, 10,227, 61,209,157, 48,228, 46,  8,237, 28, 77, 78,138,249,
240,142, 31,163,184,129, 91,145, 78, 91,214,110, 58, 47, 13,147, 72,110,215,102,
161,187,108,103,168,183, 53, 33,249,209, 59, 94,180, 68,128,169, 15,181,199,123,
 26,105,142,174,  0,136,233, 53,189,181, 91,140,139,194, 26,229,147,130,193,129,
245,181,175,231, 14,167, 61,218,108, 73,152,162, 32,190,162,167,135, 38, 57, 63,
135,108, 90,238,237, 76,138,102,224, 31,189,166, 95,241,202, 34,218,217,  9, 37,
126,246,  5,244,112, 16,  0, 40,170, 74,101,112,168,186, 51, 27,189,103,129,138,
  4, 77,111,253,177,109,185,109,140,213,200,154,251, 64,153, 93,217,119,159, 90,
140, 38,101, 37,226,208, 77,199, 84,155,166,116, 96,166,106,130,187,173, 28,145,
167,169,253, 51, 15,
} ;

// ../Source/assign/template/GB_subassign_08s_template.c:
uint8_t GB_JITpackage_101 [2413] = {
 40,181, 47,253, 96, 43, 88, 29, 75,  0,234, 87,  4, 16, 45,176,172,140,117,200,
198,110, 84, 92,210, 38,247, 24,  2,176, 65,103, 87,121,149,240, 48, 61,159,134,
225, 62,253, 90,219,199,109,152,115,127,155,161,244,  7,253,  7,251, 27,187, 18,
246,  0,238,  0,247,  0,154,205, 85, 81, 85, 15, 74,192, 39, 17, 53,150,140,  3,
137,120,117,198, 29,247,234,167,188,138, 27, 75,  4,229, 27,104, 97, 22,192,183,
137, 14, 54,153,203,130,115,103,233,124,110,207, 27, 13, 10,141,  6,164,111,247,
 80,158,248, 33, 42,167, 76,246,124,108,220,157,178,146,203,243,226,185,210, 83,
141,172,105,197, 50,230,205,146,123, 20,215, 97,152, 60,214, 55, 86, 84,198,112,
227, 77,118,126,235,187,187,153,178, 92,197, 34,  8,203, 76, 27,247,181,167, 78,
 17,144, 60,171, 90,238,171, 17,129, 76, 30,173, 97,210,190, 83,183,103,103,102,
218,153,245,104, 76, 27,155,152,  7,  7, 34,  3,201, 26,227, 54,110,205,113,214,
 60, 83,243,109,123,159,  6, 76, 34,147, 71,  1, 73,100,114,  9,139, 62,225,137,
 33, 33, 14,121, 15,105,185,114,115,243,  9, 62,204,131,102,229,141,160, 26, 95,
105, 97,231,217,193,  6,188,135, 78,220,157,242,247,138,227,  8,174,133,223,250,
203, 65,186, 76, 86, 84,157,234, 44, 55,203,117,142,216, 64, 36, 82,207,196, 88,
 94,116, 56, 62, 68,188,161,161,241,104,104,  8,142,136,214,153,177, 11,225,146,
100,194, 38, 39,105, 40,139,122,235,178,214, 48,124,137, 70, 56,147,125,181, 28,
185,142,218, 91,174, 94,114, 30,121, 45,  0, 60,255,112,111,182,203,109,159,105,
 87,177,204,118,159,112,207, 11,174, 78,120,103,217, 23, 59, 37,121, 99,169, 89,
  9,126,122, 17, 69,131, 77,227,173, 43, 88, 42, 11,  3,227,133, 99,197,137,  8,
 11,194,247, 80,  1,179,166,147,147, 25,125,201,176, 78, 33,243,174,141,245, 16,
161, 21, 95,244,206,148, 34,147, 79,  6,  8,  8,152, 72, 34,146, 79,  7,  4, 68,
 62, 77, 34,199, 17,181,245,149,153, 43,  0,164, 78,213,173,157, 43, 27, 63,116,
 37,237,158,187, 11,220, 53,187,134, 77, 77,194, 39,202, 93,203, 83,194,251, 74,
203,213,234,135, 52,150,216, 51,190, 85,  2,157,207,243,157,250,109,147,199,240,
152, 59,158,218,230,207, 18,171,219,171,140, 86,139,251,222,138,189,181,252,140,
202, 79,161,141, 82,224,219, 24,242,102,232,120,167,243,184,105, 31,178, 73,110,
102, 91, 95,243, 27,215,141,114,142, 21,149,170,210,114,189,168, 16,165,231,219,
152,206,119,200,228, 22, 38,119, 41,115, 81, 84,209, 45,112, 66, 67, 17, 37, 42,
205,179,192,232, 64,243, 38, 46,214,245, 62, 45,192, 80,206,104, 90,243, 43,229,
 14,  7,180,145, 72, 36, 34,191,109, 51, 99, 14,103,106, 15,149, 26,246, 74, 79,
 73,175, 30,157,146,167, 56, 22,191,245, 17, 36,135,188,178,120,120,206,133,  8,
207, 90,252,226, 61,233, 77, 56, 77, 24, 29,198,201,192,112,201,225, 48,163, 93,
237, 64,135,117,160,188,242, 55,107,206, 51,139, 94,167,190, 61,183,185,135,164,
132,199,228,242, 53,187, 94,169, 92,122, 68,175,188, 49,237,236,195,125,171,245,
226,186,168,232,162,156,246,134,241, 30,224, 31,123,104, 63,125,162, 43,136,176,
178, 48,136,153,138,  5, 20, 20, 24,233, 51, 81, 80,110, 14,148,103,124,103,  7,
244,202, 63,207, 81,  0,129, 76, 39,158, 24,107,140,220,125,202, 87,102, 28,223,
140, 46,177,100,162,134, 98,147,177, 52, 21,180, 64,196, 91,179,157, 23,195,157,
221,225,192,244, 14,167, 60,242,202,179,  9,194, 50, 71, 18,165,  2,141, 70,133,
188,117,152,222, 46,247,237,  9,115,147,147, 79, 38,159, 41,227, 70, 99, 89,147,
245, 73,214,249, 86, 28, 41,  6,134,  9,229, 87,  5,188, 42,170, 24, 49, 97, 65,
 76, 88,168,  9,238,164,150,209,152, 31,130,111,103,116, 74,174,111,223, 74, 61,
243, 15,194,249,236,225,124,207, 98, 72,237,112,235, 77,186,124,130,152,176, 22,
196,203, 37,186, 88,180, 78,140,251,218,140, 62,173, 27,158,183,254, 99,241,203,
 43,175, 62, 15, 66,  8, 33,132, 15,240,  1,114, 32,132,240, 65,226,152,236,139,
254,162, 69,  0,178, 56,245,207, 19, 92,194, 96, 42, 38, 34, 16,190,178, 98,151,
217,109,140,166,239, 43, 45, 36,130,197, 51,158,152,205, 43,207, 98,115,195,151,
167,245,184,179,188,109,235, 95,108, 58, 59,146,  7, 39,214, 28, 31,124,250,124,
178,239,246,211,179,209, 33, 44,153, 12,232,147,246, 32,186,  6,169,232,129, 64,
160,109,235, 62,225,219, 54,164,101,158,166, 65,148,196, 71,129,177,194,141, 49,
183,119,238,173, 57,161,205, 90,233,168, 42,125,245,154,255, 78, 73,127,  1,130,
 57,168,242,179, 16, 42,163,204,140,136,136, 36, 73,146,225, 66, 41,  4,194, 56,
 32, 36,138, 24, 75, 15,178, 80, 60,201,241, 20,132, 96,136, 33,  2,163,  4,132,
 24, 66,  8, 33,138,  8,136, 33, 34, 34,209,136, 84,209,166,  3,126,129,242,127,
218, 31,213, 57,206,103, 97, 11,146,167,255,  4,188,166,162, 28, 67,166, 98,253,
 45, 71,  8,109, 56,  3,117,152,125, 67,134,  6, 61,100,236,198, 57,115,144,235,
 49,136,186,184, 35, 94,165,132, 61,244,149,112,240,173, 57,148, 38, 81, 56,231,
 45,114,196, 26,185, 29,161,173,229, 28,119,179, 49,231, 72,152,208,199,245,213,
 77,163,154,242, 96,180, 18,101, 90,166,126,152,143, 22,169, 35, 80,248,  1,143,
189,170, 89, 27,122, 42, 37,196,195,  1,216,215,133,135,170,242,198, 84,241, 26,
 54,160,125, 54,109, 75, 33,136,239, 21,120,157,230,155,173,147,124,224,189,105,
253,  5,168, 68,  1,183, 84,192,120,162, 95, 60,223, 24, 97,124, 90,217,208,249,
102,  7,163,143, 39, 60, 62,167,  5,244,155, 19, 42,190,165, 43,135,106, 37,102,
106,245,106,254,209, 99,148,233,153,190, 28,107,209,245,172, 97, 73, 24,132, 10,
195, 20, 25,156,177, 12,  3, 67, 39,164,255, 22, 60,225,116, 61,139,125,  5, 99,
173,195, 19,130, 51,247, 98, 23,115,249,133, 38, 36,133,230, 12,161, 71,203,155,
225,229, 38, 38,113, 54,102, 87,139, 27, 22,190,124,173,180,119,118,164,109,132,
242,170,141, 94,184,145, 16,255,156,178, 96,130,153, 67,213,136,250,123,252, 46,
208, 32, 46,  9, 19, 94,194,195, 38,129,150,194, 34,121,180,138,184,134, 22,109,
114, 33, 22,164, 68,227, 43, 60,175,139, 15, 95,229, 13,208, 43, 80,167,157,  3,
185,139,106, 45,128,230,251,197, 64,131,198,143, 60,239,187, 48, 33,215,146, 83,
121, 99,115,224,  9,201,216,111,208,234,228,144,  2,114, 91,  7, 52, 69,117,  1,
 84, 36,245, 60,  7, 76,234, 62, 95,232,100, 12,223,252,218,231,105, 62,215,185,
201,113,237,105,152,144, 71, 30, 18,100,211,101, 19,205,130,187,155, 46, 24,194,
  2,140, 19,196, 59,136, 83,105,202,  9,255,109,236,200,188,111,234,132,125,252,
 17, 49,226, 23, 86,178,169,254,130,168,161, 96, 63,112, 65,188, 92, 43,102,156,
 67,233, 66,160,195,141,131,215, 21,161,175,152, 31,147,111,234, 80,115, 21, 73,
237,239,171,174,186,209,143,207, 21,131,129,117, 61,234,209, 12,108, 25, 30,  0,
  8, 26,195, 66, 93, 41,166,202,175, 67,202,255,100,242,103,159, 73, 91,248,171,
101,170, 70,169,224,152,200,194,242,255, 91,214, 75,188,243, 57,240,117,255,192,
186, 77,  9,226, 56,133,172,191,123, 21,146, 86,100, 18,222,130,147, 41, 35, 86,
 37,112,189, 30,108, 49,241,197, 87, 77, 56,112,254,146,233,133,139,118,237, 15,
 60,139, 73, 62,237, 11,119, 73,102,227, 21,  3,155,112, 30, 83,209,122,232, 81,
198, 89, 48, 78,214,160,170,136,126, 71,199,146, 96,210, 88,252,210,244, 52,153,
 35,166, 20,207,121,117, 47, 38, 93,135, 73,240,125, 95, 73,239,113, 70,151,161,
160,231, 69, 19,192,120, 56, 86,225,233,120, 55,229, 44,158,233, 34,161,198,168,
 49, 11,240,211,254,126, 92,188,252,204,130,184, 86, 79, 67,254, 38, 23,116,162,
199,154,207, 99,142, 76, 78,224,107, 70, 32,152,236,207,112,144, 41, 67, 98, 98,
222,100,185, 60,241,  6,245,158,146,220, 44, 78,217, 77,  9, 33,226,250, 20,203,
 48,236,156,165, 10,119,138,202,217,194,142, 81, 56,167,186,180,158,172, 60,202,
184, 20, 19,190,192,144, 70, 13,102,  9, 74, 12, 77,152,200, 55,229,228,136, 38,
128, 12, 77,165,162,167, 77, 91,225,157, 84,121, 68,175,125, 37, 87,101,202, 17,
 39, 29, 52, 47, 15, 49,161, 96,215, 42, 20,157,179,188,247,168, 41,225,182,  0,
 87,104,152, 32,155,135, 89,101, 10,149,108,247,215,238,135, 61,188,  6,200,176,
163,102,184,213, 25, 55, 19, 45,252,197,200, 10,139,183,225, 73,252, 56,219,167,
  8,173,165, 71,188,231,163,214,146,134, 94,214,113, 75, 99,176,175,187,253,213,
135, 82,154, 68,129,158,149,211,151, 90,201,239,239,188, 60,104,230,255,132, 41,
117, 52,170,141,116, 64,211, 29,217,250,147,148, 50,  3,242,199,246,213,151,130,
166,241,217, 81,164,228, 37,226, 21, 34,240,102, 86, 32, 21,134,105, 92, 11,254,
  3, 52,222, 44,139,179,192,139, 22, 51,  5,173,183,226,117,  2, 58,197,133,208,
 22,  5,197, 20,128, 82,131,228, 18,170,214,236, 44, 67,160,183,128,  2,177,170,
 31, 97,162,172,172, 79,228,108,247,119, 34, 60, 93, 99,164,188, 98, 10,206,149,
176,237,119, 12,  0,213, 74,153,  5, 24, 79,199, 73,176, 85,103,122,153,193, 86,
 83, 46, 26, 16,144, 59, 63,148,  8,224,252,169,195,112,212,145,161,132, 28,196,
125, 95,138,122, 82,169,214,248,204,141,122,  5, 49,139,132,148,226,147,184,  4,
194,153,107,183,173,210,105,170,212,176,143,104, 50, 19,236,104,207,222,233, 17,
106,139,242,227,173,234,184, 68, 83,161,130,101,202, 29,229, 43, 89, 95, 86,214,
 23, 37, 18,187, 15,135, 28,194, 71,107, 98,129,144,153,180,227,236,190,102,103,
113,205,154,210,101,193,128,106, 19, 10, 64,200, 28, 67,224,113, 33,121,210,193,
202,222,177, 98,242,230, 29,183,  6,220,  6,200,148, 20, 44,116, 50,139,114,122,
248,191,180,178,103, 38, 87,206, 57,207, 72,166, 62, 49,191,  0, 67, 71, 58, 64,
 27,202, 75, 21,199,  1,200, 78, 71,115, 38,226,179,181,192,112,114, 96,239, 51,
220,238,224,154,214,  0, 19,130,  8,115,211, 39,114, 42,  8,102,164,195, 64, 59,
 25, 44, 14,211, 85,184,128,163, 93,111, 88,147,170,152,120,157,185,210,209, 23,
204, 72,117,  7, 71, 11,135, 47,120, 63, 63,205,243,181, 60,182, 66,173,170,222,
 91,177,134,222, 84, 71,193,159,181,126,132,172, 80,138,217,  4,232,167,247,145,
225,159,197,115,143,168, 34,198,188, 83, 85, 73,185, 88, 50,202, 90,180, 89, 20,
240,103,219,211,179,101,210,229, 27, 75, 60, 87, 45,254,240,227,230,161,165,232,
160,108, 21, 28, 14, 88, 43, 23, 67, 31,137,107, 10, 12, 86,240,  9,155,102,121,
 96,166,161, 37, 18,103,238,145, 12, 85,213, 64, 31,
} ;

// ../Source/assign/template/GB_subassign_09_template.c:
uint8_t GB_JITpackage_102 [2401] = {
 40,181, 47,253, 96, 90, 79,189, 74,  0,234, 85,156, 15, 45,160,204,140,117, 72,
127,255,  2,209,238,  9,  7,126, 98,176,129,137, 77,233, 68,154, 67,142,183,114,
  4,169, 60,152,182,127, 86,230, 57, 15,100,184,225,117,120, 29,156, 14,175, 84,
237,  0,229,  0,239,  0, 51,254,114,180, 61,249, 18,  9,181,216, 85,226, 19, 91,
 62, 65,113,168,140,179,184,239,166, 61,243, 91,158,121, 30, 13,132,229, 30, 87,
113, 26, 56,202,243, 32,120, 58,150,230,246, 86,103,124, 51,198,255,255,241,168,
240,120, 72,185, 85,168,117,252,188,233,252,244,192,120,210,139,226,112, 40, 34,
180,237,186, 32, 95,240,101,254,169,106,244,226, 43, 33,232,150,158, 63,245,181,
217,190, 47,116, 97, 79,190,108,235, 39,  4,147, 99, 52,107,182, 30, 19, 73,133,
129,179, 11, 86,234,147,229,  8,138, 61, 25,171, 24,248, 78,190, 34,135,161,226,
161, 35,193, 88,195,242,229,137,223,206, 48,226,196,165,164, 46, 17,168, 76, 42,
 12,  6, 40,147,202, 33, 87,116,233, 70, 13,248,112,  9,117,142,172,169, 22, 61,
151, 28,197,193,100, 21, 90,136,137,175,133,213,113,199,205, 61,220, 49,102,188,
219, 45,183, 80,194,235,254,242,  4,178,178,149, 44,  7,200, 70,170,162,204, 39,
110, 40,171,198,253, 16, 76,222,196,136,247,194,207,118, 31,  6,226, 13, 13, 15,
134,134,134, 54,235,167,109,243,150,130, 94, 95, 53,122,168, 97, 64, 91,  3, 92,
150,117,107,174,239,185,209, 11,171,219,165,203,241,163, 81, 10,231,134,108,175,
 79,148,172, 66,220, 37, 43,146,120,224,225, 43,185, 67,147,169, 56,238,109, 42,
170, 23,  1, 81, 57, 71, 97, 40,220, 43,116, 40,203, 83, 97,158,171,158, 21, 65,
 38,149, 75,  7, 10, 12,168, 72, 19,202, 37,105,192,228, 82,101,242, 27, 77,146,
 45,236, 72,238, 57, 40,148,135,100, 90,238,134, 85,194,219,241, 29,181, 40,123,
179, 81, 73,  9,207,215,178,  6,180,141, 49, 79,237,198,150,219,225,175,117, 75,
231,221,109,228,121,107,141,161, 59, 97,195,172,207, 23, 94,231,144,147,122,104,
207,120,140,219,242,141,216,116, 16, 16, 61,223, 13, 94,252,137,142,177,133, 44,
 47,137, 90,166, 32, 85, 25, 14,108,210,122,217, 90,122,209, 62,119,180, 19, 78,
251, 24,223,237, 55,158,179, 62,229,  2,201,144, 98,100, 29, 20,255,  9,195,168,
118,182,240, 24,207,168,193, 13,118, 17,235,  1, 27, 60, 79, 45,143, 68, 92,133,
 48,225,137,208, 60,141, 71,195,209, 60, 88,238, 94,230, 50,127,184, 89, 50,150,
129,151, 50,246,253,  4,121,197,163, 79,240, 83,133,197, 45,253,197,228,212, 51,
 22,214,123,251,252,238, 81,  3,192, 20,226,213, 46, 89,245,210,134, 21,221,227,
168,204,133, 85, 45,254,177,162,  6,185, 28,226,164,232,162,187, 23, 23, 22, 14,
113,184,171,209,220, 40,200, 93, 82,250,177, 68,170,131,229,151, 91,145,118, 71,
 12, 68,207, 24,150,181,115,192,  9, 12,149,195, 83,204,242,201, 82,195,186,128,
203,235, 93,189,148, 17,125,193,115, 25,141,131,215,161,104, 32, 33,193,153, 28,
148, 14,150,247,181, 17, 20,250,229, 25,239, 55,160, 64,207,104,105, 95,172,209,
219,165,182,176,239,179, 98,116,138,198, 81, 12, 58,111, 66,194,211,169, 38, 50,
 78,243,240, 44,237, 26,237,117, 25,123, 36,114,231, 29,110,249,228,151, 99, 49,
116, 97, 71,144, 57, 69,162, 73, 99, 95, 86,194, 33, 20,233,138, 26,156, 28, 88,
196,114,195, 56,187,238, 33, 51,186, 24,228,143, 71,199,180, 91,179,221,136,182,
161, 38, 97,229,149,138,103, 66,227, 34,170, 74,170, 42, 24,183,165,247, 77, 11,
 11, 21,203, 45, 10,103, 81,100, 30, 68, 68,245, 16,161,153, 42,175,224, 44,  9,
198,125, 55,152,109,240, 47,185, 48,235,232,152, 64,167,229,154, 78, 23,173,122,
 23, 45,171,106,192,236, 78, 62,107,250, 57,203,152, 77,216, 92,122,136,168, 26,
188,205, 38,218, 84,147,198,187,193,159, 84,222,104,233, 51, 44,190,249,229,153,
 12,231,156,115,206, 97, 28,198, 85, 56,231, 28,134, 18,177, 66,209,173, 87, 19,
 92,132, 44, 62, 61,227, 10, 14,137, 66,215, 66,122, 29, 98,150, 53, 44,164,170,
228,194,226,125, 35,199,243,203, 21,229, 61,252,164,191,220,208,114,165,255, 31,
207,  8, 58,133,161,226,209,126, 17, 46,101, 92,170, 22, 85, 95,163, 63,104, 58,
157,208,165, 44, 66,244, 12,  3, 49, 77,161, 80,232,210,181, 92, 57,178, 14, 53,
241,224, 81, 30, 69,231,101,141, 40, 63, 55, 58, 47, 81,231,168,244,162, 46, 20,
202,131,252,130, 34,217,108,  3,232,144,166,200,117,130, 66,168, 18,172,212, 25,
163,140,204,200, 72,210,164,208, 26,  2, 33,134,225, 64, 32,165,138, 84, 91, 15,
178,160, 44,199,130, 16,133, 56,  2, 66,  8, 33,132, 32, 67,  8, 33,  4, 17,129,
 34, 34, 18, 73, 64, 34, 70,220,140,  1,126,  1,107, 61, 90, 34,169,231, 60,  0,
 76,250,215, 10,233, 83,165,214,196, 50, 24, 69,234,251, 47,253,190, 72,168,180,
225, 49,  4,156, 47,174,243,243,183,  3,186, 25,  1, 68,123,131,  0,200,  5,204,
224,179, 33,131,131,226,154, 14, 74,247,213, 38,218,225, 72,186,201,219, 71, 74,
157,124, 73,118, 24,112, 59,148, 67, 97, 77,168,131, 16,163,217,  5,197,156, 62,
 99,176,160,  8,100, 30,237,184,235,  8, 83, 73, 18, 16, 55, 58,190,173,120, 26,
  6,233, 66,143,217,157, 27,230,231,132,131,148, 19, 98,164,172,170,220,168, 13,
 54,103,135, 20,196, 75,  4,196, 78,249,193, 14,109, 30,237,227,232,104, 17, 72,
166, 66,237,232,198,108,134, 39,155,200,122,142, 38, 32, 45, 92,113,143,244,209,
144,162, 71,184, 38,111,125, 33,135,227,104, 52, 36,123,187,186, 66,171, 76, 31,
  7,192,198, 84,133,177,  4, 55,228, 65,201, 82,245,242,198, 38,195, 56, 65, 73,
 27,123, 38, 71, 84,157, 18, 39,217, 37, 11,141,131, 17, 63,118,149,196,183,134,
 72,203, 52,143,113,228,  8, 83, 60,178,  1,  7,  4, 65,120, 58,229, 91,206,178,
 44, 57,131,173,201, 92, 58,142,230, 81,  2,235, 54,213,227,231, 12, 50,223,123,
166,194,211,199,155,244, 58,  0, 53, 44, 29,165,234, 73,122,209, 34, 35,106,140,
  2, 47, 80, 70,165,174,226, 15,104, 37, 67,248, 77, 66,220,173,  0, 49,165, 42,
 27, 60,214, 45, 39,228, 41,168, 56, 53,162,226, 31,176, 99, 29,153,240,181, 13,
226,249, 34,203, 35,183,129, 67, 49,233,138,205, 99, 49,156,252,203,172, 48,101,
 95, 72,124, 50, 76,232,226, 80,229,152, 37, 42,167, 58, 26,116,132,229, 92,133,
 71, 34,243, 69, 46,132,166,  0, 79,160,246,149, 15, 48, 70,231,140, 66,169, 94,
178,205,150,235,133, 46,108,154, 78,173,116,188, 37,210,155,149,205,146,110,  2,
251,195,233,141,224,166, 16, 59,174, 13, 52, 23,185,248, 43,254,245,244,107,233,
220,129,  7,250,214, 15,232, 20,235,171, 31,253,167,128,209, 40, 25, 54, 80, 90,
254,156,240,117, 89,123, 57,203, 83, 13, 71,141,163,146,  6,151,144,183,102,  2,
 88,  4,177,253, 88,143,140,208, 53,147,192,156,182,145,249,174, 78,185,141,214,
 18, 46,227,254, 37,230, 39,132, 30,154,132,  5,254, 78, 98,113, 12,223,110, 96,
  5, 84,234, 90, 65, 52,246,202,231, 82,246,229,181,200,228, 48,185,211, 42,235,
112,220, 65, 68, 17,114, 34, 49, 92, 66,115,192,231, 56,217,180,234,134,197,116,
130,247,140,143,167,142,193, 11, 56, 12, 34,  7, 66,137, 75,176,  1, 98,192, 51,
135, 96,214,128,210, 92, 71,111,255, 36,108,  8, 15,156,139,164,112, 30,222,164,
154,204, 69, 41,147,203,208, 93,209,176, 26,118, 90,235,  9,141,149,252, 89,183,
125,153,206,104,178,222, 93,205, 56,110,180, 99,236, 69, 25, 76, 50,232,151,172,
 42, 28, 60,170, 72, 87,157, 30,193, 50,209, 24,218, 85,200,170, 92,191,216,252,
 26,249,123, 16,133,183,103, 28,129,135, 47,132, 18,  6, 96,  4, 10,243,103,209,
194,184,147, 19, 42, 18,106,162, 88,221,211,225,242,125, 52,198, 68, 87,170, 52,
 41,191,182,163,137,210,211, 13,118,170,172,201, 79, 38, 45,111,220, 22, 16,208,
113,120,194, 12,180,225,181,132,133,222, 95, 29,246,163,118,225, 99,  1, 23, 39,
244,206,166,201,233, 67,217, 66, 73,173, 23, 60, 33,  3,158,178, 13,149, 75,231,
244,235,205,105,  9, 48,145,133, 86,169,162, 17,164,195, 93,227, 18,  0,134, 39,
 76,200,216,230,  2, 47, 10, 77,132,135, 77,190, 10,115, 55,218, 30,222, 25, 85,
205, 97,221, 29,211, 70,  6,192,186,164,208, 23,102,162,131, 28, 25, 99,142, 33,
 38,205, 19,145, 68,215,234,151, 72,171, 35, 71,197, 37, 86,  5, 60, 82,242,179,
 87,168, 19, 86,252,252, 99,122,107, 84, 87,  7,134, 53,197,188,192, 23, 85, 60,
228, 59,236, 57, 78,157,209, 14,158, 10, 20,212,211, 22, 45,132, 85,134,212,172,
115,103, 36,  9,181,107,138,  3,252,162, 35,  5, 74,227,201,209,122, 73, 69,125,
  7, 17, 74, 38,164,161, 66,137,134,142,108,127,  0,195,250,109,219, 76, 60,206,
170, 23,137, 79, 25, 52,232, 10,213, 19,122,173,177, 34,100, 14,140,167,144,101,
 13,190,146,211, 84,126,138, 87,112,213, 66, 42, 82, 80, 60, 98, 74,249, 66, 95,
135,163,253,205,  5, 65,121, 72, 19,114, 84, 43,195,239, 99,  0, 46,227, 28, 22,
 69, 79,164, 79, 72,172, 91,204, 60,151, 85, 99,203,101, 14,146,174,179, 69,219,
 57,171,105, 80,136, 92, 35, 68, 48,141,148,163,167,246, 21,218,159, 11,124,154,
117,183, 60, 88,137, 53,213, 60,241, 78,133,124,109,183,186,229,  0,132,173, 92,
  2,166, 31,171,  9,105, 31,159, 71, 43,134, 29,111, 15,177, 86, 31,164,246,141,
 50,225, 29,  6,  6,118,  2, 77,122,170,164,161,181,253,227,144, 79,224,211,199,
213, 14, 90,135,242, 46, 83,153,167,125,191,244,255,229,147, 87, 76,254,123, 54,
235,208, 98, 81,100,115,245,132,235,105,110, 96,142,103,198,240,232,207, 95, 36,
 25,162,120, 93, 45,  4,182,164, 51, 37, 34,189,155,114,244, 62,149, 88,  5,211,
124,220,206,221, 20,211, 57, 68, 26,120,  4,195,239,  7,131,248,110,233,105,245,
236, 70, 63, 84,228,189, 50, 62,220,  8, 26,243, 78, 14, 55,  5,223,214,116,140,
230,101, 75, 59, 27,184,159, 82,196,204,152,242,126, 31,144, 69,144,128,109, 47,
 87,231,176, 17, 78,114,128, 87,189,243,197, 82,125,149, 61,  0,192, 36, 43, 50,
 14, 12,233,152,109, 59,225, 30, 71, 73,183,166, 96,146,101,109, 10,  8,167, 91,
220,246, 21, 61,143,248,192,159,123, 79, 50,197,113,151,187, 32,164, 34,130,167,
128,128,188,  5, 66,229,  3,161,111,125, 12,163,213,107,251, 77, 24,170, 22,207,
168, 78, 18,161, 83, 24, 25,  6,213,235, 97,231,230,166,184,185,186,193,130, 69,
239, 17,245,130, 18, 35,184,231,145,196, 73,  4, 16, 70,241,115, 43,126,146,150,
 78,199,125, 26,220,223, 52,245, 90,102, 58,165,104, 89,128, 79,216, 91,161,235,
121,
} ;

// ../Source/assign/template/GB_subassign_10_template.c:
uint8_t GB_JITpackage_103 [2411] = {
 40,181, 47,253, 96,173, 91, 13, 75,  0,106, 87,252, 15, 45,160,172,142,117,152,
130,134,190, 67,214, 31,251, 67, 57,218, 81, 77,195,251,118,233,135,  6,103,  1,
 76,219,162, 93,189, 81,131, 63,206,135,175, 78,120, 29, 94,  7, 99,193, 43, 21,
246,  0,236,  0,247,  0,175, 26,190,  8,248, 34, 98,199,194,153,136,136,148,103,
 58,227,142,187,245, 83,110, 69,143,  5,130,114, 15,188, 48, 11,224,243,196,  9,
 15, 39, 99,193,185,179,116, 62,183,197, 27,141,  9,141,  6,164,111,119,140, 60,
241, 49,168,164, 50,217,243,177,113,247,202, 74, 46,207,138,231, 74, 95, 53,178,
166, 21,187,152, 55, 75,238, 97, 48, 18, 26,174,195, 48,217,152,140, 86,149, 49,
220,120,147,160,238,110,182, 92,197,162,  8,203, 76, 27,247,181,175, 12, 68, 36,
207,170,150, 59,211,136, 64, 38,143,214, 48,105,223,171,219, 19, 52, 51,237,236,
122, 52,166,141, 77,204,227,243,192,129,100, 61,186,141,187,115,156, 53,139,217,
249,182,189, 83,  3, 38,145,201,163,128, 36, 50,249,132, 73,167,240, 28,201,135,
 67,222, 49,180, 92,185,233, 57,  5, 31,198, 65,179,242, 66, 84,141,175,180,176,
243,236, 96,  3,222,130, 78,220,157,242,247,202, 17,108,182, 47,149, 81,248,173,
207, 52, 76, 23,234,146,172, 87,157,229,102,185,206, 49, 34,137,212, 98, 98, 44,
 43, 58, 28, 29, 32,206,192,208,120, 48, 48,  4,175, 60,155, 34, 44,179, 52,209,
202, 33,221, 55, 30,124,146, 80,216,228, 36,197,200,164,222,186,172, 53, 12,127,
162, 18,206,180, 28,185,142,254, 86,208,237, 45, 87, 47, 57, 11,121, 45,  0, 60,
255,112,111,182,203,109,159,105, 87,177,204,118,167,112,207, 10,174, 74,120,103,
217, 23,123, 37,121, 99,169,217,  9,158,122,210,166,129,167,241,214, 25, 22,235,
194,192,120,249, 92, 81,  3,113, 65,248, 28, 36, 96, 38, 47,250,151,139,235,160,
250,  9,156,151,241, 92, 14, 17, 94,241, 73, 83,100,114,202,  0,  1,  1, 19,  9,
117, 64, 64,228,212, 36,114, 44, 29, 58,222,171,173,175,228, 64,250, 86,208, 39,
 78,178,168,219,229,179, 76,158, 74,236,153, 31,210, 34,153, 95,243,105,157, 25,
147,184,233,228,110,231,206, 38,208, 60,237, 81, 75,207, 96,100,180, 90,220,247,
 86,236,173,229,103, 84,158,202, 26,223, 30,201,155,159,  3,158,206,227,158, 55,
211,254,182,201, 55, 70, 39, 62, 53, 77,208, 49, 61, 73,  2,165,210,165, 69,115,
155, 31,178, 73,110,102,187,  9,183, 49,157,239, 16,133,201,125,226,100, 54,150,
100,129,154,206, 38, 70, 88,157,103,129,113,162,243, 52,151, 43, 67, 41,192,124,
209,180,230, 87,202, 29, 14,104, 39, 58, 30,141, 37, 90, 60, 22,140,229,129,114,
 24, 45, 75, 70, 34,219, 54, 51,254,124,112,115, 21,235,138, 87,211, 59,247,214,
217,165, 87,213,135,226,183, 30,130,228,144, 91, 20,185,210,247,220, 85, 28, 79,
168,  0,225, 89,138, 87,188, 55,189,  9, 41,104,169,  9,165,195, 56, 23, 22, 62,
 53, 28,102,180,171, 32,232,176, 13,148, 87,254,102,205,121,102,210,  3,213,183,
197,109,238, 24, 50,194, 99,114,249,154,101, 94,169,124,122, 72,175,188, 49,237,
 44,196,125,171,181, 34, 67, 57,149,169,164, 12,229,180,183,209,123,128,202,237,
161, 61, 21,146,174, 32, 66,203,194, 32,114, 36, 22,108, 54,152, 41, 68, 85, 80,
110, 13,148,103,124, 39, 72,244,202, 67,207, 81,  0,129, 76, 39,158, 90,238, 81,
238, 78,229, 43, 51,142,111, 74,151, 88, 56,177,179,241,112,174,142,  5, 45, 15,
241,214,108,231,197,112,103,119, 56, 48,125,195, 41,143,  4,141, 70, 70,222, 58,
 76,111,151,251,182,132,185,201,201, 39,147,208,148,209,211,185, 46,234,154,100,
157,111,197,177, 90, 88,152, 80,158,145,128, 25,  9, 43, 66,104,174,  7,141,165,
154,192,  7,201, 58,227, 78,106, 23,253,126,  8,150, 90,198,123, 22,194,249,236,
225,124,207,142,164,118,184,245, 54,181,  8,159, 46,167, 30, 52,215,130,120,185,
 72,151,139,214,137, 47,250,180,110,120,222,250, 16,197, 47,175,220, 10, 61,  8,
 33,132, 16, 58, 64,  7,248,129, 16, 66,  7,137,227,137,164,191,104, 35,175, 32,
 16, 81,188,122,232,  9, 62, 73,162,138, 93,102,183, 71, 77,223, 87, 90,  8,  4,
138,103, 60, 49,158, 87,158,197,230,134, 47, 79,235,113,103,121,219,214,255, 47,
 54,157,160, 75, 30,175,252,157,250,196,154,163,131, 83,161, 83,246,221,158,122,
 86,250,131,133,195,161,124, 18,157,210, 28, 72,215, 96, 37, 61,145, 72,180,109,
221,169,219, 22, 67,227,188, 78,131,140,  8,149, 70, 34, 81, 18, 95,165,184, 71,
115, 59,237, 62,149,222,122,175, 98, 89, 90,174, 21, 25,113,122, 14,130, 54,168,
242,195,210, 49, 83, 34, 35, 35, 73,146, 66, 90,  3, 18, 41,132,226, 64,158,195,
138,148, 82, 15,162,120, 44, 73,178, 16,131, 96,  4,132, 40, 66,  8, 49,134, 16,
 66,  8, 35,132, 16,130,136,  4, 18,140, 76, 85,105, 58,126, 65, 64, 77, 53, 54,
213, 57, 14, 23,  9,  8,146,177,107,133,199, 83,116, 57,222,  8,213,234, 91, 14,
173,109,176,223,116,248, 42, 85,134,198,157, 31,174,104,107, 81, 16, 52, 78, 16,
 58,186, 43, 94,229, 85,240, 16,137,232,193,183, 83, 29, 77,162, 64,149,182,228,
136, 22,114, 59,138, 54, 75,226,120,199,102,170,148, 48,178,197,207,166,155,134,
197,249, 49, 34,139, 50,204,147,214,253,143,212, 41, 42, 40,148,162,199,151,213,
240,  0, 93,221,116,120,168,  0, 16,134, 15,141,139,239,193, 46,230, 74,108,152,
 38,179, 25,130,134, 18, 67, 61, 96,119,171,207,  3,189,242,111,240, 17,184, 45,
144,115,132, 17,180,144,165, 54, 79,169,241, 68,129,122, 33,245, 20, 98,116,176,
213, 55,197, 24,146,168,161, 41,227,167, 49,131,184,173,253, 80, 38, 67,128, 46,
174, 87, 65,149,123,130, 93,198,233, 26, 70, 89, 70,228,171,169,203, 96,178, 47,
 27, 50, 28,132, 58,128, 33,172,198,153,184, 18, 38, 34,172, 14,122,217,  2,201,
 92,100, 43,196,238, 95,187,131,207, 95,161, 45,179, 84, 70,180, 86, 69, 32,147,
236,131, 15,132,150, 44,150,103, 98,219,153, 63,127, 25, 90,239,226, 97,235,191,
185,209, 35,131,  7, 88,238,198, 34, 33,226, 74,  8, 15, 78, 45,237, 47,247,127,
 84, 70, 64, 67,216, 49,164, 18, 46,188,193,183, 73,244, 62,228,114,  8,224,232,
141, 79,195,129,146, 84,219,216, 72, 70, 88,146,143, 58,201,139,104, 53,254, 33,
 34,146,130, 26, 24,225,171,170,135,150,151,  8,120,229, 65,212,  7,168,115, 72,
135, 20,  4,181, 22,252,248,221,121, 10, 73,173, 56, 14, 39, 21,232, 66,212,196,
 42, 40, 72,108,135,140,193, 57,132, 97, 40, 29, 58, 96, 45,124,192, 90,136,168,
108, 56,198,166,226,180, 17,145, 53, 63,233, 67,193,130, 47, 25,237,219, 53, 15,
108,238, 26,103,  6,173, 81, 33, 65,192, 36,190, 40,134, 45,223,107, 14, 54, 68,
207,159,103, 63, 96, 17,103,184,136, 95,184,132,223,223,139, 90, 35,225,239,150,
175,217,131,234,175,175, 19, 23, 99,165,142, 90,231,  7, 60, 72,210, 22, 19,217,
232,205,128, 41,103, 21,128,127,160, 67, 29,131, 68,135,150,188, 66,126, 33,254,
 96,144,173, 29,141,253,146,  8, 51,251,199,199,196,128,228,137, 99,145, 63,192,
 52, 50, 44,211,200, 16, 52,238, 41,119,248,255, 98, 64,251,135,253,214,198,204,
171,104,150,154,224,108,  4,157,109,199,192, 98, 85, 32, 42,198, 30, 44,124,183,
  5,228, 29, 21,146,214,119,103,200,178, 73,142,159, 33, 82, 54,181, 76, 27,144,
217,179,134, 67,228,191,186,231,  3,191,170,246,238, 51,220,113,156,181,208, 15,
 84,108, 63, 83,122,185,147, 71,105,168,205,124, 81,188,162, 20,101, 34,235,241,
182,185,233, 66, 91, 97,243,135,217,175, 32, 87, 15,159, 68,186,179,254,162,247,
247, 17,142,158,100, 49,203,195, 53, 58, 19,185, 21,141,  6, 69,114, 12,182,196,
 71,153, 99,108, 38,230, 80,253,248, 39,129,246,165,155,155,124, 51,172,  1, 55,
 34, 47, 34,  6, 86,224,192,  8,178, 13, 15, 58,151,242,223,197, 12, 10,  8, 10,
 35, 49,140,126,110, 13,235,122, 12,238,127,148, 49,209,185,212,211, 10, 22, 49,
141,195, 24, 70, 56,141,231, 41,134, 74,244, 38,148,165,189,231,136,120,143,122,
206, 16,181,207, 29,101,215,129,231,246,238,146, 37,183,147, 10, 89,168,136,187,
101,202, 73,204,150,141,120,176,211, 76,234,109,  0,127,153,182, 45, 60,178,148,
148,146, 56,228,192,247, 35,125,235, 75, 82, 56,131,100,156,240,105,219, 93,250,
128, 92, 52,130,147, 40,166,145,240,209,  8,  9, 23, 33, 71,148, 93,180, 25,188,
108,165,158, 88,  4,  4, 64, 67, 49,187,172,101, 36, 20,178,236,203, 49, 17,157,
 77,120,255,161,247,224,165,  0,114, 52,184, 10,158, 95,245,110, 84,125,242,101,
253,190,158,  1,112,127,180,173,111, 33,184, 48,105,231,241,252,175,236,219, 78,
130, 88,124, 24,237,113,133, 54,244,  0,116,158,106, 45,209,208, 11, 98,214, 82,
 12,216, 64, 96,127,  5, 93, 74, 35, 20,  0,193,115,230,169,229,187,238,210,203,
109,204, 58,149,107,181, 53, 41,209,129,131,119,122,205, 73, 50, 66, 87, 48,207,
200, 23, 17,197, 73,195,182, 81,181, 18,  1,235, 51, 17,209,  8, 41,244, 42, 16,
104,192,150, 86, 30,  0,245,102, 12, 78,211, 47,150, 95, 81, 32,  9, 87,100,156,
  8,168,134, 23,138, 26, 96, 76, 17,128, 53, 98,180,100, 48,150,178,243, 77,160,
 90,144,153, 13,143, 71,248, 81,222,234,227,226, 44, 78,  5,230, 47,191,209,202,
155,233, 43,183,234,  4,127,239,  9,216,134,166,196,103, 87, 59,142,132, 68,221,
125,204,246, 84,154,186, 72,155, 64,236,202, 47, 51,236,204, 78,193,164,135,  1,
240, 13, 14,148, 37,169, 18,198,233, 73,175,210,233,115,128, 36,171,252,198, 18,
180, 84,195,196,  5,138,103,219,110, 47,177, 90,148,114, 53,101,243, 25,152,147,
 71, 43, 83,221,156, 72,176,148, 62,178,170, 98,  0,199, 36,140,250,222, 66,165,
 60, 73,  4, 40, 31,219,220,249,183,119,124, 29,135,110,  9,130,182,200,185, 90,
254,214,153,232,155, 59,182, 80,179,168,  0,  3, 60,217,206,233,149,159,240,193,
  2,167,222, 15, 52, 67, 84, 54,162,168,165, 69, 60, 51,222,209,109, 24,123,201,
192, 87,168,192,114, 50, 75,144,212,  7, 82,171,206, 97,137,133, 17,175,188,202,
 37,237,  6, 68, 44, 75,185, 31, 24, 41, 37, 53, 77,  8,201, 82,192, 50,235,162,
 34,139,175,241,  7,151,121,182,226,  7,247,200,210,214, 87,170, 16,204,155,208,
 84,126,222,250, 85,125, 80,202,178,  5,240, 83, 32,224,170,  0,123, 27,144,230,
 50, 46,243,177,111, 88,210,109,151,106, 50,181, 60,  5,118, 46,219, 15,199,199,
117,248, 76,199, 68, 84,224,164,110,146,131, 89, 95,127,121,128,239,239,102, 83,
 88,111,148,236,110,239,195,125,162,244, 65,133,210,  0,221, 52,155, 90,102,138,
 91, 65, 56, 11,156, 66,213,170,234,206,  3,
} ;

// ../Source/assign/template/GB_subassign_11_template.c:
uint8_t GB_JITpackage_104 [2408] = {
 40,181, 47,253, 96, 95, 79,245, 74,  0, 74, 86,188, 15, 45,160,142, 85,231,184,
 92,111,242,206,110, 63,237, 92, 35, 91,243,117, 80, 76, 55, 65,233, 99,192,111,
199, 88,101, 93,191, 94,150,202,229, 25,109, 49,225,117,120, 29,172,151,163,102,
239,  0,229,  0,240,  0, 15,114,125,198, 95,142,182, 39, 63, 34, 33, 23,187, 74,
124, 98,202,223,  4,133,161,170,135, 93, 20, 85, 69, 93,220,183,227, 94,253,148,
 87,152,230,242, 64,185,230, 89,152,  7,143,210, 96, 18, 52,153,235,114,187,171,
 51,190, 25,227,255,255,120, 88,120, 60, 42,228, 58,110,222,116, 70, 15,141, 39,
205,168,137,235,178, 12,114,  6,177,202,210,243,167,206, 58,219,151,175,132,156,
202,209, 12,235, 92,216,147, 47,219,250, 73,146,174,209,173,249,122, 72, 34, 19,
  6,222, 50, 88,169, 79,150, 35, 39,246,100,205, 98,224, 59, 57,139, 24,134, 10,
135, 76, 68, 99, 13,203,151, 39,126,123,195,136, 19,151,146,122,100, 96, 34,153,
 48, 32,144, 36,147, 67,217,243,232, 70, 13,232,240,  8,245,142,173, 41, 23, 53,
143, 30,133,177,108, 21,218,135,137,175,133,245,113,199,238, 61,222, 49,102,188,
221, 41,183, 80,194,236,190,  2,249,  2, 89,217, 70, 87,  3,  4, 17, 89, 79,245,
137, 27,202,202,113, 99,146,132, 77,140,120, 47,220,116, 23,179, 60,156,  0,129,
  7,  3,  1,  2,  1,207,213, 32,219,173, 49,174,155,183,148,243,250,202,209, 67,
 14,  3,218, 26,224,178,172, 93,115,125,207,142,102, 90,237, 30, 93,142, 27,142,
 86, 56, 55,100,155,125,146,182, 10,189, 71,215, 35, 17, 65,195, 87,242,133, 75,
101, 97, 30,  6, 81, 97, 97, 17, 15,214,123,148,133,226,221, 66,134,186, 52,150,
  5,123, 22,118, 61,144,100,242, 40,193,129,  2, 19, 73, 34, 61,138, 10, 72, 30,
 77, 36,191,207, 36,217,194, 76,228,190, 67,129,228, 17,153,150,187, 97,149,240,
118,124, 71, 46,202,134,224,176,164,132,231,107, 89,  3,218,214,152, 39,119, 99,
203,238,240,247,186,165,243,239, 54,242,188,181,198,206,157,176,225,214,231, 11,
179,119,200, 73, 53,180,103,188,198,109,249, 70,109, 62,136, 67,207,183,131, 25,
111,158,107,108, 33,203, 44,162,150, 43, 68, 86,213,161, 77, 90, 47, 91, 75, 51,
218,231,142,118,227,180,175,241,237,126,227,121,235, 75, 21, 40, 35,138,207,117,
 78,252, 39, 77,163,220,217,194,107, 60, 35,  7, 57, 56,209,244,188,230,224,121,
 74, 57,  4,242,170,132,  9, 77,196,  5,187,104, 46,152,139,  3,229, 15,171, 46,
243,134,155, 37,107, 21,188,148,177,239, 39,232, 21,127, 62,193, 79, 21, 22,183,
244, 23,146, 83,175, 44,174,119,183,249,223, 35,  7,128, 43,196,203, 61,186,234,
 35,142,235,185,230, 81,213,197, 85, 45,190,185, 34,  7, 85, 14,189, 40,190,231,
 15,139,  2,  4, 28,106,248,171,207,236, 40,231, 93, 82,186,161, 64, 42,111,160,
188,242, 43,210,238,168,113,232, 25,195, 50,247, 14,184,193, 48, 57, 60,213, 40,
159, 44, 53,174, 15,168,188,254,213, 71, 25,207, 27, 96,175,186, 64,192, 50, 20,
 15, 36, 36, 48,211,131,178,129,242,190, 54,114, 58,175, 60,227,141, 21, 56,208,
 51, 90,218, 25,107,116,247,168, 45,236,139, 93,241,185,116,121,148,131, 12, 54,
 33,161,201, 88, 19,213,187, 56, 96,150,118,141, 54,187,172, 29,  2,185,243, 13,
167, 92,242,202,181,216,185,176, 31,104, 78,144,103,210,216,153,165,112, 72,138,
178,200,193,217,161, 61, 44, 59,141,183,236, 30,154,  1,143,199,133,105,187,102,
203, 17,109, 67, 78,194,201, 39, 19,205,196,229, 69, 88, 86,100, 77, 52,110, 75,
 47, 54,  9, 16, 48,161,252,162,120, 23, 69,133, 61, 68, 88, 14, 17,151,105,114,
 11,239,138,104,220,183,131, 27,  7,255,145, 11,183, 11, 23, 54,232,188, 94,211,
249,226, 85,255,226,117, 85, 13,184,253,201,111, 77, 55,103, 25,183, 13,136, 71,
 14, 17,214,  3, 12,  2,226,129,176, 38,141,151,131, 63,169,188,209,210,103, 88,
 28,226,149, 87, 25,239,189,247,222,179, 60,203,171,120,239, 61,139,  4,185, 58,
207, 47,172, 46,184,232, 88,124,122,198, 25, 28,194, 96, 40, 34,158,206,181,144,
102,135,154,101, 13, 11,169, 26,185,176,120,223,136,209,188,146, 69,121, 15, 63,
233, 47, 55,180, 92,233,255, 99, 60, 35,231, 18, 67,  5, 70, 27,155,240, 40,227,
 81,189,168,250,250,220,225,146,201,116, 30,109, 19,158,111,150,135,105,234,116,
 58, 82,118,143,174,229,218,177,101,168,137,  8,152,132, 81, 91,199,141,203, 26,
 81,126,118, 29,178, 86,232, 20,164,170, 72, 18,  6,253, 66,138,116,182,  1, 92,
  8,130, 64,168, 34,172, 18, 34, 83, 50, 35, 34,146, 52, 41,180,  6,  2, 33,134,
225, 64, 32,165,138, 84, 91, 15,178,128, 44,  7, 67, 24,136, 80,  4,134, 16, 66,
  8, 97,132, 16, 66,136, 33,  2, 69,  8, 33, 34, 18,208,136, 17, 55, 99,126,193,
172, 30, 13, 48,169,231, 48,251, 37, 61,126,133,156, 83,245,215,100, 51, 24, 62,
234,213, 47,253, 10, 72,168,180,225, 49,132,159, 47,174,243,243,183,  3,186, 19,
  0, 68,123,129,254,199,  5,204,224,186, 33,131,131,224,150, 14, 74,247,205, 38,
218,193, 72,184,201, 91,143,148,  7,249,146,236, 16,248,115, 40,135,162,154, 80,
 15, 31, 70,179,217,196,220, 61, 99, 48,157, 34,192, 29,113, 50,234,  8,181,100,
 39, 32, 62,116,236,173,120, 78,  6,232, 66,105,217,157, 15,242,115, 22,124,148,
 67, 47, 82,190, 74,110,212, 10, 54,101,135,116,196, 75,  4,196, 78,249,189, 14,
109, 30, 33, 70,209, 81,  9, 72, 46,  4,218,209, 10,217,140, 56, 54,177,121,142,
 94, 88, 58,184,226, 12,233,163, 25, 69,143,108, 77,222, 56, 78,222,142,163,235,
144, 28,227,234,152,172,162, 61, 28,  0, 33,147, 90,177,  4, 23,224, 65, 73, 81,
117, 54, 68, 77,246,221,  4,161,108,108,152, 27, 17, 23, 37,142,109, 75,182,181,
 13,134,253,235,170, 79,111,205,114,  3, 45,143,126,100,130, 57, 60,234,241,  6,
240,129,215,115, 42,170,156,109, 54,114,150, 76,147,152,105, 28,233,162,  4, 86,
 26,212, 35,193, 25, 94,190,223, 76, 61, 77,159, 69, 41, 65,  0,230,176, 52, 79,
213,249,243,162,178, 92,169,  1,251, 93, 64,142, 74,176,226,150,103, 37, 77,184,
111, 66,240,150,152,151, 82, 85, 27,188,144, 91,206,222,233,167,248, 57,161,226,
 82,175, 99, 74,153, 64,107,155,130,242,197,152, 23,119,171, 67,161,229,138, 39,
 81, 22,168,252,101,125,  9,201,254,224,239,201,136, 16,241,161,209,202, 18,133,
 51,254, 13, 10,130,229, 32,133,115, 34,161, 69,238,132, 13,  1,158, 94,219,119,
 31,192,141,162, 51, 10,133,123, 73,106,182, 70, 47,244,133,153, 32,181,178,227,
173,145,222,172, 45,150,116, 11,236, 73,206,  1,128, 79, 66,204,120,107,160, 77,
104,241,  4,223,232,156, 15,235,220,129,111,245,218,223,230,142,245,168, 23,120,
115,225,227, 22,137,239,161,166,252, 53,226,107, 86,123, 25,170,167, 83, 78, 20,
 71, 50, 13,251, 66,254,154,  9,110, 17,158,237, 19, 59,178, 48, 93,131,  4,249,
105, 51,224, 59,159,114,115, 75,216,127,215, 31,246,160,190, 96,194,241,254, 88,
 87,140,111,223,102, 98,181,234,106, 21, 32,242,124,101,  3, 82, 18,126, 59, 48,
 23, 85,238,172,103, 58, 84,124,152,  9,132, 42, 95,124, 46,237, 28,196, 45, 78,
126,106,117, 23, 99,154, 56, 67,222,139,250, 24, 99,129,139,228,178, 45,100,134,
148, 12, 96,211, 59, 45,  7,166,  1,148,175, 30,127,118,158,183, 93, 29,184, 39,
145,194,177,241, 86, 75, 50,207,  1,153, 92,123,238, 24, 71,213,176,203, 90,155,
105, 84,171, 40,133,118, 47,211,  1,154,124,162,155,154,113,234,180, 71,237, 81,
 35, 76,206,200,151,172, 20, 14, 40,106,163, 85, 39,143,128, 74,180, 48,218, 86,
136,149,133, 18, 54,209, 31,127,246,208, 92,223,117, 89,192,200,139, 46,129, 33,
 84, 32, 78,254,115,111, 24,103, 89,  1, 88,208,122, 68, 52, 56, 15,135,235, 83,
 19,166, 64,165,140,146,  2,180,237, 39, 74, 71,183,246, 84,121, 38,191,104,181,
192,184, 77, 64, 66,111, 17, 84, 51, 80, 17, 23, 55,100,244,255,213,241, 28,226,
133,171,  5,120,156,144,155, 29,222,211, 39,164,133,114,176, 94, 44,139, 12,148,
  8,109, 92, 94, 10,210,111,109, 78,244, 96,144, 44, 48, 72,181, 26, 17, 58, 92,
 18,165,225, 78,158, 48, 69,198,118, 22,152,160, 16, 68,120,  0,227,187, 48,149,
 70,147,226, 61,148,170, 25,214, 57, 51,109, 48,  0, 75,113,133,154,152,  9,  8,
146,204, 24,113,140, 43,169,137,136, 40,186,134,110,137,207,234, 16, 82,193,141,
181,  6, 30,117,252,172, 10,117,207,138, 31,202, 49,189, 48,149,103, 73,218,111,
 71,121,188, 22, 97,120,  8, 49, 50, 58,230,233,180,214,167, 59,130,200,215, 69,
211,183, 10,124,156, 53,120, 31, 73,116,186,140,124,180,190,192,165, 36,105, 64,
135, 81,169,196,206,237,124, 34,231, 39, 79,189,138, 13, 26, 92,105,224,  1,150,
235,199,123,179, 76, 78, 32, 47,198,109, 45,200,246,138,217, 19, 28,156, 94,196,
226, 11, 48, 83,108,103,141,200,146, 50,149,124,201,107,215,104,225, 68,171, 94,
 30,161,167, 60,166,143,231,146,253,  7,  6, 83,121,206,  9, 49,170, 77,254,247,
233,  0,215,113,142, 83,209, 13,  2, 18, 66,213,237, 40,207,106,213,152,242, 59,
129,162,235, 72,209,118,206,106, 27, 20, 38, 43,  8, 17,163,145,237,232,169,185,
 66,253,115,101, 83,  3,221,173,  8, 32, 49,161, 58, 36,222,144, 80, 81,237, 86,
145, 23,128,184,149,123,212,244, 71,110, 34,218, 71,200,104,245, 88, 71,223, 67,
 88,251, 15, 70,246, 45,248,240,234,  3,173,158, 96, 37,253,149,246,180,150, 62,
206,241,  9, 24,253,  4,218,225,236, 80,216,165, 18,243,180,242,255,167,206,127,
 79,207,148, 60, 97, 59,172, 74,148, 26,174,157,124, 62,201, 13,203,245,200,153,
188,191,156,100, 94, 48, 80,244,187,224,  8,112,255,222,244, 16,141, 79, 41, 11,
247,101,197,186, 49,205,198,119,222, 83,113,102, 14,  9,  3, 47, 16, 30, 63,224,
136,183,154,118,168, 14,221,104,148,138,151, 87,250,173, 27, 67, 99,208,201, 33,
161,224, 97,107, 17,163, 70,182,246,179, 93,102,151,250,249,200, 52,247,114,192,
 35,130, 36,108, 11,177,141,149,110,116,226,  3,187,170,129,175,151, 10, 87,121,
  3,  0, 68,146,162, 27, 71, 67,160,203,214, 29,185, 63, 70, 41, 64, 83,  7,202,
 66, 81,  5,133,173, 75,190,173, 21, 41,159, 56, 36, 66, 95, 74, 56, 37,156, 58,
152, 32,120, 17,205, 39,  9,128,100,244,173,241,  3,213,145,181, 48,140, 86, 31,
228, 55,209,169,218, 99, 66,117,155, 17,140,140, 62, 24, 36,133,252,161,230,137,
 36,111, 89, 39,249,160, 59, 70,112, 27,120, 93, 94,160,238,215,123, 53,119,241,
 65, 83, 45, 18,135,181,250,153,  4, 42, 37,116,211,132,104,153,137,184,242, 34,
 21, 56, 37,163,117, 20, 49,  6,
} ;

// ../Source/assign/template/GB_subassign_12_template.c:
uint8_t GB_JITpackage_105 [2403] = {
 40,181, 47,253, 96, 31, 93,205, 74,  0, 26, 86,216, 15, 45,176,172,140,117,136,
207,221, 72,123, 73,155,220,125,  8,192, 38,190,123,171, 75, 64,159,154, 70, 28,
195,121,250,181,182,143,219, 48,231,254, 54,131,240, 79,233, 79,211,187,227, 18,
242,  0,236,  0,245,  0,239, 33,122, 48, 29,137,135, 88,249,166, 51,238,184, 91,
127,229, 86,252, 96, 28, 42,255,192, 75,195,  0,190, 79,148,248,116, 54, 24,156,
 59, 75,231,115, 91,220,225,152,224,112, 68,250,118,215,200, 19, 95,131, 74, 42,
147, 61, 31, 27,119,175,172,228,242,172,120,174,244,149, 35,235,155, 49,173, 88,
198,188, 89,114,175,226, 58, 12,147,141,201,104, 85, 25,235, 50,110,188,201, 80,
119, 55, 91,174, 98,113,132,101,166,141,251,218, 87,148,201,179,170,229,222, 56,
 36, 17, 10,164, 53, 76,218,247,234,246, 12,205, 76, 59,187, 32,141,105, 99, 83,
  3,  1, 53,116, 34, 89, 95,220,198,237, 57,206,154,197,244,124,219,222, 41,  2,
 20,  9,  5, 98, 96, 34,161,124,194,164, 83,120, 94,200,134, 71,222, 53,180, 92,
185,249, 57,  5,159,230,162, 89,121, 29,170,198, 87, 90,216,121,118,208,  1,111,
 65, 39,238, 94,249,187,229,241,  4,155,237, 75,109,  0,252,214,111, 24,166, 12,
117, 73,214,171,206,114,179, 92,231, 72,153, 68,106, 49, 49,150, 21, 29,142, 23,
135, 47, 44, 56, 32, 11, 11,  1,241,241,192,244, 12,175, 92,114,203,179,153,165,
137, 86, 15,137,214,153,177,123,  7,132, 79, 19, 10,155,156,164, 26,153,212, 91,
151,181,134,225, 79, 84,194,153,236,171,229,200,117,161,219, 91,174, 94,114, 22,
242,218,  0,120,254,225,222,108,151,209,182,207,180,171,216, 51, 42, 51,219,157,
194, 61, 43,184, 42,225,157,101, 95,236,213,228,141,165,102, 39,120,234, 73, 16,
 14, 62,141,183,222,192, 88,151,  6,198, 12,232,138, 28,135, 11,194,119,137,128,
 89,211,201,201,140,206,100, 92,159,208,121,155,207,117,137,240,138, 79,122,104,
 78,212,129,  2,  3, 40, 19,  4,  3, 36,167, 40,146, 99,233,240,241, 94,109,125,
101, 39,114,107,182,243, 98,184,179, 75,236,118, 54,167, 91, 79, 77, 78, 73,164,
143,176,228,222, 90,126,168, 30, 55,150,216, 35, 89,223,217, 69,232,139,231,167,
233, 61, 38, 40, 73,160, 84,146, 22,205, 65,188,226, 83, 89,227,219, 23,242,230,
247,128,167,243,184,231,205,180,191,109,242, 85, 87, 14,186, 60,159, 77,132,101,
 61,248,  0,  3,242, 97, 85,122,235, 61,139,101,105,185, 86,196,233,249, 54,166,
147, 98,242,247,  8,165,145, 51,154,214,252, 90,249,227,  1,237,134,132,231,195,
193, 68,204,  7,163,169,192,104, 97, 84,218,185,183,206, 44,249,109,155, 25,191,
154, 14,186,244, 74,190,  2, 77,252,214, 83, 72, 30,185, 53,  1, 96,114,159, 58,
 27,  8, 75, 58,  6,114, 60, 16,241,193,242, 60, 12,140, 18,158,199,185, 46, 49,
115,109,222,115, 87,113, 60, 33,  0,138,103, 39, 94,241,222,244, 38,164,160,165,
 38,148, 14,227, 84, 80,248,196,112,152,209,174,134,224,195, 50, 84,110,249,155,
 53,231,153, 73,207,226, 54,119, 13,137,  1,161, 92,190,102,155, 91, 44,159, 32,
210, 45,111, 76, 59, 19,113,223,106,173,216, 84, 78,109, 42,105, 83, 57,237,237,
226, 93,128,229,246,208,158, 18, 73, 95, 16,161,133,105, 16, 59, 17, 12, 32, 32,
 52,147,136,170,160,220, 24, 42,207,248,206,208,232,150,139,158,227,128,  2,153,
 78, 60,181,124,107,198,250, 34,119,167,242,149, 25,199, 55,165, 79, 48,157,232,
129,248,116, 46,143,  5, 49, 13,  1, 14,199, 70,222, 58, 76,111,151,251,182,132,
185, 73,202, 79,161, 64,209,148,241,227,185, 46,234,162,100,157,111,197,177, 82,
 80,160, 84,190,137,128,155,  8, 43, 58,112,174,  6, 14,166,162, 60,248,112,115,
 21,235,138, 72,214, 25,119, 82,203,232,247, 71,176,212, 54,222,179, 16,194,249,
236,225,124,207, 94, 72,237,112,235,109,106, 24,159, 50,167, 26, 56, 23,131,152,
201, 72,153,139,214,137, 51,250,180,110,120,222,122,209,196, 51,183,220, 18, 61,
  8, 33,132, 16, 94,224,  5,130, 32,132,240, 50,121,188,145,244, 23,237, 45,  9,
 70, 19,175, 46,186,130, 79, 26, 77,  4, 71, 26, 85,236, 50,187,125,209,244,125,
165,141, 80, 76, 60,227,169,249,220,242,108,168,190,177,185,225,203,211,122,220,
 89,222,182,245,177,233, 12, 77, 32,160, 88,115,124,112, 74,116,202,190,219, 83,
207, 74,111,192,116, 58,149, 79,163, 83,218,  3,233, 26,172,164, 55, 26,141,182,
173, 59,133,111, 91, 13,173,243, 60, 14,222,147,196, 73,124, 90,158, 24,184, 47,
230,118,218,129, 52, 54,107,  3,130, 55,168,  2,188,210, 41, 99, 34, 35, 34,146,
 36, 73, 90,  3,130, 41,  4,226, 64, 28, 36,138,148, 74, 15,194,120, 48,199, 67,
 36,194, 64,  4,132, 40, 66,  8, 33, 72, 64,  8, 33, 72, 72,  8, 81, 36,144,  9,
 70,196,138, 54, 29,126,205,244, 99, 53, 34,162,115,156, 20, 41,  8,  2,208,133,
 29,157,211,232, 28, 47, 68, 61,234, 91,142, 87, 54,112, 50, 29, 76, 95,149,161,
225,199, 15, 50, 90,129, 88, 19,218, 11, 20,160,110, 19,175, 82,104, 55, 84, 83,
 56,100,222, 69,137, 99,187,235,104, 18,229,187,180,145, 99,136,144,219,241, 48,
250,195,129,174,189, 93, 65,140,247,136, 61,212, 29,113,140,228,123,134,177, 88,
148, 57, 51,121, 33, 62,150,185,192, 82,232, 72,143,243,213,  6, 29,122,231,185,
240, 59,  4,104,145, 17,222, 58,223, 27,217,121,  2,177, 17, 26,207,198, 53, 62,
148, 56, 97,192,235,114,255, 52,158,230, 67,103, 56,198,119,129,202, 19,177, 81,
  5,164, 57,250,104,254, 17, 76,103,229,215, 24,161, 50,230,137,244,151,106,225,
228, 20,239,130,161,164,122, 56,154,219, 43,174,168,176, 13, 80,198,246,128,100,
111, 86, 18,195,152,133,229, 89,196, 34, 43,218, 36,138,218,242,196,152,130,107,
208,122,128,138, 27,142,155, 61,  9, 19, 40,118,177, 72, 72,147, 13,219, 83, 57,
252,208,154, 97,179,159,177,173,240, 88,239,145, 76,189,159,193,134,215, 62,138,
241,153,129,110,228,  3,225, 83, 20,254, 95, 34,114,172, 40,225,250,130, 82,130,
 84,152,113, 99, 12, 66, 92,130, 50,185,218,215,158,154,152, 16,169,  2, 12, 18,
 55, 65, 32,236,227,211,  1, 83,132, 66, 71, 18,233,  2, 90,156,182, 52, 12,151,
 68, 36,230,  7,241,195,122, 37,178, 32,232,160,101,152, 34,137,135,148,207, 64,
 11,239,133,123,241,191, 11,132, 42,167, 30,166, 13,157, 47, 28,209,125, 91, 45,
  4,253, 91,253, 20,198, 14, 28,207, 65,133, 87,136,242, 79,140,120,232,175, 44,
118, 54, 49,225, 54, 29,118,176, 77,106,181,205,156,170,104, 69,197,126,141, 57,
 43,133, 60, 50,199, 85,205,240,157,173,253, 12,233,157,231, 83,198,233, 67,235,
161,144, 24, 97, 18,178, 40, 35,155, 33,133,234, 98,180,100,132,253,136,173,101,
 72,127,164, 13,114,232,252,251, 66, 34, 82,119,110, 27, 52,123, 80,254, 56,152,
226, 22,172, 41, 92,173,  8,162, 88,193, 10,159, 19, 22,238, 18,147,170,228,  9,
172,142, 14,245, 52,228,102,  7,124,157, 58,126,187,115, 95,212,213, 25,190, 93,
203,198, 63, 40, 56,198, 69,152, 99,157, 16, 19,146,150, 33, 30, 16,120,160,236,
193,124,206, 87,233,254, 16,114,175,181,210,  1, 89,230, 77,  3,191,231, 71, 95,
 77, 36,115,  4,224, 55,138, 64,193, 58,  1, 84, 28, 42,203, 85,214,126,146,114,
196,132,121,236, 54, 19,166,119,201,141, 83,  8,103,149,108,131,146,172, 77, 39,
 73, 68,232,222,138, 59,255,248,246, 81,179, 86, 71, 71,177,218,146,108, 91,216,
128,196,168,235,149,202, 17,183,106,227, 74,171, 94,123,220,102,169, 79,201,189,
117, 38, 89, 89,253,133, 51,131,209, 94,119, 72,137,132,205,179,178,124, 64,230,
218,143,  9,144,189,147, 69,123,135, 38, 50, 69, 80, 58,194,206,164,227,252, 26,
 87, 72, 52,115,170,117,165, 99,198, 19,112,215, 95,248, 55,206,  1,  7, 92,101,
 91, 83,232,182,220,255, 20,128, 24,119,127,  4, 99,102,172,186,146, 15,218,181,
139, 43,155,154, 96,112,170,245,156,230,231,111,146, 10,219,  1,112, 82, 14, 52,
201, 36,231, 41, 65, 18, 36,172,129,212,157,  8, 82,188,241,250,252,158,117,118,
 44,148,214,125,201,115,172, 82, 34,  9, 68, 77, 66, 73, 98,112, 50,213, 24,114,
198,188,  0,  4, 69,125,164, 33, 41, 83,201,220,  2, 64, 97,141,100, 41,231,238,
103,176,168,246,186,212,192,223,192,154,239, 40, 50,233, 12,177,107, 33,209,194,
104, 82,185,123,255, 19,120,204, 91, 65,229,224,177,219, 82,166,252, 68, 94,231,
241, 60,194,183,147, 26, 49, 12,  6,184, 10, 26,132,226,207,111, 93,231, 82,201,
100, 10,245, 75,115,  3,180,228,168,210,110, 29,113,125, 76,107, 32,133,181, 42,
100,237,192,250,199, 95,217,126,232,112,163,135,253,166, 41,106, 33, 64, 15, 33,
 87, 75, 26,176, 55,243, 11,252, 26,205,179, 74,105, 81,  6, 36,146,243, 47, 90,
 99,245,145, 94, 58,105,166,161,162,  8,133,245, 37,157,234,240,206, 95,240, 36,
189,211,117,247,177,250,171,168, 98,165, 81,164, 71, 13, 37, 26,255,156, 33, 50,
 20,135,152,171, 56,140,  6,220,231, 63,160,253, 77, 51, 56, 31,190, 24,110,168,
160,247, 43, 38, 78,140,198, 28, 27,157,  5, 64, 75,225, 90, 53,246,180,100, 39,
115, 38,240, 22,132,110, 67,196, 35,250, 41,103,244,133,  2, 87, 33,140, 25,246,
223, 25,229,134,251,138,160,122,249,157, 46,182,224,  3,154,239, 98, 74,180,193,
 17, 55,161,182,174,122,114,117,149, 53, 40, 13,132,193,148,129,237,186, 42, 33,
204,249,  6,195,195,116, 34, 56,141, 12,222,127, 33,122,226, 86, 80, 63, 83,231,
178,112,  4, 67, 66, 69,169, 38,241, 28,162,184,208,110, 89,156,147, 19,153,158,
200,146, 41,106,180,252,236,232,187,130, 21,250,160,171, 40, 37, 76, 71, 33,129,
122,230, 75,147, 38,137, 62, 85,237,218,212, 33,130, 56, 95,188, 55,225, 60, 90,
 49,161, 75, 62, 21,219,152,252, 30,192,234,  8,220, 21,190,217,165, 23,252, 96,
255, 11,129, 42,248, 28, 56, 24,250, 32,  5, 30,127,128,133,171, 36,248, 31,125,
156,196,197,185,173,110,149,121,194,217,109, 17,247,238, 12,218, 42,211,108,  4,
 29, 91, 34,143,217,237,100,194, 28,248,170,135,175, 21, 50, 98,170,211,130, 13,
141, 67, 85, 77, 18,117, 97, 32,182, 98,128, 90, 89,169, 45,  4,127,149, 63, 36,
131,135,186, 60,156, 29, 89, 91,250, 72, 85, 65,127,147,151,146,149,188,101,207,
 29,148,252, 63,132, 10,105,137, 99,251,204,218,106,200,112, 25, 13,  5, 21, 17,
 89, 61,177, 48,148,181,183,213, 39, 24,219,172,  2,216, 27,191, 60,185,221,135,
185, 66, 95,130,169,236, 33,185,191,134,153, 18, 57,194, 16,207, 37,193,212,241,
225,101,201, 24, 70,249, 57,218, 52, 69, 45, 51, 25,180,180,121,  9, 94,241,182,
170,166,243,
} ;

// ../Source/assign/template/GB_subassign_13_template.c:
uint8_t GB_JITpackage_106 [1667] = {
 40,181, 47,253, 96,215, 41,205, 51,  0, 10, 71, 36, 13, 40,176, 86,177, 14, 84,
242,232, 11,100,125, 56, 48, 18,180,  1,165,244,  8,129, 16,229, 73,126, 40,199,
 14,190, 81,192,165, 78,243,248, 65,255, 65,231,167,  4, 23,199,  0,195,  0,201,
  0, 33,175,162,188,210,119, 71, 37,254,156,223,232, 29, 58,141,221,243, 23,122,
101,163,151,101,232,185,210, 91, 22, 81,211,218, 97, 28, 78, 70,199,251,186, 46,
118, 23,167,237,203,101,120,198,209,111,189,149, 59,220,223,205,214,171, 29, 55,
130, 99,166,141,251,218, 91,  8,152,139, 42, 41,247,102, 57,184,100, 10,154,212,
 69,139,221,186, 45, 71, 50,211, 22,105,  5,141,105,119,146, 83,192, 49,225,185,
136,186,228, 54,238,207,113, 38,133,200,207,231,196, 94, 41,100, 14, 50,  5, 12,
152,131,204,169,110,122,133,101, 73,156,248,  5,123,137,148,171, 39, 65,175, 32,
198,145, 32,217,120, 43,172,198, 55, 90,216, 89,126,208,  2, 31, 66, 37,254,126,
253,198, 25, 59,252,135, 67,108,  0, 14,212,166,210,166,236, 86,231, 56,173,215,
153, 67,192,112, 52, 68, 98, 28, 67, 31,230, 36, 42,110, 96, 96, 41, 48, 48,  8,
183,183, 94,125,244, 66,226,181,  1, 61,237,151, 69,180,237, 51,253,106,119, 51,
109,145,253, 94,117,142,125,187, 91,152, 55,142, 36,171,201, 52, 14,228, 54, 28,
 26,215,169,208, 32,196, 36, 50, 32, 85, 33, 28,188,194, 28, 76,183,102,223,232,
185, 72, 79,226,151,110,151, 52,208,248,138, 65,  1,243, 10,103, 89,167, 61,233,
 13,224,163,250, 82,150,248, 77,  2,253, 23, 81, 95,249,145,244,197,242,148,202,
 70,101, 64, 69, 83,153, 98, 72,123, 24,175,248,213,230, 68,251,156,241, 89, 98,
 89,114,205,232,201,108,235,107,126,227, 58,175,127, 48, 14,150, 65, 11,136, 89,
112, 31,141,167,195,130,187,190,117,198,159,247,236,191,158,113, 32, 77,197,117,
 16,212, 56, 23, 16,  3,113, 29, 32,207,166,193,249,179, 84, 62,119,200,255,223,
 98, 73,177, 88,112, 36,229,223,198, 84,190,111, 60,110, 25,219,118,157,  3,219,
 64, 29,237,214, 41,218,179,  4, 74, 56, 29,114, 50,226,148,195,161,157,224, 37,
 99, 57, 79,234, 98,219, 26,143,187,147, 21,119,184,254,112, 76, 86,153, 72, 69,
 97, 10,182,237, 28,180,211, 41, 56,152,105, 52, 56, 79,198,  5,  6,  6,103,163,
 68, 42, 17,109, 11,210, 58,107,183,121, 53,209,209, 46,184, 77, 37,242,106, 51,
109,180,135,103, 89,181,184,239,173, 93,149,137,196,233,112, 61,227, 43, 71, 35,
127,184,200, 51,151,176,144,169,196, 18,119, 93,210,249,187, 78,189,202, 55,102,
204, 97,114, 58, 70,227,225, 62, 24, 32,143,246,201,160,102,130,187, 53, 91,121,
 59,220,162, 55, 41, 19, 16, 96,122,135, 95, 63,248,195, 69,114,  4,199, 60, 81,
139, 96,162, 85,230,238,222,242,113, 10, 83,117,210,139,180, 36,154,122,126,162,
 38,117,248, 20,157,176, 40,246, 37,101,206,251,232,111, 29,  5, 22,203, 74,158,
 31,238,123,122,191,220,247, 68,222,220, 40,114, 70, 42, 71,153,142,166, 85,218,
 51, 21,115,150,128,192,245, 45,  3,110, 25, 25, 87,209,209, 38, 58, 26, 43,179,
226,193, 62, 27, 43,153,250,229,130, 97,  9,161, 93,225, 48, 28, 86,233,117,200,
101,184, 75,228,124,231,158, 45,162, 31, 71,165,175,176,151,108,237,110, 81,199,
 30, 62,221,138,183, 56, 60,126,235, 65, 48,199,158,121, 72, 15,147,211,225, 73,
185,134, 48,  8,128,229, 61,218, 94,207,235,215, 29, 64, 31, 13,132, 88,105,102,
217,201,105, 61,249, 42, 87,218,120,246,138, 53,109,167,242,165,124,210,180,230,
215,235,  4,  4,155,165, 26, 69, 98,239,100,195,178, 77, 64,224, 84, 40,  4,178,
 89,143,111,167,158,178, 77, 31,137, 72,239,179,214, 16,133, 75,209,100,198,233,
 32,155,132,210,227,164, 51,246,240,104,147,219,244,109, 11,129, 74,168, 65, 45,
 99,104, 70,102, 68, 36, 73, 82, 40, 12,  7, 81,  8, 98, 24,  5, 33,165,176, 30,
194,168, 64,  8, 99, 24, 66,164,  0, 17,130,  8, 50,194,  8, 81, 68, 36, 24,  9,
 69,  2,137,106, 23,214,116,164,  0,  2, 10,169,203,  7, 81,108, 76, 59, 93,139,
158, 55, 80, 56, 96,206,139, 45, 69,119, 31, 72, 86,  0, 34,110,163,215, 68, 44,
 86, 50,184,165, 46, 99, 47,220,158, 16, 72,123,222,162,165,  9,151, 40,161,232,
 17,184,117,185,181, 74,190,120,163,241,121, 68, 22, 71,112,244,151, 16,229,181,
151,203, 63,220,249, 24, 53,127, 18,  1,201,228,135,153,104,111,  7,199, 40, 40,
111,186, 39,251,183, 72,139, 32,194, 21,168,  2, 16,182,  6, 67, 43,143,  5, 38,
227,236, 47,  5,224,170, 16,141,147,196, 55,254,102, 27,134,200,245, 61, 70,174,
242, 28, 50,233,138,  8,125,  6, 79, 99,147,129,247,208,207,236, 24, 30,224, 17,
 72, 12,145,109,230,206, 21, 56,170,100,109, 62, 72,222,148,164,173,171,203, 85,
134,240, 63,247, 83,213, 51,100, 59,179, 33,124, 44, 70, 74,126,211, 88,143,228,
109, 18,  2,202,121,175,165, 49,217, 21,185, 91,223, 94,120,124, 86,118,115,251,
190,112, 14, 33,244,240, 84,141, 94,210,  9,209, 16,218, 10,181,164,192, 21, 17,
 35,116,156,212, 32,  2,115,156, 97, 50, 53,194,243,229, 36, 99, 13,233,209, 53,
146,215,186,243, 26, 96, 16,212, 59, 93, 32, 35,208,118,168, 58,160, 80,134,178,
 48,179,143, 96,  6, 79,145, 65, 83,162, 62,166, 86,168,114, 69, 85,129, 10,  7,
165,187, 52,106,233,208,156, 16,215,173,193, 11, 17, 23,126,203,214, 65, 35,212,
175,127, 95,107,216,225,217,155, 37,129, 76, 27,226,123,164, 12,110, 32,184,229,
255,201,113,116,136,225, 21,188,  8, 66,123,132,171,  7,249,119, 73,252,240, 57,
 10,193,  3,108,244,138, 70,  3, 35,133, 20, 81, 23,  7,183,206, 80,138,202,  1,
 11, 68,168,108,217, 18,169,138,221, 62,  4,137,212,150,178,206, 36,233, 57, 29,
199, 98,202,141,149,146,180,218,255,105, 91,216, 52,165,203,  3,173, 13, 45,139,
 54,223,180, 13,199,139,241, 89,134, 56,183, 72,229,236, 57,160,253, 40,140, 58,
 90,161,214,248, 61,204,131,241,151, 92, 63,  7,239, 80, 46,255, 94,132,176,213,
 21, 68,196,160,105,  3,141, 27, 34,232, 37,193,193,162, 19,169,191,186,177, 39,
 82, 24,157, 28, 42,189,154, 14,164, 51,170,180,  5,223, 19, 90,112,121,140,224,
 67,241,  4, 31,  6,108, 24,136,108, 99,124, 94,192, 53,225, 73,198,124,240, 51,
200,170,128, 47, 74,208,234,216, 33, 95, 91,  8,128,147,188,124,157,164,155, 80,
 27,160,112,214,162, 87,169, 39, 94,249, 56, 71,191, 99,211, 85,248,155, 97,188,
 89,203,218, 28, 40,243,100,135, 21,175,170, 29, 53, 74,101, 55, 36, 85,229,198,
157, 81,150,252,110, 37,113, 69,161,237,139, 26,202, 98, 32,114, 58,125,101,110,
  3,143,201,203,233,216,160, 51, 17,214, 39, 16, 67, 16,140, 32,137, 40, 71,252,
115,  1,217,194,159,227,182, 87, 12,182,231,166,140,133,253, 99,  9, 92, 35,236,
247, 10,147,167,128,222, 54, 77,123,112,159,182, 56,191,173,243,162,164, 18,252,
 87, 57,165, 77, 97,187,173,115, 61,129, 99, 29,213,  7, 84,204, 21,188,104,246,
164,  7,168,242,190,236, 61, 36,166, 53, 78,202, 87, 81,215, 55,109, 80,191,157,
146, 55, 66, 38,155, 89, 89, 11,163,  6, 64,226, 87,241, 21,238, 59,205,222, 84,
218, 72,159, 47, 14, 23,  6,250, 41,243,218, 42, 76,208, 88, 88, 18,252,196,252,
 24,138,114,  7,162,114, 62,148, 65,150, 74,230,166,169,254,204, 52,131,156, 11,
236,143,183,170,246, 32, 12,
} ;

// ../Source/assign/template/GB_subassign_15_template.c:
uint8_t GB_JITpackage_107 [1667] = {
 40,181, 47,253, 96,226, 41,205, 51,  0, 58, 72, 84, 13, 40,176, 22, 85, 29, 20,
248,232, 11,100, 89,208, 12, 21,150, 35,205,229,164, 68,178,121,120,248, 75, 64,
177, 11,152, 51,  1, 95,217,254,160,255, 96,237, 79,135,  3,201,  0,200,  0,203,
  0, 55, 30,183,  4,121, 85,229,149,190, 57, 42,241,231,252, 66,111,208,105,228,
158, 63,208, 41, 27,189, 44, 65,207,149,190,186,116, 77, 43,119, 85,222,199,113,
177,185, 56,109,223, 13,195, 51,134,126,235,171,204,225,254,110,174,172, 87,185,
173,  4,199, 76, 27,247,181,175, 18, 52,239,170, 40,183,118, 49,200,108,  8, 90,
196, 69,123,189,186, 45, 67, 50,211,238, 50,130,198,180, 57,137, 65,224, 33,209,
201,116,125,114, 27,183,231, 56,139, 70,164,231,115, 94,167, 18, 54,  6, 27,130,
  5,141,193,230, 19, 39,157,194,242, 36, 74, 60,115,125, 36,202,213,147,159, 83,
240,194,136, 16,217,120, 41,170,198, 55, 90,216, 89,126,240,  2, 63, 66, 37,254,
110,253,198, 25, 57,124,  7,204, 31, 52,128,134,201,130,202, 36,236, 85,231, 56,
173,215,121, 75,208,108,116, 68, 98, 28, 65, 31,222, 34, 40, 94, 80,112, 33, 40,
 40,  8, 31,253,173,161,219, 91,175, 62,122, 35,241,218,128,158,246,203, 29,109,
251, 76,191,202,221, 76,187,179,223,169,206,177, 47,247, 74,243,198, 81,100, 57,
 88,134,  1, 55, 11,143,108,203,160,200, 32,188, 34, 54,224, 68, 29, 24,156,210,
 24, 72,175,102,223,216,201, 72, 79,226,143,110,159, 48,208,120,106,129, 58,208,
 28,103, 89,167, 77,105, 13,224,161,250,209,141, 22,191, 69,159, 63,211,245,149,
159, 73, 95, 44, 63,177, 88,176, 12,176,100, 44, 82, 28,105, 79,227, 21,159,178,
 72,201, 62,103,124,150,214,140,158,204,182,190,230, 55,174,211,186,231,194,184,
 48,184,105, 27, 24,118,193, 10,120, 85,108, 30, 78,231,163, 98,179,174,117,198,
159,119,236,183,142,109, 31, 14,133,245, 15,204, 48, 46,224,245,217, 62, 62, 29,
141,131,243,103,169,124,238,145,255,255,229,178,114,185,224, 40,202,191,141,169,
124,  7,253,140,123,206,232,225,144, 38, 53,233,154,166,105,214, 61, 46,237,147,
145,189,250, 68,123,158, 64,  9,165,195, 77, 66,124,106, 56,180, 18,204,100, 44,
231, 69, 92,108, 91,227,113,115,146,226, 13,214, 29,126, 73,140,132,154, 52,  4,
153,132,105,218, 55,104,165, 79,108, 16,227,112,108,157,141, 11, 13, 13, 12,109,
 34,161, 42, 72,235,172,156,197, 41,137,140,236, 98,179,160, 72, 36,139,204,225,
 24, 86, 45,238,123, 43, 71, 97, 36,113, 54, 88,207,248,202, 80,201, 29, 78,242,
188, 33, 40,100, 42,177,196, 92,159,116,254,172, 79,167,242,141, 25,111,151,148,
174,225,116, 54,143,198,167,147,121, 48,200,145,216,110,205, 86, 94, 14,119,247,
 22,101, 12,  6,211, 55,220,186,193, 29,222,201, 44,209, 10, 35,209, 42, 51,119,
127,  9,249,164,161, 56,233, 69, 58,234,164,158, 95,215, 34, 14,127,162, 18,238,
 98, 95, 81,222,188,151, 75, 75,158, 31,238,123,122,191,220, 55, 69,222,220, 42,
114, 70, 42, 67,155,140, 44,163, 46,121, 42,251,166,235,124, 43,222, 42,  1,  1,
235,218,  6,212, 54,176,141, 34, 35,147,200,224, 84,155,150,206,229,233,104,201,
211, 51,153, 11, 75,  8,109,203,166,217, 46, 81,150, 40,214,225,134,225, 62,145,
243,157,123,118, 71, 63,143,209,180,118,250,133,193, 28, 46,189,138,175, 60, 64,
126,235, 69, 52,191,142,129, 72,239,146,210,225, 69,185,130, 46,216, 57,206, 15,
  0,203,151,224,232,209,246,122, 90,183,222,240,241,112, 32,188, 98,232,163,153,
 37, 39,167,245,228,169, 92,105,227,217, 45,149,164,157,202,143,114, 74,211,154,
 95,173, 99, 48,154,157, 90, 69, 98, 47,229,  3, 47, 76, 19, 16,248,  4,  2,137,
104, 22,228,218,167,175,104,210, 67, 36,210,251,172, 21, 52,225, 81, 68,153, 81,
186,200, 37, 15, 37, 72, 74,129, 71,168, 97, 45, 83,104, 70,100, 68, 36, 73, 82,
 40, 12,  7, 97,  8, 49, 14,130,144, 82, 72, 15, 34,105,166,195, 41, 14, 33, 76,
192,  8, 33,  6, 17, 34, 36,132, 32,129, 76, 32, 18, 51,129, 68,182, 11,107,244,
164,  0,194,  9,169,229,131, 30,184, 50,161, 97,193, 61,111, 80,245,128,225, 27,
203, 60,186,103, 88, 18,193,226,184,185,162, 72, 29,110,193,109,236, 50,237,  9,
129,180,202, 27,180, 58,147, 45,145,214,182,138,168, 84,194,202,251,249,239,200,
203, 28,246,111, 47,161,152,217,190,144, 63,249,230, 79,181,252,222, 13, 26,201,
225, 97, 34,183,221,118, 81,144,164,211, 17,193, 23, 84, 45,109, 63, 91,187,  6,
160,157, 23,205,172,147, 87,254,230,128, 35, 69,255,166,154,195, 39,172,186,121,
 13,245,137, 52,225,166,252,222,183,136,248,145, 59, 28, 41, 17,223, 38, 32,227,
213,135, 20,135,195,  8,110,239,219,184,139,185, 38,162,245, 45,118,106, 28,172,
205, 67,242,146, 50,218,194, 93, 93,193, 16,234, 15,108,171,122, 96,182, 55,163,
151,127,166,100,147,222, 52,170,199,104,252,  8,208,146,192,125,122, 23,191, 93,
178,113, 28,197,231,195,108,129,222,185, 96,141, 19, 10,189, 76,170, 70, 47, 15,
 99,217, 42, 97, 65,232, 41,188, 34,101, 33,160, 58, 96,162, 35, 24, 55, 70,152,
125,250,  4,183, 67,118,116,141,147,215,148,247,125,100,195, 47,224, 87,208,126,
223,186,139,134, 10,128,131,237,248,200,205,241,204, 89,190, 82, 67,152,202, 30,
103, 18,149,152, 32,103,131, 72,172, 58,111,110,131,171, 88,  3,  8,177,145, 70,
170,241,185,161,246, 91,214, 31,185,217, 81,224,102, 18,254,100, 38,116,227, 35,
190,219,224,190, 85, 67,201, 17, 70,178,152,161, 86,  5,183, 64,202,119, 21,126,
203,141,194,133,210,181, 90,117, 32, 67,209,118,233,148, 36,137,235,103,167,165,
220,  4,130, 80, 38, 70, 91, 24, 17,155,110, 14,217,162,116,109, 73, 71,  9, 58,
 37,195, 69, 75,177,109,165, 13,167,251,142, 30,141, 73,162,168, 49, 94,155,144,
200,243,234, 45,  3, 97,131,139,  9,191,237, 15, 56,233,104, 32, 12,104,139, 88,
186, 33, 91, 34,  6,135,254,142,132, 88,152,200,221,214,130, 73,205,  4,165, 15,
160,224, 16, 64, 59,183,131, 69,  3,212,157,164,236,243,141, 57, 33,133,217,164,
 68, 68, 60,172,183,166, 35,246, 12,171,183, 17,120,194, 57, 92,152,145,100, 83,
188,195,135,217, 13, 35,102, 28, 70,246, 11, 30, 39, 56,159, 61,135, 51,131, 85,
  5,129, 40, 97,185, 67,127,128,137, 33,176, 39,185,120,238,148,219,  4,107,128,
114,183,117, 31, 83,195, 95,105,113, 14,238, 99,146,170,253,253, 49,254,203,108,
201,  7,144,121, 69,180,204, 78, 45,180,114,116,193,  6,191, 93,216,167,178,198,
248,187, 28,249,181, 36, 33, 78, 33,236,139,118,203,154,192, 38, 59, 45, 51, 97,
 48,229, 38,130,220,  3,137, 78, 69, 12,190,132,179, 32,  2,129, 20, 85, 28,127,
152,207,133, 29,214, 61, 14,169, 98,117, 63, 47,105, 44,102, 65, 28,110, 72,208,
  9, 49,152, 92, 77,132,184,162,242, 47,246,177,156,183, 32,200,136,209, 93,113,
213,  1,203,202,199, 23, 52,250,156, 53,176,170,137,138, 86, 15,192,131,139, 75,
113,236, 91,  9, 80,160,250,206,123, 12, 50, 45,233,116, 81,229, 98,189,121, 66,
 13,114, 90,226, 16,178,  1,213,202,186,137,216,139, 68,171,101,151,196, 77,245,
186, 19,221, 67, 35,222,195, 39, 79,103,246, 89,152, 61, 20,  6,111,225, 64,113,
114,107,115,135, 75, 33, 36,238, 50,152, 74,230,166,233,254,204, 84, 23,153,  4,
180, 67,194,170,118, 86, 12,
} ;

// ../Source/assign/template/GB_subassign_17_template.c:
uint8_t GB_JITpackage_108 [1685] = {
 40,181, 47,253, 96,  7, 43, 93, 52,  0,186, 72,116, 13, 40,176, 22, 85, 29, 20,
184,213, 54, 89, 22, 52, 67,101,  9, 19,112,174,  6,161,110,228,146,172,211,200,
130, 15, 53,161, 68, 78, 29, 63,232, 63,232,238,236,128,  3,205,  0,199,  0,205,
  0, 48,235, 92,192, 43,180,117,132, 62,218,  6,231,207, 82,249,220, 34,255,255,
203,101,229, 98,163,151,101,200,115,165,175, 46, 93,211,202, 93,157, 78,134,199,
251, 56, 46, 54, 23, 55,236,175,172, 87,185,198, 51,138,126,235,251, 85,230,190,
155,241, 70,130, 99,166,141,251,218, 87, 12,154,119,117,148, 91,187,100, 48,  7,
  5, 61,226,162,189, 94,221,150, 34,153,105,119, 89, 65, 99,218,156,236, 20,112,
 76,124, 48, 93,155,220,198, 13, 58,206, 35, 17,  9,250,156,215, 41,133,131,204,
 65,  1,131, 38,115,240,137,147, 78, 97,105, 18, 39,142,185,158, 50,202,213,147,
161, 83,240,234, 72,140,108,188, 21, 85,227, 27, 45,236, 44, 63,120,129, 23,161,
 18,127,183,126,227,140, 28,254,195, 33,166,237, 75,105,  0, 14, 19,135,202, 36,
236, 85,231, 56,173,215,121, 99,208,108, 84, 68, 98, 28, 67, 62,188, 73, 84,220,
192,224, 82, 96, 96, 16,156,244, 34, 77,233,164,158, 95,215, 35, 14,127,162, 18,
238, 98,223, 81,222,188,143,254, 86,209,237,173, 87, 31, 61,145,120,109, 64, 79,
251,229,142,182,125,166, 95,229,110,166,221,217,239, 20,110, 25,226, 85,149,119,
142,125,185, 87,154, 55,142, 35,187,193,178, 14,220, 56, 28,217,230,169,200, 32,
188, 36, 50,224, 68, 33,100, 78,105, 50,210,171,217, 55,126, 48, 55, 78,233, 73,
252,148,219, 38,239, 27,223,160,121, 71,227, 41, 74, 65,115, 10, 65,115,156,101,
157, 22,165,105,228,174,  1, 92, 84,159,146, 37,126,143, 66, 63,166,235, 43,191,
146,190, 88,126, 98,225,176, 12,176,100, 44, 82, 20,105, 15,227, 21,159,226,160,
100,159, 51, 62, 75,107, 70, 79,102, 91, 95,243, 27,215,105, 29,116,117, 46, 12,
 90,192,203, 98,  3,109, 62, 29, 22,155,117,173, 51,254,188, 99,191,117,108, 11,
109, 42,172,135,  2, 53,100,194, 41,241,100, 70,233, 32,154,132,210,  3,165, 51,
246,176, 72,147,154,116, 77,211, 52,235, 28,151, 22,242,100,175, 62,209,158, 38,
 80, 66,233,112,147, 17,159, 28, 14,173,  4, 49, 25,203,249, 17, 23,219,214,120,
220,156,172,184,131,245,135, 95, 18, 27,161, 38, 77,129,166,125,131, 86, 58,197,
  6,177,141,198,246,201,184,192,192,232,104,211,  8,213,209,174, 32,173,179,114,
156, 83, 19,158,236, 98,227, 80, 35,167, 56, 18, 39,123, 56,134, 85,139,251,222,
202, 81,216, 72,156, 14,214, 51,190, 82, 68,242,135,143, 60,111,  9, 11,153, 74,
 44, 71,249, 84, 30,223,154,185, 54,233,252, 89,159, 58,218,167,242,141, 25,111,
151,148,174,217,124, 54, 16, 70,232,147,129, 48,184,153,216,110,205, 86, 94, 14,
119,247, 30,101,  2,  2, 76,239,112,235,153, 63,188,147, 36, 56,102,137, 86,  4,
 18,173, 50,115,247,151,143, 79, 26, 42,151, 75, 75,158, 31,238,123,122,191,220,
 23, 69,222,220, 42,114, 70, 42, 69,  7,158, 44,163,178, 31,116,157,111,197, 91,
 37, 32, 96, 93,203,128, 90,  6,182, 85,120,178,  9,207,166, 58,104,249, 92,160,
141,150, 60, 61,223,198, 84, 98, 48, 23,150, 16,218, 14, 80,200,179,217, 54,161,
 77,103, 51, 17, 63,167,204,152, 35,147,217, 52,219, 85, 41,110, 19, 57,223,185,
103,119,244,227,168,244,212,245, 20, 91,185, 87,211,175,135, 75,175,226, 43, 14,
143,223,122, 16,205,175, 99, 30,210,131, 27,118, 73,233,240,163, 92, 67, 46,  8,
128,229,155,163, 18,147,224,232,209,246,122, 90,183,238, 16,  2,109, 32,188, 82,
102,150,156,156,214,147,167,114,165,141,103,183, 84,146,118, 42,159,146, 81,154,
214,252,106,157,128, 64,179, 83,171, 72,236,161,104, 23,166,  9,  8,124, 10,  9,
  1,209,172,199,181, 79, 95,209,164,139, 70,164,247, 89,  3,129, 73,168,113, 41,
 83,102,102, 70, 68, 36, 73, 82, 72,107, 97,  8, 49,204, 64,136, 37,164,  7,146,
168, 48,201, 99, 20, 67, 36,  1, 34,198, 16,133,  4, 69, 96,136, 64, 68,100,162,
  9, 69,164,118, 97, 13,116,132,  1,130, 97,169,203, 15,186,134, 49, 81,109,  1,
137,222, 64,187, 49, 74, 27,203,117,186,195,122,146,196,154,184,185,174, 20,109,
 59, 97,134,219,120, 25, 47,  7,123, 66, 80,173,242, 22, 45,100,162, 59, 84,109,
125, 69,157,157, 60,222,  4, 94,115, 46,229,  0, 94,247,142,  2,210,170,237,161,
248,192, 18,159, 33,138,239, 34,193,200, 69, 48,241,182, 91,145,202, 15,149, 70,
164,242,253,177,200, 33,248, 74, 22,100, 87,239,112, 47,108, 89, 20,164,134,  3,
 92, 63,  2, 92, 57,253,114, 27,211,  0, 40,242, 92,216, 42,187,234,182,240,115,
246, 69,214, 62,138,146,144,199,214, 96,148,186, 32,149,184,133,244, 16,235,133,
 20,112, 73,108,224,168, 11, 25,180,174,  3,133, 92, 99,157, 85,123, 65,233, 62,
 78,132, 41, 94,155,196,195,128,200,220, 26,228,134,158,212,245,  8,121,143, 26,
215,160, 96,192, 37, 26,234,167,118, 70,155, 84,120,140,219,233,247, 22,114,  3,
128,177,172,249,154, 70, 70,244, 22,148,122,108,182,141,  6,144,195,219, 74, 39,
122, 87, 10, 33,190, 25,186,190,255,178,198,237,131,171,201,130,208, 43,132, 26,
189,140,238, 78, 32,177,130,160, 68, 76, 67, 16, 98, 96, 76,101,152, 89,182, 21,
190, 92,201, 74,133, 88,187,218,239,213,130,188,208,218,  1,217, 19,132, 76,  4,
109,186, 80,169, 18, 74,117, 47, 12,131,143,212, 48,207,134,110,148, 72,199,148,
 50, 84,227, 91,213,129,148,  6,121,190,212,120,105, 11,187,  2,247, 93,227,135,
 38, 73,111,195,246,104, 35,187,191, 19,253, 79,108,199,192,155,  7,  5, 10, 55,
116,116, 36,  6,110, 64,112,139, 44,201,113, 55,203,225, 21,253,  9,174,120,172,
 67, 15,126,238,222,250,  5, 60, 10,237,163,  7,125,  5, 23, 80,187, 71, 87,212,
 73,  7,247, 79, 40,187,202,249, 47,162,127,104,108, 97,174, 26,218, 30,242, 69,
234,109, 89, 71, 48,105, 61,142,203,147,226,105,165, 39,175,158, 57, 77, 36,120,
152, 34,206,252, 66, 67, 62, 68,211,108,218,214,200, 11, 52,248,235,  1,167, 80,
177,121,180, 11,177,196,186, 91,122, 67, 95, 82,  4,167,149,227, 51, 22, 77, 36,
223, 86,242,146,206,  4, 45, 15,140,110, 72,  9,101,132,194, 50, 38, 82, 74,117,
  3,107,164, 32,117,162, 72,117, 29,116,112,205,184,108,139, 20, 79,212,224, 90,
 30,  1, 19,197, 36,124, 96,222, 64, 16,138,197,196,189,112,111,194,  3,232,118,
 49, 70,128, 89,133, 14,147, 24,181,142, 18, 37,231,205, 58, 20,155,112,229,105,
185,127,169,169,175,232, 56, 24,233, 57,154,  0,252,253,100,252,141,213, 18,252,
128,243, 33,102,153,196,170,119, 53,192, 34, 49, 48,171,254,198, 90, 92,158,241,
103,210,133,  8,133,136, 47, 42,147, 21,129,231,116, 34,102, 14,142,143, 51,140,
127, 58,114,249, 14,190,  4,245, 13,233,164, 56, 31,152,191,133,125, 17,189, 73,
159,178,168,108, 67, 29, 36,216, 75,214, 41, 65,194,111,194, 18,245,125,158,  0,
  6,211, 65,254, 93,177, 82, 20, 57,113, 84,138,135,244,180,240,186,199, 31,160,
 41,215, 36,197,145, 94, 30,128,114,246,231,228,  3,200,180,191,197,238, 42,124,
241,166,  3,245,184,169, 37,134,232,110, 47,120,225, 70,  4, 79,234, 97, 39,148,
102, 28,220,224,244,193, 39,119,233,185,150, 19,238, 98,161, 50,232,143,132,115,
118,160, 20,209,106,186,  0, 74,100,110,154, 99,149,153,172,149, 36, 56,112, 74,
167, 82, 40,208,  4,
} ;

// ../Source/assign/template/GB_subassign_19_template.c:
uint8_t GB_JITpackage_109 [1686] = {
 40,181, 47,253, 96, 19, 43,101, 52,  0,154, 71, 84, 13, 40,176, 86,177, 14, 84,
242,232, 11,100,125, 56, 48, 18, 46, 76,192, 57, 17,  0,150, 38, 67,176, 88, 14,
206, 66,  9,255, 72,228,212,241,131,254,131,206, 79,  9, 46,202,  0,198,  0,203,
  0,207,254,235, 25, 23,226,116,174,135,160, 86, 65,  1,177, 16,199, 17,250,108,
 28,156, 63, 75,229,115,135,252,255, 45,150, 20,139,141, 94,150, 32,207,149,222,
178,136,154,214, 14,179,188,175,235, 98,119,145,203,240,140,163,223,122, 43,119,
184,191,155,173, 87, 59,110,  4,199, 76, 27,247,181,183, 46,170,164,220,155, 37,
131,217, 16, 52,169,139, 22,187,117, 91,142,100,166, 45,210,  8, 26,211,238,100,
  5,193, 70,196,  7, 35,234,146,219,184, 65,199,153, 20, 34, 65,159, 19,123,133,
176,201,108,  8, 20, 52,153,205,169,110,122,133,101, 73,140, 56,  6,123,137,148,
171, 39, 67,175, 32, 86,  1, 65,178,241,118,172,198, 55, 90,216, 89,126,208,  2,
 31, 66, 37,254,126,253,198, 25, 59,252,134,203, 29,166,237, 91,109,  0, 12,148,
167,210,166,236,214,130,134,163, 33, 18,227,  8,242, 97, 14,162,243,130,  2, 11,
 65, 65, 65,247, 22,143, 83,154,170,147, 94,164, 37,209,212,243, 19, 53,169,195,
167,232,132, 69,177, 47, 41,115,222, 71,127,235,232,246,214,171,143, 94, 72,188,
 54,160,167,253,178,136,182,125,166, 95,237,110,166, 45,178,223, 43,220, 18,196,
171, 40,239, 28,251,118,183, 52,111, 28, 73,150,147,105, 21,144,243,108,104,156,
 69, 71,131, 16,131,192,128, 84,101,144,121,165,201, 76,183,102,223,248,193, 72,
 79,226,151,110,151,188,111, 60,141,175, 20, 16, 52,175, 12, 52,199, 89,214,105,
 79,154,198,238, 27,192, 71,245,165, 27, 45,126,147, 66, 63, 70,212, 87,126, 36,
125,177, 60,165,226, 81, 25, 80,209, 84,166, 24,210,222,197, 43,126,229, 57,209,
 62,103,124,150,215,140,158,204,182,190,230, 55,174,179,175,131,176, 10, 44,131,
220,134,145,101, 24,156,128,216,  4,  7,226,124, 56, 38,184,235, 91,103,252,121,
  1,181,130,136, 84,114,218, 40, 92,138, 38, 51, 78,255,216, 36,148, 29, 39,157,
113,207, 25, 61, 60,218,228, 54,125,219,182,237,250,  6,182,133, 44,180, 91,167,
104,207, 18, 40,225,116,200,201,135, 83, 12,135,118,130,152,140,229, 60,169,139,
109,107, 60,238, 78,118,206,112,189,225,152,204, 68, 42, 74, 67,160, 77,217,182,
157,131,118,186,  4,  7, 51, 78,  6,247,193,160,184,184,168,216, 40,145,202,130,
180,206,218,121, 94, 69, 88,104, 20,156,167, 18,121,229,153, 60, 90,195,179,172,
 90,220,247,214,174,202, 68,226,100,184,158,241,149,163,145, 55, 92,228,153, 59,
 72,200, 84, 98, 73,202,167,242,184,235,146,206,223,117,234, 85,190, 49, 99, 14,
147,211, 53,156, 15,  7,186,  8,125, 52, 80,  6, 57, 17,220,173,217,202,219,225,
 22,189, 73,249,114,193,244, 12,191,158,121,195, 69,114,  4,199, 60, 81,235, 50,
209, 42,115, 23, 22,203, 74,158, 31,166,247,203,125, 79,228,205,141, 34,103,164,
114,180,177,208,180, 74,251, 70,212,249, 86,204, 89,  2,  2,215, 55, 12,184, 97,
100, 92,199, 66,139,176,224, 88,155,149, 15,  6,210, 88,201,212,243,109, 76, 37,
  6,131, 97,  9,161,229,  0,133, 44, 56, 28, 39,196,169,224, 68,196,207, 41, 51,
222,200,100, 56, 13,135,145,178, 52,193, 93, 34,231, 59,247,108, 17,253, 54, 74,
211, 90,234,216, 37,107,248,116, 43,222,218,232,248,173,255,208, 28,123,214, 33,
 61,200,101, 24, 60, 41, 87, 16, 12,118,142,243,  3,192,242,221, 81,137, 71,112,
244,188,158,215,175, 51,132, 64, 28,  8,177,210,204,178,147,211,122,242, 85,174,
180,241,236, 21,107,218, 78,229, 75,249,164,105,205,175,215, 47,151,205, 82,141,
 34,177,119,178, 97,217, 38, 32,112, 10,  4,  4,162,243,177,217,142,111,167,158,
178, 77, 31,137, 72,239, 51,129, 77,168, 81,173, 98,104, 70, 70, 68, 68,146,164,
 32, 25, 14, 97,  8, 49, 12, 65,168,169,155,  7,226,128, 68,199, 83, 16, 67, 44,
  1, 34,134, 24,131,  4, 69, 64,140, 64, 36, 16,  9, 36,144,104, 68,106, 23,214,
116,132,129,240, 88,234,135,240,  9,  9,211, 77, 25,121,177,224,222, 56, 40, 39,
 52,226, 22,107,113,222,157, 92,242,247,122,187,249, 90,249,252,237, 63, 80, 55,
175,218, 56, 95,219, 39,194,107,247,155,181,100, 19,223,121,233, 22, 87,212,219,
209,235, 77,205,247, 28, 80, 56,172,216,193, 67, 55,179,226,242, 40, 72,129,137,
175, 35,  5,229, 88,105,114, 92,154, 32,183, 47,143, 42, 26, 49,149,205,247, 32,
129,185, 66, 44,175, 14, 78,123,122, 93,151,149,119,216, 17,121,143,  0,154,255,
  0,174,172,191,241,198,122,104,226,121, 95, 40, 42, 91,197,155,112,235,  6,209,
194, 45,245,145,184,105,109,108,169,188, 18,145,153, 92, 92,176,108,207,176,120,
  3, 48,  7, 13,198, 64,118,150,163,219,144,128, 43, 58,239,149,166,235,217, 49,
221,240,116,108, 36, 82,187, 38, 92,119, 32,218,212,152,101, 55, 17, 36,  9,148,
 56,131,225,150,171,105,136, 79, 34, 81,237,165,209,187,222, 42,186,223,106,115,
 72,112, 44, 27,126, 94,201,102,111,123,125,184,141,195, 25, 15, 42,224,124,224,
219, 58,105,191, 81, 58, 61, 78,145,251,203,104,195,195, 78, 79, 47,116, 70,232,
 21, 94,205, 94,230,114, 51,  0,153, 75,  8, 34,241,168, 34,152,193,129,238, 97,
210, 25, 35,246, 69, 36,255, 20,114,218, 21, 79,175, 49,224,213,130, 13, 84,227,
 22,160, 41,104,251,181,218, 81, 40,176,194, 48,163,143,228, 15, 30, 31, 82,165,
196,120, 76, 86,165, 42, 92,171,216,185, 52,  8,192,  5,  5,113, 45,220,182,102,
123,200, 32, 76,174, 93, 65,131,168, 31,240,190,126,216,241,166,  4,179, 40,146,
208,117,  3,235,214,212,146,227,156, 19, 30, 43, 22, 22,244,234,113,225,238,225,
167,124, 81,184,208,125,126, 88,112,113,220, 53,  6, 68, 93, 28,172,194,139, 10,
116, 14, 44, 18, 65,  5, 96, 11,228,226,  9,171, 67, 48, 83,125,128,235,224,148,
174,116,228,148,164,120,182,210, 19, 89,231, 81,  3,142,161,167, 92,126,216,235,
 16,249,104,138, 85, 91, 40,235, 69, 10,252,216,  3,136, 58,154, 67, 88,186,186,
239,193,144, 44,169, 48, 71,217,161, 64,214, 74,  4,104, 43, 57,166,101,130,246,
 14,108, 55, 68, 66, 38,199,176, 28,  0,197, 72, 82,148,116, 99, 59,164,120, 37,
125, 62,118, 81, 58,184,103,212,199, 22, 79, 79,104,195,  5, 28,161,151,226,171,
 62, 60,219,240,129,  8, 96, 56, 94, 48, 57,129,204,117,122, 44, 51,176,173, 80,
 21, 37,158,208, 33, 45,193, 38,146, 31,  5,142,225, 38,208,  6,120,198, 10, 74,
 54,117, 38,108, 63, 14,  6,  0,241, 52, 10,254,102,  2,175, 84, 92, 61,204,206,
188,179,173,222,182,246, 94, 78,211,142,  8,164,213, 96,156,219,202,163,125,118,
 47,196, 83,228,147,232,241, 41, 12,150,188, 19, 53,179,176,108, 35,179, 82,243,
145,124,231, 48, 29,  4,107, 73,178,202,209,172,185, 38,108, 61, 71,169, 37, 21,
 79,126,136,236, 22,227,  0,  4, 94, 16,250,108,237,232,111,156,176,188,245,207,
 53,103, 86, 24, 20,212, 95,171,235,200, 59,199, 87,166,150,170,230, 36,143, 31,
160, 98,148,247, 66,226, 87, 30, 32,114,250,211,231,129,186,219,  3,137,189, 42,
108,251,166, 17, 53,  5,233, 21,  6, 49,  2,192,128,201,145,192, 77,233,244,131,
162, 51,227,221,202, 25,143,110,181,115,251, 53,192, 42,151,137,129, 68,167, 49,
154,114,221, 69, 17,100,  5, 99,163, 46,244, 77, 19,251,153,105,170,113, 20,164,
 51, 30,170, 66,129, 48,
} ;

// ../Source/assign/template/GB_subassign_22_template.c:
uint8_t GB_JITpackage_110 [564] = {
 40,181, 47,253, 96,117,  5, 85, 17,  0,198, 30, 95, 32,240, 24, 61,208,133,145,
136, 47,145,124, 48, 47,150, 42, 43, 50,238,192,245,239, 45, 24, 38,253,232,202,
  5,158,129, 52,135,191, 86,  0, 84,  0, 83,  0,219, 97,211, 24,136,195,230,  2,
138,121,166,235,105, 78,188,192,185, 10,220, 98, 88, 57,158,117,220, 69,  2,226,
153, 43,141,215,121,226,238,119, 29,187, 43, 79, 59,169,246,169,242,239, 78,183,
118, 36,185,174, 46,253,243,131, 40, 87, 57,132,224,210, 27,191,167,197,225,111,
111,219,188, 91,170, 90,207,209,168, 61, 73,197, 13,134, 75, 51, 24,  2,247,245,
103, 28,142,148,206,167,211,226,207,158,252, 62,139,183, 84,189,177,233,152,183,
126,109, 39,  9,135, 34,245, 76,122, 94, 46,157,140, 55,190,108,219,252, 19,193,
253,152,235, 80,216,180,  7,233,196,156, 55,242, 87, 82,221,247, 63,139,246,250,
 62,173, 23,237, 51,209, 20,190, 63,229,215,191,113,189,193, 82,221,184,181,156,
103,138, 46,192, 28,226, 41,233,155,214,188,245,231,129, 83, 52, 32,142,244,253,
165,212, 12,189,204,116, 71,144,122,  6,185,190,111,245,173,175, 72, 29, 46, 88,
 93,138,121,119,225, 60, 25, 79,190, 30, 93,220,174,191,249, 25,220, 78, 18, 61,
255, 40, 28,175, 63,184,253,111, 13,243,239,255,220,221,253,186, 88,215, 85,184,
226,237,156,219,  1,215,213,186, 90, 89, 38,177,103, 41,137,121, 20, 14,119,233,
 96, 58, 82,114,166, 44,162, 68, 18,135, 60,229, 44,  2, 97,117,169, 63, 28,126,
112,136, 75,140,  9,104,221,115,107,236,237,248, 61, 72,181, 11, 48, 47,139, 36,
183,111,237,204, 19, 59, 14, 69,159, 97,105,102, 28,144,216,183,151, 88,236, 91,
 69, 93,  1,152,115, 54,148,174,227, 82, 17, 77,  6, 65, 32, 32,132, 16,166,170,
172,  3,229,136,192, 12, 25,247,125,240,228, 77,  7,222,134,  7,145,135,220, 74,
 64,  4,212,139,141, 25,236,158,246,100, 39,221,192,161, 21, 56,240,201,  4,250,
133, 24,107,  0,220,109, 10,137, 41,106,145,  7, 91,141,  3, 90,196,129,236,119,
 26, 39,112, 80,206,101,195, 96,217,144, 73,205,  5, 19,138, 89,114, 94, 12, 31,
 34, 82,240, 28,174, 98,242,148, 87, 38,103, 91,197,178,127,129,209, 83,113, 65,
 34,  5,197, 13, 70, 96, 88,  6,161,182, 67,197,145,122, 69,208,130,175, 91,  3,
130,208,145,119,172, 66,205,212,  3, 70, 68,126, 51,222,  8, 63,145, 97,112, 92,
115,206, 81,182, 86, 25,206,166,217,121,102, 66,219,166,171,117, 77,241,104,168,
 21, 42, 10,134,
} ;

// ../Source/assign/template/GB_subassign_23_template.c:
uint8_t GB_JITpackage_111 [1806] = {
 40,181, 47,253, 96, 95, 29, 37, 56,  0,246,126,189, 40,176,148,117, 14,180, 32,
108,223,223,245, 11, 22, 22, 47,251, 25,167, 77,212, 93, 24, 47,106,  4, 49, 61,
147,194,110, 42, 17,202,165, 63,232, 63,216,254,193,185,177,  0,174,  0,181,  0,
215,188,247,119,202,239,109,212,215,187, 35, 22,204,180,147,249, 54,110,240,235,
194, 90,105, 87,202,125, 13,206, 43,107,208, 59, 38,215, 16,204,184, 49, 71,181,
175,243,234, 12,193,180,211,185,176, 56, 38, 34, 92,158,121, 91,110, 15,101, 41,
184, 84,122,171,244,147,199,128,109, 53,155,111,103,156, 74,227,219,213,118, 42,
 26, 27, 80, 65,214, 38,176,113,135,142,243,  6, 98, 67,231, 56,249,168,112,177,
 92, 42, 12,  7,150,203,173, 90, 61, 98,107,162,155, 23,200,159,182,236,117,118,
244, 40,146, 29,136,237,163,160,  4,166, 49, 72, 63, 81,103, 27,138, 40,142, 11,
181, 99,251,235, 13,246, 38,114,121, 13,229,215, 49,157, 41,247,117,157, 39,194,
101, 94, 16,139, 49, 37,133,120, 66, 72,220,192,128,170, 24, 24,  4,155, 14, 54,
 97, 49, 37,206,104,131, 91,196, 33,152,230,139,133,100,231,194, 54,178, 51, 15,
 21,233, 69, 72,207,136,  3, 49, 69, 28,205, 63,218,101, 75,154,216, 78,121,206,
243,174, 87,113, 14,191,107,159,169, 18,138, 58,201,220,202, 51, 97, 33, 95,251,
 88, 45,215, 83, 86,  7,125, 64,179, 34,132,101,252, 47,161, 60,222,215, 10, 80,
157,142,156, 24, 22,138,248,181,206,110, 24,176,225,240,134,  6,  1,239, 44,228,
  4, 42,154,173, 96,250, 38,197,  6,195,159,178,197, 63,181, 73, 82,  5,  9,150,
 19,233, 32,215,102,239, 62,135,164,231, 75,235, 27,211,250,106,193,190, 13,114,
110,179,228, 99,165,185, 85,138,182,234,122, 45,126,188,158,205,245,130,158,118,
146,103,151,126, 36,127,171, 25,135,221,175,150,242,145, 14,175,205,214,199,215,
  1, 64,161, 56,252,251, 42,171,218, 76, 51,174,154, 11,179,222, 42,190, 85,205,
 46,188, 92,115, 28,  5,233,247,211, 14,132,130,159,192, 71, 34,229,217,112, 59,
  4,243,163,229, 49, 78, 47,207,146,165,115,  3,244,185, 62, 44, 29,214,105, 35,
 91, 25,114,212,244,177, 78,213, 55,174, 90, 45,235,186,174,235, 26,177,170,107,
 62, 34,159,171,  5, 51,110,144,224, 24,104, 99,116,  1,  0, 60, 94, 16, 30, 43,
 66,159,140,169,193,  9,141,164,103, 98, 23,167, 35,146,111,147, 23,222,203,111,
204,245,137, 70,243, 81,  8, 19,137, 50,183,140,208,110,222,112,171,143, 85,174,
199,128,222, 75,172,155,152, 84,215,106,155, 46, 69,243, 16,208, 19,121,115,164,
208,203, 50,174,183, 73,114,239, 73, 46,173, 30,212,137,101, 79,201,255,210,158,
242,235,123, 69,115,123,135,204,175,185,252, 48, 14, 78,232, 51,186, 48,140,185,
241,112, 68, 83,122, 36,100,  8,116,108, 15,240,129,  1,130,151, 46,171,228,229,
227,124,173,247,253,250,172, 74,213,248,118, 86,162,143, 49,198,248, 56, 79, 29,
104, 30, 80,222, 35, 76, 98,202, 16, 57,183, 18,182,151,165,121,207,217,181,218,
 29, 50,183, 48, 17, 83,101,254,209, 65,159,169,119,143,219,203,238,195, 53, 75,
 57, 28,196,106, 59,122, 79, 89,102, 15,210,140, 63, 10,229, 50, 26, 57, 51,  6,
173, 22,146, 53, 71,234,194,210,117,221,230, 76,212, 90,107,183,109,219, 66, 35,
208, 71,125,230,  6,235, 64,120, 46, 40, 90,123,131,116,203, 30,233,241,187,170,
 99, 35,217,185,240, 92, 92,215,150,  3,129,205,168,145,185, 82, 52, 34, 34, 73,
 74,146,210,112, 81,  8, 98, 24, 39,161,180,212,  3,226,104, 84,  7, 84, 20,228,
 44, 65,198, 24, 35, 50, 34, 18, 76, 40,129,136,146,114, 53, 29,176,  8, 48,167,
 77,142,203, 70, 90,146,207,157,234, 34,155,206,209,250,100,209, 51, 88,249,243,
 81, 11,140, 65, 17, 47, 47,191, 88,124,240,210,108,254,141,212,212, 17, 15,236,
 28,181, 57,  7, 61,112, 89,206,128, 83,161,116,211,228,185,233, 91,194,218,112,
115,197,183,108, 72, 85, 49,233,183, 16,115,113,189,207,  5,129, 51, 51,201,  6,
219, 90,222,  2,158,187, 53,204,229, 75,170, 70,255, 46,187, 78,166, 64, 67, 40,
168,113,185, 90,181, 50, 32,244,220,189, 20,109,194, 94,218,126,161,200, 43,125,
 59, 98, 40,248,165, 72, 78, 58, 49,221,214, 90, 51,  7,244,167,255,235,109,191,
254, 52, 96, 95, 55,192,190, 29,216,230, 18,  4, 49,143,121,122,138,236,190,208,
126,168,226,132, 94,  5,204, 64, 14,197,223,250, 15,153, 64,192, 89, 20,118,125,
110, 96,  2,195,174, 35, 62, 73,118,142, 83,100,104,109,  1, 74,117,249, 96, 35,
122, 77,223, 50, 84,115,110,169,235,247, 24,169, 33,116,134, 39,170, 72,218,138,
150,199, 64,218,  1,189,187, 84, 98,145,110,205,115, 36, 77, 23, 56,100,112, 10,
133,181,129,230, 68,183, 55,247,197, 15, 33, 22, 44, 39, 25,195,184, 20,253, 83,
137,240,138, 56,163, 27, 11,199,136, 44,191, 13,250,166, 75,105, 28,210,239,137,
245, 43,119, 22,188,103, 95,148, 67,178, 49, 13,  4,133, 30, 15,171, 30,143, 29,
 15,147,  6,126,241,  7,111,212, 32,125,  4,118, 28,230,222, 16,138,  0, 88, 82,
112,102,142, 77,144, 32,115, 18,  2,238, 72, 14,194,120, 13,193,107, 38, 13, 88,
 56,254,206, 77, 33,164, 80,195, 16, 36, 10, 65, 94,  7,245,224,173,239,135,214,
 84,151,200,  9, 62, 32,  6,167,119,130, 73,207, 78,142,150,174,213, 34, 47, 13,
210, 49, 26, 51, 16,168, 96,  8,150, 96,194, 68, 48,193,182,202,245,164,210, 82,
 62, 27,  1,129, 34, 52, 21, 72,144,164, 11,179, 47, 42,167,117, 32, 50,162,126,
208, 97, 42, 74,169,255, 51,124,  0, 83,161, 90,138, 28,208, 94,240, 61, 58,207,
119,170,136,237,206,248,209, 60,179, 17, 91, 75,241, 98,121,156,243,162,169,  7,
 38, 83,111, 14,242, 68, 98, 69, 16, 48, 25,197, 23,189,178,155,219,121,152, 49,
193, 21,223,106,100, 45,254,204,248,  2,218,128, 57,168,181,204, 54,179,144,  5,
 28,  3,234,236,142,233,213,244, 99, 55, 78,115,150,120, 22, 12,  6, 89,246, 68,
 59, 65,112,194, 67,  7, 97, 62,246,142,129, 42,228, 34, 11,235,197, 43,200,190,
176,138, 48,110,152, 76, 16,149, 94,142, 32, 39,106, 54,  1, 83,240, 24,200,  0,
191, 91, 78,161,136, 22, 21,101,185, 65, 57,249,241,170, 19,  4,189, 39,160,223,
170,223,176,232,  5,114, 11,178, 54,169, 13, 46, 35, 42, 74,206,186,126, 61,105,
127, 40, 50, 48, 43,223,  6,154,126,146, 74,107,241,100,122, 18,118,132,  4, 65,
  4,165, 96,170,202,102, 60,184,107, 53,217, 24, 56,247, 49,240,206,122, 84,242,
  3,112,241,140,182,  3, 22,138, 14,217,124, 84, 45,231, 59,108,155,154,  9,155,
183,221,225, 45,148,151, 97, 59, 78,156,194,114,154,149,118,  3,176,110, 90,165,
154, 19, 89, 22,181,  7, 98, 52,155, 18, 18, 54,210,243, 15, 20,120,196,226,116,
222,159,117,164,147, 86,155,132,225, 53, 86,205,179, 27,244, 91, 94,123,137,192,
 80, 29,103,202,215,189,120, 18, 39, 97,164, 62, 65, 97,152, 63,254,213,125,245,
121, 73, 45, 19, 99,155,128,138,241, 65,152, 91,111,183,209,212, 38,  5,219, 96,
165, 49, 63,170,142,193,168, 64,163, 32, 76,204,106, 17, 72,139, 39,230, 94, 42,
  2,109,162,231,119, 93,113,239, 97,135, 86,145,234,106, 48,147, 93,174, 98,159,
166,204,103,227,228, 88,106,102, 67, 46,194, 12, 42,126, 65,205, 45,107, 21,128,
241, 38,144,237, 38,133,158, 32,213,119,253, 61, 74,168,161, 37,165,160,121,105,
 35,  4,193, 42,140,107,187, 49,175, 92, 41,151, 24,178,  8, 99, 47, 11,243, 81,
 50,175,170, 64, 10,239,230,141, 62,118,116, 49,204,159,105,203,  5,200, 80,196,
 50,213,168, 88,227,130, 45,132, 69,193,220,139, 51,  6, 84, 46,  5, 63, 86,254,
244,122, 56, 44, 18,154, 44,  7, 58,247, 85,126,239, 58,226, 54,238,190,150, 15,
 81, 23, 25,177,128,203,132, 94, 48, 44,174,206,243,195, 10, 41,  4, 85, 89,199,
 66,145, 70,108, 99,143, 96,124,161,232,159,141, 61,169,  2,120,178, 59, 80,112,
 28,232,243, 84,103, 41,178,164,137,142, 57, 55,205,240,103, 38,112, 98,168, 45,
 71,236, 86,173,  0,100,
} ;

// ../Source/assign/template/GB_subassign_25_template.c:
uint8_t GB_JITpackage_112 [2009] = {
 40,181, 47,253, 96, 65, 32,125, 62,  0,234, 71, 72, 13, 40,176, 86,177, 14, 84,
100,128, 23,150,108,206,119,200,225,106,241, 36, 82,150, 56,206,211,194, 49, 12,
192,113,150,196,158,189,114,252,160,255,160,243, 83,130, 11,201,  0,194,  0,209,
  0,248,153, 74, 82,115,125,159, 43,157, 94,226,154, 52, 51,214,154,214,141, 73,
206,246,141,213, 49,141, 57,169,217, 81,197,162,  8,150,153, 54,238,107,143,225,
184, 78,187,104,243,130, 37,129,149,163, 60, 69,135,127,156,188, 93,198,186,155,
241,175,191,  6,252, 46,  7, 10,243, 48, 83,117, 76,194,193,179,186,229,190, 42,
  5,  3,  7,151,222, 48,105,225, 49,183,167, 54,243,230,130, 77,206, 69, 67,227,
 25,200,154,116, 27,247,231, 56,111, 32,243,115,142,131,127,  9,  7,  5,  7,151,
  5,131,130,131, 83,216,244,135, 39, 73,106, 62,  0, 95,218,114, 29,205,208, 31,
  8,114, 32, 54, 43,175,  4,166,241,149, 22,212,121,118,160, 74, 99,218, 25,124,
 70,229, 75,249,120,190,122,223,222, 72, 14,159,249,195,229, 80, 29,211, 89,114,
118,212, 57, 38, 28, 68, 10, 50, 49,150,162, 14, 71,  8,137, 19, 16, 84, 46,  4,
  4,  1, 17,211, 67, 31, 11,  4,130, 15,151, 10,225, 21,218, 64, 68,208, 38,243,
136,103,132,231,106, 21, 29,231,  6,121,229,164, 82, 73,105, 56,149, 35,130, 66,
166,243, 15,132, 78,108,114, 29,175,233,158,142, 39, 86,124,172,140,255, 39, 21,
143, 55,157,  1, 48, 90,214, 39,226, 90,103,180, 11,120, 31,184, 74,182, 98,207,
152, 44,105,173,158,222,206, 89, 90,121,156,175,204, 24, 94,155,175,120,214,219,
 38, 84, 53,153, 80, 90,101, 58,229, 22,250,  7,114,103,233, 60,173,191,122, 36,
241, 79,210, 23,203,103, 77, 43,246, 42,214, 54, 89,115,162, 81, 23, 82,186, 90,
244,219, 91,158,253,140,187,209,243,124,238, 68,127,180, 73,253,215,165, 60, 75,
 77,146,219,169,196, 14,255,129,219,182,180,253,214,227,247,149,191, 42, 77, 43,
 45,153, 55,203, 17,228,112, 46, 44, 70, 29,134, 73, 10,163, 51,184,167,104, 84,
 77,180,153,209,148, 87,240,247, 98,205, 49,100,202,184,225,233, 88,154, 78, 21,
 53,112,224,249,245,179,220,242,233,172, 42,254,195,221,111,131,208,202,189,226,
185,133, 62, 10, 58, 40,172, 98,137,181, 45,101,216, 29, 39, 73, 39,148, 38,114,
 43,  9, 54,189,170,170, 18,106, 42,  9,  1,180,133,196, 38,118,180,206,180, 25,
144,169, 42, 40, 69, 34,248,140,205,155,113, 95,  1,134,204,105,115,164,235,115,
206,109,219,174,103,109, 69, 39,106, 44, 14,196,117, 65,241,177, 60, 27, 19,160,
 15,244,128,170, 79,200,243, 55,171, 89, 85,127, 88,147,232,195,229,186,229,127,
 12,127, 21,159, 78, 70,212,216,124, 66,240,138, 86,181,225,128,168,140,235, 45,
106, 56,214,132, 69,188,240,195,153,236,187,101, 26,175, 91, 31,200,169, 44,141,
  8,237, 54,236, 89,155, 76,124,225,100, 55,210,175,215,251, 24,174, 57, 78, 94,
233,129, 40, 40,  1,149, 46,192,226,216,124, 58,161,202,194,136,154,107,  3,138,
240,146,128, 31,207,149,109,173, 60,199, 77, 18,250,138, 51,150,249,204, 63, 46,
219,241,249, 87,205,233,214,  6,226,234,112, 88, 44,242,184, 71, 21,107, 81,202,
 95, 73, 53,189,162,115, 78, 63,161, 62,108,199, 69,112,222,114, 56, 51,159, 14,
 13,191,172,188,192, 67,158,201, 53,211, 89,237,161, 13, 49,176, 60,251,222,123,
 25,237,191,120,217,233,208, 19, 67,150,132,200, 21,183,144,252,146,232,180,222,
182,181,230, 83, 57,163, 83,187, 67,195, 41, 76,108,248, 71,199, 21, 51,207,178,
107,118,138, 37, 39,242,135,103,124,167, 38, 98,177, 56, 76, 20,198, 50,209, 58,
 51,118, 41,131,135,205,145,164,165,108,106,174,203,122,195,240,169, 41,142, 58,
250, 91,181,219,219, 81,189, 28,129,200,107,  3,178,153,223,240,130,103,104,213,
 89,246,197,  2,130,  4,168, 66,180, 80, 41, 52, 68, 34, 35, 41, 72, 82, 25, 14,
130, 32,  4, 66,137,172, 38,138,168, 15,178,192, 44,150, 81, 12, 83,146,  8,148,
 17, 16, 66, 76, 32, 34, 34,129,  4, 34, 49,146,100,130,121,133,208,193,223,182,
215,223,131,209,178,226,207,118, 53, 40, 28, 55,101,228, 98, 31,120, 53,  4,  1,
181,135,118, 26, 31,142, 38, 32,137,187,130, 24, 20,202,163, 79,239, 34,168,187,
 33,116, 36,145,128, 81,114,178, 77,106,173, 36, 17,181,150, 60, 69,162,247,116,
121, 47, 72,  9,179, 71,217, 41, 71,150, 17, 16,209,130, 26, 65,169,240,130,186,
 63,151,247, 45,178,239,203,205,253, 83,228,194,231,122,  7,155,212,196,147,196,
119,138,180,157,245,133,123,116, 82,143,178, 75,219,179,148, 77,144,  0,156, 84,
 64, 51,  9,154, 63,169, 39, 16,164,247,157,116,218,131,228,216, 99,103, 41,234,
195,  4, 54,173, 60,  8,200, 33,126,221, 32,168,196,187, 50, 38,138,104, 74,234,
 17, 29, 14, 61, 18, 74,252,107, 19, 79,247,225,223, 86,164,170, 94, 73,101,125,
221,166,240,228, 51,214,210,177, 50,231,  9,203,185,248,222,197,128,168,104, 78,
131,149, 41,171,234, 20,252, 87,211, 36,230,194,  7,223,132, 47,  5, 43, 24, 70,
 48, 84, 16,250,137, 33,254, 34,130, 13,240,177, 74,194,232,114,125, 79,176,254,
 16, 31, 27,115, 73, 99,103,  6,250,129,129, 13,116, 88,200, 11, 85, 23, 74,200,
207,  0,207,112,159,160, 74,252, 20, 92,189,177,153, 78, 51,145,  7, 77, 72, 33,
205,116, 68,101,147,200, 27, 60, 89, 45,175,162,163,180,117,216, 99,239,219, 54,
104, 14,231,251,124,219,185,221, 93, 19,192, 80,105,141, 22,147,135,166,170, 85,
171, 80,205, 80, 73,227,109,177,196,109,  8, 99,154,223,154,159,159, 52,133,227,
170,174,  4,123, 92, 29, 65,137, 70,102,131, 83,213, 44,168, 86,108, 33,224,215,
194,212, 28,182,252,225, 89,113,127, 15,  1,218, 28,245,  9,148,237,159,107,163,
224,236,  2, 49,217,231, 60, 63, 86,164,150, 21, 72,251, 61,239,252,158, 92,164,
224,  5,  0,218,184,250,217,118,215, 42,243,207,184, 42,198,180,251,210,235,189,
165, 55,122,111,214,142, 98, 67,  4,171, 73, 74,105,230,134,194, 21,  1,  6, 61,
121, 58,237,139,163,189,222, 72, 46,102, 34,204, 79, 52,  3,251,172,102,241, 90,
128,115, 61,130,106, 80,182,233,131,228,  7, 27, 39,186,101,228, 18, 77,178,244,
205, 72,170,135,244, 65,249, 52, 88,124, 41,140,201,131,130, 99,219,205,147, 47,
 80, 31,145, 21,237,108, 79,223,160,158, 88, 90, 14,160, 16, 12, 86,  9,249,149,
190,191, 80,135,  4,134,158,141,170, 89, 41,254,152,247,173,124, 53, 20,224,196,
181,194,252, 16,179,227,173, 12,112, 79,218,127, 37, 68,169,150,225, 85, 32,224,
 21,  1,188, 76,108,121,244, 89,169,  7, 14, 92, 16,153, 73,134, 81, 54,240, 39,
 18, 83, 73, 66,101, 88, 80,219, 15,170, 76,  9,219, 25,229, 19,214,119, 51,109,
215,107, 10, 76,176,200,141, 60, 94, 24,188,172,180,113,147,105,241,242,154,118,
 59, 87,164, 93, 67, 29,194,129,210,  9,220,166,134,168,130,153,206, 12, 51, 85,
 85,196,181, 30,  3,146,234,191,126, 78,234,164,233, 76, 27,203,123, 96, 98,242,
126,219, 92, 15, 67,244, 39,164,118, 85,118, 19,255, 72,187,191, 36,113, 24, 62,
 22,233,  3,159, 83,105,223, 76, 57,  6,143,212,146,238, 66, 16, 33, 81, 24,231,
 79, 73, 17,200,200, 40,127, 77,214,153,197,229,133, 50,  7,206, 15, 27, 85,  5,
105,122, 36,132,178,  5, 55,137,128,134, 79, 77,152,101, 13,232, 30,184, 43,118,
254,253, 43,137,214,151, 62,172,111,168, 82, 60, 36,120,131,125,129,230,233, 85,
 72,237,147,168, 96, 69, 21,111,143,195,198,218, 22,206,155, 95, 83,228,218,210,
113,  3,104,188,111,123,149, 22, 57, 76,133, 56, 90, 92,131, 61,108, 36, 65,162,
 69,134,184,  5,122,242,174,186, 60, 34,227,232,141, 45, 18, 29, 36,207, 57,176,
142,195, 53, 65,185,133, 45,  7,157, 70,178,250,167, 72,  0, 91, 36,188, 65,104,
  7,227,146,173,167,103,243,158,242, 33, 27, 52,189,128,  8,146,151,196,118, 85,
244,166,241, 11,212,166,156,231, 26,138,119,231,148,157, 29,114,153,245,126,227,
 52,254,105, 82,156,254, 73, 90,154,142, 19, 26,177, 25,237,167,198, 70, 61,180,
  0,109,233,170,124,228,  1, 56,198,104,214, 36,221, 14, 61,133, 54,110, 70, 28,
105,102,112,215,  7,101,148, 54, 57, 19,226, 11,100,164,149,212,144, 72, 81,236,
 50, 60,186,250,227, 42,195,118,148,207, 75,101,127, 28, 38,181,  8,117,174,102,
134,  6,  1, 25,181, 13,250,226,185,211,148,128,154,106, 19,154, 59, 60, 72, 97,
 32,150,142, 99,212,216, 65, 75,135,155,109,136, 91, 42, 89, 50, 48,202, 44, 23,
 21,195,243, 18, 51,233,205, 85,233,170,164, 14,140, 85, 36, 97,171,215, 73, 44,
252,193,184,254, 67, 95,100, 58, 36, 67, 30,146, 97, 40,164,143,  1,104, 71, 91,
142,243,131,143,155,138,198,  4,158,240, 26, 10,208,138,156,240, 17,147,208,207,
234,148,187,120,195,167,249,228, 60,130,106, 49, 21, 51,129, 27,112,165,107,186,
 40, 93, 95,  0,152, 90, 43,128,102,
} ;

// ../Source/assign/template/GB_subassign_27_template.c:
uint8_t GB_JITpackage_113 [2575] = {
 40,181, 47,253, 96, 91, 48, 45, 80,  0, 10, 87,204, 15, 45,160,142,217,234,154,
 20,224, 73,191,203,151,141, 12, 81,252,112,116, 98,101,201, 37,226,202,175,150,
164, 78,135,213,223,169,169,181,248,160,253, 10, 94,135,215,  1,167,240, 84,  1,
236,  0,234,  0,243,  0, 17, 60, 24,155,140,189, 23,189,188,113,  8,164,  2,  4,
242,181,246,122,155, 39,153,217,190, 59, 72,195, 22, 78,191,176,186,151,125,138,
111,101, 43,251, 92,225, 45,247,199,154, 31, 60,201,182,143,241,  2,157, 63,151,
112,186,251,133, 66,235,246,231,215,177,156,210,163,235,133, 86,179, 88,215, 52,
 65,158,184, 62,103, 35,  4, 81,107, 78,124,203, 19, 89,232, 94,221,238,248, 40,
222,  9,122,240, 41,182,176, 35, 60, 37,225,153,229, 74,111, 57,  0,113,106, 86,
151, 55, 16,202,  4, 66,194,213,  4,105,187,165,114,131,250, 74,166, 52, 18,182,
146,167,182,144, 64,160,192,152, 80,204, 81,217, 50,231,246, 86, 27,205,121,140,
237,172,  0,  4,  5, 66,114,160, 66,129,120,100,146,206,108,115, 64,138, 79,218,
 71,213,157, 86,123,206, 58,205, 98,162,162,176, 86, 88,216, 86, 72, 59,124,251,
234, 64, 58,159,242,151,183, 99, 28, 46,113,167,171, 94,203, 92,132,187,133, 47,
140,212,226,251, 14, 64, 60,185,209,214,194,207,101,223, 68,197, 31, 30, 32,146,
135,135,135,183,207, 62,137, 72, 24,141,205, 45, 24, 19,182,175,131,194, 22, 86,
244, 33,160, 60,158,145,235, 55, 46,202, 62,114,140,211,158,193,169, 35,237,123,
182,253,128, 69,213,116, 89,117,110, 68, 56,113, 48, 94,182, 71,125, 15,166, 44,
104,229,197,181,181,229,174, 87,242,103,199,189,248, 52,227,248,129,118, 86,254,
168,252,177, 46, 89, 39,168,154,160,180,103,171,175,164, 66,150, 29, 15, 97,237,
 91,103,101, 39,188,253,168, 50,199,235,124,109,126,101,170,249, 99, 41,102,121,
215, 48,105,  7,205,203,217,119, 98, 91,249,142,162,156,204,157, 69, 34, 33,102,
145,154,244, 15, 41,165,203,182,164,135,158,117, 89,233,112,131,173,139, 79, 34,
180,250,210,249,121,207,118,198, 38,221,194, 34, 67,193,235,104, 48,207,246,107,
 16, 52, 28, 79,219,188, 77,134,115,109, 65,167, 45,120,156, 12, 70,132,  5, 47,
 66,185,132,148,144, 56,233,152,199,108,223,  8, 90,143,115, 90, 57, 39,190,246,
178,126,185,123,158, 76,197,229,158,142,198,162, 65,167,121, 94, 79,240, 72,213,
142,193, 92, 52,167,202, 28, 44,217, 70,190,112,153, 76,144,240, 99, 64, 19, 94,
 88,153,206,246, 10, 79, 58,232,114, 74,242, 99, 21, 73,163,162, 42,116, 11,111,
251,149,239,133, 81,218,192, 24,113,249,181,181, 65,162, 99, 46,178,109,127,190,
215,229,149, 12,198,227, 92,112, 92, 39, 67,241,234,188,180,235,100,153,114,112,
120,196, 47,167, 28,115,170,165, 10,155,218,130,114, 68, 73, 28,145, 36,181,230,
161,181,  1, 43, 21,192, 23, 82,244,186,165,114,142,  7, 67, 19, 17, 85,126,176,
 97,141,  1,131, 51,  6,141, 81,206, 88,195, 45,114,198, 57, 81,178, 69, 82,115,
166,121,195,131, 59,219,180, 55,239, 99,150,130, 92, 43, 43,249,163,237,107, 11,
 15,131,116, 41,189,193,  5,196,128,144, 70,228, 58, 99, 22, 46, 67,177,153,152,
 67,106,252, 62,  2,  6, 70,236,225,193, 69,156, 52, 29, 52,218, 49, 43,251, 42,
 13,169, 99,101, 58,170,110,111, 95,202,147,  7,107,124, 66, 47,209,156,241,119,
226,218,212,148,146, 41,  7,186, 38, 38,117, 47, 20, 89,120,207,178, 65,  1, 16,
200,  5,200,229,145, 78, 39,227, 92, 70,231, 77,212, 10, 73,227, 81,  2,220,154,
 21,244,123,209,123,205,187,  0, 30, 78,166,211,105,153, 12, 71,193,141,151,229,
122, 89,175,203,149, 63, 58,194, 11,206, 53,231,122,116, 61, 88,206,203,221,245,
185,189,182, 61,184, 93, 58,199,174, 58, 64,243,  2,238, 53, 63,240,204,  1,171,
159,129,129, 57,202,224, 92, 75,174, 53,  7, 25, 24, 32,  6,116,191, 74,117,221,
 32,216,112,  9, 71,105,107,173,181,230,152,168,206,142,209,217,133, 71,243,112,
210, 67, 13, 95,198,211, 44, 50, 92,223,161, 78, 74,225, 45,145, 55,  7,135,185,
116, 11,156, 80,121,187,147,  0,192,181,244,140,102, 98,115,161, 97,219, 69, 92,
254,134,135, 26,109,160,136,  8, 87,145,208,179,238,215,154, 47,217, 55, 50,221,
130,133,169,125,200, 16,116,163, 75, 45,182,162,137,171,233,162,169, 47, 10, 24,
 73,104,194,252, 86,120,237,115,206,157, 57, 39,221, 57,183,217, 56, 55,225, 38,
156,115,174,226, 32, 57,114,180, 51, 70,155, 68, 37, 34, 19, 68, 18,110,121, 72,
146, 14,177, 92, 20,130,162,168,210,219,218, 72, 52, 35, 34, 73, 65,138,146,225,
178, 24,132, 33, 65,164,167,177,164,222,  2,121, 60,202,177, 16,134, 64,194,  8,
 17, 16, 98,136,  0, 17, 66,  2, 17, 17, 17, 17,  9, 36, 16, 81, 81,  7, 57,  7,
 80,176,230,195,170,192,104, 88, 71, 17,128,132,105,167,242,100,221, 41,127, 48,
 93,162, 33,139, 43,105, 50, 47, 87,225, 87, 96, 16, 69, 69,177, 23,171,111,104,
174,183, 97,159,144,255,139,105,170,139, 93,137,125,172,107,168,184, 77,205, 11,
198,113,122,198,186, 97,222, 89, 53, 54, 68, 59,  2,142,163,194,  8,  0, 72,160,
192,156,207,102,156, 83,156,173,120, 80,161, 52, 12,108,177,140,122,148, 27,203,
219, 75,239, 99,179,243, 74, 12,105,138,157,  8,  8,194,143,192, 76,152,255, 84,
230,  3,187,244,149,255,195, 94,200,147, 49, 30, 50, 21, 53,236, 98,162,122,138,
 39,222, 66, 48,236,135,242, 59,142,158,241, 40, 85,212,115, 45,182,120,211, 72,
 99,205,233,126, 23, 67,106,136, 71,174, 79,120,133,234,130, 53, 75, 32,117,226,
130,  4,213,162, 15,251,209,208, 33,  0,178, 80, 24, 24,128, 50,  8, 75, 87,128,
246, 81, 78,224,152,104,  8, 34,106,192,  0, 18, 61,208,236,128, 71,115,216,  0,
  4,251,135,196,186,251,133, 97,188,  1,201, 40, 32,164,136,244, 42,  8,185,212,
  3, 42,149, 67,120,228, 99, 84, 14, 93, 58,  7,187, 24,105, 29,106,121,242,164,
 66,143,236,189, 14, 99, 18,121, 93, 27, 98,227,210,125,182,242, 63, 62,239, 34,
 15,194,185,129,156,189, 38,154, 90, 44,186, 23, 73, 72,253,146,109,177,211,113,
 58,218, 92,241, 19,147,123,109, 24,109, 98,243, 53, 64, 26,137,124, 57,211,106,
 56,139, 97,115,204,246, 50,230,217,210,239,107,225,208,111,141,175,251, 78, 41,
183,121, 56,217, 93, 21,148,204, 28,189, 45,217,193,172, 11, 38,167,134,254, 74,
236,239,217, 42,  9,221,201, 30, 50,114,231,232,121, 72, 93,150, 71, 17,165,183,
234, 32, 92,103,160,219,132,123,249, 68,139,120,180, 62,129,109,215,  9, 68,124,
181, 99,227,  6,157,140,156, 94,236, 86,111,248,100, 82, 27, 99, 97, 67, 31,204,
179,107, 93,233,228, 49, 88, 20,251,204,  4, 87, 74, 44, 68,  6, 21, 37, 78,176,
165,193,235, 28,234,156,223,245,248, 10, 38,132, 36, 27,157, 55,106, 27, 80,255,
  3,  1, 16,157,202,121,111, 91,118,188,186, 19,227, 47,112,125,123,109,111,121,
 29,212, 52, 48,242,167,223,245,184, 81,208,  5,251,209,166,120, 82,145,  6, 56,
195,111,  8, 13, 32,223,199, 43,220,251, 13,134, 31, 81, 60,164,192,234,224,130,
116,240,242,190, 73,242,161, 72,195, 96, 58, 96,200,161,132,126, 34,189, 63,130,
 33, 61,158,  1,136,182,  3, 56, 97,214,145,106,238, 26, 80,117,110, 14, 29,232,
117, 90,135,248,134, 42,117,166,193,  3,123,151, 16, 11,236, 50, 66,207,252, 69,
 52,232, 67, 64,203,132,  2, 34, 94, 30,  0, 71, 84, 23,245,153,181,116, 14, 66,
225, 43, 41,221, 68,211, 56,112,189,202,112,  1,137,133,224,224,190,107, 74,186,
  0, 10,227, 16,  7, 38, 41,114,154,217, 45,182,155,  8,104,167, 15, 19,241,231,
129, 89,133,190,236, 56,159, 36,  5, 78,126,111,  9, 74,134,126,106,137,212,194,
210,111, 74, 25, 54,158,254,226,148,196, 41, 48,255, 25, 36, 77, 38,142,207, 87,
231,160, 95,155,101,236,164, 57,212,220,181, 11,195,130,  1,108,  9,248, 78,225,
106,210,190,130,155,243,111,  0,167,124,139,  0,102,220, 88, 12,221,202,  9,153,
158,102,128,152,233,122,231,213, 34,217, 11,147,208,231, 92, 73,177,207, 72,254,
 34,192, 11, 76,220, 55,156,200,246, 19,192,151,246, 78,133,100, 36,193,240,124,
178, 39,162,148, 63, 90,143, 97,174,134,237, 78, 75, 88, 43, 11,149, 64, 18,124,
120,  9,230,232,  1, 98, 23,170, 51,215, 36,211,113,129,243, 24, 81,183, 56,201,
130,204,189,104,231,164,140, 98,117,135,228, 81, 20,229, 47,156,185,133,223,145,
183,200, 28,129, 58,148, 16,243,  5, 32,153, 95,134,  8, 23, 98, 63,164, 10,132,
244,135,134,251,141, 25,168, 87,200, 74, 27,153,247,224,134, 69,185,176,194, 42,
183,252,157, 22,124,200, 65,185,222, 83,  9,190, 90,219,255,205,166,  4, 60,147,
 88,172, 53,131, 53,179, 32, 74,171,244, 26,170, 58,101, 81,199, 19,  8,232, 92,
172,188,103, 63,179,183,225, 40,162,192,163,108,126,247,222,205,180,179, 98,136,
140,251, 89, 95,108, 62,106,214,  3,144,188,175,224,251, 98,201,131,144, 42,183,
197, 68,  7,140, 61, 53,127, 50,138,102, 93, 72,105,128,159, 33,119,168,246,119,
253,131, 31,127, 54, 96,170,141,252,205, 98, 41,165, 97,214,246, 56, 59,183,122,
224, 78, 31, 29, 90,134,  8,233,226,205, 68,125, 24,183,129,228, 34, 41, 51, 69,
159,152,255, 31,141,244,116,200,247, 78, 68,231,190, 26, 42, 26,  6,212, 40,138,
223,172, 32, 85,111, 48,103,235,202,121, 51,155,146,229,210, 42, 51,241, 57, 69,
175, 12,117, 46, 32,248,229,142, 11,214, 41, 20, 26,193, 72,157,170,235,111,221,
100, 74,218,184,135,169,100,240,220, 16,253,212, 60,196, 12, 73, 13,104,140,127,
182,136,115,136,195,  0, 67, 91, 41,179,159, 25,  2, 20,206, 42,200,131,  4, 32,
 60, 74,133,119, 87,249,100, 93, 54, 16,151,126, 31,139, 35,173,181,112,230, 20,
 64, 47,137, 54,228,180, 93,160, 81,114,195, 96, 27,178, 99,241,214,167,210,  4,
108,221,208,148,141, 57,186,246,189,156,201,100,236,168,219, 44, 46, 55,169,174,
 35,121,173,173, 76,152,101,132, 51,180, 94,134, 16,120,133, 71,136,114,231,150,
 30,240,231,237, 75, 54, 69, 93,198,206, 15, 97, 67, 62, 29, 33,200,116,164,218,
 59,231,236, 66,230,244,118, 98, 28, 47,185, 73,126,201, 24, 38,180, 27,138, 68,
223,128, 23,144,189, 20, 22,191, 38, 57, 67, 65, 93,130,169, 60,181,137,210,160,
 82,145, 85,164, 64,  0, 26,  9, 73, 39,139, 44,102,147, 89,174, 14,174,163,200,
 87, 39,156,198, 49, 79,124,246,186, 23,111,121, 83, 57,248, 36,125,232, 46,157,
159,254,204,138, 64,196, 55, 37,154,185, 71,213,131, 74, 43, 21, 65,163,203,172,
105,122,224,212, 34, 13,148,249, 26,165,  1, 98, 52,176, 23, 77,213,226,214,155,
127,144, 13, 71,246,233, 89,204,216,179,241,100,114, 22,132,172,118, 84,226, 93,
108, 36,140,148, 90, 32, 84, 82, 74, 28, 49,116, 18, 36,248, 39,253,126,104, 83,
189,103,140,242,167, 59,221, 69,166,122,192,124,179,241,171,244, 17, 66,146,255,
242, 27,241, 85,235, 38,189,181, 48,247,163, 87,172,147,145,  9,109,210, 54,212,
179, 42, 90,222,212,130, 69, 65,165,152,203,172,120, 18, 95,199, 93, 17, 97, 85,
217,213,101,138,119, 12, 87,162, 24,112, 24, 68,107, 79,106,123,  8, 13,  9,203,
214, 11,173,201, 26,233, 86,200,214, 18,150,120,140,  0, 38, 46,119, 55, 59,216,
 62, 70, 88,147, 92, 40,123,153, 59,146,233,117,  1,169,138,126, 80,  4,204,217,
 52, 25,  7,102,146, 43,104,223,204, 19,169,154, 86,214,198,
} ;

// ../Source/builder/template/GB_bld_template.c:
uint8_t GB_JITpackage_114 [1397] = {
 40,181, 47,253, 96,110, 19, 93, 43,  0,134, 57,165, 39,192, 24,113, 14, 68, 89,
183,226, 78,147,116,202, 14,149,237, 72,203, 60, 23, 34, 18,138, 50, 49,122,224,
242,136,193,  7,112, 15,174,171, 40,152,138,  2, 16,158,  0,150,  0,152,  0,204,
155,225,169, 36, 83,158,156,160, 42, 96,168,113,234, 69,104,202,190, 92,197, 21,
235,169,113,255,148,183,159, 23,163, 44,  6, 25,  4,140, 98,151,211, 54,111,152,
186,159,237,168,143,131, 81,142,122,109,  7,227, 49,161,145,121,106, 50,149,117,
227,220,152,200,110, 28,194,205, 39,  5,  4,  3,  4, 12,195,129,  1,194,165, 43,
250,196,107,226, 38,158,217, 60,132,181,204,150,250,228,217,116, 34, 48,205, 77,
139,  6,229,233, 52,143,246,110, 30, 11,107, 95,219, 93, 11,181,237, 61, 20,221,
 21, 90,153, 50,187,191,232, 62, 73, 32, 79,244,224,110,150,  6, 68,189,225,202,
104, 59,168,101,218,213,131, 86, 21, 97,241,130,  2, 11,166,160, 32,178,227,106,
111,217, 84,237,205,219,136,140,143,254,217,232,213,197,103, 95, 84,201,224, 26,
205, 99,116, 15,  5,181,145,224,116, 52, 56, 38,170, 12,140,143,190,248,217,128,
255,183, 88, 82, 32,236, 13, 58, 19,214,235,114,239,129,200, 42,223,123, 67,214,
159,194, 23, 29,246,150,145,250, 51,157, 14,  7, 70,117,241, 52,238, 71,223, 68,
135,195, 17, 81,101,120, 56,147,178,187,166,172,248, 51,146, 23, 19,101,188,228,
 85,172, 87,175,147,  2,101,166, 83, 77,115,103,141,122, 45,118,242,222,164,229,
174,109,150, 81,196,105,218,220,215, 43, 46,127, 98,189,118,182,203, 88, 77,142,
181,180, 62,229,231,154,185, 76, 66, 81, 88, 40, 67,181, 88, 86,164,158,250, 19,
136,138,254,161,145, 33, 81, 77,116, 34, 60,151, 84, 11,117, 71, 33, 32,234, 15,
 63,184,252, 47,170,195, 67,222, 54,200,245, 90,200,149,230, 61, 93,115,191,171,
132,133,148,203,229, 15, 14, 55,184, 38,186,182, 93,115,164,112,123,138, 93,124,
 41, 70,140,117,149,109, 17, 42,132,110, 58,237, 90, 38,239, 50, 17, 55,181,  0,
135,191,237,119,148,168,167,154,182, 36, 12,122, 83,254,233,106,242,154,226,126,
234,107,155,205, 81, 94,178,255, 84,163,228, 79, 11,129,225,252,105, 71,  7, 53,
142,110,118,232, 57,157,208,157, 29, 54,117, 84,214,169,125, 56, 32,234,  1, 91,
192,229,242,148, 93,179,187, 62,105, 46, 18,229,217,224, 84, 92, 69,229, 82,244,
  8,224,154, 75,  2,  2,103,232, 76, 14, 50, 82, 84,182, 54, 22,137,251, 54,120,
197,237,205,186,236,107, 91,116,137,163,  6,105,140, 27,114, 89,239, 79, 36,132,
242,243,118, 88,239,238, 82, 36,209, 47, 54, 50, 58,170, 11,106,131,194,227,217,
184, 79, 88, 99,152, 33,116,143,238, 98, 41, 84,105,  0,190,156,117,189, 36, 78,
167,213, 42, 18, 79,228, 86,178,113,123,243,220,207, 53, 71,137, 93,133,178,208,
126,246,201, 12,244, 84,173, 75,134,238,153, 41,219, 77,213,228, 21,235,187, 53,
249,211, 44,219,248,140,245,158,124,178,178, 79,  1,129, 51,168,177,161, 67, 51,
 50, 51,146,164, 32, 41, 12,107, 65, 12, 98, 16,163,212, 89,234,  1,130,120, 68,
 13,113, 36,195, 64,  9, 33,132, 33, 98, 68, 68, 68, 36, 16,  9, 18, 36, 37, 45,
213, 26, 49,230,167, 72, 78,196,168, 35,  2,245, 35, 80, 83,187, 95,189, 14,143,
135, 26,153,203, 83,192,  1,140, 21,255, 45,210,230,115,139,146,173, 54, 56, 44,
 60, 30,227,220,181,105, 24,153, 97,209,249, 67,227,255,168,239,183,112, 81,240,
 64, 11,203,180,195,157,160, 59, 90,112, 45,104,  8,126,161, 12,194,108,223,144,
246,188,137,203, 35,104,164,236,229,172,143,  9,137,133,151, 62, 49,111, 16,104,
  1,114, 63,107,107,153, 76,212, 37,222,205,201,196,154, 71,180,114,149,116, 12,
 29,251, 36,  9,  7, 23,191,203, 67,193,145, 83, 26,229,  9,191, 66, 36, 74,106,
143,121,193,253, 79, 88, 46, 10,125,122,167,232, 11,140,162,243,164, 39, 46,188,
 41,  6,130,164,  2,227,143, 52, 27,209, 78, 34,172,142,184,140, 12, 78,198,146,
129,111,207,177, 71,  9, 78, 25, 54, 86,189,185,116,147,216,178,123,  8, 82,201,
125,105, 40,114,160,216, 38,103,164, 38, 21, 26,229, 64,131, 57,136,228,129,208,
240,146,162, 31, 90,176,218,152, 69,131,223,152,169,177,142,114,168, 45,118, 15,
208,191, 71, 13,218, 46,168,  6,178, 84, 28,  7,181, 97,163, 54,212,198,163,193,
151,169,194,157,201, 96,  7,128,241,149,  6,123,203,  5, 44,123,  2,187,168,165,
233, 98, 26,168,213,208, 13, 88,174,155, 48, 11,228, 84, 44,199, 82,236,235,220,
  0,121,106,177,190,244,180, 98, 98,233,228,128,101,234,106, 92, 37,166,100,184,
 38, 93,214, 34,225,119,236, 44,175,181,132,218,211,152,156,184,224,235, 73, 80,
106,128,248,  4,120, 62, 92,200,168, 11, 57, 80,166,108, 84,110, 23,172, 35, 37,
 88,135,109,  1,194, 27,154,253,175, 93, 33,213, 74, 82, 80, 10, 51,130,249, 66,
 81,110,130, 66,113, 13,218, 75,131, 92,129,  3,240,123,128, 58,181, 52, 79,146,
171,176, 75, 21,  7,130,  0, 21, 65, 53,174,252,223,180,192,145, 93, 39, 19, 13,
 29, 13,106,131,180,  6, 89,198, 64, 49, 28,190,235,240,202, 71,144,231,190,167,
210,204,  5,186, 75,204,210,158,162,226, 62,158,180, 97,131,167,163, 94, 66,233,
 54,117,166,202,131, 62,119, 91,190,137, 98,154,215,215, 23,244, 70,167, 28,  6,
 45, 60,149,132,243, 37,  5,245,123,  0,200,236, 78, 98,242, 85, 14,188,199, 69,
100,136, 10,  4, 86,251,233, 31,204,101, 57,109, 66,182,146,246,227,222, 34, 77,
168,143, 66,118,200,203,111,136,208, 10,181, 52,237,114,192, 78,106, 95,197,237,
 57,222, 70, 73,250,127, 17, 78, 37, 97, 24,158,215, 41,  2, 68,126,165,244,107,
 40, 49, 80,122,203,253, 52, 65,163,252,212,216,147,178,224, 70,111,135,193, 55,
155,208, 83,219,228,112,207, 77, 16, 77, 60, 20, 50, 89,155,231,194,157,130,199,
189,152, 27, 17, 66,214, 69, 59,148,161,106,143, 16, 41, 80,101,127,231,202,231,
139,121,153, 77, 78,233,165, 48,162,211, 25,109,175,200,103,224,146,150, 16,186,
 78,  9,134,146, 67, 10,218, 36,154,244, 26,139,253,  4,226,109,127,140,220,103,
211,140, 84,102, 50, 55,229,219, 53,224,240,160,237,151,210,  0, 60,
} ;

// ../Source/builtin/include/GB_Matrix_content.h:
uint8_t GB_JITpackage_115 [7649] = {
 40,181, 47,253, 96,228,114,189,238,  0,202,152,  0, 27, 44,176,144, 81, 55,170,
116,206, 74, 11,187,253, 62, 83,221, 41,105, 20,166, 32,198, 16,118, 96,119, 98,
225,220,225, 56, 37,132,112, 61, 81, 80, 57,132,127, 74,127, 26,245, 31,227,149,
  1,159,  1,171,  1,141,101,145,187, 35, 34, 69, 95,202, 61, 39,111,149,113,229,
115, 94,185,235,249,209, 25,107,250,186,114,237,167,236,103,146,165,108,185,  8,
133, 82,121,191, 40, 39, 49,153,161,253,184,173,143,188, 14,113,200, 94, 61,122,
204, 86, 19,189,246,163,178, 78,167,238,155,129,  4,132, 76,185, 99, 93,203,109,
176, 58,214,122, 31,235,234, 75, 51, 89,109,125,234, 85,107, 52, 18, 46,149,148,
246, 66,206, 53,140,173, 20,165, 87,198,168,172,162,175,243,103,202,146, 68,204,
 31, 72, 52, 25,171, 78,105,104, 80,136,176,239, 19,223, 78,107,236,189, 64, 42,
 95,143,107, 43, 25,246,163,243, 69, 99, 77,  5,147,105,229, 47,100,137, 13,231,
214, 76,132, 68,239,111,188,129,188, 19,235,222,101,160,148,148,  4,113,131,232,
209, 28,231,237, 32,179, 86,245,205,190,254,172,250,218,154,134, 62, 49,233,106,
 70,201,186, 79,187, 70,151,147, 64,141,114,235,103, 31,178, 46,237,200, 13,221,
 54,149,201,205,214,140,140,214, 95,168,163, 87,253, 86,214,181,162,206, 52,240,
148,209,247, 17,232,151, 65, 23, 61, 64, 67,247,  8, 91, 11, 14,139,125,218,115,
179, 38, 81,198,181, 76, 54,106,130,237,243, 62,216,214,190, 79,187, 95,171,253,
198, 56,210,174, 42,127,219,148, 93,127, 80,114,219,234,136, 84,162,203,164, 45,
199,115, 90,137,182, 87,254, 50, 38,253,177,157,107, 76, 46, 48,152, 16,189,  6,
161,253,189,177, 95, 45,141,111, 44,132,211, 66,  6, 46,149,203,228,128,165,114,
217,199, 57, 11,189,131, 48,131,141,166,221,172, 42, 49,239, 88,136, 99,210,168,
176, 38, 83,  7, 82, 63,229,201,209,213, 51,142,  8,101,200,142,227, 69, 94,136,
202,234,186,  2, 68, 29,108, 37,119, 37, 43,170,177,107,148, 46,163, 57,173, 12,
 33, 83,225, 96, 41,148,200,132, 66,  9,114, 41,147,166,253,158,218,151,203, 48,
 81, 58,152,248,160,103, 84, 38,243, 58, 58, 70,223, 47, 27,182,156, 99,182, 33,
197, 53, 90,108, 57,202,253,209, 41,254,108,107, 38,101,101, 76,165,114, 54,189,
188,114,200, 82,  3,129,184,131,153, 93,242,185,250,205,196, 80, 99, 36,154,232,
150,166,185, 59, 69, 81,150,101, 65,223,117,243,  8,149, 20, 37,137, 72, 42, 21,
 76, 36,218,106, 33,145,125, 87,114,136,185,210,124, 44,144,163, 49,130,  8,  5,
214, 74,245, 29,238,115,  9, 18,249,  8,137, 75,129,141,140, 87,229, 19,209,198,
 88,127,180, 27,245,251,134, 74, 26,  1,177, 54,202,152,211,233, 20,219,184, 46,
 76,190,199,149,  1,218, 44,103,153,196,167,242,175,  9, 11,195, 61,122, 15, 11,
 68, 20, 69, 30, 31, 25,214, 93,195,231,134, 27,101,232,152,127,131, 44, 75, 45,
170, 88,168,168,250,123, 92,103, 59,173, 23,114, 78, 97, 91, 51,  8,182, 34,126,
184, 24,165,141,220,136,216, 70,229,129,  9,152,189,145,116, 86,127, 57,221,137,
 48,201, 99,129,184,156,203, 92,  8,147, 92,150,233, 97,153, 92,166,100,153, 25,
158, 15, 72,114,166,141, 88,  6,165,  5, 22,151, 66, 90,201,159,218,239,236,235,
215, 29,223, 41, 32, 43, 34, 61, 84,238,  3, 45,228,236, 74,213,131,178,194, 13,
183,114,205,222, 39,214,153,202,157, 85, 37,229, 91,245,133, 48,171, 32,103, 26,
250, 99,244, 76,206,106,140,101, 66, 98,244,120,167, 77, 65,174,178, 70,255,118,
254,162, 71, 52,167, 72,176,145,164, 29,226,  1, 89, 32, 42,185, 27, 83,202,211,
  6, 27,196, 43, 68, 89,154, 67, 78, 81, 76, 77,150,230,115,218,120,253,180, 65,
154, 70,108,223,119,218,166,109,109,176, 40,251, 59,131, 12,178,114,243, 23,150,
 73,221,202,182, 38, 50,125,120,232,247, 95,  4, 81, 54,181,145,221,210,140, 43,
191,111,186, 57, 13,151, 44, 70, 95,233,163,124,110, 10,161, 83,167,240,104,210,
 38,  2,  5,174, 20,136, 87,214, 60,238,236, 69, 70,  5,  4,  9, 24,216,  9, 84,
  4,158, 77, 59, 76, 43, 75,119, 94, 85,189,253, 25,187,222, 26,190,190, 40, 99,
 83, 62, 60,236,228, 20, 38, 67, 52, 78,229,123,108,239,207,176,118,209, 57, 38,
 66, 96, 22,226, 52,109,219,160,127,156, 84, 45,222, 33,139,165,112,155,182, 80,
136,179, 43, 25,104,106,241,225, 28,109, 20,122, 54, 72,115, 40, 66,216,201,186,
216,227,239,166,168,196,178,232, 32,220, 84,166,113, 83,207,  4,103, 59, 52, 12,
 82, 88, 83,222,224,219,116,180, 30,194, 13,190,163, 82,254,215,191, 30,101,171,
130,253, 21,130, 28,165,158,217,246,220,145, 37, 53, 54,214,240,  2,147,180, 90,
104,  9,236, 67,242, 73,108, 31, 30, 44,236, 70,242, 87,214,139,107,148,155,215,
181,114,235,229,243,215, 40,162,198, 63,242, 55,156,217,139,141,137,208,116, 66,
 18,185, 28, 64, 80,145,136, 40, 64, 49, 16, 97,177, 68, 21, 11, 69, 67,101,228,
242, 81, 40,210,207, 90,173,237,152, 61, 88,136,242,132,141, 62, 50,237, 88,  8,
 22,144,  4,105,213,198, 22, 67,242,174,180, 96, 31,119,253,232, 53,210,225,226,
166, 84,236,166,156, 98,125,195,  3,  1,145, 96,167, 71,134,233, 60, 31, 20, 87,
117,140,196,218,165,105, 59,241,241,240,224,110,129,152, 24, 73, 54,177, 20,145,
177,172, 93,124,146,172, 98, 38,171,171, 93,148, 80,221, 57,156,218,131,113,182,
 58,111, 50,254,154,122,166,161,233, 70,143,104, 13,203,  8, 10, 66,223,120,  4,
 70,185,218, 72,140,198,188, 58, 18, 42, 13,194, 86,191,237, 91,190,141,158,173,
 22,115,125,196,172,106,106, 31,203,  4,250,112, 46, 13, 48, 56, 38, 12,167,210,
  8,240, 38, 17, 18, 29, 17, 50,190,227, 78, 96, 30,200,110, 82, 55, 88,246,207,
206,194,229, 23, 37,125, 48,231,171,215,200, 88,145, 72,229, 47,118,  0,200, 39,
182,179,232,207, 51,119,  1, 64,115,215,186,172, 11,178, 38,  7,227,154, 23, 52,
 39,103,  2,101,161,158,  9, 85, 60,210, 62,206, 51, 29,134, 38,228,147,147, 17,
160, 93,181,146, 38,193, 19, 49, 61,  5,250, 97,  3,120, 46, 30,115,165,  5,  2,
118,250,135,243,220,149,100,166, 57,177, 21, 40,242,136, 34,233,145, 46, 58, 18,
230,159,201, 84,253, 42, 15, 64, 33,204,228,139,221,148, 67,150, 38,147,180,186,
 79,100,102,129,  9, 75,203,127,195, 71,185, 47,102, 42,101,117, 76,231, 70,137,
 65,239,109,121,111, 48,151,113,200, 24,231, 36, 99,194,180, 22,159, 93,200,247,
141,154,202, 62,160, 11,  6,163,105,238, 20,101, 89,219,244,205, 76,137,166,213,
118, 57,166,120,110, 84, 98,141,237,255,204, 54,194,124,148, 15, 15, 27,243, 59,
228,104, 45,230,161,202,101,140,184,123,104, 62, 51,124,212,218, 79,153, 89, 36,
114, 75,  6, 14, 88, 42,165,178,132, 85,204, 52,253, 50, 62,151,165, 56, 18,  5,
148,202,239,121,250, 99,191, 12,197,190,171,223, 85,210, 28, 18, 22, 10,133,229,
162,228,162, 77,251, 80, 15, 59, 48,163,  6, 48, 29, 25, 28, 27,211,  4,142,140,
132, 14, 10,190,153, 12,  8,218, 42, 40,206,101,205, 36, 44,170,112, 17,129,  3,
 51, 89,208,152,222, 57,149, 15,109, 20, 59, 42, 29,150, 29, 27, 85, 98,182, 95,
161,184,180,233,157,243,235,202, 77, 29,132, 83, 66,198,  1, 37,161,102,185,122,
116,202,219,161, 65, 97,106,112,193, 32,179,113, 49,  1,131,241, 94, 97,198, 85,
191,191,118,192,  0,  5,189,177,  4,137, 36, 94,203,129,195, 90, 42, 89,171,211,
140,118,173, 12,247, 47, 24, 99,247,166, 54,181,177,220, 67, 73, 39, 42,182,167,
178, 10,156,203,181,229, 26,202, 90,173,237,109, 15, 93, 14,227,211,238,202,213,
161, 59,174, 36,180,254,103,191,118, 12, 39, 99,248,235,231,  8, 81,134,153,166,
233, 19,138, 96,168,  4,245,106, 36, 37,115,108,102,  0,  0, 80,  4,  5,179, 80,
 16, 16, 14,142,206, 38,227, 57,101, 88, 62, 84,132,101, 16,197, 77, 77,193,129,
 16,217, 33, 28,199, 25,  3,148, 49,128,  0,152,  0, 32,128,  1,  0,129,  0,234,
  0,114,169,120,179,237, 89, 70,194, 58, 11, 79, 75,248,174, 30,248,117, 64,195,
 99,  2, 60,182, 73, 61,104,245,172,105, 12, 14, 63,152, 97, 22, 26,192,218, 83,
 47,189, 48, 75,173,162, 91,  5,  3,240,136,  7,157,107,122,153, 59,181, 27,  4,
 37,144,182,224,158, 30, 61,145,  9,172,242, 83, 95,107,117,176,183, 27,136,243,
172,  9,235,251,165,137,104,114,185,159, 23,234, 93, 87,188, 70,104, 57, 36,188,
 85, 73,212,118, 98,184,128,218,241,222, 50,204,150,133, 64,205,233, 43,107, 89,
245,218, 48,196, 89, 51,136, 40, 97, 65, 76,215, 27,161, 22,221,224, 48,216,226,
 19, 76, 16,  1,  2,253,246,233, 93,143,149,190,249,231, 19, 78,139,209, 24,219,
 90,204,194,155, 17,202, 46,191,174,198,230,199, 39, 88,237, 61, 52,221, 51,250,
148, 93,103,150, 90,163,103,230,241,183,215, 41,207, 75,254, 15,234,191,199, 31,
114,135,150, 54,210,196, 51,114,149, 62,189, 22,190,167,128,248,248, 37,171,226,
160, 70,164,116,  0,128, 35, 29,164, 40, 27,219,202,253,229,194,  8,243, 60,178,
100, 28,101, 44,177, 42, 84,149,240,150,243, 52, 99, 17, 50,208, 67, 81,222,149,
204,119, 90,205, 52,165, 35,157,171,164,120, 84, 12,110,253,232,148,123,232,110,
 82, 36,246, 40, 91,232,231,  2, 49,180, 45, 96, 99, 58,241, 87, 30, 79,150,106,
 18,102, 68,146,197, 54, 95,192,172,134,153,233,125,200,219,  3,117, 18, 31,205,
200, 38,204,216,242, 42,189,219,119, 46, 88,240,184, 77,  0, 17, 67, 74, 39,108,
143,166,136, 31, 29,247,105,130,223, 69, 51,  5,125, 97, 63,248,125,201,100, 29,
208,209,211,249,194, 53, 33,136, 33, 44,145,133,249,202, 75,  3,226,189,179, 82,
247,154, 58,240,134,192, 18, 17, 35,232,231,197, 38,114,  5, 38, 19, 87,218,131,
213,137, 45,199, 97, 18,142,176,202,253, 35,233,191,  9,148, 48, 68,109,194, 76,
 21,240,218, 67, 14, 82,239,113,229,123,184,166, 87,161,133, 31,189,224,243, 74,
158, 10,105, 26,145,233,219,201,213,147, 82, 72,208,125,214, 61,202,125,185,  7,
250,255,120,142, 65,190, 68,191,104, 75, 49, 98, 20, 47,151, 78,177, 29, 50,160,
 19, 82,124,245,169,189,252,247, 20,198, 88,190,178,163, 19,236, 26, 73,124,220,
214,228,111, 83,171,195,254,110, 56, 52, 11,243,220,  6,220,154, 22,195,129, 23,
163, 13,173, 82, 54,137, 69,  3, 34, 67, 66,156,  2,218, 91,184,229,168, 16,143,
 85, 87, 52, 51,116,192, 97, 85, 79,178,213,104, 58, 15,171,135, 92,170,213, 37,
 23,137,151,110, 40,192,131,215,232, 98,191,152, 96,171, 74, 87,157, 39, 93,170,
 20,155, 46, 28,165,230,254,139, 32,236,112, 47,145,245, 31, 43, 24,202,101, 92,
 60,149,253,204,213,197, 40,181,111,144, 71,177,223, 34,138, 17,175,143,237,207,
 45, 32,137,133,  2, 17,238,225, 33,118, 52,138,220,131,107, 86, 11,104,145, 60,
227,253,205,145, 13, 22,115,223,212, 29,204,104, 38,219, 22,105, 53,204, 42,186,
 24, 21,206,200, 37,161,239,217,105,170, 18,254,199,252,106,129,255, 63,209,167,
171, 39, 60,  7,194, 97,230,218, 40, 43,187, 43,193,217, 93,154, 87,202, 14,115,
 59,106,  1,212, 89, 88,132,131, 10,164,183,189,170,  5,181,175,220,120, 54, 60,
 89,163, 91,252, 44, 74, 44,174,  4,199,173, 62, 61, 62, 84, 54,126, 54,196,164,
143,118, 33,142,121,131, 30,179, 16,145, 65, 63,183,150,140,198,253,249,214, 35,
 58,  2, 36,153,102,215,103,152,231, 71, 51,129,220,163,131,199, 76,202,240,122,
 16,119,154,247, 90,130,  0,116,185, 60, 12,157,202,  1,233, 94,159, 63,126,235,
 40,231,128,166,126,183,239,224,  1,114, 78,158, 18,199,228, 70, 67, 13,217,144,
137, 12,251, 72, 85,118,224, 12,140,238, 51, 67, 69, 14,236, 17, 24, 91, 79,164,
 40, 98,  7,213, 60, 72,  6,236, 74,251,215,218,167, 29,182, 43, 59, 18,189, 29,
 26,223,238,214,142, 37,191,117, 12,  8, 42,170,  5, 47, 79, 38,  2, 90, 16,174,
  1, 83,173,245,222,131, 55,196,113, 74,219, 41,192,158,  8,205, 65,187,221,229,
 57,204, 39,146, 32,244,  2, 65,150, 72, 80, 37, 12,198,234,178,225,215,111,186,
 17, 70,209,228, 20,134,129,219,168, 13,195,159,112,163,158,194, 73,116,107,238,
136,161, 55, 99, 34, 59, 32,217,186, 41,219, 42, 67, 95,152, 12, 96, 84,  9,220,
 85,154, 26,165, 42,  5,212, 17, 67,130,231, 11,183,186, 10,227,169,166,202,226,
 97,204, 80,194,139,234,  7,199, 58,139,107,233,147,210,209,244,121, 58, 17,109,
 20,108, 91,156, 84, 11,  6, 57,196,237,161,215,175,220,149,  6,119,252,246,109,
 80, 43,216,129,  5, 42, 28,168,175,  1, 92,127,157, 43, 68,172,134, 11,194,249,
 39, 90,  5, 71,167,181,153, 85,191,209,210,138,218,  8,180,106, 55,214, 88,  5,
141, 26,134,122, 85,157,201,168, 82,254,152, 10, 94,174,224,161,111, 90, 51,203,
150,195,198, 42,136,168, 45,238, 65,249, 21, 19,121, 53,219, 31, 63, 75,  3,106,
 95,210,165,136, 60, 50,149,223,206,254,126, 49,222,164,144, 78,127,  5,120,203,
 70,100, 93, 44, 43, 68,178,161, 89,209,199, 60,134,199, 62,137, 37,254,133, 82,
 37,139,121,182, 53,235, 29, 65,108,240, 85, 23,133, 92,158,126, 88,128,143,  6,
153,183, 30,161,147, 47,146, 78,  8,119,163, 92,255,148,138,  2, 54,194,119,149,
 82, 97,231,241,177,217, 65,199,207, 85,187, 80,112, 65, 75,196, 42,119,147,152,
100, 90,116, 69, 22, 95,156, 56, 83, 92, 10, 41, 85,222, 11, 53, 29,142,176, 76,
  3,171,169,215, 37,  7, 83, 85, 15, 76, 87, 96,255,212,217,219,238, 76,207, 22,
 72, 72,136,  6,170,178, 20, 75, 28, 74,249,231, 80,235,134, 30,149, 38,239,141,
 70,217, 67,179, 40, 92, 25,140,125,169, 28,198, 56, 65,184,106, 37, 26,120,210,
 45,140,171,213,199,201,224, 80,185, 58,129, 48,161,246, 17,101, 79,244, 93,255,
200, 12,  6,211,224, 70, 74, 82, 37, 78, 50,198,145, 88,158, 13, 10, 15,  5, 58,
 81, 87,227, 53,126, 74,239,173, 98, 96,131,198, 11,  9,255, 81,153,131,226, 80,
168,240, 56, 89,254, 73,172,135, 62, 44, 79,243, 98,193,198,137, 28, 69,159,  8,
 76,132, 80,242,102, 29,121, 30,242,229, 72,177,106,115,196, 50,210,119,  0,165,
240,140, 92, 11,  9,145,152,193, 78, 47,222,103,136, 52, 63, 86,113, 74,  5, 13,
190,122,174, 17,157, 35, 35, 52,237, 30,  0, 14,190, 31, 83,  9,185,105,235, 60,
130,145,218,134,202,199,136,141,117,101, 30, 80,  4, 28, 43, 31,195,189,107,118,
